'use strict';

var inherits = require('inherits');

var is = require('../../../util/ModelUtil').is;

var CommandInterceptor = require('diagram-js/lib/command/CommandInterceptor');


function AutoExpandParentBehavior(eventBus, elementFactory) {

  CommandInterceptor.call(this, eventBus);

  // assign correct shape position unless already set

  this.postExecute('shape.create', function(context) {

    var source = context.source,
        shape = context.shape;

    if (!context.position) {

      if (is(shape, 'bpmn:TextAnnotation')) {
        context.position = {
          x: source.x + source.width / 2 + 75,
          y: source.y - (50) - shape.height / 2
        };
      } else {
        context.position = {
          x: source.x + source.width + 80 + shape.width / 2,
          y: source.y + source.height / 2
        };
      }
    }
  }, true);
}


AutoExpandParentBehavior.$inject = [ 'eventBus', 'elementFactory', 'bpmnRules' ];

inherits(AutoExpandParentBehavior, CommandInterceptor);

module.exports = AutoExpandParentBehavior;