import {
  create as svgCreate
} from 'tiny-svg';

export const DATA_OBJECT_REFERENCE_OUTLINE_PATH = 'M44.7648 11.3263L36.9892 2.64074C36.0451 1.58628 34.5651 0.988708 33.1904 0.988708H5.98667C3.22688 0.988708 0.989624 3.34892 0.989624 6.26039V55.0235C0.989624 57.9349 3.22688 60.2952 5.98667 60.2952H40.966C43.7257 60.2952 45.963 57.9349 45.963 55.0235V14.9459C45.963 13.5998 45.6407 12.3048 44.7648 11.3263Z';
export const DATA_STORE_REFERENCE_OUTLINE_PATH = 'M1.03845 48.1347C1.03845 49.3511 1.07295 50.758 1.38342 52.064C1.69949 53.3938 2.32428 54.7154 3.56383 55.6428C6.02533 57.4841 10.1161 58.7685 14.8212 59.6067C19.5772 60.4538 25.1388 60.8738 30.6831 60.8738C36.2276 60.8738 41.7891 60.4538 46.545 59.6067C51.2504 58.7687 55.3412 57.4842 57.8028 55.6429C59.0424 54.7156 59.6673 53.3938 59.9834 52.064C60.2938 50.7579 60.3285 49.351 60.3285 48.1344V13.8415C60.3285 12.6249 60.2938 11.218 59.9834 9.91171C59.6673 8.58194 59.0423 7.2602 57.8027 6.33294C55.341 4.49168 51.2503 3.20723 46.545 2.36914C41.7891 1.522 36.2276 1.10204 30.6831 1.10205C25.1388 1.10206 19.5772 1.52206 14.8213 2.36923C10.1162 3.20734 6.02543 4.49183 3.5639 6.33314C2.32433 7.26038 1.69951 8.58206 1.38343 9.91181C1.07295 11.2179 1.03845 12.6247 1.03845 13.8411V48.1347Z';

/**
 * @type {Dimensions}
 */
export const DATA_OBJECT_REFERENCE_STANDARD_SIZE = { width: 36, height: 50 };

/**
 * @type {Dimensions}
 */
export const DATA_STORE_REFERENCE_STANDARD_SIZE = { width: 50, height: 50 };

/**
 * Create a path element with given attributes.
 * @param {string} path
 * @param {Object} attrs
 * @param {Object} OUTLINE_STYLE
 * @return {SVGElement}
 */
export function createPath(path, attrs, OUTLINE_STYLE) {
  return svgCreate('path', {
    d: path,
    strokeWidth: 2,
    transform: `translate(${attrs.x}, ${attrs.y})`,
    ...OUTLINE_STYLE
  });
}