'use strict';

/**
 * @name BraintreeError.American Express - getRewardsBalance Error Codes
 * @description Errors that occur when creating components.
 * @property {MERCHANT} AMEX_NONCE_REQUIRED Occurs when a nonce is not provided to method.
 * @property {NETWORK} AMEX_NETWORK_ERROR Occurs when there is an error communicating with the Braintree gateway.
 */

/**
 * @name BraintreeError.American Express - getExpressCheckoutProfile Error Codes
 * @description Errors that occur when creating components.
 * @property {MERCHANT} AMEX_NONCE_REQUIRED Occurs when a nonce is not provided to method.
 * @property {NETWORK} AMEX_NETWORK_ERROR Occurs when there is an error communicating with the Braintree gateway.
 */

var BraintreeError = require('../lib/braintree-error');

module.exports = {
  AMEX_NONCE_REQUIRED: {
    type: BraintreeError.types.MERCHANT,
    code: 'AMEX_NONCE_REQUIRED'
  },
  AMEX_NETWORK_ERROR: {
    type: BraintreeError.types.NETWORK,
    code: 'AMEX_NETWORK_ERROR'
  }
};
