import type { CSSProperties, Component, FunctionalComponent, VNode } from 'vue'
import type { EdgeComponent, EdgeEventsOn, EdgeMarkerType, EdgeTextProps, GraphNode } from '../../types'
import type { ConnectionMode } from '../../types'
interface Props {
  id: string
  type: EdgeComponent | Function | Object | false
  name: string
  source: string
  target: string
  sourceNode?: GraphNode
  targetNode?: GraphNode
  targetHandleId?: string | null
  sourceHandleId?: string | null
  selectable?: boolean
  updatable?: boolean
  label?: string | VNode | Component<EdgeTextProps> | Object
  data?: any
  events: EdgeEventsOn
  labelStyle?: CSSProperties
  labelShowBg?: boolean
  labelBgStyle?: any
  labelBgPadding?: [number, number]
  labelBgBorderRadius?: number
  animated?: boolean
  selected?: boolean
  style: CSSProperties
  markerEnd?: EdgeMarkerType
  markerStart?: EdgeMarkerType
  connectionMode: ConnectionMode
  edgeUpdaterRadius: number
}
declare const Wrapper: FunctionalComponent<Props>
export default Wrapper
