import type { Position } from '../../../types'
export interface GetBezierPathParams {
  sourceX: number
  sourceY: number
  sourcePosition?: Position
  targetX: number
  targetY: number
  targetPosition?: Position
  curvature?: number
  centerX?: number
  centerY?: number
}
export declare function getBezierPath({
  sourceX,
  sourceY,
  sourcePosition,
  targetX,
  targetY,
  targetPosition,
  curvature,
}: GetBezierPathParams): string
export declare function getBezierCenter({
  sourceX,
  sourceY,
  sourcePosition,
  targetX,
  targetY,
  targetPosition,
  curvature,
}: GetBezierPathParams): [number, number, number, number]
