import type { D3DragEvent, SubjectPosition } from 'd3-drag'
import type { Ref } from 'vue'
import type { MaybeRef } from '@vueuse/core'
import type { NodeDragEvent } from '../types'
export declare type UseDragEvent = D3DragEvent<HTMLDivElement, null, SubjectPosition>
interface UseDragParams {
  onStart: (event: NodeDragEvent['event'], currentNode: NodeDragEvent['node'], nodes: NodeDragEvent['nodes']) => void
  onDrag: (event: NodeDragEvent['event'], currentNode: NodeDragEvent['node'], nodes: NodeDragEvent['nodes']) => void
  onStop: (event: NodeDragEvent['event'], currentNode: NodeDragEvent['node'], nodes: NodeDragEvent['nodes']) => void
  el: Ref<Element>
  disabled?: MaybeRef<boolean>
  id?: string
}
declare function useDrag(params: UseDragParams): Ref<boolean> | undefined
export default useDrag
