import type { D3ZoomEvent } from 'd3-zoom'
import type { FlowElements, FlowProps } from '../../types/flow'
import type {
  Connection,
  EdgeChange,
  EdgeMouseEvent,
  EdgeUpdateEvent,
  GraphEdge,
  GraphNode,
  NodeChange,
  NodeDragEvent,
  NodeMouseEvent,
  OnConnectStartParams,
  ViewpaneTransform,
  VueFlowStore,
} from '../../types'
declare const _default: {
  new (...args: any[]): {
    $: import('vue').ComponentInternalInstance
    $data: {}
    $props: Partial<{
      connectionLineStyle: import('vue').CSSProperties | null
      snapToGrid: boolean
      onlyRenderVisibleElements: boolean
      edgesUpdatable: boolean
      nodesDraggable: boolean
      nodesConnectable: boolean
      elementsSelectable: boolean
      selectNodesOnDrag: boolean
      panOnDrag: boolean
      zoomOnScroll: boolean
      zoomOnPinch: boolean
      panOnScroll: boolean
      zoomOnDoubleClick: boolean
      preventScrolling: boolean
      fitViewOnInit: boolean
      connectOnClick: boolean
      applyDefault: boolean
      autoConnect: boolean | import('../../types').Connector
      elevateEdgesOnSelect: boolean
    }> &
      Omit<
        Readonly<
          import('vue').ExtractPropTypes<
            __VLS_WithDefaults<
              __VLS_TypePropsToRuntimeProps<FlowProps>,
              {
                snapToGrid: undefined
                onlyRenderVisibleElements: undefined
                edgesUpdatable: undefined
                nodesConnectable: undefined
                nodesDraggable: undefined
                elementsSelectable: undefined
                selectNodesOnDrag: undefined
                preventScrolling: undefined
                zoomOnScroll: undefined
                zoomOnPinch: undefined
                zoomOnDoubleClick: undefined
                panOnScroll: undefined
                panOnDrag: undefined
                applyDefault: undefined
                fitViewOnInit: undefined
                connectOnClick: undefined
                connectionLineStyle: undefined
                autoConnect: undefined
                elevateEdgesOnSelect: undefined
              }
            >
          >
        > & {
          'onNodesChange'?: ((changes: NodeChange[]) => any) | undefined
          'onEdgesChange'?: ((changes: EdgeChange[]) => any) | undefined
          'onNodeDoubleClick'?: ((nodeMouseEvent: NodeMouseEvent) => any) | undefined
          'onNodeClick'?: ((nodeMouseEvent: NodeMouseEvent) => any) | undefined
          'onNodeMouseEnter'?: ((nodeMouseEvent: NodeMouseEvent) => any) | undefined
          'onNodeMouseMove'?: ((nodeMouseEvent: NodeMouseEvent) => any) | undefined
          'onNodeMouseLeave'?: ((nodeMouseEvent: NodeMouseEvent) => any) | undefined
          'onNodeContextMenu'?: ((nodeMouseEvent: NodeMouseEvent) => any) | undefined
          'onNodeDragStart'?: ((nodeDragEvent: NodeDragEvent) => any) | undefined
          'onNodeDrag'?: ((nodeDragEvent: NodeDragEvent) => any) | undefined
          'onNodeDragStop'?: ((nodeDragEvent: NodeDragEvent) => any) | undefined
          'onMiniMapNodeClick'?: ((nodeMouseEvent: NodeMouseEvent) => any) | undefined
          'onMiniMapNodeDoubleClick'?: ((nodeMouseEvent: NodeMouseEvent) => any) | undefined
          'onMiniMapNodeMouseEnter'?: ((nodeMouseEvent: NodeMouseEvent) => any) | undefined
          'onMiniMapNodeMouseMove'?: ((nodeMouseEvent: NodeMouseEvent) => any) | undefined
          'onMiniMapNodeMouseLeave'?: ((nodeMouseEvent: NodeMouseEvent) => any) | undefined
          'onConnect'?: ((connectionEvent: Connection) => any) | undefined
          'onConnectStart'?:
            | ((
                connectionEvent: {
                  event: MouseEvent
                } & OnConnectStartParams,
              ) => any)
            | undefined
          'onConnectStop'?: ((connectionEvent: MouseEvent) => any) | undefined
          'onConnectEnd'?: ((connectionEvent: MouseEvent) => any) | undefined
          'onPaneReady'?: ((paneEvent: VueFlowStore) => any) | undefined
          'onMove'?:
            | ((moveEvent: { event: D3ZoomEvent<HTMLDivElement, any>; flowTransform: ViewpaneTransform }) => any)
            | undefined
          'onMoveStart'?:
            | ((moveEvent: { event: D3ZoomEvent<HTMLDivElement, any>; flowTransform: ViewpaneTransform }) => any)
            | undefined
          'onMoveEnd'?:
            | ((moveEvent: { event: D3ZoomEvent<HTMLDivElement, any>; flowTransform: ViewpaneTransform }) => any)
            | undefined
          'onSelectionDragStart'?: ((selectionEvent: NodeDragEvent) => any) | undefined
          'onSelectionDrag'?: ((selectionEvent: NodeDragEvent) => any) | undefined
          'onSelectionDragStop'?: ((selectionEvent: NodeDragEvent) => any) | undefined
          'onSelectionContextMenu'?: ((selectionEvent: { event: MouseEvent; nodes: GraphNode[] }) => any) | undefined
          'onPaneScroll'?: ((paneEvent: WheelEvent | undefined) => any) | undefined
          'onPaneClick'?: ((paneEvent: MouseEvent) => any) | undefined
          'onPaneContextMenu'?: ((paneEvent: MouseEvent) => any) | undefined
          'onPaneMouseEnter'?: ((paneEvent: MouseEvent) => any) | undefined
          'onPaneMouseMove'?: ((paneEvent: MouseEvent) => any) | undefined
          'onPaneMouseLeave'?: ((paneEvent: MouseEvent) => any) | undefined
          'onEdgeContextMenu'?: ((edgeMouseEvent: EdgeMouseEvent) => any) | undefined
          'onEdgeMouseEnter'?: ((edgeMouseEvent: EdgeMouseEvent) => any) | undefined
          'onEdgeMouseMove'?: ((edgeMouseEvent: EdgeMouseEvent) => any) | undefined
          'onEdgeMouseLeave'?: ((edgeMouseEvent: EdgeMouseEvent) => any) | undefined
          'onEdgeDoubleClick'?: ((edgeMouseEvent: EdgeMouseEvent) => any) | undefined
          'onEdgeClick'?: ((edgeMouseEvent: EdgeMouseEvent) => any) | undefined
          'onEdgeUpdateStart'?: ((edgeMouseEvent: EdgeMouseEvent) => any) | undefined
          'onEdgeUpdate'?: ((edgeUpdateEvent: EdgeUpdateEvent) => any) | undefined
          'onEdgeUpdateEnd'?: ((edgeMouseEvent: EdgeMouseEvent) => any) | undefined
          'onUpdate:modelValue'?: ((value: FlowElements<any>) => any) | undefined
          'onUpdate:nodes'?: ((value: GraphNode<any, any>[]) => any) | undefined
          'onUpdate:edges'?: ((value: GraphEdge<any, any>[]) => any) | undefined
        } & import('vue').VNodeProps &
          import('vue').AllowedComponentProps &
          import('vue').ComponentCustomProps,
        | 'connectionLineStyle'
        | 'snapToGrid'
        | 'onlyRenderVisibleElements'
        | 'edgesUpdatable'
        | 'nodesDraggable'
        | 'nodesConnectable'
        | 'elementsSelectable'
        | 'selectNodesOnDrag'
        | 'panOnDrag'
        | 'zoomOnScroll'
        | 'zoomOnPinch'
        | 'panOnScroll'
        | 'zoomOnDoubleClick'
        | 'preventScrolling'
        | 'fitViewOnInit'
        | 'connectOnClick'
        | 'applyDefault'
        | 'autoConnect'
        | 'elevateEdgesOnSelect'
      >
    $attrs: {
      [x: string]: unknown
    }
    $refs: {
      [x: string]: unknown
    }
    $slots: Readonly<{
      [name: string]: import('vue').Slot | undefined
    }>
    $root:
      | import('vue').ComponentPublicInstance<
          {},
          {},
          {},
          {},
          {},
          {},
          {},
          {},
          false,
          import('vue').ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}>
        >
      | null
    $parent:
      | import('vue').ComponentPublicInstance<
          {},
          {},
          {},
          {},
          {},
          {},
          {},
          {},
          false,
          import('vue').ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}>
        >
      | null
    $emit: ((event: 'nodesChange', changes: NodeChange[]) => void) &
      ((event: 'edgesChange', changes: EdgeChange[]) => void) &
      ((event: 'nodeDoubleClick', nodeMouseEvent: NodeMouseEvent) => void) &
      ((event: 'nodeClick', nodeMouseEvent: NodeMouseEvent) => void) &
      ((event: 'nodeMouseEnter', nodeMouseEvent: NodeMouseEvent) => void) &
      ((event: 'nodeMouseMove', nodeMouseEvent: NodeMouseEvent) => void) &
      ((event: 'nodeMouseLeave', nodeMouseEvent: NodeMouseEvent) => void) &
      ((event: 'nodeContextMenu', nodeMouseEvent: NodeMouseEvent) => void) &
      ((event: 'nodeDragStart', nodeDragEvent: NodeDragEvent) => void) &
      ((event: 'nodeDrag', nodeDragEvent: NodeDragEvent) => void) &
      ((event: 'nodeDragStop', nodeDragEvent: NodeDragEvent) => void) &
      ((event: 'miniMapNodeClick', nodeMouseEvent: NodeMouseEvent) => void) &
      ((event: 'miniMapNodeDoubleClick', nodeMouseEvent: NodeMouseEvent) => void) &
      ((event: 'miniMapNodeMouseEnter', nodeMouseEvent: NodeMouseEvent) => void) &
      ((event: 'miniMapNodeMouseMove', nodeMouseEvent: NodeMouseEvent) => void) &
      ((event: 'miniMapNodeMouseLeave', nodeMouseEvent: NodeMouseEvent) => void) &
      ((event: 'connect', connectionEvent: Connection) => void) &
      ((
        event: 'connectStart',
        connectionEvent: {
          event: MouseEvent
        } & OnConnectStartParams,
      ) => void) &
      ((event: 'connectStop', connectionEvent: MouseEvent) => void) &
      ((event: 'connectEnd', connectionEvent: MouseEvent) => void) &
      ((event: 'paneReady', paneEvent: VueFlowStore) => void) &
      ((
        event: 'move',
        moveEvent: {
          event: D3ZoomEvent<HTMLDivElement, any>
          flowTransform: ViewpaneTransform
        },
      ) => void) &
      ((
        event: 'moveStart',
        moveEvent: {
          event: D3ZoomEvent<HTMLDivElement, any>
          flowTransform: ViewpaneTransform
        },
      ) => void) &
      ((
        event: 'moveEnd',
        moveEvent: {
          event: D3ZoomEvent<HTMLDivElement, any>
          flowTransform: ViewpaneTransform
        },
      ) => void) &
      ((event: 'selectionDragStart', selectionEvent: NodeDragEvent) => void) &
      ((event: 'selectionDrag', selectionEvent: NodeDragEvent) => void) &
      ((event: 'selectionDragStop', selectionEvent: NodeDragEvent) => void) &
      ((
        event: 'selectionContextMenu',
        selectionEvent: {
          event: MouseEvent
          nodes: GraphNode[]
        },
      ) => void) &
      ((event: 'paneScroll', paneEvent: WheelEvent | undefined) => void) &
      ((event: 'paneClick', paneEvent: MouseEvent) => void) &
      ((event: 'paneContextMenu', paneEvent: MouseEvent) => void) &
      ((event: 'paneMouseEnter', paneEvent: MouseEvent) => void) &
      ((event: 'paneMouseMove', paneEvent: MouseEvent) => void) &
      ((event: 'paneMouseLeave', paneEvent: MouseEvent) => void) &
      ((event: 'edgeContextMenu', edgeMouseEvent: EdgeMouseEvent) => void) &
      ((event: 'edgeMouseEnter', edgeMouseEvent: EdgeMouseEvent) => void) &
      ((event: 'edgeMouseMove', edgeMouseEvent: EdgeMouseEvent) => void) &
      ((event: 'edgeMouseLeave', edgeMouseEvent: EdgeMouseEvent) => void) &
      ((event: 'edgeDoubleClick', edgeMouseEvent: EdgeMouseEvent) => void) &
      ((event: 'edgeClick', edgeMouseEvent: EdgeMouseEvent) => void) &
      ((event: 'edgeUpdateStart', edgeMouseEvent: EdgeMouseEvent) => void) &
      ((event: 'edgeUpdate', edgeUpdateEvent: EdgeUpdateEvent) => void) &
      ((event: 'edgeUpdateEnd', edgeMouseEvent: EdgeMouseEvent) => void) &
      ((event: 'update:modelValue', value: FlowElements<any>) => void) &
      ((event: 'update:nodes', value: GraphNode<any, any>[]) => void) &
      ((event: 'update:edges', value: GraphEdge<any, any>[]) => void)
    $el: any
    $options: import('vue').ComponentOptionsBase<
      Readonly<
        import('vue').ExtractPropTypes<
          __VLS_WithDefaults<
            __VLS_TypePropsToRuntimeProps<FlowProps>,
            {
              snapToGrid: undefined
              onlyRenderVisibleElements: undefined
              edgesUpdatable: undefined
              nodesConnectable: undefined
              nodesDraggable: undefined
              elementsSelectable: undefined
              selectNodesOnDrag: undefined
              preventScrolling: undefined
              zoomOnScroll: undefined
              zoomOnPinch: undefined
              zoomOnDoubleClick: undefined
              panOnScroll: undefined
              panOnDrag: undefined
              applyDefault: undefined
              fitViewOnInit: undefined
              connectOnClick: undefined
              connectionLineStyle: undefined
              autoConnect: undefined
              elevateEdgesOnSelect: undefined
            }
          >
        >
      > & {
        'onNodesChange'?: ((changes: NodeChange[]) => any) | undefined
        'onEdgesChange'?: ((changes: EdgeChange[]) => any) | undefined
        'onNodeDoubleClick'?: ((nodeMouseEvent: NodeMouseEvent) => any) | undefined
        'onNodeClick'?: ((nodeMouseEvent: NodeMouseEvent) => any) | undefined
        'onNodeMouseEnter'?: ((nodeMouseEvent: NodeMouseEvent) => any) | undefined
        'onNodeMouseMove'?: ((nodeMouseEvent: NodeMouseEvent) => any) | undefined
        'onNodeMouseLeave'?: ((nodeMouseEvent: NodeMouseEvent) => any) | undefined
        'onNodeContextMenu'?: ((nodeMouseEvent: NodeMouseEvent) => any) | undefined
        'onNodeDragStart'?: ((nodeDragEvent: NodeDragEvent) => any) | undefined
        'onNodeDrag'?: ((nodeDragEvent: NodeDragEvent) => any) | undefined
        'onNodeDragStop'?: ((nodeDragEvent: NodeDragEvent) => any) | undefined
        'onMiniMapNodeClick'?: ((nodeMouseEvent: NodeMouseEvent) => any) | undefined
        'onMiniMapNodeDoubleClick'?: ((nodeMouseEvent: NodeMouseEvent) => any) | undefined
        'onMiniMapNodeMouseEnter'?: ((nodeMouseEvent: NodeMouseEvent) => any) | undefined
        'onMiniMapNodeMouseMove'?: ((nodeMouseEvent: NodeMouseEvent) => any) | undefined
        'onMiniMapNodeMouseLeave'?: ((nodeMouseEvent: NodeMouseEvent) => any) | undefined
        'onConnect'?: ((connectionEvent: Connection) => any) | undefined
        'onConnectStart'?:
          | ((
              connectionEvent: {
                event: MouseEvent
              } & OnConnectStartParams,
            ) => any)
          | undefined
        'onConnectStop'?: ((connectionEvent: MouseEvent) => any) | undefined
        'onConnectEnd'?: ((connectionEvent: MouseEvent) => any) | undefined
        'onPaneReady'?: ((paneEvent: VueFlowStore) => any) | undefined
        'onMove'?: ((moveEvent: { event: D3ZoomEvent<HTMLDivElement, any>; flowTransform: ViewpaneTransform }) => any) | undefined
        'onMoveStart'?:
          | ((moveEvent: { event: D3ZoomEvent<HTMLDivElement, any>; flowTransform: ViewpaneTransform }) => any)
          | undefined
        'onMoveEnd'?:
          | ((moveEvent: { event: D3ZoomEvent<HTMLDivElement, any>; flowTransform: ViewpaneTransform }) => any)
          | undefined
        'onSelectionDragStart'?: ((selectionEvent: NodeDragEvent) => any) | undefined
        'onSelectionDrag'?: ((selectionEvent: NodeDragEvent) => any) | undefined
        'onSelectionDragStop'?: ((selectionEvent: NodeDragEvent) => any) | undefined
        'onSelectionContextMenu'?: ((selectionEvent: { event: MouseEvent; nodes: GraphNode[] }) => any) | undefined
        'onPaneScroll'?: ((paneEvent: WheelEvent | undefined) => any) | undefined
        'onPaneClick'?: ((paneEvent: MouseEvent) => any) | undefined
        'onPaneContextMenu'?: ((paneEvent: MouseEvent) => any) | undefined
        'onPaneMouseEnter'?: ((paneEvent: MouseEvent) => any) | undefined
        'onPaneMouseMove'?: ((paneEvent: MouseEvent) => any) | undefined
        'onPaneMouseLeave'?: ((paneEvent: MouseEvent) => any) | undefined
        'onEdgeContextMenu'?: ((edgeMouseEvent: EdgeMouseEvent) => any) | undefined
        'onEdgeMouseEnter'?: ((edgeMouseEvent: EdgeMouseEvent) => any) | undefined
        'onEdgeMouseMove'?: ((edgeMouseEvent: EdgeMouseEvent) => any) | undefined
        'onEdgeMouseLeave'?: ((edgeMouseEvent: EdgeMouseEvent) => any) | undefined
        'onEdgeDoubleClick'?: ((edgeMouseEvent: EdgeMouseEvent) => any) | undefined
        'onEdgeClick'?: ((edgeMouseEvent: EdgeMouseEvent) => any) | undefined
        'onEdgeUpdateStart'?: ((edgeMouseEvent: EdgeMouseEvent) => any) | undefined
        'onEdgeUpdate'?: ((edgeUpdateEvent: EdgeUpdateEvent) => any) | undefined
        'onEdgeUpdateEnd'?: ((edgeMouseEvent: EdgeMouseEvent) => any) | undefined
        'onUpdate:modelValue'?: ((value: FlowElements<any>) => any) | undefined
        'onUpdate:nodes'?: ((value: GraphNode<any, any>[]) => any) | undefined
        'onUpdate:edges'?: ((value: GraphEdge<any, any>[]) => any) | undefined
      },
      {
        id: string
        emits: Readonly<{
          nodesChange: import('@vueuse/shared').EventHookTrigger<NodeChange[]>
          edgesChange: import('@vueuse/shared').EventHookTrigger<EdgeChange[]>
          nodeDoubleClick: import('@vueuse/shared').EventHookTrigger<NodeMouseEvent>
          nodeClick: import('@vueuse/shared').EventHookTrigger<NodeMouseEvent>
          nodeMouseEnter: import('@vueuse/shared').EventHookTrigger<NodeMouseEvent>
          nodeMouseMove: import('@vueuse/shared').EventHookTrigger<NodeMouseEvent>
          nodeMouseLeave: import('@vueuse/shared').EventHookTrigger<NodeMouseEvent>
          nodeContextMenu: import('@vueuse/shared').EventHookTrigger<NodeMouseEvent>
          nodeDragStart: import('@vueuse/shared').EventHookTrigger<NodeDragEvent>
          nodeDrag: import('@vueuse/shared').EventHookTrigger<NodeDragEvent>
          nodeDragStop: import('@vueuse/shared').EventHookTrigger<NodeDragEvent>
          updateNodeInternals: import('@vueuse/shared').EventHookTrigger<string[]>
          miniMapNodeClick: import('@vueuse/shared').EventHookTrigger<NodeMouseEvent>
          miniMapNodeDoubleClick: import('@vueuse/shared').EventHookTrigger<NodeMouseEvent>
          miniMapNodeMouseEnter: import('@vueuse/shared').EventHookTrigger<NodeMouseEvent>
          miniMapNodeMouseMove: import('@vueuse/shared').EventHookTrigger<NodeMouseEvent>
          miniMapNodeMouseLeave: import('@vueuse/shared').EventHookTrigger<NodeMouseEvent>
          connect: import('@vueuse/shared').EventHookTrigger<Connection>
          connectStart: import('@vueuse/shared').EventHookTrigger<
            {
              event: MouseEvent
            } & OnConnectStartParams
          >
          connectStop: import('@vueuse/shared').EventHookTrigger<MouseEvent>
          connectEnd: import('@vueuse/shared').EventHookTrigger<MouseEvent>
          paneReady: import('@vueuse/shared').EventHookTrigger<VueFlowStore>
          move: import('@vueuse/shared').EventHookTrigger<{
            event: D3ZoomEvent<HTMLDivElement, any>
            flowTransform: ViewpaneTransform
          }>
          moveStart: import('@vueuse/shared').EventHookTrigger<{
            event: D3ZoomEvent<HTMLDivElement, any>
            flowTransform: ViewpaneTransform
          }>
          moveEnd: import('@vueuse/shared').EventHookTrigger<{
            event: D3ZoomEvent<HTMLDivElement, any>
            flowTransform: ViewpaneTransform
          }>
          selectionDragStart: import('@vueuse/shared').EventHookTrigger<NodeDragEvent>
          selectionDrag: import('@vueuse/shared').EventHookTrigger<NodeDragEvent>
          selectionDragStop: import('@vueuse/shared').EventHookTrigger<NodeDragEvent>
          selectionContextMenu: import('@vueuse/shared').EventHookTrigger<{
            event: MouseEvent
            nodes: GraphNode<any, any>[]
          }>
          paneScroll: import('@vueuse/shared').EventHookTrigger<WheelEvent | undefined>
          paneClick: import('@vueuse/shared').EventHookTrigger<MouseEvent>
          paneContextMenu: import('@vueuse/shared').EventHookTrigger<MouseEvent>
          paneMouseEnter: import('@vueuse/shared').EventHookTrigger<MouseEvent>
          paneMouseMove: import('@vueuse/shared').EventHookTrigger<MouseEvent>
          paneMouseLeave: import('@vueuse/shared').EventHookTrigger<MouseEvent>
          edgeContextMenu: import('@vueuse/shared').EventHookTrigger<EdgeMouseEvent>
          edgeMouseEnter: import('@vueuse/shared').EventHookTrigger<EdgeMouseEvent>
          edgeMouseMove: import('@vueuse/shared').EventHookTrigger<EdgeMouseEvent>
          edgeMouseLeave: import('@vueuse/shared').EventHookTrigger<EdgeMouseEvent>
          edgeDoubleClick: import('@vueuse/shared').EventHookTrigger<EdgeMouseEvent>
          edgeClick: import('@vueuse/shared').EventHookTrigger<EdgeMouseEvent>
          edgeUpdateStart: import('@vueuse/shared').EventHookTrigger<EdgeMouseEvent>
          edgeUpdate: import('@vueuse/shared').EventHookTrigger<EdgeUpdateEvent>
          edgeUpdateEnd: import('@vueuse/shared').EventHookTrigger<EdgeMouseEvent>
        }>
        onNodesChange: import('@vueuse/shared').EventHookOn<NodeChange[]>
        onEdgesChange: import('@vueuse/shared').EventHookOn<EdgeChange[]>
        onNodeDoubleClick: import('@vueuse/shared').EventHookOn<NodeMouseEvent>
        onNodeClick: import('@vueuse/shared').EventHookOn<NodeMouseEvent>
        onNodeMouseEnter: import('@vueuse/shared').EventHookOn<NodeMouseEvent>
        onNodeMouseMove: import('@vueuse/shared').EventHookOn<NodeMouseEvent>
        onNodeMouseLeave: import('@vueuse/shared').EventHookOn<NodeMouseEvent>
        onNodeContextMenu: import('@vueuse/shared').EventHookOn<NodeMouseEvent>
        onNodeDragStart: import('@vueuse/shared').EventHookOn<NodeDragEvent>
        onNodeDrag: import('@vueuse/shared').EventHookOn<NodeDragEvent>
        onNodeDragStop: import('@vueuse/shared').EventHookOn<NodeDragEvent>
        onUpdateNodeInternals: import('@vueuse/shared').EventHookOn<string[]>
        onMiniMapNodeClick: import('@vueuse/shared').EventHookOn<NodeMouseEvent>
        onMiniMapNodeDoubleClick: import('@vueuse/shared').EventHookOn<NodeMouseEvent>
        onMiniMapNodeMouseEnter: import('@vueuse/shared').EventHookOn<NodeMouseEvent>
        onMiniMapNodeMouseMove: import('@vueuse/shared').EventHookOn<NodeMouseEvent>
        onMiniMapNodeMouseLeave: import('@vueuse/shared').EventHookOn<NodeMouseEvent>
        onConnect: import('@vueuse/shared').EventHookOn<Connection>
        onConnectStart: import('@vueuse/shared').EventHookOn<
          {
            event: MouseEvent
          } & OnConnectStartParams
        >
        onConnectStop: import('@vueuse/shared').EventHookOn<MouseEvent>
        onConnectEnd: import('@vueuse/shared').EventHookOn<MouseEvent>
        onPaneReady: import('@vueuse/shared').EventHookOn<VueFlowStore>
        onMove: import('@vueuse/shared').EventHookOn<{
          event: D3ZoomEvent<HTMLDivElement, any>
          flowTransform: ViewpaneTransform
        }>
        onMoveStart: import('@vueuse/shared').EventHookOn<{
          event: D3ZoomEvent<HTMLDivElement, any>
          flowTransform: ViewpaneTransform
        }>
        onMoveEnd: import('@vueuse/shared').EventHookOn<{
          event: D3ZoomEvent<HTMLDivElement, any>
          flowTransform: ViewpaneTransform
        }>
        onSelectionDragStart: import('@vueuse/shared').EventHookOn<NodeDragEvent>
        onSelectionDrag: import('@vueuse/shared').EventHookOn<NodeDragEvent>
        onSelectionDragStop: import('@vueuse/shared').EventHookOn<NodeDragEvent>
        onSelectionContextMenu: import('@vueuse/shared').EventHookOn<{
          event: MouseEvent
          nodes: GraphNode<any, any>[]
        }>
        onPaneScroll: import('@vueuse/shared').EventHookOn<WheelEvent | undefined>
        onPaneClick: import('@vueuse/shared').EventHookOn<MouseEvent>
        onPaneContextMenu: import('@vueuse/shared').EventHookOn<MouseEvent>
        onPaneMouseEnter: import('@vueuse/shared').EventHookOn<MouseEvent>
        onPaneMouseMove: import('@vueuse/shared').EventHookOn<MouseEvent>
        onPaneMouseLeave: import('@vueuse/shared').EventHookOn<MouseEvent>
        onEdgeContextMenu: import('@vueuse/shared').EventHookOn<EdgeMouseEvent>
        onEdgeMouseEnter: import('@vueuse/shared').EventHookOn<EdgeMouseEvent>
        onEdgeMouseMove: import('@vueuse/shared').EventHookOn<EdgeMouseEvent>
        onEdgeMouseLeave: import('@vueuse/shared').EventHookOn<EdgeMouseEvent>
        onEdgeDoubleClick: import('@vueuse/shared').EventHookOn<EdgeMouseEvent>
        onEdgeClick: import('@vueuse/shared').EventHookOn<EdgeMouseEvent>
        onEdgeUpdateStart: import('@vueuse/shared').EventHookOn<EdgeMouseEvent>
        onEdgeUpdate: import('@vueuse/shared').EventHookOn<EdgeUpdateEvent>
        onEdgeUpdateEnd: import('@vueuse/shared').EventHookOn<EdgeMouseEvent>
        vueFlowRef: import('vue').Ref<HTMLDivElement | null>
        viewportRef: import('vue').Ref<HTMLDivElement | null>
        hooks: import('vue').Ref<
          Readonly<{
            nodesChange: import('@vueuse/shared').EventHook<NodeChange[]>
            edgesChange: import('@vueuse/shared').EventHook<EdgeChange[]>
            nodeDoubleClick: import('@vueuse/shared').EventHook<NodeMouseEvent>
            nodeClick: import('@vueuse/shared').EventHook<NodeMouseEvent>
            nodeMouseEnter: import('@vueuse/shared').EventHook<NodeMouseEvent>
            nodeMouseMove: import('@vueuse/shared').EventHook<NodeMouseEvent>
            nodeMouseLeave: import('@vueuse/shared').EventHook<NodeMouseEvent>
            nodeContextMenu: import('@vueuse/shared').EventHook<NodeMouseEvent>
            nodeDragStart: import('@vueuse/shared').EventHook<NodeDragEvent>
            nodeDrag: import('@vueuse/shared').EventHook<NodeDragEvent>
            nodeDragStop: import('@vueuse/shared').EventHook<NodeDragEvent>
            updateNodeInternals: import('@vueuse/shared').EventHook<string[]>
            miniMapNodeClick: import('@vueuse/shared').EventHook<NodeMouseEvent>
            miniMapNodeDoubleClick: import('@vueuse/shared').EventHook<NodeMouseEvent>
            miniMapNodeMouseEnter: import('@vueuse/shared').EventHook<NodeMouseEvent>
            miniMapNodeMouseMove: import('@vueuse/shared').EventHook<NodeMouseEvent>
            miniMapNodeMouseLeave: import('@vueuse/shared').EventHook<NodeMouseEvent>
            connect: import('@vueuse/shared').EventHook<Connection>
            connectStart: import('@vueuse/shared').EventHook<
              {
                event: MouseEvent
              } & OnConnectStartParams
            >
            connectStop: import('@vueuse/shared').EventHook<MouseEvent>
            connectEnd: import('@vueuse/shared').EventHook<MouseEvent>
            paneReady: import('@vueuse/shared').EventHook<VueFlowStore>
            move: import('@vueuse/shared').EventHook<{
              event: D3ZoomEvent<HTMLDivElement, any>
              flowTransform: ViewpaneTransform
            }>
            moveStart: import('@vueuse/shared').EventHook<{
              event: D3ZoomEvent<HTMLDivElement, any>
              flowTransform: ViewpaneTransform
            }>
            moveEnd: import('@vueuse/shared').EventHook<{
              event: D3ZoomEvent<HTMLDivElement, any>
              flowTransform: ViewpaneTransform
            }>
            selectionDragStart: import('@vueuse/shared').EventHook<NodeDragEvent>
            selectionDrag: import('@vueuse/shared').EventHook<NodeDragEvent>
            selectionDragStop: import('@vueuse/shared').EventHook<NodeDragEvent>
            selectionContextMenu: import('@vueuse/shared').EventHook<{
              event: MouseEvent
              nodes: GraphNode<any, any>[]
            }>
            paneScroll: import('@vueuse/shared').EventHook<WheelEvent | undefined>
            paneClick: import('@vueuse/shared').EventHook<MouseEvent>
            paneContextMenu: import('@vueuse/shared').EventHook<MouseEvent>
            paneMouseEnter: import('@vueuse/shared').EventHook<MouseEvent>
            paneMouseMove: import('@vueuse/shared').EventHook<MouseEvent>
            paneMouseLeave: import('@vueuse/shared').EventHook<MouseEvent>
            edgeContextMenu: import('@vueuse/shared').EventHook<EdgeMouseEvent>
            edgeMouseEnter: import('@vueuse/shared').EventHook<EdgeMouseEvent>
            edgeMouseMove: import('@vueuse/shared').EventHook<EdgeMouseEvent>
            edgeMouseLeave: import('@vueuse/shared').EventHook<EdgeMouseEvent>
            edgeDoubleClick: import('@vueuse/shared').EventHook<EdgeMouseEvent>
            edgeClick: import('@vueuse/shared').EventHook<EdgeMouseEvent>
            edgeUpdateStart: import('@vueuse/shared').EventHook<EdgeMouseEvent>
            edgeUpdate: import('@vueuse/shared').EventHook<EdgeUpdateEvent>
            edgeUpdateEnd: import('@vueuse/shared').EventHook<EdgeMouseEvent>
          }>
        >
        nodes: import('vue').Ref<GraphNode<any, any>[]>
        edges: import('vue').Ref<GraphEdge<any, any>[]>
        d3Zoom: import('vue').Ref<import('../../types').D3Zoom | null>
        d3Selection: import('vue').Ref<import('../../types').D3Selection | null>
        d3ZoomHandler: import('vue').Ref<import('../../types').D3ZoomHandler | null>
        minZoom: import('vue').Ref<number>
        maxZoom: import('vue').Ref<number>
        defaultZoom: import('vue').Ref<number>
        translateExtent: import('vue').Ref<import('../../types').CoordinateExtent>
        nodeExtent: import('vue').Ref<import('../../types').CoordinateExtent>
        dimensions: import('vue').Ref<import('../../types').Dimensions>
        viewport: import('vue').Ref<import('../../types').Viewport>
        onlyRenderVisibleElements: import('vue').Ref<boolean>
        defaultPosition: import('vue').Ref<[number, number]>
        nodesSelectionActive: import('vue').Ref<boolean>
        userSelectionActive: import('vue').Ref<boolean>
        multiSelectionActive: import('vue').Ref<boolean>
        deleteKeyCode: import('vue').Ref<import('@vueuse/core').KeyFilter>
        selectionKeyCode: import('vue').Ref<import('@vueuse/core').KeyFilter>
        multiSelectionKeyCode: import('vue').Ref<import('@vueuse/core').KeyFilter>
        zoomActivationKeyCode: import('vue').Ref<import('@vueuse/core').KeyFilter>
        connectionNodeId: import('vue').Ref<string | null>
        connectionHandleId: import('vue').Ref<string | null>
        connectionHandleType: import('vue').Ref<import('../../types').HandleType | null>
        connectionPosition: import('vue').Ref<import('../../types').XYPosition>
        connectionMode: import('vue').Ref<import('../../types').ConnectionMode>
        connectionLineOptions: import('vue').Ref<import('../../types').ConnectionLineOptions>
        connectionLineType: import('vue').Ref<import('../../types').ConnectionLineType>
        connectionLineStyle: import('vue').Ref<import('vue').CSSProperties | null>
        connectionStartHandle: import('vue').Ref<import('../../types').StartHandle | null>
        connectOnClick: import('vue').Ref<boolean>
        edgeUpdaterRadius: import('vue').Ref<number>
        snapToGrid: import('vue').Ref<boolean>
        snapGrid: import('vue').Ref<import('../../types').SnapGrid>
        defaultMarkerColor: import('vue').Ref<string>
        edgesUpdatable: import('vue').Ref<boolean>
        nodesDraggable: import('vue').Ref<boolean>
        nodesConnectable: import('vue').Ref<boolean>
        elementsSelectable: import('vue').Ref<boolean>
        selectNodesOnDrag: import('vue').Ref<boolean>
        panOnDrag: import('vue').Ref<boolean>
        zoomOnScroll: import('vue').Ref<boolean>
        zoomOnPinch: import('vue').Ref<boolean>
        panOnScroll: import('vue').Ref<boolean>
        panOnScrollSpeed: import('vue').Ref<number>
        panOnScrollMode: import('vue').Ref<import('../../types').PanOnScrollMode>
        zoomOnDoubleClick: import('vue').Ref<boolean>
        preventScrolling: import('vue').Ref<boolean>
        initialized: import('vue').Ref<boolean>
        applyDefault: import('vue').Ref<boolean>
        autoConnect: import('vue').Ref<boolean | import('../../types').Connector>
        fitViewOnInit?: import('vue').Ref<boolean | undefined> | undefined
        noDragClassName?: import('vue').Ref<string | undefined> | undefined
        noWheelClassName?: import('vue').Ref<string | undefined> | undefined
        noPanClassName?: import('vue').Ref<string | undefined> | undefined
        defaultEdgeOptions?: import('vue').Ref<import('../../types').DefaultEdgeOptions | undefined> | undefined
        vueFlowVersion: import('vue').Ref<string>
        edgeTypes?: import('vue').Ref<import('../../types').EdgeTypesObject | undefined> | undefined
        nodeTypes?: import('vue').Ref<import('../../types').NodeTypesObject | undefined> | undefined
        elevateEdgesOnSelect?: import('vue').Ref<boolean | undefined> | undefined
        getEdgeTypes: import('vue').ComputedRef<Record<string, import('../../types').EdgeComponent>>
        getNodeTypes: import('vue').ComputedRef<Record<string, import('../../types').NodeComponent>>
        getElements: import('vue').ComputedRef<FlowElements<any>>
        getNodes: import('vue').ComputedRef<GraphNode<any, any>[]>
        getEdges: import('vue').ComputedRef<GraphEdge<any, any>[]>
        getNode: import('vue').ComputedRef<(id: string) => GraphNode<any, any> | undefined>
        getEdge: import('vue').ComputedRef<(id: string) => GraphEdge<any, any> | undefined>
        getSelectedElements: import('vue').ComputedRef<FlowElements<any>>
        getSelectedNodes: import('vue').ComputedRef<GraphNode<any, any>[]>
        getSelectedEdges: import('vue').ComputedRef<GraphEdge<any, any>[]>
        setElements: import('../../types').SetElements
        setNodes: import('../../types').SetNodes
        setEdges: import('../../types').SetEdges
        addNodes: import('../../types').AddNodes
        addEdges: import('../../types').AddEdges
        removeNodes: import('../../types').RemoveNodes
        removeEdges: import('../../types').RemoveEdges
        findNode: (id: string) => GraphNode<any, any> | undefined
        findEdge: (id: string) => GraphEdge<any, any> | undefined
        updateEdge: import('../../types').UpdateEdge
        applyEdgeChanges: (changes: EdgeChange[]) => GraphEdge<any, any>[]
        applyNodeChanges: (changes: NodeChange[]) => GraphNode<any, any>[]
        addSelectedElements: (elements: FlowElements<any>) => void
        addSelectedEdges: (edges: GraphEdge<any, any>[]) => void
        addSelectedNodes: (nodes: GraphNode<any, any>[]) => void
        removeSelectedEdges: (edges: GraphEdge<any, any>[]) => void
        removeSelectedNodes: (nodes: GraphNode<any, any>[]) => void
        removeSelectedElements: (
          elements?:
            | {
                nodes?: GraphNode<any, any>[] | undefined
                edges?: GraphEdge<any, any>[] | undefined
              }
            | undefined,
        ) => void
        setMinZoom: (zoom: number) => void
        setMaxZoom: (zoom: number) => void
        setTranslateExtent: (translateExtent: import('../../types').CoordinateExtent) => void
        setInteractive: (isInteractive: boolean) => void
        setState: import('../../types').SetState
        toObject: () => import('../../types').FlowExportObject
        updateNodeInternals: import('../../types').UpdateNodeInternals
        updateNodePositions: import('../../types').UpdateNodePosition
        updateNodeDimensions: import('../../types').UpdateNodeDimensions
        $reset: () => void
        $destroy: () => void
        zoomIn: import('../../types').ZoomInOut
        zoomOut: import('../../types').ZoomInOut
        zoomTo: import('../../types').ZoomTo
        setTransform: import('../../types').SetTransform
        getTransform: import('../../types').GetTransform
        fitView: import('../../types').FitView
        setCenter: import('../../types').SetCenter
        fitBounds: import('../../types').FitBounds
        project: import('../../types').Project
      },
      unknown,
      {},
      {},
      import('vue').ComponentOptionsMixin,
      import('vue').ComponentOptionsMixin,
      {
        nodesChange: (changes: NodeChange[]) => void
      } & {
        edgesChange: (changes: EdgeChange[]) => void
      } & {
        nodeDoubleClick: (nodeMouseEvent: NodeMouseEvent) => void
      } & {
        nodeClick: (nodeMouseEvent: NodeMouseEvent) => void
      } & {
        nodeMouseEnter: (nodeMouseEvent: NodeMouseEvent) => void
      } & {
        nodeMouseMove: (nodeMouseEvent: NodeMouseEvent) => void
      } & {
        nodeMouseLeave: (nodeMouseEvent: NodeMouseEvent) => void
      } & {
        nodeContextMenu: (nodeMouseEvent: NodeMouseEvent) => void
      } & {
        nodeDragStart: (nodeDragEvent: NodeDragEvent) => void
      } & {
        nodeDrag: (nodeDragEvent: NodeDragEvent) => void
      } & {
        nodeDragStop: (nodeDragEvent: NodeDragEvent) => void
      } & {
        miniMapNodeClick: (nodeMouseEvent: NodeMouseEvent) => void
      } & {
        miniMapNodeDoubleClick: (nodeMouseEvent: NodeMouseEvent) => void
      } & {
        miniMapNodeMouseEnter: (nodeMouseEvent: NodeMouseEvent) => void
      } & {
        miniMapNodeMouseMove: (nodeMouseEvent: NodeMouseEvent) => void
      } & {
        miniMapNodeMouseLeave: (nodeMouseEvent: NodeMouseEvent) => void
      } & {
        connect: (connectionEvent: Connection) => void
      } & {
        connectStart: (
          connectionEvent: {
            event: MouseEvent
          } & OnConnectStartParams,
        ) => void
      } & {
        connectStop: (connectionEvent: MouseEvent) => void
      } & {
        connectEnd: (connectionEvent: MouseEvent) => void
      } & {
        moveStart: (moveEvent: { event: D3ZoomEvent<HTMLDivElement, any>; flowTransform: ViewpaneTransform }) => void
      } & {
        move: (moveEvent: { event: D3ZoomEvent<HTMLDivElement, any>; flowTransform: ViewpaneTransform }) => void
      } & {
        moveEnd: (moveEvent: { event: D3ZoomEvent<HTMLDivElement, any>; flowTransform: ViewpaneTransform }) => void
      } & {
        selectionDragStart: (selectionEvent: NodeDragEvent) => void
      } & {
        selectionDrag: (selectionEvent: NodeDragEvent) => void
      } & {
        selectionDragStop: (selectionEvent: NodeDragEvent) => void
      } & {
        selectionContextMenu: (selectionEvent: { event: MouseEvent; nodes: GraphNode[] }) => void
      } & {
        paneReady: (paneEvent: VueFlowStore) => void
      } & {
        paneScroll: (paneEvent: WheelEvent | undefined) => void
      } & {
        paneClick: (paneEvent: MouseEvent) => void
      } & {
        paneContextMenu: (paneEvent: MouseEvent) => void
      } & {
        paneMouseEnter: (paneEvent: MouseEvent) => void
      } & {
        paneMouseMove: (paneEvent: MouseEvent) => void
      } & {
        paneMouseLeave: (paneEvent: MouseEvent) => void
      } & {
        edgeContextMenu: (edgeMouseEvent: EdgeMouseEvent) => void
      } & {
        edgeMouseEnter: (edgeMouseEvent: EdgeMouseEvent) => void
      } & {
        edgeMouseMove: (edgeMouseEvent: EdgeMouseEvent) => void
      } & {
        edgeMouseLeave: (edgeMouseEvent: EdgeMouseEvent) => void
      } & {
        edgeDoubleClick: (edgeMouseEvent: EdgeMouseEvent) => void
      } & {
        edgeClick: (edgeMouseEvent: EdgeMouseEvent) => void
      } & {
        edgeUpdateStart: (edgeMouseEvent: EdgeMouseEvent) => void
      } & {
        edgeUpdate: (edgeUpdateEvent: EdgeUpdateEvent) => void
      } & {
        edgeUpdateEnd: (edgeMouseEvent: EdgeMouseEvent) => void
      } & {
        'update:modelValue': (value: FlowElements<any>) => void
      } & {
        'update:nodes': (value: GraphNode<any, any>[]) => void
      } & {
        'update:edges': (value: GraphEdge<any, any>[]) => void
      },
      string,
      {
        connectionLineStyle: import('vue').CSSProperties | null
        snapToGrid: boolean
        onlyRenderVisibleElements: boolean
        edgesUpdatable: boolean
        nodesDraggable: boolean
        nodesConnectable: boolean
        elementsSelectable: boolean
        selectNodesOnDrag: boolean
        panOnDrag: boolean
        zoomOnScroll: boolean
        zoomOnPinch: boolean
        panOnScroll: boolean
        zoomOnDoubleClick: boolean
        preventScrolling: boolean
        fitViewOnInit: boolean
        connectOnClick: boolean
        applyDefault: boolean
        autoConnect: boolean | import('../../types').Connector
        elevateEdgesOnSelect: boolean
      }
    > & {
      beforeCreate?: ((() => void) | (() => void)[]) | undefined
      created?: ((() => void) | (() => void)[]) | undefined
      beforeMount?: ((() => void) | (() => void)[]) | undefined
      mounted?: ((() => void) | (() => void)[]) | undefined
      beforeUpdate?: ((() => void) | (() => void)[]) | undefined
      updated?: ((() => void) | (() => void)[]) | undefined
      activated?: ((() => void) | (() => void)[]) | undefined
      deactivated?: ((() => void) | (() => void)[]) | undefined
      beforeDestroy?: ((() => void) | (() => void)[]) | undefined
      beforeUnmount?: ((() => void) | (() => void)[]) | undefined
      destroyed?: ((() => void) | (() => void)[]) | undefined
      unmounted?: ((() => void) | (() => void)[]) | undefined
      renderTracked?: (((e: import('vue').DebuggerEvent) => void) | ((e: import('vue').DebuggerEvent) => void)[]) | undefined
      renderTriggered?: (((e: import('vue').DebuggerEvent) => void) | ((e: import('vue').DebuggerEvent) => void)[]) | undefined
      errorCaptured?:
        | (
            | ((
                err: unknown,
                instance:
                  | import('vue').ComponentPublicInstance<
                      {},
                      {},
                      {},
                      {},
                      {},
                      {},
                      {},
                      {},
                      false,
                      import('vue').ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}>
                    >
                  | null,
                info: string,
              ) => boolean | void)
            | ((
                err: unknown,
                instance:
                  | import('vue').ComponentPublicInstance<
                      {},
                      {},
                      {},
                      {},
                      {},
                      {},
                      {},
                      {},
                      false,
                      import('vue').ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}>
                    >
                  | null,
                info: string,
              ) => boolean | void)[]
          )
        | undefined
    }
    $forceUpdate: () => void
    $nextTick: typeof import('vue').nextTick
    $watch(
      source: string | Function,
      cb: Function,
      options?: import('vue').WatchOptions<boolean> | undefined,
    ): import('vue').WatchStopHandle
  } & Readonly<
    import('vue').ExtractPropTypes<
      __VLS_WithDefaults<
        __VLS_TypePropsToRuntimeProps<FlowProps>,
        {
          snapToGrid: undefined
          onlyRenderVisibleElements: undefined
          edgesUpdatable: undefined
          nodesConnectable: undefined
          nodesDraggable: undefined
          elementsSelectable: undefined
          selectNodesOnDrag: undefined
          preventScrolling: undefined
          zoomOnScroll: undefined
          zoomOnPinch: undefined
          zoomOnDoubleClick: undefined
          panOnScroll: undefined
          panOnDrag: undefined
          applyDefault: undefined
          fitViewOnInit: undefined
          connectOnClick: undefined
          connectionLineStyle: undefined
          autoConnect: undefined
          elevateEdgesOnSelect: undefined
        }
      >
    >
  > & {
      'onNodesChange'?: ((changes: NodeChange[]) => any) | undefined
      'onEdgesChange'?: ((changes: EdgeChange[]) => any) | undefined
      'onNodeDoubleClick'?: ((nodeMouseEvent: NodeMouseEvent) => any) | undefined
      'onNodeClick'?: ((nodeMouseEvent: NodeMouseEvent) => any) | undefined
      'onNodeMouseEnter'?: ((nodeMouseEvent: NodeMouseEvent) => any) | undefined
      'onNodeMouseMove'?: ((nodeMouseEvent: NodeMouseEvent) => any) | undefined
      'onNodeMouseLeave'?: ((nodeMouseEvent: NodeMouseEvent) => any) | undefined
      'onNodeContextMenu'?: ((nodeMouseEvent: NodeMouseEvent) => any) | undefined
      'onNodeDragStart'?: ((nodeDragEvent: NodeDragEvent) => any) | undefined
      'onNodeDrag'?: ((nodeDragEvent: NodeDragEvent) => any) | undefined
      'onNodeDragStop'?: ((nodeDragEvent: NodeDragEvent) => any) | undefined
      'onMiniMapNodeClick'?: ((nodeMouseEvent: NodeMouseEvent) => any) | undefined
      'onMiniMapNodeDoubleClick'?: ((nodeMouseEvent: NodeMouseEvent) => any) | undefined
      'onMiniMapNodeMouseEnter'?: ((nodeMouseEvent: NodeMouseEvent) => any) | undefined
      'onMiniMapNodeMouseMove'?: ((nodeMouseEvent: NodeMouseEvent) => any) | undefined
      'onMiniMapNodeMouseLeave'?: ((nodeMouseEvent: NodeMouseEvent) => any) | undefined
      'onConnect'?: ((connectionEvent: Connection) => any) | undefined
      'onConnectStart'?:
        | ((
            connectionEvent: {
              event: MouseEvent
            } & OnConnectStartParams,
          ) => any)
        | undefined
      'onConnectStop'?: ((connectionEvent: MouseEvent) => any) | undefined
      'onConnectEnd'?: ((connectionEvent: MouseEvent) => any) | undefined
      'onPaneReady'?: ((paneEvent: VueFlowStore) => any) | undefined
      'onMove'?: ((moveEvent: { event: D3ZoomEvent<HTMLDivElement, any>; flowTransform: ViewpaneTransform }) => any) | undefined
      'onMoveStart'?:
        | ((moveEvent: { event: D3ZoomEvent<HTMLDivElement, any>; flowTransform: ViewpaneTransform }) => any)
        | undefined
      'onMoveEnd'?:
        | ((moveEvent: { event: D3ZoomEvent<HTMLDivElement, any>; flowTransform: ViewpaneTransform }) => any)
        | undefined
      'onSelectionDragStart'?: ((selectionEvent: NodeDragEvent) => any) | undefined
      'onSelectionDrag'?: ((selectionEvent: NodeDragEvent) => any) | undefined
      'onSelectionDragStop'?: ((selectionEvent: NodeDragEvent) => any) | undefined
      'onSelectionContextMenu'?: ((selectionEvent: { event: MouseEvent; nodes: GraphNode[] }) => any) | undefined
      'onPaneScroll'?: ((paneEvent: WheelEvent | undefined) => any) | undefined
      'onPaneClick'?: ((paneEvent: MouseEvent) => any) | undefined
      'onPaneContextMenu'?: ((paneEvent: MouseEvent) => any) | undefined
      'onPaneMouseEnter'?: ((paneEvent: MouseEvent) => any) | undefined
      'onPaneMouseMove'?: ((paneEvent: MouseEvent) => any) | undefined
      'onPaneMouseLeave'?: ((paneEvent: MouseEvent) => any) | undefined
      'onEdgeContextMenu'?: ((edgeMouseEvent: EdgeMouseEvent) => any) | undefined
      'onEdgeMouseEnter'?: ((edgeMouseEvent: EdgeMouseEvent) => any) | undefined
      'onEdgeMouseMove'?: ((edgeMouseEvent: EdgeMouseEvent) => any) | undefined
      'onEdgeMouseLeave'?: ((edgeMouseEvent: EdgeMouseEvent) => any) | undefined
      'onEdgeDoubleClick'?: ((edgeMouseEvent: EdgeMouseEvent) => any) | undefined
      'onEdgeClick'?: ((edgeMouseEvent: EdgeMouseEvent) => any) | undefined
      'onEdgeUpdateStart'?: ((edgeMouseEvent: EdgeMouseEvent) => any) | undefined
      'onEdgeUpdate'?: ((edgeUpdateEvent: EdgeUpdateEvent) => any) | undefined
      'onEdgeUpdateEnd'?: ((edgeMouseEvent: EdgeMouseEvent) => any) | undefined
      'onUpdate:modelValue'?: ((value: FlowElements<any>) => any) | undefined
      'onUpdate:nodes'?: ((value: GraphNode<any, any>[]) => any) | undefined
      'onUpdate:edges'?: ((value: GraphEdge<any, any>[]) => any) | undefined
    } & import('vue').ShallowUnwrapRef<{
      id: string
      emits: Readonly<{
        nodesChange: import('@vueuse/shared').EventHookTrigger<NodeChange[]>
        edgesChange: import('@vueuse/shared').EventHookTrigger<EdgeChange[]>
        nodeDoubleClick: import('@vueuse/shared').EventHookTrigger<NodeMouseEvent>
        nodeClick: import('@vueuse/shared').EventHookTrigger<NodeMouseEvent>
        nodeMouseEnter: import('@vueuse/shared').EventHookTrigger<NodeMouseEvent>
        nodeMouseMove: import('@vueuse/shared').EventHookTrigger<NodeMouseEvent>
        nodeMouseLeave: import('@vueuse/shared').EventHookTrigger<NodeMouseEvent>
        nodeContextMenu: import('@vueuse/shared').EventHookTrigger<NodeMouseEvent>
        nodeDragStart: import('@vueuse/shared').EventHookTrigger<NodeDragEvent>
        nodeDrag: import('@vueuse/shared').EventHookTrigger<NodeDragEvent>
        nodeDragStop: import('@vueuse/shared').EventHookTrigger<NodeDragEvent>
        updateNodeInternals: import('@vueuse/shared').EventHookTrigger<string[]>
        miniMapNodeClick: import('@vueuse/shared').EventHookTrigger<NodeMouseEvent>
        miniMapNodeDoubleClick: import('@vueuse/shared').EventHookTrigger<NodeMouseEvent>
        miniMapNodeMouseEnter: import('@vueuse/shared').EventHookTrigger<NodeMouseEvent>
        miniMapNodeMouseMove: import('@vueuse/shared').EventHookTrigger<NodeMouseEvent>
        miniMapNodeMouseLeave: import('@vueuse/shared').EventHookTrigger<NodeMouseEvent>
        connect: import('@vueuse/shared').EventHookTrigger<Connection>
        connectStart: import('@vueuse/shared').EventHookTrigger<
          {
            event: MouseEvent
          } & OnConnectStartParams
        >
        connectStop: import('@vueuse/shared').EventHookTrigger<MouseEvent>
        connectEnd: import('@vueuse/shared').EventHookTrigger<MouseEvent>
        paneReady: import('@vueuse/shared').EventHookTrigger<VueFlowStore>
        move: import('@vueuse/shared').EventHookTrigger<{
          event: D3ZoomEvent<HTMLDivElement, any>
          flowTransform: ViewpaneTransform
        }>
        moveStart: import('@vueuse/shared').EventHookTrigger<{
          event: D3ZoomEvent<HTMLDivElement, any>
          flowTransform: ViewpaneTransform
        }>
        moveEnd: import('@vueuse/shared').EventHookTrigger<{
          event: D3ZoomEvent<HTMLDivElement, any>
          flowTransform: ViewpaneTransform
        }>
        selectionDragStart: import('@vueuse/shared').EventHookTrigger<NodeDragEvent>
        selectionDrag: import('@vueuse/shared').EventHookTrigger<NodeDragEvent>
        selectionDragStop: import('@vueuse/shared').EventHookTrigger<NodeDragEvent>
        selectionContextMenu: import('@vueuse/shared').EventHookTrigger<{
          event: MouseEvent
          nodes: GraphNode<any, any>[]
        }>
        paneScroll: import('@vueuse/shared').EventHookTrigger<WheelEvent | undefined>
        paneClick: import('@vueuse/shared').EventHookTrigger<MouseEvent>
        paneContextMenu: import('@vueuse/shared').EventHookTrigger<MouseEvent>
        paneMouseEnter: import('@vueuse/shared').EventHookTrigger<MouseEvent>
        paneMouseMove: import('@vueuse/shared').EventHookTrigger<MouseEvent>
        paneMouseLeave: import('@vueuse/shared').EventHookTrigger<MouseEvent>
        edgeContextMenu: import('@vueuse/shared').EventHookTrigger<EdgeMouseEvent>
        edgeMouseEnter: import('@vueuse/shared').EventHookTrigger<EdgeMouseEvent>
        edgeMouseMove: import('@vueuse/shared').EventHookTrigger<EdgeMouseEvent>
        edgeMouseLeave: import('@vueuse/shared').EventHookTrigger<EdgeMouseEvent>
        edgeDoubleClick: import('@vueuse/shared').EventHookTrigger<EdgeMouseEvent>
        edgeClick: import('@vueuse/shared').EventHookTrigger<EdgeMouseEvent>
        edgeUpdateStart: import('@vueuse/shared').EventHookTrigger<EdgeMouseEvent>
        edgeUpdate: import('@vueuse/shared').EventHookTrigger<EdgeUpdateEvent>
        edgeUpdateEnd: import('@vueuse/shared').EventHookTrigger<EdgeMouseEvent>
      }>
      onNodesChange: import('@vueuse/shared').EventHookOn<NodeChange[]>
      onEdgesChange: import('@vueuse/shared').EventHookOn<EdgeChange[]>
      onNodeDoubleClick: import('@vueuse/shared').EventHookOn<NodeMouseEvent>
      onNodeClick: import('@vueuse/shared').EventHookOn<NodeMouseEvent>
      onNodeMouseEnter: import('@vueuse/shared').EventHookOn<NodeMouseEvent>
      onNodeMouseMove: import('@vueuse/shared').EventHookOn<NodeMouseEvent>
      onNodeMouseLeave: import('@vueuse/shared').EventHookOn<NodeMouseEvent>
      onNodeContextMenu: import('@vueuse/shared').EventHookOn<NodeMouseEvent>
      onNodeDragStart: import('@vueuse/shared').EventHookOn<NodeDragEvent>
      onNodeDrag: import('@vueuse/shared').EventHookOn<NodeDragEvent>
      onNodeDragStop: import('@vueuse/shared').EventHookOn<NodeDragEvent>
      onUpdateNodeInternals: import('@vueuse/shared').EventHookOn<string[]>
      onMiniMapNodeClick: import('@vueuse/shared').EventHookOn<NodeMouseEvent>
      onMiniMapNodeDoubleClick: import('@vueuse/shared').EventHookOn<NodeMouseEvent>
      onMiniMapNodeMouseEnter: import('@vueuse/shared').EventHookOn<NodeMouseEvent>
      onMiniMapNodeMouseMove: import('@vueuse/shared').EventHookOn<NodeMouseEvent>
      onMiniMapNodeMouseLeave: import('@vueuse/shared').EventHookOn<NodeMouseEvent>
      onConnect: import('@vueuse/shared').EventHookOn<Connection>
      onConnectStart: import('@vueuse/shared').EventHookOn<
        {
          event: MouseEvent
        } & OnConnectStartParams
      >
      onConnectStop: import('@vueuse/shared').EventHookOn<MouseEvent>
      onConnectEnd: import('@vueuse/shared').EventHookOn<MouseEvent>
      onPaneReady: import('@vueuse/shared').EventHookOn<VueFlowStore>
      onMove: import('@vueuse/shared').EventHookOn<{
        event: D3ZoomEvent<HTMLDivElement, any>
        flowTransform: ViewpaneTransform
      }>
      onMoveStart: import('@vueuse/shared').EventHookOn<{
        event: D3ZoomEvent<HTMLDivElement, any>
        flowTransform: ViewpaneTransform
      }>
      onMoveEnd: import('@vueuse/shared').EventHookOn<{
        event: D3ZoomEvent<HTMLDivElement, any>
        flowTransform: ViewpaneTransform
      }>
      onSelectionDragStart: import('@vueuse/shared').EventHookOn<NodeDragEvent>
      onSelectionDrag: import('@vueuse/shared').EventHookOn<NodeDragEvent>
      onSelectionDragStop: import('@vueuse/shared').EventHookOn<NodeDragEvent>
      onSelectionContextMenu: import('@vueuse/shared').EventHookOn<{
        event: MouseEvent
        nodes: GraphNode<any, any>[]
      }>
      onPaneScroll: import('@vueuse/shared').EventHookOn<WheelEvent | undefined>
      onPaneClick: import('@vueuse/shared').EventHookOn<MouseEvent>
      onPaneContextMenu: import('@vueuse/shared').EventHookOn<MouseEvent>
      onPaneMouseEnter: import('@vueuse/shared').EventHookOn<MouseEvent>
      onPaneMouseMove: import('@vueuse/shared').EventHookOn<MouseEvent>
      onPaneMouseLeave: import('@vueuse/shared').EventHookOn<MouseEvent>
      onEdgeContextMenu: import('@vueuse/shared').EventHookOn<EdgeMouseEvent>
      onEdgeMouseEnter: import('@vueuse/shared').EventHookOn<EdgeMouseEvent>
      onEdgeMouseMove: import('@vueuse/shared').EventHookOn<EdgeMouseEvent>
      onEdgeMouseLeave: import('@vueuse/shared').EventHookOn<EdgeMouseEvent>
      onEdgeDoubleClick: import('@vueuse/shared').EventHookOn<EdgeMouseEvent>
      onEdgeClick: import('@vueuse/shared').EventHookOn<EdgeMouseEvent>
      onEdgeUpdateStart: import('@vueuse/shared').EventHookOn<EdgeMouseEvent>
      onEdgeUpdate: import('@vueuse/shared').EventHookOn<EdgeUpdateEvent>
      onEdgeUpdateEnd: import('@vueuse/shared').EventHookOn<EdgeMouseEvent>
      vueFlowRef: import('vue').Ref<HTMLDivElement | null>
      viewportRef: import('vue').Ref<HTMLDivElement | null>
      hooks: import('vue').Ref<
        Readonly<{
          nodesChange: import('@vueuse/shared').EventHook<NodeChange[]>
          edgesChange: import('@vueuse/shared').EventHook<EdgeChange[]>
          nodeDoubleClick: import('@vueuse/shared').EventHook<NodeMouseEvent>
          nodeClick: import('@vueuse/shared').EventHook<NodeMouseEvent>
          nodeMouseEnter: import('@vueuse/shared').EventHook<NodeMouseEvent>
          nodeMouseMove: import('@vueuse/shared').EventHook<NodeMouseEvent>
          nodeMouseLeave: import('@vueuse/shared').EventHook<NodeMouseEvent>
          nodeContextMenu: import('@vueuse/shared').EventHook<NodeMouseEvent>
          nodeDragStart: import('@vueuse/shared').EventHook<NodeDragEvent>
          nodeDrag: import('@vueuse/shared').EventHook<NodeDragEvent>
          nodeDragStop: import('@vueuse/shared').EventHook<NodeDragEvent>
          updateNodeInternals: import('@vueuse/shared').EventHook<string[]>
          miniMapNodeClick: import('@vueuse/shared').EventHook<NodeMouseEvent>
          miniMapNodeDoubleClick: import('@vueuse/shared').EventHook<NodeMouseEvent>
          miniMapNodeMouseEnter: import('@vueuse/shared').EventHook<NodeMouseEvent>
          miniMapNodeMouseMove: import('@vueuse/shared').EventHook<NodeMouseEvent>
          miniMapNodeMouseLeave: import('@vueuse/shared').EventHook<NodeMouseEvent>
          connect: import('@vueuse/shared').EventHook<Connection>
          connectStart: import('@vueuse/shared').EventHook<
            {
              event: MouseEvent
            } & OnConnectStartParams
          >
          connectStop: import('@vueuse/shared').EventHook<MouseEvent>
          connectEnd: import('@vueuse/shared').EventHook<MouseEvent>
          paneReady: import('@vueuse/shared').EventHook<VueFlowStore>
          move: import('@vueuse/shared').EventHook<{
            event: D3ZoomEvent<HTMLDivElement, any>
            flowTransform: ViewpaneTransform
          }>
          moveStart: import('@vueuse/shared').EventHook<{
            event: D3ZoomEvent<HTMLDivElement, any>
            flowTransform: ViewpaneTransform
          }>
          moveEnd: import('@vueuse/shared').EventHook<{
            event: D3ZoomEvent<HTMLDivElement, any>
            flowTransform: ViewpaneTransform
          }>
          selectionDragStart: import('@vueuse/shared').EventHook<NodeDragEvent>
          selectionDrag: import('@vueuse/shared').EventHook<NodeDragEvent>
          selectionDragStop: import('@vueuse/shared').EventHook<NodeDragEvent>
          selectionContextMenu: import('@vueuse/shared').EventHook<{
            event: MouseEvent
            nodes: GraphNode<any, any>[]
          }>
          paneScroll: import('@vueuse/shared').EventHook<WheelEvent | undefined>
          paneClick: import('@vueuse/shared').EventHook<MouseEvent>
          paneContextMenu: import('@vueuse/shared').EventHook<MouseEvent>
          paneMouseEnter: import('@vueuse/shared').EventHook<MouseEvent>
          paneMouseMove: import('@vueuse/shared').EventHook<MouseEvent>
          paneMouseLeave: import('@vueuse/shared').EventHook<MouseEvent>
          edgeContextMenu: import('@vueuse/shared').EventHook<EdgeMouseEvent>
          edgeMouseEnter: import('@vueuse/shared').EventHook<EdgeMouseEvent>
          edgeMouseMove: import('@vueuse/shared').EventHook<EdgeMouseEvent>
          edgeMouseLeave: import('@vueuse/shared').EventHook<EdgeMouseEvent>
          edgeDoubleClick: import('@vueuse/shared').EventHook<EdgeMouseEvent>
          edgeClick: import('@vueuse/shared').EventHook<EdgeMouseEvent>
          edgeUpdateStart: import('@vueuse/shared').EventHook<EdgeMouseEvent>
          edgeUpdate: import('@vueuse/shared').EventHook<EdgeUpdateEvent>
          edgeUpdateEnd: import('@vueuse/shared').EventHook<EdgeMouseEvent>
        }>
      >
      nodes: import('vue').Ref<GraphNode<any, any>[]>
      edges: import('vue').Ref<GraphEdge<any, any>[]>
      d3Zoom: import('vue').Ref<import('../../types').D3Zoom | null>
      d3Selection: import('vue').Ref<import('../../types').D3Selection | null>
      d3ZoomHandler: import('vue').Ref<import('../../types').D3ZoomHandler | null>
      minZoom: import('vue').Ref<number>
      maxZoom: import('vue').Ref<number>
      defaultZoom: import('vue').Ref<number>
      translateExtent: import('vue').Ref<import('../../types').CoordinateExtent>
      nodeExtent: import('vue').Ref<import('../../types').CoordinateExtent>
      dimensions: import('vue').Ref<import('../../types').Dimensions>
      viewport: import('vue').Ref<import('../../types').Viewport>
      onlyRenderVisibleElements: import('vue').Ref<boolean>
      defaultPosition: import('vue').Ref<[number, number]>
      nodesSelectionActive: import('vue').Ref<boolean>
      userSelectionActive: import('vue').Ref<boolean>
      multiSelectionActive: import('vue').Ref<boolean>
      deleteKeyCode: import('vue').Ref<import('@vueuse/core').KeyFilter>
      selectionKeyCode: import('vue').Ref<import('@vueuse/core').KeyFilter>
      multiSelectionKeyCode: import('vue').Ref<import('@vueuse/core').KeyFilter>
      zoomActivationKeyCode: import('vue').Ref<import('@vueuse/core').KeyFilter>
      connectionNodeId: import('vue').Ref<string | null>
      connectionHandleId: import('vue').Ref<string | null>
      connectionHandleType: import('vue').Ref<import('../../types').HandleType | null>
      connectionPosition: import('vue').Ref<import('../../types').XYPosition>
      connectionMode: import('vue').Ref<import('../../types').ConnectionMode>
      connectionLineOptions: import('vue').Ref<import('../../types').ConnectionLineOptions>
      connectionLineType: import('vue').Ref<import('../../types').ConnectionLineType>
      connectionLineStyle: import('vue').Ref<import('vue').CSSProperties | null>
      connectionStartHandle: import('vue').Ref<import('../../types').StartHandle | null>
      connectOnClick: import('vue').Ref<boolean>
      edgeUpdaterRadius: import('vue').Ref<number>
      snapToGrid: import('vue').Ref<boolean>
      snapGrid: import('vue').Ref<import('../../types').SnapGrid>
      defaultMarkerColor: import('vue').Ref<string>
      edgesUpdatable: import('vue').Ref<boolean>
      nodesDraggable: import('vue').Ref<boolean>
      nodesConnectable: import('vue').Ref<boolean>
      elementsSelectable: import('vue').Ref<boolean>
      selectNodesOnDrag: import('vue').Ref<boolean>
      panOnDrag: import('vue').Ref<boolean>
      zoomOnScroll: import('vue').Ref<boolean>
      zoomOnPinch: import('vue').Ref<boolean>
      panOnScroll: import('vue').Ref<boolean>
      panOnScrollSpeed: import('vue').Ref<number>
      panOnScrollMode: import('vue').Ref<import('../../types').PanOnScrollMode>
      zoomOnDoubleClick: import('vue').Ref<boolean>
      preventScrolling: import('vue').Ref<boolean>
      initialized: import('vue').Ref<boolean>
      applyDefault: import('vue').Ref<boolean>
      autoConnect: import('vue').Ref<boolean | import('../../types').Connector>
      fitViewOnInit?: import('vue').Ref<boolean | undefined> | undefined
      noDragClassName?: import('vue').Ref<string | undefined> | undefined
      noWheelClassName?: import('vue').Ref<string | undefined> | undefined
      noPanClassName?: import('vue').Ref<string | undefined> | undefined
      defaultEdgeOptions?: import('vue').Ref<import('../../types').DefaultEdgeOptions | undefined> | undefined
      vueFlowVersion: import('vue').Ref<string>
      edgeTypes?: import('vue').Ref<import('../../types').EdgeTypesObject | undefined> | undefined
      nodeTypes?: import('vue').Ref<import('../../types').NodeTypesObject | undefined> | undefined
      elevateEdgesOnSelect?: import('vue').Ref<boolean | undefined> | undefined
      getEdgeTypes: import('vue').ComputedRef<Record<string, import('../../types').EdgeComponent>>
      getNodeTypes: import('vue').ComputedRef<Record<string, import('../../types').NodeComponent>>
      getElements: import('vue').ComputedRef<FlowElements<any>>
      getNodes: import('vue').ComputedRef<GraphNode<any, any>[]>
      getEdges: import('vue').ComputedRef<GraphEdge<any, any>[]>
      getNode: import('vue').ComputedRef<(id: string) => GraphNode<any, any> | undefined>
      getEdge: import('vue').ComputedRef<(id: string) => GraphEdge<any, any> | undefined>
      getSelectedElements: import('vue').ComputedRef<FlowElements<any>>
      getSelectedNodes: import('vue').ComputedRef<GraphNode<any, any>[]>
      getSelectedEdges: import('vue').ComputedRef<GraphEdge<any, any>[]>
      setElements: import('../../types').SetElements
      setNodes: import('../../types').SetNodes
      setEdges: import('../../types').SetEdges
      addNodes: import('../../types').AddNodes
      addEdges: import('../../types').AddEdges
      removeNodes: import('../../types').RemoveNodes
      removeEdges: import('../../types').RemoveEdges
      findNode: (id: string) => GraphNode<any, any> | undefined
      findEdge: (id: string) => GraphEdge<any, any> | undefined
      updateEdge: import('../../types').UpdateEdge
      applyEdgeChanges: (changes: EdgeChange[]) => GraphEdge<any, any>[]
      applyNodeChanges: (changes: NodeChange[]) => GraphNode<any, any>[]
      addSelectedElements: (elements: FlowElements<any>) => void
      addSelectedEdges: (edges: GraphEdge<any, any>[]) => void
      addSelectedNodes: (nodes: GraphNode<any, any>[]) => void
      removeSelectedEdges: (edges: GraphEdge<any, any>[]) => void
      removeSelectedNodes: (nodes: GraphNode<any, any>[]) => void
      removeSelectedElements: (
        elements?:
          | {
              nodes?: GraphNode<any, any>[] | undefined
              edges?: GraphEdge<any, any>[] | undefined
            }
          | undefined,
      ) => void
      setMinZoom: (zoom: number) => void
      setMaxZoom: (zoom: number) => void
      setTranslateExtent: (translateExtent: import('../../types').CoordinateExtent) => void
      setInteractive: (isInteractive: boolean) => void
      setState: import('../../types').SetState
      toObject: () => import('../../types').FlowExportObject
      updateNodeInternals: import('../../types').UpdateNodeInternals
      updateNodePositions: import('../../types').UpdateNodePosition
      updateNodeDimensions: import('../../types').UpdateNodeDimensions
      $reset: () => void
      $destroy: () => void
      zoomIn: import('../../types').ZoomInOut
      zoomOut: import('../../types').ZoomInOut
      zoomTo: import('../../types').ZoomTo
      setTransform: import('../../types').SetTransform
      getTransform: import('../../types').GetTransform
      fitView: import('../../types').FitView
      setCenter: import('../../types').SetCenter
      fitBounds: import('../../types').FitBounds
      project: import('../../types').Project
    }> & {} & import('vue').ComponentCustomProperties
  __isFragment?: undefined
  __isTeleport?: undefined
  __isSuspense?: undefined
} & import('vue').ComponentOptionsBase<
  Readonly<
    import('vue').ExtractPropTypes<
      __VLS_WithDefaults<
        __VLS_TypePropsToRuntimeProps<FlowProps>,
        {
          snapToGrid: undefined
          onlyRenderVisibleElements: undefined
          edgesUpdatable: undefined
          nodesConnectable: undefined
          nodesDraggable: undefined
          elementsSelectable: undefined
          selectNodesOnDrag: undefined
          preventScrolling: undefined
          zoomOnScroll: undefined
          zoomOnPinch: undefined
          zoomOnDoubleClick: undefined
          panOnScroll: undefined
          panOnDrag: undefined
          applyDefault: undefined
          fitViewOnInit: undefined
          connectOnClick: undefined
          connectionLineStyle: undefined
          autoConnect: undefined
          elevateEdgesOnSelect: undefined
        }
      >
    >
  > & {
    'onNodesChange'?: ((changes: NodeChange[]) => any) | undefined
    'onEdgesChange'?: ((changes: EdgeChange[]) => any) | undefined
    'onNodeDoubleClick'?: ((nodeMouseEvent: NodeMouseEvent) => any) | undefined
    'onNodeClick'?: ((nodeMouseEvent: NodeMouseEvent) => any) | undefined
    'onNodeMouseEnter'?: ((nodeMouseEvent: NodeMouseEvent) => any) | undefined
    'onNodeMouseMove'?: ((nodeMouseEvent: NodeMouseEvent) => any) | undefined
    'onNodeMouseLeave'?: ((nodeMouseEvent: NodeMouseEvent) => any) | undefined
    'onNodeContextMenu'?: ((nodeMouseEvent: NodeMouseEvent) => any) | undefined
    'onNodeDragStart'?: ((nodeDragEvent: NodeDragEvent) => any) | undefined
    'onNodeDrag'?: ((nodeDragEvent: NodeDragEvent) => any) | undefined
    'onNodeDragStop'?: ((nodeDragEvent: NodeDragEvent) => any) | undefined
    'onMiniMapNodeClick'?: ((nodeMouseEvent: NodeMouseEvent) => any) | undefined
    'onMiniMapNodeDoubleClick'?: ((nodeMouseEvent: NodeMouseEvent) => any) | undefined
    'onMiniMapNodeMouseEnter'?: ((nodeMouseEvent: NodeMouseEvent) => any) | undefined
    'onMiniMapNodeMouseMove'?: ((nodeMouseEvent: NodeMouseEvent) => any) | undefined
    'onMiniMapNodeMouseLeave'?: ((nodeMouseEvent: NodeMouseEvent) => any) | undefined
    'onConnect'?: ((connectionEvent: Connection) => any) | undefined
    'onConnectStart'?:
      | ((
          connectionEvent: {
            event: MouseEvent
          } & OnConnectStartParams,
        ) => any)
      | undefined
    'onConnectStop'?: ((connectionEvent: MouseEvent) => any) | undefined
    'onConnectEnd'?: ((connectionEvent: MouseEvent) => any) | undefined
    'onPaneReady'?: ((paneEvent: VueFlowStore) => any) | undefined
    'onMove'?: ((moveEvent: { event: D3ZoomEvent<HTMLDivElement, any>; flowTransform: ViewpaneTransform }) => any) | undefined
    'onMoveStart'?:
      | ((moveEvent: { event: D3ZoomEvent<HTMLDivElement, any>; flowTransform: ViewpaneTransform }) => any)
      | undefined
    'onMoveEnd'?: ((moveEvent: { event: D3ZoomEvent<HTMLDivElement, any>; flowTransform: ViewpaneTransform }) => any) | undefined
    'onSelectionDragStart'?: ((selectionEvent: NodeDragEvent) => any) | undefined
    'onSelectionDrag'?: ((selectionEvent: NodeDragEvent) => any) | undefined
    'onSelectionDragStop'?: ((selectionEvent: NodeDragEvent) => any) | undefined
    'onSelectionContextMenu'?: ((selectionEvent: { event: MouseEvent; nodes: GraphNode[] }) => any) | undefined
    'onPaneScroll'?: ((paneEvent: WheelEvent | undefined) => any) | undefined
    'onPaneClick'?: ((paneEvent: MouseEvent) => any) | undefined
    'onPaneContextMenu'?: ((paneEvent: MouseEvent) => any) | undefined
    'onPaneMouseEnter'?: ((paneEvent: MouseEvent) => any) | undefined
    'onPaneMouseMove'?: ((paneEvent: MouseEvent) => any) | undefined
    'onPaneMouseLeave'?: ((paneEvent: MouseEvent) => any) | undefined
    'onEdgeContextMenu'?: ((edgeMouseEvent: EdgeMouseEvent) => any) | undefined
    'onEdgeMouseEnter'?: ((edgeMouseEvent: EdgeMouseEvent) => any) | undefined
    'onEdgeMouseMove'?: ((edgeMouseEvent: EdgeMouseEvent) => any) | undefined
    'onEdgeMouseLeave'?: ((edgeMouseEvent: EdgeMouseEvent) => any) | undefined
    'onEdgeDoubleClick'?: ((edgeMouseEvent: EdgeMouseEvent) => any) | undefined
    'onEdgeClick'?: ((edgeMouseEvent: EdgeMouseEvent) => any) | undefined
    'onEdgeUpdateStart'?: ((edgeMouseEvent: EdgeMouseEvent) => any) | undefined
    'onEdgeUpdate'?: ((edgeUpdateEvent: EdgeUpdateEvent) => any) | undefined
    'onEdgeUpdateEnd'?: ((edgeMouseEvent: EdgeMouseEvent) => any) | undefined
    'onUpdate:modelValue'?: ((value: FlowElements<any>) => any) | undefined
    'onUpdate:nodes'?: ((value: GraphNode<any, any>[]) => any) | undefined
    'onUpdate:edges'?: ((value: GraphEdge<any, any>[]) => any) | undefined
  },
  {
    id: string
    emits: Readonly<{
      nodesChange: import('@vueuse/shared').EventHookTrigger<NodeChange[]>
      edgesChange: import('@vueuse/shared').EventHookTrigger<EdgeChange[]>
      nodeDoubleClick: import('@vueuse/shared').EventHookTrigger<NodeMouseEvent>
      nodeClick: import('@vueuse/shared').EventHookTrigger<NodeMouseEvent>
      nodeMouseEnter: import('@vueuse/shared').EventHookTrigger<NodeMouseEvent>
      nodeMouseMove: import('@vueuse/shared').EventHookTrigger<NodeMouseEvent>
      nodeMouseLeave: import('@vueuse/shared').EventHookTrigger<NodeMouseEvent>
      nodeContextMenu: import('@vueuse/shared').EventHookTrigger<NodeMouseEvent>
      nodeDragStart: import('@vueuse/shared').EventHookTrigger<NodeDragEvent>
      nodeDrag: import('@vueuse/shared').EventHookTrigger<NodeDragEvent>
      nodeDragStop: import('@vueuse/shared').EventHookTrigger<NodeDragEvent>
      updateNodeInternals: import('@vueuse/shared').EventHookTrigger<string[]>
      miniMapNodeClick: import('@vueuse/shared').EventHookTrigger<NodeMouseEvent>
      miniMapNodeDoubleClick: import('@vueuse/shared').EventHookTrigger<NodeMouseEvent>
      miniMapNodeMouseEnter: import('@vueuse/shared').EventHookTrigger<NodeMouseEvent>
      miniMapNodeMouseMove: import('@vueuse/shared').EventHookTrigger<NodeMouseEvent>
      miniMapNodeMouseLeave: import('@vueuse/shared').EventHookTrigger<NodeMouseEvent>
      connect: import('@vueuse/shared').EventHookTrigger<Connection>
      connectStart: import('@vueuse/shared').EventHookTrigger<
        {
          event: MouseEvent
        } & OnConnectStartParams
      >
      connectStop: import('@vueuse/shared').EventHookTrigger<MouseEvent>
      connectEnd: import('@vueuse/shared').EventHookTrigger<MouseEvent>
      paneReady: import('@vueuse/shared').EventHookTrigger<VueFlowStore>
      move: import('@vueuse/shared').EventHookTrigger<{
        event: D3ZoomEvent<HTMLDivElement, any>
        flowTransform: ViewpaneTransform
      }>
      moveStart: import('@vueuse/shared').EventHookTrigger<{
        event: D3ZoomEvent<HTMLDivElement, any>
        flowTransform: ViewpaneTransform
      }>
      moveEnd: import('@vueuse/shared').EventHookTrigger<{
        event: D3ZoomEvent<HTMLDivElement, any>
        flowTransform: ViewpaneTransform
      }>
      selectionDragStart: import('@vueuse/shared').EventHookTrigger<NodeDragEvent>
      selectionDrag: import('@vueuse/shared').EventHookTrigger<NodeDragEvent>
      selectionDragStop: import('@vueuse/shared').EventHookTrigger<NodeDragEvent>
      selectionContextMenu: import('@vueuse/shared').EventHookTrigger<{
        event: MouseEvent
        nodes: GraphNode<any, any>[]
      }>
      paneScroll: import('@vueuse/shared').EventHookTrigger<WheelEvent | undefined>
      paneClick: import('@vueuse/shared').EventHookTrigger<MouseEvent>
      paneContextMenu: import('@vueuse/shared').EventHookTrigger<MouseEvent>
      paneMouseEnter: import('@vueuse/shared').EventHookTrigger<MouseEvent>
      paneMouseMove: import('@vueuse/shared').EventHookTrigger<MouseEvent>
      paneMouseLeave: import('@vueuse/shared').EventHookTrigger<MouseEvent>
      edgeContextMenu: import('@vueuse/shared').EventHookTrigger<EdgeMouseEvent>
      edgeMouseEnter: import('@vueuse/shared').EventHookTrigger<EdgeMouseEvent>
      edgeMouseMove: import('@vueuse/shared').EventHookTrigger<EdgeMouseEvent>
      edgeMouseLeave: import('@vueuse/shared').EventHookTrigger<EdgeMouseEvent>
      edgeDoubleClick: import('@vueuse/shared').EventHookTrigger<EdgeMouseEvent>
      edgeClick: import('@vueuse/shared').EventHookTrigger<EdgeMouseEvent>
      edgeUpdateStart: import('@vueuse/shared').EventHookTrigger<EdgeMouseEvent>
      edgeUpdate: import('@vueuse/shared').EventHookTrigger<EdgeUpdateEvent>
      edgeUpdateEnd: import('@vueuse/shared').EventHookTrigger<EdgeMouseEvent>
    }>
    onNodesChange: import('@vueuse/shared').EventHookOn<NodeChange[]>
    onEdgesChange: import('@vueuse/shared').EventHookOn<EdgeChange[]>
    onNodeDoubleClick: import('@vueuse/shared').EventHookOn<NodeMouseEvent>
    onNodeClick: import('@vueuse/shared').EventHookOn<NodeMouseEvent>
    onNodeMouseEnter: import('@vueuse/shared').EventHookOn<NodeMouseEvent>
    onNodeMouseMove: import('@vueuse/shared').EventHookOn<NodeMouseEvent>
    onNodeMouseLeave: import('@vueuse/shared').EventHookOn<NodeMouseEvent>
    onNodeContextMenu: import('@vueuse/shared').EventHookOn<NodeMouseEvent>
    onNodeDragStart: import('@vueuse/shared').EventHookOn<NodeDragEvent>
    onNodeDrag: import('@vueuse/shared').EventHookOn<NodeDragEvent>
    onNodeDragStop: import('@vueuse/shared').EventHookOn<NodeDragEvent>
    onUpdateNodeInternals: import('@vueuse/shared').EventHookOn<string[]>
    onMiniMapNodeClick: import('@vueuse/shared').EventHookOn<NodeMouseEvent>
    onMiniMapNodeDoubleClick: import('@vueuse/shared').EventHookOn<NodeMouseEvent>
    onMiniMapNodeMouseEnter: import('@vueuse/shared').EventHookOn<NodeMouseEvent>
    onMiniMapNodeMouseMove: import('@vueuse/shared').EventHookOn<NodeMouseEvent>
    onMiniMapNodeMouseLeave: import('@vueuse/shared').EventHookOn<NodeMouseEvent>
    onConnect: import('@vueuse/shared').EventHookOn<Connection>
    onConnectStart: import('@vueuse/shared').EventHookOn<
      {
        event: MouseEvent
      } & OnConnectStartParams
    >
    onConnectStop: import('@vueuse/shared').EventHookOn<MouseEvent>
    onConnectEnd: import('@vueuse/shared').EventHookOn<MouseEvent>
    onPaneReady: import('@vueuse/shared').EventHookOn<VueFlowStore>
    onMove: import('@vueuse/shared').EventHookOn<{
      event: D3ZoomEvent<HTMLDivElement, any>
      flowTransform: ViewpaneTransform
    }>
    onMoveStart: import('@vueuse/shared').EventHookOn<{
      event: D3ZoomEvent<HTMLDivElement, any>
      flowTransform: ViewpaneTransform
    }>
    onMoveEnd: import('@vueuse/shared').EventHookOn<{
      event: D3ZoomEvent<HTMLDivElement, any>
      flowTransform: ViewpaneTransform
    }>
    onSelectionDragStart: import('@vueuse/shared').EventHookOn<NodeDragEvent>
    onSelectionDrag: import('@vueuse/shared').EventHookOn<NodeDragEvent>
    onSelectionDragStop: import('@vueuse/shared').EventHookOn<NodeDragEvent>
    onSelectionContextMenu: import('@vueuse/shared').EventHookOn<{
      event: MouseEvent
      nodes: GraphNode<any, any>[]
    }>
    onPaneScroll: import('@vueuse/shared').EventHookOn<WheelEvent | undefined>
    onPaneClick: import('@vueuse/shared').EventHookOn<MouseEvent>
    onPaneContextMenu: import('@vueuse/shared').EventHookOn<MouseEvent>
    onPaneMouseEnter: import('@vueuse/shared').EventHookOn<MouseEvent>
    onPaneMouseMove: import('@vueuse/shared').EventHookOn<MouseEvent>
    onPaneMouseLeave: import('@vueuse/shared').EventHookOn<MouseEvent>
    onEdgeContextMenu: import('@vueuse/shared').EventHookOn<EdgeMouseEvent>
    onEdgeMouseEnter: import('@vueuse/shared').EventHookOn<EdgeMouseEvent>
    onEdgeMouseMove: import('@vueuse/shared').EventHookOn<EdgeMouseEvent>
    onEdgeMouseLeave: import('@vueuse/shared').EventHookOn<EdgeMouseEvent>
    onEdgeDoubleClick: import('@vueuse/shared').EventHookOn<EdgeMouseEvent>
    onEdgeClick: import('@vueuse/shared').EventHookOn<EdgeMouseEvent>
    onEdgeUpdateStart: import('@vueuse/shared').EventHookOn<EdgeMouseEvent>
    onEdgeUpdate: import('@vueuse/shared').EventHookOn<EdgeUpdateEvent>
    onEdgeUpdateEnd: import('@vueuse/shared').EventHookOn<EdgeMouseEvent>
    vueFlowRef: import('vue').Ref<HTMLDivElement | null>
    viewportRef: import('vue').Ref<HTMLDivElement | null>
    hooks: import('vue').Ref<
      Readonly<{
        nodesChange: import('@vueuse/shared').EventHook<NodeChange[]>
        edgesChange: import('@vueuse/shared').EventHook<EdgeChange[]>
        nodeDoubleClick: import('@vueuse/shared').EventHook<NodeMouseEvent>
        nodeClick: import('@vueuse/shared').EventHook<NodeMouseEvent>
        nodeMouseEnter: import('@vueuse/shared').EventHook<NodeMouseEvent>
        nodeMouseMove: import('@vueuse/shared').EventHook<NodeMouseEvent>
        nodeMouseLeave: import('@vueuse/shared').EventHook<NodeMouseEvent>
        nodeContextMenu: import('@vueuse/shared').EventHook<NodeMouseEvent>
        nodeDragStart: import('@vueuse/shared').EventHook<NodeDragEvent>
        nodeDrag: import('@vueuse/shared').EventHook<NodeDragEvent>
        nodeDragStop: import('@vueuse/shared').EventHook<NodeDragEvent>
        updateNodeInternals: import('@vueuse/shared').EventHook<string[]>
        miniMapNodeClick: import('@vueuse/shared').EventHook<NodeMouseEvent>
        miniMapNodeDoubleClick: import('@vueuse/shared').EventHook<NodeMouseEvent>
        miniMapNodeMouseEnter: import('@vueuse/shared').EventHook<NodeMouseEvent>
        miniMapNodeMouseMove: import('@vueuse/shared').EventHook<NodeMouseEvent>
        miniMapNodeMouseLeave: import('@vueuse/shared').EventHook<NodeMouseEvent>
        connect: import('@vueuse/shared').EventHook<Connection>
        connectStart: import('@vueuse/shared').EventHook<
          {
            event: MouseEvent
          } & OnConnectStartParams
        >
        connectStop: import('@vueuse/shared').EventHook<MouseEvent>
        connectEnd: import('@vueuse/shared').EventHook<MouseEvent>
        paneReady: import('@vueuse/shared').EventHook<VueFlowStore>
        move: import('@vueuse/shared').EventHook<{
          event: D3ZoomEvent<HTMLDivElement, any>
          flowTransform: ViewpaneTransform
        }>
        moveStart: import('@vueuse/shared').EventHook<{
          event: D3ZoomEvent<HTMLDivElement, any>
          flowTransform: ViewpaneTransform
        }>
        moveEnd: import('@vueuse/shared').EventHook<{
          event: D3ZoomEvent<HTMLDivElement, any>
          flowTransform: ViewpaneTransform
        }>
        selectionDragStart: import('@vueuse/shared').EventHook<NodeDragEvent>
        selectionDrag: import('@vueuse/shared').EventHook<NodeDragEvent>
        selectionDragStop: import('@vueuse/shared').EventHook<NodeDragEvent>
        selectionContextMenu: import('@vueuse/shared').EventHook<{
          event: MouseEvent
          nodes: GraphNode<any, any>[]
        }>
        paneScroll: import('@vueuse/shared').EventHook<WheelEvent | undefined>
        paneClick: import('@vueuse/shared').EventHook<MouseEvent>
        paneContextMenu: import('@vueuse/shared').EventHook<MouseEvent>
        paneMouseEnter: import('@vueuse/shared').EventHook<MouseEvent>
        paneMouseMove: import('@vueuse/shared').EventHook<MouseEvent>
        paneMouseLeave: import('@vueuse/shared').EventHook<MouseEvent>
        edgeContextMenu: import('@vueuse/shared').EventHook<EdgeMouseEvent>
        edgeMouseEnter: import('@vueuse/shared').EventHook<EdgeMouseEvent>
        edgeMouseMove: import('@vueuse/shared').EventHook<EdgeMouseEvent>
        edgeMouseLeave: import('@vueuse/shared').EventHook<EdgeMouseEvent>
        edgeDoubleClick: import('@vueuse/shared').EventHook<EdgeMouseEvent>
        edgeClick: import('@vueuse/shared').EventHook<EdgeMouseEvent>
        edgeUpdateStart: import('@vueuse/shared').EventHook<EdgeMouseEvent>
        edgeUpdate: import('@vueuse/shared').EventHook<EdgeUpdateEvent>
        edgeUpdateEnd: import('@vueuse/shared').EventHook<EdgeMouseEvent>
      }>
    >
    nodes: import('vue').Ref<GraphNode<any, any>[]>
    edges: import('vue').Ref<GraphEdge<any, any>[]>
    d3Zoom: import('vue').Ref<import('../../types').D3Zoom | null>
    d3Selection: import('vue').Ref<import('../../types').D3Selection | null>
    d3ZoomHandler: import('vue').Ref<import('../../types').D3ZoomHandler | null>
    minZoom: import('vue').Ref<number>
    maxZoom: import('vue').Ref<number>
    defaultZoom: import('vue').Ref<number>
    translateExtent: import('vue').Ref<import('../../types').CoordinateExtent>
    nodeExtent: import('vue').Ref<import('../../types').CoordinateExtent>
    dimensions: import('vue').Ref<import('../../types').Dimensions>
    viewport: import('vue').Ref<import('../../types').Viewport>
    onlyRenderVisibleElements: import('vue').Ref<boolean>
    defaultPosition: import('vue').Ref<[number, number]>
    nodesSelectionActive: import('vue').Ref<boolean>
    userSelectionActive: import('vue').Ref<boolean>
    multiSelectionActive: import('vue').Ref<boolean>
    deleteKeyCode: import('vue').Ref<import('@vueuse/core').KeyFilter>
    selectionKeyCode: import('vue').Ref<import('@vueuse/core').KeyFilter>
    multiSelectionKeyCode: import('vue').Ref<import('@vueuse/core').KeyFilter>
    zoomActivationKeyCode: import('vue').Ref<import('@vueuse/core').KeyFilter>
    connectionNodeId: import('vue').Ref<string | null>
    connectionHandleId: import('vue').Ref<string | null>
    connectionHandleType: import('vue').Ref<import('../../types').HandleType | null>
    connectionPosition: import('vue').Ref<import('../../types').XYPosition>
    connectionMode: import('vue').Ref<import('../../types').ConnectionMode>
    connectionLineOptions: import('vue').Ref<import('../../types').ConnectionLineOptions>
    connectionLineType: import('vue').Ref<import('../../types').ConnectionLineType>
    connectionLineStyle: import('vue').Ref<import('vue').CSSProperties | null>
    connectionStartHandle: import('vue').Ref<import('../../types').StartHandle | null>
    connectOnClick: import('vue').Ref<boolean>
    edgeUpdaterRadius: import('vue').Ref<number>
    snapToGrid: import('vue').Ref<boolean>
    snapGrid: import('vue').Ref<import('../../types').SnapGrid>
    defaultMarkerColor: import('vue').Ref<string>
    edgesUpdatable: import('vue').Ref<boolean>
    nodesDraggable: import('vue').Ref<boolean>
    nodesConnectable: import('vue').Ref<boolean>
    elementsSelectable: import('vue').Ref<boolean>
    selectNodesOnDrag: import('vue').Ref<boolean>
    panOnDrag: import('vue').Ref<boolean>
    zoomOnScroll: import('vue').Ref<boolean>
    zoomOnPinch: import('vue').Ref<boolean>
    panOnScroll: import('vue').Ref<boolean>
    panOnScrollSpeed: import('vue').Ref<number>
    panOnScrollMode: import('vue').Ref<import('../../types').PanOnScrollMode>
    zoomOnDoubleClick: import('vue').Ref<boolean>
    preventScrolling: import('vue').Ref<boolean>
    initialized: import('vue').Ref<boolean>
    applyDefault: import('vue').Ref<boolean>
    autoConnect: import('vue').Ref<boolean | import('../../types').Connector>
    fitViewOnInit?: import('vue').Ref<boolean | undefined> | undefined
    noDragClassName?: import('vue').Ref<string | undefined> | undefined
    noWheelClassName?: import('vue').Ref<string | undefined> | undefined
    noPanClassName?: import('vue').Ref<string | undefined> | undefined
    defaultEdgeOptions?: import('vue').Ref<import('../../types').DefaultEdgeOptions | undefined> | undefined
    vueFlowVersion: import('vue').Ref<string>
    edgeTypes?: import('vue').Ref<import('../../types').EdgeTypesObject | undefined> | undefined
    nodeTypes?: import('vue').Ref<import('../../types').NodeTypesObject | undefined> | undefined
    elevateEdgesOnSelect?: import('vue').Ref<boolean | undefined> | undefined
    getEdgeTypes: import('vue').ComputedRef<Record<string, import('../../types').EdgeComponent>>
    getNodeTypes: import('vue').ComputedRef<Record<string, import('../../types').NodeComponent>>
    getElements: import('vue').ComputedRef<FlowElements<any>>
    getNodes: import('vue').ComputedRef<GraphNode<any, any>[]>
    getEdges: import('vue').ComputedRef<GraphEdge<any, any>[]>
    getNode: import('vue').ComputedRef<(id: string) => GraphNode<any, any> | undefined>
    getEdge: import('vue').ComputedRef<(id: string) => GraphEdge<any, any> | undefined>
    getSelectedElements: import('vue').ComputedRef<FlowElements<any>>
    getSelectedNodes: import('vue').ComputedRef<GraphNode<any, any>[]>
    getSelectedEdges: import('vue').ComputedRef<GraphEdge<any, any>[]>
    setElements: import('../../types').SetElements
    setNodes: import('../../types').SetNodes
    setEdges: import('../../types').SetEdges
    addNodes: import('../../types').AddNodes
    addEdges: import('../../types').AddEdges
    removeNodes: import('../../types').RemoveNodes
    removeEdges: import('../../types').RemoveEdges
    findNode: (id: string) => GraphNode<any, any> | undefined
    findEdge: (id: string) => GraphEdge<any, any> | undefined
    updateEdge: import('../../types').UpdateEdge
    applyEdgeChanges: (changes: EdgeChange[]) => GraphEdge<any, any>[]
    applyNodeChanges: (changes: NodeChange[]) => GraphNode<any, any>[]
    addSelectedElements: (elements: FlowElements<any>) => void
    addSelectedEdges: (edges: GraphEdge<any, any>[]) => void
    addSelectedNodes: (nodes: GraphNode<any, any>[]) => void
    removeSelectedEdges: (edges: GraphEdge<any, any>[]) => void
    removeSelectedNodes: (nodes: GraphNode<any, any>[]) => void
    removeSelectedElements: (
      elements?:
        | {
            nodes?: GraphNode<any, any>[] | undefined
            edges?: GraphEdge<any, any>[] | undefined
          }
        | undefined,
    ) => void
    setMinZoom: (zoom: number) => void
    setMaxZoom: (zoom: number) => void
    setTranslateExtent: (translateExtent: import('../../types').CoordinateExtent) => void
    setInteractive: (isInteractive: boolean) => void
    setState: import('../../types').SetState
    toObject: () => import('../../types').FlowExportObject
    updateNodeInternals: import('../../types').UpdateNodeInternals
    updateNodePositions: import('../../types').UpdateNodePosition
    updateNodeDimensions: import('../../types').UpdateNodeDimensions
    $reset: () => void
    $destroy: () => void
    zoomIn: import('../../types').ZoomInOut
    zoomOut: import('../../types').ZoomInOut
    zoomTo: import('../../types').ZoomTo
    setTransform: import('../../types').SetTransform
    getTransform: import('../../types').GetTransform
    fitView: import('../../types').FitView
    setCenter: import('../../types').SetCenter
    fitBounds: import('../../types').FitBounds
    project: import('../../types').Project
  },
  unknown,
  {},
  {},
  import('vue').ComponentOptionsMixin,
  import('vue').ComponentOptionsMixin,
  {
    nodesChange: (changes: NodeChange[]) => void
  } & {
    edgesChange: (changes: EdgeChange[]) => void
  } & {
    nodeDoubleClick: (nodeMouseEvent: NodeMouseEvent) => void
  } & {
    nodeClick: (nodeMouseEvent: NodeMouseEvent) => void
  } & {
    nodeMouseEnter: (nodeMouseEvent: NodeMouseEvent) => void
  } & {
    nodeMouseMove: (nodeMouseEvent: NodeMouseEvent) => void
  } & {
    nodeMouseLeave: (nodeMouseEvent: NodeMouseEvent) => void
  } & {
    nodeContextMenu: (nodeMouseEvent: NodeMouseEvent) => void
  } & {
    nodeDragStart: (nodeDragEvent: NodeDragEvent) => void
  } & {
    nodeDrag: (nodeDragEvent: NodeDragEvent) => void
  } & {
    nodeDragStop: (nodeDragEvent: NodeDragEvent) => void
  } & {
    miniMapNodeClick: (nodeMouseEvent: NodeMouseEvent) => void
  } & {
    miniMapNodeDoubleClick: (nodeMouseEvent: NodeMouseEvent) => void
  } & {
    miniMapNodeMouseEnter: (nodeMouseEvent: NodeMouseEvent) => void
  } & {
    miniMapNodeMouseMove: (nodeMouseEvent: NodeMouseEvent) => void
  } & {
    miniMapNodeMouseLeave: (nodeMouseEvent: NodeMouseEvent) => void
  } & {
    connect: (connectionEvent: Connection) => void
  } & {
    connectStart: (
      connectionEvent: {
        event: MouseEvent
      } & OnConnectStartParams,
    ) => void
  } & {
    connectStop: (connectionEvent: MouseEvent) => void
  } & {
    connectEnd: (connectionEvent: MouseEvent) => void
  } & {
    moveStart: (moveEvent: { event: D3ZoomEvent<HTMLDivElement, any>; flowTransform: ViewpaneTransform }) => void
  } & {
    move: (moveEvent: { event: D3ZoomEvent<HTMLDivElement, any>; flowTransform: ViewpaneTransform }) => void
  } & {
    moveEnd: (moveEvent: { event: D3ZoomEvent<HTMLDivElement, any>; flowTransform: ViewpaneTransform }) => void
  } & {
    selectionDragStart: (selectionEvent: NodeDragEvent) => void
  } & {
    selectionDrag: (selectionEvent: NodeDragEvent) => void
  } & {
    selectionDragStop: (selectionEvent: NodeDragEvent) => void
  } & {
    selectionContextMenu: (selectionEvent: { event: MouseEvent; nodes: GraphNode[] }) => void
  } & {
    paneReady: (paneEvent: VueFlowStore) => void
  } & {
    paneScroll: (paneEvent: WheelEvent | undefined) => void
  } & {
    paneClick: (paneEvent: MouseEvent) => void
  } & {
    paneContextMenu: (paneEvent: MouseEvent) => void
  } & {
    paneMouseEnter: (paneEvent: MouseEvent) => void
  } & {
    paneMouseMove: (paneEvent: MouseEvent) => void
  } & {
    paneMouseLeave: (paneEvent: MouseEvent) => void
  } & {
    edgeContextMenu: (edgeMouseEvent: EdgeMouseEvent) => void
  } & {
    edgeMouseEnter: (edgeMouseEvent: EdgeMouseEvent) => void
  } & {
    edgeMouseMove: (edgeMouseEvent: EdgeMouseEvent) => void
  } & {
    edgeMouseLeave: (edgeMouseEvent: EdgeMouseEvent) => void
  } & {
    edgeDoubleClick: (edgeMouseEvent: EdgeMouseEvent) => void
  } & {
    edgeClick: (edgeMouseEvent: EdgeMouseEvent) => void
  } & {
    edgeUpdateStart: (edgeMouseEvent: EdgeMouseEvent) => void
  } & {
    edgeUpdate: (edgeUpdateEvent: EdgeUpdateEvent) => void
  } & {
    edgeUpdateEnd: (edgeMouseEvent: EdgeMouseEvent) => void
  } & {
    'update:modelValue': (value: FlowElements<any>) => void
  } & {
    'update:nodes': (value: GraphNode<any, any>[]) => void
  } & {
    'update:edges': (value: GraphEdge<any, any>[]) => void
  },
  string,
  {
    connectionLineStyle: import('vue').CSSProperties | null
    snapToGrid: boolean
    onlyRenderVisibleElements: boolean
    edgesUpdatable: boolean
    nodesDraggable: boolean
    nodesConnectable: boolean
    elementsSelectable: boolean
    selectNodesOnDrag: boolean
    panOnDrag: boolean
    zoomOnScroll: boolean
    zoomOnPinch: boolean
    panOnScroll: boolean
    zoomOnDoubleClick: boolean
    preventScrolling: boolean
    fitViewOnInit: boolean
    connectOnClick: boolean
    applyDefault: boolean
    autoConnect: boolean | import('../../types').Connector
    elevateEdgesOnSelect: boolean
  }
> &
  import('vue').VNodeProps &
  import('vue').AllowedComponentProps &
  import('vue').ComponentCustomProps &
  (new () => {
    $slots: Record<string, {}> &
      Record<string, {}> & {
        'connection-line': (_: {}) => any
        'zoom-pane': (_: {}) => any
        'default': (_: {}) => any
      }
  })
export default _default
declare type __VLS_NonUndefinedable<T> = T extends undefined ? never : T
declare type __VLS_TypePropsToRuntimeProps<T> = {
  [K in keyof T]-?: {} extends Pick<T, K>
    ? {
        type: import('vue').PropType<__VLS_NonUndefinedable<T[K]>>
      }
    : {
        type: import('vue').PropType<T[K]>
        required: true
      }
}
declare type __VLS_WithDefaults<P, D> = {
  [K in keyof Pick<P, keyof P>]: K extends keyof D
    ? P[K] & {
        default: D[K]
      }
    : P[K]
}
