import type { Dimensions, ElementData, XYPosition } from './flow'
import type { GraphNode, Node, NodeHandleBounds } from './node'
import type { GraphEdge } from './edge'
export interface NodeDragItem {
  id: string
  position: XYPosition
  distance: XYPosition
  dimensions: Dimensions
  extent?: Node['extent']
  parentNode?: string
}
export interface NodeDimensionChange {
  id: string
  type: 'dimensions'
  dimensions: Dimensions
  handleBounds?: NodeHandleBounds
}
export interface NodePositionChange {
  id: string
  type: 'position'
  position: XYPosition
  computedPosition: XYPosition
  dragging: boolean
}
export interface NodeSelectionChange {
  id: string
  type: 'select'
  selected: boolean
}
export interface NodeRemoveChange {
  id: string
  type: 'remove'
}
export interface NodeAddChange<Data = ElementData> {
  item: GraphNode<Data>
  type: 'add'
}
export declare type NodeChange = NodeDimensionChange | NodePositionChange | NodeSelectionChange | NodeRemoveChange | NodeAddChange
export declare type EdgeSelectionChange = NodeSelectionChange
export declare type EdgeRemoveChange = NodeRemoveChange
export interface EdgeAddChange<Data = ElementData> {
  item: GraphEdge<Data>
  type: 'add'
}
export declare type EdgeChange = EdgeSelectionChange | EdgeRemoveChange | EdgeAddChange
export declare type ElementChange = NodeChange | EdgeChange
