import type { Ref } from 'vue'
import type { ComputedGetters, CoordinateExtent, Getters, GraphNode, NodeDragItem, XYPosition } from '../types'
export declare function hasSelector(target: Element, selector: string, node: Ref<Element>): boolean
export declare function getDragItems(
  nodes: GraphNode[],
  mousePos: XYPosition,
  getNode: Getters['getNode'],
  nodeId?: string,
): NodeDragItem[]
export declare function getEventHandlerParams({
  id,
  dragItems,
  getNode,
}: {
  id?: string
  dragItems: NodeDragItem[]
  getNode: ComputedGetters['getNode']
}): [GraphNode, GraphNode[]]
export declare function updatePosition(
  dragItem: NodeDragItem,
  mousePos: XYPosition,
  parent?: GraphNode,
  nodeExtent?: CoordinateExtent,
): NodeDragItem
