import type { Actions, Connection, CoordinateExtent, Edge, Getters, GraphEdge, GraphNode, Node } from '../types'
export declare const isDef: <T>(val: T) => val is NonNullable<T>
export declare const addEdgeToStore: (edgeParams: Edge | Connection, edges: Edge[]) => false | GraphEdge<any, any>
export declare const updateEdgeAction: (
  edge: GraphEdge,
  newConnection: Connection,
  edges: GraphEdge[],
  add: Actions['addEdges'],
) =>
  | false
  | {
      id: string
      source: string
      target: string
      sourceHandle: string | null
      targetHandle: string | null
      label?:
        | string
        | import('vue').VNode<
            import('vue').RendererNode,
            import('vue').RendererElement,
            {
              [key: string]: any
            }
          >
        | import('vue').Component<
            import('~/types').EdgeTextProps,
            any,
            any,
            import('vue').ComputedOptions,
            import('vue').MethodOptions
          >
        | undefined
      type?: string | undefined
      labelStyle?: import('vue').CSSProperties | undefined
      labelShowBg?: boolean | undefined
      labelBgStyle?: import('vue').CSSProperties | undefined
      labelBgPadding?: [number, number] | undefined
      labelBgBorderRadius?: number | undefined
      animated?: boolean | undefined
      markerStart?: import('../types').EdgeMarkerType | undefined
      markerEnd?: import('../types').EdgeMarkerType | undefined
      updatable?: boolean | undefined
      selectable?: boolean | undefined
      class?: string | import('../types').ClassFunc<GraphEdge<any, any>> | undefined
      style?: import('../types').Styles | import('../types').StyleFunc<GraphEdge<any, any>> | undefined
      hidden?: boolean | undefined
      template?: import('../types').EdgeComponent | undefined
      data?: any
      events?: Partial<import('../types').EdgeEventsHandler<any>> | undefined
      selected?: boolean | undefined
      z?: number | undefined
      sourceNode: GraphNode<any, any>
      targetNode: GraphNode<any, any>
      sourceX: number
      sourceY: number
      targetX: number
      targetY: number
    }
export declare const createGraphNodes: (
  nodes: Node[],
  getNode: Getters['getNode'],
  currGraphNodes: GraphNode[],
  extent: CoordinateExtent,
) => import('vue').ShallowReactive<GraphNode<any, any>>[]
