import { getCurrentScope, onScopeDispose, ref, watch, customRef, unref, getCurrentInstance, onMounted, nextTick, isRef, onUpdated, computed, onBeforeMount, defineComponent, toRef, inject, openBlock, createElementBlock, normalizeClass, renderSlot, h, markRaw, shallowReactive, createPropsRestProxy, provide, effectScope, onBeforeUnmount, normalizeStyle, createBlock, resolveDynamicComponent, createCommentVNode, createElementVNode, mergeProps, Fragment, createTextVNode, toDisplayString, normalizeProps, reactive, toRefs, renderList, resolveComponent, createVNode, watchEffect, withCtx, onUnmounted, useSlots, useAttrs } from "vue";
var _a;
const isClient = typeof window !== "undefined";
const isDef$3 = (val) => typeof val !== "undefined";
const isFunction = (val) => typeof val === "function";
const isString = (val) => typeof val === "string";
const noop$1 = () => {
};
isClient && ((_a = window == null ? void 0 : window.navigator) == null ? void 0 : _a.userAgent) && /iP(ad|hone|od)/.test(window.navigator.userAgent);
function resolveUnref(r) {
  return typeof r === "function" ? r() : unref(r);
}
function createFilterWrapper(filter2, fn) {
  function wrapper(...args) {
    filter2(() => fn.apply(this, args), { fn, thisArg: this, args });
  }
  return wrapper;
}
const bypassFilter = (invoke) => {
  return invoke();
};
function pausableFilter(extendFilter = bypassFilter) {
  const isActive = ref(true);
  function pause() {
    isActive.value = false;
  }
  function resume() {
    isActive.value = true;
  }
  const eventFilter = (...args) => {
    if (isActive.value)
      extendFilter(...args);
  };
  return { isActive, pause, resume, eventFilter };
}
function promiseTimeout(ms, throwOnTimeout = false, reason = "Timeout") {
  return new Promise((resolve, reject) => {
    if (throwOnTimeout)
      setTimeout(() => reject(reason), ms);
    else
      setTimeout(resolve, ms);
  });
}
function computedWithControl(source, fn) {
  let v = void 0;
  let track;
  let trigger;
  const dirty = ref(true);
  const update = () => {
    dirty.value = true;
    trigger();
  };
  watch(source, update, { flush: "sync" });
  const get2 = isFunction(fn) ? fn : fn.get;
  const set2 = isFunction(fn) ? void 0 : fn.set;
  const result = customRef((_track, _trigger) => {
    track = _track;
    trigger = _trigger;
    return {
      get() {
        if (dirty.value) {
          v = get2();
          dirty.value = false;
        }
        track();
        return v;
      },
      set(v2) {
        set2 == null ? void 0 : set2(v2);
      }
    };
  });
  if (Object.isExtensible(result))
    result.trigger = update;
  return result;
}
function createEventHook() {
  const fns = [];
  const off = (fn) => {
    const index = fns.indexOf(fn);
    if (index !== -1)
      fns.splice(index, 1);
  };
  const on = (fn) => {
    fns.push(fn);
    return {
      off: () => off(fn)
    };
  };
  const trigger = (param) => {
    fns.forEach((fn) => fn(param));
  };
  return {
    on,
    off,
    trigger
  };
}
function tryOnScopeDispose(fn) {
  if (getCurrentScope()) {
    onScopeDispose(fn);
    return true;
  }
  return false;
}
function tryOnMounted(fn, sync = true) {
  if (getCurrentInstance())
    onMounted(fn);
  else if (sync)
    fn();
  else
    nextTick(fn);
}
function until(r) {
  let isNot = false;
  function toMatch(condition, { flush = "sync", deep = false, timeout: timeout2, throwOnTimeout } = {}) {
    let stop = null;
    const watcher = new Promise((resolve) => {
      stop = watch(r, (v) => {
        if (condition(v) !== isNot) {
          stop == null ? void 0 : stop();
          resolve(v);
        }
      }, {
        flush,
        deep,
        immediate: true
      });
    });
    const promises = [watcher];
    if (timeout2 != null) {
      promises.push(promiseTimeout(timeout2, throwOnTimeout).then(() => resolveUnref(r)).finally(() => stop == null ? void 0 : stop()));
    }
    return Promise.race(promises);
  }
  function toBe(value, options) {
    if (!isRef(value))
      return toMatch((v) => v === value, options);
    const { flush = "sync", deep = false, timeout: timeout2, throwOnTimeout } = options != null ? options : {};
    let stop = null;
    const watcher = new Promise((resolve) => {
      stop = watch([r, value], ([v1, v2]) => {
        if (isNot !== (v1 === v2)) {
          stop == null ? void 0 : stop();
          resolve(v1);
        }
      }, {
        flush,
        deep,
        immediate: true
      });
    });
    const promises = [watcher];
    if (timeout2 != null) {
      promises.push(promiseTimeout(timeout2, throwOnTimeout).then(() => resolveUnref(r)).finally(() => {
        stop == null ? void 0 : stop();
        return resolveUnref(r);
      }));
    }
    return Promise.race(promises);
  }
  function toBeTruthy(options) {
    return toMatch((v) => Boolean(v), options);
  }
  function toBeNull(options) {
    return toBe(null, options);
  }
  function toBeUndefined(options) {
    return toBe(void 0, options);
  }
  function toBeNaN(options) {
    return toMatch(Number.isNaN, options);
  }
  function toContains(value, options) {
    return toMatch((v) => {
      const array2 = Array.from(v);
      return array2.includes(value) || array2.includes(resolveUnref(value));
    }, options);
  }
  function changed(options) {
    return changedTimes(1, options);
  }
  function changedTimes(n = 1, options) {
    let count = -1;
    return toMatch(() => {
      count += 1;
      return count >= n;
    }, options);
  }
  if (Array.isArray(resolveUnref(r))) {
    const instance = {
      toMatch,
      toContains,
      changed,
      changedTimes,
      get not() {
        isNot = !isNot;
        return this;
      }
    };
    return instance;
  } else {
    const instance = {
      toMatch,
      toBe,
      toBeTruthy,
      toBeNull,
      toBeNaN,
      toBeUndefined,
      changed,
      changedTimes,
      get not() {
        isNot = !isNot;
        return this;
      }
    };
    return instance;
  }
}
var __getOwnPropSymbols$6 = Object.getOwnPropertySymbols;
var __hasOwnProp$6 = Object.prototype.hasOwnProperty;
var __propIsEnum$6 = Object.prototype.propertyIsEnumerable;
var __objRest$5 = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$6.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$6)
    for (var prop of __getOwnPropSymbols$6(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$6.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
function watchWithFilter(source, cb, options = {}) {
  const _a2 = options, {
    eventFilter = bypassFilter
  } = _a2, watchOptions = __objRest$5(_a2, [
    "eventFilter"
  ]);
  return watch(source, createFilterWrapper(eventFilter, cb), watchOptions);
}
var __defProp$2 = Object.defineProperty;
var __defProps$2 = Object.defineProperties;
var __getOwnPropDescs$2 = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2 = Object.getOwnPropertySymbols;
var __hasOwnProp$2 = Object.prototype.hasOwnProperty;
var __propIsEnum$2 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2 = (obj, key, value) => key in obj ? __defProp$2(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2.call(b, prop))
      __defNormalProp$2(a, prop, b[prop]);
  if (__getOwnPropSymbols$2)
    for (var prop of __getOwnPropSymbols$2(b)) {
      if (__propIsEnum$2.call(b, prop))
        __defNormalProp$2(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$2 = (a, b) => __defProps$2(a, __getOwnPropDescs$2(b));
var __objRest$1 = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2)
    for (var prop of __getOwnPropSymbols$2(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
function watchPausable(source, cb, options = {}) {
  const _a2 = options, {
    eventFilter: filter2
  } = _a2, watchOptions = __objRest$1(_a2, [
    "eventFilter"
  ]);
  const { eventFilter, pause, resume, isActive } = pausableFilter(filter2);
  const stop = watchWithFilter(source, cb, __spreadProps$2(__spreadValues$2({}, watchOptions), {
    eventFilter
  }));
  return { stop, pause, resume, isActive };
}
function unrefElement(elRef) {
  var _a2;
  const plain = resolveUnref(elRef);
  return (_a2 = plain == null ? void 0 : plain.$el) != null ? _a2 : plain;
}
const defaultWindow = isClient ? window : void 0;
function useEventListener(...args) {
  let target;
  let event;
  let listener;
  let options;
  if (isString(args[0])) {
    [event, listener, options] = args;
    target = defaultWindow;
  } else {
    [target, event, listener, options] = args;
  }
  if (!target)
    return noop$1;
  let cleanup = noop$1;
  const stopWatch = watch(() => unrefElement(target), (el) => {
    cleanup();
    if (!el)
      return;
    el.addEventListener(event, listener, options);
    cleanup = () => {
      el.removeEventListener(event, listener, options);
      cleanup = noop$1;
    };
  }, { immediate: true, flush: "post" });
  const stop = () => {
    stopWatch();
    cleanup();
  };
  tryOnScopeDispose(stop);
  return stop;
}
const createKeyPredicate = (keyFilter) => {
  if (typeof keyFilter === "function")
    return keyFilter;
  else if (typeof keyFilter === "string")
    return (event) => event.key === keyFilter;
  else if (Array.isArray(keyFilter))
    return (event) => keyFilter.includes(event.key);
  else if (keyFilter)
    return () => true;
  else
    return () => false;
};
function onKeyStroke(key, handler, options = {}) {
  const { target = defaultWindow, eventName = "keydown", passive = false } = options;
  const predicate = createKeyPredicate(key);
  const listener = (e) => {
    if (predicate(e))
      handler(e);
  };
  return useEventListener(target, eventName, listener, passive);
}
function templateRef(key, initialValue = null) {
  const instance = getCurrentInstance();
  let _trigger = () => {
  };
  const element = customRef((track, trigger) => {
    _trigger = trigger;
    return {
      get() {
        var _a2, _b;
        track();
        return (_b = (_a2 = instance == null ? void 0 : instance.proxy) == null ? void 0 : _a2.$refs[key]) != null ? _b : initialValue;
      },
      set() {
      }
    };
  });
  tryOnMounted(_trigger);
  onUpdated(_trigger);
  return element;
}
function useSupported(callback, sync = false) {
  const isSupported = ref();
  const update = () => isSupported.value = Boolean(callback());
  update();
  tryOnMounted(update, sync);
  return isSupported;
}
const _global = typeof globalThis !== "undefined" ? globalThis : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : {};
const globalKey = "__vueuse_ssr_handlers__";
_global[globalKey] = _global[globalKey] || {};
_global[globalKey];
var __getOwnPropSymbols$e = Object.getOwnPropertySymbols;
var __hasOwnProp$e = Object.prototype.hasOwnProperty;
var __propIsEnum$e = Object.prototype.propertyIsEnumerable;
var __objRest$2 = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$e.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$e)
    for (var prop of __getOwnPropSymbols$e(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$e.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
function useResizeObserver(target, callback, options = {}) {
  const _a2 = options, { window: window2 = defaultWindow } = _a2, observerOptions = __objRest$2(_a2, ["window"]);
  let observer;
  const isSupported = useSupported(() => window2 && "ResizeObserver" in window2);
  const cleanup = () => {
    if (observer) {
      observer.disconnect();
      observer = void 0;
    }
  };
  const stopWatch = watch(() => unrefElement(target), (el) => {
    cleanup();
    if (isSupported.value && window2 && el) {
      observer = new ResizeObserver(callback);
      observer.observe(el, observerOptions);
    }
  }, { immediate: true, flush: "post" });
  const stop = () => {
    cleanup();
    stopWatch();
  };
  tryOnScopeDispose(stop);
  return {
    isSupported,
    stop
  };
}
function useElementBounding(target, options = {}) {
  const {
    reset = true,
    windowResize = true,
    windowScroll = true,
    immediate = true
  } = options;
  const height = ref(0);
  const bottom = ref(0);
  const left = ref(0);
  const right = ref(0);
  const top = ref(0);
  const width = ref(0);
  const x = ref(0);
  const y = ref(0);
  function update() {
    const el = unrefElement(target);
    if (!el) {
      if (reset) {
        height.value = 0;
        bottom.value = 0;
        left.value = 0;
        right.value = 0;
        top.value = 0;
        width.value = 0;
        x.value = 0;
        y.value = 0;
      }
      return;
    }
    const rect = el.getBoundingClientRect();
    height.value = rect.height;
    bottom.value = rect.bottom;
    left.value = rect.left;
    right.value = rect.right;
    top.value = rect.top;
    width.value = rect.width;
    x.value = rect.x;
    y.value = rect.y;
  }
  useResizeObserver(target, update);
  watch(() => unrefElement(target), (ele) => !ele && update());
  if (windowScroll)
    useEventListener("scroll", update, { passive: true });
  if (windowResize)
    useEventListener("resize", update, { passive: true });
  tryOnMounted(() => {
    if (immediate)
      update();
  });
  return {
    height,
    bottom,
    left,
    right,
    top,
    width,
    x,
    y,
    update
  };
}
var SwipeDirection;
(function(SwipeDirection2) {
  SwipeDirection2["UP"] = "UP";
  SwipeDirection2["RIGHT"] = "RIGHT";
  SwipeDirection2["DOWN"] = "DOWN";
  SwipeDirection2["LEFT"] = "LEFT";
  SwipeDirection2["NONE"] = "NONE";
})(SwipeDirection || (SwipeDirection = {}));
function useVModel(props, key, emit, options = {}) {
  var _a2, _b, _c;
  const {
    passive = false,
    eventName,
    deep = false,
    defaultValue
  } = options;
  const vm = getCurrentInstance();
  const _emit = emit || (vm == null ? void 0 : vm.emit) || ((_a2 = vm == null ? void 0 : vm.$emit) == null ? void 0 : _a2.bind(vm)) || ((_c = (_b = vm == null ? void 0 : vm.proxy) == null ? void 0 : _b.$emit) == null ? void 0 : _c.bind(vm == null ? void 0 : vm.proxy));
  let event = eventName;
  if (!key) {
    {
      key = "modelValue";
    }
  }
  event = eventName || event || `update:${key.toString()}`;
  const getValue = () => isDef$3(props[key]) ? props[key] : defaultValue;
  if (passive) {
    const proxy = ref(getValue());
    watch(() => props[key], (v) => proxy.value = v);
    watch(proxy, (v) => {
      if (v !== props[key] || deep)
        _emit(event, v);
    }, {
      deep
    });
    return proxy;
  } else {
    return computed({
      get() {
        return getValue();
      },
      set(value) {
        _emit(event, value);
      }
    });
  }
}
var noop = { value: () => {
} };
function dispatch() {
  for (var i = 0, n = arguments.length, _ = {}, t; i < n; ++i) {
    if (!(t = arguments[i] + "") || t in _ || /[\s.]/.test(t))
      throw new Error("illegal type: " + t);
    _[t] = [];
  }
  return new Dispatch(_);
}
function Dispatch(_) {
  this._ = _;
}
function parseTypenames$1(typenames, types) {
  return typenames.trim().split(/^|\s+/).map(function(t) {
    var name = "", i = t.indexOf(".");
    if (i >= 0)
      name = t.slice(i + 1), t = t.slice(0, i);
    if (t && !types.hasOwnProperty(t))
      throw new Error("unknown type: " + t);
    return { type: t, name };
  });
}
Dispatch.prototype = dispatch.prototype = {
  constructor: Dispatch,
  on: function(typename, callback) {
    var _ = this._, T = parseTypenames$1(typename + "", _), t, i = -1, n = T.length;
    if (arguments.length < 2) {
      while (++i < n)
        if ((t = (typename = T[i]).type) && (t = get$1(_[t], typename.name)))
          return t;
      return;
    }
    if (callback != null && typeof callback !== "function")
      throw new Error("invalid callback: " + callback);
    while (++i < n) {
      if (t = (typename = T[i]).type)
        _[t] = set$1(_[t], typename.name, callback);
      else if (callback == null)
        for (t in _)
          _[t] = set$1(_[t], typename.name, null);
    }
    return this;
  },
  copy: function() {
    var copy = {}, _ = this._;
    for (var t in _)
      copy[t] = _[t].slice();
    return new Dispatch(copy);
  },
  call: function(type, that) {
    if ((n = arguments.length - 2) > 0)
      for (var args = new Array(n), i = 0, n, t; i < n; ++i)
        args[i] = arguments[i + 2];
    if (!this._.hasOwnProperty(type))
      throw new Error("unknown type: " + type);
    for (t = this._[type], i = 0, n = t.length; i < n; ++i)
      t[i].value.apply(that, args);
  },
  apply: function(type, that, args) {
    if (!this._.hasOwnProperty(type))
      throw new Error("unknown type: " + type);
    for (var t = this._[type], i = 0, n = t.length; i < n; ++i)
      t[i].value.apply(that, args);
  }
};
function get$1(type, name) {
  for (var i = 0, n = type.length, c; i < n; ++i) {
    if ((c = type[i]).name === name) {
      return c.value;
    }
  }
}
function set$1(type, name, callback) {
  for (var i = 0, n = type.length; i < n; ++i) {
    if (type[i].name === name) {
      type[i] = noop, type = type.slice(0, i).concat(type.slice(i + 1));
      break;
    }
  }
  if (callback != null)
    type.push({ name, value: callback });
  return type;
}
var xhtml = "http://www.w3.org/1999/xhtml";
var namespaces = {
  svg: "http://www.w3.org/2000/svg",
  xhtml,
  xlink: "http://www.w3.org/1999/xlink",
  xml: "http://www.w3.org/XML/1998/namespace",
  xmlns: "http://www.w3.org/2000/xmlns/"
};
function namespace(name) {
  var prefix = name += "", i = prefix.indexOf(":");
  if (i >= 0 && (prefix = name.slice(0, i)) !== "xmlns")
    name = name.slice(i + 1);
  return namespaces.hasOwnProperty(prefix) ? { space: namespaces[prefix], local: name } : name;
}
function creatorInherit(name) {
  return function() {
    var document2 = this.ownerDocument, uri = this.namespaceURI;
    return uri === xhtml && document2.documentElement.namespaceURI === xhtml ? document2.createElement(name) : document2.createElementNS(uri, name);
  };
}
function creatorFixed(fullname) {
  return function() {
    return this.ownerDocument.createElementNS(fullname.space, fullname.local);
  };
}
function creator(name) {
  var fullname = namespace(name);
  return (fullname.local ? creatorFixed : creatorInherit)(fullname);
}
function none() {
}
function selector(selector2) {
  return selector2 == null ? none : function() {
    return this.querySelector(selector2);
  };
}
function selection_select(select2) {
  if (typeof select2 !== "function")
    select2 = selector(select2);
  for (var groups = this._groups, m = groups.length, subgroups = new Array(m), j = 0; j < m; ++j) {
    for (var group = groups[j], n = group.length, subgroup = subgroups[j] = new Array(n), node, subnode, i = 0; i < n; ++i) {
      if ((node = group[i]) && (subnode = select2.call(node, node.__data__, i, group))) {
        if ("__data__" in node)
          subnode.__data__ = node.__data__;
        subgroup[i] = subnode;
      }
    }
  }
  return new Selection$1(subgroups, this._parents);
}
function array(x) {
  return x == null ? [] : Array.isArray(x) ? x : Array.from(x);
}
function empty() {
  return [];
}
function selectorAll(selector2) {
  return selector2 == null ? empty : function() {
    return this.querySelectorAll(selector2);
  };
}
function arrayAll(select2) {
  return function() {
    return array(select2.apply(this, arguments));
  };
}
function selection_selectAll(select2) {
  if (typeof select2 === "function")
    select2 = arrayAll(select2);
  else
    select2 = selectorAll(select2);
  for (var groups = this._groups, m = groups.length, subgroups = [], parents = [], j = 0; j < m; ++j) {
    for (var group = groups[j], n = group.length, node, i = 0; i < n; ++i) {
      if (node = group[i]) {
        subgroups.push(select2.call(node, node.__data__, i, group));
        parents.push(node);
      }
    }
  }
  return new Selection$1(subgroups, parents);
}
function matcher(selector2) {
  return function() {
    return this.matches(selector2);
  };
}
function childMatcher(selector2) {
  return function(node) {
    return node.matches(selector2);
  };
}
var find = Array.prototype.find;
function childFind(match) {
  return function() {
    return find.call(this.children, match);
  };
}
function childFirst() {
  return this.firstElementChild;
}
function selection_selectChild(match) {
  return this.select(match == null ? childFirst : childFind(typeof match === "function" ? match : childMatcher(match)));
}
var filter = Array.prototype.filter;
function children() {
  return Array.from(this.children);
}
function childrenFilter(match) {
  return function() {
    return filter.call(this.children, match);
  };
}
function selection_selectChildren(match) {
  return this.selectAll(match == null ? children : childrenFilter(typeof match === "function" ? match : childMatcher(match)));
}
function selection_filter(match) {
  if (typeof match !== "function")
    match = matcher(match);
  for (var groups = this._groups, m = groups.length, subgroups = new Array(m), j = 0; j < m; ++j) {
    for (var group = groups[j], n = group.length, subgroup = subgroups[j] = [], node, i = 0; i < n; ++i) {
      if ((node = group[i]) && match.call(node, node.__data__, i, group)) {
        subgroup.push(node);
      }
    }
  }
  return new Selection$1(subgroups, this._parents);
}
function sparse(update) {
  return new Array(update.length);
}
function selection_enter() {
  return new Selection$1(this._enter || this._groups.map(sparse), this._parents);
}
function EnterNode(parent, datum2) {
  this.ownerDocument = parent.ownerDocument;
  this.namespaceURI = parent.namespaceURI;
  this._next = null;
  this._parent = parent;
  this.__data__ = datum2;
}
EnterNode.prototype = {
  constructor: EnterNode,
  appendChild: function(child) {
    return this._parent.insertBefore(child, this._next);
  },
  insertBefore: function(child, next) {
    return this._parent.insertBefore(child, next);
  },
  querySelector: function(selector2) {
    return this._parent.querySelector(selector2);
  },
  querySelectorAll: function(selector2) {
    return this._parent.querySelectorAll(selector2);
  }
};
function constant$3(x) {
  return function() {
    return x;
  };
}
function bindIndex(parent, group, enter, update, exit, data) {
  var i = 0, node, groupLength = group.length, dataLength = data.length;
  for (; i < dataLength; ++i) {
    if (node = group[i]) {
      node.__data__ = data[i];
      update[i] = node;
    } else {
      enter[i] = new EnterNode(parent, data[i]);
    }
  }
  for (; i < groupLength; ++i) {
    if (node = group[i]) {
      exit[i] = node;
    }
  }
}
function bindKey(parent, group, enter, update, exit, data, key) {
  var i, node, nodeByKeyValue = /* @__PURE__ */ new Map(), groupLength = group.length, dataLength = data.length, keyValues = new Array(groupLength), keyValue;
  for (i = 0; i < groupLength; ++i) {
    if (node = group[i]) {
      keyValues[i] = keyValue = key.call(node, node.__data__, i, group) + "";
      if (nodeByKeyValue.has(keyValue)) {
        exit[i] = node;
      } else {
        nodeByKeyValue.set(keyValue, node);
      }
    }
  }
  for (i = 0; i < dataLength; ++i) {
    keyValue = key.call(parent, data[i], i, data) + "";
    if (node = nodeByKeyValue.get(keyValue)) {
      update[i] = node;
      node.__data__ = data[i];
      nodeByKeyValue.delete(keyValue);
    } else {
      enter[i] = new EnterNode(parent, data[i]);
    }
  }
  for (i = 0; i < groupLength; ++i) {
    if ((node = group[i]) && nodeByKeyValue.get(keyValues[i]) === node) {
      exit[i] = node;
    }
  }
}
function datum(node) {
  return node.__data__;
}
function selection_data(value, key) {
  if (!arguments.length)
    return Array.from(this, datum);
  var bind = key ? bindKey : bindIndex, parents = this._parents, groups = this._groups;
  if (typeof value !== "function")
    value = constant$3(value);
  for (var m = groups.length, update = new Array(m), enter = new Array(m), exit = new Array(m), j = 0; j < m; ++j) {
    var parent = parents[j], group = groups[j], groupLength = group.length, data = arraylike(value.call(parent, parent && parent.__data__, j, parents)), dataLength = data.length, enterGroup = enter[j] = new Array(dataLength), updateGroup = update[j] = new Array(dataLength), exitGroup = exit[j] = new Array(groupLength);
    bind(parent, group, enterGroup, updateGroup, exitGroup, data, key);
    for (var i0 = 0, i1 = 0, previous, next; i0 < dataLength; ++i0) {
      if (previous = enterGroup[i0]) {
        if (i0 >= i1)
          i1 = i0 + 1;
        while (!(next = updateGroup[i1]) && ++i1 < dataLength)
          ;
        previous._next = next || null;
      }
    }
  }
  update = new Selection$1(update, parents);
  update._enter = enter;
  update._exit = exit;
  return update;
}
function arraylike(data) {
  return typeof data === "object" && "length" in data ? data : Array.from(data);
}
function selection_exit() {
  return new Selection$1(this._exit || this._groups.map(sparse), this._parents);
}
function selection_join(onenter, onupdate, onexit) {
  var enter = this.enter(), update = this, exit = this.exit();
  if (typeof onenter === "function") {
    enter = onenter(enter);
    if (enter)
      enter = enter.selection();
  } else {
    enter = enter.append(onenter + "");
  }
  if (onupdate != null) {
    update = onupdate(update);
    if (update)
      update = update.selection();
  }
  if (onexit == null)
    exit.remove();
  else
    onexit(exit);
  return enter && update ? enter.merge(update).order() : update;
}
function selection_merge(context) {
  var selection2 = context.selection ? context.selection() : context;
  for (var groups0 = this._groups, groups1 = selection2._groups, m0 = groups0.length, m1 = groups1.length, m = Math.min(m0, m1), merges = new Array(m0), j = 0; j < m; ++j) {
    for (var group0 = groups0[j], group1 = groups1[j], n = group0.length, merge = merges[j] = new Array(n), node, i = 0; i < n; ++i) {
      if (node = group0[i] || group1[i]) {
        merge[i] = node;
      }
    }
  }
  for (; j < m0; ++j) {
    merges[j] = groups0[j];
  }
  return new Selection$1(merges, this._parents);
}
function selection_order() {
  for (var groups = this._groups, j = -1, m = groups.length; ++j < m; ) {
    for (var group = groups[j], i = group.length - 1, next = group[i], node; --i >= 0; ) {
      if (node = group[i]) {
        if (next && node.compareDocumentPosition(next) ^ 4)
          next.parentNode.insertBefore(node, next);
        next = node;
      }
    }
  }
  return this;
}
function selection_sort(compare) {
  if (!compare)
    compare = ascending;
  function compareNode(a, b) {
    return a && b ? compare(a.__data__, b.__data__) : !a - !b;
  }
  for (var groups = this._groups, m = groups.length, sortgroups = new Array(m), j = 0; j < m; ++j) {
    for (var group = groups[j], n = group.length, sortgroup = sortgroups[j] = new Array(n), node, i = 0; i < n; ++i) {
      if (node = group[i]) {
        sortgroup[i] = node;
      }
    }
    sortgroup.sort(compareNode);
  }
  return new Selection$1(sortgroups, this._parents).order();
}
function ascending(a, b) {
  return a < b ? -1 : a > b ? 1 : a >= b ? 0 : NaN;
}
function selection_call() {
  var callback = arguments[0];
  arguments[0] = this;
  callback.apply(null, arguments);
  return this;
}
function selection_nodes() {
  return Array.from(this);
}
function selection_node() {
  for (var groups = this._groups, j = 0, m = groups.length; j < m; ++j) {
    for (var group = groups[j], i = 0, n = group.length; i < n; ++i) {
      var node = group[i];
      if (node)
        return node;
    }
  }
  return null;
}
function selection_size() {
  let size = 0;
  for (const node of this)
    ++size;
  return size;
}
function selection_empty() {
  return !this.node();
}
function selection_each(callback) {
  for (var groups = this._groups, j = 0, m = groups.length; j < m; ++j) {
    for (var group = groups[j], i = 0, n = group.length, node; i < n; ++i) {
      if (node = group[i])
        callback.call(node, node.__data__, i, group);
    }
  }
  return this;
}
function attrRemove$1(name) {
  return function() {
    this.removeAttribute(name);
  };
}
function attrRemoveNS$1(fullname) {
  return function() {
    this.removeAttributeNS(fullname.space, fullname.local);
  };
}
function attrConstant$1(name, value) {
  return function() {
    this.setAttribute(name, value);
  };
}
function attrConstantNS$1(fullname, value) {
  return function() {
    this.setAttributeNS(fullname.space, fullname.local, value);
  };
}
function attrFunction$1(name, value) {
  return function() {
    var v = value.apply(this, arguments);
    if (v == null)
      this.removeAttribute(name);
    else
      this.setAttribute(name, v);
  };
}
function attrFunctionNS$1(fullname, value) {
  return function() {
    var v = value.apply(this, arguments);
    if (v == null)
      this.removeAttributeNS(fullname.space, fullname.local);
    else
      this.setAttributeNS(fullname.space, fullname.local, v);
  };
}
function selection_attr(name, value) {
  var fullname = namespace(name);
  if (arguments.length < 2) {
    var node = this.node();
    return fullname.local ? node.getAttributeNS(fullname.space, fullname.local) : node.getAttribute(fullname);
  }
  return this.each((value == null ? fullname.local ? attrRemoveNS$1 : attrRemove$1 : typeof value === "function" ? fullname.local ? attrFunctionNS$1 : attrFunction$1 : fullname.local ? attrConstantNS$1 : attrConstant$1)(fullname, value));
}
function defaultView(node) {
  return node.ownerDocument && node.ownerDocument.defaultView || node.document && node || node.defaultView;
}
function styleRemove$1(name) {
  return function() {
    this.style.removeProperty(name);
  };
}
function styleConstant$1(name, value, priority) {
  return function() {
    this.style.setProperty(name, value, priority);
  };
}
function styleFunction$1(name, value, priority) {
  return function() {
    var v = value.apply(this, arguments);
    if (v == null)
      this.style.removeProperty(name);
    else
      this.style.setProperty(name, v, priority);
  };
}
function selection_style(name, value, priority) {
  return arguments.length > 1 ? this.each((value == null ? styleRemove$1 : typeof value === "function" ? styleFunction$1 : styleConstant$1)(name, value, priority == null ? "" : priority)) : styleValue(this.node(), name);
}
function styleValue(node, name) {
  return node.style.getPropertyValue(name) || defaultView(node).getComputedStyle(node, null).getPropertyValue(name);
}
function propertyRemove(name) {
  return function() {
    delete this[name];
  };
}
function propertyConstant(name, value) {
  return function() {
    this[name] = value;
  };
}
function propertyFunction(name, value) {
  return function() {
    var v = value.apply(this, arguments);
    if (v == null)
      delete this[name];
    else
      this[name] = v;
  };
}
function selection_property(name, value) {
  return arguments.length > 1 ? this.each((value == null ? propertyRemove : typeof value === "function" ? propertyFunction : propertyConstant)(name, value)) : this.node()[name];
}
function classArray(string) {
  return string.trim().split(/^|\s+/);
}
function classList(node) {
  return node.classList || new ClassList(node);
}
function ClassList(node) {
  this._node = node;
  this._names = classArray(node.getAttribute("class") || "");
}
ClassList.prototype = {
  add: function(name) {
    var i = this._names.indexOf(name);
    if (i < 0) {
      this._names.push(name);
      this._node.setAttribute("class", this._names.join(" "));
    }
  },
  remove: function(name) {
    var i = this._names.indexOf(name);
    if (i >= 0) {
      this._names.splice(i, 1);
      this._node.setAttribute("class", this._names.join(" "));
    }
  },
  contains: function(name) {
    return this._names.indexOf(name) >= 0;
  }
};
function classedAdd(node, names) {
  var list = classList(node), i = -1, n = names.length;
  while (++i < n)
    list.add(names[i]);
}
function classedRemove(node, names) {
  var list = classList(node), i = -1, n = names.length;
  while (++i < n)
    list.remove(names[i]);
}
function classedTrue(names) {
  return function() {
    classedAdd(this, names);
  };
}
function classedFalse(names) {
  return function() {
    classedRemove(this, names);
  };
}
function classedFunction(names, value) {
  return function() {
    (value.apply(this, arguments) ? classedAdd : classedRemove)(this, names);
  };
}
function selection_classed(name, value) {
  var names = classArray(name + "");
  if (arguments.length < 2) {
    var list = classList(this.node()), i = -1, n = names.length;
    while (++i < n)
      if (!list.contains(names[i]))
        return false;
    return true;
  }
  return this.each((typeof value === "function" ? classedFunction : value ? classedTrue : classedFalse)(names, value));
}
function textRemove() {
  this.textContent = "";
}
function textConstant$1(value) {
  return function() {
    this.textContent = value;
  };
}
function textFunction$1(value) {
  return function() {
    var v = value.apply(this, arguments);
    this.textContent = v == null ? "" : v;
  };
}
function selection_text(value) {
  return arguments.length ? this.each(value == null ? textRemove : (typeof value === "function" ? textFunction$1 : textConstant$1)(value)) : this.node().textContent;
}
function htmlRemove() {
  this.innerHTML = "";
}
function htmlConstant(value) {
  return function() {
    this.innerHTML = value;
  };
}
function htmlFunction(value) {
  return function() {
    var v = value.apply(this, arguments);
    this.innerHTML = v == null ? "" : v;
  };
}
function selection_html(value) {
  return arguments.length ? this.each(value == null ? htmlRemove : (typeof value === "function" ? htmlFunction : htmlConstant)(value)) : this.node().innerHTML;
}
function raise() {
  if (this.nextSibling)
    this.parentNode.appendChild(this);
}
function selection_raise() {
  return this.each(raise);
}
function lower() {
  if (this.previousSibling)
    this.parentNode.insertBefore(this, this.parentNode.firstChild);
}
function selection_lower() {
  return this.each(lower);
}
function selection_append(name) {
  var create2 = typeof name === "function" ? name : creator(name);
  return this.select(function() {
    return this.appendChild(create2.apply(this, arguments));
  });
}
function constantNull() {
  return null;
}
function selection_insert(name, before) {
  var create2 = typeof name === "function" ? name : creator(name), select2 = before == null ? constantNull : typeof before === "function" ? before : selector(before);
  return this.select(function() {
    return this.insertBefore(create2.apply(this, arguments), select2.apply(this, arguments) || null);
  });
}
function remove() {
  var parent = this.parentNode;
  if (parent)
    parent.removeChild(this);
}
function selection_remove() {
  return this.each(remove);
}
function selection_cloneShallow() {
  var clone = this.cloneNode(false), parent = this.parentNode;
  return parent ? parent.insertBefore(clone, this.nextSibling) : clone;
}
function selection_cloneDeep() {
  var clone = this.cloneNode(true), parent = this.parentNode;
  return parent ? parent.insertBefore(clone, this.nextSibling) : clone;
}
function selection_clone(deep) {
  return this.select(deep ? selection_cloneDeep : selection_cloneShallow);
}
function selection_datum(value) {
  return arguments.length ? this.property("__data__", value) : this.node().__data__;
}
function contextListener(listener) {
  return function(event) {
    listener.call(this, event, this.__data__);
  };
}
function parseTypenames(typenames) {
  return typenames.trim().split(/^|\s+/).map(function(t) {
    var name = "", i = t.indexOf(".");
    if (i >= 0)
      name = t.slice(i + 1), t = t.slice(0, i);
    return { type: t, name };
  });
}
function onRemove(typename) {
  return function() {
    var on = this.__on;
    if (!on)
      return;
    for (var j = 0, i = -1, m = on.length, o; j < m; ++j) {
      if (o = on[j], (!typename.type || o.type === typename.type) && o.name === typename.name) {
        this.removeEventListener(o.type, o.listener, o.options);
      } else {
        on[++i] = o;
      }
    }
    if (++i)
      on.length = i;
    else
      delete this.__on;
  };
}
function onAdd(typename, value, options) {
  return function() {
    var on = this.__on, o, listener = contextListener(value);
    if (on)
      for (var j = 0, m = on.length; j < m; ++j) {
        if ((o = on[j]).type === typename.type && o.name === typename.name) {
          this.removeEventListener(o.type, o.listener, o.options);
          this.addEventListener(o.type, o.listener = listener, o.options = options);
          o.value = value;
          return;
        }
      }
    this.addEventListener(typename.type, listener, options);
    o = { type: typename.type, name: typename.name, value, listener, options };
    if (!on)
      this.__on = [o];
    else
      on.push(o);
  };
}
function selection_on(typename, value, options) {
  var typenames = parseTypenames(typename + ""), i, n = typenames.length, t;
  if (arguments.length < 2) {
    var on = this.node().__on;
    if (on)
      for (var j = 0, m = on.length, o; j < m; ++j) {
        for (i = 0, o = on[j]; i < n; ++i) {
          if ((t = typenames[i]).type === o.type && t.name === o.name) {
            return o.value;
          }
        }
      }
    return;
  }
  on = value ? onAdd : onRemove;
  for (i = 0; i < n; ++i)
    this.each(on(typenames[i], value, options));
  return this;
}
function dispatchEvent(node, type, params) {
  var window2 = defaultView(node), event = window2.CustomEvent;
  if (typeof event === "function") {
    event = new event(type, params);
  } else {
    event = window2.document.createEvent("Event");
    if (params)
      event.initEvent(type, params.bubbles, params.cancelable), event.detail = params.detail;
    else
      event.initEvent(type, false, false);
  }
  node.dispatchEvent(event);
}
function dispatchConstant(type, params) {
  return function() {
    return dispatchEvent(this, type, params);
  };
}
function dispatchFunction(type, params) {
  return function() {
    return dispatchEvent(this, type, params.apply(this, arguments));
  };
}
function selection_dispatch(type, params) {
  return this.each((typeof params === "function" ? dispatchFunction : dispatchConstant)(type, params));
}
function* selection_iterator() {
  for (var groups = this._groups, j = 0, m = groups.length; j < m; ++j) {
    for (var group = groups[j], i = 0, n = group.length, node; i < n; ++i) {
      if (node = group[i])
        yield node;
    }
  }
}
var root = [null];
function Selection$1(groups, parents) {
  this._groups = groups;
  this._parents = parents;
}
function selection() {
  return new Selection$1([[document.documentElement]], root);
}
function selection_selection() {
  return this;
}
Selection$1.prototype = selection.prototype = {
  constructor: Selection$1,
  select: selection_select,
  selectAll: selection_selectAll,
  selectChild: selection_selectChild,
  selectChildren: selection_selectChildren,
  filter: selection_filter,
  data: selection_data,
  enter: selection_enter,
  exit: selection_exit,
  join: selection_join,
  merge: selection_merge,
  selection: selection_selection,
  order: selection_order,
  sort: selection_sort,
  call: selection_call,
  nodes: selection_nodes,
  node: selection_node,
  size: selection_size,
  empty: selection_empty,
  each: selection_each,
  attr: selection_attr,
  style: selection_style,
  property: selection_property,
  classed: selection_classed,
  text: selection_text,
  html: selection_html,
  raise: selection_raise,
  lower: selection_lower,
  append: selection_append,
  insert: selection_insert,
  remove: selection_remove,
  clone: selection_clone,
  datum: selection_datum,
  on: selection_on,
  dispatch: selection_dispatch,
  [Symbol.iterator]: selection_iterator
};
function select(selector2) {
  return typeof selector2 === "string" ? new Selection$1([[document.querySelector(selector2)]], [document.documentElement]) : new Selection$1([[selector2]], root);
}
function sourceEvent(event) {
  let sourceEvent2;
  while (sourceEvent2 = event.sourceEvent)
    event = sourceEvent2;
  return event;
}
function pointer(event, node) {
  event = sourceEvent(event);
  if (node === void 0)
    node = event.currentTarget;
  if (node) {
    var svg = node.ownerSVGElement || node;
    if (svg.createSVGPoint) {
      var point = svg.createSVGPoint();
      point.x = event.clientX, point.y = event.clientY;
      point = point.matrixTransform(node.getScreenCTM().inverse());
      return [point.x, point.y];
    }
    if (node.getBoundingClientRect) {
      var rect = node.getBoundingClientRect();
      return [event.clientX - rect.left - node.clientLeft, event.clientY - rect.top - node.clientTop];
    }
  }
  return [event.pageX, event.pageY];
}
const nonpassive = { passive: false };
const nonpassivecapture = { capture: true, passive: false };
function nopropagation$1(event) {
  event.stopImmediatePropagation();
}
function noevent$1(event) {
  event.preventDefault();
  event.stopImmediatePropagation();
}
function dragDisable(view) {
  var root2 = view.document.documentElement, selection2 = select(view).on("dragstart.drag", noevent$1, nonpassivecapture);
  if ("onselectstart" in root2) {
    selection2.on("selectstart.drag", noevent$1, nonpassivecapture);
  } else {
    root2.__noselect = root2.style.MozUserSelect;
    root2.style.MozUserSelect = "none";
  }
}
function yesdrag(view, noclick) {
  var root2 = view.document.documentElement, selection2 = select(view).on("dragstart.drag", null);
  if (noclick) {
    selection2.on("click.drag", noevent$1, nonpassivecapture);
    setTimeout(function() {
      selection2.on("click.drag", null);
    }, 0);
  }
  if ("onselectstart" in root2) {
    selection2.on("selectstart.drag", null);
  } else {
    root2.style.MozUserSelect = root2.__noselect;
    delete root2.__noselect;
  }
}
var constant$2 = (x) => () => x;
function DragEvent(type, {
  sourceEvent: sourceEvent2,
  subject,
  target,
  identifier,
  active,
  x,
  y,
  dx,
  dy,
  dispatch: dispatch2
}) {
  Object.defineProperties(this, {
    type: { value: type, enumerable: true, configurable: true },
    sourceEvent: { value: sourceEvent2, enumerable: true, configurable: true },
    subject: { value: subject, enumerable: true, configurable: true },
    target: { value: target, enumerable: true, configurable: true },
    identifier: { value: identifier, enumerable: true, configurable: true },
    active: { value: active, enumerable: true, configurable: true },
    x: { value: x, enumerable: true, configurable: true },
    y: { value: y, enumerable: true, configurable: true },
    dx: { value: dx, enumerable: true, configurable: true },
    dy: { value: dy, enumerable: true, configurable: true },
    _: { value: dispatch2 }
  });
}
DragEvent.prototype.on = function() {
  var value = this._.on.apply(this._, arguments);
  return value === this._ ? this : value;
};
function defaultFilter$1(event) {
  return !event.ctrlKey && !event.button;
}
function defaultContainer() {
  return this.parentNode;
}
function defaultSubject(event, d) {
  return d == null ? { x: event.x, y: event.y } : d;
}
function defaultTouchable$1() {
  return navigator.maxTouchPoints || "ontouchstart" in this;
}
function drag() {
  var filter2 = defaultFilter$1, container = defaultContainer, subject = defaultSubject, touchable = defaultTouchable$1, gestures = {}, listeners = dispatch("start", "drag", "end"), active = 0, mousedownx, mousedowny, mousemoving, touchending, clickDistance2 = 0;
  function drag2(selection2) {
    selection2.on("mousedown.drag", mousedowned).filter(touchable).on("touchstart.drag", touchstarted).on("touchmove.drag", touchmoved, nonpassive).on("touchend.drag touchcancel.drag", touchended).style("touch-action", "none").style("-webkit-tap-highlight-color", "rgba(0,0,0,0)");
  }
  function mousedowned(event, d) {
    if (touchending || !filter2.call(this, event, d))
      return;
    var gesture = beforestart(this, container.call(this, event, d), event, d, "mouse");
    if (!gesture)
      return;
    select(event.view).on("mousemove.drag", mousemoved, nonpassivecapture).on("mouseup.drag", mouseupped, nonpassivecapture);
    dragDisable(event.view);
    nopropagation$1(event);
    mousemoving = false;
    mousedownx = event.clientX;
    mousedowny = event.clientY;
    gesture("start", event);
  }
  function mousemoved(event) {
    noevent$1(event);
    if (!mousemoving) {
      var dx = event.clientX - mousedownx, dy = event.clientY - mousedowny;
      mousemoving = dx * dx + dy * dy > clickDistance2;
    }
    gestures.mouse("drag", event);
  }
  function mouseupped(event) {
    select(event.view).on("mousemove.drag mouseup.drag", null);
    yesdrag(event.view, mousemoving);
    noevent$1(event);
    gestures.mouse("end", event);
  }
  function touchstarted(event, d) {
    if (!filter2.call(this, event, d))
      return;
    var touches = event.changedTouches, c = container.call(this, event, d), n = touches.length, i, gesture;
    for (i = 0; i < n; ++i) {
      if (gesture = beforestart(this, c, event, d, touches[i].identifier, touches[i])) {
        nopropagation$1(event);
        gesture("start", event, touches[i]);
      }
    }
  }
  function touchmoved(event) {
    var touches = event.changedTouches, n = touches.length, i, gesture;
    for (i = 0; i < n; ++i) {
      if (gesture = gestures[touches[i].identifier]) {
        noevent$1(event);
        gesture("drag", event, touches[i]);
      }
    }
  }
  function touchended(event) {
    var touches = event.changedTouches, n = touches.length, i, gesture;
    if (touchending)
      clearTimeout(touchending);
    touchending = setTimeout(function() {
      touchending = null;
    }, 500);
    for (i = 0; i < n; ++i) {
      if (gesture = gestures[touches[i].identifier]) {
        nopropagation$1(event);
        gesture("end", event, touches[i]);
      }
    }
  }
  function beforestart(that, container2, event, d, identifier, touch) {
    var dispatch2 = listeners.copy(), p = pointer(touch || event, container2), dx, dy, s;
    if ((s = subject.call(that, new DragEvent("beforestart", {
      sourceEvent: event,
      target: drag2,
      identifier,
      active,
      x: p[0],
      y: p[1],
      dx: 0,
      dy: 0,
      dispatch: dispatch2
    }), d)) == null)
      return;
    dx = s.x - p[0] || 0;
    dy = s.y - p[1] || 0;
    return function gesture(type, event2, touch2) {
      var p0 = p, n;
      switch (type) {
        case "start":
          gestures[identifier] = gesture, n = active++;
          break;
        case "end":
          delete gestures[identifier], --active;
        case "drag":
          p = pointer(touch2 || event2, container2), n = active;
          break;
      }
      dispatch2.call(
        type,
        that,
        new DragEvent(type, {
          sourceEvent: event2,
          subject: s,
          target: drag2,
          identifier,
          active: n,
          x: p[0] + dx,
          y: p[1] + dy,
          dx: p[0] - p0[0],
          dy: p[1] - p0[1],
          dispatch: dispatch2
        }),
        d
      );
    };
  }
  drag2.filter = function(_) {
    return arguments.length ? (filter2 = typeof _ === "function" ? _ : constant$2(!!_), drag2) : filter2;
  };
  drag2.container = function(_) {
    return arguments.length ? (container = typeof _ === "function" ? _ : constant$2(_), drag2) : container;
  };
  drag2.subject = function(_) {
    return arguments.length ? (subject = typeof _ === "function" ? _ : constant$2(_), drag2) : subject;
  };
  drag2.touchable = function(_) {
    return arguments.length ? (touchable = typeof _ === "function" ? _ : constant$2(!!_), drag2) : touchable;
  };
  drag2.on = function() {
    var value = listeners.on.apply(listeners, arguments);
    return value === listeners ? drag2 : value;
  };
  drag2.clickDistance = function(_) {
    return arguments.length ? (clickDistance2 = (_ = +_) * _, drag2) : Math.sqrt(clickDistance2);
  };
  return drag2;
}
function define(constructor, factory, prototype) {
  constructor.prototype = factory.prototype = prototype;
  prototype.constructor = constructor;
}
function extend(parent, definition) {
  var prototype = Object.create(parent.prototype);
  for (var key in definition)
    prototype[key] = definition[key];
  return prototype;
}
function Color() {
}
var darker = 0.7;
var brighter = 1 / darker;
var reI = "\\s*([+-]?\\d+)\\s*", reN = "\\s*([+-]?(?:\\d*\\.)?\\d+(?:[eE][+-]?\\d+)?)\\s*", reP = "\\s*([+-]?(?:\\d*\\.)?\\d+(?:[eE][+-]?\\d+)?)%\\s*", reHex = /^#([0-9a-f]{3,8})$/, reRgbInteger = new RegExp(`^rgb\\(${reI},${reI},${reI}\\)$`), reRgbPercent = new RegExp(`^rgb\\(${reP},${reP},${reP}\\)$`), reRgbaInteger = new RegExp(`^rgba\\(${reI},${reI},${reI},${reN}\\)$`), reRgbaPercent = new RegExp(`^rgba\\(${reP},${reP},${reP},${reN}\\)$`), reHslPercent = new RegExp(`^hsl\\(${reN},${reP},${reP}\\)$`), reHslaPercent = new RegExp(`^hsla\\(${reN},${reP},${reP},${reN}\\)$`);
var named = {
  aliceblue: 15792383,
  antiquewhite: 16444375,
  aqua: 65535,
  aquamarine: 8388564,
  azure: 15794175,
  beige: 16119260,
  bisque: 16770244,
  black: 0,
  blanchedalmond: 16772045,
  blue: 255,
  blueviolet: 9055202,
  brown: 10824234,
  burlywood: 14596231,
  cadetblue: 6266528,
  chartreuse: 8388352,
  chocolate: 13789470,
  coral: 16744272,
  cornflowerblue: 6591981,
  cornsilk: 16775388,
  crimson: 14423100,
  cyan: 65535,
  darkblue: 139,
  darkcyan: 35723,
  darkgoldenrod: 12092939,
  darkgray: 11119017,
  darkgreen: 25600,
  darkgrey: 11119017,
  darkkhaki: 12433259,
  darkmagenta: 9109643,
  darkolivegreen: 5597999,
  darkorange: 16747520,
  darkorchid: 10040012,
  darkred: 9109504,
  darksalmon: 15308410,
  darkseagreen: 9419919,
  darkslateblue: 4734347,
  darkslategray: 3100495,
  darkslategrey: 3100495,
  darkturquoise: 52945,
  darkviolet: 9699539,
  deeppink: 16716947,
  deepskyblue: 49151,
  dimgray: 6908265,
  dimgrey: 6908265,
  dodgerblue: 2003199,
  firebrick: 11674146,
  floralwhite: 16775920,
  forestgreen: 2263842,
  fuchsia: 16711935,
  gainsboro: 14474460,
  ghostwhite: 16316671,
  gold: 16766720,
  goldenrod: 14329120,
  gray: 8421504,
  green: 32768,
  greenyellow: 11403055,
  grey: 8421504,
  honeydew: 15794160,
  hotpink: 16738740,
  indianred: 13458524,
  indigo: 4915330,
  ivory: 16777200,
  khaki: 15787660,
  lavender: 15132410,
  lavenderblush: 16773365,
  lawngreen: 8190976,
  lemonchiffon: 16775885,
  lightblue: 11393254,
  lightcoral: 15761536,
  lightcyan: 14745599,
  lightgoldenrodyellow: 16448210,
  lightgray: 13882323,
  lightgreen: 9498256,
  lightgrey: 13882323,
  lightpink: 16758465,
  lightsalmon: 16752762,
  lightseagreen: 2142890,
  lightskyblue: 8900346,
  lightslategray: 7833753,
  lightslategrey: 7833753,
  lightsteelblue: 11584734,
  lightyellow: 16777184,
  lime: 65280,
  limegreen: 3329330,
  linen: 16445670,
  magenta: 16711935,
  maroon: 8388608,
  mediumaquamarine: 6737322,
  mediumblue: 205,
  mediumorchid: 12211667,
  mediumpurple: 9662683,
  mediumseagreen: 3978097,
  mediumslateblue: 8087790,
  mediumspringgreen: 64154,
  mediumturquoise: 4772300,
  mediumvioletred: 13047173,
  midnightblue: 1644912,
  mintcream: 16121850,
  mistyrose: 16770273,
  moccasin: 16770229,
  navajowhite: 16768685,
  navy: 128,
  oldlace: 16643558,
  olive: 8421376,
  olivedrab: 7048739,
  orange: 16753920,
  orangered: 16729344,
  orchid: 14315734,
  palegoldenrod: 15657130,
  palegreen: 10025880,
  paleturquoise: 11529966,
  palevioletred: 14381203,
  papayawhip: 16773077,
  peachpuff: 16767673,
  peru: 13468991,
  pink: 16761035,
  plum: 14524637,
  powderblue: 11591910,
  purple: 8388736,
  rebeccapurple: 6697881,
  red: 16711680,
  rosybrown: 12357519,
  royalblue: 4286945,
  saddlebrown: 9127187,
  salmon: 16416882,
  sandybrown: 16032864,
  seagreen: 3050327,
  seashell: 16774638,
  sienna: 10506797,
  silver: 12632256,
  skyblue: 8900331,
  slateblue: 6970061,
  slategray: 7372944,
  slategrey: 7372944,
  snow: 16775930,
  springgreen: 65407,
  steelblue: 4620980,
  tan: 13808780,
  teal: 32896,
  thistle: 14204888,
  tomato: 16737095,
  turquoise: 4251856,
  violet: 15631086,
  wheat: 16113331,
  white: 16777215,
  whitesmoke: 16119285,
  yellow: 16776960,
  yellowgreen: 10145074
};
define(Color, color, {
  copy(channels) {
    return Object.assign(new this.constructor(), this, channels);
  },
  displayable() {
    return this.rgb().displayable();
  },
  hex: color_formatHex,
  formatHex: color_formatHex,
  formatHex8: color_formatHex8,
  formatHsl: color_formatHsl,
  formatRgb: color_formatRgb,
  toString: color_formatRgb
});
function color_formatHex() {
  return this.rgb().formatHex();
}
function color_formatHex8() {
  return this.rgb().formatHex8();
}
function color_formatHsl() {
  return hslConvert(this).formatHsl();
}
function color_formatRgb() {
  return this.rgb().formatRgb();
}
function color(format) {
  var m, l;
  format = (format + "").trim().toLowerCase();
  return (m = reHex.exec(format)) ? (l = m[1].length, m = parseInt(m[1], 16), l === 6 ? rgbn(m) : l === 3 ? new Rgb(m >> 8 & 15 | m >> 4 & 240, m >> 4 & 15 | m & 240, (m & 15) << 4 | m & 15, 1) : l === 8 ? rgba(m >> 24 & 255, m >> 16 & 255, m >> 8 & 255, (m & 255) / 255) : l === 4 ? rgba(m >> 12 & 15 | m >> 8 & 240, m >> 8 & 15 | m >> 4 & 240, m >> 4 & 15 | m & 240, ((m & 15) << 4 | m & 15) / 255) : null) : (m = reRgbInteger.exec(format)) ? new Rgb(m[1], m[2], m[3], 1) : (m = reRgbPercent.exec(format)) ? new Rgb(m[1] * 255 / 100, m[2] * 255 / 100, m[3] * 255 / 100, 1) : (m = reRgbaInteger.exec(format)) ? rgba(m[1], m[2], m[3], m[4]) : (m = reRgbaPercent.exec(format)) ? rgba(m[1] * 255 / 100, m[2] * 255 / 100, m[3] * 255 / 100, m[4]) : (m = reHslPercent.exec(format)) ? hsla(m[1], m[2] / 100, m[3] / 100, 1) : (m = reHslaPercent.exec(format)) ? hsla(m[1], m[2] / 100, m[3] / 100, m[4]) : named.hasOwnProperty(format) ? rgbn(named[format]) : format === "transparent" ? new Rgb(NaN, NaN, NaN, 0) : null;
}
function rgbn(n) {
  return new Rgb(n >> 16 & 255, n >> 8 & 255, n & 255, 1);
}
function rgba(r, g, b, a) {
  if (a <= 0)
    r = g = b = NaN;
  return new Rgb(r, g, b, a);
}
function rgbConvert(o) {
  if (!(o instanceof Color))
    o = color(o);
  if (!o)
    return new Rgb();
  o = o.rgb();
  return new Rgb(o.r, o.g, o.b, o.opacity);
}
function rgb(r, g, b, opacity) {
  return arguments.length === 1 ? rgbConvert(r) : new Rgb(r, g, b, opacity == null ? 1 : opacity);
}
function Rgb(r, g, b, opacity) {
  this.r = +r;
  this.g = +g;
  this.b = +b;
  this.opacity = +opacity;
}
define(Rgb, rgb, extend(Color, {
  brighter(k) {
    k = k == null ? brighter : Math.pow(brighter, k);
    return new Rgb(this.r * k, this.g * k, this.b * k, this.opacity);
  },
  darker(k) {
    k = k == null ? darker : Math.pow(darker, k);
    return new Rgb(this.r * k, this.g * k, this.b * k, this.opacity);
  },
  rgb() {
    return this;
  },
  clamp() {
    return new Rgb(clampi(this.r), clampi(this.g), clampi(this.b), clampa(this.opacity));
  },
  displayable() {
    return -0.5 <= this.r && this.r < 255.5 && (-0.5 <= this.g && this.g < 255.5) && (-0.5 <= this.b && this.b < 255.5) && (0 <= this.opacity && this.opacity <= 1);
  },
  hex: rgb_formatHex,
  formatHex: rgb_formatHex,
  formatHex8: rgb_formatHex8,
  formatRgb: rgb_formatRgb,
  toString: rgb_formatRgb
}));
function rgb_formatHex() {
  return `#${hex(this.r)}${hex(this.g)}${hex(this.b)}`;
}
function rgb_formatHex8() {
  return `#${hex(this.r)}${hex(this.g)}${hex(this.b)}${hex((isNaN(this.opacity) ? 1 : this.opacity) * 255)}`;
}
function rgb_formatRgb() {
  const a = clampa(this.opacity);
  return `${a === 1 ? "rgb(" : "rgba("}${clampi(this.r)}, ${clampi(this.g)}, ${clampi(this.b)}${a === 1 ? ")" : `, ${a})`}`;
}
function clampa(opacity) {
  return isNaN(opacity) ? 1 : Math.max(0, Math.min(1, opacity));
}
function clampi(value) {
  return Math.max(0, Math.min(255, Math.round(value) || 0));
}
function hex(value) {
  value = clampi(value);
  return (value < 16 ? "0" : "") + value.toString(16);
}
function hsla(h2, s, l, a) {
  if (a <= 0)
    h2 = s = l = NaN;
  else if (l <= 0 || l >= 1)
    h2 = s = NaN;
  else if (s <= 0)
    h2 = NaN;
  return new Hsl(h2, s, l, a);
}
function hslConvert(o) {
  if (o instanceof Hsl)
    return new Hsl(o.h, o.s, o.l, o.opacity);
  if (!(o instanceof Color))
    o = color(o);
  if (!o)
    return new Hsl();
  if (o instanceof Hsl)
    return o;
  o = o.rgb();
  var r = o.r / 255, g = o.g / 255, b = o.b / 255, min = Math.min(r, g, b), max = Math.max(r, g, b), h2 = NaN, s = max - min, l = (max + min) / 2;
  if (s) {
    if (r === max)
      h2 = (g - b) / s + (g < b) * 6;
    else if (g === max)
      h2 = (b - r) / s + 2;
    else
      h2 = (r - g) / s + 4;
    s /= l < 0.5 ? max + min : 2 - max - min;
    h2 *= 60;
  } else {
    s = l > 0 && l < 1 ? 0 : h2;
  }
  return new Hsl(h2, s, l, o.opacity);
}
function hsl(h2, s, l, opacity) {
  return arguments.length === 1 ? hslConvert(h2) : new Hsl(h2, s, l, opacity == null ? 1 : opacity);
}
function Hsl(h2, s, l, opacity) {
  this.h = +h2;
  this.s = +s;
  this.l = +l;
  this.opacity = +opacity;
}
define(Hsl, hsl, extend(Color, {
  brighter(k) {
    k = k == null ? brighter : Math.pow(brighter, k);
    return new Hsl(this.h, this.s, this.l * k, this.opacity);
  },
  darker(k) {
    k = k == null ? darker : Math.pow(darker, k);
    return new Hsl(this.h, this.s, this.l * k, this.opacity);
  },
  rgb() {
    var h2 = this.h % 360 + (this.h < 0) * 360, s = isNaN(h2) || isNaN(this.s) ? 0 : this.s, l = this.l, m2 = l + (l < 0.5 ? l : 1 - l) * s, m1 = 2 * l - m2;
    return new Rgb(
      hsl2rgb(h2 >= 240 ? h2 - 240 : h2 + 120, m1, m2),
      hsl2rgb(h2, m1, m2),
      hsl2rgb(h2 < 120 ? h2 + 240 : h2 - 120, m1, m2),
      this.opacity
    );
  },
  clamp() {
    return new Hsl(clamph(this.h), clampt(this.s), clampt(this.l), clampa(this.opacity));
  },
  displayable() {
    return (0 <= this.s && this.s <= 1 || isNaN(this.s)) && (0 <= this.l && this.l <= 1) && (0 <= this.opacity && this.opacity <= 1);
  },
  formatHsl() {
    const a = clampa(this.opacity);
    return `${a === 1 ? "hsl(" : "hsla("}${clamph(this.h)}, ${clampt(this.s) * 100}%, ${clampt(this.l) * 100}%${a === 1 ? ")" : `, ${a})`}`;
  }
}));
function clamph(value) {
  value = (value || 0) % 360;
  return value < 0 ? value + 360 : value;
}
function clampt(value) {
  return Math.max(0, Math.min(1, value || 0));
}
function hsl2rgb(h2, m1, m2) {
  return (h2 < 60 ? m1 + (m2 - m1) * h2 / 60 : h2 < 180 ? m2 : h2 < 240 ? m1 + (m2 - m1) * (240 - h2) / 60 : m1) * 255;
}
var constant$1 = (x) => () => x;
function linear(a, d) {
  return function(t) {
    return a + t * d;
  };
}
function exponential(a, b, y) {
  return a = Math.pow(a, y), b = Math.pow(b, y) - a, y = 1 / y, function(t) {
    return Math.pow(a + t * b, y);
  };
}
function gamma(y) {
  return (y = +y) === 1 ? nogamma : function(a, b) {
    return b - a ? exponential(a, b, y) : constant$1(isNaN(a) ? b : a);
  };
}
function nogamma(a, b) {
  var d = b - a;
  return d ? linear(a, d) : constant$1(isNaN(a) ? b : a);
}
var interpolateRgb = function rgbGamma(y) {
  var color2 = gamma(y);
  function rgb$1(start2, end) {
    var r = color2((start2 = rgb(start2)).r, (end = rgb(end)).r), g = color2(start2.g, end.g), b = color2(start2.b, end.b), opacity = nogamma(start2.opacity, end.opacity);
    return function(t) {
      start2.r = r(t);
      start2.g = g(t);
      start2.b = b(t);
      start2.opacity = opacity(t);
      return start2 + "";
    };
  }
  rgb$1.gamma = rgbGamma;
  return rgb$1;
}(1);
function interpolateNumber(a, b) {
  return a = +a, b = +b, function(t) {
    return a * (1 - t) + b * t;
  };
}
var reA = /[-+]?(?:\d+\.?\d*|\.?\d+)(?:[eE][-+]?\d+)?/g, reB = new RegExp(reA.source, "g");
function zero(b) {
  return function() {
    return b;
  };
}
function one(b) {
  return function(t) {
    return b(t) + "";
  };
}
function interpolateString(a, b) {
  var bi = reA.lastIndex = reB.lastIndex = 0, am, bm, bs, i = -1, s = [], q = [];
  a = a + "", b = b + "";
  while ((am = reA.exec(a)) && (bm = reB.exec(b))) {
    if ((bs = bm.index) > bi) {
      bs = b.slice(bi, bs);
      if (s[i])
        s[i] += bs;
      else
        s[++i] = bs;
    }
    if ((am = am[0]) === (bm = bm[0])) {
      if (s[i])
        s[i] += bm;
      else
        s[++i] = bm;
    } else {
      s[++i] = null;
      q.push({ i, x: interpolateNumber(am, bm) });
    }
    bi = reB.lastIndex;
  }
  if (bi < b.length) {
    bs = b.slice(bi);
    if (s[i])
      s[i] += bs;
    else
      s[++i] = bs;
  }
  return s.length < 2 ? q[0] ? one(q[0].x) : zero(b) : (b = q.length, function(t) {
    for (var i2 = 0, o; i2 < b; ++i2)
      s[(o = q[i2]).i] = o.x(t);
    return s.join("");
  });
}
var degrees = 180 / Math.PI;
var identity$1 = {
  translateX: 0,
  translateY: 0,
  rotate: 0,
  skewX: 0,
  scaleX: 1,
  scaleY: 1
};
function decompose(a, b, c, d, e, f) {
  var scaleX, scaleY, skewX;
  if (scaleX = Math.sqrt(a * a + b * b))
    a /= scaleX, b /= scaleX;
  if (skewX = a * c + b * d)
    c -= a * skewX, d -= b * skewX;
  if (scaleY = Math.sqrt(c * c + d * d))
    c /= scaleY, d /= scaleY, skewX /= scaleY;
  if (a * d < b * c)
    a = -a, b = -b, skewX = -skewX, scaleX = -scaleX;
  return {
    translateX: e,
    translateY: f,
    rotate: Math.atan2(b, a) * degrees,
    skewX: Math.atan(skewX) * degrees,
    scaleX,
    scaleY
  };
}
var svgNode;
function parseCss(value) {
  const m = new (typeof DOMMatrix === "function" ? DOMMatrix : WebKitCSSMatrix)(value + "");
  return m.isIdentity ? identity$1 : decompose(m.a, m.b, m.c, m.d, m.e, m.f);
}
function parseSvg(value) {
  if (value == null)
    return identity$1;
  if (!svgNode)
    svgNode = document.createElementNS("http://www.w3.org/2000/svg", "g");
  svgNode.setAttribute("transform", value);
  if (!(value = svgNode.transform.baseVal.consolidate()))
    return identity$1;
  value = value.matrix;
  return decompose(value.a, value.b, value.c, value.d, value.e, value.f);
}
function interpolateTransform(parse, pxComma, pxParen, degParen) {
  function pop(s) {
    return s.length ? s.pop() + " " : "";
  }
  function translate(xa, ya, xb, yb, s, q) {
    if (xa !== xb || ya !== yb) {
      var i = s.push("translate(", null, pxComma, null, pxParen);
      q.push({ i: i - 4, x: interpolateNumber(xa, xb) }, { i: i - 2, x: interpolateNumber(ya, yb) });
    } else if (xb || yb) {
      s.push("translate(" + xb + pxComma + yb + pxParen);
    }
  }
  function rotate(a, b, s, q) {
    if (a !== b) {
      if (a - b > 180)
        b += 360;
      else if (b - a > 180)
        a += 360;
      q.push({ i: s.push(pop(s) + "rotate(", null, degParen) - 2, x: interpolateNumber(a, b) });
    } else if (b) {
      s.push(pop(s) + "rotate(" + b + degParen);
    }
  }
  function skewX(a, b, s, q) {
    if (a !== b) {
      q.push({ i: s.push(pop(s) + "skewX(", null, degParen) - 2, x: interpolateNumber(a, b) });
    } else if (b) {
      s.push(pop(s) + "skewX(" + b + degParen);
    }
  }
  function scale(xa, ya, xb, yb, s, q) {
    if (xa !== xb || ya !== yb) {
      var i = s.push(pop(s) + "scale(", null, ",", null, ")");
      q.push({ i: i - 4, x: interpolateNumber(xa, xb) }, { i: i - 2, x: interpolateNumber(ya, yb) });
    } else if (xb !== 1 || yb !== 1) {
      s.push(pop(s) + "scale(" + xb + "," + yb + ")");
    }
  }
  return function(a, b) {
    var s = [], q = [];
    a = parse(a), b = parse(b);
    translate(a.translateX, a.translateY, b.translateX, b.translateY, s, q);
    rotate(a.rotate, b.rotate, s, q);
    skewX(a.skewX, b.skewX, s, q);
    scale(a.scaleX, a.scaleY, b.scaleX, b.scaleY, s, q);
    a = b = null;
    return function(t) {
      var i = -1, n = q.length, o;
      while (++i < n)
        s[(o = q[i]).i] = o.x(t);
      return s.join("");
    };
  };
}
var interpolateTransformCss = interpolateTransform(parseCss, "px, ", "px)", "deg)");
var interpolateTransformSvg = interpolateTransform(parseSvg, ", ", ")", ")");
var epsilon2 = 1e-12;
function cosh(x) {
  return ((x = Math.exp(x)) + 1 / x) / 2;
}
function sinh(x) {
  return ((x = Math.exp(x)) - 1 / x) / 2;
}
function tanh(x) {
  return ((x = Math.exp(2 * x)) - 1) / (x + 1);
}
var interpolateZoom = function zoomRho(rho, rho2, rho4) {
  function zoom2(p0, p1) {
    var ux0 = p0[0], uy0 = p0[1], w0 = p0[2], ux1 = p1[0], uy1 = p1[1], w1 = p1[2], dx = ux1 - ux0, dy = uy1 - uy0, d2 = dx * dx + dy * dy, i, S;
    if (d2 < epsilon2) {
      S = Math.log(w1 / w0) / rho;
      i = function(t) {
        return [
          ux0 + t * dx,
          uy0 + t * dy,
          w0 * Math.exp(rho * t * S)
        ];
      };
    } else {
      var d1 = Math.sqrt(d2), b0 = (w1 * w1 - w0 * w0 + rho4 * d2) / (2 * w0 * rho2 * d1), b1 = (w1 * w1 - w0 * w0 - rho4 * d2) / (2 * w1 * rho2 * d1), r0 = Math.log(Math.sqrt(b0 * b0 + 1) - b0), r1 = Math.log(Math.sqrt(b1 * b1 + 1) - b1);
      S = (r1 - r0) / rho;
      i = function(t) {
        var s = t * S, coshr0 = cosh(r0), u = w0 / (rho2 * d1) * (coshr0 * tanh(rho * s + r0) - sinh(r0));
        return [
          ux0 + u * dx,
          uy0 + u * dy,
          w0 * coshr0 / cosh(rho * s + r0)
        ];
      };
    }
    i.duration = S * 1e3 * rho / Math.SQRT2;
    return i;
  }
  zoom2.rho = function(_) {
    var _1 = Math.max(1e-3, +_), _2 = _1 * _1, _4 = _2 * _2;
    return zoomRho(_1, _2, _4);
  };
  return zoom2;
}(Math.SQRT2, 2, 4);
var frame = 0, timeout$1 = 0, interval = 0, pokeDelay = 1e3, taskHead, taskTail, clockLast = 0, clockNow = 0, clockSkew = 0, clock = typeof performance === "object" && performance.now ? performance : Date, setFrame = typeof window === "object" && window.requestAnimationFrame ? window.requestAnimationFrame.bind(window) : function(f) {
  setTimeout(f, 17);
};
function now() {
  return clockNow || (setFrame(clearNow), clockNow = clock.now() + clockSkew);
}
function clearNow() {
  clockNow = 0;
}
function Timer() {
  this._call = this._time = this._next = null;
}
Timer.prototype = timer.prototype = {
  constructor: Timer,
  restart: function(callback, delay, time) {
    if (typeof callback !== "function")
      throw new TypeError("callback is not a function");
    time = (time == null ? now() : +time) + (delay == null ? 0 : +delay);
    if (!this._next && taskTail !== this) {
      if (taskTail)
        taskTail._next = this;
      else
        taskHead = this;
      taskTail = this;
    }
    this._call = callback;
    this._time = time;
    sleep();
  },
  stop: function() {
    if (this._call) {
      this._call = null;
      this._time = Infinity;
      sleep();
    }
  }
};
function timer(callback, delay, time) {
  var t = new Timer();
  t.restart(callback, delay, time);
  return t;
}
function timerFlush() {
  now();
  ++frame;
  var t = taskHead, e;
  while (t) {
    if ((e = clockNow - t._time) >= 0)
      t._call.call(void 0, e);
    t = t._next;
  }
  --frame;
}
function wake() {
  clockNow = (clockLast = clock.now()) + clockSkew;
  frame = timeout$1 = 0;
  try {
    timerFlush();
  } finally {
    frame = 0;
    nap();
    clockNow = 0;
  }
}
function poke() {
  var now2 = clock.now(), delay = now2 - clockLast;
  if (delay > pokeDelay)
    clockSkew -= delay, clockLast = now2;
}
function nap() {
  var t0, t1 = taskHead, t2, time = Infinity;
  while (t1) {
    if (t1._call) {
      if (time > t1._time)
        time = t1._time;
      t0 = t1, t1 = t1._next;
    } else {
      t2 = t1._next, t1._next = null;
      t1 = t0 ? t0._next = t2 : taskHead = t2;
    }
  }
  taskTail = t0;
  sleep(time);
}
function sleep(time) {
  if (frame)
    return;
  if (timeout$1)
    timeout$1 = clearTimeout(timeout$1);
  var delay = time - clockNow;
  if (delay > 24) {
    if (time < Infinity)
      timeout$1 = setTimeout(wake, time - clock.now() - clockSkew);
    if (interval)
      interval = clearInterval(interval);
  } else {
    if (!interval)
      clockLast = clock.now(), interval = setInterval(poke, pokeDelay);
    frame = 1, setFrame(wake);
  }
}
function timeout(callback, delay, time) {
  var t = new Timer();
  delay = delay == null ? 0 : +delay;
  t.restart((elapsed) => {
    t.stop();
    callback(elapsed + delay);
  }, delay, time);
  return t;
}
var emptyOn = dispatch("start", "end", "cancel", "interrupt");
var emptyTween = [];
var CREATED = 0;
var SCHEDULED = 1;
var STARTING = 2;
var STARTED = 3;
var RUNNING = 4;
var ENDING = 5;
var ENDED = 6;
function schedule(node, name, id2, index, group, timing) {
  var schedules = node.__transition;
  if (!schedules)
    node.__transition = {};
  else if (id2 in schedules)
    return;
  create(node, id2, {
    name,
    index,
    group,
    on: emptyOn,
    tween: emptyTween,
    time: timing.time,
    delay: timing.delay,
    duration: timing.duration,
    ease: timing.ease,
    timer: null,
    state: CREATED
  });
}
function init(node, id2) {
  var schedule2 = get(node, id2);
  if (schedule2.state > CREATED)
    throw new Error("too late; already scheduled");
  return schedule2;
}
function set(node, id2) {
  var schedule2 = get(node, id2);
  if (schedule2.state > STARTED)
    throw new Error("too late; already running");
  return schedule2;
}
function get(node, id2) {
  var schedule2 = node.__transition;
  if (!schedule2 || !(schedule2 = schedule2[id2]))
    throw new Error("transition not found");
  return schedule2;
}
function create(node, id2, self2) {
  var schedules = node.__transition, tween;
  schedules[id2] = self2;
  self2.timer = timer(schedule2, 0, self2.time);
  function schedule2(elapsed) {
    self2.state = SCHEDULED;
    self2.timer.restart(start2, self2.delay, self2.time);
    if (self2.delay <= elapsed)
      start2(elapsed - self2.delay);
  }
  function start2(elapsed) {
    var i, j, n, o;
    if (self2.state !== SCHEDULED)
      return stop();
    for (i in schedules) {
      o = schedules[i];
      if (o.name !== self2.name)
        continue;
      if (o.state === STARTED)
        return timeout(start2);
      if (o.state === RUNNING) {
        o.state = ENDED;
        o.timer.stop();
        o.on.call("interrupt", node, node.__data__, o.index, o.group);
        delete schedules[i];
      } else if (+i < id2) {
        o.state = ENDED;
        o.timer.stop();
        o.on.call("cancel", node, node.__data__, o.index, o.group);
        delete schedules[i];
      }
    }
    timeout(function() {
      if (self2.state === STARTED) {
        self2.state = RUNNING;
        self2.timer.restart(tick, self2.delay, self2.time);
        tick(elapsed);
      }
    });
    self2.state = STARTING;
    self2.on.call("start", node, node.__data__, self2.index, self2.group);
    if (self2.state !== STARTING)
      return;
    self2.state = STARTED;
    tween = new Array(n = self2.tween.length);
    for (i = 0, j = -1; i < n; ++i) {
      if (o = self2.tween[i].value.call(node, node.__data__, self2.index, self2.group)) {
        tween[++j] = o;
      }
    }
    tween.length = j + 1;
  }
  function tick(elapsed) {
    var t = elapsed < self2.duration ? self2.ease.call(null, elapsed / self2.duration) : (self2.timer.restart(stop), self2.state = ENDING, 1), i = -1, n = tween.length;
    while (++i < n) {
      tween[i].call(node, t);
    }
    if (self2.state === ENDING) {
      self2.on.call("end", node, node.__data__, self2.index, self2.group);
      stop();
    }
  }
  function stop() {
    self2.state = ENDED;
    self2.timer.stop();
    delete schedules[id2];
    for (var i in schedules)
      return;
    delete node.__transition;
  }
}
function interrupt(node, name) {
  var schedules = node.__transition, schedule2, active, empty2 = true, i;
  if (!schedules)
    return;
  name = name == null ? null : name + "";
  for (i in schedules) {
    if ((schedule2 = schedules[i]).name !== name) {
      empty2 = false;
      continue;
    }
    active = schedule2.state > STARTING && schedule2.state < ENDING;
    schedule2.state = ENDED;
    schedule2.timer.stop();
    schedule2.on.call(active ? "interrupt" : "cancel", node, node.__data__, schedule2.index, schedule2.group);
    delete schedules[i];
  }
  if (empty2)
    delete node.__transition;
}
function selection_interrupt(name) {
  return this.each(function() {
    interrupt(this, name);
  });
}
function tweenRemove(id2, name) {
  var tween0, tween1;
  return function() {
    var schedule2 = set(this, id2), tween = schedule2.tween;
    if (tween !== tween0) {
      tween1 = tween0 = tween;
      for (var i = 0, n = tween1.length; i < n; ++i) {
        if (tween1[i].name === name) {
          tween1 = tween1.slice();
          tween1.splice(i, 1);
          break;
        }
      }
    }
    schedule2.tween = tween1;
  };
}
function tweenFunction(id2, name, value) {
  var tween0, tween1;
  if (typeof value !== "function")
    throw new Error();
  return function() {
    var schedule2 = set(this, id2), tween = schedule2.tween;
    if (tween !== tween0) {
      tween1 = (tween0 = tween).slice();
      for (var t = { name, value }, i = 0, n = tween1.length; i < n; ++i) {
        if (tween1[i].name === name) {
          tween1[i] = t;
          break;
        }
      }
      if (i === n)
        tween1.push(t);
    }
    schedule2.tween = tween1;
  };
}
function transition_tween(name, value) {
  var id2 = this._id;
  name += "";
  if (arguments.length < 2) {
    var tween = get(this.node(), id2).tween;
    for (var i = 0, n = tween.length, t; i < n; ++i) {
      if ((t = tween[i]).name === name) {
        return t.value;
      }
    }
    return null;
  }
  return this.each((value == null ? tweenRemove : tweenFunction)(id2, name, value));
}
function tweenValue(transition2, name, value) {
  var id2 = transition2._id;
  transition2.each(function() {
    var schedule2 = set(this, id2);
    (schedule2.value || (schedule2.value = {}))[name] = value.apply(this, arguments);
  });
  return function(node) {
    return get(node, id2).value[name];
  };
}
function interpolate(a, b) {
  var c;
  return (typeof b === "number" ? interpolateNumber : b instanceof color ? interpolateRgb : (c = color(b)) ? (b = c, interpolateRgb) : interpolateString)(a, b);
}
function attrRemove(name) {
  return function() {
    this.removeAttribute(name);
  };
}
function attrRemoveNS(fullname) {
  return function() {
    this.removeAttributeNS(fullname.space, fullname.local);
  };
}
function attrConstant(name, interpolate2, value1) {
  var string00, string1 = value1 + "", interpolate0;
  return function() {
    var string0 = this.getAttribute(name);
    return string0 === string1 ? null : string0 === string00 ? interpolate0 : interpolate0 = interpolate2(string00 = string0, value1);
  };
}
function attrConstantNS(fullname, interpolate2, value1) {
  var string00, string1 = value1 + "", interpolate0;
  return function() {
    var string0 = this.getAttributeNS(fullname.space, fullname.local);
    return string0 === string1 ? null : string0 === string00 ? interpolate0 : interpolate0 = interpolate2(string00 = string0, value1);
  };
}
function attrFunction(name, interpolate2, value) {
  var string00, string10, interpolate0;
  return function() {
    var string0, value1 = value(this), string1;
    if (value1 == null)
      return void this.removeAttribute(name);
    string0 = this.getAttribute(name);
    string1 = value1 + "";
    return string0 === string1 ? null : string0 === string00 && string1 === string10 ? interpolate0 : (string10 = string1, interpolate0 = interpolate2(string00 = string0, value1));
  };
}
function attrFunctionNS(fullname, interpolate2, value) {
  var string00, string10, interpolate0;
  return function() {
    var string0, value1 = value(this), string1;
    if (value1 == null)
      return void this.removeAttributeNS(fullname.space, fullname.local);
    string0 = this.getAttributeNS(fullname.space, fullname.local);
    string1 = value1 + "";
    return string0 === string1 ? null : string0 === string00 && string1 === string10 ? interpolate0 : (string10 = string1, interpolate0 = interpolate2(string00 = string0, value1));
  };
}
function transition_attr(name, value) {
  var fullname = namespace(name), i = fullname === "transform" ? interpolateTransformSvg : interpolate;
  return this.attrTween(name, typeof value === "function" ? (fullname.local ? attrFunctionNS : attrFunction)(fullname, i, tweenValue(this, "attr." + name, value)) : value == null ? (fullname.local ? attrRemoveNS : attrRemove)(fullname) : (fullname.local ? attrConstantNS : attrConstant)(fullname, i, value));
}
function attrInterpolate(name, i) {
  return function(t) {
    this.setAttribute(name, i.call(this, t));
  };
}
function attrInterpolateNS(fullname, i) {
  return function(t) {
    this.setAttributeNS(fullname.space, fullname.local, i.call(this, t));
  };
}
function attrTweenNS(fullname, value) {
  var t0, i0;
  function tween() {
    var i = value.apply(this, arguments);
    if (i !== i0)
      t0 = (i0 = i) && attrInterpolateNS(fullname, i);
    return t0;
  }
  tween._value = value;
  return tween;
}
function attrTween(name, value) {
  var t0, i0;
  function tween() {
    var i = value.apply(this, arguments);
    if (i !== i0)
      t0 = (i0 = i) && attrInterpolate(name, i);
    return t0;
  }
  tween._value = value;
  return tween;
}
function transition_attrTween(name, value) {
  var key = "attr." + name;
  if (arguments.length < 2)
    return (key = this.tween(key)) && key._value;
  if (value == null)
    return this.tween(key, null);
  if (typeof value !== "function")
    throw new Error();
  var fullname = namespace(name);
  return this.tween(key, (fullname.local ? attrTweenNS : attrTween)(fullname, value));
}
function delayFunction(id2, value) {
  return function() {
    init(this, id2).delay = +value.apply(this, arguments);
  };
}
function delayConstant(id2, value) {
  return value = +value, function() {
    init(this, id2).delay = value;
  };
}
function transition_delay(value) {
  var id2 = this._id;
  return arguments.length ? this.each((typeof value === "function" ? delayFunction : delayConstant)(id2, value)) : get(this.node(), id2).delay;
}
function durationFunction(id2, value) {
  return function() {
    set(this, id2).duration = +value.apply(this, arguments);
  };
}
function durationConstant(id2, value) {
  return value = +value, function() {
    set(this, id2).duration = value;
  };
}
function transition_duration(value) {
  var id2 = this._id;
  return arguments.length ? this.each((typeof value === "function" ? durationFunction : durationConstant)(id2, value)) : get(this.node(), id2).duration;
}
function easeConstant(id2, value) {
  if (typeof value !== "function")
    throw new Error();
  return function() {
    set(this, id2).ease = value;
  };
}
function transition_ease(value) {
  var id2 = this._id;
  return arguments.length ? this.each(easeConstant(id2, value)) : get(this.node(), id2).ease;
}
function easeVarying(id2, value) {
  return function() {
    var v = value.apply(this, arguments);
    if (typeof v !== "function")
      throw new Error();
    set(this, id2).ease = v;
  };
}
function transition_easeVarying(value) {
  if (typeof value !== "function")
    throw new Error();
  return this.each(easeVarying(this._id, value));
}
function transition_filter(match) {
  if (typeof match !== "function")
    match = matcher(match);
  for (var groups = this._groups, m = groups.length, subgroups = new Array(m), j = 0; j < m; ++j) {
    for (var group = groups[j], n = group.length, subgroup = subgroups[j] = [], node, i = 0; i < n; ++i) {
      if ((node = group[i]) && match.call(node, node.__data__, i, group)) {
        subgroup.push(node);
      }
    }
  }
  return new Transition(subgroups, this._parents, this._name, this._id);
}
function transition_merge(transition2) {
  if (transition2._id !== this._id)
    throw new Error();
  for (var groups0 = this._groups, groups1 = transition2._groups, m0 = groups0.length, m1 = groups1.length, m = Math.min(m0, m1), merges = new Array(m0), j = 0; j < m; ++j) {
    for (var group0 = groups0[j], group1 = groups1[j], n = group0.length, merge = merges[j] = new Array(n), node, i = 0; i < n; ++i) {
      if (node = group0[i] || group1[i]) {
        merge[i] = node;
      }
    }
  }
  for (; j < m0; ++j) {
    merges[j] = groups0[j];
  }
  return new Transition(merges, this._parents, this._name, this._id);
}
function start(name) {
  return (name + "").trim().split(/^|\s+/).every(function(t) {
    var i = t.indexOf(".");
    if (i >= 0)
      t = t.slice(0, i);
    return !t || t === "start";
  });
}
function onFunction(id2, name, listener) {
  var on0, on1, sit = start(name) ? init : set;
  return function() {
    var schedule2 = sit(this, id2), on = schedule2.on;
    if (on !== on0)
      (on1 = (on0 = on).copy()).on(name, listener);
    schedule2.on = on1;
  };
}
function transition_on(name, listener) {
  var id2 = this._id;
  return arguments.length < 2 ? get(this.node(), id2).on.on(name) : this.each(onFunction(id2, name, listener));
}
function removeFunction(id2) {
  return function() {
    var parent = this.parentNode;
    for (var i in this.__transition)
      if (+i !== id2)
        return;
    if (parent)
      parent.removeChild(this);
  };
}
function transition_remove() {
  return this.on("end.remove", removeFunction(this._id));
}
function transition_select(select2) {
  var name = this._name, id2 = this._id;
  if (typeof select2 !== "function")
    select2 = selector(select2);
  for (var groups = this._groups, m = groups.length, subgroups = new Array(m), j = 0; j < m; ++j) {
    for (var group = groups[j], n = group.length, subgroup = subgroups[j] = new Array(n), node, subnode, i = 0; i < n; ++i) {
      if ((node = group[i]) && (subnode = select2.call(node, node.__data__, i, group))) {
        if ("__data__" in node)
          subnode.__data__ = node.__data__;
        subgroup[i] = subnode;
        schedule(subgroup[i], name, id2, i, subgroup, get(node, id2));
      }
    }
  }
  return new Transition(subgroups, this._parents, name, id2);
}
function transition_selectAll(select2) {
  var name = this._name, id2 = this._id;
  if (typeof select2 !== "function")
    select2 = selectorAll(select2);
  for (var groups = this._groups, m = groups.length, subgroups = [], parents = [], j = 0; j < m; ++j) {
    for (var group = groups[j], n = group.length, node, i = 0; i < n; ++i) {
      if (node = group[i]) {
        for (var children2 = select2.call(node, node.__data__, i, group), child, inherit2 = get(node, id2), k = 0, l = children2.length; k < l; ++k) {
          if (child = children2[k]) {
            schedule(child, name, id2, k, children2, inherit2);
          }
        }
        subgroups.push(children2);
        parents.push(node);
      }
    }
  }
  return new Transition(subgroups, parents, name, id2);
}
var Selection = selection.prototype.constructor;
function transition_selection() {
  return new Selection(this._groups, this._parents);
}
function styleNull(name, interpolate2) {
  var string00, string10, interpolate0;
  return function() {
    var string0 = styleValue(this, name), string1 = (this.style.removeProperty(name), styleValue(this, name));
    return string0 === string1 ? null : string0 === string00 && string1 === string10 ? interpolate0 : interpolate0 = interpolate2(string00 = string0, string10 = string1);
  };
}
function styleRemove(name) {
  return function() {
    this.style.removeProperty(name);
  };
}
function styleConstant(name, interpolate2, value1) {
  var string00, string1 = value1 + "", interpolate0;
  return function() {
    var string0 = styleValue(this, name);
    return string0 === string1 ? null : string0 === string00 ? interpolate0 : interpolate0 = interpolate2(string00 = string0, value1);
  };
}
function styleFunction(name, interpolate2, value) {
  var string00, string10, interpolate0;
  return function() {
    var string0 = styleValue(this, name), value1 = value(this), string1 = value1 + "";
    if (value1 == null)
      string1 = value1 = (this.style.removeProperty(name), styleValue(this, name));
    return string0 === string1 ? null : string0 === string00 && string1 === string10 ? interpolate0 : (string10 = string1, interpolate0 = interpolate2(string00 = string0, value1));
  };
}
function styleMaybeRemove(id2, name) {
  var on0, on1, listener0, key = "style." + name, event = "end." + key, remove2;
  return function() {
    var schedule2 = set(this, id2), on = schedule2.on, listener = schedule2.value[key] == null ? remove2 || (remove2 = styleRemove(name)) : void 0;
    if (on !== on0 || listener0 !== listener)
      (on1 = (on0 = on).copy()).on(event, listener0 = listener);
    schedule2.on = on1;
  };
}
function transition_style(name, value, priority) {
  var i = (name += "") === "transform" ? interpolateTransformCss : interpolate;
  return value == null ? this.styleTween(name, styleNull(name, i)).on("end.style." + name, styleRemove(name)) : typeof value === "function" ? this.styleTween(name, styleFunction(name, i, tweenValue(this, "style." + name, value))).each(styleMaybeRemove(this._id, name)) : this.styleTween(name, styleConstant(name, i, value), priority).on("end.style." + name, null);
}
function styleInterpolate(name, i, priority) {
  return function(t) {
    this.style.setProperty(name, i.call(this, t), priority);
  };
}
function styleTween(name, value, priority) {
  var t, i0;
  function tween() {
    var i = value.apply(this, arguments);
    if (i !== i0)
      t = (i0 = i) && styleInterpolate(name, i, priority);
    return t;
  }
  tween._value = value;
  return tween;
}
function transition_styleTween(name, value, priority) {
  var key = "style." + (name += "");
  if (arguments.length < 2)
    return (key = this.tween(key)) && key._value;
  if (value == null)
    return this.tween(key, null);
  if (typeof value !== "function")
    throw new Error();
  return this.tween(key, styleTween(name, value, priority == null ? "" : priority));
}
function textConstant(value) {
  return function() {
    this.textContent = value;
  };
}
function textFunction(value) {
  return function() {
    var value1 = value(this);
    this.textContent = value1 == null ? "" : value1;
  };
}
function transition_text(value) {
  return this.tween("text", typeof value === "function" ? textFunction(tweenValue(this, "text", value)) : textConstant(value == null ? "" : value + ""));
}
function textInterpolate(i) {
  return function(t) {
    this.textContent = i.call(this, t);
  };
}
function textTween(value) {
  var t0, i0;
  function tween() {
    var i = value.apply(this, arguments);
    if (i !== i0)
      t0 = (i0 = i) && textInterpolate(i);
    return t0;
  }
  tween._value = value;
  return tween;
}
function transition_textTween(value) {
  var key = "text";
  if (arguments.length < 1)
    return (key = this.tween(key)) && key._value;
  if (value == null)
    return this.tween(key, null);
  if (typeof value !== "function")
    throw new Error();
  return this.tween(key, textTween(value));
}
function transition_transition() {
  var name = this._name, id0 = this._id, id1 = newId();
  for (var groups = this._groups, m = groups.length, j = 0; j < m; ++j) {
    for (var group = groups[j], n = group.length, node, i = 0; i < n; ++i) {
      if (node = group[i]) {
        var inherit2 = get(node, id0);
        schedule(node, name, id1, i, group, {
          time: inherit2.time + inherit2.delay + inherit2.duration,
          delay: 0,
          duration: inherit2.duration,
          ease: inherit2.ease
        });
      }
    }
  }
  return new Transition(groups, this._parents, name, id1);
}
function transition_end() {
  var on0, on1, that = this, id2 = that._id, size = that.size();
  return new Promise(function(resolve, reject) {
    var cancel = { value: reject }, end = { value: function() {
      if (--size === 0)
        resolve();
    } };
    that.each(function() {
      var schedule2 = set(this, id2), on = schedule2.on;
      if (on !== on0) {
        on1 = (on0 = on).copy();
        on1._.cancel.push(cancel);
        on1._.interrupt.push(cancel);
        on1._.end.push(end);
      }
      schedule2.on = on1;
    });
    if (size === 0)
      resolve();
  });
}
var id = 0;
function Transition(groups, parents, name, id2) {
  this._groups = groups;
  this._parents = parents;
  this._name = name;
  this._id = id2;
}
function newId() {
  return ++id;
}
var selection_prototype = selection.prototype;
Transition.prototype = {
  constructor: Transition,
  select: transition_select,
  selectAll: transition_selectAll,
  selectChild: selection_prototype.selectChild,
  selectChildren: selection_prototype.selectChildren,
  filter: transition_filter,
  merge: transition_merge,
  selection: transition_selection,
  transition: transition_transition,
  call: selection_prototype.call,
  nodes: selection_prototype.nodes,
  node: selection_prototype.node,
  size: selection_prototype.size,
  empty: selection_prototype.empty,
  each: selection_prototype.each,
  on: transition_on,
  attr: transition_attr,
  attrTween: transition_attrTween,
  style: transition_style,
  styleTween: transition_styleTween,
  text: transition_text,
  textTween: transition_textTween,
  remove: transition_remove,
  tween: transition_tween,
  delay: transition_delay,
  duration: transition_duration,
  ease: transition_ease,
  easeVarying: transition_easeVarying,
  end: transition_end,
  [Symbol.iterator]: selection_prototype[Symbol.iterator]
};
function cubicInOut(t) {
  return ((t *= 2) <= 1 ? t * t * t : (t -= 2) * t * t + 2) / 2;
}
var defaultTiming = {
  time: null,
  delay: 0,
  duration: 250,
  ease: cubicInOut
};
function inherit(node, id2) {
  var timing;
  while (!(timing = node.__transition) || !(timing = timing[id2])) {
    if (!(node = node.parentNode)) {
      throw new Error(`transition ${id2} not found`);
    }
  }
  return timing;
}
function selection_transition(name) {
  var id2, timing;
  if (name instanceof Transition) {
    id2 = name._id, name = name._name;
  } else {
    id2 = newId(), (timing = defaultTiming).time = now(), name = name == null ? null : name + "";
  }
  for (var groups = this._groups, m = groups.length, j = 0; j < m; ++j) {
    for (var group = groups[j], n = group.length, node, i = 0; i < n; ++i) {
      if (node = group[i]) {
        schedule(node, name, id2, i, group, timing || inherit(node, id2));
      }
    }
  }
  return new Transition(groups, this._parents, name, id2);
}
selection.prototype.interrupt = selection_interrupt;
selection.prototype.transition = selection_transition;
var constant = (x) => () => x;
function ZoomEvent(type, {
  sourceEvent: sourceEvent2,
  target,
  transform,
  dispatch: dispatch2
}) {
  Object.defineProperties(this, {
    type: { value: type, enumerable: true, configurable: true },
    sourceEvent: { value: sourceEvent2, enumerable: true, configurable: true },
    target: { value: target, enumerable: true, configurable: true },
    transform: { value: transform, enumerable: true, configurable: true },
    _: { value: dispatch2 }
  });
}
function Transform(k, x, y) {
  this.k = k;
  this.x = x;
  this.y = y;
}
Transform.prototype = {
  constructor: Transform,
  scale: function(k) {
    return k === 1 ? this : new Transform(this.k * k, this.x, this.y);
  },
  translate: function(x, y) {
    return x === 0 & y === 0 ? this : new Transform(this.k, this.x + this.k * x, this.y + this.k * y);
  },
  apply: function(point) {
    return [point[0] * this.k + this.x, point[1] * this.k + this.y];
  },
  applyX: function(x) {
    return x * this.k + this.x;
  },
  applyY: function(y) {
    return y * this.k + this.y;
  },
  invert: function(location) {
    return [(location[0] - this.x) / this.k, (location[1] - this.y) / this.k];
  },
  invertX: function(x) {
    return (x - this.x) / this.k;
  },
  invertY: function(y) {
    return (y - this.y) / this.k;
  },
  rescaleX: function(x) {
    return x.copy().domain(x.range().map(this.invertX, this).map(x.invert, x));
  },
  rescaleY: function(y) {
    return y.copy().domain(y.range().map(this.invertY, this).map(y.invert, y));
  },
  toString: function() {
    return "translate(" + this.x + "," + this.y + ") scale(" + this.k + ")";
  }
};
var identity = new Transform(1, 0, 0);
Transform.prototype;
function nopropagation(event) {
  event.stopImmediatePropagation();
}
function noevent(event) {
  event.preventDefault();
  event.stopImmediatePropagation();
}
function defaultFilter(event) {
  return (!event.ctrlKey || event.type === "wheel") && !event.button;
}
function defaultExtent() {
  var e = this;
  if (e instanceof SVGElement) {
    e = e.ownerSVGElement || e;
    if (e.hasAttribute("viewBox")) {
      e = e.viewBox.baseVal;
      return [[e.x, e.y], [e.x + e.width, e.y + e.height]];
    }
    return [[0, 0], [e.width.baseVal.value, e.height.baseVal.value]];
  }
  return [[0, 0], [e.clientWidth, e.clientHeight]];
}
function defaultTransform() {
  return this.__zoom || identity;
}
function defaultWheelDelta(event) {
  return -event.deltaY * (event.deltaMode === 1 ? 0.05 : event.deltaMode ? 1 : 2e-3) * (event.ctrlKey ? 10 : 1);
}
function defaultTouchable() {
  return navigator.maxTouchPoints || "ontouchstart" in this;
}
function defaultConstrain(transform, extent, translateExtent) {
  var dx0 = transform.invertX(extent[0][0]) - translateExtent[0][0], dx1 = transform.invertX(extent[1][0]) - translateExtent[1][0], dy0 = transform.invertY(extent[0][1]) - translateExtent[0][1], dy1 = transform.invertY(extent[1][1]) - translateExtent[1][1];
  return transform.translate(
    dx1 > dx0 ? (dx0 + dx1) / 2 : Math.min(0, dx0) || Math.max(0, dx1),
    dy1 > dy0 ? (dy0 + dy1) / 2 : Math.min(0, dy0) || Math.max(0, dy1)
  );
}
function zoom() {
  var filter2 = defaultFilter, extent = defaultExtent, constrain = defaultConstrain, wheelDelta = defaultWheelDelta, touchable = defaultTouchable, scaleExtent = [0, Infinity], translateExtent = [[-Infinity, -Infinity], [Infinity, Infinity]], duration = 250, interpolate2 = interpolateZoom, listeners = dispatch("start", "zoom", "end"), touchstarting, touchfirst, touchending, touchDelay = 500, wheelDelay = 150, clickDistance2 = 0, tapDistance = 10;
  function zoom2(selection2) {
    selection2.property("__zoom", defaultTransform).on("wheel.zoom", wheeled, { passive: false }).on("mousedown.zoom", mousedowned).on("dblclick.zoom", dblclicked).filter(touchable).on("touchstart.zoom", touchstarted).on("touchmove.zoom", touchmoved).on("touchend.zoom touchcancel.zoom", touchended).style("-webkit-tap-highlight-color", "rgba(0,0,0,0)");
  }
  zoom2.transform = function(collection, transform, point, event) {
    var selection2 = collection.selection ? collection.selection() : collection;
    selection2.property("__zoom", defaultTransform);
    if (collection !== selection2) {
      schedule2(collection, transform, point, event);
    } else {
      selection2.interrupt().each(function() {
        gesture(this, arguments).event(event).start().zoom(null, typeof transform === "function" ? transform.apply(this, arguments) : transform).end();
      });
    }
  };
  zoom2.scaleBy = function(selection2, k, p, event) {
    zoom2.scaleTo(selection2, function() {
      var k0 = this.__zoom.k, k1 = typeof k === "function" ? k.apply(this, arguments) : k;
      return k0 * k1;
    }, p, event);
  };
  zoom2.scaleTo = function(selection2, k, p, event) {
    zoom2.transform(selection2, function() {
      var e = extent.apply(this, arguments), t0 = this.__zoom, p0 = p == null ? centroid(e) : typeof p === "function" ? p.apply(this, arguments) : p, p1 = t0.invert(p0), k1 = typeof k === "function" ? k.apply(this, arguments) : k;
      return constrain(translate(scale(t0, k1), p0, p1), e, translateExtent);
    }, p, event);
  };
  zoom2.translateBy = function(selection2, x, y, event) {
    zoom2.transform(selection2, function() {
      return constrain(this.__zoom.translate(
        typeof x === "function" ? x.apply(this, arguments) : x,
        typeof y === "function" ? y.apply(this, arguments) : y
      ), extent.apply(this, arguments), translateExtent);
    }, null, event);
  };
  zoom2.translateTo = function(selection2, x, y, p, event) {
    zoom2.transform(selection2, function() {
      var e = extent.apply(this, arguments), t = this.__zoom, p0 = p == null ? centroid(e) : typeof p === "function" ? p.apply(this, arguments) : p;
      return constrain(identity.translate(p0[0], p0[1]).scale(t.k).translate(
        typeof x === "function" ? -x.apply(this, arguments) : -x,
        typeof y === "function" ? -y.apply(this, arguments) : -y
      ), e, translateExtent);
    }, p, event);
  };
  function scale(transform, k) {
    k = Math.max(scaleExtent[0], Math.min(scaleExtent[1], k));
    return k === transform.k ? transform : new Transform(k, transform.x, transform.y);
  }
  function translate(transform, p0, p1) {
    var x = p0[0] - p1[0] * transform.k, y = p0[1] - p1[1] * transform.k;
    return x === transform.x && y === transform.y ? transform : new Transform(transform.k, x, y);
  }
  function centroid(extent2) {
    return [(+extent2[0][0] + +extent2[1][0]) / 2, (+extent2[0][1] + +extent2[1][1]) / 2];
  }
  function schedule2(transition2, transform, point, event) {
    transition2.on("start.zoom", function() {
      gesture(this, arguments).event(event).start();
    }).on("interrupt.zoom end.zoom", function() {
      gesture(this, arguments).event(event).end();
    }).tween("zoom", function() {
      var that = this, args = arguments, g = gesture(that, args).event(event), e = extent.apply(that, args), p = point == null ? centroid(e) : typeof point === "function" ? point.apply(that, args) : point, w = Math.max(e[1][0] - e[0][0], e[1][1] - e[0][1]), a = that.__zoom, b = typeof transform === "function" ? transform.apply(that, args) : transform, i = interpolate2(a.invert(p).concat(w / a.k), b.invert(p).concat(w / b.k));
      return function(t) {
        if (t === 1)
          t = b;
        else {
          var l = i(t), k = w / l[2];
          t = new Transform(k, p[0] - l[0] * k, p[1] - l[1] * k);
        }
        g.zoom(null, t);
      };
    });
  }
  function gesture(that, args, clean) {
    return !clean && that.__zooming || new Gesture(that, args);
  }
  function Gesture(that, args) {
    this.that = that;
    this.args = args;
    this.active = 0;
    this.sourceEvent = null;
    this.extent = extent.apply(that, args);
    this.taps = 0;
  }
  Gesture.prototype = {
    event: function(event) {
      if (event)
        this.sourceEvent = event;
      return this;
    },
    start: function() {
      if (++this.active === 1) {
        this.that.__zooming = this;
        this.emit("start");
      }
      return this;
    },
    zoom: function(key, transform) {
      if (this.mouse && key !== "mouse")
        this.mouse[1] = transform.invert(this.mouse[0]);
      if (this.touch0 && key !== "touch")
        this.touch0[1] = transform.invert(this.touch0[0]);
      if (this.touch1 && key !== "touch")
        this.touch1[1] = transform.invert(this.touch1[0]);
      this.that.__zoom = transform;
      this.emit("zoom");
      return this;
    },
    end: function() {
      if (--this.active === 0) {
        delete this.that.__zooming;
        this.emit("end");
      }
      return this;
    },
    emit: function(type) {
      var d = select(this.that).datum();
      listeners.call(
        type,
        this.that,
        new ZoomEvent(type, {
          sourceEvent: this.sourceEvent,
          target: zoom2,
          type,
          transform: this.that.__zoom,
          dispatch: listeners
        }),
        d
      );
    }
  };
  function wheeled(event, ...args) {
    if (!filter2.apply(this, arguments))
      return;
    var g = gesture(this, args).event(event), t = this.__zoom, k = Math.max(scaleExtent[0], Math.min(scaleExtent[1], t.k * Math.pow(2, wheelDelta.apply(this, arguments)))), p = pointer(event);
    if (g.wheel) {
      if (g.mouse[0][0] !== p[0] || g.mouse[0][1] !== p[1]) {
        g.mouse[1] = t.invert(g.mouse[0] = p);
      }
      clearTimeout(g.wheel);
    } else if (t.k === k)
      return;
    else {
      g.mouse = [p, t.invert(p)];
      interrupt(this);
      g.start();
    }
    noevent(event);
    g.wheel = setTimeout(wheelidled, wheelDelay);
    g.zoom("mouse", constrain(translate(scale(t, k), g.mouse[0], g.mouse[1]), g.extent, translateExtent));
    function wheelidled() {
      g.wheel = null;
      g.end();
    }
  }
  function mousedowned(event, ...args) {
    if (touchending || !filter2.apply(this, arguments))
      return;
    var currentTarget = event.currentTarget, g = gesture(this, args, true).event(event), v = select(event.view).on("mousemove.zoom", mousemoved, true).on("mouseup.zoom", mouseupped, true), p = pointer(event, currentTarget), x0 = event.clientX, y0 = event.clientY;
    dragDisable(event.view);
    nopropagation(event);
    g.mouse = [p, this.__zoom.invert(p)];
    interrupt(this);
    g.start();
    function mousemoved(event2) {
      noevent(event2);
      if (!g.moved) {
        var dx = event2.clientX - x0, dy = event2.clientY - y0;
        g.moved = dx * dx + dy * dy > clickDistance2;
      }
      g.event(event2).zoom("mouse", constrain(translate(g.that.__zoom, g.mouse[0] = pointer(event2, currentTarget), g.mouse[1]), g.extent, translateExtent));
    }
    function mouseupped(event2) {
      v.on("mousemove.zoom mouseup.zoom", null);
      yesdrag(event2.view, g.moved);
      noevent(event2);
      g.event(event2).end();
    }
  }
  function dblclicked(event, ...args) {
    if (!filter2.apply(this, arguments))
      return;
    var t0 = this.__zoom, p0 = pointer(event.changedTouches ? event.changedTouches[0] : event, this), p1 = t0.invert(p0), k1 = t0.k * (event.shiftKey ? 0.5 : 2), t1 = constrain(translate(scale(t0, k1), p0, p1), extent.apply(this, args), translateExtent);
    noevent(event);
    if (duration > 0)
      select(this).transition().duration(duration).call(schedule2, t1, p0, event);
    else
      select(this).call(zoom2.transform, t1, p0, event);
  }
  function touchstarted(event, ...args) {
    if (!filter2.apply(this, arguments))
      return;
    var touches = event.touches, n = touches.length, g = gesture(this, args, event.changedTouches.length === n).event(event), started, i, t, p;
    nopropagation(event);
    for (i = 0; i < n; ++i) {
      t = touches[i], p = pointer(t, this);
      p = [p, this.__zoom.invert(p), t.identifier];
      if (!g.touch0)
        g.touch0 = p, started = true, g.taps = 1 + !!touchstarting;
      else if (!g.touch1 && g.touch0[2] !== p[2])
        g.touch1 = p, g.taps = 0;
    }
    if (touchstarting)
      touchstarting = clearTimeout(touchstarting);
    if (started) {
      if (g.taps < 2)
        touchfirst = p[0], touchstarting = setTimeout(function() {
          touchstarting = null;
        }, touchDelay);
      interrupt(this);
      g.start();
    }
  }
  function touchmoved(event, ...args) {
    if (!this.__zooming)
      return;
    var g = gesture(this, args).event(event), touches = event.changedTouches, n = touches.length, i, t, p, l;
    noevent(event);
    for (i = 0; i < n; ++i) {
      t = touches[i], p = pointer(t, this);
      if (g.touch0 && g.touch0[2] === t.identifier)
        g.touch0[0] = p;
      else if (g.touch1 && g.touch1[2] === t.identifier)
        g.touch1[0] = p;
    }
    t = g.that.__zoom;
    if (g.touch1) {
      var p0 = g.touch0[0], l0 = g.touch0[1], p1 = g.touch1[0], l1 = g.touch1[1], dp = (dp = p1[0] - p0[0]) * dp + (dp = p1[1] - p0[1]) * dp, dl = (dl = l1[0] - l0[0]) * dl + (dl = l1[1] - l0[1]) * dl;
      t = scale(t, Math.sqrt(dp / dl));
      p = [(p0[0] + p1[0]) / 2, (p0[1] + p1[1]) / 2];
      l = [(l0[0] + l1[0]) / 2, (l0[1] + l1[1]) / 2];
    } else if (g.touch0)
      p = g.touch0[0], l = g.touch0[1];
    else
      return;
    g.zoom("touch", constrain(translate(t, p, l), g.extent, translateExtent));
  }
  function touchended(event, ...args) {
    if (!this.__zooming)
      return;
    var g = gesture(this, args).event(event), touches = event.changedTouches, n = touches.length, i, t;
    nopropagation(event);
    if (touchending)
      clearTimeout(touchending);
    touchending = setTimeout(function() {
      touchending = null;
    }, touchDelay);
    for (i = 0; i < n; ++i) {
      t = touches[i];
      if (g.touch0 && g.touch0[2] === t.identifier)
        delete g.touch0;
      else if (g.touch1 && g.touch1[2] === t.identifier)
        delete g.touch1;
    }
    if (g.touch1 && !g.touch0)
      g.touch0 = g.touch1, delete g.touch1;
    if (g.touch0)
      g.touch0[1] = this.__zoom.invert(g.touch0[0]);
    else {
      g.end();
      if (g.taps === 2) {
        t = pointer(t, this);
        if (Math.hypot(touchfirst[0] - t[0], touchfirst[1] - t[1]) < tapDistance) {
          var p = select(this).on("dblclick.zoom");
          if (p)
            p.apply(this, arguments);
        }
      }
    }
  }
  zoom2.wheelDelta = function(_) {
    return arguments.length ? (wheelDelta = typeof _ === "function" ? _ : constant(+_), zoom2) : wheelDelta;
  };
  zoom2.filter = function(_) {
    return arguments.length ? (filter2 = typeof _ === "function" ? _ : constant(!!_), zoom2) : filter2;
  };
  zoom2.touchable = function(_) {
    return arguments.length ? (touchable = typeof _ === "function" ? _ : constant(!!_), zoom2) : touchable;
  };
  zoom2.extent = function(_) {
    return arguments.length ? (extent = typeof _ === "function" ? _ : constant([[+_[0][0], +_[0][1]], [+_[1][0], +_[1][1]]]), zoom2) : extent;
  };
  zoom2.scaleExtent = function(_) {
    return arguments.length ? (scaleExtent[0] = +_[0], scaleExtent[1] = +_[1], zoom2) : [scaleExtent[0], scaleExtent[1]];
  };
  zoom2.translateExtent = function(_) {
    return arguments.length ? (translateExtent[0][0] = +_[0][0], translateExtent[1][0] = +_[1][0], translateExtent[0][1] = +_[0][1], translateExtent[1][1] = +_[1][1], zoom2) : [[translateExtent[0][0], translateExtent[0][1]], [translateExtent[1][0], translateExtent[1][1]]];
  };
  zoom2.constrain = function(_) {
    return arguments.length ? (constrain = _, zoom2) : constrain;
  };
  zoom2.duration = function(_) {
    return arguments.length ? (duration = +_, zoom2) : duration;
  };
  zoom2.interpolate = function(_) {
    return arguments.length ? (interpolate2 = _, zoom2) : interpolate2;
  };
  zoom2.on = function() {
    var value = listeners.on.apply(listeners, arguments);
    return value === listeners ? zoom2 : value;
  };
  zoom2.clickDistance = function(_) {
    return arguments.length ? (clickDistance2 = (_ = +_) * _, zoom2) : Math.sqrt(clickDistance2);
  };
  zoom2.tapDistance = function(_) {
    return arguments.length ? (tapDistance = +_, zoom2) : tapDistance;
  };
  return zoom2;
}
var Position = /* @__PURE__ */ ((Position2) => {
  Position2["Left"] = "left";
  Position2["Top"] = "top";
  Position2["Right"] = "right";
  Position2["Bottom"] = "bottom";
  return Position2;
})(Position || {});
var BackgroundVariant = /* @__PURE__ */ ((BackgroundVariant2) => {
  BackgroundVariant2["Lines"] = "lines";
  BackgroundVariant2["Dots"] = "dots";
  return BackgroundVariant2;
})(BackgroundVariant || {});
var ConnectionLineType = /* @__PURE__ */ ((ConnectionLineType2) => {
  ConnectionLineType2["Bezier"] = "default";
  ConnectionLineType2["Straight"] = "straight";
  ConnectionLineType2["Step"] = "step";
  ConnectionLineType2["SmoothStep"] = "smoothstep";
  return ConnectionLineType2;
})(ConnectionLineType || {});
var ConnectionMode = /* @__PURE__ */ ((ConnectionMode2) => {
  ConnectionMode2["Strict"] = "strict";
  ConnectionMode2["Loose"] = "loose";
  return ConnectionMode2;
})(ConnectionMode || {});
var MarkerType = /* @__PURE__ */ ((MarkerType2) => {
  MarkerType2["Arrow"] = "arrow";
  MarkerType2["ArrowClosed"] = "arrowclosed";
  return MarkerType2;
})(MarkerType || {});
var PanOnScrollMode = /* @__PURE__ */ ((PanOnScrollMode2) => {
  PanOnScrollMode2["Free"] = "free";
  PanOnScrollMode2["Vertical"] = "vertical";
  PanOnScrollMode2["Horizontal"] = "horizontal";
  return PanOnScrollMode2;
})(PanOnScrollMode || {});
const VueFlow = Symbol("vueFlow");
const NodeId = Symbol("nodeId");
const Slots = Symbol("slots");
const createHooks = () => ({
  edgesChange: createEventHook(),
  nodesChange: createEventHook(),
  nodeDoubleClick: createEventHook(),
  nodeClick: createEventHook(),
  nodeMouseEnter: createEventHook(),
  nodeMouseMove: createEventHook(),
  nodeMouseLeave: createEventHook(),
  nodeContextMenu: createEventHook(),
  nodeDragStart: createEventHook(),
  nodeDrag: createEventHook(),
  nodeDragStop: createEventHook(),
  miniMapNodeClick: createEventHook(),
  miniMapNodeDoubleClick: createEventHook(),
  miniMapNodeMouseEnter: createEventHook(),
  miniMapNodeMouseMove: createEventHook(),
  miniMapNodeMouseLeave: createEventHook(),
  connect: createEventHook(),
  connectStart: createEventHook(),
  connectStop: createEventHook(),
  connectEnd: createEventHook(),
  paneReady: createEventHook(),
  move: createEventHook(),
  moveStart: createEventHook(),
  moveEnd: createEventHook(),
  selectionDragStart: createEventHook(),
  selectionDrag: createEventHook(),
  selectionDragStop: createEventHook(),
  selectionContextMenu: createEventHook(),
  paneScroll: createEventHook(),
  paneClick: createEventHook(),
  paneContextMenu: createEventHook(),
  paneMouseEnter: createEventHook(),
  paneMouseMove: createEventHook(),
  paneMouseLeave: createEventHook(),
  edgeContextMenu: createEventHook(),
  edgeMouseEnter: createEventHook(),
  edgeMouseMove: createEventHook(),
  edgeMouseLeave: createEventHook(),
  edgeDoubleClick: createEventHook(),
  edgeClick: createEventHook(),
  edgeUpdateStart: createEventHook(),
  edgeUpdate: createEventHook(),
  edgeUpdateEnd: createEventHook(),
  updateNodeInternals: createEventHook()
});
var useHooks = (emit, hooks) => {
  onBeforeMount(() => {
    for (const [key, value] of Object.entries(hooks.value)) {
      const listener = (data) => {
        emit(key, data);
      };
      value.on(listener);
      tryOnScopeDispose(() => {
        value.off(listener);
      });
    }
  });
};
const _hoisted_1$g = ["data-handleid", "data-nodeid", "data-handlepos"];
const __default__$h = {
  name: "Handle"
};
const _sfc_main$i = /* @__PURE__ */ defineComponent({
  ...__default__$h,
  props: {
    id: null,
    type: { default: "source" },
    position: { default: () => "top" },
    isValidConnection: { type: Function, default: () => function() {
      return true;
    } },
    connectable: { type: Boolean, default: true }
  },
  setup(__props) {
    const __$temp_1 = useVueFlow(), connectionStartHandle = toRef(__$temp_1, "connectionStartHandle"), connectionMode = toRef(__$temp_1, "connectionMode");
    const nodeId = inject(NodeId, "");
    const handleId = computed(() => {
      var _a2;
      return (_a2 = __props.id) != null ? _a2 : connectionMode.value === ConnectionMode.Strict ? null : `${nodeId}__handle-${__props.position}`;
    });
    const { onMouseDown, onClick } = useHandle();
    const onMouseDownHandler = (event) => {
      onMouseDown(event, handleId.value, nodeId, __props.type === "target", __props.isValidConnection, void 0);
    };
    const onClickHandler = (event) => {
      var _a2;
      onClick(event, (_a2 = handleId.value) != null ? _a2 : null, nodeId, __props.type, __props.isValidConnection);
    };
    const getClasses = computed(() => {
      return [
        "vue-flow__handle",
        `vue-flow__handle-${__props.position}`,
        `vue-flow__handle-${handleId.value}`,
        "nodrag",
        {
          source: __props.type !== "target",
          target: __props.type === "target",
          connectable: __props.connectable,
          connecting: connectionStartHandle.value && connectionStartHandle.value.nodeId === nodeId && connectionStartHandle.value.handleId === handleId.value && connectionStartHandle.value.type === __props.type
        }
      ];
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        "data-handleid": handleId.value,
        "data-nodeid": unref(nodeId),
        "data-handlepos": __props.position,
        class: normalizeClass(unref(getClasses)),
        onMousedown: onMouseDownHandler,
        onClick: onClickHandler
      }, [
        renderSlot(_ctx.$slots, "default", { id: __props.id })
      ], 42, _hoisted_1$g);
    };
  }
});
const DefaultNode = function({
  sourcePosition = Position.Bottom,
  targetPosition = Position.Top,
  label,
  connectable = false,
  isValidTargetPos,
  isValidSourcePos
}) {
  return [
    h(_sfc_main$i, { type: "target", position: targetPosition, isConnectable: connectable, isValidConnection: isValidTargetPos }),
    typeof label !== "string" && label ? h(label) : h("div", { innerHTML: label }),
    h(_sfc_main$i, { type: "source", position: sourcePosition, isConnectable: connectable, isValidConnection: isValidSourcePos })
  ];
};
DefaultNode.props = ["sourcePosition", "targetPosition", "label", "isValidTargetPos", "isValidSourcePos", "connectable"];
DefaultNode.inheritAttrs = false;
const InputNode = function({
  sourcePosition = Position.Bottom,
  label,
  connectable = false,
  isValidSourcePos
}) {
  return [
    typeof label !== "string" && label ? h(label) : h("div", { innerHTML: label }),
    h(_sfc_main$i, { type: "source", position: sourcePosition, isConnectable: connectable, isValidConnection: isValidSourcePos })
  ];
};
InputNode.props = ["sourcePosition", "label", "isValidSourcePos", "connectable"];
InputNode.inheritAttrs = false;
const OutputNode = function({
  targetPosition = Position.Top,
  label,
  connectable = false,
  isValidTargetPos
}) {
  return [
    h(_sfc_main$i, { type: "target", position: targetPosition, isConnectable: connectable, isValidConnection: isValidTargetPos }),
    typeof label !== "string" && label ? h(label) : h("div", { innerHTML: label })
  ];
};
OutputNode.props = ["targetPosition", "label", "isValidTargetPos", "connectable"];
OutputNode.inheritAttrs = false;
const getDimensions = (node) => ({
  width: node.offsetWidth,
  height: node.offsetHeight
});
const clamp = (val, min = 0, max = 1) => Math.min(Math.max(val, min), max);
const clampPosition = (position, extent) => ({
  x: clamp(position.x, extent[0][0], extent[1][0]),
  y: clamp(position.y, extent[0][1], extent[1][1])
});
const getHostForElement = (element) => {
  const doc = element.getRootNode();
  const window2 = useWindow();
  if ("getElementFromPoint" in doc)
    return doc;
  else
    return window2.document;
};
const isEdge = (element) => "id" in element && "source" in element && "target" in element;
const isGraphEdge = (element) => isEdge(element) && "sourceNode" in element && "targetNode" in element;
const isNode = (element) => "id" in element && !isEdge(element);
const isGraphNode = (element) => isNode(element) && "computedPosition" in element;
const parseNode = (node, nodeExtent, defaults) => {
  var _a2;
  let defaultValues = defaults;
  if (!isGraphNode(node)) {
    defaultValues = {
      type: (_a2 = node.type) != null ? _a2 : "default",
      dimensions: markRaw({
        width: 0,
        height: 0
      }),
      handleBounds: {
        source: [],
        target: []
      },
      computedPosition: markRaw({
        z: 0,
        ...node.position
      }),
      draggable: void 0,
      selectable: void 0,
      connectable: void 0,
      ...defaults
    };
  }
  return {
    ...defaultValues,
    ...node,
    id: node.id.toString()
  };
};
const parseEdge = (edge, defaults) => {
  defaults = !isGraphEdge(edge) ? {
    sourceHandle: edge.sourceHandle ? edge.sourceHandle.toString() : void 0,
    targetHandle: edge.targetHandle ? edge.targetHandle.toString() : void 0,
    type: edge.type,
    source: edge.source.toString(),
    target: edge.target.toString(),
    z: 0,
    sourceX: 0,
    sourceY: 0,
    targetX: 0,
    targetY: 0,
    updatable: edge.updatable,
    selectable: edge.selectable,
    data: edge.data,
    ...defaults
  } : defaults;
  return Object.assign({ id: edge.id.toString() }, edge, defaults);
};
const getConnectedElements = (node, elements, dir) => {
  if (!isNode(node))
    return [];
  const origin = dir === "source" ? "target" : "source";
  const ids = elements.filter((e) => isEdge(e) && e[origin] === node.id).map((e) => isEdge(e) && e[dir]);
  return elements.filter((e) => ids.includes(e.id));
};
const getOutgoers = (node, elements) => getConnectedElements(node, elements, "target");
const getIncomers = (node, elements) => getConnectedElements(node, elements, "source");
const getEdgeId = ({ source, sourceHandle, target, targetHandle }) => `vueflow__edge-${source}${sourceHandle != null ? sourceHandle : ""}-${target}${targetHandle != null ? targetHandle : ""}`;
const connectionExists = (edge, elements) => elements.some(
  (el) => isEdge(el) && el.source === edge.source && el.target === edge.target && (el.sourceHandle === edge.sourceHandle || !el.sourceHandle && !edge.sourceHandle) && (el.targetHandle === edge.targetHandle || !el.targetHandle && !edge.targetHandle)
);
const addEdge = (edgeParams, elements, defaults) => {
  if (!edgeParams.source || !edgeParams.target) {
    console.warn("[vueflow]: Can't create edge. An edge needs a source and a target.");
    return elements;
  }
  let edge;
  if (isEdge(edgeParams)) {
    edge = { ...edgeParams };
  } else {
    edge = {
      ...edgeParams,
      id: getEdgeId(edgeParams)
    };
  }
  edge = parseEdge(edge, defaults);
  if (connectionExists(edge, elements))
    return elements;
  elements.push(edge);
  return elements;
};
const updateEdge = (oldEdge, newConnection, elements) => {
  if (!newConnection.source || !newConnection.target) {
    console.warn("[vueflow]: Can't create new edge. An edge needs a source and a target.");
    return elements;
  }
  const foundEdge = elements.find((e) => isEdge(e) && e.id === oldEdge.id);
  if (!foundEdge) {
    console.warn(`[vueflow]: The old edge with id=${oldEdge.id} does not exist.`);
    return elements;
  }
  const edge = {
    ...oldEdge,
    id: getEdgeId(newConnection),
    source: newConnection.source,
    target: newConnection.target,
    sourceHandle: newConnection.sourceHandle,
    targetHandle: newConnection.targetHandle
  };
  elements.splice(elements.indexOf(foundEdge), 1, edge);
  return elements.filter((e) => e.id !== oldEdge.id);
};
const pointToRendererPoint = ({ x, y }, { x: tx, y: ty, zoom: tScale }, snapToGrid, [snapX, snapY]) => {
  const position = {
    x: (x - tx) / tScale,
    y: (y - ty) / tScale
  };
  if (snapToGrid) {
    return {
      x: snapX * Math.round(position.x / snapX),
      y: snapY * Math.round(position.y / snapY)
    };
  }
  return position;
};
const getBoundsOfBoxes = (box1, box2) => ({
  x: Math.min(box1.x, box2.x),
  y: Math.min(box1.y, box2.y),
  x2: Math.max(box1.x2, box2.x2),
  y2: Math.max(box1.y2, box2.y2)
});
const rectToBox = ({ x, y, width, height }) => ({
  x,
  y,
  x2: x + width,
  y2: y + height
});
const boxToRect = ({ x, y, x2, y2 }) => ({
  x,
  y,
  width: x2 - x,
  height: y2 - y
});
const getBoundsofRects = (rect1, rect2) => boxToRect(getBoundsOfBoxes(rectToBox(rect1), rectToBox(rect2)));
const getRectOfNodes = (nodes) => {
  const box = nodes.reduce(
    (currBox, { computedPosition = { x: 0, y: 0 }, dimensions = { width: 0, height: 0 } } = {}) => getBoundsOfBoxes(
      currBox,
      rectToBox({
        ...computedPosition,
        ...dimensions
      })
    ),
    { x: Infinity, y: Infinity, x2: -Infinity, y2: -Infinity }
  );
  return boxToRect(box);
};
const graphPosToZoomedPos = ({ x, y }, { x: tx, y: ty, zoom: tScale }) => ({
  x: x * tScale + tx,
  y: y * tScale + ty
});
const getNodesInside = (nodes, rect, { x: tx, y: ty, zoom: tScale } = { x: 0, y: 0, zoom: 1 }, partially = false) => {
  const rBox = rectToBox({
    x: (rect.x - tx) / tScale,
    y: (rect.y - ty) / tScale,
    width: rect.width / tScale,
    height: rect.height / tScale
  });
  return nodes.filter((node) => {
    if (!node || node.selectable === false)
      return false;
    const { computedPosition = { x: 0, y: 0 }, dimensions = { width: 0, height: 0 } } = node;
    const nBox = rectToBox({ ...computedPosition, ...dimensions });
    const xOverlap = Math.max(0, Math.min(rBox.x2, nBox.x2) - Math.max(rBox.x, nBox.x));
    const yOverlap = Math.max(0, Math.min(rBox.y2, nBox.y2) - Math.max(rBox.y, nBox.y));
    const overlappingArea = Math.ceil(xOverlap * yOverlap);
    const notInitialized = typeof dimensions.width === "undefined" || typeof dimensions.height === "undefined" || dimensions.width === 0 || dimensions.height === 0;
    const partiallyVisible = partially && overlappingArea > 0;
    const area = dimensions.width * dimensions.height;
    return notInitialized || partiallyVisible || overlappingArea >= area;
  });
};
const getConnectedEdges = (nodes, edges) => {
  const nodeIds = nodes.map((node) => node.id);
  return edges.filter((edge) => nodeIds.includes(edge.source) || nodeIds.includes(edge.target));
};
const getTransformForBounds = (bounds, width, height, minZoom, maxZoom, padding = 0.1, offset = { x: 0, y: 0 }) => {
  var _a2, _b;
  const xZoom = width / (bounds.width * (1 + padding));
  const yZoom = height / (bounds.height * (1 + padding));
  const zoom2 = Math.min(xZoom, yZoom);
  const clampedZoom = clamp(zoom2, minZoom, maxZoom);
  const boundsCenterX = bounds.x + bounds.width / 2;
  const boundsCenterY = bounds.y + bounds.height / 2;
  const x = width / 2 - boundsCenterX * clampedZoom + ((_a2 = offset.x) != null ? _a2 : 0);
  const y = height / 2 - boundsCenterY * clampedZoom + ((_b = offset.y) != null ? _b : 0);
  return { x, y, zoom: clampedZoom };
};
const getXYZPos = (parentPos, computedPosition) => {
  return {
    x: computedPosition.x + parentPos.x,
    y: computedPosition.y + parentPos.y,
    z: parentPos.z > computedPosition.z ? parentPos.z : computedPosition.z
  };
};
const isParentSelected = (node, getNode) => {
  if (!node.parentNode)
    return false;
  const parent = getNode(node.parentNode);
  if (!parent)
    return false;
  if (parent.selected)
    return true;
  return isParentSelected(parent, getNode);
};
const getMarkerId = (marker) => {
  if (typeof marker === "undefined")
    return "";
  if (typeof marker === "string")
    return marker;
  return Object.keys(marker).sort().map((key) => `${key}=${marker[key]}`).join("&");
};
const getHandlePosition = (position, rect, handle) => {
  var _a2, _b, _c, _d;
  const x = ((_a2 = handle == null ? void 0 : handle.x) != null ? _a2 : 0) + rect.x;
  const y = ((_b = handle == null ? void 0 : handle.y) != null ? _b : 0) + rect.y;
  const width = (_c = handle == null ? void 0 : handle.width) != null ? _c : rect.width;
  const height = (_d = handle == null ? void 0 : handle.height) != null ? _d : rect.height;
  switch (position) {
    case Position.Top:
      return {
        x: x + width / 2,
        y
      };
    case Position.Right:
      return {
        x: x + width,
        y: y + height / 2
      };
    case Position.Bottom:
      return {
        x: x + width / 2,
        y: y + height
      };
    case Position.Left:
      return {
        x,
        y: y + height / 2
      };
  }
};
const getHandle = (bounds = [], handleId) => {
  if (!bounds.length)
    return void 0;
  let handle;
  if (!handleId && bounds.length === 1)
    handle = bounds[0];
  else if (handleId)
    handle = bounds.find((d) => d.id === handleId);
  return handle || bounds[0];
};
const getEdgePositions = (sourceNode, sourceHandle, sourcePosition, targetNode, targetHandle, targetPosition) => {
  const sourceHandlePos = getHandlePosition(
    sourcePosition,
    {
      ...sourceNode.dimensions,
      ...sourceNode.computedPosition
    },
    sourceHandle
  );
  const targetHandlePos = getHandlePosition(
    targetPosition,
    {
      ...targetNode.dimensions,
      ...targetNode.computedPosition
    },
    targetHandle
  );
  return {
    sourceX: sourceHandlePos.x,
    sourceY: sourceHandlePos.y,
    targetX: targetHandlePos.x,
    targetY: targetHandlePos.y
  };
};
function isEdgeVisible({
  sourcePos,
  targetPos,
  sourceWidth,
  sourceHeight,
  targetWidth,
  targetHeight,
  width,
  height,
  viewport
}) {
  const edgeBox = {
    x: Math.min(sourcePos.x, targetPos.x),
    y: Math.min(sourcePos.y, targetPos.y),
    x2: Math.max(sourcePos.x + sourceWidth, targetPos.x + targetWidth),
    y2: Math.max(sourcePos.y + sourceHeight, targetPos.y + targetHeight)
  };
  if (edgeBox.x === edgeBox.x2) {
    edgeBox.x2 += 1;
  }
  if (edgeBox.y === edgeBox.y2) {
    edgeBox.y2 += 1;
  }
  const viewBox = rectToBox({
    x: (0 - viewport.x) / viewport.zoom,
    y: (0 - viewport.y) / viewport.zoom,
    width: width / viewport.zoom,
    height: height / viewport.zoom
  });
  const xOverlap = Math.max(0, Math.min(viewBox.x2, edgeBox.x2) - Math.max(viewBox.x, edgeBox.x));
  const yOverlap = Math.max(0, Math.min(viewBox.y2, edgeBox.y2) - Math.max(viewBox.y, edgeBox.y));
  const overlappingArea = Math.ceil(xOverlap * yOverlap);
  return overlappingArea > 0;
}
const groupEdgesByZLevel = (edges, getNode) => {
  let maxLevel = -1;
  const levelLookup = edges.reduce((tree, edge) => {
    const source = getNode(edge.source);
    const target = getNode(edge.target);
    if (!source || !target)
      return tree;
    const z = edge.z ? edge.z : Math.max(source.computedPosition.z || 0, target.computedPosition.z || 0);
    if (tree[z]) {
      tree[z].push(edge);
    } else {
      tree[z] = [edge];
    }
    maxLevel = z > maxLevel ? z : maxLevel;
    return tree;
  }, {});
  return Object.entries(Object.keys(levelLookup).length ? levelLookup : { 0: [] }).map(([key, edges2]) => {
    const level = +key;
    return {
      edges: edges2,
      level,
      isMaxLevel: level === maxLevel
    };
  });
};
const getHandleBounds = (selector2, nodeElement, zoom2) => {
  const handles = nodeElement.querySelectorAll(selector2);
  if (!handles || !handles.length) {
    return void 0;
  }
  const handlesArray = Array.from(handles);
  const nodeBounds = nodeElement.getBoundingClientRect();
  return handlesArray.map((handle) => {
    const handleBounds = handle.getBoundingClientRect();
    return {
      id: handle.getAttribute("data-handleid"),
      position: handle.getAttribute("data-handlepos"),
      x: (handleBounds.left - nodeBounds.left) / zoom2,
      y: (handleBounds.top - nodeBounds.top) / zoom2,
      ...getDimensions(handle)
    };
  });
};
const handleNodeClick = (node, multiSelectionActive, addSelectedNodes, removeSelectedElements, nodesSelectionActive) => {
  nodesSelectionActive.value = false;
  if (!node.selected) {
    addSelectedNodes([node]);
  } else if (node.selected && multiSelectionActive) {
    removeSelectedElements({ nodes: [node] });
  }
};
function handleParentExpand(updateItem, parent) {
  var _a2, _b;
  if (parent) {
    const extendWidth = updateItem.position.x + updateItem.dimensions.width - parent.dimensions.width;
    const extendHeight = updateItem.position.y + updateItem.dimensions.height - parent.dimensions.height;
    if (extendWidth > 0 || extendHeight > 0 || updateItem.position.x < 0 || updateItem.position.y < 0) {
      parent.style = { ...parent.style };
      parent.style.width = (_a2 = parent.style.width) != null ? _a2 : parent.dimensions.width;
      parent.style.height = (_b = parent.style.height) != null ? _b : parent.dimensions.height;
      if (extendWidth > 0) {
        if (typeof parent.style.width === "string") {
          const currWidth = parseInt(parent.style.width, 10);
          parent.style.width = `${currWidth + extendWidth}px`;
        } else {
          parent.style.width += extendWidth;
        }
      }
      if (extendHeight > 0) {
        if (typeof parent.style.height === "string") {
          const currWidth = parseInt(parent.style.height, 10);
          parent.style.height = `${currWidth + extendHeight}px`;
        } else {
          parent.style.height += extendHeight;
        }
      }
      if (updateItem.position.x < 0) {
        const xDiff = Math.abs(updateItem.position.x);
        parent.position.x = parent.position.x - xDiff;
        if (typeof parent.style.width === "string") {
          const currWidth = parseInt(parent.style.width, 10);
          parent.style.width = `${currWidth + xDiff}px`;
        } else {
          parent.style.width += xDiff;
        }
        updateItem.position.x = 0;
      }
      if (updateItem.position.y < 0) {
        const yDiff = Math.abs(updateItem.position.y);
        parent.position.y = parent.position.y - yDiff;
        if (typeof parent.style.height === "string") {
          const currWidth = parseInt(parent.style.height, 10);
          parent.style.height = `${currWidth + yDiff}px`;
        } else {
          parent.style.height += yDiff;
        }
        updateItem.position.y = 0;
      }
    }
  }
}
const applyChanges = (changes, elements) => {
  let elementIds = elements.map((el) => el.id);
  changes.forEach((change) => {
    if (change.type === "add") {
      const item = change.item;
      return elements.push(item);
    }
    const i = elementIds.indexOf(change.id);
    const el = elements[i];
    switch (change.type) {
      case "select":
        if (isGraphNode(el) || isGraphEdge(el))
          el.selected = change.selected;
        break;
      case "position":
        if (isGraphNode(el)) {
          if (typeof change.position !== "undefined")
            el.position = change.position;
          if (typeof change.computedPosition !== "undefined") {
            el.computedPosition = { ...el.computedPosition, ...change.computedPosition };
          }
          if (el.expandParent && el.parentNode) {
            const parent = elements[elementIds.indexOf(el.parentNode)];
            if (parent && isGraphNode(parent)) {
              handleParentExpand(el, parent);
            }
          }
        }
        break;
      case "dimensions":
        if (isGraphNode(el)) {
          if (typeof change.dimensions !== "undefined")
            el.dimensions = change.dimensions;
          if (el.expandParent && el.parentNode) {
            const parent = elements[elementIds.indexOf(el.parentNode)];
            if (parent && isGraphNode(parent)) {
              handleParentExpand(el, parent);
            }
          }
        }
        break;
      case "remove":
        if (elementIds.includes(change.id)) {
          elements.splice(i, 1);
          elementIds = elements.map((el2) => el2.id);
        }
        break;
    }
  });
  return elements;
};
const applyEdgeChanges = (changes, edges) => applyChanges(changes, edges);
const applyNodeChanges = (changes, nodes) => applyChanges(changes, nodes);
const createSelectionChange = (id2, selected) => ({
  id: id2,
  type: "select",
  selected
});
const createAdditionChange = (item) => ({
  item,
  type: "add"
});
const createRemoveChange = (id2) => ({
  id: id2,
  type: "remove"
});
const getSelectionChanges = (items, selectedIds) => {
  return items.reduce((res, item) => {
    const willBeSelected = selectedIds.includes(item.id);
    if (!item.selected && willBeSelected) {
      item.selected = true;
      res.push(createSelectionChange(item.id, true));
    } else if (item.selected && !willBeSelected) {
      item.selected = false;
      res.push(createSelectionChange(item.id, false));
    }
    return res;
  }, []);
};
const isDef$2 = (val) => typeof val !== "undefined";
const addEdgeToStore = (edgeParams, edges) => {
  if (!edgeParams.source || !edgeParams.target) {
    console.warn("[vueflow]: Can't create edge. An edge needs a source and a target.");
    return false;
  }
  let edge;
  if (isEdge(edgeParams)) {
    edge = { ...edgeParams };
  } else {
    edge = {
      ...edgeParams,
      id: getEdgeId(edgeParams)
    };
  }
  edge = parseEdge(edge);
  if (connectionExists(edge, edges))
    return false;
  return edge;
};
const updateEdgeAction = (edge, newConnection, edges, add) => {
  if (!newConnection.source || !newConnection.target) {
    console.warn("[vueflow]: Can't create new edge. An edge needs a source and a target.");
    return false;
  }
  const foundEdge = edges.find((e) => isGraphEdge(e) && e.id === edge.id);
  if (!foundEdge) {
    console.warn(`[vueflow]: The old edge with id=${edge.id} does not exist.`);
    return false;
  }
  edges.splice(edges.indexOf(edge), 1);
  const newEdge = {
    ...edge,
    id: getEdgeId(newConnection),
    source: newConnection.source,
    target: newConnection.target,
    sourceHandle: newConnection.sourceHandle,
    targetHandle: newConnection.targetHandle
  };
  add([newEdge]);
  return newEdge;
};
const createGraphNodes = (nodes, getNode, currGraphNodes, extent) => {
  const parentNodes = {};
  const graphNodes = nodes.map((node) => {
    const parsed = shallowReactive(
      parseNode(node, extent, {
        ...getNode(node.id),
        parentNode: node.parentNode
      })
    );
    if (node.parentNode) {
      parentNodes[node.parentNode] = true;
    }
    return parsed;
  });
  graphNodes.forEach((node) => {
    const nextNodes = [...graphNodes, ...currGraphNodes];
    if (node.parentNode && !nextNodes.find((n) => n.id === node.parentNode)) {
      console.warn(`[vueflow]: Parent node ${node.parentNode} not found`);
    }
    if (node.parentNode || parentNodes[node.id]) {
      if (parentNodes[node.id]) {
        node.isParent = true;
      }
      const parent = node.parentNode ? getNode(node.parentNode) : void 0;
      if (parent)
        parent.isParent = true;
    }
  });
  return graphNodes;
};
const _hoisted_1$f = ["data-id"];
const __default__$g = {
  name: "Node",
  inheritAttrs: false
};
const _sfc_main$h = /* @__PURE__ */ defineComponent({
  ...__default__$g,
  props: {
    id: null,
    draggable: { type: Boolean },
    selectable: { type: Boolean },
    connectable: { type: Boolean },
    snapGrid: null,
    type: { type: [null, Function, Object, Boolean] },
    name: null,
    node: null
  },
  setup(__props) {
    const props = createPropsRestProxy(__props, ["id", "type", "name", "draggable", "selectable", "connectable", "snapGrid"]);
    provide(NodeId, __props.id);
    const __$temp_1 = useVueFlow(), edges = toRef(__$temp_1, "edges"), viewport = toRef(__$temp_1, "viewport"), noPanClassName = toRef(__$temp_1, "noPanClassName"), selectNodesOnDrag = toRef(__$temp_1, "selectNodesOnDrag"), nodesSelectionActive = toRef(__$temp_1, "nodesSelectionActive"), multiSelectionActive = toRef(__$temp_1, "multiSelectionActive"), emits = toRef(__$temp_1, "emits"), getNode = toRef(__$temp_1, "getNode"), removeSelectedElements = toRef(__$temp_1, "removeSelectedElements"), addSelectedNodes = toRef(__$temp_1, "addSelectedNodes"), updateNodeDimensions = toRef(__$temp_1, "updateNodeDimensions"), onUpdateNodeInternals = toRef(__$temp_1, "onUpdateNodeInternals");
    const node = useVModel(props, "node");
    const parentNode = computed(() => node.value.parentNode ? getNode.value(node.value.parentNode) : void 0);
    const nodeElement = ref();
    const { emit, on } = useNodeHooks(node.value, emits.value);
    let scope = effectScope();
    const dragging = useDrag({
      id: __props.id,
      el: nodeElement,
      disabled: computed(() => !__props.draggable),
      onStart(event, node2, nodes) {
        emit.dragStart({ event, node: node2, nodes });
      },
      onDrag(event, node2, nodes) {
        emit.drag({ event, node: node2, nodes });
      },
      onStop(event, node2, nodes) {
        emit.dragStop({ event, node: node2, nodes });
      }
    });
    const observer = useResizeObserver(
      nodeElement,
      () => {
        updateNodeDimensions.value([{ id: __props.id, nodeElement: nodeElement.value }]);
      },
      { box: "content-box" }
    );
    const updatePosition2 = (nodePos, parentPos) => {
      if (parentPos) {
        node.value.computedPosition = getXYZPos({ x: parentPos.x, y: parentPos.y, z: parentPos.z }, nodePos);
      } else {
        node.value.computedPosition = nodePos;
      }
    };
    const updateInternals = () => {
      if (nodeElement.value)
        updateNodeDimensions.value([{ id: __props.id, nodeElement: nodeElement.value, forceUpdate: true }]);
      updatePosition2(
        {
          x: node.value.position.x,
          y: node.value.position.y,
          z: node.value.computedPosition.z ? node.value.computedPosition.z : node.value.selected ? 1e3 : 0
        },
        parentNode.value ? { ...parentNode.value.computedPosition } : void 0
      );
    };
    onUpdateNodeInternals.value((updateIds) => {
      if (updateIds.includes(__props.id)) {
        updateInternals();
      }
    });
    onMounted(() => {
      if (!scope)
        scope = effectScope();
      scope.run(() => {
        watch(
          [() => node.value.width, () => node.value.height, () => node.value.type, () => node.value.sourcePosition, () => node.value.targetPosition],
          () => {
            updateNodeDimensions.value([{ id: __props.id, nodeElement: nodeElement.value, forceUpdate: true }]);
          },
          { flush: "post", immediate: true }
        );
        watch(
          [
            () => node.value.position.x,
            () => node.value.position.y,
            () => {
              var _a2;
              return (_a2 = parentNode.value) == null ? void 0 : _a2.computedPosition.x;
            },
            () => {
              var _a2;
              return (_a2 = parentNode.value) == null ? void 0 : _a2.computedPosition.y;
            },
            () => {
              var _a2;
              return (_a2 = parentNode.value) == null ? void 0 : _a2.computedPosition.z;
            },
            () => node.value.selected,
            () => node.value.dimensions,
            () => {
              var _a2;
              return (_a2 = parentNode.value) == null ? void 0 : _a2.dimensions;
            }
          ],
          ([newX, newY, parentX, parentY, parentZ]) => {
            const xyzPos = {
              x: newX,
              y: newY,
              z: node.value.selected ? 1e3 : 0
            };
            updatePosition2(xyzPos, parentX && parentY ? { x: parentX, y: parentY, z: parentZ } : void 0);
            node.value.handleBounds = {
              source: getHandleBounds(".source", nodeElement.value, viewport.value.zoom),
              target: getHandleBounds(".target", nodeElement.value, viewport.value.zoom)
            };
          },
          { immediate: true, flush: "post" }
        );
      });
    });
    onBeforeUnmount(() => {
      observer.stop();
      scope == null ? void 0 : scope.stop();
      scope = void 0;
    });
    const onMouseEnter = (event) => {
      if (!(dragging == null ? void 0 : dragging.value)) {
        emit.mouseEnter({ event, node: node.value, connectedEdges: getConnectedEdges([node.value], edges.value) });
      }
    };
    const onMouseMove = (event) => {
      if (!(dragging == null ? void 0 : dragging.value)) {
        emit.mouseMove({ event, node: node.value, connectedEdges: getConnectedEdges([node.value], edges.value) });
      }
    };
    const onMouseLeave = (event) => {
      if (!(dragging == null ? void 0 : dragging.value)) {
        emit.mouseLeave({ event, node: node.value, connectedEdges: getConnectedEdges([node.value], edges.value) });
      }
    };
    const onContextMenu = (event) => {
      emit.contextMenu({
        event,
        node: node.value,
        connectedEdges: getConnectedEdges([node.value], edges.value)
      });
    };
    const onDoubleClick = (event) => {
      emit.doubleClick({ event, node: node.value, connectedEdges: getConnectedEdges([node.value], edges.value) });
    };
    const onSelectNode = (event) => {
      if (__props.selectable && (!selectNodesOnDrag.value || !__props.draggable)) {
        handleNodeClick(node.value, multiSelectionActive.value, addSelectedNodes.value, removeSelectedElements.value, nodesSelectionActive);
      }
      emit.click({ event, node: node.value, connectedEdges: getConnectedEdges([node.value], edges.value) });
    };
    const getClass = computed(() => {
      return node.value.class instanceof Function ? node.value.class(node.value) : node.value.class;
    });
    const getStyle = computed(() => {
      const styles = (node.value.style instanceof Function ? node.value.style(node.value) : node.value.style) || {};
      const width = node.value.width instanceof Function ? node.value.width(node.value) : node.value.width;
      const height = node.value.height instanceof Function ? node.value.height(node.value) : node.value.height;
      if (width)
        styles.width = typeof width === "string" ? width : `${width}px`;
      if (height)
        styles.height = typeof height === "string" ? height : `${height}px`;
      return styles;
    });
    return (_ctx, _cache) => {
      var _a2;
      return openBlock(), createElementBlock("div", {
        ref_key: "nodeElement",
        ref: nodeElement,
        class: normalizeClass(["vue-flow__node", [
          `vue-flow__node-${__props.name}`,
          noPanClassName.value,
          {
            dragging: unref(dragging),
            selected: node.value.selected,
            selectable: __props.selectable
          },
          unref(getClass)
        ]]),
        style: normalizeStyle({
          zIndex: (_a2 = node.value.computedPosition.z) != null ? _a2 : 0,
          transform: `translate(${node.value.computedPosition.x}px,${node.value.computedPosition.y}px)`,
          pointerEvents: __props.selectable || __props.draggable ? "all" : "none",
          ...unref(getStyle)
        }),
        "data-id": node.value.id,
        onMouseenter: onMouseEnter,
        onMousemove: onMouseMove,
        onMouseleave: onMouseLeave,
        onContextmenu: onContextMenu,
        onClick: onSelectNode,
        onDblclick: onDoubleClick
      }, [
        (openBlock(), createBlock(resolveDynamicComponent(__props.type), {
          id: node.value.id,
          type: node.value.type,
          data: node.value.data,
          events: { ...node.value.events, ...unref(on) },
          selected: !!node.value.selected,
          connectable: __props.connectable,
          position: node.value.position,
          dimensions: node.value.dimensions,
          "is-valid-target-pos": node.value.isValidTargetPos,
          "is-valid-source-pos": node.value.isValidSourcePos,
          "parent-node": node.value.parentNode,
          dragging: unref(dragging),
          "z-index": node.value.computedPosition.z,
          "target-position": node.value.targetPosition,
          "source-position": node.value.sourcePosition,
          label: node.value.label,
          "drag-handle": node.value.dragHandle,
          onUpdateNodeInternals: updateInternals
        }, null, 40, ["id", "type", "data", "events", "selected", "connectable", "position", "dimensions", "is-valid-target-pos", "is-valid-source-pos", "parent-node", "dragging", "z-index", "target-position", "source-position", "label", "drag-handle"]))
      ], 46, _hoisted_1$f);
    };
  }
});
const _hoisted_1$e = ["transform"];
const _hoisted_2$9 = ["width", "height", "x", "y", "rx", "ry"];
const _hoisted_3$7 = ["y"];
const __default__$f = {
  name: "EdgeText"
};
const _sfc_main$g = /* @__PURE__ */ defineComponent({
  ...__default__$f,
  props: {
    x: null,
    y: null,
    label: null,
    labelStyle: { default: () => ({}) },
    labelShowBg: { type: Boolean, default: true },
    labelBgStyle: { default: () => ({}) },
    labelBgPadding: { default: () => [2, 4] },
    labelBgBorderRadius: { default: 2 }
  },
  setup(__props) {
    const edgeRef = templateRef("el", null);
    let box = ref({ x: 0, y: 0, width: 0, height: 0 });
    onMounted(() => {
      box.value = edgeRef.value.getBBox();
    });
    const transform = computed(() => `translate(${__props.x - box.value.width / 2} ${__props.y - box.value.height / 2})`);
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("g", {
        transform: unref(transform),
        class: "vue-flow__edge-textwrapper"
      }, [
        __props.labelShowBg ? (openBlock(), createElementBlock("rect", {
          key: 0,
          class: "vue-flow__edge-textbg",
          width: `${box.value.width + 2 * __props.labelBgPadding[0]}px`,
          height: `${box.value.height + 2 * __props.labelBgPadding[1]}px`,
          x: -__props.labelBgPadding[0],
          y: -__props.labelBgPadding[1],
          style: normalizeStyle(__props.labelBgStyle),
          rx: __props.labelBgBorderRadius,
          ry: __props.labelBgBorderRadius
        }, null, 12, _hoisted_2$9)) : createCommentVNode("", true),
        createElementVNode("text", mergeProps(_ctx.$attrs, {
          ref: "el",
          class: "vue-flow__edge-text",
          y: box.value.height / 2,
          dy: "0.3em",
          style: __props.labelStyle
        }), [
          renderSlot(_ctx.$slots, "default", {}, () => [
            typeof __props.label !== "string" && typeof __props.label ? (openBlock(), createBlock(resolveDynamicComponent(__props.label), { key: 0 })) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
              createTextVNode(toDisplayString(__props.label), 1)
            ], 64))
          ])
        ], 16, _hoisted_3$7)
      ], 8, _hoisted_1$e);
    };
  }
});
const BaseEdge = function({
  path,
  centerX,
  centerY,
  label,
  labelBgBorderRadius,
  labelBgPadding,
  labelBgStyle,
  labelShowBg,
  labelStyle,
  markerStart,
  markerEnd,
  style
}) {
  return [
    h("path", {
      "style": { ...style },
      "d": path,
      "class": "vue-flow__edge-path",
      "marker-end": markerEnd,
      "marker-start": markerStart
    }),
    label ? h(_sfc_main$g, {
      x: centerX,
      y: centerY,
      label,
      labelStyle,
      labelShowBg,
      labelBgStyle,
      labelBgPadding,
      labelBgBorderRadius
    }) : null
  ];
};
BaseEdge.props = [
  "path",
  "centerX",
  "centerY",
  "label",
  "labelBgBorderRadius",
  "labelBgPadding",
  "labelBgStyle",
  "labelShowBg",
  "labelStyle",
  "markerStart",
  "markerEnd",
  "style"
];
BaseEdge.inheritAttrs = false;
function calculateControlOffset(distance, curvature) {
  if (distance >= 0) {
    return 0.5 * distance;
  } else {
    return curvature * 25 * Math.sqrt(-distance);
  }
}
function getControlWithCurvature({ pos, x1, y1, x2, y2, c }) {
  let ctX, ctY;
  switch (pos) {
    case Position.Left:
      ctX = x1 - calculateControlOffset(x1 - x2, c);
      ctY = y1;
      break;
    case Position.Right:
      ctX = x1 + calculateControlOffset(x2 - x1, c);
      ctY = y1;
      break;
    case Position.Top:
      ctX = x1;
      ctY = y1 - calculateControlOffset(y1 - y2, c);
      break;
    case Position.Bottom:
      ctX = x1;
      ctY = y1 + calculateControlOffset(y2 - y1, c);
      break;
  }
  return [ctX, ctY];
}
function getBezierPath({
  sourceX,
  sourceY,
  sourcePosition = Position.Bottom,
  targetX,
  targetY,
  targetPosition = Position.Top,
  curvature = 0.25
}) {
  const [sourceControlX, sourceControlY] = getControlWithCurvature({
    pos: sourcePosition,
    x1: sourceX,
    y1: sourceY,
    x2: targetX,
    y2: targetY,
    c: curvature
  });
  const [targetControlX, targetControlY] = getControlWithCurvature({
    pos: targetPosition,
    x1: targetX,
    y1: targetY,
    x2: sourceX,
    y2: sourceY,
    c: curvature
  });
  return `M${sourceX},${sourceY} C${sourceControlX},${sourceControlY} ${targetControlX},${targetControlY} ${targetX},${targetY}`;
}
function getBezierCenter({
  sourceX,
  sourceY,
  sourcePosition = Position.Bottom,
  targetX,
  targetY,
  targetPosition = Position.Top,
  curvature = 0.25
}) {
  const [sourceControlX, sourceControlY] = getControlWithCurvature({
    pos: sourcePosition,
    x1: sourceX,
    y1: sourceY,
    x2: targetX,
    y2: targetY,
    c: curvature
  });
  const [targetControlX, targetControlY] = getControlWithCurvature({
    pos: targetPosition,
    x1: targetX,
    y1: targetY,
    x2: sourceX,
    y2: sourceY,
    c: curvature
  });
  const centerX = sourceX * 0.125 + sourceControlX * 0.375 + targetControlX * 0.375 + targetX * 0.125;
  const centerY = sourceY * 0.125 + sourceControlY * 0.375 + targetControlY * 0.375 + targetY * 0.125;
  const xOffset = Math.abs(centerX - sourceX);
  const yOffset = Math.abs(centerY - sourceY);
  return [centerX, centerY, xOffset, yOffset];
}
function getControl({ pos, x1, y1, x2, y2 }) {
  let ctX, ctY;
  switch (pos) {
    case Position.Left:
    case Position.Right:
      ctX = 0.5 * (x1 + x2);
      ctY = y1;
      break;
    case Position.Top:
    case Position.Bottom:
      ctX = x1;
      ctY = 0.5 * (y1 + y2);
      break;
  }
  return [ctX, ctY];
}
function getSimpleBezierPath({
  sourceX,
  sourceY,
  sourcePosition = Position.Bottom,
  targetX,
  targetY,
  targetPosition = Position.Top
}) {
  const [sourceControlX, sourceControlY] = getControl({
    pos: sourcePosition,
    x1: sourceX,
    y1: sourceY,
    x2: targetX,
    y2: targetY
  });
  const [targetControlX, targetControlY] = getControl({
    pos: targetPosition,
    x1: targetX,
    y1: targetY,
    x2: sourceX,
    y2: sourceY
  });
  return `M${sourceX},${sourceY} C${sourceControlX},${sourceControlY} ${targetControlX},${targetControlY} ${targetX},${targetY}`;
}
function getSimpleBezierCenter({
  sourceX,
  sourceY,
  sourcePosition = Position.Bottom,
  targetX,
  targetY,
  targetPosition = Position.Top
}) {
  const [sourceControlX, sourceControlY] = getControl({
    pos: sourcePosition,
    x1: sourceX,
    y1: sourceY,
    x2: targetX,
    y2: targetY
  });
  const [targetControlX, targetControlY] = getControl({
    pos: targetPosition,
    x1: targetX,
    y1: targetY,
    x2: sourceX,
    y2: sourceY
  });
  const centerX = sourceX * 0.125 + sourceControlX * 0.375 + targetControlX * 0.375 + targetX * 0.125;
  const centerY = sourceY * 0.125 + sourceControlY * 0.375 + targetControlY * 0.375 + targetY * 0.125;
  const xOffset = Math.abs(centerX - sourceX);
  const yOffset = Math.abs(centerY - sourceY);
  return [centerX, centerY, xOffset, yOffset];
}
const LeftOrRight = [Position.Left, Position.Right];
const getCenter = ({
  sourceX,
  sourceY,
  targetX,
  targetY,
  sourcePosition = Position.Bottom,
  targetPosition = Position.Top
}) => {
  const sourceIsLeftOrRight = LeftOrRight.includes(sourcePosition);
  const targetIsLeftOrRight = LeftOrRight.includes(targetPosition);
  const mixedEdge = sourceIsLeftOrRight && !targetIsLeftOrRight || targetIsLeftOrRight && !sourceIsLeftOrRight;
  if (mixedEdge) {
    const xOffset2 = sourceIsLeftOrRight ? Math.abs(targetX - sourceX) : 0;
    const centerX2 = sourceX > targetX ? sourceX - xOffset2 : sourceX + xOffset2;
    const yOffset2 = sourceIsLeftOrRight ? 0 : Math.abs(targetY - sourceY);
    const centerY2 = sourceY < targetY ? sourceY + yOffset2 : sourceY - yOffset2;
    return [centerX2, centerY2, xOffset2, yOffset2];
  }
  const xOffset = Math.abs(targetX - sourceX) / 2;
  const centerX = targetX < sourceX ? targetX + xOffset : targetX - xOffset;
  const yOffset = Math.abs(targetY - sourceY) / 2;
  const centerY = targetY < sourceY ? targetY + yOffset : targetY - yOffset;
  return [centerX, centerY, xOffset, yOffset];
};
const bottomLeftCorner = (x, y, size) => `L ${x},${y - size}Q ${x},${y} ${x + size},${y}`;
const leftBottomCorner = (x, y, size) => `L ${x + size},${y}Q ${x},${y} ${x},${y - size}`;
const bottomRightCorner = (x, y, size) => `L ${x},${y - size}Q ${x},${y} ${x - size},${y}`;
const rightBottomCorner = (x, y, size) => `L ${x - size},${y}Q ${x},${y} ${x},${y - size}`;
const leftTopCorner = (x, y, size) => `L ${x + size},${y}Q ${x},${y} ${x},${y + size}`;
const topLeftCorner = (x, y, size) => `L ${x},${y + size}Q ${x},${y} ${x + size},${y}`;
const topRightCorner = (x, y, size) => `L ${x},${y + size}Q ${x},${y} ${x - size},${y}`;
const rightTopCorner = (x, y, size) => `L ${x - size},${y}Q ${x},${y} ${x},${y + size}`;
function getSmoothStepPath({
  sourceX,
  sourceY,
  sourcePosition = Position.Bottom,
  targetX,
  targetY,
  targetPosition = Position.Top,
  borderRadius = 5,
  centerX,
  centerY
}) {
  const [_centerX, _centerY, offsetX, offsetY] = getCenter({ sourceX, sourceY, targetX, targetY });
  const cornerWidth = Math.min(borderRadius, Math.abs(targetX - sourceX));
  const cornerHeight = Math.min(borderRadius, Math.abs(targetY - sourceY));
  const cornerSize = Math.min(cornerWidth, cornerHeight, offsetX, offsetY);
  const leftAndRight = [Position.Left, Position.Right];
  const cX = typeof centerX !== "undefined" ? centerX : _centerX;
  const cY = typeof centerY !== "undefined" ? centerY : _centerY;
  let firstCornerPath;
  let secondCornerPath;
  if (sourceX <= targetX) {
    firstCornerPath = sourceY <= targetY ? bottomLeftCorner(sourceX, cY, cornerSize) : topLeftCorner(sourceX, cY, cornerSize);
    secondCornerPath = sourceY <= targetY ? rightTopCorner(targetX, cY, cornerSize) : rightBottomCorner(targetX, cY, cornerSize);
  } else {
    firstCornerPath = sourceY < targetY ? bottomRightCorner(sourceX, cY, cornerSize) : topRightCorner(sourceX, cY, cornerSize);
    secondCornerPath = sourceY < targetY ? leftTopCorner(targetX, cY, cornerSize) : leftBottomCorner(targetX, cY, cornerSize);
  }
  if (leftAndRight.includes(sourcePosition) && leftAndRight.includes(targetPosition)) {
    if (sourceX <= targetX) {
      firstCornerPath = sourceY <= targetY ? rightTopCorner(cX, sourceY, cornerSize) : rightBottomCorner(cX, sourceY, cornerSize);
      secondCornerPath = sourceY <= targetY ? bottomLeftCorner(cX, targetY, cornerSize) : topLeftCorner(cX, targetY, cornerSize);
    } else if (sourcePosition === Position.Right && targetPosition === Position.Left || sourcePosition === Position.Left && targetPosition === Position.Right || sourcePosition === Position.Left && targetPosition === Position.Left) {
      firstCornerPath = sourceY <= targetY ? leftTopCorner(cX, sourceY, cornerSize) : leftBottomCorner(cX, sourceY, cornerSize);
      secondCornerPath = sourceY <= targetY ? bottomRightCorner(cX, targetY, cornerSize) : topRightCorner(cX, targetY, cornerSize);
    }
  } else if (leftAndRight.includes(sourcePosition) && !leftAndRight.includes(targetPosition)) {
    if (sourceX <= targetX) {
      firstCornerPath = sourceY <= targetY ? rightTopCorner(targetX, sourceY, cornerSize) : rightBottomCorner(targetX, sourceY, cornerSize);
    } else {
      firstCornerPath = sourceY <= targetY ? leftTopCorner(targetX, sourceY, cornerSize) : leftBottomCorner(targetX, sourceY, cornerSize);
    }
    secondCornerPath = "";
  } else if (!leftAndRight.includes(sourcePosition) && leftAndRight.includes(targetPosition)) {
    if (sourceX <= targetX) {
      firstCornerPath = sourceY <= targetY ? bottomLeftCorner(sourceX, targetY, cornerSize) : topLeftCorner(sourceX, targetY, cornerSize);
    } else {
      firstCornerPath = sourceY <= targetY ? bottomRightCorner(sourceX, targetY, cornerSize) : topRightCorner(sourceX, targetY, cornerSize);
    }
    secondCornerPath = "";
  }
  return `M ${sourceX},${sourceY}${firstCornerPath}${secondCornerPath}L ${targetX},${targetY}`;
}
const BezierEdge = function({
  sourcePosition = Position.Bottom,
  targetPosition = Position.Top,
  label,
  labelStyle = {},
  labelShowBg = true,
  labelBgStyle = {},
  labelBgPadding,
  labelBgBorderRadius,
  sourceY,
  sourceX,
  targetX,
  targetY,
  curvature,
  markerEnd,
  markerStart,
  style
}) {
  const [centerX, centerY] = getBezierCenter({
    sourceX,
    sourceY,
    targetX,
    targetY,
    sourcePosition,
    targetPosition,
    curvature
  });
  const path = getBezierPath({
    sourceX,
    sourceY,
    targetX,
    targetY,
    sourcePosition,
    targetPosition,
    curvature
  });
  return h(BaseEdge, {
    path,
    centerX,
    centerY,
    label,
    labelStyle,
    labelShowBg,
    labelBgStyle,
    labelBgPadding,
    labelBgBorderRadius,
    style,
    markerEnd,
    markerStart
  });
};
BezierEdge.props = [
  "sourcePosition",
  "targetPosition",
  "label",
  "labelStyle",
  "labelShowBg",
  "labelBgStyle",
  "labelBgPadding",
  "labelBgBorderRadius",
  "sourceY",
  "sourceX",
  "targetX",
  "targetY",
  "curvature",
  "markerEnd",
  "markerStart",
  "style"
];
BezierEdge.inheritAttrs = false;
const SimpleBezierEdge = function({
  sourcePosition = Position.Bottom,
  targetPosition = Position.Top,
  label,
  labelStyle = {},
  labelShowBg = true,
  labelBgStyle = {},
  labelBgPadding,
  labelBgBorderRadius,
  sourceY,
  sourceX,
  targetX,
  targetY,
  markerEnd,
  markerStart,
  style
}) {
  const [centerX, centerY] = getSimpleBezierCenter({
    sourceX,
    sourceY,
    targetX,
    targetY,
    sourcePosition,
    targetPosition
  });
  const path = getSimpleBezierPath({
    sourceX,
    sourceY,
    targetX,
    targetY,
    sourcePosition,
    targetPosition
  });
  return h(BaseEdge, {
    path,
    centerX,
    centerY,
    label,
    labelStyle,
    labelShowBg,
    labelBgStyle,
    labelBgPadding,
    labelBgBorderRadius,
    style,
    markerEnd,
    markerStart
  });
};
SimpleBezierEdge.props = [
  "sourcePosition",
  "targetPosition",
  "label",
  "labelStyle",
  "labelShowBg",
  "labelBgStyle",
  "labelBgPadding",
  "labelBgBorderRadius",
  "sourceY",
  "sourceX",
  "targetX",
  "targetY",
  "markerEnd",
  "markerStart",
  "style"
];
SimpleBezierEdge.inheritAttrs = false;
const SmoothStepEdge = function({
  sourcePosition = Position.Bottom,
  targetPosition = Position.Top,
  label,
  labelStyle = {},
  labelShowBg = true,
  labelBgStyle = {},
  labelBgPadding,
  labelBgBorderRadius,
  sourceY,
  sourceX,
  targetX,
  targetY,
  markerEnd,
  markerStart,
  borderRadius,
  style
}) {
  const [centerX, centerY] = getCenter({
    sourceX,
    sourceY,
    targetX,
    targetY,
    sourcePosition,
    targetPosition
  });
  const path = getSmoothStepPath({
    sourceX,
    sourceY,
    targetX,
    targetY,
    sourcePosition,
    targetPosition,
    borderRadius
  });
  return h(BaseEdge, {
    path,
    centerX,
    centerY,
    label,
    labelStyle,
    labelShowBg,
    labelBgStyle,
    labelBgPadding,
    labelBgBorderRadius,
    style,
    markerEnd,
    markerStart
  });
};
SmoothStepEdge.props = [
  "sourcePosition",
  "targetPosition",
  "label",
  "labelStyle",
  "labelShowBg",
  "labelBgStyle",
  "labelBgPadding",
  "labelBgBorderRadius",
  "sourceY",
  "sourceX",
  "targetX",
  "targetY",
  "borderRadius",
  "markerEnd",
  "markerStart",
  "style"
];
SmoothStepEdge.inheritAttrs = false;
const StepEdge = function(props) {
  return h(SmoothStepEdge, { ...props, borderRadius: 0 });
};
StepEdge.props = [
  "sourcePosition",
  "targetPosition",
  "label",
  "labelStyle",
  "labelShowBg",
  "labelBgStyle",
  "labelBgPadding",
  "labelBgBorderRadius",
  "sourceY",
  "sourceX",
  "targetX",
  "targetY",
  "markerEnd",
  "markerStart",
  "style"
];
StepEdge.inheritAttrs = false;
const StraightEdge = function({
  label,
  labelStyle = {},
  labelShowBg = true,
  labelBgStyle = {},
  labelBgPadding,
  labelBgBorderRadius,
  sourceY,
  sourceX,
  targetX,
  targetY,
  markerEnd,
  markerStart,
  style
}) {
  const centerY = computed(() => {
    const yOffset = Math.abs(targetY - sourceY) / 2;
    return targetY < sourceY ? targetY + yOffset : targetY - yOffset;
  });
  const centerX = computed(() => {
    const xOffset = Math.abs(targetX - sourceX) / 2;
    return targetX < sourceX ? targetX + xOffset : targetX - xOffset;
  });
  return h(BaseEdge, {
    path: `M ${sourceX},${sourceY}L ${targetX},${targetY}`,
    centerX: centerX.value,
    centerY: centerY.value,
    label,
    labelStyle,
    labelShowBg,
    labelBgStyle,
    labelBgPadding,
    labelBgBorderRadius,
    style,
    markerEnd,
    markerStart
  });
};
StraightEdge.props = [
  "label",
  "labelStyle",
  "labelShowBg",
  "labelBgStyle",
  "labelBgPadding",
  "labelBgBorderRadius",
  "sourceY",
  "sourceX",
  "targetX",
  "targetY",
  "markerEnd",
  "markerStart",
  "style"
];
StraightEdge.inheritAttrs = false;
const shiftX = (x, shift, position) => {
  if (position === Position.Left)
    return x - shift;
  if (position === Position.Right)
    return x + shift;
  return x;
};
const shiftY = (y, shift, position) => {
  if (position === Position.Top)
    return y - shift;
  if (position === Position.Bottom)
    return y + shift;
  return y;
};
const EdgeAnchor = function({ radius = 10, centerX = 0, centerY = 0, position = Position.Top }) {
  const cx = computed(() => {
    const val = shiftX(centerX, radius, position);
    if (isNaN(val))
      return 0;
    else
      return val;
  });
  const cy = computed(() => {
    const val = shiftY(centerY, radius, position);
    if (isNaN(val))
      return 0;
    else
      return val;
  });
  return h("circle", {
    class: "vue-flow__edgeupdater",
    cx: cx.value,
    cy: cy.value,
    r: radius,
    stroke: "transparent",
    fill: "transparent"
  });
};
EdgeAnchor.props = ["radius", "centerX", "centerY", "position"];
const Wrapper = function({
  name,
  type,
  id: id2,
  data,
  events,
  labelBgBorderRadius,
  labelBgPadding,
  labelBgStyle,
  labelStyle,
  labelShowBg,
  style,
  animated,
  label,
  updatable,
  selectable,
  target,
  source,
  sourceNode,
  targetNode,
  sourceHandleId,
  targetHandleId,
  selected,
  markerEnd,
  markerStart,
  connectionMode,
  edgeUpdaterRadius
}, { emit }) {
  var _a2, _b;
  if (!sourceNode || !targetNode)
    return null;
  let updating = ref(false);
  const onEdgeUpdaterMouseEnter = () => updating.value = true;
  const onEdgeUpdaterMouseOut = () => updating.value = false;
  const onEdgeUpdaterSourceMouseDown = (e) => {
    emit("source-mousedown", e);
  };
  const onEdgeUpdaterTargetMouseDown = (e) => {
    emit("target-mousedown", e);
  };
  let sourceNodeHandles;
  if (connectionMode === ConnectionMode.Strict) {
    sourceNodeHandles = sourceNode.handleBounds.source;
  } else {
    sourceNodeHandles = (_a2 = sourceNode.handleBounds.source) != null ? _a2 : sourceNode.handleBounds.target;
  }
  const sourceHandle = getHandle(sourceNodeHandles, sourceHandleId);
  let targetNodeHandles;
  if (connectionMode === ConnectionMode.Strict) {
    targetNodeHandles = targetNode.handleBounds.target;
  } else {
    targetNodeHandles = (_b = targetNode.handleBounds.target) != null ? _b : targetNode.handleBounds.source;
  }
  const targetHandle = getHandle(targetNodeHandles, targetHandleId);
  const sourcePosition = sourceHandle ? sourceHandle.position : Position.Bottom;
  const targetPosition = targetHandle ? targetHandle.position : Position.Top;
  const { sourceX, sourceY, targetY, targetX } = getEdgePositions(
    sourceNode,
    sourceHandle,
    sourcePosition,
    targetNode,
    targetHandle,
    targetPosition
  );
  return h(
    "g",
    {
      class: [
        "vue-flow__edge",
        `vue-flow__edge-${name}`,
        {
          updating: updating.value,
          selected,
          animated,
          inactive: !selectable
        }
      ]
    },
    [
      h(type, {
        id: id2,
        sourceNode,
        targetNode,
        source,
        target,
        updatable,
        selected,
        animated,
        label,
        labelStyle,
        labelShowBg,
        labelBgStyle,
        labelBgPadding,
        labelBgBorderRadius,
        data,
        events,
        style,
        markerStart: `url(#${getMarkerId(markerStart)})`,
        markerEnd: `url(#${getMarkerId(markerEnd)})`,
        sourcePosition,
        targetPosition,
        sourceX,
        sourceY,
        targetX,
        targetY,
        sourceHandleId,
        targetHandleId
      }),
      updatable ? [
        h(
          "g",
          {
            onMousedown: onEdgeUpdaterSourceMouseDown,
            onMouseenter: onEdgeUpdaterMouseEnter,
            onMouseout: onEdgeUpdaterMouseOut
          },
          h(EdgeAnchor, {
            position: sourcePosition,
            centerX: sourceX,
            centerY: sourceY,
            radius: edgeUpdaterRadius
          })
        ),
        h(
          "g",
          {
            onMousedown: onEdgeUpdaterTargetMouseDown,
            onMouseenter: onEdgeUpdaterMouseEnter,
            onMouseout: onEdgeUpdaterMouseOut
          },
          h(EdgeAnchor, {
            position: targetPosition,
            centerX: targetX,
            centerY: targetY,
            radius: edgeUpdaterRadius
          })
        )
      ] : null
    ]
  );
};
Wrapper.props = [
  "name",
  "type",
  "id",
  "data",
  "events",
  "labelBgBorderRadius",
  "labelBgPadding",
  "labelBgStyle",
  "labelStyle",
  "labelShowBg",
  "style",
  "animated",
  "label",
  "updatable",
  "selectable",
  "target",
  "source",
  "sourceNode",
  "targetNode",
  "sourceHandleId",
  "targetHandleId",
  "selected",
  "markerEnd",
  "markerStart",
  "connectionMode",
  "edgeUpdaterRadius"
];
Wrapper.emits = ["source-mousedown", "target-mousedown"];
const _hoisted_1$d = { class: "vue-flow__connection" };
const _hoisted_2$8 = ["d", "marker-end", "marker-start"];
const __default__$e = {
  name: "ConnectionLine"
};
const _sfc_main$f = /* @__PURE__ */ defineComponent({
  ...__default__$e,
  props: {
    sourceNode: null
  },
  setup(__props) {
    var _a2, _b, _c, _d;
    const __$temp_1 = useVueFlow(), getNodes = toRef(__$temp_1, "getNodes"), connectionHandleId = toRef(__$temp_1, "connectionHandleId"), connectionHandleType = toRef(__$temp_1, "connectionHandleType"), connectionPosition = toRef(__$temp_1, "connectionPosition"), connectionLineType = toRef(__$temp_1, "connectionLineType"), connectionLineStyle = toRef(__$temp_1, "connectionLineStyle");
    toRef(__$temp_1, "connectionNodeId");
    const connectionLineOptions = toRef(__$temp_1, "connectionLineOptions"), viewport = toRef(__$temp_1, "viewport");
    const slots = (_a2 = inject(Slots)) == null ? void 0 : _a2["connection-line"];
    const hasSlot = slots == null ? void 0 : slots({});
    const sourceHandle = connectionHandleId.value && connectionHandleType.value ? (_b = __props.sourceNode.handleBounds[connectionHandleType.value]) == null ? void 0 : _b.find((d) => d.id === connectionHandleId.value) : connectionHandleType.value && ((_d = __props.sourceNode.handleBounds[(_c = connectionHandleType.value) != null ? _c : "source"]) == null ? void 0 : _d[0]);
    const sourceHandleX = sourceHandle ? sourceHandle.x + sourceHandle.width / 2 : __props.sourceNode.dimensions.width / 2;
    const sourceHandleY = sourceHandle ? sourceHandle.y + sourceHandle.height / 2 : __props.sourceNode.dimensions.height;
    const sourceX = __props.sourceNode.computedPosition.x + sourceHandleX;
    const sourceY = __props.sourceNode.computedPosition.y + sourceHandleY;
    const isRightOrLeft = (sourceHandle == null ? void 0 : sourceHandle.position) === Position.Left || (sourceHandle == null ? void 0 : sourceHandle.position) === Position.Right;
    const targetPosition = isRightOrLeft ? Position.Left : Position.Top;
    const targetX = computed(() => (connectionPosition.value.x - viewport.value.x) / viewport.value.zoom);
    const targetY = computed(() => (connectionPosition.value.y - viewport.value.y) / viewport.value.zoom);
    const dAttr = computed(() => {
      let path = `M${sourceX},${sourceY} ${targetX.value},${targetY.value}`;
      switch (connectionLineType.value || connectionLineOptions.value.type) {
        case ConnectionLineType.Bezier:
          path = getBezierPath({
            sourceX,
            sourceY,
            sourcePosition: sourceHandle == null ? void 0 : sourceHandle.position,
            targetX: targetX.value,
            targetY: targetY.value,
            targetPosition
          });
          break;
        case ConnectionLineType.Step:
          path = getSmoothStepPath({
            sourceX,
            sourceY,
            sourcePosition: sourceHandle == null ? void 0 : sourceHandle.position,
            targetX: targetX.value,
            targetY: targetY.value,
            targetPosition,
            borderRadius: 0
          });
          break;
        case ConnectionLineType.SmoothStep:
          path = getSmoothStepPath({
            sourceX,
            sourceY,
            sourcePosition: sourceHandle == null ? void 0 : sourceHandle.position,
            targetX: targetX.value,
            targetY: targetY.value,
            targetPosition
          });
          break;
      }
      return path;
    });
    return (_ctx, _cache) => {
      var _a3;
      return openBlock(), createElementBlock("g", _hoisted_1$d, [
        unref(hasSlot) ? (openBlock(), createBlock(resolveDynamicComponent(unref(slots)), normalizeProps(mergeProps({ key: 0 }, {
          sourceX,
          sourceY,
          sourcePosition: (_a3 = unref(sourceHandle)) == null ? void 0 : _a3.position,
          targetX: targetX.value,
          targetY: targetY.value,
          targetPosition: unref(targetPosition),
          nodes: getNodes.value,
          sourceNode: __props.sourceNode,
          sourceHandle: unref(sourceHandle),
          markerEnd: `url(#${unref(getMarkerId)(connectionLineOptions.value.markerEnd)})`,
          markerStart: `url(#${unref(getMarkerId)(connectionLineOptions.value.markerStart)})`
        })), null, 16)) : (openBlock(), createElementBlock("path", {
          key: 1,
          d: unref(dAttr),
          class: normalizeClass(["vue-flow__connection-path", connectionLineOptions.value.class]),
          style: normalizeStyle(connectionLineStyle.value || connectionLineOptions.value.style || {}),
          "marker-end": `url(#${unref(getMarkerId)(connectionLineOptions.value.markerEnd)})`,
          "marker-start": `url(#${unref(getMarkerId)(connectionLineOptions.value.markerStart)})`
        }, null, 14, _hoisted_2$8))
      ]);
    };
  }
});
const __default__$d = {
  name: "NodesSelection"
};
const _sfc_main$e = /* @__PURE__ */ defineComponent({
  ...__default__$d,
  setup(__props) {
    const __$temp_1 = useVueFlow(), emits = toRef(__$temp_1, "emits");
    toRef(__$temp_1, "setState");
    const viewport = toRef(__$temp_1, "viewport"), getSelectedNodes = toRef(__$temp_1, "getSelectedNodes");
    toRef(__$temp_1, "snapToGrid");
    toRef(__$temp_1, "snapGrid");
    const noPanClassName = toRef(__$temp_1, "noPanClassName");
    const el = ref();
    useDrag({
      el,
      onStart(event, node, nodes) {
        emits.value.selectionDragStart({ event, node, nodes });
      },
      onDrag(event, node, nodes) {
        emits.value.selectionDrag({ event, node, nodes });
      },
      onStop(event, node, nodes) {
        emits.value.selectionDragStop({ event, node, nodes });
      }
    });
    const selectedNodesBBox = computed(() => getRectOfNodes(getSelectedNodes.value));
    const innerStyle = computed(() => ({
      width: `${selectedNodesBBox.value.width}px`,
      height: `${selectedNodesBBox.value.height}px`,
      top: `${selectedNodesBBox.value.y}px`,
      left: `${selectedNodesBBox.value.x}px`
    }));
    const onContextMenu = (event) => emits.value.selectionContextMenu({ event, nodes: getSelectedNodes.value });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        class: normalizeClass(["vue-flow__nodesselection vue-flow__container", noPanClassName.value]),
        style: normalizeStyle({ transform: `translate(${viewport.value.x}px,${viewport.value.y}px) scale(${viewport.value.zoom})` })
      }, [
        createElementVNode("div", {
          ref_key: "el",
          ref: el,
          class: "vue-flow__nodesselection-rect",
          style: normalizeStyle(unref(innerStyle)),
          onContextmenu: onContextMenu
        }, null, 36)
      ], 6);
    };
  }
});
const __default__$c = {
  name: "SelectionRect"
};
const _sfc_main$d = /* @__PURE__ */ defineComponent({
  ...__default__$c,
  props: {
    width: null,
    height: null,
    x: null,
    y: null
  },
  setup(__props) {
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        class: "vue-flow__selection",
        style: normalizeStyle({
          width: `${__props.width}px`,
          height: `${__props.height}px`,
          transform: `translate(${__props.x}px, ${__props.y}px)`
        })
      }, null, 4);
    };
  }
});
function getMousePosition(event) {
  const flowNode = event.target.closest(".vue-flow");
  if (!flowNode)
    return;
  const containerBounds = flowNode.getBoundingClientRect();
  return {
    x: event.clientX - containerBounds.left,
    y: event.clientY - containerBounds.top
  };
}
const _hoisted_1$c = {
  ref: "user-selection",
  class: "vue-flow__selectionpane vue-flow__container"
};
const __default__$b = {
  name: "UserSelection"
};
const _sfc_main$c = /* @__PURE__ */ defineComponent({
  ...__default__$b,
  setup(__props) {
    const __$temp_1 = useVueFlow(), userSelectionActive = toRef(__$temp_1, "userSelectionActive"), setState = toRef(__$temp_1, "setState"), getNodes = toRef(__$temp_1, "getNodes"), getEdges = toRef(__$temp_1, "getEdges"), viewport = toRef(__$temp_1, "viewport"), addSelectedEdges = toRef(__$temp_1, "addSelectedEdges"), addSelectedNodes = toRef(__$temp_1, "addSelectedNodes");
    const el = templateRef("user-selection", null);
    let prevNodes = ref(0);
    let prevEdges = ref(0);
    const initialRect = () => ({
      width: 0,
      height: 0,
      startX: 0,
      startY: 0,
      x: 0,
      y: 0,
      draw: false
    });
    let rect = ref(initialRect());
    const reset = () => {
      rect.value = initialRect();
      prevNodes.value = 0;
      prevEdges.value = 0;
      setState.value({
        userSelectionActive: false
      });
    };
    const onMouseDown = (event) => {
      const mousePos = getMousePosition(event);
      if (!mousePos)
        return;
      rect.value = {
        width: 0,
        height: 0,
        startX: mousePos.x,
        startY: mousePos.y,
        x: mousePos.x,
        y: mousePos.y,
        draw: true
      };
      setState.value({
        userSelectionActive: true,
        nodesSelectionActive: false
      });
    };
    const onMouseMove = (event) => {
      if (!userSelectionActive.value || !rect.value.draw)
        return;
      const mousePos = getMousePosition(event);
      if (!mousePos)
        return;
      const startX = rect.value.startX;
      const startY = rect.value.startY;
      const nextUserSelectRect = {
        ...rect.value,
        x: mousePos.x < startX ? mousePos.x : rect.value.x,
        y: mousePos.y < startY ? mousePos.y : rect.value.y,
        width: Math.abs(mousePos.x - startX),
        height: Math.abs(mousePos.y - startY)
      };
      const selectedNodes = getNodesInside(getNodes.value, rect.value, viewport.value);
      const selectedEdges = getConnectedEdges(selectedNodes, getEdges.value);
      rect.value = nextUserSelectRect;
      addSelectedNodes.value(selectedNodes);
      addSelectedEdges.value(selectedEdges);
      prevNodes.value = selectedNodes.length;
      prevEdges.value = selectedEdges.length;
    };
    const onMouseUp = () => {
      rect.value = initialRect();
      setState.value({
        nodesSelectionActive: prevNodes.value > 0,
        userSelectionActive: false
      });
    };
    const onMouseLeave = () => {
      setState.value({
        nodesSelectionActive: prevNodes.value > 0
      });
      reset();
    };
    onMounted(() => {
      useEventListener(el, "mousedown", onMouseDown);
      useEventListener(el, "mousemove", onMouseMove);
      useEventListener(el, "click", onMouseUp);
      useEventListener(el, "mouseup", onMouseUp);
      useEventListener(el, "mouseleave", onMouseLeave);
    });
    onBeforeUnmount(() => {
      reset();
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", _hoisted_1$c, [
        rect.value.draw ? (openBlock(), createBlock(_sfc_main$d, {
          key: 0,
          width: rect.value.width,
          height: rect.value.height,
          x: rect.value.x,
          y: rect.value.y
        }, null, 8, ["width", "height", "x", "y"])) : createCommentVNode("", true)
      ], 512);
    };
  }
});
const defaultNodeTypes = {
  input: InputNode,
  default: DefaultNode,
  output: OutputNode
};
const defaultEdgeTypes = {
  default: BezierEdge,
  straight: StraightEdge,
  step: StepEdge,
  smoothstep: SmoothStepEdge,
  simplebezier: SimpleBezierEdge
};
const isDef$1 = (val) => typeof val !== "undefined";
const defaultState = () => ({
  vueFlowRef: null,
  viewportRef: null,
  nodes: [],
  edges: [],
  nodeTypes: {},
  edgeTypes: {},
  initialized: false,
  dimensions: {
    width: 0,
    height: 0
  },
  viewport: { x: 0, y: 0, zoom: 1 },
  d3Zoom: null,
  d3Selection: null,
  d3ZoomHandler: null,
  minZoom: 0.5,
  maxZoom: 2,
  translateExtent: [
    [Number.NEGATIVE_INFINITY, Number.NEGATIVE_INFINITY],
    [Number.POSITIVE_INFINITY, Number.POSITIVE_INFINITY]
  ],
  nodeExtent: [
    [Number.NEGATIVE_INFINITY, Number.NEGATIVE_INFINITY],
    [Number.POSITIVE_INFINITY, Number.POSITIVE_INFINITY]
  ],
  preventScrolling: true,
  zoomOnScroll: true,
  zoomOnPinch: true,
  zoomOnDoubleClick: true,
  panOnScroll: false,
  panOnScrollSpeed: 0.5,
  panOnScrollMode: PanOnScrollMode.Free,
  panOnDrag: true,
  edgeUpdaterRadius: 10,
  onlyRenderVisibleElements: false,
  defaultZoom: 1,
  defaultPosition: [0, 0],
  nodesSelectionActive: false,
  userSelectionActive: false,
  defaultMarkerColor: "#b1b1b7",
  connectionLineStyle: {},
  connectionLineType: ConnectionLineType.Bezier,
  connectionLineOptions: {
    type: ConnectionLineType.Bezier,
    style: {}
  },
  connectionNodeId: null,
  connectionHandleId: null,
  connectionHandleType: null,
  connectionPosition: { x: NaN, y: NaN },
  connectionMode: ConnectionMode.Loose,
  connectionStartHandle: null,
  connectOnClick: true,
  snapGrid: [15, 15],
  snapToGrid: false,
  edgesUpdatable: false,
  nodesConnectable: true,
  nodesDraggable: true,
  elementsSelectable: true,
  selectNodesOnDrag: true,
  multiSelectionActive: false,
  selectionKeyCode: "Shift",
  multiSelectionKeyCode: "Meta",
  zoomActivationKeyCode: "Meta",
  deleteKeyCode: "Backspace",
  hooks: createHooks(),
  applyDefault: true,
  autoConnect: false,
  fitViewOnInit: false,
  noDragClassName: "nodrag",
  noWheelClassName: "nowheel",
  noPanClassName: "nopan",
  defaultEdgeOptions: void 0,
  elevateEdgesOnSelect: false,
  vueFlowVersion: "0.4.36"
});
var useState = (opts) => {
  const state = defaultState();
  if (opts) {
    Object.keys(opts).forEach((o) => {
      const option = opts[o];
      if (isDef$1(option))
        state[o] = option;
    });
  }
  return state;
};
var useActions = (state, getters) => {
  const updateNodePositions = (dragItems, changed, dragging) => {
    const changes = [];
    dragItems.forEach((node) => {
      var _a2, _b, _c, _d;
      const change = {
        id: node.id,
        type: "position",
        dragging
      };
      if (changed) {
        change.computedPosition = node.position;
        change.position = node.position;
        if (node.parentNode) {
          const parentNode = getters.getNode.value(node.parentNode);
          change.position = {
            x: change.position.x - ((_b = (_a2 = parentNode == null ? void 0 : parentNode.computedPosition) == null ? void 0 : _a2.x) != null ? _b : 0),
            y: change.position.y - ((_d = (_c = parentNode == null ? void 0 : parentNode.computedPosition) == null ? void 0 : _c.y) != null ? _d : 0)
          };
        }
      }
      changes.push(change);
    });
    if (changes == null ? void 0 : changes.length) {
      state.hooks.nodesChange.trigger(changes);
    }
  };
  const updateNodeDimensions = (updates) => {
    const changes = updates.reduce((res, update) => {
      const node = getters.getNode.value(update.id);
      if (node) {
        const dimensions = getDimensions(update.nodeElement);
        const doUpdate = !!(dimensions.width && dimensions.height && (node.dimensions.width !== dimensions.width || node.dimensions.height !== dimensions.height) || update.forceUpdate);
        node.handleBounds = {
          source: getHandleBounds(".source", update.nodeElement, state.viewport.zoom),
          target: getHandleBounds(".target", update.nodeElement, state.viewport.zoom)
        };
        if (doUpdate) {
          node.dimensions = dimensions;
          res.push({
            id: node.id,
            type: "dimensions",
            dimensions
          });
        }
      }
      return res;
    }, []);
    if (changes.length)
      state.hooks.nodesChange.trigger(changes);
  };
  const nodeSelectionHandler = (nodes, selected) => {
    const nodeIds2 = nodes.map((n) => n.id);
    let changedNodes;
    if (state.multiSelectionActive)
      changedNodes = nodeIds2.map((nodeId) => createSelectionChange(nodeId, selected));
    else
      changedNodes = getSelectionChanges(state.nodes, nodeIds2);
    if (changedNodes.length)
      state.hooks.nodesChange.trigger(changedNodes);
  };
  const edgeSelectionHandler = (edges, selected) => {
    const edgeIds2 = edges.map((e) => e.id);
    let changedEdges;
    if (state.multiSelectionActive)
      changedEdges = edgeIds2.map((edgeId) => createSelectionChange(edgeId, selected));
    else
      changedEdges = getSelectionChanges(state.edges, edgeIds2);
    if (changedEdges.length)
      state.hooks.edgesChange.trigger(changedEdges);
  };
  const addSelectedNodes = (nodes) => {
    nodeSelectionHandler(nodes, true);
  };
  const addSelectedEdges = (edges) => {
    edgeSelectionHandler(edges, true);
  };
  const addSelectedElements = (elements) => {
    addSelectedNodes(elements.filter(isGraphNode));
    addSelectedEdges(elements.filter(isGraphEdge));
  };
  const removeSelectedNodes = (nodes) => {
    nodeSelectionHandler(nodes, false);
  };
  const removeSelectedEdges = (edges) => {
    edgeSelectionHandler(edges, false);
  };
  const removeSelectedElements = (elements) => {
    if (!elements) {
      removeSelectedNodes([]);
      removeSelectedEdges([]);
    } else {
      if (elements.nodes)
        removeSelectedNodes(elements.nodes.filter(isGraphNode));
      if (elements.edges)
        removeSelectedEdges(elements.edges.filter(isGraphEdge));
    }
  };
  const setMinZoom = (minZoom) => {
    var _a2;
    (_a2 = state.d3Zoom) == null ? void 0 : _a2.scaleExtent([minZoom, state.maxZoom]);
    state.minZoom = minZoom;
  };
  const setMaxZoom = (maxZoom) => {
    var _a2;
    (_a2 = state.d3Zoom) == null ? void 0 : _a2.scaleExtent([state.minZoom, maxZoom]);
    state.maxZoom = maxZoom;
  };
  const setTranslateExtent = (translateExtent) => {
    var _a2;
    (_a2 = state.d3Zoom) == null ? void 0 : _a2.translateExtent(translateExtent);
    state.translateExtent = translateExtent;
  };
  const setInteractive = (isInteractive) => {
    state.nodesDraggable = isInteractive;
    state.nodesConnectable = isInteractive;
    state.elementsSelectable = isInteractive;
  };
  const setNodes = (nodes, extent) => {
    if (!state.initialized && !nodes.length)
      return;
    if (!state.nodes)
      state.nodes = [];
    const curr = nodes instanceof Function ? nodes(state.nodes) : nodes;
    state.nodes = createGraphNodes(curr, getters.getNode.value, state.nodes, extent != null ? extent : state.nodeExtent);
  };
  const setEdges = (edges) => {
    if (!state.initialized && !edges.length)
      return;
    const curr = edges instanceof Function ? edges(state.edges) : edges;
    state.edges = curr.reduce((res, edge) => {
      const sourceNode = getters.getNode.value(edge.source);
      const targetNode = getters.getNode.value(edge.target);
      const missingSource = !sourceNode || typeof sourceNode === "undefined";
      const missingTarget = !targetNode || typeof targetNode === "undefined";
      if (missingSource)
        console.warn(`[vue-flow]: Couldn't create edge for source id: ${edge.source}; edge id: ${edge.id}`);
      if (missingTarget)
        console.warn(`[vue-flow]: Couldn't create edge for target id: ${edge.target}; edge id: ${edge.id}`);
      if (missingSource || missingTarget)
        return res;
      const storedEdge = getters.getEdge.value(edge.id);
      res.push(
        shallowReactive({
          ...parseEdge(edge, Object.assign({}, storedEdge, state.defaultEdgeOptions)),
          sourceNode,
          targetNode
        })
      );
      return res;
    }, []);
  };
  const setElements = (elements, extent) => {
    if (!state.initialized && !elements.length || !elements)
      return;
    const curr = elements instanceof Function ? elements([...state.nodes, ...state.edges]) : elements;
    setNodes(curr.filter(isNode), extent);
    setEdges(curr.filter(isEdge));
  };
  const addNodes = (nodes, extent) => {
    const curr = nodes instanceof Function ? nodes(state.nodes) : nodes;
    const graphNodes = createGraphNodes(curr, getters.getNode.value, state.nodes, extent != null ? extent : state.nodeExtent);
    const changes = graphNodes.map(createAdditionChange);
    if (changes.length)
      state.hooks.nodesChange.trigger(changes);
  };
  const addEdges = (params) => {
    const curr = params instanceof Function ? params(state.edges) : params;
    const changes = curr.reduce((acc, param) => {
      const edge = addEdgeToStore(
        {
          ...param,
          ...state.defaultEdgeOptions
        },
        state.edges
      );
      if (edge) {
        const sourceNode = getters.getNode.value(edge.source);
        const targetNode = getters.getNode.value(edge.target);
        const missingSource = !sourceNode || typeof sourceNode === "undefined";
        const missingTarget = !targetNode || typeof targetNode === "undefined";
        if (missingSource)
          console.warn(`[vueflow]: Couldn't create edge for source id: ${edge.source}; edge id: ${edge.id}`);
        if (missingTarget)
          console.warn(`[vueflow]: Couldn't create edge for target id: ${edge.target}; edge id: ${edge.id}`);
        if (missingTarget || missingSource)
          return acc;
        acc.push(
          createAdditionChange(
            shallowReactive({
              ...edge,
              sourceNode,
              targetNode
            })
          )
        );
      }
      return acc;
    }, []);
    if (changes.length)
      state.hooks.edgesChange.trigger(changes);
  };
  const removeNodes = (nodes, removeConnectedEdges = true) => {
    const curr = nodes instanceof Function ? nodes(state.nodes) : nodes;
    const nodeChanges = [];
    const edgeChanges = [];
    curr.forEach((item) => {
      nodeChanges.push(createRemoveChange(typeof item === "string" ? item : item.id));
      if (removeConnectedEdges) {
        const connections = getConnectedEdges([typeof item === "string" ? { id: item } : item], state.edges);
        edgeChanges.push(...connections.map((connection) => createRemoveChange(connection.id)));
      }
    });
    if (nodeChanges.length) {
      state.hooks.nodesChange.trigger(nodeChanges);
    }
    if (edgeChanges.length) {
      state.hooks.edgesChange.trigger(edgeChanges);
    }
  };
  const removeEdges = (edges) => {
    const curr = edges instanceof Function ? edges(state.edges) : edges;
    const changes = [];
    curr.forEach((item) => {
      changes.push(createRemoveChange(typeof item === "string" ? item : item.id));
    });
    state.hooks.edgesChange.trigger(changes);
  };
  const nodeIds = computed(() => state.nodes.map((n) => n.id));
  const edgeIds = computed(() => state.edges.map((e) => e.id));
  const findNode = (id2) => {
    if (state.nodes && !nodeIds.value.length)
      return state.nodes.find((node) => node.id === id2);
    return state.nodes[nodeIds.value.indexOf(id2)];
  };
  const findEdge = (id2) => {
    if (state.edges && !edgeIds.value.length)
      return state.edges.find((edge) => edge.id === id2);
    return state.edges[edgeIds.value.indexOf(id2)];
  };
  const updateEdge2 = (oldEdge, newConnection) => updateEdgeAction(oldEdge, newConnection, state.edges, addEdges);
  const applyNodeChanges2 = (changes) => applyChanges(changes, state.nodes);
  const applyEdgeChanges2 = (changes) => applyChanges(changes, state.edges);
  const setState = (options) => {
    var _a2, _b;
    const skip = ["modelValue", "nodes", "edges", "maxZoom", "minZoom", "translateExtent", "hooks"];
    const opts = options instanceof Function ? options(state) : options;
    if (typeof opts.modelValue !== "undefined")
      setElements(opts.modelValue, (_a2 = opts.nodeExtent) != null ? _a2 : state.nodeExtent);
    if (typeof opts.nodes !== "undefined")
      setNodes(opts.nodes, (_b = opts.nodeExtent) != null ? _b : state.nodeExtent);
    if (typeof opts.edges !== "undefined")
      setEdges(opts.edges);
    Object.keys(opts).forEach((o) => {
      const option = opts[o];
      if (!skip.includes(o) && isDef$2(option))
        state[o] = option;
    });
    if (!state.d3Zoom)
      until(() => state.d3Zoom).not.toBeUndefined().then(() => {
        if (typeof opts.maxZoom !== "undefined")
          setMaxZoom(opts.maxZoom);
        if (typeof opts.minZoom !== "undefined")
          setMinZoom(opts.minZoom);
        if (typeof opts.translateExtent !== "undefined")
          setTranslateExtent(opts.translateExtent);
      });
    else {
      if (typeof opts.maxZoom !== "undefined")
        setMaxZoom(opts.maxZoom);
      if (typeof opts.minZoom !== "undefined")
        setMinZoom(opts.minZoom);
      if (typeof opts.translateExtent !== "undefined")
        setTranslateExtent(opts.translateExtent);
    }
    if (!state.initialized)
      state.initialized = true;
  };
  const toObject = () => {
    return JSON.parse(
      JSON.stringify({
        nodes: state.nodes,
        edges: state.edges,
        position: [state.viewport.x, state.viewport.y],
        zoom: state.viewport.zoom
      })
    );
  };
  const updateNodeInternals = (ids) => {
    state.hooks.updateNodeInternals.trigger(ids);
  };
  let zoomPanHelper;
  state.hooks.paneReady.on(({ id: id2 }) => {
    zoomPanHelper = useZoomPanHelper(id2);
  });
  const paneReady = async () => {
    return new Promise((resolve) => {
      if (!zoomPanHelper) {
        until(() => zoomPanHelper).toBeTruthy().then(() => resolve(zoomPanHelper));
      } else {
        resolve(zoomPanHelper);
      }
    });
  };
  return {
    updateNodePositions,
    updateNodeDimensions,
    setElements,
    setNodes,
    setEdges,
    addNodes,
    addEdges,
    removeNodes,
    removeEdges,
    findNode,
    findEdge,
    updateEdge: updateEdge2,
    applyEdgeChanges: applyEdgeChanges2,
    applyNodeChanges: applyNodeChanges2,
    addSelectedElements,
    addSelectedNodes,
    addSelectedEdges,
    setMinZoom,
    setMaxZoom,
    setTranslateExtent,
    removeSelectedElements,
    removeSelectedNodes,
    removeSelectedEdges,
    setInteractive,
    setState,
    fitView: async (params = { padding: 0.1 }) => {
      const { fitView } = await paneReady();
      fitView(params);
    },
    zoomIn: async (options) => {
      const { zoomIn } = await paneReady();
      zoomIn(options);
    },
    zoomOut: async (options) => {
      const { zoomOut } = await paneReady();
      zoomOut(options);
    },
    zoomTo: async (zoomLevel, options) => {
      const { zoomTo } = await paneReady();
      zoomTo(zoomLevel, options);
    },
    setTransform: async (transform, options) => {
      const { setTransform } = await paneReady();
      setTransform(transform, options);
    },
    getTransform: () => ({
      x: state.viewport.x,
      y: state.viewport.y,
      zoom: state.viewport.zoom
    }),
    setCenter: async (x, y, options) => {
      const { setCenter } = await paneReady();
      setCenter(x, y, options);
    },
    fitBounds: async (bounds, options) => {
      const { fitBounds } = await paneReady();
      fitBounds(bounds, options);
    },
    project: (position) => pointToRendererPoint(position, state.viewport, state.snapToGrid, state.snapGrid),
    toObject,
    updateNodeInternals,
    $reset: () => {
      setState(useState());
    },
    $destroy: () => {
    }
  };
};
var useGetters = (state) => {
  const nodeIds = computed(() => state.nodes.map((n) => n.id));
  const edgeIds = computed(() => state.edges.map((e) => e.id));
  const getNode = computed(() => (id2) => {
    if (state.nodes && !nodeIds.value.length)
      return state.nodes.find((node) => node.id === id2);
    return state.nodes[nodeIds.value.indexOf(id2)];
  });
  const getEdge = computed(() => (id2) => {
    if (state.edges && !edgeIds.value.length)
      return state.edges.find((edge) => edge.id === id2);
    return state.edges[edgeIds.value.indexOf(id2)];
  });
  const getEdgeTypes = computed(() => {
    var _a2;
    const edgeTypes = {
      ...defaultEdgeTypes,
      ...state.edgeTypes
    };
    const keys = Object.keys(edgeTypes);
    (_a2 = state.edges) == null ? void 0 : _a2.forEach((e) => e.type && !keys.includes(e.type) && (edgeTypes[e.type] = e.type));
    return edgeTypes;
  });
  const getNodeTypes = computed(() => {
    var _a2;
    const nodeTypes = {
      ...defaultNodeTypes,
      ...state.nodeTypes
    };
    const keys = Object.keys(nodeTypes);
    (_a2 = state.nodes) == null ? void 0 : _a2.forEach((n) => n.type && !keys.includes(n.type) && (nodeTypes[n.type] = n.type));
    return nodeTypes;
  });
  const getNodes = computed(() => {
    const nodes = state.nodes.filter((n) => !n.hidden);
    return state.onlyRenderVisibleElements ? nodes && getNodesInside(
      nodes,
      {
        x: 0,
        y: 0,
        width: state.dimensions.width,
        height: state.dimensions.height
      },
      state.viewport,
      true
    ) : nodes != null ? nodes : [];
  });
  const edgeHidden = (e, source, target) => {
    source = source != null ? source : getNode.value(e.source);
    target = target != null ? target : getNode.value(e.target);
    if (!source || !target) {
      console.warn(`[vue-flow]: Orphaned edge ${e.id} will be removed.`);
      state.edges.splice(state.edges.indexOf(e), 1);
      return true;
    }
    return !e.hidden && target && !target.hidden && source && !source.hidden && source.dimensions.width && source.dimensions.height && target.dimensions.width && target.dimensions.height;
  };
  const getEdges = computed(() => {
    if (!state.onlyRenderVisibleElements)
      return state.edges.filter((edge) => edgeHidden(edge));
    return state.edges.filter((e) => {
      const source = getNode.value(e.source);
      const target = getNode.value(e.target);
      return edgeHidden(e, source, target) && isEdgeVisible({
        sourcePos: source.computedPosition || { x: 0, y: 0 },
        targetPos: target.computedPosition || { x: 0, y: 0 },
        sourceWidth: source.dimensions.width,
        sourceHeight: source.dimensions.height,
        targetWidth: target.dimensions.width,
        targetHeight: target.dimensions.height,
        width: state.dimensions.width,
        height: state.dimensions.height,
        viewport: state.viewport
      });
    });
  });
  const getElements = computed(() => [...getNodes.value, ...getEdges.value]);
  const getSelectedNodes = computed(() => state.nodes.filter((n) => n.selected));
  const getSelectedEdges = computed(() => state.edges.filter((e) => e.selected));
  const getSelectedElements = computed(() => {
    var _a2, _b;
    return [
      ...(_a2 = getSelectedNodes.value) != null ? _a2 : [],
      ...(_b = getSelectedEdges.value) != null ? _b : []
    ];
  });
  return {
    getNode,
    getEdge,
    getElements,
    getEdgeTypes,
    getNodeTypes,
    getEdges,
    getNodes,
    getSelectedElements,
    getSelectedNodes,
    getSelectedEdges
  };
};
class Storage {
  constructor() {
    this.currentId = 0;
    this.flows = /* @__PURE__ */ new Map();
  }
  static getInstance() {
    if (!Storage.instance) {
      Storage.instance = new Storage();
    }
    return Storage.instance;
  }
  set(id2, flow) {
    return this.flows.set(id2, flow);
  }
  get(id2) {
    return this.flows.get(id2);
  }
  remove(id2) {
    return this.flows.delete(id2);
  }
  create(id2, preloadedState) {
    const state = useState(preloadedState);
    const reactiveState = reactive(state);
    const getters = useGetters(reactiveState);
    const actions = useActions(reactiveState, getters);
    const hooksOn = {};
    Object.entries(reactiveState.hooks).forEach(([n, h2]) => {
      const name = `on${n.charAt(0).toUpperCase() + n.slice(1)}`;
      hooksOn[name] = h2.on;
    });
    const emits = {};
    Object.entries(reactiveState.hooks).forEach(([n, h2]) => {
      emits[n] = h2.trigger;
    });
    actions.setState(reactiveState);
    if (preloadedState) {
      if (preloadedState.modelValue)
        actions.setElements(preloadedState.modelValue);
      if (preloadedState.nodes)
        actions.setNodes(preloadedState.nodes);
      if (preloadedState.edges)
        actions.setEdges(preloadedState.edges);
    }
    const flow = {
      ...hooksOn,
      ...getters,
      ...actions,
      ...toRefs(reactiveState),
      emits,
      id: id2,
      $destroy: () => {
        this.remove(id2);
      }
    };
    this.set(id2, flow);
    return flow;
  }
  getId() {
    return `vue-flow-${this.currentId++}`;
  }
}
var useVueFlow = (options) => {
  const storage = Storage.getInstance();
  const scope = getCurrentScope();
  const id2 = options == null ? void 0 : options.id;
  const vueFlowId = (scope == null ? void 0 : scope.vueFlowId) || id2;
  let vueFlow;
  let isParentScope = false;
  if (scope) {
    const injection = inject(VueFlow, null);
    if (typeof injection !== "undefined" && injection !== null)
      vueFlow = injection;
  }
  if (!vueFlow) {
    if (vueFlowId)
      vueFlow = storage.get(vueFlowId);
  }
  if (!vueFlow || vueFlow && id2 && id2 !== vueFlow.id) {
    const name = id2 != null ? id2 : storage.getId();
    vueFlow = storage.create(name, options);
    if (scope) {
      scope.vueFlowId = name;
      isParentScope = true;
    }
  } else {
    if (options)
      vueFlow.setState(options);
  }
  if (!vueFlow)
    throw new Error("[vueflow]: store instance not found.");
  if (scope) {
    provide(VueFlow, vueFlow);
    if (isParentScope) {
      tryOnScopeDispose(() => {
        if (storage.get(vueFlow.id)) {
          vueFlow.$destroy();
        }
        vueFlow = null;
      });
    }
  }
  return vueFlow;
};
const checkElementBelowIsValid = (event, connectionMode, isTarget, nodeId, handleId, isValidConnection, doc, edges, getNode) => {
  var _a2, _b;
  const elementBelow = doc.elementFromPoint(event.clientX, event.clientY);
  const elementBelowIsTarget = (elementBelow == null ? void 0 : elementBelow.classList.contains("target")) || false;
  const elementBelowIsSource = (elementBelow == null ? void 0 : elementBelow.classList.contains("source")) || false;
  const result = {
    elementBelow,
    isValid: false,
    connection: { source: "", target: "", sourceHandle: null, targetHandle: null },
    isHoveringHandle: false
  };
  if (elementBelow && (elementBelowIsTarget || elementBelowIsSource)) {
    result.isHoveringHandle = true;
    const isValid = connectionMode === ConnectionMode.Strict ? isTarget && elementBelowIsSource || !isTarget && elementBelowIsTarget : true;
    if (isValid) {
      const elementBelowNodeId = (_a2 = elementBelow.getAttribute("data-nodeid")) != null ? _a2 : "";
      const elementBelowHandleId = (_b = elementBelow.getAttribute("data-handleid")) != null ? _b : "";
      const sourceId = isTarget ? elementBelowNodeId : nodeId;
      const sourceHandleId = isTarget ? elementBelowHandleId : handleId;
      const targetId = isTarget ? nodeId : elementBelowNodeId;
      const targetHandleId = isTarget ? handleId : elementBelowHandleId;
      const connection = {
        source: sourceId,
        sourceHandle: sourceHandleId,
        target: targetId,
        targetHandle: targetHandleId
      };
      result.connection = connection;
      result.isValid = isValidConnection(connection, { edges, sourceNode: getNode(sourceId), targetNode: getNode(targetId) }) || !result.connection.target || !result.connection.source;
    }
  }
  return result;
};
const resetRecentHandle = (hoveredHandle) => {
  hoveredHandle == null ? void 0 : hoveredHandle.classList.remove("vue-flow__handle-valid");
  hoveredHandle == null ? void 0 : hoveredHandle.classList.remove("vue-flow__handle-connecting");
};
var useHandle = () => {
  const __$temp_1 = useVueFlow(), edges = toRef(__$temp_1, "edges"), connectOnClick = toRef(__$temp_1, "connectOnClick"), nodesConnectable = toRef(__$temp_1, "nodesConnectable"), connectionStartHandle = toRef(__$temp_1, "connectionStartHandle"), connectionPosition = toRef(__$temp_1, "connectionPosition"), connectionMode = toRef(__$temp_1, "connectionMode"), emits = toRef(__$temp_1, "emits"), setState = toRef(__$temp_1, "setState"), getNode = toRef(__$temp_1, "getNode");
  let recentHoveredHandle;
  const onMouseDown = (event, handleId, nodeId, isTarget, isValidConnection, elementEdgeUpdaterType, onEdgeUpdate, onEdgeUpdateEnd) => {
    var _a2;
    const flowNode = event.target.closest(".vue-flow");
    const doc = getHostForElement(event.target);
    if (!doc)
      return;
    let validConnectFunc = isValidConnection != null ? isValidConnection : () => true;
    const node = getNode.value(nodeId);
    if (node && (typeof node.connectable === "undefined" ? nodesConnectable.value : node.connectable) === false)
      return;
    if (!isValidConnection) {
      if (node)
        validConnectFunc = (_a2 = !isTarget ? node.isValidTargetPos : node.isValidSourcePos) != null ? _a2 : () => true;
    }
    const elementBelow = doc.elementFromPoint(event.clientX, event.clientY);
    const elementBelowIsTarget = elementBelow == null ? void 0 : elementBelow.classList.contains("target");
    const elementBelowIsSource = elementBelow == null ? void 0 : elementBelow.classList.contains("source");
    if (!flowNode || !elementBelowIsTarget && !elementBelowIsSource && !elementEdgeUpdaterType)
      return;
    const handleType = elementEdgeUpdaterType != null ? elementEdgeUpdaterType : elementBelowIsTarget ? "target" : "source";
    const containerBounds = flowNode.getBoundingClientRect();
    setState.value({
      connectionPosition: {
        x: event.clientX - containerBounds.left,
        y: event.clientY - containerBounds.top
      },
      connectionNodeId: nodeId,
      connectionHandleId: handleId,
      connectionHandleType: handleType
    });
    emits.value.connectStart({ event, nodeId, handleId, handleType });
    function onMouseMove(event2) {
      connectionPosition.value.x = event2.clientX - containerBounds.left;
      connectionPosition.value.y = event2.clientY - containerBounds.top;
      const { connection, elementBelow: elementBelow2, isValid, isHoveringHandle } = checkElementBelowIsValid(
        event2,
        connectionMode.value,
        isTarget,
        nodeId,
        handleId,
        validConnectFunc,
        doc,
        edges.value,
        getNode.value
      );
      if (!isHoveringHandle)
        return resetRecentHandle(recentHoveredHandle);
      const isOwnHandle = connection.source === connection.target;
      if (!isOwnHandle && elementBelow2) {
        recentHoveredHandle = elementBelow2;
        elementBelow2.classList.add("vue-flow__handle-connecting");
        elementBelow2.classList.toggle("vue-flow__handle-valid", isValid);
      }
    }
    function onMouseUp(event2) {
      const { connection, isValid } = checkElementBelowIsValid(
        event2,
        connectionMode.value,
        isTarget,
        nodeId,
        handleId,
        validConnectFunc,
        doc,
        edges.value,
        getNode.value
      );
      emits.value.connectStop(event2);
      const isOwnHandle = connection.source === connection.target;
      if (isValid && !isOwnHandle) {
        if (!onEdgeUpdate)
          emits.value.connect(connection);
        else
          onEdgeUpdate(connection);
      }
      emits.value.connectEnd(event2);
      if (elementEdgeUpdaterType)
        onEdgeUpdateEnd == null ? void 0 : onEdgeUpdateEnd();
      resetRecentHandle(recentHoveredHandle);
      setState.value({
        connectionNodeId: null,
        connectionHandleId: null,
        connectionHandleType: null,
        connectionPosition: { x: NaN, y: NaN }
      });
      doc.removeEventListener("mousemove", onMouseMove);
      doc.removeEventListener("mouseup", onMouseUp);
    }
    doc.addEventListener("mousemove", onMouseMove);
    doc.addEventListener("mouseup", onMouseUp);
  };
  const onClick = (event, handleId, nodeId, handleType, isValidConnection) => {
    var _a2;
    if (!connectOnClick.value)
      return;
    if (!connectionStartHandle.value) {
      emits.value.connectStart({ event, nodeId, handleId, handleType });
      setState.value({ connectionStartHandle: { nodeId, type: handleType, handleId } });
    } else {
      let validConnectFunc = isValidConnection != null ? isValidConnection : () => true;
      const node = getNode.value(nodeId);
      if (node && (typeof node.connectable === "undefined" ? nodesConnectable.value : node.connectable) === false)
        return;
      if (!isValidConnection) {
        if (node)
          validConnectFunc = (_a2 = handleType !== "target" ? node.isValidTargetPos : node.isValidSourcePos) != null ? _a2 : () => true;
      }
      const doc = getHostForElement(event.target);
      const { connection, isValid } = checkElementBelowIsValid(
        event,
        connectionMode.value,
        connectionStartHandle.value.type === "target",
        connectionStartHandle.value.nodeId,
        connectionStartHandle.value.handleId || null,
        validConnectFunc,
        doc,
        edges.value,
        getNode.value
      );
      const isOwnHandle = connection.source === connection.target;
      emits.value.connectStop(event);
      if (isValid && !isOwnHandle)
        emits.value.connect(connection);
      emits.value.connectEnd(event);
      setState.value({ connectionStartHandle: null });
    }
  };
  return {
    onMouseDown,
    onClick
  };
};
var useWindow = () => {
  if (typeof window !== "undefined")
    return window;
  else
    return { chrome: false };
};
function isInputDOMNode(event) {
  const target = event.target;
  return ["INPUT", "SELECT", "TEXTAREA"].includes(target == null ? void 0 : target.nodeName) || (target == null ? void 0 : target.hasAttribute("contenteditable")) || !!(target == null ? void 0 : target.closest(".nokey"));
}
var useKeyPress = (keyFilter, onChange) => {
  const window2 = useWindow();
  let isPressed = ref(false);
  watch(isPressed, () => {
    if (onChange && typeof onChange === "function")
      onChange(isPressed.value);
  });
  onKeyStroke(
    keyFilter,
    (e) => {
      if (isInputDOMNode(e))
        return;
      e.preventDefault();
      isPressed.value = true;
    },
    { eventName: "keydown" }
  );
  onKeyStroke(
    keyFilter,
    (e) => {
      if (isInputDOMNode(e))
        return;
      e.preventDefault();
      isPressed.value = false;
    },
    { eventName: "keyup" }
  );
  if (typeof window2.addEventListener !== "undefined") {
    useEventListener(window2, "blur", () => {
      isPressed.value = false;
    });
  }
  if (onChange && typeof onChange === "function")
    onChange(isPressed.value);
  return isPressed;
};
const DEFAULT_PADDING = 0.1;
const transition = (selection2, ms = 0) => selection2.transition().duration(ms);
const untilDimensions = async (dimensions, getNodes) => {
  const window2 = useWindow();
  if ("screen" in window2) {
    await until(dimensions).toMatch(({ height, width }) => !isNaN(width) && width > 0 && !isNaN(height) && height > 0);
    if (getNodes.length > 0) {
      await until(getNodes).toMatch(
        (nodes) => !!nodes.filter(({ dimensions: { width, height } }) => !isNaN(width) && width > 0 && !isNaN(height) && height > 0).length
      );
    }
  }
  return true;
};
var useZoomPanHelper = (vueFlowId) => {
  const __$temp_1 = useVueFlow({ id: vueFlowId }), onPaneReady = toRef(__$temp_1, "onPaneReady"), nodes = toRef(__$temp_1, "nodes"), d3Zoom = toRef(__$temp_1, "d3Zoom"), d3Selection = toRef(__$temp_1, "d3Selection"), dimensions = toRef(__$temp_1, "dimensions"), translateExtent = toRef(__$temp_1, "translateExtent"), minZoom = toRef(__$temp_1, "minZoom"), maxZoom = toRef(__$temp_1, "maxZoom"), viewport = toRef(__$temp_1, "viewport"), snapToGrid = toRef(__$temp_1, "snapToGrid"), snapGrid = toRef(__$temp_1, "snapGrid"), getNodes = toRef(__$temp_1, "getNodes");
  let hasDimensions = ref(false);
  onPaneReady.value(() => hasDimensions.value = true);
  const zoomTo = async (zoomLevel, options) => {
    if (!hasDimensions.value)
      await untilDimensions(dimensions.value, getNodes.value);
    if (d3Selection.value && d3Zoom.value) {
      d3Zoom.value.scaleTo(transition(d3Selection.value, options == null ? void 0 : options.duration), zoomLevel);
    }
  };
  const zoom2 = async (scale, duration) => {
    if (!hasDimensions.value)
      await untilDimensions(dimensions.value, getNodes.value);
    if (d3Selection.value && d3Zoom.value) {
      d3Zoom.value.scaleBy(transition(d3Selection.value, duration), scale);
    }
  };
  const zoomIn = async (options) => {
    await zoom2(1.2, options == null ? void 0 : options.duration);
  };
  const zoomOut = async (options) => {
    await zoom2(1 / 1.2, options == null ? void 0 : options.duration);
  };
  const transformViewport = (x, y, zoom22, duration) => {
    const { x: clampedX, y: clampedY } = clampPosition({ x: -x, y: -y }, translateExtent.value);
    const nextTransform = identity.translate(-clampedX, -clampedY).scale(zoom22);
    if (d3Selection.value && d3Zoom.value) {
      d3Zoom.value.transform(transition(d3Selection.value, duration), nextTransform);
    }
  };
  return {
    zoomIn,
    zoomOut,
    zoomTo,
    setTransform: async (transform, options) => {
      if (!hasDimensions.value)
        await untilDimensions(dimensions.value, getNodes.value);
      transformViewport(transform.x, transform.y, transform.zoom, options == null ? void 0 : options.duration);
    },
    getTransform: () => ({
      x: viewport.value.x,
      y: viewport.value.y,
      zoom: viewport.value.zoom
    }),
    fitView: async (options = {
      padding: DEFAULT_PADDING,
      includeHiddenNodes: false,
      duration: 0
    }) => {
      var _a2, _b, _c;
      if (!hasDimensions.value)
        await untilDimensions(dimensions.value, getNodes.value);
      if (!getNodes.value.length)
        return;
      let nodeBounds = [];
      if (options.nodes) {
        nodeBounds = nodes.value.filter((n) => {
          var _a3;
          return (_a3 = options.nodes) == null ? void 0 : _a3.includes(n.id);
        });
      }
      if (!nodeBounds || !nodeBounds.length) {
        nodeBounds = options.includeHiddenNodes ? nodeBounds : getNodes.value;
      }
      const bounds = getRectOfNodes(nodeBounds);
      const { x, y, zoom: zoom22 } = getTransformForBounds(
        bounds,
        dimensions.value.width,
        dimensions.value.height,
        (_a2 = options.minZoom) != null ? _a2 : minZoom.value,
        (_b = options.maxZoom) != null ? _b : maxZoom.value,
        (_c = options.padding) != null ? _c : DEFAULT_PADDING,
        options.offset
      );
      transformViewport(x, y, zoom22, options == null ? void 0 : options.duration);
    },
    setCenter: async (x, y, options) => {
      if (!hasDimensions.value)
        await untilDimensions(dimensions.value, getNodes.value);
      const nextZoom = typeof (options == null ? void 0 : options.zoom) !== "undefined" ? options.zoom : maxZoom.value;
      const centerX = dimensions.value.width / 2 - x * nextZoom;
      const centerY = dimensions.value.height / 2 - y * nextZoom;
      transformViewport(centerX, centerY, nextZoom, options == null ? void 0 : options.duration);
    },
    fitBounds: async (bounds, options = { padding: DEFAULT_PADDING }) => {
      if (!hasDimensions.value)
        await untilDimensions(dimensions.value, getNodes.value);
      const { x, y, zoom: zoom22 } = getTransformForBounds(bounds, dimensions.value.width, dimensions.value.height, minZoom.value, maxZoom.value, options.padding);
      transformViewport(x, y, zoom22, options == null ? void 0 : options.duration);
    },
    project: (position) => pointToRendererPoint(position, viewport.value, snapToGrid.value, snapGrid.value)
  };
};
function hasSelector(target, selector2, node) {
  let current = target;
  do {
    if (current && current.matches(selector2))
      return true;
    else if (current === node.value)
      return false;
    current = current.parentElement;
  } while (current);
  return false;
}
function getDragItems(nodes, mousePos, getNode, nodeId) {
  return nodes.filter((n) => (n.selected || n.id === nodeId) && (!n.parentNode || !isParentSelected(n, getNode))).map((n) => {
    var _a2, _b;
    return {
      id: n.id,
      position: n.computedPosition || { x: 0, y: 0, z: 0 },
      distance: {
        x: mousePos.x - ((_a2 = n.computedPosition) == null ? void 0 : _a2.x) || 0,
        y: mousePos.y - ((_b = n.computedPosition) == null ? void 0 : _b.y) || 0
      },
      extent: n.extent,
      parentNode: n.parentNode,
      dimensions: n.dimensions
    };
  });
}
function getEventHandlerParams({
  id: id2,
  dragItems,
  getNode
}) {
  const extendedDragItems = dragItems.map((n) => {
    const node = getNode.value(n.id);
    return {
      ...node
    };
  });
  return [id2 ? extendedDragItems.find((n) => n.id === id2) : extendedDragItems[0], extendedDragItems];
}
function updatePosition(dragItem, mousePos, parent, nodeExtent) {
  var _a2, _b, _c, _d;
  let currentExtent = dragItem.extent || nodeExtent;
  const nextPosition = { x: mousePos.x - dragItem.distance.x, y: mousePos.y - dragItem.distance.y };
  if (dragItem.extent === "parent" && parent) {
    if (dragItem.parentNode && dragItem.dimensions.width && dragItem.dimensions.height) {
      currentExtent = parent.computedPosition && parent.dimensions.width && parent.dimensions.height ? [
        [parent.computedPosition.x, parent.computedPosition.y],
        [
          parent.computedPosition.x + parent.dimensions.width - dragItem.dimensions.width,
          parent.computedPosition.y + parent.dimensions.height - dragItem.dimensions.height
        ]
      ] : currentExtent;
    }
  } else if (dragItem.extent && dragItem.parentNode) {
    const dragItemExtent = dragItem.extent;
    const parentX = (_b = (_a2 = parent == null ? void 0 : parent.computedPosition) == null ? void 0 : _a2.x) != null ? _b : 0;
    const parentY = (_d = (_c = parent == null ? void 0 : parent.computedPosition) == null ? void 0 : _c.y) != null ? _d : 0;
    currentExtent = [
      [dragItemExtent[0][0] + parentX, dragItemExtent[0][1] + parentY],
      [dragItemExtent[1][0] + parentX, dragItemExtent[1][1] + parentY]
    ];
  }
  dragItem.position = currentExtent ? clampPosition(nextPosition, currentExtent) : nextPosition;
  return dragItem;
}
function useDrag(params) {
  const scope = effectScope();
  const dragging = scope.run(() => {
    const __$temp_1 = useVueFlow(), viewport = toRef(__$temp_1, "viewport"), snapToGrid = toRef(__$temp_1, "snapToGrid"), globalSnapGrid = toRef(__$temp_1, "snapGrid"), noDragClassName = toRef(__$temp_1, "noDragClassName"), nodes = toRef(__$temp_1, "nodes"), nodeExtent = toRef(__$temp_1, "nodeExtent"), getNode = toRef(__$temp_1, "getNode"), multiSelectionActive = toRef(__$temp_1, "multiSelectionActive"), nodesSelectionActive = toRef(__$temp_1, "nodesSelectionActive"), selectNodesOnDrag = toRef(__$temp_1, "selectNodesOnDrag"), removeSelectedElements = toRef(__$temp_1, "removeSelectedElements"), addSelectedNodes = toRef(__$temp_1, "addSelectedNodes"), updateNodePositions = toRef(__$temp_1, "updateNodePositions");
    const __$temp_2 = params, onStart = toRef(__$temp_2, "onStart"), onDrag = toRef(__$temp_2, "onDrag"), onStop = toRef(__$temp_2, "onStop"), el = toRef(__$temp_2, "el"), disabled = toRef(__$temp_2, "disabled", false), id2 = toRef(__$temp_2, "id");
    const dragging2 = ref(false);
    let dragItems = ref();
    let lastPos = ref({ x: void 0, y: void 0 });
    let dragHandler = ref();
    const hasSnapGrid = (sg) => (sg != null ? sg : snapToGrid.value) ? globalSnapGrid.value : void 0;
    const getMousePosition2 = (event, snapGrid) => {
      const x = event.sourceEvent.touches ? event.sourceEvent.touches[0].clientX : event.sourceEvent.clientX;
      const y = event.sourceEvent.touches ? event.sourceEvent.touches[0].clientY : event.sourceEvent.clientY;
      return pointToRendererPoint(
        {
          x,
          y
        },
        viewport.value,
        !!snapGrid,
        snapGrid != null ? snapGrid : globalSnapGrid.value
      );
    };
    watch(
      [() => disabled.value, () => el.value],
      () => {
        if (el.value) {
          const selection2 = select(el.value);
          const node = id2.value ? getNode.value(id2.value) : void 0;
          if (disabled.value) {
            selection2.on(".drag", null);
          } else {
            dragHandler.value = drag().on("start", (event) => {
              if (!selectNodesOnDrag.value && !multiSelectionActive.value && id2.value) {
                if (!(node == null ? void 0 : node.selected)) {
                  removeSelectedElements.value();
                }
              }
              if (node && !disabled.value && selectNodesOnDrag.value) {
                handleNodeClick(node, multiSelectionActive.value, addSelectedNodes.value, removeSelectedElements.value, nodesSelectionActive);
              }
              const mousePos = getMousePosition2(event, hasSnapGrid(node == null ? void 0 : node.snapGrid));
              dragItems.value = getDragItems(nodes.value, mousePos, getNode.value, id2.value);
              if (onStart.value && dragItems.value) {
                const [currentNode, nodes2] = getEventHandlerParams({
                  id: id2.value,
                  dragItems: dragItems.value,
                  getNode
                });
                onStart.value(event.sourceEvent, currentNode, nodes2);
              }
            }).on("drag", (event) => {
              const mousePos = getMousePosition2(event, hasSnapGrid(node == null ? void 0 : node.snapGrid));
              if ((lastPos.value.x !== mousePos.x || lastPos.value.y !== mousePos.y) && dragItems.value) {
                lastPos.value = mousePos;
                dragItems.value = dragItems.value.map(
                  (n) => updatePosition(n, mousePos, n.parentNode ? getNode.value(n.parentNode) : void 0, nodeExtent.value)
                );
                updateNodePositions.value(dragItems.value, true, true);
                dragging2.value = true;
                if (onDrag.value) {
                  const [currentNode, nodes2] = getEventHandlerParams({
                    id: id2.value,
                    dragItems: dragItems.value,
                    getNode
                  });
                  onDrag.value(event.sourceEvent, currentNode, nodes2);
                }
              }
              event.on("end", (event2) => {
                dragging2.value = false;
                if (onStop.value && dragItems.value) {
                  updateNodePositions.value(dragItems.value, false, false);
                  const [currentNode, nodes2] = getEventHandlerParams({
                    id: id2.value,
                    dragItems: dragItems.value,
                    getNode
                  });
                  onStop.value(event2.sourceEvent, currentNode, nodes2);
                }
              });
            }).filter((event) => {
              const target = event.target;
              return !event.button && (!noDragClassName.value || !hasSelector(target, `.${noDragClassName.value}`, el) && (!(node == null ? void 0 : node.dragHandle) || hasSelector(target, node.dragHandle, el)));
            });
            selection2.call(dragHandler.value);
          }
        }
      },
      { flush: "post" }
    );
    return dragging2;
  });
  tryOnScopeDispose(() => scope.stop());
  return dragging;
}
const createNodeHooks = () => ({
  doubleClick: createEventHook(),
  click: createEventHook(),
  mouseEnter: createEventHook(),
  mouseMove: createEventHook(),
  mouseLeave: createEventHook(),
  contextMenu: createEventHook(),
  dragStart: createEventHook(),
  drag: createEventHook(),
  dragStop: createEventHook()
});
function useNodeHooks(node, emits) {
  const nodeHooks = createNodeHooks();
  nodeHooks.doubleClick.on((event) => {
    var _a2, _b;
    emits.nodeDoubleClick(event);
    (_b = (_a2 = node.events) == null ? void 0 : _a2.doubleClick) == null ? void 0 : _b.call(_a2, event);
  });
  nodeHooks.click.on((event) => {
    var _a2, _b;
    emits.nodeClick(event);
    (_b = (_a2 = node.events) == null ? void 0 : _a2.click) == null ? void 0 : _b.call(_a2, event);
  });
  nodeHooks.mouseEnter.on((event) => {
    var _a2, _b;
    emits.nodeMouseEnter(event);
    (_b = (_a2 = node.events) == null ? void 0 : _a2.mouseEnter) == null ? void 0 : _b.call(_a2, event);
  });
  nodeHooks.mouseMove.on((event) => {
    var _a2, _b;
    emits.nodeMouseMove(event);
    (_b = (_a2 = node.events) == null ? void 0 : _a2.mouseMove) == null ? void 0 : _b.call(_a2, event);
  });
  nodeHooks.mouseLeave.on((event) => {
    var _a2, _b;
    emits.nodeMouseLeave(event);
    (_b = (_a2 = node.events) == null ? void 0 : _a2.mouseLeave) == null ? void 0 : _b.call(_a2, event);
  });
  nodeHooks.contextMenu.on((event) => {
    var _a2, _b;
    emits.nodeContextMenu(event);
    (_b = (_a2 = node.events) == null ? void 0 : _a2.contextMenu) == null ? void 0 : _b.call(_a2, event);
  });
  nodeHooks.dragStart.on((event) => {
    var _a2, _b;
    emits.nodeDragStart(event);
    (_b = (_a2 = node.events) == null ? void 0 : _a2.dragStart) == null ? void 0 : _b.call(_a2, event);
  });
  nodeHooks.drag.on((event) => {
    var _a2, _b;
    emits.nodeDrag(event);
    (_b = (_a2 = node.events) == null ? void 0 : _a2.drag) == null ? void 0 : _b.call(_a2, event);
  });
  nodeHooks.dragStop.on((event) => {
    var _a2, _b;
    emits.nodeDragStop(event);
    (_b = (_a2 = node.events) == null ? void 0 : _a2.dragStop) == null ? void 0 : _b.call(_a2, event);
  });
  return Object.entries(nodeHooks).reduce(
    (hooks, [key, value]) => {
      hooks.emit[key] = value.trigger;
      hooks.on[key] = value.on;
      return hooks;
    },
    { emit: {}, on: {} }
  );
}
const createEdgeHooks = () => ({
  doubleClick: createEventHook(),
  click: createEventHook(),
  mouseEnter: createEventHook(),
  mouseMove: createEventHook(),
  mouseLeave: createEventHook(),
  contextMenu: createEventHook(),
  updateStart: createEventHook(),
  update: createEventHook(),
  updateEnd: createEventHook()
});
function useEdgeHooks(edge, emits) {
  const edgeHooks = createEdgeHooks();
  edgeHooks.doubleClick.on((event) => {
    var _a2, _b;
    emits.edgeDoubleClick(event);
    (_b = (_a2 = edge.events) == null ? void 0 : _a2.doubleClick) == null ? void 0 : _b.call(_a2, event);
  });
  edgeHooks.click.on((event) => {
    var _a2, _b;
    emits.edgeClick(event);
    (_b = (_a2 = edge.events) == null ? void 0 : _a2.click) == null ? void 0 : _b.call(_a2, event);
  });
  edgeHooks.mouseEnter.on((event) => {
    var _a2, _b;
    emits.edgeMouseEnter(event);
    (_b = (_a2 = edge.events) == null ? void 0 : _a2.mouseEnter) == null ? void 0 : _b.call(_a2, event);
  });
  edgeHooks.mouseMove.on((event) => {
    var _a2, _b;
    emits.edgeMouseMove(event);
    (_b = (_a2 = edge.events) == null ? void 0 : _a2.mouseMove) == null ? void 0 : _b.call(_a2, event);
  });
  edgeHooks.mouseLeave.on((event) => {
    var _a2, _b;
    emits.edgeMouseLeave(event);
    (_b = (_a2 = edge.events) == null ? void 0 : _a2.mouseLeave) == null ? void 0 : _b.call(_a2, event);
  });
  edgeHooks.contextMenu.on((event) => {
    var _a2, _b;
    emits.edgeContextMenu(event);
    (_b = (_a2 = edge.events) == null ? void 0 : _a2.contextMenu) == null ? void 0 : _b.call(_a2, event);
  });
  edgeHooks.updateStart.on((event) => {
    var _a2, _b;
    emits.edgeUpdateStart(event);
    (_b = (_a2 = edge.events) == null ? void 0 : _a2.updateStart) == null ? void 0 : _b.call(_a2, event);
  });
  edgeHooks.update.on((event) => {
    var _a2, _b;
    emits.edgeUpdate(event);
    (_b = (_a2 = edge.events) == null ? void 0 : _a2.update) == null ? void 0 : _b.call(_a2, event);
  });
  edgeHooks.updateEnd.on((event) => {
    var _a2, _b;
    emits.edgeUpdateEnd(event);
    (_b = (_a2 = edge.events) == null ? void 0 : _a2.updateEnd) == null ? void 0 : _b.call(_a2, event);
  });
  return Object.entries(edgeHooks).reduce(
    (hooks, [key, value]) => {
      hooks.emit[key] = value.trigger;
      hooks.on[key] = value.on;
      return hooks;
    },
    { emit: {}, on: {} }
  );
}
const __default__$a = {
  name: "SelectionPane",
  inheritAttrs: false
};
const _sfc_main$b = /* @__PURE__ */ defineComponent({
  ...__default__$a,
  setup(__props) {
    const __$temp_1 = useVueFlow(), id2 = toRef(__$temp_1, "id"), edges = toRef(__$temp_1, "edges"), deleteKeyCode = toRef(__$temp_1, "deleteKeyCode"), selectionKeyCode = toRef(__$temp_1, "selectionKeyCode"), multiSelectionKeyCode = toRef(__$temp_1, "multiSelectionKeyCode"), emits = toRef(__$temp_1, "emits"), nodesSelectionActive = toRef(__$temp_1, "nodesSelectionActive"), userSelectionActive = toRef(__$temp_1, "userSelectionActive"), elementsSelectable = toRef(__$temp_1, "elementsSelectable"), removeSelectedElements = toRef(__$temp_1, "removeSelectedElements"), setState = toRef(__$temp_1, "setState");
    toRef(__$temp_1, "getSelectedEdges");
    toRef(__$temp_1, "getSelectedNodes");
    const getNodes = toRef(__$temp_1, "getNodes"), removeNodes = toRef(__$temp_1, "removeNodes"), removeEdges = toRef(__$temp_1, "removeEdges");
    const onClick = (event) => {
      emits.value.paneClick(event);
      setState.value({
        nodesSelectionActive: false
      });
      removeSelectedElements.value();
    };
    const onContextMenu = (event) => emits.value.paneContextMenu(event);
    const onWheel = (event) => emits.value.paneScroll(event);
    const onMouseEnter = (event) => emits.value.paneMouseEnter(event);
    const onMouseLeave = (event) => emits.value.paneMouseLeave(event);
    const onMouseMove = (event) => emits.value.paneMouseMove(event);
    useKeyPress(deleteKeyCode.value, (keyPressed) => {
      if (!keyPressed)
        return;
      const nodesToRemove = getNodes.value.reduce((res, node) => {
        if (!node.selected && node.parentNode && res.find((n) => n.id === node.parentNode)) {
          res.push(node);
        } else if (node.selected) {
          res.push(node);
        }
        return res;
      }, []);
      const selectedEdges = edges.value.filter((e) => e.selected);
      if (nodesToRemove || selectedEdges) {
        if (selectedEdges.length > 0) {
          removeEdges.value(selectedEdges);
        }
        if (nodesToRemove.length > 0) {
          removeNodes.value(nodesToRemove);
        }
        setState.value({
          nodesSelectionActive: false
        });
        removeSelectedElements.value();
      }
    });
    useKeyPress(multiSelectionKeyCode.value, (keyPressed) => {
      setState.value({
        multiSelectionActive: keyPressed
      });
    });
    const selectionKeyPressed = useKeyPress(selectionKeyCode.value, (keyPressed) => {
      if (userSelectionActive.value && keyPressed)
        return;
      setState.value({
        userSelectionActive: keyPressed && elementsSelectable.value
      });
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock(Fragment, null, [
        unref(selectionKeyPressed) ? (openBlock(), createBlock(unref(_sfc_main$c), {
          key: `user-selection-${id2.value}`
        })) : createCommentVNode("", true),
        nodesSelectionActive.value ? (openBlock(), createBlock(unref(_sfc_main$e), {
          key: `nodes-selection-${id2.value}`
        })) : createCommentVNode("", true),
        (openBlock(), createElementBlock("div", {
          key: `pane-${id2.value}`,
          class: "vue-flow__pane vue-flow__container",
          onClick,
          onContextmenu: onContextMenu,
          onWheel,
          onMouseenter: onMouseEnter,
          onMousemove: onMouseMove,
          onMouseleave: onMouseLeave
        }, null, 32))
      ], 64);
    };
  }
});
const _hoisted_1$b = { class: "vue-flow__nodes vue-flow__container" };
const __default__$9 = {
  name: "Nodes"
};
const _sfc_main$a = /* @__PURE__ */ defineComponent({
  ...__default__$9,
  setup(__props) {
    const slots = inject(Slots);
    const __$temp_1 = useVueFlow(), nodesDraggable = toRef(__$temp_1, "nodesDraggable"), elementsSelectable = toRef(__$temp_1, "elementsSelectable"), nodesConnectable = toRef(__$temp_1, "nodesConnectable");
    toRef(__$temp_1, "noPanClassName");
    toRef(__$temp_1, "snapToGrid");
    toRef(__$temp_1, "snapGrid");
    toRef(__$temp_1, "getNode");
    const getNodes = toRef(__$temp_1, "getNodes"), getNodeTypes = toRef(__$temp_1, "getNodeTypes");
    const draggable = (d) => typeof d === "undefined" ? nodesDraggable.value : d;
    const selectable = (s) => typeof s === "undefined" ? elementsSelectable.value : s;
    const connectable = (c) => typeof c === "undefined" ? nodesConnectable.value : c;
    const getType = (type, template) => {
      const name = type || "default";
      let nodeType = template != null ? template : getNodeTypes.value[name];
      const instance = getCurrentInstance();
      if (typeof nodeType === "string") {
        if (instance) {
          const components = Object.keys(instance.appContext.components);
          if (components && components.includes(name)) {
            nodeType = resolveComponent(name, false);
          }
        }
      }
      if (typeof nodeType !== "string")
        return nodeType;
      const slot = slots == null ? void 0 : slots[`node-${name}`];
      if (!(slot == null ? void 0 : slot({}))) {
        console.warn(`[vueflow]: Node type "${type}" not found and no node-slot detected. Using fallback type "default".`);
        return false;
      }
      return slot;
    };
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", _hoisted_1$b, [
        (openBlock(true), createElementBlock(Fragment, null, renderList(getNodes.value, (node) => {
          return openBlock(), createBlock(unref(_sfc_main$h), {
            id: node.id,
            key: node.id,
            type: getType(node.type, node.template),
            name: node.type || "default",
            draggable: draggable(node.draggable),
            selectable: selectable(node.selectable),
            connectable: connectable(node.connectable),
            node
          }, null, 8, ["id", "type", "name", "draggable", "selectable", "connectable", "node"]);
        }), 128))
      ]);
    };
  }
});
const _hoisted_1$a = ["id", "markerWidth", "markerHeight", "markerUnits", "orient"];
const _hoisted_2$7 = ["stroke", "stroke-width", "fill"];
const _hoisted_3$6 = ["stroke", "stroke-width"];
const __default__$8 = {
  name: "MarkerType"
};
const _sfc_main$9 = /* @__PURE__ */ defineComponent({
  ...__default__$8,
  props: {
    id: null,
    type: null,
    color: { default: "none" },
    width: { default: 12.5 },
    height: { default: 12.5 },
    markerUnits: { default: "strokeWidth" },
    orient: { default: "auto" },
    strokeWidth: { default: 1 }
  },
  setup(__props) {
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("marker", {
        id: __props.id,
        class: "vue-flow__arrowhead",
        viewBox: "-10 -10 20 20",
        refX: "0",
        refY: "0",
        markerWidth: `${__props.width}`,
        markerHeight: `${__props.height}`,
        markerUnits: __props.markerUnits,
        orient: __props.orient
      }, [
        __props.type === "arrowclosed" ? (openBlock(), createElementBlock("polyline", {
          key: 0,
          stroke: __props.color,
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": __props.strokeWidth,
          fill: __props.color,
          points: "-5,-4 0,0 -5,4 -5,-4"
        }, null, 8, _hoisted_2$7)) : createCommentVNode("", true),
        __props.type === "arrow" ? (openBlock(), createElementBlock("polyline", {
          key: 1,
          stroke: __props.color,
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": __props.strokeWidth,
          fill: "none",
          points: "-5,-4 0,0 -5,4"
        }, null, 8, _hoisted_3$6)) : createCommentVNode("", true)
      ], 8, _hoisted_1$a);
    };
  }
});
const __default__$7 = {
  name: "MarkerDefinitions"
};
const _sfc_main$8 = /* @__PURE__ */ defineComponent({
  ...__default__$7,
  setup(__props) {
    const __$temp_1 = useVueFlow(), edges = toRef(__$temp_1, "edges"), connectionLineOptions = toRef(__$temp_1, "connectionLineOptions"), defaultColor = toRef(__$temp_1, "defaultMarkerColor");
    const markers = computed(() => {
      const ids = [];
      const markers2 = [];
      const createMarkers = (marker) => {
        if (marker) {
          const markerId = getMarkerId(marker);
          if (!ids.includes(markerId)) {
            if (typeof marker === "object")
              markers2.push({ ...marker, id: markerId, color: marker.color || defaultColor.value });
            else
              markers2.push({ id: markerId, color: defaultColor.value, type: marker });
            ids.push(markerId);
          }
        }
      };
      [connectionLineOptions.value.markerEnd, connectionLineOptions.value.markerStart].forEach(createMarkers);
      edges.value.reduce((markers3, edge) => {
        [edge.markerStart, edge.markerEnd].forEach(createMarkers);
        return markers3.sort((a, b) => a.id.localeCompare(b.id));
      }, markers2);
      return markers2;
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("defs", null, [
        (openBlock(true), createElementBlock(Fragment, null, renderList(unref(markers), (marker) => {
          return openBlock(), createBlock(_sfc_main$9, {
            id: marker.id,
            key: marker.id,
            type: marker.type,
            color: marker.color,
            width: marker.width,
            height: marker.height,
            markerUnits: marker.markerUnits,
            "stroke-width": marker.strokeWidth,
            orient: marker.orient
          }, null, 8, ["id", "type", "color", "width", "height", "markerUnits", "stroke-width", "orient"]);
        }), 128))
      ]);
    };
  }
});
const _hoisted_1$9 = {
  key: 0,
  class: "vue-flow__edges vue-flow__connectionline vue-flow__container"
};
const __default__$6 = {
  name: "Edges"
};
const _sfc_main$7 = /* @__PURE__ */ defineComponent({
  ...__default__$6,
  setup(__props) {
    const slots = inject(Slots);
    const __$temp_1 = useVueFlow(), emits = toRef(__$temp_1, "emits"), connectionMode = toRef(__$temp_1, "connectionMode"), edgeUpdaterRadius = toRef(__$temp_1, "edgeUpdaterRadius"), onPaneReady = toRef(__$temp_1, "onPaneReady"), connectionNodeId = toRef(__$temp_1, "connectionNodeId"), nodesConnectable = toRef(__$temp_1, "nodesConnectable"), connectionHandleType = toRef(__$temp_1, "connectionHandleType"), edgesUpdatable = toRef(__$temp_1, "edgesUpdatable"), elementsSelectable = toRef(__$temp_1, "elementsSelectable"), getSelectedNodes = toRef(__$temp_1, "getSelectedNodes"), nodesSelectionActive = toRef(__$temp_1, "nodesSelectionActive"), getNode = toRef(__$temp_1, "getNode");
    toRef(__$temp_1, "getNodes");
    const getEdges = toRef(__$temp_1, "getEdges"), getEdgeTypes = toRef(__$temp_1, "getEdgeTypes"), addSelectedEdges = toRef(__$temp_1, "addSelectedEdges"), noPanClassName = toRef(__$temp_1, "noPanClassName"), elevateEdgesOnSelect = toRef(__$temp_1, "elevateEdgesOnSelect");
    const selectable = (s) => typeof s === "undefined" ? elementsSelectable.value : s;
    const updatable = (u) => typeof u === "undefined" ? edgesUpdatable.value : u;
    const sourceNode = computedWithControl(connectionNodeId, () => {
      if (connectionNodeId.value)
        return getNode.value(connectionNodeId.value);
      return false;
    });
    const connectionLineVisible = computedWithControl(
      connectionNodeId,
      () => !!(sourceNode.value && (typeof sourceNode.value.connectable === "undefined" ? nodesConnectable.value : sourceNode.value.connectable) && connectionNodeId.value && connectionHandleType.value)
    );
    const hooks = ref({});
    let groups = ref([]);
    let scope = effectScope();
    onPaneReady.value(() => {
      if (!scope)
        scope = effectScope();
      scope.run(() => {
        const edgeAmount = computed(() => getEdges.value.length);
        watch(
          [getSelectedNodes, edgeAmount],
          () => {
            getEdges.value.forEach((edge) => {
              if (hooks.value[edge.id])
                return;
              hooks.value[edge.id] = useEdgeHooks(edge, emits.value);
            });
            if (elevateEdgesOnSelect.value) {
              nextTick(() => groups.value = groupEdgesByZLevel(getEdges.value, getNode.value));
            } else {
              groups.value = [
                {
                  isMaxLevel: true,
                  edges: getEdges.value,
                  level: 0
                }
              ];
            }
          },
          {
            immediate: true
          }
        );
      });
    });
    onBeforeUnmount(() => {
      scope == null ? void 0 : scope.stop();
      scope = null;
    });
    const getType = (type, template) => {
      const name = type || "default";
      let edgeType = template != null ? template : getEdgeTypes.value[name];
      const instance = getCurrentInstance();
      if (typeof edgeType === "string") {
        if (instance) {
          const components = Object.keys(instance.appContext.components);
          if (components && components.includes(name)) {
            edgeType = resolveComponent(name, false);
          }
        }
      }
      if (edgeType && typeof edgeType !== "string")
        return edgeType;
      const slot = slots == null ? void 0 : slots[`edge-${name}`];
      if (!(slot == null ? void 0 : slot({}))) {
        console.warn(`[vueflow]: Edge type "${type}" not found and no edge-slot detected. Using fallback type "default".`);
        return false;
      }
      return slot;
    };
    const onEdgeClick = (event, edge) => {
      const data = { event, edge };
      if (selectable(edge.selectable)) {
        nodesSelectionActive.value = false;
        addSelectedEdges.value([edge]);
      }
      hooks.value[edge.id].emit.click(data);
    };
    const onEdgeContextMenu = (event, edge) => hooks.value[edge.id].emit.contextMenu({ event, edge });
    const onDoubleClick = (event, edge) => hooks.value[edge.id].emit.doubleClick({ event, edge });
    const onEdgeMouseEnter = (event, edge) => hooks.value[edge.id].emit.mouseEnter({ event, edge });
    const onEdgeMouseMove = (event, edge) => hooks.value[edge.id].emit.mouseMove({ event, edge });
    const onEdgeMouseLeave = (event, edge) => hooks.value[edge.id].emit.mouseLeave({ event, edge });
    const onEdgeUpdaterSourceMouseDown = (event, edge) => handleEdgeUpdater(event, edge, true);
    const onEdgeUpdaterTargetMouseDown = (event, edge) => handleEdgeUpdater(event, edge, false);
    const { onMouseDown } = useHandle();
    const handleEdgeUpdater = (event, edge, isSourceHandle) => {
      var _a2;
      const nodeId = isSourceHandle ? edge.target : edge.source;
      const handleId = (_a2 = isSourceHandle ? edge.targetHandle : edge.sourceHandle) != null ? _a2 : "";
      hooks.value[edge.id].emit.updateStart({ event, edge });
      onMouseDown(
        event,
        handleId,
        nodeId,
        isSourceHandle,
        void 0,
        isSourceHandle ? "target" : "source",
        (connection) => {
          if (!connectionExists(connection, getEdges.value))
            hooks.value[edge.id].emit.update({ edge, connection });
        },
        () => hooks.value[edge.id].emit.updateEnd({ event, edge })
      );
    };
    const getClass = (edge) => {
      const extraClass = edge.class instanceof Function ? edge.class(edge) : edge.class;
      return [noPanClassName.value, extraClass];
    };
    const getStyle = (edge) => edge.style instanceof Function ? edge.style(edge) : edge.style;
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock(Fragment, null, [
        (openBlock(true), createElementBlock(Fragment, null, renderList(groups.value, (group) => {
          return openBlock(), createElementBlock("svg", {
            key: group.level,
            class: "vue-flow__edges vue-flow__container",
            style: normalizeStyle(`z-index: ${group.level}`)
          }, [
            group.isMaxLevel ? (openBlock(), createBlock(_sfc_main$8, { key: 0 })) : createCommentVNode("", true),
            createElementVNode("g", null, [
              (openBlock(true), createElementBlock(Fragment, null, renderList(group.edges, (edge) => {
                return openBlock(), createBlock(unref(Wrapper), {
                  id: edge.id,
                  key: edge.id,
                  type: getType(edge.type, edge.template),
                  name: edge.type || "default",
                  source: edge.source,
                  target: edge.target,
                  "target-handle-id": edge.targetHandle,
                  "source-handle-id": edge.sourceHandle,
                  "source-node": getNode.value(edge.source),
                  "target-node": getNode.value(edge.target),
                  label: edge.label,
                  data: edge.data,
                  events: { ...edge.events, ...hooks.value[edge.id].on },
                  animated: edge.animated,
                  selectable: selectable(edge.selectable),
                  selected: edge.selected,
                  updatable: updatable(edge.updatable),
                  "label-style": edge.labelStyle,
                  "label-show-bg": edge.labelShowBg,
                  "label-bg-style": edge.labelBgStyle,
                  "label-bg-padding": edge.labelBgPadding,
                  "label-bg-border-radius": edge.labelBgBorderRadius,
                  "connection-mode": connectionMode.value,
                  "edge-updater-radius": edgeUpdaterRadius.value,
                  "marker-end": edge.markerEnd,
                  "marker-start": edge.markerStart,
                  style: normalizeStyle(getStyle(edge)),
                  class: normalizeClass(getClass(edge)),
                  onClick: ($event) => onEdgeClick($event, edge),
                  onDblclick: ($event) => onDoubleClick($event, edge),
                  onContextmenu: ($event) => onEdgeContextMenu($event, edge),
                  onMouseenter: ($event) => onEdgeMouseEnter($event, edge),
                  onMousemove: ($event) => onEdgeMouseMove($event, edge),
                  onMouseleave: ($event) => onEdgeMouseLeave($event, edge),
                  onSourceMousedown: ($event) => onEdgeUpdaterSourceMouseDown($event, edge),
                  onTargetMousedown: ($event) => onEdgeUpdaterTargetMouseDown($event, edge)
                }, null, 8, ["id", "type", "name", "source", "target", "target-handle-id", "source-handle-id", "source-node", "target-node", "label", "data", "events", "animated", "selectable", "selected", "updatable", "label-style", "label-show-bg", "label-bg-style", "label-bg-padding", "label-bg-border-radius", "connection-mode", "edge-updater-radius", "marker-end", "marker-start", "style", "class", "onClick", "onDblclick", "onContextmenu", "onMouseenter", "onMousemove", "onMouseleave", "onSourceMousedown", "onTargetMousedown"]);
              }), 128))
            ])
          ], 4);
        }), 128)),
        connectionLineVisible.value && !!sourceNode.value ? (openBlock(), createElementBlock("svg", _hoisted_1$9, [
          createVNode(_sfc_main$f, { "source-node": sourceNode.value }, null, 8, ["source-node"])
        ])) : createCommentVNode("", true)
      ], 64);
    };
  }
});
const __default__$5 = {
  name: "Transform"
};
const _sfc_main$6 = /* @__PURE__ */ defineComponent({
  ...__default__$5,
  setup(__props) {
    const { id: id2, nodes, edges, viewport, snapToGrid, snapGrid, dimensions, setState, fitViewOnInit, emits, fitView, ...rest } = useVueFlow();
    const untilDimensions2 = async (dim) => {
      const window2 = useWindow();
      if ("screen" in window2) {
        await until(dim).toMatch(({ height, width }) => !isNaN(width) && width > 0 && !isNaN(height) && height > 0);
      }
      return true;
    };
    let ready = ref(false);
    onMounted(async () => {
      await untilDimensions2(dimensions.value);
      ready.value = true;
      emits.paneReady({
        id: id2,
        nodes,
        edges,
        viewport,
        snapToGrid,
        snapGrid,
        dimensions,
        setState,
        fitViewOnInit,
        fitView,
        emits,
        ...rest
      });
      (fitViewOnInit == null ? void 0 : fitViewOnInit.value) && fitView();
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        key: `transform-${unref(id2)}`,
        class: "vue-flow__transformationpane vue-flow__container",
        style: normalizeStyle({ transform: `translate(${unref(viewport).x}px,${unref(viewport).y}px) scale(${unref(viewport).zoom})`, opacity: ready.value ? void 0 : 0 })
      }, [
        createVNode(_sfc_main$7),
        createVNode(_sfc_main$a),
        renderSlot(_ctx.$slots, "default")
      ], 4);
    };
  }
});
const __default__$4 = {
  name: "Viewport"
};
const _sfc_main$5 = /* @__PURE__ */ defineComponent({
  ...__default__$4,
  setup(__props) {
    const __$temp_1 = useVueFlow(), id2 = toRef(__$temp_1, "id"), minZoom = toRef(__$temp_1, "minZoom"), maxZoom = toRef(__$temp_1, "maxZoom"), defaultZoom = toRef(__$temp_1, "defaultZoom"), defaultPosition = toRef(__$temp_1, "defaultPosition"), translateExtent = toRef(__$temp_1, "translateExtent"), dimensions = toRef(__$temp_1, "dimensions"), zoomActivationKeyCode = toRef(__$temp_1, "zoomActivationKeyCode"), selectionKeyCode = toRef(__$temp_1, "selectionKeyCode"), panOnScroll = toRef(__$temp_1, "panOnScroll"), panOnScrollMode = toRef(__$temp_1, "panOnScrollMode"), panOnScrollSpeed = toRef(__$temp_1, "panOnScrollSpeed"), panOnDrag = toRef(__$temp_1, "panOnDrag"), zoomOnDoubleClick = toRef(__$temp_1, "zoomOnDoubleClick"), zoomOnPinch = toRef(__$temp_1, "zoomOnPinch"), zoomOnScroll = toRef(__$temp_1, "zoomOnScroll"), preventScrolling = toRef(__$temp_1, "preventScrolling"), noWheelClassName = toRef(__$temp_1, "noWheelClassName"), noPanClassName = toRef(__$temp_1, "noPanClassName"), setState = toRef(__$temp_1, "setState"), emits = toRef(__$temp_1, "emits");
    const viewportEl = templateRef("viewport", null);
    let isZoomingOrPanning = ref(false);
    const viewChanged = (prevTransform, eventTransform) => prevTransform.x !== eventTransform.x && !isNaN(eventTransform.x) || prevTransform.y !== eventTransform.y && !isNaN(eventTransform.y) || prevTransform.zoom !== eventTransform.k && !isNaN(eventTransform.k);
    const eventToFlowTransform = (eventTransform) => ({
      x: eventTransform.x,
      y: eventTransform.y,
      zoom: eventTransform.k
    });
    const isWrappedWithClass = (event, className) => event.target.closest(`.${className}`);
    const clampedZoom = clamp(defaultZoom.value, minZoom.value, maxZoom.value);
    let transform = ref({
      ...clampPosition({ x: defaultPosition.value[0], y: defaultPosition.value[1] }, translateExtent.value),
      zoom: clampedZoom
    });
    const { width, height } = useElementBounding(viewportEl);
    const stop = watch(
      [width, height],
      ([newWidth, newHeight]) => {
        dimensions.value.width = newWidth;
        dimensions.value.height = newHeight;
      },
      { immediate: true }
    );
    onBeforeUnmount(() => stop());
    onMounted(() => {
      const window2 = useWindow();
      if ("screen" in window2) {
        useEventListener(window2, "onresize", () => {
          if (!viewportEl.value)
            return;
          const { width: width2, height: height2 } = getDimensions(viewportEl.value);
          dimensions.value.width = width2;
          dimensions.value.height = height2;
        });
      }
      const d3Zoom = zoom().scaleExtent([minZoom.value, maxZoom.value]).translateExtent(translateExtent.value);
      const d3Selection = select(viewportEl.value).call(d3Zoom);
      const d3ZoomHandler = d3Selection.on("wheel.zoom");
      const updatedTransform = identity.translate(transform.value.x, transform.value.y).scale(transform.value.zoom);
      d3Zoom.transform(d3Selection, updatedTransform);
      setState.value({
        d3Zoom,
        d3Selection,
        d3ZoomHandler,
        viewport: { x: updatedTransform.x, y: updatedTransform.y, zoom: updatedTransform.k },
        viewportRef: viewportEl.value
      });
      const selectionKeyPressed = useKeyPress(selectionKeyCode.value, (keyPress) => {
        if (keyPress && !isZoomingOrPanning.value) {
          d3Zoom.on("zoom", null);
        } else if (!keyPress) {
          d3Zoom.on("zoom", (event) => {
            setState.value({ viewport: { x: event.transform.x, y: event.transform.y, zoom: event.transform.k } });
            const flowTransform = eventToFlowTransform(event.transform);
            emits.value.move({ event, flowTransform });
          });
        }
      });
      const zoomKeyPressed = useKeyPress(zoomActivationKeyCode.value);
      d3Zoom.on("start", (event) => {
        isZoomingOrPanning.value = true;
        const flowTransform = eventToFlowTransform(event.transform);
        transform.value = flowTransform;
        emits.value.moveStart({ event, flowTransform });
      });
      d3Zoom.on("end", (event) => {
        isZoomingOrPanning.value = false;
        if (viewChanged(transform.value, event.transform)) {
          const flowTransform = eventToFlowTransform(event.transform);
          transform.value = flowTransform;
          emits.value.moveEnd({ event, flowTransform });
        }
      });
      watchEffect(() => {
        if (panOnScroll.value && !zoomKeyPressed.value) {
          d3Selection.on("wheel", (event) => {
            var _a2;
            if (isWrappedWithClass(event, (_a2 = noWheelClassName.value) == null ? void 0 : _a2.value)) {
              return false;
            }
            event.preventDefault();
            event.stopImmediatePropagation();
            const currentZoom = d3Selection.property("__zoom").k || 1;
            if (event.ctrlKey && zoomOnPinch.value) {
              const point = pointer(event);
              const pinchDelta = -event.deltaY * (event.deltaMode === 1 ? 0.05 : event.deltaMode ? 1 : 2e-3) * 10;
              const zoom2 = currentZoom * 2 ** pinchDelta;
              d3Zoom.scaleTo(d3Selection, zoom2, point);
              return;
            }
            const deltaNormalize = event.deltaMode === 1 ? 20 : 1;
            const deltaX = panOnScrollMode.value === PanOnScrollMode.Vertical ? 0 : event.deltaX * deltaNormalize;
            const deltaY = panOnScrollMode.value === PanOnScrollMode.Horizontal ? 0 : event.deltaY * deltaNormalize;
            d3Zoom.translateBy(d3Selection, -(deltaX / currentZoom) * panOnScrollSpeed.value, -(deltaY / currentZoom) * panOnScrollSpeed.value);
          }).on("wheel.zoom", null);
        } else if (typeof d3ZoomHandler !== "undefined") {
          d3Selection.on("wheel", (event) => {
            var _a2;
            if (!preventScrolling.value || isWrappedWithClass(event, (_a2 = noWheelClassName.value) == null ? void 0 : _a2.value)) {
              return null;
            }
            event.preventDefault();
          }).on("wheel.zoom", d3ZoomHandler);
        }
      });
      d3Zoom.filter((event) => {
        const zoomScroll = zoomKeyPressed.value || zoomOnScroll.value;
        const pinchZoom = zoomOnPinch.value && event.ctrlKey;
        if (!panOnDrag.value && !zoomScroll && !panOnScroll.value && !zoomOnDoubleClick.value && !zoomOnPinch.value)
          return false;
        if (selectionKeyPressed.value)
          return false;
        if (!zoomOnDoubleClick.value && event.type === "dblclick")
          return false;
        if (isWrappedWithClass(event, noWheelClassName.value) && event.type === "wheel")
          return false;
        if (isWrappedWithClass(event, noPanClassName.value) && event.type !== "wheel")
          return false;
        if (!zoomOnPinch.value && event.ctrlKey && event.type === "wheel")
          return false;
        if (!zoomScroll && !panOnScroll.value && !pinchZoom && event.type === "wheel")
          return false;
        if (!panOnDrag.value && (event.type === "mousedown" || event.type === "touchstart"))
          return false;
        return (!event.ctrlKey || event.type === "wheel") && !event.button;
      });
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        ref: "viewport",
        key: `viewport-${id2.value}`,
        class: "vue-flow__viewport vue-flow__container"
      }, [
        createVNode(_sfc_main$6, null, {
          default: withCtx(() => [
            renderSlot(_ctx.$slots, "default")
          ]),
          _: 3
        }),
        createVNode(_sfc_main$b)
      ]);
    };
  }
});
const isDef = (val) => typeof val !== "undefined";
var useWatch = (models, props, store) => {
  const scope = effectScope();
  scope.run(() => {
    const watchModelValue = () => {
      scope.run(() => {
        let pauseModel;
        let pauseStore;
        pauseModel = watchPausable(
          [models.modelValue, () => {
            var _a2, _b;
            return (_b = (_a2 = models.modelValue) == null ? void 0 : _a2.value) == null ? void 0 : _b.length;
          }],
          ([v]) => {
            if (v && Array.isArray(v)) {
              if (pauseStore)
                pauseStore.pause();
              if (pauseModel)
                pauseModel.pause();
              store.setElements(v);
              pauseStore = watchPausable(
                [store.edges, store.nodes, () => store.edges.value.length, () => store.nodes.value.length],
                ([e, n]) => {
                  if (pauseModel)
                    pauseModel.pause();
                  const val = [...n, ...e];
                  if (val.length)
                    models.modelValue.value = val;
                  nextTick(() => {
                    if (pauseModel)
                      pauseModel.resume();
                  });
                },
                { immediate: true }
              );
              nextTick(() => {
                if (pauseStore)
                  pauseStore.resume();
                if (pauseModel)
                  pauseModel.resume();
              });
            }
          },
          { immediate: !!(models.modelValue && models.modelValue.value) }
        );
      });
    };
    const watchNodesValue = () => {
      scope.run(() => {
        let pauseModel;
        let pauseStore;
        pauseModel = watchPausable(
          [models.nodes, () => {
            var _a2, _b;
            return (_b = (_a2 = models.nodes) == null ? void 0 : _a2.value) == null ? void 0 : _b.length;
          }],
          async ([v]) => {
            if (v && Array.isArray(v)) {
              if (pauseStore)
                pauseStore.pause();
              if (pauseModel)
                pauseModel.pause();
              store.setNodes(v);
              pauseStore = watchPausable(
                () => store.nodes.value.length,
                () => {
                  if (store.nodes.value.length)
                    models.nodes.value = [...store.nodes.value];
                },
                { immediate: true }
              );
              nextTick(() => {
                if (pauseStore)
                  pauseStore.resume();
                if (pauseModel)
                  pauseModel.resume();
              });
            }
          },
          { immediate: !!(models.nodes && models.nodes.value) }
        );
      });
    };
    const watchEdgesValue = () => {
      scope.run(() => {
        let pauseModel;
        let pauseStore;
        pauseModel = watchPausable(
          [models.edges, () => {
            var _a2, _b;
            return (_b = (_a2 = models.edges) == null ? void 0 : _a2.value) == null ? void 0 : _b.length;
          }],
          async ([v]) => {
            if (v && Array.isArray(v)) {
              if (pauseStore)
                pauseStore.pause();
              if (pauseModel)
                pauseModel.pause();
              store.setEdges(v);
              pauseStore = watchPausable(
                () => store.edges.value.length,
                () => {
                  if (store.edges.value.length)
                    models.edges.value = [...store.edges.value];
                },
                { immediate: true }
              );
              nextTick(() => {
                if (pauseStore)
                  pauseStore.resume();
                if (pauseModel)
                  pauseModel.resume();
              });
            }
          },
          { immediate: !!(models.edges && models.edges.value) }
        );
      });
    };
    const watchMaxZoom = () => {
      scope.run(() => {
        watch(
          () => props.maxZoom,
          () => {
            if (props.maxZoom && isDef(props.maxZoom)) {
              store.setMaxZoom(props.maxZoom);
            }
          },
          { immediate: isDef(props.maxZoom) }
        );
      });
    };
    const watchMinZoom = () => {
      scope.run(() => {
        watch(
          () => props.minZoom,
          () => {
            if (props.minZoom && isDef(props.minZoom)) {
              store.setMinZoom(props.minZoom);
            }
          },
          { immediate: isDef(props.minZoom) }
        );
      });
    };
    const watchApplyDefault = () => {
      scope.run(() => {
        watch(
          () => props.applyDefault,
          () => {
            if (isDef(props.applyDefault)) {
              store.applyDefault.value = props.applyDefault;
            }
          },
          { immediate: isDef(props.applyDefault) }
        );
        watch(
          store.applyDefault,
          (_, __, onCleanup) => {
            if (store.applyDefault.value) {
              store.onNodesChange(store.applyNodeChanges);
              store.onEdgesChange(store.applyEdgeChanges);
            } else {
              store.hooks.value.nodesChange.off(store.applyNodeChanges);
              store.hooks.value.edgesChange.off(store.applyEdgeChanges);
            }
            onCleanup(() => {
              store.hooks.value.nodesChange.off(store.applyNodeChanges);
              store.hooks.value.edgesChange.off(store.applyEdgeChanges);
            });
          },
          { immediate: true }
        );
      });
    };
    const watchAutoConnect = () => {
      scope.run(() => {
        const autoConnector = async (params) => {
          let connection = params;
          if (isFunction(props.autoConnect)) {
            connection = await props.autoConnect(params);
          }
          if (connection !== false) {
            store.addEdges([connection]);
          }
        };
        watch(
          () => props.autoConnect,
          () => {
            if (isDef(props.autoConnect)) {
              store.autoConnect.value = props.autoConnect;
            }
          },
          { immediate: isDef(props.autoConnect) }
        );
        watch(
          store.autoConnect,
          (autoConnectEnabled, _, onCleanup) => {
            if (autoConnectEnabled) {
              store.onConnect(autoConnector);
            } else {
              store.hooks.value.connect.off(autoConnector);
            }
            onCleanup(() => {
              store.hooks.value.connect.off(autoConnector);
            });
          },
          { immediate: true }
        );
      });
    };
    const watchRest = () => {
      const skip = ["id", "modelValue", "edges", "nodes", "maxZoom", "minZoom", "applyDefault", "autoConnect"];
      Object.keys(props).forEach((prop) => {
        if (!skip.includes(prop)) {
          const model = props[prop];
          const storedValue = store[prop];
          scope.run(() => {
            watch(
              () => model,
              () => {
                if (isDef(model)) {
                  storedValue.value = model;
                }
              },
              { immediate: isDef(model) }
            );
          });
        }
      });
    };
    [
      watchModelValue,
      watchNodesValue,
      watchEdgesValue,
      watchMinZoom,
      watchMaxZoom,
      watchApplyDefault,
      watchAutoConnect,
      watchRest
    ].forEach((watch2) => watch2());
  });
  return () => scope.stop();
};
const __default__$3 = {
  name: "VueFlow"
};
const _sfc_main$4 = /* @__PURE__ */ defineComponent({
  ...__default__$3,
  props: {
    id: null,
    modelValue: null,
    nodes: null,
    edges: null,
    edgeTypes: null,
    nodeTypes: null,
    connectionMode: null,
    connectionLineType: null,
    connectionLineStyle: { default: void 0 },
    connectionLineOptions: null,
    deleteKeyCode: null,
    selectionKeyCode: null,
    multiSelectionKeyCode: null,
    zoomActivationKeyCode: null,
    snapToGrid: { type: Boolean, default: void 0 },
    snapGrid: null,
    onlyRenderVisibleElements: { type: Boolean, default: void 0 },
    edgesUpdatable: { type: Boolean, default: void 0 },
    nodesDraggable: { type: Boolean, default: void 0 },
    nodesConnectable: { type: Boolean, default: void 0 },
    elementsSelectable: { type: Boolean, default: void 0 },
    selectNodesOnDrag: { type: Boolean, default: void 0 },
    panOnDrag: { type: Boolean, default: void 0 },
    minZoom: null,
    maxZoom: null,
    defaultZoom: null,
    defaultPosition: null,
    translateExtent: null,
    nodeExtent: null,
    defaultMarkerColor: null,
    zoomOnScroll: { type: Boolean, default: void 0 },
    zoomOnPinch: { type: Boolean, default: void 0 },
    panOnScroll: { type: Boolean, default: void 0 },
    panOnScrollSpeed: null,
    panOnScrollMode: null,
    zoomOnDoubleClick: { type: Boolean, default: void 0 },
    preventScrolling: { type: Boolean, default: void 0 },
    edgeUpdaterRadius: null,
    fitViewOnInit: { type: Boolean, default: void 0 },
    connectOnClick: { type: Boolean, default: void 0 },
    applyDefault: { type: Boolean, default: void 0 },
    autoConnect: { type: [Boolean, Function], default: void 0 },
    noDragClassName: null,
    noWheelClassName: null,
    noPanClassName: null,
    defaultEdgeOptions: null,
    elevateEdgesOnSelect: { type: Boolean, default: void 0 }
  },
  emits: ["nodesChange", "edgesChange", "nodeDoubleClick", "nodeClick", "nodeMouseEnter", "nodeMouseMove", "nodeMouseLeave", "nodeContextMenu", "nodeDragStart", "nodeDrag", "nodeDragStop", "miniMapNodeClick", "miniMapNodeDoubleClick", "miniMapNodeMouseEnter", "miniMapNodeMouseMove", "miniMapNodeMouseLeave", "connect", "connectStart", "connectStop", "connectEnd", "moveStart", "move", "moveEnd", "selectionDragStart", "selectionDrag", "selectionDragStop", "selectionContextMenu", "paneReady", "paneScroll", "paneClick", "paneContextMenu", "paneMouseEnter", "paneMouseMove", "paneMouseLeave", "edgeContextMenu", "edgeMouseEnter", "edgeMouseMove", "edgeMouseLeave", "edgeDoubleClick", "edgeClick", "edgeUpdateStart", "edgeUpdate", "edgeUpdateEnd", "update:modelValue", "update:nodes", "update:edges"],
  setup(__props, { expose, emit }) {
    const props = __props;
    const modelValue = useVModel(props, "modelValue", emit);
    const modelNodes = useVModel(props, "nodes", emit);
    const modelEdges = useVModel(props, "edges", emit);
    const { vueFlowRef, id: id2, hooks, getNodeTypes, getEdgeTypes, $reset, ...rest } = useVueFlow({ id: props.id });
    const dispose = useWatch({ modelValue, nodes: modelNodes, edges: modelEdges }, props, {
      vueFlowRef,
      id: id2,
      hooks,
      getNodeTypes,
      getEdgeTypes,
      $reset,
      ...rest
    });
    const el = ref();
    onUnmounted(() => {
      dispose();
    });
    onMounted(() => {
      vueFlowRef.value = el.value;
    });
    useHooks(emit, hooks);
    provide(Slots, useSlots());
    expose({
      vueFlowRef,
      id: id2,
      hooks,
      getNodeTypes,
      getEdgeTypes,
      $reset,
      ...rest
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        ref_key: "el",
        ref: el,
        class: "vue-flow"
      }, [
        createVNode(_sfc_main$5, null, {
          nodes: withCtx(() => [
            (openBlock(true), createElementBlock(Fragment, null, renderList(Object.keys(unref(getNodeTypes)), (nodeName) => {
              return renderSlot(_ctx.$slots, `node-${nodeName}`);
            }), 256))
          ]),
          edges: withCtx(() => [
            (openBlock(true), createElementBlock(Fragment, null, renderList(Object.keys(unref(getEdgeTypes)), (edgeName) => {
              return renderSlot(_ctx.$slots, `edge-${edgeName}`);
            }), 256))
          ]),
          "connection-name": withCtx(() => [
            renderSlot(_ctx.$slots, "connection-line")
          ]),
          default: withCtx(() => [
            renderSlot(_ctx.$slots, "zoom-pane")
          ]),
          _: 3
        }),
        renderSlot(_ctx.$slots, "default")
      ], 512);
    };
  }
});
const MiniMapNode = function({
  position: { x, y },
  dimensions: { height, width },
  strokeWidth,
  strokeColor,
  borderRadius,
  color: color2,
  shapeRendering = "geometricPrecision"
}, { attrs, emit, slots }) {
  var _a2, _b;
  const style = (_a2 = attrs.style) != null ? _a2 : {};
  return [
    h("rect", {
      class: ["vue-flow__minimap-node", attrs.class].join(" "),
      style,
      x,
      y,
      rx: borderRadius,
      ry: borderRadius,
      width,
      height,
      fill: color2 || style.background || style.backgroundColor,
      stroke: strokeColor,
      strokeWidth,
      shapeRendering,
      onClick: (e) => emit("click", e),
      onDblClick: (e) => emit("dblclick", e),
      onMouseenter: (e) => emit("mouseenter", e),
      onMousemove: (e) => emit("mousemove", e),
      onMouseleave: (e) => emit("mouseleave", e)
    }),
    (_b = slots == null ? void 0 : slots.default) == null ? void 0 : _b.call(slots)
  ];
};
MiniMapNode.props = ["position", "dimensions", "strokeWidth", "strokeColor", "borderRadius", "color", "shapeRendering"];
MiniMapNode.emits = ["click", "dblclick", "mouseenter", "mousemove", "mouseleave"];
const _hoisted_1$8 = ["width", "height", "viewBox"];
const _hoisted_2$6 = ["d", "fill"];
const __default__$2 = {
  name: "MiniMap"
};
const _sfc_main$3 = /* @__PURE__ */ defineComponent({
  ...__default__$2,
  props: {
    nodeColor: { type: [String, Function], default: "#fff" },
    nodeStrokeColor: { type: [String, Function], default: "#555" },
    nodeClassName: null,
    nodeBorderRadius: { default: 5 },
    nodeStrokeWidth: { default: 2 },
    maskColor: { default: "rgb(240, 242, 243, 0.7)" },
    width: null,
    height: null
  },
  emits: ["nodeClick", "nodeDblclick", "nodeMouseenter", "nodeMousemove", "nodeMouseleave"],
  setup(__props, { emit }) {
    const attrs = useAttrs();
    const window2 = useWindow();
    const defaultWidth = 200;
    const defaultHeight = 150;
    const __$temp_1 = useVueFlow(), edges = toRef(__$temp_1, "edges"), viewport = toRef(__$temp_1, "viewport"), dimensions = toRef(__$temp_1, "dimensions"), emits = toRef(__$temp_1, "emits"), getNodes = toRef(__$temp_1, "getNodes");
    const elementWidth = computed(() => {
      var _a2, _b, _c;
      return (_c = (_b = __props.width) != null ? _b : (_a2 = attrs.style) == null ? void 0 : _a2.width) != null ? _c : defaultWidth;
    });
    const elementHeight = computed(() => {
      var _a2, _b, _c;
      return (_c = (_b = __props.height) != null ? _b : (_a2 = attrs.style) == null ? void 0 : _a2.height) != null ? _c : defaultHeight;
    });
    const nodeColorFunc = __props.nodeColor instanceof Function ? __props.nodeColor : () => __props.nodeColor;
    const nodeStrokeColorFunc = __props.nodeStrokeColor instanceof Function ? __props.nodeStrokeColor : () => __props.nodeStrokeColor;
    const nodeClassNameFunc = __props.nodeClassName instanceof Function ? __props.nodeClassName : () => __props.nodeClassName;
    const shapeRendering = typeof window2 === "undefined" || !!window2.chrome ? "crispEdges" : "geometricPrecision";
    const bb = computed(() => {
      return getRectOfNodes(getNodes.value);
    });
    const viewBB = computed(() => ({
      x: -viewport.value.x / viewport.value.zoom,
      y: -viewport.value.y / viewport.value.zoom,
      width: dimensions.value.width / viewport.value.zoom,
      height: dimensions.value.height / viewport.value.zoom
    }));
    const viewBox = computedWithControl(viewBB, () => {
      const boundingRect = getNodes.value && getNodes.value.length ? getBoundsofRects(bb.value, viewBB.value) : viewBB.value;
      const scaledWidth = boundingRect.width / elementWidth.value;
      const scaledHeight = boundingRect.height / elementHeight.value;
      const viewScale = Math.max(scaledWidth, scaledHeight);
      const viewWidth = viewScale * elementWidth.value;
      const viewHeight = viewScale * elementHeight.value;
      const offset = 5 * viewScale;
      return {
        offset,
        x: boundingRect.x - (viewWidth - boundingRect.width) / 2 - offset,
        y: boundingRect.y - (viewHeight - boundingRect.height) / 2 - offset,
        width: viewWidth + offset * 2,
        height: viewHeight + offset * 2
      };
    });
    const d = computedWithControl(viewBox, () => {
      if (viewBox.value.x && viewBox.value.y) {
        return `
    M${viewBox.value.x - viewBox.value.offset},${viewBox.value.y - viewBox.value.offset}
    h${viewBox.value.width + viewBox.value.offset * 2}
    v${viewBox.value.height + viewBox.value.offset * 2}
    h${-viewBox.value.width - viewBox.value.offset * 2}z
    M${viewBB.value.x},${viewBB.value.y}
    h${viewBB.value.width}
    v${viewBB.value.height}
    h${-viewBB.value.width}z`;
      } else {
        return "";
      }
    });
    const onNodeClick = (event, node) => {
      const param = { event, node, connectedEdges: getConnectedEdges([node], edges.value) };
      emits.value.miniMapNodeClick(param);
      emit("nodeClick", param);
    };
    const onNodeDblClick = (event, node) => {
      const param = { event, node, connectedEdges: getConnectedEdges([node], edges.value) };
      emits.value.miniMapNodeDoubleClick(param);
      emit("nodeDblclick", param);
    };
    const onNodeMouseEnter = (event, node) => {
      const param = { event, node, connectedEdges: getConnectedEdges([node], edges.value) };
      emits.value.miniMapNodeMouseEnter(param);
      emit("nodeMouseenter", param);
    };
    const onNodeMouseMove = (event, node) => {
      const param = { event, node, connectedEdges: getConnectedEdges([node], edges.value) };
      emits.value.miniMapNodeMouseMove(param);
      emit("nodeMousemove", param);
    };
    const onNodeMouseLeave = (event, node) => {
      const param = { event, node, connectedEdges: getConnectedEdges([node], edges.value) };
      emits.value.miniMapNodeMouseLeave(param);
      emit("nodeMouseleave", param);
    };
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("svg", {
        width: elementWidth.value,
        height: elementHeight.value,
        viewBox: [viewBox.value.x, viewBox.value.y, viewBox.value.width, viewBox.value.height].join(" "),
        class: "vue-flow__minimap"
      }, [
        (openBlock(true), createElementBlock(Fragment, null, renderList(getNodes.value, (node) => {
          return openBlock(), createBlock(unref(MiniMapNode), {
            id: node.id,
            key: node.id,
            position: node.computedPosition,
            dimensions: node.dimensions,
            style: normalizeStyle(node.style),
            class: normalizeClass(unref(nodeClassNameFunc)(node)),
            color: unref(nodeColorFunc)(node),
            "border-radius": __props.nodeBorderRadius,
            "stroke-color": unref(nodeStrokeColorFunc)(node),
            "stroke-width": __props.nodeStrokeWidth,
            "shape-rendering": unref(shapeRendering),
            onClick: ($event) => onNodeClick($event, node),
            onDblclick: ($event) => onNodeDblClick($event, node),
            onMouseenter: ($event) => onNodeMouseEnter($event, node),
            onMousemove: ($event) => onNodeMouseMove($event, node),
            onMouseleave: ($event) => onNodeMouseLeave($event, node)
          }, {
            default: withCtx(() => [
              renderSlot(_ctx.$slots, `node-${node.type}`, {
                id: node.id,
                parentNode: node.parentNode,
                selected: node.selected,
                position: node.computedPosition,
                dimensions: node.dimensions,
                style: normalizeStyle(node.style),
                class: normalizeClass(unref(nodeClassNameFunc)(node)),
                color: unref(nodeColorFunc)(node),
                borderRadius: __props.nodeBorderRadius,
                strokeColor: unref(nodeStrokeColorFunc)(node),
                strokeWidth: __props.nodeStrokeWidth,
                shapeRendering: unref(shapeRendering)
              })
            ]),
            _: 2
          }, 1032, ["id", "position", "dimensions", "style", "class", "color", "border-radius", "stroke-color", "stroke-width", "shape-rendering", "onClick", "onDblclick", "onMouseenter", "onMousemove", "onMouseleave"]);
        }), 128)),
        createElementVNode("path", {
          class: "vue-flow__minimap-mask",
          d: unref(d),
          fill: __props.maskColor,
          "fill-rule": "evenodd"
        }, null, 8, _hoisted_2$6)
      ], 8, _hoisted_1$8);
    };
  }
});
var _export_sfc = (sfc, props) => {
  const target = sfc.__vccOpts || sfc;
  for (const [key, val] of props) {
    target[key] = val;
  }
  return target;
};
const _sfc_main$2 = {
  name: "ControlButton"
};
const _hoisted_1$7 = { class: "vue-flow__controls-button" };
function _sfc_render(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("button", _hoisted_1$7, [
    renderSlot(_ctx.$slots, "default")
  ]);
}
var ControlButton = /* @__PURE__ */ _export_sfc(_sfc_main$2, [["render", _sfc_render]]);
const _hoisted_1$6 = {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 32 32"
};
const _hoisted_2$5 = /* @__PURE__ */ createElementVNode("path", { d: "M32 18.133H18.133V32h-4.266V18.133H0v-4.266h13.867V0h4.266v13.867H32z" }, null, -1);
const _hoisted_3$5 = [
  _hoisted_2$5
];
function render$4(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$6, _hoisted_3$5);
}
var PlusIcon = { render: render$4 };
const _hoisted_1$5 = {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 32 5"
};
const _hoisted_2$4 = /* @__PURE__ */ createElementVNode("path", { d: "M0 0h32v4.2H0z" }, null, -1);
const _hoisted_3$4 = [
  _hoisted_2$4
];
function render$3(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$5, _hoisted_3$4);
}
var MinusIcon = { render: render$3 };
const _hoisted_1$4 = {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 32 30"
};
const _hoisted_2$3 = /* @__PURE__ */ createElementVNode("path", { d: "M3.692 4.63c0-.53.4-.938.939-.938h5.215V0H4.708C2.13 0 0 2.054 0 4.63v5.216h3.692V4.631zM27.354 0h-5.2v3.692h5.17c.53 0 .984.4.984.939v5.215H32V4.631A4.624 4.624 0 0 0 27.354 0zm.954 24.83c0 .532-.4.94-.939.94h-5.215v3.768h5.215c2.577 0 4.631-2.13 4.631-4.707v-5.139h-3.692v5.139zm-23.677.94a.919.919 0 0 1-.939-.94v-5.138H0v5.139c0 2.577 2.13 4.707 4.708 4.707h5.138V25.77H4.631z" }, null, -1);
const _hoisted_3$3 = [
  _hoisted_2$3
];
function render$2(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$4, _hoisted_3$3);
}
var FitView = { render: render$2 };
const _hoisted_1$3 = {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 25 32"
};
const _hoisted_2$2 = /* @__PURE__ */ createElementVNode("path", { d: "M21.333 10.667H19.81V7.619C19.81 3.429 16.38 0 12.19 0 8 0 4.571 3.429 4.571 7.619v3.048H3.048A3.056 3.056 0 0 0 0 13.714v15.238A3.056 3.056 0 0 0 3.048 32h18.285a3.056 3.056 0 0 0 3.048-3.048V13.714a3.056 3.056 0 0 0-3.048-3.047zM12.19 24.533a3.056 3.056 0 0 1-3.047-3.047 3.056 3.056 0 0 1 3.047-3.048 3.056 3.056 0 0 1 3.048 3.048 3.056 3.056 0 0 1-3.048 3.047zm4.724-13.866H7.467V7.619c0-2.59 2.133-4.724 4.723-4.724 2.591 0 4.724 2.133 4.724 4.724v3.048z" }, null, -1);
const _hoisted_3$2 = [
  _hoisted_2$2
];
function render$1(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$3, _hoisted_3$2);
}
var Lock = { render: render$1 };
const _hoisted_1$2 = {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 25 32"
};
const _hoisted_2$1 = /* @__PURE__ */ createElementVNode("path", { d: "M21.333 10.667H19.81V7.619C19.81 3.429 16.38 0 12.19 0c-4.114 1.828-1.37 2.133.305 2.438 1.676.305 4.42 2.59 4.42 5.181v3.048H3.047A3.056 3.056 0 0 0 0 13.714v15.238A3.056 3.056 0 0 0 3.048 32h18.285a3.056 3.056 0 0 0 3.048-3.048V13.714a3.056 3.056 0 0 0-3.048-3.047zM12.19 24.533a3.056 3.056 0 0 1-3.047-3.047 3.056 3.056 0 0 1 3.047-3.048 3.056 3.056 0 0 1 3.048 3.048 3.056 3.056 0 0 1-3.048 3.047z" }, null, -1);
const _hoisted_3$1 = [
  _hoisted_2$1
];
function render(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$2, _hoisted_3$1);
}
var Unlock = { render };
const _hoisted_1$1 = { class: "vue-flow__controls" };
const __default__$1 = {
  name: "Controls"
};
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  ...__default__$1,
  props: {
    showZoom: { type: Boolean, default: true },
    showFitView: { type: Boolean, default: true },
    showInteractive: { type: Boolean, default: true },
    fitViewParams: null
  },
  emits: ["zoomIn", "zoomOut", "fitView", "interactionChange"],
  setup(__props, { emit }) {
    const __$temp_1 = useVueFlow(), nodesDraggable = toRef(__$temp_1, "nodesDraggable"), nodesConnectable = toRef(__$temp_1, "nodesConnectable"), elementsSelectable = toRef(__$temp_1, "elementsSelectable"), setInteractive = toRef(__$temp_1, "setInteractive"), zoomIn = toRef(__$temp_1, "zoomIn"), zoomOut = toRef(__$temp_1, "zoomOut"), fitView = toRef(__$temp_1, "fitView");
    const isInteractive = computed(() => nodesDraggable.value && nodesConnectable.value && elementsSelectable.value);
    const onZoomInHandler = () => {
      zoomIn.value();
      emit("zoomIn");
    };
    const onZoomOutHandler = () => {
      zoomOut.value();
      emit("zoomOut");
    };
    const onFitViewHandler = () => {
      fitView.value(__props.fitViewParams);
      emit("fitView");
    };
    const onInteractiveChangeHandler = () => {
      setInteractive.value(!isInteractive.value);
      emit("interactionChange", !isInteractive.value);
    };
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", _hoisted_1$1, [
        renderSlot(_ctx.$slots, "top"),
        __props.showZoom ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
          renderSlot(_ctx.$slots, "control-zoom-in", {}, () => [
            createVNode(ControlButton, {
              class: "vue-flow__controls-zoomin",
              onClick: onZoomInHandler
            }, {
              default: withCtx(() => [
                renderSlot(_ctx.$slots, "icon-zoom-in", {}, () => [
                  createVNode(unref(PlusIcon))
                ])
              ]),
              _: 3
            })
          ]),
          renderSlot(_ctx.$slots, "control-zoom-out", {}, () => [
            createVNode(ControlButton, {
              class: "vue-flow__controls-zoomout",
              onClick: onZoomOutHandler
            }, {
              default: withCtx(() => [
                renderSlot(_ctx.$slots, "icon-zoom-out", {}, () => [
                  createVNode(unref(MinusIcon))
                ])
              ]),
              _: 3
            })
          ])
        ], 64)) : createCommentVNode("", true),
        __props.showFitView ? renderSlot(_ctx.$slots, "control-fit-view", { key: 1 }, () => [
          createVNode(ControlButton, {
            class: "vue-flow__controls-fitview",
            onClick: onFitViewHandler
          }, {
            default: withCtx(() => [
              renderSlot(_ctx.$slots, "icon-fit-view", {}, () => [
                createVNode(unref(FitView))
              ])
            ]),
            _: 3
          })
        ]) : createCommentVNode("", true),
        __props.showInteractive ? renderSlot(_ctx.$slots, "control-interactive", { key: 2 }, () => [
          __props.showInteractive ? (openBlock(), createBlock(ControlButton, {
            key: 0,
            class: "vue-flow__controls-interactive",
            onClick: onInteractiveChangeHandler
          }, {
            default: withCtx(() => [
              unref(isInteractive) ? renderSlot(_ctx.$slots, "icon-unlock", { key: 0 }, () => [
                createVNode(unref(Unlock))
              ]) : createCommentVNode("", true),
              !unref(isInteractive) ? renderSlot(_ctx.$slots, "icon-lock", { key: 1 }, () => [
                createVNode(unref(Lock))
              ]) : createCommentVNode("", true)
            ]),
            _: 3
          })) : createCommentVNode("", true)
        ]) : createCommentVNode("", true),
        renderSlot(_ctx.$slots, "default")
      ]);
    };
  }
});
const _hoisted_1 = ["x", "y", "width", "height"];
const _hoisted_2 = ["stroke", "stroke-width", "d"];
const _hoisted_3 = ["cx", "cy", "r", "fill"];
const _hoisted_4 = {
  key: 2,
  height: "100",
  width: "100"
};
const _hoisted_5 = ["fill"];
const _hoisted_6 = ["x", "y", "fill"];
const __default__ = {
  name: "Background"
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...__default__,
  props: {
    variant: { default: () => "dots" },
    gap: { default: 10 },
    size: { default: 0.4 },
    patternColor: null,
    bgColor: null,
    height: { default: 100 },
    width: { default: 100 },
    x: { default: 0 },
    y: { default: 0 }
  },
  setup(__props) {
    const defaultColors = {
      ["dots"]: "#81818a",
      ["lines"]: "#eee"
    };
    const __$temp_1 = useVueFlow(), viewport = toRef(__$temp_1, "viewport");
    const background = computed(() => {
      const scaledGap = __props.gap && __props.gap * viewport.value.zoom;
      const xOffset = scaledGap && viewport.value.x % scaledGap;
      const yOffset = scaledGap && viewport.value.y % scaledGap;
      const bgSize = __props.size * viewport.value.zoom;
      return {
        scaledGap,
        xOffset,
        yOffset,
        size: bgSize
      };
    });
    const patternId = `pattern-${Math.floor(Math.random() * 1e5)}`;
    const patternColor = computed(() => __props.patternColor || defaultColors[__props.variant || "dots"]);
    const d = computed(
      () => `M${background.value.scaledGap / 2} 0 V${background.value.scaledGap} M0 ${background.value.scaledGap / 2} H${background.value.scaledGap}`
    );
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("svg", {
        class: "vue-flow__background",
        style: normalizeStyle({
          height: `${__props.height > 100 ? 100 : __props.height}%`,
          width: `${__props.width > 100 ? 100 : __props.width}%`
        })
      }, [
        renderSlot(_ctx.$slots, "pattern-container", { id: patternId }, () => [
          createElementVNode("pattern", {
            id: patternId,
            x: background.value.xOffset,
            y: background.value.yOffset,
            width: background.value.scaledGap,
            height: background.value.scaledGap,
            patternUnits: "userSpaceOnUse"
          }, [
            renderSlot(_ctx.$slots, "pattern", {}, () => [
              __props.variant === "lines" ? (openBlock(), createElementBlock("path", {
                key: 0,
                stroke: unref(patternColor),
                "stroke-width": __props.size,
                d: unref(d)
              }, null, 8, _hoisted_2)) : __props.variant === "dots" ? (openBlock(), createElementBlock("circle", {
                key: 1,
                cx: background.value.size,
                cy: background.value.size,
                r: background.value.size,
                fill: unref(patternColor)
              }, null, 8, _hoisted_3)) : createCommentVNode("", true),
              __props.bgColor ? (openBlock(), createElementBlock("svg", _hoisted_4, [
                createElementVNode("rect", {
                  width: "100%",
                  height: "100%",
                  fill: __props.bgColor
                }, null, 8, _hoisted_5)
              ])) : createCommentVNode("", true)
            ])
          ], 8, _hoisted_1)
        ]),
        createElementVNode("rect", {
          x: __props.x,
          y: __props.y,
          width: "100%",
          height: "100%",
          fill: `url(#${patternId})`
        }, null, 8, _hoisted_6),
        renderSlot(_ctx.$slots, "default", { id: patternId })
      ], 4);
    };
  }
});
export { _sfc_main as Background, BackgroundVariant, BaseEdge, BezierEdge, ConnectionLineType, ConnectionMode, ControlButton, _sfc_main$1 as Controls, _sfc_main$g as EdgeText, Storage as GlobalVueFlowStorage, _sfc_main$i as Handle, MarkerType, _sfc_main$3 as MiniMap, MiniMapNode, NodeId as NodeIdInjection, PanOnScrollMode, Position, SimpleBezierEdge, SmoothStepEdge, StepEdge, StraightEdge, _sfc_main$4 as VueFlow, VueFlow as VueFlowInjection, addEdge, applyChanges, applyEdgeChanges, applyNodeChanges, defaultEdgeTypes, defaultNodeTypes, getBezierCenter, getBezierPath, getConnectedEdges, getCenter as getEdgeCenter, getIncomers, getMarkerId, getNodesInside, getOutgoers, getRectOfNodes, getSimpleBezierCenter, getSimpleBezierPath, getSmoothStepPath, getTransformForBounds, graphPosToZoomedPos, isEdge, isNode, updateEdge, useHandle, useVueFlow, useZoomPanHelper };
