import type {
  Edge,
  EdgeAddChange,
  EdgeChange,
  EdgeRemoveChange,
  EdgeSelectionChange,
  ElementChange,
  FlowElement,
  FlowElements,
  GraphEdge,
  GraphNode,
  Node,
  NodeAddChange,
  NodeChange,
  NodeRemoveChange,
  NodeSelectionChange,
} from '../types'
export declare const applyChanges: <
  T extends Node<any, any> | Edge<any, any> | FlowElement<any> = Node<any, any>,
  C extends ElementChange = T extends GraphNode<any, any> ? NodeChange : EdgeChange,
>(
  changes: C[],
  elements: T[],
) => T[]
export declare const applyEdgeChanges: (changes: EdgeChange[], edges: GraphEdge[]) => GraphEdge<any, any>[]
export declare const applyNodeChanges: (changes: NodeChange[], nodes: GraphNode[]) => GraphNode<any, any>[]
export declare const createSelectionChange: (id: string, selected: boolean) => NodeSelectionChange | EdgeSelectionChange
export declare const createAdditionChange: <
  T extends GraphNode<any, any> | GraphEdge<any, any> = GraphNode<any, any>,
  C extends EdgeAddChange<any> | NodeAddChange<any> = T extends GraphNode<any, any> ? NodeAddChange<any> : EdgeAddChange<any>,
>(
  item: T,
) => C
export declare const createRemoveChange: (id: string) => NodeRemoveChange | EdgeRemoveChange
export declare const getSelectionChanges: (items: FlowElements<any>, selectedIds: string[]) => NodeSelectionChange[]
