import type { EdgePositions, Getters, GraphEdge, GraphNode, HandleElement, Rect, Viewport, XYPosition } from '../types'
import type { Position } from '../types'
export declare const getHandlePosition: (position: Position, rect: Rect, handle?: HandleElement) => XYPosition
export declare const getHandle: (bounds?: HandleElement[], handleId?: string | null) => HandleElement | undefined
export declare const getEdgePositions: (
  sourceNode: GraphNode,
  sourceHandle: HandleElement | undefined,
  sourcePosition: Position,
  targetNode: GraphNode,
  targetHandle: HandleElement | undefined,
  targetPosition: Position,
) => EdgePositions
interface IsEdgeVisibleParams {
  sourcePos: XYPosition
  targetPos: XYPosition
  sourceWidth: number
  sourceHeight: number
  targetWidth: number
  targetHeight: number
  width: number
  height: number
  viewport: Viewport
}
export declare function isEdgeVisible({
  sourcePos,
  targetPos,
  sourceWidth,
  sourceHeight,
  targetWidth,
  targetHeight,
  width,
  height,
  viewport,
}: IsEdgeVisibleParams): boolean
export declare const groupEdgesByZLevel: (
  edges: GraphEdge[],
  getNode: Getters['getNode'],
) => {
  edges: GraphEdge<any, any>[]
  level: number
  isMaxLevel: boolean
}[]
export {}
