import type {
  Box,
  Connection,
  CoordinateExtent,
  DefaultEdgeOptions,
  Dimensions,
  Edge,
  EdgeMarkerType,
  Elements,
  FlowElement,
  Getters,
  GraphEdge,
  GraphNode,
  Node,
  Rect,
  Viewport,
  XYPosition,
  XYZPosition,
} from '../types'
export declare const getDimensions: (node: HTMLElement) => Dimensions
export declare const clamp: (val: number, min?: number, max?: number) => number
export declare const clampPosition: (position: XYPosition, extent: CoordinateExtent) => XYPosition
export declare const getHostForElement: (element: HTMLElement) => Document
declare type MaybeElement = Node | Edge | Connection | FlowElement
export declare const isEdge: (element: MaybeElement) => element is Edge<any, any>
export declare const isGraphEdge: (element: MaybeElement) => element is GraphEdge<any, any>
export declare const isNode: (element: MaybeElement) => element is Node<any, any>
export declare const isGraphNode: (element: MaybeElement) => element is GraphNode<any, any>
export declare const parseNode: (node: Node, nodeExtent: CoordinateExtent, defaults?: Partial<GraphNode>) => GraphNode
export declare const parseEdge: (edge: Edge, defaults?: Partial<GraphEdge>) => GraphEdge
export declare const getOutgoers: (node: GraphNode, elements: Elements<any>) => import('../types').Element<any>[]
export declare const getIncomers: (node: GraphNode, elements: Elements<any>) => import('../types').Element<any>[]
export declare const getEdgeId: ({ source, sourceHandle, target, targetHandle }: Connection) => string
export declare const connectionExists: (edge: Edge | Connection, elements: Elements<any>) => boolean
/**
 * Intended for options API
 * In composition API you can access utilities from `useVueFlow`
 */
export declare const addEdge: (
  edgeParams: Edge | Connection,
  elements: Elements<any>,
  defaults?: DefaultEdgeOptions,
) => Elements<any>
/**
 * Intended for options API
 * In composition API you can access utilities from `useVueFlow`
 */
export declare const updateEdge: (oldEdge: Edge, newConnection: Connection, elements: Elements<any>) => Elements<any>
export declare const pointToRendererPoint: (
  { x, y }: XYPosition,
  { x: tx, y: ty, zoom: tScale }: Viewport,
  snapToGrid: boolean,
  [snapX, snapY]: [number, number],
) => XYPosition
export declare const rectToBox: ({ x, y, width, height }: Rect) => Box
export declare const boxToRect: ({ x, y, x2, y2 }: Box) => Rect
export declare const getBoundsofRects: (rect1: Rect, rect2: Rect) => Rect
export declare const getRectOfNodes: (nodes: GraphNode[]) => Rect
export declare const graphPosToZoomedPos: ({ x, y }: XYPosition, { x: tx, y: ty, zoom: tScale }: Viewport) => XYPosition
export declare const getNodesInside: (
  nodes: GraphNode[],
  rect: Rect,
  { x: tx, y: ty, zoom: tScale }?: Viewport,
  partially?: boolean,
) => GraphNode<any, any>[]
export declare const getConnectedEdges: (nodes: GraphNode[], edges: GraphEdge[]) => GraphEdge<any, any>[]
export declare const getTransformForBounds: (
  bounds: Rect,
  width: number,
  height: number,
  minZoom: number,
  maxZoom: number,
  padding?: number,
  offset?: {
    x?: number
    y?: number
  },
) => Viewport
export declare const getXYZPos: (parentPos: XYZPosition, computedPosition: XYZPosition) => XYZPosition
export declare const isParentSelected: (node: GraphNode, getNode: Getters['getNode']) => boolean
export declare const getMarkerId: (marker: EdgeMarkerType | undefined) => string
export {}
