from . import widget
from browser import html, document

class Dialog(html.DIV, widget.DraggableWidget):

    def __init__(self, title):
      html.DIV.__init__(self,
         Class="ui-dialog ui-widget ui-widget-content ui-corner-all ui-front ui-draggable ui-resizable",
         style={'position': 'absolute', 'height': 'auto', 'width': '300px',
                'top': '98px', 'left': '140px', 'display': 'block', 'zIndex':0})

      widget.DraggableWidget.__init__(self, self, 'dialog', id)

      titlebar = html.DIV(Id="titlebar", Class="ui-dialog-titlebar")

      self._title = html.DIV(title, Class="ui-dialog-title")
        
      titlebar <= self._title

      title_button = html.BUTTON('X', Title="close", Class="ui-close-button")

      def dialog_close(e):
          #del document[self._div_shell.id]
          document.remove(self)

      title_button.bind('click', dialog_close)

      titlebar <= title_button

      self.body=html.DIV(Class="ui-dialog-body",
           style={'width': 'auto', 'min-height': '105px', 
                  'max-height': 'none', 'height': 'auto'})

      self <= titlebar
      self <= self.body

      for _i in ['n', 'e', 's', 'w', 'se', 'sw', 'ne', 'nw']:
          if _i == 'se':
             _class="ui-resizable-handle ui-resizable-%s ui-icon ui-icon-gripsmall-diagonal-%s" % (_i, _i)
          else:
             _class="ui-resizable-handle ui-resizable-%s" % _i

          self <= html.DIV(Class=_class, style={'z-index': '90'})

      self.footer = html.DIV(Class='ui-footer')
      self <= self.footer

    def add_ok_cancel(self, ok=None, cancel=None):
        """Add Ok and Cancel buttons
        ok is the callback function if user clicks "Ok". It is a function that
        takes the Dialog instance as single argument. Same for cancel
        """
        self.ok = ok
        self.cancel = cancel

        self.footer.style.height = '1.5em'
        left = html.DIV(style=dict(width="50%"),Class='ui-footer-ok')
        right = html.DIV(style=dict(width="50%"), Class='ui-footer-cancel')
        self.footer <= left+right
        
        ok_button = html.BUTTON('Ok', Class="ui-footer-button")
        if ok is None:
            ok_button.bind('click', lambda ev: self.close())
        else:
            ok_button.bind('click', lambda ev: self.callback(ok))
        left <= ok_button

        cancel_button = html.BUTTON('Annuler', Class="ui-footer-button")
        if cancel is None:
            cancel_button.bind('click', lambda ev: self.close())
        else:
            cancel_button.bind('click', lambda ev: self.callback(cancel))
        right <= cancel_button

    def close(self):
        print('close', self)
        self.parent.remove(self)

    def callback(self, func):
        func(self)

class EntryDialog(Dialog):

    def __init__(self, title, prompt, callback):
        Dialog.__init__(self, title)

        d_prompt = html.DIV(prompt, Class="ui-widget", 
            style=dict(float="left",paddingRight="10px"))
        self.entry = html.INPUT()
        self.body <= html.DIV(d_prompt+self.entry,
            style={'padding':'15px'})
        self.entry.focus()
        self.entry.bind('keydown', self.keydown)
        self.add_ok_cancel(ok=callback)
        self.callback = callback
    
    def keydown(self, ev):
        ev.stopPropagation()

class SelectDialog(Dialog):

    def __init__(self, title, prompt, options, action, _id=None):
        Dialog.__init__(self, _id)
        self.set_title(title)
        self.options = options
        self.action = action
        d_prompt = html.DIV(prompt, Class="ui-widget", 
            style=dict(float="left",paddingRight="10px"))
        self.select = html.SELECT()
        for option in options:
            self.select <= html.OPTION(option)
        body = html.DIV(d_prompt+self.select,
            style={'padding':'15px'})
        b_ok = html.BUTTON("Ok")
        b_ok.bind('click', self.ok)
        b_cancel = html.BUTTON("Cancel")
        b_cancel.bind('click', self.cancel)
        body += html.DIV(b_ok+b_cancel, style={'padding':'15px'})
        self._div_dialog <= body
    
    def ok(self, ev):
        ix = self._div_shell.get(selector='SELECT')[0].selectedIndex
        document.remove(self._div_shell)
        self.action(self.options[ix])

    def cancel(self, ev):
        document.remove(self._div_shell)

class YesNoDialog(Dialog):

    def __init__(self, title, prompt, action_if_yes, action_if_no, _id=None):
        Dialog.__init__(self, _id)
        self.set_title(title)
        
        self.action_if_yes = action_if_yes
        self.action_if_no = action_if_no
        
        d_prompt = html.DIV(prompt, Class="ui-widget", 
            style=dict(float="left",paddingRight="10px"))
        body = html.DIV(d_prompt, style={'padding':'15px'})
        b_ok = html.BUTTON("Yes")
        b_ok.bind('click', self.yes)
        b_cancel = html.BUTTON("No")
        b_cancel.bind('click', self.no)
        body += html.DIV(b_ok+b_cancel, style={'padding':'15px'})
        self._div_dialog <= body
    
    def yes(self, ev):
        document.remove(self._div_shell)
        self.action_if_yes(self)

    def no(self, ev):
        document.remove(self._div_shell)
        if self.action_if_no is not None:
            self.action_if_no(self)
