__BRYTHON__.use_VFS = true;
__BRYTHON__.VFS={"array": [".js", "var $module = (function($B){\n\nvar _b_ = $B.builtins,\n    $s = [],\n    i\nfor(var $b in _b_){$s.push('var ' + $b +' = _b_[\"'+$b+'\"]')}\neval($s.join(';'))\n\nvar typecodes = {\n    'b': Int8Array,    // signed char, 1 byte\n    'B': Uint8Array,   // unsigned char, 1\n    'u': null,         // Py_UNICODE Unicode character, 2 (deprecated)\n    'h': Int16Array,   // signed short, 2\n    'H': Uint16Array,  // unsigned short, 2\n    'i': Int16Array,   //  signed int, 2\n    'I': Uint16Array,  // unsigned int, 2\n    'l': Int32Array,   // signed long, 4\n    'L': Uint32Array,  // unsigned long, 4\n    'q': null,         // signed long, 8 (not implemented)\n    'Q': null,         // unsigned long, 8 (not implemented)\n    'f': Float32Array, // float, 4\n    'd': Float64Array  // double float, 8\n}\n\nvar array = $B.make_class(\"array\",\n    function(){\n        var missing = {},\n            $ = $B.args(\"array\", 2, {typecode: null, initializer: null},\n                [\"typecode\", \"initializer\"], arguments, {initializer: missing},\n                null, null),\n            typecode = $.typecode,\n            initializer = $.initializer\n        if(! typecodes.hasOwnProperty(typecode)){\n            throw _b_.ValueError.$factory(\"bad typecode (must be b, \" +\n                \"B, u, h, H, i, I, l, L, q, Q, f or d)\")\n        }\n        if(typecodes[typecode] === null){\n            throw _b_.NotImplementedError.$factory(\"type code \" +\n                typecode + \"is not implemented\")\n        }\n        var res = {\n            __class__: array,\n            typecode: typecode,\n            obj: null\n        }\n        if(initializer !== missing){\n            if(Array.isArray(initializer)){\n                array.fromlist(res, initializer)\n            }else if(_b_.isinstance(initializer, _b_.bytes)){\n                array.frombytes(res, initializer)\n            }else{\n                array.extend(res, initializer)\n            }\n        }\n        return res\n    }\n)\n\narray.$buffer_protocol = true\n\nvar array_iterator = $B.$iterator_class(\"array_iterator\")\n\narray.__getitem__ = function(self, key){\n    if(self.obj && self.obj[key] !== undefined){\n        return self.obj[key]\n    }\n    throw _b_.IndexError(\"array index out of range\")\n}\n\narray.__iter__ = function(self){\n    return $B.$iterator(self.obj, array_iterator)\n}\n\narray.__len__ = function(self){\n    return self.obj.length\n}\n\narray.__str__ = function(self){\n    $B.args(\"__str__\", 1, {self: null},\n        [\"self\"], arguments, {}, null, null)\n    var res = \"array('\" + self.typecode + \"'\"\n    if(self.obj !== null){\n        res += \", [\" + self.obj + \"]\"\n    }\n    return res + \")\"\n}\n\nfunction normalize_index(self, i){\n    // return an index i between 0 and self.obj.length - 1\n    if(i < 0){\n        i = self.obj.length + i\n    }\n    if(i < 0){i = 0}\n    else if(i > self.obj.length - 1){\n        i = self.obj.length\n    }\n    return i\n}\n\narray.append = function(self, value){\n    $B.args(\"append\", 2, {self: null, value: null},\n        [\"self\", \"value\"], arguments, {}, null, null)\n    var pos = self.obj === null ? 0 : self.obj.length\n    return array.insert(self, pos, value)\n}\n\narray.count = function(self, x){\n    $B.args(\"count\", 2, {self: null, x: null},\n        [\"self\", \"x\"], arguments, {}, null, null)\n    if(self.obj === null){return 0}\n    return self.obj.filter(function(item){return item == x}).length\n}\n\narray.extend = function(self, iterable){\n    $B.args(\"extend\", 2, {self: null, iterable: null},\n        [\"self\", \"iterable\"], arguments, {}, null, null)\n    if(iterable.__class__ === array){\n        if(iterable.typecode !== self.typecode){\n            throw _b_.TypeError.$factory(\"can only extend with array \" +\n                \"of same kind\")\n        }\n        if(iterable.obj === null){return _b_.None}\n        // create new object with length = sum of lengths\n        var newobj = new typecodes[self.typecode](self.obj.length +\n            iterable.obj.length)\n        // copy self.obj\n        newobj.set(self.obj)\n        // copy iterable.obj\n        newobj.set(iterable.obj, self.obj.length)\n        self.obj = newobj\n    }else{\n        var it = _b_.iter(iterable)\n        while(true){\n            try{\n                var item = _b_.next(it)\n                array.append(self, item)\n            }catch(err){\n                if(err.__class__ !== _b_.StopIteration){\n                    throw err\n                }\n                break\n            }\n        }\n    }\n    return _b_.None\n}\n\narray.frombytes = function(self, s){\n    $B.args(\"frombytes\", 2, {self: null, s: null},\n        [\"self\", \"s\"], arguments, {}, null, null)\n    if(! _b_.isinstance(s, _b_.bytes)){\n        throw _b_.TypeError.$factory(\"a bytes-like object is required, \" +\n            \"not '\" + $B.class_name(s) + \"'\")\n    }\n    self.obj = new typecodes[self.typecode](s.source)\n    return None\n}\n\narray.fromlist = function(self, list){\n    $B.args(\"fromlist\", 2, {self: null, list: null},\n        [\"self\", \"list\"], arguments, {}, null, null)\n    var it = _b_.iter(list)\n    while(true){\n        try{\n            var item = _b_.next(it)\n            try{\n                array.append(self, item)\n            }catch(err){\n                console.log(err)\n                return _b_.None\n            }\n        }catch(err){\n            if(err.__class__ === _b_.StopIteration){\n                return _b_.None\n            }\n            throw err\n        }\n    }\n}\n\narray.fromstring = array.frombytes\n\narray.index = function(self, x){\n    $B.args(\"index\", 2, {self: null, x: null},\n        [\"self\", \"x\"], arguments, {}, null, null)\n    var res = self.obj.findIndex(function(item){return x == item})\n    if(res == -1){\n        throw _b_.ValueError.$factory(\"array.index(x): x not in array\")\n    }\n    return res\n}\n\narray.insert = function(self, i, value){\n    $B.args(\"insert\", 3, {self: null, i: null, value: null},\n        [\"self\", \"i\", \"value\"], arguments, {}, null, null)\n    if(self.obj === null){\n        self.obj = [value]\n    }else{\n        self.obj.splice(i, 0, value)\n    }\n    return _b_.None\n}\n\narray.itemsize = function(self){\n    return typecodes[self.typecode].BYTES_PER_ELEMENT\n}\n\narray.pop = function(self, i){\n    var $ = $B.args(\"count\", 2, {self: null, i: null},\n        [\"self\", \"i\"], arguments, {i: -1}, null, null)\n    i = $.i\n    if(self.obj === null){\n        throw _b_.IndexError.$factory(\"pop from empty array\")\n    }else if(self.obj.length == 1){\n        var res = self.obj[0]\n        self.obj = null\n        return res\n    }\n    i = normalize_index(self, i)\n    // store value to return\n    var res = self.obj[i]\n    // create new array, size = previous size - 1\n    var newobj = new typecodes[self.typecode](self.obj.length - 1)\n    // fill new array with values until i excluded\n    newobj.set(self.obj.slice(0, i))\n    // fill with values after i\n    newobj.set(self.obj.slice(i + 1), i)\n    // set self.obj to new array\n    self.obj = newobj\n    // return stored value\n    return res\n}\n\narray.remove = function(self, x){\n    $B.args(\"remove\", 2, {self: null, x: null},\n        [\"self\", \"x\"], arguments, {}, null, null)\n    var res = self.obj.findIndex(function(item){return x == item})\n    if(res == -1){\n        throw _b_.ValueError.$factory(\"array.remove(x): x not in array\")\n    }\n    array.pop(self, res)\n    return _b_.None\n}\n\narray.reverse = function(self){\n    $B.args(\"reverse\", 1, {self: null},\n        [\"self\"], arguments, {}, null, null)\n    if(self.obj === null){return _b_.None}\n    self.obj.reverse()\n    return _b_.None\n}\n\narray.tobytes = function(self){\n    $B.args(\"tobytes\", 1, {self: null},\n        [\"self\"], arguments, {}, null, null)\n    var items = Array.slice.call(null, self.obj),\n        res = []\n    items.forEach(function(item){\n        while(item > 256){\n            res.push(item % 256)\n            item = Math.floor(item / 256)\n        }\n        res.push(item)\n    })\n    return _b_.bytes.$factory(res)\n}\n\narray.tolist = function(self){\n    $B.args(\"tolist\", 1, {self: null},\n        [\"self\"], arguments, {}, null, null)\n    return Array.slice.call(null, self.obj)\n}\n\narray.tostring = array.tobytes\n\narray.typecode = function(self){\n    return self.typecode\n}\n\n$B.set_func_names(array, \"array\")\n\nreturn {\n    array: array,\n    typecodes: Object.keys(typecodes).join('')\n}\n\n})(__BRYTHON__)\n"], "builtins": [".js", "var $module = (function(){\n    var obj = {\n        __class__: __BRYTHON__.module,\n        __name__: 'builtins'\n    },\n        builtin_names = ['ArithmeticError', 'AssertionError', 'AttributeError',\n    'BaseException', 'BlockingIOError', 'BrokenPipeError', 'BufferError',\n    'BytesWarning', 'ChildProcessError', 'ConnectionAbortedError',\n    'ConnectionError', 'ConnectionRefusedError', 'ConnectionResetError',\n    'DeprecationWarning', 'EOFError', 'Ellipsis', 'EnvironmentError', 'Exception',\n    'False', 'FileExistsError', 'FileNotFoundError', 'FloatingPointError',\n    'FutureWarning', 'GeneratorExit', 'IOError', 'ImportError', 'ImportWarning',\n    'IndentationError', 'IndexError', 'InterruptedError', 'IsADirectoryError',\n    'KeyError', 'KeyboardInterrupt', 'LookupError', 'MemoryError', 'NameError',\n    'None', 'NotADirectoryError', 'NotImplemented', 'NotImplementedError',\n    'OSError', 'OverflowError', 'PendingDeprecationWarning', 'PermissionError',\n    'ProcessLookupError', 'ReferenceError', 'ResourceWarning', 'RuntimeError',\n    'RuntimeWarning', 'StopIteration', 'SyntaxError', 'SyntaxWarning',\n    'SystemError', 'SystemExit', 'TabError', 'TimeoutError', 'True', 'TypeError',\n    'UnboundLocalError', 'UnicodeDecodeError', 'UnicodeEncodeError',\n    'UnicodeError', 'UnicodeTranslateError', 'UnicodeWarning', 'UserWarning',\n    'ValueError', 'Warning', 'WindowsError', 'ZeroDivisionError', '_',\n    '__build_class__', '__debug__', '__doc__', '__import__', '__name__',\n    '__package__', 'abs', 'all', 'any', 'ascii', 'bin', 'bool', 'bytearray',\n    'bytes','callable', 'chr', 'classmethod', 'compile', 'complex', 'copyright',\n    'credits','delattr', 'dict', 'dir', 'divmod', 'enumerate', 'eval', 'exec',\n    'exit', 'filter', 'float', 'format', 'frozenset', 'getattr', 'globals',\n    'hasattr', 'hash', 'help', 'hex', 'id', 'input', 'int', 'isinstance',\n    'issubclass', 'iter', 'len', 'license', 'list', 'locals', 'map', 'max',\n    'memoryview', 'min', 'next', 'object', 'oct', 'open', 'ord', 'pow', 'print',\n    'property', 'quit', 'range', 'repr', 'reversed', 'round', 'set', 'setattr',\n    'slice', 'sorted', 'staticmethod', 'str', 'sum', 'super', 'tuple', 'type',\n    'vars', 'zip',\n    '__newobj__' // defined in py_objects.js ; required for pickle\n    ]\n    for(var i = 0, len = builtin_names.length; i < len; i++){\n        try{eval(\"obj['\" + builtin_names[i] + \"'] = __BRYTHON__.builtins.\" +\n            builtin_names[i])}\n        catch(err){if (__BRYTHON__.$debug) {console.log(err)}}\n    }\n    return obj\n})()\n"], "dis": [".js", "var $module=(function($B){\n\nvar dict = $B.builtins.dict\nvar mod = {\n    dis:function(src){\n        $B.$py_module_path['__main__'] = $B.brython_path\n        return __BRYTHON__.py2js(src,'__main__','__main__',\n            $B.builtins_scope).to_js()\n    },\n    OPTIMIZED: 1,\n    NEWLOCALS: 2,\n    VARARGS: 4,\n    VARKEYWORDS: 8,\n    NESTED: 16,\n    GENERATOR: 32,\n    NOFREE: 64,\n    COROUTINE: 128,\n    ITERABLE_COROUTINE: 256,\n    ASYNC_GENERATOR: 512,\n    COMPILER_FLAG_NAMES: $B.builtins.dict.$factory()\n}\nmod.COMPILER_FLAG_NAMES = dict.$factory([\n     [1, \"OPTIMIZED\"],\n     [2, \"NEWLOCALS\"],\n     [4, \"VARARGS\"],\n     [8, \"VARKEYWORDS\"],\n    [16, \"NESTED\"],\n    [32, \"GENERATOR\"],\n    [64, \"NOFREE\"],\n   [128, \"COROUTINE\"],\n   [256, \"ITERABLE_COROUTINE\"],\n   [512, \"ASYNC_GENERATOR\"]\n])\n\nreturn mod\n\n})(__BRYTHON__)"], "hashlib": [".js", "var $module=(function($B){\n\nvar _b_ = $B.builtins\n\nvar $s = []\nfor(var $b in _b_){$s.push('var ' + $b +' = _b_[\"'+$b+'\"]')}\neval($s.join(';'))\n\nvar $mod = {\n\n    __getattr__ : function(attr){\n        if(attr == 'new'){return hash.$factory}\n        return this[attr]\n    },\n    md5: function(obj){return hash.$factory('md5', obj)},\n    sha1: function(obj){return hash.$factory('sha1', obj)},\n    sha224: function(obj){return hash.$factory('sha224', obj)},\n    sha256: function(obj){return hash.$factory('sha256', obj)},\n    sha384: function(obj){return hash.$factory('sha384', obj)},\n    sha512: function(obj){return hash.$factory('sha512', obj)},\n\n    algorithms_guaranteed: ['md5', 'sha1', 'sha224', 'sha256', 'sha384', 'sha512'],\n    algorithms_available:  ['md5', 'sha1', 'sha224', 'sha256', 'sha384', 'sha512']\n}\n\n//todo: eventually move this function to a \"utility\" file or use ajax module?\nfunction $get_CryptoJS_lib(alg){\n    if($B.VFS !== undefined){\n        // use file in brython_stdlib.js\n        var lib = $B.VFS[\"crypto_js.rollups.\" + alg]\n        if (lib===undefined){\n            throw _b_.ImportError.$factory(\"can't import hashlib.\" + alg)\n        }\n        var res = lib[1]\n        try{\n            eval(res + \"; $B.CryptoJS = CryptoJS;\")\n            return\n        }catch(err){\n            throw Error(\"JS Eval Error\",\n                \"Cannot eval CryptoJS algorithm '\" + alg + \"' : error:\" + err)\n        }\n    }\n\n    var module = {__name__: 'CryptoJS', $is_package: false}\n    var res = $B.$download_module(module, $B.brython_path + 'libs/crypto_js/rollups/' + alg + '.js');\n\n    try{\n        eval(res + \"; $B.CryptoJS = CryptoJS;\")\n    }catch(err){\n        throw Error(\"JS Eval Error\",\n            \"Cannot eval CryptoJS algorithm '\" + alg + \"' : error:\" + err)\n    }\n}\n\nfunction bytes2WordArray(obj){\n    // Transform a bytes object into an instance of class WordArray\n    // defined in CryptoJS\n    if(!_b_.isinstance(obj, _b_.bytes)){\n        throw _b_.TypeError(\"expected bytes, got \" + $B.class_name(obj))\n    }\n\n    var words = []\n    for(var i = 0; i < obj.source.length; i += 4){\n        var word = obj.source.slice(i, i + 4)\n        while(word.length < 4){word.push(0)}\n        var w = word[3] + (word[2] << 8) + (word[1] << 16) + (word[0] << 24)\n        words.push(w)\n    }\n    return {words: words, sigBytes: obj.source.length}\n}\n\nvar hash = {\n    __class__: _b_.type,\n    __mro__: [_b_.object],\n    $infos:{\n        __name__: 'hash'\n    }\n}\n\nhash.update = function(self, msg){\n    self.hash.update(bytes2WordArray(msg))\n}\n\nhash.copy = function(self){\n    return self.hash.clone()\n}\n\nhash.digest = function(self){\n    var obj = self.hash.clone().finalize().toString(),\n        res = []\n    for(var i = 0; i < obj.length; i += 2){\n        res.push(parseInt(obj.substr(i, 2), 16))\n    }\n    return _b_.bytes.$factory(res)\n}\n\nhash.hexdigest = function(self) {\n    return self.hash.clone().finalize().toString()\n}\n\nhash.$factory = function(alg, obj) {\n    var res = {\n        __class__: hash\n    }\n\n    switch(alg) {\n      case 'md5':\n      case 'sha1':\n      case 'sha224':\n      case 'sha256':\n      case 'sha384':\n      case 'sha512':\n        var ALG = alg.toUpperCase()\n        if($B.Crypto === undefined ||\n            $B.CryptoJS.algo[ALG] === undefined){$get_CryptoJS_lib(alg)}\n\n        res.hash = $B.CryptoJS.algo[ALG].create()\n        if(obj !== undefined){\n            res.hash.update(bytes2WordArray(obj))\n        }\n        break\n      default:\n        throw $B.builtins.AttributeError.$factory('Invalid hash algorithm: ' + alg)\n    }\n\n    return res\n}\n\nreturn $mod\n\n})(__BRYTHON__)\n"], "json": [".js", "var $module = (function($B){\n\nvar _b_ = $B.builtins\nfunction js2py(js){\n    switch(typeof js){\n        case \"object\":\n            if(js === null){\n                return _b_.None\n            }else if(Array.isArray(js)){\n                var res = _b_.list.$factory()\n                js.forEach(function(item){\n                    res.push(js2py(item))\n                })\n            }else{\n                var res = _b_.dict.$factory()\n                Object.keys(js).forEach(function(key){\n                    res.$string_dict[key] = js2py(js[key])\n                })\n            }\n            return res\n        default:\n            return js\n    }\n}\n\nreturn  {\n    loads : function(){\n        var $ = $B.args('loads', 1, {obj:null}, ['obj'], arguments, {},\n            null, null)\n        return js2py(JSON.parse($.obj))\n    },\n    load : function(){\n        var $ = $B.args('load', 1, {obj:null}, ['obj'], arguments, {},\n            null, null)\n        return $module.loads(obj.$content);\n    },\n    dumps : function(){\n        var $ = $B.args('dumps', 1, {obj:null}, ['obj'], arguments, {},\n            null, null)\n        return JSON.stringify($B.pyobj2jsobj($.obj))\n    }\n}\n\n})(__BRYTHON__)\n"], "long_int": [".js", "/*\nModule to manipulate long integers\n*/\n\nvar $module=(function($B){\n\neval($B.InjectBuiltins())\n\nvar $LongIntDict = {__class__:$B.$type,__name__:'LongInt'}\n\nfunction add_pos(v1, v2){\n    // Add two positive numbers\n    // v1, v2 : strings\n    // Return an instance of LongInt\n\n    var res = '', carry = 0, iself=v1.length, sv=0\n    for(var i=v2.length-1;i>=0;i--){\n        iself--\n        if(iself<0){sv=0}else{sv=parseInt(v1.charAt(iself))}\n        x = (carry+sv+parseInt(v2.charAt(i))).toString()\n        if(x.length==2){res=x.charAt(1)+res;carry=parseInt(x.charAt(0))}\n        else{res=x+res;carry=0}\n    }\n    while(iself>0){\n        iself--\n        x = (carry+parseInt(v1.charAt(iself))).toString()\n        if(x.length==2){res=x.charAt(1)+res;carry=parseInt(x.charAt(0))}\n        else{res=x+res;carry=0}\n    }\n    if(carry){res=carry+res}        \n    return {__class__:$LongIntDict, value:res, pos:true}\n}\n\nfunction check_shift(shift){\n    // Check the argument of >> and <<\n    if(!isinstance(shift, LongInt)){\n        throw TypeError(\"shift must be LongInt, not '\"+\n            $B.get_class(shift).__name__+\"'\")\n    }\n    if(!shift.pos){throw ValueError(\"negative shift count\")}\n}\n\nfunction clone(obj){\n    // Used for traces\n    var obj1 = {}\n    for(var attr in obj){obj1[attr]=obj[attr]}\n    return obj1\n}\n\nfunction comp_pos(v1, v2){\n    // Compare two positive numbers\n    if(v1.length>v2.length){return 1}\n    else if(v1.length<v2.length){return -1}\n    else{\n        if(v1>v2){return 1}\n        else if(v1<v2){return -1}\n    }\n    return 0\n}\n\nfunction divmod_pos(v1, v2){\n    // v1, v2 : strings, represent 2 positive integers A and B\n    // Return [a, b] where a and b are instances of LongInt\n    // a = A // B, b = A % B\n    var v1_init = v1, quotient, mod\n    if(comp_pos(v1, v2)==-1){ // a < b\n        quotient='0'\n        mod = LongInt(v1)\n    }else if(v2==v1){ // a = b\n        quotient = '1';\n        mod = LongInt('0')\n    }else{\n        var quotient = '', v1_init = v1\n        var left = v1.substr(0, v2.length)\n        if(v1<v2){left = v1.substr(0, v2.length+1)}\n        var right = v1.substr(left.length)\n        // mv2 maps integers i from 2 to 9 to i*v2, used as a cache to avoid\n        // having to compute i*v2 each time\n        var mv2 = {}\n        // Javascript \"safe integer\" with the 15 first digits in v2,\n        // used in the algorithm to test candidate values\n        var jsv2 = parseInt(v2.substr(0,15))\n\n        // Division algorithm\n        // At each step in the division, v1 is split into substrings\n        // \"left\" is the left part, with the same length as v2\n        // \"rest\" is the rest of v1 after \"left\"\n        // The algorithm finds the one-digit integer \"candidate\" such\n        // that 0 <= left - candidate*v2 < v2\n        // It stops when right is empty\n        while(true){\n            // Uses JS division to test an approximate result\n            var jsleft = parseInt(left.substr(0,15))\n            var candidate = Math.floor(jsleft/jsv2).toString()\n\n            // Check that candidate is the correct result\n            // Start by computing candidate*v2 : for this, use the table\n            // mv2, which stores the multiples of v2 already calculated\n            if(mv2[candidate]===undefined){\n                mv2[candidate] = mul_pos(v2, candidate).value\n            }\n            if(comp_pos(left, mv2[candidate])==-1){\n                // If left < candidate * v2, use candidate-1\n                candidate--\n                if(mv2[candidate]===undefined){\n                    mv2[candidate] = mul_pos(v2, candidate).value\n                }\n            }\n\n            // Add candidate to the quotient\n            quotient += candidate\n\n            // New value for left : left - v2*candidate\n            left = sub_pos(left, mv2[candidate]).value\n\n            // Stop if all digits in v1 have been used\n            if(right.length==0){break}\n\n            // Else, add next digit to left and remove it from right\n            left += right.charAt(0)\n            right = right.substr(1)\n        }\n        // Modulo is A - (A//B)*B\n        mod = sub_pos(v1, mul_pos(quotient, v2).value)\n    }\n    return [LongInt(quotient), mod]\n}\n\nfunction mul_pos(v1, v2){\n    // Multiply positive numbers v1 by v2\n    // Make v2 smaller than v1\n    if(v1.length<v2.length){var a=v1; v1=v2 ; v2=a}\n    if(v2=='0'){return LongInt('0')}\n    var cols = {}, i=v2.length, j\n    \n    // Built the object \"cols\", indexed by integers from 1 to nb1+nb2-2\n    // where nb1 and nb2 are the number of digits in v1 and v2.\n    // cols[n] is the sum of v1[i]*v2[j] for i+j = n\n    \n    while(i--){\n        var car = v2.charAt(i)\n        if(car==\"0\"){\n            j = v1.length\n            while(j--){\n                if(cols[i+j]===undefined){cols[i+j]=0}\n            }        \n        }else if(car==\"1\"){\n            j = v1.length\n            while(j--){\n                var z = parseInt(v1.charAt(j))\n                if(cols[i+j]===undefined){cols[i+j]=z}\n                else{cols[i+j] += z}\n            }\n        }else{\n            var x = parseInt(car), j = v1.length, y, z\n            while(j--){\n                y = x * parseInt(v1.charAt(j))\n                if(cols[i+j]===undefined){cols[i+j]=y}\n                else{cols[i+j] += y}\n            }\n        }\n    }\n\n    // Transform cols so that cols[x] is a one-digit integers\n    i = v1.length+v2.length-1\n    while(i--){\n        var col = cols[i].toString()\n        if(col.length>1){\n            // If the value in cols[i] has more than one digit, only keep the\n            // last one and report the others at the right index\n            // For instance if cols[i] = 123, keep 3 in cols[i], add 2 to\n            // cols[i-1] and 1 to cols[i-2]\n            cols[i] = parseInt(col.charAt(col.length-1))\n            j = col.length\n            while(j-->1){\n                var report = parseInt(col.charAt(j-1))\n                var pos = i-col.length+j\n                if(cols[pos]===undefined){cols[pos]=report}\n                else{cols[pos] += report}\n            }\n        }\n    }\n\n    // Find minimum index in cols\n    // The previous loop may have introduced negative indices\n    var imin\n    for(var attr in cols){\n        i = parseInt(attr)\n        if(imin===undefined){imin=i}\n        else if(i<imin){imin=i}\n    }\n\n    // Result is the concatenation of digits in cols\n    var res = ''\n    for(var i=imin;i<=v1.length+v2.length-2;i++){res+=cols[i].toString()}\n    return LongInt(res)\n}\n\nfunction sub_pos(v1, v2){\n    // Substraction of positive numbers with v1>=v2\n\n    var res = '', carry = 0, i1=v1.length, sv=0\n    \n    // For all digits in v2, starting by the rightmost, substract it from\n    // the matching digit in v1\n    // This is the equivalent of the manual operation :\n    //    12345678\n    //   -   98765\n    //\n    // We begin by the rightmost operation : 8-5 (3, no carry),\n    // then 7-6 (1, no carry)\n    // then 6-7 (9, carry 1) and so on\n    for(var i=v2.length-1;i>=0;i--){\n        i1--\n        sv = parseInt(v1.charAt(i1))\n        x = (sv-carry-parseInt(v2.charAt(i)))\n        if(x<0){res=(10+x)+res;carry=1}\n        else{res=x+res;carry=0}\n    }\n    \n    // If there are remaining digits in v1, substract the carry, if any\n    while(i1>0){\n        i1--\n        x = (parseInt(v1.charAt(i1))-carry)\n        if(x<0){res=(10+x)+res;carry=1}\n        else{res=x+res;carry=0}\n    }\n\n    // Remove leading zeros and return the result\n    while(res.charAt(0)=='0' && res.length>1){res=res.substr(1)}\n    return {__class__:$LongIntDict, value:res, pos:true}\n}\n\n// Special methods to implement operations on instances of LongInt\n\n$LongIntDict.__abs__ = function(self){\n    return {__class__:$LongIntDict, value: self.value, pos:true}\n}\n\n$LongIntDict.__add__ = function(self, other){\n    if (typeof other == 'number') other=LongInt(_b_.str.$factory(other))\n    // Addition of \"self\" and \"other\"\n    // If both have the same sign (+ or -) we add their absolute values\n    // If they have different sign we use the substraction of their\n    // absolute values\n    var res\n    if(self.pos&&other.pos){  // self > 0, other > 0\n        return add_pos(self.value, other.value)\n    }else if(!self.pos&&!other.pos){ // self < 0, other < 0\n        res = add_pos(self.value, other.value)\n        res.pos = false\n        return res\n    }else if(self.pos && !other.pos){ // self > 0, other < 0\n        switch (comp_pos(self.value, other.value)){\n            case 1:\n                res = sub_pos(self.value, other.value)\n                break\n            case 0:\n                res = {__class__:$LongIntDict, value:0, pos:true}\n                break\n            case -1:\n                res = sub_pos(other.value, self.value)\n                res.pos = false\n                break\n        }\n        return res\n    }else{ // self < 0, other > 0\n        switch(comp_pos(self.value, other.value)){\n            case 1:\n                res = sub_pos(self.value, other.value)\n                res.pos = false\n                break\n            case 0:\n                res = {__class__:$LongIntDict, value:0, pos:true}\n                break\n            case -1:\n                res = sub_pos(other.value, self.value)\n                break\n        }\n        return res\n    }\n}\n\n$LongIntDict.__and__ = function(self, other){\n    if (typeof other == 'number') other=LongInt(_b_.str.$factory(other))\n    // Bitwise \"and\" : build the binary representation of self and other\n    var v1 = $LongIntDict.__index__(self)\n    var v2 = $LongIntDict.__index__(other)\n    // apply \"and\" on zeros and ones\n    if(v1.length<v2.length){var temp=v2;v2=v1;v1=temp}\n    var start = v1.length-v2.length\n    var res = ''\n    for(var i=0;i<v2.length;i++){\n        if(v1.charAt(start+i)=='1' && v2.charAt(i)=='1'){res += '1'}\n        else{res += '0'}\n    }\n    // Return the LongInt instance represented by res in base 2\n    return LongInt(res, 2)\n}\n\n$LongIntDict.__divmod__ = function(self, other){\n    if (typeof other == 'number') other=LongInt(_b_.str.$factory(other))\n\n    var dm = divmod_pos(self.value, other.value)\n    if(self.pos!==other.pos){\n        if(dm[0].value!='0'){dm[0].pos = false}\n        if(dm[1].value!='0'){\n            // If self and other have different signs and self is not a multiple\n            // of other, round to the previous integer\n            dm[0] = $LongIntDict.__sub__(dm[0], LongInt('1'))\n            dm[1] = $LongIntDict.__add__(dm[1], LongInt('1'))\n        }\n    }\n    return dm    \n}\n\n$LongIntDict.__eq__ = function(self, other){\n    if (typeof other == 'number') other=LongInt(_b_.str.$factory(other))\n    return self.value==other.value && self.pos==other.pos\n}\n\n$LongIntDict.__floordiv__ = function(self, other){\n    if (typeof other == 'number') other=LongInt(_b_.str.$factory(other))\n    return $LongIntDict.__divmod__(self, other)[0]\n}\n\n$LongIntDict.__ge__ = function(self, other){\n    if (typeof other == 'number') other=LongInt(_b_.str.$factory(other))\n    if(self.value.length>other.value.length){return true}\n    else if(self.value.length<other.value.length){return false}\n    else{return self.value >= other.value}\n}\n\n$LongIntDict.__gt__ = function(self, other){\n    return !$LongIntDict.__le__(self, other)\n}\n\n$LongIntDict.__index__ = function(self){\n    // Used by bin()\n    // returns a string with the binary value of self\n    // The algorithm computes the result of the floor division of self by 2\n    \n    // XXX to do : negative integers\n    \n    var res = '', pos=self.value.length,\n        temp = self.value, d\n    while(true){\n        d = divmod_pos(temp, '2')\n        res = d[1].value + res\n        temp = d[0].value\n        if(temp=='0'){break}\n    }\n    return res\n}\n\n$LongIntDict.__invert__ = function(self){\n    var bin = $LongIntDict.__index__(self)\n    var res = ''\n    for(var i=0;i<bin.length;i++){\n        res += bin.charAt(i)=='0' ? '1' : '0'\n    }\n    return LongInt(res, 2)\n}\n\n$LongIntDict.__le__ = function(self, other){\n    if (typeof other == 'number') other=LongInt(_b_.str.$factory(other))\n    if(self.value.length>other.value.length){return false}\n    else if(self.value.length<other.value.length){return true}\n    else{return self.value <= other.value}\n}\n\n$LongIntDict.__lt__ = function(self, other){\n    return !$LongIntDict.__ge__(self, other)\n}\n\n$LongIntDict.__lshift__ = function(self, shift){\n    check_shift(shift)\n    var res = self.value\n    while(true){\n        var x, carry=0, res1=''\n        for(var i=res.length-1;i>=0;i--){\n            x = (carry+parseInt(res.charAt(i))*2).toString()\n            if(x.length==2){res1=x.charAt(1)+res1;carry=parseInt(x.charAt(0))}\n            else{res1=x+res1;carry=0}\n        }\n        if(carry){res1=carry+res1}\n        res=res1\n        shift = sub_pos(shift.value, '1')\n        if(shift.value=='0'){break}\n    }\n    return {__class__:$LongIntDict, value:res, pos:self.pos}\n}\n\n$LongIntDict.__mod__ = function(self, other){\n    return $LongIntDict.__divmod__(self, other)[1]\n}\n\n$LongIntDict.__mro__ = [_b_.object]\n\n$LongIntDict.__mul__ = function(self, other){\n    if (typeof other == 'number') other=LongInt(_b_.str.$factory(other))\n    var res = mul_pos(self.value, other.value)\n    if(self.pos==other.pos){return res}\n    res.pos = false\n    return res\n}\n\n$LongIntDict.__neg__ = function(obj){\n    return {__class__:$LongIntDict, value:obj.value, pos:!obj.pos}\n}\n\n$LongIntDict.__or__ = function(self, other){\n    var v1 = $LongIntDict.__index__(self)\n    var v2 = $LongIntDict.__index__(other)\n    if(v1.length<v2.length){var temp=v2;v2=v1;v1=temp}\n    var start = v1.length-v2.length\n    var res = v1.substr(0, start)\n    for(var i=0;i<v2.length;i++){\n        if(v1.charAt(start+i)=='1' || v2.charAt(i)=='1'){res += '1'}\n        else{res += '0'}\n    }\n    return LongInt(res, 2)\n}\n\n\n$LongIntDict.__pow__ = function(self, power){\n    if (typeof power == \"number\") {\n        power=LongInt(_b_.str.$factory(power))\n    }else if(!isinstance(power, LongInt)){\n        var msg = \"power must be a LongDict, not '\"\n        throw TypeError(msg+$B.get_class(power).__name__+\"'\")\n    }\n    if(!power.pos){\n        if(self.value=='1'){return self}\n        // For all other integers, x**-n is 0\n        return LongInt('0')\n    }else if(power.value=='0'){\n        return LongInt('1')\n    }\n    var res = {__class__:$LongIntDict, value:self.value, pos:self.pos}\n    var pow = power.value\n    while(true){\n        pow = sub_pos(pow, '1').value\n        if(pow == '0'){break}\n        res = $LongIntDict.__mul__(res, self)\n    }\n    return res    \n}\n\n$LongIntDict.__rshift__ = function(self, shift){\n    check_shift(shift)\n    var res = self.value\n    while(true){\n        res = divmod_pos(res, '2')[0].value\n        if(res.value=='0'){break}\n        shift = sub_pos(shift.value, '1')\n        if(shift.value=='0'){break}\n    }\n    return {__class__:$LongIntDict, value:res, pos:self.pos}\n}\n\n$LongIntDict.__str__ = $LongIntDict.__repr__ = function(self){\n    var res = \"LongInt('\"\n    if(!self.pos){res += '-'}\n    return res+self.value+\"')\"\n}\n\n$LongIntDict.__sub__ = function(self, other){\n    if (typeof other == 'number') other=LongInt(_b_.str.$factory(other))\n    var res\n    if(self.pos && other.pos){\n        switch(comp_pos(self.value, other.value)){\n            case 1:\n                res = sub_pos(self.value, other.value)\n                break\n            case 0:\n                res = {__class__:$LongIntDict, value:'0', pos:true}\n                break\n            case -1:\n                res = sub_pos(other.value, self.value)\n                res.pos = false\n                break\n        }\n        return res\n    }else if(!self.pos && !other.pos){\n        switch(comp_pos(self.value, other.value)){\n            case 1:\n                res = sub_pos(self.value, other.value)\n                res.pos = false\n                break\n            case 0:\n                res = {__class__:$LongIntDict, value:'0', pos:true}\n                break\n            case -1:\n                res = sub_pos(other.value, self.value)\n                break\n        }\n        return res\n    }else if(self.pos && !other.pos){\n        return add_pos(self.value, other.value)\n    }else{\n        res = add_pos(self.value, other.value)\n        res.pos = false\n        return res\n    }\n}\n\n$LongIntDict.__xor__ = function(self, other){\n    var v1 = $LongIntDict.__index__(self)\n    var v2 = $LongIntDict.__index__(other)\n    if(v1.length<v2.length){var temp=v2;v2=v1;v1=temp}\n    var start = v1.length-v2.length\n    var res = v1.substr(0, start)\n    for(var i=0;i<v2.length;i++){\n        if(v1.charAt(start+i)=='1' && v2.charAt(i)=='0'){res += '1'}\n        else if(v1.charAt(start+i)=='0' && v2.charAt(i)=='1'){res += '1'}\n        else{res += '0'}\n    }\n    return LongInt(res, 2)\n}\n\n$LongIntDict.to_base = function(self, base){\n    // Returns the string representation of self in specified base\n    var res='', v=self.value\n    while(v>0){\n        var dm = divmod_pos(v, base.toString())\n        res = parseInt(dm[1].value).toString(base)+res\n        v = dm[0].value\n        if(v==0){break}\n    }\n    return res\n}\n\nfunction digits(base){\n    // Return an object where keys are all the digits valid in specified base\n    // and value is \"true\"\n    // Used to test if the string passed as first argument to LongInt is valid\n    var is_digits = {}\n    // Number from 0 to base, or from 0 to 9 if base > 10\n    for(var i=0;i<base;i++){\n        if(i==10){break}\n        is_digits[i]=true\n    }\n    if(base>10){\n        // Additional letters\n        // For instance in base 16, add \"abcdefABCDEF\" as keys\n        for(var i=0;i<base-10;i++){\n            is_digits[String.fromCharCode(65+i)]=true\n            is_digits[String.fromCharCode(97+i)]=true\n        }\n    }\n    return is_digits\n}\n\nvar MAX_SAFE_INTEGER = Math.pow(2, 53)-1;\nvar MIN_SAFE_INTEGER = -Number.MAX_SAFE_INTEGER;\n\nfunction isSafeInteger(n) {\n    return (typeof n === 'number' &&\n        Math.round(n) === n &&\n        Number.MIN_SAFE_INTEGER <= n &&\n        n <= Number.MAX_SAFE_INTEGER);\n}\n\nfunction LongInt(value, base){\n    if(arguments.length>2){\n        throw _b_.TypeError(\"LongInt takes at most 2 arguments (\"+\n            arguments.length+\" given)\")\n    }\n    // base defaults to 10\n    if(base===undefined){base = 10}\n    else if(!isinstance(base, int)){\n        throw TypeError(\"'\"+$B.get_class(base).__name__+\"' object cannot be interpreted as an integer\")\n    }\n    if(base<0 || base==1 || base>36){\n        throw ValueError(\"LongInt() base must be >= 2 and <= 36\")\n    }\n    if(isinstance(value, float)){\n        if(value>=0){value=Math.round(value.value)}\n        else{value=Math.ceil(value.value)}\n    }\n    if(typeof value=='number'){\n        if(isSafeInteger(value)){value = value.toString()}\n        else{throw ValueError(\"argument of long_int is not a safe integer\")}\n    }else if(typeof value!='string'){\n        throw ValueError(\"argument of long_int must be a string, not \"+\n            $B.get_class(value).__name__)\n    }\n    var has_prefix = false, pos = true, start = 0\n    // Strip leading and trailing whitespaces\n    while(value.charAt(0)==' ' && value.length){value = value.substr(1)}\n    while(value.charAt(value.length-1)==' ' && value.length){\n        value = value.substr(0, value.length-1)\n    }\n    // Check if string starts with + or -\n    if(value.charAt(0)=='+'){has_prefix=true}\n    else if(value.charAt(0)=='-'){has_prefix=true;pos=false}\n    if(has_prefix){\n        // Remove prefix\n        if(value.length==1){\n            // \"+\" or \"-\" alone are not valid arguments\n            throw ValueError('LongInt argument is not a valid number: \"'+value+'\"')\n        }else{value=value.substr(1)}\n    }\n    // Ignore leading zeros\n    while(start<value.length-1 && value.charAt(start)=='0'){start++}\n    value = value.substr(start)\n\n    // Check if all characters in value are valid in the base\n    var is_digits = digits(base), point = -1\n    for(var i=0;i<value.length;i++){\n        if(value.charAt(i)=='.' && point==-1){point=i}\n        else if(!is_digits[value.charAt(i)]){\n            throw ValueError('LongInt argument is not a valid number: \"'+value+'\"')\n        }\n    }\n    if(point!=-1){value=value.substr(0,point)}\n    if(base!=10){\n        // Conversion to base 10\n        var coef = '1', v10 = LongInt(0),\n            pos = value.length, digit_base10\n        while(pos--){\n            digit_base10 = parseInt(value.charAt(pos), base).toString()\n            digit_by_coef = mul_pos(coef, digit_base10).value\n            v10 = add_pos(v10.value, digit_by_coef)\n            coef = mul_pos(coef, base.toString()).value\n        }\n        return v10\n    }\n    return {__class__:$LongIntDict, value:value, pos:pos}\n}\n\nLongInt.__class__ = $B.$factory\nLongInt.$dict = $LongIntDict\n$LongIntDict.$factory = LongInt\n\nreturn {LongInt:LongInt}\n\n})(__BRYTHON__)\n"], "marshal": [".js", "var $module = (function($B){\n\nreturn  {\n    loads : function(){\n        var $ = $B.args('loads', 1, {obj:null}, ['obj'], arguments, {},\n            null, null)\n        return $B.jsobject2pyobject(JSON.parse($.obj))\n    },\n    load : function(){\n        var $ = $B.args('load', 1, {obj:null}, ['obj'], arguments, {},\n            null, null)\n        return $module.loads(obj.$content);\n    },\n    dumps : function(){\n        var $ = $B.args('dumps', 1, {obj:null}, ['obj'], arguments, {},\n            null, null)\n        return JSON.stringify($B.pyobject2jsobject($.obj))\n    },\n}\n\n})(__BRYTHON__)\n"], "math": [".js", "var $module = (function($B){\n\nvar _b_ = $B.builtins,\n    $s = [],\n    i\nfor(var $b in _b_){$s.push('var ' + $b +' = _b_[\"'+$b+'\"]')}\neval($s.join(';'))\n\n//for(var $py_builtin in _b_){eval(\"var \"+$py_builtin+\"=_b_[$py_builtin]\")}\n\nvar float_check = function(x) {\n    if(x.__class__ === $B.long_int){return parseInt(x.value)}\n    return _b_.float.$factory(x)\n}\n\nvar isWholeNumber = function(x){return (x * 10) % 10 == 0}\n\nvar isOdd = function(x) {return isWholeNumber(x) && 2 * Math.floor(x / 2) != x}\n\nvar isLargeNumber = function(x) {return x > Math.pow(2, 32)}\n\n// Big number Library from jsfromhell.com\n// This library helps with producing \"correct\" results from\n// mathematic operations\n\n//+ Jonas Raoni Soares Silva\n//@ http://jsfromhell.com/classes/bignumber [rev. #4]\n\n\nvar BigNumber = function(n, p, r){\n    var o = this, i\n    if(n instanceof BigNumber){\n        for(i in {precision: 0, roundType: 0, _s: 0, _f: 0}){o[i] = n[i]}\n        o._d = n._d.slice()\n        return\n    }\n    o.precision = isNaN(p = Math.abs(p)) ? BigNumber.defaultPrecision : p\n    o.roundType = isNaN(r = Math.abs(r)) ? BigNumber.defaultRoundType : r\n    o._s = (n += \"\").charAt(0) == \"-\"\n    o._f = ((n = n.replace(/[^\\d.]/g, \"\").split(\".\", 2))[0] =\n        n[0].replace(/^0+/, \"\") || \"0\").length\n    for(i = (n = o._d = (n.join(\"\") || \"0\").split(\"\")).length; i;\n        n[--i] = +n[i]){}\n    o.round()\n}\nwith({$: BigNumber, o: BigNumber.prototype}){\n    $.ROUND_HALF_EVEN = ($.ROUND_HALF_DOWN = ($.ROUND_HALF_UP =\n        ($.ROUND_FLOOR = ($.ROUND_CEIL = ($.ROUND_DOWN = ($.ROUND_UP = 0) + 1) +\n            1) + 1) + 1) + 1) + 1\n    $.defaultPrecision = 40\n    $.defaultRoundType = $.ROUND_HALF_UP\n    o.add = function(n){\n        if(this._s != (n = new BigNumber(n))._s){\n            return n._s ^= 1, this.subtract(n)\n        }\n        var o = new BigNumber(this),\n            a = o._d,\n            b = n._d,\n            la = o._f,\n            lb = n._f,\n            n = Math.max(la, lb),\n            i,\n            r\n        la != lb && ((lb = la - lb) > 0 ? o._zeroes(b, lb, 1) :\n            o._zeroes(a, -lb, 1))\n        i = (la = a.length) == (lb = b.length) ? a.length :\n            ((lb = la - lb) > 0 ? o._zeroes(b, lb) : o._zeroes(a, -lb)).length\n        for(r = 0; i; r = (a[--i] = a[i] + b[i] + r) / 10 >>> 0, a[i] %= 10){}\n        return r && ++n && a.unshift(r), o._f = n, o.round()\n    };\n    o.subtract = function(n){\n        if(this._s != (n = new BigNumber(n))._s)\n            return n._s ^= 1, this.add(n);\n        var o = new BigNumber(this),\n            c = o.abs().compare(n.abs()) + 1,\n            a = c ? o : n,\n            b = c ? n : o,\n            la = a._f,\n            lb = b._f,\n            d = la,\n            i,\n            j;\n        a = a._d, b = b._d, la != lb && ((lb = la - lb) > 0 ? o._zeroes(b, lb, 1) : o._zeroes(a, -lb, 1));\n        for(i = (la = a.length) == (lb = b.length) ? a.length : ((lb = la - lb) > 0 ? o._zeroes(b, lb) : o._zeroes(a, -lb)).length; i;){\n            if(a[--i] < b[i]){\n                for(j = i; j && !a[--j]; a[j] = 9);\n                --a[j], a[i] += 10;\n            }\n            b[i] = a[i] - b[i];\n        }\n        return c || (o._s ^= 1), o._f = d, o._d = b, o.round();\n    };\n    o.multiply = function(n){\n        var o = new BigNumber(this), r = o._d.length >= (n = new BigNumber(n))._d.length, a = (r ? o : n)._d,\n        b = (r ? n : o)._d, la = a.length, lb = b.length, x = new BigNumber, i, j, s;\n        for(i = lb; i; r && s.unshift(r), x.set(x.add(new BigNumber(s.join(\"\")))))\n            for(s = (new Array(lb - --i)).join(\"0\").split(\"\"), r = 0, j = la; j; r += a[--j] * b[i], s.unshift(r % 10), r = (r / 10) >>> 0);\n        return o._s = o._s != n._s, o._f = ((r = la + lb - o._f - n._f) >= (j = (o._d = x._d).length) ? this._zeroes(o._d, r - j + 1, 1).length : j) - r, o.round();\n    };\n    o.divide = function(n){\n        if((n = new BigNumber(n)) == \"0\")\n            throw new Error(\"Division by 0\");\n        else if(this == \"0\")\n            return new BigNumber;\n        var o = new BigNumber(this), a = o._d, b = n._d, la = a.length - o._f,\n        lb = b.length - n._f, r = new BigNumber, i = 0, j, s, l, f = 1, c = 0, e = 0;\n        r._s = o._s != n._s, r.precision = Math.max(o.precision, n.precision),\n        r._f = +r._d.pop(), la != lb && o._zeroes(la > lb ? b : a, Math.abs(la - lb));\n        n._f = b.length, b = n, b._s = false, b = b.round();\n        for(n = new BigNumber; a[0] == \"0\"; a.shift());\n        out:\n        do{\n            for(l = c = 0, n == \"0\" && (n._d = [], n._f = 0); i < a.length && n.compare(b) == -1; ++i){\n                (l = i + 1 == a.length, (!f && ++c > 1 || (e = l && n == \"0\" && a[i] == \"0\")))\n                && (r._f == r._d.length && ++r._f, r._d.push(0));\n                (a[i] == \"0\" && n == \"0\") || (n._d.push(a[i]), ++n._f);\n                if(e)\n                    break out;\n                if((l && n.compare(b) == -1 && (r._f == r._d.length && ++r._f, 1)) || (l = 0))\n                    while(r._d.push(0), n._d.push(0), ++n._f, n.compare(b) == -1);\n            }\n            if(f = 0, n.compare(b) == -1 && !(l = 0))\n                while(l ? r._d.push(0) : l = 1, n._d.push(0), ++n._f, n.compare(b) == -1);\n            for(s = new BigNumber, j = 0; n.compare(y = s.add(b)) + 1 && ++j; s.set(y));\n            n.set(n.subtract(s)), !l && r._f == r._d.length && ++r._f, r._d.push(j);\n        }\n        while((i < a.length || n != \"0\") && (r._d.length - r._f) <= r.precision);\n        return r.round();\n    };\n    o.mod = function(n){\n        return this.subtract(this.divide(n).intPart().multiply(n));\n    };\n    o.pow = function(n){\n        var o = new BigNumber(this), i;\n        if((n = (new BigNumber(n)).intPart()) == 0) return o.set(1);\n        for(i = Math.abs(n); --i; o.set(o.multiply(this)));\n        return n < 0 ? o.set((new BigNumber(1)).divide(o)) : o;\n    };\n    o.set = function(n){\n        return this.constructor(n), this;\n    };\n    o.compare = function(n){\n        var a = this, la = this._f, b = new BigNumber(n), lb = b._f, r = [-1, 1], i, l;\n        if(a._s != b._s)\n            return a._s ? -1 : 1;\n        if(la != lb)\n            return r[(la > lb) ^ a._s];\n        for(la = (a = a._d).length, lb = (b = b._d).length, i = -1, l = Math.min(la, lb); ++i < l;)\n            if(a[i] != b[i])\n                return r[(a[i] > b[i]) ^ a._s];\n        return la != lb ? r[(la > lb) ^ a._s] : 0;\n    };\n    o.negate = function(){\n        var n = new BigNumber(this); return n._s ^= 1, n;\n    };\n    o.abs = function(){\n        var n = new BigNumber(this); return n._s = 0, n;\n    };\n    o.intPart = function(){\n        return new BigNumber((this._s ? \"-\" : \"\") + (this._d.slice(0, this._f).join(\"\") || \"0\"));\n    };\n    o.valueOf = o.toString = function(){\n        var o = this;\n        return (o._s ? \"-\" : \"\") + (o._d.slice(0, o._f).join(\"\") || \"0\") + (o._f != o._d.length ? \".\" + o._d.slice(o._f).join(\"\") : \"\");\n    };\n    o._zeroes = function(n, l, t){\n        var s = [\"push\", \"unshift\"][t || 0];\n        for(++l; --l;  n[s](0));\n        return n;\n    };\n    o.round = function(){\n        if(\"_rounding\" in this) return this;\n        var $ = BigNumber, r = this.roundType, b = this._d, d, p, n, x;\n        for(this._rounding = true; this._f > 1 && !b[0]; --this._f, b.shift());\n        for(d = this._f, p = this.precision + d, n = b[p]; b.length > d && !b[b.length -1]; b.pop());\n        x = (this._s ? \"-\" : \"\") + (p - d ? \"0.\" + this._zeroes([], p - d - 1).join(\"\") : \"\") + 1;\n        if(b.length > p){\n            n && (r == $.DOWN ? false : r == $.UP ? true : r == $.CEIL ? !this._s\n            : r == $.FLOOR ? this._s : r == $.HALF_UP ? n >= 5 : r == $.HALF_DOWN ? n > 5\n            : r == $.HALF_EVEN ? n >= 5 && b[p - 1] & 1 : false) && this.add(x);\n            b.splice(p, b.length - p);\n        }\n        return delete this._rounding, this;\n    };\n}\n\nvar isNegZero = function(x) {return x === 0 && Math.atan2(x,x) < 0}\n\nvar _mod = {\n    __getattr__ : function(attr){\n        var res = this[attr]\n        if(res === undefined){$raise('AttributeError',\n            'module math has no attribute ' + attr)}\n        return res\n    },\n    acos: function(x) {return float.$factory(Math.acos(float_check(x)))},\n    acosh: function(x) {\n        if(_b_.$isinf(x)){return float.$factory('inf')}\n        var y = float_check(x)\n        return float.$factory(Math.log(y + Math.sqrt(y * y - 1)))\n    },\n    asin: function(x) {return float.$factory(Math.asin(float_check(x)))},\n    asinh: function(x) {\n        if(_b_.$isninf(x)){return float.$factory('-inf')}\n        if(_b_.$isinf(x)){return float.$factory('inf')}\n        var y = float_check(x)\n        return float.$factory(Math.log(y + Math.sqrt(y * y + 1)))\n    },\n    atan: function(x) {\n        if(_b_.$isninf(x)){return float.$factory(-Math.PI / 2)}\n        if(_b_.$isinf(x)){return float.$factory(Math.PI / 2)}\n        return float.$factory(Math.atan(float_check(x)))},\n    atan2: function(y, x) {\n        return float.$factory(Math.atan2(float_check(y), float_check(x)))\n    },\n    atanh: function(x) {\n       var y = float_check(x)\n       if(y == 0){return 0}\n       return float.$factory(0.5 * Math.log((1 / y + 1)/(1 / y - 1)));\n    },\n    ceil: function(x) {\n       try{return getattr(x, '__ceil__')()}catch(err){}\n\n       if(_b_.$isninf(x)){return float.$factory('-inf')}\n       if(_b_.$isinf(x)){return float.$factory('inf')}\n       if(isNaN(x)){return float.$factory('nan')}\n\n       var y = float_check(x)\n       if(! isNaN(parseFloat(y)) && isFinite(y)){\n           return int.$factory(Math.ceil(y))\n       }\n\n       $raise('ValueError',\n           'object is not a number and does not contain __ceil__')\n    },\n    copysign: function(x,y) {\n        var x1 = Math.abs(float_check(x))\n        var y1 = float_check(y)\n        var sign = y1 ? y1 < 0 ? -1 : 1 : 1\n        if(isNegZero(y1)){sign = -1}   // probably need to work on adding a check for -0\n        return float.$factory(x1 * sign)\n    },\n    cos : function(x){return float.$factory(Math.cos(float_check(x)))},\n    cosh: function(x){\n        if(_b_.$isinf(x)) {return float.$factory('inf')}\n        var y = float_check(x)\n        if(Math.cosh !== undefined){return float.$factory(Math.cosh(y))}\n        return float.$factory((Math.pow(Math.E, y) + Math.pow(Math.E, -y)) / 2)\n    },\n    degrees: function(x){return float.$factory(float_check(x) * 180 / Math.PI)},\n    e: float.$factory(Math.E),\n    erf: function(x) {\n        // inspired from\n        // http://stackoverflow.com/questions/457408/is-there-an-easily-available-implementation-of-erf-for-python\n        var y = float_check(x)\n        var t = 1.0 / (1.0 + 0.5 * Math.abs(y))\n        var ans = 1 - t * Math.exp( -y * y - 1.26551223 +\n                     t * ( 1.00002368 +\n                     t * ( 0.37409196 +\n                     t * ( 0.09678418 +\n                     t * (-0.18628806 +\n                     t * ( 0.27886807 +\n                     t * (-1.13520398 +\n                     t * ( 1.48851587 +\n                     t * (-0.82215223 +\n                     t * 0.17087277)))))))))\n        if(y >= 0.0){return ans}\n        return -ans\n    },\n\n    erfc: function(x) {\n        // inspired from\n        // http://stackoverflow.com/questions/457408/is-there-an-easily-available-implementation-of-erf-for-python\n        var y = float_check(x)\n        var t = 1.0 / (1.0 + 0.5 * Math.abs(y))\n        var ans = 1 - t * Math.exp( -y * y - 1.26551223 +\n                     t * ( 1.00002368 +\n                     t * ( 0.37409196 +\n                     t * ( 0.09678418 +\n                     t * (-0.18628806 +\n                     t * ( 0.27886807 +\n                     t * (-1.13520398 +\n                     t * ( 1.48851587 +\n                     t * (-0.82215223 +\n                     t * 0.17087277)))))))))\n        if(y >= 0.0){return 1 - ans}\n        return 1 + ans\n    },\n    exp: function(x){\n         if(_b_.$isninf(x)){return float.$factory(0)}\n         if(_b_.$isinf(x)){return float.$factory('inf')}\n         var _r = Math.exp(float_check(x))\n         if(_b_.$isinf(_r)){throw OverflowError(\"math range error\")}\n         return float.$factory(_r)\n    },\n    expm1: function(x){return float.$factory(Math.exp(float_check(x)) - 1)},\n    //fabs: function(x){ return x>0?float.$factory(x):float.$factory(-x)},\n    fabs: function(x){return _b_.$fabs(x)}, //located in py_float.js\n    factorial: function(x) {\n         //using code from http://stackoverflow.com/questions/3959211/fast-factorial-function-in-javascript\n         var y = float_check(x),\n             r = 1\n         for(var i = 2; i <= y; i++){r *= i}\n         return r\n    },\n    floor: function(x){return Math.floor(float_check(x))},\n    fmod: function(x,y){return float.$factory(float_check(x) % float_check(y))},\n    frexp: function(x){\n        var _l = _b_.$frexp(x)\n        return _b_.tuple.$factory([float.$factory(_l[0]), _l[1]])\n    },\n    fsum: function(x){\n        /* Translation into Javascript of the function msum in an Active\n           State Cookbook recipe : https://code.activestate.com/recipes/393090/\n           by Raymond Hettinger\n        */\n        var partials = [],\n            res = new Number(),\n            _it = _b_.iter(x)\n        while(true){\n            try{\n                var x = _b_.next(_it),\n                    i = 0\n                for(var j = 0, len = partials.length; j < len; j++){\n                    var y = partials[j]\n                    if(Math.abs(x) < Math.abs(y)){\n                        var z = x\n                        x = y\n                        y = z\n                    }\n                    var hi = x + y,\n                        lo = y - (hi - x)\n                    if(lo){\n                        partials[i] = lo\n                        i++\n                    }\n                    x = hi\n                }\n                partials = partials.slice(0, i).concat([x])\n            }catch(err){\n                if(_b_.isinstance(err, _b_.StopIteration)){break}\n                throw err\n            }\n        }\n        var res = new Number(0)\n        for(var i = 0; i < partials.length; i++){\n            res += new Number(partials[i])\n        }\n        return new Number(res)\n    },\n    gamma: function(x){\n         //using code from http://stackoverflow.com/questions/3959211/fast-factorial-function-in-javascript\n         // Lanczos Approximation of the Gamma Function\n         // As described in Numerical Recipes in C (2nd ed. Cambridge University Press, 1992)\n         var y = float_check(x)\n         var z = y + 1\n         var d1 = Math.sqrt(2 * Math.PI) / z\n\n         var d2 = 1.000000000190015;\n         d2 +=  76.18009172947146 / (z + 1)\n         d2 += -86.50532032941677 / (z + 2)\n         d2 +=  24.01409824083091 / (z + 3)\n         d2 += -1.231739572450155 / (z + 4)\n         d2 +=  1.208650973866179E-3 / (z + 5)\n         d2 += -5.395239384953E-6 / (z + 6)\n\n         return d1 * d2 * Math.pow(z + 5.5, z + 0.5) * Math.exp(-(z + 5.5))\n    },\n    gcd: function(){\n        var $ = $B.args(\"gcd\", 2, {a: null, b: null}, ['a', 'b'],\n                arguments, {}, null, null),\n            a = $B.PyNumber_Index($.a),\n            b = $B.PyNumber_Index($.b)\n        if(a == 0 && b == 0){return 0}\n        // https://stackoverflow.com/questions/17445231/js-how-to-find-the-greatest-common-divisor\n        a = Math.abs(a);\n        b = Math.abs(b);\n        if(b > a){var temp = a; a = b; b = temp;}\n        while(true){\n            if(b == 0){return a}\n            a %= b\n            if(a == 0){return b}\n            b %= a\n        }\n    },\n    hypot: function(x,y){\n       if(_b_.$isinf(x) || _b_.$isinf(y)){return float.$factory('inf')}\n       var x1 = float_check(x),\n           y1 = float_check(y)\n       return float.$factory(Math.sqrt(x1 * x1 + y1 * y1))},\n    inf: float.$factory('inf'),\n    isclose:function(){\n        var $ns = $B.args(\"isclose\",\n                          4,\n                          {a: null, b: null, rel_tol: null, abs_tol: null},\n                          ['a', 'b', 'rel_tol', 'abs_tol'],\n                          arguments,\n                          {rel_tol: 1e-09, abs_tol: 0.0},\n                          null,\n                          null)\n        var a = $ns['a'],\n            b = $ns['b'],\n            rel_tol = $ns['rel_tol'],\n            abs_tol = $ns['abs_tol']\n        if(rel_tol < 0.0 || abs_tol < 0.0){\n            throw ValueError('tolerances must be non-negative')\n        }\n        if(a == b){return True}\n        if(_b_.$isinf(a) || _b_.$isinf(b)){return false}\n        var diff = _b_.$fabs(b - a)\n        var result = (\n            (diff <= _b_.$fabs(rel_tol * b)) ||\n                (diff <= _b_.$fabs(rel_tol * a))\n            ) || (diff <= _b_.$fabs(abs_tol)\n        )\n        return result\n    },\n    isfinite: function(x){return isFinite(float_check(x))},\n    isinf: function(x){return _b_.$isinf(float_check(x))},\n    isnan: function(x){return isNaN(float_check(x))},\n    ldexp: function(x, i){return _b_.$ldexp(x, i)},   //located in py_float.js\n    lgamma: function(x){\n         // see gamma function for sources\n         var y = float_check(x),\n             z = y + 1,\n             d1 = Math.sqrt(2 * Math.PI) / z\n\n         var d2 = 1.000000000190015\n         d2 +=  76.18009172947146 / (z + 1)\n         d2 += -86.50532032941677 / (z + 2)\n         d2 +=  24.01409824083091 / (z + 3)\n         d2 += -1.231739572450155 / (z + 4)\n         d2 +=  1.208650973866179E-3 / (z + 5)\n         d2 += -5.395239384953E-6 / (z + 6)\n\n         return float.$factory(Math.log(Math.abs(d1 * d2 *\n             Math.pow(z + 5.5, z + 0.5) * Math.exp(-(z + 5.5)))))\n    },\n    log: function(x, base){\n         var x1 = float_check(x)\n         if(base === undefined){return float.$factory(Math.log(x1))}\n         return float.$factory(Math.log(x1) / Math.log(float_check(base)))\n    },\n    log1p: function(x){return float.$factory(Math.log(1.0 + float_check(x)))},\n    log2: function(x){\n        if(isNaN(x)){return float.$factory('nan')}\n        if(_b_.$isninf(x)) {throw ValueError('')}\n        var x1 = float_check(x)\n        if(x1 < 0.0){throw ValueError('')}\n        return float.$factory(Math.log(x1) / Math.LN2)\n    },\n    log10: function(x) {\n        return float.$factory(Math.log(float_check(x)) / Math.LN10)\n    },\n    modf: function(x) {\n       if(_b_.$isninf(x)){\n           return _b_.tuple.$factory([0.0, float.$factory('-inf')])\n       }\n       if(_b_.$isinf(x)){\n           return _b_.tuple.$factory([0.0, float.$factory('inf')])\n       }\n       if(isNaN(x)){\n           return _b_.tuple.$factory([float.$factory('nan'),\n               float.$factory('nan')])\n       }\n\n       var x1 = float_check(x)\n       if(x1 > 0){\n          var i = float.$factory(x1 - Math.floor(x1))\n          return _b_.tuple.$factory([i, float.$factory(x1 - i)])\n       }\n\n       var x2 = Math.ceil(x1)\n       var i = float.$factory(x1 - x2)\n       return _b_.tuple.$factory([i, float.$factory(x2)])\n    },\n    nan: float.$factory('nan'),\n    pi : float.$factory(Math.PI),\n    pow: function(x,y) {\n        var x1 = float_check(x)\n        var y1 = float_check(y)\n        if(y1 == 0){return float.$factory(1)}\n        if(x1 == 0 && y1 < 0){throw _b_.ValueError('')}\n\n        if(isNaN(y1)){\n            if(x1 == 1){return float.$factory(1)}\n            return float.$factory('nan')\n        }\n        if(x1 == 0){return float.$factory(0)}\n\n        if(_b_.$isninf(y)){\n            if(x1 == 1 || x1 == -1){return float.$factory(1)}\n            if(x1 < 1 && x1 > -1){return float.$factory('inf')}\n            return float.$factory(0)\n        }\n        if(_b_.$isinf(y)){\n            if(x1 == 1 || x1 == -1){return float.$factory(1)}\n            if(x1 < 1 && x1 > -1){return float.$factory(0)}\n            return float.$factory('inf')\n        }\n\n        if(isNaN(x1)){return float.$factory('nan')}\n        if(_b_.$isninf(x)){\n            if(y1 > 0 && isOdd(y1)){return float.$factory('-inf')}\n            if(y1 > 0){return float.$factory('inf')}  // this is even or a float\n            if(y1 < 0){return float.$factory(0)}\n            return float.$factory(1)\n        }\n\n        if(_b_.$isinf(x)){\n            if(y1 > 0){return float.$factory('inf')}\n            if(y1 < 0){return float.$factory(0)}\n            return float.$factory(1)\n        }\n\n        var r\n        if(isLargeNumber(x1) || isLargeNumber(y1)){\n           var x = new BigNumber(x1),\n               y = new BigNumber(y1)\n           r = x.pow(y)\n        }else{\n           r = Math.pow(x1,y1)\n        }\n\n        if(isNaN(r)){return float.$factory('nan')}\n        if(_b_.$isninf(r)){return float.$factory('-inf')}\n        if(_b_.$isinf(r)){return float.$factory('inf')}\n\n        return r\n    },\n    radians: function(x){\n        return float.$factory(float_check(x) * Math.PI / 180)\n    },\n    sin : function(x){return float.$factory(Math.sin(float_check(x)))},\n    sinh: function(x) {\n        //if (_b_.$isinf(x)) return float.$factory('inf');\n        var y = float_check(x)\n        if(Math.sinh !== undefined){return float.$factory(Math.sinh(y))}\n        return float.$factory(\n            (Math.pow(Math.E, y) - Math.pow(Math.E, -y)) / 2)\n    },\n    sqrt : function(x){\n      var y = float_check(x)\n      if(y < 0){throw ValueError(\"math range error\")}\n      if(_b_.$isinf(y)){return float.$factory('inf')}\n      var _r = Math.sqrt(y)\n      if(_b_.$isinf(_r)){throw OverflowError(\"math range error\")}\n      return float.$factory(_r)\n    },\n    tan: function(x) {\n        var y = float_check(x)\n        return float.$factory(Math.tan(y))\n    },\n    tanh: function(x) {\n        var y = float_check(x)\n        if(Math.tanh !== undefined){return float.$factory(Math.tanh(y))}\n        return float.$factory((Math.pow(Math.E, y) - Math.pow(Math.E, -y))/\n             (Math.pow(Math.E, y) + Math.pow(Math.E, -y)))\n    },\n    trunc: function(x) {\n       try{return getattr(x, '__trunc__')()}catch(err){}\n       var x1 = float_check(x)\n       if(!isNaN(parseFloat(x1)) && isFinite(x1)){\n          if(Math.trunc !== undefined){return int.$factory(Math.trunc(x1))}\n          if(x1 > 0){return int.$factory(Math.floor(x1))}\n          return int.$factory(Math.ceil(x1))  // x1 < 0\n       }\n       $raise('ValueError',\n           'object is not a number and does not contain __trunc__')\n    }\n}\n\nfor(var $attr in _mod){\n    if(typeof _mod[$attr] === 'function'){\n        _mod[$attr].__repr__ = (function(func){\n            return function(){return '<built-in function ' + func + '>'}\n        })($attr)\n        _mod[$attr].__str__ = (function(func){\n            return function(){return '<built-in function ' + func + '>'}\n        })($attr)\n    }\n}\n\nreturn _mod\n\n})(__BRYTHON__)\n"], "modulefinder": [".js", "var $module=(function($B){\n\nvar _b_=$B.builtins\nvar _mod = {}\n\n$ModuleFinderDict = {__class__:_b_.type,__name__:'ModuleFinder'}\n$ModuleFinderDict.__mro__ = [_b_.object]\n\n$ModuleFinderDict.run_script = function(self, pathname){\n    // pathname is the url of a Python script\n    var py_src = _b_.$open(pathname).read()\n    // transform into internal Brython tree structure\n    var root = $B.py2js(py_src)\n    // walk the tree to find occurences of imports\n    function walk(node){\n        var modules = []\n        var ctx = node.context\n        if(ctx && ctx.type=='node'){ctx = ctx.tree[0]}\n\n        if(ctx && ctx.type==\"import\"){\n            for(var i=0, _len_i = ctx.tree.length; i < _len_i;i++){\n                if(modules.indexOf(ctx.tree[i].name)==-1){\n                    modules.push(ctx.tree[i].name)\n                }\n            }\n        }else if(ctx && ctx.type==\"from\"){\n            if(modules.indexOf(ctx.module)==-1){\n                modules.push(ctx.module)\n            }\n        }\n        \n        for(var i=0, _len_i = node.children.length; i < _len_i;i++){\n            mods = walk(node.children[i])\n            for(var j=0, _len_j = mods.length; j < _len_j;j++){\n                if(modules.indexOf(mods[j])==-1){modules.push(mods[j])}\n            }\n        }\n        return modules\n    }\n    self.modules = walk(root)\n}\n\n_mod.ModuleFinder = function(){return {__class__:$ModuleFinderDict}\n}\n_mod.ModuleFinder.$dict = $ModuleFinderDict\n_mod.ModuleFinder.__class__ = $B.$factory\n$ModuleFinderDict.$factory = _mod.ModuleFinder\n\nreturn _mod\n})(__BRYTHON__)\n"], "posix": [".js", "/*\nThis module provides access to operating system functionality that is\nstandardized by the C Standard and the POSIX standard (a thinly\ndisguised Unix interface).  Refer to the library manual and\ncorresponding Unix manual entries for more information on calls.\n*/\n\nvar $B = __BRYTHON__,\n    _b_ = $B.builtins\n\nfunction _randint(a, b){\n    return parseInt(Math.random() * (b - a + 1) + a)\n}\n\nvar stat_result = $B.make_class(\"stat_result\",\n    function(){\n        var res = {\n            __class__: stat_result,\n            st_atime: new Date(),\n            st_uid: -1,\n            st_gid: -1,\n            st_ino: -1,\n            st_mode: 0,\n            st_size: 1\n        };\n        [\"mtime\", \"ctime\", \"atime_ns\", \"mtime_ns\", \"ctime_ns\"].\n            forEach(function(item){\n                res[\"st_\" + item] = res.st_atime\n            });\n        return res\n    }\n)\n$B.set_func_names(stat_result, \"posix\")\n\nvar $module = {\n    F_OK: 0,\n    O_APPEND: 8,\n    O_BINARY: 32768,\n    O_CREAT: 256,\n    O_EXCL: 1024,\n    O_NOINHERIT: 128,\n    O_RANDOM: 16,\n    O_RDONLY: 0,\n    O_RDWR: 2,\n    O_SEQUENTIAL: 32,\n    O_SHORT_LIVED: 4096,\n    O_TEMPORARY: 64,\n    O_TEXT: 16384,\n    O_TRUNC: 512,\n    O_WRONLY: 1,\n    P_DETACH: 4,\n    P_NOWAIT: 1,\n    P_NOWAITO: 3,\n    P_OVERLAY: 2,\n    P_WAIT: 0,\n    R_OK: 4,\n    TMP_MAX: 32767,\n    W_OK: 2,\n    X_OK: 1,\n    _have_functions: ['MS_WINDOWS'],\n    environ: _b_.dict.$factory(\n        [['PYTHONPATH', $B.brython_path],\n         ['PYTHONUSERBASE', ' ']]),\n    error: _b_.OSError,\n    getcwd: function(){return $B.brython_path},\n    getpid: function(){return 0},\n    lstat: function(){return stat_result.$factory()},\n    open: function(path, flags){return _b_.open(path, flags)},\n    stat: function(){return stat_result.$factory()},\n    urandom: function(n){\n        var randbytes = []\n        for(var i = 0; i < n; i++){\n            randbytes.push(_randint(0, 255))\n        }\n        return _b_.bytes.$factory(randbytes)\n    },\n    WTERMSIG: function(){return 0},\n    WNOHANG: function(){return _b_.tuple.$factory([0, 0])}\n};\n\n[\"WCOREDUMP\", \"WIFCONTINUED\", \"WIFSTOPPED\", \"WIFSIGNALED\", \"WIFEXITED\"].forEach(function(funcname){\n        $module[funcname] = function(){return false}\n    });\n\n[\"WEXITSTATUS\", \"WSTOPSIG\", \"WTERMSIG\"].\n    forEach(function(funcname){\n        $module[funcname] = function(){return _b_.None}\n    });\n\n[\"_exit\", \"_getdiskusage\", \"_getfileinformation\", \"_getfinalpathname\",\n    \"_getfullpathname\", \"_isdir\", \"abort\", \"access\", \"chdir\", \"chmod\",\n    \"close\", \"closerange\", \"device_encoding\", \"dup\", \"dup2\",\n    \"execv\", \"execve\", \"fsat\", \"fsync\", \"get_terminal_size\", \"getcwdb\",\n    \"getlogin\", \"getppid\", \"isatty\", \"kill\", \"link\", \"listdir\", \"lseek\",\n    \"mkdir\", \"pipe\", \"putenv\", \"read\", \"readlink\", \"remove\", \"rename\",\n    \"replace\", \"rmdir\", \"spawnv\", \"spawnve\", \"startfile\", \"stat_float_times\",\n    \"statvfs_result\", \"strerror\", \"symlink\", \"system\", \"terminal_size\",\n    \"times\", \"times_result\", \"umask\", \"uname_result\", \"unlink\", \"utime\",\n    \"waitpid\", \"write\"].forEach(function(funcname){\n        $module[funcname] = function(){\n            throw _b_.NotImplementedError.$factory(\"posix.\" + funcname +\n                \" is not implemented\")\n        }\n    });\n"], "random": [".js", "// Javascript implementation of the random module\n// Based on Ian Bicking's implementation of the Mersenne twister\n\nvar $module = (function($B){\n\nvar _b_ = $B.builtins,\n    i\n\nvar VERSION = 3\n\n// Code copied from https://github.com/ianb/whrandom/blob/master/mersenne.js\n// by Ian Bicking\n\n// this program is a JavaScript version of Mersenne Twister,\n// a straight conversion from the original program, mt19937ar.c,\n// translated by y. okada on july 17, 2006.\n// and modified a little at july 20, 2006, but there are not any substantial differences.\n// modularized by Ian Bicking, March 25, 2013 (found original version at http://www.math.sci.hiroshima-u.ac.jp/~m-mat/MT/VERSIONS/JAVASCRIPT/java-script.html)\n// in this program, procedure descriptions and comments of original source code were not removed.\n// lines commented with //c// were originally descriptions of c procedure. and a few following lines are appropriate JavaScript descriptions.\n// lines commented with /* and */ are original comments.\n// lines commented with // are additional comments in this JavaScript version.\n/*\n   A C-program for MT19937, with initialization improved 2002/1/26.\n   Coded by Takuji Nishimura and Makoto Matsumoto.\n\n   Before using, initialize the state by using init_genrand(seed)\n   or init_by_array(init_key, key_length).\n\n   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,\n   All rights reserved.\n\n   Redistribution and use in source and binary forms, with or without\n   modification, are permitted provided that the following conditions\n   are met:\n\n     1. Redistributions of source code must retain the above copyright\n        notice, this list of conditions and the following disclaimer.\n\n     2. Redistributions in binary form must reproduce the above copyright\n        notice, this list of conditions and the following disclaimer in the\n        documentation and/or other materials provided with the distribution.\n\n     3. The names of its contributors may not be used to endorse or promote\n        products derived from this software without specific prior written\n        permission.\n\n   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n   \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR\n   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,\n   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,\n   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR\n   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF\n   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING\n   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS\n   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n\n\n   Any feedback is very welcome.\n   http://www.math.sci.hiroshima-u.ac.jp/~m-mat/MT/emt.html\n   email: m-mat @ math.sci.hiroshima-u.ac.jp (remove space)\n*/\n\nfunction RandomStream(seed) {\n\n    /*jshint bitwise:false */\n    /* Period parameters */\n    //c//#define N 624\n    //c//#define M 397\n    //c//#define MATRIX_A 0x9908b0dfUL   /* constant vector a */\n    //c//#define UPPER_MASK 0x80000000UL /* most significant w-r bits */\n    //c//#define LOWER_MASK 0x7fffffffUL /* least significant r bits */\n    var N = 624\n    var M = 397\n    var MATRIX_A = 0x9908b0df   /* constant vector a */\n    var UPPER_MASK = 0x80000000 /* most significant w-r bits */\n    var LOWER_MASK = 0x7fffffff /* least significant r bits */\n    //c//static unsigned long mt[N]; /* the array for the state vector  */\n    //c//static int mti=N+1; /* mti==N+1 means mt[N] is not initialized */\n    var mt = new Array(N)   /* the array for the state vector  */\n    var mti = N + 1           /* mti==N+1 means mt[N] is not initialized */\n\n    function unsigned32(n1){\n        // returns a 32-bits unsiged integer from an operand to which applied a\n        // bit operator.\n        return n1 < 0 ? (n1 ^ UPPER_MASK) + UPPER_MASK : n1\n    }\n\n    function subtraction32(n1, n2){\n    // emulates lowerflow of a c 32-bits unsiged integer variable, instead of\n    // the operator -. these both arguments must be non-negative integers\n    // expressible using unsigned 32 bits.\n        return n1 < n2 ? unsigned32((0x100000000 - (n2 - n1)) & 0xffffffff) :\n          n1 - n2\n    }\n\n    function addition32(n1, n2){\n        // emulates overflow of a c 32-bits unsiged integer variable, instead of\n        // the operator +. these both arguments must be non-negative integers\n        // expressible using unsigned 32 bits.\n        return unsigned32((n1 + n2) & 0xffffffff)\n    }\n\n    function multiplication32(n1, n2){\n        // emulates overflow of a c 32-bits unsiged integer variable, instead of the\n        // operator *. these both arguments must be non-negative integers\n        // expressible using unsigned 32 bits.\n        var sum = 0\n        for (var i = 0; i < 32; ++i){\n            if((n1 >>> i) & 0x1){\n                sum = addition32(sum, unsigned32(n2 << i))\n            }\n        }\n        return sum\n    }\n\n    /* initializes mt[N] with a seed */\n    //c//void init_genrand(unsigned long s)\n    function init_genrand(s) {\n        //c//mt[0]= s & 0xffffffff;\n        mt[0] = unsigned32(s & 0xffffffff)\n        for(mti = 1; mti < N; mti++){\n            mt[mti] =\n                //c//(1812433253 * (mt[mti-1] ^ (mt[mti-1] >> 30)) + mti);\n                addition32(multiplication32(1812433253,\n                    unsigned32(mt[mti - 1] ^ (mt[mti - 1] >>> 30))), mti)\n            /* See Knuth TAOCP Vol2. 3rd Ed. P.106 for multiplier. */\n            /* In the previous versions, MSBs of the seed affect   */\n            /* only MSBs of the array mt[].                        */\n            /* 2002/01/09 modified by Makoto Matsumoto             */\n            //c//mt[mti] &= 0xffffffff;\n            mt[mti] = unsigned32(mt[mti] & 0xffffffff);\n            /* for >32 bit machines */\n        }\n    }\n\n    /* initialize by an array with array-length */\n    /* init_key is the array for initializing keys */\n    /* key_length is its length */\n    /* slight change for C++, 2004/2/26 */\n    //c//void init_by_array(unsigned long init_key[], int key_length)\n    function init_by_array(init_key, key_length) {\n        //c//int i, j, k;\n        var i, j, k\n        init_genrand(19650218)\n        i = 1\n        j = 0\n        k = (N > key_length ? N : key_length)\n        for(; k; k--){\n          //c//mt[i] = (mt[i] ^ ((mt[i-1] ^ (mt[i-1] >> 30)) * 1664525))\n          //c// + init_key[j] + j; /* non linear */\n          mt[i] = addition32(\n              addition32(unsigned32(mt[i] ^\n                  multiplication32(unsigned32(mt[i - 1] ^ (mt[i - 1] >>> 30)),\n                  1664525)),\n              init_key[j]), j)\n          mt[i] =\n              //c//mt[i] &= 0xffffffff; /* for WORDSIZE > 32 machines */\n              unsigned32(mt[i] & 0xffffffff)\n          i++\n          j++\n          if(i >= N){mt[0] = mt[N - 1]; i = 1}\n          if(j >= key_length){j = 0}\n        }\n        for(k = N - 1; k; k--){\n            //c//mt[i] = (mt[i] ^ ((mt[i-1] ^ (mt[i-1] >> 30)) * 1566083941))\n            //c//- i; /* non linear */\n            mt[i] = subtraction32(\n                unsigned32(\n                    (mt[i]) ^\n                        multiplication32(\n                            unsigned32(mt[i - 1] ^ (mt[i - 1] >>> 30)),\n                    1566083941)),\n                i\n            )\n            //c//mt[i] &= 0xffffffff; /* for WORDSIZE > 32 machines */\n            mt[i] = unsigned32(mt[i] & 0xffffffff)\n            i++\n            if(i >= N){mt[0] = mt[N - 1]; i = 1}\n        }\n        mt[0] = 0x80000000; /* MSB is 1; assuring non-zero initial array */\n    }\n\n    /* generates a random number on [0,0xffffffff]-interval */\n    //c//unsigned long genrand_int32(void)\n    function genrand_int32() {\n        //c//unsigned long y;\n        //c//static unsigned long mag01[2]={0x0UL, MATRIX_A};\n        var y;\n        var mag01 = [0x0, MATRIX_A];\n        /* mag01[x] = x * MATRIX_A  for x=0,1 */\n\n        if(mti >= N){ /* generate N words at one time */\n            //c//int kk;\n            var kk\n\n            if(mti == N + 1){   /* if init_genrand() has not been called, */\n              init_genrand(Date.now()) /* a default initial seed is used */\n            }\n\n            for(kk = 0; kk < N - M; kk++){\n              //c//y = (mt[kk]&UPPER_MASK)|(mt[kk+1]&LOWER_MASK);\n              //c//mt[kk] = mt[kk+M] ^ (y >> 1) ^ mag01[y & 0x1];\n              y = unsigned32((mt[kk]&UPPER_MASK) | (mt[kk + 1]&LOWER_MASK))\n              mt[kk] = unsigned32(mt[kk + M] ^ (y >>> 1) ^ mag01[y & 0x1])\n            }\n            for(;kk < N - 1; kk++){\n              //c//y = (mt[kk]&UPPER_MASK)|(mt[kk+1]&LOWER_MASK);\n              //c//mt[kk] = mt[kk+(M-N)] ^ (y >> 1) ^ mag01[y & 0x1];\n              y = unsigned32((mt[kk]&UPPER_MASK) | (mt[kk + 1]&LOWER_MASK))\n              mt[kk] = unsigned32(mt[kk + (M - N)] ^ (y >>> 1) ^ mag01[y & 0x1])\n            }\n            //c//y = (mt[N-1]&UPPER_MASK)|(mt[0]&LOWER_MASK);\n            //c//mt[N-1] = mt[M-1] ^ (y >> 1) ^ mag01[y & 0x1];\n            y = unsigned32((mt[N - 1] & UPPER_MASK) | (mt[0] & LOWER_MASK))\n            mt[N - 1] = unsigned32(mt[M - 1] ^ (y >>> 1) ^ mag01[y & 0x1])\n            mti = 0\n        }\n\n        y = mt[mti++]\n\n        /* Tempering */\n        //c//y ^= (y >> 11);\n        //c//y ^= (y << 7) & 0x9d2c5680;\n        //c//y ^= (y << 15) & 0xefc60000;\n        //c//y ^= (y >> 18);\n        y = unsigned32(y ^ (y >>> 11))\n        y = unsigned32(y ^ ((y << 7) & 0x9d2c5680))\n        y = unsigned32(y ^ ((y << 15) & 0xefc60000))\n        y = unsigned32(y ^ (y >>> 18))\n\n        return y\n    }\n\n    /* generates a random number on [0,0x7fffffff]-interval */\n    //c//long genrand_int31(void)\n    function genrand_int31(){\n        //c//return (genrand_int32()>>1);\n        return (genrand_int32()>>>1)\n    }\n\n    /* generates a random number on [0,1]-real-interval */\n    //c//double genrand_real1(void)\n    function genrand_real1(){\n        return genrand_int32()*(1.0/4294967295.0)\n        /* divided by 2^32-1 */\n    }\n\n    /* generates a random number on [0,1)-real-interval */\n    //c//double genrand_real2(void)\n    function genrand_real2(){\n        return genrand_int32() * (1.0 / 4294967296.0)\n        /* divided by 2^32 */\n    }\n\n    /* generates a random number on (0,1)-real-interval */\n    //c//double genrand_real3(void)\n    function genrand_real3() {\n        return ((genrand_int32()) + 0.5) * (1.0 / 4294967296.0)\n        /* divided by 2^32 */\n    }\n\n    /* generates a random number on [0,1) with 53-bit resolution*/\n    //c//double genrand_res53(void)\n    function genrand_res53() {\n        //c//unsigned long a=genrand_int32()>>5, b=genrand_int32()>>6;\n        var a = genrand_int32() >>> 5,\n            b = genrand_int32() >>> 6\n        return (a * 67108864.0 + b) * (1.0 / 9007199254740992.0)\n    }\n    /* These real versions are due to Isaku Wada, 2002/01/09 added */\n\n    var random = genrand_res53\n\n    random.seed = function(seed){\n        if(! seed){seed = Date.now()}\n        if(typeof seed != \"number\"){seed = parseInt(seed, 10)}\n        if((seed !== 0 && ! seed) || isNaN(seed)){throw \"Bad seed\"}\n        init_genrand(seed)\n    }\n\n    random.seed(seed)\n\n    random.int31 = genrand_int31\n    random.real1 = genrand_real1\n    random.real2 = genrand_real2\n    random.real3 = genrand_real3\n    random.res53 = genrand_res53\n\n    // Added for compatibility with Python\n    random.getstate = function(){return [VERSION, mt, mti]}\n\n    random.setstate = function(state){\n        mt = state[1]\n        mti = state[2]\n    }\n\n    return random\n\n}\n\n// magic constants\n\nvar NV_MAGICCONST = 4 * Math.exp(-0.5)/Math.sqrt(2),\n    gauss_next = null,\n    NV_MAGICCONST = 1.71552776992141,\n    TWOPI = 6.28318530718,\n    LOG4 = 1.38629436111989,\n    SG_MAGICCONST = 2.50407739677627,\n    VERSION = VERSION\n\nvar Random = $B.make_class(\"Random\",\n    function(){\n        return {\n            __class__: Random,\n            _random: RandomStream()\n        }\n    }\n)\n\nRandom._randbelow = function(self, x){\n    return Math.floor(x * self._random())\n}\n\nRandom._urandom = function(self, n){\n    /*\n    urandom(n) -> str\n    Return n random bytes suitable for cryptographic use.\n    */\n\n    var randbytes = []\n    for(i = 0; i < n; i++){randbytes.push(parseInt(self._random() * 256))}\n    return _b_.bytes.$factory(randbytes)\n}\n\nRandom.betavariate = function(){\n    /* Beta distribution.\n\n    Conditions on the parameters are alpha > 0 and beta > 0.\n    Returned values range between 0 and 1.\n\n\n    # This version due to Janne Sinkkonen, and matches all the std\n    # texts (e.g., Knuth Vol 2 Ed 3 pg 134 \"the beta distribution\").\n    */\n\n    var $ = $B.args('betavariate', 3, {self: null, alpha:null, beta:null},\n            ['self', 'alpha', 'beta'], arguments, {}, null, null),\n        self = $.self,\n        alpha = $.alpha,\n        beta = $.beta\n\n    var y = Random.gammavariate(self, alpha, 1)\n    if(y == 0){return _b_.float.$factory(0)}\n    else{return y / (y + Random.gammavariate(self, beta, 1))}\n}\n\nRandom.choice = function(){\n    var $ = $B.args(\"choice\", 2,\n        {self: null, seq:null},[\"self\", \"seq\"],arguments, {}, null, null),\n        self = $.self,\n        seq = $.seq\n    var len, rank\n    if(Array.isArray(seq)){len = seq.length}\n    else{len = _b_.getattr(seq,\"__len__\")()}\n    if(len == 0){\n        throw _b_.IndexError.$factory(\"Cannot choose from an empty sequence\")\n    }\n    rank = parseInt(self._random() * len)\n    if(Array.isArray(seq)){return seq[rank]}\n    else{return _b_.getattr(seq, \"__getitem__\")(rank)}\n}\n\nRandom.expovariate = function(self, lambd){\n    /*\n    Exponential distribution.\n\n    lambd is 1.0 divided by the desired mean.  It should be\n    nonzero.  (The parameter would be called \"lambda\", but that is\n    a reserved word in Python.)  Returned values range from 0 to\n    positive infinity if lambd is positive, and from negative\n    infinity to 0 if lambd is negative.\n\n    */\n    // lambd: rate lambd = 1/mean\n    // ('lambda' is a Python reserved word)\n\n    // we use 1-random() instead of random() to preclude the\n    // possibility of taking the log of zero.\n    return -Math.log(1.0 - self._random()) / lambd\n}\n\nRandom.gammavariate = function(self, alpha, beta){\n    /* Gamma distribution.  Not the gamma function!\n\n    Conditions on the parameters are alpha > 0 and beta > 0.\n\n    The probability distribution function is:\n\n                x ** (alpha - 1) * math.exp(-x / beta)\n      pdf(x) =  --------------------------------------\n                  math.gamma(alpha) * beta ** alpha\n\n    */\n\n    // alpha > 0, beta > 0, mean is alpha*beta, variance is alpha*beta**2\n\n    // Warning: a few older sources define the gamma distribution in terms\n    // of alpha > -1.0\n\n    var $ = $B.args('gammavariate', 3,\n            {self: null, alpha:null, beta:null},\n            ['self', 'alpha', 'beta'],\n            arguments, {}, null, null),\n        self = $.self,\n        alpha = $.alpha,\n        beta = $.beta,\n        LOG4 = Math.log(4),\n        SG_MAGICCONST = 1.0 + Math.log(4.5)\n\n    if(alpha <= 0.0 || beta <= 0.0){\n        throw _b_.ValueError.$factory('gammavariate: alpha and beta must be > 0.0')\n    }\n\n    if(alpha > 1.0){\n\n        // Uses R.C.H. Cheng, \"The generation of Gamma\n        // variables with non-integral shape parameters\",\n        // Applied Statistics, (1977), 26, No. 1, p71-74\n\n        var ainv = Math.sqrt(2.0 * alpha - 1.0),\n            bbb = alpha - LOG4,\n            ccc = alpha + ainv\n\n        while(true){\n            var u1 = self._random()\n            if(!((1e-7 < u1) && (u1 < .9999999))){\n                continue\n            }\n            var u2 = 1.0 - self._random(),\n                v = Math.log(u1 / (1.0 - u1)) / ainv,\n                x = alpha * Math.exp(v),\n                z = u1 * u1 * u2,\n                r = bbb + ccc * v - x\n            if((r + SG_MAGICCONST - 4.5 * z >= 0.0) || r >= Math.log(z)){\n                return x * beta\n            }\n        }\n    }else if(alpha == 1.0){\n        // expovariate(1)\n        var u = self._random()\n        while(u <= 1e-7){u = self._random()}\n        return -Math.log(u) * beta\n    }else{\n        // alpha is between 0 and 1 (exclusive)\n\n        // Uses ALGORITHM GS of Statistical Computing - Kennedy & Gentle\n\n        while(true){\n            var u = self._random(),\n                b = (Math.E + alpha)/Math.E,\n                p = b*u,\n                x\n            if(p <= 1.0){x = Math.pow(p, (1.0/alpha))}\n            else{x = -Math.log((b-p)/alpha)}\n            var u1 = self._random()\n            if(p > 1.0){\n                if(u1 <= Math.pow(x, alpha - 1.0)){\n                    break\n                }\n            }else if(u1 <= Math.exp(-x)){\n                break\n            }\n        }\n        return x * beta\n    }\n}\n\nRandom.gauss = function(){\n\n    /* Gaussian distribution.\n\n    mu is the mean, and sigma is the standard deviation.  This is\n    slightly faster than the normalvariate() function.\n\n    Not thread-safe without a lock around calls.\n\n    # When x and y are two variables from [0, 1), uniformly\n    # distributed, then\n    #\n    #    cos(2*pi*x)*sqrt(-2*log(1-y))\n    #    sin(2*pi*x)*sqrt(-2*log(1-y))\n    #\n    # are two *independent* variables with normal distribution\n    # (mu = 0, sigma = 1).\n    # (Lambert Meertens)\n    # (corrected version; bug discovered by Mike Miller, fixed by LM)\n\n    # Multithreading note: When two threads call this function\n    # simultaneously, it is possible that they will receive the\n    # same return value.  The window is very small though.  To\n    # avoid this, you have to use a lock around all calls.  (I\n    # didn't want to slow this down in the serial case by using a\n    # lock here.)\n    */\n\n    var $ = $B.args('gauss', 3, {self: null, mu:null, sigma:null},\n            ['self', 'mu', 'sigma'], arguments, {}, null, null),\n        self = $.self,\n        mu = $.mu,\n        sigma = $.sigma\n\n    var z = gauss_next\n    gauss_next = null\n    if(z === null){\n        var x2pi = self._random() * Math.PI * 2,\n            g2rad = Math.sqrt(-2.0 * Math.log(1.0 - self._random())),\n            z = Math.cos(x2pi) * g2rad\n        gauss_next = Math.sin(x2pi) * g2rad\n    }\n    return mu + z*sigma\n}\n\nRandom.getrandbits = function(){\n    var $ = $B.args(\"getrandbits\", 2,\n        {self: null, k:null},[\"self\", \"k\"],arguments, {}, null, null),\n        self = $.self,\n        k = $B.$GetInt($.k)\n    // getrandbits(k) -> x.  Generates a long int with k random bits.\n    if(k <= 0){\n        throw _b_.ValueError.$factory('number of bits must be greater than zero')\n    }\n    if(k != _b_.int.$factory(k)){\n        throw _b_.TypeError.$factory('number of bits should be an integer')\n    }\n    var numbytes = (k + 7), // bits / 8 and rounded up\n        x = _b_.int.from_bytes(Random._urandom(self, numbytes), 'big')\n    return _b_.getattr(x, '__rshift__')(\n        _b_.getattr(numbytes*8,'__sub__')(k))\n}\n\nRandom.getstate = function(){\n    // Return internal state; can be passed to setstate() later.\n    var $ = $B.args('getstate', 1, {self: null},\n        [\"self\"], arguments, {}, null, null)\n    return $.self._random.getstate()\n}\n\nRandom.lognormvariate = function(){\n    /*\n    Log normal distribution.\n\n    If you take the natural logarithm of this distribution, you'll get a\n    normal distribution with mean mu and standard deviation sigma.\n    mu can have any value, and sigma must be greater than zero.\n\n    */\n    return Math.exp(Random.normalvariate.apply(null, arguments))\n}\n\nRandom.normalvariate = function(){\n    /*\n    Normal distribution.\n\n    mu is the mean, and sigma is the standard deviation.\n\n    */\n\n    // mu = mean, sigma = standard deviation\n\n    // Uses Kinderman and Monahan method. Reference: Kinderman,\n    // A.J. and Monahan, J.F., \"Computer generation of random\n    // variables using the ratio of uniform deviates\", ACM Trans\n    // Math Software, 3, (1977), pp257-260.\n\n    var $ = $B.args(\"normalvariate\", 3,\n        {self: null, mu:null, sigma:null}, [\"self\", \"mu\", \"sigma\"],\n        arguments, {}, null, null),\n        self = $.self,\n        mu = $.mu,\n        sigma = $.sigma\n\n    while(true){\n        var u1 = self._random(),\n            u2 = 1.0 - self._random(),\n            z = NV_MAGICCONST * (u1 - 0.5) / u2,\n            zz = z * z / 4.0\n        if(zz <= -Math.log(u2)){break}\n    }\n    return mu + z * sigma\n}\n\nRandom.paretovariate = function(){\n    /* Pareto distribution.  alpha is the shape parameter.*/\n    // Jain, pg. 495\n\n    var $ = $B.args(\"paretovariate\", 2, {self: null, alpha:null},\n        [\"self\", \"alpha\"], arguments, {}, null, null)\n\n    var u = 1 - $.self._random()\n    return 1 / Math.pow(u, 1 / $.alpha)\n}\n\nRandom.randint = function(self, a, b){\n    var $ = $B.args('randint', 3,\n        {self: null, a:null, b:null},\n        ['self', 'a', 'b'],\n        arguments, {}, null, null)\n    return Random.randrange($.self, $.a, $.b + 1)\n}\n\nRandom.random = function(self){\n    return self._random()\n}\n\nRandom.randrange = function(){\n    var $ = $B.args('randrange', 4,\n        {self: null, x:null, stop:null, step:null},\n        ['self', 'x', 'stop', 'step'],\n        arguments, {stop:null, step:null}, null, null),\n        self = $.self,\n        _random = self._random\n        //console.log(\"randrange\", $)\n\n    if($.stop === null){\n        var start = 0, stop = $.x, step = 1\n    }else{\n        var start = $.x, stop = $.stop,\n            step = $.step === null ? 1 : $.step\n        if(step == 0){throw _b_.ValueError.$factory('step cannot be 0')}\n    }\n    if((step > 0 && start > stop) || (step < 0 && start < stop)){\n        throw _b_.ValueError.$factory(\"empty range for randrange() (\" +\n            start + \", \" + stop + \", \" + step + \")\")\n    }\n    if(typeof start == 'number' && typeof stop == 'number' &&\n        typeof step == 'number'){\n        return start + step * Math.floor(_random() *\n            Math.ceil((stop - start) / step))\n    }else{\n        var d = _b_.getattr(stop, '__sub__')(start)\n        d = _b_.getattr(d, '__floordiv__')(step)\n        // Force d to be a LongInt\n        d = $B.long_int.$factory(d)\n        // d is a long integer with n digits ; to choose a random number\n        // between 0 and d the most simple is to take a random digit\n        // at each position, except the first one\n        var s = d.value,\n            _len = s.length,\n            res = Math.floor(_random() * (parseInt(s.charAt(0)) +\n                (_len == 1 ? 0 : 1))) + ''\n        var same_start = res.charAt(0) == s.charAt(0)\n        for(var i = 1; i < _len; i++){\n            if(same_start){\n                // If it's the last digit, don't allow stop as valid\n                if(i == _len - 1){\n                    res += Math.floor(_random() * parseInt(s.charAt(i))) + ''\n                }else{\n                    res += Math.floor(_random() *\n                        (parseInt(s.charAt(i)) + 1)) + ''\n                    same_start = res.charAt(i) == s.charAt(i)\n                }\n            }else{\n                res += Math.floor(_random() * 10) + ''\n            }\n        }\n        var offset = {__class__: $B.long_int, value: res,\n            pos: true}\n        d = _b_.getattr(step, '__mul__')(offset)\n        d = _b_.getattr(start, '__add__')(d)\n        return _b_.int.$factory(d)\n    }\n}\n\nRandom.sample = function(){\n    /*\n    Chooses k unique random elements from a population sequence or set.\n\n    Returns a new list containing elements from the population while\n    leaving the original population unchanged.  The resulting list is\n    in selection order so that all sub-slices will also be valid random\n    samples.  This allows raffle winners (the sample) to be partitioned\n    into grand prize and second place winners (the subslices).\n\n    Members of the population need not be hashable or unique.  If the\n    population contains repeats, then each occurrence is a possible\n    selection in the sample.\n\n    To choose a sample in a range of integers, use range as an argument.\n    This is especially fast and space efficient for sampling from a\n    large population:   sample(range(10000000), 60)\n\n    # Sampling without replacement entails tracking either potential\n    # selections (the pool) in a list or previous selections in a set.\n\n    # When the number of selections is small compared to the\n    # population, then tracking selections is efficient, requiring\n    # only a small set and an occasional reselection.  For\n    # a larger number of selections, the pool tracking method is\n    # preferred since the list takes less space than the\n    # set and it doesn't suffer from frequent reselections.'\n\n    */\n    var $ = $B.args('sample', 3, {self: null, population: null,k: null},\n        ['self', 'population','k'], arguments, {}, null, null),\n        self = $.self,\n        population = $.population,\n        k = $.k\n\n    if(!_b_.hasattr(population, '__len__')){\n        throw _b_.TypeError.$factory(\"Population must be a sequence or set. \" +\n            \"For dicts, use list(d).\")\n    }\n    var n = _b_.getattr(population, '__len__')()\n\n    if(k < 0 || k > n){\n        throw _b_.ValueError.$factory(\"Sample larger than population\")\n    }\n    var result = [],\n        setsize = 21        // size of a small set minus size of an empty list\n    if(k > 5){\n        setsize += Math.pow(4, Math.ceil(Math.log(k * 3, 4))) // table size for big sets\n    }\n    if(n <= setsize){\n        // An n-length list is smaller than a k-length set\n        if(Array.isArray(population)){\n            var pool = population.slice()\n        }else{var pool = _b_.list.$factory(population)}\n        for(var i = 0; i < k; i++){ //invariant:  non-selected at [0,n-i)\n            var j = Random._randbelow(self, n - i)\n            result[i] = pool[j]\n            pool[j] = pool[n - i - 1]   // move non-selected item into vacancy\n        }\n    }else{\n        selected = {}\n        for(var i = 0; i < k; i++){\n            var j = Random._randbelow(self, n)\n            while(selected[j] !== undefined){\n                j = Random._randbelow(self, n)\n            }\n            selected[j] = true\n            result[i] = Array.isArray(population) ? population[j] :\n                            _b_.getattr(population, '__getitem__')(j)\n        }\n    }\n    return result\n}\n\nRandom.seed = function(){\n    /*\n    Initialize internal state from hashable object.\n\n    None or no argument seeds from current time or from an operating\n    system specific randomness source if available.\n\n    If *a* is an int, all bits are used.\n    */\n    var $ = $B.args('seed', 3, {self: null, a: null, version: null},\n        ['self', 'a', 'version'],\n        arguments, {a: new Date(), version: 2}, null, null),\n        self = $.self,\n        a = $.a,\n        version = $.version\n\n    if(version == 1){a = _b_.hash(a)}\n    else if(version == 2){\n        if(_b_.isinstance(a, _b_.str)){\n            a = _b_.int.from_bytes(_b_.bytes.$factory(a, 'utf-8'), 'big')\n        }else if(_b_.isinstance(a, [_b_.bytes, _b_.bytearray])){\n            a = _b_.int.from_bytes(a, 'big')\n        }else if(!_b_.isinstance(a, _b_.int)){\n            throw _b_.TypeError.$factory('wrong argument')\n        }\n        if(a.__class__ === $B.long_int){\n            // In this implementation, seed() only accepts safe integers\n            // Generate a random one from the underlying string value,\n            // using an arbitrary seed (99) to always return the same\n            // integer\n            var numbers = a.value,\n                res = '',\n                pos\n            self._random.seed(99)\n            for(var i = 0; i < 17; i++){\n                pos = parseInt(self._random() * numbers.length)\n                res += numbers.charAt(pos)\n            }\n            a = parseInt(res)\n        }\n    }else{\n        throw ValueError.$factory('version can only be 1 or 2')\n    }\n\n    self._random.seed(a)\n    gauss_next = null\n}\n\nRandom.setstate = function(state){\n    // Restore internal state from object returned by getstate().\n    var $ = $B.args('setstate', 2, {self: null, state:null}, ['self', 'state'],\n        arguments, {}, null, null),\n        self = $.self\n    var state = self._random.getstate()\n    if(! Array.isArray($.state)){\n        throw _b_.TypeError.$factory('state must be a list, not ' +\n            $B.class_name($.state))\n    }\n    if($.state.length < state.length){\n        throw _b_.ValueError.$factory(\"need more than \" + $.state.length +\n            \" values to unpack\")\n    }else if($.state.length > state.length){\n        throw _b_.ValueError.$factory(\"too many values to unpack (expected \" +\n            state.length + \")\")\n    }\n    if($.state[0] != 3){\n        throw _b_.ValueError.$factory(\"ValueError: state with version \" +\n            $.state[0] + \" passed to Random.setstate() of version 3\")\n    }\n    var second = _b_.list.$factory($.state[1])\n    if(second.length !== state[1].length){\n        throw _b_.ValueError.$factory('state vector is the wrong size')\n    }\n    for(var i = 0; i < second.length; i++){\n        if(typeof second[i] != 'number'){\n            throw _b_.ValueError.$factory('state vector items must be integers')\n        }\n    }\n    self._random.setstate($.state)\n}\n\nRandom.shuffle = function(x, random){\n    /*\n    x, random = random.random -> shuffle list x in place; return None.\n\n    Optional arg random is a 0-argument function returning a random\n    float in [0.0, 1.0); by default, the standard random.random.\n    */\n\n    var $ = $B.args('shuffle', 3, {self: null, x: null, random: null},\n        ['self', 'x','random'],\n        arguments, {random: null}, null, null),\n        self = $.self,\n        x = $.x,\n        random = $.random\n\n    if(random === null){random = self._random}\n\n    if(Array.isArray(x)){\n        for(var i = x.length - 1; i >= 0;i--){\n            var j = Math.floor(random() * (i + 1)),\n                temp = x[j]\n            x[j] = x[i]\n            x[i] = temp\n        }\n    }else{\n        var len = _b_.getattr(x, '__len__')(), temp,\n            x_get = _b_.getattr(x, '__getitem__'),\n            x_set = _b_.getattr(x, '__setitem__')\n\n        for(i = len - 1; i >= 0; i--){\n            var j = Math.floor(random() * (i + 1)),\n                temp = x_get(j)\n            x_set(j, x_get(i))\n            x_set(i, temp)\n        }\n    }\n}\n\nRandom.triangular = function(){\n    /*\n    Triangular distribution.\n\n    Continuous distribution bounded by given lower and upper limits,\n    and having a given mode value in-between.\n\n    http://en.wikipedia.org/wiki/Triangular_distribution\n    */\n    var $ = $B.args('triangular', 4,\n        {self: null, low: null, high: null, mode: null},\n        ['self', 'low', 'high', 'mode'],\n        arguments, {low: 0, high: 1, mode: null}, null, null),\n        low = $.low,\n        high = $.high,\n        mode = $.mode\n\n    var u = $.self._random(),\n        c = mode === null ? 0.5 : (mode - low) / (high - low)\n    if(u > c){\n        u = 1 - u\n        c = 1 - c\n        var temp = low\n        low = high\n        high = temp\n    }\n    return low + (high - low) * Math.pow(u * c, 0.5)\n}\n\nRandom.uniform = function(){\n    var $ = $B.args('uniform', 3, {self: null, a: null, b: null},\n        ['self', 'a', 'b'], arguments, {}, null, null),\n        a = $B.$GetInt($.a),\n        b = $B.$GetInt($.b)\n\n    return a + (b - a) * $.self._random()\n}\n\nRandom.vonmisesvariate = function(){\n    /* Circular data distribution.\n\n    mu is the mean angle, expressed in radians between 0 and 2*pi, and\n    kappa is the concentration parameter, which must be greater than or\n    equal to zero.  If kappa is equal to zero, this distribution reduces\n    to a uniform random angle over the range 0 to 2*pi.\n\n    */\n    // mu:    mean angle (in radians between 0 and 2*pi)\n    // kappa: concentration parameter kappa (>= 0)\n    // if kappa = 0 generate uniform random angle\n\n    // Based upon an algorithm published in: Fisher, N.I.,\n    // \"Statistical Analysis of Circular Data\", Cambridge\n    // University Press, 1993.\n\n    // Thanks to Magnus Kessler for a correction to the\n    // implementation of step 4.\n\n    var $ = $B.args('vonmisesvariate', 3,\n            {self: null, mu: null, kappa:null}, ['self', 'mu', 'kappa'],\n            arguments, {}, null, null),\n        self = $.self,\n        mu = $.mu,\n        kappa = $.kappa,\n        TWOPI = 2*Math.PI\n\n    if(kappa <= 1e-6){return TWOPI * self._random()}\n\n    var s = 0.5 / kappa,\n        r = s + Math.sqrt(1.0 + s * s)\n\n    while(true){\n        var u1 = self._random(),\n            z = Math.cos(Math.PI * u1),\n            d = z / (r + z),\n            u2 = self._random()\n        if((u2 < 1.0 - d * d) ||\n            (u2 <= (1.0 - d) * Math.exp(d))){\n                break\n        }\n    }\n    var q = 1.0 / r,\n        f = (q + z) / (1.0 + q * z),\n        u3 = self._random()\n    if(u3 > 0.5){var theta = (mu + Math.acos(f)) % TWOPI}\n    else{var theta = (mu - Math.acos(f)) % TWOPI}\n    return theta\n}\n\nRandom.weibullvariate = function(){\n    /*Weibull distribution.\n\n    alpha is the scale parameter and beta is the shape parameter.\n\n    */\n    // Jain, pg. 499; bug fix courtesy Bill Arms\n    var $ = $B.args(\"weibullvariate\", 3,\n        {self: null, alpha: null, beta: null},\n        [\"self\", \"alpha\", \"beta\"], arguments, {}, null, null)\n\n    var u = 1 - $.self._random()\n    return $.alpha * Math.pow(-Math.log(u), 1 / $.beta)\n}\n\n$B.set_func_names(Random, \"random\")\n\nvar $module = Random.$factory()\nfor(var attr in Random){\n    $module[attr] = (function(x){\n        return function(){return Random[x]($module, ...arguments)}\n    })(attr)\n    $module[attr].$infos = Random[attr].$infos\n}\n\n$module.Random = Random\n\nvar SystemRandom = $B.make_class(\"SystemRandom\",\n    function(){\n        return {__class__: SystemRandom}\n    }\n)\nSystemRandom.__getattribute__ = function(){\n    throw $B.builtins.NotImplementedError.$factory()\n}\n\n$module.SystemRandom = SystemRandom\n\nreturn $module\n\n})(__BRYTHON__)\n\n"], "zlib": [".js", "var $module = (function($B){\n\n_b_ = $B.builtins\n\n// copied from https://stackoverflow.com/questions/18638900/javascript-crc32\n// by Denys S\u00e9guret\nvar a_table = \"00000000 77073096 EE0E612C 990951BA 076DC419 706AF48F E963A535 9E6495A3 0EDB8832 79DCB8A4 E0D5E91E 97D2D988 09B64C2B 7EB17CBD E7B82D07 90BF1D91 1DB71064 6AB020F2 F3B97148 84BE41DE 1ADAD47D 6DDDE4EB F4D4B551 83D385C7 136C9856 646BA8C0 FD62F97A 8A65C9EC 14015C4F 63066CD9 FA0F3D63 8D080DF5 3B6E20C8 4C69105E D56041E4 A2677172 3C03E4D1 4B04D447 D20D85FD A50AB56B 35B5A8FA 42B2986C DBBBC9D6 ACBCF940 32D86CE3 45DF5C75 DCD60DCF ABD13D59 26D930AC 51DE003A C8D75180 BFD06116 21B4F4B5 56B3C423 CFBA9599 B8BDA50F 2802B89E 5F058808 C60CD9B2 B10BE924 2F6F7C87 58684C11 C1611DAB B6662D3D 76DC4190 01DB7106 98D220BC EFD5102A 71B18589 06B6B51F 9FBFE4A5 E8B8D433 7807C9A2 0F00F934 9609A88E E10E9818 7F6A0DBB 086D3D2D 91646C97 E6635C01 6B6B51F4 1C6C6162 856530D8 F262004E 6C0695ED 1B01A57B 8208F4C1 F50FC457 65B0D9C6 12B7E950 8BBEB8EA FCB9887C 62DD1DDF 15DA2D49 8CD37CF3 FBD44C65 4DB26158 3AB551CE A3BC0074 D4BB30E2 4ADFA541 3DD895D7 A4D1C46D D3D6F4FB 4369E96A 346ED9FC AD678846 DA60B8D0 44042D73 33031DE5 AA0A4C5F DD0D7CC9 5005713C 270241AA BE0B1010 C90C2086 5768B525 206F85B3 B966D409 CE61E49F 5EDEF90E 29D9C998 B0D09822 C7D7A8B4 59B33D17 2EB40D81 B7BD5C3B C0BA6CAD EDB88320 9ABFB3B6 03B6E20C 74B1D29A EAD54739 9DD277AF 04DB2615 73DC1683 E3630B12 94643B84 0D6D6A3E 7A6A5AA8 E40ECF0B 9309FF9D 0A00AE27 7D079EB1 F00F9344 8708A3D2 1E01F268 6906C2FE F762575D 806567CB 196C3671 6E6B06E7 FED41B76 89D32BE0 10DA7A5A 67DD4ACC F9B9DF6F 8EBEEFF9 17B7BE43 60B08ED5 D6D6A3E8 A1D1937E 38D8C2C4 4FDFF252 D1BB67F1 A6BC5767 3FB506DD 48B2364B D80D2BDA AF0A1B4C 36034AF6 41047A60 DF60EFC3 A867DF55 316E8EEF 4669BE79 CB61B38C BC66831A 256FD2A0 5268E236 CC0C7795 BB0B4703 220216B9 5505262F C5BA3BBE B2BD0B28 2BB45A92 5CB36A04 C2D7FFA7 B5D0CF31 2CD99E8B 5BDEAE1D 9B64C2B0 EC63F226 756AA39C 026D930A 9C0906A9 EB0E363F 72076785 05005713 95BF4A82 E2B87A14 7BB12BAE 0CB61B38 92D28E9B E5D5BE0D 7CDCEFB7 0BDBDF21 86D3D2D4 F1D4E242 68DDB3F8 1FDA836E 81BE16CD F6B9265B 6FB077E1 18B74777 88085AE6 FF0F6A70 66063BCA 11010B5C 8F659EFF F862AE69 616BFFD3 166CCF45 A00AE278 D70DD2EE 4E048354 3903B3C2 A7672661 D06016F7 4969474D 3E6E77DB AED16A4A D9D65ADC 40DF0B66 37D83BF0 A9BCAE53 DEBB9EC5 47B2CF7F 30B5FFE9 BDBDF21C CABAC28A 53B39330 24B4A3A6 BAD03605 CDD70693 54DE5729 23D967BF B3667A2E C4614AB8 5D681B02 2A6F2B94 B40BBE37 C30C8EA1 5A05DF1B 2D02EF8D\";\nvar b_table = a_table.split(' ').map(function(s){ return parseInt(s,16) });\nfunction crc32 (str) {\n    var crc = -1;\n    for(var i=0, iTop=str.length; i<iTop; i++) {\n        crc = ( crc >>> 8 ) ^ b_table[( crc ^ str.charCodeAt( i ) ) & 0xFF];\n    }\n    return (crc ^ (-1)) >>> 0;\n};\n\nreturn  {\n    DEFLATED: 8,\n\n    DEF_BUF_SIZE: 16384,\n\n    DEF_MEM_LEVEL: 8,\n\n    MAX_WBITS: 15,\n\n    ZLIB_RUNTIME_VERSION: \"1.2.11\",\n\n    ZLIB_VERSION: \"1.2.11\",\n\n    Z_BEST_COMPRESSION: 9,\n\n    Z_BEST_SPEED: 1,\n\n    Z_BLOCK: 5,\n\n    Z_DEFAULT_COMPRESSION: -1,\n\n    Z_DEFAULT_STRATEGY: 0,\n\n    Z_FILTERED: 1,\n\n    Z_FINISH: 4,\n\n    Z_FIXED: 4,\n\n    Z_FULL_FLUSH: 3,\n\n    Z_HUFFMAN_ONLY: 2,\n\n    Z_NO_COMPRESSION: 0,\n\n    Z_NO_FLUSH: 0,\n\n    Z_PARTIAL_FLUSH: 1,\n\n    Z_RLE: 3,\n\n    Z_SYNC_FLUSH: 2,\n\n    Z_TREES: 6,\n\n    __version__: \"1.0\",\n\n    crc32: crc32,\n\n    compress: function(data){return data},\n\n    decompress: function(data){return data}\n\n}\n\n})(__BRYTHON__)\n"], "_aio": [".js", "// Replacement for asyncio.\n//\n// CPython asyncio can't be implemented for Brython because it relies on\n// blocking function (eg run(), run_until_complete()), and such functions\n// can't be defined in Javascript. It also manages an event loop, and a\n// browser only has its own built-in event loop.\n//\n// This module exposes functions whose result can be \"await\"-ed inside\n// asynchrounous functions defined by \"async def\".\n\nvar $module = (function($B){\n\nvar _b_ = $B.builtins\n\nvar responseType = {\n    \"text\": \"text\",\n    \"binary\": \"arraybuffer\",\n    \"dataURL\": \"arraybuffer\"\n}\n\nfunction handle_kwargs(kw, method){\n    var data,\n        cache = \"no-cache\",\n        format = \"text\",\n        headers = {},\n        timeout = {}\n    for(var key in kw.$string_dict){\n        if(key == \"data\"){\n            var params = kw.$string_dict[key]\n            if(typeof params == \"string\"){\n                data = params\n            }else{\n                if(params.__class__ !== _b_.dict){\n                    throw _b_.TypeError.$factory(\"wrong type for data, \" +\n                        \"expected dict or str, got \" + $B.class_name(params))\n                }\n                params = params.$string_dict\n                var items = []\n                for(var key in params){\n                    items.push(encodeURIComponent(key) + \"=\" +\n                               encodeURIComponent(params[key]))\n                }\n                data = items.join(\"&\")\n            }\n        }else if(key == \"headers\"){\n            headers = kw.$string_dict[key].$string_dict\n        }else if(key.startsWith(\"on\")){\n            var event = key.substr(2)\n            if(event == \"timeout\"){\n                timeout.func = kw.$string_dict[key]\n            }else{\n                ajax.bind(self, event, kw.$string_dict[key])\n            }\n        }else if(key == \"timeout\"){\n            timeout.seconds = kw.$string_dict[key]\n        }else if(key == \"cache\"){\n            cache = kw.$string_dict[key]\n        }else if(key == \"format\"){\n            format = kw.$string_dict[key]\n        }\n    }\n    if(method == \"post\"){\n        // For POST requests, set default header\n        if(! headers.hasOwnProperty(\"Content-type\")){\n            headers[\"Content-Type\"] = \"application/x-www-form-urlencoded\"\n        }\n        if(data && !headers.hasOwnProperty(\"Content-Length\")){\n            headers[\"Content-Length\"] = data.length\n        }\n    }\n    return {\n        body: data,\n        cache: cache,\n        format: format,\n        timeout: timeout,\n        headers: headers\n    }\n}\n\nfunction ajax(){\n    var $ = $B.args(\"ajax\", 2, {method: null, url: null},\n            [\"method\", \"url\"], arguments, {},\n            null, \"kw\"),\n        method = $.method,\n        url = $.url,\n        kw = $.kw\n    var args = handle_kwargs(kw, \"get\")\n    if(! args.cache){\n        url = \"?ts\" + (new Date()).getTime() + \"=0\"\n    }\n    if(args.body){\n        url = url + (args.cache ? \"?\" : \"&\") + args.body\n    }\n    return {\n        __class__: $B.coroutine,\n        $args: [url, args],\n        $func: function(){\n            return new Promise(function(resolve, reject){\n                var xhr = new XMLHttpRequest()\n                xhr.open(method, url, true)\n                for(key in args.headers){\n                    xhr.setRequestHeader(key, args.headers[key])\n                }\n                xhr.format = args.format\n                xhr.responseType = responseType[args.format]\n                xhr.onreadystatechange = function(){\n                    if(this.readyState == 4){\n                        this.__class__ = HTTPRequest\n                        resolve(this)\n                    }\n                }\n                xhr.send()\n            })\n        }\n    }\n}\n\nfunction event(){\n    // event(element, name) is a Promise on the event \"name\" happening on the\n    // element. This promise always resolves (never rejects) with the DOM event.\n    var $ = $B.args(\"event\", 2, {element: null, name: null},\n            [\"element\", \"name\"], arguments, {}, null, null),\n        element = $.element,\n        name = $.name\n    return new Promise(function(resolve){\n        element.elt.addEventListener(name, function(evt){\n            resolve($B.$DOMEvent(evt))\n        })\n    })\n}\n\nvar HTTPRequest = $B.make_class(\"Request\")\n\nHTTPRequest.data = _b_.property.$factory(function(self){\n    if(self.format == \"binary\"){\n        var view = new Uint8Array(self.response)\n        return _b_.bytes.$factory(Array.from(view))\n    }else if(self.format == \"text\"){\n        return self.responseText\n    }else if(self.format == \"dataURL\"){\n        var base64String = btoa(String.fromCharCode.apply(null,\n            new Uint8Array(self.response)))\n        return \"data:\" + self.getResponseHeader(\"Content-Type\") +\n            \";base64,\" + base64String\n    }\n})\n\nHTTPRequest.response_headers = _b_.property.$factory(function(self){\n    var headers = self.getAllResponseHeaders()\n    if(headers === null){return _b_.None}\n    var res = _b_.dict.$factory()\n    if(headers.length > 0){\n        // Convert the header string into an array\n        // of individual headers\n        var lines = headers.trim().split(/[\\r\\n]+/)\n        // Create a map of header names to values\n        lines.forEach(function(line){\n          var parts = line.split(': ')\n          var header = parts.shift()\n          var value = parts.join(': ')\n          res.$string_dict[header] = value\n        })\n    }\n    return res\n})\n\nfunction get(){\n    var args = [\"GET\"]\n    for(var i = 0, len = arguments.length; i < len; i++){\n        args.push(arguments[i])\n    }\n    return ajax.apply(null, args)\n}\n\nfunction iscoroutine(f){\n    return f.__class__ === $B.coroutine\n}\n\nfunction iscoroutinefunction(f){\n    return (f.$infos.__code__.co_flags & 128) != 0\n}\n\nfunction post(){\n    var args = [\"POST\"]\n    for(var i = 0, len = arguments.length; i < len; i++){\n        args.push(arguments[i])\n    }\n    return ajax.apply(null, args)\n}\n\nfunction run(coro){\n    var handle_success = function(){\n            $B.leave_frame()\n        },\n        handle_error = function(ev){\n            var err_msg = \"Traceback (most recent call last):\\n\"\n            err_msg += $B.print_stack(ev.$stack)\n            err_msg += \"\\n\" + ev.__class__.$infos.__name__ +\n                ': ' + ev.args[0]\n            $B.builtins.print(err_msg)\n            throw ev\n        }\n\n    var $ = $B.args(\"run\", 3, {coro: null, onsuccess: null, onerror: null},\n            [\"coro\", \"onsuccess\", \"onerror\"], arguments,\n            {onsuccess: handle_success, onerror: handle_error},\n            null, null),\n        coro = $.coro,\n        onsuccess = $.onsuccess,\n        onerror = $.onerror\n\n    if(onerror !== handle_error){\n        function error_func(exc){\n            try{\n                onerror(exc)\n            }catch(err){\n                handle_error(err)\n            }\n        }\n    }else{\n        error_func = handle_error\n    }\n    $B.coroutine.send(coro).then(onsuccess).catch(error_func)\n    return _b_.None\n}\n\nfunction sleep(seconds){\n    return {\n        __class__: $B.coroutine,\n        $args: [seconds],\n        $func: function(){\n            return new Promise(resolve => setTimeout(resolve, 1000 * seconds))\n        }\n    }\n}\n\nreturn {\n    ajax: ajax,\n    event: event,\n    get: get,\n    iscoroutine: iscoroutine,\n    iscoroutinefunction: iscoroutinefunction,\n    post: post,\n    run: run,\n    sleep: sleep\n}\n\n})(__BRYTHON__)\n"], "_ajax": [".js", "// ajax\nvar $module = (function($B){\n\neval($B.InjectBuiltins())\nvar $N = $B.builtins.None,\n    _b_ = $B.builtins\n\nvar add_to_res = function(res, key, val) {\n    if(isinstance(val, list)){\n        for (j = 0; j < val.length; j++) {\n            add_to_res(res, key, val[j])\n        }\n    }else if (val instanceof File || val instanceof Blob){\n        res.append(key, val)\n    }else{res.append(key,str.$factory(val))}\n}\n\nfunction set_timeout(self, timeout){\n    if(timeout.seconds !== undefined){\n        self.js.$requestTimer = setTimeout(\n            function() {\n                self.js.abort()\n                if(timeout.func){\n                    timeout.func()\n                }\n            },\n            timeout.seconds * 1000)\n    }\n}\n\nfunction handle_kwargs(self, kw, method){\n    var data,\n        headers,\n        cache,\n        timeout = {}\n    for(var key in kw.$string_dict){\n        if(key == \"data\"){\n            var params = kw.$string_dict[key]\n            if(typeof params == \"string\"){\n                data = params\n            }else{\n                if(params.__class__ !== _b_.dict){\n                    throw _b_.TypeError.$factory(\"wrong type for data, \" +\n                        \"expected dict or str, got \" + $B.class_name(params))\n                }\n                params = params.$string_dict\n                var items = []\n                for(var key in params){\n                    items.push(encodeURIComponent(key) + \"=\" +\n                               encodeURIComponent(params[key]))\n                }\n                data = items.join(\"&\")\n            }\n        }else if(key==\"headers\"){\n            headers = kw.$string_dict[key].$string_dict\n            for(var key in headers){\n                self.js.setRequestHeader(key, headers[key])\n            }\n        }else if(key.startsWith(\"on\")){\n            var event = key.substr(2)\n            if(event == \"timeout\"){\n                timeout.func = kw.$string_dict[key]\n            }else{\n                ajax.bind(self, event, kw.$string_dict[key])\n            }\n        }else if(key == \"timeout\"){\n            timeout.seconds = kw.$string_dict[key]\n        }else if(key == \"cache\"){\n            cache = kw.$string_dict[key]\n        }\n    }\n    if(method == \"post\" && ! headers){\n        // For POST requests, set default header\n        self.js.setRequestHeader(\"Content-type\",\n                                 \"application/x-www-form-urlencoded\")\n    }\n    return {cache: cache, data:data, timeout: timeout}\n}\n\nvar ajax = {\n    __class__: _b_.type,\n    __mro__: [$B.JSObject, _b_.object],\n\n    __getattribute__ : function(self, attr){\n        // Special case for send : accept dict as parameters\n        if(attr == 'send'){\n            return function(params){\n                return ajax.send(self, params)\n            }\n        }\n        // Otherwise default to JSObject method\n        return $B.JSObject.__getattribute__(self, attr)\n    },\n\n    __repr__ : function(self){return '<object Ajax>'},\n    __str__ : function(self){return '<object Ajax>'},\n\n    $infos: {\n        __module__: \"builtins\",\n        __name__: \"ajax\"\n    },\n\n    bind : function(self, evt, func){\n        // req.bind(evt,func) is the same as req.onevt = func\n        self.js['on' + evt] = function(){\n            try{\n                return func.apply(null, arguments)\n            }catch(err){\n                if(err.__class__ !== undefined){\n                    var msg = _b_.getattr(err, 'info') +\n                        '\\n' + err.__class__.$infos.__name__\n                    if(err.args){msg += ': ' + err.args[0]}\n                    try{getattr($B.stderr, \"write\")(msg)}\n                    catch(err){console.log(msg)}\n                }else{\n                    try{getattr($B.stderr, \"write\")(err)}\n                    catch(err1){console.log(err)}\n                }\n            }\n        }\n        return $N\n    },\n\n    send : function(self, params){\n        // params can be Python dictionary or string\n        var res = ''\n        if(!params){\n            self.js.send()\n            return $N\n        }else if(isinstance(params, str)){\n            res = params\n        }else if(isinstance(params, dict)){\n            if(self.headers['content-type'] == 'multipart/form-data'){\n                // The FormData object serializes the data in the 'multipart/form-data'\n                // content-type so we may as well override that header if it was set\n                // by the user.\n                res = new FormData()\n                var items = _b_.list.$factory(_b_.dict.items(params))\n                for(var i = 0, len = items.length; i < len; i++){\n                    add_to_res(res, str.$factory(items[i][0]), items[i][1])\n                }\n            }else{\n                var items = _b_.list.$factory(_b_.dict.items(params))\n                for(var i = 0, len = items.length; i < len; i++){\n                    var key = encodeURIComponent(str.$factory(items[i][0]));\n                    if(isinstance(items[i][1], list)){\n                        for (j = 0; j < items[i][1].length; j++) {\n                            res += key +'=' +\n                                encodeURIComponent(str.$factory(items[i][1][j])) + '&'\n                        }\n                    }else{\n                        res += key + '=' +\n                            encodeURIComponent(str.$factory(items[i][1])) + '&'\n                    }\n                }\n                res = res.substr(0, res.length - 1)\n            }\n        }else{\n            throw _b_.TypeError(\"send() argument must be string or dictionary, not '\" +\n                str.$factory(params.__class__) + \"'\")\n        }\n        self.js.send(res)\n        return $N\n    },\n\n    set_header : function(self,key,value){\n        self.js.setRequestHeader(key,value)\n        self.headers[key.toLowerCase()] = value.toLowerCase()\n    },\n\n    set_timeout : function(self, seconds, func){\n        self.js.$requestTimer = setTimeout(\n            function() {self.js.abort();func()},\n            seconds * 1000)\n    }\n}\n\najax.$factory = function(){\n\n    if(window.XMLHttpRequest){// code for IE7+, Firefox, Chrome, Opera, Safari\n        var xmlhttp = new XMLHttpRequest()\n    }else{// code for IE6, IE5\n        var xmlhttp = new ActiveXObject(\"Microsoft.XMLHTTP\")\n    }\n    xmlhttp.onreadystatechange = function(){\n        // here, \"this\" refers to xmlhttp\n        var state = this.readyState\n        if(this.responseType == \"\" || this.responseType == \"text\"){\n            res.js.text = this.responseText\n        }\n        var timer = this.$requestTimer\n        if(state == 0 && this.onuninitialized){this.onuninitialized(res)}\n        else if(state == 1 && this.onloading){this.onloading(res)}\n        else if(state == 2 && this.onloaded){this.onloaded(res)}\n        else if(state == 3 && this.oninteractive){this.oninteractive(res)}\n        else if(state == 4 && this.oncomplete){\n            if(timer !== null){window.clearTimeout(timer)}\n            this.oncomplete(res)\n        }\n    }\n    var res = {\n        __class__: ajax,\n        js: xmlhttp,\n        headers: {}\n    }\n    return res\n}\n\nfunction get(){\n    var $ = $B.args(\"get\", 2, {url: null, async: null},\n            [\"url\", \"async\"], arguments, {async: true},\n            null, \"kw\"),\n        url = $.url,\n        async = $.async,\n        kw = $.kw\n    var self = ajax.$factory(),\n        items = handle_kwargs(self, kw, \"get\"),\n        qs = items.data,\n        timeout = items.timeout\n    set_timeout(self, timeout)\n    if(qs){\n        url += \"?\" + qs\n    }\n    if(! (items.cache === true)){\n        url += (qs ? \"&\" : \"?\") + (new Date()).getTime()\n    }\n    self.js.open(\"GET\", url, async)\n    self.js.send()\n}\n\nfunction post(){\n    var $ = $B.args(\"get\", 2, {url: null, async: null},\n            [\"url\", \"async\"], arguments, {async: true},\n            null, \"kw\"),\n        url = $.url,\n        async = $.async,\n        kw = $.kw,\n        data\n    var self = ajax.$factory()\n    self.js.open(\"POST\", url, async)\n    var items = handle_kwargs(self, kw, \"post\"),\n        data = items.data,\n        timeout = items.timeout\n    set_timeout(self, timeout)\n    self.js.send(data)\n}\n\n$B.set_func_names(ajax)\n\nreturn {ajax: ajax, Ajax: ajax, get: get, post: post}\n\n})(__BRYTHON__)\n"], "_base64": [".js", "var $module=(function($B){\n\nvar _b_ = $B.builtins,\n    _keyStr = \"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=\"\n\nfunction make_alphabet(altchars){\n    var alphabet = _keyStr\n    if(altchars !== undefined && altchars !== _b_.None){\n        // altchars is an instance of Python bytes\n        var source = altchars.source\n        alphabet = alphabet.substr(0,alphabet.length-3) +\n            _b_.chr(source[0]) + _b_.chr(source[1]) + '='\n    }\n    return alphabet\n}\n\nvar Base64 = {\n    error: function(){return 'binascii_error'},\n\n    encode: function(bytes, altchars){\n\n        var input = bytes.source,\n            output = \"\",\n            chr1, chr2, chr3, enc1, enc2, enc3, enc4\n        var i = 0\n\n        var alphabet = make_alphabet(altchars)\n\n        while(i < input.length){\n\n            chr1 = input[i++]\n            chr2 = input[i++]\n            chr3 = input[i++]\n\n            enc1 = chr1 >> 2\n            enc2 = ((chr1 & 3) << 4) | (chr2 >> 4)\n            enc3 = ((chr2 & 15) << 2) | (chr3 >> 6)\n            enc4 = chr3 & 63\n\n            if(isNaN(chr2)){\n                enc3 = enc4 = 64\n            }else if(isNaN(chr3)){\n                enc4 = 64\n            }\n\n            output = output + alphabet.charAt(enc1) +\n                alphabet.charAt(enc2) +\n                alphabet.charAt(enc3) +\n                alphabet.charAt(enc4)\n\n        }\n        return _b_.bytes.$factory(output, 'utf-8', 'strict')\n    },\n\n\n    decode: function(bytes, altchars, validate){\n        var output = [],\n            chr1, chr2, chr3,\n            enc1, enc2, enc3, enc4\n\n        var alphabet = make_alphabet(altchars)\n\n        var input = bytes.source\n\n        // If validate is set, check that all characters in input\n        // are in the alphabet\n        var _input = ''\n        var padding = 0\n        for(var i = 0, len = input.length; i < len; i++){\n            var car = String.fromCharCode(input[i])\n            var char_num = alphabet.indexOf(car)\n            if(char_num == -1){\n                if(validate){throw Base64.error(\"Non-base64 digit found: \" +\n                    car)}\n            }else if(char_num == 64 && i < input.length - 2){\n                if(validate){throw Base64.error(\"Non-base64 digit found: \" +\n                    car)}\n            }else if(char_num == 64 && i >= input.length - 2){\n                padding++\n                _input += car\n            }else{\n                _input += car\n            }\n        }\n        input = _input\n        if(_input.length == padding){return _b_.bytes.$factory([])}\n        if( _input.length % 4 > 0){throw Base64.error(\"Incorrect padding\")}\n\n        var i = 0\n        while(i < input.length){\n\n            enc1 = alphabet.indexOf(input.charAt(i++))\n            enc2 = alphabet.indexOf(input.charAt(i++))\n            enc3 = alphabet.indexOf(input.charAt(i++))\n            enc4 = alphabet.indexOf(input.charAt(i++))\n\n            chr1 = (enc1 << 2) | (enc2 >> 4)\n            chr2 = ((enc2 & 15) << 4) | (enc3 >> 2)\n            chr3 = ((enc3 & 3) << 6) | enc4\n\n            output.push(chr1)\n\n            if(enc3 != 64){output.push(chr2)}\n            if(enc4 != 64){output.push(chr3)}\n\n        }\n        // return Python bytes\n        return _b_.bytes.$factory(output, 'utf-8', 'strict')\n\n    },\n\n    _utf8_encode: function(string) {\n        string = string.replace(/\\r\\n/g, \"\\n\")\n        var utftext = \"\";\n\n        for(var n = 0; n < string.length; n++){\n\n            var c = string.charCodeAt(n)\n\n            if(c < 128){\n                utftext += String.fromCharCode(c)\n            }else if((c > 127) && (c < 2048)){\n                utftext += String.fromCharCode((c >> 6) | 192)\n                utftext += String.fromCharCode((c & 63) | 128)\n            }else{\n                utftext += String.fromCharCode((c >> 12) | 224)\n                utftext += String.fromCharCode(((c >> 6) & 63) | 128)\n                utftext += String.fromCharCode((c & 63) | 128)\n            }\n\n        }\n\n        return utftext\n    },\n\n    _utf8_decode: function(utftext) {\n        var string = \"\",\n            i = 0,\n            c = c1 = c2 = 0\n\n        while(i < utftext.length){\n\n            c = utftext.charCodeAt(i)\n\n            if(c < 128){\n                string += String.fromCharCode(c)\n                i++\n            }else if((c > 191) && (c < 224)){\n                c2 = utftext.charCodeAt(i + 1)\n                string += String.fromCharCode(((c & 31) << 6) | (c2 & 63))\n                i += 2\n            }else{\n                c2 = utftext.charCodeAt(i + 1)\n                c3 = utftext.charCodeAt(i + 2)\n                string += String.fromCharCode(\n                    ((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63))\n                i += 3\n            }\n\n        }\n\n        return string\n    }\n\n}\n\nreturn {Base64:Base64}\n}\n\n)(__BRYTHON__)"], "_binascii": [".js", "var $module=(function($B){\n\nvar _b_ = $B.builtins,\n    _keyStr = \"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=\"\n\nvar error = $B.make_class(\"error\", _b_.Exception.$factory)\nerror.__bases__ = [_b_.Exception]\n$B.set_func_names(error, \"binascii\")\n\nfunction decode(bytes, altchars, validate){\n    var output = [],\n        chr1, chr2, chr3,\n        enc1, enc2, enc3, enc4\n\n    var alphabet = make_alphabet(altchars)\n\n    var input = bytes.source\n\n    // If validate is set, check that all characters in input\n    // are in the alphabet\n    var _input = ''\n    var padding = 0\n    for(var i = 0, len = input.length; i < len; i++){\n        var car = String.fromCharCode(input[i])\n        var char_num = alphabet.indexOf(car)\n        if(char_num == -1){\n            if(validate){throw error.$factory(\"Non-base64 digit found: \" +\n                car)}\n        }else if(char_num == 64 && i < input.length - 2){\n            if(validate){throw error.$factory(\"Non-base64 digit found: \" +\n                car)}\n        }else if(char_num == 64 && i >= input.length - 2){\n            padding++\n            _input += car\n        }else{\n            _input += car\n        }\n    }\n    input = _input\n    if(_input.length == padding){return _b_.bytes.$factory([])}\n    if( _input.length % 4 > 0){throw error.$factory(\"Incorrect padding\")}\n\n    var i = 0\n    while(i < input.length){\n\n        enc1 = alphabet.indexOf(input.charAt(i++))\n        enc2 = alphabet.indexOf(input.charAt(i++))\n        enc3 = alphabet.indexOf(input.charAt(i++))\n        enc4 = alphabet.indexOf(input.charAt(i++))\n\n        chr1 = (enc1 << 2) | (enc2 >> 4)\n        chr2 = ((enc2 & 15) << 4) | (enc3 >> 2)\n        chr3 = ((enc3 & 3) << 6) | enc4\n\n        output.push(chr1)\n\n        if(enc3 != 64){output.push(chr2)}\n        if(enc4 != 64){output.push(chr3)}\n\n    }\n    // return Python bytes\n    return _b_.bytes.$factory(output, 'utf-8', 'strict')\n\n}\n\nfunction make_alphabet(altchars){\n    var alphabet = _keyStr\n    if(altchars !== undefined && altchars !== _b_.None){\n        // altchars is an instance of Python bytes\n        var source = altchars.source\n        alphabet = alphabet.substr(0,alphabet.length-3) +\n            _b_.chr(source[0]) + _b_.chr(source[1]) + '='\n    }\n    return alphabet\n}\n\nvar module = {\n    a2b_base64: function(){\n        var $ = $B.args(\"a2b_base64\", 1, {s: null}, ['s'],\n                arguments, {}, null, null)\n        return decode($.s)\n    },\n    b2a_base64: function(){\n        var $ = $B.args(\"b2a_base64\", 1, {data: null}, ['data'],\n                arguments, {}, null, \"kw\")\n        var newline = false\n        if($.kw && $.kw.$string_dict){\n            newline = $.kw.$string_dict[\"newline\"]\n        }\n\n        var string = $B.to_bytes($.data),\n            res = btoa(String.fromCharCode.apply(null, string))\n        if(newline){res += \"\\n\"}\n        return _b_.bytes.$factory(res, \"ascii\")\n    },\n    b2a_hex: function(obj){\n        var string = $B.to_bytes(obj),\n            res = []\n        function conv(c){\n            if(c > 9){\n                c = c + 'a'.charCodeAt(0) - 10\n            }else{\n                c = c + '0'.charCodeAt(0)\n            }\n            return c\n        }\n        string.forEach(function(char){\n            res.push(conv((char >> 4) & 0xf))\n            res.push(conv(char & 0xf))\n        })\n        return _b_.bytes.$factory(res, \"ascii\")\n    },\n    b2a_uu: function(obj){\n        var string = $B.to_bytes(obj)\n        var len = string.length,\n            res = String.fromCharCode((0x20 + len) & 0x3F)\n        while(string.length > 0){\n            var s = string.slice(0, 3)\n            while(s.length < 3){s.push(String.fromCharCode(0))}\n            var A = s[0],\n                B = s[1],\n                C = s[2]\n            var a = (A >> 2) & 0x3F,\n                b = ((A << 4) | ((B >> 4) & 0xF)) & 0x3F,\n                c = (((B << 2) | ((C >> 6) & 0x3)) & 0x3F),\n                d = C & 0x3F\n            res += String.fromCharCode(0x20 + a, 0x20 + b, 0x20 + c, 0x20 + d)\n            string = string.slice(3)\n        }\n        return _b_.bytes.$factory(res + \"\\n\", \"ascii\")\n    },\n    error: error\n}\n\nmodule.hexlify = module.b2a_hex\n\nreturn module\n}\n)(__BRYTHON__)"], "_jsre": [".js", "var $module=(function($B){\n\n    var _b_ = $B.builtins\n    var $s = []\n    for(var $b in _b_) $s.push('var ' + $b +'=_b_[\"' + $b + '\"]')\n    eval($s.join(';'))\n\n    var JSObject = $B.JSObject\n\n    var obj = {__class__: $module,\n        __str__: function(){return \"<module 're'>\"}\n    }\n    obj.A = obj.ASCII = 256\n    obj.I = obj.IGNORECASE = 2 // 'i'\n    obj.L = obj.LOCALE = 4\n    obj.M = obj.MULTILINE = 8 // 'm'\n    obj.S = obj.DOTALL = 16\n    obj.U = obj.UNICODE = 32\n    obj.X = obj.VERBOSE = 64\n    obj._is_valid = function(pattern) {\n        if ($B.$options.re == 'pyre'){return false}  //force use of python's re module\n        if ($B.$options.re == 'jsre'){return true}   //force use of brythons re module\n        // FIXME: Improve\n\n        if(! isinstance(pattern, str)){\n           // this is probably a SRE_PATTERN, so return false, and let\n           // python's re module handle this.\n           return false\n        }\n        var is_valid = false\n        try{\n            new RegExp(pattern)\n            is_valid = true\n        }\n        catch(e){}\n        if(! is_valid){return false}  //if js won't parse the pattern return false\n\n        // using reference http://www.regular-expressions.info/\n        // to compare python re and javascript regex libraries\n\n        // look for things javascript does not support\n        // check for name capturing group\n        var mylist = ['?P=', '?P<', '(?#', '(?<=', '(?<!', '(?(']\n        for(var i = 0, _len_i = mylist.length; i < _len_i; i++) {\n           if (pattern.indexOf(mylist[i]) > -1) return false\n        }\n\n        var re_list=['\\{,\\d+\\}']\n        for(var i=0, _len_i = re_list.length; i < _len_i; i++) {\n           var _re = new RegExp(re_list[i])\n           if (_re.test(pattern)){return false}\n        }\n\n        // it looks like the pattern has passed all our tests so lets assume\n        // javascript can handle this pattern.\n        return true\n    }\n    var $SRE_PatternDict = {\n        __class__:_b_.type,\n        $infos:{\n            __name__:'SRE_Pattern'\n        }\n    }\n    $SRE_PatternDict.__mro__ = [object]\n    $SRE_PatternDict.findall = function(self, string){\n        return obj.findall(self.pattern, string, self.flags)\n    }\n    $SRE_PatternDict.finditer = function(self, string){\n        return obj.finditer(self.pattern, string, self.flags)\n    }\n    $SRE_PatternDict.match = function(self, string){\n        return obj.match(self.pattern, string, self.flags)\n    }\n    $SRE_PatternDict.search = function(self, string){\n        return obj.search(self.pattern, string, self.flags)\n    }\n    $SRE_PatternDict.sub = function(self,repl,string){\n        return obj.sub(self.pattern,repl,string,self.flags)\n    }\n    // TODO: groups\n    // TODO: groupindex\n    function normflags(flags){\n        return ((flags & obj.I)? 'i' : '') + ((flags & obj.M)? 'm' : '');\n    }\n    // TODO: fullmatch()\n    // TODO: split()\n    // TODO: subn()\n    obj.compile = function(pattern, flags){\n        return {\n            __class__: $SRE_PatternDict,\n            pattern: pattern,\n            flags: normflags(flags)\n        }\n    }\n    obj.escape = function(string){\n        // Escape all the characters in pattern except ASCII letters, numbers\n        // and '_'. This is useful if you want to match an arbitrary literal\n        // string that may have regular expression metacharacters in it.\n        var res = ''\n        var ok = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_'\n        for(var i = 0, _len_i = string.length; i < _len_i; i++){\n            if(ok.search(string.charAt(i))>-1){res += string.charAt(i)}\n        }\n        return res\n    }\n    obj.findall = function(pattern, string, flags){\n        var $ns=$B.args('re.findall', 2,\n            {pattern:null, string:null}, ['pattern', 'string'],\n            arguments,{}, 'args', 'kw') ,\n            args = $ns['args'] ,\n            _flags = 0;\n        if(args.length>0){var flags = args[0]}\n        else{var _flags = getattr($ns['kw'], 'get')('flags', 0)}\n\n        var flags = normflags()\n        flags += 'gm'\n        var jsp = new RegExp(pattern,flags),\n            jsmatch = string.match(jsp)\n        if(jsmatch === null){return []}\n        return jsmatch\n    }\n    obj.finditer = function(pattern, string, flags){\n        var $ns=$B.args('re.finditer', 2,\n            {pattern:null, string:null}, ['pattern', 'string'],\n            arguments,{},'args','kw'),\n            args = $ns['args'],\n            _flags = 0;\n        if(args.length>0){var flags=args[0]}\n        else{var _flags = getattr($ns['kw'], 'get')('flags', 0)}\n\n        var flags = normflags()\n        flags += 'gm'\n        var jsp = new RegExp(pattern, flags),\n            jsmatch = string.match(jsp);\n        if(jsmatch === null){return []}\n\n        var _list = []\n        for(var j = 0, _len_j = jsmatch.length; j < _len_j; j++) {\n            var mo = {}\n            mo._match=jsmatch[j]\n            mo.group = function(){\n               var res = []\n               for(var i=0, _len_i = arguments.length; i < _len_i;i++){\n                   if(jsmatch[arguments[i]] === undefined){res.push(None)}\n                   else{res.push(jsmatch[arguments[i]])}\n               }\n               if(arguments.length == 1){return res[0]}\n               return tuple.$factory(res)\n            }\n            mo.groups = function(_default){\n               if(_default === undefined){_default=None}\n               var res = []\n               for(var i = 1, _len_i = jsmatch.length; i < _len_i; i++){\n                  if(jsmatch[i] === undefined){res.push(_default)}\n                  else{res.push(jsmatch[i])}\n               }\n               return tuple.$factory(res)\n            }\n            mo.start = function(){return mo._match.index}\n            mo.end = function(){return mo._match.length - mo._match.index}\n            mo.string = string\n            _list.push(JSObject.$factory(mo))\n        }\n        return _list\n    }\n    obj.search = function(pattern, string){\n        var $ns = $B.args('re.search', 2,\n            {pattern:null, string:null},['pattern', 'string'],\n            arguments, {}, 'args', 'kw')\n        var args = $ns['args']\n        if(args.length>0){var flags = args[0]}\n        else{var flags = getattr($ns['kw'], 'get')('flags', '')}\n        flags = normflags(flags)\n        var jsp = new RegExp(pattern,flags)\n        var jsmatch = string.match(jsp)\n        if(jsmatch === null){return None}\n        var mo = new Object()\n        mo.group = function(){\n            var res = []\n            for(var i = 0, _len_i = arguments.length; i < _len_i; i++){\n                if(jsmatch[arguments[i]] === undefined){res.push(None)}\n                else{res.push(jsmatch[arguments[i]])}\n            }\n            if(arguments.length == 1){return res[0]}\n            return tuple.$factory(res)\n        }\n        mo.groups = function(_default){\n            if(_default===undefined){_default=None}\n            var res = []\n            for(var i = 1, _len_i = jsmatch.length; i < _len_i; i++){\n                if(jsmatch[i] === undefined){res.push(_default)}\n                else{res.push(jsmatch[i])}\n            }\n            return tuple.$factory(res)\n        }\n        mo.start = function(){return jsmatch.index}\n        mo.end = function(){return jsmatch.length - jsmatch.index}\n        mo.string = string\n        return JSObject.$factory(mo)\n    }\n    obj.sub = function(pattern, repl, string){\n        var $ns=$B.args('re.search', 3,\n            {pattern: null, repl: null, string: null},\n            ['pattern', 'repl', 'string'],\n            arguments,{}, 'args', 'kw')\n        for($var in $ns){eval(\"var \" + $var + \"=$ns[$var]\")}\n        var args = $ns['args']\n        var count = _b_.dict.get($ns['kw'], 'count', 0)\n        var flags = _b_.dict.get($ns['kw'], 'flags', '')\n        if(args.length > 0){var count = args[0]}\n        if(args.length > 1){var flags = args[1]}\n        flags = normflags(flags)\n        if(typeof repl == \"string\"){\n            // backreferences are \\1, \\2... in Python but $1,$2... in Javascript\n            repl = repl.replace(/\\\\(\\d+)/g, '$$$1')\n        }else if(typeof repl == \"function\"){\n            // the argument passed to the Python function is the match object\n            // the arguments passed to the Javascript function are :\n            // - the matched substring\n            // - the matched groups\n            // - the offset of the matched substring inside the string\n            // - the string being examined\n            var $repl1 = function(){\n                var mo = Object()\n                mo.string = arguments[arguments.length - 1]\n                var matched = arguments[0];\n                var start = arguments[arguments.length - 2]\n                var end = start + matched.length\n                mo.start = function(){return start}\n                mo.end = function(){return end}\n                groups = []\n                for(var i = 1, _len_i = arguments.length-2; i < _len_i; i++){\n                    groups.push(arguments[i])\n                }\n                mo.groups = function(_default){\n                    if(_default === undefined){_default = None}\n                    var res = []\n                    for(var i = 0, _len_i = groups.length; i < _len_i; i++){\n                        if(groups[i] === undefined){res.push(_default)}\n                        else{res.push(groups[i])}\n                    }\n                    return res\n                }\n                mo.group = function(i){\n                    if(i==0){return matched}\n                    return groups[i-1]\n                }\n                return repl(JSObject.$factory(mo))\n            }\n        }\n        if(count == 0){flags += 'g'}\n        var jsp = new RegExp(pattern, flags)\n        if(typeof repl == 'function'){return string.replace(jsp, $repl1)}\n        else{return string.replace(jsp, repl)}\n    }\n    obj.match = (function(search_func){\n        return function(){\n            // match is like search but pattern must start with ^\n            var pattern = arguments[0]\n            if(pattern.charAt(0) != '^'){pattern = '^'+pattern}\n            var args = [pattern]\n            for(var i = 1, _len_i = arguments.length; i < _len_i; i++){\n                args.push(arguments[i])\n            }\n            return search_func.apply(null, args)\n        }\n    })(obj.search)\n\n    return obj\n}\n)(__BRYTHON__)\n"], "_locale": [".js", "var am = {\n    \"C\": \"AM\",\n    \"aa\": \"saaku\",\n    \"ab\": \"AM\",\n    \"ae\": \"AM\",\n    \"af\": \"vm.\",\n    \"ak\": \"AN\",\n    \"am\": \"\\u1325\\u12cb\\u1275\",\n    \"an\": \"AM\",\n    \"ar\": \"\\u0635\",\n    \"as\": \"\\u09f0\\u09be\\u09a4\\u09bf\\u09aa\\u09c1\",\n    \"av\": \"AM\",\n    \"ay\": \"AM\",\n    \"az\": \"AM\",\n    \"ba\": \"\",\n    \"be\": \"\",\n    \"bg\": \"\",\n    \"bh\": \"AM\",\n    \"bi\": \"AM\",\n    \"bm\": \"AM\",\n    \"bn\": \"AM\",\n    \"bo\": \"\\u0f66\\u0f94\\u0f0b\\u0f51\\u0fb2\\u0f7c\",\n    \"br\": \"A.M.\",\n    \"bs\": \"prijepodne\",\n    \"ca\": \"a. m.\",\n    \"ce\": \"AM\",\n    \"ch\": \"AM\",\n    \"co\": \"\",\n    \"cr\": \"AM\",\n    \"cs\": \"dop.\",\n    \"cu\": \"\\u0414\\u041f\",\n    \"cv\": \"AM\",\n    \"cy\": \"yb\",\n    \"da\": \"\",\n    \"de\": \"\",\n    \"dv\": \"\\u0789\\u0786\",\n    \"dz\": \"\\u0f66\\u0f94\\u0f0b\\u0f46\\u0f0b\",\n    \"ee\": \"\\u014bdi\",\n    \"el\": \"\\u03c0\\u03bc\",\n    \"en\": \"AM\",\n    \"eo\": \"atm\",\n    \"es\": \"\",\n    \"et\": \"AM\",\n    \"eu\": \"AM\",\n    \"fa\": \"\\u0642.\\u0638\",\n    \"ff\": \"\",\n    \"fi\": \"ap.\",\n    \"fj\": \"AM\",\n    \"fo\": \"um fyr.\",\n    \"fr\": \"\",\n    \"fy\": \"AM\",\n    \"ga\": \"r.n.\",\n    \"gd\": \"m\",\n    \"gl\": \"a.m.\",\n    \"gn\": \"a.m.\",\n    \"gu\": \"\\u0aaa\\u0ac2\\u0ab0\\u0acd\\u0ab5\\u00a0\\u0aae\\u0aa7\\u0acd\\u0aaf\\u0abe\\u0ab9\\u0acd\\u0aa8\",\n    \"gv\": \"a.m.\",\n    \"ha\": \"AM\",\n    \"he\": \"AM\",\n    \"hi\": \"\\u092a\\u0942\\u0930\\u094d\\u0935\\u093e\\u0939\\u094d\\u0928\",\n    \"ho\": \"AM\",\n    \"hr\": \"\",\n    \"ht\": \"AM\",\n    \"hu\": \"de.\",\n    \"hy\": \"\",\n    \"hz\": \"AM\",\n    \"ia\": \"a.m.\",\n    \"id\": \"AM\",\n    \"ie\": \"AM\",\n    \"ig\": \"A.M.\",\n    \"ii\": \"\\ua0b5\\ua1aa\\ua20c\\ua210\",\n    \"ik\": \"AM\",\n    \"io\": \"AM\",\n    \"is\": \"f.h.\",\n    \"it\": \"\",\n    \"iu\": \"AM\",\n    \"ja\": \"\\u5348\\u524d\",\n    \"jv\": \"\",\n    \"ka\": \"AM\",\n    \"kg\": \"AM\",\n    \"ki\": \"Kiroko\",\n    \"kj\": \"AM\",\n    \"kk\": \"AM\",\n    \"kl\": \"\",\n    \"km\": \"\\u1796\\u17d2\\u179a\\u17b9\\u1780\",\n    \"kn\": \"\\u0caa\\u0cc2\\u0cb0\\u0ccd\\u0cb5\\u0cbe\\u0cb9\\u0ccd\\u0ca8\",\n    \"ko\": \"\\uc624\\uc804\",\n    \"kr\": \"AM\",\n    \"ks\": \"AM\",\n    \"ku\": \"\\u067e.\\u0646\",\n    \"kv\": \"AM\",\n    \"kw\": \"a.m.\",\n    \"ky\": \"\",\n    \"la\": \"\",\n    \"lb\": \"\",\n    \"lg\": \"AM\",\n    \"li\": \"AM\",\n    \"ln\": \"nt\\u0254\\u0301ng\\u0254\\u0301\",\n    \"lo\": \"\\u0e81\\u0ec8\\u0ead\\u0e99\\u0e97\\u0ec8\\u0ebd\\u0e87\",\n    \"lt\": \"prie\\u0161piet\",\n    \"lu\": \"Dinda\",\n    \"lv\": \"priek\\u0161p.\",\n    \"mg\": \"AM\",\n    \"mh\": \"AM\",\n    \"mi\": \"a.m.\",\n    \"mk\": \"\\u043f\\u0440\\u0435\\u0442\\u043f\\u043b.\",\n    \"ml\": \"AM\",\n    \"mn\": \"??\",\n    \"mo\": \"AM\",\n    \"mr\": \"\\u092e.\\u092a\\u0942.\",\n    \"ms\": \"PG\",\n    \"mt\": \"AM\",\n    \"my\": \"\\u1014\\u1036\\u1014\\u1000\\u103a\",\n    \"na\": \"AM\",\n    \"nb\": \"a.m.\",\n    \"nd\": \"AM\",\n    \"ne\": \"\\u092a\\u0942\\u0930\\u094d\\u0935\\u093e\\u0939\\u094d\\u0928\",\n    \"ng\": \"AM\",\n    \"nl\": \"\",\n    \"nn\": \"f.m.\",\n    \"no\": \"a.m.\",\n    \"nr\": \"AM\",\n    \"nv\": \"AM\",\n    \"ny\": \"AM\",\n    \"oc\": \"AM\",\n    \"oj\": \"AM\",\n    \"om\": \"WD\",\n    \"or\": \"AM\",\n    \"os\": \"AM\",\n    \"pa\": \"\\u0a38\\u0a35\\u0a47\\u0a30\",\n    \"pi\": \"AM\",\n    \"pl\": \"AM\",\n    \"ps\": \"\\u063a.\\u0645.\",\n    \"pt\": \"\",\n    \"qu\": \"a.m.\",\n    \"rc\": \"AM\",\n    \"rm\": \"AM\",\n    \"rn\": \"Z.MU.\",\n    \"ro\": \"a.m.\",\n    \"ru\": \"\",\n    \"rw\": \"AM\",\n    \"sa\": \"\\u092e\\u0927\\u094d\\u092f\\u093e\\u0928\\u092a\\u0942\\u0930\\u094d\\u0935\",\n    \"sc\": \"AM\",\n    \"sd\": \"AM\",\n    \"se\": \"i.b.\",\n    \"sg\": \"ND\",\n    \"sh\": \"AM\",\n    \"si\": \"\\u0db4\\u0dd9.\\u0dc0.\",\n    \"sk\": \"AM\",\n    \"sl\": \"dop.\",\n    \"sm\": \"AM\",\n    \"sn\": \"AM\",\n    \"so\": \"sn.\",\n    \"sq\": \"e paradites\",\n    \"sr\": \"pre podne\",\n    \"ss\": \"AM\",\n    \"st\": \"AM\",\n    \"su\": \"AM\",\n    \"sv\": \"\",\n    \"sw\": \"AM\",\n    \"ta\": \"\\u0b95\\u0bbe\\u0bb2\\u0bc8\",\n    \"te\": \"\\u0c2a\\u0c42\\u0c30\\u0c4d\\u0c35\\u0c3e\\u0c39\\u0c4d\\u0c28\",\n    \"tg\": \"\",\n    \"th\": \"AM\",\n    \"ti\": \"\\u1295\\u1309\\u1206 \\u1230\\u12d3\\u1270\",\n    \"tk\": \"\",\n    \"tl\": \"AM\",\n    \"tn\": \"AM\",\n    \"to\": \"AM\",\n    \"tr\": \"\\u00d6\\u00d6\",\n    \"ts\": \"AM\",\n    \"tt\": \"\",\n    \"tw\": \"AM\",\n    \"ty\": \"AM\",\n    \"ug\": \"\\u0686?\\u0634\\u062a\\u0649\\u0646 \\u0628?\\u0631?\\u0646\",\n    \"uk\": \"AM\",\n    \"ur\": \"AM\",\n    \"uz\": \"TO\",\n    \"ve\": \"AM\",\n    \"vi\": \"SA\",\n    \"vo\": \"AM\",\n    \"wa\": \"AM\",\n    \"wo\": \"\",\n    \"xh\": \"AM\",\n    \"yi\": \"\\ua0b5\\ua1aa\\ua20c\\ua210\",\n    \"yo\": \"\\u00c0\\u00e1r?`\",\n    \"za\": \"AM\",\n    \"zh\": \"\\u4e0a\\u5348\",\n    \"zu\": \"AM\"\n}\nvar pm = {\n    \"C\": \"PM\",\n    \"aa\": \"carra\",\n    \"ab\": \"PM\",\n    \"ae\": \"PM\",\n    \"af\": \"nm.\",\n    \"ak\": \"EW\",\n    \"am\": \"\\u12a8\\u1230\\u12d3\\u1275\",\n    \"an\": \"PM\",\n    \"ar\": \"\\u0645\",\n    \"as\": \"\\u0986\\u09ac\\u09c7\\u09b2\\u09bf\",\n    \"av\": \"PM\",\n    \"ay\": \"PM\",\n    \"az\": \"PM\",\n    \"ba\": \"\",\n    \"be\": \"\",\n    \"bg\": \"\",\n    \"bh\": \"PM\",\n    \"bi\": \"PM\",\n    \"bm\": \"PM\",\n    \"bn\": \"PM\",\n    \"bo\": \"\\u0f55\\u0fb1\\u0f72\\u0f0b\\u0f51\\u0fb2\\u0f7c\",\n    \"br\": \"G.M.\",\n    \"bs\": \"popodne\",\n    \"ca\": \"p. m.\",\n    \"ce\": \"PM\",\n    \"ch\": \"PM\",\n    \"co\": \"\",\n    \"cr\": \"PM\",\n    \"cs\": \"odp.\",\n    \"cu\": \"\\u041f\\u041f\",\n    \"cv\": \"PM\",\n    \"cy\": \"yh\",\n    \"da\": \"\",\n    \"de\": \"\",\n    \"dv\": \"\\u0789\\u078a\",\n    \"dz\": \"\\u0f55\\u0fb1\\u0f72\\u0f0b\\u0f46\\u0f0b\",\n    \"ee\": \"\\u0263etr\\u0254\",\n    \"el\": \"\\u03bc\\u03bc\",\n    \"en\": \"PM\",\n    \"eo\": \"ptm\",\n    \"es\": \"\",\n    \"et\": \"PM\",\n    \"eu\": \"PM\",\n    \"fa\": \"\\u0628.\\u0638\",\n    \"ff\": \"\",\n    \"fi\": \"ip.\",\n    \"fj\": \"PM\",\n    \"fo\": \"um sein.\",\n    \"fr\": \"\",\n    \"fy\": \"PM\",\n    \"ga\": \"i.n.\",\n    \"gd\": \"f\",\n    \"gl\": \"p.m.\",\n    \"gn\": \"p.m.\",\n    \"gu\": \"\\u0a89\\u0aa4\\u0acd\\u0aa4\\u0ab0\\u00a0\\u0aae\\u0aa7\\u0acd\\u0aaf\\u0abe\\u0ab9\\u0acd\\u0aa8\",\n    \"gv\": \"p.m.\",\n    \"ha\": \"PM\",\n    \"he\": \"PM\",\n    \"hi\": \"\\u0905\\u092a\\u0930\\u093e\\u0939\\u094d\\u0928\",\n    \"ho\": \"PM\",\n    \"hr\": \"\",\n    \"ht\": \"PM\",\n    \"hu\": \"du.\",\n    \"hy\": \"\",\n    \"hz\": \"PM\",\n    \"ia\": \"p.m.\",\n    \"id\": \"PM\",\n    \"ie\": \"PM\",\n    \"ig\": \"P.M.\",\n    \"ii\": \"\\ua0b5\\ua1aa\\ua20c\\ua248\",\n    \"ik\": \"PM\",\n    \"io\": \"PM\",\n    \"is\": \"e.h.\",\n    \"it\": \"\",\n    \"iu\": \"PM\",\n    \"ja\": \"\\u5348\\u5f8c\",\n    \"jv\": \"\",\n    \"ka\": \"PM\",\n    \"kg\": \"PM\",\n    \"ki\": \"Hwa\\u0129-in\\u0129\",\n    \"kj\": \"PM\",\n    \"kk\": \"PM\",\n    \"kl\": \"\",\n    \"km\": \"\\u179b\\u17d2\\u1784\\u17b6\\u1785\",\n    \"kn\": \"\\u0c85\\u0caa\\u0cb0\\u0cbe\\u0cb9\\u0ccd\\u0ca8\",\n    \"ko\": \"\\uc624\\ud6c4\",\n    \"kr\": \"PM\",\n    \"ks\": \"PM\",\n    \"ku\": \"\\u062f.\\u0646\",\n    \"kv\": \"PM\",\n    \"kw\": \"p.m.\",\n    \"ky\": \"\",\n    \"la\": \"\",\n    \"lb\": \"\",\n    \"lg\": \"PM\",\n    \"li\": \"PM\",\n    \"ln\": \"mp\\u00f3kwa\",\n    \"lo\": \"\\u0eab\\u0ebc\\u0eb1\\u0e87\\u0e97\\u0ec8\\u0ebd\\u0e87\",\n    \"lt\": \"popiet\",\n    \"lu\": \"Dilolo\",\n    \"lv\": \"p\\u0113cp.\",\n    \"mg\": \"PM\",\n    \"mh\": \"PM\",\n    \"mi\": \"p.m.\",\n    \"mk\": \"\\u043f\\u043e\\u043f\\u043b.\",\n    \"ml\": \"PM\",\n    \"mn\": \"?\\u0425\",\n    \"mo\": \"PM\",\n    \"mr\": \"\\u092e.\\u0928\\u0902.\",\n    \"ms\": \"PTG\",\n    \"mt\": \"PM\",\n    \"my\": \"\\u100a\\u1014\\u1031\",\n    \"na\": \"PM\",\n    \"nb\": \"p.m.\",\n    \"nd\": \"PM\",\n    \"ne\": \"\\u0905\\u092a\\u0930\\u093e\\u0939\\u094d\\u0928\",\n    \"ng\": \"PM\",\n    \"nl\": \"\",\n    \"nn\": \"e.m.\",\n    \"no\": \"p.m.\",\n    \"nr\": \"PM\",\n    \"nv\": \"PM\",\n    \"ny\": \"PM\",\n    \"oc\": \"PM\",\n    \"oj\": \"PM\",\n    \"om\": \"WB\",\n    \"or\": \"PM\",\n    \"os\": \"PM\",\n    \"pa\": \"\\u0a36\\u0a3e\\u0a2e\",\n    \"pi\": \"PM\",\n    \"pl\": \"PM\",\n    \"ps\": \"\\u063a.\\u0648.\",\n    \"pt\": \"\",\n    \"qu\": \"p.m.\",\n    \"rc\": \"PM\",\n    \"rm\": \"PM\",\n    \"rn\": \"Z.MW.\",\n    \"ro\": \"p.m.\",\n    \"ru\": \"\",\n    \"rw\": \"PM\",\n    \"sa\": \"\\u092e\\u0927\\u094d\\u092f\\u093e\\u0928\\u092a\\u091a\\u094d\\u092f\\u093e\\u0924\",\n    \"sc\": \"PM\",\n    \"sd\": \"PM\",\n    \"se\": \"e.b.\",\n    \"sg\": \"LK\",\n    \"sh\": \"PM\",\n    \"si\": \"\\u0db4.\\u0dc0.\",\n    \"sk\": \"PM\",\n    \"sl\": \"pop.\",\n    \"sm\": \"PM\",\n    \"sn\": \"PM\",\n    \"so\": \"gn.\",\n    \"sq\": \"e pasdites\",\n    \"sr\": \"po podne\",\n    \"ss\": \"PM\",\n    \"st\": \"PM\",\n    \"su\": \"PM\",\n    \"sv\": \"\",\n    \"sw\": \"PM\",\n    \"ta\": \"\\u0bae\\u0bbe\\u0bb2\\u0bc8\",\n    \"te\": \"\\u0c05\\u0c2a\\u0c30\\u0c3e\\u0c39\\u0c4d\\u0c28\",\n    \"tg\": \"\",\n    \"th\": \"PM\",\n    \"ti\": \"\\u12f5\\u1215\\u122d \\u1230\\u12d3\\u1275\",\n    \"tk\": \"\",\n    \"tl\": \"PM\",\n    \"tn\": \"PM\",\n    \"to\": \"PM\",\n    \"tr\": \"\\u00d6S\",\n    \"ts\": \"PM\",\n    \"tt\": \"\",\n    \"tw\": \"PM\",\n    \"ty\": \"PM\",\n    \"ug\": \"\\u0686?\\u0634\\u062a\\u0649\\u0646 \\u0643?\\u064a\\u0649\\u0646\",\n    \"uk\": \"PM\",\n    \"ur\": \"PM\",\n    \"uz\": \"TK\",\n    \"ve\": \"PM\",\n    \"vi\": \"CH\",\n    \"vo\": \"PM\",\n    \"wa\": \"PM\",\n    \"wo\": \"\",\n    \"xh\": \"PM\",\n    \"yi\": \"\\ua0b5\\ua1aa\\ua20c\\ua248\",\n    \"yo\": \"?`s\\u00e1n\",\n    \"za\": \"PM\",\n    \"zh\": \"\\u4e0b\\u5348\",\n    \"zu\": \"PM\"\n}\n\nvar X_format = {\n    \"%H:%M:%S\": [\n        \"C\",\n        \"ab\",\n        \"ae\",\n        \"af\",\n        \"an\",\n        \"av\",\n        \"ay\",\n        \"az\",\n        \"ba\",\n        \"be\",\n        \"bg\",\n        \"bh\",\n        \"bi\",\n        \"bm\",\n        \"bo\",\n        \"br\",\n        \"bs\",\n        \"ca\",\n        \"ce\",\n        \"ch\",\n        \"co\",\n        \"cr\",\n        \"cs\",\n        \"cu\",\n        \"cv\",\n        \"cy\",\n        \"da\",\n        \"de\",\n        \"dv\",\n        \"eo\",\n        \"es\",\n        \"et\",\n        \"eu\",\n        \"ff\",\n        \"fj\",\n        \"fo\",\n        \"fr\",\n        \"fy\",\n        \"ga\",\n        \"gd\",\n        \"gl\",\n        \"gn\",\n        \"gu\",\n        \"gv\",\n        \"ha\",\n        \"he\",\n        \"hi\",\n        \"ho\",\n        \"hr\",\n        \"ht\",\n        \"hu\",\n        \"hy\",\n        \"hz\",\n        \"ia\",\n        \"ie\",\n        \"ig\",\n        \"ik\",\n        \"io\",\n        \"is\",\n        \"it\",\n        \"ja\",\n        \"ka\",\n        \"kg\",\n        \"ki\",\n        \"kj\",\n        \"kk\",\n        \"kl\",\n        \"km\",\n        \"kn\",\n        \"kv\",\n        \"kw\",\n        \"ky\",\n        \"la\",\n        \"lb\",\n        \"lg\",\n        \"li\",\n        \"ln\",\n        \"lo\",\n        \"lt\",\n        \"lu\",\n        \"lv\",\n        \"mg\",\n        \"mh\",\n        \"mk\",\n        \"mn\",\n        \"mo\",\n        \"mr\",\n        \"mt\",\n        \"my\",\n        \"na\",\n        \"nb\",\n        \"nd\",\n        \"ng\",\n        \"nl\",\n        \"nn\",\n        \"no\",\n        \"nr\",\n        \"nv\",\n        \"ny\",\n        \"oj\",\n        \"or\",\n        \"os\",\n        \"pi\",\n        \"pl\",\n        \"ps\",\n        \"pt\",\n        \"rc\",\n        \"rm\",\n        \"rn\",\n        \"ro\",\n        \"ru\",\n        \"rw\",\n        \"sa\",\n        \"sc\",\n        \"se\",\n        \"sg\",\n        \"sh\",\n        \"sk\",\n        \"sl\",\n        \"sm\",\n        \"sn\",\n        \"sr\",\n        \"ss\",\n        \"st\",\n        \"su\",\n        \"sv\",\n        \"sw\",\n        \"ta\",\n        \"te\",\n        \"tg\",\n        \"th\",\n        \"tk\",\n        \"tl\",\n        \"tn\",\n        \"tr\",\n        \"ts\",\n        \"tt\",\n        \"tw\",\n        \"ty\",\n        \"ug\",\n        \"uk\",\n        \"uz\",\n        \"ve\",\n        \"vo\",\n        \"wa\",\n        \"wo\",\n        \"xh\",\n        \"yo\",\n        \"za\",\n        \"zh\",\n        \"zu\"\n    ],\n    \"%i:%M:%S %p\": [\n        \"aa\",\n        \"ak\",\n        \"am\",\n        \"bn\",\n        \"el\",\n        \"en\",\n        \"iu\",\n        \"kr\",\n        \"ks\",\n        \"mi\",\n        \"ml\",\n        \"ms\",\n        \"ne\",\n        \"om\",\n        \"sd\",\n        \"so\",\n        \"sq\",\n        \"ti\",\n        \"to\",\n        \"ur\",\n        \"vi\"\n    ],\n    \"%I:%M:%S %p\": [\n        \"ar\",\n        \"fa\",\n        \"ku\",\n        \"qu\"\n    ],\n    \"%p %i:%M:%S\": [\n        \"as\",\n        \"ii\",\n        \"ko\",\n        \"yi\"\n    ],\n    \"\\u0f46\\u0f74\\u0f0b\\u0f5a\\u0f7c\\u0f51\\u0f0b%i:%M:%S %p\": [\n        \"dz\"\n    ],\n    \"%p ga %i:%M:%S\": [\n        \"ee\"\n    ],\n    \"%H.%M.%S\": [\n        \"fi\",\n        \"id\",\n        \"jv\",\n        \"oc\",\n        \"si\"\n    ],\n    \"%p %I:%M:%S\": [\n        \"pa\"\n    ]\n}\nvar x_format = {\n    \"%m/%d/%y\": [\n        \"C\"\n    ],\n    \"%d/%m/%Y\": [\n        \"aa\",\n        \"am\",\n        \"bm\",\n        \"bn\",\n        \"ca\",\n        \"co\",\n        \"cy\",\n        \"el\",\n        \"es\",\n        \"ff\",\n        \"fr\",\n        \"ga\",\n        \"gd\",\n        \"gl\",\n        \"gn\",\n        \"gv\",\n        \"ha\",\n        \"he\",\n        \"id\",\n        \"ig\",\n        \"it\",\n        \"iu\",\n        \"jv\",\n        \"ki\",\n        \"kr\",\n        \"kw\",\n        \"la\",\n        \"lg\",\n        \"ln\",\n        \"lo\",\n        \"lu\",\n        \"mi\",\n        \"ml\",\n        \"ms\",\n        \"mt\",\n        \"nd\",\n        \"oc\",\n        \"om\",\n        \"pt\",\n        \"qu\",\n        \"rn\",\n        \"sd\",\n        \"sg\",\n        \"so\",\n        \"sw\",\n        \"ti\",\n        \"to\",\n        \"uk\",\n        \"ur\",\n        \"uz\",\n        \"vi\",\n        \"wo\",\n        \"yo\"\n    ],\n    \"%m/%d/%Y\": [\n        \"ab\",\n        \"ae\",\n        \"an\",\n        \"av\",\n        \"ay\",\n        \"bh\",\n        \"bi\",\n        \"ch\",\n        \"cr\",\n        \"cv\",\n        \"ee\",\n        \"en\",\n        \"fj\",\n        \"ho\",\n        \"ht\",\n        \"hz\",\n        \"ie\",\n        \"ik\",\n        \"io\",\n        \"kg\",\n        \"kj\",\n        \"ks\",\n        \"kv\",\n        \"li\",\n        \"mh\",\n        \"mo\",\n        \"na\",\n        \"ne\",\n        \"ng\",\n        \"nv\",\n        \"ny\",\n        \"oj\",\n        \"pi\",\n        \"rc\",\n        \"sc\",\n        \"sh\",\n        \"sm\",\n        \"su\",\n        \"tl\",\n        \"tw\",\n        \"ty\",\n        \"wa\",\n        \"za\",\n        \"zu\"\n    ],\n    \"%Y-%m-%d\": [\n        \"af\",\n        \"br\",\n        \"ce\",\n        \"dz\",\n        \"eo\",\n        \"ko\",\n        \"lt\",\n        \"mg\",\n        \"nr\",\n        \"rw\",\n        \"se\",\n        \"si\",\n        \"sn\",\n        \"ss\",\n        \"st\",\n        \"sv\",\n        \"tn\",\n        \"ts\",\n        \"ug\",\n        \"ve\",\n        \"vo\",\n        \"xh\"\n    ],\n    \"%Y/%m/%d\": [\n        \"ak\",\n        \"bo\",\n        \"eu\",\n        \"ia\",\n        \"ii\",\n        \"ja\",\n        \"ku\",\n        \"yi\",\n        \"zh\"\n    ],\n    \"null\": [\n        \"ar\",\n        \"fa\",\n        \"ps\",\n        \"th\"\n    ],\n    \"%d-%m-%Y\": [\n        \"as\",\n        \"da\",\n        \"fy\",\n        \"hi\",\n        \"kl\",\n        \"mr\",\n        \"my\",\n        \"nl\",\n        \"rm\",\n        \"sa\",\n        \"ta\"\n    ],\n    \"%d.%m.%Y\": [\n        \"az\",\n        \"cs\",\n        \"de\",\n        \"et\",\n        \"fi\",\n        \"fo\",\n        \"hy\",\n        \"is\",\n        \"ka\",\n        \"kk\",\n        \"lv\",\n        \"mk\",\n        \"nb\",\n        \"nn\",\n        \"no\",\n        \"os\",\n        \"pl\",\n        \"ro\",\n        \"ru\",\n        \"sq\",\n        \"tg\",\n        \"tr\",\n        \"tt\"\n    ],\n    \"%d.%m.%y\": [\n        \"ba\",\n        \"be\",\n        \"lb\"\n    ],\n    \"%d.%m.%Y \\u0433.\": [\n        \"bg\"\n    ],\n    \"%d.%m.%Y.\": [\n        \"bs\",\n        \"hr\",\n        \"sr\"\n    ],\n    \"%Y.%m.%d\": [\n        \"cu\",\n        \"mn\"\n    ],\n    \"%d/%m/%y\": [\n        \"dv\",\n        \"km\"\n    ],\n    \"%d-%m-%y\": [\n        \"gu\",\n        \"kn\",\n        \"or\",\n        \"pa\",\n        \"te\"\n    ],\n    \"%Y. %m. %d.\": [\n        \"hu\"\n    ],\n    \"%d-%b %y\": [\n        \"ky\"\n    ],\n    \"%d. %m. %Y\": [\n        \"sk\",\n        \"sl\"\n    ],\n    \"%d.%m.%y \\u00fd.\": [\n        \"tk\"\n    ]\n}\n\n\nvar $module=(function($B){\n    var _b_ = $B.builtins\n    return {\n        CHAR_MAX: 127,\n        LC_ALL: 6,\n        LC_COLLATE: 3,\n        LC_CTYPE: 0,\n        LC_MESSAGES: 5,\n        LC_MONETARY: 4,\n        LC_NUMERIC: 1,\n        LC_TIME: 2,\n        Error: _b_.ValueError,\n\n        _date_format: function(spec, hour){\n            var t,\n                locale = __BRYTHON__.locale.substr(0, 2)\n\n            if(spec == \"p\"){\n                var res = hours < 12 ? am[locale] : pm[locale]\n                if(res === undefined){\n                    throw _b_.ValueError.$factory(\"no format \" + spec + \" for locale \" +\n                        locale)\n                }\n                return res\n            }\n            else if(spec == \"x\"){\n                t = x_format\n            }else if(spec == \"X\"){\n                t = X_format\n            }else{\n                throw _b_.ValueError.$factory(\"invalid format\", spec)\n            }\n            for(var key in t){\n                if(t[key].indexOf(locale) > -1){\n                    return key\n                }\n            }\n            throw _b_.ValueError.$factory(\"no format \" + spec + \" for locale \" +\n                locale)\n        },\n\n        localeconv: function(){\n            var conv = {'grouping': [127],\n                    'currency_symbol': '',\n                    'n_sign_posn': 127,\n                    'p_cs_precedes': 127,\n                    'n_cs_precedes': 127,\n                    'mon_grouping': [],\n                    'n_sep_by_space': 127,\n                    'decimal_point': '.',\n                    'negative_sign': '',\n                    'positive_sign': '',\n                    'p_sep_by_space': 127,\n                    'int_curr_symbol': '',\n                    'p_sign_posn': 127,\n                    'thousands_sep': '',\n                    'mon_thousands_sep': '',\n                    'frac_digits': 127,\n                    'mon_decimal_point': '',\n                    'int_frac_digits': 127\n             }\n             var res = _b_.dict.$factory()\n             res.$string_dict = conv\n             return res\n         },\n\n        setlocale : function(){\n            var $ = $B.args(\"setlocale\", 2, {category: null, locale: null},\n                [\"category\", \"locale\"], arguments, {locale: _b_.None},\n                null, null)\n            /// XXX category is currently ignored\n            if($.locale == \"\"){\n                // use browser language setting, if it is set\n                var LANG = ($B.language || \"\").substr(0, 2)\n                if(am.hasOwnProperty(LANG)){\n                    $B.locale = LANG\n                    return LANG\n                }else{\n                    console.log(\"Unknown locale: \" + LANG)\n                }\n            }else if($.locale === _b_.None){\n                // return current locale\n                return $B.locale\n            }else{\n                // Only use 2 first characters\n                try{$.locale.substr(0, 2)}\n                catch(err){\n                    throw $module.Error.$factory(\"Invalid locale: \" + $.locale)\n                }\n                if(am.hasOwnProperty($.locale.substr(0, 2))){\n                    $B.locale = $.locale\n                    return $.locale\n                }else{\n                    throw $module.Error.$factory(\"Unknown locale: \" + $.locale)\n                }\n            }\n        }\n    }\n})(__BRYTHON__)\n"], "_multiprocessing": [".js", "// multiprocessing\nvar $module = (function($B){\n\nvar _b_ = $B.builtins\nvar $s=[]\nfor(var $b in _b_) $s.push('var ' + $b +'=_b_[\"'+$b+'\"]')\neval($s.join(';'))\n\n//for(var $py_builtin in _b_){eval(\"var \"+$py_builtin+\"=_b_[$py_builtin]\")}\n\nvar Process = {\n    __class__:_b_.type,\n    __mro__: [_b_.object],\n    $infos:{\n        __name__:'Process'\n    },\n    $is_class: true\n}\n\nvar $convert_args=function(args) {\n    var _list=[]\n    for(var i=0, _len_i = args.length; i < _len_i; i++) {\n      var _a=args[i]\n      if(isinstance(_a, str)){_list.push(\"'\"+_a+\"'\")} else {_list.push(_a)}\n    }\n\n    return _list.join(',')\n}\n\nProcess.is_alive = function(self){return self.$alive}\n\nProcess.join = function(self, timeout){\n   // need to block until process is complete\n   // could probably use a addEventListener to execute all existing code\n   // after this join statement\n\n   self.$worker.addEventListener('message', function (e) {\n        var data=e.data\n        if (data.stdout != '') { // output stdout from process\n           $B.stdout.write(data.stdout)\n        }\n   }, false);\n}\n\nProcess.run = function(self){\n   //fix me\n}\n\nProcess.start = function(self){\n   self.$worker.postMessage({target: self.$target,\n                             args: $convert_args(self.$args),\n                          //   kwargs: self.$kwargs\n                           })\n   self.$worker.addEventListener('error', function(e) { throw e})\n   self.$alive=true\n}\n\nProcess.terminate = function(self){\n   self.$worker.terminate()\n   self.$alive=false\n}\n\n// variables\n//name\n//daemon\n//pid\n//exitcode\n\nProcess. $factory = function(){\n    //arguments group=None, target=None, name=None, args=(), kwargs=()\n\n    var $ns=$B.args('Process',0,{},[],arguments,{},null,'kw')\n    var kw=$ns['kw']\n\n    var target=_b_.dict.get($ns['kw'],'target',None)\n    var args=_b_.dict.get($ns['kw'],'args',tuple.$factory())\n\n    var worker = new Worker('/src/web_workers/multiprocessing.js')\n\n    var res = {\n        __class__:Process,\n        $worker: worker,\n        name: $ns['name'] || None,\n        $target: target+'',\n        $args: args,\n        //$kwargs: $ns['kw'],\n        $alive: false\n    }\n    return res\n}\n\n$B.set_func_names(Process, \"multiprocessing\")\n\nvar Pool = $B.make_class(\"Pool\")\n\nPool.__enter__ = function(self){}\nPool.__exit__ = function(self){}\n\nPool.__str__ = Pool.toString = Pool.__repr__=function(self){\n   return '<object Pool>'\n}\n\nPool.map = function(){\n\n   var $ns=$B.args('Pool.map', 3,\n       {self:null, func:null, fargs:null}, ['self', 'func', 'fargs'],\n       arguments,{},'args','kw')\n   var func=$ns['func']\n   var fargs=$ns['fargs']\n\n   var _results=[]\n\n   fargs=iter(fargs)\n\n   var _pos=0\n   console.log(self.$processes)\n   _workers=[]\n   for(var i=0; i < self.$processes; i++) {\n       _workers[i] = new Worker('/src/web_workers/multiprocessing.js')\n       var arg\n\n       try{arg=getattr(fargs, '__next__')()}\n       catch(err) {\n          if (err.__class__ !== _b_.StopIteration) throw err\n       }\n       console.log(arg)\n       _workers[i].finished=false\n       _workers[i].postMessage({target: func+'', pos: _pos,\n                             args: $convert_args([arg])})\n       _pos++\n\n       _workers[i].addEventListener('message', function(e) {\n           _results[e.data.pos]=e.data.result\n           if (_results.length == args.length) return _results\n\n           try {\n               arg=getattr(fargs, '__next__')()\n               e.currentTarget.postMessage({target: func+'', pos: _pos,\n                                            args: $convert_args([arg])})\n               _pos++\n           } catch(err) {\n               if (err.__class__ !== _b_.StopIteration) throw err\n               this.finished=true\n           }\n       }, false);\n   }\n}\n\nPool.apply_async = function(){\n\n   var $ns=$B.$MakeArgs('apply_async', 3,\n       {self:null, func:null, fargs:null}, ['self', 'func', 'fargs'],\n       arguments,{},'args','kw')\n   var func=$ns['func']\n   var fargs=$ns['fargs']\n\n   fargs=iter(fargs)\n\n   async_result = {}\n   async_result.get=function(timeout){\n                      console.log(results)\n                      console.log(fargs)\n                      return this.results}\n   async_result.results=[]\n\n   var _pos=0\n\n   _workers=[]\n   for(var i=0; i < self.$processes; i++) {\n       _workers[i] = new Worker('/src/web_workers/multiprocessing.js')\n       var arg\n\n       try{arg=getattr(fargs, '__next__')()}\n       catch(err) {\n          if (err.__class__ !== _b_.StopIteration) throw err\n       }\n       //console.log(arg)\n       //_workers[i].finished=false\n       _workers[i].postMessage({target: func+'', pos: _pos,\n                             args: $convert_args([arg])})\n       _pos++\n\n       _workers[i].addEventListener('message', function(e) {\n           async_result.results[e.data.pos]=e.data.result\n           //if (_results.length == args.length) return _results\n\n           try {\n               arg=getattr(fargs, '__next__')()\n               e.currentTarget.postMessage({target: func+'', pos: _pos,\n                                            args: $convert_args([arg])})\n               _pos++\n           } catch(err) {\n               if (err.__class__ !== _b_.StopIteration) throw err\n               this.finished=true\n           }\n       }, false);\n   }\n\n   console.log(\"return\", async_result)\n   return async_result\n}\n\nPool.$factory = function(){\n    console.log(\"pool\")\n    console.log(arguments)\n    var $ns=$B.args('Pool',1,\n        {processes:null},['processes'],arguments,{},'args','kw')\n    //var kw=$ns['kw']\n\n    var processes=$ns['processes']\n\n    if (processes == None) {\n       // look to see if we have stored cpu_count in local storage\n       // maybe we should create a brython config file with settings,etc..??\n\n       // if not there use a tool such as Core Estimator to calculate number of cpu's\n       // http://eligrey.com/blog/post/cpu-core-estimation-with-javascript\n    }\n\n    console.log(processes)\n    var res = {\n        __class__:Pool,\n        $processes:processes\n    }\n    return res\n}\n\n$B.set_func_names(Pool, \"multiprocessing\")\n\nreturn {Process:Process, Pool:Pool}\n\n})(__BRYTHON__)\n"], "_posixsubprocess": [".js", "var $module=(function($B){\n\n    return {\n       cloexec_pipe: function() {}   // fixme\n    }\n})(__BRYTHON__)\n"], "_profile": [".js", "// Private interface to the profiling instrumentation implemented in py_utils.js.\n// Uses local a copy of the eval function from py_builtin_functions.js\n\nvar $module=(function($B) {\n    eval($B.InjectBuiltins());\n    return {\n        brython:$B,\n        data:$B.$profile_data,\n        start:$B.$profile.start,\n        stop:$B.$profile.stop,\n        pause:$B.$profile.pause,\n        status:$B.$profile.status,\n        clear:$B.$profile.clear,\n        elapsed:$B.$profile.elapsed,\n        run:function(src,_globals,_locals,nruns) {\n            var current_frame = $B.frames_stack[$B.frames_stack.length-1]\n            if(current_frame!==undefined){\n                var current_locals_id = current_frame[0].replace(/\\./,'_'),\n             current_globals_id = current_frame[2].replace(/\\./,'_')\n            }\n\n            var is_exec = true,\n                leave = false\n\n            // code will be run in a specific block\n            var globals_id = '$profile_'+$B.UUID(),\n             locals_id\n\n             if(_locals===_globals){\n                 locals_id = globals_id\n             }else{\n                 locals_id = '$profile_'+$B.UUID()\n             }\n             // Initialise the object for block namespaces\n             eval('var $locals_'+globals_id+' = {}\\nvar $locals_'+locals_id+' = {}')\n\n             // Initialise block globals\n\n            // A _globals dictionary is provided, set or reuse its attribute\n            // globals_id\n            _globals.globals_id = _globals.globals_id || globals_id\n            globals_id = _globals.globals_id\n\n            if(_locals === _globals || _locals === undefined){\n                locals_id = globals_id\n                parent_scope = $B.builtins_scope\n            }else{\n                // The parent block of locals must be set to globals\n                parent_scope = {\n                    id: globals_id,\n                    parent_block: $B.builtins_scope,\n                    binding: {}\n                }\n                for(var attr in _globals.$string_dict){\n                    parent_scope.binding[attr] = true\n                }\n            }\n\n            // Initialise block globals\n            if(_globals.$jsobj){var items = _globals.$jsobj}\n            else{var items = _globals.$string_dict}\n            for(var item in items){\n                item1 = to_alias(item)\n                try{\n                    eval('$locals_' + globals_id + '[\"' + item1 +\n                        '\"] = items[item]')\n                }catch(err){\n                    console.log(err)\n                    console.log('error setting', item)\n                    break\n                }\n            }\n\n             // Initialise block locals\n            var items = _b_.dict.items(_locals), item\n            if(_locals.$jsobj){var items = _locals.$jsobj}\n            else{var items = _locals.$string_dict}\n            for(var item in items){\n                item1 = to_alias(item)\n                try{\n                    eval('$locals_' + locals_id + '[\"' + item[0] + '\"] = item[1]')\n                }catch(err){\n                    console.log(err)\n                    console.log('error setting', item)\n                    break\n                }\n            }\n             //var nb_modules = Object.keys(__BRYTHON__.modules).length\n             //console.log('before exec', nb_modules)\n\n            console.log(\"call py2js\", src, globals_id, locals_id, parent_scope)\n            var root = $B.py2js(src, globals_id, locals_id, parent_scope),\n                js, gns, lns\n\n             try{\n\n                 var js = root.to_js()\n\n                     var i,res,gns;\n                     for(i=0;i<nruns;i++) {\n                         res = eval(js)\n                         gns = eval('$locals_'+globals_id)\n                     }\n\n                     // Update _locals with the namespace after execution\n                     if(_locals!==undefined){\n                         var lns = eval('$locals_'+locals_id)\n                         var setitem = getattr(_locals,'__setitem__')\n                         for(var attr in lns){\n                             if(attr.charAt(0)=='$'){continue}\n                             setitem(attr, lns[attr])\n                         }\n                     }else{\n                         for(var attr in lns){current_frame[1][attr] = lns[attr]}\n                     }\n\n                     if(_globals!==undefined){\n                         // Update _globals with the namespace after execution\n                         var setitem = getattr(_globals,'__setitem__')\n                         for(var attr in gns){\n                             if(attr.charAt(0)=='$'){continue}\n                             setitem(attr, gns[attr])\n                         }\n                     }else{\n                         for(var attr in gns){\n                             current_frame[3][attr] = gns[attr]\n                         }\n                     }\n\n                     // fixme: some extra variables are bleeding into locals...\n                     /*  This also causes issues for unittests */\n                     if(res===undefined) return _b_.None\n                         return res\n             }catch(err){\n                 if(err.$py_error===undefined){throw $B.exception(err)}\n                 throw err\n             }finally{\n\n                 delete __BRYTHON__.modules[globals_id]\n                 delete __BRYTHON__.modules[locals_id]\n                 $B.clear_ns(globals_id)\n                 $B.clear_ns(locals_id)\n\n                 if(!is_exec && leave_frame){\n                     // For eval(), the finally clause with \"leave_frame\" was removed\n                     // so we must execute it here\n                     $B.frames_stack.pop()\n                 }\n             }\n        }\n    }\n})(__BRYTHON__)\n"], "_sre_utils": [".js", "var $module=(function($B){\n\n    function unicode_iscased(cp){\n        // cp : Unicode code point\n        var letter = String.fromCodePoint(cp)\n        return (letter != letter.toLowerCase() ||\n            letter != letter.toUpperCase())\n    }\n\n    function ascii_iscased(cp){\n        if(cp > 255){return false}\n        return unicode_iscased(cp)\n    }\n\n    function unicode_tolower(cp){\n        var letter = String.fromCodePoint(cp),\n            lower = letter.toLowerCase()\n        return lower.charCodeAt(0)\n    }\n\n    function ascii_tolower(cp){\n        return unicode_tolower(cp)\n    }\n\nreturn {\n    unicode_iscased: unicode_iscased,\n    ascii_iscased: ascii_iscased,\n    unicode_tolower: unicode_tolower,\n    ascii_tolower: ascii_tolower\n}\n\n}\n\n)(__BRYTHON__)"], "_string": [".js", "var $module=(function($B){\n\nvar _b_ = $B.builtins\n\nfunction parts(format_string){\n    var result = [],\n        _parts = $B.split_format(format_string) // defined in py_string.js\n    for(var i = 0; i < _parts.length; i+= 2){\n        result.push({pre: _parts[i], fmt: _parts[i + 1]})\n    }\n    return result\n}\n\nfunction Tuple(){\n    var args = []\n    for(var i=0, len=arguments.length; i < len; i++){\n        args.push(arguments[i])\n    }\n    return _b_.tuple.$factory(args)\n}\n\nreturn{\n\n    formatter_field_name_split: function(fieldname){\n        // Split the argument as a field name\n        var parsed = $B.parse_format(fieldname),\n            first = parsed.name,\n            rest = []\n        if(first.match(/\\d+/)){first = parseInt(first)}\n        parsed.name_ext.forEach(function(ext){\n            if(ext.startsWith(\"[\")){\n                var item = ext.substr(1, ext.length - 2)\n                if(item.match(/\\d+/)){\n                    rest.push(Tuple(false, parseInt(item)))\n                }else{\n                    rest.push(Tuple(false, item))\n                }\n            }else{\n                rest.push(Tuple(true, ext.substr(1)))\n            }\n        })\n        return Tuple(first, _b_.iter(rest))\n    },\n    formatter_parser: function(format_string){\n        // Parse the argument as a format string\n\n        if(! _b_.isinstance(format_string, _b_.str)){\n            throw _b_.ValueError.$factory(\"Invalid format string type: \" +\n                $B.class_name(format_string))\n        }\n\n        var result  = []\n        parts(format_string).forEach(function(item){\n            var pre = item.pre === undefined ? \"\" : item.pre,\n                fmt = item.fmt\n            if(fmt === undefined){\n               result.push(Tuple(pre, _b_.None, _b_.None, _b_.None))\n            }else if(fmt.string == ''){\n               result.push(Tuple(pre, '', '', _b_.None))\n            }else{\n               result.push(Tuple(pre,\n                   fmt.raw_name + fmt.name_ext.join(\"\"),\n                   fmt.raw_spec,\n                   fmt.conv || _b_.None))\n           }\n        })\n        return result\n    }\n}\n})(__BRYTHON__)"], "_strptime": [".js", "var _b_ = __BRYTHON__.builtins\n\nvar $module = (function($B){\n    return {\n        _strptime_datetime: function(cls, s, fmt){\n            var pos_s = 0,\n                pos_fmt = 0,\n                dt = {}\n            function error(){\n                throw Error(\"no match \" + pos_s + \" \" + s.charAt(pos_s) + \" \"+\n                    pos_fmt + \" \" + fmt.charAt(pos_fmt))\n            }\n\n            var locale = __BRYTHON__.locale,\n                shortdays = [],\n                longdays = [],\n                conv_func = locale == \"C\" ?\n                    function(d){return d.toDateString()} :\n                    function(d, options){\n                        return d.toLocaleDateString(locale, options)\n                    }\n\n            for(var day = 16; day < 23; day++){\n                var d = new Date(Date.UTC(2012, 11, day, 3, 0, 0))\n                shortdays.push(conv_func(d, {weekday: 'short'}))\n                longdays.push(conv_func(d, {weekday: 'long'}))\n            }\n\n            var shortmonths = [],\n                longmonths = []\n\n            for(var month = 0; month < 12; month++){\n                var d = new Date(Date.UTC(2012, month, 1, 3, 0, 0))\n                shortmonths.push(conv_func(d, {month: 'short'}))\n                longmonths.push(conv_func(d, {month: 'long'}))\n            }\n\n            var shortdays_re = new RegExp(shortdays.join(\"|\").replace(\".\", \"\\\\.\")),\n                longdays_re = new RegExp(longdays.join(\"|\")),\n                shortmonths_re = new RegExp(shortmonths.join(\"|\").replace(\".\", \"\\\\.\")),\n                longmonths_re = new RegExp(longmonths.join(\"|\"))\n\n            var regexps = {\n                d: [\"day\", new RegExp(\"0[1-9]|[123][0-9]\")],\n                H: [\"hour\", new RegExp(\"[01][0-9]|2[0-3]|\\\\d\")],\n                I: [\"hour\", new RegExp(\"0[0-9]|1[0-2]\")],\n                m: [\"month\", new RegExp(\"0[1-9]|1[012]\")],\n                M: [\"minute\", new RegExp(\"[0-5][0-9]\")],\n                S: [\"second\", new RegExp(\"([1-5]\\\\d)|(0?\\\\d)\")],\n                y: [\"year\", new RegExp(\"0{0,2}\\\\d{2}\")],\n                Y: [\"year\", new RegExp(\"\\\\d{4}\")]\n            }\n\n            while(pos_fmt < fmt.length){\n                var car = fmt.charAt(pos_fmt)\n                if(car == \"%\"){\n                    var spec = fmt.charAt(pos_fmt + 1),\n                        regexp = regexps[spec]\n                    if(regexp !== undefined){\n                        var re = regexp[1],\n                            attr = regexp[0],\n                            res = re.exec(s.substr(pos_s))\n                        if(res === null){\n                            error()\n                        }else{\n                            if(dt[attr] !== undefined){\n                                throw Error(attr + \" is defined more than once\")\n                            }else{\n                                dt[attr] = parseInt(res[0])\n                                pos_fmt += 2\n                                pos_s += res[0].length\n                            }\n                        }\n                    }else if(spec == \"a\" || spec == \"A\"){\n                        // Locale's abbreviated (a) or full (A) weekday name\n                        var attr = \"weekday\",\n                            re = spec == \"a\" ? shortdays_re : longdays_re,\n                            t = spec == \"a\" ? shortdays : longdays\n                            res = re.exec(s.substr(pos_s))\n                        if(res === null){\n                            error()\n                        }else{\n                            var match = res[0],\n                                ix = t.indexOf(match)\n                        }\n                        if(dt.weekday !== undefined){\n                            throw Error(attr + \" is defined more than once\")\n                        }else{\n                            dt.weekday = ix\n                        }\n                        pos_fmt += 2\n                        pos_s += match.length\n                    }else if(spec == \"b\" || spec == \"B\"){\n                        // Locales's abbreviated (b) or full (B) month\n                        var attr = \"month\",\n                            re = spec == \"b\" ? shortmonths_re : longmonths_re,\n                            t = spec == \"b\" ? shortmonths : longmonths,\n                            res = re.exec(s.substr(pos_s))\n                        if(res === null){\n                            error()\n                        }else{\n                            var match = res[0],\n                                ix = t.indexOf(match)\n                        }\n                        if(dt.month !== undefined){\n                            throw Error(attr + \" is defined more than once\")\n                        }else{\n                            dt.month = ix + 1\n                        }\n                        pos_fmt += 2\n                        pos_s += match.length\n                    }else if(spec == \"c\"){\n                        // Locale's appropriate date and time representation\n                        var fmt1 = fmt.substr(0, pos_fmt - 1) + _locale_c_format() +\n                            fmt.substr(pos_fmt + 2)\n                        console.log(\"fmt1\", fmt1)\n                        fmt = fmt1\n                    }else if(spec == \"%\"){\n                        if(s.charAt(pos_s) == \"%\"){\n                            pos_fmt++\n                            pos_s++\n                        }else{\n                            error()\n                        }\n                    }else{\n                        pos_fmt++\n                    }\n                }else{\n                    if(car == s.charAt(pos_s)){\n                        pos_fmt++\n                        pos_s++\n                    }else{\n                        error()\n                    }\n                }\n            }\n            return $B.$call(cls)(dt.year, dt.month, dt.day,\n                dt.hour || 0, dt.minute || 0, dt.second || 0)\n        }\n    }\n})(__BRYTHON__)\n"], "_svg": [".js", "// creation of an HTML element\nvar $module = (function($B){\n\nvar _b_ = $B.builtins\nvar TagSum = $B.TagSum // defined in py_dom.js\n\nvar $s=[]\nfor(var $b in _b_) $s.push('var ' + $b +' = _b_[\"' + $b + '\"]')\neval($s.join(';'))\n\nvar $svgNS = \"http://www.w3.org/2000/svg\"\nvar $xlinkNS = \"http://www.w3.org/1999/xlink\"\n\nfunction makeTagDict(tagName){\n    // return the dictionary for the class associated with tagName\n    var dict = $B.make_class(tagName)\n\n    dict.__init__ = function(){\n        var $ns = $B.args('__init__', 1, {self: null}, ['self'],\n            arguments, {}, 'args', 'kw'),\n            self = $ns['self'],\n            args = $ns['args']\n        if(args.length == 1){\n            var first = args[0]\n            if(isinstance(first, [str, int, float])){\n                self.elt.appendChild(document.createTextNode(str.$factory(first)))\n            }else if(first.__class__ === TagSum){\n                for(var i = 0, len = first.children.length; i < len; i++){\n                    self.elt.appendChild(first.children[i].elt)\n                }\n            }else{ // argument is another DOMNode instance\n                try{self.elt.appendChild(first.elt)}\n                catch(err){throw ValueError.$factory('wrong element ' + first)}\n            }\n        }\n\n        // attributes\n        var items = _b_.list.$factory(_b_.dict.items($ns['kw']))\n        for(var i = 0, len = items.length; i < len; i++){\n            // keyword arguments\n            var arg = items[i][0],\n                value = items[i][1]\n            if(arg.toLowerCase().substr(0,2) == \"on\"){\n                // Event binding passed as argument \"onclick\", \"onfocus\"...\n                // Better use method bind of DOMNode objects\n                var js = '$B.DOMNode.bind(self,\"' +\n                    arg.toLowerCase().substr(2)\n                eval(js+'\",function(){'+value+'})')\n            }else if(arg.toLowerCase() == \"style\"){\n                $B.DOMNode.set_style(self,value)\n            }else if(arg.toLowerCase().indexOf(\"href\") !== -1){ // xlink:href\n                self.elt.setAttributeNS( \"http://www.w3.org/1999/xlink\",\n                    \"href\",value)\n            }else{\n                if(value !== false){\n                    // option.selected=false sets it to true :-)\n                    try{\n                        arg = arg.replace('_', '-')\n                        self.elt.setAttributeNS(null, arg, value)\n                    }catch(err){\n                        throw ValueError.$factory(\"can't set attribute \" + arg)\n                    }\n                }\n            }\n        }\n    }\n\n    dict.__mro__ = [$B.DOMNode, $B.builtins.object]\n\n    dict.__new__ = function(cls){\n        var res = $B.DOMNode.$factory(document.createElementNS($svgNS, tagName))\n        res.__class__ = cls\n        return res\n    }\n\n    dict.$factory = function(){\n        var res = $B.DOMNode.$factory(\n            document.createElementNS($svgNS, tagName))\n        res.__class__ = dict\n        // apply __init__\n        dict.__init__(res, ...arguments)\n        return res\n    }\n\n    $B.set_func_names(dict, \"browser.svg\")\n\n    return dict\n}\n\n\n// SVG\nvar $svg_tags = ['a',\n'altGlyph',\n'altGlyphDef',\n'altGlyphItem',\n'animate',\n'animateColor',\n'animateMotion',\n'animateTransform',\n'circle',\n'clipPath',\n'color_profile', // instead of color-profile\n'cursor',\n'defs',\n'desc',\n'ellipse',\n'feBlend',\n'foreignObject', //patch to enable foreign objects\n'g',\n'image',\n'line',\n'linearGradient',\n'marker',\n'mask',\n'path',\n'pattern',\n'polygon',\n'polyline',\n'radialGradient',\n'rect',\n'set',\n'stop',\n'svg',\n'text',\n'tref',\n'tspan',\n'use']\n\n// create classes\nvar obj = new Object()\nvar dicts = {}\nfor(var i = 0, len = $svg_tags.length; i < len; i++){\n    var tag = $svg_tags[i]\n    obj[tag] = makeTagDict(tag)\n}\nreturn obj\n})(__BRYTHON__)\n"], "_sys": [".js", "var $module=(function($B){\n    var _b_ = $B.builtins\n    return {\n        // Called \"Getframe\" because \"_getframe\" wouldn't be imported in\n        // sys.py with \"from _sys import *\"\n        Getframe : function(depth){\n            return $B._frame.$factory($B.frames_stack, depth)\n        },\n        modules :\n            {'__get__':function(){\n                console.log(\"get sys.modules\")\n                return $B.obj_dict($B.imported)\n            },\n             '__set__':function(self, obj, value){ throw _b_.TypeError(\"Read only property 'sys.modules'\") }\n            },\n        path:\n            {'__get__':function(){return $B.path},\n             '__set__':function(self, obj, value){ $B.path = value }\n            },\n        meta_path:\n            {'__get__':function(){return $B.meta_path},\n             '__set__':function(self, obj, value){ $B.meta_path = value }\n            },\n        path_hooks:\n            {'__get__':function(){return $B.path_hooks},\n             '__set__':function(self, obj, value){ $B.path_hooks = value }\n            },\n        path_importer_cache:\n            {'__get__':function(){\n                return _b_.dict.$factory($B.JSObject.$factory($B.path_importer_cache))\n            },\n             '__set__':function(self, obj, value){\n                 throw _b_.TypeError(\"Read only property 'sys.path_importer_cache'\")\n            }\n        },\n        stderr : {\n            __get__:function(){return $B.stderr},\n            __set__:function(self, obj, value){$B.stderr = value},\n            write:function(data){_b_.getattr($B.stderr,\"write\")(data)}\n            },\n        stdout : {\n            __get__:function(){return $B.stdout},\n            __set__:function(self, obj, value){$B.stdout = value},\n            write:function(data){_b_.getattr($B.stdout,\"write\")(data)}\n            },\n        stdin : $B.stdin\n    }\n})(__BRYTHON__)\n"], "_warnings": [".js", "var $module = (function($B){\n\n_b_ = $B.builtins\n\nreturn  {\n    __doc__: \"_warnings provides basic warning filtering support.\\n \" +\n        \"It is a helper module to speed up interpreter start-up.\",\n\n    default_action: \"default\",\n\n    filters: [\n        ['ignore', _b_.None, _b_.DeprecationWarning, _b_.None, 0],\n        ['ignore', _b_.None, _b_.PendingDeprecationWarning, _b_.None, 0],\n        ['ignore', _b_.None, _b_.ImportWarning, _b_.None, 0],\n        ['ignore', _b_.None, _b_.BytesWarning, _b_.None, 0]].map(\n            function(x){return _b_.tuple.$factory(x)}),\n\n    once_registry: _b_.dict.$factory(),\n\n    warn: function(){},\n\n    warn_explicit: function(){}\n\n}\n\n})(__BRYTHON__)\n"], "crypto_js.rollups.md5": [".js", "/*\nCryptoJS v3.1.2\ncode.google.com/p/crypto-js\n(c) 2009-2013 by Jeff Mott. All rights reserved.\ncode.google.com/p/crypto-js/wiki/License\n*/\nvar CryptoJS=CryptoJS||function(s,p){var m={},l=m.lib={},n=function(){},r=l.Base={extend:function(b){n.prototype=this;var h=new n;b&&h.mixIn(b);h.hasOwnProperty(\"init\")||(h.init=function(){h.$super.init.apply(this,arguments)});h.init.prototype=h;h.$super=this;return h},create:function(){var b=this.extend();b.init.apply(b,arguments);return b},init:function(){},mixIn:function(b){for(var h in b)b.hasOwnProperty(h)&&(this[h]=b[h]);b.hasOwnProperty(\"toString\")&&(this.toString=b.toString)},clone:function(){return this.init.prototype.extend(this)}},\nq=l.WordArray=r.extend({init:function(b,h){b=this.words=b||[];this.sigBytes=h!=p?h:4*b.length},toString:function(b){return(b||t).stringify(this)},concat:function(b){var h=this.words,a=b.words,j=this.sigBytes;b=b.sigBytes;this.clamp();if(j%4)for(var g=0;g<b;g++)h[j+g>>>2]|=(a[g>>>2]>>>24-8*(g%4)&255)<<24-8*((j+g)%4);else if(65535<a.length)for(g=0;g<b;g+=4)h[j+g>>>2]=a[g>>>2];else h.push.apply(h,a);this.sigBytes+=b;return this},clamp:function(){var b=this.words,h=this.sigBytes;b[h>>>2]&=4294967295<<\n32-8*(h%4);b.length=s.ceil(h/4)},clone:function(){var b=r.clone.call(this);b.words=this.words.slice(0);return b},random:function(b){for(var h=[],a=0;a<b;a+=4)h.push(4294967296*s.random()|0);return new q.init(h,b)}}),v=m.enc={},t=v.Hex={stringify:function(b){var a=b.words;b=b.sigBytes;for(var g=[],j=0;j<b;j++){var k=a[j>>>2]>>>24-8*(j%4)&255;g.push((k>>>4).toString(16));g.push((k&15).toString(16))}return g.join(\"\")},parse:function(b){for(var a=b.length,g=[],j=0;j<a;j+=2)g[j>>>3]|=parseInt(b.substr(j,\n2),16)<<24-4*(j%8);return new q.init(g,a/2)}},a=v.Latin1={stringify:function(b){var a=b.words;b=b.sigBytes;for(var g=[],j=0;j<b;j++)g.push(String.fromCharCode(a[j>>>2]>>>24-8*(j%4)&255));return g.join(\"\")},parse:function(b){for(var a=b.length,g=[],j=0;j<a;j++)g[j>>>2]|=(b.charCodeAt(j)&255)<<24-8*(j%4);return new q.init(g,a)}},u=v.Utf8={stringify:function(b){try{return decodeURIComponent(escape(a.stringify(b)))}catch(g){throw Error(\"Malformed UTF-8 data\");}},parse:function(b){return a.parse(unescape(encodeURIComponent(b)))}},\ng=l.BufferedBlockAlgorithm=r.extend({reset:function(){this._data=new q.init;this._nDataBytes=0},_append:function(b){\"string\"==typeof b&&(b=u.parse(b));this._data.concat(b);this._nDataBytes+=b.sigBytes},_process:function(b){var a=this._data,g=a.words,j=a.sigBytes,k=this.blockSize,m=j/(4*k),m=b?s.ceil(m):s.max((m|0)-this._minBufferSize,0);b=m*k;j=s.min(4*b,j);if(b){for(var l=0;l<b;l+=k)this._doProcessBlock(g,l);l=g.splice(0,b);a.sigBytes-=j}return new q.init(l,j)},clone:function(){var b=r.clone.call(this);\nb._data=this._data.clone();return b},_minBufferSize:0});l.Hasher=g.extend({cfg:r.extend(),init:function(b){this.cfg=this.cfg.extend(b);this.reset()},reset:function(){g.reset.call(this);this._doReset()},update:function(b){this._append(b);this._process();return this},finalize:function(b){b&&this._append(b);return this._doFinalize()},blockSize:16,_createHelper:function(b){return function(a,g){return(new b.init(g)).finalize(a)}},_createHmacHelper:function(b){return function(a,g){return(new k.HMAC.init(b,\ng)).finalize(a)}}});var k=m.algo={};return m}(Math);\n(function(s){function p(a,k,b,h,l,j,m){a=a+(k&b|~k&h)+l+m;return(a<<j|a>>>32-j)+k}function m(a,k,b,h,l,j,m){a=a+(k&h|b&~h)+l+m;return(a<<j|a>>>32-j)+k}function l(a,k,b,h,l,j,m){a=a+(k^b^h)+l+m;return(a<<j|a>>>32-j)+k}function n(a,k,b,h,l,j,m){a=a+(b^(k|~h))+l+m;return(a<<j|a>>>32-j)+k}for(var r=CryptoJS,q=r.lib,v=q.WordArray,t=q.Hasher,q=r.algo,a=[],u=0;64>u;u++)a[u]=4294967296*s.abs(s.sin(u+1))|0;q=q.MD5=t.extend({_doReset:function(){this._hash=new v.init([1732584193,4023233417,2562383102,271733878])},\n_doProcessBlock:function(g,k){for(var b=0;16>b;b++){var h=k+b,w=g[h];g[h]=(w<<8|w>>>24)&16711935|(w<<24|w>>>8)&4278255360}var b=this._hash.words,h=g[k+0],w=g[k+1],j=g[k+2],q=g[k+3],r=g[k+4],s=g[k+5],t=g[k+6],u=g[k+7],v=g[k+8],x=g[k+9],y=g[k+10],z=g[k+11],A=g[k+12],B=g[k+13],C=g[k+14],D=g[k+15],c=b[0],d=b[1],e=b[2],f=b[3],c=p(c,d,e,f,h,7,a[0]),f=p(f,c,d,e,w,12,a[1]),e=p(e,f,c,d,j,17,a[2]),d=p(d,e,f,c,q,22,a[3]),c=p(c,d,e,f,r,7,a[4]),f=p(f,c,d,e,s,12,a[5]),e=p(e,f,c,d,t,17,a[6]),d=p(d,e,f,c,u,22,a[7]),\nc=p(c,d,e,f,v,7,a[8]),f=p(f,c,d,e,x,12,a[9]),e=p(e,f,c,d,y,17,a[10]),d=p(d,e,f,c,z,22,a[11]),c=p(c,d,e,f,A,7,a[12]),f=p(f,c,d,e,B,12,a[13]),e=p(e,f,c,d,C,17,a[14]),d=p(d,e,f,c,D,22,a[15]),c=m(c,d,e,f,w,5,a[16]),f=m(f,c,d,e,t,9,a[17]),e=m(e,f,c,d,z,14,a[18]),d=m(d,e,f,c,h,20,a[19]),c=m(c,d,e,f,s,5,a[20]),f=m(f,c,d,e,y,9,a[21]),e=m(e,f,c,d,D,14,a[22]),d=m(d,e,f,c,r,20,a[23]),c=m(c,d,e,f,x,5,a[24]),f=m(f,c,d,e,C,9,a[25]),e=m(e,f,c,d,q,14,a[26]),d=m(d,e,f,c,v,20,a[27]),c=m(c,d,e,f,B,5,a[28]),f=m(f,c,\nd,e,j,9,a[29]),e=m(e,f,c,d,u,14,a[30]),d=m(d,e,f,c,A,20,a[31]),c=l(c,d,e,f,s,4,a[32]),f=l(f,c,d,e,v,11,a[33]),e=l(e,f,c,d,z,16,a[34]),d=l(d,e,f,c,C,23,a[35]),c=l(c,d,e,f,w,4,a[36]),f=l(f,c,d,e,r,11,a[37]),e=l(e,f,c,d,u,16,a[38]),d=l(d,e,f,c,y,23,a[39]),c=l(c,d,e,f,B,4,a[40]),f=l(f,c,d,e,h,11,a[41]),e=l(e,f,c,d,q,16,a[42]),d=l(d,e,f,c,t,23,a[43]),c=l(c,d,e,f,x,4,a[44]),f=l(f,c,d,e,A,11,a[45]),e=l(e,f,c,d,D,16,a[46]),d=l(d,e,f,c,j,23,a[47]),c=n(c,d,e,f,h,6,a[48]),f=n(f,c,d,e,u,10,a[49]),e=n(e,f,c,d,\nC,15,a[50]),d=n(d,e,f,c,s,21,a[51]),c=n(c,d,e,f,A,6,a[52]),f=n(f,c,d,e,q,10,a[53]),e=n(e,f,c,d,y,15,a[54]),d=n(d,e,f,c,w,21,a[55]),c=n(c,d,e,f,v,6,a[56]),f=n(f,c,d,e,D,10,a[57]),e=n(e,f,c,d,t,15,a[58]),d=n(d,e,f,c,B,21,a[59]),c=n(c,d,e,f,r,6,a[60]),f=n(f,c,d,e,z,10,a[61]),e=n(e,f,c,d,j,15,a[62]),d=n(d,e,f,c,x,21,a[63]);b[0]=b[0]+c|0;b[1]=b[1]+d|0;b[2]=b[2]+e|0;b[3]=b[3]+f|0},_doFinalize:function(){var a=this._data,k=a.words,b=8*this._nDataBytes,h=8*a.sigBytes;k[h>>>5]|=128<<24-h%32;var l=s.floor(b/\n4294967296);k[(h+64>>>9<<4)+15]=(l<<8|l>>>24)&16711935|(l<<24|l>>>8)&4278255360;k[(h+64>>>9<<4)+14]=(b<<8|b>>>24)&16711935|(b<<24|b>>>8)&4278255360;a.sigBytes=4*(k.length+1);this._process();a=this._hash;k=a.words;for(b=0;4>b;b++)h=k[b],k[b]=(h<<8|h>>>24)&16711935|(h<<24|h>>>8)&4278255360;return a},clone:function(){var a=t.clone.call(this);a._hash=this._hash.clone();return a}});r.MD5=t._createHelper(q);r.HmacMD5=t._createHmacHelper(q)})(Math);\n"], "crypto_js.rollups.sha1": [".js", "/*\nCryptoJS v3.1.2\ncode.google.com/p/crypto-js\n(c) 2009-2013 by Jeff Mott. All rights reserved.\ncode.google.com/p/crypto-js/wiki/License\n*/\nvar CryptoJS=CryptoJS||function(e,m){var p={},j=p.lib={},l=function(){},f=j.Base={extend:function(a){l.prototype=this;var c=new l;a&&c.mixIn(a);c.hasOwnProperty(\"init\")||(c.init=function(){c.$super.init.apply(this,arguments)});c.init.prototype=c;c.$super=this;return c},create:function(){var a=this.extend();a.init.apply(a,arguments);return a},init:function(){},mixIn:function(a){for(var c in a)a.hasOwnProperty(c)&&(this[c]=a[c]);a.hasOwnProperty(\"toString\")&&(this.toString=a.toString)},clone:function(){return this.init.prototype.extend(this)}},\nn=j.WordArray=f.extend({init:function(a,c){a=this.words=a||[];this.sigBytes=c!=m?c:4*a.length},toString:function(a){return(a||h).stringify(this)},concat:function(a){var c=this.words,q=a.words,d=this.sigBytes;a=a.sigBytes;this.clamp();if(d%4)for(var b=0;b<a;b++)c[d+b>>>2]|=(q[b>>>2]>>>24-8*(b%4)&255)<<24-8*((d+b)%4);else if(65535<q.length)for(b=0;b<a;b+=4)c[d+b>>>2]=q[b>>>2];else c.push.apply(c,q);this.sigBytes+=a;return this},clamp:function(){var a=this.words,c=this.sigBytes;a[c>>>2]&=4294967295<<\n32-8*(c%4);a.length=e.ceil(c/4)},clone:function(){var a=f.clone.call(this);a.words=this.words.slice(0);return a},random:function(a){for(var c=[],b=0;b<a;b+=4)c.push(4294967296*e.random()|0);return new n.init(c,a)}}),b=p.enc={},h=b.Hex={stringify:function(a){var c=a.words;a=a.sigBytes;for(var b=[],d=0;d<a;d++){var f=c[d>>>2]>>>24-8*(d%4)&255;b.push((f>>>4).toString(16));b.push((f&15).toString(16))}return b.join(\"\")},parse:function(a){for(var c=a.length,b=[],d=0;d<c;d+=2)b[d>>>3]|=parseInt(a.substr(d,\n2),16)<<24-4*(d%8);return new n.init(b,c/2)}},g=b.Latin1={stringify:function(a){var c=a.words;a=a.sigBytes;for(var b=[],d=0;d<a;d++)b.push(String.fromCharCode(c[d>>>2]>>>24-8*(d%4)&255));return b.join(\"\")},parse:function(a){for(var c=a.length,b=[],d=0;d<c;d++)b[d>>>2]|=(a.charCodeAt(d)&255)<<24-8*(d%4);return new n.init(b,c)}},r=b.Utf8={stringify:function(a){try{return decodeURIComponent(escape(g.stringify(a)))}catch(c){throw Error(\"Malformed UTF-8 data\");}},parse:function(a){return g.parse(unescape(encodeURIComponent(a)))}},\nk=j.BufferedBlockAlgorithm=f.extend({reset:function(){this._data=new n.init;this._nDataBytes=0},_append:function(a){\"string\"==typeof a&&(a=r.parse(a));this._data.concat(a);this._nDataBytes+=a.sigBytes},_process:function(a){var c=this._data,b=c.words,d=c.sigBytes,f=this.blockSize,h=d/(4*f),h=a?e.ceil(h):e.max((h|0)-this._minBufferSize,0);a=h*f;d=e.min(4*a,d);if(a){for(var g=0;g<a;g+=f)this._doProcessBlock(b,g);g=b.splice(0,a);c.sigBytes-=d}return new n.init(g,d)},clone:function(){var a=f.clone.call(this);\na._data=this._data.clone();return a},_minBufferSize:0});j.Hasher=k.extend({cfg:f.extend(),init:function(a){this.cfg=this.cfg.extend(a);this.reset()},reset:function(){k.reset.call(this);this._doReset()},update:function(a){this._append(a);this._process();return this},finalize:function(a){a&&this._append(a);return this._doFinalize()},blockSize:16,_createHelper:function(a){return function(c,b){return(new a.init(b)).finalize(c)}},_createHmacHelper:function(a){return function(b,f){return(new s.HMAC.init(a,\nf)).finalize(b)}}});var s=p.algo={};return p}(Math);\n(function(){var e=CryptoJS,m=e.lib,p=m.WordArray,j=m.Hasher,l=[],m=e.algo.SHA1=j.extend({_doReset:function(){this._hash=new p.init([1732584193,4023233417,2562383102,271733878,3285377520])},_doProcessBlock:function(f,n){for(var b=this._hash.words,h=b[0],g=b[1],e=b[2],k=b[3],j=b[4],a=0;80>a;a++){if(16>a)l[a]=f[n+a]|0;else{var c=l[a-3]^l[a-8]^l[a-14]^l[a-16];l[a]=c<<1|c>>>31}c=(h<<5|h>>>27)+j+l[a];c=20>a?c+((g&e|~g&k)+1518500249):40>a?c+((g^e^k)+1859775393):60>a?c+((g&e|g&k|e&k)-1894007588):c+((g^e^\nk)-899497514);j=k;k=e;e=g<<30|g>>>2;g=h;h=c}b[0]=b[0]+h|0;b[1]=b[1]+g|0;b[2]=b[2]+e|0;b[3]=b[3]+k|0;b[4]=b[4]+j|0},_doFinalize:function(){var f=this._data,e=f.words,b=8*this._nDataBytes,h=8*f.sigBytes;e[h>>>5]|=128<<24-h%32;e[(h+64>>>9<<4)+14]=Math.floor(b/4294967296);e[(h+64>>>9<<4)+15]=b;f.sigBytes=4*e.length;this._process();return this._hash},clone:function(){var e=j.clone.call(this);e._hash=this._hash.clone();return e}});e.SHA1=j._createHelper(m);e.HmacSHA1=j._createHmacHelper(m)})();\n"], "crypto_js.rollups.sha224": [".js", "/*\nCryptoJS v3.1.2\ncode.google.com/p/crypto-js\n(c) 2009-2013 by Jeff Mott. All rights reserved.\ncode.google.com/p/crypto-js/wiki/License\n*/\nvar CryptoJS=CryptoJS||function(g,l){var f={},k=f.lib={},h=function(){},m=k.Base={extend:function(a){h.prototype=this;var c=new h;a&&c.mixIn(a);c.hasOwnProperty(\"init\")||(c.init=function(){c.$super.init.apply(this,arguments)});c.init.prototype=c;c.$super=this;return c},create:function(){var a=this.extend();a.init.apply(a,arguments);return a},init:function(){},mixIn:function(a){for(var c in a)a.hasOwnProperty(c)&&(this[c]=a[c]);a.hasOwnProperty(\"toString\")&&(this.toString=a.toString)},clone:function(){return this.init.prototype.extend(this)}},\nq=k.WordArray=m.extend({init:function(a,c){a=this.words=a||[];this.sigBytes=c!=l?c:4*a.length},toString:function(a){return(a||s).stringify(this)},concat:function(a){var c=this.words,d=a.words,b=this.sigBytes;a=a.sigBytes;this.clamp();if(b%4)for(var e=0;e<a;e++)c[b+e>>>2]|=(d[e>>>2]>>>24-8*(e%4)&255)<<24-8*((b+e)%4);else if(65535<d.length)for(e=0;e<a;e+=4)c[b+e>>>2]=d[e>>>2];else c.push.apply(c,d);this.sigBytes+=a;return this},clamp:function(){var a=this.words,c=this.sigBytes;a[c>>>2]&=4294967295<<\n32-8*(c%4);a.length=g.ceil(c/4)},clone:function(){var a=m.clone.call(this);a.words=this.words.slice(0);return a},random:function(a){for(var c=[],d=0;d<a;d+=4)c.push(4294967296*g.random()|0);return new q.init(c,a)}}),t=f.enc={},s=t.Hex={stringify:function(a){var c=a.words;a=a.sigBytes;for(var d=[],b=0;b<a;b++){var e=c[b>>>2]>>>24-8*(b%4)&255;d.push((e>>>4).toString(16));d.push((e&15).toString(16))}return d.join(\"\")},parse:function(a){for(var c=a.length,d=[],b=0;b<c;b+=2)d[b>>>3]|=parseInt(a.substr(b,\n2),16)<<24-4*(b%8);return new q.init(d,c/2)}},n=t.Latin1={stringify:function(a){var c=a.words;a=a.sigBytes;for(var d=[],b=0;b<a;b++)d.push(String.fromCharCode(c[b>>>2]>>>24-8*(b%4)&255));return d.join(\"\")},parse:function(a){for(var c=a.length,d=[],b=0;b<c;b++)d[b>>>2]|=(a.charCodeAt(b)&255)<<24-8*(b%4);return new q.init(d,c)}},j=t.Utf8={stringify:function(a){try{return decodeURIComponent(escape(n.stringify(a)))}catch(c){throw Error(\"Malformed UTF-8 data\");}},parse:function(a){return n.parse(unescape(encodeURIComponent(a)))}},\nw=k.BufferedBlockAlgorithm=m.extend({reset:function(){this._data=new q.init;this._nDataBytes=0},_append:function(a){\"string\"==typeof a&&(a=j.parse(a));this._data.concat(a);this._nDataBytes+=a.sigBytes},_process:function(a){var c=this._data,d=c.words,b=c.sigBytes,e=this.blockSize,f=b/(4*e),f=a?g.ceil(f):g.max((f|0)-this._minBufferSize,0);a=f*e;b=g.min(4*a,b);if(a){for(var u=0;u<a;u+=e)this._doProcessBlock(d,u);u=d.splice(0,a);c.sigBytes-=b}return new q.init(u,b)},clone:function(){var a=m.clone.call(this);\na._data=this._data.clone();return a},_minBufferSize:0});k.Hasher=w.extend({cfg:m.extend(),init:function(a){this.cfg=this.cfg.extend(a);this.reset()},reset:function(){w.reset.call(this);this._doReset()},update:function(a){this._append(a);this._process();return this},finalize:function(a){a&&this._append(a);return this._doFinalize()},blockSize:16,_createHelper:function(a){return function(c,d){return(new a.init(d)).finalize(c)}},_createHmacHelper:function(a){return function(c,d){return(new v.HMAC.init(a,\nd)).finalize(c)}}});var v=f.algo={};return f}(Math);\n(function(g){for(var l=CryptoJS,f=l.lib,k=f.WordArray,h=f.Hasher,f=l.algo,m=[],q=[],t=function(a){return 4294967296*(a-(a|0))|0},s=2,n=0;64>n;){var j;a:{j=s;for(var w=g.sqrt(j),v=2;v<=w;v++)if(!(j%v)){j=!1;break a}j=!0}j&&(8>n&&(m[n]=t(g.pow(s,0.5))),q[n]=t(g.pow(s,1/3)),n++);s++}var a=[],f=f.SHA256=h.extend({_doReset:function(){this._hash=new k.init(m.slice(0))},_doProcessBlock:function(c,d){for(var b=this._hash.words,e=b[0],f=b[1],g=b[2],k=b[3],h=b[4],l=b[5],m=b[6],n=b[7],p=0;64>p;p++){if(16>p)a[p]=\nc[d+p]|0;else{var j=a[p-15],r=a[p-2];a[p]=((j<<25|j>>>7)^(j<<14|j>>>18)^j>>>3)+a[p-7]+((r<<15|r>>>17)^(r<<13|r>>>19)^r>>>10)+a[p-16]}j=n+((h<<26|h>>>6)^(h<<21|h>>>11)^(h<<7|h>>>25))+(h&l^~h&m)+q[p]+a[p];r=((e<<30|e>>>2)^(e<<19|e>>>13)^(e<<10|e>>>22))+(e&f^e&g^f&g);n=m;m=l;l=h;h=k+j|0;k=g;g=f;f=e;e=j+r|0}b[0]=b[0]+e|0;b[1]=b[1]+f|0;b[2]=b[2]+g|0;b[3]=b[3]+k|0;b[4]=b[4]+h|0;b[5]=b[5]+l|0;b[6]=b[6]+m|0;b[7]=b[7]+n|0},_doFinalize:function(){var a=this._data,d=a.words,b=8*this._nDataBytes,e=8*a.sigBytes;\nd[e>>>5]|=128<<24-e%32;d[(e+64>>>9<<4)+14]=g.floor(b/4294967296);d[(e+64>>>9<<4)+15]=b;a.sigBytes=4*d.length;this._process();return this._hash},clone:function(){var a=h.clone.call(this);a._hash=this._hash.clone();return a}});l.SHA256=h._createHelper(f);l.HmacSHA256=h._createHmacHelper(f)})(Math);\n(function(){var g=CryptoJS,l=g.lib.WordArray,f=g.algo,k=f.SHA256,f=f.SHA224=k.extend({_doReset:function(){this._hash=new l.init([3238371032,914150663,812702999,4144912697,4290775857,1750603025,1694076839,3204075428])},_doFinalize:function(){var f=k._doFinalize.call(this);f.sigBytes-=4;return f}});g.SHA224=k._createHelper(f);g.HmacSHA224=k._createHmacHelper(f)})();\n"], "crypto_js.rollups.sha256": [".js", "/*\nCryptoJS v3.1.2\ncode.google.com/p/crypto-js\n(c) 2009-2013 by Jeff Mott. All rights reserved.\ncode.google.com/p/crypto-js/wiki/License\n*/\nvar CryptoJS=CryptoJS||function(h,s){var f={},t=f.lib={},g=function(){},j=t.Base={extend:function(a){g.prototype=this;var c=new g;a&&c.mixIn(a);c.hasOwnProperty(\"init\")||(c.init=function(){c.$super.init.apply(this,arguments)});c.init.prototype=c;c.$super=this;return c},create:function(){var a=this.extend();a.init.apply(a,arguments);return a},init:function(){},mixIn:function(a){for(var c in a)a.hasOwnProperty(c)&&(this[c]=a[c]);a.hasOwnProperty(\"toString\")&&(this.toString=a.toString)},clone:function(){return this.init.prototype.extend(this)}},\nq=t.WordArray=j.extend({init:function(a,c){a=this.words=a||[];this.sigBytes=c!=s?c:4*a.length},toString:function(a){return(a||u).stringify(this)},concat:function(a){var c=this.words,d=a.words,b=this.sigBytes;a=a.sigBytes;this.clamp();if(b%4)for(var e=0;e<a;e++)c[b+e>>>2]|=(d[e>>>2]>>>24-8*(e%4)&255)<<24-8*((b+e)%4);else if(65535<d.length)for(e=0;e<a;e+=4)c[b+e>>>2]=d[e>>>2];else c.push.apply(c,d);this.sigBytes+=a;return this},clamp:function(){var a=this.words,c=this.sigBytes;a[c>>>2]&=4294967295<<\n32-8*(c%4);a.length=h.ceil(c/4)},clone:function(){var a=j.clone.call(this);a.words=this.words.slice(0);return a},random:function(a){for(var c=[],d=0;d<a;d+=4)c.push(4294967296*h.random()|0);return new q.init(c,a)}}),v=f.enc={},u=v.Hex={stringify:function(a){var c=a.words;a=a.sigBytes;for(var d=[],b=0;b<a;b++){var e=c[b>>>2]>>>24-8*(b%4)&255;d.push((e>>>4).toString(16));d.push((e&15).toString(16))}return d.join(\"\")},parse:function(a){for(var c=a.length,d=[],b=0;b<c;b+=2)d[b>>>3]|=parseInt(a.substr(b,\n2),16)<<24-4*(b%8);return new q.init(d,c/2)}},k=v.Latin1={stringify:function(a){var c=a.words;a=a.sigBytes;for(var d=[],b=0;b<a;b++)d.push(String.fromCharCode(c[b>>>2]>>>24-8*(b%4)&255));return d.join(\"\")},parse:function(a){for(var c=a.length,d=[],b=0;b<c;b++)d[b>>>2]|=(a.charCodeAt(b)&255)<<24-8*(b%4);return new q.init(d,c)}},l=v.Utf8={stringify:function(a){try{return decodeURIComponent(escape(k.stringify(a)))}catch(c){throw Error(\"Malformed UTF-8 data\");}},parse:function(a){return k.parse(unescape(encodeURIComponent(a)))}},\nx=t.BufferedBlockAlgorithm=j.extend({reset:function(){this._data=new q.init;this._nDataBytes=0},_append:function(a){\"string\"==typeof a&&(a=l.parse(a));this._data.concat(a);this._nDataBytes+=a.sigBytes},_process:function(a){var c=this._data,d=c.words,b=c.sigBytes,e=this.blockSize,f=b/(4*e),f=a?h.ceil(f):h.max((f|0)-this._minBufferSize,0);a=f*e;b=h.min(4*a,b);if(a){for(var m=0;m<a;m+=e)this._doProcessBlock(d,m);m=d.splice(0,a);c.sigBytes-=b}return new q.init(m,b)},clone:function(){var a=j.clone.call(this);\na._data=this._data.clone();return a},_minBufferSize:0});t.Hasher=x.extend({cfg:j.extend(),init:function(a){this.cfg=this.cfg.extend(a);this.reset()},reset:function(){x.reset.call(this);this._doReset()},update:function(a){this._append(a);this._process();return this},finalize:function(a){a&&this._append(a);return this._doFinalize()},blockSize:16,_createHelper:function(a){return function(c,d){return(new a.init(d)).finalize(c)}},_createHmacHelper:function(a){return function(c,d){return(new w.HMAC.init(a,\nd)).finalize(c)}}});var w=f.algo={};return f}(Math);\n(function(h){for(var s=CryptoJS,f=s.lib,t=f.WordArray,g=f.Hasher,f=s.algo,j=[],q=[],v=function(a){return 4294967296*(a-(a|0))|0},u=2,k=0;64>k;){var l;a:{l=u;for(var x=h.sqrt(l),w=2;w<=x;w++)if(!(l%w)){l=!1;break a}l=!0}l&&(8>k&&(j[k]=v(h.pow(u,0.5))),q[k]=v(h.pow(u,1/3)),k++);u++}var a=[],f=f.SHA256=g.extend({_doReset:function(){this._hash=new t.init(j.slice(0))},_doProcessBlock:function(c,d){for(var b=this._hash.words,e=b[0],f=b[1],m=b[2],h=b[3],p=b[4],j=b[5],k=b[6],l=b[7],n=0;64>n;n++){if(16>n)a[n]=\nc[d+n]|0;else{var r=a[n-15],g=a[n-2];a[n]=((r<<25|r>>>7)^(r<<14|r>>>18)^r>>>3)+a[n-7]+((g<<15|g>>>17)^(g<<13|g>>>19)^g>>>10)+a[n-16]}r=l+((p<<26|p>>>6)^(p<<21|p>>>11)^(p<<7|p>>>25))+(p&j^~p&k)+q[n]+a[n];g=((e<<30|e>>>2)^(e<<19|e>>>13)^(e<<10|e>>>22))+(e&f^e&m^f&m);l=k;k=j;j=p;p=h+r|0;h=m;m=f;f=e;e=r+g|0}b[0]=b[0]+e|0;b[1]=b[1]+f|0;b[2]=b[2]+m|0;b[3]=b[3]+h|0;b[4]=b[4]+p|0;b[5]=b[5]+j|0;b[6]=b[6]+k|0;b[7]=b[7]+l|0},_doFinalize:function(){var a=this._data,d=a.words,b=8*this._nDataBytes,e=8*a.sigBytes;\nd[e>>>5]|=128<<24-e%32;d[(e+64>>>9<<4)+14]=h.floor(b/4294967296);d[(e+64>>>9<<4)+15]=b;a.sigBytes=4*d.length;this._process();return this._hash},clone:function(){var a=g.clone.call(this);a._hash=this._hash.clone();return a}});s.SHA256=g._createHelper(f);s.HmacSHA256=g._createHmacHelper(f)})(Math);\n"], "crypto_js.rollups.sha3": [".js", "/*\nCryptoJS v3.1.2\ncode.google.com/p/crypto-js\n(c) 2009-2013 by Jeff Mott. All rights reserved.\ncode.google.com/p/crypto-js/wiki/License\n*/\nvar CryptoJS=CryptoJS||function(v,p){var d={},u=d.lib={},r=function(){},f=u.Base={extend:function(a){r.prototype=this;var b=new r;a&&b.mixIn(a);b.hasOwnProperty(\"init\")||(b.init=function(){b.$super.init.apply(this,arguments)});b.init.prototype=b;b.$super=this;return b},create:function(){var a=this.extend();a.init.apply(a,arguments);return a},init:function(){},mixIn:function(a){for(var b in a)a.hasOwnProperty(b)&&(this[b]=a[b]);a.hasOwnProperty(\"toString\")&&(this.toString=a.toString)},clone:function(){return this.init.prototype.extend(this)}},\ns=u.WordArray=f.extend({init:function(a,b){a=this.words=a||[];this.sigBytes=b!=p?b:4*a.length},toString:function(a){return(a||y).stringify(this)},concat:function(a){var b=this.words,c=a.words,j=this.sigBytes;a=a.sigBytes;this.clamp();if(j%4)for(var n=0;n<a;n++)b[j+n>>>2]|=(c[n>>>2]>>>24-8*(n%4)&255)<<24-8*((j+n)%4);else if(65535<c.length)for(n=0;n<a;n+=4)b[j+n>>>2]=c[n>>>2];else b.push.apply(b,c);this.sigBytes+=a;return this},clamp:function(){var a=this.words,b=this.sigBytes;a[b>>>2]&=4294967295<<\n32-8*(b%4);a.length=v.ceil(b/4)},clone:function(){var a=f.clone.call(this);a.words=this.words.slice(0);return a},random:function(a){for(var b=[],c=0;c<a;c+=4)b.push(4294967296*v.random()|0);return new s.init(b,a)}}),x=d.enc={},y=x.Hex={stringify:function(a){var b=a.words;a=a.sigBytes;for(var c=[],j=0;j<a;j++){var n=b[j>>>2]>>>24-8*(j%4)&255;c.push((n>>>4).toString(16));c.push((n&15).toString(16))}return c.join(\"\")},parse:function(a){for(var b=a.length,c=[],j=0;j<b;j+=2)c[j>>>3]|=parseInt(a.substr(j,\n2),16)<<24-4*(j%8);return new s.init(c,b/2)}},e=x.Latin1={stringify:function(a){var b=a.words;a=a.sigBytes;for(var c=[],j=0;j<a;j++)c.push(String.fromCharCode(b[j>>>2]>>>24-8*(j%4)&255));return c.join(\"\")},parse:function(a){for(var b=a.length,c=[],j=0;j<b;j++)c[j>>>2]|=(a.charCodeAt(j)&255)<<24-8*(j%4);return new s.init(c,b)}},q=x.Utf8={stringify:function(a){try{return decodeURIComponent(escape(e.stringify(a)))}catch(b){throw Error(\"Malformed UTF-8 data\");}},parse:function(a){return e.parse(unescape(encodeURIComponent(a)))}},\nt=u.BufferedBlockAlgorithm=f.extend({reset:function(){this._data=new s.init;this._nDataBytes=0},_append:function(a){\"string\"==typeof a&&(a=q.parse(a));this._data.concat(a);this._nDataBytes+=a.sigBytes},_process:function(a){var b=this._data,c=b.words,j=b.sigBytes,n=this.blockSize,e=j/(4*n),e=a?v.ceil(e):v.max((e|0)-this._minBufferSize,0);a=e*n;j=v.min(4*a,j);if(a){for(var f=0;f<a;f+=n)this._doProcessBlock(c,f);f=c.splice(0,a);b.sigBytes-=j}return new s.init(f,j)},clone:function(){var a=f.clone.call(this);\na._data=this._data.clone();return a},_minBufferSize:0});u.Hasher=t.extend({cfg:f.extend(),init:function(a){this.cfg=this.cfg.extend(a);this.reset()},reset:function(){t.reset.call(this);this._doReset()},update:function(a){this._append(a);this._process();return this},finalize:function(a){a&&this._append(a);return this._doFinalize()},blockSize:16,_createHelper:function(a){return function(b,c){return(new a.init(c)).finalize(b)}},_createHmacHelper:function(a){return function(b,c){return(new w.HMAC.init(a,\nc)).finalize(b)}}});var w=d.algo={};return d}(Math);\n(function(v){var p=CryptoJS,d=p.lib,u=d.Base,r=d.WordArray,p=p.x64={};p.Word=u.extend({init:function(f,s){this.high=f;this.low=s}});p.WordArray=u.extend({init:function(f,s){f=this.words=f||[];this.sigBytes=s!=v?s:8*f.length},toX32:function(){for(var f=this.words,s=f.length,d=[],p=0;p<s;p++){var e=f[p];d.push(e.high);d.push(e.low)}return r.create(d,this.sigBytes)},clone:function(){for(var f=u.clone.call(this),d=f.words=this.words.slice(0),p=d.length,r=0;r<p;r++)d[r]=d[r].clone();return f}})})();\n(function(v){for(var p=CryptoJS,d=p.lib,u=d.WordArray,r=d.Hasher,f=p.x64.Word,d=p.algo,s=[],x=[],y=[],e=1,q=0,t=0;24>t;t++){s[e+5*q]=(t+1)*(t+2)/2%64;var w=(2*e+3*q)%5,e=q%5,q=w}for(e=0;5>e;e++)for(q=0;5>q;q++)x[e+5*q]=q+5*((2*e+3*q)%5);e=1;for(q=0;24>q;q++){for(var a=w=t=0;7>a;a++){if(e&1){var b=(1<<a)-1;32>b?w^=1<<b:t^=1<<b-32}e=e&128?e<<1^113:e<<1}y[q]=f.create(t,w)}for(var c=[],e=0;25>e;e++)c[e]=f.create();d=d.SHA3=r.extend({cfg:r.cfg.extend({outputLength:512}),_doReset:function(){for(var a=this._state=\n[],b=0;25>b;b++)a[b]=new f.init;this.blockSize=(1600-2*this.cfg.outputLength)/32},_doProcessBlock:function(a,b){for(var e=this._state,f=this.blockSize/2,h=0;h<f;h++){var l=a[b+2*h],m=a[b+2*h+1],l=(l<<8|l>>>24)&16711935|(l<<24|l>>>8)&4278255360,m=(m<<8|m>>>24)&16711935|(m<<24|m>>>8)&4278255360,g=e[h];g.high^=m;g.low^=l}for(f=0;24>f;f++){for(h=0;5>h;h++){for(var d=l=0,k=0;5>k;k++)g=e[h+5*k],l^=g.high,d^=g.low;g=c[h];g.high=l;g.low=d}for(h=0;5>h;h++){g=c[(h+4)%5];l=c[(h+1)%5];m=l.high;k=l.low;l=g.high^\n(m<<1|k>>>31);d=g.low^(k<<1|m>>>31);for(k=0;5>k;k++)g=e[h+5*k],g.high^=l,g.low^=d}for(m=1;25>m;m++)g=e[m],h=g.high,g=g.low,k=s[m],32>k?(l=h<<k|g>>>32-k,d=g<<k|h>>>32-k):(l=g<<k-32|h>>>64-k,d=h<<k-32|g>>>64-k),g=c[x[m]],g.high=l,g.low=d;g=c[0];h=e[0];g.high=h.high;g.low=h.low;for(h=0;5>h;h++)for(k=0;5>k;k++)m=h+5*k,g=e[m],l=c[m],m=c[(h+1)%5+5*k],d=c[(h+2)%5+5*k],g.high=l.high^~m.high&d.high,g.low=l.low^~m.low&d.low;g=e[0];h=y[f];g.high^=h.high;g.low^=h.low}},_doFinalize:function(){var a=this._data,\nb=a.words,c=8*a.sigBytes,e=32*this.blockSize;b[c>>>5]|=1<<24-c%32;b[(v.ceil((c+1)/e)*e>>>5)-1]|=128;a.sigBytes=4*b.length;this._process();for(var a=this._state,b=this.cfg.outputLength/8,c=b/8,e=[],h=0;h<c;h++){var d=a[h],f=d.high,d=d.low,f=(f<<8|f>>>24)&16711935|(f<<24|f>>>8)&4278255360,d=(d<<8|d>>>24)&16711935|(d<<24|d>>>8)&4278255360;e.push(d);e.push(f)}return new u.init(e,b)},clone:function(){for(var a=r.clone.call(this),b=a._state=this._state.slice(0),c=0;25>c;c++)b[c]=b[c].clone();return a}});\np.SHA3=r._createHelper(d);p.HmacSHA3=r._createHmacHelper(d)})(Math);\n"], "crypto_js.rollups.sha384": [".js", "/*\nCryptoJS v3.1.2\ncode.google.com/p/crypto-js\n(c) 2009-2013 by Jeff Mott. All rights reserved.\ncode.google.com/p/crypto-js/wiki/License\n*/\nvar CryptoJS=CryptoJS||function(a,c){var d={},j=d.lib={},f=function(){},m=j.Base={extend:function(a){f.prototype=this;var b=new f;a&&b.mixIn(a);b.hasOwnProperty(\"init\")||(b.init=function(){b.$super.init.apply(this,arguments)});b.init.prototype=b;b.$super=this;return b},create:function(){var a=this.extend();a.init.apply(a,arguments);return a},init:function(){},mixIn:function(a){for(var b in a)a.hasOwnProperty(b)&&(this[b]=a[b]);a.hasOwnProperty(\"toString\")&&(this.toString=a.toString)},clone:function(){return this.init.prototype.extend(this)}},\nB=j.WordArray=m.extend({init:function(a,b){a=this.words=a||[];this.sigBytes=b!=c?b:4*a.length},toString:function(a){return(a||y).stringify(this)},concat:function(a){var b=this.words,g=a.words,e=this.sigBytes;a=a.sigBytes;this.clamp();if(e%4)for(var k=0;k<a;k++)b[e+k>>>2]|=(g[k>>>2]>>>24-8*(k%4)&255)<<24-8*((e+k)%4);else if(65535<g.length)for(k=0;k<a;k+=4)b[e+k>>>2]=g[k>>>2];else b.push.apply(b,g);this.sigBytes+=a;return this},clamp:function(){var n=this.words,b=this.sigBytes;n[b>>>2]&=4294967295<<\n32-8*(b%4);n.length=a.ceil(b/4)},clone:function(){var a=m.clone.call(this);a.words=this.words.slice(0);return a},random:function(n){for(var b=[],g=0;g<n;g+=4)b.push(4294967296*a.random()|0);return new B.init(b,n)}}),v=d.enc={},y=v.Hex={stringify:function(a){var b=a.words;a=a.sigBytes;for(var g=[],e=0;e<a;e++){var k=b[e>>>2]>>>24-8*(e%4)&255;g.push((k>>>4).toString(16));g.push((k&15).toString(16))}return g.join(\"\")},parse:function(a){for(var b=a.length,g=[],e=0;e<b;e+=2)g[e>>>3]|=parseInt(a.substr(e,\n2),16)<<24-4*(e%8);return new B.init(g,b/2)}},F=v.Latin1={stringify:function(a){var b=a.words;a=a.sigBytes;for(var g=[],e=0;e<a;e++)g.push(String.fromCharCode(b[e>>>2]>>>24-8*(e%4)&255));return g.join(\"\")},parse:function(a){for(var b=a.length,g=[],e=0;e<b;e++)g[e>>>2]|=(a.charCodeAt(e)&255)<<24-8*(e%4);return new B.init(g,b)}},ha=v.Utf8={stringify:function(a){try{return decodeURIComponent(escape(F.stringify(a)))}catch(b){throw Error(\"Malformed UTF-8 data\");}},parse:function(a){return F.parse(unescape(encodeURIComponent(a)))}},\nZ=j.BufferedBlockAlgorithm=m.extend({reset:function(){this._data=new B.init;this._nDataBytes=0},_append:function(a){\"string\"==typeof a&&(a=ha.parse(a));this._data.concat(a);this._nDataBytes+=a.sigBytes},_process:function(n){var b=this._data,g=b.words,e=b.sigBytes,k=this.blockSize,m=e/(4*k),m=n?a.ceil(m):a.max((m|0)-this._minBufferSize,0);n=m*k;e=a.min(4*n,e);if(n){for(var c=0;c<n;c+=k)this._doProcessBlock(g,c);c=g.splice(0,n);b.sigBytes-=e}return new B.init(c,e)},clone:function(){var a=m.clone.call(this);\na._data=this._data.clone();return a},_minBufferSize:0});j.Hasher=Z.extend({cfg:m.extend(),init:function(a){this.cfg=this.cfg.extend(a);this.reset()},reset:function(){Z.reset.call(this);this._doReset()},update:function(a){this._append(a);this._process();return this},finalize:function(a){a&&this._append(a);return this._doFinalize()},blockSize:16,_createHelper:function(a){return function(b,g){return(new a.init(g)).finalize(b)}},_createHmacHelper:function(a){return function(b,g){return(new ia.HMAC.init(a,\ng)).finalize(b)}}});var ia=d.algo={};return d}(Math);\n(function(a){var c=CryptoJS,d=c.lib,j=d.Base,f=d.WordArray,c=c.x64={};c.Word=j.extend({init:function(a,c){this.high=a;this.low=c}});c.WordArray=j.extend({init:function(c,d){c=this.words=c||[];this.sigBytes=d!=a?d:8*c.length},toX32:function(){for(var a=this.words,c=a.length,d=[],j=0;j<c;j++){var F=a[j];d.push(F.high);d.push(F.low)}return f.create(d,this.sigBytes)},clone:function(){for(var a=j.clone.call(this),c=a.words=this.words.slice(0),d=c.length,f=0;f<d;f++)c[f]=c[f].clone();return a}})})();\n(function(){function a(){return f.create.apply(f,arguments)}for(var c=CryptoJS,d=c.lib.Hasher,j=c.x64,f=j.Word,m=j.WordArray,j=c.algo,B=[a(1116352408,3609767458),a(1899447441,602891725),a(3049323471,3964484399),a(3921009573,2173295548),a(961987163,4081628472),a(1508970993,3053834265),a(2453635748,2937671579),a(2870763221,3664609560),a(3624381080,2734883394),a(310598401,1164996542),a(607225278,1323610764),a(1426881987,3590304994),a(1925078388,4068182383),a(2162078206,991336113),a(2614888103,633803317),\na(3248222580,3479774868),a(3835390401,2666613458),a(4022224774,944711139),a(264347078,2341262773),a(604807628,2007800933),a(770255983,1495990901),a(1249150122,1856431235),a(1555081692,3175218132),a(1996064986,2198950837),a(2554220882,3999719339),a(2821834349,766784016),a(2952996808,2566594879),a(3210313671,3203337956),a(3336571891,1034457026),a(3584528711,2466948901),a(113926993,3758326383),a(338241895,168717936),a(666307205,1188179964),a(773529912,1546045734),a(1294757372,1522805485),a(1396182291,\n2643833823),a(1695183700,2343527390),a(1986661051,1014477480),a(2177026350,1206759142),a(2456956037,344077627),a(2730485921,1290863460),a(2820302411,3158454273),a(3259730800,3505952657),a(3345764771,106217008),a(3516065817,3606008344),a(3600352804,1432725776),a(4094571909,1467031594),a(275423344,851169720),a(430227734,3100823752),a(506948616,1363258195),a(659060556,3750685593),a(883997877,3785050280),a(958139571,3318307427),a(1322822218,3812723403),a(1537002063,2003034995),a(1747873779,3602036899),\na(1955562222,1575990012),a(2024104815,1125592928),a(2227730452,2716904306),a(2361852424,442776044),a(2428436474,593698344),a(2756734187,3733110249),a(3204031479,2999351573),a(3329325298,3815920427),a(3391569614,3928383900),a(3515267271,566280711),a(3940187606,3454069534),a(4118630271,4000239992),a(116418474,1914138554),a(174292421,2731055270),a(289380356,3203993006),a(460393269,320620315),a(685471733,587496836),a(852142971,1086792851),a(1017036298,365543100),a(1126000580,2618297676),a(1288033470,\n3409855158),a(1501505948,4234509866),a(1607167915,987167468),a(1816402316,1246189591)],v=[],y=0;80>y;y++)v[y]=a();j=j.SHA512=d.extend({_doReset:function(){this._hash=new m.init([new f.init(1779033703,4089235720),new f.init(3144134277,2227873595),new f.init(1013904242,4271175723),new f.init(2773480762,1595750129),new f.init(1359893119,2917565137),new f.init(2600822924,725511199),new f.init(528734635,4215389547),new f.init(1541459225,327033209)])},_doProcessBlock:function(a,c){for(var d=this._hash.words,\nf=d[0],j=d[1],b=d[2],g=d[3],e=d[4],k=d[5],m=d[6],d=d[7],y=f.high,M=f.low,$=j.high,N=j.low,aa=b.high,O=b.low,ba=g.high,P=g.low,ca=e.high,Q=e.low,da=k.high,R=k.low,ea=m.high,S=m.low,fa=d.high,T=d.low,s=y,p=M,G=$,D=N,H=aa,E=O,W=ba,I=P,t=ca,q=Q,U=da,J=R,V=ea,K=S,X=fa,L=T,u=0;80>u;u++){var z=v[u];if(16>u)var r=z.high=a[c+2*u]|0,h=z.low=a[c+2*u+1]|0;else{var r=v[u-15],h=r.high,w=r.low,r=(h>>>1|w<<31)^(h>>>8|w<<24)^h>>>7,w=(w>>>1|h<<31)^(w>>>8|h<<24)^(w>>>7|h<<25),C=v[u-2],h=C.high,l=C.low,C=(h>>>19|l<<\n13)^(h<<3|l>>>29)^h>>>6,l=(l>>>19|h<<13)^(l<<3|h>>>29)^(l>>>6|h<<26),h=v[u-7],Y=h.high,A=v[u-16],x=A.high,A=A.low,h=w+h.low,r=r+Y+(h>>>0<w>>>0?1:0),h=h+l,r=r+C+(h>>>0<l>>>0?1:0),h=h+A,r=r+x+(h>>>0<A>>>0?1:0);z.high=r;z.low=h}var Y=t&U^~t&V,A=q&J^~q&K,z=s&G^s&H^G&H,ja=p&D^p&E^D&E,w=(s>>>28|p<<4)^(s<<30|p>>>2)^(s<<25|p>>>7),C=(p>>>28|s<<4)^(p<<30|s>>>2)^(p<<25|s>>>7),l=B[u],ka=l.high,ga=l.low,l=L+((q>>>14|t<<18)^(q>>>18|t<<14)^(q<<23|t>>>9)),x=X+((t>>>14|q<<18)^(t>>>18|q<<14)^(t<<23|q>>>9))+(l>>>0<\nL>>>0?1:0),l=l+A,x=x+Y+(l>>>0<A>>>0?1:0),l=l+ga,x=x+ka+(l>>>0<ga>>>0?1:0),l=l+h,x=x+r+(l>>>0<h>>>0?1:0),h=C+ja,z=w+z+(h>>>0<C>>>0?1:0),X=V,L=K,V=U,K=J,U=t,J=q,q=I+l|0,t=W+x+(q>>>0<I>>>0?1:0)|0,W=H,I=E,H=G,E=D,G=s,D=p,p=l+h|0,s=x+z+(p>>>0<l>>>0?1:0)|0}M=f.low=M+p;f.high=y+s+(M>>>0<p>>>0?1:0);N=j.low=N+D;j.high=$+G+(N>>>0<D>>>0?1:0);O=b.low=O+E;b.high=aa+H+(O>>>0<E>>>0?1:0);P=g.low=P+I;g.high=ba+W+(P>>>0<I>>>0?1:0);Q=e.low=Q+q;e.high=ca+t+(Q>>>0<q>>>0?1:0);R=k.low=R+J;k.high=da+U+(R>>>0<J>>>0?1:0);\nS=m.low=S+K;m.high=ea+V+(S>>>0<K>>>0?1:0);T=d.low=T+L;d.high=fa+X+(T>>>0<L>>>0?1:0)},_doFinalize:function(){var a=this._data,c=a.words,d=8*this._nDataBytes,f=8*a.sigBytes;c[f>>>5]|=128<<24-f%32;c[(f+128>>>10<<5)+30]=Math.floor(d/4294967296);c[(f+128>>>10<<5)+31]=d;a.sigBytes=4*c.length;this._process();return this._hash.toX32()},clone:function(){var a=d.clone.call(this);a._hash=this._hash.clone();return a},blockSize:32});c.SHA512=d._createHelper(j);c.HmacSHA512=d._createHmacHelper(j)})();\n(function(){var a=CryptoJS,c=a.x64,d=c.Word,j=c.WordArray,c=a.algo,f=c.SHA512,c=c.SHA384=f.extend({_doReset:function(){this._hash=new j.init([new d.init(3418070365,3238371032),new d.init(1654270250,914150663),new d.init(2438529370,812702999),new d.init(355462360,4144912697),new d.init(1731405415,4290775857),new d.init(2394180231,1750603025),new d.init(3675008525,1694076839),new d.init(1203062813,3204075428)])},_doFinalize:function(){var a=f._doFinalize.call(this);a.sigBytes-=16;return a}});a.SHA384=\nf._createHelper(c);a.HmacSHA384=f._createHmacHelper(c)})();\n"], "crypto_js.rollups.sha512": [".js", "/*\nCryptoJS v3.1.2\ncode.google.com/p/crypto-js\n(c) 2009-2013 by Jeff Mott. All rights reserved.\ncode.google.com/p/crypto-js/wiki/License\n*/\nvar CryptoJS=CryptoJS||function(a,m){var r={},f=r.lib={},g=function(){},l=f.Base={extend:function(a){g.prototype=this;var b=new g;a&&b.mixIn(a);b.hasOwnProperty(\"init\")||(b.init=function(){b.$super.init.apply(this,arguments)});b.init.prototype=b;b.$super=this;return b},create:function(){var a=this.extend();a.init.apply(a,arguments);return a},init:function(){},mixIn:function(a){for(var b in a)a.hasOwnProperty(b)&&(this[b]=a[b]);a.hasOwnProperty(\"toString\")&&(this.toString=a.toString)},clone:function(){return this.init.prototype.extend(this)}},\np=f.WordArray=l.extend({init:function(a,b){a=this.words=a||[];this.sigBytes=b!=m?b:4*a.length},toString:function(a){return(a||q).stringify(this)},concat:function(a){var b=this.words,d=a.words,c=this.sigBytes;a=a.sigBytes;this.clamp();if(c%4)for(var j=0;j<a;j++)b[c+j>>>2]|=(d[j>>>2]>>>24-8*(j%4)&255)<<24-8*((c+j)%4);else if(65535<d.length)for(j=0;j<a;j+=4)b[c+j>>>2]=d[j>>>2];else b.push.apply(b,d);this.sigBytes+=a;return this},clamp:function(){var n=this.words,b=this.sigBytes;n[b>>>2]&=4294967295<<\n32-8*(b%4);n.length=a.ceil(b/4)},clone:function(){var a=l.clone.call(this);a.words=this.words.slice(0);return a},random:function(n){for(var b=[],d=0;d<n;d+=4)b.push(4294967296*a.random()|0);return new p.init(b,n)}}),y=r.enc={},q=y.Hex={stringify:function(a){var b=a.words;a=a.sigBytes;for(var d=[],c=0;c<a;c++){var j=b[c>>>2]>>>24-8*(c%4)&255;d.push((j>>>4).toString(16));d.push((j&15).toString(16))}return d.join(\"\")},parse:function(a){for(var b=a.length,d=[],c=0;c<b;c+=2)d[c>>>3]|=parseInt(a.substr(c,\n2),16)<<24-4*(c%8);return new p.init(d,b/2)}},G=y.Latin1={stringify:function(a){var b=a.words;a=a.sigBytes;for(var d=[],c=0;c<a;c++)d.push(String.fromCharCode(b[c>>>2]>>>24-8*(c%4)&255));return d.join(\"\")},parse:function(a){for(var b=a.length,d=[],c=0;c<b;c++)d[c>>>2]|=(a.charCodeAt(c)&255)<<24-8*(c%4);return new p.init(d,b)}},fa=y.Utf8={stringify:function(a){try{return decodeURIComponent(escape(G.stringify(a)))}catch(b){throw Error(\"Malformed UTF-8 data\");}},parse:function(a){return G.parse(unescape(encodeURIComponent(a)))}},\nh=f.BufferedBlockAlgorithm=l.extend({reset:function(){this._data=new p.init;this._nDataBytes=0},_append:function(a){\"string\"==typeof a&&(a=fa.parse(a));this._data.concat(a);this._nDataBytes+=a.sigBytes},_process:function(n){var b=this._data,d=b.words,c=b.sigBytes,j=this.blockSize,l=c/(4*j),l=n?a.ceil(l):a.max((l|0)-this._minBufferSize,0);n=l*j;c=a.min(4*n,c);if(n){for(var h=0;h<n;h+=j)this._doProcessBlock(d,h);h=d.splice(0,n);b.sigBytes-=c}return new p.init(h,c)},clone:function(){var a=l.clone.call(this);\na._data=this._data.clone();return a},_minBufferSize:0});f.Hasher=h.extend({cfg:l.extend(),init:function(a){this.cfg=this.cfg.extend(a);this.reset()},reset:function(){h.reset.call(this);this._doReset()},update:function(a){this._append(a);this._process();return this},finalize:function(a){a&&this._append(a);return this._doFinalize()},blockSize:16,_createHelper:function(a){return function(b,d){return(new a.init(d)).finalize(b)}},_createHmacHelper:function(a){return function(b,d){return(new ga.HMAC.init(a,\nd)).finalize(b)}}});var ga=r.algo={};return r}(Math);\n(function(a){var m=CryptoJS,r=m.lib,f=r.Base,g=r.WordArray,m=m.x64={};m.Word=f.extend({init:function(a,p){this.high=a;this.low=p}});m.WordArray=f.extend({init:function(l,p){l=this.words=l||[];this.sigBytes=p!=a?p:8*l.length},toX32:function(){for(var a=this.words,p=a.length,f=[],q=0;q<p;q++){var G=a[q];f.push(G.high);f.push(G.low)}return g.create(f,this.sigBytes)},clone:function(){for(var a=f.clone.call(this),p=a.words=this.words.slice(0),g=p.length,q=0;q<g;q++)p[q]=p[q].clone();return a}})})();\n(function(){function a(){return g.create.apply(g,arguments)}for(var m=CryptoJS,r=m.lib.Hasher,f=m.x64,g=f.Word,l=f.WordArray,f=m.algo,p=[a(1116352408,3609767458),a(1899447441,602891725),a(3049323471,3964484399),a(3921009573,2173295548),a(961987163,4081628472),a(1508970993,3053834265),a(2453635748,2937671579),a(2870763221,3664609560),a(3624381080,2734883394),a(310598401,1164996542),a(607225278,1323610764),a(1426881987,3590304994),a(1925078388,4068182383),a(2162078206,991336113),a(2614888103,633803317),\na(3248222580,3479774868),a(3835390401,2666613458),a(4022224774,944711139),a(264347078,2341262773),a(604807628,2007800933),a(770255983,1495990901),a(1249150122,1856431235),a(1555081692,3175218132),a(1996064986,2198950837),a(2554220882,3999719339),a(2821834349,766784016),a(2952996808,2566594879),a(3210313671,3203337956),a(3336571891,1034457026),a(3584528711,2466948901),a(113926993,3758326383),a(338241895,168717936),a(666307205,1188179964),a(773529912,1546045734),a(1294757372,1522805485),a(1396182291,\n2643833823),a(1695183700,2343527390),a(1986661051,1014477480),a(2177026350,1206759142),a(2456956037,344077627),a(2730485921,1290863460),a(2820302411,3158454273),a(3259730800,3505952657),a(3345764771,106217008),a(3516065817,3606008344),a(3600352804,1432725776),a(4094571909,1467031594),a(275423344,851169720),a(430227734,3100823752),a(506948616,1363258195),a(659060556,3750685593),a(883997877,3785050280),a(958139571,3318307427),a(1322822218,3812723403),a(1537002063,2003034995),a(1747873779,3602036899),\na(1955562222,1575990012),a(2024104815,1125592928),a(2227730452,2716904306),a(2361852424,442776044),a(2428436474,593698344),a(2756734187,3733110249),a(3204031479,2999351573),a(3329325298,3815920427),a(3391569614,3928383900),a(3515267271,566280711),a(3940187606,3454069534),a(4118630271,4000239992),a(116418474,1914138554),a(174292421,2731055270),a(289380356,3203993006),a(460393269,320620315),a(685471733,587496836),a(852142971,1086792851),a(1017036298,365543100),a(1126000580,2618297676),a(1288033470,\n3409855158),a(1501505948,4234509866),a(1607167915,987167468),a(1816402316,1246189591)],y=[],q=0;80>q;q++)y[q]=a();f=f.SHA512=r.extend({_doReset:function(){this._hash=new l.init([new g.init(1779033703,4089235720),new g.init(3144134277,2227873595),new g.init(1013904242,4271175723),new g.init(2773480762,1595750129),new g.init(1359893119,2917565137),new g.init(2600822924,725511199),new g.init(528734635,4215389547),new g.init(1541459225,327033209)])},_doProcessBlock:function(a,f){for(var h=this._hash.words,\ng=h[0],n=h[1],b=h[2],d=h[3],c=h[4],j=h[5],l=h[6],h=h[7],q=g.high,m=g.low,r=n.high,N=n.low,Z=b.high,O=b.low,$=d.high,P=d.low,aa=c.high,Q=c.low,ba=j.high,R=j.low,ca=l.high,S=l.low,da=h.high,T=h.low,v=q,s=m,H=r,E=N,I=Z,F=O,W=$,J=P,w=aa,t=Q,U=ba,K=R,V=ca,L=S,X=da,M=T,x=0;80>x;x++){var B=y[x];if(16>x)var u=B.high=a[f+2*x]|0,e=B.low=a[f+2*x+1]|0;else{var u=y[x-15],e=u.high,z=u.low,u=(e>>>1|z<<31)^(e>>>8|z<<24)^e>>>7,z=(z>>>1|e<<31)^(z>>>8|e<<24)^(z>>>7|e<<25),D=y[x-2],e=D.high,k=D.low,D=(e>>>19|k<<13)^\n(e<<3|k>>>29)^e>>>6,k=(k>>>19|e<<13)^(k<<3|e>>>29)^(k>>>6|e<<26),e=y[x-7],Y=e.high,C=y[x-16],A=C.high,C=C.low,e=z+e.low,u=u+Y+(e>>>0<z>>>0?1:0),e=e+k,u=u+D+(e>>>0<k>>>0?1:0),e=e+C,u=u+A+(e>>>0<C>>>0?1:0);B.high=u;B.low=e}var Y=w&U^~w&V,C=t&K^~t&L,B=v&H^v&I^H&I,ha=s&E^s&F^E&F,z=(v>>>28|s<<4)^(v<<30|s>>>2)^(v<<25|s>>>7),D=(s>>>28|v<<4)^(s<<30|v>>>2)^(s<<25|v>>>7),k=p[x],ia=k.high,ea=k.low,k=M+((t>>>14|w<<18)^(t>>>18|w<<14)^(t<<23|w>>>9)),A=X+((w>>>14|t<<18)^(w>>>18|t<<14)^(w<<23|t>>>9))+(k>>>0<M>>>\n0?1:0),k=k+C,A=A+Y+(k>>>0<C>>>0?1:0),k=k+ea,A=A+ia+(k>>>0<ea>>>0?1:0),k=k+e,A=A+u+(k>>>0<e>>>0?1:0),e=D+ha,B=z+B+(e>>>0<D>>>0?1:0),X=V,M=L,V=U,L=K,U=w,K=t,t=J+k|0,w=W+A+(t>>>0<J>>>0?1:0)|0,W=I,J=F,I=H,F=E,H=v,E=s,s=k+e|0,v=A+B+(s>>>0<k>>>0?1:0)|0}m=g.low=m+s;g.high=q+v+(m>>>0<s>>>0?1:0);N=n.low=N+E;n.high=r+H+(N>>>0<E>>>0?1:0);O=b.low=O+F;b.high=Z+I+(O>>>0<F>>>0?1:0);P=d.low=P+J;d.high=$+W+(P>>>0<J>>>0?1:0);Q=c.low=Q+t;c.high=aa+w+(Q>>>0<t>>>0?1:0);R=j.low=R+K;j.high=ba+U+(R>>>0<K>>>0?1:0);S=l.low=\nS+L;l.high=ca+V+(S>>>0<L>>>0?1:0);T=h.low=T+M;h.high=da+X+(T>>>0<M>>>0?1:0)},_doFinalize:function(){var a=this._data,f=a.words,h=8*this._nDataBytes,g=8*a.sigBytes;f[g>>>5]|=128<<24-g%32;f[(g+128>>>10<<5)+30]=Math.floor(h/4294967296);f[(g+128>>>10<<5)+31]=h;a.sigBytes=4*f.length;this._process();return this._hash.toX32()},clone:function(){var a=r.clone.call(this);a._hash=this._hash.clone();return a},blockSize:32});m.SHA512=r._createHelper(f);m.HmacSHA512=r._createHmacHelper(f)})();\n"], "abc": [".py", "\n\n\n\"\"\"Abstract Base Classes (ABCs) according to PEP 3119.\"\"\"\n\n\ndef abstractmethod(funcobj):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n funcobj.__isabstractmethod__=True\n return funcobj\n \n \nclass abstractclassmethod(classmethod):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n __isabstractmethod__=True\n \n def __init__(self,callable):\n  callable.__isabstractmethod__=True\n  super().__init__(callable)\n  \n  \nclass abstractstaticmethod(staticmethod):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n __isabstractmethod__=True\n \n def __init__(self,callable):\n  callable.__isabstractmethod__=True\n  super().__init__(callable)\n  \n  \nclass abstractproperty(property):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n __isabstractmethod__=True\n \n \ntry :\n from _abc import (get_cache_token,_abc_init,_abc_register,\n _abc_instancecheck,_abc_subclasscheck,_get_dump,\n _reset_registry,_reset_caches)\nexcept ImportError:\n from _py_abc import ABCMeta,get_cache_token\n ABCMeta.__module__='abc'\nelse :\n class ABCMeta(type):\n  ''\n\n\n\n\n\n\n\n\n\n\n  \n  def __new__(mcls,name,bases,namespace,**kwargs):\n   cls=super().__new__(mcls,name,bases,namespace,**kwargs)\n   _abc_init(cls)\n   return cls\n   \n  def register(cls,subclass):\n   ''\n\n\n   \n   return _abc_register(cls,subclass)\n   \n  def __instancecheck__(cls,instance):\n   ''\n   return _abc_instancecheck(cls,instance)\n   \n  def __subclasscheck__(cls,subclass):\n   ''\n   return _abc_subclasscheck(cls,subclass)\n   \n  def _dump_registry(cls,file=None ):\n   ''\n   print(f\"Class: {cls.__module__}.{cls.__qualname__}\",file=file)\n   print(f\"Inv. counter: {get_cache_token()}\",file=file)\n   (_abc_registry,_abc_cache,_abc_negative_cache,\n   _abc_negative_cache_version)=_get_dump(cls)\n   print(f\"_abc_registry: {_abc_registry!r}\",file=file)\n   print(f\"_abc_cache: {_abc_cache!r}\",file=file)\n   print(f\"_abc_negative_cache: {_abc_negative_cache!r}\",file=file)\n   print(f\"_abc_negative_cache_version: {_abc_negative_cache_version!r}\",\n   file=file)\n   \n  def _abc_registry_clear(cls):\n   ''\n   _reset_registry(cls)\n   \n  def _abc_caches_clear(cls):\n   ''\n   _reset_caches(cls)\n   \n   \nclass ABC(metaclass=ABCMeta):\n ''\n\n \n __slots__=()\n", ["_abc", "_py_abc"]], "antigravity": [".py", "\nimport webbrowser\nimport hashlib\n\nwebbrowser.open(\"https://xkcd.com/353/\")\n\ndef geohash(latitude,longitude,datedow):\n ''\n\n\n\n\n \n \n h=hashlib.md5(datedow).hexdigest()\n p,q=[('%f'%float.fromhex('0.'+x))for x in (h[:16],h[16:32])]\n print('%d%s %d%s'%(latitude,p[1:],longitude,q[1:]))\n", ["hashlib", "webbrowser"]], "argparse": [".py", "\n\n\"\"\"Command-line parsing library\n\nThis module is an optparse-inspired command-line parsing library that:\n\n    - handles both optional and positional arguments\n    - produces highly informative usage messages\n    - supports parsers that dispatch to sub-parsers\n\nThe following is a simple usage example that sums integers from the\ncommand-line and writes the result to a file::\n\n    parser = argparse.ArgumentParser(\n        description='sum the integers at the command line')\n    parser.add_argument(\n        'integers', metavar='int', nargs='+', type=int,\n        help='an integer to be summed')\n    parser.add_argument(\n        '--log', default=sys.stdout, type=argparse.FileType('w'),\n        help='the file where the sum should be written')\n    args = parser.parse_args()\n    args.log.write('%s' % sum(args.integers))\n    args.log.close()\n\nThe module contains the following public classes:\n\n    - ArgumentParser -- The main entry point for command-line parsing. As the\n        example above shows, the add_argument() method is used to populate\n        the parser with actions for optional and positional arguments. Then\n        the parse_args() method is invoked to convert the args at the\n        command-line into an object with attributes.\n\n    - ArgumentError -- The exception raised by ArgumentParser objects when\n        there are errors with the parser's actions. Errors raised while\n        parsing the command-line are caught by ArgumentParser and emitted\n        as command-line messages.\n\n    - FileType -- A factory for defining types of files to be created. As the\n        example above shows, instances of FileType are typically passed as\n        the type= argument of add_argument() calls.\n\n    - Action -- The base class for parser actions. Typically actions are\n        selected by passing strings like 'store_true' or 'append_const' to\n        the action= argument of add_argument(). However, for greater\n        customization of ArgumentParser actions, subclasses of Action may\n        be defined and passed as the action= argument.\n\n    - HelpFormatter, RawDescriptionHelpFormatter, RawTextHelpFormatter,\n        ArgumentDefaultsHelpFormatter -- Formatter classes which\n        may be passed as the formatter_class= argument to the\n        ArgumentParser constructor. HelpFormatter is the default,\n        RawDescriptionHelpFormatter and RawTextHelpFormatter tell the parser\n        not to change the formatting for help text, and\n        ArgumentDefaultsHelpFormatter adds information about argument defaults\n        to the help.\n\nAll other classes in this module are considered implementation details.\n(Also note that HelpFormatter and RawDescriptionHelpFormatter are only\nconsidered public as object names -- the API of the formatter objects is\nstill considered an implementation detail.)\n\"\"\"\n\n__version__='1.1'\n__all__=[\n'ArgumentParser',\n'ArgumentError',\n'ArgumentTypeError',\n'FileType',\n'HelpFormatter',\n'ArgumentDefaultsHelpFormatter',\n'RawDescriptionHelpFormatter',\n'RawTextHelpFormatter',\n'MetavarTypeHelpFormatter',\n'Namespace',\n'Action',\n'ONE_OR_MORE',\n'OPTIONAL',\n'PARSER',\n'REMAINDER',\n'SUPPRESS',\n'ZERO_OR_MORE',\n]\n\n\nimport os as _os\nimport re as _re\nimport sys as _sys\n\nfrom gettext import gettext as _,ngettext\n\nSUPPRESS='==SUPPRESS=='\n\nOPTIONAL='?'\nZERO_OR_MORE='*'\nONE_OR_MORE='+'\nPARSER='A...'\nREMAINDER='...'\n_UNRECOGNIZED_ARGS_ATTR='_unrecognized_args'\n\n\n\n\n\nclass _AttributeHolder(object):\n ''\n\n\n\n\n\n \n \n def __repr__(self):\n  type_name=type(self).__name__\n  arg_strings=[]\n  star_args={}\n  for arg in self._get_args():\n   arg_strings.append(repr(arg))\n  for name,value in self._get_kwargs():\n   if name.isidentifier():\n    arg_strings.append('%s=%r'%(name,value))\n   else :\n    star_args[name]=value\n  if star_args:\n   arg_strings.append('**%s'%repr(star_args))\n  return '%s(%s)'%(type_name,', '.join(arg_strings))\n  \n def _get_kwargs(self):\n  return sorted(self.__dict__.items())\n  \n def _get_args(self):\n  return []\n  \n  \ndef _copy_items(items):\n if items is None :\n  return []\n  \n  \n  \n if type(items)is list:\n  return items[:]\n import copy\n return copy.copy(items)\n \n \n \n \n \n \nclass HelpFormatter(object):\n ''\n\n\n\n \n \n def __init__(self,\n prog,\n indent_increment=2,\n max_help_position=24,\n width=None ):\n \n \n  if width is None :\n   try :\n    width=int(_os.environ['COLUMNS'])\n   except (KeyError,ValueError):\n    width=80\n   width -=2\n   \n  self._prog=prog\n  self._indent_increment=indent_increment\n  self._max_help_position=max_help_position\n  self._max_help_position=min(max_help_position,\n  max(width -20,indent_increment *2))\n  self._width=width\n  \n  self._current_indent=0\n  self._level=0\n  self._action_max_length=0\n  \n  self._root_section=self._Section(self,None )\n  self._current_section=self._root_section\n  \n  self._whitespace_matcher=_re.compile(r'\\s+',_re.ASCII)\n  self._long_break_matcher=_re.compile(r'\\n\\n\\n+')\n  \n  \n  \n  \n def _indent(self):\n  self._current_indent +=self._indent_increment\n  self._level +=1\n  \n def _dedent(self):\n  self._current_indent -=self._indent_increment\n  assert self._current_indent >=0,'Indent decreased below 0.'\n  self._level -=1\n  \n class _Section(object):\n \n  def __init__(self,formatter,parent,heading=None ):\n   self.formatter=formatter\n   self.parent=parent\n   self.heading=heading\n   self.items=[]\n   \n  def format_help(self):\n  \n   if self.parent is not None :\n    self.formatter._indent()\n   join=self.formatter._join_parts\n   item_help=join([func(*args)for func,args in self.items])\n   if self.parent is not None :\n    self.formatter._dedent()\n    \n    \n   if not item_help:\n    return ''\n    \n    \n   if self.heading is not SUPPRESS and self.heading is not None :\n    current_indent=self.formatter._current_indent\n    heading='%*s%s:\\n'%(current_indent,'',self.heading)\n   else :\n    heading=''\n    \n    \n   return join(['\\n',heading,item_help,'\\n'])\n   \n def _add_item(self,func,args):\n  self._current_section.items.append((func,args))\n  \n  \n  \n  \n def start_section(self,heading):\n  self._indent()\n  section=self._Section(self,self._current_section,heading)\n  self._add_item(section.format_help,[])\n  self._current_section=section\n  \n def end_section(self):\n  self._current_section=self._current_section.parent\n  self._dedent()\n  \n def add_text(self,text):\n  if text is not SUPPRESS and text is not None :\n   self._add_item(self._format_text,[text])\n   \n def add_usage(self,usage,actions,groups,prefix=None ):\n  if usage is not SUPPRESS:\n   args=usage,actions,groups,prefix\n   self._add_item(self._format_usage,args)\n   \n def add_argument(self,action):\n  if action.help is not SUPPRESS:\n  \n  \n   get_invocation=self._format_action_invocation\n   invocations=[get_invocation(action)]\n   for subaction in self._iter_indented_subactions(action):\n    invocations.append(get_invocation(subaction))\n    \n    \n   invocation_length=max([len(s)for s in invocations])\n   action_length=invocation_length+self._current_indent\n   self._action_max_length=max(self._action_max_length,\n   action_length)\n   \n   \n   self._add_item(self._format_action,[action])\n   \n def add_arguments(self,actions):\n  for action in actions:\n   self.add_argument(action)\n   \n   \n   \n   \n def format_help(self):\n  help=self._root_section.format_help()\n  if help:\n   help=self._long_break_matcher.sub('\\n\\n',help)\n   help=help.strip('\\n')+'\\n'\n  return help\n  \n def _join_parts(self,part_strings):\n  return ''.join([part\n  for part in part_strings\n  if part and part is not SUPPRESS])\n  \n def _format_usage(self,usage,actions,groups,prefix):\n  if prefix is None :\n   prefix=_('usage: ')\n   \n   \n  if usage is not None :\n   usage=usage %dict(prog=self._prog)\n   \n   \n  elif usage is None and not actions:\n   usage='%(prog)s'%dict(prog=self._prog)\n   \n   \n  elif usage is None :\n   prog='%(prog)s'%dict(prog=self._prog)\n   \n   \n   optionals=[]\n   positionals=[]\n   for action in actions:\n    if action.option_strings:\n     optionals.append(action)\n    else :\n     positionals.append(action)\n     \n     \n   format=self._format_actions_usage\n   action_usage=format(optionals+positionals,groups)\n   usage=' '.join([s for s in [prog,action_usage]if s])\n   \n   \n   text_width=self._width -self._current_indent\n   if len(prefix)+len(usage)>text_width:\n   \n   \n    part_regexp=(\n    r'\\(.*?\\)+(?=\\s|$)|'\n    r'\\[.*?\\]+(?=\\s|$)|'\n    r'\\S+'\n    )\n    opt_usage=format(optionals,groups)\n    pos_usage=format(positionals,groups)\n    opt_parts=_re.findall(part_regexp,opt_usage)\n    pos_parts=_re.findall(part_regexp,pos_usage)\n    assert ' '.join(opt_parts)==opt_usage\n    assert ' '.join(pos_parts)==pos_usage\n    \n    \n    def get_lines(parts,indent,prefix=None ):\n     lines=[]\n     line=[]\n     if prefix is not None :\n      line_len=len(prefix)-1\n     else :\n      line_len=len(indent)-1\n     for part in parts:\n      if line_len+1+len(part)>text_width and line:\n       lines.append(indent+' '.join(line))\n       line=[]\n       line_len=len(indent)-1\n      line.append(part)\n      line_len +=len(part)+1\n     if line:\n      lines.append(indent+' '.join(line))\n     if prefix is not None :\n      lines[0]=lines[0][len(indent):]\n     return lines\n     \n     \n    if len(prefix)+len(prog)<=0.75 *text_width:\n     indent=' '*(len(prefix)+len(prog)+1)\n     if opt_parts:\n      lines=get_lines([prog]+opt_parts,indent,prefix)\n      lines.extend(get_lines(pos_parts,indent))\n     elif pos_parts:\n      lines=get_lines([prog]+pos_parts,indent,prefix)\n     else :\n      lines=[prog]\n      \n      \n    else :\n     indent=' '*len(prefix)\n     parts=opt_parts+pos_parts\n     lines=get_lines(parts,indent)\n     if len(lines)>1:\n      lines=[]\n      lines.extend(get_lines(opt_parts,indent))\n      lines.extend(get_lines(pos_parts,indent))\n     lines=[prog]+lines\n     \n     \n    usage='\\n'.join(lines)\n    \n    \n  return '%s%s\\n\\n'%(prefix,usage)\n  \n def _format_actions_usage(self,actions,groups):\n \n  group_actions=set()\n  inserts={}\n  for group in groups:\n   try :\n    start=actions.index(group._group_actions[0])\n   except ValueError:\n    continue\n   else :\n    end=start+len(group._group_actions)\n    if actions[start:end]==group._group_actions:\n     for action in group._group_actions:\n      group_actions.add(action)\n     if not group.required:\n      if start in inserts:\n       inserts[start]+=' ['\n      else :\n       inserts[start]='['\n      inserts[end]=']'\n     else :\n      if start in inserts:\n       inserts[start]+=' ('\n      else :\n       inserts[start]='('\n      inserts[end]=')'\n     for i in range(start+1,end):\n      inserts[i]='|'\n      \n      \n  parts=[]\n  for i,action in enumerate(actions):\n  \n  \n  \n   if action.help is SUPPRESS:\n    parts.append(None )\n    if inserts.get(i)=='|':\n     inserts.pop(i)\n    elif inserts.get(i+1)=='|':\n     inserts.pop(i+1)\n     \n     \n   elif not action.option_strings:\n    default=self._get_default_metavar_for_positional(action)\n    part=self._format_args(action,default)\n    \n    \n    if action in group_actions:\n     if part[0]=='['and part[-1]==']':\n      part=part[1:-1]\n      \n      \n    parts.append(part)\n    \n    \n   else :\n    option_string=action.option_strings[0]\n    \n    \n    \n    if action.nargs ==0:\n     part='%s'%option_string\n     \n     \n     \n    else :\n     default=self._get_default_metavar_for_optional(action)\n     args_string=self._format_args(action,default)\n     part='%s %s'%(option_string,args_string)\n     \n     \n    if not action.required and action not in group_actions:\n     part='[%s]'%part\n     \n     \n    parts.append(part)\n    \n    \n  for i in sorted(inserts,reverse=True ):\n   parts[i:i]=[inserts[i]]\n   \n   \n  text=' '.join([item for item in parts if item is not None ])\n  \n  \n  open=r'[\\[(]'\n  close=r'[\\])]'\n  text=_re.sub(r'(%s) '%open,r'\\1',text)\n  text=_re.sub(r' (%s)'%close,r'\\1',text)\n  text=_re.sub(r'%s *%s'%(open,close),r'',text)\n  text=_re.sub(r'\\(([^|]*)\\)',r'\\1',text)\n  text=text.strip()\n  \n  \n  return text\n  \n def _format_text(self,text):\n  if '%(prog)'in text:\n   text=text %dict(prog=self._prog)\n  text_width=max(self._width -self._current_indent,11)\n  indent=' '*self._current_indent\n  return self._fill_text(text,text_width,indent)+'\\n\\n'\n  \n def _format_action(self,action):\n \n  help_position=min(self._action_max_length+2,\n  self._max_help_position)\n  help_width=max(self._width -help_position,11)\n  action_width=help_position -self._current_indent -2\n  action_header=self._format_action_invocation(action)\n  \n  \n  if not action.help:\n   tup=self._current_indent,'',action_header\n   action_header='%*s%s\\n'%tup\n   \n   \n  elif len(action_header)<=action_width:\n   tup=self._current_indent,'',action_width,action_header\n   action_header='%*s%-*s  '%tup\n   indent_first=0\n   \n   \n  else :\n   tup=self._current_indent,'',action_header\n   action_header='%*s%s\\n'%tup\n   indent_first=help_position\n   \n   \n  parts=[action_header]\n  \n  \n  if action.help:\n   help_text=self._expand_help(action)\n   help_lines=self._split_lines(help_text,help_width)\n   parts.append('%*s%s\\n'%(indent_first,'',help_lines[0]))\n   for line in help_lines[1:]:\n    parts.append('%*s%s\\n'%(help_position,'',line))\n    \n    \n  elif not action_header.endswith('\\n'):\n   parts.append('\\n')\n   \n   \n  for subaction in self._iter_indented_subactions(action):\n   parts.append(self._format_action(subaction))\n   \n   \n  return self._join_parts(parts)\n  \n def _format_action_invocation(self,action):\n  if not action.option_strings:\n   default=self._get_default_metavar_for_positional(action)\n   metavar,=self._metavar_formatter(action,default)(1)\n   return metavar\n   \n  else :\n   parts=[]\n   \n   \n   \n   if action.nargs ==0:\n    parts.extend(action.option_strings)\n    \n    \n    \n   else :\n    default=self._get_default_metavar_for_optional(action)\n    args_string=self._format_args(action,default)\n    for option_string in action.option_strings:\n     parts.append('%s %s'%(option_string,args_string))\n     \n   return ', '.join(parts)\n   \n def _metavar_formatter(self,action,default_metavar):\n  if action.metavar is not None :\n   result=action.metavar\n  elif action.choices is not None :\n   choice_strs=[str(choice)for choice in action.choices]\n   result='{%s}'%','.join(choice_strs)\n  else :\n   result=default_metavar\n   \n  def format(tuple_size):\n   if isinstance(result,tuple):\n    return result\n   else :\n    return (result,)*tuple_size\n  return format\n  \n def _format_args(self,action,default_metavar):\n  get_metavar=self._metavar_formatter(action,default_metavar)\n  if action.nargs is None :\n   result='%s'%get_metavar(1)\n  elif action.nargs ==OPTIONAL:\n   result='[%s]'%get_metavar(1)\n  elif action.nargs ==ZERO_OR_MORE:\n   result='[%s [%s ...]]'%get_metavar(2)\n  elif action.nargs ==ONE_OR_MORE:\n   result='%s [%s ...]'%get_metavar(2)\n  elif action.nargs ==REMAINDER:\n   result='...'\n  elif action.nargs ==PARSER:\n   result='%s ...'%get_metavar(1)\n  elif action.nargs ==SUPPRESS:\n   result=''\n  else :\n   formats=['%s'for _ in range(action.nargs)]\n   result=' '.join(formats)%get_metavar(action.nargs)\n  return result\n  \n def _expand_help(self,action):\n  params=dict(vars(action),prog=self._prog)\n  for name in list(params):\n   if params[name]is SUPPRESS:\n    del params[name]\n  for name in list(params):\n   if hasattr(params[name],'__name__'):\n    params[name]=params[name].__name__\n  if params.get('choices')is not None :\n   choices_str=', '.join([str(c)for c in params['choices']])\n   params['choices']=choices_str\n  return self._get_help_string(action)%params\n  \n def _iter_indented_subactions(self,action):\n  try :\n   get_subactions=action._get_subactions\n  except AttributeError:\n   pass\n  else :\n   self._indent()\n   yield from get_subactions()\n   self._dedent()\n   \n def _split_lines(self,text,width):\n  text=self._whitespace_matcher.sub(' ',text).strip()\n  \n  \n  import textwrap\n  return textwrap.wrap(text,width)\n  \n def _fill_text(self,text,width,indent):\n  text=self._whitespace_matcher.sub(' ',text).strip()\n  import textwrap\n  return textwrap.fill(text,width,\n  initial_indent=indent,\n  subsequent_indent=indent)\n  \n def _get_help_string(self,action):\n  return action.help\n  \n def _get_default_metavar_for_optional(self,action):\n  return action.dest.upper()\n  \n def _get_default_metavar_for_positional(self,action):\n  return action.dest\n  \n  \nclass RawDescriptionHelpFormatter(HelpFormatter):\n ''\n\n\n\n \n \n def _fill_text(self,text,width,indent):\n  return ''.join(indent+line for line in text.splitlines(keepends=True ))\n  \n  \nclass RawTextHelpFormatter(RawDescriptionHelpFormatter):\n ''\n\n\n\n \n \n def _split_lines(self,text,width):\n  return text.splitlines()\n  \n  \nclass ArgumentDefaultsHelpFormatter(HelpFormatter):\n ''\n\n\n\n \n \n def _get_help_string(self,action):\n  help=action.help\n  if '%(default)'not in action.help:\n   if action.default is not SUPPRESS:\n    defaulting_nargs=[OPTIONAL,ZERO_OR_MORE]\n    if action.option_strings or action.nargs in defaulting_nargs:\n     help +=' (default: %(default)s)'\n  return help\n  \n  \nclass MetavarTypeHelpFormatter(HelpFormatter):\n ''\n\n\n\n\n \n \n def _get_default_metavar_for_optional(self,action):\n  return action.type.__name__\n  \n def _get_default_metavar_for_positional(self,action):\n  return action.type.__name__\n  \n  \n  \n  \n  \n  \n  \ndef _get_action_name(argument):\n if argument is None :\n  return None\n elif argument.option_strings:\n  return '/'.join(argument.option_strings)\n elif argument.metavar not in (None ,SUPPRESS):\n  return argument.metavar\n elif argument.dest not in (None ,SUPPRESS):\n  return argument.dest\n else :\n  return None\n  \n  \nclass ArgumentError(Exception):\n ''\n\n\n\n \n \n def __init__(self,argument,message):\n  self.argument_name=_get_action_name(argument)\n  self.message=message\n  \n def __str__(self):\n  if self.argument_name is None :\n   format='%(message)s'\n  else :\n   format='argument %(argument_name)s: %(message)s'\n  return format %dict(message=self.message,\n  argument_name=self.argument_name)\n  \n  \nclass ArgumentTypeError(Exception):\n ''\n pass\n \n \n \n \n \n \nclass Action(_AttributeHolder):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n def __init__(self,\n option_strings,\n dest,\n nargs=None ,\n const=None ,\n default=None ,\n type=None ,\n choices=None ,\n required=False ,\n help=None ,\n metavar=None ):\n  self.option_strings=option_strings\n  self.dest=dest\n  self.nargs=nargs\n  self.const=const\n  self.default=default\n  self.type=type\n  self.choices=choices\n  self.required=required\n  self.help=help\n  self.metavar=metavar\n  \n def _get_kwargs(self):\n  names=[\n  'option_strings',\n  'dest',\n  'nargs',\n  'const',\n  'default',\n  'type',\n  'choices',\n  'help',\n  'metavar',\n  ]\n  return [(name,getattr(self,name))for name in names]\n  \n def __call__(self,parser,namespace,values,option_string=None ):\n  raise NotImplementedError(_('.__call__() not defined'))\n  \n  \nclass _StoreAction(Action):\n\n def __init__(self,\n option_strings,\n dest,\n nargs=None ,\n const=None ,\n default=None ,\n type=None ,\n choices=None ,\n required=False ,\n help=None ,\n metavar=None ):\n  if nargs ==0:\n   raise ValueError('nargs for store actions must be > 0; if you '\n   'have nothing to store, actions such as store '\n   'true or store const may be more appropriate')\n  if const is not None and nargs !=OPTIONAL:\n   raise ValueError('nargs must be %r to supply const'%OPTIONAL)\n  super(_StoreAction,self).__init__(\n  option_strings=option_strings,\n  dest=dest,\n  nargs=nargs,\n  const=const,\n  default=default,\n  type=type,\n  choices=choices,\n  required=required,\n  help=help,\n  metavar=metavar)\n  \n def __call__(self,parser,namespace,values,option_string=None ):\n  setattr(namespace,self.dest,values)\n  \n  \nclass _StoreConstAction(Action):\n\n def __init__(self,\n option_strings,\n dest,\n const,\n default=None ,\n required=False ,\n help=None ,\n metavar=None ):\n  super(_StoreConstAction,self).__init__(\n  option_strings=option_strings,\n  dest=dest,\n  nargs=0,\n  const=const,\n  default=default,\n  required=required,\n  help=help)\n  \n def __call__(self,parser,namespace,values,option_string=None ):\n  setattr(namespace,self.dest,self.const)\n  \n  \nclass _StoreTrueAction(_StoreConstAction):\n\n def __init__(self,\n option_strings,\n dest,\n default=False ,\n required=False ,\n help=None ):\n  super(_StoreTrueAction,self).__init__(\n  option_strings=option_strings,\n  dest=dest,\n  const=True ,\n  default=default,\n  required=required,\n  help=help)\n  \n  \nclass _StoreFalseAction(_StoreConstAction):\n\n def __init__(self,\n option_strings,\n dest,\n default=True ,\n required=False ,\n help=None ):\n  super(_StoreFalseAction,self).__init__(\n  option_strings=option_strings,\n  dest=dest,\n  const=False ,\n  default=default,\n  required=required,\n  help=help)\n  \n  \nclass _AppendAction(Action):\n\n def __init__(self,\n option_strings,\n dest,\n nargs=None ,\n const=None ,\n default=None ,\n type=None ,\n choices=None ,\n required=False ,\n help=None ,\n metavar=None ):\n  if nargs ==0:\n   raise ValueError('nargs for append actions must be > 0; if arg '\n   'strings are not supplying the value to append, '\n   'the append const action may be more appropriate')\n  if const is not None and nargs !=OPTIONAL:\n   raise ValueError('nargs must be %r to supply const'%OPTIONAL)\n  super(_AppendAction,self).__init__(\n  option_strings=option_strings,\n  dest=dest,\n  nargs=nargs,\n  const=const,\n  default=default,\n  type=type,\n  choices=choices,\n  required=required,\n  help=help,\n  metavar=metavar)\n  \n def __call__(self,parser,namespace,values,option_string=None ):\n  items=getattr(namespace,self.dest,None )\n  items=_copy_items(items)\n  items.append(values)\n  setattr(namespace,self.dest,items)\n  \n  \nclass _AppendConstAction(Action):\n\n def __init__(self,\n option_strings,\n dest,\n const,\n default=None ,\n required=False ,\n help=None ,\n metavar=None ):\n  super(_AppendConstAction,self).__init__(\n  option_strings=option_strings,\n  dest=dest,\n  nargs=0,\n  const=const,\n  default=default,\n  required=required,\n  help=help,\n  metavar=metavar)\n  \n def __call__(self,parser,namespace,values,option_string=None ):\n  items=getattr(namespace,self.dest,None )\n  items=_copy_items(items)\n  items.append(self.const)\n  setattr(namespace,self.dest,items)\n  \n  \nclass _CountAction(Action):\n\n def __init__(self,\n option_strings,\n dest,\n default=None ,\n required=False ,\n help=None ):\n  super(_CountAction,self).__init__(\n  option_strings=option_strings,\n  dest=dest,\n  nargs=0,\n  default=default,\n  required=required,\n  help=help)\n  \n def __call__(self,parser,namespace,values,option_string=None ):\n  count=getattr(namespace,self.dest,None )\n  if count is None :\n   count=0\n  setattr(namespace,self.dest,count+1)\n  \n  \nclass _HelpAction(Action):\n\n def __init__(self,\n option_strings,\n dest=SUPPRESS,\n default=SUPPRESS,\n help=None ):\n  super(_HelpAction,self).__init__(\n  option_strings=option_strings,\n  dest=dest,\n  default=default,\n  nargs=0,\n  help=help)\n  \n def __call__(self,parser,namespace,values,option_string=None ):\n  parser.print_help()\n  parser.exit()\n  \n  \nclass _VersionAction(Action):\n\n def __init__(self,\n option_strings,\n version=None ,\n dest=SUPPRESS,\n default=SUPPRESS,\n help=\"show program's version number and exit\"):\n  super(_VersionAction,self).__init__(\n  option_strings=option_strings,\n  dest=dest,\n  default=default,\n  nargs=0,\n  help=help)\n  self.version=version\n  \n def __call__(self,parser,namespace,values,option_string=None ):\n  version=self.version\n  if version is None :\n   version=parser.version\n  formatter=parser._get_formatter()\n  formatter.add_text(version)\n  parser._print_message(formatter.format_help(),_sys.stdout)\n  parser.exit()\n  \n  \nclass _SubParsersAction(Action):\n\n class _ChoicesPseudoAction(Action):\n \n  def __init__(self,name,aliases,help):\n   metavar=dest=name\n   if aliases:\n    metavar +=' (%s)'%', '.join(aliases)\n   sup=super(_SubParsersAction._ChoicesPseudoAction,self)\n   sup.__init__(option_strings=[],dest=dest,help=help,\n   metavar=metavar)\n   \n def __init__(self,\n option_strings,\n prog,\n parser_class,\n dest=SUPPRESS,\n required=False ,\n help=None ,\n metavar=None ):\n \n  self._prog_prefix=prog\n  self._parser_class=parser_class\n  self._name_parser_map={}\n  self._choices_actions=[]\n  \n  super(_SubParsersAction,self).__init__(\n  option_strings=option_strings,\n  dest=dest,\n  nargs=PARSER,\n  choices=self._name_parser_map,\n  required=required,\n  help=help,\n  metavar=metavar)\n  \n def add_parser(self,name,**kwargs):\n \n  if kwargs.get('prog')is None :\n   kwargs['prog']='%s %s'%(self._prog_prefix,name)\n   \n  aliases=kwargs.pop('aliases',())\n  \n  \n  if 'help'in kwargs:\n   help=kwargs.pop('help')\n   choice_action=self._ChoicesPseudoAction(name,aliases,help)\n   self._choices_actions.append(choice_action)\n   \n   \n  parser=self._parser_class(**kwargs)\n  self._name_parser_map[name]=parser\n  \n  \n  for alias in aliases:\n   self._name_parser_map[alias]=parser\n   \n  return parser\n  \n def _get_subactions(self):\n  return self._choices_actions\n  \n def __call__(self,parser,namespace,values,option_string=None ):\n  parser_name=values[0]\n  arg_strings=values[1:]\n  \n  \n  if self.dest is not SUPPRESS:\n   setattr(namespace,self.dest,parser_name)\n   \n   \n  try :\n   parser=self._name_parser_map[parser_name]\n  except KeyError:\n   args={'parser_name':parser_name,\n   'choices':', '.join(self._name_parser_map)}\n   msg=_('unknown parser %(parser_name)r (choices: %(choices)s)')%args\n   raise ArgumentError(self,msg)\n   \n   \n   \n   \n   \n   \n   \n   \n  subnamespace,arg_strings=parser.parse_known_args(arg_strings,None )\n  for key,value in vars(subnamespace).items():\n   setattr(namespace,key,value)\n   \n  if arg_strings:\n   vars(namespace).setdefault(_UNRECOGNIZED_ARGS_ATTR,[])\n   getattr(namespace,_UNRECOGNIZED_ARGS_ATTR).extend(arg_strings)\n   \n   \n   \n   \n   \n   \nclass FileType(object):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n def __init__(self,mode='r',bufsize=-1,encoding=None ,errors=None ):\n  self._mode=mode\n  self._bufsize=bufsize\n  self._encoding=encoding\n  self._errors=errors\n  \n def __call__(self,string):\n \n  if string =='-':\n   if 'r'in self._mode:\n    return _sys.stdin\n   elif 'w'in self._mode:\n    return _sys.stdout\n   else :\n    msg=_('argument \"-\" with mode %r')%self._mode\n    raise ValueError(msg)\n    \n    \n  try :\n   return open(string,self._mode,self._bufsize,self._encoding,\n   self._errors)\n  except OSError as e:\n   message=_(\"can't open '%s': %s\")\n   raise ArgumentTypeError(message %(string,e))\n   \n def __repr__(self):\n  args=self._mode,self._bufsize\n  kwargs=[('encoding',self._encoding),('errors',self._errors)]\n  args_str=', '.join([repr(arg)for arg in args if arg !=-1]+\n  ['%s=%r'%(kw,arg)for kw,arg in kwargs\n  if arg is not None ])\n  return '%s(%s)'%(type(self).__name__,args_str)\n  \n  \n  \n  \n  \nclass Namespace(_AttributeHolder):\n ''\n\n\n\n \n \n def __init__(self,**kwargs):\n  for name in kwargs:\n   setattr(self,name,kwargs[name])\n   \n def __eq__(self,other):\n  if not isinstance(other,Namespace):\n   return NotImplemented\n  return vars(self)==vars(other)\n  \n def __contains__(self,key):\n  return key in self.__dict__\n  \n  \nclass _ActionsContainer(object):\n\n def __init__(self,\n description,\n prefix_chars,\n argument_default,\n conflict_handler):\n  super(_ActionsContainer,self).__init__()\n  \n  self.description=description\n  self.argument_default=argument_default\n  self.prefix_chars=prefix_chars\n  self.conflict_handler=conflict_handler\n  \n  \n  self._registries={}\n  \n  \n  self.register('action',None ,_StoreAction)\n  self.register('action','store',_StoreAction)\n  self.register('action','store_const',_StoreConstAction)\n  self.register('action','store_true',_StoreTrueAction)\n  self.register('action','store_false',_StoreFalseAction)\n  self.register('action','append',_AppendAction)\n  self.register('action','append_const',_AppendConstAction)\n  self.register('action','count',_CountAction)\n  self.register('action','help',_HelpAction)\n  self.register('action','version',_VersionAction)\n  self.register('action','parsers',_SubParsersAction)\n  \n  \n  self._get_handler()\n  \n  \n  self._actions=[]\n  self._option_string_actions={}\n  \n  \n  self._action_groups=[]\n  self._mutually_exclusive_groups=[]\n  \n  \n  self._defaults={}\n  \n  \n  self._negative_number_matcher=_re.compile(r'^-\\d+$|^-\\d*\\.\\d+$')\n  \n  \n  \n  self._has_negative_number_optionals=[]\n  \n  \n  \n  \n def register(self,registry_name,value,object):\n  registry=self._registries.setdefault(registry_name,{})\n  registry[value]=object\n  \n def _registry_get(self,registry_name,value,default=None ):\n  return self._registries[registry_name].get(value,default)\n  \n  \n  \n  \n def set_defaults(self,**kwargs):\n  self._defaults.update(kwargs)\n  \n  \n  \n  for action in self._actions:\n   if action.dest in kwargs:\n    action.default=kwargs[action.dest]\n    \n def get_default(self,dest):\n  for action in self._actions:\n   if action.dest ==dest and action.default is not None :\n    return action.default\n  return self._defaults.get(dest,None )\n  \n  \n  \n  \n  \n def add_argument(self,*args,**kwargs):\n  ''\n\n\n  \n  \n  \n  \n  \n  chars=self.prefix_chars\n  if not args or len(args)==1 and args[0][0]not in chars:\n   if args and 'dest'in kwargs:\n    raise ValueError('dest supplied twice for positional argument')\n   kwargs=self._get_positional_kwargs(*args,**kwargs)\n   \n   \n  else :\n   kwargs=self._get_optional_kwargs(*args,**kwargs)\n   \n   \n  if 'default'not in kwargs:\n   dest=kwargs['dest']\n   if dest in self._defaults:\n    kwargs['default']=self._defaults[dest]\n   elif self.argument_default is not None :\n    kwargs['default']=self.argument_default\n    \n    \n  action_class=self._pop_action_class(kwargs)\n  if not callable(action_class):\n   raise ValueError('unknown action \"%s\"'%(action_class,))\n  action=action_class(**kwargs)\n  \n  \n  type_func=self._registry_get('type',action.type,action.type)\n  if not callable(type_func):\n   raise ValueError('%r is not callable'%(type_func,))\n   \n   \n  if hasattr(self,\"_get_formatter\"):\n   try :\n    self._get_formatter()._format_args(action,None )\n   except TypeError:\n    raise ValueError(\"length of metavar tuple does not match nargs\")\n    \n  return self._add_action(action)\n  \n def add_argument_group(self,*args,**kwargs):\n  group=_ArgumentGroup(self,*args,**kwargs)\n  self._action_groups.append(group)\n  return group\n  \n def add_mutually_exclusive_group(self,**kwargs):\n  group=_MutuallyExclusiveGroup(self,**kwargs)\n  self._mutually_exclusive_groups.append(group)\n  return group\n  \n def _add_action(self,action):\n \n  self._check_conflict(action)\n  \n  \n  self._actions.append(action)\n  action.container=self\n  \n  \n  for option_string in action.option_strings:\n   self._option_string_actions[option_string]=action\n   \n   \n  for option_string in action.option_strings:\n   if self._negative_number_matcher.match(option_string):\n    if not self._has_negative_number_optionals:\n     self._has_negative_number_optionals.append(True )\n     \n     \n  return action\n  \n def _remove_action(self,action):\n  self._actions.remove(action)\n  \n def _add_container_actions(self,container):\n \n  title_group_map={}\n  for group in self._action_groups:\n   if group.title in title_group_map:\n    msg=_('cannot merge actions - two groups are named %r')\n    raise ValueError(msg %(group.title))\n   title_group_map[group.title]=group\n   \n   \n  group_map={}\n  for group in container._action_groups:\n  \n  \n  \n   if group.title not in title_group_map:\n    title_group_map[group.title]=self.add_argument_group(\n    title=group.title,\n    description=group.description,\n    conflict_handler=group.conflict_handler)\n    \n    \n   for action in group._group_actions:\n    group_map[action]=title_group_map[group.title]\n    \n    \n    \n    \n  for group in container._mutually_exclusive_groups:\n   mutex_group=self.add_mutually_exclusive_group(\n   required=group.required)\n   \n   \n   for action in group._group_actions:\n    group_map[action]=mutex_group\n    \n    \n  for action in container._actions:\n   group_map.get(action,self)._add_action(action)\n   \n def _get_positional_kwargs(self,dest,**kwargs):\n \n  if 'required'in kwargs:\n   msg=_(\"'required' is an invalid argument for positionals\")\n   raise TypeError(msg)\n   \n   \n   \n  if kwargs.get('nargs')not in [OPTIONAL,ZERO_OR_MORE]:\n   kwargs['required']=True\n  if kwargs.get('nargs')==ZERO_OR_MORE and 'default'not in kwargs:\n   kwargs['required']=True\n   \n   \n  return dict(kwargs,dest=dest,option_strings=[])\n  \n def _get_optional_kwargs(self,*args,**kwargs):\n \n  option_strings=[]\n  long_option_strings=[]\n  for option_string in args:\n  \n   if not option_string[0]in self.prefix_chars:\n    args={'option':option_string,\n    'prefix_chars':self.prefix_chars}\n    msg=_('invalid option string %(option)r: '\n    'must start with a character %(prefix_chars)r')\n    raise ValueError(msg %args)\n    \n    \n   option_strings.append(option_string)\n   if option_string[0]in self.prefix_chars:\n    if len(option_string)>1:\n     if option_string[1]in self.prefix_chars:\n      long_option_strings.append(option_string)\n      \n      \n  dest=kwargs.pop('dest',None )\n  if dest is None :\n   if long_option_strings:\n    dest_option_string=long_option_strings[0]\n   else :\n    dest_option_string=option_strings[0]\n   dest=dest_option_string.lstrip(self.prefix_chars)\n   if not dest:\n    msg=_('dest= is required for options like %r')\n    raise ValueError(msg %option_string)\n   dest=dest.replace('-','_')\n   \n   \n  return dict(kwargs,dest=dest,option_strings=option_strings)\n  \n def _pop_action_class(self,kwargs,default=None ):\n  action=kwargs.pop('action',default)\n  return self._registry_get('action',action,action)\n  \n def _get_handler(self):\n \n  handler_func_name='_handle_conflict_%s'%self.conflict_handler\n  try :\n   return getattr(self,handler_func_name)\n  except AttributeError:\n   msg=_('invalid conflict_resolution value: %r')\n   raise ValueError(msg %self.conflict_handler)\n   \n def _check_conflict(self,action):\n \n \n  confl_optionals=[]\n  for option_string in action.option_strings:\n   if option_string in self._option_string_actions:\n    confl_optional=self._option_string_actions[option_string]\n    confl_optionals.append((option_string,confl_optional))\n    \n    \n  if confl_optionals:\n   conflict_handler=self._get_handler()\n   conflict_handler(action,confl_optionals)\n   \n def _handle_conflict_error(self,action,conflicting_actions):\n  message=ngettext('conflicting option string: %s',\n  'conflicting option strings: %s',\n  len(conflicting_actions))\n  conflict_string=', '.join([option_string\n  for option_string,action\n  in conflicting_actions])\n  raise ArgumentError(action,message %conflict_string)\n  \n def _handle_conflict_resolve(self,action,conflicting_actions):\n \n \n  for option_string,action in conflicting_actions:\n  \n  \n   action.option_strings.remove(option_string)\n   self._option_string_actions.pop(option_string,None )\n   \n   \n   \n   if not action.option_strings:\n    action.container._remove_action(action)\n    \n    \nclass _ArgumentGroup(_ActionsContainer):\n\n def __init__(self,container,title=None ,description=None ,**kwargs):\n \n  update=kwargs.setdefault\n  update('conflict_handler',container.conflict_handler)\n  update('prefix_chars',container.prefix_chars)\n  update('argument_default',container.argument_default)\n  super_init=super(_ArgumentGroup,self).__init__\n  super_init(description=description,**kwargs)\n  \n  \n  self.title=title\n  self._group_actions=[]\n  \n  \n  self._registries=container._registries\n  self._actions=container._actions\n  self._option_string_actions=container._option_string_actions\n  self._defaults=container._defaults\n  self._has_negative_number_optionals=\\\n  container._has_negative_number_optionals\n  self._mutually_exclusive_groups=container._mutually_exclusive_groups\n  \n def _add_action(self,action):\n  action=super(_ArgumentGroup,self)._add_action(action)\n  self._group_actions.append(action)\n  return action\n  \n def _remove_action(self,action):\n  super(_ArgumentGroup,self)._remove_action(action)\n  self._group_actions.remove(action)\n  \n  \nclass _MutuallyExclusiveGroup(_ArgumentGroup):\n\n def __init__(self,container,required=False ):\n  super(_MutuallyExclusiveGroup,self).__init__(container)\n  self.required=required\n  self._container=container\n  \n def _add_action(self,action):\n  if action.required:\n   msg=_('mutually exclusive arguments must be optional')\n   raise ValueError(msg)\n  action=self._container._add_action(action)\n  self._group_actions.append(action)\n  return action\n  \n def _remove_action(self,action):\n  self._container._remove_action(action)\n  self._group_actions.remove(action)\n  \n  \nclass ArgumentParser(_AttributeHolder,_ActionsContainer):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n def __init__(self,\n prog=None ,\n usage=None ,\n description=None ,\n epilog=None ,\n parents=[],\n formatter_class=HelpFormatter,\n prefix_chars='-',\n fromfile_prefix_chars=None ,\n argument_default=None ,\n conflict_handler='error',\n add_help=True ,\n allow_abbrev=True ):\n \n  superinit=super(ArgumentParser,self).__init__\n  superinit(description=description,\n  prefix_chars=prefix_chars,\n  argument_default=argument_default,\n  conflict_handler=conflict_handler)\n  \n  \n  if prog is None :\n   prog=_os.path.basename(_sys.argv[0])\n   \n  self.prog=prog\n  self.usage=usage\n  self.epilog=epilog\n  self.formatter_class=formatter_class\n  self.fromfile_prefix_chars=fromfile_prefix_chars\n  self.add_help=add_help\n  self.allow_abbrev=allow_abbrev\n  \n  add_group=self.add_argument_group\n  self._positionals=add_group(_('positional arguments'))\n  self._optionals=add_group(_('optional arguments'))\n  self._subparsers=None\n  \n  \n  def identity(string):\n   return string\n  self.register('type',None ,identity)\n  \n  \n  \n  default_prefix='-'if '-'in prefix_chars else prefix_chars[0]\n  if self.add_help:\n   self.add_argument(\n   default_prefix+'h',default_prefix *2+'help',\n   action='help',default=SUPPRESS,\n   help=_('show this help message and exit'))\n   \n   \n  for parent in parents:\n   self._add_container_actions(parent)\n   try :\n    defaults=parent._defaults\n   except AttributeError:\n    pass\n   else :\n    self._defaults.update(defaults)\n    \n    \n    \n    \n def _get_kwargs(self):\n  names=[\n  'prog',\n  'usage',\n  'description',\n  'formatter_class',\n  'conflict_handler',\n  'add_help',\n  ]\n  return [(name,getattr(self,name))for name in names]\n  \n  \n  \n  \n def add_subparsers(self,**kwargs):\n  if self._subparsers is not None :\n   self.error(_('cannot have multiple subparser arguments'))\n   \n   \n  kwargs.setdefault('parser_class',type(self))\n  \n  if 'title'in kwargs or 'description'in kwargs:\n   title=_(kwargs.pop('title','subcommands'))\n   description=_(kwargs.pop('description',None ))\n   self._subparsers=self.add_argument_group(title,description)\n  else :\n   self._subparsers=self._positionals\n   \n   \n   \n  if kwargs.get('prog')is None :\n   formatter=self._get_formatter()\n   positionals=self._get_positional_actions()\n   groups=self._mutually_exclusive_groups\n   formatter.add_usage(self.usage,positionals,groups,'')\n   kwargs['prog']=formatter.format_help().strip()\n   \n   \n  parsers_class=self._pop_action_class(kwargs,'parsers')\n  action=parsers_class(option_strings=[],**kwargs)\n  self._subparsers._add_action(action)\n  \n  \n  return action\n  \n def _add_action(self,action):\n  if action.option_strings:\n   self._optionals._add_action(action)\n  else :\n   self._positionals._add_action(action)\n  return action\n  \n def _get_optional_actions(self):\n  return [action\n  for action in self._actions\n  if action.option_strings]\n  \n def _get_positional_actions(self):\n  return [action\n  for action in self._actions\n  if not action.option_strings]\n  \n  \n  \n  \n def parse_args(self,args=None ,namespace=None ):\n  args,argv=self.parse_known_args(args,namespace)\n  if argv:\n   msg=_('unrecognized arguments: %s')\n   self.error(msg %' '.join(argv))\n  return args\n  \n def parse_known_args(self,args=None ,namespace=None ):\n  if args is None :\n  \n   args=_sys.argv[1:]\n  else :\n  \n   args=list(args)\n   \n   \n  if namespace is None :\n   namespace=Namespace()\n   \n   \n  for action in self._actions:\n   if action.dest is not SUPPRESS:\n    if not hasattr(namespace,action.dest):\n     if action.default is not SUPPRESS:\n      setattr(namespace,action.dest,action.default)\n      \n      \n  for dest in self._defaults:\n   if not hasattr(namespace,dest):\n    setattr(namespace,dest,self._defaults[dest])\n    \n    \n  try :\n   namespace,args=self._parse_known_args(args,namespace)\n   if hasattr(namespace,_UNRECOGNIZED_ARGS_ATTR):\n    args.extend(getattr(namespace,_UNRECOGNIZED_ARGS_ATTR))\n    delattr(namespace,_UNRECOGNIZED_ARGS_ATTR)\n   return namespace,args\n  except ArgumentError:\n   err=_sys.exc_info()[1]\n   self.error(str(err))\n   \n def _parse_known_args(self,arg_strings,namespace):\n \n  if self.fromfile_prefix_chars is not None :\n   arg_strings=self._read_args_from_files(arg_strings)\n   \n   \n   \n  action_conflicts={}\n  for mutex_group in self._mutually_exclusive_groups:\n   group_actions=mutex_group._group_actions\n   for i,mutex_action in enumerate(mutex_group._group_actions):\n    conflicts=action_conflicts.setdefault(mutex_action,[])\n    conflicts.extend(group_actions[:i])\n    conflicts.extend(group_actions[i+1:])\n    \n    \n    \n    \n  option_string_indices={}\n  arg_string_pattern_parts=[]\n  arg_strings_iter=iter(arg_strings)\n  for i,arg_string in enumerate(arg_strings_iter):\n  \n  \n   if arg_string =='--':\n    arg_string_pattern_parts.append('-')\n    for arg_string in arg_strings_iter:\n     arg_string_pattern_parts.append('A')\n     \n     \n     \n   else :\n    option_tuple=self._parse_optional(arg_string)\n    if option_tuple is None :\n     pattern='A'\n    else :\n     option_string_indices[i]=option_tuple\n     pattern='O'\n    arg_string_pattern_parts.append(pattern)\n    \n    \n  arg_strings_pattern=''.join(arg_string_pattern_parts)\n  \n  \n  seen_actions=set()\n  seen_non_default_actions=set()\n  \n  def take_action(action,argument_strings,option_string=None ):\n   seen_actions.add(action)\n   argument_values=self._get_values(action,argument_strings)\n   \n   \n   \n   \n   if argument_values is not action.default:\n    seen_non_default_actions.add(action)\n    for conflict_action in action_conflicts.get(action,[]):\n     if conflict_action in seen_non_default_actions:\n      msg=_('not allowed with argument %s')\n      action_name=_get_action_name(conflict_action)\n      raise ArgumentError(action,msg %action_name)\n      \n      \n      \n   if argument_values is not SUPPRESS:\n    action(self,namespace,argument_values,option_string)\n    \n    \n  def consume_optional(start_index):\n  \n  \n   option_tuple=option_string_indices[start_index]\n   action,option_string,explicit_arg=option_tuple\n   \n   \n   \n   match_argument=self._match_argument\n   action_tuples=[]\n   while True :\n   \n   \n    if action is None :\n     extras.append(arg_strings[start_index])\n     return start_index+1\n     \n     \n     \n    if explicit_arg is not None :\n     arg_count=match_argument(action,'A')\n     \n     \n     \n     \n     chars=self.prefix_chars\n     if arg_count ==0 and option_string[1]not in chars:\n      action_tuples.append((action,[],option_string))\n      char=option_string[0]\n      option_string=char+explicit_arg[0]\n      new_explicit_arg=explicit_arg[1:]or None\n      optionals_map=self._option_string_actions\n      if option_string in optionals_map:\n       action=optionals_map[option_string]\n       explicit_arg=new_explicit_arg\n      else :\n       msg=_('ignored explicit argument %r')\n       raise ArgumentError(action,msg %explicit_arg)\n       \n       \n       \n     elif arg_count ==1:\n      stop=start_index+1\n      args=[explicit_arg]\n      action_tuples.append((action,args,option_string))\n      break\n      \n      \n      \n     else :\n      msg=_('ignored explicit argument %r')\n      raise ArgumentError(action,msg %explicit_arg)\n      \n      \n      \n      \n    else :\n     start=start_index+1\n     selected_patterns=arg_strings_pattern[start:]\n     arg_count=match_argument(action,selected_patterns)\n     stop=start+arg_count\n     args=arg_strings[start:stop]\n     action_tuples.append((action,args,option_string))\n     break\n     \n     \n     \n   assert action_tuples\n   for action,args,option_string in action_tuples:\n    take_action(action,args,option_string)\n   return stop\n   \n   \n   \n  positionals=self._get_positional_actions()\n  \n  \n  def consume_positionals(start_index):\n  \n   match_partial=self._match_arguments_partial\n   selected_pattern=arg_strings_pattern[start_index:]\n   arg_counts=match_partial(positionals,selected_pattern)\n   \n   \n   \n   for action,arg_count in zip(positionals,arg_counts):\n    args=arg_strings[start_index:start_index+arg_count]\n    start_index +=arg_count\n    take_action(action,args)\n    \n    \n    \n   positionals[:]=positionals[len(arg_counts):]\n   return start_index\n   \n   \n   \n  extras=[]\n  start_index=0\n  if option_string_indices:\n   max_option_string_index=max(option_string_indices)\n  else :\n   max_option_string_index=-1\n  while start_index <=max_option_string_index:\n  \n  \n   next_option_string_index=min([\n   index\n   for index in option_string_indices\n   if index >=start_index])\n   if start_index !=next_option_string_index:\n    positionals_end_index=consume_positionals(start_index)\n    \n    \n    \n    if positionals_end_index >start_index:\n     start_index=positionals_end_index\n     continue\n    else :\n     start_index=positionals_end_index\n     \n     \n     \n   if start_index not in option_string_indices:\n    strings=arg_strings[start_index:next_option_string_index]\n    extras.extend(strings)\n    start_index=next_option_string_index\n    \n    \n   start_index=consume_optional(start_index)\n   \n   \n  stop_index=consume_positionals(start_index)\n  \n  \n  extras.extend(arg_strings[stop_index:])\n  \n  \n  \n  required_actions=[]\n  for action in self._actions:\n   if action not in seen_actions:\n    if action.required:\n     required_actions.append(_get_action_name(action))\n    else :\n    \n    \n    \n    \n     if (action.default is not None and\n     isinstance(action.default,str)and\n     hasattr(namespace,action.dest)and\n     action.default is getattr(namespace,action.dest)):\n      setattr(namespace,action.dest,\n      self._get_value(action,action.default))\n      \n  if required_actions:\n   self.error(_('the following arguments are required: %s')%\n   ', '.join(required_actions))\n   \n   \n  for group in self._mutually_exclusive_groups:\n   if group.required:\n    for action in group._group_actions:\n     if action in seen_non_default_actions:\n      break\n      \n      \n    else :\n     names=[_get_action_name(action)\n     for action in group._group_actions\n     if action.help is not SUPPRESS]\n     msg=_('one of the arguments %s is required')\n     self.error(msg %' '.join(names))\n     \n     \n  return namespace,extras\n  \n def _read_args_from_files(self,arg_strings):\n \n  new_arg_strings=[]\n  for arg_string in arg_strings:\n  \n  \n   if not arg_string or arg_string[0]not in self.fromfile_prefix_chars:\n    new_arg_strings.append(arg_string)\n    \n    \n   else :\n    try :\n     with open(arg_string[1:])as args_file:\n      arg_strings=[]\n      for arg_line in args_file.read().splitlines():\n       for arg in self.convert_arg_line_to_args(arg_line):\n        arg_strings.append(arg)\n      arg_strings=self._read_args_from_files(arg_strings)\n      new_arg_strings.extend(arg_strings)\n    except OSError:\n     err=_sys.exc_info()[1]\n     self.error(str(err))\n     \n     \n  return new_arg_strings\n  \n def convert_arg_line_to_args(self,arg_line):\n  return [arg_line]\n  \n def _match_argument(self,action,arg_strings_pattern):\n \n  nargs_pattern=self._get_nargs_pattern(action)\n  match=_re.match(nargs_pattern,arg_strings_pattern)\n  \n  \n  if match is None :\n   nargs_errors={\n   None :_('expected one argument'),\n   OPTIONAL:_('expected at most one argument'),\n   ONE_OR_MORE:_('expected at least one argument'),\n   }\n   default=ngettext('expected %s argument',\n   'expected %s arguments',\n   action.nargs)%action.nargs\n   msg=nargs_errors.get(action.nargs,default)\n   raise ArgumentError(action,msg)\n   \n   \n  return len(match.group(1))\n  \n def _match_arguments_partial(self,actions,arg_strings_pattern):\n \n \n  result=[]\n  for i in range(len(actions),0,-1):\n   actions_slice=actions[:i]\n   pattern=''.join([self._get_nargs_pattern(action)\n   for action in actions_slice])\n   match=_re.match(pattern,arg_strings_pattern)\n   if match is not None :\n    result.extend([len(string)for string in match.groups()])\n    break\n    \n    \n  return result\n  \n def _parse_optional(self,arg_string):\n \n  if not arg_string:\n   return None\n   \n   \n  if not arg_string[0]in self.prefix_chars:\n   return None\n   \n   \n  if arg_string in self._option_string_actions:\n   action=self._option_string_actions[arg_string]\n   return action,arg_string,None\n   \n   \n  if len(arg_string)==1:\n   return None\n   \n   \n  if '='in arg_string:\n   option_string,explicit_arg=arg_string.split('=',1)\n   if option_string in self._option_string_actions:\n    action=self._option_string_actions[option_string]\n    return action,option_string,explicit_arg\n    \n  if self.allow_abbrev:\n  \n  \n   option_tuples=self._get_option_tuples(arg_string)\n   \n   \n   if len(option_tuples)>1:\n    options=', '.join([option_string\n    for action,option_string,explicit_arg in option_tuples])\n    args={'option':arg_string,'matches':options}\n    msg=_('ambiguous option: %(option)s could match %(matches)s')\n    self.error(msg %args)\n    \n    \n    \n   elif len(option_tuples)==1:\n    option_tuple,=option_tuples\n    return option_tuple\n    \n    \n    \n    \n  if self._negative_number_matcher.match(arg_string):\n   if not self._has_negative_number_optionals:\n    return None\n    \n    \n  if ' 'in arg_string:\n   return None\n   \n   \n   \n  return None ,arg_string,None\n  \n def _get_option_tuples(self,option_string):\n  result=[]\n  \n  \n  \n  chars=self.prefix_chars\n  if option_string[0]in chars and option_string[1]in chars:\n   if '='in option_string:\n    option_prefix,explicit_arg=option_string.split('=',1)\n   else :\n    option_prefix=option_string\n    explicit_arg=None\n   for option_string in self._option_string_actions:\n    if option_string.startswith(option_prefix):\n     action=self._option_string_actions[option_string]\n     tup=action,option_string,explicit_arg\n     result.append(tup)\n     \n     \n     \n     \n  elif option_string[0]in chars and option_string[1]not in chars:\n   option_prefix=option_string\n   explicit_arg=None\n   short_option_prefix=option_string[:2]\n   short_explicit_arg=option_string[2:]\n   \n   for option_string in self._option_string_actions:\n    if option_string ==short_option_prefix:\n     action=self._option_string_actions[option_string]\n     tup=action,option_string,short_explicit_arg\n     result.append(tup)\n    elif option_string.startswith(option_prefix):\n     action=self._option_string_actions[option_string]\n     tup=action,option_string,explicit_arg\n     result.append(tup)\n     \n     \n  else :\n   self.error(_('unexpected option string: %s')%option_string)\n   \n   \n  return result\n  \n def _get_nargs_pattern(self,action):\n \n \n  nargs=action.nargs\n  \n  \n  if nargs is None :\n   nargs_pattern='(-*A-*)'\n   \n   \n  elif nargs ==OPTIONAL:\n   nargs_pattern='(-*A?-*)'\n   \n   \n  elif nargs ==ZERO_OR_MORE:\n   nargs_pattern='(-*[A-]*)'\n   \n   \n  elif nargs ==ONE_OR_MORE:\n   nargs_pattern='(-*A[A-]*)'\n   \n   \n  elif nargs ==REMAINDER:\n   nargs_pattern='([-AO]*)'\n   \n   \n  elif nargs ==PARSER:\n   nargs_pattern='(-*A[-AO]*)'\n   \n   \n  elif nargs ==SUPPRESS:\n   nargs_pattern='(-*-*)'\n   \n   \n  else :\n   nargs_pattern='(-*%s-*)'%'-*'.join('A'*nargs)\n   \n   \n  if action.option_strings:\n   nargs_pattern=nargs_pattern.replace('-*','')\n   nargs_pattern=nargs_pattern.replace('-','')\n   \n   \n  return nargs_pattern\n  \n  \n  \n  \n  \n def parse_intermixed_args(self,args=None ,namespace=None ):\n  args,argv=self.parse_known_intermixed_args(args,namespace)\n  if argv:\n   msg=_('unrecognized arguments: %s')\n   self.error(msg %' '.join(argv))\n  return args\n  \n def parse_known_intermixed_args(self,args=None ,namespace=None ):\n \n \n \n \n \n \n \n \n \n \n \n \n  positionals=self._get_positional_actions()\n  a=[action for action in positionals\n  if action.nargs in [PARSER,REMAINDER]]\n  if a:\n   raise TypeError('parse_intermixed_args: positional arg'\n   ' with nargs=%s'%a[0].nargs)\n   \n  if [action.dest for group in self._mutually_exclusive_groups\n  for action in group._group_actions if action in positionals]:\n   raise TypeError('parse_intermixed_args: positional in'\n   ' mutuallyExclusiveGroup')\n   \n  try :\n   save_usage=self.usage\n   try :\n    if self.usage is None :\n    \n     self.usage=self.format_usage()[7:]\n    for action in positionals:\n    \n     action.save_nargs=action.nargs\n     \n     action.nargs=SUPPRESS\n     action.save_default=action.default\n     action.default=SUPPRESS\n    namespace,remaining_args=self.parse_known_args(args,\n    namespace)\n    for action in positionals:\n    \n     if (hasattr(namespace,action.dest)\n     and getattr(namespace,action.dest)==[]):\n      from warnings import warn\n      warn('Do not expect %s in %s'%(action.dest,namespace))\n      delattr(namespace,action.dest)\n   finally :\n   \n    for action in positionals:\n     action.nargs=action.save_nargs\n     action.default=action.save_default\n   optionals=self._get_optional_actions()\n   try :\n   \n   \n    for action in optionals:\n     action.save_required=action.required\n     action.required=False\n    for group in self._mutually_exclusive_groups:\n     group.save_required=group.required\n     group.required=False\n    namespace,extras=self.parse_known_args(remaining_args,\n    namespace)\n   finally :\n   \n    for action in optionals:\n     action.required=action.save_required\n    for group in self._mutually_exclusive_groups:\n     group.required=group.save_required\n  finally :\n   self.usage=save_usage\n  return namespace,extras\n  \n  \n  \n  \n def _get_values(self,action,arg_strings):\n \n  if action.nargs not in [PARSER,REMAINDER]:\n   try :\n    arg_strings.remove('--')\n   except ValueError:\n    pass\n    \n    \n  if not arg_strings and action.nargs ==OPTIONAL:\n   if action.option_strings:\n    value=action.const\n   else :\n    value=action.default\n   if isinstance(value,str):\n    value=self._get_value(action,value)\n    self._check_value(action,value)\n    \n    \n    \n  elif (not arg_strings and action.nargs ==ZERO_OR_MORE and\n  not action.option_strings):\n   if action.default is not None :\n    value=action.default\n   else :\n    value=arg_strings\n   self._check_value(action,value)\n   \n   \n  elif len(arg_strings)==1 and action.nargs in [None ,OPTIONAL]:\n   arg_string,=arg_strings\n   value=self._get_value(action,arg_string)\n   self._check_value(action,value)\n   \n   \n  elif action.nargs ==REMAINDER:\n   value=[self._get_value(action,v)for v in arg_strings]\n   \n   \n  elif action.nargs ==PARSER:\n   value=[self._get_value(action,v)for v in arg_strings]\n   self._check_value(action,value[0])\n   \n   \n  elif action.nargs ==SUPPRESS:\n   value=SUPPRESS\n   \n   \n  else :\n   value=[self._get_value(action,v)for v in arg_strings]\n   for v in value:\n    self._check_value(action,v)\n    \n    \n  return value\n  \n def _get_value(self,action,arg_string):\n  type_func=self._registry_get('type',action.type,action.type)\n  if not callable(type_func):\n   msg=_('%r is not callable')\n   raise ArgumentError(action,msg %type_func)\n   \n   \n  try :\n   result=type_func(arg_string)\n   \n   \n  except ArgumentTypeError:\n   name=getattr(action.type,'__name__',repr(action.type))\n   msg=str(_sys.exc_info()[1])\n   raise ArgumentError(action,msg)\n   \n   \n  except (TypeError,ValueError):\n   name=getattr(action.type,'__name__',repr(action.type))\n   args={'type':name,'value':arg_string}\n   msg=_('invalid %(type)s value: %(value)r')\n   raise ArgumentError(action,msg %args)\n   \n   \n  return result\n  \n def _check_value(self,action,value):\n \n  if action.choices is not None and value not in action.choices:\n   args={'value':value,\n   'choices':', '.join(map(repr,action.choices))}\n   msg=_('invalid choice: %(value)r (choose from %(choices)s)')\n   raise ArgumentError(action,msg %args)\n   \n   \n   \n   \n def format_usage(self):\n  formatter=self._get_formatter()\n  formatter.add_usage(self.usage,self._actions,\n  self._mutually_exclusive_groups)\n  return formatter.format_help()\n  \n def format_help(self):\n  formatter=self._get_formatter()\n  \n  \n  formatter.add_usage(self.usage,self._actions,\n  self._mutually_exclusive_groups)\n  \n  \n  formatter.add_text(self.description)\n  \n  \n  for action_group in self._action_groups:\n   formatter.start_section(action_group.title)\n   formatter.add_text(action_group.description)\n   formatter.add_arguments(action_group._group_actions)\n   formatter.end_section()\n   \n   \n  formatter.add_text(self.epilog)\n  \n  \n  return formatter.format_help()\n  \n def _get_formatter(self):\n  return self.formatter_class(prog=self.prog)\n  \n  \n  \n  \n def print_usage(self,file=None ):\n  if file is None :\n   file=_sys.stdout\n  self._print_message(self.format_usage(),file)\n  \n def print_help(self,file=None ):\n  if file is None :\n   file=_sys.stdout\n  self._print_message(self.format_help(),file)\n  \n def _print_message(self,message,file=None ):\n  if message:\n   if file is None :\n    file=_sys.stderr\n   file.write(message)\n   \n   \n   \n   \n def exit(self,status=0,message=None ):\n  if message:\n   self._print_message(message,_sys.stderr)\n  _sys.exit(status)\n  \n def error(self,message):\n  ''\n\n\n\n\n\n\n  \n  self.print_usage(_sys.stderr)\n  args={'prog':self.prog,'message':message}\n  self.exit(2,_('%(prog)s: error: %(message)s\\n')%args)\n", ["copy", "gettext", "os", "re", "sys", "textwrap", "warnings"]], "atexit": [".py", "''\n\n\n\n\n\nclass __loader__(object):\n pass\n \ndef _clear(*args,**kw):\n ''\n \n pass\n \ndef _run_exitfuncs(*args,**kw):\n ''\n \n pass\n \ndef register(*args,**kw):\n ''\n\n\n\n\n\n\n \n pass\n \ndef unregister(*args,**kw):\n ''\n\n\n\n \n pass\n", []], "base64": [".py", "#! /usr/bin/env python3\n\n\"\"\"Base16, Base32, Base64 (RFC 3548), Base85 and Ascii85 data encodings\"\"\"\n\n\n\n\n\nimport re\nimport struct\nimport binascii\n\n\n__all__=[\n\n'encode','decode','encodebytes','decodebytes',\n\n'b64encode','b64decode','b32encode','b32decode',\n'b16encode','b16decode',\n\n'b85encode','b85decode','a85encode','a85decode',\n\n'standard_b64encode','standard_b64decode',\n\n\n\n\n'urlsafe_b64encode','urlsafe_b64decode',\n]\n\n\nbytes_types=(bytes,bytearray)\n\ndef _bytes_from_decode_data(s):\n if isinstance(s,str):\n  try :\n   return s.encode('ascii')\n  except UnicodeEncodeError:\n   raise ValueError('string argument should contain only ASCII characters')\n if isinstance(s,bytes_types):\n  return s\n try :\n  return memoryview(s).tobytes()\n except TypeError:\n  raise TypeError(\"argument should be a bytes-like object or ASCII \"\n  \"string, not %r\"%s.__class__.__name__)from None\n  \n  \n  \n  \ndef b64encode(s,altchars=None ):\n ''\n\n\n\n\n \n encoded=binascii.b2a_base64(s,newline=False )\n if altchars is not None :\n  assert len(altchars)==2,repr(altchars)\n  return encoded.translate(bytes.maketrans(b'+/',altchars))\n return encoded\n \n \ndef b64decode(s,altchars=None ,validate=False ):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n \n s=_bytes_from_decode_data(s)\n if altchars is not None :\n  altchars=_bytes_from_decode_data(altchars)\n  assert len(altchars)==2,repr(altchars)\n  s=s.translate(bytes.maketrans(altchars,b'+/'))\n if validate and not re.match(b'^[A-Za-z0-9+/]*={0,2}$',s):\n  raise binascii.Error('Non-base64 digit found')\n return binascii.a2b_base64(s)\n \n \ndef standard_b64encode(s):\n ''\n\n\n \n return b64encode(s)\n \ndef standard_b64decode(s):\n ''\n\n\n\n\n\n \n return b64decode(s)\n \n \n_urlsafe_encode_translation=bytes.maketrans(b'+/',b'-_')\n_urlsafe_decode_translation=bytes.maketrans(b'-_',b'+/')\n\ndef urlsafe_b64encode(s):\n ''\n\n\n\n\n \n return b64encode(s).translate(_urlsafe_encode_translation)\n \ndef urlsafe_b64decode(s):\n ''\n\n\n\n\n\n\n\n\n \n s=_bytes_from_decode_data(s)\n s=s.translate(_urlsafe_decode_translation)\n return b64decode(s)\n \n \n \n \n_b32alphabet=b'ABCDEFGHIJKLMNOPQRSTUVWXYZ234567'\n_b32tab2=None\n_b32rev=None\n\ndef b32encode(s):\n ''\n \n global _b32tab2\n \n \n if _b32tab2 is None :\n  b32tab=[bytes((i,))for i in _b32alphabet]\n  _b32tab2=[a+b for a in b32tab for b in b32tab]\n  b32tab=None\n  \n if not isinstance(s,bytes_types):\n  s=memoryview(s).tobytes()\n leftover=len(s)%5\n \n if leftover:\n  s=s+b'\\0'*(5 -leftover)\n encoded=bytearray()\n from_bytes=int.from_bytes\n b32tab2=_b32tab2\n for i in range(0,len(s),5):\n  c=from_bytes(s[i:i+5],'big')\n  encoded +=(b32tab2[c >>30]+\n  b32tab2[(c >>20)&0x3ff]+\n  b32tab2[(c >>10)&0x3ff]+\n  b32tab2[c&0x3ff]\n  )\n  \n if leftover ==1:\n  encoded[-6:]=b'======'\n elif leftover ==2:\n  encoded[-4:]=b'===='\n elif leftover ==3:\n  encoded[-3:]=b'==='\n elif leftover ==4:\n  encoded[-1:]=b'='\n return bytes(encoded)\n \ndef b32decode(s,casefold=False ,map01=None ):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n global _b32rev\n \n \n if _b32rev is None :\n  _b32rev={v:k for k,v in enumerate(_b32alphabet)}\n s=_bytes_from_decode_data(s)\n if len(s)%8:\n  raise binascii.Error('Incorrect padding')\n  \n  \n  \n if map01 is not None :\n  map01=_bytes_from_decode_data(map01)\n  assert len(map01)==1,repr(map01)\n  s=s.translate(bytes.maketrans(b'01',b'O'+map01))\n if casefold:\n  s=s.upper()\n  \n  \n  \n l=len(s)\n s=s.rstrip(b'=')\n padchars=l -len(s)\n \n decoded=bytearray()\n b32rev=_b32rev\n for i in range(0,len(s),8):\n  quanta=s[i:i+8]\n  acc=0\n  try :\n   for c in quanta:\n    acc=(acc <<5)+b32rev[c]\n  except KeyError:\n   raise binascii.Error('Non-base32 digit found')from None\n  decoded +=acc.to_bytes(5,'big')\n  \n if l %8 or padchars not in {0,1,3,4,6}:\n  raise binascii.Error('Incorrect padding')\n if padchars and decoded:\n  acc <<=5 *padchars\n  last=acc.to_bytes(5,'big')\n  leftover=(43 -5 *padchars)//8\n  decoded[-5:]=last[:leftover]\n return bytes(decoded)\n \n \n \n \n \ndef b16encode(s):\n ''\n \n return binascii.hexlify(s).upper()\n \n \ndef b16decode(s,casefold=False ):\n ''\n\n\n\n\n\n\n\n \n s=_bytes_from_decode_data(s)\n if casefold:\n  s=s.upper()\n if re.search(b'[^0-9A-F]',s):\n  raise binascii.Error('Non-base16 digit found')\n return binascii.unhexlify(s)\n \n \n \n \n \n_a85chars=None\n_a85chars2=None\n_A85START=b\"<~\"\n_A85END=b\"~>\"\n\ndef _85encode(b,chars,chars2,pad=False ,foldnuls=False ,foldspaces=False ):\n\n if not isinstance(b,bytes_types):\n  b=memoryview(b).tobytes()\n  \n padding=(-len(b))%4\n if padding:\n  b=b+b'\\0'*padding\n words=struct.Struct('!%dI'%(len(b)//4)).unpack(b)\n \n chunks=[b'z'if foldnuls and not word else\n b'y'if foldspaces and word ==0x20202020 else\n (chars2[word //614125]+\n chars2[word //85 %7225]+\n chars[word %85])\n for word in words]\n \n if padding and not pad:\n  if chunks[-1]==b'z':\n   chunks[-1]=chars[0]*5\n  chunks[-1]=chunks[-1][:-padding]\n  \n return b''.join(chunks)\n \ndef a85encode(b,*,foldspaces=False ,wrapcol=0,pad=False ,adobe=False ):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n global _a85chars,_a85chars2\n \n \n if _a85chars is None :\n  _a85chars=[bytes((i,))for i in range(33,118)]\n  _a85chars2=[(a+b)for a in _a85chars for b in _a85chars]\n  \n result=_85encode(b,_a85chars,_a85chars2,pad,True ,foldspaces)\n \n if adobe:\n  result=_A85START+result\n if wrapcol:\n  wrapcol=max(2 if adobe else 1,wrapcol)\n  chunks=[result[i:i+wrapcol]\n  for i in range(0,len(result),wrapcol)]\n  if adobe:\n   if len(chunks[-1])+2 >wrapcol:\n    chunks.append(b'')\n  result=b'\\n'.join(chunks)\n if adobe:\n  result +=_A85END\n  \n return result\n \ndef a85decode(b,*,foldspaces=False ,adobe=False ,ignorechars=b' \\t\\n\\r\\v'):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n b=_bytes_from_decode_data(b)\n if adobe:\n  if not b.endswith(_A85END):\n   raise ValueError(\n   \"Ascii85 encoded byte sequences must end \"\n   \"with {!r}\".format(_A85END)\n   )\n  if b.startswith(_A85START):\n   b=b[2:-2]\n  else :\n   b=b[:-2]\n   \n   \n   \n   \n packI=struct.Struct('!I').pack\n decoded=[]\n decoded_append=decoded.append\n curr=[]\n curr_append=curr.append\n curr_clear=curr.clear\n for x in b+b'u'*4:\n  if b'!'[0]<=x <=b'u'[0]:\n   curr_append(x)\n   if len(curr)==5:\n    acc=0\n    for x in curr:\n     acc=85 *acc+(x -33)\n    try :\n     decoded_append(packI(acc))\n    except struct.error:\n     raise ValueError('Ascii85 overflow')from None\n    curr_clear()\n  elif x ==b'z'[0]:\n   if curr:\n    raise ValueError('z inside Ascii85 5-tuple')\n   decoded_append(b'\\0\\0\\0\\0')\n  elif foldspaces and x ==b'y'[0]:\n   if curr:\n    raise ValueError('y inside Ascii85 5-tuple')\n   decoded_append(b'\\x20\\x20\\x20\\x20')\n  elif x in ignorechars:\n  \n   continue\n  else :\n   raise ValueError('Non-Ascii85 digit found: %c'%x)\n   \n result=b''.join(decoded)\n padding=4 -len(curr)\n if padding:\n \n  result=result[:-padding]\n return result\n \n \n \n_b85alphabet=(b\"0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ\"\nb\"abcdefghijklmnopqrstuvwxyz!#$%&()*+-;<=>?@^_`{|}~\")\n_b85chars=None\n_b85chars2=None\n_b85dec=None\n\ndef b85encode(b,pad=False ):\n ''\n\n\n\n \n global _b85chars,_b85chars2\n \n \n if _b85chars is None :\n  _b85chars=[bytes((i,))for i in _b85alphabet]\n  _b85chars2=[(a+b)for a in _b85chars for b in _b85chars]\n return _85encode(b,_b85chars,_b85chars2,pad)\n \ndef b85decode(b):\n ''\n\n\n \n global _b85dec\n \n \n if _b85dec is None :\n  _b85dec=[None ]*256\n  for i,c in enumerate(_b85alphabet):\n   _b85dec[c]=i\n   \n b=_bytes_from_decode_data(b)\n padding=(-len(b))%5\n b=b+b'~'*padding\n out=[]\n packI=struct.Struct('!I').pack\n for i in range(0,len(b),5):\n  chunk=b[i:i+5]\n  acc=0\n  try :\n   for c in chunk:\n    acc=acc *85+_b85dec[c]\n  except TypeError:\n   for j,c in enumerate(chunk):\n    if _b85dec[c]is None :\n     raise ValueError('bad base85 character at position %d'\n     %(i+j))from None\n   raise\n  try :\n   out.append(packI(acc))\n  except struct.error:\n   raise ValueError('base85 overflow in hunk starting at byte %d'\n   %i)from None\n   \n result=b''.join(out)\n if padding:\n  result=result[:-padding]\n return result\n \n \n \n \n \nMAXLINESIZE=76\nMAXBINSIZE=(MAXLINESIZE //4)*3\n\ndef encode(input,output):\n ''\n while True :\n  s=input.read(MAXBINSIZE)\n  if not s:\n   break\n  while len(s)<MAXBINSIZE:\n   ns=input.read(MAXBINSIZE -len(s))\n   if not ns:\n    break\n   s +=ns\n  line=binascii.b2a_base64(s)\n  output.write(line)\n  \n  \ndef decode(input,output):\n ''\n while True :\n  line=input.readline()\n  if not line:\n   break\n  s=binascii.a2b_base64(line)\n  output.write(s)\n  \ndef _input_type_check(s):\n try :\n  m=memoryview(s)\n except TypeError as err:\n  msg=\"expected bytes-like object, not %s\"%s.__class__.__name__\n  raise TypeError(msg)from err\n if m.format not in ('c','b','B'):\n  msg=(\"expected single byte elements, not %r from %s\"%\n  (m.format,s.__class__.__name__))\n  raise TypeError(msg)\n if m.ndim !=1:\n  msg=(\"expected 1-D data, not %d-D data from %s\"%\n  (m.ndim,s.__class__.__name__))\n  raise TypeError(msg)\n  \n  \ndef encodebytes(s):\n ''\n \n _input_type_check(s)\n pieces=[]\n for i in range(0,len(s),MAXBINSIZE):\n  chunk=s[i:i+MAXBINSIZE]\n  pieces.append(binascii.b2a_base64(chunk))\n return b\"\".join(pieces)\n \ndef encodestring(s):\n ''\n import warnings\n warnings.warn(\"encodestring() is a deprecated alias since 3.1, \"\n \"use encodebytes()\",\n DeprecationWarning,2)\n return encodebytes(s)\n \n \ndef decodebytes(s):\n ''\n _input_type_check(s)\n return binascii.a2b_base64(s)\n \ndef decodestring(s):\n ''\n import warnings\n warnings.warn(\"decodestring() is a deprecated alias since Python 3.1, \"\n \"use decodebytes()\",\n DeprecationWarning,2)\n return decodebytes(s)\n \n \n \ndef main():\n ''\n import sys,getopt\n try :\n  opts,args=getopt.getopt(sys.argv[1:],'deut')\n except getopt.error as msg:\n  sys.stdout=sys.stderr\n  print(msg)\n  print(\"\"\"usage: %s [-d|-e|-u|-t] [file|-]\n        -d, -u: decode\n        -e: encode (default)\n        -t: encode and decode string 'Aladdin:open sesame'\"\"\"%sys.argv[0])\n  sys.exit(2)\n func=encode\n for o,a in opts:\n  if o =='-e':func=encode\n  if o =='-d':func=decode\n  if o =='-u':func=decode\n  if o =='-t':test();return\n if args and args[0]!='-':\n  with open(args[0],'rb')as f:\n   func(f,sys.stdout.buffer)\n else :\n  func(sys.stdin.buffer,sys.stdout.buffer)\n  \n  \ndef test():\n s0=b\"Aladdin:open sesame\"\n print(repr(s0))\n s1=encodebytes(s0)\n print(repr(s1))\n s2=decodebytes(s1)\n print(repr(s2))\n assert s0 ==s2\n \n \nif __name__ =='__main__':\n main()\n", ["binascii", "getopt", "re", "struct", "sys", "warnings"]], "bdb": [".py", "''\n\nimport fnmatch\nimport sys\nimport os\nfrom inspect import CO_GENERATOR,CO_COROUTINE,CO_ASYNC_GENERATOR\n\n__all__=[\"BdbQuit\",\"Bdb\",\"Breakpoint\"]\n\nGENERATOR_AND_COROUTINE_FLAGS=CO_GENERATOR |CO_COROUTINE |CO_ASYNC_GENERATOR\n\n\nclass BdbQuit(Exception):\n ''\n \n \nclass Bdb:\n ''\n\n\n\n\n\n\n\n\n\n\n \n \n def __init__(self,skip=None ):\n  self.skip=set(skip)if skip else None\n  self.breaks={}\n  self.fncache={}\n  self.frame_returning=None\n  \n def canonic(self,filename):\n  ''\n\n\n\n\n\n  \n  if filename ==\"<\"+filename[1:-1]+\">\":\n   return filename\n  canonic=self.fncache.get(filename)\n  if not canonic:\n   canonic=os.path.abspath(filename)\n   canonic=os.path.normcase(canonic)\n   self.fncache[filename]=canonic\n  return canonic\n  \n def reset(self):\n  ''\n  import linecache\n  linecache.checkcache()\n  self.botframe=None\n  self._set_stopinfo(None ,None )\n  \n def trace_dispatch(self,frame,event,arg):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  if self.quitting:\n   return\n  if event =='line':\n   return self.dispatch_line(frame)\n  if event =='call':\n   return self.dispatch_call(frame,arg)\n  if event =='return':\n   return self.dispatch_return(frame,arg)\n  if event =='exception':\n   return self.dispatch_exception(frame,arg)\n  if event =='c_call':\n   return self.trace_dispatch\n  if event =='c_exception':\n   return self.trace_dispatch\n  if event =='c_return':\n   return self.trace_dispatch\n  print('bdb.Bdb.dispatch: unknown debugging event:',repr(event))\n  return self.trace_dispatch\n  \n def dispatch_line(self,frame):\n  ''\n\n\n\n\n  \n  if self.stop_here(frame)or self.break_here(frame):\n   self.user_line(frame)\n   if self.quitting:raise BdbQuit\n  return self.trace_dispatch\n  \n def dispatch_call(self,frame,arg):\n  ''\n\n\n\n\n  \n  \n  if self.botframe is None :\n  \n   self.botframe=frame.f_back\n   return self.trace_dispatch\n  if not (self.stop_here(frame)or self.break_anywhere(frame)):\n  \n   return\n   \n  if self.stopframe and frame.f_code.co_flags&GENERATOR_AND_COROUTINE_FLAGS:\n   return self.trace_dispatch\n  self.user_call(frame,arg)\n  if self.quitting:raise BdbQuit\n  return self.trace_dispatch\n  \n def dispatch_return(self,frame,arg):\n  ''\n\n\n\n\n  \n  if self.stop_here(frame)or frame ==self.returnframe:\n  \n   if self.stopframe and frame.f_code.co_flags&GENERATOR_AND_COROUTINE_FLAGS:\n    return self.trace_dispatch\n   try :\n    self.frame_returning=frame\n    self.user_return(frame,arg)\n   finally :\n    self.frame_returning=None\n   if self.quitting:raise BdbQuit\n   \n   if self.stopframe is frame and self.stoplineno !=-1:\n    self._set_stopinfo(None ,None )\n  return self.trace_dispatch\n  \n def dispatch_exception(self,frame,arg):\n  ''\n\n\n\n\n  \n  if self.stop_here(frame):\n  \n  \n  \n   if not (frame.f_code.co_flags&GENERATOR_AND_COROUTINE_FLAGS\n   and arg[0]is StopIteration and arg[2]is None ):\n    self.user_exception(frame,arg)\n    if self.quitting:raise BdbQuit\n    \n    \n    \n    \n  elif (self.stopframe and frame is not self.stopframe\n  and self.stopframe.f_code.co_flags&GENERATOR_AND_COROUTINE_FLAGS\n  and arg[0]in (StopIteration,GeneratorExit)):\n   self.user_exception(frame,arg)\n   if self.quitting:raise BdbQuit\n   \n  return self.trace_dispatch\n  \n  \n  \n  \n  \n def is_skipped_module(self,module_name):\n  ''\n  for pattern in self.skip:\n   if fnmatch.fnmatch(module_name,pattern):\n    return True\n  return False\n  \n def stop_here(self,frame):\n  ''\n  \n  \n  if self.skip and\\\n  self.is_skipped_module(frame.f_globals.get('__name__')):\n   return False\n  if frame is self.stopframe:\n   if self.stoplineno ==-1:\n    return False\n   return frame.f_lineno >=self.stoplineno\n  if not self.stopframe:\n   return True\n  return False\n  \n def break_here(self,frame):\n  ''\n\n\n\n  \n  filename=self.canonic(frame.f_code.co_filename)\n  if filename not in self.breaks:\n   return False\n  lineno=frame.f_lineno\n  if lineno not in self.breaks[filename]:\n  \n  \n   lineno=frame.f_code.co_firstlineno\n   if lineno not in self.breaks[filename]:\n    return False\n    \n    \n  (bp,flag)=effective(filename,lineno,frame)\n  if bp:\n   self.currentbp=bp.number\n   if (flag and bp.temporary):\n    self.do_clear(str(bp.number))\n   return True\n  else :\n   return False\n   \n def do_clear(self,arg):\n  ''\n\n\n  \n  raise NotImplementedError(\"subclass of bdb must implement do_clear()\")\n  \n def break_anywhere(self,frame):\n  ''\n  \n  return self.canonic(frame.f_code.co_filename)in self.breaks\n  \n  \n  \n  \n def user_call(self,frame,argument_list):\n  ''\n  pass\n  \n def user_line(self,frame):\n  ''\n  pass\n  \n def user_return(self,frame,return_value):\n  ''\n  pass\n  \n def user_exception(self,frame,exc_info):\n  ''\n  pass\n  \n def _set_stopinfo(self,stopframe,returnframe,stoplineno=0):\n  ''\n\n\n\n\n  \n  self.stopframe=stopframe\n  self.returnframe=returnframe\n  self.quitting=False\n  \n  \n  self.stoplineno=stoplineno\n  \n  \n  \n  \n def set_until(self,frame,lineno=None ):\n  ''\n  \n  \n  if lineno is None :\n   lineno=frame.f_lineno+1\n  self._set_stopinfo(frame,frame,lineno)\n  \n def set_step(self):\n  ''\n  \n  \n  \n  \n  if self.frame_returning:\n   caller_frame=self.frame_returning.f_back\n   if caller_frame and not caller_frame.f_trace:\n    caller_frame.f_trace=self.trace_dispatch\n  self._set_stopinfo(None ,None )\n  \n def set_next(self,frame):\n  ''\n  self._set_stopinfo(frame,None )\n  \n def set_return(self,frame):\n  ''\n  if frame.f_code.co_flags&GENERATOR_AND_COROUTINE_FLAGS:\n   self._set_stopinfo(frame,None ,-1)\n  else :\n   self._set_stopinfo(frame.f_back,frame)\n   \n def set_trace(self,frame=None ):\n  ''\n\n\n  \n  if frame is None :\n   frame=sys._getframe().f_back\n  self.reset()\n  while frame:\n   frame.f_trace=self.trace_dispatch\n   self.botframe=frame\n   frame=frame.f_back\n  self.set_step()\n  sys.settrace(self.trace_dispatch)\n  \n def set_continue(self):\n  ''\n\n\n  \n  \n  self._set_stopinfo(self.botframe,None ,-1)\n  if not self.breaks:\n  \n   sys.settrace(None )\n   frame=sys._getframe().f_back\n   while frame and frame is not self.botframe:\n    del frame.f_trace\n    frame=frame.f_back\n    \n def set_quit(self):\n  ''\n\n\n  \n  self.stopframe=self.botframe\n  self.returnframe=None\n  self.quitting=True\n  sys.settrace(None )\n  \n  \n  \n  \n  \n  \n  \n  \n def set_break(self,filename,lineno,temporary=False ,cond=None ,\n funcname=None ):\n  ''\n\n\n\n  \n  filename=self.canonic(filename)\n  import linecache\n  line=linecache.getline(filename,lineno)\n  if not line:\n   return 'Line %s:%d does not exist'%(filename,lineno)\n  list=self.breaks.setdefault(filename,[])\n  if lineno not in list:\n   list.append(lineno)\n  bp=Breakpoint(filename,lineno,temporary,cond,funcname)\n  return None\n  \n def _prune_breaks(self,filename,lineno):\n  ''\n\n\n\n\n\n  \n  if (filename,lineno)not in Breakpoint.bplist:\n   self.breaks[filename].remove(lineno)\n  if not self.breaks[filename]:\n   del self.breaks[filename]\n   \n def clear_break(self,filename,lineno):\n  ''\n\n\n  \n  filename=self.canonic(filename)\n  if filename not in self.breaks:\n   return 'There are no breakpoints in %s'%filename\n  if lineno not in self.breaks[filename]:\n   return 'There is no breakpoint at %s:%d'%(filename,lineno)\n   \n   \n  for bp in Breakpoint.bplist[filename,lineno][:]:\n   bp.deleteMe()\n  self._prune_breaks(filename,lineno)\n  return None\n  \n def clear_bpbynumber(self,arg):\n  ''\n\n\n  \n  try :\n   bp=self.get_bpbynumber(arg)\n  except ValueError as err:\n   return str(err)\n  bp.deleteMe()\n  self._prune_breaks(bp.file,bp.line)\n  return None\n  \n def clear_all_file_breaks(self,filename):\n  ''\n\n\n  \n  filename=self.canonic(filename)\n  if filename not in self.breaks:\n   return 'There are no breakpoints in %s'%filename\n  for line in self.breaks[filename]:\n   blist=Breakpoint.bplist[filename,line]\n   for bp in blist:\n    bp.deleteMe()\n  del self.breaks[filename]\n  return None\n  \n def clear_all_breaks(self):\n  ''\n\n\n  \n  if not self.breaks:\n   return 'There are no breakpoints'\n  for bp in Breakpoint.bpbynumber:\n   if bp:\n    bp.deleteMe()\n  self.breaks={}\n  return None\n  \n def get_bpbynumber(self,arg):\n  ''\n\n\n\n  \n  if not arg:\n   raise ValueError('Breakpoint number expected')\n  try :\n   number=int(arg)\n  except ValueError:\n   raise ValueError('Non-numeric breakpoint number %s'%arg)from None\n  try :\n   bp=Breakpoint.bpbynumber[number]\n  except IndexError:\n   raise ValueError('Breakpoint number %d out of range'%number)from None\n  if bp is None :\n   raise ValueError('Breakpoint %d already deleted'%number)\n  return bp\n  \n def get_break(self,filename,lineno):\n  ''\n  filename=self.canonic(filename)\n  return filename in self.breaks and\\\n  lineno in self.breaks[filename]\n  \n def get_breaks(self,filename,lineno):\n  ''\n\n\n  \n  filename=self.canonic(filename)\n  return filename in self.breaks and\\\n  lineno in self.breaks[filename]and\\\n  Breakpoint.bplist[filename,lineno]or []\n  \n def get_file_breaks(self,filename):\n  ''\n\n\n  \n  filename=self.canonic(filename)\n  if filename in self.breaks:\n   return self.breaks[filename]\n  else :\n   return []\n   \n def get_all_breaks(self):\n  ''\n  return self.breaks\n  \n  \n  \n  \n def get_stack(self,f,t):\n  ''\n\n\n\n  \n  stack=[]\n  if t and t.tb_frame is f:\n   t=t.tb_next\n  while f is not None :\n   stack.append((f,f.f_lineno))\n   if f is self.botframe:\n    break\n   f=f.f_back\n  stack.reverse()\n  i=max(0,len(stack)-1)\n  while t is not None :\n   stack.append((t.tb_frame,t.tb_lineno))\n   t=t.tb_next\n  if f is None :\n   i=max(0,len(stack)-1)\n  return stack,i\n  \n def format_stack_entry(self,frame_lineno,lprefix=': '):\n  ''\n\n\n\n\n\n\n  \n  import linecache,reprlib\n  frame,lineno=frame_lineno\n  filename=self.canonic(frame.f_code.co_filename)\n  s='%s(%r)'%(filename,lineno)\n  if frame.f_code.co_name:\n   s +=frame.f_code.co_name\n  else :\n   s +=\"<lambda>\"\n  if '__args__'in frame.f_locals:\n   args=frame.f_locals['__args__']\n  else :\n   args=None\n  if args:\n   s +=reprlib.repr(args)\n  else :\n   s +='()'\n  if '__return__'in frame.f_locals:\n   rv=frame.f_locals['__return__']\n   s +='->'\n   s +=reprlib.repr(rv)\n  line=linecache.getline(filename,lineno,frame.f_globals)\n  if line:\n   s +=lprefix+line.strip()\n  return s\n  \n  \n  \n  \n  \n def run(self,cmd,globals=None ,locals=None ):\n  ''\n\n\n  \n  if globals is None :\n   import __main__\n   globals=__main__.__dict__\n  if locals is None :\n   locals=globals\n  self.reset()\n  if isinstance(cmd,str):\n   cmd=compile(cmd,\"<string>\",\"exec\")\n  sys.settrace(self.trace_dispatch)\n  try :\n   exec(cmd,globals,locals)\n  except BdbQuit:\n   pass\n  finally :\n   self.quitting=True\n   sys.settrace(None )\n   \n def runeval(self,expr,globals=None ,locals=None ):\n  ''\n\n\n  \n  if globals is None :\n   import __main__\n   globals=__main__.__dict__\n  if locals is None :\n   locals=globals\n  self.reset()\n  sys.settrace(self.trace_dispatch)\n  try :\n   return eval(expr,globals,locals)\n  except BdbQuit:\n   pass\n  finally :\n   self.quitting=True\n   sys.settrace(None )\n   \n def runctx(self,cmd,globals,locals):\n  ''\n  \n  self.run(cmd,globals,locals)\n  \n  \n  \n def runcall(self,func,*args,**kwds):\n  ''\n\n\n  \n  self.reset()\n  sys.settrace(self.trace_dispatch)\n  res=None\n  try :\n   res=func(*args,**kwds)\n  except BdbQuit:\n   pass\n  finally :\n   self.quitting=True\n   sys.settrace(None )\n  return res\n  \n  \ndef set_trace():\n ''\n Bdb().set_trace()\n \n \nclass Breakpoint:\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n \n \n \n next=1\n bplist={}\n bpbynumber=[None ]\n \n \n \n def __init__(self,file,line,temporary=False ,cond=None ,funcname=None ):\n  self.funcname=funcname\n  \n  self.func_first_executable_line=None\n  self.file=file\n  self.line=line\n  self.temporary=temporary\n  self.cond=cond\n  self.enabled=True\n  self.ignore=0\n  self.hits=0\n  self.number=Breakpoint.next\n  Breakpoint.next +=1\n  \n  self.bpbynumber.append(self)\n  if (file,line)in self.bplist:\n   self.bplist[file,line].append(self)\n  else :\n   self.bplist[file,line]=[self]\n   \n def deleteMe(self):\n  ''\n\n\n\n  \n  \n  index=(self.file,self.line)\n  self.bpbynumber[self.number]=None\n  self.bplist[index].remove(self)\n  if not self.bplist[index]:\n  \n   del self.bplist[index]\n   \n def enable(self):\n  ''\n  self.enabled=True\n  \n def disable(self):\n  ''\n  self.enabled=False\n  \n def bpprint(self,out=None ):\n  ''\n\n\n\n  \n  if out is None :\n   out=sys.stdout\n  print(self.bpformat(),file=out)\n  \n def bpformat(self):\n  ''\n\n\n\n\n\n  \n  if self.temporary:\n   disp='del  '\n  else :\n   disp='keep '\n  if self.enabled:\n   disp=disp+'yes  '\n  else :\n   disp=disp+'no   '\n  ret='%-4dbreakpoint   %s at %s:%d'%(self.number,disp,\n  self.file,self.line)\n  if self.cond:\n   ret +='\\n\\tstop only if %s'%(self.cond,)\n  if self.ignore:\n   ret +='\\n\\tignore next %d hits'%(self.ignore,)\n  if self.hits:\n   if self.hits >1:\n    ss='s'\n   else :\n    ss=''\n   ret +='\\n\\tbreakpoint already hit %d time%s'%(self.hits,ss)\n  return ret\n  \n def __str__(self):\n  ''\n  return 'breakpoint %s at %s:%s'%(self.number,self.file,self.line)\n  \n  \n  \n  \ndef checkfuncname(b,frame):\n ''\n\n\n\n\n\n \n if not b.funcname:\n \n  if b.line !=frame.f_lineno:\n  \n  \n   return False\n  return True\n  \n  \n if frame.f_code.co_name !=b.funcname:\n \n  return False\n  \n  \n if not b.func_first_executable_line:\n \n  b.func_first_executable_line=frame.f_lineno\n  \n if b.func_first_executable_line !=frame.f_lineno:\n \n  return False\n return True\n \n \n \n \ndef effective(file,line,frame):\n ''\n\n\n\n\n\n \n possibles=Breakpoint.bplist[file,line]\n for b in possibles:\n  if not b.enabled:\n   continue\n  if not checkfuncname(b,frame):\n   continue\n   \n  b.hits +=1\n  if not b.cond:\n  \n   if b.ignore >0:\n    b.ignore -=1\n    continue\n   else :\n   \n    return (b,True )\n  else :\n  \n  \n  \n   try :\n    val=eval(b.cond,frame.f_globals,frame.f_locals)\n    if val:\n     if b.ignore >0:\n      b.ignore -=1\n      \n     else :\n      return (b,True )\n      \n      \n   except :\n   \n   \n   \n    return (b,False )\n return (None ,None )\n \n \n \n \nclass Tdb(Bdb):\n def user_call(self,frame,args):\n  name=frame.f_code.co_name\n  if not name:name='???'\n  print('+++ call',name,args)\n def user_line(self,frame):\n  import linecache\n  name=frame.f_code.co_name\n  if not name:name='???'\n  fn=self.canonic(frame.f_code.co_filename)\n  line=linecache.getline(fn,frame.f_lineno,frame.f_globals)\n  print('+++',fn,frame.f_lineno,name,':',line.strip())\n def user_return(self,frame,retval):\n  print('+++ return',retval)\n def user_exception(self,frame,exc_stuff):\n  print('+++ exception',exc_stuff)\n  self.set_continue()\n  \ndef foo(n):\n print('foo(',n,')')\n x=bar(n *10)\n print('bar returned',x)\n \ndef bar(a):\n print('bar(',a,')')\n return a /2\n \ndef test():\n t=Tdb()\n t.run('import bdb; bdb.foo(10)')\n", ["__main__", "fnmatch", "inspect", "linecache", "os", "reprlib", "sys"]], "binascii": [".py", "''\n\n\n\n\n\n\n\nimport _base64\n\nfrom _binascii import *\n\nclass Error(ValueError):\n def __init__(self,msg=''):\n  self._msg=msg\n  \n def __str__(self):\n  return \" binascii.Error: \"+self._msg\n  \n  \nclass Done(Exception):\n pass\n \nclass Incomplete(Error):\n pass\n \ndef a2b_uu(s):\n if not s:\n  return ''\n  \n length=(ord(s[0])-0x20)%64\n \n def quadruplets_gen(s):\n  while s:\n   try :\n    yield ord(s[0]),ord(s[1]),ord(s[2]),ord(s[3])\n   except IndexError:\n    s +='   '\n    yield ord(s[0]),ord(s[1]),ord(s[2]),ord(s[3])\n    return\n   s=s[4:]\n   \n try :\n  result=[''.join(\n  [chr((A -0x20)<<2 |(((B -0x20)>>4)&0x3)),\n  chr(((B -0x20)&0xf)<<4 |(((C -0x20)>>2)&0xf)),\n  chr(((C -0x20)&0x3)<<6 |((D -0x20)&0x3f))\n  ])for A,B,C,D in quadruplets_gen(s[1:].rstrip())]\n except ValueError:\n  raise Error('Illegal char')\n result=''.join(result)\n trailingdata=result[length:]\n if trailingdata.strip('\\x00'):\n  raise Error('Trailing garbage')\n result=result[:length]\n if len(result)<length:\n  result +=((length -len(result))*'\\x00')\n return bytes(result,__BRYTHON__.charset)\n \n \ntable_a2b_base64={\n'A':0,\n'B':1,\n'C':2,\n'D':3,\n'E':4,\n'F':5,\n'G':6,\n'H':7,\n'I':8,\n'J':9,\n'K':10,\n'L':11,\n'M':12,\n'N':13,\n'O':14,\n'P':15,\n'Q':16,\n'R':17,\n'S':18,\n'T':19,\n'U':20,\n'V':21,\n'W':22,\n'X':23,\n'Y':24,\n'Z':25,\n'a':26,\n'b':27,\n'c':28,\n'd':29,\n'e':30,\n'f':31,\n'g':32,\n'h':33,\n'i':34,\n'j':35,\n'k':36,\n'l':37,\n'm':38,\n'n':39,\n'o':40,\n'p':41,\n'q':42,\n'r':43,\n's':44,\n't':45,\n'u':46,\n'v':47,\n'w':48,\n'x':49,\n'y':50,\n'z':51,\n'0':52,\n'1':53,\n'2':54,\n'3':55,\n'4':56,\n'5':57,\n'6':58,\n'7':59,\n'8':60,\n'9':61,\n'+':62,\n'/':63,\n'=':0,\n}\n\n\ndef XXXa2b_base64(s):\n return _base64.Base64.decode(s)\n \ntable_b2a_base64=\"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz\"\\\n\"0123456789+/\"\n\ndef XXXb2a_base64(s,newline=True ):\n length=len(s)\n final_length=length %3\n \n def triples_gen(s):\n  while s:\n   try :\n    yield s[0],s[1],s[2]\n   except IndexError:\n    s +=b'\\0\\0'\n    yield s[0],s[1],s[2]\n    return\n   s=s[3:]\n   \n a=triples_gen(s[:length -final_length])\n \n result=[''.join(\n [table_b2a_base64[(A >>2)&0x3F],\n table_b2a_base64[((A <<4)|((B >>4)&0xF))&0x3F],\n table_b2a_base64[((B <<2)|((C >>6)&0x3))&0x3F],\n table_b2a_base64[(C)&0x3F]])\n for A,B,C in a]\n \n final=s[length -final_length:]\n if final_length ==0:\n  snippet=''\n elif final_length ==1:\n  a=final[0]\n  snippet=table_b2a_base64[(a >>2)&0x3F]+\\\n  table_b2a_base64[(a <<4)&0x3F]+'=='\n else :\n  a=final[0]\n  b=final[1]\n  snippet=table_b2a_base64[(a >>2)&0x3F]+\\\n  table_b2a_base64[((a <<4)|(b >>4)&0xF)&0x3F]+\\\n  table_b2a_base64[(b <<2)&0x3F]+'='\n  \n result=''.join(result)+snippet\n if newline:\n  result +='\\n'\n return bytes(result,__BRYTHON__.charset)\n \ndef a2b_qp(s,header=False ):\n inp=0\n odata=[]\n while inp <len(s):\n  if s[inp]=='=':\n   inp +=1\n   if inp >=len(s):\n    break\n    \n   if (s[inp]=='\\n')or (s[inp]=='\\r'):\n    if s[inp]!='\\n':\n     while inp <len(s)and s[inp]!='\\n':\n      inp +=1\n    if inp <len(s):\n     inp +=1\n   elif s[inp]=='=':\n   \n    odata.append('=')\n    inp +=1\n   elif s[inp]in hex_numbers and s[inp+1]in hex_numbers:\n    ch=chr(int(s[inp:inp+2],16))\n    inp +=2\n    odata.append(ch)\n   else :\n    odata.append('=')\n  elif header and s[inp]=='_':\n   odata.append(' ')\n   inp +=1\n  else :\n   odata.append(s[inp])\n   inp +=1\n return bytes(''.join(odata),__BRYTHON__.charset)\n \ndef b2a_qp(data,quotetabs=False ,istext=True ,header=False ):\n ''\n\n\n\n\n \n MAXLINESIZE=76\n \n \n lf=data.find('\\n')\n crlf=lf >0 and data[lf -1]=='\\r'\n \n inp=0\n linelen=0\n odata=[]\n while inp <len(data):\n  c=data[inp]\n  if (c >'~'or\n  c =='='or\n  (header and c =='_')or\n  (c =='.'and linelen ==0 and (inp+1 ==len(data)or\n  data[inp+1]=='\\n'or\n  data[inp+1]=='\\r'))or\n  (not istext and (c =='\\r'or c =='\\n'))or\n  ((c =='\\t'or c ==' ')and (inp+1 ==len(data)))or\n  (c <=' 'and c !='\\r'and c !='\\n'and\n  (quotetabs or (not quotetabs and (c !='\\t'and c !=' '))))):\n   linelen +=3\n   if linelen >=MAXLINESIZE:\n    odata.append('=')\n    if crlf:odata.append('\\r')\n    odata.append('\\n')\n    linelen=3\n   odata.append('='+two_hex_digits(ord(c)))\n   inp +=1\n  else :\n   if (istext and\n   (c =='\\n'or (inp+1 <len(data)and c =='\\r'and\n   data[inp+1]=='\\n'))):\n    linelen=0\n    \n    if (len(odata)>0 and\n    (odata[-1]==' 'or odata[-1]=='\\t')):\n     ch=ord(odata[-1])\n     odata[-1]='='\n     odata.append(two_hex_digits(ch))\n     \n    if crlf:odata.append('\\r')\n    odata.append('\\n')\n    if c =='\\r':\n     inp +=2\n    else :\n     inp +=1\n   else :\n    if (inp+1 <len(data)and\n    data[inp+1]!='\\n'and\n    (linelen+1)>=MAXLINESIZE):\n     odata.append('=')\n     if crlf:odata.append('\\r')\n     odata.append('\\n')\n     linelen=0\n     \n    linelen +=1\n    if header and c ==' ':\n     c='_'\n    odata.append(c)\n    inp +=1\n return ''.join(odata)\n \nhex_numbers='0123456789ABCDEF'\ndef hex(n):\n if n ==0:\n  return '0'\n  \n if n <0:\n  n=-n\n  sign='-'\n else :\n  sign=''\n arr=[]\n \n def hex_gen(n):\n  ''\n  while n:\n   yield n %0x10\n   n=n /0x10\n   \n for nibble in hex_gen(n):\n  arr=[hex_numbers[nibble]]+arr\n return sign+''.join(arr)\n \ndef two_hex_digits(n):\n return hex_numbers[n /0x10]+hex_numbers[n %0x10]\n \n \ndef strhex_to_int(s):\n i=0\n for c in s:\n  i=i *0x10+hex_numbers.index(c)\n return i\n \nhqx_encoding='!\"#$%&\\'()*+,-012345689@ABCDEFGHIJKLMNPQRSTUVXYZ[`abcdefhijklmpqr'\n\nDONE=0x7f\nSKIP=0x7e\nFAIL=0x7d\n\ntable_a2b_hqx=[\n\nFAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,\n\nFAIL,FAIL,SKIP,FAIL,FAIL,SKIP,FAIL,FAIL,\n\nFAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,\n\nFAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,\n\nFAIL,0x00,0x01,0x02,0x03,0x04,0x05,0x06,\n\n0x07,0x08,0x09,0x0A,0x0B,0x0C,FAIL,FAIL,\n\n0x0D,0x0E,0x0F,0x10,0x11,0x12,0x13,FAIL,\n\n0x14,0x15,DONE,FAIL,FAIL,FAIL,FAIL,FAIL,\n\n0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,\n\n0x1E,0x1F,0x20,0x21,0x22,0x23,0x24,FAIL,\n\n0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,FAIL,\n\n0x2C,0x2D,0x2E,0x2F,FAIL,FAIL,FAIL,FAIL,\n\n0x30,0x31,0x32,0x33,0x34,0x35,0x36,FAIL,\n\n0x37,0x38,0x39,0x3A,0x3B,0x3C,FAIL,FAIL,\n\n0x3D,0x3E,0x3F,FAIL,FAIL,FAIL,FAIL,FAIL,\n\nFAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,\nFAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,\nFAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,\nFAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,\nFAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,\nFAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,\nFAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,\nFAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,\nFAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,\nFAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,\nFAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,\nFAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,\nFAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,\nFAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,\nFAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,\nFAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,\nFAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,FAIL,\n]\n\ndef a2b_hqx(s):\n result=[]\n \n def quadruples_gen(s):\n  t=[]\n  for c in s:\n   res=table_a2b_hqx[ord(c)]\n   if res ==SKIP:\n    continue\n   elif res ==FAIL:\n    raise Error('Illegal character')\n   elif res ==DONE:\n    yield t\n    raise Done\n   else :\n    t.append(res)\n   if len(t)==4:\n    yield t\n    t=[]\n  yield t\n  \n done=0\n try :\n  for snippet in quadruples_gen(s):\n   length=len(snippet)\n   if length ==4:\n    result.append(chr(((snippet[0]&0x3f)<<2)|(snippet[1]>>4)))\n    result.append(chr(((snippet[1]&0x0f)<<4)|(snippet[2]>>2)))\n    result.append(chr(((snippet[2]&0x03)<<6)|(snippet[3])))\n   elif length ==3:\n    result.append(chr(((snippet[0]&0x3f)<<2)|(snippet[1]>>4)))\n    result.append(chr(((snippet[1]&0x0f)<<4)|(snippet[2]>>2)))\n   elif length ==2:\n    result.append(chr(((snippet[0]&0x3f)<<2)|(snippet[1]>>4)))\n except Done:\n  done=1\n except Error:\n  raise\n return (''.join(result),done)\n \n \n \ndef b2a_hqx(s):\n result=[]\n \n def triples_gen(s):\n  while s:\n   try :\n    yield ord(s[0]),ord(s[1]),ord(s[2])\n   except IndexError:\n    yield tuple([ord(c)for c in s])\n   s=s[3:]\n   \n for snippet in triples_gen(s):\n  length=len(snippet)\n  if length ==3:\n   result.append(\n   hqx_encoding[(snippet[0]&0xfc)>>2])\n   result.append(hqx_encoding[\n   ((snippet[0]&0x03)<<4)|((snippet[1]&0xf0)>>4)])\n   result.append(hqx_encoding[\n   (snippet[1]&0x0f)<<2 |((snippet[2]&0xc0)>>6)])\n   result.append(hqx_encoding[snippet[2]&0x3f])\n  elif length ==2:\n   result.append(\n   hqx_encoding[(snippet[0]&0xfc)>>2])\n   result.append(hqx_encoding[\n   ((snippet[0]&0x03)<<4)|((snippet[1]&0xf0)>>4)])\n   result.append(hqx_encoding[\n   (snippet[1]&0x0f)<<2])\n  elif length ==1:\n   result.append(\n   hqx_encoding[(snippet[0]&0xfc)>>2])\n   result.append(hqx_encoding[\n   ((snippet[0]&0x03)<<4)])\n return ''.join(result)\n \ncrctab_hqx=[\n0x0000,0x1021,0x2042,0x3063,0x4084,0x50a5,0x60c6,0x70e7,\n0x8108,0x9129,0xa14a,0xb16b,0xc18c,0xd1ad,0xe1ce,0xf1ef,\n0x1231,0x0210,0x3273,0x2252,0x52b5,0x4294,0x72f7,0x62d6,\n0x9339,0x8318,0xb37b,0xa35a,0xd3bd,0xc39c,0xf3ff,0xe3de,\n0x2462,0x3443,0x0420,0x1401,0x64e6,0x74c7,0x44a4,0x5485,\n0xa56a,0xb54b,0x8528,0x9509,0xe5ee,0xf5cf,0xc5ac,0xd58d,\n0x3653,0x2672,0x1611,0x0630,0x76d7,0x66f6,0x5695,0x46b4,\n0xb75b,0xa77a,0x9719,0x8738,0xf7df,0xe7fe,0xd79d,0xc7bc,\n0x48c4,0x58e5,0x6886,0x78a7,0x0840,0x1861,0x2802,0x3823,\n0xc9cc,0xd9ed,0xe98e,0xf9af,0x8948,0x9969,0xa90a,0xb92b,\n0x5af5,0x4ad4,0x7ab7,0x6a96,0x1a71,0x0a50,0x3a33,0x2a12,\n0xdbfd,0xcbdc,0xfbbf,0xeb9e,0x9b79,0x8b58,0xbb3b,0xab1a,\n0x6ca6,0x7c87,0x4ce4,0x5cc5,0x2c22,0x3c03,0x0c60,0x1c41,\n0xedae,0xfd8f,0xcdec,0xddcd,0xad2a,0xbd0b,0x8d68,0x9d49,\n0x7e97,0x6eb6,0x5ed5,0x4ef4,0x3e13,0x2e32,0x1e51,0x0e70,\n0xff9f,0xefbe,0xdfdd,0xcffc,0xbf1b,0xaf3a,0x9f59,0x8f78,\n0x9188,0x81a9,0xb1ca,0xa1eb,0xd10c,0xc12d,0xf14e,0xe16f,\n0x1080,0x00a1,0x30c2,0x20e3,0x5004,0x4025,0x7046,0x6067,\n0x83b9,0x9398,0xa3fb,0xb3da,0xc33d,0xd31c,0xe37f,0xf35e,\n0x02b1,0x1290,0x22f3,0x32d2,0x4235,0x5214,0x6277,0x7256,\n0xb5ea,0xa5cb,0x95a8,0x8589,0xf56e,0xe54f,0xd52c,0xc50d,\n0x34e2,0x24c3,0x14a0,0x0481,0x7466,0x6447,0x5424,0x4405,\n0xa7db,0xb7fa,0x8799,0x97b8,0xe75f,0xf77e,0xc71d,0xd73c,\n0x26d3,0x36f2,0x0691,0x16b0,0x6657,0x7676,0x4615,0x5634,\n0xd94c,0xc96d,0xf90e,0xe92f,0x99c8,0x89e9,0xb98a,0xa9ab,\n0x5844,0x4865,0x7806,0x6827,0x18c0,0x08e1,0x3882,0x28a3,\n0xcb7d,0xdb5c,0xeb3f,0xfb1e,0x8bf9,0x9bd8,0xabbb,0xbb9a,\n0x4a75,0x5a54,0x6a37,0x7a16,0x0af1,0x1ad0,0x2ab3,0x3a92,\n0xfd2e,0xed0f,0xdd6c,0xcd4d,0xbdaa,0xad8b,0x9de8,0x8dc9,\n0x7c26,0x6c07,0x5c64,0x4c45,0x3ca2,0x2c83,0x1ce0,0x0cc1,\n0xef1f,0xff3e,0xcf5d,0xdf7c,0xaf9b,0xbfba,0x8fd9,0x9ff8,\n0x6e17,0x7e36,0x4e55,0x5e74,0x2e93,0x3eb2,0x0ed1,0x1ef0,\n]\n\ndef crc_hqx(s,crc):\n for c in s:\n  crc=((crc <<8)&0xff00)^crctab_hqx[((crc >>8)&0xff)^ord(c)]\n  \n return crc\n \ndef rlecode_hqx(s):\n ''\n\n\n\n \n if not s:\n  return ''\n result=[]\n prev=s[0]\n count=1\n \n \n \n \n if s[-1]=='!':\n  s=s[1:]+'?'\n else :\n  s=s[1:]+'!'\n  \n for c in s:\n  if c ==prev and count <255:\n   count +=1\n  else :\n   if count ==1:\n    if prev !='\\x90':\n     result.append(prev)\n    else :\n     result.extend(['\\x90','\\x00'])\n   elif count <4:\n    if prev !='\\x90':\n     result.extend([prev]*count)\n    else :\n     result.extend(['\\x90','\\x00']*count)\n   else :\n    if prev !='\\x90':\n     result.extend([prev,'\\x90',chr(count)])\n    else :\n     result.extend(['\\x90','\\x00','\\x90',chr(count)])\n   count=1\n   prev=c\n   \n return ''.join(result)\n \ndef rledecode_hqx(s):\n s=s.split('\\x90')\n result=[s[0]]\n prev=s[0]\n for snippet in s[1:]:\n  count=ord(snippet[0])\n  if count >0:\n   result.append(prev[-1]*(count -1))\n   prev=snippet\n  else :\n   result.append('\\x90')\n   prev='\\x90'\n  result.append(snippet[1:])\n  \n return ''.join(result)\n \ncrc_32_tab=[\n0x00000000,0x77073096,0xee0e612c,0x990951ba,0x076dc419,\n0x706af48f,0xe963a535,0x9e6495a3,0x0edb8832,0x79dcb8a4,\n0xe0d5e91e,0x97d2d988,0x09b64c2b,0x7eb17cbd,0xe7b82d07,\n0x90bf1d91,0x1db71064,0x6ab020f2,0xf3b97148,0x84be41de,\n0x1adad47d,0x6ddde4eb,0xf4d4b551,0x83d385c7,0x136c9856,\n0x646ba8c0,0xfd62f97a,0x8a65c9ec,0x14015c4f,0x63066cd9,\n0xfa0f3d63,0x8d080df5,0x3b6e20c8,0x4c69105e,0xd56041e4,\n0xa2677172,0x3c03e4d1,0x4b04d447,0xd20d85fd,0xa50ab56b,\n0x35b5a8fa,0x42b2986c,0xdbbbc9d6,0xacbcf940,0x32d86ce3,\n0x45df5c75,0xdcd60dcf,0xabd13d59,0x26d930ac,0x51de003a,\n0xc8d75180,0xbfd06116,0x21b4f4b5,0x56b3c423,0xcfba9599,\n0xb8bda50f,0x2802b89e,0x5f058808,0xc60cd9b2,0xb10be924,\n0x2f6f7c87,0x58684c11,0xc1611dab,0xb6662d3d,0x76dc4190,\n0x01db7106,0x98d220bc,0xefd5102a,0x71b18589,0x06b6b51f,\n0x9fbfe4a5,0xe8b8d433,0x7807c9a2,0x0f00f934,0x9609a88e,\n0xe10e9818,0x7f6a0dbb,0x086d3d2d,0x91646c97,0xe6635c01,\n0x6b6b51f4,0x1c6c6162,0x856530d8,0xf262004e,0x6c0695ed,\n0x1b01a57b,0x8208f4c1,0xf50fc457,0x65b0d9c6,0x12b7e950,\n0x8bbeb8ea,0xfcb9887c,0x62dd1ddf,0x15da2d49,0x8cd37cf3,\n0xfbd44c65,0x4db26158,0x3ab551ce,0xa3bc0074,0xd4bb30e2,\n0x4adfa541,0x3dd895d7,0xa4d1c46d,0xd3d6f4fb,0x4369e96a,\n0x346ed9fc,0xad678846,0xda60b8d0,0x44042d73,0x33031de5,\n0xaa0a4c5f,0xdd0d7cc9,0x5005713c,0x270241aa,0xbe0b1010,\n0xc90c2086,0x5768b525,0x206f85b3,0xb966d409,0xce61e49f,\n0x5edef90e,0x29d9c998,0xb0d09822,0xc7d7a8b4,0x59b33d17,\n0x2eb40d81,0xb7bd5c3b,0xc0ba6cad,0xedb88320,0x9abfb3b6,\n0x03b6e20c,0x74b1d29a,0xead54739,0x9dd277af,0x04db2615,\n0x73dc1683,0xe3630b12,0x94643b84,0x0d6d6a3e,0x7a6a5aa8,\n0xe40ecf0b,0x9309ff9d,0x0a00ae27,0x7d079eb1,0xf00f9344,\n0x8708a3d2,0x1e01f268,0x6906c2fe,0xf762575d,0x806567cb,\n0x196c3671,0x6e6b06e7,0xfed41b76,0x89d32be0,0x10da7a5a,\n0x67dd4acc,0xf9b9df6f,0x8ebeeff9,0x17b7be43,0x60b08ed5,\n0xd6d6a3e8,0xa1d1937e,0x38d8c2c4,0x4fdff252,0xd1bb67f1,\n0xa6bc5767,0x3fb506dd,0x48b2364b,0xd80d2bda,0xaf0a1b4c,\n0x36034af6,0x41047a60,0xdf60efc3,0xa867df55,0x316e8eef,\n0x4669be79,0xcb61b38c,0xbc66831a,0x256fd2a0,0x5268e236,\n0xcc0c7795,0xbb0b4703,0x220216b9,0x5505262f,0xc5ba3bbe,\n0xb2bd0b28,0x2bb45a92,0x5cb36a04,0xc2d7ffa7,0xb5d0cf31,\n0x2cd99e8b,0x5bdeae1d,0x9b64c2b0,0xec63f226,0x756aa39c,\n0x026d930a,0x9c0906a9,0xeb0e363f,0x72076785,0x05005713,\n0x95bf4a82,0xe2b87a14,0x7bb12bae,0x0cb61b38,0x92d28e9b,\n0xe5d5be0d,0x7cdcefb7,0x0bdbdf21,0x86d3d2d4,0xf1d4e242,\n0x68ddb3f8,0x1fda836e,0x81be16cd,0xf6b9265b,0x6fb077e1,\n0x18b74777,0x88085ae6,0xff0f6a70,0x66063bca,0x11010b5c,\n0x8f659eff,0xf862ae69,0x616bffd3,0x166ccf45,0xa00ae278,\n0xd70dd2ee,0x4e048354,0x3903b3c2,0xa7672661,0xd06016f7,\n0x4969474d,0x3e6e77db,0xaed16a4a,0xd9d65adc,0x40df0b66,\n0x37d83bf0,0xa9bcae53,0xdebb9ec5,0x47b2cf7f,0x30b5ffe9,\n0xbdbdf21c,0xcabac28a,0x53b39330,0x24b4a3a6,0xbad03605,\n0xcdd70693,0x54de5729,0x23d967bf,0xb3667a2e,0xc4614ab8,\n0x5d681b02,0x2a6f2b94,0xb40bbe37,0xc30c8ea1,0x5a05df1b,\n0x2d02ef8d\n]\n\ndef crc32(s,crc=0):\n result=0\n crc=~int(crc)&0xffffffff\n \n for c in s:\n  crc=crc_32_tab[(crc ^int(ord(c)))&0xff]^(crc >>8)\n  \n  \n  \n result=crc ^0xffffffff\n \n if result >2 **31:\n  result=((result+2 **31)%2 **32)-2 **31\n  \n return result\n \ntable_hex=[\n-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,\n-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,\n-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,\n0,1,2,3,4,5,6,7,8,9,-1,-1,-1,-1,-1,-1,\n-1,10,11,12,13,14,15,-1,-1,-1,-1,-1,-1,-1,-1,-1,\n-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,\n-1,10,11,12,13,14,15,-1,-1,-1,-1,-1,-1,-1,-1,-1,\n-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1\n]\n\n\ndef a2b_hex(t):\n result=[]\n \n def pairs_gen(s):\n  if isinstance(s,bytes)or isinstance(s,bytearray):\n   conv=lambda x:x\n  else :\n   conv=lambda x:ord(x)\n  while s:\n   try :\n    yield table_hex[conv(s[0])],table_hex[conv(s[1])]\n   except IndexError:\n    if len(s):\n     raise TypeError('Odd-length string')\n    return\n   s=s[2:]\n   \n for a,b in pairs_gen(t):\n  if a <0 or b <0:\n   raise TypeError('Non-hexadecimal digit found')\n  result.append(chr((a <<4)+b))\n return bytes(''.join(result),__BRYTHON__.charset)\n \n \nunhexlify=a2b_hex\n", ["_base64", "_binascii"]], "bisect": [".py", "''\n\ndef insort_right(a,x,lo=0,hi=None ):\n ''\n\n\n\n\n\n \n \n if lo <0:\n  raise ValueError('lo must be non-negative')\n if hi is None :\n  hi=len(a)\n while lo <hi:\n  mid=(lo+hi)//2\n  if x <a[mid]:hi=mid\n  else :lo=mid+1\n a.insert(lo,x)\n \ndef bisect_right(a,x,lo=0,hi=None ):\n ''\n\n\n\n\n\n\n\n \n \n if lo <0:\n  raise ValueError('lo must be non-negative')\n if hi is None :\n  hi=len(a)\n while lo <hi:\n  mid=(lo+hi)//2\n  if x <a[mid]:hi=mid\n  else :lo=mid+1\n return lo\n \ndef insort_left(a,x,lo=0,hi=None ):\n ''\n\n\n\n\n\n \n \n if lo <0:\n  raise ValueError('lo must be non-negative')\n if hi is None :\n  hi=len(a)\n while lo <hi:\n  mid=(lo+hi)//2\n  if a[mid]<x:lo=mid+1\n  else :hi=mid\n a.insert(lo,x)\n \n \ndef bisect_left(a,x,lo=0,hi=None ):\n ''\n\n\n\n\n\n\n\n \n \n if lo <0:\n  raise ValueError('lo must be non-negative')\n if hi is None :\n  hi=len(a)\n while lo <hi:\n  mid=(lo+hi)//2\n  if a[mid]<x:lo=mid+1\n  else :hi=mid\n return lo\n \n \ntry :\n from _bisect import *\nexcept ImportError:\n pass\n \n \nbisect=bisect_right\ninsort=insort_right\n", ["_bisect"]], "calendar": [".py", "''\n\n\n\n\n\n\nimport sys\nimport datetime\nimport locale as _locale\nfrom itertools import repeat\n\n__all__=[\"IllegalMonthError\",\"IllegalWeekdayError\",\"setfirstweekday\",\n\"firstweekday\",\"isleap\",\"leapdays\",\"weekday\",\"monthrange\",\n\"monthcalendar\",\"prmonth\",\"month\",\"prcal\",\"calendar\",\n\"timegm\",\"month_name\",\"month_abbr\",\"day_name\",\"day_abbr\",\n\"Calendar\",\"TextCalendar\",\"HTMLCalendar\",\"LocaleTextCalendar\",\n\"LocaleHTMLCalendar\",\"weekheader\"]\n\n\nerror=ValueError\n\n\nclass IllegalMonthError(ValueError):\n def __init__(self,month):\n  self.month=month\n def __str__(self):\n  return \"bad month number %r; must be 1-12\"%self.month\n  \n  \nclass IllegalWeekdayError(ValueError):\n def __init__(self,weekday):\n  self.weekday=weekday\n def __str__(self):\n  return \"bad weekday number %r; must be 0 (Monday) to 6 (Sunday)\"%self.weekday\n  \n  \n  \nJanuary=1\nFebruary=2\n\n\nmdays=[0,31,28,31,30,31,30,31,31,30,31,30,31]\n\n\n\n\n\n\nclass _localized_month:\n\n _months=[datetime.date(2001,i+1,1).strftime for i in range(12)]\n _months.insert(0,lambda x:\"\")\n \n def __init__(self,format):\n  self.format=format\n  \n def __getitem__(self,i):\n  funcs=self._months[i]\n  if isinstance(i,slice):\n   return [f(self.format)for f in funcs]\n  else :\n   return funcs(self.format)\n   \n def __len__(self):\n  return 13\n  \n  \nclass _localized_day:\n\n\n _days=[datetime.date(2001,1,i+1).strftime for i in range(7)]\n \n def __init__(self,format):\n  self.format=format\n  \n def __getitem__(self,i):\n  funcs=self._days[i]\n  if isinstance(i,slice):\n   return [f(self.format)for f in funcs]\n  else :\n   return funcs(self.format)\n   \n def __len__(self):\n  return 7\n  \n  \n  \nday_name=_localized_day('%A')\nday_abbr=_localized_day('%a')\n\n\nmonth_name=_localized_month('%B')\nmonth_abbr=_localized_month('%b')\n\n\n(MONDAY,TUESDAY,WEDNESDAY,THURSDAY,FRIDAY,SATURDAY,SUNDAY)=range(7)\n\n\ndef isleap(year):\n ''\n return year %4 ==0 and (year %100 !=0 or year %400 ==0)\n \n \ndef leapdays(y1,y2):\n ''\n \n y1 -=1\n y2 -=1\n return (y2 //4 -y1 //4)-(y2 //100 -y1 //100)+(y2 //400 -y1 //400)\n \n \ndef weekday(year,month,day):\n ''\n if not datetime.MINYEAR <=year <=datetime.MAXYEAR:\n  year=2000+year %400\n return datetime.date(year,month,day).weekday()\n \n \ndef monthrange(year,month):\n ''\n \n if not 1 <=month <=12:\n  raise IllegalMonthError(month)\n day1=weekday(year,month,1)\n ndays=mdays[month]+(month ==February and isleap(year))\n return day1,ndays\n \n \ndef monthlen(year,month):\n return mdays[month]+(month ==February and isleap(year))\n \n \ndef prevmonth(year,month):\n if month ==1:\n  return year -1,12\n else :\n  return year,month -1\n  \n  \ndef nextmonth(year,month):\n if month ==12:\n  return year+1,1\n else :\n  return year,month+1\n  \n  \nclass Calendar(object):\n ''\n\n\n \n \n def __init__(self,firstweekday=0):\n  self.firstweekday=firstweekday\n  \n def getfirstweekday(self):\n  return self._firstweekday %7\n  \n def setfirstweekday(self,firstweekday):\n  self._firstweekday=firstweekday\n  \n firstweekday=property(getfirstweekday,setfirstweekday)\n \n def iterweekdays(self):\n  ''\n\n\n  \n  for i in range(self.firstweekday,self.firstweekday+7):\n   yield i %7\n   \n def itermonthdates(self,year,month):\n  ''\n\n\n\n  \n  for y,m,d in self.itermonthdays3(year,month):\n   yield datetime.date(y,m,d)\n   \n def itermonthdays(self,year,month):\n  ''\n\n\n  \n  day1,ndays=monthrange(year,month)\n  days_before=(day1 -self.firstweekday)%7\n  yield from repeat(0,days_before)\n  yield from range(1,ndays+1)\n  days_after=(self.firstweekday -day1 -ndays)%7\n  yield from repeat(0,days_after)\n  \n def itermonthdays2(self,year,month):\n  ''\n\n\n  \n  for i,d in enumerate(self.itermonthdays(year,month),self.firstweekday):\n   yield d,i %7\n   \n def itermonthdays3(self,year,month):\n  ''\n\n\n  \n  day1,ndays=monthrange(year,month)\n  days_before=(day1 -self.firstweekday)%7\n  days_after=(self.firstweekday -day1 -ndays)%7\n  y,m=prevmonth(year,month)\n  end=monthlen(y,m)+1\n  for d in range(end -days_before,end):\n   yield y,m,d\n  for d in range(1,ndays+1):\n   yield year,month,d\n  y,m=nextmonth(year,month)\n  for d in range(1,days_after+1):\n   yield y,m,d\n   \n def itermonthdays4(self,year,month):\n  ''\n\n\n  \n  for i,(y,m,d)in enumerate(self.itermonthdays3(year,month)):\n   yield y,m,d,(self.firstweekday+i)%7\n   \n def monthdatescalendar(self,year,month):\n  ''\n\n\n  \n  dates=list(self.itermonthdates(year,month))\n  return [dates[i:i+7]for i in range(0,len(dates),7)]\n  \n def monthdays2calendar(self,year,month):\n  ''\n\n\n\n\n  \n  days=list(self.itermonthdays2(year,month))\n  return [days[i:i+7]for i in range(0,len(days),7)]\n  \n def monthdayscalendar(self,year,month):\n  ''\n\n\n  \n  days=list(self.itermonthdays(year,month))\n  return [days[i:i+7]for i in range(0,len(days),7)]\n  \n def yeardatescalendar(self,year,width=3):\n  ''\n\n\n\n\n  \n  months=[\n  self.monthdatescalendar(year,i)\n  for i in range(January,January+12)\n  ]\n  return [months[i:i+width]for i in range(0,len(months),width)]\n  \n def yeardays2calendar(self,year,width=3):\n  ''\n\n\n\n\n  \n  months=[\n  self.monthdays2calendar(year,i)\n  for i in range(January,January+12)\n  ]\n  return [months[i:i+width]for i in range(0,len(months),width)]\n  \n def yeardayscalendar(self,year,width=3):\n  ''\n\n\n\n  \n  months=[\n  self.monthdayscalendar(year,i)\n  for i in range(January,January+12)\n  ]\n  return [months[i:i+width]for i in range(0,len(months),width)]\n  \n  \nclass TextCalendar(Calendar):\n ''\n\n\n \n \n def prweek(self,theweek,width):\n  ''\n\n  \n  print(self.formatweek(theweek,width),end='')\n  \n def formatday(self,day,weekday,width):\n  ''\n\n  \n  if day ==0:\n   s=''\n  else :\n   s='%2i'%day\n  return s.center(width)\n  \n def formatweek(self,theweek,width):\n  ''\n\n  \n  return ' '.join(self.formatday(d,wd,width)for (d,wd)in theweek)\n  \n def formatweekday(self,day,width):\n  ''\n\n  \n  if width >=9:\n   names=day_name\n  else :\n   names=day_abbr\n  return names[day][:width].center(width)\n  \n def formatweekheader(self,width):\n  ''\n\n  \n  return ' '.join(self.formatweekday(i,width)for i in self.iterweekdays())\n  \n def formatmonthname(self,theyear,themonth,width,withyear=True ):\n  ''\n\n  \n  s=month_name[themonth]\n  if withyear:\n   s=\"%s %r\"%(s,theyear)\n  return s.center(width)\n  \n def prmonth(self,theyear,themonth,w=0,l=0):\n  ''\n\n  \n  print(self.formatmonth(theyear,themonth,w,l),end='')\n  \n def formatmonth(self,theyear,themonth,w=0,l=0):\n  ''\n\n  \n  w=max(2,w)\n  l=max(1,l)\n  s=self.formatmonthname(theyear,themonth,7 *(w+1)-1)\n  s=s.rstrip()\n  s +='\\n'*l\n  s +=self.formatweekheader(w).rstrip()\n  s +='\\n'*l\n  for week in self.monthdays2calendar(theyear,themonth):\n   s +=self.formatweek(week,w).rstrip()\n   s +='\\n'*l\n  return s\n  \n def formatyear(self,theyear,w=2,l=1,c=6,m=3):\n  ''\n\n  \n  w=max(2,w)\n  l=max(1,l)\n  c=max(2,c)\n  colwidth=(w+1)*7 -1\n  v=[]\n  a=v.append\n  a(repr(theyear).center(colwidth *m+c *(m -1)).rstrip())\n  a('\\n'*l)\n  header=self.formatweekheader(w)\n  for (i,row)in enumerate(self.yeardays2calendar(theyear,m)):\n  \n   months=range(m *i+1,min(m *(i+1)+1,13))\n   a('\\n'*l)\n   names=(self.formatmonthname(theyear,k,colwidth,False )\n   for k in months)\n   a(formatstring(names,colwidth,c).rstrip())\n   a('\\n'*l)\n   headers=(header for k in months)\n   a(formatstring(headers,colwidth,c).rstrip())\n   a('\\n'*l)\n   \n   height=max(len(cal)for cal in row)\n   for j in range(height):\n    weeks=[]\n    for cal in row:\n     if j >=len(cal):\n      weeks.append('')\n     else :\n      weeks.append(self.formatweek(cal[j],w))\n    a(formatstring(weeks,colwidth,c).rstrip())\n    a('\\n'*l)\n  return ''.join(v)\n  \n def pryear(self,theyear,w=0,l=0,c=6,m=3):\n  ''\n  print(self.formatyear(theyear,w,l,c,m),end='')\n  \n  \nclass HTMLCalendar(Calendar):\n ''\n\n \n \n \n cssclasses=[\"mon\",\"tue\",\"wed\",\"thu\",\"fri\",\"sat\",\"sun\"]\n \n \n cssclasses_weekday_head=cssclasses\n \n \n cssclass_noday=\"noday\"\n \n \n cssclass_month_head=\"month\"\n \n \n cssclass_month=\"month\"\n \n \n cssclass_year_head=\"year\"\n \n \n cssclass_year=\"year\"\n \n def formatday(self,day,weekday):\n  ''\n\n  \n  if day ==0:\n  \n   return '<td class=\"%s\">&nbsp;</td>'%self.cssclass_noday\n  else :\n   return '<td class=\"%s\">%d</td>'%(self.cssclasses[weekday],day)\n   \n def formatweek(self,theweek):\n  ''\n\n  \n  s=''.join(self.formatday(d,wd)for (d,wd)in theweek)\n  return '<tr>%s</tr>'%s\n  \n def formatweekday(self,day):\n  ''\n\n  \n  return '<th class=\"%s\">%s</th>'%(\n  self.cssclasses_weekday_head[day],day_abbr[day])\n  \n def formatweekheader(self):\n  ''\n\n  \n  s=''.join(self.formatweekday(i)for i in self.iterweekdays())\n  return '<tr>%s</tr>'%s\n  \n def formatmonthname(self,theyear,themonth,withyear=True ):\n  ''\n\n  \n  if withyear:\n   s='%s %s'%(month_name[themonth],theyear)\n  else :\n   s='%s'%month_name[themonth]\n  return '<tr><th colspan=\"7\" class=\"%s\">%s</th></tr>'%(\n  self.cssclass_month_head,s)\n  \n def formatmonth(self,theyear,themonth,withyear=True ):\n  ''\n\n  \n  v=[]\n  a=v.append\n  a('<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"%s\">'%(\n  self.cssclass_month))\n  a('\\n')\n  a(self.formatmonthname(theyear,themonth,withyear=withyear))\n  a('\\n')\n  a(self.formatweekheader())\n  a('\\n')\n  for week in self.monthdays2calendar(theyear,themonth):\n   a(self.formatweek(week))\n   a('\\n')\n  a('</table>')\n  a('\\n')\n  return ''.join(v)\n  \n def formatyear(self,theyear,width=3):\n  ''\n\n  \n  v=[]\n  a=v.append\n  width=max(width,1)\n  a('<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"%s\">'%\n  self.cssclass_year)\n  a('\\n')\n  a('<tr><th colspan=\"%d\" class=\"%s\">%s</th></tr>'%(\n  width,self.cssclass_year_head,theyear))\n  for i in range(January,January+12,width):\n  \n   months=range(i,min(i+width,13))\n   a('<tr>')\n   for m in months:\n    a('<td>')\n    a(self.formatmonth(theyear,m,withyear=False ))\n    a('</td>')\n   a('</tr>')\n  a('</table>')\n  return ''.join(v)\n  \n def formatyearpage(self,theyear,width=3,css='calendar.css',encoding=None ):\n  ''\n\n  \n  if encoding is None :\n   encoding=sys.getdefaultencoding()\n  v=[]\n  a=v.append\n  a('<?xml version=\"1.0\" encoding=\"%s\"?>\\n'%encoding)\n  a('<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\\n')\n  a('<html>\\n')\n  a('<head>\\n')\n  a('<meta http-equiv=\"Content-Type\" content=\"text/html; charset=%s\" />\\n'%encoding)\n  if css is not None :\n   a('<link rel=\"stylesheet\" type=\"text/css\" href=\"%s\" />\\n'%css)\n  a('<title>Calendar for %d</title>\\n'%theyear)\n  a('</head>\\n')\n  a('<body>\\n')\n  a(self.formatyear(theyear,width))\n  a('</body>\\n')\n  a('</html>\\n')\n  return ''.join(v).encode(encoding,\"xmlcharrefreplace\")\n  \n  \nclass different_locale:\n def __init__(self,locale):\n  self.locale=locale\n  \n def __enter__(self):\n  self.oldlocale=_locale.getlocale(_locale.LC_TIME)\n  _locale.setlocale(_locale.LC_TIME,self.locale)\n  \n def __exit__(self,*args):\n  _locale.setlocale(_locale.LC_TIME,self.oldlocale)\n  \n  \nclass LocaleTextCalendar(TextCalendar):\n ''\n\n\n\n\n \n \n def __init__(self,firstweekday=0,locale=None ):\n  TextCalendar.__init__(self,firstweekday)\n  if locale is None :\n   locale=_locale.getdefaultlocale()\n  self.locale=locale\n  \n def formatweekday(self,day,width):\n  with different_locale(self.locale):\n   if width >=9:\n    names=day_name\n   else :\n    names=day_abbr\n   name=names[day]\n   return name[:width].center(width)\n   \n def formatmonthname(self,theyear,themonth,width,withyear=True ):\n  with different_locale(self.locale):\n   s=month_name[themonth]\n   if withyear:\n    s=\"%s %r\"%(s,theyear)\n   return s.center(width)\n   \n   \nclass LocaleHTMLCalendar(HTMLCalendar):\n ''\n\n\n\n\n \n def __init__(self,firstweekday=0,locale=None ):\n  HTMLCalendar.__init__(self,firstweekday)\n  if locale is None :\n   locale=_locale.getdefaultlocale()\n  self.locale=locale\n  \n def formatweekday(self,day):\n  with different_locale(self.locale):\n   s=day_abbr[day]\n   return '<th class=\"%s\">%s</th>'%(self.cssclasses[day],s)\n   \n def formatmonthname(self,theyear,themonth,withyear=True ):\n  with different_locale(self.locale):\n   s=month_name[themonth]\n   if withyear:\n    s='%s %s'%(s,theyear)\n   return '<tr><th colspan=\"7\" class=\"month\">%s</th></tr>'%s\n   \n   \n   \nc=TextCalendar()\n\nfirstweekday=c.getfirstweekday\n\ndef setfirstweekday(firstweekday):\n if not MONDAY <=firstweekday <=SUNDAY:\n  raise IllegalWeekdayError(firstweekday)\n c.firstweekday=firstweekday\n \nmonthcalendar=c.monthdayscalendar\nprweek=c.prweek\nweek=c.formatweek\nweekheader=c.formatweekheader\nprmonth=c.prmonth\nmonth=c.formatmonth\ncalendar=c.formatyear\nprcal=c.pryear\n\n\n\n_colwidth=7 *3 -1\n_spacing=6\n\n\ndef format(cols,colwidth=_colwidth,spacing=_spacing):\n ''\n print(formatstring(cols,colwidth,spacing))\n \n \ndef formatstring(cols,colwidth=_colwidth,spacing=_spacing):\n ''\n spacing *=' '\n return spacing.join(c.center(colwidth)for c in cols)\n \n \nEPOCH=1970\n_EPOCH_ORD=datetime.date(EPOCH,1,1).toordinal()\n\n\ndef timegm(tuple):\n ''\n year,month,day,hour,minute,second=tuple[:6]\n days=datetime.date(year,month,1).toordinal()-_EPOCH_ORD+day -1\n hours=days *24+hour\n minutes=hours *60+minute\n seconds=minutes *60+second\n return seconds\n \n \ndef main(args):\n import argparse\n parser=argparse.ArgumentParser()\n textgroup=parser.add_argument_group('text only arguments')\n htmlgroup=parser.add_argument_group('html only arguments')\n textgroup.add_argument(\n \"-w\",\"--width\",\n type=int,default=2,\n help=\"width of date column (default 2)\"\n )\n textgroup.add_argument(\n \"-l\",\"--lines\",\n type=int,default=1,\n help=\"number of lines for each week (default 1)\"\n )\n textgroup.add_argument(\n \"-s\",\"--spacing\",\n type=int,default=6,\n help=\"spacing between months (default 6)\"\n )\n textgroup.add_argument(\n \"-m\",\"--months\",\n type=int,default=3,\n help=\"months per row (default 3)\"\n )\n htmlgroup.add_argument(\n \"-c\",\"--css\",\n default=\"calendar.css\",\n help=\"CSS to use for page\"\n )\n parser.add_argument(\n \"-L\",\"--locale\",\n default=None ,\n help=\"locale to be used from month and weekday names\"\n )\n parser.add_argument(\n \"-e\",\"--encoding\",\n default=None ,\n help=\"encoding to use for output\"\n )\n parser.add_argument(\n \"-t\",\"--type\",\n default=\"text\",\n choices=(\"text\",\"html\"),\n help=\"output type (text or html)\"\n )\n parser.add_argument(\n \"year\",\n nargs='?',type=int,\n help=\"year number (1-9999)\"\n )\n parser.add_argument(\n \"month\",\n nargs='?',type=int,\n help=\"month number (1-12, text only)\"\n )\n \n options=parser.parse_args(args[1:])\n \n if options.locale and not options.encoding:\n  parser.error(\"if --locale is specified --encoding is required\")\n  sys.exit(1)\n  \n locale=options.locale,options.encoding\n \n if options.type ==\"html\":\n  if options.locale:\n   cal=LocaleHTMLCalendar(locale=locale)\n  else :\n   cal=HTMLCalendar()\n  encoding=options.encoding\n  if encoding is None :\n   encoding=sys.getdefaultencoding()\n  optdict=dict(encoding=encoding,css=options.css)\n  write=sys.stdout.buffer.write\n  if options.year is None :\n   write(cal.formatyearpage(datetime.date.today().year,**optdict))\n  elif options.month is None :\n   write(cal.formatyearpage(options.year,**optdict))\n  else :\n   parser.error(\"incorrect number of arguments\")\n   sys.exit(1)\n else :\n  if options.locale:\n   cal=LocaleTextCalendar(locale=locale)\n  else :\n   cal=TextCalendar()\n  optdict=dict(w=options.width,l=options.lines)\n  if options.month is None :\n   optdict[\"c\"]=options.spacing\n   optdict[\"m\"]=options.months\n  if options.year is None :\n   result=cal.formatyear(datetime.date.today().year,**optdict)\n  elif options.month is None :\n   result=cal.formatyear(options.year,**optdict)\n  else :\n   result=cal.formatmonth(options.year,options.month,**optdict)\n  write=sys.stdout.write\n  if options.encoding:\n   result=result.encode(options.encoding)\n   write=sys.stdout.buffer.write\n  write(result)\n  \n  \nif __name__ ==\"__main__\":\n main(sys.argv)\n", ["argparse", "datetime", "itertools", "locale", "sys"]], "cmath": [".py", "\n\n\n\n\n\n\n\n\n\nimport math\nimport sys\n\ndef takes_complex(func):\n def decorated(x):\n  if isinstance(x,complex):\n   return func(x)\n  elif type(x)in [int,float]:\n   return func(complex(x))\n  elif hasattr(x,'__complex__'):\n   c=x.__complex__()\n   if not isinstance(c,complex):\n    raise TypeError(\"A complex number is required\")\n   else :\n    return func(c)\n  elif hasattr(x,'__float__'):\n   try :\n    c=complex(x.__float__(),0)\n   except :\n    raise TypeError(\"A complex number is required\")\n   return func(c)\n  else :\n   raise TypeError(\"A complex number is required\")\n if hasattr(func,'__doc__'):\n  decorated.__doc__=func.__doc__\n if hasattr(func,'__name__'):\n  decorated.__name__=func.__name__\n return decorated\n \n@takes_complex\ndef isfinite(x):\n return math.isfinite(x.imag)and math.isfinite(x.real)\n \n@takes_complex\ndef phase(x):\n ''\n return math.atan2(x.imag,x.real)\n \n@takes_complex\ndef polar(x):\n ''\n\n\n\n\n \n phi=math.atan2(x.imag,x.real)\n r=math.sqrt(x.real **2+x.imag **2)\n return r,phi\n \ndef rect(r,phi):\n ''\n\n \n if math.isinf(r)or math.isinf(phi):\n \n \n  if math.isinf(phi)and r !=.0 and not math.isnan(r):\n   raise ValueError(\"math domain error\")\n   \n   \n   \n   \n  if -_INF <phi <_INF and phi !=.0:\n   if r >0:\n    _real=math.copysign(_INF,math.cos(phi))\n    _imag=math.copysign(_INF,math.sin(phi))\n   else :\n    _real=-math.copysign(_INF,cos(phi));\n    _imag=-math.copysign(_INF,sin(phi));\n   return complex(_real,_imag)\n  return _SPECIAL_VALUE(complex(r,phi),_rect_special_values)\n  \n else :\n  if phi ==.0:\n  \n  \n  \n   return complex(r,phi *r)\n  else :\n   return complex(r *math.cos(phi),r *math.sin(phi))\n   \n@takes_complex\ndef sqrt(x):\n ''\n\n\n\n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n s,d,ax,ay=.0,.0,math.fabs(x.real),math.fabs(x.imag)\n \n ret=_SPECIAL_VALUE(x,_sqrt_special_values)\n if ret is not None :\n  return ret\n  \n if x.real ==.0 and x.imag ==.0:\n  _real=.0\n  _imag=x.imag\n  return complex(_real,_imag)\n  \n if ax <sys.float_info.min and ay <sys.float_info.min and (ax >0. or ay >0.):\n \n  ax=math.ldexp(ax,_CM_SCALE_UP);\n  s=math.ldexp(math.sqrt(ax+math.hypot(ax,math.ldexp(ay,_CM_SCALE_UP))),_CM_SCALE_DOWN)\n else :\n  ax /=8.0 ;\n  s=2.0 *math.sqrt(ax+math.hypot(ax,ay /8.0));\n  \n d=ay /(2.0 *s)\n \n if x.real >=.0:\n  _real=s ;\n  _imag=math.copysign(d,x.imag)\n else :\n  _real=d ;\n  _imag=math.copysign(s,x.imag)\n  \n return complex(_real,_imag)\n \n@takes_complex\ndef acos(x):\n ''\n\n\n\n\n \n \n ret=_SPECIAL_VALUE(x,_acos_special_values)\n if ret is not None :\n  return ret\n  \n if math.fabs(x.real)>_CM_LARGE_DOUBLE or math.fabs(x.imag)>_CM_LARGE_DOUBLE:\n \n \n  _real=math.atan2(math.fabs(x.imag),x.real)\n  \n  \n  \n  if x.real <0:\n   _imag=-math.copysign(math.log(math.hypot(x.real /2.,x.imag /2.))+_M_LN2 *2.,x.imag);\n  else :\n   _imag=math.copysign(math.log(math.hypot(x.real /2.,x.imag /2.))+_M_LN2 *2.,-x.imag);\n else :\n  s1=complex(float(1 -x.real),-x.imag)\n  s1=sqrt(s1)\n  s2=complex(1.0+x.real,x.imag)\n  s2=sqrt(s2)\n  _real=2.0 *math.atan2(s1.real,s2.real);\n  _imag=math.asinh(s2.real *s1.imag -s2.imag *s1.real)\n  \n return complex(_real,_imag)\n \n@takes_complex\ndef acosh(x):\n ''\n\n\n\n \n ret=_SPECIAL_VALUE(x,_acosh_special_values)\n if ret is not None :\n  return ret\n  \n if math.fabs(x.real)>_CM_LARGE_DOUBLE or math.fabs(x.imag)>_CM_LARGE_DOUBLE:\n \n  _real=math.log(math.hypot(x.real /2.0,x.imag /2.0))+_M_LN2 *2.0\n  _imag=math.atan2(x.imag,x.real);\n else :\n  s1=sqrt(complex(x.real -1.0,x.imag))\n  s2=sqrt(complex(x.real+1.0,x.imag))\n  _real=math.asinh(s1.real *s2.real+s1.imag *s2.imag)\n  _imag=2. *math.atan2(s1.imag,s2.real)\n  \n return complex(_real,_imag)\n \n@takes_complex\ndef asin(x):\n ''\n\n\n\n \n \n s=complex(-x.imag,x.real)\n s=asinh(s)\n return complex(s.imag,-s.real)\n \n@takes_complex\ndef asinh(x):\n ''\n\n\n\n\n \n ret=_SPECIAL_VALUE(x,_asinh_special_values)\n if ret is not None :\n  return ret\n  \n if math.fabs(x.real)>_CM_LARGE_DOUBLE or math.fabs(x.imag)>_CM_LARGE_DOUBLE:\n  if x.imag >=.0:\n   _real=math.copysign(math.log(math.hypot(x.real /2.,x.imag /2.))+_M_LN2 *2.,x.real)\n  else :\n   _real=-math.copysign(math.log(math.hypot(x.real /2.,x.imag /2.))+_M_LN2 *2.,-x.real)\n  _imag=math.atan2(x.imag,math.fabs(x.real))\n else :\n  s1=sqrt(complex(1.0+x.imag,-x.real))\n  s2=sqrt(complex(1.0 -x.imag,x.real))\n  _real=math.asinh(s1.real *s2.imag -s2.real *s1.imag)\n  _imag=math.atan2(x.imag,s1.real *s2.real -s1.imag *s2.imag)\n return complex(_real,_imag)\n \n@takes_complex\ndef atan(x):\n ''\n\n\n\n\n \n s=atanh(complex(-x.imag,x.real))\n return complex(s.imag,-s.real)\n \n@takes_complex\ndef atanh(x):\n ''\n\n\n\n\n \n \n ret=_SPECIAL_VALUE(x,_atanh_special_values)\n if ret is not None :\n  return ret\n  \n  \n if x.real <.0:\n  return -(atanh(-x))\n  \n ay=math.fabs(x.imag)\n \n if x.real >_CM_SQRT_LARGE_DOUBLE or ay >_CM_SQRT_LARGE_DOUBLE:\n \n \n \n \n \n  h=math.hypot(x.real /2.,x.imag /2.)\n  _real=x.real /4. /h /h\n  \n  \n  \n  \n  \n  \n  _imag=-math.copysign(math.pi /2.,-x.imag)\n  \n elif x.real ==1.0 and ay <_CM_SQRT_DBL_MIN:\n \n \n  if (ay ==.0):\n   raise ValueError(\"math domain error\")\n  else :\n   _real=-math.log(math.sqrt(ay)/math.sqrt(math.hypot(ay,2.)))\n   _imag=math.copysign(math.atan2(2.0,-ay)/2,x.imag)\n   \n else :\n \n  _real=math.log1p(4. *x.real /((1 -x.real)*(1 -x.real)+ay *ay))/4.\n  _imag=-math.atan2(-2. *x.imag,(1 -x.real)*(1+x.real)-ay *ay)/2.\n  errno=0\n  \n return complex(_real,_imag)\n \n@takes_complex\ndef cos(x):\n ''\n return cosh(complex(-x.imag,x.real))\n \n@takes_complex\ndef cosh(x):\n ''\n \n \n if isinf(x):\n  if -_INF <x.imag <_INF and x.imag !=.0:\n   if x.real >0:\n    _real=math.copysign(_INF,math.cos(x.imag))\n    _imag=math.copysign(_INF,math.sin(x.imag))\n   else :\n    _real=math.copysign(_INF,math.cos(x.imag))\n    _imag=-math.copysign(_INF,math.sin(x.imag))\n   return complex(_real,_imag)\n  else :\n  \n   if x.imag !=.0 and not math.isnan(x.real):\n    raise ValueError(\"math domain error\")\n   return _SPECIAL_VALUE(x,_cosh_special_values)\n   \n if math.fabs(x.real)>_CM_LOG_LARGE_DOUBLE:\n \n \n  x_minus_one=x.real -math.copysign(1.0,x.real)\n  _real=cos(x.imag)*math.cosh(x_minus_one)*math.e\n  _imag=sin(x.imag)*math.sinh(x_minus_one)*math.e\n else :\n  _real=math.cos(x.imag)*math.cosh(x.real)\n  _imag=math.sin(x.imag)*math.sinh(x.real)\n  \n ret=complex(_real,_imag)\n \n if isinf(ret):\n  raise OverflowError()\n return ret\n \n@takes_complex\ndef exp(x):\n ''\n if math.isinf(x.real)or math.isinf(x.imag):\n \n  if math.isinf(x.imag)and (-_INF <x.real <_INF or math.isinf(x.real)and x.real >0):\n   raise ValueError(\"math domain error\")\n   \n  if math.isinf(x.real)and -_INF <x.imag <_INF and x.imag !=.0:\n   if x.real >0:\n    _real=math.copysign(_INF,cos(x.imag))\n    _imag=math.copysign(_INF,sin(x.imag))\n   else :\n    _real=math.copysign(.0,cos(x.imag))\n    _imag=math.copysign(.0,sin(x.imag))\n   return complex(_real,_imag)\n   \n  return _SPECIAL_VALUE(x,_exp_special_values)\n  \n  \n if x.real >_CM_LOG_LARGE_DOUBLE:\n  l=math.exp(x.real -1.);\n  _real=l *math.cos(x.imag)*math.e\n  _imag=l *math.sin(x.imag)*math.e\n else :\n  l=math.exp(x.real);\n  _real=l *math.cos(x.imag)\n  _imag=l *math.sin(x.imag)\n  \n if math.isinf(_real)or math.isinf(_imag):\n  raise OverflowError()\n  \n return complex(_real,_imag)\n \ndef isclose(x,y,*,rel_tol=1e-09,abs_tol=0.0):\n rel_tol=float(rel_tol)\n abs_tol=float(abs_tol)\n return abs(x -y)<=max(rel_tol *max(abs(x),abs(y)),abs_tol)\n \n@takes_complex\ndef isinf(x):\n ''\n return math.isinf(x.real)or math.isinf(x.imag)\n \n@takes_complex\ndef isnan(x):\n ''\n return math.isnan(x.real)or math.isnan(x.imag)\n \n \n@takes_complex\ndef _to_complex(x):\n return x\n \ndef log(x,base=None ):\n ''\n\n\n\n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n x=_to_complex(x)\n \n \n \n \n \n \n if base is not None :\n  x=log(x)\n  base=log(base)\n  x=x /base\n  \n ret=_SPECIAL_VALUE(x,_log_special_values)\n if ret is not None :\n  return ret\n  \n ax=math.fabs(x.real)\n ay=math.fabs(x.imag)\n \n if ax >_CM_LARGE_DOUBLE or ay >_CM_LARGE_DOUBLE:\n  _real=math.log(math.hypot(ax /2.0,ay /2.0))+_M_LN2\n elif ax <sys.float_info.min and ay <sys.float_info.min:\n  if ax >.0 or ay >.0:\n  \n   _real=math.log(math.hypot(math.ldexp(ax,sys.float_info.mant_dig),math.ldexp(ay,sys.float_info.mant_dig)))-sys.float_info.mant_dig *_M_LN2\n  else :\n  \n   raise ValueError(\"math domain error\")\n   _real=-_INF\n   _imag=math.atan2(x.imag,x.real)\n else :\n  h=math.hypot(ax,ay)\n  if 0.71 <=h and h <=1.73:\n   am=max(ax,ay)\n   an=min(ax,ay)\n   _real=math.log1p((am -1)*(am+1)+an *an)/2.\n  else :\n   _real=math.log(h)\n _imag=math.atan2(x.imag,x.real)\n return complex(_real,_imag)\n \n@takes_complex\ndef log10(x):\n ''\n\n\n\n \n ret=log(x);\n _real=ret.real /_M_LN10\n _imag=ret.imag /_M_LN10\n return complex(_real,_imag)\n \n@takes_complex\ndef sin(x):\n ''\n \n s=complex(-x.imag,x.real)\n s=sinh(s)\n return complex(s.imag,-s.real)\n \n@takes_complex\ndef sinh(x):\n ''\n \n if math.isinf(x.real)or math.isinf(x.imag):\n \n \n  if math.isinf(x.imag)and not math.isnan(x.real):\n   raise ValueError(\"math domain error\")\n   \n  if math.isinf(x.real)and -_INF <x.imag <_INF and x.imag !=.0:\n   if x.real >0:\n    _real=math.copysign(_INF,cos(x.imag))\n    _imag=math.copysign(_INF,sin(x.imag))\n   else :\n    _real=-math.copysign(_INF,cos(x.imag))\n    _imag=math.copysign(_INF,sin(x.imag))\n   return complex(_real,_imag)\n   \n  return _SPECIAL_VALUE(x,_sinh_special_values)\n  \n if math.fabs(x.real)>_CM_LOG_LARGE_DOUBLE:\n  x_minus_one=x.real -math.copysign(1.0,x.real)\n  _real=math.cos(x.imag)*math.sinh(x.imag)*math.e\n  _imag=math.sin(x.imag)*math.cosh(x.imag)*math.e\n else :\n  _real=math.cos(x.imag)*math.sinh(x.real)\n  _imag=math.sin(x.imag)*math.cosh(x.real)\n  \n if math.isinf(_real)or math.isinf(_imag):\n  raise OverflowError()\n  \n return complex(_real,_imag)\n \n@takes_complex\ndef tan(x):\n ''\n s=atanh(complex(-x.imag,x.real))\n return complex(s.imag,-s.real)\n \n@takes_complex\ndef tanh(x):\n ''\n ''\n\n\n \n \n \n \n \n \n \n \n \n \n \n if isinf(x):\n  if math.isinf(x.imag)and -_INF <x.real <_INF:\n   raise ValueError(\"math domain error\")\n   \n   \n  if math.isinf(x.real)and -_INF <x.imag <_INF and x.imag !=.0:\n   if x.real >0:\n    _real=1.0\n    _imag=math.copysign(.0,2.0 *math.sin(x.imag)*math.cos(x.imag))\n   else :\n    _real=-1.0\n    _imag=math.copysign(.0,2. *math.sin(x.imag)*math.cos(x.imag))\n   return complex(_real,_imag)\n  return _SPECIAL_VALUE(x,_tanh_special_values)\n  \n  \n if math.fabs(x.real)>_CM_LOG_LARGE_DOUBLE:\n  _real=math.copysign(1.,x.real)\n  _imag=4. *math.sin(x.imag)*math.cos(x.imag)*math.exp(-2. *math.fabs(x.real))\n else :\n  tx=math.tanh(x.real)\n  ty=math.tan(x.imag)\n  cx=1.0 /math.cosh(x.real)\n  txty=tx *ty\n  denom=1.+txty *txty\n  _real=tx *(1.+ty *ty)/denom\n  _imag=((ty /denom)*cx)*cx\n return complex(_real,_imag)\n \n \npi=math.pi\ne=math.e\n\n_CM_LARGE_DOUBLE=sys.float_info.max /4\n_CM_SQRT_LARGE_DOUBLE=math.sqrt(_CM_LARGE_DOUBLE)\n_CM_LOG_LARGE_DOUBLE=math.log(_CM_LARGE_DOUBLE)\n_CM_SQRT_DBL_MIN=math.sqrt(sys.float_info.min)\n_M_LN2=0.6931471805599453094\n_M_LN10=2.302585092994045684\n\nif sys.float_info.radix ==2:\n _CM_SCALE_UP=int((2 *(sys.float_info.mant_dig /2)+1))\nelif sys.float_info.radix ==16:\n _CM_SCALE_UP=int((4 *sys.float_info.mant_dig+1))\nelse :\n raise (\"cmath implementation expects the float base to be either 2 or 16, got \"+str(sys.float_info.radix)+\" instead.\")\n_CM_SCALE_DOWN=int((-(_CM_SCALE_UP+1)/2))\n\n_INF=float('inf')\n_NAN=float('nan')\n_PI=math.pi\n_P14=0.25 *math.pi\n_P12=0.5 *math.pi\n_P34=0.75 *math.pi\n_U=-9.5426319407711027e33\n\n\n_ST_NINF=0\n_ST_NEG=1\n_ST_NZERO=2\n_ST_PZERO=3\n_ST_POS=4\n_ST_PINF=5\n_ST_NAN=6\n\n\ndef _SPECIAL_VALUE(z,table):\n if not math.isfinite(z.real)or not math.isfinite(z.imag):\n  return table[_special_type(z.real)][_special_type(z.imag)]\n else :\n  return None\n  \ndef _special_type(x):\n if -_INF <x <_INF:\n  if x !=0:\n   if math.copysign(1.0,x)==1.0:\n    return _ST_POS\n   else :\n    return _ST_NEG\n  else :\n   if math.copysign(1.0,x)==1.0:\n    return _ST_PZERO\n   else :\n    return _ST_NZERO\n if math.isnan(x):\n  return _ST_NAN\n if math.copysign(1.0,x)==1.0:\n  return _ST_PINF\n else :\n  return _ST_NINF\n  \n_acos_special_values=[\n[complex(_P34,_INF),complex(_PI,_INF),complex(_PI,_INF),complex(_PI,-_INF),complex(_PI,-_INF),complex(_P34,-_INF),complex(_NAN,_INF)],\n[complex(_P12,_INF),complex(_U,_U),complex(_U,_U),complex(_U,_U),complex(_U,_U),complex(_P12,-_INF),complex(_NAN,_NAN)],\n[complex(_P12,_INF),complex(_U,_U),complex(_P12,0.),complex(_P12,-0.),complex(_U,_U),complex(_P12,-_INF),complex(_P12,_NAN)],\n[complex(_P12,_INF),complex(_U,_U),complex(_P12,0.),complex(_P12,-0.),complex(_U,_U),complex(_P12,-_INF),complex(_P12,_NAN)],\n[complex(_P12,_INF),complex(_U,_U),complex(_U,_U),complex(_U,_U),complex(_U,_U),complex(_P12,-_INF),complex(_NAN,_NAN)],\n[complex(_P14,_INF),complex(0.,_INF),complex(0.,_INF),complex(0.,-_INF),complex(0.,-_INF),complex(_P14,-_INF),complex(_NAN,_INF)],\n[complex(_NAN,_INF),complex(_NAN,_NAN),complex(_NAN,_NAN),complex(_NAN,_NAN),complex(_NAN,_NAN),complex(_NAN,-_INF),complex(_NAN,_NAN)],\n]\n\n_acosh_special_values=[\n[complex(_INF,-_P34),complex(_INF,-_PI),complex(_INF,-_PI),complex(_INF,_PI),complex(_INF,_PI),complex(_INF,_P34),complex(_INF,_NAN)],\n[complex(_INF,-_P12),complex(_U,_U),complex(_U,_U),complex(_U,_U),complex(_U,_U),complex(_INF,_P12),complex(_NAN,_NAN)],\n[complex(_INF,-_P12),complex(_U,_U),complex(0.,-_P12),complex(0.,_P12),complex(_U,_U),complex(_INF,_P12),complex(_NAN,_NAN)],\n[complex(_INF,-_P12),complex(_U,_U),complex(0.,-_P12),complex(0.,_P12),complex(_U,_U),complex(_INF,_P12),complex(_NAN,_NAN)],\n[complex(_INF,-_P12),complex(_U,_U),complex(_U,_U),complex(_U,_U),complex(_U,_U),complex(_INF,_P12),complex(_NAN,_NAN)],\n[complex(_INF,-_P14),complex(_INF,-0.),complex(_INF,-0.),complex(_INF,0.),complex(_INF,0.),complex(_INF,_P14),complex(_INF,_NAN)],\n[complex(_INF,_NAN),complex(_NAN,_NAN),complex(_NAN,_NAN),complex(_NAN,_NAN),complex(_NAN,_NAN),complex(_INF,_NAN),complex(_NAN,_NAN)],\n]\n\n_asinh_special_values=[\n[complex(-_INF,-_P14),complex(-_INF,-0.),complex(-_INF,-0.),complex(-_INF,0.),complex(-_INF,0.),complex(-_INF,_P14),complex(-_INF,_NAN)],\n[complex(-_INF,-_P12),complex(_U,_U),complex(_U,_U),complex(_U,_U),complex(_U,_U),complex(-_INF,_P12),complex(_NAN,_NAN)],\n[complex(-_INF,-_P12),complex(_U,_U),complex(-0.,-0.),complex(-0.,0.),complex(_U,_U),complex(-_INF,_P12),complex(_NAN,_NAN)],\n[complex(_INF,-_P12),complex(_U,_U),complex(0.,-0.),complex(0.,0.),complex(_U,_U),complex(_INF,_P12),complex(_NAN,_NAN)],\n[complex(_INF,-_P12),complex(_U,_U),complex(_U,_U),complex(_U,_U),complex(_U,_U),complex(_INF,_P12),complex(_NAN,_NAN)],\n[complex(_INF,-_P14),complex(_INF,-0.),complex(_INF,-0.),complex(_INF,0.),complex(_INF,0.),complex(_INF,_P14),complex(_INF,_NAN)],\n[complex(_INF,_NAN),complex(_NAN,_NAN),complex(_NAN,-0.),complex(_NAN,0.),complex(_NAN,_NAN),complex(_INF,_NAN),complex(_NAN,_NAN)],\n]\n\n_atanh_special_values=[\n[complex(-0.,-_P12),complex(-0.,-_P12),complex(-0.,-_P12),complex(-0.,_P12),complex(-0.,_P12),complex(-0.,_P12),complex(-0.,_NAN)],\n[complex(-0.,-_P12),complex(_U,_U),complex(_U,_U),complex(_U,_U),complex(_U,_U),complex(-0.,_P12),complex(_NAN,_NAN)],\n[complex(-0.,-_P12),complex(_U,_U),complex(-0.,-0.),complex(-0.,0.),complex(_U,_U),complex(-0.,_P12),complex(-0.,_NAN)],\n[complex(0.,-_P12),complex(_U,_U),complex(0.,-0.),complex(0.,0.),complex(_U,_U),complex(0.,_P12),complex(0.,_NAN)],\n[complex(0.,-_P12),complex(_U,_U),complex(_U,_U),complex(_U,_U),complex(_U,_U),complex(0.,_P12),complex(_NAN,_NAN)],\n[complex(0.,-_P12),complex(0.,-_P12),complex(0.,-_P12),complex(0.,_P12),complex(0.,_P12),complex(0.,_P12),complex(0.,_NAN)],\n[complex(0.,-_P12),complex(_NAN,_NAN),complex(_NAN,_NAN),complex(_NAN,_NAN),complex(_NAN,_NAN),complex(0.,_P12),complex(_NAN,_NAN)],\n]\n\n_cosh_special_values=[\n[complex(_INF,_NAN),complex(_U,_U),complex(_INF,0.),complex(_INF,-0.),complex(_U,_U),complex(_INF,_NAN),complex(_INF,_NAN)],\n[complex(_NAN,_NAN),complex(_U,_U),complex(_U,_U),complex(_U,_U),complex(_U,_U),complex(_NAN,_NAN),complex(_NAN,_NAN)],\n[complex(_NAN,0.),complex(_U,_U),complex(1.,0.),complex(1.,-0.),complex(_U,_U),complex(_NAN,0.),complex(_NAN,0.)],\n[complex(_NAN,0.),complex(_U,_U),complex(1.,-0.),complex(1.,0.),complex(_U,_U),complex(_NAN,0.),complex(_NAN,0.)],\n[complex(_NAN,_NAN),complex(_U,_U),complex(_U,_U),complex(_U,_U),complex(_U,_U),complex(_NAN,_NAN),complex(_NAN,_NAN)],\n[complex(_INF,_NAN),complex(_U,_U),complex(_INF,-0.),complex(_INF,0.),complex(_U,_U),complex(_INF,_NAN),complex(_INF,_NAN)],\n[complex(_NAN,_NAN),complex(_NAN,_NAN),complex(_NAN,0.),complex(_NAN,0.),complex(_NAN,_NAN),complex(_NAN,_NAN),complex(_NAN,_NAN)],\n]\n\n_exp_special_values=[\n[complex(0.,0.),complex(_U,_U),complex(0.,-0.),complex(0.,0.),complex(_U,_U),complex(0.,0.),complex(0.,0.)],\n[complex(_NAN,_NAN),complex(_U,_U),complex(_U,_U),complex(_U,_U),complex(_U,_U),complex(_NAN,_NAN),complex(_NAN,_NAN)],\n[complex(_NAN,_NAN),complex(_U,_U),complex(1.,-0.),complex(1.,0.),complex(_U,_U),complex(_NAN,_NAN),complex(_NAN,_NAN)],\n[complex(_NAN,_NAN),complex(_U,_U),complex(1.,-0.),complex(1.,0.),complex(_U,_U),complex(_NAN,_NAN),complex(_NAN,_NAN)],\n[complex(_NAN,_NAN),complex(_U,_U),complex(_U,_U),complex(_U,_U),complex(_U,_U),complex(_NAN,_NAN),complex(_NAN,_NAN)],\n[complex(_INF,_NAN),complex(_U,_U),complex(_INF,-0.),complex(_INF,0.),complex(_U,_U),complex(_INF,_NAN),complex(_INF,_NAN)],\n[complex(_NAN,_NAN),complex(_NAN,_NAN),complex(_NAN,-0.),complex(_NAN,0.),complex(_NAN,_NAN),complex(_NAN,_NAN),complex(_NAN,_NAN)],\n]\n\n_log_special_values=[\n[complex(_INF,-_P34),complex(_INF,-_PI),complex(_INF,-_PI),complex(_INF,_PI),complex(_INF,_PI),complex(_INF,_P34),complex(_INF,_NAN)],\n[complex(_INF,-_P12),complex(_U,_U),complex(_U,_U),complex(_U,_U),complex(_U,_U),complex(_INF,_P12),complex(_NAN,_NAN)],\n[complex(_INF,-_P12),complex(_U,_U),complex(-_INF,-_PI),complex(-_INF,_PI),complex(_U,_U),complex(_INF,_P12),complex(_NAN,_NAN)],\n[complex(_INF,-_P12),complex(_U,_U),complex(-_INF,-0.),complex(-_INF,0.),complex(_U,_U),complex(_INF,_P12),complex(_NAN,_NAN)],\n[complex(_INF,-_P12),complex(_U,_U),complex(_U,_U),complex(_U,_U),complex(_U,_U),complex(_INF,_P12),complex(_NAN,_NAN)],\n[complex(_INF,-_P14),complex(_INF,-0.),complex(_INF,-0.),complex(_INF,0.),complex(_INF,0.),complex(_INF,_P14),complex(_INF,_NAN)],\n[complex(_INF,_NAN),complex(_NAN,_NAN),complex(_NAN,_NAN),complex(_NAN,_NAN),complex(_NAN,_NAN),complex(_INF,_NAN),complex(_NAN,_NAN)],\n]\n\n_sinh_special_values=[\n[complex(_INF,_NAN),complex(_U,_U),complex(-_INF,-0.),complex(-_INF,0.),complex(_U,_U),complex(_INF,_NAN),complex(_INF,_NAN)],\n[complex(_NAN,_NAN),complex(_U,_U),complex(_U,_U),complex(_U,_U),complex(_U,_U),complex(_NAN,_NAN),complex(_NAN,_NAN)],\n[complex(0.,_NAN),complex(_U,_U),complex(-0.,-0.),complex(-0.,0.),complex(_U,_U),complex(0.,_NAN),complex(0.,_NAN)],\n[complex(0.,_NAN),complex(_U,_U),complex(0.,-0.),complex(0.,0.),complex(_U,_U),complex(0.,_NAN),complex(0.,_NAN)],\n[complex(_NAN,_NAN),complex(_U,_U),complex(_U,_U),complex(_U,_U),complex(_U,_U),complex(_NAN,_NAN),complex(_NAN,_NAN)],\n[complex(_INF,_NAN),complex(_U,_U),complex(_INF,-0.),complex(_INF,0.),complex(_U,_U),complex(_INF,_NAN),complex(_INF,_NAN)],\n[complex(_NAN,_NAN),complex(_NAN,_NAN),complex(_NAN,-0.),complex(_NAN,0.),complex(_NAN,_NAN),complex(_NAN,_NAN),complex(_NAN,_NAN)],\n]\n\n_sqrt_special_values=[\n[complex(_INF,-_INF),complex(0.,-_INF),complex(0.,-_INF),complex(0.,_INF),complex(0.,_INF),complex(_INF,_INF),complex(_NAN,_INF)],\n[complex(_INF,-_INF),complex(_U,_U),complex(_U,_U),complex(_U,_U),complex(_U,_U),complex(_INF,_INF),complex(_NAN,_NAN)],\n[complex(_INF,-_INF),complex(_U,_U),complex(0.,-0.),complex(0.,0.),complex(_U,_U),complex(_INF,_INF),complex(_NAN,_NAN)],\n[complex(_INF,-_INF),complex(_U,_U),complex(0.,-0.),complex(0.,0.),complex(_U,_U),complex(_INF,_INF),complex(_NAN,_NAN)],\n[complex(_INF,-_INF),complex(_U,_U),complex(_U,_U),complex(_U,_U),complex(_U,_U),complex(_INF,_INF),complex(_NAN,_NAN)],\n[complex(_INF,-_INF),complex(_INF,-0.),complex(_INF,-0.),complex(_INF,0.),complex(_INF,0.),complex(_INF,_INF),complex(_INF,_NAN)],\n[complex(_INF,-_INF),complex(_NAN,_NAN),complex(_NAN,_NAN),complex(_NAN,_NAN),complex(_NAN,_NAN),complex(_INF,_INF),complex(_NAN,_NAN)],\n]\n\n_tanh_special_values=[\n[complex(-1.,0.),complex(_U,_U),complex(-1.,-0.),complex(-1.,0.),complex(_U,_U),complex(-1.,0.),complex(-1.,0.)],\n[complex(_NAN,_NAN),complex(_U,_U),complex(_U,_U),complex(_U,_U),complex(_U,_U),complex(_NAN,_NAN),complex(_NAN,_NAN)],\n[complex(_NAN,_NAN),complex(_U,_U),complex(-0.,-0.),complex(-0.,0.),complex(_U,_U),complex(_NAN,_NAN),complex(_NAN,_NAN)],\n[complex(_NAN,_NAN),complex(_U,_U),complex(0.,-0.),complex(0.,0.),complex(_U,_U),complex(_NAN,_NAN),complex(_NAN,_NAN)],\n[complex(_NAN,_NAN),complex(_U,_U),complex(_U,_U),complex(_U,_U),complex(_U,_U),complex(_NAN,_NAN),complex(_NAN,_NAN)],\n[complex(1.,0.),complex(_U,_U),complex(1.,-0.),complex(1.,0.),complex(_U,_U),complex(1.,0.),complex(1.,0.)],\n[complex(_NAN,_NAN),complex(_NAN,_NAN),complex(_NAN,-0.),complex(_NAN,0.),complex(_NAN,_NAN),complex(_NAN,_NAN),complex(_NAN,_NAN)],\n]\n\n_rect_special_values=[\n[complex(_INF,_NAN),complex(_U,_U),complex(-_INF,0.),complex(-_INF,-0.),complex(_U,_U),complex(_INF,_NAN),complex(_INF,_NAN)],\n[complex(_NAN,_NAN),complex(_U,_U),complex(_U,_U),complex(_U,_U),complex(_U,_U),complex(_NAN,_NAN),complex(_NAN,_NAN)],\n[complex(0.,0.),complex(_U,_U),complex(-0.,0.),complex(-0.,-0.),complex(_U,_U),complex(0.,0.),complex(0.,0.)],\n[complex(0.,0.),complex(_U,_U),complex(0.,-0.),complex(0.,0.),complex(_U,_U),complex(0.,0.),complex(0.,0.)],\n[complex(_NAN,_NAN),complex(_U,_U),complex(_U,_U),complex(_U,_U),complex(_U,_U),complex(_NAN,_NAN),complex(_NAN,_NAN)],\n[complex(_INF,_NAN),complex(_U,_U),complex(_INF,-0.),complex(_INF,0.),complex(_U,_U),complex(_INF,_NAN),complex(_INF,_NAN)],\n[complex(_NAN,_NAN),complex(_NAN,_NAN),complex(_NAN,0.),complex(_NAN,0.),complex(_NAN,_NAN),complex(_NAN,_NAN),complex(_NAN,_NAN)],\n]\n", ["math", "sys"]], "cmd": [".py", "''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nimport string,sys\n\n__all__=[\"Cmd\"]\n\nPROMPT='(Cmd) '\nIDENTCHARS=string.ascii_letters+string.digits+'_'\n\nclass Cmd:\n ''\n\n\n\n\n\n\n\n\n\n \n prompt=PROMPT\n identchars=IDENTCHARS\n ruler='='\n lastcmd=''\n intro=None\n doc_leader=\"\"\n doc_header=\"Documented commands (type help <topic>):\"\n misc_header=\"Miscellaneous help topics:\"\n undoc_header=\"Undocumented commands:\"\n nohelp=\"*** No help on %s\"\n use_rawinput=1\n \n def __init__(self,completekey='tab',stdin=None ,stdout=None ):\n  ''\n\n\n\n\n\n\n\n\n  \n  if stdin is not None :\n   self.stdin=stdin\n  else :\n   self.stdin=sys.stdin\n  if stdout is not None :\n   self.stdout=stdout\n  else :\n   self.stdout=sys.stdout\n  self.cmdqueue=[]\n  self.completekey=completekey\n  \n def cmdloop(self,intro=None ):\n  ''\n\n\n\n  \n  \n  self.preloop()\n  if self.use_rawinput and self.completekey:\n   try :\n    import readline\n    self.old_completer=readline.get_completer()\n    readline.set_completer(self.complete)\n    readline.parse_and_bind(self.completekey+\": complete\")\n   except ImportError:\n    pass\n  try :\n   if intro is not None :\n    self.intro=intro\n   if self.intro:\n    self.stdout.write(str(self.intro)+\"\\n\")\n   stop=None\n   while not stop:\n    if self.cmdqueue:\n     line=self.cmdqueue.pop(0)\n    else :\n     if self.use_rawinput:\n      try :\n       line=input(self.prompt)\n      except EOFError:\n       line='EOF'\n     else :\n      self.stdout.write(self.prompt)\n      self.stdout.flush()\n      line=self.stdin.readline()\n      if not len(line):\n       line='EOF'\n      else :\n       line=line.rstrip('\\r\\n')\n    line=self.precmd(line)\n    stop=self.onecmd(line)\n    stop=self.postcmd(stop,line)\n   self.postloop()\n  finally :\n   if self.use_rawinput and self.completekey:\n    try :\n     import readline\n     readline.set_completer(self.old_completer)\n    except ImportError:\n     pass\n     \n     \n def precmd(self,line):\n  ''\n\n\n  \n  return line\n  \n def postcmd(self,stop,line):\n  ''\n  return stop\n  \n def preloop(self):\n  ''\n  pass\n  \n def postloop(self):\n  ''\n\n\n  \n  pass\n  \n def parseline(self,line):\n  ''\n\n\n  \n  line=line.strip()\n  if not line:\n   return None ,None ,line\n  elif line[0]=='?':\n   line='help '+line[1:]\n  elif line[0]=='!':\n   if hasattr(self,'do_shell'):\n    line='shell '+line[1:]\n   else :\n    return None ,None ,line\n  i,n=0,len(line)\n  while i <n and line[i]in self.identchars:i=i+1\n  cmd,arg=line[:i],line[i:].strip()\n  return cmd,arg,line\n  \n def onecmd(self,line):\n  ''\n\n\n\n\n\n\n\n  \n  cmd,arg,line=self.parseline(line)\n  if not line:\n   return self.emptyline()\n  if cmd is None :\n   return self.default(line)\n  self.lastcmd=line\n  if line =='EOF':\n   self.lastcmd=''\n  if cmd =='':\n   return self.default(line)\n  else :\n   try :\n    func=getattr(self,'do_'+cmd)\n   except AttributeError:\n    return self.default(line)\n   return func(arg)\n   \n def emptyline(self):\n  ''\n\n\n\n\n  \n  if self.lastcmd:\n   return self.onecmd(self.lastcmd)\n   \n def default(self,line):\n  ''\n\n\n\n\n  \n  self.stdout.write('*** Unknown syntax: %s\\n'%line)\n  \n def completedefault(self,*ignored):\n  ''\n\n\n\n\n  \n  return []\n  \n def completenames(self,text,*ignored):\n  dotext='do_'+text\n  return [a[3:]for a in self.get_names()if a.startswith(dotext)]\n  \n def complete(self,text,state):\n  ''\n\n\n\n  \n  if state ==0:\n   import readline\n   origline=readline.get_line_buffer()\n   line=origline.lstrip()\n   stripped=len(origline)-len(line)\n   begidx=readline.get_begidx()-stripped\n   endidx=readline.get_endidx()-stripped\n   if begidx >0:\n    cmd,args,foo=self.parseline(line)\n    if cmd =='':\n     compfunc=self.completedefault\n    else :\n     try :\n      compfunc=getattr(self,'complete_'+cmd)\n     except AttributeError:\n      compfunc=self.completedefault\n   else :\n    compfunc=self.completenames\n   self.completion_matches=compfunc(text,line,begidx,endidx)\n  try :\n   return self.completion_matches[state]\n  except IndexError:\n   return None\n   \n def get_names(self):\n \n \n  return dir(self.__class__)\n  \n def complete_help(self,*args):\n  commands=set(self.completenames(*args))\n  topics=set(a[5:]for a in self.get_names()\n  if a.startswith('help_'+args[0]))\n  return list(commands |topics)\n  \n def do_help(self,arg):\n  ''\n  if arg:\n  \n   try :\n    func=getattr(self,'help_'+arg)\n   except AttributeError:\n    try :\n     doc=getattr(self,'do_'+arg).__doc__\n     if doc:\n      self.stdout.write(\"%s\\n\"%str(doc))\n      return\n    except AttributeError:\n     pass\n    self.stdout.write(\"%s\\n\"%str(self.nohelp %(arg,)))\n    return\n   func()\n  else :\n   names=self.get_names()\n   cmds_doc=[]\n   cmds_undoc=[]\n   help={}\n   for name in names:\n    if name[:5]=='help_':\n     help[name[5:]]=1\n   names.sort()\n   \n   prevname=''\n   for name in names:\n    if name[:3]=='do_':\n     if name ==prevname:\n      continue\n     prevname=name\n     cmd=name[3:]\n     if cmd in help:\n      cmds_doc.append(cmd)\n      del help[cmd]\n     elif getattr(self,name).__doc__:\n      cmds_doc.append(cmd)\n     else :\n      cmds_undoc.append(cmd)\n   self.stdout.write(\"%s\\n\"%str(self.doc_leader))\n   self.print_topics(self.doc_header,cmds_doc,15,80)\n   self.print_topics(self.misc_header,list(help.keys()),15,80)\n   self.print_topics(self.undoc_header,cmds_undoc,15,80)\n   \n def print_topics(self,header,cmds,cmdlen,maxcol):\n  if cmds:\n   self.stdout.write(\"%s\\n\"%str(header))\n   if self.ruler:\n    self.stdout.write(\"%s\\n\"%str(self.ruler *len(header)))\n   self.columnize(cmds,maxcol -1)\n   self.stdout.write(\"\\n\")\n   \n def columnize(self,list,displaywidth=80):\n  ''\n\n\n\n  \n  if not list:\n   self.stdout.write(\"<empty>\\n\")\n   return\n   \n  nonstrings=[i for i in range(len(list))\n  if not isinstance(list[i],str)]\n  if nonstrings:\n   raise TypeError(\"list[i] not a string for i in %s\"\n   %\", \".join(map(str,nonstrings)))\n  size=len(list)\n  if size ==1:\n   self.stdout.write('%s\\n'%str(list[0]))\n   return\n   \n  for nrows in range(1,len(list)):\n   ncols=(size+nrows -1)//nrows\n   colwidths=[]\n   totwidth=-2\n   for col in range(ncols):\n    colwidth=0\n    for row in range(nrows):\n     i=row+nrows *col\n     if i >=size:\n      break\n     x=list[i]\n     colwidth=max(colwidth,len(x))\n    colwidths.append(colwidth)\n    totwidth +=colwidth+2\n    if totwidth >displaywidth:\n     break\n   if totwidth <=displaywidth:\n    break\n  else :\n   nrows=len(list)\n   ncols=1\n   colwidths=[0]\n  for row in range(nrows):\n   texts=[]\n   for col in range(ncols):\n    i=row+nrows *col\n    if i >=size:\n     x=\"\"\n    else :\n     x=list[i]\n    texts.append(x)\n   while texts and not texts[-1]:\n    del texts[-1]\n   for col in range(len(texts)):\n    texts[col]=texts[col].ljust(colwidths[col])\n   self.stdout.write(\"%s\\n\"%str(\"  \".join(texts)))\n", ["readline", "string", "sys"]], "code": [".py", "''\n\n\n\n\n\n\nimport sys\nimport traceback\nfrom codeop import CommandCompiler,compile_command\n\n__all__=[\"InteractiveInterpreter\",\"InteractiveConsole\",\"interact\",\n\"compile_command\"]\n\nclass InteractiveInterpreter:\n ''\n\n\n\n\n\n \n \n def __init__(self,locals=None ):\n  ''\n\n\n\n\n\n\n  \n  if locals is None :\n   locals={\"__name__\":\"__console__\",\"__doc__\":None }\n  self.locals=locals\n  self.compile=CommandCompiler()\n  \n def runsource(self,source,filename=\"<input>\",symbol=\"single\"):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  try :\n   code=self.compile(source,filename,symbol)\n  except (OverflowError,SyntaxError,ValueError):\n  \n   self.showsyntaxerror(filename)\n   return False\n   \n  if code is None :\n  \n   return True\n   \n   \n  self.runcode(code)\n  return False\n  \n def runcode(self,code):\n  ''\n\n\n\n\n\n\n\n\n\n  \n  try :\n   exec(code,self.locals)\n  except SystemExit:\n   raise\n  except :\n   self.showtraceback()\n   \n def showsyntaxerror(self,filename=None ):\n  ''\n\n\n\n\n\n\n\n\n\n  \n  type,value,tb=sys.exc_info()\n  sys.last_type=type\n  sys.last_value=value\n  sys.last_traceback=tb\n  if filename and type is SyntaxError:\n  \n   try :\n    msg,(dummy_filename,lineno,offset,line)=value.args\n   except ValueError:\n   \n    pass\n   else :\n   \n    value=SyntaxError(msg,(filename,lineno,offset,line))\n    sys.last_value=value\n  if sys.excepthook is sys.__excepthook__:\n   lines=traceback.format_exception_only(type,value)\n   self.write(''.join(lines))\n  else :\n  \n  \n   sys.excepthook(type,value,tb)\n   \n def showtraceback(self):\n  ''\n\n\n\n\n\n  \n  sys.last_type,sys.last_value,last_tb=ei=sys.exc_info()\n  sys.last_traceback=last_tb\n  try :\n   lines=traceback.format_exception(ei[0],ei[1],last_tb.tb_next)\n   if sys.excepthook is sys.__excepthook__:\n    self.write(''.join(lines))\n   else :\n   \n   \n    sys.excepthook(ei[0],ei[1],last_tb)\n  finally :\n   last_tb=ei=None\n   \n def write(self,data):\n  ''\n\n\n\n\n  \n  sys.stderr.write(data)\n  \n  \nclass InteractiveConsole(InteractiveInterpreter):\n ''\n\n\n\n\n \n \n def __init__(self,locals=None ,filename=\"<console>\"):\n  ''\n\n\n\n\n\n\n\n  \n  InteractiveInterpreter.__init__(self,locals)\n  self.filename=filename\n  self.resetbuffer()\n  \n def resetbuffer(self):\n  ''\n  self.buffer=[]\n  \n def interact(self,banner=None ,exitmsg=None ):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  try :\n   sys.ps1\n  except AttributeError:\n   sys.ps1=\">>> \"\n  try :\n   sys.ps2\n  except AttributeError:\n   sys.ps2=\"... \"\n  cprt='Type \"help\", \"copyright\", \"credits\" or \"license\" for more information.'\n  if banner is None :\n   self.write(\"Python %s on %s\\n%s\\n(%s)\\n\"%\n   (sys.version,sys.platform,cprt,\n   self.__class__.__name__))\n  elif banner:\n   self.write(\"%s\\n\"%str(banner))\n  more=0\n  while 1:\n   try :\n    if more:\n     prompt=sys.ps2\n    else :\n     prompt=sys.ps1\n    try :\n     line=self.raw_input(prompt)\n    except EOFError:\n     self.write(\"\\n\")\n     break\n    else :\n     more=self.push(line)\n   except KeyboardInterrupt:\n    self.write(\"\\nKeyboardInterrupt\\n\")\n    self.resetbuffer()\n    more=0\n  if exitmsg is None :\n   self.write('now exiting %s...\\n'%self.__class__.__name__)\n  elif exitmsg !='':\n   self.write('%s\\n'%exitmsg)\n   \n def push(self,line):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n  \n  self.buffer.append(line)\n  source=\"\\n\".join(self.buffer)\n  more=self.runsource(source,self.filename)\n  if not more:\n   self.resetbuffer()\n  return more\n  \n def raw_input(self,prompt=\"\"):\n  ''\n\n\n\n\n\n\n\n\n  \n  return input(prompt)\n  \n  \n  \ndef interact(banner=None ,readfunc=None ,local=None ,exitmsg=None ):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n \n console=InteractiveConsole(local)\n if readfunc is not None :\n  console.raw_input=readfunc\n else :\n  try :\n   import readline\n  except ImportError:\n   pass\n console.interact(banner,exitmsg)\n \n \nif __name__ ==\"__main__\":\n import argparse\n \n parser=argparse.ArgumentParser()\n parser.add_argument('-q',action='store_true',\n help=\"don't print version and copyright messages\")\n args=parser.parse_args()\n if args.q or sys.flags.quiet:\n  banner=''\n else :\n  banner=None\n interact(banner)\n", ["argparse", "codeop", "readline", "sys", "traceback"]], "codecs": [".py", "''\n\n\n\n\n\n\n\n\nimport builtins\nimport sys\n\n\n\ntry :\n from _codecs import *\nexcept ImportError as why:\n raise SystemError('Failed to load the builtin codecs: %s'%why)\n \n__all__=[\"register\",\"lookup\",\"open\",\"EncodedFile\",\"BOM\",\"BOM_BE\",\n\"BOM_LE\",\"BOM32_BE\",\"BOM32_LE\",\"BOM64_BE\",\"BOM64_LE\",\n\"BOM_UTF8\",\"BOM_UTF16\",\"BOM_UTF16_LE\",\"BOM_UTF16_BE\",\n\"BOM_UTF32\",\"BOM_UTF32_LE\",\"BOM_UTF32_BE\",\n\"CodecInfo\",\"Codec\",\"IncrementalEncoder\",\"IncrementalDecoder\",\n\"StreamReader\",\"StreamWriter\",\n\"StreamReaderWriter\",\"StreamRecoder\",\n\"getencoder\",\"getdecoder\",\"getincrementalencoder\",\n\"getincrementaldecoder\",\"getreader\",\"getwriter\",\n\"encode\",\"decode\",\"iterencode\",\"iterdecode\",\n\"strict_errors\",\"ignore_errors\",\"replace_errors\",\n\"xmlcharrefreplace_errors\",\n\"backslashreplace_errors\",\"namereplace_errors\",\n\"register_error\",\"lookup_error\"]\n\n\n\n\n\n\n\n\n\n\nBOM_UTF8=b'\\xef\\xbb\\xbf'\n\n\nBOM_LE=BOM_UTF16_LE=b'\\xff\\xfe'\n\n\nBOM_BE=BOM_UTF16_BE=b'\\xfe\\xff'\n\n\nBOM_UTF32_LE=b'\\xff\\xfe\\x00\\x00'\n\n\nBOM_UTF32_BE=b'\\x00\\x00\\xfe\\xff'\n\nif sys.byteorder =='little':\n\n\n BOM=BOM_UTF16=BOM_UTF16_LE\n \n \n BOM_UTF32=BOM_UTF32_LE\n \nelse :\n\n\n BOM=BOM_UTF16=BOM_UTF16_BE\n \n \n BOM_UTF32=BOM_UTF32_BE\n \n \nBOM32_LE=BOM_UTF16_LE\nBOM32_BE=BOM_UTF16_BE\nBOM64_LE=BOM_UTF32_LE\nBOM64_BE=BOM_UTF32_BE\n\n\n\n\nclass CodecInfo(tuple):\n ''\n \n \n \n \n \n \n \n _is_text_encoding=True\n \n def __new__(cls,encode,decode,streamreader=None ,streamwriter=None ,\n incrementalencoder=None ,incrementaldecoder=None ,name=None ,\n *,_is_text_encoding=None ):\n  self=tuple.__new__(cls,(encode,decode,streamreader,streamwriter))\n  self.name=name\n  self.encode=encode\n  self.decode=decode\n  self.incrementalencoder=incrementalencoder\n  self.incrementaldecoder=incrementaldecoder\n  self.streamwriter=streamwriter\n  self.streamreader=streamreader\n  if _is_text_encoding is not None :\n   self._is_text_encoding=_is_text_encoding\n  return self\n  \n def __repr__(self):\n  return \"<%s.%s object for encoding %s at %#x>\"%\\\n  (self.__class__.__module__,self.__class__.__qualname__,\n  self.name,id(self))\n  \nclass Codec:\n\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n def encode(self,input,errors='strict'):\n \n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  raise NotImplementedError\n  \n def decode(self,input,errors='strict'):\n \n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  raise NotImplementedError\n  \nclass IncrementalEncoder(object):\n ''\n\n\n\n \n def __init__(self,errors='strict'):\n  ''\n\n\n\n\n\n  \n  self.errors=errors\n  self.buffer=\"\"\n  \n def encode(self,input,final=False ):\n  ''\n\n  \n  raise NotImplementedError\n  \n def reset(self):\n  ''\n\n  \n  \n def getstate(self):\n  ''\n\n  \n  return 0\n  \n def setstate(self,state):\n  ''\n\n\n  \n  \nclass BufferedIncrementalEncoder(IncrementalEncoder):\n ''\n\n\n\n \n def __init__(self,errors='strict'):\n  IncrementalEncoder.__init__(self,errors)\n  \n  self.buffer=\"\"\n  \n def _buffer_encode(self,input,errors,final):\n \n \n  raise NotImplementedError\n  \n def encode(self,input,final=False ):\n \n  data=self.buffer+input\n  (result,consumed)=self._buffer_encode(data,self.errors,final)\n  \n  self.buffer=data[consumed:]\n  return result\n  \n def reset(self):\n  IncrementalEncoder.reset(self)\n  self.buffer=\"\"\n  \n def getstate(self):\n  return self.buffer or 0\n  \n def setstate(self,state):\n  self.buffer=state or \"\"\n  \nclass IncrementalDecoder(object):\n ''\n\n\n\n \n def __init__(self,errors='strict'):\n  ''\n\n\n\n\n\n  \n  self.errors=errors\n  \n def decode(self,input,final=False ):\n  ''\n\n  \n  raise NotImplementedError\n  \n def reset(self):\n  ''\n\n  \n  \n def getstate(self):\n  ''\n\n\n\n\n\n\n\n\n\n  \n  return (b\"\",0)\n  \n def setstate(self,state):\n  ''\n\n\n\n\n  \n  \nclass BufferedIncrementalDecoder(IncrementalDecoder):\n ''\n\n\n\n \n def __init__(self,errors='strict'):\n  IncrementalDecoder.__init__(self,errors)\n  \n  self.buffer=b\"\"\n  \n def _buffer_decode(self,input,errors,final):\n \n \n  raise NotImplementedError\n  \n def decode(self,input,final=False ):\n \n  data=self.buffer+input\n  (result,consumed)=self._buffer_decode(data,self.errors,final)\n  \n  self.buffer=data[consumed:]\n  return result\n  \n def reset(self):\n  IncrementalDecoder.reset(self)\n  self.buffer=b\"\"\n  \n def getstate(self):\n \n  return (self.buffer,0)\n  \n def setstate(self,state):\n \n  self.buffer=state[0]\n  \n  \n  \n  \n  \n  \n  \n  \nclass StreamWriter(Codec):\n\n def __init__(self,stream,errors='strict'):\n \n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  self.stream=stream\n  self.errors=errors\n  \n def write(self,object):\n \n  ''\n  \n  data,consumed=self.encode(object,self.errors)\n  self.stream.write(data)\n  \n def writelines(self,list):\n \n  ''\n\n  \n  self.write(''.join(list))\n  \n def reset(self):\n \n  ''\n\n\n\n\n\n\n  \n  pass\n  \n def seek(self,offset,whence=0):\n  self.stream.seek(offset,whence)\n  if whence ==0 and offset ==0:\n   self.reset()\n   \n def __getattr__(self,name,\n getattr=getattr):\n \n  ''\n  \n  return getattr(self.stream,name)\n  \n def __enter__(self):\n  return self\n  \n def __exit__(self,type,value,tb):\n  self.stream.close()\n  \n  \n  \nclass StreamReader(Codec):\n\n charbuffertype=str\n \n def __init__(self,stream,errors='strict'):\n \n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  self.stream=stream\n  self.errors=errors\n  self.bytebuffer=b\"\"\n  self._empty_charbuffer=self.charbuffertype()\n  self.charbuffer=self._empty_charbuffer\n  self.linebuffer=None\n  \n def decode(self,input,errors='strict'):\n  raise NotImplementedError\n  \n def read(self,size=-1,chars=-1,firstline=False ):\n \n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  \n  if self.linebuffer:\n   self.charbuffer=self._empty_charbuffer.join(self.linebuffer)\n   self.linebuffer=None\n   \n  if chars <0:\n  \n  \n   chars=size\n   \n   \n  while True :\n  \n   if chars >=0:\n    if len(self.charbuffer)>=chars:\n     break\n     \n   if size <0:\n    newdata=self.stream.read()\n   else :\n    newdata=self.stream.read(size)\n    \n   data=self.bytebuffer+newdata\n   if not data:\n    break\n   try :\n    newchars,decodedbytes=self.decode(data,self.errors)\n   except UnicodeDecodeError as exc:\n    if firstline:\n     newchars,decodedbytes=\\\n     self.decode(data[:exc.start],self.errors)\n     lines=newchars.splitlines(keepends=True )\n     if len(lines)<=1:\n      raise\n    else :\n     raise\n     \n   self.bytebuffer=data[decodedbytes:]\n   \n   self.charbuffer +=newchars\n   \n   if not newdata:\n    break\n  if chars <0:\n  \n   result=self.charbuffer\n   self.charbuffer=self._empty_charbuffer\n  else :\n  \n   result=self.charbuffer[:chars]\n   self.charbuffer=self.charbuffer[chars:]\n  return result\n  \n def readline(self,size=None ,keepends=True ):\n \n  ''\n\n\n\n\n\n  \n  \n  \n  if self.linebuffer:\n   line=self.linebuffer[0]\n   del self.linebuffer[0]\n   if len(self.linebuffer)==1:\n   \n   \n    self.charbuffer=self.linebuffer[0]\n    self.linebuffer=None\n   if not keepends:\n    line=line.splitlines(keepends=False )[0]\n   return line\n   \n  readsize=size or 72\n  line=self._empty_charbuffer\n  \n  while True :\n   data=self.read(readsize,firstline=True )\n   if data:\n   \n   \n   \n    if (isinstance(data,str)and data.endswith(\"\\r\"))or\\\n    (isinstance(data,bytes)and data.endswith(b\"\\r\")):\n     data +=self.read(size=1,chars=1)\n     \n   line +=data\n   lines=line.splitlines(keepends=True )\n   if lines:\n    if len(lines)>1:\n    \n    \n     line=lines[0]\n     del lines[0]\n     if len(lines)>1:\n     \n      lines[-1]+=self.charbuffer\n      self.linebuffer=lines\n      self.charbuffer=None\n     else :\n     \n      self.charbuffer=lines[0]+self.charbuffer\n     if not keepends:\n      line=line.splitlines(keepends=False )[0]\n     break\n    line0withend=lines[0]\n    line0withoutend=lines[0].splitlines(keepends=False )[0]\n    if line0withend !=line0withoutend:\n    \n     self.charbuffer=self._empty_charbuffer.join(lines[1:])+\\\n     self.charbuffer\n     if keepends:\n      line=line0withend\n     else :\n      line=line0withoutend\n     break\n     \n   if not data or size is not None :\n    if line and not keepends:\n     line=line.splitlines(keepends=False )[0]\n    break\n   if readsize <8000:\n    readsize *=2\n  return line\n  \n def readlines(self,sizehint=None ,keepends=True ):\n \n  ''\n\n\n\n\n\n\n\n\n  \n  data=self.read()\n  return data.splitlines(keepends)\n  \n def reset(self):\n \n  ''\n\n\n\n\n\n  \n  self.bytebuffer=b\"\"\n  self.charbuffer=self._empty_charbuffer\n  self.linebuffer=None\n  \n def seek(self,offset,whence=0):\n  ''\n\n\n  \n  self.stream.seek(offset,whence)\n  self.reset()\n  \n def __next__(self):\n \n  ''\n  line=self.readline()\n  if line:\n   return line\n  raise StopIteration\n  \n def __iter__(self):\n  return self\n  \n def __getattr__(self,name,\n getattr=getattr):\n \n  ''\n  \n  return getattr(self.stream,name)\n  \n def __enter__(self):\n  return self\n  \n def __exit__(self,type,value,tb):\n  self.stream.close()\n  \n  \n  \nclass StreamReaderWriter:\n\n ''\n\n\n\n\n\n\n \n \n encoding='unknown'\n \n def __init__(self,stream,Reader,Writer,errors='strict'):\n \n  ''\n\n\n\n\n\n\n\n\n\n  \n  self.stream=stream\n  self.reader=Reader(stream,errors)\n  self.writer=Writer(stream,errors)\n  self.errors=errors\n  \n def read(self,size=-1):\n \n  return self.reader.read(size)\n  \n def readline(self,size=None ):\n \n  return self.reader.readline(size)\n  \n def readlines(self,sizehint=None ):\n \n  return self.reader.readlines(sizehint)\n  \n def __next__(self):\n \n  ''\n  return next(self.reader)\n  \n def __iter__(self):\n  return self\n  \n def write(self,data):\n \n  return self.writer.write(data)\n  \n def writelines(self,list):\n \n  return self.writer.writelines(list)\n  \n def reset(self):\n \n  self.reader.reset()\n  self.writer.reset()\n  \n def seek(self,offset,whence=0):\n  self.stream.seek(offset,whence)\n  self.reader.reset()\n  if whence ==0 and offset ==0:\n   self.writer.reset()\n   \n def __getattr__(self,name,\n getattr=getattr):\n \n  ''\n  \n  return getattr(self.stream,name)\n  \n  \n  \n def __enter__(self):\n  return self\n  \n def __exit__(self,type,value,tb):\n  self.stream.close()\n  \n  \n  \nclass StreamRecoder:\n\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n data_encoding='unknown'\n file_encoding='unknown'\n \n def __init__(self,stream,encode,decode,Reader,Writer,\n errors='strict'):\n \n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  self.stream=stream\n  self.encode=encode\n  self.decode=decode\n  self.reader=Reader(stream,errors)\n  self.writer=Writer(stream,errors)\n  self.errors=errors\n  \n def read(self,size=-1):\n \n  data=self.reader.read(size)\n  data,bytesencoded=self.encode(data,self.errors)\n  return data\n  \n def readline(self,size=None ):\n \n  if size is None :\n   data=self.reader.readline()\n  else :\n   data=self.reader.readline(size)\n  data,bytesencoded=self.encode(data,self.errors)\n  return data\n  \n def readlines(self,sizehint=None ):\n \n  data=self.reader.read()\n  data,bytesencoded=self.encode(data,self.errors)\n  return data.splitlines(keepends=True )\n  \n def __next__(self):\n \n  ''\n  data=next(self.reader)\n  data,bytesencoded=self.encode(data,self.errors)\n  return data\n  \n def __iter__(self):\n  return self\n  \n def write(self,data):\n \n  data,bytesdecoded=self.decode(data,self.errors)\n  return self.writer.write(data)\n  \n def writelines(self,list):\n \n  data=''.join(list)\n  data,bytesdecoded=self.decode(data,self.errors)\n  return self.writer.write(data)\n  \n def reset(self):\n \n  self.reader.reset()\n  self.writer.reset()\n  \n def __getattr__(self,name,\n getattr=getattr):\n \n  ''\n  \n  return getattr(self.stream,name)\n  \n def __enter__(self):\n  return self\n  \n def __exit__(self,type,value,tb):\n  self.stream.close()\n  \n  \n  \ndef open(filename,mode='r',encoding=None ,errors='strict',buffering=1):\n\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n if encoding is not None and\\\n 'b'not in mode:\n \n  mode=mode+'b'\n file=builtins.open(filename,mode,buffering)\n if encoding is None :\n  return file\n info=lookup(encoding)\n srw=StreamReaderWriter(file,info.streamreader,info.streamwriter,errors)\n \n srw.encoding=encoding\n return srw\n \ndef EncodedFile(file,data_encoding,file_encoding=None ,errors='strict'):\n\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n if file_encoding is None :\n  file_encoding=data_encoding\n data_info=lookup(data_encoding)\n file_info=lookup(file_encoding)\n sr=StreamRecoder(file,data_info.encode,data_info.decode,\n file_info.streamreader,file_info.streamwriter,errors)\n \n sr.data_encoding=data_encoding\n sr.file_encoding=file_encoding\n return sr\n \n \n \ndef getencoder(encoding):\n\n ''\n\n\n\n\n \n return lookup(encoding).encode\n \ndef getdecoder(encoding):\n\n ''\n\n\n\n\n \n return lookup(encoding).decode\n \ndef getincrementalencoder(encoding):\n\n ''\n\n\n\n\n\n \n encoder=lookup(encoding).incrementalencoder\n if encoder is None :\n  raise LookupError(encoding)\n return encoder\n \ndef getincrementaldecoder(encoding):\n\n ''\n\n\n\n\n\n \n decoder=lookup(encoding).incrementaldecoder\n if decoder is None :\n  raise LookupError(encoding)\n return decoder\n \ndef getreader(encoding):\n\n ''\n\n\n\n\n \n return lookup(encoding).streamreader\n \ndef getwriter(encoding):\n\n ''\n\n\n\n\n \n return lookup(encoding).streamwriter\n \ndef iterencode(iterator,encoding,errors='strict',**kwargs):\n ''\n\n\n\n\n\n\n \n encoder=getincrementalencoder(encoding)(errors,**kwargs)\n for input in iterator:\n  output=encoder.encode(input)\n  if output:\n   yield output\n output=encoder.encode(\"\",True )\n if output:\n  yield output\n  \ndef iterdecode(iterator,encoding,errors='strict',**kwargs):\n ''\n\n\n\n\n\n\n \n decoder=getincrementaldecoder(encoding)(errors,**kwargs)\n for input in iterator:\n  output=decoder.decode(input)\n  if output:\n   yield output\n output=decoder.decode(b\"\",True )\n if output:\n  yield output\n  \n  \n  \ndef make_identity_dict(rng):\n\n ''\n\n\n\n\n \n return {i:i for i in rng}\n \ndef make_encoding_map(decoding_map):\n\n ''\n\n\n\n\n\n\n\n\n\n \n m={}\n for k,v in decoding_map.items():\n  if not v in m:\n   m[v]=k\n  else :\n   m[v]=None\n return m\n \n \n \ntry :\n strict_errors=lookup_error(\"strict\")\n ignore_errors=lookup_error(\"ignore\")\n replace_errors=lookup_error(\"replace\")\n xmlcharrefreplace_errors=lookup_error(\"xmlcharrefreplace\")\n backslashreplace_errors=lookup_error(\"backslashreplace\")\n namereplace_errors=lookup_error(\"namereplace\")\nexcept LookupError:\n\n strict_errors=None\n ignore_errors=None\n replace_errors=None\n xmlcharrefreplace_errors=None\n backslashreplace_errors=None\n namereplace_errors=None\n \n \n \n_false=0\nif _false:\n import encodings\n \n \n \nif __name__ =='__main__':\n\n\n sys.stdout=EncodedFile(sys.stdout,'latin-1','utf-8')\n \n \n sys.stdin=EncodedFile(sys.stdin,'utf-8','latin-1')\n", ["_codecs", "builtins", "encodings", "sys"]], "codeop": [".py", "''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nimport __future__\n\n_features=[getattr(__future__,fname)\nfor fname in __future__.all_feature_names]\n\n__all__=[\"compile_command\",\"Compile\",\"CommandCompiler\"]\n\nPyCF_DONT_IMPLY_DEDENT=0x200\n\ndef _maybe_compile(compiler,source,filename,symbol):\n\n for line in source.split(\"\\n\"):\n  line=line.strip()\n  if line and line[0]!='#':\n   break\n else :\n  if symbol !=\"eval\":\n   source=\"pass\"\n   \n err=err1=err2=None\n code=code1=code2=None\n \n try :\n  code=compiler(source,filename,symbol)\n except SyntaxError as err:\n  pass\n  \n try :\n  code1=compiler(source+\"\\n\",filename,symbol)\n except SyntaxError as e:\n  err1=e\n  \n try :\n  code2=compiler(source+\"\\n\\n\",filename,symbol)\n except SyntaxError as e:\n  err2=e\n  \n if code:\n  return code\n if not code1 and repr(err1)==repr(err2):\n  raise err1\n  \ndef _compile(source,filename,symbol):\n return compile(source,filename,symbol,PyCF_DONT_IMPLY_DEDENT)\n \ndef compile_command(source,filename=\"<input>\",symbol=\"single\"):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n return _maybe_compile(_compile,source,filename,symbol)\n \nclass Compile:\n ''\n\n\n \n def __init__(self):\n  self.flags=PyCF_DONT_IMPLY_DEDENT\n  \n def __call__(self,source,filename,symbol):\n  codeob=compile(source,filename,symbol,self.flags,1)\n  for feature in _features:\n   if codeob.co_flags&feature.compiler_flag:\n    self.flags |=feature.compiler_flag\n  return codeob\n  \nclass CommandCompiler:\n ''\n\n\n\n \n \n def __init__(self,):\n  self.compiler=Compile()\n  \n def __call__(self,source,filename=\"<input>\",symbol=\"single\"):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  return _maybe_compile(self.compiler,source,filename,symbol)\n", ["__future__"]], "colorsys": [".py", "''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n__all__=[\"rgb_to_yiq\",\"yiq_to_rgb\",\"rgb_to_hls\",\"hls_to_rgb\",\n\"rgb_to_hsv\",\"hsv_to_rgb\"]\n\n\n\nONE_THIRD=1.0 /3.0\nONE_SIXTH=1.0 /6.0\nTWO_THIRD=2.0 /3.0\n\n\n\n\n\n\n\n\ndef rgb_to_yiq(r,g,b):\n y=0.30 *r+0.59 *g+0.11 *b\n i=0.74 *(r -y)-0.27 *(b -y)\n q=0.48 *(r -y)+0.41 *(b -y)\n return (y,i,q)\n \ndef yiq_to_rgb(y,i,q):\n\n\n\n\n r=y+0.9468822170900693 *i+0.6235565819861433 *q\n g=y -0.27478764629897834 *i -0.6356910791873801 *q\n b=y -1.1085450346420322 *i+1.7090069284064666 *q\n \n if r <0.0:\n  r=0.0\n if g <0.0:\n  g=0.0\n if b <0.0:\n  b=0.0\n if r >1.0:\n  r=1.0\n if g >1.0:\n  g=1.0\n if b >1.0:\n  b=1.0\n return (r,g,b)\n \n \n \n \n \n \n \ndef rgb_to_hls(r,g,b):\n maxc=max(r,g,b)\n minc=min(r,g,b)\n \n l=(minc+maxc)/2.0\n if minc ==maxc:\n  return 0.0,l,0.0\n if l <=0.5:\n  s=(maxc -minc)/(maxc+minc)\n else :\n  s=(maxc -minc)/(2.0 -maxc -minc)\n rc=(maxc -r)/(maxc -minc)\n gc=(maxc -g)/(maxc -minc)\n bc=(maxc -b)/(maxc -minc)\n if r ==maxc:\n  h=bc -gc\n elif g ==maxc:\n  h=2.0+rc -bc\n else :\n  h=4.0+gc -rc\n h=(h /6.0)%1.0\n return h,l,s\n \ndef hls_to_rgb(h,l,s):\n if s ==0.0:\n  return l,l,l\n if l <=0.5:\n  m2=l *(1.0+s)\n else :\n  m2=l+s -(l *s)\n m1=2.0 *l -m2\n return (_v(m1,m2,h+ONE_THIRD),_v(m1,m2,h),_v(m1,m2,h -ONE_THIRD))\n \ndef _v(m1,m2,hue):\n hue=hue %1.0\n if hue <ONE_SIXTH:\n  return m1+(m2 -m1)*hue *6.0\n if hue <0.5:\n  return m2\n if hue <TWO_THIRD:\n  return m1+(m2 -m1)*(TWO_THIRD -hue)*6.0\n return m1\n \n \n \n \n \n \n \ndef rgb_to_hsv(r,g,b):\n maxc=max(r,g,b)\n minc=min(r,g,b)\n v=maxc\n if minc ==maxc:\n  return 0.0,0.0,v\n s=(maxc -minc)/maxc\n rc=(maxc -r)/(maxc -minc)\n gc=(maxc -g)/(maxc -minc)\n bc=(maxc -b)/(maxc -minc)\n if r ==maxc:\n  h=bc -gc\n elif g ==maxc:\n  h=2.0+rc -bc\n else :\n  h=4.0+gc -rc\n h=(h /6.0)%1.0\n return h,s,v\n \ndef hsv_to_rgb(h,s,v):\n if s ==0.0:\n  return v,v,v\n i=int(h *6.0)\n f=(h *6.0)-i\n p=v *(1.0 -s)\n q=v *(1.0 -s *f)\n t=v *(1.0 -s *(1.0 -f))\n i=i %6\n if i ==0:\n  return v,t,p\n if i ==1:\n  return q,v,p\n if i ==2:\n  return p,v,t\n if i ==3:\n  return p,q,v\n if i ==4:\n  return t,p,v\n if i ==5:\n  return v,p,q\n  \n", []], "configparser": [".py", "''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nfrom collections.abc import MutableMapping\nfrom collections import OrderedDict as _default_dict,ChainMap as _ChainMap\nimport functools\nimport io\nimport itertools\nimport os\nimport re\nimport sys\nimport warnings\n\n__all__=[\"NoSectionError\",\"DuplicateOptionError\",\"DuplicateSectionError\",\n\"NoOptionError\",\"InterpolationError\",\"InterpolationDepthError\",\n\"InterpolationMissingOptionError\",\"InterpolationSyntaxError\",\n\"ParsingError\",\"MissingSectionHeaderError\",\n\"ConfigParser\",\"SafeConfigParser\",\"RawConfigParser\",\n\"Interpolation\",\"BasicInterpolation\",\"ExtendedInterpolation\",\n\"LegacyInterpolation\",\"SectionProxy\",\"ConverterMapping\",\n\"DEFAULTSECT\",\"MAX_INTERPOLATION_DEPTH\"]\n\nDEFAULTSECT=\"DEFAULT\"\n\nMAX_INTERPOLATION_DEPTH=10\n\n\n\n\nclass Error(Exception):\n ''\n \n def __init__(self,msg=''):\n  self.message=msg\n  Exception.__init__(self,msg)\n  \n def __repr__(self):\n  return self.message\n  \n __str__=__repr__\n \n \nclass NoSectionError(Error):\n ''\n \n def __init__(self,section):\n  Error.__init__(self,'No section: %r'%(section,))\n  self.section=section\n  self.args=(section,)\n  \n  \nclass DuplicateSectionError(Error):\n ''\n\n\n\n\n \n \n def __init__(self,section,source=None ,lineno=None ):\n  msg=[repr(section),\" already exists\"]\n  if source is not None :\n   message=[\"While reading from \",repr(source)]\n   if lineno is not None :\n    message.append(\" [line {0:2d}]\".format(lineno))\n   message.append(\": section \")\n   message.extend(msg)\n   msg=message\n  else :\n   msg.insert(0,\"Section \")\n  Error.__init__(self,\"\".join(msg))\n  self.section=section\n  self.source=source\n  self.lineno=lineno\n  self.args=(section,source,lineno)\n  \n  \nclass DuplicateOptionError(Error):\n ''\n\n\n\n \n \n def __init__(self,section,option,source=None ,lineno=None ):\n  msg=[repr(option),\" in section \",repr(section),\n  \" already exists\"]\n  if source is not None :\n   message=[\"While reading from \",repr(source)]\n   if lineno is not None :\n    message.append(\" [line {0:2d}]\".format(lineno))\n   message.append(\": option \")\n   message.extend(msg)\n   msg=message\n  else :\n   msg.insert(0,\"Option \")\n  Error.__init__(self,\"\".join(msg))\n  self.section=section\n  self.option=option\n  self.source=source\n  self.lineno=lineno\n  self.args=(section,option,source,lineno)\n  \n  \nclass NoOptionError(Error):\n ''\n \n def __init__(self,option,section):\n  Error.__init__(self,\"No option %r in section: %r\"%\n  (option,section))\n  self.option=option\n  self.section=section\n  self.args=(option,section)\n  \n  \nclass InterpolationError(Error):\n ''\n \n def __init__(self,option,section,msg):\n  Error.__init__(self,msg)\n  self.option=option\n  self.section=section\n  self.args=(option,section,msg)\n  \n  \nclass InterpolationMissingOptionError(InterpolationError):\n ''\n \n def __init__(self,option,section,rawval,reference):\n  msg=(\"Bad value substitution: option {!r} in section {!r} contains \"\n  \"an interpolation key {!r} which is not a valid option name. \"\n  \"Raw value: {!r}\".format(option,section,reference,rawval))\n  InterpolationError.__init__(self,option,section,msg)\n  self.reference=reference\n  self.args=(option,section,rawval,reference)\n  \n  \nclass InterpolationSyntaxError(InterpolationError):\n ''\n\n\n\n \n \n \nclass InterpolationDepthError(InterpolationError):\n ''\n \n def __init__(self,option,section,rawval):\n  msg=(\"Recursion limit exceeded in value substitution: option {!r} \"\n  \"in section {!r} contains an interpolation key which \"\n  \"cannot be substituted in {} steps. Raw value: {!r}\"\n  \"\".format(option,section,MAX_INTERPOLATION_DEPTH,\n  rawval))\n  InterpolationError.__init__(self,option,section,msg)\n  self.args=(option,section,rawval)\n  \n  \nclass ParsingError(Error):\n ''\n \n def __init__(self,source=None ,filename=None ):\n \n \n  if filename and source:\n   raise ValueError(\"Cannot specify both `filename' and `source'. \"\n   \"Use `source'.\")\n  elif not filename and not source:\n   raise ValueError(\"Required argument `source' not given.\")\n  elif filename:\n   source=filename\n  Error.__init__(self,'Source contains parsing errors: %r'%source)\n  self.source=source\n  self.errors=[]\n  self.args=(source,)\n  \n @property\n def filename(self):\n  ''\n  warnings.warn(\n  \"The 'filename' attribute will be removed in future versions.  \"\n  \"Use 'source' instead.\",\n  DeprecationWarning,stacklevel=2\n  )\n  return self.source\n  \n @filename.setter\n def filename(self,value):\n  ''\n  warnings.warn(\n  \"The 'filename' attribute will be removed in future versions.  \"\n  \"Use 'source' instead.\",\n  DeprecationWarning,stacklevel=2\n  )\n  self.source=value\n  \n def append(self,lineno,line):\n  self.errors.append((lineno,line))\n  self.message +='\\n\\t[line %2d]: %s'%(lineno,line)\n  \n  \nclass MissingSectionHeaderError(ParsingError):\n ''\n \n def __init__(self,filename,lineno,line):\n  Error.__init__(\n  self,\n  'File contains no section headers.\\nfile: %r, line: %d\\n%r'%\n  (filename,lineno,line))\n  self.source=filename\n  self.lineno=lineno\n  self.line=line\n  self.args=(filename,lineno,line)\n  \n  \n  \n  \n  \n_UNSET=object()\n\n\nclass Interpolation:\n ''\n \n def before_get(self,parser,section,option,value,defaults):\n  return value\n  \n def before_set(self,parser,section,option,value):\n  return value\n  \n def before_read(self,parser,section,option,value):\n  return value\n  \n def before_write(self,parser,section,option,value):\n  return value\n  \n  \nclass BasicInterpolation(Interpolation):\n ''\n\n\n\n\n\n\n\n\n\n\n\n \n \n _KEYCRE=re.compile(r\"%\\(([^)]+)\\)s\")\n \n def before_get(self,parser,section,option,value,defaults):\n  L=[]\n  self._interpolate_some(parser,option,L,value,section,defaults,1)\n  return ''.join(L)\n  \n def before_set(self,parser,section,option,value):\n  tmp_value=value.replace('%%','')\n  tmp_value=self._KEYCRE.sub('',tmp_value)\n  if '%'in tmp_value:\n   raise ValueError(\"invalid interpolation syntax in %r at \"\n   \"position %d\"%(value,tmp_value.find('%')))\n  return value\n  \n def _interpolate_some(self,parser,option,accum,rest,section,map,\n depth):\n  rawval=parser.get(section,option,raw=True ,fallback=rest)\n  if depth >MAX_INTERPOLATION_DEPTH:\n   raise InterpolationDepthError(option,section,rawval)\n  while rest:\n   p=rest.find(\"%\")\n   if p <0:\n    accum.append(rest)\n    return\n   if p >0:\n    accum.append(rest[:p])\n    rest=rest[p:]\n    \n   c=rest[1:2]\n   if c ==\"%\":\n    accum.append(\"%\")\n    rest=rest[2:]\n   elif c ==\"(\":\n    m=self._KEYCRE.match(rest)\n    if m is None :\n     raise InterpolationSyntaxError(option,section,\n     \"bad interpolation variable reference %r\"%rest)\n    var=parser.optionxform(m.group(1))\n    rest=rest[m.end():]\n    try :\n     v=map[var]\n    except KeyError:\n     raise InterpolationMissingOptionError(\n     option,section,rawval,var)from None\n    if \"%\"in v:\n     self._interpolate_some(parser,option,accum,v,\n     section,map,depth+1)\n    else :\n     accum.append(v)\n   else :\n    raise InterpolationSyntaxError(\n    option,section,\n    \"'%%' must be followed by '%%' or '(', \"\n    \"found: %r\"%(rest,))\n    \n    \nclass ExtendedInterpolation(Interpolation):\n ''\n \n \n _KEYCRE=re.compile(r\"\\$\\{([^}]+)\\}\")\n \n def before_get(self,parser,section,option,value,defaults):\n  L=[]\n  self._interpolate_some(parser,option,L,value,section,defaults,1)\n  return ''.join(L)\n  \n def before_set(self,parser,section,option,value):\n  tmp_value=value.replace('$$','')\n  tmp_value=self._KEYCRE.sub('',tmp_value)\n  if '$'in tmp_value:\n   raise ValueError(\"invalid interpolation syntax in %r at \"\n   \"position %d\"%(value,tmp_value.find('$')))\n  return value\n  \n def _interpolate_some(self,parser,option,accum,rest,section,map,\n depth):\n  rawval=parser.get(section,option,raw=True ,fallback=rest)\n  if depth >MAX_INTERPOLATION_DEPTH:\n   raise InterpolationDepthError(option,section,rawval)\n  while rest:\n   p=rest.find(\"$\")\n   if p <0:\n    accum.append(rest)\n    return\n   if p >0:\n    accum.append(rest[:p])\n    rest=rest[p:]\n    \n   c=rest[1:2]\n   if c ==\"$\":\n    accum.append(\"$\")\n    rest=rest[2:]\n   elif c ==\"{\":\n    m=self._KEYCRE.match(rest)\n    if m is None :\n     raise InterpolationSyntaxError(option,section,\n     \"bad interpolation variable reference %r\"%rest)\n    path=m.group(1).split(':')\n    rest=rest[m.end():]\n    sect=section\n    opt=option\n    try :\n     if len(path)==1:\n      opt=parser.optionxform(path[0])\n      v=map[opt]\n     elif len(path)==2:\n      sect=path[0]\n      opt=parser.optionxform(path[1])\n      v=parser.get(sect,opt,raw=True )\n     else :\n      raise InterpolationSyntaxError(\n      option,section,\n      \"More than one ':' found: %r\"%(rest,))\n    except (KeyError,NoSectionError,NoOptionError):\n     raise InterpolationMissingOptionError(\n     option,section,rawval,\":\".join(path))from None\n    if \"$\"in v:\n     self._interpolate_some(parser,opt,accum,v,sect,\n     dict(parser.items(sect,raw=True )),\n     depth+1)\n    else :\n     accum.append(v)\n   else :\n    raise InterpolationSyntaxError(\n    option,section,\n    \"'$' must be followed by '$' or '{', \"\n    \"found: %r\"%(rest,))\n    \n    \nclass LegacyInterpolation(Interpolation):\n ''\n \n \n _KEYCRE=re.compile(r\"%\\(([^)]*)\\)s|.\")\n \n def before_get(self,parser,section,option,value,vars):\n  rawval=value\n  depth=MAX_INTERPOLATION_DEPTH\n  while depth:\n   depth -=1\n   if value and \"%(\"in value:\n    replace=functools.partial(self._interpolation_replace,\n    parser=parser)\n    value=self._KEYCRE.sub(replace,value)\n    try :\n     value=value %vars\n    except KeyError as e:\n     raise InterpolationMissingOptionError(\n     option,section,rawval,e.args[0])from None\n   else :\n    break\n  if value and \"%(\"in value:\n   raise InterpolationDepthError(option,section,rawval)\n  return value\n  \n def before_set(self,parser,section,option,value):\n  return value\n  \n @staticmethod\n def _interpolation_replace(match,parser):\n  s=match.group(1)\n  if s is None :\n   return match.group()\n  else :\n   return \"%%(%s)s\"%parser.optionxform(s)\n   \n   \nclass RawConfigParser(MutableMapping):\n ''\n \n \n _SECT_TMPL=r\"\"\"\n        \\[                                 # [\n        (?P<header>[^]]+)                  # very permissive!\n        \\]                                 # ]\n        \"\"\"\n _OPT_TMPL=r\"\"\"\n        (?P<option>.*?)                    # very permissive!\n        \\s*(?P<vi>{delim})\\s*              # any number of space/tab,\n                                           # followed by any of the\n                                           # allowed delimiters,\n                                           # followed by any space/tab\n        (?P<value>.*)$                     # everything up to eol\n        \"\"\"\n _OPT_NV_TMPL=r\"\"\"\n        (?P<option>.*?)                    # very permissive!\n        \\s*(?:                             # any number of space/tab,\n        (?P<vi>{delim})\\s*                 # optionally followed by\n                                           # any of the allowed\n                                           # delimiters, followed by any\n                                           # space/tab\n        (?P<value>.*))?$                   # everything up to eol\n        \"\"\"\n \n _DEFAULT_INTERPOLATION=Interpolation()\n \n SECTCRE=re.compile(_SECT_TMPL,re.VERBOSE)\n \n OPTCRE=re.compile(_OPT_TMPL.format(delim=\"=|:\"),re.VERBOSE)\n \n \n OPTCRE_NV=re.compile(_OPT_NV_TMPL.format(delim=\"=|:\"),re.VERBOSE)\n \n NONSPACECRE=re.compile(r\"\\S\")\n \n BOOLEAN_STATES={'1':True ,'yes':True ,'true':True ,'on':True ,\n '0':False ,'no':False ,'false':False ,'off':False }\n \n def __init__(self,defaults=None ,dict_type=_default_dict,\n allow_no_value=False ,*,delimiters=('=',':'),\n comment_prefixes=('#',';'),inline_comment_prefixes=None ,\n strict=True ,empty_lines_in_values=True ,\n default_section=DEFAULTSECT,\n interpolation=_UNSET,converters=_UNSET):\n \n  self._dict=dict_type\n  self._sections=self._dict()\n  self._defaults=self._dict()\n  self._converters=ConverterMapping(self)\n  self._proxies=self._dict()\n  self._proxies[default_section]=SectionProxy(self,default_section)\n  self._delimiters=tuple(delimiters)\n  if delimiters ==('=',':'):\n   self._optcre=self.OPTCRE_NV if allow_no_value else self.OPTCRE\n  else :\n   d=\"|\".join(re.escape(d)for d in delimiters)\n   if allow_no_value:\n    self._optcre=re.compile(self._OPT_NV_TMPL.format(delim=d),\n    re.VERBOSE)\n   else :\n    self._optcre=re.compile(self._OPT_TMPL.format(delim=d),\n    re.VERBOSE)\n  self._comment_prefixes=tuple(comment_prefixes or ())\n  self._inline_comment_prefixes=tuple(inline_comment_prefixes or ())\n  self._strict=strict\n  self._allow_no_value=allow_no_value\n  self._empty_lines_in_values=empty_lines_in_values\n  self.default_section=default_section\n  self._interpolation=interpolation\n  if self._interpolation is _UNSET:\n   self._interpolation=self._DEFAULT_INTERPOLATION\n  if self._interpolation is None :\n   self._interpolation=Interpolation()\n  if converters is not _UNSET:\n   self._converters.update(converters)\n  if defaults:\n   self._read_defaults(defaults)\n   \n def defaults(self):\n  return self._defaults\n  \n def sections(self):\n  ''\n  \n  return list(self._sections.keys())\n  \n def add_section(self,section):\n  ''\n\n\n\n  \n  if section ==self.default_section:\n   raise ValueError('Invalid section name: %r'%section)\n   \n  if section in self._sections:\n   raise DuplicateSectionError(section)\n  self._sections[section]=self._dict()\n  self._proxies[section]=SectionProxy(self,section)\n  \n def has_section(self,section):\n  ''\n\n\n  \n  return section in self._sections\n  \n def options(self,section):\n  ''\n  try :\n   opts=self._sections[section].copy()\n  except KeyError:\n   raise NoSectionError(section)from None\n  opts.update(self._defaults)\n  return list(opts.keys())\n  \n def read(self,filenames,encoding=None ):\n  ''\n\n\n\n\n\n\n\n\n\n  \n  if isinstance(filenames,(str,bytes,os.PathLike)):\n   filenames=[filenames]\n  read_ok=[]\n  for filename in filenames:\n   try :\n    with open(filename,encoding=encoding)as fp:\n     self._read(fp,filename)\n   except OSError:\n    continue\n   if isinstance(filename,os.PathLike):\n    filename=os.fspath(filename)\n   read_ok.append(filename)\n  return read_ok\n  \n def read_file(self,f,source=None ):\n  ''\n\n\n\n\n\n  \n  if source is None :\n   try :\n    source=f.name\n   except AttributeError:\n    source='<???>'\n  self._read(f,source)\n  \n def read_string(self,string,source='<string>'):\n  ''\n  sfile=io.StringIO(string)\n  self.read_file(sfile,source)\n  \n def read_dict(self,dictionary,source='<dict>'):\n  ''\n\n\n\n\n\n\n\n\n\n\n  \n  elements_added=set()\n  for section,keys in dictionary.items():\n   section=str(section)\n   try :\n    self.add_section(section)\n   except (DuplicateSectionError,ValueError):\n    if self._strict and section in elements_added:\n     raise\n   elements_added.add(section)\n   for key,value in keys.items():\n    key=self.optionxform(str(key))\n    if value is not None :\n     value=str(value)\n    if self._strict and (section,key)in elements_added:\n     raise DuplicateOptionError(section,key,source)\n    elements_added.add((section,key))\n    self.set(section,key,value)\n    \n def readfp(self,fp,filename=None ):\n  ''\n  warnings.warn(\n  \"This method will be removed in future versions.  \"\n  \"Use 'parser.read_file()' instead.\",\n  DeprecationWarning,stacklevel=2\n  )\n  self.read_file(fp,source=filename)\n  \n def get(self,section,option,*,raw=False ,vars=None ,fallback=_UNSET):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  try :\n   d=self._unify_values(section,vars)\n  except NoSectionError:\n   if fallback is _UNSET:\n    raise\n   else :\n    return fallback\n  option=self.optionxform(option)\n  try :\n   value=d[option]\n  except KeyError:\n   if fallback is _UNSET:\n    raise NoOptionError(option,section)\n   else :\n    return fallback\n    \n  if raw or value is None :\n   return value\n  else :\n   return self._interpolation.before_get(self,section,option,value,\n   d)\n   \n def _get(self,section,conv,option,**kwargs):\n  return conv(self.get(section,option,**kwargs))\n  \n def _get_conv(self,section,option,conv,*,raw=False ,vars=None ,\n fallback=_UNSET,**kwargs):\n  try :\n   return self._get(section,conv,option,raw=raw,vars=vars,\n   **kwargs)\n  except (NoSectionError,NoOptionError):\n   if fallback is _UNSET:\n    raise\n   return fallback\n   \n   \n def getint(self,section,option,*,raw=False ,vars=None ,\n fallback=_UNSET,**kwargs):\n  return self._get_conv(section,option,int,raw=raw,vars=vars,\n  fallback=fallback,**kwargs)\n  \n def getfloat(self,section,option,*,raw=False ,vars=None ,\n fallback=_UNSET,**kwargs):\n  return self._get_conv(section,option,float,raw=raw,vars=vars,\n  fallback=fallback,**kwargs)\n  \n def getboolean(self,section,option,*,raw=False ,vars=None ,\n fallback=_UNSET,**kwargs):\n  return self._get_conv(section,option,self._convert_to_boolean,\n  raw=raw,vars=vars,fallback=fallback,**kwargs)\n  \n def items(self,section=_UNSET,raw=False ,vars=None ):\n  ''\n\n\n\n\n\n\n\n\n  \n  if section is _UNSET:\n   return super().items()\n  d=self._defaults.copy()\n  try :\n   d.update(self._sections[section])\n  except KeyError:\n   if section !=self.default_section:\n    raise NoSectionError(section)\n    \n  if vars:\n   for key,value in vars.items():\n    d[self.optionxform(key)]=value\n  value_getter=lambda option:self._interpolation.before_get(self,\n  section,option,d[option],d)\n  if raw:\n   value_getter=lambda option:d[option]\n  return [(option,value_getter(option))for option in d.keys()]\n  \n def popitem(self):\n  ''\n\n\n\n\n  \n  for key in self.sections():\n   value=self[key]\n   del self[key]\n   return key,value\n  raise KeyError\n  \n def optionxform(self,optionstr):\n  return optionstr.lower()\n  \n def has_option(self,section,option):\n  ''\n\n  \n  if not section or section ==self.default_section:\n   option=self.optionxform(option)\n   return option in self._defaults\n  elif section not in self._sections:\n   return False\n  else :\n   option=self.optionxform(option)\n   return (option in self._sections[section]\n   or option in self._defaults)\n   \n def set(self,section,option,value=None ):\n  ''\n  if value:\n   value=self._interpolation.before_set(self,section,option,\n   value)\n  if not section or section ==self.default_section:\n   sectdict=self._defaults\n  else :\n   try :\n    sectdict=self._sections[section]\n   except KeyError:\n    raise NoSectionError(section)from None\n  sectdict[self.optionxform(option)]=value\n  \n def write(self,fp,space_around_delimiters=True ):\n  ''\n\n\n\n  \n  if space_around_delimiters:\n   d=\" {} \".format(self._delimiters[0])\n  else :\n   d=self._delimiters[0]\n  if self._defaults:\n   self._write_section(fp,self.default_section,\n   self._defaults.items(),d)\n  for section in self._sections:\n   self._write_section(fp,section,\n   self._sections[section].items(),d)\n   \n def _write_section(self,fp,section_name,section_items,delimiter):\n  ''\n  fp.write(\"[{}]\\n\".format(section_name))\n  for key,value in section_items:\n   value=self._interpolation.before_write(self,section_name,key,\n   value)\n   if value is not None or not self._allow_no_value:\n    value=delimiter+str(value).replace('\\n','\\n\\t')\n   else :\n    value=\"\"\n   fp.write(\"{}{}\\n\".format(key,value))\n  fp.write(\"\\n\")\n  \n def remove_option(self,section,option):\n  ''\n  if not section or section ==self.default_section:\n   sectdict=self._defaults\n  else :\n   try :\n    sectdict=self._sections[section]\n   except KeyError:\n    raise NoSectionError(section)from None\n  option=self.optionxform(option)\n  existed=option in sectdict\n  if existed:\n   del sectdict[option]\n  return existed\n  \n def remove_section(self,section):\n  ''\n  existed=section in self._sections\n  if existed:\n   del self._sections[section]\n   del self._proxies[section]\n  return existed\n  \n def __getitem__(self,key):\n  if key !=self.default_section and not self.has_section(key):\n   raise KeyError(key)\n  return self._proxies[key]\n  \n def __setitem__(self,key,value):\n \n \n \n \n \n  if key ==self.default_section:\n   self._defaults.clear()\n  elif key in self._sections:\n   self._sections[key].clear()\n  self.read_dict({key:value})\n  \n def __delitem__(self,key):\n  if key ==self.default_section:\n   raise ValueError(\"Cannot remove the default section.\")\n  if not self.has_section(key):\n   raise KeyError(key)\n  self.remove_section(key)\n  \n def __contains__(self,key):\n  return key ==self.default_section or self.has_section(key)\n  \n def __len__(self):\n  return len(self._sections)+1\n  \n def __iter__(self):\n \n  return itertools.chain((self.default_section,),self._sections.keys())\n  \n def _read(self,fp,fpname):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  elements_added=set()\n  cursect=None\n  sectname=None\n  optname=None\n  lineno=0\n  indent_level=0\n  e=None\n  for lineno,line in enumerate(fp,start=1):\n   comment_start=sys.maxsize\n   \n   inline_prefixes={p:-1 for p in self._inline_comment_prefixes}\n   while comment_start ==sys.maxsize and inline_prefixes:\n    next_prefixes={}\n    for prefix,index in inline_prefixes.items():\n     index=line.find(prefix,index+1)\n     if index ==-1:\n      continue\n     next_prefixes[prefix]=index\n     if index ==0 or (index >0 and line[index -1].isspace()):\n      comment_start=min(comment_start,index)\n    inline_prefixes=next_prefixes\n    \n   for prefix in self._comment_prefixes:\n    if line.strip().startswith(prefix):\n     comment_start=0\n     break\n   if comment_start ==sys.maxsize:\n    comment_start=None\n   value=line[:comment_start].strip()\n   if not value:\n    if self._empty_lines_in_values:\n    \n    \n     if (comment_start is None and\n     cursect is not None and\n     optname and\n     cursect[optname]is not None ):\n      cursect[optname].append('')\n    else :\n    \n     indent_level=sys.maxsize\n    continue\n    \n   first_nonspace=self.NONSPACECRE.search(line)\n   cur_indent_level=first_nonspace.start()if first_nonspace else 0\n   if (cursect is not None and optname and\n   cur_indent_level >indent_level):\n    cursect[optname].append(value)\n    \n   else :\n    indent_level=cur_indent_level\n    \n    mo=self.SECTCRE.match(value)\n    if mo:\n     sectname=mo.group('header')\n     if sectname in self._sections:\n      if self._strict and sectname in elements_added:\n       raise DuplicateSectionError(sectname,fpname,\n       lineno)\n      cursect=self._sections[sectname]\n      elements_added.add(sectname)\n     elif sectname ==self.default_section:\n      cursect=self._defaults\n     else :\n      cursect=self._dict()\n      self._sections[sectname]=cursect\n      self._proxies[sectname]=SectionProxy(self,sectname)\n      elements_added.add(sectname)\n      \n     optname=None\n     \n    elif cursect is None :\n     raise MissingSectionHeaderError(fpname,lineno,line)\n     \n    else :\n     mo=self._optcre.match(value)\n     if mo:\n      optname,vi,optval=mo.group('option','vi','value')\n      if not optname:\n       e=self._handle_error(e,fpname,lineno,line)\n      optname=self.optionxform(optname.rstrip())\n      if (self._strict and\n      (sectname,optname)in elements_added):\n       raise DuplicateOptionError(sectname,optname,\n       fpname,lineno)\n      elements_added.add((sectname,optname))\n      \n      \n      if optval is not None :\n       optval=optval.strip()\n       cursect[optname]=[optval]\n      else :\n      \n       cursect[optname]=None\n     else :\n     \n     \n     \n     \n      e=self._handle_error(e,fpname,lineno,line)\n  self._join_multiline_values()\n  \n  if e:\n   raise e\n   \n def _join_multiline_values(self):\n  defaults=self.default_section,self._defaults\n  all_sections=itertools.chain((defaults,),\n  self._sections.items())\n  for section,options in all_sections:\n   for name,val in options.items():\n    if isinstance(val,list):\n     val='\\n'.join(val).rstrip()\n    options[name]=self._interpolation.before_read(self,\n    section,\n    name,val)\n    \n def _read_defaults(self,defaults):\n  ''\n  \n  for key,value in defaults.items():\n   self._defaults[self.optionxform(key)]=value\n   \n def _handle_error(self,exc,fpname,lineno,line):\n  if not exc:\n   exc=ParsingError(fpname)\n  exc.append(lineno,repr(line))\n  return exc\n  \n def _unify_values(self,section,vars):\n  ''\n\n\n  \n  sectiondict={}\n  try :\n   sectiondict=self._sections[section]\n  except KeyError:\n   if section !=self.default_section:\n    raise NoSectionError(section)from None\n    \n  vardict={}\n  if vars:\n   for key,value in vars.items():\n    if value is not None :\n     value=str(value)\n    vardict[self.optionxform(key)]=value\n  return _ChainMap(vardict,sectiondict,self._defaults)\n  \n def _convert_to_boolean(self,value):\n  ''\n  \n  if value.lower()not in self.BOOLEAN_STATES:\n   raise ValueError('Not a boolean: %s'%value)\n  return self.BOOLEAN_STATES[value.lower()]\n  \n def _validate_value_types(self,*,section=\"\",option=\"\",value=\"\"):\n  ''\n\n\n\n\n\n\n\n\n\n\n  \n  if not isinstance(section,str):\n   raise TypeError(\"section names must be strings\")\n  if not isinstance(option,str):\n   raise TypeError(\"option keys must be strings\")\n  if not self._allow_no_value or value:\n   if not isinstance(value,str):\n    raise TypeError(\"option values must be strings\")\n    \n @property\n def converters(self):\n  return self._converters\n  \n  \nclass ConfigParser(RawConfigParser):\n ''\n \n _DEFAULT_INTERPOLATION=BasicInterpolation()\n \n def set(self,section,option,value=None ):\n  ''\n  \n  self._validate_value_types(option=option,value=value)\n  super().set(section,option,value)\n  \n def add_section(self,section):\n  ''\n\n  \n  self._validate_value_types(section=section)\n  super().add_section(section)\n  \n def _read_defaults(self,defaults):\n  ''\n\n\n\n  \n  try :\n   hold_interpolation=self._interpolation\n   self._interpolation=Interpolation()\n   self.read_dict({self.default_section:defaults})\n  finally :\n   self._interpolation=hold_interpolation\n   \n   \nclass SafeConfigParser(ConfigParser):\n ''\n \n def __init__(self,*args,**kwargs):\n  super().__init__(*args,**kwargs)\n  warnings.warn(\n  \"The SafeConfigParser class has been renamed to ConfigParser \"\n  \"in Python 3.2. This alias will be removed in future versions.\"\n  \" Use ConfigParser directly instead.\",\n  DeprecationWarning,stacklevel=2\n  )\n  \n  \nclass SectionProxy(MutableMapping):\n ''\n \n def __init__(self,parser,name):\n  ''\n  self._parser=parser\n  self._name=name\n  for conv in parser.converters:\n   key='get'+conv\n   getter=functools.partial(self.get,_impl=getattr(parser,key))\n   setattr(self,key,getter)\n   \n def __repr__(self):\n  return '<Section: {}>'.format(self._name)\n  \n def __getitem__(self,key):\n  if not self._parser.has_option(self._name,key):\n   raise KeyError(key)\n  return self._parser.get(self._name,key)\n  \n def __setitem__(self,key,value):\n  self._parser._validate_value_types(option=key,value=value)\n  return self._parser.set(self._name,key,value)\n  \n def __delitem__(self,key):\n  if not (self._parser.has_option(self._name,key)and\n  self._parser.remove_option(self._name,key)):\n   raise KeyError(key)\n   \n def __contains__(self,key):\n  return self._parser.has_option(self._name,key)\n  \n def __len__(self):\n  return len(self._options())\n  \n def __iter__(self):\n  return self._options().__iter__()\n  \n def _options(self):\n  if self._name !=self._parser.default_section:\n   return self._parser.options(self._name)\n  else :\n   return self._parser.defaults()\n   \n @property\n def parser(self):\n \n  return self._parser\n  \n @property\n def name(self):\n \n  return self._name\n  \n def get(self,option,fallback=None ,*,raw=False ,vars=None ,\n _impl=None ,**kwargs):\n  ''\n\n\n\n\n  \n  \n  \n  if not _impl:\n   _impl=self._parser.get\n  return _impl(self._name,option,raw=raw,vars=vars,\n  fallback=fallback,**kwargs)\n  \n  \nclass ConverterMapping(MutableMapping):\n ''\n\n\n\n\n \n \n GETTERCRE=re.compile(r\"^get(?P<name>.+)$\")\n \n def __init__(self,parser):\n  self._parser=parser\n  self._data={}\n  for getter in dir(self._parser):\n   m=self.GETTERCRE.match(getter)\n   if not m or not callable(getattr(self._parser,getter)):\n    continue\n   self._data[m.group('name')]=None\n   \n def __getitem__(self,key):\n  return self._data[key]\n  \n def __setitem__(self,key,value):\n  try :\n   k='get'+key\n  except TypeError:\n   raise ValueError('Incompatible key: {} (type: {})'\n   ''.format(key,type(key)))\n  if k =='get':\n   raise ValueError('Incompatible key: cannot use \"\" as a name')\n  self._data[key]=value\n  func=functools.partial(self._parser._get_conv,conv=value)\n  func.converter=value\n  setattr(self._parser,k,func)\n  for proxy in self._parser.values():\n   getter=functools.partial(proxy.get,_impl=func)\n   setattr(proxy,k,getter)\n   \n def __delitem__(self,key):\n  try :\n   k='get'+(key or None )\n  except TypeError:\n   raise KeyError(key)\n  del self._data[key]\n  for inst in itertools.chain((self._parser,),self._parser.values()):\n   try :\n    delattr(inst,k)\n   except AttributeError:\n   \n   \n    continue\n    \n def __iter__(self):\n  return iter(self._data)\n  \n def __len__(self):\n  return len(self._data)\n", ["collections", "collections.abc", "functools", "io", "itertools", "os", "re", "sys", "warnings"]], "contextlib": [".py", "''\nimport abc\nimport sys\nimport _collections_abc\nfrom collections import deque\nfrom functools import wraps\n\n__all__=[\"asynccontextmanager\",\"contextmanager\",\"closing\",\"nullcontext\",\n\"AbstractContextManager\",\"AbstractAsyncContextManager\",\n\"AsyncExitStack\",\"ContextDecorator\",\"ExitStack\",\n\"redirect_stdout\",\"redirect_stderr\",\"suppress\"]\n\n\nclass AbstractContextManager(abc.ABC):\n\n ''\n \n def __enter__(self):\n  ''\n  return self\n  \n @abc.abstractmethod\n def __exit__(self,exc_type,exc_value,traceback):\n  ''\n  return None\n  \n @classmethod\n def __subclasshook__(cls,C):\n  if cls is AbstractContextManager:\n   return _collections_abc._check_methods(C,\"__enter__\",\"__exit__\")\n  return NotImplemented\n  \n  \nclass AbstractAsyncContextManager(abc.ABC):\n\n ''\n \n async def __aenter__(self):\n  ''\n  return self\n  \n @abc.abstractmethod\n async def __aexit__(self,exc_type,exc_value,traceback):\n  ''\n  return None\n  \n @classmethod\n def __subclasshook__(cls,C):\n  if cls is AbstractAsyncContextManager:\n   return _collections_abc._check_methods(C,\"__aenter__\",\n   \"__aexit__\")\n  return NotImplemented\n  \n  \nclass ContextDecorator(object):\n ''\n \n def _recreate_cm(self):\n  ''\n\n\n\n\n\n\n\n  \n  return self\n  \n def __call__(self,func):\n  @wraps(func)\n  def inner(*args,**kwds):\n   with self._recreate_cm():\n    return func(*args,**kwds)\n  return inner\n  \n  \nclass _GeneratorContextManagerBase:\n ''\n \n def __init__(self,func,args,kwds):\n  self.gen=func(*args,**kwds)\n  self.func,self.args,self.kwds=func,args,kwds\n  \n  doc=getattr(func,\"__doc__\",None )\n  if doc is None :\n   doc=type(self).__doc__\n  self.__doc__=doc\n  \n  \n  \n  \n  \n  \n  \nclass _GeneratorContextManager(_GeneratorContextManagerBase,\nAbstractContextManager,\nContextDecorator):\n ''\n \n def _recreate_cm(self):\n \n \n \n  return self.__class__(self.func,self.args,self.kwds)\n  \n def __enter__(self):\n \n \n  del self.args,self.kwds,self.func\n  try :\n   return next(self.gen)\n  except StopIteration:\n   raise RuntimeError(\"generator didn't yield\")from None\n   \n def __exit__(self,type,value,traceback):\n  if type is None :\n   try :\n    next(self.gen)\n   except StopIteration:\n    return False\n   else :\n    raise RuntimeError(\"generator didn't stop\")\n  else :\n   if value is None :\n   \n   \n    value=type()\n   try :\n    self.gen.throw(type,value,traceback)\n   except StopIteration as exc:\n   \n   \n   \n    return exc is not value\n   except RuntimeError as exc:\n   \n    if exc is value:\n     return False\n     \n     \n     \n    if type is StopIteration and exc.__cause__ is value:\n     return False\n    raise\n   except :\n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n    if sys.exc_info()[1]is value:\n     return False\n    raise\n   raise RuntimeError(\"generator didn't stop after throw()\")\n   \n   \nclass _AsyncGeneratorContextManager(_GeneratorContextManagerBase,\nAbstractAsyncContextManager):\n ''\n \n async def __aenter__(self):\n  try :\n   return await self.gen.__anext__()\n  except StopAsyncIteration:\n   raise RuntimeError(\"generator didn't yield\")from None\n   \n async def __aexit__(self,typ,value,traceback):\n  if typ is None :\n   try :\n    await self.gen.__anext__()\n   except StopAsyncIteration:\n    return\n   else :\n    raise RuntimeError(\"generator didn't stop\")\n  else :\n   if value is None :\n    value=typ()\n    \n    \n   try :\n    await self.gen.athrow(typ,value,traceback)\n    raise RuntimeError(\"generator didn't stop after throw()\")\n   except StopAsyncIteration as exc:\n    return exc is not value\n   except RuntimeError as exc:\n    if exc is value:\n     return False\n     \n     \n     \n     \n     \n     \n    if isinstance(value,(StopIteration,StopAsyncIteration)):\n     if exc.__cause__ is value:\n      return False\n    raise\n   except BaseException as exc:\n    if exc is not value:\n     raise\n     \n     \ndef contextmanager(func):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n @wraps(func)\n def helper(*args,**kwds):\n  return _GeneratorContextManager(func,args,kwds)\n return helper\n \n \ndef asynccontextmanager(func):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n @wraps(func)\n def helper(*args,**kwds):\n  return _AsyncGeneratorContextManager(func,args,kwds)\n return helper\n \n \nclass closing(AbstractContextManager):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n def __init__(self,thing):\n  self.thing=thing\n def __enter__(self):\n  return self.thing\n def __exit__(self,*exc_info):\n  self.thing.close()\n  \n  \nclass _RedirectStream(AbstractContextManager):\n\n _stream=None\n \n def __init__(self,new_target):\n  self._new_target=new_target\n  \n  self._old_targets=[]\n  \n def __enter__(self):\n  self._old_targets.append(getattr(sys,self._stream))\n  setattr(sys,self._stream,self._new_target)\n  return self._new_target\n  \n def __exit__(self,exctype,excinst,exctb):\n  setattr(sys,self._stream,self._old_targets.pop())\n  \n  \nclass redirect_stdout(_RedirectStream):\n ''\n\n\n\n\n\n\n\n\n\n \n \n _stream=\"stdout\"\n \n \nclass redirect_stderr(_RedirectStream):\n ''\n \n _stream=\"stderr\"\n \n \nclass suppress(AbstractContextManager):\n ''\n\n\n\n\n\n\n\n \n \n def __init__(self,*exceptions):\n  self._exceptions=exceptions\n  \n def __enter__(self):\n  pass\n  \n def __exit__(self,exctype,excinst,exctb):\n \n \n \n \n \n \n \n \n \n  return exctype is not None and issubclass(exctype,self._exceptions)\n  \n  \nclass _BaseExitStack:\n ''\n \n @staticmethod\n def _create_exit_wrapper(cm,cm_exit):\n  def _exit_wrapper(exc_type,exc,tb):\n   return cm_exit(cm,exc_type,exc,tb)\n  return _exit_wrapper\n  \n @staticmethod\n def _create_cb_wrapper(callback,*args,**kwds):\n  def _exit_wrapper(exc_type,exc,tb):\n   callback(*args,**kwds)\n  return _exit_wrapper\n  \n def __init__(self):\n  self._exit_callbacks=deque()\n  \n def pop_all(self):\n  ''\n  new_stack=type(self)()\n  new_stack._exit_callbacks=self._exit_callbacks\n  self._exit_callbacks=deque()\n  return new_stack\n  \n def push(self,exit):\n  ''\n\n\n\n\n  \n  \n  \n  _cb_type=type(exit)\n  \n  try :\n   exit_method=_cb_type.__exit__\n  except AttributeError:\n  \n   self._push_exit_callback(exit)\n  else :\n   self._push_cm_exit(exit,exit_method)\n  return exit\n  \n def enter_context(self,cm):\n  ''\n\n\n\n  \n  \n  \n  _cm_type=type(cm)\n  _exit=_cm_type.__exit__\n  result=_cm_type.__enter__(cm)\n  self._push_cm_exit(cm,_exit)\n  return result\n  \n def callback(self,callback,*args,**kwds):\n  ''\n\n\n  \n  _exit_wrapper=self._create_cb_wrapper(callback,*args,**kwds)\n  \n  \n  \n  _exit_wrapper.__wrapped__=callback\n  self._push_exit_callback(_exit_wrapper)\n  return callback\n  \n def _push_cm_exit(self,cm,cm_exit):\n  ''\n  _exit_wrapper=self._create_exit_wrapper(cm,cm_exit)\n  _exit_wrapper.__self__=cm\n  self._push_exit_callback(_exit_wrapper,True )\n  \n def _push_exit_callback(self,callback,is_sync=True ):\n  self._exit_callbacks.append((is_sync,callback))\n  \n  \n  \nclass ExitStack(_BaseExitStack,AbstractContextManager):\n ''\n\n\n\n\n\n\n\n \n \n def __enter__(self):\n  return self\n  \n def __exit__(self,*exc_details):\n  received_exc=exc_details[0]is not None\n  \n  \n  \n  frame_exc=sys.exc_info()[1]\n  def _fix_exception_context(new_exc,old_exc):\n  \n   while 1:\n    exc_context=new_exc.__context__\n    if exc_context is old_exc:\n    \n     return\n    if exc_context is None or exc_context is frame_exc:\n     break\n    new_exc=exc_context\n    \n    \n   new_exc.__context__=old_exc\n   \n   \n   \n  suppressed_exc=False\n  pending_raise=False\n  while self._exit_callbacks:\n   is_sync,cb=self._exit_callbacks.pop()\n   assert is_sync\n   try :\n    if cb(*exc_details):\n     suppressed_exc=True\n     pending_raise=False\n     exc_details=(None ,None ,None )\n   except :\n    new_exc_details=sys.exc_info()\n    \n    _fix_exception_context(new_exc_details[1],exc_details[1])\n    pending_raise=True\n    exc_details=new_exc_details\n  if pending_raise:\n   try :\n   \n   \n    fixed_ctx=exc_details[1].__context__\n    raise exc_details[1]\n   except BaseException:\n    exc_details[1].__context__=fixed_ctx\n    raise\n  return received_exc and suppressed_exc\n  \n def close(self):\n  ''\n  self.__exit__(None ,None ,None )\n  \n  \n  \nclass AsyncExitStack(_BaseExitStack,AbstractAsyncContextManager):\n ''\n\n\n\n\n\n\n\n\n\n \n \n @staticmethod\n def _create_async_exit_wrapper(cm,cm_exit):\n  async def _exit_wrapper(exc_type,exc,tb):\n   return await cm_exit(cm,exc_type,exc,tb)\n  return _exit_wrapper\n  \n @staticmethod\n def _create_async_cb_wrapper(callback,*args,**kwds):\n  async def _exit_wrapper(exc_type,exc,tb):\n   await callback(*args,**kwds)\n  return _exit_wrapper\n  \n async def enter_async_context(self,cm):\n  ''\n\n\n\n  \n  _cm_type=type(cm)\n  _exit=_cm_type.__aexit__\n  result=await _cm_type.__aenter__(cm)\n  self._push_async_cm_exit(cm,_exit)\n  return result\n  \n def push_async_exit(self,exit):\n  ''\n\n\n\n\n\n  \n  _cb_type=type(exit)\n  try :\n   exit_method=_cb_type.__aexit__\n  except AttributeError:\n  \n   self._push_exit_callback(exit,False )\n  else :\n   self._push_async_cm_exit(exit,exit_method)\n  return exit\n  \n def push_async_callback(self,callback,*args,**kwds):\n  ''\n\n\n  \n  _exit_wrapper=self._create_async_cb_wrapper(callback,*args,**kwds)\n  \n  \n  \n  _exit_wrapper.__wrapped__=callback\n  self._push_exit_callback(_exit_wrapper,False )\n  return callback\n  \n async def aclose(self):\n  ''\n  await self.__aexit__(None ,None ,None )\n  \n def _push_async_cm_exit(self,cm,cm_exit):\n  ''\n  \n  _exit_wrapper=self._create_async_exit_wrapper(cm,cm_exit)\n  _exit_wrapper.__self__=cm\n  self._push_exit_callback(_exit_wrapper,False )\n  \n async def __aenter__(self):\n  return self\n  \n async def __aexit__(self,*exc_details):\n  received_exc=exc_details[0]is not None\n  \n  \n  \n  frame_exc=sys.exc_info()[1]\n  def _fix_exception_context(new_exc,old_exc):\n  \n   while 1:\n    exc_context=new_exc.__context__\n    if exc_context is old_exc:\n    \n     return\n    if exc_context is None or exc_context is frame_exc:\n     break\n    new_exc=exc_context\n    \n    \n   new_exc.__context__=old_exc\n   \n   \n   \n  suppressed_exc=False\n  pending_raise=False\n  while self._exit_callbacks:\n   is_sync,cb=self._exit_callbacks.pop()\n   try :\n    if is_sync:\n     cb_suppress=cb(*exc_details)\n    else :\n     cb_suppress=await cb(*exc_details)\n     \n    if cb_suppress:\n     suppressed_exc=True\n     pending_raise=False\n     exc_details=(None ,None ,None )\n   except :\n    new_exc_details=sys.exc_info()\n    \n    _fix_exception_context(new_exc_details[1],exc_details[1])\n    pending_raise=True\n    exc_details=new_exc_details\n  if pending_raise:\n   try :\n   \n   \n    fixed_ctx=exc_details[1].__context__\n    raise exc_details[1]\n   except BaseException:\n    exc_details[1].__context__=fixed_ctx\n    raise\n  return received_exc and suppressed_exc\n  \n  \nclass nullcontext(AbstractContextManager):\n ''\n\n\n\n\n\n\n\n \n \n def __init__(self,enter_result=None ):\n  self.enter_result=enter_result\n  \n def __enter__(self):\n  return self.enter_result\n  \n def __exit__(self,*excinfo):\n  pass\n", ["_collections_abc", "abc", "collections", "functools", "sys"]], "contextvars": [".py", "from _contextvars import Context,ContextVar,Token,copy_context\n\n\n__all__=('Context','ContextVar','Token','copy_context')\n", ["_contextvars"]], "copy": [".py", "''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nimport types\nimport weakref\nfrom copyreg import dispatch_table\n\nclass Error(Exception):\n pass\nerror=Error\n\ntry :\n from org.python.core import PyStringMap\nexcept ImportError:\n PyStringMap=None\n \n__all__=[\"Error\",\"copy\",\"deepcopy\"]\n\ndef copy(x):\n ''\n\n\n \n \n cls=type(x)\n \n copier=_copy_dispatch.get(cls)\n if copier:\n  return copier(x)\n  \n try :\n  issc=issubclass(cls,type)\n except TypeError:\n  issc=False\n if issc:\n \n  return _copy_immutable(x)\n  \n copier=getattr(cls,\"__copy__\",None )\n if copier:\n  return copier(x)\n  \n reductor=dispatch_table.get(cls)\n if reductor:\n  rv=reductor(x)\n else :\n  reductor=getattr(x,\"__reduce_ex__\",None )\n  if reductor:\n   rv=reductor(4)\n  else :\n   reductor=getattr(x,\"__reduce__\",None )\n   if reductor:\n    rv=reductor()\n   else :\n    raise Error(\"un(shallow)copyable object of type %s\"%cls)\n    \n if isinstance(rv,str):\n  return x\n return _reconstruct(x,None ,*rv)\n \n \n_copy_dispatch=d={}\n\ndef _copy_immutable(x):\n return x\nfor t in (type(None ),int,float,bool,complex,str,tuple,\nbytes,frozenset,type,range,slice,\ntypes.BuiltinFunctionType,type(Ellipsis),type(NotImplemented),\ntypes.FunctionType,weakref.ref):\n d[t]=_copy_immutable\nt=getattr(types,\"CodeType\",None )\nif t is not None :\n d[t]=_copy_immutable\n \nd[list]=list.copy\nd[dict]=dict.copy\nd[set]=set.copy\nd[bytearray]=bytearray.copy\n\nif PyStringMap is not None :\n d[PyStringMap]=PyStringMap.copy\n \ndel d,t\n\ndef deepcopy(x,memo=None ,_nil=[]):\n ''\n\n\n \n \n if memo is None :\n  memo={}\n  \n d=id(x)\n y=memo.get(d,_nil)\n if y is not _nil:\n  return y\n  \n cls=type(x)\n \n copier=_deepcopy_dispatch.get(cls)\n if copier:\n  y=copier(x,memo)\n else :\n  try :\n   issc=issubclass(cls,type)\n  except TypeError:\n   issc=0\n  if issc:\n   y=_deepcopy_atomic(x,memo)\n  else :\n   copier=getattr(x,\"__deepcopy__\",None )\n   if copier:\n    y=copier(memo)\n   else :\n    reductor=dispatch_table.get(cls)\n    if reductor:\n     rv=reductor(x)\n    else :\n     reductor=getattr(x,\"__reduce_ex__\",None )\n     if reductor:\n      rv=reductor(4)\n     else :\n      reductor=getattr(x,\"__reduce__\",None )\n      if reductor:\n       rv=reductor()\n      else :\n       raise Error(\n       \"un(deep)copyable object of type %s\"%cls)\n    if isinstance(rv,str):\n     y=x\n    else :\n     y=_reconstruct(x,memo,*rv)\n     \n     \n if y is not x:\n  memo[d]=y\n  _keep_alive(x,memo)\n return y\n \n_deepcopy_dispatch=d={}\n\ndef _deepcopy_atomic(x,memo):\n return x\nd[type(None )]=_deepcopy_atomic\nd[type(Ellipsis)]=_deepcopy_atomic\nd[type(NotImplemented)]=_deepcopy_atomic\nd[int]=_deepcopy_atomic\nd[float]=_deepcopy_atomic\nd[bool]=_deepcopy_atomic\nd[complex]=_deepcopy_atomic\nd[bytes]=_deepcopy_atomic\nd[str]=_deepcopy_atomic\ntry :\n d[types.CodeType]=_deepcopy_atomic\nexcept AttributeError:\n pass\nd[type]=_deepcopy_atomic\nd[types.BuiltinFunctionType]=_deepcopy_atomic\nd[types.FunctionType]=_deepcopy_atomic\nd[weakref.ref]=_deepcopy_atomic\n\ndef _deepcopy_list(x,memo,deepcopy=deepcopy):\n y=[]\n memo[id(x)]=y\n append=y.append\n for a in x:\n  append(deepcopy(a,memo))\n return y\nd[list]=_deepcopy_list\n\ndef _deepcopy_tuple(x,memo,deepcopy=deepcopy):\n y=[deepcopy(a,memo)for a in x]\n \n \n try :\n  return memo[id(x)]\n except KeyError:\n  pass\n for k,j in zip(x,y):\n  if k is not j:\n   y=tuple(y)\n   break\n else :\n  y=x\n return y\nd[tuple]=_deepcopy_tuple\n\ndef _deepcopy_dict(x,memo,deepcopy=deepcopy):\n y={}\n memo[id(x)]=y\n for key,value in x.items():\n  y[deepcopy(key,memo)]=deepcopy(value,memo)\n return y\nd[dict]=_deepcopy_dict\nif PyStringMap is not None :\n d[PyStringMap]=_deepcopy_dict\n \ndef _deepcopy_method(x,memo):\n return type(x)(x.__func__,deepcopy(x.__self__,memo))\nd[types.MethodType]=_deepcopy_method\n\ndel d\n\ndef _keep_alive(x,memo):\n ''\n\n\n\n\n\n\n\n \n try :\n  memo[id(memo)].append(x)\n except KeyError:\n \n  memo[id(memo)]=[x]\n  \ndef _reconstruct(x,memo,func,args,\nstate=None ,listiter=None ,dictiter=None ,\ndeepcopy=deepcopy):\n deep=memo is not None\n if deep and args:\n  args=(deepcopy(arg,memo)for arg in args)\n y=func(*args)\n if deep:\n  memo[id(x)]=y\n  \n if state is not None :\n  if deep:\n   state=deepcopy(state,memo)\n  if hasattr(y,'__setstate__'):\n   y.__setstate__(state)\n  else :\n   if isinstance(state,tuple)and len(state)==2:\n    state,slotstate=state\n   else :\n    slotstate=None\n   if state is not None :\n    y.__dict__.update(state)\n   if slotstate is not None :\n    for key,value in slotstate.items():\n     setattr(y,key,value)\n     \n if listiter is not None :\n  if deep:\n   for item in listiter:\n    item=deepcopy(item,memo)\n    y.append(item)\n  else :\n   for item in listiter:\n    y.append(item)\n if dictiter is not None :\n  if deep:\n   for key,value in dictiter:\n    key=deepcopy(key,memo)\n    value=deepcopy(value,memo)\n    y[key]=value\n  else :\n   for key,value in dictiter:\n    y[key]=value\n return y\n \ndel types,weakref,PyStringMap\n", ["copyreg", "org.python.core", "types", "weakref"]], "copyreg": [".py", "''\n\n\n\n\n\n__all__=[\"pickle\",\"constructor\",\n\"add_extension\",\"remove_extension\",\"clear_extension_cache\"]\n\ndispatch_table={}\n\ndef pickle(ob_type,pickle_function,constructor_ob=None ):\n if not callable(pickle_function):\n  raise TypeError(\"reduction functions must be callable\")\n dispatch_table[ob_type]=pickle_function\n \n \n \n if constructor_ob is not None :\n  constructor(constructor_ob)\n  \ndef constructor(object):\n if not callable(object):\n  raise TypeError(\"constructors must be callable\")\n  \n  \n  \ntry :\n complex\nexcept NameError:\n pass\nelse :\n\n def pickle_complex(c):\n  return complex,(c.real,c.imag)\n  \n pickle(complex,pickle_complex,complex)\n \n \n \ndef _reconstructor(cls,base,state):\n if base is object:\n  obj=object.__new__(cls)\n else :\n  obj=base.__new__(cls,state)\n  if base.__init__ !=object.__init__:\n   base.__init__(obj,state)\n return obj\n \n_HEAPTYPE=1 <<9\n\n\n\ndef _reduce_ex(self,proto):\n assert proto <2\n for base in self.__class__.__mro__:\n  if hasattr(base,'__flags__')and not base.__flags__&_HEAPTYPE:\n   break\n else :\n  base=object\n if base is object:\n  state=None\n else :\n  if base is self.__class__:\n   raise TypeError(\"can't pickle %s objects\"%base.__name__)\n  state=base(self)\n args=(self.__class__,base,state)\n try :\n  getstate=self.__getstate__\n except AttributeError:\n  if getattr(self,\"__slots__\",None ):\n   raise TypeError(\"a class that defines __slots__ without \"\n   \"defining __getstate__ cannot be pickled\")from None\n  try :\n   dict=self.__dict__\n  except AttributeError:\n   dict=None\n else :\n  dict=getstate()\n if dict:\n  return _reconstructor,args,dict\n else :\n  return _reconstructor,args\n  \n  \n  \ndef __newobj__(cls,*args):\n return cls.__new__(cls,*args)\n \ndef __newobj_ex__(cls,args,kwargs):\n ''\n\n \n return cls.__new__(cls,*args,**kwargs)\n \ndef _slotnames(cls):\n ''\n\n\n\n\n\n\n\n \n \n \n names=cls.__dict__.get(\"__slotnames__\")\n if names is not None :\n  return names\n  \n  \n names=[]\n if not hasattr(cls,\"__slots__\"):\n \n  pass\n else :\n \n  for c in cls.__mro__:\n   if \"__slots__\"in c.__dict__:\n    slots=c.__dict__['__slots__']\n    \n    if isinstance(slots,str):\n     slots=(slots,)\n    for name in slots:\n    \n     if name in (\"__dict__\",\"__weakref__\"):\n      continue\n      \n     elif name.startswith('__')and not name.endswith('__'):\n      stripped=c.__name__.lstrip('_')\n      if stripped:\n       names.append('_%s%s'%(stripped,name))\n      else :\n       names.append(name)\n     else :\n      names.append(name)\n      \n      \n try :\n  cls.__slotnames__=names\n except :\n  pass\n  \n return names\n \n \n \n \n \n \n \n \n \n \n_extension_registry={}\n_inverted_registry={}\n_extension_cache={}\n\n\n\ndef add_extension(module,name,code):\n ''\n code=int(code)\n if not 1 <=code <=0x7fffffff:\n  raise ValueError(\"code out of range\")\n key=(module,name)\n if (_extension_registry.get(key)==code and\n _inverted_registry.get(code)==key):\n  return\n if key in _extension_registry:\n  raise ValueError(\"key %s is already registered with code %s\"%\n  (key,_extension_registry[key]))\n if code in _inverted_registry:\n  raise ValueError(\"code %s is already in use for key %s\"%\n  (code,_inverted_registry[code]))\n _extension_registry[key]=code\n _inverted_registry[code]=key\n \ndef remove_extension(module,name,code):\n ''\n key=(module,name)\n if (_extension_registry.get(key)!=code or\n _inverted_registry.get(code)!=key):\n  raise ValueError(\"key %s is not registered with code %s\"%\n  (key,code))\n del _extension_registry[key]\n del _inverted_registry[code]\n if code in _extension_cache:\n  del _extension_cache[code]\n  \ndef clear_extension_cache():\n _extension_cache.clear()\n \n \n \n \n \n \n \n \n \n \n \n \n \n", []], "csv": [".py", "\n\"\"\"\ncsv.py - read/write/investigate CSV files\n\"\"\"\n\nimport re\nfrom _csv import Error,__version__,writer,reader,register_dialect,\\\nunregister_dialect,get_dialect,list_dialects,\\\nfield_size_limit,\\\nQUOTE_MINIMAL,QUOTE_ALL,QUOTE_NONNUMERIC,QUOTE_NONE,\\\n__doc__\nfrom _csv import Dialect as _Dialect\n\nfrom collections import OrderedDict\nfrom io import StringIO\n\n__all__=[\"QUOTE_MINIMAL\",\"QUOTE_ALL\",\"QUOTE_NONNUMERIC\",\"QUOTE_NONE\",\n\"Error\",\"Dialect\",\"__doc__\",\"excel\",\"excel_tab\",\n\"field_size_limit\",\"reader\",\"writer\",\n\"register_dialect\",\"get_dialect\",\"list_dialects\",\"Sniffer\",\n\"unregister_dialect\",\"__version__\",\"DictReader\",\"DictWriter\",\n\"unix_dialect\"]\n\nclass Dialect:\n ''\n\n\n\n\n\n \n _name=\"\"\n _valid=False\n \n delimiter=None\n quotechar=None\n escapechar=None\n doublequote=None\n skipinitialspace=None\n lineterminator=None\n quoting=None\n \n def __init__(self):\n  if self.__class__ !=Dialect:\n   self._valid=True\n  self._validate()\n  \n def _validate(self):\n  try :\n   _Dialect(self)\n  except TypeError as e:\n  \n   raise Error(str(e))\n   \nclass excel(Dialect):\n ''\n delimiter=','\n quotechar='\"'\n doublequote=True\n skipinitialspace=False\n lineterminator='\\r\\n'\n quoting=QUOTE_MINIMAL\nregister_dialect(\"excel\",excel)\n\nclass excel_tab(excel):\n ''\n delimiter='\\t'\nregister_dialect(\"excel-tab\",excel_tab)\n\nclass unix_dialect(Dialect):\n ''\n delimiter=','\n quotechar='\"'\n doublequote=True\n skipinitialspace=False\n lineterminator='\\n'\n quoting=QUOTE_ALL\nregister_dialect(\"unix\",unix_dialect)\n\n\nclass DictReader:\n def __init__(self,f,fieldnames=None ,restkey=None ,restval=None ,\n dialect=\"excel\",*args,**kwds):\n  self._fieldnames=fieldnames\n  self.restkey=restkey\n  self.restval=restval\n  self.reader=reader(f,dialect,*args,**kwds)\n  self.dialect=dialect\n  self.line_num=0\n  \n def __iter__(self):\n  return self\n  \n @property\n def fieldnames(self):\n  if self._fieldnames is None :\n   try :\n    self._fieldnames=next(self.reader)\n   except StopIteration:\n    pass\n  self.line_num=self.reader.line_num\n  return self._fieldnames\n  \n @fieldnames.setter\n def fieldnames(self,value):\n  self._fieldnames=value\n  \n def __next__(self):\n  if self.line_num ==0:\n  \n   self.fieldnames\n  row=next(self.reader)\n  self.line_num=self.reader.line_num\n  \n  \n  \n  \n  while row ==[]:\n   row=next(self.reader)\n  d=OrderedDict(zip(self.fieldnames,row))\n  lf=len(self.fieldnames)\n  lr=len(row)\n  if lf <lr:\n   d[self.restkey]=row[lf:]\n  elif lf >lr:\n   for key in self.fieldnames[lr:]:\n    d[key]=self.restval\n  return d\n  \n  \nclass DictWriter:\n def __init__(self,f,fieldnames,restval=\"\",extrasaction=\"raise\",\n dialect=\"excel\",*args,**kwds):\n  self.fieldnames=fieldnames\n  self.restval=restval\n  if extrasaction.lower()not in (\"raise\",\"ignore\"):\n   raise ValueError(\"extrasaction (%s) must be 'raise' or 'ignore'\"\n   %extrasaction)\n  self.extrasaction=extrasaction\n  self.writer=writer(f,dialect,*args,**kwds)\n  \n def writeheader(self):\n  header=dict(zip(self.fieldnames,self.fieldnames))\n  self.writerow(header)\n  \n def _dict_to_list(self,rowdict):\n  if self.extrasaction ==\"raise\":\n   wrong_fields=rowdict.keys()-self.fieldnames\n   if wrong_fields:\n    raise ValueError(\"dict contains fields not in fieldnames: \"\n    +\", \".join([repr(x)for x in wrong_fields]))\n  return (rowdict.get(key,self.restval)for key in self.fieldnames)\n  \n def writerow(self,rowdict):\n  return self.writer.writerow(self._dict_to_list(rowdict))\n  \n def writerows(self,rowdicts):\n  return self.writer.writerows(map(self._dict_to_list,rowdicts))\n  \n  \ntry :\n complex\nexcept NameError:\n complex=float\n \nclass Sniffer:\n ''\n\n\n \n def __init__(self):\n \n  self.preferred=[',','\\t',';',' ',':']\n  \n  \n def sniff(self,sample,delimiters=None ):\n  ''\n\n  \n  \n  quotechar,doublequote,delimiter,skipinitialspace=\\\n  self._guess_quote_and_delimiter(sample,delimiters)\n  if not delimiter:\n   delimiter,skipinitialspace=self._guess_delimiter(sample,\n   delimiters)\n   \n  if not delimiter:\n   raise Error(\"Could not determine delimiter\")\n   \n  class dialect(Dialect):\n   _name=\"sniffed\"\n   lineterminator='\\r\\n'\n   quoting=QUOTE_MINIMAL\n   \n   \n  dialect.doublequote=doublequote\n  dialect.delimiter=delimiter\n  \n  dialect.quotechar=quotechar or '\"'\n  dialect.skipinitialspace=skipinitialspace\n  \n  return dialect\n  \n  \n def _guess_quote_and_delimiter(self,data,delimiters):\n  ''\n\n\n\n\n\n\n\n\n  \n  \n  matches=[]\n  for restr in (r'(?P<delim>[^\\w\\n\"\\'])(?P<space> ?)(?P<quote>[\"\\']).*?(?P=quote)(?P=delim)',\n  r'(?:^|\\n)(?P<quote>[\"\\']).*?(?P=quote)(?P<delim>[^\\w\\n\"\\'])(?P<space> ?)',\n  r'(?P<delim>[^\\w\\n\"\\'])(?P<space> ?)(?P<quote>[\"\\']).*?(?P=quote)(?:$|\\n)',\n  r'(?:^|\\n)(?P<quote>[\"\\']).*?(?P=quote)(?:$|\\n)'):\n   regexp=re.compile(restr,re.DOTALL |re.MULTILINE)\n   matches=regexp.findall(data)\n   if matches:\n    break\n    \n  if not matches:\n  \n   return ('',False ,None ,0)\n  quotes={}\n  delims={}\n  spaces=0\n  groupindex=regexp.groupindex\n  for m in matches:\n   n=groupindex['quote']-1\n   key=m[n]\n   if key:\n    quotes[key]=quotes.get(key,0)+1\n   try :\n    n=groupindex['delim']-1\n    key=m[n]\n   except KeyError:\n    continue\n   if key and (delimiters is None or key in delimiters):\n    delims[key]=delims.get(key,0)+1\n   try :\n    n=groupindex['space']-1\n   except KeyError:\n    continue\n   if m[n]:\n    spaces +=1\n    \n  quotechar=max(quotes,key=quotes.get)\n  \n  if delims:\n   delim=max(delims,key=delims.get)\n   skipinitialspace=delims[delim]==spaces\n   if delim =='\\n':\n    delim=''\n  else :\n  \n   delim=''\n   skipinitialspace=0\n   \n   \n   \n  dq_regexp=re.compile(\n  r\"((%(delim)s)|^)\\W*%(quote)s[^%(delim)s\\n]*%(quote)s[^%(delim)s\\n]*%(quote)s\\W*((%(delim)s)|$)\"%\\\n  {'delim':re.escape(delim),'quote':quotechar},re.MULTILINE)\n  \n  \n  \n  if dq_regexp.search(data):\n   doublequote=True\n  else :\n   doublequote=False\n   \n  return (quotechar,doublequote,delim,skipinitialspace)\n  \n  \n def _guess_delimiter(self,data,delimiters):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  \n  data=list(filter(None ,data.split('\\n')))\n  \n  ascii=[chr(c)for c in range(127)]\n  \n  \n  chunkLength=min(10,len(data))\n  iteration=0\n  charFrequency={}\n  modes={}\n  delims={}\n  start,end=0,chunkLength\n  while start <len(data):\n   iteration +=1\n   for line in data[start:end]:\n    for char in ascii:\n     metaFrequency=charFrequency.get(char,{})\n     \n     freq=line.count(char)\n     \n     metaFrequency[freq]=metaFrequency.get(freq,0)+1\n     charFrequency[char]=metaFrequency\n     \n   for char in charFrequency.keys():\n    items=list(charFrequency[char].items())\n    if len(items)==1 and items[0][0]==0:\n     continue\n     \n    if len(items)>1:\n     modes[char]=max(items,key=lambda x:x[1])\n     \n     \n     items.remove(modes[char])\n     modes[char]=(modes[char][0],modes[char][1]\n     -sum(item[1]for item in items))\n    else :\n     modes[char]=items[0]\n     \n     \n   modeList=modes.items()\n   total=float(min(chunkLength *iteration,len(data)))\n   \n   consistency=1.0\n   \n   threshold=0.9\n   while len(delims)==0 and consistency >=threshold:\n    for k,v in modeList:\n     if v[0]>0 and v[1]>0:\n      if ((v[1]/total)>=consistency and\n      (delimiters is None or k in delimiters)):\n       delims[k]=v\n    consistency -=0.01\n    \n   if len(delims)==1:\n    delim=list(delims.keys())[0]\n    skipinitialspace=(data[0].count(delim)==\n    data[0].count(\"%c \"%delim))\n    return (delim,skipinitialspace)\n    \n    \n   start=end\n   end +=chunkLength\n   \n  if not delims:\n   return ('',0)\n   \n   \n  if len(delims)>1:\n   for d in self.preferred:\n    if d in delims.keys():\n     skipinitialspace=(data[0].count(d)==\n     data[0].count(\"%c \"%d))\n     return (d,skipinitialspace)\n     \n     \n     \n  items=[(v,k)for (k,v)in delims.items()]\n  items.sort()\n  delim=items[-1][1]\n  \n  skipinitialspace=(data[0].count(delim)==\n  data[0].count(\"%c \"%delim))\n  return (delim,skipinitialspace)\n  \n  \n def has_header(self,sample):\n \n \n \n \n \n \n \n \n \n  rdr=reader(StringIO(sample),self.sniff(sample))\n  \n  header=next(rdr)\n  \n  columns=len(header)\n  columnTypes={}\n  for i in range(columns):columnTypes[i]=None\n  \n  checked=0\n  for row in rdr:\n  \n   if checked >20:\n    break\n   checked +=1\n   \n   if len(row)!=columns:\n    continue\n    \n   for col in list(columnTypes.keys()):\n   \n    for thisType in [int,float,complex]:\n     try :\n      thisType(row[col])\n      break\n     except (ValueError,OverflowError):\n      pass\n    else :\n    \n     thisType=len(row[col])\n     \n    if thisType !=columnTypes[col]:\n     if columnTypes[col]is None :\n      columnTypes[col]=thisType\n     else :\n     \n     \n      del columnTypes[col]\n      \n      \n      \n  hasHeader=0\n  for col,colType in columnTypes.items():\n   if type(colType)==type(0):\n    if len(header[col])!=colType:\n     hasHeader +=1\n    else :\n     hasHeader -=1\n   else :\n    try :\n     colType(header[col])\n    except (ValueError,TypeError):\n     hasHeader +=1\n    else :\n     hasHeader -=1\n     \n  return hasHeader >0\n", ["_csv", "collections", "io", "re"]], "dataclasses": [".py", "import re\nimport sys\nimport copy\nimport types\nimport inspect\nimport keyword\n\n__all__=['dataclass',\n'field',\n'Field',\n'FrozenInstanceError',\n'InitVar',\n'MISSING',\n\n\n'fields',\n'asdict',\n'astuple',\n'make_dataclass',\n'replace',\n'is_dataclass',\n]\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nclass FrozenInstanceError(AttributeError):pass\n\n\n\n\nclass _HAS_DEFAULT_FACTORY_CLASS:\n def __repr__(self):\n  return '<factory>'\n_HAS_DEFAULT_FACTORY=_HAS_DEFAULT_FACTORY_CLASS()\n\n\n\nclass _MISSING_TYPE:\n pass\nMISSING=_MISSING_TYPE()\n\n\n\n_EMPTY_METADATA=types.MappingProxyType({})\n\n\nclass _FIELD_BASE:\n def __init__(self,name):\n  self.name=name\n def __repr__(self):\n  return self.name\n_FIELD=_FIELD_BASE('_FIELD')\n_FIELD_CLASSVAR=_FIELD_BASE('_FIELD_CLASSVAR')\n_FIELD_INITVAR=_FIELD_BASE('_FIELD_INITVAR')\n\n\n\n_FIELDS='__dataclass_fields__'\n\n\n\n_PARAMS='__dataclass_params__'\n\n\n\n_POST_INIT_NAME='__post_init__'\n\n\n\n\n_MODULE_IDENTIFIER_RE=re.compile(r'^(?:\\s*(\\w+)\\s*\\.)?\\s*(\\w+)')\n\nclass _InitVarMeta(type):\n def __getitem__(self,params):\n  return self\n  \nclass InitVar(metaclass=_InitVarMeta):\n pass\n \n \n \n \n \n \n \n \n \n \n \n \nclass Field:\n __slots__=('name',\n 'type',\n 'default',\n 'default_factory',\n 'repr',\n 'hash',\n 'init',\n 'compare',\n 'metadata',\n '_field_type',\n )\n \n def __init__(self,default,default_factory,init,repr,hash,compare,\n metadata):\n  self.name=None\n  self.type=None\n  self.default=default\n  self.default_factory=default_factory\n  self.init=init\n  self.repr=repr\n  self.hash=hash\n  self.compare=compare\n  self.metadata=(_EMPTY_METADATA\n  if metadata is None or len(metadata)==0 else\n  types.MappingProxyType(metadata))\n  self._field_type=None\n  \n def __repr__(self):\n  return ('Field('\n  f'name={self.name!r},'\n  f'type={self.type!r},'\n  f'default={self.default!r},'\n  f'default_factory={self.default_factory!r},'\n  f'init={self.init!r},'\n  f'repr={self.repr!r},'\n  f'hash={self.hash!r},'\n  f'compare={self.compare!r},'\n  f'metadata={self.metadata!r},'\n  f'_field_type={self._field_type}'\n  ')')\n  \n  \n  \n  \n  \n  \n  \n  \n  \n def __set_name__(self,owner,name):\n  func=getattr(type(self.default),'__set_name__',None )\n  if func:\n  \n  \n   func(self.default,owner,name)\n   \n   \nclass _DataclassParams:\n __slots__=('init',\n 'repr',\n 'eq',\n 'order',\n 'unsafe_hash',\n 'frozen',\n )\n \n def __init__(self,init,repr,eq,order,unsafe_hash,frozen):\n  self.init=init\n  self.repr=repr\n  self.eq=eq\n  self.order=order\n  self.unsafe_hash=unsafe_hash\n  self.frozen=frozen\n  \n def __repr__(self):\n  return ('_DataclassParams('\n  f'init={self.init!r},'\n  f'repr={self.repr!r},'\n  f'eq={self.eq!r},'\n  f'order={self.order!r},'\n  f'unsafe_hash={self.unsafe_hash!r},'\n  f'frozen={self.frozen!r}'\n  ')')\n  \n  \n  \n  \n  \ndef field(*,default=MISSING,default_factory=MISSING,init=True ,repr=True ,\nhash=None ,compare=True ,metadata=None ):\n ''\n\n\n\n\n\n\n\n\n\n\n\n \n \n if default is not MISSING and default_factory is not MISSING:\n  raise ValueError('cannot specify both default and default_factory')\n return Field(default,default_factory,init,repr,hash,compare,\n metadata)\n \n \ndef _tuple_str(obj_name,fields):\n\n\n\n\n\n if not fields:\n  return '()'\n  \n return f'({\",\".join([f\"{obj_name}.{f.name}\" for f in fields])},)'\n \n \ndef _create_fn(name,args,body,*,globals=None ,locals=None ,\nreturn_type=MISSING):\n\n\n\n if locals is None :\n  locals={}\n return_annotation=''\n if return_type is not MISSING:\n  locals['_return_type']=return_type\n  return_annotation='->_return_type'\n args=','.join(args)\n body='\\n'.join(f' {b}'for b in body)\n \n \n txt=f'def {name}({args}){return_annotation}:\\n{body}'\n \n exec(txt,globals,locals)\n return locals[name]\n \n \ndef _field_assign(frozen,name,value,self_name):\n\n\n\n\n\n\n if frozen:\n  return f'object.__setattr__({self_name},{name!r},{value})'\n return f'{self_name}.{name}={value}'\n \n \ndef _field_init(f,frozen,globals,self_name):\n\n\n\n default_name=f'_dflt_{f.name}'\n if f.default_factory is not MISSING:\n  if f.init:\n  \n  \n   globals[default_name]=f.default_factory\n   value=(f'{default_name}() '\n   f'if {f.name} is _HAS_DEFAULT_FACTORY '\n   f'else {f.name}')\n  else :\n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n   globals[default_name]=f.default_factory\n   value=f'{default_name}()'\n else :\n \n  if f.init:\n   if f.default is MISSING:\n   \n    value=f.name\n   elif f.default is not MISSING:\n    globals[default_name]=f.default\n    value=f.name\n  else :\n  \n  \n   return None\n   \n   \n   \n   \n if f._field_type is _FIELD_INITVAR:\n  return None\n  \n  \n return _field_assign(frozen,f.name,value,self_name)\n \n \ndef _init_param(f):\n\n\n\n\n if f.default is MISSING and f.default_factory is MISSING:\n \n \n  default=''\n elif f.default is not MISSING:\n \n \n  default=f'=_dflt_{f.name}'\n elif f.default_factory is not MISSING:\n \n  default='=_HAS_DEFAULT_FACTORY'\n return f'{f.name}:_type_{f.name}{default}'\n \n \ndef _init_fn(fields,frozen,has_post_init,self_name):\n\n\n\n\n\n\n\n seen_default=False\n for f in fields:\n \n  if f.init:\n   if not (f.default is MISSING and f.default_factory is MISSING):\n    seen_default=True\n   elif seen_default:\n    raise TypeError(f'non-default argument {f.name!r} '\n    'follows default argument')\n    \n globals={'MISSING':MISSING,\n '_HAS_DEFAULT_FACTORY':_HAS_DEFAULT_FACTORY}\n \n body_lines=[]\n for f in fields:\n  line=_field_init(f,frozen,globals,self_name)\n  \n  \n  if line:\n   body_lines.append(line)\n   \n   \n if has_post_init:\n  params_str=','.join(f.name for f in fields\n  if f._field_type is _FIELD_INITVAR)\n  body_lines.append(f'{self_name}.{_POST_INIT_NAME}({params_str})')\n  \n  \n if not body_lines:\n  body_lines=['pass']\n  \n locals={f'_type_{f.name}':f.type for f in fields}\n return _create_fn('__init__',\n [self_name]+[_init_param(f)for f in fields if f.init],\n body_lines,\n locals=locals,\n globals=globals,\n return_type=None )\n \n \ndef _repr_fn(fields):\n return _create_fn('__repr__',\n ('self',),\n ['return self.__class__.__qualname__ + f\"('+\n ', '.join([f\"{f.name}={{self.{f.name}!r}}\"\n for f in fields])+\n ')\"'])\n \n \ndef _frozen_get_del_attr(cls,fields):\n\n\n globals={'cls':cls,\n 'FrozenInstanceError':FrozenInstanceError}\n if fields:\n  fields_str='('+','.join(repr(f.name)for f in fields)+',)'\n else :\n \n  fields_str='()'\n return (_create_fn('__setattr__',\n ('self','name','value'),\n (f'if type(self) is cls or name in {fields_str}:',\n ' raise FrozenInstanceError(f\"cannot assign to field {name!r}\")',\n f'super(cls, self).__setattr__(name, value)'),\n globals=globals),\n _create_fn('__delattr__',\n ('self','name'),\n (f'if type(self) is cls or name in {fields_str}:',\n ' raise FrozenInstanceError(f\"cannot delete field {name!r}\")',\n f'super(cls, self).__delattr__(name)'),\n globals=globals),\n )\n \n \ndef _cmp_fn(name,op,self_tuple,other_tuple):\n\n\n\n\n\n return _create_fn(name,\n ('self','other'),\n ['if other.__class__ is self.__class__:',\n f' return {self_tuple}{op}{other_tuple}',\n 'return NotImplemented'])\n \n \ndef _hash_fn(fields):\n self_tuple=_tuple_str('self',fields)\n return _create_fn('__hash__',\n ('self',),\n [f'return hash({self_tuple})'])\n \n \ndef _is_classvar(a_type,typing):\n\n\n return (a_type is typing.ClassVar\n or (type(a_type)is typing._GenericAlias\n and a_type.__origin__ is typing.ClassVar))\n \n \ndef _is_initvar(a_type,dataclasses):\n\n\n return a_type is dataclasses.InitVar\n \n \ndef _is_type(annotation,cls,a_module,a_type,is_type_predicate):\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n match=_MODULE_IDENTIFIER_RE.match(annotation)\n if match:\n  ns=None\n  module_name=match.group(1)\n  if not module_name:\n  \n  \n   ns=sys.modules.get(cls.__module__).__dict__\n  else :\n  \n   module=sys.modules.get(cls.__module__)\n   if module and module.__dict__.get(module_name)is a_module:\n    ns=sys.modules.get(a_type.__module__).__dict__\n  if ns and is_type_predicate(ns.get(match.group(2)),a_module):\n   return True\n return False\n \n \ndef _get_field(cls,a_name,a_type):\n\n\n\n\n\n\n default=getattr(cls,a_name,MISSING)\n if isinstance(default,Field):\n  f=default\n else :\n  if isinstance(default,types.MemberDescriptorType):\n  \n   default=MISSING\n  f=field(default=default)\n  \n  \n f.name=a_name\n f.type=a_type\n \n \n \n \n f._field_type=_FIELD\n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n typing=sys.modules.get('typing')\n if typing:\n  if (_is_classvar(a_type,typing)\n  or (isinstance(f.type,str)\n  and _is_type(f.type,cls,typing,typing.ClassVar,\n  _is_classvar))):\n   f._field_type=_FIELD_CLASSVAR\n   \n   \n   \n if f._field_type is _FIELD:\n \n \n  dataclasses=sys.modules[__name__]\n  if (_is_initvar(a_type,dataclasses)\n  or (isinstance(f.type,str)\n  and _is_type(f.type,cls,dataclasses,dataclasses.InitVar,\n  _is_initvar))):\n   f._field_type=_FIELD_INITVAR\n   \n   \n   \n   \n   \n   \n if f._field_type in (_FIELD_CLASSVAR,_FIELD_INITVAR):\n  if f.default_factory is not MISSING:\n   raise TypeError(f'field {f.name} cannot have a '\n   'default factory')\n   \n   \n   \n   \n   \n   \n   \n if f._field_type is _FIELD and isinstance(f.default,(list,dict,set)):\n  raise ValueError(f'mutable default {type(f.default)} for field '\n  f'{f.name} is not allowed: use default_factory')\n  \n return f\n \n \ndef _set_new_attribute(cls,name,value):\n\n\n if name in cls.__dict__:\n  return True\n setattr(cls,name,value)\n return False\n \n \n \n \n \n \n \ndef _hash_set_none(cls,fields):\n return None\n \ndef _hash_add(cls,fields):\n flds=[f for f in fields if (f.compare if f.hash is None else f.hash)]\n return _hash_fn(flds)\n \ndef _hash_exception(cls,fields):\n\n raise TypeError(f'Cannot overwrite attribute __hash__ '\n f'in class {cls.__name__}')\n \n \n \n \n \n \n \n \n \n \n_hash_action={(False ,False ,False ,False ):None ,\n(False ,False ,False ,True ):None ,\n(False ,False ,True ,False ):None ,\n(False ,False ,True ,True ):None ,\n(False ,True ,False ,False ):_hash_set_none,\n(False ,True ,False ,True ):None ,\n(False ,True ,True ,False ):_hash_add,\n(False ,True ,True ,True ):None ,\n(True ,False ,False ,False ):_hash_add,\n(True ,False ,False ,True ):_hash_exception,\n(True ,False ,True ,False ):_hash_add,\n(True ,False ,True ,True ):_hash_exception,\n(True ,True ,False ,False ):_hash_add,\n(True ,True ,False ,True ):_hash_exception,\n(True ,True ,True ,False ):_hash_add,\n(True ,True ,True ,True ):_hash_exception,\n}\n\n\n\n\ndef _process_class(cls,init,repr,eq,order,unsafe_hash,frozen):\n\n\n\n\n fields={}\n \n setattr(cls,_PARAMS,_DataclassParams(init,repr,eq,order,\n unsafe_hash,frozen))\n \n \n \n \n \n any_frozen_base=False\n has_dataclass_bases=False\n for b in cls.__mro__[-1:0:-1]:\n \n \n  base_fields=getattr(b,_FIELDS,None )\n  if base_fields:\n   has_dataclass_bases=True\n   for f in base_fields.values():\n    fields[f.name]=f\n   if getattr(b,_PARAMS).frozen:\n    any_frozen_base=True\n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n cls_annotations=cls.__dict__.get('__annotations__',{})\n \n \n \n \n cls_fields=[_get_field(cls,name,type)\n for name,type in cls_annotations.items()]\n for f in cls_fields:\n  fields[f.name]=f\n  \n  \n  \n  \n  \n  if isinstance(getattr(cls,f.name,None ),Field):\n   if f.default is MISSING:\n   \n   \n   \n   \n   \n   \n    delattr(cls,f.name)\n   else :\n    setattr(cls,f.name,f.default)\n    \n    \n for name,value in cls.__dict__.items():\n  if isinstance(value,Field)and not name in cls_annotations:\n   raise TypeError(f'{name!r} is a field but has no type annotation')\n   \n   \n if has_dataclass_bases:\n \n  if any_frozen_base and not frozen:\n   raise TypeError('cannot inherit non-frozen dataclass from a '\n   'frozen one')\n   \n   \n  if not any_frozen_base and frozen:\n   raise TypeError('cannot inherit frozen dataclass from a '\n   'non-frozen one')\n   \n   \n   \n setattr(cls,_FIELDS,fields)\n \n \n \n \n \n \n class_hash=cls.__dict__.get('__hash__',MISSING)\n has_explicit_hash=not (class_hash is MISSING or\n (class_hash is None and '__eq__'in cls.__dict__))\n \n \n \n if order and not eq:\n  raise ValueError('eq must be true if order is true')\n  \n if init:\n \n  has_post_init=hasattr(cls,_POST_INIT_NAME)\n  \n  \n  flds=[f for f in fields.values()\n  if f._field_type in (_FIELD,_FIELD_INITVAR)]\n  _set_new_attribute(cls,'__init__',\n  _init_fn(flds,\n  frozen,\n  has_post_init,\n  \n  \n  \n  '__dataclass_self__'if 'self'in fields\n  else 'self',\n  ))\n  \n  \n  \n field_list=[f for f in fields.values()if f._field_type is _FIELD]\n \n if repr:\n  flds=[f for f in field_list if f.repr]\n  _set_new_attribute(cls,'__repr__',_repr_fn(flds))\n  \n if eq:\n \n \n  flds=[f for f in field_list if f.compare]\n  self_tuple=_tuple_str('self',flds)\n  other_tuple=_tuple_str('other',flds)\n  _set_new_attribute(cls,'__eq__',\n  _cmp_fn('__eq__','==',\n  self_tuple,other_tuple))\n  \n if order:\n \n  flds=[f for f in field_list if f.compare]\n  self_tuple=_tuple_str('self',flds)\n  other_tuple=_tuple_str('other',flds)\n  for name,op in [('__lt__','<'),\n  ('__le__','<='),\n  ('__gt__','>'),\n  ('__ge__','>='),\n  ]:\n   if _set_new_attribute(cls,name,\n   _cmp_fn(name,op,self_tuple,other_tuple)):\n    raise TypeError(f'Cannot overwrite attribute {name} '\n    f'in class {cls.__name__}. Consider using '\n    'functools.total_ordering')\n    \n if frozen:\n  for fn in _frozen_get_del_attr(cls,field_list):\n   if _set_new_attribute(cls,fn.__name__,fn):\n    raise TypeError(f'Cannot overwrite attribute {fn.__name__} '\n    f'in class {cls.__name__}')\n    \n    \n hash_action=_hash_action[bool(unsafe_hash),\n bool(eq),\n bool(frozen),\n has_explicit_hash]\n if hash_action:\n \n \n  cls.__hash__=hash_action(cls,field_list)\n  \n if not getattr(cls,'__doc__'):\n \n  cls.__doc__=(cls.__name__+\n  str(inspect.signature(cls)).replace(' -> None',''))\n  \n return cls\n \n \n \n \n \ndef dataclass(_cls=None ,*,init=True ,repr=True ,eq=True ,order=False ,\nunsafe_hash=False ,frozen=False ):\n ''\n\n\n\n\n\n\n\n\n\n \n \n def wrap(cls):\n  return _process_class(cls,init,repr,eq,order,unsafe_hash,frozen)\n  \n  \n if _cls is None :\n \n  return wrap\n  \n  \n return wrap(_cls)\n \n \ndef fields(class_or_instance):\n ''\n\n\n\n \n \n \n try :\n  fields=getattr(class_or_instance,_FIELDS)\n except AttributeError:\n  raise TypeError('must be called with a dataclass type or instance')\n  \n  \n  \n return tuple(f for f in fields.values()if f._field_type is _FIELD)\n \n \ndef _is_dataclass_instance(obj):\n ''\n return not isinstance(obj,type)and hasattr(obj,_FIELDS)\n \n \ndef is_dataclass(obj):\n ''\n \n return hasattr(obj,_FIELDS)\n \n \ndef asdict(obj,*,dict_factory=dict):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n if not _is_dataclass_instance(obj):\n  raise TypeError(\"asdict() should be called on dataclass instances\")\n return _asdict_inner(obj,dict_factory)\n \n \ndef _asdict_inner(obj,dict_factory):\n if _is_dataclass_instance(obj):\n  result=[]\n  for f in fields(obj):\n   value=_asdict_inner(getattr(obj,f.name),dict_factory)\n   result.append((f.name,value))\n  return dict_factory(result)\n elif isinstance(obj,(list,tuple)):\n  return type(obj)(_asdict_inner(v,dict_factory)for v in obj)\n elif isinstance(obj,dict):\n  return type(obj)((_asdict_inner(k,dict_factory),_asdict_inner(v,dict_factory))\n  for k,v in obj.items())\n else :\n  return copy.deepcopy(obj)\n  \n  \ndef astuple(obj,*,tuple_factory=tuple):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n if not _is_dataclass_instance(obj):\n  raise TypeError(\"astuple() should be called on dataclass instances\")\n return _astuple_inner(obj,tuple_factory)\n \n \ndef _astuple_inner(obj,tuple_factory):\n if _is_dataclass_instance(obj):\n  result=[]\n  for f in fields(obj):\n   value=_astuple_inner(getattr(obj,f.name),tuple_factory)\n   result.append(value)\n  return tuple_factory(result)\n elif isinstance(obj,(list,tuple)):\n  return type(obj)(_astuple_inner(v,tuple_factory)for v in obj)\n elif isinstance(obj,dict):\n  return type(obj)((_astuple_inner(k,tuple_factory),_astuple_inner(v,tuple_factory))\n  for k,v in obj.items())\n else :\n  return copy.deepcopy(obj)\n  \n  \ndef make_dataclass(cls_name,fields,*,bases=(),namespace=None ,init=True ,\nrepr=True ,eq=True ,order=False ,unsafe_hash=False ,\nfrozen=False ):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n if namespace is None :\n  namespace={}\n else :\n \n  namespace=namespace.copy()\n  \n  \n  \n seen=set()\n anns={}\n for item in fields:\n  if isinstance(item,str):\n   name=item\n   tp='typing.Any'\n  elif len(item)==2:\n   name,tp,=item\n  elif len(item)==3:\n   name,tp,spec=item\n   namespace[name]=spec\n  else :\n   raise TypeError(f'Invalid field: {item!r}')\n   \n  if not isinstance(name,str)or not name.isidentifier():\n   raise TypeError(f'Field names must be valid identifers: {name!r}')\n  if keyword.iskeyword(name):\n   raise TypeError(f'Field names must not be keywords: {name!r}')\n  if name in seen:\n   raise TypeError(f'Field name duplicated: {name!r}')\n   \n  seen.add(name)\n  anns[name]=tp\n  \n namespace['__annotations__']=anns\n \n \n cls=types.new_class(cls_name,bases,{},lambda ns:ns.update(namespace))\n return dataclass(cls,init=init,repr=repr,eq=eq,order=order,\n unsafe_hash=unsafe_hash,frozen=frozen)\n \n \ndef replace(obj,**changes):\n ''\n\n\n\n\n\n\n\n\n\n\n\n \n \n \n \n \n if not _is_dataclass_instance(obj):\n  raise TypeError(\"replace() should be called on dataclass instances\")\n  \n  \n  \n  \n for f in getattr(obj,_FIELDS).values():\n \n  if f._field_type is _FIELD_CLASSVAR:\n   continue\n   \n  if not f.init:\n  \n   if f.name in changes:\n    raise ValueError(f'field {f.name} is declared with '\n    'init=False, it cannot be specified with '\n    'replace()')\n   continue\n   \n  if f.name not in changes:\n   changes[f.name]=getattr(obj,f.name)\n   \n   \n   \n   \n   \n   \n return obj.__class__(**changes)\n", ["copy", "inspect", "keyword", "re", "sys", "types"]], "datetime": [".py", "''\n\n\n\n\n\nimport time as _time\nimport math as _math\n\ndef _cmp(x,y):\n return 0 if x ==y else 1 if x >y else -1\n \nMINYEAR=1\nMAXYEAR=9999\n_MAXORDINAL=3652059\n\n\n\n\n\n\n\n\n\n\n\n_DAYS_IN_MONTH=[-1,31,28,31,30,31,30,31,31,30,31,30,31]\n\n_DAYS_BEFORE_MONTH=[-1]\ndbm=0\nfor dim in _DAYS_IN_MONTH[1:]:\n _DAYS_BEFORE_MONTH.append(dbm)\n dbm +=dim\ndel dbm,dim\n\ndef _is_leap(year):\n ''\n return year %4 ==0 and (year %100 !=0 or year %400 ==0)\n \ndef _days_before_year(year):\n ''\n y=year -1\n return y *365+y //4 -y //100+y //400\n \ndef _days_in_month(year,month):\n ''\n assert 1 <=month <=12,month\n if month ==2 and _is_leap(year):\n  return 29\n return _DAYS_IN_MONTH[month]\n \ndef _days_before_month(year,month):\n ''\n assert 1 <=month <=12,'month must be in 1..12'\n return _DAYS_BEFORE_MONTH[month]+(month >2 and _is_leap(year))\n \ndef _ymd2ord(year,month,day):\n ''\n assert 1 <=month <=12,'month must be in 1..12'\n dim=_days_in_month(year,month)\n assert 1 <=day <=dim,('day must be in 1..%d'%dim)\n return (_days_before_year(year)+\n _days_before_month(year,month)+\n day)\n \n_DI400Y=_days_before_year(401)\n_DI100Y=_days_before_year(101)\n_DI4Y=_days_before_year(5)\n\n\n\nassert _DI4Y ==4 *365+1\n\n\n\nassert _DI400Y ==4 *_DI100Y+1\n\n\n\nassert _DI100Y ==25 *_DI4Y -1\n\ndef _ord2ymd(n):\n ''\n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n n -=1\n n400,n=divmod(n,_DI400Y)\n year=n400 *400+1\n \n \n \n \n \n \n n100,n=divmod(n,_DI100Y)\n \n \n n4,n=divmod(n,_DI4Y)\n \n \n \n n1,n=divmod(n,365)\n \n year +=n100 *100+n4 *4+n1\n if n1 ==4 or n100 ==4:\n  assert n ==0\n  return year -1,12,31\n  \n  \n  \n leapyear=n1 ==3 and (n4 !=24 or n100 ==3)\n assert leapyear ==_is_leap(year)\n month=(n+50)>>5\n preceding=_DAYS_BEFORE_MONTH[month]+(month >2 and leapyear)\n if preceding >n:\n  month -=1\n  preceding -=_DAYS_IN_MONTH[month]+(month ==2 and leapyear)\n n -=preceding\n assert 0 <=n <_days_in_month(year,month)\n \n \n \n return year,month,n+1\n \n \n_MONTHNAMES=[None ,\"Jan\",\"Feb\",\"Mar\",\"Apr\",\"May\",\"Jun\",\n\"Jul\",\"Aug\",\"Sep\",\"Oct\",\"Nov\",\"Dec\"]\n_DAYNAMES=[None ,\"Mon\",\"Tue\",\"Wed\",\"Thu\",\"Fri\",\"Sat\",\"Sun\"]\n\n\ndef _build_struct_time(y,m,d,hh,mm,ss,dstflag):\n wday=(_ymd2ord(y,m,d)+6)%7\n dnum=_days_before_month(y,m)+d\n return _time.struct_time((y,m,d,hh,mm,ss,wday,dnum,dstflag))\n \ndef _format_time(hh,mm,ss,us,timespec='auto'):\n specs={\n 'hours':'{:02d}',\n 'minutes':'{:02d}:{:02d}',\n 'seconds':'{:02d}:{:02d}:{:02d}',\n 'milliseconds':'{:02d}:{:02d}:{:02d}.{:03d}',\n 'microseconds':'{:02d}:{:02d}:{:02d}.{:06d}'\n }\n \n if timespec =='auto':\n \n  timespec='microseconds'if us else 'seconds'\n elif timespec =='milliseconds':\n  us //=1000\n try :\n  fmt=specs[timespec]\n except KeyError:\n  raise ValueError('Unknown timespec value')\n else :\n  return fmt.format(hh,mm,ss,us)\n  \ndef _format_offset(off):\n s=''\n if off is not None :\n  if off.days <0:\n   sign=\"-\"\n   off=-off\n  else :\n   sign=\"+\"\n  hh,mm=divmod(off,timedelta(hours=1))\n  mm,ss=divmod(mm,timedelta(minutes=1))\n  s +=\"%s%02d:%02d\"%(sign,hh,mm)\n  if ss or ss.microseconds:\n   s +=\":%02d\"%ss.seconds\n   \n   if ss.microseconds:\n    s +='.%06d'%ss.microseconds\n return s\n \n \ndef _wrap_strftime(object,format,timetuple):\n\n freplace=None\n zreplace=None\n Zreplace=None\n \n \n newformat=[]\n push=newformat.append\n i,n=0,len(format)\n while i <n:\n  ch=format[i]\n  i +=1\n  if ch =='%':\n   if i <n:\n    ch=format[i]\n    i +=1\n    if ch =='f':\n     if freplace is None :\n      freplace='%06d'%getattr(object,\n      'microsecond',0)\n     newformat.append(freplace)\n    elif ch =='z':\n     if zreplace is None :\n      zreplace=\"\"\n      if hasattr(object,\"utcoffset\"):\n       offset=object.utcoffset()\n       if offset is not None :\n        sign='+'\n        if offset.days <0:\n         offset=-offset\n         sign='-'\n        h,rest=divmod(offset,timedelta(hours=1))\n        m,rest=divmod(rest,timedelta(minutes=1))\n        s=rest.seconds\n        u=offset.microseconds\n        if u:\n         zreplace='%c%02d%02d%02d.%06d'%(sign,h,m,s,u)\n        elif s:\n         zreplace='%c%02d%02d%02d'%(sign,h,m,s)\n        else :\n         zreplace='%c%02d%02d'%(sign,h,m)\n     assert '%'not in zreplace\n     newformat.append(zreplace)\n    elif ch =='Z':\n     if Zreplace is None :\n      Zreplace=\"\"\n      if hasattr(object,\"tzname\"):\n       s=object.tzname()\n       if s is not None :\n       \n        Zreplace=s.replace('%','%%')\n     newformat.append(Zreplace)\n    else :\n     push('%')\n     push(ch)\n   else :\n    push('%')\n  else :\n   push(ch)\n newformat=\"\".join(newformat)\n return _time.strftime(newformat,timetuple)\n \n \ndef _parse_isoformat_date(dtstr):\n\n\n year=int(dtstr[0:4])\n if dtstr[4]!='-':\n  raise ValueError('Invalid date separator: %s'%dtstr[4])\n  \n month=int(dtstr[5:7])\n \n if dtstr[7]!='-':\n  raise ValueError('Invalid date separator')\n  \n day=int(dtstr[8:10])\n \n return [year,month,day]\n \ndef _parse_hh_mm_ss_ff(tstr):\n\n len_str=len(tstr)\n \n time_comps=[0,0,0,0]\n pos=0\n for comp in range(0,3):\n  if (len_str -pos)<2:\n   raise ValueError('Incomplete time component')\n   \n  time_comps[comp]=int(tstr[pos:pos+2])\n  \n  pos +=2\n  next_char=tstr[pos:pos+1]\n  \n  if not next_char or comp >=2:\n   break\n   \n  if next_char !=':':\n   raise ValueError('Invalid time separator: %c'%next_char)\n   \n  pos +=1\n  \n if pos <len_str:\n  if tstr[pos]!='.':\n   raise ValueError('Invalid microsecond component')\n  else :\n   pos +=1\n   \n   len_remainder=len_str -pos\n   if len_remainder not in (3,6):\n    raise ValueError('Invalid microsecond component')\n    \n   time_comps[3]=int(tstr[pos:])\n   if len_remainder ==3:\n    time_comps[3]*=1000\n    \n return time_comps\n \ndef _parse_isoformat_time(tstr):\n\n len_str=len(tstr)\n if len_str <2:\n  raise ValueError('Isoformat time too short')\n  \n  \n tz_pos=(tstr.find('-')+1 or tstr.find('+')+1)\n timestr=tstr[:tz_pos -1]if tz_pos >0 else tstr\n \n time_comps=_parse_hh_mm_ss_ff(timestr)\n \n tzi=None\n if tz_pos >0:\n  tzstr=tstr[tz_pos:]\n  \n  \n  \n  \n  \n  \n  if len(tzstr)not in (5,8,15):\n   raise ValueError('Malformed time zone string')\n   \n  tz_comps=_parse_hh_mm_ss_ff(tzstr)\n  if all(x ==0 for x in tz_comps):\n   tzi=timezone.utc\n  else :\n   tzsign=-1 if tstr[tz_pos -1]=='-'else 1\n   \n   td=timedelta(hours=tz_comps[0],minutes=tz_comps[1],\n   seconds=tz_comps[2],microseconds=tz_comps[3])\n   \n   tzi=timezone(tzsign *td)\n   \n time_comps.append(tzi)\n \n return time_comps\n \n \n \ndef _check_tzname(name):\n if name is not None and not isinstance(name,str):\n  raise TypeError(\"tzinfo.tzname() must return None or string, \"\n  \"not '%s'\"%type(name))\n  \n  \n  \n  \n  \n  \n  \ndef _check_utc_offset(name,offset):\n assert name in (\"utcoffset\",\"dst\")\n if offset is None :\n  return\n if not isinstance(offset,timedelta):\n  raise TypeError(\"tzinfo.%s() must return None \"\n  \"or timedelta, not '%s'\"%(name,type(offset)))\n if not -timedelta(1)<offset <timedelta(1):\n  raise ValueError(\"%s()=%s, must be strictly between \"\n  \"-timedelta(hours=24) and timedelta(hours=24)\"%\n  (name,offset))\n  \ndef _check_int_field(value):\n if isinstance(value,int):\n  return value\n if not isinstance(value,float):\n  try :\n   value=value.__int__()\n  except AttributeError:\n   pass\n  else :\n   if isinstance(value,int):\n    return value\n   raise TypeError('__int__ returned non-int (type %s)'%\n   type(value).__name__)\n  raise TypeError('an integer is required (got type %s)'%\n  type(value).__name__)\n raise TypeError('integer argument expected, got float')\n \ndef _check_date_fields(year,month,day):\n year=_check_int_field(year)\n month=_check_int_field(month)\n day=_check_int_field(day)\n if not MINYEAR <=year <=MAXYEAR:\n  raise ValueError('year must be in %d..%d'%(MINYEAR,MAXYEAR),year)\n if not 1 <=month <=12:\n  raise ValueError('month must be in 1..12',month)\n dim=_days_in_month(year,month)\n if not 1 <=day <=dim:\n  raise ValueError('day must be in 1..%d'%dim,day)\n return year,month,day\n \ndef _check_time_fields(hour,minute,second,microsecond,fold):\n hour=_check_int_field(hour)\n minute=_check_int_field(minute)\n second=_check_int_field(second)\n microsecond=_check_int_field(microsecond)\n if not 0 <=hour <=23:\n  raise ValueError('hour must be in 0..23',hour)\n if not 0 <=minute <=59:\n  raise ValueError('minute must be in 0..59',minute)\n if not 0 <=second <=59:\n  raise ValueError('second must be in 0..59',second)\n if not 0 <=microsecond <=999999:\n  raise ValueError('microsecond must be in 0..999999',microsecond)\n if fold not in (0,1):\n  raise ValueError('fold must be either 0 or 1',fold)\n return hour,minute,second,microsecond,fold\n \ndef _check_tzinfo_arg(tz):\n if tz is not None and not isinstance(tz,tzinfo):\n  raise TypeError(\"tzinfo argument must be None or of a tzinfo subclass\")\n  \ndef _cmperror(x,y):\n raise TypeError(\"can't compare '%s' to '%s'\"%(\n type(x).__name__,type(y).__name__))\n \ndef _divide_and_round(a,b):\n ''\n\n\n\n \n \n \n q,r=divmod(a,b)\n \n \n \n r *=2\n greater_than_half=r >b if b >0 else r <b\n if greater_than_half or r ==b and q %2 ==1:\n  q +=1\n  \n return q\n \n \nclass timedelta:\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n __slots__='_days','_seconds','_microseconds','_hashcode'\n \n def __new__(cls,days=0,seconds=0,microseconds=0,\n milliseconds=0,minutes=0,hours=0,weeks=0):\n \n \n \n \n \n \n \n \n \n \n \n \n  d=s=us=0\n  \n  \n  days +=weeks *7\n  seconds +=minutes *60+hours *3600\n  microseconds +=milliseconds *1000\n  \n  \n  \n  if isinstance(days,float):\n   dayfrac,days=_math.modf(days)\n   daysecondsfrac,daysecondswhole=_math.modf(dayfrac *(24. *3600.))\n   assert daysecondswhole ==int(daysecondswhole)\n   s=int(daysecondswhole)\n   assert days ==int(days)\n   d=int(days)\n  else :\n   daysecondsfrac=0.0\n   d=days\n  assert isinstance(daysecondsfrac,float)\n  assert abs(daysecondsfrac)<=1.0\n  assert isinstance(d,int)\n  assert abs(s)<=24 *3600\n  \n  \n  if isinstance(seconds,float):\n   secondsfrac,seconds=_math.modf(seconds)\n   assert seconds ==int(seconds)\n   seconds=int(seconds)\n   secondsfrac +=daysecondsfrac\n   assert abs(secondsfrac)<=2.0\n  else :\n   secondsfrac=daysecondsfrac\n   \n  assert isinstance(secondsfrac,float)\n  assert abs(secondsfrac)<=2.0\n  \n  assert isinstance(seconds,int)\n  days,seconds=divmod(seconds,24 *3600)\n  d +=days\n  s +=int(seconds)\n  assert isinstance(s,int)\n  assert abs(s)<=2 *24 *3600\n  \n  \n  usdouble=secondsfrac *1e6\n  assert abs(usdouble)<2.1e6\n  \n  \n  if isinstance(microseconds,float):\n   microseconds=round(microseconds+usdouble)\n   seconds,microseconds=divmod(microseconds,1000000)\n   days,seconds=divmod(seconds,24 *3600)\n   d +=days\n   s +=seconds\n  else :\n   microseconds=int(microseconds)\n   seconds,microseconds=divmod(microseconds,1000000)\n   days,seconds=divmod(seconds,24 *3600)\n   d +=days\n   s +=seconds\n   microseconds=round(microseconds+usdouble)\n  assert isinstance(s,int)\n  assert isinstance(microseconds,int)\n  assert abs(s)<=3 *24 *3600\n  assert abs(microseconds)<3.1e6\n  \n  \n  seconds,us=divmod(microseconds,1000000)\n  s +=seconds\n  days,s=divmod(s,24 *3600)\n  d +=days\n  \n  assert isinstance(d,int)\n  assert isinstance(s,int)and 0 <=s <24 *3600\n  assert isinstance(us,int)and 0 <=us <1000000\n  \n  if abs(d)>999999999:\n   raise OverflowError(\"timedelta # of days is too large: %d\"%d)\n   \n  self=object.__new__(cls)\n  self._days=d\n  self._seconds=s\n  self._microseconds=us\n  self._hashcode=-1\n  return self\n  \n def __repr__(self):\n  args=[]\n  if self._days:\n   args.append(\"days=%d\"%self._days)\n  if self._seconds:\n   args.append(\"seconds=%d\"%self._seconds)\n  if self._microseconds:\n   args.append(\"microseconds=%d\"%self._microseconds)\n  if not args:\n   args.append('0')\n  return \"%s.%s(%s)\"%(self.__class__.__module__,\n  self.__class__.__qualname__,\n  ', '.join(args))\n  \n def __str__(self):\n  mm,ss=divmod(self._seconds,60)\n  hh,mm=divmod(mm,60)\n  s=\"%d:%02d:%02d\"%(hh,mm,ss)\n  if self._days:\n   def plural(n):\n    return n,abs(n)!=1 and \"s\"or \"\"\n   s=(\"%d day%s, \"%plural(self._days))+s\n  if self._microseconds:\n   s=s+\".%06d\"%self._microseconds\n  return s\n  \n def total_seconds(self):\n  ''\n  return ((self.days *86400+self.seconds)*10 **6+\n  self.microseconds)/10 **6\n  \n  \n @property\n def days(self):\n  ''\n  return self._days\n  \n @property\n def seconds(self):\n  ''\n  return self._seconds\n  \n @property\n def microseconds(self):\n  ''\n  return self._microseconds\n  \n def __add__(self,other):\n  if isinstance(other,timedelta):\n  \n  \n   return timedelta(self._days+other._days,\n   self._seconds+other._seconds,\n   self._microseconds+other._microseconds)\n  return NotImplemented\n  \n __radd__=__add__\n \n def __sub__(self,other):\n  if isinstance(other,timedelta):\n  \n  \n   return timedelta(self._days -other._days,\n   self._seconds -other._seconds,\n   self._microseconds -other._microseconds)\n  return NotImplemented\n  \n def __rsub__(self,other):\n  if isinstance(other,timedelta):\n   return -self+other\n  return NotImplemented\n  \n def __neg__(self):\n \n \n  return timedelta(-self._days,\n  -self._seconds,\n  -self._microseconds)\n  \n def __pos__(self):\n  return self\n  \n def __abs__(self):\n  if self._days <0:\n   return -self\n  else :\n   return self\n   \n def __mul__(self,other):\n  if isinstance(other,int):\n  \n  \n   return timedelta(self._days *other,\n   self._seconds *other,\n   self._microseconds *other)\n  if isinstance(other,float):\n   usec=self._to_microseconds()\n   a,b=other.as_integer_ratio()\n   return timedelta(0,0,_divide_and_round(usec *a,b))\n  return NotImplemented\n  \n __rmul__=__mul__\n \n def _to_microseconds(self):\n  return ((self._days *(24 *3600)+self._seconds)*1000000+\n  self._microseconds)\n  \n def __floordiv__(self,other):\n  if not isinstance(other,(int,timedelta)):\n   return NotImplemented\n  usec=self._to_microseconds()\n  if isinstance(other,timedelta):\n   return usec //other._to_microseconds()\n  if isinstance(other,int):\n   return timedelta(0,0,usec //other)\n   \n def __truediv__(self,other):\n  if not isinstance(other,(int,float,timedelta)):\n   return NotImplemented\n  usec=self._to_microseconds()\n  if isinstance(other,timedelta):\n   return usec /other._to_microseconds()\n  if isinstance(other,int):\n   return timedelta(0,0,_divide_and_round(usec,other))\n  if isinstance(other,float):\n   a,b=other.as_integer_ratio()\n   return timedelta(0,0,_divide_and_round(b *usec,a))\n   \n def __mod__(self,other):\n  if isinstance(other,timedelta):\n   r=self._to_microseconds()%other._to_microseconds()\n   return timedelta(0,0,r)\n  return NotImplemented\n  \n def __divmod__(self,other):\n  if isinstance(other,timedelta):\n   q,r=divmod(self._to_microseconds(),\n   other._to_microseconds())\n   return q,timedelta(0,0,r)\n  return NotImplemented\n  \n  \n  \n def __eq__(self,other):\n  if isinstance(other,timedelta):\n   return self._cmp(other)==0\n  else :\n   return False\n   \n def __le__(self,other):\n  if isinstance(other,timedelta):\n   return self._cmp(other)<=0\n  else :\n   _cmperror(self,other)\n   \n def __lt__(self,other):\n  if isinstance(other,timedelta):\n   return self._cmp(other)<0\n  else :\n   _cmperror(self,other)\n   \n def __ge__(self,other):\n  if isinstance(other,timedelta):\n   return self._cmp(other)>=0\n  else :\n   _cmperror(self,other)\n   \n def __gt__(self,other):\n  if isinstance(other,timedelta):\n   return self._cmp(other)>0\n  else :\n   _cmperror(self,other)\n   \n def _cmp(self,other):\n  assert isinstance(other,timedelta)\n  return _cmp(self._getstate(),other._getstate())\n  \n def __hash__(self):\n  if self._hashcode ==-1:\n   self._hashcode=hash(self._getstate())\n  return self._hashcode\n  \n def __bool__(self):\n  return (self._days !=0 or\n  self._seconds !=0 or\n  self._microseconds !=0)\n  \n  \n  \n def _getstate(self):\n  return (self._days,self._seconds,self._microseconds)\n  \n def __reduce__(self):\n  return (self.__class__,self._getstate())\n  \ntimedelta.min=timedelta(-999999999)\ntimedelta.max=timedelta(days=999999999,hours=23,minutes=59,seconds=59,\nmicroseconds=999999)\ntimedelta.resolution=timedelta(microseconds=1)\n\nclass date:\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n __slots__='_year','_month','_day','_hashcode'\n \n def __new__(cls,year,month=None ,day=None ):\n  ''\n\n\n\n\n  \n  if month is None and isinstance(year,bytes)and len(year)==4 and\\\n  1 <=year[2]<=12:\n  \n   self=object.__new__(cls)\n   self.__setstate(year)\n   self._hashcode=-1\n   return self\n  year,month,day=_check_date_fields(year,month,day)\n  self=object.__new__(cls)\n  self._year=year\n  self._month=month\n  self._day=day\n  self._hashcode=-1\n  return self\n  \n  \n  \n @classmethod\n def fromtimestamp(cls,t):\n  ''\n  y,m,d,hh,mm,ss,weekday,jday,dst=_time.localtime(t)\n  return cls(y,m,d)\n  \n @classmethod\n def today(cls):\n  ''\n  t=_time.time()\n  return cls.fromtimestamp(t)\n  \n @classmethod\n def fromordinal(cls,n):\n  ''\n\n\n\n  \n  y,m,d=_ord2ymd(n)\n  return cls(y,m,d)\n  \n @classmethod\n def fromisoformat(cls,date_string):\n  ''\n  if not isinstance(date_string,str):\n   raise TypeError('fromisoformat: argument must be str')\n   \n  try :\n   assert len(date_string)==10\n   return cls(*_parse_isoformat_date(date_string))\n  except Exception:\n   raise ValueError('Invalid isoformat string: %s'%date_string)\n   \n   \n   \n   \n def __repr__(self):\n  ''\n\n\n\n\n\n\n\n\n  \n  return \"%s.%s(%d, %d, %d)\"%(self.__class__.__module__,\n  self.__class__.__qualname__,\n  self._year,\n  self._month,\n  self._day)\n  \n  \n  \n  \n  \n  \n def ctime(self):\n  ''\n  weekday=self.toordinal()%7 or 7\n  return \"%s %s %2d 00:00:00 %04d\"%(\n  _DAYNAMES[weekday],\n  _MONTHNAMES[self._month],\n  self._day,self._year)\n  \n def strftime(self,fmt):\n  ''\n  return _wrap_strftime(self,fmt,self.timetuple())\n  \n def __format__(self,fmt):\n  if not isinstance(fmt,str):\n   raise TypeError(\"must be str, not %s\"%type(fmt).__name__)\n  if len(fmt)!=0:\n   return self.strftime(fmt)\n  return str(self)\n  \n def isoformat(self):\n  ''\n\n\n\n\n\n\n  \n  return \"%04d-%02d-%02d\"%(self._year,self._month,self._day)\n  \n __str__=isoformat\n \n \n @property\n def year(self):\n  ''\n  return self._year\n  \n @property\n def month(self):\n  ''\n  return self._month\n  \n @property\n def day(self):\n  ''\n  return self._day\n  \n  \n  \n  \n def timetuple(self):\n  ''\n  return _build_struct_time(self._year,self._month,self._day,\n  0,0,0,-1)\n  \n def toordinal(self):\n  ''\n\n\n\n  \n  return _ymd2ord(self._year,self._month,self._day)\n  \n def replace(self,year=None ,month=None ,day=None ):\n  ''\n  if year is None :\n   year=self._year\n  if month is None :\n   month=self._month\n  if day is None :\n   day=self._day\n  return type(self)(year,month,day)\n  \n  \n  \n def __eq__(self,other):\n  if isinstance(other,date):\n   return self._cmp(other)==0\n  return NotImplemented\n  \n def __le__(self,other):\n  if isinstance(other,date):\n   return self._cmp(other)<=0\n  return NotImplemented\n  \n def __lt__(self,other):\n  if isinstance(other,date):\n   return self._cmp(other)<0\n  return NotImplemented\n  \n def __ge__(self,other):\n  if isinstance(other,date):\n   return self._cmp(other)>=0\n  return NotImplemented\n  \n def __gt__(self,other):\n  if isinstance(other,date):\n   return self._cmp(other)>0\n  return NotImplemented\n  \n def _cmp(self,other):\n  assert isinstance(other,date)\n  y,m,d=self._year,self._month,self._day\n  y2,m2,d2=other._year,other._month,other._day\n  return _cmp((y,m,d),(y2,m2,d2))\n  \n def __hash__(self):\n  ''\n  if self._hashcode ==-1:\n   self._hashcode=hash(self._getstate())\n  return self._hashcode\n  \n  \n  \n def __add__(self,other):\n  ''\n  if isinstance(other,timedelta):\n   o=self.toordinal()+other.days\n   if 0 <o <=_MAXORDINAL:\n    return date.fromordinal(o)\n   raise OverflowError(\"result out of range\")\n  return NotImplemented\n  \n __radd__=__add__\n \n def __sub__(self,other):\n  ''\n  if isinstance(other,timedelta):\n   return self+timedelta(-other.days)\n  if isinstance(other,date):\n   days1=self.toordinal()\n   days2=other.toordinal()\n   return timedelta(days1 -days2)\n  return NotImplemented\n  \n def weekday(self):\n  ''\n  return (self.toordinal()+6)%7\n  \n  \n  \n def isoweekday(self):\n  ''\n  \n  return self.toordinal()%7 or 7\n  \n def isocalendar(self):\n  ''\n\n\n\n\n\n\n\n\n\n\n  \n  year=self._year\n  week1monday=_isoweek1monday(year)\n  today=_ymd2ord(self._year,self._month,self._day)\n  \n  week,day=divmod(today -week1monday,7)\n  if week <0:\n   year -=1\n   week1monday=_isoweek1monday(year)\n   week,day=divmod(today -week1monday,7)\n  elif week >=52:\n   if today >=_isoweek1monday(year+1):\n    year +=1\n    week=0\n  return year,week+1,day+1\n  \n  \n  \n def _getstate(self):\n  yhi,ylo=divmod(self._year,256)\n  return bytes([yhi,ylo,self._month,self._day]),\n  \n def __setstate(self,string):\n  yhi,ylo,self._month,self._day=string\n  self._year=yhi *256+ylo\n  \n def __reduce__(self):\n  return (self.__class__,self._getstate())\n  \n_date_class=date\n\ndate.min=date(1,1,1)\ndate.max=date(9999,12,31)\ndate.resolution=timedelta(days=1)\n\n\nclass tzinfo:\n ''\n\n\n \n __slots__=()\n \n def tzname(self,dt):\n  ''\n  raise NotImplementedError(\"tzinfo subclass must override tzname()\")\n  \n def utcoffset(self,dt):\n  ''\n  raise NotImplementedError(\"tzinfo subclass must override utcoffset()\")\n  \n def dst(self,dt):\n  ''\n\n\n\n  \n  raise NotImplementedError(\"tzinfo subclass must override dst()\")\n  \n def fromutc(self,dt):\n  ''\n  \n  if not isinstance(dt,datetime):\n   raise TypeError(\"fromutc() requires a datetime argument\")\n  if dt.tzinfo is not self:\n   raise ValueError(\"dt.tzinfo is not self\")\n   \n  dtoff=dt.utcoffset()\n  if dtoff is None :\n   raise ValueError(\"fromutc() requires a non-None utcoffset() \"\n   \"result\")\n   \n   \n   \n  dtdst=dt.dst()\n  if dtdst is None :\n   raise ValueError(\"fromutc() requires a non-None dst() result\")\n  delta=dtoff -dtdst\n  if delta:\n   dt +=delta\n   dtdst=dt.dst()\n   if dtdst is None :\n    raise ValueError(\"fromutc(): dt.dst gave inconsistent \"\n    \"results; cannot convert\")\n  return dt+dtdst\n  \n  \n  \n def __reduce__(self):\n  getinitargs=getattr(self,\"__getinitargs__\",None )\n  if getinitargs:\n   args=getinitargs()\n  else :\n   args=()\n  getstate=getattr(self,\"__getstate__\",None )\n  if getstate:\n   state=getstate()\n  else :\n   state=getattr(self,\"__dict__\",None )or None\n  if state is None :\n   return (self.__class__,args)\n  else :\n   return (self.__class__,args,state)\n   \n_tzinfo_class=tzinfo\n\nclass time:\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n __slots__='_hour','_minute','_second','_microsecond','_tzinfo','_hashcode','_fold'\n \n def __new__(cls,hour=0,minute=0,second=0,microsecond=0,tzinfo=None ,*,fold=0):\n  ''\n\n\n\n\n\n\n\n  \n  if isinstance(hour,bytes)and len(hour)==6 and hour[0]&0x7F <24:\n  \n   self=object.__new__(cls)\n   self.__setstate(hour,minute or None )\n   self._hashcode=-1\n   return self\n  hour,minute,second,microsecond,fold=_check_time_fields(\n  hour,minute,second,microsecond,fold)\n  _check_tzinfo_arg(tzinfo)\n  self=object.__new__(cls)\n  self._hour=hour\n  self._minute=minute\n  self._second=second\n  self._microsecond=microsecond\n  self._tzinfo=tzinfo\n  self._hashcode=-1\n  self._fold=fold\n  return self\n  \n  \n @property\n def hour(self):\n  ''\n  return self._hour\n  \n @property\n def minute(self):\n  ''\n  return self._minute\n  \n @property\n def second(self):\n  ''\n  return self._second\n  \n @property\n def microsecond(self):\n  ''\n  return self._microsecond\n  \n @property\n def tzinfo(self):\n  ''\n  return self._tzinfo\n  \n @property\n def fold(self):\n  return self._fold\n  \n  \n  \n  \n  \n def __eq__(self,other):\n  if isinstance(other,time):\n   return self._cmp(other,allow_mixed=True )==0\n  else :\n   return False\n   \n def __le__(self,other):\n  if isinstance(other,time):\n   return self._cmp(other)<=0\n  else :\n   _cmperror(self,other)\n   \n def __lt__(self,other):\n  if isinstance(other,time):\n   return self._cmp(other)<0\n  else :\n   _cmperror(self,other)\n   \n def __ge__(self,other):\n  if isinstance(other,time):\n   return self._cmp(other)>=0\n  else :\n   _cmperror(self,other)\n   \n def __gt__(self,other):\n  if isinstance(other,time):\n   return self._cmp(other)>0\n  else :\n   _cmperror(self,other)\n   \n def _cmp(self,other,allow_mixed=False ):\n  assert isinstance(other,time)\n  mytz=self._tzinfo\n  ottz=other._tzinfo\n  myoff=otoff=None\n  \n  if mytz is ottz:\n   base_compare=True\n  else :\n   myoff=self.utcoffset()\n   otoff=other.utcoffset()\n   base_compare=myoff ==otoff\n   \n  if base_compare:\n   return _cmp((self._hour,self._minute,self._second,\n   self._microsecond),\n   (other._hour,other._minute,other._second,\n   other._microsecond))\n  if myoff is None or otoff is None :\n   if allow_mixed:\n    return 2\n   else :\n    raise TypeError(\"cannot compare naive and aware times\")\n  myhhmm=self._hour *60+self._minute -myoff //timedelta(minutes=1)\n  othhmm=other._hour *60+other._minute -otoff //timedelta(minutes=1)\n  return _cmp((myhhmm,self._second,self._microsecond),\n  (othhmm,other._second,other._microsecond))\n  \n def __hash__(self):\n  ''\n  if self._hashcode ==-1:\n   if self.fold:\n    t=self.replace(fold=0)\n   else :\n    t=self\n   tzoff=t.utcoffset()\n   if not tzoff:\n    self._hashcode=hash(t._getstate()[0])\n   else :\n    h,m=divmod(timedelta(hours=self.hour,minutes=self.minute)-tzoff,\n    timedelta(hours=1))\n    assert not m %timedelta(minutes=1),\"whole minute\"\n    m //=timedelta(minutes=1)\n    if 0 <=h <24:\n     self._hashcode=hash(time(h,m,self.second,self.microsecond))\n    else :\n     self._hashcode=hash((h,m,self.second,self.microsecond))\n  return self._hashcode\n  \n  \n  \n def _tzstr(self):\n  ''\n  off=self.utcoffset()\n  return _format_offset(off)\n  \n def __repr__(self):\n  ''\n  if self._microsecond !=0:\n   s=\", %d, %d\"%(self._second,self._microsecond)\n  elif self._second !=0:\n   s=\", %d\"%self._second\n  else :\n   s=\"\"\n  s=\"%s.%s(%d, %d%s)\"%(self.__class__.__module__,\n  self.__class__.__qualname__,\n  self._hour,self._minute,s)\n  if self._tzinfo is not None :\n   assert s[-1:]==\")\"\n   s=s[:-1]+\", tzinfo=%r\"%self._tzinfo+\")\"\n  if self._fold:\n   assert s[-1:]==\")\"\n   s=s[:-1]+\", fold=1)\"\n  return s\n  \n def isoformat(self,timespec='auto'):\n  ''\n\n\n\n\n\n\n  \n  s=_format_time(self._hour,self._minute,self._second,\n  self._microsecond,timespec)\n  tz=self._tzstr()\n  if tz:\n   s +=tz\n  return s\n  \n __str__=isoformat\n \n @classmethod\n def fromisoformat(cls,time_string):\n  ''\n  if not isinstance(time_string,str):\n   raise TypeError('fromisoformat: argument must be str')\n   \n  try :\n   return cls(*_parse_isoformat_time(time_string))\n  except Exception:\n   raise ValueError('Invalid isoformat string: %s'%time_string)\n   \n   \n def strftime(self,fmt):\n  ''\n\n  \n  \n  \n  timetuple=(1900,1,1,\n  self._hour,self._minute,self._second,\n  0,1,-1)\n  return _wrap_strftime(self,fmt,timetuple)\n  \n def __format__(self,fmt):\n  if not isinstance(fmt,str):\n   raise TypeError(\"must be str, not %s\"%type(fmt).__name__)\n  if len(fmt)!=0:\n   return self.strftime(fmt)\n  return str(self)\n  \n  \n  \n def utcoffset(self):\n  ''\n  \n  if self._tzinfo is None :\n   return None\n  offset=self._tzinfo.utcoffset(None )\n  _check_utc_offset(\"utcoffset\",offset)\n  return offset\n  \n def tzname(self):\n  ''\n\n\n\n\n  \n  if self._tzinfo is None :\n   return None\n  name=self._tzinfo.tzname(None )\n  _check_tzname(name)\n  return name\n  \n def dst(self):\n  ''\n\n\n\n\n\n\n  \n  if self._tzinfo is None :\n   return None\n  offset=self._tzinfo.dst(None )\n  _check_utc_offset(\"dst\",offset)\n  return offset\n  \n def replace(self,hour=None ,minute=None ,second=None ,microsecond=None ,\n tzinfo=True ,*,fold=None ):\n  ''\n  if hour is None :\n   hour=self.hour\n  if minute is None :\n   minute=self.minute\n  if second is None :\n   second=self.second\n  if microsecond is None :\n   microsecond=self.microsecond\n  if tzinfo is True :\n   tzinfo=self.tzinfo\n  if fold is None :\n   fold=self._fold\n  return type(self)(hour,minute,second,microsecond,tzinfo,fold=fold)\n  \n  \n  \n def _getstate(self,protocol=3):\n  us2,us3=divmod(self._microsecond,256)\n  us1,us2=divmod(us2,256)\n  h=self._hour\n  if self._fold and protocol >3:\n   h +=128\n  basestate=bytes([h,self._minute,self._second,\n  us1,us2,us3])\n  if self._tzinfo is None :\n   return (basestate,)\n  else :\n   return (basestate,self._tzinfo)\n   \n def __setstate(self,string,tzinfo):\n  if tzinfo is not None and not isinstance(tzinfo,_tzinfo_class):\n   raise TypeError(\"bad tzinfo state arg\")\n  h,self._minute,self._second,us1,us2,us3=string\n  if h >127:\n   self._fold=1\n   self._hour=h -128\n  else :\n   self._fold=0\n   self._hour=h\n  self._microsecond=(((us1 <<8)|us2)<<8)|us3\n  self._tzinfo=tzinfo\n  \n def __reduce_ex__(self,protocol):\n  return (time,self._getstate(protocol))\n  \n def __reduce__(self):\n  return self.__reduce_ex__(2)\n  \n_time_class=time\n\ntime.min=time(0,0,0)\ntime.max=time(23,59,59,999999)\ntime.resolution=timedelta(microseconds=1)\n\nclass datetime(date):\n ''\n\n\n\n \n __slots__=date.__slots__+time.__slots__\n \n def __new__(cls,year,month=None ,day=None ,hour=0,minute=0,second=0,\n microsecond=0,tzinfo=None ,*,fold=0):\n  if isinstance(year,bytes)and len(year)==10 and 1 <=year[2]&0x7F <=12:\n  \n   self=object.__new__(cls)\n   self.__setstate(year,month)\n   self._hashcode=-1\n   return self\n  year,month,day=_check_date_fields(year,month,day)\n  hour,minute,second,microsecond,fold=_check_time_fields(\n  hour,minute,second,microsecond,fold)\n  _check_tzinfo_arg(tzinfo)\n  self=object.__new__(cls)\n  self._year=year\n  self._month=month\n  self._day=day\n  self._hour=hour\n  self._minute=minute\n  self._second=second\n  self._microsecond=microsecond\n  self._tzinfo=tzinfo\n  self._hashcode=-1\n  self._fold=fold\n  return self\n  \n  \n @property\n def hour(self):\n  ''\n  return self._hour\n  \n @property\n def minute(self):\n  ''\n  return self._minute\n  \n @property\n def second(self):\n  ''\n  return self._second\n  \n @property\n def microsecond(self):\n  ''\n  return self._microsecond\n  \n @property\n def tzinfo(self):\n  ''\n  return self._tzinfo\n  \n @property\n def fold(self):\n  return self._fold\n  \n @classmethod\n def _fromtimestamp(cls,t,utc,tz):\n  ''\n\n\n  \n  frac,t=_math.modf(t)\n  us=round(frac *1e6)\n  if us >=1000000:\n   t +=1\n   us -=1000000\n  elif us <0:\n   t -=1\n   us +=1000000\n   \n  converter=_time.gmtime if utc else _time.localtime\n  y,m,d,hh,mm,ss,weekday,jday,dst=converter(t)\n  ss=min(ss,59)\n  result=cls(y,m,d,hh,mm,ss,us,tz)\n  if tz is None :\n  \n  \n  \n   max_fold_seconds=24 *3600\n   y,m,d,hh,mm,ss=converter(t -max_fold_seconds)[:6]\n   probe1=cls(y,m,d,hh,mm,ss,us,tz)\n   trans=result -probe1 -timedelta(0,max_fold_seconds)\n   if trans.days <0:\n    y,m,d,hh,mm,ss=converter(t+trans //timedelta(0,1))[:6]\n    probe2=cls(y,m,d,hh,mm,ss,us,tz)\n    if probe2 ==result:\n     result._fold=1\n  else :\n   result=tz.fromutc(result)\n  return result\n  \n @classmethod\n def fromtimestamp(cls,t,tz=None ):\n  ''\n\n\n  \n  _check_tzinfo_arg(tz)\n  \n  return cls._fromtimestamp(t,tz is not None ,tz)\n  \n @classmethod\n def utcfromtimestamp(cls,t):\n  ''\n  return cls._fromtimestamp(t,True ,None )\n  \n @classmethod\n def now(cls,tz=None ):\n  ''\n  t=_time.time()\n  return cls.fromtimestamp(t,tz)\n  \n @classmethod\n def utcnow(cls):\n  ''\n  t=_time.time()\n  return cls.utcfromtimestamp(t)\n  \n @classmethod\n def combine(cls,date,time,tzinfo=True ):\n  ''\n  if not isinstance(date,_date_class):\n   raise TypeError(\"date argument must be a date instance\")\n  if not isinstance(time,_time_class):\n   raise TypeError(\"time argument must be a time instance\")\n  if tzinfo is True :\n   tzinfo=time.tzinfo\n  return cls(date.year,date.month,date.day,\n  time.hour,time.minute,time.second,time.microsecond,\n  tzinfo,fold=time.fold)\n  \n @classmethod\n def fromisoformat(cls,date_string):\n  ''\n  if not isinstance(date_string,str):\n   raise TypeError('fromisoformat: argument must be str')\n   \n   \n  dstr=date_string[0:10]\n  tstr=date_string[11:]\n  \n  try :\n   date_components=_parse_isoformat_date(dstr)\n  except ValueError:\n   raise ValueError('Invalid isoformat string: %s'%date_string)\n   \n  if tstr:\n   try :\n    time_components=_parse_isoformat_time(tstr)\n   except ValueError:\n    raise ValueError('Invalid isoformat string: %s'%date_string)\n  else :\n   time_components=[0,0,0,0,None ]\n   \n  return cls(*(date_components+time_components))\n  \n def timetuple(self):\n  ''\n  dst=self.dst()\n  if dst is None :\n   dst=-1\n  elif dst:\n   dst=1\n  else :\n   dst=0\n  return _build_struct_time(self.year,self.month,self.day,\n  self.hour,self.minute,self.second,\n  dst)\n  \n def _mktime(self):\n  ''\n  epoch=datetime(1970,1,1)\n  max_fold_seconds=24 *3600\n  t=(self -epoch)//timedelta(0,1)\n  def local(u):\n   y,m,d,hh,mm,ss=_time.localtime(u)[:6]\n   return (datetime(y,m,d,hh,mm,ss)-epoch)//timedelta(0,1)\n   \n   \n  a=local(t)-t\n  u1=t -a\n  t1=local(u1)\n  if t1 ==t:\n  \n  \n  \n   u2=u1+(-max_fold_seconds,max_fold_seconds)[self.fold]\n   b=local(u2)-u2\n   if a ==b:\n    return u1\n  else :\n   b=t1 -u1\n   assert a !=b\n  u2=t -b\n  t2=local(u2)\n  if t2 ==t:\n   return u2\n  if t1 ==t:\n   return u1\n   \n   \n  return (max,min)[self.fold](u1,u2)\n  \n  \n def timestamp(self):\n  ''\n  if self._tzinfo is None :\n   s=self._mktime()\n   return s+self.microsecond /1e6\n  else :\n   return (self -_EPOCH).total_seconds()\n   \n def utctimetuple(self):\n  ''\n  offset=self.utcoffset()\n  if offset:\n   self -=offset\n  y,m,d=self.year,self.month,self.day\n  hh,mm,ss=self.hour,self.minute,self.second\n  return _build_struct_time(y,m,d,hh,mm,ss,0)\n  \n def date(self):\n  ''\n  return date(self._year,self._month,self._day)\n  \n def time(self):\n  ''\n  return time(self.hour,self.minute,self.second,self.microsecond,fold=self.fold)\n  \n def timetz(self):\n  ''\n  return time(self.hour,self.minute,self.second,self.microsecond,\n  self._tzinfo,fold=self.fold)\n  \n def replace(self,year=None ,month=None ,day=None ,hour=None ,\n minute=None ,second=None ,microsecond=None ,tzinfo=True ,\n *,fold=None ):\n  ''\n  if year is None :\n   year=self.year\n  if month is None :\n   month=self.month\n  if day is None :\n   day=self.day\n  if hour is None :\n   hour=self.hour\n  if minute is None :\n   minute=self.minute\n  if second is None :\n   second=self.second\n  if microsecond is None :\n   microsecond=self.microsecond\n  if tzinfo is True :\n   tzinfo=self.tzinfo\n  if fold is None :\n   fold=self.fold\n  return type(self)(year,month,day,hour,minute,second,\n  microsecond,tzinfo,fold=fold)\n  \n def _local_timezone(self):\n  if self.tzinfo is None :\n   ts=self._mktime()\n  else :\n   ts=(self -_EPOCH)//timedelta(seconds=1)\n  localtm=_time.localtime(ts)\n  local=datetime(*localtm[:6])\n  try :\n  \n   gmtoff=localtm.tm_gmtoff\n   zone=localtm.tm_zone\n  except AttributeError:\n   delta=local -datetime(*_time.gmtime(ts)[:6])\n   zone=_time.strftime('%Z',localtm)\n   tz=timezone(delta,zone)\n  else :\n   tz=timezone(timedelta(seconds=gmtoff),zone)\n  return tz\n  \n def astimezone(self,tz=None ):\n  if tz is None :\n   tz=self._local_timezone()\n  elif not isinstance(tz,tzinfo):\n   raise TypeError(\"tz argument must be an instance of tzinfo\")\n   \n  mytz=self.tzinfo\n  if mytz is None :\n   mytz=self._local_timezone()\n   myoffset=mytz.utcoffset(self)\n  else :\n   myoffset=mytz.utcoffset(self)\n   if myoffset is None :\n    mytz=self.replace(tzinfo=None )._local_timezone()\n    myoffset=mytz.utcoffset(self)\n    \n  if tz is mytz:\n   return self\n   \n   \n  utc=(self -myoffset).replace(tzinfo=tz)\n  \n  \n  return tz.fromutc(utc)\n  \n  \n  \n def ctime(self):\n  ''\n  weekday=self.toordinal()%7 or 7\n  return \"%s %s %2d %02d:%02d:%02d %04d\"%(\n  _DAYNAMES[weekday],\n  _MONTHNAMES[self._month],\n  self._day,\n  self._hour,self._minute,self._second,\n  self._year)\n  \n def isoformat(self,sep='T',timespec='auto'):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  s=(\"%04d-%02d-%02d%c\"%(self._year,self._month,self._day,sep)+\n  _format_time(self._hour,self._minute,self._second,\n  self._microsecond,timespec))\n  \n  off=self.utcoffset()\n  tz=_format_offset(off)\n  if tz:\n   s +=tz\n   \n  return s\n  \n def __repr__(self):\n  ''\n  L=[self._year,self._month,self._day,\n  self._hour,self._minute,self._second,self._microsecond]\n  if L[-1]==0:\n   del L[-1]\n  if L[-1]==0:\n   del L[-1]\n  s=\"%s.%s(%s)\"%(self.__class__.__module__,\n  self.__class__.__qualname__,\n  \", \".join(map(str,L)))\n  if self._tzinfo is not None :\n   assert s[-1:]==\")\"\n   s=s[:-1]+\", tzinfo=%r\"%self._tzinfo+\")\"\n  if self._fold:\n   assert s[-1:]==\")\"\n   s=s[:-1]+\", fold=1)\"\n  return s\n  \n def __str__(self):\n  ''\n  return self.isoformat(sep=' ')\n  \n @classmethod\n def strptime(cls,date_string,format):\n  ''\n  import _strptime\n  return _strptime._strptime_datetime(cls,date_string,format)\n  \n def utcoffset(self):\n  ''\n  \n  if self._tzinfo is None :\n   return None\n  offset=self._tzinfo.utcoffset(self)\n  _check_utc_offset(\"utcoffset\",offset)\n  return offset\n  \n def tzname(self):\n  ''\n\n\n\n\n  \n  if self._tzinfo is None :\n   return None\n  name=self._tzinfo.tzname(self)\n  _check_tzname(name)\n  return name\n  \n def dst(self):\n  ''\n\n\n\n\n\n\n  \n  if self._tzinfo is None :\n   return None\n  offset=self._tzinfo.dst(self)\n  _check_utc_offset(\"dst\",offset)\n  return offset\n  \n  \n  \n def __eq__(self,other):\n  if isinstance(other,datetime):\n   return self._cmp(other,allow_mixed=True )==0\n  elif not isinstance(other,date):\n   return NotImplemented\n  else :\n   return False\n   \n def __le__(self,other):\n  if isinstance(other,datetime):\n   return self._cmp(other)<=0\n  elif not isinstance(other,date):\n   return NotImplemented\n  else :\n   _cmperror(self,other)\n   \n def __lt__(self,other):\n  if isinstance(other,datetime):\n   return self._cmp(other)<0\n  elif not isinstance(other,date):\n   return NotImplemented\n  else :\n   _cmperror(self,other)\n   \n def __ge__(self,other):\n  if isinstance(other,datetime):\n   return self._cmp(other)>=0\n  elif not isinstance(other,date):\n   return NotImplemented\n  else :\n   _cmperror(self,other)\n   \n def __gt__(self,other):\n  if isinstance(other,datetime):\n   return self._cmp(other)>0\n  elif not isinstance(other,date):\n   return NotImplemented\n  else :\n   _cmperror(self,other)\n   \n def _cmp(self,other,allow_mixed=False ):\n  assert isinstance(other,datetime)\n  mytz=self._tzinfo\n  ottz=other._tzinfo\n  myoff=otoff=None\n  \n  if mytz is ottz:\n   base_compare=True\n  else :\n   myoff=self.utcoffset()\n   otoff=other.utcoffset()\n   \n   if allow_mixed:\n    if myoff !=self.replace(fold=not self.fold).utcoffset():\n     return 2\n    if otoff !=other.replace(fold=not other.fold).utcoffset():\n     return 2\n   base_compare=myoff ==otoff\n   \n  if base_compare:\n   return _cmp((self._year,self._month,self._day,\n   self._hour,self._minute,self._second,\n   self._microsecond),\n   (other._year,other._month,other._day,\n   other._hour,other._minute,other._second,\n   other._microsecond))\n  if myoff is None or otoff is None :\n   if allow_mixed:\n    return 2\n   else :\n    raise TypeError(\"cannot compare naive and aware datetimes\")\n    \n  diff=self -other\n  if diff.days <0:\n   return -1\n  return diff and 1 or 0\n  \n def __add__(self,other):\n  ''\n  if not isinstance(other,timedelta):\n   return NotImplemented\n  delta=timedelta(self.toordinal(),\n  hours=self._hour,\n  minutes=self._minute,\n  seconds=self._second,\n  microseconds=self._microsecond)\n  delta +=other\n  hour,rem=divmod(delta.seconds,3600)\n  minute,second=divmod(rem,60)\n  if 0 <delta.days <=_MAXORDINAL:\n   return datetime.combine(date.fromordinal(delta.days),\n   time(hour,minute,second,\n   delta.microseconds,\n   tzinfo=self._tzinfo))\n  raise OverflowError(\"result out of range\")\n  \n __radd__=__add__\n \n def __sub__(self,other):\n  ''\n  if not isinstance(other,datetime):\n   if isinstance(other,timedelta):\n    return self+-other\n   return NotImplemented\n   \n  days1=self.toordinal()\n  days2=other.toordinal()\n  secs1=self._second+self._minute *60+self._hour *3600\n  secs2=other._second+other._minute *60+other._hour *3600\n  base=timedelta(days1 -days2,\n  secs1 -secs2,\n  self._microsecond -other._microsecond)\n  if self._tzinfo is other._tzinfo:\n   return base\n  myoff=self.utcoffset()\n  otoff=other.utcoffset()\n  if myoff ==otoff:\n   return base\n  if myoff is None or otoff is None :\n   raise TypeError(\"cannot mix naive and timezone-aware time\")\n  return base+otoff -myoff\n  \n def __hash__(self):\n  if self._hashcode ==-1:\n   if self.fold:\n    t=self.replace(fold=0)\n   else :\n    t=self\n   tzoff=t.utcoffset()\n   if tzoff is None :\n    self._hashcode=hash(t._getstate()[0])\n   else :\n    days=_ymd2ord(self.year,self.month,self.day)\n    seconds=self.hour *3600+self.minute *60+self.second\n    self._hashcode=hash(timedelta(days,seconds,self.microsecond)-tzoff)\n  return self._hashcode\n  \n  \n  \n def _getstate(self,protocol=3):\n  yhi,ylo=divmod(self._year,256)\n  us2,us3=divmod(self._microsecond,256)\n  us1,us2=divmod(us2,256)\n  m=self._month\n  if self._fold and protocol >3:\n   m +=128\n  basestate=bytes([yhi,ylo,m,self._day,\n  self._hour,self._minute,self._second,\n  us1,us2,us3])\n  if self._tzinfo is None :\n   return (basestate,)\n  else :\n   return (basestate,self._tzinfo)\n   \n def __setstate(self,string,tzinfo):\n  if tzinfo is not None and not isinstance(tzinfo,_tzinfo_class):\n   raise TypeError(\"bad tzinfo state arg\")\n  (yhi,ylo,m,self._day,self._hour,\n  self._minute,self._second,us1,us2,us3)=string\n  if m >127:\n   self._fold=1\n   self._month=m -128\n  else :\n   self._fold=0\n   self._month=m\n  self._year=yhi *256+ylo\n  self._microsecond=(((us1 <<8)|us2)<<8)|us3\n  self._tzinfo=tzinfo\n  \n def __reduce_ex__(self,protocol):\n  return (self.__class__,self._getstate(protocol))\n  \n def __reduce__(self):\n  return self.__reduce_ex__(2)\n  \n  \ndatetime.min=datetime(1,1,1)\ndatetime.max=datetime(9999,12,31,23,59,59,999999)\ndatetime.resolution=timedelta(microseconds=1)\n\n\ndef _isoweek1monday(year):\n\n\n THURSDAY=3\n firstday=_ymd2ord(year,1,1)\n firstweekday=(firstday+6)%7\n week1monday=firstday -firstweekday\n if firstweekday >THURSDAY:\n  week1monday +=7\n return week1monday\n \nclass timezone(tzinfo):\n __slots__='_offset','_name'\n \n \n _Omitted=object()\n def __new__(cls,offset,name=_Omitted):\n  if not isinstance(offset,timedelta):\n   raise TypeError(\"offset must be a timedelta\")\n  if name is cls._Omitted:\n   if not offset:\n    return cls.utc\n   name=None\n  elif not isinstance(name,str):\n   raise TypeError(\"name must be a string\")\n  if not cls._minoffset <=offset <=cls._maxoffset:\n   raise ValueError(\"offset must be a timedelta \"\n   \"strictly between -timedelta(hours=24) and \"\n   \"timedelta(hours=24).\")\n  return cls._create(offset,name)\n  \n @classmethod\n def _create(cls,offset,name=None ):\n  self=tzinfo.__new__(cls)\n  self._offset=offset\n  self._name=name\n  return self\n  \n def __getinitargs__(self):\n  ''\n  if self._name is None :\n   return (self._offset,)\n  return (self._offset,self._name)\n  \n def __eq__(self,other):\n  if type(other)!=timezone:\n   return False\n  return self._offset ==other._offset\n  \n def __hash__(self):\n  return hash(self._offset)\n  \n def __repr__(self):\n  ''\n\n\n\n\n\n\n\n  \n  if self is self.utc:\n   return 'datetime.timezone.utc'\n  if self._name is None :\n   return \"%s.%s(%r)\"%(self.__class__.__module__,\n   self.__class__.__qualname__,\n   self._offset)\n  return \"%s.%s(%r, %r)\"%(self.__class__.__module__,\n  self.__class__.__qualname__,\n  self._offset,self._name)\n  \n def __str__(self):\n  return self.tzname(None )\n  \n def utcoffset(self,dt):\n  if isinstance(dt,datetime)or dt is None :\n   return self._offset\n  raise TypeError(\"utcoffset() argument must be a datetime instance\"\n  \" or None\")\n  \n def tzname(self,dt):\n  if isinstance(dt,datetime)or dt is None :\n   if self._name is None :\n    return self._name_from_offset(self._offset)\n   return self._name\n  raise TypeError(\"tzname() argument must be a datetime instance\"\n  \" or None\")\n  \n def dst(self,dt):\n  if isinstance(dt,datetime)or dt is None :\n   return None\n  raise TypeError(\"dst() argument must be a datetime instance\"\n  \" or None\")\n  \n def fromutc(self,dt):\n  if isinstance(dt,datetime):\n   if dt.tzinfo is not self:\n    raise ValueError(\"fromutc: dt.tzinfo \"\n    \"is not self\")\n   return dt+self._offset\n  raise TypeError(\"fromutc() argument must be a datetime instance\"\n  \" or None\")\n  \n _maxoffset=timedelta(hours=23,minutes=59)\n _minoffset=-_maxoffset\n \n @staticmethod\n def _name_from_offset(delta):\n  if not delta:\n   return 'UTC'\n  if delta <timedelta(0):\n   sign='-'\n   delta=-delta\n  else :\n   sign='+'\n  hours,rest=divmod(delta,timedelta(hours=1))\n  minutes,rest=divmod(rest,timedelta(minutes=1))\n  seconds=rest.seconds\n  microseconds=rest.microseconds\n  if microseconds:\n   return (f'UTC{sign}{hours:02d}:{minutes:02d}:{seconds:02d}'\n   f'.{microseconds:06d}')\n  if seconds:\n   return f'UTC{sign}{hours:02d}:{minutes:02d}:{seconds:02d}'\n  return f'UTC{sign}{hours:02d}:{minutes:02d}'\n  \ntimezone.utc=timezone._create(timedelta(0))\ntimezone.min=timezone._create(timezone._minoffset)\ntimezone.max=timezone._create(timezone._maxoffset)\n_EPOCH=datetime(1970,1,1,tzinfo=timezone.utc)\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\ntry :\n from _datetime import *\nexcept ImportError:\n pass\nelse :\n\n del (_DAYNAMES,_DAYS_BEFORE_MONTH,_DAYS_IN_MONTH,_DI100Y,_DI400Y,\n _DI4Y,_EPOCH,_MAXORDINAL,_MONTHNAMES,_build_struct_time,\n _check_date_fields,_check_int_field,_check_time_fields,\n _check_tzinfo_arg,_check_tzname,_check_utc_offset,_cmp,_cmperror,\n _date_class,_days_before_month,_days_before_year,_days_in_month,\n _format_time,_format_offset,_is_leap,_isoweek1monday,_math,\n _ord2ymd,_time,_time_class,_tzinfo_class,_wrap_strftime,_ymd2ord,\n _divide_and_round,_parse_isoformat_date,_parse_isoformat_time,\n _parse_hh_mm_ss_ff)\n \n \n \n \n from _datetime import __doc__\n", ["_datetime", "_strptime", "math", "time"]], "decimal": [".py", "\ntry :\n from _decimal import *\n from _decimal import __doc__\n from _decimal import __version__\n from _decimal import __libmpdec_version__\nexcept ImportError:\n from _pydecimal import *\n from _pydecimal import __doc__\n from _pydecimal import __version__\n from _pydecimal import __libmpdec_version__\n", ["_decimal", "_pydecimal"]], "difflib": [".py", "''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n__all__=['get_close_matches','ndiff','restore','SequenceMatcher',\n'Differ','IS_CHARACTER_JUNK','IS_LINE_JUNK','context_diff',\n'unified_diff','diff_bytes','HtmlDiff','Match']\n\nfrom heapq import nlargest as _nlargest\nfrom collections import namedtuple as _namedtuple\n\nMatch=_namedtuple('Match','a b size')\n\ndef _calculate_ratio(matches,length):\n if length:\n  return 2.0 *matches /length\n return 1.0\n \nclass SequenceMatcher:\n\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n def __init__(self,isjunk=None ,a='',b='',autojunk=True ):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  self.isjunk=isjunk\n  self.a=self.b=None\n  self.autojunk=autojunk\n  self.set_seqs(a,b)\n  \n def set_seqs(self,a,b):\n  ''\n\n\n\n\n\n  \n  \n  self.set_seq1(a)\n  self.set_seq2(b)\n  \n def set_seq1(self,a):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  \n  if a is self.a:\n   return\n  self.a=a\n  self.matching_blocks=self.opcodes=None\n  \n def set_seq2(self,b):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  \n  if b is self.b:\n   return\n  self.b=b\n  self.matching_blocks=self.opcodes=None\n  self.fullbcount=None\n  self.__chain_b()\n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n def __chain_b(self):\n \n \n \n \n \n \n \n \n \n \n  b=self.b\n  self.b2j=b2j={}\n  \n  for i,elt in enumerate(b):\n   indices=b2j.setdefault(elt,[])\n   indices.append(i)\n   \n   \n  self.bjunk=junk=set()\n  isjunk=self.isjunk\n  if isjunk:\n   for elt in b2j.keys():\n    if isjunk(elt):\n     junk.add(elt)\n   for elt in junk:\n    del b2j[elt]\n    \n    \n  self.bpopular=popular=set()\n  n=len(b)\n  if self.autojunk and n >=200:\n   ntest=n //100+1\n   for elt,idxs in b2j.items():\n    if len(idxs)>ntest:\n     popular.add(elt)\n   for elt in popular:\n    del b2j[elt]\n    \n def find_longest_match(self,alo,ahi,blo,bhi):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  a,b,b2j,isbjunk=self.a,self.b,self.b2j,self.bjunk.__contains__\n  besti,bestj,bestsize=alo,blo,0\n  \n  \n  \n  j2len={}\n  nothing=[]\n  for i in range(alo,ahi):\n  \n  \n   j2lenget=j2len.get\n   newj2len={}\n   for j in b2j.get(a[i],nothing):\n   \n    if j <blo:\n     continue\n    if j >=bhi:\n     break\n    k=newj2len[j]=j2lenget(j -1,0)+1\n    if k >bestsize:\n     besti,bestj,bestsize=i -k+1,j -k+1,k\n   j2len=newj2len\n   \n   \n   \n   \n   \n  while besti >alo and bestj >blo and\\\n  not isbjunk(b[bestj -1])and\\\n  a[besti -1]==b[bestj -1]:\n   besti,bestj,bestsize=besti -1,bestj -1,bestsize+1\n  while besti+bestsize <ahi and bestj+bestsize <bhi and\\\n  not isbjunk(b[bestj+bestsize])and\\\n  a[besti+bestsize]==b[bestj+bestsize]:\n   bestsize +=1\n   \n   \n   \n   \n   \n   \n   \n   \n  while besti >alo and bestj >blo and\\\n  isbjunk(b[bestj -1])and\\\n  a[besti -1]==b[bestj -1]:\n   besti,bestj,bestsize=besti -1,bestj -1,bestsize+1\n  while besti+bestsize <ahi and bestj+bestsize <bhi and\\\n  isbjunk(b[bestj+bestsize])and\\\n  a[besti+bestsize]==b[bestj+bestsize]:\n   bestsize=bestsize+1\n   \n  return Match(besti,bestj,bestsize)\n  \n def get_matching_blocks(self):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  \n  if self.matching_blocks is not None :\n   return self.matching_blocks\n  la,lb=len(self.a),len(self.b)\n  \n  \n  \n  \n  \n  \n  \n  queue=[(0,la,0,lb)]\n  matching_blocks=[]\n  while queue:\n   alo,ahi,blo,bhi=queue.pop()\n   i,j,k=x=self.find_longest_match(alo,ahi,blo,bhi)\n   \n   \n   \n   if k:\n    matching_blocks.append(x)\n    if alo <i and blo <j:\n     queue.append((alo,i,blo,j))\n    if i+k <ahi and j+k <bhi:\n     queue.append((i+k,ahi,j+k,bhi))\n  matching_blocks.sort()\n  \n  \n  \n  \n  i1=j1=k1=0\n  non_adjacent=[]\n  for i2,j2,k2 in matching_blocks:\n  \n   if i1+k1 ==i2 and j1+k1 ==j2:\n   \n   \n   \n    k1 +=k2\n   else :\n   \n   \n   \n    if k1:\n     non_adjacent.append((i1,j1,k1))\n    i1,j1,k1=i2,j2,k2\n  if k1:\n   non_adjacent.append((i1,j1,k1))\n   \n  non_adjacent.append((la,lb,0))\n  self.matching_blocks=list(map(Match._make,non_adjacent))\n  return self.matching_blocks\n  \n def get_opcodes(self):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  \n  if self.opcodes is not None :\n   return self.opcodes\n  i=j=0\n  self.opcodes=answer=[]\n  for ai,bj,size in self.get_matching_blocks():\n  \n  \n  \n  \n  \n   tag=''\n   if i <ai and j <bj:\n    tag='replace'\n   elif i <ai:\n    tag='delete'\n   elif j <bj:\n    tag='insert'\n   if tag:\n    answer.append((tag,i,ai,j,bj))\n   i,j=ai+size,bj+size\n   \n   \n   if size:\n    answer.append(('equal',ai,i,bj,j))\n  return answer\n  \n def get_grouped_opcodes(self,n=3):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  \n  codes=self.get_opcodes()\n  if not codes:\n   codes=[(\"equal\",0,1,0,1)]\n   \n  if codes[0][0]=='equal':\n   tag,i1,i2,j1,j2=codes[0]\n   codes[0]=tag,max(i1,i2 -n),i2,max(j1,j2 -n),j2\n  if codes[-1][0]=='equal':\n   tag,i1,i2,j1,j2=codes[-1]\n   codes[-1]=tag,i1,min(i2,i1+n),j1,min(j2,j1+n)\n   \n  nn=n+n\n  group=[]\n  for tag,i1,i2,j1,j2 in codes:\n  \n  \n   if tag =='equal'and i2 -i1 >nn:\n    group.append((tag,i1,min(i2,i1+n),j1,min(j2,j1+n)))\n    yield group\n    group=[]\n    i1,j1=max(i1,i2 -n),max(j1,j2 -n)\n   group.append((tag,i1,i2,j1,j2))\n  if group and not (len(group)==1 and group[0][0]=='equal'):\n   yield group\n   \n def ratio(self):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  \n  matches=sum(triple[-1]for triple in self.get_matching_blocks())\n  return _calculate_ratio(matches,len(self.a)+len(self.b))\n  \n def quick_ratio(self):\n  ''\n\n\n\n  \n  \n  \n  \n  \n  if self.fullbcount is None :\n   self.fullbcount=fullbcount={}\n   for elt in self.b:\n    fullbcount[elt]=fullbcount.get(elt,0)+1\n  fullbcount=self.fullbcount\n  \n  \n  avail={}\n  availhas,matches=avail.__contains__,0\n  for elt in self.a:\n   if availhas(elt):\n    numb=avail[elt]\n   else :\n    numb=fullbcount.get(elt,0)\n   avail[elt]=numb -1\n   if numb >0:\n    matches=matches+1\n  return _calculate_ratio(matches,len(self.a)+len(self.b))\n  \n def real_quick_ratio(self):\n  ''\n\n\n\n  \n  \n  la,lb=len(self.a),len(self.b)\n  \n  \n  return _calculate_ratio(min(la,lb),la+lb)\n  \ndef get_close_matches(word,possibilities,n=3,cutoff=0.6):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n if not n >0:\n  raise ValueError(\"n must be > 0: %r\"%(n,))\n if not 0.0 <=cutoff <=1.0:\n  raise ValueError(\"cutoff must be in [0.0, 1.0]: %r\"%(cutoff,))\n result=[]\n s=SequenceMatcher()\n s.set_seq2(word)\n for x in possibilities:\n  s.set_seq1(x)\n  if s.real_quick_ratio()>=cutoff and\\\n  s.quick_ratio()>=cutoff and\\\n  s.ratio()>=cutoff:\n   result.append((s.ratio(),x))\n   \n   \n result=_nlargest(n,result)\n \n return [x for score,x in result]\n \ndef _count_leading(line,ch):\n ''\n\n\n\n\n\n\n \n \n i,n=0,len(line)\n while i <n and line[i]==ch:\n  i +=1\n return i\n \nclass Differ:\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n def __init__(self,linejunk=None ,charjunk=None ):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  \n  self.linejunk=linejunk\n  self.charjunk=charjunk\n  \n def compare(self,a,b):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  \n  cruncher=SequenceMatcher(self.linejunk,a,b)\n  for tag,alo,ahi,blo,bhi in cruncher.get_opcodes():\n   if tag =='replace':\n    g=self._fancy_replace(a,alo,ahi,b,blo,bhi)\n   elif tag =='delete':\n    g=self._dump('-',a,alo,ahi)\n   elif tag =='insert':\n    g=self._dump('+',b,blo,bhi)\n   elif tag =='equal':\n    g=self._dump(' ',a,alo,ahi)\n   else :\n    raise ValueError('unknown tag %r'%(tag,))\n    \n   yield from g\n   \n def _dump(self,tag,x,lo,hi):\n  ''\n  for i in range(lo,hi):\n   yield '%s %s'%(tag,x[i])\n   \n def _plain_replace(self,a,alo,ahi,b,blo,bhi):\n  assert alo <ahi and blo <bhi\n  \n  \n  if bhi -blo <ahi -alo:\n   first=self._dump('+',b,blo,bhi)\n   second=self._dump('-',a,alo,ahi)\n  else :\n   first=self._dump('-',a,alo,ahi)\n   second=self._dump('+',b,blo,bhi)\n   \n  for g in first,second:\n   yield from g\n   \n def _fancy_replace(self,a,alo,ahi,b,blo,bhi):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  \n  \n  \n  best_ratio,cutoff=0.74,0.75\n  cruncher=SequenceMatcher(self.charjunk)\n  eqi,eqj=None ,None\n  \n  \n  \n  \n  for j in range(blo,bhi):\n   bj=b[j]\n   cruncher.set_seq2(bj)\n   for i in range(alo,ahi):\n    ai=a[i]\n    if ai ==bj:\n     if eqi is None :\n      eqi,eqj=i,j\n     continue\n    cruncher.set_seq1(ai)\n    \n    \n    \n    \n    \n    \n    if cruncher.real_quick_ratio()>best_ratio and\\\n    cruncher.quick_ratio()>best_ratio and\\\n    cruncher.ratio()>best_ratio:\n     best_ratio,best_i,best_j=cruncher.ratio(),i,j\n  if best_ratio <cutoff:\n  \n   if eqi is None :\n   \n    yield from self._plain_replace(a,alo,ahi,b,blo,bhi)\n    return\n    \n   best_i,best_j,best_ratio=eqi,eqj,1.0\n  else :\n  \n   eqi=None\n   \n   \n   \n   \n   \n  yield from self._fancy_helper(a,alo,best_i,b,blo,best_j)\n  \n  \n  aelt,belt=a[best_i],b[best_j]\n  if eqi is None :\n  \n   atags=btags=\"\"\n   cruncher.set_seqs(aelt,belt)\n   for tag,ai1,ai2,bj1,bj2 in cruncher.get_opcodes():\n    la,lb=ai2 -ai1,bj2 -bj1\n    if tag =='replace':\n     atags +='^'*la\n     btags +='^'*lb\n    elif tag =='delete':\n     atags +='-'*la\n    elif tag =='insert':\n     btags +='+'*lb\n    elif tag =='equal':\n     atags +=' '*la\n     btags +=' '*lb\n    else :\n     raise ValueError('unknown tag %r'%(tag,))\n   yield from self._qformat(aelt,belt,atags,btags)\n  else :\n  \n   yield '  '+aelt\n   \n   \n  yield from self._fancy_helper(a,best_i+1,ahi,b,best_j+1,bhi)\n  \n def _fancy_helper(self,a,alo,ahi,b,blo,bhi):\n  g=[]\n  if alo <ahi:\n   if blo <bhi:\n    g=self._fancy_replace(a,alo,ahi,b,blo,bhi)\n   else :\n    g=self._dump('-',a,alo,ahi)\n  elif blo <bhi:\n   g=self._dump('+',b,blo,bhi)\n   \n  yield from g\n  \n def _qformat(self,aline,bline,atags,btags):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  \n  \n  common=min(_count_leading(aline,\"\\t\"),\n  _count_leading(bline,\"\\t\"))\n  common=min(common,_count_leading(atags[:common],\" \"))\n  common=min(common,_count_leading(btags[:common],\" \"))\n  atags=atags[common:].rstrip()\n  btags=btags[common:].rstrip()\n  \n  yield \"- \"+aline\n  if atags:\n   yield \"? %s%s\\n\"%(\"\\t\"*common,atags)\n   \n  yield \"+ \"+bline\n  if btags:\n   yield \"? %s%s\\n\"%(\"\\t\"*common,btags)\n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \nimport re\n\ndef IS_LINE_JUNK(line,pat=re.compile(r\"\\s*(?:#\\s*)?$\").match):\n ''\n\n\n\n\n\n\n\n\n\n\n \n \n return pat(line)is not None\n \ndef IS_CHARACTER_JUNK(ch,ws=\" \\t\"):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n return ch in ws\n \n \n \n \n \n \ndef _format_range_unified(start,stop):\n ''\n \n beginning=start+1\n length=stop -start\n if length ==1:\n  return '{}'.format(beginning)\n if not length:\n  beginning -=1\n return '{},{}'.format(beginning,length)\n \ndef unified_diff(a,b,fromfile='',tofile='',fromfiledate='',\ntofiledate='',n=3,lineterm='\\n'):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n _check_types(a,b,fromfile,tofile,fromfiledate,tofiledate,lineterm)\n started=False\n for group in SequenceMatcher(None ,a,b).get_grouped_opcodes(n):\n  if not started:\n   started=True\n   fromdate='\\t{}'.format(fromfiledate)if fromfiledate else ''\n   todate='\\t{}'.format(tofiledate)if tofiledate else ''\n   yield '--- {}{}{}'.format(fromfile,fromdate,lineterm)\n   yield '+++ {}{}{}'.format(tofile,todate,lineterm)\n   \n  first,last=group[0],group[-1]\n  file1_range=_format_range_unified(first[1],last[2])\n  file2_range=_format_range_unified(first[3],last[4])\n  yield '@@ -{} +{} @@{}'.format(file1_range,file2_range,lineterm)\n  \n  for tag,i1,i2,j1,j2 in group:\n   if tag =='equal':\n    for line in a[i1:i2]:\n     yield ' '+line\n    continue\n   if tag in {'replace','delete'}:\n    for line in a[i1:i2]:\n     yield '-'+line\n   if tag in {'replace','insert'}:\n    for line in b[j1:j2]:\n     yield '+'+line\n     \n     \n     \n     \n     \n     \ndef _format_range_context(start,stop):\n ''\n \n beginning=start+1\n length=stop -start\n if not length:\n  beginning -=1\n if length <=1:\n  return '{}'.format(beginning)\n return '{},{}'.format(beginning,beginning+length -1)\n \n \ndef context_diff(a,b,fromfile='',tofile='',\nfromfiledate='',tofiledate='',n=3,lineterm='\\n'):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n _check_types(a,b,fromfile,tofile,fromfiledate,tofiledate,lineterm)\n prefix=dict(insert='+ ',delete='- ',replace='! ',equal='  ')\n started=False\n for group in SequenceMatcher(None ,a,b).get_grouped_opcodes(n):\n  if not started:\n   started=True\n   fromdate='\\t{}'.format(fromfiledate)if fromfiledate else ''\n   todate='\\t{}'.format(tofiledate)if tofiledate else ''\n   yield '*** {}{}{}'.format(fromfile,fromdate,lineterm)\n   yield '--- {}{}{}'.format(tofile,todate,lineterm)\n   \n  first,last=group[0],group[-1]\n  yield '***************'+lineterm\n  \n  file1_range=_format_range_context(first[1],last[2])\n  yield '*** {} ****{}'.format(file1_range,lineterm)\n  \n  if any(tag in {'replace','delete'}for tag,_,_,_,_ in group):\n   for tag,i1,i2,_,_ in group:\n    if tag !='insert':\n     for line in a[i1:i2]:\n      yield prefix[tag]+line\n      \n  file2_range=_format_range_context(first[3],last[4])\n  yield '--- {} ----{}'.format(file2_range,lineterm)\n  \n  if any(tag in {'replace','insert'}for tag,_,_,_,_ in group):\n   for tag,_,_,j1,j2 in group:\n    if tag !='delete':\n     for line in b[j1:j2]:\n      yield prefix[tag]+line\n      \ndef _check_types(a,b,*args):\n\n\n\n\n\n\n if a and not isinstance(a[0],str):\n  raise TypeError('lines to compare must be str, not %s (%r)'%\n  (type(a[0]).__name__,a[0]))\n if b and not isinstance(b[0],str):\n  raise TypeError('lines to compare must be str, not %s (%r)'%\n  (type(b[0]).__name__,b[0]))\n for arg in args:\n  if not isinstance(arg,str):\n   raise TypeError('all arguments must be str, not: %r'%(arg,))\n   \ndef diff_bytes(dfunc,a,b,fromfile=b'',tofile=b'',\nfromfiledate=b'',tofiledate=b'',n=3,lineterm=b'\\n'):\n ''\n\n\n\n\n\n\n\n \n def decode(s):\n  try :\n   return s.decode('ascii','surrogateescape')\n  except AttributeError as err:\n   msg=('all arguments must be bytes, not %s (%r)'%\n   (type(s).__name__,s))\n   raise TypeError(msg)from err\n a=list(map(decode,a))\n b=list(map(decode,b))\n fromfile=decode(fromfile)\n tofile=decode(tofile)\n fromfiledate=decode(fromfiledate)\n tofiledate=decode(tofiledate)\n lineterm=decode(lineterm)\n \n lines=dfunc(a,b,fromfile,tofile,fromfiledate,tofiledate,n,lineterm)\n for line in lines:\n  yield line.encode('ascii','surrogateescape')\n  \ndef ndiff(a,b,linejunk=None ,charjunk=IS_CHARACTER_JUNK):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n return Differ(linejunk,charjunk).compare(a,b)\n \ndef _mdiff(fromlines,tolines,context=None ,linejunk=None ,\ncharjunk=IS_CHARACTER_JUNK):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n import re\n \n \n change_re=re.compile(r'(\\++|\\-+|\\^+)')\n \n \n diff_lines_iterator=ndiff(fromlines,tolines,linejunk,charjunk)\n \n def _make_line(lines,format_key,side,num_lines=[0,0]):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  num_lines[side]+=1\n  \n  \n  if format_key is None :\n   return (num_lines[side],lines.pop(0)[2:])\n   \n  if format_key =='?':\n   text,markers=lines.pop(0),lines.pop(0)\n   \n   sub_info=[]\n   def record_sub_info(match_object,sub_info=sub_info):\n    sub_info.append([match_object.group(1)[0],match_object.span()])\n    return match_object.group(1)\n   change_re.sub(record_sub_info,markers)\n   \n   \n   for key,(begin,end)in reversed(sub_info):\n    text=text[0:begin]+'\\0'+key+text[begin:end]+'\\1'+text[end:]\n   text=text[2:]\n   \n  else :\n   text=lines.pop(0)[2:]\n   \n   \n   if not text:\n    text=' '\n    \n   text='\\0'+format_key+text+'\\1'\n   \n   \n   \n  return (num_lines[side],text)\n  \n def _line_iterator():\n  ''\n\n\n\n\n\n\n\n\n\n\n\n  \n  lines=[]\n  num_blanks_pending,num_blanks_to_yield=0,0\n  while True :\n  \n  \n  \n   while len(lines)<4:\n    lines.append(next(diff_lines_iterator,'X'))\n   s=''.join([line[0]for line in lines])\n   if s.startswith('X'):\n   \n   \n   \n    num_blanks_to_yield=num_blanks_pending\n   elif s.startswith('-?+?'):\n   \n    yield _make_line(lines,'?',0),_make_line(lines,'?',1),True\n    continue\n   elif s.startswith('--++'):\n   \n   \n    num_blanks_pending -=1\n    yield _make_line(lines,'-',0),None ,True\n    continue\n   elif s.startswith(('--?+','--+','- ')):\n   \n   \n    from_line,to_line=_make_line(lines,'-',0),None\n    num_blanks_to_yield,num_blanks_pending=num_blanks_pending -1,0\n   elif s.startswith('-+?'):\n   \n    yield _make_line(lines,None ,0),_make_line(lines,'?',1),True\n    continue\n   elif s.startswith('-?+'):\n   \n    yield _make_line(lines,'?',0),_make_line(lines,None ,1),True\n    continue\n   elif s.startswith('-'):\n   \n    num_blanks_pending -=1\n    yield _make_line(lines,'-',0),None ,True\n    continue\n   elif s.startswith('+--'):\n   \n   \n    num_blanks_pending +=1\n    yield None ,_make_line(lines,'+',1),True\n    continue\n   elif s.startswith(('+ ','+-')):\n   \n    from_line,to_line=None ,_make_line(lines,'+',1)\n    num_blanks_to_yield,num_blanks_pending=num_blanks_pending+1,0\n   elif s.startswith('+'):\n   \n    num_blanks_pending +=1\n    yield None ,_make_line(lines,'+',1),True\n    continue\n   elif s.startswith(' '):\n   \n    yield _make_line(lines[:],None ,0),_make_line(lines,None ,1),False\n    continue\n    \n    \n   while (num_blanks_to_yield <0):\n    num_blanks_to_yield +=1\n    yield None ,('','\\n'),True\n   while (num_blanks_to_yield >0):\n    num_blanks_to_yield -=1\n    yield ('','\\n'),None ,True\n   if s.startswith('X'):\n    return\n   else :\n    yield from_line,to_line,True\n    \n def _line_pair_iterator():\n  ''\n\n\n\n\n\n\n\n\n\n\n  \n  line_iterator=_line_iterator()\n  fromlines,tolines=[],[]\n  while True :\n  \n   while (len(fromlines)==0 or len(tolines)==0):\n    try :\n     from_line,to_line,found_diff=next(line_iterator)\n    except StopIteration:\n     return\n    if from_line is not None :\n     fromlines.append((from_line,found_diff))\n    if to_line is not None :\n     tolines.append((to_line,found_diff))\n     \n   from_line,fromDiff=fromlines.pop(0)\n   to_line,to_diff=tolines.pop(0)\n   yield (from_line,to_line,fromDiff or to_diff)\n   \n   \n   \n line_pair_iterator=_line_pair_iterator()\n if context is None :\n  yield from line_pair_iterator\n  \n  \n else :\n  context +=1\n  lines_to_write=0\n  while True :\n  \n  \n  \n   index,contextLines=0,[None ]*(context)\n   found_diff=False\n   while (found_diff is False ):\n    try :\n     from_line,to_line,found_diff=next(line_pair_iterator)\n    except StopIteration:\n     return\n    i=index %context\n    contextLines[i]=(from_line,to_line,found_diff)\n    index +=1\n    \n    \n   if index >context:\n    yield None ,None ,None\n    lines_to_write=context\n   else :\n    lines_to_write=index\n    index=0\n   while (lines_to_write):\n    i=index %context\n    index +=1\n    yield contextLines[i]\n    lines_to_write -=1\n    \n   lines_to_write=context -1\n   try :\n    while (lines_to_write):\n     from_line,to_line,found_diff=next(line_pair_iterator)\n     \n     if found_diff:\n      lines_to_write=context -1\n     else :\n      lines_to_write -=1\n     yield from_line,to_line,found_diff\n   except StopIteration:\n   \n    return\n    \n    \n_file_template=\"\"\"\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"\n          \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n\n<html>\n\n<head>\n    <meta http-equiv=\"Content-Type\"\n          content=\"text/html; charset=%(charset)s\" />\n    <title></title>\n    <style type=\"text/css\">%(styles)s\n    </style>\n</head>\n\n<body>\n    %(table)s%(legend)s\n</body>\n\n</html>\"\"\"\n\n_styles=\"\"\"\n        table.diff {font-family:Courier; border:medium;}\n        .diff_header {background-color:#e0e0e0}\n        td.diff_header {text-align:right}\n        .diff_next {background-color:#c0c0c0}\n        .diff_add {background-color:#aaffaa}\n        .diff_chg {background-color:#ffff77}\n        .diff_sub {background-color:#ffaaaa}\"\"\"\n\n_table_template=\"\"\"\n    <table class=\"diff\" id=\"difflib_chg_%(prefix)s_top\"\n           cellspacing=\"0\" cellpadding=\"0\" rules=\"groups\" >\n        <colgroup></colgroup> <colgroup></colgroup> <colgroup></colgroup>\n        <colgroup></colgroup> <colgroup></colgroup> <colgroup></colgroup>\n        %(header_row)s\n        <tbody>\n%(data_rows)s        </tbody>\n    </table>\"\"\"\n\n_legend=\"\"\"\n    <table class=\"diff\" summary=\"Legends\">\n        <tr> <th colspan=\"2\"> Legends </th> </tr>\n        <tr> <td> <table border=\"\" summary=\"Colors\">\n                      <tr><th> Colors </th> </tr>\n                      <tr><td class=\"diff_add\">&nbsp;Added&nbsp;</td></tr>\n                      <tr><td class=\"diff_chg\">Changed</td> </tr>\n                      <tr><td class=\"diff_sub\">Deleted</td> </tr>\n                  </table></td>\n             <td> <table border=\"\" summary=\"Links\">\n                      <tr><th colspan=\"2\"> Links </th> </tr>\n                      <tr><td>(f)irst change</td> </tr>\n                      <tr><td>(n)ext change</td> </tr>\n                      <tr><td>(t)op</td> </tr>\n                  </table></td> </tr>\n    </table>\"\"\"\n\nclass HtmlDiff(object):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n _file_template=_file_template\n _styles=_styles\n _table_template=_table_template\n _legend=_legend\n _default_prefix=0\n \n def __init__(self,tabsize=8,wrapcolumn=None ,linejunk=None ,\n charjunk=IS_CHARACTER_JUNK):\n  ''\n\n\n\n\n\n\n\n\n  \n  self._tabsize=tabsize\n  self._wrapcolumn=wrapcolumn\n  self._linejunk=linejunk\n  self._charjunk=charjunk\n  \n def make_file(self,fromlines,tolines,fromdesc='',todesc='',\n context=False ,numlines=5,*,charset='utf-8'):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  \n  return (self._file_template %dict(\n  styles=self._styles,\n  legend=self._legend,\n  table=self.make_table(fromlines,tolines,fromdesc,todesc,\n  context=context,numlines=numlines),\n  charset=charset\n  )).encode(charset,'xmlcharrefreplace').decode(charset)\n  \n def _tab_newline_replace(self,fromlines,tolines):\n  ''\n\n\n\n\n\n\n\n  \n  def expand_tabs(line):\n  \n   line=line.replace(' ','\\0')\n   \n   line=line.expandtabs(self._tabsize)\n   \n   \n   line=line.replace(' ','\\t')\n   return line.replace('\\0',' ').rstrip('\\n')\n  fromlines=[expand_tabs(line)for line in fromlines]\n  tolines=[expand_tabs(line)for line in tolines]\n  return fromlines,tolines\n  \n def _split_line(self,data_list,line_num,text):\n  ''\n\n\n\n\n\n\n  \n  \n  if not line_num:\n   data_list.append((line_num,text))\n   return\n   \n   \n  size=len(text)\n  max=self._wrapcolumn\n  if (size <=max)or ((size -(text.count('\\0')*3))<=max):\n   data_list.append((line_num,text))\n   return\n   \n   \n   \n  i=0\n  n=0\n  mark=''\n  while n <max and i <size:\n   if text[i]=='\\0':\n    i +=1\n    mark=text[i]\n    i +=1\n   elif text[i]=='\\1':\n    i +=1\n    mark=''\n   else :\n    i +=1\n    n +=1\n    \n    \n  line1=text[:i]\n  line2=text[i:]\n  \n  \n  \n  \n  if mark:\n   line1=line1+'\\1'\n   line2='\\0'+mark+line2\n   \n   \n  data_list.append((line_num,line1))\n  \n  \n  self._split_line(data_list,'>',line2)\n  \n def _line_wrapper(self,diffs):\n  ''\n  \n  \n  for fromdata,todata,flag in diffs:\n  \n   if flag is None :\n    yield fromdata,todata,flag\n    continue\n   (fromline,fromtext),(toline,totext)=fromdata,todata\n   \n   \n   fromlist,tolist=[],[]\n   self._split_line(fromlist,fromline,fromtext)\n   self._split_line(tolist,toline,totext)\n   \n   \n   while fromlist or tolist:\n    if fromlist:\n     fromdata=fromlist.pop(0)\n    else :\n     fromdata=('',' ')\n    if tolist:\n     todata=tolist.pop(0)\n    else :\n     todata=('',' ')\n    yield fromdata,todata,flag\n    \n def _collect_lines(self,diffs):\n  ''\n\n\n\n  \n  \n  fromlist,tolist,flaglist=[],[],[]\n  \n  for fromdata,todata,flag in diffs:\n   try :\n   \n    fromlist.append(self._format_line(0,flag,*fromdata))\n    tolist.append(self._format_line(1,flag,*todata))\n   except TypeError:\n   \n    fromlist.append(None )\n    tolist.append(None )\n   flaglist.append(flag)\n  return fromlist,tolist,flaglist\n  \n def _format_line(self,side,flag,linenum,text):\n  ''\n\n\n\n\n\n  \n  try :\n   linenum='%d'%linenum\n   id=' id=\"%s%s\"'%(self._prefix[side],linenum)\n  except TypeError:\n  \n   id=''\n   \n  text=text.replace(\"&\",\"&amp;\").replace(\">\",\"&gt;\").replace(\"<\",\"&lt;\")\n  \n  \n  text=text.replace(' ','&nbsp;').rstrip()\n  \n  return '<td class=\"diff_header\"%s>%s</td><td nowrap=\"nowrap\">%s</td>'\\\n  %(id,linenum,text)\n  \n def _make_prefix(self):\n  ''\n  \n  \n  \n  fromprefix=\"from%d_\"%HtmlDiff._default_prefix\n  toprefix=\"to%d_\"%HtmlDiff._default_prefix\n  HtmlDiff._default_prefix +=1\n  \n  self._prefix=[fromprefix,toprefix]\n  \n def _convert_flags(self,fromlist,tolist,flaglist,context,numlines):\n  ''\n  \n  \n  toprefix=self._prefix[1]\n  \n  \n  next_id=['']*len(flaglist)\n  next_href=['']*len(flaglist)\n  num_chg,in_change=0,False\n  last=0\n  for i,flag in enumerate(flaglist):\n   if flag:\n    if not in_change:\n     in_change=True\n     last=i\n     \n     \n     \n     i=max([0,i -numlines])\n     next_id[i]=' id=\"difflib_chg_%s_%d\"'%(toprefix,num_chg)\n     \n     \n     num_chg +=1\n     next_href[last]='<a href=\"#difflib_chg_%s_%d\">n</a>'%(\n     toprefix,num_chg)\n   else :\n    in_change=False\n    \n  if not flaglist:\n   flaglist=[False ]\n   next_id=['']\n   next_href=['']\n   last=0\n   if context:\n    fromlist=['<td></td><td>&nbsp;No Differences Found&nbsp;</td>']\n    tolist=fromlist\n   else :\n    fromlist=tolist=['<td></td><td>&nbsp;Empty File&nbsp;</td>']\n    \n  if not flaglist[0]:\n   next_href[0]='<a href=\"#difflib_chg_%s_0\">f</a>'%toprefix\n   \n  next_href[last]='<a href=\"#difflib_chg_%s_top\">t</a>'%(toprefix)\n  \n  return fromlist,tolist,flaglist,next_href,next_id\n  \n def make_table(self,fromlines,tolines,fromdesc='',todesc='',context=False ,\n numlines=5):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  \n  \n  \n  self._make_prefix()\n  \n  \n  \n  fromlines,tolines=self._tab_newline_replace(fromlines,tolines)\n  \n  \n  if context:\n   context_lines=numlines\n  else :\n   context_lines=None\n  diffs=_mdiff(fromlines,tolines,context_lines,linejunk=self._linejunk,\n  charjunk=self._charjunk)\n  \n  \n  if self._wrapcolumn:\n   diffs=self._line_wrapper(diffs)\n   \n   \n  fromlist,tolist,flaglist=self._collect_lines(diffs)\n  \n  \n  fromlist,tolist,flaglist,next_href,next_id=self._convert_flags(\n  fromlist,tolist,flaglist,context,numlines)\n  \n  s=[]\n  fmt='            <tr><td class=\"diff_next\"%s>%s</td>%s'+\\\n  '<td class=\"diff_next\">%s</td>%s</tr>\\n'\n  for i in range(len(flaglist)):\n   if flaglist[i]is None :\n   \n   \n    if i >0:\n     s.append('        </tbody>        \\n        <tbody>\\n')\n   else :\n    s.append(fmt %(next_id[i],next_href[i],fromlist[i],\n    next_href[i],tolist[i]))\n  if fromdesc or todesc:\n   header_row='<thead><tr>%s%s%s%s</tr></thead>'%(\n   '<th class=\"diff_next\"><br /></th>',\n   '<th colspan=\"2\" class=\"diff_header\">%s</th>'%fromdesc,\n   '<th class=\"diff_next\"><br /></th>',\n   '<th colspan=\"2\" class=\"diff_header\">%s</th>'%todesc)\n  else :\n   header_row=''\n   \n  table=self._table_template %dict(\n  data_rows=''.join(s),\n  header_row=header_row,\n  prefix=self._prefix[1])\n  \n  return table.replace('\\0+','<span class=\"diff_add\">').\\\n  replace('\\0-','<span class=\"diff_sub\">').\\\n  replace('\\0^','<span class=\"diff_chg\">').\\\n  replace('\\1','</span>').\\\n  replace('\\t','&nbsp;')\n  \ndel re\n\ndef restore(delta,which):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n try :\n  tag={1:\"- \",2:\"+ \"}[int(which)]\n except KeyError:\n  raise ValueError('unknown delta choice (must be 1 or 2): %r'\n  %which)from None\n prefixes=(\"  \",tag)\n for line in delta:\n  if line[:2]in prefixes:\n   yield line[2:]\n   \ndef _test():\n import doctest,difflib\n return doctest.testmod(difflib)\n \nif __name__ ==\"__main__\":\n _test()\n", ["collections", "difflib", "doctest", "heapq", "re"]], "doctest": [".py", "\n\n\n\n\n\n\n\nr\"\"\"Module doctest -- a framework for running examples in docstrings.\n\nIn simplest use, end each module M to be tested with:\n\ndef _test():\n    import doctest\n    doctest.testmod()\n\nif __name__ == \"__main__\":\n    _test()\n\nThen running the module as a script will cause the examples in the\ndocstrings to get executed and verified:\n\npython M.py\n\nThis won't display anything unless an example fails, in which case the\nfailing example(s) and the cause(s) of the failure(s) are printed to stdout\n(why not stderr? because stderr is a lame hack <0.2 wink>), and the final\nline of output is \"Test failed.\".\n\nRun it with the -v switch instead:\n\npython M.py -v\n\nand a detailed report of all examples tried is printed to stdout, along\nwith assorted summaries at the end.\n\nYou can force verbose mode by passing \"verbose=True\" to testmod, or prohibit\nit by passing \"verbose=False\".  In either of those cases, sys.argv is not\nexamined by testmod.\n\nThere are a variety of other ways to run doctests, including integration\nwith the unittest framework, and support for running non-Python text\nfiles containing doctests.  There are also many ways to override parts\nof doctest's default behaviors.  See the Library Reference Manual for\ndetails.\n\"\"\"\n\n__docformat__='reStructuredText en'\n\n__all__=[\n\n'register_optionflag',\n'DONT_ACCEPT_TRUE_FOR_1',\n'DONT_ACCEPT_BLANKLINE',\n'NORMALIZE_WHITESPACE',\n'ELLIPSIS',\n'SKIP',\n'IGNORE_EXCEPTION_DETAIL',\n'COMPARISON_FLAGS',\n'REPORT_UDIFF',\n'REPORT_CDIFF',\n'REPORT_NDIFF',\n'REPORT_ONLY_FIRST_FAILURE',\n'REPORTING_FLAGS',\n'FAIL_FAST',\n\n\n'Example',\n'DocTest',\n\n'DocTestParser',\n\n'DocTestFinder',\n\n'DocTestRunner',\n'OutputChecker',\n'DocTestFailure',\n'UnexpectedException',\n'DebugRunner',\n\n'testmod',\n'testfile',\n'run_docstring_examples',\n\n'DocTestSuite',\n'DocFileSuite',\n'set_unittest_reportflags',\n\n'script_from_examples',\n'testsource',\n'debug_src',\n'debug',\n]\n\nimport __future__\nimport difflib\nimport inspect\nimport linecache\nimport os\nimport pdb\nimport re\nimport sys\nimport traceback\nimport unittest\nfrom io import StringIO\nfrom collections import namedtuple\n\nTestResults=namedtuple('TestResults','failed attempted')\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nOPTIONFLAGS_BY_NAME={}\ndef register_optionflag(name):\n\n return OPTIONFLAGS_BY_NAME.setdefault(name,1 <<len(OPTIONFLAGS_BY_NAME))\n \nDONT_ACCEPT_TRUE_FOR_1=register_optionflag('DONT_ACCEPT_TRUE_FOR_1')\nDONT_ACCEPT_BLANKLINE=register_optionflag('DONT_ACCEPT_BLANKLINE')\nNORMALIZE_WHITESPACE=register_optionflag('NORMALIZE_WHITESPACE')\nELLIPSIS=register_optionflag('ELLIPSIS')\nSKIP=register_optionflag('SKIP')\nIGNORE_EXCEPTION_DETAIL=register_optionflag('IGNORE_EXCEPTION_DETAIL')\n\nCOMPARISON_FLAGS=(DONT_ACCEPT_TRUE_FOR_1 |\nDONT_ACCEPT_BLANKLINE |\nNORMALIZE_WHITESPACE |\nELLIPSIS |\nSKIP |\nIGNORE_EXCEPTION_DETAIL)\n\nREPORT_UDIFF=register_optionflag('REPORT_UDIFF')\nREPORT_CDIFF=register_optionflag('REPORT_CDIFF')\nREPORT_NDIFF=register_optionflag('REPORT_NDIFF')\nREPORT_ONLY_FIRST_FAILURE=register_optionflag('REPORT_ONLY_FIRST_FAILURE')\nFAIL_FAST=register_optionflag('FAIL_FAST')\n\nREPORTING_FLAGS=(REPORT_UDIFF |\nREPORT_CDIFF |\nREPORT_NDIFF |\nREPORT_ONLY_FIRST_FAILURE |\nFAIL_FAST)\n\n\nBLANKLINE_MARKER='<BLANKLINE>'\nELLIPSIS_MARKER='...'\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\ndef _extract_future_flags(globs):\n ''\n\n\n \n flags=0\n for fname in __future__.all_feature_names:\n  feature=globs.get(fname,None )\n  if feature is getattr(__future__,fname):\n   flags |=feature.compiler_flag\n return flags\n \ndef _normalize_module(module,depth=2):\n ''\n\n\n\n\n\n\n\n \n if inspect.ismodule(module):\n  return module\n elif isinstance(module,str):\n  return __import__(module,globals(),locals(),[\"*\"])\n elif module is None :\n  return sys.modules[sys._getframe(depth).f_globals['__name__']]\n else :\n  raise TypeError(\"Expected a module, string, or None\")\n  \ndef _load_testfile(filename,package,module_relative,encoding):\n if module_relative:\n  package=_normalize_module(package,3)\n  filename=_module_relative_path(package,filename)\n  if getattr(package,'__loader__',None )is not None :\n   if hasattr(package.__loader__,'get_data'):\n    file_contents=package.__loader__.get_data(filename)\n    file_contents=file_contents.decode(encoding)\n    \n    \n    return file_contents.replace(os.linesep,'\\n'),filename\n with open(filename,encoding=encoding)as f:\n  return f.read(),filename\n  \ndef _indent(s,indent=4):\n ''\n\n\n \n \n return re.sub('(?m)^(?!$)',indent *' ',s)\n \ndef _exception_traceback(exc_info):\n ''\n\n\n \n \n excout=StringIO()\n exc_type,exc_val,exc_tb=exc_info\n traceback.print_exception(exc_type,exc_val,exc_tb,file=excout)\n return excout.getvalue()\n \n \nclass _SpoofOut(StringIO):\n def getvalue(self):\n  result=StringIO.getvalue(self)\n  \n  \n  \n  if result and not result.endswith(\"\\n\"):\n   result +=\"\\n\"\n  return result\n  \n def truncate(self,size=None ):\n  self.seek(size)\n  StringIO.truncate(self)\n  \n  \ndef _ellipsis_match(want,got):\n ''\n\n\n\n \n if ELLIPSIS_MARKER not in want:\n  return want ==got\n  \n  \n ws=want.split(ELLIPSIS_MARKER)\n assert len(ws)>=2\n \n \n startpos,endpos=0,len(got)\n w=ws[0]\n if w:\n  if got.startswith(w):\n   startpos=len(w)\n   del ws[0]\n  else :\n   return False\n w=ws[-1]\n if w:\n  if got.endswith(w):\n   endpos -=len(w)\n   del ws[-1]\n  else :\n   return False\n   \n if startpos >endpos:\n \n \n  return False\n  \n  \n  \n  \n for w in ws:\n \n \n \n  startpos=got.find(w,startpos,endpos)\n  if startpos <0:\n   return False\n  startpos +=len(w)\n  \n return True\n \ndef _comment_line(line):\n ''\n line=line.rstrip()\n if line:\n  return '# '+line\n else :\n  return '#'\n  \ndef _strip_exception_details(msg):\n\n\n\n\n\n\n\n\n\n\n start,end=0,len(msg)\n \n i=msg.find(\"\\n\")\n if i >=0:\n  end=i\n  \n i=msg.find(':',0,end)\n if i >=0:\n  end=i\n  \n i=msg.rfind('.',0,end)\n if i >=0:\n  start=i+1\n return msg[start:end]\n \nclass _OutputRedirectingPdb(pdb.Pdb):\n ''\n\n\n\n \n def __init__(self,out):\n  self.__out=out\n  self.__debugger_used=False\n  \n  pdb.Pdb.__init__(self,stdout=out,nosigint=True )\n  \n  self.use_rawinput=1\n  \n def set_trace(self,frame=None ):\n  self.__debugger_used=True\n  if frame is None :\n   frame=sys._getframe().f_back\n  pdb.Pdb.set_trace(self,frame)\n  \n def set_continue(self):\n \n \n  if self.__debugger_used:\n   pdb.Pdb.set_continue(self)\n   \n def trace_dispatch(self,*args):\n \n  save_stdout=sys.stdout\n  sys.stdout=self.__out\n  \n  try :\n   return pdb.Pdb.trace_dispatch(self,*args)\n  finally :\n   sys.stdout=save_stdout\n   \n   \ndef _module_relative_path(module,test_path):\n if not inspect.ismodule(module):\n  raise TypeError('Expected a module: %r'%module)\n if test_path.startswith('/'):\n  raise ValueError('Module-relative files may not have absolute paths')\n  \n  \n test_path=os.path.join(*(test_path.split('/')))\n \n \n if hasattr(module,'__file__'):\n \n  basedir=os.path.split(module.__file__)[0]\n elif module.__name__ =='__main__':\n \n  if len(sys.argv)>0 and sys.argv[0]!='':\n   basedir=os.path.split(sys.argv[0])[0]\n  else :\n   basedir=os.curdir\n else :\n  if hasattr(module,'__path__'):\n   for directory in module.__path__:\n    fullpath=os.path.join(directory,test_path)\n    if os.path.exists(fullpath):\n     return fullpath\n     \n     \n  raise ValueError(\"Can't resolve paths relative to the module \"\n  \"%r (it has no __file__)\"\n  %module.__name__)\n  \n  \n return os.path.join(basedir,test_path)\n \n \n \n \n \n \n \n \n \n \n \n \n \nclass Example:\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n def __init__(self,source,want,exc_msg=None ,lineno=0,indent=0,\n options=None ):\n \n  if not source.endswith('\\n'):\n   source +='\\n'\n  if want and not want.endswith('\\n'):\n   want +='\\n'\n  if exc_msg is not None and not exc_msg.endswith('\\n'):\n   exc_msg +='\\n'\n   \n  self.source=source\n  self.want=want\n  self.lineno=lineno\n  self.indent=indent\n  if options is None :options={}\n  self.options=options\n  self.exc_msg=exc_msg\n  \n def __eq__(self,other):\n  if type(self)is not type(other):\n   return NotImplemented\n   \n  return self.source ==other.source and\\\n  self.want ==other.want and\\\n  self.lineno ==other.lineno and\\\n  self.indent ==other.indent and\\\n  self.options ==other.options and\\\n  self.exc_msg ==other.exc_msg\n  \n def __hash__(self):\n  return hash((self.source,self.want,self.lineno,self.indent,\n  self.exc_msg))\n  \nclass DocTest:\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n def __init__(self,examples,globs,name,filename,lineno,docstring):\n  ''\n\n\n  \n  assert not isinstance(examples,str),\\\n  \"DocTest no longer accepts str; use DocTestParser instead\"\n  self.examples=examples\n  self.docstring=docstring\n  self.globs=globs.copy()\n  self.name=name\n  self.filename=filename\n  self.lineno=lineno\n  \n def __repr__(self):\n  if len(self.examples)==0:\n   examples='no examples'\n  elif len(self.examples)==1:\n   examples='1 example'\n  else :\n   examples='%d examples'%len(self.examples)\n  return ('<%s %s from %s:%s (%s)>'%\n  (self.__class__.__name__,\n  self.name,self.filename,self.lineno,examples))\n  \n def __eq__(self,other):\n  if type(self)is not type(other):\n   return NotImplemented\n   \n  return self.examples ==other.examples and\\\n  self.docstring ==other.docstring and\\\n  self.globs ==other.globs and\\\n  self.name ==other.name and\\\n  self.filename ==other.filename and\\\n  self.lineno ==other.lineno\n  \n def __hash__(self):\n  return hash((self.docstring,self.name,self.filename,self.lineno))\n  \n  \n def __lt__(self,other):\n  if not isinstance(other,DocTest):\n   return NotImplemented\n  return ((self.name,self.filename,self.lineno,id(self))\n  <\n  (other.name,other.filename,other.lineno,id(other)))\n  \n  \n  \n  \n  \nclass DocTestParser:\n ''\n\n \n \n \n \n \n \n _EXAMPLE_RE=re.compile(r'''\n        # Source consists of a PS1 line followed by zero or more PS2 lines.\n        (?P<source>\n            (?:^(?P<indent> [ ]*) >>>    .*)    # PS1 line\n            (?:\\n           [ ]*  \\.\\.\\. .*)*)  # PS2 lines\n        \\n?\n        # Want consists of any non-blank lines that do not start with PS1.\n        (?P<want> (?:(?![ ]*$)    # Not a blank line\n                     (?![ ]*>>>)  # Not a line starting with PS1\n                     .+$\\n?       # But any other line\n                  )*)\n        ''',re.MULTILINE |re.VERBOSE)\n \n \n \n \n \n \n \n \n \n \n _EXCEPTION_RE=re.compile(r\"\"\"\n        # Grab the traceback header.  Different versions of Python have\n        # said different things on the first traceback line.\n        ^(?P<hdr> Traceback\\ \\(\n            (?: most\\ recent\\ call\\ last\n            |   innermost\\ last\n            ) \\) :\n        )\n        \\s* $                # toss trailing whitespace on the header.\n        (?P<stack> .*?)      # don't blink: absorb stuff until...\n        ^ (?P<msg> \\w+ .*)   #     a line *starts* with alphanum.\n        \"\"\",re.VERBOSE |re.MULTILINE |re.DOTALL)\n \n \n \n _IS_BLANK_OR_COMMENT=re.compile(r'^[ ]*(#.*)?$').match\n \n def parse(self,string,name='<string>'):\n  ''\n\n\n\n\n\n  \n  string=string.expandtabs()\n  \n  min_indent=self._min_indent(string)\n  if min_indent >0:\n   string='\\n'.join([l[min_indent:]for l in string.split('\\n')])\n   \n  output=[]\n  charno,lineno=0,0\n  \n  for m in self._EXAMPLE_RE.finditer(string):\n  \n   output.append(string[charno:m.start()])\n   \n   lineno +=string.count('\\n',charno,m.start())\n   \n   (source,options,want,exc_msg)=\\\n   self._parse_example(m,name,lineno)\n   \n   if not self._IS_BLANK_OR_COMMENT(source):\n    output.append(Example(source,want,exc_msg,\n    lineno=lineno,\n    indent=min_indent+len(m.group('indent')),\n    options=options))\n    \n   lineno +=string.count('\\n',m.start(),m.end())\n   \n   charno=m.end()\n   \n  output.append(string[charno:])\n  return output\n  \n def get_doctest(self,string,globs,name,filename,lineno):\n  ''\n\n\n\n\n\n\n  \n  return DocTest(self.get_examples(string,name),globs,\n  name,filename,lineno,string)\n  \n def get_examples(self,string,name='<string>'):\n  ''\n\n\n\n\n\n\n\n\n  \n  return [x for x in self.parse(string,name)\n  if isinstance(x,Example)]\n  \n def _parse_example(self,m,name,lineno):\n  ''\n\n\n\n\n\n\n\n\n  \n  \n  indent=len(m.group('indent'))\n  \n  \n  \n  source_lines=m.group('source').split('\\n')\n  self._check_prompt_blank(source_lines,indent,name,lineno)\n  self._check_prefix(source_lines[1:],' '*indent+'.',name,lineno)\n  source='\\n'.join([sl[indent+4:]for sl in source_lines])\n  \n  \n  \n  \n  want=m.group('want')\n  want_lines=want.split('\\n')\n  if len(want_lines)>1 and re.match(r' *$',want_lines[-1]):\n   del want_lines[-1]\n  self._check_prefix(want_lines,' '*indent,name,\n  lineno+len(source_lines))\n  want='\\n'.join([wl[indent:]for wl in want_lines])\n  \n  \n  m=self._EXCEPTION_RE.match(want)\n  if m:\n   exc_msg=m.group('msg')\n  else :\n   exc_msg=None\n   \n   \n  options=self._find_options(source,name,lineno)\n  \n  return source,options,want,exc_msg\n  \n  \n  \n  \n  \n  \n  \n  \n _OPTION_DIRECTIVE_RE=re.compile(r'#\\s*doctest:\\s*([^\\n\\'\"]*)$',\n re.MULTILINE)\n \n def _find_options(self,source,name,lineno):\n  ''\n\n\n\n\n\n  \n  options={}\n  \n  for m in self._OPTION_DIRECTIVE_RE.finditer(source):\n   option_strings=m.group(1).replace(',',' ').split()\n   for option in option_strings:\n    if (option[0]not in '+-'or\n    option[1:]not in OPTIONFLAGS_BY_NAME):\n     raise ValueError('line %r of the doctest for %s '\n     'has an invalid option: %r'%\n     (lineno+1,name,option))\n    flag=OPTIONFLAGS_BY_NAME[option[1:]]\n    options[flag]=(option[0]=='+')\n  if options and self._IS_BLANK_OR_COMMENT(source):\n   raise ValueError('line %r of the doctest for %s has an option '\n   'directive on a line with no example: %r'%\n   (lineno,name,source))\n  return options\n  \n  \n  \n _INDENT_RE=re.compile(r'^([ ]*)(?=\\S)',re.MULTILINE)\n \n def _min_indent(self,s):\n  ''\n  indents=[len(indent)for indent in self._INDENT_RE.findall(s)]\n  if len(indents)>0:\n   return min(indents)\n  else :\n   return 0\n   \n def _check_prompt_blank(self,lines,indent,name,lineno):\n  ''\n\n\n\n\n  \n  for i,line in enumerate(lines):\n   if len(line)>=indent+4 and line[indent+3]!=' ':\n    raise ValueError('line %r of the docstring for %s '\n    'lacks blank after %s: %r'%\n    (lineno+i+1,name,\n    line[indent:indent+3],line))\n    \n def _check_prefix(self,lines,prefix,name,lineno):\n  ''\n\n\n  \n  for i,line in enumerate(lines):\n   if line and not line.startswith(prefix):\n    raise ValueError('line %r of the docstring for %s has '\n    'inconsistent leading whitespace: %r'%\n    (lineno+i+1,name,line))\n    \n    \n    \n    \n    \n    \nclass DocTestFinder:\n ''\n\n\n\n\n\n \n \n def __init__(self,verbose=False ,parser=DocTestParser(),\n recurse=True ,exclude_empty=True ):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  self._parser=parser\n  self._verbose=verbose\n  self._recurse=recurse\n  self._exclude_empty=exclude_empty\n  \n def find(self,obj,name=None ,module=None ,globs=None ,extraglobs=None ):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  \n  if name is None :\n   name=getattr(obj,'__name__',None )\n   if name is None :\n    raise ValueError(\"DocTestFinder.find: name must be given \"\n    \"when obj.__name__ doesn't exist: %r\"%\n    (type(obj),))\n    \n    \n    \n    \n  if module is False :\n   module=None\n  elif module is None :\n   module=inspect.getmodule(obj)\n   \n   \n   \n   \n  try :\n   file=inspect.getsourcefile(obj)\n  except TypeError:\n   source_lines=None\n  else :\n   if not file:\n   \n   \n    file=inspect.getfile(obj)\n    if not file[0]+file[-2:]=='<]>':file=None\n   if file is None :\n    source_lines=None\n   else :\n    if module is not None :\n    \n    \n    \n     source_lines=linecache.getlines(file,module.__dict__)\n    else :\n    \n    \n     source_lines=linecache.getlines(file)\n    if not source_lines:\n     source_lines=None\n     \n     \n  if globs is None :\n   if module is None :\n    globs={}\n   else :\n    globs=module.__dict__.copy()\n  else :\n   globs=globs.copy()\n  if extraglobs is not None :\n   globs.update(extraglobs)\n  if '__name__'not in globs:\n   globs['__name__']='__main__'\n   \n   \n  tests=[]\n  self._find(tests,obj,name,module,source_lines,globs,{})\n  \n  \n  \n  \n  tests.sort()\n  return tests\n  \n def _from_module(self,module,object):\n  ''\n\n\n  \n  if module is None :\n   return True\n  elif inspect.getmodule(object)is not None :\n   return module is inspect.getmodule(object)\n  elif inspect.isfunction(object):\n   return module.__dict__ is object.__globals__\n  elif inspect.ismethoddescriptor(object):\n   if hasattr(object,'__objclass__'):\n    obj_mod=object.__objclass__.__module__\n   elif hasattr(object,'__module__'):\n    obj_mod=object.__module__\n   else :\n    return True\n   return module.__name__ ==obj_mod\n  elif inspect.isclass(object):\n   return module.__name__ ==object.__module__\n  elif hasattr(object,'__module__'):\n   return module.__name__ ==object.__module__\n  elif isinstance(object,property):\n   return True\n  else :\n   raise ValueError(\"object must be a class or function\")\n   \n def _find(self,tests,obj,name,module,source_lines,globs,seen):\n  ''\n\n\n  \n  if self._verbose:\n   print('Finding tests in %s'%name)\n   \n   \n  if id(obj)in seen:\n   return\n  seen[id(obj)]=1\n  \n  \n  test=self._get_test(obj,name,module,globs,source_lines)\n  if test is not None :\n   tests.append(test)\n   \n   \n  if inspect.ismodule(obj)and self._recurse:\n   for valname,val in obj.__dict__.items():\n    valname='%s.%s'%(name,valname)\n    \n    if ((inspect.isroutine(inspect.unwrap(val))\n    or inspect.isclass(val))and\n    self._from_module(module,val)):\n     self._find(tests,val,valname,module,source_lines,\n     globs,seen)\n     \n     \n  if inspect.ismodule(obj)and self._recurse:\n   for valname,val in getattr(obj,'__test__',{}).items():\n    if not isinstance(valname,str):\n     raise ValueError(\"DocTestFinder.find: __test__ keys \"\n     \"must be strings: %r\"%\n     (type(valname),))\n    if not (inspect.isroutine(val)or inspect.isclass(val)or\n    inspect.ismodule(val)or isinstance(val,str)):\n     raise ValueError(\"DocTestFinder.find: __test__ values \"\n     \"must be strings, functions, methods, \"\n     \"classes, or modules: %r\"%\n     (type(val),))\n    valname='%s.__test__.%s'%(name,valname)\n    self._find(tests,val,valname,module,source_lines,\n    globs,seen)\n    \n    \n  if inspect.isclass(obj)and self._recurse:\n   for valname,val in obj.__dict__.items():\n   \n    if isinstance(val,staticmethod):\n     val=getattr(obj,valname)\n    if isinstance(val,classmethod):\n     val=getattr(obj,valname).__func__\n     \n     \n    if ((inspect.isroutine(val)or inspect.isclass(val)or\n    isinstance(val,property))and\n    self._from_module(module,val)):\n     valname='%s.%s'%(name,valname)\n     self._find(tests,val,valname,module,source_lines,\n     globs,seen)\n     \n def _get_test(self,obj,name,module,globs,source_lines):\n  ''\n\n\n  \n  \n  \n  if isinstance(obj,str):\n   docstring=obj\n  else :\n   try :\n    if obj.__doc__ is None :\n     docstring=''\n    else :\n     docstring=obj.__doc__\n     if not isinstance(docstring,str):\n      docstring=str(docstring)\n   except (TypeError,AttributeError):\n    docstring=''\n    \n    \n  lineno=self._find_lineno(obj,source_lines)\n  \n  \n  if self._exclude_empty and not docstring:\n   return None\n   \n   \n  if module is None :\n   filename=None\n  else :\n   filename=getattr(module,'__file__',module.__name__)\n   if filename[-4:]==\".pyc\":\n    filename=filename[:-1]\n  return self._parser.get_doctest(docstring,globs,name,\n  filename,lineno)\n  \n def _find_lineno(self,obj,source_lines):\n  ''\n\n\n  \n  lineno=None\n  \n  \n  if inspect.ismodule(obj):\n   lineno=0\n   \n   \n   \n   \n  if inspect.isclass(obj):\n   if source_lines is None :\n    return None\n   pat=re.compile(r'^\\s*class\\s*%s\\b'%\n   getattr(obj,'__name__','-'))\n   for i,line in enumerate(source_lines):\n    if pat.match(line):\n     lineno=i\n     break\n     \n     \n  if inspect.ismethod(obj):obj=obj.__func__\n  if inspect.isfunction(obj):obj=obj.__code__\n  if inspect.istraceback(obj):obj=obj.tb_frame\n  if inspect.isframe(obj):obj=obj.f_code\n  if inspect.iscode(obj):\n   lineno=getattr(obj,'co_firstlineno',None )-1\n   \n   \n   \n   \n   \n   \n  if lineno is not None :\n   if source_lines is None :\n    return lineno+1\n   pat=re.compile(r'(^|.*:)\\s*\\w*(\"|\\')')\n   for lineno in range(lineno,len(source_lines)):\n    if pat.match(source_lines[lineno]):\n     return lineno\n     \n     \n  return None\n  \n  \n  \n  \n  \nclass DocTestRunner:\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n \n DIVIDER=\"*\"*70\n \n def __init__(self,checker=None ,verbose=None ,optionflags=0):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  self._checker=checker or OutputChecker()\n  if verbose is None :\n   verbose='-v'in sys.argv\n  self._verbose=verbose\n  self.optionflags=optionflags\n  self.original_optionflags=optionflags\n  \n  \n  self.tries=0\n  self.failures=0\n  self._name2ft={}\n  \n  \n  self._fakeout=_SpoofOut()\n  \n  \n  \n  \n  \n def report_start(self,out,test,example):\n  ''\n\n\n  \n  if self._verbose:\n   if example.want:\n    out('Trying:\\n'+_indent(example.source)+\n    'Expecting:\\n'+_indent(example.want))\n   else :\n    out('Trying:\\n'+_indent(example.source)+\n    'Expecting nothing\\n')\n    \n def report_success(self,out,test,example,got):\n  ''\n\n\n  \n  if self._verbose:\n   out(\"ok\\n\")\n   \n def report_failure(self,out,test,example,got):\n  ''\n\n  \n  out(self._failure_header(test,example)+\n  self._checker.output_difference(example,got,self.optionflags))\n  \n def report_unexpected_exception(self,out,test,example,exc_info):\n  ''\n\n  \n  out(self._failure_header(test,example)+\n  'Exception raised:\\n'+_indent(_exception_traceback(exc_info)))\n  \n def _failure_header(self,test,example):\n  out=[self.DIVIDER]\n  if test.filename:\n   if test.lineno is not None and example.lineno is not None :\n    lineno=test.lineno+example.lineno+1\n   else :\n    lineno='?'\n   out.append('File \"%s\", line %s, in %s'%\n   (test.filename,lineno,test.name))\n  else :\n   out.append('Line %s, in %s'%(example.lineno+1,test.name))\n  out.append('Failed example:')\n  source=example.source\n  out.append(_indent(source))\n  return '\\n'.join(out)\n  \n  \n  \n  \n  \n def __run(self,test,compileflags,out):\n  ''\n\n\n\n\n\n\n\n  \n  \n  failures=tries=0\n  \n  \n  \n  original_optionflags=self.optionflags\n  \n  SUCCESS,FAILURE,BOOM=range(3)\n  \n  check=self._checker.check_output\n  \n  \n  for examplenum,example in enumerate(test.examples):\n  \n  \n  \n   quiet=(self.optionflags&REPORT_ONLY_FIRST_FAILURE and\n   failures >0)\n   \n   \n   self.optionflags=original_optionflags\n   if example.options:\n    for (optionflag,val)in example.options.items():\n     if val:\n      self.optionflags |=optionflag\n     else :\n      self.optionflags &=~optionflag\n      \n      \n   if self.optionflags&SKIP:\n    continue\n    \n    \n   tries +=1\n   if not quiet:\n    self.report_start(out,test,example)\n    \n    \n    \n    \n   filename='<doctest %s[%d]>'%(test.name,examplenum)\n   \n   \n   \n   \n   try :\n   \n    exec(compile(example.source,filename,\"single\",\n    compileflags,1),test.globs)\n    self.debugger.set_continue()\n    exception=None\n   except KeyboardInterrupt:\n    raise\n   except :\n    exception=sys.exc_info()\n    self.debugger.set_continue()\n    \n   got=self._fakeout.getvalue()\n   self._fakeout.truncate(0)\n   outcome=FAILURE\n   \n   \n   \n   if exception is None :\n    if check(example.want,got,self.optionflags):\n     outcome=SUCCESS\n     \n     \n   else :\n    exc_msg=traceback.format_exception_only(*exception[:2])[-1]\n    if not quiet:\n     got +=_exception_traceback(exception)\n     \n     \n     \n    if example.exc_msg is None :\n     outcome=BOOM\n     \n     \n    elif check(example.exc_msg,exc_msg,self.optionflags):\n     outcome=SUCCESS\n     \n     \n    elif self.optionflags&IGNORE_EXCEPTION_DETAIL:\n     if check(_strip_exception_details(example.exc_msg),\n     _strip_exception_details(exc_msg),\n     self.optionflags):\n      outcome=SUCCESS\n      \n      \n   if outcome is SUCCESS:\n    if not quiet:\n     self.report_success(out,test,example,got)\n   elif outcome is FAILURE:\n    if not quiet:\n     self.report_failure(out,test,example,got)\n    failures +=1\n   elif outcome is BOOM:\n    if not quiet:\n     self.report_unexpected_exception(out,test,example,\n     exception)\n    failures +=1\n   else :\n    assert False ,(\"unknown outcome\",outcome)\n    \n   if failures and self.optionflags&FAIL_FAST:\n    break\n    \n    \n  self.optionflags=original_optionflags\n  \n  \n  self.__record_outcome(test,failures,tries)\n  return TestResults(failures,tries)\n  \n def __record_outcome(self,test,f,t):\n  ''\n\n\n  \n  f2,t2=self._name2ft.get(test.name,(0,0))\n  self._name2ft[test.name]=(f+f2,t+t2)\n  self.failures +=f\n  self.tries +=t\n  \n __LINECACHE_FILENAME_RE=re.compile(r'<doctest '\n r'(?P<name>.+)'\n r'\\[(?P<examplenum>\\d+)\\]>$')\n def __patched_linecache_getlines(self,filename,module_globals=None ):\n  m=self.__LINECACHE_FILENAME_RE.match(filename)\n  if m and m.group('name')==self.test.name:\n   example=self.test.examples[int(m.group('examplenum'))]\n   return example.source.splitlines(keepends=True )\n  else :\n   return self.save_linecache_getlines(filename,module_globals)\n   \n def run(self,test,compileflags=None ,out=None ,clear_globs=True ):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  self.test=test\n  \n  if compileflags is None :\n   compileflags=_extract_future_flags(test.globs)\n   \n  save_stdout=sys.stdout\n  if out is None :\n   encoding=save_stdout.encoding\n   if encoding is None or encoding.lower()=='utf-8':\n    out=save_stdout.write\n   else :\n   \n    def out(s):\n     s=str(s.encode(encoding,'backslashreplace'),encoding)\n     save_stdout.write(s)\n  sys.stdout=self._fakeout\n  \n  \n  \n  \n  \n  \n  save_trace=sys.gettrace()\n  save_set_trace=pdb.set_trace\n  self.debugger=_OutputRedirectingPdb(save_stdout)\n  self.debugger.reset()\n  pdb.set_trace=self.debugger.set_trace\n  \n  \n  \n  self.save_linecache_getlines=linecache.getlines\n  linecache.getlines=self.__patched_linecache_getlines\n  \n  \n  save_displayhook=sys.displayhook\n  sys.displayhook=sys.__displayhook__\n  \n  try :\n   return self.__run(test,compileflags,out)\n  finally :\n   sys.stdout=save_stdout\n   pdb.set_trace=save_set_trace\n   sys.settrace(save_trace)\n   linecache.getlines=self.save_linecache_getlines\n   sys.displayhook=save_displayhook\n   if clear_globs:\n    test.globs.clear()\n    import builtins\n    builtins._=None\n    \n    \n    \n    \n def summarize(self,verbose=None ):\n  ''\n\n\n\n\n\n\n\n\n  \n  if verbose is None :\n   verbose=self._verbose\n  notests=[]\n  passed=[]\n  failed=[]\n  totalt=totalf=0\n  for x in self._name2ft.items():\n   name,(f,t)=x\n   assert f <=t\n   totalt +=t\n   totalf +=f\n   if t ==0:\n    notests.append(name)\n   elif f ==0:\n    passed.append((name,t))\n   else :\n    failed.append(x)\n  if verbose:\n   if notests:\n    print(len(notests),\"items had no tests:\")\n    notests.sort()\n    for thing in notests:\n     print(\"   \",thing)\n   if passed:\n    print(len(passed),\"items passed all tests:\")\n    passed.sort()\n    for thing,count in passed:\n     print(\" %3d tests in %s\"%(count,thing))\n  if failed:\n   print(self.DIVIDER)\n   print(len(failed),\"items had failures:\")\n   failed.sort()\n   for thing,(f,t)in failed:\n    print(\" %3d of %3d in %s\"%(f,t,thing))\n  if verbose:\n   print(totalt,\"tests in\",len(self._name2ft),\"items.\")\n   print(totalt -totalf,\"passed and\",totalf,\"failed.\")\n  if totalf:\n   print(\"***Test Failed***\",totalf,\"failures.\")\n  elif verbose:\n   print(\"Test passed.\")\n  return TestResults(totalf,totalt)\n  \n  \n  \n  \n def merge(self,other):\n  d=self._name2ft\n  for name,(f,t)in other._name2ft.items():\n   if name in d:\n   \n   \n   \n   \n    f2,t2=d[name]\n    f=f+f2\n    t=t+t2\n   d[name]=f,t\n   \nclass OutputChecker:\n ''\n\n\n\n\n\n \n def _toAscii(self,s):\n  ''\n\n  \n  return str(s.encode('ASCII','backslashreplace'),\"ASCII\")\n  \n def check_output(self,want,got,optionflags):\n  ''\n\n\n\n\n\n\n\n  \n  \n  \n  \n  \n  \n  \n  got=self._toAscii(got)\n  want=self._toAscii(want)\n  \n  \n  \n  if got ==want:\n   return True\n   \n   \n   \n  if not (optionflags&DONT_ACCEPT_TRUE_FOR_1):\n   if (got,want)==(\"True\\n\",\"1\\n\"):\n    return True\n   if (got,want)==(\"False\\n\",\"0\\n\"):\n    return True\n    \n    \n    \n  if not (optionflags&DONT_ACCEPT_BLANKLINE):\n  \n   want=re.sub(r'(?m)^%s\\s*?$'%re.escape(BLANKLINE_MARKER),\n   '',want)\n   \n   \n   got=re.sub(r'(?m)^[^\\S\\n]+$','',got)\n   if got ==want:\n    return True\n    \n    \n    \n    \n  if optionflags&NORMALIZE_WHITESPACE:\n   got=' '.join(got.split())\n   want=' '.join(want.split())\n   if got ==want:\n    return True\n    \n    \n    \n  if optionflags&ELLIPSIS:\n   if _ellipsis_match(want,got):\n    return True\n    \n    \n  return False\n  \n  \n def _do_a_fancy_diff(self,want,got,optionflags):\n \n  if not optionflags&(REPORT_UDIFF |\n  REPORT_CDIFF |\n  REPORT_NDIFF):\n   return False\n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n  if optionflags&REPORT_NDIFF:\n   return True\n   \n   \n  return want.count('\\n')>2 and got.count('\\n')>2\n  \n def output_difference(self,example,got,optionflags):\n  ''\n\n\n\n\n  \n  want=example.want\n  \n  \n  if not (optionflags&DONT_ACCEPT_BLANKLINE):\n   got=re.sub('(?m)^[ ]*(?=\\n)',BLANKLINE_MARKER,got)\n   \n   \n  if self._do_a_fancy_diff(want,got,optionflags):\n  \n   want_lines=want.splitlines(keepends=True )\n   got_lines=got.splitlines(keepends=True )\n   \n   if optionflags&REPORT_UDIFF:\n    diff=difflib.unified_diff(want_lines,got_lines,n=2)\n    diff=list(diff)[2:]\n    kind='unified diff with -expected +actual'\n   elif optionflags&REPORT_CDIFF:\n    diff=difflib.context_diff(want_lines,got_lines,n=2)\n    diff=list(diff)[2:]\n    kind='context diff with expected followed by actual'\n   elif optionflags&REPORT_NDIFF:\n    engine=difflib.Differ(charjunk=difflib.IS_CHARACTER_JUNK)\n    diff=list(engine.compare(want_lines,got_lines))\n    kind='ndiff with -expected +actual'\n   else :\n    assert 0,'Bad diff option'\n    \n   diff=[line.rstrip()+'\\n'for line in diff]\n   return 'Differences (%s):\\n'%kind+_indent(''.join(diff))\n   \n   \n   \n  if want and got:\n   return 'Expected:\\n%sGot:\\n%s'%(_indent(want),_indent(got))\n  elif want:\n   return 'Expected:\\n%sGot nothing\\n'%_indent(want)\n  elif got:\n   return 'Expected nothing\\nGot:\\n%s'%_indent(got)\n  else :\n   return 'Expected nothing\\nGot nothing\\n'\n   \nclass DocTestFailure(Exception):\n ''\n\n\n\n\n\n\n\n\n \n def __init__(self,test,example,got):\n  self.test=test\n  self.example=example\n  self.got=got\n  \n def __str__(self):\n  return str(self.test)\n  \nclass UnexpectedException(Exception):\n ''\n\n\n\n\n\n\n\n\n \n def __init__(self,test,example,exc_info):\n  self.test=test\n  self.example=example\n  self.exc_info=exc_info\n  \n def __str__(self):\n  return str(self.test)\n  \nclass DebugRunner(DocTestRunner):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n def run(self,test,compileflags=None ,out=None ,clear_globs=True ):\n  r=DocTestRunner.run(self,test,compileflags,out,False )\n  if clear_globs:\n   test.globs.clear()\n  return r\n  \n def report_unexpected_exception(self,out,test,example,exc_info):\n  raise UnexpectedException(test,example,exc_info)\n  \n def report_failure(self,out,test,example,got):\n  raise DocTestFailure(test,example,got)\n  \n  \n  \n  \n  \n  \n  \n  \nmaster=None\n\ndef testmod(m=None ,name=None ,globs=None ,verbose=None ,\nreport=True ,optionflags=0,extraglobs=None ,\nraise_on_error=False ,exclude_empty=False ):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n global master\n \n \n if m is None :\n \n \n \n  m=sys.modules.get('__main__')\n  \n  \n if not inspect.ismodule(m):\n  raise TypeError(\"testmod: module required; %r\"%(m,))\n  \n  \n if name is None :\n  name=m.__name__\n  \n  \n finder=DocTestFinder(exclude_empty=exclude_empty)\n \n if raise_on_error:\n  runner=DebugRunner(verbose=verbose,optionflags=optionflags)\n else :\n  runner=DocTestRunner(verbose=verbose,optionflags=optionflags)\n  \n for test in finder.find(m,name,globs=globs,extraglobs=extraglobs):\n  runner.run(test)\n  \n if report:\n  runner.summarize()\n  \n if master is None :\n  master=runner\n else :\n  master.merge(runner)\n  \n return TestResults(runner.failures,runner.tries)\n \ndef testfile(filename,module_relative=True ,name=None ,package=None ,\nglobs=None ,verbose=None ,report=True ,optionflags=0,\nextraglobs=None ,raise_on_error=False ,parser=DocTestParser(),\nencoding=None ):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n global master\n \n if package and not module_relative:\n  raise ValueError(\"Package may only be specified for module-\"\n  \"relative paths.\")\n  \n  \n text,filename=_load_testfile(filename,package,module_relative,\n encoding or \"utf-8\")\n \n \n if name is None :\n  name=os.path.basename(filename)\n  \n  \n if globs is None :\n  globs={}\n else :\n  globs=globs.copy()\n if extraglobs is not None :\n  globs.update(extraglobs)\n if '__name__'not in globs:\n  globs['__name__']='__main__'\n  \n if raise_on_error:\n  runner=DebugRunner(verbose=verbose,optionflags=optionflags)\n else :\n  runner=DocTestRunner(verbose=verbose,optionflags=optionflags)\n  \n  \n test=parser.get_doctest(text,globs,name,filename,0)\n runner.run(test)\n \n if report:\n  runner.summarize()\n  \n if master is None :\n  master=runner\n else :\n  master.merge(runner)\n  \n return TestResults(runner.failures,runner.tries)\n \ndef run_docstring_examples(f,globs,verbose=False ,name=\"NoName\",\ncompileflags=None ,optionflags=0):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n finder=DocTestFinder(verbose=verbose,recurse=False )\n runner=DocTestRunner(verbose=verbose,optionflags=optionflags)\n for test in finder.find(f,name,globs=globs):\n  runner.run(test,compileflags=compileflags)\n  \n  \n  \n  \n  \n_unittest_reportflags=0\n\ndef set_unittest_reportflags(flags):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n global _unittest_reportflags\n \n if (flags&REPORTING_FLAGS)!=flags:\n  raise ValueError(\"Only reporting flags allowed\",flags)\n old=_unittest_reportflags\n _unittest_reportflags=flags\n return old\n \n \nclass DocTestCase(unittest.TestCase):\n\n def __init__(self,test,optionflags=0,setUp=None ,tearDown=None ,\n checker=None ):\n \n  unittest.TestCase.__init__(self)\n  self._dt_optionflags=optionflags\n  self._dt_checker=checker\n  self._dt_test=test\n  self._dt_setUp=setUp\n  self._dt_tearDown=tearDown\n  \n def setUp(self):\n  test=self._dt_test\n  \n  if self._dt_setUp is not None :\n   self._dt_setUp(test)\n   \n def tearDown(self):\n  test=self._dt_test\n  \n  if self._dt_tearDown is not None :\n   self._dt_tearDown(test)\n   \n  test.globs.clear()\n  \n def runTest(self):\n  test=self._dt_test\n  old=sys.stdout\n  new=StringIO()\n  optionflags=self._dt_optionflags\n  \n  if not (optionflags&REPORTING_FLAGS):\n  \n  \n   optionflags |=_unittest_reportflags\n   \n  runner=DocTestRunner(optionflags=optionflags,\n  checker=self._dt_checker,verbose=False )\n  \n  try :\n   runner.DIVIDER=\"-\"*70\n   failures,tries=runner.run(\n   test,out=new.write,clear_globs=False )\n  finally :\n   sys.stdout=old\n   \n  if failures:\n   raise self.failureException(self.format_failure(new.getvalue()))\n   \n def format_failure(self,err):\n  test=self._dt_test\n  if test.lineno is None :\n   lineno='unknown line number'\n  else :\n   lineno='%s'%test.lineno\n  lname='.'.join(test.name.split('.')[-1:])\n  return ('Failed doctest test for %s\\n'\n  '  File \"%s\", line %s, in %s\\n\\n%s'\n  %(test.name,test.filename,lineno,lname,err)\n  )\n  \n def debug(self):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  \n  self.setUp()\n  runner=DebugRunner(optionflags=self._dt_optionflags,\n  checker=self._dt_checker,verbose=False )\n  runner.run(self._dt_test,clear_globs=False )\n  self.tearDown()\n  \n def id(self):\n  return self._dt_test.name\n  \n def __eq__(self,other):\n  if type(self)is not type(other):\n   return NotImplemented\n   \n  return self._dt_test ==other._dt_test and\\\n  self._dt_optionflags ==other._dt_optionflags and\\\n  self._dt_setUp ==other._dt_setUp and\\\n  self._dt_tearDown ==other._dt_tearDown and\\\n  self._dt_checker ==other._dt_checker\n  \n def __hash__(self):\n  return hash((self._dt_optionflags,self._dt_setUp,self._dt_tearDown,\n  self._dt_checker))\n  \n def __repr__(self):\n  name=self._dt_test.name.split('.')\n  return \"%s (%s)\"%(name[-1],'.'.join(name[:-1]))\n  \n __str__=__repr__\n \n def shortDescription(self):\n  return \"Doctest: \"+self._dt_test.name\n  \nclass SkipDocTestCase(DocTestCase):\n def __init__(self,module):\n  self.module=module\n  DocTestCase.__init__(self,None )\n  \n def setUp(self):\n  self.skipTest(\"DocTestSuite will not work with -O2 and above\")\n  \n def test_skip(self):\n  pass\n  \n def shortDescription(self):\n  return \"Skipping tests from %s\"%self.module.__name__\n  \n __str__=shortDescription\n \n \nclass _DocTestSuite(unittest.TestSuite):\n\n def _removeTestAtIndex(self,index):\n  pass\n  \n  \ndef DocTestSuite(module=None ,globs=None ,extraglobs=None ,test_finder=None ,\n**options):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n if test_finder is None :\n  test_finder=DocTestFinder()\n  \n module=_normalize_module(module)\n tests=test_finder.find(module,globs=globs,extraglobs=extraglobs)\n \n if not tests and sys.flags.optimize >=2:\n \n  suite=_DocTestSuite()\n  suite.addTest(SkipDocTestCase(module))\n  return suite\n  \n tests.sort()\n suite=_DocTestSuite()\n \n for test in tests:\n  if len(test.examples)==0:\n   continue\n  if not test.filename:\n   filename=module.__file__\n   if filename[-4:]==\".pyc\":\n    filename=filename[:-1]\n   test.filename=filename\n  suite.addTest(DocTestCase(test,**options))\n  \n return suite\n \nclass DocFileCase(DocTestCase):\n\n def id(self):\n  return '_'.join(self._dt_test.name.split('.'))\n  \n def __repr__(self):\n  return self._dt_test.filename\n __str__=__repr__\n \n def format_failure(self,err):\n  return ('Failed doctest test for %s\\n  File \"%s\", line 0\\n\\n%s'\n  %(self._dt_test.name,self._dt_test.filename,err)\n  )\n  \ndef DocFileTest(path,module_relative=True ,package=None ,\nglobs=None ,parser=DocTestParser(),\nencoding=None ,**options):\n if globs is None :\n  globs={}\n else :\n  globs=globs.copy()\n  \n if package and not module_relative:\n  raise ValueError(\"Package may only be specified for module-\"\n  \"relative paths.\")\n  \n  \n doc,path=_load_testfile(path,package,module_relative,\n encoding or \"utf-8\")\n \n if \"__file__\"not in globs:\n  globs[\"__file__\"]=path\n  \n  \n name=os.path.basename(path)\n \n \n test=parser.get_doctest(doc,globs,name,path,0)\n return DocFileCase(test,**options)\n \ndef DocFileSuite(*paths,**kw):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n suite=_DocTestSuite()\n \n \n \n \n if kw.get('module_relative',True ):\n  kw['package']=_normalize_module(kw.get('package'))\n  \n for path in paths:\n  suite.addTest(DocFileTest(path,**kw))\n  \n return suite\n \n \n \n \n \ndef script_from_examples(s):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n output=[]\n for piece in DocTestParser().parse(s):\n  if isinstance(piece,Example):\n  \n   output.append(piece.source[:-1])\n   \n   want=piece.want\n   if want:\n    output.append('# Expected:')\n    output +=['## '+l for l in want.split('\\n')[:-1]]\n  else :\n  \n   output +=[_comment_line(l)\n   for l in piece.split('\\n')[:-1]]\n   \n   \n while output and output[-1]=='#':\n  output.pop()\n while output and output[0]=='#':\n  output.pop(0)\n  \n  \n return '\\n'.join(output)+'\\n'\n \ndef testsource(module,name):\n ''\n\n\n\n\n \n module=_normalize_module(module)\n tests=DocTestFinder().find(module)\n test=[t for t in tests if t.name ==name]\n if not test:\n  raise ValueError(name,\"not found in tests\")\n test=test[0]\n testsrc=script_from_examples(test.docstring)\n return testsrc\n \ndef debug_src(src,pm=False ,globs=None ):\n ''\n testsrc=script_from_examples(src)\n debug_script(testsrc,pm,globs)\n \ndef debug_script(src,pm=False ,globs=None ):\n ''\n import pdb\n \n if globs:\n  globs=globs.copy()\n else :\n  globs={}\n  \n if pm:\n  try :\n   exec(src,globs,globs)\n  except :\n   print(sys.exc_info()[1])\n   p=pdb.Pdb(nosigint=True )\n   p.reset()\n   p.interaction(None ,sys.exc_info()[2])\n else :\n  pdb.Pdb(nosigint=True ).run(\"exec(%r)\"%src,globs,globs)\n  \ndef debug(module,name,pm=False ):\n ''\n\n\n\n\n \n module=_normalize_module(module)\n testsrc=testsource(module,name)\n debug_script(testsrc,pm,module.__dict__)\n \n \n \n \nclass _TestClass:\n ''\n\n\n\n\n\n\n\n\n\n\n \n \n def __init__(self,val):\n  ''\n\n\n\n\n  \n  \n  self.val=val\n  \n def square(self):\n  ''\n\n\n\n  \n  \n  self.val=self.val **2\n  return self\n  \n def get(self):\n  ''\n\n\n\n\n  \n  \n  return self.val\n  \n__test__={\"_TestClass\":_TestClass,\n\"string\":r\"\"\"\n                      Example of a string object, searched as-is.\n                      >>> x = 1; y = 2\n                      >>> x + y, x * y\n                      (3, 2)\n                      \"\"\",\n\n\"bool-int equivalence\":r\"\"\"\n                                    In 2.2, boolean expressions displayed\n                                    0 or 1.  By default, we still accept\n                                    them.  This can be disabled by passing\n                                    DONT_ACCEPT_TRUE_FOR_1 to the new\n                                    optionflags argument.\n                                    >>> 4 == 4\n                                    1\n                                    >>> 4 == 4\n                                    True\n                                    >>> 4 > 4\n                                    0\n                                    >>> 4 > 4\n                                    False\n                                    \"\"\",\n\n\"blank lines\":r\"\"\"\n                Blank lines can be marked with <BLANKLINE>:\n                    >>> print('foo\\n\\nbar\\n')\n                    foo\n                    <BLANKLINE>\n                    bar\n                    <BLANKLINE>\n            \"\"\",\n\n\"ellipsis\":r\"\"\"\n                If the ellipsis flag is used, then '...' can be used to\n                elide substrings in the desired output:\n                    >>> print(list(range(1000))) #doctest: +ELLIPSIS\n                    [0, 1, 2, ..., 999]\n            \"\"\",\n\n\"whitespace normalization\":r\"\"\"\n                If the whitespace normalization flag is used, then\n                differences in whitespace are ignored.\n                    >>> print(list(range(30))) #doctest: +NORMALIZE_WHITESPACE\n                    [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14,\n                     15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26,\n                     27, 28, 29]\n            \"\"\",\n}\n\n\ndef _test():\n import argparse\n \n parser=argparse.ArgumentParser(description=\"doctest runner\")\n parser.add_argument('-v','--verbose',action='store_true',default=False ,\n help='print very verbose output for all tests')\n parser.add_argument('-o','--option',action='append',\n choices=OPTIONFLAGS_BY_NAME.keys(),default=[],\n help=('specify a doctest option flag to apply'\n ' to the test run; may be specified more'\n ' than once to apply multiple options'))\n parser.add_argument('-f','--fail-fast',action='store_true',\n help=('stop running tests after first failure (this'\n ' is a shorthand for -o FAIL_FAST, and is'\n ' in addition to any other -o options)'))\n parser.add_argument('file',nargs='+',\n help='file containing the tests to run')\n args=parser.parse_args()\n testfiles=args.file\n \n \n verbose=args.verbose\n options=0\n for option in args.option:\n  options |=OPTIONFLAGS_BY_NAME[option]\n if args.fail_fast:\n  options |=FAIL_FAST\n for filename in testfiles:\n  if filename.endswith(\".py\"):\n  \n  \n  \n   dirname,filename=os.path.split(filename)\n   sys.path.insert(0,dirname)\n   m=__import__(filename[:-3])\n   del sys.path[0]\n   failures,_=testmod(m,verbose=verbose,optionflags=options)\n  else :\n   failures,_=testfile(filename,module_relative=False ,\n   verbose=verbose,optionflags=options)\n  if failures:\n   return 1\n return 0\n \n \nif __name__ ==\"__main__\":\n sys.exit(_test())\n", ["__future__", "argparse", "builtins", "collections", "difflib", "inspect", "io", "linecache", "os", "pdb", "re", "sys", "traceback", "unittest"]], "enum": [".py", "import sys\nfrom types import MappingProxyType,DynamicClassAttribute\n\n\ntry :\n from _collections import OrderedDict\nexcept ImportError:\n from collections import OrderedDict\n \n \n__all__=[\n'EnumMeta',\n'Enum','IntEnum','Flag','IntFlag',\n'auto','unique',\n]\n\n\ndef _is_descriptor(obj):\n ''\n return (\n hasattr(obj,'__get__')or\n hasattr(obj,'__set__')or\n hasattr(obj,'__delete__'))\n \n \ndef _is_dunder(name):\n ''\n return (name[:2]==name[-2:]=='__'and\n name[2:3]!='_'and\n name[-3:-2]!='_'and\n len(name)>4)\n \n \ndef _is_sunder(name):\n ''\n return (name[0]==name[-1]=='_'and\n name[1:2]!='_'and\n name[-2:-1]!='_'and\n len(name)>2)\n \ndef _make_class_unpicklable(cls):\n ''\n def _break_on_call_reduce(self,proto):\n  raise TypeError('%r cannot be pickled'%self)\n cls.__reduce_ex__=_break_on_call_reduce\n cls.__module__='<unknown>'\n \n_auto_null=object()\nclass auto:\n ''\n\n \n value=_auto_null\n \n \nclass _EnumDict(dict):\n ''\n\n\n\n\n \n def __init__(self):\n  super().__init__()\n  self._member_names=[]\n  self._last_values=[]\n  self._ignore=[]\n  \n def __setitem__(self,key,value):\n  ''\n\n\n\n\n\n\n  \n  if _is_sunder(key):\n   if key not in (\n   '_order_','_create_pseudo_member_',\n   '_generate_next_value_','_missing_','_ignore_',\n   ):\n    raise ValueError('_names_ are reserved for future Enum use')\n   if key =='_generate_next_value_':\n    setattr(self,'_generate_next_value',value)\n   elif key =='_ignore_':\n    if isinstance(value,str):\n     value=value.replace(',',' ').split()\n    else :\n     value=list(value)\n    self._ignore=value\n    already=set(value)&set(self._member_names)\n    if already:\n     raise ValueError('_ignore_ cannot specify already set names: %r'%(already,))\n  elif _is_dunder(key):\n   if key =='__order__':\n    key='_order_'\n  elif key in self._member_names:\n  \n   raise TypeError('Attempted to reuse key: %r'%key)\n  elif key in self._ignore:\n   pass\n  elif not _is_descriptor(value):\n   if key in self:\n   \n    raise TypeError('%r already defined as: %r'%(key,self[key]))\n   if isinstance(value,auto):\n    if value.value ==_auto_null:\n     value.value=self._generate_next_value(key,1,len(self._member_names),self._last_values[:])\n    value=value.value\n   self._member_names.append(key)\n   self._last_values.append(value)\n  super().__setitem__(key,value)\n  \n  \n  \n  \n  \nEnum=None\n\n\nclass EnumMeta(type):\n ''\n @classmethod\n def __prepare__(metacls,cls,bases):\n \n  enum_dict=_EnumDict()\n  \n  member_type,first_enum=metacls._get_mixins_(bases)\n  if first_enum is not None :\n   enum_dict['_generate_next_value_']=getattr(first_enum,'_generate_next_value_',None )\n  return enum_dict\n  \n def __new__(metacls,cls,bases,classdict):\n \n \n \n \n \n \n  classdict.setdefault('_ignore_',[]).append('_ignore_')\n  ignore=classdict['_ignore_']\n  for key in ignore:\n   classdict.pop(key,None )\n  member_type,first_enum=metacls._get_mixins_(bases)\n  __new__,save_new,use_args=metacls._find_new_(classdict,member_type,\n  first_enum)\n  \n  \n  \n  enum_members={k:classdict[k]for k in classdict._member_names}\n  for name in classdict._member_names:\n   del classdict[name]\n   \n   \n  _order_=classdict.pop('_order_',None )\n  \n  \n  invalid_names=set(enum_members)&{'mro',}\n  if invalid_names:\n   raise ValueError('Invalid enum member name: {0}'.format(\n   ','.join(invalid_names)))\n   \n   \n  if '__doc__'not in classdict:\n   classdict['__doc__']='An enumeration.'\n   \n   \n  enum_class=super().__new__(metacls,cls,bases,classdict)\n  enum_class._member_names_=[]\n  enum_class._member_map_=OrderedDict()\n  enum_class._member_type_=member_type\n  \n  \n  \n  base_attributes={a for b in enum_class.mro()for a in b.__dict__}\n  \n  \n  enum_class._value2member_map_={}\n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  if '__reduce_ex__'not in classdict:\n   if member_type is not object:\n    methods=('__getnewargs_ex__','__getnewargs__',\n    '__reduce_ex__','__reduce__')\n    if not any(m in member_type.__dict__ for m in methods):\n     _make_class_unpicklable(enum_class)\n     \n     \n     \n     \n     \n  for member_name in classdict._member_names:\n   value=enum_members[member_name]\n   if not isinstance(value,tuple):\n    args=(value,)\n   else :\n    args=value\n   if member_type is tuple:\n    args=(args,)\n   if not use_args:\n    enum_member=__new__(enum_class)\n    if not hasattr(enum_member,'_value_'):\n     enum_member._value_=value\n   else :\n    enum_member=__new__(enum_class,*args)\n    if not hasattr(enum_member,'_value_'):\n     if member_type is object:\n      enum_member._value_=value\n     else :\n      enum_member._value_=member_type(*args)\n   value=enum_member._value_\n   enum_member._name_=member_name\n   enum_member.__objclass__=enum_class\n   enum_member.__init__(*args)\n   \n   \n   for name,canonical_member in enum_class._member_map_.items():\n    if canonical_member._value_ ==enum_member._value_:\n     enum_member=canonical_member\n     break\n   else :\n   \n    enum_class._member_names_.append(member_name)\n    \n    \n   if member_name not in base_attributes:\n    setattr(enum_class,member_name,enum_member)\n    \n   enum_class._member_map_[member_name]=enum_member\n   try :\n   \n   \n   \n    enum_class._value2member_map_[value]=enum_member\n   except TypeError:\n    pass\n    \n    \n    \n  for name in ('__repr__','__str__','__format__','__reduce_ex__'):\n   class_method=getattr(enum_class,name)\n   obj_method=getattr(member_type,name,None )\n   enum_method=getattr(first_enum,name,None )\n   if obj_method is not None and obj_method is class_method:\n    setattr(enum_class,name,enum_method)\n    \n    \n    \n  if Enum is not None :\n  \n  \n   if save_new:\n    enum_class.__new_member__=__new__\n   enum_class.__new__=Enum.__new__\n   \n   \n  if _order_ is not None :\n   if isinstance(_order_,str):\n    _order_=_order_.replace(',',' ').split()\n   if _order_ !=enum_class._member_names_:\n    raise TypeError('member order does not match _order_')\n    \n  return enum_class\n  \n def __bool__(self):\n  ''\n\n  \n  return True\n  \n def __call__(cls,value,names=None ,*,module=None ,qualname=None ,type=None ,start=1):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  if names is None :\n   return cls.__new__(cls,value)\n   \n  return cls._create_(value,names,module=module,qualname=qualname,type=type,start=start)\n  \n def __contains__(cls,member):\n  if not isinstance(member,Enum):\n   import warnings\n   warnings.warn(\n   \"using non-Enums in containment checks will raise \"\n   \"TypeError in Python 3.8\",\n   DeprecationWarning,2)\n  return isinstance(member,cls)and member._name_ in cls._member_map_\n  \n def __delattr__(cls,attr):\n \n \n  if attr in cls._member_map_:\n   raise AttributeError(\n   \"%s: cannot delete Enum member.\"%cls.__name__)\n  super().__delattr__(attr)\n  \n def __dir__(self):\n  return (['__class__','__doc__','__members__','__module__']+\n  self._member_names_)\n  \n def __getattr__(cls,name):\n  ''\n\n\n\n\n\n\n  \n  if _is_dunder(name):\n   raise AttributeError(name)\n  try :\n   return cls._member_map_[name]\n  except KeyError:\n   raise AttributeError(name)from None\n   \n def __getitem__(cls,name):\n  return cls._member_map_[name]\n  \n def __iter__(cls):\n  return (cls._member_map_[name]for name in cls._member_names_)\n  \n def __len__(cls):\n  return len(cls._member_names_)\n  \n @property\n def __members__(cls):\n  ''\n\n\n\n\n  \n  return MappingProxyType(cls._member_map_)\n  \n def __repr__(cls):\n  return \"<enum %r>\"%cls.__name__\n  \n def __reversed__(cls):\n  return (cls._member_map_[name]for name in reversed(cls._member_names_))\n  \n def __setattr__(cls,name,value):\n  ''\n\n\n\n\n\n  \n  member_map=cls.__dict__.get('_member_map_',{})\n  if name in member_map:\n   raise AttributeError('Cannot reassign members.')\n  super().__setattr__(name,value)\n  \n def _create_(cls,class_name,names,*,module=None ,qualname=None ,type=None ,start=1):\n  ''\n\n\n\n\n\n\n\n\n\n  \n  metacls=cls.__class__\n  bases=(cls,)if type is None else (type,cls)\n  _,first_enum=cls._get_mixins_(bases)\n  classdict=metacls.__prepare__(class_name,bases)\n  \n  \n  if isinstance(names,str):\n   names=names.replace(',',' ').split()\n  if isinstance(names,(tuple,list))and names and isinstance(names[0],str):\n   original_names,names=names,[]\n   last_values=[]\n   for count,name in enumerate(original_names):\n    value=first_enum._generate_next_value_(name,start,count,last_values[:])\n    last_values.append(value)\n    names.append((name,value))\n    \n    \n  for item in names:\n   if isinstance(item,str):\n    member_name,member_value=item,names[item]\n   else :\n    member_name,member_value=item\n   classdict[member_name]=member_value\n  enum_class=metacls.__new__(metacls,class_name,bases,classdict)\n  \n  \n  \n  if module is None :\n   try :\n    module=sys._getframe(2).f_globals['__name__']\n   except (AttributeError,ValueError)as exc:\n    pass\n  if module is None :\n   _make_class_unpicklable(enum_class)\n  else :\n   enum_class.__module__=module\n  if qualname is not None :\n   enum_class.__qualname__=qualname\n   \n  return enum_class\n  \n @staticmethod\n def _get_mixins_(bases):\n  ''\n\n\n\n\n  \n  if not bases:\n   return object,Enum\n   \n   \n   \n   \n  member_type=first_enum=None\n  for base in bases:\n   if (base is not Enum and\n   issubclass(base,Enum)and\n   base._member_names_):\n    raise TypeError(\"Cannot extend enumerations\")\n    \n  if not issubclass(base,Enum):\n   raise TypeError(\"new enumerations must be created as \"\n   \"`ClassName([mixin_type,] enum_type)`\")\n   \n   \n   \n  if not issubclass(bases[0],Enum):\n   member_type=bases[0]\n   first_enum=bases[-1]\n  else :\n   for base in bases[0].__mro__:\n   \n   \n   \n   \n    if issubclass(base,Enum):\n     if first_enum is None :\n      first_enum=base\n    else :\n     if member_type is None :\n      member_type=base\n      \n  return member_type,first_enum\n  \n @staticmethod\n def _find_new_(classdict,member_type,first_enum):\n  ''\n\n\n\n\n\n  \n  \n  \n  \n  __new__=classdict.get('__new__',None )\n  \n  \n  save_new=__new__ is not None\n  \n  if __new__ is None :\n  \n  \n   for method in ('__new_member__','__new__'):\n    for possible in (member_type,first_enum):\n     target=getattr(possible,method,None )\n     if target not in {\n     None ,\n     None .__new__,\n     object.__new__,\n     Enum.__new__,\n     }:\n      __new__=target\n      break\n    if __new__ is not None :\n     break\n   else :\n    __new__=object.__new__\n    \n    \n    \n    \n  if __new__ is object.__new__:\n   use_args=False\n  else :\n   use_args=True\n   \n  return __new__,save_new,use_args\n  \n  \nclass Enum(metaclass=EnumMeta):\n ''\n\n\n\n \n def __new__(cls,value):\n \n \n \n  if type(value)is cls:\n  \n   return value\n   \n   \n  try :\n   if value in cls._value2member_map_:\n    return cls._value2member_map_[value]\n  except TypeError:\n  \n   for member in cls._member_map_.values():\n    if member._value_ ==value:\n     return member\n     \n  return cls._missing_(value)\n  \n def _generate_next_value_(name,start,count,last_values):\n  for last_value in reversed(last_values):\n   try :\n    return last_value+1\n   except TypeError:\n    pass\n  else :\n   return start\n   \n @classmethod\n def _missing_(cls,value):\n  raise ValueError(\"%r is not a valid %s\"%(value,cls.__name__))\n  \n def __repr__(self):\n  return \"<%s.%s: %r>\"%(\n  self.__class__.__name__,self._name_,self._value_)\n  \n def __str__(self):\n  return \"%s.%s\"%(self.__class__.__name__,self._name_)\n  \n def __dir__(self):\n  added_behavior=[\n  m\n  for cls in self.__class__.mro()\n  for m in cls.__dict__\n  if m[0]!='_'and m not in self._member_map_\n  ]\n  return (['__class__','__doc__','__module__']+added_behavior)\n  \n def __format__(self,format_spec):\n \n \n \n \n \n  if self._member_type_ is object:\n   cls=str\n   val=str(self)\n   \n  else :\n   cls=self._member_type_\n   val=self._value_\n  return cls.__format__(val,format_spec)\n  \n def __hash__(self):\n  return hash(self._name_)\n  \n def __reduce_ex__(self,proto):\n  return self.__class__,(self._value_,)\n  \n  \n  \n  \n  \n  \n  \n  \n @DynamicClassAttribute\n def name(self):\n  ''\n  return self._name_\n  \n @DynamicClassAttribute\n def value(self):\n  ''\n  return self._value_\n  \n @classmethod\n def _convert(cls,name,module,filter,source=None ):\n  ''\n\n  \n  \n  \n  \n  \n  \n  module_globals=vars(sys.modules[module])\n  if source:\n   source=vars(source)\n  else :\n   source=module_globals\n   \n   \n   \n   \n   \n  members=[\n  (name,source[name])\n  for name in source.keys()\n  if filter(name)]\n  try :\n  \n   members.sort(key=lambda t:(t[1],t[0]))\n  except TypeError:\n  \n   members.sort(key=lambda t:t[0])\n  cls=cls(name,members,module=module)\n  cls.__reduce_ex__=_reduce_ex_by_name\n  module_globals.update(cls.__members__)\n  module_globals[name]=cls\n  return cls\n  \n  \nclass IntEnum(int,Enum):\n ''\n \n \ndef _reduce_ex_by_name(self,proto):\n return self.name\n \nclass Flag(Enum):\n ''\n \n def _generate_next_value_(name,start,count,last_values):\n  ''\n\n\n\n\n\n\n  \n  if not count:\n   return start if start is not None else 1\n  for last_value in reversed(last_values):\n   try :\n    high_bit=_high_bit(last_value)\n    break\n   except Exception:\n    raise TypeError('Invalid Flag value: %r'%last_value)from None\n  return 2 **(high_bit+1)\n  \n @classmethod\n def _missing_(cls,value):\n  original_value=value\n  if value <0:\n   value=~value\n  possible_member=cls._create_pseudo_member_(value)\n  if original_value <0:\n   possible_member=~possible_member\n  return possible_member\n  \n @classmethod\n def _create_pseudo_member_(cls,value):\n  ''\n\n  \n  pseudo_member=cls._value2member_map_.get(value,None )\n  if pseudo_member is None :\n  \n   _,extra_flags=_decompose(cls,value)\n   if extra_flags:\n    raise ValueError(\"%r is not a valid %s\"%(value,cls.__name__))\n    \n   pseudo_member=object.__new__(cls)\n   pseudo_member._name_=None\n   pseudo_member._value_=value\n   \n   \n   pseudo_member=cls._value2member_map_.setdefault(value,pseudo_member)\n  return pseudo_member\n  \n def __contains__(self,other):\n  if not isinstance(other,self.__class__):\n   import warnings\n   warnings.warn(\n   \"using non-Flags in containment checks will raise \"\n   \"TypeError in Python 3.8\",\n   DeprecationWarning,2)\n   return False\n  return other._value_&self._value_ ==other._value_\n  \n def __repr__(self):\n  cls=self.__class__\n  if self._name_ is not None :\n   return '<%s.%s: %r>'%(cls.__name__,self._name_,self._value_)\n  members,uncovered=_decompose(cls,self._value_)\n  return '<%s.%s: %r>'%(\n  cls.__name__,\n  '|'.join([str(m._name_ or m._value_)for m in members]),\n  self._value_,\n  )\n  \n def __str__(self):\n  cls=self.__class__\n  if self._name_ is not None :\n   return '%s.%s'%(cls.__name__,self._name_)\n  members,uncovered=_decompose(cls,self._value_)\n  if len(members)==1 and members[0]._name_ is None :\n   return '%s.%r'%(cls.__name__,members[0]._value_)\n  else :\n   return '%s.%s'%(\n   cls.__name__,\n   '|'.join([str(m._name_ or m._value_)for m in members]),\n   )\n   \n def __bool__(self):\n  return bool(self._value_)\n  \n def __or__(self,other):\n  if not isinstance(other,self.__class__):\n   return NotImplemented\n  return self.__class__(self._value_ |other._value_)\n  \n def __and__(self,other):\n  if not isinstance(other,self.__class__):\n   return NotImplemented\n  return self.__class__(self._value_&other._value_)\n  \n def __xor__(self,other):\n  if not isinstance(other,self.__class__):\n   return NotImplemented\n  return self.__class__(self._value_ ^other._value_)\n  \n def __invert__(self):\n  members,uncovered=_decompose(self.__class__,self._value_)\n  inverted=self.__class__(0)\n  for m in self.__class__:\n   if m not in members and not (m._value_&self._value_):\n    inverted=inverted |m\n  return self.__class__(inverted)\n  \n  \nclass IntFlag(int,Flag):\n ''\n \n @classmethod\n def _missing_(cls,value):\n  if not isinstance(value,int):\n   raise ValueError(\"%r is not a valid %s\"%(value,cls.__name__))\n  new_member=cls._create_pseudo_member_(value)\n  return new_member\n  \n @classmethod\n def _create_pseudo_member_(cls,value):\n  pseudo_member=cls._value2member_map_.get(value,None )\n  if pseudo_member is None :\n   need_to_create=[value]\n   \n   _,extra_flags=_decompose(cls,value)\n   \n   while extra_flags:\n   \n    bit=_high_bit(extra_flags)\n    flag_value=2 **bit\n    if (flag_value not in cls._value2member_map_ and\n    flag_value not in need_to_create\n    ):\n     need_to_create.append(flag_value)\n    if extra_flags ==-flag_value:\n     extra_flags=0\n    else :\n     extra_flags ^=flag_value\n   for value in reversed(need_to_create):\n   \n    pseudo_member=int.__new__(cls,value)\n    pseudo_member._name_=None\n    pseudo_member._value_=value\n    \n    \n    pseudo_member=cls._value2member_map_.setdefault(value,pseudo_member)\n  return pseudo_member\n  \n def __or__(self,other):\n  if not isinstance(other,(self.__class__,int)):\n   return NotImplemented\n  result=self.__class__(self._value_ |self.__class__(other)._value_)\n  return result\n  \n def __and__(self,other):\n  if not isinstance(other,(self.__class__,int)):\n   return NotImplemented\n  return self.__class__(self._value_&self.__class__(other)._value_)\n  \n def __xor__(self,other):\n  if not isinstance(other,(self.__class__,int)):\n   return NotImplemented\n  return self.__class__(self._value_ ^self.__class__(other)._value_)\n  \n __ror__=__or__\n __rand__=__and__\n __rxor__=__xor__\n \n def __invert__(self):\n  result=self.__class__(~self._value_)\n  return result\n  \n  \ndef _high_bit(value):\n ''\n return value.bit_length()-1\n \ndef unique(enumeration):\n ''\n duplicates=[]\n for name,member in enumeration.__members__.items():\n  if name !=member.name:\n   duplicates.append((name,member.name))\n if duplicates:\n  alias_details=', '.join(\n  [\"%s -> %s\"%(alias,name)for (alias,name)in duplicates])\n  raise ValueError('duplicate values found in %r: %s'%\n  (enumeration,alias_details))\n return enumeration\n \ndef _decompose(flag,value):\n ''\n \n not_covered=value\n negative=value <0\n \n \n \n if negative:\n \n  flags_to_check=[\n  (m,v)\n  for v,m in list(flag._value2member_map_.items())\n  if m.name is not None\n  ]\n else :\n \n  flags_to_check=[\n  (m,v)\n  for v,m in list(flag._value2member_map_.items())\n  if m.name is not None or _power_of_two(v)\n  ]\n members=[]\n for member,member_value in flags_to_check:\n  if member_value and member_value&value ==member_value:\n   members.append(member)\n   not_covered &=~member_value\n if not members and value in flag._value2member_map_:\n  members.append(flag._value2member_map_[value])\n members.sort(key=lambda m:m._value_,reverse=True )\n if len(members)>1 and members[0].value ==value:\n \n  members.pop(0)\n return members,not_covered\n \ndef _power_of_two(value):\n if value <1:\n  return False\n return value ==2 **_high_bit(value)\n", ["_collections", "collections", "sys", "types", "warnings"]], "errno": [".py", "''\n\n\n\n\n\n\n\n\n\n\n\n\n\nE2BIG=7\n\nEACCES=13\n\nEADDRINUSE=10048\n\nEADDRNOTAVAIL=10049\n\nEAFNOSUPPORT=10047\n\nEAGAIN=11\n\nEALREADY=10037\n\nEBADF=9\n\nEBADMSG=104\n\nEBUSY=16\n\nECANCELED=105\n\nECHILD=10\n\nECONNABORTED=10053\n\nECONNREFUSED=10061\n\nECONNRESET=10054\n\nEDEADLK=36\n\nEDEADLOCK=36\n\nEDESTADDRREQ=10039\n\nEDOM=33\n\nEDQUOT=10069\n\nEEXIST=17\n\nEFAULT=14\n\nEFBIG=27\n\nEHOSTDOWN=10064\n\nEHOSTUNREACH=10065\n\nEIDRM=111\n\nEILSEQ=42\n\nEINPROGRESS=10036\n\nEINTR=4\n\nEINVAL=22\n\nEIO=5\n\nEISCONN=10056\n\nEISDIR=21\n\nELOOP=10062\n\nEMFILE=24\n\nEMLINK=31\n\nEMSGSIZE=10040\n\nENAMETOOLONG=38\n\nENETDOWN=10050\n\nENETRESET=10052\n\nENETUNREACH=10051\n\nENFILE=23\n\nENOBUFS=10055\n\nENODATA=120\n\nENODEV=19\n\nENOENT=2\n\nENOEXEC=8\n\nENOLCK=39\n\nENOLINK=121\n\nENOMEM=12\n\nENOMSG=122\n\nENOPROTOOPT=10042\n\nENOSPC=28\n\nENOSR=124\n\nENOSTR=125\n\nENOSYS=40\n\nENOTCONN=10057\n\nENOTDIR=20\n\nENOTEMPTY=41\n\nENOTRECOVERABLE=127\n\nENOTSOCK=10038\n\nENOTSUP=129\n\nENOTTY=25\n\nENXIO=6\n\nEOPNOTSUPP=10045\n\nEOVERFLOW=132\n\nEOWNERDEAD=133\n\nEPERM=1\n\nEPFNOSUPPORT=10046\n\nEPIPE=32\n\nEPROTO=134\n\nEPROTONOSUPPORT=10043\n\nEPROTOTYPE=10041\n\nERANGE=34\n\nEREMOTE=10071\n\nEROFS=30\n\nESHUTDOWN=10058\n\nESOCKTNOSUPPORT=10044\n\nESPIPE=29\n\nESRCH=3\n\nESTALE=10070\n\nETIME=137\n\nETIMEDOUT=10060\n\nETOOMANYREFS=10059\n\nETXTBSY=139\n\nEUSERS=10068\n\nEWOULDBLOCK=10035\n\nEXDEV=18\n\nWSABASEERR=10000\n\nWSAEACCES=10013\n\nWSAEADDRINUSE=10048\n\nWSAEADDRNOTAVAIL=10049\n\nWSAEAFNOSUPPORT=10047\n\nWSAEALREADY=10037\n\nWSAEBADF=10009\n\nWSAECONNABORTED=10053\n\nWSAECONNREFUSED=10061\n\nWSAECONNRESET=10054\n\nWSAEDESTADDRREQ=10039\n\nWSAEDISCON=10101\n\nWSAEDQUOT=10069\n\nWSAEFAULT=10014\n\nWSAEHOSTDOWN=10064\n\nWSAEHOSTUNREACH=10065\n\nWSAEINPROGRESS=10036\n\nWSAEINTR=10004\n\nWSAEINVAL=10022\n\nWSAEISCONN=10056\n\nWSAELOOP=10062\n\nWSAEMFILE=10024\n\nWSAEMSGSIZE=10040\n\nWSAENAMETOOLONG=10063\n\nWSAENETDOWN=10050\n\nWSAENETRESET=10052\n\nWSAENETUNREACH=10051\n\nWSAENOBUFS=10055\n\nWSAENOPROTOOPT=10042\n\nWSAENOTCONN=10057\n\nWSAENOTEMPTY=10066\n\nWSAENOTSOCK=10038\n\nWSAEOPNOTSUPP=10045\n\nWSAEPFNOSUPPORT=10046\n\nWSAEPROCLIM=10067\n\nWSAEPROTONOSUPPORT=10043\n\nWSAEPROTOTYPE=10041\n\nWSAEREMOTE=10071\n\nWSAESHUTDOWN=10058\n\nWSAESOCKTNOSUPPORT=10044\n\nWSAESTALE=10070\n\nWSAETIMEDOUT=10060\n\nWSAETOOMANYREFS=10059\n\nWSAEUSERS=10068\n\nWSAEWOULDBLOCK=10035\n\nWSANOTINITIALISED=10093\n\nWSASYSNOTREADY=10091\n\nWSAVERNOTSUPPORTED=10092\n\nerrorcode={v:k for (k,v)in globals().items()if k ==k.upper()}\n", []], "external_import": [".py", "import os\nfrom browser import doc\nimport urllib.request\n\n\n\n\n\nclass ModuleFinder:\n def __init__(self,path_entry):\n  print(\"external_import here..\")\n  \n  self._module=None\n  if path_entry.startswith('http://'):\n   self.path_entry=path_entry\n  else :\n   raise ImportError()\n   \n def __str__(self):\n  return '<%s for \"%s\">'%(self.__class__.__name__,self.path_entry)\n  \n def find_module(self,fullname,path=None ):\n  path=path or self.path_entry\n  \n  for _ext in ['js','pyj','py']:\n   _fp,_url,_headers=urllib.request.urlopen(path+'/'+'%s.%s'%(fullname,_ext))\n   self._module=_fp.read()\n   _fp.close()\n   if self._module is not None :\n    print(\"module found at %s:%s\"%(path,fullname))\n    return ModuleLoader(path,fullname,self._module)\n    \n  print('module %s not found'%fullname)\n  raise ImportError()\n  return None\n  \nclass ModuleLoader:\n ''\n \n def __init__(self,filepath,name,module_source):\n  self._filepath=filepath\n  self._name=name\n  self._module_source=module_source\n  \n def get_source(self):\n  return self._module_source\n  \n def is_package(self):\n  return '.'in self._name\n  \n def load_module(self):\n  if self._name in sys.modules:\n  \n   mod=sys.modules[self._name]\n   return mod\n   \n  _src=self.get_source()\n  if self._filepath.endswith('.js'):\n   mod=JSObject(import_js_module(_src,self._filepath,self._name))\n  elif self._filepath.endswith('.py'):\n   mod=JSObject(import_py_module(_src,self._filepath,self._name))\n  elif self._filepath.endswith('.pyj'):\n   mod=JSObject(import_pyj_module(_src,self._filepath,self._name))\n  else :\n   raise ImportError('Invalid Module: %s'%self._filepath)\n   \n   \n  mod.__file__=self._filepath\n  mod.__name__=self._name\n  mod.__path__=os.path.abspath(self._filepath)\n  mod.__loader__=self\n  mod.__package__='.'.join(self._name.split('.')[:-1])\n  \n  if self.is_package():\n   print('adding path for package')\n   \n   \n   mod.__path__=[self._filepath]\n  else :\n   print('imported as regular module')\n   \n  print('creating a new module object for \"%s\"'%self._name)\n  sys.modules.setdefault(self._name,mod)\n  JSObject(__BRYTHON__.imported)[self._name]=mod\n  \n  return mod\n", ["browser", "os", "urllib.request"]], "faulthandler": [".py", "''\n\n\n_EXCEPTION_ACCESS_VIOLATION=-1073741819\n\n_EXCEPTION_INT_DIVIDE_BY_ZERO=-1073741676\n\n_EXCEPTION_NONCONTINUABLE=1\n\n_EXCEPTION_NONCONTINUABLE_EXCEPTION=-1073741787\n\n_EXCEPTION_STACK_OVERFLOW=-1073741571\n\nclass __loader__(object):\n ''\n\n\n\n\n \n \n \n __delattr__=\"<slot wrapper '__delattr__' of 'object' objects>\"\n \n __dict__=\"{'__module__': '_frozen_importlib', '__doc__': 'Meta path import for built-in modules.\\n\\n    All methods are either class or static methods to avoid the need to\\n    instantiate the class.\\n\\n    ', 'module_repr': <staticmethod object at 0x000001F9B17F15F8>, 'find_spec': <classmethod object at 0x000001F9B17F1630>, 'find_module': <classmethod object at 0x000001F9B17F1668>, 'create_module': <classmethod object at 0x000001F9B17F16A0>, 'exec_module': <classmethod object at 0x000001F9B17F16D8>, 'get_code': <classmethod object at 0x000001F9B17F1748>, 'get_source': <classmethod object at 0x000001F9B17F17B8>, 'is_package': <classmethod object at 0x000001F9B17F1828>, 'load_module': <classmethod object at 0x000001F9B17F1860>, '__dict__': <attribute '__dict__' of 'BuiltinImporter' objects>, '__weakref__': <attribute '__weakref__' of 'BuiltinImporter' objects>}\"\n \n __dir__=\"<method '__dir__' of 'object' objects>\"\n \n __eq__=\"<slot wrapper '__eq__' of 'object' objects>\"\n \n __format__=\"<method '__format__' of 'object' objects>\"\n \n __ge__=\"<slot wrapper '__ge__' of 'object' objects>\"\n \n __getattribute__=\"<slot wrapper '__getattribute__' of 'object' objects>\"\n \n __gt__=\"<slot wrapper '__gt__' of 'object' objects>\"\n \n __hash__=\"<slot wrapper '__hash__' of 'object' objects>\"\n \n __init__=\"<slot wrapper '__init__' of 'object' objects>\"\n \n def __init_subclass__(*args,**kw):\n  ''\n\n\n  \n  pass\n  \n __le__=\"<slot wrapper '__le__' of 'object' objects>\"\n \n __lt__=\"<slot wrapper '__lt__' of 'object' objects>\"\n \n __module__=\"\"\"_frozen_importlib\"\"\"\n \n __ne__=\"<slot wrapper '__ne__' of 'object' objects>\"\n \n def __new__(*args,**kw):\n  ''\n  pass\n  \n __reduce__=\"<method '__reduce__' of 'object' objects>\"\n \n __reduce_ex__=\"<method '__reduce_ex__' of 'object' objects>\"\n \n __repr__=\"<slot wrapper '__repr__' of 'object' objects>\"\n \n __setattr__=\"<slot wrapper '__setattr__' of 'object' objects>\"\n \n __sizeof__=\"<method '__sizeof__' of 'object' objects>\"\n \n __str__=\"<slot wrapper '__str__' of 'object' objects>\"\n \n def __subclasshook__(*args,**kw):\n  ''\n\n\n\n\n  \n  pass\n  \n __weakref__=\"<attribute '__weakref__' of 'BuiltinImporter' objects>\"\n \n create_module=\"<bound method BuiltinImporter.create_module of <class '_frozen_importlib.BuiltinImporter'>>\"\n \n exec_module=\"<bound method BuiltinImporter.exec_module of <class '_frozen_importlib.BuiltinImporter'>>\"\n \n find_module=\"<bound method BuiltinImporter.find_module of <class '_frozen_importlib.BuiltinImporter'>>\"\n \n find_spec=\"<bound method BuiltinImporter.find_spec of <class '_frozen_importlib.BuiltinImporter'>>\"\n \n get_code=\"<bound method BuiltinImporter.get_code of <class '_frozen_importlib.BuiltinImporter'>>\"\n \n get_source=\"<bound method BuiltinImporter.get_source of <class '_frozen_importlib.BuiltinImporter'>>\"\n \n is_package=\"<bound method BuiltinImporter.is_package of <class '_frozen_importlib.BuiltinImporter'>>\"\n \n load_module=\"<bound method _load_module_shim of <class '_frozen_importlib.BuiltinImporter'>>\"\n \n def module_repr(*args,**kw):\n  ''\n\n\n  \n  pass\n__spec__=\"ModuleSpec(name='faulthandler', loader=<class '_frozen_importlib.BuiltinImporter'>, origin='built-in')\"\n\ndef _fatal_error(*args,**kw):\n ''\n pass\n \ndef _fatal_error_c_thread(*args,**kw):\n ''\n pass\n \ndef _raise_exception(*args,**kw):\n ''\n pass\n \ndef _read_null(*args,**kw):\n ''\n pass\n \ndef _sigabrt(*args,**kw):\n ''\n pass\n \ndef _sigfpe(*args,**kw):\n ''\n pass\n \ndef _sigsegv(*args,**kw):\n ''\n pass\n \ndef cancel_dump_traceback_later(*args,**kw):\n ''\n pass\n \ndef disable(*args,**kw):\n ''\n pass\n \ndef dump_traceback(*args,**kw):\n ''\n pass\n \ndef dump_traceback_later(*args,**kw):\n ''\n \n pass\n \ndef enable(*args,**kw):\n ''\n pass\n \ndef is_enabled(*args,**kw):\n ''\n pass\n", []], "fnmatch": [".py", "''\n\n\n\n\n\n\n\n\n\n\nimport os\nimport posixpath\nimport re\nimport functools\n\n__all__=[\"filter\",\"fnmatch\",\"fnmatchcase\",\"translate\"]\n\ndef fnmatch(name,pat):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n \n name=os.path.normcase(name)\n pat=os.path.normcase(pat)\n return fnmatchcase(name,pat)\n \n@functools.lru_cache(maxsize=256,typed=True )\ndef _compile_pattern(pat):\n if isinstance(pat,bytes):\n  pat_str=str(pat,'ISO-8859-1')\n  res_str=translate(pat_str)\n  res=bytes(res_str,'ISO-8859-1')\n else :\n  res=translate(pat)\n return re.compile(res).match\n \ndef filter(names,pat):\n ''\n result=[]\n pat=os.path.normcase(pat)\n match=_compile_pattern(pat)\n if os.path is posixpath:\n \n  for name in names:\n   if match(name):\n    result.append(name)\n else :\n  for name in names:\n   if match(os.path.normcase(name)):\n    result.append(name)\n return result\n \ndef fnmatchcase(name,pat):\n ''\n\n\n\n \n match=_compile_pattern(pat)\n return match(name)is not None\n \n \ndef translate(pat):\n ''\n\n\n \n \n i,n=0,len(pat)\n res=''\n while i <n:\n  c=pat[i]\n  i=i+1\n  if c =='*':\n   res=res+'.*'\n  elif c =='?':\n   res=res+'.'\n  elif c =='[':\n   j=i\n   if j <n and pat[j]=='!':\n    j=j+1\n   if j <n and pat[j]==']':\n    j=j+1\n   while j <n and pat[j]!=']':\n    j=j+1\n   if j >=n:\n    res=res+'\\\\['\n   else :\n    stuff=pat[i:j]\n    if '--'not in stuff:\n     stuff=stuff.replace('\\\\',r'\\\\')\n    else :\n     chunks=[]\n     k=i+2 if pat[i]=='!'else i+1\n     while True :\n      k=pat.find('-',k,j)\n      if k <0:\n       break\n      chunks.append(pat[i:k])\n      i=k+1\n      k=k+3\n     chunks.append(pat[i:j])\n     \n     \n     stuff='-'.join(s.replace('\\\\',r'\\\\').replace('-',r'\\-')\n     for s in chunks)\n     \n    stuff=re.sub(r'([&~|])',r'\\\\\\1',stuff)\n    i=j+1\n    if stuff[0]=='!':\n     stuff='^'+stuff[1:]\n    elif stuff[0]in ('^','['):\n     stuff='\\\\'+stuff\n    res='%s[%s]'%(res,stuff)\n  else :\n   res=res+re.escape(c)\n return r'(?s:%s)\\Z'%res\n", ["functools", "os", "posixpath", "re"]], "formatter": [".py", "''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nimport sys\nimport warnings\nwarnings.warn('the formatter module is deprecated',DeprecationWarning,\nstacklevel=2)\n\n\nAS_IS=None\n\n\nclass NullFormatter:\n ''\n\n\n\n\n\n\n\n \n \n def __init__(self,writer=None ):\n  if writer is None :\n   writer=NullWriter()\n  self.writer=writer\n def end_paragraph(self,blankline):pass\n def add_line_break(self):pass\n def add_hor_rule(self,*args,**kw):pass\n def add_label_data(self,format,counter,blankline=None ):pass\n def add_flowing_data(self,data):pass\n def add_literal_data(self,data):pass\n def flush_softspace(self):pass\n def push_alignment(self,align):pass\n def pop_alignment(self):pass\n def push_font(self,x):pass\n def pop_font(self):pass\n def push_margin(self,margin):pass\n def pop_margin(self):pass\n def set_spacing(self,spacing):pass\n def push_style(self,*styles):pass\n def pop_style(self,n=1):pass\n def assert_line_data(self,flag=1):pass\n \n \nclass AbstractFormatter:\n ''\n\n\n\n\n\n \n \n \n \n \n \n \n def __init__(self,writer):\n  self.writer=writer\n  self.align=None\n  self.align_stack=[]\n  self.font_stack=[]\n  self.margin_stack=[]\n  self.spacing=None\n  self.style_stack=[]\n  self.nospace=1\n  self.softspace=0\n  self.para_end=1\n  self.parskip=0\n  self.hard_break=1\n  self.have_label=0\n  \n def end_paragraph(self,blankline):\n  if not self.hard_break:\n   self.writer.send_line_break()\n   self.have_label=0\n  if self.parskip <blankline and not self.have_label:\n   self.writer.send_paragraph(blankline -self.parskip)\n   self.parskip=blankline\n   self.have_label=0\n  self.hard_break=self.nospace=self.para_end=1\n  self.softspace=0\n  \n def add_line_break(self):\n  if not (self.hard_break or self.para_end):\n   self.writer.send_line_break()\n   self.have_label=self.parskip=0\n  self.hard_break=self.nospace=1\n  self.softspace=0\n  \n def add_hor_rule(self,*args,**kw):\n  if not self.hard_break:\n   self.writer.send_line_break()\n  self.writer.send_hor_rule(*args,**kw)\n  self.hard_break=self.nospace=1\n  self.have_label=self.para_end=self.softspace=self.parskip=0\n  \n def add_label_data(self,format,counter,blankline=None ):\n  if self.have_label or not self.hard_break:\n   self.writer.send_line_break()\n  if not self.para_end:\n   self.writer.send_paragraph((blankline and 1)or 0)\n  if isinstance(format,str):\n   self.writer.send_label_data(self.format_counter(format,counter))\n  else :\n   self.writer.send_label_data(format)\n  self.nospace=self.have_label=self.hard_break=self.para_end=1\n  self.softspace=self.parskip=0\n  \n def format_counter(self,format,counter):\n  label=''\n  for c in format:\n   if c =='1':\n    label=label+('%d'%counter)\n   elif c in 'aA':\n    if counter >0:\n     label=label+self.format_letter(c,counter)\n   elif c in 'iI':\n    if counter >0:\n     label=label+self.format_roman(c,counter)\n   else :\n    label=label+c\n  return label\n  \n def format_letter(self,case,counter):\n  label=''\n  while counter >0:\n   counter,x=divmod(counter -1,26)\n   \n   \n   \n   s=chr(ord(case)+x)\n   label=s+label\n  return label\n  \n def format_roman(self,case,counter):\n  ones=['i','x','c','m']\n  fives=['v','l','d']\n  label,index='',0\n  \n  while counter >0:\n   counter,x=divmod(counter,10)\n   if x ==9:\n    label=ones[index]+ones[index+1]+label\n   elif x ==4:\n    label=ones[index]+fives[index]+label\n   else :\n    if x >=5:\n     s=fives[index]\n     x=x -5\n    else :\n     s=''\n    s=s+ones[index]*x\n    label=s+label\n   index=index+1\n  if case =='I':\n   return label.upper()\n  return label\n  \n def add_flowing_data(self,data):\n  if not data:return\n  prespace=data[:1].isspace()\n  postspace=data[-1:].isspace()\n  data=\" \".join(data.split())\n  if self.nospace and not data:\n   return\n  elif prespace or self.softspace:\n   if not data:\n    if not self.nospace:\n     self.softspace=1\n     self.parskip=0\n    return\n   if not self.nospace:\n    data=' '+data\n  self.hard_break=self.nospace=self.para_end=\\\n  self.parskip=self.have_label=0\n  self.softspace=postspace\n  self.writer.send_flowing_data(data)\n  \n def add_literal_data(self,data):\n  if not data:return\n  if self.softspace:\n   self.writer.send_flowing_data(\" \")\n  self.hard_break=data[-1:]=='\\n'\n  self.nospace=self.para_end=self.softspace=\\\n  self.parskip=self.have_label=0\n  self.writer.send_literal_data(data)\n  \n def flush_softspace(self):\n  if self.softspace:\n   self.hard_break=self.para_end=self.parskip=\\\n   self.have_label=self.softspace=0\n   self.nospace=1\n   self.writer.send_flowing_data(' ')\n   \n def push_alignment(self,align):\n  if align and align !=self.align:\n   self.writer.new_alignment(align)\n   self.align=align\n   self.align_stack.append(align)\n  else :\n   self.align_stack.append(self.align)\n   \n def pop_alignment(self):\n  if self.align_stack:\n   del self.align_stack[-1]\n  if self.align_stack:\n   self.align=align=self.align_stack[-1]\n   self.writer.new_alignment(align)\n  else :\n   self.align=None\n   self.writer.new_alignment(None )\n   \n def push_font(self,font):\n  size,i,b,tt=font\n  if self.softspace:\n   self.hard_break=self.para_end=self.softspace=0\n   self.nospace=1\n   self.writer.send_flowing_data(' ')\n  if self.font_stack:\n   csize,ci,cb,ctt=self.font_stack[-1]\n   if size is AS_IS:size=csize\n   if i is AS_IS:i=ci\n   if b is AS_IS:b=cb\n   if tt is AS_IS:tt=ctt\n  font=(size,i,b,tt)\n  self.font_stack.append(font)\n  self.writer.new_font(font)\n  \n def pop_font(self):\n  if self.font_stack:\n   del self.font_stack[-1]\n  if self.font_stack:\n   font=self.font_stack[-1]\n  else :\n   font=None\n  self.writer.new_font(font)\n  \n def push_margin(self,margin):\n  self.margin_stack.append(margin)\n  fstack=[m for m in self.margin_stack if m]\n  if not margin and fstack:\n   margin=fstack[-1]\n  self.writer.new_margin(margin,len(fstack))\n  \n def pop_margin(self):\n  if self.margin_stack:\n   del self.margin_stack[-1]\n  fstack=[m for m in self.margin_stack if m]\n  if fstack:\n   margin=fstack[-1]\n  else :\n   margin=None\n  self.writer.new_margin(margin,len(fstack))\n  \n def set_spacing(self,spacing):\n  self.spacing=spacing\n  self.writer.new_spacing(spacing)\n  \n def push_style(self,*styles):\n  if self.softspace:\n   self.hard_break=self.para_end=self.softspace=0\n   self.nospace=1\n   self.writer.send_flowing_data(' ')\n  for style in styles:\n   self.style_stack.append(style)\n  self.writer.new_styles(tuple(self.style_stack))\n  \n def pop_style(self,n=1):\n  del self.style_stack[-n:]\n  self.writer.new_styles(tuple(self.style_stack))\n  \n def assert_line_data(self,flag=1):\n  self.nospace=self.hard_break=not flag\n  self.para_end=self.parskip=self.have_label=0\n  \n  \nclass NullWriter:\n ''\n\n\n\n\n\n \n def __init__(self):pass\n def flush(self):pass\n def new_alignment(self,align):pass\n def new_font(self,font):pass\n def new_margin(self,margin,level):pass\n def new_spacing(self,spacing):pass\n def new_styles(self,styles):pass\n def send_paragraph(self,blankline):pass\n def send_line_break(self):pass\n def send_hor_rule(self,*args,**kw):pass\n def send_label_data(self,data):pass\n def send_flowing_data(self,data):pass\n def send_literal_data(self,data):pass\n \n \nclass AbstractWriter(NullWriter):\n ''\n\n\n\n\n \n \n def new_alignment(self,align):\n  print(\"new_alignment(%r)\"%(align,))\n  \n def new_font(self,font):\n  print(\"new_font(%r)\"%(font,))\n  \n def new_margin(self,margin,level):\n  print(\"new_margin(%r, %d)\"%(margin,level))\n  \n def new_spacing(self,spacing):\n  print(\"new_spacing(%r)\"%(spacing,))\n  \n def new_styles(self,styles):\n  print(\"new_styles(%r)\"%(styles,))\n  \n def send_paragraph(self,blankline):\n  print(\"send_paragraph(%r)\"%(blankline,))\n  \n def send_line_break(self):\n  print(\"send_line_break()\")\n  \n def send_hor_rule(self,*args,**kw):\n  print(\"send_hor_rule()\")\n  \n def send_label_data(self,data):\n  print(\"send_label_data(%r)\"%(data,))\n  \n def send_flowing_data(self,data):\n  print(\"send_flowing_data(%r)\"%(data,))\n  \n def send_literal_data(self,data):\n  print(\"send_literal_data(%r)\"%(data,))\n  \n  \nclass DumbWriter(NullWriter):\n ''\n\n\n\n\n\n \n \n def __init__(self,file=None ,maxcol=72):\n  self.file=file or sys.stdout\n  self.maxcol=maxcol\n  NullWriter.__init__(self)\n  self.reset()\n  \n def reset(self):\n  self.col=0\n  self.atbreak=0\n  \n def send_paragraph(self,blankline):\n  self.file.write('\\n'*blankline)\n  self.col=0\n  self.atbreak=0\n  \n def send_line_break(self):\n  self.file.write('\\n')\n  self.col=0\n  self.atbreak=0\n  \n def send_hor_rule(self,*args,**kw):\n  self.file.write('\\n')\n  self.file.write('-'*self.maxcol)\n  self.file.write('\\n')\n  self.col=0\n  self.atbreak=0\n  \n def send_literal_data(self,data):\n  self.file.write(data)\n  i=data.rfind('\\n')\n  if i >=0:\n   self.col=0\n   data=data[i+1:]\n  data=data.expandtabs()\n  self.col=self.col+len(data)\n  self.atbreak=0\n  \n def send_flowing_data(self,data):\n  if not data:return\n  atbreak=self.atbreak or data[0].isspace()\n  col=self.col\n  maxcol=self.maxcol\n  write=self.file.write\n  for word in data.split():\n   if atbreak:\n    if col+len(word)>=maxcol:\n     write('\\n')\n     col=0\n    else :\n     write(' ')\n     col=col+1\n   write(word)\n   col=col+len(word)\n   atbreak=1\n  self.col=col\n  self.atbreak=data[-1].isspace()\n  \n  \ndef test(file=None ):\n w=DumbWriter()\n f=AbstractFormatter(w)\n if file is not None :\n  fp=open(file)\n elif sys.argv[1:]:\n  fp=open(sys.argv[1])\n else :\n  fp=sys.stdin\n try :\n  for line in fp:\n   if line =='\\n':\n    f.end_paragraph(1)\n   else :\n    f.add_flowing_data(line)\n finally :\n  if fp is not sys.stdin:\n   fp.close()\n f.end_paragraph(0)\n \n \nif __name__ =='__main__':\n test()\n", ["sys", "warnings"]], "fractions": [".py", "\n\n\n\"\"\"Fraction, infinite-precision, real numbers.\"\"\"\n\nfrom decimal import Decimal\nimport math\nimport numbers\nimport operator\nimport re\nimport sys\n\n__all__=['Fraction','gcd']\n\n\n\ndef gcd(a,b):\n ''\n\n\n\n \n import warnings\n warnings.warn('fractions.gcd() is deprecated. Use math.gcd() instead.',\n DeprecationWarning,2)\n if type(a)is int is type(b):\n  if (b or a)<0:\n   return -math.gcd(a,b)\n  return math.gcd(a,b)\n return _gcd(a,b)\n \ndef _gcd(a,b):\n\n while b:\n  a,b=b,a %b\n return a\n \n \n \n_PyHASH_MODULUS=sys.hash_info.modulus\n\n\n_PyHASH_INF=sys.hash_info.inf\n\n_RATIONAL_FORMAT=re.compile(r\"\"\"\n    \\A\\s*                      # optional whitespace at the start, then\n    (?P<sign>[-+]?)            # an optional sign, then\n    (?=\\d|\\.\\d)                # lookahead for digit or .digit\n    (?P<num>\\d*)               # numerator (possibly empty)\n    (?:                        # followed by\n       (?:/(?P<denom>\\d+))?    # an optional denominator\n    |                          # or\n       (?:\\.(?P<decimal>\\d*))? # an optional fractional part\n       (?:E(?P<exp>[-+]?\\d+))? # and optional exponent\n    )\n    \\s*\\Z                      # and optional whitespace to finish\n\"\"\",re.VERBOSE |re.IGNORECASE)\n\n\nclass Fraction(numbers.Rational):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n __slots__=('_numerator','_denominator')\n \n \n def __new__(cls,numerator=0,denominator=None ,*,_normalize=True ):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  self=super(Fraction,cls).__new__(cls)\n  \n  if denominator is None :\n   if type(numerator)is int:\n    self._numerator=numerator\n    self._denominator=1\n    return self\n    \n   elif isinstance(numerator,numbers.Rational):\n    self._numerator=numerator.numerator\n    self._denominator=numerator.denominator\n    return self\n    \n   elif isinstance(numerator,(float,Decimal)):\n   \n    self._numerator,self._denominator=numerator.as_integer_ratio()\n    return self\n    \n   elif isinstance(numerator,str):\n   \n    m=_RATIONAL_FORMAT.match(numerator)\n    if m is None :\n     raise ValueError('Invalid literal for Fraction: %r'%\n     numerator)\n    numerator=int(m.group('num')or '0')\n    denom=m.group('denom')\n    if denom:\n     denominator=int(denom)\n    else :\n     denominator=1\n     decimal=m.group('decimal')\n     if decimal:\n      scale=10 **len(decimal)\n      numerator=numerator *scale+int(decimal)\n      denominator *=scale\n     exp=m.group('exp')\n     if exp:\n      exp=int(exp)\n      if exp >=0:\n       numerator *=10 **exp\n      else :\n       denominator *=10 **-exp\n    if m.group('sign')=='-':\n     numerator=-numerator\n     \n   else :\n    raise TypeError(\"argument should be a string \"\n    \"or a Rational instance\")\n    \n  elif type(numerator)is int is type(denominator):\n   pass\n   \n  elif (isinstance(numerator,numbers.Rational)and\n  isinstance(denominator,numbers.Rational)):\n   numerator,denominator=(\n   numerator.numerator *denominator.denominator,\n   denominator.numerator *numerator.denominator\n   )\n  else :\n   raise TypeError(\"both arguments should be \"\n   \"Rational instances\")\n   \n  if denominator ==0:\n   raise ZeroDivisionError('Fraction(%s, 0)'%numerator)\n  if _normalize:\n   if type(numerator)is int is type(denominator):\n   \n    g=math.gcd(numerator,denominator)\n    if denominator <0:\n     g=-g\n   else :\n    g=_gcd(numerator,denominator)\n   numerator //=g\n   denominator //=g\n  self._numerator=numerator\n  self._denominator=denominator\n  return self\n  \n @classmethod\n def from_float(cls,f):\n  ''\n\n\n\n  \n  if isinstance(f,numbers.Integral):\n   return cls(f)\n  elif not isinstance(f,float):\n   raise TypeError(\"%s.from_float() only takes floats, not %r (%s)\"%\n   (cls.__name__,f,type(f).__name__))\n  return cls(*f.as_integer_ratio())\n  \n @classmethod\n def from_decimal(cls,dec):\n  ''\n  from decimal import Decimal\n  if isinstance(dec,numbers.Integral):\n   dec=Decimal(int(dec))\n  elif not isinstance(dec,Decimal):\n   raise TypeError(\n   \"%s.from_decimal() only takes Decimals, not %r (%s)\"%\n   (cls.__name__,dec,type(dec).__name__))\n  return cls(*dec.as_integer_ratio())\n  \n def limit_denominator(self,max_denominator=1000000):\n  ''\n\n\n\n\n\n\n\n\n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  if max_denominator <1:\n   raise ValueError(\"max_denominator should be at least 1\")\n  if self._denominator <=max_denominator:\n   return Fraction(self)\n   \n  p0,q0,p1,q1=0,1,1,0\n  n,d=self._numerator,self._denominator\n  while True :\n   a=n //d\n   q2=q0+a *q1\n   if q2 >max_denominator:\n    break\n   p0,q0,p1,q1=p1,q1,p0+a *p1,q2\n   n,d=d,n -a *d\n   \n  k=(max_denominator -q0)//q1\n  bound1=Fraction(p0+k *p1,q0+k *q1)\n  bound2=Fraction(p1,q1)\n  if abs(bound2 -self)<=abs(bound1 -self):\n   return bound2\n  else :\n   return bound1\n   \n @property\n def numerator(a):\n  return a._numerator\n  \n @property\n def denominator(a):\n  return a._denominator\n  \n def __repr__(self):\n  ''\n  return '%s(%s, %s)'%(self.__class__.__name__,\n  self._numerator,self._denominator)\n  \n def __str__(self):\n  ''\n  if self._denominator ==1:\n   return str(self._numerator)\n  else :\n   return '%s/%s'%(self._numerator,self._denominator)\n   \n def _operator_fallbacks(monomorphic_operator,fallback_operator):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  def forward(a,b):\n   if isinstance(b,(int,Fraction)):\n    return monomorphic_operator(a,b)\n   elif isinstance(b,float):\n    return fallback_operator(float(a),b)\n   elif isinstance(b,complex):\n    return fallback_operator(complex(a),b)\n   else :\n    return NotImplemented\n  forward.__name__='__'+fallback_operator.__name__+'__'\n  forward.__doc__=monomorphic_operator.__doc__\n  \n  def reverse(b,a):\n   if isinstance(a,numbers.Rational):\n   \n    return monomorphic_operator(a,b)\n   elif isinstance(a,numbers.Real):\n    return fallback_operator(float(a),float(b))\n   elif isinstance(a,numbers.Complex):\n    return fallback_operator(complex(a),complex(b))\n   else :\n    return NotImplemented\n  reverse.__name__='__r'+fallback_operator.__name__+'__'\n  reverse.__doc__=monomorphic_operator.__doc__\n  \n  return forward,reverse\n  \n def _add(a,b):\n  ''\n  da,db=a.denominator,b.denominator\n  return Fraction(a.numerator *db+b.numerator *da,\n  da *db)\n  \n __add__,__radd__=_operator_fallbacks(_add,operator.add)\n \n def _sub(a,b):\n  ''\n  da,db=a.denominator,b.denominator\n  return Fraction(a.numerator *db -b.numerator *da,\n  da *db)\n  \n __sub__,__rsub__=_operator_fallbacks(_sub,operator.sub)\n \n def _mul(a,b):\n  ''\n  return Fraction(a.numerator *b.numerator,a.denominator *b.denominator)\n  \n __mul__,__rmul__=_operator_fallbacks(_mul,operator.mul)\n \n def _div(a,b):\n  ''\n  return Fraction(a.numerator *b.denominator,\n  a.denominator *b.numerator)\n  \n __truediv__,__rtruediv__=_operator_fallbacks(_div,operator.truediv)\n \n def __floordiv__(a,b):\n  ''\n  return math.floor(a /b)\n  \n def __rfloordiv__(b,a):\n  ''\n  return math.floor(a /b)\n  \n def __mod__(a,b):\n  ''\n  div=a //b\n  return a -b *div\n  \n def __rmod__(b,a):\n  ''\n  div=a //b\n  return a -b *div\n  \n def __pow__(a,b):\n  ''\n\n\n\n\n\n  \n  if isinstance(b,numbers.Rational):\n   if b.denominator ==1:\n    power=b.numerator\n    if power >=0:\n     return Fraction(a._numerator **power,\n     a._denominator **power,\n     _normalize=False )\n    elif a._numerator >=0:\n     return Fraction(a._denominator **-power,\n     a._numerator **-power,\n     _normalize=False )\n    else :\n     return Fraction((-a._denominator)**-power,\n     (-a._numerator)**-power,\n     _normalize=False )\n   else :\n   \n   \n    return float(a)**float(b)\n  else :\n   return float(a)**b\n   \n def __rpow__(b,a):\n  ''\n  if b._denominator ==1 and b._numerator >=0:\n  \n   return a **b._numerator\n   \n  if isinstance(a,numbers.Rational):\n   return Fraction(a.numerator,a.denominator)**b\n   \n  if b._denominator ==1:\n   return a **b._numerator\n   \n  return a **float(b)\n  \n def __pos__(a):\n  ''\n  return Fraction(a._numerator,a._denominator,_normalize=False )\n  \n def __neg__(a):\n  ''\n  return Fraction(-a._numerator,a._denominator,_normalize=False )\n  \n def __abs__(a):\n  ''\n  return Fraction(abs(a._numerator),a._denominator,_normalize=False )\n  \n def __trunc__(a):\n  ''\n  if a._numerator <0:\n   return -(-a._numerator //a._denominator)\n  else :\n   return a._numerator //a._denominator\n   \n def __floor__(a):\n  ''\n  return a.numerator //a.denominator\n  \n def __ceil__(a):\n  ''\n  \n  return -(-a.numerator //a.denominator)\n  \n def __round__(self,ndigits=None ):\n  ''\n\n\n  \n  if ndigits is None :\n   floor,remainder=divmod(self.numerator,self.denominator)\n   if remainder *2 <self.denominator:\n    return floor\n   elif remainder *2 >self.denominator:\n    return floor+1\n    \n   elif floor %2 ==0:\n    return floor\n   else :\n    return floor+1\n  shift=10 **abs(ndigits)\n  \n  \n  \n  if ndigits >0:\n   return Fraction(round(self *shift),shift)\n  else :\n   return Fraction(round(self /shift)*shift)\n   \n def __hash__(self):\n  ''\n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  dinv=pow(self._denominator,_PyHASH_MODULUS -2,_PyHASH_MODULUS)\n  if not dinv:\n   hash_=_PyHASH_INF\n  else :\n   hash_=abs(self._numerator)*dinv %_PyHASH_MODULUS\n  result=hash_ if self >=0 else -hash_\n  return -2 if result ==-1 else result\n  \n def __eq__(a,b):\n  ''\n  if type(b)is int:\n   return a._numerator ==b and a._denominator ==1\n  if isinstance(b,numbers.Rational):\n   return (a._numerator ==b.numerator and\n   a._denominator ==b.denominator)\n  if isinstance(b,numbers.Complex)and b.imag ==0:\n   b=b.real\n  if isinstance(b,float):\n   if math.isnan(b)or math.isinf(b):\n   \n   \n    return 0.0 ==b\n   else :\n    return a ==a.from_float(b)\n  else :\n  \n  \n   return NotImplemented\n   \n def _richcmp(self,other,op):\n  ''\n\n\n\n\n\n\n\n  \n  \n  if isinstance(other,numbers.Rational):\n   return op(self._numerator *other.denominator,\n   self._denominator *other.numerator)\n  if isinstance(other,float):\n   if math.isnan(other)or math.isinf(other):\n    return op(0.0,other)\n   else :\n    return op(self,self.from_float(other))\n  else :\n   return NotImplemented\n   \n def __lt__(a,b):\n  ''\n  return a._richcmp(b,operator.lt)\n  \n def __gt__(a,b):\n  ''\n  return a._richcmp(b,operator.gt)\n  \n def __le__(a,b):\n  ''\n  return a._richcmp(b,operator.le)\n  \n def __ge__(a,b):\n  ''\n  return a._richcmp(b,operator.ge)\n  \n def __bool__(a):\n  ''\n  return a._numerator !=0\n  \n  \n  \n def __reduce__(self):\n  return (self.__class__,(str(self),))\n  \n def __copy__(self):\n  if type(self)==Fraction:\n   return self\n  return self.__class__(self._numerator,self._denominator)\n  \n def __deepcopy__(self,memo):\n  if type(self)==Fraction:\n   return self\n  return self.__class__(self._numerator,self._denominator)\n", ["decimal", "math", "numbers", "operator", "re", "sys", "warnings"]], "functools": [".py", "''\n\n\n\n\n\n\n\n\n\n\n__all__=['update_wrapper','wraps','WRAPPER_ASSIGNMENTS','WRAPPER_UPDATES',\n'total_ordering','cmp_to_key','lru_cache','reduce','partial',\n'partialmethod','singledispatch']\n\ntry :\n from _functools import reduce\nexcept ImportError:\n pass\nfrom abc import get_cache_token\nfrom collections import namedtuple\n\nfrom reprlib import recursive_repr\nfrom _thread import RLock\n\n\n\n\n\n\n\n\n\nWRAPPER_ASSIGNMENTS=('__module__','__name__','__qualname__','__doc__',\n'__annotations__')\nWRAPPER_UPDATES=('__dict__',)\ndef update_wrapper(wrapper,\nwrapped,\nassigned=WRAPPER_ASSIGNMENTS,\nupdated=WRAPPER_UPDATES):\n ''\n\n\n\n\n\n\n\n\n\n \n for attr in assigned:\n  try :\n   value=getattr(wrapped,attr)\n  except AttributeError:\n   pass\n  else :\n   setattr(wrapper,attr,value)\n for attr in updated:\n  getattr(wrapper,attr).update(getattr(wrapped,attr,{}))\n  \n  \n wrapper.__wrapped__=wrapped\n \n return wrapper\n \ndef wraps(wrapped,\nassigned=WRAPPER_ASSIGNMENTS,\nupdated=WRAPPER_UPDATES):\n ''\n\n\n\n\n\n\n \n return partial(update_wrapper,wrapped=wrapped,\n assigned=assigned,updated=updated)\n \n \n \n \n \n \n \n \n \n \n \ndef _gt_from_lt(self,other,NotImplemented=NotImplemented):\n ''\n op_result=self.__lt__(other)\n if op_result is NotImplemented:\n  return op_result\n return not op_result and self !=other\n \ndef _le_from_lt(self,other,NotImplemented=NotImplemented):\n ''\n op_result=self.__lt__(other)\n return op_result or self ==other\n \ndef _ge_from_lt(self,other,NotImplemented=NotImplemented):\n ''\n op_result=self.__lt__(other)\n if op_result is NotImplemented:\n  return op_result\n return not op_result\n \ndef _ge_from_le(self,other,NotImplemented=NotImplemented):\n ''\n op_result=self.__le__(other)\n if op_result is NotImplemented:\n  return op_result\n return not op_result or self ==other\n \ndef _lt_from_le(self,other,NotImplemented=NotImplemented):\n ''\n op_result=self.__le__(other)\n if op_result is NotImplemented:\n  return op_result\n return op_result and self !=other\n \ndef _gt_from_le(self,other,NotImplemented=NotImplemented):\n ''\n op_result=self.__le__(other)\n if op_result is NotImplemented:\n  return op_result\n return not op_result\n \ndef _lt_from_gt(self,other,NotImplemented=NotImplemented):\n ''\n op_result=self.__gt__(other)\n if op_result is NotImplemented:\n  return op_result\n return not op_result and self !=other\n \ndef _ge_from_gt(self,other,NotImplemented=NotImplemented):\n ''\n op_result=self.__gt__(other)\n return op_result or self ==other\n \ndef _le_from_gt(self,other,NotImplemented=NotImplemented):\n ''\n op_result=self.__gt__(other)\n if op_result is NotImplemented:\n  return op_result\n return not op_result\n \ndef _le_from_ge(self,other,NotImplemented=NotImplemented):\n ''\n op_result=self.__ge__(other)\n if op_result is NotImplemented:\n  return op_result\n return not op_result or self ==other\n \ndef _gt_from_ge(self,other,NotImplemented=NotImplemented):\n ''\n op_result=self.__ge__(other)\n if op_result is NotImplemented:\n  return op_result\n return op_result and self !=other\n \ndef _lt_from_ge(self,other,NotImplemented=NotImplemented):\n ''\n op_result=self.__ge__(other)\n if op_result is NotImplemented:\n  return op_result\n return not op_result\n \n_convert={\n'__lt__':[('__gt__',_gt_from_lt),\n('__le__',_le_from_lt),\n('__ge__',_ge_from_lt)],\n'__le__':[('__ge__',_ge_from_le),\n('__lt__',_lt_from_le),\n('__gt__',_gt_from_le)],\n'__gt__':[('__lt__',_lt_from_gt),\n('__ge__',_ge_from_gt),\n('__le__',_le_from_gt)],\n'__ge__':[('__le__',_le_from_ge),\n('__gt__',_gt_from_ge),\n('__lt__',_lt_from_ge)]\n}\n\ndef total_ordering(cls):\n ''\n \n roots={op for op in _convert if getattr(cls,op,None )is not getattr(object,op,None )}\n if not roots:\n  raise ValueError('must define at least one ordering operation: < > <= >=')\n root=max(roots)\n for opname,opfunc in _convert[root]:\n  if opname not in roots:\n   opfunc.__name__=opname\n   setattr(cls,opname,opfunc)\n return cls\n \n \n \n \n \n \ndef cmp_to_key(mycmp):\n ''\n class K(object):\n  __slots__=['obj']\n  def __init__(self,obj):\n   self.obj=obj\n  def __lt__(self,other):\n   return mycmp(self.obj,other.obj)<0\n  def __gt__(self,other):\n   return mycmp(self.obj,other.obj)>0\n  def __eq__(self,other):\n   return mycmp(self.obj,other.obj)==0\n  def __le__(self,other):\n   return mycmp(self.obj,other.obj)<=0\n  def __ge__(self,other):\n   return mycmp(self.obj,other.obj)>=0\n  __hash__=None\n return K\n \ntry :\n from _functools import cmp_to_key\nexcept ImportError:\n pass\n \n \n \n \n \n \n \nclass partial:\n ''\n\n \n \n __slots__=\"func\",\"args\",\"keywords\",\"__dict__\",\"__weakref__\"\n \n def __new__(*args,**keywords):\n  if not args:\n   raise TypeError(\"descriptor '__new__' of partial needs an argument\")\n  if len(args)<2:\n   raise TypeError(\"type 'partial' takes at least one argument\")\n  cls,func,*args=args\n  if not callable(func):\n   raise TypeError(\"the first argument must be callable\")\n  args=tuple(args)\n  \n  if hasattr(func,\"func\"):\n   args=func.args+args\n   tmpkw=func.keywords.copy()\n   tmpkw.update(keywords)\n   keywords=tmpkw\n   del tmpkw\n   func=func.func\n   \n  self=super(partial,cls).__new__(cls)\n  \n  self.func=func\n  self.args=args\n  self.keywords=keywords\n  return self\n  \n def __call__(*args,**keywords):\n  if not args:\n   raise TypeError(\"descriptor '__call__' of partial needs an argument\")\n  self,*args=args\n  newkeywords=self.keywords.copy()\n  newkeywords.update(keywords)\n  return self.func(*self.args,*args,**newkeywords)\n  \n @recursive_repr()\n def __repr__(self):\n  qualname=type(self).__qualname__\n  args=[repr(self.func)]\n  args.extend(repr(x)for x in self.args)\n  args.extend(f\"{k}={v!r}\"for (k,v)in self.keywords.items())\n  if type(self).__module__ ==\"functools\":\n   return f\"functools.{qualname}({', '.join(args)})\"\n  return f\"{qualname}({', '.join(args)})\"\n  \n def __reduce__(self):\n  return type(self),(self.func,),(self.func,self.args,\n  self.keywords or None ,self.__dict__ or None )\n  \n def __setstate__(self,state):\n  if not isinstance(state,tuple):\n   raise TypeError(\"argument to __setstate__ must be a tuple\")\n  if len(state)!=4:\n   raise TypeError(f\"expected 4 items in state, got {len(state)}\")\n  func,args,kwds,namespace=state\n  if (not callable(func)or not isinstance(args,tuple)or\n  (kwds is not None and not isinstance(kwds,dict))or\n  (namespace is not None and not isinstance(namespace,dict))):\n   raise TypeError(\"invalid partial state\")\n   \n  args=tuple(args)\n  if kwds is None :\n   kwds={}\n  elif type(kwds)is not dict:\n   kwds=dict(kwds)\n  if namespace is None :\n   namespace={}\n   \n  self.__dict__=namespace\n  self.func=func\n  self.args=args\n  self.keywords=kwds\n  \ntry :\n from _functools import partial\nexcept ImportError:\n pass\n \n \nclass partialmethod(object):\n ''\n\n\n\n\n \n \n def __init__(self,func,*args,**keywords):\n  if not callable(func)and not hasattr(func,\"__get__\"):\n   raise TypeError(\"{!r} is not callable or a descriptor\"\n   .format(func))\n   \n   \n   \n  if isinstance(func,partialmethod):\n  \n  \n  \n   self.func=func.func\n   self.args=func.args+args\n   self.keywords=func.keywords.copy()\n   self.keywords.update(keywords)\n  else :\n   self.func=func\n   self.args=args\n   self.keywords=keywords\n   \n def __repr__(self):\n  args=\", \".join(map(repr,self.args))\n  keywords=\", \".join(\"{}={!r}\".format(k,v)\n  for k,v in self.keywords.items())\n  format_string=\"{module}.{cls}({func}, {args}, {keywords})\"\n  return format_string.format(module=self.__class__.__module__,\n  cls=self.__class__.__qualname__,\n  func=self.func,\n  args=args,\n  keywords=keywords)\n  \n def _make_unbound_method(self):\n  def _method(*args,**keywords):\n   call_keywords=self.keywords.copy()\n   call_keywords.update(keywords)\n   cls_or_self,*rest=args\n   call_args=(cls_or_self,)+self.args+tuple(rest)\n   return self.func(*call_args,**call_keywords)\n  _method.__isabstractmethod__=self.__isabstractmethod__\n  _method._partialmethod=self\n  return _method\n  \n def __get__(self,obj,cls):\n  get=getattr(self.func,\"__get__\",None )\n  result=None\n  if get is not None :\n   new_func=get(obj,cls)\n   if new_func is not self.func:\n   \n   \n    result=partial(new_func,*self.args,**self.keywords)\n    try :\n     result.__self__=new_func.__self__\n    except AttributeError:\n     pass\n  if result is None :\n  \n  \n   result=self._make_unbound_method().__get__(obj,cls)\n  return result\n  \n @property\n def __isabstractmethod__(self):\n  return getattr(self.func,\"__isabstractmethod__\",False )\n  \n  \n  \n  \n  \n  \n_CacheInfo=namedtuple(\"CacheInfo\",[\"hits\",\"misses\",\"maxsize\",\"currsize\"])\n\nclass _HashedSeq(list):\n ''\n\n\n\n \n \n __slots__='hashvalue'\n \n def __init__(self,tup,hash=hash):\n  self[:]=tup\n  self.hashvalue=hash(tup)\n  \n def __hash__(self):\n  return self.hashvalue\n  \ndef _make_key(args,kwds,typed,\nkwd_mark=(object(),),\nfasttypes={int,str,frozenset,type(None )},\ntuple=tuple,type=type,len=len):\n ''\n\n\n\n\n\n\n\n\n \n \n \n \n \n key=args\n if kwds:\n  key +=kwd_mark\n  for item in kwds.items():\n   key +=item\n if typed:\n  key +=tuple(type(v)for v in args)\n  if kwds:\n   key +=tuple(type(v)for v in kwds.values())\n elif len(key)==1 and type(key[0])in fasttypes:\n  return key[0]\n return _HashedSeq(key)\n \ndef lru_cache(maxsize=128,typed=False ):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n \n \n \n \n \n \n \n \n if maxsize is not None and not isinstance(maxsize,int):\n  raise TypeError('Expected maxsize to be an integer or None')\n  \n def decorating_function(user_function):\n  wrapper=_lru_cache_wrapper(user_function,maxsize,typed,_CacheInfo)\n  return update_wrapper(wrapper,user_function)\n  \n return decorating_function\n \ndef _lru_cache_wrapper(user_function,maxsize,typed,_CacheInfo):\n\n sentinel=object()\n make_key=_make_key\n PREV,NEXT,KEY,RESULT=0,1,2,3\n \n cache={}\n hits=misses=0\n full=False\n cache_get=cache.get\n cache_len=cache.__len__\n lock=RLock()\n root=[]\n root[:]=[root,root,None ,None ]\n \n if maxsize ==0:\n \n  def wrapper(*args,**kwds):\n  \n   nonlocal misses\n   result=user_function(*args,**kwds)\n   misses +=1\n   return result\n   \n elif maxsize is None :\n \n  def wrapper(*args,**kwds):\n  \n   nonlocal hits,misses\n   key=make_key(args,kwds,typed)\n   result=cache_get(key,sentinel)\n   if result is not sentinel:\n    hits +=1\n    return result\n   result=user_function(*args,**kwds)\n   cache[key]=result\n   misses +=1\n   return result\n   \n else :\n \n  def wrapper(*args,**kwds):\n  \n   nonlocal root,hits,misses,full\n   key=make_key(args,kwds,typed)\n   with lock:\n    link=cache_get(key)\n    if link is not None :\n    \n     link_prev,link_next,_key,result=link\n     link_prev[NEXT]=link_next\n     link_next[PREV]=link_prev\n     last=root[PREV]\n     last[NEXT]=root[PREV]=link\n     link[PREV]=last\n     link[NEXT]=root\n     hits +=1\n     return result\n   result=user_function(*args,**kwds)\n   with lock:\n    if key in cache:\n    \n    \n    \n    \n     pass\n    elif full:\n    \n     oldroot=root\n     oldroot[KEY]=key\n     oldroot[RESULT]=result\n     \n     \n     \n     \n     \n     \n     root=oldroot[NEXT]\n     oldkey=root[KEY]\n     oldresult=root[RESULT]\n     root[KEY]=root[RESULT]=None\n     \n     del cache[oldkey]\n     \n     \n     \n     cache[key]=oldroot\n    else :\n    \n     last=root[PREV]\n     link=[last,root,key,result]\n     last[NEXT]=root[PREV]=cache[key]=link\n     \n     \n     full=(cache_len()>=maxsize)\n    misses +=1\n   return result\n   \n def cache_info():\n  ''\n  with lock:\n   return _CacheInfo(hits,misses,maxsize,cache_len())\n   \n def cache_clear():\n  ''\n  nonlocal hits,misses,full\n  with lock:\n   cache.clear()\n   root[:]=[root,root,None ,None ]\n   hits=misses=0\n   full=False\n   \n wrapper.cache_info=cache_info\n wrapper.cache_clear=cache_clear\n return wrapper\n \ntry :\n from _functools import _lru_cache_wrapper\nexcept ImportError:\n pass\n \n \n \n \n \n \ndef _c3_merge(sequences):\n ''\n\n\n\n \n result=[]\n while True :\n  sequences=[s for s in sequences if s]\n  if not sequences:\n   return result\n  for s1 in sequences:\n   candidate=s1[0]\n   for s2 in sequences:\n    if candidate in s2[1:]:\n     candidate=None\n     break\n   else :\n    break\n  if candidate is None :\n   raise RuntimeError(\"Inconsistent hierarchy\")\n  result.append(candidate)\n  \n  for seq in sequences:\n   if seq[0]==candidate:\n    del seq[0]\n    \ndef _c3_mro(cls,abcs=None ):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n for i,base in enumerate(reversed(cls.__bases__)):\n  if hasattr(base,'__abstractmethods__'):\n   boundary=len(cls.__bases__)-i\n   break\n else :\n  boundary=0\n abcs=list(abcs)if abcs else []\n explicit_bases=list(cls.__bases__[:boundary])\n abstract_bases=[]\n other_bases=list(cls.__bases__[boundary:])\n for base in abcs:\n  if issubclass(cls,base)and not any(\n  issubclass(b,base)for b in cls.__bases__\n  ):\n  \n  \n   abstract_bases.append(base)\n for base in abstract_bases:\n  abcs.remove(base)\n explicit_c3_mros=[_c3_mro(base,abcs=abcs)for base in explicit_bases]\n abstract_c3_mros=[_c3_mro(base,abcs=abcs)for base in abstract_bases]\n other_c3_mros=[_c3_mro(base,abcs=abcs)for base in other_bases]\n return _c3_merge(\n [[cls]]+\n explicit_c3_mros+abstract_c3_mros+other_c3_mros+\n [explicit_bases]+[abstract_bases]+[other_bases]\n )\n \ndef _compose_mro(cls,types):\n ''\n\n\n\n\n \n bases=set(cls.__mro__)\n \n def is_related(typ):\n  return (typ not in bases and hasattr(typ,'__mro__')\n  and issubclass(cls,typ))\n types=[n for n in types if is_related(n)]\n \n \n def is_strict_base(typ):\n  for other in types:\n   if typ !=other and typ in other.__mro__:\n    return True\n  return False\n types=[n for n in types if not is_strict_base(n)]\n \n \n type_set=set(types)\n mro=[]\n for typ in types:\n  found=[]\n  for sub in typ.__subclasses__():\n   if sub not in bases and issubclass(cls,sub):\n    found.append([s for s in sub.__mro__ if s in type_set])\n  if not found:\n   mro.append(typ)\n   continue\n   \n  found.sort(key=len,reverse=True )\n  for sub in found:\n   for subcls in sub:\n    if subcls not in mro:\n     mro.append(subcls)\n return _c3_mro(cls,abcs=mro)\n \ndef _find_impl(cls,registry):\n ''\n\n\n\n\n\n\n\n \n mro=_compose_mro(cls,registry.keys())\n match=None\n for t in mro:\n  if match is not None :\n  \n  \n   if (t in registry and t not in cls.__mro__\n   and match not in cls.__mro__\n   and not issubclass(match,t)):\n    raise RuntimeError(\"Ambiguous dispatch: {} or {}\".format(\n    match,t))\n   break\n  if t in registry:\n   match=t\n return registry.get(match)\n \ndef singledispatch(func):\n ''\n\n\n\n\n\n\n \n \n \n \n import types,weakref\n \n registry={}\n dispatch_cache=weakref.WeakKeyDictionary()\n cache_token=None\n \n def dispatch(cls):\n  ''\n\n\n\n\n  \n  nonlocal cache_token\n  if cache_token is not None :\n   current_token=get_cache_token()\n   if cache_token !=current_token:\n    dispatch_cache.clear()\n    cache_token=current_token\n  try :\n   impl=dispatch_cache[cls]\n  except KeyError:\n   try :\n    impl=registry[cls]\n   except KeyError:\n    impl=_find_impl(cls,registry)\n   dispatch_cache[cls]=impl\n  return impl\n  \n def register(cls,func=None ):\n  ''\n\n\n\n  \n  nonlocal cache_token\n  if func is None :\n   if isinstance(cls,type):\n    return lambda f:register(cls,f)\n   ann=getattr(cls,'__annotations__',{})\n   if not ann:\n    raise TypeError(\n    f\"Invalid first argument to `register()`: {cls!r}. \"\n    f\"Use either `@register(some_class)` or plain `@register` \"\n    f\"on an annotated function.\"\n    )\n   func=cls\n   \n   \n   from typing import get_type_hints\n   argname,cls=next(iter(get_type_hints(func).items()))\n   assert isinstance(cls,type),(\n   f\"Invalid annotation for {argname!r}. {cls!r} is not a class.\"\n   )\n  registry[cls]=func\n  if cache_token is None and hasattr(cls,'__abstractmethods__'):\n   cache_token=get_cache_token()\n  dispatch_cache.clear()\n  return func\n  \n def wrapper(*args,**kw):\n  return dispatch(args[0].__class__)(*args,**kw)\n  \n registry[object]=func\n wrapper.register=register\n wrapper.dispatch=dispatch\n wrapper.registry=types.MappingProxyType(registry)\n wrapper._clear_cache=dispatch_cache.clear\n update_wrapper(wrapper,func)\n return wrapper\n", ["_functools", "_thread", "abc", "collections", "reprlib", "types", "typing", "weakref"]], "gc": [".py", "''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nDEBUG_COLLECTABLE=2\n\nDEBUG_LEAK=38\n\nDEBUG_SAVEALL=32\n\nDEBUG_STATS=1\n\nDEBUG_UNCOLLECTABLE=4\n\nclass __loader__:\n pass\n \ncallbacks=[]\n\ndef collect(*args,**kw):\n ''\n\n\n\n\n\n \n pass\n \ndef disable(*args,**kw):\n ''\n\n \n pass\n \ndef enable(*args,**kw):\n ''\n\n \n pass\n \ngarbage=[]\n\ndef get_count(*args,**kw):\n ''\n\n \n pass\n \ndef get_debug(*args,**kw):\n ''\n\n \n pass\n \ndef get_objects(*args,**kw):\n ''\n\n\n \n pass\n \ndef get_referents(*args,**kw):\n ''\n pass\n \ndef get_referrers(*args,**kw):\n ''\n pass\n \ndef get_threshold(*args,**kw):\n ''\n\n \n pass\n \ndef is_tracked(*args,**kw):\n ''\n\n\n \n pass\n \ndef isenabled(*args,**kw):\n ''\n\n \n pass\n \ndef set_debug(*args,**kw):\n ''\n\n\n\n\n\n\n\n\n\n\n \n pass\n \ndef set_threshold(*args,**kw):\n ''\n\n\n \n pass\n", []], "genericpath": [".py", "''\n\n\n\n\nimport os\nimport stat\n\n__all__=['commonprefix','exists','getatime','getctime','getmtime',\n'getsize','isdir','isfile','samefile','sameopenfile',\n'samestat']\n\n\n\n\ndef exists(path):\n ''\n try :\n  os.stat(path)\n except OSError:\n  return False\n return True\n \n \n \n \ndef isfile(path):\n ''\n try :\n  st=os.stat(path)\n except OSError:\n  return False\n return stat.S_ISREG(st.st_mode)\n \n \n \n \n \ndef isdir(s):\n ''\n try :\n  st=os.stat(s)\n except OSError:\n  return False\n return stat.S_ISDIR(st.st_mode)\n \n \ndef getsize(filename):\n ''\n return os.stat(filename).st_size\n \n \ndef getmtime(filename):\n ''\n return os.stat(filename).st_mtime\n \n \ndef getatime(filename):\n ''\n return os.stat(filename).st_atime\n \n \ndef getctime(filename):\n ''\n return os.stat(filename).st_ctime\n \n \n \ndef commonprefix(m):\n ''\n if not m:return ''\n \n \n \n \n if not isinstance(m[0],(list,tuple)):\n  m=tuple(map(os.fspath,m))\n s1=min(m)\n s2=max(m)\n for i,c in enumerate(s1):\n  if c !=s2[i]:\n   return s1[:i]\n return s1\n \n \n \ndef samestat(s1,s2):\n ''\n return (s1.st_ino ==s2.st_ino and\n s1.st_dev ==s2.st_dev)\n \n \n \ndef samefile(f1,f2):\n ''\n s1=os.stat(f1)\n s2=os.stat(f2)\n return samestat(s1,s2)\n \n \n \n \ndef sameopenfile(fp1,fp2):\n ''\n s1=os.fstat(fp1)\n s2=os.fstat(fp2)\n return samestat(s1,s2)\n \n \n \n \n \n \n \n \n \ndef _splitext(p,sep,altsep,extsep):\n ''\n\n\n \n \n \n sepIndex=p.rfind(sep)\n if altsep:\n  altsepIndex=p.rfind(altsep)\n  sepIndex=max(sepIndex,altsepIndex)\n  \n dotIndex=p.rfind(extsep)\n if dotIndex >sepIndex:\n \n  filenameIndex=sepIndex+1\n  while filenameIndex <dotIndex:\n   if p[filenameIndex:filenameIndex+1]!=extsep:\n    return p[:dotIndex],p[dotIndex:]\n   filenameIndex +=1\n   \n return p,p[:0]\n \ndef _check_arg_types(funcname,*args):\n hasstr=hasbytes=False\n for s in args:\n  if isinstance(s,str):\n   hasstr=True\n  elif isinstance(s,bytes):\n   hasbytes=True\n  else :\n   raise TypeError('%s() argument must be str or bytes, not %r'%\n   (funcname,s.__class__.__name__))from None\n if hasstr and hasbytes:\n  raise TypeError(\"Can't mix strings and bytes in path components\")from None\n", ["os", "stat"]], "getopt": [".py", "''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n__all__=[\"GetoptError\",\"error\",\"getopt\",\"gnu_getopt\"]\n\nimport os\ntry :\n from gettext import gettext as _\nexcept ImportError:\n\n def _(s):return s\n \nclass GetoptError(Exception):\n opt=''\n msg=''\n def __init__(self,msg,opt=''):\n  self.msg=msg\n  self.opt=opt\n  Exception.__init__(self,msg,opt)\n  \n def __str__(self):\n  return self.msg\n  \nerror=GetoptError\n\ndef getopt(args,shortopts,longopts=[]):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n opts=[]\n if type(longopts)==type(\"\"):\n  longopts=[longopts]\n else :\n  longopts=list(longopts)\n while args and args[0].startswith('-')and args[0]!='-':\n  if args[0]=='--':\n   args=args[1:]\n   break\n  if args[0].startswith('--'):\n   opts,args=do_longs(opts,args[0][2:],longopts,args[1:])\n  else :\n   opts,args=do_shorts(opts,args[0][1:],shortopts,args[1:])\n   \n return opts,args\n \ndef gnu_getopt(args,shortopts,longopts=[]):\n ''\n\n\n\n\n\n\n\n\n\n\n\n \n \n opts=[]\n prog_args=[]\n if isinstance(longopts,str):\n  longopts=[longopts]\n else :\n  longopts=list(longopts)\n  \n  \n if shortopts.startswith('+'):\n  shortopts=shortopts[1:]\n  all_options_first=True\n elif os.environ.get(\"POSIXLY_CORRECT\"):\n  all_options_first=True\n else :\n  all_options_first=False\n  \n while args:\n  if args[0]=='--':\n   prog_args +=args[1:]\n   break\n   \n  if args[0][:2]=='--':\n   opts,args=do_longs(opts,args[0][2:],longopts,args[1:])\n  elif args[0][:1]=='-'and args[0]!='-':\n   opts,args=do_shorts(opts,args[0][1:],shortopts,args[1:])\n  else :\n   if all_options_first:\n    prog_args +=args\n    break\n   else :\n    prog_args.append(args[0])\n    args=args[1:]\n    \n return opts,prog_args\n \ndef do_longs(opts,opt,longopts,args):\n try :\n  i=opt.index('=')\n except ValueError:\n  optarg=None\n else :\n  opt,optarg=opt[:i],opt[i+1:]\n  \n has_arg,opt=long_has_args(opt,longopts)\n if has_arg:\n  if optarg is None :\n   if not args:\n    raise GetoptError(_('option --%s requires argument')%opt,opt)\n   optarg,args=args[0],args[1:]\n elif optarg is not None :\n  raise GetoptError(_('option --%s must not have an argument')%opt,opt)\n opts.append(('--'+opt,optarg or ''))\n return opts,args\n \n \n \n \ndef long_has_args(opt,longopts):\n possibilities=[o for o in longopts if o.startswith(opt)]\n if not possibilities:\n  raise GetoptError(_('option --%s not recognized')%opt,opt)\n  \n if opt in possibilities:\n  return False ,opt\n elif opt+'='in possibilities:\n  return True ,opt\n  \n if len(possibilities)>1:\n \n \n  raise GetoptError(_('option --%s not a unique prefix')%opt,opt)\n assert len(possibilities)==1\n unique_match=possibilities[0]\n has_arg=unique_match.endswith('=')\n if has_arg:\n  unique_match=unique_match[:-1]\n return has_arg,unique_match\n \ndef do_shorts(opts,optstring,shortopts,args):\n while optstring !='':\n  opt,optstring=optstring[0],optstring[1:]\n  if short_has_arg(opt,shortopts):\n   if optstring =='':\n    if not args:\n     raise GetoptError(_('option -%s requires argument')%opt,\n     opt)\n    optstring,args=args[0],args[1:]\n   optarg,optstring=optstring,''\n  else :\n   optarg=''\n  opts.append(('-'+opt,optarg))\n return opts,args\n \ndef short_has_arg(opt,shortopts):\n for i in range(len(shortopts)):\n  if opt ==shortopts[i]!=':':\n   return shortopts.startswith(':',i+1)\n raise GetoptError(_('option -%s not recognized')%opt,opt)\n \nif __name__ =='__main__':\n import sys\n print(getopt(sys.argv[1:],\"a:b\",[\"alpha=\",\"beta\"]))\n", ["gettext", "os", "sys"]], "gettext": [".py", "''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nimport locale\nimport os\nimport re\nimport sys\n\n\n__all__=['NullTranslations','GNUTranslations','Catalog',\n'find','translation','install','textdomain','bindtextdomain',\n'bind_textdomain_codeset',\n'dgettext','dngettext','gettext','lgettext','ldgettext',\n'ldngettext','lngettext','ngettext',\n]\n\n_default_localedir=os.path.join(sys.base_prefix,'share','locale')\n\n\n\n\n\n\n\n\n\n\n_token_pattern=re.compile(r\"\"\"\n        (?P<WHITESPACES>[ \\t]+)                    | # spaces and horizontal tabs\n        (?P<NUMBER>[0-9]+\\b)                       | # decimal integer\n        (?P<NAME>n\\b)                              | # only n is allowed\n        (?P<PARENTHESIS>[()])                      |\n        (?P<OPERATOR>[-*/%+?:]|[><!]=?|==|&&|\\|\\|) | # !, *, /, %, +, -, <, >,\n                                                     # <=, >=, ==, !=, &&, ||,\n                                                     # ? :\n                                                     # unary and bitwise ops\n                                                     # not allowed\n        (?P<INVALID>\\w+|.)                           # invalid token\n    \"\"\",re.VERBOSE |re.DOTALL)\n\ndef _tokenize(plural):\n for mo in re.finditer(_token_pattern,plural):\n  kind=mo.lastgroup\n  if kind =='WHITESPACES':\n   continue\n  value=mo.group(kind)\n  if kind =='INVALID':\n   raise ValueError('invalid token in plural form: %s'%value)\n  yield value\n yield ''\n \ndef _error(value):\n if value:\n  return ValueError('unexpected token in plural form: %s'%value)\n else :\n  return ValueError('unexpected end of plural form')\n  \n_binary_ops=(\n('||',),\n('&&',),\n('==','!='),\n('<','>','<=','>='),\n('+','-'),\n('*','/','%'),\n)\n_binary_ops={op:i for i,ops in enumerate(_binary_ops,1)for op in ops}\n_c2py_ops={'||':'or','&&':'and','/':'//'}\n\ndef _parse(tokens,priority=-1):\n result=''\n nexttok=next(tokens)\n while nexttok =='!':\n  result +='not '\n  nexttok=next(tokens)\n  \n if nexttok =='(':\n  sub,nexttok=_parse(tokens)\n  result='%s(%s)'%(result,sub)\n  if nexttok !=')':\n   raise ValueError('unbalanced parenthesis in plural form')\n elif nexttok =='n':\n  result='%s%s'%(result,nexttok)\n else :\n  try :\n   value=int(nexttok,10)\n  except ValueError:\n   raise _error(nexttok)from None\n  result='%s%d'%(result,value)\n nexttok=next(tokens)\n \n j=100\n while nexttok in _binary_ops:\n  i=_binary_ops[nexttok]\n  if i <priority:\n   break\n   \n  if i in (3,4)and j in (3,4):\n   result='(%s)'%result\n   \n  op=_c2py_ops.get(nexttok,nexttok)\n  right,nexttok=_parse(tokens,i+1)\n  result='%s %s %s'%(result,op,right)\n  j=i\n if j ==priority ==4:\n  result='(%s)'%result\n  \n if nexttok =='?'and priority <=0:\n  if_true,nexttok=_parse(tokens,0)\n  if nexttok !=':':\n   raise _error(nexttok)\n  if_false,nexttok=_parse(tokens)\n  result='%s if %s else %s'%(if_true,result,if_false)\n  if priority ==0:\n   result='(%s)'%result\n   \n return result,nexttok\n \ndef _as_int(n):\n try :\n  i=round(n)\n except TypeError:\n  raise TypeError('Plural value must be an integer, got %s'%\n  (n.__class__.__name__,))from None\n import warnings\n warnings.warn('Plural value must be an integer, got %s'%\n (n.__class__.__name__,),\n DeprecationWarning,4)\n return n\n \ndef c2py(plural):\n ''\n\n \n \n if len(plural)>1000:\n  raise ValueError('plural form expression is too long')\n try :\n  result,nexttok=_parse(_tokenize(plural))\n  if nexttok:\n   raise _error(nexttok)\n   \n  depth=0\n  for c in result:\n   if c =='(':\n    depth +=1\n    if depth >20:\n    \n    \n     raise ValueError('plural form expression is too complex')\n   elif c ==')':\n    depth -=1\n    \n  ns={'_as_int':_as_int}\n  exec('''if True:\n            def func(n):\n                if not isinstance(n, int):\n                    n = _as_int(n)\n                return int(%s)\n            '''%result,ns)\n  return ns['func']\n except RecursionError:\n \n  raise ValueError('plural form expression is too complex')\n  \n  \ndef _expand_lang(loc):\n loc=locale.normalize(loc)\n COMPONENT_CODESET=1 <<0\n COMPONENT_TERRITORY=1 <<1\n COMPONENT_MODIFIER=1 <<2\n \n mask=0\n pos=loc.find('@')\n if pos >=0:\n  modifier=loc[pos:]\n  loc=loc[:pos]\n  mask |=COMPONENT_MODIFIER\n else :\n  modifier=''\n pos=loc.find('.')\n if pos >=0:\n  codeset=loc[pos:]\n  loc=loc[:pos]\n  mask |=COMPONENT_CODESET\n else :\n  codeset=''\n pos=loc.find('_')\n if pos >=0:\n  territory=loc[pos:]\n  loc=loc[:pos]\n  mask |=COMPONENT_TERRITORY\n else :\n  territory=''\n language=loc\n ret=[]\n for i in range(mask+1):\n  if not (i&~mask):\n   val=language\n   if i&COMPONENT_TERRITORY:val +=territory\n   if i&COMPONENT_CODESET:val +=codeset\n   if i&COMPONENT_MODIFIER:val +=modifier\n   ret.append(val)\n ret.reverse()\n return ret\n \n \n \nclass NullTranslations:\n def __init__(self,fp=None ):\n  self._info={}\n  self._charset=None\n  self._output_charset=None\n  self._fallback=None\n  if fp is not None :\n   self._parse(fp)\n   \n def _parse(self,fp):\n  pass\n  \n def add_fallback(self,fallback):\n  if self._fallback:\n   self._fallback.add_fallback(fallback)\n  else :\n   self._fallback=fallback\n   \n def gettext(self,message):\n  if self._fallback:\n   return self._fallback.gettext(message)\n  return message\n  \n def lgettext(self,message):\n  if self._fallback:\n   return self._fallback.lgettext(message)\n  if self._output_charset:\n   return message.encode(self._output_charset)\n  return message.encode(locale.getpreferredencoding())\n  \n def ngettext(self,msgid1,msgid2,n):\n  if self._fallback:\n   return self._fallback.ngettext(msgid1,msgid2,n)\n  if n ==1:\n   return msgid1\n  else :\n   return msgid2\n   \n def lngettext(self,msgid1,msgid2,n):\n  if self._fallback:\n   return self._fallback.lngettext(msgid1,msgid2,n)\n  if n ==1:\n   tmsg=msgid1\n  else :\n   tmsg=msgid2\n  if self._output_charset:\n   return tmsg.encode(self._output_charset)\n  return tmsg.encode(locale.getpreferredencoding())\n  \n def info(self):\n  return self._info\n  \n def charset(self):\n  return self._charset\n  \n def output_charset(self):\n  return self._output_charset\n  \n def set_output_charset(self,charset):\n  self._output_charset=charset\n  \n def install(self,names=None ):\n  import builtins\n  builtins.__dict__['_']=self.gettext\n  if hasattr(names,\"__contains__\"):\n   if \"gettext\"in names:\n    builtins.__dict__['gettext']=builtins.__dict__['_']\n   if \"ngettext\"in names:\n    builtins.__dict__['ngettext']=self.ngettext\n   if \"lgettext\"in names:\n    builtins.__dict__['lgettext']=self.lgettext\n   if \"lngettext\"in names:\n    builtins.__dict__['lngettext']=self.lngettext\n    \n    \nclass GNUTranslations(NullTranslations):\n\n LE_MAGIC=0x950412de\n BE_MAGIC=0xde120495\n \n \n VERSIONS=(0,1)\n \n def _get_versions(self,version):\n  ''\n  return (version >>16,version&0xffff)\n  \n def _parse(self,fp):\n  ''\n  \n  \n  from struct import unpack\n  filename=getattr(fp,'name','')\n  \n  \n  self._catalog=catalog={}\n  self.plural=lambda n:int(n !=1)\n  buf=fp.read()\n  buflen=len(buf)\n  \n  magic=unpack('<I',buf[:4])[0]\n  if magic ==self.LE_MAGIC:\n   version,msgcount,masteridx,transidx=unpack('<4I',buf[4:20])\n   ii='<II'\n  elif magic ==self.BE_MAGIC:\n   version,msgcount,masteridx,transidx=unpack('>4I',buf[4:20])\n   ii='>II'\n  else :\n   raise OSError(0,'Bad magic number',filename)\n   \n  major_version,minor_version=self._get_versions(version)\n  \n  if major_version not in self.VERSIONS:\n   raise OSError(0,'Bad version number '+str(major_version),filename)\n   \n   \n   \n  for i in range(0,msgcount):\n   mlen,moff=unpack(ii,buf[masteridx:masteridx+8])\n   mend=moff+mlen\n   tlen,toff=unpack(ii,buf[transidx:transidx+8])\n   tend=toff+tlen\n   if mend <buflen and tend <buflen:\n    msg=buf[moff:mend]\n    tmsg=buf[toff:tend]\n   else :\n    raise OSError(0,'File is corrupt',filename)\n    \n   if mlen ==0:\n   \n    lastk=None\n    for b_item in tmsg.split(b'\\n'):\n     item=b_item.decode().strip()\n     if not item:\n      continue\n     k=v=None\n     if ':'in item:\n      k,v=item.split(':',1)\n      k=k.strip().lower()\n      v=v.strip()\n      self._info[k]=v\n      lastk=k\n     elif lastk:\n      self._info[lastk]+='\\n'+item\n     if k =='content-type':\n      self._charset=v.split('charset=')[1]\n     elif k =='plural-forms':\n      v=v.split(';')\n      plural=v[1].split('plural=')[1]\n      self.plural=c2py(plural)\n      \n      \n      \n      \n      \n      \n      \n      \n      \n   charset=self._charset or 'ascii'\n   if b'\\x00'in msg:\n   \n    msgid1,msgid2=msg.split(b'\\x00')\n    tmsg=tmsg.split(b'\\x00')\n    msgid1=str(msgid1,charset)\n    for i,x in enumerate(tmsg):\n     catalog[(msgid1,i)]=str(x,charset)\n   else :\n    catalog[str(msg,charset)]=str(tmsg,charset)\n    \n   masteridx +=8\n   transidx +=8\n   \n def lgettext(self,message):\n  missing=object()\n  tmsg=self._catalog.get(message,missing)\n  if tmsg is missing:\n   if self._fallback:\n    return self._fallback.lgettext(message)\n   tmsg=message\n  if self._output_charset:\n   return tmsg.encode(self._output_charset)\n  return tmsg.encode(locale.getpreferredencoding())\n  \n def lngettext(self,msgid1,msgid2,n):\n  try :\n   tmsg=self._catalog[(msgid1,self.plural(n))]\n  except KeyError:\n   if self._fallback:\n    return self._fallback.lngettext(msgid1,msgid2,n)\n   if n ==1:\n    tmsg=msgid1\n   else :\n    tmsg=msgid2\n  if self._output_charset:\n   return tmsg.encode(self._output_charset)\n  return tmsg.encode(locale.getpreferredencoding())\n  \n def gettext(self,message):\n  missing=object()\n  tmsg=self._catalog.get(message,missing)\n  if tmsg is missing:\n   if self._fallback:\n    return self._fallback.gettext(message)\n   return message\n  return tmsg\n  \n def ngettext(self,msgid1,msgid2,n):\n  try :\n   tmsg=self._catalog[(msgid1,self.plural(n))]\n  except KeyError:\n   if self._fallback:\n    return self._fallback.ngettext(msgid1,msgid2,n)\n   if n ==1:\n    tmsg=msgid1\n   else :\n    tmsg=msgid2\n  return tmsg\n  \n  \n  \ndef find(domain,localedir=None ,languages=None ,all=False ):\n\n if localedir is None :\n  localedir=_default_localedir\n if languages is None :\n  languages=[]\n  for envar in ('LANGUAGE','LC_ALL','LC_MESSAGES','LANG'):\n   val=os.environ.get(envar)\n   if val:\n    languages=val.split(':')\n    break\n  if 'C'not in languages:\n   languages.append('C')\n   \n nelangs=[]\n for lang in languages:\n  for nelang in _expand_lang(lang):\n   if nelang not in nelangs:\n    nelangs.append(nelang)\n    \n if all:\n  result=[]\n else :\n  result=None\n for lang in nelangs:\n  if lang =='C':\n   break\n  mofile=os.path.join(localedir,lang,'LC_MESSAGES','%s.mo'%domain)\n  if os.path.exists(mofile):\n   if all:\n    result.append(mofile)\n   else :\n    return mofile\n return result\n \n \n \n \n_translations={}\n\ndef translation(domain,localedir=None ,languages=None ,\nclass_=None ,fallback=False ,codeset=None ):\n if class_ is None :\n  class_=GNUTranslations\n mofiles=find(domain,localedir,languages,all=True )\n if not mofiles:\n  if fallback:\n   return NullTranslations()\n  from errno import ENOENT\n  raise FileNotFoundError(ENOENT,\n  'No translation file found for domain',domain)\n  \n  \n result=None\n for mofile in mofiles:\n  key=(class_,os.path.abspath(mofile))\n  t=_translations.get(key)\n  if t is None :\n   with open(mofile,'rb')as fp:\n    t=_translations.setdefault(key,class_(fp))\n    \n    \n    \n    \n    \n  import copy\n  t=copy.copy(t)\n  if codeset:\n   t.set_output_charset(codeset)\n  if result is None :\n   result=t\n  else :\n   result.add_fallback(t)\n return result\n \n \ndef install(domain,localedir=None ,codeset=None ,names=None ):\n t=translation(domain,localedir,fallback=True ,codeset=codeset)\n t.install(names)\n \n \n \n \n_localedirs={}\n\n_localecodesets={}\n\n_current_domain='messages'\n\n\ndef textdomain(domain=None ):\n global _current_domain\n if domain is not None :\n  _current_domain=domain\n return _current_domain\n \n \ndef bindtextdomain(domain,localedir=None ):\n global _localedirs\n if localedir is not None :\n  _localedirs[domain]=localedir\n return _localedirs.get(domain,_default_localedir)\n \n \ndef bind_textdomain_codeset(domain,codeset=None ):\n global _localecodesets\n if codeset is not None :\n  _localecodesets[domain]=codeset\n return _localecodesets.get(domain)\n \n \ndef dgettext(domain,message):\n try :\n  t=translation(domain,_localedirs.get(domain,None ),\n  codeset=_localecodesets.get(domain))\n except OSError:\n  return message\n return t.gettext(message)\n \ndef ldgettext(domain,message):\n codeset=_localecodesets.get(domain)\n try :\n  t=translation(domain,_localedirs.get(domain,None ),codeset=codeset)\n except OSError:\n  return message.encode(codeset or locale.getpreferredencoding())\n return t.lgettext(message)\n \ndef dngettext(domain,msgid1,msgid2,n):\n try :\n  t=translation(domain,_localedirs.get(domain,None ),\n  codeset=_localecodesets.get(domain))\n except OSError:\n  if n ==1:\n   return msgid1\n  else :\n   return msgid2\n return t.ngettext(msgid1,msgid2,n)\n \ndef ldngettext(domain,msgid1,msgid2,n):\n codeset=_localecodesets.get(domain)\n try :\n  t=translation(domain,_localedirs.get(domain,None ),codeset=codeset)\n except OSError:\n  if n ==1:\n   tmsg=msgid1\n  else :\n   tmsg=msgid2\n  return tmsg.encode(codeset or locale.getpreferredencoding())\n return t.lngettext(msgid1,msgid2,n)\n \ndef gettext(message):\n return dgettext(_current_domain,message)\n \ndef lgettext(message):\n return ldgettext(_current_domain,message)\n \ndef ngettext(msgid1,msgid2,n):\n return dngettext(_current_domain,msgid1,msgid2,n)\n \ndef lngettext(msgid1,msgid2,n):\n return ldngettext(_current_domain,msgid1,msgid2,n)\n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \nCatalog=translation\n", ["builtins", "copy", "errno", "locale", "os", "re", "struct", "sys", "warnings"]], "glob": [".py", "''\n\nimport os\nimport re\nimport fnmatch\n\n__all__=[\"glob\",\"iglob\",\"escape\"]\n\ndef glob(pathname,*,recursive=False ):\n ''\n\n\n\n\n\n\n\n\n \n return list(iglob(pathname,recursive=recursive))\n \ndef iglob(pathname,*,recursive=False ):\n ''\n\n\n\n\n\n\n\n\n \n it=_iglob(pathname,recursive,False )\n if recursive and _isrecursive(pathname):\n  s=next(it)\n  assert not s\n return it\n \ndef _iglob(pathname,recursive,dironly):\n dirname,basename=os.path.split(pathname)\n if not has_magic(pathname):\n  assert not dironly\n  if basename:\n   if os.path.lexists(pathname):\n    yield pathname\n  else :\n  \n   if os.path.isdir(dirname):\n    yield pathname\n  return\n if not dirname:\n  if recursive and _isrecursive(basename):\n   yield from _glob2(dirname,basename,dironly)\n  else :\n   yield from _glob1(dirname,basename,dironly)\n  return\n  \n  \n  \n if dirname !=pathname and has_magic(dirname):\n  dirs=_iglob(dirname,recursive,True )\n else :\n  dirs=[dirname]\n if has_magic(basename):\n  if recursive and _isrecursive(basename):\n   glob_in_dir=_glob2\n  else :\n   glob_in_dir=_glob1\n else :\n  glob_in_dir=_glob0\n for dirname in dirs:\n  for name in glob_in_dir(dirname,basename,dironly):\n   yield os.path.join(dirname,name)\n   \n   \n   \n   \n   \ndef _glob1(dirname,pattern,dironly):\n names=list(_iterdir(dirname,dironly))\n if not _ishidden(pattern):\n  names=(x for x in names if not _ishidden(x))\n return fnmatch.filter(names,pattern)\n \ndef _glob0(dirname,basename,dironly):\n if not basename:\n \n \n  if os.path.isdir(dirname):\n   return [basename]\n else :\n  if os.path.lexists(os.path.join(dirname,basename)):\n   return [basename]\n return []\n \n \n \ndef glob0(dirname,pattern):\n return _glob0(dirname,pattern,False )\n \ndef glob1(dirname,pattern):\n return _glob1(dirname,pattern,False )\n \n \n \n \ndef _glob2(dirname,pattern,dironly):\n assert _isrecursive(pattern)\n yield pattern[:0]\n yield from _rlistdir(dirname,dironly)\n \n \n \ndef _iterdir(dirname,dironly):\n if not dirname:\n  if isinstance(dirname,bytes):\n   dirname=bytes(os.curdir,'ASCII')\n  else :\n   dirname=os.curdir\n try :\n  with os.scandir(dirname)as it:\n   for entry in it:\n    try :\n     if not dironly or entry.is_dir():\n      yield entry.name\n    except OSError:\n     pass\n except OSError:\n  return\n  \n  \ndef _rlistdir(dirname,dironly):\n names=list(_iterdir(dirname,dironly))\n for x in names:\n  if not _ishidden(x):\n   yield x\n   path=os.path.join(dirname,x)if dirname else x\n   for y in _rlistdir(path,dironly):\n    yield os.path.join(x,y)\n    \n    \nmagic_check=re.compile('([*?[])')\nmagic_check_bytes=re.compile(b'([*?[])')\n\ndef has_magic(s):\n if isinstance(s,bytes):\n  match=magic_check_bytes.search(s)\n else :\n  match=magic_check.search(s)\n return match is not None\n \ndef _ishidden(path):\n return path[0]in ('.',b'.'[0])\n \ndef _isrecursive(pattern):\n if isinstance(pattern,bytes):\n  return pattern ==b'**'\n else :\n  return pattern =='**'\n  \ndef escape(pathname):\n ''\n \n \n \n drive,pathname=os.path.splitdrive(pathname)\n if isinstance(pathname,bytes):\n  pathname=magic_check_bytes.sub(br'[\\1]',pathname)\n else :\n  pathname=magic_check.sub(r'[\\1]',pathname)\n return drive+pathname\n", ["fnmatch", "os", "re"]], "heapq": [".py", "''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n__about__=\"\"\"Heap queues\n\n[explanation by Fran\u00e7ois Pinard]\n\nHeaps are arrays for which a[k] <= a[2*k+1] and a[k] <= a[2*k+2] for\nall k, counting elements from 0.  For the sake of comparison,\nnon-existing elements are considered to be infinite.  The interesting\nproperty of a heap is that a[0] is always its smallest element.\n\nThe strange invariant above is meant to be an efficient memory\nrepresentation for a tournament.  The numbers below are `k', not a[k]:\n\n                                   0\n\n                  1                                 2\n\n          3               4                5               6\n\n      7       8       9       10      11      12      13      14\n\n    15 16   17 18   19 20   21 22   23 24   25 26   27 28   29 30\n\n\nIn the tree above, each cell `k' is topping `2*k+1' and `2*k+2'.  In\na usual binary tournament we see in sports, each cell is the winner\nover the two cells it tops, and we can trace the winner down the tree\nto see all opponents s/he had.  However, in many computer applications\nof such tournaments, we do not need to trace the history of a winner.\nTo be more memory efficient, when a winner is promoted, we try to\nreplace it by something else at a lower level, and the rule becomes\nthat a cell and the two cells it tops contain three different items,\nbut the top cell \"wins\" over the two topped cells.\n\nIf this heap invariant is protected at all time, index 0 is clearly\nthe overall winner.  The simplest algorithmic way to remove it and\nfind the \"next\" winner is to move some loser (let's say cell 30 in the\ndiagram above) into the 0 position, and then percolate this new 0 down\nthe tree, exchanging values, until the invariant is re-established.\nThis is clearly logarithmic on the total number of items in the tree.\nBy iterating over all items, you get an O(n ln n) sort.\n\nA nice feature of this sort is that you can efficiently insert new\nitems while the sort is going on, provided that the inserted items are\nnot \"better\" than the last 0'th element you extracted.  This is\nespecially useful in simulation contexts, where the tree holds all\nincoming events, and the \"win\" condition means the smallest scheduled\ntime.  When an event schedule other events for execution, they are\nscheduled into the future, so they can easily go into the heap.  So, a\nheap is a good structure for implementing schedulers (this is what I\nused for my MIDI sequencer :-).\n\nVarious structures for implementing schedulers have been extensively\nstudied, and heaps are good for this, as they are reasonably speedy,\nthe speed is almost constant, and the worst case is not much different\nthan the average case.  However, there are other representations which\nare more efficient overall, yet the worst cases might be terrible.\n\nHeaps are also very useful in big disk sorts.  You most probably all\nknow that a big sort implies producing \"runs\" (which are pre-sorted\nsequences, which size is usually related to the amount of CPU memory),\nfollowed by a merging passes for these runs, which merging is often\nvery cleverly organised[1].  It is very important that the initial\nsort produces the longest runs possible.  Tournaments are a good way\nto that.  If, using all the memory available to hold a tournament, you\nreplace and percolate items that happen to fit the current run, you'll\nproduce runs which are twice the size of the memory for random input,\nand much better for input fuzzily ordered.\n\nMoreover, if you output the 0'th item on disk and get an input which\nmay not fit in the current tournament (because the value \"wins\" over\nthe last output value), it cannot fit in the heap, so the size of the\nheap decreases.  The freed memory could be cleverly reused immediately\nfor progressively building a second heap, which grows at exactly the\nsame rate the first heap is melting.  When the first heap completely\nvanishes, you switch heaps and start a new run.  Clever and quite\neffective!\n\nIn a word, heaps are useful memory structures to know.  I use them in\na few applications, and I think it is good to keep a `heap' module\naround. :-)\n\n--------------------\n[1] The disk balancing algorithms which are current, nowadays, are\nmore annoying than clever, and this is a consequence of the seeking\ncapabilities of the disks.  On devices which cannot seek, like big\ntape drives, the story was quite different, and one had to be very\nclever to ensure (far in advance) that each tape movement will be the\nmost effective possible (that is, will best participate at\n\"progressing\" the merge).  Some tapes were even able to read\nbackwards, and this was also used to avoid the rewinding time.\nBelieve me, real good tape sorts were quite spectacular to watch!\nFrom all times, sorting has always been a Great Art! :-)\n\"\"\"\n\n__all__=['heappush','heappop','heapify','heapreplace','merge',\n'nlargest','nsmallest','heappushpop']\n\ndef heappush(heap,item):\n ''\n heap.append(item)\n _siftdown(heap,0,len(heap)-1)\n \ndef heappop(heap):\n ''\n lastelt=heap.pop()\n if heap:\n  returnitem=heap[0]\n  heap[0]=lastelt\n  _siftup(heap,0)\n  return returnitem\n return lastelt\n \ndef heapreplace(heap,item):\n ''\n\n\n\n\n\n\n\n\n \n returnitem=heap[0]\n heap[0]=item\n _siftup(heap,0)\n return returnitem\n \ndef heappushpop(heap,item):\n ''\n if heap and heap[0]<item:\n  item,heap[0]=heap[0],item\n  _siftup(heap,0)\n return item\n \ndef heapify(x):\n ''\n n=len(x)\n \n \n \n \n \n for i in reversed(range(n //2)):\n  _siftup(x,i)\n  \ndef _heappop_max(heap):\n ''\n lastelt=heap.pop()\n if heap:\n  returnitem=heap[0]\n  heap[0]=lastelt\n  _siftup_max(heap,0)\n  return returnitem\n return lastelt\n \ndef _heapreplace_max(heap,item):\n ''\n returnitem=heap[0]\n heap[0]=item\n _siftup_max(heap,0)\n return returnitem\n \ndef _heapify_max(x):\n ''\n n=len(x)\n for i in reversed(range(n //2)):\n  _siftup_max(x,i)\n  \n  \n  \n  \ndef _siftdown(heap,startpos,pos):\n newitem=heap[pos]\n \n \n while pos >startpos:\n  parentpos=(pos -1)>>1\n  parent=heap[parentpos]\n  if newitem <parent:\n   heap[pos]=parent\n   pos=parentpos\n   continue\n  break\n heap[pos]=newitem\n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \ndef _siftup(heap,pos):\n endpos=len(heap)\n startpos=pos\n newitem=heap[pos]\n \n childpos=2 *pos+1\n while childpos <endpos:\n \n  rightpos=childpos+1\n  if rightpos <endpos and not heap[childpos]<heap[rightpos]:\n   childpos=rightpos\n   \n  heap[pos]=heap[childpos]\n  pos=childpos\n  childpos=2 *pos+1\n  \n  \n heap[pos]=newitem\n _siftdown(heap,startpos,pos)\n \ndef _siftdown_max(heap,startpos,pos):\n ''\n newitem=heap[pos]\n \n \n while pos >startpos:\n  parentpos=(pos -1)>>1\n  parent=heap[parentpos]\n  if parent <newitem:\n   heap[pos]=parent\n   pos=parentpos\n   continue\n  break\n heap[pos]=newitem\n \ndef _siftup_max(heap,pos):\n ''\n endpos=len(heap)\n startpos=pos\n newitem=heap[pos]\n \n childpos=2 *pos+1\n while childpos <endpos:\n \n  rightpos=childpos+1\n  if rightpos <endpos and not heap[rightpos]<heap[childpos]:\n   childpos=rightpos\n   \n  heap[pos]=heap[childpos]\n  pos=childpos\n  childpos=2 *pos+1\n  \n  \n heap[pos]=newitem\n _siftdown_max(heap,startpos,pos)\n \ndef merge(*iterables,key=None ,reverse=False ):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n h=[]\n h_append=h.append\n \n if reverse:\n  _heapify=_heapify_max\n  _heappop=_heappop_max\n  _heapreplace=_heapreplace_max\n  direction=-1\n else :\n  _heapify=heapify\n  _heappop=heappop\n  _heapreplace=heapreplace\n  direction=1\n  \n if key is None :\n  for order,it in enumerate(map(iter,iterables)):\n   try :\n    next=it.__next__\n    h_append([next(),order *direction,next])\n   except StopIteration:\n    pass\n  _heapify(h)\n  while len(h)>1:\n   try :\n    while True :\n     value,order,next=s=h[0]\n     yield value\n     s[0]=next()\n     _heapreplace(h,s)\n   except StopIteration:\n    _heappop(h)\n  if h:\n  \n   value,order,next=h[0]\n   yield value\n   yield from next.__self__\n  return\n  \n for order,it in enumerate(map(iter,iterables)):\n  try :\n   next=it.__next__\n   value=next()\n   h_append([key(value),order *direction,value,next])\n  except StopIteration:\n   pass\n _heapify(h)\n while len(h)>1:\n  try :\n   while True :\n    key_value,order,value,next=s=h[0]\n    yield value\n    value=next()\n    s[0]=key(value)\n    s[2]=value\n    _heapreplace(h,s)\n  except StopIteration:\n   _heappop(h)\n if h:\n  key_value,order,value,next=h[0]\n  yield value\n  yield from next.__self__\n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \ndef nsmallest(n,iterable,key=None ):\n ''\n\n\n \n \n \n if n ==1:\n  it=iter(iterable)\n  sentinel=object()\n  if key is None :\n   result=min(it,default=sentinel)\n  else :\n   result=min(it,default=sentinel,key=key)\n  return []if result is sentinel else [result]\n  \n  \n try :\n  size=len(iterable)\n except (TypeError,AttributeError):\n  pass\n else :\n  if n >=size:\n   return sorted(iterable,key=key)[:n]\n   \n   \n if key is None :\n  it=iter(iterable)\n  \n  \n  result=[(elem,i)for i,elem in zip(range(n),it)]\n  if not result:\n   return result\n  _heapify_max(result)\n  top=result[0][0]\n  order=n\n  _heapreplace=_heapreplace_max\n  for elem in it:\n   if elem <top:\n    _heapreplace(result,(elem,order))\n    top,_order=result[0]\n    order +=1\n  result.sort()\n  return [elem for (elem,order)in result]\n  \n  \n it=iter(iterable)\n result=[(key(elem),i,elem)for i,elem in zip(range(n),it)]\n if not result:\n  return result\n _heapify_max(result)\n top=result[0][0]\n order=n\n _heapreplace=_heapreplace_max\n for elem in it:\n  k=key(elem)\n  if k <top:\n   _heapreplace(result,(k,order,elem))\n   top,_order,_elem=result[0]\n   order +=1\n result.sort()\n return [elem for (k,order,elem)in result]\n \ndef nlargest(n,iterable,key=None ):\n ''\n\n\n \n \n \n if n ==1:\n  it=iter(iterable)\n  sentinel=object()\n  if key is None :\n   result=max(it,default=sentinel)\n  else :\n   result=max(it,default=sentinel,key=key)\n  return []if result is sentinel else [result]\n  \n  \n try :\n  size=len(iterable)\n except (TypeError,AttributeError):\n  pass\n else :\n  if n >=size:\n   return sorted(iterable,key=key,reverse=True )[:n]\n   \n   \n if key is None :\n  it=iter(iterable)\n  result=[(elem,i)for i,elem in zip(range(0,-n,-1),it)]\n  if not result:\n   return result\n  heapify(result)\n  top=result[0][0]\n  order=-n\n  _heapreplace=heapreplace\n  for elem in it:\n   if top <elem:\n    _heapreplace(result,(elem,order))\n    top,_order=result[0]\n    order -=1\n  result.sort(reverse=True )\n  return [elem for (elem,order)in result]\n  \n  \n it=iter(iterable)\n result=[(key(elem),i,elem)for i,elem in zip(range(0,-n,-1),it)]\n if not result:\n  return result\n heapify(result)\n top=result[0][0]\n order=-n\n _heapreplace=heapreplace\n for elem in it:\n  k=key(elem)\n  if top <k:\n   _heapreplace(result,(k,order,elem))\n   top,_order,_elem=result[0]\n   order -=1\n result.sort(reverse=True )\n return [elem for (k,order,elem)in result]\n \n \n \n \n\"\"\"\ntry:\n    from _heapq import *\nexcept ImportError:\n    pass\ntry:\n    from _heapq import _heapreplace_max\nexcept ImportError:\n    pass\ntry:\n    from _heapq import _heapify_max\nexcept ImportError:\n    pass\ntry:\n    from _heapq import _heappop_max\nexcept ImportError:\n    pass\n\"\"\"\n\nif __name__ ==\"__main__\":\n\n import doctest\n print(doctest.testmod())\n", ["doctest"]], "imp": [".py", "''\n\n\n\n\n\n\n\nfrom _imp import (lock_held,acquire_lock,release_lock,\nget_frozen_object,is_frozen_package,\ninit_frozen,is_builtin,is_frozen,\n_fix_co_filename)\ntry :\n from _imp import create_dynamic\nexcept ImportError:\n\n create_dynamic=None\n \nfrom importlib._bootstrap import _ERR_MSG,_exec,_load,_builtin_from_name\nfrom importlib._bootstrap_external import SourcelessFileLoader\n\nfrom importlib import machinery\nfrom importlib import util\nimport importlib\nimport os\nimport sys\nimport tokenize\nimport types\nimport warnings\n\nwarnings.warn(\"the imp module is deprecated in favour of importlib; \"\n\"see the module's documentation for alternative uses\",\nDeprecationWarning,stacklevel=2)\n\n\nSEARCH_ERROR=0\nPY_SOURCE=1\nPY_COMPILED=2\nC_EXTENSION=3\nPY_RESOURCE=4\nPKG_DIRECTORY=5\nC_BUILTIN=6\nPY_FROZEN=7\nPY_CODERESOURCE=8\nIMP_HOOK=9\n\n\ndef new_module(name):\n ''\n\n\n\n\n\n \n return types.ModuleType(name)\n \n \ndef get_magic():\n ''\n\n\n \n return util.MAGIC_NUMBER\n \n \ndef get_tag():\n ''\n return sys.implementation.cache_tag\n \n \ndef cache_from_source(path,debug_override=None ):\n ''\n\n\n\n\n\n\n\n\n\n\n\n \n with warnings.catch_warnings():\n  warnings.simplefilter('ignore')\n  return util.cache_from_source(path,debug_override)\n  \n  \ndef source_from_cache(path):\n ''\n\n\n\n\n\n\n\n\n \n return util.source_from_cache(path)\n \n \ndef get_suffixes():\n ''\n extensions=[(s,'rb',C_EXTENSION)for s in machinery.EXTENSION_SUFFIXES]\n source=[(s,'r',PY_SOURCE)for s in machinery.SOURCE_SUFFIXES]\n bytecode=[(s,'rb',PY_COMPILED)for s in machinery.BYTECODE_SUFFIXES]\n \n return extensions+source+bytecode\n \n \nclass NullImporter:\n\n ''\n\n\n\n \n \n def __init__(self,path):\n  if path =='':\n   raise ImportError('empty pathname',path='')\n  elif os.path.isdir(path):\n   raise ImportError('existing directory',path=path)\n   \n def find_module(self,fullname):\n  ''\n  return None\n  \n  \nclass _HackedGetData:\n\n ''\n \n \n def __init__(self,fullname,path,file=None ):\n  super().__init__(fullname,path)\n  self.file=file\n  \n def get_data(self,path):\n  ''\n  if self.file and path ==self.path:\n   if not self.file.closed:\n    file=self.file\n   else :\n    self.file=file=open(self.path,'r')\n    \n   with file:\n   \n   \n   \n   \n   \n    return file.read()\n  else :\n   return super().get_data(path)\n   \n   \nclass _LoadSourceCompatibility(_HackedGetData,machinery.SourceFileLoader):\n\n ''\n \n \ndef load_source(name,pathname,file=None ):\n loader=_LoadSourceCompatibility(name,pathname,file)\n spec=util.spec_from_file_location(name,pathname,loader=loader)\n if name in sys.modules:\n  module=_exec(spec,sys.modules[name])\n else :\n  module=_load(spec)\n  \n  \n module.__loader__=machinery.SourceFileLoader(name,pathname)\n module.__spec__.loader=module.__loader__\n return module\n \n \nclass _LoadCompiledCompatibility(_HackedGetData,SourcelessFileLoader):\n\n ''\n \n \ndef load_compiled(name,pathname,file=None ):\n ''\n loader=_LoadCompiledCompatibility(name,pathname,file)\n spec=util.spec_from_file_location(name,pathname,loader=loader)\n if name in sys.modules:\n  module=_exec(spec,sys.modules[name])\n else :\n  module=_load(spec)\n  \n  \n module.__loader__=SourcelessFileLoader(name,pathname)\n module.__spec__.loader=module.__loader__\n return module\n \n \ndef load_package(name,path):\n ''\n if os.path.isdir(path):\n  extensions=(machinery.SOURCE_SUFFIXES[:]+\n  machinery.BYTECODE_SUFFIXES[:])\n  for extension in extensions:\n   init_path=os.path.join(path,'__init__'+extension)\n   if os.path.exists(init_path):\n    path=init_path\n    break\n  else :\n   raise ValueError('{!r} is not a package'.format(path))\n spec=util.spec_from_file_location(name,path,\n submodule_search_locations=[])\n if name in sys.modules:\n  return _exec(spec,sys.modules[name])\n else :\n  return _load(spec)\n  \n  \ndef load_module(name,file,filename,details):\n ''\n\n\n\n\n\n \n suffix,mode,type_=details\n if mode and (not mode.startswith(('r','U'))or '+'in mode):\n  raise ValueError('invalid file open mode {!r}'.format(mode))\n elif file is None and type_ in {PY_SOURCE,PY_COMPILED}:\n  msg='file object required for import (type code {})'.format(type_)\n  raise ValueError(msg)\n elif type_ ==PY_SOURCE:\n  return load_source(name,filename,file)\n elif type_ ==PY_COMPILED:\n  return load_compiled(name,filename,file)\n elif type_ ==C_EXTENSION and load_dynamic is not None :\n  if file is None :\n   with open(filename,'rb')as opened_file:\n    return load_dynamic(name,filename,opened_file)\n  else :\n   return load_dynamic(name,filename,file)\n elif type_ ==PKG_DIRECTORY:\n  return load_package(name,filename)\n elif type_ ==C_BUILTIN:\n  return init_builtin(name)\n elif type_ ==PY_FROZEN:\n  return init_frozen(name)\n else :\n  msg=\"Don't know how to import {} (type code {})\".format(name,type_)\n  raise ImportError(msg,name=name)\n  \n  \ndef find_module(name,path=None ):\n ''\n\n\n\n\n\n\n\n\n \n if not isinstance(name,str):\n  raise TypeError(\"'name' must be a str, not {}\".format(type(name)))\n elif not isinstance(path,(type(None ),list)):\n \n  raise RuntimeError(\"'path' must be None or a list, \"\n  \"not {}\".format(type(path)))\n  \n if path is None :\n  if is_builtin(name):\n   return None ,None ,('','',C_BUILTIN)\n  elif is_frozen(name):\n   return None ,None ,('','',PY_FROZEN)\n  else :\n   path=sys.path\n   \n for entry in path:\n  package_directory=os.path.join(entry,name)\n  for suffix in ['.py',machinery.BYTECODE_SUFFIXES[0]]:\n   package_file_name='__init__'+suffix\n   file_path=os.path.join(package_directory,package_file_name)\n   if os.path.isfile(file_path):\n    return None ,package_directory,('','',PKG_DIRECTORY)\n  for suffix,mode,type_ in get_suffixes():\n   file_name=name+suffix\n   file_path=os.path.join(entry,file_name)\n   if os.path.isfile(file_path):\n    break\n  else :\n   continue\n  break\n else :\n  raise ImportError(_ERR_MSG.format(name),name=name)\n  \n encoding=None\n if 'b'not in mode:\n  with open(file_path,'rb')as file:\n   encoding=tokenize.detect_encoding(file.readline)[0]\n file=open(file_path,mode,encoding=encoding)\n return file,file_path,(suffix,mode,type_)\n \n \ndef reload(module):\n ''\n\n\n\n\n\n \n return importlib.reload(module)\n \n \ndef init_builtin(name):\n ''\n\n\n\n \n try :\n  return _builtin_from_name(name)\n except ImportError:\n  return None\n  \n  \nif create_dynamic:\n def load_dynamic(name,path,file=None ):\n  ''\n\n\n  \n  import importlib.machinery\n  loader=importlib.machinery.ExtensionFileLoader(name,path)\n  \n  \n  \n  spec=importlib.machinery.ModuleSpec(\n  name=name,loader=loader,origin=path)\n  return _load(spec)\n  \nelse :\n load_dynamic=None\n", ["_imp", "importlib", "importlib._bootstrap", "importlib._bootstrap_external", "importlib.machinery", "importlib.util", "os", "sys", "tokenize", "types", "warnings"]], "inspect": [".py", "''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n__author__=('Ka-Ping Yee <ping@lfw.org>',\n'Yury Selivanov <yselivanov@sprymix.com>')\n\nimport abc\nimport dis\nimport collections.abc\nimport enum\nimport importlib.machinery\nimport itertools\nimport linecache\nimport os\nimport re\nimport sys\nimport tokenize\nimport token\nimport types\nimport warnings\nimport functools\nimport builtins\nfrom operator import attrgetter\nfrom collections import namedtuple,OrderedDict\n\n\n\nmod_dict=globals()\nfor k,v in dis.COMPILER_FLAG_NAMES.items():\n mod_dict[\"CO_\"+v]=k\n \n \nTPFLAGS_IS_ABSTRACT=1 <<20\n\n\ndef ismodule(object):\n ''\n\n\n\n\n \n return isinstance(object,types.ModuleType)\n \ndef isclass(object):\n ''\n\n\n\n \n return isinstance(object,type)\n \ndef ismethod(object):\n ''\n\n\n\n\n\n \n return isinstance(object,types.MethodType)\n \ndef ismethoddescriptor(object):\n ''\n\n\n\n\n\n\n\n\n\n\n\n \n if isclass(object)or ismethod(object)or isfunction(object):\n \n  return False\n tp=type(object)\n return hasattr(tp,\"__get__\")and not hasattr(tp,\"__set__\")\n \ndef isdatadescriptor(object):\n ''\n\n\n\n\n\n \n if isclass(object)or ismethod(object)or isfunction(object):\n \n  return False\n tp=type(object)\n return hasattr(tp,\"__set__\")and hasattr(tp,\"__get__\")\n \nif hasattr(types,'MemberDescriptorType'):\n\n def ismemberdescriptor(object):\n  ''\n\n\n  \n  return isinstance(object,types.MemberDescriptorType)\nelse :\n\n def ismemberdescriptor(object):\n  ''\n\n\n  \n  return False\n  \nif hasattr(types,'GetSetDescriptorType'):\n\n def isgetsetdescriptor(object):\n  ''\n\n\n  \n  return isinstance(object,types.GetSetDescriptorType)\nelse :\n\n def isgetsetdescriptor(object):\n  ''\n\n\n  \n  return False\n  \ndef isfunction(object):\n ''\n\n\n\n\n\n\n\n\n \n return isinstance(object,types.FunctionType)\n \ndef isgeneratorfunction(object):\n ''\n\n\n \n return bool((isfunction(object)or ismethod(object))and\n object.__code__.co_flags&CO_GENERATOR)\n \ndef iscoroutinefunction(object):\n ''\n\n\n \n return bool((isfunction(object)or ismethod(object))and\n object.__code__.co_flags&CO_COROUTINE)\n \ndef isasyncgenfunction(object):\n ''\n\n\n\n \n return bool((isfunction(object)or ismethod(object))and\n object.__code__.co_flags&CO_ASYNC_GENERATOR)\n \ndef isasyncgen(object):\n ''\n return isinstance(object,types.AsyncGeneratorType)\n \ndef isgenerator(object):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n \n return isinstance(object,types.GeneratorType)\n \ndef iscoroutine(object):\n ''\n return isinstance(object,types.CoroutineType)\n \ndef isawaitable(object):\n ''\n return (isinstance(object,types.CoroutineType)or\n isinstance(object,types.GeneratorType)and\n bool(object.gi_code.co_flags&CO_ITERABLE_COROUTINE)or\n isinstance(object,collections.abc.Awaitable))\n \ndef istraceback(object):\n ''\n\n\n\n\n\n \n return isinstance(object,types.TracebackType)\n \ndef isframe(object):\n ''\n\n\n\n\n\n\n\n\n\n \n return isinstance(object,types.FrameType)\n \ndef iscode(object):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n return isinstance(object,types.CodeType)\n \ndef isbuiltin(object):\n ''\n\n\n\n\n \n return isinstance(object,types.BuiltinFunctionType)\n \ndef isroutine(object):\n ''\n return (isbuiltin(object)\n or isfunction(object)\n or ismethod(object)\n or ismethoddescriptor(object))\n \ndef isabstract(object):\n ''\n if not isinstance(object,type):\n  return False\n if object.__flags__&TPFLAGS_IS_ABSTRACT:\n  return True\n if not issubclass(type(object),abc.ABCMeta):\n  return False\n if hasattr(object,'__abstractmethods__'):\n \n \n  return False\n  \n  \n for name,value in object.__dict__.items():\n  if getattr(value,\"__isabstractmethod__\",False ):\n   return True\n for base in object.__bases__:\n  for name in getattr(base,\"__abstractmethods__\",()):\n   value=getattr(object,name,None )\n   if getattr(value,\"__isabstractmethod__\",False ):\n    return True\n return False\n \ndef getmembers(object,predicate=None ):\n ''\n \n if isclass(object):\n  mro=(object,)+getmro(object)\n else :\n  mro=()\n results=[]\n processed=set()\n names=dir(object)\n \n \n \n try :\n  for base in object.__bases__:\n   for k,v in base.__dict__.items():\n    if isinstance(v,types.DynamicClassAttribute):\n     names.append(k)\n except AttributeError:\n  pass\n for key in names:\n \n \n \n  try :\n   value=getattr(object,key)\n   \n   if key in processed:\n    raise AttributeError\n  except AttributeError:\n   for base in mro:\n    if key in base.__dict__:\n     value=base.__dict__[key]\n     break\n   else :\n   \n   \n    continue\n  if not predicate or predicate(value):\n   results.append((key,value))\n  processed.add(key)\n results.sort(key=lambda pair:pair[0])\n return results\n \nAttribute=namedtuple('Attribute','name kind defining_class object')\n\ndef classify_class_attrs(cls):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n mro=getmro(cls)\n metamro=getmro(type(cls))\n metamro=tuple(cls for cls in metamro if cls not in (type,object))\n class_bases=(cls,)+mro\n all_bases=class_bases+metamro\n names=dir(cls)\n \n \n \n for base in mro:\n  for k,v in base.__dict__.items():\n   if isinstance(v,types.DynamicClassAttribute):\n    names.append(k)\n result=[]\n processed=set()\n \n for name in names:\n \n \n \n \n \n \n \n \n \n  homecls=None\n  get_obj=None\n  dict_obj=None\n  if name not in processed:\n   try :\n    if name =='__dict__':\n     raise Exception(\"__dict__ is special, don't want the proxy\")\n    get_obj=getattr(cls,name)\n   except Exception as exc:\n    pass\n   else :\n    homecls=getattr(get_obj,\"__objclass__\",homecls)\n    if homecls not in class_bases:\n    \n    \n     homecls=None\n     last_cls=None\n     \n     for srch_cls in class_bases:\n      srch_obj=getattr(srch_cls,name,None )\n      if srch_obj is get_obj:\n       last_cls=srch_cls\n       \n     for srch_cls in metamro:\n      try :\n       srch_obj=srch_cls.__getattr__(cls,name)\n      except AttributeError:\n       continue\n      if srch_obj is get_obj:\n       last_cls=srch_cls\n     if last_cls is not None :\n      homecls=last_cls\n  for base in all_bases:\n   if name in base.__dict__:\n    dict_obj=base.__dict__[name]\n    if homecls not in metamro:\n     homecls=base\n    break\n  if homecls is None :\n  \n  \n   continue\n  obj=get_obj if get_obj is not None else dict_obj\n  \n  if isinstance(dict_obj,(staticmethod,types.BuiltinMethodType)):\n   kind=\"static method\"\n   obj=dict_obj\n  elif isinstance(dict_obj,(classmethod,types.ClassMethodDescriptorType)):\n   kind=\"class method\"\n   obj=dict_obj\n  elif isinstance(dict_obj,property):\n   kind=\"property\"\n   obj=dict_obj\n  elif isroutine(obj):\n   kind=\"method\"\n  else :\n   kind=\"data\"\n  result.append(Attribute(name,kind,homecls,obj))\n  processed.add(name)\n return result\n \n \n \ndef getmro(cls):\n ''\n return cls.__mro__\n \n \n \ndef unwrap(func,*,stop=None ):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n if stop is None :\n  def _is_wrapper(f):\n   return hasattr(f,'__wrapped__')\n else :\n  def _is_wrapper(f):\n   return hasattr(f,'__wrapped__')and not stop(f)\n f=func\n \n \n memo={id(f):f}\n recursion_limit=sys.getrecursionlimit()\n while _is_wrapper(func):\n  func=func.__wrapped__\n  id_func=id(func)\n  if (id_func in memo)or (len(memo)>=recursion_limit):\n   raise ValueError('wrapper loop when unwrapping {!r}'.format(f))\n  memo[id_func]=func\n return func\n \n \ndef indentsize(line):\n ''\n expline=line.expandtabs()\n return len(expline)-len(expline.lstrip())\n \ndef _findclass(func):\n cls=sys.modules.get(func.__module__)\n if cls is None :\n  return None\n for name in func.__qualname__.split('.')[:-1]:\n  cls=getattr(cls,name)\n if not isclass(cls):\n  return None\n return cls\n \ndef _finddoc(obj):\n if isclass(obj):\n  for base in obj.__mro__:\n   if base is not object:\n    try :\n     doc=base.__doc__\n    except AttributeError:\n     continue\n    if doc is not None :\n     return doc\n  return None\n  \n if ismethod(obj):\n  name=obj.__func__.__name__\n  self=obj.__self__\n  if (isclass(self)and\n  getattr(getattr(self,name,None ),'__func__')is obj.__func__):\n  \n   cls=self\n  else :\n   cls=self.__class__\n elif isfunction(obj):\n  name=obj.__name__\n  cls=_findclass(obj)\n  if cls is None or getattr(cls,name)is not obj:\n   return None\n elif isbuiltin(obj):\n  name=obj.__name__\n  self=obj.__self__\n  if (isclass(self)and\n  self.__qualname__+'.'+name ==obj.__qualname__):\n  \n   cls=self\n  else :\n   cls=self.__class__\n   \n elif isinstance(obj,property):\n  func=obj.fget\n  name=func.__name__\n  cls=_findclass(func)\n  if cls is None or getattr(cls,name)is not obj:\n   return None\n elif ismethoddescriptor(obj)or isdatadescriptor(obj):\n  name=obj.__name__\n  cls=obj.__objclass__\n  if getattr(cls,name)is not obj:\n   return None\n else :\n  return None\n  \n for base in cls.__mro__:\n  try :\n   doc=getattr(base,name).__doc__\n  except AttributeError:\n   continue\n  if doc is not None :\n   return doc\n return None\n \ndef getdoc(object):\n ''\n\n\n\n \n try :\n  doc=object.__doc__\n except AttributeError:\n  return None\n if doc is None :\n  try :\n   doc=_finddoc(object)\n  except (AttributeError,TypeError):\n   return None\n if not isinstance(doc,str):\n  return None\n return cleandoc(doc)\n \ndef cleandoc(doc):\n ''\n\n\n \n try :\n  lines=doc.expandtabs().split('\\n')\n except UnicodeError:\n  return None\n else :\n \n  margin=sys.maxsize\n  for line in lines[1:]:\n   content=len(line.lstrip())\n   if content:\n    indent=len(line)-content\n    margin=min(margin,indent)\n    \n  if lines:\n   lines[0]=lines[0].lstrip()\n  if margin <sys.maxsize:\n   for i in range(1,len(lines)):lines[i]=lines[i][margin:]\n   \n  while lines and not lines[-1]:\n   lines.pop()\n  while lines and not lines[0]:\n   lines.pop(0)\n  return '\\n'.join(lines)\n  \ndef getfile(object):\n ''\n if ismodule(object):\n  if getattr(object,'__file__',None ):\n   return object.__file__\n  raise TypeError('{!r} is a built-in module'.format(object))\n if isclass(object):\n  if hasattr(object,'__module__'):\n   object=sys.modules.get(object.__module__)\n   if getattr(object,'__file__',None ):\n    return object.__file__\n  raise TypeError('{!r} is a built-in class'.format(object))\n if ismethod(object):\n  object=object.__func__\n if isfunction(object):\n  object=object.__code__\n if istraceback(object):\n  object=object.tb_frame\n if isframe(object):\n  object=object.f_code\n if iscode(object):\n  return object.co_filename\n raise TypeError('module, class, method, function, traceback, frame, or '\n 'code object was expected, got {}'.format(\n type(object).__name__))\n \ndef getmodulename(path):\n ''\n fname=os.path.basename(path)\n \n suffixes=[(-len(suffix),suffix)\n for suffix in importlib.machinery.all_suffixes()]\n suffixes.sort()\n for neglen,suffix in suffixes:\n  if fname.endswith(suffix):\n   return fname[:neglen]\n return None\n \ndef getsourcefile(object):\n ''\n\n \n filename=getfile(object)\n all_bytecode_suffixes=importlib.machinery.DEBUG_BYTECODE_SUFFIXES[:]\n all_bytecode_suffixes +=importlib.machinery.OPTIMIZED_BYTECODE_SUFFIXES[:]\n if any(filename.endswith(s)for s in all_bytecode_suffixes):\n  filename=(os.path.splitext(filename)[0]+\n  importlib.machinery.SOURCE_SUFFIXES[0])\n elif any(filename.endswith(s)for s in\n importlib.machinery.EXTENSION_SUFFIXES):\n  return None\n if os.path.exists(filename):\n  return filename\n  \n if getattr(getmodule(object,filename),'__loader__',None )is not None :\n  return filename\n  \n if filename in linecache.cache:\n  return filename\n  \ndef getabsfile(object,_filename=None ):\n ''\n\n\n \n if _filename is None :\n  _filename=getsourcefile(object)or getfile(object)\n return os.path.normcase(os.path.abspath(_filename))\n \nmodulesbyfile={}\n_filesbymodname={}\n\ndef getmodule(object,_filename=None ):\n ''\n if ismodule(object):\n  return object\n if hasattr(object,'__module__'):\n  return sys.modules.get(object.__module__)\n  \n if _filename is not None and _filename in modulesbyfile:\n  return sys.modules.get(modulesbyfile[_filename])\n  \n try :\n  file=getabsfile(object,_filename)\n except TypeError:\n  return None\n if file in modulesbyfile:\n  return sys.modules.get(modulesbyfile[file])\n  \n  \n for modname,module in list(sys.modules.items()):\n  if ismodule(module)and hasattr(module,'__file__'):\n   f=module.__file__\n   if f ==_filesbymodname.get(modname,None ):\n   \n    continue\n   _filesbymodname[modname]=f\n   f=getabsfile(module)\n   \n   modulesbyfile[f]=modulesbyfile[\n   os.path.realpath(f)]=module.__name__\n if file in modulesbyfile:\n  return sys.modules.get(modulesbyfile[file])\n  \n main=sys.modules['__main__']\n if not hasattr(object,'__name__'):\n  return None\n if hasattr(main,object.__name__):\n  mainobject=getattr(main,object.__name__)\n  if mainobject is object:\n   return main\n   \n builtin=sys.modules['builtins']\n if hasattr(builtin,object.__name__):\n  builtinobject=getattr(builtin,object.__name__)\n  if builtinobject is object:\n   return builtin\n   \ndef findsource(object):\n ''\n\n\n\n\n \n \n file=getsourcefile(object)\n if file:\n \n  linecache.checkcache(file)\n else :\n  file=getfile(object)\n  \n  \n  \n  if not (file.startswith('<')and file.endswith('>')):\n   raise OSError('source code not available')\n   \n module=getmodule(object,file)\n if module:\n  lines=linecache.getlines(file,module.__dict__)\n else :\n  lines=linecache.getlines(file)\n if not lines:\n  raise OSError('could not get source code')\n  \n if ismodule(object):\n  return lines,0\n  \n if isclass(object):\n  name=object.__name__\n  pat=re.compile(r'^(\\s*)class\\s*'+name+r'\\b')\n  \n  \n  \n  candidates=[]\n  for i in range(len(lines)):\n   match=pat.match(lines[i])\n   if match:\n   \n    if lines[i][0]=='c':\n     return lines,i\n     \n    candidates.append((match.group(1),i))\n  if candidates:\n  \n  \n   candidates.sort()\n   return lines,candidates[0][1]\n  else :\n   raise OSError('could not find class definition')\n   \n if ismethod(object):\n  object=object.__func__\n if isfunction(object):\n  object=object.__code__\n if istraceback(object):\n  object=object.tb_frame\n if isframe(object):\n  object=object.f_code\n if iscode(object):\n  if not hasattr(object,'co_firstlineno'):\n   raise OSError('could not find function definition')\n  lnum=object.co_firstlineno -1\n  pat=re.compile(r'^(\\s*def\\s)|(\\s*async\\s+def\\s)|(.*(?<!\\w)lambda(:|\\s))|^(\\s*@)')\n  while lnum >0:\n   if pat.match(lines[lnum]):break\n   lnum=lnum -1\n  return lines,lnum\n raise OSError('could not find code object')\n \ndef getcomments(object):\n ''\n\n\n \n try :\n  lines,lnum=findsource(object)\n except (OSError,TypeError):\n  return None\n  \n if ismodule(object):\n \n  start=0\n  if lines and lines[0][:2]=='#!':start=1\n  while start <len(lines)and lines[start].strip()in ('','#'):\n   start=start+1\n  if start <len(lines)and lines[start][:1]=='#':\n   comments=[]\n   end=start\n   while end <len(lines)and lines[end][:1]=='#':\n    comments.append(lines[end].expandtabs())\n    end=end+1\n   return ''.join(comments)\n   \n   \n elif lnum >0:\n  indent=indentsize(lines[lnum])\n  end=lnum -1\n  if end >=0 and lines[end].lstrip()[:1]=='#'and\\\n  indentsize(lines[end])==indent:\n   comments=[lines[end].expandtabs().lstrip()]\n   if end >0:\n    end=end -1\n    comment=lines[end].expandtabs().lstrip()\n    while comment[:1]=='#'and indentsize(lines[end])==indent:\n     comments[:0]=[comment]\n     end=end -1\n     if end <0:break\n     comment=lines[end].expandtabs().lstrip()\n   while comments and comments[0].strip()=='#':\n    comments[:1]=[]\n   while comments and comments[-1].strip()=='#':\n    comments[-1:]=[]\n   return ''.join(comments)\n   \nclass EndOfBlock(Exception):pass\n\nclass BlockFinder:\n ''\n def __init__(self):\n  self.indent=0\n  self.islambda=False\n  self.started=False\n  self.passline=False\n  self.indecorator=False\n  self.decoratorhasargs=False\n  self.last=1\n  \n def tokeneater(self,type,token,srowcol,erowcol,line):\n  if not self.started and not self.indecorator:\n  \n   if token ==\"@\":\n    self.indecorator=True\n    \n   elif token in (\"def\",\"class\",\"lambda\"):\n    if token ==\"lambda\":\n     self.islambda=True\n    self.started=True\n   self.passline=True\n  elif token ==\"(\":\n   if self.indecorator:\n    self.decoratorhasargs=True\n  elif token ==\")\":\n   if self.indecorator:\n    self.indecorator=False\n    self.decoratorhasargs=False\n  elif type ==tokenize.NEWLINE:\n   self.passline=False\n   self.last=srowcol[0]\n   if self.islambda:\n    raise EndOfBlock\n    \n    \n   if self.indecorator and not self.decoratorhasargs:\n    self.indecorator=False\n  elif self.passline:\n   pass\n  elif type ==tokenize.INDENT:\n   self.indent=self.indent+1\n   self.passline=True\n  elif type ==tokenize.DEDENT:\n   self.indent=self.indent -1\n   \n   \n   \n   if self.indent <=0:\n    raise EndOfBlock\n  elif self.indent ==0 and type not in (tokenize.COMMENT,tokenize.NL):\n  \n  \n   raise EndOfBlock\n   \ndef getblock(lines):\n ''\n blockfinder=BlockFinder()\n try :\n  tokens=tokenize.generate_tokens(iter(lines).__next__)\n  for _token in tokens:\n   blockfinder.tokeneater(*_token)\n except (EndOfBlock,IndentationError):\n  pass\n return lines[:blockfinder.last]\n \ndef getsourcelines(object):\n ''\n\n\n\n\n\n \n object=unwrap(object)\n lines,lnum=findsource(object)\n \n if ismodule(object):\n  return lines,0\n else :\n  return getblock(lines[lnum:]),lnum+1\n  \ndef getsource(object):\n ''\n\n\n\n \n lines,lnum=getsourcelines(object)\n return ''.join(lines)\n \n \ndef walktree(classes,children,parent):\n ''\n results=[]\n classes.sort(key=attrgetter('__module__','__name__'))\n for c in classes:\n  results.append((c,c.__bases__))\n  if c in children:\n   results.append(walktree(children[c],children,c))\n return results\n \ndef getclasstree(classes,unique=False ):\n ''\n\n\n\n\n\n\n \n children={}\n roots=[]\n for c in classes:\n  if c.__bases__:\n   for parent in c.__bases__:\n    if not parent in children:\n     children[parent]=[]\n    if c not in children[parent]:\n     children[parent].append(c)\n    if unique and parent in classes:break\n  elif c not in roots:\n   roots.append(c)\n for parent in children:\n  if parent not in classes:\n   roots.append(parent)\n return walktree(roots,children,None )\n \n \nArguments=namedtuple('Arguments','args, varargs, varkw')\n\ndef getargs(co):\n ''\n\n\n\n\n \n args,varargs,kwonlyargs,varkw=_getfullargs(co)\n return Arguments(args+kwonlyargs,varargs,varkw)\n \ndef _getfullargs(co):\n ''\n\n\n\n \n \n if not iscode(co):\n  raise TypeError('{!r} is not a code object'.format(co))\n  \n nargs=co.co_argcount\n names=co.co_varnames\n nkwargs=co.co_kwonlyargcount\n args=list(names[:nargs])\n kwonlyargs=list(names[nargs:nargs+nkwargs])\n step=0\n \n nargs +=nkwargs\n varargs=None\n if co.co_flags&CO_VARARGS:\n  varargs=co.co_varnames[nargs]\n  nargs=nargs+1\n varkw=None\n if co.co_flags&CO_VARKEYWORDS:\n  varkw=co.co_varnames[nargs]\n return args,varargs,kwonlyargs,varkw\n \n \nArgSpec=namedtuple('ArgSpec','args varargs keywords defaults')\n\ndef getargspec(func):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n warnings.warn(\"inspect.getargspec() is deprecated, \"\n \"use inspect.signature() or inspect.getfullargspec()\",\n DeprecationWarning,stacklevel=2)\n args,varargs,varkw,defaults,kwonlyargs,kwonlydefaults,ann=\\\n getfullargspec(func)\n if kwonlyargs or ann:\n  raise ValueError(\"Function has keyword-only parameters or annotations\"\n  \", use getfullargspec() API which can support them\")\n return ArgSpec(args,varargs,varkw,defaults)\n \nFullArgSpec=namedtuple('FullArgSpec',\n'args, varargs, varkw, defaults, kwonlyargs, kwonlydefaults, annotations')\n\ndef getfullargspec(func):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n try :\n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n  sig=_signature_from_callable(func,\n  follow_wrapper_chains=False ,\n  skip_bound_arg=False ,\n  sigcls=Signature)\n except Exception as ex:\n \n \n \n \n  raise TypeError('unsupported callable')from ex\n  \n args=[]\n varargs=None\n varkw=None\n kwonlyargs=[]\n defaults=()\n annotations={}\n defaults=()\n kwdefaults={}\n \n if sig.return_annotation is not sig.empty:\n  annotations['return']=sig.return_annotation\n  \n for param in sig.parameters.values():\n  kind=param.kind\n  name=param.name\n  \n  if kind is _POSITIONAL_ONLY:\n   args.append(name)\n  elif kind is _POSITIONAL_OR_KEYWORD:\n   args.append(name)\n   if param.default is not param.empty:\n    defaults +=(param.default,)\n  elif kind is _VAR_POSITIONAL:\n   varargs=name\n  elif kind is _KEYWORD_ONLY:\n   kwonlyargs.append(name)\n   if param.default is not param.empty:\n    kwdefaults[name]=param.default\n  elif kind is _VAR_KEYWORD:\n   varkw=name\n   \n  if param.annotation is not param.empty:\n   annotations[name]=param.annotation\n   \n if not kwdefaults:\n \n  kwdefaults=None\n  \n if not defaults:\n \n  defaults=None\n  \n return FullArgSpec(args,varargs,varkw,defaults,\n kwonlyargs,kwdefaults,annotations)\n \n \nArgInfo=namedtuple('ArgInfo','args varargs keywords locals')\n\ndef getargvalues(frame):\n ''\n\n\n\n\n \n args,varargs,varkw=getargs(frame.f_code)\n return ArgInfo(args,varargs,varkw,frame.f_locals)\n \ndef formatannotation(annotation,base_module=None ):\n if getattr(annotation,'__module__',None )=='typing':\n  return repr(annotation).replace('typing.','')\n if isinstance(annotation,type):\n  if annotation.__module__ in ('builtins',base_module):\n   return annotation.__qualname__\n  return annotation.__module__+'.'+annotation.__qualname__\n return repr(annotation)\n \ndef formatannotationrelativeto(object):\n module=getattr(object,'__module__',None )\n def _formatannotation(annotation):\n  return formatannotation(annotation,module)\n return _formatannotation\n \ndef formatargspec(args,varargs=None ,varkw=None ,defaults=None ,\nkwonlyargs=(),kwonlydefaults={},annotations={},\nformatarg=str,\nformatvarargs=lambda name:'*'+name,\nformatvarkw=lambda name:'**'+name,\nformatvalue=lambda value:'='+repr(value),\nformatreturns=lambda text:' -> '+text,\nformatannotation=formatannotation):\n ''\n\n\n\n\n\n\n\n\n\n \n \n from warnings import warn\n \n warn(\"`formatargspec` is deprecated since Python 3.5. Use `signature` and \"\n \"the `Signature` object directly\",\n DeprecationWarning,\n stacklevel=2)\n \n def formatargandannotation(arg):\n  result=formatarg(arg)\n  if arg in annotations:\n   result +=': '+formatannotation(annotations[arg])\n  return result\n specs=[]\n if defaults:\n  firstdefault=len(args)-len(defaults)\n for i,arg in enumerate(args):\n  spec=formatargandannotation(arg)\n  if defaults and i >=firstdefault:\n   spec=spec+formatvalue(defaults[i -firstdefault])\n  specs.append(spec)\n if varargs is not None :\n  specs.append(formatvarargs(formatargandannotation(varargs)))\n else :\n  if kwonlyargs:\n   specs.append('*')\n if kwonlyargs:\n  for kwonlyarg in kwonlyargs:\n   spec=formatargandannotation(kwonlyarg)\n   if kwonlydefaults and kwonlyarg in kwonlydefaults:\n    spec +=formatvalue(kwonlydefaults[kwonlyarg])\n   specs.append(spec)\n if varkw is not None :\n  specs.append(formatvarkw(formatargandannotation(varkw)))\n result='('+', '.join(specs)+')'\n if 'return'in annotations:\n  result +=formatreturns(formatannotation(annotations['return']))\n return result\n \ndef formatargvalues(args,varargs,varkw,locals,\nformatarg=str,\nformatvarargs=lambda name:'*'+name,\nformatvarkw=lambda name:'**'+name,\nformatvalue=lambda value:'='+repr(value)):\n ''\n\n\n\n\n \n def convert(name,locals=locals,\n formatarg=formatarg,formatvalue=formatvalue):\n  return formatarg(name)+formatvalue(locals[name])\n specs=[]\n for i in range(len(args)):\n  specs.append(convert(args[i]))\n if varargs:\n  specs.append(formatvarargs(varargs)+formatvalue(locals[varargs]))\n if varkw:\n  specs.append(formatvarkw(varkw)+formatvalue(locals[varkw]))\n return '('+', '.join(specs)+')'\n \ndef _missing_arguments(f_name,argnames,pos,values):\n names=[repr(name)for name in argnames if name not in values]\n missing=len(names)\n if missing ==1:\n  s=names[0]\n elif missing ==2:\n  s=\"{} and {}\".format(*names)\n else :\n  tail=\", {} and {}\".format(*names[-2:])\n  del names[-2:]\n  s=\", \".join(names)+tail\n raise TypeError(\"%s() missing %i required %s argument%s: %s\"%\n (f_name,missing,\n \"positional\"if pos else \"keyword-only\",\n \"\"if missing ==1 else \"s\",s))\n \ndef _too_many(f_name,args,kwonly,varargs,defcount,given,values):\n atleast=len(args)-defcount\n kwonly_given=len([arg for arg in kwonly if arg in values])\n if varargs:\n  plural=atleast !=1\n  sig=\"at least %d\"%(atleast,)\n elif defcount:\n  plural=True\n  sig=\"from %d to %d\"%(atleast,len(args))\n else :\n  plural=len(args)!=1\n  sig=str(len(args))\n kwonly_sig=\"\"\n if kwonly_given:\n  msg=\" positional argument%s (and %d keyword-only argument%s)\"\n  kwonly_sig=(msg %(\"s\"if given !=1 else \"\",kwonly_given,\n  \"s\"if kwonly_given !=1 else \"\"))\n raise TypeError(\"%s() takes %s positional argument%s but %d%s %s given\"%\n (f_name,sig,\"s\"if plural else \"\",given,kwonly_sig,\n \"was\"if given ==1 and not kwonly_given else \"were\"))\n \ndef getcallargs(*func_and_positional,**named):\n ''\n\n\n\n \n func=func_and_positional[0]\n positional=func_and_positional[1:]\n spec=getfullargspec(func)\n args,varargs,varkw,defaults,kwonlyargs,kwonlydefaults,ann=spec\n f_name=func.__name__\n arg2value={}\n \n \n if ismethod(func)and func.__self__ is not None :\n \n  positional=(func.__self__,)+positional\n num_pos=len(positional)\n num_args=len(args)\n num_defaults=len(defaults)if defaults else 0\n \n n=min(num_pos,num_args)\n for i in range(n):\n  arg2value[args[i]]=positional[i]\n if varargs:\n  arg2value[varargs]=tuple(positional[n:])\n possible_kwargs=set(args+kwonlyargs)\n if varkw:\n  arg2value[varkw]={}\n for kw,value in named.items():\n  if kw not in possible_kwargs:\n   if not varkw:\n    raise TypeError(\"%s() got an unexpected keyword argument %r\"%\n    (f_name,kw))\n   arg2value[varkw][kw]=value\n   continue\n  if kw in arg2value:\n   raise TypeError(\"%s() got multiple values for argument %r\"%\n   (f_name,kw))\n  arg2value[kw]=value\n if num_pos >num_args and not varargs:\n  _too_many(f_name,args,kwonlyargs,varargs,num_defaults,\n  num_pos,arg2value)\n if num_pos <num_args:\n  req=args[:num_args -num_defaults]\n  for arg in req:\n   if arg not in arg2value:\n    _missing_arguments(f_name,req,True ,arg2value)\n  for i,arg in enumerate(args[num_args -num_defaults:]):\n   if arg not in arg2value:\n    arg2value[arg]=defaults[i]\n missing=0\n for kwarg in kwonlyargs:\n  if kwarg not in arg2value:\n   if kwonlydefaults and kwarg in kwonlydefaults:\n    arg2value[kwarg]=kwonlydefaults[kwarg]\n   else :\n    missing +=1\n if missing:\n  _missing_arguments(f_name,kwonlyargs,False ,arg2value)\n return arg2value\n \nClosureVars=namedtuple('ClosureVars','nonlocals globals builtins unbound')\n\ndef getclosurevars(func):\n ''\n\n\n\n\n\n \n \n if ismethod(func):\n  func=func.__func__\n  \n if not isfunction(func):\n  raise TypeError(\"{!r} is not a Python function\".format(func))\n  \n code=func.__code__\n \n \n if func.__closure__ is None :\n  nonlocal_vars={}\n else :\n  nonlocal_vars={\n  var:cell.cell_contents\n  for var,cell in zip(code.co_freevars,func.__closure__)\n  }\n  \n  \n  \n global_ns=func.__globals__\n builtin_ns=global_ns.get(\"__builtins__\",builtins.__dict__)\n if ismodule(builtin_ns):\n  builtin_ns=builtin_ns.__dict__\n global_vars={}\n builtin_vars={}\n unbound_names=set()\n for name in code.co_names:\n  if name in (\"None\",\"True\",\"False\"):\n  \n  \n   continue\n  try :\n   global_vars[name]=global_ns[name]\n  except KeyError:\n   try :\n    builtin_vars[name]=builtin_ns[name]\n   except KeyError:\n    unbound_names.add(name)\n    \n return ClosureVars(nonlocal_vars,global_vars,\n builtin_vars,unbound_names)\n \n \n \nTraceback=namedtuple('Traceback','filename lineno function code_context index')\n\ndef getframeinfo(frame,context=1):\n ''\n\n\n\n\n\n \n if istraceback(frame):\n  lineno=frame.tb_lineno\n  frame=frame.tb_frame\n else :\n  lineno=frame.f_lineno\n if not isframe(frame):\n  raise TypeError('{!r} is not a frame or traceback object'.format(frame))\n  \n filename=getsourcefile(frame)or getfile(frame)\n if context >0:\n  start=lineno -1 -context //2\n  try :\n   lines,lnum=findsource(frame)\n  except OSError:\n   lines=index=None\n  else :\n   start=max(0,min(start,len(lines)-context))\n   lines=lines[start:start+context]\n   index=lineno -1 -start\n else :\n  lines=index=None\n  \n return Traceback(filename,lineno,frame.f_code.co_name,lines,index)\n \ndef getlineno(frame):\n ''\n \n return frame.f_lineno\n \nFrameInfo=namedtuple('FrameInfo',('frame',)+Traceback._fields)\n\ndef getouterframes(frame,context=1):\n ''\n\n\n \n framelist=[]\n while frame:\n  frameinfo=(frame,)+getframeinfo(frame,context)\n  framelist.append(FrameInfo(*frameinfo))\n  frame=frame.f_back\n return framelist\n \ndef getinnerframes(tb,context=1):\n ''\n\n\n \n framelist=[]\n while tb:\n  frameinfo=(tb.tb_frame,)+getframeinfo(tb,context)\n  framelist.append(FrameInfo(*frameinfo))\n  tb=tb.tb_next\n return framelist\n \ndef currentframe():\n ''\n return sys._getframe(1)if hasattr(sys,\"_getframe\")else None\n \ndef stack(context=1):\n ''\n return getouterframes(sys._getframe(1),context)\n \ndef trace(context=1):\n ''\n return getinnerframes(sys.exc_info()[2],context)\n \n \n \n \n_sentinel=object()\n\ndef _static_getmro(klass):\n return type.__dict__['__mro__'].__get__(klass)\n \ndef _check_instance(obj,attr):\n instance_dict={}\n try :\n  instance_dict=object.__getattribute__(obj,\"__dict__\")\n except AttributeError:\n  pass\n return dict.get(instance_dict,attr,_sentinel)\n \n \ndef _check_class(klass,attr):\n for entry in _static_getmro(klass):\n  if _shadowed_dict(type(entry))is _sentinel:\n   try :\n    return entry.__dict__[attr]\n   except KeyError:\n    pass\n return _sentinel\n \ndef _is_type(obj):\n try :\n  _static_getmro(obj)\n except TypeError:\n  return False\n return True\n \ndef _shadowed_dict(klass):\n dict_attr=type.__dict__[\"__dict__\"]\n for entry in _static_getmro(klass):\n  try :\n   class_dict=dict_attr.__get__(entry)[\"__dict__\"]\n  except KeyError:\n   pass\n  else :\n   if not (type(class_dict)is types.GetSetDescriptorType and\n   class_dict.__name__ ==\"__dict__\"and\n   class_dict.__objclass__ is entry):\n    return class_dict\n return _sentinel\n \ndef getattr_static(obj,attr,default=_sentinel):\n ''\n\n\n\n\n\n\n\n\n \n instance_result=_sentinel\n if not _is_type(obj):\n  klass=type(obj)\n  dict_attr=_shadowed_dict(klass)\n  if (dict_attr is _sentinel or\n  type(dict_attr)is types.MemberDescriptorType):\n   instance_result=_check_instance(obj,attr)\n else :\n  klass=obj\n  \n klass_result=_check_class(klass,attr)\n \n if instance_result is not _sentinel and klass_result is not _sentinel:\n  if (_check_class(type(klass_result),'__get__')is not _sentinel and\n  _check_class(type(klass_result),'__set__')is not _sentinel):\n   return klass_result\n   \n if instance_result is not _sentinel:\n  return instance_result\n if klass_result is not _sentinel:\n  return klass_result\n  \n if obj is klass:\n \n  for entry in _static_getmro(type(klass)):\n   if _shadowed_dict(type(entry))is _sentinel:\n    try :\n     return entry.__dict__[attr]\n    except KeyError:\n     pass\n if default is not _sentinel:\n  return default\n raise AttributeError(attr)\n \n \n \n \nGEN_CREATED='GEN_CREATED'\nGEN_RUNNING='GEN_RUNNING'\nGEN_SUSPENDED='GEN_SUSPENDED'\nGEN_CLOSED='GEN_CLOSED'\n\ndef getgeneratorstate(generator):\n ''\n\n\n\n\n\n\n \n if generator.gi_running:\n  return GEN_RUNNING\n if generator.gi_frame is None :\n  return GEN_CLOSED\n if generator.gi_frame.f_lasti ==-1:\n  return GEN_CREATED\n return GEN_SUSPENDED\n \n \ndef getgeneratorlocals(generator):\n ''\n\n\n\n \n \n if not isgenerator(generator):\n  raise TypeError(\"{!r} is not a Python generator\".format(generator))\n  \n frame=getattr(generator,\"gi_frame\",None )\n if frame is not None :\n  return generator.gi_frame.f_locals\n else :\n  return {}\n  \n  \n  \n  \nCORO_CREATED='CORO_CREATED'\nCORO_RUNNING='CORO_RUNNING'\nCORO_SUSPENDED='CORO_SUSPENDED'\nCORO_CLOSED='CORO_CLOSED'\n\ndef getcoroutinestate(coroutine):\n ''\n\n\n\n\n\n\n \n if coroutine.cr_running:\n  return CORO_RUNNING\n if coroutine.cr_frame is None :\n  return CORO_CLOSED\n if coroutine.cr_frame.f_lasti ==-1:\n  return CORO_CREATED\n return CORO_SUSPENDED\n \n \ndef getcoroutinelocals(coroutine):\n ''\n\n\n\n \n frame=getattr(coroutine,\"cr_frame\",None )\n if frame is not None :\n  return frame.f_locals\n else :\n  return {}\n  \n  \n  \n  \n  \n  \n  \n_WrapperDescriptor=type(type.__call__)\n_MethodWrapper=type(all.__call__)\n_ClassMethodWrapper=type(int.__dict__['from_bytes'])\n\n_NonUserDefinedCallables=(_WrapperDescriptor,\n_MethodWrapper,\n_ClassMethodWrapper,\ntypes.BuiltinFunctionType)\n\n\ndef _signature_get_user_defined_method(cls,method_name):\n ''\n\n\n \n try :\n  meth=getattr(cls,method_name)\n except AttributeError:\n  return\n else :\n  if not isinstance(meth,_NonUserDefinedCallables):\n  \n  \n   return meth\n   \n   \ndef _signature_get_partial(wrapped_sig,partial,extra_args=()):\n ''\n\n\n \n \n old_params=wrapped_sig.parameters\n new_params=OrderedDict(old_params.items())\n \n partial_args=partial.args or ()\n partial_keywords=partial.keywords or {}\n \n if extra_args:\n  partial_args=extra_args+partial_args\n  \n try :\n  ba=wrapped_sig.bind_partial(*partial_args,**partial_keywords)\n except TypeError as ex:\n  msg='partial object {!r} has incorrect arguments'.format(partial)\n  raise ValueError(msg)from ex\n  \n  \n transform_to_kwonly=False\n for param_name,param in old_params.items():\n  try :\n   arg_value=ba.arguments[param_name]\n  except KeyError:\n   pass\n  else :\n   if param.kind is _POSITIONAL_ONLY:\n   \n   \n    new_params.pop(param_name)\n    continue\n    \n   if param.kind is _POSITIONAL_OR_KEYWORD:\n    if param_name in partial_keywords:\n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n     transform_to_kwonly=True\n     \n     new_params[param_name]=param.replace(default=arg_value)\n    else :\n    \n     new_params.pop(param.name)\n     continue\n     \n   if param.kind is _KEYWORD_ONLY:\n   \n    new_params[param_name]=param.replace(default=arg_value)\n    \n  if transform_to_kwonly:\n   assert param.kind is not _POSITIONAL_ONLY\n   \n   if param.kind is _POSITIONAL_OR_KEYWORD:\n    new_param=new_params[param_name].replace(kind=_KEYWORD_ONLY)\n    new_params[param_name]=new_param\n    new_params.move_to_end(param_name)\n   elif param.kind in (_KEYWORD_ONLY,_VAR_KEYWORD):\n    new_params.move_to_end(param_name)\n   elif param.kind is _VAR_POSITIONAL:\n    new_params.pop(param.name)\n    \n return wrapped_sig.replace(parameters=new_params.values())\n \n \ndef _signature_bound_method(sig):\n ''\n\n \n \n params=tuple(sig.parameters.values())\n \n if not params or params[0].kind in (_VAR_KEYWORD,_KEYWORD_ONLY):\n  raise ValueError('invalid method signature')\n  \n kind=params[0].kind\n if kind in (_POSITIONAL_OR_KEYWORD,_POSITIONAL_ONLY):\n \n \n  params=params[1:]\n else :\n  if kind is not _VAR_POSITIONAL:\n  \n  \n   raise ValueError('invalid argument type')\n   \n   \n   \n return sig.replace(parameters=params)\n \n \ndef _signature_is_builtin(obj):\n ''\n\n \n return (isbuiltin(obj)or\n ismethoddescriptor(obj)or\n isinstance(obj,_NonUserDefinedCallables)or\n \n \n obj in (type,object))\n \n \ndef _signature_is_functionlike(obj):\n ''\n\n\n\n \n \n if not callable(obj)or isclass(obj):\n \n \n  return False\n  \n name=getattr(obj,'__name__',None )\n code=getattr(obj,'__code__',None )\n defaults=getattr(obj,'__defaults__',_void)\n kwdefaults=getattr(obj,'__kwdefaults__',_void)\n annotations=getattr(obj,'__annotations__',None )\n \n return (isinstance(code,types.CodeType)and\n isinstance(name,str)and\n (defaults is None or isinstance(defaults,tuple))and\n (kwdefaults is None or isinstance(kwdefaults,dict))and\n isinstance(annotations,dict))\n \n \ndef _signature_get_bound_param(spec):\n ''\n\n\n\n\n \n \n assert spec.startswith('($')\n \n pos=spec.find(',')\n if pos ==-1:\n  pos=spec.find(')')\n  \n cpos=spec.find(':')\n assert cpos ==-1 or cpos >pos\n \n cpos=spec.find('=')\n assert cpos ==-1 or cpos >pos\n \n return spec[2:pos]\n \n \ndef _signature_strip_non_python_syntax(signature):\n ''\n\n\n\n\n\n\n\n\n\n \n \n if not signature:\n  return signature,None ,None\n  \n self_parameter=None\n last_positional_only=None\n \n lines=[l.encode('ascii')for l in signature.split('\\n')]\n generator=iter(lines).__next__\n token_stream=tokenize.tokenize(generator)\n \n delayed_comma=False\n skip_next_comma=False\n text=[]\n add=text.append\n \n current_parameter=0\n OP=token.OP\n ERRORTOKEN=token.ERRORTOKEN\n \n \n t=next(token_stream)\n assert t.type ==tokenize.ENCODING\n \n for t in token_stream:\n  type,string=t.type,t.string\n  \n  if type ==OP:\n   if string ==',':\n    if skip_next_comma:\n     skip_next_comma=False\n    else :\n     assert not delayed_comma\n     delayed_comma=True\n     current_parameter +=1\n    continue\n    \n   if string =='/':\n    assert not skip_next_comma\n    assert last_positional_only is None\n    skip_next_comma=True\n    last_positional_only=current_parameter -1\n    continue\n    \n  if (type ==ERRORTOKEN)and (string =='$'):\n   assert self_parameter is None\n   self_parameter=current_parameter\n   continue\n   \n  if delayed_comma:\n   delayed_comma=False\n   if not ((type ==OP)and (string ==')')):\n    add(', ')\n  add(string)\n  if (string ==','):\n   add(' ')\n clean_signature=''.join(text)\n return clean_signature,self_parameter,last_positional_only\n \n \ndef _signature_fromstr(cls,obj,s,skip_bound_arg=True ):\n ''\n\n \n \n \n import ast\n \n Parameter=cls._parameter_cls\n \n clean_signature,self_parameter,last_positional_only=\\\n _signature_strip_non_python_syntax(s)\n \n program=\"def foo\"+clean_signature+\": pass\"\n \n try :\n  module=ast.parse(program)\n except SyntaxError:\n  module=None\n  \n if not isinstance(module,ast.Module):\n  raise ValueError(\"{!r} builtin has invalid signature\".format(obj))\n  \n f=module.body[0]\n \n parameters=[]\n empty=Parameter.empty\n invalid=object()\n \n module=None\n module_dict={}\n module_name=getattr(obj,'__module__',None )\n if module_name:\n  module=sys.modules.get(module_name,None )\n  if module:\n   module_dict=module.__dict__\n sys_module_dict=sys.modules\n \n def parse_name(node):\n  assert isinstance(node,ast.arg)\n  if node.annotation !=None :\n   raise ValueError(\"Annotations are not currently supported\")\n  return node.arg\n  \n def wrap_value(s):\n  try :\n   value=eval(s,module_dict)\n  except NameError:\n   try :\n    value=eval(s,sys_module_dict)\n   except NameError:\n    raise RuntimeError()\n    \n  if isinstance(value,str):\n   return ast.Str(value)\n  if isinstance(value,(int,float)):\n   return ast.Num(value)\n  if isinstance(value,bytes):\n   return ast.Bytes(value)\n  if value in (True ,False ,None ):\n   return ast.NameConstant(value)\n  raise RuntimeError()\n  \n class RewriteSymbolics(ast.NodeTransformer):\n  def visit_Attribute(self,node):\n   a=[]\n   n=node\n   while isinstance(n,ast.Attribute):\n    a.append(n.attr)\n    n=n.value\n   if not isinstance(n,ast.Name):\n    raise RuntimeError()\n   a.append(n.id)\n   value=\".\".join(reversed(a))\n   return wrap_value(value)\n   \n  def visit_Name(self,node):\n   if not isinstance(node.ctx,ast.Load):\n    raise ValueError()\n   return wrap_value(node.id)\n   \n def p(name_node,default_node,default=empty):\n  name=parse_name(name_node)\n  if name is invalid:\n   return None\n  if default_node and default_node is not _empty:\n   try :\n    default_node=RewriteSymbolics().visit(default_node)\n    o=ast.literal_eval(default_node)\n   except ValueError:\n    o=invalid\n   if o is invalid:\n    return None\n   default=o if o is not invalid else default\n  parameters.append(Parameter(name,kind,default=default,annotation=empty))\n  \n  \n args=reversed(f.args.args)\n defaults=reversed(f.args.defaults)\n iter=itertools.zip_longest(args,defaults,fillvalue=None )\n if last_positional_only is not None :\n  kind=Parameter.POSITIONAL_ONLY\n else :\n  kind=Parameter.POSITIONAL_OR_KEYWORD\n for i,(name,default)in enumerate(reversed(list(iter))):\n  p(name,default)\n  if i ==last_positional_only:\n   kind=Parameter.POSITIONAL_OR_KEYWORD\n   \n   \n if f.args.vararg:\n  kind=Parameter.VAR_POSITIONAL\n  p(f.args.vararg,empty)\n  \n  \n kind=Parameter.KEYWORD_ONLY\n for name,default in zip(f.args.kwonlyargs,f.args.kw_defaults):\n  p(name,default)\n  \n  \n if f.args.kwarg:\n  kind=Parameter.VAR_KEYWORD\n  p(f.args.kwarg,empty)\n  \n if self_parameter is not None :\n \n \n \n \n \n  assert parameters\n  _self=getattr(obj,'__self__',None )\n  self_isbound=_self is not None\n  self_ismodule=ismodule(_self)\n  if self_isbound and (self_ismodule or skip_bound_arg):\n   parameters.pop(0)\n  else :\n  \n   p=parameters[0].replace(kind=Parameter.POSITIONAL_ONLY)\n   parameters[0]=p\n   \n return cls(parameters,return_annotation=cls.empty)\n \n \ndef _signature_from_builtin(cls,func,skip_bound_arg=True ):\n ''\n\n \n \n if not _signature_is_builtin(func):\n  raise TypeError(\"{!r} is not a Python builtin \"\n  \"function\".format(func))\n  \n s=getattr(func,\"__text_signature__\",None )\n if not s:\n  raise ValueError(\"no signature found for builtin {!r}\".format(func))\n  \n return _signature_fromstr(cls,func,s,skip_bound_arg)\n \n \ndef _signature_from_function(cls,func):\n ''\n \n is_duck_function=False\n if not isfunction(func):\n  if _signature_is_functionlike(func):\n   is_duck_function=True\n  else :\n  \n  \n   raise TypeError('{!r} is not a Python function'.format(func))\n   \n Parameter=cls._parameter_cls\n \n \n func_code=func.__code__\n pos_count=func_code.co_argcount\n arg_names=func_code.co_varnames\n positional=tuple(arg_names[:pos_count])\n keyword_only_count=func_code.co_kwonlyargcount\n keyword_only=arg_names[pos_count:(pos_count+keyword_only_count)]\n annotations=func.__annotations__\n defaults=func.__defaults__\n kwdefaults=func.__kwdefaults__\n \n if defaults:\n  pos_default_count=len(defaults)\n else :\n  pos_default_count=0\n  \n parameters=[]\n \n \n non_default_count=pos_count -pos_default_count\n for name in positional[:non_default_count]:\n  annotation=annotations.get(name,_empty)\n  parameters.append(Parameter(name,annotation=annotation,\n  kind=_POSITIONAL_OR_KEYWORD))\n  \n  \n for offset,name in enumerate(positional[non_default_count:]):\n  annotation=annotations.get(name,_empty)\n  parameters.append(Parameter(name,annotation=annotation,\n  kind=_POSITIONAL_OR_KEYWORD,\n  default=defaults[offset]))\n  \n  \n if func_code.co_flags&CO_VARARGS:\n  name=arg_names[pos_count+keyword_only_count]\n  annotation=annotations.get(name,_empty)\n  parameters.append(Parameter(name,annotation=annotation,\n  kind=_VAR_POSITIONAL))\n  \n  \n for name in keyword_only:\n  default=_empty\n  if kwdefaults is not None :\n   default=kwdefaults.get(name,_empty)\n   \n  annotation=annotations.get(name,_empty)\n  parameters.append(Parameter(name,annotation=annotation,\n  kind=_KEYWORD_ONLY,\n  default=default))\n  \n if func_code.co_flags&CO_VARKEYWORDS:\n  index=pos_count+keyword_only_count\n  if func_code.co_flags&CO_VARARGS:\n   index +=1\n   \n  name=arg_names[index]\n  annotation=annotations.get(name,_empty)\n  parameters.append(Parameter(name,annotation=annotation,\n  kind=_VAR_KEYWORD))\n  \n  \n  \n return cls(parameters,\n return_annotation=annotations.get('return',_empty),\n __validate_parameters__=is_duck_function)\n \n \ndef _signature_from_callable(obj,*,\nfollow_wrapper_chains=True ,\nskip_bound_arg=True ,\nsigcls):\n\n ''\n\n \n \n if not callable(obj):\n  raise TypeError('{!r} is not a callable object'.format(obj))\n  \n if isinstance(obj,types.MethodType):\n \n \n  sig=_signature_from_callable(\n  obj.__func__,\n  follow_wrapper_chains=follow_wrapper_chains,\n  skip_bound_arg=skip_bound_arg,\n  sigcls=sigcls)\n  \n  if skip_bound_arg:\n   return _signature_bound_method(sig)\n  else :\n   return sig\n   \n   \n if follow_wrapper_chains:\n  obj=unwrap(obj,stop=(lambda f:hasattr(f,\"__signature__\")))\n  if isinstance(obj,types.MethodType):\n  \n  \n  \n   return _signature_from_callable(\n   obj,\n   follow_wrapper_chains=follow_wrapper_chains,\n   skip_bound_arg=skip_bound_arg,\n   sigcls=sigcls)\n   \n try :\n  sig=obj.__signature__\n except AttributeError:\n  pass\n else :\n  if sig is not None :\n   if not isinstance(sig,Signature):\n    raise TypeError(\n    'unexpected object {!r} in __signature__ '\n    'attribute'.format(sig))\n   return sig\n   \n try :\n  partialmethod=obj._partialmethod\n except AttributeError:\n  pass\n else :\n  if isinstance(partialmethod,functools.partialmethod):\n  \n  \n  \n  \n  \n  \n  \n   wrapped_sig=_signature_from_callable(\n   partialmethod.func,\n   follow_wrapper_chains=follow_wrapper_chains,\n   skip_bound_arg=skip_bound_arg,\n   sigcls=sigcls)\n   \n   sig=_signature_get_partial(wrapped_sig,partialmethod,(None ,))\n   first_wrapped_param=tuple(wrapped_sig.parameters.values())[0]\n   if first_wrapped_param.kind is Parameter.VAR_POSITIONAL:\n   \n   \n    return sig\n   else :\n    sig_params=tuple(sig.parameters.values())\n    assert (not sig_params or\n    first_wrapped_param is not sig_params[0])\n    new_params=(first_wrapped_param,)+sig_params\n    return sig.replace(parameters=new_params)\n    \n if isfunction(obj)or _signature_is_functionlike(obj):\n \n \n  return _signature_from_function(sigcls,obj)\n  \n if _signature_is_builtin(obj):\n  return _signature_from_builtin(sigcls,obj,\n  skip_bound_arg=skip_bound_arg)\n  \n if isinstance(obj,functools.partial):\n  wrapped_sig=_signature_from_callable(\n  obj.func,\n  follow_wrapper_chains=follow_wrapper_chains,\n  skip_bound_arg=skip_bound_arg,\n  sigcls=sigcls)\n  return _signature_get_partial(wrapped_sig,obj)\n  \n sig=None\n if isinstance(obj,type):\n \n \n \n \n  call=_signature_get_user_defined_method(type(obj),'__call__')\n  if call is not None :\n   sig=_signature_from_callable(\n   call,\n   follow_wrapper_chains=follow_wrapper_chains,\n   skip_bound_arg=skip_bound_arg,\n   sigcls=sigcls)\n  else :\n  \n   new=_signature_get_user_defined_method(obj,'__new__')\n   if new is not None :\n    sig=_signature_from_callable(\n    new,\n    follow_wrapper_chains=follow_wrapper_chains,\n    skip_bound_arg=skip_bound_arg,\n    sigcls=sigcls)\n   else :\n   \n    init=_signature_get_user_defined_method(obj,'__init__')\n    if init is not None :\n     sig=_signature_from_callable(\n     init,\n     follow_wrapper_chains=follow_wrapper_chains,\n     skip_bound_arg=skip_bound_arg,\n     sigcls=sigcls)\n     \n  if sig is None :\n  \n  \n  \n   for base in obj.__mro__[:-1]:\n   \n   \n   \n   \n   \n   \n   \n    try :\n     text_sig=base.__text_signature__\n    except AttributeError:\n     pass\n    else :\n     if text_sig:\n     \n     \n      return _signature_fromstr(sigcls,obj,text_sig)\n      \n      \n      \n      \n   if type not in obj.__mro__:\n   \n   \n    if (obj.__init__ is object.__init__ and\n    obj.__new__ is object.__new__):\n    \n     return signature(object)\n    else :\n     raise ValueError(\n     'no signature found for builtin type {!r}'.format(obj))\n     \n elif not isinstance(obj,_NonUserDefinedCallables):\n \n \n \n \n  call=_signature_get_user_defined_method(type(obj),'__call__')\n  if call is not None :\n   try :\n    sig=_signature_from_callable(\n    call,\n    follow_wrapper_chains=follow_wrapper_chains,\n    skip_bound_arg=skip_bound_arg,\n    sigcls=sigcls)\n   except ValueError as ex:\n    msg='no signature found for {!r}'.format(obj)\n    raise ValueError(msg)from ex\n    \n if sig is not None :\n \n \n  if skip_bound_arg:\n   return _signature_bound_method(sig)\n  else :\n   return sig\n   \n if isinstance(obj,types.BuiltinFunctionType):\n \n  msg='no signature found for builtin function {!r}'.format(obj)\n  raise ValueError(msg)\n  \n raise ValueError('callable {!r} is not supported by signature'.format(obj))\n \n \nclass _void:\n ''\n \n \nclass _empty:\n ''\n \n \nclass _ParameterKind(enum.IntEnum):\n POSITIONAL_ONLY=0\n POSITIONAL_OR_KEYWORD=1\n VAR_POSITIONAL=2\n KEYWORD_ONLY=3\n VAR_KEYWORD=4\n \n def __str__(self):\n  return self._name_\n  \n  \n_POSITIONAL_ONLY=_ParameterKind.POSITIONAL_ONLY\n_POSITIONAL_OR_KEYWORD=_ParameterKind.POSITIONAL_OR_KEYWORD\n_VAR_POSITIONAL=_ParameterKind.VAR_POSITIONAL\n_KEYWORD_ONLY=_ParameterKind.KEYWORD_ONLY\n_VAR_KEYWORD=_ParameterKind.VAR_KEYWORD\n\n_PARAM_NAME_MAPPING={\n_POSITIONAL_ONLY:'positional-only',\n_POSITIONAL_OR_KEYWORD:'positional or keyword',\n_VAR_POSITIONAL:'variadic positional',\n_KEYWORD_ONLY:'keyword-only',\n_VAR_KEYWORD:'variadic keyword'\n}\n\n_get_paramkind_descr=_PARAM_NAME_MAPPING.__getitem__\n\n\nclass Parameter:\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n __slots__=('_name','_kind','_default','_annotation')\n \n POSITIONAL_ONLY=_POSITIONAL_ONLY\n POSITIONAL_OR_KEYWORD=_POSITIONAL_OR_KEYWORD\n VAR_POSITIONAL=_VAR_POSITIONAL\n KEYWORD_ONLY=_KEYWORD_ONLY\n VAR_KEYWORD=_VAR_KEYWORD\n \n empty=_empty\n \n def __init__(self,name,kind,*,default=_empty,annotation=_empty):\n  try :\n   self._kind=_ParameterKind(kind)\n  except ValueError:\n   raise ValueError(f'value {kind!r} is not a valid Parameter.kind')\n  if default is not _empty:\n   if self._kind in (_VAR_POSITIONAL,_VAR_KEYWORD):\n    msg='{} parameters cannot have default values'\n    msg=msg.format(_get_paramkind_descr(self._kind))\n    raise ValueError(msg)\n  self._default=default\n  self._annotation=annotation\n  \n  if name is _empty:\n   raise ValueError('name is a required attribute for Parameter')\n   \n  if not isinstance(name,str):\n   msg='name must be a str, not a {}'.format(type(name).__name__)\n   raise TypeError(msg)\n   \n  if name[0]=='.'and name[1:].isdigit():\n  \n  \n  \n  \n   if self._kind !=_POSITIONAL_OR_KEYWORD:\n    msg=(\n    'implicit arguments must be passed as '\n    'positional or keyword arguments, not {}'\n    )\n    msg=msg.format(_get_paramkind_descr(self._kind))\n    raise ValueError(msg)\n   self._kind=_POSITIONAL_ONLY\n   name='implicit{}'.format(name[1:])\n   \n  if not name.isidentifier():\n   raise ValueError('{!r} is not a valid parameter name'.format(name))\n   \n  self._name=name\n  \n def __reduce__(self):\n  return (type(self),\n  (self._name,self._kind),\n  {'_default':self._default,\n  '_annotation':self._annotation})\n  \n def __setstate__(self,state):\n  self._default=state['_default']\n  self._annotation=state['_annotation']\n  \n @property\n def name(self):\n  return self._name\n  \n @property\n def default(self):\n  return self._default\n  \n @property\n def annotation(self):\n  return self._annotation\n  \n @property\n def kind(self):\n  return self._kind\n  \n def replace(self,*,name=_void,kind=_void,\n annotation=_void,default=_void):\n  ''\n  \n  if name is _void:\n   name=self._name\n   \n  if kind is _void:\n   kind=self._kind\n   \n  if annotation is _void:\n   annotation=self._annotation\n   \n  if default is _void:\n   default=self._default\n   \n  return type(self)(name,kind,default=default,annotation=annotation)\n  \n def __str__(self):\n  kind=self.kind\n  formatted=self._name\n  \n  \n  if self._annotation is not _empty:\n   formatted='{}: {}'.format(formatted,\n   formatannotation(self._annotation))\n   \n  if self._default is not _empty:\n   if self._annotation is not _empty:\n    formatted='{} = {}'.format(formatted,repr(self._default))\n   else :\n    formatted='{}={}'.format(formatted,repr(self._default))\n    \n  if kind ==_VAR_POSITIONAL:\n   formatted='*'+formatted\n  elif kind ==_VAR_KEYWORD:\n   formatted='**'+formatted\n   \n  return formatted\n  \n def __repr__(self):\n  return '<{} \"{}\">'.format(self.__class__.__name__,self)\n  \n def __hash__(self):\n  return hash((self.name,self.kind,self.annotation,self.default))\n  \n def __eq__(self,other):\n  if self is other:\n   return True\n  if not isinstance(other,Parameter):\n   return NotImplemented\n  return (self._name ==other._name and\n  self._kind ==other._kind and\n  self._default ==other._default and\n  self._annotation ==other._annotation)\n  \n  \nclass BoundArguments:\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n __slots__=('arguments','_signature','__weakref__')\n \n def __init__(self,signature,arguments):\n  self.arguments=arguments\n  self._signature=signature\n  \n @property\n def signature(self):\n  return self._signature\n  \n @property\n def args(self):\n  args=[]\n  for param_name,param in self._signature.parameters.items():\n   if param.kind in (_VAR_KEYWORD,_KEYWORD_ONLY):\n    break\n    \n   try :\n    arg=self.arguments[param_name]\n   except KeyError:\n   \n   \n    break\n   else :\n    if param.kind ==_VAR_POSITIONAL:\n    \n     args.extend(arg)\n    else :\n    \n     args.append(arg)\n     \n  return tuple(args)\n  \n @property\n def kwargs(self):\n  kwargs={}\n  kwargs_started=False\n  for param_name,param in self._signature.parameters.items():\n   if not kwargs_started:\n    if param.kind in (_VAR_KEYWORD,_KEYWORD_ONLY):\n     kwargs_started=True\n    else :\n     if param_name not in self.arguments:\n      kwargs_started=True\n      continue\n      \n   if not kwargs_started:\n    continue\n    \n   try :\n    arg=self.arguments[param_name]\n   except KeyError:\n    pass\n   else :\n    if param.kind ==_VAR_KEYWORD:\n    \n     kwargs.update(arg)\n    else :\n    \n     kwargs[param_name]=arg\n     \n  return kwargs\n  \n def apply_defaults(self):\n  ''\n\n\n\n\n\n\n  \n  arguments=self.arguments\n  new_arguments=[]\n  for name,param in self._signature.parameters.items():\n   try :\n    new_arguments.append((name,arguments[name]))\n   except KeyError:\n    if param.default is not _empty:\n     val=param.default\n    elif param.kind is _VAR_POSITIONAL:\n     val=()\n    elif param.kind is _VAR_KEYWORD:\n     val={}\n    else :\n    \n    \n     continue\n    new_arguments.append((name,val))\n  self.arguments=OrderedDict(new_arguments)\n  \n def __eq__(self,other):\n  if self is other:\n   return True\n  if not isinstance(other,BoundArguments):\n   return NotImplemented\n  return (self.signature ==other.signature and\n  self.arguments ==other.arguments)\n  \n def __setstate__(self,state):\n  self._signature=state['_signature']\n  self.arguments=state['arguments']\n  \n def __getstate__(self):\n  return {'_signature':self._signature,'arguments':self.arguments}\n  \n def __repr__(self):\n  args=[]\n  for arg,value in self.arguments.items():\n   args.append('{}={!r}'.format(arg,value))\n  return '<{} ({})>'.format(self.__class__.__name__,', '.join(args))\n  \n  \nclass Signature:\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n __slots__=('_return_annotation','_parameters')\n \n _parameter_cls=Parameter\n _bound_arguments_cls=BoundArguments\n \n empty=_empty\n \n def __init__(self,parameters=None ,*,return_annotation=_empty,\n __validate_parameters__=True ):\n  ''\n\n  \n  \n  if parameters is None :\n   params=OrderedDict()\n  else :\n   if __validate_parameters__:\n    params=OrderedDict()\n    top_kind=_POSITIONAL_ONLY\n    kind_defaults=False\n    \n    for idx,param in enumerate(parameters):\n     kind=param.kind\n     name=param.name\n     \n     if kind <top_kind:\n      msg=(\n      'wrong parameter order: {} parameter before {} '\n      'parameter'\n      )\n      msg=msg.format(_get_paramkind_descr(top_kind),\n      _get_paramkind_descr(kind))\n      raise ValueError(msg)\n     elif kind >top_kind:\n      kind_defaults=False\n      top_kind=kind\n      \n     if kind in (_POSITIONAL_ONLY,_POSITIONAL_OR_KEYWORD):\n      if param.default is _empty:\n       if kind_defaults:\n       \n       \n       \n        msg='non-default argument follows default '\\\n        'argument'\n        raise ValueError(msg)\n      else :\n      \n       kind_defaults=True\n       \n     if name in params:\n      msg='duplicate parameter name: {!r}'.format(name)\n      raise ValueError(msg)\n      \n     params[name]=param\n   else :\n    params=OrderedDict(((param.name,param)\n    for param in parameters))\n    \n  self._parameters=types.MappingProxyType(params)\n  self._return_annotation=return_annotation\n  \n @classmethod\n def from_function(cls,func):\n  ''\n  \n  warnings.warn(\"inspect.Signature.from_function() is deprecated, \"\n  \"use Signature.from_callable()\",\n  DeprecationWarning,stacklevel=2)\n  return _signature_from_function(cls,func)\n  \n @classmethod\n def from_builtin(cls,func):\n  ''\n  \n  warnings.warn(\"inspect.Signature.from_builtin() is deprecated, \"\n  \"use Signature.from_callable()\",\n  DeprecationWarning,stacklevel=2)\n  return _signature_from_builtin(cls,func)\n  \n @classmethod\n def from_callable(cls,obj,*,follow_wrapped=True ):\n  ''\n  return _signature_from_callable(obj,sigcls=cls,\n  follow_wrapper_chains=follow_wrapped)\n  \n @property\n def parameters(self):\n  return self._parameters\n  \n @property\n def return_annotation(self):\n  return self._return_annotation\n  \n def replace(self,*,parameters=_void,return_annotation=_void):\n  ''\n\n\n  \n  \n  if parameters is _void:\n   parameters=self.parameters.values()\n   \n  if return_annotation is _void:\n   return_annotation=self._return_annotation\n   \n  return type(self)(parameters,\n  return_annotation=return_annotation)\n  \n def _hash_basis(self):\n  params=tuple(param for param in self.parameters.values()\n  if param.kind !=_KEYWORD_ONLY)\n  \n  kwo_params={param.name:param for param in self.parameters.values()\n  if param.kind ==_KEYWORD_ONLY}\n  \n  return params,kwo_params,self.return_annotation\n  \n def __hash__(self):\n  params,kwo_params,return_annotation=self._hash_basis()\n  kwo_params=frozenset(kwo_params.values())\n  return hash((params,kwo_params,return_annotation))\n  \n def __eq__(self,other):\n  if self is other:\n   return True\n  if not isinstance(other,Signature):\n   return NotImplemented\n  return self._hash_basis()==other._hash_basis()\n  \n def _bind(self,args,kwargs,*,partial=False ):\n  ''\n  \n  arguments=OrderedDict()\n  \n  parameters=iter(self.parameters.values())\n  parameters_ex=()\n  arg_vals=iter(args)\n  \n  while True :\n  \n  \n   try :\n    arg_val=next(arg_vals)\n   except StopIteration:\n   \n    try :\n     param=next(parameters)\n    except StopIteration:\n    \n    \n     break\n    else :\n     if param.kind ==_VAR_POSITIONAL:\n     \n     \n      break\n     elif param.name in kwargs:\n      if param.kind ==_POSITIONAL_ONLY:\n       msg='{arg!r} parameter is positional only, '\\\n       'but was passed as a keyword'\n       msg=msg.format(arg=param.name)\n       raise TypeError(msg)from None\n      parameters_ex=(param,)\n      break\n     elif (param.kind ==_VAR_KEYWORD or\n     param.default is not _empty):\n     \n     \n     \n      parameters_ex=(param,)\n      break\n     else :\n     \n     \n      if partial:\n       parameters_ex=(param,)\n       break\n      else :\n       msg='missing a required argument: {arg!r}'\n       msg=msg.format(arg=param.name)\n       raise TypeError(msg)from None\n   else :\n   \n    try :\n     param=next(parameters)\n    except StopIteration:\n     raise TypeError('too many positional arguments')from None\n    else :\n     if param.kind in (_VAR_KEYWORD,_KEYWORD_ONLY):\n     \n     \n      raise TypeError(\n      'too many positional arguments')from None\n      \n     if param.kind ==_VAR_POSITIONAL:\n     \n     \n     \n      values=[arg_val]\n      values.extend(arg_vals)\n      arguments[param.name]=tuple(values)\n      break\n      \n     if param.name in kwargs:\n      raise TypeError(\n      'multiple values for argument {arg!r}'.format(\n      arg=param.name))from None\n      \n     arguments[param.name]=arg_val\n     \n     \n     \n  kwargs_param=None\n  for param in itertools.chain(parameters_ex,parameters):\n   if param.kind ==_VAR_KEYWORD:\n   \n    kwargs_param=param\n    continue\n    \n   if param.kind ==_VAR_POSITIONAL:\n   \n   \n   \n    continue\n    \n   param_name=param.name\n   try :\n    arg_val=kwargs.pop(param_name)\n   except KeyError:\n   \n   \n   \n   \n    if (not partial and param.kind !=_VAR_POSITIONAL and\n    param.default is _empty):\n     raise TypeError('missing a required argument: {arg!r}'.\\\n     format(arg=param_name))from None\n     \n   else :\n    if param.kind ==_POSITIONAL_ONLY:\n    \n    \n    \n     raise TypeError('{arg!r} parameter is positional only, '\n     'but was passed as a keyword'.\\\n     format(arg=param.name))\n     \n    arguments[param_name]=arg_val\n    \n  if kwargs:\n   if kwargs_param is not None :\n   \n    arguments[kwargs_param.name]=kwargs\n   else :\n    raise TypeError(\n    'got an unexpected keyword argument {arg!r}'.format(\n    arg=next(iter(kwargs))))\n    \n  return self._bound_arguments_cls(self,arguments)\n  \n def bind(*args,**kwargs):\n  ''\n\n\n  \n  return args[0]._bind(args[1:],kwargs)\n  \n def bind_partial(*args,**kwargs):\n  ''\n\n\n  \n  return args[0]._bind(args[1:],kwargs,partial=True )\n  \n def __reduce__(self):\n  return (type(self),\n  (tuple(self._parameters.values()),),\n  {'_return_annotation':self._return_annotation})\n  \n def __setstate__(self,state):\n  self._return_annotation=state['_return_annotation']\n  \n def __repr__(self):\n  return '<{} {}>'.format(self.__class__.__name__,self)\n  \n def __str__(self):\n  result=[]\n  render_pos_only_separator=False\n  render_kw_only_separator=True\n  for param in self.parameters.values():\n   formatted=str(param)\n   \n   kind=param.kind\n   \n   if kind ==_POSITIONAL_ONLY:\n    render_pos_only_separator=True\n   elif render_pos_only_separator:\n   \n   \n    result.append('/')\n    render_pos_only_separator=False\n    \n   if kind ==_VAR_POSITIONAL:\n   \n   \n    render_kw_only_separator=False\n   elif kind ==_KEYWORD_ONLY and render_kw_only_separator:\n   \n   \n   \n    result.append('*')\n    \n    \n    render_kw_only_separator=False\n    \n   result.append(formatted)\n   \n  if render_pos_only_separator:\n  \n  \n   result.append('/')\n   \n  rendered='({})'.format(', '.join(result))\n  \n  if self.return_annotation is not _empty:\n   anno=formatannotation(self.return_annotation)\n   rendered +=' -> {}'.format(anno)\n   \n  return rendered\n  \n  \ndef signature(obj,*,follow_wrapped=True ):\n ''\n return Signature.from_callable(obj,follow_wrapped=follow_wrapped)\n \n \ndef _main():\n ''\n import argparse\n import importlib\n \n parser=argparse.ArgumentParser()\n parser.add_argument(\n 'object',\n help=\"The object to be analysed. \"\n \"It supports the 'module:qualname' syntax\")\n parser.add_argument(\n '-d','--details',action='store_true',\n help='Display info about the module rather than its source code')\n \n args=parser.parse_args()\n \n target=args.object\n mod_name,has_attrs,attrs=target.partition(\":\")\n try :\n  obj=module=importlib.import_module(mod_name)\n except Exception as exc:\n  msg=\"Failed to import {} ({}: {})\".format(mod_name,\n  type(exc).__name__,\n  exc)\n  print(msg,file=sys.stderr)\n  exit(2)\n  \n if has_attrs:\n  parts=attrs.split(\".\")\n  obj=module\n  for part in parts:\n   obj=getattr(obj,part)\n   \n if module.__name__ in sys.builtin_module_names:\n  print(\"Can't get info for builtin modules.\",file=sys.stderr)\n  exit(1)\n  \n if args.details:\n  print('Target: {}'.format(target))\n  print('Origin: {}'.format(getsourcefile(module)))\n  print('Cached: {}'.format(module.__cached__))\n  if obj is module:\n   print('Loader: {}'.format(repr(module.__loader__)))\n   if hasattr(module,'__path__'):\n    print('Submodule search path: {}'.format(module.__path__))\n  else :\n   try :\n    __,lineno=findsource(obj)\n   except Exception:\n    pass\n   else :\n    print('Line: {}'.format(lineno))\n    \n  print('\\n')\n else :\n  print(getsource(obj))\n  \n  \nif __name__ ==\"__main__\":\n _main()\n", ["abc", "argparse", "ast", "builtins", "collections", "collections.abc", "dis", "enum", "functools", "importlib", "importlib.machinery", "itertools", "linecache", "operator", "os", "re", "sys", "token", "tokenize", "types", "warnings"]], "io": [".py", "''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n__author__=(\"Guido van Rossum <guido@python.org>, \"\n\"Mike Verdone <mike.verdone@gmail.com>, \"\n\"Mark Russell <mark.russell@zen.co.uk>, \"\n\"Antoine Pitrou <solipsis@pitrou.net>, \"\n\"Amaury Forgeot d'Arc <amauryfa@gmail.com>, \"\n\"Benjamin Peterson <benjamin@python.org>\")\n\n__all__=[\"BlockingIOError\",\"open\",\"IOBase\",\"RawIOBase\",\"FileIO\",\n\"BytesIO\",\"StringIO\",\"BufferedIOBase\",\n\"BufferedReader\",\"BufferedWriter\",\"BufferedRWPair\",\n\"BufferedRandom\",\"TextIOBase\",\"TextIOWrapper\",\n\"UnsupportedOperation\",\"SEEK_SET\",\"SEEK_CUR\",\"SEEK_END\"]\n\n\nimport _io\nimport abc\n\nfrom _io import (DEFAULT_BUFFER_SIZE,BlockingIOError,UnsupportedOperation,\nopen,FileIO,BytesIO,StringIO,BufferedReader,\nBufferedWriter,BufferedRWPair,BufferedRandom,\nIncrementalNewlineDecoder,TextIOWrapper)\n\nOpenWrapper=_io.open\n\n\nUnsupportedOperation.__module__=\"io\"\n\n\nSEEK_SET=0\nSEEK_CUR=1\nSEEK_END=2\n\n\n\n\nclass IOBase(_io._IOBase,metaclass=abc.ABCMeta):\n __doc__=_io._IOBase.__doc__\n \nclass RawIOBase(_io._RawIOBase,IOBase):\n __doc__=_io._RawIOBase.__doc__\n \nclass BufferedIOBase(_io._BufferedIOBase,IOBase):\n __doc__=_io._BufferedIOBase.__doc__\n \nclass TextIOBase(_io._TextIOBase,IOBase):\n __doc__=_io._TextIOBase.__doc__\n \nRawIOBase.register(FileIO)\n\nfor klass in (BytesIO,BufferedReader,BufferedWriter,BufferedRandom,\nBufferedRWPair):\n BufferedIOBase.register(klass)\n \nfor klass in (StringIO,TextIOWrapper):\n TextIOBase.register(klass)\ndel klass\n\ntry :\n from _io import _WindowsConsoleIO\nexcept ImportError:\n pass\nelse :\n RawIOBase.register(_WindowsConsoleIO)\n", ["_io", "abc"]], "ipaddress": [".py", "\n\n\n\"\"\"A fast, lightweight IPv4/IPv6 manipulation library in Python.\n\nThis library is used to create/poke/manipulate IPv4 and IPv6 addresses\nand networks.\n\n\"\"\"\n\n__version__='1.0'\n\n\nimport functools\n\nIPV4LENGTH=32\nIPV6LENGTH=128\n\nclass AddressValueError(ValueError):\n ''\n \n \nclass NetmaskValueError(ValueError):\n ''\n \n \ndef ip_address(address):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n try :\n  return IPv4Address(address)\n except (AddressValueError,NetmaskValueError):\n  pass\n  \n try :\n  return IPv6Address(address)\n except (AddressValueError,NetmaskValueError):\n  pass\n  \n raise ValueError('%r does not appear to be an IPv4 or IPv6 address'%\n address)\n \n \ndef ip_network(address,strict=True ):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n try :\n  return IPv4Network(address,strict)\n except (AddressValueError,NetmaskValueError):\n  pass\n  \n try :\n  return IPv6Network(address,strict)\n except (AddressValueError,NetmaskValueError):\n  pass\n  \n raise ValueError('%r does not appear to be an IPv4 or IPv6 network'%\n address)\n \n \ndef ip_interface(address):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n try :\n  return IPv4Interface(address)\n except (AddressValueError,NetmaskValueError):\n  pass\n  \n try :\n  return IPv6Interface(address)\n except (AddressValueError,NetmaskValueError):\n  pass\n  \n raise ValueError('%r does not appear to be an IPv4 or IPv6 interface'%\n address)\n \n \ndef v4_int_to_packed(address):\n ''\n\n\n\n\n\n\n\n\n\n\n\n \n try :\n  return address.to_bytes(4,'big')\n except OverflowError:\n  raise ValueError(\"Address negative or too large for IPv4\")\n  \n  \ndef v6_int_to_packed(address):\n ''\n\n\n\n\n\n\n\n \n try :\n  return address.to_bytes(16,'big')\n except OverflowError:\n  raise ValueError(\"Address negative or too large for IPv6\")\n  \n  \ndef _split_optional_netmask(address):\n ''\n addr=str(address).split('/')\n if len(addr)>2:\n  raise AddressValueError(\"Only one '/' permitted in %r\"%address)\n return addr\n \n \ndef _find_address_range(addresses):\n ''\n\n\n\n\n\n\n\n \n it=iter(addresses)\n first=last=next(it)\n for ip in it:\n  if ip._ip !=last._ip+1:\n   yield first,last\n   first=ip\n  last=ip\n yield first,last\n \n \ndef _count_righthand_zero_bits(number,bits):\n ''\n\n\n\n\n\n\n\n\n \n if number ==0:\n  return bits\n return min(bits,(~number&(number -1)).bit_length())\n \n \ndef summarize_address_range(first,last):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n if (not (isinstance(first,_BaseAddress)and\n isinstance(last,_BaseAddress))):\n  raise TypeError('first and last must be IP addresses, not networks')\n if first.version !=last.version:\n  raise TypeError(\"%s and %s are not of the same version\"%(\n  first,last))\n if first >last:\n  raise ValueError('last IP address must be greater than first')\n  \n if first.version ==4:\n  ip=IPv4Network\n elif first.version ==6:\n  ip=IPv6Network\n else :\n  raise ValueError('unknown IP version')\n  \n ip_bits=first._max_prefixlen\n first_int=first._ip\n last_int=last._ip\n while first_int <=last_int:\n  nbits=min(_count_righthand_zero_bits(first_int,ip_bits),\n  (last_int -first_int+1).bit_length()-1)\n  net=ip((first_int,ip_bits -nbits))\n  yield net\n  first_int +=1 <<nbits\n  if first_int -1 ==ip._ALL_ONES:\n   break\n   \n   \ndef _collapse_addresses_internal(addresses):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n to_merge=list(addresses)\n subnets={}\n while to_merge:\n  net=to_merge.pop()\n  supernet=net.supernet()\n  existing=subnets.get(supernet)\n  if existing is None :\n   subnets[supernet]=net\n  elif existing !=net:\n  \n   del subnets[supernet]\n   to_merge.append(supernet)\n   \n last=None\n for net in sorted(subnets.values()):\n  if last is not None :\n  \n  \n   if last.broadcast_address >=net.broadcast_address:\n    continue\n  yield net\n  last=net\n  \n  \ndef collapse_addresses(addresses):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n addrs=[]\n ips=[]\n nets=[]\n \n \n for ip in addresses:\n  if isinstance(ip,_BaseAddress):\n   if ips and ips[-1]._version !=ip._version:\n    raise TypeError(\"%s and %s are not of the same version\"%(\n    ip,ips[-1]))\n   ips.append(ip)\n  elif ip._prefixlen ==ip._max_prefixlen:\n   if ips and ips[-1]._version !=ip._version:\n    raise TypeError(\"%s and %s are not of the same version\"%(\n    ip,ips[-1]))\n   try :\n    ips.append(ip.ip)\n   except AttributeError:\n    ips.append(ip.network_address)\n  else :\n   if nets and nets[-1]._version !=ip._version:\n    raise TypeError(\"%s and %s are not of the same version\"%(\n    ip,nets[-1]))\n   nets.append(ip)\n   \n   \n ips=sorted(set(ips))\n \n \n if ips:\n  for first,last in _find_address_range(ips):\n   addrs.extend(summarize_address_range(first,last))\n   \n return _collapse_addresses_internal(addrs+nets)\n \n \ndef get_mixed_type_key(obj):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n if isinstance(obj,_BaseNetwork):\n  return obj._get_networks_key()\n elif isinstance(obj,_BaseAddress):\n  return obj._get_address_key()\n return NotImplemented\n \n \nclass _IPAddressBase:\n\n ''\n \n __slots__=()\n \n @property\n def exploded(self):\n  ''\n  return self._explode_shorthand_ip_string()\n  \n @property\n def compressed(self):\n  ''\n  return str(self)\n  \n @property\n def reverse_pointer(self):\n  ''\n\n\n\n\n\n  \n  return self._reverse_pointer()\n  \n @property\n def version(self):\n  msg='%200s has no version specified'%(type(self),)\n  raise NotImplementedError(msg)\n  \n def _check_int_address(self,address):\n  if address <0:\n   msg=\"%d (< 0) is not permitted as an IPv%d address\"\n   raise AddressValueError(msg %(address,self._version))\n  if address >self._ALL_ONES:\n   msg=\"%d (>= 2**%d) is not permitted as an IPv%d address\"\n   raise AddressValueError(msg %(address,self._max_prefixlen,\n   self._version))\n   \n def _check_packed_address(self,address,expected_len):\n  address_len=len(address)\n  if address_len !=expected_len:\n   msg=\"%r (len %d != %d) is not permitted as an IPv%d address\"\n   raise AddressValueError(msg %(address,address_len,\n   expected_len,self._version))\n   \n @classmethod\n def _ip_int_from_prefix(cls,prefixlen):\n  ''\n\n\n\n\n\n\n\n  \n  return cls._ALL_ONES ^(cls._ALL_ONES >>prefixlen)\n  \n @classmethod\n def _prefix_from_ip_int(cls,ip_int):\n  ''\n\n\n\n\n\n\n\n\n\n  \n  trailing_zeroes=_count_righthand_zero_bits(ip_int,\n  cls._max_prefixlen)\n  prefixlen=cls._max_prefixlen -trailing_zeroes\n  leading_ones=ip_int >>trailing_zeroes\n  all_ones=(1 <<prefixlen)-1\n  if leading_ones !=all_ones:\n   byteslen=cls._max_prefixlen //8\n   details=ip_int.to_bytes(byteslen,'big')\n   msg='Netmask pattern %r mixes zeroes & ones'\n   raise ValueError(msg %details)\n  return prefixlen\n  \n @classmethod\n def _report_invalid_netmask(cls,netmask_str):\n  msg='%r is not a valid netmask'%netmask_str\n  raise NetmaskValueError(msg)from None\n  \n @classmethod\n def _prefix_from_prefix_string(cls,prefixlen_str):\n  ''\n\n\n\n\n\n\n\n\n\n  \n  \n  \n  if not _BaseV4._DECIMAL_DIGITS.issuperset(prefixlen_str):\n   cls._report_invalid_netmask(prefixlen_str)\n  try :\n   prefixlen=int(prefixlen_str)\n  except ValueError:\n   cls._report_invalid_netmask(prefixlen_str)\n  if not (0 <=prefixlen <=cls._max_prefixlen):\n   cls._report_invalid_netmask(prefixlen_str)\n  return prefixlen\n  \n @classmethod\n def _prefix_from_ip_string(cls,ip_str):\n  ''\n\n\n\n\n\n\n\n\n\n  \n  \n  try :\n   ip_int=cls._ip_int_from_string(ip_str)\n  except AddressValueError:\n   cls._report_invalid_netmask(ip_str)\n   \n   \n   \n   \n  try :\n   return cls._prefix_from_ip_int(ip_int)\n  except ValueError:\n   pass\n   \n   \n  ip_int ^=cls._ALL_ONES\n  try :\n   return cls._prefix_from_ip_int(ip_int)\n  except ValueError:\n   cls._report_invalid_netmask(ip_str)\n   \n def __reduce__(self):\n  return self.__class__,(str(self),)\n  \n  \n@functools.total_ordering\nclass _BaseAddress(_IPAddressBase):\n\n ''\n\n\n\n \n \n __slots__=()\n \n def __int__(self):\n  return self._ip\n  \n def __eq__(self,other):\n  try :\n   return (self._ip ==other._ip\n   and self._version ==other._version)\n  except AttributeError:\n   return NotImplemented\n   \n def __lt__(self,other):\n  if not isinstance(other,_BaseAddress):\n   return NotImplemented\n  if self._version !=other._version:\n   raise TypeError('%s and %s are not of the same version'%(\n   self,other))\n  if self._ip !=other._ip:\n   return self._ip <other._ip\n  return False\n  \n  \n  \n def __add__(self,other):\n  if not isinstance(other,int):\n   return NotImplemented\n  return self.__class__(int(self)+other)\n  \n def __sub__(self,other):\n  if not isinstance(other,int):\n   return NotImplemented\n  return self.__class__(int(self)-other)\n  \n def __repr__(self):\n  return '%s(%r)'%(self.__class__.__name__,str(self))\n  \n def __str__(self):\n  return str(self._string_from_ip_int(self._ip))\n  \n def __hash__(self):\n  return hash(hex(int(self._ip)))\n  \n def _get_address_key(self):\n  return (self._version,self)\n  \n def __reduce__(self):\n  return self.__class__,(self._ip,)\n  \n  \n@functools.total_ordering\nclass _BaseNetwork(_IPAddressBase):\n\n ''\n\n\n\n\n \n def __init__(self,address):\n  self._cache={}\n  \n def __repr__(self):\n  return '%s(%r)'%(self.__class__.__name__,str(self))\n  \n def __str__(self):\n  return '%s/%d'%(self.network_address,self.prefixlen)\n  \n def hosts(self):\n  ''\n\n\n\n\n  \n  network=int(self.network_address)\n  broadcast=int(self.broadcast_address)\n  for x in range(network+1,broadcast):\n   yield self._address_class(x)\n   \n def __iter__(self):\n  network=int(self.network_address)\n  broadcast=int(self.broadcast_address)\n  for x in range(network,broadcast+1):\n   yield self._address_class(x)\n   \n def __getitem__(self,n):\n  network=int(self.network_address)\n  broadcast=int(self.broadcast_address)\n  if n >=0:\n   if network+n >broadcast:\n    raise IndexError('address out of range')\n   return self._address_class(network+n)\n  else :\n   n +=1\n   if broadcast+n <network:\n    raise IndexError('address out of range')\n   return self._address_class(broadcast+n)\n   \n def __lt__(self,other):\n  if not isinstance(other,_BaseNetwork):\n   return NotImplemented\n  if self._version !=other._version:\n   raise TypeError('%s and %s are not of the same version'%(\n   self,other))\n  if self.network_address !=other.network_address:\n   return self.network_address <other.network_address\n  if self.netmask !=other.netmask:\n   return self.netmask <other.netmask\n  return False\n  \n def __eq__(self,other):\n  try :\n   return (self._version ==other._version and\n   self.network_address ==other.network_address and\n   int(self.netmask)==int(other.netmask))\n  except AttributeError:\n   return NotImplemented\n   \n def __hash__(self):\n  return hash(int(self.network_address)^int(self.netmask))\n  \n def __contains__(self,other):\n \n  if self._version !=other._version:\n   return False\n   \n  if isinstance(other,_BaseNetwork):\n   return False\n   \n  else :\n  \n   return (int(self.network_address)<=int(other._ip)<=\n   int(self.broadcast_address))\n   \n def overlaps(self,other):\n  ''\n  return self.network_address in other or (\n  self.broadcast_address in other or (\n  other.network_address in self or (\n  other.broadcast_address in self)))\n  \n @property\n def broadcast_address(self):\n  x=self._cache.get('broadcast_address')\n  if x is None :\n   x=self._address_class(int(self.network_address)|\n   int(self.hostmask))\n   self._cache['broadcast_address']=x\n  return x\n  \n @property\n def hostmask(self):\n  x=self._cache.get('hostmask')\n  if x is None :\n   x=self._address_class(int(self.netmask)^self._ALL_ONES)\n   self._cache['hostmask']=x\n  return x\n  \n @property\n def with_prefixlen(self):\n  return '%s/%d'%(self.network_address,self._prefixlen)\n  \n @property\n def with_netmask(self):\n  return '%s/%s'%(self.network_address,self.netmask)\n  \n @property\n def with_hostmask(self):\n  return '%s/%s'%(self.network_address,self.hostmask)\n  \n @property\n def num_addresses(self):\n  ''\n  return int(self.broadcast_address)-int(self.network_address)+1\n  \n @property\n def _address_class(self):\n \n \n \n  msg='%200s has no associated address class'%(type(self),)\n  raise NotImplementedError(msg)\n  \n @property\n def prefixlen(self):\n  return self._prefixlen\n  \n def address_exclude(self,other):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  if not self._version ==other._version:\n   raise TypeError(\"%s and %s are not of the same version\"%(\n   self,other))\n   \n  if not isinstance(other,_BaseNetwork):\n   raise TypeError(\"%s is not a network object\"%other)\n   \n  if not other.subnet_of(self):\n   raise ValueError('%s not contained in %s'%(other,self))\n  if other ==self:\n   return\n   \n   \n  other=other.__class__('%s/%s'%(other.network_address,\n  other.prefixlen))\n  \n  s1,s2=self.subnets()\n  while s1 !=other and s2 !=other:\n   if other.subnet_of(s1):\n    yield s2\n    s1,s2=s1.subnets()\n   elif other.subnet_of(s2):\n    yield s1\n    s1,s2=s2.subnets()\n   else :\n   \n    raise AssertionError('Error performing exclusion: '\n    's1: %s s2: %s other: %s'%\n    (s1,s2,other))\n  if s1 ==other:\n   yield s2\n  elif s2 ==other:\n   yield s1\n  else :\n  \n   raise AssertionError('Error performing exclusion: '\n   's1: %s s2: %s other: %s'%\n   (s1,s2,other))\n   \n def compare_networks(self,other):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  \n  if self._version !=other._version:\n   raise TypeError('%s and %s are not of the same type'%(\n   self,other))\n   \n  if self.network_address <other.network_address:\n   return -1\n  if self.network_address >other.network_address:\n   return 1\n   \n  if self.netmask <other.netmask:\n   return -1\n  if self.netmask >other.netmask:\n   return 1\n  return 0\n  \n def _get_networks_key(self):\n  ''\n\n\n\n\n\n  \n  return (self._version,self.network_address,self.netmask)\n  \n def subnets(self,prefixlen_diff=1,new_prefix=None ):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  if self._prefixlen ==self._max_prefixlen:\n   yield self\n   return\n   \n  if new_prefix is not None :\n   if new_prefix <self._prefixlen:\n    raise ValueError('new prefix must be longer')\n   if prefixlen_diff !=1:\n    raise ValueError('cannot set prefixlen_diff and new_prefix')\n   prefixlen_diff=new_prefix -self._prefixlen\n   \n  if prefixlen_diff <0:\n   raise ValueError('prefix length diff must be > 0')\n  new_prefixlen=self._prefixlen+prefixlen_diff\n  \n  if new_prefixlen >self._max_prefixlen:\n   raise ValueError(\n   'prefix length diff %d is invalid for netblock %s'%(\n   new_prefixlen,self))\n   \n  start=int(self.network_address)\n  end=int(self.broadcast_address)+1\n  step=(int(self.hostmask)+1)>>prefixlen_diff\n  for new_addr in range(start,end,step):\n   current=self.__class__((new_addr,new_prefixlen))\n   yield current\n   \n def supernet(self,prefixlen_diff=1,new_prefix=None ):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  if self._prefixlen ==0:\n   return self\n   \n  if new_prefix is not None :\n   if new_prefix >self._prefixlen:\n    raise ValueError('new prefix must be shorter')\n   if prefixlen_diff !=1:\n    raise ValueError('cannot set prefixlen_diff and new_prefix')\n   prefixlen_diff=self._prefixlen -new_prefix\n   \n  new_prefixlen=self.prefixlen -prefixlen_diff\n  if new_prefixlen <0:\n   raise ValueError(\n   'current prefixlen is %d, cannot have a prefixlen_diff of %d'%\n   (self.prefixlen,prefixlen_diff))\n  return self.__class__((\n  int(self.network_address)&(int(self.netmask)<<prefixlen_diff),\n  new_prefixlen\n  ))\n  \n @property\n def is_multicast(self):\n  ''\n\n\n\n\n\n  \n  return (self.network_address.is_multicast and\n  self.broadcast_address.is_multicast)\n  \n @staticmethod\n def _is_subnet_of(a,b):\n  try :\n  \n   if a._version !=b._version:\n    raise TypeError(f\"{a} and {b} are not of the same version\")\n   return (b.network_address <=a.network_address and\n   b.broadcast_address >=a.broadcast_address)\n  except AttributeError:\n   raise TypeError(f\"Unable to test subnet containment \"\n   f\"between {a} and {b}\")\n   \n def subnet_of(self,other):\n  ''\n  return self._is_subnet_of(self,other)\n  \n def supernet_of(self,other):\n  ''\n  return self._is_subnet_of(other,self)\n  \n @property\n def is_reserved(self):\n  ''\n\n\n\n\n\n  \n  return (self.network_address.is_reserved and\n  self.broadcast_address.is_reserved)\n  \n @property\n def is_link_local(self):\n  ''\n\n\n\n\n  \n  return (self.network_address.is_link_local and\n  self.broadcast_address.is_link_local)\n  \n @property\n def is_private(self):\n  ''\n\n\n\n\n\n  \n  return (self.network_address.is_private and\n  self.broadcast_address.is_private)\n  \n @property\n def is_global(self):\n  ''\n\n\n\n\n\n  \n  return not self.is_private\n  \n @property\n def is_unspecified(self):\n  ''\n\n\n\n\n\n  \n  return (self.network_address.is_unspecified and\n  self.broadcast_address.is_unspecified)\n  \n @property\n def is_loopback(self):\n  ''\n\n\n\n\n\n  \n  return (self.network_address.is_loopback and\n  self.broadcast_address.is_loopback)\n  \n  \nclass _BaseV4:\n\n ''\n\n\n\n\n \n \n __slots__=()\n _version=4\n \n _ALL_ONES=(2 **IPV4LENGTH)-1\n _DECIMAL_DIGITS=frozenset('0123456789')\n \n \n _valid_mask_octets=frozenset({255,254,252,248,240,224,192,128,0})\n \n _max_prefixlen=IPV4LENGTH\n \n \n _netmask_cache={}\n \n def _explode_shorthand_ip_string(self):\n  return str(self)\n  \n @classmethod\n def _make_netmask(cls,arg):\n  ''\n\n\n\n\n\n  \n  if arg not in cls._netmask_cache:\n   if isinstance(arg,int):\n    prefixlen=arg\n   else :\n    try :\n    \n     prefixlen=cls._prefix_from_prefix_string(arg)\n    except NetmaskValueError:\n    \n    \n     prefixlen=cls._prefix_from_ip_string(arg)\n   netmask=IPv4Address(cls._ip_int_from_prefix(prefixlen))\n   cls._netmask_cache[arg]=netmask,prefixlen\n  return cls._netmask_cache[arg]\n  \n @classmethod\n def _ip_int_from_string(cls,ip_str):\n  ''\n\n\n\n\n\n\n\n\n\n\n  \n  if not ip_str:\n   raise AddressValueError('Address cannot be empty')\n   \n  octets=ip_str.split('.')\n  if len(octets)!=4:\n   raise AddressValueError(\"Expected 4 octets in %r\"%ip_str)\n   \n  try :\n   return int.from_bytes(map(cls._parse_octet,octets),'big')\n  except ValueError as exc:\n   raise AddressValueError(\"%s in %r\"%(exc,ip_str))from None\n   \n @classmethod\n def _parse_octet(cls,octet_str):\n  ''\n\n\n\n\n\n\n\n\n\n\n  \n  if not octet_str:\n   raise ValueError(\"Empty octet not permitted\")\n   \n  if not cls._DECIMAL_DIGITS.issuperset(octet_str):\n   msg=\"Only decimal digits permitted in %r\"\n   raise ValueError(msg %octet_str)\n   \n   \n  if len(octet_str)>3:\n   msg=\"At most 3 characters permitted in %r\"\n   raise ValueError(msg %octet_str)\n   \n  octet_int=int(octet_str,10)\n  \n  \n  \n  if octet_int >7 and octet_str[0]=='0':\n   msg=\"Ambiguous (octal/decimal) value in %r not permitted\"\n   raise ValueError(msg %octet_str)\n  if octet_int >255:\n   raise ValueError(\"Octet %d (> 255) not permitted\"%octet_int)\n  return octet_int\n  \n @classmethod\n def _string_from_ip_int(cls,ip_int):\n  ''\n\n\n\n\n\n\n\n  \n  return '.'.join(map(str,ip_int.to_bytes(4,'big')))\n  \n def _is_valid_netmask(self,netmask):\n  ''\n\n\n\n\n\n\n\n\n\n  \n  mask=netmask.split('.')\n  if len(mask)==4:\n   try :\n    for x in mask:\n     if int(x)not in self._valid_mask_octets:\n      return False\n   except ValueError:\n   \n    return False\n   for idx,y in enumerate(mask):\n    if idx >0 and y >mask[idx -1]:\n     return False\n   return True\n  try :\n   netmask=int(netmask)\n  except ValueError:\n   return False\n  return 0 <=netmask <=self._max_prefixlen\n  \n def _is_hostmask(self,ip_str):\n  ''\n\n\n\n\n\n\n\n  \n  bits=ip_str.split('.')\n  try :\n   parts=[x for x in map(int,bits)if x in self._valid_mask_octets]\n  except ValueError:\n   return False\n  if len(parts)!=len(bits):\n   return False\n  if parts[0]<parts[-1]:\n   return True\n  return False\n  \n def _reverse_pointer(self):\n  ''\n\n\n\n  \n  reverse_octets=str(self).split('.')[::-1]\n  return '.'.join(reverse_octets)+'.in-addr.arpa'\n  \n @property\n def max_prefixlen(self):\n  return self._max_prefixlen\n  \n @property\n def version(self):\n  return self._version\n  \n  \nclass IPv4Address(_BaseV4,_BaseAddress):\n\n ''\n \n __slots__=('_ip','__weakref__')\n \n def __init__(self,address):\n \n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  \n  if isinstance(address,int):\n   self._check_int_address(address)\n   self._ip=address\n   return\n   \n   \n  if isinstance(address,bytes):\n   self._check_packed_address(address,4)\n   self._ip=int.from_bytes(address,'big')\n   return\n   \n   \n   \n  addr_str=str(address)\n  if '/'in addr_str:\n   raise AddressValueError(\"Unexpected '/' in %r\"%address)\n  self._ip=self._ip_int_from_string(addr_str)\n  \n @property\n def packed(self):\n  ''\n  return v4_int_to_packed(self._ip)\n  \n @property\n def is_reserved(self):\n  ''\n\n\n\n\n\n  \n  return self in self._constants._reserved_network\n  \n @property\n @functools.lru_cache()\n def is_private(self):\n  ''\n\n\n\n\n\n  \n  return any(self in net for net in self._constants._private_networks)\n  \n @property\n @functools.lru_cache()\n def is_global(self):\n  return self not in self._constants._public_network and not self.is_private\n  \n @property\n def is_multicast(self):\n  ''\n\n\n\n\n\n  \n  return self in self._constants._multicast_network\n  \n @property\n def is_unspecified(self):\n  ''\n\n\n\n\n\n  \n  return self ==self._constants._unspecified_address\n  \n @property\n def is_loopback(self):\n  ''\n\n\n\n\n  \n  return self in self._constants._loopback_network\n  \n @property\n def is_link_local(self):\n  ''\n\n\n\n\n  \n  return self in self._constants._linklocal_network\n  \n  \nclass IPv4Interface(IPv4Address):\n\n def __init__(self,address):\n  if isinstance(address,(bytes,int)):\n   IPv4Address.__init__(self,address)\n   self.network=IPv4Network(self._ip)\n   self._prefixlen=self._max_prefixlen\n   return\n   \n  if isinstance(address,tuple):\n   IPv4Address.__init__(self,address[0])\n   if len(address)>1:\n    self._prefixlen=int(address[1])\n   else :\n    self._prefixlen=self._max_prefixlen\n    \n   self.network=IPv4Network(address,strict=False )\n   self.netmask=self.network.netmask\n   self.hostmask=self.network.hostmask\n   return\n   \n  addr=_split_optional_netmask(address)\n  IPv4Address.__init__(self,addr[0])\n  \n  self.network=IPv4Network(address,strict=False )\n  self._prefixlen=self.network._prefixlen\n  \n  self.netmask=self.network.netmask\n  self.hostmask=self.network.hostmask\n  \n def __str__(self):\n  return '%s/%d'%(self._string_from_ip_int(self._ip),\n  self.network.prefixlen)\n  \n def __eq__(self,other):\n  address_equal=IPv4Address.__eq__(self,other)\n  if not address_equal or address_equal is NotImplemented:\n   return address_equal\n  try :\n   return self.network ==other.network\n  except AttributeError:\n  \n  \n  \n   return False\n   \n def __lt__(self,other):\n  address_less=IPv4Address.__lt__(self,other)\n  if address_less is NotImplemented:\n   return NotImplemented\n  try :\n   return (self.network <other.network or\n   self.network ==other.network and address_less)\n  except AttributeError:\n  \n  \n   return False\n   \n def __hash__(self):\n  return self._ip ^self._prefixlen ^int(self.network.network_address)\n  \n __reduce__=_IPAddressBase.__reduce__\n \n @property\n def ip(self):\n  return IPv4Address(self._ip)\n  \n @property\n def with_prefixlen(self):\n  return '%s/%s'%(self._string_from_ip_int(self._ip),\n  self._prefixlen)\n  \n @property\n def with_netmask(self):\n  return '%s/%s'%(self._string_from_ip_int(self._ip),\n  self.netmask)\n  \n @property\n def with_hostmask(self):\n  return '%s/%s'%(self._string_from_ip_int(self._ip),\n  self.hostmask)\n  \n  \nclass IPv4Network(_BaseV4,_BaseNetwork):\n\n ''\n\n\n\n\n\n\n\n\n \n \n _address_class=IPv4Address\n \n def __init__(self,address,strict=True ):\n \n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  _BaseNetwork.__init__(self,address)\n  \n  \n  if isinstance(address,(int,bytes)):\n   addr=address\n   mask=self._max_prefixlen\n   \n  elif isinstance(address,tuple):\n   addr=address[0]\n   mask=address[1]if len(address)>1 else self._max_prefixlen\n   \n   \n  else :\n   args=_split_optional_netmask(address)\n   addr=self._ip_int_from_string(args[0])\n   mask=args[1]if len(args)==2 else self._max_prefixlen\n   \n  self.network_address=IPv4Address(addr)\n  self.netmask,self._prefixlen=self._make_netmask(mask)\n  packed=int(self.network_address)\n  if packed&int(self.netmask)!=packed:\n   if strict:\n    raise ValueError('%s has host bits set'%self)\n   else :\n    self.network_address=IPv4Address(packed&\n    int(self.netmask))\n    \n  if self._prefixlen ==(self._max_prefixlen -1):\n   self.hosts=self.__iter__\n   \n @property\n @functools.lru_cache()\n def is_global(self):\n  ''\n\n\n\n\n\n  \n  return (not (self.network_address in IPv4Network('100.64.0.0/10')and\n  self.broadcast_address in IPv4Network('100.64.0.0/10'))and\n  not self.is_private)\n  \n  \nclass _IPv4Constants:\n _linklocal_network=IPv4Network('169.254.0.0/16')\n \n _loopback_network=IPv4Network('127.0.0.0/8')\n \n _multicast_network=IPv4Network('224.0.0.0/4')\n \n _public_network=IPv4Network('100.64.0.0/10')\n \n _private_networks=[\n IPv4Network('0.0.0.0/8'),\n IPv4Network('10.0.0.0/8'),\n IPv4Network('127.0.0.0/8'),\n IPv4Network('169.254.0.0/16'),\n IPv4Network('172.16.0.0/12'),\n IPv4Network('192.0.0.0/29'),\n IPv4Network('192.0.0.170/31'),\n IPv4Network('192.0.2.0/24'),\n IPv4Network('192.168.0.0/16'),\n IPv4Network('198.18.0.0/15'),\n IPv4Network('198.51.100.0/24'),\n IPv4Network('203.0.113.0/24'),\n IPv4Network('240.0.0.0/4'),\n IPv4Network('255.255.255.255/32'),\n ]\n \n _reserved_network=IPv4Network('240.0.0.0/4')\n \n _unspecified_address=IPv4Address('0.0.0.0')\n \n \nIPv4Address._constants=_IPv4Constants\n\n\nclass _BaseV6:\n\n ''\n\n\n\n\n \n \n __slots__=()\n _version=6\n _ALL_ONES=(2 **IPV6LENGTH)-1\n _HEXTET_COUNT=8\n _HEX_DIGITS=frozenset('0123456789ABCDEFabcdef')\n _max_prefixlen=IPV6LENGTH\n \n \n \n _netmask_cache={}\n \n @classmethod\n def _make_netmask(cls,arg):\n  ''\n\n\n\n\n\n  \n  if arg not in cls._netmask_cache:\n   if isinstance(arg,int):\n    prefixlen=arg\n   else :\n    prefixlen=cls._prefix_from_prefix_string(arg)\n   netmask=IPv6Address(cls._ip_int_from_prefix(prefixlen))\n   cls._netmask_cache[arg]=netmask,prefixlen\n  return cls._netmask_cache[arg]\n  \n @classmethod\n def _ip_int_from_string(cls,ip_str):\n  ''\n\n\n\n\n\n\n\n\n\n\n  \n  if not ip_str:\n   raise AddressValueError('Address cannot be empty')\n   \n  parts=ip_str.split(':')\n  \n  \n  _min_parts=3\n  if len(parts)<_min_parts:\n   msg=\"At least %d parts expected in %r\"%(_min_parts,ip_str)\n   raise AddressValueError(msg)\n   \n   \n  if '.'in parts[-1]:\n   try :\n    ipv4_int=IPv4Address(parts.pop())._ip\n   except AddressValueError as exc:\n    raise AddressValueError(\"%s in %r\"%(exc,ip_str))from None\n   parts.append('%x'%((ipv4_int >>16)&0xFFFF))\n   parts.append('%x'%(ipv4_int&0xFFFF))\n   \n   \n   \n   \n  _max_parts=cls._HEXTET_COUNT+1\n  if len(parts)>_max_parts:\n   msg=\"At most %d colons permitted in %r\"%(_max_parts -1,ip_str)\n   raise AddressValueError(msg)\n   \n   \n   \n  skip_index=None\n  for i in range(1,len(parts)-1):\n   if not parts[i]:\n    if skip_index is not None :\n    \n     msg=\"At most one '::' permitted in %r\"%ip_str\n     raise AddressValueError(msg)\n    skip_index=i\n    \n    \n    \n  if skip_index is not None :\n  \n   parts_hi=skip_index\n   parts_lo=len(parts)-skip_index -1\n   if not parts[0]:\n    parts_hi -=1\n    if parts_hi:\n     msg=\"Leading ':' only permitted as part of '::' in %r\"\n     raise AddressValueError(msg %ip_str)\n   if not parts[-1]:\n    parts_lo -=1\n    if parts_lo:\n     msg=\"Trailing ':' only permitted as part of '::' in %r\"\n     raise AddressValueError(msg %ip_str)\n   parts_skipped=cls._HEXTET_COUNT -(parts_hi+parts_lo)\n   if parts_skipped <1:\n    msg=\"Expected at most %d other parts with '::' in %r\"\n    raise AddressValueError(msg %(cls._HEXTET_COUNT -1,ip_str))\n  else :\n  \n  \n  \n   if len(parts)!=cls._HEXTET_COUNT:\n    msg=\"Exactly %d parts expected without '::' in %r\"\n    raise AddressValueError(msg %(cls._HEXTET_COUNT,ip_str))\n   if not parts[0]:\n    msg=\"Leading ':' only permitted as part of '::' in %r\"\n    raise AddressValueError(msg %ip_str)\n   if not parts[-1]:\n    msg=\"Trailing ':' only permitted as part of '::' in %r\"\n    raise AddressValueError(msg %ip_str)\n   parts_hi=len(parts)\n   parts_lo=0\n   parts_skipped=0\n   \n  try :\n  \n   ip_int=0\n   for i in range(parts_hi):\n    ip_int <<=16\n    ip_int |=cls._parse_hextet(parts[i])\n   ip_int <<=16 *parts_skipped\n   for i in range(-parts_lo,0):\n    ip_int <<=16\n    ip_int |=cls._parse_hextet(parts[i])\n   return ip_int\n  except ValueError as exc:\n   raise AddressValueError(\"%s in %r\"%(exc,ip_str))from None\n   \n @classmethod\n def _parse_hextet(cls,hextet_str):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n  \n  \n  if not cls._HEX_DIGITS.issuperset(hextet_str):\n   raise ValueError(\"Only hex digits permitted in %r\"%hextet_str)\n   \n   \n  if len(hextet_str)>4:\n   msg=\"At most 4 characters permitted in %r\"\n   raise ValueError(msg %hextet_str)\n   \n  return int(hextet_str,16)\n  \n @classmethod\n def _compress_hextets(cls,hextets):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  best_doublecolon_start=-1\n  best_doublecolon_len=0\n  doublecolon_start=-1\n  doublecolon_len=0\n  for index,hextet in enumerate(hextets):\n   if hextet =='0':\n    doublecolon_len +=1\n    if doublecolon_start ==-1:\n    \n     doublecolon_start=index\n    if doublecolon_len >best_doublecolon_len:\n    \n     best_doublecolon_len=doublecolon_len\n     best_doublecolon_start=doublecolon_start\n   else :\n    doublecolon_len=0\n    doublecolon_start=-1\n    \n  if best_doublecolon_len >1:\n   best_doublecolon_end=(best_doublecolon_start+\n   best_doublecolon_len)\n   \n   if best_doublecolon_end ==len(hextets):\n    hextets +=['']\n   hextets[best_doublecolon_start:best_doublecolon_end]=['']\n   \n   if best_doublecolon_start ==0:\n    hextets=['']+hextets\n    \n  return hextets\n  \n @classmethod\n def _string_from_ip_int(cls,ip_int=None ):\n  ''\n\n\n\n\n\n\n\n\n\n\n  \n  if ip_int is None :\n   ip_int=int(cls._ip)\n   \n  if ip_int >cls._ALL_ONES:\n   raise ValueError('IPv6 address is too large')\n   \n  hex_str='%032x'%ip_int\n  hextets=['%x'%int(hex_str[x:x+4],16)for x in range(0,32,4)]\n  \n  hextets=cls._compress_hextets(hextets)\n  return ':'.join(hextets)\n  \n def _explode_shorthand_ip_string(self):\n  ''\n\n\n\n\n\n\n\n  \n  if isinstance(self,IPv6Network):\n   ip_str=str(self.network_address)\n  elif isinstance(self,IPv6Interface):\n   ip_str=str(self.ip)\n  else :\n   ip_str=str(self)\n   \n  ip_int=self._ip_int_from_string(ip_str)\n  hex_str='%032x'%ip_int\n  parts=[hex_str[x:x+4]for x in range(0,32,4)]\n  if isinstance(self,(_BaseNetwork,IPv6Interface)):\n   return '%s/%d'%(':'.join(parts),self._prefixlen)\n  return ':'.join(parts)\n  \n def _reverse_pointer(self):\n  ''\n\n\n\n  \n  reverse_chars=self.exploded[::-1].replace(':','')\n  return '.'.join(reverse_chars)+'.ip6.arpa'\n  \n @property\n def max_prefixlen(self):\n  return self._max_prefixlen\n  \n @property\n def version(self):\n  return self._version\n  \n  \nclass IPv6Address(_BaseV6,_BaseAddress):\n\n ''\n \n __slots__=('_ip','__weakref__')\n \n def __init__(self,address):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  \n  if isinstance(address,int):\n   self._check_int_address(address)\n   self._ip=address\n   return\n   \n   \n  if isinstance(address,bytes):\n   self._check_packed_address(address,16)\n   self._ip=int.from_bytes(address,'big')\n   return\n   \n   \n   \n  addr_str=str(address)\n  if '/'in addr_str:\n   raise AddressValueError(\"Unexpected '/' in %r\"%address)\n  self._ip=self._ip_int_from_string(addr_str)\n  \n @property\n def packed(self):\n  ''\n  return v6_int_to_packed(self._ip)\n  \n @property\n def is_multicast(self):\n  ''\n\n\n\n\n\n  \n  return self in self._constants._multicast_network\n  \n @property\n def is_reserved(self):\n  ''\n\n\n\n\n\n  \n  return any(self in x for x in self._constants._reserved_networks)\n  \n @property\n def is_link_local(self):\n  ''\n\n\n\n\n  \n  return self in self._constants._linklocal_network\n  \n @property\n def is_site_local(self):\n  ''\n\n\n\n\n\n\n\n\n  \n  return self in self._constants._sitelocal_network\n  \n @property\n @functools.lru_cache()\n def is_private(self):\n  ''\n\n\n\n\n\n  \n  return any(self in net for net in self._constants._private_networks)\n  \n @property\n def is_global(self):\n  ''\n\n\n\n\n\n  \n  return not self.is_private\n  \n @property\n def is_unspecified(self):\n  ''\n\n\n\n\n\n  \n  return self._ip ==0\n  \n @property\n def is_loopback(self):\n  ''\n\n\n\n\n\n  \n  return self._ip ==1\n  \n @property\n def ipv4_mapped(self):\n  ''\n\n\n\n\n\n  \n  if (self._ip >>32)!=0xFFFF:\n   return None\n  return IPv4Address(self._ip&0xFFFFFFFF)\n  \n @property\n def teredo(self):\n  ''\n\n\n\n\n\n\n  \n  if (self._ip >>96)!=0x20010000:\n   return None\n  return (IPv4Address((self._ip >>64)&0xFFFFFFFF),\n  IPv4Address(~self._ip&0xFFFFFFFF))\n  \n @property\n def sixtofour(self):\n  ''\n\n\n\n\n\n  \n  if (self._ip >>112)!=0x2002:\n   return None\n  return IPv4Address((self._ip >>80)&0xFFFFFFFF)\n  \n  \nclass IPv6Interface(IPv6Address):\n\n def __init__(self,address):\n  if isinstance(address,(bytes,int)):\n   IPv6Address.__init__(self,address)\n   self.network=IPv6Network(self._ip)\n   self._prefixlen=self._max_prefixlen\n   return\n  if isinstance(address,tuple):\n   IPv6Address.__init__(self,address[0])\n   if len(address)>1:\n    self._prefixlen=int(address[1])\n   else :\n    self._prefixlen=self._max_prefixlen\n   self.network=IPv6Network(address,strict=False )\n   self.netmask=self.network.netmask\n   self.hostmask=self.network.hostmask\n   return\n   \n  addr=_split_optional_netmask(address)\n  IPv6Address.__init__(self,addr[0])\n  self.network=IPv6Network(address,strict=False )\n  self.netmask=self.network.netmask\n  self._prefixlen=self.network._prefixlen\n  self.hostmask=self.network.hostmask\n  \n def __str__(self):\n  return '%s/%d'%(self._string_from_ip_int(self._ip),\n  self.network.prefixlen)\n  \n def __eq__(self,other):\n  address_equal=IPv6Address.__eq__(self,other)\n  if not address_equal or address_equal is NotImplemented:\n   return address_equal\n  try :\n   return self.network ==other.network\n  except AttributeError:\n  \n  \n  \n   return False\n   \n def __lt__(self,other):\n  address_less=IPv6Address.__lt__(self,other)\n  if address_less is NotImplemented:\n   return NotImplemented\n  try :\n   return (self.network <other.network or\n   self.network ==other.network and address_less)\n  except AttributeError:\n  \n  \n   return False\n   \n def __hash__(self):\n  return self._ip ^self._prefixlen ^int(self.network.network_address)\n  \n __reduce__=_IPAddressBase.__reduce__\n \n @property\n def ip(self):\n  return IPv6Address(self._ip)\n  \n @property\n def with_prefixlen(self):\n  return '%s/%s'%(self._string_from_ip_int(self._ip),\n  self._prefixlen)\n  \n @property\n def with_netmask(self):\n  return '%s/%s'%(self._string_from_ip_int(self._ip),\n  self.netmask)\n  \n @property\n def with_hostmask(self):\n  return '%s/%s'%(self._string_from_ip_int(self._ip),\n  self.hostmask)\n  \n @property\n def is_unspecified(self):\n  return self._ip ==0 and self.network.is_unspecified\n  \n @property\n def is_loopback(self):\n  return self._ip ==1 and self.network.is_loopback\n  \n  \nclass IPv6Network(_BaseV6,_BaseNetwork):\n\n ''\n\n\n\n\n\n\n\n\n \n \n \n _address_class=IPv6Address\n \n def __init__(self,address,strict=True ):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  _BaseNetwork.__init__(self,address)\n  \n  \n  if isinstance(address,(int,bytes)):\n   addr=address\n   mask=self._max_prefixlen\n   \n  elif isinstance(address,tuple):\n   addr=address[0]\n   mask=address[1]if len(address)>1 else self._max_prefixlen\n   \n   \n  else :\n   args=_split_optional_netmask(address)\n   addr=self._ip_int_from_string(args[0])\n   mask=args[1]if len(args)==2 else self._max_prefixlen\n   \n  self.network_address=IPv6Address(addr)\n  self.netmask,self._prefixlen=self._make_netmask(mask)\n  packed=int(self.network_address)\n  if packed&int(self.netmask)!=packed:\n   if strict:\n    raise ValueError('%s has host bits set'%self)\n   else :\n    self.network_address=IPv6Address(packed&\n    int(self.netmask))\n    \n  if self._prefixlen ==(self._max_prefixlen -1):\n   self.hosts=self.__iter__\n   \n def hosts(self):\n  ''\n\n\n\n\n  \n  network=int(self.network_address)\n  broadcast=int(self.broadcast_address)\n  for x in range(network+1,broadcast+1):\n   yield self._address_class(x)\n   \n @property\n def is_site_local(self):\n  ''\n\n\n\n\n\n\n\n\n  \n  return (self.network_address.is_site_local and\n  self.broadcast_address.is_site_local)\n  \n  \nclass _IPv6Constants:\n\n _linklocal_network=IPv6Network('fe80::/10')\n \n _multicast_network=IPv6Network('ff00::/8')\n \n _private_networks=[\n IPv6Network('::1/128'),\n IPv6Network('::/128'),\n IPv6Network('::ffff:0:0/96'),\n IPv6Network('100::/64'),\n IPv6Network('2001::/23'),\n IPv6Network('2001:2::/48'),\n IPv6Network('2001:db8::/32'),\n IPv6Network('2001:10::/28'),\n IPv6Network('fc00::/7'),\n IPv6Network('fe80::/10'),\n ]\n \n _reserved_networks=[\n IPv6Network('::/8'),IPv6Network('100::/8'),\n IPv6Network('200::/7'),IPv6Network('400::/6'),\n IPv6Network('800::/5'),IPv6Network('1000::/4'),\n IPv6Network('4000::/3'),IPv6Network('6000::/3'),\n IPv6Network('8000::/3'),IPv6Network('A000::/3'),\n IPv6Network('C000::/3'),IPv6Network('E000::/4'),\n IPv6Network('F000::/5'),IPv6Network('F800::/6'),\n IPv6Network('FE00::/9'),\n ]\n \n _sitelocal_network=IPv6Network('fec0::/10')\n \n \nIPv6Address._constants=_IPv6Constants\n", ["functools"]], "itertools": [".py", "import operator\n\nclass accumulate:\n def __init__(self,iterable,func=operator.add):\n  self.it=iter(iterable)\n  self._total=None\n  self.func=func\n  \n def __iter__(self):\n  return self\n  \n def __next__(self):\n  if not self._total:\n   self._total=next(self.it)\n   return self._total\n  else :\n   element=next(self.it)\n   try :\n    self._total=self.func(self._total,element)\n   except :\n    raise TypeError(\"unsupported operand type\")\n   return self._total\n   \n   \n   \nclass chain:\n def __init__(self,*iterables):\n  self._iterables_iter=iter(map(iter,iterables))\n  \n  self._cur_iterable_iter=iter([])\n  \n def __iter__(self):\n  return self\n  \n def __next__(self):\n  while True :\n   try :\n    return next(self._cur_iterable_iter)\n   except StopIteration:\n    self._cur_iterable_iter=next(self._iterables_iter)\n    \n @classmethod\n def from_iterable(cls,iterable):\n  for it in iterable:\n   for element in it:\n    yield element\n    \nclass combinations:\n def __init__(self,iterable,r):\n  self.pool=tuple(iterable)\n  self.n=len(self.pool)\n  self.r=r\n  self.indices=list(range(self.r))\n  self.zero=False\n  \n def __iter__(self):\n  return self\n  \n def __next__(self):\n  if self.r >self.n:\n   raise StopIteration\n  if not self.zero:\n   self.zero=True\n   return tuple(self.pool[i]for i in self.indices)\n  else :\n   try :\n    for i in reversed(range(self.r)):\n     if self.indices[i]!=i+self.n -self.r:\n      break\n    self.indices[i]+=1\n    for j in range(i+1,self.r):\n     self.indices[j]=self.indices[j -1]+1\n    return tuple(self.pool[i]for i in self.indices)\n   except :\n    raise StopIteration\n    \nclass combinations_with_replacement:\n def __init__(self,iterable,r):\n  self.pool=tuple(iterable)\n  self.n=len(self.pool)\n  self.r=r\n  self.indices=[0]*self.r\n  self.zero=False\n  \n def __iter__(self):\n  return self\n  \n def __next__(self):\n  if not self.n and self.r:\n   raise StopIteration\n  if not self.zero:\n   self.zero=True\n   return tuple(self.pool[i]for i in self.indices)\n  else :\n   try :\n    for i in reversed(range(self.r)):\n     if self.indices[i]!=self.n -1:\n      break\n    self.indices[i:]=[self.indices[i]+1]*(self.r -i)\n    return tuple(self.pool[i]for i in self.indices)\n   except :\n    raise StopIteration\n    \n    \n    \nclass compress:\n def __init__(self,data,selectors):\n  self.data=iter(data)\n  self.selectors=iter(selectors)\n  \n def __iter__(self):\n  return self\n  \n def __next__(self):\n  while True :\n   next_item=next(self.data)\n   next_selector=next(self.selectors)\n   if bool(next_selector):\n    return next_item\n    \n    \n    \n    \nclass count:\n ''\n\n\n\n \n def __init__(self,start=0,step=1):\n  if not isinstance(start,(int,float)):\n   raise TypeError('a number is required')\n  self.times=start -step\n  self.step=step\n  \n def __iter__(self):\n  return self\n  \n def __next__(self):\n  self.times +=self.step\n  return self.times\n  \n def __repr__(self):\n  return 'count(%d)'%(self.times+self.step)\n  \n  \n  \nclass cycle:\n def __init__(self,iterable):\n  self._cur_iter=iter(iterable)\n  self._saved=[]\n  self._must_save=True\n  \n def __iter__(self):\n  return self\n  \n def __next__(self):\n  try :\n   next_elt=next(self._cur_iter)\n   if self._must_save:\n    self._saved.append(next_elt)\n  except StopIteration:\n   self._cur_iter=iter(self._saved)\n   next_elt=next(self._cur_iter)\n   self._must_save=False\n  return next_elt\n  \n  \n  \nclass dropwhile:\n def __init__(self,predicate,iterable):\n  self._predicate=predicate\n  self._iter=iter(iterable)\n  self._dropped=False\n  \n def __iter__(self):\n  return self\n  \n def __next__(self):\n  value=next(self._iter)\n  if self._dropped:\n   return value\n  while self._predicate(value):\n   value=next(self._iter)\n  self._dropped=True\n  return value\n  \n  \n  \nclass filterfalse:\n def __init__(self,predicate,iterable):\n \n  self._iter=iter(iterable)\n  if predicate is None :\n   self._predicate=bool\n  else :\n   self._predicate=predicate\n   \n def __iter__(self):\n  return self\n def __next__(self):\n  next_elt=next(self._iter)\n  while True :\n   if not self._predicate(next_elt):\n    return next_elt\n   next_elt=next(self._iter)\n   \nclass groupby:\n\n\n def __init__(self,iterable,key=None ):\n  if key is None :\n   key=lambda x:x\n  self.keyfunc=key\n  self.it=iter(iterable)\n  self.tgtkey=self.currkey=self.currvalue=object()\n def __iter__(self):\n  return self\n def __next__(self):\n  while self.currkey ==self.tgtkey:\n   self.currvalue=next(self.it)\n   self.currkey=self.keyfunc(self.currvalue)\n  self.tgtkey=self.currkey\n  return (self.currkey,self._grouper(self.tgtkey))\n def _grouper(self,tgtkey):\n  while self.currkey ==tgtkey:\n   yield self.currvalue\n   self.currvalue=next(self.it)\n   self.currkey=self.keyfunc(self.currvalue)\n   \n   \n   \nclass islice:\n def __init__(self,iterable,*args):\n  s=slice(*args)\n  self.start,self.stop,self.step=s.start or 0,s.stop,s.step\n  if not isinstance(self.start,int):\n   raise ValueError(\"Start argument must be an integer\")\n  if self.stop !=None and not isinstance(self.stop,int):\n   raise ValueError(\"Stop argument must be an integer or None\")\n  if self.step is None :\n   self.step=1\n  if self.start <0 or (self.stop !=None and self.stop <0\n  )or self.step <=0:\n   raise ValueError(\"indices for islice() must be positive\")\n  self.it=iter(iterable)\n  self.donext=None\n  self.cnt=0\n  \n def __iter__(self):\n  return self\n  \n def __next__(self):\n  nextindex=self.start\n  if self.stop !=None and nextindex >=self.stop:\n   raise StopIteration\n  while self.cnt <=nextindex:\n   nextitem=next(self.it)\n   self.cnt +=1\n  self.start +=self.step\n  return nextitem\n  \nclass permutations:\n def __init__(self,iterable,r=None ):\n  self.pool=tuple(iterable)\n  self.n=len(self.pool)\n  self.r=self.n if r is None else r\n  self.indices=list(range(self.n))\n  self.cycles=list(range(self.n,self.n -self.r,-1))\n  self.zero=False\n  self.stop=False\n  \n def __iter__(self):\n  return self\n  \n def __next__(self):\n  indices=self.indices\n  if self.r >self.n:\n   raise StopIteration\n  if not self.zero:\n   self.zero=True\n   return tuple(self.pool[i]for i in indices[:self.r])\n   \n  i=self.r -1\n  while i >=0:\n   j=self.cycles[i]-1\n   if j >0:\n    self.cycles[i]=j\n    indices[i],indices[-j]=indices[-j],indices[i]\n    return tuple(self.pool[i]for i in indices[:self.r])\n   self.cycles[i]=len(indices)-i\n   n1=len(indices)-1\n   assert n1 >=0\n   num=indices[i]\n   for k in range(i,n1):\n    indices[k]=indices[k+1]\n   indices[n1]=num\n   i -=1\n  raise StopIteration\n  \n  \ndef product(*args,repeat=1):\n\n\n pools=[tuple(pool)for pool in args]*repeat\n result=[[]]\n for pool in pools:\n  result=[x+[y]for x in result for y in pool]\n for prod in result:\n  yield tuple(prod)\n  \n  \n  \n  \n  \n  \n  \n  \nclass _product:\n def __init__(self,*args,**kw):\n  if len(kw)>1:\n   raise TypeError(\"product() takes at most 1 argument (%d given)\"%\n   len(kw))\n  self.repeat=kw.get('repeat',1)\n  if not isinstance(self.repeat,int):\n   raise TypeError(\"integer argument expected, got %s\"%\n   type(self.repeat))\n  self.gears=[x for x in args]*self.repeat\n  self.num_gears=len(self.gears)\n  \n  self.indicies=[(0,len(self.gears[x]))\n  for x in range(0,self.num_gears)]\n  self.cont=True\n  self.zero=False\n  \n def roll_gears(self):\n \n \n \n  should_carry=True\n  for n in range(0,self.num_gears):\n   nth_gear=self.num_gears -n -1\n   if should_carry:\n    count,lim=self.indicies[nth_gear]\n    count +=1\n    if count ==lim and nth_gear ==0:\n     self.cont=False\n    if count ==lim:\n     should_carry=True\n     count=0\n    else :\n     should_carry=False\n    self.indicies[nth_gear]=(count,lim)\n   else :\n    break\n    \n def __iter__(self):\n  return self\n  \n def __next__(self):\n  if self.zero:\n   raise StopIteration\n  if self.repeat >0:\n   if not self.cont:\n    raise StopIteration\n   l=[]\n   for x in range(0,self.num_gears):\n    index,limit=self.indicies[x]\n    print('itertools 353',self.gears,x,index)\n    l.append(self.gears[x][index])\n   self.roll_gears()\n   return tuple(l)\n  elif self.repeat ==0:\n   self.zero=True\n   return ()\n  else :\n   raise ValueError(\"repeat argument cannot be negative\")\n   \n   \n   \nclass repeat:\n def __init__(self,obj,times=None ):\n  self._obj=obj\n  if times is not None :\n   range(times)\n   if times <0:\n    times=0\n  self._times=times\n  \n def __iter__(self):\n  return self\n  \n def __next__(self):\n \n  if self._times is not None :\n   if self._times <=0:\n    raise StopIteration()\n   self._times -=1\n  return self._obj\n  \n def __repr__(self):\n  if self._times is not None :\n   return 'repeat(%r, %r)'%(self._obj,self._times)\n  else :\n   return 'repeat(%r)'%(self._obj,)\n   \n def __len__(self):\n  if self._times ==-1 or self._times is None :\n   raise TypeError(\"len() of uniszed object\")\n  return self._times\n  \n  \n  \nclass starmap(object):\n def __init__(self,function,iterable):\n  self._func=function\n  self._iter=iter(iterable)\n  \n def __iter__(self):\n  return self\n  \n def __next__(self):\n  t=next(self._iter)\n  return self._func(*t)\n  \n  \n  \nclass takewhile(object):\n def __init__(self,predicate,iterable):\n  self._predicate=predicate\n  self._iter=iter(iterable)\n  \n def __iter__(self):\n  return self\n  \n def __next__(self):\n  value=next(self._iter)\n  if not self._predicate(value):\n   raise StopIteration()\n  return value\n  \n  \n  \nclass TeeData(object):\n def __init__(self,iterator):\n  self.data=[]\n  self._iter=iterator\n  \n def __getitem__(self,i):\n \n  while i >=len(self.data):\n   self.data.append(next(self._iter))\n  return self.data[i]\n  \n  \nclass TeeObject(object):\n def __init__(self,iterable=None ,tee_data=None ):\n  if tee_data:\n   self.tee_data=tee_data\n   self.pos=0\n   \n  elif isinstance(iterable,TeeObject):\n   self.tee_data=iterable.tee_data\n   self.pos=iterable.pos\n  else :\n   self.tee_data=TeeData(iter(iterable))\n   self.pos=0\n   \n def __next__(self):\n  data=self.tee_data[self.pos]\n  self.pos +=1\n  return data\n  \n def __iter__(self):\n  return self\n  \n  \ndef tee(iterable,n=2):\n if isinstance(iterable,TeeObject):\n  return tuple([iterable]+\n  [TeeObject(tee_data=iterable.tee_data)for i in range(n -1)])\n tee_data=TeeData(iter(iterable))\n return tuple([TeeObject(tee_data=tee_data)for i in range(n)])\n \nclass zip_longest:\n def __init__(self,*args,fillvalue=None ):\n  self.args=[iter(arg)for arg in args]\n  self.fillvalue=fillvalue\n  self.units=len(args)\n  \n def __iter__(self):\n  return self\n  \n def __next__(self):\n  temp=[]\n  nb=0\n  for i in range(self.units):\n   try :\n    temp.append(next(self.args[i]))\n    nb +=1\n   except StopIteration:\n    temp.append(self.fillvalue)\n  if nb ==0:\n   raise StopIteration\n  return tuple(temp)\n", ["operator"]], "keyword": [".py", "#! /usr/bin/env python3\n\n\"\"\"Keywords (from \"graminit.c\")\n\nThis file is automatically generated; please don't muck it up!\n\nTo update the symbols in this file, 'cd' to the top directory of\nthe python source tree after building the interpreter and run:\n\n    ./python Lib/keyword.py\n\"\"\"\n\n__all__=[\"iskeyword\",\"kwlist\"]\n\nkwlist=[\n\n'False',\n'None',\n'True',\n'and',\n'as',\n'assert',\n'async',\n'await',\n'break',\n'class',\n'continue',\n'def',\n'del',\n'elif',\n'else',\n'except',\n'finally',\n'for',\n'from',\n'global',\n'if',\n'import',\n'in',\n'is',\n'lambda',\n'nonlocal',\n'not',\n'or',\n'pass',\n'raise',\n'return',\n'try',\n'while',\n'with',\n'yield',\n\n]\n\niskeyword=frozenset(kwlist).__contains__\n\ndef main():\n import sys,re\n \n args=sys.argv[1:]\n iptfile=args and args[0]or \"Python/graminit.c\"\n if len(args)>1:optfile=args[1]\n else :optfile=\"Lib/keyword.py\"\n \n \n \n with open(optfile,newline='')as fp:\n  format=fp.readlines()\n nl=format[0][len(format[0].strip()):]if format else '\\n'\n \n \n with open(iptfile)as fp:\n  strprog=re.compile('\"([^\"]+)\"')\n  lines=[]\n  for line in fp:\n   if '{1, \"'in line:\n    match=strprog.search(line)\n    if match:\n     lines.append(\"        '\"+match.group(1)+\"',\"+nl)\n lines.sort()\n \n \n try :\n  start=format.index(\"#--start keywords--\"+nl)+1\n  end=format.index(\"#--end keywords--\"+nl)\n  format[start:end]=lines\n except ValueError:\n  sys.stderr.write(\"target does not contain format markers\\n\")\n  sys.exit(1)\n  \n  \n with open(optfile,'w',newline='')as fp:\n  fp.writelines(format)\n  \nif __name__ ==\"__main__\":\n main()\n", ["re", "sys"]], "linecache": [".py", "''\n\n\n\n\n\n\nimport functools\nimport sys\nimport os\nimport tokenize\n\n__all__=[\"getline\",\"clearcache\",\"checkcache\"]\n\ndef getline(filename,lineno,module_globals=None ):\n lines=getlines(filename,module_globals)\n if 1 <=lineno <=len(lines):\n  return lines[lineno -1]\n else :\n  return ''\n  \n  \n  \n  \n  \n  \ncache={}\n\n\ndef clearcache():\n ''\n \n global cache\n cache={}\n \n \ndef getlines(filename,module_globals=None ):\n ''\n \n \n if filename in cache:\n  entry=cache[filename]\n  if len(entry)!=1:\n   return cache[filename][2]\n   \n try :\n  return updatecache(filename,module_globals)\n except MemoryError:\n  clearcache()\n  return []\n  \n  \ndef checkcache(filename=None ):\n ''\n \n \n if filename is None :\n  filenames=list(cache.keys())\n else :\n  if filename in cache:\n   filenames=[filename]\n  else :\n   return\n   \n for filename in filenames:\n  entry=cache[filename]\n  if len(entry)==1:\n  \n   continue\n  size,mtime,lines,fullname=entry\n  if mtime is None :\n   continue\n  try :\n   stat=os.stat(fullname)\n  except OSError:\n   del cache[filename]\n   continue\n  if size !=stat.st_size or mtime !=stat.st_mtime:\n   del cache[filename]\n   \n   \ndef updatecache(filename,module_globals=None ):\n ''\n\n \n \n if filename in cache:\n  if len(cache[filename])!=1:\n   del cache[filename]\n if not filename or (filename.startswith('<')and filename.endswith('>')):\n  return []\n  \n fullname=filename\n try :\n  stat=os.stat(fullname)\n except OSError:\n  basename=filename\n  \n  \n  \n  if lazycache(filename,module_globals):\n   try :\n    data=cache[filename][0]()\n   except (ImportError,OSError):\n    pass\n   else :\n    if data is None :\n    \n    \n     return []\n    cache[filename]=(\n    len(data),None ,\n    [line+'\\n'for line in data.splitlines()],fullname\n    )\n    return cache[filename][2]\n    \n    \n    \n  if os.path.isabs(filename):\n   return []\n   \n  for dirname in sys.path:\n   try :\n    fullname=os.path.join(dirname,basename)\n   except (TypeError,AttributeError):\n   \n    continue\n   try :\n    stat=os.stat(fullname)\n    break\n   except OSError:\n    pass\n  else :\n   return []\n try :\n  with tokenize.open(fullname)as fp:\n   lines=fp.readlines()\n except OSError:\n  return []\n if lines and not lines[-1].endswith('\\n'):\n  lines[-1]+='\\n'\n size,mtime=stat.st_size,stat.st_mtime\n cache[filename]=size,mtime,lines,fullname\n return lines\n \n \ndef lazycache(filename,module_globals):\n ''\n\n\n\n\n\n\n\n\n\n\n \n if filename in cache:\n  if len(cache[filename])==1:\n   return True\n  else :\n   return False\n if not filename or (filename.startswith('<')and filename.endswith('>')):\n  return False\n  \n if module_globals and '__loader__'in module_globals:\n  name=module_globals.get('__name__')\n  loader=module_globals['__loader__']\n  get_source=getattr(loader,'get_source',None )\n  \n  if name and get_source:\n   get_lines=functools.partial(get_source,name)\n   cache[filename]=(get_lines,)\n   return True\n return False\n", ["functools", "os", "sys", "tokenize"]], "locale": [".py", "''\n\n\n\n\n\n\n\n\n\n\n\nimport sys\nimport encodings\nimport encodings.aliases\nimport re\nimport _collections_abc\nfrom builtins import str as _builtin_str\nimport functools\n\n\n\n\n\n\n\n__all__=[\"getlocale\",\"getdefaultlocale\",\"getpreferredencoding\",\"Error\",\n\"setlocale\",\"resetlocale\",\"localeconv\",\"strcoll\",\"strxfrm\",\n\"str\",\"atof\",\"atoi\",\"format\",\"format_string\",\"currency\",\n\"normalize\",\"LC_CTYPE\",\"LC_COLLATE\",\"LC_TIME\",\"LC_MONETARY\",\n\"LC_NUMERIC\",\"LC_ALL\",\"CHAR_MAX\"]\n\ndef _strcoll(a,b):\n ''\n\n \n return (a >b)-(a <b)\n \ndef _strxfrm(s):\n ''\n\n \n return s\n \ntry :\n\n from _locale import *\n \nexcept ImportError:\n\n\n\n CHAR_MAX=127\n LC_ALL=6\n LC_COLLATE=3\n LC_CTYPE=0\n LC_MESSAGES=5\n LC_MONETARY=4\n LC_NUMERIC=1\n LC_TIME=2\n Error=ValueError\n \n def localeconv():\n  ''\n\n  \n  \n  return {'grouping':[127],\n  'currency_symbol':'',\n  'n_sign_posn':127,\n  'p_cs_precedes':127,\n  'n_cs_precedes':127,\n  'mon_grouping':[],\n  'n_sep_by_space':127,\n  'decimal_point':'.',\n  'negative_sign':'',\n  'positive_sign':'',\n  'p_sep_by_space':127,\n  'int_curr_symbol':'',\n  'p_sign_posn':127,\n  'thousands_sep':'',\n  'mon_thousands_sep':'',\n  'frac_digits':127,\n  'mon_decimal_point':'',\n  'int_frac_digits':127}\n  \n def setlocale(category,value=None ):\n  ''\n\n  \n  if value not in (None ,'','C'):\n   raise Error('_locale emulation only supports \"C\" locale')\n  return 'C'\n  \n  \nif 'strxfrm'not in globals():\n strxfrm=_strxfrm\nif 'strcoll'not in globals():\n strcoll=_strcoll\n \n \n_localeconv=localeconv\n\n\n\n_override_localeconv={}\n\n@functools.wraps(_localeconv)\ndef localeconv():\n d=_localeconv()\n if _override_localeconv:\n  d.update(_override_localeconv)\n return d\n \n \n \n \n \n \n \n \ndef _grouping_intervals(grouping):\n last_interval=None\n for interval in grouping:\n \n  if interval ==CHAR_MAX:\n   return\n   \n  if interval ==0:\n   if last_interval is None :\n    raise ValueError(\"invalid grouping\")\n   while True :\n    yield last_interval\n  yield interval\n  last_interval=interval\n  \n  \ndef _group(s,monetary=False ):\n conv=localeconv()\n thousands_sep=conv[monetary and 'mon_thousands_sep'or 'thousands_sep']\n grouping=conv[monetary and 'mon_grouping'or 'grouping']\n if not grouping:\n  return (s,0)\n if s[-1]==' ':\n  stripped=s.rstrip()\n  right_spaces=s[len(stripped):]\n  s=stripped\n else :\n  right_spaces=''\n left_spaces=''\n groups=[]\n for interval in _grouping_intervals(grouping):\n  if not s or s[-1]not in \"0123456789\":\n  \n   left_spaces=s\n   s=''\n   break\n  groups.append(s[-interval:])\n  s=s[:-interval]\n if s:\n  groups.append(s)\n groups.reverse()\n return (\n left_spaces+thousands_sep.join(groups)+right_spaces,\n len(thousands_sep)*(len(groups)-1)\n )\n \n \ndef _strip_padding(s,amount):\n lpos=0\n while amount and s[lpos]==' ':\n  lpos +=1\n  amount -=1\n rpos=len(s)-1\n while amount and s[rpos]==' ':\n  rpos -=1\n  amount -=1\n return s[lpos:rpos+1]\n \n_percent_re=re.compile(r'%(?:\\((?P<key>.*?)\\))?'\nr'(?P<modifiers>[-#0-9 +*.hlL]*?)[eEfFgGdiouxXcrs%]')\n\ndef _format(percent,value,grouping=False ,monetary=False ,*additional):\n if additional:\n  formatted=percent %((value,)+additional)\n else :\n  formatted=percent %value\n  \n if percent[-1]in 'eEfFgG':\n  seps=0\n  parts=formatted.split('.')\n  if grouping:\n   parts[0],seps=_group(parts[0],monetary=monetary)\n  decimal_point=localeconv()[monetary and 'mon_decimal_point'\n  or 'decimal_point']\n  formatted=decimal_point.join(parts)\n  if seps:\n   formatted=_strip_padding(formatted,seps)\n elif percent[-1]in 'diu':\n  seps=0\n  if grouping:\n   formatted,seps=_group(formatted,monetary=monetary)\n  if seps:\n   formatted=_strip_padding(formatted,seps)\n return formatted\n \ndef format_string(f,val,grouping=False ,monetary=False ):\n ''\n\n\n\n\n \n percents=list(_percent_re.finditer(f))\n new_f=_percent_re.sub('%s',f)\n \n if isinstance(val,_collections_abc.Mapping):\n  new_val=[]\n  for perc in percents:\n   if perc.group()[-1]=='%':\n    new_val.append('%')\n   else :\n    new_val.append(_format(perc.group(),val,grouping,monetary))\n else :\n  if not isinstance(val,tuple):\n   val=(val,)\n  new_val=[]\n  i=0\n  for perc in percents:\n   if perc.group()[-1]=='%':\n    new_val.append('%')\n   else :\n    starcount=perc.group('modifiers').count('*')\n    new_val.append(_format(perc.group(),\n    val[i],\n    grouping,\n    monetary,\n    *val[i+1:i+1+starcount]))\n    i +=(1+starcount)\n val=tuple(new_val)\n \n return new_f %val\n \ndef format(percent,value,grouping=False ,monetary=False ,*additional):\n ''\n import warnings\n warnings.warn(\n \"This method will be removed in a future version of Python. \"\n \"Use 'locale.format_string()' instead.\",\n DeprecationWarning,stacklevel=2\n )\n \n match=_percent_re.match(percent)\n if not match or len(match.group())!=len(percent):\n  raise ValueError((\"format() must be given exactly one %%char \"\n  \"format specifier, %s not valid\")%repr(percent))\n return _format(percent,value,grouping,monetary,*additional)\n \ndef currency(val,symbol=True ,grouping=False ,international=False ):\n ''\n \n conv=localeconv()\n \n \n digits=conv[international and 'int_frac_digits'or 'frac_digits']\n if digits ==127:\n  raise ValueError(\"Currency formatting is not possible using \"\n  \"the 'C' locale.\")\n  \n s=_format('%%.%if'%digits,abs(val),grouping,monetary=True )\n \n s='<'+s+'>'\n \n if symbol:\n  smb=conv[international and 'int_curr_symbol'or 'currency_symbol']\n  precedes=conv[val <0 and 'n_cs_precedes'or 'p_cs_precedes']\n  separated=conv[val <0 and 'n_sep_by_space'or 'p_sep_by_space']\n  \n  if precedes:\n   s=smb+(separated and ' 'or '')+s\n  else :\n   s=s+(separated and ' 'or '')+smb\n   \n sign_pos=conv[val <0 and 'n_sign_posn'or 'p_sign_posn']\n sign=conv[val <0 and 'negative_sign'or 'positive_sign']\n \n if sign_pos ==0:\n  s='('+s+')'\n elif sign_pos ==1:\n  s=sign+s\n elif sign_pos ==2:\n  s=s+sign\n elif sign_pos ==3:\n  s=s.replace('<',sign)\n elif sign_pos ==4:\n  s=s.replace('>',sign)\n else :\n \n \n  s=sign+s\n  \n return s.replace('<','').replace('>','')\n \ndef str(val):\n ''\n return _format(\"%.12g\",val)\n \ndef delocalize(string):\n ''\n \n conv=localeconv()\n \n \n ts=conv['thousands_sep']\n if ts:\n  string=string.replace(ts,'')\n  \n  \n dd=conv['decimal_point']\n if dd:\n  string=string.replace(dd,'.')\n return string\n \ndef atof(string,func=float):\n ''\n return func(delocalize(string))\n \ndef atoi(string):\n ''\n return int(delocalize(string))\n \ndef _test():\n setlocale(LC_ALL,\"\")\n \n s1=format_string(\"%d\",123456789,1)\n print(s1,\"is\",atoi(s1))\n \n s1=str(3.14)\n print(s1,\"is\",atof(s1))\n \n \n \n \n \n \n \n \n_setlocale=setlocale\n\ndef _replace_encoding(code,encoding):\n if '.'in code:\n  langname=code[:code.index('.')]\n else :\n  langname=code\n  \n norm_encoding=encodings.normalize_encoding(encoding)\n \n norm_encoding=encodings.aliases.aliases.get(norm_encoding.lower(),\n norm_encoding)\n \n encoding=norm_encoding\n norm_encoding=norm_encoding.lower()\n if norm_encoding in locale_encoding_alias:\n  encoding=locale_encoding_alias[norm_encoding]\n else :\n  norm_encoding=norm_encoding.replace('_','')\n  norm_encoding=norm_encoding.replace('-','')\n  if norm_encoding in locale_encoding_alias:\n   encoding=locale_encoding_alias[norm_encoding]\n   \n return langname+'.'+encoding\n \ndef _append_modifier(code,modifier):\n if modifier =='euro':\n  if '.'not in code:\n   return code+'.ISO8859-15'\n  _,_,encoding=code.partition('.')\n  if encoding in ('ISO8859-15','UTF-8'):\n   return code\n  if encoding =='ISO8859-1':\n   return _replace_encoding(code,'ISO8859-15')\n return code+'@'+modifier\n \ndef normalize(localename):\n\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n code=localename.lower()\n if ':'in code:\n \n  code=code.replace(':','.')\n if '@'in code:\n  code,modifier=code.split('@',1)\n else :\n  modifier=''\n if '.'in code:\n  langname,encoding=code.split('.')[:2]\n else :\n  langname=code\n  encoding=''\n  \n  \n lang_enc=langname\n if encoding:\n  norm_encoding=encoding.replace('-','')\n  norm_encoding=norm_encoding.replace('_','')\n  lang_enc +='.'+norm_encoding\n lookup_name=lang_enc\n if modifier:\n  lookup_name +='@'+modifier\n code=locale_alias.get(lookup_name,None )\n if code is not None :\n  return code\n  \n  \n if modifier:\n \n  code=locale_alias.get(lang_enc,None )\n  if code is not None :\n  \n   if '@'not in code:\n    return _append_modifier(code,modifier)\n   if code.split('@',1)[1].lower()==modifier:\n    return code\n    \n    \n if encoding:\n \n  lookup_name=langname\n  if modifier:\n   lookup_name +='@'+modifier\n  code=locale_alias.get(lookup_name,None )\n  if code is not None :\n  \n   if '@'not in code:\n    return _replace_encoding(code,encoding)\n   code,modifier=code.split('@',1)\n   return _replace_encoding(code,encoding)+'@'+modifier\n   \n  if modifier:\n  \n   code=locale_alias.get(langname,None )\n   if code is not None :\n   \n    if '@'not in code:\n     code=_replace_encoding(code,encoding)\n     return _append_modifier(code,modifier)\n    code,defmod=code.split('@',1)\n    if defmod.lower()==modifier:\n     return _replace_encoding(code,encoding)+'@'+defmod\n     \n return localename\n \ndef _parse_localename(localename):\n\n ''\n\n\n\n\n\n\n\n\n\n\n \n code=normalize(localename)\n if '@'in code:\n \n  code,modifier=code.split('@',1)\n  if modifier =='euro'and '.'not in code:\n  \n  \n  \n   return code,'iso-8859-15'\n   \n if '.'in code:\n  return tuple(code.split('.')[:2])\n elif code =='C':\n  return None ,None\n raise ValueError('unknown locale: %s'%localename)\n \ndef _build_localename(localetuple):\n\n ''\n\n\n\n\n \n try :\n  language,encoding=localetuple\n  \n  if language is None :\n   language='C'\n  if encoding is None :\n   return language\n  else :\n   return language+'.'+encoding\n except (TypeError,ValueError):\n  raise TypeError('Locale must be None, a string, or an iterable of '\n  'two strings -- language code, encoding.')from None\n  \ndef getdefaultlocale(envvars=('LC_ALL','LC_CTYPE','LANG','LANGUAGE')):\n\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n try :\n \n  import _locale\n  code,encoding=_locale._getdefaultlocale()\n except (ImportError,AttributeError):\n  pass\n else :\n \n  if sys.platform ==\"win32\"and code and code[:2]==\"0x\":\n  \n   code=windows_locale.get(int(code,0))\n   \n   \n  return code,encoding\n  \n  \n import os\n lookup=os.environ.get\n for variable in envvars:\n  localename=lookup(variable,None )\n  if localename:\n   if variable =='LANGUAGE':\n    localename=localename.split(':')[0]\n   break\n else :\n  localename='C'\n return _parse_localename(localename)\n \n \ndef getlocale(category=LC_CTYPE):\n\n ''\n\n\n\n\n\n\n\n\n\n \n localename=_setlocale(category)\n if category ==LC_ALL and ';'in localename:\n  raise TypeError('category LC_ALL is not supported')\n return _parse_localename(localename)\n \ndef setlocale(category,locale=None ):\n\n ''\n\n\n\n\n\n\n\n\n \n if locale and not isinstance(locale,_builtin_str):\n \n  locale=normalize(_build_localename(locale))\n return _setlocale(category,locale)\n \ndef resetlocale(category=LC_ALL):\n\n ''\n\n\n\n\n \n _setlocale(category,_build_localename(getdefaultlocale()))\n \nif sys.platform.startswith(\"win\"):\n\n def getpreferredencoding(do_setlocale=True ):\n  ''\n  if sys.flags.utf8_mode:\n   return 'UTF-8'\n  import _bootlocale\n  return _bootlocale.getpreferredencoding(False )\nelse :\n\n try :\n  CODESET\n except NameError:\n  if hasattr(sys,'getandroidapilevel'):\n  \n  \n   def getpreferredencoding(do_setlocale=True ):\n    return 'UTF-8'\n  else :\n  \n   def getpreferredencoding(do_setlocale=True ):\n    ''\n    \n    if sys.flags.utf8_mode:\n     return 'UTF-8'\n    res=getdefaultlocale()[1]\n    if res is None :\n    \n     res='ascii'\n    return res\n else :\n  def getpreferredencoding(do_setlocale=True ):\n   ''\n   \n   if sys.flags.utf8_mode:\n    return 'UTF-8'\n   import _bootlocale\n   if do_setlocale:\n    oldloc=setlocale(LC_CTYPE)\n    try :\n     setlocale(LC_CTYPE,\"\")\n    except Error:\n     pass\n   result=_bootlocale.getpreferredencoding(False )\n   if do_setlocale:\n    setlocale(LC_CTYPE,oldloc)\n   return result\n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \nlocale_encoding_alias={\n\n\n'437':'C',\n'c':'C',\n'en':'ISO8859-1',\n'jis':'JIS7',\n'jis7':'JIS7',\n'ajec':'eucJP',\n'koi8c':'KOI8-C',\n'microsoftcp1251':'CP1251',\n'microsoftcp1255':'CP1255',\n'microsoftcp1256':'CP1256',\n'88591':'ISO8859-1',\n'88592':'ISO8859-2',\n'88595':'ISO8859-5',\n'885915':'ISO8859-15',\n\n\n'ascii':'ISO8859-1',\n'latin_1':'ISO8859-1',\n'iso8859_1':'ISO8859-1',\n'iso8859_10':'ISO8859-10',\n'iso8859_11':'ISO8859-11',\n'iso8859_13':'ISO8859-13',\n'iso8859_14':'ISO8859-14',\n'iso8859_15':'ISO8859-15',\n'iso8859_16':'ISO8859-16',\n'iso8859_2':'ISO8859-2',\n'iso8859_3':'ISO8859-3',\n'iso8859_4':'ISO8859-4',\n'iso8859_5':'ISO8859-5',\n'iso8859_6':'ISO8859-6',\n'iso8859_7':'ISO8859-7',\n'iso8859_8':'ISO8859-8',\n'iso8859_9':'ISO8859-9',\n'iso2022_jp':'JIS7',\n'shift_jis':'SJIS',\n'tactis':'TACTIS',\n'euc_jp':'eucJP',\n'euc_kr':'eucKR',\n'utf_8':'UTF-8',\n'koi8_r':'KOI8-R',\n'koi8_t':'KOI8-T',\n'koi8_u':'KOI8-U',\n'kz1048':'RK1048',\n'cp1251':'CP1251',\n'cp1255':'CP1255',\n'cp1256':'CP1256',\n\n\n\n}\n\nfor k,v in sorted(locale_encoding_alias.items()):\n k=k.replace('_','')\n locale_encoding_alias.setdefault(k,v)\n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \nlocale_alias={\n'a3':'az_AZ.KOI8-C',\n'a3_az':'az_AZ.KOI8-C',\n'a3_az.koic':'az_AZ.KOI8-C',\n'aa_dj':'aa_DJ.ISO8859-1',\n'aa_er':'aa_ER.UTF-8',\n'aa_et':'aa_ET.UTF-8',\n'af':'af_ZA.ISO8859-1',\n'af_za':'af_ZA.ISO8859-1',\n'agr_pe':'agr_PE.UTF-8',\n'ak_gh':'ak_GH.UTF-8',\n'am':'am_ET.UTF-8',\n'am_et':'am_ET.UTF-8',\n'american':'en_US.ISO8859-1',\n'an_es':'an_ES.ISO8859-15',\n'anp_in':'anp_IN.UTF-8',\n'ar':'ar_AA.ISO8859-6',\n'ar_aa':'ar_AA.ISO8859-6',\n'ar_ae':'ar_AE.ISO8859-6',\n'ar_bh':'ar_BH.ISO8859-6',\n'ar_dz':'ar_DZ.ISO8859-6',\n'ar_eg':'ar_EG.ISO8859-6',\n'ar_in':'ar_IN.UTF-8',\n'ar_iq':'ar_IQ.ISO8859-6',\n'ar_jo':'ar_JO.ISO8859-6',\n'ar_kw':'ar_KW.ISO8859-6',\n'ar_lb':'ar_LB.ISO8859-6',\n'ar_ly':'ar_LY.ISO8859-6',\n'ar_ma':'ar_MA.ISO8859-6',\n'ar_om':'ar_OM.ISO8859-6',\n'ar_qa':'ar_QA.ISO8859-6',\n'ar_sa':'ar_SA.ISO8859-6',\n'ar_sd':'ar_SD.ISO8859-6',\n'ar_ss':'ar_SS.UTF-8',\n'ar_sy':'ar_SY.ISO8859-6',\n'ar_tn':'ar_TN.ISO8859-6',\n'ar_ye':'ar_YE.ISO8859-6',\n'arabic':'ar_AA.ISO8859-6',\n'as':'as_IN.UTF-8',\n'as_in':'as_IN.UTF-8',\n'ast_es':'ast_ES.ISO8859-15',\n'ayc_pe':'ayc_PE.UTF-8',\n'az':'az_AZ.ISO8859-9E',\n'az_az':'az_AZ.ISO8859-9E',\n'az_az.iso88599e':'az_AZ.ISO8859-9E',\n'az_ir':'az_IR.UTF-8',\n'be':'be_BY.CP1251',\n'be@latin':'be_BY.UTF-8@latin',\n'be_bg.utf8':'bg_BG.UTF-8',\n'be_by':'be_BY.CP1251',\n'be_by@latin':'be_BY.UTF-8@latin',\n'bem_zm':'bem_ZM.UTF-8',\n'ber_dz':'ber_DZ.UTF-8',\n'ber_ma':'ber_MA.UTF-8',\n'bg':'bg_BG.CP1251',\n'bg_bg':'bg_BG.CP1251',\n'bhb_in.utf8':'bhb_IN.UTF-8',\n'bho_in':'bho_IN.UTF-8',\n'bho_np':'bho_NP.UTF-8',\n'bi_vu':'bi_VU.UTF-8',\n'bn_bd':'bn_BD.UTF-8',\n'bn_in':'bn_IN.UTF-8',\n'bo_cn':'bo_CN.UTF-8',\n'bo_in':'bo_IN.UTF-8',\n'bokmal':'nb_NO.ISO8859-1',\n'bokm\\xe5l':'nb_NO.ISO8859-1',\n'br':'br_FR.ISO8859-1',\n'br_fr':'br_FR.ISO8859-1',\n'brx_in':'brx_IN.UTF-8',\n'bs':'bs_BA.ISO8859-2',\n'bs_ba':'bs_BA.ISO8859-2',\n'bulgarian':'bg_BG.CP1251',\n'byn_er':'byn_ER.UTF-8',\n'c':'C',\n'c-french':'fr_CA.ISO8859-1',\n'c.ascii':'C',\n'c.en':'C',\n'c.iso88591':'en_US.ISO8859-1',\n'c.utf8':'en_US.UTF-8',\n'c_c':'C',\n'c_c.c':'C',\n'ca':'ca_ES.ISO8859-1',\n'ca_ad':'ca_AD.ISO8859-1',\n'ca_es':'ca_ES.ISO8859-1',\n'ca_es@valencia':'ca_ES.UTF-8@valencia',\n'ca_fr':'ca_FR.ISO8859-1',\n'ca_it':'ca_IT.ISO8859-1',\n'catalan':'ca_ES.ISO8859-1',\n'ce_ru':'ce_RU.UTF-8',\n'cextend':'en_US.ISO8859-1',\n'chinese-s':'zh_CN.eucCN',\n'chinese-t':'zh_TW.eucTW',\n'chr_us':'chr_US.UTF-8',\n'ckb_iq':'ckb_IQ.UTF-8',\n'cmn_tw':'cmn_TW.UTF-8',\n'crh_ua':'crh_UA.UTF-8',\n'croatian':'hr_HR.ISO8859-2',\n'cs':'cs_CZ.ISO8859-2',\n'cs_cs':'cs_CZ.ISO8859-2',\n'cs_cz':'cs_CZ.ISO8859-2',\n'csb_pl':'csb_PL.UTF-8',\n'cv_ru':'cv_RU.UTF-8',\n'cy':'cy_GB.ISO8859-1',\n'cy_gb':'cy_GB.ISO8859-1',\n'cz':'cs_CZ.ISO8859-2',\n'cz_cz':'cs_CZ.ISO8859-2',\n'czech':'cs_CZ.ISO8859-2',\n'da':'da_DK.ISO8859-1',\n'da_dk':'da_DK.ISO8859-1',\n'danish':'da_DK.ISO8859-1',\n'dansk':'da_DK.ISO8859-1',\n'de':'de_DE.ISO8859-1',\n'de_at':'de_AT.ISO8859-1',\n'de_be':'de_BE.ISO8859-1',\n'de_ch':'de_CH.ISO8859-1',\n'de_de':'de_DE.ISO8859-1',\n'de_it':'de_IT.ISO8859-1',\n'de_li.utf8':'de_LI.UTF-8',\n'de_lu':'de_LU.ISO8859-1',\n'deutsch':'de_DE.ISO8859-1',\n'doi_in':'doi_IN.UTF-8',\n'dutch':'nl_NL.ISO8859-1',\n'dutch.iso88591':'nl_BE.ISO8859-1',\n'dv_mv':'dv_MV.UTF-8',\n'dz_bt':'dz_BT.UTF-8',\n'ee':'ee_EE.ISO8859-4',\n'ee_ee':'ee_EE.ISO8859-4',\n'eesti':'et_EE.ISO8859-1',\n'el':'el_GR.ISO8859-7',\n'el_cy':'el_CY.ISO8859-7',\n'el_gr':'el_GR.ISO8859-7',\n'el_gr@euro':'el_GR.ISO8859-15',\n'en':'en_US.ISO8859-1',\n'en_ag':'en_AG.UTF-8',\n'en_au':'en_AU.ISO8859-1',\n'en_be':'en_BE.ISO8859-1',\n'en_bw':'en_BW.ISO8859-1',\n'en_ca':'en_CA.ISO8859-1',\n'en_dk':'en_DK.ISO8859-1',\n'en_dl.utf8':'en_DL.UTF-8',\n'en_gb':'en_GB.ISO8859-1',\n'en_hk':'en_HK.ISO8859-1',\n'en_ie':'en_IE.ISO8859-1',\n'en_il':'en_IL.UTF-8',\n'en_in':'en_IN.ISO8859-1',\n'en_ng':'en_NG.UTF-8',\n'en_nz':'en_NZ.ISO8859-1',\n'en_ph':'en_PH.ISO8859-1',\n'en_sc.utf8':'en_SC.UTF-8',\n'en_sg':'en_SG.ISO8859-1',\n'en_uk':'en_GB.ISO8859-1',\n'en_us':'en_US.ISO8859-1',\n'en_us@euro@euro':'en_US.ISO8859-15',\n'en_za':'en_ZA.ISO8859-1',\n'en_zm':'en_ZM.UTF-8',\n'en_zw':'en_ZW.ISO8859-1',\n'en_zw.utf8':'en_ZS.UTF-8',\n'eng_gb':'en_GB.ISO8859-1',\n'english':'en_EN.ISO8859-1',\n'english.iso88591':'en_US.ISO8859-1',\n'english_uk':'en_GB.ISO8859-1',\n'english_united-states':'en_US.ISO8859-1',\n'english_united-states.437':'C',\n'english_us':'en_US.ISO8859-1',\n'eo':'eo_XX.ISO8859-3',\n'eo.utf8':'eo.UTF-8',\n'eo_eo':'eo_EO.ISO8859-3',\n'eo_us.utf8':'eo_US.UTF-8',\n'eo_xx':'eo_XX.ISO8859-3',\n'es':'es_ES.ISO8859-1',\n'es_ar':'es_AR.ISO8859-1',\n'es_bo':'es_BO.ISO8859-1',\n'es_cl':'es_CL.ISO8859-1',\n'es_co':'es_CO.ISO8859-1',\n'es_cr':'es_CR.ISO8859-1',\n'es_cu':'es_CU.UTF-8',\n'es_do':'es_DO.ISO8859-1',\n'es_ec':'es_EC.ISO8859-1',\n'es_es':'es_ES.ISO8859-1',\n'es_gt':'es_GT.ISO8859-1',\n'es_hn':'es_HN.ISO8859-1',\n'es_mx':'es_MX.ISO8859-1',\n'es_ni':'es_NI.ISO8859-1',\n'es_pa':'es_PA.ISO8859-1',\n'es_pe':'es_PE.ISO8859-1',\n'es_pr':'es_PR.ISO8859-1',\n'es_py':'es_PY.ISO8859-1',\n'es_sv':'es_SV.ISO8859-1',\n'es_us':'es_US.ISO8859-1',\n'es_uy':'es_UY.ISO8859-1',\n'es_ve':'es_VE.ISO8859-1',\n'estonian':'et_EE.ISO8859-1',\n'et':'et_EE.ISO8859-15',\n'et_ee':'et_EE.ISO8859-15',\n'eu':'eu_ES.ISO8859-1',\n'eu_es':'eu_ES.ISO8859-1',\n'eu_fr':'eu_FR.ISO8859-1',\n'fa':'fa_IR.UTF-8',\n'fa_ir':'fa_IR.UTF-8',\n'fa_ir.isiri3342':'fa_IR.ISIRI-3342',\n'ff_sn':'ff_SN.UTF-8',\n'fi':'fi_FI.ISO8859-15',\n'fi_fi':'fi_FI.ISO8859-15',\n'fil_ph':'fil_PH.UTF-8',\n'finnish':'fi_FI.ISO8859-1',\n'fo':'fo_FO.ISO8859-1',\n'fo_fo':'fo_FO.ISO8859-1',\n'fr':'fr_FR.ISO8859-1',\n'fr_be':'fr_BE.ISO8859-1',\n'fr_ca':'fr_CA.ISO8859-1',\n'fr_ch':'fr_CH.ISO8859-1',\n'fr_fr':'fr_FR.ISO8859-1',\n'fr_lu':'fr_LU.ISO8859-1',\n'fran\\xe7ais':'fr_FR.ISO8859-1',\n'fre_fr':'fr_FR.ISO8859-1',\n'french':'fr_FR.ISO8859-1',\n'french.iso88591':'fr_CH.ISO8859-1',\n'french_france':'fr_FR.ISO8859-1',\n'fur_it':'fur_IT.UTF-8',\n'fy_de':'fy_DE.UTF-8',\n'fy_nl':'fy_NL.UTF-8',\n'ga':'ga_IE.ISO8859-1',\n'ga_ie':'ga_IE.ISO8859-1',\n'galego':'gl_ES.ISO8859-1',\n'galician':'gl_ES.ISO8859-1',\n'gd':'gd_GB.ISO8859-1',\n'gd_gb':'gd_GB.ISO8859-1',\n'ger_de':'de_DE.ISO8859-1',\n'german':'de_DE.ISO8859-1',\n'german.iso88591':'de_CH.ISO8859-1',\n'german_germany':'de_DE.ISO8859-1',\n'gez_er':'gez_ER.UTF-8',\n'gez_et':'gez_ET.UTF-8',\n'gl':'gl_ES.ISO8859-1',\n'gl_es':'gl_ES.ISO8859-1',\n'greek':'el_GR.ISO8859-7',\n'gu_in':'gu_IN.UTF-8',\n'gv':'gv_GB.ISO8859-1',\n'gv_gb':'gv_GB.ISO8859-1',\n'ha_ng':'ha_NG.UTF-8',\n'hak_tw':'hak_TW.UTF-8',\n'he':'he_IL.ISO8859-8',\n'he_il':'he_IL.ISO8859-8',\n'hebrew':'he_IL.ISO8859-8',\n'hi':'hi_IN.ISCII-DEV',\n'hi_in':'hi_IN.ISCII-DEV',\n'hi_in.isciidev':'hi_IN.ISCII-DEV',\n'hif_fj':'hif_FJ.UTF-8',\n'hne':'hne_IN.UTF-8',\n'hne_in':'hne_IN.UTF-8',\n'hr':'hr_HR.ISO8859-2',\n'hr_hr':'hr_HR.ISO8859-2',\n'hrvatski':'hr_HR.ISO8859-2',\n'hsb_de':'hsb_DE.ISO8859-2',\n'ht_ht':'ht_HT.UTF-8',\n'hu':'hu_HU.ISO8859-2',\n'hu_hu':'hu_HU.ISO8859-2',\n'hungarian':'hu_HU.ISO8859-2',\n'hy_am':'hy_AM.UTF-8',\n'hy_am.armscii8':'hy_AM.ARMSCII_8',\n'ia':'ia.UTF-8',\n'ia_fr':'ia_FR.UTF-8',\n'icelandic':'is_IS.ISO8859-1',\n'id':'id_ID.ISO8859-1',\n'id_id':'id_ID.ISO8859-1',\n'ig_ng':'ig_NG.UTF-8',\n'ik_ca':'ik_CA.UTF-8',\n'in':'id_ID.ISO8859-1',\n'in_id':'id_ID.ISO8859-1',\n'is':'is_IS.ISO8859-1',\n'is_is':'is_IS.ISO8859-1',\n'iso-8859-1':'en_US.ISO8859-1',\n'iso-8859-15':'en_US.ISO8859-15',\n'iso8859-1':'en_US.ISO8859-1',\n'iso8859-15':'en_US.ISO8859-15',\n'iso_8859_1':'en_US.ISO8859-1',\n'iso_8859_15':'en_US.ISO8859-15',\n'it':'it_IT.ISO8859-1',\n'it_ch':'it_CH.ISO8859-1',\n'it_it':'it_IT.ISO8859-1',\n'italian':'it_IT.ISO8859-1',\n'iu':'iu_CA.NUNACOM-8',\n'iu_ca':'iu_CA.NUNACOM-8',\n'iu_ca.nunacom8':'iu_CA.NUNACOM-8',\n'iw':'he_IL.ISO8859-8',\n'iw_il':'he_IL.ISO8859-8',\n'iw_il.utf8':'iw_IL.UTF-8',\n'ja':'ja_JP.eucJP',\n'ja_jp':'ja_JP.eucJP',\n'ja_jp.euc':'ja_JP.eucJP',\n'ja_jp.mscode':'ja_JP.SJIS',\n'ja_jp.pck':'ja_JP.SJIS',\n'japan':'ja_JP.eucJP',\n'japanese':'ja_JP.eucJP',\n'japanese-euc':'ja_JP.eucJP',\n'japanese.euc':'ja_JP.eucJP',\n'jp_jp':'ja_JP.eucJP',\n'ka':'ka_GE.GEORGIAN-ACADEMY',\n'ka_ge':'ka_GE.GEORGIAN-ACADEMY',\n'ka_ge.georgianacademy':'ka_GE.GEORGIAN-ACADEMY',\n'ka_ge.georgianps':'ka_GE.GEORGIAN-PS',\n'ka_ge.georgianrs':'ka_GE.GEORGIAN-ACADEMY',\n'kab_dz':'kab_DZ.UTF-8',\n'kk_kz':'kk_KZ.ptcp154',\n'kl':'kl_GL.ISO8859-1',\n'kl_gl':'kl_GL.ISO8859-1',\n'km_kh':'km_KH.UTF-8',\n'kn':'kn_IN.UTF-8',\n'kn_in':'kn_IN.UTF-8',\n'ko':'ko_KR.eucKR',\n'ko_kr':'ko_KR.eucKR',\n'ko_kr.euc':'ko_KR.eucKR',\n'kok_in':'kok_IN.UTF-8',\n'korean':'ko_KR.eucKR',\n'korean.euc':'ko_KR.eucKR',\n'ks':'ks_IN.UTF-8',\n'ks_in':'ks_IN.UTF-8',\n'ks_in@devanagari.utf8':'ks_IN.UTF-8@devanagari',\n'ku_tr':'ku_TR.ISO8859-9',\n'kw':'kw_GB.ISO8859-1',\n'kw_gb':'kw_GB.ISO8859-1',\n'ky':'ky_KG.UTF-8',\n'ky_kg':'ky_KG.UTF-8',\n'lb_lu':'lb_LU.UTF-8',\n'lg_ug':'lg_UG.ISO8859-10',\n'li_be':'li_BE.UTF-8',\n'li_nl':'li_NL.UTF-8',\n'lij_it':'lij_IT.UTF-8',\n'lithuanian':'lt_LT.ISO8859-13',\n'ln_cd':'ln_CD.UTF-8',\n'lo':'lo_LA.MULELAO-1',\n'lo_la':'lo_LA.MULELAO-1',\n'lo_la.cp1133':'lo_LA.IBM-CP1133',\n'lo_la.ibmcp1133':'lo_LA.IBM-CP1133',\n'lo_la.mulelao1':'lo_LA.MULELAO-1',\n'lt':'lt_LT.ISO8859-13',\n'lt_lt':'lt_LT.ISO8859-13',\n'lv':'lv_LV.ISO8859-13',\n'lv_lv':'lv_LV.ISO8859-13',\n'lzh_tw':'lzh_TW.UTF-8',\n'mag_in':'mag_IN.UTF-8',\n'mai':'mai_IN.UTF-8',\n'mai_in':'mai_IN.UTF-8',\n'mai_np':'mai_NP.UTF-8',\n'mfe_mu':'mfe_MU.UTF-8',\n'mg_mg':'mg_MG.ISO8859-15',\n'mhr_ru':'mhr_RU.UTF-8',\n'mi':'mi_NZ.ISO8859-1',\n'mi_nz':'mi_NZ.ISO8859-1',\n'miq_ni':'miq_NI.UTF-8',\n'mjw_in':'mjw_IN.UTF-8',\n'mk':'mk_MK.ISO8859-5',\n'mk_mk':'mk_MK.ISO8859-5',\n'ml':'ml_IN.UTF-8',\n'ml_in':'ml_IN.UTF-8',\n'mn_mn':'mn_MN.UTF-8',\n'mni_in':'mni_IN.UTF-8',\n'mr':'mr_IN.UTF-8',\n'mr_in':'mr_IN.UTF-8',\n'ms':'ms_MY.ISO8859-1',\n'ms_my':'ms_MY.ISO8859-1',\n'mt':'mt_MT.ISO8859-3',\n'mt_mt':'mt_MT.ISO8859-3',\n'my_mm':'my_MM.UTF-8',\n'nan_tw':'nan_TW.UTF-8',\n'nb':'nb_NO.ISO8859-1',\n'nb_no':'nb_NO.ISO8859-1',\n'nds_de':'nds_DE.UTF-8',\n'nds_nl':'nds_NL.UTF-8',\n'ne_np':'ne_NP.UTF-8',\n'nhn_mx':'nhn_MX.UTF-8',\n'niu_nu':'niu_NU.UTF-8',\n'niu_nz':'niu_NZ.UTF-8',\n'nl':'nl_NL.ISO8859-1',\n'nl_aw':'nl_AW.UTF-8',\n'nl_be':'nl_BE.ISO8859-1',\n'nl_nl':'nl_NL.ISO8859-1',\n'nn':'nn_NO.ISO8859-1',\n'nn_no':'nn_NO.ISO8859-1',\n'no':'no_NO.ISO8859-1',\n'no@nynorsk':'ny_NO.ISO8859-1',\n'no_no':'no_NO.ISO8859-1',\n'no_no.iso88591@bokmal':'no_NO.ISO8859-1',\n'no_no.iso88591@nynorsk':'no_NO.ISO8859-1',\n'norwegian':'no_NO.ISO8859-1',\n'nr':'nr_ZA.ISO8859-1',\n'nr_za':'nr_ZA.ISO8859-1',\n'nso':'nso_ZA.ISO8859-15',\n'nso_za':'nso_ZA.ISO8859-15',\n'ny':'ny_NO.ISO8859-1',\n'ny_no':'ny_NO.ISO8859-1',\n'nynorsk':'nn_NO.ISO8859-1',\n'oc':'oc_FR.ISO8859-1',\n'oc_fr':'oc_FR.ISO8859-1',\n'om_et':'om_ET.UTF-8',\n'om_ke':'om_KE.ISO8859-1',\n'or':'or_IN.UTF-8',\n'or_in':'or_IN.UTF-8',\n'os_ru':'os_RU.UTF-8',\n'pa':'pa_IN.UTF-8',\n'pa_in':'pa_IN.UTF-8',\n'pa_pk':'pa_PK.UTF-8',\n'pap_an':'pap_AN.UTF-8',\n'pap_aw':'pap_AW.UTF-8',\n'pap_cw':'pap_CW.UTF-8',\n'pd':'pd_US.ISO8859-1',\n'pd_de':'pd_DE.ISO8859-1',\n'pd_us':'pd_US.ISO8859-1',\n'ph':'ph_PH.ISO8859-1',\n'ph_ph':'ph_PH.ISO8859-1',\n'pl':'pl_PL.ISO8859-2',\n'pl_pl':'pl_PL.ISO8859-2',\n'polish':'pl_PL.ISO8859-2',\n'portuguese':'pt_PT.ISO8859-1',\n'portuguese_brazil':'pt_BR.ISO8859-1',\n'posix':'C',\n'posix-utf2':'C',\n'pp':'pp_AN.ISO8859-1',\n'pp_an':'pp_AN.ISO8859-1',\n'ps_af':'ps_AF.UTF-8',\n'pt':'pt_PT.ISO8859-1',\n'pt_br':'pt_BR.ISO8859-1',\n'pt_pt':'pt_PT.ISO8859-1',\n'quz_pe':'quz_PE.UTF-8',\n'raj_in':'raj_IN.UTF-8',\n'ro':'ro_RO.ISO8859-2',\n'ro_ro':'ro_RO.ISO8859-2',\n'romanian':'ro_RO.ISO8859-2',\n'ru':'ru_RU.UTF-8',\n'ru_ru':'ru_RU.UTF-8',\n'ru_ua':'ru_UA.KOI8-U',\n'rumanian':'ro_RO.ISO8859-2',\n'russian':'ru_RU.KOI8-R',\n'rw':'rw_RW.ISO8859-1',\n'rw_rw':'rw_RW.ISO8859-1',\n'sa_in':'sa_IN.UTF-8',\n'sat_in':'sat_IN.UTF-8',\n'sc_it':'sc_IT.UTF-8',\n'sd':'sd_IN.UTF-8',\n'sd_in':'sd_IN.UTF-8',\n'sd_in@devanagari.utf8':'sd_IN.UTF-8@devanagari',\n'sd_pk':'sd_PK.UTF-8',\n'se_no':'se_NO.UTF-8',\n'serbocroatian':'sr_RS.UTF-8@latin',\n'sgs_lt':'sgs_LT.UTF-8',\n'sh':'sr_RS.UTF-8@latin',\n'sh_ba.iso88592@bosnia':'sr_CS.ISO8859-2',\n'sh_hr':'sh_HR.ISO8859-2',\n'sh_hr.iso88592':'hr_HR.ISO8859-2',\n'sh_sp':'sr_CS.ISO8859-2',\n'sh_yu':'sr_RS.UTF-8@latin',\n'shn_mm':'shn_MM.UTF-8',\n'shs_ca':'shs_CA.UTF-8',\n'si':'si_LK.UTF-8',\n'si_lk':'si_LK.UTF-8',\n'sid_et':'sid_ET.UTF-8',\n'sinhala':'si_LK.UTF-8',\n'sk':'sk_SK.ISO8859-2',\n'sk_sk':'sk_SK.ISO8859-2',\n'sl':'sl_SI.ISO8859-2',\n'sl_cs':'sl_CS.ISO8859-2',\n'sl_si':'sl_SI.ISO8859-2',\n'slovak':'sk_SK.ISO8859-2',\n'slovene':'sl_SI.ISO8859-2',\n'slovenian':'sl_SI.ISO8859-2',\n'sm_ws':'sm_WS.UTF-8',\n'so_dj':'so_DJ.ISO8859-1',\n'so_et':'so_ET.UTF-8',\n'so_ke':'so_KE.ISO8859-1',\n'so_so':'so_SO.ISO8859-1',\n'sp':'sr_CS.ISO8859-5',\n'sp_yu':'sr_CS.ISO8859-5',\n'spanish':'es_ES.ISO8859-1',\n'spanish_spain':'es_ES.ISO8859-1',\n'sq':'sq_AL.ISO8859-2',\n'sq_al':'sq_AL.ISO8859-2',\n'sq_mk':'sq_MK.UTF-8',\n'sr':'sr_RS.UTF-8',\n'sr@cyrillic':'sr_RS.UTF-8',\n'sr@latn':'sr_CS.UTF-8@latin',\n'sr_cs':'sr_CS.UTF-8',\n'sr_cs.iso88592@latn':'sr_CS.ISO8859-2',\n'sr_cs@latn':'sr_CS.UTF-8@latin',\n'sr_me':'sr_ME.UTF-8',\n'sr_rs':'sr_RS.UTF-8',\n'sr_rs@latn':'sr_RS.UTF-8@latin',\n'sr_sp':'sr_CS.ISO8859-2',\n'sr_yu':'sr_RS.UTF-8@latin',\n'sr_yu.cp1251@cyrillic':'sr_CS.CP1251',\n'sr_yu.iso88592':'sr_CS.ISO8859-2',\n'sr_yu.iso88595':'sr_CS.ISO8859-5',\n'sr_yu.iso88595@cyrillic':'sr_CS.ISO8859-5',\n'sr_yu.microsoftcp1251@cyrillic':'sr_CS.CP1251',\n'sr_yu.utf8':'sr_RS.UTF-8',\n'sr_yu.utf8@cyrillic':'sr_RS.UTF-8',\n'sr_yu@cyrillic':'sr_RS.UTF-8',\n'ss':'ss_ZA.ISO8859-1',\n'ss_za':'ss_ZA.ISO8859-1',\n'st':'st_ZA.ISO8859-1',\n'st_za':'st_ZA.ISO8859-1',\n'sv':'sv_SE.ISO8859-1',\n'sv_fi':'sv_FI.ISO8859-1',\n'sv_se':'sv_SE.ISO8859-1',\n'sw_ke':'sw_KE.UTF-8',\n'sw_tz':'sw_TZ.UTF-8',\n'swedish':'sv_SE.ISO8859-1',\n'szl_pl':'szl_PL.UTF-8',\n'ta':'ta_IN.TSCII-0',\n'ta_in':'ta_IN.TSCII-0',\n'ta_in.tscii':'ta_IN.TSCII-0',\n'ta_in.tscii0':'ta_IN.TSCII-0',\n'ta_lk':'ta_LK.UTF-8',\n'tcy_in.utf8':'tcy_IN.UTF-8',\n'te':'te_IN.UTF-8',\n'te_in':'te_IN.UTF-8',\n'tg':'tg_TJ.KOI8-C',\n'tg_tj':'tg_TJ.KOI8-C',\n'th':'th_TH.ISO8859-11',\n'th_th':'th_TH.ISO8859-11',\n'th_th.tactis':'th_TH.TIS620',\n'th_th.tis620':'th_TH.TIS620',\n'thai':'th_TH.ISO8859-11',\n'the_np':'the_NP.UTF-8',\n'ti_er':'ti_ER.UTF-8',\n'ti_et':'ti_ET.UTF-8',\n'tig_er':'tig_ER.UTF-8',\n'tk_tm':'tk_TM.UTF-8',\n'tl':'tl_PH.ISO8859-1',\n'tl_ph':'tl_PH.ISO8859-1',\n'tn':'tn_ZA.ISO8859-15',\n'tn_za':'tn_ZA.ISO8859-15',\n'to_to':'to_TO.UTF-8',\n'tpi_pg':'tpi_PG.UTF-8',\n'tr':'tr_TR.ISO8859-9',\n'tr_cy':'tr_CY.ISO8859-9',\n'tr_tr':'tr_TR.ISO8859-9',\n'ts':'ts_ZA.ISO8859-1',\n'ts_za':'ts_ZA.ISO8859-1',\n'tt':'tt_RU.TATAR-CYR',\n'tt_ru':'tt_RU.TATAR-CYR',\n'tt_ru.tatarcyr':'tt_RU.TATAR-CYR',\n'tt_ru@iqtelif':'tt_RU.UTF-8@iqtelif',\n'turkish':'tr_TR.ISO8859-9',\n'ug_cn':'ug_CN.UTF-8',\n'uk':'uk_UA.KOI8-U',\n'uk_ua':'uk_UA.KOI8-U',\n'univ':'en_US.utf',\n'universal':'en_US.utf',\n'universal.utf8@ucs4':'en_US.UTF-8',\n'unm_us':'unm_US.UTF-8',\n'ur':'ur_PK.CP1256',\n'ur_in':'ur_IN.UTF-8',\n'ur_pk':'ur_PK.CP1256',\n'uz':'uz_UZ.UTF-8',\n'uz_uz':'uz_UZ.UTF-8',\n'uz_uz@cyrillic':'uz_UZ.UTF-8',\n've':'ve_ZA.UTF-8',\n've_za':'ve_ZA.UTF-8',\n'vi':'vi_VN.TCVN',\n'vi_vn':'vi_VN.TCVN',\n'vi_vn.tcvn':'vi_VN.TCVN',\n'vi_vn.tcvn5712':'vi_VN.TCVN',\n'vi_vn.viscii':'vi_VN.VISCII',\n'vi_vn.viscii111':'vi_VN.VISCII',\n'wa':'wa_BE.ISO8859-1',\n'wa_be':'wa_BE.ISO8859-1',\n'wae_ch':'wae_CH.UTF-8',\n'wal_et':'wal_ET.UTF-8',\n'wo_sn':'wo_SN.UTF-8',\n'xh':'xh_ZA.ISO8859-1',\n'xh_za':'xh_ZA.ISO8859-1',\n'yi':'yi_US.CP1255',\n'yi_us':'yi_US.CP1255',\n'yo_ng':'yo_NG.UTF-8',\n'yue_hk':'yue_HK.UTF-8',\n'yuw_pg':'yuw_PG.UTF-8',\n'zh':'zh_CN.eucCN',\n'zh_cn':'zh_CN.gb2312',\n'zh_cn.big5':'zh_TW.big5',\n'zh_cn.euc':'zh_CN.eucCN',\n'zh_hk':'zh_HK.big5hkscs',\n'zh_hk.big5hk':'zh_HK.big5hkscs',\n'zh_sg':'zh_SG.GB2312',\n'zh_sg.gbk':'zh_SG.GBK',\n'zh_tw':'zh_TW.big5',\n'zh_tw.euc':'zh_TW.eucTW',\n'zh_tw.euctw':'zh_TW.eucTW',\n'zu':'zu_ZA.ISO8859-1',\n'zu_za':'zu_ZA.ISO8859-1',\n}\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nwindows_locale={\n0x0436:\"af_ZA\",\n0x041c:\"sq_AL\",\n0x0484:\"gsw_FR\",\n0x045e:\"am_ET\",\n0x0401:\"ar_SA\",\n0x0801:\"ar_IQ\",\n0x0c01:\"ar_EG\",\n0x1001:\"ar_LY\",\n0x1401:\"ar_DZ\",\n0x1801:\"ar_MA\",\n0x1c01:\"ar_TN\",\n0x2001:\"ar_OM\",\n0x2401:\"ar_YE\",\n0x2801:\"ar_SY\",\n0x2c01:\"ar_JO\",\n0x3001:\"ar_LB\",\n0x3401:\"ar_KW\",\n0x3801:\"ar_AE\",\n0x3c01:\"ar_BH\",\n0x4001:\"ar_QA\",\n0x042b:\"hy_AM\",\n0x044d:\"as_IN\",\n0x042c:\"az_AZ\",\n0x082c:\"az_AZ\",\n0x046d:\"ba_RU\",\n0x042d:\"eu_ES\",\n0x0423:\"be_BY\",\n0x0445:\"bn_IN\",\n0x201a:\"bs_BA\",\n0x141a:\"bs_BA\",\n0x047e:\"br_FR\",\n0x0402:\"bg_BG\",\n\n0x0403:\"ca_ES\",\n0x0004:\"zh_CHS\",\n0x0404:\"zh_TW\",\n0x0804:\"zh_CN\",\n0x0c04:\"zh_HK\",\n0x1004:\"zh_SG\",\n0x1404:\"zh_MO\",\n0x7c04:\"zh_CHT\",\n0x0483:\"co_FR\",\n0x041a:\"hr_HR\",\n0x101a:\"hr_BA\",\n0x0405:\"cs_CZ\",\n0x0406:\"da_DK\",\n0x048c:\"gbz_AF\",\n0x0465:\"div_MV\",\n0x0413:\"nl_NL\",\n0x0813:\"nl_BE\",\n0x0409:\"en_US\",\n0x0809:\"en_GB\",\n0x0c09:\"en_AU\",\n0x1009:\"en_CA\",\n0x1409:\"en_NZ\",\n0x1809:\"en_IE\",\n0x1c09:\"en_ZA\",\n0x2009:\"en_JA\",\n0x2409:\"en_CB\",\n0x2809:\"en_BZ\",\n0x2c09:\"en_TT\",\n0x3009:\"en_ZW\",\n0x3409:\"en_PH\",\n0x4009:\"en_IN\",\n0x4409:\"en_MY\",\n0x4809:\"en_IN\",\n0x0425:\"et_EE\",\n0x0438:\"fo_FO\",\n0x0464:\"fil_PH\",\n0x040b:\"fi_FI\",\n0x040c:\"fr_FR\",\n0x080c:\"fr_BE\",\n0x0c0c:\"fr_CA\",\n0x100c:\"fr_CH\",\n0x140c:\"fr_LU\",\n0x180c:\"fr_MC\",\n0x0462:\"fy_NL\",\n0x0456:\"gl_ES\",\n0x0437:\"ka_GE\",\n0x0407:\"de_DE\",\n0x0807:\"de_CH\",\n0x0c07:\"de_AT\",\n0x1007:\"de_LU\",\n0x1407:\"de_LI\",\n0x0408:\"el_GR\",\n0x046f:\"kl_GL\",\n0x0447:\"gu_IN\",\n0x0468:\"ha_NG\",\n0x040d:\"he_IL\",\n0x0439:\"hi_IN\",\n0x040e:\"hu_HU\",\n0x040f:\"is_IS\",\n0x0421:\"id_ID\",\n0x045d:\"iu_CA\",\n0x085d:\"iu_CA\",\n0x083c:\"ga_IE\",\n0x0410:\"it_IT\",\n0x0810:\"it_CH\",\n0x0411:\"ja_JP\",\n0x044b:\"kn_IN\",\n0x043f:\"kk_KZ\",\n0x0453:\"kh_KH\",\n0x0486:\"qut_GT\",\n0x0487:\"rw_RW\",\n0x0457:\"kok_IN\",\n0x0412:\"ko_KR\",\n0x0440:\"ky_KG\",\n0x0454:\"lo_LA\",\n0x0426:\"lv_LV\",\n0x0427:\"lt_LT\",\n0x082e:\"dsb_DE\",\n0x046e:\"lb_LU\",\n0x042f:\"mk_MK\",\n0x043e:\"ms_MY\",\n0x083e:\"ms_BN\",\n0x044c:\"ml_IN\",\n0x043a:\"mt_MT\",\n0x0481:\"mi_NZ\",\n0x047a:\"arn_CL\",\n0x044e:\"mr_IN\",\n0x047c:\"moh_CA\",\n0x0450:\"mn_MN\",\n0x0850:\"mn_CN\",\n0x0461:\"ne_NP\",\n0x0414:\"nb_NO\",\n0x0814:\"nn_NO\",\n0x0482:\"oc_FR\",\n0x0448:\"or_IN\",\n0x0463:\"ps_AF\",\n0x0429:\"fa_IR\",\n0x0415:\"pl_PL\",\n0x0416:\"pt_BR\",\n0x0816:\"pt_PT\",\n0x0446:\"pa_IN\",\n0x046b:\"quz_BO\",\n0x086b:\"quz_EC\",\n0x0c6b:\"quz_PE\",\n0x0418:\"ro_RO\",\n0x0417:\"rm_CH\",\n0x0419:\"ru_RU\",\n0x243b:\"smn_FI\",\n0x103b:\"smj_NO\",\n0x143b:\"smj_SE\",\n0x043b:\"se_NO\",\n0x083b:\"se_SE\",\n0x0c3b:\"se_FI\",\n0x203b:\"sms_FI\",\n0x183b:\"sma_NO\",\n0x1c3b:\"sma_SE\",\n0x044f:\"sa_IN\",\n0x0c1a:\"sr_SP\",\n0x1c1a:\"sr_BA\",\n0x081a:\"sr_SP\",\n0x181a:\"sr_BA\",\n0x045b:\"si_LK\",\n0x046c:\"ns_ZA\",\n0x0432:\"tn_ZA\",\n0x041b:\"sk_SK\",\n0x0424:\"sl_SI\",\n0x040a:\"es_ES\",\n0x080a:\"es_MX\",\n0x0c0a:\"es_ES\",\n0x100a:\"es_GT\",\n0x140a:\"es_CR\",\n0x180a:\"es_PA\",\n0x1c0a:\"es_DO\",\n0x200a:\"es_VE\",\n0x240a:\"es_CO\",\n0x280a:\"es_PE\",\n0x2c0a:\"es_AR\",\n0x300a:\"es_EC\",\n0x340a:\"es_CL\",\n0x380a:\"es_UR\",\n0x3c0a:\"es_PY\",\n0x400a:\"es_BO\",\n0x440a:\"es_SV\",\n0x480a:\"es_HN\",\n0x4c0a:\"es_NI\",\n0x500a:\"es_PR\",\n0x540a:\"es_US\",\n\n0x0441:\"sw_KE\",\n0x041d:\"sv_SE\",\n0x081d:\"sv_FI\",\n0x045a:\"syr_SY\",\n0x0428:\"tg_TJ\",\n0x085f:\"tmz_DZ\",\n0x0449:\"ta_IN\",\n0x0444:\"tt_RU\",\n0x044a:\"te_IN\",\n0x041e:\"th_TH\",\n0x0851:\"bo_BT\",\n0x0451:\"bo_CN\",\n0x041f:\"tr_TR\",\n0x0442:\"tk_TM\",\n0x0480:\"ug_CN\",\n0x0422:\"uk_UA\",\n0x042e:\"wen_DE\",\n0x0420:\"ur_PK\",\n0x0820:\"ur_IN\",\n0x0443:\"uz_UZ\",\n0x0843:\"uz_UZ\",\n0x042a:\"vi_VN\",\n0x0452:\"cy_GB\",\n0x0488:\"wo_SN\",\n0x0434:\"xh_ZA\",\n0x0485:\"sah_RU\",\n0x0478:\"ii_CN\",\n0x046a:\"yo_NG\",\n0x0435:\"zu_ZA\",\n}\n\ndef _print_locale():\n\n ''\n \n categories={}\n def _init_categories(categories=categories):\n  for k,v in globals().items():\n   if k[:3]=='LC_':\n    categories[k]=v\n _init_categories()\n del categories['LC_ALL']\n \n print('Locale defaults as determined by getdefaultlocale():')\n print('-'*72)\n lang,enc=getdefaultlocale()\n print('Language: ',lang or '(undefined)')\n print('Encoding: ',enc or '(undefined)')\n print()\n \n print('Locale settings on startup:')\n print('-'*72)\n for name,category in categories.items():\n  print(name,'...')\n  lang,enc=getlocale(category)\n  print('   Language: ',lang or '(undefined)')\n  print('   Encoding: ',enc or '(undefined)')\n  print()\n  \n print()\n print('Locale settings after calling resetlocale():')\n print('-'*72)\n resetlocale()\n for name,category in categories.items():\n  print(name,'...')\n  lang,enc=getlocale(category)\n  print('   Language: ',lang or '(undefined)')\n  print('   Encoding: ',enc or '(undefined)')\n  print()\n  \n try :\n  setlocale(LC_ALL,\"\")\n except :\n  print('NOTE:')\n  print('setlocale(LC_ALL, \"\") does not support the default locale')\n  print('given in the OS environment variables.')\n else :\n  print()\n  print('Locale settings after calling setlocale(LC_ALL, \"\"):')\n  print('-'*72)\n  for name,category in categories.items():\n   print(name,'...')\n   lang,enc=getlocale(category)\n   print('   Language: ',lang or '(undefined)')\n   print('   Encoding: ',enc or '(undefined)')\n   print()\n   \n   \n   \ntry :\n LC_MESSAGES\nexcept NameError:\n pass\nelse :\n __all__.append(\"LC_MESSAGES\")\n \nif __name__ =='__main__':\n print('Locale aliasing:')\n print()\n _print_locale()\n print()\n print('Number formatting:')\n print()\n _test()\n", ["_bootlocale", "_collections_abc", "_locale", "builtins", "encodings", "encodings.aliases", "functools", "os", "re", "sys", "warnings"]], "nntplib": [".py", "''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nimport re\nimport socket\nimport collections\nimport datetime\nimport warnings\n\ntry :\n import ssl\nexcept ImportError:\n _have_ssl=False\nelse :\n _have_ssl=True\n \nfrom email.header import decode_header as _email_decode_header\nfrom socket import _GLOBAL_DEFAULT_TIMEOUT\n\n__all__=[\"NNTP\",\n\"NNTPError\",\"NNTPReplyError\",\"NNTPTemporaryError\",\n\"NNTPPermanentError\",\"NNTPProtocolError\",\"NNTPDataError\",\n\"decode_header\",\n]\n\n\n\n\n\n_MAXLINE=2048\n\n\n\nclass NNTPError(Exception):\n ''\n def __init__(self,*args):\n  Exception.__init__(self,*args)\n  try :\n   self.response=args[0]\n  except IndexError:\n   self.response='No response given'\n   \nclass NNTPReplyError(NNTPError):\n ''\n pass\n \nclass NNTPTemporaryError(NNTPError):\n ''\n pass\n \nclass NNTPPermanentError(NNTPError):\n ''\n pass\n \nclass NNTPProtocolError(NNTPError):\n ''\n pass\n \nclass NNTPDataError(NNTPError):\n ''\n pass\n \n \n \nNNTP_PORT=119\nNNTP_SSL_PORT=563\n\n\n_LONGRESP={\n'100',\n'101',\n'211',\n'215',\n'220',\n'221',\n'222',\n'224',\n'225',\n'230',\n'231',\n'282',\n}\n\n\n_DEFAULT_OVERVIEW_FMT=[\n\"subject\",\"from\",\"date\",\"message-id\",\"references\",\":bytes\",\":lines\"]\n\n\n_OVERVIEW_FMT_ALTERNATIVES={\n'bytes':':bytes',\n'lines':':lines',\n}\n\n\n_CRLF=b'\\r\\n'\n\nGroupInfo=collections.namedtuple('GroupInfo',\n['group','last','first','flag'])\n\nArticleInfo=collections.namedtuple('ArticleInfo',\n['number','message_id','lines'])\n\n\n\ndef decode_header(header_str):\n ''\n \n parts=[]\n for v,enc in _email_decode_header(header_str):\n  if isinstance(v,bytes):\n   parts.append(v.decode(enc or 'ascii'))\n  else :\n   parts.append(v)\n return ''.join(parts)\n \ndef _parse_overview_fmt(lines):\n ''\n\n\n \n fmt=[]\n for line in lines:\n  if line[0]==':':\n  \n   name,_,suffix=line[1:].partition(':')\n   name=':'+name\n  else :\n  \n   name,_,suffix=line.partition(':')\n  name=name.lower()\n  name=_OVERVIEW_FMT_ALTERNATIVES.get(name,name)\n  \n  fmt.append(name)\n defaults=_DEFAULT_OVERVIEW_FMT\n if len(fmt)<len(defaults):\n  raise NNTPDataError(\"LIST OVERVIEW.FMT response too short\")\n if fmt[:len(defaults)]!=defaults:\n  raise NNTPDataError(\"LIST OVERVIEW.FMT redefines default fields\")\n return fmt\n \ndef _parse_overview(lines,fmt,data_process_func=None ):\n ''\n \n n_defaults=len(_DEFAULT_OVERVIEW_FMT)\n overview=[]\n for line in lines:\n  fields={}\n  article_number,*tokens=line.split('\\t')\n  article_number=int(article_number)\n  for i,token in enumerate(tokens):\n   if i >=len(fmt):\n   \n   \n   \n    continue\n   field_name=fmt[i]\n   is_metadata=field_name.startswith(':')\n   if i >=n_defaults and not is_metadata:\n   \n   \n    h=field_name+\": \"\n    if token and token[:len(h)].lower()!=h:\n     raise NNTPDataError(\"OVER/XOVER response doesn't include \"\n     \"names of additional headers\")\n    token=token[len(h):]if token else None\n   fields[fmt[i]]=token\n  overview.append((article_number,fields))\n return overview\n \ndef _parse_datetime(date_str,time_str=None ):\n ''\n\n\n \n if time_str is None :\n  time_str=date_str[-6:]\n  date_str=date_str[:-6]\n hours=int(time_str[:2])\n minutes=int(time_str[2:4])\n seconds=int(time_str[4:])\n year=int(date_str[:-4])\n month=int(date_str[-4:-2])\n day=int(date_str[-2:])\n \n \n if year <70:\n  year +=2000\n elif year <100:\n  year +=1900\n return datetime.datetime(year,month,day,hours,minutes,seconds)\n \ndef _unparse_datetime(dt,legacy=False ):\n ''\n\n\n\n\n\n\n\n\n\n\n \n if not isinstance(dt,datetime.datetime):\n  time_str=\"000000\"\n else :\n  time_str=\"{0.hour:02d}{0.minute:02d}{0.second:02d}\".format(dt)\n y=dt.year\n if legacy:\n  y=y %100\n  date_str=\"{0:02d}{1.month:02d}{1.day:02d}\".format(y,dt)\n else :\n  date_str=\"{0:04d}{1.month:02d}{1.day:02d}\".format(y,dt)\n return date_str,time_str\n \n \nif _have_ssl:\n\n def _encrypt_on(sock,context,hostname):\n  ''\n\n\n\n\n  \n  \n  if context is None :\n   context=ssl._create_stdlib_context()\n  return context.wrap_socket(sock,server_hostname=hostname)\n  \n  \n  \nclass _NNTPBase:\n\n\n\n\n\n\n\n\n\n\n\n\n encoding='utf-8'\n errors='surrogateescape'\n \n def __init__(self,file,host,\n readermode=None ,timeout=_GLOBAL_DEFAULT_TIMEOUT):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n  \n  self.host=host\n  self.file=file\n  self.debugging=0\n  self.welcome=self._getresp()\n  \n  \n  self._caps=None\n  self.getcapabilities()\n  \n  \n  \n  \n  \n  \n  \n  \n  self.readermode_afterauth=False\n  if readermode and 'READER'not in self._caps:\n   self._setreadermode()\n   if not self.readermode_afterauth:\n   \n    self._caps=None\n    self.getcapabilities()\n    \n    \n    \n    \n  self.tls_on=False\n  \n  \n  self.authenticated=False\n  \n def __enter__(self):\n  return self\n  \n def __exit__(self,*args):\n  is_connected=lambda :hasattr(self,\"file\")\n  if is_connected():\n   try :\n    self.quit()\n   except (OSError,EOFError):\n    pass\n   finally :\n    if is_connected():\n     self._close()\n     \n def getwelcome(self):\n  ''\n\n\n  \n  \n  if self.debugging:print('*welcome*',repr(self.welcome))\n  return self.welcome\n  \n def getcapabilities(self):\n  ''\n\n  \n  if self._caps is None :\n   self.nntp_version=1\n   self.nntp_implementation=None\n   try :\n    resp,caps=self.capabilities()\n   except (NNTPPermanentError,NNTPTemporaryError):\n   \n    self._caps={}\n   else :\n    self._caps=caps\n    if 'VERSION'in caps:\n    \n    \n     self.nntp_version=max(map(int,caps['VERSION']))\n    if 'IMPLEMENTATION'in caps:\n     self.nntp_implementation=' '.join(caps['IMPLEMENTATION'])\n  return self._caps\n  \n def set_debuglevel(self,level):\n  ''\n\n\n  \n  \n  self.debugging=level\n debug=set_debuglevel\n \n def _putline(self,line):\n  ''\n  \n  line=line+_CRLF\n  if self.debugging >1:print('*put*',repr(line))\n  self.file.write(line)\n  self.file.flush()\n  \n def _putcmd(self,line):\n  ''\n  \n  if self.debugging:print('*cmd*',repr(line))\n  line=line.encode(self.encoding,self.errors)\n  self._putline(line)\n  \n def _getline(self,strip_crlf=True ):\n  ''\n\n  \n  line=self.file.readline(_MAXLINE+1)\n  if len(line)>_MAXLINE:\n   raise NNTPDataError('line too long')\n  if self.debugging >1:\n   print('*get*',repr(line))\n  if not line:raise EOFError\n  if strip_crlf:\n   if line[-2:]==_CRLF:\n    line=line[:-2]\n   elif line[-1:]in _CRLF:\n    line=line[:-1]\n  return line\n  \n def _getresp(self):\n  ''\n\n  \n  resp=self._getline()\n  if self.debugging:print('*resp*',repr(resp))\n  resp=resp.decode(self.encoding,self.errors)\n  c=resp[:1]\n  if c =='4':\n   raise NNTPTemporaryError(resp)\n  if c =='5':\n   raise NNTPPermanentError(resp)\n  if c not in '123':\n   raise NNTPProtocolError(resp)\n  return resp\n  \n def _getlongresp(self,file=None ):\n  ''\n\n\n\n\n\n  \n  \n  openedFile=None\n  try :\n  \n   if isinstance(file,(str,bytes)):\n    openedFile=file=open(file,\"wb\")\n    \n   resp=self._getresp()\n   if resp[:3]not in _LONGRESP:\n    raise NNTPReplyError(resp)\n    \n   lines=[]\n   if file is not None :\n   \n    terminators=(b'.'+_CRLF,b'.\\n')\n    while 1:\n     line=self._getline(False )\n     if line in terminators:\n      break\n     if line.startswith(b'..'):\n      line=line[1:]\n     file.write(line)\n   else :\n    terminator=b'.'\n    while 1:\n     line=self._getline()\n     if line ==terminator:\n      break\n     if line.startswith(b'..'):\n      line=line[1:]\n     lines.append(line)\n  finally :\n  \n   if openedFile:\n    openedFile.close()\n    \n  return resp,lines\n  \n def _shortcmd(self,line):\n  ''\n  \n  self._putcmd(line)\n  return self._getresp()\n  \n def _longcmd(self,line,file=None ):\n  ''\n  \n  self._putcmd(line)\n  return self._getlongresp(file)\n  \n def _longcmdstring(self,line,file=None ):\n  ''\n\n\n  \n  self._putcmd(line)\n  resp,list=self._getlongresp(file)\n  return resp,[line.decode(self.encoding,self.errors)\n  for line in list]\n  \n def _getoverviewfmt(self):\n  ''\n  \n  try :\n   return self._cachedoverviewfmt\n  except AttributeError:\n   pass\n  try :\n   resp,lines=self._longcmdstring(\"LIST OVERVIEW.FMT\")\n  except NNTPPermanentError:\n  \n   fmt=_DEFAULT_OVERVIEW_FMT[:]\n  else :\n   fmt=_parse_overview_fmt(lines)\n  self._cachedoverviewfmt=fmt\n  return fmt\n  \n def _grouplist(self,lines):\n \n  return [GroupInfo(*line.split())for line in lines]\n  \n def capabilities(self):\n  ''\n\n\n\n\n  \n  caps={}\n  resp,lines=self._longcmdstring(\"CAPABILITIES\")\n  for line in lines:\n   name,*tokens=line.split()\n   caps[name]=tokens\n  return resp,caps\n  \n def newgroups(self,date,*,file=None ):\n  ''\n\n\n\n\n  \n  if not isinstance(date,(datetime.date,datetime.date)):\n   raise TypeError(\n   \"the date parameter must be a date or datetime object, \"\n   \"not '{:40}'\".format(date.__class__.__name__))\n  date_str,time_str=_unparse_datetime(date,self.nntp_version <2)\n  cmd='NEWGROUPS {0} {1}'.format(date_str,time_str)\n  resp,lines=self._longcmdstring(cmd,file)\n  return resp,self._grouplist(lines)\n  \n def newnews(self,group,date,*,file=None ):\n  ''\n\n\n\n\n\n  \n  if not isinstance(date,(datetime.date,datetime.date)):\n   raise TypeError(\n   \"the date parameter must be a date or datetime object, \"\n   \"not '{:40}'\".format(date.__class__.__name__))\n  date_str,time_str=_unparse_datetime(date,self.nntp_version <2)\n  cmd='NEWNEWS {0} {1} {2}'.format(group,date_str,time_str)\n  return self._longcmdstring(cmd,file)\n  \n def list(self,group_pattern=None ,*,file=None ):\n  ''\n\n\n\n\n\n  \n  if group_pattern is not None :\n   command='LIST ACTIVE '+group_pattern\n  else :\n   command='LIST'\n  resp,lines=self._longcmdstring(command,file)\n  return resp,self._grouplist(lines)\n  \n def _getdescriptions(self,group_pattern,return_all):\n  line_pat=re.compile('^(?P<group>[^ \\t]+)[ \\t]+(.*)$')\n  \n  resp,lines=self._longcmdstring('LIST NEWSGROUPS '+group_pattern)\n  if not resp.startswith('215'):\n  \n  \n  \n   resp,lines=self._longcmdstring('XGTITLE '+group_pattern)\n  groups={}\n  for raw_line in lines:\n   match=line_pat.search(raw_line.strip())\n   if match:\n    name,desc=match.group(1,2)\n    if not return_all:\n     return desc\n    groups[name]=desc\n  if return_all:\n   return resp,groups\n  else :\n  \n   return ''\n   \n def description(self,group):\n  ''\n\n\n\n\n\n\n\n\n  \n  return self._getdescriptions(group,False )\n  \n def descriptions(self,group_pattern):\n  ''\n  return self._getdescriptions(group_pattern,True )\n  \n def group(self,name):\n  ''\n\n\n\n\n\n\n\n  \n  resp=self._shortcmd('GROUP '+name)\n  if not resp.startswith('211'):\n   raise NNTPReplyError(resp)\n  words=resp.split()\n  count=first=last=0\n  n=len(words)\n  if n >1:\n   count=words[1]\n   if n >2:\n    first=words[2]\n    if n >3:\n     last=words[3]\n     if n >4:\n      name=words[4].lower()\n  return resp,int(count),int(first),int(last),name\n  \n def help(self,*,file=None ):\n  ''\n\n\n\n\n\n  \n  return self._longcmdstring('HELP',file)\n  \n def _statparse(self,resp):\n  ''\n  \n  if not resp.startswith('22'):\n   raise NNTPReplyError(resp)\n  words=resp.split()\n  art_num=int(words[1])\n  message_id=words[2]\n  return resp,art_num,message_id\n  \n def _statcmd(self,line):\n  ''\n  resp=self._shortcmd(line)\n  return self._statparse(resp)\n  \n def stat(self,message_spec=None ):\n  ''\n\n\n\n\n\n\n  \n  if message_spec:\n   return self._statcmd('STAT {0}'.format(message_spec))\n  else :\n   return self._statcmd('STAT')\n   \n def next(self):\n  ''\n  return self._statcmd('NEXT')\n  \n def last(self):\n  ''\n  return self._statcmd('LAST')\n  \n def _artcmd(self,line,file=None ):\n  ''\n  resp,lines=self._longcmd(line,file)\n  resp,art_num,message_id=self._statparse(resp)\n  return resp,ArticleInfo(art_num,message_id,lines)\n  \n def head(self,message_spec=None ,*,file=None ):\n  ''\n\n\n\n\n\n  \n  if message_spec is not None :\n   cmd='HEAD {0}'.format(message_spec)\n  else :\n   cmd='HEAD'\n  return self._artcmd(cmd,file)\n  \n def body(self,message_spec=None ,*,file=None ):\n  ''\n\n\n\n\n\n  \n  if message_spec is not None :\n   cmd='BODY {0}'.format(message_spec)\n  else :\n   cmd='BODY'\n  return self._artcmd(cmd,file)\n  \n def article(self,message_spec=None ,*,file=None ):\n  ''\n\n\n\n\n\n  \n  if message_spec is not None :\n   cmd='ARTICLE {0}'.format(message_spec)\n  else :\n   cmd='ARTICLE'\n  return self._artcmd(cmd,file)\n  \n def slave(self):\n  ''\n\n  \n  return self._shortcmd('SLAVE')\n  \n def xhdr(self,hdr,str,*,file=None ):\n  ''\n\n\n\n\n\n\n  \n  pat=re.compile('^([0-9]+) ?(.*)\\n?')\n  resp,lines=self._longcmdstring('XHDR {0} {1}'.format(hdr,str),file)\n  def remove_number(line):\n   m=pat.match(line)\n   return m.group(1,2)if m else line\n  return resp,[remove_number(line)for line in lines]\n  \n def xover(self,start,end,*,file=None ):\n  ''\n\n\n\n\n\n\n  \n  resp,lines=self._longcmdstring('XOVER {0}-{1}'.format(start,end),\n  file)\n  fmt=self._getoverviewfmt()\n  return resp,_parse_overview(lines,fmt)\n  \n def over(self,message_spec,*,file=None ):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  cmd='OVER'if 'OVER'in self._caps else 'XOVER'\n  if isinstance(message_spec,(tuple,list)):\n   start,end=message_spec\n   cmd +=' {0}-{1}'.format(start,end or '')\n  elif message_spec is not None :\n   cmd=cmd+' '+message_spec\n  resp,lines=self._longcmdstring(cmd,file)\n  fmt=self._getoverviewfmt()\n  return resp,_parse_overview(lines,fmt)\n  \n def xgtitle(self,group,*,file=None ):\n  ''\n\n\n\n  \n  warnings.warn(\"The XGTITLE extension is not actively used, \"\n  \"use descriptions() instead\",\n  DeprecationWarning,2)\n  line_pat=re.compile('^([^ \\t]+)[ \\t]+(.*)$')\n  resp,raw_lines=self._longcmdstring('XGTITLE '+group,file)\n  lines=[]\n  for raw_line in raw_lines:\n   match=line_pat.search(raw_line.strip())\n   if match:\n    lines.append(match.group(1,2))\n  return resp,lines\n  \n def xpath(self,id):\n  ''\n\n\n\n\n  \n  warnings.warn(\"The XPATH extension is not actively used\",\n  DeprecationWarning,2)\n  \n  resp=self._shortcmd('XPATH {0}'.format(id))\n  if not resp.startswith('223'):\n   raise NNTPReplyError(resp)\n  try :\n   [resp_num,path]=resp.split()\n  except ValueError:\n   raise NNTPReplyError(resp)from None\n  else :\n   return resp,path\n   \n def date(self):\n  ''\n\n\n\n  \n  resp=self._shortcmd(\"DATE\")\n  if not resp.startswith('111'):\n   raise NNTPReplyError(resp)\n  elem=resp.split()\n  if len(elem)!=2:\n   raise NNTPDataError(resp)\n  date=elem[1]\n  if len(date)!=14:\n   raise NNTPDataError(resp)\n  return resp,_parse_datetime(date,None )\n  \n def _post(self,command,f):\n  resp=self._shortcmd(command)\n  \n  if not resp.startswith('3'):\n   raise NNTPReplyError(resp)\n  if isinstance(f,(bytes,bytearray)):\n   f=f.splitlines()\n   \n   \n   \n   \n  for line in f:\n   if not line.endswith(_CRLF):\n    line=line.rstrip(b\"\\r\\n\")+_CRLF\n   if line.startswith(b'.'):\n    line=b'.'+line\n   self.file.write(line)\n  self.file.write(b\".\\r\\n\")\n  self.file.flush()\n  return self._getresp()\n  \n def post(self,data):\n  ''\n\n\n  \n  return self._post('POST',data)\n  \n def ihave(self,message_id,data):\n  ''\n\n\n\n\n  \n  return self._post('IHAVE {0}'.format(message_id),data)\n  \n def _close(self):\n  self.file.close()\n  del self.file\n  \n def quit(self):\n  ''\n  \n  try :\n   resp=self._shortcmd('QUIT')\n  finally :\n   self._close()\n  return resp\n  \n def login(self,user=None ,password=None ,usenetrc=True ):\n  if self.authenticated:\n   raise ValueError(\"Already logged in.\")\n  if not user and not usenetrc:\n   raise ValueError(\n   \"At least one of `user` and `usenetrc` must be specified\")\n   \n   \n   \n  try :\n   if usenetrc and not user:\n    import netrc\n    credentials=netrc.netrc()\n    auth=credentials.authenticators(self.host)\n    if auth:\n     user=auth[0]\n     password=auth[2]\n  except OSError:\n   pass\n   \n  if not user:\n   return\n  resp=self._shortcmd('authinfo user '+user)\n  if resp.startswith('381'):\n   if not password:\n    raise NNTPReplyError(resp)\n   else :\n    resp=self._shortcmd('authinfo pass '+password)\n    if not resp.startswith('281'):\n     raise NNTPPermanentError(resp)\n     \n  self._caps=None\n  self.getcapabilities()\n  \n  \n  if self.readermode_afterauth and 'READER'not in self._caps:\n   self._setreadermode()\n   \n   self._caps=None\n   self.getcapabilities()\n   \n def _setreadermode(self):\n  try :\n   self.welcome=self._shortcmd('mode reader')\n  except NNTPPermanentError:\n  \n   pass\n  except NNTPTemporaryError as e:\n   if e.response.startswith('480'):\n   \n    self.readermode_afterauth=True\n   else :\n    raise\n    \n if _have_ssl:\n  def starttls(self,context=None ):\n   ''\n\n   \n   \n   \n   if self.tls_on:\n    raise ValueError(\"TLS is already enabled.\")\n   if self.authenticated:\n    raise ValueError(\"TLS cannot be started after authentication.\")\n   resp=self._shortcmd('STARTTLS')\n   if resp.startswith('382'):\n    self.file.close()\n    self.sock=_encrypt_on(self.sock,context,self.host)\n    self.file=self.sock.makefile(\"rwb\")\n    self.tls_on=True\n    \n    \n    self._caps=None\n    self.getcapabilities()\n   else :\n    raise NNTPError(\"TLS failed to start.\")\n    \n    \nclass NNTP(_NNTPBase):\n\n def __init__(self,host,port=NNTP_PORT,user=None ,password=None ,\n readermode=None ,usenetrc=False ,\n timeout=_GLOBAL_DEFAULT_TIMEOUT):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  self.host=host\n  self.port=port\n  self.sock=socket.create_connection((host,port),timeout)\n  file=None\n  try :\n   file=self.sock.makefile(\"rwb\")\n   _NNTPBase.__init__(self,file,host,\n   readermode,timeout)\n   if user or usenetrc:\n    self.login(user,password,usenetrc)\n  except :\n   if file:\n    file.close()\n   self.sock.close()\n   raise\n   \n def _close(self):\n  try :\n   _NNTPBase._close(self)\n  finally :\n   self.sock.close()\n   \n   \nif _have_ssl:\n class NNTP_SSL(_NNTPBase):\n \n  def __init__(self,host,port=NNTP_SSL_PORT,\n  user=None ,password=None ,ssl_context=None ,\n  readermode=None ,usenetrc=False ,\n  timeout=_GLOBAL_DEFAULT_TIMEOUT):\n   ''\n\n   \n   self.sock=socket.create_connection((host,port),timeout)\n   file=None\n   try :\n    self.sock=_encrypt_on(self.sock,ssl_context,host)\n    file=self.sock.makefile(\"rwb\")\n    _NNTPBase.__init__(self,file,host,\n    readermode=readermode,timeout=timeout)\n    if user or usenetrc:\n     self.login(user,password,usenetrc)\n   except :\n    if file:\n     file.close()\n    self.sock.close()\n    raise\n    \n  def _close(self):\n   try :\n    _NNTPBase._close(self)\n   finally :\n    self.sock.close()\n    \n __all__.append(\"NNTP_SSL\")\n \n \n \nif __name__ =='__main__':\n import argparse\n \n parser=argparse.ArgumentParser(description=\"\"\"\\\n        nntplib built-in demo - display the latest articles in a newsgroup\"\"\")\n parser.add_argument('-g','--group',default='gmane.comp.python.general',\n help='group to fetch messages from (default: %(default)s)')\n parser.add_argument('-s','--server',default='news.gmane.org',\n help='NNTP server hostname (default: %(default)s)')\n parser.add_argument('-p','--port',default=-1,type=int,\n help='NNTP port number (default: %s / %s)'%(NNTP_PORT,NNTP_SSL_PORT))\n parser.add_argument('-n','--nb-articles',default=10,type=int,\n help='number of articles to fetch (default: %(default)s)')\n parser.add_argument('-S','--ssl',action='store_true',default=False ,\n help='use NNTP over SSL')\n args=parser.parse_args()\n \n port=args.port\n if not args.ssl:\n  if port ==-1:\n   port=NNTP_PORT\n  s=NNTP(host=args.server,port=port)\n else :\n  if port ==-1:\n   port=NNTP_SSL_PORT\n  s=NNTP_SSL(host=args.server,port=port)\n  \n caps=s.getcapabilities()\n if 'STARTTLS'in caps:\n  s.starttls()\n resp,count,first,last,name=s.group(args.group)\n print('Group',name,'has',count,'articles, range',first,'to',last)\n \n def cut(s,lim):\n  if len(s)>lim:\n   s=s[:lim -4]+\"...\"\n  return s\n  \n first=str(int(last)-args.nb_articles+1)\n resp,overviews=s.xover(first,last)\n for artnum,over in overviews:\n  author=decode_header(over['from']).split('<',1)[0]\n  subject=decode_header(over['subject'])\n  lines=int(over[':lines'])\n  print(\"{:7} {:20} {:42} ({})\".format(\n  artnum,cut(author,20),cut(subject,42),lines)\n  )\n  \n s.quit()\n", ["argparse", "collections", "datetime", "email.header", "netrc", "re", "socket", "ssl", "warnings"]], "numbers": [".py", "\n\n\n\"\"\"Abstract Base Classes (ABCs) for numbers, according to PEP 3141.\n\nTODO: Fill out more detailed documentation on the operators.\"\"\"\n\nfrom abc import ABCMeta,abstractmethod\n\n__all__=[\"Number\",\"Complex\",\"Real\",\"Rational\",\"Integral\"]\n\nclass Number(metaclass=ABCMeta):\n ''\n\n\n\n \n __slots__=()\n \n \n __hash__=None\n \n \n \n \n \n \n \n \n \n \nclass Complex(Number):\n ''\n\n\n\n\n\n\n\n \n \n __slots__=()\n \n @abstractmethod\n def __complex__(self):\n  ''\n  \n def __bool__(self):\n  ''\n  return self !=0\n  \n @property\n @abstractmethod\n def real(self):\n  ''\n\n\n  \n  raise NotImplementedError\n  \n @property\n @abstractmethod\n def imag(self):\n  ''\n\n\n  \n  raise NotImplementedError\n  \n @abstractmethod\n def __add__(self,other):\n  ''\n  raise NotImplementedError\n  \n @abstractmethod\n def __radd__(self,other):\n  ''\n  raise NotImplementedError\n  \n @abstractmethod\n def __neg__(self):\n  ''\n  raise NotImplementedError\n  \n @abstractmethod\n def __pos__(self):\n  ''\n  raise NotImplementedError\n  \n def __sub__(self,other):\n  ''\n  return self+-other\n  \n def __rsub__(self,other):\n  ''\n  return -self+other\n  \n @abstractmethod\n def __mul__(self,other):\n  ''\n  raise NotImplementedError\n  \n @abstractmethod\n def __rmul__(self,other):\n  ''\n  raise NotImplementedError\n  \n @abstractmethod\n def __truediv__(self,other):\n  ''\n  raise NotImplementedError\n  \n @abstractmethod\n def __rtruediv__(self,other):\n  ''\n  raise NotImplementedError\n  \n @abstractmethod\n def __pow__(self,exponent):\n  ''\n  raise NotImplementedError\n  \n @abstractmethod\n def __rpow__(self,base):\n  ''\n  raise NotImplementedError\n  \n @abstractmethod\n def __abs__(self):\n  ''\n  raise NotImplementedError\n  \n @abstractmethod\n def conjugate(self):\n  ''\n  raise NotImplementedError\n  \n @abstractmethod\n def __eq__(self,other):\n  ''\n  raise NotImplementedError\n  \nComplex.register(complex)\n\n\nclass Real(Complex):\n ''\n\n\n\n\n\n \n \n __slots__=()\n \n @abstractmethod\n def __float__(self):\n  ''\n\n  \n  raise NotImplementedError\n  \n @abstractmethod\n def __trunc__(self):\n  ''\n\n\n\n\n\n\n\n  \n  raise NotImplementedError\n  \n @abstractmethod\n def __floor__(self):\n  ''\n  raise NotImplementedError\n  \n @abstractmethod\n def __ceil__(self):\n  ''\n  raise NotImplementedError\n  \n @abstractmethod\n def __round__(self,ndigits=None ):\n  ''\n\n\n\n  \n  raise NotImplementedError\n  \n def __divmod__(self,other):\n  ''\n\n\n\n  \n  return (self //other,self %other)\n  \n def __rdivmod__(self,other):\n  ''\n\n\n\n  \n  return (other //self,other %self)\n  \n @abstractmethod\n def __floordiv__(self,other):\n  ''\n  raise NotImplementedError\n  \n @abstractmethod\n def __rfloordiv__(self,other):\n  ''\n  raise NotImplementedError\n  \n @abstractmethod\n def __mod__(self,other):\n  ''\n  raise NotImplementedError\n  \n @abstractmethod\n def __rmod__(self,other):\n  ''\n  raise NotImplementedError\n  \n @abstractmethod\n def __lt__(self,other):\n  ''\n\n  \n  raise NotImplementedError\n  \n @abstractmethod\n def __le__(self,other):\n  ''\n  raise NotImplementedError\n  \n  \n def __complex__(self):\n  ''\n  return complex(float(self))\n  \n @property\n def real(self):\n  ''\n  return +self\n  \n @property\n def imag(self):\n  ''\n  return 0\n  \n def conjugate(self):\n  ''\n  return +self\n  \nReal.register(float)\n\n\nclass Rational(Real):\n ''\n \n __slots__=()\n \n @property\n @abstractmethod\n def numerator(self):\n  raise NotImplementedError\n  \n @property\n @abstractmethod\n def denominator(self):\n  raise NotImplementedError\n  \n  \n def __float__(self):\n  ''\n\n\n\n\n\n  \n  return self.numerator /self.denominator\n  \n  \nclass Integral(Rational):\n ''\n \n __slots__=()\n \n @abstractmethod\n def __int__(self):\n  ''\n  raise NotImplementedError\n  \n def __index__(self):\n  ''\n  return int(self)\n  \n @abstractmethod\n def __pow__(self,exponent,modulus=None ):\n  ''\n\n\n\n\n\n  \n  raise NotImplementedError\n  \n @abstractmethod\n def __lshift__(self,other):\n  ''\n  raise NotImplementedError\n  \n @abstractmethod\n def __rlshift__(self,other):\n  ''\n  raise NotImplementedError\n  \n @abstractmethod\n def __rshift__(self,other):\n  ''\n  raise NotImplementedError\n  \n @abstractmethod\n def __rrshift__(self,other):\n  ''\n  raise NotImplementedError\n  \n @abstractmethod\n def __and__(self,other):\n  ''\n  raise NotImplementedError\n  \n @abstractmethod\n def __rand__(self,other):\n  ''\n  raise NotImplementedError\n  \n @abstractmethod\n def __xor__(self,other):\n  ''\n  raise NotImplementedError\n  \n @abstractmethod\n def __rxor__(self,other):\n  ''\n  raise NotImplementedError\n  \n @abstractmethod\n def __or__(self,other):\n  ''\n  raise NotImplementedError\n  \n @abstractmethod\n def __ror__(self,other):\n  ''\n  raise NotImplementedError\n  \n @abstractmethod\n def __invert__(self):\n  ''\n  raise NotImplementedError\n  \n  \n def __float__(self):\n  ''\n  return float(int(self))\n  \n @property\n def numerator(self):\n  ''\n  return +self\n  \n @property\n def denominator(self):\n  ''\n  return 1\n  \nIntegral.register(int)\n", ["abc"]], "opcode": [".py", "\n\"\"\"\nopcode module - potentially shared between dis and other modules which\noperate on bytecodes (e.g. peephole optimizers).\n\"\"\"\n\n__all__=[\"cmp_op\",\"hasconst\",\"hasname\",\"hasjrel\",\"hasjabs\",\n\"haslocal\",\"hascompare\",\"hasfree\",\"opname\",\"opmap\",\n\"HAVE_ARGUMENT\",\"EXTENDED_ARG\",\"hasnargs\"]\n\n\n\n\n\n\n\n\ntry :\n from _opcode import stack_effect\n __all__.append('stack_effect')\nexcept ImportError:\n pass\n \ncmp_op=('<','<=','==','!=','>','>=','in','not in','is',\n'is not','exception match','BAD')\n\nhasconst=[]\nhasname=[]\nhasjrel=[]\nhasjabs=[]\nhaslocal=[]\nhascompare=[]\nhasfree=[]\nhasnargs=[]\n\nopmap={}\nopname=['<%r>'%(op,)for op in range(256)]\n\ndef def_op(name,op):\n opname[op]=name\n opmap[name]=op\n \ndef name_op(name,op):\n def_op(name,op)\n hasname.append(op)\n \ndef jrel_op(name,op):\n def_op(name,op)\n hasjrel.append(op)\n \ndef jabs_op(name,op):\n def_op(name,op)\n hasjabs.append(op)\n \n \n \n \ndef_op('POP_TOP',1)\ndef_op('ROT_TWO',2)\ndef_op('ROT_THREE',3)\ndef_op('DUP_TOP',4)\ndef_op('DUP_TOP_TWO',5)\n\ndef_op('NOP',9)\ndef_op('UNARY_POSITIVE',10)\ndef_op('UNARY_NEGATIVE',11)\ndef_op('UNARY_NOT',12)\n\ndef_op('UNARY_INVERT',15)\n\ndef_op('BINARY_MATRIX_MULTIPLY',16)\ndef_op('INPLACE_MATRIX_MULTIPLY',17)\n\ndef_op('BINARY_POWER',19)\ndef_op('BINARY_MULTIPLY',20)\n\ndef_op('BINARY_MODULO',22)\ndef_op('BINARY_ADD',23)\ndef_op('BINARY_SUBTRACT',24)\ndef_op('BINARY_SUBSCR',25)\ndef_op('BINARY_FLOOR_DIVIDE',26)\ndef_op('BINARY_TRUE_DIVIDE',27)\ndef_op('INPLACE_FLOOR_DIVIDE',28)\ndef_op('INPLACE_TRUE_DIVIDE',29)\n\ndef_op('GET_AITER',50)\ndef_op('GET_ANEXT',51)\ndef_op('BEFORE_ASYNC_WITH',52)\n\ndef_op('INPLACE_ADD',55)\ndef_op('INPLACE_SUBTRACT',56)\ndef_op('INPLACE_MULTIPLY',57)\n\ndef_op('INPLACE_MODULO',59)\ndef_op('STORE_SUBSCR',60)\ndef_op('DELETE_SUBSCR',61)\ndef_op('BINARY_LSHIFT',62)\ndef_op('BINARY_RSHIFT',63)\ndef_op('BINARY_AND',64)\ndef_op('BINARY_XOR',65)\ndef_op('BINARY_OR',66)\ndef_op('INPLACE_POWER',67)\ndef_op('GET_ITER',68)\ndef_op('GET_YIELD_FROM_ITER',69)\n\ndef_op('PRINT_EXPR',70)\ndef_op('LOAD_BUILD_CLASS',71)\ndef_op('YIELD_FROM',72)\ndef_op('GET_AWAITABLE',73)\n\ndef_op('INPLACE_LSHIFT',75)\ndef_op('INPLACE_RSHIFT',76)\ndef_op('INPLACE_AND',77)\ndef_op('INPLACE_XOR',78)\ndef_op('INPLACE_OR',79)\ndef_op('BREAK_LOOP',80)\ndef_op('WITH_CLEANUP_START',81)\ndef_op('WITH_CLEANUP_FINISH',82)\n\ndef_op('RETURN_VALUE',83)\ndef_op('IMPORT_STAR',84)\ndef_op('SETUP_ANNOTATIONS',85)\ndef_op('YIELD_VALUE',86)\ndef_op('POP_BLOCK',87)\ndef_op('END_FINALLY',88)\ndef_op('POP_EXCEPT',89)\n\nHAVE_ARGUMENT=90\n\nname_op('STORE_NAME',90)\nname_op('DELETE_NAME',91)\ndef_op('UNPACK_SEQUENCE',92)\njrel_op('FOR_ITER',93)\ndef_op('UNPACK_EX',94)\nname_op('STORE_ATTR',95)\nname_op('DELETE_ATTR',96)\nname_op('STORE_GLOBAL',97)\nname_op('DELETE_GLOBAL',98)\ndef_op('LOAD_CONST',100)\nhasconst.append(100)\nname_op('LOAD_NAME',101)\ndef_op('BUILD_TUPLE',102)\ndef_op('BUILD_LIST',103)\ndef_op('BUILD_SET',104)\ndef_op('BUILD_MAP',105)\nname_op('LOAD_ATTR',106)\ndef_op('COMPARE_OP',107)\nhascompare.append(107)\nname_op('IMPORT_NAME',108)\nname_op('IMPORT_FROM',109)\n\njrel_op('JUMP_FORWARD',110)\njabs_op('JUMP_IF_FALSE_OR_POP',111)\njabs_op('JUMP_IF_TRUE_OR_POP',112)\njabs_op('JUMP_ABSOLUTE',113)\njabs_op('POP_JUMP_IF_FALSE',114)\njabs_op('POP_JUMP_IF_TRUE',115)\n\nname_op('LOAD_GLOBAL',116)\n\njabs_op('CONTINUE_LOOP',119)\njrel_op('SETUP_LOOP',120)\njrel_op('SETUP_EXCEPT',121)\njrel_op('SETUP_FINALLY',122)\n\ndef_op('LOAD_FAST',124)\nhaslocal.append(124)\ndef_op('STORE_FAST',125)\nhaslocal.append(125)\ndef_op('DELETE_FAST',126)\nhaslocal.append(126)\n\ndef_op('RAISE_VARARGS',130)\ndef_op('CALL_FUNCTION',131)\ndef_op('MAKE_FUNCTION',132)\ndef_op('BUILD_SLICE',133)\ndef_op('LOAD_CLOSURE',135)\nhasfree.append(135)\ndef_op('LOAD_DEREF',136)\nhasfree.append(136)\ndef_op('STORE_DEREF',137)\nhasfree.append(137)\ndef_op('DELETE_DEREF',138)\nhasfree.append(138)\n\ndef_op('CALL_FUNCTION_KW',141)\ndef_op('CALL_FUNCTION_EX',142)\n\njrel_op('SETUP_WITH',143)\n\ndef_op('LIST_APPEND',145)\ndef_op('SET_ADD',146)\ndef_op('MAP_ADD',147)\n\ndef_op('LOAD_CLASSDEREF',148)\nhasfree.append(148)\n\ndef_op('EXTENDED_ARG',144)\nEXTENDED_ARG=144\n\ndef_op('BUILD_LIST_UNPACK',149)\ndef_op('BUILD_MAP_UNPACK',150)\ndef_op('BUILD_MAP_UNPACK_WITH_CALL',151)\ndef_op('BUILD_TUPLE_UNPACK',152)\ndef_op('BUILD_SET_UNPACK',153)\n\njrel_op('SETUP_ASYNC_WITH',154)\n\ndef_op('FORMAT_VALUE',155)\ndef_op('BUILD_CONST_KEY_MAP',156)\ndef_op('BUILD_STRING',157)\ndef_op('BUILD_TUPLE_UNPACK_WITH_CALL',158)\n\nname_op('LOAD_METHOD',160)\ndef_op('CALL_METHOD',161)\n\ndel def_op,name_op,jrel_op,jabs_op\n", ["_opcode"]], "operator": [".py", "''\n\n\n\n\n\n\n\n\n\n\n\n__all__=['abs','add','and_','attrgetter','concat','contains','countOf',\n'delitem','eq','floordiv','ge','getitem','gt','iadd','iand',\n'iconcat','ifloordiv','ilshift','imatmul','imod','imul',\n'index','indexOf','inv','invert','ior','ipow','irshift',\n'is_','is_not','isub','itemgetter','itruediv','ixor','le',\n'length_hint','lshift','lt','matmul','methodcaller','mod',\n'mul','ne','neg','not_','or_','pos','pow','rshift',\n'setitem','sub','truediv','truth','xor']\n\nfrom builtins import abs as _abs\n\n\n\n\ndef lt(a,b):\n ''\n return a <b\n \ndef le(a,b):\n ''\n return a <=b\n \ndef eq(a,b):\n ''\n return a ==b\n \ndef ne(a,b):\n ''\n return a !=b\n \ndef ge(a,b):\n ''\n return a >=b\n \ndef gt(a,b):\n ''\n return a >b\n \n \n \ndef not_(a):\n ''\n return not a\n \ndef truth(a):\n ''\n return True if a else False\n \ndef is_(a,b):\n ''\n return a is b\n \ndef is_not(a,b):\n ''\n return a is not b\n \n \n \ndef abs(a):\n ''\n return _abs(a)\n \ndef add(a,b):\n ''\n return a+b\n \ndef and_(a,b):\n ''\n return a&b\n \ndef floordiv(a,b):\n ''\n return a //b\n \ndef index(a):\n ''\n return a.__index__()\n \ndef inv(a):\n ''\n return ~a\ninvert=inv\n\ndef lshift(a,b):\n ''\n return a <<b\n \ndef mod(a,b):\n ''\n return a %b\n \ndef mul(a,b):\n ''\n return a *b\n \ndef matmul(a,b):\n ''\n return a @b\n \ndef neg(a):\n ''\n return -a\n \ndef or_(a,b):\n ''\n return a |b\n \ndef pos(a):\n ''\n return +a\n \ndef pow(a,b):\n ''\n return a **b\n \ndef rshift(a,b):\n ''\n return a >>b\n \ndef sub(a,b):\n ''\n return a -b\n \ndef truediv(a,b):\n ''\n return a /b\n \ndef xor(a,b):\n ''\n return a ^b\n \n \n \ndef concat(a,b):\n ''\n if not hasattr(a,'__getitem__'):\n  msg=\"'%s' object can't be concatenated\"%type(a).__name__\n  raise TypeError(msg)\n return a+b\n \ndef contains(a,b):\n ''\n return b in a\n \ndef countOf(a,b):\n ''\n count=0\n for i in a:\n  if i ==b:\n   count +=1\n return count\n \ndef delitem(a,b):\n ''\n del a[b]\n \ndef getitem(a,b):\n ''\n return a[b]\n \ndef indexOf(a,b):\n ''\n for i,j in enumerate(a):\n  if j ==b:\n   return i\n else :\n  raise ValueError('sequence.index(x): x not in sequence')\n  \ndef setitem(a,b,c):\n ''\n a[b]=c\n \ndef length_hint(obj,default=0):\n ''\n\n\n\n\n\n\n \n if not isinstance(default,int):\n  msg=(\"'%s' object cannot be interpreted as an integer\"%\n  type(default).__name__)\n  raise TypeError(msg)\n  \n try :\n  return len(obj)\n except TypeError:\n  pass\n  \n try :\n  hint=type(obj).__length_hint__\n except AttributeError:\n  return default\n  \n try :\n  val=hint(obj)\n except TypeError:\n  return default\n if val is NotImplemented:\n  return default\n if not isinstance(val,int):\n  msg=('__length_hint__ must be integer, not %s'%\n  type(val).__name__)\n  raise TypeError(msg)\n if val <0:\n  msg='__length_hint__() should return >= 0'\n  raise ValueError(msg)\n return val\n \n \n \nclass attrgetter:\n ''\n\n\n\n\n\n \n __slots__=('_attrs','_call')\n \n def __init__(self,attr,*attrs):\n  if not attrs:\n   if not isinstance(attr,str):\n    raise TypeError('attribute name must be a string')\n   self._attrs=(attr,)\n   names=attr.split('.')\n   def func(obj):\n    for name in names:\n     obj=getattr(obj,name)\n    return obj\n   self._call=func\n  else :\n   self._attrs=(attr,)+attrs\n   getters=tuple(map(attrgetter,self._attrs))\n   def func(obj):\n    return tuple(getter(obj)for getter in getters)\n   self._call=func\n   \n def __call__(self,obj):\n  return self._call(obj)\n  \n def __repr__(self):\n  return '%s.%s(%s)'%(self.__class__.__module__,\n  self.__class__.__qualname__,\n  ', '.join(map(repr,self._attrs)))\n  \n def __reduce__(self):\n  return self.__class__,self._attrs\n  \nclass itemgetter:\n ''\n\n\n\n \n __slots__=('_items','_call')\n \n def __init__(self,item,*items):\n  if not items:\n   self._items=(item,)\n   def func(obj):\n    return obj[item]\n   self._call=func\n  else :\n   self._items=items=(item,)+items\n   def func(obj):\n    return tuple(obj[i]for i in items)\n   self._call=func\n   \n def __call__(self,obj):\n  return self._call(obj)\n  \n def __repr__(self):\n  return '%s.%s(%s)'%(self.__class__.__module__,\n  self.__class__.__name__,\n  ', '.join(map(repr,self._items)))\n  \n def __reduce__(self):\n  return self.__class__,self._items\n  \nclass methodcaller:\n ''\n\n\n\n\n \n __slots__=('_name','_args','_kwargs')\n \n def __init__(*args,**kwargs):\n  if len(args)<2:\n   msg=\"methodcaller needs at least one argument, the method name\"\n   raise TypeError(msg)\n  self=args[0]\n  self._name=args[1]\n  if not isinstance(self._name,str):\n   raise TypeError('method name must be a string')\n  self._args=args[2:]\n  self._kwargs=kwargs\n  \n def __call__(self,obj):\n  return getattr(obj,self._name)(*self._args,**self._kwargs)\n  \n def __repr__(self):\n  args=[repr(self._name)]\n  args.extend(map(repr,self._args))\n  args.extend('%s=%r'%(k,v)for k,v in self._kwargs.items())\n  return '%s.%s(%s)'%(self.__class__.__module__,\n  self.__class__.__name__,\n  ', '.join(args))\n  \n def __reduce__(self):\n  if not self._kwargs:\n   return self.__class__,(self._name,)+self._args\n  else :\n   from functools import partial\n   return partial(self.__class__,self._name,**self._kwargs),self._args\n   \n   \n   \n   \ndef iadd(a,b):\n ''\n a +=b\n return a\n \ndef iand(a,b):\n ''\n a &=b\n return a\n \ndef iconcat(a,b):\n ''\n if not hasattr(a,'__getitem__'):\n  msg=\"'%s' object can't be concatenated\"%type(a).__name__\n  raise TypeError(msg)\n a +=b\n return a\n \ndef ifloordiv(a,b):\n ''\n a //=b\n return a\n \ndef ilshift(a,b):\n ''\n a <<=b\n return a\n \ndef imod(a,b):\n ''\n a %=b\n return a\n \ndef imul(a,b):\n ''\n a *=b\n return a\n \ndef imatmul(a,b):\n ''\n a @=b\n return a\n \ndef ior(a,b):\n ''\n a |=b\n return a\n \ndef ipow(a,b):\n ''\n a **=b\n return a\n \ndef irshift(a,b):\n ''\n a >>=b\n return a\n \ndef isub(a,b):\n ''\n a -=b\n return a\n \ndef itruediv(a,b):\n ''\n a /=b\n return a\n \ndef ixor(a,b):\n ''\n a ^=b\n return a\n \n \ntry :\n from _operator import *\nexcept ImportError:\n pass\nelse :\n from _operator import __doc__\n \n \n \n__lt__=lt\n__le__=le\n__eq__=eq\n__ne__=ne\n__ge__=ge\n__gt__=gt\n__not__=not_\n__abs__=abs\n__add__=add\n__and__=and_\n__floordiv__=floordiv\n__index__=index\n__inv__=inv\n__invert__=invert\n__lshift__=lshift\n__mod__=mod\n__mul__=mul\n__matmul__=matmul\n__neg__=neg\n__or__=or_\n__pos__=pos\n__pow__=pow\n__rshift__=rshift\n__sub__=sub\n__truediv__=truediv\n__xor__=xor\n__concat__=concat\n__contains__=contains\n__delitem__=delitem\n__getitem__=getitem\n__setitem__=setitem\n__iadd__=iadd\n__iand__=iand\n__iconcat__=iconcat\n__ifloordiv__=ifloordiv\n__ilshift__=ilshift\n__imod__=imod\n__imul__=imul\n__imatmul__=imatmul\n__ior__=ior\n__ipow__=ipow\n__irshift__=irshift\n__isub__=isub\n__itruediv__=itruediv\n__ixor__=ixor\n", ["_operator", "builtins", "functools"]], "optparse": [".py", "''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n__version__=\"1.5.3\"\n\n__all__=['Option',\n'make_option',\n'SUPPRESS_HELP',\n'SUPPRESS_USAGE',\n'Values',\n'OptionContainer',\n'OptionGroup',\n'OptionParser',\n'HelpFormatter',\n'IndentedHelpFormatter',\n'TitledHelpFormatter',\n'OptParseError',\n'OptionError',\n'OptionConflictError',\n'OptionValueError',\n'BadOptionError',\n'check_choice']\n\n__copyright__=\"\"\"\nCopyright (c) 2001-2006 Gregory P. Ward.  All rights reserved.\nCopyright (c) 2002-2006 Python Software Foundation.  All rights reserved.\n\nRedistribution and use in source and binary forms, with or without\nmodification, are permitted provided that the following conditions are\nmet:\n\n  * Redistributions of source code must retain the above copyright\n    notice, this list of conditions and the following disclaimer.\n\n  * Redistributions in binary form must reproduce the above copyright\n    notice, this list of conditions and the following disclaimer in the\n    documentation and/or other materials provided with the distribution.\n\n  * Neither the name of the author nor the names of its\n    contributors may be used to endorse or promote products derived from\n    this software without specific prior written permission.\n\nTHIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS\nIS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED\nTO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A\nPARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR\nCONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,\nEXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,\nPROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR\nPROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF\nLIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING\nNEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS\nSOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n\"\"\"\n\nimport sys,os\nimport textwrap\n\ndef _repr(self):\n return \"<%s at 0x%x: %s>\"%(self.__class__.__name__,id(self),self)\n \n \n \n \n \n \n \n \ntry :\n from gettext import gettext,ngettext\nexcept ImportError:\n def gettext(message):\n  return message\n  \n def ngettext(singular,plural,n):\n  if n ==1:\n   return singular\n  return plural\n  \n_=gettext\n\n\nclass OptParseError(Exception):\n def __init__(self,msg):\n  self.msg=msg\n  \n def __str__(self):\n  return self.msg\n  \n  \nclass OptionError(OptParseError):\n ''\n\n\n \n \n def __init__(self,msg,option):\n  self.msg=msg\n  self.option_id=str(option)\n  \n def __str__(self):\n  if self.option_id:\n   return \"option %s: %s\"%(self.option_id,self.msg)\n  else :\n   return self.msg\n   \nclass OptionConflictError(OptionError):\n ''\n\n \n \nclass OptionValueError(OptParseError):\n ''\n\n\n \n \nclass BadOptionError(OptParseError):\n ''\n\n \n def __init__(self,opt_str):\n  self.opt_str=opt_str\n  \n def __str__(self):\n  return _(\"no such option: %s\")%self.opt_str\n  \nclass AmbiguousOptionError(BadOptionError):\n ''\n\n \n def __init__(self,opt_str,possibilities):\n  BadOptionError.__init__(self,opt_str)\n  self.possibilities=possibilities\n  \n def __str__(self):\n  return (_(\"ambiguous option: %s (%s?)\")\n  %(self.opt_str,\", \".join(self.possibilities)))\n  \n  \nclass HelpFormatter:\n\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n NO_DEFAULT_VALUE=\"none\"\n \n def __init__(self,\n indent_increment,\n max_help_position,\n width,\n short_first):\n  self.parser=None\n  self.indent_increment=indent_increment\n  if width is None :\n   try :\n    width=int(os.environ['COLUMNS'])\n   except (KeyError,ValueError):\n    width=80\n   width -=2\n  self.width=width\n  self.help_position=self.max_help_position=\\\n  min(max_help_position,max(width -20,indent_increment *2))\n  self.current_indent=0\n  self.level=0\n  self.help_width=None\n  self.short_first=short_first\n  self.default_tag=\"%default\"\n  self.option_strings={}\n  self._short_opt_fmt=\"%s %s\"\n  self._long_opt_fmt=\"%s=%s\"\n  \n def set_parser(self,parser):\n  self.parser=parser\n  \n def set_short_opt_delimiter(self,delim):\n  if delim not in (\"\",\" \"):\n   raise ValueError(\n   \"invalid metavar delimiter for short options: %r\"%delim)\n  self._short_opt_fmt=\"%s\"+delim+\"%s\"\n  \n def set_long_opt_delimiter(self,delim):\n  if delim not in (\"=\",\" \"):\n   raise ValueError(\n   \"invalid metavar delimiter for long options: %r\"%delim)\n  self._long_opt_fmt=\"%s\"+delim+\"%s\"\n  \n def indent(self):\n  self.current_indent +=self.indent_increment\n  self.level +=1\n  \n def dedent(self):\n  self.current_indent -=self.indent_increment\n  assert self.current_indent >=0,\"Indent decreased below 0.\"\n  self.level -=1\n  \n def format_usage(self,usage):\n  raise NotImplementedError(\"subclasses must implement\")\n  \n def format_heading(self,heading):\n  raise NotImplementedError(\"subclasses must implement\")\n  \n def _format_text(self,text):\n  ''\n\n\n  \n  text_width=max(self.width -self.current_indent,11)\n  indent=\" \"*self.current_indent\n  return textwrap.fill(text,\n  text_width,\n  initial_indent=indent,\n  subsequent_indent=indent)\n  \n def format_description(self,description):\n  if description:\n   return self._format_text(description)+\"\\n\"\n  else :\n   return \"\"\n   \n def format_epilog(self,epilog):\n  if epilog:\n   return \"\\n\"+self._format_text(epilog)+\"\\n\"\n  else :\n   return \"\"\n   \n   \n def expand_default(self,option):\n  if self.parser is None or not self.default_tag:\n   return option.help\n   \n  default_value=self.parser.defaults.get(option.dest)\n  if default_value is NO_DEFAULT or default_value is None :\n   default_value=self.NO_DEFAULT_VALUE\n   \n  return option.help.replace(self.default_tag,str(default_value))\n  \n def format_option(self,option):\n \n \n \n \n \n \n \n \n \n \n \n \n \n \n  result=[]\n  opts=self.option_strings[option]\n  opt_width=self.help_position -self.current_indent -2\n  if len(opts)>opt_width:\n   opts=\"%*s%s\\n\"%(self.current_indent,\"\",opts)\n   indent_first=self.help_position\n  else :\n   opts=\"%*s%-*s  \"%(self.current_indent,\"\",opt_width,opts)\n   indent_first=0\n  result.append(opts)\n  if option.help:\n   help_text=self.expand_default(option)\n   help_lines=textwrap.wrap(help_text,self.help_width)\n   result.append(\"%*s%s\\n\"%(indent_first,\"\",help_lines[0]))\n   result.extend([\"%*s%s\\n\"%(self.help_position,\"\",line)\n   for line in help_lines[1:]])\n  elif opts[-1]!=\"\\n\":\n   result.append(\"\\n\")\n  return \"\".join(result)\n  \n def store_option_strings(self,parser):\n  self.indent()\n  max_len=0\n  for opt in parser.option_list:\n   strings=self.format_option_strings(opt)\n   self.option_strings[opt]=strings\n   max_len=max(max_len,len(strings)+self.current_indent)\n  self.indent()\n  for group in parser.option_groups:\n   for opt in group.option_list:\n    strings=self.format_option_strings(opt)\n    self.option_strings[opt]=strings\n    max_len=max(max_len,len(strings)+self.current_indent)\n  self.dedent()\n  self.dedent()\n  self.help_position=min(max_len+2,self.max_help_position)\n  self.help_width=max(self.width -self.help_position,11)\n  \n def format_option_strings(self,option):\n  ''\n  if option.takes_value():\n   metavar=option.metavar or option.dest.upper()\n   short_opts=[self._short_opt_fmt %(sopt,metavar)\n   for sopt in option._short_opts]\n   long_opts=[self._long_opt_fmt %(lopt,metavar)\n   for lopt in option._long_opts]\n  else :\n   short_opts=option._short_opts\n   long_opts=option._long_opts\n   \n  if self.short_first:\n   opts=short_opts+long_opts\n  else :\n   opts=long_opts+short_opts\n   \n  return \", \".join(opts)\n  \nclass IndentedHelpFormatter(HelpFormatter):\n ''\n \n \n def __init__(self,\n indent_increment=2,\n max_help_position=24,\n width=None ,\n short_first=1):\n  HelpFormatter.__init__(\n  self,indent_increment,max_help_position,width,short_first)\n  \n def format_usage(self,usage):\n  return _(\"Usage: %s\\n\")%usage\n  \n def format_heading(self,heading):\n  return \"%*s%s:\\n\"%(self.current_indent,\"\",heading)\n  \n  \nclass TitledHelpFormatter(HelpFormatter):\n ''\n \n \n def __init__(self,\n indent_increment=0,\n max_help_position=24,\n width=None ,\n short_first=0):\n  HelpFormatter.__init__(\n  self,indent_increment,max_help_position,width,short_first)\n  \n def format_usage(self,usage):\n  return \"%s  %s\\n\"%(self.format_heading(_(\"Usage\")),usage)\n  \n def format_heading(self,heading):\n  return \"%s\\n%s\\n\"%(heading,\"=-\"[self.level]*len(heading))\n  \n  \ndef _parse_num(val,type):\n if val[:2].lower()==\"0x\":\n  radix=16\n elif val[:2].lower()==\"0b\":\n  radix=2\n  val=val[2:]or \"0\"\n elif val[:1]==\"0\":\n  radix=8\n else :\n  radix=10\n  \n return type(val,radix)\n \ndef _parse_int(val):\n return _parse_num(val,int)\n \n_builtin_cvt={\"int\":(_parse_int,_(\"integer\")),\n\"long\":(_parse_int,_(\"integer\")),\n\"float\":(float,_(\"floating-point\")),\n\"complex\":(complex,_(\"complex\"))}\n\ndef check_builtin(option,opt,value):\n (cvt,what)=_builtin_cvt[option.type]\n try :\n  return cvt(value)\n except ValueError:\n  raise OptionValueError(\n  _(\"option %s: invalid %s value: %r\")%(opt,what,value))\n  \ndef check_choice(option,opt,value):\n if value in option.choices:\n  return value\n else :\n  choices=\", \".join(map(repr,option.choices))\n  raise OptionValueError(\n  _(\"option %s: invalid choice: %r (choose from %s)\")\n  %(opt,value,choices))\n  \n  \n  \nNO_DEFAULT=(\"NO\",\"DEFAULT\")\n\n\nclass Option:\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n \n \n ATTRS=['action',\n 'type',\n 'dest',\n 'default',\n 'nargs',\n 'const',\n 'choices',\n 'callback',\n 'callback_args',\n 'callback_kwargs',\n 'help',\n 'metavar']\n \n \n \n ACTIONS=(\"store\",\n \"store_const\",\n \"store_true\",\n \"store_false\",\n \"append\",\n \"append_const\",\n \"count\",\n \"callback\",\n \"help\",\n \"version\")\n \n \n \n \n STORE_ACTIONS=(\"store\",\n \"store_const\",\n \"store_true\",\n \"store_false\",\n \"append\",\n \"append_const\",\n \"count\")\n \n \n \n TYPED_ACTIONS=(\"store\",\n \"append\",\n \"callback\")\n \n \n \n ALWAYS_TYPED_ACTIONS=(\"store\",\n \"append\")\n \n \n CONST_ACTIONS=(\"store_const\",\n \"append_const\")\n \n \n \n TYPES=(\"string\",\"int\",\"long\",\"float\",\"complex\",\"choice\")\n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n \n TYPE_CHECKER={\"int\":check_builtin,\n \"long\":check_builtin,\n \"float\":check_builtin,\n \"complex\":check_builtin,\n \"choice\":check_choice,\n }\n \n \n \n \n \n \n \n \n \n \n CHECK_METHODS=None\n \n \n \n \n def __init__(self,*opts,**attrs):\n \n \n  self._short_opts=[]\n  self._long_opts=[]\n  opts=self._check_opt_strings(opts)\n  self._set_opt_strings(opts)\n  \n  \n  self._set_attrs(attrs)\n  \n  \n  \n  \n  \n  \n  for checker in self.CHECK_METHODS:\n   checker(self)\n   \n def _check_opt_strings(self,opts):\n \n \n \n  opts=[opt for opt in opts if opt]\n  if not opts:\n   raise TypeError(\"at least one option string must be supplied\")\n  return opts\n  \n def _set_opt_strings(self,opts):\n  for opt in opts:\n   if len(opt)<2:\n    raise OptionError(\n    \"invalid option string %r: \"\n    \"must be at least two characters long\"%opt,self)\n   elif len(opt)==2:\n    if not (opt[0]==\"-\"and opt[1]!=\"-\"):\n     raise OptionError(\n     \"invalid short option string %r: \"\n     \"must be of the form -x, (x any non-dash char)\"%opt,\n     self)\n    self._short_opts.append(opt)\n   else :\n    if not (opt[0:2]==\"--\"and opt[2]!=\"-\"):\n     raise OptionError(\n     \"invalid long option string %r: \"\n     \"must start with --, followed by non-dash\"%opt,\n     self)\n    self._long_opts.append(opt)\n    \n def _set_attrs(self,attrs):\n  for attr in self.ATTRS:\n   if attr in attrs:\n    setattr(self,attr,attrs[attr])\n    del attrs[attr]\n   else :\n    if attr =='default':\n     setattr(self,attr,NO_DEFAULT)\n    else :\n     setattr(self,attr,None )\n  if attrs:\n   attrs=sorted(attrs.keys())\n   raise OptionError(\n   \"invalid keyword arguments: %s\"%\", \".join(attrs),\n   self)\n   \n   \n   \n   \n def _check_action(self):\n  if self.action is None :\n   self.action=\"store\"\n  elif self.action not in self.ACTIONS:\n   raise OptionError(\"invalid action: %r\"%self.action,self)\n   \n def _check_type(self):\n  if self.type is None :\n   if self.action in self.ALWAYS_TYPED_ACTIONS:\n    if self.choices is not None :\n    \n     self.type=\"choice\"\n    else :\n    \n     self.type=\"string\"\n  else :\n  \n  \n   if isinstance(self.type,type):\n    self.type=self.type.__name__\n    \n   if self.type ==\"str\":\n    self.type=\"string\"\n    \n   if self.type not in self.TYPES:\n    raise OptionError(\"invalid option type: %r\"%self.type,self)\n   if self.action not in self.TYPED_ACTIONS:\n    raise OptionError(\n    \"must not supply a type for action %r\"%self.action,self)\n    \n def _check_choice(self):\n  if self.type ==\"choice\":\n   if self.choices is None :\n    raise OptionError(\n    \"must supply a list of choices for type 'choice'\",self)\n   elif not isinstance(self.choices,(tuple,list)):\n    raise OptionError(\n    \"choices must be a list of strings ('%s' supplied)\"\n    %str(type(self.choices)).split(\"'\")[1],self)\n  elif self.choices is not None :\n   raise OptionError(\n   \"must not supply choices for type %r\"%self.type,self)\n   \n def _check_dest(self):\n \n \n  takes_value=(self.action in self.STORE_ACTIONS or\n  self.type is not None )\n  if self.dest is None and takes_value:\n  \n  \n  \n   if self._long_opts:\n   \n    self.dest=self._long_opts[0][2:].replace('-','_')\n   else :\n    self.dest=self._short_opts[0][1]\n    \n def _check_const(self):\n  if self.action not in self.CONST_ACTIONS and self.const is not None :\n   raise OptionError(\n   \"'const' must not be supplied for action %r\"%self.action,\n   self)\n   \n def _check_nargs(self):\n  if self.action in self.TYPED_ACTIONS:\n   if self.nargs is None :\n    self.nargs=1\n  elif self.nargs is not None :\n   raise OptionError(\n   \"'nargs' must not be supplied for action %r\"%self.action,\n   self)\n   \n def _check_callback(self):\n  if self.action ==\"callback\":\n   if not callable(self.callback):\n    raise OptionError(\n    \"callback not callable: %r\"%self.callback,self)\n   if (self.callback_args is not None and\n   not isinstance(self.callback_args,tuple)):\n    raise OptionError(\n    \"callback_args, if supplied, must be a tuple: not %r\"\n    %self.callback_args,self)\n   if (self.callback_kwargs is not None and\n   not isinstance(self.callback_kwargs,dict)):\n    raise OptionError(\n    \"callback_kwargs, if supplied, must be a dict: not %r\"\n    %self.callback_kwargs,self)\n  else :\n   if self.callback is not None :\n    raise OptionError(\n    \"callback supplied (%r) for non-callback option\"\n    %self.callback,self)\n   if self.callback_args is not None :\n    raise OptionError(\n    \"callback_args supplied for non-callback option\",self)\n   if self.callback_kwargs is not None :\n    raise OptionError(\n    \"callback_kwargs supplied for non-callback option\",self)\n    \n    \n CHECK_METHODS=[_check_action,\n _check_type,\n _check_choice,\n _check_dest,\n _check_const,\n _check_nargs,\n _check_callback]\n \n \n \n \n def __str__(self):\n  return \"/\".join(self._short_opts+self._long_opts)\n  \n __repr__=_repr\n \n def takes_value(self):\n  return self.type is not None\n  \n def get_opt_string(self):\n  if self._long_opts:\n   return self._long_opts[0]\n  else :\n   return self._short_opts[0]\n   \n   \n   \n   \n def check_value(self,opt,value):\n  checker=self.TYPE_CHECKER.get(self.type)\n  if checker is None :\n   return value\n  else :\n   return checker(self,opt,value)\n   \n def convert_value(self,opt,value):\n  if value is not None :\n   if self.nargs ==1:\n    return self.check_value(opt,value)\n   else :\n    return tuple([self.check_value(opt,v)for v in value])\n    \n def process(self,opt,value,values,parser):\n \n \n \n  value=self.convert_value(opt,value)\n  \n  \n  \n  \n  return self.take_action(\n  self.action,self.dest,opt,value,values,parser)\n  \n def take_action(self,action,dest,opt,value,values,parser):\n  if action ==\"store\":\n   setattr(values,dest,value)\n  elif action ==\"store_const\":\n   setattr(values,dest,self.const)\n  elif action ==\"store_true\":\n   setattr(values,dest,True )\n  elif action ==\"store_false\":\n   setattr(values,dest,False )\n  elif action ==\"append\":\n   values.ensure_value(dest,[]).append(value)\n  elif action ==\"append_const\":\n   values.ensure_value(dest,[]).append(self.const)\n  elif action ==\"count\":\n   setattr(values,dest,values.ensure_value(dest,0)+1)\n  elif action ==\"callback\":\n   args=self.callback_args or ()\n   kwargs=self.callback_kwargs or {}\n   self.callback(self,opt,value,parser,*args,**kwargs)\n  elif action ==\"help\":\n   parser.print_help()\n   parser.exit()\n  elif action ==\"version\":\n   parser.print_version()\n   parser.exit()\n  else :\n   raise ValueError(\"unknown action %r\"%self.action)\n   \n  return 1\n  \n  \n  \n  \nSUPPRESS_HELP=\"SUPPRESS\"+\"HELP\"\nSUPPRESS_USAGE=\"SUPPRESS\"+\"USAGE\"\n\nclass Values:\n\n def __init__(self,defaults=None ):\n  if defaults:\n   for (attr,val)in defaults.items():\n    setattr(self,attr,val)\n    \n def __str__(self):\n  return str(self.__dict__)\n  \n __repr__=_repr\n \n def __eq__(self,other):\n  if isinstance(other,Values):\n   return self.__dict__ ==other.__dict__\n  elif isinstance(other,dict):\n   return self.__dict__ ==other\n  else :\n   return NotImplemented\n   \n def _update_careful(self,dict):\n  ''\n\n\n\n\n  \n  for attr in dir(self):\n   if attr in dict:\n    dval=dict[attr]\n    if dval is not None :\n     setattr(self,attr,dval)\n     \n def _update_loose(self,dict):\n  ''\n\n\n\n  \n  self.__dict__.update(dict)\n  \n def _update(self,dict,mode):\n  if mode ==\"careful\":\n   self._update_careful(dict)\n  elif mode ==\"loose\":\n   self._update_loose(dict)\n  else :\n   raise ValueError(\"invalid update mode: %r\"%mode)\n   \n def read_module(self,modname,mode=\"careful\"):\n  __import__(modname)\n  mod=sys.modules[modname]\n  self._update(vars(mod),mode)\n  \n def read_file(self,filename,mode=\"careful\"):\n  vars={}\n  exec(open(filename).read(),vars)\n  self._update(vars,mode)\n  \n def ensure_value(self,attr,value):\n  if not hasattr(self,attr)or getattr(self,attr)is None :\n   setattr(self,attr,value)\n  return getattr(self,attr)\n  \n  \nclass OptionContainer:\n\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n def __init__(self,option_class,conflict_handler,description):\n \n \n \n \n  self._create_option_list()\n  \n  self.option_class=option_class\n  self.set_conflict_handler(conflict_handler)\n  self.set_description(description)\n  \n def _create_option_mappings(self):\n \n \n \n  self._short_opt={}\n  self._long_opt={}\n  self.defaults={}\n  \n  \n def _share_option_mappings(self,parser):\n \n \n  self._short_opt=parser._short_opt\n  self._long_opt=parser._long_opt\n  self.defaults=parser.defaults\n  \n def set_conflict_handler(self,handler):\n  if handler not in (\"error\",\"resolve\"):\n   raise ValueError(\"invalid conflict_resolution value %r\"%handler)\n  self.conflict_handler=handler\n  \n def set_description(self,description):\n  self.description=description\n  \n def get_description(self):\n  return self.description\n  \n  \n def destroy(self):\n  ''\n  del self._short_opt\n  del self._long_opt\n  del self.defaults\n  \n  \n  \n  \n def _check_conflict(self,option):\n  conflict_opts=[]\n  for opt in option._short_opts:\n   if opt in self._short_opt:\n    conflict_opts.append((opt,self._short_opt[opt]))\n  for opt in option._long_opts:\n   if opt in self._long_opt:\n    conflict_opts.append((opt,self._long_opt[opt]))\n    \n  if conflict_opts:\n   handler=self.conflict_handler\n   if handler ==\"error\":\n    raise OptionConflictError(\n    \"conflicting option string(s): %s\"\n    %\", \".join([co[0]for co in conflict_opts]),\n    option)\n   elif handler ==\"resolve\":\n    for (opt,c_option)in conflict_opts:\n     if opt.startswith(\"--\"):\n      c_option._long_opts.remove(opt)\n      del self._long_opt[opt]\n     else :\n      c_option._short_opts.remove(opt)\n      del self._short_opt[opt]\n     if not (c_option._short_opts or c_option._long_opts):\n      c_option.container.option_list.remove(c_option)\n      \n def add_option(self,*args,**kwargs):\n  ''\n\n  \n  if isinstance(args[0],str):\n   option=self.option_class(*args,**kwargs)\n  elif len(args)==1 and not kwargs:\n   option=args[0]\n   if not isinstance(option,Option):\n    raise TypeError(\"not an Option instance: %r\"%option)\n  else :\n   raise TypeError(\"invalid arguments\")\n   \n  self._check_conflict(option)\n  \n  self.option_list.append(option)\n  option.container=self\n  for opt in option._short_opts:\n   self._short_opt[opt]=option\n  for opt in option._long_opts:\n   self._long_opt[opt]=option\n   \n  if option.dest is not None :\n   if option.default is not NO_DEFAULT:\n    self.defaults[option.dest]=option.default\n   elif option.dest not in self.defaults:\n    self.defaults[option.dest]=None\n    \n  return option\n  \n def add_options(self,option_list):\n  for option in option_list:\n   self.add_option(option)\n   \n   \n   \n def get_option(self,opt_str):\n  return (self._short_opt.get(opt_str)or\n  self._long_opt.get(opt_str))\n  \n def has_option(self,opt_str):\n  return (opt_str in self._short_opt or\n  opt_str in self._long_opt)\n  \n def remove_option(self,opt_str):\n  option=self._short_opt.get(opt_str)\n  if option is None :\n   option=self._long_opt.get(opt_str)\n  if option is None :\n   raise ValueError(\"no such option %r\"%opt_str)\n   \n  for opt in option._short_opts:\n   del self._short_opt[opt]\n  for opt in option._long_opts:\n   del self._long_opt[opt]\n  option.container.option_list.remove(option)\n  \n  \n  \n  \n def format_option_help(self,formatter):\n  if not self.option_list:\n   return \"\"\n  result=[]\n  for option in self.option_list:\n   if not option.help is SUPPRESS_HELP:\n    result.append(formatter.format_option(option))\n  return \"\".join(result)\n  \n def format_description(self,formatter):\n  return formatter.format_description(self.get_description())\n  \n def format_help(self,formatter):\n  result=[]\n  if self.description:\n   result.append(self.format_description(formatter))\n  if self.option_list:\n   result.append(self.format_option_help(formatter))\n  return \"\\n\".join(result)\n  \n  \nclass OptionGroup(OptionContainer):\n\n def __init__(self,parser,title,description=None ):\n  self.parser=parser\n  OptionContainer.__init__(\n  self,parser.option_class,parser.conflict_handler,description)\n  self.title=title\n  \n def _create_option_list(self):\n  self.option_list=[]\n  self._share_option_mappings(self.parser)\n  \n def set_title(self,title):\n  self.title=title\n  \n def destroy(self):\n  ''\n  OptionContainer.destroy(self)\n  del self.option_list\n  \n  \n  \n def format_help(self,formatter):\n  result=formatter.format_heading(self.title)\n  formatter.indent()\n  result +=OptionContainer.format_help(self,formatter)\n  formatter.dedent()\n  return result\n  \n  \nclass OptionParser(OptionContainer):\n\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n \n standard_option_list=[]\n \n def __init__(self,\n usage=None ,\n option_list=None ,\n option_class=Option,\n version=None ,\n conflict_handler=\"error\",\n description=None ,\n formatter=None ,\n add_help_option=True ,\n prog=None ,\n epilog=None ):\n  OptionContainer.__init__(\n  self,option_class,conflict_handler,description)\n  self.set_usage(usage)\n  self.prog=prog\n  self.version=version\n  self.allow_interspersed_args=True\n  self.process_default_values=True\n  if formatter is None :\n   formatter=IndentedHelpFormatter()\n  self.formatter=formatter\n  self.formatter.set_parser(self)\n  self.epilog=epilog\n  \n  \n  \n  \n  \n  self._populate_option_list(option_list,\n  add_help=add_help_option)\n  \n  self._init_parsing_state()\n  \n  \n def destroy(self):\n  ''\n\n\n\n\n  \n  OptionContainer.destroy(self)\n  for group in self.option_groups:\n   group.destroy()\n  del self.option_list\n  del self.option_groups\n  del self.formatter\n  \n  \n  \n  \n  \n def _create_option_list(self):\n  self.option_list=[]\n  self.option_groups=[]\n  self._create_option_mappings()\n  \n def _add_help_option(self):\n  self.add_option(\"-h\",\"--help\",\n  action=\"help\",\n  help=_(\"show this help message and exit\"))\n  \n def _add_version_option(self):\n  self.add_option(\"--version\",\n  action=\"version\",\n  help=_(\"show program's version number and exit\"))\n  \n def _populate_option_list(self,option_list,add_help=True ):\n  if self.standard_option_list:\n   self.add_options(self.standard_option_list)\n  if option_list:\n   self.add_options(option_list)\n  if self.version:\n   self._add_version_option()\n  if add_help:\n   self._add_help_option()\n   \n def _init_parsing_state(self):\n \n  self.rargs=None\n  self.largs=None\n  self.values=None\n  \n  \n  \n  \n def set_usage(self,usage):\n  if usage is None :\n   self.usage=_(\"%prog [options]\")\n  elif usage is SUPPRESS_USAGE:\n   self.usage=None\n   \n  elif usage.lower().startswith(\"usage: \"):\n   self.usage=usage[7:]\n  else :\n   self.usage=usage\n   \n def enable_interspersed_args(self):\n  ''\n\n\n\n  \n  self.allow_interspersed_args=True\n  \n def disable_interspersed_args(self):\n  ''\n\n\n\n  \n  self.allow_interspersed_args=False\n  \n def set_process_default_values(self,process):\n  self.process_default_values=process\n  \n def set_default(self,dest,value):\n  self.defaults[dest]=value\n  \n def set_defaults(self,**kwargs):\n  self.defaults.update(kwargs)\n  \n def _get_all_options(self):\n  options=self.option_list[:]\n  for group in self.option_groups:\n   options.extend(group.option_list)\n  return options\n  \n def get_default_values(self):\n  if not self.process_default_values:\n  \n   return Values(self.defaults)\n   \n  defaults=self.defaults.copy()\n  for option in self._get_all_options():\n   default=defaults.get(option.dest)\n   if isinstance(default,str):\n    opt_str=option.get_opt_string()\n    defaults[option.dest]=option.check_value(opt_str,default)\n    \n  return Values(defaults)\n  \n  \n  \n  \n def add_option_group(self,*args,**kwargs):\n \n  if isinstance(args[0],str):\n   group=OptionGroup(self,*args,**kwargs)\n  elif len(args)==1 and not kwargs:\n   group=args[0]\n   if not isinstance(group,OptionGroup):\n    raise TypeError(\"not an OptionGroup instance: %r\"%group)\n   if group.parser is not self:\n    raise ValueError(\"invalid OptionGroup (wrong parser)\")\n  else :\n   raise TypeError(\"invalid arguments\")\n   \n  self.option_groups.append(group)\n  return group\n  \n def get_option_group(self,opt_str):\n  option=(self._short_opt.get(opt_str)or\n  self._long_opt.get(opt_str))\n  if option and option.container is not self:\n   return option.container\n  return None\n  \n  \n  \n  \n def _get_args(self,args):\n  if args is None :\n   return sys.argv[1:]\n  else :\n   return args[:]\n   \n def parse_args(self,args=None ,values=None ):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n  \n  rargs=self._get_args(args)\n  if values is None :\n   values=self.get_default_values()\n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n  self.rargs=rargs\n  self.largs=largs=[]\n  self.values=values\n  \n  try :\n   stop=self._process_args(largs,rargs,values)\n  except (BadOptionError,OptionValueError)as err:\n   self.error(str(err))\n   \n  args=largs+rargs\n  return self.check_values(values,args)\n  \n def check_values(self,values,args):\n  ''\n\n\n\n\n\n\n\n\n  \n  return (values,args)\n  \n def _process_args(self,largs,rargs,values):\n  ''\n\n\n\n\n\n\n\n  \n  while rargs:\n   arg=rargs[0]\n   \n   \n   \n   if arg ==\"--\":\n    del rargs[0]\n    return\n   elif arg[0:2]==\"--\":\n   \n    self._process_long_opt(rargs,values)\n   elif arg[:1]==\"-\"and len(arg)>1:\n   \n   \n    self._process_short_opts(rargs,values)\n   elif self.allow_interspersed_args:\n    largs.append(arg)\n    del rargs[0]\n   else :\n    return\n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n def _match_long_opt(self,opt):\n  ''\n\n\n\n\n  \n  return _match_abbrev(opt,self._long_opt)\n  \n def _process_long_opt(self,rargs,values):\n  arg=rargs.pop(0)\n  \n  \n  \n  if \"=\"in arg:\n   (opt,next_arg)=arg.split(\"=\",1)\n   rargs.insert(0,next_arg)\n   had_explicit_value=True\n  else :\n   opt=arg\n   had_explicit_value=False\n   \n  opt=self._match_long_opt(opt)\n  option=self._long_opt[opt]\n  if option.takes_value():\n   nargs=option.nargs\n   if len(rargs)<nargs:\n    self.error(ngettext(\n    \"%(option)s option requires %(number)d argument\",\n    \"%(option)s option requires %(number)d arguments\",\n    nargs)%{\"option\":opt,\"number\":nargs})\n   elif nargs ==1:\n    value=rargs.pop(0)\n   else :\n    value=tuple(rargs[0:nargs])\n    del rargs[0:nargs]\n    \n  elif had_explicit_value:\n   self.error(_(\"%s option does not take a value\")%opt)\n   \n  else :\n   value=None\n   \n  option.process(opt,value,values,self)\n  \n def _process_short_opts(self,rargs,values):\n  arg=rargs.pop(0)\n  stop=False\n  i=1\n  for ch in arg[1:]:\n   opt=\"-\"+ch\n   option=self._short_opt.get(opt)\n   i +=1\n   \n   if not option:\n    raise BadOptionError(opt)\n   if option.takes_value():\n   \n   \n    if i <len(arg):\n     rargs.insert(0,arg[i:])\n     stop=True\n     \n    nargs=option.nargs\n    if len(rargs)<nargs:\n     self.error(ngettext(\n     \"%(option)s option requires %(number)d argument\",\n     \"%(option)s option requires %(number)d arguments\",\n     nargs)%{\"option\":opt,\"number\":nargs})\n    elif nargs ==1:\n     value=rargs.pop(0)\n    else :\n     value=tuple(rargs[0:nargs])\n     del rargs[0:nargs]\n     \n   else :\n    value=None\n    \n   option.process(opt,value,values,self)\n   \n   if stop:\n    break\n    \n    \n    \n    \n def get_prog_name(self):\n  if self.prog is None :\n   return os.path.basename(sys.argv[0])\n  else :\n   return self.prog\n   \n def expand_prog_name(self,s):\n  return s.replace(\"%prog\",self.get_prog_name())\n  \n def get_description(self):\n  return self.expand_prog_name(self.description)\n  \n def exit(self,status=0,msg=None ):\n  if msg:\n   sys.stderr.write(msg)\n  sys.exit(status)\n  \n def error(self,msg):\n  ''\n\n\n\n\n  \n  self.print_usage(sys.stderr)\n  self.exit(2,\"%s: error: %s\\n\"%(self.get_prog_name(),msg))\n  \n def get_usage(self):\n  if self.usage:\n   return self.formatter.format_usage(\n   self.expand_prog_name(self.usage))\n  else :\n   return \"\"\n   \n def print_usage(self,file=None ):\n  ''\n\n\n\n\n\n\n  \n  if self.usage:\n   print(self.get_usage(),file=file)\n   \n def get_version(self):\n  if self.version:\n   return self.expand_prog_name(self.version)\n  else :\n   return \"\"\n   \n def print_version(self,file=None ):\n  ''\n\n\n\n\n\n  \n  if self.version:\n   print(self.get_version(),file=file)\n   \n def format_option_help(self,formatter=None ):\n  if formatter is None :\n   formatter=self.formatter\n  formatter.store_option_strings(self)\n  result=[]\n  result.append(formatter.format_heading(_(\"Options\")))\n  formatter.indent()\n  if self.option_list:\n   result.append(OptionContainer.format_option_help(self,formatter))\n   result.append(\"\\n\")\n  for group in self.option_groups:\n   result.append(group.format_help(formatter))\n   result.append(\"\\n\")\n  formatter.dedent()\n  \n  return \"\".join(result[:-1])\n  \n def format_epilog(self,formatter):\n  return formatter.format_epilog(self.epilog)\n  \n def format_help(self,formatter=None ):\n  if formatter is None :\n   formatter=self.formatter\n  result=[]\n  if self.usage:\n   result.append(self.get_usage()+\"\\n\")\n  if self.description:\n   result.append(self.format_description(formatter)+\"\\n\")\n  result.append(self.format_option_help(formatter))\n  result.append(self.format_epilog(formatter))\n  return \"\".join(result)\n  \n def print_help(self,file=None ):\n  ''\n\n\n\n  \n  if file is None :\n   file=sys.stdout\n  file.write(self.format_help())\n  \n  \n  \n  \ndef _match_abbrev(s,wordmap):\n ''\n\n\n\n\n \n \n if s in wordmap:\n  return s\n else :\n \n  possibilities=[word for word in wordmap.keys()\n  if word.startswith(s)]\n  \n  if len(possibilities)==1:\n   return possibilities[0]\n  elif not possibilities:\n   raise BadOptionError(s)\n  else :\n  \n   possibilities.sort()\n   raise AmbiguousOptionError(s,possibilities)\n   \n   \n   \n   \n   \n   \nmake_option=Option\n", ["gettext", "os", "sys", "textwrap"]], "os": [".py", "''\n\n\n\nimport sys\n\nerror=OSError\nname='posix'\nlinesep='\\n'\n\nfrom posix import *\nimport posixpath as path\n\nsys.modules['os.path']=path\nfrom os.path import (curdir,pardir,sep,pathsep,defpath,extsep,altsep,\ndevnull)\n\nenviron={'HOME':__BRYTHON__.curdir,\n'PYTHONPATH':__BRYTHON__.brython_path\n}\n\ndef _get_exports_list(module):\n try :\n  return list(module.__all__)\n except AttributeError:\n  return [n for n in dir(module)if n[0]!='_']\n  \ndef getenv(key,default=None ):\n ''\n\n \n return environ.get(key,default)\n \nsupports_bytes_environ=True\n\ndef chdir(path):\n __BRYTHON__.curdir=path\n \ndef fsencode(filename):\n ''\n\n\n\n \n encoding=sys.getfilesystemencoding()\n errors='surrogateescape'\n if isinstance(filename,bytes):\n  return filename\n elif isinstance(filename,str):\n  return filename.encode(encoding,errors)\n else :\n  raise TypeError(\"expect bytes or str, not %s\"%type(filename).__name__)\n  \ndef fsdecode(filename):\n ''\n\n\n\n \n encoding=sys.getfilesystemencoding()\n errors='surrogateescape'\n if isinstance(filename,str):\n  return filename\n elif isinstance(filename,bytes):\n  return filename.decode(encoding,errors)\n else :\n  raise TypeError(\"expect bytes or str, not %s\"%type(filename).__name__)\n  \ndef fspath(path):\n return path\n \ndef getcwd():\n return __BRYTHON__.curdir\n \n_set=set()\n\nsupports_dir_fd=_set\n\nsupports_effective_ids=_set\n\nsupports_fd=_set\n\nsupports_follow_symlinks=_set\n\n", ["os.path", "posix", "posixpath", "sys"]], "pdb": [".py", "#! /usr/bin/env python3\n\n\"\"\"\nThe Python Debugger Pdb\n=======================\n\nTo use the debugger in its simplest form:\n\n        >>> import pdb\n        >>> pdb.run('<a statement>')\n\nThe debugger's prompt is '(Pdb) '.  This will stop in the first\nfunction call in <a statement>.\n\nAlternatively, if a statement terminated with an unhandled exception,\nyou can use pdb's post-mortem facility to inspect the contents of the\ntraceback:\n\n        >>> <a statement>\n        <exception traceback>\n        >>> import pdb\n        >>> pdb.pm()\n\nThe commands recognized by the debugger are listed in the next\nsection.  Most can be abbreviated as indicated; e.g., h(elp) means\nthat 'help' can be typed as 'h' or 'help' (but not as 'he' or 'hel',\nnor as 'H' or 'Help' or 'HELP').  Optional arguments are enclosed in\nsquare brackets.  Alternatives in the command syntax are separated\nby a vertical bar (|).\n\nA blank line repeats the previous command literally, except for\n'list', where it lists the next 11 lines.\n\nCommands that the debugger doesn't recognize are assumed to be Python\nstatements and are executed in the context of the program being\ndebugged.  Python statements can also be prefixed with an exclamation\npoint ('!').  This is a powerful way to inspect the program being\ndebugged; it is even possible to change variables or call functions.\nWhen an exception occurs in such a statement, the exception name is\nprinted but the debugger's state is not changed.\n\nThe debugger supports aliases, which can save typing.  And aliases can\nhave parameters (see the alias help entry) which allows one a certain\nlevel of adaptability to the context under examination.\n\nMultiple commands may be entered on a single line, separated by the\npair ';;'.  No intelligence is applied to separating the commands; the\ninput is split at the first ';;', even if it is in the middle of a\nquoted string.\n\nIf a file \".pdbrc\" exists in your home directory or in the current\ndirectory, it is read in and executed as if it had been typed at the\ndebugger prompt.  This is particularly useful for aliases.  If both\nfiles exist, the one in the home directory is read first and aliases\ndefined there can be overridden by the local file.  This behavior can be\ndisabled by passing the \"readrc=False\" argument to the Pdb constructor.\n\nAside from aliases, the debugger is not directly programmable; but it\nis implemented as a class from which you can derive your own debugger\nclass, which you can make as fancy as you like.\n\n\nDebugger commands\n=================\n\n\"\"\"\n\n\n\nimport os\nimport re\nimport sys\nimport cmd\nimport bdb\nimport dis\nimport code\nimport glob\nimport pprint\nimport signal\nimport inspect\nimport traceback\nimport linecache\n\n\nclass Restart(Exception):\n ''\n pass\n \n__all__=[\"run\",\"pm\",\"Pdb\",\"runeval\",\"runctx\",\"runcall\",\"set_trace\",\n\"post_mortem\",\"help\"]\n\ndef find_function(funcname,filename):\n cre=re.compile(r'def\\s+%s\\s*[(]'%re.escape(funcname))\n try :\n  fp=open(filename)\n except OSError:\n  return None\n  \n with fp:\n  for lineno,line in enumerate(fp,start=1):\n   if cre.match(line):\n    return funcname,filename,lineno\n return None\n \ndef getsourcelines(obj):\n lines,lineno=inspect.findsource(obj)\n if inspect.isframe(obj)and obj.f_globals is obj.f_locals:\n \n  return lines,1\n elif inspect.ismodule(obj):\n  return lines,1\n return inspect.getblock(lines[lineno:]),lineno+1\n \ndef lasti2lineno(code,lasti):\n linestarts=list(dis.findlinestarts(code))\n linestarts.reverse()\n for i,lineno in linestarts:\n  if lasti >=i:\n   return lineno\n return 0\n \n \nclass _rstr(str):\n ''\n def __repr__(self):\n  return self\n  \n  \n  \n  \n  \n  \n  \nline_prefix='\\n-> '\n\nclass Pdb(bdb.Bdb,cmd.Cmd):\n\n _previous_sigint_handler=None\n \n def __init__(self,completekey='tab',stdin=None ,stdout=None ,skip=None ,\n nosigint=False ,readrc=True ):\n  bdb.Bdb.__init__(self,skip=skip)\n  cmd.Cmd.__init__(self,completekey,stdin,stdout)\n  if stdout:\n   self.use_rawinput=0\n  self.prompt='(Pdb) '\n  self.aliases={}\n  self.displaying={}\n  self.mainpyfile=''\n  self._wait_for_mainpyfile=False\n  self.tb_lineno={}\n  \n  try :\n   import readline\n   \n   readline.set_completer_delims(' \\t\\n`@#$%^&*()=+[{]}\\\\|;:\\'\",<>?')\n  except ImportError:\n   pass\n  self.allow_kbdint=False\n  self.nosigint=nosigint\n  \n  \n  self.rcLines=[]\n  if readrc:\n   if 'HOME'in os.environ:\n    envHome=os.environ['HOME']\n    try :\n     with open(os.path.join(envHome,\".pdbrc\"))as rcFile:\n      self.rcLines.extend(rcFile)\n    except OSError:\n     pass\n   try :\n    with open(\".pdbrc\")as rcFile:\n     self.rcLines.extend(rcFile)\n   except OSError:\n    pass\n    \n  self.commands={}\n  self.commands_doprompt={}\n  \n  self.commands_silent={}\n  \n  self.commands_defining=False\n  \n  self.commands_bnum=None\n  \n  \n def sigint_handler(self,signum,frame):\n  if self.allow_kbdint:\n   raise KeyboardInterrupt\n  self.message(\"\\nProgram interrupted. (Use 'cont' to resume).\")\n  self.set_step()\n  self.set_trace(frame)\n  \n def reset(self):\n  bdb.Bdb.reset(self)\n  self.forget()\n  \n def forget(self):\n  self.lineno=None\n  self.stack=[]\n  self.curindex=0\n  self.curframe=None\n  self.tb_lineno.clear()\n  \n def setup(self,f,tb):\n  self.forget()\n  self.stack,self.curindex=self.get_stack(f,tb)\n  while tb:\n  \n  \n  \n   lineno=lasti2lineno(tb.tb_frame.f_code,tb.tb_lasti)\n   self.tb_lineno[tb.tb_frame]=lineno\n   tb=tb.tb_next\n  self.curframe=self.stack[self.curindex][0]\n  \n  \n  \n  self.curframe_locals=self.curframe.f_locals\n  return self.execRcLines()\n  \n  \n def execRcLines(self):\n  if not self.rcLines:\n   return\n   \n  rcLines=self.rcLines\n  rcLines.reverse()\n  \n  self.rcLines=[]\n  while rcLines:\n   line=rcLines.pop().strip()\n   if line and line[0]!='#':\n    if self.onecmd(line):\n    \n    \n    \n     self.rcLines +=reversed(rcLines)\n     return True\n     \n     \n     \n def user_call(self,frame,argument_list):\n  ''\n  \n  if self._wait_for_mainpyfile:\n   return\n  if self.stop_here(frame):\n   self.message('--Call--')\n   self.interaction(frame,None )\n   \n def user_line(self,frame):\n  ''\n  if self._wait_for_mainpyfile:\n   if (self.mainpyfile !=self.canonic(frame.f_code.co_filename)\n   or frame.f_lineno <=0):\n    return\n   self._wait_for_mainpyfile=False\n  if self.bp_commands(frame):\n   self.interaction(frame,None )\n   \n def bp_commands(self,frame):\n  ''\n\n\n\n  \n  \n  if getattr(self,\"currentbp\",False )and\\\n  self.currentbp in self.commands:\n   currentbp=self.currentbp\n   self.currentbp=0\n   lastcmd_back=self.lastcmd\n   self.setup(frame,None )\n   for line in self.commands[currentbp]:\n    self.onecmd(line)\n   self.lastcmd=lastcmd_back\n   if not self.commands_silent[currentbp]:\n    self.print_stack_entry(self.stack[self.curindex])\n   if self.commands_doprompt[currentbp]:\n    self._cmdloop()\n   self.forget()\n   return\n  return 1\n  \n def user_return(self,frame,return_value):\n  ''\n  if self._wait_for_mainpyfile:\n   return\n  frame.f_locals['__return__']=return_value\n  self.message('--Return--')\n  self.interaction(frame,None )\n  \n def user_exception(self,frame,exc_info):\n  ''\n  \n  if self._wait_for_mainpyfile:\n   return\n  exc_type,exc_value,exc_traceback=exc_info\n  frame.f_locals['__exception__']=exc_type,exc_value\n  \n  \n  \n  \n  \n  \n  prefix='Internal 'if (not exc_traceback\n  and exc_type is StopIteration)else ''\n  self.message('%s%s'%(prefix,\n  traceback.format_exception_only(exc_type,exc_value)[-1].strip()))\n  self.interaction(frame,exc_traceback)\n  \n  \n def _cmdloop(self):\n  while True :\n   try :\n   \n   \n    self.allow_kbdint=True\n    self.cmdloop()\n    self.allow_kbdint=False\n    break\n   except KeyboardInterrupt:\n    self.message('--KeyboardInterrupt--')\n    \n    \n def preloop(self):\n  displaying=self.displaying.get(self.curframe)\n  if displaying:\n   for expr,oldvalue in displaying.items():\n    newvalue=self._getval_except(expr)\n    \n    \n    \n    if newvalue is not oldvalue and newvalue !=oldvalue:\n     displaying[expr]=newvalue\n     self.message('display %s: %r  [old: %r]'%\n     (expr,newvalue,oldvalue))\n     \n def interaction(self,frame,traceback):\n \n  if Pdb._previous_sigint_handler:\n   signal.signal(signal.SIGINT,Pdb._previous_sigint_handler)\n   Pdb._previous_sigint_handler=None\n  if self.setup(frame,traceback):\n  \n  \n   self.forget()\n   return\n  self.print_stack_entry(self.stack[self.curindex])\n  self._cmdloop()\n  self.forget()\n  \n def displayhook(self,obj):\n  ''\n\n  \n  \n  if obj is not None :\n   self.message(repr(obj))\n   \n def default(self,line):\n  if line[:1]=='!':line=line[1:]\n  locals=self.curframe_locals\n  globals=self.curframe.f_globals\n  try :\n   code=compile(line+'\\n','<stdin>','single')\n   save_stdout=sys.stdout\n   save_stdin=sys.stdin\n   save_displayhook=sys.displayhook\n   try :\n    sys.stdin=self.stdin\n    sys.stdout=self.stdout\n    sys.displayhook=self.displayhook\n    exec(code,globals,locals)\n   finally :\n    sys.stdout=save_stdout\n    sys.stdin=save_stdin\n    sys.displayhook=save_displayhook\n  except :\n   exc_info=sys.exc_info()[:2]\n   self.error(traceback.format_exception_only(*exc_info)[-1].strip())\n   \n def precmd(self,line):\n  ''\n  if not line.strip():\n   return line\n  args=line.split()\n  while args[0]in self.aliases:\n   line=self.aliases[args[0]]\n   ii=1\n   for tmpArg in args[1:]:\n    line=line.replace(\"%\"+str(ii),\n    tmpArg)\n    ii +=1\n   line=line.replace(\"%*\",' '.join(args[1:]))\n   args=line.split()\n   \n   \n  if args[0]!='alias':\n   marker=line.find(';;')\n   if marker >=0:\n   \n    next=line[marker+2:].lstrip()\n    self.cmdqueue.append(next)\n    line=line[:marker].rstrip()\n  return line\n  \n def onecmd(self,line):\n  ''\n\n\n\n\n  \n  if not self.commands_defining:\n   return cmd.Cmd.onecmd(self,line)\n  else :\n   return self.handle_command_def(line)\n   \n def handle_command_def(self,line):\n  ''\n  cmd,arg,line=self.parseline(line)\n  if not cmd:\n   return\n  if cmd =='silent':\n   self.commands_silent[self.commands_bnum]=True\n   return\n  elif cmd =='end':\n   self.cmdqueue=[]\n   return 1\n  cmdlist=self.commands[self.commands_bnum]\n  if arg:\n   cmdlist.append(cmd+' '+arg)\n  else :\n   cmdlist.append(cmd)\n   \n  try :\n   func=getattr(self,'do_'+cmd)\n  except AttributeError:\n   func=self.default\n   \n  if func.__name__ in self.commands_resuming:\n   self.commands_doprompt[self.commands_bnum]=False\n   self.cmdqueue=[]\n   return 1\n  return\n  \n  \n  \n def message(self,msg):\n  print(msg,file=self.stdout)\n  \n def error(self,msg):\n  print('***',msg,file=self.stdout)\n  \n  \n  \n  \n def _complete_location(self,text,line,begidx,endidx):\n \n  if line.strip().endswith((':',',')):\n  \n   return []\n   \n  try :\n   ret=self._complete_expression(text,line,begidx,endidx)\n  except Exception:\n   ret=[]\n   \n  globs=glob.glob(text+'*')\n  for fn in globs:\n   if os.path.isdir(fn):\n    ret.append(fn+'/')\n   elif os.path.isfile(fn)and fn.lower().endswith(('.py','.pyw')):\n    ret.append(fn+':')\n  return ret\n  \n def _complete_bpnumber(self,text,line,begidx,endidx):\n \n \n \n  return [str(i)for i,bp in enumerate(bdb.Breakpoint.bpbynumber)\n  if bp is not None and str(i).startswith(text)]\n  \n def _complete_expression(self,text,line,begidx,endidx):\n \n  if not self.curframe:\n   return []\n   \n   \n   \n  ns=self.curframe.f_globals.copy()\n  ns.update(self.curframe_locals)\n  if '.'in text:\n  \n  \n  \n   dotted=text.split('.')\n   try :\n    obj=ns[dotted[0]]\n    for part in dotted[1:-1]:\n     obj=getattr(obj,part)\n   except (KeyError,AttributeError):\n    return []\n   prefix='.'.join(dotted[:-1])+'.'\n   return [prefix+n for n in dir(obj)if n.startswith(dotted[-1])]\n  else :\n  \n   return [n for n in ns.keys()if n.startswith(text)]\n   \n   \n   \n   \n   \n def do_commands(self,arg):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  if not arg:\n   bnum=len(bdb.Breakpoint.bpbynumber)-1\n  else :\n   try :\n    bnum=int(arg)\n   except :\n    self.error(\"Usage: commands [bnum]\\n        ...\\n        end\")\n    return\n  self.commands_bnum=bnum\n  \n  if bnum in self.commands:\n   old_command_defs=(self.commands[bnum],\n   self.commands_doprompt[bnum],\n   self.commands_silent[bnum])\n  else :\n   old_command_defs=None\n  self.commands[bnum]=[]\n  self.commands_doprompt[bnum]=True\n  self.commands_silent[bnum]=False\n  \n  prompt_back=self.prompt\n  self.prompt='(com) '\n  self.commands_defining=True\n  try :\n   self.cmdloop()\n  except KeyboardInterrupt:\n  \n   if old_command_defs:\n    self.commands[bnum]=old_command_defs[0]\n    self.commands_doprompt[bnum]=old_command_defs[1]\n    self.commands_silent[bnum]=old_command_defs[2]\n   else :\n    del self.commands[bnum]\n    del self.commands_doprompt[bnum]\n    del self.commands_silent[bnum]\n   self.error('command definition aborted, old commands restored')\n  finally :\n   self.commands_defining=False\n   self.prompt=prompt_back\n   \n complete_commands=_complete_bpnumber\n \n def do_break(self,arg,temporary=0):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  if not arg:\n   if self.breaks:\n    self.message(\"Num Type         Disp Enb   Where\")\n    for bp in bdb.Breakpoint.bpbynumber:\n     if bp:\n      self.message(bp.bpformat())\n   return\n   \n   \n  filename=None\n  lineno=None\n  cond=None\n  comma=arg.find(',')\n  if comma >0:\n  \n   cond=arg[comma+1:].lstrip()\n   arg=arg[:comma].rstrip()\n   \n  colon=arg.rfind(':')\n  funcname=None\n  if colon >=0:\n   filename=arg[:colon].rstrip()\n   f=self.lookupmodule(filename)\n   if not f:\n    self.error('%r not found from sys.path'%filename)\n    return\n   else :\n    filename=f\n   arg=arg[colon+1:].lstrip()\n   try :\n    lineno=int(arg)\n   except ValueError:\n    self.error('Bad lineno: %s'%arg)\n    return\n  else :\n  \n   try :\n    lineno=int(arg)\n   except ValueError:\n    try :\n     func=eval(arg,\n     self.curframe.f_globals,\n     self.curframe_locals)\n    except :\n     func=arg\n    try :\n     if hasattr(func,'__func__'):\n      func=func.__func__\n     code=func.__code__\n     \n     \n     funcname=code.co_name\n     lineno=code.co_firstlineno\n     filename=code.co_filename\n    except :\n    \n     (ok,filename,ln)=self.lineinfo(arg)\n     if not ok:\n      self.error('The specified object %r is not a function '\n      'or was not found along sys.path.'%arg)\n      return\n     funcname=ok\n     lineno=int(ln)\n  if not filename:\n   filename=self.defaultFile()\n   \n  line=self.checkline(filename,lineno)\n  if line:\n  \n   err=self.set_break(filename,line,temporary,cond,funcname)\n   if err:\n    self.error(err)\n   else :\n    bp=self.get_breaks(filename,line)[-1]\n    self.message(\"Breakpoint %d at %s:%d\"%\n    (bp.number,bp.file,bp.line))\n    \n    \n def defaultFile(self):\n  ''\n  filename=self.curframe.f_code.co_filename\n  if filename =='<string>'and self.mainpyfile:\n   filename=self.mainpyfile\n  return filename\n  \n do_b=do_break\n \n complete_break=_complete_location\n complete_b=_complete_location\n \n def do_tbreak(self,arg):\n  ''\n\n\n  \n  self.do_break(arg,1)\n  \n complete_tbreak=_complete_location\n \n def lineinfo(self,identifier):\n  failed=(None ,None ,None )\n  \n  idstring=identifier.split(\"'\")\n  if len(idstring)==1:\n  \n   id=idstring[0].strip()\n  elif len(idstring)==3:\n  \n   id=idstring[1].strip()\n  else :\n   return failed\n  if id =='':return failed\n  parts=id.split('.')\n  \n  if parts[0]=='self':\n   del parts[0]\n   if len(parts)==0:\n    return failed\n    \n  fname=self.defaultFile()\n  if len(parts)==1:\n   item=parts[0]\n  else :\n  \n  \n   f=self.lookupmodule(parts[0])\n   if f:\n    fname=f\n   item=parts[1]\n  answer=find_function(item,fname)\n  return answer or failed\n  \n def checkline(self,filename,lineno):\n  ''\n\n\n\n  \n  \n  \n  globs=self.curframe.f_globals if hasattr(self,'curframe')else None\n  line=linecache.getline(filename,lineno,globs)\n  if not line:\n   self.message('End of file')\n   return 0\n  line=line.strip()\n  \n  if (not line or (line[0]=='#')or\n  (line[:3]=='\"\"\"')or line[:3]==\"'''\"):\n   self.error('Blank or comment')\n   return 0\n  return lineno\n  \n def do_enable(self,arg):\n  ''\n\n\n  \n  args=arg.split()\n  for i in args:\n   try :\n    bp=self.get_bpbynumber(i)\n   except ValueError as err:\n    self.error(err)\n   else :\n    bp.enable()\n    self.message('Enabled %s'%bp)\n    \n complete_enable=_complete_bpnumber\n \n def do_disable(self,arg):\n  ''\n\n\n\n\n\n  \n  args=arg.split()\n  for i in args:\n   try :\n    bp=self.get_bpbynumber(i)\n   except ValueError as err:\n    self.error(err)\n   else :\n    bp.disable()\n    self.message('Disabled %s'%bp)\n    \n complete_disable=_complete_bpnumber\n \n def do_condition(self,arg):\n  ''\n\n\n\n\n  \n  args=arg.split(' ',1)\n  try :\n   cond=args[1]\n  except IndexError:\n   cond=None\n  try :\n   bp=self.get_bpbynumber(args[0].strip())\n  except IndexError:\n   self.error('Breakpoint number expected')\n  except ValueError as err:\n   self.error(err)\n  else :\n   bp.cond=cond\n   if not cond:\n    self.message('Breakpoint %d is now unconditional.'%bp.number)\n   else :\n    self.message('New condition set for breakpoint %d.'%bp.number)\n    \n complete_condition=_complete_bpnumber\n \n def do_ignore(self,arg):\n  ''\n\n\n\n\n\n\n  \n  args=arg.split()\n  try :\n   count=int(args[1].strip())\n  except :\n   count=0\n  try :\n   bp=self.get_bpbynumber(args[0].strip())\n  except IndexError:\n   self.error('Breakpoint number expected')\n  except ValueError as err:\n   self.error(err)\n  else :\n   bp.ignore=count\n   if count >0:\n    if count >1:\n     countstr='%d crossings'%count\n    else :\n     countstr='1 crossing'\n    self.message('Will ignore next %s of breakpoint %d.'%\n    (countstr,bp.number))\n   else :\n    self.message('Will stop next time breakpoint %d is reached.'\n    %bp.number)\n    \n complete_ignore=_complete_bpnumber\n \n def do_clear(self,arg):\n  ''\n\n\n\n\n  \n  if not arg:\n   try :\n    reply=input('Clear all breaks? ')\n   except EOFError:\n    reply='no'\n   reply=reply.strip().lower()\n   if reply in ('y','yes'):\n    bplist=[bp for bp in bdb.Breakpoint.bpbynumber if bp]\n    self.clear_all_breaks()\n    for bp in bplist:\n     self.message('Deleted %s'%bp)\n   return\n  if ':'in arg:\n  \n   i=arg.rfind(':')\n   filename=arg[:i]\n   arg=arg[i+1:]\n   try :\n    lineno=int(arg)\n   except ValueError:\n    err=\"Invalid line number (%s)\"%arg\n   else :\n    bplist=self.get_breaks(filename,lineno)\n    err=self.clear_break(filename,lineno)\n   if err:\n    self.error(err)\n   else :\n    for bp in bplist:\n     self.message('Deleted %s'%bp)\n   return\n  numberlist=arg.split()\n  for i in numberlist:\n   try :\n    bp=self.get_bpbynumber(i)\n   except ValueError as err:\n    self.error(err)\n   else :\n    self.clear_bpbynumber(i)\n    self.message('Deleted %s'%bp)\n do_cl=do_clear\n \n complete_clear=_complete_location\n complete_cl=_complete_location\n \n def do_where(self,arg):\n  ''\n\n\n\n  \n  self.print_stack_trace()\n do_w=do_where\n do_bt=do_where\n \n def _select_frame(self,number):\n  assert 0 <=number <len(self.stack)\n  self.curindex=number\n  self.curframe=self.stack[self.curindex][0]\n  self.curframe_locals=self.curframe.f_locals\n  self.print_stack_entry(self.stack[self.curindex])\n  self.lineno=None\n  \n def do_up(self,arg):\n  ''\n\n\n  \n  if self.curindex ==0:\n   self.error('Oldest frame')\n   return\n  try :\n   count=int(arg or 1)\n  except ValueError:\n   self.error('Invalid frame count (%s)'%arg)\n   return\n  if count <0:\n   newframe=0\n  else :\n   newframe=max(0,self.curindex -count)\n  self._select_frame(newframe)\n do_u=do_up\n \n def do_down(self,arg):\n  ''\n\n\n  \n  if self.curindex+1 ==len(self.stack):\n   self.error('Newest frame')\n   return\n  try :\n   count=int(arg or 1)\n  except ValueError:\n   self.error('Invalid frame count (%s)'%arg)\n   return\n  if count <0:\n   newframe=len(self.stack)-1\n  else :\n   newframe=min(len(self.stack)-1,self.curindex+count)\n  self._select_frame(newframe)\n do_d=do_down\n \n def do_until(self,arg):\n  ''\n\n\n\n\n\n  \n  if arg:\n   try :\n    lineno=int(arg)\n   except ValueError:\n    self.error('Error in argument: %r'%arg)\n    return\n   if lineno <=self.curframe.f_lineno:\n    self.error('\"until\" line number is smaller than current '\n    'line number')\n    return\n  else :\n   lineno=None\n  self.set_until(self.curframe,lineno)\n  return 1\n do_unt=do_until\n \n def do_step(self,arg):\n  ''\n\n\n\n  \n  self.set_step()\n  return 1\n do_s=do_step\n \n def do_next(self,arg):\n  ''\n\n\n  \n  self.set_next(self.curframe)\n  return 1\n do_n=do_next\n \n def do_run(self,arg):\n  ''\n\n\n\n\n  \n  if arg:\n   import shlex\n   argv0=sys.argv[0:1]\n   sys.argv=shlex.split(arg)\n   sys.argv[:0]=argv0\n   \n  raise Restart\n  \n do_restart=do_run\n \n def do_return(self,arg):\n  ''\n\n  \n  self.set_return(self.curframe)\n  return 1\n do_r=do_return\n \n def do_continue(self,arg):\n  ''\n\n  \n  if not self.nosigint:\n   try :\n    Pdb._previous_sigint_handler=\\\n    signal.signal(signal.SIGINT,self.sigint_handler)\n   except ValueError:\n   \n   \n   \n   \n    pass\n  self.set_continue()\n  return 1\n do_c=do_cont=do_continue\n \n def do_jump(self,arg):\n  ''\n\n\n\n\n\n\n\n\n  \n  if self.curindex+1 !=len(self.stack):\n   self.error('You can only jump within the bottom frame')\n   return\n  try :\n   arg=int(arg)\n  except ValueError:\n   self.error(\"The 'jump' command requires a line number\")\n  else :\n   try :\n   \n   \n    self.curframe.f_lineno=arg\n    self.stack[self.curindex]=self.stack[self.curindex][0],arg\n    self.print_stack_entry(self.stack[self.curindex])\n   except ValueError as e:\n    self.error('Jump failed: %s'%e)\n do_j=do_jump\n \n def do_debug(self,arg):\n  ''\n\n\n\n  \n  sys.settrace(None )\n  globals=self.curframe.f_globals\n  locals=self.curframe_locals\n  p=Pdb(self.completekey,self.stdin,self.stdout)\n  p.prompt=\"(%s) \"%self.prompt.strip()\n  self.message(\"ENTERING RECURSIVE DEBUGGER\")\n  sys.call_tracing(p.run,(arg,globals,locals))\n  self.message(\"LEAVING RECURSIVE DEBUGGER\")\n  sys.settrace(self.trace_dispatch)\n  self.lastcmd=p.lastcmd\n  \n complete_debug=_complete_expression\n \n def do_quit(self,arg):\n  ''\n\n  \n  self._user_requested_quit=True\n  self.set_quit()\n  return 1\n  \n do_q=do_quit\n do_exit=do_quit\n \n def do_EOF(self,arg):\n  ''\n\n  \n  self.message('')\n  self._user_requested_quit=True\n  self.set_quit()\n  return 1\n  \n def do_args(self,arg):\n  ''\n\n  \n  co=self.curframe.f_code\n  dict=self.curframe_locals\n  n=co.co_argcount\n  if co.co_flags&4:n=n+1\n  if co.co_flags&8:n=n+1\n  for i in range(n):\n   name=co.co_varnames[i]\n   if name in dict:\n    self.message('%s = %r'%(name,dict[name]))\n   else :\n    self.message('%s = *** undefined ***'%(name,))\n do_a=do_args\n \n def do_retval(self,arg):\n  ''\n\n  \n  if '__return__'in self.curframe_locals:\n   self.message(repr(self.curframe_locals['__return__']))\n  else :\n   self.error('Not yet returned!')\n do_rv=do_retval\n \n def _getval(self,arg):\n  try :\n   return eval(arg,self.curframe.f_globals,self.curframe_locals)\n  except :\n   exc_info=sys.exc_info()[:2]\n   self.error(traceback.format_exception_only(*exc_info)[-1].strip())\n   raise\n   \n def _getval_except(self,arg,frame=None ):\n  try :\n   if frame is None :\n    return eval(arg,self.curframe.f_globals,self.curframe_locals)\n   else :\n    return eval(arg,frame.f_globals,frame.f_locals)\n  except :\n   exc_info=sys.exc_info()[:2]\n   err=traceback.format_exception_only(*exc_info)[-1].strip()\n   return _rstr('** raised %s **'%err)\n   \n def do_p(self,arg):\n  ''\n\n  \n  try :\n   self.message(repr(self._getval(arg)))\n  except :\n   pass\n   \n def do_pp(self,arg):\n  ''\n\n  \n  try :\n   self.message(pprint.pformat(self._getval(arg)))\n  except :\n   pass\n   \n complete_print=_complete_expression\n complete_p=_complete_expression\n complete_pp=_complete_expression\n \n def do_list(self,arg):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  self.lastcmd='list'\n  last=None\n  if arg and arg !='.':\n   try :\n    if ','in arg:\n     first,last=arg.split(',')\n     first=int(first.strip())\n     last=int(last.strip())\n     if last <first:\n     \n      last=first+last\n    else :\n     first=int(arg.strip())\n     first=max(1,first -5)\n   except ValueError:\n    self.error('Error in argument: %r'%arg)\n    return\n  elif self.lineno is None or arg =='.':\n   first=max(1,self.curframe.f_lineno -5)\n  else :\n   first=self.lineno+1\n  if last is None :\n   last=first+10\n  filename=self.curframe.f_code.co_filename\n  breaklist=self.get_file_breaks(filename)\n  try :\n   lines=linecache.getlines(filename,self.curframe.f_globals)\n   self._print_lines(lines[first -1:last],first,breaklist,\n   self.curframe)\n   self.lineno=min(last,len(lines))\n   if len(lines)<last:\n    self.message('[EOF]')\n  except KeyboardInterrupt:\n   pass\n do_l=do_list\n \n def do_longlist(self,arg):\n  ''\n\n  \n  filename=self.curframe.f_code.co_filename\n  breaklist=self.get_file_breaks(filename)\n  try :\n   lines,lineno=getsourcelines(self.curframe)\n  except OSError as err:\n   self.error(err)\n   return\n  self._print_lines(lines,lineno,breaklist,self.curframe)\n do_ll=do_longlist\n \n def do_source(self,arg):\n  ''\n\n  \n  try :\n   obj=self._getval(arg)\n  except :\n   return\n  try :\n   lines,lineno=getsourcelines(obj)\n  except (OSError,TypeError)as err:\n   self.error(err)\n   return\n  self._print_lines(lines,lineno)\n  \n complete_source=_complete_expression\n \n def _print_lines(self,lines,start,breaks=(),frame=None ):\n  ''\n  if frame:\n   current_lineno=frame.f_lineno\n   exc_lineno=self.tb_lineno.get(frame,-1)\n  else :\n   current_lineno=exc_lineno=-1\n  for lineno,line in enumerate(lines,start):\n   s=str(lineno).rjust(3)\n   if len(s)<4:\n    s +=' '\n   if lineno in breaks:\n    s +='B'\n   else :\n    s +=' '\n   if lineno ==current_lineno:\n    s +='->'\n   elif lineno ==exc_lineno:\n    s +='>>'\n   self.message(s+'\\t'+line.rstrip())\n   \n def do_whatis(self,arg):\n  ''\n\n  \n  try :\n   value=self._getval(arg)\n  except :\n  \n   return\n  code=None\n  \n  try :\n   code=value.__code__\n  except Exception:\n   pass\n  if code:\n   self.message('Function %s'%code.co_name)\n   return\n   \n  try :\n   code=value.__func__.__code__\n  except Exception:\n   pass\n  if code:\n   self.message('Method %s'%code.co_name)\n   return\n   \n  if value.__class__ is type:\n   self.message('Class %s.%s'%(value.__module__,value.__qualname__))\n   return\n   \n  self.message(type(value))\n  \n complete_whatis=_complete_expression\n \n def do_display(self,arg):\n  ''\n\n\n\n\n\n  \n  if not arg:\n   self.message('Currently displaying:')\n   for item in self.displaying.get(self.curframe,{}).items():\n    self.message('%s: %r'%item)\n  else :\n   val=self._getval_except(arg)\n   self.displaying.setdefault(self.curframe,{})[arg]=val\n   self.message('display %s: %r'%(arg,val))\n   \n complete_display=_complete_expression\n \n def do_undisplay(self,arg):\n  ''\n\n\n\n\n  \n  if arg:\n   try :\n    del self.displaying.get(self.curframe,{})[arg]\n   except KeyError:\n    self.error('not displaying %s'%arg)\n  else :\n   self.displaying.pop(self.curframe,None )\n   \n def complete_undisplay(self,text,line,begidx,endidx):\n  return [e for e in self.displaying.get(self.curframe,{})\n  if e.startswith(text)]\n  \n def do_interact(self,arg):\n  ''\n\n\n\n  \n  ns=self.curframe.f_globals.copy()\n  ns.update(self.curframe_locals)\n  code.interact(\"*interactive*\",local=ns)\n  \n def do_alias(self,arg):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  args=arg.split()\n  if len(args)==0:\n   keys=sorted(self.aliases.keys())\n   for alias in keys:\n    self.message(\"%s = %s\"%(alias,self.aliases[alias]))\n   return\n  if args[0]in self.aliases and len(args)==1:\n   self.message(\"%s = %s\"%(args[0],self.aliases[args[0]]))\n  else :\n   self.aliases[args[0]]=' '.join(args[1:])\n   \n def do_unalias(self,arg):\n  ''\n\n  \n  args=arg.split()\n  if len(args)==0:return\n  if args[0]in self.aliases:\n   del self.aliases[args[0]]\n   \n def complete_unalias(self,text,line,begidx,endidx):\n  return [a for a in self.aliases if a.startswith(text)]\n  \n  \n commands_resuming=['do_continue','do_step','do_next','do_return',\n 'do_quit','do_jump']\n \n \n \n \n \n \n \n \n \n def print_stack_trace(self):\n  try :\n   for frame_lineno in self.stack:\n    self.print_stack_entry(frame_lineno)\n  except KeyboardInterrupt:\n   pass\n   \n def print_stack_entry(self,frame_lineno,prompt_prefix=line_prefix):\n  frame,lineno=frame_lineno\n  if frame is self.curframe:\n   prefix='> '\n  else :\n   prefix='  '\n  self.message(prefix+\n  self.format_stack_entry(frame_lineno,prompt_prefix))\n  \n  \n  \n def do_help(self,arg):\n  ''\n\n\n\n\n  \n  if not arg:\n   return cmd.Cmd.do_help(self,arg)\n  try :\n   try :\n    topic=getattr(self,'help_'+arg)\n    return topic()\n   except AttributeError:\n    command=getattr(self,'do_'+arg)\n  except AttributeError:\n   self.error('No help for %r'%arg)\n  else :\n   if sys.flags.optimize >=2:\n    self.error('No help for %r; please do not run Python with -OO '\n    'if you need command help'%arg)\n    return\n   self.message(command.__doc__.rstrip())\n   \n do_h=do_help\n \n def help_exec(self):\n  ''\n\n\n\n\n\n\n\n  \n  self.message((self.help_exec.__doc__ or '').strip())\n  \n def help_pdb(self):\n  help()\n  \n  \n  \n def lookupmodule(self,filename):\n  ''\n\n\n\n  \n  if os.path.isabs(filename)and os.path.exists(filename):\n   return filename\n  f=os.path.join(sys.path[0],filename)\n  if os.path.exists(f)and self.canonic(f)==self.mainpyfile:\n   return f\n  root,ext=os.path.splitext(filename)\n  if ext =='':\n   filename=filename+'.py'\n  if os.path.isabs(filename):\n   return filename\n  for dirname in sys.path:\n   while os.path.islink(dirname):\n    dirname=os.readlink(dirname)\n   fullname=os.path.join(dirname,filename)\n   if os.path.exists(fullname):\n    return fullname\n  return None\n  \n def _runmodule(self,module_name):\n  self._wait_for_mainpyfile=True\n  self._user_requested_quit=False\n  import runpy\n  mod_name,mod_spec,code=runpy._get_module_details(module_name)\n  self.mainpyfile=self.canonic(code.co_filename)\n  import __main__\n  __main__.__dict__.clear()\n  __main__.__dict__.update({\n  \"__name__\":\"__main__\",\n  \"__file__\":self.mainpyfile,\n  \"__package__\":mod_spec.parent,\n  \"__loader__\":mod_spec.loader,\n  \"__spec__\":mod_spec,\n  \"__builtins__\":__builtins__,\n  })\n  self.run(code)\n  \n def _runscript(self,filename):\n \n \n \n \n \n  import __main__\n  __main__.__dict__.clear()\n  __main__.__dict__.update({\"__name__\":\"__main__\",\n  \"__file__\":filename,\n  \"__builtins__\":__builtins__,\n  })\n  \n  \n  \n  \n  \n  \n  self._wait_for_mainpyfile=True\n  self.mainpyfile=self.canonic(filename)\n  self._user_requested_quit=False\n  with open(filename,\"rb\")as fp:\n   statement=\"exec(compile(%r, %r, 'exec'))\"%\\\n   (fp.read(),self.mainpyfile)\n  self.run(statement)\n  \n  \n  \nif __doc__ is not None :\n\n _help_order=[\n 'help','where','down','up','break','tbreak','clear','disable',\n 'enable','ignore','condition','commands','step','next','until',\n 'jump','return','retval','run','continue','list','longlist',\n 'args','p','pp','whatis','source','display','undisplay',\n 'interact','alias','unalias','debug','quit',\n ]\n \n for _command in _help_order:\n  __doc__ +=getattr(Pdb,'do_'+_command).__doc__.strip()+'\\n\\n'\n __doc__ +=Pdb.help_exec.__doc__\n \n del _help_order,_command\n \n \n \n \ndef run(statement,globals=None ,locals=None ):\n Pdb().run(statement,globals,locals)\n \ndef runeval(expression,globals=None ,locals=None ):\n return Pdb().runeval(expression,globals,locals)\n \ndef runctx(statement,globals,locals):\n\n run(statement,globals,locals)\n \ndef runcall(*args,**kwds):\n return Pdb().runcall(*args,**kwds)\n \ndef set_trace(*,header=None ):\n pdb=Pdb()\n if header is not None :\n  pdb.message(header)\n pdb.set_trace(sys._getframe().f_back)\n \n \n \ndef post_mortem(t=None ):\n\n if t is None :\n \n \n  t=sys.exc_info()[2]\n if t is None :\n  raise ValueError(\"A valid traceback must be passed if no \"\n  \"exception is being handled\")\n  \n p=Pdb()\n p.reset()\n p.interaction(None ,t)\n \ndef pm():\n post_mortem(sys.last_traceback)\n \n \n \n \nTESTCMD='import x; x.main()'\n\ndef test():\n run(TESTCMD)\n \n \ndef help():\n import pydoc\n pydoc.pager(__doc__)\n \n_usage=\"\"\"\\\nusage: pdb.py [-c command] ... [-m module | pyfile] [arg] ...\n\nDebug the Python program given by pyfile. Alternatively,\nan executable module or package to debug can be specified using\nthe -m switch.\n\nInitial commands are read from .pdbrc files in your home directory\nand in the current directory, if they exist.  Commands supplied with\n-c are executed after commands from .pdbrc files.\n\nTo let the script run until an exception occurs, use \"-c continue\".\nTo let the script run up to a given line X in the debugged file, use\n\"-c 'until X'\".\"\"\"\n\ndef main():\n import getopt\n \n opts,args=getopt.getopt(sys.argv[1:],'mhc:',['--help','--command='])\n \n if not args:\n  print(_usage)\n  sys.exit(2)\n  \n commands=[]\n run_as_module=False\n for opt,optarg in opts:\n  if opt in ['-h','--help']:\n   print(_usage)\n   sys.exit()\n  elif opt in ['-c','--command']:\n   commands.append(optarg)\n  elif opt in ['-m']:\n   run_as_module=True\n   \n mainpyfile=args[0]\n if not run_as_module and not os.path.exists(mainpyfile):\n  print('Error:',mainpyfile,'does not exist')\n  sys.exit(1)\n  \n sys.argv[:]=args\n \n \n if not run_as_module:\n  sys.path[0]=os.path.dirname(mainpyfile)\n  \n  \n  \n  \n  \n pdb=Pdb()\n pdb.rcLines.extend(commands)\n while True :\n  try :\n   if run_as_module:\n    pdb._runmodule(mainpyfile)\n   else :\n    pdb._runscript(mainpyfile)\n   if pdb._user_requested_quit:\n    break\n   print(\"The program finished and will be restarted\")\n  except Restart:\n   print(\"Restarting\",mainpyfile,\"with arguments:\")\n   print(\"\\t\"+\" \".join(args))\n  except SystemExit:\n  \n   print(\"The program exited via sys.exit(). Exit status:\",end=' ')\n   print(sys.exc_info()[1])\n  except SyntaxError:\n   traceback.print_exc()\n   sys.exit(1)\n  except :\n   traceback.print_exc()\n   print(\"Uncaught exception. Entering post mortem debugging\")\n   print(\"Running 'cont' or 'step' will restart the program\")\n   t=sys.exc_info()[2]\n   pdb.interaction(None ,t)\n   print(\"Post mortem debugger finished. The \"+mainpyfile+\n   \" will be restarted\")\n   \n   \n   \nif __name__ =='__main__':\n import pdb\n pdb.main()\n", ["__main__", "bdb", "cmd", "code", "dis", "getopt", "glob", "inspect", "linecache", "os", "pdb", "pprint", "pydoc", "re", "readline", "runpy", "shlex", "signal", "sys", "traceback"]], "pickle": [".py", "''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nfrom types import FunctionType\nfrom copyreg import dispatch_table\nfrom copyreg import _extension_registry,_inverted_registry,_extension_cache\nfrom itertools import islice\nfrom functools import partial\nimport sys\nfrom sys import maxsize\nfrom struct import pack,unpack\nimport re\nimport io\nimport codecs\nimport _compat_pickle\n\n__all__=[\"PickleError\",\"PicklingError\",\"UnpicklingError\",\"Pickler\",\n\"Unpickler\",\"dump\",\"dumps\",\"load\",\"loads\"]\n\n\nbytes_types=(bytes,bytearray)\n\n\nformat_version=\"4.0\"\ncompatible_formats=[\"1.0\",\n\"1.1\",\n\"1.2\",\n\"1.3\",\n\"2.0\",\n\"3.0\",\n\"4.0\",\n]\n\n\nHIGHEST_PROTOCOL=4\n\n\n\n\nDEFAULT_PROTOCOL=3\n\nclass PickleError(Exception):\n ''\n pass\n \nclass PicklingError(PickleError):\n ''\n\n\n \n pass\n \nclass UnpicklingError(PickleError):\n ''\n\n\n\n\n\n\n \n pass\n \n \n \nclass _Stop(Exception):\n def __init__(self,value):\n  self.value=value\n  \n  \ntry :\n from org.python.core import PyStringMap\nexcept ImportError:\n PyStringMap=None\n \n \n \n \n \nMARK=b'('\nSTOP=b'.'\nPOP=b'0'\nPOP_MARK=b'1'\nDUP=b'2'\nFLOAT=b'F'\nINT=b'I'\nBININT=b'J'\nBININT1=b'K'\nLONG=b'L'\nBININT2=b'M'\nNONE=b'N'\nPERSID=b'P'\nBINPERSID=b'Q'\nREDUCE=b'R'\nSTRING=b'S'\nBINSTRING=b'T'\nSHORT_BINSTRING=b'U'\nUNICODE=b'V'\nBINUNICODE=b'X'\nAPPEND=b'a'\nBUILD=b'b'\nGLOBAL=b'c'\nDICT=b'd'\nEMPTY_DICT=b'}'\nAPPENDS=b'e'\nGET=b'g'\nBINGET=b'h'\nINST=b'i'\nLONG_BINGET=b'j'\nLIST=b'l'\nEMPTY_LIST=b']'\nOBJ=b'o'\nPUT=b'p'\nBINPUT=b'q'\nLONG_BINPUT=b'r'\nSETITEM=b's'\nTUPLE=b't'\nEMPTY_TUPLE=b')'\nSETITEMS=b'u'\nBINFLOAT=b'G'\n\nTRUE=b'I01\\n'\nFALSE=b'I00\\n'\n\n\n\nPROTO=b'\\x80'\nNEWOBJ=b'\\x81'\nEXT1=b'\\x82'\nEXT2=b'\\x83'\nEXT4=b'\\x84'\nTUPLE1=b'\\x85'\nTUPLE2=b'\\x86'\nTUPLE3=b'\\x87'\nNEWTRUE=b'\\x88'\nNEWFALSE=b'\\x89'\nLONG1=b'\\x8a'\nLONG4=b'\\x8b'\n\n_tuplesize2code=[EMPTY_TUPLE,TUPLE1,TUPLE2,TUPLE3]\n\n\n\nBINBYTES=b'B'\nSHORT_BINBYTES=b'C'\n\n\nSHORT_BINUNICODE=b'\\x8c'\nBINUNICODE8=b'\\x8d'\nBINBYTES8=b'\\x8e'\nEMPTY_SET=b'\\x8f'\nADDITEMS=b'\\x90'\nFROZENSET=b'\\x91'\nNEWOBJ_EX=b'\\x92'\nSTACK_GLOBAL=b'\\x93'\nMEMOIZE=b'\\x94'\nFRAME=b'\\x95'\n\n__all__.extend([x for x in dir()if re.match(\"[A-Z][A-Z0-9_]+$\",x)])\n\n\nclass _Framer:\n\n _FRAME_SIZE_MIN=4\n _FRAME_SIZE_TARGET=64 *1024\n \n def __init__(self,file_write):\n  self.file_write=file_write\n  self.current_frame=None\n  \n def start_framing(self):\n  self.current_frame=io.BytesIO()\n  \n def end_framing(self):\n  if self.current_frame and self.current_frame.tell()>0:\n   self.commit_frame(force=True )\n   self.current_frame=None\n   \n def commit_frame(self,force=False ):\n  if self.current_frame:\n   f=self.current_frame\n   if f.tell()>=self._FRAME_SIZE_TARGET or force:\n    data=f.getbuffer()\n    write=self.file_write\n    if len(data)>=self._FRAME_SIZE_MIN:\n    \n    \n    \n    \n     write(FRAME+pack(\"<Q\",len(data)))\n     \n     \n     \n     \n    write(data)\n    \n    \n    \n    \n    \n    self.current_frame=io.BytesIO()\n    \n def write(self,data):\n  if self.current_frame:\n   return self.current_frame.write(data)\n  else :\n   return self.file_write(data)\n   \n def write_large_bytes(self,header,payload):\n  write=self.file_write\n  if self.current_frame:\n  \n   self.commit_frame(force=True )\n   \n   \n   \n   \n   \n   \n   \n  write(header)\n  write(payload)\n  \n  \nclass _Unframer:\n\n def __init__(self,file_read,file_readline,file_tell=None ):\n  self.file_read=file_read\n  self.file_readline=file_readline\n  self.current_frame=None\n  \n def read(self,n):\n  if self.current_frame:\n   data=self.current_frame.read(n)\n   if not data and n !=0:\n    self.current_frame=None\n    return self.file_read(n)\n   if len(data)<n:\n    raise UnpicklingError(\n    \"pickle exhausted before end of frame\")\n   return data\n  else :\n   return self.file_read(n)\n   \n def readline(self):\n  if self.current_frame:\n   data=self.current_frame.readline()\n   if not data:\n    self.current_frame=None\n    return self.file_readline()\n   if data[-1]!=b'\\n'[0]:\n    raise UnpicklingError(\n    \"pickle exhausted before end of frame\")\n   return data\n  else :\n   return self.file_readline()\n   \n def load_frame(self,frame_size):\n  if self.current_frame and self.current_frame.read()!=b'':\n   raise UnpicklingError(\n   \"beginning of a new frame before end of current frame\")\n  self.current_frame=io.BytesIO(self.file_read(frame_size))\n  \n  \n  \n  \ndef _getattribute(obj,name):\n for subpath in name.split('.'):\n  if subpath =='<locals>':\n   raise AttributeError(\"Can't get local attribute {!r} on {!r}\"\n   .format(name,obj))\n  try :\n   parent=obj\n   obj=getattr(obj,subpath)\n  except AttributeError:\n   raise AttributeError(\"Can't get attribute {!r} on {!r}\"\n   .format(name,obj))from None\n return obj,parent\n \ndef whichmodule(obj,name):\n ''\n module_name=getattr(obj,'__module__',None )\n if module_name is not None :\n  return module_name\n  \n  \n for module_name,module in list(sys.modules.items()):\n  if module_name =='__main__'or module is None :\n   continue\n  try :\n   if _getattribute(module,name)[0]is obj:\n    return module_name\n  except AttributeError:\n   pass\n return '__main__'\n \ndef encode_long(x):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n if x ==0:\n  return b''\n nbytes=(x.bit_length()>>3)+1\n result=x.to_bytes(nbytes,byteorder='little',signed=True )\n if x <0 and nbytes >1:\n  if result[-1]==0xff and (result[-2]&0x80)!=0:\n   result=result[:-1]\n return result\n \ndef decode_long(data):\n ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n \n return int.from_bytes(data,byteorder='little',signed=True )\n \n \n \n \nclass _Pickler:\n\n def __init__(self,file,protocol=None ,*,fix_imports=True ):\n  ''\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  \n  if protocol is None :\n   protocol=DEFAULT_PROTOCOL\n  if protocol <0:\n   protocol=HIGHEST_PROTOCOL\n  elif not 0 <=protocol <=HIGHEST_PROTOCOL:\n   raise ValueError(\"pickle protocol must be <= %d\"%HIGHEST_PROTOCOL)\n  try :\n   self._file_write=file.write\n  except AttributeError:\n   raise TypeError(\"file must have a 'write' attribute\")\n  self.framer=_Framer(self._file_write)\n  self.write=self.framer.write\n  self._write_large_bytes=self.framer.write_large_bytes\n  self.memo={}\n  self.proto=int(protocol)\n  self.bin=protocol >=1\n  self.fast=0\n  self.fix_imports=fix_imports and protocol <3\n  \n def clear_memo(self):\n  ''\n\n\n\n\n\n  \n  self.memo.clear()\n  \n def dump(self,obj):\n  ''\n  \n  \n  if not hasattr(self,\"_file_write\"):\n   raise PicklingError(\"Pickler.__init__() was not called by \"\n   \"%s.__init__()\"%(self.__class__.__name__,))\n  if self.proto >=2:\n   self.write(PROTO+pack(\"<B\",self.proto))\n  if self.proto >=4:\n   self.framer.start_framing()\n  self.save(obj)\n  self.write(STOP)\n  self.framer.end_framing()\n  \n def memoize(self,obj):\n  ''\n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  if self.fast:\n   return\n  assert id(obj)not in self.memo\n  idx=len(self.memo)\n  self.write(self.put(idx))\n  self.memo[id(obj)]=idx,obj\n  \n  \n def put(self,idx):\n  if self.proto >=4:\n   return MEMOIZE\n  elif self.bin:\n   if idx <256:\n    return BINPUT+pack(\"<B\",idx)\n   else :\n    return LONG_BINPUT+pack(\"<I\",idx)\n  else :\n   return PUT+repr(idx).encode(\"ascii\")+b'\\n'\n   \n   \n def get(self,i):\n  if self.bin:\n   if i <256:\n    return BINGET+pack(\"<B\",i)\n   else :\n    return LONG_BINGET+pack(\"<I\",i)\n    \n  return GET+repr(i).encode(\"ascii\")+b'\\n'\n  \n def save(self,obj,save_persistent_id=True ):\n  self.framer.commit_frame()\n  \n  \n  pid=self.persistent_id(obj)\n  if pid is not None and save_persistent_id:\n   self.save_pers(pid)\n   return\n   \n   \n  x=self.memo.get(id(obj))\n  if x is not None :\n   self.write(self.get(x[0]))\n   return\n   \n   \n  t=type(obj)\n  f=self.dispatch.get(t)\n  if f is not None :\n   f(self,obj)\n   return\n   \n   \n  reduce=getattr(self,'dispatch_table',dispatch_table).get(t)\n  if reduce is not None :\n   rv=reduce(obj)\n  else :\n  \n   try :\n    issc=issubclass(t,type)\n   except TypeError:\n    issc=False\n   if issc:\n    self.save_global(obj)\n    return\n    \n    \n   reduce=getattr(obj,\"__reduce_ex__\",None )\n   i