import { _ as _objectSpread2, a as _defineProperty, b as _typeof } from './chunk-40949afc.js';

/**
 * Get value of an object property/path even if it's nested
 */
function getValueByPath(obj, path) {
  var value = path.split('.').reduce(function (o, i) {
    return o[i];
  }, obj);
  return value;
}
/**
 * Extension of indexOf method by equality function if specified
 */

function indexOf(array, obj, fn) {
  if (!array) return -1;
  if (!fn || typeof fn !== 'function') return array.indexOf(obj);

  for (var i = 0; i < array.length; i++) {
    if (fn(array[i], obj)) {
      return i;
    }
  }

  return -1;
}
/**
* Merge function to replace Object.assign with deep merging possibility
*/

var isObject = function isObject(item) {
  return _typeof(item) === 'object' && !Array.isArray(item);
};

var mergeFn = function mergeFn(target, source) {
  var isDeep = function isDeep(prop) {
    return isObject(source[prop]) && target.hasOwnProperty(prop) && isObject(target[prop]);
  };

  var replaced = Object.getOwnPropertyNames(source).map(function (prop) {
    return _defineProperty({}, prop, isDeep(prop) ? mergeFn(target[prop], source[prop]) : source[prop]);
  }).reduce(function (a, b) {
    return _objectSpread2({}, a, {}, b);
  }, {});
  return _objectSpread2({}, target, {}, replaced);
};

var merge = mergeFn;
/**
 * Mobile detection
 * https://www.abeautifulsite.net/detecting-mobile-devices-with-javascript
 */

var isMobile = {
  Android: function Android() {
    return typeof window !== 'undefined' && window.navigator.userAgent.match(/Android/i);
  },
  BlackBerry: function BlackBerry() {
    return typeof window !== 'undefined' && window.navigator.userAgent.match(/BlackBerry/i);
  },
  iOS: function iOS() {
    return typeof window !== 'undefined' && window.navigator.userAgent.match(/iPhone|iPad|iPod/i);
  },
  Opera: function Opera() {
    return typeof window !== 'undefined' && window.navigator.userAgent.match(/Opera Mini/i);
  },
  Windows: function Windows() {
    return typeof window !== 'undefined' && window.navigator.userAgent.match(/IEMobile/i);
  },
  any: function any() {
    return isMobile.Android() || isMobile.BlackBerry() || isMobile.iOS() || isMobile.Opera() || isMobile.Windows();
  }
};
function removeElement(el) {
  if (typeof el.remove !== 'undefined') {
    el.remove();
  } else if (typeof el.parentNode !== 'undefined') {
    el.parentNode.removeChild(el);
  }
}

export { indexOf as a, getValueByPath as g, isMobile as i, merge as m, removeElement as r };
