'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var __chunk_1 = require('./chunk-2777282e.js');
require('./chunk-b29181fc.js');
var __chunk_3 = require('./chunk-0820a378.js');
var __chunk_5 = require('./chunk-102d949d.js');
var __chunk_6 = require('./chunk-13e039f5.js');

var script = {
  name: 'BCarousel',
  components: __chunk_1._defineProperty({}, __chunk_5.Icon.name, __chunk_5.Icon),
  props: {
    value: {
      type: Number,
      default: 0
    },
    animated: {
      type: String,
      default: 'slide'
    },
    interval: Number,
    autoplay: {
      type: Boolean,
      default: true
    },
    pauseHover: {
      type: Boolean,
      default: true
    },
    pauseInfo: {
      type: Boolean,
      default: true
    },
    arrow: {
      type: Boolean,
      default: true
    },
    arrowBoth: {
      type: Boolean,
      default: true
    },
    arrowHover: {
      type: Boolean,
      default: true
    },
    iconPack: String,
    iconSize: String,
    iconPrev: {
      type: String,
      default: __chunk_3.config.defaultIconPrev
    },
    iconNext: {
      type: String,
      default: __chunk_3.config.defaultIconNext
    },
    indicator: {
      type: Boolean,
      default: true
    },
    indicatorInside: {
      type: Boolean,
      default: true
    },
    indicatorMode: {
      type: String,
      default: 'click'
    },
    indicatorStyle: {
      type: String,
      default: 'is-dots'
    }
  },
  data: function data() {
    return {
      _isCarousel: true,
      activeItem: this.value,
      carouselItems: [],
      isPause: false,
      timer: null
    };
  },
  watch: {
    /**
    * When v-model is changed set the new active tab.
    */
    value: function value(_value) {
      this.changeItem(_value, false);
    },

    /**
    * When tab-items are updated, set active one.
    */
    carouselItems: function carouselItems() {
      if (this.activeItem < this.carouselItems.length) {
        this.carouselItems[this.activeItem].isActive = true;
      }
    },

    /**
     *  When autoplay is change, set by status
     */
    autoplay: function autoplay(status) {
      status ? this.startTimer() : this.pauseTimer();
    }
  },
  methods: {
    startTimer: function startTimer() {
      var _this = this;

      if (!this.autoplay || this.timer) return;
      this.isPause = false;
      this.timer = setInterval(function () {
        _this.next();
      }, this.interval || __chunk_3.config.defaultCarouselInterval);
    },
    pauseTimer: function pauseTimer() {
      if (!this.pauseHover && this.autoplay) return;
      this.isPause = true;

      if (this.timer) {
        clearInterval(this.timer);
        this.timer = null;
      }
    },

    /**
    * Change the active item and emit change event.
    * action only for animated slide, there true = next, false = prev
    */
    changeItem: function changeItem(newIndex, action) {
      if (this.activeItem === newIndex) return;
      this.carouselItems[this.activeItem].status(false, action);
      this.carouselItems[newIndex].status(true, action);
      this.activeItem = newIndex;
      this.$emit('change', newIndex);
    },
    // Indicator trigger, emit input event and change active item.
    modeChange: function modeChange(trigger, value) {
      if (this.indicatorMode === trigger) {
        this.$emit('input', value);
        this.changeItem(value, false);
      }
    },
    prev: function prev() {
      return this.activeItem === 0 ? this.changeItem(this.carouselItems.length - 1, true) : this.changeItem(this.activeItem - 1, true);
    },
    next: function next() {
      return this.activeItem === this.carouselItems.length - 1 ? this.changeItem(0, false) : this.changeItem(this.activeItem + 1, false);
    },
    // checking arrow between both
    checkArrow: function checkArrow(value) {
      if (this.arrowBoth) return true;
      if (this.activeItem !== value) return true;
    },
    touchStart: function touchStart(event) {
      this.startX = event.changedTouches[0].pageX;
    },
    touchEnd: function touchEnd(event) {
      var diffX = event.changedTouches[0].pageX - this.startX;

      if (Math.abs(diffX) > 50) {
        if (diffX < 0) {
          this.next();
        } else {
          this.prev();
        }
      }
    }
  },
  mounted: function mounted() {
    if (this.activeItem < this.carouselItems.length) {
      this.carouselItems[this.activeItem].isActive = true;
    }

    this.startTimer();
  },
  beforeDestroy: function beforeDestroy() {
    this.pauseTimer();
  }
};

/* script */
const __vue_script__ = script;

/* template */
var __vue_render__ = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"carousel",on:{"mouseenter":_vm.pauseTimer,"mouseleave":_vm.startTimer,"touchstart":function($event){$event.stopPropagation();return _vm.touchStart($event)},"touchend":function($event){$event.stopPropagation();return _vm.touchEnd($event)}}},[_c('div',{staticClass:"carousel-list"},[_vm._t("default"),_vm._v(" "),(_vm.arrow)?_c('div',{staticClass:"carousel-arrow",class:{'is-hovered': _vm.arrowHover}},[(_vm.checkArrow(0))?_c('b-icon',{staticClass:"has-icons-left",attrs:{"pack":_vm.iconPack,"icon":_vm.iconPrev,"size":_vm.iconSize,"both":""},nativeOn:{"click":function($event){$event.preventDefault();return _vm.prev($event)}}}):_vm._e(),_vm._v(" "),(_vm.checkArrow(_vm.carouselItems.length - 1))?_c('b-icon',{staticClass:"has-icons-right",attrs:{"pack":_vm.iconPack,"icon":_vm.iconNext,"size":_vm.iconSize,"both":""},nativeOn:{"click":function($event){$event.preventDefault();return _vm.next($event)}}}):_vm._e()],1):_vm._e()],2),_vm._v(" "),(_vm.autoplay && _vm.pauseHover && _vm.pauseInfo && _vm.isPause)?_c('div',{staticClass:"carousel-pause"},[_c('span',{staticClass:"tag"},[_vm._v("Pause")])]):_vm._e(),_vm._v(" "),(_vm.indicator)?_c('div',{staticClass:"carousel-indicator",class:{'is-inside': _vm.indicatorInside}},_vm._l((_vm.carouselItems),function(item,index){return _c('a',{key:index,staticClass:"indicator-item",class:{'is-active': index === _vm.activeItem},on:{"mouseover":function($event){return _vm.modeChange('hover', index)},"click":function($event){return _vm.modeChange('click', index)}}},[_vm._t("indicators",[_c('span',{staticClass:"indicator-style",class:_vm.indicatorStyle})],{"i":index})],2)}),0):_vm._e()])};
var __vue_staticRenderFns__ = [];

  /* style */
  const __vue_inject_styles__ = undefined;
  /* scoped */
  const __vue_scope_id__ = undefined;
  /* module identifier */
  const __vue_module_identifier__ = undefined;
  /* functional template */
  const __vue_is_functional_template__ = false;
  /* style inject */
  
  /* style inject SSR */
  

  
  var Carousel = __chunk_6.__vue_normalize__(
    { render: __vue_render__, staticRenderFns: __vue_staticRenderFns__ },
    __vue_inject_styles__,
    __vue_script__,
    __vue_scope_id__,
    __vue_is_functional_template__,
    __vue_module_identifier__,
    undefined,
    undefined
  );

//
//
//
//
//
//
//
//
var script$1 = {
  name: 'BCarouselItem',
  data: function data() {
    return {
      isActive: false,
      transitionName: null
    };
  },
  computed: {
    transition: function transition() {
      if (this.$parent.animated === 'fade') {
        return 'fade';
      } else {
        return this.transitionName;
      }
    }
  },
  methods: {
    /**
    * Status of item, alter animation name based on action.
    */
    status: function status(value, action) {
      this.transitionName = action ? 'slide-next' : 'slide-prev';
      this.isActive = value;
    }
  },
  created: function created() {
    if (!this.$parent.$data._isCarousel) {
      this.$destroy();
      throw new Error('You should wrap bCarouselItem on a bCarousel');
    }

    this.$parent.carouselItems.push(this);
  },
  beforeDestroy: function beforeDestroy() {
    var index = this.$parent.carouselItems.indexOf(this);

    if (index >= 0) {
      this.$parent.carouselItems.splice(index, 1);
    }
  }
};

/* script */
const __vue_script__$1 = script$1;

/* template */
var __vue_render__$1 = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('transition',{attrs:{"name":_vm.transition}},[_c('div',{directives:[{name:"show",rawName:"v-show",value:(_vm.isActive),expression:"isActive"}],staticClass:"carousel-item"},[_vm._t("default")],2)])};
var __vue_staticRenderFns__$1 = [];

  /* style */
  const __vue_inject_styles__$1 = undefined;
  /* scoped */
  const __vue_scope_id__$1 = undefined;
  /* module identifier */
  const __vue_module_identifier__$1 = undefined;
  /* functional template */
  const __vue_is_functional_template__$1 = false;
  /* style inject */
  
  /* style inject SSR */
  

  
  var CarouselItem = __chunk_6.__vue_normalize__(
    { render: __vue_render__$1, staticRenderFns: __vue_staticRenderFns__$1 },
    __vue_inject_styles__$1,
    __vue_script__$1,
    __vue_scope_id__$1,
    __vue_is_functional_template__$1,
    __vue_module_identifier__$1,
    undefined,
    undefined
  );

var Plugin = {
  install: function install(Vue) {
    __chunk_6.registerComponent(Vue, Carousel);
    __chunk_6.registerComponent(Vue, CarouselItem);
  }
};
__chunk_6.use(Plugin);

exports.BCarousel = Carousel;
exports.BCarouselItem = CarouselItem;
exports.default = Plugin;
