/*! Buefy v0.9.2 | MIT License | github.com/buefy/buefy */
(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
  typeof define === 'function' && define.amd ? define(['exports'], factory) :
  (global = global || self, factory(global.Sidebar = {}));
}(this, function (exports) { 'use strict';

  function removeElement(el) {
    if (typeof el.remove !== 'undefined') {
      el.remove();
    } else if (typeof el.parentNode !== 'undefined' && el.parentNode !== null) {
      el.parentNode.removeChild(el);
    }
  }
  function isCustomElement(vm) {
    return 'shadowRoot' in vm.$root.$options;
  }

  //
  var script = {
    name: 'BSidebar',
    // deprecated, to replace with default 'value' in the next breaking change
    model: {
      prop: 'open',
      event: 'update:open'
    },
    props: {
      open: Boolean,
      type: [String, Object],
      overlay: Boolean,
      position: {
        type: String,
        default: 'fixed',
        validator: function validator(value) {
          return ['fixed', 'absolute', 'static'].indexOf(value) >= 0;
        }
      },
      fullheight: Boolean,
      fullwidth: Boolean,
      right: Boolean,
      mobile: {
        type: String
      },
      reduce: Boolean,
      expandOnHover: Boolean,
      expandOnHoverFixed: Boolean,
      canCancel: {
        type: [Array, Boolean],
        default: function _default() {
          return ['escape', 'outside'];
        }
      },
      onCancel: {
        type: Function,
        default: function _default() {}
      }
    },
    data: function data() {
      return {
        isOpen: this.open,
        transitionName: null,
        animating: true
      };
    },
    computed: {
      rootClasses: function rootClasses() {
        return [this.type, {
          'is-fixed': this.isFixed,
          'is-static': this.isStatic,
          'is-absolute': this.isAbsolute,
          'is-fullheight': this.fullheight,
          'is-fullwidth': this.fullwidth,
          'is-right': this.right,
          'is-mini': this.reduce,
          'is-mini-expand': this.expandOnHover,
          'is-mini-expand-fixed': this.expandOnHover && this.expandOnHoverFixed,
          'is-mini-mobile': this.mobile === 'reduce',
          'is-hidden-mobile': this.mobile === 'hide',
          'is-fullwidth-mobile': this.mobile === 'fullwidth'
        }];
      },
      cancelOptions: function cancelOptions() {
        return typeof this.canCancel === 'boolean' ? this.canCancel ? ['escape', 'outside'] : [] : this.canCancel;
      },
      isStatic: function isStatic() {
        return this.position === 'static';
      },
      isFixed: function isFixed() {
        return this.position === 'fixed';
      },
      isAbsolute: function isAbsolute() {
        return this.position === 'absolute';
      },

      /**
       * White-listed items to not close when clicked.
       * Add sidebar content and all children.
       */
      whiteList: function whiteList() {
        var whiteList = [];
        whiteList.push(this.$refs.sidebarContent); // Add all chidren from dropdown

        if (this.$refs.sidebarContent !== undefined) {
          var children = this.$refs.sidebarContent.querySelectorAll('*');
          var _iteratorNormalCompletion = true;
          var _didIteratorError = false;
          var _iteratorError = undefined;

          try {
            for (var _iterator = children[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
              var child = _step.value;
              whiteList.push(child);
            }
          } catch (err) {
            _didIteratorError = true;
            _iteratorError = err;
          } finally {
            try {
              if (!_iteratorNormalCompletion && _iterator.return != null) {
                _iterator.return();
              }
            } finally {
              if (_didIteratorError) {
                throw _iteratorError;
              }
            }
          }
        }

        return whiteList;
      }
    },
    watch: {
      open: {
        handler: function handler(value) {
          this.isOpen = value;
          var open = this.right ? !value : value;
          this.transitionName = !open ? 'slide-prev' : 'slide-next';
        },
        immediate: true
      }
    },
    methods: {
      /**
      * Keypress event that is bound to the document.
      */
      keyPress: function keyPress(_ref) {
        var key = _ref.key;

        if (this.isFixed) {
          if (this.isOpen && (key === 'Escape' || key === 'Esc')) this.cancel('escape');
        }
      },

      /**
      * Close the Sidebar if canCancel and call the onCancel prop (function).
      */
      cancel: function cancel(method) {
        if (this.cancelOptions.indexOf(method) < 0) return;
        if (this.isStatic) return;
        this.onCancel.apply(null, arguments);
        this.close();
      },

      /**
      * Call the onCancel prop (function) and emit events
      */
      close: function close() {
        this.isOpen = false;
        this.$emit('close');
        this.$emit('update:open', false);
      },

      /**
       * Close fixed sidebar if clicked outside.
       */
      clickedOutside: function clickedOutside(event) {
        if (this.isFixed) {
          if (this.isOpen && !this.animating) {
            var target = isCustomElement(this) ? event.composedPath()[0] : event.target;

            if (this.whiteList.indexOf(target) < 0) {
              this.cancel('outside');
            }
          }
        }
      },

      /**
      * Transition before-enter hook
      */
      beforeEnter: function beforeEnter() {
        this.animating = true;
      },

      /**
      * Transition after-leave hook
      */
      afterEnter: function afterEnter() {
        this.animating = false;
      }
    },
    created: function created() {
      if (typeof window !== 'undefined') {
        document.addEventListener('keyup', this.keyPress);
        document.addEventListener('click', this.clickedOutside);
      }
    },
    mounted: function mounted() {
      if (typeof window !== 'undefined') {
        if (this.isFixed) {
          document.body.appendChild(this.$el);
        }
      }
    },
    beforeDestroy: function beforeDestroy() {
      if (typeof window !== 'undefined') {
        document.removeEventListener('keyup', this.keyPress);
        document.removeEventListener('click', this.clickedOutside);
      }

      if (this.isFixed) {
        removeElement(this.$el);
      }
    }
  };

  function normalizeComponent(template, style, script, scopeId, isFunctionalTemplate, moduleIdentifier
  /* server only */
  , shadowMode, createInjector, createInjectorSSR, createInjectorShadow) {
    if (typeof shadowMode !== 'boolean') {
      createInjectorSSR = createInjector;
      createInjector = shadowMode;
      shadowMode = false;
    } // Vue.extend constructor export interop.


    var options = typeof script === 'function' ? script.options : script; // render functions

    if (template && template.render) {
      options.render = template.render;
      options.staticRenderFns = template.staticRenderFns;
      options._compiled = true; // functional template

      if (isFunctionalTemplate) {
        options.functional = true;
      }
    } // scopedId


    if (scopeId) {
      options._scopeId = scopeId;
    }

    var hook;

    if (moduleIdentifier) {
      // server build
      hook = function hook(context) {
        // 2.3 injection
        context = context || // cached call
        this.$vnode && this.$vnode.ssrContext || // stateful
        this.parent && this.parent.$vnode && this.parent.$vnode.ssrContext; // functional
        // 2.2 with runInNewContext: true

        if (!context && typeof __VUE_SSR_CONTEXT__ !== 'undefined') {
          context = __VUE_SSR_CONTEXT__;
        } // inject component styles


        if (style) {
          style.call(this, createInjectorSSR(context));
        } // register component module identifier for async chunk inference


        if (context && context._registeredComponents) {
          context._registeredComponents.add(moduleIdentifier);
        }
      }; // used by ssr in case component is cached and beforeCreate
      // never gets called


      options._ssrRegister = hook;
    } else if (style) {
      hook = shadowMode ? function () {
        style.call(this, createInjectorShadow(this.$root.$options.shadowRoot));
      } : function (context) {
        style.call(this, createInjector(context));
      };
    }

    if (hook) {
      if (options.functional) {
        // register for functional component in vue file
        var originalRender = options.render;

        options.render = function renderWithStyleInjection(h, context) {
          hook.call(context);
          return originalRender(h, context);
        };
      } else {
        // inject component registration as beforeCreate hook
        var existing = options.beforeCreate;
        options.beforeCreate = existing ? [].concat(existing, hook) : [hook];
      }
    }

    return script;
  }

  var normalizeComponent_1 = normalizeComponent;

  /* script */
  const __vue_script__ = script;

  /* template */
  var __vue_render__ = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"b-sidebar"},[(_vm.overlay && _vm.isOpen)?_c('div',{staticClass:"sidebar-background"}):_vm._e(),_c('transition',{attrs:{"name":_vm.transitionName},on:{"before-enter":_vm.beforeEnter,"after-enter":_vm.afterEnter}},[_c('div',{directives:[{name:"show",rawName:"v-show",value:(_vm.isOpen),expression:"isOpen"}],ref:"sidebarContent",staticClass:"sidebar-content",class:_vm.rootClasses},[_vm._t("default")],2)])],1)};
  var __vue_staticRenderFns__ = [];

    /* style */
    const __vue_inject_styles__ = undefined;
    /* scoped */
    const __vue_scope_id__ = undefined;
    /* module identifier */
    const __vue_module_identifier__ = undefined;
    /* functional template */
    const __vue_is_functional_template__ = false;
    /* style inject */
    
    /* style inject SSR */
    

    
    var Sidebar = normalizeComponent_1(
      { render: __vue_render__, staticRenderFns: __vue_staticRenderFns__ },
      __vue_inject_styles__,
      __vue_script__,
      __vue_scope_id__,
      __vue_is_functional_template__,
      __vue_module_identifier__,
      undefined,
      undefined
    );

  var use = function use(plugin) {
    if (typeof window !== 'undefined' && window.Vue) {
      window.Vue.use(plugin);
    }
  };
  var registerComponent = function registerComponent(Vue, component) {
    Vue.component(component.name, component);
  };

  var Plugin = {
    install: function install(Vue) {
      registerComponent(Vue, Sidebar);
    }
  };
  use(Plugin);

  exports.BSidebar = Sidebar;
  exports.default = Plugin;

  Object.defineProperty(exports, '__esModule', { value: true });

}));
