'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var __chunk_5 = require('./chunk-13e039f5.js');

var script = {
  name: 'BSkeleton',
  functional: true,
  props: {
    active: {
      type: Boolean,
      default: true
    },
    animated: {
      type: Boolean,
      default: true
    },
    width: [Number, String],
    height: [Number, String],
    circle: Boolean,
    rounded: {
      type: Boolean,
      default: true
    },
    count: {
      type: Number,
      default: 1
    },
    position: {
      type: String,
      default: '',
      validator: function validator(value) {
        return ['', 'is-centered', 'is-right'].indexOf(value) > -1;
      }
    },
    size: String
  },
  render: function render(createElement, context) {
    if (!context.props.active) return;
    var items = [];
    var width = context.props.width;
    var height = context.props.height;

    for (var i = 0; i < context.props.count; i++) {
      items.push(createElement('div', {
        staticClass: 'b-skeleton-item',
        class: {
          'is-rounded': context.props.rounded
        },
        key: i,
        style: {
          height: height === undefined ? null : isNaN(height) ? height : height + 'px',
          width: width === undefined ? null : isNaN(width) ? width : width + 'px',
          borderRadius: context.props.circle ? '50%' : null
        }
      }));
    }

    return createElement('div', {
      staticClass: 'b-skeleton',
      class: [context.props.size, context.props.position, {
        'is-animated': context.props.animated
      }]
    }, items);
  }
};

/* script */
const __vue_script__ = script;

/* template */

  /* style */
  const __vue_inject_styles__ = undefined;
  /* scoped */
  const __vue_scope_id__ = undefined;
  /* module identifier */
  const __vue_module_identifier__ = undefined;
  /* functional template */
  const __vue_is_functional_template__ = undefined;
  /* style inject */
  
  /* style inject SSR */
  

  
  var Skeleton = __chunk_5.__vue_normalize__(
    {},
    __vue_inject_styles__,
    __vue_script__,
    __vue_scope_id__,
    __vue_is_functional_template__,
    __vue_module_identifier__,
    undefined,
    undefined
  );

var Plugin = {
  install: function install(Vue) {
    __chunk_5.registerComponent(Vue, Skeleton);
  }
};
__chunk_5.use(Plugin);

exports.BSkeleton = Skeleton;
exports.default = Plugin;
