import './chunk-455cdeae.js';
import { merge } from './helpers.js';
export { bound, createAbsoluteElement, createNewEvent, escapeRegExpChars, getMonthNames, getValueByPath, getWeekdayNames, hasFlag, indexOf, isCustomElement, isDefined, isMobile, isNil, isVueComponent, isWebpSupported, matchWithGroups, merge, mod, multiColumnSort, removeDiacriticsFromString, removeElement, sign, toCssWidth } from './helpers.js';
import { s as setVueInstance, a as setOptions, c as config } from './chunk-e92e3389.js';
import './chunk-17b33cd2.js';
import './chunk-7e17a637.js';
import { a as registerComponentProgrammatic, u as use } from './chunk-cca88db8.js';
import './chunk-83c8b459.js';
import './chunk-b0123b89.js';
import Plugin from './autocomplete.js';
export { default as Autocomplete } from './autocomplete.js';
import Plugin$1 from './breadcrumb.js';
export { default as Breadcrumb } from './breadcrumb.js';
import './chunk-b5576437.js';
import Plugin$2 from './button.js';
export { default as Button } from './button.js';
import './chunk-60a03517.js';
import Plugin$3 from './carousel.js';
export { default as Carousel } from './carousel.js';
import './chunk-493ff0a9.js';
import './chunk-2793447b.js';
import './chunk-4a2008fa.js';
import Plugin$4 from './checkbox.js';
export { default as Checkbox } from './checkbox.js';
import Plugin$6 from './collapse.js';
export { default as Collapse } from './collapse.js';
import './chunk-6e56b8bc.js';
import './chunk-42f463e6.js';
import './chunk-ade5b253.js';
import './chunk-d46e7ff0.js';
import Plugin$5 from './clockpicker.js';
export { default as Clockpicker } from './clockpicker.js';
import Plugin$7 from './colorpicker.js';
export { default as Colorpicker } from './colorpicker.js';
import './chunk-4e788733.js';
import './chunk-9b0b8225.js';
import './chunk-6c64686f.js';
import Plugin$8 from './datepicker.js';
export { default as Datepicker } from './datepicker.js';
import './chunk-293c457c.js';
import Plugin$9 from './datetimepicker.js';
export { default as Datetimepicker } from './datetimepicker.js';
import './chunk-33e1434e.js';
import Plugin$a from './dialog.js';
export { default as Dialog, DialogProgrammatic } from './dialog.js';
import Plugin$b from './dropdown.js';
export { default as Dropdown } from './dropdown.js';
import Plugin$c from './field.js';
export { default as Field } from './field.js';
import Plugin$d from './icon.js';
export { default as Icon } from './icon.js';
import Plugin$e from './image.js';
export { default as Image } from './image.js';
import Plugin$f from './input.js';
export { default as Input } from './input.js';
import './chunk-b9bdb0e4.js';
import './chunk-6d0f2352.js';
import Plugin$g from './loading.js';
export { default as Loading, LoadingProgrammatic } from './loading.js';
import Plugin$h from './menu.js';
export { default as Menu } from './menu.js';
import './chunk-7bb9107f.js';
import Plugin$i from './message.js';
export { default as Message } from './message.js';
import Plugin$j from './modal.js';
export { default as Modal, ModalProgrammatic } from './modal.js';
import Plugin$l from './notification.js';
export { default as Notification, NotificationProgrammatic } from './notification.js';
import './chunk-a32d1427.js';
import Plugin$k from './navbar.js';
export { default as Navbar } from './navbar.js';
import Plugin$m from './numberinput.js';
export { default as Numberinput } from './numberinput.js';
import './chunk-c5284276.js';
import Plugin$n from './pagination.js';
export { default as Pagination } from './pagination.js';
import Plugin$o from './progress.js';
export { default as Progress } from './progress.js';
import Plugin$p from './radio.js';
export { default as Radio } from './radio.js';
import Plugin$q from './rate.js';
export { default as Rate } from './rate.js';
import Plugin$r from './select.js';
export { default as Select } from './select.js';
import Plugin$s from './skeleton.js';
export { default as Skeleton } from './skeleton.js';
import Plugin$t from './sidebar.js';
export { default as Sidebar } from './sidebar.js';
import Plugin$u from './slider.js';
export { default as Slider } from './slider.js';
import Plugin$v from './snackbar.js';
export { default as Snackbar, SnackbarProgrammatic } from './snackbar.js';
import './chunk-c9c18b2f.js';
import './chunk-f32d0228.js';
import Plugin$w from './steps.js';
export { default as Steps } from './steps.js';
import Plugin$x from './switch.js';
export { default as Switch } from './switch.js';
import Plugin$y from './table.js';
export { default as Table } from './table.js';
import Plugin$z from './tabs.js';
export { default as Tabs } from './tabs.js';
import './chunk-2f2f0a74.js';
import Plugin$A from './tag.js';
export { default as Tag } from './tag.js';
import Plugin$B from './taginput.js';
export { default as Taginput } from './taginput.js';
import Plugin$C from './timepicker.js';
export { default as Timepicker } from './timepicker.js';
import Plugin$D from './toast.js';
export { default as Toast, ToastProgrammatic } from './toast.js';
import Plugin$E from './tooltip.js';
export { default as Tooltip } from './tooltip.js';
import Plugin$F from './upload.js';
export { default as Upload } from './upload.js';
import ConfigComponent from './config.js';
export { default as ConfigProgrammatic } from './config.js';



var components = /*#__PURE__*/Object.freeze({
    Autocomplete: Plugin,
    Breadcrumb: Plugin$1,
    Button: Plugin$2,
    Carousel: Plugin$3,
    Checkbox: Plugin$4,
    Clockpicker: Plugin$5,
    Collapse: Plugin$6,
    Colorpicker: Plugin$7,
    Datepicker: Plugin$8,
    Datetimepicker: Plugin$9,
    Dialog: Plugin$a,
    Dropdown: Plugin$b,
    Field: Plugin$c,
    Icon: Plugin$d,
    Image: Plugin$e,
    Input: Plugin$f,
    Loading: Plugin$g,
    Menu: Plugin$h,
    Message: Plugin$i,
    Modal: Plugin$j,
    Navbar: Plugin$k,
    Notification: Plugin$l,
    Numberinput: Plugin$m,
    Pagination: Plugin$n,
    Progress: Plugin$o,
    Radio: Plugin$p,
    Rate: Plugin$q,
    Select: Plugin$r,
    Skeleton: Plugin$s,
    Sidebar: Plugin$t,
    Slider: Plugin$u,
    Snackbar: Plugin$v,
    Steps: Plugin$w,
    Switch: Plugin$x,
    Table: Plugin$y,
    Tabs: Plugin$z,
    Tag: Plugin$A,
    Taginput: Plugin$B,
    Timepicker: Plugin$C,
    Toast: Plugin$D,
    Tooltip: Plugin$E,
    Upload: Plugin$F
});

var Buefy = {
  install: function install(Vue) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    setVueInstance(Vue); // Options

    setOptions(merge(config, options, true)); // Components

    for (var componentKey in components) {
      Vue.use(components[componentKey]);
    } // Config component


    registerComponentProgrammatic(Vue, 'config', ConfigComponent);
    Vue.prototype.$buefy.globalNoticeInterval = null;
  }
};
use(Buefy);

export default Buefy;
