'use strict';

var helpers = require('./helpers.js');
var __chunk_2 = require('./chunk-1bb51959.js');

var FormElementMixin = {
  props: {
    size: String,
    expanded: Boolean,
    loading: Boolean,
    rounded: Boolean,
    icon: String,
    iconPack: String,
    // Native options to use in HTML5 validation
    autocomplete: String,
    maxlength: [Number, String],
    useHtml5Validation: {
      type: Boolean,
      default: function _default() {
        return __chunk_2.config.defaultUseHtml5Validation;
      }
    },
    validationMessage: String,
    locale: {
      type: [String, Array],
      default: function _default() {
        return __chunk_2.config.defaultLocale;
      }
    },
    statusIcon: {
      type: Boolean,
      default: function _default() {
        return __chunk_2.config.defaultStatusIcon;
      }
    }
  },
  data: function data() {
    return {
      isValid: true,
      isFocused: false,
      newIconPack: this.iconPack || __chunk_2.config.defaultIconPack
    };
  },
  computed: {
    /**
     * Find parent Field, max 3 levels deep.
     */
    parentField: function parentField() {
      var parent = this.$parent;

      for (var i = 0; i < 3; i++) {
        if (parent && !parent.$data._isField) {
          parent = parent.$parent;
        }
      }

      return parent;
    },

    /**
     * Get the type prop from parent if it's a Field.
     */
    statusType: function statusType() {
      var _ref = this.parentField || {},
          newType = _ref.newType;

      if (!newType) return;

      if (typeof newType === 'string') {
        return newType;
      } else {
        for (var key in newType) {
          if (newType[key]) {
            return key;
          }
        }
      }
    },

    /**
     * Get the message prop from parent if it's a Field.
     */
    statusMessage: function statusMessage() {
      if (!this.parentField) return;
      return this.parentField.newMessage || this.parentField.$slots.message;
    },

    /**
     * Fix icon size for inputs, large was too big
     */
    iconSize: function iconSize() {
      switch (this.size) {
        case 'is-small':
          return this.size;

        case 'is-medium':
          return;

        case 'is-large':
          return this.newIconPack === 'mdi' ? 'is-medium' : '';
      }
    }
  },
  methods: {
    /**
     * Focus method that work dynamically depending on the component.
     */
    focus: function focus() {
      var el = this.getElement();
      if (el === undefined) return;
      this.$nextTick(function () {
        if (el) el.focus();
      });
    },
    onBlur: function onBlur($event) {
      this.isFocused = false;
      this.$emit('blur', $event);
      this.checkHtml5Validity();
    },
    onFocus: function onFocus($event) {
      this.isFocused = true;
      this.$emit('focus', $event);
    },
    getElement: function getElement() {
      var el = this.$refs[this.$data._elementRef];

      while (helpers.isVueComponent(el)) {
        el = el.$refs[el.$data._elementRef];
      }

      return el;
    },
    setInvalid: function setInvalid() {
      var type = 'is-danger';
      var message = this.validationMessage || this.getElement().validationMessage;
      this.setValidity(type, message);
    },
    setValidity: function setValidity(type, message) {
      var _this = this;

      this.$nextTick(function () {
        if (_this.parentField) {
          // Set type only if not defined
          if (!_this.parentField.type) {
            _this.parentField.newType = type;
          } // Set message only if not defined


          if (!_this.parentField.message) {
            _this.parentField.newMessage = message;
          }
        }
      });
    },

    /**
     * Check HTML5 validation, set isValid property.
     * If validation fail, send 'is-danger' type,
     * and error message to parent if it's a Field.
     */
    checkHtml5Validity: function checkHtml5Validity() {
      if (!this.useHtml5Validation) return;
      var el = this.getElement();
      if (el === undefined) return;

      if (!el.checkValidity()) {
        this.setInvalid();
        this.isValid = false;
      } else {
        this.setValidity(null, null);
        this.isValid = true;
      }

      return this.isValid;
    }
  }
};

exports.FormElementMixin = FormElementMixin;
