'use strict';

var setImmediate   = global.setImmediate
var clearImmediate = global.clearImmediate

module.exports = function(fn, delay, scope){

    var timeoutId = -1

    return function(){

        var self = scope || this
        var args = arguments

        if (delay < 0){
            fn.apply(self, args)
            return
        }

        var withTimeout = delay || !setImmediate
        var clearFn = withTimeout?
                        clearTimeout:
                        clearImmediate
        var setFn   = withTimeout?
                        setTimeout:
                        setImmediate

        if (timeoutId !== -1){
            clearFn(timeoutId)
        }

        timeoutId = setFn(function(){
            fn.apply(self, args)
            self = null
        }, delay)
    }
}