# Bugsnag error reporter for JavaScript
![10.80kB](https://img.shields.io/badge/size-10.80kB-green.svg)
[![Documentation](https://img.shields.io/badge/docs-v4-green.svg)](https://docs.bugsnag.com/platforms/browsers/js)
[![Build status](https://travis-ci.org/bugsnag/bugsnag-js.svg?branch=master)](https://travis-ci.org/bugsnag/bugsnag-js)
[![BrowserStack Status](https://www.browserstack.com/automate/badge.svg?badge_key=VkNhNGlWRTV6c1Z1VXByYmxFTCtwbUd4M1p5cUI3KzFWRTJvaWk3WFZBTT0tLTBNZjFuM2ZJbW0vUDBPZ1pMQ3ZCd2c9PQ==--003c472323b43561f74fdbca9f732de0f609c74c)](https://www.browserstack.com/automate/public-build/VkNhNGlWRTV6c1Z1VXByYmxFTCtwbUd4M1p5cUI3KzFWRTJvaWk3WFZBTT0tLTBNZjFuM2ZJbW0vUDBPZ1pMQ3ZCd2c9PQ==--003c472323b43561f74fdbca9f732de0f609c74c)
[![NPM](https://img.shields.io/npm/v/bugsnag-js.svg)](https://npmjs.org/package/bugsnag-js)

[![NPM](https://nodei.co/npm/bugsnag-js.png?compact=true)](https://npmjs.org/package/bugsnag-js)

Automatically detect JavaScript errors on your website, get real-time error alerts and detailed diagnostic reports. Get cross-browser error detection and see errors grouped by browser, browser version, OS, and more. Learn more about [JavaScript error reporting](https://www.bugsnag.com/platforms/javascript/) from Bugsnag.

## Getting started

1. [Create a Bugsnag account](https://www.bugsnag.com)
2. Complete the instructions in the [integration guide](https://docs.bugsnag.com/platforms/browsers/)
3. Report handled exceptions using
   [`client.notify()`](https://docs.bugsnag.com/platforms/browsers/js/#reporting-handled-exceptions)
4. Customize your integration using the
   [configuration options](https://docs.bugsnag.com/platforms/browsers/js/configuration-options/)

## Integrating with frameworks

Use the following plugins and guides to integrate Bugsnag with various frameworks.

| Framework  | Bugsnag plugin | Documentation |
| ---------- | -------------- | --------------|
| React | [bugsnag-react](https://github.com/bugsnag/bugsnag-react)  | [React docs](https://docs.bugsnag.com/platforms/browsers/react/) |
| Vue | [bugsnag-vue](https://github.com/bugsnag/bugsnag-vue)  | [Vue docs](https://docs.bugsnag.com/platforms/browsers/vue/) |
| Angular | [bugsnag-angular](https://github.com/bugsnag/bugsnag-angular)  | [Angular docs](https://docs.bugsnag.com/platforms/browsers/angular/) |
| Backbone | - | [Backbone docs](https://docs.bugsnag.com/platforms/browsers/backbone/) |
| Ember | - | [Ember docs](https://docs.bugsnag.com/platforms/browsers/ember/) |

## Support

* Check out the [FAQ](https://docs.bugsnag.com/platforms/browsers/js/faq/) and [configuration options](https://docs.bugsnag.com/platforms/browsers/js/configuration-options/)
* [Search open and closed issues](https://github.com/bugsnag/bugsnag-js/issues?q=is%3Aissue) for similar problems
* [Report a bug or request a feature](https://github.com/bugsnag/bugsnag-js/issues/new)

## Contributing

All contributors are welcome! For information on how to build, test, and release
`bugsnag-js`, see our
[contributing guide](CONTRIBUTING.md).

## License

The Bugsnag JS library is free software released under the MIT License. See
[LICENSE.txt](LICENSE.txt) for
details.
