// bwip-js // Barcode Writer in Pure JavaScript
// https://github.com/metafloor/bwip-js
//
// This code was automatically generated from:
// Barcode Writer in Pure PostScript - Version 2024-06-18
//
// Copyright (c) 2011-2024 Mark Warren
// Copyright (c) 2004-2024 Terry Burton
//
// Licensed MIT. See the LICENSE file in the bwip-js root directory.
// bwip-js/barcode-hdr.js
//
// This code is injected above the cross-compiled barcode.js.

// The BWIPJS object (graphics interface)
var $$ = null;
var $j = 0; // stack pointer
var $k = []; // operand stack
var $_ = {}; // base of the dictionary stack

// Array ctor
//  $a()    : Build a new array up to the Infinity-marker on the stack.
//  $a(arr) : Convert native array to a "view" of the array.
//  $a(len) : Create a new array of length `len`
function $a(a) {
    if (!arguments.length) {
        for (var i = $j - 1; i >= 0 && $k[i] !== Infinity; i--);
        if (i < 0) {
            throw new Error('array-marker-not-found');
        }
        a = $k.splice(i + 1, $j - 1 - i);
        $j = i;
    } else if (!(a instanceof Array)) {
        a = new Array(+arguments[0]);
        for (var i = 0, l = a.length; i < l; i++) {
            a[i] = null;
        }
    }
    a.b = a; // base array
    a.o = 0; // offset into base
    return a;
}

// dict ctor
//  $d() : look for the Infinity marker on the stack
function $d() {
    // Build the dictionary in the order the keys/values were pushed so enumeration
    // occurs in the correct sequence.
    for (var mark = $j - 1; mark >= 0 && $k[mark] !== Infinity; mark -= 2) {
        if ($k[mark - 1] === Infinity) {
            throw new Error('dict-malformed-stack');
        }
    }
    if (mark < 0) {
        throw new Error('dict-marker-not-found');
    }
    var d = new Map;
    for (var i = mark + 1; i < $j; i += 2) {
        // Unlike javascript, postscript dict keys differentiate between
        // numbers and the string representation of a number.
        var k = $k[i]; // "key" into the dict entry
        var t = typeof k;
        if (t == 'number' || t == 'string') {
            d.set(k, $k[i + 1]);
        } else if (k instanceof Uint8Array) {
            d.set($z(k), $k[i + 1]);
        } else {
            throw new Error('dict-not-a-valid-key(' + k + ')');
        }
    }
    $j = mark;
    return d;
}

// string ctor
//  s(number)   : create zero-filled string of number-length
//  s(string)   : make a copy of the string
//  s(uint8[])  : make a copy of the string
//
// Returns a Uint8Array-string.
function $s(v) {
    var t = typeof v;
    if (t === 'number') {
        return new Uint8Array(v);
    }
    if (t !== 'string') {
        v = '' + v;
    }
    var s = new Uint8Array(v.length);
    for (var i = 0; i < v.length; i++) {
        s[i] = v.charCodeAt(i);
    }
    return s;
}

// ... n c roll
function $r(n, c) {
    if ($j < n) {
        throw new Error('roll: --stack-underflow--');
    }
    if (!c) {
        return;
    }
    if (c < 0) {
        var t = $k.splice($j - n, -c);
    } else {
        var t = $k.splice($j - n, n - c);
    }
    $k.splice.apply($k, [$j - t.length, 0].concat(t));
}

// Primarily designed to convert uint8-string to string, but will call the
// the toString() method on any value.
function $z(s) {
    if (s instanceof Uint8Array) {
        return String.fromCharCode.apply(null, s);
    }
    return '' + s;
}

// Copies source to dest and returns a view of just the copied characters
function $strcpy(dst, src) {
    if (typeof dst === 'string') {
        dst = $s(dst);
    }
    if (src instanceof Uint8Array) {
        for (var i = 0, l = src.length; i < l; i++) {
            dst[i] = src[i];
        }
    } else {
        for (var i = 0, l = src.length; i < l; i++) {
            dst[i] = src.charCodeAt(i);
        }
    }
    return src.length < dst.length ? dst.subarray(0, src.length) : dst;
}

// Copies source to dest and should (but doesn't) return a view of just the copied elements
function $arrcpy(dst, src) {
    for (var i = 0, l = src.length; i < l; i++) {
        dst[i] = src[i];
    }
    dst.length = src.length;
    return dst;
}

// cvs operator - convert a value to its string representation
//  s : string to store into
//  v : any value
function $cvs(s, v) {
    var t = typeof v;
    if (t == 'number' || t == 'boolean' || v === null) {
        v = '' + v;
    } else if (t !== 'string') {
        v = '--nostringval--';
    }
    for (var i = 0, l = v.length; i < l; i++) {
        s[i] = v.charCodeAt(i);
    }
    $k[$j++] = i < s.length ? s.subarray(0, i) : s;
}
// cvi operator - converts a numeric string value to integer.
function $cvi(s) {
    if (s instanceof Uint8Array) {
        // nul-chars on the end of a string are ignored by postscript but cause javascript
        // to return a zero result.
        return String.fromCharCode.apply(null, s).replace(/\0+$/, '') | 0;
    }
    return ('' + s) | 0;
}

// cvrs operator - convert a number to a radix string
//  s : string to store into
//  n : number
//  r : radix
function $cvrs(s, n, r) {
    return $strcpy(s, (~~n).toString(r).toUpperCase());
}

// cvx - convert to executable.
// This is only used by BWIPP to convert <XX> string literals.
function $cvx(s) {
    s = $z(s)
    var m = /^\s*<((?:[0-9a-fA-F]{2})+)>\s*$/.exec(s);
    if (!m) {
        throw new Error('cvx: not a <HH> hex string literal');
    }
    var h = m[1];
    var l = h.length >> 1;
    var u = new Uint8Array(l);
    for (var i = 0, j = 0; i < l; i++) {
        var c0 = h.charCodeAt(j++);
        var c1 = h.charCodeAt(j++);
        u[i] = ((c0 < 58 ? c0 - 48 : (c0 & 15) + 9) << 4) +
            (c1 < 58 ? c1 - 48 : (c1 & 15) + 9);
    }
    return u;
}

// get operator
//  s : source
//  k : key
function $get(s, k) {
    if (s instanceof Uint8Array) {
        return s[k];
    }
    if (typeof s === 'string') {
        return s.charCodeAt(k);
    }
    if (s instanceof Array) {
        return s.b[s.o + k];
    }
    if (k instanceof Uint8Array) {
        return s.get($z(k));
    }
    return s.get(k);
}

// put operator
//  d : dest
//  k : key
//  v : value
function $put(d, k, v) {
    if (d instanceof Uint8Array) {
        d[k] = v;
    } else if (d instanceof Array) {
        d.b[d.o + k] = v;
    } else if (typeof d == 'object') {
        if (k instanceof Uint8Array) {
            d.set($z(k), v);
        } else {
            d.set(k, v);
        }
    } else {
        throw new Error('put-not-writable-' + (typeof d));
    }
}

// getinterval operator
//  s : src
//  o : offset
//  l : length
function $geti(s, o, l) {
    if (s instanceof Uint8Array) {
        return s.subarray(o, o + l);
    }
    if (s instanceof Array) {
        var a = new Array(l);
        a.b = s.b; // base array
        a.o = s.o + o; // offset into base
        return a;
    }
    // Must be a string
    return s.substr(o, l);
}

// putinterval operator
//  d : dst
//  o : offset
//  s : src
function $puti(d, o, s) {
    if (d instanceof Uint8Array) {
        if (typeof s == 'string') {
            for (var i = 0, l = s.length; i < l; i++) {
                d[o + i] = s.charCodeAt(i);
            }
        } else {
            // When both d and s are the same, we want to copy
            // backwards, which works for the general case as well.
            for (var i = s.length - 1; i >= 0; i--) {
                d[o + i] = s[i];
            }
        }
    } else if (d instanceof Array) {
        // Operate on the base arrays
        var darr = d.b;
        var doff = o + d.o;
        var sarr = s.b;
        var soff = s.o;

        for (var i = 0, l = s.length; i < l; i++) {
            darr[doff + i] = sarr[soff + i];
        }
    } else {
        throw new Error('putinterval-not-writable-' + (typeof d));
    }
}

// type operator
function $type(v) {
    // null can be mis-typed - get it out of the way
    if (v == null) {
        return 'nulltype';
    }
    var t = typeof v;
    if (t == 'number') {
        return v % 1 ? 'realtype' : 'integertype';
    }
    if (t == 'boolean') {
        return 'booleantype';
    }
    if (t == 'string' || v instanceof Uint8Array) {
        return 'stringtype';
    }
    if (t == 'function') {
        return 'operatortype';
    }
    if (v instanceof Array) {
        return 'arraytype';
    }
    return 'dicttype';
    // filetype
    // fonttype
    // gstatetype
    // marktype (v === Infinity)
    // nametype
    // savetype
}

// anchorsearch operator
//      string seek anchorsearch suffix seek true %if-found
//                               string false     %if-not-found
function $anchorsearch(str, seek) {
    if (!(str instanceof Uint8Array)) {
        str = $s(str);
    }
    var i = 0,
        ls = str.length,
        lk = seek.length;

    // Optimize for single characters.
    if (lk == 1) {
        var cd = seek instanceof Uint8Array ? seek[0] : seek.charCodeAt(0);
        i = str[0] == cd ? 1 : ls;
    } else if (seek.length <= ls) {
        // Slow path,
        if (!(seek instanceof Uint8Array)) {
            seek = $s(seek);
        }
        for (; i < lk && str[i] == seek[i]; i++);
    }
    if (i == lk) {
        $k[$j++] = str.subarray(lk);
        $k[$j++] = str.subarray(0, lk);
        $k[$j++] = true;
    } else {
        $k[$j++] = str;
        $k[$j++] = false;
    }
}

// search operator
//      string seek search suffix match prefix true %if-found
//                         string false             %if-not-found
function $search(str, seek) {
    if (!(str instanceof Uint8Array)) {
        str = $s(str);
    }
    var ls = str.length;

    // Virtually all uses of search in BWIPP are for single-characters.
    // Optimize for that case.
    if (seek.length == 1) {
        var lk = 1;
        var cd = seek instanceof Uint8Array ? seek[0] : seek.charCodeAt(0);
        for (var i = 0; i < ls && str[i] != cd; i++);
    } else {
        // Slow path,
        if (!(seek instanceof Uint8Array)) {
            seek = $s(seek);
        }
        var lk = seek.length;
        var cd = seek[0];
        for (var i = 0; i < ls && str[i] != cd; i++);
        while (i < ls) {
            for (var j = 1; j < lk && str[i + j] === seek[j]; j++);
            if (j === lk) {
                break;
            }
            for (i++; i < ls && str[i] != cd; i++);
        }
    }
    if (i < ls) {
        $k[$j++] = str.subarray(i + lk);
        $k[$j++] = str.subarray(i, i + lk);
        $k[$j++] = str.subarray(0, i);
        $k[$j++] = true;
    } else {
        $k[$j++] = str;
        $k[$j++] = false;
    }
}

// The callback is omitted when forall is being used just to push onto the
// stack.  The callback normally returns undefined.  A return of true means break.
function $forall(o, cb) {
    if (o instanceof Uint8Array) {
        for (var i = 0, l = o.length; i < l; i++) {
            $k[$j++] = o[i];
            if (cb && cb()) break;
        }
    } else if (o instanceof Array) {
        // The array may be a view.
        for (var a = o.b, i = o.o, l = o.o + o.length; i < l; i++) {
            $k[$j++] = a[i];
            if (cb && cb()) break;
        }
    } else if (typeof o === 'string') {
        for (var i = 0, l = o.length; i < l; i++) {
            $k[$j++] = o.charCodeAt(i);
            if (cb && cb()) break;
        }
    } else if (o instanceof Map) {
        for (var keys = o.keys(), i = 0, l = o.size; i < l; i++) {
            var id = keys.next().value;
            $k[$j++] = id;
            $k[$j++] = o.get(id);
            if (cb && cb()) break;
        }
    } else {
        for (var id in o) {
            $k[$j++] = id;
            $k[$j++] = o[id];
            if (cb && cb()) break;
        }
    }
}

function $cleartomark() {
    while ($j > 0 && $k[--$j] !== Infinity);
}

function $counttomark() {
    for (var i = $j - 1; i >= 0 && $k[i] !== Infinity; i--);
    return $j - i - 1;
}

function $aload(a) {
    for (var i = 0, l = a.length, b = a.b, o = a.o; i < l; i++) {
        $k[$j++] = b[o + i];
    }
    // This push has been optimized out.  See $.aload() in psc.js.
    //$k[$j++] = a;
}

function $astore(a) {
    for (var i = 0, l = a.length, b = a.b, o = a.o + l - 1; i < l; i++) {
        b[o - i] = $k[--$j];
    }
    $k[$j++] = a;
}

function $eq(a, b) {
    if (typeof a === 'string' && typeof b === 'string') {
        return a == b;
    }
    if (a instanceof Uint8Array && b instanceof Uint8Array) {
        if (a.length != b.length) {
            return false;
        }
        for (var i = 0, l = a.length; i < l; i++) {
            if (a[i] != b[i]) {
                return false;
            }
        }
        return true;
    }
    if (a instanceof Uint8Array && typeof b === 'string' ||
        b instanceof Uint8Array && typeof a === 'string') {
        if (a instanceof Uint8Array) {
            a = $z(a);
        } else {
            b = $z(b);
        }
        return a == b;
    }
    return a == b;
}

function $ne(a, b) {
    return !$eq(a, b);
}

function $lt(a, b) {
    if (a instanceof Uint8Array) {
        a = $z(a);
    }
    if (b instanceof Uint8Array) {
        b = $z(b);
    }
    return a < b;
}

function $le(a, b) {
    if (a instanceof Uint8Array) {
        a = $z(a);
    }
    if (b instanceof Uint8Array) {
        b = $z(b);
    }
    return a <= b;
}

function $gt(a, b) {
    if (a instanceof Uint8Array) {
        a = $z(a);
    }
    if (b instanceof Uint8Array) {
        b = $z(b);
    }
    return a > b;
}

function $ge(a, b) {
    if (a instanceof Uint8Array) {
        a = $z(a);
    }
    if (b instanceof Uint8Array) {
        b = $z(b);
    }
    return a >= b;
}

function $an(a, b) { // and
    return (typeof a === 'boolean') ? a && b : a & b;
}

function $or(a, b) { // or
    return (typeof a === 'boolean') ? a || b : a | b;
}

function $xo(a, b) { // xor
    return (typeof a === 'boolean') ? !a && b || a && !b : a ^ b;
}

function $nt(a) {
    return typeof a == 'boolean' ? !a : ~a;
}
// emulate single-precision floating-point (pseudo-polyfill for Math.fround)
var $f = (function(fa) {
    return function(v) {
        return Number.isInteger(v) ? v : (fa[0] = v, fa[0]);
    };
})(new Float32Array(1));

// This is a replacement for the BWIPP raiseerror function.
function bwipp_raiseerror() {
    var info = $k[--$j];
    var name = $k[--$j];
    throw new Error($z(name) + ": " + $z(info));
}

// This is a replacement for the BWIPP processoptions function.
// We cannot use the BWIPP version due to two reasons:
// - legacy code allows strings to be numbers and numbers to be strings
// - in javascript, there is no way to tell the difference between a real
//   number that is an integer, and an actual integer.
//
// options currentdict processoptions exec -> options
function bwipp_processoptions() {
    var dict = $k[--$j];
    var opts = $k[$j - 1];
    var map = opts instanceof Map;
    for (var id in dict) {
        var val;
        if (map) {
            if (!opts.has(id)) {
                continue;
            }
            val = opts.get(id);
        } else {
            if (!opts.hasOwnProperty(id)) {
                continue;
            }
            val = opts[id];
        }
        var def = dict[id];
        var typ = typeof def;

        // null is a placeholder for realtype
        if (def == null || typ == 'number') {
            // This allows for numeric strings
            if (!isFinite(+val)) {
                throw new Error('bwipp.invalidOptionType: ' + id +
                    ': not a realtype: ' + val);
            }
            if (typeof val == 'string') {
                val = +val;
                map ? opts.set(id, val) : (opts[id] = val);
            }
        } else if (typ == 'boolean') {
            if (val !== true && val !== false) {
                // In keeping with the ethos of javascript, allow a more relaxed
                // interpretation of boolean.
                if (val == null || (val | 0) === val) {
                    val = !!val;
                } else if (val == 'true') {
                    val = true;
                } else if (val == 'false') {
                    val = false;
                } else {
                    throw new Error('bwipp.invalidOptionType: ' + id +
                        ': not a booleantype: ' + val);
                }
                map ? opts.set(id, val) : (opts[id] = val);
            }
        } else if (typ == 'string' || def instanceof Uint8Array) {
            // This allows numbers to be strings
            if (typeof val == 'number') {
                val = '' + val;
                map ? opts.set(id, val) : (opts[id] = val);
            } else if (typeof val != 'string' && !(val instanceof Uint8Array)) {
                throw new Error('bwipp.invalidOptionType: ' + id +
                    ': not a stringtype: ' + val);
            }
        }
        // Set the option into the dictionary
        dict[id] = val;
    }
}

// Replacement for loadctx which contains complex postscript operations
// that we don't implement correctly.
// f is a reference to the enclosing function.
function bwipp_loadctx(f) {
    if (!f.$ctx) {
        f.$ctx = {};
    }
    var next = Object.getPrototypeOf($_);
    Object.setPrototypeOf(f.$ctx, next);
    Object.setPrototypeOf($_, f.$ctx);
}

function bwipp_parseinput() {
    $_ = Object.create($_); //#200
    bwipp_loadctx(bwipp_parseinput) //#202
    $_.fncvals = $k[--$j]; //#204
    $_.barcode = $k[--$j]; //#205
    var _2 = 'parse'; //#207
    $_[_2] = $get($_.fncvals, _2); //#207
    delete $_.fncvals[_2]; //#207
    var _6 = 'parsefnc'; //#208
    $_[_6] = $get($_.fncvals, _6); //#208
    delete $_.fncvals[_6]; //#208
    var _A = 'parseonly'; //#209
    var _C = $get($_.fncvals, _A) !== undefined; //#209
    $_[_A] = _C; //#209
    delete $_.fncvals[_A]; //#209
    var _E = 'eci'; //#210
    var _G = $get($_.fncvals, _E) !== undefined; //#210
    $_[_E] = _G; //#210
    delete $_.fncvals[_E]; //#210
    if (!bwipp_parseinput.__225__) { //#225
        $_ = Object.create($_); //#225
        $k[$j++] = Infinity; //#214
        var _I = $a(['NUL', 'SOH', 'STX', 'ETX', 'EOT', 'ENQ', 'ACK', 'BEL', 'BS', 'TAB', 'LF', 'VT', 'FF', 'CR', "", "", 'DLE', 'DC1', 'DC2', 'DC3', 'DC4', 'NAK', 'SYN', 'ETB', 'CAN', 'EM', 'SUB', 'ESC', 'FS', 'GS', 'RS', 'US']); //#219
        $k[$j++] = 0; //#223
        for (var _J = 0, _K = _I.length; _J < _K; _J++) { //#223
            var _M = $k[--$j]; //#222
            $k[$j++] = $get(_I, _J); //#222
            $k[$j++] = _M; //#222
            $k[$j++] = $f(_M + 1); //#222
        } //#222
        $j--; //#223
        $_.ctrl = $d(); //#224
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_parseinput.$ctx[id] = $_[id]); //#224
        bwipp_parseinput.__225__ = 1; //#224
        $_ = Object.getPrototypeOf($_); //#224
    } //#224
    $_.msg = $a($_.barcode.length); //#227
    $_.j = 0; //#228
    $k[$j++] = $_.barcode; //#347
    for (;;) { //#347
        $search($k[--$j], "^"); //#230
        var _T = $k[--$j]; //#230
        var _U = $k[--$j]; //#230
        $k[$j++] = _T; //#233
        $k[$j++] = _U.length; //#233
        $k[$j++] = $_.msg; //#233
        $k[$j++] = $_.j; //#233
        $k[$j++] = _U; //#233
        $k[$j++] = Infinity; //#233
        var _X = $k[--$j]; //#233
        var _Y = $k[--$j]; //#233
        $k[$j++] = _X; //#233
        $forall(_Y); //#233
        var _Z = $a(); //#233
        var _a = $k[--$j]; //#233
        $puti($k[--$j], _a, _Z); //#233
        $_.j = $f($k[--$j] + $_.j); //#234
        if ($k[--$j]) { //#345
            $j--; //#236
            for (var _f = 0, _g = 1; _f < _g; _f++) { //#343
                if ($an($nt($_.parse), $nt($_.parsefnc))) { //#243
                    $put($_.msg, $_.j, 94); //#240
                    $_.j = $f($_.j + 1); //#241
                    break; //#242
                } //#242
                $put($_.msg, $_.j, 94); //#246
                $_.j = $f($_.j + 1); //#247
                if ($_.parse) { //#290
                    var _q = $k[--$j]; //#251
                    $k[$j++] = _q; //#262
                    if (_q.length >= 3) { //#262
                        var _r = $k[--$j]; //#252
                        var _s = $geti(_r, 0, 3); //#252
                        var _t = $_.ctrl; //#252
                        var _u = $get(_t, _s) !== undefined; //#253
                        $k[$j++] = _r; //#261
                        $k[$j++] = _t; //#261
                        $k[$j++] = _s; //#261
                        if (_u) { //#260
                            $_.j = $f($_.j - 1); //#254
                            var _w = $k[--$j]; //#255
                            $put($_.msg, $_.j, $get($k[--$j], _w)); //#255
                            $_.j = $f($_.j + 1); //#256
                            var _12 = $k[--$j]; //#257
                            $k[$j++] = $geti(_12, 3, _12.length - 3); //#258
                            break; //#258
                        } else { //#260
                            $j -= 2; //#260
                        } //#260
                    } //#260
                    var _14 = $k[--$j]; //#263
                    $k[$j++] = _14; //#274
                    if (_14.length >= 2) { //#274
                        var _15 = $k[--$j]; //#264
                        var _16 = $geti(_15, 0, 2); //#264
                        var _17 = $_.ctrl; //#264
                        var _18 = $get(_17, _16) !== undefined; //#265
                        $k[$j++] = _15; //#273
                        $k[$j++] = _17; //#273
                        $k[$j++] = _16; //#273
                        if (_18) { //#272
                            $_.j = $f($_.j - 1); //#266
                            var _1A = $k[--$j]; //#267
                            $put($_.msg, $_.j, $get($k[--$j], _1A)); //#267
                            $_.j = $f($_.j + 1); //#268
                            var _1G = $k[--$j]; //#269
                            $k[$j++] = $geti(_1G, 2, _1G.length - 2); //#270
                            break; //#270
                        } else { //#272
                            $j -= 2; //#272
                        } //#272
                    } //#272
                    var _1I = $k[--$j]; //#275
                    $k[$j++] = _1I; //#289
                    if (_1I.length >= 3) { //#289
                        var _1J = $k[--$j]; //#276
                        var _1K = $geti(_1J, 0, 3); //#276
                        $k[$j++] = _1J; //#278
                        $k[$j++] = true; //#278
                        for (var _1L = 0, _1M = _1K.length; _1L < _1M; _1L++) { //#278
                            var _1N = $get(_1K, _1L); //#278
                            if ((_1N < 48) || (_1N > 57)) { //#277
                                $j--; //#277
                                $k[$j++] = false; //#277
                            } //#277
                        } //#277
                        if ($k[--$j]) { //#288
                            var _1P = $k[--$j]; //#280
                            var _1R = $cvi($geti(_1P, 0, 3)); //#280
                            $k[$j++] = _1P; //#283
                            $k[$j++] = _1R; //#283
                            if (_1R > 255) { //#283
                                $j -= 2; //#281
                                $k[$j++] = 'bwipp.invalidOrdinal#282'; //#282
                                $k[$j++] = "Ordinal must be 000 to 255"; //#282
                                bwipp_raiseerror(); //#282
                            } //#282
                            $_.j = $f($_.j - 1); //#284
                            $put($_.msg, $_.j, $k[--$j]); //#285
                            $_.j = $f($_.j + 1); //#286
                            var _1X = $k[--$j]; //#287
                            $k[$j++] = $geti(_1X, 3, _1X.length - 3); //#287
                        } //#287
                    } //#287
                } //#287
                if (($or($_.parseonly, $nt($_.parsefnc))) || ($get($_.msg, $f($_.j - 1)) != 94)) { //#295
                    break; //#295
                } //#295
                $_.j = $f($_.j - 1); //#298
                var _1f = $k[--$j]; //#299
                $k[$j++] = _1f; //#302
                if (_1f.length < 3) { //#302
                    $j--; //#300
                    $k[$j++] = 'bwipp.truncatedFNC#301'; //#301
                    $k[$j++] = "Function character truncated"; //#301
                    bwipp_raiseerror(); //#301
                } //#301
                var _1g = $k[--$j]; //#303
                $k[$j++] = _1g; //#308
                if ($get(_1g, 0) == 94) { //#308
                    $put($_.msg, $_.j, 94); //#304
                    $_.j = $f($_.j + 1); //#305
                    var _1l = $k[--$j]; //#306
                    $k[$j++] = $geti(_1l, 1, _1l.length - 1); //#307
                    break; //#307
                } //#307
                var _1n = $k[--$j]; //#309
                $k[$j++] = _1n; //#326
                if ($eq($geti(_1n, 0, 3), "ECI") && $_.eci) { //#326
                    var _1q = $k[--$j]; //#310
                    $k[$j++] = _1q; //#313
                    if (_1q.length < 9) { //#313
                        $j--; //#311
                        $k[$j++] = 'bwipp.truncatedECI#312'; //#312
                        $k[$j++] = "ECI truncated"; //#312
                        bwipp_raiseerror(); //#312
                    } //#312
                    var _1r = $k[--$j]; //#314
                    var _1s = $geti(_1r, 3, 6); //#314
                    $k[$j++] = _1r; //#320
                    $k[$j++] = _1s; //#320
                    for (var _1t = 0, _1u = _1s.length; _1t < _1u; _1t++) { //#320
                        var _1v = $get(_1s, _1t); //#320
                        if ((_1v < 48) || (_1v > 57)) { //#319
                            $j -= 2; //#317
                            $k[$j++] = 'bwipp.invalidECI#318'; //#318
                            $k[$j++] = "ECI must be 000000 to 999999"; //#318
                            bwipp_raiseerror(); //#318
                        } //#318
                    } //#318
                    var _1w = $k[--$j]; //#321
                    $k[$j++] = 0; //#321
                    $forall(_1w, function() { //#321
                        var _1x = $k[--$j]; //#321
                        var _1y = $k[--$j]; //#321
                        $k[$j++] = ($f(_1y - $f(_1x - 48))) * 10; //#321
                    }); //#321
                    $put($_.msg, $_.j, (~~($k[--$j] / 10)) - 1000000); //#322
                    $_.j = $f($_.j + 1); //#323
                    var _23 = $k[--$j]; //#324
                    $k[$j++] = $geti(_23, 9, _23.length - 9); //#325
                    break; //#325
                } //#325
                var _25 = $k[--$j]; //#327
                $k[$j++] = _25; //#330
                if (_25.length < 4) { //#330
                    $j--; //#328
                    $k[$j++] = 'bwipp.truncatedFNC#329'; //#329
                    $k[$j++] = "Function character truncated"; //#329
                    bwipp_raiseerror(); //#329
                } //#329
                var _26 = $k[--$j]; //#331
                var _27 = $geti(_26, 0, 4); //#331
                var _29 = $get($_.fncvals, _27) !== undefined; //#331
                $k[$j++] = _26; //#336
                $k[$j++] = _27; //#336
                if (!_29) { //#336
                    var _2A = $k[--$j]; //#332
                    var _2B = $s(_2A.length + 28); //#332
                    $puti(_2B, 28, _2A); //#332
                    $puti(_2B, 0, "Unknown function character: "); //#333
                    var _2C = $k[--$j]; //#334
                    $k[$j++] = _2B; //#334
                    $k[$j++] = _2C; //#334
                    $j--; //#334
                    var _2D = $k[--$j]; //#335
                    $k[$j++] = 'bwipp.unknownFNC#335'; //#335
                    $k[$j++] = _2D; //#335
                    bwipp_raiseerror(); //#335
                } //#335
                $put($_.msg, $_.j, $get($_.fncvals, $k[--$j])); //#338
                $_.j = $f($_.j + 1); //#339
                var _2K = $k[--$j]; //#340
                $k[$j++] = $geti(_2K, 4, _2K.length - 4); //#341
                break; //#341
            } //#341
        } else { //#345
            break; //#345
        } //#345
    } //#345
    if ($nt($_.parseonly)) { //#353
        $k[$j++] = $geti($_.msg, 0, $_.j); //#350
    } else { //#353
        $k[$j++] = $s($_.j); //#353
        for (var _2U = 0, _2T = $f($_.j - 1); _2U <= _2T; _2U += 1) { //#353
            var _2V = $k[--$j]; //#353
            $put(_2V, _2U, $get($_.msg, _2U)); //#353
            $k[$j++] = _2V; //#353
        } //#353
    } //#353
    $_ = Object.getPrototypeOf($_); //#356
    $_ = Object.getPrototypeOf($_); //#358
} //bwipp_parseinput
function bwipp_gs1process() {
    $_ = Object.create($_); //#383
    bwipp_loadctx(bwipp_gs1process) //#385
    if (!bwipp_gs1process.__2469__) { //#2469
        $_ = Object.create($_); //#2469
        var _1 = new Map([
            ["cset", 'N'],
            ["min", 18],
            ["max", 18],
            ["opt", false],
            ["linters", $a(['lintcsum', 'lintkey'])]
        ]); //#393
        var _2 = $a([_1]); //#393
        var _3 = $a([]); //#395
        var _4 = new Map([
            ["parts", _2],
            ["dlpkey", _3]
        ]); //#395
        var _5 = $a(['lintcsum', 'lintkey']); //#402
        var _6 = new Map([
            ["cset", 'N'],
            ["min", 14],
            ["max", 14],
            ["opt", false],
            ["linters", _5]
        ]); //#402
        var _7 = $a([_6]); //#402
        var _8 = $a(["255", "37"]); //#404
        var _9 = $a(["22", "10", "21"]); //#405
        var _A = $a(["235"]); //#405
        var _B = $a([_9, _A]); //#405
        var _C = new Map([
            ["parts", _7],
            ["ex", _8],
            ["dlpkey", _B]
        ]); //#405
        var _D = $a(['lintcsum', 'lintkey']); //#412
        var _E = new Map([
            ["cset", 'N'],
            ["min", 14],
            ["max", 14],
            ["opt", false],
            ["linters", _D]
        ]); //#412
        var _F = $a([_E]); //#412
        var _G = $a(["01", "03"]); //#414
        var _H = $a(["37"]); //#415
        var _I = $a([_H]); //#415
        var _J = $a([_I]); //#415
        var _K = new Map([
            ["parts", _F],
            ["ex", _G],
            ["req", _J]
        ]); //#415
        var _L = $a(['lintcsum', 'lintkey']); //#422
        var _M = new Map([
            ["cset", 'N'],
            ["min", 14],
            ["max", 14],
            ["opt", false],
            ["linters", _L]
        ]); //#422
        var _N = $a([_M]); //#422
        var _P = new Map([
            ["parts", _N],
            ["ex", $a(["01", "02", "37"])],
            ["dlattr", false]
        ]); //#425
        var _R = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 20],
            ["opt", false],
            ["linters", $a([])]
        ]); //#432
        var _a = new Map([
            ["parts", $a([_R])],
            ["req", $a([$a([$a(["01"]), $a(["02"]), $a(["03"]), $a(["8006"]), $a(["8026"])])])]
        ]); //#434
        var _c = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a(['lintyymmd0'])]
        ]); //#441
        var _k = new Map([
            ["parts", $a([_c])],
            ["req", $a([$a([$a(["01"]), $a(["02"]), $a(["8006"]), $a(["8026"])])])]
        ]); //#443
        var _m = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a(['lintyymmd0'])]
        ]); //#450
        var _r = new Map([
            ["parts", $a([_m])],
            ["req", $a([$a([$a(["8020"])])])]
        ]); //#452
        var _t = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a(['lintyymmd0'])]
        ]); //#459
        var _11 = new Map([
            ["parts", $a([_t])],
            ["req", $a([$a([$a(["01"]), $a(["02"]), $a(["8006"]), $a(["8026"])])])]
        ]); //#461
        var _13 = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a(['lintyymmd0'])]
        ]); //#470
        var _1C = new Map([
            ["parts", $a([_13])],
            ["req", $a([$a([$a(["01"]), $a(["02"]), $a(["255"]), $a(["8006"]), $a(["8026"])])])]
        ]); //#472
        var _1E = new Map([
            ["cset", 'N'],
            ["min", 2],
            ["max", 2],
            ["opt", false],
            ["linters", $a([])]
        ]); //#479
        var _1M = new Map([
            ["parts", $a([_1E])],
            ["req", $a([$a([$a(["01"]), $a(["02"]), $a(["8006"]), $a(["8026"])])])]
        ]); //#481
        var _1O = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 20],
            ["opt", false],
            ["linters", $a([])]
        ]); //#488
        var _1W = new Map([
            ["parts", $a([_1O])],
            ["ex", $a(["235"])],
            ["req", $a([$a([$a(["01"]), $a(["03"]), $a(["8006"])])])],
            ["dlattr", false]
        ]); //#492
        var _1Y = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 20],
            ["opt", false],
            ["linters", $a([])]
        ]); //#499
        var _1d = new Map([
            ["parts", $a([_1Y])],
            ["req", $a([$a([$a(["01"])])])],
            ["dlattr", false]
        ]); //#502
        var _1f = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 28],
            ["opt", false],
            ["linters", $a([])]
        ]); //#509
        var _1k = new Map([
            ["parts", $a([_1f])],
            ["req", $a([$a([$a(["01"])])])],
            ["dlattr", false]
        ]); //#512
        var _1m = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 30],
            ["opt", false],
            ["linters", $a([])]
        ]); //#519
        var _1u = new Map([
            ["parts", $a([_1m])],
            ["req", $a([$a([$a(["01"]), $a(["02"]), $a(["8006"]), $a(["8026"])])])]
        ]); //#521
        var _1w = new Map([
            ["cset", 'N'],
            ["min", 1],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#529
        var _24 = $a([$a([$a(["01"]), $a(["02"]), $a(["03"]), $a(["8006"]), $a(["8026"])])]); //#531
        var _25 = new Map([
            ["parts", $a([_1w])],
            ["req", _24]
        ]); //#531
        var _27 = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 20],
            ["opt", false],
            ["linters", $a([])]
        ]); //#538
        var _2C = new Map([
            ["parts", $a([_27])],
            ["req", $a([$a([$a(["01"])])])]
        ]); //#540
        var _2E = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 30],
            ["opt", false],
            ["linters", $a([])]
        ]); //#547
        var _2M = new Map([
            ["parts", $a([_2E])],
            ["req", $a([$a([$a(["01"]), $a(["8006"])]), $a([$a(["21"])])])]
        ]); //#549
        var _2O = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 30],
            ["opt", false],
            ["linters", $a([])]
        ]); //#556
        var _2U = new Map([
            ["parts", $a([_2O])],
            ["req", $a([$a([$a(["01"]), $a(["8006"])])])]
        ]); //#558
        var _2W = new Map([
            ["cset", 'N'],
            ["min", 13],
            ["max", 13],
            ["opt", false],
            ["linters", $a(['lintcsum', 'lintkey'])]
        ]); //#565
        var _2Y = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 17],
            ["opt", true],
            ["linters", $a([])]
        ]); //#566
        var _2b = new Map([
            ["parts", $a([_2W, _2Y])],
            ["dlpkey", $a([])]
        ]); //#568
        var _2d = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 20],
            ["opt", false],
            ["linters", $a([])]
        ]); //#575
        var _2i = new Map([
            ["parts", $a([_2d])],
            ["req", $a([$a([$a(["414"])])])],
            ["dlattr", false]
        ]); //#578
        var _2k = new Map([
            ["cset", 'N'],
            ["min", 13],
            ["max", 13],
            ["opt", false],
            ["linters", $a(['lintcsum', 'lintkey'])]
        ]); //#585
        var _2m = new Map([
            ["cset", 'N'],
            ["min", 1],
            ["max", 12],
            ["opt", true],
            ["linters", $a([])]
        ]); //#586
        var _2q = new Map([
            ["parts", $a([_2k, _2m])],
            ["ex", $a(["01", "02", "415", "8006", "8020", "8026"])],
            ["dlpkey", $a([])]
        ]); //#589
        var _2s = new Map([
            ["cset", 'N'],
            ["min", 1],
            ["max", 8],
            ["opt", false],
            ["linters", $a([])]
        ]); //#596
        var _2y = new Map([
            ["parts", $a([_2s])],
            ["req", $a([$a([$a(["01"]), $a(["02"])])])]
        ]); //#598
        var _30 = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#605
        var _37 = new Map([
            ["parts", $a([_30])],
            ["ex", $a(["310n"])],
            ["req", $a([$a([$a(["01"]), $a(["02"])])])]
        ]); //#608
        var _39 = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#620
        var _3G = new Map([
            ["parts", $a([_39])],
            ["ex", $a(["311n"])],
            ["req", $a([$a([$a(["01"]), $a(["02"])])])]
        ]); //#623
        var _3I = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#635
        var _3P = new Map([
            ["parts", $a([_3I])],
            ["ex", $a(["312n"])],
            ["req", $a([$a([$a(["01"]), $a(["02"])])])]
        ]); //#638
        var _3R = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#650
        var _3Y = new Map([
            ["parts", $a([_3R])],
            ["ex", $a(["313n"])],
            ["req", $a([$a([$a(["01"]), $a(["02"])])])]
        ]); //#653
        var _3a = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#665
        var _3h = new Map([
            ["parts", $a([_3a])],
            ["ex", $a(["314n"])],
            ["req", $a([$a([$a(["01"]), $a(["02"])])])]
        ]); //#668
        var _3j = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#680
        var _3q = new Map([
            ["parts", $a([_3j])],
            ["ex", $a(["315n"])],
            ["req", $a([$a([$a(["01"]), $a(["02"])])])]
        ]); //#683
        var _3s = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#695
        var _3z = new Map([
            ["parts", $a([_3s])],
            ["ex", $a(["316n"])],
            ["req", $a([$a([$a(["01"]), $a(["02"])])])]
        ]); //#698
        var _41 = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#710
        var _48 = new Map([
            ["parts", $a([_41])],
            ["ex", $a(["320n"])],
            ["req", $a([$a([$a(["01"]), $a(["02"])])])]
        ]); //#713
        var _4A = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#725
        var _4H = new Map([
            ["parts", $a([_4A])],
            ["ex", $a(["321n"])],
            ["req", $a([$a([$a(["01"]), $a(["02"])])])]
        ]); //#728
        var _4J = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#740
        var _4Q = new Map([
            ["parts", $a([_4J])],
            ["ex", $a(["322n"])],
            ["req", $a([$a([$a(["01"]), $a(["02"])])])]
        ]); //#743
        var _4S = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#755
        var _4Z = new Map([
            ["parts", $a([_4S])],
            ["ex", $a(["323n"])],
            ["req", $a([$a([$a(["01"]), $a(["02"])])])]
        ]); //#758
        var _4b = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#770
        var _4i = new Map([
            ["parts", $a([_4b])],
            ["ex", $a(["324n"])],
            ["req", $a([$a([$a(["01"]), $a(["02"])])])]
        ]); //#773
        var _4k = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#785
        var _4r = new Map([
            ["parts", $a([_4k])],
            ["ex", $a(["325n"])],
            ["req", $a([$a([$a(["01"]), $a(["02"])])])]
        ]); //#788
        var _4t = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#800
        var _50 = new Map([
            ["parts", $a([_4t])],
            ["ex", $a(["326n"])],
            ["req", $a([$a([$a(["01"]), $a(["02"])])])]
        ]); //#803
        var _52 = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#815
        var _59 = new Map([
            ["parts", $a([_52])],
            ["ex", $a(["327n"])],
            ["req", $a([$a([$a(["01"]), $a(["02"])])])]
        ]); //#818
        var _5B = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#830
        var _5I = new Map([
            ["parts", $a([_5B])],
            ["ex", $a(["328n"])],
            ["req", $a([$a([$a(["01"]), $a(["02"])])])]
        ]); //#833
        var _5K = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#845
        var _5R = new Map([
            ["parts", $a([_5K])],
            ["ex", $a(["329n"])],
            ["req", $a([$a([$a(["01"]), $a(["02"])])])]
        ]); //#848
        var _5T = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#860
        var _5a = new Map([
            ["parts", $a([_5T])],
            ["ex", $a(["330n"])],
            ["req", $a([$a([$a(["00"]), $a(["01"])])])]
        ]); //#863
        var _5c = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#875
        var _5j = new Map([
            ["parts", $a([_5c])],
            ["ex", $a(["331n"])],
            ["req", $a([$a([$a(["00"]), $a(["01"])])])]
        ]); //#878
        var _5l = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#890
        var _5s = new Map([
            ["parts", $a([_5l])],
            ["ex", $a(["332n"])],
            ["req", $a([$a([$a(["00"]), $a(["01"])])])]
        ]); //#893
        var _5u = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#905
        var _61 = new Map([
            ["parts", $a([_5u])],
            ["ex", $a(["333n"])],
            ["req", $a([$a([$a(["00"]), $a(["01"])])])]
        ]); //#908
        var _63 = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#920
        var _6A = new Map([
            ["parts", $a([_63])],
            ["ex", $a(["334n"])],
            ["req", $a([$a([$a(["00"]), $a(["01"])])])]
        ]); //#923
        var _6C = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#935
        var _6J = new Map([
            ["parts", $a([_6C])],
            ["ex", $a(["335n"])],
            ["req", $a([$a([$a(["00"]), $a(["01"])])])]
        ]); //#938
        var _6L = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#950
        var _6S = new Map([
            ["parts", $a([_6L])],
            ["ex", $a(["336n"])],
            ["req", $a([$a([$a(["00"]), $a(["01"])])])]
        ]); //#953
        var _6U = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#965
        var _6a = new Map([
            ["parts", $a([_6U])],
            ["ex", $a(["337n"])],
            ["req", $a([$a([$a(["01"])])])]
        ]); //#968
        var _6c = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#980
        var _6j = new Map([
            ["parts", $a([_6c])],
            ["ex", $a(["340n"])],
            ["req", $a([$a([$a(["00"]), $a(["01"])])])]
        ]); //#983
        var _6l = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#995
        var _6s = new Map([
            ["parts", $a([_6l])],
            ["ex", $a(["341n"])],
            ["req", $a([$a([$a(["00"]), $a(["01"])])])]
        ]); //#998
        var _6u = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1010
        var _71 = new Map([
            ["parts", $a([_6u])],
            ["ex", $a(["342n"])],
            ["req", $a([$a([$a(["00"]), $a(["01"])])])]
        ]); //#1013
        var _73 = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1025
        var _7A = new Map([
            ["parts", $a([_73])],
            ["ex", $a(["343n"])],
            ["req", $a([$a([$a(["00"]), $a(["01"])])])]
        ]); //#1028
        var _7C = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1040
        var _7J = new Map([
            ["parts", $a([_7C])],
            ["ex", $a(["344n"])],
            ["req", $a([$a([$a(["00"]), $a(["01"])])])]
        ]); //#1043
        var _7L = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1055
        var _7S = new Map([
            ["parts", $a([_7L])],
            ["ex", $a(["345n"])],
            ["req", $a([$a([$a(["00"]), $a(["01"])])])]
        ]); //#1058
        var _7U = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1070
        var _7b = new Map([
            ["parts", $a([_7U])],
            ["ex", $a(["346n"])],
            ["req", $a([$a([$a(["00"]), $a(["01"])])])]
        ]); //#1073
        var _7d = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1085
        var _7k = new Map([
            ["parts", $a([_7d])],
            ["ex", $a(["347n"])],
            ["req", $a([$a([$a(["00"]), $a(["01"])])])]
        ]); //#1088
        var _7m = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1100
        var _7t = new Map([
            ["parts", $a([_7m])],
            ["ex", $a(["348n"])],
            ["req", $a([$a([$a(["00"]), $a(["01"])])])]
        ]); //#1103
        var _7v = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1115
        var _82 = new Map([
            ["parts", $a([_7v])],
            ["ex", $a(["349n"])],
            ["req", $a([$a([$a(["00"]), $a(["01"])])])]
        ]); //#1118
        var _84 = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1130
        var _8B = new Map([
            ["parts", $a([_84])],
            ["ex", $a(["350n"])],
            ["req", $a([$a([$a(["01"]), $a(["02"])])])]
        ]); //#1133
        var _8D = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1145
        var _8K = new Map([
            ["parts", $a([_8D])],
            ["ex", $a(["351n"])],
            ["req", $a([$a([$a(["01"]), $a(["02"])])])]
        ]); //#1148
        var _8M = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1160
        var _8T = new Map([
            ["parts", $a([_8M])],
            ["ex", $a(["352n"])],
            ["req", $a([$a([$a(["01"]), $a(["02"])])])]
        ]); //#1163
        var _8V = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1175
        var _8c = new Map([
            ["parts", $a([_8V])],
            ["ex", $a(["353n"])],
            ["req", $a([$a([$a(["00"]), $a(["01"])])])]
        ]); //#1178
        var _8e = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1190
        var _8l = new Map([
            ["parts", $a([_8e])],
            ["ex", $a(["354n"])],
            ["req", $a([$a([$a(["00"]), $a(["01"])])])]
        ]); //#1193
        var _8n = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1205
        var _8u = new Map([
            ["parts", $a([_8n])],
            ["ex", $a(["355n"])],
            ["req", $a([$a([$a(["00"]), $a(["01"])])])]
        ]); //#1208
        var _8w = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1220
        var _93 = new Map([
            ["parts", $a([_8w])],
            ["ex", $a(["356n"])],
            ["req", $a([$a([$a(["01"]), $a(["02"])])])]
        ]); //#1223
        var _95 = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1235
        var _9C = new Map([
            ["parts", $a([_95])],
            ["ex", $a(["357n"])],
            ["req", $a([$a([$a(["01"]), $a(["02"])])])]
        ]); //#1238
        var _9E = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1250
        var _9L = new Map([
            ["parts", $a([_9E])],
            ["ex", $a(["360n"])],
            ["req", $a([$a([$a(["01"]), $a(["02"])])])]
        ]); //#1253
        var _9N = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1265
        var _9U = new Map([
            ["parts", $a([_9N])],
            ["ex", $a(["361n"])],
            ["req", $a([$a([$a(["01"]), $a(["02"])])])]
        ]); //#1268
        var _9W = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1280
        var _9d = new Map([
            ["parts", $a([_9W])],
            ["ex", $a(["362n"])],
            ["req", $a([$a([$a(["00"]), $a(["01"])])])]
        ]); //#1283
        var _9f = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1295
        var _9m = new Map([
            ["parts", $a([_9f])],
            ["ex", $a(["363n"])],
            ["req", $a([$a([$a(["00"]), $a(["01"])])])]
        ]); //#1298
        var _9o = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1310
        var _9v = new Map([
            ["parts", $a([_9o])],
            ["ex", $a(["364n"])],
            ["req", $a([$a([$a(["01"]), $a(["02"])])])]
        ]); //#1313
        var _9x = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1325
        var _A4 = new Map([
            ["parts", $a([_9x])],
            ["ex", $a(["365n"])],
            ["req", $a([$a([$a(["01"]), $a(["02"])])])]
        ]); //#1328
        var _A6 = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1340
        var _AD = new Map([
            ["parts", $a([_A6])],
            ["ex", $a(["366n"])],
            ["req", $a([$a([$a(["01"]), $a(["02"])])])]
        ]); //#1343
        var _AF = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1355
        var _AM = new Map([
            ["parts", $a([_AF])],
            ["ex", $a(["367n"])],
            ["req", $a([$a([$a(["00"]), $a(["01"])])])]
        ]); //#1358
        var _AO = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1370
        var _AV = new Map([
            ["parts", $a([_AO])],
            ["ex", $a(["368n"])],
            ["req", $a([$a([$a(["00"]), $a(["01"])])])]
        ]); //#1373
        var _AX = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1385
        var _Ae = new Map([
            ["parts", $a([_AX])],
            ["ex", $a(["369n"])],
            ["req", $a([$a([$a(["00"]), $a(["01"])])])]
        ]); //#1388
        var _Ag = new Map([
            ["cset", 'N'],
            ["min", 1],
            ["max", 8],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1400
        var _Ao = new Map([
            ["parts", $a([_Ag])],
            ["req", $a([$a([$a(["00"])]), $a([$a(["02"]), $a(["8026"])])])]
        ]); //#1402
        var _Aq = new Map([
            ["cset", 'N'],
            ["min", 1],
            ["max", 15],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1409
        var _Ax = new Map([
            ["parts", $a([_Aq])],
            ["ex", $a(["390n", "391n", "394n", "8111"])],
            ["req", $a([$a([$a(["255"]), $a(["8020"])])])]
        ]); //#1412
        var _Az = new Map([
            ["cset", 'N'],
            ["min", 3],
            ["max", 3],
            ["opt", false],
            ["linters", $a(['lintiso4217'])]
        ]); //#1428
        var _B1 = new Map([
            ["cset", 'N'],
            ["min", 1],
            ["max", 15],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1429
        var _B7 = new Map([
            ["parts", $a([_Az, _B1])],
            ["ex", $a(["391n"])],
            ["req", $a([$a([$a(["8020"])])])]
        ]); //#1432
        var _B9 = new Map([
            ["cset", 'N'],
            ["min", 1],
            ["max", 15],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1448
        var _BL = new Map([
            ["parts", $a([_B9])],
            ["ex", $a(["392n", "393n"])],
            ["req", $a([$a([$a(["01"])]), $a([$a(["30"]), $a(["31nn"]), $a(["32nn"]), $a(["35nn"]), $a(["36nn"])])])]
        ]); //#1451
        var _BN = new Map([
            ["cset", 'N'],
            ["min", 3],
            ["max", 3],
            ["opt", false],
            ["linters", $a(['lintiso4217'])]
        ]); //#1467
        var _BP = new Map([
            ["cset", 'N'],
            ["min", 1],
            ["max", 15],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1468
        var _BZ = new Map([
            ["parts", $a([_BN, _BP])],
            ["ex", $a(["393n"])],
            ["req", $a([$a([$a(["30"]), $a(["31nn"]), $a(["32nn"]), $a(["35nn"]), $a(["36nn"])])])]
        ]); //#1471
        var _Bb = new Map([
            ["cset", 'N'],
            ["min", 4],
            ["max", 4],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1487
        var _Bh = new Map([
            ["parts", $a([_Bb])],
            ["ex", $a(["394n", "8111"])],
            ["req", $a([$a([$a(["255"])])])]
        ]); //#1490
        var _Bj = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1500
        var _Bt = new Map([
            ["parts", $a([_Bj])],
            ["ex", $a(["392n", "393n", "395n", "8005"])],
            ["req", $a([$a([$a(["30"]), $a(["31nn"]), $a(["32nn"]), $a(["35nn"]), $a(["36nn"])])])]
        ]); //#1503
        var _Bv = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 30],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1515
        var _Bx = new Map([
            ["parts", $a([_Bv])]
        ]); //#1515
        var _Bz = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 30],
            ["opt", false],
            ["linters", $a(['lintkey'])]
        ]); //#1523
        var _C2 = new Map([
            ["parts", $a([_Bz])],
            ["dlpkey", $a([])]
        ]); //#1525
        var _C4 = new Map([
            ["cset", 'N'],
            ["min", 17],
            ["max", 17],
            ["opt", false],
            ["linters", $a(['lintcsum', 'lintkey'])]
        ]); //#1532
        var _C7 = new Map([
            ["parts", $a([_C4])],
            ["dlpkey", $a([])]
        ]); //#1534
        var _C9 = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 30],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1541
        var _CE = new Map([
            ["parts", $a([_C9])],
            ["req", $a([$a([$a(["00"])])])]
        ]); //#1543
        var _CG = new Map([
            ["cset", 'N'],
            ["min", 13],
            ["max", 13],
            ["opt", false],
            ["linters", $a(['lintcsum', 'lintkey'])]
        ]); //#1550
        var _CI = new Map([
            ["parts", $a([_CG])]
        ]); //#1550
        var _CK = new Map([
            ["cset", 'N'],
            ["min", 13],
            ["max", 13],
            ["opt", false],
            ["linters", $a(['lintcsum', 'lintkey'])]
        ]); //#1561
        var _CP = new Map([
            ["parts", $a([_CK])],
            ["dlpkey", $a([$a(["254"]), $a(["7040"])])]
        ]); //#1563
        var _CR = new Map([
            ["cset", 'N'],
            ["min", 13],
            ["max", 13],
            ["opt", false],
            ["linters", $a(['lintcsum', 'lintkey'])]
        ]); //#1570
        var _CY = new Map([
            ["parts", $a([_CR])],
            ["req", $a([$a([$a(["8020"])])])],
            ["dlpkey", $a([$a(["8020"])])]
        ]); //#1573
        var _Ca = new Map([
            ["cset", 'N'],
            ["min", 13],
            ["max", 13],
            ["opt", false],
            ["linters", $a(['lintcsum', 'lintkey'])]
        ]); //#1580
        var _Cc = new Map([
            ["parts", $a([_Ca])]
        ]); //#1580
        var _Ce = new Map([
            ["cset", 'N'],
            ["min", 13],
            ["max", 13],
            ["opt", false],
            ["linters", $a(['lintcsum', 'lintkey'])]
        ]); //#1588
        var _Ci = new Map([
            ["parts", $a([_Ce])],
            ["dlpkey", $a([$a(["7040"])])]
        ]); //#1590
        var _Ck = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 20],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1597
        var _Cn = new Map([
            ["parts", $a([_Ck])],
            ["ex", $a(["421"])]
        ]); //#1599
        var _Cp = new Map([
            ["cset", 'N'],
            ["min", 3],
            ["max", 3],
            ["opt", false],
            ["linters", $a(['lintiso3166'])]
        ]); //#1606
        var _Cr = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 9],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1607
        var _Cu = new Map([
            ["parts", $a([_Cp, _Cr])],
            ["ex", $a(["4307"])]
        ]); //#1609
        var _Cw = new Map([
            ["cset", 'N'],
            ["min", 3],
            ["max", 3],
            ["opt", false],
            ["linters", $a(['lintiso3166'])]
        ]); //#1616
        var _D5 = new Map([
            ["parts", $a([_Cw])],
            ["ex", $a(["426"])],
            ["req", $a([$a([$a(["01"]), $a(["02"]), $a(["8006"]), $a(["8026"])])])]
        ]); //#1619
        var _D7 = new Map([
            ["cset", 'N'],
            ["min", 1],
            ["max", 15],
            ["opt", false],
            ["linters", $a(['lintiso3166list'])]
        ]); //#1626
        var _DE = new Map([
            ["parts", $a([_D7])],
            ["ex", $a(["426"])],
            ["req", $a([$a([$a(["01"]), $a(["02"])])])]
        ]); //#1629
        var _DG = new Map([
            ["cset", 'N'],
            ["min", 3],
            ["max", 3],
            ["opt", false],
            ["linters", $a(['lintiso3166'])]
        ]); //#1636
        var _DN = new Map([
            ["parts", $a([_DG])],
            ["ex", $a(["426"])],
            ["req", $a([$a([$a(["01"]), $a(["02"])])])]
        ]); //#1639
        var _DP = new Map([
            ["cset", 'N'],
            ["min", 1],
            ["max", 15],
            ["opt", false],
            ["linters", $a(['lintiso3166list'])]
        ]); //#1646
        var _DW = new Map([
            ["parts", $a([_DP])],
            ["ex", $a(["426"])],
            ["req", $a([$a([$a(["01"]), $a(["02"])])])]
        ]); //#1649
        var _DY = new Map([
            ["cset", 'N'],
            ["min", 3],
            ["max", 3],
            ["opt", false],
            ["linters", $a(['lintiso3166'])]
        ]); //#1656
        var _De = new Map([
            ["parts", $a([_DY])],
            ["req", $a([$a([$a(["01"]), $a(["02"])])])]
        ]); //#1658
        var _Dg = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 3],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1665
        var _Do = new Map([
            ["parts", $a([_Dg])],
            ["req", $a([$a([$a(["01"]), $a(["02"])]), $a([$a(["422"])])])]
        ]); //#1667
        var _Dq = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 35],
            ["opt", false],
            ["linters", $a(['lintpcenc'])]
        ]); //#1674
        var _Dv = new Map([
            ["parts", $a([_Dq])],
            ["req", $a([$a([$a(["00"])])])]
        ]); //#1676
        var _Dx = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 70],
            ["opt", false],
            ["linters", $a(['lintpcenc'])]
        ]); //#1684
        var _E2 = new Map([
            ["parts", $a([_Dx])],
            ["req", $a([$a([$a(["00"])])])]
        ]); //#1686
        var _E4 = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 70],
            ["opt", false],
            ["linters", $a(['lintpcenc'])]
        ]); //#1693
        var _E9 = new Map([
            ["parts", $a([_E4])],
            ["req", $a([$a([$a(["4302"])])])]
        ]); //#1695
        var _EB = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 70],
            ["opt", false],
            ["linters", $a(['lintpcenc'])]
        ]); //#1702
        var _EG = new Map([
            ["parts", $a([_EB])],
            ["req", $a([$a([$a(["00"])])])]
        ]); //#1704
        var _EI = new Map([
            ["cset", 'X'],
            ["min", 2],
            ["max", 2],
            ["opt", false],
            ["linters", $a(['lintiso3166alpha2'])]
        ]); //#1713
        var _EN = new Map([
            ["parts", $a([_EI])],
            ["req", $a([$a([$a(["00"])])])]
        ]); //#1715
        var _EP = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 30],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1722
        var _EU = new Map([
            ["parts", $a([_EP])],
            ["req", $a([$a([$a(["00"])])])]
        ]); //#1724
        var _EW = new Map([
            ["cset", 'N'],
            ["min", 10],
            ["max", 10],
            ["opt", false],
            ["linters", $a(['lintlatitude'])]
        ]); //#1731
        var _EY = new Map([
            ["cset", 'N'],
            ["min", 10],
            ["max", 10],
            ["opt", false],
            ["linters", $a(['lintlongitude'])]
        ]); //#1732
        var _Ed = new Map([
            ["parts", $a([_EW, _EY])],
            ["req", $a([$a([$a(["00"])])])]
        ]); //#1734
        var _Ef = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 35],
            ["opt", false],
            ["linters", $a(['lintpcenc'])]
        ]); //#1741
        var _Ek = new Map([
            ["parts", $a([_Ef])],
            ["req", $a([$a([$a(["00"])])])]
        ]); //#1743
        var _Em = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 70],
            ["opt", false],
            ["linters", $a(['lintpcenc'])]
        ]); //#1751
        var _Er = new Map([
            ["parts", $a([_Em])],
            ["req", $a([$a([$a(["00"])])])]
        ]); //#1753
        var _Et = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 70],
            ["opt", false],
            ["linters", $a(['lintpcenc'])]
        ]); //#1760
        var _Ey = new Map([
            ["parts", $a([_Et])],
            ["req", $a([$a([$a(["4312"])])])]
        ]); //#1762
        var _F0 = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 70],
            ["opt", false],
            ["linters", $a(['lintpcenc'])]
        ]); //#1769
        var _F5 = new Map([
            ["parts", $a([_F0])],
            ["req", $a([$a([$a(["00"])])])]
        ]); //#1771
        var _F7 = new Map([
            ["cset", 'X'],
            ["min", 2],
            ["max", 2],
            ["opt", false],
            ["linters", $a(['lintiso3166alpha2'])]
        ]); //#1780
        var _FC = new Map([
            ["parts", $a([_F7])],
            ["req", $a([$a([$a(["00"])])])]
        ]); //#1782
        var _FE = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 20],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1789
        var _FJ = new Map([
            ["parts", $a([_FE])],
            ["req", $a([$a([$a(["00"])])])]
        ]); //#1791
        var _FL = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 30],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1798
        var _FQ = new Map([
            ["parts", $a([_FL])],
            ["req", $a([$a([$a(["00"])])])]
        ]); //#1800
        var _FS = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 35],
            ["opt", false],
            ["linters", $a(['lintpcenc'])]
        ]); //#1807
        var _FX = new Map([
            ["parts", $a([_FS])],
            ["req", $a([$a([$a(["00"])])])]
        ]); //#1809
        var _FZ = new Map([
            ["cset", 'N'],
            ["min", 1],
            ["max", 1],
            ["opt", false],
            ["linters", $a(['lintyesno'])]
        ]); //#1816
        var _Fe = new Map([
            ["parts", $a([_FZ])],
            ["req", $a([$a([$a(["00"])])])]
        ]); //#1818
        var _Fg = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a(['lintyymmd0'])]
        ]); //#1827
        var _Fi = new Map([
            ["cset", 'N'],
            ["min", 4],
            ["max", 4],
            ["opt", false],
            ["linters", $a(['linthhmm'])]
        ]); //#1828
        var _Fn = new Map([
            ["parts", $a([_Fg, _Fi])],
            ["req", $a([$a([$a(["00"])])])]
        ]); //#1830
        var _Fp = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a(['lintyymmdd'])]
        ]); //#1838
        var _Fu = new Map([
            ["parts", $a([_Fp])],
            ["req", $a([$a([$a(["00"])])])]
        ]); //#1840
        var _Fw = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1847
        var _Fy = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 1],
            ["opt", true],
            ["linters", $a(['linthyphen'])]
        ]); //#1848
        var _G4 = new Map([
            ["parts", $a([_Fw, _Fy])],
            ["ex", $a(["4331"])],
            ["req", $a([$a([$a(["00"])])])]
        ]); //#1851
        var _G6 = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1858
        var _G8 = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 1],
            ["opt", true],
            ["linters", $a(['linthyphen'])]
        ]); //#1859
        var _GE = new Map([
            ["parts", $a([_G6, _G8])],
            ["ex", $a(["4330"])],
            ["req", $a([$a([$a(["00"])])])]
        ]); //#1862
        var _GG = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1869
        var _GI = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 1],
            ["opt", true],
            ["linters", $a(['linthyphen'])]
        ]); //#1870
        var _GO = new Map([
            ["parts", $a([_GG, _GI])],
            ["ex", $a(["4333"])],
            ["req", $a([$a([$a(["00"])])])]
        ]); //#1873
        var _GQ = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1880
        var _GS = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 1],
            ["opt", true],
            ["linters", $a(['linthyphen'])]
        ]); //#1881
        var _GY = new Map([
            ["parts", $a([_GQ, _GS])],
            ["ex", $a(["4332"])],
            ["req", $a([$a([$a(["00"])])])]
        ]); //#1884
        var _Ga = new Map([
            ["cset", 'N'],
            ["min", 13],
            ["max", 13],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1891
        var _Gi = new Map([
            ["parts", $a([_Ga])],
            ["req", $a([$a([$a(["01"]), $a(["02"]), $a(["8006"]), $a(["8026"])])])]
        ]); //#1893
        var _Gk = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 30],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1900
        var _Gq = new Map([
            ["parts", $a([_Gk])],
            ["req", $a([$a([$a(["01"]), $a(["02"])])])]
        ]); //#1902
        var _Gs = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a(['lintyymmdd'])]
        ]); //#1909
        var _Gu = new Map([
            ["cset", 'N'],
            ["min", 4],
            ["max", 4],
            ["opt", false],
            ["linters", $a(['linthhmm'])]
        ]); //#1910
        var _H0 = new Map([
            ["parts", $a([_Gs, _Gu])],
            ["req", $a([$a([$a(["01"]), $a(["02"])])])]
        ]); //#1912
        var _H2 = new Map([
            ["cset", 'N'],
            ["min", 1],
            ["max", 4],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1919
        var _H9 = new Map([
            ["parts", $a([_H2])],
            ["req", $a([$a([$a(["01"])]), $a([$a(["10"])])])]
        ]); //#1921
        var _HB = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 12],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1928
        var _HH = new Map([
            ["parts", $a([_HB])],
            ["req", $a([$a([$a(["01"]), $a(["02"])])])]
        ]); //#1930
        var _HJ = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a(['lintyymmdd'])]
        ]); //#1937
        var _HP = new Map([
            ["parts", $a([_HJ])],
            ["req", $a([$a([$a(["01"]), $a(["02"])])])]
        ]); //#1939
        var _HR = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a(['lintyymmdd'])]
        ]); //#1946
        var _HT = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", true],
            ["linters", $a(['lintyymmdd'])]
        ]); //#1947
        var _HZ = new Map([
            ["parts", $a([_HR, _HT])],
            ["req", $a([$a([$a(["01"]), $a(["02"])])])]
        ]); //#1949
        var _Hb = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 3],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1956
        var _Hh = new Map([
            ["parts", $a([_Hb])],
            ["req", $a([$a([$a(["01"]), $a(["02"])])])]
        ]); //#1958
        var _Hj = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 10],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1965
        var _Hp = new Map([
            ["parts", $a([_Hj])],
            ["req", $a([$a([$a(["01"]), $a(["02"])])])]
        ]); //#1967
        var _Hr = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 2],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1974
        var _Hx = new Map([
            ["parts", $a([_Hr])],
            ["req", $a([$a([$a(["01"]), $a(["02"])])])]
        ]); //#1976
        var _Hz = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a(['lintyymmdd'])]
        ]); //#1983
        var _I1 = new Map([
            ["cset", 'N'],
            ["min", 4],
            ["max", 4],
            ["opt", true],
            ["linters", $a(['linthhmm'])]
        ]); //#1984
        var _I7 = new Map([
            ["parts", $a([_Hz, _I1])],
            ["req", $a([$a([$a(["01"]), $a(["02"])])])]
        ]); //#1986
        var _I9 = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 20],
            ["opt", false],
            ["linters", $a([])]
        ]); //#1993
        var _IH = new Map([
            ["parts", $a([_I9])],
            ["req", $a([$a([$a(["01"]), $a(["8006"])]), $a([$a(["416"])])])]
        ]); //#1995
        var _IJ = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 20],
            ["opt", false],
            ["linters", $a([])]
        ]); //#2002
        var _IP = new Map([
            ["parts", $a([_IJ])],
            ["req", $a([$a([$a(["01"]), $a(["8006"])])])]
        ]); //#2004
        var _IR = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 20],
            ["opt", false],
            ["linters", $a([])]
        ]); //#2011
        var _IW = new Map([
            ["parts", $a([_IR])],
            ["req", $a([$a([$a(["7021"])])])]
        ]); //#2013
        var _IY = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 30],
            ["opt", false],
            ["linters", $a(['lintkey'])]
        ]); //#2020
        var _Ia = new Map([
            ["parts", $a([_IY])]
        ]); //#2020
        var _Ic = new Map([
            ["cset", 'N'],
            ["min", 3],
            ["max", 3],
            ["opt", false],
            ["linters", $a(['lintiso3166999'])]
        ]); //#2028
        var _Ie = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 27],
            ["opt", false],
            ["linters", $a([])]
        ]); //#2029
        var _Ik = new Map([
            ["parts", $a([_Ic, _Ie])],
            ["req", $a([$a([$a(["01"]), $a(["02"])])])]
        ]); //#2031
        var _Im = new Map([
            ["cset", 'N'],
            ["min", 1],
            ["max", 1],
            ["opt", false],
            ["linters", $a([])]
        ]); //#2047
        var _Io = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 1],
            ["opt", false],
            ["linters", $a([])]
        ]); //#2048
        var _Iq = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 1],
            ["opt", false],
            ["linters", $a([])]
        ]); //#2049
        var _Is = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 1],
            ["opt", false],
            ["linters", $a(['lintimporteridx'])]
        ]); //#2050
        var _Iu = new Map([
            ["parts", $a([_Im, _Io, _Iq, _Is])],
            ["dlattr", false]
        ]); //#2052
        var _Iw = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 20],
            ["opt", false],
            ["linters", $a([])]
        ]); //#2059
        var _J1 = new Map([
            ["parts", $a([_Iw])],
            ["req", $a([$a([$a(["01"])])])]
        ]); //#2061
        var _J3 = new Map([
            ["cset", 'X'],
            ["min", 2],
            ["max", 2],
            ["opt", false],
            ["linters", $a([])]
        ]); //#2073
        var _J5 = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 28],
            ["opt", false],
            ["linters", $a([])]
        ]); //#2074
        var _JB = new Map([
            ["parts", $a([_J3, _J5])],
            ["req", $a([$a([$a(["01"]), $a(["8004"])])])]
        ]); //#2076
        var _JD = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 20],
            ["opt", false],
            ["linters", $a([])]
        ]); //#2092
        var _JJ = new Map([
            ["parts", $a([_JD])],
            ["req", $a([$a([$a(["01"]), $a(["8006"])])])]
        ]); //#2094
        var _JL = new Map([
            ["cset", 'N'],
            ["min", 2],
            ["max", 2],
            ["opt", false],
            ["linters", $a(['lintmediatype'])]
        ]); //#2101
        var _JR = new Map([
            ["parts", $a([_JL])],
            ["req", $a([$a([$a(["8017"]), $a(["8018"])])])]
        ]); //#2103
        var _JT = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 25],
            ["opt", false],
            ["linters", $a([])]
        ]); //#2110
        var _JZ = new Map([
            ["parts", $a([_JT])],
            ["req", $a([$a([$a(["8017"]), $a(["8018"])])])]
        ]); //#2112
        var _Jb = new Map([
            ["cset", 'N'],
            ["min", 8],
            ["max", 8],
            ["opt", false],
            ["linters", $a(['lintyyyymmdd'])]
        ]); //#2119
        var _Jh = new Map([
            ["parts", $a([_Jb])],
            ["ex", $a(["7251"])],
            ["req", $a([$a([$a(["8018"])])])],
            ["dlattr", false]
        ]); //#2123
        var _Jj = new Map([
            ["cset", 'N'],
            ["min", 8],
            ["max", 8],
            ["opt", false],
            ["linters", $a(['lintyyyymmdd'])]
        ]); //#2130
        var _Jl = new Map([
            ["cset", 'N'],
            ["min", 4],
            ["max", 4],
            ["opt", false],
            ["linters", $a(['linthhmm'])]
        ]); //#2131
        var _Jr = new Map([
            ["parts", $a([_Jj, _Jl])],
            ["ex", $a(["7250"])],
            ["req", $a([$a([$a(["8018"])])])],
            ["dlattr", false]
        ]); //#2135
        var _Jt = new Map([
            ["cset", 'N'],
            ["min", 1],
            ["max", 1],
            ["opt", false],
            ["linters", $a(['lintiso5218'])]
        ]); //#2142
        var _Jy = new Map([
            ["parts", $a([_Jt])],
            ["req", $a([$a([$a(["8018"])])])],
            ["dlattr", false]
        ]); //#2145
        var _K0 = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 40],
            ["opt", false],
            ["linters", $a(['lintpcenc'])]
        ]); //#2152
        var _K7 = new Map([
            ["parts", $a([_K0])],
            ["ex", $a(["7256", "7259"])],
            ["req", $a([$a([$a(["8017"]), $a(["8018"])])])],
            ["dlattr", false]
        ]); //#2156
        var _K9 = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 10],
            ["opt", false],
            ["linters", $a([])]
        ]); //#2164
        var _KG = new Map([
            ["parts", $a([_K9])],
            ["ex", $a(["7256", "7259"])],
            ["req", $a([$a([$a(["8017"]), $a(["8018"])])])],
            ["dlattr", false]
        ]); //#2168
        var _KI = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 90],
            ["opt", false],
            ["linters", $a(['lintpcenc'])]
        ]); //#2175
        var _KO = new Map([
            ["parts", $a([_KI])],
            ["req", $a([$a([$a(["8017"]), $a(["8018"])])])],
            ["dlattr", false]
        ]); //#2178
        var _KQ = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 70],
            ["opt", false],
            ["linters", $a(['lintpcenc'])]
        ]); //#2185
        var _KV = new Map([
            ["parts", $a([_KQ])],
            ["req", $a([$a([$a(["8018"])])])],
            ["dlattr", false]
        ]); //#2188
        var _KX = new Map([
            ["cset", 'X'],
            ["min", 3],
            ["max", 3],
            ["opt", false],
            ["linters", $a(['lintposinseqslash'])]
        ]); //#2195
        var _Kc = new Map([
            ["parts", $a([_KX])],
            ["req", $a([$a([$a(["8018", "7259"])])])],
            ["dlattr", false]
        ]); //#2198
        var _Ke = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 40],
            ["opt", false],
            ["linters", $a(['lintpcenc'])]
        ]); //#2205
        var _Kk = new Map([
            ["parts", $a([_Ke])],
            ["ex", $a(["7256"])],
            ["req", $a([$a([$a(["8018"])])])],
            ["dlattr", false]
        ]); //#2209
        var _Km = new Map([
            ["cset", 'N'],
            ["min", 4],
            ["max", 4],
            ["opt", false],
            ["linters", $a(['lintnonzero'])]
        ]); //#2216
        var _Ko = new Map([
            ["cset", 'N'],
            ["min", 5],
            ["max", 5],
            ["opt", false],
            ["linters", $a(['lintnonzero'])]
        ]); //#2217
        var _Kq = new Map([
            ["cset", 'N'],
            ["min", 3],
            ["max", 3],
            ["opt", false],
            ["linters", $a(['lintnonzero'])]
        ]); //#2218
        var _Ks = new Map([
            ["cset", 'N'],
            ["min", 1],
            ["max", 1],
            ["opt", false],
            ["linters", $a(['lintwinding'])]
        ]); //#2219
        var _Ku = new Map([
            ["cset", 'N'],
            ["min", 1],
            ["max", 1],
            ["opt", false],
            ["linters", $a([])]
        ]); //#2220
        var _Kz = new Map([
            ["parts", $a([_Km, _Ko, _Kq, _Ks, _Ku])],
            ["req", $a([$a([$a(["01"])])])]
        ]); //#2222
        var _L1 = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 20],
            ["opt", false],
            ["linters", $a([])]
        ]); //#2229
        var _L3 = new Map([
            ["parts", $a([_L1])]
        ]); //#2229
        var _L5 = new Map([
            ["cset", 'N'],
            ["min", 1],
            ["max", 1],
            ["opt", false],
            ["linters", $a(['lintzero'])]
        ]); //#2237
        var _L7 = new Map([
            ["cset", 'N'],
            ["min", 13],
            ["max", 13],
            ["opt", false],
            ["linters", $a(['lintcsum', 'lintkey'])]
        ]); //#2238
        var _L9 = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 16],
            ["opt", true],
            ["linters", $a([])]
        ]); //#2239
        var _LC = new Map([
            ["parts", $a([_L5, _L7, _L9])],
            ["dlpkey", $a([])]
        ]); //#2241
        var _LE = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 30],
            ["opt", false],
            ["linters", $a(['lintkey'])]
        ]); //#2248
        var _LI = new Map([
            ["parts", $a([_LE])],
            ["dlpkey", $a([$a(["7040"])])]
        ]); //#2250
        var _LK = new Map([
            ["cset", 'N'],
            ["min", 6],
            ["max", 6],
            ["opt", false],
            ["linters", $a([])]
        ]); //#2257
        var _LQ = new Map([
            ["parts", $a([_LK])],
            ["req", $a([$a([$a(["01"]), $a(["02"])])])]
        ]); //#2259
        var _LS = new Map([
            ["cset", 'N'],
            ["min", 14],
            ["max", 14],
            ["opt", false],
            ["linters", $a(['lintcsum'])]
        ]); //#2266
        var _LU = new Map([
            ["cset", 'N'],
            ["min", 4],
            ["max", 4],
            ["opt", false],
            ["linters", $a(['lintpieceoftotal'])]
        ]); //#2267
        var _LZ = new Map([
            ["parts", $a([_LS, _LU])],
            ["ex", $a(["01", "37"])],
            ["dlpkey", $a([$a(["22", "10", "21"])])]
        ]); //#2270
        var _Lb = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 34],
            ["opt", false],
            ["linters", $a(['lintiban'])]
        ]); //#2277
        var _Lg = new Map([
            ["parts", $a([_Lb])],
            ["req", $a([$a([$a(["415"])])])]
        ]); //#2279
        var _Li = new Map([
            ["cset", 'N'],
            ["min", 8],
            ["max", 8],
            ["opt", false],
            ["linters", $a(['lintyymmddhh'])]
        ]); //#2286
        var _Lk = new Map([
            ["cset", 'N'],
            ["min", 1],
            ["max", 4],
            ["opt", true],
            ["linters", $a(['lintmmoptss'])]
        ]); //#2287
        var _Lq = new Map([
            ["parts", $a([_Li, _Lk])],
            ["req", $a([$a([$a(["01"]), $a(["02"])])])]
        ]); //#2289
        var _Ls = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 50],
            ["opt", false],
            ["linters", $a([])]
        ]); //#2296
        var _Ly = new Map([
            ["parts", $a([_Ls])],
            ["req", $a([$a([$a(["00"]), $a(["01"])])])]
        ]); //#2298
        var _M0 = new Map([
            ["cset", 'Y'],
            ["min", 1],
            ["max", 30],
            ["opt", false],
            ["linters", $a(['lintkey'])]
        ]); //#2305
        var _M4 = new Map([
            ["parts", $a([_M0])],
            ["dlpkey", $a([$a(["8011"])])]
        ]); //#2307
        var _M6 = new Map([
            ["cset", 'N'],
            ["min", 1],
            ["max", 12],
            ["opt", false],
            ["linters", $a(['lintnozeroprefix'])]
        ]); //#2314
        var _MB = new Map([
            ["parts", $a([_M6])],
            ["req", $a([$a([$a(["8010"])])])],
            ["dlattr", false]
        ]); //#2317
        var _MD = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 20],
            ["opt", false],
            ["linters", $a([])]
        ]); //#2324
        var _MJ = new Map([
            ["parts", $a([_MD])],
            ["req", $a([$a([$a(["01"]), $a(["8006"])])])]
        ]); //#2326
        var _ML = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 25],
            ["opt", false],
            ["linters", $a(['lintcsumalpha', 'lintkey'])]
        ]); //#2333
        var _MO = new Map([
            ["parts", $a([_ML])],
            ["dlpkey", $a([])]
        ]); //#2335
        var _MQ = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 25],
            ["opt", false],
            ["linters", $a(['lintcsumalpha', 'lintkey', 'linthasnondigit'])]
        ]); //#2342
        var _MV = new Map([
            ["parts", $a([_MQ])],
            ["req", $a([$a([$a(["01"])])])],
            ["dlattr", false]
        ]); //#2345
        var _MX = new Map([
            ["cset", 'N'],
            ["min", 18],
            ["max", 18],
            ["opt", false],
            ["linters", $a(['lintcsum', 'lintkey'])]
        ]); //#2352
        var _Mc = new Map([
            ["parts", $a([_MX])],
            ["ex", $a(["8018"])],
            ["dlpkey", $a([$a(["8019"])])]
        ]); //#2355
        var _Me = new Map([
            ["cset", 'N'],
            ["min", 18],
            ["max", 18],
            ["opt", false],
            ["linters", $a(['lintcsum', 'lintkey'])]
        ]); //#2362
        var _Mj = new Map([
            ["parts", $a([_Me])],
            ["ex", $a(["8017"])],
            ["dlpkey", $a([$a(["8019"])])]
        ]); //#2365
        var _Ml = new Map([
            ["cset", 'N'],
            ["min", 1],
            ["max", 10],
            ["opt", false],
            ["linters", $a([])]
        ]); //#2372
        var _Mr = new Map([
            ["parts", $a([_Ml])],
            ["req", $a([$a([$a(["8017"]), $a(["8018"])])])],
            ["dlattr", false]
        ]); //#2375
        var _Mt = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 25],
            ["opt", false],
            ["linters", $a([])]
        ]); //#2382
        var _My = new Map([
            ["parts", $a([_Mt])],
            ["req", $a([$a([$a(["415"])])])]
        ]); //#2384
        var _N0 = new Map([
            ["cset", 'N'],
            ["min", 14],
            ["max", 14],
            ["opt", false],
            ["linters", $a(['lintcsum'])]
        ]); //#2391
        var _N2 = new Map([
            ["cset", 'N'],
            ["min", 4],
            ["max", 4],
            ["opt", false],
            ["linters", $a(['lintpieceoftotal'])]
        ]); //#2392
        var _N8 = new Map([
            ["parts", $a([_N0, _N2])],
            ["ex", $a(["02", "8006"])],
            ["req", $a([$a([$a(["37"])])])]
        ]); //#2395
        var _NA = new Map([
            ["cset", 'Z'],
            ["min", 1],
            ["max", 90],
            ["opt", false],
            ["linters", $a([])]
        ]); //#2402
        var _NO = new Map([
            ["parts", $a([_NA])],
            ["req", $a([$a([$a(["00"]), $a(["01", "21"]), $a(["253"]), $a(["255"]), $a(["8003"]), $a(["8004"]), $a(["8006", "21"]), $a(["8010", "8011"]), $a(["8017"]), $a(["8018"])])])]
        ]); //#2404
        var _NQ = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 70],
            ["opt", false],
            ["linters", $a(['lintcouponcode'])]
        ]); //#2411
        var _NS = new Map([
            ["parts", $a([_NQ])]
        ]); //#2411
        var _NU = new Map([
            ["cset", 'N'],
            ["min", 4],
            ["max", 4],
            ["opt", false],
            ["linters", $a([])]
        ]); //#2419
        var _NZ = new Map([
            ["parts", $a([_NU])],
            ["req", $a([$a([$a(["255"])])])]
        ]); //#2421
        var _Nb = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 70],
            ["opt", false],
            ["linters", $a(['lintcouponposoffer'])]
        ]); //#2428
        var _Nd = new Map([
            ["parts", $a([_Nb])]
        ]); //#2428
        var _Nf = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 70],
            ["opt", false],
            ["linters", $a([])]
        ]); //#2436
        var _Nk = new Map([
            ["parts", $a([_Nf])],
            ["req", $a([$a([$a(["01"])])])],
            ["dlattr", false]
        ]); //#2439
        var _Nm = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 30],
            ["opt", false],
            ["linters", $a([])]
        ]); //#2446
        var _No = new Map([
            ["parts", $a([_Nm])]
        ]); //#2446
        var _Nq = new Map([
            ["cset", 'X'],
            ["min", 1],
            ["max", 90],
            ["opt", false],
            ["linters", $a([])]
        ]); //#2454
        var _Ns = new Map([
            ["parts", $a([_Nq])]
        ]); //#2454
        var _Nt = new Map([
            ["00", _4],
            ["01", _C],
            ["02", _K],
            ["03", _P],
            ["10", _a],
            ["11", _k],
            ["12", _r],
            ["13", _11],
            ["15", _11],
            ["16", _11],
            ["17", _1C],
            ["20", _1M],
            ["21", _1W],
            ["22", _1d],
            ["235", _1k],
            ["240", _1u],
            ["241", _1u],
            ["242", _25],
            ["243", _2C],
            ["250", _2M],
            ["251", _2U],
            ["253", _2b],
            ["254", _2i],
            ["255", _2q],
            ["30", _2y],
            ["3100", _37],
            ["3101", _37],
            ["3102", _37],
            ["3103", _37],
            ["3104", _37],
            ["3105", _37],
            ["3110", _3G],
            ["3111", _3G],
            ["3112", _3G],
            ["3113", _3G],
            ["3114", _3G],
            ["3115", _3G],
            ["3120", _3P],
            ["3121", _3P],
            ["3122", _3P],
            ["3123", _3P],
            ["3124", _3P],
            ["3125", _3P],
            ["3130", _3Y],
            ["3131", _3Y],
            ["3132", _3Y],
            ["3133", _3Y],
            ["3134", _3Y],
            ["3135", _3Y],
            ["3140", _3h],
            ["3141", _3h],
            ["3142", _3h],
            ["3143", _3h],
            ["3144", _3h],
            ["3145", _3h],
            ["3150", _3q],
            ["3151", _3q],
            ["3152", _3q],
            ["3153", _3q],
            ["3154", _3q],
            ["3155", _3q],
            ["3160", _3z],
            ["3161", _3z],
            ["3162", _3z],
            ["3163", _3z],
            ["3164", _3z],
            ["3165", _3z],
            ["3200", _48],
            ["3201", _48],
            ["3202", _48],
            ["3203", _48],
            ["3204", _48],
            ["3205", _48],
            ["3210", _4H],
            ["3211", _4H],
            ["3212", _4H],
            ["3213", _4H],
            ["3214", _4H],
            ["3215", _4H],
            ["3220", _4Q],
            ["3221", _4Q],
            ["3222", _4Q],
            ["3223", _4Q],
            ["3224", _4Q],
            ["3225", _4Q],
            ["3230", _4Z],
            ["3231", _4Z],
            ["3232", _4Z],
            ["3233", _4Z],
            ["3234", _4Z],
            ["3235", _4Z],
            ["3240", _4i],
            ["3241", _4i],
            ["3242", _4i],
            ["3243", _4i],
            ["3244", _4i],
            ["3245", _4i],
            ["3250", _4r],
            ["3251", _4r],
            ["3252", _4r],
            ["3253", _4r],
            ["3254", _4r],
            ["3255", _4r],
            ["3260", _50],
            ["3261", _50],
            ["3262", _50],
            ["3263", _50],
            ["3264", _50],
            ["3265", _50],
            ["3270", _59],
            ["3271", _59],
            ["3272", _59],
            ["3273", _59],
            ["3274", _59],
            ["3275", _59],
            ["3280", _5I],
            ["3281", _5I],
            ["3282", _5I],
            ["3283", _5I],
            ["3284", _5I],
            ["3285", _5I],
            ["3290", _5R],
            ["3291", _5R],
            ["3292", _5R],
            ["3293", _5R],
            ["3294", _5R],
            ["3295", _5R],
            ["3300", _5a],
            ["3301", _5a],
            ["3302", _5a],
            ["3303", _5a],
            ["3304", _5a],
            ["3305", _5a],
            ["3310", _5j],
            ["3311", _5j],
            ["3312", _5j],
            ["3313", _5j],
            ["3314", _5j],
            ["3315", _5j],
            ["3320", _5s],
            ["3321", _5s],
            ["3322", _5s],
            ["3323", _5s],
            ["3324", _5s],
            ["3325", _5s],
            ["3330", _61],
            ["3331", _61],
            ["3332", _61],
            ["3333", _61],
            ["3334", _61],
            ["3335", _61],
            ["3340", _6A],
            ["3341", _6A],
            ["3342", _6A],
            ["3343", _6A],
            ["3344", _6A],
            ["3345", _6A],
            ["3350", _6J],
            ["3351", _6J],
            ["3352", _6J],
            ["3353", _6J],
            ["3354", _6J],
            ["3355", _6J],
            ["3360", _6S],
            ["3361", _6S],
            ["3362", _6S],
            ["3363", _6S],
            ["3364", _6S],
            ["3365", _6S],
            ["3370", _6a],
            ["3371", _6a],
            ["3372", _6a],
            ["3373", _6a],
            ["3374", _6a],
            ["3375", _6a],
            ["3400", _6j],
            ["3401", _6j],
            ["3402", _6j],
            ["3403", _6j],
            ["3404", _6j],
            ["3405", _6j],
            ["3410", _6s],
            ["3411", _6s],
            ["3412", _6s],
            ["3413", _6s],
            ["3414", _6s],
            ["3415", _6s],
            ["3420", _71],
            ["3421", _71],
            ["3422", _71],
            ["3423", _71],
            ["3424", _71],
            ["3425", _71],
            ["3430", _7A],
            ["3431", _7A],
            ["3432", _7A],
            ["3433", _7A],
            ["3434", _7A],
            ["3435", _7A],
            ["3440", _7J],
            ["3441", _7J],
            ["3442", _7J],
            ["3443", _7J],
            ["3444", _7J],
            ["3445", _7J],
            ["3450", _7S],
            ["3451", _7S],
            ["3452", _7S],
            ["3453", _7S],
            ["3454", _7S],
            ["3455", _7S],
            ["3460", _7b],
            ["3461", _7b],
            ["3462", _7b],
            ["3463", _7b],
            ["3464", _7b],
            ["3465", _7b],
            ["3470", _7k],
            ["3471", _7k],
            ["3472", _7k],
            ["3473", _7k],
            ["3474", _7k],
            ["3475", _7k],
            ["3480", _7t],
            ["3481", _7t],
            ["3482", _7t],
            ["3483", _7t],
            ["3484", _7t],
            ["3485", _7t],
            ["3490", _82],
            ["3491", _82],
            ["3492", _82],
            ["3493", _82],
            ["3494", _82],
            ["3495", _82],
            ["3500", _8B],
            ["3501", _8B],
            ["3502", _8B],
            ["3503", _8B],
            ["3504", _8B],
            ["3505", _8B],
            ["3510", _8K],
            ["3511", _8K],
            ["3512", _8K],
            ["3513", _8K],
            ["3514", _8K],
            ["3515", _8K],
            ["3520", _8T],
            ["3521", _8T],
            ["3522", _8T],
            ["3523", _8T],
            ["3524", _8T],
            ["3525", _8T],
            ["3530", _8c],
            ["3531", _8c],
            ["3532", _8c],
            ["3533", _8c],
            ["3534", _8c],
            ["3535", _8c],
            ["3540", _8l],
            ["3541", _8l],
            ["3542", _8l],
            ["3543", _8l],
            ["3544", _8l],
            ["3545", _8l],
            ["3550", _8u],
            ["3551", _8u],
            ["3552", _8u],
            ["3553", _8u],
            ["3554", _8u],
            ["3555", _8u],
            ["3560", _93],
            ["3561", _93],
            ["3562", _93],
            ["3563", _93],
            ["3564", _93],
            ["3565", _93],
            ["3570", _9C],
            ["3571", _9C],
            ["3572", _9C],
            ["3573", _9C],
            ["3574", _9C],
            ["3575", _9C],
            ["3600", _9L],
            ["3601", _9L],
            ["3602", _9L],
            ["3603", _9L],
            ["3604", _9L],
            ["3605", _9L],
            ["3610", _9U],
            ["3611", _9U],
            ["3612", _9U],
            ["3613", _9U],
            ["3614", _9U],
            ["3615", _9U],
            ["3620", _9d],
            ["3621", _9d],
            ["3622", _9d],
            ["3623", _9d],
            ["3624", _9d],
            ["3625", _9d],
            ["3630", _9m],
            ["3631", _9m],
            ["3632", _9m],
            ["3633", _9m],
            ["3634", _9m],
            ["3635", _9m],
            ["3640", _9v],
            ["3641", _9v],
            ["3642", _9v],
            ["3643", _9v],
            ["3644", _9v],
            ["3645", _9v],
            ["3650", _A4],
            ["3651", _A4],
            ["3652", _A4],
            ["3653", _A4],
            ["3654", _A4],
            ["3655", _A4],
            ["3660", _AD],
            ["3661", _AD],
            ["3662", _AD],
            ["3663", _AD],
            ["3664", _AD],
            ["3665", _AD],
            ["3670", _AM],
            ["3671", _AM],
            ["3672", _AM],
            ["3673", _AM],
            ["3674", _AM],
            ["3675", _AM],
            ["3680", _AV],
            ["3681", _AV],
            ["3682", _AV],
            ["3683", _AV],
            ["3684", _AV],
            ["3685", _AV],
            ["3690", _Ae],
            ["3691", _Ae],
            ["3692", _Ae],
            ["3693", _Ae],
            ["3694", _Ae],
            ["3695", _Ae],
            ["37", _Ao],
            ["3900", _Ax],
            ["3901", _Ax],
            ["3902", _Ax],
            ["3903", _Ax],
            ["3904", _Ax],
            ["3905", _Ax],
            ["3906", _Ax],
            ["3907", _Ax],
            ["3908", _Ax],
            ["3909", _Ax],
            ["3910", _B7],
            ["3911", _B7],
            ["3912", _B7],
            ["3913", _B7],
            ["3914", _B7],
            ["3915", _B7],
            ["3916", _B7],
            ["3917", _B7],
            ["3918", _B7],
            ["3919", _B7],
            ["3920", _BL],
            ["3921", _BL],
            ["3922", _BL],
            ["3923", _BL],
            ["3924", _BL],
            ["3925", _BL],
            ["3926", _BL],
            ["3927", _BL],
            ["3928", _BL],
            ["3929", _BL],
            ["3930", _BZ],
            ["3931", _BZ],
            ["3932", _BZ],
            ["3933", _BZ],
            ["3934", _BZ],
            ["3935", _BZ],
            ["3936", _BZ],
            ["3937", _BZ],
            ["3938", _BZ],
            ["3939", _BZ],
            ["3940", _Bh],
            ["3941", _Bh],
            ["3942", _Bh],
            ["3943", _Bh],
            ["3950", _Bt],
            ["3951", _Bt],
            ["3952", _Bt],
            ["3953", _Bt],
            ["3954", _Bt],
            ["3955", _Bt],
            ["400", _Bx],
            ["401", _C2],
            ["402", _C7],
            ["403", _CE],
            ["410", _CI],
            ["411", _CI],
            ["412", _CI],
            ["413", _CI],
            ["414", _CP],
            ["415", _CY],
            ["416", _Cc],
            ["417", _Ci],
            ["420", _Cn],
            ["421", _Cu],
            ["422", _D5],
            ["423", _DE],
            ["424", _DN],
            ["425", _DW],
            ["426", _De],
            ["427", _Do],
            ["4300", _Dv],
            ["4301", _Dv],
            ["4302", _E2],
            ["4303", _E9],
            ["4304", _EG],
            ["4305", _EG],
            ["4306", _EG],
            ["4307", _EN],
            ["4308", _EU],
            ["4309", _Ed],
            ["4310", _Ek],
            ["4311", _Ek],
            ["4312", _Er],
            ["4313", _Ey],
            ["4314", _F5],
            ["4315", _F5],
            ["4316", _F5],
            ["4317", _FC],
            ["4318", _FJ],
            ["4319", _FQ],
            ["4320", _FX],
            ["4321", _Fe],
            ["4322", _Fe],
            ["4323", _Fe],
            ["4324", _Fn],
            ["4325", _Fn],
            ["4326", _Fu],
            ["4330", _G4],
            ["4331", _GE],
            ["4332", _GO],
            ["4333", _GY],
            ["7001", _Gi],
            ["7002", _Gq],
            ["7003", _H0],
            ["7004", _H9],
            ["7005", _HH],
            ["7006", _HP],
            ["7007", _HZ],
            ["7008", _Hh],
            ["7009", _Hp],
            ["7010", _Hx],
            ["7011", _I7],
            ["7020", _IH],
            ["7021", _IP],
            ["7022", _IW],
            ["7023", _Ia],
            ["7030", _Ik],
            ["7031", _Ik],
            ["7032", _Ik],
            ["7033", _Ik],
            ["7034", _Ik],
            ["7035", _Ik],
            ["7036", _Ik],
            ["7037", _Ik],
            ["7038", _Ik],
            ["7039", _Ik],
            ["7040", _Iu],
            ["710", _J1],
            ["711", _J1],
            ["712", _J1],
            ["713", _J1],
            ["714", _J1],
            ["715", _J1],
            ["7230", _JB],
            ["7231", _JB],
            ["7232", _JB],
            ["7233", _JB],
            ["7234", _JB],
            ["7235", _JB],
            ["7236", _JB],
            ["7237", _JB],
            ["7238", _JB],
            ["7239", _JB],
            ["7240", _JJ],
            ["7241", _JR],
            ["7242", _JZ],
            ["7250", _Jh],
            ["7251", _Jr],
            ["7252", _Jy],
            ["7253", _K7],
            ["7254", _K7],
            ["7255", _KG],
            ["7256", _KO],
            ["7257", _KV],
            ["7258", _Kc],
            ["7259", _Kk],
            ["8001", _Kz],
            ["8002", _L3],
            ["8003", _LC],
            ["8004", _LI],
            ["8005", _LQ],
            ["8006", _LZ],
            ["8007", _Lg],
            ["8008", _Lq],
            ["8009", _Ly],
            ["8010", _M4],
            ["8011", _MB],
            ["8012", _MJ],
            ["8013", _MO],
            ["8014", _MV],
            ["8017", _Mc],
            ["8018", _Mj],
            ["8019", _Mr],
            ["8020", _My],
            ["8026", _N8],
            ["8030", _NO],
            ["8110", _NS],
            ["8111", _NZ],
            ["8112", _Nd],
            ["8200", _Nk],
            ["90", _No],
            ["91", _Ns],
            ["92", _Ns],
            ["93", _Ns],
            ["94", _Ns],
            ["95", _Ns],
            ["96", _Ns],
            ["97", _Ns],
            ["98", _Ns],
            ["99", _Ns]
        ]); //#2466
        $_.gs1syntax = _Nt; //#2468
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_gs1process.$ctx[id] = $_[id]); //#2468
        bwipp_gs1process.__2469__ = 1; //#2468
        $_ = Object.getPrototypeOf($_); //#2468
    } //#2468
    if ($eq($k[--$j], 'ai')) { //#2700
        $anchorsearch($k[--$j], "("); //#2476
        if ($nt($k[--$j])) { //#2478
            $j--; //#2477
            $k[$j++] = 'bwipp.GS1aiMissingOpenParen#2477'; //#2477
            $k[$j++] = "AIs must start with '('"; //#2477
            bwipp_raiseerror(); //#2477
        } //#2477
        $j--; //#2479
        $k[$j++] = Infinity; //#2480
        var _Ny = $k[--$j]; //#2480
        var _Nz = $k[--$j]; //#2480
        $k[$j++] = _Ny; //#2487
        $k[$j++] = _Nz; //#2487
        for (;;) { //#2487
            var _O0 = $k[--$j]; //#2481
            $k[$j++] = _O0; //#2481
            if ($eq(_O0, "")) { //#2481
                $j--; //#2481
                break; //#2481
            } //#2481
            $search($k[--$j], ")"); //#2482
            if ($nt($k[--$j])) { //#2484
                $cleartomark(); //#2483
                $k[$j++] = 'bwipp.GS1aiMissingCloseParen#2483'; //#2483
                $k[$j++] = "AIs must end with ')'"; //#2483
                bwipp_raiseerror(); //#2483
            } //#2483
            var _O3 = $k[--$j]; //#2485
            var _O4 = $k[--$j]; //#2485
            $k[$j++] = _O3; //#2485
            $k[$j++] = _O4; //#2485
            $j--; //#2485
            var _O5 = $k[--$j]; //#2485
            var _O6 = $k[--$j]; //#2485
            $k[$j++] = _O5; //#2486
            $search(_O6, "("); //#2486
            if ($k[--$j]) { //#2486
                var _O8 = $k[--$j]; //#2486
                var _O9 = $k[--$j]; //#2486
                $k[$j++] = _O8; //#2486
                $k[$j++] = _O9; //#2486
                $j--; //#2486
                var _OA = $k[--$j]; //#2486
                var _OB = $k[--$j]; //#2486
                $k[$j++] = _OA; //#2486
                $k[$j++] = _OB; //#2486
            } else { //#2486
                $k[$j++] = ""; //#2486
            } //#2486
        } //#2486
        var _OC = $counttomark(); //#2488
        $k[$j++] = _OC; //#2488
        if (_OC > 0) { //#2488
            var _OD = $k[--$j]; //#2488
            for (var _OF = _OD, _OE = (~~(_OD / 2)) + 1; _OF >= _OE; _OF -= 1) { //#2488
                $r(_OF, -1); //#2488
            } //#2488
        } else { //#2488
            $j--; //#2488
        } //#2488
        $astore($a(~~($counttomark() / 2))); //#2489
        $_.ais = $k[--$j]; //#2489
        $astore($a($counttomark())); //#2490
        $k[$j++] = Infinity; //#2490
        var _OL = $k[--$j]; //#2490
        var _OM = $k[--$j]; //#2490
        $k[$j++] = _OL; //#2492
        $forall(_OM, function() { //#2492
            var _OO = new Map([
                ["parse", $_.parse],
                ["parseonly", true],
                ["parsefnc", false]
            ]); //#2491
            $k[$j++] = _OO; //#2491
            bwipp_parseinput(); //#2491
        }); //#2491
        $_.vals = $a(); //#2492
        $j--; //#2493
    } else { //#2700
        $anchorsearch($k[--$j], "http://"); //#2498
        if ($nt($k[--$j])) { //#2503
            $anchorsearch($k[--$j], "HTTP://"); //#2499
            if ($nt($k[--$j])) { //#2503
                $anchorsearch($k[--$j], "https://"); //#2500
                if ($nt($k[--$j])) { //#2503
                    $anchorsearch($k[--$j], "HTTPS://"); //#2501
                    if ($nt($k[--$j])) { //#2503
                        $j--; //#2502
                        $k[$j++] = 'bwipp.GS1dlURIbadScheme#2502'; //#2502
                        $k[$j++] = "Scheme must be http:// HTTP:// https:// or HTTPS://"; //#2502
                        bwipp_raiseerror(); //#2502
                    } //#2502
                } //#2502
            } //#2502
        } //#2502
        $j--; //#2504
        $search($k[--$j], "/"); //#2507
        if ($nt($k[--$j])) { //#2509
            $j--; //#2508
            $k[$j++] = 'bwipp.GS1dlMissingDomainOrPathInfo#2508'; //#2508
            $k[$j++] = "URI must contain a domain and path info"; //#2508
            bwipp_raiseerror(); //#2508
        } //#2508
        $j -= 2; //#2510
        $search($k[--$j], "#"); //#2513
        if ($k[--$j]) { //#2515
            var _Oc = $k[--$j]; //#2514
            var _Od = $k[--$j]; //#2514
            $k[$j++] = _Oc; //#2514
            $k[$j++] = _Od; //#2514
            $j--; //#2514
            var _Oe = $k[--$j]; //#2514
            var _Of = $k[--$j]; //#2514
            $k[$j++] = _Oe; //#2514
            $k[$j++] = _Of; //#2514
            $j--; //#2514
        } //#2514
        $search($k[--$j], "?"); //#2518
        if ($nt($k[--$j])) { //#2520
            var _Oi = $k[--$j]; //#2519
            $k[$j++] = ""; //#2519
            $k[$j++] = null; //#2519
            $k[$j++] = _Oi; //#2519
        } //#2519
        $_.pp = $k[--$j]; //#2521
        $j--; //#2522
        $_.qp = $k[--$j]; //#2523
        $k[$j++] = Infinity; //#2526
        $k[$j++] = 0; //#2530
        $k[$j++] = 0; //#2530
        $k[$j++] = $_.pp; //#2530
        for (;;) { //#2530
            $search($k[--$j], "/"); //#2528
            if ($nt($k[--$j])) { //#2528
                $j--; //#2528
                break; //#2528
            } //#2528
            var _Oo = $k[--$j]; //#2529
            var _Op = $k[--$j]; //#2529
            $k[$j++] = _Oo.length + 1; //#2529
            $k[$j++] = _Op; //#2529
            $j--; //#2529
            var _Oq = $k[--$j]; //#2529
            var _Or = $k[--$j]; //#2529
            var _Os = $k[--$j]; //#2529
            $k[$j++] = _Os; //#2529
            $k[$j++] = $f(_Oq + _Os); //#2529
            $k[$j++] = _Or; //#2529
        } //#2529
        $astore($a($counttomark() - 1)); //#2531
        $_.pipos = $k[--$j]; //#2531
        $j -= 2; //#2531
        if ($_.pipos.length <= 1) { //#2534
            $k[$j++] = 'bwipp.GS1dlNoAIinfo#2533'; //#2533
            $k[$j++] = "The path was too short to contain AI info"; //#2533
            bwipp_raiseerror(); //#2533
        } //#2533
        $k[$j++] = false; //#2550
        for (var _Oy = $_.pipos.length - 2; _Oy >= 0; _Oy -= 2) { //#2550
            var _P0 = $get($_.pipos, _Oy); //#2540
            var _P4 = $geti($_.pp, _P0, $f($f($get($_.pipos, _Oy + 1) - _P0) - 1)); //#2541
            var _P6 = $get($_.gs1syntax, _P4) !== undefined; //#2542
            $k[$j++] = _Oy; //#2548
            $k[$j++] = _P4; //#2548
            if (_P6) { //#2547
                var _PA = $get($get($_.gs1syntax, $k[--$j]), 'dlpkey') !== undefined; //#2543
                if (_PA) { //#2545
                    var _PB = $k[--$j]; //#2544
                    var _PC = $k[--$j]; //#2544
                    $k[$j++] = _PB; //#2544
                    $k[$j++] = _PC; //#2544
                    $j--; //#2544
                    $k[$j++] = true; //#2544
                    break; //#2544
                } //#2544
            } else { //#2547
                $j--; //#2547
            } //#2547
            $j--; //#2549
        } //#2549
        if ($nt($k[--$j])) { //#2553
            $k[$j++] = 'bwipp.GS1dlNoAIinfo#2552'; //#2552
            $k[$j++] = "The path does not contain a valid primary key"; //#2552
            bwipp_raiseerror(); //#2552
        } //#2552
        var _PG = $get($_.pipos, $k[--$j]); //#2554
        $_.pp = $geti($_.pp, _PG, $f($_.pp.length - _PG)); //#2554
        $_.uriunescape = function() {
            $_.qq = $k[--$j]; //#2557
            $_.in = $k[--$j]; //#2558
            $_.out = $s($_.in.length); //#2559
            $k[$j++] = 0; //#2583
            $k[$j++] = 0; //#2583
            for (;;) { //#2583
                var _PO = $k[--$j]; //#2561
                var _PP = $k[--$j]; //#2561
                $k[$j++] = _PP; //#2561
                $k[$j++] = _PO; //#2561
                if (_PP >= $_.in.length) { //#2561
                    break; //#2561
                } //#2561
                var _PS = $k[--$j]; //#2562
                var _PT = $k[--$j]; //#2562
                var _PU = $get($_.in, _PT); //#2562
                $k[$j++] = _PT; //#2582
                $k[$j++] = _PS; //#2582
                $k[$j++] = _PU; //#2582
                if ((_PU == 43) && $_.qq) { //#2581
                    $j--; //#2564
                    var _PX = $k[--$j]; //#2564
                    $put($_.out, _PX, 32); //#2564
                    var _PY = $k[--$j]; //#2565
                    $k[$j++] = $f(_PY + 1); //#2565
                    $k[$j++] = $f(_PX + 1); //#2565
                } else { //#2581
                    var _PZ = $k[--$j]; //#2567
                    var _Pa = $k[--$j]; //#2567
                    var _Pb = $k[--$j]; //#2567
                    $k[$j++] = _Pb; //#2582
                    $k[$j++] = _Pa; //#2582
                    $k[$j++] = _PZ; //#2582
                    if ((_PZ == 37) && (_Pb < ($_.in.length - 2))) { //#2581
                        $j--; //#2568
                        var _Pe = $k[--$j]; //#2569
                        var _Pf = $k[--$j]; //#2569
                        var _Pg = $geti($_.in, $f(_Pf + 1), 2); //#2569
                        $k[$j++] = _Pf; //#2576
                        $k[$j++] = _Pe; //#2576
                        $k[$j++] = 0; //#2576
                        for (var _Ph = 0, _Pi = _Pg.length; _Ph < _Pi; _Ph++) { //#2576
                            var _Pj = $get(_Pg, _Ph); //#2576
                            $k[$j++] = _Pj; //#2574
                            if ((_Pj >= 48) && (_Pj <= 57)) { //#2573
                                var _Pk = $k[--$j]; //#2570
                                $k[$j++] = $f(_Pk - 48); //#2570
                            } else { //#2573
                                var _Pl = $k[--$j]; //#2571
                                $k[$j++] = _Pl; //#2574
                                if ((_Pl >= 65) && (_Pl <= 70)) { //#2573
                                    var _Pm = $k[--$j]; //#2571
                                    $k[$j++] = $f(_Pm - 55); //#2571
                                } else { //#2573
                                    var _Pn = $k[--$j]; //#2572
                                    $k[$j++] = _Pn; //#2574
                                    if ((_Pn >= 97) && (_Pn <= 102)) { //#2573
                                        var _Po = $k[--$j]; //#2572
                                        $k[$j++] = $f(_Po - 87); //#2572
                                    } else { //#2573
                                        $j -= 2; //#2573
                                        $k[$j++] = 'bwipp.GS1dlBadHexCharacter#2573'; //#2573
                                        $k[$j++] = "Invalid hex character"; //#2573
                                        bwipp_raiseerror(); //#2573
                                    } //#2573
                                } //#2573
                            } //#2573
                            var _Pp = $k[--$j]; //#2575
                            var _Pq = $k[--$j]; //#2575
                            $k[$j++] = $f(_Pp + (_Pq * 16)); //#2575
                        } //#2575
                        var _Ps = $k[--$j]; //#2577
                        var _Pt = $k[--$j]; //#2577
                        $put($_.out, _Pt, _Ps); //#2577
                        var _Pu = $k[--$j]; //#2578
                        $k[$j++] = $f(_Pu + 3); //#2578
                        $k[$j++] = $f(_Pt + 1); //#2578
                    } else { //#2581
                        var _Pw = $k[--$j]; //#2580
                        var _Px = $k[--$j]; //#2580
                        $put($_.out, _Px, _Pw); //#2580
                        var _Py = $k[--$j]; //#2581
                        $k[$j++] = $f(_Py + 1); //#2581
                        $k[$j++] = $f(_Px + 1); //#2581
                    } //#2581
                } //#2581
            } //#2581
            $_.out = $geti($_.out, 0, $k[--$j]); //#2584
            $j--; //#2585
            $k[$j++] = $_.out; //#2586
        }; //#2586
        $_.isvaliddlpkeyseq = function() {
            $_.in = $k[--$j]; //#2590
            $k[$j++] = false; //#2604
            $forall($get($get($_.gs1syntax, $get($_.in, 0)), 'dlpkey'), function() { //#2604
                $_.seq = $k[--$j]; //#2593
                $_.i = 1; //#2594
                $_.j = 0; //#2594
                for (;;) { //#2602
                    if ($_.i >= $_.in.length) { //#2596
                        break; //#2596
                    } //#2596
                    if ($_.j >= $_.seq.length) { //#2597
                        break; //#2597
                    } //#2597
                    if ($eq($get($_.in, $_.i), $get($_.seq, $_.j))) { //#2600
                        $_.i = $_.i + 1; //#2599
                    } //#2599
                    $_.j = $_.j + 1; //#2601
                } //#2601
                if ($_.i == $_.in.length) { //#2603
                    $j--; //#2603
                    $k[$j++] = true; //#2603
                    return true; //#2603
                } //#2603
            }); //#2603
        }; //#2603
        $_.ais = $a(99); //#2607
        $_.vals = $a(99); //#2608
        $k[$j++] = 0; //#2622
        $k[$j++] = $_.pp; //#2622
        for (;;) { //#2622
            $search($k[--$j], "/"); //#2613
            if ($k[--$j]) { //#2619
                var _QU = $k[--$j]; //#2614
                var _QV = $k[--$j]; //#2614
                var _QW = $k[--$j]; //#2614
                var _QX = $k[--$j]; //#2614
                $put($_.ais, _QX, _QU); //#2614
                $k[$j++] = _QX; //#2616
                $search(_QW, "/"); //#2616
                if ($k[--$j]) { //#2616
                    var _QZ = $k[--$j]; //#2616
                    var _Qa = $k[--$j]; //#2616
                    $k[$j++] = _QZ; //#2616
                    $k[$j++] = _Qa; //#2616
                    $j--; //#2616
                } else { //#2616
                    var _Qb = $k[--$j]; //#2616
                    $k[$j++] = ""; //#2616
                    $k[$j++] = _Qb; //#2616
                } //#2616
                var _Qd = $k[--$j]; //#2617
                var _Qe = $k[--$j]; //#2617
                var _Qf = $k[--$j]; //#2617
                $k[$j++] = _Qf; //#2617
                $k[$j++] = _Qe; //#2617
                $k[$j++] = $_.vals; //#2617
                $k[$j++] = _Qf; //#2617
                $k[$j++] = _Qd; //#2617
                $k[$j++] = false; //#2617
                $_.uriunescape(); //#2617
                var _Qg = $k[--$j]; //#2617
                var _Qh = $k[--$j]; //#2617
                $put($k[--$j], _Qh, _Qg); //#2617
            } else { //#2619
                $j--; //#2619
                break; //#2619
            } //#2619
            var _Qj = $k[--$j]; //#2621
            var _Qk = $k[--$j]; //#2621
            $k[$j++] = $f(_Qk + 1); //#2621
            $k[$j++] = _Qj; //#2621
        } //#2621
        var _Ql = $k[--$j]; //#2623
        $_.plen = _Ql; //#2623
        $k[$j++] = _Ql; //#2630
        if (_Ql > 1) { //#2630
            $k[$j++] = $geti($_.ais, 0, $_.plen); //#2627
            $_.isvaliddlpkeyseq(); //#2627
            if ($nt($k[--$j])) { //#2629
                $j--; //#2628
                $k[$j++] = 'bwipp.GS1dlBadPathInfo#2628'; //#2628
                $k[$j++] = "The AIs in the path are not a valid key-qualifier sequence for the key"; //#2628
                bwipp_raiseerror(); //#2628
            } //#2628
        } //#2628
        $k[$j++] = $_.qp; //#2648
        for (;;) { //#2648
            var _Qr = $k[--$j]; //#2634
            $k[$j++] = _Qr; //#2634
            if ($eq(_Qr, "")) { //#2634
                $j--; //#2634
                break; //#2634
            } //#2634
            $search($k[--$j], "&"); //#2635
            if ($k[--$j]) { //#2635
                var _Qu = $k[--$j]; //#2635
                var _Qv = $k[--$j]; //#2635
                $k[$j++] = _Qu; //#2635
                $k[$j++] = _Qv; //#2635
                $j--; //#2635
            } else { //#2635
                var _Qw = $k[--$j]; //#2635
                $k[$j++] = ""; //#2635
                $k[$j++] = _Qw; //#2635
            } //#2635
            $search($k[--$j], "="); //#2636
            if ($k[--$j]) { //#2646
                var _Qz = $k[--$j]; //#2637
                $k[$j++] = _Qz; //#2637
                $k[$j++] = true; //#2637
                $forall(_Qz, function() { //#2637
                    var _R0 = $k[--$j]; //#2637
                    var _R1 = $k[--$j]; //#2637
                    $k[$j++] = _R1 && ((_R0 >= 48) && (_R0 <= 57)); //#2637
                }); //#2637
                if ($k[--$j]) { //#2643
                    var _R4 = $k[--$j]; //#2638
                    var _R5 = $k[--$j]; //#2638
                    var _R6 = $k[--$j]; //#2638
                    var _R7 = $k[--$j]; //#2638
                    var _R8 = $k[--$j]; //#2638
                    $put($_.ais, _R8, _R4); //#2638
                    $k[$j++] = _R8; //#2640
                    $k[$j++] = _R7; //#2640
                    $k[$j++] = $_.vals; //#2640
                    $k[$j++] = _R8; //#2640
                    $k[$j++] = _R6; //#2640
                    $k[$j++] = true; //#2640
                    $_.uriunescape(); //#2640
                    var _RA = $k[--$j]; //#2640
                    var _RB = $k[--$j]; //#2640
                    $put($k[--$j], _RB, _RA); //#2640
                    var _RD = $k[--$j]; //#2641
                    var _RE = $k[--$j]; //#2641
                    $k[$j++] = $f(_RE + 1); //#2641
                    $k[$j++] = _RD; //#2641
                } else { //#2643
                    $j -= 3; //#2643
                } //#2643
            } else { //#2646
                $j--; //#2646
            } //#2646
        } //#2646
        var _RH = $k[--$j]; //#2651
        var _RJ = $geti($_.ais, $_.plen, $f(_RH - $_.plen)); //#2651
        $k[$j++] = _RH; //#2665
        for (var _RK = 0, _RL = _RJ.length; _RK < _RL; _RK++) { //#2665
            var _RM = $get(_RJ, _RK); //#2665
            var _RO = $get($_.gs1syntax, _RM) !== undefined; //#2652
            $k[$j++] = _RM; //#2656
            if (_RO) { //#2655
                var _RQ = $k[--$j]; //#2653
                var _RR = $get($_.gs1syntax, _RQ); //#2653
                var _RS = $get(_RR, 'dlattr') !== undefined; //#2653
                $k[$j++] = _RQ; //#2653
                $k[$j++] = _RR; //#2653
                $k[$j++] = 'dlattr'; //#2653
                if (_RS) { //#2653
                    var _RT = $k[--$j]; //#2653
                    var _RV = $get($k[--$j], _RT); //#2653
                    $k[$j++] = _RV; //#2653
                } else { //#2653
                    $j -= 2; //#2653
                    $k[$j++] = true; //#2653
                } //#2653
            } else { //#2655
                $k[$j++] = $_.dontlint; //#2655
            } //#2655
            if ($nt($k[--$j])) { //#2663
                var _RY = $k[--$j]; //#2658
                var _RZ = _RY.length; //#2658
                var _Ra = $s(_RZ + 46); //#2658
                $puti(_Ra, 0, "AI ("); //#2659
                $puti(_Ra, 4, _RY); //#2660
                $puti(_Ra, _RZ + 4, ") is not a valid GS1 DL URI data attribute"); //#2661
                $k[$j++] = _RY; //#2662
                $k[$j++] = _Ra; //#2662
                $k[$j++] = _RZ; //#2662
                $j--; //#2662
                var _Rb = $k[--$j]; //#2662
                var _Rc = $k[--$j]; //#2662
                $k[$j++] = _Rb; //#2662
                $k[$j++] = _Rc; //#2662
                $j--; //#2662
                var _Rd = $k[--$j]; //#2662
                $k[$j++] = 'bwipp.GS1dlInvalidDataAttribute#2662'; //#2662
                $k[$j++] = _Rd; //#2662
                bwipp_raiseerror(); //#2662
            } //#2662
            $j--; //#2664
        } //#2664
        var _Rg = $k[--$j]; //#2668
        var _Ri = $geti($_.ais, $_.plen, $f(_Rg - $_.plen)); //#2668
        $k[$j++] = _Rg; //#2683
        for (var _Rj = 0, _Rk = _Ri.length; _Rj < _Rk; _Rj++) { //#2683
            $k[$j++] = $get(_Ri, _Rj); //#2681
            for (var _Rn = $_.plen; _Rn >= 1; _Rn -= 1) { //#2681
                var _Ro = $k[--$j]; //#2670
                $k[$j++] = _Ro; //#2672
                $k[$j++] = _Rn; //#2672
                $k[$j++] = _Ro; //#2672
                $k[$j++] = Infinity; //#2670
                $aload($geti($_.ais, 0, $_.plen)); //#2671
                $r($counttomark() + 3, -2); //#2672
                var _Rt = $k[--$j]; //#2672
                var _Ru = $k[--$j]; //#2672
                $k[$j++] = _Rt; //#2672
                $r(_Ru, 1); //#2672
                var _Rv = $a(); //#2672
                $k[$j++] = _Rv; //#2673
                $_.isvaliddlpkeyseq(); //#2673
                if ($k[--$j]) { //#2680
                    var _Rx = $k[--$j]; //#2674
                    var _Ry = $k[--$j]; //#2674
                    $k[$j++] = _Rx; //#2674
                    $k[$j++] = _Ry; //#2674
                    $j--; //#2674
                    var _Rz = $k[--$j]; //#2675
                    var _S0 = _Rz.length; //#2675
                    var _S1 = $s(_S0 + 50); //#2675
                    $puti(_S1, 0, "AI ("); //#2676
                    $puti(_S1, 4, _Rz); //#2677
                    $puti(_S1, _S0 + 4, ") from query params should be in the path info"); //#2678
                    $k[$j++] = _Rz; //#2679
                    $k[$j++] = _S1; //#2679
                    $k[$j++] = _S0; //#2679
                    $j--; //#2679
                    var _S2 = $k[--$j]; //#2679
                    var _S3 = $k[--$j]; //#2679
                    $k[$j++] = _S2; //#2679
                    $k[$j++] = _S3; //#2679
                    $j--; //#2679
                    var _S4 = $k[--$j]; //#2679
                    $k[$j++] = 'bwipp.GS1dlAttributeMustBeQualifier#2679'; //#2679
                    $k[$j++] = _S4; //#2679
                    bwipp_raiseerror(); //#2679
                } //#2679
            } //#2679
            $j--; //#2682
        } //#2682
        var _S6 = $k[--$j]; //#2685
        $_.ais = $geti($_.ais, 0, _S6); //#2685
        $_.vals = $geti($_.vals, 0, _S6); //#2686
        for (var _SC = 0, _SB = $_.ais.length - 1; _SC <= _SB; _SC += 1) { //#2701
            $k[$j++] = _SC; //#2699
            if ($eq($get($_.ais, _SC), "01")) { //#2699
                var _SF = $k[--$j]; //#2692
                var _SH = $get($_.vals, _SF); //#2692
                var _SI = _SH.length; //#2693
                $k[$j++] = _SF; //#2698
                $k[$j++] = _SH; //#2698
                if ((_SI == 8) || ((_SI == 12) || (_SI == 13))) { //#2697
                    var _SK = $strcpy($s(14), "00000000000000"); //#2694
                    var _SL = $k[--$j]; //#2694
                    $puti(_SK, 14 - _SL.length, _SL); //#2694
                    var _SN = $k[--$j]; //#2695
                    $put($_.vals, _SN, _SK); //#2695
                    $k[$j++] = _SN; //#2695
                } else { //#2697
                    $j--; //#2697
                } //#2697
            } //#2697
            $j--; //#2700
        } //#2700
    } //#2700
    if (!bwipp_gs1process.__2714__) { //#2714
        $_ = Object.create($_); //#2714
        $k[$j++] = Infinity; //#2707
        var _SO = $a(["00", "01", "02", "03", "04", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "31", "32", "33", "34", "35", "36", "41"]); //#2712
        for (var _SP = 0, _SQ = _SO.length; _SP < _SQ; _SP++) { //#2713
            var _SR = $get(_SO, _SP); //#2713
            $k[$j++] = _SR; //#2713
            $k[$j++] = _SR; //#2713
        } //#2713
        $_.aifixed = $d(); //#2713
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_gs1process.$ctx[id] = $_[id]); //#2713
        bwipp_gs1process.__2714__ = 1; //#2713
        $_ = Object.getPrototypeOf($_); //#2713
    } //#2713
    $k[$j++] = Infinity; //#2716
    var _SU = $_.ais; //#2717
    for (var _SV = 0, _SW = _SU.length; _SV < _SW; _SV++) { //#2724
        var _SX = $get(_SU, _SV); //#2724
        $k[$j++] = true; //#2723
        $k[$j++] = _SX; //#2723
        if (_SX.length >= 2) { //#2722
            var _Sb = $get($_.aifixed, $geti($k[--$j], 0, 2)) !== undefined; //#2720
            if (_Sb) { //#2720
                $j--; //#2720
                $k[$j++] = false; //#2720
            } //#2720
        } else { //#2722
            $j--; //#2722
        } //#2722
    } //#2722
    $_.fncs = $a(); //#2722
    if (!bwipp_gs1process.__2749__) { //#2749
        $_ = Object.create($_); //#2749
        $k[$j++] = Infinity; //#2730
        $k[$j++] = 0; //#2732
        for (var _Sd = 0, _Se = "!\"%&'()*+,-./0123456789:;<=>?ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz".length; _Sd < _Se; _Sd++) { //#2732
            var _Sg = $k[--$j]; //#2732
            $k[$j++] = $get("!\"%&'()*+,-./0123456789:;<=>?ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz", _Sd); //#2732
            $k[$j++] = _Sg; //#2732
            $k[$j++] = $f(_Sg + 1); //#2732
        } //#2732
        $j--; //#2732
        $_.cset82 = $d(); //#2733
        $k[$j++] = Infinity; //#2735
        $k[$j++] = 0; //#2737
        for (var _Si = 0, _Sj = "#-/0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".length; _Si < _Sj; _Si++) { //#2737
            var _Sl = $k[--$j]; //#2737
            $k[$j++] = $get("#-/0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ", _Si); //#2737
            $k[$j++] = _Sl; //#2737
            $k[$j++] = $f(_Sl + 1); //#2737
        } //#2737
        $j--; //#2737
        $_.cset39 = $d(); //#2738
        $k[$j++] = Infinity; //#2740
        $k[$j++] = 0; //#2742
        for (var _Sn = 0, _So = "23456789ABCDEFGHJKLMNPQRSTUVWXYZ".length; _Sn < _So; _Sn++) { //#2742
            var _Sq = $k[--$j]; //#2742
            $k[$j++] = $get("23456789ABCDEFGHJKLMNPQRSTUVWXYZ", _Sn); //#2742
            $k[$j++] = _Sq; //#2742
            $k[$j++] = $f(_Sq + 1); //#2742
        } //#2742
        $j--; //#2742
        $_.cset32 = $d(); //#2743
        $k[$j++] = Infinity; //#2745
        $k[$j++] = 0; //#2747
        for (var _Ss = 0, _St = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_".length; _Ss < _St; _Ss++) { //#2747
            var _Sv = $k[--$j]; //#2747
            $k[$j++] = $get("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_", _Ss); //#2747
            $k[$j++] = _Sv; //#2747
            $k[$j++] = $f(_Sv + 1); //#2747
        } //#2747
        $j--; //#2747
        $_.cset64 = $d(); //#2748
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_gs1process.$ctx[id] = $_[id]); //#2748
        bwipp_gs1process.__2749__ = 1; //#2748
        $_ = Object.getPrototypeOf($_); //#2748
    } //#2748
    $_.lintnumeric = function() {
        var _Sy = $k[--$j]; //#2752
        $k[$j++] = true; //#2752
        $forall(_Sy, function() { //#2752
            var _Sz = $k[--$j]; //#2752
            if ((_Sz < 48) || (_Sz > 57)) { //#2752
                $j--; //#2752
                $k[$j++] = false; //#2752
                return true; //#2752
            } //#2752
        }); //#2752
        if ($nt($k[--$j])) { //#2753
            $j--; //#2753
            $k[$j++] = 'bwipp.GS1notNumeric#2753'; //#2753
            $k[$j++] = "Not numeric"; //#2753
            $k[$j++] = false; //#2753
            return true; //#2753
        } //#2753
    }; //#2753
    $_.lintcset82 = function() {
        var _T1 = $k[--$j]; //#2757
        $k[$j++] = true; //#2757
        $forall(_T1, function() { //#2757
            var _T4 = $get($_.cset82, $k[--$j]) !== undefined; //#2757
            if (!_T4) { //#2757
                $j--; //#2757
                $k[$j++] = false; //#2757
                return true; //#2757
            } //#2757
        }); //#2757
        if ($nt($k[--$j])) { //#2758
            $j--; //#2758
            $k[$j++] = 'bwipp.GS1badCSET82character#2758'; //#2758
            $k[$j++] = "Invalid CSET 82 character"; //#2758
            $k[$j++] = false; //#2758
            return true; //#2758
        } //#2758
    }; //#2758
    $_.lintcset39 = function() {
        var _T6 = $k[--$j]; //#2762
        $k[$j++] = true; //#2762
        $forall(_T6, function() { //#2762
            var _T9 = $get($_.cset39, $k[--$j]) !== undefined; //#2762
            if (!_T9) { //#2762
                $j--; //#2762
                $k[$j++] = false; //#2762
                return true; //#2762
            } //#2762
        }); //#2762
        if ($nt($k[--$j])) { //#2763
            $j--; //#2763
            $k[$j++] = 'bwipp.GS1badCSET39character#2763'; //#2763
            $k[$j++] = "Invalid CSET 39 character"; //#2763
            $k[$j++] = false; //#2763
            return true; //#2763
        } //#2763
    }; //#2763
    $_.lintcset64 = function() {
        var _TB = $k[--$j]; //#2768
        $k[$j++] = true; //#2768
        $forall(_TB, function() { //#2768
            var _TC = $k[--$j]; //#2768
            var _TE = $get($_.cset64, _TC) !== undefined; //#2768
            if ((!_TE) && (_TC != 61)) { //#2768
                $j--; //#2768
                $k[$j++] = false; //#2768
                return true; //#2768
            } //#2768
        }); //#2768
        if ($nt($k[--$j])) { //#2769
            $j--; //#2769
            $k[$j++] = 'bwipp.GS1badCSET64character#2769'; //#2769
            $k[$j++] = "Invalid CSET 64 character"; //#2769
            $k[$j++] = false; //#2769
            return true; //#2769
        } //#2769
    }; //#2769
    $_.lintkey = function() {
        var _TG = $k[--$j]; //#2773
        $k[$j++] = _TG; //#2773
        if (_TG.length < 2) { //#2773
            $j -= 2; //#2773
            $k[$j++] = 'bwipp.GS1keyTooShort#2773'; //#2773
            $k[$j++] = "Key is too short"; //#2773
            $k[$j++] = false; //#2773
            return true; //#2773
        } //#2773
        var _TH = $k[--$j]; //#2774
        var _TI = $get(_TH, 0); //#2774
        var _TJ = $get(_TH, 1); //#2775
        if (((_TI < 48) || (_TI > 57)) || ((_TJ < 48) || (_TJ > 57))) { //#2777
            $j--; //#2776
            $k[$j++] = 'bwipp.GS1badGCP#2776'; //#2776
            $k[$j++] = "Non-numeric company prefix"; //#2776
            $k[$j++] = false; //#2776
            return true; //#2776
        } //#2776
    }; //#2776
    $_.lintimporteridx = function() {
        $search("-0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz", $k[--$j]); //#2782
        if ($nt($k[--$j])) { //#2782
            $j -= 2; //#2782
            $k[$j++] = 'bwipp.GS1badImporterIndex#2782'; //#2782
            $k[$j++] = "Invalid importer index"; //#2782
            $k[$j++] = false; //#2782
            return true; //#2782
        } //#2782
        $j -= 3; //#2783
    }; //#2783
    $_.lintcsum = function() {
        $k[$j++] = Infinity; //#2787
        var _TM = $k[--$j]; //#2787
        var _TN = $k[--$j]; //#2787
        var _TO = ((_TN.length % 2) == 0) ? 3 : 1; //#2788
        $k[$j++] = _TM; //#2789
        $k[$j++] = _TO; //#2789
        $forall(_TN, function() { //#2789
            var _TP = $k[--$j]; //#2789
            var _TQ = $k[--$j]; //#2789
            $k[$j++] = $f(_TP - 48) * _TQ; //#2789
            $k[$j++] = $f(4 - _TQ); //#2789
        }); //#2789
        $j--; //#2789
        var _TR = $counttomark() + 1; //#2790
        $k[$j++] = 0; //#2790
        for (var _TS = 0, _TT = _TR - 1; _TS < _TT; _TS++) { //#2790
            var _TU = $k[--$j]; //#2790
            var _TV = $k[--$j]; //#2790
            $k[$j++] = $f(_TV + _TU); //#2790
        } //#2790
        var _TW = $k[--$j]; //#2790
        var _TX = $k[--$j]; //#2790
        $k[$j++] = _TW; //#2790
        $k[$j++] = _TX; //#2790
        $j--; //#2790
        if (($k[--$j] % 10) != 0) { //#2791
            $j--; //#2791
            $k[$j++] = 'bwipp.GS1badChecksum#2791'; //#2791
            $k[$j++] = "Bad checksum"; //#2791
            $k[$j++] = false; //#2791
            return true; //#2791
        } //#2791
    }; //#2791
    $_.lintcsumalpha = function() {
        var _TZ = $k[--$j]; //#2795
        $k[$j++] = _TZ; //#2795
        if (_TZ.length < 2) { //#2795
            $j -= 2; //#2795
            $k[$j++] = 'bwipp.GS1alphaTooShort#2795'; //#2795
            $k[$j++] = "Alphanumeric string is too short to check"; //#2795
            $k[$j++] = false; //#2795
            return true; //#2795
        } //#2795
        var _Ta = $k[--$j]; //#2796
        $k[$j++] = _Ta; //#2798
        $k[$j++] = _Ta.length - 2; //#2798
        $k[$j++] = $geti(_Ta, 0, _Ta.length - 2); //#2798
        $k[$j++] = Infinity; //#2798
        var _Tc = $k[--$j]; //#2798
        var _Td = $k[--$j]; //#2798
        $k[$j++] = _Tc; //#2800
        $forall(_Td, function() { //#2800
            var _Te = $k[--$j]; //#2799
            var _Tg = $get($_.cset82, _Te) !== undefined; //#2799
            $k[$j++] = _Te; //#2799
            if (_Tg) { //#2799
                var _Tj = $get($_.cset82, $k[--$j]); //#2799
                $k[$j++] = _Tj; //#2799
            } else { //#2799
                $k[$j++] = -1; //#2799
                return true; //#2799
            } //#2799
        }); //#2799
        var _Tk = $k[--$j]; //#2801
        $k[$j++] = _Tk; //#2801
        if (_Tk == -1) { //#2801
            $cleartomark(); //#2801
            $j -= 3; //#2801
            $k[$j++] = 'bwipp.GS1UnknownCSET82Character#2801'; //#2801
            $k[$j++] = "Unknown CSET 82 character"; //#2801
            $k[$j++] = false; //#2801
            return true; //#2801
        } //#2801
        $astore($a($counttomark())); //#2802
        var _Tn = $k[--$j]; //#2802
        var _To = $k[--$j]; //#2802
        $k[$j++] = _Tn; //#2802
        $k[$j++] = _To; //#2802
        $j--; //#2802
        var _Tp = $k[--$j]; //#2803
        var _Tq = $k[--$j]; //#2803
        var _Ts = $geti($k[--$j], _Tq, 2); //#2804
        $k[$j++] = _Tp; //#2804
        $k[$j++] = _Ts; //#2804
        $k[$j++] = Infinity; //#2804
        var _Tt = $k[--$j]; //#2804
        var _Tu = $k[--$j]; //#2804
        $k[$j++] = _Tt; //#2806
        $forall(_Tu, function() { //#2806
            var _Tv = $k[--$j]; //#2805
            var _Tx = $get($_.cset32, _Tv) !== undefined; //#2805
            $k[$j++] = _Tv; //#2805
            if (_Tx) { //#2805
                var _U0 = $get($_.cset32, $k[--$j]); //#2805
                $k[$j++] = _U0; //#2805
            } else { //#2805
                $k[$j++] = -1; //#2805
                return true; //#2805
            } //#2805
        }); //#2805
        var _U1 = $k[--$j]; //#2807
        $k[$j++] = _U1; //#2807
        if (_U1 == -1) { //#2807
            $cleartomark(); //#2807
            $j -= 2; //#2807
            $k[$j++] = 'bwipp.GS1UnknownCSET32Character#2807'; //#2807
            $k[$j++] = "Unknown CSET 32 character"; //#2807
            $k[$j++] = false; //#2807
            return true; //#2807
        } //#2807
        $astore($a($counttomark())); //#2808
        var _U4 = $k[--$j]; //#2808
        var _U5 = $k[--$j]; //#2808
        $k[$j++] = _U4; //#2808
        $k[$j++] = _U5; //#2808
        $j--; //#2808
        var _U6 = $k[--$j]; //#2809
        var _U9 = $k[--$j]; //#2809
        var _UA = $a([2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83]); //#2810
        var _UB = _U9.length; //#2812
        $k[$j++] = $f(($get(_U6, 0) << 5) + $get(_U6, 1)); //#2812
        $k[$j++] = _U9; //#2812
        $k[$j++] = _UA; //#2812
        $k[$j++] = _UB; //#2812
        if (_UB > _UA.length) { //#2812
            $j -= 5; //#2812
            $k[$j++] = 'bwipp.GS1alphaTooLong#2812'; //#2812
            $k[$j++] = "Alphanumeric string is too long to check"; //#2812
            $k[$j++] = false; //#2812
            return true; //#2812
        } //#2812
        var _UC = $k[--$j]; //#2813
        var _UE = $geti($k[--$j], 0, _UC); //#2813
        for (var _UF = 0, _UG = _UE.length; _UF < _UG; _UF++) { //#2813
            var _UI = $k[--$j]; //#2813
            $k[$j++] = $get(_UE, _UF); //#2813
            $k[$j++] = _UI; //#2813
        } //#2813
        var _UJ = $k[--$j]; //#2814
        $k[$j++] = 0; //#2814
        $forall(_UJ, function() { //#2814
            var _UK = $k[--$j]; //#2814
            var _UL = $k[--$j]; //#2814
            var _UM = $k[--$j]; //#2814
            $k[$j++] = $f(_UL + (_UM * _UK)); //#2814
        }); //#2814
        var _UN = $k[--$j]; //#2814
        if ($k[--$j] != (_UN % 1021)) { //#2815
            $j--; //#2815
            $k[$j++] = 'bwipp.GS1badAlphaCheckCharacters#2815'; //#2815
            $k[$j++] = "Bad alphanumeric check characters"; //#2815
            $k[$j++] = false; //#2815
            return true; //#2815
        } //#2815
    }; //#2815
    if (!bwipp_gs1process.__2839__) { //#2839
        $_ = Object.create($_); //#2839
        $k[$j++] = Infinity; //#2819
        var _UP = $a(['004', '008', '010', '012', '016', '020', '024', '028', '031', '032', '036', '040', '044', '048', '050', '051', '052', '056', '060', '064', '068', '070', '072', '074', '076', '084', '086', '090', '092', '096', '100', '104', '108', '112', '116', '120', '124', '132', '136', '140', '144', '148', '152', '156', '158', '162', '166', '170', '174', '175', '178', '180', '184', '188', '191', '192', '196', '203', '204', '208', '212', '214', '218', '222', '226', '231', '232', '233', '234', '238', '239', '242', '246', '248', '250', '254', '258', '260', '262', '266', '268', '270', '275', '276', '288', '292', '296', '300', '304', '308', '312', '316', '320', '324', '328', '332', '334', '336', '340', '344', '348', '352', '356', '360', '364', '368', '372', '376', '380', '384', '388', '392', '398', '400', '404', '408', '410', '414', '417', '418', '422', '426', '428', '430', '434', '438', '440', '442', '446', '450', '454', '458', '462', '466', '470', '474', '478', '480', '484', '492', '496', '498', '499', '500', '504', '508', '512', '516', '520', '524', '528', '531', '533', '534', '535', '540', '548', '554', '558', '562', '566', '570', '574', '578', '580', '581', '583', '584', '585', '586', '591', '598', '600', '604', '608', '612', '616', '620', '624', '626', '630', '634', '638', '642', '643', '646', '652', '654', '659', '660', '662', '663', '666', '670', '674', '678', '682', '686', '688', '690', '694', '702', '703', '704', '705', '706', '710', '716', '724', '728', '729', '732', '740', '744', '748', '752', '756', '760', '762', '764', '768', '772', '776', '780', '784', '788', '792', '795', '796', '798', '800', '804', '807', '818', '826', '831', '832', '833', '834', '840', '850', '854', '858', '860', '862', '876', '882', '887', '894']); //#2837
        for (var _UQ = 0, _UR = _UP.length; _UQ < _UR; _UQ++) { //#2838
            var _US = $get(_UP, _UQ); //#2838
            $k[$j++] = _US; //#2838
            $k[$j++] = _US; //#2838
        } //#2838
        $_.iso3166 = $d(); //#2838
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_gs1process.$ctx[id] = $_[id]); //#2838
        bwipp_gs1process.__2839__ = 1; //#2838
        $_ = Object.getPrototypeOf($_); //#2838
    } //#2838
    $_.lintiso3166 = function() {
        var _UX = $get($_.iso3166, $k[--$j]) !== undefined; //#2842
        if (!_UX) { //#2842
            $j--; //#2842
            $k[$j++] = 'bwipp.GS1UnknownCountry#2842'; //#2842
            $k[$j++] = "Unknown country code"; //#2842
            $k[$j++] = false; //#2842
            return true; //#2842
        } //#2842
    }; //#2842
    $_.lintiso3166999 = function() {
        var _UY = $k[--$j]; //#2846
        $k[$j++] = _UY; //#2850
        if ($ne(_UY, '999')) { //#2849
            var _Ub = $get($_.iso3166, $k[--$j]) !== undefined; //#2847
            if (!_Ub) { //#2847
                $j--; //#2847
                $k[$j++] = 'bwipp.GS1UnknownCountryOr999#2847'; //#2847
                $k[$j++] = "Unknown country code or not 999"; //#2847
                $k[$j++] = false; //#2847
                return true; //#2847
            } //#2847
        } else { //#2849
            $j--; //#2849
        } //#2849
    }; //#2849
    $_.lintiso3166list = function() {
        var _Uc = $k[--$j]; //#2854
        $k[$j++] = _Uc; //#2856
        if ((_Uc.length % 3) != 0) { //#2856
            $j -= 2; //#2855
            $k[$j++] = 'bwipp.GS1BadCountryListLength#2855'; //#2855
            $k[$j++] = "Not a group of three-digit country codes"; //#2855
            $k[$j++] = false; //#2855
            return true; //#2855
        } //#2855
        var _Ud = $k[--$j]; //#2858
        $k[$j++] = _Ud; //#2861
        $k[$j++] = true; //#2861
        for (var _Uf = 0, _Ue = _Ud.length - 1; _Uf <= _Ue; _Uf += 3) { //#2861
            var _Ug = $k[--$j]; //#2859
            var _Uh = $k[--$j]; //#2859
            var _Uk = $get($_.iso3166, $geti(_Uh, _Uf, 3)) !== undefined; //#2860
            $k[$j++] = _Uh; //#2860
            $k[$j++] = _Ug; //#2860
            if (!_Uk) { //#2860
                $j -= 2; //#2860
                $k[$j++] = false; //#2860
                break; //#2860
            } //#2860
        } //#2860
        if ($nt($k[--$j])) { //#2862
            $j--; //#2862
            $k[$j++] = 'bwipp.GS1UnknownCountry#2862'; //#2862
            $k[$j++] = "Unknown country code"; //#2862
            $k[$j++] = false; //#2862
            return true; //#2862
        } //#2862
        $j--; //#2863
    }; //#2863
    if (!bwipp_gs1process.__2893__) { //#2893
        $_ = Object.create($_); //#2893
        $k[$j++] = Infinity; //#2867
        var _Um = $a(['AD', 'AE', 'AF', 'AG', 'AI', 'AL', 'AM', 'AO', 'AQ', 'AR', 'AS', 'AT', 'AU', 'AW', 'AX', 'AZ', 'BA', 'BB', 'BD', 'BE', 'BF', 'BG', 'BH', 'BI', 'BJ', 'BL', 'BM', 'BN', 'BO', 'BQ', 'BR', 'BS', 'BT', 'BV', 'BW', 'BY', 'BZ', 'CA', 'CC', 'CD', 'CF', 'CG', 'CH', 'CI', 'CK', 'CL', 'CM', 'CN', 'CO', 'CR', 'CU', 'CV', 'CW', 'CX', 'CY', 'CZ', 'DE', 'DJ', 'DK', 'DM', 'DO', 'DZ', 'EC', 'EE', 'EG', 'EH', 'ER', 'ES', 'ET', 'FI', 'FJ', 'FK', 'FM', 'FO', 'FR', 'GA', 'GB', 'GD', 'GE', 'GF', 'GG', 'GH', 'GI', 'GL', 'GM', 'GN', 'GP', 'GQ', 'GR', 'GS', 'GT', 'GU', 'GW', 'GY', 'HK', 'HM', 'HN', 'HR', 'HT', 'HU', 'ID', 'IE', 'IL', 'IM', 'IN', 'IO', 'IQ', 'IR', 'IS', 'IT', 'JE', 'JM', 'JO', 'JP', 'KE', 'KG', 'KH', 'KI', 'KM', 'KN', 'KP', 'KR', 'KW', 'KY', 'KZ', 'LA', 'LB', 'LC', 'LI', 'LK', 'LR', 'LS', 'LT', 'LU', 'LV', 'LY', 'MA', 'MC', 'MD', 'ME', 'MF', 'MG', 'MH', 'MK', 'ML', 'MM', 'MN', 'MO', 'MP', 'MQ', 'MR', 'MS', 'MT', 'MU', 'MV', 'MW', 'MX', 'MY', 'MZ', 'NA', 'NC', 'NE', 'NF', 'NG', 'NI', 'NL', 'NO', 'NP', 'NR', 'NU', 'NZ', 'OM', 'PA', 'PE', 'PF', 'PG', 'PH', 'PK', 'PL', 'PM', 'PN', 'PR', 'PS', 'PT', 'PW', 'PY', 'QA', 'RE', 'RO', 'RS', 'RU', 'RW', 'SA', 'SB', 'SC', 'SD', 'SE', 'SG', 'SH', 'SI', 'SJ', 'SK', 'SL', 'SM', 'SN', 'SO', 'SR', 'SS', 'ST', 'SV', 'SX', 'SY', 'SZ', 'TC', 'TD', 'TF', 'TG', 'TH', 'TJ', 'TK', 'TL', 'TM', 'TN', 'TO', 'TR', 'TT', 'TV', 'TW', 'TZ', 'UA', 'UG', 'UM', 'US', 'UY', 'UZ', 'VA', 'VC', 'VE', 'VG', 'VI', 'VN', 'VU', 'WF', 'WS', 'YE', 'YT', 'ZA', 'ZM', 'ZW']); //#2891
        for (var _Un = 0, _Uo = _Um.length; _Un < _Uo; _Un++) { //#2892
            var _Up = $get(_Um, _Un); //#2892
            $k[$j++] = _Up; //#2892
            $k[$j++] = _Up; //#2892
        } //#2892
        $_.iso3166alpha2 = $d(); //#2892
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_gs1process.$ctx[id] = $_[id]); //#2892
        bwipp_gs1process.__2893__ = 1; //#2892
        $_ = Object.getPrototypeOf($_); //#2892
    } //#2892
    $_.lintiso3166alpha2 = function() {
        var _Uu = $get($_.iso3166alpha2, $k[--$j]) !== undefined; //#2896
        if (!_Uu) { //#2896
            $j--; //#2896
            $k[$j++] = 'bwipp.GS1UnknownCountryAlpha#2896'; //#2896
            $k[$j++] = "Unknown country alpha code"; //#2896
            $k[$j++] = false; //#2896
            return true; //#2896
        } //#2896
    }; //#2896
    if (!bwipp_gs1process.__2924__) { //#2924
        $_ = Object.create($_); //#2924
        $k[$j++] = Infinity; //#2900
        var _Uv = $a(['008', '012', '032', '036', '044', '048', '050', '051', '052', '060', '064', '068', '072', '084', '090', '096', '104', '108', '116', '124', '132', '136', '144', '152', '156', '170', '174', '188', '191', '192', '203', '208', '214', '222', '230', '232', '238', '242', '262', '270', '292', '320', '324', '328', '332', '340', '344', '348', '352', '356', '360', '364', '368', '376', '388', '392', '398', '400', '404', '408', '410', '414', '417', '418', '422', '426', '430', '434', '446', '454', '458', '462', '480', '484', '496', '498', '504', '512', '516', '524', '532', '533', '548', '554', '558', '566', '578', '586', '590', '598', '600', '604', '608', '634', '643', '646', '654', '682', '690', '694', '702', '704', '706', '710', '728', '748', '752', '756', '760', '764', '776', '780', '784', '788', '800', '807', '818', '826', '834', '840', '858', '860', '882', '886', '901', '925', '927', '928', '929', '930', '931', '932', '933', '934', '936', '938', '940', '941', '943', '944', '946', '947', '948', '949', '950', '951', '952', '953', '955', '956', '957', '958', '959', '960', '961', '962', '963', '964', '965', '967', '968', '969', '970', '971', '972', '973', '975', '976', '977', '978', '979', '980', '981', '984', '985', '986', '990', '994', '997', '999']); //#2922
        for (var _Uw = 0, _Ux = _Uv.length; _Uw < _Ux; _Uw++) { //#2923
            var _Uy = $get(_Uv, _Uw); //#2923
            $k[$j++] = _Uy; //#2923
            $k[$j++] = _Uy; //#2923
        } //#2923
        $_.iso4217 = $d(); //#2923
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_gs1process.$ctx[id] = $_[id]); //#2923
        bwipp_gs1process.__2924__ = 1; //#2923
        $_ = Object.getPrototypeOf($_); //#2923
    } //#2923
    $_.lintiso4217 = function() {
        var _V3 = $get($_.iso4217, $k[--$j]) !== undefined; //#2927
        if (!_V3) { //#2927
            $j--; //#2927
            $k[$j++] = 'bwipp.GS1UnknownCurrency#2927'; //#2927
            $k[$j++] = "Unknown currency code"; //#2927
            $k[$j++] = false; //#2927
            return true; //#2927
        } //#2927
    }; //#2927
    $_.lintiso5218 = function() {
        var _V4 = $k[--$j]; //#2931
        if ($ne(_V4, "0") && ($ne(_V4, "1") && ($ne(_V4, "2") && $ne(_V4, "9")))) { //#2933
            $j--; //#2932
            $k[$j++] = 'bwipp.GS1biologicalSexCode#2932'; //#2932
            $k[$j++] = "Invalid biological sex code"; //#2932
            $k[$j++] = false; //#2932
            return true; //#2932
        } //#2932
    }; //#2932
    $_.lintiban = function() {
        var _V5 = $k[--$j]; //#2937
        $k[$j++] = _V5; //#2937
        if (_V5.length <= 4) { //#2937
            $j -= 2; //#2937
            $k[$j++] = 'bwipp.GS1tooShort#2937'; //#2937
            $k[$j++] = "IBAN too short"; //#2937
            $k[$j++] = false; //#2937
            return true; //#2937
        } //#2937
        var _V6 = $k[--$j]; //#2938
        $k[$j++] = _V6; //#2943
        $k[$j++] = true; //#2943
        $forall(_V6, function() { //#2943
            var _V7 = $s(1); //#2939
            $put(_V7, 0, $k[--$j]); //#2939
            $search("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ", _V7); //#2941
            if ($nt($k[--$j])) { //#2941
                $j -= 2; //#2941
                $k[$j++] = false; //#2941
                return true; //#2941
            } //#2941
            $j -= 3; //#2942
        }); //#2942
        if ($nt($k[--$j])) { //#2944
            $j--; //#2944
            $k[$j++] = 'bwipp.GS1badIBANcharacter#2944'; //#2944
            $k[$j++] = "Invalid IBAN character"; //#2944
            $k[$j++] = false; //#2944
            return true; //#2944
        } //#2944
        var _VB = $k[--$j]; //#2945
        $k[$j++] = _VB; //#2945
        $k[$j++] = _VB; //#2945
        $k[$j++] = Infinity; //#2945
        var _VC = $k[--$j]; //#2945
        var _VD = $k[--$j]; //#2945
        $k[$j++] = _VC; //#2945
        $k[$j++] = _VD; //#2945
        $k[$j++] = Infinity; //#2945
        var _VE = $k[--$j]; //#2945
        var _VF = $k[--$j]; //#2945
        $k[$j++] = _VE; //#2945
        $forall(_VF); //#2945
        $r($counttomark(), -4); //#2945
        $astore($a($counttomark())); //#2945
        var _VJ = $k[--$j]; //#2945
        var _VK = $k[--$j]; //#2945
        $k[$j++] = _VJ; //#2945
        $k[$j++] = _VK; //#2945
        $j--; //#2945
        $forall($k[--$j], function() { //#2947
            var _VN = $f($k[--$j] - 48); //#2946
            $k[$j++] = _VN; //#2946
            if (_VN > 9) { //#2946
                var _VP = $f($k[--$j] - 7); //#2946
                $k[$j++] = ~~(_VP / 10); //#2946
                $k[$j++] = _VP % 10; //#2946
            } //#2946
        }); //#2946
        $astore($a($counttomark())); //#2947
        var _VS = $k[--$j]; //#2947
        var _VT = $k[--$j]; //#2947
        $k[$j++] = _VS; //#2947
        $k[$j++] = _VT; //#2947
        $j--; //#2947
        var _VU = $k[--$j]; //#2948
        $k[$j++] = 0; //#2948
        $forall(_VU, function() { //#2948
            var _VV = $k[--$j]; //#2948
            var _VW = $k[--$j]; //#2948
            $k[$j++] = ($f(_VV + (_VW * 10))) % 97; //#2948
        }); //#2948
        if ($k[--$j] != 1) { //#2949
            $j -= 2; //#2949
            $k[$j++] = 'bwipp.GS1badIBANchecksum#2949'; //#2949
            $k[$j++] = "IBAN checksum incorrect"; //#2949
            $k[$j++] = false; //#2949
            return true; //#2949
        } //#2949
        var _VZ = $geti($k[--$j], 0, 2); //#2950
        $k[$j++] = _VZ; //#2950
        $_.lintiso3166alpha2(); //#2950
    }; //#2950
    $_.lintzero = function() {
        if ($ne($k[--$j], "0")) { //#2954
            $j--; //#2954
            $k[$j++] = 'bwipp.GS1zeroRequired#2954'; //#2954
            $k[$j++] = "Zero is required"; //#2954
            $k[$j++] = false; //#2954
            return true; //#2954
        } //#2954
    }; //#2954
    $_.lintnonzero = function() {
        var _Vb = $k[--$j]; //#2958
        $k[$j++] = false; //#2958
        $forall(_Vb, function() { //#2958
            if ($k[--$j] != 48) { //#2958
                $j--; //#2958
                $k[$j++] = true; //#2958
            } //#2958
        }); //#2958
        if ($nt($k[--$j])) { //#2959
            $j--; //#2959
            $k[$j++] = 'bwipp.GS1zeroNotPermitted#2959'; //#2959
            $k[$j++] = "Zero not permitted"; //#2959
            $k[$j++] = false; //#2959
            return true; //#2959
        } //#2959
    }; //#2959
    $_.lintnozeroprefix = function() {
        var _Ve = $k[--$j]; //#2963
        if ((_Ve.length > 1) && ($get(_Ve, 0) == 48)) { //#2965
            $j--; //#2964
            $k[$j++] = 'bwipp.GS1badZeroPrefix#2964'; //#2964
            $k[$j++] = "Zero prefix is not permitted"; //#2964
            $k[$j++] = false; //#2964
            return true; //#2964
        } //#2964
    }; //#2964
    $_.linthasnondigit = function() {
        var _Vg = $k[--$j]; //#2969
        $k[$j++] = false; //#2969
        $forall(_Vg, function() { //#2969
            var _Vh = $k[--$j]; //#2969
            if ((_Vh < 48) || (_Vh > 57)) { //#2969
                $j--; //#2969
                $k[$j++] = true; //#2969
                return true; //#2969
            } //#2969
        }); //#2969
        if ($nt($k[--$j])) { //#2970
            $k[$j++] = 'bwipp.GS1requiresNonDigit#2970'; //#2970
            $k[$j++] = "A non-digit character is required"; //#2970
            $k[$j++] = false; //#2970
            return true; //#2970
        } //#2970
    }; //#2970
    $_.linthyphen = function() {
        if ($ne($k[--$j], "-")) { //#2974
            $j--; //#2974
            $k[$j++] = 'bwipp.GS1hyphenRequired#2974'; //#2974
            $k[$j++] = "A hyphen is required"; //#2974
            $k[$j++] = false; //#2974
            return true; //#2974
        } //#2974
    }; //#2974
    $_.lintyyyymmd0 = function() {
        var _Vk = $k[--$j]; //#2978
        var _Vm = $cvi($geti(_Vk, 4, 2)); //#2978
        $k[$j++] = _Vk; //#2978
        if ((_Vm < 1) || (_Vm > 12)) { //#2978
            $j--; //#2978
            $k[$j++] = 'bwipp.GS1badMonth#2978'; //#2978
            $k[$j++] = "Invalid month"; //#2978
            $k[$j++] = false; //#2978
            return true; //#2978
        } //#2978
        var _Vn = $k[--$j]; //#2979
        var _Vp = $cvi($geti(_Vn, 0, 4)); //#2979
        $k[$j++] = _Vn; //#2980
        $k[$j++] = ((_Vp % 400) == 0) || (((_Vp % 4) == 0) && ((_Vp % 100) != 0)); //#2980
        $k[$j++] = Infinity; //#2980
        var _Vq = $k[--$j]; //#2980
        var _Vs = $k[--$j] ? 29 : 28; //#2980
        $k[$j++] = _Vq; //#2980
        $k[$j++] = 31; //#2980
        $k[$j++] = _Vs; //#2980
        $k[$j++] = 31; //#2980
        $k[$j++] = 30; //#2980
        $k[$j++] = 31; //#2980
        $k[$j++] = 30; //#2980
        $k[$j++] = 31; //#2980
        $k[$j++] = 31; //#2980
        $k[$j++] = 30; //#2980
        $k[$j++] = 31; //#2980
        $k[$j++] = 30; //#2980
        $k[$j++] = 31; //#2980
        var _Vt = $a(); //#2980
        var _Vu = $k[--$j]; //#2981
        if ($get(_Vt, $cvi($geti(_Vu, 4, 2)) - 1) < $cvi($geti(_Vu, 6, 2))) { //#2982
            $j--; //#2982
            $k[$j++] = 'bwipp.GS1badDay#2982'; //#2982
            $k[$j++] = "Invalid day of month"; //#2982
            $k[$j++] = false; //#2982
            return true; //#2982
        } //#2982
    }; //#2982
    $_.lintyyyymmdd = function() {
        var _Vy = $k[--$j]; //#2986
        $k[$j++] = _Vy; //#2986
        if (_Vy.length != 8) { //#2986
            $j--; //#2986
            $k[$j++] = 'bwipp.GS1badDateLength#2986'; //#2986
            $k[$j++] = "Invalid length for yyyymmdd date"; //#2986
            $k[$j++] = false; //#2986
            return true; //#2986
        } //#2986
        var _Vz = $k[--$j]; //#2987
        $k[$j++] = _Vz; //#2987
        if ($cvi($geti(_Vz, 6, 2)) < 1) { //#2987
            $j--; //#2987
            $k[$j++] = 'bwipp.GS1badDay#2987'; //#2987
            $k[$j++] = "Invalid day of month"; //#2987
            $k[$j++] = false; //#2987
            return true; //#2987
        } //#2987
        $_.lintyyyymmd0(); //#2988
    }; //#2988
    $_.lintyymmd0 = function() {
        var _W1 = $k[--$j]; //#2992
        var _W3 = $cvi($geti(_W1, 0, 2)); //#2992
        var _W4 = _W3 - 21; //#2993
        $k[$j++] = _W1; //#2993
        $k[$j++] = _W3; //#2993
        $k[$j++] = _W4; //#2993
        if (_W4 >= 51) { //#2993
            $j--; //#2993
            $k[$j++] = "19"; //#2993
        } else { //#2993
            if ($k[--$j] <= -50) { //#2993
                $k[$j++] = "21"; //#2993
            } else { //#2993
                $k[$j++] = "20"; //#2993
            } //#2993
        } //#2993
        var _W6 = $k[--$j]; //#2993
        var _W7 = $k[--$j]; //#2993
        $k[$j++] = _W6; //#2993
        $k[$j++] = _W7; //#2993
        $j--; //#2993
        var _W8 = $s(8); //#2994
        $puti(_W8, 0, $k[--$j]); //#2994
        $puti(_W8, 2, $k[--$j]); //#2994
        $k[$j++] = _W8; //#2995
        $_.lintyyyymmd0(); //#2995
    }; //#2995
    $_.lintyymmdd = function() {
        var _WB = $k[--$j]; //#2999
        $k[$j++] = _WB; //#2999
        if (_WB.length != 6) { //#2999
            $j--; //#2999
            $k[$j++] = 'bwipp.GS1badDateLength#2999'; //#2999
            $k[$j++] = "Invalid length for yymmdd date"; //#2999
            $k[$j++] = false; //#2999
            return true; //#2999
        } //#2999
        var _WC = $k[--$j]; //#3000
        $k[$j++] = _WC; //#3000
        if ($cvi($geti(_WC, 4, 2)) < 1) { //#3000
            $j--; //#3000
            $k[$j++] = 'bwipp.GS1badDay#3000'; //#3000
            $k[$j++] = "Invalid day of month"; //#3000
            $k[$j++] = false; //#3000
            return true; //#3000
        } //#3000
        $_.lintyymmd0(); //#3001
    }; //#3001
    $_.lintyymmddhh = function() {
        var _WE = $k[--$j]; //#3005
        $k[$j++] = _WE; //#3005
        if (_WE.length != 8) { //#3005
            $j--; //#3005
            $k[$j++] = 'bwipp.GS1badYYMMDDHHLength#3005'; //#3005
            $k[$j++] = "Invalid length for yymmdd date with hour"; //#3005
            $k[$j++] = false; //#3005
            return true; //#3005
        } //#3005
        var _WF = $k[--$j]; //#3006
        $k[$j++] = _WF; //#3006
        if ($cvi($geti(_WF, 6, 2)) > 23) { //#3006
            $j -= 2; //#3006
            $k[$j++] = 'bwipp.GS1badHour#3006'; //#3006
            $k[$j++] = "Invalid hour of day"; //#3006
            $k[$j++] = false; //#3006
            return true; //#3006
        } //#3006
        var _WI = $geti($k[--$j], 0, 6); //#3007
        $k[$j++] = _WI; //#3007
        $_.lintyymmdd(); //#3007
    }; //#3007
    $_.linthhmm = function() {
        var _WJ = $k[--$j]; //#3011
        $k[$j++] = _WJ; //#3011
        if ($cvi($geti(_WJ, 0, 2)) > 23) { //#3011
            $j -= 2; //#3011
            $k[$j++] = 'bwipp.GS1badHour#3011'; //#3011
            $k[$j++] = "Invalid hour of day"; //#3011
            $k[$j++] = false; //#3011
            return true; //#3011
        } //#3011
        if ($cvi($geti($k[--$j], 2, 2)) > 59) { //#3012
            $j--; //#3012
            $k[$j++] = 'bwipp.GS1badMinute#3012'; //#3012
            $k[$j++] = "Invalid minute in the hour"; //#3012
            $k[$j++] = false; //#3012
            return true; //#3012
        } //#3012
    }; //#3012
    $_.lintmmoptss = function() {
        var _WN = $k[--$j]; //#3016
        var _WO = _WN.length; //#3016
        $k[$j++] = _WN; //#3018
        if ((_WO != 2) && (_WO != 4)) { //#3018
            $j--; //#3017
            $k[$j++] = 'bwipp.GS1badTimeLength#3017'; //#3017
            $k[$j++] = "Invalid length for optional minutes and seconds"; //#3017
            $k[$j++] = false; //#3017
            return true; //#3017
        } //#3017
        var _WP = $k[--$j]; //#3019
        $k[$j++] = _WP; //#3019
        if ($cvi($geti(_WP, 0, 2)) > 59) { //#3019
            $j -= 2; //#3019
            $k[$j++] = 'bwipp.GS1badMinute#3019'; //#3019
            $k[$j++] = "Invalid minute in the hour"; //#3019
            $k[$j++] = false; //#3019
            return true; //#3019
        } //#3019
        var _WR = $k[--$j]; //#3020
        $k[$j++] = _WR; //#3022
        if (_WR.length >= 4) { //#3022
            var _WS = $k[--$j]; //#3021
            $k[$j++] = _WS; //#3021
            if ($cvi($geti(_WS, 2, 2)) > 59) { //#3021
                $j -= 2; //#3021
                $k[$j++] = 'bwipp.GS1badSecond#3021'; //#3021
                $k[$j++] = "Invalid second in the minute"; //#3021
                $k[$j++] = false; //#3021
                return true; //#3021
            } //#3021
        } //#3021
        $j--; //#3023
    }; //#3023
    $_.lintyesno = function() {
        var _WU = $k[--$j]; //#3027
        if ($ne(_WU, "0") && $ne(_WU, "1")) { //#3029
            $j--; //#3028
            $k[$j++] = 'bwipp.GS1badBoolean#3028'; //#3028
            $k[$j++] = "Neither 0 nor 1 for yes or no"; //#3028
            $k[$j++] = false; //#3028
            return true; //#3028
        } //#3028
    }; //#3028
    $_.lintwinding = function() {
        var _WV = $k[--$j]; //#3033
        if ($ne(_WV, "0") && ($ne(_WV, "1") && $ne(_WV, "9"))) { //#3035
            $j--; //#3034
            $k[$j++] = 'bwipp.GS1badWinding#3034'; //#3034
            $k[$j++] = "Invalid winding direction"; //#3034
            $k[$j++] = false; //#3034
            return true; //#3034
        } //#3034
    }; //#3034
    $_.lintpieceoftotal = function() {
        var _WW = $k[--$j]; //#3039
        $k[$j++] = _WW; //#3039
        if ((_WW.length % 2) != 0) { //#3039
            $j -= 2; //#3039
            $k[$j++] = 'bwipp.GS1badPieceTotalLength#3039'; //#3039
            $k[$j++] = "Invalid piece/total length"; //#3039
            $k[$j++] = false; //#3039
            return true; //#3039
        } //#3039
        var _WX = $k[--$j]; //#3040
        var _WZ = $cvi($geti(_WX, 0, ~~(_WX.length / 2))); //#3041
        $k[$j++] = _WX; //#3041
        $k[$j++] = _WZ; //#3041
        if (_WZ == 0) { //#3041
            $j -= 3; //#3041
            $k[$j++] = 'bwipp.GS1badPieceNumber#3041'; //#3041
            $k[$j++] = "Invalid piece number"; //#3041
            $k[$j++] = false; //#3041
            return true; //#3041
        } //#3041
        var _Wa = $k[--$j]; //#3042
        var _Wb = $k[--$j]; //#3042
        var _Wc = ~~(_Wb.length / 2); //#3042
        var _We = $cvi($geti(_Wb, _Wc, _Wc)); //#3043
        $k[$j++] = _Wa; //#3043
        $k[$j++] = _We; //#3043
        if (_We == 0) { //#3043
            $j -= 3; //#3043
            $k[$j++] = 'bwipp.GS1badPieceTotal#3043'; //#3043
            $k[$j++] = "Invalid total number"; //#3043
            $k[$j++] = false; //#3043
            return true; //#3043
        } //#3043
        var _Wf = $k[--$j]; //#3044
        if ($gt($k[--$j], _Wf)) { //#3044
            $j--; //#3044
            $k[$j++] = 'bwipp.GS1pieceExceedsTotal#3044'; //#3044
            $k[$j++] = "Piece number exceeds total"; //#3044
            $k[$j++] = false; //#3044
            return true; //#3044
        } //#3044
    }; //#3044
    $_.lintposinseqslash = function() {
        $search($k[--$j], "/"); //#3048
        if ($nt($k[--$j])) { //#3050
            $j--; //#3049
            $k[$j++] = 'bwipp.invalidPosInSeqFormat#3049'; //#3049
            $k[$j++] = "Invalid <pos>/<end> format"; //#3049
            $k[$j++] = false; //#3049
            return true; //#3049
        } //#3049
        var _Wj = $k[--$j]; //#3051
        var _Wk = $k[--$j]; //#3051
        $k[$j++] = _Wj; //#3051
        $k[$j++] = _Wk; //#3051
        $j--; //#3051
        var _Wl = $k[--$j]; //#3052
        $k[$j++] = _Wl; //#3054
        if (_Wl.length == 0) { //#3054
            $j -= 2; //#3053
            $k[$j++] = 'bwipp.invalidPosInSeqFormat#3053'; //#3053
            $k[$j++] = "Invalid <pos>/<end> format"; //#3053
            $k[$j++] = false; //#3053
            return true; //#3053
        } //#3053
        var _Wm = $k[--$j]; //#3055
        var _Wn = $k[--$j]; //#3055
        $k[$j++] = _Wn; //#3057
        $k[$j++] = _Wm; //#3057
        if (_Wn.length == 0) { //#3057
            $j -= 2; //#3056
            $k[$j++] = 'bwipp.invalidPosInSeqFormat#3056'; //#3056
            $k[$j++] = "Invalid <pos>/<end> format"; //#3056
            $k[$j++] = false; //#3056
            return true; //#3056
        } //#3056
        var _Wo = $k[--$j]; //#3058
        $k[$j++] = _Wo; //#3060
        $k[$j++] = true; //#3060
        $forall(_Wo, function() { //#3060
            var _Wp = $k[--$j]; //#3059
            if ((_Wp < 48) || (_Wp > 57)) { //#3059
                $j--; //#3059
                $k[$j++] = false; //#3059
                return true; //#3059
            } //#3059
        }); //#3059
        if ($nt($k[--$j])) { //#3061
            $j -= 2; //#3061
            $k[$j++] = 'bwipp.positionNotNumeric#3061'; //#3061
            $k[$j++] = "Position is not numeric"; //#3061
            $k[$j++] = false; //#3061
            return true; //#3061
        } //#3061
        var _Wr = $k[--$j]; //#3062
        var _Ws = $k[--$j]; //#3062
        $k[$j++] = _Ws; //#3064
        $k[$j++] = _Wr; //#3064
        $k[$j++] = true; //#3064
        $forall(_Ws, function() { //#3064
            var _Wt = $k[--$j]; //#3063
            if ((_Wt < 48) || (_Wt > 57)) { //#3063
                $j--; //#3063
                $k[$j++] = false; //#3063
                return true; //#3063
            } //#3063
        }); //#3063
        if ($nt($k[--$j])) { //#3065
            $j -= 2; //#3065
            $k[$j++] = 'bwipp.endNotNumeric#3065'; //#3065
            $k[$j++] = "End is not numeric"; //#3065
            $k[$j++] = false; //#3065
            return true; //#3065
        } //#3065
        var _Wv = $k[--$j]; //#3066
        $k[$j++] = _Wv; //#3066
        if ($get(_Wv, 0) == 48) { //#3066
            $j -= 2; //#3066
            $k[$j++] = 'bwipp.positionZeroPrefix#3066'; //#3066
            $k[$j++] = "Position cannot have zero prefix"; //#3066
            $k[$j++] = false; //#3066
            return true; //#3066
        } //#3066
        var _Wx = $k[--$j]; //#3067
        var _Wy = $k[--$j]; //#3067
        $k[$j++] = _Wy; //#3067
        $k[$j++] = _Wx; //#3067
        if ($get(_Wy, 0) == 48) { //#3067
            $j -= 2; //#3067
            $k[$j++] = 'bwipp.endZeroPrefix#3067'; //#3067
            $k[$j++] = "End cannot have zero prefix"; //#3067
            $k[$j++] = false; //#3067
            return true; //#3067
        } //#3067
        var _X0 = $k[--$j]; //#3068
        if ($cvi($k[--$j]) < $cvi(_X0)) { //#3069
            $k[$j++] = 'bwipp.positionExceedsEnd#3069'; //#3069
            $k[$j++] = "Position exceeds end"; //#3069
            $k[$j++] = false; //#3069
            return true; //#3069
        } //#3069
    }; //#3069
    $_.lintpcenc = function() {
        for (;;) { //#3083
            $search($k[--$j], "%"); //#3074
            if ($nt($k[--$j])) { //#3074
                $j--; //#3074
                break; //#3074
            } //#3074
            $j -= 2; //#3075
            var _X4 = $k[--$j]; //#3075
            $k[$j++] = _X4; //#3075
            if (_X4.length < 2) { //#3075
                $j -= 2; //#3075
                $k[$j++] = 'bwipp.GS1badPercentEscape#3075'; //#3075
                $k[$j++] = "Invalid % escape"; //#3075
                $k[$j++] = false; //#3075
                break; //#3075
            } //#3075
            var _X5 = $k[--$j]; //#3076
            var _X6 = $geti(_X5, 0, 2); //#3076
            $k[$j++] = _X5; //#3081
            $k[$j++] = true; //#3081
            for (var _X7 = 0, _X8 = _X6.length; _X7 < _X8; _X7++) { //#3081
                var _XA = $s(1); //#3077
                $put(_XA, 0, $get(_X6, _X7)); //#3077
                $search("0123456789ABCDEFabcdef", _XA); //#3079
                if ($nt($k[--$j])) { //#3079
                    $j -= 2; //#3079
                    $k[$j++] = false; //#3079
                    break; //#3079
                } //#3079
                $j -= 3; //#3080
            } //#3080
            if ($nt($k[--$j])) { //#3082
                $j -= 2; //#3082
                $k[$j++] = 'bwipp.GS1badPercentChars#3082'; //#3082
                $k[$j++] = "Invalid characters for percent encoding"; //#3082
                $k[$j++] = false; //#3082
                break; //#3082
            } //#3082
        } //#3082
    }; //#3082
    $_.lintcouponcode = function() {
        var _XD = $k[--$j]; //#3087
        $k[$j++] = _XD; //#3089
        $k[$j++] = true; //#3089
        $forall(_XD, function() { //#3089
            var _XE = $k[--$j]; //#3088
            if ((_XE < 48) || (_XE > 57)) { //#3088
                $j--; //#3088
                $k[$j++] = false; //#3088
                return true; //#3088
            } //#3088
        }); //#3088
        if ($nt($k[--$j])) { //#3090
            $j -= 2; //#3090
            $k[$j++] = 'bwipp.GS1couponNotNumeric#3090'; //#3090
            $k[$j++] = "Coupon not numeric"; //#3090
            $k[$j++] = false; //#3090
            return true; //#3090
        } //#3090
        var _XG = $k[--$j]; //#3093
        $k[$j++] = _XG; //#3095
        if (_XG.length < 1) { //#3095
            $j -= 2; //#3094
            $k[$j++] = 'bwipp.GS1couponTooShortGCPVLI#3094'; //#3094
            $k[$j++] = "Coupon too short: Missing GCP VLI"; //#3094
            $k[$j++] = false; //#3094
            return true; //#3094
        } //#3094
        var _XH = $k[--$j]; //#3096
        var _XJ = $cvi($geti(_XH, 0, 1)); //#3096
        $k[$j++] = _XH; //#3098
        $k[$j++] = _XJ; //#3098
        if (_XJ > 6) { //#3098
            $j -= 2; //#3097
            $k[$j++] = 'bwipp.GS1couponBadGCPVLI#3097'; //#3097
            $k[$j++] = "Coupon GCP length indicator must be 0-6"; //#3097
            $k[$j++] = false; //#3097
            return true; //#3097
        } //#3097
        var _XK = $k[--$j]; //#3099
        var _XL = $k[--$j]; //#3100
        $k[$j++] = _XL; //#3102
        $k[$j++] = $f($f(_XK + 6) + 1); //#3102
        if (($f($f(_XK + 6) + 1)) > _XL.length) { //#3102
            $j -= 3; //#3101
            $k[$j++] = 'bwipp.GS1couponTooShortGCP#3101'; //#3101
            $k[$j++] = "Coupon too short: GCP truncated"; //#3101
            $k[$j++] = false; //#3101
            return true; //#3101
        } //#3101
        var _XM = $k[--$j]; //#3103
        var _XN = $k[--$j]; //#3103
        var _XO = $geti(_XN, _XM, $f(_XN.length - _XM)); //#3103
        $k[$j++] = _XO; //#3108
        if (_XO.length < 6) { //#3108
            $j -= 2; //#3107
            $k[$j++] = 'bwipp.GS1couponTooShortOfferCode#3107'; //#3107
            $k[$j++] = "Coupon too short: Offer Code truncated"; //#3107
            $k[$j++] = false; //#3107
            return true; //#3107
        } //#3107
        var _XP = $k[--$j]; //#3109
        var _XQ = $geti(_XP, 6, _XP.length - 6); //#3109
        $k[$j++] = _XQ; //#3114
        if (_XQ.length < 1) { //#3114
            $j -= 2; //#3113
            $k[$j++] = 'bwipp.GS1couponTooShortSaveValueVLI#3113'; //#3113
            $k[$j++] = "Coupon too short: Missing Save Value VLI"; //#3113
            $k[$j++] = false; //#3113
            return true; //#3113
        } //#3113
        var _XR = $k[--$j]; //#3115
        var _XT = $cvi($geti(_XR, 0, 1)); //#3115
        $k[$j++] = _XR; //#3117
        $k[$j++] = _XT; //#3117
        if ((_XT < 1) || (_XT > 5)) { //#3117
            $j -= 2; //#3116
            $k[$j++] = 'bwipp.GS1couponBadSaveValueVLI#3116'; //#3116
            $k[$j++] = "Coupon Save Value length indicator must be 1-5"; //#3116
            $k[$j++] = false; //#3116
            return true; //#3116
        } //#3116
        var _XU = $k[--$j]; //#3118
        var _XV = $k[--$j]; //#3119
        $k[$j++] = _XV; //#3121
        $k[$j++] = $f(_XU + 1); //#3121
        if ($f(_XU + 1) > _XV.length) { //#3121
            $j -= 3; //#3120
            $k[$j++] = 'bwipp.GS1couponTooShortSaveValue#3120'; //#3120
            $k[$j++] = "Coupon too short: Save Value truncated"; //#3120
            $k[$j++] = false; //#3120
            return true; //#3120
        } //#3120
        var _XW = $k[--$j]; //#3122
        var _XX = $k[--$j]; //#3122
        var _XY = $geti(_XX, _XW, $f(_XX.length - _XW)); //#3122
        $k[$j++] = _XY; //#3127
        if (_XY.length < 1) { //#3127
            $j -= 2; //#3126
            $k[$j++] = 'bwipp.GS1couponTooShort1stPurchaseRequirementVLI#3126'; //#3126
            $k[$j++] = "Coupon too short: Missing 1st Purchase Requirement VLI"; //#3126
            $k[$j++] = false; //#3126
            return true; //#3126
        } //#3126
        var _XZ = $k[--$j]; //#3128
        var _Xb = $cvi($geti(_XZ, 0, 1)); //#3128
        $k[$j++] = _XZ; //#3130
        $k[$j++] = _Xb; //#3130
        if ((_Xb < 1) || (_Xb > 5)) { //#3130
            $j -= 2; //#3129
            $k[$j++] = 'bwipp.GS1couponBad1stPurchaseRequirementVLI#3129'; //#3129
            $k[$j++] = "Coupon 1st Purchase Requirement length indicator must be 1-5"; //#3129
            $k[$j++] = false; //#3129
            return true; //#3129
        } //#3129
        var _Xc = $k[--$j]; //#3131
        var _Xd = $k[--$j]; //#3132
        $k[$j++] = _Xd; //#3134
        $k[$j++] = $f(_Xc + 1); //#3134
        if ($f(_Xc + 1) > _Xd.length) { //#3134
            $j -= 3; //#3133
            $k[$j++] = 'bwipp.GS1couponTooShort1stPurchaseRequirement#3133'; //#3133
            $k[$j++] = "Coupon too short: 1st Purchase Requirement truncated"; //#3133
            $k[$j++] = false; //#3133
            return true; //#3133
        } //#3133
        var _Xe = $k[--$j]; //#3135
        var _Xf = $k[--$j]; //#3135
        var _Xg = $geti(_Xf, _Xe, $f(_Xf.length - _Xe)); //#3135
        $k[$j++] = _Xg; //#3140
        if (_Xg.length < 1) { //#3140
            $j -= 2; //#3139
            $k[$j++] = 'bwipp.GS1couponTooShort1stPurchaseRequirementCode#3139'; //#3139
            $k[$j++] = "Coupon too short: Missing 1st Purchase Requirement Code"; //#3139
            $k[$j++] = false; //#3139
            return true; //#3139
        } //#3139
        var _Xh = $k[--$j]; //#3141
        var _Xj = $cvi($geti(_Xh, 0, 1)); //#3141
        $k[$j++] = _Xh; //#3143
        if ((_Xj > 4) && (_Xj != 9)) { //#3143
            $j -= 2; //#3142
            $k[$j++] = 'bwipp.GS1couponBad1stPurchaseRequirementCode#3142'; //#3142
            $k[$j++] = "Coupon 1st Purchase Requirement Code must be 0-4 or 9"; //#3142
            $k[$j++] = false; //#3142
            return true; //#3142
        } //#3142
        var _Xk = $k[--$j]; //#3144
        var _Xl = $geti(_Xk, 1, _Xk.length - 1); //#3144
        $k[$j++] = _Xl; //#3149
        if (_Xl.length < 3) { //#3149
            $j -= 2; //#3148
            $k[$j++] = 'bwipp.GS1couponTooShort1stPurchaseFamilyCode#3148'; //#3148
            $k[$j++] = "Coupon too short: 1st Purchase Family Code truncated"; //#3148
            $k[$j++] = false; //#3148
            return true; //#3148
        } //#3148
        var _Xm = $k[--$j]; //#3150
        var _Xn = $geti(_Xm, 3, _Xm.length - 3); //#3150
        $k[$j++] = _Xn; //#3206
        if (_Xn.length >= 1) { //#3206
            var _Xo = $k[--$j]; //#3153
            $k[$j++] = _Xo; //#3206
            if ($cvi($geti(_Xo, 0, 1)) == 1) { //#3206
                var _Xq = $k[--$j]; //#3154
                var _Xr = $geti(_Xq, 1, _Xq.length - 1); //#3154
                $k[$j++] = _Xr; //#3159
                if (_Xr.length < 1) { //#3159
                    $j -= 2; //#3158
                    $k[$j++] = 'bwipp.GS1couponTooShortAdditionalPurchaseRulesCode#3158'; //#3158
                    $k[$j++] = "Coupon too short: Missing Additional Purchase Rules Code"; //#3158
                    $k[$j++] = false; //#3158
                    return true; //#3158
                } //#3158
                var _Xs = $k[--$j]; //#3160
                $k[$j++] = _Xs; //#3162
                if ($cvi($geti(_Xs, 0, 1)) > 3) { //#3162
                    $j -= 2; //#3161
                    $k[$j++] = 'bwipp.GS1couponBadAdditionalPurchaseRulesCode#3161'; //#3161
                    $k[$j++] = "Coupon Additional Purchase Rules Code must be 0-3"; //#3161
                    $k[$j++] = false; //#3161
                    return true; //#3161
                } //#3161
                var _Xu = $k[--$j]; //#3163
                var _Xv = $geti(_Xu, 1, _Xu.length - 1); //#3163
                $k[$j++] = _Xv; //#3168
                if (_Xv.length < 1) { //#3168
                    $j -= 2; //#3167
                    $k[$j++] = 'bwipp.GS1couponTooShort2ndPurchaseRequirementVLI#3167'; //#3167
                    $k[$j++] = "Coupon too short: Missing 2nd Purchase Requirement VLI"; //#3167
                    $k[$j++] = false; //#3167
                    return true; //#3167
                } //#3167
                var _Xw = $k[--$j]; //#3169
                var _Xy = $cvi($geti(_Xw, 0, 1)); //#3169
                $k[$j++] = _Xw; //#3171
                $k[$j++] = _Xy; //#3171
                if ((_Xy < 1) || (_Xy > 5)) { //#3171
                    $j -= 2; //#3170
                    $k[$j++] = 'bwipp.GS1couponBad2ndPurchaseRequirementVLI#3170'; //#3170
                    $k[$j++] = "Coupon 2nd Purchase Requirement length indicator must be 1-5"; //#3170
                    $k[$j++] = false; //#3170
                    return true; //#3170
                } //#3170
                var _Xz = $k[--$j]; //#3172
                var _Y0 = $k[--$j]; //#3173
                $k[$j++] = _Y0; //#3175
                $k[$j++] = $f(_Xz + 1); //#3175
                if ($f(_Xz + 1) > _Y0.length) { //#3175
                    $j -= 3; //#3174
                    $k[$j++] = 'bwipp.GS1couponTooShort2ndPurchaseRequirement#3174'; //#3174
                    $k[$j++] = "Coupon too short: 2nd Purchase Requirement truncated"; //#3174
                    $k[$j++] = false; //#3174
                    return true; //#3174
                } //#3174
                var _Y1 = $k[--$j]; //#3176
                var _Y2 = $k[--$j]; //#3176
                var _Y3 = $geti(_Y2, _Y1, $f(_Y2.length - _Y1)); //#3176
                $k[$j++] = _Y3; //#3181
                if (_Y3.length < 1) { //#3181
                    $j -= 2; //#3180
                    $k[$j++] = 'bwipp.GS1couponTooShort2ndPurchaseRequirementCode#3180'; //#3180
                    $k[$j++] = "Coupon too short: Missing 2nd Purchase Requirement Code"; //#3180
                    $k[$j++] = false; //#3180
                    return true; //#3180
                } //#3180
                var _Y4 = $k[--$j]; //#3182
                var _Y6 = $cvi($geti(_Y4, 0, 1)); //#3182
                $k[$j++] = _Y4; //#3184
                if ((_Y6 > 4) && (_Y6 != 9)) { //#3184
                    $j -= 2; //#3183
                    $k[$j++] = 'bwipp.GS1couponBad2ndPurchaseRequirementCode#3183'; //#3183
                    $k[$j++] = "Coupon 2nd Purchase Requirement Code must be 0-4 or 9"; //#3183
                    $k[$j++] = false; //#3183
                    return true; //#3183
                } //#3183
                var _Y7 = $k[--$j]; //#3185
                var _Y8 = $geti(_Y7, 1, _Y7.length - 1); //#3185
                $k[$j++] = _Y8; //#3190
                if (_Y8.length < 3) { //#3190
                    $j -= 2; //#3189
                    $k[$j++] = 'bwipp.GS1couponTooShort2ndPurchaseFamilyCode#3189'; //#3189
                    $k[$j++] = "Coupon too short: 2nd Purchase Family Code truncated"; //#3189
                    $k[$j++] = false; //#3189
                    return true; //#3189
                } //#3189
                var _Y9 = $k[--$j]; //#3191
                var _YA = $geti(_Y9, 3, _Y9.length - 3); //#3191
                $k[$j++] = _YA; //#3196
                if (_YA.length < 1) { //#3196
                    $j -= 2; //#3195
                    $k[$j++] = 'bwipp.GS1couponTooShort2ndPurchaseGCPVLI#3195'; //#3195
                    $k[$j++] = "Coupon too short: Missing 2nd Purchase GCP VLI"; //#3195
                    $k[$j++] = false; //#3195
                    return true; //#3195
                } //#3195
                var _YB = $k[--$j]; //#3197
                var _YD = $cvi($geti(_YB, 0, 1)); //#3197
                $k[$j++] = _YB; //#3199
                $k[$j++] = _YD; //#3199
                if ((_YD > 6) && (_YD != 9)) { //#3199
                    $j -= 2; //#3198
                    $k[$j++] = 'bwipp.GS1couponBad2ndPurchaseGCPVLI#3198'; //#3198
                    $k[$j++] = "Coupon 2nd Purchase GCP length indicator must be 0-6 or 9"; //#3198
                    $k[$j++] = false; //#3198
                    return true; //#3198
                } //#3198
                var _YE = $k[--$j]; //#3200
                $k[$j++] = _YE; //#3200
                if (_YE != 9) { //#3200
                    var _YF = $k[--$j]; //#3200
                    $k[$j++] = $f(_YF + 6); //#3200
                } else { //#3200
                    $j--; //#3200
                    $k[$j++] = 0; //#3200
                } //#3200
                var _YG = $k[--$j]; //#3200
                var _YH = $k[--$j]; //#3201
                $k[$j++] = _YH; //#3203
                $k[$j++] = $f(_YG + 1); //#3203
                if ($f(_YG + 1) > _YH.length) { //#3203
                    $j -= 3; //#3202
                    $k[$j++] = 'bwipp.GS1couponTooShort2ndPurchaseGCP#3202'; //#3202
                    $k[$j++] = "Coupon too short: 2nd Purchase GCP truncated"; //#3202
                    $k[$j++] = false; //#3202
                    return true; //#3202
                } //#3202
                var _YI = $k[--$j]; //#3204
                var _YJ = $k[--$j]; //#3204
                $k[$j++] = $geti(_YJ, _YI, $f(_YJ.length - _YI)); //#3204
            } //#3204
        } //#3204
        var _YL = $k[--$j]; //#3209
        $k[$j++] = _YL; //#3253
        if (_YL.length >= 1) { //#3253
            var _YM = $k[--$j]; //#3209
            $k[$j++] = _YM; //#3253
            if ($cvi($geti(_YM, 0, 1)) == 2) { //#3253
                var _YO = $k[--$j]; //#3210
                var _YP = $geti(_YO, 1, _YO.length - 1); //#3210
                $k[$j++] = _YP; //#3215
                if (_YP.length < 1) { //#3215
                    $j -= 2; //#3214
                    $k[$j++] = 'bwipp.GS1couponTooShort3rdPurchaseRequirementVLI#3214'; //#3214
                    $k[$j++] = "Coupon too short: Missing 3rd Purchase Requirement VLI"; //#3214
                    $k[$j++] = false; //#3214
                    return true; //#3214
                } //#3214
                var _YQ = $k[--$j]; //#3216
                var _YS = $cvi($geti(_YQ, 0, 1)); //#3216
                $k[$j++] = _YQ; //#3218
                $k[$j++] = _YS; //#3218
                if ((_YS < 1) || (_YS > 5)) { //#3218
                    $j -= 2; //#3217
                    $k[$j++] = 'bwipp.GS1couponBad3rdPurchaseRequirementVLI#3217'; //#3217
                    $k[$j++] = "Coupon 3rd Purchase Requirement length indicator must be 1-5"; //#3217
                    $k[$j++] = false; //#3217
                    return true; //#3217
                } //#3217
                var _YT = $k[--$j]; //#3219
                var _YU = $k[--$j]; //#3220
                $k[$j++] = _YU; //#3222
                $k[$j++] = $f(_YT + 1); //#3222
                if ($f(_YT + 1) > _YU.length) { //#3222
                    $j -= 3; //#3221
                    $k[$j++] = 'bwipp.GS1couponTooShort3rdPurchaseRequirement#3221'; //#3221
                    $k[$j++] = "Coupon too short: 3rd Purchase Requirement truncated"; //#3221
                    $k[$j++] = false; //#3221
                    return true; //#3221
                } //#3221
                var _YV = $k[--$j]; //#3223
                var _YW = $k[--$j]; //#3223
                var _YX = $geti(_YW, _YV, $f(_YW.length - _YV)); //#3223
                $k[$j++] = _YX; //#3228
                if (_YX.length < 1) { //#3228
                    $j -= 2; //#3227
                    $k[$j++] = 'bwipp.GS1couponTooShort3rdPurchaseRequirementCode#3227'; //#3227
                    $k[$j++] = "Coupon too short: Missing 3rd Purchase Requirement Code"; //#3227
                    $k[$j++] = false; //#3227
                    return true; //#3227
                } //#3227
                var _YY = $k[--$j]; //#3229
                var _Ya = $cvi($geti(_YY, 0, 1)); //#3229
                $k[$j++] = _YY; //#3231
                if ((_Ya > 4) && (_Ya != 9)) { //#3231
                    $j -= 2; //#3230
                    $k[$j++] = 'bwipp.GS1couponBad3rdPurchaseRequirementCode#3230'; //#3230
                    $k[$j++] = "Coupon 3rd Purchase Requirement Code must be 0-4 or 9"; //#3230
                    $k[$j++] = false; //#3230
                    return true; //#3230
                } //#3230
                var _Yb = $k[--$j]; //#3232
                var _Yc = $geti(_Yb, 1, _Yb.length - 1); //#3232
                $k[$j++] = _Yc; //#3237
                if (_Yc.length < 3) { //#3237
                    $j -= 2; //#3236
                    $k[$j++] = 'bwipp.GS1couponTooShort3rdPurchaseFamilyCode#3236'; //#3236
                    $k[$j++] = "Coupon too short: 3rd Purchase Family Code truncated"; //#3236
                    $k[$j++] = false; //#3236
                    return true; //#3236
                } //#3236
                var _Yd = $k[--$j]; //#3238
                var _Ye = $geti(_Yd, 3, _Yd.length - 3); //#3238
                $k[$j++] = _Ye; //#3243
                if (_Ye.length < 1) { //#3243
                    $j -= 2; //#3242
                    $k[$j++] = 'bwipp.GS1couponTooShort3rdPurchaseGCPVLI#3242'; //#3242
                    $k[$j++] = "Coupon too short: Missing 3rd Purchase GCP VLI"; //#3242
                    $k[$j++] = false; //#3242
                    return true; //#3242
                } //#3242
                var _Yf = $k[--$j]; //#3244
                var _Yh = $cvi($geti(_Yf, 0, 1)); //#3244
                $k[$j++] = _Yf; //#3246
                $k[$j++] = _Yh; //#3246
                if ((_Yh > 6) && (_Yh != 9)) { //#3246
                    $j -= 2; //#3245
                    $k[$j++] = 'bwipp.GS1couponBad3rdPurchaseGCPVLI#3245'; //#3245
                    $k[$j++] = "Coupon 3rd Purchase GCP length indicator must be 0-6 or 9"; //#3245
                    $k[$j++] = false; //#3245
                    return true; //#3245
                } //#3245
                var _Yi = $k[--$j]; //#3247
                $k[$j++] = _Yi; //#3247
                if (_Yi != 9) { //#3247
                    var _Yj = $k[--$j]; //#3247
                    $k[$j++] = $f(_Yj + 6); //#3247
                } else { //#3247
                    $j--; //#3247
                    $k[$j++] = 0; //#3247
                } //#3247
                var _Yk = $k[--$j]; //#3247
                var _Yl = $k[--$j]; //#3248
                $k[$j++] = _Yl; //#3250
                $k[$j++] = $f(_Yk + 1); //#3250
                if ($f(_Yk + 1) > _Yl.length) { //#3250
                    $j -= 3; //#3249
                    $k[$j++] = 'bwipp.GS1couponTooShort3rdPurchaseGCP#3249'; //#3249
                    $k[$j++] = "Coupon too short: 3rd Purchase GCP truncated"; //#3249
                    $k[$j++] = false; //#3249
                    return true; //#3249
                } //#3249
                var _Ym = $k[--$j]; //#3251
                var _Yn = $k[--$j]; //#3251
                $k[$j++] = $geti(_Yn, _Ym, $f(_Yn.length - _Ym)); //#3251
            } //#3251
        } //#3251
        $_.couponexpire = -1; //#3256
        var _Yp = $k[--$j]; //#3257
        $k[$j++] = _Yp; //#3275
        if (_Yp.length >= 1) { //#3275
            var _Yq = $k[--$j]; //#3257
            $k[$j++] = _Yq; //#3275
            if ($cvi($geti(_Yq, 0, 1)) == 3) { //#3275
                var _Ys = $k[--$j]; //#3258
                var _Yt = $geti(_Ys, 1, _Ys.length - 1); //#3258
                $k[$j++] = _Yt; //#3263
                if (_Yt.length < 6) { //#3263
                    $j -= 2; //#3262
                    $k[$j++] = 'bwipp.GS1couponTooShortExpirationDate#3262'; //#3262
                    $k[$j++] = "Coupon too short: Expiration date"; //#3262
                    $k[$j++] = false; //#3262
                    return true; //#3262
                } //#3262
                var _Yu = $k[--$j]; //#3264
                var _Yw = $cvi($geti(_Yu, 2, 2)); //#3264
                $k[$j++] = _Yu; //#3264
                if ((_Yw < 1) || (_Yw > 12)) { //#3264
                    $j -= 2; //#3264
                    $k[$j++] = 'bwipp.GS1couponExpirationDateBadMonth#3264'; //#3264
                    $k[$j++] = "Invalid month in expiration date"; //#3264
                    $k[$j++] = false; //#3264
                    return true; //#3264
                } //#3264
                var _Yx = $k[--$j]; //#3265
                var _Yz = $cvi($geti(_Yx, 0, 2)); //#3265
                var _Z0 = _Yz - 21; //#3266
                $k[$j++] = _Yx; //#3266
                $k[$j++] = _Yz; //#3266
                $k[$j++] = _Z0; //#3266
                if (_Z0 >= 51) { //#3266
                    $j--; //#3266
                    var _Z1 = $k[--$j]; //#3266
                    $k[$j++] = $f(_Z1 + 1900); //#3266
                } else { //#3266
                    if ($k[--$j] <= -50) { //#3266
                        var _Z3 = $k[--$j]; //#3266
                        $k[$j++] = $f(_Z3 + 2100); //#3266
                    } else { //#3266
                        var _Z4 = $k[--$j]; //#3266
                        $k[$j++] = $f(_Z4 + 2000); //#3266
                    } //#3266
                } //#3266
                var _Z5 = $k[--$j]; //#3267
                $k[$j++] = ((_Z5 % 400) == 0) || (((_Z5 % 4) == 0) && ((_Z5 % 100) != 0)); //#3268
                $k[$j++] = Infinity; //#3268
                var _Z6 = $k[--$j]; //#3268
                var _Z8 = $k[--$j] ? 29 : 28; //#3268
                $k[$j++] = _Z6; //#3268
                $k[$j++] = 31; //#3268
                $k[$j++] = _Z8; //#3268
                $k[$j++] = 31; //#3268
                $k[$j++] = 30; //#3268
                $k[$j++] = 31; //#3268
                $k[$j++] = 30; //#3268
                $k[$j++] = 31; //#3268
                $k[$j++] = 31; //#3268
                $k[$j++] = 30; //#3268
                $k[$j++] = 31; //#3268
                $k[$j++] = 30; //#3268
                $k[$j++] = 31; //#3268
                var _Z9 = $a(); //#3268
                var _ZA = $k[--$j]; //#3269
                var _ZE = $cvi($geti(_ZA, 4, 2)); //#3270
                $k[$j++] = _ZA; //#3271
                if (($get(_Z9, $cvi($geti(_ZA, 2, 2)) - 1) < _ZE) || (_ZE < 1)) { //#3271
                    $j -= 2; //#3271
                    $k[$j++] = 'bwipp.GS1couponExpirationDateBadDay#3271'; //#3271
                    $k[$j++] = "Invalid day of month in expiration date"; //#3271
                    $k[$j++] = false; //#3271
                    return true; //#3271
                } //#3271
                var _ZF = $k[--$j]; //#3272
                $_.couponexpire = $cvi($geti(_ZF, 0, 6)); //#3272
                $k[$j++] = $geti(_ZF, 6, _ZF.length - 6); //#3273
            } //#3273
        } //#3273
        var _ZI = $k[--$j]; //#3278
        $k[$j++] = _ZI; //#3299
        if (_ZI.length >= 1) { //#3299
            var _ZJ = $k[--$j]; //#3278
            $k[$j++] = _ZJ; //#3299
            if ($cvi($geti(_ZJ, 0, 1)) == 4) { //#3299
                var _ZL = $k[--$j]; //#3279
                var _ZM = $geti(_ZL, 1, _ZL.length - 1); //#3279
                $k[$j++] = _ZM; //#3284
                if (_ZM.length < 6) { //#3284
                    $j -= 2; //#3283
                    $k[$j++] = 'bwipp.GS1couponTooShortStartDate#3283'; //#3283
                    $k[$j++] = "Coupon too short: Start date"; //#3283
                    $k[$j++] = false; //#3283
                    return true; //#3283
                } //#3283
                var _ZN = $k[--$j]; //#3285
                var _ZP = $cvi($geti(_ZN, 2, 2)); //#3285
                $k[$j++] = _ZN; //#3285
                if ((_ZP < 1) || (_ZP > 12)) { //#3285
                    $j -= 2; //#3285
                    $k[$j++] = 'bwipp.GS1couponStartDateBadMonth#3285'; //#3285
                    $k[$j++] = "Invalid month in start date"; //#3285
                    $k[$j++] = false; //#3285
                    return true; //#3285
                } //#3285
                var _ZQ = $k[--$j]; //#3286
                var _ZS = $cvi($geti(_ZQ, 0, 2)); //#3286
                var _ZT = _ZS - 21; //#3287
                $k[$j++] = _ZQ; //#3287
                $k[$j++] = _ZS; //#3287
                $k[$j++] = _ZT; //#3287
                if (_ZT >= 51) { //#3287
                    $j--; //#3287
                    var _ZU = $k[--$j]; //#3287
                    $k[$j++] = $f(_ZU + 1900); //#3287
                } else { //#3287
                    if ($k[--$j] <= -50) { //#3287
                        var _ZW = $k[--$j]; //#3287
                        $k[$j++] = $f(_ZW + 2100); //#3287
                    } else { //#3287
                        var _ZX = $k[--$j]; //#3287
                        $k[$j++] = $f(_ZX + 2000); //#3287
                    } //#3287
                } //#3287
                var _ZY = $k[--$j]; //#3288
                $k[$j++] = ((_ZY % 400) == 0) || (((_ZY % 4) == 0) && ((_ZY % 100) != 0)); //#3289
                $k[$j++] = Infinity; //#3289
                var _ZZ = $k[--$j]; //#3289
                var _Zb = $k[--$j] ? 29 : 28; //#3289
                $k[$j++] = _ZZ; //#3289
                $k[$j++] = 31; //#3289
                $k[$j++] = _Zb; //#3289
                $k[$j++] = 31; //#3289
                $k[$j++] = 30; //#3289
                $k[$j++] = 31; //#3289
                $k[$j++] = 30; //#3289
                $k[$j++] = 31; //#3289
                $k[$j++] = 31; //#3289
                $k[$j++] = 30; //#3289
                $k[$j++] = 31; //#3289
                $k[$j++] = 30; //#3289
                $k[$j++] = 31; //#3289
                var _Zc = $a(); //#3289
                var _Zd = $k[--$j]; //#3290
                var _Zh = $cvi($geti(_Zd, 4, 2)); //#3291
                $k[$j++] = _Zd; //#3292
                if (($get(_Zc, $cvi($geti(_Zd, 2, 2)) - 1) < _Zh) || (_Zh < 1)) { //#3292
                    $j -= 2; //#3292
                    $k[$j++] = 'bwipp.GS1couponStartDateBadDay#3292'; //#3292
                    $k[$j++] = "Invalid day of month in start date"; //#3292
                    $k[$j++] = false; //#3292
                    return true; //#3292
                } //#3292
                var _Zi = $k[--$j]; //#3293
                $_.couponstart = $cvi($geti(_Zi, 0, 6)); //#3293
                $k[$j++] = _Zi; //#3296
                if (($_.couponexpire != -1) && ($_.couponexpire < $_.couponstart)) { //#3296
                    $j -= 2; //#3295
                    $k[$j++] = 'bwipp.GS1couponExpireDateBeforeStartDate#3295'; //#3295
                    $k[$j++] = "Coupon expires before it starts"; //#3295
                    $k[$j++] = false; //#3295
                    return true; //#3295
                } //#3295
                var _Zn = $k[--$j]; //#3297
                $k[$j++] = $geti(_Zn, 6, _Zn.length - 6); //#3297
            } //#3297
        } //#3297
        var _Zp = $k[--$j]; //#3302
        $k[$j++] = _Zp; //#3315
        if (_Zp.length >= 1) { //#3315
            var _Zq = $k[--$j]; //#3302
            $k[$j++] = _Zq; //#3315
            if ($cvi($geti(_Zq, 0, 1)) == 5) { //#3315
                var _Zs = $k[--$j]; //#3303
                var _Zt = $geti(_Zs, 1, _Zs.length - 1); //#3303
                $k[$j++] = _Zt; //#3308
                if (_Zt.length < 1) { //#3308
                    $j -= 2; //#3307
                    $k[$j++] = 'bwipp.GS1couponTooShortSerialNumberVLI#3307'; //#3307
                    $k[$j++] = "Coupon too short: Missing Serial Number VLI"; //#3307
                    $k[$j++] = false; //#3307
                    return true; //#3307
                } //#3307
                var _Zu = $k[--$j]; //#3309
                var _Zv = $geti(_Zu, 0, 1); //#3309
                $k[$j++] = _Zu; //#3312
                $k[$j++] = ($cvi(_Zv) + 6) + 1; //#3312
                if ((($cvi(_Zv) + 6) + 1) > _Zu.length) { //#3312
                    $j -= 3; //#3311
                    $k[$j++] = 'bwipp.GS1couponTooShortSerialNumber#3311'; //#3311
                    $k[$j++] = "Coupon too short: Serial Number truncated"; //#3311
                    $k[$j++] = false; //#3311
                    return true; //#3311
                } //#3311
                var _Zw = $k[--$j]; //#3313
                var _Zx = $k[--$j]; //#3313
                $k[$j++] = $geti(_Zx, _Zw, $f(_Zx.length - _Zw)); //#3313
            } //#3313
        } //#3313
        var _Zz = $k[--$j]; //#3318
        $k[$j++] = _Zz; //#3334
        if (_Zz.length >= 1) { //#3334
            var _a0 = $k[--$j]; //#3318
            $k[$j++] = _a0; //#3334
            if ($cvi($geti(_a0, 0, 1)) == 6) { //#3334
                var _a2 = $k[--$j]; //#3319
                var _a3 = $geti(_a2, 1, _a2.length - 1); //#3319
                $k[$j++] = _a3; //#3324
                if (_a3.length < 1) { //#3324
                    $j -= 2; //#3323
                    $k[$j++] = 'bwipp.GS1couponTooShortRetailerGCPGLNVLI#3323'; //#3323
                    $k[$j++] = "Coupon too short: Missing Retailer GCP/GLN VLI"; //#3323
                    $k[$j++] = false; //#3323
                    return true; //#3323
                } //#3323
                var _a4 = $k[--$j]; //#3325
                var _a6 = $cvi($geti(_a4, 0, 1)); //#3325
                $k[$j++] = _a4; //#3327
                $k[$j++] = _a6; //#3327
                if ((_a6 < 1) || (_a6 > 7)) { //#3327
                    $j -= 2; //#3326
                    $k[$j++] = 'bwipp.GS1couponBadRetailerGCPGLNVLI#3326'; //#3326
                    $k[$j++] = "Coupon Retailer GCP/GLN length indicator must be 1-7"; //#3326
                    $k[$j++] = false; //#3326
                    return true; //#3326
                } //#3326
                var _a7 = $k[--$j]; //#3328
                var _a8 = $k[--$j]; //#3329
                $k[$j++] = _a8; //#3331
                $k[$j++] = $f($f(_a7 + 6) + 1); //#3331
                if (($f($f(_a7 + 6) + 1)) > _a8.length) { //#3331
                    $j -= 3; //#3330
                    $k[$j++] = 'bwipp.GS1couponTooShortRetailerGCPGLN#3330'; //#3330
                    $k[$j++] = "Coupon too short: Retailer GCP/GLN truncated"; //#3330
                    $k[$j++] = false; //#3330
                    return true; //#3330
                } //#3330
                var _a9 = $k[--$j]; //#3332
                var _aA = $k[--$j]; //#3332
                $k[$j++] = $geti(_aA, _a9, $f(_aA.length - _a9)); //#3332
            } //#3332
        } //#3332
        var _aC = $k[--$j]; //#3337
        $k[$j++] = _aC; //#3373
        if (_aC.length >= 1) { //#3373
            var _aD = $k[--$j]; //#3337
            $k[$j++] = _aD; //#3373
            if ($cvi($geti(_aD, 0, 1)) == 9) { //#3373
                var _aF = $k[--$j]; //#3338
                var _aG = $geti(_aF, 1, _aF.length - 1); //#3338
                $k[$j++] = _aG; //#3343
                if (_aG.length < 1) { //#3343
                    $j -= 2; //#3342
                    $k[$j++] = 'bwipp.GS1couponTooShortSaveValueCode#3342'; //#3342
                    $k[$j++] = "Coupon too short: Missing Save Value Code"; //#3342
                    $k[$j++] = false; //#3342
                    return true; //#3342
                } //#3342
                var _aH = $k[--$j]; //#3344
                var _aJ = $cvi($geti(_aH, 0, 1)); //#3344
                $k[$j++] = _aH; //#3346
                if ((_aJ > 6) || ((_aJ == 3) || (_aJ == 4))) { //#3346
                    $j -= 2; //#3345
                    $k[$j++] = 'bwipp.GS1couponBadSaveValueCode#3345'; //#3345
                    $k[$j++] = "Coupon Save Value Code must be 0,1,2,5 or 6"; //#3345
                    $k[$j++] = false; //#3345
                    return true; //#3345
                } //#3345
                var _aK = $k[--$j]; //#3347
                var _aL = $geti(_aK, 1, _aK.length - 1); //#3347
                $k[$j++] = _aL; //#3352
                if (_aL.length < 1) { //#3352
                    $j -= 2; //#3351
                    $k[$j++] = 'bwipp.GS1couponTooShortSaveValueAppliesToItem#3351'; //#3351
                    $k[$j++] = "Coupon too short: Missing Save Value Applies to Item"; //#3351
                    $k[$j++] = false; //#3351
                    return true; //#3351
                } //#3351
                var _aM = $k[--$j]; //#3353
                $k[$j++] = _aM; //#3355
                if ($cvi($geti(_aM, 0, 1)) > 2) { //#3355
                    $j -= 2; //#3354
                    $k[$j++] = 'bwipp.GS1couponBadSaveValueAppliesToItem#3354'; //#3354
                    $k[$j++] = "Coupon Save Value Applies to Item must be 0-2"; //#3354
                    $k[$j++] = false; //#3354
                    return true; //#3354
                } //#3354
                var _aO = $k[--$j]; //#3356
                var _aP = $geti(_aO, 1, _aO.length - 1); //#3356
                $k[$j++] = _aP; //#3361
                if (_aP.length < 1) { //#3361
                    $j -= 2; //#3360
                    $k[$j++] = 'bwipp.GS1couponTooShortStoreCouponFlag#3360'; //#3360
                    $k[$j++] = "Coupon too short: Missing Store Coupon Flag"; //#3360
                    $k[$j++] = false; //#3360
                    return true; //#3360
                } //#3360
                var _aQ = $k[--$j]; //#3362
                var _aR = $geti(_aQ, 1, _aQ.length - 1); //#3362
                $k[$j++] = _aR; //#3367
                if (_aR.length < 1) { //#3367
                    $j -= 2; //#3366
                    $k[$j++] = 'bwipp.GS1couponTooShortDontMultiplyFlag#3366'; //#3366
                    $k[$j++] = "Coupon too short: Missing Don't Multiply Flag"; //#3366
                    $k[$j++] = false; //#3366
                    return true; //#3366
                } //#3366
                var _aS = $k[--$j]; //#3368
                $k[$j++] = _aS; //#3370
                if ($cvi($geti(_aS, 0, 1)) > 1) { //#3370
                    $j -= 2; //#3369
                    $k[$j++] = 'bwipp.GS1couponBadDontMultiplyFlag#3369'; //#3369
                    $k[$j++] = "Don't Multiply Flag must be 0 or 1"; //#3369
                    $k[$j++] = false; //#3369
                    return true; //#3369
                } //#3369
                var _aU = $k[--$j]; //#3371
                $k[$j++] = $geti(_aU, 1, _aU.length - 1); //#3371
            } //#3371
        } //#3371
        var _aW = $k[--$j]; //#3375
        $k[$j++] = _aW; //#3377
        if (_aW.length != 0) { //#3377
            $j -= 2; //#3376
            $k[$j++] = 'bwipp.GS1couponUnrecognisedOptionalField#3376'; //#3376
            $k[$j++] = "Coupon fields must be 1,2,3,4,5,6 or 9, increasing order"; //#3376
            $k[$j++] = false; //#3376
            return true; //#3376
        } //#3376
        $j--; //#3378
    }; //#3378
    $_.lintcouponposoffer = function() {
        var _aX = $k[--$j]; //#3382
        $k[$j++] = _aX; //#3384
        $k[$j++] = true; //#3384
        $forall(_aX, function() { //#3384
            var _aY = $k[--$j]; //#3383
            if ((_aY < 48) || (_aY > 57)) { //#3383
                $j--; //#3383
                $k[$j++] = false; //#3383
                return true; //#3383
            } //#3383
        }); //#3383
        if ($nt($k[--$j])) { //#3385
            $j -= 2; //#3385
            $k[$j++] = 'bwipp.GS1couponNotNumeric#3385'; //#3385
            $k[$j++] = "Coupon not numeric"; //#3385
            $k[$j++] = false; //#3385
            return true; //#3385
        } //#3385
        var _aa = $k[--$j]; //#3387
        $k[$j++] = _aa; //#3389
        if (_aa.length < 1) { //#3389
            $j -= 2; //#3388
            $k[$j++] = 'bwipp.GS1couponTooShortFormatCode#3388'; //#3388
            $k[$j++] = "Coupon too short: Missing Format Code"; //#3388
            $k[$j++] = false; //#3388
            return true; //#3388
        } //#3388
        var _ab = $k[--$j]; //#3390
        var _ac = $geti(_ab, 0, 1); //#3390
        $k[$j++] = _ab; //#3392
        if ($ne(_ac, "0") && $ne(_ac, "1")) { //#3392
            $j -= 2; //#3391
            $k[$j++] = 'bwipp.GS1couponBadFormatCode#3391'; //#3391
            $k[$j++] = "Coupon format must be 0 or 1"; //#3391
            $k[$j++] = false; //#3391
            return true; //#3391
        } //#3391
        var _ad = $k[--$j]; //#3393
        var _ae = $geti(_ad, 1, _ad.length - 1); //#3393
        $k[$j++] = _ae; //#3397
        if (_ae.length < 1) { //#3397
            $j -= 2; //#3396
            $k[$j++] = 'bwipp.GS1couponTooShortFunderVLI#3396'; //#3396
            $k[$j++] = "Coupon too short: Missing Funder VLI"; //#3396
            $k[$j++] = false; //#3396
            return true; //#3396
        } //#3396
        var _af = $k[--$j]; //#3398
        var _ah = $cvi($geti(_af, 0, 1)); //#3398
        $k[$j++] = _af; //#3400
        $k[$j++] = _ah; //#3400
        if (_ah > 6) { //#3400
            $j -= 3; //#3399
            $k[$j++] = 'bwipp.GS1couponBadFunderVLI#3399'; //#3399
            $k[$j++] = "Coupon Funder length indicator must be 0-6"; //#3399
            $k[$j++] = false; //#3399
            return true; //#3399
        } //#3399
        var _ai = $k[--$j]; //#3401
        var _aj = $k[--$j]; //#3402
        $k[$j++] = _aj; //#3404
        $k[$j++] = $f($f(_ai + 6) + 1); //#3404
        if (($f($f(_ai + 6) + 1)) > _aj.length) { //#3404
            $j -= 3; //#3403
            $k[$j++] = 'bwipp.GS1couponTooShortFunder#3403'; //#3403
            $k[$j++] = "Coupon too short: Truncated Funder ID"; //#3403
            $k[$j++] = false; //#3403
            return true; //#3403
        } //#3403
        var _ak = $k[--$j]; //#3405
        var _al = $k[--$j]; //#3405
        var _am = $geti(_al, _ak, $f(_al.length - _ak)); //#3405
        $k[$j++] = _am; //#3409
        if (_am.length < 6) { //#3409
            $j -= 2; //#3408
            $k[$j++] = 'bwipp.GS1couponTooShortOfferCode#3408'; //#3408
            $k[$j++] = "Coupon too short: Truncated Offer Code"; //#3408
            $k[$j++] = false; //#3408
            return true; //#3408
        } //#3408
        var _an = $k[--$j]; //#3410
        var _ao = $geti(_an, 6, _an.length - 6); //#3410
        $k[$j++] = _ao; //#3414
        if (_ao.length < 1) { //#3414
            $j -= 2; //#3413
            $k[$j++] = 'bwipp.GS1couponTooShortSnVLI#3413'; //#3413
            $k[$j++] = "Coupon too short: Missing SN VLI"; //#3413
            $k[$j++] = false; //#3413
            return true; //#3413
        } //#3413
        var _ap = $k[--$j]; //#3415
        var _aq = $geti(_ap, 0, 1); //#3415
        $k[$j++] = _ap; //#3419
        $k[$j++] = ($cvi(_aq) + 6) + 1; //#3419
        if ((($cvi(_aq) + 6) + 1) > _ap.length) { //#3419
            $j -= 3; //#3418
            $k[$j++] = 'bwipp.GS1couponTooShortSn#3418'; //#3418
            $k[$j++] = "Coupon too short: Truncated SN"; //#3418
            $k[$j++] = false; //#3418
            return true; //#3418
        } //#3418
        var _ar = $k[--$j]; //#3420
        var _as = $k[--$j]; //#3420
        var _at = $geti(_as, _ar, $f(_as.length - _ar)); //#3420
        $k[$j++] = _at; //#3423
        if (_at.length != 0) { //#3423
            $j -= 2; //#3422
            $k[$j++] = 'bwipp.GS1couponTooLong#3422'; //#3422
            $k[$j++] = "Coupon too long"; //#3422
            $k[$j++] = false; //#3422
            return true; //#3422
        } //#3422
        $j--; //#3424
    }; //#3424
    $_.lintlatitude = function() {
        var _au = $k[--$j]; //#3428
        $k[$j++] = _au; //#3430
        if (_au.length != 10) { //#3430
            $j--; //#3429
            $k[$j++] = 'bwipp.GS1badLatitudeLength#3429'; //#3429
            $k[$j++] = "Invalid length for a latitude"; //#3429
            $k[$j++] = false; //#3429
            return true; //#3429
        } //#3429
        if ($cvi($k[--$j]) > $cvi("1800000000")) { //#3433
            $j--; //#3433
            $k[$j++] = 'bwipp.GS1badLatitude#3433'; //#3433
            $k[$j++] = "Invalid value for latitude"; //#3433
            $k[$j++] = false; //#3433
            return true; //#3433
        } //#3433
    }; //#3433
    $_.lintlongitude = function() {
        var _aw = $k[--$j]; //#3437
        $k[$j++] = _aw; //#3439
        if (_aw.length != 10) { //#3439
            $j--; //#3438
            $k[$j++] = 'bwipp.GS1badLongitudeLength#3438'; //#3438
            $k[$j++] = "Invalid length for a longitude"; //#3438
            $k[$j++] = false; //#3438
            return true; //#3438
        } //#3438
        if ($cvi($k[--$j]) > $cvi("3600000000")) { //#3443
            $j--; //#3443
            $k[$j++] = 'bwipp.GS1badLongitude#3443'; //#3443
            $k[$j++] = "Invalid value for longitude"; //#3443
            $k[$j++] = false; //#3443
            return true; //#3443
        } //#3443
    }; //#3443
    if (!bwipp_gs1process.__3452__) { //#3452
        $_ = Object.create($_); //#3452
        $k[$j++] = Infinity; //#3447
        var _ay = $a(['01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '80', '81', '82', '83', '84', '85', '86', '87', '88', '89', '90', '91', '92', '93', '94', '95', '96', '97', '98', '99']); //#3450
        for (var _az = 0, _b0 = _ay.length; _az < _b0; _az++) { //#3451
            var _b1 = $get(_ay, _az); //#3451
            $k[$j++] = _b1; //#3451
            $k[$j++] = _b1; //#3451
        } //#3451
        $_.aidcmediatype = $d(); //#3451
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_gs1process.$ctx[id] = $_[id]); //#3451
        bwipp_gs1process.__3452__ = 1; //#3451
        $_ = Object.getPrototypeOf($_); //#3451
    } //#3451
    $_.lintmediatype = function() {
        var _b6 = $get($_.aidcmediatype, $k[--$j]) !== undefined; //#3455
        if (!_b6) { //#3455
            $j--; //#3455
            $k[$j++] = 'bwipp.GS1UnknownMediaType#3455'; //#3455
            $k[$j++] = "Unknown AIDC media type"; //#3455
            $k[$j++] = false; //#3455
            return true; //#3455
        } //#3455
    }; //#3455
    if (!$_.dontlint) { //#3596
        $k[$j++] = true; //#3499
        for (var _bA = 0, _b9 = $_.vals.length - 1; _bA <= _b9; _bA += 1) { //#3499
            $_.ai = $get($_.ais, _bA); //#3463
            $_.val = $get($_.vals, _bA); //#3464
            var _bH = $get($_.gs1syntax, $_.ai) !== undefined; //#3465
            if (_bH) { //#3497
                var _bL = $get($get($_.gs1syntax, $_.ai), 'parts'); //#3466
                $k[$j++] = _bL; //#3468
                $k[$j++] = 0; //#3468
                $forall(_bL, function() { //#3468
                    var _bM = $k[--$j]; //#3468
                    $k[$j++] = _bM; //#3468
                    if ($get(_bM, 'opt')) { //#3468
                        $j--; //#3468
                        $k[$j++] = 0; //#3468
                    } else { //#3468
                        var _bP = $get($k[--$j], 'min'); //#3468
                        $k[$j++] = _bP; //#3468
                    } //#3468
                    var _bQ = $k[--$j]; //#3468
                    var _bR = $k[--$j]; //#3468
                    $k[$j++] = $f(_bR + _bQ); //#3468
                }); //#3468
                if ($k[--$j] > $_.val.length) { //#3470
                    $j--; //#3469
                    $k[$j++] = 'bwipp.GS1valueTooShort#3469'; //#3469
                    $k[$j++] = "Too short"; //#3469
                    $k[$j++] = false; //#3469
                    break; //#3469
                } //#3469
                var _bU = $k[--$j]; //#3471
                $k[$j++] = _bU; //#3471
                $k[$j++] = 0; //#3471
                $forall(_bU, function() { //#3471
                    var _bW = $get($k[--$j], 'max'); //#3471
                    var _bX = $k[--$j]; //#3471
                    $k[$j++] = $f(_bX + _bW); //#3471
                }); //#3471
                if ($k[--$j] < $_.val.length) { //#3473
                    $j--; //#3472
                    $k[$j++] = 'bwipp.GS1valueTooLong#3472'; //#3472
                    $k[$j++] = "Too long"; //#3472
                    $k[$j++] = false; //#3472
                    break; //#3472
                } //#3472
                $forall($k[--$j], function() { //#3491
                    $_.props = $k[--$j]; //#3475
                    var _bd = $get($_.props, 'max'); //#3476
                    var _be = $_.val; //#3476
                    var _bf = _be.length; //#3476
                    if (_bd > _be.length) { //#3476
                        var _ = _bf; //#3476
                        _bf = _bd; //#3476
                        _bd = _; //#3476
                    } //#3476
                    $_.eval = $geti($_.val, 0, _bd); //#3477
                    var _bk = $_.eval.length; //#3478
                    $_.val = $geti($_.val, _bk, $_.val.length - _bk); //#3478
                    if ($_.eval.length == 0) { //#3489
                        if ($nt($get($_.props, 'opt'))) { //#3482
                            $j--; //#3481
                            $k[$j++] = 'bwipp.GS1valueTooShort#3481'; //#3481
                            $k[$j++] = "Too short"; //#3481
                            $k[$j++] = false; //#3481
                            return true; //#3481
                        } //#3481
                    } else { //#3489
                        if ($_.eval.length < $get($_.props, 'min')) { //#3486
                            $j--; //#3485
                            $k[$j++] = 'bwipp.GS1valueTooShort#3485'; //#3485
                            $k[$j++] = "Too short"; //#3485
                            $k[$j++] = false; //#3485
                            return true; //#3485
                        } //#3485
                        var _bt = new Map([
                            ["N", 'lintnumeric'],
                            ["X", 'lintcset82'],
                            ["Y", 'lintcset39'],
                            ["Z", 'lintcset64']
                        ]); //#3487
                        $k[$j++] = $_.eval; //#3488
                        if ($_[$get(_bt, $get($_.props, 'cset'))]() === true) {
                            return true;
                        } //#3488
                        $forall($get($_.props, 'linters'), function() { //#3489
                            var _c3 = $_[$k[--$j]]; //#3489
                            $k[$j++] = $_.eval; //#3489
                            if (_c3() === true) {
                                return true;
                            } //#3489
                        }); //#3489
                    } //#3489
                }); //#3489
                var _c4 = $k[--$j]; //#3492
                $k[$j++] = _c4; //#3492
                if ($nt(_c4)) { //#3492
                    break; //#3492
                } //#3492
                if ($_.val.length != 0) { //#3495
                    $j--; //#3494
                    $k[$j++] = 'bwipp.GS1valueTooLong#3494'; //#3494
                    $k[$j++] = "Too long"; //#3494
                    $k[$j++] = false; //#3494
                    break; //#3494
                } //#3494
            } else { //#3497
                $j--; //#3497
                $k[$j++] = 'bwipp.GS1unknownAI#3497'; //#3497
                $k[$j++] = "Unrecognised AI"; //#3497
                $k[$j++] = false; //#3497
                break; //#3497
            } //#3497
        } //#3497
        if ($nt($k[--$j])) { //#3507
            var _c7 = $k[--$j]; //#3501
            var _c9 = $s((_c7.length + $_.ai.length) + 5); //#3501
            $puti(_c9, 0, "AI "); //#3502
            $puti(_c9, 3, $_.ai); //#3503
            $puti(_c9, 3 + $_.ai.length, ": "); //#3504
            $puti(_c9, 5 + $_.ai.length, _c7); //#3505
            $k[$j++] = _c9; //#3506
            bwipp_raiseerror(); //#3506
        } //#3506
        $_.aiexists = function() {
            $_.this = $k[--$j]; //#3511
            $_.patt = $k[--$j]; //#3512
            for (var _cF = 0, _cG = 1; _cF < _cG; _cF++) { //#3533
                var _cJ = $get($_.aivals, $_.patt) !== undefined; //#3514
                if (_cJ) { //#3514
                    $k[$j++] = true; //#3514
                    break; //#3514
                } //#3514
                if ($_.patt.length == 4) { //#3531
                    if ($eq($geti($_.patt, 3, 1), "n")) { //#3529
                        var _cP = $eq($geti($_.patt, 2, 1), "n") ? 2 : 3; //#3517
                        $_.pfxlen = _cP; //#3517
                        var _cQ = $_.ais; //#3519
                        $k[$j++] = false; //#3527
                        for (var _cR = 0, _cS = _cQ.length; _cR < _cS; _cR++) { //#3527
                            var _cT = $get(_cQ, _cR); //#3527
                            $k[$j++] = _cT; //#3526
                            if ($ne(_cT, $_.this) && (_cT.length == 4)) { //#3525
                                if ($eq($geti($k[--$j], 0, $_.pfxlen), $geti($_.patt, 0, $_.pfxlen))) { //#3523
                                    $j--; //#3522
                                    $k[$j++] = true; //#3522
                                } //#3522
                            } else { //#3525
                                $j--; //#3525
                            } //#3525
                        } //#3525
                        break; //#3528
                    } //#3528
                    $k[$j++] = false; //#3530
                    break; //#3530
                } //#3530
                $k[$j++] = false; //#3532
                break; //#3532
            } //#3532
        }; //#3532
        var _cb = $_.vals; //#3537
        $_.aivals = new Map; //#3537
        for (var _ce = 0, _cd = $_.vals.length - 1; _ce <= _cd; _ce += 1) { //#3552
            $_.ai = $get($_.ais, _ce); //#3539
            $_.val = $get($_.vals, _ce); //#3540
            var _cl = $get($_.aivals, $_.ai) !== undefined; //#3541
            if (_cl) { //#3550
                if ($ne($get($_.aivals, $_.ai), $_.val)) { //#3548
                    var _cr = $s($_.ai.length + 40); //#3543
                    $puti(_cr, 0, "Repeated AIs ("); //#3544
                    $puti(_cr, 14, $_.ai); //#3545
                    $puti(_cr, 14 + $_.ai.length, ") must have the same value"); //#3546
                    $k[$j++] = 'bwipp.GS1repeatedDifferingAIs#3547'; //#3547
                    $k[$j++] = _cr; //#3547
                    bwipp_raiseerror(); //#3547
                } //#3547
            } else { //#3550
                $put($_.aivals, $_.ai, $_.val); //#3550
            } //#3550
        } //#3550
        for (var _cz = 0, _cy = $_.vals.length - 1; _cz <= _cy; _cz += 1) { //#3594
            $_.ai = $get($_.ais, _cz); //#3556
            var _d4 = $get($_.gs1syntax, $_.ai); //#3557
            var _d5 = $get(_d4, 'ex') !== undefined; //#3557
            $k[$j++] = _d4; //#3572
            $k[$j++] = 'ex'; //#3572
            if (_d5) { //#3571
                var _d6 = $k[--$j]; //#3558
                $forall($get($k[--$j], _d6), function() { //#3569
                    $_.patt = $k[--$j]; //#3559
                    $k[$j++] = $_.patt; //#3560
                    $k[$j++] = $_.ai; //#3560
                    $_.aiexists(); //#3560
                    if ($k[--$j]) { //#3568
                        var _dF = $s(($_.ai.length + $_.patt.length) + 36); //#3561
                        $puti(_dF, 0, "AIs ("); //#3562
                        $puti(_dF, 5, $_.ai); //#3563
                        $puti(_dF, 5 + $_.ai.length, ") and ("); //#3564
                        $puti(_dF, 12 + $_.ai.length, $_.patt); //#3565
                        $puti(_dF, (12 + $_.ai.length) + $_.patt.length, ") are mutually exclusive"); //#3566
                        $k[$j++] = 'bwipp.GS1exclusiveAIs#3567'; //#3567
                        $k[$j++] = _dF; //#3567
                        bwipp_raiseerror(); //#3567
                    } //#3567
                }); //#3567
            } else { //#3571
                $j -= 2; //#3571
            } //#3571
            if ($_.lintreqs) { //#3593
                var _dP = $get($_.gs1syntax, $_.ai); //#3574
                var _dQ = $get(_dP, 'req') !== undefined; //#3574
                $k[$j++] = _dP; //#3592
                $k[$j++] = 'req'; //#3592
                if (_dQ) { //#3591
                    var _dR = $k[--$j]; //#3575
                    $forall($get($k[--$j], _dR), function() { //#3589
                        var _dU = $k[--$j]; //#3576
                        $k[$j++] = false; //#3581
                        $forall(_dU, function() { //#3581
                            var _dV = $k[--$j]; //#3577
                            $k[$j++] = true; //#3579
                            $forall(_dV, function() { //#3579
                                $k[$j++] = $_.ai; //#3578
                                $_.aiexists(); //#3578
                                if ($nt($k[--$j])) { //#3578
                                    $j--; //#3578
                                    $k[$j++] = false; //#3578
                                } //#3578
                            }); //#3578
                            if ($k[--$j]) { //#3580
                                $j--; //#3580
                                $k[$j++] = true; //#3580
                                return true; //#3580
                            } //#3580
                        }); //#3580
                        if ($nt($k[--$j])) { //#3588
                            var _db = $s($_.ai.length + 47); //#3583
                            $puti(_db, 0, "One of more requisite AIs for AI ("); //#3584
                            $puti(_db, 34, $_.ai); //#3585
                            $puti(_db, 34 + $_.ai.length, ") are missing"); //#3586
                            $k[$j++] = 'bwipp.GS1missingAIs#3587'; //#3587
                            $k[$j++] = _db; //#3587
                            bwipp_raiseerror(); //#3587
                        } //#3587
                    }); //#3587
                } else { //#3591
                    $j -= 2; //#3591
                } //#3591
            } //#3591
        } //#3591
    } //#3591
    $k[$j++] = $_.ais; //#3600
    $k[$j++] = $_.vals; //#3600
    $k[$j++] = $_.fncs; //#3600
    $_ = Object.getPrototypeOf($_); //#3600
    $_ = Object.getPrototypeOf($_); //#3602
} //bwipp_gs1process
function bwipp_renmatrix() {
    if ($_.bwipjs_dontdraw) { //#3896
        return; //#3896
    } //#3896
    $_ = Object.create($_); //#3898
    $_.width = 1; //#3901
    $_.height = 1; //#3902
    $_.bordercolor = "unset"; //#3903
    $_.barcolor = "unset"; //#3904
    $_.backgroundcolor = "unset"; //#3905
    $_.colormap = "unset"; //#3906
    $_.dotty = false; //#3907
    $_.inkspread = null; //#3908
    $_.inkspreadh = null; //#3909
    $_.inkspreadv = null; //#3910
    $_.includetext = false; //#3911
    $_.txt = $a([]); //#3912
    $_.textcolor = "unset"; //#3913
    $_.textxalign = "unset"; //#3914
    $_.textyalign = "unset"; //#3915
    $_.textfont = "OCR-B"; //#3916
    $_.textsize = 10; //#3917
    $_.textxoffset = 0; //#3918
    $_.textyoffset = 0; //#3919
    $_.textgaps = 0; //#3920
    $_.alttext = ""; //#3921
    $_.showborder = false; //#3922
    $_.borderleft = 0; //#3923
    $_.borderright = 0; //#3924
    $_.bordertop = 0; //#3925
    $_.borderbottom = 0; //#3926
    $_.borderwidth = 0.25; //#3927
    $forall($k[--$j], function() { //#3929
        var _3 = $k[--$j]; //#3929
        $_[$k[--$j]] = _3; //#3929
    }); //#3929
    $k[$j++] = $_.opt; //#3930
    delete $_['opt']; //#3930
    $k[$j++] = $_; //#3930
    bwipp_processoptions(); //#3930
    $j--; //#3930
    if ($eq($_.inkspread, null)) { //#3932
        $_.inkspread = 0; //#3932
    } //#3932
    if ($eq($_.inkspreadh, null)) { //#3933
        $_.inkspreadh = $_.inkspread; //#3933
    } //#3933
    if ($eq($_.inkspreadv, null)) { //#3934
        $_.inkspreadv = $_.inkspread; //#3934
    } //#3934
    if ($_.textsize <= 0) { //#3938
        $k[$j++] = 'bwipp.renmatrixBadTextsize#3937'; //#3937
        $k[$j++] = "The font size must be greater than zero"; //#3937
        bwipp_raiseerror(); //#3937
    } //#3937
    $_.xyget = function() {
        var _D = $k[--$j]; //#3940
        var _G = $get($_.pixs, $f($k[--$j] + (_D * $_.pixx))); //#3940
        $k[$j++] = _G; //#3940
    }; //#3940
    $_.cget = function() {
        var _I = $k[--$j]; //#3941
        var _L = $get($_.cache, $f($k[--$j] + (_I * $_.pixx))); //#3941
        var _M = $k[--$j]; //#3941
        $k[$j++] = $an(_M, _L); //#3941
    }; //#3941
    $_.cput = function() {
        var _N = $k[--$j]; //#3943
        $k[$j++] = _N; //#3947
        if ((_N % 4) == 0) { //#3946
            var _O = $k[--$j]; //#3944
            var _P = $k[--$j]; //#3944
            var _Q = $k[--$j]; //#3944
            var _R = $_.pixx; //#3944
            var _S = $_.cache; //#3944
            $put(_S, $f(_Q + (_P * _R)), $or($get(_S, $f(_Q + (_P * _R))), _O)); //#3944
        } else { //#3946
            $j -= 3; //#3946
        } //#3946
    }; //#3946
    $_.abcd = function() {
        $k[$j++] = $s(4); //#3955
        $k[$j++] = 0; //#3955
        $k[$j++] = Infinity; //#3951
        var _V = $k[--$j]; //#3952
        var _W = $k[--$j]; //#3952
        var _X = $k[--$j]; //#3952
        var _Y = $k[--$j]; //#3952
        var _b = $f($k[--$j] + (_Y * $_.pixx)); //#3953
        $k[$j++] = _X; //#3954
        $k[$j++] = _W; //#3954
        $k[$j++] = _V; //#3954
        $k[$j++] = _b; //#3954
        $aload($geti($_.pixs, _b, 2)); //#3954
        var _e = $k[--$j]; //#3954
        var _f = $k[--$j]; //#3954
        var _j = $geti($_.pixs, $f($k[--$j] + $_.pixx), 2); //#3955
        $k[$j++] = _f; //#3955
        $k[$j++] = _e; //#3955
        $aload(_j); //#3955
        var _k = $a(); //#3955
        for (var _l = 0, _m = _k.length; _l < _m; _l++) { //#3956
            var _o = $k[--$j]; //#3956
            var _p = $k[--$j]; //#3956
            $put(_p, _o, $f($get(_k, _l) + 48)); //#3956
            $k[$j++] = _p; //#3956
            $k[$j++] = $f(_o + 1); //#3956
        } //#3956
        $j--; //#3956
    }; //#3956
    $_.right = function() {
        if ($_.dir != 1) { //#3959
            $k[$j++] = $_.x; //#3959
            $k[$j++] = $_.y; //#3959
            $k[$j++] = $_.dir; //#3959
            $_.cput(); //#3959
            $k[$j++] = $a([$_.x, $_.y]); //#3959
        } //#3959
        $_.x = $_.x + 1; //#3959
        $_.dir = 1; //#3959
    }; //#3959
    $_.down = function() {
        if ($_.dir != 2) { //#3960
            $k[$j++] = $_.x; //#3960
            $k[$j++] = $_.y; //#3960
            $k[$j++] = $_.dir; //#3960
            $_.cput(); //#3960
            $k[$j++] = $a([$_.x, $_.y]); //#3960
        } //#3960
        $_.y = $_.y + 1; //#3960
        $_.dir = 2; //#3960
    }; //#3960
    $_.left = function() {
        if ($_.dir != 4) { //#3961
            $k[$j++] = $_.x; //#3961
            $k[$j++] = $_.y; //#3961
            $k[$j++] = $_.dir; //#3961
            $_.cput(); //#3961
            $k[$j++] = $a([$_.x, $_.y]); //#3961
        } //#3961
        $_.x = $_.x - 1; //#3961
        $_.dir = 4; //#3961
    }; //#3961
    $_.up = function() {
        if ($_.dir != 8) { //#3962
            $k[$j++] = $_.x; //#3962
            $k[$j++] = $_.y; //#3962
            $k[$j++] = $_.dir; //#3962
            $_.cput(); //#3962
            $k[$j++] = $a([$_.x, $_.y]); //#3962
        } //#3962
        $_.y = $_.y - 1; //#3962
        $_.dir = 8; //#3962
    }; //#3962
    $_.trace = function() {
        $_.y = $k[--$j]; //#3966
        $_.x = $k[--$j]; //#3966
        $k[$j++] = 'dir'; //#3968
        $k[$j++] = $f($_.x + 1); //#3968
        $k[$j++] = $f($_.y + 1); //#3968
        $_.xyget(); //#3968
        var _1R = ($k[--$j] == 1) ? 8 : 4; //#3968
        $_[$k[--$j]] = _1R; //#3968
        $_.sx = $_.x; //#3969
        $_.sy = $_.y; //#3969
        $_.sdir = $_.dir; //#3969
        $k[$j++] = Infinity; //#3973
        for (;;) { //#3987
            $k[$j++] = $_.x; //#3974
            $k[$j++] = $_.y; //#3974
            $_.abcd(); //#3974
            for (var _1Y = 0, _1Z = 1; _1Y < _1Z; _1Y++) { //#3985
                var _1a = $k[--$j]; //#3976
                $k[$j++] = _1a; //#3976
                if ($eq(_1a, "0001") || ($eq(_1a, "0011") || $eq(_1a, "1011"))) { //#3976
                    $j--; //#3976
                    $_.right(); //#3976
                    break; //#3976
                } //#3976
                var _1b = $k[--$j]; //#3977
                $k[$j++] = _1b; //#3977
                if ($eq(_1b, "0010") || ($eq(_1b, "1010") || $eq(_1b, "1110"))) { //#3977
                    $j--; //#3977
                    $_.down(); //#3977
                    break; //#3977
                } //#3977
                var _1c = $k[--$j]; //#3978
                $k[$j++] = _1c; //#3978
                if ($eq(_1c, "1000") || ($eq(_1c, "1100") || $eq(_1c, "1101"))) { //#3978
                    $j--; //#3978
                    $_.left(); //#3978
                    break; //#3978
                } //#3978
                var _1d = $k[--$j]; //#3979
                $k[$j++] = _1d; //#3979
                if ($eq(_1d, "0100") || ($eq(_1d, "0101") || $eq(_1d, "0111"))) { //#3979
                    $j--; //#3979
                    $_.up(); //#3979
                    break; //#3979
                } //#3979
                var _1e = $k[--$j]; //#3980
                $k[$j++] = _1e; //#3984
                if ($eq(_1e, "1001")) { //#3983
                    if ($_.dir == 2) { //#3981
                        $j--; //#3981
                        $_.left(); //#3981
                        break; //#3981
                    } else { //#3981
                        $j--; //#3981
                        $_.right(); //#3981
                        break; //#3981
                    } //#3981
                } else { //#3983
                    if ($_.dir == 1) { //#3983
                        $j--; //#3983
                        $_.down(); //#3983
                        break; //#3983
                    } else { //#3983
                        $j--; //#3983
                        $_.up(); //#3983
                        break; //#3983
                    } //#3983
                } //#3983
            } //#3983
            if (($eq($_.x, $_.sx) && $eq($_.y, $_.sy)) && ($_.dir == $_.sdir)) { //#3986
                break; //#3986
            } //#3986
        } //#3986
        $astore($a($counttomark())); //#3988
        var _1p = $k[--$j]; //#3988
        var _1q = $k[--$j]; //#3988
        $k[$j++] = _1p; //#3988
        $k[$j++] = _1q; //#3988
        $j--; //#3988
    }; //#3988
    $_.drawlayer = function() {
        $_.pixsorig = $_.pixs; //#4033
        $_.pixs = $k[--$j]; //#4034
        $k[$j++] = Infinity; //#4037
        for (var _1u = 0, _1v = $_.pixx + 2; _1u < _1v; _1u++) { //#4038
            $k[$j++] = 0; //#4038
        } //#4038
        for (var _1z = 0, _20 = $_.pixx, _1y = $_.pixs.length - 1; _20 < 0 ? _1z >= _1y : _1z <= _1y; _1z += _20) { //#4043
            $k[$j++] = 0; //#4041
            $aload($geti($_.pixs, _1z, $_.pixx)); //#4041
            $k[$j++] = 0; //#4042
        } //#4042
        for (var _25 = 0, _26 = $_.pixx + 2; _25 < _26; _25++) { //#4044
            $k[$j++] = 0; //#4044
        } //#4044
        $_.pixs = $a(); //#4044
        $_.pixx = $_.pixx + 2; //#4046
        $_.pixy = $_.pixy + 2; //#4047
        $k[$j++] = Infinity; //#4050
        for (var _2B = 0, _2C = $_.pixs.length; _2B < _2C; _2B++) { //#4050
            $k[$j++] = 0; //#4050
        } //#4050
        $_.cache = $a(); //#4050
        $k[$j++] = Infinity; //#4053
        for (var _2G = 0, _2F = $_.pixy - 2; _2G <= _2F; _2G += 1) { //#4070
            $_.j = _2G; //#4055
            for (var _2J = 0, _2I = $_.pixx - 2; _2J <= _2I; _2J += 1) { //#4069
                $_.i = _2J; //#4057
                $k[$j++] = 'k'; //#4058
                $k[$j++] = $_.i; //#4058
                $k[$j++] = $_.j; //#4058
                $_.abcd(); //#4058
                var _2M = $k[--$j]; //#4058
                $_[$k[--$j]] = _2M; //#4058
                if ($eq($_.k, "0001") || $eq($_.k, "1001")) { //#4063
                    $k[$j++] = 8; //#4060
                    $k[$j++] = $_.i; //#4060
                    $k[$j++] = $_.j; //#4060
                    $_.cget(); //#4060
                    if ($k[--$j] == 0) { //#4062
                        $k[$j++] = $_.i; //#4061
                        $k[$j++] = $_.j; //#4061
                        $_.trace(); //#4061
                    } //#4061
                } //#4061
                if ($eq($_.k, "1110")) { //#4068
                    $k[$j++] = 4; //#4065
                    $k[$j++] = $_.i; //#4065
                    $k[$j++] = $_.j; //#4065
                    $_.cget(); //#4065
                    if ($k[--$j] == 0) { //#4067
                        $k[$j++] = $_.i; //#4066
                        $k[$j++] = $_.j; //#4066
                        $_.trace(); //#4066
                    } //#4066
                } //#4066
            } //#4066
        } //#4066
        $_.paths = $a(); //#4066
        $_.pixx = $_.pixx - 2; //#4074
        $_.pixy = $_.pixy - 2; //#4075
        $$.newpath(); //#4078
        var _2e = $_.paths; //#4079
        for (var _2f = 0, _2g = _2e.length; _2f < _2g; _2f++) { //#4097
            $_.p = $get(_2e, _2f); //#4080
            $_.len = $_.p.length; //#4081
            $aload($get($_.p, $_.len - 1)); //#4082
            $aload($get($_.p, 0)); //#4083
            for (var _2q = 0, _2p = $_.len - 1; _2q <= _2p; _2q += 1) { //#4094
                $_.i = _2q; //#4085
                $aload($get($_.p, ($_.i + 1) % $_.len)); //#4086
                var _2v = $k[--$j]; //#4086
                var _2w = $k[--$j]; //#4086
                var _2x = $k[--$j]; //#4086
                var _2y = $k[--$j]; //#4086
                var _2z = $k[--$j]; //#4086
                var _30 = $k[--$j]; //#4086
                $k[$j++] = _2y; //#4088
                $k[$j++] = _2x; //#4088
                $k[$j++] = _2w; //#4088
                $k[$j++] = _2v; //#4088
                $k[$j++] = _30; //#4088
                $k[$j++] = _2y; //#4088
                $k[$j++] = $_.inkspreadh; //#4088
                if ($lt(_2v, _2z)) { //#4088
                    var _32 = $k[--$j]; //#4088
                    var _33 = $k[--$j]; //#4088
                    $k[$j++] = $f(_33 + _32); //#4088
                } else { //#4088
                    var _34 = $k[--$j]; //#4088
                    var _35 = $k[--$j]; //#4088
                    $k[$j++] = $f(_35 - _34); //#4088
                } //#4088
                var _36 = $k[--$j]; //#4089
                var _37 = $k[--$j]; //#4089
                var _38 = $k[--$j]; //#4089
                var _39 = $k[--$j]; //#4089
                var _3A = $k[--$j]; //#4090
                $k[$j++] = _3A; //#4091
                $k[$j++] = _36; //#4091
                $k[$j++] = _39; //#4091
                $k[$j++] = _38; //#4091
                $k[$j++] = _3A; //#4091
                $k[$j++] = $_.inkspreadv; //#4091
                if ($gt(_39, _37)) { //#4091
                    var _3C = $k[--$j]; //#4091
                    var _3D = $k[--$j]; //#4091
                    $k[$j++] = $f(_3D + _3C); //#4091
                } else { //#4091
                    var _3E = $k[--$j]; //#4091
                    var _3F = $k[--$j]; //#4091
                    $k[$j++] = $f(_3F - _3E); //#4091
                } //#4091
                var _3G = $k[--$j]; //#4092
                var _3H = $k[--$j]; //#4092
                var _3I = $k[--$j]; //#4092
                var _3J = $k[--$j]; //#4092
                $k[$j++] = _3I; //#4093
                $k[$j++] = _3H; //#4093
                $k[$j++] = _3J; //#4093
                $k[$j++] = $f($_.pixy - _3G); //#4093
                if ($_.i == 0) { //#4093
                    var _3M = $k[--$j]; //#4093
                    $$.moveto($k[--$j], _3M); //#4093
                } else { //#4093
                    var _3O = $k[--$j]; //#4093
                    $$.lineto($k[--$j], _3O); //#4093
                } //#4093
            } //#4093
            $$.closepath(); //#4095
            $j -= 4; //#4096
        } //#4096
        $$.fill(); //#4098
        $_.pixs = $_.pixsorig; //#4100
    }; //#4100
    $_.drawlayerdots = function() {
        $_.pixsorig = $_.pixs; //#4106
        $_.pixs = $k[--$j]; //#4107
        $$.newpath(); //#4109
        for (var _3V = 0, _3U = $_.pixs.length - 1; _3V <= _3U; _3V += 1) { //#4117
            $_.x = _3V % $_.pixx; //#4111
            $_.y = ~~(_3V / $_.pixx); //#4112
            $k[$j++] = $_.x; //#4113
            $k[$j++] = $_.y; //#4113
            $_.xyget(); //#4113
            if ($k[--$j] == 1) { //#4116
                $$.moveto($f($_.x + 0.5), $f(($_.pixy - $_.y) - 0.5)); //#4114
                $$.arc($f($_.x + 0.5), $f(($_.pixy - $_.y) - 0.5), $f(0.5 - $_.inkspread), 0, 360, 1); //#4115
            } //#4115
        } //#4115
        $$.fill(); //#4118
        $_.pixs = $_.pixsorig; //#4120
    }; //#4120
    $$.save(); //#4124
    var _3j = $$.currpos(); //#4126
    $$.translate(_3j.x, _3j.y); //#4126
    $_.inkspread = $_.inkspread / 2; //#4128
    $_.inkspreadh = $_.inkspreadh / 2; //#4129
    $_.inkspreadv = $_.inkspreadv / 2; //#4130
    $$.scale(($_.width / $_.pixx) * 72, ($_.height / $_.pixy) * 72); //#4133
    $_.tl = $a([-($f($_.borderleft + ($_.borderwidth / 2))), $f(($_.pixy + $_.bordertop) + ($_.borderwidth / 2))]); //#4136
    $_.tr = $a([$f(($_.pixx + $_.borderright) + ($_.borderwidth / 2)), $f(($_.pixy + $_.bordertop) + ($_.borderwidth / 2))]); //#4137
    $_.bl = $a([-($f($_.borderleft + ($_.borderwidth / 2))), -($f($_.borderbottom + ($_.borderwidth / 2)))]); //#4138
    $_.br = $a([$f(($_.pixx + $_.borderright) + ($_.borderwidth / 2)), -($f($_.borderbottom + ($_.borderwidth / 2)))]); //#4139
    if ($ne($_.backgroundcolor, "unset")) { //#4145
        $$.save(); //#4141
        $$.newpath(); //#4142
        $aload($_.bl); //#4142
        var _4H = $k[--$j]; //#4142
        $$.moveto($k[--$j], _4H); //#4142
        var _4M = $a([$_.br, $_.tr, $_.tl]); //#4142
        for (var _4N = 0, _4O = _4M.length; _4N < _4O; _4N++) { //#4142
            $aload($get(_4M, _4N)); //#4142
            var _4Q = $k[--$j]; //#4142
            $$.lineto($k[--$j], _4Q); //#4142
        } //#4142
        $$.closepath(); //#4142
        $$.setcolor($_.backgroundcolor); //#4143
        $$.fill(); //#4143
        $$.restore(); //#4144
    } //#4144
    if ($_.showborder) { //#4152
        $$.save(); //#4147
        $$.newpath(); //#4148
        $aload($_.bl); //#4148
        var _4V = $k[--$j]; //#4148
        $$.moveto($k[--$j], _4V); //#4148
        var _4a = $a([$_.br, $_.tr, $_.tl]); //#4148
        for (var _4b = 0, _4c = _4a.length; _4b < _4c; _4b++) { //#4148
            $aload($get(_4a, _4b)); //#4148
            var _4e = $k[--$j]; //#4148
            $$.lineto($k[--$j], _4e); //#4148
        } //#4148
        $$.closepath(); //#4148
        if ($ne($_.bordercolor, "unset")) { //#4149
            $$.setcolor($_.bordercolor); //#4149
        } //#4149
        $$.setlinewidth($f($_.borderwidth - ($_.inkspread * 2))); //#4150
        $$.stroke(); //#4150
        $$.restore(); //#4151
    } //#4151
    if ($eq($_.colormap, "unset")) { //#4157
        var _4m = new Map([
            [1, $_.barcolor]
        ]); //#4156
        $_.colormap = _4m; //#4156
    } //#4156
    var _4n = $_.colormap; //#4159
    for (var _4s = _4n.size, _4r = _4n.keys(), _4q = 0; _4q < _4s; _4q++) { //#4165
        var _4o = _4r.next().value; //#4165
        var _4p = _4n.get(_4o); //#4165
        $k[$j++] = _4o; //#4160
        $k[$j++] = _4p; //#4160
        if ($ne(_4p, "unset")) { //#4160
            $$.setcolor($k[--$j]); //#4160
        } else { //#4160
            $j--; //#4160
        } //#4160
        $_.key = $k[--$j]; //#4161
        $k[$j++] = Infinity; //#4162
        var _4v = $_.pixs; //#4163
        for (var _4w = 0, _4x = _4v.length; _4w < _4x; _4w++) { //#4163
            var _50 = $eq($get(_4v, _4w), $_.key) ? 1 : 0; //#4163
            $k[$j++] = _50; //#4163
        } //#4163
        var _51 = $a(); //#4163
        $k[$j++] = _51; //#4164
        if ($_.dotty) { //#4164
            $_.drawlayerdots(); //#4164
        } else { //#4164
            $_.drawlayer(); //#4164
        } //#4164
    } //#4164
    if ($ne($_.textcolor, "unset")) { //#4168
        $$.setcolor($_.textcolor); //#4168
    } //#4168
    if ($_.includetext) { //#4229
        if (($eq($_.textxalign, "unset") && $eq($_.textyalign, "unset")) && $eq($_.alttext, "")) { //#4227
            $_.s = 0; //#4171
            $_.fn = ""; //#4171
            var _59 = $_.txt; //#4172
            for (var _5A = 0, _5B = _59.length; _5A < _5B; _5A++) { //#4185
                $forall($get(_59, _5A)); //#4173
                var _5D = $k[--$j]; //#4174
                var _5E = $k[--$j]; //#4174
                $k[$j++] = _5E; //#4183
                $k[$j++] = _5D; //#4183
                if ((_5D != $_.s) || $ne(_5E, $_.fn)) { //#4182
                    var _5H = $k[--$j]; //#4175
                    $k[$j++] = _5H; //#4178
                    if (_5H <= 0) { //#4178
                        $j -= 5; //#4176
                        $k[$j++] = 'bwipp.renmatrixFontTooSmall#4177'; //#4177
                        $k[$j++] = "The font size is too small"; //#4177
                        bwipp_raiseerror(); //#4177
                    } //#4177
                    var _5I = $k[--$j]; //#4179
                    var _5J = $k[--$j]; //#4179
                    $_.s = _5I; //#4179
                    $_.fn = _5J; //#4179
                    $$.selectfont(_5J, _5I); //#4180
                } else { //#4182
                    $j -= 2; //#4182
                } //#4182
                var _5K = $k[--$j]; //#4184
                $$.moveto($k[--$j], _5K); //#4184
                $$.show($k[--$j], 0, 0); //#4184
            } //#4184
        } else { //#4227
            $$.selectfont($_.textfont, $_.textsize); //#4187
            if ($eq($_.alttext, "")) { //#4193
                $k[$j++] = Infinity; //#4189
                var _5Q = $_.txt; //#4189
                for (var _5R = 0, _5S = _5Q.length; _5R < _5S; _5R++) { //#4189
                    $forall($get($get(_5Q, _5R), 0)); //#4189
                } //#4189
                $_.txt = $a(); //#4189
                $_.tstr = $s($_.txt.length); //#4190
                for (var _5a = 0, _5Z = $_.txt.length - 1; _5a <= _5Z; _5a += 1) { //#4191
                    $put($_.tstr, _5a, $get($_.txt, _5a)); //#4191
                } //#4191
            } else { //#4193
                $_.tstr = $_.alttext; //#4193
            } //#4193
            if ($_.tstr.length == 0) { //#4203
                $k[$j++] = 0; //#4198
            } else { //#4203
                $$.save(); //#4200
                $$.newpath(); //#4201
                $$.moveto(0, 0); //#4201
                $$.charpath("0", false); //#4201
                var _5g = $$.pathbbox(); //#4201
                $$.restore(); //#4203
                $k[$j++] = _5g.ury; //#4203
            } //#4203
            $_.textascent = $k[--$j]; //#4212
            var _5j = $$.stringwidth($_.tstr); //#4213
            $_.textwidth = $f(_5j.w + (($_.tstr.length - 1) * $_.textgaps)); //#4213
            $_.textxpos = $f($_.textxoffset + ($f($_.pixx - $_.textwidth) / 2)); //#4215
            if ($eq($_.textxalign, "left")) { //#4216
                $_.textxpos = $_.textxoffset; //#4216
            } //#4216
            if ($eq($_.textxalign, "right")) { //#4217
                $_.textxpos = $f(($_.pixx - $_.textxoffset) - $_.textwidth); //#4217
            } //#4217
            if ($eq($_.textxalign, "offleft")) { //#4218
                $_.textxpos = -$f($_.textwidth + $_.textxoffset); //#4218
            } //#4218
            if ($eq($_.textxalign, "offright")) { //#4219
                $_.textxpos = $_.pixx + $_.textxoffset; //#4219
            } //#4219
            if ($eq($_.textxalign, "justify") && ($_.textwidth < $_.pixx)) { //#4223
                $_.textxpos = 0; //#4221
                $_.textgaps = $f($_.pixx - $_.textwidth) / ($_.tstr.length - 1); //#4222
            } //#4222
            $_.textypos = -($f($f($_.textyoffset + $_.textascent) + 1)); //#4224
            if ($eq($_.textyalign, "above")) { //#4225
                $_.textypos = ($_.textyoffset + $_.pixy) + 1; //#4225
            } //#4225
            if ($eq($_.textyalign, "center")) { //#4226
                $_.textypos = $f($_.textyoffset + ($f($_.pixy - $_.textascent) / 2)); //#4226
            } //#4226
            $$.moveto($_.textxpos, $_.textypos); //#4227
            $$.show($_.tstr, $_.textgaps, 0); //#4227
        } //#4227
    } //#4227
    $$.restore(); //#4231
    $_ = Object.getPrototypeOf($_); //#4233
} //bwipp_renmatrix
function bwipp_ean5() {
    $_ = Object.create($_); //#4400
    $_.dontdraw = false; //#4403
    $_.includetext = false; //#4404
    $_.textfont = "OCR-B"; //#4405
    $_.textsize = 12; //#4406
    $_.textxoffset = 0; //#4407
    $_.textyoffset = null; //#4408
    $_.height = 0.7; //#4409
    $k[$j++] = $_; //#4411
    bwipp_processoptions(); //#4411
    $_.options = $k[--$j]; //#4411
    $_.barcode = $k[--$j]; //#4412
    if ($eq($_.textyoffset, null)) { //#4416
        $_.textyoffset = $f(($_.height * 72) + 1); //#4415
    } //#4415
    bwipp_loadctx(bwipp_ean5) //#4418
    if ($_.barcode.length != 5) { //#4423
        $k[$j++] = 'bwipp.ean5badLength#4422'; //#4422
        $k[$j++] = "EAN-5 add-on must be 5 digits"; //#4422
        bwipp_raiseerror(); //#4422
    } //#4422
    $forall($_.barcode, function() { //#4428
        var _6 = $k[--$j]; //#4425
        if ((_6 < 48) || (_6 > 57)) { //#4427
            $k[$j++] = 'bwipp.ean5badCharacter#4426'; //#4426
            $k[$j++] = "EAN-5 add-on must contain only digits"; //#4426
            bwipp_raiseerror(); //#4426
        } //#4426
    }); //#4426
    if (!bwipp_ean5.__4446__) { //#4446
        $_ = Object.create($_); //#4446
        $_.encs = $a(["3211", "2221", "2122", "1411", "1132", "1231", "1114", "1312", "1213", "3112", "112", "11"]); //#4436
        $_.barchars = "0123456789"; //#4439
        $_.mirrormaps = $a(["11000", "10100", "10010", "10001", "01100", "00110", "00011", "01010", "01001", "00101"]); //#4445
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_ean5.$ctx[id] = $_[id]); //#4445
        bwipp_ean5.__4446__ = 1; //#4445
        $_ = Object.getPrototypeOf($_); //#4445
    } //#4445
    $_.checksum = 0; //#4448
    for (var _A = 0; _A <= 4; _A += 1) { //#4457
        $_.i = _A; //#4450
        $_.barchar = $f($get($_.barcode, $_.i) - 48); //#4451
        if (($_.i % 2) == 0) { //#4455
            $_.checksum = $f(($_.barchar * 3) + $_.checksum); //#4453
        } else { //#4455
            $_.checksum = $f(($_.barchar * 9) + $_.checksum); //#4455
        } //#4455
    } //#4455
    $_.checksum = $_.checksum % 10; //#4458
    $_.mirrormap = $get($_.mirrormaps, $_.checksum); //#4459
    $_.sbs = $s(31); //#4461
    $_.txt = $a(5); //#4462
    for (var _P = 0; _P <= 4; _P += 1) { //#4492
        $_.i = _P; //#4465
        if ($_.i == 0) { //#4471
            $puti($_.sbs, 0, $get($_.encs, 10)); //#4469
        } else { //#4471
            $puti($_.sbs, (($_.i - 1) * 6) + 7, $get($_.encs, 11)); //#4471
        } //#4471
        $search($_.barchars, $geti($_.barcode, $_.i, 1)); //#4475
        $j--; //#4476
        $_.indx = $k[--$j].length; //#4477
        $j -= 2; //#4478
        $_.enc = $get($_.encs, $_.indx); //#4479
        if ($get($_.mirrormap, $_.i) == 49) { //#4489
            $_.enclen = $_.enc.length; //#4481
            $_.revenc = $s($_.enclen); //#4482
            for (var _o = 0, _n = $_.enclen - 1; _o <= _n; _o += 1) { //#4487
                $_.j = _o; //#4484
                $_.char = $get($_.enc, $_.j); //#4485
                $put($_.revenc, ($_.enclen - $_.j) - 1, $_.char); //#4486
            } //#4486
            $_.enc = $_.revenc; //#4488
        } //#4488
        $puti($_.sbs, ($_.i * 6) + 3, $_.enc); //#4490
        $put($_.txt, $_.i, $a([$geti($_.barcode, $_.i, 1), ((($_.i - 1) * 9) + 10) + $_.textxoffset, $_.textyoffset, $_.textfont, $_.textsize])); //#4491
    } //#4491
    $k[$j++] = Infinity; //#4495
    $k[$j++] = Infinity; //#4497
    var _1B = $_.sbs; //#4497
    for (var _1C = 0, _1D = _1B.length; _1C < _1D; _1C++) { //#4497
        $k[$j++] = $get(_1B, _1C) - 48; //#4497
    } //#4497
    var _1F = $a(); //#4497
    $k[$j++] = Infinity; //#4498
    for (var _1G = 0, _1H = 16; _1G < _1H; _1G++) { //#4498
        $k[$j++] = $_.height; //#4498
    } //#4498
    var _1J = $a(); //#4498
    $k[$j++] = Infinity; //#4499
    for (var _1K = 0, _1L = 16; _1K < _1L; _1K++) { //#4499
        $k[$j++] = 0; //#4499
    } //#4499
    var _1M = $a(); //#4499
    $k[$j++] = 'ren'; //#4502
    $k[$j++] = 'renlinear'; //#4502
    $k[$j++] = 'sbs'; //#4502
    $k[$j++] = _1F; //#4502
    $k[$j++] = 'bhs'; //#4502
    $k[$j++] = _1J; //#4502
    $k[$j++] = 'bbs'; //#4502
    $k[$j++] = _1M; //#4502
    if ($_.includetext) { //#4502
        $k[$j++] = 'txt'; //#4501
        $k[$j++] = $_.txt; //#4501
    } //#4501
    $k[$j++] = 'opt'; //#4508
    $k[$j++] = $_.options; //#4508
    $k[$j++] = 'guardrightpos'; //#4508
    $k[$j++] = 5; //#4508
    $k[$j++] = 'guardrightypos'; //#4508
    $k[$j++] = $f($_.textyoffset + 4); //#4508
    $k[$j++] = 'borderleft'; //#4508
    $k[$j++] = 12; //#4508
    $k[$j++] = 'borderright'; //#4508
    $k[$j++] = 5; //#4508
    $k[$j++] = 'bordertop'; //#4508
    $k[$j++] = 10; //#4508
    var _1R = $d(); //#4508
    $k[$j++] = _1R; //#4511
    if (!$_.dontdraw) { //#4511
        bwipp_renlinear(); //#4511
    } //#4511
    $_ = Object.getPrototypeOf($_); //#4513
    $_ = Object.getPrototypeOf($_); //#4515
} //bwipp_ean5
function bwipp_ean2() {
    $_ = Object.create($_); //#4545
    $_.dontdraw = false; //#4548
    $_.includetext = false; //#4549
    $_.textfont = "OCR-B"; //#4550
    $_.textsize = 12; //#4551
    $_.textxoffset = 0; //#4552
    $_.textyoffset = null; //#4553
    $_.height = 0.7; //#4554
    $k[$j++] = $_; //#4556
    bwipp_processoptions(); //#4556
    $_.options = $k[--$j]; //#4556
    $_.barcode = $k[--$j]; //#4557
    if ($eq($_.textyoffset, null)) { //#4561
        $_.textyoffset = $f(($_.height * 72) + 1); //#4560
    } //#4560
    bwipp_loadctx(bwipp_ean2) //#4563
    if ($_.barcode.length != 2) { //#4568
        $k[$j++] = 'bwipp.ean2badLength#4567'; //#4567
        $k[$j++] = "EAN-2 add-on must be 2 digits"; //#4567
        bwipp_raiseerror(); //#4567
    } //#4567
    $forall($_.barcode, function() { //#4573
        var _6 = $k[--$j]; //#4570
        if ((_6 < 48) || (_6 > 57)) { //#4572
            $k[$j++] = 'bwipp.ean2badCharacter#4571'; //#4571
            $k[$j++] = "EAN-2 add-on must contain only digits"; //#4571
            bwipp_raiseerror(); //#4571
        } //#4571
    }); //#4571
    if (!bwipp_ean2.__4588__) { //#4588
        $_ = Object.create($_); //#4588
        $_.encs = $a(["3211", "2221", "2122", "1411", "1132", "1231", "1114", "1312", "1213", "3112", "112", "11"]); //#4581
        $_.barchars = "0123456789"; //#4584
        $_.mirrormaps = $a(["00", "01", "10", "11"]); //#4587
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_ean2.$ctx[id] = $_[id]); //#4587
        bwipp_ean2.__4588__ = 1; //#4587
        $_ = Object.getPrototypeOf($_); //#4587
    } //#4587
    $_.mirrormap = $get($_.mirrormaps, $cvi($geti($_.barcode, 0, 2)) % 4); //#4590
    $_.sbs = $s(13); //#4592
    $_.txt = $a(2); //#4593
    for (var _G = 0; _G <= 1; _G += 1) { //#4623
        $_.i = _G; //#4596
        if ($_.i == 0) { //#4602
            $puti($_.sbs, 0, $get($_.encs, 10)); //#4600
        } else { //#4602
            $puti($_.sbs, (($_.i - 1) * 6) + 7, $get($_.encs, 11)); //#4602
        } //#4602
        $search($_.barchars, $geti($_.barcode, $_.i, 1)); //#4606
        $j--; //#4607
        $_.indx = $k[--$j].length; //#4608
        $j -= 2; //#4609
        $_.enc = $get($_.encs, $_.indx); //#4610
        if ($get($_.mirrormap, $_.i) == 49) { //#4620
            $_.enclen = $_.enc.length; //#4612
            $_.revenc = $s($_.enclen); //#4613
            for (var _f = 0, _e = $_.enclen - 1; _f <= _e; _f += 1) { //#4618
                $_.j = _f; //#4615
                $_.char = $get($_.enc, $_.j); //#4616
                $put($_.revenc, ($_.enclen - $_.j) - 1, $_.char); //#4617
            } //#4617
            $_.enc = $_.revenc; //#4619
        } //#4619
        $puti($_.sbs, ($_.i * 6) + 3, $_.enc); //#4621
        $put($_.txt, $_.i, $a([$geti($_.barcode, $_.i, 1), ((($_.i - 1) * 9) + 10) + $_.textxoffset, $_.textyoffset, $_.textfont, $_.textsize])); //#4622
    } //#4622
    $k[$j++] = Infinity; //#4626
    $k[$j++] = Infinity; //#4628
    var _12 = $_.sbs; //#4628
    for (var _13 = 0, _14 = _12.length; _13 < _14; _13++) { //#4628
        $k[$j++] = $get(_12, _13) - 48; //#4628
    } //#4628
    var _16 = $a(); //#4628
    $k[$j++] = Infinity; //#4629
    for (var _17 = 0, _18 = 12; _17 < _18; _17++) { //#4629
        $k[$j++] = $_.height; //#4629
    } //#4629
    var _1A = $a(); //#4629
    $k[$j++] = Infinity; //#4630
    for (var _1B = 0, _1C = 12; _1B < _1C; _1B++) { //#4630
        $k[$j++] = 0; //#4630
    } //#4630
    var _1D = $a(); //#4630
    $k[$j++] = 'ren'; //#4633
    $k[$j++] = 'renlinear'; //#4633
    $k[$j++] = 'sbs'; //#4633
    $k[$j++] = _16; //#4633
    $k[$j++] = 'bhs'; //#4633
    $k[$j++] = _1A; //#4633
    $k[$j++] = 'bbs'; //#4633
    $k[$j++] = _1D; //#4633
    if ($_.includetext) { //#4633
        $k[$j++] = 'txt'; //#4632
        $k[$j++] = $_.txt; //#4632
    } //#4632
    $k[$j++] = 'opt'; //#4639
    $k[$j++] = $_.options; //#4639
    $k[$j++] = 'guardrightpos'; //#4639
    $k[$j++] = 5; //#4639
    $k[$j++] = 'guardrightypos'; //#4639
    $k[$j++] = $f($_.textyoffset + 4); //#4639
    $k[$j++] = 'borderleft'; //#4639
    $k[$j++] = 12; //#4639
    $k[$j++] = 'borderright'; //#4639
    $k[$j++] = 5; //#4639
    $k[$j++] = 'bordertop'; //#4639
    $k[$j++] = 10; //#4639
    var _1I = $d(); //#4639
    $k[$j++] = _1I; //#4642
    if (!$_.dontdraw) { //#4642
        bwipp_renlinear(); //#4642
    } //#4642
    $_ = Object.getPrototypeOf($_); //#4644
    $_ = Object.getPrototypeOf($_); //#4646
} //bwipp_ean2
function bwipp_ean13() {
    $_ = Object.create($_); //#4678
    $_.dontdraw = false; //#4681
    $_.includetext = false; //#4682
    $_.textfont = "OCR-B"; //#4683
    $_.textsize = 12; //#4684
    $_.textxoffset = -11; //#4685
    $_.textyoffset = -4; //#4686
    $_.height = 1; //#4687
    $_.addongap = 12; //#4688
    $_.addontextfont = "unset"; //#4689
    $_.addontextsize = null; //#4690
    $_.addontextxoffset = null; //#4691
    $_.addontextyoffset = null; //#4692
    $k[$j++] = $_; //#4694
    bwipp_processoptions(); //#4694
    $_.options = $k[--$j]; //#4694
    $_.barcode = $k[--$j]; //#4695
    bwipp_loadctx(bwipp_ean13) //#4697
    $search($_.barcode, " "); //#4700
    if ($k[--$j]) { //#4706
        $_.barcode = $k[--$j]; //#4701
        $j--; //#4702
        $_.addon = $k[--$j]; //#4703
    } else { //#4706
        $j--; //#4705
        $_.addon = ""; //#4706
    } //#4706
    if (($_.barcode.length != 12) && ($_.barcode.length != 13)) { //#4712
        $k[$j++] = 'bwipp.ean13badLength#4711'; //#4711
        $k[$j++] = "EAN-13 must be 12 or 13 digits"; //#4711
        bwipp_raiseerror(); //#4711
    } //#4711
    $forall($_.barcode, function() { //#4717
        var _9 = $k[--$j]; //#4714
        if ((_9 < 48) || (_9 > 57)) { //#4716
            $k[$j++] = 'bwipp.ean13badCharacter#4715'; //#4715
            $k[$j++] = "EAN-13 must contain only digits"; //#4715
            bwipp_raiseerror(); //#4715
        } //#4715
    }); //#4715
    if ((($_.addon.length != 0) && ($_.addon.length != 2)) && ($_.addon.length != 5)) { //#4720
        $k[$j++] = 'bwipp.ean13badAddOnLength#4719'; //#4719
        $k[$j++] = "Add-on for EAN-13 must be 2 or 5 digits"; //#4719
        bwipp_raiseerror(); //#4719
    } //#4719
    $_.pad = $s(13); //#4723
    $_.checksum = 0; //#4724
    for (var _E = 0; _E <= 11; _E += 1) { //#4733
        $_.i = _E; //#4726
        $_.barchar = $f($get($_.barcode, $_.i) - 48); //#4727
        if (($_.i % 2) == 0) { //#4731
            $_.checksum = $f($_.barchar + $_.checksum); //#4729
        } else { //#4731
            $_.checksum = $f(($_.barchar * 3) + $_.checksum); //#4731
        } //#4731
    } //#4731
    $_.checksum = ($f(10 - ($_.checksum % 10))) % 10; //#4734
    if ($_.barcode.length == 13) { //#4739
        if ($get($_.barcode, 12) != $f($_.checksum + 48)) { //#4738
            $k[$j++] = 'bwipp.ean13badCheckDigit#4737'; //#4737
            $k[$j++] = "Incorrect EAN-13 check digit provided"; //#4737
            bwipp_raiseerror(); //#4737
        } //#4737
    } //#4737
    $puti($_.pad, 0, $_.barcode); //#4740
    $put($_.pad, 12, $f($_.checksum + 48)); //#4741
    $_.barcode = $_.pad; //#4742
    if (!bwipp_ean13.__4760__) { //#4760
        $_ = Object.create($_); //#4760
        $_.encs = $a(["3211", "2221", "2122", "1411", "1132", "1231", "1114", "1312", "1213", "3112", "111", "11111", "111"]); //#4750
        $_.barchars = "0123456789"; //#4753
        $_.mirrormaps = $a(["000000", "001011", "001101", "001110", "010011", "011001", "011100", "010101", "010110", "011010"]); //#4759
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_ean13.$ctx[id] = $_[id]); //#4759
        bwipp_ean13.__4760__ = 1; //#4759
        $_ = Object.getPrototypeOf($_); //#4759
    } //#4759
    $_.sbs = $s(59); //#4762
    $_.txt = $a(13); //#4763
    $puti($_.sbs, 0, $get($_.encs, 10)); //#4766
    $_.mirrormap = $get($_.mirrormaps, $get($_.barcode, 0) - 48); //#4769
    $put($_.txt, 0, $a([$geti($_.barcode, 0, 1), $_.textxoffset, $_.textyoffset, $_.textfont, $_.textsize])); //#4770
    for (var _r = 1; _r <= 6; _r += 1) { //#4793
        $_.i = _r; //#4775
        $search($_.barchars, $geti($_.barcode, $_.i, 1)); //#4776
        $j--; //#4777
        $_.indx = $k[--$j].length; //#4778
        $j -= 2; //#4779
        $_.enc = $get($_.encs, $_.indx); //#4780
        if ($get($_.mirrormap, $_.i - 1) == 49) { //#4790
            $_.enclen = $_.enc.length; //#4782
            $_.revenc = $s($_.enclen); //#4783
            for (var _18 = 0, _17 = $_.enclen - 1; _18 <= _17; _18 += 1) { //#4788
                $_.j = _18; //#4785
                $_.char = $get($_.enc, $_.j); //#4786
                $put($_.revenc, ($_.enclen - $_.j) - 1, $_.char); //#4787
            } //#4787
            $_.enc = $_.revenc; //#4789
        } //#4789
        $puti($_.sbs, (($_.i - 1) * 4) + 3, $_.enc); //#4791
        $put($_.txt, $_.i, $a([$geti($_.barcode, $_.i, 1), ((($_.i - 1) * 7) + 15) + $_.textxoffset, $_.textyoffset, $_.textfont, $_.textsize])); //#4792
    } //#4792
    $puti($_.sbs, ((7 - 1) * 4) + 3, $get($_.encs, 11)); //#4796
    for (var _1Y = 7; _1Y <= 12; _1Y += 1) { //#4809
        $_.i = _1Y; //#4801
        $search($_.barchars, $geti($_.barcode, $_.i, 1)); //#4802
        $j--; //#4803
        $_.indx = $k[--$j].length; //#4804
        $j -= 2; //#4805
        $_.enc = $get($_.encs, $_.indx); //#4806
        $puti($_.sbs, (($_.i - 1) * 4) + 8, $_.enc); //#4807
        $put($_.txt, $_.i, $a([$geti($_.barcode, $_.i, 1), ((($_.i - 1) * 7) + 19) + $_.textxoffset, $_.textyoffset, $_.textfont, $_.textsize])); //#4808
    } //#4808
    $puti($_.sbs, 56, $get($_.encs, 12)); //#4812
    $k[$j++] = Infinity; //#4814
    var _1y = $_.sbs; //#4814
    for (var _1z = 0, _20 = _1y.length; _1z < _20; _1z++) { //#4814
        $k[$j++] = $get(_1y, _1z) - 48; //#4814
    } //#4814
    $_.sbs = $a(); //#4814
    if ($_.includetext) { //#4821
        $k[$j++] = Infinity; //#4816
        $k[$j++] = $_.height; //#4816
        $k[$j++] = $_.height; //#4816
        for (var _26 = 0, _27 = 12; _26 < _27; _26++) { //#4816
            $k[$j++] = $f($_.height - 0.075); //#4816
        } //#4816
        $k[$j++] = $_.height; //#4816
        $k[$j++] = $_.height; //#4816
        for (var _2B = 0, _2C = 12; _2B < _2C; _2B++) { //#4816
            $k[$j++] = $f($_.height - 0.075); //#4816
        } //#4816
        $k[$j++] = $_.height; //#4816
        $k[$j++] = $_.height; //#4816
        $_.bhs = $a(); //#4816
        $k[$j++] = Infinity; //#4817
        $k[$j++] = 0; //#4817
        $k[$j++] = 0; //#4817
        for (var _2H = 0, _2I = 12; _2H < _2I; _2H++) { //#4817
            $k[$j++] = 0.075; //#4817
        } //#4817
        $k[$j++] = 0; //#4817
        $k[$j++] = 0; //#4817
        for (var _2J = 0, _2K = 12; _2J < _2K; _2J++) { //#4817
            $k[$j++] = 0.075; //#4817
        } //#4817
        $k[$j++] = 0; //#4817
        $k[$j++] = 0; //#4817
        $_.bbs = $a(); //#4817
    } else { //#4821
        $k[$j++] = Infinity; //#4819
        for (var _2M = 0, _2N = 30; _2M < _2N; _2M++) { //#4819
            $k[$j++] = $_.height; //#4819
        } //#4819
        $_.bhs = $a(); //#4819
        $k[$j++] = Infinity; //#4820
        for (var _2Q = 0, _2R = 30; _2Q < _2R; _2Q++) { //#4820
            $k[$j++] = 0; //#4820
        } //#4820
        $_.bbs = $a(); //#4820
        $_.txt = $a([]); //#4821
    } //#4821
    $_.guardrightypos = 0; //#4823
    if ($ne($_.addon, "")) { //#4844
        $k[$j++] = Infinity; //#4827
        $k[$j++] = 'dontdraw'; //#4831
        $k[$j++] = true; //#4831
        $k[$j++] = 'includetext'; //#4831
        $k[$j++] = true; //#4831
        $k[$j++] = 'height'; //#4831
        $k[$j++] = $f($_.height - 0.15); //#4831
        $k[$j++] = 'textxoffset'; //#4831
        if ($ne($_.addontextxoffset, null)) { //#4831
            $k[$j++] = $_.addontextxoffset; //#4831
        } else { //#4831
            $k[$j++] = 95 + $_.addongap; //#4831
        } //#4831
        if ($ne($_.addontextyoffset, null)) { //#4832
            $k[$j++] = 'textyoffset'; //#4832
            $k[$j++] = $_.addontextyoffset; //#4832
        } //#4832
        $k[$j++] = 'textsize'; //#4833
        if ($ne($_.addontextsize, null)) { //#4833
            $k[$j++] = $_.addontextsize; //#4833
        } else { //#4833
            $k[$j++] = $_.textsize; //#4833
        } //#4833
        var _2f = $ne($_.addontextfont, "unset") ? $_.addontextfont : $_.textfont; //#4834
        $k[$j++] = 'textfont'; //#4834
        $k[$j++] = _2f; //#4834
        $_.addopts = $d(); //#4835
        if ($_.addon.length == 2) { //#4836
            $k[$j++] = $_.addon; //#4836
            $k[$j++] = $_.addopts; //#4836
            bwipp_ean2(); //#4836
        } //#4836
        if ($_.addon.length == 5) { //#4837
            $k[$j++] = $_.addon; //#4837
            $k[$j++] = $_.addopts; //#4837
            bwipp_ean5(); //#4837
        } //#4837
        $_.addcode = $k[--$j]; //#4838
        $k[$j++] = Infinity; //#4839
        $aload($_.sbs); //#4839
        $k[$j++] = $_.addongap; //#4839
        $aload($get($_.addcode, "sbs")); //#4839
        $_.sbs = $a(); //#4839
        $k[$j++] = Infinity; //#4840
        $aload($_.bhs); //#4840
        $forall($get($_.addcode, "bhs"), function() { //#4840
            var _2w = $k[--$j]; //#4840
            $k[$j++] = $f(_2w - 0.075); //#4840
        }); //#4840
        $_.bhs = $a(); //#4840
        $k[$j++] = Infinity; //#4841
        $aload($_.bbs); //#4841
        $forall($get($_.addcode, "bbs"), function() { //#4841
            var _31 = $k[--$j]; //#4841
            $k[$j++] = $f(_31 + 0.075); //#4841
        }); //#4841
        $_.bbs = $a(); //#4841
        $k[$j++] = Infinity; //#4842
        $aload($_.txt); //#4842
        $aload($get($_.addcode, "txt")); //#4842
        $_.txt = $a(); //#4842
        $_.guardrightypos = ($_.height * 72) - 6; //#4843
    } //#4843
    $k[$j++] = Infinity; //#4847
    $k[$j++] = 'ren'; //#4854
    $k[$j++] = 'renlinear'; //#4854
    $k[$j++] = 'sbs'; //#4854
    $k[$j++] = $_.sbs; //#4854
    $k[$j++] = 'bhs'; //#4854
    $k[$j++] = $_.bhs; //#4854
    $k[$j++] = 'bbs'; //#4854
    $k[$j++] = $_.bbs; //#4854
    $k[$j++] = 'txt'; //#4854
    $k[$j++] = $_.txt; //#4854
    $k[$j++] = 'opt'; //#4854
    $k[$j++] = $_.options; //#4854
    $k[$j++] = 'guardrightpos'; //#4854
    if ($eq($_.addon, "")) { //#4854
        $k[$j++] = 7; //#4854
    } else { //#4854
        $k[$j++] = 5; //#4854
    } //#4854
    $k[$j++] = 'guardrightypos'; //#4857
    $k[$j++] = $_.guardrightypos; //#4857
    $k[$j++] = 'borderleft'; //#4857
    $k[$j++] = 11; //#4857
    $k[$j++] = 'borderright'; //#4857
    if ($eq($_.addon, "")) { //#4857
        $k[$j++] = 7; //#4857
    } else { //#4857
        $k[$j++] = 5; //#4857
    } //#4857
    $k[$j++] = 'bordertop'; //#4859
    $k[$j++] = 0; //#4859
    $k[$j++] = 'borderbottom'; //#4859
    $k[$j++] = 5; //#4859
    var _3G = $d(); //#4859
    $k[$j++] = _3G; //#4862
    if (!$_.dontdraw) { //#4862
        bwipp_renlinear(); //#4862
    } //#4862
    $_ = Object.getPrototypeOf($_); //#4864
    $_ = Object.getPrototypeOf($_); //#4866
} //bwipp_ean13
function bwipp_ean8() {
    $_ = Object.create($_); //#4898
    $_.dontdraw = false; //#4901
    $_.includetext = false; //#4902
    $_.textfont = "OCR-B"; //#4903
    $_.textsize = 12; //#4904
    $_.textxoffset = 4; //#4905
    $_.textyoffset = -4; //#4906
    $_.height = 1; //#4907
    $_.addongap = 12; //#4908
    $_.addontextfont = "unset"; //#4909
    $_.addontextsize = null; //#4910
    $_.addontextxoffset = null; //#4911
    $_.addontextyoffset = null; //#4912
    $k[$j++] = $_; //#4914
    bwipp_processoptions(); //#4914
    $_.options = $k[--$j]; //#4914
    $_.barcode = $k[--$j]; //#4915
    bwipp_loadctx(bwipp_ean8) //#4917
    $search($_.barcode, " "); //#4920
    if ($k[--$j]) { //#4926
        $_.barcode = $k[--$j]; //#4921
        $j--; //#4922
        $_.addon = $k[--$j]; //#4923
    } else { //#4926
        $j--; //#4925
        $_.addon = ""; //#4926
    } //#4926
    if (($_.barcode.length != 7) && ($_.barcode.length != 8)) { //#4932
        $k[$j++] = 'bwipp.ean8badLength#4931'; //#4931
        $k[$j++] = "EAN-8 must be 7 or 8 digits"; //#4931
        bwipp_raiseerror(); //#4931
    } //#4931
    $forall($_.barcode, function() { //#4937
        var _9 = $k[--$j]; //#4934
        if ((_9 < 48) || (_9 > 57)) { //#4936
            $k[$j++] = 'bwipp.ean8badCharacter#4935'; //#4935
            $k[$j++] = "EAN-8 must contain only digits"; //#4935
            bwipp_raiseerror(); //#4935
        } //#4935
    }); //#4935
    if ((($_.addon.length != 0) && ($_.addon.length != 2)) && ($_.addon.length != 5)) { //#4940
        $k[$j++] = 'bwipp.ean8badAddOnLength#4939'; //#4939
        $k[$j++] = "Add-on for EAN-8 must be 2 or 5 digits"; //#4939
        bwipp_raiseerror(); //#4939
    } //#4939
    $_.pad = $s(8); //#4943
    $_.checksum = 0; //#4944
    for (var _E = 0; _E <= 6; _E += 1) { //#4953
        $_.i = _E; //#4946
        $_.barchar = $f($get($_.barcode, $_.i) - 48); //#4947
        if (($_.i % 2) != 0) { //#4951
            $_.checksum = $f($_.barchar + $_.checksum); //#4949
        } else { //#4951
            $_.checksum = $f(($_.barchar * 3) + $_.checksum); //#4951
        } //#4951
    } //#4951
    $_.checksum = ($f(10 - ($_.checksum % 10))) % 10; //#4954
    if ($_.barcode.length == 8) { //#4959
        if ($get($_.barcode, 7) != $f($_.checksum + 48)) { //#4958
            $k[$j++] = 'bwipp.ean8badCheckDigit#4957'; //#4957
            $k[$j++] = "Incorrect EAN-8 check digit provided"; //#4957
            bwipp_raiseerror(); //#4957
        } //#4957
    } //#4957
    $puti($_.pad, 0, $_.barcode); //#4960
    $put($_.pad, 7, $f($_.checksum + 48)); //#4961
    $_.barcode = $_.pad; //#4962
    if (!bwipp_ean8.__4974__) { //#4974
        $_ = Object.create($_); //#4974
        $_.encs = $a(["3211", "2221", "2122", "1411", "1132", "1231", "1114", "1312", "1213", "3112", "111", "11111", "111"]); //#4970
        $_.barchars = "0123456789"; //#4973
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_ean8.$ctx[id] = $_[id]); //#4973
        bwipp_ean8.__4974__ = 1; //#4973
        $_ = Object.getPrototypeOf($_); //#4973
    } //#4973
    $_.sbs = $s(43); //#4976
    $_.txt = $a(8); //#4977
    $puti($_.sbs, 0, $get($_.encs, 10)); //#4980
    for (var _e = 0; _e <= 3; _e += 1) { //#4993
        $_.i = _e; //#4985
        $search($_.barchars, $geti($_.barcode, $_.i, 1)); //#4986
        $j--; //#4987
        $_.indx = $k[--$j].length; //#4988
        $j -= 2; //#4989
        $_.enc = $get($_.encs, $_.indx); //#4990
        $puti($_.sbs, ($_.i * 4) + 3, $_.enc); //#4991
        $put($_.txt, $_.i, $a([$geti($_.barcode, $_.i, 1), ($_.i * 7) + $_.textxoffset, $_.textyoffset, $_.textfont, $_.textsize])); //#4992
    } //#4992
    $puti($_.sbs, (4 * 4) + 3, $get($_.encs, 11)); //#4996
    for (var _14 = 4; _14 <= 7; _14 += 1) { //#5009
        $_.i = _14; //#5001
        $search($_.barchars, $geti($_.barcode, $_.i, 1)); //#5002
        $j--; //#5003
        $_.indx = $k[--$j].length; //#5004
        $j -= 2; //#5005
        $_.enc = $get($_.encs, $_.indx); //#5006
        $puti($_.sbs, ($_.i * 4) + 8, $_.enc); //#5007
        $put($_.txt, $_.i, $a([$geti($_.barcode, $_.i, 1), (($_.i * 7) + $_.textxoffset) + 4, $_.textyoffset, $_.textfont, $_.textsize])); //#5008
    } //#5008
    $puti($_.sbs, 40, $get($_.encs, 12)); //#5012
    $k[$j++] = Infinity; //#5014
    var _1U = $_.sbs; //#5014
    for (var _1V = 0, _1W = _1U.length; _1V < _1W; _1V++) { //#5014
        $k[$j++] = $get(_1U, _1V) - 48; //#5014
    } //#5014
    $_.sbs = $a(); //#5014
    if ($_.includetext) { //#5021
        $k[$j++] = Infinity; //#5016
        $k[$j++] = $_.height; //#5016
        $k[$j++] = $_.height; //#5016
        for (var _1c = 0, _1d = 8; _1c < _1d; _1c++) { //#5016
            $k[$j++] = $f($_.height - 0.075); //#5016
        } //#5016
        $k[$j++] = $_.height; //#5016
        $k[$j++] = $_.height; //#5016
        for (var _1h = 0, _1i = 8; _1h < _1i; _1h++) { //#5016
            $k[$j++] = $f($_.height - 0.075); //#5016
        } //#5016
        $k[$j++] = $_.height; //#5016
        $k[$j++] = $_.height; //#5016
        $_.bhs = $a(); //#5016
        $k[$j++] = Infinity; //#5017
        $k[$j++] = 0; //#5017
        $k[$j++] = 0; //#5017
        for (var _1n = 0, _1o = 8; _1n < _1o; _1n++) { //#5017
            $k[$j++] = 0.075; //#5017
        } //#5017
        $k[$j++] = 0; //#5017
        $k[$j++] = 0; //#5017
        for (var _1p = 0, _1q = 8; _1p < _1q; _1p++) { //#5017
            $k[$j++] = 0.075; //#5017
        } //#5017
        $k[$j++] = 0; //#5017
        $k[$j++] = 0; //#5017
        $_.bbs = $a(); //#5017
    } else { //#5021
        $k[$j++] = Infinity; //#5019
        for (var _1s = 0, _1t = 22; _1s < _1t; _1s++) { //#5019
            $k[$j++] = $_.height; //#5019
        } //#5019
        $_.bhs = $a(); //#5019
        $k[$j++] = Infinity; //#5020
        for (var _1w = 0, _1x = 22; _1w < _1x; _1w++) { //#5020
            $k[$j++] = 0; //#5020
        } //#5020
        $_.bbs = $a(); //#5020
        $_.txt = $a([]); //#5021
    } //#5021
    $_.guardrightypos = 0; //#5023
    if ($ne($_.addon, "")) { //#5044
        $k[$j++] = Infinity; //#5027
        $k[$j++] = 'dontdraw'; //#5031
        $k[$j++] = true; //#5031
        $k[$j++] = 'includetext'; //#5031
        $k[$j++] = true; //#5031
        $k[$j++] = 'height'; //#5031
        $k[$j++] = $f($_.height - 0.15); //#5031
        $k[$j++] = 'textxoffset'; //#5031
        if ($ne($_.addontextxoffset, null)) { //#5031
            $k[$j++] = $_.addontextxoffset; //#5031
        } else { //#5031
            $k[$j++] = 67 + $_.addongap; //#5031
        } //#5031
        if ($ne($_.addontextyoffset, null)) { //#5032
            $k[$j++] = 'textyoffset'; //#5032
            $k[$j++] = $_.addontextyoffset; //#5032
        } //#5032
        $k[$j++] = 'textsize'; //#5033
        if ($ne($_.addontextsize, null)) { //#5033
            $k[$j++] = $_.addontextsize; //#5033
        } else { //#5033
            $k[$j++] = $_.textsize; //#5033
        } //#5033
        var _2B = $ne($_.addontextfont, "unset") ? $_.addontextfont : $_.textfont; //#5034
        $k[$j++] = 'textfont'; //#5034
        $k[$j++] = _2B; //#5034
        $_.addopts = $d(); //#5035
        if ($_.addon.length == 2) { //#5036
            $k[$j++] = $_.addon; //#5036
            $k[$j++] = $_.addopts; //#5036
            bwipp_ean2(); //#5036
        } //#5036
        if ($_.addon.length == 5) { //#5037
            $k[$j++] = $_.addon; //#5037
            $k[$j++] = $_.addopts; //#5037
            bwipp_ean5(); //#5037
        } //#5037
        $_.addcode = $k[--$j]; //#5038
        $k[$j++] = Infinity; //#5039
        $aload($_.sbs); //#5039
        $k[$j++] = $_.addongap; //#5039
        $aload($get($_.addcode, "sbs")); //#5039
        $_.sbs = $a(); //#5039
        $k[$j++] = Infinity; //#5040
        $aload($_.bhs); //#5040
        $forall($get($_.addcode, "bhs"), function() { //#5040
            var _2S = $k[--$j]; //#5040
            $k[$j++] = $f(_2S - 0.075); //#5040
        }); //#5040
        $_.bhs = $a(); //#5040
        $k[$j++] = Infinity; //#5041
        $aload($_.bbs); //#5041
        $forall($get($_.addcode, "bbs"), function() { //#5041
            var _2X = $k[--$j]; //#5041
            $k[$j++] = $f(_2X + 0.075); //#5041
        }); //#5041
        $_.bbs = $a(); //#5041
        $k[$j++] = Infinity; //#5042
        $aload($_.txt); //#5042
        $aload($get($_.addcode, "txt")); //#5042
        $_.txt = $a(); //#5042
        $_.guardrightypos = ($_.height * 72) - 6; //#5043
    } //#5043
    $k[$j++] = Infinity; //#5047
    $k[$j++] = 'ren'; //#5055
    $k[$j++] = 'renlinear'; //#5055
    $k[$j++] = 'sbs'; //#5055
    $k[$j++] = $_.sbs; //#5055
    $k[$j++] = 'bhs'; //#5055
    $k[$j++] = $_.bhs; //#5055
    $k[$j++] = 'bbs'; //#5055
    $k[$j++] = $_.bbs; //#5055
    $k[$j++] = 'txt'; //#5055
    $k[$j++] = $_.txt; //#5055
    $k[$j++] = 'opt'; //#5055
    $k[$j++] = $_.options; //#5055
    $k[$j++] = 'guardleftpos'; //#5055
    $k[$j++] = 7; //#5055
    $k[$j++] = 'guardrightpos'; //#5055
    if ($eq($_.addon, "")) { //#5055
        $k[$j++] = 7; //#5055
    } else { //#5055
        $k[$j++] = 5; //#5055
    } //#5055
    $k[$j++] = 'guardrightypos'; //#5058
    $k[$j++] = $_.guardrightypos; //#5058
    $k[$j++] = 'borderleft'; //#5058
    $k[$j++] = 7; //#5058
    $k[$j++] = 'borderright'; //#5058
    if ($eq($_.addon, "")) { //#5058
        $k[$j++] = 7; //#5058
    } else { //#5058
        $k[$j++] = 5; //#5058
    } //#5058
    $k[$j++] = 'bordertop'; //#5060
    $k[$j++] = 0; //#5060
    $k[$j++] = 'borderbottom'; //#5060
    $k[$j++] = 5; //#5060
    var _2m = $d(); //#5060
    $k[$j++] = _2m; //#5063
    if (!$_.dontdraw) { //#5063
        bwipp_renlinear(); //#5063
    } //#5063
    $_ = Object.getPrototypeOf($_); //#5065
    $_ = Object.getPrototypeOf($_); //#5067
} //bwipp_ean8
function bwipp_upca() {
    $_ = Object.create($_); //#5099
    $_.dontdraw = false; //#5102
    $_.includetext = false; //#5103
    $_.textfont = "OCR-B"; //#5104
    $_.textsize = 12; //#5105
    $_.textxoffset = -9; //#5106
    $_.textyoffset = -4; //#5107
    $_.height = 1; //#5108
    $_.addongap = 12; //#5109
    $_.addontextfont = "unset"; //#5110
    $_.addontextsize = null; //#5111
    $_.addontextxoffset = null; //#5112
    $_.addontextyoffset = null; //#5113
    $k[$j++] = $_; //#5115
    bwipp_processoptions(); //#5115
    $_.options = $k[--$j]; //#5115
    $_.barcode = $k[--$j]; //#5116
    bwipp_loadctx(bwipp_upca) //#5118
    $search($_.barcode, " "); //#5121
    if ($k[--$j]) { //#5127
        $_.barcode = $k[--$j]; //#5122
        $j--; //#5123
        $_.addon = $k[--$j]; //#5124
    } else { //#5127
        $j--; //#5126
        $_.addon = ""; //#5127
    } //#5127
    if (($_.barcode.length == 7) || ($_.barcode.length == 8)) { //#5173
        $forall($_.barcode, function() { //#5137
            var _9 = $k[--$j]; //#5134
            if ((_9 < 48) || (_9 > 57)) { //#5136
                $k[$j++] = 'bwipp.upcAupcEbadCharacter#5135'; //#5135
                $k[$j++] = "UPC-E must contain only digits"; //#5135
                bwipp_raiseerror(); //#5135
            } //#5135
        }); //#5135
        var _B = $get($_.barcode, 0); //#5138
        if ((_B != 48) && (_B != 49)) { //#5140
            $k[$j++] = 'bwipp.upcAupcEbadNumberSystem#5139'; //#5139
            $k[$j++] = "UPC-E must have number system 0 or 1"; //#5139
            bwipp_raiseerror(); //#5139
        } //#5139
        for (var _C = 0, _D = 1; _C < _D; _C++) { //#5168
            var _F = ($_.barcode.length == 8) ? 12 : 11; //#5142
            $_.upcacode = $s(_F); //#5142
            if ($f($get($_.barcode, 6) - 48) <= 2) { //#5149
                $puti($_.upcacode, 0, $geti($_.barcode, 0, 3)); //#5144
                $puti($_.upcacode, 3, $geti($_.barcode, 6, 1)); //#5145
                $puti($_.upcacode, 4, "0000"); //#5146
                $puti($_.upcacode, 8, $geti($_.barcode, 3, 3)); //#5147
                break; //#5148
            } //#5148
            if ($f($get($_.barcode, 6) - 48) == 3) { //#5155
                $puti($_.upcacode, 0, $geti($_.barcode, 0, 4)); //#5151
                $puti($_.upcacode, 4, "00000"); //#5152
                $puti($_.upcacode, 9, $geti($_.barcode, 4, 2)); //#5153
                break; //#5154
            } //#5154
            if ($f($get($_.barcode, 6) - 48) == 4) { //#5161
                $puti($_.upcacode, 0, $geti($_.barcode, 0, 5)); //#5157
                $puti($_.upcacode, 5, "00000"); //#5158
                $puti($_.upcacode, 10, $geti($_.barcode, 5, 1)); //#5159
                break; //#5160
            } //#5160
            if ($f($get($_.barcode, 6) - 48) >= 5) { //#5167
                $puti($_.upcacode, 0, $geti($_.barcode, 0, 6)); //#5163
                $puti($_.upcacode, 6, "0000"); //#5164
                $puti($_.upcacode, 10, $geti($_.barcode, 6, 1)); //#5165
                break; //#5166
            } //#5166
        } //#5166
        if ($_.barcode.length == 8) { //#5171
            $puti($_.upcacode, 11, $geti($_.barcode, 7, 1)); //#5170
        } //#5170
        $_.barcode = $_.upcacode; //#5172
    } //#5172
    if (($_.barcode.length != 11) && ($_.barcode.length != 12)) { //#5178
        $k[$j++] = 'bwipp.upcAbadLength#5177'; //#5177
        $k[$j++] = "UPC-A must be 11 or 12 digits"; //#5177
        bwipp_raiseerror(); //#5177
    } //#5177
    var _11 = $_.barcode; //#5179
    for (var _12 = 0, _13 = _11.length; _12 < _13; _12++) { //#5183
        var _14 = $get(_11, _12); //#5183
        if ((_14 < 48) || (_14 > 57)) { //#5182
            $k[$j++] = 'bwipp.upcAbadCharacter#5181'; //#5181
            $k[$j++] = "UPC-A must contain only digits"; //#5181
            bwipp_raiseerror(); //#5181
        } //#5181
    } //#5181
    if ((($_.addon.length != 0) && ($_.addon.length != 2)) && ($_.addon.length != 5)) { //#5186
        $k[$j++] = 'bwipp.upcAbadAddOnLength#5185'; //#5185
        $k[$j++] = "Add-on for UPC-A must be 2 or 5 digits"; //#5185
        bwipp_raiseerror(); //#5185
    } //#5185
    $_.pad = $s(12); //#5189
    $_.checksum = 0; //#5190
    for (var _19 = 0; _19 <= 10; _19 += 1) { //#5199
        $_.i = _19; //#5192
        $_.barchar = $get($_.barcode, $_.i) - 48; //#5193
        if (($_.i % 2) != 0) { //#5197
            $_.checksum = $_.checksum + $_.barchar; //#5195
        } else { //#5197
            $_.checksum = $_.checksum + ($_.barchar * 3); //#5197
        } //#5197
    } //#5197
    $_.checksum = (10 - ($_.checksum % 10)) % 10; //#5200
    if ($_.barcode.length == 12) { //#5205
        if ($get($_.barcode, 11) != ($_.checksum + 48)) { //#5204
            $k[$j++] = 'bwipp.upcAbadCheckDigit#5203'; //#5203
            $k[$j++] = "Incorrect UPC check digit provided"; //#5203
            bwipp_raiseerror(); //#5203
        } //#5203
    } //#5203
    $puti($_.pad, 0, $_.barcode); //#5206
    $put($_.pad, 11, $_.checksum + 48); //#5207
    $_.barcode = $_.pad; //#5208
    if (!bwipp_upca.__5220__) { //#5220
        $_ = Object.create($_); //#5220
        $_.encs = $a(["3211", "2221", "2122", "1411", "1132", "1231", "1114", "1312", "1213", "3112", "111", "11111", "111"]); //#5216
        $_.barchars = "0123456789"; //#5219
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_upca.$ctx[id] = $_[id]); //#5219
        bwipp_upca.__5220__ = 1; //#5219
        $_ = Object.getPrototypeOf($_); //#5219
    } //#5219
    $_.sbs = $s(59); //#5222
    $_.txt = $a(12); //#5223
    $puti($_.sbs, 0, $get($_.encs, 10)); //#5226
    for (var _1Z = 0; _1Z <= 5; _1Z += 1) { //#5243
        $_.i = _1Z; //#5231
        $search($_.barchars, $geti($_.barcode, $_.i, 1)); //#5232
        $j--; //#5233
        $_.indx = $k[--$j].length; //#5234
        $j -= 2; //#5235
        $_.enc = $get($_.encs, $_.indx); //#5236
        $puti($_.sbs, ($_.i * 4) + 3, $_.enc); //#5237
        if ($_.i == 0) { //#5241
            $put($_.txt, 0, $a([$geti($_.barcode, 0, 1), $_.textxoffset, $_.textyoffset, $_.textfont, $_.textsize - 2])); //#5239
        } else { //#5241
            $put($_.txt, $_.i, $a([$geti($_.barcode, $_.i, 1), (($_.i * 7) + 13) + $_.textxoffset, $_.textyoffset, $_.textfont, $_.textsize])); //#5241
        } //#5241
    } //#5241
    $puti($_.sbs, (6 * 4) + 3, $get($_.encs, 11)); //#5246
    for (var _28 = 6; _28 <= 11; _28 += 1) { //#5263
        $_.i = _28; //#5251
        $search($_.barchars, $geti($_.barcode, $_.i, 1)); //#5252
        $j--; //#5253
        $_.indx = $k[--$j].length; //#5254
        $j -= 2; //#5255
        $_.enc = $get($_.encs, $_.indx); //#5256
        $puti($_.sbs, ($_.i * 4) + 8, $_.enc); //#5257
        if ($_.i == 11) { //#5261
            $put($_.txt, 11, $a([$geti($_.barcode, 11, 1), $_.textxoffset + 107, $_.textyoffset, $_.textfont, $_.textsize - 2])); //#5259
        } else { //#5261
            $put($_.txt, $_.i, $a([$geti($_.barcode, $_.i, 1), (($_.i * 7) + $_.textxoffset) + 17, $_.textyoffset, $_.textfont, $_.textsize])); //#5261
        } //#5261
    } //#5261
    $puti($_.sbs, 56, $get($_.encs, 12)); //#5266
    $k[$j++] = Infinity; //#5268
    var _2h = $_.sbs; //#5268
    for (var _2i = 0, _2j = _2h.length; _2i < _2j; _2i++) { //#5268
        $k[$j++] = $get(_2h, _2i) - 48; //#5268
    } //#5268
    $_.sbs = $a(); //#5268
    if ($_.includetext) { //#5275
        $k[$j++] = Infinity; //#5270
        for (var _2n = 0, _2o = 4; _2n < _2o; _2n++) { //#5270
            $k[$j++] = $_.height; //#5270
        } //#5270
        for (var _2q = 0, _2r = 10; _2q < _2r; _2q++) { //#5270
            $k[$j++] = $f($_.height - 0.075); //#5270
        } //#5270
        $k[$j++] = $_.height; //#5270
        $k[$j++] = $_.height; //#5270
        for (var _2v = 0, _2w = 10; _2v < _2w; _2v++) { //#5270
            $k[$j++] = $f($_.height - 0.075); //#5270
        } //#5270
        for (var _2y = 0, _2z = 4; _2y < _2z; _2y++) { //#5270
            $k[$j++] = $_.height; //#5270
        } //#5270
        $_.bhs = $a(); //#5270
        $k[$j++] = Infinity; //#5271
        $k[$j++] = 0; //#5271
        $k[$j++] = 0; //#5271
        $k[$j++] = 0; //#5271
        $k[$j++] = 0; //#5271
        for (var _32 = 0, _33 = 10; _32 < _33; _32++) { //#5271
            $k[$j++] = 0.075; //#5271
        } //#5271
        $k[$j++] = 0; //#5271
        $k[$j++] = 0; //#5271
        for (var _34 = 0, _35 = 10; _34 < _35; _34++) { //#5271
            $k[$j++] = 0.075; //#5271
        } //#5271
        $k[$j++] = 0; //#5271
        $k[$j++] = 0; //#5271
        $k[$j++] = 0; //#5271
        $k[$j++] = 0; //#5271
        $_.bbs = $a(); //#5271
    } else { //#5275
        $k[$j++] = Infinity; //#5273
        for (var _37 = 0, _38 = 30; _37 < _38; _37++) { //#5273
            $k[$j++] = $_.height; //#5273
        } //#5273
        $_.bhs = $a(); //#5273
        $k[$j++] = Infinity; //#5274
        for (var _3B = 0, _3C = 30; _3B < _3C; _3B++) { //#5274
            $k[$j++] = 0; //#5274
        } //#5274
        $_.bbs = $a(); //#5274
        $_.txt = $a([]); //#5275
    } //#5275
    $_.guardrightypos = 0; //#5277
    if ($ne($_.addon, "")) { //#5298
        $k[$j++] = Infinity; //#5281
        $k[$j++] = 'dontdraw'; //#5285
        $k[$j++] = true; //#5285
        $k[$j++] = 'includetext'; //#5285
        $k[$j++] = true; //#5285
        $k[$j++] = 'height'; //#5285
        $k[$j++] = $f($_.height - 0.15); //#5285
        $k[$j++] = 'textxoffset'; //#5285
        if ($ne($_.addontextxoffset, null)) { //#5285
            $k[$j++] = $_.addontextxoffset; //#5285
        } else { //#5285
            $k[$j++] = 95 + $_.addongap; //#5285
        } //#5285
        if ($ne($_.addontextyoffset, null)) { //#5286
            $k[$j++] = 'textyoffset'; //#5286
            $k[$j++] = $_.addontextyoffset; //#5286
        } //#5286
        $k[$j++] = 'textsize'; //#5287
        if ($ne($_.addontextsize, null)) { //#5287
            $k[$j++] = $_.addontextsize; //#5287
        } else { //#5287
            $k[$j++] = $_.textsize; //#5287
        } //#5287
        var _3Q = $ne($_.addontextfont, "unset") ? $_.addontextfont : $_.textfont; //#5288
        $k[$j++] = 'textfont'; //#5288
        $k[$j++] = _3Q; //#5288
        $_.addopts = $d(); //#5289
        if ($_.addon.length == 2) { //#5290
            $k[$j++] = $_.addon; //#5290
            $k[$j++] = $_.addopts; //#5290
            bwipp_ean2(); //#5290
        } //#5290
        if ($_.addon.length == 5) { //#5291
            $k[$j++] = $_.addon; //#5291
            $k[$j++] = $_.addopts; //#5291
            bwipp_ean5(); //#5291
        } //#5291
        $_.addcode = $k[--$j]; //#5292
        $k[$j++] = Infinity; //#5293
        $aload($_.sbs); //#5293
        $k[$j++] = $_.addongap; //#5293
        $aload($get($_.addcode, "sbs")); //#5293
        $_.sbs = $a(); //#5293
        $k[$j++] = Infinity; //#5294
        $aload($_.bhs); //#5294
        $forall($get($_.addcode, "bhs"), function() { //#5294
            var _3h = $k[--$j]; //#5294
            $k[$j++] = $f(_3h - 0.075); //#5294
        }); //#5294
        $_.bhs = $a(); //#5294
        $k[$j++] = Infinity; //#5295
        $aload($_.bbs); //#5295
        $forall($get($_.addcode, "bbs"), function() { //#5295
            var _3m = $k[--$j]; //#5295
            $k[$j++] = $f(_3m + 0.075); //#5295
        }); //#5295
        $_.bbs = $a(); //#5295
        $k[$j++] = Infinity; //#5296
        $aload($_.txt); //#5296
        $aload($get($_.addcode, "txt")); //#5296
        $_.txt = $a(); //#5296
        $_.guardrightypos = ($_.height * 72) - 6; //#5297
    } //#5297
    $k[$j++] = Infinity; //#5301
    $k[$j++] = 'ren'; //#5308
    $k[$j++] = 'renlinear'; //#5308
    $k[$j++] = 'sbs'; //#5308
    $k[$j++] = $_.sbs; //#5308
    $k[$j++] = 'bhs'; //#5308
    $k[$j++] = $_.bhs; //#5308
    $k[$j++] = 'bbs'; //#5308
    $k[$j++] = $_.bbs; //#5308
    $k[$j++] = 'txt'; //#5308
    $k[$j++] = $_.txt; //#5308
    $k[$j++] = 'opt'; //#5308
    $k[$j++] = $_.options; //#5308
    $k[$j++] = 'guardrightpos'; //#5308
    if ($eq($_.addon, "")) { //#5308
        $k[$j++] = 9; //#5308
    } else { //#5308
        $k[$j++] = 5; //#5308
    } //#5308
    $k[$j++] = 'guardrightypos'; //#5311
    $k[$j++] = $_.guardrightypos; //#5311
    $k[$j++] = 'borderleft'; //#5311
    $k[$j++] = 9; //#5311
    $k[$j++] = 'borderright'; //#5311
    if ($eq($_.addon, "")) { //#5311
        $k[$j++] = 9; //#5311
    } else { //#5311
        $k[$j++] = 5; //#5311
    } //#5311
    $k[$j++] = 'bordertop'; //#5313
    $k[$j++] = 0; //#5313
    $k[$j++] = 'borderbottom'; //#5313
    $k[$j++] = 5; //#5313
    var _41 = $d(); //#5313
    $k[$j++] = _41; //#5316
    if (!$_.dontdraw) { //#5316
        bwipp_renlinear(); //#5316
    } //#5316
    $_ = Object.getPrototypeOf($_); //#5318
    $_ = Object.getPrototypeOf($_); //#5320
} //bwipp_upca
function bwipp_upce() {
    $_ = Object.create($_); //#5352
    $_.dontdraw = false; //#5355
    $_.includetext = false; //#5356
    $_.textfont = "OCR-B"; //#5357
    $_.textsize = 12; //#5358
    $_.textxoffset = -9; //#5359
    $_.textyoffset = -4; //#5360
    $_.height = 1; //#5361
    $_.addongap = 12; //#5362
    $_.addontextfont = "unset"; //#5363
    $_.addontextsize = null; //#5364
    $_.addontextxoffset = null; //#5365
    $_.addontextyoffset = null; //#5366
    $k[$j++] = $_; //#5368
    bwipp_processoptions(); //#5368
    $_.options = $k[--$j]; //#5368
    $_.barcode = $k[--$j]; //#5369
    bwipp_loadctx(bwipp_upce) //#5371
    $search($_.barcode, " "); //#5374
    if ($k[--$j]) { //#5380
        $_.barcode = $k[--$j]; //#5375
        $j--; //#5376
        $_.addon = $k[--$j]; //#5377
    } else { //#5380
        $j--; //#5379
        $_.addon = ""; //#5380
    } //#5380
    if (($_.barcode.length == 11) || ($_.barcode.length == 12)) { //#5422
        $forall($_.barcode, function() { //#5390
            var _9 = $k[--$j]; //#5387
            if ((_9 < 48) || (_9 > 57)) { //#5389
                $k[$j++] = 'bwipp.upcEupcAbadCharacter#5388'; //#5388
                $k[$j++] = "UPC-A must contain only digits"; //#5388
                bwipp_raiseerror(); //#5388
            } //#5388
        }); //#5388
        for (var _A = 0, _B = 1; _A < _B; _A++) { //#5417
            var _D = ($_.barcode.length == 12) ? 8 : 7; //#5392
            $_.upcecode = $s(_D); //#5392
            if (($f($get($_.barcode, 3) - 48) <= 2) && $eq($geti($_.barcode, 4, 4), "0000")) { //#5398
                $puti($_.upcecode, 0, $geti($_.barcode, 0, 3)); //#5394
                $puti($_.upcecode, 3, $geti($_.barcode, 8, 3)); //#5395
                $puti($_.upcecode, 6, $geti($_.barcode, 3, 1)); //#5396
                break; //#5397
            } //#5397
            if ($eq($geti($_.barcode, 4, 5), "00000")) { //#5404
                $puti($_.upcecode, 0, $geti($_.barcode, 0, 4)); //#5400
                $puti($_.upcecode, 4, $geti($_.barcode, 9, 2)); //#5401
                $puti($_.upcecode, 6, "3"); //#5402
                break; //#5403
            } //#5403
            if ($eq($geti($_.barcode, 5, 5), "00000")) { //#5410
                $puti($_.upcecode, 0, $geti($_.barcode, 0, 5)); //#5406
                $puti($_.upcecode, 5, $geti($_.barcode, 10, 1)); //#5407
                $puti($_.upcecode, 6, "4"); //#5408
                break; //#5409
            } //#5409
            if (($f($get($_.barcode, 10) - 48) >= 5) && $eq($geti($_.barcode, 6, 4), "0000")) { //#5415
                $puti($_.upcecode, 0, $geti($_.barcode, 0, 6)); //#5412
                $puti($_.upcecode, 6, $geti($_.barcode, 10, 1)); //#5413
                break; //#5414
            } //#5414
            $k[$j++] = 'bwipp.upcEupcAnotCompressible#5416'; //#5416
            $k[$j++] = "UPC-A cannot be converted to a UPC-E"; //#5416
            bwipp_raiseerror(); //#5416
        } //#5416
        if ($_.barcode.length == 12) { //#5420
            $puti($_.upcecode, 7, $geti($_.barcode, 11, 1)); //#5419
        } //#5419
        $_.barcode = $_.upcecode; //#5421
    } //#5421
    if (($_.barcode.length != 7) && ($_.barcode.length != 8)) { //#5427
        $k[$j++] = 'bwipp.upcEbadLength#5426'; //#5426
        $k[$j++] = "UPC-E must be 7 or 8 digits"; //#5426
        bwipp_raiseerror(); //#5426
    } //#5426
    var _11 = $_.barcode; //#5428
    for (var _12 = 0, _13 = _11.length; _12 < _13; _12++) { //#5432
        var _14 = $get(_11, _12); //#5432
        if ((_14 < 48) || (_14 > 57)) { //#5431
            $k[$j++] = 'bwipp.upcEbadCharacter#5430'; //#5430
            $k[$j++] = "UPC-E must contain only digits"; //#5430
            bwipp_raiseerror(); //#5430
        } //#5430
    } //#5430
    if ((($_.addon.length != 0) && ($_.addon.length != 2)) && ($_.addon.length != 5)) { //#5435
        $k[$j++] = 'bwipp.upcEbadAddOnLength#5434'; //#5434
        $k[$j++] = "Add-on for UPC-E must be 2 or 5 digits"; //#5434
        bwipp_raiseerror(); //#5434
    } //#5434
    var _19 = $get($_.barcode, 0); //#5438
    if ((_19 != 48) && (_19 != 49)) { //#5440
        $k[$j++] = 'bwipp.upcEbadNumberSystem#5439'; //#5439
        $k[$j++] = "UPC-E must have number system 0 or 1"; //#5439
        bwipp_raiseerror(); //#5439
    } //#5439
    if (!bwipp_upce.__5457__) { //#5457
        $_ = Object.create($_); //#5457
        $_.encs = $a(["3211", "2221", "2122", "1411", "1132", "1231", "1114", "1312", "1213", "3112", "111", "111111"]); //#5448
        $_.barchars = "0123456789"; //#5451
        $_.mirrormaps = $a(["000111", "001011", "001101", "001110", "010011", "011001", "011100", "010101", "010110", "011010"]); //#5456
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_upce.$ctx[id] = $_[id]); //#5456
        bwipp_upce.__5457__ = 1; //#5456
        $_ = Object.getPrototypeOf($_); //#5456
    } //#5456
    for (var _1D = 0, _1E = 1; _1D < _1E; _1D++) { //#5487
        $_.upcacode = $s(11); //#5461
        if (($get($_.barcode, 6) - 48) <= 2) { //#5468
            $puti($_.upcacode, 0, $geti($_.barcode, 0, 3)); //#5463
            $puti($_.upcacode, 3, $geti($_.barcode, 6, 1)); //#5464
            $puti($_.upcacode, 4, "0000"); //#5465
            $puti($_.upcacode, 8, $geti($_.barcode, 3, 3)); //#5466
            break; //#5467
        } //#5467
        if (($get($_.barcode, 6) - 48) == 3) { //#5474
            $puti($_.upcacode, 0, $geti($_.barcode, 0, 4)); //#5470
            $puti($_.upcacode, 4, "00000"); //#5471
            $puti($_.upcacode, 9, $geti($_.barcode, 4, 2)); //#5472
            break; //#5473
        } //#5473
        if (($get($_.barcode, 6) - 48) == 4) { //#5480
            $puti($_.upcacode, 0, $geti($_.barcode, 0, 5)); //#5476
            $puti($_.upcacode, 5, "00000"); //#5477
            $puti($_.upcacode, 10, $geti($_.barcode, 5, 1)); //#5478
            break; //#5479
        } //#5479
        if (($get($_.barcode, 6) - 48) >= 5) { //#5486
            $puti($_.upcacode, 0, $geti($_.barcode, 0, 6)); //#5482
            $puti($_.upcacode, 6, "0000"); //#5483
            $puti($_.upcacode, 10, $geti($_.barcode, 6, 1)); //#5484
            break; //#5485
        } //#5485
    } //#5485
    $_.checksum = 0; //#5488
    for (var _1t = 0; _1t <= 10; _1t += 1) { //#5497
        $_.i = _1t; //#5490
        $_.barchar = $get($_.upcacode, $_.i) - 48; //#5491
        if (($_.i % 2) != 0) { //#5495
            $_.checksum = $_.checksum + $_.barchar; //#5493
        } else { //#5495
            $_.checksum = $_.checksum + ($_.barchar * 3); //#5495
        } //#5495
    } //#5495
    $_.checksum = (10 - ($_.checksum % 10)) % 10; //#5498
    if ($_.barcode.length == 8) { //#5503
        if ($get($_.barcode, 7) != ($_.checksum + 48)) { //#5502
            $k[$j++] = 'bwipp.upcEbadCheckDigit#5501'; //#5501
            $k[$j++] = "Incorrect UPC check digit provided"; //#5501
            bwipp_raiseerror(); //#5501
        } //#5501
    } //#5501
    $_.pad = $s(8); //#5504
    $puti($_.pad, 0, $_.barcode); //#5505
    $put($_.pad, 7, $_.checksum + 48); //#5506
    $_.barcode = $_.pad; //#5507
    $_.txt = $a(8); //#5508
    $put($_.txt, 0, $a([$geti($_.barcode, 0, 1), $_.textxoffset, $_.textyoffset, $_.textfont, $_.textsize - 2])); //#5509
    $_.mirrormap = $get($_.mirrormaps, $_.checksum); //#5512
    if ($get($_.barcode, 0) == 48) { //#5526
        $_.invt = $s($_.mirrormap.length); //#5516
        for (var _2V = 0, _2U = $_.mirrormap.length - 1; _2V <= _2U; _2V += 1) { //#5524
            $_.i = _2V; //#5518
            if ($get($_.mirrormap, $_.i) == 48) { //#5522
                $put($_.invt, $_.i, 49); //#5520
            } else { //#5522
                $put($_.invt, $_.i, 48); //#5522
            } //#5522
        } //#5522
        $_.mirrormap = $_.invt; //#5525
    } //#5525
    $_.sbs = $s(33); //#5528
    $puti($_.sbs, 0, $get($_.encs, 10)); //#5531
    for (var _2i = 1; _2i <= 6; _2i += 1) { //#5553
        $_.i = _2i; //#5534
        $search($_.barchars, $geti($_.barcode, $_.i, 1)); //#5536
        $j--; //#5537
        $_.indx = $k[--$j].length; //#5538
        $j -= 2; //#5539
        $_.enc = $get($_.encs, $_.indx); //#5540
        if ($get($_.mirrormap, $_.i - 1) == 49) { //#5550
            $_.enclen = $_.enc.length; //#5542
            $_.revenc = $s($_.enclen); //#5543
            for (var _2z = 0, _2y = $_.enclen - 1; _2z <= _2y; _2z += 1) { //#5548
                $_.j = _2z; //#5545
                $_.char = $get($_.enc, $_.j); //#5546
                $put($_.revenc, ($_.enclen - $_.j) - 1, $_.char); //#5547
            } //#5547
            $_.enc = $_.revenc; //#5549
        } //#5549
        $puti($_.sbs, (($_.i - 1) * 4) + 3, $_.enc); //#5551
        $put($_.txt, $_.i, $a([$geti($_.barcode, $_.i, 1), ((($_.i - 1) * 7) + 13) + $_.textxoffset, $_.textyoffset, $_.textfont, $_.textsize])); //#5552
    } //#5552
    $put($_.txt, 7, $a([$geti($_.barcode, 7, 1), ((6 * 7) + 21) + $_.textxoffset, $_.textyoffset, $_.textfont, $_.textsize - 2])); //#5555
    $puti($_.sbs, 27, $get($_.encs, 11)); //#5558
    $k[$j++] = Infinity; //#5560
    var _3X = $_.sbs; //#5560
    for (var _3Y = 0, _3Z = _3X.length; _3Y < _3Z; _3Y++) { //#5560
        $k[$j++] = $get(_3X, _3Y) - 48; //#5560
    } //#5560
    $_.sbs = $a(); //#5560
    if ($_.includetext) { //#5567
        $k[$j++] = Infinity; //#5562
        $k[$j++] = $_.height; //#5562
        $k[$j++] = $_.height; //#5562
        for (var _3f = 0, _3g = 12; _3f < _3g; _3f++) { //#5562
            $k[$j++] = $f($_.height - 0.075); //#5562
        } //#5562
        $k[$j++] = $_.height; //#5562
        $k[$j++] = $_.height; //#5562
        $k[$j++] = $_.height; //#5562
        $_.bhs = $a(); //#5562
        $k[$j++] = Infinity; //#5563
        $k[$j++] = 0; //#5563
        $k[$j++] = 0; //#5563
        for (var _3m = 0, _3n = 12; _3m < _3n; _3m++) { //#5563
            $k[$j++] = 0.075; //#5563
        } //#5563
        $k[$j++] = 0; //#5563
        $k[$j++] = 0; //#5563
        $k[$j++] = 0; //#5563
        $_.bbs = $a(); //#5563
    } else { //#5567
        $k[$j++] = Infinity; //#5565
        for (var _3p = 0, _3q = 17; _3p < _3q; _3p++) { //#5565
            $k[$j++] = $_.height; //#5565
        } //#5565
        $_.bhs = $a(); //#5565
        $k[$j++] = Infinity; //#5566
        for (var _3t = 0, _3u = 17; _3t < _3u; _3t++) { //#5566
            $k[$j++] = 0; //#5566
        } //#5566
        $_.bbs = $a(); //#5566
        $_.txt = $a([]); //#5567
    } //#5567
    $_.guardrightypos = 0; //#5569
    if ($ne($_.addon, "")) { //#5590
        $k[$j++] = Infinity; //#5573
        $k[$j++] = 'dontdraw'; //#5577
        $k[$j++] = true; //#5577
        $k[$j++] = 'includetext'; //#5577
        $k[$j++] = true; //#5577
        $k[$j++] = 'height'; //#5577
        $k[$j++] = $f($_.height - 0.15); //#5577
        $k[$j++] = 'textxoffset'; //#5577
        if ($ne($_.addontextxoffset, null)) { //#5577
            $k[$j++] = $_.addontextxoffset; //#5577
        } else { //#5577
            $k[$j++] = 51 + $_.addongap; //#5577
        } //#5577
        if ($ne($_.addontextyoffset, null)) { //#5578
            $k[$j++] = 'textyoffset'; //#5578
            $k[$j++] = $_.addontextyoffset; //#5578
        } //#5578
        $k[$j++] = 'textsize'; //#5579
        if ($ne($_.addontextsize, null)) { //#5579
            $k[$j++] = $_.addontextsize; //#5579
        } else { //#5579
            $k[$j++] = $_.textsize; //#5579
        } //#5579
        var _48 = $ne($_.addontextfont, "unset") ? $_.addontextfont : $_.textfont; //#5580
        $k[$j++] = 'textfont'; //#5580
        $k[$j++] = _48; //#5580
        $_.addopts = $d(); //#5581
        if ($_.addon.length == 2) { //#5582
            $k[$j++] = $_.addon; //#5582
            $k[$j++] = $_.addopts; //#5582
            bwipp_ean2(); //#5582
        } //#5582
        if ($_.addon.length == 5) { //#5583
            $k[$j++] = $_.addon; //#5583
            $k[$j++] = $_.addopts; //#5583
            bwipp_ean5(); //#5583
        } //#5583
        $_.addcode = $k[--$j]; //#5584
        $k[$j++] = Infinity; //#5585
        $aload($_.sbs); //#5585
        $k[$j++] = $_.addongap; //#5585
        $aload($get($_.addcode, "sbs")); //#5585
        $_.sbs = $a(); //#5585
        $k[$j++] = Infinity; //#5586
        $aload($_.bhs); //#5586
        $forall($get($_.addcode, "bhs"), function() { //#5586
            var _4P = $k[--$j]; //#5586
            $k[$j++] = $f(_4P - 0.075); //#5586
        }); //#5586
        $_.bhs = $a(); //#5586
        $k[$j++] = Infinity; //#5587
        $aload($_.bbs); //#5587
        $forall($get($_.addcode, "bbs"), function() { //#5587
            var _4U = $k[--$j]; //#5587
            $k[$j++] = $f(_4U + 0.075); //#5587
        }); //#5587
        $_.bbs = $a(); //#5587
        $k[$j++] = Infinity; //#5588
        $aload($_.txt); //#5588
        $aload($get($_.addcode, "txt")); //#5588
        $_.txt = $a(); //#5588
        $_.guardrightypos = ($_.height * 72) - 6; //#5589
    } //#5589
    $k[$j++] = Infinity; //#5593
    $k[$j++] = 'ren'; //#5600
    $k[$j++] = 'renlinear'; //#5600
    $k[$j++] = 'sbs'; //#5600
    $k[$j++] = $_.sbs; //#5600
    $k[$j++] = 'bhs'; //#5600
    $k[$j++] = $_.bhs; //#5600
    $k[$j++] = 'bbs'; //#5600
    $k[$j++] = $_.bbs; //#5600
    $k[$j++] = 'txt'; //#5600
    $k[$j++] = $_.txt; //#5600
    $k[$j++] = 'opt'; //#5600
    $k[$j++] = $_.options; //#5600
    $k[$j++] = 'guardrightpos'; //#5600
    if ($eq($_.addon, "")) { //#5600
        $k[$j++] = 9; //#5600
    } else { //#5600
        $k[$j++] = 5; //#5600
    } //#5600
    $k[$j++] = 'guardrightypos'; //#5603
    $k[$j++] = $_.guardrightypos; //#5603
    $k[$j++] = 'borderleft'; //#5603
    $k[$j++] = 9; //#5603
    $k[$j++] = 'borderright'; //#5603
    if ($eq($_.addon, "")) { //#5603
        $k[$j++] = 9; //#5603
    } else { //#5603
        $k[$j++] = 5; //#5603
    } //#5603
    $k[$j++] = 'bordertop'; //#5605
    $k[$j++] = 0; //#5605
    $k[$j++] = 'borderbottom'; //#5605
    $k[$j++] = 5; //#5605
    var _4j = $d(); //#5605
    $k[$j++] = _4j; //#5608
    if (!$_.dontdraw) { //#5608
        bwipp_renlinear(); //#5608
    } //#5608
    $_ = Object.getPrototypeOf($_); //#5610
    $_ = Object.getPrototypeOf($_); //#5612
} //bwipp_upce
function bwipp_isbn() {
    $_ = Object.create($_); //#5641
    $_.dontdraw = false; //#5644
    $_.includetext = false; //#5645
    $_.isbntextfont = 'OCR-A'; //#5646
    $_.isbntextsize = 8; //#5647
    $_.isbntextxoffset = null; //#5648
    $_.isbntextyoffset = null; //#5649
    $_.height = 1; //#5650
    $_.addongap = 12; //#5651
    $_.legacy = false; //#5652
    $k[$j++] = $_; //#5654
    bwipp_processoptions(); //#5654
    $_.options = $k[--$j]; //#5654
    $_.barcode = $k[--$j]; //#5655
    $search($_.barcode, " "); //#5658
    if ($k[--$j]) { //#5664
        $_.barcode = $k[--$j]; //#5659
        $j--; //#5660
        $_.addon = $k[--$j]; //#5661
    } else { //#5664
        $j--; //#5663
        $_.addon = ""; //#5664
    } //#5664
    if ((($_.barcode.length != 15) && ($_.barcode.length != 17)) && (($_.barcode.length != 11) && ($_.barcode.length != 13))) { //#5671
        $k[$j++] = 'bwipp.isbnBadLength#5670'; //#5670
        $k[$j++] = "ISBN-13 must be 15 or 17 characters including dashes. ISBN-10 must be 11 or 13 characters including dashes"; //#5670
        bwipp_raiseerror(); //#5670
    } //#5670
    if ((($_.addon.length != 0) && ($_.addon.length != 2)) && ($_.addon.length != 5)) { //#5674
        $k[$j++] = 'bwipp.isbnBadAddOnLength#5673'; //#5673
        $k[$j++] = "Add-on for ISBN must be 2 or 5 digits"; //#5673
        bwipp_raiseerror(); //#5673
    } //#5673
    if ($_.barcode.length >= 15) { //#5738
        var _F = $geti($_.barcode, 0, 4); //#5676
        if ($ne(_F, "978-") && $ne(_F, "979-")) { //#5678
            $k[$j++] = 'bwipp.isbn13badPrefix#5677'; //#5677
            $k[$j++] = "ISBN-13 prefix must be 978- or 979-"; //#5677
            bwipp_raiseerror(); //#5677
        } //#5677
        $_.wasdash = false; //#5679
        $_.numdash = 0; //#5679
        $_.numdigit = 0; //#5679
        var _H = $geti($_.barcode, 5, 9); //#5680
        for (var _I = 0, _J = _H.length; _I < _J; _I++) { //#5693
            var _K = $get(_H, _I); //#5693
            $k[$j++] = _K; //#5688
            if (_K == 45) { //#5688
                if ($_.wasdash) { //#5685
                    $k[$j++] = 'bwipp.isbn13adjacentDashes#5684'; //#5684
                    $k[$j++] = "ISBN-13 does not permit adjacent dashes"; //#5684
                    bwipp_raiseerror(); //#5684
                } //#5684
                $_.wasdash = true; //#5686
                $_.numdash = $_.numdash + 1; //#5687
            } //#5687
            var _N = $k[--$j]; //#5689
            if ((_N >= 48) && (_N <= 57)) { //#5692
                $_.wasdash = false; //#5690
                $_.numdigit = $_.numdigit + 1; //#5691
            } //#5691
        } //#5691
        if (($_.numdash != 2) || ($_.numdigit != 7)) { //#5696
            $k[$j++] = 'bwipp.isbn13numDashesDigits#5695'; //#5695
            $k[$j++] = "Incorrect number of dashes and digits for ISBN-13"; //#5695
            bwipp_raiseerror(); //#5695
        } //#5695
        var _S = $get($_.barcode, 14); //#5697
        if ((_S < 48) || (_S > 57)) { //#5699
            $k[$j++] = 'bwipp.isbn13character15#5698'; //#5698
            $k[$j++] = "ISBN-13 character 15 must be a digit"; //#5698
            bwipp_raiseerror(); //#5698
        } //#5698
        if ($_.barcode.length == 17) { //#5707
            if ($ne($geti($_.barcode, 15, 1), "-")) { //#5703
                $k[$j++] = 'bwipp.isbn13character16#5702'; //#5702
                $k[$j++] = "ISBN-13 penultimate character must be a dash"; //#5702
                bwipp_raiseerror(); //#5702
            } //#5702
            var _X = $get($_.barcode, 16); //#5704
            if ((_X < 48) || (_X > 57)) { //#5706
                $k[$j++] = 'bwipp.isbn13character17#5705'; //#5705
                $k[$j++] = "ISBN-13 final character must be a digit"; //#5705
                bwipp_raiseerror(); //#5705
            } //#5705
        } //#5705
    } else { //#5738
        var _Z = $get($_.barcode, 0); //#5709
        if ((_Z < 48) || (_Z > 57)) { //#5711
            $k[$j++] = 'bwipp.isbn10FirstDigit#5710'; //#5710
            $k[$j++] = "ISBN-10 first character must be a digit"; //#5710
            bwipp_raiseerror(); //#5710
        } //#5710
        $_.wasdash = false; //#5712
        $_.numdash = 0; //#5712
        $_.numdigit = 0; //#5712
        var _b = $geti($_.barcode, 1, 9); //#5713
        for (var _c = 0, _d = _b.length; _c < _d; _c++) { //#5726
            var _e = $get(_b, _c); //#5726
            $k[$j++] = _e; //#5721
            if (_e == 45) { //#5721
                if ($_.wasdash) { //#5718
                    $k[$j++] = 'bwipp.isbn10adjacentDashes#5717'; //#5717
                    $k[$j++] = "ISBN-10 does not permit adjacent dashes"; //#5717
                    bwipp_raiseerror(); //#5717
                } //#5717
                $_.wasdash = true; //#5719
                $_.numdash = $_.numdash + 1; //#5720
            } //#5720
            var _h = $k[--$j]; //#5722
            if ((_h >= 48) && (_h <= 57)) { //#5725
                $_.wasdash = false; //#5723
                $_.numdigit = $_.numdigit + 1; //#5724
            } //#5724
        } //#5724
        if (($_.numdash != 2) || ($_.numdigit != 7)) { //#5729
            $k[$j++] = 'bwipp.isbn10numDashesDigits#5728'; //#5728
            $k[$j++] = "Incorrect number of dashes and digits for ISBN-10"; //#5728
            bwipp_raiseerror(); //#5728
        } //#5728
        var _m = $get($_.barcode, 10); //#5730
        if ((_m < 48) || (_m > 57)) { //#5732
            $k[$j++] = 'bwipp.isbn10character11#5731'; //#5731
            $k[$j++] = "ISBN-10 character 11 must be a digit"; //#5731
            bwipp_raiseerror(); //#5731
        } //#5731
        if ($_.barcode.length == 13) { //#5740
            if ($ne($geti($_.barcode, 11, 1), "-")) { //#5736
                $k[$j++] = 'bwipp.isbn10character12#5735'; //#5735
                $k[$j++] = "ISBN-10 penultimate character must be a dash"; //#5735
                bwipp_raiseerror(); //#5735
            } //#5735
            var _r = $get($_.barcode, 12); //#5737
            if (((_r < 48) || (_r > 57)) && (_r != 88)) { //#5739
                $k[$j++] = 'bwipp.isbn10character13#5738'; //#5738
                $k[$j++] = "ISBN-10 final character must be a digit or X"; //#5738
                bwipp_raiseerror(); //#5738
            } //#5738
        } //#5738
    } //#5738
    $_.isbntxt = $_.barcode; //#5743
    if ($_.isbntxt.length <= 13) { //#5769
        $_.isbn = $s(10); //#5747
        $_.checksum = 0; //#5748
        $_.i = 0; //#5749
        $_.n = 0; //#5749
        for (;;) { //#5761
            $_.isbnchar = $f($get($_.isbntxt, $_.i) - 48); //#5751
            if ($_.isbnchar != -3) { //#5758
                $put($_.isbn, $_.n, $f($_.isbnchar + 48)); //#5753
                if ($_.n < 9) { //#5756
                    $_.checksum = $f($_.checksum + ((10 - $_.n) * $_.isbnchar)); //#5755
                } //#5755
                $_.n = $_.n + 1; //#5757
            } //#5757
            $_.i = $_.i + 1; //#5759
            if ($_.i == $_.isbntxt.length) { //#5760
                break; //#5760
            } //#5760
        } //#5760
        var _1B = ($f(11 - ($_.checksum % 11))) % 11; //#5762
        $k[$j++] = 'checksum'; //#5762
        $k[$j++] = _1B; //#5762
        if (_1B == 10) { //#5762
            $j--; //#5762
            $k[$j++] = 40; //#5762
        } //#5762
        var _1C = $k[--$j]; //#5762
        $_[$k[--$j]] = $f(_1C + 48); //#5762
        $_.isbn = $geti($_.isbn, 0, 9); //#5763
        if ($_.isbntxt.length == 13) { //#5768
            if ($get($_.isbntxt, 12) != $_.checksum) { //#5767
                $k[$j++] = 'bwipp.isbn10badCheckDigit#5766'; //#5766
                $k[$j++] = "Incorrect ISBN-10 check digit provided"; //#5766
                bwipp_raiseerror(); //#5766
            } //#5766
        } //#5766
    } //#5766
    if ((!$_.legacy) || ($_.isbntxt.length >= 15)) { //#5805
        if ($_.isbntxt.length <= 13) { //#5779
            $_.pad = $s(15); //#5775
            $puti($_.pad, 0, "978-"); //#5776
            $puti($_.pad, 4, $geti($_.isbntxt, 0, 11)); //#5777
            $_.isbntxt = $_.pad; //#5778
        } //#5778
        $_.isbn = $s(13); //#5782
        $_.checksum = 0; //#5783
        $_.i = 0; //#5784
        $_.n = 0; //#5784
        for (;;) { //#5796
            $_.isbnchar = $get($_.isbntxt, $_.i) - 48; //#5786
            if ($_.isbnchar != -3) { //#5793
                $put($_.isbn, $_.n, $_.isbnchar + 48); //#5788
                if ($_.n < 12) { //#5791
                    $k[$j++] = 'checksum'; //#5790
                    $k[$j++] = $_.isbnchar; //#5790
                    if (($_.n % 2) != 0) { //#5790
                        var _1e = $k[--$j]; //#5790
                        $k[$j++] = _1e * 3; //#5790
                    } //#5790
                    var _1g = $k[--$j]; //#5790
                    $_[$k[--$j]] = $f(_1g + $_.checksum); //#5790
                } //#5790
                $_.n = $_.n + 1; //#5792
            } //#5792
            $_.i = $_.i + 1; //#5794
            if ($_.i == $_.isbntxt.length) { //#5795
                break; //#5795
            } //#5795
        } //#5795
        $_.checksum = ((10 - ($_.checksum % 10)) % 10) + 48; //#5797
        $_.isbn = $geti($_.isbn, 0, 12); //#5798
        if ($_.isbntxt.length == 17) { //#5803
            if ($get($_.isbntxt, 16) != $_.checksum) { //#5802
                $k[$j++] = 'bwipp.isbn13badCheckDigit#5801'; //#5801
                $k[$j++] = "Incorrect ISBN-13 check digit provided"; //#5801
                bwipp_raiseerror(); //#5801
            } //#5801
        } //#5801
    } //#5801
    var _1u = ($_.isbn.length == 12) ? 22 : 18; //#5808
    $_.pad = $s(_1u); //#5808
    $puti($_.pad, 0, "ISBN "); //#5809
    $puti($_.pad, 5, $_.isbntxt); //#5810
    $put($_.pad, $_.pad.length - 2, 45); //#5811
    $put($_.pad, $_.pad.length - 1, $_.checksum); //#5812
    $_.isbntxt = $_.pad; //#5813
    $_.barcode = $s(12); //#5816
    if ($_.isbn.length == 9) { //#5821
        $puti($_.barcode, 0, "978"); //#5818
        $puti($_.barcode, 3, $_.isbn); //#5819
    } else { //#5821
        $puti($_.barcode, 0, $_.isbn); //#5821
    } //#5821
    if ($ne($_.addon, "")) { //#5831
        var _2E = $s((12 + $_.addon.length) + 1); //#5826
        $puti(_2E, 0, $_.barcode); //#5827
        $puti(_2E, 12, " "); //#5828
        $puti(_2E, 13, $_.addon); //#5829
        $_.barcode = _2E; //#5830
    } //#5830
    $put($_.options, "dontdraw", true); //#5834
    $put($_.options, "addongap", $_.addongap); //#5835
    $k[$j++] = 'args'; //#5836
    $k[$j++] = $_.barcode; //#5836
    $k[$j++] = $_.options; //#5836
    bwipp_ean13(); //#5836
    var _2M = $k[--$j]; //#5836
    $_[$k[--$j]] = _2M; //#5836
    if ($_.includetext) { //#5855
        if ($eq($_.isbntextxoffset, null)) { //#5842
            $k[$j++] = 'isbntextxoffset'; //#5841
            if ($_.isbn.length == 9) { //#5841
                $k[$j++] = -1; //#5841
            } else { //#5841
                $k[$j++] = -12; //#5841
            } //#5841
            var _2R = $k[--$j]; //#5841
            $_[$k[--$j]] = _2R; //#5841
        } //#5841
        if ($eq($_.isbntextyoffset, null)) { //#5845
            $_.isbntextyoffset = ($_.height * 72) + 3; //#5844
        } //#5844
        var _2W = $get($_.args, "txt") !== undefined; //#5846
        if (_2W) { //#5853
            $_.txt = $get($_.args, "txt"); //#5847
            $_.newtxt = $a($_.txt.length + 1); //#5848
            $puti($_.newtxt, 0, $_.txt); //#5849
            $put($_.newtxt, $_.newtxt.length - 1, $a([$_.isbntxt, $_.isbntextxoffset, $_.isbntextyoffset, $_.isbntextfont, $_.isbntextsize])); //#5850
            $put($_.args, "txt", $_.newtxt); //#5851
        } else { //#5853
            $put($_.args, "txt", $a([$a([$_.isbntxt, $_.isbntextxoffset, $_.isbntextyoffset, $_.isbntextfont, $_.isbntextsize])])); //#5853
        } //#5853
    } //#5853
    $put($_.args, "opt", $_.options); //#5857
    $k[$j++] = $_.args; //#5860
    if (!$_.dontdraw) { //#5860
        bwipp_renlinear(); //#5860
    } //#5860
    $_ = Object.getPrototypeOf($_); //#5862
} //bwipp_isbn
function bwipp_ismn() {
    $_ = Object.create($_); //#5891
    $_.dontdraw = false; //#5894
    $_.includetext = false; //#5895
    $_.ismntextfont = 'OCR-A'; //#5896
    $_.ismntextsize = 8; //#5897
    $_.ismntextxoffset = null; //#5898
    $_.ismntextyoffset = null; //#5899
    $_.height = 1; //#5900
    $_.addongap = 12; //#5901
    $_.legacy = false; //#5902
    $k[$j++] = $_; //#5904
    bwipp_processoptions(); //#5904
    $_.options = $k[--$j]; //#5904
    $_.barcode = $k[--$j]; //#5905
    $search($_.barcode, " "); //#5908
    if ($k[--$j]) { //#5914
        $_.barcode = $k[--$j]; //#5909
        $j--; //#5910
        $_.addon = $k[--$j]; //#5911
    } else { //#5914
        $j--; //#5913
        $_.addon = ""; //#5914
    } //#5914
    if ((($_.barcode.length != 15) && ($_.barcode.length != 17)) && (($_.barcode.length != 11) && ($_.barcode.length != 13))) { //#5921
        $k[$j++] = 'bwipp.ismnBadLength#5920'; //#5920
        $k[$j++] = "ISMN-13 must be 15 or 17 characters including dashes. ISMN-10 must be 11 or 13 characters including dashes"; //#5920
        bwipp_raiseerror(); //#5920
    } //#5920
    if ((($_.addon.length != 0) && ($_.addon.length != 2)) && ($_.addon.length != 5)) { //#5924
        $k[$j++] = 'bwipp.ismnBadAddOnLength#5923'; //#5923
        $k[$j++] = "Add-on for ISMN must be 2 or 5 digits"; //#5923
        bwipp_raiseerror(); //#5923
    } //#5923
    if ($_.barcode.length >= 15) { //#5991
        if ($ne($geti($_.barcode, 0, 4), "979-")) { //#5928
            $k[$j++] = 'bwipp.ismn13badPrefix#5927'; //#5927
            $k[$j++] = "ISMN-13 prefix must be 979-"; //#5927
            bwipp_raiseerror(); //#5927
        } //#5927
        $_.wasdash = false; //#5929
        $_.numdash = 0; //#5929
        $_.numdigit = 0; //#5929
        var _H = $geti($_.barcode, 5, 9); //#5930
        for (var _I = 0, _J = _H.length; _I < _J; _I++) { //#5943
            var _K = $get(_H, _I); //#5943
            $k[$j++] = _K; //#5938
            if (_K == 45) { //#5938
                if ($_.wasdash) { //#5935
                    $k[$j++] = 'bwipp.ismn13adjacentDashes#5934'; //#5934
                    $k[$j++] = "ISMN-13 does not permit adjacent dashes"; //#5934
                    bwipp_raiseerror(); //#5934
                } //#5934
                $_.wasdash = true; //#5936
                $_.numdash = $_.numdash + 1; //#5937
            } //#5937
            var _N = $k[--$j]; //#5939
            if ((_N >= 48) && (_N <= 57)) { //#5942
                $_.wasdash = false; //#5940
                $_.numdigit = $_.numdigit + 1; //#5941
            } //#5941
        } //#5941
        if (($_.numdash != 2) || ($_.numdigit != 7)) { //#5946
            $k[$j++] = 'bwipp.ismn13numDashesDigits#5945'; //#5945
            $k[$j++] = "Incorrect number of dashes and digits for ISMN-13"; //#5945
            bwipp_raiseerror(); //#5945
        } //#5945
        var _S = $get($_.barcode, 14); //#5947
        if ((_S < 48) || (_S > 57)) { //#5949
            $k[$j++] = 'bwipp.ismn13character15#5948'; //#5948
            $k[$j++] = "ISMN-13 character 15 must be a digit"; //#5948
            bwipp_raiseerror(); //#5948
        } //#5948
        if ($_.barcode.length == 17) { //#5957
            if ($ne($geti($_.barcode, 15, 1), "-")) { //#5953
                $k[$j++] = 'bwipp.ismn13character16#5952'; //#5952
                $k[$j++] = "ISMN-13 penultimate character must be a dash"; //#5952
                bwipp_raiseerror(); //#5952
            } //#5952
            var _X = $get($_.barcode, 16); //#5954
            if ((_X < 48) || (_X > 57)) { //#5956
                $k[$j++] = 'bwipp.ismn13character17#5955'; //#5955
                $k[$j++] = "ISMN-13 final character must be a digit"; //#5955
                bwipp_raiseerror(); //#5955
            } //#5955
        } //#5955
    } else { //#5991
        if ($ne($geti($_.barcode, 0, 2), "M-")) { //#5961
            $k[$j++] = 'bwipp.ismn10badPrefix#5960'; //#5960
            $k[$j++] = "ISMN-10 prefix must be M-"; //#5960
            bwipp_raiseerror(); //#5960
        } //#5960
        var _b = $get($_.barcode, 2); //#5962
        if ((_b < 48) || (_b > 57)) { //#5964
            $k[$j++] = 'bwipp.ismn10character3#5963'; //#5963
            $k[$j++] = "ISMN-10 character 3 must be a digit"; //#5963
            bwipp_raiseerror(); //#5963
        } //#5963
        $_.wasdash = false; //#5965
        $_.numdash = 0; //#5965
        $_.numdigit = 0; //#5965
        var _d = $geti($_.barcode, 3, 7); //#5966
        for (var _e = 0, _f = _d.length; _e < _f; _e++) { //#5979
            var _g = $get(_d, _e); //#5979
            $k[$j++] = _g; //#5974
            if (_g == 45) { //#5974
                if ($_.wasdash) { //#5971
                    $k[$j++] = 'bwipp.ismn10adjacentDashes#5970'; //#5970
                    $k[$j++] = "ISMN-10 does not permit adjacent dashes"; //#5970
                    bwipp_raiseerror(); //#5970
                } //#5970
                $_.wasdash = true; //#5972
                $_.numdash = $_.numdash + 1; //#5973
            } //#5973
            var _j = $k[--$j]; //#5975
            if ((_j >= 48) && (_j <= 57)) { //#5978
                $_.wasdash = false; //#5976
                $_.numdigit = $_.numdigit + 1; //#5977
            } //#5977
        } //#5977
        if (($_.numdash != 1) || ($_.numdigit != 6)) { //#5982
            $k[$j++] = 'bwipp.ismn10numDashesDigits#5981'; //#5981
            $k[$j++] = "Incorrect number of dashes and digits for ISMN-10"; //#5981
            bwipp_raiseerror(); //#5981
        } //#5981
        var _o = $get($_.barcode, 10); //#5983
        if ((_o < 48) || (_o > 57)) { //#5985
            $k[$j++] = 'bwipp.ismn10character11#5984'; //#5984
            $k[$j++] = "ISMN-10 character 11 must be a digit"; //#5984
            bwipp_raiseerror(); //#5984
        } //#5984
        if ($_.barcode.length == 13) { //#5993
            var _r = $geti($_.barcode, 11, 1); //#5987
            if ($ne(_r, "-")) { //#5989
                $k[$j++] = 'bwipp.ismn10character12#5988'; //#5988
                $k[$j++] = "ISMN-10 penultimate character must be a dash"; //#5988
                bwipp_raiseerror(); //#5988
            } //#5988
            var _t = $get($_.barcode, 12); //#5990
            if (((_t < 48) || (_t > 57)) && (_t != 88)) { //#5992
                $k[$j++] = 'bwipp.ismn10character13#5991'; //#5991
                $k[$j++] = "ISMN-10 final character must be a digit or X"; //#5991
                bwipp_raiseerror(); //#5991
            } //#5991
        } //#5991
    } //#5991
    $_.ismntxt = $_.barcode; //#5996
    $_.legacytxt = ""; //#5999
    if ($_.ismntxt.length <= 13) { //#6006
        $_.legacytxt = $_.ismntxt; //#6001
        $_.pad = $s($_.ismntxt.length + 4); //#6002
        $puti($_.pad, 0, "979-0-"); //#6003
        $puti($_.pad, 6, $geti($_.ismntxt, 2, $_.ismntxt.length - 2)); //#6004
        $_.ismntxt = $_.pad; //#6005
    } //#6005
    $_.ismn = $s(13); //#6009
    $_.checksum = 0; //#6010
    $_.i = 0; //#6011
    $_.n = 0; //#6011
    for (;;) { //#6027
        $_.ismnchar = $get($_.ismntxt, $_.i) - 48; //#6013
        if ($_.ismnchar != -3) { //#6024
            $put($_.ismn, $_.n, $_.ismnchar + 48); //#6015
            if ($_.n < 12) { //#6022
                if (($_.n % 2) == 0) { //#6020
                    $_.checksum = $_.ismnchar + $_.checksum; //#6018
                } else { //#6020
                    $_.checksum = ($_.ismnchar * 3) + $_.checksum; //#6020
                } //#6020
            } //#6020
            $_.n = $_.n + 1; //#6023
        } //#6023
        $_.i = $_.i + 1; //#6025
        if ($_.i == $_.ismntxt.length) { //#6026
            break; //#6026
        } //#6026
    } //#6026
    $_.checksum = ((10 - ($_.checksum % 10)) % 10) + 48; //#6028
    if (($_.barcode.length == 13) || ($_.barcode.length == 17)) { //#6035
        var _1Q = $_.barcode; //#6032
        if ($get(_1Q, _1Q.length - 1) != $_.checksum) { //#6034
            $k[$j++] = 'bwipp.ismnBadCheckDigit#6033'; //#6033
            $k[$j++] = "Incorrect ISMN check digit provided"; //#6033
            bwipp_raiseerror(); //#6033
        } //#6033
    } //#6033
    if ($_.legacy && $ne($_.legacytxt, "")) { //#6042
        $_.ismntxt = $_.legacytxt; //#6039
        $_.pad = $s(18); //#6040
    } else { //#6042
        $_.pad = $s(22); //#6042
    } //#6042
    $puti($_.pad, 0, "ISMN "); //#6044
    $puti($_.pad, 5, $_.ismntxt); //#6045
    $put($_.pad, $_.pad.length - 2, 45); //#6046
    $put($_.pad, $_.pad.length - 1, $_.checksum); //#6047
    $_.ismntxt = $_.pad; //#6048
    $_.barcode = $geti($_.ismn, 0, 12); //#6051
    if ($ne($_.addon, "")) { //#6060
        var _1l = $s((12 + $_.addon.length) + 1); //#6055
        $puti(_1l, 0, $_.barcode); //#6056
        $puti(_1l, 12, " "); //#6057
        $puti(_1l, 13, $_.addon); //#6058
        $_.barcode = _1l; //#6059
    } //#6059
    $put($_.options, "dontdraw", true); //#6063
    $put($_.options, "addongap", $_.addongap); //#6064
    $k[$j++] = 'args'; //#6065
    $k[$j++] = $_.barcode; //#6065
    $k[$j++] = $_.options; //#6065
    bwipp_ean13(); //#6065
    var _1t = $k[--$j]; //#6065
    $_[$k[--$j]] = _1t; //#6065
    if ($_.includetext) { //#6084
        if ($eq($_.ismntextxoffset, null)) { //#6071
            $k[$j++] = 'ismntextxoffset'; //#6070
            if ($_.ismntxt.length == 18) { //#6070
                $k[$j++] = -1; //#6070
            } else { //#6070
                $k[$j++] = -12; //#6070
            } //#6070
            var _1y = $k[--$j]; //#6070
            $_[$k[--$j]] = _1y; //#6070
        } //#6070
        if ($eq($_.ismntextyoffset, null)) { //#6074
            $_.ismntextyoffset = ($_.height * 72) + 3; //#6073
        } //#6073
        var _23 = $get($_.args, "txt") !== undefined; //#6075
        if (_23) { //#6082
            $_.txt = $get($_.args, "txt"); //#6076
            $_.newtxt = $a($_.txt.length + 1); //#6077
            $puti($_.newtxt, 0, $_.txt); //#6078
            $put($_.newtxt, $_.newtxt.length - 1, $a([$_.ismntxt, $_.ismntextxoffset, $_.ismntextyoffset, $_.ismntextfont, $_.ismntextsize])); //#6079
            $put($_.args, "txt", $_.newtxt); //#6080
        } else { //#6082
            $put($_.args, "txt", $a([$a([$_.ismntxt, $_.ismntextxoffset, $_.ismntextyoffset, $_.ismntextfont, $_.ismntextsize])])); //#6082
        } //#6082
    } //#6082
    $put($_.args, "opt", $_.options); //#6086
    $k[$j++] = $_.args; //#6089
    if (!$_.dontdraw) { //#6089
        bwipp_renlinear(); //#6089
    } //#6089
    $_ = Object.getPrototypeOf($_); //#6091
} //bwipp_ismn
function bwipp_issn() {
    $_ = Object.create($_); //#6120
    $_.dontdraw = false; //#6123
    $_.includetext = false; //#6124
    $_.issntextfont = 'OCR-A'; //#6125
    $_.issntextsize = 8; //#6126
    $_.issntextxoffset = null; //#6127
    $_.issntextyoffset = null; //#6128
    $_.height = 1; //#6129
    $_.addongap = 12; //#6130
    $k[$j++] = $_; //#6132
    bwipp_processoptions(); //#6132
    $_.options = $k[--$j]; //#6132
    $_.issntxt = $k[--$j]; //#6133
    $search($_.issntxt, " "); //#6136
    if ($k[--$j]) { //#6142
        $_.issntxt = $k[--$j]; //#6137
        $j--; //#6138
        $_.seqvar = $k[--$j]; //#6139
    } else { //#6142
        $j--; //#6141
        $_.seqvar = "00"; //#6142
    } //#6142
    $search($_.seqvar, " "); //#6146
    if ($k[--$j]) { //#6152
        $_.seqvar = $k[--$j]; //#6147
        $j--; //#6148
        $_.addon = $k[--$j]; //#6149
    } else { //#6152
        $j--; //#6151
        $_.addon = ""; //#6152
    } //#6152
    if (($_.issntxt.length != 8) && ($_.issntxt.length != 9)) { //#6158
        $k[$j++] = 'bwipp.issnBadLength#6157'; //#6157
        $k[$j++] = "ISSN must be 8 or 9 characters including dash, in the format XXXX-XXXX"; //#6157
        bwipp_raiseerror(); //#6157
    } //#6157
    var _D = $geti($_.issntxt, 0, 4); //#6159
    for (var _E = 0, _F = _D.length; _E < _F; _E++) { //#6163
        var _G = $get(_D, _E); //#6163
        if ((_G < 48) || (_G > 57)) { //#6162
            $k[$j++] = 'bwipp.issnFirstThroughFourthNotNumeric#6161'; //#6161
            $k[$j++] = "ISSN first four characters must be numeral characters"; //#6161
            bwipp_raiseerror(); //#6161
        } //#6161
    } //#6161
    if ($ne($geti($_.issntxt, 4, 1), "-")) { //#6166
        $k[$j++] = 'bwipp.issnNeedsDash#6165'; //#6165
        $k[$j++] = "ISSN fifth character must be a dash"; //#6165
        bwipp_raiseerror(); //#6165
    } //#6165
    var _K = $geti($_.issntxt, 5, 3); //#6167
    for (var _L = 0, _M = _K.length; _L < _M; _L++) { //#6171
        var _N = $get(_K, _L); //#6171
        if ((_N < 48) || (_N > 57)) { //#6170
            $k[$j++] = 'bwipp.issnSixthThroughEighthNotNumeric#6169'; //#6169
            $k[$j++] = "ISSN sixth through eighth characters must be numerals"; //#6169
            bwipp_raiseerror(); //#6169
        } //#6169
    } //#6169
    if ($_.issntxt.length == 9) { //#6176
        var _Q = $get($_.issntxt, 8); //#6173
        if (((_Q < 48) || (_Q > 57)) && (_Q != 88)) { //#6175
            $k[$j++] = 'bwipp.issnNinthCharacterBadFormat#6174'; //#6174
            $k[$j++] = "ISSN ninth character must be a number or the character X"; //#6174
            bwipp_raiseerror(); //#6174
        } //#6174
    } //#6174
    if ($_.seqvar.length != 2) { //#6179
        $k[$j++] = 'bwipp.issnBadSequenceVariantLength#6178'; //#6178
        $k[$j++] = "Sequence variant for ISSN must be 2 digits"; //#6178
        bwipp_raiseerror(); //#6178
    } //#6178
    $forall($_.seqvar, function() { //#6184
        var _T = $k[--$j]; //#6181
        if ((_T < 48) || (_T > 57)) { //#6183
            $k[$j++] = 'bwipp.issnSequenceVariantBadCharacter#6182'; //#6182
            $k[$j++] = "Sequence variant for ISSN must contain only digits"; //#6182
            bwipp_raiseerror(); //#6182
        } //#6182
    }); //#6182
    if ((($_.addon.length != 0) && ($_.addon.length != 2)) && ($_.addon.length != 5)) { //#6187
        $k[$j++] = 'bwipp.issnBadAddOnLength#6186'; //#6186
        $k[$j++] = "Add-on for ISSN must be 2 or 5 digits"; //#6186
        bwipp_raiseerror(); //#6186
    } //#6186
    $_.issn = $s(8); //#6190
    $_.checksum = 0; //#6191
    $_.i = 0; //#6192
    $_.n = 0; //#6192
    for (;;) { //#6204
        $_.issnchar = $f($get($_.issntxt, $_.i) - 48); //#6194
        if ($_.issnchar != -3) { //#6201
            $put($_.issn, $_.n, $f($_.issnchar + 48)); //#6196
            if ($_.n < 7) { //#6199
                $_.checksum = $f($_.checksum + ($_.issnchar * (8 - $_.n))); //#6198
            } //#6198
            $_.n = $_.n + 1; //#6200
        } //#6200
        $_.i = $_.i + 1; //#6202
        if ($_.i == $_.issntxt.length) { //#6203
            break; //#6203
        } //#6203
    } //#6203
    $_.checksum = ($f(11 - ($_.checksum % 11))) % 11; //#6205
    var _p = $f($_.checksum + 48); //#6206
    $k[$j++] = 'checksum'; //#6206
    $k[$j++] = _p; //#6206
    if (_p == 58) { //#6206
        $j--; //#6206
        $k[$j++] = 88; //#6206
    } //#6206
    var _q = $k[--$j]; //#6206
    var _r = $k[--$j]; //#6206
    $_[_r] = _q; //#6206
    if ($_.issntxt.length == 9) { //#6211
        if ($get($_.issntxt, 8) != $_.checksum) { //#6210
            $k[$j++] = 'bwipp.issnBadCheckDigit#6209'; //#6209
            $k[$j++] = "Incorrect ISSN check digit provided"; //#6209
            bwipp_raiseerror(); //#6209
        } //#6209
    } //#6209
    $_.pad = $s(14); //#6214
    $puti($_.pad, 0, "ISSN "); //#6215
    $puti($_.pad, 5, $_.issntxt); //#6216
    $put($_.pad, 13, $_.checksum); //#6217
    $_.issntxt = $_.pad; //#6218
    $_.barcode = $geti($_.issn, 0, 7); //#6221
    $_.barcode = $s(12); //#6224
    $puti($_.barcode, 0, "977"); //#6225
    $puti($_.barcode, 3, $_.issn); //#6226
    $puti($_.barcode, 10, $_.seqvar); //#6227
    if ($ne($_.addon, "")) { //#6236
        var _1D = $s((12 + $_.addon.length) + 1); //#6231
        $puti(_1D, 0, $_.barcode); //#6232
        $puti(_1D, 12, " "); //#6233
        $puti(_1D, 13, $_.addon); //#6234
        $_.barcode = _1D; //#6235
    } //#6235
    $put($_.options, "dontdraw", true); //#6239
    $put($_.options, "addongap", $_.addongap); //#6240
    $k[$j++] = 'args'; //#6241
    $k[$j++] = $_.barcode; //#6241
    $k[$j++] = $_.options; //#6241
    bwipp_ean13(); //#6241
    var _1L = $k[--$j]; //#6241
    $_[$k[--$j]] = _1L; //#6241
    if ($_.includetext) { //#6256
        if ($eq($_.issntextxoffset, null)) { //#6245
            $_.issntextxoffset = 10; //#6245
        } //#6245
        if ($eq($_.issntextyoffset, null)) { //#6246
            $_.issntextyoffset = ($_.height * 72) + 3; //#6246
        } //#6246
        var _1S = $get($_.args, "txt") !== undefined; //#6247
        if (_1S) { //#6254
            $_.txt = $get($_.args, "txt"); //#6248
            $_.newtxt = $a($_.txt.length + 1); //#6249
            $puti($_.newtxt, 0, $_.txt); //#6250
            $put($_.newtxt, $_.newtxt.length - 1, $a([$_.issntxt, $_.issntextxoffset, $_.issntextyoffset, $_.issntextfont, $_.issntextsize])); //#6251
            $put($_.args, "txt", $_.newtxt); //#6252
        } else { //#6254
            $put($_.args, "txt", $a([$a([$_.issntxt, $_.issntextxoffset, $_.issntextyoffset, $_.issntextfont, $_.issntextsize])])); //#6254
        } //#6254
    } //#6254
    $put($_.args, "opt", $_.options); //#6258
    $k[$j++] = $_.args; //#6261
    if (!$_.dontdraw) { //#6261
        bwipp_renlinear(); //#6261
    } //#6261
    $_ = Object.getPrototypeOf($_); //#6263
} //bwipp_issn
function bwipp_mands() {
    $_ = Object.create($_); //#6292
    $_.dontdraw = false; //#6295
    $_.includetext = false; //#6296
    $k[$j++] = $_; //#6298
    bwipp_processoptions(); //#6298
    $_.options = $k[--$j]; //#6298
    $_.barcode = $k[--$j]; //#6299
    $_.barlen = $_.barcode.length; //#6301
    if (($_.barlen != 7) && ($_.barlen != 8)) { //#6306
        $k[$j++] = 'bwipp.MandSbadLength#6305'; //#6305
        $k[$j++] = "M&S barcode must be 7 or 8 characters"; //#6305
        bwipp_raiseerror(); //#6305
    } //#6305
    if ($_.barlen == 7) { //#6310
        var _7 = $strcpy($s(8), "00000000"); //#6309
        $puti(_7, 1, $_.barcode); //#6309
        $_.barcode = _7; //#6309
    } //#6309
    $put($_.options, "dontdraw", true); //#6313
    $k[$j++] = 'args'; //#6314
    $k[$j++] = $_.barcode; //#6314
    $k[$j++] = $_.options; //#6314
    bwipp_ean8(); //#6314
    var _C = $k[--$j]; //#6314
    $_[$k[--$j]] = _C; //#6314
    var _F = $get($_.args, "bbs"); //#6317
    $put(_F, 10, $get(_F, 2)); //#6318
    $put(_F, 11, $get(_F, 2)); //#6319
    var _J = $get($_.args, "bhs"); //#6320
    $put(_J, 10, $get(_J, 2)); //#6321
    $put(_J, 11, $get(_J, 2)); //#6322
    $_.txt = $get($_.args, "txt"); //#6325
    if ($_.barlen == 7) { //#6333
        for (var _P = 0; _P <= 6; _P += 1) { //#6331
            var _Q = $_.txt; //#6328
            $puti($get($get(_Q, _P), 0), 0, $get($get(_Q, _P + 1), 0)); //#6330
        } //#6330
        $puti($get($get($_.txt, 7), 0), 0, " "); //#6332
    } //#6332
    var _Y = $a(10); //#6336
    $puti(_Y, 0, $_.txt); //#6336
    $_.txt = _Y; //#6336
    var _b = $get($_.txt, 0); //#6337
    $put($_.txt, 8, $arrcpy($a(_b.length), _b)); //#6337
    var _g = $get($_.txt, 0); //#6338
    $put($_.txt, 9, $arrcpy($a(_g.length), _g)); //#6338
    $put($get($_.txt, 8), 0, "M"); //#6339
    $put($get($_.txt, 8), 1, -12); //#6339
    $put($get($_.txt, 9), 0, "S"); //#6340
    var _r = $get($_.txt, 9); //#6340
    $put(_r, 1, 69); //#6340
    $put($_.args, "txt", $_.txt); //#6342
    $put($_.args, "opt", $_.options); //#6343
    $k[$j++] = $_.args; //#6346
    if (!$_.dontdraw) { //#6346
        bwipp_renlinear(); //#6346
    } //#6346
    $_ = Object.getPrototypeOf($_); //#6348
} //bwipp_mands
function bwipp_code128() {
    $_ = Object.create($_); //#6379
    $_.dontdraw = false; //#6382
    $_.includetext = false; //#6383
    $_.textfont = "OCR-B"; //#6384
    $_.textsize = 10; //#6385
    $_.textxoffset = 0; //#6386
    $_.textyoffset = -8; //#6387
    $_.height = 1; //#6388
    $_.encoding = "auto"; //#6389
    $_.raw = false; //#6390
    $_.parse = false; //#6391
    $_.parsefnc = false; //#6392
    $k[$j++] = $_; //#6394
    bwipp_processoptions(); //#6394
    $_.options = $k[--$j]; //#6394
    $_.barcode = $k[--$j]; //#6395
    bwipp_loadctx(bwipp_code128) //#6397
    if (!bwipp_code128.__6406__) { //#6406
        $_ = Object.create($_); //#6406
        $_.sta = -1; //#6401
        $_.stb = -2; //#6401
        $_.stc = -3; //#6401
        $_.swa = -4; //#6402
        $_.swb = -5; //#6402
        $_.swc = -6; //#6402
        $_.fn1 = -7; //#6403
        $_.fn2 = -8; //#6403
        $_.fn3 = -9; //#6403
        $_.fn4 = -10; //#6404
        $_.sft = -11; //#6404
        $_.stp = -12; //#6404
        $_.lka = -13; //#6405
        $_.lkc = -14; //#6405
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_code128.$ctx[id] = $_[id]); //#6405
        bwipp_code128.__6406__ = 1; //#6405
        $_ = Object.getPrototypeOf($_); //#6405
    } //#6405
    var _6 = $_.fn1; //#6413
    var _B = new Map([
        ["parse", $_.parse],
        ["parsefnc", $_.parsefnc],
        ["FNC1", $_.fn1],
        ["FNC1", _6],
        ["FNC2", $_.fn2],
        ["FNC3", $_.fn3],
        ["LNKA", $_.lka],
        ["LNKC", $_.lkc]
    ]); //#6418
    $_.fncvals = _B; //#6419
    $k[$j++] = 'msg'; //#6420
    $k[$j++] = $_.barcode; //#6420
    $k[$j++] = $_.fncvals; //#6420
    bwipp_parseinput(); //#6420
    var _E = $k[--$j]; //#6420
    $_[$k[--$j]] = _E; //#6420
    $_.msglen = $_.msg.length; //#6421
    if (!bwipp_code128.__6479__) { //#6479
        $_ = Object.create($_); //#6479
        $_.charmaps = $a([$a([32, 32, "00"]), $a(["!", "!", "01"]), $a(["\"", "\"", "02"]), $a(["#", "#", "03"]), $a(["$", "$", "04"]), $a(["%", "%", "05"]), $a(["&", "&", "06"]), $a(["'", "'", "07"]), $a([40, 40, "08"]), $a([41, 41, "09"]), $a(["*", "*", "10"]), $a(["+", "+", "11"]), $a([",", ",", "12"]), $a(["-", "-", "13"]), $a([".", ".", "14"]), $a(["/", "/", "15"]), $a(["0", "0", "16"]), $a(["1", "1", "17"]), $a(["2", "2", "18"]), $a(["3", "3", "19"]), $a(["4", "4", "20"]), $a(["5", "5", "21"]), $a(["6", "6", "22"]), $a(["7", "7", "23"]), $a(["8", "8", "24"]), $a(["9", "9", "25"]), $a([":", ":", "26"]), $a([";", ";", "27"]), $a(["<", "<", "28"]), $a(["=", "=", "29"]), $a([">", ">", "30"]), $a(["?", "?", "31"]), $a(["@", "@", "32"]), $a(["A", "A", "33"]), $a(["B", "B", "34"]), $a(["C", "C", "35"]), $a(["D", "D", "36"]), $a(["E", "E", "37"]), $a(["F", "F", "38"]), $a(["G", "G", "39"]), $a(["H", "H", "40"]), $a(["I", "I", "41"]), $a(["J", "J", "42"]), $a(["K", "K", "43"]), $a(["L", "L", "44"]), $a(["M", "M", "45"]), $a(["N", "N", "46"]), $a(["O", "O", "47"]), $a(["P", "P", "48"]), $a(["Q", "Q", "49"]), $a(["R", "R", "50"]), $a(["S", "S", "51"]), $a(["T", "T", "52"]), $a(["U", "U", "53"]), $a(["V", "V", "54"]), $a(["W", "W", "55"]), $a(["X", "X", "56"]), $a(["Y", "Y", "57"]), $a(["Z", "Z", "58"]), $a(["[", "[", "59"]), $a([92, 92, "60"]), $a(["]", "]", "61"]), $a(["^", "^", "62"]), $a(["_", "_", "63"]), $a([0, "`", "64"]), $a([1, "a", "65"]), $a([2, "b", "66"]), $a([3, "c", "67"]), $a([4, "d", "68"]), $a([5, "e", "69"]), $a([6, "f", "70"]), $a([7, "g", "71"]), $a([8, "h", "72"]), $a([9, "i", "73"]), $a([10, "j", "74"]), $a([11, "k", "75"]), $a([12, "l", "76"]), $a([13, "m", "77"]), $a([14, "n", "78"]), $a([15, "o", "79"]), $a([16, "p", "80"]), $a([17, "q", "81"]), $a([18, "r", "82"]), $a([19, "s", "83"]), $a([20, "t", "84"]), $a([21, "u", "85"]), $a([22, "v", "86"]), $a([23, "w", "87"]), $a([24, "x", "88"]), $a([25, "y", "89"]), $a([26, "z", "90"]), $a([27, "{", "91"]), $a([28, "|", "92"]), $a([29, "}", "93"]), $a([30, "~", "94"]), $a([31, 127, "95"]), $a([$_.fn3, $_.fn3, "96"]), $a([$_.fn2, $_.fn2, "97"]), $a([$_.sft, $_.sft, "98"]), $a([$_.swc, $_.swc, "99"]), $a([$_.swb, $_.fn4, $_.swb]), $a([$_.fn4, $_.swa, $_.swa]), $a([$_.fn1, $_.fn1, $_.fn1]), $a([$_.sta, $_.sta, $_.sta]), $a([$_.stb, $_.stb, $_.stb]), $a([$_.stc, $_.stc, $_.stc]), $a([$_.stp, $_.stp, $_.stp])]); //#6463
        $_.charvals = $a([new Map, new Map, new Map]); //#6466
        for (var _2X = 0, _2W = $_.charmaps.length - 1; _2X <= _2W; _2X += 1) { //#6475
            $_.i = _2X; //#6468
            $_.encs = $get($_.charmaps, $_.i); //#6469
            for (var _2b = 0; _2b <= 2; _2b += 1) { //#6474
                $_.j = _2b; //#6471
                var _2e = $get($_.encs, $_.j); //#6472
                $k[$j++] = _2e; //#6472
                if ($eq($type(_2e), 'stringtype')) { //#6472
                    var _2h = $get($k[--$j], 0); //#6472
                    $k[$j++] = _2h; //#6472
                } //#6472
                $put($get($_.charvals, $_.j), $k[--$j], $_.i); //#6473
            } //#6473
        } //#6473
        $_.seta = $get($_.charvals, 0); //#6476
        $_.setb = $get($_.charvals, 1); //#6477
        $_.setc = $get($_.charvals, 2); //#6478
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_code128.$ctx[id] = $_[id]); //#6478
        bwipp_code128.__6479__ = 1; //#6478
        $_ = Object.getPrototypeOf($_); //#6478
    } //#6478
    $put($_.seta, $_.lka, $get($_.seta, $_.swb)); //#6482
    $put($_.seta, $_.lkc, $get($_.seta, $_.swc)); //#6482
    $put($_.setb, $_.lka, $get($_.setb, $_.swc)); //#6483
    $put($_.setb, $_.lkc, $get($_.setb, $_.swa)); //#6483
    $put($_.setc, $_.lka, $get($_.setc, $_.swa)); //#6484
    $put($_.setc, $_.lkc, $get($_.setc, $_.swb)); //#6484
    if ($_.raw) { //#6486
        $_.encoding = "raw"; //#6486
    } //#6486
    if ($eq($_.encoding, "raw")) { //#6500
        $_.cws = $a($_.barcode.length); //#6489
        $_.i = 0; //#6490
        $_.j = 0; //#6490
        for (;;) { //#6497
            if ($_.i == $_.barcode.length) { //#6492
                break; //#6492
            } //#6492
            $_.cw = $cvi($geti($_.barcode, $_.i + 1, 3)); //#6493
            $put($_.cws, $_.j, $_.cw); //#6494
            $_.i = $_.i + 4; //#6495
            $_.j = $_.j + 1; //#6496
        } //#6496
        $_.cws = $geti($_.cws, 0, $_.j); //#6498
        $_.text = ""; //#6499
    } //#6499
    if ($eq($_.encoding, "auto")) { //#6725
        $_.text = $s($_.msglen); //#6504
        for (var _3k = 0, _3j = $_.msglen - 1; _3k <= _3j; _3k += 1) { //#6508
            $_.i = _3k; //#6506
            var _3p = $get($_.msg, $_.i); //#6507
            $k[$j++] = $_.text; //#6507
            $k[$j++] = $_.i; //#6507
            $k[$j++] = _3p; //#6507
            if (_3p < 0) { //#6507
                $j--; //#6507
                $k[$j++] = 32; //#6507
            } //#6507
            var _3q = $k[--$j]; //#6507
            var _3r = $k[--$j]; //#6507
            $put($k[--$j], _3r, _3q); //#6507
        } //#6507
        $k[$j++] = Infinity; //#6511
        for (var _3u = 0, _3v = $_.msglen; _3u < _3v; _3u++) { //#6511
            $k[$j++] = 0; //#6511
        } //#6511
        $k[$j++] = 0; //#6511
        $_.numSA = $a(); //#6511
        $k[$j++] = Infinity; //#6512
        for (var _3y = 0, _3z = $_.msglen; _3y < _3z; _3y++) { //#6512
            $k[$j++] = 0; //#6512
        } //#6512
        $k[$j++] = 0; //#6512
        $_.numEA = $a(); //#6512
        for (var _42 = $_.msglen - 1; _42 >= 0; _42 -= 1) { //#6522
            $_.i = _42; //#6514
            if ($get($_.msg, $_.i) >= 0) { //#6521
                if ($get($_.msg, $_.i) >= 128) { //#6519
                    $put($_.numEA, $_.i, $f($get($_.numEA, $_.i + 1) + 1)); //#6517
                } else { //#6519
                    $put($_.numSA, $_.i, $f($get($_.numSA, $_.i + 1) + 1)); //#6519
                } //#6519
            } //#6519
        } //#6519
        $_.ea = false; //#6525
        $_.msgtmp = $a([]); //#6525
        for (var _4M = 0, _4L = $_.msglen - 1; _4M <= _4L; _4M += 1) { //#6540
            $_.i = _4M; //#6527
            $_.c = $get($_.msg, $_.i); //#6528
            if ((!$xo($_.ea, $_.c < 128)) && ($_.c >= 0)) { //#6538
                if ($_.ea) { //#6530
                    $k[$j++] = $_.numSA; //#6530
                } else { //#6530
                    $k[$j++] = $_.numEA; //#6530
                } //#6530
                var _4Y = $get($k[--$j], $_.i); //#6530
                var _4b = ($f(_4Y + $_.i) == $_.msglen) ? 3 : 5; //#6531
                if (_4Y < _4b) { //#6536
                    $k[$j++] = Infinity; //#6533
                    $aload($_.msgtmp); //#6533
                    $k[$j++] = $_.fn4; //#6533
                    $_.msgtmp = $a(); //#6533
                } else { //#6536
                    $k[$j++] = Infinity; //#6535
                    $aload($_.msgtmp); //#6535
                    $k[$j++] = $_.fn4; //#6535
                    $k[$j++] = $_.fn4; //#6535
                    $_.msgtmp = $a(); //#6535
                    $_.ea = !$_.ea; //#6536
                } //#6536
            } //#6536
            $k[$j++] = Infinity; //#6539
            $aload($_.msgtmp); //#6539
            if ($_.c >= 0) { //#6539
                $k[$j++] = $_.c & 127; //#6539
            } else { //#6539
                $k[$j++] = $_.c; //#6539
            } //#6539
            $_.msgtmp = $a(); //#6539
        } //#6539
        $_.msg = $_.msgtmp; //#6541
        $_.msglen = $_.msg.length; //#6542
        $_.numsscr = function() {
            $_.n = 0; //#6546
            $_.s = 0; //#6546
            $_.p = $k[--$j]; //#6547
            for (;;) { //#6560
                if ($_.p >= $_.msglen) { //#6548
                    break; //#6548
                } //#6548
                var _4w = $get($_.msg, $_.p); //#6549
                var _4y = $get($_.setc, _4w) !== undefined; //#6550
                $k[$j++] = _4w; //#6550
                if (!_4y) { //#6550
                    $j--; //#6550
                    break; //#6550
                } //#6550
                var _4z = $k[--$j]; //#6551
                $k[$j++] = _4z; //#6556
                if (_4z <= -1) { //#6555
                    var _51 = $k[--$j]; //#6553
                    if ((_51 == $_.fn1) && (($_.s % 2) == 0)) { //#6553
                        $_.s = $_.s + 1; //#6553
                    } else { //#6553
                        break; //#6553
                    } //#6553
                } else { //#6555
                    $j--; //#6555
                } //#6555
                $_.n = $_.n + 1; //#6557
                $_.s = $_.s + 1; //#6558
                $_.p = $f($_.p + 1); //#6559
            } //#6559
            $k[$j++] = $_.n; //#6561
            $k[$j++] = $_.s; //#6561
        }; //#6561
        $_.enca = function() {
            $put($_.cws, $_.j, $get($_.seta, $k[--$j])); //#6566
            $_.j = $_.j + 1; //#6567
        }; //#6567
        $_.encb = function() {
            $put($_.cws, $_.j, $get($_.setb, $k[--$j])); //#6570
            $_.j = $_.j + 1; //#6571
        }; //#6571
        $_.encc = function() {
            var _5L = $k[--$j]; //#6574
            $k[$j++] = _5L; //#6578
            if ($ne($type(_5L), 'arraytype')) { //#6577
                var _5P = $get($_.setc, $k[--$j]); //#6575
                $k[$j++] = _5P; //#6575
            } else { //#6577
                $aload($k[--$j]); //#6577
                var _5R = $k[--$j]; //#6577
                var _5S = $k[--$j]; //#6577
                $k[$j++] = $f($f(_5R - 48) + ($f(_5S - 48) * 10)); //#6577
            } //#6577
            $put($_.cws, $_.j, $k[--$j]); //#6579
            $_.j = $_.j + 1; //#6580
        }; //#6580
        $_.anotb = function() {
            var _5X = $k[--$j]; //#6584
            var _5Z = $get($_.seta, _5X) !== undefined; //#6584
            var _5b = $get($_.setb, _5X) !== undefined; //#6584
            $k[$j++] = _5Z && (!_5b); //#6584
        }; //#6584
        $_.bnota = function() {
            var _5c = $k[--$j]; //#6585
            var _5e = $get($_.setb, _5c) !== undefined; //#6585
            var _5g = $get($_.seta, _5c) !== undefined; //#6585
            $k[$j++] = _5e && (!_5g); //#6585
        }; //#6585
        $k[$j++] = Infinity; //#6588
        for (var _5i = 0, _5j = $_.msg.length; _5i < _5j; _5i++) { //#6588
            $k[$j++] = 0; //#6588
        } //#6588
        $k[$j++] = 9999; //#6588
        $_.nextanotb = $a(); //#6588
        $k[$j++] = Infinity; //#6589
        for (var _5m = 0, _5n = $_.msg.length; _5m < _5n; _5m++) { //#6589
            $k[$j++] = 0; //#6589
        } //#6589
        $k[$j++] = 9999; //#6589
        $_.nextbnota = $a(); //#6589
        for (var _5q = $_.msg.length - 1; _5q >= 0; _5q -= 1) { //#6602
            $_.i = _5q; //#6591
            $k[$j++] = $get($_.msg, $_.i); //#6592
            $_.anotb(); //#6592
            if ($k[--$j]) { //#6595
                $put($_.nextanotb, $_.i, 0); //#6593
            } else { //#6595
                $put($_.nextanotb, $_.i, $f($get($_.nextanotb, $_.i + 1) + 1)); //#6595
            } //#6595
            $k[$j++] = $get($_.msg, $_.i); //#6597
            $_.bnota(); //#6597
            if ($k[--$j]) { //#6600
                $put($_.nextbnota, $_.i, 0); //#6598
            } else { //#6600
                $put($_.nextbnota, $_.i, $f($get($_.nextbnota, $_.i + 1) + 1)); //#6600
            } //#6600
        } //#6600
        $_.abeforeb = function() {
            var _6D = $k[--$j]; //#6605
            $k[$j++] = $lt($get($_.nextanotb, _6D), $get($_.nextbnota, _6D)); //#6605
        }; //#6605
        $_.bbeforea = function() {
            var _6I = $k[--$j]; //#6606
            $k[$j++] = $lt($get($_.nextbnota, _6I), $get($_.nextanotb, _6I)); //#6606
        }; //#6606
        $_.cws = $a(($_.barcode.length * 2) + 3); //#6608
        $_.j = 0; //#6611
        if ($_.msglen > 0) { //#6612
            $k[$j++] = 0; //#6612
            $_.numsscr(); //#6612
        } else { //#6612
            $k[$j++] = -1; //#6612
            $k[$j++] = -1; //#6612
        } //#6612
        $_.nums = $k[--$j]; //#6612
        $_.nchars = $k[--$j]; //#6612
        for (;;) { //#6637
            if ($_.msglen == 0) { //#6618
                $k[$j++] = $_.stb; //#6615
                $_.enca(); //#6615
                $_.cset = "setb"; //#6616
                break; //#6617
            } //#6617
            if (($_.msglen == 2) && ($_.nums == 2)) { //#6623
                $k[$j++] = $_.stc; //#6620
                $_.enca(); //#6620
                $_.cset = "setc"; //#6621
                break; //#6622
            } //#6622
            if ($_.nums >= 4) { //#6628
                $k[$j++] = $_.stc; //#6625
                $_.enca(); //#6625
                $_.cset = "setc"; //#6626
                break; //#6627
            } //#6627
            $k[$j++] = 0; //#6629
            $_.abeforeb(); //#6629
            if ($k[--$j]) { //#6633
                $k[$j++] = $_.sta; //#6630
                $_.enca(); //#6630
                $_.cset = "seta"; //#6631
                break; //#6632
            } //#6632
            $k[$j++] = $_.stb; //#6634
            $_.enca(); //#6634
            $_.cset = "setb"; //#6635
            break; //#6636
        } //#6636
        $_.i = 0; //#6640
        for (;;) { //#6723
            if ($_.i == $_.msglen) { //#6641
                break; //#6641
            } //#6641
            $k[$j++] = $_.i; //#6643
            $_.numsscr(); //#6643
            $_.nums = $k[--$j]; //#6643
            $_.nchars = $k[--$j]; //#6643
            for (;;) { //#6721
                if ((($eq($_.cset, "seta") || $eq($_.cset, "setb")) && ($_.nums >= 4)) && ($get($_.msg, $_.i) != $_.fn1)) { //#6660
                    if (($_.nums % 2) == 0) { //#6658
                        $k[$j++] = $_.swc; //#6650
                        if ($eq($_.cset, "seta")) { //#6650
                            $_.enca(); //#6650
                        } else { //#6650
                            $_.encb(); //#6650
                        } //#6650
                        $_.cset = "setc"; //#6651
                        break; //#6652
                    } else { //#6658
                        $k[$j++] = $get($_.msg, $_.i); //#6654
                        if ($eq($_.cset, "seta")) { //#6654
                            $_.enca(); //#6654
                        } else { //#6654
                            $_.encb(); //#6654
                        } //#6654
                        $_.i = $_.i + 1; //#6655
                        $k[$j++] = $_.swc; //#6656
                        if ($eq($_.cset, "seta")) { //#6656
                            $_.enca(); //#6656
                        } else { //#6656
                            $_.encb(); //#6656
                        } //#6656
                        $_.cset = "setc"; //#6657
                        break; //#6658
                    } //#6658
                } //#6658
                $k[$j++] = $eq($_.cset, "setb"); //#6661
                $k[$j++] = $get($_.msg, $_.i); //#6661
                $_.anotb(); //#6661
                var _72 = $k[--$j]; //#6661
                var _73 = $k[--$j]; //#6661
                if ((_73 && _72)) { //#6673
                    if ($_.i < ($_.msglen - 1)) { //#6669
                        $k[$j++] = $_.i + 1; //#6663
                        $_.bbeforea(); //#6663
                        if ($k[--$j]) { //#6668
                            $k[$j++] = $_.sft; //#6664
                            $_.encb(); //#6664
                            $k[$j++] = $get($_.msg, $_.i); //#6665
                            $_.enca(); //#6665
                            $_.i = $_.i + 1; //#6666
                            break; //#6667
                        } //#6667
                    } //#6667
                    $k[$j++] = $_.swa; //#6670
                    $_.encb(); //#6670
                    $_.cset = "seta"; //#6671
                    break; //#6672
                } //#6672
                $k[$j++] = $eq($_.cset, "seta"); //#6674
                $k[$j++] = $get($_.msg, $_.i); //#6674
                $_.bnota(); //#6674
                var _7I = $k[--$j]; //#6674
                var _7J = $k[--$j]; //#6674
                if ((_7J && _7I)) { //#6686
                    if ($_.i < ($_.msglen - 1)) { //#6682
                        $k[$j++] = $_.i + 1; //#6676
                        $_.abeforeb(); //#6676
                        if ($k[--$j]) { //#6681
                            $k[$j++] = $_.sft; //#6677
                            $_.enca(); //#6677
                            $k[$j++] = $get($_.msg, $_.i); //#6678
                            $_.encb(); //#6678
                            $_.i = $_.i + 1; //#6679
                            break; //#6680
                        } //#6680
                    } //#6680
                    $k[$j++] = $_.swb; //#6683
                    $_.enca(); //#6683
                    $_.cset = "setb"; //#6684
                    break; //#6685
                } //#6685
                if (($eq($_.cset, "setc") && ($_.nums < 2)) && (($get($_.msg, $_.i) > -1) || ($get($_.msg, $_.i) == $_.fn4))) { //#6696
                    $k[$j++] = $_.i; //#6688
                    $_.abeforeb(); //#6688
                    if ($k[--$j]) { //#6692
                        $k[$j++] = $_.swa; //#6689
                        $_.encc(); //#6689
                        $_.cset = "seta"; //#6690
                        break; //#6691
                    } //#6691
                    $k[$j++] = $_.swb; //#6693
                    $_.encc(); //#6693
                    $_.cset = "setb"; //#6694
                    break; //#6695
                } //#6695
                if ($eq($_.cset, "seta")) { //#6703
                    $k[$j++] = $get($_.msg, $_.i); //#6700
                    $_.enca(); //#6700
                    $_.i = $_.i + 1; //#6701
                    break; //#6702
                } //#6702
                if ($eq($_.cset, "setb")) { //#6708
                    $k[$j++] = $get($_.msg, $_.i); //#6705
                    $_.encb(); //#6705
                    $_.i = $_.i + 1; //#6706
                    break; //#6707
                } //#6707
                if ($eq($_.cset, "setc")) { //#6718
                    if ($get($_.msg, $_.i) <= -1) { //#6715
                        $k[$j++] = $get($_.msg, $_.i); //#6711
                        $_.encc(); //#6711
                        $_.i = $_.i + 1; //#6712
                    } else { //#6715
                        $k[$j++] = $geti($_.msg, $_.i, 2); //#6714
                        $_.encc(); //#6714
                        $_.i = $_.i + 2; //#6715
                    } //#6715
                    break; //#6717
                } //#6717
                break; //#6720
            } //#6720
        } //#6720
        $_.cws = $geti($_.cws, 0, $_.j); //#6724
    } //#6724
    var _87 = $a($_.j + 2); //#6728
    $puti(_87, 0, $_.cws); //#6728
    $_.cws = _87; //#6728
    $_.csum = $get($_.cws, 0); //#6729
    for (var _8D = 1, _8C = $_.j - 1; _8D <= _8C; _8D += 1) { //#6733
        $_.i = _8D; //#6731
        $_.csum = $f($_.csum + ($get($_.cws, $_.i) * $_.i)); //#6732
    } //#6732
    $_.csum = $_.csum % 103; //#6734
    $put($_.cws, $_.j, $_.csum); //#6735
    $put($_.cws, $_.j + 1, $get($_.seta, $_.stp)); //#6736
    var _8T = $get($_.options, 'debugcws') !== undefined; //#6738
    if (_8T) { //#6738
        $k[$j++] = 'bwipp.debugcws#6738'; //#6738
        $k[$j++] = $_.cws; //#6738
        bwipp_raiseerror(); //#6738
    } //#6738
    if (!bwipp_code128.__6760__) { //#6760
        $_ = Object.create($_); //#6760
        $_.encs = $a(["212222", "222122", "222221", "121223", "121322", "131222", "122213", "122312", "132212", "221213", "221312", "231212", "112232", "122132", "122231", "113222", "123122", "123221", "223211", "221132", "221231", "213212", "223112", "312131", "311222", "321122", "321221", "312212", "322112", "322211", "212123", "212321", "232121", "111323", "131123", "131321", "112313", "132113", "132311", "211313", "231113", "231311", "112133", "112331", "132131", "113123", "113321", "133121", "313121", "211331", "231131", "213113", "213311", "213131", "311123", "311321", "331121", "312113", "312311", "332111", "314111", "221411", "431111", "111224", "111422", "121124", "121421", "141122", "141221", "112214", "112412", "122114", "122411", "142112", "142211", "241211", "221114", "413111", "241112", "134111", "111242", "121142", "121241", "114212", "124112", "124211", "411212", "421112", "421211", "212141", "214121", "412121", "111143", "111341", "131141", "114113", "114311", "411113", "411311", "113141", "114131", "311141", "411131", "211412", "211214", "211232", "2331112"]); //#6759
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_code128.$ctx[id] = $_[id]); //#6759
        bwipp_code128.__6760__ = 1; //#6759
        $_ = Object.getPrototypeOf($_); //#6759
    } //#6759
    $_.sbs = $s(($_.cws.length * 6) + 1); //#6763
    for (var _8b = 0, _8a = $_.cws.length - 1; _8b <= _8a; _8b += 1) { //#6767
        $_.i = _8b; //#6765
        $puti($_.sbs, $_.i * 6, $get($_.encs, $get($_.cws, $_.i))); //#6766
    } //#6766
    $k[$j++] = Infinity; //#6770
    $k[$j++] = Infinity; //#6772
    var _8j = $_.sbs; //#6772
    for (var _8k = 0, _8l = _8j.length; _8k < _8l; _8k++) { //#6772
        $k[$j++] = $get(_8j, _8k) - 48; //#6772
    } //#6772
    var _8n = $a(); //#6772
    $k[$j++] = Infinity; //#6773
    for (var _8p = 0, _8q = ~~(($_.sbs.length + 1) / 2); _8p < _8q; _8p++) { //#6773
        $k[$j++] = $_.height; //#6773
    } //#6773
    var _8s = $a(); //#6773
    $k[$j++] = Infinity; //#6774
    for (var _8u = 0, _8v = ~~(($_.sbs.length + 1) / 2); _8u < _8v; _8u++) { //#6774
        $k[$j++] = 0; //#6774
    } //#6774
    var _8w = $a(); //#6774
    $k[$j++] = 'ren'; //#6777
    $k[$j++] = 'renlinear'; //#6777
    $k[$j++] = 'sbs'; //#6777
    $k[$j++] = _8n; //#6777
    $k[$j++] = 'bhs'; //#6777
    $k[$j++] = _8s; //#6777
    $k[$j++] = 'bbs'; //#6777
    $k[$j++] = _8w; //#6777
    $k[$j++] = 'txt'; //#6777
    $k[$j++] = $a([$a([$_.text, $_.textxoffset, $_.textyoffset, $_.textfont, $_.textsize])]); //#6777
    $k[$j++] = 'textxalign'; //#6777
    $k[$j++] = "center"; //#6777
    $k[$j++] = 'opt'; //#6777
    $k[$j++] = $_.options; //#6777
    var _95 = $d(); //#6777
    $k[$j++] = _95; //#6780
    if (!$_.dontdraw) { //#6780
        bwipp_renlinear(); //#6780
    } //#6780
    $_ = Object.getPrototypeOf($_); //#6782
    $_ = Object.getPrototypeOf($_); //#6784
} //bwipp_code128
function bwipp_gs1_128() {
    $_ = Object.create($_); //#6815
    $_.dontdraw = false; //#6818
    $_.includetext = false; //#6819
    $_.textfont = "OCR-B"; //#6820
    $_.textsize = 10; //#6821
    $_.textxoffset = 0; //#6822
    $_.textyoffset = -8; //#6823
    $_.height = 0.5; //#6824
    $_.linkagea = false; //#6825
    $_.linkagec = false; //#6826
    $_.parse = false; //#6827
    $_.dontlint = false; //#6828
    $_.lintreqs = false; //#6829
    $k[$j++] = $_; //#6831
    bwipp_processoptions(); //#6831
    $_.options = $k[--$j]; //#6831
    $_.barcode = $k[--$j]; //#6832
    if ($_.linkagea && $_.linkagec) { //#6836
        $k[$j++] = 'bwipp.gs1128badLinkage#6835'; //#6835
        $k[$j++] = "linkagea and linkagec cannot be used together"; //#6835
        bwipp_raiseerror(); //#6835
    } //#6835
    $_.text = $_.barcode; //#6838
    $k[$j++] = $_.barcode; //#6840
    $k[$j++] = 'ai'; //#6840
    bwipp_gs1process(); //#6840
    $_.fncs = $k[--$j]; //#6841
    $_.vals = $k[--$j]; //#6842
    $_.ais = $k[--$j]; //#6843
    $_.fnc1 = -1; //#6846
    $_.c128 = $a([$_.fnc1]); //#6847
    for (var _D = 0, _C = $_.ais.length - 1; _D <= _C; _D += 1) { //#6863
        $_.i = _D; //#6849
        $_.ai = $get($_.ais, $_.i); //#6850
        $_.val = $get($_.vals, $_.i); //#6851
        var _N = $a(($_.c128.length + $_.ai.length) + $_.val.length); //#6852
        $puti(_N, 0, $_.c128); //#6853
        $k[$j++] = _N; //#6854
        $k[$j++] = _N; //#6854
        $k[$j++] = $_.c128.length; //#6854
        $k[$j++] = $_.ai; //#6854
        $k[$j++] = Infinity; //#6854
        var _R = $k[--$j]; //#6854
        var _S = $k[--$j]; //#6854
        $k[$j++] = _R; //#6854
        $forall(_S); //#6854
        var _T = $a(); //#6854
        var _U = $k[--$j]; //#6854
        $puti($k[--$j], _U, _T); //#6854
        var _W = $k[--$j]; //#6855
        $k[$j++] = _W; //#6855
        $k[$j++] = _W; //#6855
        $k[$j++] = $_.c128.length + $_.ai.length; //#6855
        $k[$j++] = $_.val; //#6855
        $k[$j++] = Infinity; //#6855
        var _a = $k[--$j]; //#6855
        var _b = $k[--$j]; //#6855
        $k[$j++] = _a; //#6855
        $forall(_b); //#6855
        var _c = $a(); //#6855
        var _d = $k[--$j]; //#6855
        $puti($k[--$j], _d, _c); //#6855
        $_.c128 = $k[--$j]; //#6856
        if (($_.i != ($_.ais.length - 1)) && $get($_.fncs, $_.i)) { //#6862
            var _m = $a($_.c128.length + 1); //#6858
            $puti(_m, 0, $_.c128); //#6859
            $put(_m, $_.c128.length, $_.fnc1); //#6860
            $_.c128 = _m; //#6861
        } //#6861
    } //#6861
    $_.barcode = $s(($_.c128.length + 1) * 5); //#6866
    $_.i = 0; //#6867
    $_.j = 0; //#6867
    for (;;) { //#6877
        if ($_.i == $_.c128.length) { //#6868
            break; //#6868
        } //#6868
        var _w = $get($_.c128, $_.i); //#6869
        $k[$j++] = _w; //#6874
        if (_w == $_.fnc1) { //#6873
            $j--; //#6870
            $puti($_.barcode, $_.j, "^FNC1"); //#6870
            $_.j = $_.j + 4; //#6871
        } else { //#6873
            $put($_.barcode, $_.j, $k[--$j]); //#6873
        } //#6873
        $_.i = $_.i + 1; //#6875
        $_.j = $_.j + 1; //#6876
    } //#6876
    if ($_.linkagea || $_.linkagec) { //#6881
        $k[$j++] = $_.barcode; //#6879
        $k[$j++] = $_.j; //#6879
        if ($_.linkagea) { //#6879
            $k[$j++] = "^LNKA"; //#6879
        } else { //#6879
            $k[$j++] = "^LNKC"; //#6879
        } //#6879
        var _1B = $k[--$j]; //#6879
        var _1C = $k[--$j]; //#6879
        $puti($k[--$j], _1C, _1B); //#6879
        $_.j = $_.j + 5; //#6880
    } //#6880
    $_.barcode = $geti($_.barcode, 0, $_.j); //#6882
    delete $_.options["parse"]; //#6885
    $put($_.options, "height", $_.height); //#6886
    $put($_.options, "dontdraw", true); //#6887
    $put($_.options, "parsefnc", true); //#6888
    $k[$j++] = 'args'; //#6889
    $k[$j++] = $_.barcode; //#6889
    $k[$j++] = $_.options; //#6889
    bwipp_code128(); //#6889
    var _1P = $k[--$j]; //#6889
    $_[$k[--$j]] = _1P; //#6889
    $put($_.args, "txt", $a([$a([$_.text, $_.textxoffset, $_.textyoffset, $_.textfont, $_.textsize])])); //#6891
    $put($_.args, "textxalign", "center"); //#6892
    $put($_.args, "opt", $_.options); //#6893
    $k[$j++] = $_.args; //#6896
    if (!$_.dontdraw) { //#6896
        bwipp_renlinear(); //#6896
    } //#6896
    $_ = Object.getPrototypeOf($_); //#6898
} //bwipp_gs1_128
function bwipp_ean14() {
    $_ = Object.create($_); //#6927
    $_.dontdraw = false; //#6930
    $_.includetext = false; //#6931
    $_.textfont = "OCR-B"; //#6932
    $_.textsize = 10; //#6933
    $_.textxoffset = 0; //#6934
    $_.textyoffset = -8; //#6935
    $_.height = 1; //#6936
    $k[$j++] = $_; //#6938
    bwipp_processoptions(); //#6938
    $_.options = $k[--$j]; //#6938
    $_.barcode = $k[--$j]; //#6939
    $_.text = $_.barcode; //#6942
    var _3 = $_.barcode; //#6943
    $k[$j++] = $s(_3.length); //#6944
    $k[$j++] = 0; //#6944
    $forall(_3, function() { //#6944
        var _5 = $k[--$j]; //#6944
        $k[$j++] = _5; //#6944
        if (_5 != 32) { //#6944
            var _6 = $k[--$j]; //#6944
            var _7 = $k[--$j]; //#6944
            var _8 = $k[--$j]; //#6944
            $put(_8, _7, _6); //#6944
            $k[$j++] = _8; //#6944
            $k[$j++] = $f(_7 + 1); //#6944
        } else { //#6944
            $j--; //#6944
        } //#6944
    }); //#6944
    var _9 = $k[--$j]; //#6945
    $_.barcode = $geti($k[--$j], 0, _9); //#6945
    $_.hasspace = $_.text.length != $_.barcode.length; //#6946
    if (($_.barcode.length != 17) && ($_.barcode.length != 18)) { //#6951
        $k[$j++] = 'bwipp.ean14badLength#6950'; //#6950
        $k[$j++] = "GS1-14 must be 13 or 14 digits"; //#6950
        bwipp_raiseerror(); //#6950
    } //#6950
    if ($ne($geti($_.barcode, 0, 4), "(01)")) { //#6954
        $k[$j++] = 'bwipp.ean14badAI#6953'; //#6953
        $k[$j++] = "GS1-14 must begin with (01) application identifier"; //#6953
        bwipp_raiseerror(); //#6953
    } //#6953
    var _K = $geti($_.barcode, 4, $_.barcode.length - 4); //#6955
    for (var _L = 0, _M = _K.length; _L < _M; _L++) { //#6959
        var _N = $get(_K, _L); //#6959
        if ((_N < 48) || (_N > 57)) { //#6958
            $k[$j++] = 'bwipp.ean14badCharacter#6957'; //#6957
            $k[$j++] = "GS1-14 must contain only digits"; //#6957
            bwipp_raiseerror(); //#6957
        } //#6957
    } //#6957
    $_.checksum = 0; //#6962
    for (var _O = 0; _O <= 12; _O += 1) { //#6966
        $_.i = _O; //#6964
        $k[$j++] = 'checksum'; //#6965
        $k[$j++] = $_.checksum; //#6965
        $k[$j++] = $f($get($_.barcode, $_.i + 4) - 48); //#6965
        if (($_.i % 2) == 0) { //#6965
            var _U = $k[--$j]; //#6965
            $k[$j++] = _U * 3; //#6965
        } //#6965
        var _V = $k[--$j]; //#6965
        var _W = $k[--$j]; //#6965
        $_[$k[--$j]] = $f(_W + _V); //#6965
    } //#6965
    $_.checksum = (10 - ($_.checksum % 10)) % 10; //#6967
    if ($_.barcode.length == 18) { //#6981
        if ($get($_.barcode, 17) != ($_.checksum + 48)) { //#6971
            $k[$j++] = 'bwipp.ean14badCheckDigit#6970'; //#6970
            $k[$j++] = "Incorrect GS1-14 check digit provided"; //#6970
            bwipp_raiseerror(); //#6970
        } //#6970
    } else { //#6981
        var _d = $s(18); //#6973
        $puti(_d, 0, $_.barcode); //#6974
        $put(_d, 17, $_.checksum + 48); //#6975
        $_.barcode = _d; //#6976
        var _i = $_.hasspace ? 2 : 1; //#6977
        var _j = $s($_.text.length + _i); //#6977
        $puti(_j, _j.length - 2, " "); //#6978
        $put(_j, _j.length - 1, $_.checksum + 48); //#6979
        $puti(_j, 0, $_.text); //#6980
        $_.text = _j; //#6981
    } //#6981
    $_.gtin = $geti($_.barcode, 4, 14); //#6983
    $_.barcode = $s(21); //#6986
    $puti($_.barcode, 0, "^FNC101"); //#6987
    var _r = $_.gtin; //#6988
    $puti($_.barcode, 7, _r); //#6988
    $put($_.options, "dontdraw", true); //#6991
    $put($_.options, "parsefnc", true); //#6992
    $k[$j++] = 'args'; //#6993
    $k[$j++] = $_.barcode; //#6993
    $k[$j++] = $_.options; //#6993
    bwipp_code128(); //#6993
    var _w = $k[--$j]; //#6993
    $_[$k[--$j]] = _w; //#6993
    $put($_.args, "txt", $a([$a([$_.text, $_.textxoffset, $_.textyoffset, $_.textfont, $_.textsize])])); //#6995
    $put($_.args, "textxalign", "center"); //#6996
    $put($_.args, "opt", $_.options); //#6997
    $k[$j++] = $_.args; //#7000
    if (!$_.dontdraw) { //#7000
        bwipp_renlinear(); //#7000
    } //#7000
    $_ = Object.getPrototypeOf($_); //#7002
} //bwipp_ean14
function bwipp_sscc18() {
    $_ = Object.create($_); //#7031
    $_.dontdraw = false; //#7034
    $_.includetext = false; //#7035
    $_.textfont = "OCR-B"; //#7036
    $_.textsize = 10; //#7037
    $_.textxoffset = 0; //#7038
    $_.textyoffset = -8; //#7039
    $_.height = 1; //#7040
    $k[$j++] = $_; //#7042
    bwipp_processoptions(); //#7042
    $_.options = $k[--$j]; //#7042
    $_.barcode = $k[--$j]; //#7043
    $_.text = $_.barcode; //#7046
    var _3 = $_.barcode; //#7047
    $k[$j++] = $s(_3.length); //#7048
    $k[$j++] = 0; //#7048
    $forall(_3, function() { //#7048
        var _5 = $k[--$j]; //#7048
        $k[$j++] = _5; //#7048
        if (_5 != 32) { //#7048
            var _6 = $k[--$j]; //#7048
            var _7 = $k[--$j]; //#7048
            var _8 = $k[--$j]; //#7048
            $put(_8, _7, _6); //#7048
            $k[$j++] = _8; //#7048
            $k[$j++] = $f(_7 + 1); //#7048
        } else { //#7048
            $j--; //#7048
        } //#7048
    }); //#7048
    var _9 = $k[--$j]; //#7049
    $_.barcode = $geti($k[--$j], 0, _9); //#7049
    $_.hasspace = $_.text.length != $_.barcode.length; //#7050
    if (($_.barcode.length != 21) && ($_.barcode.length != 22)) { //#7055
        $k[$j++] = 'bwipp.sscc18badLength#7054'; //#7054
        $k[$j++] = "SSCC-18 must be 17 or 18 digits"; //#7054
        bwipp_raiseerror(); //#7054
    } //#7054
    if ($ne($geti($_.barcode, 0, 4), "(00)")) { //#7058
        $k[$j++] = 'bwipp.sscc18badAI#7057'; //#7057
        $k[$j++] = "SSCC-18 must begin with (00) application identifier"; //#7057
        bwipp_raiseerror(); //#7057
    } //#7057
    var _K = $geti($_.barcode, 4, $_.barcode.length - 4); //#7059
    for (var _L = 0, _M = _K.length; _L < _M; _L++) { //#7063
        var _N = $get(_K, _L); //#7063
        if ((_N < 48) || (_N > 57)) { //#7062
            $k[$j++] = 'bwipp.sscc18badCharacter#7061'; //#7061
            $k[$j++] = "SSCC-18 must contain only digits"; //#7061
            bwipp_raiseerror(); //#7061
        } //#7061
    } //#7061
    $_.checksum = 0; //#7066
    for (var _O = 0; _O <= 16; _O += 1) { //#7070
        $_.i = _O; //#7068
        $k[$j++] = 'checksum'; //#7069
        $k[$j++] = $_.checksum; //#7069
        $k[$j++] = $f($get($_.barcode, $_.i + 4) - 48); //#7069
        if (($_.i % 2) == 0) { //#7069
            var _U = $k[--$j]; //#7069
            $k[$j++] = _U * 3; //#7069
        } //#7069
        var _V = $k[--$j]; //#7069
        var _W = $k[--$j]; //#7069
        $_[$k[--$j]] = $f(_W + _V); //#7069
    } //#7069
    $_.checksum = (10 - ($_.checksum % 10)) % 10; //#7071
    if ($_.barcode.length == 22) { //#7085
        if ($get($_.barcode, 21) != ($_.checksum + 48)) { //#7075
            $k[$j++] = 'bwipp.sscc18badCheckDigit#7074'; //#7074
            $k[$j++] = "Incorrect SSCC-18 check digit provided"; //#7074
            bwipp_raiseerror(); //#7074
        } //#7074
    } else { //#7085
        var _d = $s(22); //#7077
        $puti(_d, 0, $_.barcode); //#7078
        $put(_d, 21, $_.checksum + 48); //#7079
        $_.barcode = _d; //#7080
        var _i = $_.hasspace ? 2 : 1; //#7081
        var _j = $s($_.text.length + _i); //#7081
        $puti(_j, _j.length - 2, " "); //#7082
        $put(_j, _j.length - 1, $_.checksum + 48); //#7083
        $puti(_j, 0, $_.text); //#7084
        $_.text = _j; //#7085
    } //#7085
    $_.sscc = $geti($_.barcode, 4, 18); //#7087
    $_.barcode = $s(25); //#7090
    $puti($_.barcode, 0, "^FNC100"); //#7091
    var _r = $_.sscc; //#7092
    $puti($_.barcode, 7, _r); //#7092
    $put($_.options, "dontdraw", true); //#7095
    $put($_.options, "parsefnc", true); //#7096
    $k[$j++] = 'args'; //#7097
    $k[$j++] = $_.barcode; //#7097
    $k[$j++] = $_.options; //#7097
    bwipp_code128(); //#7097
    var _w = $k[--$j]; //#7097
    $_[$k[--$j]] = _w; //#7097
    $put($_.args, "txt", $a([$a([$_.text, $_.textxoffset, $_.textyoffset, $_.textfont, $_.textsize])])); //#7099
    $put($_.args, "textxalign", "center"); //#7100
    $put($_.args, "opt", $_.options); //#7101
    $k[$j++] = $_.args; //#7104
    if (!$_.dontdraw) { //#7104
        bwipp_renlinear(); //#7104
    } //#7104
    $_ = Object.getPrototypeOf($_); //#7106
} //bwipp_sscc18
function bwipp_code39() {
    $_ = Object.create($_); //#7136
    $_.dontdraw = false; //#7139
    $_.includecheck = false; //#7140
    $_.validatecheck = false; //#7141
    $_.includetext = false; //#7142
    $_.includecheckintext = false; //#7143
    $_.hidestars = false; //#7144
    $_.textfont = "OCR-B"; //#7145
    $_.textsize = 10; //#7146
    $_.textyoffset = -8; //#7147
    $_.height = 1; //#7148
    $k[$j++] = $_; //#7150
    bwipp_processoptions(); //#7150
    $_.options = $k[--$j]; //#7150
    $_.barcode = $k[--$j]; //#7151
    if ($eq($_.barcode, "")) { //#7155
        $k[$j++] = 'bwipp.code39emptyData#7154'; //#7154
        $k[$j++] = "The data must not be empty"; //#7154
        bwipp_raiseerror(); //#7154
    } //#7154
    bwipp_loadctx(bwipp_code39) //#7157
    if (!bwipp_code39.__7177__) { //#7177
        $_ = Object.create($_); //#7177
        $_.encs = $a(["1113313111", "3113111131", "1133111131", "3133111111", "1113311131", "3113311111", "1133311111", "1113113131", "3113113111", "1133113111", "3111131131", "1131131131", "3131131111", "1111331131", "3111331111", "1131331111", "1111133131", "3111133111", "1131133111", "1111333111", "3111111331", "1131111331", "3131111311", "1111311331", "3111311311", "1131311311", "1111113331", "3111113311", "1131113311", "1111313311", "3311111131", "1331111131", "3331111111", "1311311131", "3311311111", "1331311111", "1311113131", "3311113111", "1331113111", "1313131111", "1313111311", "1311131311", "1113131311", "1311313111"]); //#7171
        $_.barchars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%"; //#7174
        $_.charvals = new Map; //#7175
        for (var _4 = 0; _4 <= 42; _4 += 1) { //#7176
            $put($_.charvals, $geti($_.barchars, _4, 1), _4); //#7176
        } //#7176
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_code39.$ctx[id] = $_[id]); //#7176
        bwipp_code39.__7177__ = 1; //#7176
        $_ = Object.getPrototypeOf($_); //#7176
    } //#7176
    for (var _B = 0, _A = $_.barcode.length - 1; _B <= _A; _B += 1) { //#7184
        var _F = $get($_.charvals, $geti($_.barcode, _B, 1)) !== undefined; //#7181
        if (!_F) { //#7183
            $k[$j++] = 'bwipp.code39badCharacter#7182'; //#7182
            $k[$j++] = "Code 39 must contain only digits, capital letters, spaces and the symbols -.$/+%"; //#7182
            bwipp_raiseerror(); //#7182
        } //#7182
    } //#7182
    $k[$j++] = 'barlen'; //#7186
    $k[$j++] = $_.barcode.length; //#7186
    if ($_.validatecheck) { //#7186
        var _I = $k[--$j]; //#7186
        $k[$j++] = $f(_I - 1); //#7186
    } //#7186
    var _J = $k[--$j]; //#7186
    $_[$k[--$j]] = _J; //#7186
    $_.checksum = 0; //#7188
    for (var _N = 0, _M = $f($_.barlen - 1); _N <= _M; _N += 1) { //#7192
        $_.checksum = $f($get($_.charvals, $geti($_.barcode, _N, 1)) + $_.checksum); //#7191
    } //#7191
    $_.checksum = $_.checksum % 43; //#7193
    if ($_.validatecheck) { //#7200
        if ($get($_.barcode, $_.barlen) != $get($_.barchars, $_.checksum)) { //#7197
            $k[$j++] = 'bwipp.code39badCheckDigit#7196'; //#7196
            $k[$j++] = "Incorrect Code 39 check digit provided"; //#7196
            bwipp_raiseerror(); //#7196
        } //#7196
        $_.barcode = $geti($_.barcode, 0, $_.barlen); //#7198
        $_.includecheck = true; //#7199
    } //#7199
    var _g = $_.includecheck ? 3 : 2; //#7202
    $_.sbs = $s($f($_.barlen + _g) * 10); //#7202
    var _k = $_.includecheck ? 3 : 2; //#7203
    $_.txt = $a($f($_.barlen + _k)); //#7203
    $puti($_.sbs, 0, $get($_.encs, 43)); //#7206
    if (!$_.hidestars) { //#7210
        $put($_.txt, 0, $a(["*", 0, $_.textyoffset, $_.textfont, $_.textsize])); //#7208
    } else { //#7210
        $put($_.txt, 0, $a(["", 0, $_.textyoffset, $_.textfont, $_.textsize])); //#7210
    } //#7210
    for (var _12 = 0, _11 = $f($_.barlen - 1); _12 <= _11; _12 += 1) { //#7218
        $_.i = _12; //#7214
        $_.indx = $get($_.charvals, $geti($_.barcode, $_.i, 1)); //#7215
        $puti($_.sbs, ($_.i * 10) + 10, $get($_.encs, $_.indx)); //#7216
        $put($_.txt, $_.i + 1, $a([$geti($_.barcode, $_.i, 1), ($_.i + 1) * 16, $_.textyoffset, $_.textfont, $_.textsize])); //#7217
    } //#7217
    if ($_.includecheck) { //#7239
        $puti($_.sbs, $f(($_.barlen * 10) + 10), $get($_.encs, $_.checksum)); //#7222
        if ($_.includecheckintext) { //#7226
            $put($_.txt, $f($_.barlen + 1), $a([$geti($_.barchars, $_.checksum, 1), $f($_.barlen + 1) * 16, $_.textyoffset, $_.textfont, $_.textsize])); //#7224
        } else { //#7226
            $put($_.txt, $f($_.barlen + 1), $a(["", $f($_.barlen + 1) * 16, $_.textyoffset, $_.textfont, $_.textsize])); //#7226
        } //#7226
        $puti($_.sbs, $f(($_.barlen * 10) + 20), $get($_.encs, 43)); //#7228
        if (!$_.hidestars) { //#7232
            $put($_.txt, $f($_.barlen + 2), $a(["*", $f($_.barlen + 2) * 16, $_.textyoffset, $_.textfont, $_.textsize])); //#7230
        } else { //#7232
            $put($_.txt, $f($_.barlen + 2), $a(["", $f($_.barlen + 2) * 16, $_.textyoffset, $_.textfont, $_.textsize])); //#7232
        } //#7232
    } else { //#7239
        $puti($_.sbs, $f(($_.barlen * 10) + 10), $get($_.encs, 43)); //#7235
        if (!$_.hidestars) { //#7239
            $put($_.txt, $f($_.barlen + 1), $a(["*", $f($_.barlen + 1) * 16, $_.textyoffset, $_.textfont, $_.textsize])); //#7237
        } else { //#7239
            $put($_.txt, $f($_.barlen + 1), $a(["", $f($_.barlen + 1) * 16, $_.textyoffset, $_.textfont, $_.textsize])); //#7239
        } //#7239
    } //#7239
    $k[$j++] = Infinity; //#7244
    $k[$j++] = Infinity; //#7246
    var _2N = $_.sbs; //#7246
    for (var _2O = 0, _2P = _2N.length; _2O < _2P; _2O++) { //#7246
        $k[$j++] = $get(_2N, _2O) - 48; //#7246
    } //#7246
    var _2R = $a(); //#7246
    $k[$j++] = Infinity; //#7247
    for (var _2T = 0, _2U = ~~(($_.sbs.length + 1) / 2); _2T < _2U; _2T++) { //#7247
        $k[$j++] = $_.height; //#7247
    } //#7247
    var _2W = $a(); //#7247
    $k[$j++] = Infinity; //#7248
    for (var _2Y = 0, _2Z = ~~(($_.sbs.length + 1) / 2); _2Y < _2Z; _2Y++) { //#7248
        $k[$j++] = 0; //#7248
    } //#7248
    var _2a = $a(); //#7248
    $k[$j++] = 'ren'; //#7251
    $k[$j++] = 'renlinear'; //#7251
    $k[$j++] = 'sbs'; //#7251
    $k[$j++] = _2R; //#7251
    $k[$j++] = 'bhs'; //#7251
    $k[$j++] = _2W; //#7251
    $k[$j++] = 'bbs'; //#7251
    $k[$j++] = _2a; //#7251
    if ($_.includetext) { //#7251
        $k[$j++] = 'txt'; //#7250
        $k[$j++] = $_.txt; //#7250
    } //#7250
    $k[$j++] = 'opt'; //#7252
    $k[$j++] = $_.options; //#7252
    var _2e = $d(); //#7252
    $k[$j++] = _2e; //#7255
    if (!$_.dontdraw) { //#7255
        bwipp_renlinear(); //#7255
    } //#7255
    $_ = Object.getPrototypeOf($_); //#7257
    $_ = Object.getPrototypeOf($_); //#7259
} //bwipp_code39
function bwipp_code39ext() {
    $_ = Object.create($_); //#7291
    $_.dontdraw = false; //#7294
    $_.includetext = false; //#7295
    $_.parse = false; //#7296
    $k[$j++] = $_; //#7298
    bwipp_processoptions(); //#7298
    $_.options = $k[--$j]; //#7298
    $_.barcode = $k[--$j]; //#7299
    bwipp_loadctx(bwipp_code39ext) //#7301
    var _3 = new Map([
        ["parse", $_.parse],
        ["parseonly", true],
        ["parsefnc", false]
    ]); //#7307
    $_.fncvals = _3; //#7308
    $k[$j++] = 'barcode'; //#7309
    $k[$j++] = $_.barcode; //#7309
    $k[$j++] = $_.fncvals; //#7309
    bwipp_parseinput(); //#7309
    var _6 = $k[--$j]; //#7309
    $_[$k[--$j]] = _6; //#7309
    $_.barlen = $_.barcode.length; //#7310
    delete $_.options["parse"]; //#7311
    $forall($_.barcode, function() { //#7318
        if ($k[--$j] >= 128) { //#7317
            $k[$j++] = 'bwipp.code39extBadCharacter#7316'; //#7316
            $k[$j++] = "Code 39 Extended must contain only ASCII characters"; //#7316
            bwipp_raiseerror(); //#7316
        } //#7316
    }); //#7316
    if (!bwipp_code39ext.__7332__) { //#7332
        $_ = Object.create($_); //#7332
        $_.extencs = $a(["%U", "$A", "$B", "$C", "$D", "$E", "$F", "$G", "$H", "$I", "$J", "$K", "$L", "$M", "$N", "$O", "$P", "$Q", "$R", "$S", "$T", "$U", "$V", "$W", "$X", "$Y", "$Z", "%A", "%B", "%C", "%D", "%E", " ", "/A", "/B", "/C", "/D", "/E", "/F", "/G", "/H", "/I", "/J", "/K", "/L", "-", ".", "/O", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "/Z", "%F", "%G", "%H", "%I", "%J", "%V", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "%K", "%L", "%M", "%N", "%O", "%W", "+A", "+B", "+C", "+D", "+E", "+F", "+G", "+H", "+I", "+J", "+K", "+L", "+M", "+N", "+O", "+P", "+Q", "+R", "+S", "+T", "+U", "+V", "+W", "+X", "+Y", "+Z", "%P", "%Q", "%R", "%S", "%T"]); //#7331
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_code39ext.$ctx[id] = $_[id]); //#7331
        bwipp_code39ext.__7332__ = 1; //#7331
        $_ = Object.getPrototypeOf($_); //#7331
    } //#7331
    $_.newcode = $s($_.barlen * 2); //#7334
    $_.newtext = $s($_.barlen * 2); //#7335
    $_.j = 0; //#7336
    for (var _K = 0, _J = $_.barlen - 1; _K <= _J; _K += 1) { //#7344
        $_.i = _K; //#7338
        $_.extchar = $get($_.extencs, $get($_.barcode, $_.i)); //#7339
        $puti($_.newcode, $_.j, $_.extchar); //#7340
        var _X = $get($_.barcode, $_.i); //#7341
        $k[$j++] = $_.newtext; //#7341
        $k[$j++] = $_.j; //#7341
        $k[$j++] = _X; //#7341
        if ((_X < 32) || (_X == 127)) { //#7341
            $j--; //#7341
            $k[$j++] = 32; //#7341
        } //#7341
        var _Y = $k[--$j]; //#7341
        var _Z = $k[--$j]; //#7341
        $put($k[--$j], _Z, _Y); //#7341
        if ($_.extchar.length != 1) { //#7342
            $put($_.newtext, $_.j + 1, 32); //#7342
        } //#7342
        $_.j = $_.j + $_.extchar.length; //#7343
    } //#7343
    $_.newcode = $geti($_.newcode, 0, $_.j); //#7345
    $_.newtext = $geti($_.newtext, 0, $_.j); //#7346
    $put($_.options, "dontdraw", true); //#7349
    $k[$j++] = 'args'; //#7350
    $k[$j++] = $_.newcode; //#7350
    $k[$j++] = $_.options; //#7350
    bwipp_code39(); //#7350
    var _p = $k[--$j]; //#7350
    $_[$k[--$j]] = _p; //#7350
    if ($_.includetext) { //#7362
        $_.txt = $get($_.args, "txt"); //#7354
        for (var _w = 0, _v = $_.newtext.length - 1; _w <= _v; _w += 1) { //#7360
            $_.i = _w; //#7356
            $_.txtentry = $get($_.txt, $_.i + 1); //#7357
            $put($_.txtentry, 0, $geti($_.newtext, $_.i, 1)); //#7358
            $put($_.txt, $_.i + 1, $_.txtentry); //#7359
        } //#7359
        $put($_.args, "txt", $_.txt); //#7361
    } //#7361
    $put($_.args, "opt", $_.options); //#7363
    $k[$j++] = $_.args; //#7366
    if (!$_.dontdraw) { //#7366
        bwipp_renlinear(); //#7366
    } //#7366
    $_ = Object.getPrototypeOf($_); //#7368
    $_ = Object.getPrototypeOf($_); //#7370
} //bwipp_code39ext
function bwipp_code32() {
    $_ = Object.create($_); //#7399
    $_.dontdraw = false; //#7402
    $_.includetext = false; //#7403
    $_.textfont = "OCR-B"; //#7404
    $_.textsize = 10; //#7405
    $_.textyoffset = -8; //#7406
    $_.textxoffset = 0; //#7407
    $_.height = 1; //#7408
    $k[$j++] = $_; //#7410
    bwipp_processoptions(); //#7410
    $_.options = $k[--$j]; //#7410
    $_.barcode = $k[--$j]; //#7411
    if (($_.barcode.length != 8) && ($_.barcode.length != 9)) { //#7416
        $k[$j++] = 'bwipp.code32badLength#7415'; //#7415
        $k[$j++] = "Italian Pharmacode must be 8 or 9 digits"; //#7415
        bwipp_raiseerror(); //#7415
    } //#7415
    $forall($_.barcode, function() { //#7421
        var _5 = $k[--$j]; //#7418
        if ((_5 < 48) || (_5 > 57)) { //#7420
            $k[$j++] = 'bwipp.code32badCharacter#7419'; //#7419
            $k[$j++] = "Italian Pharmacode must contain only digits"; //#7419
            bwipp_raiseerror(); //#7419
        } //#7419
    }); //#7419
    $_.checksum = 0; //#7424
    for (var _6 = 0; _6 <= 7; _6 += 1) { //#7429
        $_.i = _6; //#7426
        $k[$j++] = $f($get($_.barcode, $_.i) - 48); //#7427
        if (($_.i % 2) != 0) { //#7427
            var _B = $k[--$j]; //#7427
            $k[$j++] = _B * 2; //#7427
        } //#7427
        var _C = $k[--$j]; //#7427
        $k[$j++] = _C; //#7427
        if (_C > 9) { //#7427
            var _D = $k[--$j]; //#7427
            $k[$j++] = $f(_D - 9); //#7427
        } //#7427
        $_.checksum = $f($k[--$j] + $_.checksum); //#7428
    } //#7428
    $_.checksum = $_.checksum % 10; //#7430
    if ($_.barcode.length == 9) { //#7435
        if ($get($_.barcode, 8) != $f($_.checksum + 48)) { //#7434
            $k[$j++] = 'bwipp.code32badCheckDigit#7433'; //#7433
            $k[$j++] = "Incorrect Italian Pharmacode check digit provided"; //#7433
            bwipp_raiseerror(); //#7433
        } //#7433
    } //#7433
    var _L = $s(10); //#7436
    $puti(_L, 0, $_.barcode); //#7437
    $put(_L, 8, $f($_.checksum + 48)); //#7438
    $_.text = _L; //#7439
    $_.val = $cvrs($s(6), $cvi($_.text), 32); //#7442
    $_.barcode = $s(6); //#7443
    for (var _S = 0; _S <= 5; _S += 1) { //#7444
        $put($_.barcode, _S, 48); //#7444
    } //#7444
    $puti($_.barcode, 6 - $_.val.length, $_.val); //#7445
    for (var _X = 0; _X <= 5; _X += 1) { //#7452
        var _Z = $get($_.barcode, _X); //#7449
        $k[$j++] = _X; //#7450
        $k[$j++] = _Z; //#7450
        $k[$j++] = _Z; //#7450
        for (var _a = 0, _b = "AEIO".length; _a < _b; _a++) { //#7450
            if ($k[--$j] >= $get("AEIO", _a)) { //#7450
                var _e = $k[--$j]; //#7450
                $k[$j++] = $f(_e + 1); //#7450
            } //#7450
            var _f = $k[--$j]; //#7450
            $k[$j++] = _f; //#7450
            $k[$j++] = _f; //#7450
        } //#7450
        $j--; //#7450
        var _h = $k[--$j]; //#7451
        $put($_.barcode, $k[--$j], _h); //#7451
    } //#7451
    $puti($_.text, 1, $geti($_.text, 0, 9)); //#7455
    $put($_.text, 0, 65); //#7456
    $put($_.options, "dontdraw", true); //#7459
    $k[$j++] = 'args'; //#7460
    $k[$j++] = $_.barcode; //#7460
    $k[$j++] = $_.options; //#7460
    bwipp_code39(); //#7460
    var _q = $k[--$j]; //#7460
    var _r = $k[--$j]; //#7460
    $_[_r] = _q; //#7460
    $put($_.args, "txt", $a([$a([$_.text, $_.textxoffset, $_.textyoffset, $_.textfont, $_.textsize])])); //#7462
    $put($_.args, "textxalign", "center"); //#7463
    $put($_.args, "opt", $_.options); //#7464
    $k[$j++] = $_.args; //#7467
    if (!$_.dontdraw) { //#7467
        bwipp_renlinear(); //#7467
    } //#7467
    $_ = Object.getPrototypeOf($_); //#7469
} //bwipp_code32
function bwipp_pzn() {
    $_ = Object.create($_); //#7498
    $_.dontdraw = false; //#7501
    $_.includetext = false; //#7502
    $_.textfont = "OCR-B"; //#7503
    $_.textsize = 10; //#7504
    $_.textyoffset = -8; //#7505
    $_.textxoffset = 0; //#7506
    $_.height = 1; //#7507
    $_.pzn8 = false; //#7508
    $k[$j++] = $_; //#7510
    bwipp_processoptions(); //#7510
    $_.options = $k[--$j]; //#7510
    $_.barcode = $k[--$j]; //#7511
    if ($_.pzn8) { //#7520
        if (($_.barcode.length != 7) && ($_.barcode.length != 8)) { //#7517
            $k[$j++] = 'bwipp.pzn8badLength#7516'; //#7516
            $k[$j++] = "PZN8 must be 7 or 8 digits"; //#7516
            bwipp_raiseerror(); //#7516
        } //#7516
    } else { //#7520
        if (($_.barcode.length != 6) && ($_.barcode.length != 7)) { //#7521
            $k[$j++] = 'bwipp.pzn7badLength#7520'; //#7520
            $k[$j++] = "PZN7 must be 6 or 7 digits"; //#7520
            bwipp_raiseerror(); //#7520
        } //#7520
    } //#7520
    $forall($_.barcode, function() { //#7527
        var _8 = $k[--$j]; //#7524
        if ((_8 < 48) || (_8 > 57)) { //#7526
            $k[$j++] = 'bwipp.pznBadCharacter#7525'; //#7525
            $k[$j++] = "PZN must contain only digits"; //#7525
            bwipp_raiseerror(); //#7525
        } //#7525
    }); //#7525
    var _A = $_.pzn8 ? 9 : 8; //#7530
    $_.msglen = _A; //#7530
    $_.checksum = 0; //#7531
    for (var _D = 0, _C = $_.msglen - 3; _D <= _C; _D += 1) { //#7536
        $_.i = _D; //#7533
        var _J = $_.pzn8 ? 1 : 2; //#7534
        $_.checksum = $f(($f($get($_.barcode, $_.i) - 48) * ($_.i + _J)) + $_.checksum); //#7535
    } //#7535
    $_.checksum = $_.checksum % 11; //#7537
    if ($_.checksum == 10) { //#7540
        $k[$j++] = 'bwipp.pznBadInputSequence#7539'; //#7539
        $k[$j++] = "Incorrect PZN input sequence provided"; //#7539
        bwipp_raiseerror(); //#7539
    } //#7539
    if ($_.barcode.length == ($_.msglen - 1)) { //#7545
        if ($get($_.barcode, $_.msglen - 2) != $f($_.checksum + 48)) { //#7544
            $k[$j++] = 'bwipp.pznBadCheckDigit#7543'; //#7543
            $k[$j++] = "Incorrect PZN check digit provided"; //#7543
            bwipp_raiseerror(); //#7543
        } //#7543
    } //#7543
    var _U = $s($_.msglen); //#7546
    $put(_U, 0, 45); //#7547
    $puti(_U, 1, $_.barcode); //#7548
    $put(_U, $_.msglen - 1, $f($_.checksum + 48)); //#7549
    $_.msg = _U; //#7550
    $put($_.options, "dontdraw", true); //#7553
    $k[$j++] = 'args'; //#7554
    $k[$j++] = $_.msg; //#7554
    $k[$j++] = $_.options; //#7554
    bwipp_code39(); //#7554
    var _b = $k[--$j]; //#7554
    $_[$k[--$j]] = _b; //#7554
    $_.text = $s($_.msglen + 5); //#7557
    $puti($_.text, 0, "PZN - "); //#7558
    $puti($_.text, 6, $geti($_.msg, 1, $_.msglen - 1)); //#7559
    var _r = $a([$a([$_.text, $_.textxoffset, $_.textyoffset, $_.textfont, $_.textsize])]); //#7561
    $put($_.args, "txt", _r); //#7561
    $put($_.args, "textxalign", "center"); //#7562
    $put($_.args, "opt", $_.options); //#7563
    $k[$j++] = $_.args; //#7566
    if (!$_.dontdraw) { //#7566
        bwipp_renlinear(); //#7566
    } //#7566
    $_ = Object.getPrototypeOf($_); //#7568
} //bwipp_pzn
function bwipp_code93() {
    $_ = Object.create($_); //#7599
    $_.dontdraw = false; //#7602
    $_.includecheck = false; //#7603
    $_.includetext = false; //#7604
    $_.textfont = "OCR-B"; //#7605
    $_.textsize = 10; //#7606
    $_.textyoffset = -8; //#7607
    $_.height = 1; //#7608
    $_.parse = false; //#7609
    $_.parsefnc = false; //#7610
    $k[$j++] = $_; //#7612
    bwipp_processoptions(); //#7612
    $_.options = $k[--$j]; //#7612
    $_.barcode = $k[--$j]; //#7613
    bwipp_loadctx(bwipp_code93) //#7615
    if (!bwipp_code93.__7643__) { //#7643
        $_ = Object.create($_); //#7643
        $_.encs = $a(["131112", "111213", "111312", "111411", "121113", "121212", "121311", "111114", "131211", "141111", "211113", "211212", "211311", "221112", "221211", "231111", "112113", "112212", "112311", "122112", "132111", "111123", "111222", "111321", "121122", "131121", "212112", "212211", "211122", "211221", "221121", "222111", "112122", "112221", "122121", "123111", "121131", "311112", "311211", "321111", "112131", "113121", "211131", "121221", "312111", "311121", "122211", "111141", "1111411"]); //#7629
        $_.barchars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%"; //#7632
        $_.charvals = new Map; //#7633
        for (var _3 = 0; _3 <= 42; _3 += 1) { //#7634
            $put($_.charvals, $get($_.barchars, _3), _3); //#7634
        } //#7634
        $_.sft1 = -1; //#7636
        $_.sft2 = -2; //#7636
        $_.sft3 = -3; //#7636
        $_.sft4 = -4; //#7636
        var _7 = $_.charvals; //#7638
        $put(_7, $_.sft1, 43); //#7638
        $put($_.charvals, $_.sft2, 44); //#7639
        $put($_.charvals, $_.sft3, 45); //#7640
        $put($_.charvals, $_.sft4, 46); //#7641
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_code93.$ctx[id] = $_[id]); //#7641
        bwipp_code93.__7643__ = 1; //#7641
        $_ = Object.getPrototypeOf($_); //#7641
    } //#7641
    var _M = new Map([
        ["parse", $_.parse],
        ["parsefnc", $_.parsefnc],
        ["SFT$", $_.sft1],
        ["SFT%", $_.sft2],
        ["SFT/", $_.sft3],
        ["SFT+", $_.sft4]
    ]); //#7652
    $_.fncvals = _M; //#7653
    $k[$j++] = 'msg'; //#7654
    $k[$j++] = $_.barcode; //#7654
    $k[$j++] = $_.fncvals; //#7654
    bwipp_parseinput(); //#7654
    var _P = $k[--$j]; //#7654
    $_[$k[--$j]] = _P; //#7654
    $_.msglen = $_.msg.length; //#7655
    $forall($_.msg, function() { //#7662
        var _V = $get($_.charvals, $k[--$j]) !== undefined; //#7659
        if (!_V) { //#7661
            $k[$j++] = 'bwipp.code93BadCharacter#7660'; //#7660
            $k[$j++] = "Code 93 must only contain digits, capital letters, spaces, the symbols -.$/+ and shift non-data characters"; //#7660
            bwipp_raiseerror(); //#7660
        } //#7660
    }); //#7660
    if ($_.includecheck) { //#7667
        $_.sbs = $s(($_.msglen * 6) + 25); //#7665
    } else { //#7667
        $_.sbs = $s(($_.msglen * 6) + 13); //#7667
    } //#7667
    $_.txt = $a($_.msglen); //#7669
    $puti($_.sbs, 0, $get($_.encs, 47)); //#7672
    $_.checksum1 = 0; //#7674
    $_.checksum2 = 0; //#7674
    for (var _i = 0, _h = $_.msglen - 1; _i <= _h; _i += 1) { //#7683
        $_.i = _i; //#7676
        $_.indx = $get($_.charvals, $get($_.msg, $_.i)); //#7677
        $puti($_.sbs, ($_.i * 6) + 6, $get($_.encs, $_.indx)); //#7678
        var _v = $get($_.msg, $_.i); //#7679
        $k[$j++] = 'char'; //#7679
        $k[$j++] = _v; //#7679
        if (_v < 0) { //#7679
            $j--; //#7679
            $k[$j++] = " "; //#7679
        } else { //#7679
            var _w = $s(1); //#7679
            $put(_w, 0, $k[--$j]); //#7679
            $k[$j++] = _w; //#7679
        } //#7679
        var _y = $k[--$j]; //#7679
        $_[$k[--$j]] = _y; //#7679
        $put($_.txt, $_.i, $a([$_.char, ($_.i * 9) + 9, $_.textyoffset, $_.textfont, $_.textsize])); //#7680
        $_.checksum1 = $f($_.checksum1 + ((((($_.msglen - $_.i) - 1) % 20) + 1) * $_.indx)); //#7681
        $_.checksum2 = $f($_.checksum2 + (((($_.msglen - $_.i) % 15) + 1) * $_.indx)); //#7682
    } //#7682
    if ($_.includecheck) { //#7695
        $_.checksum1 = $_.checksum1 % 47; //#7687
        $_.checksum2 = $f($_.checksum2 + $_.checksum1) % 47; //#7688
        $puti($_.sbs, ($_.msglen * 6) + 6, $get($_.encs, $_.checksum1)); //#7689
        $puti($_.sbs, ($_.msglen * 6) + 12, $get($_.encs, $_.checksum2)); //#7690
        $puti($_.sbs, ($_.msglen * 6) + 18, $get($_.encs, 48)); //#7692
    } else { //#7695
        $puti($_.sbs, ($_.msglen * 6) + 6, $get($_.encs, 48)); //#7695
    } //#7695
    $k[$j++] = Infinity; //#7699
    $k[$j++] = Infinity; //#7701
    var _1c = $_.sbs; //#7701
    for (var _1d = 0, _1e = _1c.length; _1d < _1e; _1d++) { //#7701
        $k[$j++] = $get(_1c, _1d) - 48; //#7701
    } //#7701
    var _1g = $a(); //#7701
    $k[$j++] = Infinity; //#7702
    for (var _1i = 0, _1j = ~~(($_.sbs.length + 1) / 2); _1i < _1j; _1i++) { //#7702
        $k[$j++] = $_.height; //#7702
    } //#7702
    var _1l = $a(); //#7702
    $k[$j++] = Infinity; //#7703
    for (var _1n = 0, _1o = ~~(($_.sbs.length + 1) / 2); _1n < _1o; _1n++) { //#7703
        $k[$j++] = 0; //#7703
    } //#7703
    var _1p = $a(); //#7703
    $k[$j++] = 'ren'; //#7706
    $k[$j++] = 'renlinear'; //#7706
    $k[$j++] = 'sbs'; //#7706
    $k[$j++] = _1g; //#7706
    $k[$j++] = 'bhs'; //#7706
    $k[$j++] = _1l; //#7706
    $k[$j++] = 'bbs'; //#7706
    $k[$j++] = _1p; //#7706
    if ($_.includetext) { //#7706
        $k[$j++] = 'txt'; //#7705
        $k[$j++] = $_.txt; //#7705
    } //#7705
    $k[$j++] = 'opt'; //#7707
    $k[$j++] = $_.options; //#7707
    var _1t = $d(); //#7707
    $k[$j++] = _1t; //#7710
    if (!$_.dontdraw) { //#7710
        bwipp_renlinear(); //#7710
    } //#7710
    $_ = Object.getPrototypeOf($_); //#7712
    $_ = Object.getPrototypeOf($_); //#7714
} //bwipp_code93
function bwipp_code93ext() {
    $_ = Object.create($_); //#7746
    $_.dontdraw = false; //#7749
    $_.includetext = false; //#7750
    $_.parse = false; //#7751
    $k[$j++] = $_; //#7753
    bwipp_processoptions(); //#7753
    $_.options = $k[--$j]; //#7753
    $_.barcode = $k[--$j]; //#7754
    bwipp_loadctx(bwipp_code93ext) //#7756
    var _3 = new Map([
        ["parse", $_.parse],
        ["parseonly", true],
        ["parsefnc", false]
    ]); //#7762
    $_.fncvals = _3; //#7763
    $k[$j++] = 'barcode'; //#7764
    $k[$j++] = $_.barcode; //#7764
    $k[$j++] = $_.fncvals; //#7764
    bwipp_parseinput(); //#7764
    var _6 = $k[--$j]; //#7764
    var _7 = $k[--$j]; //#7764
    $_[_7] = _6; //#7764
    $_.barlen = $_.barcode.length; //#7765
    delete $_.options["parse"]; //#7766
    if (!bwipp_code93ext.__7788__) { //#7788
        $_ = Object.create($_); //#7788
        $_.extencs = $a(["^SFT%U", "^SFT$A", "^SFT$B", "^SFT$C", "^SFT$D", "^SFT$E", "^SFT$F", "^SFT$G", "^SFT$H", "^SFT$I", "^SFT$J", "^SFT$K", "^SFT$L", "^SFT$M", "^SFT$N", "^SFT$O", "^SFT$P", "^SFT$Q", "^SFT$R", "^SFT$S", "^SFT$T", "^SFT$U", "^SFT$V", "^SFT$W", "^SFT$X", "^SFT$Y", "^SFT$Z", "^SFT%A", "^SFT%B", "^SFT%C", "^SFT%D", "^SFT%E", " ", "^SFT/A", "^SFT/B", "^SFT/C", "$", "%", "^SFT/F", "^SFT/G", "^SFT/H", "^SFT/I", "^SFT/J", "+", "^SFT/L", "-", ".", "/", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "^SFT/Z", "^SFT%F", "^SFT%G", "^SFT%H", "^SFT%I", "^SFT%J", "^SFT%V", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "^SFT%K", "^SFT%L", "^SFT%M", "^SFT%N", "^SFT%O", "^SFT%W", "^SFT+A", "^SFT+B", "^SFT+C", "^SFT+D", "^SFT+E", "^SFT+F", "^SFT+G", "^SFT+H", "^SFT+I", "^SFT+J", "^SFT+K", "^SFT+L", "^SFT+M", "^SFT+N", "^SFT+O", "^SFT+P", "^SFT+Q", "^SFT+R", "^SFT+S", "^SFT+T", "^SFT+U", "^SFT+V", "^SFT+W", "^SFT+X", "^SFT+Y", "^SFT+Z", "^SFT%P", "^SFT%Q", "^SFT%R", "^SFT%S", "^SFT%T"]); //#7787
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_code93ext.$ctx[id] = $_[id]); //#7787
        bwipp_code93ext.__7788__ = 1; //#7787
        $_ = Object.getPrototypeOf($_); //#7787
    } //#7787
    $_.newcode = $s($_.barlen * 6); //#7790
    $_.newtext = $s($_.barlen * 6); //#7791
    $_.j = 0; //#7792
    $_.k = 0; //#7792
    for (var _I = 0, _H = $_.barlen - 1; _I <= _H; _I += 1) { //#7806
        $_.i = _I; //#7794
        var _L = $get($_.barcode, $_.i); //#7795
        $k[$j++] = _L; //#7798
        if (_L > 127) { //#7798
            $j--; //#7797
            $k[$j++] = 'bwipp.code93extbadCharacter#7797'; //#7797
            $k[$j++] = "Code 93 Extended only support ASCII characters with values 0 to 127"; //#7797
            bwipp_raiseerror(); //#7797
        } //#7797
        $_.extchar = $get($_.extencs, $k[--$j]); //#7799
        $_.extlen = $_.extchar.length; //#7800
        $puti($_.newcode, $_.j, $_.extchar); //#7801
        var _X = $get($_.barcode, $_.i); //#7802
        $k[$j++] = $_.newtext; //#7802
        $k[$j++] = $_.k; //#7802
        $k[$j++] = _X; //#7802
        if ((_X < 32) || (_X == 127)) { //#7802
            $j--; //#7802
            $k[$j++] = 32; //#7802
        } //#7802
        var _Y = $k[--$j]; //#7802
        var _Z = $k[--$j]; //#7802
        $put($k[--$j], _Z, _Y); //#7802
        if ($_.extlen != 1) { //#7803
            $put($_.newtext, $_.k + 1, 32); //#7803
        } //#7803
        $_.j = $_.j + $_.extlen; //#7804
        var _i = ($_.extlen == 1) ? 1 : 2; //#7805
        $_.k = $_.k + _i; //#7805
    } //#7805
    $_.newcode = $geti($_.newcode, 0, $_.j); //#7807
    $_.newtext = $geti($_.newtext, 0, $_.k); //#7808
    $put($_.options, "dontdraw", true); //#7811
    $put($_.options, "parsefnc", true); //#7812
    $k[$j++] = 'args'; //#7813
    $k[$j++] = $_.newcode; //#7813
    $k[$j++] = $_.options; //#7813
    bwipp_code93(); //#7813
    var _t = $k[--$j]; //#7813
    $_[$k[--$j]] = _t; //#7813
    if ($_.includetext) { //#7825
        $_.txt = $get($_.args, "txt"); //#7817
        for (var _10 = 0, _z = $_.newtext.length - 1; _10 <= _z; _10 += 1) { //#7823
            $_.i = _10; //#7819
            $_.txtentry = $get($_.txt, $_.i); //#7820
            $put($_.txtentry, 0, $geti($_.newtext, $_.i, 1)); //#7821
            $put($_.txt, $_.i, $_.txtentry); //#7822
        } //#7822
        $put($_.args, "txt", $_.txt); //#7824
    } //#7824
    $put($_.args, "opt", $_.options); //#7826
    $k[$j++] = $_.args; //#7829
    if (!$_.dontdraw) { //#7829
        bwipp_renlinear(); //#7829
    } //#7829
    $_ = Object.getPrototypeOf($_); //#7831
    $_ = Object.getPrototypeOf($_); //#7833
} //bwipp_code93ext
function bwipp_interleaved2of5() {
    $_ = Object.create($_); //#7863
    $_.dontdraw = false; //#7866
    $_.includecheck = false; //#7867
    $_.includetext = false; //#7868
    $_.includecheckintext = false; //#7869
    $_.textfont = "OCR-B"; //#7870
    $_.textsize = 10; //#7871
    $_.textyoffset = -8; //#7872
    $_.height = 1; //#7873
    $k[$j++] = $_; //#7875
    bwipp_processoptions(); //#7875
    $_.options = $k[--$j]; //#7875
    $_.barcode = $k[--$j]; //#7876
    bwipp_loadctx(bwipp_interleaved2of5) //#7878
    $forall($_.barcode, function() { //#7885
        var _3 = $k[--$j]; //#7882
        if ((_3 < 48) || (_3 > 57)) { //#7884
            $k[$j++] = 'bwipp.interleaved2of5badCharacter#7883'; //#7883
            $k[$j++] = "Interleaved 2 of 5 must contain only digits"; //#7883
            bwipp_raiseerror(); //#7883
        } //#7883
    }); //#7883
    $_.barlen = $_.barcode.length; //#7887
    if (((($_.barlen % 2) == 0) && $_.includecheck) || ((($_.barlen % 2) != 0) && (!$_.includecheck))) { //#7898
        $_.pad = $s($_.barlen + 1); //#7893
        $put($_.pad, 0, 48); //#7894
        $puti($_.pad, 1, $_.barcode); //#7895
        $_.barcode = $_.pad; //#7896
        $_.barlen = $_.barlen + 1; //#7897
    } //#7897
    if ($_.includecheck) { //#7917
        $_.checksum = 0; //#7902
        for (var _J = 0, _I = $_.barlen - 1; _J <= _I; _J += 1) { //#7910
            $_.i = _J; //#7904
            if (($_.i % 2) == 0) { //#7908
                $_.checksum = $_.checksum + (($get($_.barcode, $_.i) - 48) * 3); //#7906
            } else { //#7908
                $_.checksum = $_.checksum + ($get($_.barcode, $_.i) - 48); //#7908
            } //#7908
        } //#7908
        $_.checksum = (10 - ($_.checksum % 10)) % 10; //#7911
        $_.pad = $s($_.barlen + 1); //#7912
        $puti($_.pad, 0, $_.barcode); //#7913
        $put($_.pad, $_.barlen, $_.checksum + 48); //#7914
        $_.barcode = $_.pad; //#7915
        $_.barlen = $_.barlen + 1; //#7916
    } //#7916
    if (!bwipp_interleaved2of5.__7929__) { //#7929
        $_ = Object.create($_); //#7929
        $_.encs = $a(["11221", "21112", "12112", "22111", "11212", "21211", "12211", "11122", "21121", "12121", "1111", "2111"]); //#7925
        $_.barchars = "0123456789"; //#7928
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_interleaved2of5.$ctx[id] = $_[id]); //#7928
        bwipp_interleaved2of5.__7929__ = 1; //#7928
        $_ = Object.getPrototypeOf($_); //#7928
    } //#7928
    $_.sbs = $s(($_.barlen * 5) + 8); //#7931
    $_.txt = $a($_.barlen); //#7932
    $puti($_.sbs, 0, $get($_.encs, 10)); //#7935
    for (var _o = 0, _n = $_.barlen - 1; _o <= _n; _o += 2) { //#7969
        $_.i = _o; //#7938
        $search($_.barchars, $geti($_.barcode, $_.i, 1)); //#7940
        $j--; //#7941
        $_.indx = $k[--$j].length; //#7942
        $j -= 2; //#7943
        $_.enca = $get($_.encs, $_.indx); //#7944
        $search($_.barchars, $geti($_.barcode, $_.i + 1, 1)); //#7946
        $j--; //#7947
        $_.indx = $k[--$j].length; //#7948
        $j -= 2; //#7949
        $_.encb = $get($_.encs, $_.indx); //#7950
        $_.intl = $s($_.enca.length * 2); //#7953
        for (var _19 = 0, _18 = $_.enca.length - 1; _19 <= _18; _19 += 1) { //#7960
            $_.j = _19; //#7955
            $_.achar = $get($_.enca, $_.j); //#7956
            $_.bchar = $get($_.encb, $_.j); //#7957
            $put($_.intl, $_.j * 2, $_.achar); //#7958
            $put($_.intl, ($_.j * 2) + 1, $_.bchar); //#7959
        } //#7959
        $puti($_.sbs, ($_.i * 5) + 4, $_.intl); //#7962
        $put($_.txt, $_.i, $a([$geti($_.barcode, $_.i, 1), ($_.i * 9) + 4, $_.textyoffset, $_.textfont, $_.textsize])); //#7963
        if (($_.includecheck && (!$_.includecheckintext)) && (($_.barlen - 2) == $_.i)) { //#7967
            $put($_.txt, $_.i + 1, $a([" ", (($_.i + 1) * 9) + 4, $_.textyoffset, $_.textfont, $_.textsize])); //#7965
        } else { //#7967
            $put($_.txt, $_.i + 1, $a([$geti($_.barcode, $_.i + 1, 1), (($_.i + 1) * 9) + 4, $_.textyoffset, $_.textfont, $_.textsize])); //#7967
        } //#7967
    } //#7967
    $puti($_.sbs, ($_.barlen * 5) + 4, $get($_.encs, 11)); //#7972
    $k[$j++] = Infinity; //#7975
    $k[$j++] = Infinity; //#7977
    var _1y = $_.sbs; //#7977
    for (var _1z = 0, _20 = _1y.length; _1z < _20; _1z++) { //#7977
        $k[$j++] = $get(_1y, _1z) - 48; //#7977
    } //#7977
    var _22 = $a(); //#7977
    $k[$j++] = Infinity; //#7978
    for (var _24 = 0, _25 = ~~(($_.sbs.length + 1) / 2); _24 < _25; _24++) { //#7978
        $k[$j++] = $_.height; //#7978
    } //#7978
    var _27 = $a(); //#7978
    $k[$j++] = Infinity; //#7979
    for (var _29 = 0, _2A = ~~(($_.sbs.length + 1) / 2); _29 < _2A; _29++) { //#7979
        $k[$j++] = 0; //#7979
    } //#7979
    var _2B = $a(); //#7979
    $k[$j++] = 'ren'; //#7982
    $k[$j++] = 'renlinear'; //#7982
    $k[$j++] = 'sbs'; //#7982
    $k[$j++] = _22; //#7982
    $k[$j++] = 'bhs'; //#7982
    $k[$j++] = _27; //#7982
    $k[$j++] = 'bbs'; //#7982
    $k[$j++] = _2B; //#7982
    if ($_.includetext) { //#7982
        $k[$j++] = 'txt'; //#7981
        $k[$j++] = $_.txt; //#7981
    } //#7981
    $k[$j++] = 'barratio'; //#7985
    $k[$j++] = 2; //#7985
    $k[$j++] = 'spaceratio'; //#7985
    $k[$j++] = 2; //#7985
    $k[$j++] = 'opt'; //#7985
    $k[$j++] = $_.options; //#7985
    var _2F = $d(); //#7985
    $k[$j++] = _2F; //#7988
    if (!$_.dontdraw) { //#7988
        bwipp_renlinear(); //#7988
    } //#7988
    $_ = Object.getPrototypeOf($_); //#7990
    $_ = Object.getPrototypeOf($_); //#7992
} //bwipp_interleaved2of5
function bwipp_itf14() {
    $_ = Object.create($_); //#8021
    $_.dontdraw = false; //#8024
    $_.includetext = false; //#8025
    $_.includecheckintext = true; //#8026
    $_.textfont = "OCR-B"; //#8027
    $_.textsize = 10; //#8028
    $_.textxoffset = 0; //#8029
    $_.textyoffset = 3.5; //#8030
    $_.height = 0.5; //#8031
    $_.showborder = true; //#8032
    $_.borderwidth = 4; //#8033
    $_.borderleft = 10; //#8034
    $_.borderright = 10; //#8035
    $_.bordertop = -0.55; //#8036
    $_.borderbottom = -0.55; //#8037
    $k[$j++] = $_; //#8039
    bwipp_processoptions(); //#8039
    $_.options = $k[--$j]; //#8039
    $_.barcode = $k[--$j]; //#8040
    $_.text = $_.barcode; //#8043
    var _3 = $_.barcode; //#8044
    $k[$j++] = $s(_3.length); //#8045
    $k[$j++] = 0; //#8045
    $forall(_3, function() { //#8045
        var _5 = $k[--$j]; //#8045
        $k[$j++] = _5; //#8045
        if (_5 != 32) { //#8045
            var _6 = $k[--$j]; //#8045
            var _7 = $k[--$j]; //#8045
            var _8 = $k[--$j]; //#8045
            $put(_8, _7, _6); //#8045
            $k[$j++] = _8; //#8045
            $k[$j++] = $f(_7 + 1); //#8045
        } else { //#8045
            $j--; //#8045
        } //#8045
    }); //#8045
    var _9 = $k[--$j]; //#8046
    $_.barcode = $geti($k[--$j], 0, _9); //#8046
    $_.hasspace = $_.text.length != $_.barcode.length; //#8047
    if (($_.barcode.length != 13) && ($_.barcode.length != 14)) { //#8052
        $k[$j++] = 'bwipp.itf14badLength#8051'; //#8051
        $k[$j++] = "ITF-14 must be 13 or 14 digits"; //#8051
        bwipp_raiseerror(); //#8051
    } //#8051
    var _G = $_.barcode; //#8053
    for (var _H = 0, _I = _G.length; _H < _I; _H++) { //#8057
        var _J = $get(_G, _H); //#8057
        if ((_J < 48) || (_J > 57)) { //#8056
            $k[$j++] = 'bwipp.itf14badCharacter#8055'; //#8055
            $k[$j++] = "ITF-14 must contain only digits"; //#8055
            bwipp_raiseerror(); //#8055
        } //#8055
    } //#8055
    $_.checksum = 0; //#8060
    for (var _K = 0; _K <= 12; _K += 1) { //#8064
        $_.i = _K; //#8062
        $k[$j++] = 'checksum'; //#8063
        $k[$j++] = $_.checksum; //#8063
        $k[$j++] = $f($get($_.barcode, $_.i) - 48); //#8063
        if (($_.i % 2) == 0) { //#8063
            var _Q = $k[--$j]; //#8063
            $k[$j++] = _Q * 3; //#8063
        } //#8063
        var _R = $k[--$j]; //#8063
        var _S = $k[--$j]; //#8063
        $_[$k[--$j]] = $f(_S + _R); //#8063
    } //#8063
    $_.checksum = (10 - ($_.checksum % 10)) % 10; //#8065
    if ($_.barcode.length == 14) { //#8079
        if ($get($_.barcode, 13) != ($_.checksum + 48)) { //#8069
            $k[$j++] = 'bwipp.itf14badCheckDigit#8068'; //#8068
            $k[$j++] = "Incorrect ITF-14 check digit provided"; //#8068
            bwipp_raiseerror(); //#8068
        } //#8068
    } else { //#8079
        var _Z = $s(14); //#8071
        $puti(_Z, 0, $_.barcode); //#8072
        $put(_Z, 13, $_.checksum + 48); //#8073
        $_.barcode = _Z; //#8074
        var _e = $_.hasspace ? 2 : 1; //#8075
        var _f = $s($_.text.length + _e); //#8075
        $puti(_f, _f.length - 2, " "); //#8076
        $put(_f, _f.length - 1, $_.checksum + 48); //#8077
        $puti(_f, 0, $_.text); //#8078
        $_.text = _f; //#8079
    } //#8079
    var _i = $_.options; //#8083
    $put(_i, "dontdraw", true); //#8083
    $put($_.options, "showborder", $_.showborder); //#8084
    $put($_.options, "borderwidth", $_.borderwidth); //#8085
    $put($_.options, "borderleft", $_.borderleft); //#8086
    $put($_.options, "borderright", $_.borderright); //#8087
    var _r = $_.options; //#8088
    $put(_r, "bordertop", $_.bordertop); //#8088
    $put($_.options, "borderbottom", $_.borderbottom); //#8089
    $put($_.options, "height", $_.height); //#8090
    $put($_.options, "textyoffset", $_.textyoffset); //#8091
    $k[$j++] = 'args'; //#8092
    $k[$j++] = $_.barcode; //#8092
    $k[$j++] = $_.options; //#8092
    bwipp_interleaved2of5(); //#8092
    var _11 = $k[--$j]; //#8092
    $_[$k[--$j]] = _11; //#8092
    $put($_.args, "txt", $a([$a([$_.text, $_.textxoffset, $_.textyoffset, $_.textfont, $_.textsize])])); //#8094
    $put($_.args, "textxalign", "center"); //#8095
    $put($_.args, "opt", $_.options); //#8096
    $k[$j++] = $_.args; //#8099
    if (!$_.dontdraw) { //#8099
        bwipp_renlinear(); //#8099
    } //#8099
    $_ = Object.getPrototypeOf($_); //#8101
} //bwipp_itf14
function bwipp_identcode() {
    $_ = Object.create($_); //#8130
    $_.dontdraw = false; //#8133
    $_.includetext = false; //#8134
    $_.textfont = "OCR-B"; //#8135
    $_.textsize = 10; //#8136
    $_.textxoffset = 0; //#8137
    $_.textyoffset = -8; //#8138
    $_.height = 1; //#8139
    $k[$j++] = $_; //#8141
    bwipp_processoptions(); //#8141
    $_.options = $k[--$j]; //#8141
    $_.barcode = $k[--$j]; //#8142
    if (($_.barcode.length != 11) && ($_.barcode.length != 12)) { //#8147
        $k[$j++] = 'bwipp.identcodeBadLength#8146'; //#8146
        $k[$j++] = "Deutsche Post Identcode must be 11 or 12 digits"; //#8146
        bwipp_raiseerror(); //#8146
    } //#8146
    $forall($_.barcode, function() { //#8152
        var _5 = $k[--$j]; //#8149
        if ((_5 < 48) || (_5 > 57)) { //#8151
            $k[$j++] = 'bwipp.identcodeBadCharacter#8150'; //#8150
            $k[$j++] = "Deutsche Post Identcode must contain only digits"; //#8150
            bwipp_raiseerror(); //#8150
        } //#8150
    }); //#8150
    $_.checksum = 0; //#8155
    for (var _6 = 0; _6 <= 10; _6 += 1) { //#8159
        $_.i = _6; //#8157
        $k[$j++] = 'checksum'; //#8158
        $k[$j++] = $_.checksum; //#8158
        $k[$j++] = $f($get($_.barcode, $_.i) - 48); //#8158
        if (($_.i % 2) == 0) { //#8158
            var _C = $k[--$j]; //#8158
            $k[$j++] = _C * 4; //#8158
        } else { //#8158
            var _D = $k[--$j]; //#8158
            $k[$j++] = _D * 9; //#8158
        } //#8158
        var _E = $k[--$j]; //#8158
        var _F = $k[--$j]; //#8158
        $_[$k[--$j]] = $f(_F + _E); //#8158
    } //#8158
    $_.checksum = (10 - ($_.checksum % 10)) % 10; //#8160
    if ($_.barcode.length == 12) { //#8165
        if ($get($_.barcode, 11) != ($_.checksum + 48)) { //#8164
            $k[$j++] = 'bwipp.identcodeBadCheckDigit#8163'; //#8163
            $k[$j++] = "Incorrect Deutsche Post Identcode check digit provided"; //#8163
            bwipp_raiseerror(); //#8163
        } //#8163
    } //#8163
    var _M = $s(12); //#8166
    $puti(_M, 0, $_.barcode); //#8167
    $put(_M, 11, $_.checksum + 48); //#8168
    $_.barcode = _M; //#8169
    $_.text = $strcpy($s(16), "  .       .     "); //#8172
    $puti($_.text, 0, $geti($_.barcode, 0, 2)); //#8173
    $puti($_.text, 3, $geti($_.barcode, 2, 3)); //#8174
    $puti($_.text, 7, $geti($_.barcode, 5, 3)); //#8175
    $puti($_.text, 11, $geti($_.barcode, 8, 3)); //#8176
    $puti($_.text, 15, $geti($_.barcode, 11, 1)); //#8177
    $put($_.options, "dontdraw", true); //#8180
    $put($_.options, "includecheck", false); //#8181
    var _i = $_.barcode; //#8182
    $k[$j++] = 'args'; //#8182
    $k[$j++] = _i; //#8182
    $k[$j++] = $_.options; //#8182
    bwipp_interleaved2of5(); //#8182
    var _k = $k[--$j]; //#8182
    $_[$k[--$j]] = _k; //#8182
    var _r = $_.textsize; //#8184
    $put($_.args, "txt", $a([$a([$_.text, $_.textxoffset, $_.textyoffset, $_.textfont, _r])])); //#8184
    $put($_.args, "textxalign", "center"); //#8185
    $put($_.args, "opt", $_.options); //#8186
    $k[$j++] = $_.args; //#8189
    if (!$_.dontdraw) { //#8189
        bwipp_renlinear(); //#8189
    } //#8189
    $_ = Object.getPrototypeOf($_); //#8191
} //bwipp_identcode
function bwipp_leitcode() {
    $_ = Object.create($_); //#8220
    $_.dontdraw = false; //#8223
    $_.includetext = false; //#8224
    $_.textfont = "OCR-B"; //#8225
    $_.textsize = 10; //#8226
    $_.textxoffset = 0; //#8227
    $_.textyoffset = -8; //#8228
    $_.height = 1; //#8229
    $k[$j++] = $_; //#8231
    bwipp_processoptions(); //#8231
    $_.options = $k[--$j]; //#8231
    $_.barcode = $k[--$j]; //#8232
    if (($_.barcode.length != 13) && ($_.barcode.length != 14)) { //#8237
        $k[$j++] = 'bwipp.leitcodeBadLength#8236'; //#8236
        $k[$j++] = "Deutsche Post Leitcode must be 13 or 14 digits"; //#8236
        bwipp_raiseerror(); //#8236
    } //#8236
    $forall($_.barcode, function() { //#8242
        var _5 = $k[--$j]; //#8239
        if ((_5 < 48) || (_5 > 57)) { //#8241
            $k[$j++] = 'bwipp.leitcodeBadCharacter#8240'; //#8240
            $k[$j++] = "Deutsche Post Leitcode must contain only digits"; //#8240
            bwipp_raiseerror(); //#8240
        } //#8240
    }); //#8240
    $_.checksum = 0; //#8245
    for (var _6 = 0; _6 <= 12; _6 += 1) { //#8249
        $_.i = _6; //#8247
        $k[$j++] = 'checksum'; //#8248
        $k[$j++] = $_.checksum; //#8248
        $k[$j++] = $f($get($_.barcode, $_.i) - 48); //#8248
        if (($_.i % 2) == 0) { //#8248
            var _C = $k[--$j]; //#8248
            $k[$j++] = _C * 4; //#8248
        } else { //#8248
            var _D = $k[--$j]; //#8248
            $k[$j++] = _D * 9; //#8248
        } //#8248
        var _E = $k[--$j]; //#8248
        var _F = $k[--$j]; //#8248
        $_[$k[--$j]] = $f(_F + _E); //#8248
    } //#8248
    $_.checksum = (10 - ($_.checksum % 10)) % 10; //#8250
    if ($_.barcode.length == 14) { //#8255
        if ($get($_.barcode, 13) != ($_.checksum + 48)) { //#8254
            $k[$j++] = 'bwipp.leitcodeBadCheckDigit#8253'; //#8253
            $k[$j++] = "Incorrect Deutsche Post Leitcode check digit provided"; //#8253
            bwipp_raiseerror(); //#8253
        } //#8253
    } //#8253
    var _M = $s(14); //#8256
    $puti(_M, 0, $_.barcode); //#8257
    $put(_M, 13, $_.checksum + 48); //#8258
    $_.barcode = _M; //#8259
    $_.text = $strcpy($s(18), "     .   .   .    "); //#8262
    $puti($_.text, 0, $geti($_.barcode, 0, 5)); //#8263
    $puti($_.text, 6, $geti($_.barcode, 5, 3)); //#8264
    $puti($_.text, 10, $geti($_.barcode, 8, 3)); //#8265
    $puti($_.text, 14, $geti($_.barcode, 11, 2)); //#8266
    $puti($_.text, 17, $geti($_.barcode, 13, 1)); //#8267
    $put($_.options, "dontdraw", true); //#8270
    $put($_.options, "includecheck", false); //#8271
    var _i = $_.barcode; //#8272
    $k[$j++] = 'args'; //#8272
    $k[$j++] = _i; //#8272
    $k[$j++] = $_.options; //#8272
    bwipp_interleaved2of5(); //#8272
    var _k = $k[--$j]; //#8272
    $_[$k[--$j]] = _k; //#8272
    var _r = $_.textsize; //#8274
    $put($_.args, "txt", $a([$a([$_.text, $_.textxoffset, $_.textyoffset, $_.textfont, _r])])); //#8274
    $put($_.args, "textxalign", "center"); //#8275
    $put($_.args, "opt", $_.options); //#8276
    $k[$j++] = $_.args; //#8279
    if (!$_.dontdraw) { //#8279
        bwipp_renlinear(); //#8279
    } //#8279
    $_ = Object.getPrototypeOf($_); //#8281
} //bwipp_leitcode
function bwipp_databaromni() {
    $_ = Object.create($_); //#8312
    $_.dontdraw = false; //#8315
    $_.height = 33 / 72; //#8316
    $_.linkage = false; //#8317
    $_.format = "omni"; //#8318
    $_.barxmult = 33; //#8319
    $k[$j++] = $_; //#8321
    bwipp_processoptions(); //#8321
    $_.options = $k[--$j]; //#8321
    $_.barcode = $k[--$j]; //#8322
    if (($_.barcode.length != 17) && ($_.barcode.length != 18)) { //#8326
        $k[$j++] = 'bwipp.databaromniBadLength#8325'; //#8325
        $k[$j++] = "GS1 DataBar Omnidirectional must be 13 or 14 digits"; //#8325
        bwipp_raiseerror(); //#8325
    } //#8325
    if ($ne($geti($_.barcode, 0, 4), "(01)")) { //#8329
        $k[$j++] = 'bwipp.databaromniBadAI#8328'; //#8328
        $k[$j++] = "GS1 DataBar Omnidirectional must begin with (01) application identifier"; //#8328
        bwipp_raiseerror(); //#8328
    } //#8328
    var _8 = $geti($_.barcode, 4, $_.barcode.length - 4); //#8330
    for (var _9 = 0, _A = _8.length; _9 < _A; _9++) { //#8334
        var _B = $get(_8, _9); //#8334
        if ((_B < 48) || (_B > 57)) { //#8333
            $k[$j++] = 'bwipp.databaromniBadCharacter#8332'; //#8332
            $k[$j++] = "GS1 DataBar Omnidirectional must contain only digits"; //#8332
            bwipp_raiseerror(); //#8332
        } //#8332
    } //#8332
    if ($_.barxmult < 33) { //#8338
        $k[$j++] = 'bwipp.databarStackedOmniBarXmult#8337'; //#8337
        $k[$j++] = "GS1 DataBar Stacked Omnidirectional must have a barxmult of at least 33"; //#8337
        bwipp_raiseerror(); //#8337
    } //#8337
    if ((($ne($_.format, "omni") && $ne($_.format, "stacked")) && $ne($_.format, "stackedomni")) && $ne($_.format, "truncated")) { //#8342
        $k[$j++] = 'bwipp.databaromniBadFormat#8341'; //#8341
        $k[$j++] = "Valid formats are omni, stacked, stackedomni and truncated"; //#8341
        bwipp_raiseerror(); //#8341
    } //#8341
    if ($eq($_.format, "truncated")) { //#8344
        $_.height = 13 / 72; //#8344
    } //#8344
    bwipp_loadctx(bwipp_databaromni) //#8346
    $_.checksum = 0; //#8349
    for (var _I = 0; _I <= 12; _I += 1) { //#8353
        $_.i = _I; //#8351
        $k[$j++] = 'checksum'; //#8352
        $k[$j++] = $_.checksum; //#8352
        $k[$j++] = $f($get($_.barcode, $_.i + 4) - 48); //#8352
        if (($_.i % 2) == 0) { //#8352
            var _O = $k[--$j]; //#8352
            $k[$j++] = _O * 3; //#8352
        } //#8352
        var _P = $k[--$j]; //#8352
        var _Q = $k[--$j]; //#8352
        $_[$k[--$j]] = $f(_Q + _P); //#8352
    } //#8352
    $_.checksum = (10 - ($_.checksum % 10)) % 10; //#8354
    if ($_.barcode.length == 18) { //#8359
        if ($get($_.barcode, 17) != ($_.checksum + 48)) { //#8358
            $k[$j++] = 'bwipp.databaromniBadCheckDigit#8357'; //#8357
            $k[$j++] = "Incorrect GS1 DataBar Omnidirectional check digit provided"; //#8357
            bwipp_raiseerror(); //#8357
        } //#8357
    } //#8357
    var _X = $s(18); //#8360
    $puti(_X, 0, $_.barcode); //#8361
    $put(_X, 17, $_.checksum + 48); //#8362
    $_.barcode = _X; //#8363
    $_.txt = $a($_.barcode.length); //#8366
    for (var _e = 0, _d = $_.barcode.length - 1; _e <= _d; _e += 1) { //#8370
        $_.i = _e; //#8368
        $put($_.txt, $_.i, $a([$geti($_.barcode, $_.i, 1), 0, 0, "", 0])); //#8369
    } //#8369
    $_.ncr = function() {
        var _l = $k[--$j]; //#8373
        var _m = $k[--$j]; //#8373
        var _n = $f(_m - _l); //#8373
        if (_l < $f(_m - _l)) { //#8373
            var _ = _n; //#8373
            _n = _l; //#8373
            _l = _; //#8373
        } //#8373
        $k[$j++] = _n; //#8380
        $k[$j++] = 1; //#8380
        $k[$j++] = 1; //#8380
        for (var _p = _m, _o = $f(_l + 1); _p >= _o; _p -= 1) { //#8380
            var _q = $k[--$j]; //#8376
            var _r = $k[--$j]; //#8377
            var _s = $k[--$j]; //#8377
            $k[$j++] = _s; //#8379
            $k[$j++] = _r; //#8379
            $k[$j++] = _q * _p; //#8379
            if ($le(_r, _s)) { //#8379
                var _t = $k[--$j]; //#8378
                var _u = $k[--$j]; //#8378
                $k[$j++] = $f(_u + 1); //#8378
                $k[$j++] = ~~(_t / _u); //#8378
            } //#8378
        } //#8378
        for (;;) { //#8384
            var _v = $k[--$j]; //#8382
            var _w = $k[--$j]; //#8382
            var _x = $k[--$j]; //#8382
            $k[$j++] = _x; //#8382
            $k[$j++] = _w; //#8382
            $k[$j++] = _v; //#8382
            if ($gt(_w, _x)) { //#8382
                break; //#8382
            } //#8382
            var _y = $k[--$j]; //#8383
            var _z = $k[--$j]; //#8383
            $k[$j++] = $f(_z + 1); //#8383
            $k[$j++] = ~~(_y / _z); //#8383
        } //#8383
        var _10 = $k[--$j]; //#8385
        var _11 = $k[--$j]; //#8385
        $k[$j++] = _10; //#8385
        $k[$j++] = _11; //#8385
        $j--; //#8385
        var _12 = $k[--$j]; //#8385
        var _13 = $k[--$j]; //#8385
        $k[$j++] = _12; //#8385
        $k[$j++] = _13; //#8385
        $j--; //#8385
    }; //#8385
    $_.getRSSwidths = function() {
        $_.oe = $k[--$j]; //#8389
        $_.el = $k[--$j]; //#8390
        $_.mw = $k[--$j]; //#8391
        $_.nm = $k[--$j]; //#8392
        $_.val = $k[--$j]; //#8393
        $_.out = $a($_.el); //#8394
        $_.mask = 0; //#8395
        for (var _1D = 0, _1C = $f($_.el - 2); _1D <= _1C; _1D += 1) { //#8422
            $_.bar = _1D; //#8397
            $_.ew = 1; //#8398
            var _1F = $_.bar; //#8399
            $_.mask = $_.mask | ((_1F < 0 ? 1 >>> -_1F : 1 << _1F)); //#8399
            for (;;) { //#8418
                $k[$j++] = 'sval'; //#8400
                $k[$j++] = $f($f($_.nm - $_.ew) - 1); //#8400
                $k[$j++] = $f($f($_.el - $_.bar) - 2); //#8400
                $_.ncr(); //#8400
                var _1K = $k[--$j]; //#8400
                $_[$k[--$j]] = _1K; //#8400
                if (($_.oe && ($_.mask == 0)) && (($f(($f($f($_.nm - $_.ew) - ($_.el * 2))) + ($_.bar * 2))) >= -2)) { //#8403
                    $k[$j++] = 'sval'; //#8402
                    $k[$j++] = $_.sval; //#8402
                    $k[$j++] = $f(($f($f($_.nm - $_.ew) - $_.el)) + $_.bar); //#8402
                    $k[$j++] = $f($f($_.el - $_.bar) - 2); //#8402
                    $_.ncr(); //#8402
                    var _1Z = $k[--$j]; //#8402
                    var _1a = $k[--$j]; //#8402
                    $_[$k[--$j]] = $f(_1a - _1Z); //#8402
                } //#8402
                if ($f($_.el - $_.bar) > 2) { //#8412
                    $_.lval = 0; //#8405
                    for (var _1k = $f(($f(($f($f($_.nm - $_.ew) - $_.el)) + $_.bar)) + 2), _1j = $f($_.mw + 1); _1k >= _1j; _1k -= 1) { //#8409
                        $k[$j++] = $f(($f($f($_.nm - _1k) - $_.ew)) - 1); //#8407
                        $k[$j++] = $f($f($_.el - $_.bar) - 3); //#8407
                        $_.ncr(); //#8407
                        $_.lval = $f($k[--$j] + $_.lval); //#8408
                    } //#8408
                    $_.sval = $f($_.sval - ($_.lval * ($f($f($_.el - $_.bar) - 1)))); //#8410
                } else { //#8412
                    if ($f($_.nm - $_.ew) > $_.mw) { //#8412
                        $_.sval = $f($_.sval - 1); //#8412
                    } //#8412
                } //#8412
                $_.val = $f($_.val - $_.sval); //#8414
                if ($_.val < 0) { //#8415
                    break; //#8415
                } //#8415
                $_.ew = $_.ew + 1; //#8416
                var _24 = $_.bar; //#8417
                $_.mask = $_.mask & (~((_24 < 0 ? 1 >>> -_24 : 1 << _24))); //#8417
            } //#8417
            $_.val = $f($_.val + $_.sval); //#8419
            $_.nm = $f($_.nm - $_.ew); //#8420
            $put($_.out, $_.bar, $_.ew); //#8421
        } //#8421
        $put($_.out, $f($_.el - 1), $_.nm); //#8423
        $k[$j++] = $_.out; //#8424
    }; //#8424
    $k[$j++] = Infinity; //#8427
    var _2H = $_.linkage ? 1 : 0; //#8428
    var _2J = $geti($_.barcode, 4, 13); //#8429
    $k[$j++] = _2H; //#8429
    for (var _2K = 0, _2L = _2J.length; _2K < _2L; _2K++) { //#8429
        $k[$j++] = $f($get(_2J, _2K) - 48); //#8429
    } //#8429
    $_.binval = $a(); //#8429
    for (var _2O = 0; _2O <= 12; _2O += 1) { //#8436
        $_.i = _2O; //#8433
        var _2P = $_.binval; //#8434
        var _2Q = $_.i; //#8434
        $put(_2P, _2Q + 1, $f($get(_2P, _2Q + 1) + (($get($_.binval, $_.i) % 4537077) * 10))); //#8434
        $put($_.binval, $_.i, ~~($get($_.binval, $_.i) / 4537077)); //#8435
    } //#8435
    $_.right = $get($_.binval, 13) % 4537077; //#8437
    var _2c = $_.binval; //#8438
    $put(_2c, 13, ~~($get(_2c, 13) / 4537077)); //#8438
    $_.left = 0; //#8440
    $_.i = true; //#8441
    for (var _2e = 0; _2e <= 13; _2e += 1) { //#8451
        $_.j = _2e; //#8443
        var _2h = $get($_.binval, $_.j); //#8444
        $k[$j++] = _2h; //#8450
        if ((_2h == 0) && $_.i) { //#8449
            $j--; //#8446
        } else { //#8449
            $_.i = false; //#8448
            $_.left = $f($_.left + ($k[--$j] * (~~Math.pow(10, 13 - $_.j)))); //#8449
        } //#8449
    } //#8449
    $_.d1 = ~~($_.left / 1597); //#8453
    $_.d2 = $_.left % 1597; //#8454
    $_.d3 = ~~($_.right / 1597); //#8455
    $_.d4 = $_.right % 1597; //#8456
    if (!bwipp_databaromni.__8473__) { //#8473
        $_ = Object.create($_); //#8473
        $_.tab164 = $a([160, 0, 12, 4, 8, 1, 161, 1, 960, 161, 10, 6, 6, 3, 80, 10, 2014, 961, 8, 8, 4, 5, 31, 34, 2714, 2015, 6, 10, 3, 6, 10, 70, 2840, 2715, 4, 12, 1, 8, 1, 126]); //#8465
        $_.tab154 = $a([335, 0, 5, 10, 2, 7, 4, 84, 1035, 336, 7, 8, 4, 5, 20, 35, 1515, 1036, 9, 6, 6, 3, 48, 10, 1596, 1516, 11, 4, 8, 1, 81, 1]); //#8472
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_databaromni.$ctx[id] = $_[id]); //#8472
        bwipp_databaromni.__8473__ = 1; //#8472
        $_ = Object.getPrototypeOf($_); //#8472
    } //#8472
    $_.i = 0; //#8475
    for (;;) { //#8485
        if ($_.d1 <= $get($_.tab164, $_.i)) { //#8483
            var _2z = $geti($_.tab164, $_.i + 1, 7); //#8477
            for (var _30 = 0, _31 = _2z.length; _30 < _31; _30++) { //#8477
                $k[$j++] = $get(_2z, _30); //#8477
            } //#8477
            $_.d1te = $k[--$j]; //#8478
            $_.d1to = $k[--$j]; //#8478
            $_.d1mwe = $k[--$j]; //#8479
            $_.d1mwo = $k[--$j]; //#8479
            $_.d1ele = $k[--$j]; //#8480
            $_.d1elo = $k[--$j]; //#8480
            $_.d1gs = $k[--$j]; //#8481
            break; //#8482
        } //#8482
        $_.i = $_.i + 8; //#8484
    } //#8484
    $_.i = 0; //#8487
    for (;;) { //#8497
        if ($_.d2 <= $get($_.tab154, $_.i)) { //#8495
            var _3H = $geti($_.tab154, $_.i + 1, 7); //#8489
            for (var _3I = 0, _3J = _3H.length; _3I < _3J; _3I++) { //#8489
                $k[$j++] = $get(_3H, _3I); //#8489
            } //#8489
            $_.d2te = $k[--$j]; //#8490
            $_.d2to = $k[--$j]; //#8490
            $_.d2mwe = $k[--$j]; //#8491
            $_.d2mwo = $k[--$j]; //#8491
            $_.d2ele = $k[--$j]; //#8492
            $_.d2elo = $k[--$j]; //#8492
            $_.d2gs = $k[--$j]; //#8493
            break; //#8494
        } //#8494
        $_.i = $_.i + 8; //#8496
    } //#8496
    $_.i = 0; //#8499
    for (;;) { //#8509
        if ($_.d3 <= $get($_.tab164, $_.i)) { //#8507
            var _3Z = $geti($_.tab164, $_.i + 1, 7); //#8501
            for (var _3a = 0, _3b = _3Z.length; _3a < _3b; _3a++) { //#8501
                $k[$j++] = $get(_3Z, _3a); //#8501
            } //#8501
            $_.d3te = $k[--$j]; //#8502
            $_.d3to = $k[--$j]; //#8502
            $_.d3mwe = $k[--$j]; //#8503
            $_.d3mwo = $k[--$j]; //#8503
            $_.d3ele = $k[--$j]; //#8504
            $_.d3elo = $k[--$j]; //#8504
            $_.d3gs = $k[--$j]; //#8505
            break; //#8506
        } //#8506
        $_.i = $_.i + 8; //#8508
    } //#8508
    $_.i = 0; //#8511
    for (;;) { //#8521
        if ($_.d4 <= $get($_.tab154, $_.i)) { //#8519
            var _3r = $geti($_.tab154, $_.i + 1, 7); //#8513
            for (var _3s = 0, _3t = _3r.length; _3s < _3t; _3s++) { //#8513
                $k[$j++] = $get(_3r, _3s); //#8513
            } //#8513
            $_.d4te = $k[--$j]; //#8514
            $_.d4to = $k[--$j]; //#8514
            $_.d4mwe = $k[--$j]; //#8515
            $_.d4mwo = $k[--$j]; //#8515
            $_.d4ele = $k[--$j]; //#8516
            $_.d4elo = $k[--$j]; //#8516
            $_.d4gs = $k[--$j]; //#8517
            break; //#8518
        } //#8518
        $_.i = $_.i + 8; //#8520
    } //#8520
    $k[$j++] = 'd1wo'; //#8523
    $k[$j++] = ~~($f($_.d1 - $_.d1gs) / $_.d1te); //#8523
    $k[$j++] = $_.d1elo; //#8523
    $k[$j++] = $_.d1mwo; //#8523
    $k[$j++] = 4; //#8523
    $k[$j++] = false; //#8523
    $_.getRSSwidths(); //#8523
    var _48 = $k[--$j]; //#8523
    $_[$k[--$j]] = _48; //#8523
    $k[$j++] = 'd1we'; //#8524
    $k[$j++] = $f($_.d1 - $_.d1gs) % $_.d1te; //#8524
    $k[$j++] = $_.d1ele; //#8524
    $k[$j++] = $_.d1mwe; //#8524
    $k[$j++] = 4; //#8524
    $k[$j++] = true; //#8524
    $_.getRSSwidths(); //#8524
    var _4F = $k[--$j]; //#8524
    $_[$k[--$j]] = _4F; //#8524
    $k[$j++] = 'd2wo'; //#8525
    $k[$j++] = $f($_.d2 - $_.d2gs) % $_.d2to; //#8525
    $k[$j++] = $_.d2elo; //#8525
    $k[$j++] = $_.d2mwo; //#8525
    $k[$j++] = 4; //#8525
    $k[$j++] = true; //#8525
    $_.getRSSwidths(); //#8525
    var _4M = $k[--$j]; //#8525
    $_[$k[--$j]] = _4M; //#8525
    $k[$j++] = 'd2we'; //#8526
    $k[$j++] = ~~($f($_.d2 - $_.d2gs) / $_.d2to); //#8526
    $k[$j++] = $_.d2ele; //#8526
    $k[$j++] = $_.d2mwe; //#8526
    $k[$j++] = 4; //#8526
    $k[$j++] = false; //#8526
    $_.getRSSwidths(); //#8526
    var _4T = $k[--$j]; //#8526
    $_[$k[--$j]] = _4T; //#8526
    $k[$j++] = 'd3wo'; //#8527
    $k[$j++] = ~~($f($_.d3 - $_.d3gs) / $_.d3te); //#8527
    $k[$j++] = $_.d3elo; //#8527
    $k[$j++] = $_.d3mwo; //#8527
    $k[$j++] = 4; //#8527
    $k[$j++] = false; //#8527
    $_.getRSSwidths(); //#8527
    var _4a = $k[--$j]; //#8527
    $_[$k[--$j]] = _4a; //#8527
    $k[$j++] = 'd3we'; //#8528
    $k[$j++] = $f($_.d3 - $_.d3gs) % $_.d3te; //#8528
    $k[$j++] = $_.d3ele; //#8528
    $k[$j++] = $_.d3mwe; //#8528
    $k[$j++] = 4; //#8528
    $k[$j++] = true; //#8528
    $_.getRSSwidths(); //#8528
    var _4h = $k[--$j]; //#8528
    $_[$k[--$j]] = _4h; //#8528
    $k[$j++] = 'd4wo'; //#8529
    $k[$j++] = $f($_.d4 - $_.d4gs) % $_.d4to; //#8529
    $k[$j++] = $_.d4elo; //#8529
    $k[$j++] = $_.d4mwo; //#8529
    $k[$j++] = 4; //#8529
    $k[$j++] = true; //#8529
    $_.getRSSwidths(); //#8529
    var _4o = $k[--$j]; //#8529
    $_[$k[--$j]] = _4o; //#8529
    $k[$j++] = 'd4we'; //#8530
    $k[$j++] = ~~($f($_.d4 - $_.d4gs) / $_.d4to); //#8530
    $k[$j++] = $_.d4ele; //#8530
    $k[$j++] = $_.d4mwe; //#8530
    $k[$j++] = 4; //#8530
    $k[$j++] = false; //#8530
    $_.getRSSwidths(); //#8530
    var _4v = $k[--$j]; //#8530
    $_[$k[--$j]] = _4v; //#8530
    $_.d1w = $a(8); //#8532
    for (var _4y = 0; _4y <= 3; _4y += 1) { //#8537
        $_.i = _4y; //#8534
        $put($_.d1w, $_.i * 2, $get($_.d1wo, $_.i)); //#8535
        $put($_.d1w, ($_.i * 2) + 1, $get($_.d1we, $_.i)); //#8536
    } //#8536
    $_.d2w = $a(8); //#8539
    for (var _5A = 0; _5A <= 3; _5A += 1) { //#8544
        $_.i = _5A; //#8541
        $put($_.d2w, 7 - ($_.i * 2), $get($_.d2wo, $_.i)); //#8542
        $put($_.d2w, 6 - ($_.i * 2), $get($_.d2we, $_.i)); //#8543
    } //#8543
    $_.d3w = $a(8); //#8546
    for (var _5M = 0; _5M <= 3; _5M += 1) { //#8551
        $_.i = _5M; //#8548
        $put($_.d3w, 7 - ($_.i * 2), $get($_.d3wo, $_.i)); //#8549
        $put($_.d3w, 6 - ($_.i * 2), $get($_.d3we, $_.i)); //#8550
    } //#8550
    $_.d4w = $a(8); //#8553
    for (var _5Y = 0; _5Y <= 3; _5Y += 1) { //#8558
        $_.i = _5Y; //#8555
        $put($_.d4w, $_.i * 2, $get($_.d4wo, $_.i)); //#8556
        $put($_.d4w, ($_.i * 2) + 1, $get($_.d4we, $_.i)); //#8557
    } //#8557
    $k[$j++] = Infinity; //#8560
    var _5j = $_.d1w; //#8561
    for (var _5k = 0, _5l = _5j.length; _5k < _5l; _5k++) { //#8561
        $k[$j++] = $get(_5j, _5k); //#8561
    } //#8561
    var _5n = $_.d2w; //#8562
    for (var _5o = 0, _5p = _5n.length; _5o < _5p; _5o++) { //#8562
        $k[$j++] = $get(_5n, _5o); //#8562
    } //#8562
    var _5r = $_.d3w; //#8563
    for (var _5s = 0, _5t = _5r.length; _5s < _5t; _5s++) { //#8563
        $k[$j++] = $get(_5r, _5s); //#8563
    } //#8563
    var _5v = $_.d4w; //#8564
    for (var _5w = 0, _5x = _5v.length; _5w < _5x; _5w++) { //#8564
        $k[$j++] = $get(_5v, _5w); //#8564
    } //#8564
    $_.widths = $a(); //#8564
    if (!bwipp_databaromni.__8580__) { //#8580
        $_ = Object.create($_); //#8580
        $_.checkweights = $a([1, 3, 9, 27, 2, 6, 18, 54, 58, 72, 24, 8, 29, 36, 12, 4, 74, 51, 17, 32, 37, 65, 48, 16, 64, 34, 23, 69, 49, 68, 46, 59]); //#8573
        $_.checkwidths = $a([3, 8, 2, 1, 1, 3, 5, 5, 1, 1, 3, 3, 7, 1, 1, 3, 1, 9, 1, 1, 2, 7, 4, 1, 1, 2, 5, 6, 1, 1, 2, 3, 8, 1, 1, 1, 5, 7, 1, 1, 1, 3, 9, 1, 1]); //#8579
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_databaromni.$ctx[id] = $_[id]); //#8579
        bwipp_databaromni.__8580__ = 1; //#8579
        $_ = Object.getPrototypeOf($_); //#8579
    } //#8579
    $_.checksum = 0; //#8582
    for (var _63 = 0; _63 <= 31; _63 += 1) { //#8586
        $_.i = _63; //#8584
        $_.checksum = $f($_.checksum + ($get($_.widths, $_.i) * $get($_.checkweights, $_.i))); //#8585
    } //#8585
    $_.checksum = $_.checksum % 79; //#8587
    if ($_.checksum >= 8) { //#8588
        $_.checksum = $f($_.checksum + 1); //#8588
    } //#8588
    if ($_.checksum >= 72) { //#8589
        $_.checksum = $f($_.checksum + 1); //#8589
    } //#8589
    $_.checklt = $geti($_.checkwidths, (~~($_.checksum / 9)) * 5, 5); //#8590
    $_.checkrtrev = $geti($_.checkwidths, ($_.checksum % 9) * 5, 5); //#8591
    $_.checkrt = $a(5); //#8592
    for (var _6N = 0; _6N <= 4; _6N += 1) { //#8596
        $_.i = _6N; //#8594
        $put($_.checkrt, $_.i, $get($_.checkrtrev, 4 - $_.i)); //#8595
    } //#8595
    if ($eq($_.format, "omni") || $eq($_.format, "truncated")) { //#8724
        $k[$j++] = Infinity; //#8601
        var _6V = $_.d1w; //#8602
        $k[$j++] = 1; //#8602
        for (var _6W = 0, _6X = _6V.length; _6W < _6X; _6W++) { //#8602
            $k[$j++] = $get(_6V, _6W); //#8602
        } //#8602
        var _6Z = $_.checklt; //#8602
        for (var _6a = 0, _6b = _6Z.length; _6a < _6b; _6a++) { //#8602
            $k[$j++] = $get(_6Z, _6a); //#8602
        } //#8602
        var _6d = $_.d2w; //#8602
        for (var _6e = 0, _6f = _6d.length; _6e < _6f; _6e++) { //#8602
            $k[$j++] = $get(_6d, _6e); //#8602
        } //#8602
        var _6h = $_.d4w; //#8603
        for (var _6i = 0, _6j = _6h.length; _6i < _6j; _6i++) { //#8603
            $k[$j++] = $get(_6h, _6i); //#8603
        } //#8603
        var _6l = $_.checkrt; //#8603
        for (var _6m = 0, _6n = _6l.length; _6m < _6n; _6m++) { //#8603
            $k[$j++] = $get(_6l, _6m); //#8603
        } //#8603
        var _6p = $_.d3w; //#8603
        for (var _6q = 0, _6r = _6p.length; _6q < _6r; _6q++) { //#8603
            $k[$j++] = $get(_6p, _6q); //#8603
        } //#8603
        $k[$j++] = 1; //#8603
        $k[$j++] = 1; //#8603
        $_.sbs = $a(); //#8603
        $k[$j++] = Infinity; //#8606
        var _6u = $_.sbs; //#8608
        $k[$j++] = Infinity; //#8609
        for (var _6w = 0, _6x = ~~(($_.sbs.length + 1) / 2); _6w < _6x; _6w++) { //#8609
            $k[$j++] = $_.height; //#8609
        } //#8609
        var _6z = $a(); //#8609
        $k[$j++] = Infinity; //#8610
        for (var _71 = 0, _72 = ~~(($_.sbs.length + 1) / 2); _71 < _72; _71++) { //#8610
            $k[$j++] = 0; //#8610
        } //#8610
        var _73 = $a(); //#8610
        $k[$j++] = 'ren'; //#8615
        $k[$j++] = 'renlinear'; //#8615
        $k[$j++] = 'sbs'; //#8615
        $k[$j++] = _6u; //#8615
        $k[$j++] = 'bhs'; //#8615
        $k[$j++] = _6z; //#8615
        $k[$j++] = 'bbs'; //#8615
        $k[$j++] = _73; //#8615
        $k[$j++] = 'txt'; //#8615
        $k[$j++] = $_.txt; //#8615
        $k[$j++] = 'textxalign'; //#8615
        $k[$j++] = "center"; //#8615
        $k[$j++] = 'borderleft'; //#8615
        $k[$j++] = 0; //#8615
        $k[$j++] = 'borderright'; //#8615
        $k[$j++] = 0; //#8615
        $k[$j++] = 'opt'; //#8615
        $k[$j++] = $_.options; //#8615
        var _76 = $d(); //#8615
        $k[$j++] = _76; //#8618
        if (!$_.dontdraw) { //#8618
            bwipp_renlinear(); //#8618
        } //#8618
    } else { //#8724
        $k[$j++] = Infinity; //#8622
        var _78 = $_.d1w; //#8622
        $k[$j++] = 1; //#8622
        $k[$j++] = 1; //#8622
        for (var _79 = 0, _7A = _78.length; _79 < _7A; _79++) { //#8622
            $k[$j++] = $get(_78, _79); //#8622
        } //#8622
        var _7C = $_.checklt; //#8622
        for (var _7D = 0, _7E = _7C.length; _7D < _7E; _7D++) { //#8622
            $k[$j++] = $get(_7C, _7D); //#8622
        } //#8622
        var _7G = $_.d2w; //#8622
        for (var _7H = 0, _7I = _7G.length; _7H < _7I; _7H++) { //#8622
            $k[$j++] = $get(_7G, _7H); //#8622
        } //#8622
        $k[$j++] = 1; //#8622
        $k[$j++] = 1; //#8622
        $k[$j++] = 0; //#8622
        $_.top = $a(); //#8622
        $k[$j++] = Infinity; //#8623
        var _7L = $_.d4w; //#8623
        $k[$j++] = 1; //#8623
        $k[$j++] = 1; //#8623
        for (var _7M = 0, _7N = _7L.length; _7M < _7N; _7M++) { //#8623
            $k[$j++] = $get(_7L, _7M); //#8623
        } //#8623
        var _7P = $_.checkrt; //#8623
        for (var _7Q = 0, _7R = _7P.length; _7Q < _7R; _7Q++) { //#8623
            $k[$j++] = $get(_7P, _7Q); //#8623
        } //#8623
        var _7T = $_.d3w; //#8623
        for (var _7U = 0, _7V = _7T.length; _7U < _7V; _7U++) { //#8623
            $k[$j++] = $get(_7T, _7U); //#8623
        } //#8623
        $k[$j++] = 1; //#8623
        $k[$j++] = 1; //#8623
        $k[$j++] = 0; //#8623
        $_.bot = $a(); //#8623
        for (var _7Y = 0; _7Y <= 24; _7Y += 2) { //#8628
            $_.i = _7Y; //#8625
            for (var _7c = 0, _7d = $get($_.top, $_.i); _7c < _7d; _7c++) { //#8626
                $k[$j++] = 0; //#8626
            } //#8626
            for (var _7h = 0, _7i = $get($_.top, $_.i + 1); _7h < _7i; _7h++) { //#8627
                $k[$j++] = 1; //#8627
            } //#8627
        } //#8627
        $astore($a(50)); //#8629
        $_.top = $k[--$j]; //#8629
        for (var _7l = 0; _7l <= 24; _7l += 2) { //#8634
            $_.i = _7l; //#8631
            for (var _7p = 0, _7q = $get($_.bot, $_.i); _7p < _7q; _7p++) { //#8632
                $k[$j++] = 1; //#8632
            } //#8632
            for (var _7u = 0, _7v = $get($_.bot, $_.i + 1); _7u < _7v; _7u++) { //#8633
                $k[$j++] = 0; //#8633
            } //#8633
        } //#8633
        $astore($a(50)); //#8635
        $_.bot = $k[--$j]; //#8635
        if ($eq($_.format, "stacked")) { //#8657
            $_.sep = $a(50); //#8639
            $put($_.sep, 0, 0); //#8640
            for (var _81 = 1; _81 <= 49; _81 += 1) { //#8648
                $_.i = _81; //#8642
                if ($eq($get($_.top, $_.i), $get($_.bot, $_.i))) { //#8646
                    $put($_.sep, $_.i, $f(1 - $get($_.top, $_.i))); //#8644
                } else { //#8646
                    $put($_.sep, $_.i, $f(1 - $get($_.sep, $_.i - 1))); //#8646
                } //#8646
            } //#8646
            $puti($_.sep, 0, $a([0, 0, 0, 0])); //#8649
            $puti($_.sep, 46, $a([0, 0, 0, 0])); //#8650
            $k[$j++] = Infinity; //#8651
            for (var _8M = 0, _8N = 5; _8M < _8N; _8M++) { //#8652
                $aload($_.top); //#8652
            } //#8652
            $aload($_.sep); //#8653
            for (var _8Q = 0, _8R = 7; _8Q < _8R; _8Q++) { //#8654
                $aload($_.bot); //#8654
            } //#8654
            $_.pixs = $a(); //#8654
            $_.pixy = ~~($_.pixs.length / 50); //#8656
        } //#8656
        if ($eq($_.format, "stackedomni")) { //#8707
            $k[$j++] = Infinity; //#8661
            $forall($_.top, function() { //#8661
                var _8X = $k[--$j]; //#8661
                $k[$j++] = $f(1 - _8X); //#8661
            }); //#8661
            $_.sep1 = $a(); //#8661
            $puti($_.sep1, 0, $a([0, 0, 0, 0])); //#8662
            $puti($_.sep1, 46, $a([0, 0, 0, 0])); //#8663
            for (var _8d = 18; _8d <= 30; _8d += 1) { //#8676
                $_.i = _8d; //#8665
                if ($get($_.top, $_.i) == 0) { //#8673
                    if ($get($_.top, $_.i - 1) == 1) { //#8670
                        $k[$j++] = 1; //#8668
                    } else { //#8670
                        var _8n = ($get($_.sep1, $_.i - 1) == 0) ? 1 : 0; //#8670
                        $k[$j++] = _8n; //#8670
                    } //#8670
                } else { //#8673
                    $k[$j++] = 0; //#8673
                } //#8673
                $put($_.sep1, $_.i, $k[--$j]); //#8675
            } //#8675
            $k[$j++] = Infinity; //#8677
            $k[$j++] = 0; //#8677
            $k[$j++] = 0; //#8677
            $k[$j++] = 0; //#8677
            $k[$j++] = 0; //#8677
            for (var _8r = 0, _8s = 21; _8r < _8s; _8r++) { //#8677
                $k[$j++] = 0; //#8677
                $k[$j++] = 1; //#8677
            } //#8677
            $k[$j++] = 0; //#8677
            $k[$j++] = 0; //#8677
            $k[$j++] = 0; //#8677
            $k[$j++] = 0; //#8677
            $_.sep2 = $a(); //#8677
            $k[$j++] = Infinity; //#8678
            $forall($_.bot, function() { //#8678
                var _8v = $k[--$j]; //#8678
                $k[$j++] = $f(1 - _8v); //#8678
            }); //#8678
            $_.sep3 = $a(); //#8678
            $puti($_.sep3, 0, $a([0, 0, 0, 0])); //#8679
            $puti($_.sep3, 46, $a([0, 0, 0, 0])); //#8680
            for (var _91 = 19; _91 <= 31; _91 += 1) { //#8693
                $_.i = _91; //#8682
                if ($get($_.bot, $_.i) == 0) { //#8690
                    if ($get($_.bot, $_.i - 1) == 1) { //#8687
                        $k[$j++] = 1; //#8685
                    } else { //#8687
                        var _9B = ($get($_.sep3, $_.i - 1) == 0) ? 1 : 0; //#8687
                        $k[$j++] = _9B; //#8687
                    } //#8687
                } else { //#8690
                    $k[$j++] = 0; //#8690
                } //#8690
                $put($_.sep3, $_.i, $k[--$j]); //#8692
            } //#8692
            $_.f3 = $a([1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1]); //#8694
            $k[$j++] = true; //#8695
            for (var _9G = 0; _9G <= 12; _9G += 1) { //#8695
                var _9L = $k[--$j]; //#8695
                $k[$j++] = _9L && $eq($get($_.bot, _9G + 19), $get($_.f3, _9G)); //#8695
            } //#8695
            if ($k[--$j]) { //#8698
                $puti($_.sep3, 19, $a([0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0])); //#8697
            } //#8697
            $k[$j++] = Infinity; //#8699
            for (var _9Q = 0, _9R = $_.barxmult; _9Q < _9R; _9Q++) { //#8700
                $aload($_.top); //#8700
            } //#8700
            $aload($_.sep1); //#8701
            $aload($_.sep2); //#8702
            $aload($_.sep3); //#8703
            for (var _9X = 0, _9Y = $_.barxmult; _9X < _9Y; _9X++) { //#8704
                $aload($_.bot); //#8704
            } //#8704
            $_.pixs = $a(); //#8704
            $_.pixy = ~~($_.pixs.length / 50); //#8706
        } //#8706
        var _9g = new Map([
            ["ren", 'renmatrix'],
            ["pixs", $_.pixs],
            ["pixx", 50],
            ["pixy", $_.pixy],
            ["height", $_.pixy / 72],
            ["width", 50 / 72],
            ["borderleft", 0],
            ["borderright", 0],
            ["bordertop", 0],
            ["borderbottom", 0],
            ["opt", $_.options]
        ]); //#8721
        $k[$j++] = _9g; //#8724
        if (!$_.dontdraw) { //#8724
            bwipp_renmatrix(); //#8724
        } //#8724
    } //#8724
    $_ = Object.getPrototypeOf($_); //#8728
    $_ = Object.getPrototypeOf($_); //#8730
} //bwipp_databaromni
function bwipp_databarstacked() {
    $_ = Object.create($_); //#8759
    $_.dontdraw = false; //#8762
    $k[$j++] = $_; //#8764
    bwipp_processoptions(); //#8764
    $_.options = $k[--$j]; //#8764
    $_.barcode = $k[--$j]; //#8765
    if (($_.barcode.length != 17) && ($_.barcode.length != 18)) { //#8770
        $k[$j++] = 'bwipp.databarstackedBadLength#8769'; //#8769
        $k[$j++] = "GS1 DataBar Stacked must be 13 or 14 digits"; //#8769
        bwipp_raiseerror(); //#8769
    } //#8769
    if ($ne($geti($_.barcode, 0, 4), "(01)")) { //#8773
        $k[$j++] = 'bwipp.databarstackedBadAI#8772'; //#8772
        $k[$j++] = "GS1 DataBar Stacked must begin with (01) application identifier"; //#8772
        bwipp_raiseerror(); //#8772
    } //#8772
    var _8 = $geti($_.barcode, 4, $_.barcode.length - 4); //#8774
    for (var _9 = 0, _A = _8.length; _9 < _A; _9++) { //#8778
        var _B = $get(_8, _9); //#8778
        if ((_B < 48) || (_B > 57)) { //#8777
            $k[$j++] = 'bwipp.databarstackedBadCharacter#8776'; //#8776
            $k[$j++] = "GS1 DataBar Stacked must contain only digits"; //#8776
            bwipp_raiseerror(); //#8776
        } //#8776
    } //#8776
    $_.checksum = 0; //#8781
    for (var _C = 0; _C <= 12; _C += 1) { //#8785
        $_.i = _C; //#8783
        $k[$j++] = 'checksum'; //#8784
        $k[$j++] = $_.checksum; //#8784
        $k[$j++] = $f($get($_.barcode, $_.i + 4) - 48); //#8784
        if (($_.i % 2) == 0) { //#8784
            var _I = $k[--$j]; //#8784
            $k[$j++] = _I * 3; //#8784
        } //#8784
        var _J = $k[--$j]; //#8784
        var _K = $k[--$j]; //#8784
        $_[$k[--$j]] = $f(_K + _J); //#8784
    } //#8784
    $_.checksum = (10 - ($_.checksum % 10)) % 10; //#8786
    if ($_.barcode.length == 18) { //#8791
        if ($get($_.barcode, 17) != ($_.checksum + 48)) { //#8790
            $k[$j++] = 'bwipp.databarstackedBadCheckDigit#8789'; //#8789
            $k[$j++] = "Incorrect GS1 DataBar Stacked check digit provided"; //#8789
            bwipp_raiseerror(); //#8789
        } //#8789
    } //#8789
    var _R = $s(18); //#8792
    $puti(_R, 0, $_.barcode); //#8793
    $put(_R, 17, $_.checksum + 48); //#8794
    $_.barcode = _R; //#8795
    $put($_.options, "dontdraw", true); //#8798
    $put($_.options, "format", "stacked"); //#8799
    $k[$j++] = 'args'; //#8801
    $k[$j++] = $_.barcode; //#8801
    $k[$j++] = $_.options; //#8801
    bwipp_databaromni(); //#8801
    var _Y = $k[--$j]; //#8801
    $_[$k[--$j]] = _Y; //#8801
    $put($_.args, "opt", $_.options); //#8803
    $k[$j++] = $_.args; //#8806
    if (!$_.dontdraw) { //#8806
        bwipp_renmatrix(); //#8806
    } //#8806
    $_ = Object.getPrototypeOf($_); //#8808
} //bwipp_databarstacked
function bwipp_databarstackedomni() {
    $_ = Object.create($_); //#8837
    $_.dontdraw = false; //#8840
    $k[$j++] = $_; //#8842
    bwipp_processoptions(); //#8842
    $_.options = $k[--$j]; //#8842
    $_.barcode = $k[--$j]; //#8843
    if ($ne($geti($_.barcode, 0, 4), "(01)")) { //#8848
        $k[$j++] = 'bwipp.databarstackedomniBadAI#8847'; //#8847
        $k[$j++] = "GS1 DataBar Stacked Omnidirectional must begin with (01) application identifier"; //#8847
        bwipp_raiseerror(); //#8847
    } //#8847
    if (($_.barcode.length != 17) && ($_.barcode.length != 18)) { //#8851
        $k[$j++] = 'bwipp.databarstackedomniBadLength#8850'; //#8850
        $k[$j++] = "GS1 DataBar Stacked Omnidirectional must be 13 or 14 digits"; //#8850
        bwipp_raiseerror(); //#8850
    } //#8850
    var _8 = $geti($_.barcode, 4, $_.barcode.length - 4); //#8852
    for (var _9 = 0, _A = _8.length; _9 < _A; _9++) { //#8856
        var _B = $get(_8, _9); //#8856
        if ((_B < 48) || (_B > 57)) { //#8855
            $k[$j++] = 'bwipp.databarstackedomniBadCharacter#8854'; //#8854
            $k[$j++] = "GS1 DataBar Stacked Omnidirectional must contain only digits"; //#8854
            bwipp_raiseerror(); //#8854
        } //#8854
    } //#8854
    $_.checksum = 0; //#8859
    for (var _C = 0; _C <= 12; _C += 1) { //#8863
        $_.i = _C; //#8861
        $k[$j++] = 'checksum'; //#8862
        $k[$j++] = $_.checksum; //#8862
        $k[$j++] = $f($get($_.barcode, $_.i + 4) - 48); //#8862
        if (($_.i % 2) == 0) { //#8862
            var _I = $k[--$j]; //#8862
            $k[$j++] = _I * 3; //#8862
        } //#8862
        var _J = $k[--$j]; //#8862
        var _K = $k[--$j]; //#8862
        $_[$k[--$j]] = $f(_K + _J); //#8862
    } //#8862
    $_.checksum = (10 - ($_.checksum % 10)) % 10; //#8864
    if ($_.barcode.length == 18) { //#8869
        if ($get($_.barcode, 17) != ($_.checksum + 48)) { //#8868
            $k[$j++] = 'bwipp.databarstackedomniBadCheckDigit#8867'; //#8867
            $k[$j++] = "Incorrect GS1 DataBar Stacked Omnidirectional check digit provided"; //#8867
            bwipp_raiseerror(); //#8867
        } //#8867
    } //#8867
    var _R = $s(18); //#8870
    $puti(_R, 0, $_.barcode); //#8871
    $put(_R, 17, $_.checksum + 48); //#8872
    $_.barcode = _R; //#8873
    $put($_.options, "dontdraw", true); //#8876
    $put($_.options, "format", "stackedomni"); //#8877
    $k[$j++] = 'args'; //#8879
    $k[$j++] = $_.barcode; //#8879
    $k[$j++] = $_.options; //#8879
    bwipp_databaromni(); //#8879
    var _Y = $k[--$j]; //#8879
    $_[$k[--$j]] = _Y; //#8879
    $put($_.args, "opt", $_.options); //#8881
    $k[$j++] = $_.args; //#8884
    if (!$_.dontdraw) { //#8884
        bwipp_renmatrix(); //#8884
    } //#8884
    $_ = Object.getPrototypeOf($_); //#8886
} //bwipp_databarstackedomni
function bwipp_databartruncated() {
    $_ = Object.create($_); //#8915
    $_.dontdraw = false; //#8918
    $k[$j++] = $_; //#8920
    bwipp_processoptions(); //#8920
    $_.options = $k[--$j]; //#8920
    $_.barcode = $k[--$j]; //#8921
    if (($_.barcode.length != 17) && ($_.barcode.length != 18)) { //#8926
        $k[$j++] = 'bwipp.databartruncatedBadLength#8925'; //#8925
        $k[$j++] = "GS1 DataBar Truncated must be 13 or 14 digits"; //#8925
        bwipp_raiseerror(); //#8925
    } //#8925
    if ($ne($geti($_.barcode, 0, 4), "(01)")) { //#8929
        $k[$j++] = 'bwipp.databartruncatedBadAI#8928'; //#8928
        $k[$j++] = "GS1 DataBar Truncated must begin with (01) application identifier"; //#8928
        bwipp_raiseerror(); //#8928
    } //#8928
    var _8 = $geti($_.barcode, 4, $_.barcode.length - 4); //#8930
    for (var _9 = 0, _A = _8.length; _9 < _A; _9++) { //#8934
        var _B = $get(_8, _9); //#8934
        if ((_B < 48) || (_B > 57)) { //#8933
            $k[$j++] = 'bwipp.databartruncatedBadCharacter#8932'; //#8932
            $k[$j++] = "GS1 DataBar Truncated must contain only digits"; //#8932
            bwipp_raiseerror(); //#8932
        } //#8932
    } //#8932
    $_.checksum = 0; //#8937
    for (var _C = 0; _C <= 12; _C += 1) { //#8941
        $_.i = _C; //#8939
        $k[$j++] = 'checksum'; //#8940
        $k[$j++] = $_.checksum; //#8940
        $k[$j++] = $f($get($_.barcode, $_.i + 4) - 48); //#8940
        if (($_.i % 2) == 0) { //#8940
            var _I = $k[--$j]; //#8940
            $k[$j++] = _I * 3; //#8940
        } //#8940
        var _J = $k[--$j]; //#8940
        var _K = $k[--$j]; //#8940
        $_[$k[--$j]] = $f(_K + _J); //#8940
    } //#8940
    $_.checksum = (10 - ($_.checksum % 10)) % 10; //#8942
    if ($_.barcode.length == 18) { //#8947
        if ($get($_.barcode, 17) != ($_.checksum + 48)) { //#8946
            $k[$j++] = 'bwipp.databartruncatedBadCheckDigit#8945'; //#8945
            $k[$j++] = "Incorrect GS1 DataBar Truncated check digit provided"; //#8945
            bwipp_raiseerror(); //#8945
        } //#8945
    } //#8945
    var _R = $s(18); //#8948
    $puti(_R, 0, $_.barcode); //#8949
    $put(_R, 17, $_.checksum + 48); //#8950
    $_.barcode = _R; //#8951
    $put($_.options, "dontdraw", true); //#8954
    $put($_.options, "format", "truncated"); //#8955
    $k[$j++] = 'args'; //#8957
    $k[$j++] = $_.barcode; //#8957
    $k[$j++] = $_.options; //#8957
    bwipp_databaromni(); //#8957
    var _Y = $k[--$j]; //#8957
    $_[$k[--$j]] = _Y; //#8957
    $put($_.args, "opt", $_.options); //#8959
    $k[$j++] = $_.args; //#8962
    if (!$_.dontdraw) { //#8962
        bwipp_renlinear(); //#8962
    } //#8962
    $_ = Object.getPrototypeOf($_); //#8964
} //bwipp_databartruncated
function bwipp_databarlimited() {
    $_ = Object.create($_); //#8994
    $_.dontdraw = false; //#8997
    $_.height = 10 / 72; //#8998
    $_.linkage = false; //#8999
    $k[$j++] = $_; //#9001
    bwipp_processoptions(); //#9001
    $_.options = $k[--$j]; //#9001
    $_.barcode = $k[--$j]; //#9002
    bwipp_loadctx(bwipp_databarlimited) //#9004
    if (($_.barcode.length != 17) && ($_.barcode.length != 18)) { //#9009
        $k[$j++] = 'bwipp.databarlimitedBadLength#9008'; //#9008
        $k[$j++] = "GS1 DataBar Limited must be 13 or 14 digits"; //#9008
        bwipp_raiseerror(); //#9008
    } //#9008
    if ($ne($geti($_.barcode, 0, 4), "(01)")) { //#9012
        $k[$j++] = 'bwipp.databarlimitedBadAI#9011'; //#9011
        $k[$j++] = "GS1 DataBar Limited must begin with (01) application identifier"; //#9011
        bwipp_raiseerror(); //#9011
    } //#9011
    var _7 = $get($_.barcode, 4); //#9013
    if ((_7 < 48) || (_7 > 49)) { //#9015
        $k[$j++] = 'bwipp.databarlimitedBadStartDigit#9014'; //#9014
        $k[$j++] = "GS1 DataBar Limited must begin with 0 or 1"; //#9014
        bwipp_raiseerror(); //#9014
    } //#9014
    var _A = $geti($_.barcode, 5, $_.barcode.length - 5); //#9016
    for (var _B = 0, _C = _A.length; _B < _C; _B++) { //#9020
        var _D = $get(_A, _B); //#9020
        if ((_D < 48) || (_D > 57)) { //#9019
            $k[$j++] = 'bwipp.databarlimitedBadCharacter#9018'; //#9018
            $k[$j++] = "GS1 DataBar Limited must contain only digits"; //#9018
            bwipp_raiseerror(); //#9018
        } //#9018
    } //#9018
    $_.checksum = 0; //#9023
    for (var _E = 0; _E <= 12; _E += 1) { //#9027
        $_.i = _E; //#9025
        $k[$j++] = 'checksum'; //#9026
        $k[$j++] = $_.checksum; //#9026
        $k[$j++] = $f($get($_.barcode, $_.i + 4) - 48); //#9026
        if (($_.i % 2) == 0) { //#9026
            var _K = $k[--$j]; //#9026
            $k[$j++] = _K * 3; //#9026
        } //#9026
        var _L = $k[--$j]; //#9026
        var _M = $k[--$j]; //#9026
        $_[$k[--$j]] = $f(_M + _L); //#9026
    } //#9026
    $_.checksum = (10 - ($_.checksum % 10)) % 10; //#9028
    if ($_.barcode.length == 18) { //#9033
        if ($get($_.barcode, 17) != ($_.checksum + 48)) { //#9032
            $k[$j++] = 'bwipp.databarlimitedBadCheckDigit#9031'; //#9031
            $k[$j++] = "Incorrect GS1 DataBar Limited check digit provided"; //#9031
            bwipp_raiseerror(); //#9031
        } //#9031
    } //#9031
    var _T = $s(18); //#9034
    $puti(_T, 0, $_.barcode); //#9035
    $put(_T, 17, $_.checksum + 48); //#9036
    $_.barcode = _T; //#9037
    if (!bwipp_databarlimited.__9042__) { //#9042
        $_ = Object.create($_); //#9042
        $_.linkval = $a([2, 0, 1, 5, 1, 3, 3, 5, 3, 1, 0, 9, 6]); //#9041
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_databarlimited.$ctx[id] = $_[id]); //#9041
        bwipp_databarlimited.__9042__ = 1; //#9041
        $_ = Object.getPrototypeOf($_); //#9041
    } //#9041
    $k[$j++] = Infinity; //#9043
    var _Z = $geti($_.barcode, 4, 13); //#9044
    for (var _a = 0, _b = _Z.length; _a < _b; _a++) { //#9044
        $k[$j++] = $f($get(_Z, _a) - 48); //#9044
    } //#9044
    $_.binval = $a(); //#9044
    if ($_.linkage) { //#9051
        for (var _h = 0, _g = $_.binval.length - 1; _h <= _g; _h += 1) { //#9050
            $_.i = _h; //#9048
            $put($_.binval, $_.i, $f($get($_.binval, $_.i) + $get($_.linkval, $_.i))); //#9049
        } //#9049
    } //#9049
    $_.txt = $a($_.barcode.length); //#9054
    for (var _u = 0, _t = $_.barcode.length - 1; _u <= _t; _u += 1) { //#9058
        $_.i = _u; //#9056
        $put($_.txt, $_.i, $a([$geti($_.barcode, $_.i, 1), 0, 0, "", 0])); //#9057
    } //#9057
    $_.ncr = function() {
        var _11 = $k[--$j]; //#9061
        var _12 = $k[--$j]; //#9061
        var _13 = $f(_12 - _11); //#9061
        if (_11 < $f(_12 - _11)) { //#9061
            var _ = _13; //#9061
            _13 = _11; //#9061
            _11 = _; //#9061
        } //#9061
        $k[$j++] = _13; //#9068
        $k[$j++] = 1; //#9068
        $k[$j++] = 1; //#9068
        for (var _15 = _12, _14 = $f(_11 + 1); _15 >= _14; _15 -= 1) { //#9068
            var _16 = $k[--$j]; //#9064
            var _17 = $k[--$j]; //#9065
            var _18 = $k[--$j]; //#9065
            $k[$j++] = _18; //#9067
            $k[$j++] = _17; //#9067
            $k[$j++] = _16 * _15; //#9067
            if ($le(_17, _18)) { //#9067
                var _19 = $k[--$j]; //#9066
                var _1A = $k[--$j]; //#9066
                $k[$j++] = $f(_1A + 1); //#9066
                $k[$j++] = ~~(_19 / _1A); //#9066
            } //#9066
        } //#9066
        for (;;) { //#9072
            var _1B = $k[--$j]; //#9070
            var _1C = $k[--$j]; //#9070
            var _1D = $k[--$j]; //#9070
            $k[$j++] = _1D; //#9070
            $k[$j++] = _1C; //#9070
            $k[$j++] = _1B; //#9070
            if ($gt(_1C, _1D)) { //#9070
                break; //#9070
            } //#9070
            var _1E = $k[--$j]; //#9071
            var _1F = $k[--$j]; //#9071
            $k[$j++] = $f(_1F + 1); //#9071
            $k[$j++] = ~~(_1E / _1F); //#9071
        } //#9071
        var _1G = $k[--$j]; //#9073
        var _1H = $k[--$j]; //#9073
        $k[$j++] = _1G; //#9073
        $k[$j++] = _1H; //#9073
        $j--; //#9073
        var _1I = $k[--$j]; //#9073
        var _1J = $k[--$j]; //#9073
        $k[$j++] = _1I; //#9073
        $k[$j++] = _1J; //#9073
        $j--; //#9073
    }; //#9073
    $_.getRSSwidths = function() {
        $_.oe = $k[--$j]; //#9077
        $_.el = $k[--$j]; //#9078
        $_.mw = $k[--$j]; //#9079
        $_.nm = $k[--$j]; //#9080
        $_.val = $k[--$j]; //#9081
        $_.out = $a($_.el); //#9082
        $_.mask = 0; //#9083
        for (var _1T = 0, _1S = $f($_.el - 2); _1T <= _1S; _1T += 1) { //#9110
            $_.bar = _1T; //#9085
            $_.ew = 1; //#9086
            var _1V = $_.bar; //#9087
            $_.mask = $_.mask | ((_1V < 0 ? 1 >>> -_1V : 1 << _1V)); //#9087
            for (;;) { //#9106
                $k[$j++] = 'sval'; //#9088
                $k[$j++] = $f($f($_.nm - $_.ew) - 1); //#9088
                $k[$j++] = $f($f($_.el - $_.bar) - 2); //#9088
                $_.ncr(); //#9088
                var _1a = $k[--$j]; //#9088
                $_[$k[--$j]] = _1a; //#9088
                if (($_.oe && ($_.mask == 0)) && (($f(($f($f($_.nm - $_.ew) - ($_.el * 2))) + ($_.bar * 2))) >= -2)) { //#9091
                    $k[$j++] = 'sval'; //#9090
                    $k[$j++] = $_.sval; //#9090
                    $k[$j++] = $f(($f($f($_.nm - $_.ew) - $_.el)) + $_.bar); //#9090
                    $k[$j++] = $f($f($_.el - $_.bar) - 2); //#9090
                    $_.ncr(); //#9090
                    var _1p = $k[--$j]; //#9090
                    var _1q = $k[--$j]; //#9090
                    $_[$k[--$j]] = $f(_1q - _1p); //#9090
                } //#9090
                if ($f($_.el - $_.bar) > 2) { //#9100
                    $_.lval = 0; //#9093
                    for (var _20 = $f(($f(($f($f($_.nm - $_.ew) - $_.el)) + $_.bar)) + 2), _1z = $f($_.mw + 1); _20 >= _1z; _20 -= 1) { //#9097
                        $k[$j++] = $f(($f($f($_.nm - _20) - $_.ew)) - 1); //#9095
                        $k[$j++] = $f($f($_.el - $_.bar) - 3); //#9095
                        $_.ncr(); //#9095
                        $_.lval = $f($k[--$j] + $_.lval); //#9096
                    } //#9096
                    $_.sval = $f($_.sval - ($_.lval * ($f($f($_.el - $_.bar) - 1)))); //#9098
                } else { //#9100
                    if ($f($_.nm - $_.ew) > $_.mw) { //#9100
                        $_.sval = $f($_.sval - 1); //#9100
                    } //#9100
                } //#9100
                $_.val = $f($_.val - $_.sval); //#9102
                if ($_.val < 0) { //#9103
                    break; //#9103
                } //#9103
                $_.ew = $_.ew + 1; //#9104
                var _2K = $_.bar; //#9105
                $_.mask = $_.mask & (~((_2K < 0 ? 1 >>> -_2K : 1 << _2K))); //#9105
            } //#9105
            $_.val = $f($_.val + $_.sval); //#9107
            $_.nm = $f($_.nm - $_.ew); //#9108
            $put($_.out, $_.bar, $_.ew); //#9109
        } //#9109
        $put($_.out, $f($_.el - 1), $_.nm); //#9111
        $k[$j++] = $_.out; //#9112
    }; //#9112
    for (var _2W = 0; _2W <= 11; _2W += 1) { //#9119
        $_.i = _2W; //#9116
        var _2X = $_.binval; //#9117
        var _2Y = $_.i; //#9117
        $put(_2X, _2Y + 1, $f($get(_2X, _2Y + 1) + (($get($_.binval, $_.i) % 2013571) * 10))); //#9117
        $put($_.binval, $_.i, ~~($get($_.binval, $_.i) / 2013571)); //#9118
    } //#9118
    $_.d2 = $get($_.binval, 12) % 2013571; //#9120
    var _2k = $_.binval; //#9121
    $put(_2k, 12, ~~($get(_2k, 12) / 2013571)); //#9121
    $_.d1 = 0; //#9123
    $_.i = true; //#9124
    for (var _2m = 0; _2m <= 12; _2m += 1) { //#9134
        $_.j = _2m; //#9126
        var _2p = $get($_.binval, $_.j); //#9127
        $k[$j++] = _2p; //#9133
        if ((_2p == 0) && $_.i) { //#9132
            $j--; //#9129
        } else { //#9132
            $_.i = false; //#9131
            $_.d1 = $f($_.d1 + ($k[--$j] * (~~Math.pow(10, 12 - $_.j)))); //#9132
        } //#9132
    } //#9132
    if (!bwipp_databarlimited.__9146__) { //#9146
        $_ = Object.create($_); //#9146
        $_.tab267 = $a([183063, 0, 17, 9, 6, 3, 6538, 28, 820063, 183064, 13, 13, 5, 4, 875, 728, 1000775, 820064, 9, 17, 3, 6, 28, 6454, 1491020, 1000776, 15, 11, 5, 4, 2415, 203, 1979844, 1491021, 11, 15, 4, 5, 203, 2408, 1996938, 1979845, 19, 7, 8, 1, 17094, 1, 2013570, 1996939, 7, 19, 1, 8, 1, 16632]); //#9145
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_databarlimited.$ctx[id] = $_[id]); //#9145
        bwipp_databarlimited.__9146__ = 1; //#9145
        $_ = Object.getPrototypeOf($_); //#9145
    } //#9145
    $_.i = 0; //#9148
    for (;;) { //#9158
        if ($_.d1 <= $get($_.tab267, $_.i)) { //#9156
            var _32 = $geti($_.tab267, $_.i + 1, 7); //#9150
            for (var _33 = 0, _34 = _32.length; _33 < _34; _33++) { //#9150
                $k[$j++] = $get(_32, _33); //#9150
            } //#9150
            $_.d1te = $k[--$j]; //#9151
            $_.d1to = $k[--$j]; //#9151
            $_.d1mwe = $k[--$j]; //#9152
            $_.d1mwo = $k[--$j]; //#9152
            $_.d1ele = $k[--$j]; //#9153
            $_.d1elo = $k[--$j]; //#9153
            $_.d1gs = $k[--$j]; //#9154
            break; //#9155
        } //#9155
        $_.i = $_.i + 8; //#9157
    } //#9157
    $_.i = 0; //#9160
    for (;;) { //#9170
        if ($_.d2 <= $get($_.tab267, $_.i)) { //#9168
            var _3K = $geti($_.tab267, $_.i + 1, 7); //#9162
            for (var _3L = 0, _3M = _3K.length; _3L < _3M; _3L++) { //#9162
                $k[$j++] = $get(_3K, _3L); //#9162
            } //#9162
            $_.d2te = $k[--$j]; //#9163
            $_.d2to = $k[--$j]; //#9163
            $_.d2mwe = $k[--$j]; //#9164
            $_.d2mwo = $k[--$j]; //#9164
            $_.d2ele = $k[--$j]; //#9165
            $_.d2elo = $k[--$j]; //#9165
            $_.d2gs = $k[--$j]; //#9166
            break; //#9167
        } //#9167
        $_.i = $_.i + 8; //#9169
    } //#9169
    $k[$j++] = 'd1wo'; //#9172
    $k[$j++] = ~~($f($_.d1 - $_.d1gs) / $_.d1te); //#9172
    $k[$j++] = $_.d1elo; //#9172
    $k[$j++] = $_.d1mwo; //#9172
    $k[$j++] = 7; //#9172
    $k[$j++] = false; //#9172
    $_.getRSSwidths(); //#9172
    var _3b = $k[--$j]; //#9172
    $_[$k[--$j]] = _3b; //#9172
    $k[$j++] = 'd1we'; //#9173
    $k[$j++] = $f($_.d1 - $_.d1gs) % $_.d1te; //#9173
    $k[$j++] = $_.d1ele; //#9173
    $k[$j++] = $_.d1mwe; //#9173
    $k[$j++] = 7; //#9173
    $k[$j++] = true; //#9173
    $_.getRSSwidths(); //#9173
    var _3i = $k[--$j]; //#9173
    $_[$k[--$j]] = _3i; //#9173
    $k[$j++] = 'd2wo'; //#9174
    $k[$j++] = ~~($f($_.d2 - $_.d2gs) / $_.d2te); //#9174
    $k[$j++] = $_.d2elo; //#9174
    $k[$j++] = $_.d2mwo; //#9174
    $k[$j++] = 7; //#9174
    $k[$j++] = false; //#9174
    $_.getRSSwidths(); //#9174
    var _3p = $k[--$j]; //#9174
    $_[$k[--$j]] = _3p; //#9174
    $k[$j++] = 'd2we'; //#9175
    $k[$j++] = $f($_.d2 - $_.d2gs) % $_.d2te; //#9175
    $k[$j++] = $_.d2ele; //#9175
    $k[$j++] = $_.d2mwe; //#9175
    $k[$j++] = 7; //#9175
    $k[$j++] = true; //#9175
    $_.getRSSwidths(); //#9175
    var _3w = $k[--$j]; //#9175
    $_[$k[--$j]] = _3w; //#9175
    $_.d1w = $a(14); //#9177
    for (var _3z = 0; _3z <= 6; _3z += 1) { //#9182
        $_.i = _3z; //#9179
        $put($_.d1w, $_.i * 2, $get($_.d1wo, $_.i)); //#9180
        $put($_.d1w, ($_.i * 2) + 1, $get($_.d1we, $_.i)); //#9181
    } //#9181
    $_.d2w = $a(14); //#9184
    for (var _4B = 0; _4B <= 6; _4B += 1) { //#9189
        $_.i = _4B; //#9186
        $put($_.d2w, $_.i * 2, $get($_.d2wo, $_.i)); //#9187
        $put($_.d2w, ($_.i * 2) + 1, $get($_.d2we, $_.i)); //#9188
    } //#9188
    $k[$j++] = Infinity; //#9191
    var _4M = $_.d1w; //#9192
    for (var _4N = 0, _4O = _4M.length; _4N < _4O; _4N++) { //#9192
        $k[$j++] = $get(_4M, _4N); //#9192
    } //#9192
    var _4Q = $_.d2w; //#9193
    for (var _4R = 0, _4S = _4Q.length; _4R < _4S; _4R++) { //#9193
        $k[$j++] = $get(_4Q, _4R); //#9193
    } //#9193
    $_.widths = $a(); //#9193
    if (!bwipp_databarlimited.__9217__) { //#9217
        $_ = Object.create($_); //#9217
        $_.checkweights = $a([1, 3, 9, 27, 81, 65, 17, 51, 64, 14, 42, 37, 22, 66, 20, 60, 2, 6, 18, 54, 73, 41, 34, 13, 39, 28, 84, 74]); //#9200
        $k[$j++] = Infinity; //#9202
        for (var _4W = 0; _4W <= 43; _4W += 1) { //#9203
            $k[$j++] = _4W; //#9203
        } //#9203
        $k[$j++] = 45; //#9205
        $k[$j++] = 52; //#9205
        $k[$j++] = 57; //#9205
        for (var _4X = 63; _4X <= 66; _4X += 1) { //#9205
            $k[$j++] = _4X; //#9205
        } //#9205
        for (var _4Y = 73; _4Y <= 79; _4Y += 1) { //#9206
            $k[$j++] = _4Y; //#9206
        } //#9206
        $k[$j++] = 82; //#9208
        for (var _4Z = 126; _4Z <= 130; _4Z += 1) { //#9208
            $k[$j++] = _4Z; //#9208
        } //#9208
        $k[$j++] = 132; //#9210
        for (var _4a = 141; _4a <= 146; _4a += 1) { //#9210
            $k[$j++] = _4a; //#9210
        } //#9210
        for (var _4b = 210; _4b <= 217; _4b += 1) { //#9211
            $k[$j++] = _4b; //#9211
        } //#9211
        $k[$j++] = 220; //#9213
        for (var _4c = 316; _4c <= 320; _4c += 1) { //#9213
            $k[$j++] = _4c; //#9213
        } //#9213
        $k[$j++] = 322; //#9215
        $k[$j++] = 323; //#9215
        $k[$j++] = 326; //#9215
        $k[$j++] = 337; //#9215
        $_.checkseq = $a(); //#9215
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_databarlimited.$ctx[id] = $_[id]); //#9216
        bwipp_databarlimited.__9217__ = 1; //#9216
        $_ = Object.getPrototypeOf($_); //#9216
    } //#9216
    $_.checksum = 0; //#9219
    for (var _4f = 0; _4f <= 27; _4f += 1) { //#9223
        $_.i = _4f; //#9221
        $_.checksum = $f($_.checksum + ($get($_.widths, $_.i) * $get($_.checkweights, $_.i))); //#9222
    } //#9222
    $_.checksum = $_.checksum % 89; //#9224
    $_.seq = $get($_.checkseq, $_.checksum); //#9225
    $k[$j++] = 'swidths'; //#9226
    $k[$j++] = ~~($_.seq / 21); //#9226
    $k[$j++] = 8; //#9226
    $k[$j++] = 3; //#9226
    $k[$j++] = 6; //#9226
    $k[$j++] = false; //#9226
    $_.getRSSwidths(); //#9226
    var _4s = $k[--$j]; //#9226
    $_[$k[--$j]] = _4s; //#9226
    $k[$j++] = 'bwidths'; //#9227
    $k[$j++] = $_.seq % 21; //#9227
    $k[$j++] = 8; //#9227
    $k[$j++] = 3; //#9227
    $k[$j++] = 6; //#9227
    $k[$j++] = false; //#9227
    $_.getRSSwidths(); //#9227
    var _4v = $k[--$j]; //#9227
    $_[$k[--$j]] = _4v; //#9227
    $_.checkwidths = $a([0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1]); //#9229
    for (var _4y = 0; _4y <= 5; _4y += 1) { //#9234
        $_.i = _4y; //#9231
        $put($_.checkwidths, $_.i * 2, $get($_.swidths, $_.i)); //#9232
        $put($_.checkwidths, ($_.i * 2) + 1, $get($_.bwidths, $_.i)); //#9233
    } //#9233
    $k[$j++] = Infinity; //#9236
    var _59 = $_.d1w; //#9237
    $k[$j++] = 1; //#9237
    for (var _5A = 0, _5B = _59.length; _5A < _5B; _5A++) { //#9237
        $k[$j++] = $get(_59, _5A); //#9237
    } //#9237
    var _5D = $_.checkwidths; //#9237
    for (var _5E = 0, _5F = _5D.length; _5E < _5F; _5E++) { //#9237
        $k[$j++] = $get(_5D, _5E); //#9237
    } //#9237
    var _5H = $_.d2w; //#9237
    for (var _5I = 0, _5J = _5H.length; _5I < _5J; _5I++) { //#9237
        $k[$j++] = $get(_5H, _5I); //#9237
    } //#9237
    $k[$j++] = 1; //#9237
    $k[$j++] = 1; //#9237
    $k[$j++] = 5; //#9237
    $_.sbs = $a(); //#9237
    $k[$j++] = Infinity; //#9241
    var _5M = $_.sbs; //#9243
    $k[$j++] = Infinity; //#9244
    for (var _5O = 0, _5P = ~~(($_.sbs.length + 1) / 2); _5O < _5P; _5O++) { //#9244
        $k[$j++] = $_.height; //#9244
    } //#9244
    var _5R = $a(); //#9244
    $k[$j++] = Infinity; //#9245
    for (var _5T = 0, _5U = ~~(($_.sbs.length + 1) / 2); _5T < _5U; _5T++) { //#9245
        $k[$j++] = 0; //#9245
    } //#9245
    var _5V = $a(); //#9245
    $k[$j++] = 'ren'; //#9250
    $k[$j++] = 'renlinear'; //#9250
    $k[$j++] = 'sbs'; //#9250
    $k[$j++] = _5M; //#9250
    $k[$j++] = 'bhs'; //#9250
    $k[$j++] = _5R; //#9250
    $k[$j++] = 'bbs'; //#9250
    $k[$j++] = _5V; //#9250
    $k[$j++] = 'txt'; //#9250
    $k[$j++] = $_.txt; //#9250
    $k[$j++] = 'textxalign'; //#9250
    $k[$j++] = "center"; //#9250
    $k[$j++] = 'borderleft'; //#9250
    $k[$j++] = 0; //#9250
    $k[$j++] = 'borderright'; //#9250
    $k[$j++] = 0; //#9250
    $k[$j++] = 'opt'; //#9250
    $k[$j++] = $_.options; //#9250
    var _5Y = $d(); //#9250
    $k[$j++] = _5Y; //#9253
    if (!$_.dontdraw) { //#9253
        bwipp_renlinear(); //#9253
    } //#9253
    $_ = Object.getPrototypeOf($_); //#9255
    $_ = Object.getPrototypeOf($_); //#9257
} //bwipp_databarlimited
function bwipp_databarexpanded() {
    $_ = Object.create($_); //#9289
    $_.parse = false; //#9292
    $_.dontlint = false; //#9293
    $_.lintreqs = true; //#9294
    $_.dontdraw = false; //#9295
    $_.height = 34 / 72; //#9296
    $_.format = "expanded"; //#9297
    $_.segments = -1; //#9298
    $_.linkage = false; //#9299
    $_.barxmult = 34; //#9300
    $k[$j++] = $_; //#9302
    bwipp_processoptions(); //#9302
    $_.options = $k[--$j]; //#9302
    $_.barcode = $k[--$j]; //#9303
    bwipp_loadctx(bwipp_databarexpanded) //#9305
    if ($_.barxmult < 34) { //#9309
        $k[$j++] = 'bwipp.databarStackedOmniBarXmult#9308'; //#9308
        $k[$j++] = "GS1 DataBar Expanded Stacked must have a barxmult of at least 34"; //#9308
        bwipp_raiseerror(); //#9308
    } //#9308
    if ($ne($_.format, "expanded") && $ne($_.format, "expandedstacked")) { //#9313
        $k[$j++] = 'bwipp.databarexpandedBadFormat#9312'; //#9312
        $k[$j++] = "Valid formats are expanded and expandedstacked"; //#9312
        bwipp_raiseerror(); //#9312
    } //#9312
    if ($_.segments == -1) { //#9319
        var _7 = $eq($_.format, "expandedstacked") ? 4 : 22; //#9316
        $_.segments = _7; //#9316
    } else { //#9319
        if ((($_.segments < 2) || ($_.segments > 22)) || (($_.segments % 2) != 0)) { //#9320
            $k[$j++] = 'bwipp.gs1databarexpandedBadSegments#9319'; //#9319
            $k[$j++] = "The number of segments must be even from 2 to 22"; //#9319
            bwipp_raiseerror(); //#9319
        } //#9319
    } //#9319
    $k[$j++] = $_.barcode; //#9323
    $k[$j++] = 'ai'; //#9323
    bwipp_gs1process(); //#9323
    $_.fncs = $k[--$j]; //#9324
    $_.vals = $k[--$j]; //#9325
    $_.ais = $k[--$j]; //#9326
    for (;;) { //#9414
        if ($_.ais.length == 2) { //#9338
            if ($eq($get($_.ais, 0), "01") && $eq($get($_.ais, 1), "3103")) { //#9337
                if ($eq($geti($get($_.vals, 0), 0, 1), "9") && ($cvi($get($_.vals, 1)) <= 32767)) { //#9336
                    $k[$j++] = "0100"; //#9335
                    $k[$j++] = false; //#9335
                    break; //#9335
                } //#9335
            } //#9335
        } //#9335
        if ($_.ais.length == 2) { //#9347
            if ($eq($get($_.ais, 0), "01") && $eq($get($_.ais, 1), "3202")) { //#9346
                if ($eq($geti($get($_.vals, 0), 0, 1), "9") && ($cvi($get($_.vals, 1)) <= 9999)) { //#9345
                    $k[$j++] = "0101"; //#9344
                    $k[$j++] = false; //#9344
                    break; //#9344
                } //#9344
            } //#9344
        } //#9344
        if ($_.ais.length == 2) { //#9356
            if ($eq($get($_.ais, 0), "01") && $eq($get($_.ais, 1), "3203")) { //#9355
                if ($eq($geti($get($_.vals, 0), 0, 1), "9") && ($cvi($get($_.vals, 1)) <= 22767)) { //#9354
                    $k[$j++] = "0101"; //#9353
                    $k[$j++] = false; //#9353
                    break; //#9353
                } //#9353
            } //#9353
        } //#9353
        var _k = $_.ais.length; //#9359
        if ((_k == 2) || (_k == 3)) { //#9390
            $k[$j++] = 'ai310x'; //#9360
            $k[$j++] = false; //#9360
            for (var _l = 3100; _l <= 3109; _l += 1) { //#9360
                var _q = $k[--$j]; //#9360
                $k[$j++] = _q || $eq($cvrs($s(4), _l, 10), $get($_.ais, 1)); //#9360
            } //#9360
            var _r = $k[--$j]; //#9360
            $_[$k[--$j]] = _r; //#9360
            $k[$j++] = 'ai320x'; //#9361
            $k[$j++] = false; //#9361
            for (var _t = 3200; _t <= 3209; _t += 1) { //#9361
                var _y = $k[--$j]; //#9361
                $k[$j++] = _y || $eq($cvrs($s(4), _t, 10), $get($_.ais, 1)); //#9361
            } //#9361
            var _z = $k[--$j]; //#9361
            $_[$k[--$j]] = _z; //#9361
            if ($_.ais.length == 3) { //#9365
                var _12 = $a(["11", "13", "15", "17"]); //#9363
                $k[$j++] = 'aibad'; //#9363
                $k[$j++] = true; //#9363
                for (var _13 = 0, _14 = _12.length; _13 < _14; _13++) { //#9363
                    var _18 = $k[--$j]; //#9363
                    $k[$j++] = _18 && $ne($get(_12, _13), $get($_.ais, 2)); //#9363
                } //#9363
                var _19 = $k[--$j]; //#9363
                $_[$k[--$j]] = _19; //#9363
            } else { //#9365
                $_.aibad = false; //#9365
            } //#9365
            if (($eq($get($_.ais, 0), "01") && ($_.ai310x || $_.ai320x)) && (!$_.aibad)) { //#9389
                if ($_.ais.length == 3) { //#9386
                    var _1P = $cvi($geti($get($_.vals, 2), 2, 2)); //#9371
                    var _1T = $cvi($geti($get($_.vals, 2), 4, 2)); //#9372
                    if ((($eq($geti($get($_.vals, 0), 0, 1), "9") && ($cvi($get($_.vals, 1)) <= 99999)) && ((_1P >= 1) && (_1P <= 12))) && ((_1T >= 0) && (_1T <= 31))) { //#9381
                        if ($_.ai310x && $eq($get($_.ais, 2), "11")) { //#9373
                            $k[$j++] = "0111000"; //#9373
                            $k[$j++] = false; //#9373
                            break; //#9373
                        } //#9373
                        if ($_.ai320x && $eq($get($_.ais, 2), "11")) { //#9374
                            $k[$j++] = "0111001"; //#9374
                            $k[$j++] = false; //#9374
                            break; //#9374
                        } //#9374
                        if ($_.ai310x && $eq($get($_.ais, 2), "13")) { //#9375
                            $k[$j++] = "0111010"; //#9375
                            $k[$j++] = false; //#9375
                            break; //#9375
                        } //#9375
                        if ($_.ai320x && $eq($get($_.ais, 2), "13")) { //#9376
                            $k[$j++] = "0111011"; //#9376
                            $k[$j++] = false; //#9376
                            break; //#9376
                        } //#9376
                        if ($_.ai310x && $eq($get($_.ais, 2), "15")) { //#9377
                            $k[$j++] = "0111100"; //#9377
                            $k[$j++] = false; //#9377
                            break; //#9377
                        } //#9377
                        if ($_.ai320x && $eq($get($_.ais, 2), "15")) { //#9378
                            $k[$j++] = "0111101"; //#9378
                            $k[$j++] = false; //#9378
                            break; //#9378
                        } //#9378
                        if ($_.ai310x && $eq($get($_.ais, 2), "17")) { //#9379
                            $k[$j++] = "0111110"; //#9379
                            $k[$j++] = false; //#9379
                            break; //#9379
                        } //#9379
                        if ($_.ai320x && $eq($get($_.ais, 2), "17")) { //#9380
                            $k[$j++] = "0111111"; //#9380
                            $k[$j++] = false; //#9380
                            break; //#9380
                        } //#9380
                    } //#9380
                } else { //#9386
                    if ($eq($geti($get($_.vals, 0), 0, 1), "9") && ($cvi($get($_.vals, 1)) <= 99999)) { //#9387
                        if ($_.ai310x) { //#9385
                            $k[$j++] = "0111000"; //#9385
                            $k[$j++] = false; //#9385
                            break; //#9385
                        } //#9385
                        if ($_.ai320x) { //#9386
                            $k[$j++] = "0111001"; //#9386
                            $k[$j++] = false; //#9386
                            break; //#9386
                        } //#9386
                    } //#9386
                } //#9386
            } //#9386
        } //#9386
        if ($_.ais.length >= 2) { //#9398
            $k[$j++] = 'ai392x'; //#9394
            $k[$j++] = false; //#9394
            for (var _20 = 3920; _20 <= 3923; _20 += 1) { //#9394
                var _25 = $k[--$j]; //#9394
                $k[$j++] = _25 || $eq($cvrs($s(4), _20, 10), $get($_.ais, 1)); //#9394
            } //#9394
            var _26 = $k[--$j]; //#9394
            $_[$k[--$j]] = _26; //#9394
            if ($eq($get($_.ais, 0), "01") && $_.ai392x) { //#9397
                if ($eq($geti($get($_.vals, 0), 0, 1), "9")) { //#9396
                    $k[$j++] = "01100"; //#9396
                    $k[$j++] = true; //#9396
                    break; //#9396
                } //#9396
            } //#9396
        } //#9396
        if ($_.ais.length >= 2) { //#9406
            $k[$j++] = 'ai393x'; //#9402
            $k[$j++] = false; //#9402
            for (var _2F = 3930; _2F <= 3933; _2F += 1) { //#9402
                var _2K = $k[--$j]; //#9402
                $k[$j++] = _2K || $eq($cvrs($s(4), _2F, 10), $get($_.ais, 1)); //#9402
            } //#9402
            var _2L = $k[--$j]; //#9402
            $_[$k[--$j]] = _2L; //#9402
            if ($eq($get($_.ais, 0), "01") && $_.ai393x) { //#9405
                if ($eq($geti($get($_.vals, 0), 0, 1), "9")) { //#9404
                    $k[$j++] = "01101"; //#9404
                    $k[$j++] = true; //#9404
                    break; //#9404
                } //#9404
            } //#9404
        } //#9404
        if ($eq($get($_.ais, 0), "01")) { //#9409
            $k[$j++] = "1"; //#9409
            $k[$j++] = true; //#9409
            break; //#9409
        } //#9409
        $k[$j++] = "00"; //#9412
        $k[$j++] = true; //#9412
        break; //#9412
    } //#9412
    $_.gpfallow = $k[--$j]; //#9415
    $_.method = $k[--$j]; //#9416
    $_.conv12to40 = function() {
        var _2Y = $strcpy($s(40), "0000000000000000000000000000000000000000"); //#9419
        var _2Z = $k[--$j]; //#9420
        var _2d = $cvrs($s(10), $cvi($geti(_2Z, 0, 3)), 2); //#9420
        $puti($geti(_2Y, 0, 10), 10 - _2d.length, _2d); //#9420
        var _2h = $cvrs($s(10), $cvi($geti(_2Z, 3, 3)), 2); //#9421
        $puti($geti(_2Y, 10, 10), 10 - _2h.length, _2h); //#9421
        var _2l = $cvrs($s(10), $cvi($geti(_2Z, 6, 3)), 2); //#9422
        $puti($geti(_2Y, 20, 10), 10 - _2l.length, _2l); //#9422
        var _2p = $cvrs($s(10), $cvi($geti(_2Z, 9, 3)), 2); //#9423
        $puti($geti(_2Y, 30, 10), 10 - _2p.length, _2p); //#9423
        $k[$j++] = _2Y; //#9424
        $k[$j++] = _2Z; //#9424
        $j--; //#9424
    }; //#9424
    $_.conv13to44 = function() {
        var _2r = $strcpy($s(44), "00000000000000000000000000000000000000000000"); //#9428
        var _2s = $k[--$j]; //#9429
        var _2w = $cvrs($s(4), $cvi($geti(_2s, 0, 1)), 2); //#9429
        $puti($geti(_2r, 0, 4), 4 - _2w.length, _2w); //#9429
        $k[$j++] = _2r; //#9430
        $k[$j++] = _2r; //#9430
        $k[$j++] = $geti(_2s, 1, 12); //#9430
        $_.conv12to40(); //#9430
        var _2y = $k[--$j]; //#9430
        $puti($k[--$j], 4, _2y); //#9430
    }; //#9430
    $_.tobin = function() {
        var _31 = $s($k[--$j]); //#9434
        $k[$j++] = _31; //#9434
        for (var _33 = 0, _32 = _31.length - 1; _33 <= _32; _33 += 1) { //#9434
            var _34 = $k[--$j]; //#9434
            $put(_34, _33, 48); //#9434
            $k[$j++] = _34; //#9434
        } //#9434
        var _35 = $k[--$j]; //#9435
        var _38 = $cvrs($s(_35.length), $k[--$j], 2); //#9435
        $puti(_35, _35.length - _38.length, _38); //#9435
        $k[$j++] = _35; //#9435
    }; //#9435
    $_.fnc1 = -1; //#9438
    $_.lnumeric = -2; //#9438
    $_.lalphanumeric = -3; //#9438
    $_.liso646 = -4; //#9438
    if ($eq($_.method, "00")) { //#9443
        $_.cdf = $a([]); //#9441
        $_.gpf = $a([]); //#9442
    } //#9442
    if ($eq($_.method, "1")) { //#9452
        $k[$j++] = 'cdf'; //#9446
        $k[$j++] = $geti($get($_.vals, 0), 0, 13); //#9446
        $_.conv13to44(); //#9446
        var _3G = $k[--$j]; //#9446
        $_[$k[--$j]] = _3G; //#9446
        $k[$j++] = Infinity; //#9447
        var _3I = $_.cdf; //#9447
        for (var _3J = 0, _3K = _3I.length; _3J < _3K; _3J++) { //#9447
            $k[$j++] = $f($get(_3I, _3J) - 48); //#9447
        } //#9447
        $_.cdf = $a(); //#9447
        $_.gpf = $a([]); //#9448
        $_.ais = $geti($_.ais, 1, $_.ais.length - 1); //#9449
        $_.vals = $geti($_.vals, 1, $_.vals.length - 1); //#9450
        $_.fncs = $geti($_.fncs, 1, $_.fncs.length - 1); //#9451
    } //#9451
    if ($eq($_.method, "0100")) { //#9463
        $_.cdf = $s(55); //#9455
        $k[$j++] = $_.cdf; //#9456
        $k[$j++] = 0; //#9456
        $k[$j++] = $geti($get($_.vals, 0), 1, 12); //#9456
        $_.conv12to40(); //#9456
        var _3d = $k[--$j]; //#9456
        var _3e = $k[--$j]; //#9456
        $puti($k[--$j], _3e, _3d); //#9456
        $k[$j++] = $_.cdf; //#9457
        $k[$j++] = 40; //#9457
        $k[$j++] = $cvi($get($_.vals, 1)); //#9457
        $k[$j++] = 15; //#9457
        $_.tobin(); //#9457
        var _3j = $k[--$j]; //#9457
        var _3k = $k[--$j]; //#9457
        $puti($k[--$j], _3k, _3j); //#9457
        $k[$j++] = Infinity; //#9458
        var _3m = $_.cdf; //#9458
        for (var _3n = 0, _3o = _3m.length; _3n < _3o; _3n++) { //#9458
            $k[$j++] = $get(_3m, _3n) - 48; //#9458
        } //#9458
        $_.cdf = $a(); //#9458
        $_.gpf = $a([]); //#9459
        $_.ais = $a([]); //#9460
        $_.vals = $a([]); //#9461
        $_.fncs = $a([]); //#9462
    } //#9462
    if ($eq($_.method, "0101")) { //#9479
        $_.cdf = $s(55); //#9466
        $k[$j++] = $_.cdf; //#9467
        $k[$j++] = 0; //#9467
        $k[$j++] = $geti($get($_.vals, 0), 1, 12); //#9467
        $_.conv12to40(); //#9467
        var _41 = $k[--$j]; //#9467
        var _42 = $k[--$j]; //#9467
        $puti($k[--$j], _42, _41); //#9467
        if ($eq($get($_.ais, 1), "3202")) { //#9471
            $k[$j++] = $cvi($get($_.vals, 1)); //#9469
            $k[$j++] = 15; //#9469
            $_.tobin(); //#9469
        } else { //#9471
            $k[$j++] = $cvi($get($_.vals, 1)) + 10000; //#9471
            $k[$j++] = 15; //#9471
            $_.tobin(); //#9471
        } //#9471
        $puti($_.cdf, 40, $k[--$j]); //#9473
        $k[$j++] = Infinity; //#9474
        var _4C = $_.cdf; //#9474
        for (var _4D = 0, _4E = _4C.length; _4D < _4E; _4D++) { //#9474
            $k[$j++] = $get(_4C, _4D) - 48; //#9474
        } //#9474
        $_.cdf = $a(); //#9474
        $_.gpf = $a([]); //#9475
        $_.ais = $a([]); //#9476
        $_.vals = $a([]); //#9477
        $_.fncs = $a([]); //#9478
    } //#9478
    if ($_.method.length == 7) { //#9501
        $_.cdf = $s(76); //#9482
        $k[$j++] = $_.cdf; //#9483
        $k[$j++] = 0; //#9483
        $k[$j++] = $geti($get($_.vals, 0), 1, 12); //#9483
        $_.conv12to40(); //#9483
        var _4R = $k[--$j]; //#9483
        var _4S = $k[--$j]; //#9483
        $puti($k[--$j], _4S, _4R); //#9483
        var _4U = $s(6); //#9484
        $puti(_4U, 0, $geti($get($_.ais, 1), 3, 1)); //#9484
        $puti(_4U, 1, $geti($get($_.vals, 1), 1, 5)); //#9485
        $k[$j++] = $cvi(_4U); //#9485
        $k[$j++] = 20; //#9485
        $_.tobin(); //#9485
        $puti($_.cdf, 40, $k[--$j]); //#9486
        if ($_.ais.length == 3) { //#9493
            var _4f = $get($_.vals, 2); //#9488
            $k[$j++] = ($cvi($geti(_4f, 0, 2)) * 384) + ((($cvi($geti(_4f, 2, 2)) - 1) * 32) + $cvi($geti(_4f, 4, 2))); //#9491
        } else { //#9493
            $k[$j++] = 38400; //#9493
        } //#9493
        $k[$j++] = 16; //#9495
        $_.tobin(); //#9495
        $puti($_.cdf, 60, $k[--$j]); //#9495
        $k[$j++] = Infinity; //#9496
        var _4l = $_.cdf; //#9496
        for (var _4m = 0, _4n = _4l.length; _4m < _4n; _4m++) { //#9496
            $k[$j++] = $get(_4l, _4m) - 48; //#9496
        } //#9496
        $_.cdf = $a(); //#9496
        $_.gpf = $a([]); //#9497
        $_.ais = $a([]); //#9498
        $_.vals = $a([]); //#9499
        $_.fncs = $a([]); //#9500
    } //#9500
    if ($eq($_.method, "01100")) { //#9512
        $_.cdf = $s(42); //#9504
        $k[$j++] = $_.cdf; //#9505
        $k[$j++] = 0; //#9505
        $k[$j++] = $geti($get($_.vals, 0), 1, 12); //#9505
        $_.conv12to40(); //#9505
        var _50 = $k[--$j]; //#9505
        var _51 = $k[--$j]; //#9505
        $puti($k[--$j], _51, _50); //#9505
        $k[$j++] = $_.cdf; //#9506
        $k[$j++] = 40; //#9506
        $k[$j++] = $cvi($geti($get($_.ais, 1), 3, 1)); //#9506
        $k[$j++] = 2; //#9506
        $_.tobin(); //#9506
        var _57 = $k[--$j]; //#9506
        var _58 = $k[--$j]; //#9506
        $puti($k[--$j], _58, _57); //#9506
        $k[$j++] = Infinity; //#9507
        var _5A = $_.cdf; //#9507
        for (var _5B = 0, _5C = _5A.length; _5B < _5C; _5B++) { //#9507
            $k[$j++] = $get(_5A, _5B) - 48; //#9507
        } //#9507
        $_.cdf = $a(); //#9507
        $k[$j++] = Infinity; //#9508
        $forall($get($_.vals, 1)); //#9508
        if ($_.ais.length > 2) { //#9508
            $k[$j++] = $_.fnc1; //#9508
        } //#9508
        $_.gpf = $a(); //#9508
        $_.ais = $geti($_.ais, 2, $_.ais.length - 2); //#9509
        $_.vals = $geti($_.vals, 2, $_.vals.length - 2); //#9510
        $_.fncs = $geti($_.fncs, 2, $_.fncs.length - 2); //#9511
    } //#9511
    if ($eq($_.method, "01101")) { //#9524
        $_.cdf = $s(52); //#9515
        $k[$j++] = $_.cdf; //#9516
        $k[$j++] = 0; //#9516
        $k[$j++] = $geti($get($_.vals, 0), 1, 12); //#9516
        $_.conv12to40(); //#9516
        var _5Z = $k[--$j]; //#9516
        var _5a = $k[--$j]; //#9516
        $puti($k[--$j], _5a, _5Z); //#9516
        $k[$j++] = $_.cdf; //#9517
        $k[$j++] = 40; //#9517
        $k[$j++] = $cvi($geti($get($_.ais, 1), 3, 1)); //#9517
        $k[$j++] = 2; //#9517
        $_.tobin(); //#9517
        var _5g = $k[--$j]; //#9517
        var _5h = $k[--$j]; //#9517
        $puti($k[--$j], _5h, _5g); //#9517
        $k[$j++] = $_.cdf; //#9518
        $k[$j++] = 42; //#9518
        $k[$j++] = $cvi($geti($get($_.vals, 1), 0, 3)); //#9518
        $k[$j++] = 10; //#9518
        $_.tobin(); //#9518
        var _5n = $k[--$j]; //#9518
        var _5o = $k[--$j]; //#9518
        $puti($k[--$j], _5o, _5n); //#9518
        $k[$j++] = Infinity; //#9519
        var _5q = $_.cdf; //#9519
        for (var _5r = 0, _5s = _5q.length; _5r < _5s; _5r++) { //#9519
            $k[$j++] = $get(_5q, _5r) - 48; //#9519
        } //#9519
        $_.cdf = $a(); //#9519
        $k[$j++] = Infinity; //#9520
        var _5w = $get($_.vals, 1); //#9520
        var _5x = $geti(_5w, 3, _5w.length - 3); //#9520
        for (var _5y = 0, _5z = _5x.length; _5y < _5z; _5y++) { //#9520
            $k[$j++] = $get(_5x, _5y); //#9520
        } //#9520
        if ($_.ais.length > 2) { //#9520
            $k[$j++] = $_.fnc1; //#9520
        } //#9520
        $_.gpf = $a(); //#9520
        $_.ais = $geti($_.ais, 2, $_.ais.length - 2); //#9521
        $_.vals = $geti($_.vals, 2, $_.vals.length - 2); //#9522
        $_.fncs = $geti($_.fncs, 2, $_.fncs.length - 2); //#9523
    } //#9523
    if ($_.gpfallow) { //#9530
        $_.vlf = $a(2); //#9528
    } else { //#9530
        $_.vlf = $a([]); //#9530
    } //#9530
    if (!bwipp_databarexpanded.__9571__) { //#9571
        $_ = Object.create($_); //#9571
        $k[$j++] = Infinity; //#9534
        for (var _6G = 0; _6G <= 119; _6G += 1) { //#9543
            var _6I = $strcpy($s(2), "00"); //#9536
            var _6K = $cvrs($s(2), _6G, 11); //#9536
            $puti(_6I, 2 - _6K.length, _6K); //#9537
            $k[$j++] = _6G; //#9538
            $k[$j++] = _6I; //#9538
            if ($get(_6I, 0) == 65) { //#9538
                var _6M = $k[--$j]; //#9538
                $put(_6M, 0, 94); //#9538
                $k[$j++] = _6M; //#9538
            } //#9538
            var _6N = $k[--$j]; //#9539
            $k[$j++] = _6N; //#9539
            if ($get(_6N, 1) == 65) { //#9539
                var _6P = $k[--$j]; //#9539
                $put(_6P, 1, 94); //#9539
                $k[$j++] = _6P; //#9539
            } //#9539
            var _6Q = $k[--$j]; //#9540
            var _6T = $strcpy($s(7), "0000000"); //#9541
            var _6V = $cvrs($s(7), $f($k[--$j] + 8), 2); //#9541
            $puti(_6T, 7 - _6V.length, _6V); //#9542
            $k[$j++] = _6Q; //#9542
            $k[$j++] = _6T; //#9542
        } //#9542
        $k[$j++] = $_.lalphanumeric; //#9544
        $k[$j++] = "0000"; //#9544
        $_.numeric = $d(); //#9545
        $k[$j++] = Infinity; //#9547
        for (var _6Y = 48; _6Y <= 57; _6Y += 1) { //#9548
            $k[$j++] = _6Y; //#9548
            $k[$j++] = _6Y - 43; //#9548
            $k[$j++] = 5; //#9548
            $_.tobin(); //#9548
        } //#9548
        $k[$j++] = $_.fnc1; //#9550
        $k[$j++] = "01111"; //#9550
        for (var _6a = 65; _6a <= 90; _6a += 1) { //#9550
            $k[$j++] = _6a; //#9550
            $k[$j++] = _6a - 33; //#9550
            $k[$j++] = 6; //#9550
            $_.tobin(); //#9550
        } //#9550
        $k[$j++] = 42; //#9552
        $k[$j++] = "111010"; //#9552
        for (var _6b = 44; _6b <= 47; _6b += 1) { //#9552
            $k[$j++] = _6b; //#9552
            $k[$j++] = _6b + 15; //#9552
            $k[$j++] = 6; //#9552
            $_.tobin(); //#9552
        } //#9552
        $k[$j++] = $_.lnumeric; //#9554
        $k[$j++] = "000"; //#9554
        $k[$j++] = $_.liso646; //#9554
        $k[$j++] = "00100"; //#9554
        $_.alphanumeric = $d(); //#9555
        $k[$j++] = Infinity; //#9557
        for (var _6f = 48; _6f <= 57; _6f += 1) { //#9558
            $k[$j++] = _6f; //#9558
            $k[$j++] = _6f - 43; //#9558
            $k[$j++] = 5; //#9558
            $_.tobin(); //#9558
        } //#9558
        $k[$j++] = $_.fnc1; //#9560
        $k[$j++] = "01111"; //#9560
        for (var _6h = 65; _6h <= 90; _6h += 1) { //#9560
            $k[$j++] = _6h; //#9560
            $k[$j++] = _6h - 1; //#9560
            $k[$j++] = 7; //#9560
            $_.tobin(); //#9560
        } //#9560
        for (var _6i = 97; _6i <= 122; _6i += 1) { //#9561
            $k[$j++] = _6i; //#9561
            $k[$j++] = _6i - 7; //#9561
            $k[$j++] = 7; //#9561
            $_.tobin(); //#9561
        } //#9561
        $k[$j++] = 33; //#9564
        $k[$j++] = "11101000"; //#9564
        $k[$j++] = 34; //#9564
        $k[$j++] = "11101001"; //#9564
        for (var _6j = 37; _6j <= 47; _6j += 1) { //#9564
            $k[$j++] = _6j; //#9564
            $k[$j++] = _6j + 197; //#9564
            $k[$j++] = 8; //#9564
            $_.tobin(); //#9564
        } //#9564
        for (var _6k = 58; _6k <= 63; _6k += 1) { //#9565
            $k[$j++] = _6k; //#9565
            $k[$j++] = _6k + 187; //#9565
            $k[$j++] = 8; //#9565
            $_.tobin(); //#9565
        } //#9565
        $k[$j++] = 95; //#9569
        $k[$j++] = "11111011"; //#9569
        $k[$j++] = 32; //#9569
        $k[$j++] = "11111100"; //#9569
        $k[$j++] = $_.lnumeric; //#9569
        $k[$j++] = "000"; //#9569
        $k[$j++] = $_.lalphanumeric; //#9569
        $k[$j++] = "00100"; //#9569
        $_.iso646 = $d(); //#9570
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_databarexpanded.$ctx[id] = $_[id]); //#9570
        bwipp_databarexpanded.__9571__ = 1; //#9570
        $_ = Object.getPrototypeOf($_); //#9570
    } //#9570
    for (var _6r = 0, _6q = $_.ais.length - 1; _6r <= _6q; _6r += 1) { //#9589
        $_.i = _6r; //#9575
        $_.ai = $get($_.ais, $_.i); //#9576
        $_.val = $get($_.vals, $_.i); //#9577
        var _71 = $a(($_.gpf.length + $_.ai.length) + $_.val.length); //#9578
        $puti(_71, 0, $_.gpf); //#9579
        $k[$j++] = _71; //#9580
        $k[$j++] = _71; //#9580
        $k[$j++] = $_.gpf.length; //#9580
        $k[$j++] = $_.ai; //#9580
        $k[$j++] = Infinity; //#9580
        var _75 = $k[--$j]; //#9580
        var _76 = $k[--$j]; //#9580
        $k[$j++] = _75; //#9580
        $forall(_76); //#9580
        var _77 = $a(); //#9580
        var _78 = $k[--$j]; //#9580
        $puti($k[--$j], _78, _77); //#9580
        var _7A = $k[--$j]; //#9581
        $k[$j++] = _7A; //#9581
        $k[$j++] = _7A; //#9581
        $k[$j++] = $_.gpf.length + $_.ai.length; //#9581
        $k[$j++] = $_.val; //#9581
        $k[$j++] = Infinity; //#9581
        var _7E = $k[--$j]; //#9581
        var _7F = $k[--$j]; //#9581
        $k[$j++] = _7E; //#9581
        $forall(_7F); //#9581
        var _7G = $a(); //#9581
        var _7H = $k[--$j]; //#9581
        $puti($k[--$j], _7H, _7G); //#9581
        $_.gpf = $k[--$j]; //#9582
        if (($_.i != ($_.ais.length - 1)) && $get($_.fncs, $_.i)) { //#9588
            var _7Q = $a($_.gpf.length + 1); //#9584
            $puti(_7Q, 0, $_.gpf); //#9585
            $put(_7Q, $_.gpf.length, $_.fnc1); //#9586
            $_.gpf = _7Q; //#9587
        } //#9587
    } //#9587
    $_.rembits = function() {
        var _7U = $k[--$j]; //#9593
        var _7V = 48; //#9595
        var _7W = (~~Math.ceil(_7U / 12)) * 12; //#9595
        if (((~~Math.ceil(_7U / 12)) * 12) < 48) { //#9595
            var _ = _7V; //#9595
            _7V = _7W; //#9595
            _7W = _; //#9595
        } //#9595
        var _7X = ~~(_7W / 12); //#9596
        $k[$j++] = _7U; //#9600
        $k[$j++] = _7W; //#9600
        $k[$j++] = _7X; //#9600
        if ((_7X % $_.segments) == 1) { //#9599
            var _7Z = $k[--$j]; //#9597
            var _7a = $k[--$j]; //#9597
            $k[$j++] = $f(_7Z + 1) * 12; //#9597
            $k[$j++] = _7a; //#9597
            $j--; //#9597
        } else { //#9599
            $j--; //#9599
        } //#9599
        var _7b = $k[--$j]; //#9601
        var _7c = $k[--$j]; //#9601
        $k[$j++] = $f(_7b - _7c); //#9601
    }; //#9601
    $_.encode = function() {
        var _7d = $k[--$j]; //#9605
        $k[$j++] = _7d; //#9605
        if ($ne(_7d, 'raw')) { //#9605
            var _7e = $k[--$j]; //#9605
            var _7g = $get(_7e, $k[--$j]); //#9605
            $k[$j++] = _7g; //#9605
        } else { //#9605
            $j--; //#9605
        } //#9605
        var _7h = $k[--$j]; //#9606
        $k[$j++] = _7h; //#9608
        if ((_7h.length + $_.j) >= 252) { //#9608
            $j--; //#9607
            $k[$j++] = 'bwipp.gs1databarexpandedTooLong#9607'; //#9607
            $k[$j++] = "Maximum length exceeded"; //#9607
            bwipp_raiseerror(); //#9607
        } //#9607
        $k[$j++] = Infinity; //#9609
        var _7j = $k[--$j]; //#9609
        var _7k = $k[--$j]; //#9609
        $k[$j++] = _7j; //#9609
        $forall(_7k, function() { //#9609
            var _7l = $k[--$j]; //#9609
            $k[$j++] = $f(_7l - 48); //#9609
        }); //#9609
        var _7m = $a(); //#9609
        $puti($_.gpfenc, $_.j, _7m); //#9611
        $_.j = _7m.length + $_.j; //#9612
    }; //#9612
    $k[$j++] = Infinity; //#9616
    for (var _7r = 0, _7s = $_.gpf.length; _7r < _7s; _7r++) { //#9616
        $k[$j++] = 0; //#9616
    } //#9616
    $k[$j++] = 0; //#9616
    $k[$j++] = -1; //#9616
    $_.numericruns = $a(); //#9616
    $k[$j++] = Infinity; //#9617
    for (var _7v = 0, _7w = $_.gpf.length; _7v < _7w; _7v++) { //#9617
        $k[$j++] = 0; //#9617
    } //#9617
    $k[$j++] = 0; //#9617
    $_.alphanumericruns = $a(); //#9617
    $k[$j++] = Infinity; //#9618
    for (var _7z = 0, _80 = $_.gpf.length; _7z < _80; _7z++) { //#9618
        $k[$j++] = 0; //#9618
    } //#9618
    $k[$j++] = 9999; //#9618
    $_.nextiso646only = $a(); //#9618
    for (var _83 = $_.gpf.length - 1; _83 >= 0; _83 -= 1) { //#9640
        $_.i = _83; //#9620
        var _88 = $strcpy($s(2), "00"); //#9622
        var _8B = $get($_.gpf, $_.i); //#9623
        $k[$j++] = $get($_.gpf, $_.i); //#9623
        $k[$j++] = _88; //#9623
        $k[$j++] = _88; //#9623
        $k[$j++] = 0; //#9623
        $k[$j++] = _8B; //#9623
        if (_8B == $_.fnc1) { //#9623
            $j--; //#9623
            $k[$j++] = 94; //#9623
        } //#9623
        var _8D = $k[--$j]; //#9623
        var _8E = $k[--$j]; //#9623
        $put($k[--$j], _8E, _8D); //#9623
        if ($_.i < ($_.gpf.length - 1)) { //#9624
            var _8I = $k[--$j]; //#9624
            var _8L = $get($_.gpf, $_.i + 1); //#9624
            $k[$j++] = _8I; //#9624
            $k[$j++] = _8I; //#9624
            $k[$j++] = 1; //#9624
            $k[$j++] = _8L; //#9624
            if (_8L == $_.fnc1) { //#9624
                $j--; //#9624
                $k[$j++] = 94; //#9624
            } //#9624
            var _8N = $k[--$j]; //#9624
            var _8O = $k[--$j]; //#9624
            $put($k[--$j], _8O, _8N); //#9624
        } //#9624
        var _8S = $get($_.numeric, $k[--$j]) !== undefined; //#9625
        if (_8S) { //#9628
            $put($_.numericruns, $_.i, $f($get($_.numericruns, $_.i + 2) + 2)); //#9626
        } else { //#9628
            $put($_.numericruns, $_.i, 0); //#9628
        } //#9628
        var _8a = $k[--$j]; //#9630
        var _8c = $get($_.alphanumeric, _8a) !== undefined; //#9630
        $k[$j++] = _8a; //#9634
        if (_8c) { //#9633
            $put($_.alphanumericruns, $_.i, $f($get($_.alphanumericruns, $_.i + 1) + 1)); //#9631
        } else { //#9633
            $put($_.alphanumericruns, $_.i, 0); //#9633
        } //#9633
        var _8k = $k[--$j]; //#9635
        var _8m = $get($_.iso646, _8k) !== undefined; //#9635
        var _8o = $get($_.alphanumeric, _8k) !== undefined; //#9635
        if (_8m && (!_8o)) { //#9638
            $put($_.nextiso646only, $_.i, 0); //#9636
        } else { //#9638
            $put($_.nextiso646only, $_.i, $f($get($_.nextiso646only, $_.i + 1) + 1)); //#9638
        } //#9638
    } //#9638
    $_.gpfenc = $a(252); //#9643
    $_.i = 0; //#9644
    $_.j = 0; //#9644
    $_.mode = "numeric"; //#9644
    for (;;) { //#9734
        if ($_.i == $_.gpf.length) { //#9646
            break; //#9646
        } //#9646
        for (;;) { //#9733
            if ($eq($_.mode, "numeric")) { //#9682
                if ($_.i <= ($_.gpf.length - 2)) { //#9679
                    var _92 = $s(2); //#9651
                    var _95 = $get($_.gpf, $_.i); //#9652
                    $k[$j++] = _92; //#9652
                    $k[$j++] = _92; //#9652
                    $k[$j++] = 0; //#9652
                    $k[$j++] = _95; //#9652
                    if (_95 == $_.fnc1) { //#9652
                        $j--; //#9652
                        $k[$j++] = 94; //#9652
                    } //#9652
                    var _97 = $k[--$j]; //#9652
                    var _98 = $k[--$j]; //#9652
                    $put($k[--$j], _98, _97); //#9652
                    var _9A = $k[--$j]; //#9653
                    var _9D = $get($_.gpf, $_.i + 1); //#9653
                    $k[$j++] = _9A; //#9653
                    $k[$j++] = _9A; //#9653
                    $k[$j++] = 1; //#9653
                    $k[$j++] = _9D; //#9653
                    if (_9D == $_.fnc1) { //#9653
                        $j--; //#9653
                        $k[$j++] = 94; //#9653
                    } //#9653
                    var _9F = $k[--$j]; //#9653
                    var _9G = $k[--$j]; //#9653
                    $put($k[--$j], _9G, _9F); //#9653
                    var _9I = $k[--$j]; //#9654
                    var _9K = $get($_.numeric, _9I) !== undefined; //#9654
                    $k[$j++] = _9I; //#9658
                    if (_9K) { //#9658
                        $k[$j++] = $_.numeric; //#9655
                        $_.encode(); //#9655
                        $_.i = $_.i + 2; //#9656
                        break; //#9657
                    } //#9657
                    $j--; //#9659
                    $k[$j++] = $_.lalphanumeric; //#9660
                    $k[$j++] = $_.numeric; //#9660
                    $_.encode(); //#9660
                    $_.mode = "alphanumeric"; //#9661
                    break; //#9662
                } else { //#9679
                    var _9R = $get($_.gpf, $_.i); //#9664
                    if ((_9R < 48) || (_9R > 57)) { //#9668
                        $k[$j++] = $_.lalphanumeric; //#9665
                        $k[$j++] = $_.numeric; //#9665
                        $_.encode(); //#9665
                        $_.mode = "alphanumeric"; //#9666
                        break; //#9667
                    } //#9667
                    $k[$j++] = 'rem'; //#9669
                    $k[$j++] = ((((12 + 1) + $_.method.length) + $_.vlf.length) + $_.cdf.length) + $_.j; //#9669
                    $_.rembits(); //#9669
                    var _9Y = $k[--$j]; //#9669
                    $_[$k[--$j]] = _9Y; //#9669
                    if (($_.rem >= 4) && ($_.rem <= 6)) { //#9679
                        var _9f = $geti($strcpy($s(6), "000000"), 0, $_.rem); //#9671
                        var _9k = $cvrs($s(4), $f($get($_.gpf, $_.i) - 47), 2); //#9672
                        $puti(_9f, 4 - _9k.length, _9k); //#9673
                        $k[$j++] = _9f; //#9673
                        $k[$j++] = 'raw'; //#9673
                        $_.encode(); //#9673
                        $_.i = $_.i + 1; //#9674
                        break; //#9675
                    } else { //#9679
                        var _9m = $s(2); //#9677
                        $put(_9m, 0, $get($_.gpf, $_.i)); //#9677
                        $put(_9m, 1, 94); //#9677
                        $k[$j++] = _9m; //#9677
                        $k[$j++] = $_.numeric; //#9677
                        $_.encode(); //#9677
                        $_.i = $_.i + 1; //#9678
                        break; //#9679
                    } //#9679
                } //#9679
            } //#9679
            if ($eq($_.mode, "alphanumeric")) { //#9709
                if ($get($_.gpf, $_.i) == $_.fnc1) { //#9690
                    $k[$j++] = $_.fnc1; //#9686
                    $k[$j++] = $_.alphanumeric; //#9686
                    $_.encode(); //#9686
                    $_.mode = "numeric"; //#9687
                    $_.i = $_.i + 1; //#9688
                    break; //#9689
                } //#9689
                var _A2 = $get($_.gpf, $_.i); //#9691
                var _A4 = $get($_.iso646, _A2) !== undefined; //#9691
                var _A6 = $get($_.alphanumeric, _A2) !== undefined; //#9691
                if (_A4 && (!_A6)) { //#9695
                    $k[$j++] = $_.liso646; //#9692
                    $k[$j++] = $_.alphanumeric; //#9692
                    $_.encode(); //#9692
                    $_.mode = "iso646"; //#9693
                    break; //#9694
                } //#9694
                if ($get($_.numericruns, $_.i) >= 6) { //#9700
                    $k[$j++] = $_.lnumeric; //#9697
                    $k[$j++] = $_.alphanumeric; //#9697
                    $_.encode(); //#9697
                    $_.mode = "numeric"; //#9698
                    break; //#9699
                } //#9699
                var _AG = $get($_.numericruns, $_.i); //#9701
                if ((_AG >= 4) && ($f(_AG + $_.i) == $_.gpf.length)) { //#9705
                    $k[$j++] = $_.lnumeric; //#9702
                    $k[$j++] = $_.alphanumeric; //#9702
                    $_.encode(); //#9702
                    $_.mode = "numeric"; //#9703
                    break; //#9704
                } //#9704
                $k[$j++] = $get($_.gpf, $_.i); //#9706
                $k[$j++] = $_.alphanumeric; //#9706
                $_.encode(); //#9706
                $_.i = $_.i + 1; //#9707
                break; //#9708
            } //#9708
            if ($eq($_.mode, "iso646")) { //#9731
                if ($get($_.gpf, $_.i) == $_.fnc1) { //#9717
                    $k[$j++] = $_.fnc1; //#9713
                    $k[$j++] = $_.iso646; //#9713
                    $_.encode(); //#9713
                    $_.mode = "numeric"; //#9714
                    $_.i = $_.i + 1; //#9715
                    break; //#9716
                } //#9716
                if (($get($_.numericruns, $_.i) >= 4) && ($get($_.nextiso646only, $_.i) >= 10)) { //#9722
                    $k[$j++] = $_.lnumeric; //#9719
                    $k[$j++] = $_.iso646; //#9719
                    $_.encode(); //#9719
                    $_.mode = "numeric"; //#9720
                    break; //#9721
                } //#9721
                if (($get($_.alphanumericruns, $_.i) >= 5) && ($get($_.nextiso646only, $_.i) >= 10)) { //#9727
                    $k[$j++] = $_.lalphanumeric; //#9724
                    $k[$j++] = $_.iso646; //#9724
                    $_.encode(); //#9724
                    $_.mode = "alphanumeric"; //#9725
                    break; //#9726
                } //#9726
                $k[$j++] = $get($_.gpf, $_.i); //#9728
                $k[$j++] = $_.iso646; //#9728
                $_.encode(); //#9728
                $_.i = $_.i + 1; //#9729
                break; //#9730
            } //#9730
        } //#9730
    } //#9730
    $_.gpf = $geti($_.gpfenc, 0, $_.j); //#9735
    var _B0 = ((((1 + 12) + $_.method.length) + $_.vlf.length) + $_.cdf.length) + $_.gpf.length; //#9739
    $k[$j++] = _B0; //#9739
    $k[$j++] = _B0; //#9739
    $_.rembits(); //#9739
    var _B1 = $k[--$j]; //#9739
    $_.pad = $a(_B1); //#9739
    $k[$j++] = _B1; //#9746
    if ($_.vlf.length != 0) { //#9745
        var _B4 = $k[--$j]; //#9741
        var _B6 = ~~($f($k[--$j] + _B4) / 12); //#9742
        $put($_.vlf, 0, _B6 % 2); //#9742
        var _B8 = (_B6 <= 14) ? 0 : 1; //#9743
        $put($_.vlf, 1, _B8); //#9743
    } else { //#9745
        $j -= 2; //#9745
    } //#9745
    if ($_.pad.length > 0) { //#9755
        for (var _BD = 0, _BC = $_.pad.length - 1; _BD <= _BC; _BD += 5) { //#9751
            $_.i = _BD; //#9749
            var _BE = $_.pad; //#9750
            var _BF = $_.i; //#9750
            var _BG = $a([0, 0, 1, 0, 0]); //#9750
            var _BH = $_.pad; //#9750
            var _BI = $_.i; //#9750
            var _BJ = 5; //#9750
            var _BK = _BH.length - _BI; //#9750
            if ((_BH.length - _BI) > 5) { //#9750
                var _ = _BJ; //#9750
                _BJ = _BK; //#9750
                _BK = _; //#9750
            } //#9750
            $puti(_BE, _BF, $geti(_BG, 0, _BK)); //#9750
        } //#9750
        if ($eq($_.mode, "numeric")) { //#9754
            $k[$j++] = Infinity; //#9753
            $k[$j++] = 0; //#9753
            $k[$j++] = 0; //#9753
            $k[$j++] = 0; //#9753
            $k[$j++] = 0; //#9753
            $aload($_.pad); //#9753
            $_.pad = $geti($a(), 0, $_.pad.length); //#9753
        } //#9753
    } //#9753
    $k[$j++] = Infinity; //#9758
    var _BS = $_.linkage ? 1 : 0; //#9759
    $k[$j++] = _BS; //#9760
    $forall($_.method, function() { //#9760
        var _BU = $k[--$j]; //#9760
        $k[$j++] = $f(_BU - 48); //#9760
    }); //#9760
    $aload($_.vlf); //#9761
    $aload($_.cdf); //#9762
    $aload($_.gpf); //#9763
    $aload($_.pad); //#9764
    $_.binval = $a(); //#9764
    $_.datalen = ~~($_.binval.length / 12); //#9766
    $_.ncr = function() {
        var _Bb = $k[--$j]; //#9769
        var _Bc = $k[--$j]; //#9769
        var _Bd = $f(_Bc - _Bb); //#9769
        if (_Bb < $f(_Bc - _Bb)) { //#9769
            var _ = _Bd; //#9769
            _Bd = _Bb; //#9769
            _Bb = _; //#9769
        } //#9769
        $k[$j++] = _Bd; //#9776
        $k[$j++] = 1; //#9776
        $k[$j++] = 1; //#9776
        for (var _Bf = _Bc, _Be = $f(_Bb + 1); _Bf >= _Be; _Bf -= 1) { //#9776
            var _Bg = $k[--$j]; //#9772
            var _Bh = $k[--$j]; //#9773
            var _Bi = $k[--$j]; //#9773
            $k[$j++] = _Bi; //#9775
            $k[$j++] = _Bh; //#9775
            $k[$j++] = _Bg * _Bf; //#9775
            if ($le(_Bh, _Bi)) { //#9775
                var _Bj = $k[--$j]; //#9774
                var _Bk = $k[--$j]; //#9774
                $k[$j++] = $f(_Bk + 1); //#9774
                $k[$j++] = ~~(_Bj / _Bk); //#9774
            } //#9774
        } //#9774
        for (;;) { //#9780
            var _Bl = $k[--$j]; //#9778
            var _Bm = $k[--$j]; //#9778
            var _Bn = $k[--$j]; //#9778
            $k[$j++] = _Bn; //#9778
            $k[$j++] = _Bm; //#9778
            $k[$j++] = _Bl; //#9778
            if ($gt(_Bm, _Bn)) { //#9778
                break; //#9778
            } //#9778
            var _Bo = $k[--$j]; //#9779
            var _Bp = $k[--$j]; //#9779
            $k[$j++] = $f(_Bp + 1); //#9779
            $k[$j++] = ~~(_Bo / _Bp); //#9779
        } //#9779
        var _Bq = $k[--$j]; //#9781
        var _Br = $k[--$j]; //#9781
        $k[$j++] = _Bq; //#9781
        $k[$j++] = _Br; //#9781
        $j--; //#9781
        var _Bs = $k[--$j]; //#9781
        var _Bt = $k[--$j]; //#9781
        $k[$j++] = _Bs; //#9781
        $k[$j++] = _Bt; //#9781
        $j--; //#9781
    }; //#9781
    $_.getRSSwidths = function() {
        $_.oe = $k[--$j]; //#9785
        $_.el = $k[--$j]; //#9786
        $_.mw = $k[--$j]; //#9787
        $_.nm = $k[--$j]; //#9788
        $_.val = $k[--$j]; //#9789
        $_.out = $a($_.el); //#9790
        $_.mask = 0; //#9791
        for (var _C3 = 0, _C2 = $f($_.el - 2); _C3 <= _C2; _C3 += 1) { //#9818
            $_.bar = _C3; //#9793
            $_.ew = 1; //#9794
            var _C5 = $_.bar; //#9795
            $_.mask = $_.mask | ((_C5 < 0 ? 1 >>> -_C5 : 1 << _C5)); //#9795
            for (;;) { //#9814
                $k[$j++] = 'sval'; //#9796
                $k[$j++] = $f($f($_.nm - $_.ew) - 1); //#9796
                $k[$j++] = $f($f($_.el - $_.bar) - 2); //#9796
                $_.ncr(); //#9796
                var _CA = $k[--$j]; //#9796
                $_[$k[--$j]] = _CA; //#9796
                if (($_.oe && ($_.mask == 0)) && (($f(($f($f($_.nm - $_.ew) - ($_.el * 2))) + ($_.bar * 2))) >= -2)) { //#9799
                    $k[$j++] = 'sval'; //#9798
                    $k[$j++] = $_.sval; //#9798
                    $k[$j++] = $f(($f($f($_.nm - $_.ew) - $_.el)) + $_.bar); //#9798
                    $k[$j++] = $f($f($_.el - $_.bar) - 2); //#9798
                    $_.ncr(); //#9798
                    var _CP = $k[--$j]; //#9798
                    var _CQ = $k[--$j]; //#9798
                    $_[$k[--$j]] = $f(_CQ - _CP); //#9798
                } //#9798
                if ($f($_.el - $_.bar) > 2) { //#9808
                    $_.lval = 0; //#9801
                    for (var _Ca = $f(($f(($f($f($_.nm - $_.ew) - $_.el)) + $_.bar)) + 2), _CZ = $f($_.mw + 1); _Ca >= _CZ; _Ca -= 1) { //#9805
                        $k[$j++] = $f(($f($f($_.nm - _Ca) - $_.ew)) - 1); //#9803
                        $k[$j++] = $f($f($_.el - $_.bar) - 3); //#9803
                        $_.ncr(); //#9803
                        $_.lval = $f($k[--$j] + $_.lval); //#9804
                    } //#9804
                    $_.sval = $f($_.sval - ($_.lval * ($f($f($_.el - $_.bar) - 1)))); //#9806
                } else { //#9808
                    if ($f($_.nm - $_.ew) > $_.mw) { //#9808
                        $_.sval = $f($_.sval - 1); //#9808
                    } //#9808
                } //#9808
                $_.val = $f($_.val - $_.sval); //#9810
                if ($_.val < 0) { //#9811
                    break; //#9811
                } //#9811
                $_.ew = $_.ew + 1; //#9812
                var _Cu = $_.bar; //#9813
                $_.mask = $_.mask & (~((_Cu < 0 ? 1 >>> -_Cu : 1 << _Cu))); //#9813
            } //#9813
            $_.val = $f($_.val + $_.sval); //#9815
            $_.nm = $f($_.nm - $_.ew); //#9816
            $put($_.out, $_.bar, $_.ew); //#9817
        } //#9817
        $put($_.out, $f($_.el - 1), $_.nm); //#9819
        $k[$j++] = $_.out; //#9820
    }; //#9820
    if (!bwipp_databarexpanded.__9831__) { //#9831
        $_ = Object.create($_); //#9831
        $_.tab174 = $a([347, 0, 12, 5, 7, 2, 87, 4, 1387, 348, 10, 7, 5, 4, 52, 20, 2947, 1388, 8, 9, 4, 5, 30, 52, 3987, 2948, 6, 11, 3, 6, 10, 104, 4191, 3988, 4, 13, 1, 8, 1, 204]); //#9830
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_databarexpanded.$ctx[id] = $_[id]); //#9830
        bwipp_databarexpanded.__9831__ = 1; //#9830
        $_ = Object.getPrototypeOf($_); //#9830
    } //#9830
    $_.dxw = $a($_.datalen); //#9833
    for (var _DC = 0, _DB = $_.datalen - 1; _DC <= _DB; _DC += 1) { //#9874
        $_.x = _DC; //#9837
        $_.d = $geti($_.binval, $_.x * 12, 12); //#9839
        $k[$j++] = 'd'; //#9840
        $k[$j++] = 0; //#9840
        for (var _DG = 0; _DG <= 11; _DG += 1) { //#9840
            $_.j = _DG; //#9840
            var _DL = $k[--$j]; //#9840
            $k[$j++] = $f(_DL + ((~~Math.pow(2, 11 - $_.j)) * $get($_.d, $_.j))); //#9840
        } //#9840
        var _DM = $k[--$j]; //#9840
        $_[$k[--$j]] = _DM; //#9840
        $_.j = 0; //#9842
        for (;;) { //#9852
            if ($le($_.d, $get($_.tab174, $_.j))) { //#9850
                var _DU = $geti($_.tab174, $_.j + 1, 7); //#9844
                for (var _DV = 0, _DW = _DU.length; _DV < _DW; _DV++) { //#9844
                    $k[$j++] = $get(_DU, _DV); //#9844
                } //#9844
                $_.dte = $k[--$j]; //#9845
                $_.dto = $k[--$j]; //#9845
                $_.dmwe = $k[--$j]; //#9846
                $_.dmwo = $k[--$j]; //#9846
                $_.dele = $k[--$j]; //#9847
                $_.delo = $k[--$j]; //#9847
                $_.dgs = $k[--$j]; //#9848
                break; //#9849
            } //#9849
            $_.j = $_.j + 8; //#9851
        } //#9851
        $k[$j++] = 'dwo'; //#9854
        $k[$j++] = ~~($f($_.d - $_.dgs) / $_.dte); //#9854
        $k[$j++] = $_.delo; //#9854
        $k[$j++] = $_.dmwo; //#9854
        $k[$j++] = 4; //#9854
        $k[$j++] = true; //#9854
        $_.getRSSwidths(); //#9854
        var _Dl = $k[--$j]; //#9854
        $_[$k[--$j]] = _Dl; //#9854
        $k[$j++] = 'dwe'; //#9855
        $k[$j++] = $f($_.d - $_.dgs) % $_.dte; //#9855
        $k[$j++] = $_.dele; //#9855
        $k[$j++] = $_.dmwe; //#9855
        $k[$j++] = 4; //#9855
        $k[$j++] = false; //#9855
        $_.getRSSwidths(); //#9855
        var _Ds = $k[--$j]; //#9855
        $_[$k[--$j]] = _Ds; //#9855
        $_.dw = $a(8); //#9857
        if (($_.x % 2) == 0) { //#9868
            for (var _Dw = 0; _Dw <= 3; _Dw += 1) { //#9863
                $_.j = _Dw; //#9860
                $put($_.dw, 7 - ($_.j * 2), $get($_.dwo, $_.j)); //#9861
                $put($_.dw, 6 - ($_.j * 2), $get($_.dwe, $_.j)); //#9862
            } //#9862
        } else { //#9868
            for (var _E7 = 0; _E7 <= 3; _E7 += 1) { //#9869
                $_.j = _E7; //#9866
                $put($_.dw, $_.j * 2, $get($_.dwo, $_.j)); //#9867
                $put($_.dw, ($_.j * 2) + 1, $get($_.dwe, $_.j)); //#9868
            } //#9868
        } //#9868
        $put($_.dxw, $_.x, $_.dw); //#9872
    } //#9872
    if (!bwipp_databarexpanded.__9898__) { //#9898
        $_ = Object.create($_); //#9898
        $_.finderwidths = $a([1, 8, 4, 1, 1, 1, 1, 4, 8, 1, 3, 6, 4, 1, 1, 1, 1, 4, 6, 3, 3, 4, 6, 1, 1, 1, 1, 6, 4, 3, 3, 2, 8, 1, 1, 1, 1, 8, 2, 3, 2, 6, 5, 1, 1, 1, 1, 5, 6, 2, 2, 2, 9, 1, 1, 1, 1, 9, 2, 2]); //#9884
        $_.finderseq = $a([$a([0, 1]), $a([0, 3, 2]), $a([0, 5, 2, 7]), $a([0, 9, 2, 7, 4]), $a([0, 9, 2, 7, 6, 11]), $a([0, 9, 2, 7, 8, 11, 10]), $a([0, 1, 2, 3, 4, 5, 6, 7]), $a([0, 1, 2, 3, 4, 5, 6, 9, 8]), $a([0, 1, 2, 3, 4, 5, 6, 9, 10, 11]), $a([0, 1, 2, 3, 4, 7, 6, 9, 8, 11, 10])]); //#9897
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_databarexpanded.$ctx[id] = $_[id]); //#9897
        bwipp_databarexpanded.__9898__ = 1; //#9897
        $_ = Object.getPrototypeOf($_); //#9897
    } //#9897
    $_.seq = $get($_.finderseq, ~~(($_.datalen - 2) / 2)); //#9900
    $_.fxw = $a($_.seq.length); //#9901
    for (var _Ef = 0, _Ee = $_.seq.length - 1; _Ef <= _Ee; _Ef += 1) { //#9905
        $_.x = _Ef; //#9903
        $put($_.fxw, $_.x, $geti($_.finderwidths, $get($_.seq, $_.x) * 5, 5)); //#9904
    } //#9904
    if (!bwipp_databarexpanded.__9934__) { //#9934
        $_ = Object.create($_); //#9934
        $_.checkweights = $a([-1, -1, -1, -1, -1, -1, -1, -1, 77, 96, 32, 81, 27, 9, 3, 1, 20, 60, 180, 118, 143, 7, 21, 63, 205, 209, 140, 117, 39, 13, 145, 189, 193, 157, 49, 147, 19, 57, 171, 91, 132, 44, 85, 169, 197, 136, 186, 62, 185, 133, 188, 142, 4, 12, 36, 108, 50, 87, 29, 80, 97, 173, 128, 113, 150, 28, 84, 41, 123, 158, 52, 156, 166, 196, 206, 139, 187, 203, 138, 46, 76, 17, 51, 153, 37, 111, 122, 155, 146, 119, 110, 107, 106, 176, 129, 43, 16, 48, 144, 10, 30, 90, 59, 177, 164, 125, 112, 178, 200, 137, 116, 109, 70, 210, 208, 202, 184, 130, 179, 115, 190, 204, 68, 93, 31, 151, 191, 134, 148, 22, 66, 198, 172, 94, 71, 2, 40, 154, 192, 64, 162, 54, 18, 6, 120, 149, 25, 75, 14, 42, 126, 167, 175, 199, 207, 69, 23, 78, 26, 79, 103, 98, 83, 38, 114, 131, 182, 124, 159, 53, 88, 170, 127, 183, 61, 161, 55, 165, 73, 8, 24, 72, 5, 15, 89, 100, 174, 58, 160, 194, 135, 45]); //#9933
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_databarexpanded.$ctx[id] = $_[id]); //#9933
        bwipp_databarexpanded.__9934__ = 1; //#9933
        $_ = Object.getPrototypeOf($_); //#9933
    } //#9933
    $k[$j++] = Infinity; //#9936
    $forall($_.seq, function() { //#9937
        $aload($geti($_.checkweights, $k[--$j] * 16, 16)); //#9937
    }); //#9937
    var _Et = $a(); //#9937
    $_.checkweightseq = $geti(_Et, 8, _Et.length - 8); //#9938
    $k[$j++] = Infinity; //#9940
    var _Ev = $_.dxw; //#9941
    for (var _Ew = 0, _Ex = _Ev.length; _Ew < _Ex; _Ew++) { //#9941
        $forall($get(_Ev, _Ew)); //#9941
    } //#9941
    $_.widths = $a(); //#9941
    $_.checksum = 0; //#9944
    for (var _F2 = 0, _F1 = $_.widths.length - 1; _F2 <= _F1; _F2 += 1) { //#9948
        $_.i = _F2; //#9946
        $_.checksum = $f($_.checksum + ($get($_.widths, $_.i) * $get($_.checkweightseq, $_.i))); //#9947
    } //#9947
    $_.checksum = $f(($_.checksum % 211) + (($_.datalen - 3) * 211)); //#9949
    $_.i = 0; //#9951
    for (;;) { //#9961
        if ($_.checksum <= $get($_.tab174, $_.i)) { //#9959
            var _FI = $geti($_.tab174, $_.i + 1, 7); //#9953
            for (var _FJ = 0, _FK = _FI.length; _FJ < _FK; _FJ++) { //#9953
                $k[$j++] = $get(_FI, _FJ); //#9953
            } //#9953
            $_.cte = $k[--$j]; //#9954
            $_.cto = $k[--$j]; //#9954
            $_.cmwe = $k[--$j]; //#9955
            $_.cmwo = $k[--$j]; //#9955
            $_.cele = $k[--$j]; //#9956
            $_.celo = $k[--$j]; //#9956
            $_.cgs = $k[--$j]; //#9957
            break; //#9958
        } //#9958
        $_.i = $_.i + 8; //#9960
    } //#9960
    $k[$j++] = 'cwo'; //#9963
    $k[$j++] = ~~($f($_.checksum - $_.cgs) / $_.cte); //#9963
    $k[$j++] = $_.celo; //#9963
    $k[$j++] = $_.cmwo; //#9963
    $k[$j++] = 4; //#9963
    $k[$j++] = true; //#9963
    $_.getRSSwidths(); //#9963
    var _FZ = $k[--$j]; //#9963
    $_[$k[--$j]] = _FZ; //#9963
    $k[$j++] = 'cwe'; //#9964
    $k[$j++] = $f($_.checksum - $_.cgs) % $_.cte; //#9964
    $k[$j++] = $_.cele; //#9964
    $k[$j++] = $_.cmwe; //#9964
    $k[$j++] = 4; //#9964
    $k[$j++] = false; //#9964
    $_.getRSSwidths(); //#9964
    var _Fg = $k[--$j]; //#9964
    $_[$k[--$j]] = _Fg; //#9964
    $_.cw = $a(8); //#9966
    for (var _Fj = 0; _Fj <= 3; _Fj += 1) { //#9971
        $_.i = _Fj; //#9968
        $put($_.cw, $_.i * 2, $get($_.cwo, $_.i)); //#9969
        $put($_.cw, ($_.i * 2) + 1, $get($_.cwe, $_.i)); //#9970
    } //#9970
    var _Fu = $a(22); //#9973
    $put(_Fu, 0, $_.cw); //#9974
    $puti(_Fu, 1, $_.dxw); //#9974
    $_.dxw = $geti(_Fu, 0, $_.datalen + 1); //#9975
    $_.datalen = $_.dxw.length; //#9976
    $_.rows = $a(~~Math.ceil($_.datalen / $_.segments)); //#9979
    $_.numrows = $_.rows.length; //#9980
    for (var _G6 = 0, _G5 = $_.numrows - 1; _G6 <= _G5; _G6 += 1) { //#9995
        $_.r = _G6; //#9982
        $k[$j++] = Infinity; //#9983
        if ((($_.segments % 4) != 0) && (($_.r % 2) == 1)) { //#9984
            $k[$j++] = 0; //#9984
        } //#9984
        $k[$j++] = 1; //#9992
        $k[$j++] = 1; //#9992
        for (var _GB = 0, _GA = $_.segments - 1; _GB <= _GA; _GB += 1) { //#9992
            $_.pos = _GB + ($_.r * $_.segments); //#9987
            if ($_.pos < $_.datalen) { //#9991
                $forall($get($_.dxw, $_.pos)); //#9989
                if (($_.pos % 2) == 0) { //#9990
                    $forall($get($_.fxw, ~~($_.pos / 2))); //#9990
                } //#9990
            } //#9990
        } //#9990
        var _GN = $counttomark() + 2; //#9994
        $k[$j++] = 1; //#9994
        $k[$j++] = 1; //#9994
        $astore($a(_GN)); //#9994
        $put($_.rows, $_.r, $k[--$j]); //#9994
        $j--; //#9994
    } //#9994
    if ($ne($_.format, "expandedstacked")) { //#10127
        var _GU = $get($_.rows, 0); //#10000
        $_.sbs = $geti(_GU, 1, _GU.length - 1); //#10000
        $k[$j++] = Infinity; //#10002
        $k[$j++] = 1; //#10008
        for (var _GY = 0, _GX = $_.datalen - 1; _GY <= _GX; _GY += 1) { //#10008
            $_.i = _GY; //#10005
            $forall($get($_.dxw, $_.i)); //#10006
            if (($_.i % 2) == 0) { //#10007
                $forall($get($_.fxw, ~~($_.i / 2))); //#10007
            } //#10007
        } //#10007
        $k[$j++] = 1; //#10009
        $k[$j++] = 1; //#10009
        $_.sbs = $a(); //#10009
        $k[$j++] = Infinity; //#10012
        var _Gh = $_.sbs; //#10014
        $k[$j++] = Infinity; //#10015
        for (var _Gj = 0, _Gk = ~~(($_.sbs.length + 1) / 2); _Gj < _Gk; _Gj++) { //#10015
            $k[$j++] = $_.height; //#10015
        } //#10015
        var _Gm = $a(); //#10015
        $k[$j++] = Infinity; //#10016
        for (var _Go = 0, _Gp = ~~(($_.sbs.length + 1) / 2); _Go < _Gp; _Go++) { //#10016
            $k[$j++] = 0; //#10016
        } //#10016
        var _Gq = $a(); //#10016
        $k[$j++] = 'ren'; //#10021
        $k[$j++] = 'renlinear'; //#10021
        $k[$j++] = 'sbs'; //#10021
        $k[$j++] = _Gh; //#10021
        $k[$j++] = 'bhs'; //#10021
        $k[$j++] = _Gm; //#10021
        $k[$j++] = 'bbs'; //#10021
        $k[$j++] = _Gq; //#10021
        $k[$j++] = 'borderleft'; //#10021
        $k[$j++] = 0; //#10021
        $k[$j++] = 'borderright'; //#10021
        $k[$j++] = 0; //#10021
        $k[$j++] = 'bordertop'; //#10021
        $k[$j++] = 0; //#10021
        $k[$j++] = 'borderbottom'; //#10021
        $k[$j++] = 0; //#10021
        $k[$j++] = 'opt'; //#10021
        $k[$j++] = $_.options; //#10021
        var _Gs = $d(); //#10021
        $k[$j++] = _Gs; //#10024
        if (!$_.dontdraw) { //#10024
            bwipp_renlinear(); //#10024
        } //#10024
    } else { //#10127
        $_.seps = $a($_.numrows); //#10028
        for (var _Gy = 0, _Gx = $_.numrows - 1; _Gy <= _Gx; _Gy += 1) { //#10084
            $_.r = _Gy; //#10031
            $_.row = $get($_.rows, $_.r); //#10032
            $k[$j++] = Infinity; //#10035
            for (var _H4 = 0, _H3 = $_.row.length - 1; _H4 <= _H3; _H4 += 2) { //#10040
                $_.i = _H4; //#10037
                for (var _H8 = 0, _H9 = $get($_.row, $_.i); _H8 < _H9; _H8++) { //#10038
                    $k[$j++] = 0; //#10038
                } //#10038
                if ($_.i < ($_.row.length - 1)) { //#10039
                    for (var _HF = 0, _HG = $get($_.row, $_.i + 1); _HF < _HG; _HF++) { //#10039
                        $k[$j++] = 1; //#10039
                    } //#10039
                } //#10039
            } //#10039
            $astore($a($counttomark())); //#10041
            $_.row = $k[--$j]; //#10041
            $j--; //#10041
            $k[$j++] = Infinity; //#10044
            $forall($_.row, function() { //#10044
                var _HL = $k[--$j]; //#10044
                $k[$j++] = $f(1 - _HL); //#10044
            }); //#10044
            $_.sep = $a(); //#10044
            $k[$j++] = Infinity; //#10045
            for (var _HP = 19, _HO = $_.row.length - 13; _HP <= _HO; _HP += 98) { //#10046
                $k[$j++] = _HP; //#10046
            } //#10046
            for (var _HS = 68, _HR = $_.row.length - 13; _HS <= _HR; _HS += 98) { //#10047
                $k[$j++] = _HS; //#10047
            } //#10047
            $_.finderpos = $a(); //#10047
            var _HU = $_.finderpos; //#10049
            for (var _HV = 0, _HW = _HU.length; _HV < _HW; _HV++) { //#10063
                var _HX = $get(_HU, _HV); //#10063
                for (var _HZ = _HX, _HY = $f(_HX + 14); _HZ <= _HY; _HZ += 1) { //#10062
                    $_.i = _HZ; //#10051
                    if ($get($_.row, $_.i) == 0) { //#10059
                        if ($get($_.row, $_.i - 1) == 1) { //#10056
                            $k[$j++] = 1; //#10054
                        } else { //#10056
                            var _Hj = ($get($_.sep, $_.i - 1) == 0) ? 1 : 0; //#10056
                            $k[$j++] = _Hj; //#10056
                        } //#10056
                    } else { //#10059
                        $k[$j++] = 0; //#10059
                    } //#10059
                    $put($_.sep, $_.i, $k[--$j]); //#10061
                } //#10061
            } //#10061
            $puti($_.sep, 0, $a([0, 0, 0, 0])); //#10064
            $puti($_.sep, $_.row.length - 4, $a([0, 0, 0, 0])); //#10065
            if ((($_.segments % 4) == 0) && (($_.r % 2) == 1)) { //#10079
                if (($get($_.rows, $_.r).length != $get($_.rows, 0).length) && (($_.finderpos.length % 2) == 1)) { //#10077
                    $k[$j++] = Infinity; //#10071
                    $k[$j++] = 0; //#10071
                    $aload($_.row); //#10071
                    $_.row = $a(); //#10071
                    $k[$j++] = Infinity; //#10072
                    $k[$j++] = 0; //#10072
                    $aload($_.sep); //#10072
                    $_.sep = $a(); //#10072
                } else { //#10077
                    for (var _I5 = $_.row.length - 1; _I5 >= 0; _I5 -= 1) { //#10074
                        $k[$j++] = $get($_.row, _I5); //#10074
                    } //#10074
                    $astore($_.row); //#10075
                    $j--; //#10075
                    for (var _IA = $_.sep.length - 1; _IA >= 0; _IA -= 1) { //#10076
                        $k[$j++] = $get($_.sep, _IA); //#10076
                    } //#10076
                    $astore($_.sep); //#10077
                    $j--; //#10077
                } //#10077
            } //#10077
            $put($_.rows, $_.r, $_.row); //#10081
            $put($_.seps, $_.r, $_.sep); //#10082
        } //#10082
        $_.pixx = $get($_.rows, 0).length; //#10087
        $k[$j++] = Infinity; //#10088
        for (var _IN = 0, _IO = $_.pixx; _IN < _IO; _IN++) { //#10088
            $k[$j++] = 0; //#10088
        } //#10088
        var _IP = $a(); //#10088
        $puti(_IP, 0, $get($_.rows, $_.numrows - 1)); //#10088
        $put($_.rows, $_.numrows - 1, _IP); //#10089
        $k[$j++] = Infinity; //#10090
        for (var _IW = 0, _IX = $_.pixx; _IW < _IX; _IW++) { //#10090
            $k[$j++] = 0; //#10090
        } //#10090
        var _IY = $a(); //#10090
        $puti(_IY, 0, $get($_.seps, $_.numrows - 1)); //#10090
        $put($_.seps, $_.numrows - 1, _IY); //#10091
        $k[$j++] = Infinity; //#10094
        for (var _If = 0, _Ig = (~~($_.pixx / 2)) + 1; _If < _Ig; _If++) { //#10094
            $k[$j++] = 0; //#10094
            $k[$j++] = 1; //#10094
        } //#10094
        $_.sep = $geti($a(), 0, $_.pixx); //#10094
        $puti($_.sep, 0, $a([0, 0, 0, 0])); //#10095
        $puti($_.sep, $_.pixx - 4, $a([0, 0, 0, 0])); //#10096
        $k[$j++] = Infinity; //#10099
        for (var _Ir = 0, _Iq = $_.numrows - 1; _Ir <= _Iq; _Ir += 1) { //#10110
            $_.r = _Ir; //#10101
            if ($_.r != 0) { //#10104
                $aload($get($_.seps, $_.r)); //#10103
            } //#10103
            for (var _Ix = 0, _Iy = $_.barxmult; _Ix < _Iy; _Ix++) { //#10105
                $aload($get($_.rows, $_.r)); //#10105
            } //#10105
            if ($_.r != ($_.numrows - 1)) { //#10109
                $aload($get($_.seps, $_.r)); //#10107
                $aload($_.sep); //#10108
            } //#10108
        } //#10108
        $_.pixs = $a(); //#10108
        var _JH = new Map([
            ["ren", 'renmatrix'],
            ["pixs", $_.pixs],
            ["pixx", $_.pixx],
            ["pixy", ~~($_.pixs.length / $_.pixx)],
            ["height", (~~($_.pixs.length / $_.pixx)) / 72],
            ["width", $_.pixx / 72],
            ["borderleft", 0],
            ["borderright", 0],
            ["bordertop", 0],
            ["borderbottom", 0],
            ["opt", $_.options]
        ]); //#10124
        $k[$j++] = _JH; //#10127
        if (!$_.dontdraw) { //#10127
            bwipp_renmatrix(); //#10127
        } //#10127
    } //#10127
    $_ = Object.getPrototypeOf($_); //#10131
    $_ = Object.getPrototypeOf($_); //#10133
} //bwipp_databarexpanded
function bwipp_databarexpandedstacked() {
    $_ = Object.create($_); //#10162
    $_.dontdraw = false; //#10165
    $k[$j++] = $_; //#10167
    bwipp_processoptions(); //#10167
    $_.options = $k[--$j]; //#10167
    $_.barcode = $k[--$j]; //#10168
    $put($_.options, "dontdraw", true); //#10171
    $put($_.options, "format", "expandedstacked"); //#10172
    $k[$j++] = 'args'; //#10174
    $k[$j++] = $_.barcode; //#10174
    $k[$j++] = $_.options; //#10174
    bwipp_databarexpanded(); //#10174
    var _6 = $k[--$j]; //#10174
    $_[$k[--$j]] = _6; //#10174
    $put($_.args, "opt", $_.options); //#10176
    $k[$j++] = $_.args; //#10179
    if (!$_.dontdraw) { //#10179
        bwipp_renmatrix(); //#10179
    } //#10179
    $_ = Object.getPrototypeOf($_); //#10181
} //bwipp_databarexpandedstacked
function bwipp_gs1northamericancoupon() {
    $_ = Object.create($_); //#10211
    $_.dontdraw = false; //#10214
    $_.includetext = false; //#10215
    $_.coupontextfont = "OCR-B"; //#10216
    $_.coupontextsize = 9; //#10217
    $_.coupontextxoffset = null; //#10218
    $_.coupontextyoffset = null; //#10219
    $_.parse = false; //#10220
    $_.dontlint = false; //#10221
    $_.lintreqs = true; //#10222
    $k[$j++] = $_; //#10224
    bwipp_processoptions(); //#10224
    $_.options = $k[--$j]; //#10224
    $_.barcode = $k[--$j]; //#10225
    $k[$j++] = $_.barcode; //#10227
    $k[$j++] = 'ai'; //#10227
    bwipp_gs1process(); //#10227
    $j--; //#10228
    $_.vals = $k[--$j]; //#10229
    $_.ais = $k[--$j]; //#10230
    if ($_.ais.length != 1) { //#10235
        $k[$j++] = 'bwipp.gs1northamericancouponBadAIStructure#10234'; //#10234
        $k[$j++] = "A GS1 North American Coupon should consist of a single AI (8110)"; //#10234
        bwipp_raiseerror(); //#10234
    } //#10234
    if ($ne($get($_.ais, 0), "8110")) { //#10238
        $k[$j++] = 'bwipp.gs1northamericancouponBadAIStructure#10237'; //#10237
        $k[$j++] = "A GS1 North American Coupon should consist of a single AI (8110)"; //#10237
        bwipp_raiseerror(); //#10237
    } //#10237
    $_.val = $get($_.vals, 0); //#10241
    $_.vli = $f($get($_.val, 0) - 48); //#10242
    if (($_.vli < 0) || ($_.vli > 6)) { //#10245
        $k[$j++] = 'bwipp.gs1northamericancouponBadVLI#10244'; //#10244
        $k[$j++] = "The AI (8110) data should start with a Company Prefix length indicator in the range 0 to 6"; //#10244
        bwipp_raiseerror(); //#10244
    } //#10244
    $_.gcp = $geti($_.val, 1, $f($_.vli + 6)); //#10246
    $_.cod = $geti($_.val, $f($_.vli + 7), 6); //#10247
    $_.coupontext = $s($_.gcp.length + 7); //#10248
    $puti($_.coupontext, 0, $_.gcp); //#10249
    $puti($_.coupontext, $_.gcp.length, "-"); //#10250
    $puti($_.coupontext, $_.gcp.length + 1, $_.cod); //#10251
    $put($_.options, "dontdraw", true); //#10254
    $k[$j++] = 'args'; //#10256
    $k[$j++] = $_.barcode; //#10256
    $k[$j++] = $_.options; //#10256
    bwipp_databarexpandedstacked(); //#10256
    var _W = $k[--$j]; //#10256
    $_[$k[--$j]] = _W; //#10256
    if ($_.includetext) { //#10275
        if ($eq($_.coupontextxoffset, null)) { //#10262
            $_.coupontextxoffset = 0; //#10261
        } //#10261
        if ($eq($_.coupontextyoffset, null)) { //#10265
            $_.coupontextyoffset = $f(($get($_.args, "height") * 72) + 3); //#10264
        } //#10264
        var _e = $get($_.args, "txt") !== undefined; //#10266
        if (_e) { //#10273
            $_.txt = $get($_.args, "txt"); //#10267
            $_.newtxt = $a($_.txt.length + 1); //#10268
            $puti($_.newtxt, 0, $_.txt); //#10269
            $put($_.newtxt, $_.newtxt.length - 1, $a([$_.coupontext, $_.coupontextxoffset, $_.coupontextyoffset, $_.coupontextfont, $_.coupontextsize])); //#10270
            $put($_.args, "txt", $_.newtxt); //#10271
        } else { //#10273
            $put($_.args, "txt", $a([$a([$_.coupontext, $_.coupontextxoffset, $_.coupontextyoffset, $_.coupontextfont, $_.coupontextsize])])); //#10273
        } //#10273
    } //#10273
    $put($_.args, "opt", $_.options); //#10277
    $k[$j++] = $_.args; //#10280
    if (!$_.dontdraw) { //#10280
        bwipp_renmatrix(); //#10280
    } //#10280
    $_ = Object.getPrototypeOf($_); //#10282
} //bwipp_gs1northamericancoupon
function bwipp_pharmacode() {
    $_ = Object.create($_); //#10310
    $_.dontdraw = false; //#10313
    $_.height = (8 * 2.835) / 72; //#10314
    $_.nwidth = 0.5 * 2.835; //#10315
    $_.wwidth = 1.5 * 2.835; //#10316
    $_.swidth = 1 * 2.835; //#10317
    $k[$j++] = $_; //#10319
    bwipp_processoptions(); //#10319
    $_.options = $k[--$j]; //#10319
    $_.barcode = $k[--$j]; //#10320
    if (($_.barcode.length < 1) || ($_.barcode.length > 6)) { //#10325
        $k[$j++] = 'bwipp.pharmacodeBadLength#10324'; //#10324
        $k[$j++] = "Pharmacode must be 1 to 6 digits"; //#10324
        bwipp_raiseerror(); //#10324
    } //#10324
    $forall($_.barcode, function() { //#10330
        var _5 = $k[--$j]; //#10327
        if ((_5 < 48) || (_5 > 57)) { //#10329
            $k[$j++] = 'bwipp.pharmacodeBadCharacter#10328'; //#10328
            $k[$j++] = "Pharmacode must contain only digits"; //#10328
            bwipp_raiseerror(); //#10328
        } //#10328
    }); //#10328
    var _7 = $cvi($_.barcode); //#10331
    if ((_7 < 3) || (_7 > 131070)) { //#10333
        $k[$j++] = 'bwipp.pharmacodeBadValue#10332'; //#10332
        $k[$j++] = "Pharmacode value must be between 3 and 131070"; //#10332
        bwipp_raiseerror(); //#10332
    } //#10332
    $_.txt = $a($_.barcode.length); //#10336
    for (var _C = 0, _B = $_.barcode.length - 1; _C <= _B; _C += 1) { //#10340
        $_.i = _C; //#10338
        $put($_.txt, $_.i, $a([$geti($_.barcode, $_.i, 1), 0, 0, "", 0])); //#10339
    } //#10339
    $_.barcode = $cvrs($s(17), $cvi($_.barcode) + 1, 2); //#10343
    $_.barcode = $geti($_.barcode, 1, $_.barcode.length - 1); //#10344
    $_.barlen = $_.barcode.length; //#10346
    $_.sbs = $a($_.barlen * 2); //#10347
    for (var _U = 0, _T = $_.barlen - 1; _U <= _T; _U += 1) { //#10358
        $_.i = _U; //#10350
        $_.enc = $geti($_.barcode, $_.i, 1); //#10351
        if ($eq($_.enc, "0")) { //#10355
            $put($_.sbs, $_.i * 2, $_.nwidth); //#10353
        } else { //#10355
            $put($_.sbs, $_.i * 2, $_.wwidth); //#10355
        } //#10355
        $put($_.sbs, ($_.i * 2) + 1, $_.swidth); //#10357
    } //#10357
    $k[$j++] = Infinity; //#10361
    var _i = $_.sbs; //#10363
    $k[$j++] = Infinity; //#10364
    for (var _k = 0, _l = ~~(($_.sbs.length + 1) / 2); _k < _l; _k++) { //#10364
        $k[$j++] = $_.height; //#10364
    } //#10364
    var _n = $a(); //#10364
    $k[$j++] = Infinity; //#10365
    for (var _p = 0, _q = ~~(($_.sbs.length + 1) / 2); _p < _q; _p++) { //#10365
        $k[$j++] = 0; //#10365
    } //#10365
    var _r = $a(); //#10365
    $k[$j++] = 'ren'; //#10368
    $k[$j++] = 'renlinear'; //#10368
    $k[$j++] = 'sbs'; //#10368
    $k[$j++] = _i; //#10368
    $k[$j++] = 'bhs'; //#10368
    $k[$j++] = _n; //#10368
    $k[$j++] = 'bbs'; //#10368
    $k[$j++] = _r; //#10368
    $k[$j++] = 'txt'; //#10368
    $k[$j++] = $_.txt; //#10368
    $k[$j++] = 'textxalign'; //#10368
    $k[$j++] = "center"; //#10368
    $k[$j++] = 'opt'; //#10368
    $k[$j++] = $_.options; //#10368
    var _u = $d(); //#10368
    $k[$j++] = _u; //#10371
    if (!$_.dontdraw) { //#10371
        bwipp_renlinear(); //#10371
    } //#10371
    $_ = Object.getPrototypeOf($_); //#10373
} //bwipp_pharmacode
function bwipp_pharmacode2() {
    $_ = Object.create($_); //#10401
    $_.dontdraw = false; //#10404
    $_.includetext = false; //#10405
    $_.height = 4; //#10406
    $k[$j++] = $_; //#10408
    bwipp_processoptions(); //#10408
    $_.options = $k[--$j]; //#10408
    $_.barcode = $k[--$j]; //#10409
    if (($_.barcode.length < 1) || ($_.barcode.length > 8)) { //#10414
        $k[$j++] = 'bwipp.pharmacode2BadLength#10413'; //#10413
        $k[$j++] = "Two-track Pharmacode must be 1 to 6 digits"; //#10413
        bwipp_raiseerror(); //#10413
    } //#10413
    $forall($_.barcode, function() { //#10419
        var _5 = $k[--$j]; //#10416
        if ((_5 < 48) || (_5 > 57)) { //#10418
            $k[$j++] = 'bwipp.pharmacode2badCharacter#10417'; //#10417
            $k[$j++] = "Two-track Pharmacode must contain only digits"; //#10417
            bwipp_raiseerror(); //#10417
        } //#10417
    }); //#10417
    var _7 = $cvi($_.barcode); //#10420
    if ((_7 < 4) || (_7 > 64570080)) { //#10422
        $k[$j++] = 'bwipp.pharmacode2badValue#10421'; //#10421
        $k[$j++] = "Two-track Pharmacode value must be between 4 and 64570080"; //#10421
        bwipp_raiseerror(); //#10421
    } //#10421
    $_.txt = $a($_.barcode.length); //#10425
    for (var _C = 0, _B = $_.barcode.length - 1; _C <= _B; _C += 1) { //#10429
        $_.i = _C; //#10427
        $put($_.txt, $_.i, $a([$geti($_.barcode, $_.i, 1), 0, 0, "", 0])); //#10428
    } //#10428
    $_.encstr = $s(16); //#10431
    $_.sbs = $a(32); //#10432
    $_.bar = (1 / 25.4) * $_.height; //#10433
    $_.spc = (1 / 25.4) * 72; //#10434
    $_.i = 15; //#10437
    $_.val = $cvi($_.barcode); //#10438
    for (;;) { //#10445
        if ($_.val == 0) { //#10440
            break; //#10440
        } //#10440
        var _P = $_.val % 3; //#10441
        $_.val = ~~($f($_.val - $get($a([3, 1, 2]), _P)) / 3); //#10442
        $put($_.encstr, $_.i, $get($a([2, 0, 1]), _P)); //#10443
        $_.i = $_.i - 1; //#10444
    } //#10444
    $_.encstr = $geti($_.encstr, $_.i + 1, 15 - $_.i); //#10446
    $_.bhs = $a($_.encstr.length); //#10449
    $_.bbs = $a($_.encstr.length); //#10450
    for (var _i = 0, _h = $_.encstr.length - 1; _i <= _h; _i += 1) { //#10456
        $_.i = _i; //#10452
        var _l = $get($_.encstr, $_.i); //#10453
        $put($_.bhs, $_.i, $_.bar * $get($a([1, 1, 2]), _l)); //#10454
        $put($_.bbs, $_.i, $get($a([0, $_.bar, 0]), _l)); //#10455
    } //#10455
    $k[$j++] = Infinity; //#10459
    var _w = $_.bhs; //#10461
    var _x = $_.bbs; //#10462
    $k[$j++] = Infinity; //#10463
    for (var _z = 0, _10 = $_.encstr.length * 2; _z < _10; _z++) { //#10463
        $k[$j++] = $_.spc; //#10463
    } //#10463
    var _12 = $a(); //#10463
    $k[$j++] = 'ren'; //#10467
    $k[$j++] = 'renlinear'; //#10467
    $k[$j++] = 'bhs'; //#10467
    $k[$j++] = _w; //#10467
    $k[$j++] = 'bbs'; //#10467
    $k[$j++] = _x; //#10467
    $k[$j++] = 'sbs'; //#10467
    $k[$j++] = _12; //#10467
    $k[$j++] = 'txt'; //#10467
    $k[$j++] = $_.txt; //#10467
    $k[$j++] = 'textxalign'; //#10467
    $k[$j++] = "center"; //#10467
    $k[$j++] = 'textyoffset'; //#10467
    $k[$j++] = 4; //#10467
    $k[$j++] = 'opt'; //#10467
    $k[$j++] = $_.options; //#10467
    var _15 = $d(); //#10467
    $k[$j++] = _15; //#10470
    if (!$_.dontdraw) { //#10470
        bwipp_renlinear(); //#10470
    } //#10470
    $_ = Object.getPrototypeOf($_); //#10472
} //bwipp_pharmacode2
function bwipp_code2of5() {
    $_ = Object.create($_); //#10502
    $_.dontdraw = false; //#10505
    $_.includecheck = false; //#10506
    $_.validatecheck = false; //#10507
    $_.includetext = false; //#10508
    $_.includecheckintext = false; //#10509
    $_.textfont = "OCR-B"; //#10510
    $_.textsize = 10; //#10511
    $_.textyoffset = -8; //#10512
    $_.height = 1; //#10513
    $_.version = "industrial"; //#10514
    $k[$j++] = $_; //#10516
    bwipp_processoptions(); //#10516
    $_.options = $k[--$j]; //#10516
    $_.barcode = $k[--$j]; //#10517
    if ($eq($_.barcode, "")) { //#10521
        $k[$j++] = 'bwipp.code2of5emptyData#10520'; //#10520
        $k[$j++] = "The data must not be empty"; //#10520
        bwipp_raiseerror(); //#10520
    } //#10520
    bwipp_loadctx(bwipp_code2of5) //#10523
    $forall($_.barcode, function() { //#10530
        var _4 = $k[--$j]; //#10527
        if ((_4 < 48) || (_4 > 57)) { //#10529
            $k[$j++] = 'bwipp.code2of5badCharacter#10528'; //#10528
            $k[$j++] = "Code 25 must contain only digits"; //#10528
            bwipp_raiseerror(); //#10528
        } //#10528
    }); //#10528
    $k[$j++] = 'barlen'; //#10532
    $k[$j++] = $_.barcode.length; //#10532
    if ($_.validatecheck) { //#10532
        var _7 = $k[--$j]; //#10532
        $k[$j++] = $f(_7 - 1); //#10532
    } //#10532
    var _8 = $k[--$j]; //#10532
    $_[$k[--$j]] = _8; //#10532
    $_.checksum = 0; //#10534
    for (var _C = 0, _B = $f($_.barlen - 1); _C <= _B; _C += 1) { //#10538
        $_.i = _C; //#10536
        $k[$j++] = 'checksum'; //#10537
        $k[$j++] = $_.checksum; //#10537
        $k[$j++] = $f($get($_.barcode, $_.i) - 48); //#10537
        if (($f($_.barlen - $_.i) % 2) != 0) { //#10537
            var _J = $k[--$j]; //#10537
            $k[$j++] = _J * 3; //#10537
        } //#10537
        var _K = $k[--$j]; //#10537
        var _L = $k[--$j]; //#10537
        $_[$k[--$j]] = $f(_L + _K); //#10537
    } //#10537
    $_.checksum = (10 - ($_.checksum % 10)) % 10; //#10539
    if ($_.validatecheck) { //#10546
        if ($get($_.barcode, $_.barlen) != ($_.checksum + 48)) { //#10543
            $k[$j++] = 'bwipp.code2of5badCheckDigit#10542'; //#10542
            $k[$j++] = "Incorrect Code 25 check digit provided"; //#10542
            bwipp_raiseerror(); //#10542
        } //#10542
        $_.barcode = $geti($_.barcode, 0, $_.barlen); //#10544
        $_.includecheck = true; //#10545
    } //#10545
    if (!bwipp_code2of5.__10574__) { //#10574
        $_ = Object.create($_); //#10574
        var _b = new Map([
            ["industrial", $a(["1111313111", "3111111131", "1131111131", "3131111111", "1111311131", "3111311111", "1131311111", "1111113131", "3111113111", "1131113111", "313111", "31113"])],
            ["iata", $a(["1111313111", "3111111131", "1131111131", "3131111111", "1111311131", "3111311111", "1131311111", "1111113131", "3111113111", "1131113111", "1111", "311"])],
            ["matrix", $a(["113311", "311131", "131131", "331111", "113131", "313111", "133111", "111331", "311311", "131311", "311111", "31111"])],
            ["coop", $a(["331111", "111331", "113131", "113311", "131131", "131311", "133111", "311131", "311311", "313111", "3131", "133"])],
            ["datalogic", $a(["113311", "311131", "131131", "331111", "113131", "313111", "133111", "111331", "311311", "131311", "1111", "311"])]
        ]); //#10571
        $_.versions = _b; //#10573
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_code2of5.$ctx[id] = $_[id]); //#10573
        bwipp_code2of5.__10574__ = 1; //#10573
        $_ = Object.getPrototypeOf($_); //#10573
    } //#10573
    var _f = $get($_.versions, $_.version) !== undefined; //#10576
    if (!_f) { //#10578
        $k[$j++] = 'bwipp.code2of5badVersion#10577'; //#10577
        $k[$j++] = "Unrecognised Code 25 version"; //#10577
        bwipp_raiseerror(); //#10577
    } //#10577
    $_.encs = $get($_.versions, $_.version); //#10579
    $_.cs = $get($_.encs, 0).length; //#10581
    $k[$j++] = 'cw'; //#10582
    $k[$j++] = 0; //#10582
    $forall($get($_.encs, 0), function() { //#10582
        var _n = $k[--$j]; //#10582
        var _o = $k[--$j]; //#10582
        $k[$j++] = $f(_o + $f(_n - 48)); //#10582
    }); //#10582
    var _p = $k[--$j]; //#10582
    $_[$k[--$j]] = _p; //#10582
    $_.ss = $get($_.encs, 10).length; //#10583
    $k[$j++] = 'sw'; //#10584
    $k[$j++] = 0; //#10584
    $forall($get($_.encs, 10), function() { //#10584
        var _v = $k[--$j]; //#10584
        var _w = $k[--$j]; //#10584
        $k[$j++] = $f(_w + $f(_v - 48)); //#10584
    }); //#10584
    var _x = $k[--$j]; //#10584
    $_[$k[--$j]] = _x; //#10584
    var _10 = $get($_.encs, 11); //#10585
    $_.es = _10.length; //#10585
    if (!bwipp_code2of5.__10590__) { //#10590
        $_ = Object.create($_); //#10590
        $_.barchars = "0123456789"; //#10589
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_code2of5.$ctx[id] = $_[id]); //#10589
        bwipp_code2of5.__10590__ = 1; //#10589
        $_ = Object.getPrototypeOf($_); //#10589
    } //#10589
    $k[$j++] = 'sbs'; //#10592
    $k[$j++] = $_.barlen; //#10592
    if ($_.includecheck) { //#10592
        var _14 = $k[--$j]; //#10592
        $k[$j++] = $f(_14 + 1); //#10592
    } //#10592
    var _19 = $s($f(($f(($k[--$j] * $_.cs) + $_.ss)) + $_.es)); //#10592
    $_[$k[--$j]] = _19; //#10592
    $k[$j++] = 'txt'; //#10593
    $k[$j++] = $_.barlen; //#10593
    if ($_.includecheck) { //#10593
        var _1D = $k[--$j]; //#10593
        $k[$j++] = $f(_1D + 1); //#10593
    } //#10593
    var _1F = $a($k[--$j]); //#10593
    $_[$k[--$j]] = _1F; //#10593
    $puti($_.sbs, 0, $get($_.encs, 10)); //#10596
    for (var _1M = 0, _1L = $f($_.barlen - 1); _1M <= _1L; _1M += 1) { //#10607
        $_.i = _1M; //#10598
        $search($_.barchars, $geti($_.barcode, $_.i, 1)); //#10600
        $j--; //#10601
        $_.indx = $k[--$j].length; //#10602
        $j -= 2; //#10603
        $_.enc = $get($_.encs, $_.indx); //#10604
        $puti($_.sbs, ($_.i * $_.cs) + $_.ss, $_.enc); //#10605
        $put($_.txt, $_.i, $a([$geti($_.barcode, $_.i, 1), $f(($_.i * $_.cw) + $_.sw), $_.textyoffset, $_.textfont, $_.textsize])); //#10606
    } //#10606
    if ($_.includecheck) { //#10619
        $puti($_.sbs, $f(($_.barlen * $_.cs) + $_.ss), $get($_.encs, $_.checksum)); //#10611
        $puti($_.sbs, $f(($f(($_.barlen * $_.cs) + $_.cs)) + $_.ss), $get($_.encs, 11)); //#10612
        if ($_.includecheckintext) { //#10616
            $put($_.txt, $_.barlen, $a([$geti($_.barchars, $_.checksum, 1), $f(($_.barlen * $_.cw) + $_.sw), $_.textyoffset, $_.textfont, $_.textsize])); //#10614
        } else { //#10616
            $put($_.txt, $_.barlen, $a([" ", $f(($_.barlen * $_.cw) + $_.sw), $_.textyoffset, $_.textfont, $_.textsize])); //#10616
        } //#10616
    } else { //#10619
        $puti($_.sbs, $f(($_.barlen * $_.cs) + $_.ss), $get($_.encs, 11)); //#10619
    } //#10619
    $k[$j++] = Infinity; //#10623
    $k[$j++] = Infinity; //#10625
    $forall($_.sbs, function() { //#10625
        var _2U = $k[--$j]; //#10625
        $k[$j++] = $f(_2U - 48); //#10625
    }); //#10625
    var _2V = $a(); //#10625
    $k[$j++] = Infinity; //#10626
    for (var _2X = 0, _2Y = ~~(($_.sbs.length + 1) / 2); _2X < _2Y; _2X++) { //#10626
        $k[$j++] = $_.height; //#10626
    } //#10626
    var _2a = $a(); //#10626
    $k[$j++] = Infinity; //#10627
    for (var _2c = 0, _2d = ~~(($_.sbs.length + 1) / 2); _2c < _2d; _2c++) { //#10627
        $k[$j++] = 0; //#10627
    } //#10627
    var _2e = $a(); //#10627
    $k[$j++] = 'ren'; //#10630
    $k[$j++] = 'renlinear'; //#10630
    $k[$j++] = 'sbs'; //#10630
    $k[$j++] = _2V; //#10630
    $k[$j++] = 'bhs'; //#10630
    $k[$j++] = _2a; //#10630
    $k[$j++] = 'bbs'; //#10630
    $k[$j++] = _2e; //#10630
    if ($_.includetext) { //#10630
        $k[$j++] = 'txt'; //#10629
        $k[$j++] = $_.txt; //#10629
    } //#10629
    $k[$j++] = 'opt'; //#10631
    $k[$j++] = $_.options; //#10631
    var _2i = $d(); //#10631
    $k[$j++] = _2i; //#10634
    if (!$_.dontdraw) { //#10634
        bwipp_renlinear(); //#10634
    } //#10634
    $_ = Object.getPrototypeOf($_); //#10636
    $_ = Object.getPrototypeOf($_); //#10638
} //bwipp_code2of5
function bwipp_industrial2of5() {
    $_ = Object.create($_); //#10667
    $_.dontdraw = false; //#10670
    $k[$j++] = $_; //#10672
    bwipp_processoptions(); //#10672
    $_.options = $k[--$j]; //#10672
    $_.barcode = $k[--$j]; //#10673
    $put($_.options, "dontdraw", true); //#10676
    $put($_.options, "version", "industrial"); //#10677
    $k[$j++] = 'args'; //#10679
    $k[$j++] = $_.barcode; //#10679
    $k[$j++] = $_.options; //#10679
    bwipp_code2of5(); //#10679
    var _6 = $k[--$j]; //#10679
    $_[$k[--$j]] = _6; //#10679
    $put($_.args, "opt", $_.options); //#10681
    $k[$j++] = $_.args; //#10684
    if (!$_.dontdraw) { //#10684
        bwipp_renlinear(); //#10684
    } //#10684
    $_ = Object.getPrototypeOf($_); //#10686
} //bwipp_industrial2of5
function bwipp_iata2of5() {
    $_ = Object.create($_); //#10715
    $_.dontdraw = false; //#10718
    $k[$j++] = $_; //#10720
    bwipp_processoptions(); //#10720
    $_.options = $k[--$j]; //#10720
    $_.barcode = $k[--$j]; //#10721
    $put($_.options, "dontdraw", true); //#10724
    $put($_.options, "version", "iata"); //#10725
    $k[$j++] = 'args'; //#10727
    $k[$j++] = $_.barcode; //#10727
    $k[$j++] = $_.options; //#10727
    bwipp_code2of5(); //#10727
    var _6 = $k[--$j]; //#10727
    $_[$k[--$j]] = _6; //#10727
    $put($_.args, "opt", $_.options); //#10729
    $k[$j++] = $_.args; //#10732
    if (!$_.dontdraw) { //#10732
        bwipp_renlinear(); //#10732
    } //#10732
    $_ = Object.getPrototypeOf($_); //#10734
} //bwipp_iata2of5
function bwipp_matrix2of5() {
    $_ = Object.create($_); //#10763
    $_.dontdraw = false; //#10766
    $k[$j++] = $_; //#10768
    bwipp_processoptions(); //#10768
    $_.options = $k[--$j]; //#10768
    $_.barcode = $k[--$j]; //#10769
    $put($_.options, "dontdraw", true); //#10772
    $put($_.options, "version", "matrix"); //#10773
    $k[$j++] = 'args'; //#10775
    $k[$j++] = $_.barcode; //#10775
    $k[$j++] = $_.options; //#10775
    bwipp_code2of5(); //#10775
    var _6 = $k[--$j]; //#10775
    $_[$k[--$j]] = _6; //#10775
    $put($_.args, "opt", $_.options); //#10777
    $k[$j++] = $_.args; //#10780
    if (!$_.dontdraw) { //#10780
        bwipp_renlinear(); //#10780
    } //#10780
    $_ = Object.getPrototypeOf($_); //#10782
} //bwipp_matrix2of5
function bwipp_coop2of5() {
    $_ = Object.create($_); //#10811
    $_.dontdraw = false; //#10814
    $k[$j++] = $_; //#10816
    bwipp_processoptions(); //#10816
    $_.options = $k[--$j]; //#10816
    $_.barcode = $k[--$j]; //#10817
    $put($_.options, "dontdraw", true); //#10820
    $put($_.options, "version", "coop"); //#10821
    $k[$j++] = 'args'; //#10823
    $k[$j++] = $_.barcode; //#10823
    $k[$j++] = $_.options; //#10823
    bwipp_code2of5(); //#10823
    var _6 = $k[--$j]; //#10823
    $_[$k[--$j]] = _6; //#10823
    $put($_.args, "opt", $_.options); //#10825
    $k[$j++] = $_.args; //#10828
    if (!$_.dontdraw) { //#10828
        bwipp_renlinear(); //#10828
    } //#10828
    $_ = Object.getPrototypeOf($_); //#10830
} //bwipp_coop2of5
function bwipp_datalogic2of5() {
    $_ = Object.create($_); //#10859
    $_.dontdraw = false; //#10862
    $k[$j++] = $_; //#10864
    bwipp_processoptions(); //#10864
    $_.options = $k[--$j]; //#10864
    $_.barcode = $k[--$j]; //#10865
    $put($_.options, "dontdraw", true); //#10868
    $put($_.options, "version", "datalogic"); //#10869
    $k[$j++] = 'args'; //#10871
    $k[$j++] = $_.barcode; //#10871
    $k[$j++] = $_.options; //#10871
    bwipp_code2of5(); //#10871
    var _6 = $k[--$j]; //#10871
    $_[$k[--$j]] = _6; //#10871
    $put($_.args, "opt", $_.options); //#10873
    $k[$j++] = $_.args; //#10876
    if (!$_.dontdraw) { //#10876
        bwipp_renlinear(); //#10876
    } //#10876
    $_ = Object.getPrototypeOf($_); //#10878
} //bwipp_datalogic2of5
function bwipp_code11() {
    $_ = Object.create($_); //#10908
    $_.dontdraw = false; //#10911
    $_.includecheck = false; //#10912
    $_.validatecheck = false; //#10913
    $_.includetext = false; //#10914
    $_.includecheckintext = false; //#10915
    $_.textfont = "OCR-B"; //#10916
    $_.textsize = 10; //#10917
    $_.textyoffset = -8; //#10918
    $_.height = 1; //#10919
    $k[$j++] = $_; //#10921
    bwipp_processoptions(); //#10921
    $_.options = $k[--$j]; //#10921
    $_.barcode = $k[--$j]; //#10922
    if ($eq($_.barcode, "")) { //#10926
        $k[$j++] = 'bwipp.code11emptyData#10925'; //#10925
        $k[$j++] = "The data must not be empty"; //#10925
        bwipp_raiseerror(); //#10925
    } //#10925
    bwipp_loadctx(bwipp_code11) //#10928
    if (!bwipp_code11.__10942__) { //#10942
        $_ = Object.create($_); //#10942
        $_.encs = $a(["111131", "311131", "131131", "331111", "113131", "313111", "133111", "111331", "311311", "311111", "113111", "113311"]); //#10936
        $_.barchars = "0123456789-"; //#10939
        $_.charvals = new Map; //#10940
        for (var _4 = 0; _4 <= 10; _4 += 1) { //#10941
            $put($_.charvals, $geti($_.barchars, _4, 1), _4); //#10941
        } //#10941
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_code11.$ctx[id] = $_[id]); //#10941
        bwipp_code11.__10942__ = 1; //#10941
        $_ = Object.getPrototypeOf($_); //#10941
    } //#10941
    for (var _B = 0, _A = $_.barcode.length - 1; _B <= _A; _B += 1) { //#10949
        var _F = $get($_.charvals, $geti($_.barcode, _B, 1)) !== undefined; //#10946
        if (!_F) { //#10948
            $k[$j++] = 'bwipp.code11badCharacter#10947'; //#10947
            $k[$j++] = "Code 11 must contain only digits and dashes"; //#10947
            bwipp_raiseerror(); //#10947
        } //#10947
    } //#10947
    $_.barlen = $_.barcode.length; //#10951
    if ($_.validatecheck) { //#10957
        if ($_.barlen == 11) { //#10955
            $k[$j++] = 'bwipp.code11badLength#10954'; //#10954
            $k[$j++] = "Code 11 cannot be 11 characters using check digits"; //#10954
            bwipp_raiseerror(); //#10954
        } //#10954
        var _L = ($_.barlen <= 10) ? 1 : 2; //#10956
        $_.barlen = $_.barlen - _L; //#10956
    } //#10956
    $k[$j++] = 'numchecks'; //#10959
    if ($_.includecheck || $_.validatecheck) { //#10959
        var _P = ($_.barlen >= 10) ? 2 : 1; //#10959
        $k[$j++] = _P; //#10959
    } else { //#10959
        $k[$j++] = 0; //#10959
    } //#10959
    var _Q = $k[--$j]; //#10959
    $_[$k[--$j]] = _Q; //#10959
    $_.checksum1 = 0; //#10960
    $_.checksum2 = 0; //#10960
    for (var _U = 0, _T = $_.barlen - 1; _U <= _T; _U += 1) { //#10966
        $_.i = _U; //#10962
        $_.indx = $get($_.charvals, $geti($_.barcode, $_.i, 1)); //#10963
        $_.checksum1 = $f($_.checksum1 + ((((($_.barlen - $_.i) - 1) % 10) + 1) * $_.indx)); //#10964
        $_.checksum2 = $f($_.checksum2 + (((($_.barlen - $_.i) % 9) + 1) * $_.indx)); //#10965
    } //#10965
    $_.checksum1 = $_.checksum1 % 11; //#10967
    $_.checksum2 = $f($_.checksum2 + $_.checksum1) % 11; //#10968
    if ($_.validatecheck) { //#10982
        if ($_.numchecks == 1) { //#10977
            var _r = $_.checksum1; //#10971
            if ($get($_.barcode, $_.barlen) != $get($_.barchars, _r)) { //#10973
                $k[$j++] = 'bwipp.code11badCheckDigit#10972'; //#10972
                $k[$j++] = "Incorrect Code 11 check digit provided"; //#10972
                bwipp_raiseerror(); //#10972
            } //#10972
        } else { //#10977
            if (($get($_.barcode, $_.barlen) != $get($_.barchars, $_.checksum1)) || ($get($_.barcode, $_.barlen + 1) != $get($_.barchars, $_.checksum2))) { //#10978
                $k[$j++] = 'bwipp.code11badCheckDigits#10977'; //#10977
                $k[$j++] = "Incorrect Code 11 check digits provided"; //#10977
                bwipp_raiseerror(); //#10977
            } //#10977
        } //#10977
        $_.barcode = $geti($_.barcode, 0, $_.barlen); //#10980
        $_.includecheck = true; //#10981
    } //#10981
    $_.sbs = $s($f(($f($_.barlen + $_.numchecks) * 6) + 12)); //#10984
    $_.txt = $a($f($_.barlen + $_.numchecks)); //#10985
    $puti($_.sbs, 0, $get($_.encs, 11)); //#10988
    $_.xpos = 8; //#10990
    for (var _1J = 0, _1I = $_.barlen - 1; _1J <= _1I; _1J += 1) { //#11000
        $_.i = _1J; //#10992
        $_.indx = $get($_.charvals, $geti($_.barcode, $_.i, 1)); //#10993
        $_.enc = $get($_.encs, $_.indx); //#10994
        $puti($_.sbs, ($_.i * 6) + 6, $_.enc); //#10995
        $put($_.txt, $_.i, $a([$geti($_.barcode, $_.i, 1), $_.xpos, $_.textyoffset, $_.textfont, $_.textsize])); //#10996
        for (var _1f = 0; _1f <= 5; _1f += 1) { //#10999
            $_.xpos = $f($f($get($_.enc, _1f) - 48) + $_.xpos); //#10998
        } //#10998
    } //#10998
    if ($_.includecheck) { //#11029
        if ($_.barlen >= 10) { //#11026
            $puti($_.sbs, ($_.barlen * 6) + 6, $get($_.encs, $_.checksum1)); //#11005
            $puti($_.sbs, ($_.barlen * 6) + 12, $get($_.encs, $_.checksum2)); //#11006
            if ($_.includecheckintext) { //#11016
                $put($_.txt, $_.barlen, $a([$geti($_.barchars, $_.checksum1, 1), $_.xpos, $_.textyoffset, $_.textfont, $_.textsize])); //#11008
                $_.enc = $get($_.encs, $_.checksum1); //#11009
                for (var _29 = 0; _29 <= 5; _29 += 1) { //#11012
                    $_.xpos = $f($f($get($_.enc, _29) - 48) + $_.xpos); //#11011
                } //#11011
                $put($_.txt, $_.barlen + 1, $a([$geti($_.barchars, $_.checksum2, 1), $_.xpos, $_.textyoffset, $_.textfont, $_.textsize])); //#11013
            } else { //#11016
                $put($_.txt, $_.barlen, $a(["", $_.xpos, $_.textyoffset, $_.textfont, $_.textsize])); //#11015
                $put($_.txt, $_.barlen + 1, $a(["", $_.xpos, $_.textyoffset, $_.textfont, $_.textsize])); //#11016
            } //#11016
            $puti($_.sbs, ($_.barlen * 6) + 18, $get($_.encs, 11)); //#11018
        } else { //#11026
            $puti($_.sbs, ($_.barlen * 6) + 6, $get($_.encs, $_.checksum1)); //#11020
            if ($_.includecheckintext) { //#11024
                $put($_.txt, $_.barlen, $a([$geti($_.barchars, $_.checksum1, 1), $_.xpos, $_.textyoffset, $_.textfont, $_.textsize])); //#11022
            } else { //#11024
                $put($_.txt, $_.barlen, $a(["", $_.xpos, $_.textyoffset, $_.textfont, $_.textsize])); //#11024
            } //#11024
            $puti($_.sbs, ($_.barlen * 6) + 12, $get($_.encs, 11)); //#11026
        } //#11026
    } else { //#11029
        $puti($_.sbs, ($_.barlen * 6) + 6, $get($_.encs, 11)); //#11029
    } //#11029
    $k[$j++] = Infinity; //#11033
    $k[$j++] = Infinity; //#11035
    var _3A = $_.sbs; //#11035
    for (var _3B = 0, _3C = _3A.length; _3B < _3C; _3B++) { //#11035
        $k[$j++] = $get(_3A, _3B) - 48; //#11035
    } //#11035
    var _3E = $a(); //#11035
    $k[$j++] = Infinity; //#11036
    for (var _3G = 0, _3H = ~~(($_.sbs.length + 1) / 2); _3G < _3H; _3G++) { //#11036
        $k[$j++] = $_.height; //#11036
    } //#11036
    var _3J = $a(); //#11036
    $k[$j++] = Infinity; //#11037
    for (var _3L = 0, _3M = ~~(($_.sbs.length + 1) / 2); _3L < _3M; _3L++) { //#11037
        $k[$j++] = 0; //#11037
    } //#11037
    var _3N = $a(); //#11037
    $k[$j++] = 'ren'; //#11040
    $k[$j++] = 'renlinear'; //#11040
    $k[$j++] = 'sbs'; //#11040
    $k[$j++] = _3E; //#11040
    $k[$j++] = 'bhs'; //#11040
    $k[$j++] = _3J; //#11040
    $k[$j++] = 'bbs'; //#11040
    $k[$j++] = _3N; //#11040
    if ($_.includetext) { //#11040
        $k[$j++] = 'txt'; //#11039
        $k[$j++] = $_.txt; //#11039
    } //#11039
    $k[$j++] = 'opt'; //#11041
    $k[$j++] = $_.options; //#11041
    var _3R = $d(); //#11041
    $k[$j++] = _3R; //#11044
    if (!$_.dontdraw) { //#11044
        bwipp_renlinear(); //#11044
    } //#11044
    $_ = Object.getPrototypeOf($_); //#11046
    $_ = Object.getPrototypeOf($_); //#11048
} //bwipp_code11
function bwipp_bc412() {
    $_ = Object.create($_); //#11078
    $_.dontdraw = false; //#11081
    $_.includecheck = false; //#11082
    $_.validatecheck = false; //#11083
    $_.includetext = false; //#11084
    $_.includecheckintext = false; //#11085
    $_.includestartstop = false; //#11086
    $_.semi = false; //#11087
    $_.textfont = "OCR-B"; //#11088
    $_.textsize = 10; //#11089
    $_.textyoffset = -8; //#11090
    $_.height = 1; //#11091
    $k[$j++] = $_; //#11093
    bwipp_processoptions(); //#11093
    $_.options = $k[--$j]; //#11093
    $_.barcode = $k[--$j]; //#11094
    if ($eq($_.barcode, "")) { //#11098
        $k[$j++] = 'bwipp.bc412emptyData#11097'; //#11097
        $k[$j++] = "The data must not be empty"; //#11097
        bwipp_raiseerror(); //#11097
    } //#11097
    if ($_.semi) { //#11103
        $_.includestartstop = true; //#11102
    } //#11102
    bwipp_loadctx(bwipp_bc412) //#11105
    if (!bwipp_bc412.__11112__) { //#11112
        $_ = Object.create($_); //#11112
        $_.barchars = "0R9GLVHA8EZ4NTS1J2Q6C7DYKBUIX3FWP5M"; //#11109
        $_.charvals = new Map; //#11110
        for (var _4 = 0; _4 <= 34; _4 += 1) { //#11111
            $put($_.charvals, $geti($_.barchars, _4, 1), _4); //#11111
        } //#11111
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_bc412.$ctx[id] = $_[id]); //#11111
        bwipp_bc412.__11112__ = 1; //#11111
        $_ = Object.getPrototypeOf($_); //#11111
    } //#11111
    for (var _B = 0, _A = $_.barcode.length - 1; _B <= _A; _B += 1) { //#11119
        var _F = $get($_.charvals, $geti($_.barcode, _B, 1)) !== undefined; //#11116
        if (!_F) { //#11118
            $k[$j++] = 'bwipp.bc412badCharacter#11117'; //#11117
            $k[$j++] = "BC412 must contain only digits and capital letters except O"; //#11117
            bwipp_raiseerror(); //#11117
        } //#11117
    } //#11117
    if ($_.semi) { //#11175
        if ($_.validatecheck) { //#11129
            if (($_.barcode.length < 8) || ($_.barcode.length > 19)) { //#11126
                $k[$j++] = 'bwipp.bc412semivalidateBadLength#11125'; //#11125
                $k[$j++] = "BC412 semi with check digit must be 8 to 19 characters long"; //#11125
                bwipp_raiseerror(); //#11125
            } //#11125
        } else { //#11129
            if (($_.barcode.length < 7) || ($_.barcode.length > 18)) { //#11130
                $k[$j++] = 'bwipp.bc412semiBadLength#11129'; //#11129
                $k[$j++] = "BC412 semi must be 7 to 18 characters long"; //#11129
                bwipp_raiseerror(); //#11129
            } //#11129
        } //#11129
        $_.barlen = $_.barcode.length; //#11133
        if (!$_.validatecheck) { //#11141
            $_.barlen = $_.barlen + 1; //#11135
            $_.sbarcode = $s($_.barlen); //#11136
            $put($_.sbarcode, 0, $get($_.barcode, 0)); //#11137
            $put($_.sbarcode, 1, 48); //#11138
            $puti($_.sbarcode, 2, $geti($_.barcode, 1, $_.barlen - 2)); //#11139
            $_.barcode = $_.sbarcode; //#11140
        } //#11140
        $_.sumodd = 0; //#11142
        $_.sumeven = 0; //#11142
        for (var _c = 0, _b = $_.barlen - 1; _c <= _b; _c += 1) { //#11151
            $_.i = _c; //#11144
            $k[$j++] = $get($_.charvals, $geti($_.barcode, $_.i, 1)); //#11150
            if (($_.i % 2) == 0) { //#11149
                $_.sumodd = $f($k[--$j] + $_.sumodd); //#11147
            } else { //#11149
                $_.sumeven = $f($k[--$j] + $_.sumeven); //#11149
            } //#11149
        } //#11149
        $_.checksum = ($f(($_.sumodd % 35) + (($_.sumeven % 35) * 2))) % 35; //#11152
        if ($_.validatecheck) { //#11159
            if ($_.checksum != 0) { //#11156
                $k[$j++] = 'bwipp.bc412semiBadCheckDigit#11155'; //#11155
                $k[$j++] = "Incorrect BC412 semi check digit provided"; //#11155
                bwipp_raiseerror(); //#11155
            } //#11155
        } else { //#11159
            $_.checksum = ($_.checksum * 17) % 35; //#11158
            $put($_.barcode, 1, $get($_.barchars, $_.checksum)); //#11159
        } //#11159
    } else { //#11175
        $k[$j++] = 'barlen'; //#11162
        $k[$j++] = $_.barcode.length; //#11162
        if ($_.validatecheck) { //#11162
            var _y = $k[--$j]; //#11162
            $k[$j++] = $f(_y - 1); //#11162
        } //#11162
        var _z = $k[--$j]; //#11162
        $_[$k[--$j]] = _z; //#11162
        $_.checksum = 0; //#11164
        for (var _13 = 0, _12 = $_.barlen - 1; _13 <= _12; _13 += 1) { //#11168
            $_.checksum = $f($get($_.charvals, $geti($_.barcode, _13, 1)) + $_.checksum); //#11167
        } //#11167
        $_.checksum = $_.checksum % 35; //#11169
        if ($_.validatecheck) { //#11176
            if ($get($_.barcode, $_.barlen) != $get($_.barchars, $_.checksum)) { //#11173
                $k[$j++] = 'bwipp.bc412badCheckDigit#11172'; //#11172
                $k[$j++] = "Incorrect BC412 check digit provided"; //#11172
                bwipp_raiseerror(); //#11172
            } //#11172
            $_.barcode = $geti($_.barcode, 0, $_.barlen); //#11174
            $_.includecheck = true; //#11175
        } //#11175
    } //#11175
    if (!bwipp_bc412.__11191__) { //#11191
        $_ = Object.create($_); //#11191
        $_.encs = $a(["11111115", "13111212", "11131113", "12111213", "12121311", "13131111", "12111312", "11131212", "11121411", "11151111", "15111111", "11111511", "12131211", "13121112", "13111311", "11111214", "12121113", "11111313", "13111113", "11121213", "11141112", "11121312", "11141211", "14121111", "12121212", "11131311", "13121211", "12111411", "14111211", "11111412", "12111114", "14111112", "12141111", "11121114", "12131112", "12", "111"]); //#11190
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_bc412.$ctx[id] = $_[id]); //#11190
        bwipp_bc412.__11191__ = 1; //#11190
        $_ = Object.getPrototypeOf($_); //#11190
    } //#11190
    $_.sbs = $s((($_.barlen + 1) * 8) + 5); //#11193
    if ($_.includecheck) { //#11197
        $_.txt = $a($_.barlen + 1); //#11195
    } else { //#11197
        $_.txt = $a($_.barlen); //#11197
    } //#11197
    if ($_.includestartstop) { //#11207
        $puti($_.sbs, 0, $get($_.encs, 35)); //#11202
        $_.pos = 2; //#11203
        $_.txtpos = 3; //#11204
    } else { //#11207
        $_.pos = 0; //#11206
        $_.txtpos = 0; //#11207
    } //#11207
    for (var _1Z = 0, _1Y = $_.barlen - 1; _1Z <= _1Y; _1Z += 1) { //#11216
        $_.i = _1Z; //#11211
        $_.indx = $get($_.charvals, $geti($_.barcode, $_.i, 1)); //#11212
        $puti($_.sbs, $_.pos, $get($_.encs, $_.indx)); //#11213
        $put($_.txt, $_.i, $a([$geti($_.barcode, $_.i, 1), ($_.i * 12) + $_.txtpos, $_.textyoffset, $_.textfont, $_.textsize])); //#11214
        $_.pos = $_.pos + 8; //#11215
    } //#11215
    if ($_.includecheck) { //#11227
        $puti($_.sbs, $_.pos, $get($_.encs, $_.checksum)); //#11220
        if ($_.includecheckintext) { //#11224
            $put($_.txt, $_.barlen, $a([$geti($_.barchars, $_.checksum, 1), ($_.barlen * 12) + $_.txtpos, $_.textyoffset, $_.textfont, $_.textsize])); //#11222
        } else { //#11224
            $put($_.txt, $_.barlen, $a(["", ($_.barlen * 12) + $_.txtpos, $_.textyoffset, $_.textfont, $_.textsize])); //#11224
        } //#11224
        $_.pos = $_.pos + 8; //#11226
    } //#11226
    if ($_.includestartstop) { //#11233
        $puti($_.sbs, $_.pos, $get($_.encs, 36)); //#11231
        $_.pos = $_.pos + 3; //#11232
    } //#11232
    $_.sbs = $geti($_.sbs, 0, $_.pos); //#11236
    $k[$j++] = Infinity; //#11237
    $k[$j++] = Infinity; //#11239
    var _2W = $_.sbs; //#11239
    for (var _2X = 0, _2Y = _2W.length; _2X < _2Y; _2X++) { //#11239
        $k[$j++] = $f($get(_2W, _2X) - 48); //#11239
    } //#11239
    var _2a = $a(); //#11239
    $k[$j++] = Infinity; //#11240
    for (var _2c = 0, _2d = ~~(($_.sbs.length + 1) / 2); _2c < _2d; _2c++) { //#11240
        $k[$j++] = $_.height; //#11240
    } //#11240
    var _2f = $a(); //#11240
    $k[$j++] = Infinity; //#11241
    for (var _2h = 0, _2i = ~~(($_.sbs.length + 1) / 2); _2h < _2i; _2h++) { //#11241
        $k[$j++] = 0; //#11241
    } //#11241
    var _2j = $a(); //#11241
    $k[$j++] = 'ren'; //#11244
    $k[$j++] = 'renlinear'; //#11244
    $k[$j++] = 'sbs'; //#11244
    $k[$j++] = _2a; //#11244
    $k[$j++] = 'bhs'; //#11244
    $k[$j++] = _2f; //#11244
    $k[$j++] = 'bbs'; //#11244
    $k[$j++] = _2j; //#11244
    if ($_.includetext) { //#11244
        $k[$j++] = 'txt'; //#11243
        $k[$j++] = $_.txt; //#11243
    } //#11243
    $k[$j++] = 'opt'; //#11245
    $k[$j++] = $_.options; //#11245
    var _2n = $d(); //#11245
    $k[$j++] = _2n; //#11248
    if (!$_.dontdraw) { //#11248
        bwipp_renlinear(); //#11248
    } //#11248
    $_ = Object.getPrototypeOf($_); //#11250
    $_ = Object.getPrototypeOf($_); //#11252
} //bwipp_bc412
function bwipp_rationalizedCodabar() {
    $_ = Object.create($_); //#11282
    $_.dontdraw = false; //#11285
    $_.altstartstop = false; //#11286
    $_.includecheck = false; //#11287
    $_.validatecheck = false; //#11288
    $_.includetext = false; //#11289
    $_.includecheckintext = false; //#11290
    $_.textfont = "OCR-B"; //#11291
    $_.textsize = 10; //#11292
    $_.textyoffset = -8; //#11293
    $_.height = 1; //#11294
    $k[$j++] = $_; //#11296
    bwipp_processoptions(); //#11296
    $_.options = $k[--$j]; //#11296
    $_.barcode = $k[--$j]; //#11297
    if (($_.barcode.length < 2) || (($_.barcode.length < 3) && $_.validatecheck)) { //#11301
        $k[$j++] = 'bwipp.rationalizedCodabarBadLength#11300'; //#11300
        $k[$j++] = "Codabar must be at least 2 characters in length excluding any check digit"; //#11300
        bwipp_raiseerror(); //#11300
    } //#11300
    bwipp_loadctx(bwipp_rationalizedCodabar) //#11303
    if (!bwipp_rationalizedCodabar.__11317__) { //#11317
        $_ = Object.create($_); //#11317
        $_.encs = $a(["11111331", "11113311", "11131131", "33111111", "11311311", "31111311", "13111131", "13113111", "13311111", "31131111", "11133111", "11331111", "31113131", "31311131", "31313111", "11313131", "11331311", "13131131", "11131331", "11133311"]); //#11312
        $_.barcharsnormal = "0123456789-$:/.+ABCD"; //#11315
        $_.barcharsalt = "0123456789-$:/.+TN*E"; //#11316
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_rationalizedCodabar.$ctx[id] = $_[id]); //#11316
        bwipp_rationalizedCodabar.__11317__ = 1; //#11316
        $_ = Object.getPrototypeOf($_); //#11316
    } //#11316
    var _8 = $_.altstartstop ? $_.barcharsalt : $_.barcharsnormal; //#11319
    $_.barchars = _8; //#11319
    $_.charvals = new Map; //#11321
    for (var _9 = 0; _9 <= 19; _9 += 1) { //#11322
        $put($_.charvals, $geti($_.barchars, _9, 1), _9); //#11322
    } //#11322
    $_.bodyvals = new Map; //#11323
    for (var _D = 0; _D <= 15; _D += 1) { //#11324
        $put($_.bodyvals, $geti($_.barchars, _D, 1), _D); //#11324
    } //#11324
    $_.ssvals = new Map; //#11325
    for (var _H = 16; _H <= 19; _H += 1) { //#11326
        $put($_.ssvals, $geti($_.barchars, _H, 1), _H); //#11326
    } //#11326
    var _O = $get($_.ssvals, $geti($_.barcode, 0, 1)) !== undefined; //#11329
    var _T = $get($_.ssvals, $geti($_.barcode, $_.barcode.length - 1, 1)) !== undefined; //#11330
    if ((!_O) || (!_T)) { //#11336
        if ($_.altstartstop) { //#11334
            $k[$j++] = 'bwipp.rationalizedCodabarBadAltStartStop#11332'; //#11332
            $k[$j++] = "Codabar start and stop characters must be one of E N T or *"; //#11332
            bwipp_raiseerror(); //#11332
        } else { //#11334
            $k[$j++] = 'bwipp.rationalizedCodabarBadStartStop#11334'; //#11334
            $k[$j++] = "Codabar start and stop characters must be one of A B C or D"; //#11334
            bwipp_raiseerror(); //#11334
        } //#11334
    } //#11334
    for (var _X = 1, _W = $_.barcode.length - 2; _X <= _W; _X += 1) { //#11341
        var _b = $get($_.bodyvals, $geti($_.barcode, _X, 1)) !== undefined; //#11338
        if (!_b) { //#11340
            $k[$j++] = 'bwipp.rationalizedCodabarBadCharacter#11339'; //#11339
            $k[$j++] = "Codabar body must contain only digits and symbols - $ : / . +"; //#11339
            bwipp_raiseerror(); //#11339
        } //#11339
    } //#11339
    $k[$j++] = 'barlen'; //#11343
    $k[$j++] = $_.barcode.length; //#11343
    if ($_.validatecheck) { //#11343
        var _e = $k[--$j]; //#11343
        $k[$j++] = $f(_e - 1); //#11343
    } //#11343
    var _f = $k[--$j]; //#11343
    $_[$k[--$j]] = _f; //#11343
    $_.checksum = 0; //#11345
    for (var _j = 0, _i = $f($_.barlen - 2); _j <= _i; _j += 1) { //#11349
        $_.checksum = $f($get($_.charvals, $geti($_.barcode, _j, 1)) + $_.checksum); //#11348
    } //#11348
    var _r = $geti($_.barcode, $_.barcode.length - 1, 1); //#11350
    $_.checksum = $f($get($_.charvals, _r) + $_.checksum); //#11351
    $_.checksum = ($f(16 - ($_.checksum % 16))) % 16; //#11352
    if ($_.validatecheck) { //#11362
        if ($get($_.barcode, $f($_.barlen - 1)) != $get($_.barchars, $_.checksum)) { //#11356
            $k[$j++] = 'bwipp.rationalizedCodabarBadCheckDigit#11355'; //#11355
            $k[$j++] = "Incorrect Codabar check digit provided"; //#11355
            bwipp_raiseerror(); //#11355
        } //#11355
        var _14 = $s($_.barlen); //#11357
        $puti(_14, 0, $geti($_.barcode, 0, $f($_.barlen - 1))); //#11358
        $puti(_14, $f($_.barlen - 1), $geti($_.barcode, $_.barlen, 1)); //#11359
        $_.barcode = _14; //#11360
        $_.includecheck = true; //#11361
    } //#11361
    $k[$j++] = 'sbs'; //#11364
    $k[$j++] = $_.barlen; //#11364
    if ($_.includecheck) { //#11364
        var _1E = $k[--$j]; //#11364
        $k[$j++] = $f(_1E + 1); //#11364
    } //#11364
    var _1G = $s($k[--$j] * 8); //#11364
    $_[$k[--$j]] = _1G; //#11364
    $k[$j++] = 'txt'; //#11365
    $k[$j++] = $_.barlen; //#11365
    if ($_.includecheck) { //#11365
        var _1K = $k[--$j]; //#11365
        $k[$j++] = $f(_1K + 1); //#11365
    } //#11365
    var _1M = $a($k[--$j]); //#11365
    $_[$k[--$j]] = _1M; //#11365
    $_.xpos = 0; //#11367
    for (var _1Q = 0, _1P = $f($_.barlen - 2); _1Q <= _1P; _1Q += 1) { //#11377
        $_.i = _1Q; //#11369
        $_.indx = $get($_.charvals, $geti($_.barcode, $_.i, 1)); //#11370
        $_.enc = $get($_.encs, $_.indx); //#11371
        $puti($_.sbs, $_.i * 8, $_.enc); //#11372
        $put($_.txt, $_.i, $a([$geti($_.barcode, $_.i, 1), $_.xpos, $_.textyoffset, $_.textfont, $_.textsize])); //#11373
        for (var _1m = 0; _1m <= 7; _1m += 1) { //#11376
            $_.xpos = $f($f($get($_.enc, _1m) - 48) + $_.xpos); //#11375
        } //#11375
    } //#11375
    if ($_.includecheck) { //#11401
        $puti($_.sbs, $f(($_.barlen * 8) - 8), $get($_.encs, $_.checksum)); //#11382
        if ($_.includecheckintext) { //#11386
            $put($_.txt, $f($_.barlen - 1), $a([$geti($_.barchars, $_.checksum, 1), $_.xpos, $_.textyoffset, $_.textfont, $_.textsize])); //#11384
        } else { //#11386
            $put($_.txt, $f($_.barlen - 1), $a([" ", $_.xpos, $_.textyoffset, $_.textfont, $_.textsize])); //#11386
        } //#11386
        for (var _2E = 0; _2E <= 7; _2E += 1) { //#11390
            $_.xpos = $f($f($get($get($_.encs, $_.checksum), _2E) - 48) + $_.xpos); //#11389
        } //#11389
        $_.indx = $get($_.charvals, $geti($_.barcode, $f($_.barlen - 1), 1)); //#11392
        $_.enc = $get($_.encs, $_.indx); //#11393
        $puti($_.sbs, $_.barlen * 8, $_.enc); //#11394
        $put($_.txt, $_.barlen, $a([$geti($_.barcode, $f($_.barlen - 1), 1), $_.xpos, $_.textyoffset, $_.textfont, $_.textsize])); //#11395
    } else { //#11401
        $_.indx = $get($_.charvals, $geti($_.barcode, $f($_.barlen - 1), 1)); //#11398
        $_.enc = $get($_.encs, $_.indx); //#11399
        $puti($_.sbs, $f(($_.barlen * 8) - 8), $_.enc); //#11400
        $put($_.txt, $f($_.barlen - 1), $a([$geti($_.barcode, $f($_.barlen - 1), 1), $_.xpos, $_.textyoffset, $_.textfont, $_.textsize])); //#11401
    } //#11401
    $k[$j++] = Infinity; //#11405
    $k[$j++] = Infinity; //#11407
    $forall($_.sbs, function() { //#11407
        var _31 = $k[--$j]; //#11407
        $k[$j++] = $f(_31 - 48); //#11407
    }); //#11407
    var _32 = $a(); //#11407
    $k[$j++] = Infinity; //#11408
    for (var _34 = 0, _35 = ~~(($_.sbs.length + 1) / 2); _34 < _35; _34++) { //#11408
        $k[$j++] = $_.height; //#11408
    } //#11408
    var _37 = $a(); //#11408
    $k[$j++] = Infinity; //#11409
    for (var _39 = 0, _3A = ~~(($_.sbs.length + 1) / 2); _39 < _3A; _39++) { //#11409
        $k[$j++] = 0; //#11409
    } //#11409
    var _3B = $a(); //#11409
    $k[$j++] = 'ren'; //#11412
    $k[$j++] = 'renlinear'; //#11412
    $k[$j++] = 'sbs'; //#11412
    $k[$j++] = _32; //#11412
    $k[$j++] = 'bhs'; //#11412
    $k[$j++] = _37; //#11412
    $k[$j++] = 'bbs'; //#11412
    $k[$j++] = _3B; //#11412
    if ($_.includetext) { //#11412
        $k[$j++] = 'txt'; //#11411
        $k[$j++] = $_.txt; //#11411
    } //#11411
    $k[$j++] = 'opt'; //#11413
    $k[$j++] = $_.options; //#11413
    var _3F = $d(); //#11413
    $k[$j++] = _3F; //#11416
    if (!$_.dontdraw) { //#11416
        bwipp_renlinear(); //#11416
    } //#11416
    $_ = Object.getPrototypeOf($_); //#11418
    $_ = Object.getPrototypeOf($_); //#11420
} //bwipp_rationalizedCodabar
function bwipp_onecode() {
    $_ = Object.create($_); //#11450
    $_.dontdraw = false; //#11453
    $_.height = 0.15; //#11454
    $k[$j++] = $_; //#11456
    bwipp_processoptions(); //#11456
    $_.options = $k[--$j]; //#11456
    $_.barcode = $k[--$j]; //#11457
    bwipp_loadctx(bwipp_onecode) //#11459
    $_.barlen = $_.barcode.length; //#11461
    $forall($_.barcode, function() { //#11467
        var _4 = $k[--$j]; //#11464
        if ((_4 < 48) || (_4 > 57)) { //#11466
            $k[$j++] = 'bwipp.onecodeBadCharacter#11465'; //#11465
            $k[$j++] = "The data must contain only digits"; //#11465
            bwipp_raiseerror(); //#11465
        } //#11465
    }); //#11465
    if (((($_.barlen != 20) && ($_.barlen != 25)) && ($_.barlen != 29)) && ($_.barlen != 31)) { //#11471
        $k[$j++] = 'bwipp.onecodeInvalidLength#11470'; //#11470
        $k[$j++] = "The data must be 20, 25, 29 or 31 digits"; //#11470
        bwipp_raiseerror(); //#11470
    } //#11470
    $k[$j++] = Infinity; //#11474
    var _B = $eq($geti($_.barcode, 5, 1), "9") ? 14 : 11; //#11477
    $k[$j++] = 2; //#11480
    $k[$j++] = 2; //#11480
    $k[$j++] = 5; //#11480
    $k[$j++] = 5; //#11480
    $k[$j++] = _B; //#11480
    $k[$j++] = _B; //#11480
    $k[$j++] = 20; //#11480
    $k[$j++] = 20; //#11480
    $k[$j++] = 25; //#11480
    $k[$j++] = 25; //#11480
    $k[$j++] = 29; //#11480
    $k[$j++] = 29; //#11480
    $_.txtdict = $d(); //#11481
    $_.txt = $a($_.barlen + 6); //#11482
    $_.spacecnt = 0; //#11483
    for (var _H = 0, _G = $_.barlen - 1; _H <= _G; _H += 1) { //#11491
        $_.i = _H; //#11485
        var _K = $get($_.txtdict, $_.i) !== undefined; //#11486
        if (_K) { //#11489
            $put($_.txt, $_.i + $_.spacecnt, $a([" ", 0, 0, "", 0])); //#11487
            $_.spacecnt = $_.spacecnt + 1; //#11488
        } //#11488
        $put($_.txt, $_.i + $_.spacecnt, $a([$geti($_.barcode, $_.i, 1), 0, 0, "", 0])); //#11490
    } //#11490
    $_.txt = $geti($_.txt, 0, $_.barcode.length + $_.spacecnt); //#11492
    $_.normalize = function() {
        $_.base = $k[--$j]; //#11495
        $_.num = $k[--$j]; //#11496
        for (var _e = $_.num.length - 1; _e >= 1; _e -= 1) { //#11501
            $_.i = _e; //#11498
            var _f = $_.num; //#11499
            var _g = $_.i; //#11499
            $put(_f, _g - 1, $f($get(_f, _g - 1) + (~~($get($_.num, $_.i) / $_.base)))); //#11499
            $put($_.num, $_.i, $get($_.num, $_.i) % $_.base); //#11500
        } //#11500
        for (;;) { //#11507
            if ($lt($get($_.num, 0), $_.base)) { //#11503
                break; //#11503
            } //#11503
            $k[$j++] = Infinity; //#11504
            $k[$j++] = 0; //#11504
            $aload($_.num); //#11504
            $_.num = $a(); //#11504
            $put($_.num, 0, $f($get($_.num, 0) + (~~($get($_.num, 1) / $_.base)))); //#11505
            $put($_.num, 1, $get($_.num, 1) % $_.base); //#11506
        } //#11506
        $k[$j++] = Infinity; //#11509
        $_.i = true; //#11509
        var _17 = $_.num; //#11509
        for (var _18 = 0, _19 = _17.length; _18 < _19; _18++) { //#11509
            var _1A = $get(_17, _18); //#11509
            $k[$j++] = _1A; //#11509
            if ((_1A == 0) && $_.i) { //#11509
                $j--; //#11509
            } else { //#11509
                $_.i = false; //#11509
            } //#11509
        } //#11509
        $_.num = $a(); //#11509
        if ($_.num.length == 0) { //#11510
            $_.num = $a([0]); //#11510
        } //#11510
        $k[$j++] = $_.num; //#11511
    }; //#11511
    $_.bigadd = function() {
        var _1G = $k[--$j]; //#11515
        var _1H = $k[--$j]; //#11515
        $_.offset = Math.abs(_1G.length - _1H.length); //#11516
        if (_1G.length < _1H.length) { //#11517
            var _ = _1G; //#11517
            _1G = _1H; //#11517
            _1H = _; //#11517
        } //#11517
        $_.a = _1G; //#11518
        $_.b = _1H; //#11518
        for (var _1K = 0, _1J = $_.b.length - 1; _1K <= _1J; _1K += 1) { //#11521
            var _1L = $_.a; //#11520
            var _1M = $_.offset; //#11520
            $put(_1L, _1K + _1M, $f($get(_1L, _1K + _1M) + $get($_.b, _1K))); //#11520
        } //#11520
        $k[$j++] = $_.a; //#11522
    }; //#11522
    if (!bwipp_onecode.__11533__) { //#11533
        $_ = Object.create($_); //#11533
        var _1V = new Map([
            [20, $a([0])],
            [25, $a([1])],
            [29, $a([1, 0, 0, 0, 0, 1])],
            [31, $a([1, 0, 0, 0, 1, 0, 0, 0, 0, 1])]
        ]); //#11531
        $_.startvals = _1V; //#11532
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_onecode.$ctx[id] = $_[id]); //#11532
        bwipp_onecode.__11533__ = 1; //#11532
        $_ = Object.getPrototypeOf($_); //#11532
    } //#11532
    $k[$j++] = 'binval'; //#11535
    $k[$j++] = $get($_.startvals, $_.barlen); //#11535
    $k[$j++] = Infinity; //#11535
    var _1c = $geti($_.barcode, 20, $_.barlen - 20); //#11535
    for (var _1d = 0, _1e = _1c.length; _1d < _1e; _1d++) { //#11535
        $k[$j++] = $f($get(_1c, _1d) - 48); //#11535
    } //#11535
    var _1g = $a(); //#11535
    $k[$j++] = _1g; //#11535
    $_.bigadd(); //#11535
    var _1h = $k[--$j]; //#11535
    $_[$k[--$j]] = _1h; //#11535
    $k[$j++] = Infinity; //#11536
    $aload($_.binval); //#11536
    $k[$j++] = $f($get($_.barcode, 0) - 48); //#11536
    $_.binval = $a(); //#11536
    $k[$j++] = Infinity; //#11537
    var _1n = $_.binval; //#11537
    for (var _1o = 0, _1p = _1n.length; _1o < _1p; _1o++) { //#11537
        $k[$j++] = $get(_1n, _1o) * 5; //#11537
    } //#11537
    var _1r = $a(); //#11537
    $k[$j++] = 'binval'; //#11537
    $k[$j++] = _1r; //#11537
    $k[$j++] = $a([$f($get($_.barcode, 1) - 48)]); //#11537
    $_.bigadd(); //#11537
    $k[$j++] = 10; //#11537
    $_.normalize(); //#11537
    var _1v = $k[--$j]; //#11537
    $_[$k[--$j]] = _1v; //#11537
    $k[$j++] = Infinity; //#11538
    $aload($_.binval); //#11538
    var _1z = $geti($_.barcode, 2, 18); //#11538
    for (var _20 = 0, _21 = _1z.length; _20 < _21; _20++) { //#11538
        $k[$j++] = $f($get(_1z, _20) - 48); //#11538
    } //#11538
    $_.binval = $a(); //#11538
    $_.bytes = $a(13); //#11541
    var _25 = $_.binval; //#11542
    $_.bintmp = $arrcpy($a(_25.length), _25); //#11542
    for (var _28 = 12; _28 >= 0; _28 -= 1) { //#11552
        $_.i = _28; //#11544
        for (var _2B = 0, _2A = $_.bintmp.length - 2; _2B <= _2A; _2B += 1) { //#11549
            $_.j = _2B; //#11546
            var _2C = $_.bintmp; //#11547
            var _2D = $_.j; //#11547
            $put(_2C, _2D + 1, $f($get(_2C, _2D + 1) + (($get($_.bintmp, $_.j) % 256) * 10))); //#11547
            $put($_.bintmp, $_.j, ~~($get($_.bintmp, $_.j) / 256)); //#11548
        } //#11548
        $put($_.bytes, $_.i, $get($_.bintmp, $_.bintmp.length - 1) % 256); //#11550
        var _2S = $_.bintmp; //#11551
        var _2T = $_.bintmp; //#11551
        $put(_2S, _2T.length - 1, ~~($get(_2S, _2T.length - 1) / 256)); //#11551
    } //#11551
    $_.fcs = 2047; //#11555
    $_.dat = $get($_.bytes, 0) << 5; //#11556
    for (var _2X = 0, _2Y = 6; _2X < _2Y; _2X++) { //#11565
        if ((($_.fcs ^ $_.dat) & 1024) != 0) { //#11561
            $_.fcs = ($_.fcs << 1) ^ 3893; //#11559
        } else { //#11561
            $_.fcs = $_.fcs << 1; //#11561
        } //#11561
        $_.fcs = $_.fcs & 2047; //#11563
        $_.dat = $_.dat << 1; //#11564
    } //#11564
    for (var _2f = 1; _2f <= 12; _2f += 1) { //#11577
        $_.dat = $get($_.bytes, _2f) << 3; //#11567
        for (var _2i = 0, _2j = 8; _2i < _2j; _2i++) { //#11576
            if ((($_.fcs ^ $_.dat) & 1024) != 0) { //#11572
                $_.fcs = ($_.fcs << 1) ^ 3893; //#11570
            } else { //#11572
                $_.fcs = $_.fcs << 1; //#11572
            } //#11572
            $_.fcs = $_.fcs & 2047; //#11574
            $_.dat = $_.dat << 1; //#11575
        } //#11575
    } //#11575
    $_.codewords = $a(10); //#11580
    for (var _2r = 9; _2r >= 0; _2r -= 1) { //#11591
        $_.i = _2r; //#11582
        var _2t = ($_.i == 9) ? 636 : 1365; //#11583
        $_.b = _2t; //#11583
        for (var _2w = 0, _2v = $_.binval.length - 2; _2w <= _2v; _2w += 1) { //#11588
            $_.j = _2w; //#11585
            var _2x = $_.binval; //#11586
            var _2y = $_.j; //#11586
            $put(_2x, _2y + 1, $f($get(_2x, _2y + 1) + (($get($_.binval, $_.j) % $_.b) * 10))); //#11586
            $put($_.binval, $_.j, ~~($get($_.binval, $_.j) / $_.b)); //#11587
        } //#11587
        $put($_.codewords, $_.i, $get($_.binval, $_.binval.length - 1) % $_.b); //#11589
        var _3G = $_.binval; //#11590
        var _3H = $_.binval; //#11590
        $put(_3G, _3H.length - 1, ~~($get(_3G, _3H.length - 1) / $_.b)); //#11590
    } //#11590
    $put($_.codewords, 9, $get($_.codewords, 9) * 2); //#11594
    if (($_.fcs & 1024) != 0) { //#11597
        $put($_.codewords, 0, $f($get($_.codewords, 0) + 659)); //#11596
    } //#11596
    if (!bwipp_onecode.__11698__) { //#11698
        $_ = Object.create($_); //#11698
        $_.tab513 = $a([31, 7936, 47, 7808, 55, 7552, 59, 7040, 61, 6016, 62, 3968, 79, 7744, 87, 7488, 91, 6976, 93, 5952, 94, 3904, 103, 7360, 107, 6848, 109, 5824, 110, 3776, 115, 6592, 117, 5568, 118, 3520, 121, 5056, 122, 3008, 124, 1984, 143, 7712, 151, 7456, 155, 6944, 157, 5920, 158, 3872, 167, 7328, 171, 6816, 173, 5792, 174, 3744, 179, 6560, 181, 5536, 182, 3488, 185, 5024, 186, 2976, 188, 1952, 199, 7264, 203, 6752, 205, 5728, 206, 3680, 211, 6496, 213, 5472, 214, 3424, 217, 4960, 218, 2912, 220, 1888, 227, 6368, 229, 5344, 230, 3296, 233, 4832, 234, 2784, 236, 1760, 241, 4576, 242, 2528, 244, 1504, 248, 992, 271, 7696, 279, 7440, 283, 6928, 285, 5904, 286, 3856, 295, 7312, 299, 6800, 301, 5776, 302, 3728, 307, 6544, 309, 5520, 310, 3472, 313, 5008, 314, 2960, 316, 1936, 327, 7248, 331, 6736, 333, 5712, 334, 3664, 339, 6480, 341, 5456, 342, 3408, 345, 4944, 346, 2896, 348, 1872, 355, 6352, 357, 5328, 358, 3280, 361, 4816, 362, 2768, 364, 1744, 369, 4560, 370, 2512, 372, 1488, 376, 976, 391, 7216, 395, 6704, 397, 5680, 398, 3632, 403, 6448, 405, 5424, 406, 3376, 409, 4912, 410, 2864, 412, 1840, 419, 6320, 421, 5296, 422, 3248, 425, 4784, 426, 2736, 428, 1712, 433, 4528, 434, 2480, 436, 1456, 440, 944, 451, 6256, 453, 5232, 454, 3184, 457, 4720, 458, 2672, 460, 1648, 465, 4464, 466, 2416, 468, 1392, 472, 880, 481, 4336, 482, 2288, 484, 1264, 488, 752, 527, 7688, 535, 7432, 539, 6920, 541, 5896, 542, 3848, 551, 7304, 555, 6792, 557, 5768, 558, 3720, 563, 6536, 565, 5512, 566, 3464, 569, 5000, 570, 2952, 572, 1928, 583, 7240, 587, 6728, 589, 5704, 590, 3656, 595, 6472, 597, 5448, 598, 3400, 601, 4936, 602, 2888, 604, 1864, 611, 6344, 613, 5320, 614, 3272, 617, 4808, 618, 2760, 620, 1736, 625, 4552, 626, 2504, 628, 1480, 632, 968, 647, 7208, 651, 6696, 653, 5672, 654, 3624, 659, 6440, 661, 5416, 662, 3368, 665, 4904, 666, 2856, 668, 1832, 675, 6312, 677, 5288, 678, 3240, 681, 4776, 682, 2728, 684, 1704, 689, 4520, 690, 2472, 692, 1448, 696, 936, 707, 6248, 709, 5224, 710, 3176, 713, 4712, 714, 2664, 716, 1640, 721, 4456, 722, 2408, 724, 1384, 728, 872, 737, 4328, 738, 2280, 740, 1256, 775, 7192, 779, 6680, 781, 5656, 782, 3608, 787, 6424, 789, 5400, 790, 3352, 793, 4888, 794, 2840, 796, 1816, 803, 6296, 805, 5272, 806, 3224, 809, 4760, 810, 2712, 812, 1688, 817, 4504, 818, 2456, 820, 1432, 824, 920, 835, 6232, 837, 5208, 838, 3160, 841, 4696, 842, 2648, 844, 1624, 849, 4440, 850, 2392, 852, 1368, 865, 4312, 866, 2264, 868, 1240, 899, 6200, 901, 5176, 902, 3128, 905, 4664, 906, 2616, 908, 1592, 913, 4408, 914, 2360, 916, 1336, 929, 4280, 930, 2232, 932, 1208, 961, 4216, 962, 2168, 964, 1144, 1039, 7684, 1047, 7428, 1051, 6916, 1053, 5892, 1054, 3844, 1063, 7300, 1067, 6788, 1069, 5764, 1070, 3716, 1075, 6532, 1077, 5508, 1078, 3460, 1081, 4996, 1082, 2948, 1084, 1924, 1095, 7236, 1099, 6724, 1101, 5700, 1102, 3652, 1107, 6468, 1109, 5444, 1110, 3396, 1113, 4932, 1114, 2884, 1116, 1860, 1123, 6340, 1125, 5316, 1126, 3268, 1129, 4804, 1130, 2756, 1132, 1732, 1137, 4548, 1138, 2500, 1140, 1476, 1159, 7204, 1163, 6692, 1165, 5668, 1166, 3620, 1171, 6436, 1173, 5412, 1174, 3364, 1177, 4900, 1178, 2852, 1180, 1828, 1187, 6308, 1189, 5284, 1190, 3236, 1193, 4772, 1194, 2724, 1196, 1700, 1201, 4516, 1202, 2468, 1204, 1444, 1219, 6244, 1221, 5220, 1222, 3172, 1225, 4708, 1226, 2660, 1228, 1636, 1233, 4452, 1234, 2404, 1236, 1380, 1249, 4324, 1250, 2276, 1287, 7188, 1291, 6676, 1293, 5652, 1294, 3604, 1299, 6420, 1301, 5396, 1302, 3348, 1305, 4884, 1306, 2836, 1308, 1812, 1315, 6292, 1317, 5268, 1318, 3220, 1321, 4756, 1322, 2708, 1324, 1684, 1329, 4500, 1330, 2452, 1332, 1428, 1347, 6228, 1349, 5204, 1350, 3156, 1353, 4692, 1354, 2644, 1356, 1620, 1361, 4436, 1362, 2388, 1377, 4308, 1378, 2260, 1411, 6196, 1413, 5172, 1414, 3124, 1417, 4660, 1418, 2612, 1420, 1588, 1425, 4404, 1426, 2356, 1441, 4276, 1442, 2228, 1473, 4212, 1474, 2164, 1543, 7180, 1547, 6668, 1549, 5644, 1550, 3596, 1555, 6412, 1557, 5388, 1558, 3340, 1561, 4876, 1562, 2828, 1564, 1804, 1571, 6284, 1573, 5260, 1574, 3212, 1577, 4748, 1578, 2700, 1580, 1676, 1585, 4492, 1586, 2444, 1603, 6220, 1605, 5196, 1606, 3148, 1609, 4684, 1610, 2636, 1617, 4428, 1618, 2380, 1633, 4300, 1634, 2252, 1667, 6188, 1669, 5164, 1670, 3116, 1673, 4652, 1674, 2604, 1681, 4396, 1682, 2348, 1697, 4268, 1698, 2220, 1729, 4204, 1730, 2156, 1795, 6172, 1797, 5148, 1798, 3100, 1801, 4636, 1802, 2588, 1809, 4380, 1810, 2332, 1825, 4252, 1826, 2204, 1857, 4188, 1858, 2140, 1921, 4156, 1922, 2108, 2063, 7682, 2071, 7426, 2075, 6914, 2077, 5890, 2078, 3842, 2087, 7298, 2091, 6786, 2093, 5762, 2094, 3714, 2099, 6530, 2101, 5506, 2102, 3458, 2105, 4994, 2106, 2946, 2119, 7234, 2123, 6722, 2125, 5698, 2126, 3650, 2131, 6466, 2133, 5442, 2134, 3394, 2137, 4930, 2138, 2882, 2147, 6338, 2149, 5314, 2150, 3266, 2153, 4802, 2154, 2754, 2161, 4546, 2162, 2498, 2183, 7202, 2187, 6690, 2189, 5666, 2190, 3618, 2195, 6434, 2197, 5410, 2198, 3362, 2201, 4898, 2202, 2850, 2211, 6306, 2213, 5282, 2214, 3234, 2217, 4770, 2218, 2722, 2225, 4514, 2226, 2466, 2243, 6242, 2245, 5218, 2246, 3170, 2249, 4706, 2250, 2658, 2257, 4450, 2258, 2402, 2273, 4322, 2311, 7186, 2315, 6674, 2317, 5650, 2318, 3602, 2323, 6418, 2325, 5394, 2326, 3346, 2329, 4882, 2330, 2834, 2339, 6290, 2341, 5266, 2342, 3218, 2345, 4754, 2346, 2706, 2353, 4498, 2354, 2450, 2371, 6226, 2373, 5202, 2374, 3154, 2377, 4690, 2378, 2642, 2385, 4434, 2401, 4306, 2435, 6194, 2437, 5170, 2438, 3122, 2441, 4658, 2442, 2610, 2449, 4402, 2465, 4274, 2497, 4210, 2567, 7178, 2571, 6666, 2573, 5642, 2574, 3594, 2579, 6410, 2581, 5386, 2582, 3338, 2585, 4874, 2586, 2826, 2595, 6282, 2597, 5258, 2598, 3210, 2601, 4746, 2602, 2698, 2609, 4490, 2627, 6218, 2629, 5194, 2630, 3146, 2633, 4682, 2641, 4426, 2657, 4298, 2691, 6186, 2693, 5162, 2694, 3114, 2697, 4650, 2705, 4394, 2721, 4266, 2753, 4202, 2819, 6170, 2821, 5146, 2822, 3098, 2825, 4634, 2833, 4378, 2849, 4250, 2881, 4186, 2945, 4154, 3079, 7174, 3083, 6662, 3085, 5638, 3086, 3590, 3091, 6406, 3093, 5382, 3094, 3334, 3097, 4870, 3107, 6278, 3109, 5254, 3110, 3206, 3113, 4742, 3121, 4486, 3139, 6214, 3141, 5190, 3145, 4678, 3153, 4422, 3169, 4294, 3203, 6182, 3205, 5158, 3209, 4646, 3217, 4390, 3233, 4262, 3265, 4198, 3331, 6166, 3333, 5142, 3337, 4630, 3345, 4374, 3361, 4246, 3393, 4182, 3457, 4150, 3587, 6158, 3589, 5134, 3593, 4622, 3601, 4366, 3617, 4238, 3649, 4174, 3713, 4142, 3841, 4126, 4111, 7681, 4119, 7425, 4123, 6913, 4125, 5889, 4135, 7297, 4139, 6785, 4141, 5761, 4147, 6529, 4149, 5505, 4153, 4993, 4167, 7233, 4171, 6721, 4173, 5697, 4179, 6465, 4181, 5441, 4185, 4929, 4195, 6337, 4197, 5313, 4201, 4801, 4209, 4545, 4231, 7201, 4235, 6689, 4237, 5665, 4243, 6433, 4245, 5409, 4249, 4897, 4259, 6305, 4261, 5281, 4265, 4769, 4273, 4513, 4291, 6241, 4293, 5217, 4297, 4705, 4305, 4449, 4359, 7185, 4363, 6673, 4365, 5649, 4371, 6417, 4373, 5393, 4377, 4881, 4387, 6289, 4389, 5265, 4393, 4753, 4401, 4497, 4419, 6225, 4421, 5201, 4425, 4689, 4483, 6193, 4485, 5169, 4489, 4657, 4615, 7177, 4619, 6665, 4621, 5641, 4627, 6409, 4629, 5385, 4633, 4873, 4643, 6281, 4645, 5257, 4649, 4745, 4675, 6217, 4677, 5193, 4739, 6185, 4741, 5161, 4867, 6169, 4869, 5145, 5127, 7173, 5131, 6661, 5133, 5637, 5139, 6405, 5141, 5381, 5155, 6277, 5157, 5253, 5187, 6213, 5251, 6181, 5379, 6165, 5635, 6157, 6151, 7171, 6155, 6659, 6163, 6403, 6179, 6275, 6211, 5189, 4681, 4433, 4321, 3142, 2634, 2386, 2274, 1612, 1364, 1252, 856, 744, 496]); //#11688
        $_.tab213 = $a([3, 6144, 5, 5120, 6, 3072, 9, 4608, 10, 2560, 12, 1536, 17, 4352, 18, 2304, 20, 1280, 24, 768, 33, 4224, 34, 2176, 36, 1152, 40, 640, 48, 384, 65, 4160, 66, 2112, 68, 1088, 72, 576, 80, 320, 96, 192, 129, 4128, 130, 2080, 132, 1056, 136, 544, 144, 288, 257, 4112, 258, 2064, 260, 1040, 264, 528, 513, 4104, 514, 2056, 516, 1032, 1025, 4100, 1026, 2052, 2049, 4098, 4097, 2050, 1028, 520, 272, 160]); //#11697
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_onecode.$ctx[id] = $_[id]); //#11697
        bwipp_onecode.__11698__ = 1; //#11697
        $_ = Object.getPrototypeOf($_); //#11697
    } //#11697
    $_.chars = $a(10); //#11700
    for (var _3V = 0; _3V <= 9; _3V += 1) { //#11709
        $_.i = _3V; //#11702
        var _3Y = $get($_.codewords, $_.i); //#11703
        $k[$j++] = _3Y; //#11707
        if (_3Y <= 1286) { //#11706
            var _3b = $get($_.tab513, $k[--$j]); //#11704
            $k[$j++] = _3b; //#11704
        } else { //#11706
            var _3e = $get($_.tab213, $f($k[--$j] - 1287)); //#11706
            $k[$j++] = _3e; //#11706
        } //#11706
        $put($_.chars, $_.i, $k[--$j]); //#11708
    } //#11708
    for (var _3i = 9; _3i >= 0; _3i -= 1) { //#11716
        $_.i = _3i; //#11712
        if (((~~Math.pow(2, $_.i)) & $_.fcs) != 0) { //#11715
            $put($_.chars, $_.i, $get($_.chars, $_.i) ^ 8191); //#11714
        } //#11714
    } //#11714
    if (!bwipp_onecode.__11735__) { //#11735
        $_ = Object.create($_); //#11735
        $_.barmap = $a([7, 2, 4, 3, 1, 10, 0, 0, 9, 12, 2, 8, 5, 5, 6, 11, 8, 9, 3, 1, 0, 1, 5, 12, 2, 5, 1, 8, 4, 4, 9, 11, 6, 3, 8, 10, 3, 9, 7, 6, 5, 11, 1, 4, 8, 5, 2, 12, 9, 10, 0, 2, 7, 1, 6, 7, 3, 6, 4, 9, 0, 3, 8, 6, 6, 4, 2, 7, 1, 1, 9, 9, 7, 10, 5, 2, 4, 0, 3, 8, 6, 2, 0, 4, 8, 11, 1, 0, 9, 8, 3, 12, 2, 6, 7, 7, 5, 1, 4, 10, 1, 12, 6, 9, 7, 3, 8, 0, 5, 8, 9, 7, 4, 6, 2, 10, 3, 4, 0, 5, 8, 4, 5, 7, 7, 11, 1, 9, 6, 0, 9, 6, 0, 6, 4, 8, 2, 1, 3, 2, 5, 9, 8, 12, 4, 11, 6, 1, 9, 5, 7, 4, 3, 3, 1, 2, 0, 7, 2, 0, 1, 3, 4, 1, 6, 10, 3, 5, 8, 7, 9, 4, 2, 11, 5, 6, 0, 8, 7, 12, 4, 2, 8, 1, 5, 10, 3, 0, 9, 3, 0, 9, 6, 5, 2, 4, 7, 8, 1, 7, 5, 0, 4, 5, 2, 3, 0, 10, 6, 12, 9, 2, 3, 11, 1, 6, 8, 8, 7, 9, 5, 4, 0, 11, 1, 5, 2, 2, 9, 1, 4, 12, 8, 3, 6, 6, 7, 0, 3, 7, 4, 7, 7, 5, 0, 12, 1, 11, 2, 9, 9, 0, 6, 8, 5, 3, 3, 10, 8, 2]); //#11734
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_onecode.$ctx[id] = $_[id]); //#11734
        bwipp_onecode.__11735__ = 1; //#11734
        $_ = Object.getPrototypeOf($_); //#11734
    } //#11734
    $_.bbs = $a(65); //#11737
    $_.bhs = $a(65); //#11738
    for (var _3u = 0; _3u <= 64; _3u += 1) { //#11759
        $_.i = _3u; //#11740
        $_.dec = ($get($_.chars, $get($_.barmap, $_.i * 4)) & (~~Math.pow(2, $get($_.barmap, ($_.i * 4) + 1)))) != 0; //#11741
        $_.asc = ($get($_.chars, $get($_.barmap, ($_.i * 4) + 2)) & (~~Math.pow(2, $get($_.barmap, ($_.i * 4) + 3)))) != 0; //#11742
        if ((!$_.dec) && (!$_.asc)) { //#11746
            $put($_.bbs, $_.i, (3 * $_.height) / 8); //#11744
            $put($_.bhs, $_.i, (2 * $_.height) / 8); //#11745
        } //#11745
        if ((!$_.dec) && $_.asc) { //#11750
            $put($_.bbs, $_.i, (3 * $_.height) / 8); //#11748
            $put($_.bhs, $_.i, (5 * $_.height) / 8); //#11749
        } //#11749
        if ($_.dec && (!$_.asc)) { //#11754
            $put($_.bbs, $_.i, (0 * $_.height) / 8); //#11752
            $put($_.bhs, $_.i, (5 * $_.height) / 8); //#11753
        } //#11753
        if ($_.dec && $_.asc) { //#11758
            $put($_.bbs, $_.i, (0 * $_.height) / 8); //#11756
            $put($_.bhs, $_.i, (8 * $_.height) / 8); //#11757
        } //#11757
    } //#11757
    $k[$j++] = Infinity; //#11762
    var _4h = $_.bbs; //#11764
    var _4i = $_.bhs; //#11765
    $k[$j++] = Infinity; //#11766
    for (var _4k = 0, _4l = $_.bhs.length - 1; _4k < _4l; _4k++) { //#11766
        $k[$j++] = 1.44; //#11766
        $k[$j++] = 1.872; //#11766
    } //#11766
    $k[$j++] = 1.44; //#11766
    var _4m = $a(); //#11766
    $k[$j++] = 'ren'; //#11772
    $k[$j++] = 'renlinear'; //#11772
    $k[$j++] = 'bbs'; //#11772
    $k[$j++] = _4h; //#11772
    $k[$j++] = 'bhs'; //#11772
    $k[$j++] = _4i; //#11772
    $k[$j++] = 'sbs'; //#11772
    $k[$j++] = _4m; //#11772
    $k[$j++] = 'txt'; //#11772
    $k[$j++] = $_.txt; //#11772
    $k[$j++] = 'textxalign'; //#11772
    $k[$j++] = "left"; //#11772
    $k[$j++] = 'textfont'; //#11772
    $k[$j++] = "OCR-B"; //#11772
    $k[$j++] = 'textyoffset'; //#11772
    $k[$j++] = 1; //#11772
    $k[$j++] = 'textxoffset'; //#11772
    $k[$j++] = -0.3; //#11772
    $k[$j++] = 'opt'; //#11772
    $k[$j++] = $_.options; //#11772
    var _4p = $d(); //#11772
    $k[$j++] = _4p; //#11775
    if (!$_.dontdraw) { //#11775
        bwipp_renlinear(); //#11775
    } //#11775
    $_ = Object.getPrototypeOf($_); //#11777
    $_ = Object.getPrototypeOf($_); //#11779
} //bwipp_onecode
function bwipp_postnet() {
    $_ = Object.create($_); //#11809
    $_.dontdraw = false; //#11812
    $_.includetext = false; //#11813
    $_.validatecheck = false; //#11814
    $_.includecheckintext = false; //#11815
    $_.textfont = "OCR-B"; //#11816
    $_.textsize = 10; //#11817
    $_.textyoffset = -8; //#11818
    $_.height = 0.125; //#11819
    $k[$j++] = $_; //#11821
    bwipp_processoptions(); //#11821
    $_.options = $k[--$j]; //#11821
    $_.barcode = $k[--$j]; //#11822
    bwipp_loadctx(bwipp_postnet) //#11824
    $k[$j++] = 'barlen'; //#11826
    $k[$j++] = $_.barcode.length; //#11826
    if ($_.validatecheck) { //#11826
        var _4 = $k[--$j]; //#11826
        $k[$j++] = $f(_4 - 1); //#11826
    } //#11826
    var _5 = $k[--$j]; //#11826
    $_[$k[--$j]] = _5; //#11826
    if ((($_.barlen != 5) && ($_.barlen != 9)) && ($_.barlen != 11)) { //#11831
        $k[$j++] = 'bwipp.postnetBadLength#11830'; //#11830
        $k[$j++] = "USPS POSTNET must be 5, 9 or 11 digits excluding check digit"; //#11830
        bwipp_raiseerror(); //#11830
    } //#11830
    $forall($_.barcode, function() { //#11836
        var _B = $k[--$j]; //#11833
        if ((_B < 48) || (_B > 57)) { //#11835
            $k[$j++] = 'bwipp.postnetBadCharacter#11834'; //#11834
            $k[$j++] = "USPS POSTNET must contain only digits"; //#11834
            bwipp_raiseerror(); //#11834
        } //#11834
    }); //#11834
    if (!bwipp_postnet.__11848__) { //#11848
        $_ = Object.create($_); //#11848
        $_.barchars = "0123456789"; //#11840
        $_.encs = $a(["55222", "22255", "22525", "22552", "25225", "25252", "25522", "52225", "52252", "52522", "5", "5"]); //#11847
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_postnet.$ctx[id] = $_[id]); //#11847
        bwipp_postnet.__11848__ = 1; //#11847
        $_ = Object.getPrototypeOf($_); //#11847
    } //#11847
    $_.checksum = 0; //#11850
    for (var _G = 0, _F = $f($_.barlen - 1); _G <= _F; _G += 1) { //#11854
        $_.i = _G; //#11852
        $_.checksum = $f($_.checksum + $f($get($_.barcode, $_.i) - 48)); //#11853
    } //#11853
    $_.checksum = ($f(10 - ($_.checksum % 10))) % 10; //#11855
    if ($_.validatecheck) { //#11861
        if ($get($_.barcode, $_.barlen) != $get($_.barchars, $_.checksum)) { //#11859
            $k[$j++] = 'bwipp.postnetBadCheckDigit#11858'; //#11858
            $k[$j++] = "Incorrect USPS POSTNET check digit provided"; //#11858
            bwipp_raiseerror(); //#11858
        } //#11858
        $_.barcode = $geti($_.barcode, 0, $_.barlen); //#11860
    } //#11860
    $_.bhs = $a($f(($_.barlen * 5) + 7)); //#11863
    $_.txt = $a($f($_.barlen + 1)); //#11864
    $_.enc = $get($_.encs, 10); //#11867
    $_.heights = $a($_.enc.length); //#11868
    for (var _g = 0, _f = $_.enc.length - 1; _g <= _f; _g += 1) { //#11872
        $_.j = _g; //#11870
        $put($_.heights, $_.j, ($cvi($geti($_.enc, $_.j, 1)) * $_.height) / 5); //#11871
    } //#11871
    $puti($_.bhs, 0, $_.heights); //#11873
    for (var _r = 0, _q = $f($_.barlen - 1); _r <= _q; _r += 1) { //#11885
        $_.i = _r; //#11876
        $_.enc = $get($_.encs, $f($get($_.barcode, $_.i) - 48)); //#11877
        $_.heights = $a($_.enc.length); //#11878
        for (var _11 = 0, _10 = $_.enc.length - 1; _11 <= _10; _11 += 1) { //#11882
            $_.j = _11; //#11880
            $put($_.heights, $_.j, ($cvi($geti($_.enc, $_.j, 1)) * $_.height) / 5); //#11881
        } //#11881
        $puti($_.bhs, ($_.i * 5) + 1, $_.heights); //#11883
        $put($_.txt, $_.i, $a([$geti($_.barcode, $_.i, 1), (($_.i * 5) + 1) * 3.312, $_.textyoffset, $_.textfont, $_.textsize])); //#11884
    } //#11884
    $_.enc = $get($_.encs, $_.checksum); //#11888
    $_.heights = $a($_.enc.length); //#11889
    for (var _1S = 0, _1R = $_.enc.length - 1; _1S <= _1R; _1S += 1) { //#11893
        $_.j = _1S; //#11891
        $put($_.heights, $_.j, ($cvi($geti($_.enc, $_.j, 1)) * $_.height) / 5); //#11892
    } //#11892
    $puti($_.bhs, $f(($_.barlen * 5) + 1), $_.heights); //#11894
    if ($_.includecheckintext) { //#11899
        $put($_.txt, $_.barlen, $a([$geti($_.barchars, $_.checksum, 1), ($f(($_.barlen * 5) + 1)) * 3.312, $_.textyoffset, $_.textfont, $_.textsize])); //#11897
    } else { //#11899
        $put($_.txt, $_.barlen, $a([" ", (($f(($_.barlen * 5) + 1)) * 72) / 25, $_.textyoffset, $_.textfont, $_.textsize])); //#11899
    } //#11899
    $_.enc = $get($_.encs, 11); //#11903
    $_.heights = $a($_.enc.length); //#11904
    for (var _20 = 0, _1z = $_.enc.length - 1; _20 <= _1z; _20 += 1) { //#11908
        $_.j = _20; //#11906
        $put($_.heights, $_.j, ($cvi($geti($_.enc, $_.j, 1)) * $_.height) / 5); //#11907
    } //#11907
    $puti($_.bhs, $f(($_.barlen * 5) + 6), $_.heights); //#11909
    $k[$j++] = Infinity; //#11912
    var _2A = $_.bhs; //#11914
    $k[$j++] = Infinity; //#11915
    for (var _2C = 0, _2D = $_.bhs.length; _2C < _2D; _2C++) { //#11915
        $k[$j++] = 0; //#11915
    } //#11915
    var _2E = $a(); //#11915
    $k[$j++] = Infinity; //#11916
    for (var _2G = 0, _2H = $_.bhs.length - 1; _2G < _2H; _2G++) { //#11916
        $k[$j++] = 1.44; //#11916
        $k[$j++] = 1.872; //#11916
    } //#11916
    $k[$j++] = 1.44; //#11916
    var _2I = $a(); //#11916
    $k[$j++] = 'ren'; //#11919
    $k[$j++] = 'renlinear'; //#11919
    $k[$j++] = 'bhs'; //#11919
    $k[$j++] = _2A; //#11919
    $k[$j++] = 'bbs'; //#11919
    $k[$j++] = _2E; //#11919
    $k[$j++] = 'sbs'; //#11919
    $k[$j++] = _2I; //#11919
    if ($_.includetext) { //#11919
        $k[$j++] = 'txt'; //#11918
        $k[$j++] = $_.txt; //#11918
    } //#11918
    $k[$j++] = 'opt'; //#11920
    $k[$j++] = $_.options; //#11920
    var _2M = $d(); //#11920
    $k[$j++] = _2M; //#11923
    if (!$_.dontdraw) { //#11923
        bwipp_renlinear(); //#11923
    } //#11923
    $_ = Object.getPrototypeOf($_); //#11925
    $_ = Object.getPrototypeOf($_); //#11927
} //bwipp_postnet
function bwipp_planet() {
    $_ = Object.create($_); //#11957
    $_.dontdraw = false; //#11960
    $_.includetext = false; //#11961
    $_.validatecheck = false; //#11962
    $_.includecheckintext = false; //#11963
    $_.textfont = "OCR-B"; //#11964
    $_.textsize = 10; //#11965
    $_.textyoffset = -8; //#11966
    $_.height = 0.125; //#11967
    $k[$j++] = $_; //#11969
    bwipp_processoptions(); //#11969
    $_.options = $k[--$j]; //#11969
    $_.barcode = $k[--$j]; //#11970
    bwipp_loadctx(bwipp_planet) //#11972
    $k[$j++] = 'barlen'; //#11974
    $k[$j++] = $_.barcode.length; //#11974
    if ($_.validatecheck) { //#11974
        var _4 = $k[--$j]; //#11974
        $k[$j++] = $f(_4 - 1); //#11974
    } //#11974
    var _5 = $k[--$j]; //#11974
    $_[$k[--$j]] = _5; //#11974
    if (($_.barlen != 11) && ($_.barlen != 13)) { //#11979
        $k[$j++] = 'bwipp.planetBadLength#11978'; //#11978
        $k[$j++] = "USPS PLANET must be 11 or 13 digits excluding check digit"; //#11978
        bwipp_raiseerror(); //#11978
    } //#11978
    $forall($_.barcode, function() { //#11984
        var _A = $k[--$j]; //#11981
        if ((_A < 48) || (_A > 57)) { //#11983
            $k[$j++] = 'bwipp.planetBadCharacter#11982'; //#11982
            $k[$j++] = "USPS PLANET must contain only digits"; //#11982
            bwipp_raiseerror(); //#11982
        } //#11982
    }); //#11982
    if (!bwipp_planet.__11996__) { //#11996
        $_ = Object.create($_); //#11996
        $_.barchars = "0123456789"; //#11988
        $_.encs = $a(["22555", "55522", "55252", "55225", "52552", "52525", "52255", "25552", "25525", "25255", "5", "5"]); //#11995
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_planet.$ctx[id] = $_[id]); //#11995
        bwipp_planet.__11996__ = 1; //#11995
        $_ = Object.getPrototypeOf($_); //#11995
    } //#11995
    $_.checksum = 0; //#11999
    for (var _F = 0, _E = $f($_.barlen - 1); _F <= _E; _F += 1) { //#12003
        $_.i = _F; //#12001
        $_.checksum = $f($_.checksum + $f($get($_.barcode, $_.i) - 48)); //#12002
    } //#12002
    $_.checksum = ($f(10 - ($_.checksum % 10))) % 10; //#12004
    if ($_.validatecheck) { //#12010
        if ($get($_.barcode, $_.barlen) != $get($_.barchars, $_.checksum)) { //#12008
            $k[$j++] = 'bwipp.planetBadCheckDigit#12007'; //#12007
            $k[$j++] = "Incorrect USPS PLANET check digit provided"; //#12007
            bwipp_raiseerror(); //#12007
        } //#12007
        $_.barcode = $geti($_.barcode, 0, $_.barlen); //#12009
    } //#12009
    $_.bhs = $a($f(($_.barlen * 5) + 7)); //#12012
    $_.txt = $a($f($_.barlen + 1)); //#12013
    $_.enc = $get($_.encs, 10); //#12016
    $_.heights = $a($_.enc.length); //#12017
    for (var _f = 0, _e = $_.enc.length - 1; _f <= _e; _f += 1) { //#12021
        $_.j = _f; //#12019
        $put($_.heights, $_.j, ($cvi($geti($_.enc, $_.j, 1)) * $_.height) / 5); //#12020
    } //#12020
    $puti($_.bhs, 0, $_.heights); //#12022
    for (var _q = 0, _p = $f($_.barlen - 1); _q <= _p; _q += 1) { //#12034
        $_.i = _q; //#12025
        $_.enc = $get($_.encs, $f($get($_.barcode, $_.i) - 48)); //#12026
        $_.heights = $a($_.enc.length); //#12027
        for (var _10 = 0, _z = $_.enc.length - 1; _10 <= _z; _10 += 1) { //#12031
            $_.j = _10; //#12029
            $put($_.heights, $_.j, ($cvi($geti($_.enc, $_.j, 1)) * $_.height) / 5); //#12030
        } //#12030
        $puti($_.bhs, ($_.i * 5) + 1, $_.heights); //#12032
        $put($_.txt, $_.i, $a([$geti($_.barcode, $_.i, 1), (($_.i * 5) + 1) * 3.312, $_.textyoffset, $_.textfont, $_.textsize])); //#12033
    } //#12033
    $_.enc = $get($_.encs, $_.checksum); //#12037
    $_.heights = $a($_.enc.length); //#12038
    for (var _1R = 0, _1Q = $_.enc.length - 1; _1R <= _1Q; _1R += 1) { //#12042
        $_.j = _1R; //#12040
        $put($_.heights, $_.j, ($cvi($geti($_.enc, $_.j, 1)) * $_.height) / 5); //#12041
    } //#12041
    $puti($_.bhs, $f(($_.barlen * 5) + 1), $_.heights); //#12043
    if ($_.includecheckintext) { //#12048
        $put($_.txt, $_.barlen, $a([$geti($_.barchars, $_.checksum, 1), ($f(($_.barlen * 5) + 1)) * 3.312, $_.textyoffset, $_.textfont, $_.textsize])); //#12046
    } else { //#12048
        $put($_.txt, $_.barlen, $a([" ", (($f(($_.barlen * 5) + 1)) * 72) / 25, $_.textyoffset, $_.textfont, $_.textsize])); //#12048
    } //#12048
    $_.enc = $get($_.encs, 11); //#12052
    $_.heights = $a($_.enc.length); //#12053
    for (var _1z = 0, _1y = $_.enc.length - 1; _1z <= _1y; _1z += 1) { //#12057
        $_.j = _1z; //#12055
        $put($_.heights, $_.j, ($cvi($geti($_.enc, $_.j, 1)) * $_.height) / 5); //#12056
    } //#12056
    $puti($_.bhs, $f(($_.barlen * 5) + 6), $_.heights); //#12058
    $k[$j++] = Infinity; //#12061
    var _29 = $_.bhs; //#12063
    $k[$j++] = Infinity; //#12064
    for (var _2B = 0, _2C = $_.bhs.length; _2B < _2C; _2B++) { //#12064
        $k[$j++] = 0; //#12064
    } //#12064
    var _2D = $a(); //#12064
    $k[$j++] = Infinity; //#12065
    for (var _2F = 0, _2G = $_.bhs.length - 1; _2F < _2G; _2F++) { //#12065
        $k[$j++] = 1.44; //#12065
        $k[$j++] = 1.872; //#12065
    } //#12065
    $k[$j++] = 1.44; //#12065
    var _2H = $a(); //#12065
    $k[$j++] = 'ren'; //#12068
    $k[$j++] = 'renlinear'; //#12068
    $k[$j++] = 'bhs'; //#12068
    $k[$j++] = _29; //#12068
    $k[$j++] = 'bbs'; //#12068
    $k[$j++] = _2D; //#12068
    $k[$j++] = 'sbs'; //#12068
    $k[$j++] = _2H; //#12068
    if ($_.includetext) { //#12068
        $k[$j++] = 'txt'; //#12067
        $k[$j++] = $_.txt; //#12067
    } //#12067
    $k[$j++] = 'opt'; //#12069
    $k[$j++] = $_.options; //#12069
    var _2L = $d(); //#12069
    $k[$j++] = _2L; //#12072
    if (!$_.dontdraw) { //#12072
        bwipp_renlinear(); //#12072
    } //#12072
    $_ = Object.getPrototypeOf($_); //#12074
    $_ = Object.getPrototypeOf($_); //#12076
} //bwipp_planet
function bwipp_royalmail() {
    $_ = Object.create($_); //#12106
    $_.dontdraw = false; //#12109
    $_.includetext = false; //#12110
    $_.validatecheck = false; //#12111
    $_.includecheckintext = false; //#12112
    $_.textfont = "OCR-B"; //#12113
    $_.textsize = 10; //#12114
    $_.textyoffset = -8; //#12115
    $_.height = 0.175; //#12116
    $k[$j++] = $_; //#12118
    bwipp_processoptions(); //#12118
    $_.options = $k[--$j]; //#12118
    $_.barcode = $k[--$j]; //#12119
    if ($eq($_.barcode, "")) { //#12123
        $k[$j++] = 'bwipp.royalmailEmptyData#12122'; //#12122
        $k[$j++] = "The data must not be empty"; //#12122
        bwipp_raiseerror(); //#12122
    } //#12122
    bwipp_loadctx(bwipp_royalmail) //#12125
    if (!bwipp_royalmail.__12143__) { //#12143
        $_ = Object.create($_); //#12143
        $_.barchars = "ZUVWXY501234B6789AHCDEFGNIJKLMTOPQRS"; //#12129
        $_.charvals = new Map; //#12130
        for (var _3 = 0; _3 <= 35; _3 += 1) { //#12131
            $put($_.charvals, $geti($_.barchars, _3, 1), _3); //#12131
        } //#12131
        $_.encs = $a(["3300", "2211", "2301", "2310", "3201", "3210", "1122", "0033", "0123", "0132", "1023", "1032", "1302", "0213", "0303", "0312", "1203", "1212", "1320", "0231", "0321", "0330", "1221", "1230", "3102", "2013", "2103", "2112", "3003", "3012", "3120", "2031", "2121", "2130", "3021", "3030", "2", "3"]); //#12142
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_royalmail.$ctx[id] = $_[id]); //#12142
        bwipp_royalmail.__12143__ = 1; //#12142
        $_ = Object.getPrototypeOf($_); //#12142
    } //#12142
    for (var _B = 0, _A = $_.barcode.length - 1; _B <= _A; _B += 1) { //#12150
        var _F = $get($_.charvals, $geti($_.barcode, _B, 1)) !== undefined; //#12147
        if (!_F) { //#12149
            $k[$j++] = 'bwipp.royalmailBadCharacter#12148'; //#12148
            $k[$j++] = "RM4SCC must contain only capital letters and digits"; //#12148
            bwipp_raiseerror(); //#12148
        } //#12148
    } //#12148
    $k[$j++] = 'barlen'; //#12152
    $k[$j++] = $_.barcode.length; //#12152
    if ($_.validatecheck) { //#12152
        var _I = $k[--$j]; //#12152
        $k[$j++] = $f(_I - 1); //#12152
    } //#12152
    var _J = $k[--$j]; //#12152
    $_[$k[--$j]] = _J; //#12152
    $_.checksumrow = 0; //#12154
    $_.checksumcol = 0; //#12155
    for (var _N = 0, _M = $f($_.barlen - 1); _N <= _M; _N += 1) { //#12161
        $_.i = _N; //#12157
        $_.indx = $get($_.charvals, $geti($_.barcode, $_.i, 1)); //#12158
        $_.checksumrow = $_.checksumrow + (~~($_.indx / 6)); //#12159
        $_.checksumcol = $f($_.checksumcol + ($_.indx % 6)); //#12160
    } //#12160
    $_.checksum = $f((($_.checksumrow % 6) * 6) + ($_.checksumcol % 6)); //#12162
    if ($_.validatecheck) { //#12168
        if ($get($_.barcode, $_.barlen) != $get($_.barchars, $_.checksum)) { //#12166
            $k[$j++] = 'bwipp.royalmailBadCheckDigit#12165'; //#12165
            $k[$j++] = "Incorrect RM4SCC check digit provided"; //#12165
            bwipp_raiseerror(); //#12165
        } //#12165
        $_.barcode = $geti($_.barcode, 0, $_.barlen); //#12167
    } //#12167
    $_.encstr = $s($f(($_.barlen * 4) + 6)); //#12170
    $_.txt = $a($f($_.barlen + 1)); //#12171
    $puti($_.encstr, 0, $get($_.encs, 36)); //#12174
    for (var _s = 0, _r = $f($_.barlen - 1); _s <= _r; _s += 1) { //#12181
        $_.i = _s; //#12177
        $_.indx = $get($_.charvals, $geti($_.barcode, $_.i, 1)); //#12178
        $puti($_.encstr, ($_.i * 4) + 1, $get($_.encs, $_.indx)); //#12179
        $put($_.txt, $_.i, $a([$geti($_.barcode, $_.i, 1), (($_.i * 4) + 1) * 3.312, $_.textyoffset, $_.textfont, $_.textsize])); //#12180
    } //#12180
    $puti($_.encstr, $f(($_.barlen * 4) + 1), $get($_.encs, $_.checksum)); //#12184
    if ($_.includecheckintext) { //#12188
        $put($_.txt, $_.barlen, $a([$geti($_.barchars, $_.checksum, 1), ($f(($_.barlen * 4) + 1)) * 3.312, $_.textyoffset, $_.textfont, $_.textsize])); //#12186
    } else { //#12188
        $put($_.txt, $_.barlen, $a([" ", ($f(($_.barlen * 4) + 1)) * 3.312, $_.textyoffset, $_.textfont, $_.textsize])); //#12188
    } //#12188
    $puti($_.encstr, $f(($_.barlen * 4) + 5), $get($_.encs, 37)); //#12192
    $_.bbs = $a($_.encstr.length); //#12194
    $_.bhs = $a($_.encstr.length); //#12195
    for (var _1k = 0, _1j = $_.encstr.length - 1; _1k <= _1j; _1k += 1) { //#12215
        $_.i = _1k; //#12197
        $_.enc = $geti($_.encstr, $_.i, 1); //#12198
        if ($eq($_.enc, "0")) { //#12202
            $put($_.bbs, $_.i, (3 * $_.height) / 8); //#12200
            $put($_.bhs, $_.i, (2 * $_.height) / 8); //#12201
        } //#12201
        if ($eq($_.enc, "1")) { //#12206
            $put($_.bbs, $_.i, (0 * $_.height) / 8); //#12204
            $put($_.bhs, $_.i, (5 * $_.height) / 8); //#12205
        } //#12205
        if ($eq($_.enc, "2")) { //#12210
            $put($_.bbs, $_.i, (3 * $_.height) / 8); //#12208
            $put($_.bhs, $_.i, (5 * $_.height) / 8); //#12209
        } //#12209
        if ($eq($_.enc, "3")) { //#12214
            $put($_.bbs, $_.i, (0 * $_.height) / 8); //#12212
            $put($_.bhs, $_.i, (8 * $_.height) / 8); //#12213
        } //#12213
    } //#12213
    $k[$j++] = Infinity; //#12218
    var _2G = $_.bbs; //#12220
    var _2H = $_.bhs; //#12221
    $k[$j++] = Infinity; //#12222
    for (var _2J = 0, _2K = $_.bhs.length - 1; _2J < _2K; _2J++) { //#12222
        $k[$j++] = 1.44; //#12222
        $k[$j++] = 1.872; //#12222
    } //#12222
    $k[$j++] = 1.44; //#12222
    var _2L = $a(); //#12222
    $k[$j++] = 'ren'; //#12225
    $k[$j++] = 'renlinear'; //#12225
    $k[$j++] = 'bbs'; //#12225
    $k[$j++] = _2G; //#12225
    $k[$j++] = 'bhs'; //#12225
    $k[$j++] = _2H; //#12225
    $k[$j++] = 'sbs'; //#12225
    $k[$j++] = _2L; //#12225
    if ($_.includetext) { //#12225
        $k[$j++] = 'txt'; //#12224
        $k[$j++] = $_.txt; //#12224
    } //#12224
    $k[$j++] = 'opt'; //#12226
    $k[$j++] = $_.options; //#12226
    var _2P = $d(); //#12226
    $k[$j++] = _2P; //#12229
    if (!$_.dontdraw) { //#12229
        bwipp_renlinear(); //#12229
    } //#12229
    $_ = Object.getPrototypeOf($_); //#12231
    $_ = Object.getPrototypeOf($_); //#12233
} //bwipp_royalmail
function bwipp_auspost() {
    $_ = Object.create($_); //#12263
    $_.dontdraw = false; //#12266
    $_.includetext = false; //#12267
    $_.textfont = "OCR-B"; //#12268
    $_.textsize = 10; //#12269
    $_.textyoffset = -8; //#12270
    $_.height = 0.175; //#12271
    $_.custinfoenc = "character"; //#12272
    $k[$j++] = $_; //#12274
    bwipp_processoptions(); //#12274
    $_.options = $k[--$j]; //#12274
    $_.barcode = $k[--$j]; //#12275
    if ($ne($_.custinfoenc, "character") && $ne($_.custinfoenc, "numeric")) { //#12279
        $k[$j++] = 'bwipp.auspostBadCustinfoEncoding#12278'; //#12278
        $k[$j++] = "Customer information encoding must be either character or numeric"; //#12278
        bwipp_raiseerror(); //#12278
    } //#12278
    bwipp_loadctx(bwipp_auspost) //#12281
    if (!bwipp_auspost.__12304__) { //#12304
        $_ = Object.create($_); //#12304
        $_.encs = $a(["000", "001", "002", "010", "011", "012", "020", "021", "022", "100", "101", "102", "110", "111", "112", "120", "121", "122", "200", "201", "202", "210", "211", "212", "220", "221", "222", "300", "301", "302", "310", "311", "312", "320", "321", "322", "023", "030", "031", "032", "033", "103", "113", "123", "130", "131", "132", "133", "203", "213", "223", "230", "231", "232", "233", "303", "313", "323", "330", "331", "332", "333", "003", "013", "00", "01", "02", "10", "11", "12", "20", "21", "22", "30", "13", "3"]); //#12296
        $_.barchars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789abcdefghijklmnopqrstuvwxyz #"; //#12299
        var _5 = new Map([
            ["11", 37],
            ["45", 37],
            ["59", 52],
            ["62", 67]
        ]); //#12302
        $_.fcclen = _5; //#12302
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_auspost.$ctx[id] = $_[id]); //#12302
        bwipp_auspost.__12304__ = 1; //#12302
        $_ = Object.getPrototypeOf($_); //#12302
    } //#12302
    $_.barlen = $_.barcode.length; //#12306
    if ($_.barlen < 10) { //#12309
        $k[$j++] = 'bwipp.auspostTooShort#12308'; //#12308
        $k[$j++] = "The data length must be at least 10"; //#12308
        bwipp_raiseerror(); //#12308
    } //#12308
    $_.txt = $a($_.barlen - 2); //#12311
    $k[$j++] = $_.fcclen; //#12313
    if ($_.barlen >= 2) { //#12313
        $k[$j++] = $geti($_.barcode, 0, 2); //#12313
    } else { //#12313
        $k[$j++] = ""; //#12313
    } //#12313
    var _F = $k[--$j]; //#12314
    var _G = $k[--$j]; //#12314
    var _H = $get(_G, _F) !== undefined; //#12314
    $k[$j++] = _G; //#12316
    $k[$j++] = _F; //#12316
    if (!_H) { //#12316
        $j -= 2; //#12315
        $k[$j++] = 'bwipp.auspostBadFCC#12315'; //#12315
        $k[$j++] = "Must begin with an FCC, either 11, 45, 59 or 62"; //#12315
        bwipp_raiseerror(); //#12315
    } //#12315
    var _I = $k[--$j]; //#12317
    $_.encstr = $s($get($k[--$j], _I)); //#12317
    $k[$j++] = true; //#12324
    for (var _M = 0, _N = 1; _M < _N; _M++) { //#12324
        if ($_.barlen < 10) { //#12322
            $j--; //#12322
            $k[$j++] = false; //#12322
            break; //#12322
        } //#12322
        var _Q = $geti($_.barcode, 2, 8); //#12323
        for (var _R = 0, _S = _Q.length; _R < _S; _R++) { //#12323
            var _T = $get(_Q, _R); //#12323
            if ((_T < 48) || (_T > 57)) { //#12323
                $j--; //#12323
                $k[$j++] = false; //#12323
                break; //#12323
            } //#12323
        } //#12323
    } //#12323
    if ($nt($k[--$j])) { //#12327
        $k[$j++] = 'bwipp.auspostIncompleteDPID#12326'; //#12326
        $k[$j++] = "The DPID must be 8 digits"; //#12326
        bwipp_raiseerror(); //#12326
    } //#12326
    var _X = $eq($_.custinfoenc, "numeric") ? 2 : 3; //#12330
    if ((($_.barlen - 10) * _X) > (($_.encstr.length - 22) - 14)) { //#12333
        $k[$j++] = 'bwipp.auspostTooLong#12332'; //#12332
        $k[$j++] = "The message is too long"; //#12332
        bwipp_raiseerror(); //#12332
    } //#12332
    $puti($_.encstr, 0, $get($_.encs, 74)); //#12336
    for (var _c = 0; _c <= 1; _c += 1) { //#12343
        $_.i = _c; //#12340
        $puti($_.encstr, ($_.i * 2) + 2, $get($_.encs, $cvi($geti($_.barcode, $_.i, 1)) + 64)); //#12342
    } //#12342
    for (var _k = 2; _k <= 9; _k += 1) { //#12351
        $_.i = _k; //#12347
        $puti($_.encstr, ($_.i * 2) + 2, $get($_.encs, $cvi($geti($_.barcode, $_.i, 1)) + 64)); //#12349
        $put($_.txt, $_.i - 2, $a([$geti($_.barcode, $_.i, 1), ((($_.i - 2) * 2) + 6) * 3.312, $_.textyoffset, $_.textfont, $_.textsize])); //#12350
    } //#12350
    if ($eq($_.custinfoenc, "numeric")) { //#12379
        for (var _15 = 0, _14 = $_.barlen - 11; _15 <= _14; _15 += 1) { //#12364
            $_.i = _15; //#12356
            var _19 = $get($_.barcode, $_.i + 10); //#12357
            $k[$j++] = $_.encs; //#12360
            $k[$j++] = _19; //#12360
            if ((_19 < 48) || (_19 > 57)) { //#12360
                $k[$j++] = 'bwipp.auspostInvalidCustinfoDigit#12359'; //#12359
                $k[$j++] = "The customer information data contains a non-digit character"; //#12359
                bwipp_raiseerror(); //#12359
            } //#12359
            var _1A = $k[--$j]; //#12361
            $puti($_.encstr, ($_.i * 2) + 22, $get($k[--$j], $f($f(_1A - 48) + 64))); //#12362
            $put($_.txt, $_.i + 8, $a([$geti($_.barcode, $_.i + 10, 1), (($_.i * 2) + 22) * 3.312, $_.textyoffset, $_.textfont, $_.textsize])); //#12363
        } //#12363
        $_.ciflen = ($_.barlen - 10) * 2; //#12365
    } else { //#12379
        for (var _1S = 0, _1R = $_.barlen - 11; _1S <= _1R; _1S += 1) { //#12378
            $_.i = _1S; //#12368
            $search($_.barchars, $geti($_.barcode, $_.i + 10, 1)); //#12369
            if ($nt($k[--$j])) { //#12372
                $j--; //#12371
                $k[$j++] = 'bwipp.auspostInvalidCustinfoCharacter#12371'; //#12371
                $k[$j++] = "The customer information contains an invalid character"; //#12371
                bwipp_raiseerror(); //#12371
            } //#12371
            $_.indx = $k[--$j].length; //#12373
            $j -= 2; //#12374
            $_.enc = $get($_.encs, $_.indx); //#12375
            $puti($_.encstr, ($_.i * 3) + 22, $_.enc); //#12376
            $put($_.txt, $_.i + 8, $a([$geti($_.barcode, $_.i + 10, 1), (($_.i * 3) + 22) * 3.312, $_.textyoffset, $_.textfont, $_.textsize])); //#12377
        } //#12377
        $_.ciflen = ($_.barlen - 10) * 3; //#12379
    } //#12379
    for (var _1t = 22 + $_.ciflen, _1s = $_.encstr.length - 14; _1t <= _1s; _1t += 1) { //#12385
        $puti($_.encstr, _1t, $get($_.encs, 75)); //#12384
    } //#12384
    if (!bwipp_auspost.__12408__) { //#12408
        $_ = Object.create($_); //#12408
        $_.rstable = $a(64 * 64); //#12389
        $k[$j++] = $_.rstable; //#12390
        $k[$j++] = 0; //#12390
        $k[$j++] = Infinity; //#12390
        for (var _1z = 0, _20 = 64; _1z < _20; _1z++) { //#12390
            $k[$j++] = 0; //#12390
        } //#12390
        var _21 = $a(); //#12390
        var _22 = $k[--$j]; //#12390
        $puti($k[--$j], _22, _21); //#12390
        $k[$j++] = $_.rstable; //#12391
        $k[$j++] = 64; //#12391
        $k[$j++] = Infinity; //#12391
        for (var _25 = 0; _25 <= 63; _25 += 1) { //#12391
            $k[$j++] = _25; //#12391
        } //#12391
        var _26 = $a(); //#12391
        var _27 = $k[--$j]; //#12391
        $puti($k[--$j], _27, _26); //#12391
        $_.prev = 1; //#12392
        for (var _29 = 0, _2A = 64; _29 < _2A; _29++) { //#12407
            $_.next = $_.prev << 1; //#12394
            if (($_.next & 64) != 0) { //#12397
                $_.next = $_.next ^ 67; //#12396
            } //#12396
            for (var _2E = 0; _2E <= 63; _2E += 1) { //#12405
                $_.j = _2E; //#12399
                $_.nextcell = function() {
                    $k[$j++] = $_.rstable; //#12400
                    $k[$j++] = (64 * $_.next) + $_.j; //#12400
                }; //#12400
                $_.nextcell(); //#12401
                var _2M = $k[--$j]; //#12401
                $put($k[--$j], _2M, $get($_.rstable, (64 * $_.prev) + $_.j) << 1); //#12401
                $_.nextcell(); //#12402
                var _2O = $k[--$j]; //#12402
                if (($get($k[--$j], _2O) & 64) != 0) { //#12404
                    $_.nextcell(); //#12403
                    $_.nextcell(); //#12403
                    var _2R = $k[--$j]; //#12403
                    var _2T = $get($k[--$j], _2R); //#12403
                    var _2U = $k[--$j]; //#12403
                    $put($k[--$j], _2U, _2T ^ 67); //#12403
                } //#12403
            } //#12403
            $_.prev = $_.next; //#12406
        } //#12406
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_auspost.$ctx[id] = $_[id]); //#12406
        bwipp_auspost.__12408__ = 1; //#12406
        $_ = Object.getPrototypeOf($_); //#12406
    } //#12406
    $_.rscodes = $a((~~(($_.encstr.length - 16) / 3)) + 4); //#12411
    $k[$j++] = $_.rscodes; //#12412
    $k[$j++] = 0; //#12412
    $k[$j++] = Infinity; //#12412
    for (var _2b = 0, _2c = 4; _2b < _2c; _2b++) { //#12412
        $k[$j++] = 0; //#12412
    } //#12412
    var _2d = $a(); //#12412
    var _2e = $k[--$j]; //#12412
    $puti($k[--$j], _2e, _2d); //#12412
    for (var _2i = 2, _2h = $_.encstr.length - 16; _2i <= _2h; _2i += 3) { //#12420
        $_.i = _2i; //#12414
        $put($_.rscodes, ($_.rscodes.length - (~~(($_.i - 2) / 3))) - 1, (($cvi($geti($_.encstr, $_.i, 1)) * 16) + ($cvi($geti($_.encstr, $_.i + 1, 1)) * 4)) + $cvi($geti($_.encstr, $_.i + 2, 1))); //#12419
    } //#12419
    for (var _2w = $_.rscodes.length - 5; _2w >= 0; _2w -= 1) { //#12429
        $_.i = _2w; //#12422
        for (var _2x = 0; _2x <= 4; _2x += 1) { //#12428
            $_.j = _2x; //#12424
            $put($_.rscodes, $_.i + $_.j, $xo($get($_.rscodes, $_.i + $_.j), $get($_.rstable, $f((64 * $get($a([48, 17, 29, 30, 1]), $_.j)) + $get($_.rscodes, $_.i + 4))))); //#12427
        } //#12427
    } //#12427
    $_.checkcode = $strcpy($s(12), "000000000000"); //#12430
    for (var _3F = 0; _3F <= 3; _3F += 1) { //#12435
        $_.i = _3F; //#12432
        $_.enc = $cvrs($s(3), $get($_.rscodes, 3 - $_.i), 4); //#12433
        $puti($_.checkcode, ($_.i * 3) + (3 - $_.enc.length), $_.enc); //#12434
    } //#12434
    $puti($_.encstr, $_.encstr.length - 14, $_.checkcode); //#12438
    $puti($_.encstr, $_.encstr.length - 2, $get($_.encs, 74)); //#12439
    $_.bbs = $a($_.encstr.length); //#12441
    $_.bhs = $a($_.encstr.length); //#12442
    for (var _3c = 0, _3b = $_.encstr.length - 1; _3c <= _3b; _3c += 1) { //#12462
        $_.i = _3c; //#12444
        $_.enc = $geti($_.encstr, $_.i, 1); //#12445
        if ($eq($_.enc, "0")) { //#12449
            $put($_.bbs, $_.i, (0 * $_.height) / 8); //#12447
            $put($_.bhs, $_.i, (8 * $_.height) / 8); //#12448
        } //#12448
        if ($eq($_.enc, "1")) { //#12453
            $put($_.bbs, $_.i, (3 * $_.height) / 8); //#12451
            $put($_.bhs, $_.i, (5 * $_.height) / 8); //#12452
        } //#12452
        if ($eq($_.enc, "2")) { //#12457
            $put($_.bbs, $_.i, (0 * $_.height) / 8); //#12455
            $put($_.bhs, $_.i, (5 * $_.height) / 8); //#12456
        } //#12456
        if ($eq($_.enc, "3")) { //#12461
            $put($_.bbs, $_.i, (3 * $_.height) / 8); //#12459
            $put($_.bhs, $_.i, (2 * $_.height) / 8); //#12460
        } //#12460
    } //#12460
    $k[$j++] = Infinity; //#12465
    var _48 = $_.bbs; //#12467
    var _49 = $_.bhs; //#12468
    $k[$j++] = Infinity; //#12469
    for (var _4B = 0, _4C = $_.bhs.length - 1; _4B < _4C; _4B++) { //#12469
        $k[$j++] = 1.44; //#12469
        $k[$j++] = 1.872; //#12469
    } //#12469
    $k[$j++] = 1.44; //#12469
    var _4D = $a(); //#12469
    $k[$j++] = 'ren'; //#12472
    $k[$j++] = 'renlinear'; //#12472
    $k[$j++] = 'bbs'; //#12472
    $k[$j++] = _48; //#12472
    $k[$j++] = 'bhs'; //#12472
    $k[$j++] = _49; //#12472
    $k[$j++] = 'sbs'; //#12472
    $k[$j++] = _4D; //#12472
    if ($_.includetext) { //#12472
        $k[$j++] = 'txt'; //#12471
        $k[$j++] = $_.txt; //#12471
    } //#12471
    $k[$j++] = 'opt'; //#12473
    $k[$j++] = $_.options; //#12473
    var _4H = $d(); //#12473
    $k[$j++] = _4H; //#12476
    if (!$_.dontdraw) { //#12476
        bwipp_renlinear(); //#12476
    } //#12476
    $_ = Object.getPrototypeOf($_); //#12478
    $_ = Object.getPrototypeOf($_); //#12480
} //bwipp_auspost
function bwipp_kix() {
    $_ = Object.create($_); //#12510
    $_.dontdraw = false; //#12513
    $_.includetext = false; //#12514
    $_.textfont = "OCR-B"; //#12515
    $_.textsize = 10; //#12516
    $_.textyoffset = -8; //#12517
    $_.height = 0.175; //#12518
    $k[$j++] = $_; //#12520
    bwipp_processoptions(); //#12520
    $_.options = $k[--$j]; //#12520
    $_.barcode = $k[--$j]; //#12521
    if ($eq($_.barcode, "")) { //#12525
        $k[$j++] = 'bwipp.kixEmptyData#12524'; //#12524
        $k[$j++] = "The data must not be empty"; //#12524
        bwipp_raiseerror(); //#12524
    } //#12524
    bwipp_loadctx(bwipp_kix) //#12527
    if (!bwipp_kix.__12544__) { //#12544
        $_ = Object.create($_); //#12544
        $_.encs = $a(["0033", "0123", "0132", "1023", "1032", "1122", "0213", "0303", "0312", "1203", "1212", "1302", "0231", "0321", "0330", "1221", "1230", "1320", "2013", "2103", "2112", "3003", "3012", "3102", "2031", "2121", "2130", "3021", "3030", "3120", "2211", "2301", "2310", "3201", "3210", "3300"]); //#12538
        $_.barchars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"; //#12541
        $_.charvals = new Map; //#12542
        for (var _4 = 0; _4 <= 35; _4 += 1) { //#12543
            $put($_.charvals, $geti($_.barchars, _4, 1), _4); //#12543
        } //#12543
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_kix.$ctx[id] = $_[id]); //#12543
        bwipp_kix.__12544__ = 1; //#12543
        $_ = Object.getPrototypeOf($_); //#12543
    } //#12543
    for (var _B = 0, _A = $_.barcode.length - 1; _B <= _A; _B += 1) { //#12551
        var _F = $get($_.charvals, $geti($_.barcode, _B, 1)) !== undefined; //#12548
        if (!_F) { //#12550
            $k[$j++] = 'bwipp.kixBadCharacter#12549'; //#12549
            $k[$j++] = "KIX must contain only capital letters and digits"; //#12549
            bwipp_raiseerror(); //#12549
        } //#12549
    } //#12549
    $_.barlen = $_.barcode.length; //#12553
    $_.encstr = $s($_.barlen * 4); //#12554
    $_.txt = $a($_.barlen); //#12555
    for (var _N = 0, _M = $_.barlen - 1; _N <= _M; _N += 1) { //#12562
        $_.i = _N; //#12558
        $_.indx = $get($_.charvals, $geti($_.barcode, $_.i, 1)); //#12559
        $puti($_.encstr, $_.i * 4, $get($_.encs, $_.indx)); //#12560
        $put($_.txt, $_.i, $a([$geti($_.barcode, $_.i, 1), ($_.i * 4) * 3.312, $_.textyoffset, $_.textfont, $_.textsize])); //#12561
    } //#12561
    $_.bbs = $a($_.encstr.length); //#12564
    $_.bhs = $a($_.encstr.length); //#12565
    for (var _o = 0, _n = $_.encstr.length - 1; _o <= _n; _o += 1) { //#12585
        $_.i = _o; //#12567
        $_.enc = $geti($_.encstr, $_.i, 1); //#12568
        if ($eq($_.enc, "0")) { //#12572
            $put($_.bbs, $_.i, (3 * $_.height) / 8); //#12570
            $put($_.bhs, $_.i, (2 * $_.height) / 8); //#12571
        } //#12571
        if ($eq($_.enc, "1")) { //#12576
            $put($_.bbs, $_.i, (0 * $_.height) / 8); //#12574
            $put($_.bhs, $_.i, (5 * $_.height) / 8); //#12575
        } //#12575
        if ($eq($_.enc, "2")) { //#12580
            $put($_.bbs, $_.i, (3 * $_.height) / 8); //#12578
            $put($_.bhs, $_.i, (5 * $_.height) / 8); //#12579
        } //#12579
        if ($eq($_.enc, "3")) { //#12584
            $put($_.bbs, $_.i, (0 * $_.height) / 8); //#12582
            $put($_.bhs, $_.i, (8 * $_.height) / 8); //#12583
        } //#12583
    } //#12583
    $k[$j++] = Infinity; //#12588
    var _1K = $_.bbs; //#12590
    var _1L = $_.bhs; //#12591
    $k[$j++] = Infinity; //#12592
    for (var _1N = 0, _1O = $_.bhs.length - 1; _1N < _1O; _1N++) { //#12592
        $k[$j++] = 1.44; //#12592
        $k[$j++] = 1.872; //#12592
    } //#12592
    $k[$j++] = 1.44; //#12592
    var _1P = $a(); //#12592
    $k[$j++] = 'ren'; //#12595
    $k[$j++] = 'renlinear'; //#12595
    $k[$j++] = 'bbs'; //#12595
    $k[$j++] = _1K; //#12595
    $k[$j++] = 'bhs'; //#12595
    $k[$j++] = _1L; //#12595
    $k[$j++] = 'sbs'; //#12595
    $k[$j++] = _1P; //#12595
    if ($_.includetext) { //#12595
        $k[$j++] = 'txt'; //#12594
        $k[$j++] = $_.txt; //#12594
    } //#12594
    $k[$j++] = 'opt'; //#12596
    $k[$j++] = $_.options; //#12596
    var _1T = $d(); //#12596
    $k[$j++] = _1T; //#12599
    if (!$_.dontdraw) { //#12599
        bwipp_renlinear(); //#12599
    } //#12599
    $_ = Object.getPrototypeOf($_); //#12601
    $_ = Object.getPrototypeOf($_); //#12603
} //bwipp_kix
function bwipp_japanpost() {
    $_ = Object.create($_); //#12633
    $_.dontdraw = false; //#12636
    $_.includetext = false; //#12637
    $_.includecheckintext = false; //#12638
    $_.textfont = "OCR-B"; //#12639
    $_.textsize = 10; //#12640
    $_.textyoffset = -8; //#12641
    $_.height = 0.175; //#12642
    $k[$j++] = $_; //#12644
    bwipp_processoptions(); //#12644
    $_.options = $k[--$j]; //#12644
    $_.barcode = $k[--$j]; //#12645
    if ($eq($_.barcode, "")) { //#12649
        $k[$j++] = 'bwipp.japanpostEmptyData#12648'; //#12648
        $k[$j++] = "The data must not be empty"; //#12648
        bwipp_raiseerror(); //#12648
    } //#12648
    bwipp_loadctx(bwipp_japanpost) //#12651
    $forall($_.barcode, function() { //#12660
        var _4 = $k[--$j]; //#12655
        if (!(((_4 >= 48) && (_4 <= 57)) || (((_4 >= 65) && (_4 <= 90)) || (_4 == 45)))) { //#12659
            $k[$j++] = 'bwipp.japanpostBadCharacter#12658'; //#12658
            $k[$j++] = "Japan Post must contain only digits, capital letters and the dash symbol"; //#12658
            bwipp_raiseerror(); //#12658
        } //#12658
    }); //#12658
    if (!bwipp_japanpost.__12672__) { //#12672
        $_ = Object.create($_); //#12672
        $_.encs = $a(["300", "330", "312", "132", "321", "303", "123", "231", "213", "033", "030", "120", "102", "210", "012", "201", "021", "003", "333", "31", "13"]); //#12668
        $_.barchars = "0123456789-ABCDEFGHIJKLMNOPQRSTUVWXYZ"; //#12671
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_japanpost.$ctx[id] = $_[id]); //#12671
        bwipp_japanpost.__12672__ = 1; //#12671
        $_ = Object.getPrototypeOf($_); //#12671
    } //#12671
    $_.barlen = $_.barcode.length; //#12674
    $_.encstr = $s(((20 + 1) * 3) + 4); //#12676
    $_.digits = $a(20); //#12677
    $_.txt = $a($_.barlen + 1); //#12678
    $puti($_.encstr, 0, $get($_.encs, 19)); //#12681
    $_.checksum = 0; //#12683
    $_.j = 0; //#12684
    $_.i = 0; //#12684
    $k[$j++] = true; //#12719
    for (var _H = 0, _G = $_.barlen - 1; _H <= _G; _H += 1) { //#12719
        $_.i = _H; //#12687
        $search($_.barchars, $geti($_.barcode, $_.i, 1)); //#12688
        $j--; //#12689
        $_.indx = $k[--$j].length; //#12690
        $j -= 2; //#12691
        if (($_.indx >= 11) && ($_.indx < 37)) { //#12702
            if ($_.j > 18) { //#12693
                $j--; //#12693
                $k[$j++] = false; //#12693
                break; //#12693
            } //#12693
            $_.digit = (~~(($_.indx - 1) / 10)) + 10; //#12697
            $puti($_.encstr, ($_.j * 3) + 2, $get($_.encs, $_.digit)); //#12698
            $_.checksum = $_.checksum + $_.digit; //#12699
            $put($_.digits, $_.j, $_.digit); //#12700
            $_.j = $_.j + 1; //#12701
        } //#12701
        if ($_.j > 19) { //#12703
            $j--; //#12703
            $k[$j++] = false; //#12703
            break; //#12703
        } //#12703
        $_.digit = 0; //#12704
        if ($_.indx == 37) { //#12707
            $_.digit = 14; //#12706
        } //#12706
        if (($_.indx >= 11) && ($_.indx < 37)) { //#12710
            $_.digit = ($_.indx - 1) % 10; //#12709
        } //#12709
        if ($_.indx < 11) { //#12713
            $_.digit = $_.indx; //#12712
        } //#12712
        $puti($_.encstr, ($_.j * 3) + 2, $get($_.encs, $_.digit)); //#12714
        $_.checksum = $_.checksum + $_.digit; //#12715
        $put($_.digits, $_.j, $_.digit); //#12716
        $put($_.txt, $_.i, $a([$geti($_.barcode, $_.i, 1), (($_.j * 3) + 2) * 3.312, $_.textyoffset, $_.textfont, $_.textsize])); //#12717
        $_.j = $_.j + 1; //#12718
    } //#12718
    if ($nt($k[--$j])) { //#12723
        $k[$j++] = 'bwipp.japanpostTooLong#12722'; //#12722
        $k[$j++] = "The input is too long"; //#12722
        bwipp_raiseerror(); //#12722
    } //#12722
    for (var _17 = $_.j, _16 = 20 - 1; _17 <= _16; _17 += 1) { //#12731
        $_.k = _17; //#12727
        $puti($_.encstr, ($_.k * 3) + 2, $get($_.encs, 14)); //#12728
        $_.checksum = $_.checksum + 14; //#12729
        $put($_.digits, $_.k, 14); //#12730
    } //#12730
    $_.checksum = 19 - ($_.checksum % 19); //#12734
    $puti($_.encstr, 2 + (20 * 3), $get($_.encs, $_.checksum)); //#12735
    $puti($_.encstr, 2 + (21 * 3), $get($_.encs, 20)); //#12738
    $_.checkdigit = " "; //#12739
    if ($_.includecheckintext) { //#12742
        $_.checkdigit = $geti($_.barchars, $_.checksum, 1); //#12741
    } //#12741
    $put($_.txt, $_.i + 1, $a([$_.checkdigit, ((20 * 3) + 2) * 3.312, $_.textyoffset, $_.textfont, $_.textsize])); //#12743
    $puti($_.encstr, ((20 + 1) * 3) + 2, $get($_.encs, 20)); //#12746
    $_.bbs = $a((21 * 3) + 4); //#12748
    $_.bhs = $a($_.bbs.length); //#12749
    for (var _1g = 0, _1f = $_.bbs.length - 1; _1g <= _1f; _1g += 1) { //#12773
        $_.i = _1g; //#12751
        $_.enc = $geti($_.encstr, $_.i, 1); //#12752
        $_.bunit = 0; //#12753
        $_.hunit = 0; //#12754
        if ($eq($_.enc, "0")) { //#12758
            $_.bunit = 3; //#12756
            $_.hunit = 2; //#12757
        } //#12757
        if ($eq($_.enc, "1")) { //#12762
            $_.bunit = 0; //#12760
            $_.hunit = 5; //#12761
        } //#12761
        if ($eq($_.enc, "2")) { //#12766
            $_.bunit = 3; //#12764
            $_.hunit = 5; //#12765
        } //#12765
        if ($eq($_.enc, "3")) { //#12770
            $_.bunit = 0; //#12768
            $_.hunit = 8; //#12769
        } //#12769
        $put($_.bbs, $_.i, ($_.bunit * $_.height) / 8); //#12771
        $put($_.bhs, $_.i, ($_.hunit * $_.height) / 8); //#12772
    } //#12772
    $k[$j++] = Infinity; //#12776
    var _1w = $_.bbs; //#12778
    var _1x = $_.bhs; //#12779
    $k[$j++] = Infinity; //#12780
    for (var _1z = 0, _20 = $_.bhs.length - 1; _1z < _20; _1z++) { //#12780
        $k[$j++] = 1.44; //#12780
        $k[$j++] = 1.872; //#12780
    } //#12780
    $k[$j++] = 1.44; //#12780
    var _21 = $a(); //#12780
    $k[$j++] = 'ren'; //#12783
    $k[$j++] = 'renlinear'; //#12783
    $k[$j++] = 'bbs'; //#12783
    $k[$j++] = _1w; //#12783
    $k[$j++] = 'bhs'; //#12783
    $k[$j++] = _1x; //#12783
    $k[$j++] = 'sbs'; //#12783
    $k[$j++] = _21; //#12783
    if ($_.includetext) { //#12783
        $k[$j++] = 'txt'; //#12782
        $k[$j++] = $_.txt; //#12782
    } //#12782
    $k[$j++] = 'opt'; //#12784
    $k[$j++] = $_.options; //#12784
    var _25 = $d(); //#12784
    $k[$j++] = _25; //#12787
    if (!$_.dontdraw) { //#12787
        bwipp_renlinear(); //#12787
    } //#12787
    $_ = Object.getPrototypeOf($_); //#12789
    $_ = Object.getPrototypeOf($_); //#12791
} //bwipp_japanpost
function bwipp_msi() {
    $_ = Object.create($_); //#12821
    $_.dontdraw = false; //#12824
    $_.includecheck = false; //#12825
    $_.includetext = false; //#12826
    $_.includecheckintext = false; //#12827
    $_.checktype = "unset"; //#12828
    $_.badmod11 = false; //#12829
    $_.textfont = "OCR-B"; //#12830
    $_.textsize = 10; //#12831
    $_.textyoffset = -8; //#12832
    $_.height = 1; //#12833
    $k[$j++] = $_; //#12835
    bwipp_processoptions(); //#12835
    $_.options = $k[--$j]; //#12835
    $_.barcode = $k[--$j]; //#12836
    if ($ne($_.checktype, "unset") && (!$_.includecheck)) { //#12840
        $k[$j++] = 'bwipp.msiCheckTypeWithoutCheck#12839'; //#12839
        $k[$j++] = "checktype requires includecheck"; //#12839
        bwipp_raiseerror(); //#12839
    } //#12839
    if ($_.badmod11 && ((($ne($_.checktype, "mod11") && $ne($_.checktype, "ncrmod11")) && $ne($_.checktype, "mod1110")) && $ne($_.checktype, "ncrmod1110"))) { //#12844
        $k[$j++] = 'bwipp.msiBadMod11Mismatch#12843'; //#12843
        $k[$j++] = "badmod11 requires checktype with mod11"; //#12843
        bwipp_raiseerror(); //#12843
    } //#12843
    if ($eq($_.checktype, "unset")) { //#12846
        $_.checktype = "mod10"; //#12846
    } //#12846
    bwipp_loadctx(bwipp_msi) //#12848
    $forall($_.barcode, function() { //#12855
        var _B = $k[--$j]; //#12852
        if ((_B < 48) || (_B > 57)) { //#12854
            $k[$j++] = 'bwipp.msiBadCharacter#12853'; //#12853
            $k[$j++] = "MSI must contain only digits"; //#12853
            bwipp_raiseerror(); //#12853
        } //#12853
    }); //#12853
    if (!bwipp_msi.__12867__) { //#12867
        $_ = Object.create($_); //#12867
        $_.encs = $a(["12121212", "12121221", "12122112", "12122121", "12211212", "12211221", "12212112", "12212121", "21121212", "21121221", "21", "121"]); //#12863
        $_.barchars = "0123456789"; //#12866
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_msi.$ctx[id] = $_[id]); //#12866
        bwipp_msi.__12867__ = 1; //#12866
        $_ = Object.getPrototypeOf($_); //#12866
    } //#12866
    $_.barlen = $_.barcode.length; //#12869
    $_.txtlen = $_.barlen; //#12870
    $_.mod10 = function() {
        $_.code = $k[--$j]; //#12873
        $k[$j++] = 0; //#12874
        $k[$j++] = 0; //#12874
        $forall($_.code, function() { //#12874
            var _I = $k[--$j]; //#12874
            var _J = $k[--$j]; //#12874
            var _K = $k[--$j]; //#12874
            $k[$j++] = $f($f(_I - 48) + (_J * 10)); //#12874
            $k[$j++] = _K; //#12874
        }); //#12874
        $j--; //#12874
        var _L = $k[--$j]; //#12874
        $k[$j++] = _L * 2; //#12875
        $k[$j++] = 0; //#12875
        for (;;) { //#12875
            var _M = $k[--$j]; //#12875
            var _N = $k[--$j]; //#12875
            var _O = ~~(_N / 10); //#12875
            $k[$j++] = $f(_M + (_N % 10)); //#12875
            $k[$j++] = _O; //#12875
            if (_O == 0) { //#12875
                $j--; //#12875
                break; //#12875
            } //#12875
            var _P = $k[--$j]; //#12875
            var _Q = $k[--$j]; //#12875
            $k[$j++] = _P; //#12875
            $k[$j++] = _Q; //#12875
        } //#12875
        $k[$j++] = 0; //#12876
        $k[$j++] = 0; //#12876
        $forall($_.code, function() { //#12876
            var _S = $k[--$j]; //#12876
            var _T = $k[--$j]; //#12876
            var _U = $k[--$j]; //#12876
            $k[$j++] = $f(_T + $f(_S - 48)); //#12876
            $k[$j++] = _U; //#12876
        }); //#12876
        var _V = $k[--$j]; //#12876
        var _W = $k[--$j]; //#12876
        $k[$j++] = _V; //#12876
        $k[$j++] = _W; //#12876
        $j--; //#12876
        var _X = $k[--$j]; //#12876
        var _a = $s($_.code.length + 1); //#12878
        $puti(_a, 0, $_.code); //#12878
        $put(_a, $_.code.length, $f((($f(10 - ($f($k[--$j] + _X) % 10))) % 10) + 48)); //#12878
        $k[$j++] = _a; //#12878
    }; //#12878
    $_.mod11 = function() {
        $_.code = $k[--$j]; //#12882
        $k[$j++] = $_.code.length - 1; //#12883
        $forall($_.code, function() { //#12883
            var _g = $k[--$j]; //#12883
            var _h = $k[--$j]; //#12883
            $k[$j++] = $f(_g - 48); //#12883
            $k[$j++] = $f((_h % 6) + 2); //#12883
            $k[$j++] = $f(_h - 1); //#12883
        }); //#12883
        $j--; //#12883
        $k[$j++] = 0; //#12884
        for (var _j = 0, _k = $_.code.length; _j < _k; _j++) { //#12884
            var _l = $k[--$j]; //#12884
            var _m = $k[--$j]; //#12884
            var _n = $k[--$j]; //#12884
            $k[$j++] = $f(_l + (_n * _m)); //#12884
        } //#12884
        var _p = ($f(11 - ($k[--$j] % 11))) % 11; //#12886
        $k[$j++] = _p; //#12894
        if (_p == 10) { //#12893
            if ($_.badmod11) { //#12890
                $j--; //#12888
                var _s = $s($_.code.length + 2); //#12888
                $puti(_s, 0, $_.code); //#12888
                $puti(_s, $_.code.length, "10"); //#12888
                $k[$j++] = _s; //#12888
            } else { //#12890
                $j--; //#12890
                $k[$j++] = 'bwipp.msiBadMod11NotSpecified#12890'; //#12890
                $k[$j++] = "mod11 check digit is 10 but badmod11 not specified"; //#12890
                bwipp_raiseerror(); //#12890
            } //#12890
        } else { //#12893
            var _w = $s($_.code.length + 1); //#12893
            $puti(_w, 0, $_.code); //#12893
            $put(_w, $_.code.length, $f($k[--$j] + 48)); //#12893
            $k[$j++] = _w; //#12893
        } //#12893
    }; //#12893
    $_.ncrmod11 = function() {
        $_.code = $k[--$j]; //#12898
        $k[$j++] = $_.code.length - 1; //#12899
        $forall($_.code, function() { //#12899
            var _13 = $k[--$j]; //#12899
            var _14 = $k[--$j]; //#12899
            $k[$j++] = $f(_13 - 48); //#12899
            $k[$j++] = $f((_14 % 8) + 2); //#12899
            $k[$j++] = $f(_14 - 1); //#12899
        }); //#12899
        $j--; //#12899
        $k[$j++] = 0; //#12900
        for (var _16 = 0, _17 = $_.code.length; _16 < _17; _16++) { //#12900
            var _18 = $k[--$j]; //#12900
            var _19 = $k[--$j]; //#12900
            var _1A = $k[--$j]; //#12900
            $k[$j++] = $f(_18 + (_1A * _19)); //#12900
        } //#12900
        var _1C = ($f(11 - ($k[--$j] % 11))) % 11; //#12902
        $k[$j++] = _1C; //#12910
        if (_1C == 10) { //#12909
            if ($_.badmod11) { //#12906
                $j--; //#12904
                var _1F = $s($_.code.length + 2); //#12904
                $puti(_1F, 0, $_.code); //#12904
                $puti(_1F, $_.code.length, "10"); //#12904
                $k[$j++] = _1F; //#12904
            } else { //#12906
                $j--; //#12906
                $k[$j++] = 'bwipp.msiBadMod11NotSpecified#12906'; //#12906
                $k[$j++] = "mod11 check digit is 10 but badmod11 not specified"; //#12906
                bwipp_raiseerror(); //#12906
            } //#12906
        } else { //#12909
            var _1J = $s($_.code.length + 1); //#12909
            $puti(_1J, 0, $_.code); //#12909
            $put(_1J, $_.code.length, $f($k[--$j] + 48)); //#12909
            $k[$j++] = _1J; //#12909
        } //#12909
    }; //#12909
    if (!bwipp_msi.__12922__) { //#12922
        $_ = Object.create($_); //#12922
        var _1N = new Map([
            ["mod10", function() {
                $_.mod10(); //#12915
            }],
            ["mod1010", function() {
                $_.mod10(); //#12916
                $_.mod10(); //#12916
            }],
            ["mod11", function() {
                $_.mod11(); //#12917
            }],
            ["ncrmod11", function() {
                $_.ncrmod11(); //#12918
            }],
            ["mod1110", function() {
                $_.mod11(); //#12919
                $_.mod10(); //#12919
            }],
            ["ncrmod1110", function() {
                $_.ncrmod11(); //#12920
                $_.mod10(); //#12920
            }]
        ]); //#12920
        $_.checkfunc = _1N; //#12921
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_msi.$ctx[id] = $_[id]); //#12921
        bwipp_msi.__12922__ = 1; //#12921
        $_ = Object.getPrototypeOf($_); //#12921
    } //#12921
    if ($_.includecheck) { //#12932
        var _1Q = $_.checkfunc; //#12926
        var _1R = $_.checktype; //#12926
        var _1S = $get(_1Q, _1R) !== undefined; //#12926
        $k[$j++] = _1Q; //#12928
        $k[$j++] = _1R; //#12928
        if (!_1S) { //#12928
            $j -= 2; //#12927
            $k[$j++] = 'bwipp.msiBadCharacter#12927'; //#12927
            $k[$j++] = "MSI checktype must be mod10, mod1010, mod11, ncrmod11, mod1110 or ncrmod1110"; //#12927
            bwipp_raiseerror(); //#12927
        } //#12927
        var _1T = $k[--$j]; //#12929
        var _1V = $get($k[--$j], _1T); //#12929
        $k[$j++] = $_.barcode; //#12929
        if (_1V() === true) {
            return true;
        } //#12929
        $_.barcode = $k[--$j]; //#12929
        $_.barlen = $_.barcode.length; //#12930
        if ($_.includecheckintext) { //#12931
            $_.txtlen = $_.barlen; //#12931
        } //#12931
    } //#12931
    $_.sbs = $s(($_.barlen * 8) + 5); //#12934
    $_.txt = $a($_.barlen); //#12935
    $puti($_.sbs, 0, $get($_.encs, 10)); //#12938
    for (var _1k = 0, _1j = $_.barlen - 1; _1k <= _1j; _1k += 1) { //#12950
        $_.i = _1k; //#12941
        $search($_.barchars, $geti($_.barcode, $_.i, 1)); //#12943
        $j--; //#12944
        $_.indx = $k[--$j].length; //#12945
        $j -= 2; //#12946
        $_.enc = $get($_.encs, $_.indx); //#12947
        $puti($_.sbs, ($_.i * 8) + 2, $_.enc); //#12948
        $put($_.txt, $_.i, $a([$geti($_.barcode, $_.i, 1), ($_.i * 12) + 3, $_.textyoffset, $_.textfont, $_.textsize])); //#12949
    } //#12949
    $puti($_.sbs, ($_.barlen * 8) + 2, $get($_.encs, 11)); //#12953
    $k[$j++] = Infinity; //#12956
    $k[$j++] = Infinity; //#12958
    var _2A = $_.sbs; //#12958
    for (var _2B = 0, _2C = _2A.length; _2B < _2C; _2B++) { //#12958
        $k[$j++] = $get(_2A, _2B) - 48; //#12958
    } //#12958
    var _2E = $a(); //#12958
    $k[$j++] = Infinity; //#12959
    for (var _2G = 0, _2H = ~~(($_.sbs.length + 1) / 2); _2G < _2H; _2G++) { //#12959
        $k[$j++] = $_.height; //#12959
    } //#12959
    var _2J = $a(); //#12959
    $k[$j++] = Infinity; //#12960
    for (var _2L = 0, _2M = ~~(($_.sbs.length + 1) / 2); _2L < _2M; _2L++) { //#12960
        $k[$j++] = 0; //#12960
    } //#12960
    var _2N = $a(); //#12960
    $k[$j++] = 'ren'; //#12963
    $k[$j++] = 'renlinear'; //#12963
    $k[$j++] = 'sbs'; //#12963
    $k[$j++] = _2E; //#12963
    $k[$j++] = 'bhs'; //#12963
    $k[$j++] = _2J; //#12963
    $k[$j++] = 'bbs'; //#12963
    $k[$j++] = _2N; //#12963
    if ($_.includetext) { //#12963
        $k[$j++] = 'txt'; //#12962
        $k[$j++] = $geti($_.txt, 0, $_.txtlen); //#12962
    } //#12962
    $k[$j++] = 'opt'; //#12964
    $k[$j++] = $_.options; //#12964
    var _2T = $d(); //#12964
    $k[$j++] = _2T; //#12967
    if (!$_.dontdraw) { //#12967
        bwipp_renlinear(); //#12967
    } //#12967
    $_ = Object.getPrototypeOf($_); //#12969
    $_ = Object.getPrototypeOf($_); //#12971
} //bwipp_msi
function bwipp_plessey() {
    $_ = Object.create($_); //#13001
    $_.dontdraw = false; //#13004
    $_.includetext = false; //#13005
    $_.validatecheck = false; //#13006
    $_.includecheckintext = false; //#13007
    $_.unidirectional = false; //#13008
    $_.textfont = "OCR-B"; //#13009
    $_.textsize = 10; //#13010
    $_.textyoffset = -8; //#13011
    $_.height = 1; //#13012
    $k[$j++] = $_; //#13014
    bwipp_processoptions(); //#13014
    $_.options = $k[--$j]; //#13014
    $_.barcode = $k[--$j]; //#13015
    if ($eq($_.barcode, "")) { //#13019
        $k[$j++] = 'bwipp.plesseyEmptyData#13018'; //#13018
        $k[$j++] = "The data must not be empty"; //#13018
        bwipp_raiseerror(); //#13018
    } //#13018
    bwipp_loadctx(bwipp_plessey) //#13021
    if (!bwipp_plessey.__13037__) { //#13037
        $_ = Object.create($_); //#13037
        $_.barchars = "0123456789ABCDEF"; //#13025
        $_.charvals = new Map; //#13026
        for (var _3 = 0; _3 <= 15; _3 += 1) { //#13027
            $put($_.charvals, $geti($_.barchars, _3, 1), _3); //#13027
        } //#13027
        $_.encs = $a(["14141414", "32141414", "14321414", "32321414", "14143214", "32143214", "14323214", "32323214", "14141432", "32141432", "14321432", "32321432", "14143232", "32143232", "14323232", "32323232", "32321432", "541412323", "323"]); //#13036
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_plessey.$ctx[id] = $_[id]); //#13036
        bwipp_plessey.__13037__ = 1; //#13036
        $_ = Object.getPrototypeOf($_); //#13036
    } //#13036
    for (var _B = 0, _A = $_.barcode.length - 1; _B <= _A; _B += 1) { //#13044
        var _F = $get($_.charvals, $geti($_.barcode, _B, 1)) !== undefined; //#13041
        if (!_F) { //#13043
            $k[$j++] = 'bwipp.plesseyBadCharacter#13042'; //#13042
            $k[$j++] = "Plessey must contain only digits and letters A B C D E F"; //#13042
            bwipp_raiseerror(); //#13042
        } //#13042
    } //#13042
    $k[$j++] = 'barlen'; //#13046
    $k[$j++] = $_.barcode.length; //#13046
    if ($_.validatecheck) { //#13046
        var _I = $k[--$j]; //#13046
        $k[$j++] = $f(_I - 2); //#13046
    } //#13046
    var _J = $k[--$j]; //#13046
    $_[$k[--$j]] = _J; //#13046
    $_.checkbits = $a($f(($_.barlen * 4) + 8)); //#13049
    $puti($_.checkbits, $_.barlen * 4, $a([0, 0, 0, 0, 0, 0, 0, 0])); //#13050
    for (var _S = 0, _R = $f($_.barlen - 1); _S <= _R; _S += 1) { //#13060
        $_.i = _S; //#13052
        $_.indx = $get($_.charvals, $geti($_.barcode, $_.i, 1)); //#13053
        $puti($_.checkbits, $_.i * 4, $a([$_.indx & 1, ($_.indx >>> 1) & 1, ($_.indx >>> 2) & 1, $_.indx >>> 3])); //#13059
    } //#13059
    $_.checksalt = $a([1, 1, 1, 1, 0, 1, 0, 0, 1]); //#13061
    for (var _i = 0, _h = $f(($_.barlen * 4) - 1); _i <= _h; _i += 1) { //#13070
        $_.i = _i; //#13063
        if ($get($_.checkbits, $_.i) == 1) { //#13069
            for (var _m = 0; _m <= 8; _m += 1) { //#13068
                $_.j = _m; //#13066
                $put($_.checkbits, $_.i + $_.j, $xo($get($_.checkbits, $_.i + $_.j), $get($_.checksalt, $_.j))); //#13067
            } //#13067
        } //#13067
    } //#13067
    $_.checkval = 0; //#13071
    for (var _x = 0; _x <= 7; _x += 1) { //#13075
        $_.i = _x; //#13073
        $_.checkval = $f($_.checkval + ((~~Math.pow(2, $_.i)) * $get($_.checkbits, $f(($_.barlen * 4) + $_.i)))); //#13074
    } //#13074
    $_.checksum1 = $_.checkval & 15; //#13076
    $_.checksum2 = $_.checkval >>> 4; //#13077
    if ($_.validatecheck) { //#13084
        if (($get($_.barcode, $_.barlen) != $get($_.barchars, $_.checksum1)) || ($get($_.barcode, $f($_.barlen + 1)) != $get($_.barchars, $_.checksum2))) { //#13082
            $k[$j++] = 'bwipp.plesseyBadCheckDigits#13081'; //#13081
            $k[$j++] = "Incorrect Plessey check digits provided"; //#13081
            bwipp_raiseerror(); //#13081
        } //#13081
        $_.barcode = $geti($_.barcode, 0, $_.barlen); //#13083
    } //#13083
    var _1O = $_.unidirectional ? 27 : 33; //#13086
    $_.sbs = $s($f(($_.barlen * 8) + _1O)); //#13086
    $_.txt = $a($f($_.barlen + 2)); //#13087
    $puti($_.sbs, 0, $get($_.encs, 16)); //#13090
    for (var _1X = 0, _1W = $f($_.barlen - 1); _1X <= _1W; _1X += 1) { //#13097
        $_.i = _1X; //#13093
        $_.indx = $get($_.charvals, $geti($_.barcode, $_.i, 1)); //#13094
        $puti($_.sbs, ($_.i * 8) + 8, $get($_.encs, $_.indx)); //#13095
        $put($_.txt, $_.i, $a([$geti($_.barcode, $_.i, 1), ($_.i * 20) + 20, $_.textyoffset, $_.textfont, $_.textsize])); //#13096
    } //#13096
    $puti($_.sbs, $f(($_.barlen * 8) + 8), $get($_.encs, $_.checksum1)); //#13100
    $puti($_.sbs, $f(($_.barlen * 8) + 16), $get($_.encs, $_.checksum2)); //#13101
    if ($_.includecheckintext) { //#13107
        $put($_.txt, $_.barlen, $a([$geti($_.barchars, $_.checksum1, 1), $f(($_.barlen * 20) + 20), $_.textyoffset, $_.textfont, $_.textsize])); //#13103
        $put($_.txt, $f($_.barlen + 1), $a([$geti($_.barchars, $_.checksum2, 1), $f(($f($_.barlen + 1) * 20) + 20), $_.textyoffset, $_.textfont, $_.textsize])); //#13104
    } else { //#13107
        $put($_.txt, $_.barlen, $a([" ", $f(($_.barlen * 20) + 20), $_.textyoffset, $_.textfont, $_.textsize])); //#13106
        $put($_.txt, $f($_.barlen + 1), $a([" ", $f(($f($_.barlen + 1) * 20) + 20), $_.textyoffset, $_.textfont, $_.textsize])); //#13107
    } //#13107
    var _2f = $_.unidirectional ? 18 : 17; //#13111
    $puti($_.sbs, $f(($_.barlen * 8) + 24), $get($_.encs, _2f)); //#13111
    $k[$j++] = Infinity; //#13114
    $k[$j++] = Infinity; //#13116
    var _2h = $_.sbs; //#13116
    for (var _2i = 0, _2j = _2h.length; _2i < _2j; _2i++) { //#13116
        $k[$j++] = $get(_2h, _2i) - 48; //#13116
    } //#13116
    var _2l = $a(); //#13116
    $k[$j++] = Infinity; //#13117
    for (var _2n = 0, _2o = ~~(($_.sbs.length + 1) / 2); _2n < _2o; _2n++) { //#13117
        $k[$j++] = $_.height; //#13117
    } //#13117
    var _2q = $a(); //#13117
    $k[$j++] = Infinity; //#13118
    for (var _2s = 0, _2t = ~~(($_.sbs.length + 1) / 2); _2s < _2t; _2s++) { //#13118
        $k[$j++] = 0; //#13118
    } //#13118
    var _2u = $a(); //#13118
    $k[$j++] = 'ren'; //#13121
    $k[$j++] = 'renlinear'; //#13121
    $k[$j++] = 'sbs'; //#13121
    $k[$j++] = _2l; //#13121
    $k[$j++] = 'bhs'; //#13121
    $k[$j++] = _2q; //#13121
    $k[$j++] = 'bbs'; //#13121
    $k[$j++] = _2u; //#13121
    if ($_.includetext) { //#13121
        $k[$j++] = 'txt'; //#13120
        $k[$j++] = $_.txt; //#13120
    } //#13120
    $k[$j++] = 'opt'; //#13122
    $k[$j++] = $_.options; //#13122
    var _2y = $d(); //#13122
    $k[$j++] = _2y; //#13125
    if (!$_.dontdraw) { //#13125
        bwipp_renlinear(); //#13125
    } //#13125
    $_ = Object.getPrototypeOf($_); //#13127
    $_ = Object.getPrototypeOf($_); //#13129
} //bwipp_plessey
function bwipp_telepen() {
    $_ = Object.create($_); //#13160
    $_.numeric = false; //#13163
    $_.dontdraw = false; //#13164
    $_.includetext = false; //#13165
    $_.textfont = "OCR-B"; //#13166
    $_.textsize = 10; //#13167
    $_.textyoffset = -8; //#13168
    $_.height = 1; //#13169
    $_.parse = false; //#13170
    $k[$j++] = $_; //#13172
    bwipp_processoptions(); //#13172
    $_.options = $k[--$j]; //#13172
    $_.barcode = $k[--$j]; //#13173
    bwipp_loadctx(bwipp_telepen) //#13175
    var _3 = new Map([
        ["parse", $_.parse],
        ["parseonly", true],
        ["parsefnc", false]
    ]); //#13181
    $_.fncvals = _3; //#13182
    $k[$j++] = 'barcode'; //#13183
    $k[$j++] = $_.barcode; //#13183
    $k[$j++] = $_.fncvals; //#13183
    bwipp_parseinput(); //#13183
    var _6 = $k[--$j]; //#13183
    $_[$k[--$j]] = _6; //#13183
    $_.barlen = $_.barcode.length; //#13184
    delete $_.options["parse"]; //#13185
    if ($_.numeric && (($_.barlen % 2) != 0)) { //#13189
        $k[$j++] = 'bwipp.telepenNumericOddLength#13188'; //#13188
        $k[$j++] = "Telepen Numeric must have an even length"; //#13188
        bwipp_raiseerror(); //#13188
    } //#13188
    if (!bwipp_telepen.__13227__) { //#13227
        $_ = Object.create($_); //#13227
        $_.encs = $a(["31313131", "1131313111", "33313111", "1111313131", "3111313111", "11333131", "13133131", "111111313111", "31333111", "1131113131", "33113131", "1111333111", "3111113131", "1113133111", "1311133111", "111111113131", "3131113111", "11313331", "333331", "111131113111", "31113331", "1133113111", "1313113111", "1111113331", "31131331", "113111113111", "3311113111", "1111131331", "311111113111", "1113111331", "1311111331", "11111111113111", "31313311", "1131311131", "33311131", "1111313311", "3111311131", "11333311", "13133311", "111111311131", "31331131", "1131113311", "33113311", "1111331131", "3111113311", "1113131131", "1311131131", "111111113311", "3131111131", "1131131311", "33131311", "111131111131", "3111131311", "1133111131", "1313111131", "111111131311", "3113111311", "113111111131", "3311111131", "111113111311", "311111111131", "111311111311", "131111111311", "11111111111131", "3131311111", "11313133", "333133", "111131311111", "31113133", "1133311111", "1313311111", "1111113133", "313333", "113111311111", "3311311111", "11113333", "311111311111", "11131333", "13111333", "11111111311111", "31311133", "1131331111", "33331111", "1111311133", "3111331111", "11331133", "13131133", "111111331111", "3113131111", "1131111133", "33111133", "111113131111", "3111111133", "111311131111", "131111131111", "111111111133", "31311313", "113131111111", "3331111111", "1111311313", "311131111111", "11331313", "13131313", "11111131111111", "3133111111", "1131111313", "33111313", "111133111111", "3111111313", "111313111111", "131113111111", "111111111313", "313111111111", "1131131113", "33131113", "11113111111111", "3111131113", "113311111111", "131311111111", "111111131113", "3113111113", "11311111111111", "331111111111", "111113111113", "31111111111111", "111311111113", "131111111113", "1111111111111111"]); //#13226
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_telepen.$ctx[id] = $_[id]); //#13226
        bwipp_telepen.__13227__ = 1; //#13226
        $_ = Object.getPrototypeOf($_); //#13226
    } //#13226
    $_.sbs = $s(($_.barlen * 16) + 48); //#13229
    $_.txt = $a($_.barlen); //#13230
    $_.enc = $get($_.encs, 95); //#13233
    $puti($_.sbs, 0, $_.enc); //#13234
    $_.l = $_.enc.length; //#13235
    $_.checksum = 0; //#13237
    $_.i = 0; //#13238
    $_.j = 0; //#13238
    for (;;) { //#13281
        if ($_.i == $_.barlen) { //#13240
            break; //#13240
        } //#13240
        if ($_.numeric) { //#13274
            if ($get($_.barcode, $_.i) > 16) { //#13262
                $_.np = $geti($_.barcode, $_.i, 2); //#13243
                var _X = $get($_.np, 0); //#13244
                var _Z = $get($_.np, 1); //#13245
                if (((_X < 48) || (_X > 57)) || (((_Z < 48) || (_Z > 57)) && (!(_Z == 88)))) { //#13251
                    $k[$j++] = -1; //#13247
                } else { //#13251
                    var _e = $f($get($_.np, 1) - 48); //#13250
                    $k[$j++] = $f($get($_.np, 0) - 48); //#13250
                    $k[$j++] = _e; //#13250
                    if (_e != 40) { //#13250
                        var _f = $k[--$j]; //#13250
                        var _g = $k[--$j]; //#13250
                        $k[$j++] = $f(($f(_f + (_g * 10))) + 10); //#13250
                    } else { //#13250
                        $j--; //#13250
                    } //#13250
                    var _h = $k[--$j]; //#13251
                    $k[$j++] = $f(_h + 17); //#13251
                } //#13251
                var _i = $k[--$j]; //#13253
                $k[$j++] = _i; //#13255
                if (_i == -1) { //#13255
                    $k[$j++] = 'bwipp.telepenInvalidNumericCharacter#13254'; //#13254
                    $k[$j++] = "Telepen Numeric may contain only digits, or X in even positions"; //#13254
                    bwipp_raiseerror(); //#13254
                } //#13254
                $_.indx = $k[--$j]; //#13256
                $put($_.txt, $_.j, $a([$_.np, ($_.j * 16) + 16, $_.textyoffset, $_.textfont, $_.textsize])); //#13257
                $_.i = $_.i + 2; //#13258
            } else { //#13262
                $_.indx = $get($_.barcode, $_.i); //#13260
                $put($_.txt, $_.j, $a([" ", ($_.j * 16) + 16, $_.textyoffset, $_.textfont, $_.textsize])); //#13261
                $_.i = $_.i + 1; //#13262
            } //#13262
        } else { //#13274
            $_.indx = $get($_.barcode, $_.i); //#13265
            if ($_.indx > 127) { //#13268
                $k[$j++] = 'bwipp.telepenInvalidAlphaCharacter#13267'; //#13267
                $k[$j++] = "Telepen Alpha characters must have ordinal values 0 to 127"; //#13267
                bwipp_raiseerror(); //#13267
            } //#13267
            if (($_.indx >= 32) && ($_.indx <= 126)) { //#13272
                $put($_.txt, $_.j, $a([$geti($_.barcode, $_.i, 1), ($_.j * 16) + 16, $_.textyoffset, $_.textfont, $_.textsize])); //#13270
            } else { //#13272
                $put($_.txt, $_.j, $a([" ", ($_.j * 16) + 16, $_.textyoffset, $_.textfont, $_.textsize])); //#13272
            } //#13272
            $_.i = $_.i + 1; //#13274
        } //#13274
        $_.checksum = $f($_.checksum + $_.indx); //#13276
        $_.enc = $get($_.encs, $_.indx); //#13277
        $puti($_.sbs, $_.l, $_.enc); //#13278
        $_.l = $_.l + $_.enc.length; //#13279
        $_.j = $_.j + 1; //#13280
    } //#13280
    $_.checksum = ($f(127 - ($_.checksum % 127))) % 127; //#13284
    $_.enc = $get($_.encs, $_.checksum); //#13285
    $puti($_.sbs, $_.l, $_.enc); //#13286
    $_.l = $_.l + $_.enc.length; //#13287
    $_.enc = $get($_.encs, 122); //#13290
    $puti($_.sbs, $_.l, $_.enc); //#13291
    $_.l = $_.l + $_.enc.length; //#13292
    $_.sbs = $geti($_.sbs, 0, $_.l); //#13295
    $_.txt = $geti($_.txt, 0, $_.j); //#13296
    $k[$j++] = Infinity; //#13299
    $k[$j++] = Infinity; //#13301
    var _1z = $_.sbs; //#13301
    for (var _20 = 0, _21 = _1z.length; _20 < _21; _20++) { //#13301
        $k[$j++] = $f($get(_1z, _20) - 48); //#13301
    } //#13301
    var _23 = $a(); //#13301
    $k[$j++] = Infinity; //#13302
    for (var _25 = 0, _26 = ~~(($_.sbs.length + 1) / 2); _25 < _26; _25++) { //#13302
        $k[$j++] = $_.height; //#13302
    } //#13302
    var _28 = $a(); //#13302
    $k[$j++] = Infinity; //#13303
    for (var _2A = 0, _2B = ~~(($_.sbs.length + 1) / 2); _2A < _2B; _2A++) { //#13303
        $k[$j++] = 0; //#13303
    } //#13303
    var _2C = $a(); //#13303
    $k[$j++] = 'ren'; //#13306
    $k[$j++] = 'renlinear'; //#13306
    $k[$j++] = 'sbs'; //#13306
    $k[$j++] = _23; //#13306
    $k[$j++] = 'bhs'; //#13306
    $k[$j++] = _28; //#13306
    $k[$j++] = 'bbs'; //#13306
    $k[$j++] = _2C; //#13306
    if ($_.includetext) { //#13306
        $k[$j++] = 'txt'; //#13305
        $k[$j++] = $_.txt; //#13305
    } //#13305
    $k[$j++] = 'opt'; //#13307
    $k[$j++] = $_.options; //#13307
    var _2G = $d(); //#13307
    $k[$j++] = _2G; //#13310
    if (!$_.dontdraw) { //#13310
        bwipp_renlinear(); //#13310
    } //#13310
    $_ = Object.getPrototypeOf($_); //#13312
    $_ = Object.getPrototypeOf($_); //#13314
} //bwipp_telepen
function bwipp_telepennumeric() {
    $_ = Object.create($_); //#13343
    $_.dontdraw = false; //#13346
    $k[$j++] = $_; //#13348
    bwipp_processoptions(); //#13348
    $_.options = $k[--$j]; //#13348
    $_.barcode = $k[--$j]; //#13349
    $put($_.options, "dontdraw", true); //#13352
    $put($_.options, "numeric", true); //#13353
    $k[$j++] = 'args'; //#13355
    $k[$j++] = $_.barcode; //#13355
    $k[$j++] = $_.options; //#13355
    bwipp_telepen(); //#13355
    var _6 = $k[--$j]; //#13355
    $_[$k[--$j]] = _6; //#13355
    $put($_.args, "opt", $_.options); //#13357
    $k[$j++] = $_.args; //#13360
    if (!$_.dontdraw) { //#13360
        bwipp_renlinear(); //#13360
    } //#13360
    $_ = Object.getPrototypeOf($_); //#13362
} //bwipp_telepennumeric
function bwipp_posicode() {
    $_ = Object.create($_); //#13393
    $_.dontdraw = false; //#13396
    $_.includetext = false; //#13397
    $_.textfont = "OCR-B"; //#13398
    $_.textsize = 10; //#13399
    $_.textxoffset = 0; //#13400
    $_.textyoffset = -8; //#13401
    $_.height = 1; //#13402
    $_.encoding = "auto"; //#13403
    $_.version = "a"; //#13404
    $_.checkoffset = 0; //#13405
    $_.raw = false; //#13406
    $_.parse = false; //#13407
    $_.parsefnc = false; //#13408
    $k[$j++] = $_; //#13410
    bwipp_processoptions(); //#13410
    $_.options = $k[--$j]; //#13410
    var _1 = $k[--$j]; //#13411
    $_.barcode = _1; //#13411
    bwipp_loadctx(bwipp_posicode) //#13413
    if (!bwipp_posicode.__13456__) { //#13456
        $_ = Object.create($_); //#13456
        $_.la0 = -1; //#13417
        $_.la1 = -2; //#13417
        $_.la2 = -3; //#13417
        $_.sf0 = -4; //#13418
        $_.sf1 = -5; //#13418
        $_.sf2 = -6; //#13418
        $_.fn1 = -7; //#13419
        $_.fn2 = -8; //#13419
        $_.fn3 = -9; //#13419
        $_.fn4 = -10; //#13419
        $_.charmapsnormal = $a([$a(["0", "^", "'"]), $a(["1", ";", 27]), $a(["2", "<", 28]), $a(["3", "=", 29]), $a(["4", ">", 30]), $a(["5", "?", 31]), $a(["6", "@", "!"]), $a(["7", "[", "\""]), $a(["8", 92, "#"]), $a(["9", "]", "&"]), $a(["A", "a", 1]), $a(["B", "b", 2]), $a(["C", "c", 3]), $a(["D", "d", 4]), $a(["E", "e", 5]), $a(["F", "f", 6]), $a(["G", "g", 7]), $a(["H", "h", 8]), $a(["I", "i", 9]), $a(["J", "j", 10]), $a(["K", "k", 11]), $a(["L", "l", 12]), $a(["M", "m", 13]), $a(["N", "n", 14]), $a(["O", "o", 15]), $a(["P", "p", 16]), $a(["Q", "q", 17]), $a(["R", "r", 18]), $a(["S", "s", 19]), $a(["T", "t", 20]), $a(["U", "u", 21]), $a(["V", "v", 22]), $a(["W", "w", 23]), $a(["X", "x", 24]), $a(["Y", "y", 25]), $a(["Z", "z", 26]), $a(["-", "_", 40]), $a([".", "`", 41]), $a([" ", 127, 0]), $a(["$", "{", "*"]), $a(["/", "|", ","]), $a(["+", "}", ":"]), $a(["%", "~", $_.fn1]), $a([$_.la1, $_.la0, $_.fn2]), $a([$_.sf1, $_.sf0, $_.fn3]), $a([$_.sf2, $_.sf2, $_.fn4])]); //#13440
        var _13 = $a(["6", -98, -98]); //#13444
        $_.chapmapslimited = $a([$a(["0", -98, -98]), $a(["1", -98, -98]), $a(["2", -98, -98]), $a(["3", -98, -98]), $a(["4", -98, -98]), $a(["5", -98, -98]), _13, $a(["7", -98, -98]), $a(["8", -98, -98]), $a(["9", -98, -98]), $a(["A", -98, -98]), $a(["B", -98, -98]), $a(["C", -98, -98]), $a(["D", -98, -98]), $a(["E", -98, -98]), $a(["F", -98, -98]), $a(["G", -98, -98]), $a(["H", -98, -98]), $a(["I", -98, -98]), $a(["J", -98, -98]), $a(["K", -98, -98]), $a(["L", -98, -98]), $a(["M", -98, -98]), $a(["N", -98, -98]), $a(["O", -98, -98]), $a(["P", -98, -98]), $a(["Q", -98, -98]), $a(["R", -98, -98]), $a(["S", -98, -98]), $a(["T", -98, -98]), $a(["U", -98, -98]), $a(["V", -98, -98]), $a(["W", -98, -98]), $a(["X", -98, -98]), $a(["Y", -98, -98]), $a(["Z", -98, -98]), $a(["-", -98, -98]), $a([".", -98, -98])]); //#13455
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_posicode.$ctx[id] = $_[id]); //#13455
        bwipp_posicode.__13456__ = 1; //#13455
        $_ = Object.getPrototypeOf($_); //#13455
    } //#13455
    if ((($ne($_.version, "a") && $ne($_.version, "b")) && $ne($_.version, "limiteda")) && $ne($_.version, "limitedb")) { //#13460
        $k[$j++] = 'bwipp.posicodeInvalidVersion#13459'; //#13459
        $k[$j++] = "The version must be either a, b, limiteda or limitedb"; //#13459
        bwipp_raiseerror(); //#13459
    } //#13459
    $k[$j++] = 'charmaps'; //#13462
    if ($eq($_.version, "a") || $eq($_.version, "b")) { //#13462
        $k[$j++] = $_.charmapsnormal; //#13462
    } else { //#13462
        $k[$j++] = $_.chapmapslimited; //#13462
    } //#13462
    var _1j = $k[--$j]; //#13462
    $_[$k[--$j]] = _1j; //#13462
    var _1l = $_.charmaps; //#13466
    var _1m = $_.charmaps; //#13466
    var _1n = $_.charmaps; //#13466
    $_.charvals = $a([new Map, new Map, new Map]); //#13467
    for (var _1r = 0, _1q = $_.charmaps.length - 1; _1r <= _1q; _1r += 1) { //#13476
        $_.i = _1r; //#13469
        $_.encs = $get($_.charmaps, $_.i); //#13470
        for (var _1v = 0; _1v <= 2; _1v += 1) { //#13475
            $_.j = _1v; //#13472
            var _1y = $get($_.encs, $_.j); //#13473
            $k[$j++] = _1y; //#13473
            if ($eq($type(_1y), 'stringtype')) { //#13473
                var _21 = $get($k[--$j], 0); //#13473
                $k[$j++] = _21; //#13473
            } //#13473
            $put($get($_.charvals, $_.j), $k[--$j], $_.i); //#13474
        } //#13474
    } //#13474
    $_.set0 = $get($_.charvals, 0); //#13477
    $_.set1 = $get($_.charvals, 1); //#13478
    $_.set2 = $get($_.charvals, 2); //#13479
    if ($eq($_.version, "limiteda") || $eq($_.version, "limitedb")) { //#13488
        for (var _2H = 0, _2G = $_.barcode.length - 1; _2H <= _2G; _2H += 1) { //#13487
            var _2M = $get($_.set0, $get($geti($_.barcode, _2H, 1), 0)) !== undefined; //#13484
            if (!_2M) { //#13486
                $k[$j++] = 'bwipp.posicodeBadCharacter#13485'; //#13485
                $k[$j++] = "Posicode limited must contain only digits, capital letters, and the symbols - and ."; //#13485
                bwipp_raiseerror(); //#13485
            } //#13485
        } //#13485
    } //#13485
    if ($_.raw) { //#13490
        $_.encoding = "raw"; //#13490
    } //#13490
    if ($eq($_.encoding, "raw")) { //#13504
        $_.cws = $a($_.barcode.length); //#13493
        $_.i = 0; //#13494
        $_.j = 0; //#13494
        for (;;) { //#13501
            if ($_.i == $_.barcode.length) { //#13496
                break; //#13496
            } //#13496
            $_.cw = $cvi($geti($_.barcode, $_.i + 1, 3)); //#13497
            $put($_.cws, $_.j, $_.cw); //#13498
            $_.i = $_.i + 4; //#13499
            $_.j = $_.j + 1; //#13500
        } //#13500
        $_.cws = $geti($_.cws, 0, $_.j); //#13502
        $_.text = ""; //#13503
    } //#13503
    if ($eq($_.encoding, "auto")) { //#13619
        var _2k = new Map([
            ["parse", $_.parse],
            ["parsefnc", $_.parsefnc],
            ["FNC1", $_.fn1],
            ["FNC2", $_.fn2],
            ["FNC3", $_.fn3]
        ]); //#13514
        $_.fncvals = _2k; //#13516
        $k[$j++] = 'msg'; //#13517
        $k[$j++] = $_.barcode; //#13517
        $k[$j++] = $_.fncvals; //#13517
        bwipp_parseinput(); //#13517
        var _2n = $k[--$j]; //#13517
        $_[$k[--$j]] = _2n; //#13517
        $_.msglen = $_.msg.length; //#13518
        $_.text = $s($_.msglen); //#13520
        for (var _2u = 0, _2t = $_.msglen - 1; _2u <= _2t; _2u += 1) { //#13524
            $_.i = _2u; //#13522
            var _2z = $get($_.msg, $_.i); //#13523
            $k[$j++] = $_.text; //#13523
            $k[$j++] = $_.i; //#13523
            $k[$j++] = _2z; //#13523
            if (_2z < 0) { //#13523
                $j--; //#13523
                $k[$j++] = 32; //#13523
            } //#13523
            var _30 = $k[--$j]; //#13523
            var _31 = $k[--$j]; //#13523
            $put($k[--$j], _31, _30); //#13523
        } //#13523
        $k[$j++] = Infinity; //#13527
        for (var _34 = 0, _35 = $_.msglen; _34 < _35; _34++) { //#13527
            $k[$j++] = 0; //#13527
        } //#13527
        $k[$j++] = 0; //#13527
        $_.numSA = $a(); //#13527
        $k[$j++] = Infinity; //#13528
        for (var _38 = 0, _39 = $_.msglen; _38 < _39; _38++) { //#13528
            $k[$j++] = 0; //#13528
        } //#13528
        $k[$j++] = 0; //#13528
        $_.numEA = $a(); //#13528
        for (var _3C = $_.msglen - 1; _3C >= 0; _3C -= 1) { //#13538
            $_.i = _3C; //#13530
            if ($get($_.msg, $_.i) >= 0) { //#13537
                if ($get($_.msg, $_.i) >= 128) { //#13535
                    $put($_.numEA, $_.i, $f($get($_.numEA, $_.i + 1) + 1)); //#13533
                } else { //#13535
                    $put($_.numSA, $_.i, $f($get($_.numSA, $_.i + 1) + 1)); //#13535
                } //#13535
            } //#13535
        } //#13535
        $_.ea = false; //#13541
        $_.msgtmp = $a([]); //#13541
        for (var _3W = 0, _3V = $_.msglen - 1; _3W <= _3V; _3W += 1) { //#13556
            $_.i = _3W; //#13543
            $_.c = $get($_.msg, $_.i); //#13544
            if ((!$xo($_.ea, $_.c < 128)) && ($_.c >= 0)) { //#13554
                if ($_.ea) { //#13546
                    $k[$j++] = $_.numSA; //#13546
                } else { //#13546
                    $k[$j++] = $_.numEA; //#13546
                } //#13546
                var _3i = $get($k[--$j], $_.i); //#13546
                var _3l = ($f(_3i + $_.i) == $_.msglen) ? 3 : 5; //#13547
                if (_3i < _3l) { //#13552
                    $k[$j++] = Infinity; //#13549
                    $aload($_.msgtmp); //#13549
                    $k[$j++] = $_.fn4; //#13549
                    $_.msgtmp = $a(); //#13549
                } else { //#13552
                    $k[$j++] = Infinity; //#13551
                    $aload($_.msgtmp); //#13551
                    $k[$j++] = $_.fn4; //#13551
                    $k[$j++] = $_.fn4; //#13551
                    $_.msgtmp = $a(); //#13551
                    $_.ea = !$_.ea; //#13552
                } //#13552
            } //#13552
            $k[$j++] = Infinity; //#13555
            $aload($_.msgtmp); //#13555
            if ($_.c >= 0) { //#13555
                $k[$j++] = $_.c & 127; //#13555
            } else { //#13555
                $k[$j++] = $_.c; //#13555
            } //#13555
            $_.msgtmp = $a(); //#13555
        } //#13555
        $_.msg = $_.msgtmp; //#13557
        $_.msglen = $_.msg.length; //#13558
        $_.enc = function() {
            var _41 = $k[--$j]; //#13562
            $put($_.cws, $_.j, $get(_41, $k[--$j])); //#13562
            $_.j = $_.j + 1; //#13563
        }; //#13563
        $_.cws = $a($_.msglen * 2); //#13566
        $_.i = 0; //#13567
        $_.j = 0; //#13567
        $_.cset = "set0"; //#13567
        for (;;) { //#13617
            if ($_.i == $_.msglen) { //#13569
                break; //#13569
            } //#13569
            for (;;) { //#13615
                $_.char1 = $get($_.msg, $_.i); //#13574
                $k[$j++] = 'char2'; //#13575
                if (($_.i + 1) < $_.msglen) { //#13575
                    $k[$j++] = $get($_.msg, $_.i + 1); //#13575
                } else { //#13575
                    $k[$j++] = -99; //#13575
                } //#13575
                var _4J = $k[--$j]; //#13575
                $_[$k[--$j]] = _4J; //#13575
                var _4O = $get($_[$_.cset], $_.char1) !== undefined; //#13578
                if (_4O) { //#13582
                    $k[$j++] = $_.char1; //#13579
                    $k[$j++] = $_[$_.cset]; //#13579
                    $_.enc(); //#13579
                    $_.i = $_.i + 1; //#13580
                    break; //#13581
                } //#13581
                var _4V = $get($_.set2, $_.char1) !== undefined; //#13585
                if (_4V) { //#13590
                    $k[$j++] = $_.sf2; //#13586
                    $k[$j++] = $_[$_.cset]; //#13586
                    $_.enc(); //#13586
                    $k[$j++] = $_.char1; //#13587
                    $k[$j++] = $_.set2; //#13587
                    $_.enc(); //#13587
                    $_.i = $_.i + 1; //#13588
                    break; //#13589
                } //#13589
                var _4f = $get($_[$_.cset], $_.char2) !== undefined; //#13593
                if (!_4f) { //#13611
                    if ($eq($_.cset, "set0")) { //#13599
                        $k[$j++] = $_.la1; //#13595
                        $k[$j++] = $_[$_.cset]; //#13595
                        $_.enc(); //#13595
                        $_.cset = "set1"; //#13596
                    } else { //#13599
                        $k[$j++] = $_.la0; //#13598
                        $k[$j++] = $_[$_.cset]; //#13598
                        $_.enc(); //#13598
                        $_.cset = "set0"; //#13599
                    } //#13599
                    break; //#13601
                } else { //#13611
                    if ($eq($_.cset, "set0")) { //#13608
                        $k[$j++] = $_.sf1; //#13604
                        $k[$j++] = $_[$_.cset]; //#13604
                        $_.enc(); //#13604
                        $k[$j++] = $_.char1; //#13605
                        $k[$j++] = $_.set1; //#13605
                        $_.enc(); //#13605
                    } else { //#13608
                        $k[$j++] = $_.sf0; //#13607
                        $k[$j++] = $_[$_.cset]; //#13607
                        $_.enc(); //#13607
                        $k[$j++] = $_.char1; //#13608
                        $k[$j++] = $_.set0; //#13608
                        $_.enc(); //#13608
                    } //#13608
                    $_.i = $_.i + 1; //#13610
                    break; //#13611
                } //#13611
                break; //#13614
            } //#13614
        } //#13614
        $_.cws = $geti($_.cws, 0, $_.j); //#13618
    } //#13618
    if (!bwipp_posicode.__13669__) { //#13669
        $_ = Object.create($_); //#13669
        var _56 = new Map([
            ["a", $a(["141112", "131212", "121312", "111412", "131113", "121213", "111313", "121114", "111214", "111115", "181111", "171211", "161311", "151411", "141511", "131611", "121711", "111811", "171112", "161212", "151312", "141412", "131512", "121612", "111712", "161113", "151213", "141313", "131413", "121513", "111613", "151114", "141214", "131314", "121414", "111514", "141115", "131215", "121315", "111415", "131116", "121216", "111316", "121117", "111217", "111118", "1<111112", "111111111;1"])],
            ["b", $a(["151213", "141313", "131413", "121513", "141214", "131314", "121414", "131215", "121315", "121216", "191212", "181312", "171412", "161512", "151612", "141712", "131812", "121912", "181213", "171313", "161413", "151513", "141613", "131713", "121813", "171214", "161314", "151414", "141514", "131614", "121714", "161215", "151315", "141415", "131515", "121615", "151216", "141316", "131416", "121516", "141217", "131317", "121417", "131218", "121318", "121219", "1<121312", "121212121<1"])],
            ["limiteda", $a(["111411", "111312", "111213", "111114", "121311", "121212", "121113", "141111", "131211", "131112", "171111", "161211", "151311", "141411", "131511", "121611", "111711", "161112", "151212", "141312", "131412", "121512", "111612", "151113", "141213", "131313", "121413", "111513", "141114", "131214", "121314", "111414", "131115", "121215", "111315", "121116", "111216", "111117", "151111", "1"])],
            ["limitedb", $a(["121512", "121413", "121314", "121215", "131412", "131313", "131214", "151212", "141312", "141213", "181212", "171312", "161412", "151512", "141612", "131712", "121812", "171213", "161313", "151413", "141513", "131613", "121713", "161214", "151314", "141414", "131514", "121614", "151215", "141315", "131415", "121515", "141216", "131316", "121416", "131217", "121317", "121218", "141212", "1"])]
        ]); //#13666
        $_.encmaps = _56; //#13668
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_posicode.$ctx[id] = $_[id]); //#13668
        bwipp_posicode.__13669__ = 1; //#13668
        $_ = Object.getPrototypeOf($_); //#13668
    } //#13668
    $_.encs = $get($_.encmaps, $_.version); //#13670
    if (!bwipp_posicode.__13680__) { //#13680
        $_ = Object.create($_); //#13680
        $_.c2w = $a([$a([495, 330, 210, 126, 70, 35, 15, 5]), $a([165, 120, 84, 56, 35, 20, 10, 4]), $a([45, 36, 28, 21, 15, 10, 6, 3]), $a([9, 8, 7, 6, 5, 4, 3, 2]), $a([1, 1, 1, 1, 1, 1, 1, 1])]); //#13679
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_posicode.$ctx[id] = $_[id]); //#13679
        bwipp_posicode.__13680__ = 1; //#13679
        $_ = Object.getPrototypeOf($_); //#13679
    } //#13679
    $_.v = 0; //#13681
    var _5I = $_.cws; //#13682
    for (var _5J = 0, _5K = _5I.length; _5J < _5K; _5J++) { //#13691
        $_.cw = $get(_5I, _5J); //#13683
        for (var _5M = 0, _5N = 6; _5M < _5N; _5M++) { //#13690
            if ((($_.cw ^ $_.v) & 1) != 0) { //#13687
                $_.v = $_.v ^ 7682; //#13686
            } //#13686
            $_.v = $_.v >>> 1; //#13688
            $_.cw = $_.cw >>> 1; //#13689
        } //#13689
    } //#13689
    $_.v = $_.v + $_.checkoffset; //#13692
    if ($eq($_.version, "limiteda") || $eq($_.version, "limitedb")) { //#13700
        $_.v = $_.v & 1023; //#13695
        if (($_.v > 824) && ($_.v < 853)) { //#13698
            $_.v = $_.v + 292; //#13697
        } //#13697
    } else { //#13700
        $_.v = ($_.v & 1023) + 45; //#13700
    } //#13700
    $_.d = $a([2, 2, 2, 2, 2, 2]); //#13703
    $_.r = 0; //#13704
    $_.c = 0; //#13704
    $_.w = 0; //#13704
    $_.sum = 0; //#13704
    for (;;) { //#13723
        if ($_.sum == $_.v) { //#13706
            break; //#13706
        } //#13706
        $_.t = $f($_.sum + $get($get($_.c2w, $_.r), $_.c)); //#13707
        if ($_.t == $_.v) { //#13712
            $_.w = $_.w + 1; //#13709
            $put($_.d, $_.r, $_.w + 2); //#13710
            $_.sum = $_.t; //#13711
        } //#13711
        if ($_.t > $_.v) { //#13717
            $put($_.d, $_.r, $_.w + 2); //#13714
            $_.r = $_.r + 1; //#13715
            $_.w = 0; //#13716
        } //#13716
        if ($_.t < $_.v) { //#13722
            $_.c = $_.c + 1; //#13719
            $_.w = $_.w + 1; //#13720
            $_.sum = $_.t; //#13721
        } //#13721
    } //#13721
    $k[$j++] = 20; //#13724
    for (var _63 = 0; _63 <= 4; _63 += 1) { //#13724
        var _66 = $k[--$j]; //#13724
        $k[$j++] = $f(_66 - $get($_.d, _63)); //#13724
    } //#13724
    $put($_.d, 5, $k[--$j]); //#13725
    if ($eq($_.version, "b") || $eq($_.version, "limitedb")) { //#13728
        $k[$j++] = Infinity; //#13727
        var _6B = $_.d; //#13727
        for (var _6C = 0, _6D = _6B.length; _6C < _6D; _6C++) { //#13727
            $k[$j++] = $f($get(_6B, _6C) + 1); //#13727
        } //#13727
        $_.d = $a(); //#13727
    } //#13727
    $_.cbs = $strcpy($s(12), "111111111111"); //#13729
    for (var _6I = 5; _6I >= 0; _6I -= 1) { //#13733
        $_.i = _6I; //#13731
        $put($_.cbs, ((5 - $_.i) * 2) + 1, $f($get($_.d, $_.i) + 47)); //#13732
    } //#13732
    $_.sbs = $s(($_.cws.length * 6) + 31); //#13736
    var _6S = $get($_.encs, $_.encs.length - 2); //#13737
    $puti($_.sbs, 0, _6S); //#13738
    $_.j = _6S.length; //#13739
    for (var _6W = 0, _6V = $_.cws.length - 1; _6W <= _6V; _6W += 1) { //#13744
        $_.i = _6W; //#13741
        $puti($_.sbs, $_.j, $get($_.encs, $get($_.cws, $_.i))); //#13742
        $_.j = $_.j + 6; //#13743
    } //#13743
    $puti($_.sbs, $_.j, $_.cbs); //#13745
    $_.j = $_.j + 12; //#13746
    var _6l = $get($_.encs, $_.encs.length - 1); //#13747
    $puti($_.sbs, $_.j, _6l); //#13748
    $_.j = _6l.length + $_.j; //#13749
    $_.sbs = $geti($_.sbs, 0, $_.j); //#13750
    $k[$j++] = Infinity; //#13753
    $k[$j++] = Infinity; //#13755
    var _6s = $_.sbs; //#13755
    for (var _6t = 0, _6u = _6s.length; _6t < _6u; _6t++) { //#13755
        $k[$j++] = $f($get(_6s, _6t) - 48); //#13755
    } //#13755
    var _6w = $a(); //#13755
    $k[$j++] = Infinity; //#13756
    for (var _6y = 0, _6z = ~~(($_.sbs.length + 1) / 2); _6y < _6z; _6y++) { //#13756
        $k[$j++] = $_.height; //#13756
    } //#13756
    var _71 = $a(); //#13756
    $k[$j++] = Infinity; //#13757
    for (var _73 = 0, _74 = ~~(($_.sbs.length + 1) / 2); _73 < _74; _73++) { //#13757
        $k[$j++] = 0; //#13757
    } //#13757
    var _75 = $a(); //#13757
    var _7D = new Map([
        ["a", 0],
        ["b", 0],
        ["limiteda", 12],
        ["limitedb", 13]
    ]); //#13760
    var _7G = new Map([
        ["a", 0],
        ["b", 0],
        ["limiteda", 12],
        ["limitedb", 13]
    ]); //#13761
    $k[$j++] = 'ren'; //#13762
    $k[$j++] = 'renlinear'; //#13762
    $k[$j++] = 'sbs'; //#13762
    $k[$j++] = _6w; //#13762
    $k[$j++] = 'bhs'; //#13762
    $k[$j++] = _71; //#13762
    $k[$j++] = 'bbs'; //#13762
    $k[$j++] = _75; //#13762
    $k[$j++] = 'txt'; //#13762
    $k[$j++] = $a([$a([$_.text, $_.textxoffset, $_.textyoffset, $_.textfont, $_.textsize])]); //#13762
    $k[$j++] = 'textxalign'; //#13762
    $k[$j++] = "center"; //#13762
    $k[$j++] = 'borderleft'; //#13762
    $k[$j++] = $get(_7D, $_.version); //#13762
    $k[$j++] = 'borderright'; //#13762
    $k[$j++] = $get(_7G, $_.version); //#13762
    $k[$j++] = 'opt'; //#13762
    $k[$j++] = $_.options; //#13762
    var _7K = $d(); //#13762
    $k[$j++] = _7K; //#13765
    if (!$_.dontdraw) { //#13765
        bwipp_renlinear(); //#13765
    } //#13765
    $_ = Object.getPrototypeOf($_); //#13767
    $_ = Object.getPrototypeOf($_); //#13769
} //bwipp_posicode
function bwipp_codablockf() {
    $_ = Object.create($_); //#13800
    $_.dontdraw = false; //#13803
    $_.rows = -1; //#13804
    $_.columns = 8; //#13805
    $_.rowheight = 10; //#13806
    $_.sepheight = 1; //#13807
    $_.parse = false; //#13808
    $_.parsefnc = false; //#13809
    $k[$j++] = $_; //#13811
    bwipp_processoptions(); //#13811
    $_.options = $k[--$j]; //#13811
    $_.barcode = $k[--$j]; //#13812
    if (($_.columns < 4) || ($_.columns > 62)) { //#13816
        $k[$j++] = 'bwipp.codablockfBadColumns#13815'; //#13815
        $k[$j++] = "Codablock F must have 4 to 62 columns"; //#13815
        bwipp_raiseerror(); //#13815
    } //#13815
    if (($_.rows != -1) && (($_.rows < 2) || ($_.rows > 44))) { //#13820
        $k[$j++] = 'bwipp.codablockfBadRows#13819'; //#13819
        $k[$j++] = "Codablock F must have 2 to 44 rows"; //#13819
        bwipp_raiseerror(); //#13819
    } //#13819
    if ($_.rowheight < 8) { //#13824
        $k[$j++] = 'bwipp.codablockfBadRowHeight#13823'; //#13823
        $k[$j++] = "Codablock F must have rowheight of at least 8"; //#13823
        bwipp_raiseerror(); //#13823
    } //#13823
    if ($_.sepheight < 1) { //#13828
        $k[$j++] = 'bwipp.codablockfBadSepHeight#13827'; //#13827
        $k[$j++] = "Codablock F must have sepheight of at least 1"; //#13827
        bwipp_raiseerror(); //#13827
    } //#13827
    bwipp_loadctx(bwipp_codablockf) //#13830
    $k[$j++] = 'c'; //#13832
    if (($_.columns >= 4) && ($_.columns <= 62)) { //#13832
        $k[$j++] = $_.columns; //#13832
    } else { //#13832
        $k[$j++] = 8; //#13832
    } //#13832
    var _C = $k[--$j]; //#13832
    $_[$k[--$j]] = _C; //#13832
    $k[$j++] = 'rows'; //#13833
    if (($_.rows >= 2) && ($_.rows <= 44)) { //#13833
        $k[$j++] = $_.rows; //#13833
    } else { //#13833
        $k[$j++] = -1; //#13833
    } //#13833
    var _H = $k[--$j]; //#13833
    $_[$k[--$j]] = _H; //#13833
    $_.swa = -1; //#13836
    $_.swb = -2; //#13836
    $_.swc = -3; //#13836
    $_.sft = -4; //#13836
    $_.fn1 = -5; //#13837
    $_.fn2 = -6; //#13837
    $_.fn3 = -7; //#13837
    $_.fn4 = -8; //#13837
    $_.sta = -9; //#13838
    $_.stp = -10; //#13838
    var _N = new Map([
        ["parse", $_.parse],
        ["parsefnc", $_.parsefnc],
        ["FNC1", $_.fn1],
        ["FNC3", $_.fn3]
    ]); //#13846
    $_.fncvals = _N; //#13848
    $k[$j++] = 'msg'; //#13849
    $k[$j++] = $_.barcode; //#13849
    $k[$j++] = $_.fncvals; //#13849
    bwipp_parseinput(); //#13849
    var _Q = $k[--$j]; //#13849
    $_[$k[--$j]] = _Q; //#13849
    $_.msglen = $_.msg.length; //#13850
    $_.msgtmp = $a([]); //#13853
    var _U = $_.msg; //#13854
    for (var _V = 0, _W = _U.length; _V < _W; _V++) { //#13857
        $_.char = $get(_U, _V); //#13855
        $k[$j++] = Infinity; //#13856
        $aload($_.msgtmp); //#13856
        if ($_.char < 128) { //#13856
            $k[$j++] = $_.char; //#13856
        } else { //#13856
            $k[$j++] = $_.fn4; //#13856
            $k[$j++] = $_.char & 127; //#13856
        } //#13856
        $_.msgtmp = $a(); //#13856
    } //#13856
    $_.kmsg = $_.msg; //#13858
    $_.msg = $_.msgtmp; //#13859
    $_.msglen = $_.msg.length; //#13860
    if (!bwipp_codablockf.__13917__) { //#13917
        $_ = Object.create($_); //#13917
        $_.charmaps = $a([$a([32, 32, "00"]), $a(["!", "!", "01"]), $a(["\"", "\"", "02"]), $a(["#", "#", "03"]), $a(["$", "$", "04"]), $a(["%", "%", "05"]), $a(["&", "&", "06"]), $a(["'", "'", "07"]), $a([40, 40, "08"]), $a([41, 41, "09"]), $a(["*", "*", "10"]), $a(["+", "+", "11"]), $a([",", ",", "12"]), $a(["-", "-", "13"]), $a([".", ".", "14"]), $a(["/", "/", "15"]), $a(["0", "0", "16"]), $a(["1", "1", "17"]), $a(["2", "2", "18"]), $a(["3", "3", "19"]), $a(["4", "4", "20"]), $a(["5", "5", "21"]), $a(["6", "6", "22"]), $a(["7", "7", "23"]), $a(["8", "8", "24"]), $a(["9", "9", "25"]), $a([":", ":", "26"]), $a([";", ";", "27"]), $a(["<", "<", "28"]), $a(["=", "=", "29"]), $a([">", ">", "30"]), $a(["?", "?", "31"]), $a(["@", "@", "32"]), $a(["A", "A", "33"]), $a(["B", "B", "34"]), $a(["C", "C", "35"]), $a(["D", "D", "36"]), $a(["E", "E", "37"]), $a(["F", "F", "38"]), $a(["G", "G", "39"]), $a(["H", "H", "40"]), $a(["I", "I", "41"]), $a(["J", "J", "42"]), $a(["K", "K", "43"]), $a(["L", "L", "44"]), $a(["M", "M", "45"]), $a(["N", "N", "46"]), $a(["O", "O", "47"]), $a(["P", "P", "48"]), $a(["Q", "Q", "49"]), $a(["R", "R", "50"]), $a(["S", "S", "51"]), $a(["T", "T", "52"]), $a(["U", "U", "53"]), $a(["V", "V", "54"]), $a(["W", "W", "55"]), $a(["X", "X", "56"]), $a(["Y", "Y", "57"]), $a(["Z", "Z", "58"]), $a(["[", "[", "59"]), $a([92, 92, "60"]), $a(["]", "]", "61"]), $a(["^", "^", "62"]), $a(["_", "_", "63"]), $a([0, "`", "64"]), $a([1, "a", "65"]), $a([2, "b", "66"]), $a([3, "c", "67"]), $a([4, "d", "68"]), $a([5, "e", "69"]), $a([6, "f", "70"]), $a([7, "g", "71"]), $a([8, "h", "72"]), $a([9, "i", "73"]), $a([10, "j", "74"]), $a([11, "k", "75"]), $a([12, "l", "76"]), $a([13, "m", "77"]), $a([14, "n", "78"]), $a([15, "o", "79"]), $a([16, "p", "80"]), $a([17, "q", "81"]), $a([18, "r", "82"]), $a([19, "s", "83"]), $a([20, "t", "84"]), $a([21, "u", "85"]), $a([22, "v", "86"]), $a([23, "w", "87"]), $a([24, "x", "88"]), $a([25, "y", "89"]), $a([26, "z", "90"]), $a([27, "{", "91"]), $a([28, "|", "92"]), $a([29, "}", "93"]), $a([30, "~", "94"]), $a([31, 127, "95"]), $a([$_.fn3, $_.fn3, "96"]), $a([$_.fn2, $_.fn2, "97"]), $a([$_.sft, $_.sft, "98"]), $a([$_.swc, $_.swc, "99"]), $a([$_.swb, $_.fn4, $_.swb]), $a([$_.fn4, $_.swa, $_.swa]), $a([$_.fn1, $_.fn1, $_.fn1]), $a([$_.sta, $_.sta, $_.sta]), $a([$_.stp, $_.stp, $_.stp])]); //#13901
        $_.charvals = $a([new Map, new Map, new Map]); //#13904
        for (var _2p = 0, _2o = $_.charmaps.length - 1; _2p <= _2o; _2p += 1) { //#13913
            $_.i = _2p; //#13906
            $_.encs = $get($_.charmaps, $_.i); //#13907
            for (var _2t = 0; _2t <= 2; _2t += 1) { //#13912
                $_.j = _2t; //#13909
                var _2w = $get($_.encs, $_.j); //#13910
                $k[$j++] = _2w; //#13910
                if ($eq($type(_2w), 'stringtype')) { //#13910
                    var _2z = $get($k[--$j], 0); //#13910
                    $k[$j++] = _2z; //#13910
                } //#13910
                $put($get($_.charvals, $_.j), $k[--$j], $_.i); //#13911
            } //#13911
        } //#13911
        $_.seta = $get($_.charvals, 0); //#13914
        $_.setb = $get($_.charvals, 1); //#13915
        $_.setc = $get($_.charvals, 2); //#13916
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_codablockf.$ctx[id] = $_[id]); //#13916
        bwipp_codablockf.__13917__ = 1; //#13916
        $_ = Object.getPrototypeOf($_); //#13916
    } //#13916
    $_.numsscr = function() {
        $_.n = 0; //#13921
        $_.s = 0; //#13921
        $_.p = $k[--$j]; //#13922
        for (;;) { //#13933
            if ($_.p >= $_.msglen) { //#13923
                break; //#13923
            } //#13923
            var _3H = $get($_.msg, $_.p); //#13924
            var _3J = $get($_.setc, _3H) !== undefined; //#13925
            $k[$j++] = _3H; //#13925
            if (!_3J) { //#13925
                $j--; //#13925
                break; //#13925
            } //#13925
            if ($k[--$j] == $_.fn1) { //#13929
                if (($_.s % 2) == 0) { //#13928
                    $_.s = $_.s + 1; //#13928
                } else { //#13928
                    break; //#13928
                } //#13928
            } //#13928
            $_.n = $_.n + 1; //#13930
            $_.s = $_.s + 1; //#13931
            $_.p = $f($_.p + 1); //#13932
        } //#13932
        $k[$j++] = $_.n; //#13934
        $k[$j++] = $_.s; //#13934
    }; //#13934
    $_.enca = function() {
        $put($_.cws, $_.j, $get($_.seta, $k[--$j])); //#13939
        $_.j = $_.j + 1; //#13940
    }; //#13940
    $_.encb = function() {
        $put($_.cws, $_.j, $get($_.setb, $k[--$j])); //#13943
        $_.j = $_.j + 1; //#13944
    }; //#13944
    $_.encc = function() {
        var _3f = $k[--$j]; //#13947
        $k[$j++] = _3f; //#13951
        if ($ne($type(_3f), 'arraytype')) { //#13950
            var _3j = $get($_.setc, $k[--$j]); //#13948
            $k[$j++] = _3j; //#13948
        } else { //#13950
            $aload($k[--$j]); //#13950
            var _3l = $k[--$j]; //#13950
            var _3m = $k[--$j]; //#13950
            $k[$j++] = $f($f(_3l - 48) + ($f(_3m - 48) * 10)); //#13950
        } //#13950
        $put($_.cws, $_.j, $k[--$j]); //#13952
        $_.j = $_.j + 1; //#13953
    }; //#13953
    $_.anotb = function() {
        var _3r = $k[--$j]; //#13957
        var _3t = $get($_.seta, _3r) !== undefined; //#13957
        var _3v = $get($_.setb, _3r) !== undefined; //#13957
        $k[$j++] = _3t && (!_3v); //#13957
    }; //#13957
    $_.bnota = function() {
        var _3w = $k[--$j]; //#13958
        var _3y = $get($_.setb, _3w) !== undefined; //#13958
        var _40 = $get($_.seta, _3w) !== undefined; //#13958
        $k[$j++] = _3y && (!_40); //#13958
    }; //#13958
    $k[$j++] = Infinity; //#13961
    for (var _42 = 0, _43 = $_.msg.length; _42 < _43; _42++) { //#13961
        $k[$j++] = 0; //#13961
    } //#13961
    $k[$j++] = 9999; //#13961
    $_.nextanotb = $a(); //#13961
    $k[$j++] = Infinity; //#13962
    for (var _46 = 0, _47 = $_.msg.length; _46 < _47; _46++) { //#13962
        $k[$j++] = 0; //#13962
    } //#13962
    $k[$j++] = 9999; //#13962
    $_.nextbnota = $a(); //#13962
    for (var _4A = $_.msg.length - 1; _4A >= 0; _4A -= 1) { //#13975
        $_.i = _4A; //#13964
        $k[$j++] = $get($_.msg, $_.i); //#13965
        $_.anotb(); //#13965
        if ($k[--$j]) { //#13968
            $put($_.nextanotb, $_.i, 0); //#13966
        } else { //#13968
            $put($_.nextanotb, $_.i, $f($get($_.nextanotb, $_.i + 1) + 1)); //#13968
        } //#13968
        $k[$j++] = $get($_.msg, $_.i); //#13970
        $_.bnota(); //#13970
        if ($k[--$j]) { //#13973
            $put($_.nextbnota, $_.i, 0); //#13971
        } else { //#13973
            $put($_.nextbnota, $_.i, $f($get($_.nextbnota, $_.i + 1) + 1)); //#13973
        } //#13973
    } //#13973
    $_.abeforeb = function() {
        var _4X = $k[--$j]; //#13978
        $k[$j++] = $lt($get($_.nextanotb, _4X), $get($_.nextbnota, _4X)); //#13978
    }; //#13978
    $_.bbeforea = function() {
        var _4c = $k[--$j]; //#13979
        $k[$j++] = $lt($get($_.nextbnota, _4c), $get($_.nextanotb, _4c)); //#13979
    }; //#13979
    $_.padrow = function() {
        for (var _4i = 0, _4j = $k[--$j]; _4i < _4j; _4i++) { //#13989
            for (;;) { //#13988
                if ($eq($_.cset, "seta")) { //#13985
                    $k[$j++] = $_.swc; //#13985
                    $_.enca(); //#13985
                    $_.cset = "setc"; //#13985
                    break; //#13985
                } //#13985
                if ($eq($_.cset, "setb")) { //#13986
                    $k[$j++] = $_.swc; //#13986
                    $_.encb(); //#13986
                    $_.cset = "setc"; //#13986
                    break; //#13986
                } //#13986
                if ($eq($_.cset, "setc")) { //#13987
                    $k[$j++] = $_.swb; //#13987
                    $_.encc(); //#13987
                    $_.cset = "setb"; //#13987
                    break; //#13987
                } //#13987
            } //#13987
        } //#13987
    }; //#13987
    $_.encafitsrow = function() {
        if (($_.rem <= 2) && ($get($_.msg, $_.i) == $_.fn4)) { //#14004
            var _4z = ($_.rem == 2) && ($get($_.msg, $_.i + 1) <= 95); //#13996
            $k[$j++] = _4z; //#14000
            if (_4z) { //#14000
                $k[$j++] = $_.fn4; //#13997
                $_.enca(); //#13997
                $k[$j++] = $get($_.msg, $_.i + 1); //#13998
                $_.enca(); //#13998
                $_.i = $_.i + 2; //#13999
            } //#13999
        } else { //#14004
            $k[$j++] = $get($_.msg, $_.i); //#14002
            $_.enca(); //#14002
            $_.i = $_.i + 1; //#14003
            $k[$j++] = true; //#14004
        } //#14004
    }; //#14004
    $_.encbfitsrow = function() {
        if (($_.rem <= 2) && ($get($_.msg, $_.i) == $_.fn4)) { //#14020
            var _5I = ($_.rem == 2) && ($get($_.msg, $_.i + 1) >= 32); //#14012
            $k[$j++] = _5I; //#14016
            if (_5I) { //#14016
                $k[$j++] = $_.fn4; //#14013
                $_.encb(); //#14013
                $k[$j++] = $get($_.msg, $_.i + 1); //#14014
                $_.encb(); //#14014
                $_.i = $_.i + 2; //#14015
            } //#14015
        } else { //#14020
            $k[$j++] = $get($_.msg, $_.i); //#14018
            $_.encb(); //#14018
            $_.i = $_.i + 1; //#14019
            $k[$j++] = true; //#14020
        } //#14020
    }; //#14020
    $_.cws = $a($f($_.c + 5) * 44); //#14025
    $_.i = 0; //#14027
    $_.j = 0; //#14027
    $_.r = 1; //#14027
    $_.lastrow = false; //#14028
    for (;;) { //#14195
        if ($_.lastrow) { //#14030
            break; //#14030
        } //#14030
        if ($_.r > 44) { //#14034
            $k[$j++] = 'bwipp.codablockfTooBig#14033'; //#14033
            $k[$j++] = "Maximum length exceeded"; //#14033
            bwipp_raiseerror(); //#14033
        } //#14033
        $k[$j++] = $_.sta; //#14037
        $_.enca(); //#14037
        if ($_.i < $_.msglen) { //#14038
            $k[$j++] = $_.i; //#14038
            $_.numsscr(); //#14038
        } else { //#14038
            $k[$j++] = -1; //#14038
            $k[$j++] = -1; //#14038
        } //#14038
        $_.nums = $k[--$j]; //#14038
        $_.nchars = $k[--$j]; //#14038
        for (;;) { //#14058
            if ($_.msglen == 0) { //#14044
                $k[$j++] = $_.swb; //#14041
                $_.enca(); //#14041
                $_.cset = "setb"; //#14042
                break; //#14043
            } //#14043
            if ($_.nums >= 2) { //#14049
                $k[$j++] = $_.swc; //#14046
                $_.enca(); //#14046
                $_.cset = "setc"; //#14047
                break; //#14048
            } //#14048
            $k[$j++] = $_.i; //#14050
            $_.abeforeb(); //#14050
            if ($k[--$j]) { //#14054
                $k[$j++] = $_.sft; //#14051
                $_.enca(); //#14051
                $_.cset = "seta"; //#14052
                break; //#14053
            } //#14053
            $k[$j++] = $_.swb; //#14055
            $_.enca(); //#14055
            $_.cset = "setb"; //#14056
            break; //#14057
        } //#14057
        $_.j = $_.j + 1; //#14059
        $_.endofrow = false; //#14062
        for (;;) { //#14180
            $_.rem = $f($f($_.c + 3) - ($_.j % $f($_.c + 5))); //#14063
            if (($_.i == $_.msglen) || $_.endofrow) { //#14065
                break; //#14065
            } //#14065
            $k[$j++] = $_.i; //#14067
            $_.numsscr(); //#14067
            $_.nums = $k[--$j]; //#14067
            $_.nchars = $k[--$j]; //#14067
            $k[$j++] = 'remnums'; //#14068
            if ($_.nums > ($_.rem * 2)) { //#14068
                $k[$j++] = $_.rem * 2; //#14068
            } else { //#14068
                $k[$j++] = $_.nums; //#14068
            } //#14068
            var _5y = $k[--$j]; //#14068
            $_[$k[--$j]] = _5y; //#14068
            for (;;) { //#14178
                if ((($eq($_.cset, "seta") || $eq($_.cset, "setb")) && ($_.remnums >= 4)) && ($get($_.msg, $_.i) != $_.fn1)) { //#14106
                    if ((($_.remnums % 2) == 0) && ($_.rem >= 3)) { //#14088
                        $k[$j++] = $_.swc; //#14076
                        if ($eq($_.cset, "seta")) { //#14076
                            $_.enca(); //#14076
                        } else { //#14076
                            $_.encb(); //#14076
                        } //#14076
                        $_.cset = "setc"; //#14077
                        for (var _6B = 0, _6C = 2; _6B < _6C; _6B++) { //#14086
                            if ($get($_.msg, $_.i) == $_.fn1) { //#14084
                                $k[$j++] = $_.fn1; //#14080
                                $_.encc(); //#14080
                                $_.i = $_.i + 1; //#14081
                            } else { //#14084
                                $k[$j++] = $geti($_.msg, $_.i, 2); //#14083
                                $_.encc(); //#14083
                                $_.i = $_.i + 2; //#14084
                            } //#14084
                        } //#14084
                        break; //#14087
                    } //#14087
                    if ((($_.remnums % 2) != 0) && ($_.rem >= 4)) { //#14105
                        $k[$j++] = $get($_.msg, $_.i); //#14091
                        if ($eq($_.cset, "seta")) { //#14091
                            $_.enca(); //#14091
                        } else { //#14091
                            $_.encb(); //#14091
                        } //#14091
                        $_.i = $_.i + 1; //#14092
                        $k[$j++] = $_.swc; //#14093
                        if ($eq($_.cset, "seta")) { //#14093
                            $_.enca(); //#14093
                        } else { //#14093
                            $_.encb(); //#14093
                        } //#14093
                        $_.cset = "setc"; //#14094
                        for (var _6W = 0, _6X = 2; _6W < _6X; _6W++) { //#14103
                            if ($get($_.msg, $_.i) == $_.fn1) { //#14101
                                $k[$j++] = $_.fn1; //#14097
                                $_.encc(); //#14097
                                $_.i = $_.i + 1; //#14098
                            } else { //#14101
                                $k[$j++] = $geti($_.msg, $_.i, 2); //#14100
                                $_.encc(); //#14100
                                $_.i = $_.i + 2; //#14101
                            } //#14101
                        } //#14101
                        break; //#14104
                    } //#14104
                } //#14104
                $k[$j++] = $eq($_.cset, "setb"); //#14107
                $k[$j++] = $get($_.msg, $_.i); //#14107
                $_.anotb(); //#14107
                var _6m = $k[--$j]; //#14107
                var _6n = $k[--$j]; //#14107
                if ((_6n && _6m) && ($_.rem >= 2)) { //#14122
                    if ($_.i < ($_.msglen - 1)) { //#14116
                        $k[$j++] = $_.i + 1; //#14110
                        $_.bbeforea(); //#14110
                        if ($k[--$j]) { //#14115
                            $k[$j++] = $_.sft; //#14111
                            $_.encb(); //#14111
                            $k[$j++] = $get($_.msg, $_.i); //#14112
                            $_.enca(); //#14112
                            $_.i = $_.i + 1; //#14113
                            break; //#14114
                        } //#14114
                    } //#14114
                    $k[$j++] = $_.swa; //#14117
                    $_.encb(); //#14117
                    $_.cset = "seta"; //#14118
                    $k[$j++] = $get($_.msg, $_.i); //#14119
                    $_.enca(); //#14119
                    $_.i = $_.i + 1; //#14120
                    break; //#14121
                } //#14121
                $k[$j++] = $eq($_.cset, "seta"); //#14123
                $k[$j++] = $get($_.msg, $_.i); //#14123
                $_.bnota(); //#14123
                var _77 = $k[--$j]; //#14123
                var _78 = $k[--$j]; //#14123
                if ((_78 && _77) && ($_.rem >= 2)) { //#14138
                    if ($_.i < ($_.msglen - 1)) { //#14132
                        $k[$j++] = $_.i + 1; //#14126
                        $_.abeforeb(); //#14126
                        if ($k[--$j]) { //#14131
                            $k[$j++] = $_.sft; //#14127
                            $_.enca(); //#14127
                            $k[$j++] = $get($_.msg, $_.i); //#14128
                            $_.encb(); //#14128
                            $_.i = $_.i + 1; //#14129
                            break; //#14130
                        } //#14130
                    } //#14130
                    $k[$j++] = $_.swb; //#14133
                    $_.enca(); //#14133
                    $_.cset = "setb"; //#14134
                    $k[$j++] = $get($_.msg, $_.i); //#14135
                    $_.encb(); //#14135
                    $_.i = $_.i + 1; //#14136
                    break; //#14137
                } //#14137
                if (($eq($_.cset, "setc") && ($_.remnums < 2)) && ($_.rem >= 2)) { //#14151
                    $_.rem = $f($_.rem - 1); //#14141
                    $k[$j++] = $_.i; //#14142
                    $_.abeforeb(); //#14142
                    if ($k[--$j]) { //#14149
                        $k[$j++] = $_.swa; //#14143
                        $_.encc(); //#14143
                        $_.cset = "seta"; //#14144
                        $_.encafitsrow(); //#14145
                        if ($k[--$j]) { //#14145
                            break; //#14145
                        } //#14145
                    } else { //#14149
                        $k[$j++] = $_.swb; //#14147
                        $_.encc(); //#14147
                        $_.cset = "setb"; //#14148
                        $_.encbfitsrow(); //#14149
                        if ($k[--$j]) { //#14149
                            break; //#14149
                        } //#14149
                    } //#14149
                } //#14149
                var _7d = $get($_.seta, $get($_.msg, $_.i)) !== undefined; //#14154
                if (($eq($_.cset, "seta") && _7d) && ($_.rem >= 1)) { //#14157
                    $_.encafitsrow(); //#14156
                    if ($k[--$j]) { //#14156
                        break; //#14156
                    } //#14156
                } //#14156
                var _7l = $get($_.setb, $get($_.msg, $_.i)) !== undefined; //#14158
                if (($eq($_.cset, "setb") && _7l) && ($_.rem >= 1)) { //#14161
                    $_.encbfitsrow(); //#14160
                    if ($k[--$j]) { //#14160
                        break; //#14160
                    } //#14160
                } //#14160
                if (($eq($_.cset, "setc") && ($_.remnums >= 2)) && ($_.rem >= 1)) { //#14172
                    if ($get($_.msg, $_.i) == $_.fn1) { //#14169
                        $k[$j++] = $_.fn1; //#14165
                        $_.encc(); //#14165
                        $_.i = $_.i + 1; //#14166
                    } else { //#14169
                        $k[$j++] = $geti($_.msg, $_.i, 2); //#14168
                        $_.encc(); //#14168
                        $_.i = $_.i + 2; //#14169
                    } //#14169
                    break; //#14171
                } //#14171
                $_.endofrow = true; //#14175
                break; //#14176
            } //#14176
        } //#14176
        if ((((($_.r >= $_.rows) || ($_.rows == -1)) && ($_.r > 1)) && ($_.i == $_.msglen)) && ($_.rem >= 2)) { //#14192
            $k[$j++] = $f($_.rem - 2); //#14184
            $_.padrow(); //#14184
            $_.j = $_.j + 3; //#14185
            $k[$j++] = $_.stp; //#14186
            $_.enca(); //#14186
            $_.lastrow = true; //#14187
        } else { //#14192
            $k[$j++] = $_.rem; //#14189
            $_.padrow(); //#14189
            $_.j = $_.j + 1; //#14190
            $k[$j++] = $_.stp; //#14191
            $_.enca(); //#14191
            $_.r = $_.r + 1; //#14192
        } //#14192
    } //#14192
    $_.cws = $geti($_.cws, 0, $_.j); //#14196
    if (!bwipp_codablockf.__14206__) { //#14206
        $_ = Object.create($_); //#14206
        $k[$j++] = Infinity; //#14200
        for (var _8I = 64; _8I <= 95; _8I += 1) { //#14201
            $k[$j++] = _8I; //#14201
        } //#14201
        for (var _8J = 0; _8J <= 15; _8J += 1) { //#14202
            $k[$j++] = _8J; //#14202
        } //#14202
        for (var _8K = 26; _8K <= 63; _8K += 1) { //#14203
            $k[$j++] = _8K; //#14203
        } //#14203
        $_.abmap = $a(); //#14203
        $k[$j++] = Infinity; //#14205
        for (var _8M = 0; _8M <= 85; _8M += 1) { //#14205
            $k[$j++] = _8M; //#14205
        } //#14205
        $_.cmap = $a(); //#14205
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_codablockf.$ctx[id] = $_[id]); //#14205
        bwipp_codablockf.__14206__ = 1; //#14205
        $_ = Object.getPrototypeOf($_); //#14205
    } //#14205
    $_.chkmsg = $a($_.kmsg.length); //#14209
    $_.j = 0; //#14210
    for (var _8T = 0, _8S = $_.kmsg.length - 1; _8T <= _8S; _8T += 1) { //#14216
        $_.i = _8T; //#14212
        $_.char = $get($_.kmsg, $_.i); //#14213
        if ($_.char >= 0) { //#14214
            $put($_.chkmsg, $_.j, $_.char); //#14214
            $_.j = $_.j + 1; //#14214
        } //#14214
        if (($_.char == $_.fn1) && ($_.i != 0)) { //#14215
            $put($_.chkmsg, $_.j, 29); //#14215
            $_.j = $_.j + 1; //#14215
        } //#14215
    } //#14215
    $_.t1 = 0; //#14217
    $_.t2 = 0; //#14217
    $_.k1 = 0; //#14217
    $_.k2 = 0; //#14217
    for (var _8k = 0, _8j = $_.j - 1; _8k <= _8j; _8k += 1) { //#14224
        $_.i = _8k; //#14219
        $_.t1 = ($get($_.chkmsg, $_.i) * $_.i) % 86; //#14220
        $_.t2 = $f($_.t1 + $get($_.chkmsg, $_.i)) % 86; //#14221
        $_.k1 = $f($_.k1 + $_.t2) % 86; //#14222
        $_.k2 = $f($_.k2 + $_.t1) % 86; //#14223
    } //#14223
    $k[$j++] = $_.cws; //#14225
    $k[$j++] = $_.cws.length - 4; //#14225
    if ($ne($_.cset, "setc")) { //#14225
        $k[$j++] = $_.abmap; //#14225
    } else { //#14225
        $k[$j++] = $_.cmap; //#14225
    } //#14225
    var _94 = $get($k[--$j], $_.k1); //#14225
    var _95 = $k[--$j]; //#14225
    $put($k[--$j], _95, _94); //#14225
    $k[$j++] = $_.cws; //#14226
    $k[$j++] = $_.cws.length - 3; //#14226
    if ($ne($_.cset, "setc")) { //#14226
        $k[$j++] = $_.abmap; //#14226
    } else { //#14226
        $k[$j++] = $_.cmap; //#14226
    } //#14226
    var _9E = $get($k[--$j], $_.k2); //#14226
    var _9F = $k[--$j]; //#14226
    $put($k[--$j], _9F, _9E); //#14226
    var _9H = $_.cws; //#14229
    $k[$j++] = _9H; //#14229
    $k[$j++] = 2; //#14229
    if ($get(_9H, 2 - 1) != 99) { //#14229
        $k[$j++] = $_.abmap; //#14229
    } else { //#14229
        $k[$j++] = $_.cmap; //#14229
    } //#14229
    var _9N = $get($k[--$j], $_.r - 2); //#14229
    var _9O = $k[--$j]; //#14229
    $put($k[--$j], _9O, _9N); //#14229
    for (var _9S = 1, _9R = $_.r - 1; _9S <= _9R; _9S += 1) { //#14233
        $_.i = _9S; //#14231
        var _9T = $_.cws; //#14232
        var _9U = $_.i; //#14232
        var _9V = $_.c; //#14232
        $k[$j++] = _9T; //#14232
        $k[$j++] = $f((_9U * $f(_9V + 5)) + 2); //#14232
        if ($get(_9T, $f(($f((_9U * $f(_9V + 5)) + 2)) - 1)) != 99) { //#14232
            $k[$j++] = $_.abmap; //#14232
        } else { //#14232
            $k[$j++] = $_.cmap; //#14232
        } //#14232
        var _9b = $get($k[--$j], $_.i + 42); //#14232
        var _9c = $k[--$j]; //#14232
        $put($k[--$j], _9c, _9b); //#14232
    } //#14232
    for (var _9g = 0, _9f = $_.r - 1; _9g <= _9f; _9g += 1) { //#14244
        $_.rcws = $geti($_.cws, _9g * $f($_.c + 5), $f($_.c + 4)); //#14237
        $_.csum = $get($_.rcws, 0); //#14238
        for (var _9p = 1, _9o = $_.rcws.length - 2; _9p <= _9o; _9p += 1) { //#14242
            $_.i = _9p; //#14240
            $_.csum = $f($_.csum + ($get($_.rcws, $_.i) * $_.i)); //#14241
        } //#14241
        $put($_.rcws, $_.rcws.length - 1, $_.csum % 103); //#14243
    } //#14243
    var _9z = $get($_.options, 'debugcws') !== undefined; //#14246
    if (_9z) { //#14246
        $k[$j++] = 'bwipp.debugcws#14246'; //#14246
        $k[$j++] = $_.cws; //#14246
        bwipp_raiseerror(); //#14246
    } //#14246
    if (!bwipp_codablockf.__14267__) { //#14267
        $_ = Object.create($_); //#14267
        $_.encs = $a(["212222", "222122", "222221", "121223", "121322", "131222", "122213", "122312", "132212", "221213", "221312", "231212", "112232", "122132", "122231", "113222", "123122", "123221", "223211", "221132", "221231", "213212", "223112", "312131", "311222", "321122", "321221", "312212", "322112", "322211", "212123", "212321", "232121", "111323", "131123", "131321", "112313", "132113", "132311", "211313", "231113", "231311", "112133", "112331", "132131", "113123", "113321", "133121", "313121", "211331", "231131", "213113", "213311", "213131", "311123", "311321", "331121", "312113", "312311", "332111", "314111", "221411", "431111", "111224", "111422", "121124", "121421", "141122", "141221", "112214", "112412", "122114", "122411", "142112", "142211", "241211", "221114", "413111", "241112", "134111", "111242", "121142", "121241", "114212", "124112", "124211", "411212", "421112", "421211", "212141", "214121", "412121", "111143", "111341", "131141", "114113", "114311", "411113", "411311", "113141", "114131", "311141", "411131", "211412", "2331112"]); //#14266
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_codablockf.$ctx[id] = $_[id]); //#14266
        bwipp_codablockf.__14267__ = 1; //#14266
        $_ = Object.getPrototypeOf($_); //#14266
    } //#14266
    $_.rowbits = $a($_.r); //#14270
    for (var _A7 = 0, _A6 = $_.r - 1; _A7 <= _A6; _A7 += 1) { //#14282
        $_.i = _A7; //#14272
        $k[$j++] = Infinity; //#14273
        var _AC = $geti($_.cws, $_.i * $f($_.c + 5), $f($_.c + 5)); //#14274
        for (var _AD = 0, _AE = _AC.length; _AD < _AE; _AD++) { //#14276
            $forall($get($_.encs, $get(_AC, _AD)), function() { //#14275
                var _AI = $k[--$j]; //#14275
                $k[$j++] = $f(_AI - 48); //#14275
            }); //#14275
        } //#14275
        $_.sbs = $a(); //#14275
        $k[$j++] = Infinity; //#14278
        var _AK = $_.sbs; //#14279
        $k[$j++] = 0; //#14279
        for (var _AL = 0, _AM = _AK.length; _AL < _AM; _AL++) { //#14279
            var _AO = $k[--$j]; //#14279
            var _AP = (_AO == 1) ? 0 : 1; //#14279
            $k[$j++] = _AO; //#14279
            for (var _AQ = 0, _AR = $get(_AK, _AL); _AQ < _AR; _AQ++) { //#14279
                $k[$j++] = _AP //#14279
            } //#14279
        } //#14279
        $astore($a($counttomark() - 1)); //#14280
        var _AU = $k[--$j]; //#14280
        var _AV = $k[--$j]; //#14280
        $k[$j++] = _AU; //#14280
        $k[$j++] = _AV; //#14280
        $j--; //#14280
        var _AW = $k[--$j]; //#14280
        var _AX = $k[--$j]; //#14280
        $k[$j++] = _AW; //#14280
        $k[$j++] = _AX; //#14280
        $j--; //#14280
        $put($_.rowbits, $_.i, $k[--$j]); //#14281
    } //#14281
    $_.symwid = $f(($_.c * 11) + 57); //#14285
    $k[$j++] = Infinity; //#14286
    for (var _Ae = 0, _Af = $_.symwid * $_.sepheight; _Ae < _Af; _Ae++) { //#14287
        $k[$j++] = 1; //#14287
    } //#14287
    for (var _Ai = 0, _Ah = $_.r - 2; _Ai <= _Ah; _Ai += 1) { //#14296
        $_.i = _Ai; //#14289
        for (var _Ak = 0, _Al = $_.rowheight; _Ak < _Al; _Ak++) { //#14290
            $aload($get($_.rowbits, $_.i)); //#14290
        } //#14290
        for (var _Aq = 0, _Ar = $_.sepheight; _Aq < _Ar; _Aq++) { //#14295
            $k[$j++] = 1; //#14293
            $k[$j++] = 1; //#14293
            $k[$j++] = 0; //#14293
            $k[$j++] = 1; //#14293
            $k[$j++] = 0; //#14293
            $k[$j++] = 0; //#14293
            $k[$j++] = 0; //#14293
            $k[$j++] = 0; //#14293
            $k[$j++] = 1; //#14293
            $k[$j++] = 0; //#14293
            $k[$j++] = 0; //#14293
            for (var _At = 0, _Au = $f($_.symwid - 24); _At < _Au; _At++) { //#14293
                $k[$j++] = 1; //#14293
            } //#14293
            $k[$j++] = 1; //#14294
            $k[$j++] = 1; //#14294
            $k[$j++] = 0; //#14294
            $k[$j++] = 0; //#14294
            $k[$j++] = 0; //#14294
            $k[$j++] = 1; //#14294
            $k[$j++] = 1; //#14294
            $k[$j++] = 1; //#14294
            $k[$j++] = 0; //#14294
            $k[$j++] = 1; //#14294
            $k[$j++] = 0; //#14294
            $k[$j++] = 1; //#14294
            $k[$j++] = 1; //#14294
        } //#14294
    } //#14294
    for (var _Aw = 0, _Ax = $_.rowheight; _Aw < _Ax; _Aw++) { //#14297
        $aload($get($_.rowbits, $_.r - 1)); //#14297
    } //#14297
    for (var _B3 = 0, _B4 = $_.symwid * $_.sepheight; _B3 < _B4; _B3++) { //#14298
        $k[$j++] = 1; //#14298
    } //#14298
    $_.pixs = $a(); //#14298
    var _BE = new Map([
        ["ren", 'renmatrix'],
        ["pixs", $_.pixs],
        ["pixx", $_.symwid],
        ["pixy", ~~($_.pixs.length / $_.symwid)],
        ["height", (~~($_.pixs.length / $_.symwid)) / 72],
        ["width", $_.symwid / 72],
        ["opt", $_.options]
    ]); //#14309
    $k[$j++] = _BE; //#14312
    if (!$_.dontdraw) { //#14312
        bwipp_renmatrix(); //#14312
    } //#14312
    $_ = Object.getPrototypeOf($_); //#14314
    $_ = Object.getPrototypeOf($_); //#14316
} //bwipp_codablockf
function bwipp_code16k() {
    $_ = Object.create($_); //#14347
    $_.dontdraw = false; //#14350
    $_.sam = -1; //#14351
    $_.rows = 0; //#14352
    $_.rowheight = 8; //#14353
    $_.sepheight = 1; //#14354
    $_.raw = false; //#14355
    $_.parse = false; //#14356
    $_.parsefnc = false; //#14357
    $k[$j++] = $_; //#14359
    bwipp_processoptions(); //#14359
    $_.options = $k[--$j]; //#14359
    $_.barcode = $k[--$j]; //#14360
    if (($_.rows != 0) && (($_.rows < 2) || ($_.rows > 16))) { //#14364
        $k[$j++] = 'bwipp.code16kBadRows#14363'; //#14363
        $k[$j++] = "Code 16K must have 2 to 16 rows"; //#14363
        bwipp_raiseerror(); //#14363
    } //#14363
    if ($_.rowheight < 8) { //#14368
        $k[$j++] = 'bwipp.code16kBadRowHeight#14367'; //#14367
        $k[$j++] = "Code 16K must have rowheight of at least 8"; //#14367
        bwipp_raiseerror(); //#14367
    } //#14367
    if ($_.sepheight < 1) { //#14372
        $k[$j++] = 'bwipp.code16kBadSepHeight#14371'; //#14371
        $k[$j++] = "Code 16K must have sepheight of at least 1"; //#14371
        bwipp_raiseerror(); //#14371
    } //#14371
    if ($_.sam != -1) { //#14384
        $k[$j++] = true; //#14380
        for (var _8 = 0, _9 = 1; _8 < _9; _8++) { //#14380
            var _A = $_.sam; //#14377
            if ((_A < 12) || (_A > 99)) { //#14377
                $j--; //#14377
                $k[$j++] = false; //#14377
                break; //#14377
            } //#14377
            if (($_.sam % 10) < 2) { //#14378
                $j--; //#14378
                $k[$j++] = false; //#14378
                break; //#14378
            } //#14378
            if ((~~($_.sam / 10)) > ($_.sam % 10)) { //#14379
                $j--; //#14379
                $k[$j++] = false; //#14379
                break; //#14379
            } //#14379
        } //#14379
        if ($nt($k[--$j])) { //#14383
            $k[$j++] = 'bwipp.code16kBadSAM#14382'; //#14382
            $k[$j++] = "SAM must be formatted as \"NM\" for Nth of M symbols, from 2 to 9 symbols"; //#14382
            bwipp_raiseerror(); //#14382
        } //#14382
    } //#14382
    bwipp_loadctx(bwipp_code16k) //#14386
    if ($_.sam != -1) { //#14388
        $_.rows = 16; //#14388
    } //#14388
    if (!bwipp_code16k.__14453__) { //#14453
        $_ = Object.create($_); //#14453
        $_.swa = -1; //#14392
        $_.swb = -2; //#14392
        $_.swc = -3; //#14392
        $_.sa1 = -4; //#14393
        $_.sb1 = -5; //#14393
        $_.sc1 = -6; //#14393
        $_.sa2 = -7; //#14394
        $_.sb2 = -8; //#14394
        $_.sc2 = -9; //#14394
        $_.pad = -10; //#14395
        $_.sb3 = -11; //#14395
        $_.sc3 = -12; //#14395
        $_.fn1 = -13; //#14396
        $_.fn2 = -14; //#14396
        $_.fn3 = -15; //#14396
        $_.fn4 = -16; //#14396
        $_.charmaps = $a([$a([32, 32, "00"]), $a(["!", "!", "01"]), $a(["\"", "\"", "02"]), $a(["#", "#", "03"]), $a(["$", "$", "04"]), $a(["%", "%", "05"]), $a(["&", "&", "06"]), $a(["'", "'", "07"]), $a([40, 40, "08"]), $a([41, 41, "09"]), $a(["*", "*", "10"]), $a(["+", "+", "11"]), $a([",", ",", "12"]), $a(["-", "-", "13"]), $a([".", ".", "14"]), $a(["/", "/", "15"]), $a(["0", "0", "16"]), $a(["1", "1", "17"]), $a(["2", "2", "18"]), $a(["3", "3", "19"]), $a(["4", "4", "20"]), $a(["5", "5", "21"]), $a(["6", "6", "22"]), $a(["7", "7", "23"]), $a(["8", "8", "24"]), $a(["9", "9", "25"]), $a([":", ":", "26"]), $a([";", ";", "27"]), $a(["<", "<", "28"]), $a(["=", "=", "29"]), $a([">", ">", "30"]), $a(["?", "?", "31"]), $a(["@", "@", "32"]), $a(["A", "A", "33"]), $a(["B", "B", "34"]), $a(["C", "C", "35"]), $a(["D", "D", "36"]), $a(["E", "E", "37"]), $a(["F", "F", "38"]), $a(["G", "G", "39"]), $a(["H", "H", "40"]), $a(["I", "I", "41"]), $a(["J", "J", "42"]), $a(["K", "K", "43"]), $a(["L", "L", "44"]), $a(["M", "M", "45"]), $a(["N", "N", "46"]), $a(["O", "O", "47"]), $a(["P", "P", "48"]), $a(["Q", "Q", "49"]), $a(["R", "R", "50"]), $a(["S", "S", "51"]), $a(["T", "T", "52"]), $a(["U", "U", "53"]), $a(["V", "V", "54"]), $a(["W", "W", "55"]), $a(["X", "X", "56"]), $a(["Y", "Y", "57"]), $a(["Z", "Z", "58"]), $a(["[", "[", "59"]), $a([92, 92, "60"]), $a(["]", "]", "61"]), $a(["^", "^", "62"]), $a(["_", "_", "63"]), $a([0, "`", "64"]), $a([1, "a", "65"]), $a([2, "b", "66"]), $a([3, "c", "67"]), $a([4, "d", "68"]), $a([5, "e", "69"]), $a([6, "f", "70"]), $a([7, "g", "71"]), $a([8, "h", "72"]), $a([9, "i", "73"]), $a([10, "j", "74"]), $a([11, "k", "75"]), $a([12, "l", "76"]), $a([13, "m", "77"]), $a([14, "n", "78"]), $a([15, "o", "79"]), $a([16, "p", "80"]), $a([17, "q", "81"]), $a([18, "r", "82"]), $a([19, "s", "83"]), $a([20, "t", "84"]), $a([21, "u", "85"]), $a([22, "v", "86"]), $a([23, "w", "87"]), $a([24, "x", "88"]), $a([25, "y", "89"]), $a([26, "z", "90"]), $a([27, "{", "91"]), $a([28, "|", "92"]), $a([29, "}", "93"]), $a([30, "~", "94"]), $a([31, 127, "95"]), $a([$_.fn3, $_.fn3, "96"]), $a([$_.fn2, $_.fn2, "97"]), $a([$_.sb1, $_.sa1, "98"]), $a([$_.swc, $_.swc, "99"]), $a([$_.swb, $_.fn4, $_.swb]), $a([$_.fn4, $_.swa, $_.swa]), $a([$_.fn1, $_.fn1, $_.fn1]), $a([$_.pad, $_.pad, $_.pad]), $a([$_.sb2, $_.sa2, $_.sb1]), $a([$_.sc2, $_.sc2, $_.sb2]), $a([$_.sc3, $_.sc3, $_.sb3])]); //#14437
        $_.charvals = $a([new Map, new Map, new Map]); //#14440
        for (var _2W = 0, _2V = $_.charmaps.length - 1; _2W <= _2V; _2W += 1) { //#14449
            $_.i = _2W; //#14442
            $_.encs = $get($_.charmaps, $_.i); //#14443
            for (var _2a = 0; _2a <= 2; _2a += 1) { //#14448
                $_.j = _2a; //#14445
                var _2d = $get($_.encs, $_.j); //#14446
                $k[$j++] = _2d; //#14446
                if ($eq($type(_2d), 'stringtype')) { //#14446
                    var _2g = $get($k[--$j], 0); //#14446
                    $k[$j++] = _2g; //#14446
                } //#14446
                $put($get($_.charvals, $_.j), $k[--$j], $_.i); //#14447
            } //#14447
        } //#14447
        $_.seta = $get($_.charvals, 0); //#14450
        $_.setb = $get($_.charvals, 1); //#14451
        $_.setc = $get($_.charvals, 2); //#14452
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_code16k.$ctx[id] = $_[id]); //#14452
        bwipp_code16k.__14453__ = 1; //#14452
        $_ = Object.getPrototypeOf($_); //#14452
    } //#14452
    if ($_.raw) { //#14923
        $_.cws = $a($_.barcode.length); //#14457
        $_.i = 0; //#14458
        $_.j = 0; //#14458
        for (;;) { //#14469
            if ($_.i >= ($_.barcode.length - 3)) { //#14460
                break; //#14460
            } //#14460
            if ($get($_.barcode, $_.i) != 94) { //#14461
                break; //#14461
            } //#14461
            var _33 = $geti($_.barcode, $_.i + 1, 3); //#14462
            $k[$j++] = _33; //#14464
            $k[$j++] = false; //#14464
            for (var _34 = 0, _35 = _33.length; _34 < _35; _34++) { //#14464
                var _36 = $get(_33, _34); //#14464
                if ((_36 < 48) || (_36 > 57)) { //#14463
                    $j--; //#14463
                    $k[$j++] = true; //#14463
                } //#14463
            } //#14463
            if ($k[--$j]) { //#14464
                $j--; //#14464
                break; //#14464
            } //#14464
            $_.cw = $cvi($k[--$j]); //#14465
            $put($_.cws, $_.j, $_.cw); //#14466
            $_.i = $_.i + 4; //#14467
            $_.j = $_.j + 1; //#14468
        } //#14468
        if ($_.i != $_.barcode.length) { //#14472
            $k[$j++] = 'bwipp.code16kBadRawFormat#14471'; //#14471
            $k[$j++] = "raw data must be formatted as ^NNN"; //#14471
            bwipp_raiseerror(); //#14471
        } //#14471
        $_.cws = $geti($_.cws, 0, $_.j); //#14473
    } else { //#14923
        var _3O = new Map([
            ["parse", $_.parse],
            ["parsefnc", $_.parsefnc],
            ["eci", true],
            ["FNC1", $_.fn1],
            ["FNC2", $_.fn2],
            ["FNC3", $_.fn3]
        ]); //#14484
        $_.fncvals = _3O; //#14486
        $k[$j++] = 'msg'; //#14487
        $k[$j++] = $_.barcode; //#14487
        $k[$j++] = $_.fncvals; //#14487
        bwipp_parseinput(); //#14487
        var _3R = $k[--$j]; //#14487
        $_[$k[--$j]] = _3R; //#14487
        $_.msglen = $_.msg.length; //#14488
        $k[$j++] = Infinity; //#14491
        for (var _3V = 0, _3W = $_.msglen; _3V < _3W; _3V++) { //#14491
            $k[$j++] = 0; //#14491
        } //#14491
        $k[$j++] = 0; //#14491
        $_.numSA = $a(); //#14491
        $k[$j++] = Infinity; //#14492
        for (var _3Z = 0, _3a = $_.msglen; _3Z < _3a; _3Z++) { //#14492
            $k[$j++] = 0; //#14492
        } //#14492
        $k[$j++] = 0; //#14492
        $_.numEA = $a(); //#14492
        for (var _3d = $_.msglen - 1; _3d >= 0; _3d -= 1) { //#14502
            $_.i = _3d; //#14494
            if ($get($_.msg, $_.i) >= 0) { //#14501
                if ($get($_.msg, $_.i) >= 128) { //#14499
                    $put($_.numEA, $_.i, $f($get($_.numEA, $_.i + 1) + 1)); //#14497
                } else { //#14499
                    $put($_.numSA, $_.i, $f($get($_.numSA, $_.i + 1) + 1)); //#14499
                } //#14499
            } //#14499
        } //#14499
        $_.ea = false; //#14505
        $_.msgtmp = $a([]); //#14505
        for (var _3x = 0, _3w = $_.msglen - 1; _3x <= _3w; _3x += 1) { //#14520
            $_.i = _3x; //#14507
            $_.c = $get($_.msg, $_.i); //#14508
            if ((!$xo($_.ea, $_.c < 128)) && ($_.c >= 0)) { //#14518
                if ($_.ea) { //#14510
                    $k[$j++] = $_.numSA; //#14510
                } else { //#14510
                    $k[$j++] = $_.numEA; //#14510
                } //#14510
                var _49 = $get($k[--$j], $_.i); //#14510
                var _4C = ($f(_49 + $_.i) == $_.msglen) ? 3 : 5; //#14511
                if (_49 < _4C) { //#14516
                    $k[$j++] = Infinity; //#14513
                    $aload($_.msgtmp); //#14513
                    $k[$j++] = $_.fn4; //#14513
                    $_.msgtmp = $a(); //#14513
                } else { //#14516
                    $k[$j++] = Infinity; //#14515
                    $aload($_.msgtmp); //#14515
                    $k[$j++] = $_.fn4; //#14515
                    $k[$j++] = $_.fn4; //#14515
                    $_.msgtmp = $a(); //#14515
                    $_.ea = !$_.ea; //#14516
                } //#14516
            } //#14516
            $k[$j++] = Infinity; //#14519
            $aload($_.msgtmp); //#14519
            if ($_.c >= 0) { //#14519
                $k[$j++] = $_.c & 127; //#14519
            } else { //#14519
                $k[$j++] = $_.c; //#14519
            } //#14519
            $_.msgtmp = $a(); //#14519
        } //#14519
        $_.msg = $_.msgtmp; //#14521
        $_.msglen = $_.msg.length; //#14522
        $_.numsscr = function() {
            $_.n = 0; //#14526
            $_.s = 0; //#14526
            $_.p = $k[--$j]; //#14527
            for (;;) { //#14538
                if ($_.p >= $_.msglen) { //#14528
                    break; //#14528
                } //#14528
                var _4X = $get($_.msg, $_.p); //#14529
                var _4Z = $get($_.setc, _4X) !== undefined; //#14530
                $k[$j++] = _4X; //#14530
                if (!_4Z) { //#14530
                    $j--; //#14530
                    break; //#14530
                } //#14530
                if ($k[--$j] == $_.fn1) { //#14534
                    if (($_.s % 2) == 0) { //#14533
                        $_.s = $_.s + 1; //#14533
                    } else { //#14533
                        break; //#14533
                    } //#14533
                } //#14533
                $_.n = $_.n + 1; //#14535
                $_.s = $_.s + 1; //#14536
                $_.p = $f($_.p + 1); //#14537
            } //#14537
            $k[$j++] = $_.n; //#14539
            $k[$j++] = $_.s; //#14539
        }; //#14539
        $_.enca = function() {
            $put($_.cws, $_.j, $get($_.seta, $k[--$j])); //#14544
            $_.j = $_.j + 1; //#14545
        }; //#14545
        $_.encb = function() {
            $put($_.cws, $_.j, $get($_.setb, $k[--$j])); //#14548
            $_.j = $_.j + 1; //#14549
        }; //#14549
        $_.encc = function() {
            var _4v = $k[--$j]; //#14552
            $k[$j++] = _4v; //#14556
            if ($ne($type(_4v), 'arraytype')) { //#14555
                var _4z = $get($_.setc, $k[--$j]); //#14553
                $k[$j++] = _4z; //#14553
            } else { //#14555
                $aload($k[--$j]); //#14555
                var _51 = $k[--$j]; //#14555
                var _52 = $k[--$j]; //#14555
                $k[$j++] = $f($f(_51 - 48) + ($f(_52 - 48) * 10)); //#14555
            } //#14555
            $put($_.cws, $_.j, $k[--$j]); //#14557
            $_.j = $_.j + 1; //#14558
        }; //#14558
        $_.anotb = function() {
            var _57 = $k[--$j]; //#14562
            var _59 = $get($_.seta, _57) !== undefined; //#14562
            var _5B = $get($_.setb, _57) !== undefined; //#14562
            $k[$j++] = _59 && (!_5B); //#14562
        }; //#14562
        $_.bnota = function() {
            var _5C = $k[--$j]; //#14563
            var _5E = $get($_.setb, _5C) !== undefined; //#14563
            var _5G = $get($_.seta, _5C) !== undefined; //#14563
            $k[$j++] = _5E && (!_5G); //#14563
        }; //#14563
        $k[$j++] = Infinity; //#14566
        for (var _5I = 0, _5J = $_.msg.length; _5I < _5J; _5I++) { //#14566
            $k[$j++] = 0; //#14566
        } //#14566
        $k[$j++] = 9999; //#14566
        $_.nextanotb = $a(); //#14566
        $k[$j++] = Infinity; //#14567
        for (var _5M = 0, _5N = $_.msg.length; _5M < _5N; _5M++) { //#14567
            $k[$j++] = 0; //#14567
        } //#14567
        $k[$j++] = 9999; //#14567
        $_.nextbnota = $a(); //#14567
        for (var _5Q = $_.msg.length - 1; _5Q >= 0; _5Q -= 1) { //#14580
            $_.i = _5Q; //#14569
            $k[$j++] = $get($_.msg, $_.i); //#14570
            $_.anotb(); //#14570
            if ($k[--$j]) { //#14573
                $put($_.nextanotb, $_.i, 0); //#14571
            } else { //#14573
                $put($_.nextanotb, $_.i, $f($get($_.nextanotb, $_.i + 1) + 1)); //#14573
            } //#14573
            $k[$j++] = $get($_.msg, $_.i); //#14575
            $_.bnota(); //#14575
            if ($k[--$j]) { //#14578
                $put($_.nextbnota, $_.i, 0); //#14576
            } else { //#14578
                $put($_.nextbnota, $_.i, $f($get($_.nextbnota, $_.i + 1) + 1)); //#14578
            } //#14578
        } //#14578
        $_.abeforeb = function() {
            var _5n = $k[--$j]; //#14583
            $k[$j++] = $lt($get($_.nextanotb, _5n), $get($_.nextbnota, _5n)); //#14583
        }; //#14583
        $_.bbeforea = function() {
            var _5s = $k[--$j]; //#14584
            $k[$j++] = $lt($get($_.nextbnota, _5s), $get($_.nextanotb, _5s)); //#14584
        }; //#14584
        $_.cws = $a(($_.barcode.length * 2) + 3); //#14586
        $_.i = 0; //#14589
        $_.j = 0; //#14589
        for (;;) { //#14679
            if ($_.sam != -1) { //#14600
                $put($_.cws, 0, (~~($_.sam / 10)) - 1); //#14594
                $put($_.cws, 1, ($_.sam % 10) - 1); //#14595
                $_.j = 2; //#14596
                $_.cset = "setb"; //#14597
                $_.mode = 7; //#14598
                break; //#14599
            } //#14599
            if ($_.msglen == 0) { //#14606
                $_.cset = "setb"; //#14603
                $_.mode = 1; //#14604
                break; //#14605
            } //#14605
            if ($_.msglen >= 2) { //#14615
                $k[$j++] = $get($_.msg, 0) == $_.fn1; //#14609
                $k[$j++] = 1; //#14609
                $_.numsscr(); //#14609
                var _69 = $k[--$j]; //#14609
                var _6A = $k[--$j]; //#14609
                $k[$j++] = _69; //#14609
                $k[$j++] = _6A; //#14609
                $j--; //#14609
                var _6B = $k[--$j]; //#14609
                var _6C = $k[--$j]; //#14609
                if (_6C && (_6B >= 2)) { //#14614
                    $_.cset = "setc"; //#14610
                    $_.mode = 4; //#14611
                    $_.i = 1; //#14612
                    break; //#14613
                } //#14613
            } //#14613
            if ($get($_.msg, 0) == $_.fn1) { //#14622
                $_.cset = "setb"; //#14618
                $_.mode = 3; //#14619
                $_.i = 1; //#14620
                break; //#14621
            } //#14621
            if ($_.msglen >= 2) { //#14668
                $k[$j++] = 0; //#14625
                $_.numsscr(); //#14625
                var _6H = $k[--$j]; //#14625
                var _6I = $k[--$j]; //#14625
                $k[$j++] = _6H; //#14625
                $k[$j++] = _6I; //#14625
                $j--; //#14625
                var _6J = $k[--$j]; //#14625
                if ((_6J >= 2) && ((_6J % 2) == 0)) { //#14629
                    $_.cset = "setc"; //#14626
                    $_.mode = 2; //#14627
                    break; //#14628
                } //#14628
                $k[$j++] = 0; //#14631
                $_.numsscr(); //#14631
                var _6K = $k[--$j]; //#14631
                var _6L = $k[--$j]; //#14631
                $k[$j++] = _6K; //#14631
                $k[$j++] = _6L; //#14631
                $j--; //#14631
                var _6M = $k[--$j]; //#14631
                if ((_6M >= 3) && ((_6M % 2) == 1)) { //#14637
                    $k[$j++] = $get($_.msg, 0); //#14632
                    $_.encb(); //#14632
                    $_.cset = "setc"; //#14633
                    $_.mode = 5; //#14634
                    $_.i = 1; //#14635
                    break; //#14636
                } //#14636
                var _6S = $get($_.setb, $get($_.msg, 0)) !== undefined; //#14639
                $k[$j++] = _6S; //#14640
                $k[$j++] = 1; //#14640
                $_.numsscr(); //#14640
                var _6T = $k[--$j]; //#14640
                var _6U = $k[--$j]; //#14640
                $k[$j++] = _6T; //#14640
                $k[$j++] = _6U; //#14640
                $j--; //#14640
                var _6V = $k[--$j]; //#14640
                var _6W = $k[--$j]; //#14640
                if (_6W && ((_6V >= 2) && ((_6V % 2) == 0))) { //#14646
                    $k[$j++] = $get($_.msg, 0); //#14641
                    $_.encb(); //#14641
                    $_.cset = "setc"; //#14642
                    $_.mode = 5; //#14643
                    $_.i = 1; //#14644
                    break; //#14645
                } //#14645
                var _6c = $get($_.setb, $get($_.msg, 0)) !== undefined; //#14648
                $k[$j++] = _6c; //#14649
                $k[$j++] = 1; //#14649
                $_.numsscr(); //#14649
                var _6d = $k[--$j]; //#14649
                var _6e = $k[--$j]; //#14649
                $k[$j++] = _6d; //#14649
                $k[$j++] = _6e; //#14649
                $j--; //#14649
                var _6f = $k[--$j]; //#14649
                var _6g = $k[--$j]; //#14649
                if (_6g && ((_6f >= 3) && ((_6f % 2) == 1))) { //#14656
                    $k[$j++] = $get($_.msg, 0); //#14650
                    $_.encb(); //#14650
                    $k[$j++] = $get($_.msg, 1); //#14651
                    $_.encb(); //#14651
                    $_.cset = "setc"; //#14652
                    $_.mode = 6; //#14653
                    $_.i = 2; //#14654
                    break; //#14655
                } //#14655
                var _6o = $get($_.setb, $get($_.msg, 0)) !== undefined; //#14658
                var _6s = $get($_.setb, $get($_.msg, 1)) !== undefined; //#14659
                $k[$j++] = _6o && _6s; //#14660
                $k[$j++] = 2; //#14660
                $_.numsscr(); //#14660
                var _6t = $k[--$j]; //#14660
                var _6u = $k[--$j]; //#14660
                $k[$j++] = _6t; //#14660
                $k[$j++] = _6u; //#14660
                $j--; //#14660
                var _6v = $k[--$j]; //#14660
                var _6w = $k[--$j]; //#14660
                if (_6w && ((_6v >= 2) && ((_6v % 2) == 0))) { //#14667
                    $k[$j++] = $get($_.msg, 0); //#14661
                    $_.encb(); //#14661
                    $k[$j++] = $get($_.msg, 1); //#14662
                    $_.encb(); //#14662
                    $_.cset = "setc"; //#14663
                    $_.mode = 6; //#14664
                    $_.i = 2; //#14665
                    break; //#14666
                } //#14666
            } //#14666
            $k[$j++] = 0; //#14670
            $_.abeforeb(); //#14670
            if ($k[--$j]) { //#14674
                $_.cset = "seta"; //#14671
                $_.mode = 0; //#14672
                break; //#14673
            } //#14673
            $_.cset = "setb"; //#14676
            $_.mode = 1; //#14677
            break; //#14678
        } //#14678
        for (;;) { //#14922
            if ($_.i == $_.msglen) { //#14682
                break; //#14682
            } //#14682
            $k[$j++] = $_.i; //#14684
            $_.numsscr(); //#14684
            $_.nums = $k[--$j]; //#14684
            $_.nchars = $k[--$j]; //#14684
            for (;;) { //#14920
                if ($eq($_.cset, "seta")) { //#14761
                    if ($_.i < ($_.msglen - 1)) { //#14698
                        $k[$j++] = $get($_.msg, $_.i); //#14691
                        $_.bnota(); //#14691
                        $k[$j++] = $_.i + 1; //#14692
                        $_.abeforeb(); //#14692
                        var _7E = $k[--$j]; //#14692
                        var _7F = $k[--$j]; //#14692
                        if ((_7F && _7E)) { //#14697
                            $k[$j++] = $_.sb1; //#14693
                            $_.enca(); //#14693
                            $k[$j++] = $get($_.msg, $_.i); //#14694
                            $_.encb(); //#14694
                            $_.i = $_.i + 1; //#14695
                            break; //#14696
                        } //#14696
                    } //#14696
                    if ($_.i < ($_.msglen - 2)) { //#14710
                        $k[$j++] = $get($_.msg, $_.i); //#14701
                        $_.bnota(); //#14701
                        $k[$j++] = $get($_.msg, $_.i + 1); //#14702
                        $_.bnota(); //#14702
                        var _7T = $k[--$j]; //#14702
                        var _7U = $k[--$j]; //#14702
                        $k[$j++] = $an(_7U, _7T); //#14703
                        $k[$j++] = $_.i + 2; //#14703
                        $_.abeforeb(); //#14703
                        var _7W = $k[--$j]; //#14703
                        var _7X = $k[--$j]; //#14703
                        if ((_7X && _7W)) { //#14709
                            $k[$j++] = $_.sb2; //#14704
                            $_.enca(); //#14704
                            $k[$j++] = $get($_.msg, $_.i); //#14705
                            $_.encb(); //#14705
                            $k[$j++] = $get($_.msg, $_.i + 1); //#14706
                            $_.encb(); //#14706
                            $_.i = $_.i + 2; //#14707
                            break; //#14708
                        } //#14708
                    } //#14708
                    $k[$j++] = $get($_.msg, $_.i); //#14712
                    $_.bnota(); //#14712
                    if ($k[--$j]) { //#14716
                        $k[$j++] = $_.swb; //#14713
                        $_.enca(); //#14713
                        $_.cset = "setb"; //#14714
                        break; //#14715
                    } //#14715
                    if ($_.i < ($_.msglen - 4)) { //#14733
                        var _7s = $get($_.seta, $get($_.msg, $_.i + 4)) !== undefined; //#14720
                        if (($_.nums == 4) && _7s) { //#14732
                            $k[$j++] = $_.sc2; //#14721
                            $_.enca(); //#14721
                            for (var _7u = 0, _7v = 2; _7u < _7v; _7u++) { //#14730
                                if ($get($_.msg, $_.i) == $_.fn1) { //#14728
                                    $k[$j++] = $_.fn1; //#14724
                                    $_.encc(); //#14724
                                    $_.i = $_.i + 1; //#14725
                                } else { //#14728
                                    $k[$j++] = $geti($_.msg, $_.i, 2); //#14727
                                    $_.encc(); //#14727
                                    $_.i = $_.i + 2; //#14728
                                } //#14728
                            } //#14728
                            break; //#14731
                        } //#14731
                    } //#14731
                    if ($_.i < ($_.msglen - 6)) { //#14750
                        var _8D = $get($_.seta, $get($_.msg, $_.i + 6)) !== undefined; //#14737
                        if (($_.nums == 6) && _8D) { //#14749
                            $k[$j++] = $_.sc3; //#14738
                            $_.enca(); //#14738
                            for (var _8F = 0, _8G = 3; _8F < _8G; _8F++) { //#14747
                                if ($get($_.msg, $_.i) == $_.fn1) { //#14745
                                    $k[$j++] = $_.fn1; //#14741
                                    $_.encc(); //#14741
                                    $_.i = $_.i + 1; //#14742
                                } else { //#14745
                                    $k[$j++] = $geti($_.msg, $_.i, 2); //#14744
                                    $_.encc(); //#14744
                                    $_.i = $_.i + 2; //#14745
                                } //#14745
                            } //#14745
                            break; //#14748
                        } //#14748
                    } //#14748
                    if (($_.nums >= 4) && (($_.nums % 2) == 0)) { //#14756
                        $k[$j++] = $_.swc; //#14753
                        $_.enca(); //#14753
                        $_.cset = "setc"; //#14754
                        break; //#14755
                    } //#14755
                    $k[$j++] = $get($_.msg, $_.i); //#14758
                    $_.enca(); //#14758
                    $_.i = $_.i + 1; //#14759
                    break; //#14760
                } //#14760
                if ($eq($_.cset, "setb")) { //#14835
                    if ($_.i < ($_.msglen - 1)) { //#14772
                        $k[$j++] = $get($_.msg, $_.i); //#14765
                        $_.anotb(); //#14765
                        $k[$j++] = $_.i + 1; //#14766
                        $_.bbeforea(); //#14766
                        var _8f = $k[--$j]; //#14766
                        var _8g = $k[--$j]; //#14766
                        if ((_8g && _8f)) { //#14771
                            $k[$j++] = $_.sa1; //#14767
                            $_.encb(); //#14767
                            $k[$j++] = $get($_.msg, $_.i); //#14768
                            $_.enca(); //#14768
                            $_.i = $_.i + 1; //#14769
                            break; //#14770
                        } //#14770
                    } //#14770
                    if ($_.i < ($_.msglen - 2)) { //#14784
                        $k[$j++] = $get($_.msg, $_.i); //#14775
                        $_.anotb(); //#14775
                        $k[$j++] = $get($_.msg, $_.i + 1); //#14776
                        $_.anotb(); //#14776
                        var _8u = $k[--$j]; //#14776
                        var _8v = $k[--$j]; //#14776
                        $k[$j++] = $an(_8v, _8u); //#14777
                        $k[$j++] = $_.i + 2; //#14777
                        $_.bbeforea(); //#14777
                        var _8x = $k[--$j]; //#14777
                        var _8y = $k[--$j]; //#14777
                        if ((_8y && _8x)) { //#14783
                            $k[$j++] = $_.sa2; //#14778
                            $_.encb(); //#14778
                            $k[$j++] = $get($_.msg, $_.i); //#14779
                            $_.enca(); //#14779
                            $k[$j++] = $get($_.msg, $_.i + 1); //#14780
                            $_.enca(); //#14780
                            $_.i = $_.i + 2; //#14781
                            break; //#14782
                        } //#14782
                    } //#14782
                    $k[$j++] = $get($_.msg, $_.i); //#14786
                    $_.anotb(); //#14786
                    if ($k[--$j]) { //#14790
                        $k[$j++] = $_.swa; //#14787
                        $_.encb(); //#14787
                        $_.cset = "seta"; //#14788
                        break; //#14789
                    } //#14789
                    if ($_.i < ($_.msglen - 4)) { //#14807
                        var _9J = $get($_.setb, $get($_.msg, $_.i + 4)) !== undefined; //#14794
                        if (($_.nums == 4) && _9J) { //#14806
                            $k[$j++] = $_.sc2; //#14795
                            $_.encb(); //#14795
                            for (var _9L = 0, _9M = 2; _9L < _9M; _9L++) { //#14804
                                if ($get($_.msg, $_.i) == $_.fn1) { //#14802
                                    $k[$j++] = $_.fn1; //#14798
                                    $_.encc(); //#14798
                                    $_.i = $_.i + 1; //#14799
                                } else { //#14802
                                    $k[$j++] = $geti($_.msg, $_.i, 2); //#14801
                                    $_.encc(); //#14801
                                    $_.i = $_.i + 2; //#14802
                                } //#14802
                            } //#14802
                            break; //#14805
                        } //#14805
                    } //#14805
                    if ($_.i < ($_.msglen - 6)) { //#14824
                        var _9e = $get($_.setb, $get($_.msg, $_.i + 6)) !== undefined; //#14811
                        if (($_.nums == 6) && _9e) { //#14823
                            $k[$j++] = $_.sc3; //#14812
                            $_.encb(); //#14812
                            for (var _9g = 0, _9h = 3; _9g < _9h; _9g++) { //#14821
                                if ($get($_.msg, $_.i) == $_.fn1) { //#14819
                                    $k[$j++] = $_.fn1; //#14815
                                    $_.encc(); //#14815
                                    $_.i = $_.i + 1; //#14816
                                } else { //#14819
                                    $k[$j++] = $geti($_.msg, $_.i, 2); //#14818
                                    $_.encc(); //#14818
                                    $_.i = $_.i + 2; //#14819
                                } //#14819
                            } //#14819
                            break; //#14822
                        } //#14822
                    } //#14822
                    if (($_.nums >= 4) && (($_.nums % 2) == 0)) { //#14830
                        $k[$j++] = $_.swc; //#14827
                        $_.encb(); //#14827
                        $_.cset = "setc"; //#14828
                        break; //#14829
                    } //#14829
                    $k[$j++] = $get($_.msg, $_.i); //#14832
                    $_.encb(); //#14832
                    $_.i = $_.i + 1; //#14833
                    break; //#14834
                } //#14834
                if ($eq($_.cset, "setc")) { //#14918
                    if ($_.nums >= 2) { //#14847
                        if ($get($_.msg, $_.i) == $_.fn1) { //#14844
                            $k[$j++] = $_.fn1; //#14840
                            $_.encc(); //#14840
                            $_.i = $_.i + 1; //#14841
                        } else { //#14844
                            $k[$j++] = $geti($_.msg, $_.i, 2); //#14843
                            $_.encc(); //#14843
                            $_.i = $_.i + 2; //#14844
                        } //#14844
                        break; //#14846
                    } //#14846
                    if ($_.i < ($_.msglen - 1)) { //#14857
                        var _AH = $get($_.setb, $get($_.msg, $_.i)) !== undefined; //#14850
                        $k[$j++] = _AH; //#14851
                        $k[$j++] = $_.i + 1; //#14851
                        $_.numsscr(); //#14851
                        var _AJ = $k[--$j]; //#14851
                        var _AK = $k[--$j]; //#14851
                        $k[$j++] = _AJ; //#14851
                        $k[$j++] = _AK; //#14851
                        $j--; //#14851
                        var _AL = $k[--$j]; //#14851
                        var _AM = $k[--$j]; //#14851
                        if (_AM && ((_AL >= 2) && ((_AL % 2) == 0))) { //#14856
                            $k[$j++] = $_.sb1; //#14852
                            $_.encc(); //#14852
                            $k[$j++] = $get($_.msg, $_.i); //#14853
                            $_.encb(); //#14853
                            $_.i = $_.i + 1; //#14854
                            break; //#14855
                        } //#14855
                    } //#14855
                    if ($_.i < ($_.msglen - 1)) { //#14868
                        var _AY = $get($_.setb, $get($_.msg, $_.i)) !== undefined; //#14860
                        $k[$j++] = _AY; //#14861
                        $k[$j++] = $_.i + 1; //#14861
                        $_.numsscr(); //#14861
                        var _Aa = $k[--$j]; //#14861
                        var _Ab = $k[--$j]; //#14861
                        $k[$j++] = _Aa; //#14861
                        $k[$j++] = _Ab; //#14861
                        $j--; //#14861
                        var _Ac = $k[--$j]; //#14861
                        var _Ad = $k[--$j]; //#14861
                        if (_Ad && ((_Ac >= 3) && ((_Ac % 2) == 1))) { //#14867
                            $k[$j++] = $_.sb2; //#14862
                            $_.encc(); //#14862
                            $k[$j++] = $get($_.msg, $_.i); //#14863
                            $_.encb(); //#14863
                            $k[$j++] = $get($_.msg, $_.i + 1); //#14864
                            $_.encb(); //#14864
                            $_.i = $_.i + 2; //#14865
                            break; //#14866
                        } //#14866
                    } //#14866
                    if ($_.i < ($_.msglen - 2)) { //#14880
                        var _As = $get($_.setb, $get($_.msg, $_.i)) !== undefined; //#14871
                        var _Ax = $get($_.setb, $get($_.msg, $_.i + 1)) !== undefined; //#14872
                        $k[$j++] = _As && _Ax; //#14873
                        $k[$j++] = $_.i + 2; //#14873
                        $_.numsscr(); //#14873
                        var _Az = $k[--$j]; //#14873
                        var _B0 = $k[--$j]; //#14873
                        $k[$j++] = _Az; //#14873
                        $k[$j++] = _B0; //#14873
                        $j--; //#14873
                        var _B1 = $k[--$j]; //#14873
                        var _B2 = $k[--$j]; //#14873
                        if (_B2 && ((_B1 >= 2) && ((_B1 % 2) == 0))) { //#14879
                            $k[$j++] = $_.sb2; //#14874
                            $_.encc(); //#14874
                            $k[$j++] = $get($_.msg, $_.i); //#14875
                            $_.encb(); //#14875
                            $k[$j++] = $get($_.msg, $_.i + 1); //#14876
                            $_.encb(); //#14876
                            $_.i = $_.i + 2; //#14877
                            break; //#14878
                        } //#14878
                    } //#14878
                    if ($_.i < ($_.msglen - 3)) { //#14893
                        var _BH = $get($_.setb, $get($_.msg, $_.i)) !== undefined; //#14883
                        var _BM = $get($_.setb, $get($_.msg, $_.i + 1)) !== undefined; //#14884
                        $k[$j++] = _BH && _BM; //#14885
                        $k[$j++] = $_.i + 2; //#14885
                        $_.numsscr(); //#14885
                        var _BO = $k[--$j]; //#14885
                        var _BP = $k[--$j]; //#14885
                        $k[$j++] = _BO; //#14885
                        $k[$j++] = _BP; //#14885
                        $j--; //#14885
                        var _BQ = $k[--$j]; //#14885
                        var _BR = $k[--$j]; //#14885
                        if (_BR && ((_BQ >= 3) && ((_BQ % 2) == 1))) { //#14892
                            $k[$j++] = $_.sb3; //#14886
                            $_.encc(); //#14886
                            $k[$j++] = $get($_.msg, $_.i); //#14887
                            $_.encb(); //#14887
                            $k[$j++] = $get($_.msg, $_.i + 1); //#14888
                            $_.encb(); //#14888
                            $k[$j++] = $get($_.msg, $_.i + 2); //#14889
                            $_.encb(); //#14889
                            $_.i = $_.i + 3; //#14890
                            break; //#14891
                        } //#14891
                    } //#14891
                    if ($_.i < ($_.msglen - 3)) { //#14907
                        var _Bj = $get($_.setb, $get($_.msg, $_.i)) !== undefined; //#14896
                        var _Bo = $get($_.setb, $get($_.msg, $_.i + 1)) !== undefined; //#14897
                        var _Bt = $get($_.setb, $get($_.msg, $_.i + 2)) !== undefined; //#14898
                        $k[$j++] = (_Bj && _Bo) && _Bt; //#14899
                        $k[$j++] = $_.i + 3; //#14899
                        $_.numsscr(); //#14899
                        var _Bv = $k[--$j]; //#14899
                        var _Bw = $k[--$j]; //#14899
                        $k[$j++] = _Bv; //#14899
                        $k[$j++] = _Bw; //#14899
                        $j--; //#14899
                        var _Bx = $k[--$j]; //#14899
                        var _By = $k[--$j]; //#14899
                        if (_By && ((_Bx >= 2) && ((_Bx % 2) == 0))) { //#14906
                            $k[$j++] = $_.sb3; //#14900
                            $_.encc(); //#14900
                            $k[$j++] = $get($_.msg, $_.i); //#14901
                            $_.encb(); //#14901
                            $k[$j++] = $get($_.msg, $_.i + 1); //#14902
                            $_.encb(); //#14902
                            $k[$j++] = $get($_.msg, $_.i + 2); //#14903
                            $_.encb(); //#14903
                            $_.i = $_.i + 3; //#14904
                            break; //#14905
                        } //#14905
                    } //#14905
                    $k[$j++] = $_.i; //#14909
                    $_.abeforeb(); //#14909
                    if ($k[--$j]) { //#14913
                        $k[$j++] = $_.swa; //#14910
                        $_.encc(); //#14910
                        $_.cset = "seta"; //#14911
                        break; //#14912
                    } //#14912
                    $k[$j++] = $_.swb; //#14915
                    $_.encc(); //#14915
                    $_.cset = "setb"; //#14916
                    break; //#14917
                } //#14917
                break; //#14919
            } //#14919
        } //#14919
        $_.cws = $geti($_.cws, 0, $_.j); //#14923
    } //#14923
    if (!bwipp_code16k.__14946__) { //#14946
        $_ = Object.create($_); //#14946
        $_.metrics = $a([$a([2, 7]), $a([3, 12]), $a([4, 17]), $a([5, 22]), $a([6, 27]), $a([7, 32]), $a([8, 37]), $a([9, 42]), $a([10, 47]), $a([11, 52]), $a([12, 57]), $a([13, 62]), $a([14, 67]), $a([15, 72]), $a([16, 77])]); //#14945
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_code16k.$ctx[id] = $_[id]); //#14945
        bwipp_code16k.__14946__ = 1; //#14945
        $_ = Object.getPrototypeOf($_); //#14945
    } //#14945
    $_.urows = $_.rows; //#14949
    var _CZ = $_.metrics; //#14950
    for (var _Ca = 0, _Cb = _CZ.length; _Ca < _Cb; _Ca++) { //#14958
        $_.m = $get(_CZ, _Ca); //#14951
        $_.r = $get($_.m, 0); //#14952
        $_.dcws = $get($_.m, 1); //#14953
        $_.okay = true; //#14954
        if (($_.urows != 0) && ($_.urows != $_.r)) { //#14955
            $_.okay = false; //#14955
        } //#14955
        if ($_.cws.length > $_.dcws) { //#14956
            $_.okay = false; //#14956
        } //#14956
        if ($_.okay) { //#14957
            break; //#14957
        } //#14957
    } //#14957
    if (!$_.okay) { //#14962
        $k[$j++] = 'bwipp.code16kNoValidSymbol#14961'; //#14961
        $k[$j++] = "Maximum length exceeded or data too large for given options"; //#14961
        bwipp_raiseerror(); //#14961
    } //#14961
    $k[$j++] = Infinity; //#14965
    $aload($_.cws); //#14965
    for (var _Cr = 0, _Cs = $f($_.dcws - $_.cws.length); _Cr < _Cs; _Cr++) { //#14965
        $k[$j++] = 103; //#14965
    } //#14965
    $_.cws = $a(); //#14965
    $k[$j++] = Infinity; //#14968
    $k[$j++] = $f(($f($_.r - 2) * 7) + $_.mode); //#14968
    $aload($_.cws); //#14968
    $_.cws = $a(); //#14968
    $k[$j++] = 0; //#14971
    for (var _D0 = 0, _Cz = $_.dcws; _D0 <= _Cz; _D0 += 1) { //#14971
        var _D3 = $k[--$j]; //#14971
        $k[$j++] = $f(_D3 + ((_D0 + 2) * $get($_.cws, _D0))); //#14971
    } //#14971
    $_.c1 = $k[--$j] % 107; //#14972
    $k[$j++] = 0; //#14973
    for (var _D7 = 0, _D6 = $_.dcws; _D7 <= _D6; _D7 += 1) { //#14973
        var _DA = $k[--$j]; //#14973
        $k[$j++] = $f(_DA + ((_D7 + 1) * $get($_.cws, _D7))); //#14973
    } //#14973
    $_.c2 = ($f($k[--$j] + ($_.c1 * $f($_.dcws + 2)))) % 107; //#14974
    $k[$j++] = Infinity; //#14975
    $aload($_.cws); //#14975
    $k[$j++] = $_.c1; //#14975
    $k[$j++] = $_.c2; //#14975
    $_.cws = $a(); //#14975
    var _DJ = $get($_.options, 'debugcws') !== undefined; //#14977
    if (_DJ) { //#14977
        $k[$j++] = 'bwipp.debugcws#14977'; //#14977
        $k[$j++] = $_.cws; //#14977
        bwipp_raiseerror(); //#14977
    } //#14977
    if (!bwipp_code16k.__15013__) { //#15013
        $_ = Object.create($_); //#15013
        $_.encs = $a(["212222", "222122", "222221", "121223", "121322", "131222", "122213", "122312", "132212", "221213", "221312", "231212", "112232", "122132", "122231", "113222", "123122", "123221", "223211", "221132", "221231", "213212", "223112", "312131", "311222", "321122", "321221", "312212", "322112", "322211", "212123", "212321", "232121", "111323", "131123", "131321", "112313", "132113", "132311", "211313", "231113", "231311", "112133", "112331", "132131", "113123", "113321", "133121", "313121", "211331", "231131", "213113", "213311", "213131", "311123", "311321", "331121", "312113", "312311", "332111", "314111", "221411", "431111", "111224", "111422", "121124", "121421", "141122", "141221", "112214", "112412", "122114", "122411", "142112", "142211", "241211", "221114", "413111", "241112", "134111", "111242", "121142", "121241", "114212", "124112", "124211", "411212", "421112", "421211", "212141", "214121", "412121", "111143", "111341", "131141", "114113", "114311", "411113", "411311", "113141", "114131", "311141", "411131", "211412", "211214", "211232", "211133"]); //#14998
        $_.startencs = $a(["3211", "2221", "2122", "1411", "1132", "1231", "1114", "3112", "3211", "2221", "2122", "1411", "1132", "1231", "1114", "3112"]); //#15004
        $_.stopencsodd = $a(["3211", "2221", "2122", "1411", "1132", "1231", "1114", "3112", "1132", "1231", "1114", "3112", "3211", "2221", "2122", "1411"]); //#15008
        $_.stopencseven = $a(["2122", "1411", "1132", "1231", "1114", "3112", "1132", "1231", "1114", "3112", "3211", "2221", "2122", "1411", "3211", "2221"]); //#15012
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_code16k.$ctx[id] = $_[id]); //#15012
        bwipp_code16k.__15013__ = 1; //#15012
        $_ = Object.getPrototypeOf($_); //#15012
    } //#15012
    if (($_.sam == -1) || (((~~($_.sam / 10)) % 2) == 1)) { //#15018
        $_.stopencs = $_.stopencsodd; //#15016
    } else { //#15018
        $_.stopencs = $_.stopencseven; //#15018
    } //#15018
    $_.rowbits = $a($_.r); //#15022
    for (var _DY = 0, _DX = $f($_.r - 1); _DY <= _DX; _DY += 1) { //#15039
        $_.i = _DY; //#15024
        $k[$j++] = Infinity; //#15025
        $k[$j++] = 10; //#15027
        $forall($get($_.startencs, $_.i), function() { //#15027
            var _Dc = $k[--$j]; //#15027
            $k[$j++] = $f(_Dc - 48); //#15027
        }); //#15027
        var _Df = $geti($_.cws, $_.i * 5, 5); //#15029
        $k[$j++] = 1; //#15031
        for (var _Dg = 0, _Dh = _Df.length; _Dg < _Dh; _Dg++) { //#15031
            $forall($get($_.encs, $get(_Df, _Dg)), function() { //#15030
                var _Dl = $k[--$j]; //#15030
                $k[$j++] = $f(_Dl - 48); //#15030
            }); //#15030
        } //#15030
        $forall($get($_.stopencs, $_.i), function() { //#15032
            var _Dp = $k[--$j]; //#15032
            $k[$j++] = $f(_Dp - 48); //#15032
        }); //#15032
        $k[$j++] = 1; //#15033
        $_.sbs = $a(); //#15033
        $k[$j++] = Infinity; //#15035
        var _Dr = $_.sbs; //#15036
        $k[$j++] = 1; //#15036
        for (var _Ds = 0, _Dt = _Dr.length; _Ds < _Dt; _Ds++) { //#15036
            var _Dv = $k[--$j]; //#15036
            var _Dw = (_Dv == 0) ? 1 : 0; //#15036
            $k[$j++] = _Dv; //#15036
            for (var _Dx = 0, _Dy = $get(_Dr, _Ds); _Dx < _Dy; _Dx++) { //#15036
                $k[$j++] = _Dw //#15036
            } //#15036
        } //#15036
        $astore($a($counttomark() - 1)); //#15037
        var _E1 = $k[--$j]; //#15037
        var _E2 = $k[--$j]; //#15037
        $k[$j++] = _E1; //#15037
        $k[$j++] = _E2; //#15037
        $j--; //#15037
        var _E3 = $k[--$j]; //#15037
        var _E4 = $k[--$j]; //#15037
        $k[$j++] = _E3; //#15037
        $k[$j++] = _E4; //#15037
        $j--; //#15037
        $put($_.rowbits, $_.i, $k[--$j]); //#15038
    } //#15038
    $k[$j++] = Infinity; //#15042
    for (var _E9 = 0, _EA = 81 * $_.sepheight; _E9 < _EA; _E9++) { //#15043
        $k[$j++] = 1; //#15043
    } //#15043
    for (var _ED = 0, _EC = $f($_.r - 2); _ED <= _EC; _ED += 1) { //#15048
        $_.i = _ED; //#15045
        for (var _EF = 0, _EG = $_.rowheight; _EF < _EG; _EF++) { //#15046
            $aload($get($_.rowbits, $_.i)); //#15046
        } //#15046
        for (var _EL = 0, _EM = $_.sepheight; _EL < _EM; _EL++) { //#15047
            for (var _EN = 0, _EO = 10; _EN < _EO; _EN++) { //#15047
                $k[$j++] = 0; //#15047
            } //#15047
            for (var _EP = 0, _EQ = 70; _EP < _EQ; _EP++) { //#15047
                $k[$j++] = 1; //#15047
            } //#15047
            $k[$j++] = 0; //#15047
        } //#15047
    } //#15047
    for (var _ES = 0, _ET = $_.rowheight; _ES < _ET; _ES++) { //#15049
        $aload($get($_.rowbits, $f($_.r - 1))); //#15049
    } //#15049
    for (var _EY = 0, _EZ = 81 * $_.sepheight; _EY < _EZ; _EY++) { //#15050
        $k[$j++] = 1; //#15050
    } //#15050
    $_.pixs = $a(); //#15050
    var _Ef = new Map([
        ["ren", 'renmatrix'],
        ["pixs", $_.pixs],
        ["pixx", 81],
        ["pixy", ~~($_.pixs.length / 81)],
        ["height", (~~($_.pixs.length / 81)) / 72],
        ["width", 81 / 72],
        ["opt", $_.options]
    ]); //#15061
    $k[$j++] = _Ef; //#15064
    if (!$_.dontdraw) { //#15064
        bwipp_renmatrix(); //#15064
    } //#15064
    $_ = Object.getPrototypeOf($_); //#15066
    $_ = Object.getPrototypeOf($_); //#15068
} //bwipp_code16k
function bwipp_code49() {
    $_ = Object.create($_); //#15099
    $_.dontdraw = false; //#15102
    $_.sam = -1; //#15103
    $_.append = false; //#15104
    $_.rows = 0; //#15105
    $_.rowheight = 8; //#15106
    $_.sepheight = 1; //#15107
    $_.parse = false; //#15108
    $_.parsefnc = false; //#15109
    $k[$j++] = $_; //#15111
    bwipp_processoptions(); //#15111
    $_.options = $k[--$j]; //#15111
    $_.barcode = $k[--$j]; //#15112
    if (($_.rows != 0) && (($_.rows < 2) || ($_.rows > 8))) { //#15116
        $k[$j++] = 'bwipp.code49badRows#15115'; //#15115
        $k[$j++] = "Code 49 must have 2 to 8 rows"; //#15115
        bwipp_raiseerror(); //#15115
    } //#15115
    if ($_.rowheight < 8) { //#15120
        $k[$j++] = 'bwipp.code49badRowHeight#15119'; //#15119
        $k[$j++] = "Code 49 must have rowheight of at least 8"; //#15119
        bwipp_raiseerror(); //#15119
    } //#15119
    if ($_.sepheight < 1) { //#15124
        $k[$j++] = 'bwipp.code49badSepHeight#15123'; //#15123
        $k[$j++] = "Code 49 must have sepheight of at least 1"; //#15123
        bwipp_raiseerror(); //#15123
    } //#15123
    if ($_.append && ($_.sam != -1)) { //#15128
        $k[$j++] = 'bwipp.code49samAndAppend#15127'; //#15127
        $k[$j++] = "sam and append cannot be specified together"; //#15127
        bwipp_raiseerror(); //#15127
    } //#15127
    if ($_.sam != -1) { //#15140
        $k[$j++] = true; //#15136
        for (var _A = 0, _B = 1; _A < _B; _A++) { //#15136
            var _C = $_.sam; //#15133
            if ((_C < 12) || (_C > 99)) { //#15133
                $j--; //#15133
                $k[$j++] = false; //#15133
                break; //#15133
            } //#15133
            if (($_.sam % 10) < 2) { //#15134
                $j--; //#15134
                $k[$j++] = false; //#15134
                break; //#15134
            } //#15134
            if ((~~($_.sam / 10)) > ($_.sam % 10)) { //#15135
                $j--; //#15135
                $k[$j++] = false; //#15135
                break; //#15135
            } //#15135
        } //#15135
        if ($nt($k[--$j])) { //#15139
            $k[$j++] = 'bwipp.code49badSAM#15138'; //#15138
            $k[$j++] = "SAM must be formatted as \"NM\" for Nth of M symbols, from 2 to 9 symbols"; //#15138
            bwipp_raiseerror(); //#15138
        } //#15138
    } //#15138
    bwipp_loadctx(bwipp_code49) //#15142
    if (!bwipp_code49.__15146__) { //#15146
        $_ = Object.create($_); //#15146
        $_.s1 = -1; //#15145
        $_.s2 = -2; //#15145
        $_.fn1 = -3; //#15145
        $_.fn2 = -4; //#15145
        $_.fn3 = -5; //#15145
        $_.ns = -6; //#15145
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_code49.$ctx[id] = $_[id]); //#15145
        bwipp_code49.__15146__ = 1; //#15145
        $_ = Object.getPrototypeOf($_); //#15145
    } //#15145
    var _N = new Map([
        ["parse", $_.parse],
        ["parsefnc", $_.parsefnc],
        ["FNC1", $_.fn1],
        ["FNC2", $_.fn2],
        ["FNC3", $_.fn3]
    ]); //#15154
    $_.fncvals = _N; //#15155
    $k[$j++] = 'msg'; //#15156
    $k[$j++] = $_.barcode; //#15156
    $k[$j++] = $_.fncvals; //#15156
    bwipp_parseinput(); //#15156
    var _Q = $k[--$j]; //#15156
    $_[$k[--$j]] = _Q; //#15156
    $_.msglen = $_.msg.length; //#15157
    $forall($_.msg, function() { //#15163
        if ($k[--$j] > 127) { //#15162
            $k[$j++] = 'bwipp.code49badCharacter#15161'; //#15161
            $k[$j++] = "Code 49 can only support ASCII characters with values 0 to 127"; //#15161
            bwipp_raiseerror(); //#15161
        } //#15161
    }); //#15161
    if (!bwipp_code49.__15205__) { //#15205
        $_ = Object.create($_); //#15205
        $_.charmap = $a(["0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "-", ".", " ", "$", "/", "+", "%", $_.s1, $_.s2, $_.fn1, $_.fn2, $_.fn3, $_.ns]); //#15173
        $_.charvals = new Map; //#15176
        for (var _c = 0; _c <= 48; _c += 1) { //#15182
            $_.i = _c; //#15178
            var _f = $get($_.charmap, $_.i); //#15179
            $k[$j++] = _f; //#15180
            if ($eq($type(_f), 'stringtype')) { //#15180
                var _i = $get($k[--$j], 0); //#15180
                $k[$j++] = _i; //#15180
            } //#15180
            $put($_.charvals, $k[--$j], $_.i); //#15181
        } //#15181
        $_.combos = $a(["1 ", "1A", "1B", "1C", "1D", "1E", "1F", "1G", "1H", "1I", "1J", "1K", "1L", "1M", "1N", "1O", "1P", "1Q", "1R", "1S", "1T", "1U", "1V", "1W", "1X", "1Y", "1Z", "11", "12", "13", "14", "15", "  ", "16", "17", "18", " $", " %", "19", "10", "1-", "1.", "1$", " +", "1/", " -", " .", " /", " 0", " 1", " 2", " 3", " 4", " 5", " 6", " 7", " 8", " 9", "1+", "21", "22", "23", "24", "25", "26", " A", " B", " C", " D", " E", " F", " G", " H", " I", " J", " K", " L", " M", " N", " O", " P", " Q", " R", " S", " T", " U", " V", " W", " X", " Y", " Z", "27", "28", "29", "20", "2-", "2.", "2A", "2B", "2C", "2D", "2E", "2F", "2G", "2H", "2I", "2J", "2K", "2L", "2M", "2N", "2O", "2P", "2Q", "2R", "2S", "2T", "2U", "2V", "2W", "2X", "2Y", "2Z", "2$", "2/", "2+", "2%", "2 "]); //#15194
        for (var _n = 0; _n <= 127; _n += 1) { //#15204
            $_.i = _n; //#15196
            var _q = $get($_.combos, $_.i); //#15197
            $_.c1 = $get(_q, 0); //#15197
            $_.c2 = $get(_q, 1); //#15197
            if ($_.c1 == 49) { //#15200
                $put($_.charvals, $_.i, $a([$get($_.charvals, $_.s1), $get($_.charvals, $_.c2)])); //#15199
            } //#15199
            if ($_.c1 == 50) { //#15203
                $put($_.charvals, $_.i, $a([$get($_.charvals, $_.s2), $get($_.charvals, $_.c2)])); //#15202
            } //#15202
        } //#15202
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_code49.$ctx[id] = $_[id]); //#15202
        bwipp_code49.__15205__ = 1; //#15202
        $_ = Object.getPrototypeOf($_); //#15202
    } //#15202
    $_.encodealpha = function() {
        var _1G = $get($_.charvals, $k[--$j]); //#15208
        $k[$j++] = _1G; //#15209
        if ($ne($type(_1G), 'arraytype')) { //#15209
            $astore($a(1)); //#15209
        } //#15209
        var _1J = $k[--$j]; //#15210
        $puti($_.cws, $_.j, _1J); //#15210
        $_.j = _1J.length + $_.j; //#15211
    }; //#15211
    $_.base48 = function() {
        var _1N = $k[--$j]; //#15215
        $k[$j++] = 0; //#15215
        $forall(_1N, function() { //#15215
            var _1O = $k[--$j]; //#15215
            var _1P = $k[--$j]; //#15215
            $k[$j++] = $f($f(_1O - 48) + (_1P * 10)); //#15215
        }); //#15215
        $k[$j++] = Infinity; //#15216
        var _1Q = $k[--$j]; //#15216
        var _1R = $k[--$j]; //#15216
        var _1S = $k[--$j]; //#15216
        $k[$j++] = _1Q; //#15216
        $k[$j++] = _1R; //#15216
        for (var _1T = 0, _1U = $f(_1S - 1); _1T < _1U; _1T++) { //#15216
            var _1V = $k[--$j]; //#15216
            $k[$j++] = _1V % 48; //#15216
            $k[$j++] = ~~(_1V / 48); //#15216
        } //#15216
        var _1W = $a(); //#15216
        $k[$j++] = _1W; //#15217
        $k[$j++] = Infinity; //#15217
        var _1X = $k[--$j]; //#15217
        var _1Y = $k[--$j]; //#15217
        $k[$j++] = _1X; //#15217
        $k[$j++] = _1Y; //#15217
        for (var _1Z = _1Y.length - 1; _1Z >= 0; _1Z -= 1) { //#15217
            var _1a = $k[--$j]; //#15217
            $k[$j++] = $get(_1a, _1Z); //#15217
            $k[$j++] = _1a; //#15217
        } //#15217
        $j--; //#15217
        var _1c = $a(); //#15217
        $puti($_.cws, $_.j, _1c); //#15218
        $_.j = _1c.length + $_.j; //#15219
    }; //#15219
    $_.encodenumeric = function() {
        $_.nums = $k[--$j]; //#15223
        var _1i = $_.nums.length; //#15224
        var _1j = _1i % 5; //#15224
        $k[$j++] = 'pre'; //#15224
        $k[$j++] = _1i; //#15224
        $k[$j++] = _1j; //#15224
        if (_1j != 2) { //#15224
            var _1k = $k[--$j]; //#15224
            var _1l = $k[--$j]; //#15224
            $k[$j++] = $f(_1l - _1k); //#15224
        } else { //#15224
            var _1m = $k[--$j]; //#15224
            var _1n = $k[--$j]; //#15224
            $k[$j++] = $f($f(_1n - _1m) - 5); //#15224
        } //#15224
        var _1o = $k[--$j]; //#15224
        $_[$k[--$j]] = _1o; //#15224
        for (var _1s = 0, _1r = $f($_.pre - 1); _1s <= _1r; _1s += 5) { //#15225
            $k[$j++] = 3; //#15225
            $k[$j++] = $geti($_.nums, _1s, 5); //#15225
            $_.base48(); //#15225
        } //#15225
        $_.nums = $geti($_.nums, $_.pre, $f($_.nums.length - $_.pre)); //#15226
        var _21 = $_.nums.length; //#15228
        $k[$j++] = _21; //#15228
        if (_21 == 1) { //#15228
            $k[$j++] = $get($_.nums, $_.i); //#15228
            $_.encodealpha(); //#15228
        } //#15228
        var _25 = $k[--$j]; //#15229
        $k[$j++] = _25; //#15229
        if (_25 == 3) { //#15229
            $k[$j++] = 2; //#15229
            $k[$j++] = $_.nums; //#15229
            $_.base48(); //#15229
        } //#15229
        var _27 = $k[--$j]; //#15230
        $k[$j++] = _27; //#15230
        if (_27 == 4) { //#15230
            $k[$j++] = 3; //#15230
            $k[$j++] = Infinity; //#15230
            $k[$j++] = 49; //#15230
            $k[$j++] = 48; //#15230
            $aload($_.nums); //#15230
            var _29 = $a(); //#15230
            $k[$j++] = _29; //#15230
            $_.base48(); //#15230
        } //#15230
        if ($k[--$j] == 7) { //#15234
            $k[$j++] = 3; //#15232
            $k[$j++] = Infinity; //#15232
            $k[$j++] = 49; //#15232
            $k[$j++] = 48; //#15232
            $aload($geti($_.nums, 0, 4)); //#15232
            var _2D = $a(); //#15232
            $k[$j++] = _2D; //#15232
            $_.base48(); //#15232
            $k[$j++] = 2; //#15233
            $k[$j++] = $geti($_.nums, 4, 3); //#15233
            $_.base48(); //#15233
        } //#15233
    }; //#15233
    $k[$j++] = Infinity; //#15238
    for (var _2H = 0, _2I = $_.msglen; _2H < _2I; _2H++) { //#15238
        $k[$j++] = 0; //#15238
    } //#15238
    $k[$j++] = 0; //#15238
    $_.numericruns = $a(); //#15238
    for (var _2L = $_.msglen - 1; _2L >= 0; _2L -= 1) { //#15247
        $_.i = _2L; //#15240
        var _2O = $get($_.msg, $_.i); //#15241
        if ((_2O >= 48) && (_2O <= 57)) { //#15245
            $put($_.numericruns, $_.i, $f($get($_.numericruns, $_.i + 1) + 1)); //#15243
        } else { //#15245
            $put($_.numericruns, $_.i, 0); //#15245
        } //#15245
    } //#15245
    $_.cws = $a(($_.msglen * 2) + 1); //#15249
    if (!bwipp_code49.__15262__) { //#15262
        $_ = Object.create($_); //#15262
        $_.samval = $a([12, 22, 13, 23, 33, 14, 24, 34, 44, 15, 25, 35, 45, 55, 16, 26, 36, 46, 56, 66, 17, 27, 37, 47, 57, 67, 77, 18, 28, 38, 48, 58, 68, 78, 88, 19, 29, 39, 49, 59, 69, 79, 89, 99]); //#15261
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_code49.$ctx[id] = $_[id]); //#15261
        bwipp_code49.__15262__ = 1; //#15261
        $_ = Object.getPrototypeOf($_); //#15261
    } //#15261
    for (;;) { //#15298
        if ($_.append) { //#15271
            $_.mode = 1; //#15267
            $_.method = "alpha"; //#15268
            $_.i = 0; //#15269
            $_.j = 0; //#15269
            break; //#15270
        } //#15270
        if ($_.sam != -1) { //#15278
            $_.mode = 3; //#15273
            $k[$j++] = $_.cws; //#15274
            $k[$j++] = 0; //#15274
            for (var _2d = 0; _2d <= 43; _2d += 1) { //#15274
                $k[$j++] = _2d; //#15274
                if ($get($_.samval, _2d) != $_.sam) { //#15274
                    $j--; //#15274
                } //#15274
            } //#15274
            var _2h = $k[--$j]; //#15274
            var _2i = $k[--$j]; //#15274
            $put($k[--$j], _2i, $f(_2h + 1)); //#15274
            $_.method = "alpha"; //#15275
            $_.i = 0; //#15276
            $_.j = 1; //#15276
            break; //#15277
        } //#15277
        if ($get($_.numericruns, 0) >= 5) { //#15283
            $_.mode = 2; //#15280
            $_.method = "numeric"; //#15281
            $_.i = 0; //#15281
            $_.j = 0; //#15281
            break; //#15282
        } //#15282
        var _2p = $get($_.charvals, $get($_.msg, 0)); //#15284
        $k[$j++] = _2p; //#15291
        if ($ne($type(_2p), 'arraytype')) { //#15291
            $j--; //#15286
            $_.mode = 0; //#15287
            $_.method = "alpha"; //#15288
            $_.i = 0; //#15289
            $_.j = 0; //#15289
            break; //#15290
        } //#15290
        var _2t = ($get($k[--$j], 0) == 43) ? 4 : 5; //#15293
        $_.mode = _2t; //#15293
        $put($_.cws, 0, $get($get($_.charvals, $get($_.msg, 0)), 1)); //#15294
        $_.method = "alpha"; //#15295
        $_.i = 1; //#15296
        $_.j = 1; //#15296
        break; //#15297
    } //#15297
    for (;;) { //#15325
        if ($_.i == $_.msglen) { //#15302
            break; //#15302
        } //#15302
        for (;;) { //#15324
            if ($eq($_.method, "alpha")) { //#15313
                if ($get($_.numericruns, $_.i) >= 5) { //#15309
                    $k[$j++] = $_.ns; //#15306
                    $_.encodealpha(); //#15306
                    $_.method = "numeric"; //#15307
                    break; //#15308
                } //#15308
                $k[$j++] = $get($_.msg, $_.i); //#15310
                $_.encodealpha(); //#15310
                $_.i = $_.i + 1; //#15311
                break; //#15312
            } //#15312
            if ($eq($_.method, "numeric")) { //#15323
                if ($get($_.numericruns, $_.i) < 5) { //#15319
                    $k[$j++] = $_.ns; //#15316
                    $_.encodealpha(); //#15316
                    $_.method = "alpha"; //#15317
                    break; //#15318
                } //#15318
                $k[$j++] = $geti($_.msg, $_.i, $get($_.numericruns, $_.i)); //#15320
                $_.encodenumeric(); //#15320
                $_.i = $f($_.i + $get($_.numericruns, $_.i)); //#15321
                break; //#15322
            } //#15322
        } //#15322
    } //#15322
    $_.cws = $geti($_.cws, 0, $_.j); //#15326
    if (!bwipp_code49.__15340__) { //#15340
        $_ = Object.create($_); //#15340
        $_.metrics = $a([$a([2, 9]), $a([3, 16]), $a([4, 23]), $a([5, 30]), $a([6, 37]), $a([7, 42]), $a([8, 49])]); //#15339
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_code49.$ctx[id] = $_[id]); //#15339
        bwipp_code49.__15340__ = 1; //#15339
        $_ = Object.getPrototypeOf($_); //#15339
    } //#15339
    $_.urows = $_.rows; //#15343
    var _3d = $_.metrics; //#15344
    for (var _3e = 0, _3f = _3d.length; _3e < _3f; _3e++) { //#15352
        $_.m = $get(_3d, _3e); //#15345
        $_.r = $get($_.m, 0); //#15346
        $_.dcws = $get($_.m, 1); //#15347
        $_.okay = true; //#15348
        if (($_.urows != 0) && ($_.urows != $_.r)) { //#15349
            $_.okay = false; //#15349
        } //#15349
        if ($_.cws.length > $_.dcws) { //#15350
            $_.okay = false; //#15350
        } //#15350
        if ($_.okay) { //#15351
            break; //#15351
        } //#15351
    } //#15351
    if (!$_.okay) { //#15356
        $k[$j++] = 'bwipp.code49noValidSymbol#15355'; //#15355
        $k[$j++] = "Maximum length exceeded"; //#15355
        bwipp_raiseerror(); //#15355
    } //#15355
    $k[$j++] = Infinity; //#15359
    $aload($_.cws); //#15359
    for (var _3v = 0, _3w = $f($_.dcws - $_.cws.length); _3v < _3w; _3v++) { //#15359
        $k[$j++] = 48; //#15359
    } //#15359
    $_.cws = $a(); //#15359
    $_.ccs = $a($_.r * 8); //#15362
    $_.j = 0; //#15363
    for (var _42 = 0, _41 = $f($_.r - 2); _42 <= _41; _42 += 1) { //#15370
        $_.i = _42; //#15365
        $_.cc = $geti($_.cws, $_.j, 7); //#15366
        $puti($_.ccs, $_.i * 8, $_.cc); //#15367
        var _4B = $_.cc; //#15368
        $k[$j++] = $_.ccs; //#15368
        $k[$j++] = ($_.i * 8) + 7; //#15368
        $k[$j++] = 0; //#15368
        for (var _4C = 0, _4D = _4B.length; _4C < _4D; _4C++) { //#15368
            var _4F = $k[--$j]; //#15368
            $k[$j++] = $f(_4F + $get(_4B, _4C)); //#15368
        } //#15368
        var _4G = $k[--$j]; //#15368
        var _4H = $k[--$j]; //#15368
        $put($k[--$j], _4H, _4G % 49); //#15368
        $_.j = $_.j + 7; //#15369
    } //#15369
    if ($_.j < $_.dcws) { //#15373
        $puti($_.ccs, $_.ccs.length - 8, $geti($_.cws, $_.j, $f($_.dcws - $_.j))); //#15372
    } //#15372
    $_.cr7 = $f(($f($_.r - 2) * 7) + $_.mode); //#15376
    $put($_.ccs, $_.ccs.length - 2, $_.cr7); //#15377
    if (!bwipp_code49.__15386__) { //#15386
        $_ = Object.create($_); //#15386
        var _4Y = $a([1, 9, 31, 26, 2, 12, 17, 23, 37, 18, 22, 6, 27, 44, 15, 43, 39, 11, 13, 5, 41, 33, 36, 8, 4, 32, 3, 19, 40, 25, 29, 10, 24, 30]); //#15382
        $k[$j++] = _4Y; //#15383
        $k[$j++] = _4Y; //#15383
        $k[$j++] = Infinity; //#15383
        var _4Z = $k[--$j]; //#15383
        var _4b = $geti($k[--$j], 0, 32); //#15383
        $k[$j++] = _4Z; //#15383
        $k[$j++] = 20; //#15383
        $aload(_4b); //#15383
        $_.weightx = $a(); //#15383
        var _4d = $k[--$j]; //#15384
        $k[$j++] = _4d; //#15384
        $k[$j++] = _4d; //#15384
        $k[$j++] = Infinity; //#15384
        var _4e = $k[--$j]; //#15384
        var _4g = $geti($k[--$j], 1, 32); //#15384
        $k[$j++] = _4e; //#15384
        $k[$j++] = 16; //#15384
        $aload(_4g); //#15384
        $_.weighty = $a(); //#15384
        $k[$j++] = Infinity; //#15385
        var _4i = $k[--$j]; //#15385
        var _4k = $geti($k[--$j], 2, 32); //#15385
        $k[$j++] = _4i; //#15385
        $k[$j++] = 38; //#15385
        $aload(_4k); //#15385
        $_.weightz = $a(); //#15385
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_code49.$ctx[id] = $_[id]); //#15385
        bwipp_code49.__15386__ = 1; //#15385
        $_ = Object.getPrototypeOf($_); //#15385
    } //#15385
    $_.calccheck = function() {
        $_.weights = $k[--$j]; //#15388
        $_.score = 0; //#15389
        for (var _4q = 0, _4p = (~~(($f($_.r - 1) * 8) / 2)) - 1; _4q <= _4p; _4q += 1) { //#15394
            $_.i = _4q; //#15391
            $_.score = $f((($f(($get($_.ccs, $_.i * 2) * 49) + $get($_.ccs, ($_.i * 2) + 1))) * $get($_.weights, $_.i + 1)) + $_.score); //#15393
        } //#15393
        $k[$j++] = $_.score; //#15395
    }; //#15395
    $_.lastrow = $geti($_.ccs, $_.ccs.length - 8, 8); //#15397
    if ($_.r >= 7) { //#15404
        $k[$j++] = $_.cr7 * $get($_.weightz, 0); //#15401
        $k[$j++] = $_.weightz; //#15401
        $_.calccheck(); //#15401
        var _5A = $k[--$j]; //#15401
        var _5C = $f($k[--$j] + _5A) % 2401; //#15402
        $k[$j++] = ~~(_5C / 49); //#15402
        $k[$j++] = _5C % 49; //#15402
        $astore($a(2)); //#15402
        $puti($_.lastrow, 0, $k[--$j]); //#15403
    } //#15403
    $_.wr1 = $f(($get($_.lastrow, 0) * 49) + $get($_.lastrow, 1)); //#15405
    $k[$j++] = $_.cr7 * $get($_.weighty, 0); //#15408
    $k[$j++] = $_.weighty; //#15408
    $_.calccheck(); //#15408
    var _5O = $k[--$j]; //#15408
    var _5U = ($f($f($k[--$j] + _5O) + ($_.wr1 * $get($_.weighty, $f(($_.r * 4) - 3))))) % 2401; //#15410
    $_.wr2 = _5U; //#15410
    $k[$j++] = ~~(_5U / 49); //#15411
    $k[$j++] = _5U % 49; //#15411
    $astore($a(2)); //#15411
    $puti($_.lastrow, 2, $k[--$j]); //#15412
    $k[$j++] = $_.cr7 * $get($_.weightx, 0); //#15415
    $k[$j++] = $_.weightx; //#15415
    $_.calccheck(); //#15415
    var _5c = $k[--$j]; //#15415
    var _5m = ($f(($f($f($k[--$j] + _5c) + ($_.wr1 * $get($_.weightx, $f(($_.r * 4) - 3))))) + ($_.wr2 * $get($_.weightx, $f(($_.r * 4) - 2))))) % 2401; //#15419
    $k[$j++] = ~~(_5m / 49); //#15419
    $k[$j++] = _5m % 49; //#15419
    $astore($a(2)); //#15419
    $puti($_.lastrow, 4, $k[--$j]); //#15420
    var _5s = $geti($_.ccs, $_.ccs.length - 8, 7); //#15423
    $k[$j++] = 0; //#15423
    for (var _5t = 0, _5u = _5s.length; _5t < _5u; _5t++) { //#15423
        var _5w = $k[--$j]; //#15423
        $k[$j++] = $f(_5w + $get(_5s, _5t)); //#15423
    } //#15423
    $put($_.ccs, $_.ccs.length - 1, $k[--$j] % 49); //#15424
    var _61 = $get($_.options, 'debugcws') !== undefined; //#15426
    if (_61) { //#15426
        $k[$j++] = 'bwipp.debugcws#15426'; //#15426
        $k[$j++] = $_.ccs; //#15426
        bwipp_raiseerror(); //#15426
    } //#15426
    if (!bwipp_code49.__16124__) { //#16124
        $_ = Object.create($_); //#16124
        $_.patterns = $a([$a(["11521132", "25112131", "14212132", "25121221", "14221222", "12412132", "23321221", "12421222", "21521221", "15112222", "15121312", "13312222", "24221311", "13321312", "11512222", "22421311", "11521312", "25112311", "14212312", "23312311", "12412312", "21512311", "16121131", "14321131", "12521131", "15212131", "15221221", "13412131", "13421221", "11612131", "16112221", "16121311", "14312221", "14321311", "12512221", "12521311", "15212311", "13412311", "11612311", "11131135", "31131133", "51131131", "21122134", "41122132", "21131224", "41131222", "11113135", "31113133", "51113131", "11122225", "31122223", "51122221", "11131315", "31131313", "51131311", "21113224", "41113222", "21122314", "41122312", "11113315", "31113313", "51113311", "12131134", "32131132", "21231133", "41231131", "22122133", "42122131", "11222134", "22131223", "42131221", "11231224", "31231222", "12113134", "32113132", "12122224", "32122222", "12131314", "32131312", "21231313", "41231311", "22113223", "42113221", "11213224", "22122313", "42122311", "11222314", "31222312", "12113314", "32113312", "21213313", "41213311", "13131133", "33131131", "22231132", "11331133", "31331131", "23122132", "12222133", "23131222", "12231223", "32231221", "21331222", "13113133", "33113131", "13122223", "33122221", "11313133", "13131313", "33131311", "11322223", "22231312", "11331313", "31331311", "23113222", "12213223", "23122312", "12222313", "32222311", "21322312", "13113313", "33113311", "22213312", "11313313", "31313311", "14131132", "23231131", "12331132", "21431131", "24122131", "13222132", "24131221", "13231222", "11422132", "22331221", "11431222", "14113132", "14122222", "12313132", "14131312", "12322222", "23231311", "12331312", "21431311", "24113221", "13213222", "24122311", "13222312", "11413222", "22322311", "11422312", "14113312", "23213311", "12313312", "21413311", "15131131", "13331131", "14222131", "14231221", "12422131", "12431221", "15113131", "15122221", "13313131", "15131311", "13322221", "11513131", "13331311", "11522221", "14213221", "14222311", "12413221", "12422311", "15113311", "13313311", "11513311", "11141134", "31141132", "21132133", "41132131", "21141223", "41141221", "11123134", "31123132", "11132224", "31132222", "11141314", "31141312", "21114133", "41114131", "21123223", "41123221", "21132313", "41132311", "11114224", "31114222", "11123314", "31123312", "21114313", "41114311", "12141133", "32141131", "21241132", "22132132", "11232133", "22141222", "11241223", "31241221", "12123133", "32123131", "12132223", "32132221", "12141313", "32141311", "21241312", "22114132", "11214133", "22123222", "11223223", "22132312", "11232313", "31232311", "12114223", "32114221", "12123313", "32123311", "21223312", "22114312", "11214313", "31214311", "13141132", "22241131", "11341132", "23132131", "12232132", "23141221", "12241222", "21341221", "13123132", "13132222", "11323132", "13141312", "11332222", "22241311", "11341312", "23114131", "12214132", "23123221", "12223222", "23132311", "12232312", "21332311", "13114222", "13123312", "11314222", "22223311", "11323312", "23114311", "12214312", "21314311", "14141131", "12341131", "13232131", "13241221", "11432131", "14123131", "14132221", "12323131", "14141311", "12332221", "12341311", "13214131", "13223221", "11414131", "13232311", "11423221", "11432311", "14114221", "14123311", "12314221", "12323311", "13214311", "11414311", "11151133", "31151131", "21142132", "21151222", "11133133", "31133131", "11142223", "31142221", "11151313", "31151311", "21124132", "21133222", "21142312", "11115133", "31115131", "11124223", "31124221", "11133313", "31133311", "21115222", "21124312", "12151132", "21251131", "22142131", "11242132", "22151221", "11251222", "12133132", "12142222", "12151312", "21251311", "22124131", "11224132", "22133221", "11233222", "22142311", "11242312", "12115132", "12124222", "12133312", "21233311", "22115221", "11215222", "22124311", "11224312", "13151131", "12242131", "12251221", "13133131", "13142221", "11333131", "13151311", "11342221", "12224131", "12233221", "12242311", "13115131", "13124221", "11315131", "13133311", "11324221", "11333311", "12215221", "12224311", "11161132", "21152131", "21161221", "11143132", "11152222", "11161312", "21134131", "21143221", "21152311", "11125132", "11134222", "11143312", "21116131", "21125221", "21134311", "12161131", "11252131", "12143131", "12152221", "12161311", "11234131", "11243221", "11252311", "12125131", "12134221", "12143311", "11216131", "11225221", "11234311", "11111236", "31111234", "51111232", "21111325", "41111323", "61111321", "11111416", "31111414", "51111412", "31211143", "51211141", "12111235", "32111233", "52111231", "21211234", "41211232", "22111324", "42111322", "11211325", "31211323", "51211321", "12111415", "32111413", "52111411", "21211414", "41211412", "12211144", "32211142", "21311143", "41311141", "13111234", "33111232", "22211233", "42211231", "11311234", "31311232", "23111323", "43111321", "12211324", "32211322", "21311323", "41311321", "13111414", "33111412", "22211413", "42211411", "11311414", "31311412", "13211143", "33211141", "22311142", "11411143", "31411141", "14111233", "34111231", "23211232", "12311233", "32311231", "21411232", "24111322", "13211323", "33211321", "22311322", "11411323", "31411321", "14111413", "34111411", "23211412", "12311413", "32311411", "21411412", "14211142", "23311141", "12411142", "21511141", "15111232", "24211231", "13311232", "22411231", "11511232", "25111321", "14211322", "23311321", "12411322", "21511321", "15111412", "24211411", "13311412", "22411411", "11511412", "15211141", "13411141", "11611141", "16111231", "14311231", "12511231", "15211321", "13411321", "11611321", "16111411", "14311411", "12511411", "21121144", "41121142", "11112145", "31112143", "51112141", "11121235", "31121233", "51121231", "21112234", "41112232", "21121324", "41121322", "11112325", "31112323", "51112321", "11121415", "31121413", "51121411", "21112414", "41112412", "22121143", "42121141", "11221144", "31221142", "12112144", "32112142", "12121234", "32121232", "21221233", "41221231", "22112233", "42112231", "11212234", "22121323", "42121321", "11221324", "31221322", "12112324", "32112322", "12121414", "32121412", "21221413", "41221411", "22112413", "42112411", "11212414", "31212412", "23121142", "12221143", "32221141", "21321142", "13112143", "33112141", "13121233", "33121231", "11312143", "22221232", "11321233", "31321231", "23112232", "12212233", "23121322", "12221323", "32221321", "21321322", "13112323", "33112321", "13121413", "33121411", "11312323", "22221412", "11321413", "31321411", "23112412", "12212413", "32212411", "21312412", "24121141", "13221142", "22321141", "11421142", "14112142", "14121232", "12312142", "23221231", "12321232", "21421231", "24112231", "13212232", "24121321", "13221322", "11412232", "22321321", "11421322", "14112322", "14121412", "12312322", "23221411", "12321412", "21421411", "24112411", "13212412", "22312411", "11412412", "14221141", "12421141", "15112141", "15121231", "13312141", "13321231", "11512141", "11521231", "14212231", "14221321", "12412231", "12421321", "15112321", "15121411", "13312321", "13321411", "11512321", "11521411", "14212411", "12412411", "21131143", "41131141", "11122144", "31122142", "11131234", "31131232", "21113143", "41113141", "21122233", "41122231", "21131323", "41131321", "11113234", "31113232", "11122324", "31122322", "11131414", "31131412", "21113323", "41113321", "21122413", "41122411", "11113414", "31113412", "22131142", "11231143", "31231141", "12122143", "32122141", "12131233", "32131231", "21231232", "22113142", "11213143", "22122232", "11222233", "22131322", "11231323", "31231321", "12113233", "32113231", "12122323", "32122321", "12131413", "32131411", "21231412", "22113322", "11213323", "22122412", "11222413", "31222411", "12113413", "32113411", "21213412", "23131141", "12231142", "21331141", "13122142", "13131232", "11322142", "22231231", "11331232", "23113141", "12213142", "23122231", "12222232", "23131321", "12231322", "21331321", "13113232", "13122322", "11313232", "13131412", "11322322", "22231411", "11331412", "23113321", "12213322", "23122411", "12222412", "21322411", "13113412", "22213411", "11313412", "13231141", "11431141", "14122141", "14131231", "12322141", "12331231", "13213141", "13222231", "11413141", "13231321", "11422231", "11431321", "14113231", "14122321", "12313231", "14131411", "12322321", "12331411", "13213321", "13222411", "11413321", "11422411", "14113411", "12313411", "21141142", "11132143", "31132141", "11141233", "31141231", "21123142", "21132232", "21141322", "11114143", "31114141", "11123233", "31123231", "11132323", "31132321", "11141413", "31141411", "21114232", "21123322", "21132412", "11114323", "31114321", "11123413", "31123411", "22141141", "11241142", "12132142", "12141232", "21241231", "22123141", "11223142", "22132231", "11232232", "22141321", "11241322", "12114142", "12123232", "12132322", "12141412", "21241411", "22114231", "11214232", "22123321", "11223322", "22132411", "11232412", "12114322", "12123412", "21223411", "12241141", "13132141", "13141231", "11332141", "11341231", "12223141", "12232231", "12241321", "13114141", "13123231", "11314141", "13132321", "11323231", "13141411", "11332321", "11341411", "12214231", "12223321", "12232411", "13114321", "13123411", "11314321", "11323411", "21151141", "11142142", "11151232", "21133141", "21142231", "21151321", "11124142", "11133232", "11142322", "11151412", "21115141", "21124231", "21133321", "21142411", "11115232", "11124322", "11133412", "11251141", "12142141", "12151231", "11233141", "11242231", "11251321", "12124141", "12133231", "12142321", "12151411", "11215141", "11224231", "11233321", "11242411", "12115231", "12124321", "12133411", "11152141", "11161231", "11134141", "11143231", "11152321", "11161411", "11116141", "11125231", "11134321", "11143411", "21111244", "41111242", "11111335", "31111333", "51111331", "21111424", "41111422", "11111515", "31111513", "51111511", "21211153", "41211151", "22111243", "42111241", "11211244", "31211242", "12111334", "32111332", "21211333", "41211331", "22111423", "42111421", "11211424", "31211422", "12111514", "32111512", "21211513", "41211511", "22211152", "11311153", "31311151", "23111242", "12211243", "32211241", "21311242", "13111333", "33111331", "22211332", "11311333", "31311331", "23111422", "12211423", "32211421", "21311422", "13111513", "33111511", "22211512", "11311513", "31311511", "23211151", "12311152", "21411151", "24111241", "13211242", "22311241", "11411242", "14111332", "23211331", "12311332", "21411331", "24111421", "13211422", "22311421", "11411422", "14111512", "23211511", "12311512", "21411511", "13311151", "11511151", "14211241", "12411241", "15111331", "13311331", "11511331", "14211421", "12411421", "15111511", "13311511", "11511511", "31121152", "21112153", "41112151", "21121243", "41121241", "11112244", "31112242", "11121334", "31121332", "21112333", "41112331", "21121423", "41121421", "11112424", "31112422", "11121514", "31121512", "21112513", "41112511", "12121153", "32121151", "21221152", "22112152", "11212153", "22121242", "11221243", "31221241", "12112243", "32112241", "12121333", "32121331", "21221332", "22112332", "11212333", "22121422", "11221423", "31221421", "12112423", "32112421", "12121513", "32121511", "21221512", "22112512", "11212513", "31212511", "13121152", "22221151", "11321152", "23112151", "12212152", "23121241", "12221242", "21321241", "13112242", "13121332", "11312242", "22221331", "11321332", "23112331", "12212332", "23121421", "12221422", "21321421", "13112422", "13121512", "11312422", "22221511", "11321512", "23112511", "12212512", "21312511", "14121151", "12321151", "13212151", "13221241", "11412151", "11421241", "14112241", "14121331", "12312241", "12321331", "13212331", "13221421", "11412331", "11421421", "14112421", "14121511", "12312421", "12321511", "13212511", "11412511", "11131153", "31131151", "21122152", "21131242", "11113153", "31113151", "11122243", "31122241", "11131333", "31131331", "21113242", "21122332", "21131422", "11113333", "31113331", "11122423", "31122421", "11131513", "31131511", "21113422", "21122512", "12131152", "21231151", "22122151", "11222152", "22131241", "11231242", "12113152", "12122242", "12131332", "21231331", "22113241", "11213242", "22122331", "11222332", "22131421", "11231422", "12113332", "12122422", "12131512", "21231511", "22113421", "11213422", "22122511", "11222512", "13131151", "11331151", "12222151", "12231241", "13113151", "13122241", "11313151", "13131331", "11322241", "11331331", "12213241", "12222331", "12231421", "13113331", "13122421", "11313331", "13131511", "11322421", "11331511", "12213421", "12222511", "11141152", "21132151", "21141241", "11123152", "11132242", "11141332", "21114151", "21123241", "21132331", "21141421", "11114242", "11123332", "11132422", "11141512", "21114331", "21123421", "21132511", "12141151", "11232151", "11241241", "12123151", "12132241", "12141331", "11214151", "11223241", "11232331", "11241421", "12114241", "12123331", "12132421", "12141511", "11214331", "11223421", "11232511", "11151151", "11133151", "11142241", "11151331", "11115151", "11124241", "11133331", "11142421", "11151511", "11111254", "31111252", "21111343", "41111341", "11111434", "31111432", "21111523", "41111521", "11111614", "31111612", "31211161", "12111253", "32111251", "21211252", "22111342", "11211343", "31211341", "12111433", "32111431", "21211432", "22111522", "11211523", "31211521", "12111613", "32111611", "21211612", "12211162", "21311161", "13111252", "22211251", "11311252", "23111341", "12211342", "21311341", "13111432", "22211431", "11311432", "23111521", "12211522", "21311521", "13111612", "22211611", "11311612", "13211161", "11411161", "14111251", "12311251", "13211341", "11411341", "14111431", "12311431", "13211521", "11411521", "14111611", "12311611", "21121162", "11112163", "31112161", "11121253", "31121251", "21112252", "21121342", "11112343", "31112341", "11121433", "31121431", "21112432", "21121522", "11112523", "31112521", "11121613", "31121611", "22121161", "11221162", "12112162", "12121252", "21221251", "22112251", "11212252", "22121341", "11221342", "12112342", "12121432", "21221431", "22112431", "11212432", "22121521", "11221522", "12112522", "12121612", "21221611", "12221161", "13112161", "13121251", "11312161", "11321251", "32121115", "52121113", "21221116", "41221114", "61221112", "22112116", "42112114", "31212115", "51212113", "13121116", "33121114", "22221115", "42221113", "11321116", "31321114", "51321112", "23112115", "43112113", "12212116", "32212114", "52212112", "21312115", "41312113", "61312111", "14121115", "34121113", "23221114", "43221112", "12321115", "32321113", "52321111", "21421114", "41421112", "24112114", "13212115", "33212113", "22312114", "42312112", "11412115", "31412113", "51412111", "15121114", "24221113", "13321114", "33321112", "22421113", "42421111", "11521114", "31521112", "25112113", "14212114", "34212112", "23312113", "43312111", "12412114", "32412112", "21512113", "41512111", "16121113", "25221112", "14321113", "34321111", "23421112", "12521113", "32521111", "15212113", "24312112", "13412113", "33412111", "22512112", "11612113", "31612111", "31131115", "51131113", "21122116", "41122114", "61122112", "31113115", "51113113", "12131116", "32131114", "52131112", "21231115", "41231113", "61231111", "22122115", "42122113", "11222116", "31222114", "51222112", "12113116", "32113114", "52113112", "21213115", "41213113", "61213111", "13131115", "33131113", "22231114", "42231112", "11331115", "31331113", "51331111", "23122114", "43122112", "12222115", "32222113", "52222111", "21322114", "41322112", "13113115", "33113113", "22213114", "42213112", "11313115", "31313113", "51313111", "14131114", "34131112", "23231113", "43231111", "12331114", "32331112", "21431113", "41431111", "24122113", "13222114", "33222112", "22322113", "42322111", "11422114", "31422112", "14113114", "34113112", "23213113", "43213111", "12313114", "32313112", "21413113", "41413111", "15131113", "24231112", "13331113", "33331111", "22431112", "25122112", "14222113", "34222111", "23322112", "12422113", "32422111", "21522112", "15113113", "24213112", "13313113", "33313111", "22413112", "11513113", "31513111", "16131112", "25231111", "14331112", "23431111", "15222112", "24322111", "13422112", "22522111", "16113112", "25213111", "14313112", "23413111", "12513112", "21613111", "11141116", "31141114", "51141112", "21132115", "41132113", "61132111", "11123116", "31123114", "51123112", "21114115", "41114113", "61114111", "12141115", "32141113", "52141111", "21241114", "41241112", "22132114", "42132112", "11232115", "31232113", "51232111", "12123115", "32123113", "52123111", "21223114", "41223112", "22114114", "42114112", "11214115", "31214113", "51214111", "13141114", "33141112", "22241113", "42241111", "11341114", "31341112", "23132113", "43132111", "12232114", "32232112", "21332113", "41332111", "13123114", "33123112", "22223113", "42223111", "11323114", "31323112", "23114113", "43114111", "12214114", "32214112", "21314113", "41314111", "14141113", "34141111", "23241112", "12341113", "32341111", "24132112", "13232113", "33232111", "22332112", "11432113", "31432111", "14123113", "34123111", "23223112", "12323113", "32323111", "21423112", "24114112", "13214113", "33214111", "22314112", "11414113", "31414111", "15141112", "24241111", "13341112", "25132111", "14232112", "23332111", "12432112", "15123112", "24223111", "13323112", "22423111", "11523112", "25114111", "14214112", "23314111", "12414112", "21514111", "16141111", "14341111", "15232111", "13432111", "16123111", "14323111", "12523111", "15214111", "13414111", "11614111", "11151115", "31151113", "51151111", "21142114", "41142112", "11133115", "31133113", "51133111", "21124114", "41124112", "11115115", "31115113", "51115111", "12151114", "32151112", "21251113", "41251111", "22142113", "42142111", "11242114", "31242112", "12133114", "32133112", "21233113", "41233111", "22124113", "42124111", "11224114", "31224112", "12115114", "32115112", "21215113", "41215111", "13151113", "33151111", "22251112", "23142112", "12242113", "32242111", "21342112", "13133113", "33133111", "22233112", "11333113", "31333111", "23124112", "12224113", "32224111", "21324112", "13115113", "33115111", "22215112", "11315113", "31315111", "14151112", "23251111", "24142111", "13242112", "22342111", "14133112", "23233111", "12333112", "21433111", "24124111", "13224112", "22324111", "11424112", "14115112", "23215111", "12315112", "21415111", "15151111", "14242111", "15133111", "13333111", "14224111", "12424111", "15115111", "13315111", "11515111", "11161114", "31161112", "21152113", "41152111", "11143114", "31143112", "21134113", "41134111", "11125114", "31125112", "21116113", "41116111", "12161113", "32161111", "22152112", "11252113", "31252111", "12143113", "32143111", "21243112", "22134112", "11234113", "31234111", "12125113", "32125111", "21225112", "22116112", "11216113", "31216111", "13161112", "23152111", "12252112", "13143112", "22243111", "11343112", "23134111", "12234112", "21334111", "13125112", "22225111", "11325112", "23116111", "12216112", "21316111", "14161111", "13252111", "14143111", "12343111", "13234111", "11434111", "14125111", "12325111", "13216111", "11416111", "31111216", "51111214", "31211125", "51211123", "32111215", "52111213", "21211216", "41211214", "61211212", "12211126", "32211124", "52211122", "21311125", "41311123", "61311121", "13111216", "33111214", "22211215", "42211213", "11311216", "31311214", "51311212", "13211125", "33211123", "22311124", "42311122", "11411125", "31411123", "51411121", "14111215", "34111213", "23211214", "43211212", "12311215", "32311213", "52311211", "21411214", "41411212", "14211124", "34211122", "23311123", "43311121", "12411124", "32411122", "21511123", "41511121", "15111214", "24211213", "13311214", "33311212", "22411213", "42411211", "11511214", "31511212", "15211123", "24311122", "13411123", "33411121", "22511122", "11611123", "31611121", "16111213", "25211212", "14311213", "34311211", "23411212", "12511213", "32511211", "21611212", "21121126", "41121124", "61121122", "31112125", "51112123", "31121215", "51121213", "21112216", "41112214", "61112212", "22121125", "42121123", "11221126", "31221124", "51221122", "12112126", "32112124", "52112122", "12121216", "32121214", "52121212", "21221215", "41221213", "61221211", "22112215", "42112213", "11212216", "31212214", "51212212", "23121124", "43121122", "12221125", "32221123", "52221121", "21321124", "41321122", "13112125", "33112123", "13121215", "33121213", "11312125", "22221214", "42221212", "11321215", "31321213", "51321211", "23112214", "43112212", "12212215", "32212213", "52212211", "21312214", "41312212", "24121123", "13221124", "33221122", "22321123", "42321121", "11421124", "31421122", "14112124", "34112122", "14121214", "34121212", "12312124", "23221213", "43221211", "12321214", "32321212", "21421213", "41421211", "24112213", "13212214", "33212212", "22312213", "42312211", "11412214", "31412212", "25121122", "14221123", "34221121", "23321122", "12421123", "32421121", "21521122", "15112123", "15121213", "13312123", "24221212", "13321213", "33321211", "11512123", "22421212", "11521213", "31521211", "25112212", "14212213", "34212211", "23312212", "12412213", "32412211", "21512212", "15221122", "24321121", "13421122", "22521121", "16112122", "16121212", "14312122", "25221211", "14321212", "12512122", "23421211", "12521212", "15212212", "24312211", "13412212", "22512211", "11612212", "21131125", "41131123", "61131121", "11122126", "31122124", "51122122", "11131216", "31131214", "51131212", "21113125", "41113123", "61113121", "21122215", "41122213", "61122211", "11113216", "31113214", "51113212", "22131124", "42131122", "11231125", "31231123", "51231121", "12122125", "32122123", "52122121", "12131215", "32131213", "52131211", "21231214", "41231212", "22113124", "42113122", "11213125", "22122214", "42122212", "11222215", "31222213", "51222211", "12113215", "32113213", "52113211", "21213214", "41213212", "23131123", "43131121", "12231124", "32231122", "21331123", "41331121", "13122124", "33122122", "13131214", "33131212", "11322124", "22231213", "42231211", "11331214", "31331212", "23113123", "43113121", "12213124", "23122213", "43122211", "12222214", "32222212", "21322213", "41322211", "13113214", "33113212", "22213213", "42213211", "11313214", "31313212", "24131122", "13231123", "33231121", "22331122", "11431123", "31431121", "14122123", "34122121", "14131213", "34131211", "12322123", "23231212", "12331213", "32331211", "21431212", "24113122", "13213123", "24122212", "13222213", "33222211", "11413123", "22322212", "11422213", "31422211", "14113213", "34113211", "23213212", "12313213", "32313211", "21413212", "25131121", "14231122", "23331121", "12431122", "15122122", "15131212", "13322122", "24231211", "13331212", "11522122", "22431211", "25113121", "14213122", "25122211", "14222212", "12413122", "23322211", "12422212", "21522211", "15113212", "24213211", "13313212", "22413211", "11513212", "15231121", "13431121", "16122121", "16131211", "14322121", "14331211", "12522121", "15213121", "15222211", "13413121", "13422211", "11613121", "16113211", "14313211", "12513211", "21141124", "41141122", "11132125", "31132123", "51132121", "11141215", "31141213", "51141211", "21123124", "41123122", "21132214", "41132212", "11114125", "31114123", "51114121", "11123215", "31123213", "51123211", "21114214", "41114212", "22141123", "42141121", "11241124", "31241122", "12132124", "32132122", "12141214", "32141212", "21241213", "41241211", "22123123", "42123121", "11223124", "22132213", "42132211", "11232214", "31232212", "12114124", "32114122", "12123214", "32123212", "21223213", "41223211", "22114213", "42114211", "11214214", "31214212", "23141122", "12241123", "32241121", "21341122", "13132123", "33132121", "13141213", "33141211", "11332123", "22241212", "11341213", "31341211", "23123122", "12223123", "23132212", "12232213", "32232211", "21332212", "13114123", "33114121", "13123213", "33123211", "11314123", "22223212", "11323213", "31323211", "23114212", "12214213", "32214211", "21314212", "24141121", "13241122", "22341121", "14132122", "14141212", "12332122", "23241211", "12341212", "24123121", "13223122", "24132211", "13232212", "11423122", "22332211", "11432212", "14114122", "14123212", "12314122", "23223211", "12323212", "21423211", "24114211", "13214212", "22314211", "11414212", "14241121", "15132121", "15141211", "13332121", "13341211", "14223121", "14232211", "12423121", "12432211", "15114121", "15123211", "13314121", "13323211", "11514121", "11523211", "14214211", "12414211", "21151123", "41151121", "11142124", "31142122", "11151214", "31151212", "21133123", "41133121", "21142213", "41142211", "11124124", "31124122", "11133214", "31133212", "21115123", "41115121", "21124213", "41124211", "11115214", "31115212", "22151122", "11251123", "31251121", "12142123", "32142121", "12151213", "32151211", "21251212", "22133122", "11233123", "22142212", "11242213", "31242211", "12124123", "32124121", "12133213", "32133211", "21233212", "22115122", "11215123", "22124212", "11224213", "31224211", "12115213", "32115211", "21215212", "23151121", "12251122", "13142122", "13151212", "11342122", "22251211", "23133121", "12233122", "23142211", "12242212", "21342211", "13124122", "13133212", "11324122", "22233211", "11333212", "23115121", "12215122", "23124211", "12224212", "21324211", "13115212", "22215211", "11315212", "13251121", "14142121", "14151211", "12342121", "13233121", "13242211", "11433121", "14124121", "14133211", "12324121", "12333211", "13215121", "13224211", "11415121", "11424211", "14115211", "12315211", "21161122", "11152123", "31152121", "11161213", "31161211", "21143122", "21152212", "11134123", "31134121", "11143213", "31143211", "21125122", "21134212", "11116123", "31116121", "11125213", "31125211", "22161121", "12152122", "12161212", "22143121", "11243122", "22152211", "11252212", "12134122", "12143212", "21243211", "22125121", "11225122", "22134211", "11234212", "12116122", "12125212", "21225211", "13152121", "13161211", "12243121", "12252211", "13134121", "13143211", "11334121", "11343211", "12225121", "12234211", "13116121", "13125211", "11316121", "11325211", "21111226", "41111224", "61111222", "31111315", "51111313", "21211135", "41211133", "61211131", "22111225", "42111223", "11211226", "31211224", "51211222", "12111316", "32111314", "52111312", "21211315", "41211313", "61211311", "22211134", "42211132", "11311135", "31311133", "51311131", "23111224", "43111222", "12211225", "32211223", "52211221", "21311224", "41311222", "13111315", "33111313", "22211314", "42211312", "11311315", "31311313", "51311311", "23211133", "43211131", "12311134", "32311132", "21411133", "41411131", "24111223", "13211224", "33211222", "22311223", "42311221", "11411224", "31411222", "14111314", "34111312", "23211313", "43211311", "12311314", "32311312", "21411313", "41411311", "24211132", "13311133", "33311131", "22411132", "11511133", "31511131", "25111222", "14211223", "34211221", "23311222", "12411223", "32411221", "21511222", "15111313", "24211312", "13311313", "33311311", "22411312", "11511313", "31511311", "25211131", "14311132", "23411131", "12511132", "21611131", "15211222", "24311221", "13411222", "22511221", "11611222", "16111312", "25211311", "14311312", "23411311", "12511312", "21611311", "31121134", "51121132", "21112135", "41112133", "61112131", "21121225", "41121223", "61121221", "11112226", "31112224", "51112222", "11121316", "31121314", "51121312", "21112315", "41112313", "61112311", "12121135", "32121133", "52121131", "21221134", "41221132", "22112134", "42112132", "11212135", "22121224", "42121222", "11221225", "31221223", "51221221", "12112225", "32112223", "52112221", "12121315", "32121313", "52121311", "21221314", "41221312", "22112314", "42112312", "11212315", "31212313", "51212311", "13121134", "33121132", "22221133", "42221131", "11321134", "31321132", "23112133", "43112131", "12212134", "23121223", "43121221", "12221224", "32221222", "21321223", "41321221", "13112224", "33112222", "13121314", "33121312", "11312224", "22221313", "42221311", "11321314", "31321312", "23112313", "43112311", "12212314", "32212312", "21312313", "41312311", "14121133", "34121131", "23221132", "12321133", "32321131", "21421132", "24112132", "13212133", "24121222", "13221223", "33221221", "11412133", "22321222", "11421223", "31421221", "14112223", "34112221", "14121313", "34121311", "12312223", "23221312", "12321313", "32321311", "21421312", "24112312", "13212313", "33212311", "22312312", "11412313", "31412311", "15121132", "24221131", "13321132", "22421131"]), $a(["22121116", "42121114", "31221115", "51221113", "32112115", "52112113", "21212116", "41212114", "61212112", "23121115", "43121113", "12221116", "32221114", "52221112", "21321115", "41321113", "61321111", "13112116", "33112114", "22212115", "42212113", "11312116", "31312114", "51312112", "24121114", "13221115", "33221113", "22321114", "42321112", "11421115", "31421113", "51421111", "14112115", "34112113", "23212114", "43212112", "12312115", "32312113", "52312111", "21412114", "41412112", "25121113", "14221114", "34221112", "23321113", "43321111", "12421114", "32421112", "21521113", "41521111", "15112114", "24212113", "13312114", "33312112", "22412113", "42412111", "11512114", "31512112", "15221113", "24321112", "13421113", "33421111", "22521112", "16112113", "25212112", "14312113", "34312111", "23412112", "12512113", "32512111", "21612112", "21131116", "41131114", "61131112", "31122115", "51122113", "21113116", "41113114", "61113112", "22131115", "42131113", "11231116", "31231114", "51231112", "12122116", "32122114", "52122112", "21222115", "41222113", "61222111", "22113115", "42113113", "11213116", "31213114", "51213112", "23131114", "43131112", "12231115", "32231113", "52231111", "21331114", "41331112", "13122115", "33122113", "22222114", "42222112", "11322115", "31322113", "51322111", "23113114", "43113112", "12213115", "32213113", "52213111", "21313114", "41313112", "24131113", "13231114", "33231112", "22331113", "42331111", "11431114", "31431112", "14122114", "34122112", "23222113", "43222111", "12322114", "32322112", "21422113", "41422111", "24113113", "13213114", "33213112", "22313113", "42313111", "11413114", "31413112", "25131112", "14231113", "34231111", "23331112", "12431113", "32431111", "15122113", "24222112", "13322113", "33322111", "22422112", "11522113", "31522111", "25113112", "14213113", "34213111", "23313112", "12413113", "32413111", "21513112", "15231112", "24331111", "13431112", "16122112", "25222111", "14322112", "23422111", "12522112", "15213112", "24313111", "13413112", "22513111", "11613112", "21141115", "41141113", "61141111", "11132116", "31132114", "51132112", "21123115", "41123113", "61123111", "11114116", "31114114", "51114112", "22141114", "42141112", "11241115", "31241113", "51241111", "12132115", "32132113", "52132111", "21232114", "41232112", "22123114", "42123112", "11223115", "31223113", "51223111", "12114115", "32114113", "52114111", "21214114", "41214112", "23141113", "43141111", "12241114", "32241112", "21341113", "41341111", "13132114", "33132112", "22232113", "42232111", "11332114", "31332112", "23123113", "43123111", "12223114", "32223112", "21323113", "41323111", "13114114", "33114112", "22214113", "42214111", "11314114", "31314112", "24141112", "13241113", "33241111", "22341112", "14132113", "34132111", "23232112", "12332113", "32332111", "21432112", "24123112", "13223113", "33223111", "22323112", "11423113", "31423111", "14114113", "34114111", "23214112", "12314113", "32314111", "21414112", "25141111", "14241112", "23341111", "15132112", "24232111", "13332112", "22432111", "25123111", "14223112", "23323111", "12423112", "21523111", "15114112", "24214111", "13314112", "22414111", "11514112", "15241111", "16132111", "14332111", "15223111", "13423111", "16114111", "14314111", "12514111", "21151114", "41151112", "11142115", "31142113", "51142111", "21133114", "41133112", "11124115", "31124113", "51124111", "21115114", "41115112", "22151113", "42151111", "11251114", "31251112", "12142114", "32142112", "21242113", "41242111", "22133113", "42133111", "11233114", "31233112", "12124114", "32124112", "21224113", "41224111", "22115113", "42115111", "11215114", "31215112", "23151112", "12251113", "32251111", "13142113", "33142111", "22242112", "11342113", "31342111", "23133112", "12233113", "32233111", "21333112", "13124113", "33124111", "22224112", "11324113", "31324111", "23115112", "12215113", "32215111", "21315112", "24151111", "13251112", "14142112", "23242111", "12342112", "24133111", "13233112", "22333111", "11433112", "14124112", "23224111", "12324112", "21424111", "24115111", "13215112", "22315111", "11415112", "14251111", "15142111", "13342111", "14233111", "12433111", "15124111", "13324111", "11524111", "14215111", "12415111", "21161113", "41161111", "11152114", "31152112", "21143113", "41143111", "11134114", "31134112", "21125113", "41125111", "11116114", "31116112", "22161112", "12152113", "32152111", "21252112", "22143112", "11243113", "31243111", "12134113", "32134111", "21234112", "22125112", "11225113", "31225111", "12116113", "32116111", "21216112", "23161111", "13152112", "22252111", "23143111", "12243112", "21343111", "13134112", "22234111", "11334112", "23125111", "12225112", "21325111", "13116112", "22216111", "11316112", "14152111", "13243111", "14134111", "12334111", "13225111", "11425111", "14116111", "12316111", "41111215", "61111213", "21211126", "41211124", "61211122", "22111216", "42111214", "31211215", "51211213", "22211125", "42211123", "11311126", "31311124", "51311122", "23111215", "43111213", "12211216", "32211214", "52211212", "21311215", "41311213", "61311211", "23211124", "43211122", "12311125", "32311123", "52311121", "21411124", "41411122", "24111214", "13211215", "33211213", "22311214", "42311212", "11411215", "31411213", "51411211", "24211123", "13311124", "33311122", "22411123", "42411121", "11511124", "31511122", "25111213", "14211214", "34211212", "23311213", "43311211", "12411214", "32411212", "21511213", "41511211", "25211122", "14311123", "34311121", "23411122", "12511123", "32511121", "21611122", "15211213", "24311212", "13411213", "33411211", "22511212", "11611213", "31611211", "31121125", "51121123", "21112126", "41112124", "61112122", "21121216", "41121214", "61121212", "31112215", "51112213", "12121126", "32121124", "52121122", "21221125", "41221123", "61221121", "22112125", "42112123", "11212126", "22121215", "42121213", "11221216", "31221214", "51221212", "12112216", "32112214", "52112212", "21212215", "41212213", "61212211", "13121125", "33121123", "22221124", "42221122", "11321125", "31321123", "51321121", "23112124", "43112122", "12212125", "23121214", "43121212", "12221215", "32221213", "52221211", "21321214", "41321212", "13112215", "33112213", "22212214", "42212212", "11312215", "31312213", "51312211", "14121124", "34121122", "23221123", "43221121", "12321124", "32321122", "21421123", "41421121", "24112123", "13212124", "24121213", "13221214", "33221212", "11412124", "22321213", "42321211", "11421214", "31421212", "14112214", "34112212", "23212213", "43212211", "12312214", "32312212", "21412213", "41412211", "15121123", "24221122", "13321123", "33321121", "22421122", "11521123", "31521121", "25112122", "14212123", "25121212", "14221213", "34221211", "12412123", "23321212", "12421213", "32421211", "21521212", "15112213", "24212212", "13312213", "33312211", "22412212", "11512213", "31512211", "16121122", "25221121", "14321122", "23421121", "12521122", "15212122", "15221212", "13412122", "24321211", "13421212", "11612122", "22521211", "16112212", "25212211", "14312212", "23412211", "12512212", "21612211", "11131126", "31131124", "51131122", "21122125", "41122123", "61122121", "21131215", "41131213", "61131211", "11113126", "31113124", "51113122", "11122216", "31122214", "51122212", "21113215", "41113213", "61113211", "12131125", "32131123", "52131121", "21231124", "41231122", "22122124", "42122122", "11222125", "22131214", "42131212", "11231215", "31231213", "51231211", "12113125", "32113123", "52113121", "12122215", "32122213", "52122211", "21222214", "41222212", "22113214", "42113212", "11213215", "31213213", "51213211", "13131124", "33131122", "22231123", "42231121", "11331124", "31331122", "23122123", "43122121", "12222124", "23131213", "43131211", "12231214", "32231212", "21331213", "41331211", "13113124", "33113122", "13122214", "33122212", "11313124", "22222213", "42222211", "11322214", "31322212", "23113213", "43113211", "12213214", "32213212", "21313213", "41313211", "14131123", "34131121", "23231122", "12331123", "32331121", "21431122", "24122122", "13222123", "24131212", "13231213", "33231211", "11422123", "22331212", "11431213", "31431211", "14113123", "34113121", "14122213", "34122211", "12313123", "23222212", "12322213", "32322211", "21422212", "24113212", "13213213", "33213211", "22313212", "11413213", "31413211", "15131122", "24231121", "13331122", "22431121", "25122121", "14222122", "25131211", "14231212", "12422122", "23331211", "12431212", "15113122", "15122212", "13313122", "24222211", "13322212", "11513122", "22422211", "11522212", "25113211", "14213212", "23313211", "12413212", "21513211", "16131121", "14331121", "15222121", "15231211", "13422121", "13431211", "16113121", "16122211", "14313121", "14322211", "12513121", "12522211", "15213211", "13413211", "11613211", "11141125", "31141123", "51141121", "21132124", "41132122", "21141214", "41141212", "11123125", "31123123", "51123121", "11132215", "31132213", "51132211", "21114124", "41114122", "21123214", "41123212", "11114215", "31114213", "51114211", "12141124", "32141122", "21241123", "41241121", "22132123", "42132121", "11232124", "22141213", "42141211", "11241214", "31241212", "12123124", "32123122", "12132214", "32132212", "21232213", "41232211", "22114123", "42114121", "11214124", "22123213", "42123211", "11223214", "31223212", "12114214", "32114212", "21214213", "41214211", "13141123", "33141121", "22241122", "11341123", "31341121", "23132122", "12232123", "23141212", "12241213", "32241211", "21341212", "13123123", "33123121", "13132213", "33132211", "11323123", "22232212", "11332213", "31332211", "23114122", "12214123", "23123212", "12223213", "32223211", "21323212", "13114213", "33114211", "22214212", "11314213", "31314211", "14141122", "23241121", "12341122", "24132121", "13232122", "24141211", "13241212", "11432122", "22341211", "14123122", "14132212", "12323122", "23232211", "12332212", "21432211", "24114121", "13214122", "24123211", "13223212", "11414122", "22323211", "11423212", "14114212", "23214211", "12314212", "21414211", "15141121", "13341121", "14232121", "14241211", "12432121", "15123121", "15132211", "13323121", "13332211", "11523121", "14214121", "14223211", "12414121", "12423211", "15114211", "13314211", "11514211", "11151124", "31151122", "21142123", "41142121", "21151213", "41151211", "11133124", "31133122", "11142214", "31142212", "21124123", "41124121", "21133213", "41133211", "11115124", "31115122", "11124214", "31124212", "21115213", "41115211", "12151123", "32151121", "21251122", "22142122", "11242123", "22151212", "11251213", "31251211", "12133123", "32133121", "12142213", "32142211", "21242212", "22124122", "11224123", "22133212", "11233213", "31233211", "12115123", "32115121", "12124213", "32124211", "21224212", "22115212", "11215213", "31215211", "13151122", "22251121", "23142121", "12242122", "23151211", "12251212", "13133122", "13142212", "11333122", "22242211", "11342212", "23124121", "12224122", "23133211", "12233212", "21333211", "13115122", "13124212", "11315122", "22224211", "11324212", "23115211", "12215212", "21315211", "14151121", "13242121", "13251211", "14133121", "14142211", "12333121", "12342211", "13224121", "13233211", "11424121", "11433211", "14115121", "14124211", "12315121", "12324211", "13215211", "11415211", "11161123", "31161121", "21152122", "21161212", "11143123", "31143121", "11152213", "31152211", "21134122", "21143212", "11125123", "31125121", "11134213", "31134211", "21116122", "21125212", "12161122", "22152121", "11252122", "22161211", "12143122", "12152212", "21252211", "22134121", "11234122", "22143211", "11243212", "12125122", "12134212", "21234211", "22116121", "11216122", "22125211", "11225212", "13161121", "12252121", "13143121", "13152211", "11343121", "12234121", "12243211", "13125121", "13134211", "11325121", "11334211", "12216121", "12225211", "31111225", "51111223", "21111316", "41111314", "61111312", "31211134", "51211132", "12111226", "32111224", "52111222", "21211225", "41211223", "61211221", "22111315", "42111313", "11211316", "31211314", "51211312", "12211135", "32211133", "52211131", "21311134", "41311132", "13111225", "33111223", "22211224", "42211222", "11311225", "31311223", "51311221", "23111314", "43111312", "12211315", "32211313", "52211311", "21311314", "41311312", "13211134", "33211132", "22311133", "42311131", "11411134", "31411132", "14111224", "34111222", "23211223", "43211221", "12311224", "32311222", "21411223", "41411221", "24111313", "13211314", "33211312", "22311313", "42311311", "11411314", "31411312", "14211133", "34211131", "23311132", "12411133", "32411131", "21511132", "15111223", "24211222", "13311223", "33311221", "22411222", "11511223", "31511221", "25111312", "14211313", "34211311", "23311312", "12411313", "32411311", "21511312", "15211132", "24311131", "13411132", "22511131", "11611132", "16111222", "25211221", "14311222", "23411221", "12511222", "21611221", "15211312", "24311311", "13411312", "22511311", "11611312", "21121135", "41121133", "61121131", "11112136", "31112134", "51112132", "11121226", "31121224", "51121222", "21112225", "41112223", "61112221", "21121315", "41121313", "61121311", "11112316", "31112314", "51112312", "22121134", "42121132", "11221135", "31221133", "51221131", "12112135", "32112133", "52112131", "12121225", "32121223", "52121221", "21221224", "41221222", "22112224", "42112222", "11212225", "22121314", "42121312", "11221315", "31221313", "51221311", "12112315", "32112313", "52112311", "21212314", "41212312", "23121133", "43121131", "12221134", "32221132", "21321133", "41321131", "13112134", "33112132", "13121224", "33121222", "11312134", "22221223", "42221221", "11321224", "31321222", "23112223", "43112221", "12212224", "23121313", "43121311", "12221314", "32221312", "21321313", "41321311", "13112314", "33112312", "22212313", "42212311", "11312314", "31312312", "24121132", "13221133", "33221131", "22321132", "11421133", "31421131", "14112133", "34112131", "14121223", "34121221", "12312133", "23221222", "12321223", "32321221", "21421222", "24112222", "13212223", "24121312", "13221313", "33221311", "11412223", "22321312", "11421313", "31421311", "14112313", "34112311", "23212312", "12312313", "32312311", "21412312", "25121131", "14221132", "23321131", "12421132", "21521131", "15112132", "15121222", "13312132", "24221221", "13321222", "11512132", "22421221", "11521222", "25112221", "14212222", "25121311", "14221312", "12412222", "23321311", "12421312", "21521311", "15112312", "24212311", "13312312", "22412311", "11512312", "15221131", "13421131", "16112131", "16121221", "14312131", "14321221", "12512131", "12521221", "15212221", "15221311", "13412221", "13421311", "11612221", "16112311", "14312311", "12512311", "21131134", "41131132", "11122135", "31122133", "51122131", "11131225", "31131223", "51131221", "21113134", "41113132", "21122224", "41122222", "21131314", "41131312", "11113225", "31113223", "51113221", "11122315", "31122313", "51122311", "21113314", "41113312", "22131133", "42131131", "11231134", "31231132", "12122134", "32122132", "12131224", "32131222", "21231223", "41231221", "22113133", "42113131", "11213134", "22122223", "42122221", "11222224", "22131313", "42131311", "11231314", "31231312", "12113224", "32113222", "12122314", "32122312", "21222313", "41222311", "22113313", "42113311", "11213314", "31213312", "23131132", "12231133", "32231131", "21331132", "13122133", "33122131", "13131223", "33131221", "11322133", "22231222", "11331223", "31331221", "23113132", "12213133", "23122222", "12222223", "23131312", "12231313", "32231311", "21331312", "13113223", "33113221", "13122313", "33122311", "11313223", "22222312", "11322313", "31322311", "23113312", "12213313", "32213311", "21313312", "24131131", "13231132", "22331131", "11431132", "14122132", "14131222", "12322132", "23231221", "12331222", "21431221", "24113131", "13213132", "24122221", "13222222", "24131311", "11413132", "13231312", "11422222", "22331311", "11431312", "14113222", "14122312", "12313222", "23222311", "12322312", "21422311", "24113311", "13213312", "22313311", "11413312", "14231131", "12431131", "15122131", "15131221", "13322131", "13331221", "11522131", "14213131", "14222221", "12413131", "14231311", "12422221", "12431311", "15113221", "15122311", "13313221", "13322311", "11513221", "11522311", "14213311", "12413311", "21141133", "41141131", "11132134", "31132132", "11141224", "31141222", "21123133", "41123131", "21132223", "41132221", "21141313", "41141311", "11114134", "31114132", "11123224", "31123222", "11132314", "31132312", "21114223", "41114221", "21123313", "41123311", "11114314", "31114312", "22141132", "11241133", "31241131", "12132133", "32132131", "12141223", "32141221", "21241222", "22123132", "11223133", "22132222", "11232223", "22141312", "11241313", "31241311", "12114133", "32114131", "12123223", "32123221", "12132313", "32132311", "21232312", "22114222", "11214223", "22123312", "11223313", "31223311", "12114313", "32114311", "21214312", "23141131", "12241132", "21341131", "13132132", "13141222", "11332132", "22241221", "11341222", "23123131", "12223132", "23132221", "12232222", "23141311", "12241312", "21341311", "13114132", "13123222", "11314132", "13132312", "11323222", "22232311", "11332312", "23114221", "12214222", "23123311", "12223312", "21323311", "13114312", "22214311", "11314312", "13241131", "14132131", "14141221", "12332131", "12341221", "13223131", "13232221", "11423131", "13241311", "11432221", "14114131", "14123221", "12314131", "14132311", "12323221", "12332311", "13214221", "13223311", "11414221", "11423311", "14114311", "12314311", "21151132", "11142133", "31142131", "11151223", "31151221", "21133132", "21142222", "21151312", "11124133", "31124131", "11133223", "31133221", "11142313", "31142311", "21115132", "21124222", "21133312", "11115223", "31115221", "11124313", "31124311", "22151131", "11251132", "12142132", "12151222", "21251221", "22133131", "11233132", "22142221", "11242222", "22151311", "11251312", "12124132", "12133222", "12142312", "21242311", "22115131", "11215132", "22124221", "11224222", "22133311", "11233312", "12115222", "12124312", "21224311", "12251131", "13142131", "13151221", "11342131", "12233131", "12242221", "12251311", "13124131", "13133221", "11324131", "13142311", "11333221", "11342311", "12215131", "12224221", "12233311", "13115221", "13124311", "11315221", "11324311", "21161131", "11152132", "11161222", "21143131", "21152221", "21161311", "11134132", "11143222", "11152312", "21125131", "21134221", "21143311", "11116132", "11125222", "11134312", "12152131", "12161221", "11243131", "11252221", "12134131", "12143221", "12152311", "11225131", "11234221", "11243311", "12116131", "12125221", "12134311", "21111235", "41111233", "61111231", "11111326", "31111324", "51111322", "21111415", "41111413", "61111411", "21211144", "41211142", "22111234", "42111232", "11211235", "31211233", "51211231", "12111325", "32111323", "52111321", "21211324", "41211322", "22111414", "42111412", "11211415", "31211413", "51211411", "22211143", "42211141", "11311144", "31311142", "23111233", "43111231", "12211234", "32211232", "21311233", "41311231", "13111324", "33111322", "22211323", "42211321", "11311324", "31311322", "23111413", "43111411", "12211414", "32211412", "21311413", "41311411", "23211142", "12311143", "32311141", "21411142", "24111232", "13211233", "33211231", "22311232", "11411233", "31411231", "14111323", "34111321", "23211322", "12311323", "32311321", "21411322", "24111412", "13211413", "33211411", "22311412", "11411413", "31411411", "24211141", "13311142", "22411141", "11511142", "25111231", "14211232", "23311231", "12411232", "21511231", "15111322", "24211321", "13311322", "22411321", "11511322", "25111411", "14211412", "23311411", "12411412", "21511411", "14311141", "12511141", "15211231", "13411231", "11611231", "16111321", "14311321", "12511321", "15211411", "13411411", "11611411", "31121143", "51121141", "21112144", "41112142", "21121234", "41121232", "11112235", "31112233", "51112231", "11121325", "31121323", "51121321", "21112324", "41112322", "21121414", "41121412", "11112415", "31112413", "51112411", "12121144", "32121142", "21221143", "41221141", "22112143", "42112141", "11212144", "22121233", "42121231", "11221234", "31221232", "12112234", "32112232", "12121324", "32121322", "21221323", "41221321", "22112323", "42112321", "11212324", "22121413", "42121411", "11221414", "31221412", "12112414", "32112412", "21212413", "41212411", "13121143", "33121141", "22221142", "11321143", "31321141", "23112142", "12212143", "23121232", "12221233", "32221231", "21321232", "13112233", "33112231", "13121323", "33121321", "11312233", "22221322", "11321323", "31321321", "23112322", "12212323", "23121412", "12221413", "32221411", "21321412", "13112413", "33112411", "22212412", "11312413", "31312411", "14121142", "23221141", "12321142", "21421141", "24112141", "13212142", "24121231", "13221232", "11412142", "22321231", "11421232", "14112232", "14121322", "12312232", "23221321", "12321322", "21421321", "24112321", "13212322", "24121411", "13221412", "11412322", "22321411", "11421412", "14112412", "23212411", "12312412", "21412411", "15121141", "13321141", "11521141", "14212141", "14221231", "12412141", "12421231", "15112231", "15121321", "13312231", "13321321", "11512231", "11521321", "14212321", "14221411", "12412321", "12421411", "15112411", "13312411", "11512411", "11131144", "31131142", "21122143", "41122141", "21131233", "41131231", "11113144", "31113142", "11122234", "31122232", "11131324", "31131322", "21113233", "41113231", "21122323", "41122321", "21131413", "41131411", "11113324", "31113322", "11122414", "31122412", "21113413", "41113411", "12131143", "32131141", "21231142", "22122142", "11222143", "22131232", "11231233", "31231231", "12113143", "32113141", "12122233", "32122231", "12131323", "32131321", "21231322", "22113232", "11213233", "22122322", "11222323", "22131412", "11231413", "31231411", "12113323", "32113321", "12122413", "32122411", "21222412", "22113412", "11213413", "31213411", "13131142", "22231141", "11331142", "23122141", "12222142", "23131231", "12231232", "21331231", "13113142", "13122232", "11313142", "13131322", "11322232", "22231321", "11331322", "23113231", "12213232", "23122321", "12222322", "23131411", "12231412", "21331411", "13113322", "13122412", "11313322", "22222411", "11322412", "23113411", "12213412", "21313411", "14131141", "12331141", "13222141", "13231231", "11422141", "11431231", "14113141", "14122231", "12313141", "14131321", "12322231", "12331321", "13213231", "13222321", "11413231", "13231411", "11422321", "11431411", "14113321", "14122411", "12313321", "12322411", "13213411", "11413411", "11141143", "31141141", "21132142", "21141232", "11123143", "31123141", "11132233", "31132231", "11141323", "31141321", "21114142", "21123232", "21132322", "21141412", "11114233", "31114231", "11123323", "31123321", "11132413", "31132411", "21114322", "21123412", "12141142", "21241141", "22132141", "11232142", "22141231", "11241232", "12123142", "12132232", "12141322", "21241321", "22114141", "11214142", "22123231", "11223232", "22132321", "11232322", "22141411", "11241412", "12114232", "12123322", "12132412", "21232411", "22114321", "11214322", "22123411", "11223412", "13141141", "11341141", "12232141", "12241231", "13123141", "13132231", "11323141", "13141321", "11332231", "11341321", "12214141", "12223231", "12232321", "12241411", "13114231", "13123321", "11314231", "13132411", "11323321", "11332411", "12214321", "12223411", "11151142", "21142141", "21151231", "11133142", "11142232", "11151322", "21124141", "21133231", "21142321", "21151411", "11115142", "11124232", "11133322", "11142412", "21115231", "21124321", "21133411", "12151141", "11242141", "11251231", "12133141", "12142231", "12151321", "11224141", "11233231", "11242321", "11251411", "12115141", "12124231", "12133321", "12142411", "11215231", "11224321", "11233411", "11161141", "11143141", "11152231", "11161321", "11125141", "11134231", "11143321", "11152411", "11111245", "31111243", "51111241", "21111334", "41111332", "11111425", "31111423", "51111421", "21111514", "41111512", "31211152", "12111244", "32111242", "21211243", "41211241", "22111333", "42111331", "11211334", "31211332", "12111424", "32111422", "21211423", "41211421", "22111513", "42111511", "11211514", "31211512", "12211153", "32211151", "21311152", "13111243", "33111241", "22211242", "11311243", "31311241", "23111332", "12211333", "32211331", "21311332", "13111423", "33111421", "22211422", "11311423", "31311421", "23111512", "12211513", "32211511", "21311512", "13211152", "22311151", "11411152", "14111242", "23211241", "12311242", "21411241", "24111331", "13211332", "22311331", "11411332", "14111422", "23211421", "12311422", "21411421", "24111511", "13211512", "22311511", "11411512", "14211151", "12411151", "15111241", "13311241", "11511241", "14211331", "12411331", "15111421", "13311421", "11511421", "14211511", "12411511", "21121153", "41121151", "11112154", "31112152", "11121244", "31121242", "21112243", "41112241", "21121333", "41121331", "11112334", "31112332", "11121424", "31121422", "21112423", "41112421", "21121513", "41121511", "11112514", "31112512", "22121152", "11221153", "31221151", "12112153", "32112151", "12121243", "32121241", "21221242", "22112242", "11212243", "22121332", "11221333", "31221331", "12112333", "32112331", "12121423", "32121421", "21221422", "22112422", "11212423", "22121512", "11221513", "31221511", "12112513", "32112511", "21212512", "23121151", "12221152", "21321151", "13112152", "13121242", "11312152", "22221241", "11321242", "23112241", "12212242", "23121331", "12221332", "21321331", "13112332", "13121422", "11312332", "22221421", "11321422", "23112421", "12212422", "23121511", "12221512", "21321511", "13112512", "22212511", "11312512", "13221151", "11421151", "14112151", "14121241", "12312151", "12321241", "13212241", "13221331", "11412241", "11421331", "14112331", "14121421", "12312331", "12321421", "13212421", "13221511", "11412421", "11421511", "14112511", "12312511", "21131152", "11122153", "31122151", "11131243", "31131241", "21113152", "21122242", "21131332", "11113243", "31113241", "11122333", "31122331", "11131423", "31131421", "21113332", "21122422", "21131512", "11113423", "31113421", "11122513", "31122511", "22131151", "11231152", "12122152", "12131242", "21231241", "22113151", "11213152", "22122241", "11222242", "22131331", "11231332", "12113242", "12122332", "12131422", "21231421", "22113331", "11213332", "22122421", "11222422", "22131511", "11231512", "12113422", "12122512", "21222511", "12231151", "13122151", "13131241", "11322151", "11331241", "12213151", "12222241", "12231331", "13113241", "13122331", "11313241", "13131421", "11322331", "11331421", "12213331", "12222421", "12231511", "13113421", "13122511", "11313421", "11322511", "21141151", "11132152", "11141242", "21123151", "21132241", "21141331", "11114152", "11123242", "11132332", "11141422", "21114241", "21123331", "21132421", "21141511", "11114332", "11123422", "11132512", "11241151", "12132151", "12141241", "11223151", "11232241", "11241331", "12114151", "12123241", "12132331", "12141421", "11214241", "11223331", "11232421", "11241511", "12114331", "12123421", "12132511", "11142151", "11151241", "11124151", "11133241", "11142331", "11151421", "11115241", "11124331", "11133421", "11142511", "21111253", "41111251", "11111344", "31111342", "21111433", "41111431", "11111524", "31111522", "21111613", "41111611", "21211162", "22111252", "11211253", "31211251", "12111343", "32111341", "21211342", "22111432", "11211433", "31211431", "12111523", "32111521", "21211522", "22111612", "11211613", "31211611", "22211161", "11311162", "23111251", "12211252", "21311251", "13111342", "22211341", "11311342", "23111431", "12211432", "21311431", "13111522", "22211521", "11311522", "23111611", "12211612", "21311611", "12311161", "13211251", "11411251", "14111341", "12311341", "13211431", "11411431", "14111521", "12311521", "13211611", "11411611", "31121161", "21112162", "21121252", "11112253", "31112251", "11121343", "31121341", "21112342", "21121432", "11112433", "31112431", "11121523", "31121521", "21112522", "21121612", "12121162", "21221161", "22112161", "11212162", "22121251", "11221252", "12112252", "12121342", "21221341", "22112341", "11212342", "22121431", "11221432", "12112432", "12121522", "21221521", "22112521", "11212522", "22121611", "11221612", "13121161", "11321161", "12212161", "12221251", "13112251", "13121341", "11312251", "11321341", "12212341", "12221431", "13112431", "13121521", "11312431", "11321521", "12212521", "12221611", "11131162", "21122161", "21131251", "11113162"])]); //#16119
        $_.parity = $a(["1001", "0101", "1100", "0011", "1010", "0110", "1111", "0000"]); //#16123
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_code49.$ctx[id] = $_[id]); //#16123
        bwipp_code49.__16124__ = 1; //#16123
        $_ = Object.getPrototypeOf($_); //#16123
    } //#16123
    $_.rowbits = $a($_.r); //#16127
    for (var _6C = 0, _6B = $f($_.r - 1); _6C <= _6B; _6C += 1) { //#16147
        $_.i = _6C; //#16129
        $k[$j++] = 'p'; //#16130
        if ($_.i != $f($_.r - 1)) { //#16130
            $k[$j++] = $get($_.parity, $_.i); //#16130
        } else { //#16130
            $k[$j++] = "0000"; //#16130
        } //#16130
        var _6I = $k[--$j]; //#16130
        $_[$k[--$j]] = _6I; //#16130
        $_.ccrow = $geti($_.ccs, $_.i * 8, 8); //#16131
        $k[$j++] = Infinity; //#16132
        for (var _6N = 0; _6N <= 7; _6N += 2) { //#16133
            $aload($geti($_.ccrow, _6N, 2)); //#16133
            var _6Q = $k[--$j]; //#16133
            var _6R = $k[--$j]; //#16133
            $k[$j++] = $f(_6Q + (_6R * 49)); //#16133
        } //#16133
        $_.scrow = $a(); //#16133
        $k[$j++] = Infinity; //#16135
        $k[$j++] = 10; //#16140
        $k[$j++] = 1; //#16140
        $k[$j++] = 1; //#16140
        for (var _6T = 0; _6T <= 3; _6T += 1) { //#16140
            $_.j = _6T; //#16138
            $forall($get($get($_.patterns, $f($get($_.p, $_.j) - 48)), $get($_.scrow, $_.j)), function() { //#16139
                var _6d = $k[--$j]; //#16139
                $k[$j++] = $f(_6d - 48); //#16139
            }); //#16139
        } //#16139
        $k[$j++] = 4; //#16141
        $k[$j++] = 1; //#16141
        $_.sbs = $a(); //#16141
        $k[$j++] = Infinity; //#16143
        var _6f = $_.sbs; //#16144
        $k[$j++] = 1; //#16144
        for (var _6g = 0, _6h = _6f.length; _6g < _6h; _6g++) { //#16144
            var _6j = $k[--$j]; //#16144
            var _6k = (_6j == 0) ? 1 : 0; //#16144
            $k[$j++] = _6j; //#16144
            for (var _6l = 0, _6m = $get(_6f, _6g); _6l < _6m; _6l++) { //#16144
                $k[$j++] = _6k //#16144
            } //#16144
        } //#16144
        $astore($a($counttomark() - 1)); //#16145
        var _6p = $k[--$j]; //#16145
        var _6q = $k[--$j]; //#16145
        $k[$j++] = _6p; //#16145
        $k[$j++] = _6q; //#16145
        $j--; //#16145
        var _6r = $k[--$j]; //#16145
        var _6s = $k[--$j]; //#16145
        $k[$j++] = _6r; //#16145
        $k[$j++] = _6s; //#16145
        $j--; //#16145
        $put($_.rowbits, $_.i, $k[--$j]); //#16146
    } //#16146
    $k[$j++] = Infinity; //#16150
    for (var _6x = 0, _6y = 81 * $_.sepheight; _6x < _6y; _6x++) { //#16151
        $k[$j++] = 1; //#16151
    } //#16151
    for (var _71 = 0, _70 = $f($_.r - 2); _71 <= _70; _71 += 1) { //#16156
        $_.i = _71; //#16153
        for (var _73 = 0, _74 = $_.rowheight; _73 < _74; _73++) { //#16154
            $aload($get($_.rowbits, $_.i)); //#16154
        } //#16154
        for (var _79 = 0, _7A = $_.sepheight; _79 < _7A; _79++) { //#16155
            for (var _7B = 0, _7C = 10; _7B < _7C; _7B++) { //#16155
                $k[$j++] = 0; //#16155
            } //#16155
            for (var _7D = 0, _7E = 70; _7D < _7E; _7D++) { //#16155
                $k[$j++] = 1; //#16155
            } //#16155
            $k[$j++] = 0; //#16155
        } //#16155
    } //#16155
    for (var _7G = 0, _7H = $_.rowheight; _7G < _7H; _7G++) { //#16157
        $aload($get($_.rowbits, $f($_.r - 1))); //#16157
    } //#16157
    for (var _7M = 0, _7N = 81 * $_.sepheight; _7M < _7N; _7M++) { //#16158
        $k[$j++] = 1; //#16158
    } //#16158
    $_.pixs = $a(); //#16158
    var _7T = new Map([
        ["ren", 'renmatrix'],
        ["pixs", $_.pixs],
        ["pixx", 81],
        ["pixy", ~~($_.pixs.length / 81)],
        ["height", (~~($_.pixs.length / 81)) / 72],
        ["width", 81 / 72],
        ["opt", $_.options]
    ]); //#16169
    $k[$j++] = _7T; //#16172
    if (!$_.dontdraw) { //#16172
        bwipp_renmatrix(); //#16172
    } //#16172
    $_ = Object.getPrototypeOf($_); //#16174
    $_ = Object.getPrototypeOf($_); //#16176
} //bwipp_code49
function bwipp_flattermarken() {
    $_ = Object.create($_); //#16470
    $_.dontdraw = false; //#16473
    $_.includetext = false; //#16474
    $_.textfont = "OCR-B"; //#16475
    $_.textsize = 10; //#16476
    $_.textyoffset = -8; //#16477
    $_.height = 0.3; //#16478
    $k[$j++] = $_; //#16480
    bwipp_processoptions(); //#16480
    $_.options = $k[--$j]; //#16480
    $_.barcode = $k[--$j]; //#16481
    bwipp_loadctx(bwipp_flattermarken) //#16483
    $forall($_.barcode, function() { //#16490
        var _3 = $k[--$j]; //#16487
        if ((_3 < 48) || (_3 > 57)) { //#16489
            $k[$j++] = 'bwipp.flattermarkenBadCharacter#16488'; //#16488
            $k[$j++] = "Flattermarken must contain only digits"; //#16488
            bwipp_raiseerror(); //#16488
        } //#16488
    }); //#16488
    if (!bwipp_flattermarken.__16501__) { //#16501
        $_ = Object.create($_); //#16501
        $_.encs = $a(["0018", "0117", "0216", "0315", "0414", "0513", "0612", "0711", "0810", "0900"]); //#16497
        $_.barchars = "1234567890"; //#16500
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_flattermarken.$ctx[id] = $_[id]); //#16500
        bwipp_flattermarken.__16501__ = 1; //#16500
        $_ = Object.getPrototypeOf($_); //#16500
    } //#16500
    $_.barlen = $_.barcode.length; //#16503
    $_.sbs = $s($_.barlen * 4); //#16505
    $_.txt = $a($_.barlen); //#16506
    for (var _D = 0, _C = $_.barlen - 1; _D <= _C; _D += 1) { //#16518
        $_.i = _D; //#16509
        $search($_.barchars, $geti($_.barcode, $_.i, 1)); //#16511
        $j--; //#16512
        $_.indx = $k[--$j].length; //#16513
        $j -= 2; //#16514
        $_.enc = $get($_.encs, $_.indx); //#16515
        $puti($_.sbs, $_.i * 4, $_.enc); //#16516
        $put($_.txt, $_.i, $a([$geti($_.barcode, $_.i, 1), $_.i * 9, $_.textyoffset, $_.textfont, $_.textsize])); //#16517
    } //#16517
    $k[$j++] = Infinity; //#16521
    $k[$j++] = Infinity; //#16523
    var _Z = $_.sbs; //#16523
    for (var _a = 0, _b = _Z.length; _a < _b; _a++) { //#16523
        $k[$j++] = $get(_Z, _a) - 48; //#16523
    } //#16523
    var _d = $a(); //#16523
    $k[$j++] = Infinity; //#16524
    for (var _f = 0, _g = ~~(($_.sbs.length + 1) / 2); _f < _g; _f++) { //#16524
        $k[$j++] = $_.height; //#16524
    } //#16524
    var _i = $a(); //#16524
    $k[$j++] = Infinity; //#16525
    for (var _k = 0, _l = ~~(($_.sbs.length + 1) / 2); _k < _l; _k++) { //#16525
        $k[$j++] = 0; //#16525
    } //#16525
    var _m = $a(); //#16525
    $k[$j++] = 'ren'; //#16527
    $k[$j++] = 'renlinear'; //#16527
    $k[$j++] = 'sbs'; //#16527
    $k[$j++] = _d; //#16527
    $k[$j++] = 'bhs'; //#16527
    $k[$j++] = _i; //#16527
    $k[$j++] = 'bbs'; //#16527
    $k[$j++] = _m; //#16527
    $k[$j++] = 'txt'; //#16527
    $k[$j++] = $_.txt; //#16527
    $k[$j++] = 'opt'; //#16527
    $k[$j++] = $_.options; //#16527
    var _p = $d(); //#16527
    $k[$j++] = _p; //#16530
    if (!$_.dontdraw) { //#16530
        bwipp_renlinear(); //#16530
    } //#16530
    $_ = Object.getPrototypeOf($_); //#16532
    $_ = Object.getPrototypeOf($_); //#16534
} //bwipp_flattermarken
function bwipp_raw() {
    $_ = Object.create($_); //#16562
    $_.dontdraw = false; //#16565
    $_.height = 1; //#16566
    $k[$j++] = $_; //#16568
    bwipp_processoptions(); //#16568
    $_.options = $k[--$j]; //#16568
    $_.barcode = $k[--$j]; //#16569
    $forall($_.barcode, function() { //#16576
        var _3 = $k[--$j]; //#16573
        if ((_3 < 49) || (_3 > 57)) { //#16575
            $k[$j++] = 'bwipp.rawBadCharacter#16574'; //#16574
            $k[$j++] = "Raw must contain only digits 1 to 9"; //#16574
            bwipp_raiseerror(); //#16574
        } //#16574
    }); //#16574
    $k[$j++] = Infinity; //#16579
    $k[$j++] = Infinity; //#16581
    $forall($_.barcode, function() { //#16581
        var _5 = $k[--$j]; //#16581
        $k[$j++] = $f(_5 - 48); //#16581
    }); //#16581
    var _6 = $a(); //#16581
    $k[$j++] = Infinity; //#16582
    for (var _8 = 0, _9 = ~~(($_.barcode.length + 1) / 2); _8 < _9; _8++) { //#16582
        $k[$j++] = $_.height; //#16582
    } //#16582
    var _B = $a(); //#16582
    $k[$j++] = Infinity; //#16583
    for (var _D = 0, _E = ~~(($_.barcode.length + 1) / 2); _D < _E; _D++) { //#16583
        $k[$j++] = 0; //#16583
    } //#16583
    var _F = $a(); //#16583
    $k[$j++] = 'ren'; //#16584
    $k[$j++] = 'renlinear'; //#16584
    $k[$j++] = 'sbs'; //#16584
    $k[$j++] = _6; //#16584
    $k[$j++] = 'bhs'; //#16584
    $k[$j++] = _B; //#16584
    $k[$j++] = 'bbs'; //#16584
    $k[$j++] = _F; //#16584
    $k[$j++] = 'opt'; //#16584
    $k[$j++] = $_.options; //#16584
    var _H = $d(); //#16584
    $k[$j++] = _H; //#16587
    if (!$_.dontdraw) { //#16587
        bwipp_renlinear(); //#16587
    } //#16587
    $_ = Object.getPrototypeOf($_); //#16589
} //bwipp_raw
function bwipp_daft() {
    $_ = Object.create($_); //#16617
    $_.dontdraw = false; //#16620
    $_.height = 0.175; //#16621
    $k[$j++] = $_; //#16623
    bwipp_processoptions(); //#16623
    $_.options = $k[--$j]; //#16623
    $_.barcode = $k[--$j]; //#16624
    if ($eq($_.barcode, "")) { //#16628
        $k[$j++] = 'bwipp.daftEmptyData#16627'; //#16627
        $k[$j++] = "The data must not be empty"; //#16627
        bwipp_raiseerror(); //#16627
    } //#16627
    $forall($_.barcode, function() { //#16634
        var _4 = $k[--$j]; //#16631
        if ((_4 != 68) && ((_4 != 65) && ((_4 != 70) && (_4 != 84)))) { //#16633
            $k[$j++] = 'bwipp.daftBadCharacter#16632'; //#16632
            $k[$j++] = "DAFT must contain only characters D, A, F and T"; //#16632
            bwipp_raiseerror(); //#16632
        } //#16632
    }); //#16632
    $_.barlen = $_.barcode.length; //#16636
    $_.bbs = $a($_.barlen); //#16638
    $_.bhs = $a($_.barlen); //#16639
    for (var _C = 0, _B = $_.barlen - 1; _C <= _B; _C += 1) { //#16659
        $_.i = _C; //#16641
        $_.enc = $geti($_.barcode, $_.i, 1); //#16642
        if ($eq($_.enc, "D")) { //#16646
            $put($_.bbs, $_.i, (0 * $_.height) / 8); //#16644
            $put($_.bhs, $_.i, (5 * $_.height) / 8); //#16645
        } //#16645
        if ($eq($_.enc, "A")) { //#16650
            $put($_.bbs, $_.i, (3 * $_.height) / 8); //#16648
            $put($_.bhs, $_.i, (5 * $_.height) / 8); //#16649
        } //#16649
        if ($eq($_.enc, "F")) { //#16654
            $put($_.bbs, $_.i, (0 * $_.height) / 8); //#16652
            $put($_.bhs, $_.i, (8 * $_.height) / 8); //#16653
        } //#16653
        if ($eq($_.enc, "T")) { //#16658
            $put($_.bbs, $_.i, (3 * $_.height) / 8); //#16656
            $put($_.bhs, $_.i, (2 * $_.height) / 8); //#16657
        } //#16657
    } //#16657
    $k[$j++] = Infinity; //#16662
    var _i = $_.bbs; //#16664
    var _j = $_.bhs; //#16665
    $k[$j++] = Infinity; //#16666
    for (var _l = 0, _m = $_.bhs.length - 1; _l < _m; _l++) { //#16666
        $k[$j++] = 1.44; //#16666
        $k[$j++] = 1.872; //#16666
    } //#16666
    $k[$j++] = 1.44; //#16666
    var _n = $a(); //#16666
    $k[$j++] = 'ren'; //#16667
    $k[$j++] = 'renlinear'; //#16667
    $k[$j++] = 'bbs'; //#16667
    $k[$j++] = _i; //#16667
    $k[$j++] = 'bhs'; //#16667
    $k[$j++] = _j; //#16667
    $k[$j++] = 'sbs'; //#16667
    $k[$j++] = _n; //#16667
    $k[$j++] = 'opt'; //#16667
    $k[$j++] = $_.options; //#16667
    var _p = $d(); //#16667
    $k[$j++] = _p; //#16670
    if (!$_.dontdraw) { //#16670
        bwipp_renlinear(); //#16670
    } //#16670
    $_ = Object.getPrototypeOf($_); //#16672
} //bwipp_daft
function bwipp_symbol() {
    $_ = Object.create($_); //#16703
    $_.dontdraw = false; //#16706
    $k[$j++] = $_; //#16708
    bwipp_processoptions(); //#16708
    $_.options = $k[--$j]; //#16708
    var _1 = $k[--$j]; //#16709
    $_.barcode = _1; //#16709
    bwipp_loadctx(bwipp_symbol) //#16711
    if (!bwipp_symbol.__16747__) { //#16747
        $_ = Object.create($_); //#16747
        $_.fimasbs = $a([2.25, 2.25, 2.25, 11.25, 2.25, 11.25, 2.25, 2.25, 2.25]); //#16715
        $k[$j++] = Infinity; //#16716
        for (var _4 = 0, _5 = (~~($_.fimasbs.length / 2)) + 1; _4 < _5; _4++) { //#16716
            $k[$j++] = 0.625; //#16716
        } //#16716
        $_.fimabhs = $a(); //#16716
        $k[$j++] = Infinity; //#16717
        for (var _8 = 0, _9 = (~~($_.fimasbs.length / 2)) + 1; _8 < _9; _8++) { //#16717
            $k[$j++] = 0; //#16717
        } //#16717
        $_.fimabbs = $a(); //#16717
        $_.fimbsbs = $a([2.25, 6.75, 2.25, 2.25, 2.25, 6.25, 2.25, 2.25, 2.25, 6.75, 2.25]); //#16719
        $k[$j++] = Infinity; //#16720
        for (var _D = 0, _E = (~~($_.fimbsbs.length / 2)) + 1; _D < _E; _D++) { //#16720
            $k[$j++] = 0.625; //#16720
        } //#16720
        $_.fimbbhs = $a(); //#16720
        $k[$j++] = Infinity; //#16721
        for (var _H = 0, _I = (~~($_.fimbsbs.length / 2)) + 1; _H < _I; _H++) { //#16721
            $k[$j++] = 0; //#16721
        } //#16721
        $_.fimbbbs = $a(); //#16721
        $_.fimcsbs = $a([2.25, 2.25, 2.25, 6.75, 2.25, 6.75, 2.25, 6.75, 2.25, 2.25, 2.25]); //#16723
        $k[$j++] = Infinity; //#16724
        for (var _M = 0, _N = (~~($_.fimcsbs.length / 2)) + 1; _M < _N; _M++) { //#16724
            $k[$j++] = 0.625; //#16724
        } //#16724
        $_.fimcbhs = $a(); //#16724
        $k[$j++] = Infinity; //#16725
        for (var _Q = 0, _R = (~~($_.fimcsbs.length / 2)) + 1; _Q < _R; _Q++) { //#16725
            $k[$j++] = 0; //#16725
        } //#16725
        $_.fimcbbs = $a(); //#16725
        $_.fimdsbs = $a([2.25, 2.25, 2.25, 2.25, 2.25, 6.75, 2.25, 6.75, 2.25, 2.25, 2.25, 2.25, 2.25]); //#16727
        $k[$j++] = Infinity; //#16728
        for (var _V = 0, _W = (~~($_.fimdsbs.length / 2)) + 1; _V < _W; _V++) { //#16728
            $k[$j++] = 0.625; //#16728
        } //#16728
        $_.fimdbhs = $a(); //#16728
        $k[$j++] = Infinity; //#16729
        for (var _Z = 0, _a = (~~($_.fimdsbs.length / 2)) + 1; _Z < _a; _Z++) { //#16729
            $k[$j++] = 0; //#16729
        } //#16729
        $_.fimdbbs = $a(); //#16729
        $_.fimesbs = $a([2.25, 6.75, 2.25, 15.75, 2.25, 6.75, 2.25]); //#16731
        $k[$j++] = Infinity; //#16732
        for (var _e = 0, _f = (~~($_.fimesbs.length / 2)) + 1; _e < _f; _e++) { //#16732
            $k[$j++] = 0.625; //#16732
        } //#16732
        $_.fimebhs = $a(); //#16732
        $k[$j++] = Infinity; //#16733
        for (var _i = 0, _j = (~~($_.fimesbs.length / 2)) + 1; _i < _j; _i++) { //#16733
            $k[$j++] = 0; //#16733
        } //#16733
        $_.fimebbs = $a(); //#16733
        $k[$j++] = Infinity; //#16735
        for (var _l = 0, _m = 100; _l < _m; _l++) { //#16735
            $k[$j++] = 1; //#16735
            $k[$j++] = 1; //#16735
        } //#16735
        $k[$j++] = 1; //#16735
        $_.zebrasbs = $a(); //#16735
        $k[$j++] = Infinity; //#16736
        for (var _p = 0, _q = (~~($_.zebrasbs.length / 2)) + 1; _p < _q; _p++) { //#16736
            $k[$j++] = 1; //#16736
        } //#16736
        $_.zebrabhs = $a(); //#16736
        $k[$j++] = Infinity; //#16737
        for (var _t = 0, _u = (~~($_.zebrasbs.length / 2)) + 1; _t < _u; _t++) { //#16737
            $k[$j++] = 0; //#16737
        } //#16737
        $_.zebrabbs = $a(); //#16737
        $_.checksize = 199; //#16739
        $k[$j++] = Infinity; //#16740
        var _w = $_.checksize; //#16740
        for (var _x = 0, _y = ~~((_w * _w) / 2); _x < _y; _x++) { //#16740
            $k[$j++] = 1; //#16740
            $k[$j++] = 0; //#16740
        } //#16740
        $k[$j++] = 1; //#16740
        $_.checkpixs = $a(); //#16740
        var _10 = new Map([
            ["renlinear", bwipp_renlinear],
            ["renmatrix", bwipp_renmatrix]
        ]); //#16744
        $_.renmap = _10; //#16745
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_symbol.$ctx[id] = $_[id]); //#16745
        bwipp_symbol.__16747__ = 1; //#16745
        $_ = Object.getPrototypeOf($_); //#16745
    } //#16745
    var _1W = new Map([
        ["fima", function() {
            var _15 = new Map([
                ["ren", 'renlinear'],
                ["sbs", $_.fimasbs],
                ["bhs", $_.fimabhs],
                ["bbs", $_.fimabbs]
            ]); //#16750
            $k[$j++] = _15; //#16750
        }],
        ["fimb", function() {
            var _19 = new Map([
                ["ren", 'renlinear'],
                ["sbs", $_.fimbsbs],
                ["bhs", $_.fimbbhs],
                ["bbs", $_.fimbbbs]
            ]); //#16751
            $k[$j++] = _19; //#16751
        }],
        ["fimc", function() {
            var _1D = new Map([
                ["ren", 'renlinear'],
                ["sbs", $_.fimcsbs],
                ["bhs", $_.fimcbhs],
                ["bbs", $_.fimcbbs]
            ]); //#16752
            $k[$j++] = _1D; //#16752
        }],
        ["fimd", function() {
            var _1H = new Map([
                ["ren", 'renlinear'],
                ["sbs", $_.fimdsbs],
                ["bhs", $_.fimdbhs],
                ["bbs", $_.fimdbbs]
            ]); //#16753
            $k[$j++] = _1H; //#16753
        }],
        ["fime", function() {
            var _1L = new Map([
                ["ren", 'renlinear'],
                ["sbs", $_.fimesbs],
                ["bhs", $_.fimebhs],
                ["bbs", $_.fimebbs]
            ]); //#16754
            $k[$j++] = _1L; //#16754
        }],
        ["zebra", function() {
            var _1P = new Map([
                ["ren", 'renlinear'],
                ["sbs", $_.zebrasbs],
                ["bhs", $_.zebrabhs],
                ["bbs", $_.zebrabbs]
            ]); //#16755
            $k[$j++] = _1P; //#16755
        }],
        ["check", function() {
            var _1V = new Map([
                ["ren", 'renmatrix'],
                ["pixs", $_.checkpixs],
                ["pixx", $_.checksize],
                ["pixy", $_.checksize],
                ["height", $_.checksize / 72],
                ["width", $_.checksize / 72]
            ]); //#16756
            $k[$j++] = _1V; //#16756
        }]
    ]); //#16756
    $_.symbols = _1W; //#16757
    var _1Z = $get($_.symbols, $_.barcode) !== undefined; //#16760
    if (!_1Z) { //#16762
        $k[$j++] = 'bwipp.symbolUnknownSymbol#16761'; //#16761
        $k[$j++] = "Unknown symbol name provided"; //#16761
        bwipp_raiseerror(); //#16761
    } //#16761
    if ($get($_.symbols, $_.barcode)() === true) {
        return true;
    } //#16764
    var _1d = $k[--$j]; //#16765
    $put(_1d, 'opt', $_.options); //#16765
    $k[$j++] = _1d; //#16767
    if (!$_.dontdraw) { //#16767
        var _1g = $k[--$j]; //#16767
        $k[$j++] = _1g; //#16767
        if ($get($_.renmap, $get(_1g, 'ren'))() === true) {
            return true;
        } //#16767
    } //#16767
    $_ = Object.getPrototypeOf($_); //#16769
    $_ = Object.getPrototypeOf($_); //#16771
} //bwipp_symbol
function bwipp_pdf417() {
    $_ = Object.create($_); //#16802
    $_.dontdraw = false; //#16805
    $_.compact = false; //#16806
    $_.eclevel = -1; //#16807
    $_.columns = 0; //#16808
    $_.rows = 0; //#16809
    $_.rowmult = 3; //#16810
    $_.ccc = false; //#16811
    $_.raw = false; //#16812
    $_.parse = false; //#16813
    $_.parsefnc = false; //#16814
    $k[$j++] = $_; //#16816
    bwipp_processoptions(); //#16816
    $_.options = $k[--$j]; //#16816
    $_.barcode = $k[--$j]; //#16817
    if ($eq($_.barcode, "")) { //#16821
        $k[$j++] = 'bwipp.pdf417emptyData#16820'; //#16820
        $k[$j++] = "The data must not be empty"; //#16820
        bwipp_raiseerror(); //#16820
    } //#16820
    if (($_.eclevel != -1) && (($_.eclevel < 0) || ($_.eclevel > 8))) { //#16825
        $k[$j++] = 'bwipp.pdf417InvalidErrorCorrectionLevel#16824'; //#16824
        $k[$j++] = "Valid error correction levels are 0 to 8"; //#16824
        bwipp_raiseerror(); //#16824
    } //#16824
    if ($_.ccc && $_.raw) { //#16829
        $k[$j++] = 'bwipp.pdf417cccAndRaw#16828'; //#16828
        $k[$j++] = "Cannot combine ccc and raw"; //#16828
        bwipp_raiseerror(); //#16828
    } //#16828
    if ($_.ccc && $_.compact) { //#16833
        $k[$j++] = 'bwipp.pdf417cccAndCompact#16832'; //#16832
        $k[$j++] = "Cannot combine ccc and compact"; //#16832
        bwipp_raiseerror(); //#16832
    } //#16832
    if (($_.rows != 0) && (($_.rows < 3) || ($_.rows > 90))) { //#16837
        $k[$j++] = 'bwipp.pdf417invalidRows#16836'; //#16836
        $k[$j++] = "There must be between 3 and 90 rows"; //#16836
        bwipp_raiseerror(); //#16836
    } //#16836
    if (($_.columns != 0) && (($_.columns < 1) || ($_.columns > 30))) { //#16841
        $k[$j++] = 'bwipp.pdf417invalidColumns#16840'; //#16840
        $k[$j++] = "There must be between 1 and 30 columns"; //#16840
        bwipp_raiseerror(); //#16840
    } //#16840
    if ($_.rowmult <= 0) { //#16845
        $k[$j++] = 'bwipp.pdf417badRowMult#16844'; //#16844
        $k[$j++] = "The row multiplier must be greater than zero"; //#16844
        bwipp_raiseerror(); //#16844
    } //#16844
    bwipp_loadctx(bwipp_pdf417) //#16847
    if (!bwipp_pdf417.__16938__) { //#16938
        $_ = Object.create($_); //#16938
        $_.T = 0; //#16851
        $_.N = 1; //#16851
        $_.B = 2; //#16851
        $_.A = 0; //#16852
        $_.L = 1; //#16852
        $_.M = 2; //#16852
        $_.P = 3; //#16852
        $_.tl = -1; //#16855
        $_.nl = -2; //#16855
        $_.bl = -3; //#16855
        $_.bl6 = -4; //#16855
        $_.bs = -5; //#16855
        $_.al = -6; //#16858
        $_.ll = -7; //#16858
        $_.ml = -8; //#16858
        $_.pl = -9; //#16858
        $_.as = -10; //#16858
        $_.ps = -11; //#16858
        $_.charmaps = $a([$a(["A", "a", "0", ";"]), $a(["B", "b", "1", "<"]), $a(["C", "c", "2", ">"]), $a(["D", "d", "3", "@"]), $a(["E", "e", "4", "["]), $a(["F", "f", "5", 92]), $a(["G", "g", "6", "]"]), $a(["H", "h", "7", "_"]), $a(["I", "i", "8", "`"]), $a(["J", "j", "9", "~"]), $a(["K", "k", "&", "!"]), $a(["L", "l", 13, 13]), $a(["M", "m", 9, 9]), $a(["N", "n", ",", ","]), $a(["O", "o", ":", ":"]), $a(["P", "p", "#", 10]), $a(["Q", "q", "-", "-"]), $a(["R", "r", ".", "."]), $a(["S", "s", "$", "$"]), $a(["T", "t", "/", "/"]), $a(["U", "u", "+", "\""]), $a(["V", "v", "%", "|"]), $a(["W", "w", "*", "*"]), $a(["X", "x", "=", 40]), $a(["Y", "y", "^", 41]), $a(["Z", "z", $_.pl, "?"]), $a([" ", " ", " ", "{"]), $a([$_.ll, $_.as, $_.ll, "}"]), $a([$_.ml, $_.ml, $_.al, "'"]), $a([$_.ps, $_.ps, $_.ps, $_.al])]); //#16893
        $_.charvals = $a([new Map, new Map, new Map, new Map]); //#16896
        $_.alltext = new Map; //#16897
        for (var _10 = 0, _z = $_.charmaps.length - 1; _10 <= _z; _10 += 1) { //#16907
            $_.i = _10; //#16899
            $_.encs = $get($_.charmaps, $_.i); //#16900
            for (var _14 = 0; _14 <= 3; _14 += 1) { //#16906
                $_.j = _14; //#16902
                var _17 = $get($_.encs, $_.j); //#16903
                $k[$j++] = _17; //#16903
                if ($eq($type(_17), 'stringtype')) { //#16903
                    var _1A = $get($k[--$j], 0); //#16903
                    $k[$j++] = _1A; //#16903
                } //#16903
                var _1B = $k[--$j]; //#16904
                $put($get($_.charvals, $_.j), _1B, $_.i); //#16904
                $put($_.alltext, _1B, -1); //#16905
            } //#16905
        } //#16905
        $_.e = 10000; //#16909
        $_.latlen = $a([$a([0, 1, 1, 2]), $a([2, 0, 1, 2]), $a([1, 1, 0, 1]), $a([1, 2, 2, 0])]); //#16917
        $_.latseq = $a([$a([$a([]), $a([$_.ll]), $a([$_.ml]), $a([$_.ml, $_.pl])]), $a([$a([$_.ml, $_.al]), $a([]), $a([$_.ml]), $a([$_.ml, $_.pl])]), $a([$a([$_.al]), $a([$_.ll]), $a([]), $a([$_.pl])]), $a([$a([$_.al]), $a([$_.al, $_.ll]), $a([$_.al, $_.ml]), $a([])])]); //#16925
        $_.shftlen = $a([$a([$_.e, $_.e, $_.e, 1]), $a([1, $_.e, $_.e, 1]), $a([$_.e, $_.e, $_.e, 1]), $a([$_.e, $_.e, $_.e, $_.e])]); //#16933
        $k[$j++] = Infinity; //#16935
        $k[$j++] = $_.tl; //#16936
        $k[$j++] = 900; //#16936
        $k[$j++] = $_.bl; //#16936
        $k[$j++] = 901; //#16936
        $k[$j++] = $_.bl6; //#16936
        $k[$j++] = 924; //#16936
        $k[$j++] = $_.nl; //#16936
        $k[$j++] = 902; //#16936
        $k[$j++] = $_.bs; //#16936
        $k[$j++] = 913; //#16936
        $_.latchcws = $d(); //#16937
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_pdf417.$ctx[id] = $_[id]); //#16937
        bwipp_pdf417.__16938__ = 1; //#16937
        $_ = Object.getPrototypeOf($_); //#16937
    } //#16937
    if ($_.raw) { //#16959
        $_.datcws = $a($_.barcode.length); //#16942
        $_.i = 0; //#16943
        $_.j = 0; //#16943
        for (;;) { //#16954
            if ($_.i >= ($_.barcode.length - 3)) { //#16945
                break; //#16945
            } //#16945
            if ($get($_.barcode, $_.i) != 94) { //#16946
                break; //#16946
            } //#16946
            var _2W = $geti($_.barcode, $_.i + 1, 3); //#16947
            $k[$j++] = _2W; //#16949
            $k[$j++] = false; //#16949
            for (var _2X = 0, _2Y = _2W.length; _2X < _2Y; _2X++) { //#16949
                var _2Z = $get(_2W, _2X); //#16949
                if ((_2Z < 48) || (_2Z > 57)) { //#16948
                    $j--; //#16948
                    $k[$j++] = true; //#16948
                } //#16948
            } //#16948
            if ($k[--$j]) { //#16949
                $j--; //#16949
                break; //#16949
            } //#16949
            $_.cw = $cvi($k[--$j]); //#16950
            $put($_.datcws, $_.j, $_.cw); //#16951
            $_.i = $_.i + 4; //#16952
            $_.j = $_.j + 1; //#16953
        } //#16953
        if ($_.i != $_.barcode.length) { //#16957
            $k[$j++] = 'bwipp.pdf417badRawFormat#16956'; //#16956
            $k[$j++] = "raw data must be formatted as ^NNN"; //#16956
            bwipp_raiseerror(); //#16956
        } //#16956
        $_.datcws = $geti($_.datcws, 0, $_.j); //#16958
    } //#16958
    $_.encb = function() {
        $_.in = $k[--$j]; //#16962
        $_.inlen = $_.in.length; //#16963
        $_.out = $a(((~~($_.inlen / 6)) * 5) + ($_.inlen % 6)); //#16964
        for (var _2t = 0, _2s = (~~($_.inlen / 6)) - 1; _2t <= _2s; _2t += 1) { //#16987
            $_.k = _2t; //#16966
            $k[$j++] = Infinity; //#16967
            $aload($geti($_.in, $_.k * 6, 3)); //#16967
            $_.msbs = $a(); //#16967
            $k[$j++] = Infinity; //#16968
            $aload($_.msbs); //#16969
            var _2z = $k[--$j]; //#16969
            var _30 = $k[--$j]; //#16969
            var _31 = $k[--$j]; //#16969
            $k[$j++] = $f(($f(_2z + (_30 * 256))) + (_31 * 65536)); //#16970
            for (var _32 = 0, _33 = 3; _32 < _33; _32++) { //#16970
                var _34 = $k[--$j]; //#16970
                $k[$j++] = _34 % 900; //#16970
                $k[$j++] = ~~(_34 / 900); //#16970
            } //#16970
            $_.mscs = $a(); //#16970
            $k[$j++] = Infinity; //#16972
            $aload($geti($_.in, ($_.k * 6) + 3, 3)); //#16972
            $_.lsbs = $a(); //#16972
            $k[$j++] = Infinity; //#16973
            $aload($_.lsbs); //#16974
            var _3B = $k[--$j]; //#16974
            var _3C = $k[--$j]; //#16974
            var _3D = $k[--$j]; //#16974
            $k[$j++] = $f(($f(_3B + (_3C * 256))) + (_3D * 65536)); //#16975
            for (var _3E = 0, _3F = 3; _3E < _3F; _3E++) { //#16975
                var _3G = $k[--$j]; //#16975
                $k[$j++] = _3G % 900; //#16975
                $k[$j++] = ~~(_3G / 900); //#16975
            } //#16975
            $_.lscs = $a(); //#16975
            var _3J = $get($_.lscs, 0); //#16977
            var _3L = $get($_.mscs, 0); //#16977
            $put($_.out, ($_.k * 5) + 4, ($f(_3J + (_3L * 316))) % 900); //#16978
            var _3P = $get($_.lscs, 1); //#16979
            var _3R = $get($_.mscs, 0); //#16979
            var _3T = $get($_.mscs, 1); //#16979
            $put($_.out, ($_.k * 5) + 3, ($f(($f(($f((~~(($f(_3J + (_3L * 316))) / 900)) + _3P)) + (_3R * 641))) + (_3T * 316))) % 900); //#16980
            var _3X = $get($_.lscs, 2); //#16981
            var _3Z = $get($_.mscs, 0); //#16981
            var _3b = $get($_.mscs, 1); //#16981
            var _3d = $get($_.mscs, 2); //#16981
            $put($_.out, ($_.k * 5) + 2, ($f(($f(($f(($f((~~(($f(($f(($f((~~(($f(_3J + (_3L * 316))) / 900)) + _3P)) + (_3R * 641))) + (_3T * 316))) / 900)) + _3X)) + (_3Z * 20))) + (_3b * 641))) + (_3d * 316))) % 900); //#16982
            var _3h = $get($_.lscs, 3); //#16983
            var _3j = $get($_.mscs, 1); //#16983
            var _3l = $get($_.mscs, 2); //#16983
            $put($_.out, ($_.k * 5) + 1, ($f(($f(($f((~~(($f(($f(($f(($f((~~(($f(($f(($f((~~(($f(_3J + (_3L * 316))) / 900)) + _3P)) + (_3R * 641))) + (_3T * 316))) / 900)) + _3X)) + (_3Z * 20))) + (_3b * 641))) + (_3d * 316))) / 900)) + _3h)) + (_3j * 20))) + (_3l * 641))) % 900); //#16984
            $put($_.out, $_.k * 5, ($f((~~(($f(($f(($f((~~(($f(($f(($f(($f((~~(($f(($f(($f((~~(($f(_3J + (_3L * 316))) / 900)) + _3P)) + (_3R * 641))) + (_3T * 316))) / 900)) + _3X)) + (_3Z * 20))) + (_3b * 641))) + (_3d * 316))) / 900)) + _3h)) + (_3j * 20))) + (_3l * 641))) / 900)) + ($get($_.mscs, 2) * 20))) % 900); //#16986
        } //#16986
        $_.rem = $_.inlen % 6; //#16988
        if ($_.rem != 0) { //#16993
            $k[$j++] = $_.out; //#16991
            $k[$j++] = $_.out.length - $_.rem; //#16991
            $k[$j++] = Infinity; //#16991
            $aload($geti($_.in, $_.inlen - $_.rem, $_.rem)); //#16991
            var _42 = $a(); //#16991
            var _43 = $k[--$j]; //#16992
            $puti($k[--$j], _43, _42); //#16992
        } //#16992
        $k[$j++] = $_.out; //#16994
    }; //#16994
    if ($_.ccc) { //#17003
        $_.barlen = $_.barcode.length; //#16998
        $_.datcws = $a((((~~($_.barlen / 6)) * 5) + ($_.barlen % 6)) + 2); //#16999
        $put($_.datcws, 0, 920); //#17000
        var _4E = (($_.barlen % 6) == 0) ? 924 : 901; //#17001
        $put($_.datcws, 1, _4E); //#17001
        $k[$j++] = $_.datcws; //#17002
        $k[$j++] = 2; //#17002
        $k[$j++] = Infinity; //#17002
        $forall($_.barcode); //#17002
        var _4H = $a(); //#17002
        $k[$j++] = _4H; //#17002
        $_.encb(); //#17002
        var _4I = $k[--$j]; //#17002
        var _4J = $k[--$j]; //#17002
        $puti($k[--$j], _4J, _4I); //#17002
    } //#17002
    if ((!$_.raw) && (!$_.ccc)) { //#17354
        var _4P = new Map([
            ["parse", $_.parse],
            ["parsefnc", $_.parsefnc],
            ["eci", true]
        ]); //#17011
        $_.fncvals = _4P; //#17013
        $k[$j++] = 'msg'; //#17014
        $k[$j++] = $_.barcode; //#17014
        $k[$j++] = $_.fncvals; //#17014
        bwipp_parseinput(); //#17014
        var _4S = $k[--$j]; //#17014
        $_[$k[--$j]] = _4S; //#17014
        $_.msglen = $_.msg.length; //#17015
        $k[$j++] = Infinity; //#17018
        for (var _4W = 0, _4X = $_.msglen; _4W < _4X; _4W++) { //#17018
            $k[$j++] = 0; //#17018
        } //#17018
        $k[$j++] = 0; //#17018
        $_.numdigits = $a(); //#17018
        $k[$j++] = Infinity; //#17019
        for (var _4a = 0, _4b = $_.msglen; _4a < _4b; _4a++) { //#17019
            $k[$j++] = 0; //#17019
        } //#17019
        $k[$j++] = 0; //#17019
        $_.numtext = $a(); //#17019
        $k[$j++] = Infinity; //#17020
        for (var _4e = 0, _4f = $_.msglen; _4e < _4f; _4e++) { //#17020
            $k[$j++] = 0; //#17020
        } //#17020
        $k[$j++] = 0; //#17020
        $_.numbytes = $a(); //#17020
        $k[$j++] = Infinity; //#17021
        for (var _4i = 0, _4j = $_.msglen; _4i < _4j; _4i++) { //#17021
            $k[$j++] = 0; //#17021
        } //#17021
        $k[$j++] = 0; //#17021
        $_.iseci = $a(); //#17021
        for (var _4m = $_.msglen - 1; _4m >= 0; _4m -= 1) { //#17034
            $_.i = _4m; //#17023
            var _4p = $get($_.msg, $_.i); //#17024
            if ((_4p >= 48) && (_4p <= 57)) { //#17026
                $put($_.numdigits, $_.i, $f($get($_.numdigits, $_.i + 1) + 1)); //#17025
            } //#17025
            var _4z = $get($_.alltext, $get($_.msg, $_.i)) !== undefined; //#17027
            if (_4z && ($get($_.numdigits, $_.i) < 13)) { //#17029
                $put($_.numtext, $_.i, $f($get($_.numtext, $_.i + 1) + 1)); //#17028
            } //#17028
            if ((($get($_.msg, $_.i) >= 0) && ($get($_.numtext, $_.i) < 5)) && ($get($_.numdigits, $_.i) < 13)) { //#17032
                $put($_.numbytes, $_.i, $f($get($_.numbytes, $_.i + 1) + 1)); //#17031
            } //#17031
            $put($_.iseci, $_.i, $get($_.msg, $_.i) <= -1000000); //#17033
        } //#17033
        $_.numdigits = $geti($_.numdigits, 0, $_.msglen); //#17035
        $_.numtext = $geti($_.numtext, 0, $_.msglen); //#17036
        $_.numbytes = $geti($_.numbytes, 0, $_.msglen); //#17037
        $_.seq = $a([]); //#17039
        $_.seqlen = 0; //#17039
        $_.state = $_.T; //#17039
        $_.p = 0; //#17039
        for (;;) { //#17093
            if ($_.p == $_.msglen) { //#17040
                break; //#17040
            } //#17040
            if ($get($_.iseci, $_.p)) { //#17091
                $_.eci = $get($_.msg, $_.p); //#17042
                $k[$j++] = Infinity; //#17043
                $aload($_.seq); //#17044
                $k[$j++] = $a([$_.eci]); //#17045
                $_.seq = $a(); //#17045
                $_.p = $_.p + 1; //#17047
                $k[$j++] = 'seqlen'; //#17048
                $k[$j++] = $_.seqlen; //#17048
                if ($_.eci <= -1810900) { //#17048
                    $k[$j++] = 2; //#17048
                } else { //#17048
                    var _5s = ($_.eci <= -1000900) ? 3 : 2; //#17048
                    $k[$j++] = _5s; //#17048
                } //#17048
                var _5t = $k[--$j]; //#17048
                var _5u = $k[--$j]; //#17048
                $_[$k[--$j]] = $f(_5u + _5t); //#17048
            } else { //#17091
                $_.n = $get($_.numdigits, $_.p); //#17050
                if (($_.n >= 13) || (($_.n == $_.msglen) && ($_.n >= 8))) { //#17091
                    $k[$j++] = Infinity; //#17052
                    $aload($_.seq); //#17053
                    $k[$j++] = $_.nl; //#17055
                    $k[$j++] = Infinity; //#17055
                    $aload($geti($_.msg, $_.p, $_.n)); //#17055
                    var _69 = $a(); //#17055
                    $k[$j++] = _69; //#17055
                    $_.seq = $a(); //#17055
                    $_.state = $_.N; //#17057
                    $_.p = $f($_.p + $_.n); //#17058
                    $_.seqlen = $f(($_.seqlen + 1) + $_.n); //#17059
                } else { //#17091
                    $_.t = $get($_.numtext, $_.p); //#17061
                    if ($_.t >= 5) { //#17091
                        $k[$j++] = Infinity; //#17063
                        $aload($_.seq); //#17064
                        if ($_.state != $_.T) { //#17067
                            $k[$j++] = $_.tl; //#17066
                        } //#17066
                        $k[$j++] = Infinity; //#17068
                        $aload($geti($_.msg, $_.p, $_.t)); //#17068
                        var _6S = $a(); //#17068
                        $k[$j++] = _6S; //#17068
                        $_.seq = $a(); //#17068
                        $_.state = $_.T; //#17070
                        $_.p = $f($_.p + $_.t); //#17071
                        $_.seqlen = $f($f($_.seqlen + 1) + $_.t); //#17072
                    } else { //#17091
                        $_.b = $get($_.numbytes, $_.p); //#17074
                        if (($_.b == 1) && ($_.state == $_.T)) { //#17091
                            $k[$j++] = Infinity; //#17076
                            $aload($_.seq); //#17077
                            $k[$j++] = $_.bs; //#17079
                            $k[$j++] = $a([$get($_.msg, $_.p)]); //#17079
                            $_.seq = $a(); //#17079
                            $_.p = $f($_.p + $_.b); //#17081
                            $_.seqlen = $f($_.seqlen + 2); //#17082
                        } else { //#17091
                            $k[$j++] = Infinity; //#17084
                            $aload($_.seq); //#17085
                            var _6r = (($_.b % 6) != 0) ? $_.bl : $_.bl6; //#17086
                            $k[$j++] = _6r; //#17087
                            $k[$j++] = Infinity; //#17087
                            $aload($geti($_.msg, $_.p, $_.b)); //#17087
                            var _6w = $a(); //#17087
                            $k[$j++] = _6w; //#17087
                            $_.seq = $a(); //#17087
                            $_.state = $_.B; //#17089
                            $_.p = $f($_.p + $_.b); //#17090
                            $_.seqlen = $f($f($_.seqlen + 1) + $_.b); //#17091
                        } //#17091
                    } //#17091
                } //#17091
            } //#17091
        } //#17091
        $_.enca = function() {
            var _77 = $get($get($_.charvals, $_.A), $k[--$j]); //#17096
            $k[$j++] = _77; //#17096
        }; //#17096
        $_.encl = function() {
            var _7C = $get($get($_.charvals, $_.L), $k[--$j]); //#17097
            $k[$j++] = _7C; //#17097
        }; //#17097
        $_.encm = function() {
            var _7H = $get($get($_.charvals, $_.M), $k[--$j]); //#17098
            $k[$j++] = _7H; //#17098
        }; //#17098
        $_.encp = function() {
            var _7M = $get($get($_.charvals, $_.P), $k[--$j]); //#17099
            $k[$j++] = _7M; //#17099
        }; //#17099
        $_.textencfuncs = $a(['enca', 'encl', 'encm', 'encp']); //#17100
        $_.addtotext = function() {
            $put($_.text, $_.l, $k[--$j]); //#17103
            $_.l = $_.l + 1; //#17104
        }; //#17104
        $_.enct = function() {
            $_.in = $k[--$j]; //#17108
            $_.curlen = $a([$_.e, $_.e, $_.e, $_.e]); //#17110
            $put($_.curlen, $_.submode, 0); //#17111
            $_.curseq = $a([$a([]), $a([]), $a([]), $a([])]); //#17112
            $forall($_.in, function() { //#17182
                $_.char = $k[--$j]; //#17117
                for (;;) { //#17138
                    $_.imp = false; //#17121
                    var _7l = $a([$_.A, $_.L, $_.M, $_.P]); //#17122
                    for (var _7m = 0, _7n = _7l.length; _7m < _7n; _7m++) { //#17136
                        $_.x = $get(_7l, _7m); //#17123
                        var _7t = $a([$_.A, $_.L, $_.M, $_.P]); //#17124
                        for (var _7u = 0, _7v = _7t.length; _7u < _7v; _7u++) { //#17135
                            $_.y = $get(_7t, _7u); //#17125
                            $_.cost = $f($get($_.curlen, $_.x) + $get($get($_.latlen, $_.x), $_.y)); //#17126
                            if ($_.cost < $get($_.curlen, $_.y)) { //#17134
                                $put($_.curlen, $_.y, $_.cost); //#17128
                                $k[$j++] = $_.curseq; //#17131
                                $k[$j++] = $_.y; //#17131
                                $k[$j++] = Infinity; //#17129
                                $aload($get($_.curseq, $_.x)); //#17130
                                $aload($get($get($_.latseq, $_.x), $_.y)); //#17131
                                var _8M = $a(); //#17131
                                var _8N = $k[--$j]; //#17132
                                $put($k[--$j], _8N, _8M); //#17132
                                $_.imp = true; //#17133
                            } //#17133
                        } //#17133
                    } //#17133
                    if (!$_.imp) { //#17137
                        break; //#17137
                    } //#17137
                } //#17137
                $_.nxtlen = $a([$_.e, $_.e, $_.e, $_.e]); //#17141
                $_.nxtseq = $a(4); //#17142
                var _8a = $a([$_.A, $_.L, $_.M, $_.P]); //#17144
                for (var _8b = 0, _8c = _8a.length; _8b < _8c; _8b++) { //#17177
                    $_.x = $get(_8a, _8b); //#17145
                    for (;;) { //#17175
                        var _8i = $get($get($_.charvals, $_.x), $_.char) !== undefined; //#17149
                        if (!_8i) { //#17149
                            break; //#17149
                        } //#17149
                        $_.cost = $f($get($_.curlen, $_.x) + 1); //#17152
                        if ($_.cost < $get($_.nxtlen, $_.x)) { //#17156
                            $put($_.nxtlen, $_.x, $_.cost); //#17154
                            $k[$j++] = $_.nxtseq; //#17155
                            $k[$j++] = $_.x; //#17155
                            $k[$j++] = Infinity; //#17155
                            $aload($get($_.curseq, $_.x)); //#17155
                            $k[$j++] = $_.char; //#17155
                            var _8z = $a(); //#17155
                            var _90 = $k[--$j]; //#17155
                            $put($k[--$j], _90, _8z); //#17155
                        } //#17155
                        var _96 = $a([$_.A, $_.L, $_.M, $_.P]); //#17159
                        for (var _97 = 0, _98 = _96.length; _97 < _98; _97++) { //#17172
                            $_.y = $get(_96, _97); //#17160
                            if ($ne($_.x, $_.y)) { //#17171
                                $_.cost = $f($f($get($_.curlen, $_.y) + $get($get($_.shftlen, $_.y), $_.x)) + 1); //#17162
                                if ($_.cost < $get($_.nxtlen, $_.y)) { //#17170
                                    $put($_.nxtlen, $_.y, $_.cost); //#17164
                                    $k[$j++] = $_.nxtseq; //#17168
                                    $k[$j++] = $_.y; //#17168
                                    $k[$j++] = Infinity; //#17165
                                    $aload($get($_.curseq, $_.y)); //#17166
                                    var _9Y = ($_.x == $_.A) ? $_.as : $_.ps; //#17167
                                    $k[$j++] = _9Y; //#17168
                                    $k[$j++] = $_.char; //#17168
                                    var _9a = $a(); //#17168
                                    var _9b = $k[--$j]; //#17169
                                    $put($k[--$j], _9b, _9a); //#17169
                                } //#17169
                            } //#17169
                        } //#17169
                        break; //#17174
                    } //#17174
                } //#17174
                $_.curlen = $_.nxtlen; //#17179
                $_.curseq = $_.nxtseq; //#17180
            }); //#17180
            $_.minseq = $_.e; //#17185
            var _9k = $a([$_.A, $_.L, $_.M, $_.P]); //#17186
            for (var _9l = 0, _9m = _9k.length; _9l < _9m; _9l++) { //#17192
                $_.k = $get(_9k, _9l); //#17187
                if ($get($_.curlen, $_.k) < $_.minseq) { //#17191
                    $_.minseq = $get($_.curlen, $_.k); //#17189
                    $_.txtseq = $get($_.curseq, $_.k); //#17190
                } //#17190
            } //#17190
            $_.text = $a($_.minseq); //#17195
            $_.k = 0; //#17196
            $_.l = 0; //#17196
            for (;;) { //#17216
                if ($_.k >= $_.txtseq.length) { //#17197
                    break; //#17197
                } //#17197
                $_.char = $get($_.txtseq, $_.k); //#17199
                $k[$j++] = $_.char; //#17202
                if ($_[$get($_.textencfuncs, $_.submode)]() === true) {
                    break;
                } //#17202
                $_.addtotext(); //#17202
                $_.k = $_.k + 1; //#17203
                if (($_.char == $_.as) || ($_.char == $_.ps)) { //#17209
                    $k[$j++] = $get($_.txtseq, $_.k); //#17207
                    if ($_.char == $_.as) { //#17207
                        $_.enca(); //#17207
                    } else { //#17207
                        $_.encp(); //#17207
                    } //#17207
                    $_.addtotext(); //#17207
                    $_.k = $_.k + 1; //#17208
                } //#17208
                if ($_.char == $_.al) { //#17212
                    $_.submode = $_.A; //#17212
                } //#17212
                if ($_.char == $_.ll) { //#17213
                    $_.submode = $_.L; //#17213
                } //#17213
                if ($_.char == $_.ml) { //#17214
                    $_.submode = $_.M; //#17214
                } //#17214
                if ($_.char == $_.pl) { //#17215
                    $_.submode = $_.P; //#17215
                } //#17215
            } //#17215
            if (($_.text.length % 2) == 1) { //#17263
                if ($_.submode == $_.P) { //#17259
                    $k[$j++] = 'pad'; //#17220
                    $k[$j++] = $_.al; //#17220
                    $_.encp(); //#17220
                    var _Ab = $k[--$j]; //#17220
                    $_[$k[--$j]] = _Ab; //#17220
                    $_.submode = $_.A; //#17221
                } else { //#17259
                    $_.nextecitext = false; //#17224
                    for (var _Ah = $_.i + 1, _Ag = $_.seq.length - 1; _Ah <= _Ag; _Ah += 1) { //#17231
                        $_.ti = _Ah; //#17227
                        if ($ne($type($get($_.seq, $_.ti)), 'arraytype')) { //#17228
                            $_.nextecitext = false; //#17228
                            break; //#17228
                        } //#17228
                        if ($get($get($_.seq, $_.ti), 0) > -1000000) { //#17229
                            break; //#17229
                        } //#17229
                        $_.nextecitext = true; //#17230
                    } //#17230
                    if ($_.nextecitext) { //#17259
                        if ($_.submode == $_.A) { //#17256
                            var _B0 = $get($get($_.charvals, $_.L), $get($get($_.seq, $_.ti), 0)) !== undefined; //#17234
                            if (_B0) { //#17239
                                $k[$j++] = 'pad'; //#17235
                                $k[$j++] = $_.ll; //#17235
                                $_.enca(); //#17235
                                var _B2 = $k[--$j]; //#17235
                                $_[$k[--$j]] = _B2; //#17235
                                $_.submode = $_.L; //#17236
                            } else { //#17239
                                $k[$j++] = 'pad'; //#17238
                                $k[$j++] = $_.ml; //#17238
                                $_.enca(); //#17238
                                var _B6 = $k[--$j]; //#17238
                                $_[$k[--$j]] = _B6; //#17238
                                $_.submode = $_.M; //#17239
                            } //#17239
                        } else { //#17256
                            if ($_.submode == $_.M) { //#17256
                                var _BI = $get($get($_.charvals, $_.L), $get($get($_.seq, $_.ti), 0)) !== undefined; //#17243
                                if (_BI) { //#17252
                                    $k[$j++] = 'pad'; //#17244
                                    $k[$j++] = $_.ll; //#17244
                                    $_.encm(); //#17244
                                    var _BK = $k[--$j]; //#17244
                                    $_[$k[--$j]] = _BK; //#17244
                                    $_.submode = $_.L; //#17245
                                } else { //#17252
                                    var _BU = $get($get($_.charvals, $_.P), $get($get($_.seq, $_.ti), 0)) !== undefined; //#17247
                                    if (_BU) { //#17252
                                        $k[$j++] = 'pad'; //#17248
                                        $k[$j++] = $_.pl; //#17248
                                        $_.encm(); //#17248
                                        var _BW = $k[--$j]; //#17248
                                        $_[$k[--$j]] = _BW; //#17248
                                        $_.submode = $_.P; //#17249
                                    } else { //#17252
                                        $k[$j++] = 'pad'; //#17251
                                        $k[$j++] = $_.al; //#17251
                                        $_.encm(); //#17251
                                        var _Ba = $k[--$j]; //#17251
                                        $_[$k[--$j]] = _Ba; //#17251
                                        $_.submode = $_.A; //#17252
                                    } //#17252
                                } //#17252
                            } else { //#17256
                                $k[$j++] = 'pad'; //#17255
                                $k[$j++] = $_.ml; //#17255
                                $_.encl(); //#17255
                                var _Be = $k[--$j]; //#17255
                                $_[$k[--$j]] = _Be; //#17255
                                $_.submode = $_.M; //#17256
                            } //#17256
                        } //#17256
                    } else { //#17259
                        $k[$j++] = 'pad'; //#17259
                        $k[$j++] = $_.ps; //#17259
                        if ($_[$get($_.textencfuncs, $_.submode)]() === true) {
                            return true;
                        } //#17259
                        var _Bm = $k[--$j]; //#17259
                        $_[$k[--$j]] = _Bm; //#17259
                    } //#17259
                } //#17259
                $k[$j++] = Infinity; //#17262
                $aload($_.text); //#17262
                $k[$j++] = $_.pad; //#17262
                $_.text = $a(); //#17262
            } //#17262
            $_.out = $a(~~($_.text.length / 2)); //#17265
            for (var _Bv = 0, _Bu = $_.out.length - 1; _Bv <= _Bu; _Bv += 1) { //#17269
                $_.k = _Bv; //#17267
                $put($_.out, $_.k, $f(($get($_.text, $_.k * 2) * 30) + $get($_.text, ($_.k * 2) + 1))); //#17268
            } //#17268
            $k[$j++] = $_.out; //#17271
        }; //#17271
        $_.encn = function() {
            $_.in = $k[--$j]; //#17276
            $_.out = $a([]); //#17277
            for (var _C9 = 0, _C8 = $_.in.length - 1; _C9 <= _C8; _C9 += 44) { //#17305
                $_.k = _C9; //#17279
                $k[$j++] = Infinity; //#17280
                var _CE = $_.in.length - $_.k; //#17281
                $k[$j++] = 1; //#17281
                $k[$j++] = $_.in; //#17281
                $k[$j++] = $_.k; //#17281
                $k[$j++] = _CE; //#17281
                if (_CE > 44) { //#17281
                    $j--; //#17281
                    $k[$j++] = 44; //#17281
                } //#17281
                var _CF = $k[--$j]; //#17281
                var _CG = $k[--$j]; //#17281
                var _CI = $geti($k[--$j], _CG, _CF); //#17281
                for (var _CJ = 0, _CK = _CI.length; _CJ < _CK; _CJ++) { //#17282
                    $k[$j++] = $f($get(_CI, _CJ) - 48); //#17282
                } //#17282
                $_.gmod = $a(); //#17282
                $_.cwn = $a([]); //#17284
                for (;;) { //#17303
                    $_.dv = 900; //#17285
                    $_.gmul = $a([]); //#17286
                    $_.val = 0; //#17286
                    for (;;) { //#17298
                        if ($_.gmod.length == 0) { //#17287
                            break; //#17287
                        } //#17287
                        $_.val = $f(($_.val * 10) + $get($_.gmod, 0)); //#17288
                        $_.gmod = $geti($_.gmod, 1, $_.gmod.length - 1); //#17289
                        if ($_.val < $_.dv) { //#17295
                            if ($_.gmul.length != 0) { //#17293
                                $k[$j++] = Infinity; //#17292
                                $aload($_.gmul); //#17292
                                $k[$j++] = 0; //#17292
                                $_.gmul = $a(); //#17292
                            } //#17292
                        } else { //#17295
                            $k[$j++] = Infinity; //#17295
                            $aload($_.gmul); //#17295
                            $k[$j++] = ~~($_.val / $_.dv); //#17295
                            $_.gmul = $a(); //#17295
                        } //#17295
                        $_.val = $_.val % $_.dv; //#17297
                    } //#17297
                    $_.dv = $_.val; //#17299
                    $k[$j++] = Infinity; //#17300
                    $k[$j++] = $_.dv; //#17300
                    $aload($_.cwn); //#17300
                    $_.cwn = $a(); //#17300
                    $_.gmod = $_.gmul; //#17301
                    if ($_.gmul.length == 0) { //#17302
                        break; //#17302
                    } //#17302
                } //#17302
                $k[$j++] = Infinity; //#17304
                $aload($_.out); //#17304
                $aload($_.cwn); //#17304
                $_.out = $a(); //#17304
            } //#17304
            $k[$j++] = $_.out; //#17306
        }; //#17306
        $_.ence = function() {
            var _Ct = $f((-$get($k[--$j], 0)) - 1000000); //#17311
            $k[$j++] = _Ct; //#17319
            if (_Ct <= 899) { //#17318
                var _Cu = $k[--$j]; //#17312
                $k[$j++] = 927; //#17312
                $k[$j++] = _Cu; //#17312
                $astore($a(2)); //#17312
            } else { //#17318
                var _Cw = $k[--$j]; //#17313
                $k[$j++] = _Cw; //#17319
                if (_Cw <= 810899) { //#17318
                    var _Cx = $k[--$j]; //#17314
                    $k[$j++] = 926; //#17314
                    $k[$j++] = (~~(_Cx / 900)) - 1; //#17314
                    $k[$j++] = _Cx % 900; //#17314
                    $astore($a(3)); //#17314
                } else { //#17318
                    var _Cz = $k[--$j]; //#17315
                    $k[$j++] = _Cz; //#17319
                    if (_Cz <= 811799) { //#17318
                        var _D0 = $k[--$j]; //#17316
                        $k[$j++] = 925; //#17316
                        $k[$j++] = $f(_D0 - 810900); //#17316
                        $astore($a(2)); //#17316
                    } else { //#17318
                        $k[$j++] = 'bwipp.pdf417badECI#17318'; //#17318
                        $k[$j++] = "PDF417 supports ECIs 000000 to 811799"; //#17318
                        bwipp_raiseerror(); //#17318
                    } //#17318
                } //#17318
            } //#17318
        }; //#17318
        $_.encfuncs = $a(['enct', 'encn', 'encb']); //#17322
        $_.addtocws = function() {
            var _D3 = $k[--$j]; //#17325
            $puti($_.datcws, $_.j, _D3); //#17325
            $_.j = _D3.length + $_.j; //#17326
        }; //#17326
        $_.state = $_.T; //#17330
        $_.submode = $_.A; //#17330
        $_.datcws = $a($_.seqlen); //#17331
        $_.i = 0; //#17332
        $_.j = 0; //#17332
        for (;;) { //#17352
            if ($_.i >= $_.seq.length) { //#17333
                break; //#17333
            } //#17333
            $_.chars = $get($_.seq, $_.i); //#17334
            if ($eq($type($_.chars), 'arraytype')) { //#17348
                if ($get($_.chars, 0) <= -1000000) { //#17339
                    $k[$j++] = $_.chars; //#17337
                    $_.ence(); //#17337
                    $_.addtocws(); //#17337
                } else { //#17339
                    $k[$j++] = $_.chars; //#17339
                    if ($_[$get($_.encfuncs, $_.state)]() === true) {
                        break;
                    } //#17339
                    $_.addtocws(); //#17339
                } //#17339
            } else { //#17348
                $k[$j++] = $a([$get($_.latchcws, $_.chars)]); //#17342
                $_.addtocws(); //#17342
                if ($_.chars == $_.tl) { //#17343
                    $_.state = $_.T; //#17343
                    $_.submode = $_.A; //#17343
                } //#17343
                if ($_.chars == $_.nl) { //#17344
                    $_.state = $_.N; //#17344
                } //#17344
                if (($_.chars == $_.bl) || ($_.chars == $_.bl6)) { //#17345
                    $_.state = $_.B; //#17345
                } //#17345
                if ($_.chars == $_.bs) { //#17349
                    $_.i = $_.i + 1; //#17347
                    $k[$j++] = $get($_.seq, $_.i); //#17348
                    $_.encb(); //#17348
                    $_.addtocws(); //#17348
                } //#17348
            } //#17348
            $_.i = $_.i + 1; //#17351
        } //#17351
        $_.datcws = $geti($_.datcws, 0, $_.j); //#17353
    } //#17353
    $_.m = $_.datcws.length; //#17357
    if ($_.eclevel == -1) { //#17363
        if ($_.m <= 40) { //#17359
            $_.eclevel = 2; //#17359
        } //#17359
        if (($_.m >= 41) && ($_.m <= 160)) { //#17360
            $_.eclevel = 3; //#17360
        } //#17360
        if (($_.m >= 161) && ($_.m <= 320)) { //#17361
            $_.eclevel = 4; //#17361
        } //#17361
        if ($_.m >= 321) { //#17362
            $_.eclevel = 5; //#17362
        } //#17362
    } //#17362
    $_.maxeclevel = (~~((Math.log((928 - 1) - $_.m)) / Math.log(2))) - 1; //#17366
    if ($_.eclevel > $_.maxeclevel) { //#17367
        $_.eclevel = $_.maxeclevel; //#17367
    } //#17367
    $_.k = ~~Math.pow(2, $_.eclevel + 1); //#17368
    if ($_.columns == 0) { //#17371
        $_.columns = ~~(Math.round(Math.sqrt(($_.m + $_.k) / 3))); //#17371
    } //#17371
    $k[$j++] = 'c'; //#17372
    if ($_.columns >= 1) { //#17372
        $k[$j++] = $_.columns; //#17372
    } else { //#17372
        $k[$j++] = 1; //#17372
    } //#17372
    var _E8 = $k[--$j]; //#17372
    $_[$k[--$j]] = _E8; //#17372
    $_.r = ~~(Math.ceil((($_.m + $_.k) + 1) / $_.columns)); //#17375
    if (($_.r < $_.rows) && ($_.rows <= 90)) { //#17376
        $_.r = $_.rows; //#17376
    } //#17376
    if ($_.r < 3) { //#17377
        $_.r = 3; //#17377
    } //#17377
    if ($_.r > 90) { //#17382
        $k[$j++] = 'bwipp.pdf417insufficientCapacity#17381'; //#17381
        $k[$j++] = "Insufficient capacity in the symbol"; //#17381
        bwipp_raiseerror(); //#17381
    } //#17381
    var _EJ = $_.c; //#17385
    var _EK = $_.r; //#17385
    var _EL = $_.m; //#17385
    var _EM = 8; //#17385
    var _EN = (~~((Math.log($f(($f((_EJ * _EK) - 1)) - _EL))) / Math.log(2))) - 1; //#17385
    if (((~~((Math.log($f(($f((_EJ * _EK) - 1)) - _EL))) / Math.log(2))) - 1) > 8) { //#17385
        var _ = _EM; //#17385
        _EM = _EN; //#17385
        _EN = _; //#17385
    } //#17385
    $_.maxeclevel = _EN; //#17385
    if ($_.maxeclevel > $_.eclevel) { //#17389
        $_.eclevel = $_.maxeclevel; //#17387
        $_.k = ~~Math.pow(2, $_.eclevel + 1); //#17388
    } //#17388
    $_.n = $f(($_.c * $_.r) - $_.k); //#17392
    $_.cws = $a($f(($_.c * $_.r) + 1)); //#17393
    $put($_.cws, 0, $_.n); //#17394
    $puti($_.cws, 1, $_.datcws); //#17395
    $k[$j++] = $_.cws; //#17396
    $k[$j++] = $_.m + 1; //#17396
    $k[$j++] = Infinity; //#17396
    for (var _Eg = 0, _Eh = $f($f($_.n - $_.m) - 1); _Eg < _Eh; _Eg++) { //#17396
        $k[$j++] = 900; //#17396
    } //#17396
    var _Ei = $a(); //#17396
    var _Ej = $k[--$j]; //#17396
    $puti($k[--$j], _Ej, _Ei); //#17396
    $k[$j++] = $_.cws; //#17397
    $k[$j++] = $_.n; //#17397
    $k[$j++] = Infinity; //#17397
    for (var _Eo = 0, _Ep = $_.k; _Eo < _Ep; _Eo++) { //#17397
        $k[$j++] = 0; //#17397
    } //#17397
    $k[$j++] = 0; //#17397
    var _Eq = $a(); //#17397
    var _Er = $k[--$j]; //#17397
    $puti($k[--$j], _Er, _Eq); //#17397
    if (!bwipp_pdf417.__17404__) { //#17404
        $_ = Object.create($_); //#17404
        $k[$j++] = Infinity; //#17401
        $k[$j++] = 1; //#17401
        for (var _Et = 0, _Eu = 928; _Et < _Eu; _Et++) { //#17401
            var _Ev = $k[--$j]; //#17401
            $k[$j++] = _Ev; //#17401
            $k[$j++] = (_Ev * 3) % 929; //#17401
        } //#17401
        $_.rsalog = $a(); //#17401
        $_.rslog = $a(929); //#17402
        for (var _Ey = 1; _Ey <= 928; _Ey += 1) { //#17403
            $put($_.rslog, $get($_.rsalog, _Ey), _Ey); //#17403
        } //#17403
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_pdf417.$ctx[id] = $_[id]); //#17403
        bwipp_pdf417.__17404__ = 1; //#17403
        $_ = Object.getPrototypeOf($_); //#17403
    } //#17403
    $_.rsprod = function() {
        var _F3 = $k[--$j]; //#17408
        var _F4 = $k[--$j]; //#17408
        $k[$j++] = _F4; //#17412
        $k[$j++] = _F3; //#17412
        if ((_F3 != 0) && (_F4 != 0)) { //#17411
            var _F7 = $get($_.rslog, $k[--$j]); //#17409
            var _FC = $get($_.rsalog, $f(_F7 + $get($_.rslog, $k[--$j])) % 928); //#17409
            $k[$j++] = _FC; //#17409
        } else { //#17411
            $j -= 2; //#17411
            $k[$j++] = 0; //#17411
        } //#17411
    }; //#17411
    $k[$j++] = Infinity; //#17416
    $k[$j++] = 1; //#17416
    for (var _FE = 0, _FF = $_.k; _FE < _FF; _FE++) { //#17416
        $k[$j++] = 0; //#17416
    } //#17416
    $_.coeffs = $a(); //#17416
    for (var _FJ = 1, _FI = $_.k; _FJ <= _FI; _FJ += 1) { //#17425
        $_.i = _FJ; //#17418
        $put($_.coeffs, $_.i, $get($_.coeffs, $_.i - 1)); //#17419
        for (var _FQ = $_.i - 1; _FQ >= 1; _FQ -= 1) { //#17423
            $_.j = _FQ; //#17421
            $k[$j++] = $_.coeffs; //#17422
            $k[$j++] = $_.j; //#17422
            $k[$j++] = $get($_.coeffs, $_.j - 1); //#17422
            $k[$j++] = $get($_.coeffs, $_.j); //#17422
            $k[$j++] = $get($_.rsalog, $_.i); //#17422
            $_.rsprod(); //#17422
            var _Fc = $k[--$j]; //#17422
            var _Fd = $k[--$j]; //#17422
            var _Fe = $k[--$j]; //#17422
            $put($k[--$j], _Fe, $f(_Fd + _Fc) % 929); //#17422
        } //#17422
        $k[$j++] = $_.coeffs; //#17424
        $k[$j++] = 0; //#17424
        $k[$j++] = $get($_.coeffs, 0); //#17424
        $k[$j++] = $get($_.rsalog, $_.i); //#17424
        $_.rsprod(); //#17424
        var _Fm = $k[--$j]; //#17424
        var _Fn = $k[--$j]; //#17424
        $put($k[--$j], _Fn, _Fm); //#17424
    } //#17424
    $_.coeffs = $geti($_.coeffs, 0, $_.coeffs.length - 1); //#17426
    for (var _Ft = $_.coeffs.length - 1; _Ft >= 0; _Ft -= 2) { //#17427
        var _Fu = $_.coeffs; //#17427
        $put(_Fu, _Ft, $f(929 - $get(_Fu, _Ft))); //#17427
    } //#17427
    for (var _Fy = 0, _Fx = $f($_.n - 1); _Fy <= _Fx; _Fy += 1) { //#17436
        $_.t = $f($get($_.cws, _Fy) + $get($_.cws, $_.n)) % 929; //#17431
        for (var _G6 = 0, _G5 = $_.k - 1; _G6 <= _G5; _G6 += 1) { //#17435
            $_.j = _G6; //#17433
            $put($_.cws, $f($_.n + $_.j), ($f($get($_.cws, $f($f($_.n + $_.j) + 1)) + ($f(929 - (($_.t * $get($_.coeffs, ($_.k - $_.j) - 1)) % 929))))) % 929); //#17434
        } //#17434
    } //#17434
    for (var _GN = $_.n, _GM = $f($_.n + $_.k); _GN <= _GM; _GN += 1) { //#17437
        $put($_.cws, _GN, $f(929 - $get($_.cws, _GN)) % 929); //#17437
    } //#17437
    $_.cws = $geti($_.cws, 0, $_.cws.length - 1); //#17440
    var _GV = $get($_.options, 'debugcws') !== undefined; //#17442
    if (_GV) { //#17442
        $k[$j++] = 'bwipp.debugcws#17442'; //#17442
        $k[$j++] = $_.cws; //#17442
        bwipp_raiseerror(); //#17442
    } //#17442
    if (!bwipp_pdf417.__17686__) { //#17686
        $_ = Object.create($_); //#17686
        $_.clusters = $a([$a([120256, 125680, 128380, 120032, 125560, 128318, 108736, 119920, 108640, 86080, 108592, 86048, 110016, 120560, 125820, 109792, 120440, 125758, 88256, 109680, 88160, 89536, 110320, 120700, 89312, 110200, 120638, 89200, 110140, 89840, 110460, 89720, 110398, 89980, 128506, 119520, 125304, 128190, 107712, 119408, 125244, 107616, 119352, 84032, 107568, 119324, 84000, 107544, 83984, 108256, 119672, 125374, 85184, 108144, 119612, 85088, 108088, 119582, 85040, 108060, 85728, 108408, 119742, 85616, 108348, 85560, 108318, 85880, 108478, 85820, 85790, 107200, 119152, 125116, 107104, 119096, 125086, 83008, 107056, 119068, 82976, 107032, 82960, 82952, 83648, 107376, 119228, 83552, 107320, 119198, 83504, 107292, 83480, 83468, 83824, 107452, 83768, 107422, 83740, 83900, 106848, 118968, 125022, 82496, 106800, 118940, 82464, 106776, 118926, 82448, 106764, 82440, 106758, 82784, 106936, 119006, 82736, 106908, 82712, 106894, 82700, 82694, 106974, 82830, 82240, 106672, 118876, 82208, 106648, 118862, 82192, 106636, 82184, 106630, 82180, 82352, 82328, 82316, 82080, 118830, 106572, 106566, 82050, 117472, 124280, 127678, 103616, 117360, 124220, 103520, 117304, 124190, 75840, 103472, 75808, 104160, 117624, 124350, 76992, 104048, 117564, 76896, 103992, 76848, 76824, 77536, 104312, 117694, 77424, 104252, 77368, 77340, 77688, 104382, 77628, 77758, 121536, 126320, 128700, 121440, 126264, 128670, 111680, 121392, 126236, 111648, 121368, 126222, 111632, 121356, 103104, 117104, 124092, 112320, 103008, 117048, 124062, 112224, 121656, 126366, 93248, 74784, 102936, 117006, 93216, 112152, 93200, 75456, 103280, 117180, 93888, 75360, 103224, 117150, 93792, 112440, 121758, 93744, 75288, 93720, 75632, 103356, 94064, 75576, 103326, 94008, 112542, 93980, 75708, 94140, 75678, 94110, 121184, 126136, 128606, 111168, 121136, 126108, 111136, 121112, 126094, 111120, 121100, 111112, 111108, 102752, 116920, 123998, 111456, 102704, 116892, 91712, 74272, 121244, 116878, 91680, 74256, 102668, 91664, 111372, 102662, 74244, 74592, 102840, 116958, 92000, 74544, 102812, 91952, 111516, 102798, 91928, 74508, 74502, 74680, 102878, 92088, 74652, 92060, 74638, 92046, 92126, 110912, 121008, 126044, 110880, 120984, 126030, 110864, 120972, 110856, 120966, 110852, 110850, 74048, 102576, 116828, 90944, 74016, 102552, 116814, 90912, 111000, 121038, 90896, 73992, 102534, 90888, 110982, 90884, 74160, 102620, 91056, 74136, 102606, 91032, 111054, 91020, 74118, 91014, 91100, 91086, 110752, 120920, 125998, 110736, 120908, 110728, 120902, 110724, 110722, 73888, 102488, 116782, 90528, 73872, 102476, 90512, 110796, 102470, 90504, 73860, 90500, 73858, 73944, 90584, 90572, 90566, 120876, 120870, 110658, 102444, 73800, 90312, 90308, 90306, 101056, 116080, 123580, 100960, 116024, 70720, 100912, 115996, 70688, 100888, 70672, 70664, 71360, 101232, 116156, 71264, 101176, 116126, 71216, 101148, 71192, 71180, 71536, 101308, 71480, 101278, 71452, 71612, 71582, 118112, 124600, 127838, 105024, 118064, 124572, 104992, 118040, 124558, 104976, 118028, 104968, 118022, 100704, 115896, 123486, 105312, 100656, 115868, 79424, 70176, 118172, 115854, 79392, 105240, 100620, 79376, 70152, 79368, 70496, 100792, 115934, 79712, 70448, 118238, 79664, 105372, 100750, 79640, 70412, 79628, 70584, 100830, 79800, 70556, 79772, 70542, 70622, 79838, 122176, 126640, 128860, 122144, 126616, 128846, 122128, 126604, 122120, 126598, 122116, 104768, 117936, 124508, 113472, 104736, 126684, 124494, 113440, 122264, 126670, 113424, 104712, 117894, 113416, 122246, 104706, 69952, 100528, 115804, 78656, 69920, 100504, 115790, 96064, 78624, 104856, 117966, 96032, 113560, 122318, 100486, 96016, 78600, 104838, 96008, 69890, 70064, 100572, 78768, 70040, 100558, 96176, 78744, 104910, 96152, 113614, 70022, 78726, 70108, 78812, 70094, 96220, 78798, 122016, 126552, 128814, 122000, 126540, 121992, 126534, 121988, 121986, 104608, 117848, 124462, 113056, 104592, 126574, 113040, 122060, 117830, 113032, 104580, 113028, 104578, 113026, 69792, 100440, 115758, 78240, 69776, 100428, 95136, 78224, 104652, 100422, 95120, 113100, 69764, 95112, 78212, 69762, 78210, 69848, 100462, 78296, 69836, 95192, 78284, 69830, 95180, 78278, 69870, 95214, 121936, 126508, 121928, 126502, 121924, 121922, 104528, 117804, 112848, 104520, 117798, 112840, 121958, 112836, 104514, 112834, 69712, 100396, 78032, 69704, 100390, 94672, 78024, 104550, 94664, 112870, 69698, 94660, 78018, 94658, 78060, 94700, 94694, 126486, 121890, 117782, 104484, 104482, 69672, 77928, 94440, 69666, 77922, 99680, 68160, 99632, 68128, 99608, 115342, 68112, 99596, 68104, 99590, 68448, 99768, 115422, 68400, 99740, 68376, 99726, 68364, 68358, 68536, 99806, 68508, 68494, 68574, 101696, 116400, 123740, 101664, 116376, 101648, 116364, 101640, 116358, 101636, 67904, 99504, 115292, 72512, 67872, 116444, 115278, 72480, 101784, 116430, 72464, 67848, 99462, 72456, 101766, 67842, 68016, 99548, 72624, 67992, 99534, 72600, 101838, 72588, 67974, 68060, 72668, 68046, 72654, 118432, 124760, 127918, 118416, 124748, 118408, 124742, 118404, 118402, 101536, 116312, 105888, 101520, 116300, 105872, 118476, 116294, 105864, 101508, 105860, 101506, 105858, 67744, 99416, 72096, 67728, 116334, 80800, 72080, 101580, 99398, 80784, 105932, 67716, 80776, 72068, 67714, 72066, 67800, 99438, 72152, 67788, 80856, 72140, 67782, 80844, 72134, 67822, 72174, 80878, 126800, 128940, 126792, 128934, 126788, 126786, 118352, 124716, 122576, 126828, 124710, 122568, 126822, 122564, 118338, 122562, 101456, 116268, 105680, 101448, 116262, 114128, 105672, 118374, 114120, 122598, 101442, 114116, 105666, 114114, 67664, 99372, 71888, 67656, 99366, 80336, 71880, 101478, 97232, 80328, 105702, 67650, 97224, 114150, 71874, 97220, 67692, 71916, 67686, 80364, 71910, 97260, 80358, 97254, 126760, 128918, 126756, 126754, 118312, 124694, 122472, 126774, 122468, 118306, 122466, 101416, 116246, 105576, 101412, 113896, 105572, 101410, 113892, 105570, 113890, 67624, 99350, 71784, 101430, 80104, 71780, 67618, 96744, 80100, 71778, 96740, 80098, 96738, 71798, 96758, 126738, 122420, 122418, 105524, 113780, 113778, 71732, 79988, 96500, 96498, 66880, 66848, 98968, 66832, 66824, 66820, 66992, 66968, 66956, 66950, 67036, 67022, 100000, 99984, 115532, 99976, 115526, 99972, 99970, 66720, 98904, 69024, 100056, 98892, 69008, 100044, 69000, 100038, 68996, 66690, 68994, 66776, 98926, 69080, 100078, 69068, 66758, 69062, 66798, 69102, 116560, 116552, 116548, 116546, 99920, 102096, 116588, 115494, 102088, 116582, 102084, 99906, 102082, 66640, 68816, 66632, 98854, 73168, 68808, 66628, 73160, 68804, 66626, 73156, 68802, 66668, 68844, 66662, 73196, 68838, 73190, 124840, 124836, 124834, 116520, 118632, 124854, 118628, 116514, 118626, 99880, 115478, 101992, 116534, 106216, 101988, 99874, 106212, 101986, 106210, 66600, 98838, 68712, 99894, 72936, 68708, 66594, 81384, 72932, 68706, 81380, 72930, 66614, 68726, 72950, 81398, 128980, 128978, 124820, 126900, 124818, 126898, 116500, 118580, 116498, 122740, 118578, 122738, 99860, 101940, 99858, 106100, 101938, 114420]), $a([128352, 129720, 125504, 128304, 129692, 125472, 128280, 129678, 125456, 128268, 125448, 128262, 125444, 125792, 128440, 129758, 120384, 125744, 128412, 120352, 125720, 128398, 120336, 125708, 120328, 125702, 120324, 120672, 125880, 128478, 110144, 120624, 125852, 110112, 120600, 125838, 110096, 120588, 110088, 120582, 110084, 110432, 120760, 125918, 89664, 110384, 120732, 89632, 110360, 120718, 89616, 110348, 89608, 110342, 89952, 110520, 120798, 89904, 110492, 89880, 110478, 89868, 90040, 110558, 90012, 89998, 125248, 128176, 129628, 125216, 128152, 129614, 125200, 128140, 125192, 128134, 125188, 125186, 119616, 125360, 128220, 119584, 125336, 128206, 119568, 125324, 119560, 125318, 119556, 119554, 108352, 119728, 125404, 108320, 119704, 125390, 108304, 119692, 108296, 119686, 108292, 108290, 85824, 108464, 119772, 85792, 108440, 119758, 85776, 108428, 85768, 108422, 85764, 85936, 108508, 85912, 108494, 85900, 85894, 85980, 85966, 125088, 128088, 129582, 125072, 128076, 125064, 128070, 125060, 125058, 119200, 125144, 128110, 119184, 125132, 119176, 125126, 119172, 119170, 107424, 119256, 125166, 107408, 119244, 107400, 119238, 107396, 107394, 83872, 107480, 119278, 83856, 107468, 83848, 107462, 83844, 83842, 83928, 107502, 83916, 83910, 83950, 125008, 128044, 125000, 128038, 124996, 124994, 118992, 125036, 118984, 125030, 118980, 118978, 106960, 119020, 106952, 119014, 106948, 106946, 82896, 106988, 82888, 106982, 82884, 82882, 82924, 82918, 124968, 128022, 124964, 124962, 118888, 124982, 118884, 118882, 106728, 118902, 106724, 106722, 82408, 106742, 82404, 82402, 124948, 124946, 118836, 118834, 106612, 106610, 124224, 127664, 129372, 124192, 127640, 129358, 124176, 127628, 124168, 127622, 124164, 124162, 117568, 124336, 127708, 117536, 124312, 127694, 117520, 124300, 117512, 124294, 117508, 117506, 104256, 117680, 124380, 104224, 117656, 124366, 104208, 117644, 104200, 117638, 104196, 104194, 77632, 104368, 117724, 77600, 104344, 117710, 77584, 104332, 77576, 104326, 77572, 77744, 104412, 77720, 104398, 77708, 77702, 77788, 77774, 128672, 129880, 93168, 128656, 129868, 92664, 128648, 129862, 92412, 128644, 128642, 124064, 127576, 129326, 126368, 124048, 129902, 126352, 128716, 127558, 126344, 124036, 126340, 124034, 126338, 117152, 124120, 127598, 121760, 117136, 124108, 121744, 126412, 124102, 121736, 117124, 121732, 117122, 121730, 103328, 117208, 124142, 112544, 103312, 117196, 112528, 121804, 117190, 112520, 103300, 112516, 103298, 112514, 75680, 103384, 117230, 94112, 75664, 103372, 94096, 112588, 103366, 94088, 75652, 94084, 75650, 75736, 103406, 94168, 75724, 94156, 75718, 94150, 75758, 128592, 129836, 91640, 128584, 129830, 91388, 128580, 91262, 128578, 123984, 127532, 126160, 123976, 127526, 126152, 128614, 126148, 123970, 126146, 116944, 124012, 121296, 116936, 124006, 121288, 126182, 121284, 116930, 121282, 102864, 116972, 111568, 102856, 116966, 111560, 121318, 111556, 102850, 111554, 74704, 102892, 92112, 74696, 102886, 92104, 111590, 92100, 74690, 92098, 74732, 92140, 74726, 92134, 128552, 129814, 90876, 128548, 90750, 128546, 123944, 127510, 126056, 128566, 126052, 123938, 126050, 116840, 123958, 121064, 116836, 121060, 116834, 121058, 102632, 116854, 111080, 121078, 111076, 102626, 111074, 74216, 102646, 91112, 74212, 91108, 74210, 91106, 74230, 91126, 128532, 90494, 128530, 123924, 126004, 123922, 126002, 116788, 120948, 116786, 120946, 102516, 110836, 102514, 110834, 73972, 90612, 73970, 90610, 128522, 123914, 125978, 116762, 120890, 102458, 110714, 123552, 127320, 129198, 123536, 127308, 123528, 127302, 123524, 123522, 116128, 123608, 127342, 116112, 123596, 116104, 123590, 116100, 116098, 101280, 116184, 123630, 101264, 116172, 101256, 116166, 101252, 101250, 71584, 101336, 116206, 71568, 101324, 71560, 101318, 71556, 71554, 71640, 101358, 71628, 71622, 71662, 127824, 129452, 79352, 127816, 129446, 79100, 127812, 78974, 127810, 123472, 127276, 124624, 123464, 127270, 124616, 127846, 124612, 123458, 124610, 115920, 123500, 118224, 115912, 123494, 118216, 124646, 118212, 115906, 118210, 100816, 115948, 105424, 100808, 115942, 105416, 118246, 105412, 100802, 105410, 70608, 100844, 79824, 70600, 100838, 79816, 105446, 79812, 70594, 79810, 70636, 79852, 70630, 79846, 129960, 95728, 113404, 129956, 95480, 113278, 129954, 95356, 95294, 127784, 129430, 78588, 128872, 129974, 95996, 78462, 128868, 127778, 95870, 128866, 123432, 127254, 124520, 123428, 126696, 128886, 123426, 126692, 124514, 126690, 115816, 123446, 117992, 115812, 122344, 117988, 115810, 122340, 117986, 122338, 100584, 115830, 104936, 100580, 113640, 104932, 100578, 113636, 104930, 113634, 70120, 100598, 78824, 70116, 96232, 78820, 70114, 96228, 78818, 96226, 70134, 78838, 129940, 94968, 113022, 129938, 94844, 94782, 127764, 78206, 128820, 127762, 95102, 128818, 123412, 124468, 123410, 126580, 124466, 126578, 115764, 117876, 115762, 122100, 117874, 122098, 100468, 104692, 100466, 113140, 104690, 113138, 69876, 78324, 69874, 95220, 78322, 95218, 129930, 94588, 94526, 127754, 128794, 123402, 124442, 126522, 115738, 117818, 121978, 100410, 104570, 112890, 69754, 78074, 94714, 94398, 123216, 127148, 123208, 127142, 123204, 123202, 115408, 123244, 115400, 123238, 115396, 115394, 99792, 115436, 99784, 115430, 99780, 99778, 68560, 99820, 68552, 99814, 68548, 68546, 68588, 68582, 127400, 129238, 72444, 127396, 72318, 127394, 123176, 127126, 123752, 123172, 123748, 123170, 123746, 115304, 123190, 116456, 115300, 116452, 115298, 116450, 99560, 115318, 101864, 99556, 101860, 99554, 101858, 68072, 99574, 72680, 68068, 72676, 68066, 72674, 68086, 72694, 129492, 80632, 105854, 129490, 80508, 80446, 127380, 72062, 127924, 127378, 80766, 127922, 123156, 123700, 123154, 124788, 123698, 124786, 115252, 116340, 115250, 118516, 116338, 118514, 99444, 101620, 99442, 105972, 101618, 105970, 67828, 72180, 67826, 80884, 72178, 80882, 97008, 114044, 96888, 113982, 96828, 96798, 129482, 80252, 130010, 97148, 80190, 97086, 127370, 127898, 128954, 123146, 123674, 124730, 126842, 115226, 116282, 118394, 122618, 99386, 101498, 105722, 114170, 67706, 71930, 80378, 96632, 113854, 96572, 96542, 80062, 96702, 96444, 96414, 96350, 123048, 123044, 123042, 115048, 123062, 115044, 115042, 99048, 115062, 99044, 99042, 67048, 99062, 67044, 67042, 67062, 127188, 68990, 127186, 123028, 123316, 123026, 123314, 114996, 115572, 114994, 115570, 98932, 100084, 98930, 100082, 66804, 69108, 66802, 69106, 129258, 73084, 73022, 127178, 127450, 123018, 123290, 123834, 114970, 115514, 116602, 98874, 99962, 102138, 66682, 68858, 73210, 81272, 106174, 81212, 81182, 72894, 81342, 97648, 114364, 97592, 114334, 97564, 97550, 81084, 97724, 81054, 97694, 97464, 114270, 97436, 97422, 80990, 97502, 97372, 97358, 97326, 114868, 114866, 98676, 98674, 66292, 66290, 123098, 114842, 115130, 98618, 99194, 66170, 67322, 69310, 73404, 73374, 81592, 106334, 81564, 81550, 73310, 81630, 97968, 114524, 97944, 114510, 97932, 97926, 81500, 98012, 81486, 97998, 97880, 114478, 97868, 97862, 81454, 97902, 97836, 97830, 69470, 73564, 73550, 81752, 106414, 81740, 81734, 73518, 81774, 81708, 81702]), $a([109536, 120312, 86976, 109040, 120060, 86496, 108792, 119934, 86256, 108668, 86136, 129744, 89056, 110072, 129736, 88560, 109820, 129732, 88312, 109694, 129730, 88188, 128464, 129772, 89592, 128456, 129766, 89340, 128452, 89214, 128450, 125904, 128492, 125896, 128486, 125892, 125890, 120784, 125932, 120776, 125926, 120772, 120770, 110544, 120812, 110536, 120806, 110532, 84928, 108016, 119548, 84448, 107768, 119422, 84208, 107644, 84088, 107582, 84028, 129640, 85488, 108284, 129636, 85240, 108158, 129634, 85116, 85054, 128232, 129654, 85756, 128228, 85630, 128226, 125416, 128246, 125412, 125410, 119784, 125430, 119780, 119778, 108520, 119798, 108516, 108514, 83424, 107256, 119166, 83184, 107132, 83064, 107070, 83004, 82974, 129588, 83704, 107390, 129586, 83580, 83518, 128116, 83838, 128114, 125172, 125170, 119284, 119282, 107508, 107506, 82672, 106876, 82552, 106814, 82492, 82462, 129562, 82812, 82750, 128058, 125050, 119034, 82296, 106686, 82236, 82206, 82366, 82108, 82078, 76736, 103920, 117500, 76256, 103672, 117374, 76016, 103548, 75896, 103486, 75836, 129384, 77296, 104188, 129380, 77048, 104062, 129378, 76924, 76862, 127720, 129398, 77564, 127716, 77438, 127714, 124392, 127734, 124388, 124386, 117736, 124406, 117732, 117730, 104424, 117750, 104420, 104418, 112096, 121592, 126334, 92608, 111856, 121468, 92384, 111736, 121406, 92272, 111676, 92216, 111646, 92188, 75232, 103160, 117118, 93664, 74992, 103036, 93424, 112252, 102974, 93304, 74812, 93244, 74782, 93214, 129332, 75512, 103294, 129908, 129330, 93944, 75388, 129906, 93820, 75326, 93758, 127604, 75646, 128756, 127602, 94078, 128754, 124148, 126452, 124146, 126450, 117236, 121844, 117234, 121842, 103412, 103410, 91584, 111344, 121212, 91360, 111224, 121150, 91248, 111164, 91192, 111134, 91164, 91150, 74480, 102780, 91888, 74360, 102718, 91768, 111422, 91708, 74270, 91678, 129306, 74620, 129850, 92028, 74558, 91966, 127546, 128634, 124026, 126202, 116986, 121338, 102906, 90848, 110968, 121022, 90736, 110908, 90680, 110878, 90652, 90638, 74104, 102590, 91000, 74044, 90940, 74014, 90910, 74174, 91070, 90480, 110780, 90424, 110750, 90396, 90382, 73916, 90556, 73886, 90526, 90296, 110686, 90268, 90254, 73822, 90334, 90204, 90190, 71136, 101112, 116094, 70896, 100988, 70776, 100926, 70716, 70686, 129204, 71416, 101246, 129202, 71292, 71230, 127348, 71550, 127346, 123636, 123634, 116212, 116210, 101364, 101362, 79296, 105200, 118140, 79072, 105080, 118078, 78960, 105020, 78904, 104990, 78876, 78862, 70384, 100732, 79600, 70264, 100670, 79480, 105278, 79420, 70174, 79390, 129178, 70524, 129466, 79740, 70462, 79678, 127290, 127866, 123514, 124666, 115962, 118266, 100858, 113376, 122232, 126654, 95424, 113264, 122172, 95328, 113208, 122142, 95280, 113180, 95256, 113166, 95244, 78560, 104824, 117950, 95968, 78448, 104764, 95856, 113468, 104734, 95800, 78364, 95772, 78350, 95758, 70008, 100542, 78712, 69948, 96120, 78652, 69918, 96060, 78622, 96030, 70078, 78782, 96190, 94912, 113008, 122044, 94816, 112952, 122014, 94768, 112924, 94744, 112910, 94732, 94726, 78192, 104636, 95088, 78136, 104606, 95032, 113054, 95004, 78094, 94990, 69820, 78268, 69790, 95164, 78238, 95134, 94560, 112824, 121950, 94512, 112796, 94488, 112782, 94476, 94470, 78008, 104542, 94648, 77980, 94620, 77966, 94606, 69726, 78046, 94686, 94384, 112732, 94360, 112718, 94348, 94342, 77916, 94428, 77902, 94414, 94296, 112686, 94284, 94278, 77870, 94318, 94252, 94246, 68336, 99708, 68216, 99646, 68156, 68126, 68476, 68414, 127162, 123258, 115450, 99834, 72416, 101752, 116414, 72304, 101692, 72248, 101662, 72220, 72206, 67960, 99518, 72568, 67900, 72508, 67870, 72478, 68030, 72638, 80576, 105840, 118460, 80480, 105784, 118430, 80432, 105756, 80408, 105742, 80396, 80390, 72048, 101564, 80752, 71992, 101534, 80696, 71964, 80668, 71950, 80654, 67772, 72124, 67742, 80828, 72094, 80798, 114016, 122552, 126814, 96832, 113968, 122524, 96800, 113944, 122510, 96784, 113932, 96776, 113926, 96772, 80224, 105656, 118366, 97120, 80176, 105628, 97072, 114076, 105614, 97048, 80140, 97036, 80134, 97030, 71864, 101470, 80312, 71836, 97208, 80284, 71822, 97180, 80270, 97166, 67678, 71902, 80350, 97246, 96576, 113840, 122460, 96544, 113816, 122446, 96528, 113804, 96520, 113798, 96516, 96514, 80048, 105564, 96688, 80024, 105550, 96664, 113870, 96652, 80006, 96646, 71772, 80092, 71758, 96732, 80078, 96718, 96416, 113752, 122414, 96400, 113740, 96392, 113734, 96388, 96386, 79960, 105518, 96472, 79948, 96460, 79942, 96454, 71726, 79982, 96494, 96336, 113708, 96328, 113702, 96324, 96322, 79916, 96364, 79910, 96358, 96296, 113686, 96292, 96290, 79894, 96310, 66936, 99006, 66876, 66846, 67006, 68976, 100028, 68920, 99998, 68892, 68878, 66748, 69052, 66718, 69022, 73056, 102072, 116574, 73008, 102044, 72984, 102030, 72972, 72966, 68792, 99934, 73144, 68764, 73116, 68750, 73102, 66654, 68830, 73182, 81216, 106160, 118620, 81184, 106136, 118606, 81168, 106124, 81160, 106118, 81156, 81154, 72880, 101980, 81328, 72856, 101966, 81304, 106190, 81292, 72838, 81286, 68700, 72924, 68686, 81372, 72910, 81358, 114336, 122712, 126894, 114320, 122700, 114312, 122694, 114308, 114306, 81056, 106072, 118574, 97696, 81040, 106060, 97680, 114380, 106054, 97672, 81028, 97668, 81026, 97666, 72792, 101934, 81112, 72780, 97752, 81100, 72774, 97740, 81094, 97734, 68654, 72814, 81134, 97774, 114256, 122668, 114248, 122662, 114244, 114242, 80976, 106028, 97488, 80968, 106022, 97480, 114278, 97476, 80962, 97474, 72748, 81004, 72742, 97516, 80998, 97510, 114216, 122646, 114212, 114210, 80936, 106006, 97384, 80932, 97380, 80930, 97378, 72726, 80950, 97398, 114196, 114194, 80916, 97332, 80914, 97330, 66236, 66206, 67256, 99166, 67228, 67214, 66142, 67294, 69296, 100188, 69272, 100174, 69260, 69254, 67164, 69340, 67150, 69326, 73376, 102232, 116654, 73360, 102220, 73352, 102214, 73348, 73346, 69208, 100142, 73432, 102254, 73420, 69190, 73414, 67118, 69230, 73454, 106320, 118700, 106312, 118694, 106308, 106306, 73296, 102188, 81616, 106348, 102182, 81608, 73284, 81604, 73282, 81602, 69164, 73324, 69158, 81644, 73318, 81638, 122792, 126934, 122788, 122786, 106280, 118678, 114536, 106276, 114532, 106274, 114530, 73256, 102166, 81512, 73252, 98024, 81508, 73250, 98020, 81506, 98018, 69142, 73270, 81526, 98038, 122772, 122770, 106260, 114484, 106258, 114482, 73236, 81460, 73234, 97908, 81458, 97906, 122762, 106250, 114458, 73226, 81434, 97850, 66396, 66382, 67416, 99246, 67404, 67398, 66350, 67438, 69456, 100268, 69448, 100262, 69444, 69442, 67372, 69484, 67366, 69478, 102312, 116694, 102308, 102306, 69416, 100246, 73576, 102326, 73572, 69410, 73570, 67350, 69430, 73590, 118740, 118738, 102292, 106420, 102290, 106418, 69396, 73524, 69394, 81780, 73522, 81778, 118730, 102282, 106394, 69386, 73498, 81722, 66476, 66470, 67496, 99286, 67492, 67490, 66454, 67510, 100308, 100306, 67476, 69556, 67474, 69554, 116714])]); //#17685
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_pdf417.$ctx[id] = $_[id]); //#17685
        bwipp_pdf417.__17686__ = 1; //#17685
        $_ = Object.getPrototypeOf($_); //#17685
    } //#17685
    $_.cwtobits = function() {
        var _Ge = $get($_.clusters, $k[--$j]); //#17690
        $_.v = $get(_Ge, $k[--$j]); //#17690
        $k[$j++] = Infinity; //#17691
        for (var _Gh = 0, _Gi = 17; _Gh < _Gi; _Gh++) { //#17691
            $k[$j++] = 0; //#17691
        } //#17691
        var _Gl = $cvrs($s(17), $_.v, 2); //#17691
        for (var _Gm = 0, _Gn = _Gl.length; _Gm < _Gn; _Gm++) { //#17691
            $k[$j++] = $get(_Gl, _Gm) - 48; //#17691
        } //#17691
        var _Gp = $a(); //#17691
        $k[$j++] = $geti(_Gp, _Gp.length - 17, 17); //#17692
    }; //#17692
    if ($_.compact) { //#17699
        $_.rwid = $f(($f(($f((17 * $_.c) + 17)) + 17)) + 1); //#17697
    } else { //#17699
        $_.rwid = $f(($f(($f(($f((17 * $_.c) + 17)) + 17)) + 17)) + 18); //#17699
    } //#17699
    $_.pixs = $a(($_.rwid * $_.r) * $_.rowmult); //#17701
    for (var _H0 = 0, _Gz = $_.r - 1; _H0 <= _Gz; _H0 += 1) { //#17734
        $_.i = _H0; //#17704
        if (($_.i % 3) == 0) { //#17709
            $_.lcw = ((~~($_.i / 3)) * 30) + (~~(($_.r - 1) / 3)); //#17707
            $_.rcw = $f(($f(((~~($_.i / 3)) * 30) + $_.c)) - 1); //#17708
        } //#17708
        if (($_.i % 3) == 1) { //#17713
            $_.lcw = (((~~($_.i / 3)) * 30) + ($_.eclevel * 3)) + (($_.r - 1) % 3); //#17711
            $_.rcw = ((~~($_.i / 3)) * 30) + (~~(($_.r - 1) / 3)); //#17712
        } //#17712
        if (($_.i % 3) == 2) { //#17717
            $_.lcw = $f(($f(((~~($_.i / 3)) * 30) + $_.c)) - 1); //#17715
            $_.rcw = (((~~($_.i / 3)) * 30) + ($_.eclevel * 3)) + (($_.r - 1) % 3); //#17716
        } //#17716
        $k[$j++] = Infinity; //#17719
        $k[$j++] = 1; //#17721
        $k[$j++] = 1; //#17721
        $k[$j++] = 1; //#17721
        $k[$j++] = 1; //#17721
        $k[$j++] = 1; //#17721
        $k[$j++] = 1; //#17721
        $k[$j++] = 1; //#17721
        $k[$j++] = 1; //#17721
        $k[$j++] = 0; //#17721
        $k[$j++] = 1; //#17721
        $k[$j++] = 0; //#17721
        $k[$j++] = 1; //#17721
        $k[$j++] = 0; //#17721
        $k[$j++] = 1; //#17721
        $k[$j++] = 0; //#17721
        $k[$j++] = 0; //#17721
        $k[$j++] = 0; //#17721
        $k[$j++] = $_.lcw; //#17721
        $k[$j++] = $_.i % 3; //#17721
        $_.cwtobits(); //#17721
        $aload($k[--$j]); //#17721
        var _HP = $geti($_.cws, $_.c * $_.i, $_.c); //#17722
        for (var _HQ = 0, _HR = _HP.length; _HQ < _HR; _HQ++) { //#17722
            $k[$j++] = $get(_HP, _HQ); //#17722
            $k[$j++] = $_.i % 3; //#17722
            $_.cwtobits(); //#17722
            $aload($k[--$j]); //#17722
        } //#17722
        if ($_.compact) { //#17727
            $k[$j++] = 1; //#17724
        } else { //#17727
            $k[$j++] = $_.rcw; //#17726
            $k[$j++] = $_.i % 3; //#17726
            $_.cwtobits(); //#17726
            $aload($k[--$j]); //#17726
            $k[$j++] = 1; //#17727
            $k[$j++] = 1; //#17727
            $k[$j++] = 1; //#17727
            $k[$j++] = 1; //#17727
            $k[$j++] = 1; //#17727
            $k[$j++] = 1; //#17727
            $k[$j++] = 1; //#17727
            $k[$j++] = 0; //#17727
            $k[$j++] = 1; //#17727
            $k[$j++] = 0; //#17727
            $k[$j++] = 0; //#17727
            $k[$j++] = 0; //#17727
            $k[$j++] = 1; //#17727
            $k[$j++] = 0; //#17727
            $k[$j++] = 1; //#17727
            $k[$j++] = 0; //#17727
            $k[$j++] = 0; //#17727
            $k[$j++] = 1; //#17727
        } //#17727
        var _HZ = $a(); //#17727
        $k[$j++] = _HZ; //#17732
        for (var _Hc = 0, _Hb = $_.rowmult - 1; _Hc <= _Hb; _Hc += 1) { //#17732
            var _Hh = $k[--$j]; //#17731
            $puti($_.pixs, (_Hc + ($_.i * $_.rowmult)) * $_.rwid, _Hh); //#17731
            $k[$j++] = _Hh; //#17731
        } //#17731
        $j--; //#17733
    } //#17733
    var _Hq = new Map([
        ["ren", 'renmatrix'],
        ["pixs", $_.pixs],
        ["pixx", $_.rwid],
        ["pixy", $_.r * $_.rowmult],
        ["height", ($_.r * $_.rowmult) / 72],
        ["width", $_.rwid / 72],
        ["borderleft", 2],
        ["borderright", 2],
        ["bordertop", 2],
        ["borderbottom", 2],
        ["opt", $_.options]
    ]); //#17748
    $k[$j++] = _Hq; //#17751
    if (!$_.dontdraw) { //#17751
        bwipp_renmatrix(); //#17751
    } //#17751
    $_ = Object.getPrototypeOf($_); //#17753
    $_ = Object.getPrototypeOf($_); //#17755
} //bwipp_pdf417
function bwipp_pdf417compact() {
    $_ = Object.create($_); //#17784
    $_.dontdraw = false; //#17787
    $k[$j++] = $_; //#17789
    bwipp_processoptions(); //#17789
    $_.options = $k[--$j]; //#17789
    $_.barcode = $k[--$j]; //#17790
    $put($_.options, "dontdraw", true); //#17793
    $put($_.options, "compact", true); //#17794
    $k[$j++] = 'args'; //#17796
    $k[$j++] = $_.barcode; //#17796
    $k[$j++] = $_.options; //#17796
    bwipp_pdf417(); //#17796
    var _6 = $k[--$j]; //#17796
    $_[$k[--$j]] = _6; //#17796
    $put($_.args, "opt", $_.options); //#17798
    $k[$j++] = $_.args; //#17801
    if (!$_.dontdraw) { //#17801
        bwipp_renmatrix(); //#17801
    } //#17801
    $_ = Object.getPrototypeOf($_); //#17803
} //bwipp_pdf417compact
function bwipp_micropdf417() {
    $_ = Object.create($_); //#17834
    $_.dontdraw = false; //#17837
    $_.version = "unset"; //#17838
    $_.columns = 0; //#17839
    $_.rows = 0; //#17840
    $_.rowmult = 2; //#17841
    $_.cca = false; //#17842
    $_.ccb = false; //#17843
    $_.raw = false; //#17844
    $_.parse = false; //#17845
    $_.parsefnc = false; //#17846
    $k[$j++] = $_; //#17848
    bwipp_processoptions(); //#17848
    $_.options = $k[--$j]; //#17848
    $_.barcode = $k[--$j]; //#17849
    if ($eq($_.barcode, "")) { //#17853
        $k[$j++] = 'bwipp.micropdf417emptyData#17852'; //#17852
        $k[$j++] = "The data must not be empty"; //#17852
        bwipp_raiseerror(); //#17852
    } //#17852
    if ($_.rowmult <= 0) { //#17857
        $k[$j++] = 'bwipp.micropdf417badRowMult#17856'; //#17856
        $k[$j++] = "The row multiplier must be greater than zero"; //#17856
        bwipp_raiseerror(); //#17856
    } //#17856
    if (($_.cca && $_.ccb) || (($_.cca && $_.raw) || ($_.ccb && $_.raw))) { //#17861
        $k[$j++] = 'bwipp.micropdf417ccaAndCcb#17860'; //#17860
        $k[$j++] = "Cannot combine cca, ccb and raw"; //#17860
        bwipp_raiseerror(); //#17860
    } //#17860
    if ($ne($_.version, "unset")) { //#17882
        $search($_.version, "x"); //#17865
        if ($k[--$j]) { //#17880
            var _D = $k[--$j]; //#17866
            var _E = $k[--$j]; //#17866
            $k[$j++] = _D; //#17866
            $k[$j++] = _E; //#17866
            $j--; //#17866
            var _F = $k[--$j]; //#17867
            var _G = $k[--$j]; //#17867
            $k[$j++] = _G; //#17867
            $k[$j++] = _F; //#17867
            $k[$j++] = _G; //#17867
            $k[$j++] = _F; //#17867
            $astore($a(2)); //#17867
            $forall($k[--$j], function() { //#17876
                var _J = $k[--$j]; //#17869
                $k[$j++] = _J; //#17869
                $k[$j++] = true; //#17869
                if (_J.length == 0) { //#17869
                    $j--; //#17869
                    $k[$j++] = false; //#17869
                } //#17869
                var _K = $k[--$j]; //#17870
                var _L = $k[--$j]; //#17870
                $k[$j++] = _K; //#17872
                $forall(_L, function() { //#17872
                    var _M = $k[--$j]; //#17871
                    if ((_M < 48) || (_M > 57)) { //#17871
                        $j--; //#17871
                        $k[$j++] = false; //#17871
                    } //#17871
                }); //#17871
                if ($nt($k[--$j])) { //#17875
                    $k[$j++] = 'bwipp.micropdf417BadVersionBadRowOrColumn#17874'; //#17874
                    $k[$j++] = "version must be formatted as RxC"; //#17874
                    bwipp_raiseerror(); //#17874
                } //#17874
            }); //#17874
            $_.rows = $cvi($k[--$j]); //#17877
            $_.columns = $cvi($k[--$j]); //#17878
        } else { //#17880
            $j--; //#17880
            $k[$j++] = 'bwipp.micropdf417badVersionFormat#17880'; //#17880
            $k[$j++] = "version must be formatted as RxC"; //#17880
            bwipp_raiseerror(); //#17880
        } //#17880
    } //#17880
    bwipp_loadctx(bwipp_micropdf417) //#17884
    if (!bwipp_micropdf417.__17974__) { //#17974
        $_ = Object.create($_); //#17974
        $_.T = 0; //#17888
        $_.N = 1; //#17888
        $_.B = 2; //#17888
        $_.A = 0; //#17889
        $_.L = 1; //#17889
        $_.M = 2; //#17889
        $_.P = 3; //#17889
        $_.tl = -1; //#17892
        $_.nl = -2; //#17892
        $_.bl = -3; //#17892
        $_.bl6 = -4; //#17892
        $_.bs = -5; //#17892
        $_.al = -6; //#17895
        $_.ll = -7; //#17895
        $_.ml = -8; //#17895
        $_.pl = -9; //#17895
        $_.as = -10; //#17895
        $_.ps = -11; //#17895
        $_.m05 = -12; //#17898
        $_.m06 = -13; //#17898
        $_.charmaps = $a([$a(["A", "a", "0", ";"]), $a(["B", "b", "1", "<"]), $a(["C", "c", "2", ">"]), $a(["D", "d", "3", "@"]), $a(["E", "e", "4", "["]), $a(["F", "f", "5", 92]), $a(["G", "g", "6", "]"]), $a(["H", "h", "7", "_"]), $a(["I", "i", "8", "`"]), $a(["J", "j", "9", "~"]), $a(["K", "k", "&", "!"]), $a(["L", "l", 13, 13]), $a(["M", "m", 9, 9]), $a(["N", "n", ",", ","]), $a(["O", "o", ":", ":"]), $a(["P", "p", "#", 10]), $a(["Q", "q", "-", "-"]), $a(["R", "r", ".", "."]), $a(["S", "s", "$", "$"]), $a(["T", "t", "/", "/"]), $a(["U", "u", "+", "\""]), $a(["V", "v", "%", "|"]), $a(["W", "w", "*", "*"]), $a(["X", "x", "=", 40]), $a(["Y", "y", "^", 41]), $a(["Z", "z", $_.pl, "?"]), $a([" ", " ", " ", "{"]), $a([$_.ll, $_.as, $_.ll, "}"]), $a([$_.ml, $_.ml, $_.al, "'"]), $a([$_.ps, $_.ps, $_.ps, $_.al])]); //#17933
        $_.charvals = $a([new Map, new Map, new Map, new Map]); //#17936
        $_.alltext = new Map; //#17937
        for (var _19 = 0, _18 = $_.charmaps.length - 1; _19 <= _18; _19 += 1) { //#17947
            $_.i = _19; //#17939
            $_.encs = $get($_.charmaps, $_.i); //#17940
            for (var _1D = 0; _1D <= 3; _1D += 1) { //#17946
                $_.j = _1D; //#17942
                var _1G = $get($_.encs, $_.j); //#17943
                $k[$j++] = _1G; //#17943
                if ($eq($type(_1G), 'stringtype')) { //#17943
                    var _1J = $get($k[--$j], 0); //#17943
                    $k[$j++] = _1J; //#17943
                } //#17943
                var _1K = $k[--$j]; //#17944
                $put($get($_.charvals, $_.j), _1K, $_.i); //#17944
                $put($_.alltext, _1K, -1); //#17945
            } //#17945
        } //#17945
        $_.e = 10000; //#17949
        $_.latlen = $a([$a([0, 1, 1, 2]), $a([2, 0, 1, 2]), $a([1, 1, 0, 1]), $a([1, 2, 2, 0])]); //#17957
        $_.latseq = $a([$a([$a([]), $a([$_.ll]), $a([$_.ml]), $a([$_.ml, $_.pl])]), $a([$a([$_.ml, $_.al]), $a([]), $a([$_.ml]), $a([$_.ml, $_.pl])]), $a([$a([$_.al]), $a([$_.ll]), $a([]), $a([$_.pl])]), $a([$a([$_.al]), $a([$_.al, $_.ll]), $a([$_.al, $_.ml]), $a([])])]); //#17965
        $_.shftlen = $a([$a([$_.e, $_.e, $_.e, 1]), $a([1, $_.e, $_.e, 1]), $a([$_.e, $_.e, $_.e, 1]), $a([$_.e, $_.e, $_.e, $_.e])]); //#17973
        for (var id in $_) $_.hasOwnProperty(id) && (bwipp_micropdf417.$ctx[id] = $_[id]); //#17973
        bwipp_micropdf417.__17974__ = 1; //#17973
        $_ = Object.getPrototypeOf($_); //#17973
    } //#17973
    if ($_.raw || $_.cca) { //#17995
        $_.datcws = $a($_.barcode.length); //#17978
        $_.i = 0; //#17979
        $_.j = 0; //#17979
        for (;;) { //#17990
            if ($_.i >= ($_.barcode.length - 3)) { //#17981
                break; //#17981
            } //#17981
            if ($get($_.barcode, $_.i) != 94) { //#17982
                break; //#17982
            } //#17982
            var _2a = $geti($_.barcode, $_.i + 1, 3); //#17983
            $k[$j++] = _2a; //#17985
            $k[$j++] = false; //#17985
            for (var _2b = 0, _2c = _2a.length; _2b < _2c; _2b++) { //#17985
                var _2d = $get(_2a, _2b); //#17985
                if ((_2d < 48) || (_2d > 57)) { //#17984
                    $j--; //#17984
                    $k[$j++] = true; //#17984
                } //#17984
            } //#17984
            if ($k[--$j]) { //#17985
                $j--; //#17985
                break; //#17985
            } //#17985
            $_.cw = $cvi($k[--$j]); //#17986
            $put($_.datcws, $_.j, $_.cw); //#17987
            $_.i = $_.i + 4; //#17988
            $_.j = $_.j + 1; //#17989
        } //#17989
        if ($_.i != $_.barcode.length) { //#17993
            $k[$j++] = 'bwipp.micropdf417badCcaRawFormat#17992'; //#17992
            $k[$j++] = "cca and raw data must be formatted as ^NNN"; //#17992
            bwipp_raiseerror(); //#17992
        } //#17992
        $_.datcws = $geti($_.datcws, 0, $_.j); //#17994
    } //#17994
    $_.encb = function() {
        $_.in = $k[--$j]; //#17998
        $_.inlen = $_.in.length; //#17999
        $_.out = $a(((~~($_.inlen / 6)) * 5) + ($_.inlen % 6)); //#18000
        for (var _2x = 0, _2w = (~~($_.inlen / 6)) - 1; _2x <= _2w; _2x += 1) { //#18023
            $_.k = _2x; //#18002
            $k[$j++] = Infinity; //#18003
            $aload($geti($_.in, $_.k * 6, 3)); //#18003
            $_.msbs = $a(); //#18003
            $k[$j++] = Infinity; //#18004
            $aload($_.msbs); //#18005
            var _33 = $k[--$j]; //#18005
            var _34 = $k[--$j]; //#18005
            var _35 = $k[--$j]; //#18005
            $k[$j++] = $f(($f(_33 + (_34 * 256))) + (_35 * 65536)); //#18006
            for (var _36 = 0, _37 = 3; _36 < _37; _36++) { //#18006
                var _38 = $k[--$j]; //#18006
                $k[$j++] = _38 % 900; //#18006
                $k[$j++] = ~~(_38 / 900); //#18006
            } //#18006
            $_.mscs = $a(); //#18006
            $k[$j++] = Infinity; //#18008
            $aload($geti($_.in, ($_.k * 6) + 3, 3)); //#18008
            $_.lsbs = $a(); //#18008
            $k[$j++] = Infinity; //#18009
            $aload($_.lsbs); //#18010
            var _3F = $k[--$j]; //#18010
            var _3G = $k[--$j]; //#18010
            var _3H = $k[--$j]; //#18010
            $k[$j++] = $f(($f(_3F + (_3G * 256))) + (_3H * 65536)); //#18011
            for (var _3I = 0, _3J = 3; _3I < _3J; _3I++) { //#18011
                var _3K = $k[--$j]; //#18011
                $k[$j++] = _3K % 900; //#18011
                $k[$j++] = ~~(_3K / 900); //#18011
            } //#18011
            $_.lscs = $a(); //#18011
            var _3N = $get($_.lscs, 0); //#18013
            var _3P = $get($_.mscs, 0); //#18013
            $put($_.out, ($_.k * 5) + 4, ($f(_3N + (_3P * 316))) % 900); //#18014
            var _3T = $get($_.lscs, 1); //#18015
            var _3V = $get($_.mscs, 0); //#18015
            var _3X = $get($_.mscs, 1); //#18015
            $put($_.out, ($_.k * 5) + 3, ($f(($f(($f((~~(($f(_3N + (_3P * 316))) / 900)) + _3T)) + (_3V * 641))) + (_3X * 316))) % 900); //#18016
            var _3b = $get($_.lscs, 2); //#18017
            var _3d = $get($_.mscs, 0); //#18017
            var _3f = $get($_.mscs, 1); //#18017
            var _3h = $get($_.mscs, 2); //#18017
            $put($_.out, ($_.k * 5) + 2, ($f(($f(($f(($f((~~(($f(($f(($f((~~(($f(_3N + (_3P * 316))) / 900)) + _3T)) + (_3V * 641))) + (_3X * 316))) / 900)) + _3b)) + (_3d * 20))) + (_3f * 641))) + (_3h * 316))) % 900); //#18018
            var _3l = $get($_.lscs, 3); //#18019
            var _3n = $get($_.mscs, 1); //#18019
            var _3p = $get($_.mscs, 2); //#18019
            $put($_.out, ($_.k * 5) + 1, ($f(($f(($f((~~(($f(($f(($f(($f((~~(($f(($f(($f((~~(($f(_3N + (_3P * 316))) / 900)) + _3T)) + (_3V * 641))) + (_3X * 316))) / 900)) + _3b)) + (_3d * 20))) + (_3f * 641))) + (_3h * 316))) / 900)) + _3l)) + (_3n * 20))) + (_3p * 641))) % 900); //#18020
            $put($_.out, $_.k * 5, ($f((~~(($f(($f(($f((~~(($f(($f(($f(($f((~~(($f(($f(($f((~~(($f(_3N + (_3P * 316))) / 900)) + _3T)) + (_3V * 641))) + (_3X * 316))) / 900)) + _3b)) + (_3d * 20))) + (_3f * 641))) + (_3h * 316))) / 900)) + _3l)) + (_3n * 20))) + (_3p * 641))) / 900)) + ($get($_.mscs, 2) * 20))) % 900); //#18022
        } //#18022
        $_.rem = $_.inlen % 6; //#18024
        if ($_.rem != 0) { //#18029
            $k[$j++] = $_.out; //#18027
            $k[$j++] = $_.out.length - $_.rem; //#18027
            $k[$j++] = Infinity; //#18027
            $aload($geti($_.in, $_.inlen - $_.rem, $_.rem)); //#18027
            var _46 = $a(); //#18027
            var _47 = $k[--$j]; //#18028
            $puti($k[--$j], _47, _46); //#18028
        } //#18028
        $k[$j++] = $_.out; //#18030
    }; //#18030
    if ($_.ccb) { //#18039
        $_.barlen = $_.barcode.length; //#18034
        $_.datcws = $a((((~~($_.barlen / 6)) * 5) + ($_.barlen % 6)) + 2); //#18035
        $put($_.datcws, 0, 920); //#18036
        var _4I = (($_.barlen % 6) == 0) ? 924 : 901; //#18037
        $put($_.datcws, 1, _4I); //#18037
        $k[$j++] = $_.datcws; //#18038
        $k[$j++] = 2; //#18038
        $k[$j++] = Infinity; //#18038
        $forall($_.barcode); //#18038
        var _4L = $a(); //#18038
        $k[$j++] = _4L; //#18038
        $_.encb(); //#18038
        var _4M = $k[--$j]; //#18038
        var _4N = $k[--$j]; //#18038
        $puti($k[--$j], _4N, _4M); //#18038
    } //#18038
    if (((!$_.raw) && (!$_.cca)) && (!$_.ccb)) { //#18440
        var _4U = new Map([
            ["parse", $_.parse],
            ["parsefnc", $_.parsefnc],
            ["eci", true]
        ]); //#18050
        $_.fncvals = _4U; //#18051
        $k[$j++] = 'msg'; //#18052
        $k[$j++] = $_.barcode; //#18052
        $k[$j++] = $_.fncvals; //#18052
        bwipp_parseinput(); //#18052
        var _4X = $k[--$j]; //#18052
        $_[$k[--$j]] = _4X; //#18052
        $_.msglen = $_.msg.length; //#18053
        if ($_.msglen >= 9) { //#18071
            $aload($geti($_.msg, 0, 7)); //#18057
            var _4d = $k[--$j]; //#18058
            var _4e = $k[--$j]; //#18058
            $k[$j++] = _4d == 29; //#18058
            $k[$j++] = _4e; //#18058
            $j--; //#18058
            var _4f = $k[--$j]; //#18058
            var _4g = $k[--$j]; //#18058
            var _4h = $k[--$j]; //#18058
            var _4i = $k[--$j]; //#18059
            var _4j = $k[--$j]; //#18059
            var _4k = $k[--$j]; //#18059
            if (((((_4f && (_4g == 48)) && (_4h == 30)) && (_4i == 62)) && (_4j == 41)) && (_4k == 91)) { //#18070
                $aload($geti($_.msg, $_.msglen - 2, 2)); //#18060
                var _4o = $k[--$j]; //#18061
                var _4p = $k[--$j]; //#18061
                if ((_4o == 4) && (_4p == 30)) { //#18069
                    if ($get($_.msg, 5) == 53) { //#18066
                        $k[$j++] = Infinity; //#18063
                        $k[$j++] = $_.m05; //#18063
                        $aload($geti($_.msg, 7, $_.msg.length - 9)); //#18063
                        $_.msg = $a(); //#18063
                    } else { //#18066
                        if ($get($_.msg, 5) == 54) { //#18067
                            $k[$j++] = Infinity; //#18066
                            $k[$j++] = $_.m06; //#18066
                            $aload($geti($_.msg, 7, $_.msg.length - 9)); //#18066
                            $_.msg = $a(); //#18066
                        } //#18066
                    } //#18066
                } //#18066
            } //#18066
        } //#18066
        $_.msglen = $_.msg.length; //#18072
        $k[$j++] = Infinity; //#18075
        for (var _56 = 0, _57 = $_.msglen; _56 < _57; _56++) { //#18075
            $k[$j++] = 0; //#18075
        } //#18075
        $k[$j++] = 0; //#18075
        $_.numdigits = $a(); //#18075
        $k[$j++] = Infinity; //#18076
        for (var _5A = 0, _5B = $_.msglen; _5A < _5B; _5A++) { //#18076
            $k[$j++] = 0; //#18076
        } //#18076
        $k[$j++] = 0; //#18076
        $_.numtext = $a(); //#18076
        $k[$j++] = Infinity; //#18077
        for (var _5E = 0, _5F = $_.msglen; _5E < _5F; _5E++) { //#18077
            $k[$j++] = 0; //#18077
        } //#18077
        $k[$j++] = 0; //#18077
        $_.numbytes = $a(); //#18077
        $k[$j++] = Infinity; //#18078
        for (var _5I = 0, _5J = $_.msglen; _5I < _5J; _5I++) { //#18078
            $k[$j++] = 0; //#18078
        } //#18078
        $_.iseci = $a(); //#18078
        for (var _5M = $_.msglen - 1; _5M >= 0; _5M -= 1) { //#18091
            $_.i = _5M; //#18080
            var _5P = $get($_.msg, $_.i); //#18081
            if ((_5P >= 48) && (_5P <= 57)) { //#18083
                $put($_.numdigits, $_.i, $f($get($_.numdigits, $_.i + 1) + 1)); //#18082
            } //#18082
            var _5Z = $get($_.alltext, $get($_.msg, $_.i)) !== undefined; //#18084
            if (_5Z && ($get($_.numdigits, $_.i) < 13)) { //#18086
                $put($_.numtext, $_.i, $f($get($_.numtext, $_.i + 1) + 1)); //#18085
            } //#18085
            if ((($get($_.msg, $_.i) >= 0) && ($get($_.numtext, $_.i) < 5)) && ($get($_.numdigits, $_.i) < 13)) { //#18089
                $put($_.numbytes, $_.i, $f($get($_.numbytes, $_.i + 1) + 1)); //#18088
            } //#18088
            $put($_.iseci, $_.i, $get($_.msg, $_.i) <= -1000000); //#18090
        } //#18090
        $_.numdigits = $geti($_.numdigits, 0, $_.msglen); //#18092
        $_.numtext = $geti($_.numtext, 0, $_.msglen); //#18093
        $_.numbytes = $geti($_.numbytes, 0, $_.msglen); //#18094
        $_.seq = $a([]); //#18096
        $_.seqlen = 0; //#18096
        $_.state = $_.B; //#18096
        $_.p = 0; //#18096
        for (;;) { //#18158
            if ($_.p == $_.msglen) { //#18097
                break; //#18097
            } //#18097
            var _6H = $get($_.msg, $_.p); //#18098
            if (($_.p == 0) && ((_6H == $_.m05) || (_6H == $_.m06))) { //#18156
                $k[$j++] = Infinity; //#18099
                $aload($_.seq); //#18100
                var _6P = ($get($_.msg, $_.p) == $_.m05) ? $_.m05 : $_.m06; //#18101
                $k[$j++] = _6P; //#18101
                $_.seq = $a(); //#18101
                $_.p = $_.p + 1; //#18103
                $_.seqlen = $_.seqlen + 1; //#18104
            } else { //#18156
                if ($get($_.iseci, $_.p)) { //#18156
                    $_.eci = $get($_.msg, $_.p); //#18107
                    $k[$j++] = Infinity; //#18108
                    $aload($_.seq); //#18109
                    $k[$j++] = $a([$_.eci]); //#18110
                    $_.seq = $a(); //#18110
                    $_.p = $_.p + 1; //#18112
                    $k[$j++] = 'seqlen'; //#18113
                    $k[$j++] = $_.seqlen; //#18113
                    if ($_.eci <= -1810900) { //#18113
                        $k[$j++] = 2; //#18113
                    } else { //#18113
                        var _6h = ($_.eci <= -1000900) ? 3 : 2; //#18113
                        $k[$j++] = _6h; //#18113
                    } //#18113
                    var _6i = $k[--$j]; //#18113
                    var _6j = $k[--$j]; //#18113
                    $_[$k[--$j]] = $f(_6j + _6i); //#18113
                } else { //#18156
                    $_.n = $get($_.numdigits, $_.p); //#18115
                    if (($_.n >= 13) || (($_.n == $_.msglen) && ($_.n >= 8))) { //#18156
                        $k[$j++] = Infinity; //#18117
                        $aload($_.seq); //#18118
                        $k[$j++] = $_.nl; //#18120
                        $k[$j++] = Infinity; //#18120
                        $aload($geti($_.msg, $_.p, $_.n)); //#18120
                        var _6y = $a(); //#18120
                        $k[$j++] = _6y; //#18120
                        $_.seq = $a(); //#18120
                        $_.state = $_.N; //#18122
                        $_.p = $f($_.p + $_.n); //#18123
                        $_.seqlen = $f(($_.seqlen + 1) + $_.n); //#18124
                    } else { //#18156
                        $_.t = $get($_.numtext, $_.p); //#18126
                        if ($_.t >= 5) { //#18156
                            $k[$j++] = Infinity; //#18128
                            $aload($_.seq); //#18129
                            if ($_.state != $_.T) { //#18132
                                $k[$j++] = $_.tl; //#18131
                            } //#18131
                            $k[$j++] = Infinity; //#18133
                            $aload($geti($_.msg, $_.p, $_.t)); //#18133
                            var _7H = $a(); //#18133
                            $k[$j++] = _7H; //#18133
                            $_.seq = $a(); //#18133
                            $_.state = $_.T; //#18135
                            $_.p = $f($_.p + $_.t); //#18136
                            $_.seqlen = $f($f($_.seqlen + 1) + $_.t); //#18137
                        } else { //#18156
                            $_.b = $get($_.numbytes, $_.p); //#18139
                            if (($_.b == 1) && ($_.state == $_.T)) { //#18156
                                $k[$j++] = Infinity; //#18141
                                $aload($_.seq); //#18142
                                $k[$j++] = $_.bs; //#18144
                                $k[$j++] = $a([$get($_.msg, $_.p)]); //#18144
                                $_.seq = $a(); //#18144
                                $_.p = $f($_.p + $_.b); //#18146
                                $_.seqlen = $f($_.seqlen + 2); //#18147
                            } else { //#18156
                                $k[$j++] = Infinity; //#18149
                                $aload($_.seq); //#18150
                                var _7g = (($_.b % 6) != 0) ? $_.bl : $_.bl6; //#18151
                                $k[$j++] = _7g; //#18152
                                $k[$j++] = Infinity; //#18152
                                $aload($geti($_.msg, $_.p, $_.b)); //#18152
                                var _7l = $a(); //#18152
                                $k[$j++] = _7l; //#18152
                                $_.seq = $a(); //#18152
                                $_.state = $_.B; //#18154
                                $_.p = $f($_.p + $_.b); //#18155
                                $_.seqlen = $f($f($_.seqlen + 1) + $_.b); //#18156
                            } //#18156
                        } //#18156
                    } //#18156
                } //#18156
            } //#18156
        } //#18156
        $k[$j++] = Infinity; //#18160
        $k[$j++] = $_.tl; //#18161
        $k[$j++] = 900; //#18161
        $k[$j++] = $_.bl; //#18161
        $k[$j++] = 901; //#18161
        $k[$j++] = $_.bl6; //#18161
        $k[$j++] = 924; //#18161
        $k[$j++] = $_.nl; //#18161
        $k[$j++] = 902; //#18161
        $k[$j++] = $_.bs; //#18161
        $k[$j++] = 913; //#18161
        $k[$j++] = $_.m05; //#18161
        $k[$j++] = 916; //#18161
        $k[$j++] = $_.m06; //#18161
        $k[$j++] = 917; //#18161
        $_.latchcws = $d(); //#18162
        $_.enca = function() {
            var _84 = $get($get($_.charvals, $_.A), $k[--$j]); //#18165
            $k[$j++] = _84; //#18165
        }; //#18165
        $_.encl = function() {
            var _89 = $get($get($_.charvals, $_.L), $k[--$j]); //#18166
            $k[$j++] = _89; //#18166
        }; //#18166
        $_.encm = function() {
            var _8E = $get($get($_.charvals, $_.M), $k[--$j]); //#18167
            $k[$j++] = _8E; //#18167
        }; //#18167
        $_.encp = function() {
            var _8J = $get($get($_.charvals, $_.P), $k[--$j]); //#18168
            $k[$j++] = _8J; //#18168
        }; //#18168
        $_.textencfuncs = $a(['enca', 'encl', 'encm', 'encp']); //#18169
        $_.addtotext = function() {
            $put($_.text, $_.l, $k[--$j]); //#18172
            $_.l = $_.l + 1; //#18173
        }; //#18173
        $_.enct = function() {
            $_.in = $k[--$j]; //#18178
            $_.curlen = $a([$_.e, $_.e, $_.e, $_.e]); //#18180
            $put($_.curlen, $_.submode, 0); //#18181
            $_.curseq = $a([$a([]), $a([]), $a([]), $a([])]); //#18182
            $forall($_.in, function() { //#18252
                $_.char = $k[--$j]; //#18187
                for (;;) { //#18208
                    $_.imp = false; //#18191
                    var _8i = $a([$_.A, $_.L, $_.M, $_.P]); //#18192
                    for (var _8j = 0, _8k = _8i.length; _8j < _8k; _8j++) { //#18206
                        $_.x = $get(_8i, _8j); //#18193
                        var _8q = $a([$_.A, $_.L, $_.M, $_.P]); //#18194
                        for (var _8r = 0, _8s = _8q.length; _8r < _8s; _8r++) { //#18205
                            $_.y = $get(_8q, _8r); //#18195
                            $_.cost = $f($get($_.curlen, $_.x) + $get($get($_.latlen, $_.x), $_.y)); //#18196
                            if ($_.cost < $get($_.curlen, $_.y)) { //#18204
                                $put($_.curlen, $_.y, $_.cost); //#18198
                                $k[$j++] = $_.curseq; //#18201
                                $k[$j++] = $_.y; //#18201
                                $k[$j++] = Infinity; //#18199
                                $aload($get($_.curseq, $_.x)); //#18200
                                $aload($get($get($_.latseq, $_.x), $_.y)); //#18201
                                var _9J = $a(); //#18201
                                var _9K = $k[--$j]; //#18202
                                $put($k[--$j], _9K, _9J); //#18202
                                $_.imp = true; //#18203
                            } //#18203
                        } //#18203
                    } //#18203
                    if (!$_.imp) { //#18207
                        break; //#18207
                    } //#18207
                } //#18207
                $_.nxtlen = $a([$_.e, $_.e, $_.e, $_.e]); //#18211
                $_.nxtseq = $a(4); //#18212
                var _9X = $a([$_.A, $_.L, $_.M, $_.P]); //#18214
                for (var _9Y = 0, _9Z = _9X.length; _9Y < _9Z; _9Y++) { //#18247
                    $_.x = $get(_9X, _9Y); //#18215
                    for (;;) { //#18245
                        var _9f = $get($get($_.charvals, $_.x), $_.char) !== undefined; //#18219
                        if (!_9f) { //#18219
                            break; //#18219
                        } //#18219
                        $_.cost = $f($get($_.curlen, $_.x) + 1); //#18222
                        if ($_.cost < $get($_.nxtlen, $_.x)) { //#18226
                            $put($_.nxtlen, $_.x, $_.cost); //#18224
                            $k[$j++] = $_.nxtseq; //#18225
                            $k[$j++] = $_.x; //#18225
                            $k[$j++] = Infinity; //#18225
                            $aload($get($_.curseq, $_.x)); //#18225
                            $k[$j++] = $_.char; //#18225
                            var _9w = $a(); //#18225
                            var _9x = $k[--$j]; //#18225
                            $put($k[--$j], _9x, _9w); //#18225
                        } //#18225
                        var _A3 = $a([$_.A, $_.L, $_.M, $_.P]); //#18229
                        for (var _A4 = 0, _A5 = _A3.length; _A4 < _A5; _A4++) { //#18242
                            $_.y = $get(_A3, _A4); //#18230
                            if ($ne($_.x, $_.y)) { //#18241
                                $_.cost = $f($f($get($_.curlen, $_.y) + $get($get($_.shftlen, $_.y), $_.x)) + 1); //#18232
                                if ($_.cost < $get($_.nxtlen, $_.y)) { //#18240
                                    $put($_.nxtlen, $_.y, $_.cost); //#18234
                                    $k[$j++] = $_.nxtseq; //#18238
                                    $k[$j++] = $_.y; //#18238
                                    $k[$j++] = Infinity; //#18235
                                    $aload($get($_.curseq, $_.y)); //#18236
                                    var _AV = ($_.x == $_.A) ? $_.as : $_.ps; //#18237
                                    $k[$j++] = _AV; //#18238
                                    $k[$j++] = $_.char; //#18238
                                    var _AX = $a(); //#18238
                                    var _AY = $k[--$j]; //#18239
                                    $put($k[--$j], _AY, _AX); //#18239
                                } //#18239
                            } //#18239
                        } //#18239
                        break; //#18244
                    } //#18244
                } //#18244
                $_.curlen = $_.nxtlen; //#18249
                $_.curseq = $_.nxtseq; //#18250
            }); //#18250
            $_.minseq = $_.e; //#18255
            var _Ah = $a([$_.A, $_.L, $_.M, $_.P]); //#18256
            for (var _Ai = 0, _Aj = _Ah.length; _Ai < _Aj; _Ai++) { //#18262
                $_.k = $get(_Ah, _Ai); //#18257
                if ($get($_.curlen, $_.k) < $_.minseq) { //#18261
                    $_.minseq = $get($_.curlen, $_.k); //#18259
                    $_.txtseq = $get($_.curseq, $_.k); //#18260
                } //#18260
            } //#18260
            $_.text = $a($_.minseq); //#18265
            $_.k = 0; //#18266
            $_.l = 0; //#18266
            for (;;) { //#18286
                if ($_.k >= $_.txtseq.length) { //#18267
                    break; //#18267
                } //#18267
                $_.char = $get($_.txtseq, $_.k); //#18269
                $k[$j++] = $_.char; //#18272
                if ($_[$get($_.textencfuncs, $_.submode)]() === true) {
                    break;
                } //#18272
                $_.addtotext(); //#18272
                $_.k = $_.k + 1; //#18273
                if (($_.char == $_.as) || ($_.char == $_.ps)) { //#18279
                    $k[$j++] = $get($_.txtseq, $_.k); //#18277
                    if ($_.char == $_.as) { //#18277
                        $_.enca(); //#18277
                    } else { //#18277
                        $_.encp(); //#18277
                    } //#18277
                    $_.addtotext(); //#18277
                    $_.k = $_.k + 1; //#18278
                } //#18278
                if ($_.char == $_.al) { //#18282
                    $_.submode = $_.A; //#18282
                } //#18282
                if ($_.char == $_.ll) { //#18283
                    $_.submode = $_.L; //#18283
                } //#18283
                if ($_.char == $_.ml) { //#18284
                    $_.submode = $_.M; //#18284
                } //#18284
                if ($_.char == $_.pl) { //#18285
                    $_.submode = $_.P; //#18285
                } //#18285
            } //#18285
            if (($_.text.length % 2) == 1) { //#18333
                if ($_.submode == $_.P) { //#18329
                    $k[$j++] = 'pad'; //#18290
                    $k[$j++] = $_.al; //#18290
                    $_.encp(); //#18290
                    var _BY = $k[--$j]; //#18290
                    $_[$k[--$j]] = _BY; //#18290
                    $_.submode = $_.A; //#18291
                } else { //#18329
                    $_.nextecitext = false; //#18294
                    for (var _Be = $_.i + 1, _Bd = $_.seq.length - 1; _Be <= _Bd; _Be += 1) { //#18301
                        $_.ti = _Be; //#18297
                        if ($ne($type($get($_.seq, $_.ti)), 'arraytype')) { //#18298
                            $_.nextecitext = false; //#18298
                            break; //#18298
                        } //#18298
                        if ($get($get($_.seq, $_.ti), 0) > -1000000) { //#18299
                            break; //#18299
                        } //#18299
                        $_.nextecitext = true; //#18300
                    } //#18300
                    if ($_.nextecitext) { //#18329
                        if ($_.submode == $_.A) { //#18326
                            var _Bx = $get($get($_.charvals, $_.L), $get($get($_.seq, $_.ti), 0)) !== undefined; //#18304
                            if (_Bx) { //#18309
                                $k[$j++] = 'pad'; //#18305
                                $k[$j++] = $_.ll; //#18305
                                $_.enca(); //#18305
                                var _Bz = $k[--$j]; //#18305
                                $_[$k[--$j]] = _Bz; //#18305
                                $_.submode = $_.L; //#18306
                            } else { //#18309
                                $k[$j++] = 'pad'; //#18308
                                $k[$j++] = $_.ml; //#18308
                                $_.enca(); //#18308
                                var _C3 = $k[--$j]; //#18308
                                $_[$k[--$j]] = _C3; //#18308
                                $_.submode = $_.M; //#18309
                            } //#18309
                        } else { //#18326
                            if ($_.submode == $_.M) { //#18326
                                var _CF = $get($get($_.charvals, $_.L), $get($get($_.seq, $_.ti), 0)) !== undefined; //#18313
                                if (_CF) { //#18322
                                    $k[$j++] = 'pad'; //#18314
                                    $k[$j++] = $_.ll; //#18314
                                    $_.encm(); //#18314
                                    var _CH = $k[--$j]; //#18314
                                    $_[$k[--$j]] = _CH; //#18314
                                    $_.submode = $_.L; //#18315
                                } else { //#18322
                                    var _CR = $get($get($_.charvals, $_.P), $get($get($_.seq, $_.ti), 0)) !== undefined; //#18317
                                    if (_CR) { //#18322
                                        $k[$j++] = 'pad'; //#18318
                                        $k[$j++] = $_.pl; //#18318
                                        $_.encm(); //#18318
                                        var _CT = $k[--$j]; //#18318
                                        $_[$k[--$j]] = _CT; //#18318
                                        $_.submode = $_.P; //#18319
                                    } else { //#18322
                                        $k[$j++] = 'pad'; //#18321
                                        $k[$j++] = $_.al; //#18321
                                        $_.encm(); //#18321
                                        var _CX = $k[--$j]; //#18321
                                        $_[$k[--$j]] = _CX; //#18321
                                        $_.submode = $_.A; //#18322
                                    } //#18322
                                } //#18322
                            } else { //#18326
                                $k[$j++] = 'pad'; //#18325
                                $k[$j++] = $_.ml; //#18325
                                $_.encl(); //#18325
                                var _Cb = $k[--$j]; //#18325
                                $_[$k[--$j]] = _Cb; //#18325
                                $_.submode = $_.M; //#18326
                            } //#18326
                        } //#18326
                    } else { //#18329
                        $k[$j++] = 'pad'; //#18329
                        $k[$j++] = $_.ps; //#18329
                        if ($_[$get($_.textencfuncs, $_.submode)]() === true) {
                            return true;
                        } //#18329
                        var _Cj = $k[--$j]; //#18329
                        $_[$k[--$j]] = _Cj; //#18329
                    } //#18329
                } //#18329
                $k[$j++] = Infinity; //#18332
                $aload($_.text); //#18332
                $k[$j++] = $_.pad; //#18332
                $_.text = $a(); //#18332
            } //#18332
            $_.out = $a(~~($_.text.length / 2)); //#18335
            for (var _Cs = 0, _Cr = $_.out.length - 1; _Cs <= _Cr; _Cs += 1) { //#18339
                $_.k = _Cs; //#18337
                $put($_.out, $_.k, $f(($get($_.text, $_.k * 2) * 30) + $get($_.text, ($_.k * 2) + 1))); //#18338
            } //#18338
            $k[$j++] = $_.out; //#18341
        }; //#18341
        $_.encn = function() {
            $_.in = $k[--$j]; //#18346
            $_.out = $a([]); //#18347
            for (var _D6 = 0, _D5 = $_.in.length - 1; _D6 <= _D5; _D6 += 44) { //#18375
                $_.k = _D6; //#18349
                $k[$j++] = Infinity; //#18350
                var _DB = $_.in.length - $_.k; //#18351
                $k[$j++] = 1; //#18351
                $k[$j++] = $_.in; //#18351
                $k[$j++] = $_.k; //#18351
                $k[$j++] = _DB; //#18351
                if (_DB > 44) { //#18351
                    $j--; //#18351
                    $k[$j++] = 44; //#18351
                } //#18351
                var _DC = $k[--$j]; //#18351
                var _DD = $k[--$j]; //#18351
                var _DF = $geti($k[--$j], _DD, _DC); //#18351
                for (var _DG = 0, _DH = _DF.length; _DG < _DH; _DG++) { //#18352
                    $k[$j++] = $f($get(_DF, _DG) - 48); //#18352
                } //#18352
                $_.gmod = $a(); //#18352
                $_.cwn = $a([]); //#18354
                for (;;) { //#18373
                    $_.dv = 900; //#18355
                    $_.gmul = $a([]); //#18356
                    $_.val = 0; //#18356
                    for (;;) { //#18368
                        if ($_.gmod.length == 0) { //#18357
                            break; //#18357
                        } //#18357
                        $_.val = $f(($_.val * 10) + $get($_.gmod, 0)); //#18358
                        $_.gmod = $geti($_.gmod, 1, $_.gmod.length - 1); //#18359
                        if ($_.val < $_.dv) { //#18365
                            if ($_.gmul.length != 0) { //#18363
                                $k[$j++] = Infinity; //#18362
                                $aload($_.gmul); //#18362
                                $k[$j++] = 0; //#18362
                                $_.gmul = $a(); //#18362
                            } //#18362
                        } else { //#18365
                            $k[$j++] = Infinity; //#18365
                            $aload($_.gmul); //#18365
                            $k[$j++] = ~~($_.val / $_.dv); //#18365
                            $_.gmul = $a(); //#18365
                        } //#18365
                        $_.val = $_.val % $_.dv; //#18367
                    } //#18367
                    $_.dv = $_.val; //#18369
                    $k[$j++] = Infinity; //#18370
                    $k[$j++] = $_.dv; //#18370
                    $aload($_.cwn); //#18370
                    $_.cwn = $a(); //#18370
                    $_.gmod = $_.gmul; //#18371
                    if ($_.gmul.length == 0) { //#18372
                        break; //#18372
                    } //#18372
                } //#18372
                $k[$j++] = Infinity; //#18374
                $aload($_.out); //#18374
                $aload($_.cwn); //#18374
                $_.out = $a(); //#18374
            } //#18374
            $k[$j++] = $_.out; //#18376
        }; //#18376
        $_.ence = function() {
            var _Dq = $f((-$get($k[--$j], 0)) - 1000000); //#18381
            $k[$j++] = _Dq; //#18389
            if (_Dq <= 899) { //#18388
                var _Dr = $k[--$j]; //#18382
                $k[$j++] = 927; //#18382
                $k[$j++] = _Dr; //#18382
                $astore($a(2)); //#18382
            } else { //#18388
                var _Dt = $k[--$j]; //#18383
                $k[$j++] = _Dt; //#18389
                if (_Dt <= 810899) { //#18388
                    var _Du = $k[--$j]; //#18384
                    $k[$j++] = 926; //#18384
                    $k[$j++] = (~~(_Du / 900)) - 1; //#18384
                    $k[$j++] = _Du % 900; //#18384
                    $astore($a(3)); //#18384
                } else { //#18388
                    var _Dw = $k[--$j]; //#18385
                    $k[$j++] = _Dw; //#18389
                    if (_Dw <= 811799) { //#18388
                        var _Dx = $k[--$j]; //#18386
                        $k[$j++] = 925; //#18386
                        $k[$j++] = $f(_Dx - 810900); //#18386
                        $astore($a(2)); //#18386
                    } else { //#18388
                        $k[$j++] = 'bwipp.pdf417badECI#18388'; //#18388
                        $k[$j++] = "PDF417 supports ECIs 000000 to 811799"; //#18388
                        bwipp_raiseerror(); //#18388
                    } //#18388
                } //#18388
            } //#18388
        }; //#18388
        $_.encfuncs = $a(['enct', 'encn', 'encb']); //#18392
        $_.addtocws = function() {
            var _E0 = $k[--$j]; //#18395
            $puti($_.datcws, $_.j, _E0); //#18395
            $_.j = _E0.length + $_.j; //#18396
        }; //#18396
        $_.datcws = $a($_.seqlen); //#18401
        $_.i = 0; //#18402
        $_.j = 0; //#18402
        for (;;) { //#18438
            if ($_.i >= $_.seq.length) { //#18403
                break; //#18403
            } //#18403
            $_.chars = $get($_.seq, $_.i); //#18404
            if ($eq($type($_.chars), 'arraytype')) { //#18434
                if ($get($_.chars, 0) <= -1000000) { //#18409
                    $k[$j++] = $_.chars; //#18407
                    $_.ence(); //#18407
                    $_.addtocws(); //#18407
                } else { //#18409
                    $k[$j++] = $_.chars; //#18409
                    if ($_[$get($_.encfuncs, $_.state)]() === true) {
                        break;
                    } //#18409
                    $_.addtocws(); //#18409
                } //#18409
            } else { //#18434
                $k[$j++] = $a([$get($_.latchcws, $_.chars)]); //#18412
                $_.addtocws(); //#18412
                if ($_.chars == $_.tl) { //#18413
                    $_.state = $_.T; //#18413
                    $_.submode = $_.A; //#18413
                } //#18413
                if ($_.chars == $_.nl) { //#18414
                    $_.state = $_.N; //#18414
                } //#18414
                if (($_.chars == $_.bl) || ($_.chars == $_.bl6)) { //#18415
                    $_.state = $_.B; //#18415
                } //#18415
                if ($_.chars == $_.bs) { //#18419
                    $_.i = $_.i + 1; //#18417
                    $k[$j++] = $get($_.seq, $_.i); //#18418
                    $_.encb(); //#18418
                    $_.addtocws(); //#18418
                } //#18418
                if ($_.chars == $_.m05) { //#18427
                    if (($_.i + 1) < $_.seq.length) { //#18425
                        if ($get($_.seq, $_.i + 1) == $_.nl) { //#18424
                            $_.i = $_.i + 1; //#18423
                        } //#18423
                    } //#18423
                    $_.state = $_.N; //#18426
                } //#18426
                if ($_.chars == $_.m06) { //#18435
                    if (($_.i + 1) < $_.seq.length) { //#18433
                        if ($get($_.seq, $_.i + 1) == $_.tl) { //#18432
                            $_.i = $_.i + 1; //#18431
                       