Distributions
=============

ByteBuffer.js uses either ArrayBuffers in the browser or Buffers under node.js.

### Browser: [ArrayBuffer](https://developer.mozilla.org/de/docs/Web/JavaScript/Reference/Global_Objects/ArrayBuffer)-backed

##### Accessed through Typed Arrays

Using Typed Arrays here is pretty much ideal, but it [requires a somewhat recent browser](http://caniuse.com/#feat=typedarrays).

* **[ByteBufferAB.js](https://raw.githubusercontent.com/dcodeIO/ByteBuffer.js/master/dist/ByteBufferAB.js)**
  uses an ArrayBuffer as its backing buffer, accessed through an [Uint8Array](https://developer.mozilla.org/de/docs/Web/JavaScript/Reference/Global_Objects/Uint8Array).
  
* **[ByteBufferAB.min.js](https://raw.githubusercontent.com/dcodeIO/ByteBuffer.js/master/dist/ByteBufferAB.min.js)**
  has been compiled with Closure Compiler using advanced optimizations.
  
* **[ByteBufferAB.min.js.gz](https://raw.githubusercontent.com/dcodeIO/ByteBuffer.js/master/dist/ByteBufferAB.min.js.gz)**
  has also been gzipped using `-9`.
  
* **[ByteBufferAB.min.map](https://raw.githubusercontent.com/dcodeIO/ByteBuffer.js/master/dist/ByteBufferAB.min.map)**
  is the source map generated by Closure Compiler.

##### Accessed through a DataView ([polyfill](https://github.com/inexorabletash/polyfill/blob/master/typedarray.js) compatible)

Using DataViews is [generally slower](https://github.com/dcodeIO/ByteBuffer.js/issues/16) but works well with common polyfills for
older browsers (avoids array access operators on Typed Arrays).

* **[ByteBufferAB_DataView.js](https://raw.githubusercontent.com/dcodeIO/ByteBuffer.js/master/dist/ByteBufferAB_DataView.js)**
  uses an ArrayBuffer as its backing buffer, accessed through a [DataView](https://developer.mozilla.org/de/docs/Web/JavaScript/Reference/Global_Objects/DataView).

* **[ByteBufferAB_DataView.min.js](https://raw.githubusercontent.com/dcodeIO/ByteBuffer.js/master/dist/ByteBufferAB_DataView.min.js)**
  has been compiled with Closure Compiler using advanced optimizations.

* **[ByteBufferAB_DataView.min.js.gz](https://raw.githubusercontent.com/dcodeIO/ByteBuffer.js/master/dist/ByteBufferAB_DataView.min.js.gz)**
  has also been gzipped using `-9`.

* **[ByteBufferAB_DataView.min.map](https://raw.githubusercontent.com/dcodeIO/ByteBuffer.js/master/dist/ByteBufferAB_DataView.min.map)**
  is the source map generated by Closure Compiler.

### node.js: [Buffer](https://nodejs.org/api/buffer.html)-backed

* **[ByteBufferNB.js](https://raw.githubusercontent.com/dcodeIO/ByteBuffer.js/master/dist/ByteBufferNB.js)**
  uses a [node Buffer](https://nodejs.org/api/buffer.html) as its backing buffer and accessor.
  
Also available as `bytebuffer` on [npm](https://www.npmjs.org/package/bytebuffer) and
[bower](http://bower.io/search/?q=bytebuffer).

When installed as an [npm package](https://www.npmjs.org/package/bytebuffer), both versions are available.
`exports` and `exports.ByteBufferNB` point at ByteBufferNB, `exports.ByteBufferAB` points at ByteBufferAB.
