/*!
 * CanJS - 2.2.9
 * http://canjs.com/
 * Copyright (c) 2015 Bitovi
 * Fri, 11 Sep 2015 23:12:43 GMT
 * Licensed MIT
 */

/*[global-shim-start]*/
(function (exports, global){
	var origDefine = global.define;

	var get = function(name){
		var parts = name.split("."),
			cur = global,
			i;
		for(i = 0 ; i < parts.length; i++){
			if(!cur) {
				break;
			}
			cur = cur[parts[i]];
		}
		return cur;
	};
	var modules = (global.define && global.define.modules) ||
		(global._define && global._define.modules) || {};
	var ourDefine = global.define = function(moduleName, deps, callback){
		var module;
		if(typeof deps === "function") {
			callback = deps;
			deps = [];
		}
		var args = [],
			i;
		for(i =0; i < deps.length; i++) {
			args.push( exports[deps[i]] ? get(exports[deps[i]]) : ( modules[deps[i]] || get(deps[i]) )  );
		}
		// CJS has no dependencies but 3 callback arguments
		if(!deps.length && callback.length) {
			module = { exports: {} };
			var require = function(name) {
				return exports[name] ? get(exports[name]) : modules[name];
			};
			args.push(require, module.exports, module);
		}
		// Babel uses only the exports objet
		else if(!args[0] && deps[0] === "exports") {
			module = { exports: {} };
			args[0] = module.exports;
		}

		global.define = origDefine;
		var result = callback ? callback.apply(null, args) : undefined;
		global.define = ourDefine;

		// Favor CJS module.exports over the return value
		modules[moduleName] = module && module.exports ? module.exports : result;
	};
	global.define.orig = origDefine;
	global.define.modules = modules;
	global.define.amd = true;
	global.System = {
		define: function(__name, __code){
			global.define = origDefine;
			eval("(function() { " + __code + " \n }).call(global);");
			global.define = ourDefine;
		}
	};
})({},window)
/*can@2.2.9#control/plugin/plugin*/
define('can/control/plugin/plugin', [
    'dist/jquery',
    'can/util/util',
    'can/control/control'
], function ($, can) {
    $ = $ || window.$;
    var i, isAControllerOf = function (instance, controllers) {
            var name = instance.constructor.pluginName || instance.constructor._shortName;
            for (i = 0; i < controllers.length; i++) {
                if (typeof controllers[i] === 'string' ? name === controllers[i] : instance instanceof controllers[i]) {
                    return true;
                }
            }
            return false;
        }, makeArray = can.makeArray, old = can.Control.setup;
    can.Control.setup = function () {
        if (this !== can.Control) {
            var pluginName = this.pluginName || this._fullName;
            if (pluginName !== 'can_control') {
                this.plugin(pluginName);
            }
            old.apply(this, arguments);
        }
    };
    $.fn.extend({
        controls: function () {
            var controllerNames = makeArray(arguments), instances = [], controls, c;
            this.each(function () {
                controls = can.$(this).data('controls');
                if (!controls) {
                    return;
                }
                for (var i = 0; i < controls.length; i++) {
                    c = controls[i];
                    if (!controllerNames.length || isAControllerOf(c, controllerNames)) {
                        instances.push(c);
                    }
                }
            });
            return instances;
        },
        control: function (control) {
            return this.controls.apply(this, arguments)[0];
        }
    });
    can.Control.plugin = function (pluginname) {
        var control = this;
        if (!$.fn[pluginname]) {
            $.fn[pluginname] = function (options) {
                var args = makeArray(arguments), isMethod = typeof options === 'string' && $.isFunction(control.prototype[options]), meth = args[0], returns;
                this.each(function () {
                    var plugin = can.$(this).control(control);
                    if (plugin) {
                        if (isMethod) {
                            returns = plugin[meth].apply(plugin, args.slice(1));
                        } else {
                            plugin.update.apply(plugin, args);
                        }
                    } else {
                        control.newInstance.apply(control, [this].concat(args));
                    }
                });
                return returns !== undefined ? returns : this;
            };
        }
    };
    can.Control.prototype.update = function (options) {
        can.extend(this.options, options);
        this.on();
    };
    return can;
});
/*[global-shim-end]*/
(function (){
	window._define = window.define;
	window.define = window.define.orig;
})();
