/*!
 * CanJS - 2.2.9
 * http://canjs.com/
 * Copyright (c) 2015 Bitovi
 * Fri, 11 Sep 2015 23:12:43 GMT
 * Licensed MIT
 */

/*can@2.2.9#compute/read*/
var can = require('../util/util.js');
var read = function (parent, reads, options) {
    options = options || {};
    var state = { foundObservable: false };
    var cur = readValue(parent, 0, reads, options, state), type, prev, readLength = reads.length, i = 0;
    while (i < readLength) {
        prev = cur;
        for (var r = 0, readersLength = read.propertyReaders.length; r < readersLength; r++) {
            var reader = read.propertyReaders[r];
            if (reader.test(cur)) {
                cur = reader.read(cur, reads[i], i, options, state);
                break;
            }
        }
        i = i + 1;
        cur = readValue(cur, i, reads, options, state, prev);
        type = typeof cur;
        if (i < reads.length && (cur === null || type !== 'function' && type !== 'object')) {
            if (options.earlyExit) {
                options.earlyExit(prev, i - 1, cur);
            }
            return {
                value: undefined,
                parent: prev
            };
        }
    }
    if (cur === undefined) {
        if (options.earlyExit) {
            options.earlyExit(prev, i - 1);
        }
    }
    return {
        value: cur,
        parent: prev
    };
};
var readValue = function (value, index, reads, options, state, prev) {
    var usedValueReader;
    do {
        usedValueReader = false;
        for (var i = 0, len = read.valueReaders.length; i < len; i++) {
            if (read.valueReaders[i].test(value, index, reads, options)) {
                value = read.valueReaders[i].read(value, index, reads, options, state, prev);
            }
        }
    } while (usedValueReader);
    return value;
};
read.valueReaders = [
    {
        name: 'compute',
        test: function (value, i, reads, options) {
            return value && value.isComputed;
        },
        read: function (value, i, reads, options, state) {
            if (options.isArgument && i === reads.length) {
                return value;
            }
            if (!state.foundObservable && options.foundObservable) {
                options.foundObservable(value, i);
                state.foundObservable = true;
            }
            return value instanceof can.Compute ? value.get() : value();
        }
    },
    {
        name: 'function',
        test: function (value, i, reads, options) {
            var type = typeof value;
            return type === 'function' && !value.isComputed && (options.executeAnonymousFunctions !== false || options.isArgument && i === reads.length) && !(can.Construct && value.prototype instanceof can.Construct) && !(can.route && value === can.route);
        },
        read: function (value, i, reads, options, state, prev) {
            if (options.isArgument && i === reads.length) {
                return options.proxyMethods !== false ? can.proxy(value, prev) : value;
            }
            return value.call(prev);
        }
    }
];
read.propertyReaders = [
    {
        name: 'map',
        test: can.isMapLike,
        read: function (value, prop, index, options, state) {
            if (!state.foundObservable && options.foundObservable) {
                options.foundObservable(value, index);
                state.foundObservable = true;
            }
            if (typeof value[prop] === 'function' && value.constructor.prototype[prop] === value[prop]) {
                if (options.returnObserveMethods) {
                    return value[prop];
                } else if (prop === 'constructor' && value instanceof can.Construct || value[prop].prototype instanceof can.Construct) {
                    return value[prop];
                } else {
                    return value[prop].apply(value, options.args || []);
                }
            } else {
                return value.attr(prop);
            }
        }
    },
    {
        name: 'promise',
        test: function (value) {
            return can.isPromise(value);
        },
        read: function (value, prop, index, options, state) {
            if (!state.foundObservable && options.foundObservable) {
                options.foundObservable(value, index);
                state.foundObservable = true;
            }
            var observeData = value.__observeData;
            if (!value.__observeData) {
                observeData = value.__observeData = {
                    isPending: true,
                    state: 'pending',
                    isResolved: false,
                    isRejected: false,
                    value: undefined,
                    reason: undefined
                };
                can.cid(observeData);
                can.simpleExtend(observeData, can.event);
                value.then(function (value) {
                    observeData.isPending = false;
                    observeData.isResolved = true;
                    observeData.value = value;
                    observeData.state = 'resolved';
                    observeData.dispatch('state', [
                        'resolved',
                        'pending'
                    ]);
                }, function (reason) {
                    observeData.isPending = false;
                    observeData.isRejected = true;
                    observeData.reason = reason;
                    observeData.state = 'rejected';
                    observeData.dispatch('state', [
                        'rejected',
                        'pending'
                    ]);
                });
            }
            can.__observe(observeData, 'state');
            return prop in observeData ? observeData[prop] : value[prop];
        }
    },
    {
        name: 'object',
        test: function () {
            return true;
        },
        read: function (value, prop) {
            if (value == null) {
                return undefined;
            } else {
                return value[prop];
            }
        }
    }
];
read.write = function (parent, key, value, options) {
    options = options || {};
    if (can.isMapLike(parent)) {
        if (!options.isArgument && parent._data && parent._data[key] && parent._data[key].isComputed) {
            return parent._data[key](value);
        } else {
            return parent.attr(key, value);
        }
    }
    if (parent[key] && parent[key].isComputed) {
        return parent[key](value);
    }
    if (typeof parent === 'object') {
        parent[key] = value;
    }
};
module.exports = read;
