/*!
 * CanJS - 2.2.9
 * http://canjs.com/
 * Copyright (c) 2015 Bitovi
 * Fri, 11 Sep 2015 23:12:43 GMT
 * Licensed MIT
 */

/*can@2.2.9#util/attr/attr*/
var can = require('../can.js');
var setImmediate = can.global.setImmediate || function (cb) {
        return setTimeout(cb, 0);
    }, attr = {
        MutationObserver: can.global.MutationObserver || can.global.WebKitMutationObserver || can.global.MozMutationObserver,
        map: {
            'class': 'className',
            'value': 'value',
            'innertext': 'innerText',
            'textcontent': 'textContent',
            'checked': true,
            'disabled': true,
            'readonly': true,
            'required': true,
            src: function (el, val) {
                if (val == null || val === '') {
                    el.removeAttribute('src');
                    return null;
                } else {
                    el.setAttribute('src', val);
                    return val;
                }
            },
            style: function (el, val) {
                return el.style.cssText = val || '';
            }
        },
        defaultValue: [
            'input',
            'textarea'
        ],
        set: function (el, attrName, val) {
            attrName = attrName.toLowerCase();
            var oldValue;
            if (!attr.MutationObserver) {
                oldValue = attr.get(el, attrName);
            }
            var tagName = el.nodeName.toString().toLowerCase(), prop = attr.map[attrName], newValue;
            if (typeof prop === 'function') {
                newValue = prop(el, val);
            } else if (prop === true) {
                newValue = el[attrName] = true;
                if (attrName === 'checked' && el.type === 'radio') {
                    if (can.inArray(tagName, attr.defaultValue) >= 0) {
                        el.defaultChecked = true;
                    }
                }
            } else if (prop) {
                newValue = val;
                if (el[prop] !== val) {
                    el[prop] = val;
                }
                if (prop === 'value' && can.inArray(tagName, attr.defaultValue) >= 0) {
                    el.defaultValue = val;
                }
            } else {
                el.setAttribute(attrName, val);
                newValue = val;
            }
            if (!attr.MutationObserver && newValue !== oldValue) {
                attr.trigger(el, attrName, oldValue);
            }
        },
        trigger: function (el, attrName, oldValue) {
            if (can.data(can.$(el), 'canHasAttributesBindings')) {
                attrName = attrName.toLowerCase();
                return setImmediate(function () {
                    can.trigger(el, {
                        type: 'attributes',
                        attributeName: attrName,
                        target: el,
                        oldValue: oldValue,
                        bubbles: false
                    }, []);
                });
            }
        },
        get: function (el, attrName) {
            attrName = attrName.toLowerCase();
            var prop = attr.map[attrName];
            if (typeof prop === 'string' && el[prop]) {
                return el[prop];
            }
            return el.getAttribute(attrName);
        },
        remove: function (el, attrName) {
            attrName = attrName.toLowerCase();
            var oldValue;
            if (!attr.MutationObserver) {
                oldValue = attr.get(el, attrName);
            }
            var setter = attr.map[attrName];
            if (typeof setter === 'function') {
                setter(el, undefined);
            }
            if (setter === true) {
                el[attrName] = false;
            } else if (typeof setter === 'string') {
                el[setter] = '';
            } else {
                el.removeAttribute(attrName);
            }
            if (!attr.MutationObserver && oldValue != null) {
                attr.trigger(el, attrName, oldValue);
            }
        },
        has: function () {
            var el = can.global.document && document.createElement('div');
            if (el && el.hasAttribute) {
                return function (el, name) {
                    return el.hasAttribute(name);
                };
            } else {
                return function (el, name) {
                    return el.getAttribute(name) !== null;
                };
            }
        }()
    };
module.exports = attr;
