/*!
 * CanJS - 2.2.9
 * http://canjs.com/
 * Copyright (c) 2015 Bitovi
 * Fri, 11 Sep 2015 23:12:43 GMT
 * Licensed MIT
 */

/*can@2.2.9#util/string/string*/
var can = require('../util.js');
var strUndHash = /_|-/, strColons = /\=\=/, strWords = /([A-Z]+)([A-Z][a-z])/g, strLowUp = /([a-z\d])([A-Z])/g, strDash = /([a-z\d])([A-Z])/g, strReplacer = /\{([^\}]+)\}/g, strQuote = /"/g, strSingleQuote = /'/g, strHyphenMatch = /-+(.)?/g, strCamelMatch = /[a-z][A-Z]/g, getNext = function (obj, prop, add) {
        var result = obj[prop];
        if (result === undefined && add === true) {
            result = obj[prop] = {};
        }
        return result;
    }, isContainer = function (current) {
        return /^f|^o/.test(typeof current);
    }, convertBadValues = function (content) {
        var isInvalid = content === null || content === undefined || isNaN(content) && '' + content === 'NaN';
        return '' + (isInvalid ? '' : content);
    };
can.extend(can, {
    esc: function (content) {
        return convertBadValues(content).replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(strQuote, '&#34;').replace(strSingleQuote, '&#39;');
    },
    getObject: function (name, roots, add) {
        var parts = name ? name.split('.') : [], length = parts.length, current, r = 0, i, container, rootsLength;
        roots = can.isArray(roots) ? roots : [roots || window];
        rootsLength = roots.length;
        if (!length) {
            return roots[0];
        }
        for (r; r < rootsLength; r++) {
            current = roots[r];
            container = undefined;
            for (i = 0; i < length && isContainer(current); i++) {
                container = current;
                current = getNext(container, parts[i]);
            }
            if (container !== undefined && current !== undefined) {
                break;
            }
        }
        if (add === false && current !== undefined) {
            delete container[parts[i - 1]];
        }
        if (add === true && current === undefined) {
            current = roots[0];
            for (i = 0; i < length && isContainer(current); i++) {
                current = getNext(current, parts[i], true);
            }
        }
        return current;
    },
    capitalize: function (s, cache) {
        return s.charAt(0).toUpperCase() + s.slice(1);
    },
    camelize: function (str) {
        return convertBadValues(str).replace(strHyphenMatch, function (match, chr) {
            return chr ? chr.toUpperCase() : '';
        });
    },
    hyphenate: function (str) {
        return convertBadValues(str).replace(strCamelMatch, function (str, offset) {
            return str.charAt(0) + '-' + str.charAt(1).toLowerCase();
        });
    },
    underscore: function (s) {
        return s.replace(strColons, '/').replace(strWords, '$1_$2').replace(strLowUp, '$1_$2').replace(strDash, '_').toLowerCase();
    },
    sub: function (str, data, remove) {
        var obs = [];
        str = str || '';
        obs.push(str.replace(strReplacer, function (whole, inside) {
            var ob = can.getObject(inside, data, remove === true ? false : undefined);
            if (ob === undefined || ob === null) {
                obs = null;
                return '';
            }
            if (isContainer(ob) && obs) {
                obs.push(ob);
                return '';
            }
            return '' + ob;
        }));
        return obs === null ? obs : obs.length <= 1 ? obs[0] : obs;
    },
    replacer: strReplacer,
    undHash: strUndHash
});
module.exports = can;
