steal('./spec',function(){ window.MUSTACHE_SPECS.push({name:'interpolation', data: {"overview":"Interpolation tags are used to integrate dynamic content into the template.\n\nThe tag's content MUST be a non-whitespace character sequence NOT containing\nthe current closing delimiter.\n\nThis tag's content names the data to replace the tag.  A single period (`.`)\nindicates that the item currently sitting atop the context stack should be\nused; otherwise, name resolution is as follows:\n  1) Split the name on periods; the first part is the name to resolve, any\n  remaining parts should be retained.\n  2) Walk the context stack from top to bottom, finding the first context\n  that is a) a hash containing the name as a key OR b) an object responding\n  to a method with the given name.\n  3) If the context is a hash, the data is the value associated with the\n  name.\n  4) If the context is an object, the data is the value returned by the\n  method with the given name.\n  5) If any name parts were retained in step 1, each should be resolved\n  against a context stack containing only the result from the former\n  resolution.  If any part fails resolution, the result should be considered\n  falsey, and should interpolate as the empty string.\nData should be coerced into a string (and escaped, if appropriate) before\ninterpolation.\n\nThe Interpolation tags MUST NOT be treated as standalone.\n","tests":[{"name":"No Interpolation","desc":"Mustache-free templates should render as-is.","data":{},"template":"Hello from {Mustache}!\n","expected":"Hello from {Mustache}!\n"},{"name":"Basic Interpolation","desc":"Unadorned tags should interpolate content into the template.","data":{"subject":"world"},"template":"Hello, {{subject}}!\n","expected":"Hello, world!\n"},{"name":"HTML Escaping","desc":"Basic interpolation should be HTML escaped.","data":{"forbidden":"& \" < >"},"template":"These characters should be HTML escaped: {{forbidden}}\n","expected":"These characters should be HTML escaped: &amp; &quot; &lt; &gt;\n"},{"name":"Triple Mustache","desc":"Triple mustaches should interpolate without HTML escaping.","data":{"forbidden":"& \" < >"},"template":"These characters should not be HTML escaped: {{{forbidden}}}\n","expected":"These characters should not be HTML escaped: & \" < >\n"},{"name":"Ampersand","desc":"Ampersand should interpolate without HTML escaping.","data":{"forbidden":"& \" < >"},"template":"These characters should not be HTML escaped: {{&forbidden}}\n","expected":"These characters should not be HTML escaped: & \" < >\n"},{"name":"Basic Integer Interpolation","desc":"Integers should interpolate seamlessly.","data":{"mph":85},"template":"\"{{mph}} miles an hour!\"","expected":"\"85 miles an hour!\""},{"name":"Triple Mustache Integer Interpolation","desc":"Integers should interpolate seamlessly.","data":{"mph":85},"template":"\"{{{mph}}} miles an hour!\"","expected":"\"85 miles an hour!\""},{"name":"Ampersand Integer Interpolation","desc":"Integers should interpolate seamlessly.","data":{"mph":85},"template":"\"{{&mph}} miles an hour!\"","expected":"\"85 miles an hour!\""},{"name":"Basic Decimal Interpolation","desc":"Decimals should interpolate seamlessly with proper significance.","data":{"power":1.21},"template":"\"{{power}} jiggawatts!\"","expected":"\"1.21 jiggawatts!\""},{"name":"Triple Mustache Decimal Interpolation","desc":"Decimals should interpolate seamlessly with proper significance.","data":{"power":1.21},"template":"\"{{{power}}} jiggawatts!\"","expected":"\"1.21 jiggawatts!\""},{"name":"Ampersand Decimal Interpolation","desc":"Decimals should interpolate seamlessly with proper significance.","data":{"power":1.21},"template":"\"{{&power}} jiggawatts!\"","expected":"\"1.21 jiggawatts!\""},{"name":"Basic Context Miss Interpolation","desc":"Failed context lookups should default to empty strings.","data":{},"template":"I ({{cannot}}) be seen!","expected":"I () be seen!"},{"name":"Triple Mustache Context Miss Interpolation","desc":"Failed context lookups should default to empty strings.","data":{},"template":"I ({{{cannot}}}) be seen!","expected":"I () be seen!"},{"name":"Ampersand Context Miss Interpolation","desc":"Failed context lookups should default to empty strings.","data":{},"template":"I ({{&cannot}}) be seen!","expected":"I () be seen!"},{"name":"Dotted Names - Basic Interpolation","desc":"Dotted names should be considered a form of shorthand for sections.","data":{"person":{"name":"Joe"}},"template":"\"{{person.name}}\" == \"{{#person}}{{name}}{{/person}}\"","expected":"\"Joe\" == \"Joe\""},{"name":"Dotted Names - Triple Mustache Interpolation","desc":"Dotted names should be considered a form of shorthand for sections.","data":{"person":{"name":"Joe"}},"template":"\"{{{person.name}}}\" == \"{{#person}}{{{name}}}{{/person}}\"","expected":"\"Joe\" == \"Joe\""},{"name":"Dotted Names - Ampersand Interpolation","desc":"Dotted names should be considered a form of shorthand for sections.","data":{"person":{"name":"Joe"}},"template":"\"{{&person.name}}\" == \"{{#person}}{{&name}}{{/person}}\"","expected":"\"Joe\" == \"Joe\""},{"name":"Dotted Names - Arbitrary Depth","desc":"Dotted names should be functional to any level of nesting.","data":{"a":{"b":{"c":{"d":{"e":{"name":"Phil"}}}}}},"template":"\"{{a.b.c.d.e.name}}\" == \"Phil\"","expected":"\"Phil\" == \"Phil\""},{"name":"Dotted Names - Broken Chains","desc":"Any falsey value prior to the last part of the name should yield ''.","data":{"a":{}},"template":"\"{{a.b.c}}\" == \"\"","expected":"\"\" == \"\""},{"name":"Dotted Names - Broken Chain Resolution","desc":"Each part of a dotted name should resolve only against its parent.","data":{"a":{"b":{}},"c":{"name":"Jim"}},"template":"\"{{a.b.c.name}}\" == \"\"","expected":"\"\" == \"\""},{"name":"Dotted Names - Initial Resolution","desc":"The first part of a dotted name should resolve as any other name.","data":{"a":{"b":{"c":{"d":{"e":{"name":"Phil"}}}}},"b":{"c":{"d":{"e":{"name":"Wrong"}}}}},"template":"\"{{#a}}{{b.c.d.e.name}}{{/a}}\" == \"Phil\"","expected":"\"Phil\" == \"Phil\""},{"name":"Interpolation - Surrounding Whitespace","desc":"Interpolation should not alter surrounding whitespace.","data":{"string":"---"},"template":"| {{string}} |","expected":"| --- |"},{"name":"Triple Mustache - Surrounding Whitespace","desc":"Interpolation should not alter surrounding whitespace.","data":{"string":"---"},"template":"| {{{string}}} |","expected":"| --- |"},{"name":"Ampersand - Surrounding Whitespace","desc":"Interpolation should not alter surrounding whitespace.","data":{"string":"---"},"template":"| {{&string}} |","expected":"| --- |"},{"name":"Interpolation - Standalone","desc":"Standalone interpolation should not alter surrounding whitespace.","data":{"string":"---"},"template":"  {{string}}\n","expected":"  ---\n"},{"name":"Triple Mustache - Standalone","desc":"Standalone interpolation should not alter surrounding whitespace.","data":{"string":"---"},"template":"  {{{string}}}\n","expected":"  ---\n"},{"name":"Ampersand - Standalone","desc":"Standalone interpolation should not alter surrounding whitespace.","data":{"string":"---"},"template":"  {{&string}}\n","expected":"  ---\n"},{"name":"Interpolation With Padding","desc":"Superfluous in-tag whitespace should be ignored.","data":{"string":"---"},"template":"|{{ string }}|","expected":"|---|"},{"name":"Triple Mustache With Padding","desc":"Superfluous in-tag whitespace should be ignored.","data":{"string":"---"},"template":"|{{{ string }}}|","expected":"|---|"},{"name":"Ampersand With Padding","desc":"Superfluous in-tag whitespace should be ignored.","data":{"string":"---"},"template":"|{{& string }}|","expected":"|---|"}],"__ATTN__":"Do not edit this file; changes belong in the appropriate YAML file."}});});