function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { settings } from 'carbon-components';
import cx from 'classnames';
import PropTypes from 'prop-types';
import React, { Children, cloneElement, useEffect, useRef, useState } from 'react';
import { composeEventHandlers } from '../../tools/events';
import { getNextIndex, matches, keys } from '../../internal/keyboard';
var prefix = settings.prefix;

function ContentSwitcher(_ref) {
  var children = _ref.children,
      customClassName = _ref.className,
      onChange = _ref.onChange,
      _ref$selectedIndex = _ref.selectedIndex,
      controlledSelectedIndex = _ref$selectedIndex === void 0 ? 0 : _ref$selectedIndex,
      rest = _objectWithoutProperties(_ref, ["children", "className", "onChange", "selectedIndex"]);

  var switchRefs = [];
  var className = cx("".concat(prefix, "--content-switcher"), customClassName);
  var savedOnChange = useRef(null);

  var _useState = useState(controlledSelectedIndex),
      _useState2 = _slicedToArray(_useState, 2),
      selectedIndex = _useState2[0],
      setSelectedIndex = _useState2[1];

  var _useState3 = useState(controlledSelectedIndex),
      _useState4 = _slicedToArray(_useState3, 2),
      prevControlledIndex = _useState4[0],
      setPrevControlledIndex = _useState4[1];

  var _useState5 = useState(false),
      _useState6 = _slicedToArray(_useState5, 2),
      shouldFocus = _useState6[0],
      setShouldFocus = _useState6[1];

  if (controlledSelectedIndex !== prevControlledIndex) {
    setSelectedIndex(controlledSelectedIndex);
    setPrevControlledIndex(controlledSelectedIndex);
    setShouldFocus(false);
  } // Always keep track of the latest `onChange` prop to use in our focus effect
  // handler


  useEffect(function () {
    savedOnChange.current = onChange;
  }, [onChange]); // If our selectedIndex has changed from an event handler, meaning that
  // `shouldFocus` is set to true, then call the saved `onChange` handler if it
  // exists

  useEffect(function () {
    if (shouldFocus && savedOnChange.current) {
      savedOnChange.current(selectedIndex);
    }
  }, [shouldFocus, selectedIndex]); // We have a couple of scenarios we want to keep track of when managing focus:
  // 1) Don't focus the ref at the selectedIndex if its the first render, focus
  //    should only come from a user action
  // 2) Don't focus if selectedIndex has changed because of a change in props
  // 3) Trigger focus if triggered by click or key down. Both of these handlers
  //    should set `shouldFocus` to true

  useEffect(function () {
    if (!shouldFocus) {
      return;
    }

    var ref = switchRefs[selectedIndex];

    if (ref && document.activeElement !== ref) {
      ref.focus && ref.focus();
    }
  }, [shouldFocus, switchRefs, selectedIndex]);

  function handleItemRef(index) {
    return function (ref) {
      switchRefs[index] = ref;
    };
  }

  function onClick(event, index) {
    if (selectedIndex !== index) {
      setSelectedIndex(index);

      if (shouldFocus !== true) {
        setShouldFocus(true);
      }
    }
  }

  function onKeyDown(event) {
    if (matches(event, [keys.ArrowRight, keys.ArrowLeft])) {
      setSelectedIndex(getNextIndex(event, selectedIndex, children.length));

      if (shouldFocus !== true) {
        setShouldFocus(true);
      }
    }
  }

  return React.createElement("div", _extends({
    className: className
  }, rest), Children.map(children, function (child, index) {
    return cloneElement(child, {
      index: index,
      onClick: composeEventHandlers([onClick, child.props.onClick]),
      onKeyDown: composeEventHandlers([onKeyDown, child.props.onKeyDown]),
      selected: index === selectedIndex,
      ref: handleItemRef(index)
    });
  }));
}

ContentSwitcher.propTypes = {
  /**
   * Pass in Switch components to be rendered in the ContentSwitcher
   */
  children: PropTypes.node,

  /**
   * Specify an optional className to be added to the container node
   */
  className: PropTypes.string,

  /**
   * Specify an `onChange` handler that is called whenever the ContentSwitcher
   * changes which item is selected
   */
  onChange: PropTypes.func.isRequired,

  /**
   * Specify a selected index for the initially selected content
   */
  selectedIndex: PropTypes.number
};
export default ContentSwitcher;