function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { settings } from 'carbon-components';
import cx from 'classnames';
import PropTypes from 'prop-types';
import React from 'react';
import deprecate from '../../prop-types/deprecate';
var prefix = settings.prefix;
var Switch = React.forwardRef(function Switch(_ref, ref) {
  var _cx;

  var customClassName = _ref.className,
      index = _ref.index,
      onClick = _ref.onClick,
      name = _ref.name,
      _ref$selected = _ref.selected,
      selected = _ref$selected === void 0 ? false : _ref$selected,
      text = _ref.text,
      rest = _objectWithoutProperties(_ref, ["className", "index", "onClick", "name", "selected", "text"]);

  var className = cx((_cx = {}, _defineProperty(_cx, "".concat(prefix, "--content-switcher-btn"), true), _defineProperty(_cx, "".concat(prefix, "--content-switcher--selected"), selected), _defineProperty(_cx, customClassName, !!customClassName), _cx));

  function handleOnClick(event) {
    onClick(event, index);
  }

  return React.createElement("button", _extends({
    "aria-selected": selected,
    className: className,
    ref: ref,
    role: "tab",
    onClick: handleOnClick,
    tabIndex: selected ? '0' : '-1',
    type: "button"
  }, rest), React.createElement("span", {
    className: "".concat(prefix, "--content-switcher__label")
  }, text));
});
Switch.displayName = 'Switch';
Switch.propTypes = {
  /**
   * Specify an optional className to be added to your Switch
   */
  className: PropTypes.string,

  /**
   * Provide the name of your Switch that is used for event handlers
   */
  name: deprecate(PropTypes.oneOfType([PropTypes.string, PropTypes.number])),

  /**
   * The index of your Switch in your ContentSwitcher that is used for event handlers.
   * Reserved for usage in ContentSwitcher
   */
  index: PropTypes.number,

  /**
   * A handler that is invoked when a user clicks on the control.
   */
  onClick: PropTypes.func,

  /**
   * A handler that is invoked on the key down event for the control.
   */
  onKeyDown: PropTypes.func,

  /**
   * Whether your Switch is selected. Reserved for usage in ContentSwitcher
   */
  selected: PropTypes.bool,

  /**
   * Provide the contents of your Switch
   */
  text: PropTypes.string.isRequired
};
export default Switch;