"use strict";

var _react = _interopRequireDefault(require("react"));

var _Checkbox = _interopRequireDefault(require("../Checkbox"));

var _Checkbox2 = _interopRequireDefault(require("../Checkbox/Checkbox.Skeleton"));

var _enzyme = require("enzyme");

var _carbonComponents = require("carbon-components");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var prefix = _carbonComponents.settings.prefix;
describe('Checkbox', function () {
  describe('Renders as expected', function () {
    var wrapper = (0, _enzyme.mount)(_react.default.createElement(_Checkbox.default, {
      id: "testing",
      labelText: "testingLabel",
      className: "extra-class"
    }));
    var label = wrapper.find('label');
    describe('label', function () {
      it('renders a label', function () {
        expect(label.length).toEqual(1);
      });
      it('has the expected classes', function () {
        expect(label.hasClass("".concat(prefix, "--checkbox-label"))).toEqual(true);
      });
      it('has the expected htmlFor value', function () {
        expect(label.props().htmlFor).toEqual('testing');
      });
      it('applies extra classes to label', function () {
        expect(label.hasClass('extra-class')).toEqual(true);
      });
      describe('input', function () {
        var input = function input() {
          return wrapper.find('input');
        };

        it('has id set as expected', function () {
          expect(input().props().id).toEqual('testing');
        });
        it('defaultChecked prop sets defaultChecked on input', function () {
          expect(input().props().defaultChecked).toBeUndefined();
          wrapper.setProps({
            defaultChecked: true
          });
          expect(input().props().defaultChecked).toEqual(true);
        });
      });
    });
  });
  it('disabled prop on component sets disabled prop on input', function () {
    var wrapper = (0, _enzyme.mount)(_react.default.createElement(_Checkbox.default, {
      id: "test",
      labelText: "testlabel",
      disabled: true
    }));

    var input = function input() {
      return wrapper.find('input');
    };

    expect(input().props().disabled).toEqual(true);
    wrapper.setProps({
      disabled: false
    });
    expect(input().props().disabled).toEqual(false);
  });
  it('checked prop on component sets checked prop on input', function () {
    var wrapper = (0, _enzyme.mount)(_react.default.createElement(_Checkbox.default, {
      id: "test",
      labelText: "testlabel",
      checked: true
    }));

    var input = function input() {
      return wrapper.find('input');
    };

    expect(input().props().checked).toEqual(true);
    wrapper.setProps({
      checked: false
    });
    expect(input().props().checked).toEqual(false);
  });
  it('hideLabel hides the label visually', function () {
    var wrapper = (0, _enzyme.mount)(_react.default.createElement(_Checkbox.default, {
      id: "test",
      labelText: "testlabel",
      hideLabel: true
    }));
    var label = wrapper.find('label');
    expect(label.length).toEqual(1);
    var span = wrapper.find('span');
    expect(span.hasClass("".concat(prefix, "--visually-hidden"))).toEqual(true);
  });
  describe('events', function () {
    it('should invoke onChange with expected arguments', function () {
      var onChange = jest.fn();
      var id = 'test-input';
      var wrapper = (0, _enzyme.mount)(_react.default.createElement(_Checkbox.default, {
        labelText: "testlabel",
        id: id,
        onChange: onChange
      }));
      var input = wrapper.find('input');
      var inputElement = input.instance();
      inputElement.checked = true;
      wrapper.find('input').simulate('change');
      var call = onChange.mock.calls[0];
      expect(call[0]).toEqual(true);
      expect(call[1]).toEqual(id);
      expect(call[2].target).toBe(inputElement);
    });
  });
});
describe('refs', function () {
  it('should accept refs', function () {
    var MyComponent =
    /*#__PURE__*/
    function (_React$Component) {
      _inherits(MyComponent, _React$Component);

      function MyComponent(props) {
        var _this;

        _classCallCheck(this, MyComponent);

        _this = _possibleConstructorReturn(this, _getPrototypeOf(MyComponent).call(this, props));
        _this.myRef = _react.default.createRef();
        _this.focus = _this.focus.bind(_assertThisInitialized(_this));
        return _this;
      }

      _createClass(MyComponent, [{
        key: "focus",
        value: function focus() {
          this.myRef.current.focus();
        }
      }, {
        key: "render",
        value: function render() {
          return _react.default.createElement(_Checkbox.default, {
            id: "test",
            labelText: "testlabel",
            hideLabel: true,
            ref: this.myRef
          });
        }
      }]);

      return MyComponent;
    }(_react.default.Component);

    var wrapper = (0, _enzyme.mount)(_react.default.createElement(MyComponent, null));
    expect(document.activeElement.type).toBeUndefined();
    wrapper.instance().focus();
    expect(document.activeElement.type).toEqual('checkbox');
  });
  it('should set indeterminate when accepting refs', function () {
    var MyComponent =
    /*#__PURE__*/
    function (_React$Component2) {
      _inherits(MyComponent, _React$Component2);

      function MyComponent(props) {
        var _this2;

        _classCallCheck(this, MyComponent);

        _this2 = _possibleConstructorReturn(this, _getPrototypeOf(MyComponent).call(this, props));
        _this2.myRef = _react.default.createRef();
        return _this2;
      }

      _createClass(MyComponent, [{
        key: "render",
        value: function render() {
          return _react.default.createElement(_Checkbox.default, {
            indeterminate: true,
            ref: this.myRef
          });
        }
      }]);

      return MyComponent;
    }(_react.default.Component);

    var wrapper = (0, _enzyme.mount)(_react.default.createElement(MyComponent, null));
    expect(wrapper.find('input').getDOMNode().indeterminate).toBe(true);
  });
});
describe('CheckboxSkeleton', function () {
  describe('Renders as expected', function () {
    var wrapper = (0, _enzyme.mount)(_react.default.createElement(_Checkbox2.default, null));
    var label = wrapper.find('label');
    describe('label', function () {
      it('renders a label', function () {
        expect(label.length).toEqual(1);
      });
      it('has the expected classes', function () {
        expect(label.hasClass("".concat(prefix, "--checkbox-label"))).toEqual(true);
        expect(label.hasClass("".concat(prefix, "--skeleton"))).toEqual(true);
      });
    });
  });
});