"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _carbonComponents = require("carbon-components");

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _events = require("../../tools/events");

var _keyboard = require("../../internal/keyboard");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var prefix = _carbonComponents.settings.prefix;

function ContentSwitcher(_ref) {
  var children = _ref.children,
      customClassName = _ref.className,
      onChange = _ref.onChange,
      _ref$selectedIndex = _ref.selectedIndex,
      controlledSelectedIndex = _ref$selectedIndex === void 0 ? 0 : _ref$selectedIndex,
      rest = _objectWithoutProperties(_ref, ["children", "className", "onChange", "selectedIndex"]);

  var switchRefs = [];
  var className = (0, _classnames.default)("".concat(prefix, "--content-switcher"), customClassName);
  var savedOnChange = (0, _react.useRef)(null);

  var _useState = (0, _react.useState)(controlledSelectedIndex),
      _useState2 = _slicedToArray(_useState, 2),
      selectedIndex = _useState2[0],
      setSelectedIndex = _useState2[1];

  var _useState3 = (0, _react.useState)(controlledSelectedIndex),
      _useState4 = _slicedToArray(_useState3, 2),
      prevControlledIndex = _useState4[0],
      setPrevControlledIndex = _useState4[1];

  var _useState5 = (0, _react.useState)(false),
      _useState6 = _slicedToArray(_useState5, 2),
      shouldFocus = _useState6[0],
      setShouldFocus = _useState6[1];

  if (controlledSelectedIndex !== prevControlledIndex) {
    setSelectedIndex(controlledSelectedIndex);
    setPrevControlledIndex(controlledSelectedIndex);
    setShouldFocus(false);
  } // Always keep track of the latest `onChange` prop to use in our focus effect
  // handler


  (0, _react.useEffect)(function () {
    savedOnChange.current = onChange;
  }, [onChange]); // If our selectedIndex has changed from an event handler, meaning that
  // `shouldFocus` is set to true, then call the saved `onChange` handler if it
  // exists

  (0, _react.useEffect)(function () {
    if (shouldFocus && savedOnChange.current) {
      savedOnChange.current(selectedIndex);
    }
  }, [shouldFocus, selectedIndex]); // We have a couple of scenarios we want to keep track of when managing focus:
  // 1) Don't focus the ref at the selectedIndex if its the first render, focus
  //    should only come from a user action
  // 2) Don't focus if selectedIndex has changed because of a change in props
  // 3) Trigger focus if triggered by click or key down. Both of these handlers
  //    should set `shouldFocus` to true

  (0, _react.useEffect)(function () {
    if (!shouldFocus) {
      return;
    }

    var ref = switchRefs[selectedIndex];

    if (ref && document.activeElement !== ref) {
      ref.focus && ref.focus();
    }
  }, [shouldFocus, switchRefs, selectedIndex]);

  function handleItemRef(index) {
    return function (ref) {
      switchRefs[index] = ref;
    };
  }

  function onClick(event, index) {
    if (selectedIndex !== index) {
      setSelectedIndex(index);

      if (shouldFocus !== true) {
        setShouldFocus(true);
      }
    }
  }

  function onKeyDown(event) {
    if ((0, _keyboard.matches)(event, [_keyboard.keys.ArrowRight, _keyboard.keys.ArrowLeft])) {
      setSelectedIndex((0, _keyboard.getNextIndex)(event, selectedIndex, children.length));

      if (shouldFocus !== true) {
        setShouldFocus(true);
      }
    }
  }

  return _react.default.createElement("div", _extends({
    className: className
  }, rest), _react.Children.map(children, function (child, index) {
    return (0, _react.cloneElement)(child, {
      index: index,
      onClick: (0, _events.composeEventHandlers)([onClick, child.props.onClick]),
      onKeyDown: (0, _events.composeEventHandlers)([onKeyDown, child.props.onKeyDown]),
      selected: index === selectedIndex,
      ref: handleItemRef(index)
    });
  }));
}

ContentSwitcher.propTypes = {
  /**
   * Pass in Switch components to be rendered in the ContentSwitcher
   */
  children: _propTypes.default.node,

  /**
   * Specify an optional className to be added to the container node
   */
  className: _propTypes.default.string,

  /**
   * Specify an `onChange` handler that is called whenever the ContentSwitcher
   * changes which item is selected
   */
  onChange: _propTypes.default.func.isRequired,

  /**
   * Specify a selected index for the initially selected content
   */
  selectedIndex: _propTypes.default.number
};
var _default = ContentSwitcher;
exports.default = _default;