"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _carbonComponents = require("carbon-components");

var _OverflowMenu = _interopRequireDefault(require("../OverflowMenu"));

var _iconsReact = require("@carbon/icons-react");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var prefix = _carbonComponents.settings.prefix;

var TableToolbarMenu = function TableToolbarMenu(_ref) {
  var className = _ref.className,
      renderIcon = _ref.renderIcon,
      iconDescription = _ref.iconDescription,
      children = _ref.children,
      rest = _objectWithoutProperties(_ref, ["className", "renderIcon", "iconDescription", "children"]);

  var toolbarActionClasses = (0, _classnames.default)(className, "".concat(prefix, "--toolbar-action ").concat(prefix, "--overflow-menu"));
  return _react.default.createElement(_OverflowMenu.default, _extends({
    renderIcon: renderIcon,
    className: toolbarActionClasses,
    title: iconDescription,
    flipped: true
  }, rest), children);
};

TableToolbarMenu.defaultProps = {
  renderIcon: _iconsReact.Settings16,
  iconDescription: 'Settings'
};
TableToolbarMenu.propTypes = {
  children: _propTypes.default.node.isRequired,

  /**
   * Provide an optional class name for the toolbar menu
   */
  className: _propTypes.default.string,

  /**
   * Optional prop to allow overriding the default menu icon
   */
  renderIcon: _propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.object]),

  /**
   * The description of the menu icon.
   */
  iconDescription: _propTypes.default.string.isRequired
};
var _default = TableToolbarMenu;
exports.default = _default;