"use strict";

var _react = _interopRequireDefault(require("react"));

var _react2 = require("@storybook/react");

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _Pagination = _interopRequireDefault(require("../Pagination"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var props = function props() {
  return {
    disabled: (0, _addonKnobs.boolean)('Disable backward/forward buttons (disabled)', false),
    page: (0, _addonKnobs.number)('The current page (page)', 1),
    totalItems: (0, _addonKnobs.number)('Total number of items (totalItems)', 103),
    pagesUnknown: (0, _addonKnobs.boolean)('Total number of items unknown (pagesUnknown)', false),
    pageInputDisabled: (0, _addonKnobs.boolean)('Disable page input (pageInputDisabled)', false),
    backwardText: (0, _addonKnobs.text)('The description for the backward icon (backwardText)', 'Previous page'),
    forwardText: (0, _addonKnobs.text)('The description for the backward icon (forwardText)', 'Next page'),
    pageSize: (0, _addonKnobs.number)('Number of items per page (pageSize)', 10),
    pageSizes: (0, _addonKnobs.array)('Choices of `pageSize` (pageSizes)', [10, 20, 30, 40, 50]),
    itemsPerPageText: (0, _addonKnobs.text)('Label for `pageSizes` select UI (itemsPerPageText)', 'Items per page:'),
    onChange: (0, _addonActions.action)('onChange')
  };
};

(0, _react2.storiesOf)('Pagination', module).addDecorator(_addonKnobs.withKnobs).addDecorator(function (story) {
  return _react.default.createElement("div", {
    style: {
      width: '800px'
    }
  }, story());
}).add('Pagination', function () {
  return _react.default.createElement(_Pagination.default, props());
}, {
  info: {
    text: "\n            The pagination component is used to switch through multiple pages of items, when only a maxium number of items can be displayed per page. Can be used in combination with other components like DataTable.\n          "
  }
}).add('↪︎ multiple Pagination components', function () {
  return _react.default.createElement("div", null, _react.default.createElement(_Pagination.default, props()), _react.default.createElement(_Pagination.default, props()));
}, {
  info: {
    text: "Showcasing unique ids for each pagination component"
  }
});