(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('classnames'), require('prop-types'), require('react'), require('react-dom'), require('carbon-icons')) :
  typeof define === 'function' && define.amd ? define(['exports', 'classnames', 'prop-types', 'react', 'react-dom', 'carbon-icons'], factory) :
  (global = global || self, factory(global.CarbonComponentsReact = {}, global.classNames, global.PropTypes, global.React, global.ReactDOM, global.CarbonIcons));
}(this, function (exports, classNames, PropTypes, React, ReactDOM, icons) { 'use strict';

  classNames = classNames && classNames.hasOwnProperty('default') ? classNames['default'] : classNames;
  var PropTypes__default = 'default' in PropTypes ? PropTypes['default'] : PropTypes;
  var React__default = 'default' in React ? React['default'] : React;
  ReactDOM = ReactDOM && ReactDOM.hasOwnProperty('default') ? ReactDOM['default'] : ReactDOM;
  icons = icons && icons.hasOwnProperty('default') ? icons['default'] : icons;

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function (obj) {
        return typeof obj;
      };
    } else {
      _typeof = function (obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties(Constructor, staticProps);
    return Constructor;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    };

    return _extends.apply(this, arguments);
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);

    if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);
      if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });
      keys.push.apply(keys, symbols);
    }

    return keys;
  }

  function _objectSpread2(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};

      if (i % 2) {
        ownKeys(source, true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(source).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }

    return target;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf(o);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf(o, p);
  }

  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i;

    for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      target[key] = source[key];
    }

    return target;
  }

  function _objectWithoutProperties(source, excluded) {
    if (source == null) return {};

    var target = _objectWithoutPropertiesLoose(source, excluded);

    var key, i;

    if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

      for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];
        if (excluded.indexOf(key) >= 0) continue;
        if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
        target[key] = source[key];
      }
    }

    return target;
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (typeof call === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized(self);
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) arr2[i] = arr[i];

      return arr2;
    }
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _iterableToArrayLimit(arr, i) {
    var _arr = [];
    var _n = true;
    var _d = false;
    var _e = undefined;

    try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);

        if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;
      _e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }

    return _arr;
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */

  /**
   * Settings.
   * @exports CarbonComponents.settings
   * @type Object
   * @property {boolean} [disableAutoInit]
   *   Disables automatic instantiation of components.
   *   By default (`CarbonComponents.disableAutoInit` is `false`),
   *   carbon-components attempts to instantiate components automatically
   *   by searching for elements with `data-component-name` (e.g. `data-loading`) attribute
   *   or upon DOM events (e.g. clicking) on such elements.
   *   See each components' static `.init()` methods for details.
   * @property {string} [prefix=bx]
   *   Brand prefix. Should be in sync with `$prefix` Sass variable in carbon-components/src/globals/scss/_vars.scss.
   * // @todo given that the default value is so long, is it appropriate to put in the JSDoc?
   * @property {string} [selectorTabbable]
   *   A selector selecting tabbable/focusable nodes.
   *   By default selectorTabbable refereneces links, areas, inputs, buttons, selects, textareas,
   *   iframes, objects, embeds, or elements explicitly using tabindex or contenteditable attributes
   *   as long as the element is not `disabled` or the `tabindex="-1"`.
   */
  var settings = {
    prefix: 'bx',
    selectorTabbable: "\n    a[href], area[href], input:not([disabled]):not([tabindex='-1']),\n    button:not([disabled]):not([tabindex='-1']),select:not([disabled]):not([tabindex='-1']),\n    textarea:not([disabled]):not([tabindex='-1']),\n    iframe, object, embed, *[tabindex]:not([tabindex='-1']), *[contenteditable=true]\n  "
  };
  var settings_1 = settings;

  function _classCallCheck$1(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _toConsumableArray$1(arr) {
    return _arrayWithoutHoles$1(arr) || _iterableToArray$1(arr) || _nonIterableSpread$1();
  }

  function _nonIterableSpread$1() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray$1(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles$1(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }

      return arr2;
    }
  }
  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */

  /**
   * @param {Array} a An array.
   * @returns {Array} The flattened version of the given array.
   */


  function flatten(a) {
    return a.reduce(function (result, item) {
      if (Array.isArray(item)) {
        result.push.apply(result, _toConsumableArray$1(flatten(item)));
      } else {
        result.push(item);
      }

      return result;
    }, []);
  }
  /**
   * An interface for defining mix-in classes. Used with {@link mixin}.
   * @function mixinfn
   * @param {Class} ToMix The class to mix.
   * @returns {Class} The class mixed-in with the given ToMix class.
   */

  /**
   * @function mixin
   * @param {...mixinfn} mixinfns The functions generating mix-ins.
   * @returns {Class} The class generated with the given mix-ins.
   */


  function mixin() {
    for (var _len = arguments.length, mixinfns = new Array(_len), _key = 0; _key < _len; _key++) {
      mixinfns[_key] = arguments[_key];
    }

    return flatten(mixinfns).reduce(function (Class, mixinfn) {
      return mixinfn(Class);
    },
    /*#__PURE__*/
    function () {
      function _class() {
        _classCallCheck$1(this, _class);
      }

      return _class;
    }());
  }

  function _typeof$1(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof$1 = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof$1 = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof$1(obj);
  }

  function _classCallCheck$2(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$1(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$1(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$1(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$1(Constructor, staticProps);
    return Constructor;
  }

  function _possibleConstructorReturn$1(self, call) {
    if (call && (_typeof$1(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized$1(self);
  }

  function _getPrototypeOf$1(o) {
    _getPrototypeOf$1 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf$1(o);
  }

  function _assertThisInitialized$1(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _inherits$1(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf$1(subClass, superClass);
  }

  function _setPrototypeOf$1(o, p) {
    _setPrototypeOf$1 = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf$1(o, p);
  }
  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */


  function createComponent (ToMix) {
    var CreateComponent =
    /*#__PURE__*/
    function (_ToMix) {
      _inherits$1(CreateComponent, _ToMix);
      /**
       * The component instances managed by this component.
       * Releasing this component also releases the components in `this.children`.
       * @type {Component[]}
       */

      /**
       * Mix-in class to manage lifecycle of component.
       * The constructor sets up this component's effective options,
       * and registers this component't instance associated to an element.
       * @implements Handle
       * @param {HTMLElement} element The element working as this component.
       * @param {object} [options] The component options.
       */


      function CreateComponent(element) {
        var _this;

        var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

        _classCallCheck$2(this, CreateComponent);

        _this = _possibleConstructorReturn$1(this, _getPrototypeOf$1(CreateComponent).call(this, element, options));
        _this.children = [];

        if (!element || element.nodeType !== Node.ELEMENT_NODE) {
          throw new TypeError('DOM element should be given to initialize this widget.');
        }
        /**
         * The element the component is of.
         * @type {Element}
         */


        _this.element = element;
        /**
         * The component options.
         * @type {Object}
         */

        _this.options = Object.assign(Object.create(_this.constructor.options), options);

        _this.constructor.components.set(_this.element, _assertThisInitialized$1(_this));

        return _this;
      }
      /**
       * Instantiates this component of the given element.
       * @param {HTMLElement} element The element.
       */


      _createClass$1(CreateComponent, [{
        key: "release",

        /**
         * Releases this component's instance from the associated element.
         */
        value: function release() {
          for (var child = this.children.pop(); child; child = this.children.pop()) {
            child.release();
          }

          this.constructor.components.delete(this.element);
          return null;
        }
      }], [{
        key: "create",
        value: function create(element, options) {
          return this.components.get(element) || new this(element, options);
        }
      }]);

      return CreateComponent;
    }(ToMix);

    return CreateComponent;
  }

  function _typeof$2(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof$2 = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof$2 = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof$2(obj);
  }

  function _classCallCheck$3(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$2(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$2(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$2(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$2(Constructor, staticProps);
    return Constructor;
  }

  function _possibleConstructorReturn$2(self, call) {
    if (call && (_typeof$2(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized$2(self);
  }

  function _assertThisInitialized$2(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _getPrototypeOf$2(o) {
    _getPrototypeOf$2 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf$2(o);
  }

  function _inherits$2(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf$2(subClass, superClass);
  }

  function _setPrototypeOf$2(o, p) {
    _setPrototypeOf$2 = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf$2(o, p);
  }
  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */


  function initComponentBySearch (ToMix) {
    /**
     * Mix-in class to instantiate components by searching for their root elements.
     * @class InitComponentBySearch
     */
    var InitComponentBySearch =
    /*#__PURE__*/
    function (_ToMix) {
      _inherits$2(InitComponentBySearch, _ToMix);

      function InitComponentBySearch() {
        _classCallCheck$3(this, InitComponentBySearch);

        return _possibleConstructorReturn$2(this, _getPrototypeOf$2(InitComponentBySearch).apply(this, arguments));
      }

      _createClass$2(InitComponentBySearch, null, [{
        key: "init",

        /**
         * Instantiates component in the given node.
         * If the given element indicates that it's an component of this class, instantiates it.
         * Otherwise, instantiates components by searching for components in the given node.
         * @param {Node} target The DOM node to instantiate components in. Should be a document or an element.
         * @param {object} [options] The component options.
         * @param {boolean} [options.selectorInit] The CSS selector to find components.
         */
        value: function init() {
          var _this = this;

          var target = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : document;
          var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
          var effectiveOptions = Object.assign(Object.create(this.options), options);

          if (!target || target.nodeType !== Node.ELEMENT_NODE && target.nodeType !== Node.DOCUMENT_NODE) {
            throw new TypeError('DOM document or DOM element should be given to search for and initialize this widget.');
          }

          if (target.nodeType === Node.ELEMENT_NODE && target.matches(effectiveOptions.selectorInit)) {
            this.create(target, options);
          } else {
            Array.prototype.forEach.call(target.querySelectorAll(effectiveOptions.selectorInit), function (element) {
              return _this.create(element, options);
            });
          }
        }
      }]);

      return InitComponentBySearch;
    }(ToMix);

    return InitComponentBySearch;
  }

  function _typeof$3(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof$3 = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof$3 = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof$3(obj);
  }

  function _classCallCheck$4(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$3(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$3(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$3(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$3(Constructor, staticProps);
    return Constructor;
  }

  function _possibleConstructorReturn$3(self, call) {
    if (call && (_typeof$3(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized$3(self);
  }

  function _assertThisInitialized$3(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _get(target, property, receiver) {
    if (typeof Reflect !== "undefined" && Reflect.get) {
      _get = Reflect.get;
    } else {
      _get = function _get(target, property, receiver) {
        var base = _superPropBase(target, property);

        if (!base) return;
        var desc = Object.getOwnPropertyDescriptor(base, property);

        if (desc.get) {
          return desc.get.call(receiver);
        }

        return desc.value;
      };
    }

    return _get(target, property, receiver || target);
  }

  function _superPropBase(object, property) {
    while (!Object.prototype.hasOwnProperty.call(object, property)) {
      object = _getPrototypeOf$3(object);
      if (object === null) break;
    }

    return object;
  }

  function _getPrototypeOf$3(o) {
    _getPrototypeOf$3 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf$3(o);
  }

  function _inherits$3(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf$3(subClass, superClass);
  }

  function _setPrototypeOf$3(o, p) {
    _setPrototypeOf$3 = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf$3(o, p);
  }
  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */


  function handles (ToMix) {
    /**
     * Mix-in class to manage handles in component.
     * Managed handles are automatically released when the component with this class mixed in is released.
     * @class Handles
     * @implements Handle
     */
    var Handles =
    /*#__PURE__*/
    function (_ToMix) {
      _inherits$3(Handles, _ToMix);

      function Handles() {
        var _getPrototypeOf2;

        var _this;

        _classCallCheck$4(this, Handles);

        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
          args[_key] = arguments[_key];
        }

        _this = _possibleConstructorReturn$3(this, (_getPrototypeOf2 = _getPrototypeOf$3(Handles)).call.apply(_getPrototypeOf2, [this].concat(args)));
        _this.handles = new Set();
        return _this;
      }

      _createClass$3(Handles, [{
        key: "manage",

        /**
         * Manages the given handle.
         * @param {Handle} handle The handle to manage.
         * @returns {Handle} The given handle.
         */
        value: function manage(handle) {
          this.handles.add(handle);
          return handle;
        }
        /**
         * Stop managing the given handle.
         * @param {Handle} handle The handle to stop managing.
         * @returns {Handle} The given handle.
         */

      }, {
        key: "unmanage",
        value: function unmanage(handle) {
          this.handles.delete(handle);
          return handle;
        }
      }, {
        key: "release",
        value: function release() {
          var _this2 = this;

          this.handles.forEach(function (handle) {
            handle.release();

            _this2.handles.delete(handle);
          });
          return _get(_getPrototypeOf$3(Handles.prototype), "release", this).call(this);
        }
      }]);

      return Handles;
    }(ToMix);

    return Handles;
  }

  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */
  function on(element) {
    for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args[_key - 1] = arguments[_key];
    }

    element.addEventListener.apply(element, args);
    return {
      release: function release() {
        element.removeEventListener.apply(element, args);
        return null;
      }
    };
  }

  function _typeof$4(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof$4 = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof$4 = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof$4(obj);
  }

  function _classCallCheck$5(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$4(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$4(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$4(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$4(Constructor, staticProps);
    return Constructor;
  }

  function _possibleConstructorReturn$4(self, call) {
    if (call && (_typeof$4(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized$4(self);
  }

  function _assertThisInitialized$4(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _getPrototypeOf$4(o) {
    _getPrototypeOf$4 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf$4(o);
  }

  function _inherits$4(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf$4(subClass, superClass);
  }

  function _setPrototypeOf$4(o, p) {
    _setPrototypeOf$4 = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf$4(o, p);
  }
  var stateChangeTypes = {
    true: 'true',
    false: 'false',
    mixed: 'mixed'
  };

  var Checkbox =
  /*#__PURE__*/
  function (_mixin) {
    _inherits$4(Checkbox, _mixin);
    /**
     * Checkbox UI.
     * @extends CreateComponent
     * @extends InitComponentBySearch
     * @extends Handles
     * @param {HTMLElement} element The element working as a checkbox UI.
     */


    function Checkbox(element, options) {
      var _this;

      _classCallCheck$5(this, Checkbox);

      _this = _possibleConstructorReturn$4(this, _getPrototypeOf$4(Checkbox).call(this, element, options));

      _this.manage(on(_this.element, 'click', function (event) {
        _this._handleClick(event);
      }));

      _this.manage(on(_this.element, 'focus', function (event) {
        _this._handleFocus(event);
      }));

      _this.manage(on(_this.element, 'blur', function (event) {
        _this._handleBlur(event);
      }));

      _this._indeterminateCheckbox();

      _this._initCheckbox();

      return _this;
    }

    _createClass$4(Checkbox, [{
      key: "_handleClick",
      value: function _handleClick() {
        if (this.element.checked === true) {
          this.element.setAttribute('checked', '');
          this.element.setAttribute('aria-checked', 'true');
          this.element.checked = true; // nested checkboxes inside labels

          if (this.element.parentElement.classList.contains(this.options.classLabel)) {
            this.element.parentElement.setAttribute(this.options.attribContainedCheckboxState, 'true');
          }
        } else if (this.element.checked === false) {
          this.element.removeAttribute('checked');
          this.element.setAttribute('aria-checked', 'false');
          this.element.checked = false; // nested checkboxes inside labels

          if (this.element.parentElement.classList.contains(this.options.classLabel)) {
            this.element.parentElement.setAttribute(this.options.attribContainedCheckboxState, 'false');
          }
        }
      }
    }, {
      key: "_handleFocus",
      value: function _handleFocus() {
        if (this.element.parentElement.classList.contains(this.options.classLabel)) {
          this.element.parentElement.classList.add(this.options.classLabelFocused);
        }
      }
    }, {
      key: "_handleBlur",
      value: function _handleBlur() {
        if (this.element.parentElement.classList.contains(this.options.classLabel)) {
          this.element.parentElement.classList.remove(this.options.classLabelFocused);
        }
      }
      /**
       * Sets the new checkbox state.
       * @param {boolean|string} [state]
       *   The new checkbox state to set. `mixed` to put checkbox in indeterminate state.
       *   If omitted, this method simply makes the style reflect `aria-checked` attribute.
       */

    }, {
      key: "setState",
      value: function setState(state) {
        if (state === undefined || stateChangeTypes[state] === undefined) {
          throw new TypeError('setState expects a value of true, false or mixed.');
        }

        this.element.setAttribute('aria-checked', state);
        this.element.indeterminate = state === stateChangeTypes.mixed;
        this.element.checked = state === stateChangeTypes.true;
        var container = this.element.closest(this.options.selectorContainedCheckboxState);

        if (container) {
          container.setAttribute(this.options.attribContainedCheckboxState, state);
        }
      }
    }, {
      key: "setDisabled",
      value: function setDisabled(value) {
        if (value === undefined) {
          throw new TypeError('setDisabled expects a boolean value of true or false');
        }

        if (value === true) {
          this.element.setAttribute('disabled', true);
        } else if (value === false) {
          this.element.removeAttribute('disabled');
        }

        var container = this.element.closest(this.options.selectorContainedCheckboxDisabled);

        if (container) {
          container.setAttribute(this.options.attribContainedCheckboxDisabled, value);
        }
      }
    }, {
      key: "_indeterminateCheckbox",
      value: function _indeterminateCheckbox() {
        if (this.element.getAttribute('aria-checked') === 'mixed') {
          this.element.indeterminate = true;
        }

        if (this.element.indeterminate === true) {
          this.element.setAttribute('aria-checked', 'mixed');
        }

        if (this.element.parentElement.classList.contains(this.options.classLabel) && this.element.indeterminate === true) {
          this.element.parentElement.setAttribute(this.options.attribContainedCheckboxState, 'mixed');
        }
      }
    }, {
      key: "_initCheckbox",
      value: function _initCheckbox() {
        if (this.element.checked === true) {
          this.element.setAttribute('aria-checked', 'true');
        }

        if (this.element.parentElement.classList.contains(this.options.classLabel) && this.element.checked) {
          this.element.parentElement.setAttribute(this.options.attribContainedCheckboxState, 'true');
        }

        if (this.element.parentElement.classList.contains(this.options.classLabel)) {
          this.element.parentElement.setAttribute(this.options.attribContainedCheckboxDisabled, 'false');
        }

        if (this.element.parentElement.classList.contains(this.options.classLabel) && this.element.disabled) {
          this.element.parentElement.setAttribute(this.options.attribContainedCheckboxDisabled, 'true');
        }
      }
      /**
       * The map associating DOM element and copy button UI instance.
       * @member Checkbox.components
       * @type {WeakMap}
       */

    }], [{
      key: "options",

      /**
       * The component options.
       * If `options` is specified in the constructor, {@linkcode Checkbox.create .create()}, or {@linkcode Checkbox.init .init()},
       * properties in this object are overriden for the instance being create and how {@linkcode Checkbox.init .init()} works.
       * @member Checkbox.options
       * @type {object}
       * @property {string} selectorInit The data attribute to find copy button UIs.
       * @property {string} selectorContainedCheckboxState The CSS selector to find a container of checkbox preserving checked state.
       * @property {string} selectorContainedCheckboxDisabled
       *   The CSS selector to find a container of checkbox preserving disabled state.
       * @property {string} classLabel The CSS class for the label.
       * @property {string} classLabelFocused The CSS class for the focused label.
       * @property {string} attribContainedCheckboxState The attribute name for the checked state of contained checkbox.
       * @property {string} attribContainedCheckboxDisabled The attribute name for the disabled state of contained checkbox.
       */
      get: function get() {
        var prefix = settings_1.prefix;
        return {
          selectorInit: ".".concat(prefix, "--checkbox"),
          selectorContainedCheckboxState: '[data-contained-checkbox-state]',
          selectorContainedCheckboxDisabled: '[data-contained-checkbox-disabled]',
          classLabel: "".concat(prefix, "--checkbox-label"),
          classLabelFocused: "".concat(prefix, "--checkbox-label__focus"),
          attribContainedCheckboxState: 'data-contained-checkbox-state',
          attribContainedCheckboxDisabled: 'data-contained-checkbox-disabled'
        };
      }
    }]);

    Checkbox.components = new WeakMap();
    Checkbox.stateChangeTypes = stateChangeTypes;
    return Checkbox;
  }(mixin(createComponent, initComponentBySearch, handles));

  function _typeof$5(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof$5 = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof$5 = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof$5(obj);
  }

  function _toConsumableArray$2(arr) {
    return _arrayWithoutHoles$2(arr) || _iterableToArray$2(arr) || _nonIterableSpread$2();
  }

  function _nonIterableSpread$2() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray$2(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles$2(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }

      return arr2;
    }
  }

  function _classCallCheck$6(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$5(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$5(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$5(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$5(Constructor, staticProps);
    return Constructor;
  }

  function _possibleConstructorReturn$5(self, call) {
    if (call && (_typeof$5(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized$5(self);
  }

  function _assertThisInitialized$5(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _getPrototypeOf$5(o) {
    _getPrototypeOf$5 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf$5(o);
  }

  function _inherits$5(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf$5(subClass, superClass);
  }

  function _setPrototypeOf$5(o, p) {
    _setPrototypeOf$5 = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf$5(o, p);
  }
  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */


  function eventedState (ToMix) {
    /**
     * Mix-in class to manage events associated with states.
     * @class EventedState
     */
    var EventedState =
    /*#__PURE__*/
    function (_ToMix) {
      _inherits$5(EventedState, _ToMix);

      function EventedState() {
        _classCallCheck$6(this, EventedState);

        return _possibleConstructorReturn$5(this, _getPrototypeOf$5(EventedState).apply(this, arguments));
      }

      _createClass$5(EventedState, [{
        key: "_changeState",

        /* eslint-disable jsdoc/check-param-names */

        /**
         * The internal implementation for {@link EventedState#changeState `.changeState()`}, performing actual change in state.
         * @param {string} [state] The new state. Can be an omitted, which means toggling.
         * @param {object} [detail]
         *   The object that should be put to event details that is fired before/after changing state.
         *   Can have a `group` property, which specifies what state to be changed.
         * @param {EventedState~changeStateCallback} callback The callback called once changing state is finished or is canceled.
         * @private
         */
        value: function _changeState() {
          throw new Error('_changeState() should be overriden to perform actual change in state.');
        }
        /**
         * Changes the state of this component.
         * @param {string} [state] The new state. Can be an omitted, which means toggling.
         * @param {object} [detail]
         *   The object that should be put to event details that is fired before/after changing state.
         *   Can have a `group` property, which specifies what state to be changed.
         * @param {EventedState~changeStateCallback} [callback] The callback called once changing state is finished or is canceled.
         */

      }, {
        key: "changeState",
        value: function changeState() {
          var _this = this;

          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }

          var state = typeof args[0] === 'string' ? args.shift() : undefined;
          var detail = Object(args[0]) === args[0] && typeof args[0] !== 'function' ? args.shift() : undefined;
          var callback = typeof args[0] === 'function' ? args.shift() : undefined;

          if (typeof this.shouldStateBeChanged === 'function' && !this.shouldStateBeChanged(state, detail)) {
            if (callback) {
              callback(null, true);
            }

            return;
          }

          var data = {
            group: detail && detail.group,
            state: state
          };
          var eventNameSuffix = [data.group, state].filter(Boolean).join('-').split('-') // Group or state may contain hyphen
          .map(function (item) {
            return item[0].toUpperCase() + item.substr(1);
          }).join('');
          var eventStart = new CustomEvent(this.options["eventBefore".concat(eventNameSuffix)], {
            bubbles: true,
            cancelable: true,
            detail: detail
          });
          var fireOnNode = detail && detail.delegatorNode || this.element;
          var canceled = !fireOnNode.dispatchEvent(eventStart);

          if (canceled) {
            if (callback) {
              var error = new Error("Changing state (".concat(JSON.stringify(data), ") has been canceled."));
              error.canceled = true;
              callback(error);
            }
          } else {
            var changeStateArgs = [state, detail].filter(Boolean);

            this._changeState.apply(this, _toConsumableArray$2(changeStateArgs).concat([function () {
              fireOnNode.dispatchEvent(new CustomEvent(_this.options["eventAfter".concat(eventNameSuffix)], {
                bubbles: true,
                cancelable: true,
                detail: detail
              }));

              if (callback) {
                callback();
              }
            }]));
          }
        }
        /* eslint-enable jsdoc/check-param-names */

        /**
         * Tests if change in state should happen or not.
         * Classes inheriting {@link EventedState `EventedState`} should override this function.
         * @function EventedState#shouldStateBeChanged
         * @param {string} [state] The new state. Can be an omitted, which means toggling.
         * @param {Object} [detail]
         *   The object that should be put to event details that is fired before/after changing state.
         *   Can have a `group` property, which specifies what state to be changed.
         * @returns {boolean}
         *   `false` if change in state shouldn't happen, e.g. when the given new state is the same as the current one.
         */

      }]);

      return EventedState;
    }(ToMix);
    /**
     * The callback called once changing state is finished or is canceled.
     * @callback EventedState~changeStateCallback
     * @param {Error} error
     *   An error object with `true` in its `canceled` property if changing state is canceled.
     *   Cancellation happens if the handler of a custom event, that is fired before changing state happens,
     *   calls `.preventDefault()` against the event.
     * @param {boolean} keptState
     *   `true` if the call to {@link EventedState#changeState `.changeState()`} didn't cause actual change in state.
     */


    return EventedState;
  }

  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */

  /**
   * @param {Event} event The event.
   * @param {string} selector The selector.
   * @returns {Element}
   *   The closest ancestor of the event target (or the event target itself) which matches the selectors given in parameter.
   */
  function eventMatches(event, selector) {
    // <svg> in IE does not have `Element#msMatchesSelector()` (that should be copied to `Element#matches()` by a polyfill).
    // Also a weird behavior is seen in IE where DOM tree seems broken when `event.target` is on <svg>.
    // Therefore this function simply returns `undefined` when `event.target` is on <svg>.
    var target = event.target,
        currentTarget = event.currentTarget;

    if (typeof target.matches === 'function') {
      if (target.matches(selector)) {
        // If event target itself matches the given selector, return it
        return target;
      }

      if (target.matches("".concat(selector, " *"))) {
        var closest = target.closest(selector);

        if ((currentTarget.nodeType === Node.DOCUMENT_NODE ? currentTarget.documentElement : currentTarget).contains(closest)) {
          return closest;
        }
      }
    }

    return undefined;
  }

  function _typeof$6(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof$6 = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof$6 = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof$6(obj);
  }

  function _classCallCheck$7(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$6(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$6(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$6(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$6(Constructor, staticProps);
    return Constructor;
  }

  function _possibleConstructorReturn$6(self, call) {
    if (call && (_typeof$6(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized$6(self);
  }

  function _assertThisInitialized$6(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _getPrototypeOf$6(o) {
    _getPrototypeOf$6 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf$6(o);
  }

  function _inherits$6(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf$6(subClass, superClass);
  }

  function _setPrototypeOf$6(o, p) {
    _setPrototypeOf$6 = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf$6(o, p);
  }

  var toArray = function toArray(arrayLike) {
    return Array.prototype.slice.call(arrayLike);
  };

  var FileUploader =
  /*#__PURE__*/
  function (_mixin) {
    _inherits$6(FileUploader, _mixin);
    /**
     * File uploader.
     * @extends CreateComponent
     * @extends InitComponentBySearch
     * @extends eventedState
     * @extends Handles
     * @param {HTMLElement} element The element working as a file uploader.
     * @param {object} [options] The component options. See static options.
     */


    function FileUploader(element) {
      var _this;

      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      _classCallCheck$7(this, FileUploader);

      _this = _possibleConstructorReturn$6(this, _getPrototypeOf$6(FileUploader).call(this, element, options));

      _this._changeState = function (state, detail, callback) {
        if (state === 'delete-filename-fileuploader') {
          _this.container.removeChild(detail.filenameElement);
        }

        if (typeof callback === 'function') {
          callback();
        }
      };

      _this._handleDeleteButton = function (evt) {
        var target = eventMatches(evt, "[data-for=".concat(_this.inputId, "]"));

        if (target) {
          _this._changeState('delete-filename-fileuploader', {
            initialEvt: evt,
            filenameElement: target.parentNode
          });
        }
      };

      _this.input = _this.element.querySelector(_this.options.selectorInput);
      _this.container = _this.element.querySelector(_this.options.selectorContainer);

      if (!_this.input) {
        throw new TypeError('Cannot find the file input box.');
      }

      if (!_this.container) {
        throw new TypeError('Cannot find the file names container.');
      }

      _this.inputId = _this.input.getAttribute('id');

      _this.manage(on(_this.input, 'change', function () {
        return _this._displayFilenames();
      }));

      _this.manage(on(_this.container, 'click', _this._handleDeleteButton));

      return _this;
    }

    _createClass$6(FileUploader, [{
      key: "_filenamesHTML",
      value: function _filenamesHTML(name, id) {
        return "<span class=\"".concat(this.options.classSelectedFile, "\">\n      <p class=\"").concat(this.options.classFileName, "\">").concat(name, "</p>\n      <span data-for=\"").concat(id, "\" class=\"").concat(this.options.classStateContainer, "\"></span>\n    </span>");
      }
    }, {
      key: "_uploadHTML",
      value: function _uploadHTML() {
        return "\n      <div data-loading class=\"".concat(this.options.classLoading, "\">\n        <svg class=\"").concat(this.options.classLoadingSvg, "\" viewBox=\"-42 -42 84 84\">\n          <circle cx=\"0\" cy=\"0\" r=\"37.5\" />\n        </svg>\n      </div>");
      }
    }, {
      key: "_closeButtonHTML",
      value: function _closeButtonHTML() {
        return "\n      <button class=\"".concat(this.options.classFileClose, "\" type=\"button\" aria-label=\"close\">\n      <svg aria-hidden=\"true\" viewBox=\"0 0 16 16\" width=\"16\" height=\"16\">\n      <path fill=\"#231F20\" d=\"M12 4.7l-.7-.7L8 7.3 4.7 4l-.7.7L7.3 8 4 11.3l.7.7L8 8.7l3.3 3.3.7-.7L8.7 8z\"/>\n      </svg>\n      </button>");
      }
    }, {
      key: "_checkmarkHTML",
      value: function _checkmarkHTML() {
        return "\n      <svg class=\"".concat(this.options.classFileComplete, "\" viewBox=\"0 0 16 16\" fill-rule=\"evenodd\" width=\"16\" height=\"16\">\n       <path d=\"M8 0C3.6 0 0 3.6 0 8s3.6 8 8 8 8-3.6 8-8-3.6-8-8-8zM6.7 11.5L3.4 8.1l1.4-1.4 1.9 1.9 4.1-4.1 1.4 1.4-5.5 5.6z\"/>\n      </svg>");
      }
    }, {
      key: "_getStateContainers",
      value: function _getStateContainers() {
        var stateContainers = toArray(this.element.querySelectorAll("[data-for=".concat(this.inputId, "]")));

        if (stateContainers.length === 0) {
          throw new TypeError('State container elements not found; invoke _displayFilenames() first');
        }

        if (stateContainers[0].dataset.for !== this.inputId) {
          throw new TypeError('File input id must equal [data-for] attribute');
        }

        return stateContainers;
      }
      /**
       * Inject selected files into DOM. Invoked on change event.
       */

    }, {
      key: "_displayFilenames",
      value: function _displayFilenames() {
        var _this2 = this;

        var container = this.element.querySelector(this.options.selectorContainer);
        var HTMLString = toArray(this.input.files).map(function (file) {
          return _this2._filenamesHTML(file.name, _this2.inputId);
        }).join('');
        container.insertAdjacentHTML('afterbegin', HTMLString);
      }
    }, {
      key: "_removeState",
      value: function _removeState(element) {
        if (!element || element.nodeType !== Node.ELEMENT_NODE) {
          throw new TypeError('DOM element should be given to initialize this widget.');
        }

        while (element.firstChild) {
          element.removeChild(element.firstChild);
        }
      }
    }, {
      key: "_handleStateChange",
      value: function _handleStateChange(elements, selectIndex, html) {
        var _this3 = this;

        if (selectIndex === undefined) {
          elements.forEach(function (el) {
            _this3._removeState(el);

            el.insertAdjacentHTML('beforeend', html);
          });
        } else {
          elements.forEach(function (el, index) {
            if (index === selectIndex) {
              _this3._removeState(el);

              el.insertAdjacentHTML('beforeend', html);
            }
          });
        }
      }
      /**
       * Handles delete button.
       * @param {Event} evt The event triggering this action.
       * @private
       */

    }, {
      key: "setState",
      value: function setState(state, selectIndex) {
        var stateContainers = this._getStateContainers();

        if (state === 'edit') {
          this._handleStateChange(stateContainers, selectIndex, this._closeButtonHTML());
        }

        if (state === 'upload') {
          this._handleStateChange(stateContainers, selectIndex, this._uploadHTML());
        }

        if (state === 'complete') {
          this._handleStateChange(stateContainers, selectIndex, this._checkmarkHTML());
        }
      }
      /**
       * The map associating DOM element and file uploader instance.
       * @member FileUploader.components
       * @type {WeakMap}
       */

    }], [{
      key: "options",
      get: function get() {
        var prefix = settings_1.prefix;
        return {
          selectorInit: '[data-file]',
          selectorInput: "input[type=\"file\"].".concat(prefix, "--file-input"),
          selectorContainer: '[data-file-container]',
          selectorCloseButton: ".".concat(prefix, "--file-close"),
          classLoading: "".concat(prefix, "--loading"),
          classLoadingSvg: "".concat(prefix, "--loading__svg"),
          classFileName: "".concat(prefix, "--file-filename"),
          classFileClose: "".concat(prefix, "--file-close"),
          classFileComplete: "".concat(prefix, "--file-complete"),
          classSelectedFile: "".concat(prefix, "--file__selected-file"),
          classStateContainer: "".concat(prefix, "--file__state-container"),
          eventBeforeDeleteFilenameFileuploader: 'fileuploader-before-delete-filename',
          eventAfterDeleteFilenameFileuploader: 'fileuploader-after-delete-filename'
        };
      }
    }]);

    FileUploader.components = new WeakMap();
    return FileUploader;
  }(mixin(createComponent, initComponentBySearch, eventedState, handles));

  function _typeof$7(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof$7 = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof$7 = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof$7(obj);
  }

  function _classCallCheck$8(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$7(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$7(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$7(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$7(Constructor, staticProps);
    return Constructor;
  }

  function _possibleConstructorReturn$7(self, call) {
    if (call && (_typeof$7(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized$7(self);
  }

  function _assertThisInitialized$7(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _getPrototypeOf$7(o) {
    _getPrototypeOf$7 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf$7(o);
  }

  function _inherits$7(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf$7(subClass, superClass);
  }

  function _setPrototypeOf$7(o, p) {
    _setPrototypeOf$7 = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf$7(o, p);
  }

  var toArray$1 = function toArray(arrayLike) {
    return Array.prototype.slice.call(arrayLike);
  };

  var ContentSwitcher =
  /*#__PURE__*/
  function (_mixin) {
    _inherits$7(ContentSwitcher, _mixin);
    /**
     * Set of content switcher buttons.
     * @extends CreateComponent
     * @extends InitComponentBySearch
     * @extends EventedState
     * @extends Handles
     * @param {HTMLElement} element The element working as a set of content switcher buttons.
     * @param {object} [options] The component options.
     * @param {string} [options.selectorButton] The CSS selector to find switcher buttons.
     * @param {string} [options.selectorButtonSelected] The CSS selector to find the selected switcher button.
     * @param {string} [options.classActive] The CSS class for switcher button's selected state.
     * @param {string} [options.eventBeforeSelected]
     *   The name of the custom event fired before a switcher button is selected.
     *   Cancellation of this event stops selection of content switcher button.
     * @param {string} [options.eventAfterSelected] The name of the custom event fired after a switcher button is selected.
     */


    function ContentSwitcher(element, options) {
      var _this;

      _classCallCheck$8(this, ContentSwitcher);

      _this = _possibleConstructorReturn$7(this, _getPrototypeOf$7(ContentSwitcher).call(this, element, options));

      _this.manage(on(_this.element, 'click', function (event) {
        _this._handleClick(event);
      }));

      return _this;
    }
    /**
     * Handles click on content switcher button set.
     * If the click is on a content switcher button, activates it.
     * @param {Event} event The event triggering this method.
     */


    _createClass$7(ContentSwitcher, [{
      key: "_handleClick",
      value: function _handleClick(event) {
        var button = eventMatches(event, this.options.selectorButton);

        if (button) {
          this.changeState({
            group: 'selected',
            item: button,
            launchingEvent: event
          });
        }
      }
      /**
       * Internal method of {@linkcode ContentSwitcher#setActive .setActive()}, to select a content switcher button.
       * @private
       * @param {object} detail The detail of the event trigging this action.
       * @param {HTMLElement} detail.item The button to be selected.
       * @param {Function} callback Callback called when change in state completes.
       */

    }, {
      key: "_changeState",
      value: function _changeState(_ref, callback) {
        var _this2 = this;

        var item = _ref.item; // `options.selectorLink` is not defined in this class itself, code here primary is for inherited classes

        var itemLink = item.querySelector(this.options.selectorLink);

        if (itemLink) {
          toArray$1(this.element.querySelectorAll(this.options.selectorLink)).forEach(function (link) {
            if (link !== itemLink) {
              link.setAttribute('aria-selected', 'false');
            }
          });
          itemLink.setAttribute('aria-selected', 'true');
        }

        var selectorButtons = toArray$1(this.element.querySelectorAll(this.options.selectorButton));
        selectorButtons.forEach(function (button) {
          if (button !== item) {
            button.setAttribute('aria-selected', false);
            button.classList.toggle(_this2.options.classActive, false);
            toArray$1(button.ownerDocument.querySelectorAll(button.dataset.target)).forEach(function (element) {
              element.setAttribute('hidden', '');
              element.setAttribute('aria-hidden', 'true');
            });
          }
        });
        item.classList.toggle(this.options.classActive, true);
        item.setAttribute('aria-selected', true);
        toArray$1(item.ownerDocument.querySelectorAll(item.dataset.target)).forEach(function (element) {
          element.removeAttribute('hidden');
          element.setAttribute('aria-hidden', 'false');
        });

        if (callback) {
          callback();
        }
      }
      /**
       * Selects a content switcher button.
       * If the selected button has `data-target` attribute, DOM elements it points to as a CSS selector will be shown.
       * DOM elements associated with unselected buttons in the same way will be hidden.
       * @param {HTMLElement} item The button to be selected.
       * @param {ChangeState~callback} callback The callback is called once selection is finished
       * or is canceled. Will only invoke callback if it's passed in.
       */

    }, {
      key: "setActive",
      value: function setActive(item, callback) {
        this.changeState({
          group: 'selected',
          item: item
        }, function (error) {
          if (error) {
            if (callback) {
              callback(Object.assign(error, {
                item: item
              }));
            }
          } else if (callback) {
            callback(null, item);
          }
        });
      }
      /**
       * The map associating DOM element and content switcher set instance.
       * @member ContentSwitcher.components
       * @type {WeakMap}
       */

    }], [{
      key: "options",

      /**
       * The component options.
       * If `options` is specified in the constructor,
       * {@linkcode ContentSwitcher.create .create()}, or {@linkcode ContentSwitcher.init .init()},
       * properties in this object are overriden for the instance being create and how {@linkcode ContentSwitcher.init .init()} works.
       * @member ContentSwitcher.options
       * @type {object}
       * @property {string} selectorInit The CSS selector to find content switcher button set.
       * @property {string} [selectorButton] The CSS selector to find switcher buttons.
       * @property {string} [selectorButtonSelected] The CSS selector to find the selected switcher button.
       * @property {string} [classActive] The CSS class for switcher button's selected state.
       * @property {string} [eventBeforeSelected]
       *   The name of the custom event fired before a switcher button is selected.
       *   Cancellation of this event stops selection of content switcher button.
       * @property {string} [eventAfterSelected] The name of the custom event fired after a switcher button is selected.
       */
      get: function get() {
        var prefix = settings_1.prefix;
        return {
          selectorInit: '[data-content-switcher]',
          selectorButton: "input[type=\"radio\"], .".concat(prefix, "--content-switcher-btn"),
          classActive: "".concat(prefix, "--content-switcher--selected"),
          eventBeforeSelected: 'content-switcher-beingselected',
          eventAfterSelected: 'content-switcher-selected'
        };
      }
    }]);

    ContentSwitcher.components = new WeakMap();
    return ContentSwitcher;
  }(mixin(createComponent, initComponentBySearch, eventedState, handles));

  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */
  function getLaunchingDetails(evt) {
    if (!evt || typeof evt === 'function') {
      return {
        launchingElement: null,
        launchingEvent: null
      };
    }

    var launchingElement = evt.delegateTarget || evt.currentTarget || evt;
    var launchingEvent = evt.currentTarget && evt;

    if (launchingElement && !launchingElement.nodeType) {
      throw new TypeError('DOM Node should be given for launching element.');
    }

    if (launchingEvent && !launchingEvent.type) {
      throw new TypeError('DOM event should be given for launching event.');
    }

    return {
      launchingElement: launchingElement,
      launchingEvent: launchingEvent
    };
  }

  function _typeof$8(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof$8 = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof$8 = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof$8(obj);
  }

  function _classCallCheck$9(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$8(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$8(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$8(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$8(Constructor, staticProps);
    return Constructor;
  }

  function _possibleConstructorReturn$8(self, call) {
    if (call && (_typeof$8(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized$8(self);
  }

  function _assertThisInitialized$8(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _getPrototypeOf$8(o) {
    _getPrototypeOf$8 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf$8(o);
  }

  function _inherits$8(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf$8(subClass, superClass);
  }

  function _setPrototypeOf$8(o, p) {
    _setPrototypeOf$8 = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf$8(o, p);
  }

  function eventedShowHideState(ToMix) {
    /**
     * Mix-in class to launch a floating menu.
     * @class EventedShowHideState
     */
    var EventedShowHideState =
    /*#__PURE__*/
    function (_ToMix) {
      _inherits$8(EventedShowHideState, _ToMix);

      function EventedShowHideState() {
        _classCallCheck$9(this, EventedShowHideState);

        return _possibleConstructorReturn$8(this, _getPrototypeOf$8(EventedShowHideState).apply(this, arguments));
      }

      _createClass$8(EventedShowHideState, [{
        key: "show",

        /**
         */

        /**
         * Switch to 'shown' state.
         * @param [evtOrElem] The launching event or element.
         * @param {EventedState~changeStateCallback} [callback] The callback.
         */
        value: function show(evtOrElem, callback) {
          if (!evtOrElem || typeof evtOrElem === 'function') {
            callback = evtOrElem; // eslint-disable-line no-param-reassign
          }

          this.changeState('shown', getLaunchingDetails(evtOrElem), callback);
        }
        /**
         * Switch to 'hidden' state.
         * @param [evtOrElem] The launching event or element.
         * @param {EventedState~changeStateCallback} [callback] The callback.
         */

      }, {
        key: "hide",
        value: function hide(evtOrElem, callback) {
          if (!evtOrElem || typeof evtOrElem === 'function') {
            callback = evtOrElem; // eslint-disable-line no-param-reassign
          }

          this.changeState('hidden', getLaunchingDetails(evtOrElem), callback);
        }
      }]);

      return EventedShowHideState;
    }(ToMix);

    return EventedShowHideState;
  }

  var exports$1 = [eventedState, eventedShowHideState];

  function _typeof$9(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof$9 = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof$9 = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof$9(obj);
  }

  function _classCallCheck$a(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$9(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$9(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$9(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$9(Constructor, staticProps);
    return Constructor;
  }

  function _possibleConstructorReturn$9(self, call) {
    if (call && (_typeof$9(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized$9(self);
  }

  function _assertThisInitialized$9(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _getPrototypeOf$9(o) {
    _getPrototypeOf$9 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf$9(o);
  }

  function _inherits$9(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf$9(subClass, superClass);
  }

  function _setPrototypeOf$9(o, p) {
    _setPrototypeOf$9 = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf$9(o, p);
  }

  function trackBlur(ToMix) {
    var TrackBlur =
    /*#__PURE__*/
    function (_ToMix) {
      _inherits$9(TrackBlur, _ToMix);
      /**
       * Mix-in class to add an handler for losing focus.
       * @extends Handles
       * @param {HTMLElement} element The element working as this component.
       * @param {object} [options] The component options.
       */


      function TrackBlur(element, options) {
        var _this;

        _classCallCheck$a(this, TrackBlur);

        _this = _possibleConstructorReturn$9(this, _getPrototypeOf$9(TrackBlur).call(this, element, options));
        var hasFocusin = 'onfocusin' in window;
        var focusinEventName = hasFocusin ? 'focusin' : 'focus';

        _this.manage(on(_this.element.ownerDocument, focusinEventName, function (event) {
          if (!_this.element.contains(event.target)) {
            _this.handleBlur(event);
          }
        }, !hasFocusin));

        return _this;
      }
      /**
       * The method called when this component loses focus.
       * @abstract
       */


      _createClass$9(TrackBlur, [{
        key: "handleBlur",
        value: function handleBlur() {
          throw new Error('Components inheriting TrackBlur mix-in must implement handleBlur() method.');
        }
      }]);

      return TrackBlur;
    }(ToMix);

    return TrackBlur;
  }

  var exports$2 = [handles, trackBlur];

  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */
  // mdn resize function
  var optimizedResize =
  /* #__PURE__ */
  function optimizedResize() {
    var callbacks = [];
    var running = false; // run the actual callbacks

    function runCallbacks() {
      callbacks.forEach(function (callback) {
        callback();
      });
      running = false;
    } // fired on resize event


    function resize() {
      if (!running) {
        running = true;
        window.requestAnimationFrame(runCallbacks);
      }
    } // adds callback to loop


    function addCallback(callback) {
      if (callback) {
        var index = callbacks.indexOf(callback);

        if (index < 0) {
          callbacks.push(callback);
        }
      }
    }

    return {
      // public method to add additional callback
      add: function add(callback) {
        if (!callbacks.length) {
          window.addEventListener('resize', resize);
        }

        addCallback(callback);
        return {
          release: function release() {
            var index = callbacks.indexOf(callback);

            if (index >= 0) {
              callbacks.splice(index, 1);
            }
          }
        };
      }
    };
  }();

  function _typeof$a(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof$a = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof$a = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof$a(obj);
  }

  function _classCallCheck$b(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$a(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$a(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$a(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$a(Constructor, staticProps);
    return Constructor;
  }

  function _possibleConstructorReturn$a(self, call) {
    if (call && (_typeof$a(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized$a(self);
  }

  function _assertThisInitialized$a(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _get$1(target, property, receiver) {
    if (typeof Reflect !== "undefined" && Reflect.get) {
      _get$1 = Reflect.get;
    } else {
      _get$1 = function _get(target, property, receiver) {
        var base = _superPropBase$1(target, property);

        if (!base) return;
        var desc = Object.getOwnPropertyDescriptor(base, property);

        if (desc.get) {
          return desc.get.call(receiver);
        }

        return desc.value;
      };
    }

    return _get$1(target, property, receiver || target);
  }

  function _superPropBase$1(object, property) {
    while (!Object.prototype.hasOwnProperty.call(object, property)) {
      object = _getPrototypeOf$a(object);
      if (object === null) break;
    }

    return object;
  }

  function _getPrototypeOf$a(o) {
    _getPrototypeOf$a = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf$a(o);
  }

  function _inherits$a(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf$a(subClass, superClass);
  }

  function _setPrototypeOf$a(o, p) {
    _setPrototypeOf$a = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf$a(o, p);
  }

  function _defineProperty$1(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }
  /**
   * The structure for the position of floating menu.
   * @typedef {Object} FloatingMenu~position
   * @property {number} left The left position.
   * @property {number} top The top position.
   * @property {number} right The right position.
   * @property {number} bottom The bottom position.
   */

  /**
   * The structure for the size of floating menu.
   * @typedef {Object} FloatingMenu~size
   * @property {number} width The width.
   * @property {number} height The height.
   */

  /**
   * The structure for the position offset of floating menu.
   * @typedef {Object} FloatingMenu~offset
   * @property {number} top The top position.
   * @property {number} left The left position.
   */

  var DIRECTION_LEFT = 'left';
  var DIRECTION_TOP = 'top';
  var DIRECTION_RIGHT = 'right';
  var DIRECTION_BOTTOM = 'bottom';
  /**
   * @param {object} params The parameters.
   * @param {FloatingMenu~size} params.menuSize The size of the menu.
   * @param {FloatingMenu~position} params.refPosition The position of the triggering element.
   * @param {FloatingMenu~offset} [params.offset={ left: 0, top: 0 }] The position offset of the menu.
   * @param {string} [params.direction=bottom] The menu direction.
   * @param {number} [params.scrollX=0] The scroll position of the viewport.
   * @param {number} [params.scrollY=0] The scroll position of the viewport.
   * @returns {FloatingMenu~offset} The position of the menu, relative to the top-left corner of the viewport.
   * @private
   */

  var getFloatingPosition = function getFloatingPosition(_ref) {
    var _DIRECTION_LEFT$DIREC;

    var menuSize = _ref.menuSize,
        refPosition = _ref.refPosition,
        _ref$offset = _ref.offset,
        offset = _ref$offset === void 0 ? {} : _ref$offset,
        _ref$direction = _ref.direction,
        direction = _ref$direction === void 0 ? DIRECTION_BOTTOM : _ref$direction,
        _ref$scrollX = _ref.scrollX,
        scrollX = _ref$scrollX === void 0 ? 0 : _ref$scrollX,
        _ref$scrollY = _ref.scrollY,
        scrollY = _ref$scrollY === void 0 ? 0 : _ref$scrollY;
    var _refPosition$left = refPosition.left,
        refLeft = _refPosition$left === void 0 ? 0 : _refPosition$left,
        _refPosition$top = refPosition.top,
        refTop = _refPosition$top === void 0 ? 0 : _refPosition$top,
        _refPosition$right = refPosition.right,
        refRight = _refPosition$right === void 0 ? 0 : _refPosition$right,
        _refPosition$bottom = refPosition.bottom,
        refBottom = _refPosition$bottom === void 0 ? 0 : _refPosition$bottom;
    var width = menuSize.width,
        height = menuSize.height;
    var _offset$top = offset.top,
        top = _offset$top === void 0 ? 0 : _offset$top,
        _offset$left = offset.left,
        left = _offset$left === void 0 ? 0 : _offset$left;
    var refCenterHorizontal = (refLeft + refRight) / 2;
    var refCenterVertical = (refTop + refBottom) / 2;
    return (_DIRECTION_LEFT$DIREC = {}, _defineProperty$1(_DIRECTION_LEFT$DIREC, DIRECTION_LEFT, {
      left: refLeft - width + scrollX - left,
      top: refCenterVertical - height / 2 + scrollY + top
    }), _defineProperty$1(_DIRECTION_LEFT$DIREC, DIRECTION_TOP, {
      left: refCenterHorizontal - width / 2 + scrollX + left,
      top: refTop - height + scrollY - top
    }), _defineProperty$1(_DIRECTION_LEFT$DIREC, DIRECTION_RIGHT, {
      left: refRight + scrollX + left,
      top: refCenterVertical - height / 2 + scrollY + top
    }), _defineProperty$1(_DIRECTION_LEFT$DIREC, DIRECTION_BOTTOM, {
      left: refCenterHorizontal - width / 2 + scrollX + left,
      top: refBottom + scrollY + top
    }), _DIRECTION_LEFT$DIREC)[direction];
  };

  var FloatingMenu =
  /*#__PURE__*/
  function (_mixin) {
    _inherits$a(FloatingMenu, _mixin);
    /**
     * Floating menu.
     * @extends CreateComponent
     * @extends EventedShowHideState
     * @param {HTMLElement} element The element working as a modal dialog.
     * @param {object} [options] The component options.
     * @param {string} [options.selectorContainer] The CSS selector to find the container to put this menu in.
     * @param {string} [options.attribDirection] The attribute name to specify menu placement direction (top/right/bottom/left).
     * @param {string} [options.classShown] The CSS class for shown state, for the menu.
     * @param {string} [options.classRefShown] The CSS class for shown state, for the trigger button.
     * @param {string} [options.eventBeforeShown]
     *   The name of the custom event fired before this menu is shown.
     *   Cancellation of this event stops hiding the menu.
     * @param {string} [options.eventAfterShown]
     *   The name of the custom event telling that menu is sure shown
     *   without being canceled by the event handler named by `eventBeforeShown` option (`floating-menu-beingshown`).
     * @param {string} [options.eventBeforeHidden]
     *   The name of the custom event fired before this menu is hidden.
     *   Cancellation of this event stops hiding the menu.
     * @param {string} [options.eventAfterHidden]
     *   The name of the custom event telling that menu is sure hidden
     *   without being canceled by the event handler named by `eventBeforeHidden` option (`floating-menu-beinghidden`).
     * @param {Element} [options.refNode] The launching element of the menu. Used for calculating the geometry of the menu.
     * @param {object} [options.offset] The offset to adjust the geometry of the menu. Should have `top`/`left` properties.
     */


    function FloatingMenu(element, options) {
      var _this;

      _classCallCheck$b(this, FloatingMenu);

      _this = _possibleConstructorReturn$a(this, _getPrototypeOf$a(FloatingMenu).call(this, element, options));

      var attribDirectionValue = _this.element.getAttribute(_this.options.attribDirection);

      if (!_this.options.direction) {
        _this.options.direction = attribDirectionValue || 'bottom';
      }

      if (!attribDirectionValue) {
        // Update attribute for styling
        _this.element.setAttribute(_this.options.attribDirection, _this.options.direction);
      }

      return _this;
    }
    /**
     * Focuses back on the trigger button if this component loses focus.
     */


    _createClass$a(FloatingMenu, [{
      key: "handleBlur",
      value: function handleBlur(event) {
        if (this.element.classList.contains(this.options.classShown)) {
          this.changeState('hidden', getLaunchingDetails(event));
          var _this$options = this.options,
              refNode = _this$options.refNode,
              triggerNode = _this$options.triggerNode;

          if (this.element.contains(event.relatedTarget) && refNode && event.target !== refNode) {
            HTMLElement.prototype.focus.call(triggerNode || refNode); // SVGElement in IE11 does not have `.focus()` method
          }
        }
      }
      /**
       * @private
       * @returns {Element} The element that this menu should be placed to.
       */

    }, {
      key: "_getContainer",
      value: function _getContainer() {
        return this.element.closest(this.options.selectorContainer) || this.element.ownerDocument.body;
      }
      /**
       * @private
       * @returns {object} The menu position, with `top` and `left` properties.
       */

    }, {
      key: "_getPos",
      value: function _getPos() {
        var element = this.element;
        var _this$options2 = this.options,
            refNode = _this$options2.refNode,
            offset = _this$options2.offset,
            direction = _this$options2.direction;

        if (!refNode) {
          throw new Error('Cannot find the refernce node for positioning floating menu.');
        }

        return getFloatingPosition({
          menuSize: element.getBoundingClientRect(),
          refPosition: refNode.getBoundingClientRect(),
          offset: typeof offset !== 'function' ? offset : offset(element, direction, refNode),
          direction: direction,
          scrollX: refNode.ownerDocument.defaultView.pageXOffset,
          scrollY: refNode.ownerDocument.defaultView.pageYOffset
        });
      }
      /**
       * Sees if the computed style is what this floating menu expects.
       * @private
       */

    }, {
      key: "_testStyles",
      value: function _testStyles() {
        if (!this.options.debugStyle) {
          return;
        }

        var element = this.element;
        var computedStyle = element.ownerDocument.defaultView.getComputedStyle(element);
        var styles = {
          position: 'absolute',
          right: 'auto',
          margin: 0
        };
        Object.keys(styles).forEach(function (key) {
          var expected = typeof styles[key] === 'number' ? parseFloat(styles[key]) : styles[key];
          var actual = computedStyle.getPropertyValue(key);

          if (expected !== actual) {
            // eslint-disable-next-line no-console
            console.warn("Floating menu component expects ".concat(key, ": ").concat(styles[key], " style."));
          }
        });
      }
      /**
       * Places the menu.
       * @private
       */

    }, {
      key: "_place",
      value: function _place() {
        var element = this.element;

        var _this$_getPos = this._getPos(),
            left = _this$_getPos.left,
            top = _this$_getPos.top;

        element.style.left = "".concat(left, "px");
        element.style.top = "".concat(top, "px");

        this._testStyles();
      }
      /**
       * @param {string} state The new state.
       * @returns {boolean} `true` of the current state is different from the given new state.
       */

    }, {
      key: "shouldStateBeChanged",
      value: function shouldStateBeChanged(state) {
        return (state === 'shown' || state === 'hidden') && state !== (this.element.classList.contains(this.options.classShown) ? 'shown' : 'hidden');
      }
      /**
       * Changes the shown/hidden state.
       * @private
       * @param {string} state The new state.
       * @param {object} detail The detail of the event trigging this action.
       * @param {Function} callback Callback called when change in state completes.
       */

    }, {
      key: "_changeState",
      value: function _changeState(state, detail, callback) {
        var _this2 = this;

        var shown = state === 'shown';
        var _this$options3 = this.options,
            refNode = _this$options3.refNode,
            classShown = _this$options3.classShown,
            classRefShown = _this$options3.classRefShown;

        if (!refNode) {
          throw new TypeError('Cannot find the refernce node for changing the style.');
        }

        this.element.classList.toggle(classShown, shown);

        if (classRefShown) {
          refNode.classList.toggle(classRefShown, shown);
        }

        if (state === 'shown') {
          if (!this.hResize) {
            this.hResize = optimizedResize.add(function () {
              _this2._place();
            });
          }

          this._getContainer().appendChild(this.element);

          this._place(); // IE11 puts focus on elements with `.focus()`, even ones without `tabindex` attribute


          if (!this.element.hasAttribute(this.options.attribAvoidFocusOnOpen)) {
            (this.element.querySelector(this.options.selectorPrimaryFocus) || this.element).focus();
          }
        }

        if (state === 'hidden' && this.hResize) {
          this.hResize.release();
          this.hResize = null;
        }

        callback();
      }
    }, {
      key: "release",
      value: function release() {
        if (this.hResize) {
          this.hResize.release();
          this.hResize = null;
        }

        _get$1(_getPrototypeOf$a(FloatingMenu.prototype), "release", this).call(this);
      }
    }]);

    FloatingMenu.options = {
      selectorContainer: '[data-floating-menu-container]',
      selectorPrimaryFocus: '[data-floating-menu-primary-focus]',
      attribDirection: 'data-floating-menu-direction',
      attribAvoidFocusOnOpen: 'data-avoid-focus-on-open',
      classShown: '',
      // Should be provided from options arg in constructor
      classRefShown: '',
      // Should be provided from options arg in constructor
      eventBeforeShown: 'floating-menu-beingshown',
      eventAfterShown: 'floating-menu-shown',
      eventBeforeHidden: 'floating-menu-beinghidden',
      eventAfterHidden: 'floating-menu-hidden',
      refNode: null,
      // Should be provided from options arg in constructor
      offset: {
        left: 0,
        top: 0
      }
    };
    FloatingMenu.components = new WeakMap();
    return FloatingMenu;
  }(mixin(createComponent, exports$1, exports$2));

  function _typeof$b(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof$b = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof$b = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof$b(obj);
  }

  function _toConsumableArray$3(arr) {
    return _arrayWithoutHoles$3(arr) || _iterableToArray$3(arr) || _nonIterableSpread$3();
  }

  function _nonIterableSpread$3() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray$3(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles$3(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }

      return arr2;
    }
  }

  function _classCallCheck$c(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$b(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$b(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$b(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$b(Constructor, staticProps);
    return Constructor;
  }

  function _possibleConstructorReturn$b(self, call) {
    if (call && (_typeof$b(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized$b(self);
  }

  function _assertThisInitialized$b(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _getPrototypeOf$b(o) {
    _getPrototypeOf$b = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf$b(o);
  }

  function _inherits$b(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf$b(subClass, superClass);
  }

  function _setPrototypeOf$b(o, p) {
    _setPrototypeOf$b = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf$b(o, p);
  }

  function _defineProperty$2(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }
  /**
   * The CSS property names of the arrow keyed by the floating menu direction.
   * @type {Object<string, string>}
   */

  var triggerButtonPositionProps =
  /* #__PURE__ */
  function () {
    var _ref;

    return _ref = {}, _defineProperty$2(_ref, DIRECTION_TOP, 'bottom'), _defineProperty$2(_ref, DIRECTION_BOTTOM, 'top'), _defineProperty$2(_ref, DIRECTION_LEFT, 'left'), _defineProperty$2(_ref, DIRECTION_RIGHT, 'right'), _ref;
  }();
  /**
   * Determines how the position of arrow should affect the floating menu position.
   * @type {Object<string, number>}
   */


  var triggerButtonPositionFactors =
  /* #__PURE__ */
  function () {
    var _ref2;

    return _ref2 = {}, _defineProperty$2(_ref2, DIRECTION_TOP, -2), _defineProperty$2(_ref2, DIRECTION_BOTTOM, -1), _defineProperty$2(_ref2, DIRECTION_LEFT, -2), _defineProperty$2(_ref2, DIRECTION_RIGHT, -1), _ref2;
  }();
  /**
   * @param {Element} menuBody The menu body with the menu arrow.
   * @param {string} direction The floating menu direction.
   * @param {Element} trigger The trigger button.
   * @returns {FloatingMenu~offset} The adjustment of the floating menu position, upon the position of the menu arrow.
   * @private
   */


  var getMenuOffset = function getMenuOffset(menuBody, direction, trigger) {
    var triggerButtonPositionProp = triggerButtonPositionProps[direction];
    var triggerButtonPositionFactor = triggerButtonPositionFactors[direction];

    if (!triggerButtonPositionProp || !triggerButtonPositionFactor) {
      console.warn('Wrong floating menu direction:', direction); // eslint-disable-line no-console
    }

    var menuWidth = menuBody.offsetWidth;
    var menuHeight = menuBody.offsetHeight; // eslint-disable-next-line no-use-before-define

    var menu = OverflowMenu.components.get(trigger);

    if (!menu) {
      throw new TypeError('Overflow menu instance cannot be found.');
    }

    var flip = menuBody.classList.contains(menu.options.classMenuFlip);

    if (triggerButtonPositionProp === 'top' || triggerButtonPositionProp === 'bottom') {
      var triggerWidth = trigger.offsetWidth;
      return {
        left: (!flip ? 1 : -1) * (menuWidth / 2 - triggerWidth / 2),
        top: 0
      };
    }

    if (triggerButtonPositionProp === 'left' || triggerButtonPositionProp === 'right') {
      var triggerHeight = trigger.offsetHeight;
      return {
        left: 0,
        top: (!flip ? 1 : -1) * (menuHeight / 2 - triggerHeight / 2)
      };
    }

    return undefined;
  };

  var OverflowMenu =
  /*#__PURE__*/
  function (_mixin) {
    _inherits$b(OverflowMenu, _mixin);
    /**
     * Overflow menu.
     * @extends CreateComponent
     * @extends InitComponentBySearch
     * @extends Handles
     * @param {HTMLElement} element The element working as a modal dialog.
     * @param {object} [options] The component options.
     * @param {string} [options.selectorOptionMenu] The CSS selector to find the menu.
     * @param {string} [options.selectorTrigger] The CSS selector to find the trigger button.
     * @param {string} [options.classShown] The CSS class for the shown state, for the trigger UI.
     * @param {string} [options.classMenuShown] The CSS class for the shown state, for the menu.
     * @param {string} [options.classMenuFlip] The CSS class for the flipped state of the menu.
     * @param {object} [options.objMenuOffset] The offset locating the menu for the non-flipped state.
     * @param {object} [options.objMenuOffsetFlip] The offset locating the menu for the flipped state.
     */


    function OverflowMenu(element, options) {
      var _this;

      _classCallCheck$c(this, OverflowMenu);

      _this = _possibleConstructorReturn$b(this, _getPrototypeOf$b(OverflowMenu).call(this, element, options));

      _this.getCurrentNavigation = function () {
        var focused = _this.element.ownerDocument.activeElement;
        return focused.nodeType === Node.ELEMENT_NODE && focused.matches(_this.options.selectorItem) ? focused : null;
      };

      _this.navigate = function (direction) {
        var items = _toConsumableArray$3(_this.element.ownerDocument.querySelectorAll(_this.options.selectorItem));

        var start = _this.getCurrentNavigation() || _this.element.querySelector(_this.options.selectorItemSelected);

        var getNextItem = function getNextItem(old) {
          var handleUnderflow = function handleUnderflow(index, length) {
            return index + (index >= 0 ? 0 : length);
          };

          var handleOverflow = function handleOverflow(index, length) {
            return index - (index < length ? 0 : length);
          }; // `items.indexOf(old)` may be -1 (Scenario of no previous focus)


          var index = Math.max(items.indexOf(old) + direction, -1);
          return items[handleUnderflow(handleOverflow(index, items.length), items.length)];
        };

        for (var current = getNextItem(start); current && current !== start; current = getNextItem(current)) {
          if (!current.matches(_this.options.selectorItemHidden) && !current.parentNode.matches(_this.options.selectorItemHidden) && !current.matches(_this.options.selectorItemSelected)) {
            current.focus();
            break;
          }
        }
      };

      if (_this.element.getAttribute('role') !== 'button') {
        // Would prefer to use the aria-controls with a specific ID but we
        // don't have the menuOptions list at this point to pull the ID from
        _this.triggerNode = _this.element.querySelector(_this.options.selectorTrigger);
      }

      _this.manage(on(_this.element.ownerDocument, 'click', function (event) {
        _this._handleDocumentClick(event);

        _this.wasOpenBeforeClick = undefined;
      }));

      _this.manage(on(_this.element.ownerDocument, 'keydown', function (event) {
        _this._handleKeyPress(event);
      }));

      _this.manage(on(_this.element, 'mousedown', function () {
        _this.wasOpenBeforeClick = element.classList.contains(_this.options.classShown);
      }));

      return _this;
    }
    /**
     * Changes the shown/hidden state.
     * @param {string} state The new state.
     * @param {object} detail The detail of the event trigging this action.
     * @param {Function} callback Callback called when change in state completes.
     */


    _createClass$b(OverflowMenu, [{
      key: "changeState",
      value: function changeState(state, detail, callback) {
        // @todo Can clean up to use `this.triggerNode` once non-compliant code is deprecated
        var triggerElement = this.triggerNode ? 'triggerNode' : 'element';

        if (state === 'hidden') {
          this[triggerElement].setAttribute('aria-expanded', 'false');
        } else {
          this[triggerElement].setAttribute('aria-expanded', 'true');
        }

        if (!this.optionMenu) {
          var optionMenu = this.element.querySelector(this.options.selectorOptionMenu);

          if (!optionMenu) {
            throw new Error('Cannot find the target menu.');
          } // Lazily create a component instance for menu


          this.optionMenu = FloatingMenu.create(optionMenu, {
            refNode: this.element,
            classShown: this.options.classMenuShown,
            classRefShown: this.options.classShown,
            offset: this.options.objMenuOffset,
            triggerNode: this.triggerNode
          });
          this.children.push(this.optionMenu);
        }

        if (this.optionMenu.element.classList.contains(this.options.classMenuFlip)) {
          this.optionMenu.options.offset = this.options.objMenuOffsetFlip;
        } // Delegates the action of changing state to the menu.
        // (And thus the before/after shown/hidden events are fired from the menu)


        this.optionMenu.changeState(state, Object.assign(detail, {
          delegatorNode: this.element
        }), callback);
      }
      /**
       * Handles click on document.
       * @param {Event} event The triggering event.
       * @private
       */

    }, {
      key: "_handleDocumentClick",
      value: function _handleDocumentClick(event) {
        var _this2 = this;

        var element = this.element,
            optionMenu = this.optionMenu,
            wasOpenBeforeClick = this.wasOpenBeforeClick,
            triggerNode = this.triggerNode;
        var isOfSelf = element.contains(event.target);
        var isOfMenu = optionMenu && optionMenu.element.contains(event.target);
        var shouldBeOpen = isOfSelf && !wasOpenBeforeClick;
        var state = shouldBeOpen ? 'shown' : 'hidden';

        if (isOfSelf) {
          if (element.tagName === 'A') {
            event.preventDefault();
          }

          event.delegateTarget = element; // eslint-disable-line no-param-reassign
        }

        if (!isOfMenu || eventMatches(event, this.options.selectorItem)) {
          this.changeState(state, getLaunchingDetails(event), function () {
            if (state === 'hidden' && isOfMenu) {
              // @todo Can clean up to use `this.triggerNode` once non-compliant code is deprecated
              _this2[triggerNode ? 'triggerNode' : 'element'].focus();
            }
          });
        }
      }
      /**
       * Provides the element to move focus from
       * @returns {Element} Currently highlighted element.
       */

    }, {
      key: "_handleKeyPress",

      /**
       * Handles key press on document.
       * @param {Event} event The triggering event.
       * @private
       */
      value: function _handleKeyPress(event) {
        var _this3 = this;

        var key = event.which;
        var element = this.element,
            optionMenu = this.optionMenu,
            options = this.options,
            triggerNode = this.triggerNode;
        var isOfMenu = optionMenu && optionMenu.element.contains(event.target);
        var isExpanded = this.element.classList.contains(this.options.classShown); // @todo Can clean up to use `this.triggerNode` once non-compliant code is deprecated

        var triggerElement = triggerNode ? 'triggerNode' : 'element';

        switch (key) {
          // Esc
          case 27:
            this.changeState('hidden', getLaunchingDetails(event), function () {
              if (isOfMenu) {
                _this3[triggerElement].focus();
              }
            });
            break;
          // Enter || Space bar

          case 13:
          case 32:
            {
              if (!isExpanded && this.element.ownerDocument.activeElement !== this.element) {
                return;
              }

              var isOfSelf = element.contains(event.target);
              var shouldBeOpen = isOfSelf && !element.classList.contains(options.classShown);
              var state = shouldBeOpen ? 'shown' : 'hidden';

              if (isOfSelf) {
                event.delegateTarget = element; // eslint-disable-line no-param-reassign

                event.preventDefault(); // prevent scrolling

                this.changeState(state, getLaunchingDetails(event), function () {
                  if (state === 'hidden' && isOfMenu) {
                    _this3[triggerElement].focus();
                  }
                });
              }

              break;
            }

          case 38: // up arrow

          case 40:
            // down arrow
            {
              if (!isExpanded) {
                return;
              }

              event.preventDefault(); // prevent scrolling

              var direction = {
                38: -1,
                40: 1
              }[event.which];
              this.navigate(direction);
            }
            break;

          default:
            break;
        }
      }
    }], [{
      key: "options",
      get: function get() {
        var prefix = settings_1.prefix;
        return {
          selectorInit: '[data-overflow-menu]',
          selectorOptionMenu: ".".concat(prefix, "--overflow-menu-options"),
          selectorTrigger: 'button[aria-haspopup]',
          selectorItem: "\n        .".concat(prefix, "--overflow-menu-options--open >\n        .").concat(prefix, "--overflow-menu-options__option:not(.").concat(prefix, "--overflow-menu-options__option--disabled) >\n        .").concat(prefix, "--overflow-menu-options__btn\n      "),
          classShown: "".concat(prefix, "--overflow-menu--open"),
          classMenuShown: "".concat(prefix, "--overflow-menu-options--open"),
          classMenuFlip: "".concat(prefix, "--overflow-menu--flip"),
          objMenuOffset: getMenuOffset,
          objMenuOffsetFlip: getMenuOffset
        };
      }
    }]);

    OverflowMenu.components = new WeakMap();
    return OverflowMenu;
  }(mixin(createComponent, initComponentBySearch, exports$1, handles));

  /**
   * Copyright 2014-2015, Facebook, Inc.
   * All rights reserved.
   *
   * This source code is licensed under the BSD-style license found in the
   * LICENSE file in the root directory of this source tree. An additional grant
   * of patent rights can be found in the PATENTS file in the same directory.
   */

  var warning = function () {};

  {
    warning = function (condition, format, args) {
      var len = arguments.length;
      args = new Array(len > 2 ? len - 2 : 0);

      for (var key = 2; key < len; key++) {
        args[key - 2] = arguments[key];
      }

      if (format === undefined) {
        throw new Error('`warning(condition, format, ...args)` requires a warning ' + 'message argument');
      }

      if (format.length < 10 || /^[s\W]*$/.test(format)) {
        throw new Error('The warning format should be able to uniquely identify this ' + 'warning. Please, use a more descriptive format than: ' + format);
      }

      if (!condition) {
        var argIndex = 0;
        var message = 'Warning: ' + format.replace(/%s/g, function () {
          return args[argIndex++];
        });

        if (typeof console !== 'undefined') {
          console.error(message);
        }

        try {
          // This error was thrown as a convenience so that you can use this stack
          // to find the callsite that caused this warning to fire.
          throw new Error(message);
        } catch (x) {}
      }
    };
  }

  var warning_1 = warning;

  function _typeof$c(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof$c = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof$c = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof$c(obj);
  }

  function _classCallCheck$d(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$c(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$c(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$c(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$c(Constructor, staticProps);
    return Constructor;
  }

  function _possibleConstructorReturn$c(self, call) {
    if (call && (_typeof$c(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized$c(self);
  }

  function _assertThisInitialized$c(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _getPrototypeOf$c(o) {
    _getPrototypeOf$c = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf$c(o);
  }

  function _inherits$c(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf$c(subClass, superClass);
  }

  function _setPrototypeOf$c(o, p) {
    _setPrototypeOf$c = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf$c(o, p);
  }
  function initComponentByLauncher (ToMix) {
    /**
     * Mix-in class to instantiate components events on launcher button.
     * @class InitComponentByLauncher
     */
    var InitComponentByLauncher =
    /*#__PURE__*/
    function (_ToMix) {
      _inherits$c(InitComponentByLauncher, _ToMix);

      function InitComponentByLauncher() {
        _classCallCheck$d(this, InitComponentByLauncher);

        return _possibleConstructorReturn$c(this, _getPrototypeOf$c(InitComponentByLauncher).apply(this, arguments));
      }

      _createClass$c(InitComponentByLauncher, null, [{
        key: "init",

        /**
         * `true` suggests that this component is lazily initialized upon an action/event, etc.
         * @type {boolean}
         */

        /**
         * Instantiates this component in the given element.
         * If the given element indicates that it's an component of this class, instantiates it.
         * Otherwise, instantiates this component by clicking on launcher buttons
         * (buttons with attribute that `options.attribInitTarget` points to) of this component in the given node.
         * @param {Node} target The DOM node to instantiate this component in. Should be a document or an element.
         * @param {object} [options] The component options.
         * @param {string} [options.selectorInit] The CSS selector to find this component.
         * @param {string} [options.attribInitTarget] The attribute name in the launcher buttons to find target component.
         * @returns {Handle} The handle to remove the event listener to handle clicking.
         */
        value: function init() {
          var _this = this;

          var target = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : document;
          var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
          var effectiveOptions = Object.assign(Object.create(this.options), options);

          if (!target || target.nodeType !== Node.ELEMENT_NODE && target.nodeType !== Node.DOCUMENT_NODE) {
            throw new TypeError('DOM document or DOM element should be given to search for and initialize this widget.');
          }

          if (target.nodeType === Node.ELEMENT_NODE && target.matches(effectiveOptions.selectorInit)) {
            this.create(target, options);
          } else {
            var handles = effectiveOptions.initEventNames.map(function (name) {
              return on(target, name, function (event) {
                var launcher = eventMatches(event, "[".concat(effectiveOptions.attribInitTarget, "]"));

                if (launcher) {
                  event.delegateTarget = launcher; // eslint-disable-line no-param-reassign

                  var elements = launcher.ownerDocument.querySelectorAll(launcher.getAttribute(effectiveOptions.attribInitTarget));

                  if (elements.length > 1) {
                    throw new Error('Target widget must be unique.');
                  }

                  if (elements.length === 1) {
                    if (launcher.tagName === 'A') {
                      event.preventDefault();
                    }

                    var component = _this.create(elements[0], options);

                    if (typeof component.createdByLauncher === 'function') {
                      component.createdByLauncher(event);
                    }
                  }
                }
              });
            });
            return {
              release: function release() {
                for (var handle = handles.pop(); handle; handle = handles.pop()) {
                  handle.release();
                }
              }
            };
          }

          return '';
        }
      }]);

      InitComponentByLauncher.forLazyInit = true;
      return InitComponentByLauncher;
    }(ToMix);

    return InitComponentByLauncher;
  }

  function _typeof$d(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof$d = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof$d = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof$d(obj);
  }

  function _classCallCheck$e(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$d(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$d(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$d(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$d(Constructor, staticProps);
    return Constructor;
  }

  function _possibleConstructorReturn$d(self, call) {
    if (call && (_typeof$d(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized$d(self);
  }

  function _assertThisInitialized$d(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _getPrototypeOf$d(o) {
    _getPrototypeOf$d = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf$d(o);
  }

  function _inherits$d(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf$d(subClass, superClass);
  }

  function _setPrototypeOf$d(o, p) {
    _setPrototypeOf$d = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf$d(o, p);
  }

  var Modal =
  /*#__PURE__*/
  function (_mixin) {
    _inherits$d(Modal, _mixin);
    /**
     * Modal dialog.
     * @extends CreateComponent
     * @extends InitComponentByLauncher
     * @extends EventedShowHideState
     * @extends Handles
     * @param {HTMLElement} element The element working as a modal dialog.
     * @param {object} [options] The component options.
     * @param {string} [options.classVisible] The CSS class for the visible state.
     * @param {string} [options.classBody] The CSS class for `<body>` with open modal.
     * @param {string} [options.eventBeforeShown]
     *   The name of the custom event fired before this modal is shown.
     *   Cancellation of this event stops showing the modal.
     * @param {string} [options.eventAfterShown]
     *   The name of the custom event telling that modal is sure shown
     *   without being canceled by the event handler named by `eventBeforeShown` option (`modal-beingshown`).
     * @param {string} [options.eventBeforeHidden]
     *   The name of the custom event fired before this modal is hidden.
     *   Cancellation of this event stops hiding the modal.
     * @param {string} [options.eventAfterHidden]
     *   The name of the custom event telling that modal is sure hidden
     *   without being canceled by the event handler named by `eventBeforeHidden` option (`modal-beinghidden`).
     */


    function Modal(element, options) {
      var _this;

      _classCallCheck$e(this, Modal);

      _this = _possibleConstructorReturn$d(this, _getPrototypeOf$d(Modal).call(this, element, options));
      _this._handleFocusinListener = void 0;
      _this._handleKeydownListener = void 0;

      _this._handleFocusin = function (evt) {
        if (_this.element.classList.contains(_this.options.classVisible) && !_this.element.contains(evt.target) && _this.options.selectorsFloatingMenus.every(function (selector) {
          return !eventMatches(evt, selector);
        })) {
          _this.element.querySelector(settings_1.selectorTabbable).focus();
        }
      };

      _this._hookCloseActions();

      return _this;
    }
    /**
     * The handle for `focusin` event listener.
     * Used for "focus-wrap" feature.
     * @type {Handle}
     * @private
     */


    _createClass$d(Modal, [{
      key: "createdByLauncher",

      /**
       * A method that runs when `.init()` is called from `initComponentByLauncher`.
       * @param {Event} evt The event fired on the launcher button.
       */
      value: function createdByLauncher(evt) {
        this.show(evt);
      }
      /**
       * Determines whether or not to emit events and callback function when `.changeState()` is called from `eventedState`.
       * @param {string} state The new state.
       * @returns {boolean} `true` if the given `state` is different from current state.
       */

    }, {
      key: "shouldStateBeChanged",
      value: function shouldStateBeChanged(state) {
        if (state === 'shown') {
          return !this.element.classList.contains(this.options.classVisible);
        }

        return this.element.classList.contains(this.options.classVisible);
      }
      /**
       * Changes the shown/hidden state.
       * @private
       * @param {string} state The new state.
       * @param {object} detail The detail data to be included in the event that will be fired.
       * @param {Function} callback Callback called when change in state completes.
       */

    }, {
      key: "_changeState",
      value: function _changeState(state, detail, callback) {
        var _this2 = this;

        var handleTransitionEnd;

        var transitionEnd = function transitionEnd() {
          if (handleTransitionEnd) {
            handleTransitionEnd = _this2.unmanage(handleTransitionEnd).release();
          }

          if (state === 'shown' && _this2.element.offsetWidth > 0 && _this2.element.offsetHeight > 0) {
            _this2.previouslyFocusedNode = _this2.element.ownerDocument.activeElement;

            var focusableItem = _this2.element.querySelector(_this2.options.selectorPrimaryFocus) || _this2.element.querySelector(settings_1.selectorTabbable);

            focusableItem.focus();

            {
               warning_1(focusableItem, "Modals need to contain a focusable element by either using " + "`".concat(_this2.options.selectorPrimaryFocus, "` or settings.selectorTabbable.")) ;
            }
          }

          callback();
        };

        if (this._handleFocusinListener) {
          this._handleFocusinListener = this.unmanage(this._handleFocusinListener).release();
        }

        if (state === 'shown') {
          var hasFocusin = 'onfocusin' in this.element.ownerDocument.defaultView;
          var focusinEventName = hasFocusin ? 'focusin' : 'focus';
          this._handleFocusinListener = this.manage(on(this.element.ownerDocument, focusinEventName, this._handleFocusin, !hasFocusin));
        }

        if (state === 'hidden') {
          this.element.classList.toggle(this.options.classVisible, false);
          this.element.ownerDocument.body.classList.toggle(this.options.classBody, false);

          if (this.options.selectorFocusOnClose || this.previouslyFocusedNode) {
            (this.element.ownerDocument.querySelector(this.options.selectorFocusOnClose) || this.previouslyFocusedNode).focus();
          }
        } else if (state === 'shown') {
          this.element.classList.toggle(this.options.classVisible, true);
          this.element.ownerDocument.body.classList.toggle(this.options.classBody, true);
        }

        handleTransitionEnd = this.manage(on(this.element, 'transitionend', transitionEnd));
      }
    }, {
      key: "_hookCloseActions",
      value: function _hookCloseActions() {
        var _this3 = this;

        this.manage(on(this.element, 'click', function (evt) {
          var closeButton = eventMatches(evt, _this3.options.selectorModalClose);

          if (closeButton) {
            evt.delegateTarget = closeButton; // eslint-disable-line no-param-reassign
          }

          if (closeButton || evt.target === _this3.element) {
            _this3.hide(evt);
          }
        }));

        if (this._handleKeydownListener) {
          this._handleKeydownListener = this.unmanage(this._handleKeydownListener).release();
        }

        this._handleKeydownListener = this.manage(on(this.element.ownerDocument.body, 'keydown', function (evt) {
          // Avoid running `evt.stopPropagation()` only when modal is shown
          if (evt.which === 27 && _this3.shouldStateBeChanged('hidden')) {
            evt.stopPropagation();

            _this3.hide(evt);
          }
        }));
      }
      /**
       * Handles `focusin` (or `focus` depending on browser support of `focusin`) event to do wrap-focus behavior.
       * @param {Event} evt The event.
       * @private
       */

    }], [{
      key: "options",

      /**
       * The component options.
       * If `options` is specified in the constructor, {@linkcode Modal.create .create()}, or {@linkcode Modal.init .init()},
       * properties in this object are overriden for the instance being create and how {@linkcode Modal.init .init()} works.
       * @member Modal.options
       * @type {object}
       * @property {string} selectorInit The CSS class to find modal dialogs.
       * @property {string} [selectorModalClose] The selector to find elements that close the modal.
       * @property {string} [selectorPrimaryFocus] The CSS selector to determine the element to put focus when modal gets open.
       * @property {string} [selectorFocusOnClose] The CSS selector to determine the element to put focus when modal closes.
       *   If undefined, focus returns to the previously focused element prior to the modal opening.
       * @property {string} attribInitTarget The attribute name in the launcher buttons to find target modal dialogs.
       * @property {string[]} [selectorsFloatingMenu]
       *   The CSS selectors of floating menus.
       *   Used for detecting if focus-wrap behavior should be disabled temporarily.
       * @property {string} [classVisible] The CSS class for the visible state.
       * @property {string} [classBody] The CSS class for `<body>` with open modal.
       * @property {string} [classNoScroll] The CSS class for hiding scroll bar in body element while modal is shown.
       * @property {string} [eventBeforeShown]
       *   The name of the custom event fired before this modal is shown.
       *   Cancellation of this event stops showing the modal.
       * @property {string} [eventAfterShown]
       *   The name of the custom event telling that modal is sure shown
       *   without being canceled by the event handler named by `eventBeforeShown` option (`modal-beingshown`).
       * @property {string} [eventBeforeHidden]
       *   The name of the custom event fired before this modal is hidden.
       *   Cancellation of this event stops hiding the modal.
       * @property {string} [eventAfterHidden]
       *   The name of the custom event telling that modal is sure hidden
       *   without being canceled by the event handler named by `eventBeforeHidden` option (`modal-beinghidden`).
       */
      get: function get() {
        var prefix = settings_1.prefix;
        return {
          selectorInit: '[data-modal]',
          selectorModalClose: '[data-modal-close]',
          selectorPrimaryFocus: '[data-modal-primary-focus]',
          selectorsFloatingMenus: [".".concat(prefix, "--overflow-menu-options"), ".".concat(prefix, "--tooltip"), '.flatpickr-calendar'],
          classVisible: 'is-visible',
          classBody: "".concat(prefix, "--body--with-modal-open"),
          attribInitTarget: 'data-modal-target',
          initEventNames: ['click'],
          eventBeforeShown: 'modal-beingshown',
          eventAfterShown: 'modal-shown',
          eventBeforeHidden: 'modal-beinghidden',
          eventAfterHidden: 'modal-hidden'
        };
      }
    }]);

    Modal.components = new WeakMap();
    return Modal;
  }(mixin(createComponent, initComponentByLauncher, exports$1, handles));

  function _typeof$e(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof$e = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof$e = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof$e(obj);
  }

  function _classCallCheck$f(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$e(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$e(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$e(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$e(Constructor, staticProps);
    return Constructor;
  }

  function _possibleConstructorReturn$e(self, call) {
    if (call && (_typeof$e(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized$e(self);
  }

  function _assertThisInitialized$e(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _getPrototypeOf$e(o) {
    _getPrototypeOf$e = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf$e(o);
  }

  function _inherits$e(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf$e(subClass, superClass);
  }

  function _setPrototypeOf$e(o, p) {
    _setPrototypeOf$e = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf$e(o, p);
  }

  var Loading =
  /*#__PURE__*/
  function (_mixin) {
    _inherits$e(Loading, _mixin);
    /**
     * Spinner indicating loading state.
     * @extends CreateComponent
     * @extends InitComponentBySearch
     * @extends Handles
     * @param {HTMLElement} element The element working as a spinner.
     * @param {object} [options] The component options.
     * @param {boolean} [options.active] `true` if this spinner should roll.
     */


    function Loading(element, options) {
      var _this;

      _classCallCheck$f(this, Loading);

      _this = _possibleConstructorReturn$e(this, _getPrototypeOf$e(Loading).call(this, element, options));
      _this.active = _this.options.active; // Initialize spinner

      _this.set(_this.active);

      return _this;
    }
    /**
     * Sets active/inactive state.
     * @param {boolean} active `true` if this spinner should roll.
     */


    _createClass$e(Loading, [{
      key: "set",
      value: function set(active) {
        if (typeof active !== 'boolean') {
          throw new TypeError('set expects a boolean.');
        }

        this.active = active;
        this.element.classList.toggle(this.options.classLoadingStop, !this.active);
        /**
         * If overlay is the parentNode then toggle it too.
         */

        var parentNode = this.element.parentNode;

        if (parentNode && parentNode.classList.contains(this.options.classLoadingOverlay)) {
          parentNode.classList.toggle(this.options.classLoadingOverlayStop, !this.active);
        }

        return this;
      }
      /**
       * Toggles active/inactive state.
       */

    }, {
      key: "toggle",
      value: function toggle() {
        return this.set(!this.active);
      }
      /**
       * @returns {boolean} `true` if this spinner is rolling.
       */

    }, {
      key: "isActive",
      value: function isActive() {
        return this.active;
      }
      /**
       * Sets state to inactive and deletes the loading element.
       */

    }, {
      key: "end",
      value: function end() {
        var _this2 = this;

        this.set(false);
        var handleAnimationEnd = this.manage(on(this.element, 'animationend', function (evt) {
          if (handleAnimationEnd) {
            handleAnimationEnd = _this2.unmanage(handleAnimationEnd).release();
          }

          if (evt.animationName === 'rotate-end-p2') {
            _this2._deleteElement();
          }
        }));
      }
      /**
       * Delete component from the DOM.
       */

    }, {
      key: "_deleteElement",
      value: function _deleteElement() {
        var parentNode = this.element.parentNode;
        parentNode.removeChild(this.element);

        if (parentNode.classList.contains(this.options.selectorLoadingOverlay)) {
          parentNode.remove();
        }
      }
      /**
       * The map associating DOM element and spinner instance.
       * @member Loading.components
       * @type {WeakMap}
       */

    }], [{
      key: "options",

      /**
       * The component options.
       * If `options` is specified in the constructor, {@linkcode Loading.create .create()}, or {@linkcode Loading.init .init()},
       * properties in this object are overriden for the instance being create and how {@linkcode Loading.init .init()} works.
       * @member Loading.options
       * @type {object}
       * @property {string} selectorInit The CSS selector to find spinners.
       */
      get: function get() {
        var prefix = settings_1.prefix;
        return {
          selectorInit: '[data-loading]',
          selectorLoadingOverlay: ".".concat(prefix, "--loading-overlay"),
          classLoadingOverlay: "".concat(prefix, "--loading-overlay"),
          classLoadingStop: "".concat(prefix, "--loading--stop"),
          classLoadingOverlayStop: "".concat(prefix, "--loading-overlay--stop"),
          active: true
        };
      }
    }]);

    Loading.components = new WeakMap();
    return Loading;
  }(mixin(createComponent, initComponentBySearch, handles));

  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */

  /**
   * Toggles the given attribute of the given element.
   * @param {Element} elem The element.
   * @param {string} name The attribute name.
   * @param {boolean} add `true` to set the attribute.
   */
  function toggleAttribute(elem, name, add) {
    if (add) {
      elem.setAttribute(name, '');
    } else {
      elem.removeAttribute(name);
    }
  }

  function _typeof$f(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof$f = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof$f = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof$f(obj);
  }

  function _classCallCheck$g(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$f(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$f(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$f(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$f(Constructor, staticProps);
    return Constructor;
  }

  function _possibleConstructorReturn$f(self, call) {
    if (call && (_typeof$f(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized$f(self);
  }

  function _assertThisInitialized$f(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _getPrototypeOf$f(o) {
    _getPrototypeOf$f = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf$f(o);
  }

  function _inherits$f(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf$f(subClass, superClass);
  }

  function _setPrototypeOf$f(o, p) {
    _setPrototypeOf$f = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf$f(o, p);
  }

  var InlineLoading =
  /*#__PURE__*/
  function (_mixin) {
    _inherits$f(InlineLoading, _mixin);
    /**
     * Spinner indicating loading state.
     * @extends CreateComponent
     * @extends InitComponentBySearch
     * @extends Handles
     * @param {HTMLElement} element The element working as a spinner.
     * @param {object} [options] The component options.
     * @param {string} [options.initialState] The initial state, should be `inactive`, `active` or `finished`.
     */


    function InlineLoading(element, options) {
      var _this;

      _classCallCheck$g(this, InlineLoading);

      _this = _possibleConstructorReturn$f(this, _getPrototypeOf$f(InlineLoading).call(this, element, options)); // Sets the initial state

      var initialState = _this.options.initialState;

      if (initialState) {
        _this.setState(initialState);
      }

      return _this;
    }
    /**
     * Sets active/inactive state.
     * @param {string} state The new state, should be `inactive`, `active` or `finished`.
     */


    _createClass$f(InlineLoading, [{
      key: "setState",
      value: function setState(state) {
        var states = this.constructor.states;
        var values = Object.keys(states).map(function (key) {
          return states[key];
        });

        if (values.indexOf(state) < 0) {
          throw new Error("One of the following value should be given as the state: ".concat(values.join(', ')));
        }

        var elem = this.element;
        var _this$options = this.options,
            selectorSpinner = _this$options.selectorSpinner,
            selectorFinished = _this$options.selectorFinished,
            selectorTextActive = _this$options.selectorTextActive,
            selectorTextFinished = _this$options.selectorTextFinished;
        var spinner = elem.querySelector(selectorSpinner);
        var finished = elem.querySelector(selectorFinished);
        var textActive = elem.querySelector(selectorTextActive);
        var textFinished = elem.querySelector(selectorTextFinished);

        if (spinner) {
          spinner.classList.toggle(this.options.classLoadingStop, state !== states.ACTIVE);
          toggleAttribute(spinner, 'hidden', state === states.FINISHED);
        }

        if (finished) {
          toggleAttribute(finished, 'hidden', state !== states.FINISHED);
        }

        if (textActive) {
          toggleAttribute(textActive, 'hidden', state !== states.ACTIVE);
        }

        if (textFinished) {
          toggleAttribute(textFinished, 'hidden', state !== states.FINISHED);
        }

        return this;
      }
      /**
       * The list of states.
       * @type {Object<string, string>}
       */

    }], [{
      key: "options",

      /**
       * The component options.
       * If `options` is specified in the constructor, {@linkcode InlineLoading.create .create()},
       * or {@linkcode InlineLoading.init .init()},
       * properties in this object are overriden for the instance being create and how {@linkcode InlineLoading.init .init()} works.
       * @member InlineLoading.options
       * @type {object}
       * @property {string} selectorInit The CSS selector to find inline loading components.
       * @property {string} selectorSpinner The CSS selector to find the spinner.
       * @property {string} selectorFinished The CSS selector to find the "finished" icon.
       * @property {string} selectorTextActive The CSS selector to find the text describing the active state.
       * @property {string} selectorTextFinished The CSS selector to find the text describing the finished state.
       * @property {string} classLoadingStop The CSS class for spinner's stopped state.
       */
      get: function get() {
        var prefix = settings_1.prefix;
        return {
          selectorInit: '[data-inline-loading]',
          selectorSpinner: '[data-inline-loading-spinner]',
          selectorFinished: '[data-inline-loading-finished]',
          selectorTextActive: '[data-inline-loading-text-active]',
          selectorTextFinished: '[data-inline-loading-text-finished]',
          classLoadingStop: "".concat(prefix, "--loading--stop")
        };
      }
    }]);

    InlineLoading.states = {
      INACTIVE: 'inactive',
      ACTIVE: 'active',
      FINISHED: 'finished'
    };
    InlineLoading.components = new WeakMap();
    return InlineLoading;
  }(mixin(createComponent, initComponentBySearch, handles));

  function _typeof$g(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof$g = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof$g = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof$g(obj);
  }

  function _classCallCheck$h(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$g(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$g(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$g(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$g(Constructor, staticProps);
    return Constructor;
  }

  function _possibleConstructorReturn$g(self, call) {
    if (call && (_typeof$g(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized$g(self);
  }

  function _assertThisInitialized$g(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _getPrototypeOf$g(o) {
    _getPrototypeOf$g = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf$g(o);
  }

  function _inherits$g(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf$g(subClass, superClass);
  }

  function _setPrototypeOf$g(o, p) {
    _setPrototypeOf$g = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf$g(o, p);
  }

  var toArray$2 = function toArray(arrayLike) {
    return Array.prototype.slice.call(arrayLike);
  };

  var Dropdown =
  /*#__PURE__*/
  function (_mixin) {
    _inherits$g(Dropdown, _mixin);
    /**
     * A selector with drop downs.
     * @extends CreateComponent
     * @extends InitComponentBySearch
     * @extends TrackBlur
     * @param {HTMLElement} element The element working as a selector.
     * @param {object} [options] The component options.
     * @param {string} [options.selectorItem] The CSS selector to find clickable areas in dropdown items.
     * @param {string} [options.selectorItemSelected] The CSS selector to find the clickable area in the selected dropdown item.
     * @param {string} [options.classSelected] The CSS class for the selected dropdown item.
     * @param {string} [options.classOpen] The CSS class for the open state.
     * @param {string} [options.classDisabled] The CSS class for the disabled state.
     * @param {string} [options.eventBeforeSelected]
     *   The name of the custom event fired before a drop down item is selected.
     *   Cancellation of this event stops selection of drop down item.
     * @param {string} [options.eventAfterSelected] The name of the custom event fired after a drop down item is selected.
     */


    function Dropdown(element, options) {
      var _this;

      _classCallCheck$h(this, Dropdown);

      _this = _possibleConstructorReturn$g(this, _getPrototypeOf$g(Dropdown).call(this, element, options));

      _this.manage(on(_this.element.ownerDocument, 'click', function (event) {
        _this._toggle(event);
      }));

      _this.manage(on(_this.element, 'keydown', function (event) {
        _this._handleKeyDown(event);
      }));

      _this.manage(on(_this.element, 'click', function (event) {
        var item = eventMatches(event, _this.options.selectorItem);

        if (item) {
          _this.select(item);
        }
      }));

      return _this;
    }
    /**
     * Handles keydown event.
     * @param {Event} event The event triggering this method.
     */


    _createClass$g(Dropdown, [{
      key: "_handleKeyDown",
      value: function _handleKeyDown(event) {
        var isOpen = this.element.classList.contains(this.options.classOpen);
        var direction = {
          38: this.constructor.NAVIGATE.BACKWARD,
          40: this.constructor.NAVIGATE.FORWARD
        }[event.which];

        if (isOpen && direction !== undefined) {
          this.navigate(direction);
          event.preventDefault(); // Prevents up/down keys from scrolling container
        } else {
          this._toggle(event);
        }
      }
      /**
       * Opens and closes the dropdown menu.
       * @param {Event} [event] The event triggering this method.
       *
       * @todo https://github.com/carbon-design-system/carbon/issues/3641
       */

    }, {
      key: "_toggle",
      value: function _toggle(event) {
        var _this2 = this;

        var isDisabled = this.element.classList.contains(this.options.classDisabled);

        if (isDisabled) {
          return;
        }

        var triggerNode = this.element.querySelector(this.options.selectorTrigger);

        if ( // User presses down arrow
        event.which === 40 && !event.target.matches(this.options.selectorItem) || // User presses space or enter and the trigger is not a button
        !triggerNode && [13, 32].indexOf(event.which) >= 0 && !event.target.matches(this.options.selectorItem) || // User presses esc
        event.which === 27 || // User clicks
        event.type === 'click') {
          var isOpen = this.element.classList.contains(this.options.classOpen);
          var isOfSelf = this.element.contains(event.target); // Determine if the open className should be added, removed, or toggled

          var actions = {
            add: isOfSelf && event.which === 40 && !isOpen,
            remove: (!isOfSelf || event.which === 27) && isOpen,
            toggle: isOfSelf && event.which !== 27 && event.which !== 40
          };
          var changedState = false;
          Object.keys(actions).forEach(function (action) {
            if (actions[action]) {
              changedState = true;

              _this2.element.classList[action](_this2.options.classOpen);
            }
          });
          var listItems = toArray$2(this.element.querySelectorAll(this.options.selectorItem)); // only want to grab the listNode IF it's using the latest a11y HTML structure

          var listNode = triggerNode ? this.element.querySelector(this.options.selectorMenu) : null; // @todo remove conditionals for elements existing once legacy structure is depreciated

          if (changedState && this.element.classList.contains(this.options.classOpen)) {
            // toggled open
            if (triggerNode) {
              triggerNode.setAttribute('aria-expanded', 'true');
            }

            (listNode || this.element).focus();

            if (listNode) {
              var selectedNode = listNode.querySelector(this.options.selectorItemSelected);
              listNode.setAttribute('aria-activedescendant', (selectedNode || listItems[0]).id);
              (selectedNode || listItems[0]).classList.add(this.options.classFocused);
            }
          } else if (changedState && (isOfSelf || actions.remove)) {
            // toggled close
            (triggerNode || this.element).focus();

            if (triggerNode) {
              triggerNode.setAttribute('aria-expanded', 'false');
            }

            if (listNode) {
              listNode.removeAttribute('aria-activedescendant');
              this.element.querySelector(this.options.selectorItemFocused).classList.remove(this.options.classFocused);
            }
          } // @todo remove once legacy structure is depreciated


          if (!triggerNode) {
            listItems.forEach(function (item) {
              if (_this2.element.classList.contains(_this2.options.classOpen)) {
                item.tabIndex = 0;
              } else {
                item.tabIndex = -1;
              }
            });
          }
        }
      }
      /**
       * @returns {Element} Currently highlighted element.
       */

    }, {
      key: "getCurrentNavigation",
      value: function getCurrentNavigation() {
        var focusedNode; // Using the latest semantic markup structure where trigger is a button
        // @todo remove conditional once legacy structure is depreciated

        if (this.element.querySelector(this.options.selectorTrigger)) {
          var listNode = this.element.querySelector(this.options.selectorMenu);
          var focusedId = listNode.getAttribute('aria-activedescendant');
          focusedNode = focusedId ? listNode.querySelector("#".concat(focusedId)) : null;
        } else {
          var focused = this.element.ownerDocument.activeElement;
          focusedNode = focused.nodeType === Node.ELEMENT_NODE && focused.matches(this.options.selectorItem) ? focused : null;
        }

        return focusedNode;
      }
      /**
       * Moves up/down the focus.
       * @param {number} direction The direction of navigating.
       */
      // @todo create issue it's a better UX to move the focus when the user hovers so they stay in sync

    }, {
      key: "navigate",
      value: function navigate(direction) {
        var items = toArray$2(this.element.querySelectorAll(this.options.selectorItem));
        var start = this.getCurrentNavigation() || this.element.querySelector(this.options.selectorItemSelected);

        var getNextItem = function getNextItem(old) {
          var handleUnderflow = function handleUnderflow(i, l) {
            return i + (i >= 0 ? 0 : l);
          };

          var handleOverflow = function handleOverflow(i, l) {
            return i - (i < l ? 0 : l);
          }; // `items.indexOf(old)` may be -1 (Scenario of no previous focus)


          var index = Math.max(items.indexOf(old) + direction, -1);
          return items[handleUnderflow(handleOverflow(index, items.length), items.length)];
        };

        for (var current = getNextItem(start); current && current !== start; current = getNextItem(current)) {
          if (!current.matches(this.options.selectorItemHidden) && !current.parentNode.matches(this.options.selectorItemHidden) && !current.matches(this.options.selectorItemSelected)) {
            // Using the latest semantic markup structure where trigger is a button
            // @todo remove conditional once legacy structure is depreciated
            if (this.element.querySelector(this.options.selectorTrigger)) {
              var listNode = this.element.querySelector(this.options.selectorMenu);
              var previouslyFocused = listNode.querySelector(this.options.selectorItemFocused);
              current.classList.add(this.options.classFocused);
              listNode.setAttribute('aria-activedescendant', current.id);
              previouslyFocused.classList.remove(this.options.classFocused);
            } else {
              current.focus();
            }

            break;
          }
        }
      }
      /**
       * Handles clicking on the dropdown options, doing the following:
       * * Change Dropdown text to selected option.
       * * Remove selected option from options when selected.
       * * Emit custom events.
       * @param {HTMLElement} itemToSelect The element to be activated.
       */

    }, {
      key: "select",
      value: function select(itemToSelect) {
        var _this3 = this;

        var eventStart = new CustomEvent(this.options.eventBeforeSelected, {
          bubbles: true,
          cancelable: true,
          detail: {
            item: itemToSelect
          }
        });

        if (this.element.dispatchEvent(eventStart)) {
          if (this.element.dataset.dropdownType !== 'navigation') {
            var selectorText = !this.element.querySelector(this.options.selectorTrigger) && this.element.dataset.dropdownType !== 'inline' ? this.options.selectorText : this.options.selectorTextInner;
            var text = this.element.querySelector(selectorText);

            if (text) {
              text.innerHTML = itemToSelect.innerHTML;
            }

            itemToSelect.classList.add(this.options.classSelected);
          }

          this.element.dataset.value = itemToSelect.parentElement.dataset.value;
          toArray$2(this.element.querySelectorAll(this.options.selectorItemSelected)).forEach(function (item) {
            if (itemToSelect !== item) {
              item.classList.remove(_this3.options.classSelected);
            }
          });
          this.element.dispatchEvent(new CustomEvent(this.options.eventAfterSelected, {
            bubbles: true,
            cancelable: true,
            detail: {
              item: itemToSelect
            }
          }));
        }
      }
      /**
       * Closes the dropdown menu if this component loses focus.
       */

    }, {
      key: "handleBlur",
      value: function handleBlur() {
        this.element.classList.remove(this.options.classOpen);
      }
      /**
       * The map associating DOM element and selector instance.
       * @member Dropdown.components
       * @type {WeakMap}
       */

    }], [{
      key: "options",

      /**
       * The component options.
       * If `options` is specified in the constructor, {@linkcode Dropdown.create .create()}, or {@linkcode Dropdown.init .init()},
       * properties in this object are overridden for the instance being create and how {@linkcode Dropdown.init .init()} works.
       * @member Dropdown.options
       * @type {object}
       * @property {string} selectorInit The CSS selector to find selectors.
       * @property {string} [selectorTrigger] The CSS selector to find trigger button when using a11y compliant markup.
       * @property {string} [selectorMenu] The CSS selector to find menu list when using a11y compliant markup.
       * @property {string} [selectorText] The CSS selector to find the element showing the selected item.
       * @property {string} [selectorTextInner] The CSS selector to find the element showing the selected item, used for inline mode.
       * @property {string} [selectorItem] The CSS selector to find clickable areas in dropdown items.
       * @property {string} [selectorItemHidden]
       *   The CSS selector to find hidden dropdown items.
       *   Used to skip dropdown items for keyboard navigation.
       * @property {string} [selectorItemSelected] The CSS selector to find the clickable area in the selected dropdown item.
       * @property {string} [selectorItemFocused] The CSS selector to find the clickable area in the focused dropdown item.
       * @property {string} [classSelected] The CSS class for the selected dropdown item.
       * @property {string} [classFocused] The CSS class for the focused dropdown item.
       * @property {string} [classOpen] The CSS class for the open state.
       * @property {string} [classDisabled] The CSS class for the disabled state.
       * @property {string} [eventBeforeSelected]
       *   The name of the custom event fired before a drop down item is selected.
       *   Cancellation of this event stops selection of drop down item.
       * @property {string} [eventAfterSelected] The name of the custom event fired after a drop down item is selected.
       */
      get: function get() {
        var prefix = settings_1.prefix;
        return {
          selectorInit: '[data-dropdown]',
          selectorTrigger: "button.".concat(prefix, "--dropdown-text"),
          selectorMenu: ".".concat(prefix, "--dropdown-list"),
          selectorText: ".".concat(prefix, "--dropdown-text"),
          selectorTextInner: ".".concat(prefix, "--dropdown-text__inner"),
          selectorItem: ".".concat(prefix, "--dropdown-link"),
          selectorItemSelected: ".".concat(prefix, "--dropdown--selected"),
          selectorItemFocused: ".".concat(prefix, "--dropdown--focused"),
          selectorItemHidden: "[hidden],[aria-hidden=\"true\"]",
          classSelected: "".concat(prefix, "--dropdown--selected"),
          classFocused: "".concat(prefix, "--dropdown--focused"),
          classOpen: "".concat(prefix, "--dropdown--open"),
          classDisabled: "".concat(prefix, "--dropdown--disabled"),
          eventBeforeSelected: 'dropdown-beingselected',
          eventAfterSelected: 'dropdown-selected'
        };
      }
      /**
       * Enum for navigating backward/forward.
       * @readonly
       * @member Dropdown.NAVIGATE
       * @type {Object}
       * @property {number} BACKWARD Navigating backward.
       * @property {number} FORWARD Navigating forward.
       */

    }]);

    Dropdown.components = new WeakMap();
    Dropdown.NAVIGATE = {
      BACKWARD: -1,
      FORWARD: 1
    };
    return Dropdown;
  }(mixin(createComponent, initComponentBySearch, exports$2));

  function _typeof$h(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof$h = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof$h = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof$h(obj);
  }

  function _classCallCheck$i(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$h(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$h(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$h(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$h(Constructor, staticProps);
    return Constructor;
  }

  function _possibleConstructorReturn$h(self, call) {
    if (call && (_typeof$h(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized$h(self);
  }

  function _assertThisInitialized$h(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _getPrototypeOf$h(o) {
    _getPrototypeOf$h = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf$h(o);
  }

  function _inherits$h(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf$h(subClass, superClass);
  }

  function _setPrototypeOf$h(o, p) {
    _setPrototypeOf$h = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf$h(o, p);
  }

  var NumberInput =
  /*#__PURE__*/
  function (_mixin) {
    _inherits$h(NumberInput, _mixin);
    /**
     * Number input UI.
     * @extends CreateComponent
     * @extends InitComponentBySearch
     * @extends Handles
     * @param {HTMLElement} element The element working as a number input UI.
     */


    function NumberInput(element, options) {
      var _this;

      _classCallCheck$i(this, NumberInput);

      _this = _possibleConstructorReturn$h(this, _getPrototypeOf$h(NumberInput).call(this, element, options)); // Broken DOM tree is seen with up/down arrows <svg> in IE, which breaks event delegation.
      // <svg> does not have `Element.classList` in IE11

      _this.manage(on(_this.element.querySelector('.up-icon'), 'click', function (event) {
        _this._handleClick(event);
      }));

      _this.manage(on(_this.element.querySelector('.down-icon'), 'click', function (event) {
        _this._handleClick(event);
      }));

      return _this;
    }
    /**
     * Increase/decrease number by clicking on up/down icons.
     * @param {Event} event The event triggering this method.
     */


    _createClass$h(NumberInput, [{
      key: "_handleClick",
      value: function _handleClick(event) {
        var numberInput = this.element.querySelector(this.options.selectorInput);
        var target = event.currentTarget.getAttribute('class').split(' ');

        if (target.indexOf('up-icon') >= 0) {
          ++numberInput.value;
        } else if (target.indexOf('down-icon') >= 0) {
          --numberInput.value;
        } // Programmatic change in value (including `stepUp()`/`stepDown()`) won't fire change event


        numberInput.dispatchEvent(new CustomEvent('change', {
          bubbles: true,
          cancelable: false
        }));
      }
      /**
       * The map associating DOM element and number input UI instance.
       * @member NumberInput.components
       * @type {WeakMap}
       */

    }], [{
      key: "options",

      /**
       * The component options.
       * If `options` is specified in the constructor,
       * {@linkcode NumberInput.create .create()}, or {@linkcode NumberInput.init .init()},
       * properties in this object are overriden for the instance being create and how {@linkcode NumberInput.init .init()} works.
       * @member NumberInput.options
       * @type {object}
       * @property {string} selectorInit The CSS selector to find number input UIs.
       * @property {string} [selectorInput] The CSS selector to find the `<input>` element.
       */
      get: function get() {
        var prefix = settings_1.prefix;
        return {
          selectorInit: '[data-numberinput]',
          selectorInput: ".".concat(prefix, "--number input")
        };
      }
    }]);

    NumberInput.components = new WeakMap();
    return NumberInput;
  }(mixin(createComponent, initComponentBySearch, handles));

  function _typeof$i(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof$i = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof$i = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof$i(obj);
  }

  function _toConsumableArray$4(arr) {
    return _arrayWithoutHoles$4(arr) || _iterableToArray$4(arr) || _nonIterableSpread$4();
  }

  function _nonIterableSpread$4() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray$4(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles$4(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }

      return arr2;
    }
  }

  function _classCallCheck$j(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$i(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$i(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$i(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$i(Constructor, staticProps);
    return Constructor;
  }

  function _possibleConstructorReturn$i(self, call) {
    if (call && (_typeof$i(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized$i(self);
  }

  function _assertThisInitialized$i(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _getPrototypeOf$i(o) {
    _getPrototypeOf$i = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf$i(o);
  }

  function _inherits$i(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf$i(subClass, superClass);
  }

  function _setPrototypeOf$i(o, p) {
    _setPrototypeOf$i = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf$i(o, p);
  }

  var toArray$3 = function toArray(arrayLike) {
    return Array.prototype.slice.call(arrayLike);
  };

  var DataTable =
  /*#__PURE__*/
  function (_mixin) {
    _inherits$i(DataTable, _mixin);
    /**
     * Data Table
     * @extends CreateComponent
     * @extends InitComponentBySearch
     * @extends   EventedState
     * @param {HTMLElement} element The root element of tables
     * @param {object} [options] the... options
     * @param {string} [options.selectorInit] selector initialization
     * @param {string} [options.selectorExpandCells] css selector for expand
     * @param {string} [options.expandableRow] css selector for expand
     * @param {string} [options.selectorParentRows] css selector for rows housing expansion
     * @param {string} [options.selectorTableBody] root css for table body
     * @param {string} [options.eventTrigger] selector for event bubble capture points
     * @param {string} [options.eventParentContainer] used find the bubble container
     */


    function DataTable(_element, options) {
      var _this;

      _classCallCheck$j(this, DataTable);

      _this = _possibleConstructorReturn$i(this, _getPrototypeOf$i(DataTable).call(this, _element, options));

      _this._sortToggle = function (detail) {
        var element = detail.element,
            previousValue = detail.previousValue;
        toArray$3(_this.tableHeaders).forEach(function (header) {
          var sortEl = header.querySelector(_this.options.selectorTableSort);

          if (sortEl !== null && sortEl !== element) {
            sortEl.classList.remove(_this.options.classTableSortActive);
            sortEl.classList.remove(_this.options.classTableSortAscending);
          }
        });

        if (!previousValue) {
          element.dataset.previousValue = 'ascending';
          element.classList.add(_this.options.classTableSortActive);
          element.classList.add(_this.options.classTableSortAscending);
        } else if (previousValue === 'ascending') {
          element.dataset.previousValue = 'descending';
          element.classList.add(_this.options.classTableSortActive);
          element.classList.remove(_this.options.classTableSortAscending);
        } else if (previousValue === 'descending') {
          element.removeAttribute('data-previous-value');
          element.classList.remove(_this.options.classTableSortActive);
          element.classList.remove(_this.options.classTableSortAscending);
        }
      };

      _this._selectToggle = function (detail) {
        var element = detail.element;
        var checked = element.checked; // increment the  count

        _this.state.checkboxCount += checked ? 1 : -1;
        _this.countEl.textContent = _this.state.checkboxCount;
        var row = element.parentNode.parentNode;
        row.classList.toggle(_this.options.classTableSelected); // toggle on/off batch action bar

        _this._actionBarToggle(_this.state.checkboxCount > 0);
      };

      _this._selectAllToggle = function (_ref) {
        var element = _ref.element;
        var checked = element.checked;
        var inputs = toArray$3(_this.element.querySelectorAll(_this.options.selectorCheckbox));
        _this.state.checkboxCount = checked ? inputs.length - 1 : 0;
        inputs.forEach(function (item) {
          item.checked = checked;
          var row = item.parentNode.parentNode;

          if (checked && row) {
            row.classList.add(_this.options.classTableSelected);
          } else {
            row.classList.remove(_this.options.classTableSelected);
          }
        });

        _this._actionBarToggle(_this.state.checkboxCount > 0);

        if (_this.batchActionEl) {
          _this.countEl.textContent = _this.state.checkboxCount;
        }
      };

      _this._actionBarCancel = function () {
        var inputs = toArray$3(_this.element.querySelectorAll(_this.options.selectorCheckbox));
        var row = toArray$3(_this.element.querySelectorAll(_this.options.selectorTableSelected));
        row.forEach(function (item) {
          item.classList.remove(_this.options.classTableSelected);
        });
        inputs.forEach(function (item) {
          item.checked = false;
        });
        _this.state.checkboxCount = 0;

        _this._actionBarToggle(false);

        if (_this.batchActionEl) {
          _this.countEl.textContent = _this.state.checkboxCount;
        }
      };

      _this._actionBarToggle = function (toggleOn) {
        var transition = function transition(evt) {
          _this.batchActionEl.removeEventListener('transitionend', transition);

          if (evt.target.matches(_this.options.selectorActions)) {
            if (_this.batchActionEl.dataset.active === 'false') {
              _this.batchActionEl.setAttribute('tabIndex', -1);
            } else {
              _this.batchActionEl.setAttribute('tabIndex', 0);
            }
          }
        };

        if (toggleOn) {
          _this.batchActionEl.dataset.active = true;

          _this.batchActionEl.classList.add(_this.options.classActionBarActive);
        } else if (_this.batchActionEl) {
          _this.batchActionEl.dataset.active = false;

          _this.batchActionEl.classList.remove(_this.options.classActionBarActive);
        }

        if (_this.batchActionEl) {
          _this.batchActionEl.addEventListener('transitionend', transition);
        }
      };

      _this._rowExpandToggle = function (_ref2) {
        var element = _ref2.element,
            forceExpand = _ref2.forceExpand;
        var parent = element.closest(_this.options.eventParentContainer); // NOTE: `data-previous-value` keeps UI state before this method makes change in style
        // eslint-disable-next-line eqeqeq

        var shouldExpand = forceExpand != null ? forceExpand : element.dataset.previousValue === undefined || element.dataset.previousValue === 'expanded';

        if (shouldExpand) {
          element.dataset.previousValue = 'collapsed';
          parent.classList.add(_this.options.classExpandableRow);
        } else {
          parent.classList.remove(_this.options.classExpandableRow);
          element.dataset.previousValue = 'expanded';

          var expandHeader = _this.element.querySelector(_this.options.selectorExpandHeader);

          if (expandHeader) {
            expandHeader.dataset.previousValue = 'expanded';
          }
        }
      };

      _this._rowExpandToggleAll = function (_ref3) {
        var element = _ref3.element; // NOTE: `data-previous-value` keeps UI state before this method makes change in style

        var shouldExpand = element.dataset.previousValue === undefined || element.dataset.previousValue === 'expanded';
        element.dataset.previousValue = shouldExpand ? 'collapsed' : 'expanded';

        var expandCells = _this.element.querySelectorAll(_this.options.selectorExpandCells);

        Array.prototype.forEach.call(expandCells, function (cell) {
          _this._rowExpandToggle({
            element: cell,
            forceExpand: shouldExpand
          });
        });
      };

      _this._expandableHoverToggle = function (element) {
        element.previousElementSibling.classList.add(_this.options.classExpandableRowHover);

        var mouseout = function mouseout() {
          element.previousElementSibling.classList.remove(_this.options.classExpandableRowHover);
          element.removeEventListener('mouseout', mouseout);
        };

        element.addEventListener('mouseout', mouseout);
      };

      _this._toggleState = function (element, evt) {
        var data = element.dataset;
        var label = data.label ? data.label : '';
        var previousValue = data.previousValue ? data.previousValue : '';
        var initialEvt = evt;

        _this.changeState({
          group: data.event,
          element: element,
          label: label,
          previousValue: previousValue,
          initialEvt: initialEvt
        });
      };

      _this._keydownHandler = function (evt) {
        var searchContainer = _this.element.querySelector(_this.options.selectorToolbarSearchContainer);

        var searchEvent = eventMatches(evt, _this.options.selectorSearchMagnifier);
        var activeSearch = searchContainer.classList.contains(_this.options.classToolbarSearchActive);

        if (evt.which === 27) {
          _this._actionBarCancel();
        }

        if (searchContainer && searchEvent && evt.which === 13) {
          _this.activateSearch(searchContainer);
        }

        if (activeSearch && evt.which === 27) {
          _this.deactivateSearch(searchContainer, evt);
        }
      };

      _this.refreshRows = function () {
        var newExpandCells = toArray$3(_this.element.querySelectorAll(_this.options.selectorExpandCells));
        var newExpandableRows = toArray$3(_this.element.querySelectorAll(_this.options.selectorExpandableRows));
        var newParentRows = toArray$3(_this.element.querySelectorAll(_this.options.selectorParentRows)); // check if this is a refresh or the first time

        if (_this.parentRows.length > 0) {
          var diffParentRows = newParentRows.filter(function (newRow) {
            return !_this.parentRows.some(function (oldRow) {
              return oldRow === newRow;
            });
          }); // check if there are expandable rows

          if (newExpandableRows.length > 0) {
            var diffExpandableRows = diffParentRows.map(function (newRow) {
              return newRow.nextElementSibling;
            });
            var mergedExpandableRows = [].concat(_toConsumableArray$4(toArray$3(_this.expandableRows)), _toConsumableArray$4(toArray$3(diffExpandableRows)));
            _this.expandableRows = mergedExpandableRows;
          }
        } else if (newExpandableRows.length > 0) {
          _this.expandableRows = newExpandableRows;
        }

        _this.expandCells = newExpandCells;
        _this.parentRows = newParentRows;
      };

      _this.container = _element.parentNode;
      _this.toolbarEl = _this.element.querySelector(_this.options.selectorToolbar);
      _this.batchActionEl = _this.element.querySelector(_this.options.selectorActions);
      _this.countEl = _this.element.querySelector(_this.options.selectorCount);
      _this.cancelEl = _this.element.querySelector(_this.options.selectorActionCancel);
      _this.tableHeaders = _this.element.querySelectorAll('th');
      _this.tableBody = _this.element.querySelector(_this.options.selectorTableBody);
      _this.expandCells = [];
      _this.expandableRows = [];
      _this.parentRows = [];

      _this.refreshRows();

      _this.element.addEventListener('mouseover', function (evt) {
        var eventElement = eventMatches(evt, _this.options.selectorChildRow);

        if (eventElement) {
          _this._expandableHoverToggle(eventElement, true);
        }
      });

      _this.element.addEventListener('click', function (evt) {
        var eventElement = eventMatches(evt, _this.options.eventTrigger);

        var searchContainer = _this.element.querySelector(_this.options.selectorToolbarSearchContainer);

        if (eventElement) {
          _this._toggleState(eventElement, evt);
        }

        if (searchContainer) {
          _this._handleDocumentClick(evt);
        }
      });

      _this.element.addEventListener('keydown', _this._keydownHandler);

      _this.state = {
        checkboxCount: 0
      };
      return _this;
    }

    _createClass$i(DataTable, [{
      key: "_handleDocumentClick",
      value: function _handleDocumentClick(evt) {
        var searchContainer = this.element.querySelector(this.options.selectorToolbarSearchContainer);
        var searchEvent = eventMatches(evt, this.options.selectorSearchMagnifier);
        var activeSearch = searchContainer.classList.contains(this.options.classToolbarSearchActive);

        if (searchContainer && searchEvent) {
          this.activateSearch(searchContainer);
        }

        if (activeSearch) {
          this.deactivateSearch(searchContainer, evt);
        }
      }
    }, {
      key: "activateSearch",
      value: function activateSearch(container) {
        var input = container.querySelector(this.options.selectorSearchInput);
        container.classList.add(this.options.classToolbarSearchActive);
        input.focus();
      }
    }, {
      key: "deactivateSearch",
      value: function deactivateSearch(container, evt) {
        var trigger = container.querySelector(this.options.selectorSearchMagnifier);
        var input = container.querySelector(this.options.selectorSearchInput);
        var svg = trigger.querySelector('svg');

        if (input.value.length === 0 && evt.target !== input && evt.target !== trigger && evt.target !== svg) {
          container.classList.remove(this.options.classToolbarSearchActive);
          trigger.focus();
        }

        if (evt.which === 27 && evt.target === input) {
          container.classList.remove(this.options.classToolbarSearchActive);
          trigger.focus();
        }
      }
    }, {
      key: "_changeState",
      value: function _changeState(detail, callback) {
        this[this.constructor.eventHandlers[detail.group]](detail);
        callback();
      }
    }], [{
      key: "options",
      get: function get() {
        var prefix = settings_1.prefix;
        return {
          selectorInit: "[data-table]",
          selectorToolbar: ".".concat(prefix, "--table--toolbar"),
          selectorActions: ".".concat(prefix, "--batch-actions"),
          selectorCount: '[data-items-selected]',
          selectorActionCancel: ".".concat(prefix, "--batch-summary__cancel"),
          selectorCheckbox: ".".concat(prefix, "--checkbox"),
          selectorExpandHeader: "th.".concat(prefix, "--table-expand"),
          selectorExpandCells: "td.".concat(prefix, "--table-expand"),
          selectorExpandableRows: ".".concat(prefix, "--expandable-row"),
          selectorParentRows: ".".concat(prefix, "--parent-row"),
          selectorChildRow: '[data-child-row]',
          selectorTableBody: 'tbody',
          selectorTableSort: ".".concat(prefix, "--table-sort"),
          selectorTableSelected: ".".concat(prefix, "--data-table--selected"),
          selectorToolbarSearchContainer: ".".concat(prefix, "--toolbar-search-container-expandable"),
          selectorSearchMagnifier: ".".concat(prefix, "--search-magnifier"),
          selectorSearchInput: ".".concat(prefix, "--search-input"),
          classExpandableRow: "".concat(prefix, "--expandable-row"),
          classExpandableRowHidden: "".concat(prefix, "--expandable-row--hidden"),
          classExpandableRowHover: "".concat(prefix, "--expandable-row--hover"),
          classTableSortAscending: "".concat(prefix, "--table-sort--ascending"),
          classTableSortActive: "".concat(prefix, "--table-sort--active"),
          classToolbarSearchActive: "".concat(prefix, "--toolbar-search-container-active"),
          classActionBarActive: "".concat(prefix, "--batch-actions--active"),
          classTableSelected: "".concat(prefix, "--data-table--selected"),
          eventBeforeExpand: "data-table-beforetoggleexpand",
          eventAfterExpand: "data-table-aftertoggleexpand",
          eventBeforeExpandAll: "data-table-beforetoggleexpandall",
          eventAfterExpandAll: "data-table-aftertoggleexpandall",
          eventBeforeSort: "data-table-beforetogglesort",
          eventAfterSort: "data-table-aftertogglesort",
          eventTrigger: '[data-event]',
          eventParentContainer: '[data-parent-row]'
        };
      }
    }]);

    DataTable.components = new WeakMap();
    DataTable.eventHandlers = {
      expand: '_rowExpandToggle',
      expandAll: '_rowExpandToggleAll',
      sort: '_sortToggle',
      select: '_selectToggle',
      'select-all': '_selectAllToggle',
      'action-bar-cancel': '_actionBarCancel'
    };
    return DataTable;
  }(mixin(createComponent, initComponentBySearch, eventedState));

  var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

  function unwrapExports (x) {
  	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
  }

  function createCommonjsModule(fn, module) {
  	return module = { exports: {} }, fn(module, module.exports), module.exports;
  }

  var flatpickr = createCommonjsModule(function (module, exports) {
    /* flatpickr v4.6.1, @license MIT */
    (function (global, factory) {
       module.exports = factory() ;
    })(commonjsGlobal, function () {
      /*! *****************************************************************************
      Copyright (c) Microsoft Corporation. All rights reserved.
      Licensed under the Apache License, Version 2.0 (the "License"); you may not use
      this file except in compliance with the License. You may obtain a copy of the
      License at http://www.apache.org/licenses/LICENSE-2.0
        THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
      KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
      WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
      MERCHANTABLITY OR NON-INFRINGEMENT.
        See the Apache Version 2.0 License for specific language governing permissions
      and limitations under the License.
      ***************************************************************************** */

      var __assign = function () {
        __assign = Object.assign || function __assign(t) {
          for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];

            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
          }

          return t;
        };

        return __assign.apply(this, arguments);
      };

      var HOOKS = ["onChange", "onClose", "onDayCreate", "onDestroy", "onKeyDown", "onMonthChange", "onOpen", "onParseConfig", "onReady", "onValueUpdate", "onYearChange", "onPreCalendarPosition"];
      var defaults = {
        _disable: [],
        _enable: [],
        allowInput: false,
        altFormat: "F j, Y",
        altInput: false,
        altInputClass: "form-control input",
        animate: typeof window === "object" && window.navigator.userAgent.indexOf("MSIE") === -1,
        ariaDateFormat: "F j, Y",
        clickOpens: true,
        closeOnSelect: true,
        conjunction: ", ",
        dateFormat: "Y-m-d",
        defaultHour: 12,
        defaultMinute: 0,
        defaultSeconds: 0,
        disable: [],
        disableMobile: false,
        enable: [],
        enableSeconds: false,
        enableTime: false,
        errorHandler: function (err) {
          return typeof console !== "undefined" && console.warn(err);
        },
        getWeek: function (givenDate) {
          var date = new Date(givenDate.getTime());
          date.setHours(0, 0, 0, 0); // Thursday in current week decides the year.

          date.setDate(date.getDate() + 3 - (date.getDay() + 6) % 7); // January 4 is always in week 1.

          var week1 = new Date(date.getFullYear(), 0, 4); // Adjust to Thursday in week 1 and count number of weeks from date to week1.

          return 1 + Math.round(((date.getTime() - week1.getTime()) / 86400000 - 3 + (week1.getDay() + 6) % 7) / 7);
        },
        hourIncrement: 1,
        ignoredFocusElements: [],
        inline: false,
        locale: "default",
        minuteIncrement: 5,
        mode: "single",
        nextArrow: "<svg version='1.1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' viewBox='0 0 17 17'><g></g><path d='M13.207 8.472l-7.854 7.854-0.707-0.707 7.146-7.146-7.146-7.148 0.707-0.707 7.854 7.854z' /></svg>",
        noCalendar: false,
        now: new Date(),
        onChange: [],
        onClose: [],
        onDayCreate: [],
        onDestroy: [],
        onKeyDown: [],
        onMonthChange: [],
        onOpen: [],
        onParseConfig: [],
        onReady: [],
        onValueUpdate: [],
        onYearChange: [],
        onPreCalendarPosition: [],
        plugins: [],
        position: "auto",
        positionElement: undefined,
        prevArrow: "<svg version='1.1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' viewBox='0 0 17 17'><g></g><path d='M5.207 8.471l7.146 7.147-0.707 0.707-7.853-7.854 7.854-7.853 0.707 0.707-7.147 7.146z' /></svg>",
        shorthandCurrentMonth: false,
        showMonths: 1,
        static: false,
        time_24hr: false,
        weekNumbers: false,
        wrap: false
      };
      var english = {
        weekdays: {
          shorthand: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
          longhand: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]
        },
        months: {
          shorthand: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
          longhand: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]
        },
        daysInMonth: [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31],
        firstDayOfWeek: 0,
        ordinal: function (nth) {
          var s = nth % 100;
          if (s > 3 && s < 21) return "th";

          switch (s % 10) {
            case 1:
              return "st";

            case 2:
              return "nd";

            case 3:
              return "rd";

            default:
              return "th";
          }
        },
        rangeSeparator: " to ",
        weekAbbreviation: "Wk",
        scrollTitle: "Scroll to increment",
        toggleTitle: "Click to toggle",
        amPM: ["AM", "PM"],
        yearAriaLabel: "Year",
        time_24hr: false
      };

      var pad = function (number) {
        return ("0" + number).slice(-2);
      };

      var int = function (bool) {
        return bool === true ? 1 : 0;
      };
      /* istanbul ignore next */


      function debounce(func, wait, immediate) {
        if (immediate === void 0) {
          immediate = false;
        }

        var timeout;
        return function () {
          var context = this,
              args = arguments;
          timeout !== null && clearTimeout(timeout);
          timeout = window.setTimeout(function () {
            timeout = null;
            if (!immediate) func.apply(context, args);
          }, wait);
          if (immediate && !timeout) func.apply(context, args);
        };
      }

      var arrayify = function (obj) {
        return obj instanceof Array ? obj : [obj];
      };

      function toggleClass(elem, className, bool) {
        if (bool === true) return elem.classList.add(className);
        elem.classList.remove(className);
      }

      function createElement(tag, className, content) {
        var e = window.document.createElement(tag);
        className = className || "";
        content = content || "";
        e.className = className;
        if (content !== undefined) e.textContent = content;
        return e;
      }

      function clearNode(node) {
        while (node.firstChild) node.removeChild(node.firstChild);
      }

      function findParent(node, condition) {
        if (condition(node)) return node;else if (node.parentNode) return findParent(node.parentNode, condition);
        return undefined; // nothing found
      }

      function createNumberInput(inputClassName, opts) {
        var wrapper = createElement("div", "numInputWrapper"),
            numInput = createElement("input", "numInput " + inputClassName),
            arrowUp = createElement("span", "arrowUp"),
            arrowDown = createElement("span", "arrowDown");

        if (navigator.userAgent.indexOf("MSIE 9.0") === -1) {
          numInput.type = "number";
        } else {
          numInput.type = "text";
          numInput.pattern = "\\d*";
        }

        if (opts !== undefined) for (var key in opts) numInput.setAttribute(key, opts[key]);
        wrapper.appendChild(numInput);
        wrapper.appendChild(arrowUp);
        wrapper.appendChild(arrowDown);
        return wrapper;
      }

      function getEventTarget(event) {
        if (typeof event.composedPath === "function") {
          var path = event.composedPath();
          return path[0];
        }

        return event.target;
      }

      var doNothing = function () {
        return undefined;
      };

      var monthToStr = function (monthNumber, shorthand, locale) {
        return locale.months[shorthand ? "shorthand" : "longhand"][monthNumber];
      };

      var revFormat = {
        D: doNothing,
        F: function (dateObj, monthName, locale) {
          dateObj.setMonth(locale.months.longhand.indexOf(monthName));
        },
        G: function (dateObj, hour) {
          dateObj.setHours(parseFloat(hour));
        },
        H: function (dateObj, hour) {
          dateObj.setHours(parseFloat(hour));
        },
        J: function (dateObj, day) {
          dateObj.setDate(parseFloat(day));
        },
        K: function (dateObj, amPM, locale) {
          dateObj.setHours(dateObj.getHours() % 12 + 12 * int(new RegExp(locale.amPM[1], "i").test(amPM)));
        },
        M: function (dateObj, shortMonth, locale) {
          dateObj.setMonth(locale.months.shorthand.indexOf(shortMonth));
        },
        S: function (dateObj, seconds) {
          dateObj.setSeconds(parseFloat(seconds));
        },
        U: function (_, unixSeconds) {
          return new Date(parseFloat(unixSeconds) * 1000);
        },
        W: function (dateObj, weekNum, locale) {
          var weekNumber = parseInt(weekNum);
          var date = new Date(dateObj.getFullYear(), 0, 2 + (weekNumber - 1) * 7, 0, 0, 0, 0);
          date.setDate(date.getDate() - date.getDay() + locale.firstDayOfWeek);
          return date;
        },
        Y: function (dateObj, year) {
          dateObj.setFullYear(parseFloat(year));
        },
        Z: function (_, ISODate) {
          return new Date(ISODate);
        },
        d: function (dateObj, day) {
          dateObj.setDate(parseFloat(day));
        },
        h: function (dateObj, hour) {
          dateObj.setHours(parseFloat(hour));
        },
        i: function (dateObj, minutes) {
          dateObj.setMinutes(parseFloat(minutes));
        },
        j: function (dateObj, day) {
          dateObj.setDate(parseFloat(day));
        },
        l: doNothing,
        m: function (dateObj, month) {
          dateObj.setMonth(parseFloat(month) - 1);
        },
        n: function (dateObj, month) {
          dateObj.setMonth(parseFloat(month) - 1);
        },
        s: function (dateObj, seconds) {
          dateObj.setSeconds(parseFloat(seconds));
        },
        u: function (_, unixMillSeconds) {
          return new Date(parseFloat(unixMillSeconds));
        },
        w: doNothing,
        y: function (dateObj, year) {
          dateObj.setFullYear(2000 + parseFloat(year));
        }
      };
      var tokenRegex = {
        D: "(\\w+)",
        F: "(\\w+)",
        G: "(\\d\\d|\\d)",
        H: "(\\d\\d|\\d)",
        J: "(\\d\\d|\\d)\\w+",
        K: "",
        M: "(\\w+)",
        S: "(\\d\\d|\\d)",
        U: "(.+)",
        W: "(\\d\\d|\\d)",
        Y: "(\\d{4})",
        Z: "(.+)",
        d: "(\\d\\d|\\d)",
        h: "(\\d\\d|\\d)",
        i: "(\\d\\d|\\d)",
        j: "(\\d\\d|\\d)",
        l: "(\\w+)",
        m: "(\\d\\d|\\d)",
        n: "(\\d\\d|\\d)",
        s: "(\\d\\d|\\d)",
        u: "(.+)",
        w: "(\\d\\d|\\d)",
        y: "(\\d{2})"
      };
      var formats = {
        // get the date in UTC
        Z: function (date) {
          return date.toISOString();
        },
        // weekday name, short, e.g. Thu
        D: function (date, locale, options) {
          return locale.weekdays.shorthand[formats.w(date, locale, options)];
        },
        // full month name e.g. January
        F: function (date, locale, options) {
          return monthToStr(formats.n(date, locale, options) - 1, false, locale);
        },
        // padded hour 1-12
        G: function (date, locale, options) {
          return pad(formats.h(date, locale, options));
        },
        // hours with leading zero e.g. 03
        H: function (date) {
          return pad(date.getHours());
        },
        // day (1-30) with ordinal suffix e.g. 1st, 2nd
        J: function (date, locale) {
          return locale.ordinal !== undefined ? date.getDate() + locale.ordinal(date.getDate()) : date.getDate();
        },
        // AM/PM
        K: function (date, locale) {
          return locale.amPM[int(date.getHours() > 11)];
        },
        // shorthand month e.g. Jan, Sep, Oct, etc
        M: function (date, locale) {
          return monthToStr(date.getMonth(), true, locale);
        },
        // seconds 00-59
        S: function (date) {
          return pad(date.getSeconds());
        },
        // unix timestamp
        U: function (date) {
          return date.getTime() / 1000;
        },
        W: function (date, _, options) {
          return options.getWeek(date);
        },
        // full year e.g. 2016
        Y: function (date) {
          return date.getFullYear();
        },
        // day in month, padded (01-30)
        d: function (date) {
          return pad(date.getDate());
        },
        // hour from 1-12 (am/pm)
        h: function (date) {
          return date.getHours() % 12 ? date.getHours() % 12 : 12;
        },
        // minutes, padded with leading zero e.g. 09
        i: function (date) {
          return pad(date.getMinutes());
        },
        // day in month (1-30)
        j: function (date) {
          return date.getDate();
        },
        // weekday name, full, e.g. Thursday
        l: function (date, locale) {
          return locale.weekdays.longhand[date.getDay()];
        },
        // padded month number (01-12)
        m: function (date) {
          return pad(date.getMonth() + 1);
        },
        // the month number (1-12)
        n: function (date) {
          return date.getMonth() + 1;
        },
        // seconds 0-59
        s: function (date) {
          return date.getSeconds();
        },
        // Unix Milliseconds
        u: function (date) {
          return date.getTime();
        },
        // number of the day of the week
        w: function (date) {
          return date.getDay();
        },
        // last two digits of year e.g. 16 for 2016
        y: function (date) {
          return String(date.getFullYear()).substring(2);
        }
      };

      var createDateFormatter = function (_a) {
        var _b = _a.config,
            config = _b === void 0 ? defaults : _b,
            _c = _a.l10n,
            l10n = _c === void 0 ? english : _c;
        return function (dateObj, frmt, overrideLocale) {
          var locale = overrideLocale || l10n;

          if (config.formatDate !== undefined) {
            return config.formatDate(dateObj, frmt, locale);
          }

          return frmt.split("").map(function (c, i, arr) {
            return formats[c] && arr[i - 1] !== "\\" ? formats[c](dateObj, locale, config) : c !== "\\" ? c : "";
          }).join("");
        };
      };

      var createDateParser = function (_a) {
        var _b = _a.config,
            config = _b === void 0 ? defaults : _b,
            _c = _a.l10n,
            l10n = _c === void 0 ? english : _c;
        return function (date, givenFormat, timeless, customLocale) {
          if (date !== 0 && !date) return undefined;
          var locale = customLocale || l10n;
          var parsedDate;
          var dateOrig = date;
          if (date instanceof Date) parsedDate = new Date(date.getTime());else if (typeof date !== "string" && date.toFixed !== undefined // timestamp
          ) // create a copy
            parsedDate = new Date(date);else if (typeof date === "string") {
            // date string
            var format = givenFormat || (config || defaults).dateFormat;
            var datestr = String(date).trim();

            if (datestr === "today") {
              parsedDate = new Date();
              timeless = true;
            } else if (/Z$/.test(datestr) || /GMT$/.test(datestr) // datestrings w/ timezone
            ) parsedDate = new Date(date);else if (config && config.parseDate) parsedDate = config.parseDate(date, format);else {
              parsedDate = !config || !config.noCalendar ? new Date(new Date().getFullYear(), 0, 1, 0, 0, 0, 0) : new Date(new Date().setHours(0, 0, 0, 0));
              var matched = void 0,
                  ops = [];

              for (var i = 0, matchIndex = 0, regexStr = ""; i < format.length; i++) {
                var token_1 = format[i];
                var isBackSlash = token_1 === "\\";
                var escaped = format[i - 1] === "\\" || isBackSlash;

                if (tokenRegex[token_1] && !escaped) {
                  regexStr += tokenRegex[token_1];
                  var match = new RegExp(regexStr).exec(date);

                  if (match && (matched = true)) {
                    ops[token_1 !== "Y" ? "push" : "unshift"]({
                      fn: revFormat[token_1],
                      val: match[++matchIndex]
                    });
                  }
                } else if (!isBackSlash) regexStr += "."; // don't really care


                ops.forEach(function (_a) {
                  var fn = _a.fn,
                      val = _a.val;
                  return parsedDate = fn(parsedDate, val, locale) || parsedDate;
                });
              }

              parsedDate = matched ? parsedDate : undefined;
            }
          }
          /* istanbul ignore next */

          if (!(parsedDate instanceof Date && !isNaN(parsedDate.getTime()))) {
            config.errorHandler(new Error("Invalid date provided: " + dateOrig));
            return undefined;
          }

          if (timeless === true) parsedDate.setHours(0, 0, 0, 0);
          return parsedDate;
        };
      };
      /**
       * Compute the difference in dates, measured in ms
       */


      function compareDates(date1, date2, timeless) {
        if (timeless === void 0) {
          timeless = true;
        }

        if (timeless !== false) {
          return new Date(date1.getTime()).setHours(0, 0, 0, 0) - new Date(date2.getTime()).setHours(0, 0, 0, 0);
        }

        return date1.getTime() - date2.getTime();
      }

      var isBetween = function (ts, ts1, ts2) {
        return ts > Math.min(ts1, ts2) && ts < Math.max(ts1, ts2);
      };

      var duration = {
        DAY: 86400000
      };

      if (typeof Object.assign !== "function") {
        Object.assign = function (target) {
          var args = [];

          for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
          }

          if (!target) {
            throw TypeError("Cannot convert undefined or null to object");
          }

          var _loop_1 = function (source) {
            if (source) {
              Object.keys(source).forEach(function (key) {
                return target[key] = source[key];
              });
            }
          };

          for (var _a = 0, args_1 = args; _a < args_1.length; _a++) {
            var source = args_1[_a];

            _loop_1(source);
          }

          return target;
        };
      }

      var DEBOUNCED_CHANGE_MS = 300;

      function FlatpickrInstance(element, instanceConfig) {
        var self = {
          config: __assign({}, defaults, flatpickr.defaultConfig),
          l10n: english
        };
        self.parseDate = createDateParser({
          config: self.config,
          l10n: self.l10n
        });
        self._handlers = [];
        self.pluginElements = [];
        self.loadedPlugins = [];
        self._bind = bind;
        self._setHoursFromDate = setHoursFromDate;
        self._positionCalendar = positionCalendar;
        self.changeMonth = changeMonth;
        self.changeYear = changeYear;
        self.clear = clear;
        self.close = close;
        self._createElement = createElement;
        self.destroy = destroy;
        self.isEnabled = isEnabled;
        self.jumpToDate = jumpToDate;
        self.open = open;
        self.redraw = redraw;
        self.set = set;
        self.setDate = setDate;
        self.toggle = toggle;

        function setupHelperFunctions() {
          self.utils = {
            getDaysInMonth: function (month, yr) {
              if (month === void 0) {
                month = self.currentMonth;
              }

              if (yr === void 0) {
                yr = self.currentYear;
              }

              if (month === 1 && (yr % 4 === 0 && yr % 100 !== 0 || yr % 400 === 0)) return 29;
              return self.l10n.daysInMonth[month];
            }
          };
        }

        function init() {
          self.element = self.input = element;
          self.isOpen = false;
          parseConfig();
          setupLocale();
          setupInputs();
          setupDates();
          setupHelperFunctions();
          if (!self.isMobile) build();
          bindEvents();

          if (self.selectedDates.length || self.config.noCalendar) {
            if (self.config.enableTime) {
              setHoursFromDate(self.config.noCalendar ? self.latestSelectedDateObj || self.config.minDate : undefined);
            }

            updateValue(false);
          }

          setCalendarWidth();
          self.showTimeInput = self.selectedDates.length > 0 || self.config.noCalendar;
          var isSafari = /^((?!chrome|android).)*safari/i.test(navigator.userAgent);
          /* TODO: investigate this further
                     Currently, there is weird positioning behavior in safari causing pages
            to scroll up. https://github.com/chmln/flatpickr/issues/563
                     However, most browsers are not Safari and positioning is expensive when used
            in scale. https://github.com/chmln/flatpickr/issues/1096
          */

          if (!self.isMobile && isSafari) {
            positionCalendar();
          }

          triggerEvent("onReady");
        }

        function bindToInstance(fn) {
          return fn.bind(self);
        }

        function setCalendarWidth() {
          var config = self.config;
          if (config.weekNumbers === false && config.showMonths === 1) return;else if (config.noCalendar !== true) {
            window.requestAnimationFrame(function () {
              if (self.calendarContainer !== undefined) {
                self.calendarContainer.style.visibility = "hidden";
                self.calendarContainer.style.display = "block";
              }

              if (self.daysContainer !== undefined) {
                var daysWidth = (self.days.offsetWidth + 1) * config.showMonths;
                self.daysContainer.style.width = daysWidth + "px";
                self.calendarContainer.style.width = daysWidth + (self.weekWrapper !== undefined ? self.weekWrapper.offsetWidth : 0) + "px";
                self.calendarContainer.style.removeProperty("visibility");
                self.calendarContainer.style.removeProperty("display");
              }
            });
          }
        }
        /**
         * The handler for all events targeting the time inputs
         */


        function updateTime(e) {
          if (self.selectedDates.length === 0) {
            setDefaultTime();
          }

          if (e !== undefined && e.type !== "blur") {
            timeWrapper(e);
          }

          var prevValue = self._input.value;
          setHoursFromInputs();
          updateValue();

          if (self._input.value !== prevValue) {
            self._debouncedChange();
          }
        }

        function ampm2military(hour, amPM) {
          return hour % 12 + 12 * int(amPM === self.l10n.amPM[1]);
        }

        function military2ampm(hour) {
          switch (hour % 24) {
            case 0:
            case 12:
              return 12;

            default:
              return hour % 12;
          }
        }
        /**
         * Syncs the selected date object time with user's time input
         */


        function setHoursFromInputs() {
          if (self.hourElement === undefined || self.minuteElement === undefined) return;
          var hours = (parseInt(self.hourElement.value.slice(-2), 10) || 0) % 24,
              minutes = (parseInt(self.minuteElement.value, 10) || 0) % 60,
              seconds = self.secondElement !== undefined ? (parseInt(self.secondElement.value, 10) || 0) % 60 : 0;

          if (self.amPM !== undefined) {
            hours = ampm2military(hours, self.amPM.textContent);
          }

          var limitMinHours = self.config.minTime !== undefined || self.config.minDate && self.minDateHasTime && self.latestSelectedDateObj && compareDates(self.latestSelectedDateObj, self.config.minDate, true) === 0;
          var limitMaxHours = self.config.maxTime !== undefined || self.config.maxDate && self.maxDateHasTime && self.latestSelectedDateObj && compareDates(self.latestSelectedDateObj, self.config.maxDate, true) === 0;

          if (limitMaxHours) {
            var maxTime = self.config.maxTime !== undefined ? self.config.maxTime : self.config.maxDate;
            hours = Math.min(hours, maxTime.getHours());
            if (hours === maxTime.getHours()) minutes = Math.min(minutes, maxTime.getMinutes());
            if (minutes === maxTime.getMinutes()) seconds = Math.min(seconds, maxTime.getSeconds());
          }

          if (limitMinHours) {
            var minTime = self.config.minTime !== undefined ? self.config.minTime : self.config.minDate;
            hours = Math.max(hours, minTime.getHours());
            if (hours === minTime.getHours()) minutes = Math.max(minutes, minTime.getMinutes());
            if (minutes === minTime.getMinutes()) seconds = Math.max(seconds, minTime.getSeconds());
          }

          setHours(hours, minutes, seconds);
        }
        /**
         * Syncs time input values with a date
         */


        function setHoursFromDate(dateObj) {
          var date = dateObj || self.latestSelectedDateObj;
          if (date) setHours(date.getHours(), date.getMinutes(), date.getSeconds());
        }

        function setDefaultHours() {
          var hours = self.config.defaultHour;
          var minutes = self.config.defaultMinute;
          var seconds = self.config.defaultSeconds;

          if (self.config.minDate !== undefined) {
            var minHr = self.config.minDate.getHours();
            var minMinutes = self.config.minDate.getMinutes();
            hours = Math.max(hours, minHr);
            if (hours === minHr) minutes = Math.max(minMinutes, minutes);
            if (hours === minHr && minutes === minMinutes) seconds = self.config.minDate.getSeconds();
          }

          if (self.config.maxDate !== undefined) {
            var maxHr = self.config.maxDate.getHours();
            var maxMinutes = self.config.maxDate.getMinutes();
            hours = Math.min(hours, maxHr);
            if (hours === maxHr) minutes = Math.min(maxMinutes, minutes);
            if (hours === maxHr && minutes === maxMinutes) seconds = self.config.maxDate.getSeconds();
          }

          setHours(hours, minutes, seconds);
        }
        /**
         * Sets the hours, minutes, and optionally seconds
         * of the latest selected date object and the
         * corresponding time inputs
         * @param {Number} hours the hour. whether its military
         *                 or am-pm gets inferred from config
         * @param {Number} minutes the minutes
         * @param {Number} seconds the seconds (optional)
         */


        function setHours(hours, minutes, seconds) {
          if (self.latestSelectedDateObj !== undefined) {
            self.latestSelectedDateObj.setHours(hours % 24, minutes, seconds || 0, 0);
          }

          if (!self.hourElement || !self.minuteElement || self.isMobile) return;
          self.hourElement.value = pad(!self.config.time_24hr ? (12 + hours) % 12 + 12 * int(hours % 12 === 0) : hours);
          self.minuteElement.value = pad(minutes);
          if (self.amPM !== undefined) self.amPM.textContent = self.l10n.amPM[int(hours >= 12)];
          if (self.secondElement !== undefined) self.secondElement.value = pad(seconds);
        }
        /**
         * Handles the year input and incrementing events
         * @param {Event} event the keyup or increment event
         */


        function onYearInput(event) {
          var year = parseInt(event.target.value) + (event.delta || 0);

          if (year / 1000 > 1 || event.key === "Enter" && !/[^\d]/.test(year.toString())) {
            changeYear(year);
          }
        }
        /**
         * Essentially addEventListener + tracking
         * @param {Element} element the element to addEventListener to
         * @param {String} event the event name
         * @param {Function} handler the event handler
         */


        function bind(element, event, handler, options) {
          if (event instanceof Array) return event.forEach(function (ev) {
            return bind(element, ev, handler, options);
          });
          if (element instanceof Array) return element.forEach(function (el) {
            return bind(el, event, handler, options);
          });
          element.addEventListener(event, handler, options);

          self._handlers.push({
            element: element,
            event: event,
            handler: handler,
            options: options
          });
        }
        /**
         * A mousedown handler which mimics click.
         * Minimizes latency, since we don't need to wait for mouseup in most cases.
         * Also, avoids handling right clicks.
         *
         * @param {Function} handler the event handler
         */


        function onClick(handler) {
          return function (evt) {
            evt.which === 1 && handler(evt);
          };
        }

        function triggerChange() {
          triggerEvent("onChange");
        }
        /**
         * Adds all the necessary event listeners
         */


        function bindEvents() {
          if (self.config.wrap) {
            ["open", "close", "toggle", "clear"].forEach(function (evt) {
              Array.prototype.forEach.call(self.element.querySelectorAll("[data-" + evt + "]"), function (el) {
                return bind(el, "click", self[evt]);
              });
            });
          }

          if (self.isMobile) {
            setupMobile();
            return;
          }

          var debouncedResize = debounce(onResize, 50);
          self._debouncedChange = debounce(triggerChange, DEBOUNCED_CHANGE_MS);
          if (self.daysContainer && !/iPhone|iPad|iPod/i.test(navigator.userAgent)) bind(self.daysContainer, "mouseover", function (e) {
            if (self.config.mode === "range") onMouseOver(e.target);
          });
          bind(window.document.body, "keydown", onKeyDown);
          if (!self.config.inline && !self.config.static) bind(window, "resize", debouncedResize);
          if (window.ontouchstart !== undefined) bind(window.document, "touchstart", documentClick);else bind(window.document, "mousedown", onClick(documentClick));
          bind(window.document, "focus", documentClick, {
            capture: true
          });

          if (self.config.clickOpens === true) {
            bind(self._input, "focus", self.open);
            bind(self._input, "mousedown", onClick(self.open));
          }

          if (self.daysContainer !== undefined) {
            bind(self.monthNav, "mousedown", onClick(onMonthNavClick));
            bind(self.monthNav, ["keyup", "increment"], onYearInput);
            bind(self.daysContainer, "mousedown", onClick(selectDate));
          }

          if (self.timeContainer !== undefined && self.minuteElement !== undefined && self.hourElement !== undefined) {
            var selText = function (e) {
              return e.target.select();
            };

            bind(self.timeContainer, ["increment"], updateTime);
            bind(self.timeContainer, "blur", updateTime, {
              capture: true
            });
            bind(self.timeContainer, "mousedown", onClick(timeIncrement));
            bind([self.hourElement, self.minuteElement], ["focus", "click"], selText);
            if (self.secondElement !== undefined) bind(self.secondElement, "focus", function () {
              return self.secondElement && self.secondElement.select();
            });

            if (self.amPM !== undefined) {
              bind(self.amPM, "mousedown", onClick(function (e) {
                updateTime(e);
                triggerChange();
              }));
            }
          }
        }
        /**
         * Set the calendar view to a particular date.
         * @param {Date} jumpDate the date to set the view to
         * @param {boolean} triggerChange if change events should be triggered
         */


        function jumpToDate(jumpDate, triggerChange) {
          var jumpTo = jumpDate !== undefined ? self.parseDate(jumpDate) : self.latestSelectedDateObj || (self.config.minDate && self.config.minDate > self.now ? self.config.minDate : self.config.maxDate && self.config.maxDate < self.now ? self.config.maxDate : self.now);
          var oldYear = self.currentYear;
          var oldMonth = self.currentMonth;

          try {
            if (jumpTo !== undefined) {
              self.currentYear = jumpTo.getFullYear();
              self.currentMonth = jumpTo.getMonth();
            }
          } catch (e) {
            /* istanbul ignore next */
            e.message = "Invalid date supplied: " + jumpTo;
            self.config.errorHandler(e);
          }

          if (triggerChange && self.currentYear !== oldYear) {
            triggerEvent("onYearChange");
            buildMonthSwitch();
          }

          if (triggerChange && (self.currentYear !== oldYear || self.currentMonth !== oldMonth)) {
            triggerEvent("onMonthChange");
          }

          self.redraw();
        }
        /**
         * The up/down arrow handler for time inputs
         * @param {Event} e the click event
         */


        function timeIncrement(e) {
          if (~e.target.className.indexOf("arrow")) incrementNumInput(e, e.target.classList.contains("arrowUp") ? 1 : -1);
        }
        /**
         * Increments/decrements the value of input associ-
         * ated with the up/down arrow by dispatching an
         * "increment" event on the input.
         *
         * @param {Event} e the click event
         * @param {Number} delta the diff (usually 1 or -1)
         * @param {Element} inputElem the input element
         */


        function incrementNumInput(e, delta, inputElem) {
          var target = e && e.target;
          var input = inputElem || target && target.parentNode && target.parentNode.firstChild;
          var event = createEvent("increment");
          event.delta = delta;
          input && input.dispatchEvent(event);
        }

        function build() {
          var fragment = window.document.createDocumentFragment();
          self.calendarContainer = createElement("div", "flatpickr-calendar");
          self.calendarContainer.tabIndex = -1;

          if (!self.config.noCalendar) {
            fragment.appendChild(buildMonthNav());
            self.innerContainer = createElement("div", "flatpickr-innerContainer");

            if (self.config.weekNumbers) {
              var _a = buildWeeks(),
                  weekWrapper = _a.weekWrapper,
                  weekNumbers = _a.weekNumbers;

              self.innerContainer.appendChild(weekWrapper);
              self.weekNumbers = weekNumbers;
              self.weekWrapper = weekWrapper;
            }

            self.rContainer = createElement("div", "flatpickr-rContainer");
            self.rContainer.appendChild(buildWeekdays());

            if (!self.daysContainer) {
              self.daysContainer = createElement("div", "flatpickr-days");
              self.daysContainer.tabIndex = -1;
            }

            buildDays();
            self.rContainer.appendChild(self.daysContainer);
            self.innerContainer.appendChild(self.rContainer);
            fragment.appendChild(self.innerContainer);
          }

          if (self.config.enableTime) {
            fragment.appendChild(buildTime());
          }

          toggleClass(self.calendarContainer, "rangeMode", self.config.mode === "range");
          toggleClass(self.calendarContainer, "animate", self.config.animate === true);
          toggleClass(self.calendarContainer, "multiMonth", self.config.showMonths > 1);
          self.calendarContainer.appendChild(fragment);
          var customAppend = self.config.appendTo !== undefined && self.config.appendTo.nodeType !== undefined;

          if (self.config.inline || self.config.static) {
            self.calendarContainer.classList.add(self.config.inline ? "inline" : "static");

            if (self.config.inline) {
              if (!customAppend && self.element.parentNode) self.element.parentNode.insertBefore(self.calendarContainer, self._input.nextSibling);else if (self.config.appendTo !== undefined) self.config.appendTo.appendChild(self.calendarContainer);
            }

            if (self.config.static) {
              var wrapper = createElement("div", "flatpickr-wrapper");
              if (self.element.parentNode) self.element.parentNode.insertBefore(wrapper, self.element);
              wrapper.appendChild(self.element);
              if (self.altInput) wrapper.appendChild(self.altInput);
              wrapper.appendChild(self.calendarContainer);
            }
          }

          if (!self.config.static && !self.config.inline) (self.config.appendTo !== undefined ? self.config.appendTo : window.document.body).appendChild(self.calendarContainer);
        }

        function createDay(className, date, dayNumber, i) {
          var dateIsEnabled = isEnabled(date, true),
              dayElement = createElement("span", "flatpickr-day " + className, date.getDate().toString());
          dayElement.dateObj = date;
          dayElement.$i = i;
          dayElement.setAttribute("aria-label", self.formatDate(date, self.config.ariaDateFormat));

          if (className.indexOf("hidden") === -1 && compareDates(date, self.now) === 0) {
            self.todayDateElem = dayElement;
            dayElement.classList.add("today");
            dayElement.setAttribute("aria-current", "date");
          }

          if (dateIsEnabled) {
            dayElement.tabIndex = -1;

            if (isDateSelected(date)) {
              dayElement.classList.add("selected");
              self.selectedDateElem = dayElement;

              if (self.config.mode === "range") {
                toggleClass(dayElement, "startRange", self.selectedDates[0] && compareDates(date, self.selectedDates[0], true) === 0);
                toggleClass(dayElement, "endRange", self.selectedDates[1] && compareDates(date, self.selectedDates[1], true) === 0);
                if (className === "nextMonthDay") dayElement.classList.add("inRange");
              }
            }
          } else {
            dayElement.classList.add("flatpickr-disabled");
          }

          if (self.config.mode === "range") {
            if (isDateInRange(date) && !isDateSelected(date)) dayElement.classList.add("inRange");
          }

          if (self.weekNumbers && self.config.showMonths === 1 && className !== "prevMonthDay" && dayNumber % 7 === 1) {
            self.weekNumbers.insertAdjacentHTML("beforeend", "<span class='flatpickr-day'>" + self.config.getWeek(date) + "</span>");
          }

          triggerEvent("onDayCreate", dayElement);
          return dayElement;
        }

        function focusOnDayElem(targetNode) {
          targetNode.focus();
          if (self.config.mode === "range") onMouseOver(targetNode);
        }

        function getFirstAvailableDay(delta) {
          var startMonth = delta > 0 ? 0 : self.config.showMonths - 1;
          var endMonth = delta > 0 ? self.config.showMonths : -1;

          for (var m = startMonth; m != endMonth; m += delta) {
            var month = self.daysContainer.children[m];
            var startIndex = delta > 0 ? 0 : month.children.length - 1;
            var endIndex = delta > 0 ? month.children.length : -1;

            for (var i = startIndex; i != endIndex; i += delta) {
              var c = month.children[i];
              if (c.className.indexOf("hidden") === -1 && isEnabled(c.dateObj)) return c;
            }
          }

          return undefined;
        }

        function getNextAvailableDay(current, delta) {
          var givenMonth = current.className.indexOf("Month") === -1 ? current.dateObj.getMonth() : self.currentMonth;
          var endMonth = delta > 0 ? self.config.showMonths : -1;
          var loopDelta = delta > 0 ? 1 : -1;

          for (var m = givenMonth - self.currentMonth; m != endMonth; m += loopDelta) {
            var month = self.daysContainer.children[m];
            var startIndex = givenMonth - self.currentMonth === m ? current.$i + delta : delta < 0 ? month.children.length - 1 : 0;
            var numMonthDays = month.children.length;

            for (var i = startIndex; i >= 0 && i < numMonthDays && i != (delta > 0 ? numMonthDays : -1); i += loopDelta) {
              var c = month.children[i];
              if (c.className.indexOf("hidden") === -1 && isEnabled(c.dateObj) && Math.abs(current.$i - i) >= Math.abs(delta)) return focusOnDayElem(c);
            }
          }

          self.changeMonth(loopDelta);
          focusOnDay(getFirstAvailableDay(loopDelta), 0);
          return undefined;
        }

        function focusOnDay(current, offset) {
          var dayFocused = isInView(document.activeElement || document.body);
          var startElem = current !== undefined ? current : dayFocused ? document.activeElement : self.selectedDateElem !== undefined && isInView(self.selectedDateElem) ? self.selectedDateElem : self.todayDateElem !== undefined && isInView(self.todayDateElem) ? self.todayDateElem : getFirstAvailableDay(offset > 0 ? 1 : -1);
          if (startElem === undefined) return self._input.focus();
          if (!dayFocused) return focusOnDayElem(startElem);
          getNextAvailableDay(startElem, offset);
        }

        function buildMonthDays(year, month) {
          var firstOfMonth = (new Date(year, month, 1).getDay() - self.l10n.firstDayOfWeek + 7) % 7;
          var prevMonthDays = self.utils.getDaysInMonth((month - 1 + 12) % 12);
          var daysInMonth = self.utils.getDaysInMonth(month),
              days = window.document.createDocumentFragment(),
              isMultiMonth = self.config.showMonths > 1,
              prevMonthDayClass = isMultiMonth ? "prevMonthDay hidden" : "prevMonthDay",
              nextMonthDayClass = isMultiMonth ? "nextMonthDay hidden" : "nextMonthDay";
          var dayNumber = prevMonthDays + 1 - firstOfMonth,
              dayIndex = 0; // prepend days from the ending of previous month

          for (; dayNumber <= prevMonthDays; dayNumber++, dayIndex++) {
            days.appendChild(createDay(prevMonthDayClass, new Date(year, month - 1, dayNumber), dayNumber, dayIndex));
          } // Start at 1 since there is no 0th day


          for (dayNumber = 1; dayNumber <= daysInMonth; dayNumber++, dayIndex++) {
            days.appendChild(createDay("", new Date(year, month, dayNumber), dayNumber, dayIndex));
          } // append days from the next month


          for (var dayNum = daysInMonth + 1; dayNum <= 42 - firstOfMonth && (self.config.showMonths === 1 || dayIndex % 7 !== 0); dayNum++, dayIndex++) {
            days.appendChild(createDay(nextMonthDayClass, new Date(year, month + 1, dayNum % daysInMonth), dayNum, dayIndex));
          } //updateNavigationCurrentMonth();


          var dayContainer = createElement("div", "dayContainer");
          dayContainer.appendChild(days);
          return dayContainer;
        }

        function buildDays() {
          if (self.daysContainer === undefined) {
            return;
          }

          clearNode(self.daysContainer); // TODO: week numbers for each month

          if (self.weekNumbers) clearNode(self.weekNumbers);
          var frag = document.createDocumentFragment();

          for (var i = 0; i < self.config.showMonths; i++) {
            var d = new Date(self.currentYear, self.currentMonth, 1);
            d.setMonth(self.currentMonth + i);
            frag.appendChild(buildMonthDays(d.getFullYear(), d.getMonth()));
          }

          self.daysContainer.appendChild(frag);
          self.days = self.daysContainer.firstChild;

          if (self.config.mode === "range" && self.selectedDates.length === 1) {
            onMouseOver();
          }
        }

        function buildMonthSwitch() {
          if (self.config.showMonths > 1) return;

          var shouldBuildMonth = function (month) {
            if (self.config.minDate !== undefined && self.currentYear === self.config.minDate.getFullYear() && month < self.config.minDate.getMonth()) {
              return false;
            }

            return !(self.config.maxDate !== undefined && self.currentYear === self.config.maxDate.getFullYear() && month > self.config.maxDate.getMonth());
          };

          self.monthsDropdownContainer.tabIndex = -1;
          self.monthsDropdownContainer.innerHTML = "";

          for (var i = 0; i < 12; i++) {
            if (!shouldBuildMonth(i)) continue;
            var month = createElement("option", "flatpickr-monthDropdown-month");
            month.value = new Date(self.currentYear, i).getMonth().toString();
            month.textContent = monthToStr(i, false, self.l10n);
            month.tabIndex = -1;

            if (self.currentMonth === i) {
              month.selected = true;
            }

            self.monthsDropdownContainer.appendChild(month);
          }
        }

        function buildMonth() {
          var container = createElement("div", "flatpickr-month");
          var monthNavFragment = window.document.createDocumentFragment();
          var monthElement;

          if (self.config.showMonths > 1) {
            monthElement = createElement("span", "cur-month");
          } else {
            self.monthsDropdownContainer = createElement("select", "flatpickr-monthDropdown-months");
            bind(self.monthsDropdownContainer, "change", function (e) {
              var target = e.target;
              var selectedMonth = parseInt(target.value, 10);
              self.changeMonth(selectedMonth - self.currentMonth);
              triggerEvent("onMonthChange");
            });
            buildMonthSwitch();
            monthElement = self.monthsDropdownContainer;
          }

          var yearInput = createNumberInput("cur-year", {
            tabindex: "-1"
          });
          var yearElement = yearInput.getElementsByTagName("input")[0];
          yearElement.setAttribute("aria-label", self.l10n.yearAriaLabel);

          if (self.config.minDate) {
            yearElement.setAttribute("min", self.config.minDate.getFullYear().toString());
          }

          if (self.config.maxDate) {
            yearElement.setAttribute("max", self.config.maxDate.getFullYear().toString());
            yearElement.disabled = !!self.config.minDate && self.config.minDate.getFullYear() === self.config.maxDate.getFullYear();
          }

          var currentMonth = createElement("div", "flatpickr-current-month");
          currentMonth.appendChild(monthElement);
          currentMonth.appendChild(yearInput);
          monthNavFragment.appendChild(currentMonth);
          container.appendChild(monthNavFragment);
          return {
            container: container,
            yearElement: yearElement,
            monthElement: monthElement
          };
        }

        function buildMonths() {
          clearNode(self.monthNav);
          self.monthNav.appendChild(self.prevMonthNav);

          if (self.config.showMonths) {
            self.yearElements = [];
            self.monthElements = [];
          }

          for (var m = self.config.showMonths; m--;) {
            var month = buildMonth();
            self.yearElements.push(month.yearElement);
            self.monthElements.push(month.monthElement);
            self.monthNav.appendChild(month.container);
          }

          self.monthNav.appendChild(self.nextMonthNav);
        }

        function buildMonthNav() {
          self.monthNav = createElement("div", "flatpickr-months");
          self.yearElements = [];
          self.monthElements = [];
          self.prevMonthNav = createElement("span", "flatpickr-prev-month");
          self.prevMonthNav.innerHTML = self.config.prevArrow;
          self.nextMonthNav = createElement("span", "flatpickr-next-month");
          self.nextMonthNav.innerHTML = self.config.nextArrow;
          buildMonths();
          Object.defineProperty(self, "_hidePrevMonthArrow", {
            get: function () {
              return self.__hidePrevMonthArrow;
            },
            set: function (bool) {
              if (self.__hidePrevMonthArrow !== bool) {
                toggleClass(self.prevMonthNav, "flatpickr-disabled", bool);
                self.__hidePrevMonthArrow = bool;
              }
            }
          });
          Object.defineProperty(self, "_hideNextMonthArrow", {
            get: function () {
              return self.__hideNextMonthArrow;
            },
            set: function (bool) {
              if (self.__hideNextMonthArrow !== bool) {
                toggleClass(self.nextMonthNav, "flatpickr-disabled", bool);
                self.__hideNextMonthArrow = bool;
              }
            }
          });
          self.currentYearElement = self.yearElements[0];
          updateNavigationCurrentMonth();
          return self.monthNav;
        }

        function buildTime() {
          self.calendarContainer.classList.add("hasTime");
          if (self.config.noCalendar) self.calendarContainer.classList.add("noCalendar");
          self.timeContainer = createElement("div", "flatpickr-time");
          self.timeContainer.tabIndex = -1;
          var separator = createElement("span", "flatpickr-time-separator", ":");
          var hourInput = createNumberInput("flatpickr-hour");
          self.hourElement = hourInput.getElementsByTagName("input")[0];
          var minuteInput = createNumberInput("flatpickr-minute");
          self.minuteElement = minuteInput.getElementsByTagName("input")[0];
          self.hourElement.tabIndex = self.minuteElement.tabIndex = -1;
          self.hourElement.value = pad(self.latestSelectedDateObj ? self.latestSelectedDateObj.getHours() : self.config.time_24hr ? self.config.defaultHour : military2ampm(self.config.defaultHour));
          self.minuteElement.value = pad(self.latestSelectedDateObj ? self.latestSelectedDateObj.getMinutes() : self.config.defaultMinute);
          self.hourElement.setAttribute("step", self.config.hourIncrement.toString());
          self.minuteElement.setAttribute("step", self.config.minuteIncrement.toString());
          self.hourElement.setAttribute("min", self.config.time_24hr ? "0" : "1");
          self.hourElement.setAttribute("max", self.config.time_24hr ? "23" : "12");
          self.minuteElement.setAttribute("min", "0");
          self.minuteElement.setAttribute("max", "59");
          self.timeContainer.appendChild(hourInput);
          self.timeContainer.appendChild(separator);
          self.timeContainer.appendChild(minuteInput);
          if (self.config.time_24hr) self.timeContainer.classList.add("time24hr");

          if (self.config.enableSeconds) {
            self.timeContainer.classList.add("hasSeconds");
            var secondInput = createNumberInput("flatpickr-second");
            self.secondElement = secondInput.getElementsByTagName("input")[0];
            self.secondElement.value = pad(self.latestSelectedDateObj ? self.latestSelectedDateObj.getSeconds() : self.config.defaultSeconds);
            self.secondElement.setAttribute("step", self.minuteElement.getAttribute("step"));
            self.secondElement.setAttribute("min", "0");
            self.secondElement.setAttribute("max", "59");
            self.timeContainer.appendChild(createElement("span", "flatpickr-time-separator", ":"));
            self.timeContainer.appendChild(secondInput);
          }

          if (!self.config.time_24hr) {
            // add self.amPM if appropriate
            self.amPM = createElement("span", "flatpickr-am-pm", self.l10n.amPM[int((self.latestSelectedDateObj ? self.hourElement.value : self.config.defaultHour) > 11)]);
            self.amPM.title = self.l10n.toggleTitle;
            self.amPM.tabIndex = -1;
            self.timeContainer.appendChild(self.amPM);
          }

          return self.timeContainer;
        }

        function buildWeekdays() {
          if (!self.weekdayContainer) self.weekdayContainer = createElement("div", "flatpickr-weekdays");else clearNode(self.weekdayContainer);

          for (var i = self.config.showMonths; i--;) {
            var container = createElement("div", "flatpickr-weekdaycontainer");
            self.weekdayContainer.appendChild(container);
          }

          updateWeekdays();
          return self.weekdayContainer;
        }

        function updateWeekdays() {
          var firstDayOfWeek = self.l10n.firstDayOfWeek;
          var weekdays = self.l10n.weekdays.shorthand.slice();

          if (firstDayOfWeek > 0 && firstDayOfWeek < weekdays.length) {
            weekdays = weekdays.splice(firstDayOfWeek, weekdays.length).concat(weekdays.splice(0, firstDayOfWeek));
          }

          for (var i = self.config.showMonths; i--;) {
            self.weekdayContainer.children[i].innerHTML = "\n      <span class='flatpickr-weekday'>\n        " + weekdays.join("</span><span class='flatpickr-weekday'>") + "\n      </span>\n      ";
          }
        }
        /* istanbul ignore next */


        function buildWeeks() {
          self.calendarContainer.classList.add("hasWeeks");
          var weekWrapper = createElement("div", "flatpickr-weekwrapper");
          weekWrapper.appendChild(createElement("span", "flatpickr-weekday", self.l10n.weekAbbreviation));
          var weekNumbers = createElement("div", "flatpickr-weeks");
          weekWrapper.appendChild(weekNumbers);
          return {
            weekWrapper: weekWrapper,
            weekNumbers: weekNumbers
          };
        }

        function changeMonth(value, isOffset) {
          if (isOffset === void 0) {
            isOffset = true;
          }

          var delta = isOffset ? value : value - self.currentMonth;
          if (delta < 0 && self._hidePrevMonthArrow === true || delta > 0 && self._hideNextMonthArrow === true) return;
          self.currentMonth += delta;

          if (self.currentMonth < 0 || self.currentMonth > 11) {
            self.currentYear += self.currentMonth > 11 ? 1 : -1;
            self.currentMonth = (self.currentMonth + 12) % 12;
            triggerEvent("onYearChange");
            buildMonthSwitch();
          }

          buildDays();
          triggerEvent("onMonthChange");
          updateNavigationCurrentMonth();
        }

        function clear(triggerChangeEvent, toInitial) {
          if (triggerChangeEvent === void 0) {
            triggerChangeEvent = true;
          }

          if (toInitial === void 0) {
            toInitial = true;
          }

          self.input.value = "";
          if (self.altInput !== undefined) self.altInput.value = "";
          if (self.mobileInput !== undefined) self.mobileInput.value = "";
          self.selectedDates = [];
          self.latestSelectedDateObj = undefined;

          if (toInitial === true) {
            self.currentYear = self._initialDate.getFullYear();
            self.currentMonth = self._initialDate.getMonth();
          }

          self.showTimeInput = false;

          if (self.config.enableTime === true) {
            setDefaultHours();
          }

          self.redraw();
          if (triggerChangeEvent) // triggerChangeEvent is true (default) or an Event
            triggerEvent("onChange");
        }

        function close() {
          self.isOpen = false;

          if (!self.isMobile) {
            if (self.calendarContainer !== undefined) {
              self.calendarContainer.classList.remove("open");
            }

            if (self._input !== undefined) {
              self._input.classList.remove("active");
            }
          }

          triggerEvent("onClose");
        }

        function destroy() {
          if (self.config !== undefined) triggerEvent("onDestroy");

          for (var i = self._handlers.length; i--;) {
            var h = self._handlers[i];
            h.element.removeEventListener(h.event, h.handler, h.options);
          }

          self._handlers = [];

          if (self.mobileInput) {
            if (self.mobileInput.parentNode) self.mobileInput.parentNode.removeChild(self.mobileInput);
            self.mobileInput = undefined;
          } else if (self.calendarContainer && self.calendarContainer.parentNode) {
            if (self.config.static && self.calendarContainer.parentNode) {
              var wrapper = self.calendarContainer.parentNode;
              wrapper.lastChild && wrapper.removeChild(wrapper.lastChild);

              if (wrapper.parentNode) {
                while (wrapper.firstChild) wrapper.parentNode.insertBefore(wrapper.firstChild, wrapper);

                wrapper.parentNode.removeChild(wrapper);
              }
            } else self.calendarContainer.parentNode.removeChild(self.calendarContainer);
          }

          if (self.altInput) {
            self.input.type = "text";
            if (self.altInput.parentNode) self.altInput.parentNode.removeChild(self.altInput);
            delete self.altInput;
          }

          if (self.input) {
            self.input.type = self.input._type;
            self.input.classList.remove("flatpickr-input");
            self.input.removeAttribute("readonly");
            self.input.value = "";
          }

          ["_showTimeInput", "latestSelectedDateObj", "_hideNextMonthArrow", "_hidePrevMonthArrow", "__hideNextMonthArrow", "__hidePrevMonthArrow", "isMobile", "isOpen", "selectedDateElem", "minDateHasTime", "maxDateHasTime", "days", "daysContainer", "_input", "_positionElement", "innerContainer", "rContainer", "monthNav", "todayDateElem", "calendarContainer", "weekdayContainer", "prevMonthNav", "nextMonthNav", "monthsDropdownContainer", "currentMonthElement", "currentYearElement", "navigationCurrentMonth", "selectedDateElem", "config"].forEach(function (k) {
            try {
              delete self[k];
            } catch (_) {}
          });
        }

        function isCalendarElem(elem) {
          if (self.config.appendTo && self.config.appendTo.contains(elem)) return true;
          return self.calendarContainer.contains(elem);
        }

        function documentClick(e) {
          if (self.isOpen && !self.config.inline) {
            var eventTarget_1 = getEventTarget(e);
            var isCalendarElement = isCalendarElem(eventTarget_1);
            var isInput = eventTarget_1 === self.input || eventTarget_1 === self.altInput || self.element.contains(eventTarget_1) || // web components
            // e.path is not present in all browsers. circumventing typechecks
            e.path && e.path.indexOf && (~e.path.indexOf(self.input) || ~e.path.indexOf(self.altInput));
            var lostFocus = e.type === "blur" ? isInput && e.relatedTarget && !isCalendarElem(e.relatedTarget) : !isInput && !isCalendarElement && !isCalendarElem(e.relatedTarget);
            var isIgnored = !self.config.ignoredFocusElements.some(function (elem) {
              return elem.contains(eventTarget_1);
            });

            if (lostFocus && isIgnored) {
              self.close();

              if (self.config.mode === "range" && self.selectedDates.length === 1) {
                self.clear(false);
                self.redraw();
              }
            }
          }
        }

        function changeYear(newYear) {
          if (!newYear || self.config.minDate && newYear < self.config.minDate.getFullYear() || self.config.maxDate && newYear > self.config.maxDate.getFullYear()) return;
          var newYearNum = newYear,
              isNewYear = self.currentYear !== newYearNum;
          self.currentYear = newYearNum || self.currentYear;

          if (self.config.maxDate && self.currentYear === self.config.maxDate.getFullYear()) {
            self.currentMonth = Math.min(self.config.maxDate.getMonth(), self.currentMonth);
          } else if (self.config.minDate && self.currentYear === self.config.minDate.getFullYear()) {
            self.currentMonth = Math.max(self.config.minDate.getMonth(), self.currentMonth);
          }

          if (isNewYear) {
            self.redraw();
            triggerEvent("onYearChange");
            buildMonthSwitch();
          }
        }

        function isEnabled(date, timeless) {
          if (timeless === void 0) {
            timeless = true;
          }

          var dateToCheck = self.parseDate(date, undefined, timeless); // timeless

          if (self.config.minDate && dateToCheck && compareDates(dateToCheck, self.config.minDate, timeless !== undefined ? timeless : !self.minDateHasTime) < 0 || self.config.maxDate && dateToCheck && compareDates(dateToCheck, self.config.maxDate, timeless !== undefined ? timeless : !self.maxDateHasTime) > 0) return false;
          if (self.config.enable.length === 0 && self.config.disable.length === 0) return true;
          if (dateToCheck === undefined) return false;
          var bool = self.config.enable.length > 0,
              array = bool ? self.config.enable : self.config.disable;

          for (var i = 0, d = void 0; i < array.length; i++) {
            d = array[i];
            if (typeof d === "function" && d(dateToCheck) // disabled by function
            ) return bool;else if (d instanceof Date && dateToCheck !== undefined && d.getTime() === dateToCheck.getTime()) // disabled by date
              return bool;else if (typeof d === "string" && dateToCheck !== undefined) {
              // disabled by date string
              var parsed = self.parseDate(d, undefined, true);
              return parsed && parsed.getTime() === dateToCheck.getTime() ? bool : !bool;
            } else if ( // disabled by range
            typeof d === "object" && dateToCheck !== undefined && d.from && d.to && dateToCheck.getTime() >= d.from.getTime() && dateToCheck.getTime() <= d.to.getTime()) return bool;
          }

          return !bool;
        }

        function isInView(elem) {
          if (self.daysContainer !== undefined) return elem.className.indexOf("hidden") === -1 && self.daysContainer.contains(elem);
          return false;
        }

        function onKeyDown(e) {
          // e.key                      e.keyCode
          // "Backspace"                        8
          // "Tab"                              9
          // "Enter"                           13
          // "Escape"     (IE "Esc")           27
          // "ArrowLeft"  (IE "Left")          37
          // "ArrowUp"    (IE "Up")            38
          // "ArrowRight" (IE "Right")         39
          // "ArrowDown"  (IE "Down")          40
          // "Delete"     (IE "Del")           46
          var isInput = e.target === self._input;
          var allowInput = self.config.allowInput;
          var allowKeydown = self.isOpen && (!allowInput || !isInput);
          var allowInlineKeydown = self.config.inline && isInput && !allowInput;

          if (e.keyCode === 13 && isInput) {
            if (allowInput) {
              self.setDate(self._input.value, true, e.target === self.altInput ? self.config.altFormat : self.config.dateFormat);
              return e.target.blur();
            } else {
              self.open();
            }
          } else if (isCalendarElem(e.target) || allowKeydown || allowInlineKeydown) {
            var isTimeObj = !!self.timeContainer && self.timeContainer.contains(e.target);

            switch (e.keyCode) {
              case 13:
                if (isTimeObj) {
                  e.preventDefault();
                  updateTime();
                  focusAndClose();
                } else selectDate(e);

                break;

              case 27:
                // escape
                e.preventDefault();
                focusAndClose();
                break;

              case 8:
              case 46:
                if (isInput && !self.config.allowInput) {
                  e.preventDefault();
                  self.clear();
                }

                break;

              case 37:
              case 39:
                if (!isTimeObj && !isInput) {
                  e.preventDefault();

                  if (self.daysContainer !== undefined && (allowInput === false || document.activeElement && isInView(document.activeElement))) {
                    var delta_1 = e.keyCode === 39 ? 1 : -1;
                    if (!e.ctrlKey) focusOnDay(undefined, delta_1);else {
                      e.stopPropagation();
                      changeMonth(delta_1);
                      focusOnDay(getFirstAvailableDay(1), 0);
                    }
                  }
                } else if (self.hourElement) self.hourElement.focus();

                break;

              case 38:
              case 40:
                e.preventDefault();
                var delta = e.keyCode === 40 ? 1 : -1;

                if (self.daysContainer && e.target.$i !== undefined || e.target === self.input) {
                  if (e.ctrlKey) {
                    e.stopPropagation();
                    changeYear(self.currentYear - delta);
                    focusOnDay(getFirstAvailableDay(1), 0);
                  } else if (!isTimeObj) focusOnDay(undefined, delta * 7);
                } else if (e.target === self.currentYearElement) {
                  changeYear(self.currentYear - delta);
                } else if (self.config.enableTime) {
                  if (!isTimeObj && self.hourElement) self.hourElement.focus();
                  updateTime(e);

                  self._debouncedChange();
                }

                break;

              case 9:
                if (isTimeObj) {
                  var elems = [self.hourElement, self.minuteElement, self.secondElement, self.amPM].concat(self.pluginElements).filter(function (x) {
                    return x;
                  });
                  var i = elems.indexOf(e.target);

                  if (i !== -1) {
                    var target = elems[i + (e.shiftKey ? -1 : 1)];
                    e.preventDefault();

                    (target || self._input).focus();
                  }
                } else if (!self.config.noCalendar && self.daysContainer && self.daysContainer.contains(e.target) && e.shiftKey) {
                  e.preventDefault();

                  self._input.focus();
                }

                break;

              default:
                break;
            }
          }

          if (self.amPM !== undefined && e.target === self.amPM) {
            switch (e.key) {
              case self.l10n.amPM[0].charAt(0):
              case self.l10n.amPM[0].charAt(0).toLowerCase():
                self.amPM.textContent = self.l10n.amPM[0];
                setHoursFromInputs();
                updateValue();
                break;

              case self.l10n.amPM[1].charAt(0):
              case self.l10n.amPM[1].charAt(0).toLowerCase():
                self.amPM.textContent = self.l10n.amPM[1];
                setHoursFromInputs();
                updateValue();
                break;
            }
          }

          if (isInput || isCalendarElem(e.target)) {
            triggerEvent("onKeyDown", e);
          }
        }

        function onMouseOver(elem) {
          if (self.selectedDates.length !== 1 || elem && (!elem.classList.contains("flatpickr-day") || elem.classList.contains("flatpickr-disabled"))) return;
          var hoverDate = elem ? elem.dateObj.getTime() : self.days.firstElementChild.dateObj.getTime(),
              initialDate = self.parseDate(self.selectedDates[0], undefined, true).getTime(),
              rangeStartDate = Math.min(hoverDate, self.selectedDates[0].getTime()),
              rangeEndDate = Math.max(hoverDate, self.selectedDates[0].getTime());
          var containsDisabled = false;
          var minRange = 0,
              maxRange = 0;

          for (var t = rangeStartDate; t < rangeEndDate; t += duration.DAY) {
            if (!isEnabled(new Date(t), true)) {
              containsDisabled = containsDisabled || t > rangeStartDate && t < rangeEndDate;
              if (t < initialDate && (!minRange || t > minRange)) minRange = t;else if (t > initialDate && (!maxRange || t < maxRange)) maxRange = t;
            }
          }

          for (var m = 0; m < self.config.showMonths; m++) {
            var month = self.daysContainer.children[m];

            var _loop_1 = function (i, l) {
              var dayElem = month.children[i],
                  date = dayElem.dateObj;
              var timestamp = date.getTime();
              var outOfRange = minRange > 0 && timestamp < minRange || maxRange > 0 && timestamp > maxRange;

              if (outOfRange) {
                dayElem.classList.add("notAllowed");
                ["inRange", "startRange", "endRange"].forEach(function (c) {
                  dayElem.classList.remove(c);
                });
                return "continue";
              } else if (containsDisabled && !outOfRange) return "continue";

              ["startRange", "inRange", "endRange", "notAllowed"].forEach(function (c) {
                dayElem.classList.remove(c);
              });

              if (elem !== undefined) {
                elem.classList.add(hoverDate <= self.selectedDates[0].getTime() ? "startRange" : "endRange");
                if (initialDate < hoverDate && timestamp === initialDate) dayElem.classList.add("startRange");else if (initialDate > hoverDate && timestamp === initialDate) dayElem.classList.add("endRange");
                if (timestamp >= minRange && (maxRange === 0 || timestamp <= maxRange) && isBetween(timestamp, initialDate, hoverDate)) dayElem.classList.add("inRange");
              }
            };

            for (var i = 0, l = month.children.length; i < l; i++) {
              _loop_1(i, l);
            }
          }
        }

        function onResize() {
          if (self.isOpen && !self.config.static && !self.config.inline) positionCalendar();
        }

        function setDefaultTime() {
          self.setDate(self.config.minDate !== undefined ? new Date(self.config.minDate.getTime()) : new Date(), true);
          setDefaultHours();
          updateValue();
        }

        function open(e, positionElement) {
          if (positionElement === void 0) {
            positionElement = self._positionElement;
          }

          if (self.isMobile === true) {
            if (e) {
              e.preventDefault();
              e.target && e.target.blur();
            }

            if (self.mobileInput !== undefined) {
              self.mobileInput.focus();
              self.mobileInput.click();
            }

            triggerEvent("onOpen");
            return;
          }

          if (self._input.disabled || self.config.inline) return;
          var wasOpen = self.isOpen;
          self.isOpen = true;

          if (!wasOpen) {
            self.calendarContainer.classList.add("open");

            self._input.classList.add("active");

            triggerEvent("onOpen");
            positionCalendar(positionElement);
          }

          if (self.config.enableTime === true && self.config.noCalendar === true) {
            if (self.selectedDates.length === 0) {
              setDefaultTime();
            }

            if (self.config.allowInput === false && (e === undefined || !self.timeContainer.contains(e.relatedTarget))) {
              setTimeout(function () {
                return self.hourElement.select();
              }, 50);
            }
          }
        }

        function minMaxDateSetter(type) {
          return function (date) {
            var dateObj = self.config["_" + type + "Date"] = self.parseDate(date, self.config.dateFormat);
            var inverseDateObj = self.config["_" + (type === "min" ? "max" : "min") + "Date"];

            if (dateObj !== undefined) {
              self[type === "min" ? "minDateHasTime" : "maxDateHasTime"] = dateObj.getHours() > 0 || dateObj.getMinutes() > 0 || dateObj.getSeconds() > 0;
            }

            if (self.selectedDates) {
              self.selectedDates = self.selectedDates.filter(function (d) {
                return isEnabled(d);
              });
              if (!self.selectedDates.length && type === "min") setHoursFromDate(dateObj);
              updateValue();
            }

            if (self.daysContainer) {
              redraw();
              if (dateObj !== undefined) self.currentYearElement[type] = dateObj.getFullYear().toString();else self.currentYearElement.removeAttribute(type);
              self.currentYearElement.disabled = !!inverseDateObj && dateObj !== undefined && inverseDateObj.getFullYear() === dateObj.getFullYear();
            }
          };
        }

        function parseConfig() {
          var boolOpts = ["wrap", "weekNumbers", "allowInput", "clickOpens", "time_24hr", "enableTime", "noCalendar", "altInput", "shorthandCurrentMonth", "inline", "static", "enableSeconds", "disableMobile"];

          var userConfig = __assign({}, instanceConfig, JSON.parse(JSON.stringify(element.dataset || {})));

          var formats = {};
          self.config.parseDate = userConfig.parseDate;
          self.config.formatDate = userConfig.formatDate;
          Object.defineProperty(self.config, "enable", {
            get: function () {
              return self.config._enable;
            },
            set: function (dates) {
              self.config._enable = parseDateRules(dates);
            }
          });
          Object.defineProperty(self.config, "disable", {
            get: function () {
              return self.config._disable;
            },
            set: function (dates) {
              self.config._disable = parseDateRules(dates);
            }
          });
          var timeMode = userConfig.mode === "time";

          if (!userConfig.dateFormat && (userConfig.enableTime || timeMode)) {
            var defaultDateFormat = flatpickr.defaultConfig.dateFormat || defaults.dateFormat;
            formats.dateFormat = userConfig.noCalendar || timeMode ? "H:i" + (userConfig.enableSeconds ? ":S" : "") : defaultDateFormat + " H:i" + (userConfig.enableSeconds ? ":S" : "");
          }

          if (userConfig.altInput && (userConfig.enableTime || timeMode) && !userConfig.altFormat) {
            var defaultAltFormat = flatpickr.defaultConfig.altFormat || defaults.altFormat;
            formats.altFormat = userConfig.noCalendar || timeMode ? "h:i" + (userConfig.enableSeconds ? ":S K" : " K") : defaultAltFormat + (" h:i" + (userConfig.enableSeconds ? ":S" : "") + " K");
          }

          if (!userConfig.altInputClass) {
            self.config.altInputClass = self.input.className + " " + self.config.altInputClass;
          }

          Object.defineProperty(self.config, "minDate", {
            get: function () {
              return self.config._minDate;
            },
            set: minMaxDateSetter("min")
          });
          Object.defineProperty(self.config, "maxDate", {
            get: function () {
              return self.config._maxDate;
            },
            set: minMaxDateSetter("max")
          });

          var minMaxTimeSetter = function (type) {
            return function (val) {
              self.config[type === "min" ? "_minTime" : "_maxTime"] = self.parseDate(val, "H:i");
            };
          };

          Object.defineProperty(self.config, "minTime", {
            get: function () {
              return self.config._minTime;
            },
            set: minMaxTimeSetter("min")
          });
          Object.defineProperty(self.config, "maxTime", {
            get: function () {
              return self.config._maxTime;
            },
            set: minMaxTimeSetter("max")
          });

          if (userConfig.mode === "time") {
            self.config.noCalendar = true;
            self.config.enableTime = true;
          }

          Object.assign(self.config, formats, userConfig);

          for (var i = 0; i < boolOpts.length; i++) self.config[boolOpts[i]] = self.config[boolOpts[i]] === true || self.config[boolOpts[i]] === "true";

          HOOKS.filter(function (hook) {
            return self.config[hook] !== undefined;
          }).forEach(function (hook) {
            self.config[hook] = arrayify(self.config[hook] || []).map(bindToInstance);
          });
          self.isMobile = !self.config.disableMobile && !self.config.inline && self.config.mode === "single" && !self.config.disable.length && !self.config.enable.length && !self.config.weekNumbers && /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);

          for (var i = 0; i < self.config.plugins.length; i++) {
            var pluginConf = self.config.plugins[i](self) || {};

            for (var key in pluginConf) {
              if (HOOKS.indexOf(key) > -1) {
                self.config[key] = arrayify(pluginConf[key]).map(bindToInstance).concat(self.config[key]);
              } else if (typeof userConfig[key] === "undefined") self.config[key] = pluginConf[key];
            }
          }

          triggerEvent("onParseConfig");
        }

        function setupLocale() {
          if (typeof self.config.locale !== "object" && typeof flatpickr.l10ns[self.config.locale] === "undefined") self.config.errorHandler(new Error("flatpickr: invalid locale " + self.config.locale));
          self.l10n = __assign({}, flatpickr.l10ns["default"], typeof self.config.locale === "object" ? self.config.locale : self.config.locale !== "default" ? flatpickr.l10ns[self.config.locale] : undefined);
          tokenRegex.K = "(" + self.l10n.amPM[0] + "|" + self.l10n.amPM[1] + "|" + self.l10n.amPM[0].toLowerCase() + "|" + self.l10n.amPM[1].toLowerCase() + ")";

          var userConfig = __assign({}, instanceConfig, JSON.parse(JSON.stringify(element.dataset || {})));

          if (userConfig.time_24hr === undefined && flatpickr.defaultConfig.time_24hr === undefined) {
            self.config.time_24hr = self.l10n.time_24hr;
          }

          self.formatDate = createDateFormatter(self);
          self.parseDate = createDateParser({
            config: self.config,
            l10n: self.l10n
          });
        }

        function positionCalendar(customPositionElement) {
          if (self.calendarContainer === undefined) return;
          triggerEvent("onPreCalendarPosition");
          var positionElement = customPositionElement || self._positionElement;
          var calendarHeight = Array.prototype.reduce.call(self.calendarContainer.children, function (acc, child) {
            return acc + child.offsetHeight;
          }, 0),
              calendarWidth = self.calendarContainer.offsetWidth,
              configPos = self.config.position.split(" "),
              configPosVertical = configPos[0],
              configPosHorizontal = configPos.length > 1 ? configPos[1] : null,
              inputBounds = positionElement.getBoundingClientRect(),
              distanceFromBottom = window.innerHeight - inputBounds.bottom,
              showOnTop = configPosVertical === "above" || configPosVertical !== "below" && distanceFromBottom < calendarHeight && inputBounds.top > calendarHeight;
          var top = window.pageYOffset + inputBounds.top + (!showOnTop ? positionElement.offsetHeight + 2 : -calendarHeight - 2);
          toggleClass(self.calendarContainer, "arrowTop", !showOnTop);
          toggleClass(self.calendarContainer, "arrowBottom", showOnTop);
          if (self.config.inline) return;
          var left = window.pageXOffset + inputBounds.left - (configPosHorizontal != null && configPosHorizontal === "center" ? (calendarWidth - inputBounds.width) / 2 : 0);
          var right = window.document.body.offsetWidth - inputBounds.right;
          var rightMost = left + calendarWidth > window.document.body.offsetWidth;
          var centerMost = right + calendarWidth > window.document.body.offsetWidth;
          toggleClass(self.calendarContainer, "rightMost", rightMost);
          if (self.config.static) return;
          self.calendarContainer.style.top = top + "px";

          if (!rightMost) {
            self.calendarContainer.style.left = left + "px";
            self.calendarContainer.style.right = "auto";
          } else if (!centerMost) {
            self.calendarContainer.style.left = "auto";
            self.calendarContainer.style.right = right + "px";
          } else {
            var doc = document.styleSheets[0]; // some testing environments don't have css support

            if (doc === undefined) return;
            var bodyWidth = window.document.body.offsetWidth;
            var centerLeft = Math.max(0, bodyWidth / 2 - calendarWidth / 2);
            var centerBefore = ".flatpickr-calendar.centerMost:before";
            var centerAfter = ".flatpickr-calendar.centerMost:after";
            var centerIndex = doc.cssRules.length;
            var centerStyle = "{left:" + inputBounds.left + "px;right:auto;}";
            toggleClass(self.calendarContainer, "rightMost", false);
            toggleClass(self.calendarContainer, "centerMost", true);
            doc.insertRule(centerBefore + "," + centerAfter + centerStyle, centerIndex);
            self.calendarContainer.style.left = centerLeft + "px";
            self.calendarContainer.style.right = "auto";
          }
        }

        function redraw() {
          if (self.config.noCalendar || self.isMobile) return;
          updateNavigationCurrentMonth();
          buildDays();
        }

        function focusAndClose() {
          self._input.focus();

          if (window.navigator.userAgent.indexOf("MSIE") !== -1 || navigator.msMaxTouchPoints !== undefined) {
            // hack - bugs in the way IE handles focus keeps the calendar open
            setTimeout(self.close, 0);
          } else {
            self.close();
          }
        }

        function selectDate(e) {
          e.preventDefault();
          e.stopPropagation();

          var isSelectable = function (day) {
            return day.classList && day.classList.contains("flatpickr-day") && !day.classList.contains("flatpickr-disabled") && !day.classList.contains("notAllowed");
          };

          var t = findParent(e.target, isSelectable);
          if (t === undefined) return;
          var target = t;
          var selectedDate = self.latestSelectedDateObj = new Date(target.dateObj.getTime());
          var shouldChangeMonth = (selectedDate.getMonth() < self.currentMonth || selectedDate.getMonth() > self.currentMonth + self.config.showMonths - 1) && self.config.mode !== "range";
          self.selectedDateElem = target;
          if (self.config.mode === "single") self.selectedDates = [selectedDate];else if (self.config.mode === "multiple") {
            var selectedIndex = isDateSelected(selectedDate);
            if (selectedIndex) self.selectedDates.splice(parseInt(selectedIndex), 1);else self.selectedDates.push(selectedDate);
          } else if (self.config.mode === "range") {
            if (self.selectedDates.length === 2) {
              self.clear(false, false);
            }

            self.latestSelectedDateObj = selectedDate;
            self.selectedDates.push(selectedDate); // unless selecting same date twice, sort ascendingly

            if (compareDates(selectedDate, self.selectedDates[0], true) !== 0) self.selectedDates.sort(function (a, b) {
              return a.getTime() - b.getTime();
            });
          }
          setHoursFromInputs();

          if (shouldChangeMonth) {
            var isNewYear = self.currentYear !== selectedDate.getFullYear();
            self.currentYear = selectedDate.getFullYear();
            self.currentMonth = selectedDate.getMonth();

            if (isNewYear) {
              triggerEvent("onYearChange");
              buildMonthSwitch();
            }

            triggerEvent("onMonthChange");
          }

          updateNavigationCurrentMonth();
          buildDays();
          updateValue();
          if (self.config.enableTime) setTimeout(function () {
            return self.showTimeInput = true;
          }, 50); // maintain focus

          if (!shouldChangeMonth && self.config.mode !== "range" && self.config.showMonths === 1) focusOnDayElem(target);else if (self.selectedDateElem !== undefined && self.hourElement === undefined) {
            self.selectedDateElem && self.selectedDateElem.focus();
          }
          if (self.hourElement !== undefined) self.hourElement !== undefined && self.hourElement.focus();

          if (self.config.closeOnSelect) {
            var single = self.config.mode === "single" && !self.config.enableTime;
            var range = self.config.mode === "range" && self.selectedDates.length === 2 && !self.config.enableTime;

            if (single || range) {
              focusAndClose();
            }
          }

          triggerChange();
        }

        var CALLBACKS = {
          locale: [setupLocale, updateWeekdays],
          showMonths: [buildMonths, setCalendarWidth, buildWeekdays],
          minDate: [jumpToDate],
          maxDate: [jumpToDate]
        };

        function set(option, value) {
          if (option !== null && typeof option === "object") {
            Object.assign(self.config, option);

            for (var key in option) {
              if (CALLBACKS[key] !== undefined) CALLBACKS[key].forEach(function (x) {
                return x();
              });
            }
          } else {
            self.config[option] = value;
            if (CALLBACKS[option] !== undefined) CALLBACKS[option].forEach(function (x) {
              return x();
            });else if (HOOKS.indexOf(option) > -1) self.config[option] = arrayify(value);
          }

          self.redraw();
          updateValue(false);
        }

        function setSelectedDate(inputDate, format) {
          var dates = [];
          if (inputDate instanceof Array) dates = inputDate.map(function (d) {
            return self.parseDate(d, format);
          });else if (inputDate instanceof Date || typeof inputDate === "number") dates = [self.parseDate(inputDate, format)];else if (typeof inputDate === "string") {
            switch (self.config.mode) {
              case "single":
              case "time":
                dates = [self.parseDate(inputDate, format)];
                break;

              case "multiple":
                dates = inputDate.split(self.config.conjunction).map(function (date) {
                  return self.parseDate(date, format);
                });
                break;

              case "range":
                dates = inputDate.split(self.l10n.rangeSeparator).map(function (date) {
                  return self.parseDate(date, format);
                });
                break;

              default:
                break;
            }
          } else self.config.errorHandler(new Error("Invalid date supplied: " + JSON.stringify(inputDate)));
          self.selectedDates = dates.filter(function (d) {
            return d instanceof Date && isEnabled(d, false);
          });
          if (self.config.mode === "range") self.selectedDates.sort(function (a, b) {
            return a.getTime() - b.getTime();
          });
        }

        function setDate(date, triggerChange, format) {
          if (triggerChange === void 0) {
            triggerChange = false;
          }

          if (format === void 0) {
            format = self.config.dateFormat;
          }

          if (date !== 0 && !date || date instanceof Array && date.length === 0) return self.clear(triggerChange);
          setSelectedDate(date, format);
          self.showTimeInput = self.selectedDates.length > 0;
          self.latestSelectedDateObj = self.selectedDates[self.selectedDates.length - 1];
          self.redraw();
          jumpToDate();
          setHoursFromDate();

          if (self.selectedDates.length === 0) {
            self.clear(false);
          }

          updateValue(triggerChange);
          if (triggerChange) triggerEvent("onChange");
        }

        function parseDateRules(arr) {
          return arr.slice().map(function (rule) {
            if (typeof rule === "string" || typeof rule === "number" || rule instanceof Date) {
              return self.parseDate(rule, undefined, true);
            } else if (rule && typeof rule === "object" && rule.from && rule.to) return {
              from: self.parseDate(rule.from, undefined),
              to: self.parseDate(rule.to, undefined)
            };

            return rule;
          }).filter(function (x) {
            return x;
          }); // remove falsy values
        }

        function setupDates() {
          self.selectedDates = [];
          self.now = self.parseDate(self.config.now) || new Date(); // Workaround IE11 setting placeholder as the input's value

          var preloadedDate = self.config.defaultDate || ((self.input.nodeName === "INPUT" || self.input.nodeName === "TEXTAREA") && self.input.placeholder && self.input.value === self.input.placeholder ? null : self.input.value);
          if (preloadedDate) setSelectedDate(preloadedDate, self.config.dateFormat);
          self._initialDate = self.selectedDates.length > 0 ? self.selectedDates[0] : self.config.minDate && self.config.minDate.getTime() > self.now.getTime() ? self.config.minDate : self.config.maxDate && self.config.maxDate.getTime() < self.now.getTime() ? self.config.maxDate : self.now;
          self.currentYear = self._initialDate.getFullYear();
          self.currentMonth = self._initialDate.getMonth();
          if (self.selectedDates.length > 0) self.latestSelectedDateObj = self.selectedDates[0];
          if (self.config.minTime !== undefined) self.config.minTime = self.parseDate(self.config.minTime, "H:i");
          if (self.config.maxTime !== undefined) self.config.maxTime = self.parseDate(self.config.maxTime, "H:i");
          self.minDateHasTime = !!self.config.minDate && (self.config.minDate.getHours() > 0 || self.config.minDate.getMinutes() > 0 || self.config.minDate.getSeconds() > 0);
          self.maxDateHasTime = !!self.config.maxDate && (self.config.maxDate.getHours() > 0 || self.config.maxDate.getMinutes() > 0 || self.config.maxDate.getSeconds() > 0);
          Object.defineProperty(self, "showTimeInput", {
            get: function () {
              return self._showTimeInput;
            },
            set: function (bool) {
              self._showTimeInput = bool;
              if (self.calendarContainer) toggleClass(self.calendarContainer, "showTimeInput", bool);
              self.isOpen && positionCalendar();
            }
          });
        }

        function setupInputs() {
          self.input = self.config.wrap ? element.querySelector("[data-input]") : element;
          /* istanbul ignore next */

          if (!self.input) {
            self.config.errorHandler(new Error("Invalid input element specified"));
            return;
          } // hack: store previous type to restore it after destroy()


          self.input._type = self.input.type;
          self.input.type = "text";
          self.input.classList.add("flatpickr-input");
          self._input = self.input;

          if (self.config.altInput) {
            // replicate self.element
            self.altInput = createElement(self.input.nodeName, self.config.altInputClass);
            self._input = self.altInput;
            self.altInput.placeholder = self.input.placeholder;
            self.altInput.disabled = self.input.disabled;
            self.altInput.required = self.input.required;
            self.altInput.tabIndex = self.input.tabIndex;
            self.altInput.type = "text";
            self.input.setAttribute("type", "hidden");
            if (!self.config.static && self.input.parentNode) self.input.parentNode.insertBefore(self.altInput, self.input.nextSibling);
          }

          if (!self.config.allowInput) self._input.setAttribute("readonly", "readonly");
          self._positionElement = self.config.positionElement || self._input;
        }

        function setupMobile() {
          var inputType = self.config.enableTime ? self.config.noCalendar ? "time" : "datetime-local" : "date";
          self.mobileInput = createElement("input", self.input.className + " flatpickr-mobile");
          self.mobileInput.step = self.input.getAttribute("step") || "any";
          self.mobileInput.tabIndex = 1;
          self.mobileInput.type = inputType;
          self.mobileInput.disabled = self.input.disabled;
          self.mobileInput.required = self.input.required;
          self.mobileInput.placeholder = self.input.placeholder;
          self.mobileFormatStr = inputType === "datetime-local" ? "Y-m-d\\TH:i:S" : inputType === "date" ? "Y-m-d" : "H:i:S";

          if (self.selectedDates.length > 0) {
            self.mobileInput.defaultValue = self.mobileInput.value = self.formatDate(self.selectedDates[0], self.mobileFormatStr);
          }

          if (self.config.minDate) self.mobileInput.min = self.formatDate(self.config.minDate, "Y-m-d");
          if (self.config.maxDate) self.mobileInput.max = self.formatDate(self.config.maxDate, "Y-m-d");
          self.input.type = "hidden";
          if (self.altInput !== undefined) self.altInput.type = "hidden";

          try {
            if (self.input.parentNode) self.input.parentNode.insertBefore(self.mobileInput, self.input.nextSibling);
          } catch (_a) {}

          bind(self.mobileInput, "change", function (e) {
            self.setDate(e.target.value, false, self.mobileFormatStr);
            triggerEvent("onChange");
            triggerEvent("onClose");
          });
        }

        function toggle(e) {
          if (self.isOpen === true) return self.close();
          self.open(e);
        }

        function triggerEvent(event, data) {
          // If the instance has been destroyed already, all hooks have been removed
          if (self.config === undefined) return;
          var hooks = self.config[event];

          if (hooks !== undefined && hooks.length > 0) {
            for (var i = 0; hooks[i] && i < hooks.length; i++) hooks[i](self.selectedDates, self.input.value, self, data);
          }

          if (event === "onChange") {
            self.input.dispatchEvent(createEvent("change")); // many front-end frameworks bind to the input event

            self.input.dispatchEvent(createEvent("input"));
          }
        }

        function createEvent(name) {
          var e = document.createEvent("Event");
          e.initEvent(name, true, true);
          return e;
        }

        function isDateSelected(date) {
          for (var i = 0; i < self.selectedDates.length; i++) {
            if (compareDates(self.selectedDates[i], date) === 0) return "" + i;
          }

          return false;
        }

        function isDateInRange(date) {
          if (self.config.mode !== "range" || self.selectedDates.length < 2) return false;
          return compareDates(date, self.selectedDates[0]) >= 0 && compareDates(date, self.selectedDates[1]) <= 0;
        }

        function updateNavigationCurrentMonth() {
          if (self.config.noCalendar || self.isMobile || !self.monthNav) return;
          self.yearElements.forEach(function (yearElement, i) {
            var d = new Date(self.currentYear, self.currentMonth, 1);
            d.setMonth(self.currentMonth + i);

            if (self.config.showMonths > 1) {
              self.monthElements[i].textContent = monthToStr(d.getMonth(), self.config.shorthandCurrentMonth, self.l10n) + " ";
            } else {
              self.monthsDropdownContainer.value = d.getMonth().toString();
            }

            yearElement.value = d.getFullYear().toString();
          });
          self._hidePrevMonthArrow = self.config.minDate !== undefined && (self.currentYear === self.config.minDate.getFullYear() ? self.currentMonth <= self.config.minDate.getMonth() : self.currentYear < self.config.minDate.getFullYear());
          self._hideNextMonthArrow = self.config.maxDate !== undefined && (self.currentYear === self.config.maxDate.getFullYear() ? self.currentMonth + 1 > self.config.maxDate.getMonth() : self.currentYear > self.config.maxDate.getFullYear());
        }

        function getDateStr(format) {
          return self.selectedDates.map(function (dObj) {
            return self.formatDate(dObj, format);
          }).filter(function (d, i, arr) {
            return self.config.mode !== "range" || self.config.enableTime || arr.indexOf(d) === i;
          }).join(self.config.mode !== "range" ? self.config.conjunction : self.l10n.rangeSeparator);
        }
        /**
         * Updates the values of inputs associated with the calendar
         */


        function updateValue(triggerChange) {
          if (triggerChange === void 0) {
            triggerChange = true;
          }

          if (self.mobileInput !== undefined && self.mobileFormatStr) {
            self.mobileInput.value = self.latestSelectedDateObj !== undefined ? self.formatDate(self.latestSelectedDateObj, self.mobileFormatStr) : "";
          }

          self.input.value = getDateStr(self.config.dateFormat);

          if (self.altInput !== undefined) {
            self.altInput.value = getDateStr(self.config.altFormat);
          }

          if (triggerChange !== false) triggerEvent("onValueUpdate");
        }

        function onMonthNavClick(e) {
          var isPrevMonth = self.prevMonthNav.contains(e.target);
          var isNextMonth = self.nextMonthNav.contains(e.target);

          if (isPrevMonth || isNextMonth) {
            changeMonth(isPrevMonth ? -1 : 1);
          } else if (self.yearElements.indexOf(e.target) >= 0) {
            e.target.select();
          } else if (e.target.classList.contains("arrowUp")) {
            self.changeYear(self.currentYear + 1);
          } else if (e.target.classList.contains("arrowDown")) {
            self.changeYear(self.currentYear - 1);
          }
        }

        function timeWrapper(e) {
          e.preventDefault();
          var isKeyDown = e.type === "keydown",
              input = e.target;

          if (self.amPM !== undefined && e.target === self.amPM) {
            self.amPM.textContent = self.l10n.amPM[int(self.amPM.textContent === self.l10n.amPM[0])];
          }

          var min = parseFloat(input.getAttribute("min")),
              max = parseFloat(input.getAttribute("max")),
              step = parseFloat(input.getAttribute("step")),
              curValue = parseInt(input.value, 10),
              delta = e.delta || (isKeyDown ? e.which === 38 ? 1 : -1 : 0);
          var newValue = curValue + step * delta;

          if (typeof input.value !== "undefined" && input.value.length === 2) {
            var isHourElem = input === self.hourElement,
                isMinuteElem = input === self.minuteElement;

            if (newValue < min) {
              newValue = max + newValue + int(!isHourElem) + (int(isHourElem) && int(!self.amPM));
              if (isMinuteElem) incrementNumInput(undefined, -1, self.hourElement);
            } else if (newValue > max) {
              newValue = input === self.hourElement ? newValue - max - int(!self.amPM) : min;
              if (isMinuteElem) incrementNumInput(undefined, 1, self.hourElement);
            }

            if (self.amPM && isHourElem && (step === 1 ? newValue + curValue === 23 : Math.abs(newValue - curValue) > step)) {
              self.amPM.textContent = self.l10n.amPM[int(self.amPM.textContent === self.l10n.amPM[0])];
            }

            input.value = pad(newValue);
          }
        }

        init();
        return self;
      }
      /* istanbul ignore next */


      function _flatpickr(nodeList, config) {
        // static list
        var nodes = Array.prototype.slice.call(nodeList).filter(function (x) {
          return x instanceof HTMLElement;
        });
        var instances = [];

        for (var i = 0; i < nodes.length; i++) {
          var node = nodes[i];

          try {
            if (node.getAttribute("data-fp-omit") !== null) continue;

            if (node._flatpickr !== undefined) {
              node._flatpickr.destroy();

              node._flatpickr = undefined;
            }

            node._flatpickr = FlatpickrInstance(node, config || {});
            instances.push(node._flatpickr);
          } catch (e) {
            console.error(e);
          }
        }

        return instances.length === 1 ? instances[0] : instances;
      }
      /* istanbul ignore next */


      if (typeof HTMLElement !== "undefined" && typeof HTMLCollection !== "undefined" && typeof NodeList !== "undefined") {
        // browser env
        HTMLCollection.prototype.flatpickr = NodeList.prototype.flatpickr = function (config) {
          return _flatpickr(this, config);
        };

        HTMLElement.prototype.flatpickr = function (config) {
          return _flatpickr([this], config);
        };
      }
      /* istanbul ignore next */


      var flatpickr = function (selector, config) {
        if (typeof selector === "string") {
          return _flatpickr(window.document.querySelectorAll(selector), config);
        } else if (selector instanceof Node) {
          return _flatpickr([selector], config);
        } else {
          return _flatpickr(selector, config);
        }
      };
      /* istanbul ignore next */


      flatpickr.defaultConfig = {};
      flatpickr.l10ns = {
        en: __assign({}, english),
        "default": __assign({}, english)
      };

      flatpickr.localize = function (l10n) {
        flatpickr.l10ns["default"] = __assign({}, flatpickr.l10ns["default"], l10n);
      };

      flatpickr.setDefaults = function (config) {
        flatpickr.defaultConfig = __assign({}, flatpickr.defaultConfig, config);
      };

      flatpickr.parseDate = createDateParser({});
      flatpickr.formatDate = createDateFormatter({});
      flatpickr.compareDates = compareDates;
      /* istanbul ignore next */

      if (typeof jQuery !== "undefined" && typeof jQuery.fn !== "undefined") {
        jQuery.fn.flatpickr = function (config) {
          return _flatpickr(this, config);
        };
      } // eslint-disable-next-line @typescript-eslint/camelcase


      Date.prototype.fp_incr = function (days) {
        return new Date(this.getFullYear(), this.getMonth(), this.getDate() + (typeof days === "string" ? parseInt(days, 10) : days));
      };

      if (typeof window !== "undefined") {
        window.flatpickr = flatpickr;
      }

      return flatpickr;
    });
  });

  function _typeof$j(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof$j = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof$j = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof$j(obj);
  }

  function _classCallCheck$k(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$j(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$j(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$j(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$j(Constructor, staticProps);
    return Constructor;
  }

  function _possibleConstructorReturn$j(self, call) {
    if (call && (_typeof$j(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized$j(self);
  }

  function _assertThisInitialized$j(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _get$2(target, property, receiver) {
    if (typeof Reflect !== "undefined" && Reflect.get) {
      _get$2 = Reflect.get;
    } else {
      _get$2 = function _get(target, property, receiver) {
        var base = _superPropBase$2(target, property);

        if (!base) return;
        var desc = Object.getOwnPropertyDescriptor(base, property);

        if (desc.get) {
          return desc.get.call(receiver);
        }

        return desc.value;
      };
    }

    return _get$2(target, property, receiver || target);
  }

  function _superPropBase$2(object, property) {
    while (!Object.prototype.hasOwnProperty.call(object, property)) {
      object = _getPrototypeOf$j(object);
      if (object === null) break;
    }

    return object;
  }

  function _getPrototypeOf$j(o) {
    _getPrototypeOf$j = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf$j(o);
  }

  function _inherits$j(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf$j(subClass, superClass);
  }

  function _setPrototypeOf$j(o, p) {
    _setPrototypeOf$j = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf$j(o, p);
  }

  function _toConsumableArray$5(arr) {
    return _arrayWithoutHoles$5(arr) || _iterableToArray$5(arr) || _nonIterableSpread$5();
  }

  function _nonIterableSpread$5() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray$5(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles$5(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }

      return arr2;
    }
  }
  /* eslint no-underscore-dangle: [2, { "allow": ["_input", "_updateClassNames", "_updateInputFields"], "allowAfterThis": true }] */
  // `this.options` create-component mix-in creates prototype chain
  // so that `options` given in constructor argument wins over the one defined in static `options` property
  // 'Flatpickr' wants flat structure of object instead

  function flattenOptions(options) {
    var o = {}; // eslint-disable-next-line guard-for-in, no-restricted-syntax

    for (var key in options) {
      o[key] = options[key];
    }

    return o;
  } // Weekdays shorthand for english locale


  flatpickr.l10ns.en.weekdays.shorthand.forEach(function (day, index) {
    var currentDay = flatpickr.l10ns.en.weekdays.shorthand;

    if (currentDay[index] === 'Thu' || currentDay[index] === 'Th') {
      currentDay[index] = 'Th';
    } else {
      currentDay[index] = currentDay[index].charAt(0);
    }
  });

  var toArray$4 = function toArray(arrayLike) {
    return Array.prototype.slice.call(arrayLike);
  };
  /**
   * @param {number} monthNumber The month number.
   * @param {boolean} shorthand `true` to use shorthand month.
   * @param {Locale} locale The Flatpickr locale data.
   * @returns {string} The month string.
   */


  var monthToStr = function monthToStr(monthNumber, shorthand, locale) {
    return locale.months[shorthand ? 'shorthand' : 'longhand'][monthNumber];
  };
  /**
   * @param {object} config Plugin configuration.
   * @param {boolean} [config.shorthand] `true` to use shorthand month.
   * @param {string} config.selectorFlatpickrMonthYearContainer The CSS selector for the container of month/year selection UI.
   * @param {string} config.selectorFlatpickrYearContainer The CSS selector for the container of year selection UI.
   * @param {string} config.selectorFlatpickrCurrentMonth The CSS selector for the text-based month selection UI.
   * @param {string} config.classFlatpickrCurrentMonth The CSS class for the text-based month selection UI.
   * @returns {Plugin} A Flatpickr plugin to use text instead of `<select>` for month picker.
   */


  var carbonFlatpickrMonthSelectPlugin = function carbonFlatpickrMonthSelectPlugin(config) {
    return function (fp) {
      var setupElements = function setupElements() {
        var _fp$monthElements;

        if (!fp.monthElements) {
          return;
        }

        fp.monthElements.forEach(function (elem) {
          if (!elem.parentNode) return;
          elem.parentNode.removeChild(elem);
        });

        (_fp$monthElements = fp.monthElements).splice.apply(_fp$monthElements, [0, fp.monthElements.length].concat(_toConsumableArray$5(fp.monthElements.map(function () {
          // eslint-disable-next-line no-underscore-dangle
          var monthElement = fp._createElement('span', config.classFlatpickrCurrentMonth);

          monthElement.textContent = monthToStr(fp.currentMonth, config.shorthand === true, fp.l10n);
          fp.yearElements[0].closest(config.selectorFlatpickrMonthYearContainer).insertBefore(monthElement, fp.yearElements[0].closest(config.selectorFlatpickrYearContainer));
          return monthElement;
        }))));
      };

      var updateCurrentMonth = function updateCurrentMonth() {
        var monthStr = monthToStr(fp.currentMonth, config.shorthand === true, fp.l10n);
        fp.yearElements.forEach(function (elem) {
          var currentMonthContainer = elem.closest(config.selectorFlatpickrMonthYearContainer);
          Array.prototype.forEach.call(currentMonthContainer.querySelectorAll('.cur-month'), function (monthElement) {
            monthElement.textContent = monthStr;
          });
        });
      };

      var register = function register() {
        fp.loadedPlugins.push('carbonFlatpickrMonthSelectPlugin');
      };

      return {
        onMonthChange: updateCurrentMonth,
        onOpen: updateCurrentMonth,
        onReady: [setupElements, updateCurrentMonth, register]
      };
    };
  };

  var DatePicker =
  /*#__PURE__*/
  function (_mixin) {
    _inherits$j(DatePicker, _mixin);
    /**
     * DatePicker.
     * @extends CreateComponent
     * @extends InitComponentBySearch
     * @extends Handles
     * @param {HTMLElement} element The element working as an date picker.
     */


    function DatePicker(element, options) {
      var _this;

      _classCallCheck$k(this, DatePicker);

      _this = _possibleConstructorReturn$j(this, _getPrototypeOf$j(DatePicker).call(this, element, options));

      _this._handleFocus = function () {
        if (_this.calendar) {
          _this.calendar.open();
        }
      };

      _this._handleBlur = function (event) {
        if (_this.calendar) {
          var focusTo = event.relatedTarget;

          if (!focusTo || !_this.element.contains(focusTo) && (!_this.calendar.calendarContainer || !_this.calendar.calendarContainer.contains(focusTo))) {
            _this.calendar.close();
          }
        }
      };

      _this._initDatePicker = function (type) {
        if (type === 'range') {
          // Given FlatPickr assumes one `<input>` even in range mode,
          // use a hidden `<input>` for such purpose, separate from our from/to `<input>`s
          var doc = _this.element.ownerDocument;
          var rangeInput = doc.createElement('input');
          rangeInput.className = _this.options.classVisuallyHidden;
          rangeInput.setAttribute('aria-hidden', 'true');

          _this.element.appendChild(rangeInput);

          _this._rangeInput = rangeInput; // An attempt to open the date picker dropdown when this component gets focus,
          // and close the date picker dropdown when this component loses focus

          var w = doc.defaultView;
          var hasFocusin = 'onfocusin' in w;
          var hasFocusout = 'onfocusout' in w;
          var focusinEventName = hasFocusin ? 'focusin' : 'focus';
          var focusoutEventName = hasFocusout ? 'focusout' : 'blur';

          _this.manage(on(_this.element, focusinEventName, _this._handleFocus, !hasFocusin));

          _this.manage(on(_this.element, focusoutEventName, _this._handleBlur, !hasFocusout));

          _this.manage(on(_this.element.querySelector(_this.options.selectorDatePickerIcon), focusoutEventName, _this._handleBlur, !hasFocusout));
        }

        var self = _assertThisInitialized$j(_this);

        var date = type === 'range' ? _this._rangeInput : _this.element.querySelector(_this.options.selectorDatePickerInput);
        var _this$options = _this.options,
            _onClose = _this$options.onClose,
            _onChange = _this$options.onChange,
            _onMonthChange = _this$options.onMonthChange,
            _onYearChange = _this$options.onYearChange,
            _onOpen = _this$options.onOpen,
            _onValueUpdate = _this$options.onValueUpdate;
        var calendar = new flatpickr(date, Object.assign(flattenOptions(_this.options), {
          allowInput: true,
          mode: type,
          positionElement: type === 'range' && _this.element.querySelector(_this.options.selectorDatePickerInputFrom),
          onClose: function onClose(selectedDates) {
            // An attempt to disable Flatpickr's focus tracking system,
            // which has adverse effect with our old set up with two `<input>`s or our latest setup with a hidden `<input>`
            if (self.shouldForceOpen) {
              if (self.calendar.calendarContainer) {
                self.calendar.calendarContainer.classList.add('open');
              }

              self.calendar.isOpen = true;
            }

            for (var _len = arguments.length, remainder = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
              remainder[_key - 1] = arguments[_key];
            }

            if (!_onClose || _onClose.call.apply(_onClose, [this, selectedDates].concat(remainder)) !== false) {
              self._updateClassNames(calendar);

              self._updateInputFields(selectedDates, type);
            }
          },
          onChange: function onChange() {
            for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
              args[_key2] = arguments[_key2];
            }

            if (!_onChange || _onChange.call.apply(_onChange, [this].concat(args)) !== false) {
              self._updateClassNames(calendar);

              if (type === 'range') {
                if (calendar.selectedDates.length === 1 && calendar.isOpen) {
                  self.element.querySelector(self.options.selectorDatePickerInputTo).classList.add(self.options.classFocused);
                } else {
                  self.element.querySelector(self.options.selectorDatePickerInputTo).classList.remove(self.options.classFocused);
                }
              }
            }
          },
          onMonthChange: function onMonthChange() {
            for (var _len3 = arguments.length, args = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
              args[_key3] = arguments[_key3];
            }

            if (!_onMonthChange || _onMonthChange.call.apply(_onMonthChange, [this].concat(args)) !== false) {
              self._updateClassNames(calendar);
            }
          },
          onYearChange: function onYearChange() {
            for (var _len4 = arguments.length, args = new Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
              args[_key4] = arguments[_key4];
            }

            if (!_onYearChange || _onYearChange.call.apply(_onYearChange, [this].concat(args)) !== false) {
              self._updateClassNames(calendar);
            }
          },
          onOpen: function onOpen() {
            // An attempt to disable Flatpickr's focus tracking system,
            // which has adverse effect with our old set up with two `<input>`s or our latest setup with a hidden `<input>`
            self.shouldForceOpen = true;
            setTimeout(function () {
              self.shouldForceOpen = false;
            }, 0);

            for (var _len5 = arguments.length, args = new Array(_len5), _key5 = 0; _key5 < _len5; _key5++) {
              args[_key5] = arguments[_key5];
            }

            if (!_onOpen || _onOpen.call.apply(_onOpen, [this].concat(args)) !== false) {
              self._updateClassNames(calendar);
            }
          },
          onValueUpdate: function onValueUpdate() {
            for (var _len6 = arguments.length, args = new Array(_len6), _key6 = 0; _key6 < _len6; _key6++) {
              args[_key6] = arguments[_key6];
            }

            if ((!_onValueUpdate || _onValueUpdate.call.apply(_onValueUpdate, [this].concat(args)) !== false) && type === 'range') {
              self._updateInputFields(self.calendar.selectedDates, type);
            }
          },
          nextArrow: _this._rightArrowHTML(),
          prevArrow: _this._leftArrowHTML(),
          plugins: [].concat(_toConsumableArray$5(_this.options.plugins || []), [carbonFlatpickrMonthSelectPlugin(_this.options)])
        }));

        if (type === 'range') {
          _this._addInputLogic(_this.element.querySelector(_this.options.selectorDatePickerInputFrom), 0);

          _this._addInputLogic(_this.element.querySelector(_this.options.selectorDatePickerInputTo), 1);
        }

        _this.manage(on(_this.element.querySelector(_this.options.selectorDatePickerIcon), 'click', function () {
          calendar.open();
        }));

        _this._updateClassNames(calendar);

        if (type !== 'range') {
          _this._addInputLogic(date);
        }

        return calendar;
      };

      _this._addInputLogic = function (input, index) {
        if (!isNaN(index) && (index < 0 || index > 1)) {
          throw new RangeError("The index of <input> (".concat(index, ") is out of range."));
        }

        var inputField = input;

        _this.manage(on(inputField, 'change', function (evt) {
          if (evt.isTrusted || evt.detail && evt.detail.isNotFromFlatpickr) {
            var inputDate = _this.calendar.parseDate(inputField.value);

            if (inputDate && !isNaN(inputDate.valueOf())) {
              if (isNaN(index)) {
                _this.calendar.setDate(inputDate);
              } else {
                var selectedDates = _this.calendar.selectedDates;
                selectedDates[index] = inputDate;

                _this.calendar.setDate(selectedDates);
              }
            }
          }

          _this._updateClassNames(_this.calendar);
        })); // An attempt to temporarily set the `<input>` being edited as the one FlatPicker manages,
        // as FlatPicker attempts to take over `keydown` event handler on `document` to run on the date picker dropdown.


        _this.manage(on(inputField, 'keydown', function (evt) {
          var origInput = _this.calendar._input;
          _this.calendar._input = evt.target;
          setTimeout(function () {
            _this.calendar._input = origInput;
          });
        }));
      };

      _this._updateClassNames = function (_ref) {
        var calendarContainer = _ref.calendarContainer,
            selectedDates = _ref.selectedDates;

        if (calendarContainer) {
          calendarContainer.classList.add(_this.options.classCalendarContainer);
          calendarContainer.querySelector('.flatpickr-month').classList.add(_this.options.classMonth);
          calendarContainer.querySelector('.flatpickr-weekdays').classList.add(_this.options.classWeekdays);
          calendarContainer.querySelector('.flatpickr-days').classList.add(_this.options.classDays);
          toArray$4(calendarContainer.querySelectorAll('.flatpickr-weekday')).forEach(function (item) {
            var currentItem = item;
            currentItem.innerHTML = currentItem.innerHTML.replace(/\s+/g, '');
            currentItem.classList.add(_this.options.classWeekday);
          });
          toArray$4(calendarContainer.querySelectorAll('.flatpickr-day')).forEach(function (item) {
            item.classList.add(_this.options.classDay);

            if (item.classList.contains('today') && selectedDates.length > 0) {
              item.classList.add('no-border');
            } else if (item.classList.contains('today') && selectedDates.length === 0) {
              item.classList.remove('no-border');
            }
          });
        }
      };

      _this._updateInputFields = function (selectedDates, type) {
        if (type === 'range') {
          if (selectedDates.length === 2) {
            _this.element.querySelector(_this.options.selectorDatePickerInputFrom).value = _this._formatDate(selectedDates[0]);
            _this.element.querySelector(_this.options.selectorDatePickerInputTo).value = _this._formatDate(selectedDates[1]);
          } else if (selectedDates.length === 1) {
            _this.element.querySelector(_this.options.selectorDatePickerInputFrom).value = _this._formatDate(selectedDates[0]);
          }
        } else if (selectedDates.length === 1) {
          _this.element.querySelector(_this.options.selectorDatePickerInput).value = _this._formatDate(selectedDates[0]);
        }

        _this._updateClassNames(_this.calendar);
      };

      _this._formatDate = function (date) {
        return _this.calendar.formatDate(date, _this.calendar.config.dateFormat);
      };

      var _type = _this.element.getAttribute(_this.options.attribType);

      _this.calendar = _this._initDatePicker(_type);

      if (_this.calendar.calendarContainer) {
        _this.manage(on(_this.element, 'keydown', function (e) {
          if (e.which === 40) {
            e.preventDefault();

            (_this.calendar.selectedDateElem || _this.calendar.todayDateElem || _this.calendar.calendarContainer).focus();
          }
        }));

        _this.manage(on(_this.calendar.calendarContainer, 'keydown', function (e) {
          if (e.which === 9 && _type === 'range') {
            _this._updateClassNames(_this.calendar);

            _this.element.querySelector(_this.options.selectorDatePickerInputFrom).focus();
          }
        }));
      }

      return _this;
    }
    /**
     * Opens the date picker dropdown when this component gets focus.
     * Used only for range mode for now.
     * @private
     */


    _createClass$j(DatePicker, [{
      key: "_rightArrowHTML",
      value: function _rightArrowHTML() {
        return "\n      <svg\n        focusable=\"false\"\n        preserveAspectRatio=\"xMidYMid meet\"\n        style=\"will-change: transform;\"\n        xmlns=\"http://www.w3.org/2000/svg\"\n        width=\"16\"\n        height=\"16\"\n        viewBox=\"0 0 16 16\"\n        aria-hidden=\"true\">\n          <path d=\"M11 8l-5 5-.7-.7L9.6 8 5.3 3.7 6 3z\"></path>\n      </svg>";
      }
    }, {
      key: "_leftArrowHTML",
      value: function _leftArrowHTML() {
        return "\n      <svg\n        focusable=\"false\"\n        preserveAspectRatio=\"xMidYMid meet\"\n        style=\"will-change: transform;\"\n        xmlns=\"http://www.w3.org/2000/svg\"\n        width=\"16\"\n        height=\"16\"\n        viewBox=\"0 0 16 16\"\n        aria-hidden=\"true\"\n      >\n        <path d=\"M5 8l5-5 .7.7L6.4 8l4.3 4.3-.7.7z\"></path>\n      </svg>";
      }
    }, {
      key: "release",
      value: function release() {
        if (this._rangeInput && this._rangeInput.parentNode) {
          this._rangeInput.parentNode.removeChild(this._rangeInput);
        }

        if (this.calendar) {
          try {
            this.calendar.destroy();
          } catch (err) {} // eslint-disable-line no-empty


          this.calendar = null;
        }

        return _get$2(_getPrototypeOf$j(DatePicker.prototype), "release", this).call(this);
      }
      /**
       * The component options.
       * If `options` is specified in the constructor,
       * {@linkcode DatePicker.create .create()}, or {@linkcode DatePicker.init .init()},
       * properties in this object are overriden for the instance being create and how {@linkcode DatePicker.init .init()} works.
       * @property {string} selectorInit The CSS selector to find date picker UIs.
       */

    }], [{
      key: "options",
      get: function get() {
        var prefix = settings_1.prefix;
        return {
          selectorInit: '[data-date-picker]',
          selectorDatePickerInput: '[data-date-picker-input]',
          selectorDatePickerInputFrom: '[data-date-picker-input-from]',
          selectorDatePickerInputTo: '[data-date-picker-input-to]',
          selectorDatePickerIcon: '[data-date-picker-icon]',
          selectorFlatpickrMonthYearContainer: '.flatpickr-current-month',
          selectorFlatpickrYearContainer: '.numInputWrapper',
          selectorFlatpickrCurrentMonth: '.cur-month',
          classCalendarContainer: "".concat(prefix, "--date-picker__calendar"),
          classMonth: "".concat(prefix, "--date-picker__month"),
          classWeekdays: "".concat(prefix, "--date-picker__weekdays"),
          classDays: "".concat(prefix, "--date-picker__days"),
          classWeekday: "".concat(prefix, "--date-picker__weekday"),
          classDay: "".concat(prefix, "--date-picker__day"),
          classFocused: "".concat(prefix, "--focused"),
          classVisuallyHidden: "".concat(prefix, "--visually-hidden"),
          classFlatpickrCurrentMonth: 'cur-month',
          attribType: 'data-date-picker-type',
          dateFormat: 'm/d/Y'
        };
      }
      /**
       * The map associating DOM element and date picker UI instance.
       * @type {WeakMap}
       */

    }]);

    DatePicker.components = new WeakMap();
    return DatePicker;
  }(mixin(createComponent, initComponentBySearch, handles));

  function _typeof$k(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof$k = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof$k = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof$k(obj);
  }

  function _classCallCheck$l(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _possibleConstructorReturn$k(self, call) {
    if (call && (_typeof$k(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized$k(self);
  }

  function _assertThisInitialized$k(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _getPrototypeOf$k(o) {
    _getPrototypeOf$k = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf$k(o);
  }

  function _inherits$k(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf$k(subClass, superClass);
  }

  function _setPrototypeOf$k(o, p) {
    _setPrototypeOf$k = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf$k(o, p);
  }

  var Pagination =
  /*#__PURE__*/
  function (_mixin) {
    _inherits$k(Pagination, _mixin);
    /**
     * Pagination component.
     * @extends CreateComponent
     * @extends InitComponentBySearch
     * @param {HTMLElement} element The element working as a pagination component.
     * @param {object} [options] The component options.
     * @property {string} [selectorInit] The CSS selector to find pagination components.
     * @property {string} [selectorItemsPerPageInput]
     *   The CSS selector to find the input that determines the number of items per page.
     * @property {string} [selectorPageNumberInput] The CSS selector to find the input that changes the page displayed.
     * @property {string} [selectorPageBackward] The CSS selector to find the button that goes back a page.
     * @property {string} [selectorPageForward] The CSS selector to find the button that goes forward a page.
     * @property {string} [eventItemsPerPage]
     *   The name of the custom event fired when a user changes the number of items per page.
     *   event.detail.value contains the number of items a user wishes to see.
     * @property {string} [eventPageNumber]
     *   The name of the custom event fired when a user inputs a specific page number.
     *   event.detail.value contains the value that the user input.
     * @property {string} [eventPageChange]
     *   The name of the custom event fired when a user goes forward or backward a page.
     *   event.detail.direction contains the direction a user wishes to go.
     */


    function Pagination(element, options) {
      var _this;

      _classCallCheck$l(this, Pagination);

      _this = _possibleConstructorReturn$k(this, _getPrototypeOf$k(Pagination).call(this, element, options));

      _this._emitEvent = function (evtName, detail) {
        var event = new CustomEvent("".concat(evtName), {
          bubbles: true,
          cancelable: true,
          detail: detail
        });

        _this.element.dispatchEvent(event);
      };

      _this.manage(on(_this.element, 'click', function (evt) {
        if (eventMatches(evt, _this.options.selectorPageBackward)) {
          var detail = {
            initialEvt: evt,
            element: evt.target,
            direction: 'backward'
          };

          _this._emitEvent(_this.options.eventPageChange, detail);
        } else if (eventMatches(evt, _this.options.selectorPageForward)) {
          var _detail = {
            initialEvt: evt,
            element: evt.target,
            direction: 'forward'
          };

          _this._emitEvent(_this.options.eventPageChange, _detail);
        }
      }));

      _this.manage(on(_this.element, 'input', function (evt) {
        if (eventMatches(evt, _this.options.selectorItemsPerPageInput)) {
          var detail = {
            initialEvt: evt,
            element: evt.target,
            value: evt.target.value
          };

          _this._emitEvent(_this.options.eventItemsPerPage, detail);
        } else if (eventMatches(evt, _this.options.selectorPageNumberInput)) {
          var _detail2 = {
            initialEvt: evt,
            element: evt.target,
            value: evt.target.value
          };

          _this._emitEvent(_this.options.eventPageNumber, _detail2);
        }
      }));

      return _this;
    }
    /**
     * Dispatches a custom event
     * @param {string} evtName name of the event to be dispatched.
     * @param {object} detail contains the original event and any other necessary details.
     */


    Pagination.components = new WeakMap();
    Pagination.options = {
      selectorInit: '[data-pagination]',
      selectorItemsPerPageInput: '[data-items-per-page]',
      selectorPageNumberInput: '[data-page-number-input]',
      selectorPageBackward: '[data-page-backward]',
      selectorPageForward: '[data-page-forward]',
      eventItemsPerPage: 'itemsPerPage',
      eventPageNumber: 'pageNumber',
      eventPageChange: 'pageChange'
    };
    return Pagination;
  }(mixin(createComponent, initComponentBySearch, handles));

  function _defineProperty$3(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }
  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */


  function svgToggleClass(svg, name, forceAdd) {
    var list = svg.getAttribute('class').trim().split(/\s+/);
    var uniqueList = Object.keys(list.reduce(function (o, item) {
      return Object.assign(o, _defineProperty$3({}, item, 1));
    }, {}));
    var index = uniqueList.indexOf(name);
    var found = index >= 0;
    var add = forceAdd === undefined ? !found : forceAdd;

    if (found === !add) {
      if (add) {
        uniqueList.push(name);
      } else {
        uniqueList.splice(index, 1);
      }

      svg.setAttribute('class', uniqueList.join(' '));
    }
  }

  function _typeof$l(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof$l = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof$l = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof$l(obj);
  }

  function _classCallCheck$m(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$k(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$k(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$k(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$k(Constructor, staticProps);
    return Constructor;
  }

  function _possibleConstructorReturn$l(self, call) {
    if (call && (_typeof$l(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized$l(self);
  }

  function _assertThisInitialized$l(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _getPrototypeOf$l(o) {
    _getPrototypeOf$l = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf$l(o);
  }

  function _inherits$l(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf$l(subClass, superClass);
  }

  function _setPrototypeOf$l(o, p) {
    _setPrototypeOf$l = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf$l(o, p);
  }

  var toArray$5 = function toArray(arrayLike) {
    return Array.prototype.slice.call(arrayLike);
  };

  var Search =
  /*#__PURE__*/
  function (_mixin) {
    _inherits$l(Search, _mixin);
    /**
     * Search with Options.
     * @extends CreateComponent
     * @extends InitComponentBySearch
     * @extends Handles
     * @param {HTMLElement} element The element working as the search component.
     * @param {object} [options] The component options
     * @property {string} [options.selectorInit]
     *   The selector to find search UIs with options.
     * @property {string} [options.selectorSearchView]
     *   The selector to find the search view icon containers.
     * @property {string} [options.selectorSearchInput]
     *   The selector to find the search input.
     * @property {string} [options.selectorClearIcon]
     *   The selector for the clear icon that clears the search box.
     * @property {string} [options.selectorIconContainer] The data attribute selector for the icon layout container.
     * @property {string} [options.classClearHidden] The class used to hide the clear icon.
     * @property {string} [options.classLayoutHidden] The class used to hide nonselected layout view.
     */


    function Search(element, options) {
      var _this;

      _classCallCheck$m(this, Search);

      _this = _possibleConstructorReturn$l(this, _getPrototypeOf$l(Search).call(this, element, options));

      var closeIcon = _this.element.querySelector(_this.options.selectorClearIcon);

      var input = _this.element.querySelector(_this.options.selectorSearchInput);

      if (!input) {
        throw new Error('Cannot find the search input.');
      }

      if (closeIcon) {
        _this.manage(on(closeIcon, 'click', function () {
          svgToggleClass(closeIcon, _this.options.classClearHidden, true);
          input.value = '';
          input.focus();
        }));
      }

      _this.manage(on(_this.element, 'click', function (evt) {
        var toggleItem = eventMatches(evt, _this.options.selectorIconContainer);
        if (toggleItem) _this.toggleLayout(toggleItem);
      }));

      _this.manage(on(input, 'input', function (evt) {
        if (closeIcon) _this.showClear(evt.target.value, closeIcon);
      }));

      return _this;
    }
    /**
     * Toggles between the grid and list layout.
     * @param {HTMLElement} element The element contining the layout toggle.
     */


    _createClass$k(Search, [{
      key: "toggleLayout",
      value: function toggleLayout(element) {
        var _this2 = this;

        toArray$5(element.querySelectorAll(this.options.selectorSearchView)).forEach(function (item) {
          item.classList.toggle(_this2.options.classLayoutHidden);
        });
      }
      /**
       * Toggles the clear icon visibility
       * @param {HTMLElement} value The element serving as the search input.
       * @param {HTMLElement} icon The element serving as close icon.
       */

    }, {
      key: "showClear",
      value: function showClear(value, icon) {
        svgToggleClass(icon, this.options.classClearHidden, value.length === 0);
      }
      /**
       * The component options.
       * If `options` is specified in the constructor,
       * {@linkcode Search.create .create()}, or {@linkcode Search.init .init()},
       * properties in this object are overriden for the instance being created
       * and how {@linkcode Search.init .init()} works.
       * @member Search.options
       * @type {object}
       * @property {string} [options.selectorInit]
       *   The selector to find search UIs with options.
       * @property {string} [options.selectorSearchView]
       *   The selector to find the search view icon containers.
       * @property {string} [options.selectorSearchInput]
       *   The selector to find the search input.
       * @property {string} [options.selectorClearIcon]
       *   The selector for the clear icon that clears the search box.
       * @property {string} [options.selectorIconContainer] The data attribute selector for the icon layout container.
       * @property {string} [options.classClearHidden] The class used to hide the clear icon.
       * @property {string} [options.classLayoutHidden] The class used to hide nonselected layout view.
       */

    }], [{
      key: "options",
      get: function get() {
        var prefix = settings_1.prefix;
        return {
          selectorInit: '[data-search]',
          selectorSearchView: '[data-search-view]',
          selectorSearchInput: ".".concat(prefix, "--search-input"),
          selectorClearIcon: ".".concat(prefix, "--search-close"),
          selectorIconContainer: ".".concat(prefix, "--search-button[data-search-toggle]"),
          classClearHidden: "".concat(prefix, "--search-close--hidden"),
          classLayoutHidden: "".concat(prefix, "--search-view--hidden")
        };
      }
      /**
       * The map associating DOM element and search instance.
       * @member Search.components
       * @type {WeakMap}
       */

    }]);

    Search.components = new WeakMap();
    return Search;
  }(mixin(createComponent, initComponentBySearch, handles));

  function _typeof$m(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof$m = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof$m = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof$m(obj);
  }

  function _classCallCheck$n(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$l(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$l(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$l(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$l(Constructor, staticProps);
    return Constructor;
  }

  function _possibleConstructorReturn$m(self, call) {
    if (call && (_typeof$m(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized$m(self);
  }

  function _assertThisInitialized$m(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _getPrototypeOf$m(o) {
    _getPrototypeOf$m = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf$m(o);
  }

  function _inherits$m(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf$m(subClass, superClass);
  }

  function _setPrototypeOf$m(o, p) {
    _setPrototypeOf$m = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf$m(o, p);
  }

  var Accordion =
  /*#__PURE__*/
  function (_mixin) {
    _inherits$m(Accordion, _mixin);
    /**
     * Accordion.
     * @extends CreateComponent
     * @extends InitComponentBySearch
     * @extends Handles
     * @param {HTMLElement} element The element working as an accordion.
     */


    function Accordion(element, options) {
      var _this;

      _classCallCheck$n(this, Accordion);

      _this = _possibleConstructorReturn$m(this, _getPrototypeOf$m(Accordion).call(this, element, options));

      _this.manage(on(_this.element, 'click', function (event) {
        var item = eventMatches(event, _this.options.selectorAccordionItem);

        if (item && !eventMatches(event, _this.options.selectorAccordionContent)) {
          _this._toggle(item);
        }
      }));
      /**
       *
       *  DEPRECATE in v8
       *
       *  Swapping to a button elemenet instead of a div
       *  automatically maps click events to keypress as well
       *  This event listener now is only added if user is using
       *  the older markup
       */


      if (!_this._checkIfButton()) {
        _this.manage(on(_this.element, 'keypress', function (event) {
          var item = eventMatches(event, _this.options.selectorAccordionItem);

          if (item && !eventMatches(event, _this.options.selectorAccordionContent)) {
            _this._handleKeypress(event);
          }
        }));
      }

      return _this;
    }

    _createClass$l(Accordion, [{
      key: "_checkIfButton",
      value: function _checkIfButton() {
        return this.element.firstElementChild.firstElementChild.nodeName === 'BUTTON';
      }
      /**
       * Handles toggling of active state of accordion via keyboard
       * @param {Event} event The event triggering this method.
       */

    }, {
      key: "_handleKeypress",
      value: function _handleKeypress(event) {
        if (event.which === 13 || event.which === 32) {
          this._toggle(event.target);
        }
      }
    }, {
      key: "_toggle",
      value: function _toggle(element) {
        var heading = element.querySelector(this.options.selectorAccordionItemHeading);
        var expanded = heading.getAttribute('aria-expanded');

        if (expanded !== null) {
          heading.setAttribute('aria-expanded', expanded === 'true' ? 'false' : 'true');
        }

        element.classList.toggle(this.options.classActive);
      }
      /**
       * The component options.
       * If `options` is specified in the constructor,
       * {@linkcode NumberInput.create .create()}, or {@linkcode NumberInput.init .init()},
       * properties in this object are overriden for the instance being create and how {@linkcode NumberInput.init .init()} works.
       * @property {string} selectorInit The CSS selector to find accordion UIs.
       */

    }], [{
      key: "options",
      get: function get() {
        var prefix = settings_1.prefix;
        return {
          selectorInit: '[data-accordion]',
          selectorAccordionItem: ".".concat(prefix, "--accordion__item"),
          selectorAccordionItemHeading: ".".concat(prefix, "--accordion__heading"),
          selectorAccordionContent: ".".concat(prefix, "--accordion__content"),
          classActive: "".concat(prefix, "--accordion__item--active")
        };
      }
      /**
       * The map associating DOM element and accordion UI instance.
       * @type {WeakMap}
       */

    }]);

    Accordion.components = new WeakMap();
    return Accordion;
  }(mixin(createComponent, initComponentBySearch, handles));

  function _typeof$n(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof$n = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof$n = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof$n(obj);
  }

  function _classCallCheck$o(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$m(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$m(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$m(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$m(Constructor, staticProps);
    return Constructor;
  }

  function _possibleConstructorReturn$n(self, call) {
    if (call && (_typeof$n(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized$n(self);
  }

  function _assertThisInitialized$n(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _getPrototypeOf$n(o) {
    _getPrototypeOf$n = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf$n(o);
  }

  function _inherits$n(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf$n(subClass, superClass);
  }

  function _setPrototypeOf$n(o, p) {
    _setPrototypeOf$n = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf$n(o, p);
  }

  var CopyButton =
  /*#__PURE__*/
  function (_mixin) {
    _inherits$n(CopyButton, _mixin);
    /**
     * CopyBtn UI.
     * @extends CreateComponent
     * @extends InitComponentBySearch
     * @extends Handles
     * @param {HTMLElement} element The element working as a copy button UI.
     */


    function CopyButton(element, options) {
      var _this;

      _classCallCheck$o(this, CopyButton);

      _this = _possibleConstructorReturn$n(this, _getPrototypeOf$n(CopyButton).call(this, element, options));

      _this.manage(on(_this.element, 'click', function () {
        return _this.handleClick();
      }));

      return _this;
    }
    /**
     * Show the feedback tooltip on click. Hide the feedback tooltip after specified timeout value.
     */


    _createClass$m(CopyButton, [{
      key: "handleClick",
      value: function handleClick() {
        var _this2 = this;

        var feedback = this.element.querySelector(this.options.feedbackTooltip);

        if (feedback) {
          feedback.classList.add(this.options.classShowFeedback);
          setTimeout(function () {
            feedback.classList.remove(_this2.options.classShowFeedback);
          }, this.options.timeoutValue);
        }
      }
      /**
       * The map associating DOM element and copy button UI instance.
       * @member CopyBtn.components
       * @type {WeakMap}
       */

    }], [{
      key: "options",

      /**
       * The component options.
       * If `options` is specified in the constructor, {@linkcode CopyBtn.create .create()}, or {@linkcode CopyBtn.init .init()},
       * properties in this object are overriden for the instance being create and how {@linkcode CopyBtn.init .init()} works.
       * @member CopyBtn.options
       * @type {object}
       * @property {string} selectorInit The data attribute to find copy button UIs.
       * @property {string} feedbackTooltip The data attribute to find feedback tooltip.
       * @property {string} classShowFeedback The CSS selector for showing the feedback tooltip.
       * @property {number} timeoutValue The specified timeout value before the feedback tooltip is hidden.
       */
      get: function get() {
        var prefix = settings_1.prefix;
        return {
          selectorInit: '[data-copy-btn]',
          feedbackTooltip: '[data-feedback]',
          classShowFeedback: "".concat(prefix, "--btn--copy__feedback--displayed"),
          timeoutValue: 2000
        };
      }
    }]);

    CopyButton.components = new WeakMap();
    return CopyButton;
  }(mixin(createComponent, initComponentBySearch, handles));

  function _typeof$o(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof$o = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof$o = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof$o(obj);
  }

  function _classCallCheck$p(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$n(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$n(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$n(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$n(Constructor, staticProps);
    return Constructor;
  }

  function _possibleConstructorReturn$o(self, call) {
    if (call && (_typeof$o(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized$o(self);
  }

  function _assertThisInitialized$o(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _getPrototypeOf$o(o) {
    _getPrototypeOf$o = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf$o(o);
  }

  function _inherits$o(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf$o(subClass, superClass);
  }

  function _setPrototypeOf$o(o, p) {
    _setPrototypeOf$o = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf$o(o, p);
  }

  var Notification =
  /*#__PURE__*/
  function (_mixin) {
    _inherits$o(Notification, _mixin);
    /**
     * InlineNotification.
     * @extends CreateComponent
     * @extends InitComponentBySearch
     * @extends Handles
     * @param {HTMLElement} element The element working as a InlineNotification.
     */


    function Notification(element, options) {
      var _this;

      _classCallCheck$p(this, Notification);

      _this = _possibleConstructorReturn$o(this, _getPrototypeOf$o(Notification).call(this, element, options));

      _this._changeState = function (state, callback) {
        if (state === 'delete-notification') {
          _this.element.parentNode.removeChild(_this.element);

          _this.release();
        }

        callback();
      };

      _this.button = element.querySelector(_this.options.selectorButton);

      if (_this.button) {
        _this.manage(on(_this.button, 'click', function (evt) {
          if (evt.currentTarget === _this.button) {
            _this.remove();
          }
        }));
      }

      return _this;
    }

    _createClass$n(Notification, [{
      key: "remove",
      value: function remove() {
        this.changeState('delete-notification');
      }
      /**
       * The map associating DOM element and accordion UI instance.
       * @type {WeakMap}
       */

    }]);

    Notification.components = new WeakMap();
    Notification.options = {
      selectorInit: '[data-notification]',
      selectorButton: '[data-notification-btn]',
      eventBeforeDeleteNotification: 'notification-before-delete',
      eventAfterDeleteNotification: 'notification-after-delete'
    };
    return Notification;
  }(mixin(createComponent, initComponentBySearch, eventedState, handles));

  function _typeof$p(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof$p = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof$p = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof$p(obj);
  }

  function _classCallCheck$q(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$o(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$o(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$o(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$o(Constructor, staticProps);
    return Constructor;
  }

  function _possibleConstructorReturn$p(self, call) {
    if (call && (_typeof$p(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized$p(self);
  }

  function _assertThisInitialized$p(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _getPrototypeOf$p(o) {
    _getPrototypeOf$p = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf$p(o);
  }

  function _inherits$p(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf$p(subClass, superClass);
  }

  function _setPrototypeOf$p(o, p) {
    _setPrototypeOf$p = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf$p(o, p);
  }

  var toArray$6 = function toArray(arrayLike) {
    return Array.prototype.slice.call(arrayLike);
  };

  var Toolbar =
  /*#__PURE__*/
  function (_mixin) {
    _inherits$p(Toolbar, _mixin);
    /**
     * Toolbar.
     * @extends CreateComponent
     * @extends InitComponentBySearch
     * @extends Handles
     * @param {HTMLElement} element The element working as an toolbar.
     */


    function Toolbar(element, options) {
      var _this;

      _classCallCheck$q(this, Toolbar);

      _this = _possibleConstructorReturn$p(this, _getPrototypeOf$p(Toolbar).call(this, element, options));

      if (!_this.element.dataset.tableTarget) {
        console.warn('There is no table bound to this toolbar!'); // eslint-disable-line no-console
      } else {
        var boundTable = _this.element.ownerDocument.querySelector(_this.element.dataset.tableTarget);

        var rowHeightBtns = _this.element.querySelector(_this.options.selectorRowHeight);

        if (rowHeightBtns) {
          _this.manage(on(rowHeightBtns, 'click', function (event) {
            _this._handleRowHeightChange(event, boundTable);
          })); // toArray(this.element.querySelectorAll(this.options.selectorRowHeight)).forEach((item) => {
          //   item.addEventListener('click', (event) => { this._handleRowHeightChange(event, boundTable); });
          // });

        }
      }

      _this.manage(on(_this.element.ownerDocument, 'keydown', function (evt) {
        _this._handleKeyDown(evt);
      }));

      _this.manage(on(_this.element.ownerDocument, 'click', function (evt) {
        _this._handleDocumentClick(evt);
      }));

      return _this;
    }
    /**
     * Handles toggling of active state of the toolbar search input
     * @param {Event} event The event triggering this method.
     */


    _createClass$o(Toolbar, [{
      key: "_handleDocumentClick",
      value: function _handleDocumentClick(event) {
        var _this2 = this;

        var searchInput = eventMatches(event, this.options.selectorSearch);
        var isOfSelfSearchInput = searchInput && this.element.contains(searchInput);

        if (isOfSelfSearchInput) {
          var shouldBeOpen = isOfSelfSearchInput && !this.element.classList.contains(this.options.classSearchActive);
          searchInput.classList.toggle(this.options.classSearchActive, shouldBeOpen);

          if (shouldBeOpen) {
            searchInput.querySelector('input').focus();
          }
        }

        var targetComponentElement = eventMatches(event, this.options.selectorInit);
        toArray$6(this.element.ownerDocument.querySelectorAll(this.options.selectorSearch)).forEach(function (item) {
          if (!targetComponentElement || !targetComponentElement.contains(item)) {
            item.classList.remove(_this2.options.classSearchActive);
          }
        });
      }
      /**
       * Handles toggling of active state of the toolbar search input via the keyboard
       * @param {Event} event The event triggering this method.
       */

    }, {
      key: "_handleKeyDown",
      value: function _handleKeyDown(event) {
        var searchInput = eventMatches(event, this.options.selectorSearch);

        if (searchInput && event.which === 27) {
          searchInput.classList.remove(this.options.classSearchActive);
        }
      }
      /**
       * Handles toggling of the row height of the associated table
       * @param {Event} event The event triggering this method.
       * @param {HTMLElement} boundTable The table associated with the toolbar.
       */

    }, {
      key: "_handleRowHeightChange",
      value: function _handleRowHeightChange(event, boundTable) {
        var _event$currentTarget$ = event.currentTarget.querySelector('input:checked'),
            value = _event$currentTarget$.value;

        if (value === 'tall') {
          boundTable.classList.add(this.options.classTallRows);
        } else {
          boundTable.classList.remove(this.options.classTallRows);
        }
      }
      /**
       * The map associating DOM element and Toolbar UI instance.
       * @type {WeakMap}
       */

    }], [{
      key: "options",

      /**
       * The component options.
       * If `options` is specified in the constructor,
       * properties in this object are overriden for the instance being created.
       * @property {string} selectorInit The CSS selector to find toolbar instances.
       * @property {string} selectorSearch The CSS selector to find search inputs in a toolbar.
       * @property {string} selectorRowHeight The CSS selector to find the row height inputs in a toolbar.
       * @property {string} classTallRows The CSS class for making table rows into tall rows.
       * @property {string} classSearchActive The CSS class the active state of the search input.
       */
      get: function get() {
        var prefix = settings_1.prefix;
        return {
          selectorInit: '[data-toolbar]',
          selectorSearch: '[data-toolbar-search]',
          selectorRowHeight: '[data-row-height]',
          classTallRows: "".concat(prefix, "--responsive-table--tall"),
          classSearchActive: "".concat(prefix, "--toolbar-search--active")
        };
      }
    }]);

    Toolbar.components = new WeakMap();
    return Toolbar;
  }(mixin(createComponent, initComponentBySearch, handles));

  /**
   * lodash (Custom Build) <https://lodash.com/>
   * Build: `lodash modularize exports="npm" -o ./`
   * Copyright jQuery Foundation and other contributors <https://jquery.org/>
   * Released under MIT license <https://lodash.com/license>
   * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
   * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
   */

  /** Used as the `TypeError` message for "Functions" methods. */

  var FUNC_ERROR_TEXT = 'Expected a function';
  /** Used as references for various `Number` constants. */

  var NAN = 0 / 0;
  /** `Object#toString` result references. */

  var symbolTag = '[object Symbol]';
  /** Used to match leading and trailing whitespace. */

  var reTrim = /^\s+|\s+$/g;
  /** Used to detect bad signed hexadecimal string values. */

  var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;
  /** Used to detect binary string values. */

  var reIsBinary = /^0b[01]+$/i;
  /** Used to detect octal string values. */

  var reIsOctal = /^0o[0-7]+$/i;
  /** Built-in method references without a dependency on `root`. */

  var freeParseInt = parseInt;
  /** Detect free variable `global` from Node.js. */

  var freeGlobal = typeof commonjsGlobal == 'object' && commonjsGlobal && commonjsGlobal.Object === Object && commonjsGlobal;
  /** Detect free variable `self`. */

  var freeSelf = typeof self == 'object' && self && self.Object === Object && self;
  /** Used as a reference to the global object. */

  var root = freeGlobal || freeSelf || Function('return this')();
  /** Used for built-in method references. */

  var objectProto = Object.prototype;
  /**
   * Used to resolve the
   * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
   * of values.
   */

  var objectToString = objectProto.toString;
  /* Built-in method references for those with the same name as other `lodash` methods. */

  var nativeMax = Math.max,
      nativeMin = Math.min;
  /**
   * Gets the timestamp of the number of milliseconds that have elapsed since
   * the Unix epoch (1 January 1970 00:00:00 UTC).
   *
   * @static
   * @memberOf _
   * @since 2.4.0
   * @category Date
   * @returns {number} Returns the timestamp.
   * @example
   *
   * _.defer(function(stamp) {
   *   console.log(_.now() - stamp);
   * }, _.now());
   * // => Logs the number of milliseconds it took for the deferred invocation.
   */

  var now = function () {
    return root.Date.now();
  };
  /**
   * Creates a debounced function that delays invoking `func` until after `wait`
   * milliseconds have elapsed since the last time the debounced function was
   * invoked. The debounced function comes with a `cancel` method to cancel
   * delayed `func` invocations and a `flush` method to immediately invoke them.
   * Provide `options` to indicate whether `func` should be invoked on the
   * leading and/or trailing edge of the `wait` timeout. The `func` is invoked
   * with the last arguments provided to the debounced function. Subsequent
   * calls to the debounced function return the result of the last `func`
   * invocation.
   *
   * **Note:** If `leading` and `trailing` options are `true`, `func` is
   * invoked on the trailing edge of the timeout only if the debounced function
   * is invoked more than once during the `wait` timeout.
   *
   * If `wait` is `0` and `leading` is `false`, `func` invocation is deferred
   * until to the next tick, similar to `setTimeout` with a timeout of `0`.
   *
   * See [David Corbacho's article](https://css-tricks.com/debouncing-throttling-explained-examples/)
   * for details over the differences between `_.debounce` and `_.throttle`.
   *
   * @static
   * @memberOf _
   * @since 0.1.0
   * @category Function
   * @param {Function} func The function to debounce.
   * @param {number} [wait=0] The number of milliseconds to delay.
   * @param {Object} [options={}] The options object.
   * @param {boolean} [options.leading=false]
   *  Specify invoking on the leading edge of the timeout.
   * @param {number} [options.maxWait]
   *  The maximum time `func` is allowed to be delayed before it's invoked.
   * @param {boolean} [options.trailing=true]
   *  Specify invoking on the trailing edge of the timeout.
   * @returns {Function} Returns the new debounced function.
   * @example
   *
   * // Avoid costly calculations while the window size is in flux.
   * jQuery(window).on('resize', _.debounce(calculateLayout, 150));
   *
   * // Invoke `sendMail` when clicked, debouncing subsequent calls.
   * jQuery(element).on('click', _.debounce(sendMail, 300, {
   *   'leading': true,
   *   'trailing': false
   * }));
   *
   * // Ensure `batchLog` is invoked once after 1 second of debounced calls.
   * var debounced = _.debounce(batchLog, 250, { 'maxWait': 1000 });
   * var source = new EventSource('/stream');
   * jQuery(source).on('message', debounced);
   *
   * // Cancel the trailing debounced invocation.
   * jQuery(window).on('popstate', debounced.cancel);
   */


  function debounce(func, wait, options) {
    var lastArgs,
        lastThis,
        maxWait,
        result,
        timerId,
        lastCallTime,
        lastInvokeTime = 0,
        leading = false,
        maxing = false,
        trailing = true;

    if (typeof func != 'function') {
      throw new TypeError(FUNC_ERROR_TEXT);
    }

    wait = toNumber(wait) || 0;

    if (isObject(options)) {
      leading = !!options.leading;
      maxing = 'maxWait' in options;
      maxWait = maxing ? nativeMax(toNumber(options.maxWait) || 0, wait) : maxWait;
      trailing = 'trailing' in options ? !!options.trailing : trailing;
    }

    function invokeFunc(time) {
      var args = lastArgs,
          thisArg = lastThis;
      lastArgs = lastThis = undefined;
      lastInvokeTime = time;
      result = func.apply(thisArg, args);
      return result;
    }

    function leadingEdge(time) {
      // Reset any `maxWait` timer.
      lastInvokeTime = time; // Start the timer for the trailing edge.

      timerId = setTimeout(timerExpired, wait); // Invoke the leading edge.

      return leading ? invokeFunc(time) : result;
    }

    function remainingWait(time) {
      var timeSinceLastCall = time - lastCallTime,
          timeSinceLastInvoke = time - lastInvokeTime,
          result = wait - timeSinceLastCall;
      return maxing ? nativeMin(result, maxWait - timeSinceLastInvoke) : result;
    }

    function shouldInvoke(time) {
      var timeSinceLastCall = time - lastCallTime,
          timeSinceLastInvoke = time - lastInvokeTime; // Either this is the first call, activity has stopped and we're at the
      // trailing edge, the system time has gone backwards and we're treating
      // it as the trailing edge, or we've hit the `maxWait` limit.

      return lastCallTime === undefined || timeSinceLastCall >= wait || timeSinceLastCall < 0 || maxing && timeSinceLastInvoke >= maxWait;
    }

    function timerExpired() {
      var time = now();

      if (shouldInvoke(time)) {
        return trailingEdge(time);
      } // Restart the timer.


      timerId = setTimeout(timerExpired, remainingWait(time));
    }

    function trailingEdge(time) {
      timerId = undefined; // Only invoke if we have `lastArgs` which means `func` has been
      // debounced at least once.

      if (trailing && lastArgs) {
        return invokeFunc(time);
      }

      lastArgs = lastThis = undefined;
      return result;
    }

    function cancel() {
      if (timerId !== undefined) {
        clearTimeout(timerId);
      }

      lastInvokeTime = 0;
      lastArgs = lastCallTime = lastThis = timerId = undefined;
    }

    function flush() {
      return timerId === undefined ? result : trailingEdge(now());
    }

    function debounced() {
      var time = now(),
          isInvoking = shouldInvoke(time);
      lastArgs = arguments;
      lastThis = this;
      lastCallTime = time;

      if (isInvoking) {
        if (timerId === undefined) {
          return leadingEdge(lastCallTime);
        }

        if (maxing) {
          // Handle invocations in a tight loop.
          timerId = setTimeout(timerExpired, wait);
          return invokeFunc(lastCallTime);
        }
      }

      if (timerId === undefined) {
        timerId = setTimeout(timerExpired, wait);
      }

      return result;
    }

    debounced.cancel = cancel;
    debounced.flush = flush;
    return debounced;
  }
  /**
   * Checks if `value` is the
   * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
   * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
   *
   * @static
   * @memberOf _
   * @since 0.1.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is an object, else `false`.
   * @example
   *
   * _.isObject({});
   * // => true
   *
   * _.isObject([1, 2, 3]);
   * // => true
   *
   * _.isObject(_.noop);
   * // => true
   *
   * _.isObject(null);
   * // => false
   */


  function isObject(value) {
    var type = typeof value;
    return !!value && (type == 'object' || type == 'function');
  }
  /**
   * Checks if `value` is object-like. A value is object-like if it's not `null`
   * and has a `typeof` result of "object".
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
   * @example
   *
   * _.isObjectLike({});
   * // => true
   *
   * _.isObjectLike([1, 2, 3]);
   * // => true
   *
   * _.isObjectLike(_.noop);
   * // => false
   *
   * _.isObjectLike(null);
   * // => false
   */


  function isObjectLike(value) {
    return !!value && typeof value == 'object';
  }
  /**
   * Checks if `value` is classified as a `Symbol` primitive or object.
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
   * @example
   *
   * _.isSymbol(Symbol.iterator);
   * // => true
   *
   * _.isSymbol('abc');
   * // => false
   */


  function isSymbol(value) {
    return typeof value == 'symbol' || isObjectLike(value) && objectToString.call(value) == symbolTag;
  }
  /**
   * Converts `value` to a number.
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Lang
   * @param {*} value The value to process.
   * @returns {number} Returns the number.
   * @example
   *
   * _.toNumber(3.2);
   * // => 3.2
   *
   * _.toNumber(Number.MIN_VALUE);
   * // => 5e-324
   *
   * _.toNumber(Infinity);
   * // => Infinity
   *
   * _.toNumber('3.2');
   * // => 3.2
   */


  function toNumber(value) {
    if (typeof value == 'number') {
      return value;
    }

    if (isSymbol(value)) {
      return NAN;
    }

    if (isObject(value)) {
      var other = typeof value.valueOf == 'function' ? value.valueOf() : value;
      value = isObject(other) ? other + '' : other;
    }

    if (typeof value != 'string') {
      return value === 0 ? value : +value;
    }

    value = value.replace(reTrim, '');
    var isBinary = reIsBinary.test(value);
    return isBinary || reIsOctal.test(value) ? freeParseInt(value.slice(2), isBinary ? 2 : 8) : reIsBadHex.test(value) ? NAN : +value;
  }

  var lodash_debounce = debounce;

  function _typeof$q(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof$q = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof$q = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof$q(obj);
  }

  function _classCallCheck$r(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$p(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$p(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$p(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$p(Constructor, staticProps);
    return Constructor;
  }

  function _possibleConstructorReturn$q(self, call) {
    if (call && (_typeof$q(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized$q(self);
  }

  function _assertThisInitialized$q(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _getPrototypeOf$q(o) {
    _getPrototypeOf$q = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf$q(o);
  }

  function _inherits$q(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf$q(subClass, superClass);
  }

  function _setPrototypeOf$q(o, p) {
    _setPrototypeOf$q = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf$q(o, p);
  }
  function initComponentByEvent (ToMix) {
    /**
     * Mix-in class to instantiate components upon events.
     * @class InitComponentByEvent
     */
    var InitComponentByEvent =
    /*#__PURE__*/
    function (_ToMix) {
      _inherits$q(InitComponentByEvent, _ToMix);

      function InitComponentByEvent() {
        _classCallCheck$r(this, InitComponentByEvent);

        return _possibleConstructorReturn$q(this, _getPrototypeOf$q(InitComponentByEvent).apply(this, arguments));
      }

      _createClass$p(InitComponentByEvent, null, [{
        key: "init",

        /**
         * `true` suggests that this component is lazily initialized upon an action/event, etc.
         * @type {boolean}
         */

        /**
         * Instantiates this component in the given element.
         * If the given element indicates that it's an component of this class, instantiates it.
         * Otherwise, instantiates this component by clicking on this component in the given node.
         * @param {Node} target The DOM node to instantiate this component in. Should be a document or an element.
         * @param {object} [options] The component options.
         * @param {string} [options.selectorInit] The CSS selector to find this component.
         * @returns {Handle} The handle to remove the event listener to handle clicking.
         */
        value: function init() {
          var _this = this;

          var target = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : document;
          var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
          var effectiveOptions = Object.assign(Object.create(this.options), options);

          if (!target || target.nodeType !== Node.ELEMENT_NODE && target.nodeType !== Node.DOCUMENT_NODE) {
            throw new TypeError('DOM document or DOM element should be given to search for and initialize this widget.');
          }

          if (target.nodeType === Node.ELEMENT_NODE && target.matches(effectiveOptions.selectorInit)) {
            this.create(target, options);
          } else {
            // To work around non-bubbling `focus` event, use `focusin` event instead of it's available, and "capture mode" otherwise
            var hasFocusin = 'onfocusin' in (target.nodeType === Node.ELEMENT_NODE ? target.ownerDocument : target).defaultView;
            var handles = effectiveOptions.initEventNames.map(function (name) {
              var eventName = name === 'focus' && hasFocusin ? 'focusin' : name;
              return on(target, eventName, function (event) {
                var element = eventMatches(event, effectiveOptions.selectorInit); // Instantiated components handles events by themselves

                if (element && !_this.components.has(element)) {
                  var component = _this.create(element, options);

                  if (typeof component.createdByEvent === 'function') {
                    component.createdByEvent(event);
                  }
                }
              }, name === 'focus' && !hasFocusin);
            });
            return {
              release: function release() {
                for (var handle = handles.pop(); handle; handle = handles.pop()) {
                  handle.release();
                }
              }
            };
          }

          return '';
        }
      }]);

      InitComponentByEvent.forLazyInit = true;
      return InitComponentByEvent;
    }(ToMix);

    return InitComponentByEvent;
  }

  function _typeof$r(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof$r = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof$r = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof$r(obj);
  }

  function _classCallCheck$s(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$q(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$q(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$q(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$q(Constructor, staticProps);
    return Constructor;
  }

  function _possibleConstructorReturn$r(self, call) {
    if (call && (_typeof$r(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized$r(self);
  }

  function _assertThisInitialized$r(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _getPrototypeOf$r(o) {
    _getPrototypeOf$r = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf$r(o);
  }

  function _inherits$r(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf$r(subClass, superClass);
  }

  function _setPrototypeOf$r(o, p) {
    _setPrototypeOf$r = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf$r(o, p);
  }

  function ownKeys$1(object, enumerableOnly) {
    var keys = Object.keys(object);

    if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);
      if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });
      keys.push.apply(keys, symbols);
    }

    return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};

      if (i % 2) {
        ownKeys$1(source, true).forEach(function (key) {
          _defineProperty$4(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys$1(source).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }

    return target;
  }

  function _defineProperty$4(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }
  /**
   * @param {Element} menuBody The menu body with the menu arrow.
   * @param {string} menuDirection Where the floating menu menu should be placed relative to the trigger button.
   * @returns {FloatingMenu~offset} The adjustment of the floating menu position, upon the position of the menu arrow.
   * @private
   */

  var getMenuOffset$1 = function getMenuOffset(menuBody, menuDirection) {
    var _DIRECTION_LEFT$DIREC, _DIRECTION_LEFT$DIREC2;

    var arrowStyle = menuBody.ownerDocument.defaultView.getComputedStyle(menuBody, ':before');
    var arrowPositionProp = (_DIRECTION_LEFT$DIREC = {}, _defineProperty$4(_DIRECTION_LEFT$DIREC, DIRECTION_LEFT, 'right'), _defineProperty$4(_DIRECTION_LEFT$DIREC, DIRECTION_TOP, 'bottom'), _defineProperty$4(_DIRECTION_LEFT$DIREC, DIRECTION_RIGHT, 'left'), _defineProperty$4(_DIRECTION_LEFT$DIREC, DIRECTION_BOTTOM, 'top'), _DIRECTION_LEFT$DIREC)[menuDirection];
    var menuPositionAdjustmentProp = (_DIRECTION_LEFT$DIREC2 = {}, _defineProperty$4(_DIRECTION_LEFT$DIREC2, DIRECTION_LEFT, 'left'), _defineProperty$4(_DIRECTION_LEFT$DIREC2, DIRECTION_TOP, 'top'), _defineProperty$4(_DIRECTION_LEFT$DIREC2, DIRECTION_RIGHT, 'left'), _defineProperty$4(_DIRECTION_LEFT$DIREC2, DIRECTION_BOTTOM, 'top'), _DIRECTION_LEFT$DIREC2)[menuDirection];
    var values = [arrowPositionProp, 'border-bottom-width'].reduce(function (o, name) {
      return _objectSpread({}, o, _defineProperty$4({}, name, Number((/^([\d-.]+)px$/.exec(arrowStyle.getPropertyValue(name)) || [])[1])));
    }, {});
    var margin = 0;

    if (menuDirection !== DIRECTION_BOTTOM) {
      var style = menuBody.ownerDocument.defaultView.getComputedStyle(menuBody);
      margin = Number((/^([\d-.]+)px$/.exec(style.getPropertyValue('margin-top')) || [])[1]);
    }

    values[arrowPositionProp] = values[arrowPositionProp] || -6; // IE, etc.

    if (Object.keys(values).every(function (name) {
      return !isNaN(values[name]);
    })) {
      var arrowPosition = values[arrowPositionProp],
          borderBottomWidth = values['border-bottom-width'];
      return _defineProperty$4({
        left: 0,
        top: 0
      }, menuPositionAdjustmentProp, Math.sqrt(Math.pow(borderBottomWidth, 2) * 2) - arrowPosition + margin * (menuDirection === DIRECTION_TOP ? 2 : 1));
    }

    return undefined;
  };

  var Tooltip =
  /*#__PURE__*/
  function (_mixin) {
    _inherits$r(Tooltip, _mixin);
    /**
     * Tooltip.
     * @extends CreateComponent
     * @extends InitComponentBySearch
     * @extends Handles
     */


    function Tooltip(element, options) {
      var _this;

      _classCallCheck$s(this, Tooltip);

      _this = _possibleConstructorReturn$r(this, _getPrototypeOf$r(Tooltip).call(this, element, options));
      _this._hasContextMenu = false;
      _this._debouncedHandleClick = lodash_debounce(_this._handleClick, 200);

      _this._hookOn(element);

      return _this;
    }
    /**
     * A flag to detect if `oncontextmenu` event is fired right before `focus`/`blur` events.
     * @type {boolean}
     */


    _createClass$q(Tooltip, [{
      key: "createdByEvent",

      /**
       * A method called when this widget is created upon events.
       * @param {Event} event The event triggering the creation.
       */
      value: function createdByEvent(event) {
        var relatedTarget = event.relatedTarget,
            type = event.type;

        this._debouncedHandleClick({
          relatedTarget: relatedTarget,
          type: type === 'focusin' ? 'focus' : type,
          details: getLaunchingDetails(event)
        });
      }
      /**
       * Changes the shown/hidden state.
       * @param {string} state The new state.
       * @param {object} detail The detail of the event trigging this action.
       * @param {Function} callback Callback called when change in state completes.
       // */

    }, {
      key: "changeState",
      value: function changeState(state, detail, callback) {
        if (!this.tooltip) {
          var tooltip = this.element.ownerDocument.querySelector(this.element.getAttribute(this.options.attribTooltipTarget));

          if (!tooltip) {
            throw new Error('Cannot find the target tooltip.');
          } // Lazily create a component instance for tooltip


          this.tooltip = FloatingMenu.create(tooltip, {
            refNode: this.element,
            classShown: this.options.classShown,
            offset: this.options.objMenuOffset
          });

          this._hookOn(tooltip);

          this.children.push(this.tooltip);
        } // Delegates the action of changing state to the tooltip.
        // (And thus the before/after shown/hidden events are fired from the tooltip)


        this.tooltip.changeState(state, Object.assign(detail, {
          delegatorNode: this.element
        }), callback);
      }
      /**
       * Attaches event handlers to show/hide the tooltip.
       * @param {Element} element The element to attach the events to.
       * @private
       */

    }, {
      key: "_hookOn",
      value: function _hookOn(element) {
        var _this2 = this;

        var hasFocusin = 'onfocusin' in window;
        var focusinEventName = hasFocusin ? 'focusin' : 'focus';
        [focusinEventName, 'blur', 'touchleave', 'touchcancel'].forEach(function (name) {
          _this2.manage(on(element, name, function (event) {
            var relatedTarget = event.relatedTarget,
                type = event.type;
            var hadContextMenu = _this2._hasContextMenu;
            _this2._hasContextMenu = type === 'contextmenu';

            _this2._debouncedHandleClick({
              relatedTarget: relatedTarget,
              type: type === 'focusin' ? 'focus' : type,
              hadContextMenu: hadContextMenu,
              details: getLaunchingDetails(event)
            });
          }, name === focusinEventName && !hasFocusin));
        });
      }
      /**
       * Handles click/focus events.
       * @param {object} params The parameters.
       * @param {Element} params.relatedTarget The element that focus went to. (For `blur` event)
       * @param {string} params.type The event type triggering this method.
       * @param {boolean} params.hadContextMenu
       * @param {object} params.details The event details.
       * @private
       */

    }, {
      key: "_handleClick",
      value: function _handleClick(_ref2) {
        var relatedTarget = _ref2.relatedTarget,
            type = _ref2.type,
            hadContextMenu = _ref2.hadContextMenu,
            details = _ref2.details;
        var state = {
          focus: 'shown',
          blur: 'hidden',
          touchleave: 'hidden',
          touchcancel: 'hidden'
        }[type];
        var shouldPreventClose;

        if (type === 'blur') {
          // Note: SVGElement in IE11 does not have `.contains()`
          var wentToSelf = relatedTarget && this.element.contains && this.element.contains(relatedTarget) || this.tooltip && this.tooltip.element.contains(relatedTarget);
          shouldPreventClose = hadContextMenu || wentToSelf;
        }

        if (!shouldPreventClose) {
          this.changeState(state, details);
        }
      }
    }], [{
      key: "options",
      get: function get() {
        var prefix = settings_1.prefix;
        return {
          selectorInit: '[data-tooltip-trigger]',
          classShown: "".concat(prefix, "--tooltip--shown"),
          attribTooltipTarget: 'data-tooltip-target',
          objMenuOffset: getMenuOffset$1,
          initEventNames: ['focus']
        };
      }
    }]);

    Tooltip.components = new WeakMap();
    return Tooltip;
  }(mixin(createComponent, initComponentByEvent, exports$1, handles));

  function _typeof$s(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof$s = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof$s = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof$s(obj);
  }

  function _classCallCheck$t(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$r(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$r(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$r(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$r(Constructor, staticProps);
    return Constructor;
  }

  function _possibleConstructorReturn$s(self, call) {
    if (call && (_typeof$s(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized$s(self);
  }

  function _assertThisInitialized$s(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _getPrototypeOf$s(o) {
    _getPrototypeOf$s = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf$s(o);
  }

  function _inherits$s(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf$s(subClass, superClass);
  }

  function _setPrototypeOf$s(o, p) {
    _setPrototypeOf$s = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf$s(o, p);
  }

  var toArray$7 = function toArray(arrayLike) {
    return Array.prototype.slice.call(arrayLike);
  };

  var ProgressIndicator =
  /*#__PURE__*/
  function (_mixin) {
    _inherits$s(ProgressIndicator, _mixin);
    /**
     * ProgressIndicator.
     * @extends CreateComponent
     * @extends InitComponentBySearch
     * @param {HTMLElement} element The element representing the ProgressIndicator.
     * @param {object} [options] The component options.
     * @property {string} [options.selectorStepElement] The CSS selector to find step elements.
     * @property {string} [options.selectorCurrent] The CSS selector to find the current step element.
     * @property {string} [options.selectorIncomplete] The CSS class to find incomplete step elements.
     * @property {string} [options.selectorComplete] The CSS selector to find completed step elements.
     * @property {string} [options.classStep] The className for a step element.
     * @property {string} [options.classComplete] The className for a completed step element.
     * @property {string} [options.classCurrent] The className for the current step element.
     * @property {string} [options.classIncomplete] The className for a incomplete step element.
     */


    function ProgressIndicator(element, options) {
      var _this;

      _classCallCheck$t(this, ProgressIndicator);

      _this = _possibleConstructorReturn$s(this, _getPrototypeOf$s(ProgressIndicator).call(this, element, options));
      /**
       * The component state.
       * @type {Object}
       */

      _this.state = {
        /**
         * The current step index.
         * @type {number}
         */
        currentIndex: _this.getCurrent().index,

        /**
         * Total number of steps.
         * @type {number}
         */
        totalSteps: _this.getSteps().length
      };

      _this.addOverflowTooltip();

      return _this;
    }
    /**
     * Returns all steps with details about element and index.
     */


    _createClass$r(ProgressIndicator, [{
      key: "getSteps",
      value: function getSteps() {
        return toArray$7(this.element.querySelectorAll(this.options.selectorStepElement)).map(function (element, index) {
          return {
            element: element,
            index: index
          };
        });
      }
      /**
       * Returns current step; gives detail about element and index.
       */

    }, {
      key: "getCurrent",
      value: function getCurrent() {
        var currentEl = this.element.querySelector(this.options.selectorCurrent);
        return this.getSteps().filter(function (step) {
          return step.element === currentEl;
        })[0];
      }
      /**
       * Sets the current step.
       * * @param {Number} new step index or use default in `this.state.currentIndex`.
       */

    }, {
      key: "setCurrent",
      value: function setCurrent() {
        var _this2 = this;

        var newCurrentStep = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.state.currentIndex;
        var changed = false;

        if (newCurrentStep !== this.state.currentIndex) {
          this.state.currentIndex = newCurrentStep;
          changed = true;
        }

        if (changed) {
          this.getSteps().forEach(function (step) {
            if (step.index < newCurrentStep) {
              _this2._updateStep({
                element: step.element,
                className: _this2.options.classComplete,
                html: _this2._getSVGComplete()
              });
            }

            if (step.index === newCurrentStep) {
              _this2._updateStep({
                element: step.element,
                className: _this2.options.classCurrent,
                html: _this2._getCurrentSVG()
              });
            }

            if (step.index > newCurrentStep) {
              _this2._updateStep({
                element: step.element,
                className: _this2.options.classIncomplete,
                html: _this2._getIncompleteSVG()
              });
            }
          });
        }
      }
      /**
       * Update step with correct inline SVG and className
       * @param {object} args
       * @param {object} [args.element] target element
       * @param {object} [args.className] new className
       * @param {object} [args.html] new inline SVG to insert
       */

    }, {
      key: "_updateStep",
      value: function _updateStep(args) {
        var element = args.element,
            className = args.className,
            html = args.html;

        if (element.firstElementChild) {
          element.removeChild(element.firstElementChild);
        }

        if (!element.classList.contains(className)) {
          element.setAttribute('class', this.options.classStep);
          element.classList.add(className);
        }

        element.insertAdjacentHTML('afterbegin', html);
      }
      /**
       * Returns HTML string for an SVG used to represent a compelted step (checkmark)
       */

    }, {
      key: "_getSVGComplete",
      value: function _getSVGComplete() {
        return "<svg width=\"24px\" height=\"24px\" viewBox=\"0 0 24 24\">\n        <circle cx=\"12\" cy=\"12\" r=\"12\"></circle>\n        <polygon points=\"10.3 13.6 7.7 11 6.3 12.4 10.3 16.4 17.8 9 16.4 7.6\"></polygon>\n      </svg>";
      }
      /**
       * Returns HTML string for an SVG used to represent current step (circles, like a radio button, but not.)
       */

    }, {
      key: "_getCurrentSVG",
      value: function _getCurrentSVG() {
        return "<svg>\n        <circle cx=\"12\" cy=\"12\" r=\"12\"></circle>\n        <circle cx=\"12\" cy=\"12\" r=\"6\"></circle>\n      </svg>";
      }
      /**
       * Returns HTML string for an SVG used to represent incomple step (grey empty circle)
       */

    }, {
      key: "_getIncompleteSVG",
      value: function _getIncompleteSVG() {
        return "<svg>\n        <circle cx=\"12\" cy=\"12\" r=\"12\"></circle>\n      </svg>";
      }
    }, {
      key: "addOverflowTooltip",
      value: function addOverflowTooltip() {
        var _this3 = this;

        var stepLabels = toArray$7(this.element.querySelectorAll(this.options.selectorLabel));
        var tooltips = toArray$7(this.element.querySelectorAll(this.options.selectorTooltip));
        stepLabels.forEach(function (step) {
          if (step.scrollWidth > _this3.options.maxWidth) {
            step.classList.add(_this3.options.classOverflowLabel);
          }
        });
        tooltips.forEach(function (tooltip) {
          var childText = tooltip.querySelector(_this3.options.selectorTooltipText);

          if (childText.scrollHeight > _this3.options.tooltipMaxHeight) {
            tooltip.classList.add(_this3.options.classTooltipMulti);
          }
        });
      }
    }], [{
      key: "options",

      /**
       * The component options.
       * If `options` is specified in the constructor,
       * {@linkcode ProgressIndicator.create .create()}, or {@linkcode ProgressIndicator.init .init()},
       * properties in this object are overriden for the instance being created.
       * @member ProgressIndicator.options
       * @type {object}
       * @property {string} selectorInit The CSS selector to find content switcher button set.
       * @property {string} [selectorStepElement] The CSS selector to find step elements.
       * @property {string} [selectorCurrent] The CSS selector to find the current step element.
       * @property {string} [selectorIncomplete] The CSS class to find incomplete step elements.
       * @property {string} [selectorComplete] The CSS selector to find completed step elements.
       * @property {string} [classStep] The className for a step element.
       * @property {string} [classComplete] The className for a completed step element.
       * @property {string} [classCurrent] The className for the current step element.
       * @property {string} [classIncomplete] The className for a incomplete step element.
       */
      get: function get() {
        var prefix = settings_1.prefix;
        return {
          selectorInit: '[data-progress]',
          selectorStepElement: ".".concat(prefix, "--progress-step"),
          selectorCurrent: ".".concat(prefix, "--progress-step--current"),
          selectorIncomplete: ".".concat(prefix, "--progress-step--incomplete"),
          selectorComplete: ".".concat(prefix, "--progress-step--complete"),
          selectorLabel: ".".concat(prefix, "--progress-label"),
          selectorTooltip: ".".concat(prefix, "--tooltip"),
          selectorTooltipText: ".".concat(prefix, "--tooltip__text"),
          classStep: "".concat(prefix, "--progress-step"),
          classComplete: "".concat(prefix, "--progress-step--complete"),
          classCurrent: "".concat(prefix, "--progress-step--current"),
          classIncomplete: "".concat(prefix, "--progress-step--incomplete"),
          classOverflowLabel: "".concat(prefix, "--progress-label-overflow"),
          classTooltipMulti: "".concat(prefix, "--tooltip_multi"),
          maxWidth: 87,
          tooltipMaxHeight: 21
        };
      }
    }]);

    ProgressIndicator.components = new WeakMap();
    return ProgressIndicator;
  }(mixin(createComponent, initComponentBySearch));

  function _typeof$t(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof$t = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof$t = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof$t(obj);
  }

  function _classCallCheck$u(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$s(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$s(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$s(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$s(Constructor, staticProps);
    return Constructor;
  }

  function _possibleConstructorReturn$t(self, call) {
    if (call && (_typeof$t(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized$t(self);
  }

  function _assertThisInitialized$t(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _getPrototypeOf$t(o) {
    _getPrototypeOf$t = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf$t(o);
  }

  function _inherits$t(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf$t(subClass, superClass);
  }

  function _setPrototypeOf$t(o, p) {
    _setPrototypeOf$t = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf$t(o, p);
  }

  var toArray$8 = function toArray(arrayLike) {
    return Array.prototype.slice.call(arrayLike);
  };

  var StructuredList =
  /*#__PURE__*/
  function (_mixin) {
    _inherits$t(StructuredList, _mixin);
    /**
     * StructuredList
     * @extends CreateComponent
     * @extends InitComponentBySearch
     * @extends Handles
     * @param {HTMLElement} element The root element of tables
     * @param {object} [options] the... options
     * @param {string} [options.selectorInit] selector initialization
     * @param {string} [options.selectorRow] css selector for selected row
     */


    function StructuredList(element, options) {
      var _this;

      _classCallCheck$u(this, StructuredList);

      _this = _possibleConstructorReturn$t(this, _getPrototypeOf$t(StructuredList).call(this, element, options));

      _this.manage(on(_this.element, 'keydown', function (evt) {
        if (evt.which === 37 || evt.which === 38 || evt.which === 39 || evt.which === 40) {
          _this._handleKeydownArrow(evt);
        }

        if (evt.which === 13 || evt.which === 32) {
          _this._handleKeydownChecked(evt);
        }
      }));

      _this.manage(on(_this.element, 'click', function (evt) {
        _this._handleClick(evt);
      }));

      return _this;
    }

    _createClass$s(StructuredList, [{
      key: "_direction",
      value: function _direction(evt) {
        return {
          37: -1,
          // backward
          38: -1,
          // backward
          39: 1,
          // forward
          40: 1 // forward

        }[evt.which];
      }
    }, {
      key: "_nextIndex",
      value: function _nextIndex(array, arrayItem, direction) {
        return array.indexOf(arrayItem) + direction; // returns -1, 0, 1, 2, 3, 4...
      }
    }, {
      key: "_getInput",
      value: function _getInput(index) {
        var rows = toArray$8(this.element.querySelectorAll(this.options.selectorRow));
        return this.element.ownerDocument.querySelector(this.options.selectorListInput(rows[index].getAttribute('for')));
      }
    }, {
      key: "_handleInputChecked",
      value: function _handleInputChecked(index) {
        var rows = this.element.querySelectorAll(this.options.selectorRow);
        var input = this.getInput(index) || rows[index].querySelector('input');
        input.checked = true;
      }
    }, {
      key: "_handleClick",
      value: function _handleClick(evt) {
        var _this2 = this;

        var selectedRow = eventMatches(evt, this.options.selectorRow);
        toArray$8(this.element.querySelectorAll(this.options.selectorRow)).forEach(function (row) {
          return row.classList.remove(_this2.options.classActive);
        });

        if (selectedRow) {
          selectedRow.classList.add(this.options.classActive);
        }
      } // Handle Enter or Space keydown events for selecting <label> rows

    }, {
      key: "_handleKeydownChecked",
      value: function _handleKeydownChecked(evt) {
        var _this3 = this;

        evt.preventDefault(); // prevent spacebar from scrolling page

        var selectedRow = eventMatches(evt, this.options.selectorRow);
        toArray$8(this.element.querySelectorAll(this.options.selectorRow)).forEach(function (row) {
          return row.classList.remove(_this3.options.classActive);
        });

        if (selectedRow) {
          selectedRow.classList.add(this.options.classActive);
          var input = selectedRow.querySelector(this.options.selectorListInput(selectedRow.getAttribute('for'))) || selectedRow.querySelector('input');
          input.checked = true;
        }
      } // Handle up and down keydown events for selecting <label> rows

    }, {
      key: "_handleKeydownArrow",
      value: function _handleKeydownArrow(evt) {
        var _this4 = this;

        evt.preventDefault(); // prevent arrow keys from scrolling

        var selectedRow = eventMatches(evt, this.options.selectorRow);

        var direction = this._direction(evt);

        if (direction && selectedRow !== undefined) {
          var rows = toArray$8(this.element.querySelectorAll(this.options.selectorRow));
          rows.forEach(function (row) {
            return row.classList.remove(_this4.options.classActive);
          });
          var firstIndex = 0;

          var nextIndex = this._nextIndex(rows, selectedRow, direction);

          var lastIndex = rows.length - 1;

          var getSelectedIndex = function getSelectedIndex() {
            switch (nextIndex) {
              case -1:
                return lastIndex;

              case rows.length:
                return firstIndex;

              default:
                return nextIndex;
            }
          };

          var selectedIndex = getSelectedIndex();
          rows[selectedIndex].classList.add(this.options.classActive);
          rows[selectedIndex].focus();

          this._handleInputChecked(selectedIndex);
        }
      }
    }], [{
      key: "options",
      get: function get() {
        var prefix = settings_1.prefix;
        return {
          selectorInit: '[data-structured-list]',
          selectorRow: "[data-structured-list] .".concat(prefix, "--structured-list-tbody > label.").concat(prefix, "--structured-list-row"),
          selectorListInput: function selectorListInput(id) {
            return "#".concat(id, ".").concat(prefix, "--structured-list-input");
          },
          classActive: "".concat(prefix, "--structured-list-row--selected")
        };
      }
    }]);

    StructuredList.components = new WeakMap();
    return StructuredList;
  }(mixin(createComponent, initComponentBySearch, handles));

  function _typeof$u(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof$u = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof$u = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof$u(obj);
  }

  function _classCallCheck$v(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$t(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$t(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$t(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$t(Constructor, staticProps);
    return Constructor;
  }

  function _possibleConstructorReturn$u(self, call) {
    if (call && (_typeof$u(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized$u(self);
  }

  function _assertThisInitialized$u(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _getPrototypeOf$u(o) {
    _getPrototypeOf$u = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf$u(o);
  }

  function _inherits$u(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf$u(subClass, superClass);
  }

  function _setPrototypeOf$u(o, p) {
    _setPrototypeOf$u = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf$u(o, p);
  }

  var Slider =
  /*#__PURE__*/
  function (_mixin) {
    _inherits$u(Slider, _mixin);
    /**
     * Slider.
     * @extends CreateComponent
     * @extends InitComponentBySearch
     * @extends Handles
     * @param {HTMLElement} element The element working as an slider.
     */


    function Slider(element, options) {
      var _this;

      _classCallCheck$v(this, Slider);

      _this = _possibleConstructorReturn$u(this, _getPrototypeOf$u(Slider).call(this, element, options));

      _this._changeState = function (state, detail, callback) {
        callback();
      };

      _this.sliderActive = false;
      _this.dragging = false;
      _this.track = _this.element.querySelector(_this.options.selectorTrack);
      _this.filledTrack = _this.element.querySelector(_this.options.selectorFilledTrack);
      _this.thumb = _this.element.querySelector(_this.options.selectorThumb);
      _this.input = _this.element.querySelector(_this.options.selectorInput);

      if (_this.element.dataset.sliderInputBox) {
        _this.boundInput = _this.element.ownerDocument.querySelector(_this.element.dataset.sliderInputBox);

        _this._updateInput();

        _this.manage(on(_this.boundInput, 'change', function (evt) {
          _this.setValue(evt.target.value);
        }));

        _this.manage(on(_this.boundInput, 'focus', function (evt) {
          evt.target.select();
        })); // workaround for safari


        _this.manage(on(_this.boundInput, 'mouseup', function (evt) {
          evt.preventDefault();
        }));
      }

      _this._updatePosition();

      _this.manage(on(_this.thumb, 'mousedown', function () {
        _this.sliderActive = true;
      }));

      _this.manage(on(_this.element.ownerDocument, 'mouseup', function () {
        _this.sliderActive = false;
      }));

      _this.manage(on(_this.element.ownerDocument, 'mousemove', function (evt) {
        var disabled = _this.element.classList.contains(_this.options.classDisabled);

        if (_this.sliderActive === true && !disabled) {
          _this._updatePosition(evt);
        }
      }));

      _this.manage(on(_this.thumb, 'keydown', function (evt) {
        var disabled = _this.element.classList.contains(_this.options.classDisabled);

        if (!disabled) {
          _this._updatePosition(evt);
        }
      }));

      _this.manage(on(_this.track, 'click', function (evt) {
        var disabled = _this.element.classList.contains(_this.options.classDisabled);

        if (!disabled) {
          _this._updatePosition(evt);
        }
      }));

      return _this;
    }

    _createClass$t(Slider, [{
      key: "_updatePosition",
      value: function _updatePosition(evt) {
        var _this2 = this;

        var _this$_calcValue = this._calcValue(evt),
            left = _this$_calcValue.left,
            newValue = _this$_calcValue.newValue;

        if (this.dragging) {
          return;
        }

        this.dragging = true;
        requestAnimationFrame(function () {
          _this2.dragging = false;
          _this2.thumb.style.left = "".concat(left, "%");
          _this2.filledTrack.style.transform = "translate(0%, -50%) scaleX(".concat(left / 100, ")");
          _this2.input.value = newValue;

          _this2._updateInput();

          _this2.changeState('slider-value-change', {
            value: newValue
          });
        });
      }
    }, {
      key: "_calcValue",
      value: function _calcValue(evt) {
        var _this$getInputProps = this.getInputProps(),
            value = _this$getInputProps.value,
            min = _this$getInputProps.min,
            max = _this$getInputProps.max,
            step = _this$getInputProps.step;

        var range = max - min;
        var valuePercentage = (value - min) / range * 100;
        var left;
        var newValue;
        left = valuePercentage;
        newValue = value;

        if (evt) {
          var type = evt.type;

          if (type === 'keydown') {
            var direction = {
              40: -1,
              // decreasing
              37: -1,
              // decreasing
              38: 1,
              // increasing
              39: 1 // increasing

            }[evt.which];

            if (direction !== undefined) {
              var multiplier = evt.shiftKey === true ? range / step / this.options.stepMultiplier : 1;
              var stepMultiplied = step * multiplier;
              var stepSize = stepMultiplied / range * 100;
              left = valuePercentage + stepSize * direction;
              newValue = Number(value) + stepMultiplied * direction;
            }
          }

          if (type === 'mousemove' || type === 'click') {
            if (type === 'click') {
              this.element.querySelector(this.options.selectorThumb).classList.add(this.options.classThumbClicked);
            } else {
              this.element.querySelector(this.options.selectorThumb).classList.remove(this.options.classThumbClicked);
            }

            var track = this.track.getBoundingClientRect();
            var unrounded = (evt.clientX - track.left) / track.width;
            var rounded = Math.round(range * unrounded / step) * step;
            left = rounded / range * 100;
            newValue = rounded + min;
          }
        }

        if (newValue <= Number(min)) {
          left = 0;
          newValue = min;
        }

        if (newValue >= Number(max)) {
          left = 100;
          newValue = max;
        }

        return {
          left: left,
          newValue: newValue
        };
      }
    }, {
      key: "_updateInput",
      value: function _updateInput() {
        if (this.boundInput) {
          this.boundInput.value = this.input.value;
        }
      }
    }, {
      key: "getInputProps",
      value: function getInputProps() {
        var values = {
          value: Number(this.input.value),
          min: Number(this.input.min),
          max: Number(this.input.max),
          step: this.input.step ? Number(this.input.step) : 1
        };
        return values;
      }
    }, {
      key: "setValue",
      value: function setValue(value) {
        this.input.value = value;

        this._updatePosition();
      }
    }, {
      key: "stepUp",
      value: function stepUp() {
        this.input.stepUp();

        this._updatePosition();
      }
    }, {
      key: "stepDown",
      value: function stepDown() {
        this.input.stepDown();

        this._updatePosition();
      }
      /**
       * The map associating DOM element and Slider UI instance.
       * @type {WeakMap}
       */

    }], [{
      key: "options",

      /**
       * The component options.
       * If `options` is specified in the constructor,
       * properties in this object are overriden for the instance being created.
       * @property {string} selectorInit The CSS selector to find slider instances.
       */
      get: function get() {
        var prefix = settings_1.prefix;
        return {
          selectorInit: '[data-slider]',
          selectorTrack: ".".concat(prefix, "--slider__track"),
          selectorFilledTrack: ".".concat(prefix, "--slider__filled-track"),
          selectorThumb: ".".concat(prefix, "--slider__thumb"),
          selectorInput: ".".concat(prefix, "--slider__input"),
          classDisabled: "".concat(prefix, "--slider--disabled"),
          classThumbClicked: "".concat(prefix, "--slider__thumb--clicked"),
          eventBeforeSliderValueChange: 'slider-before-value-change',
          eventAfterSliderValueChange: 'slider-after-value-change',
          stepMultiplier: 4
        };
      }
    }]);

    Slider.components = new WeakMap();
    return Slider;
  }(mixin(createComponent, initComponentBySearch, eventedState, handles));

  function _typeof$v(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof$v = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof$v = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof$v(obj);
  }

  function _classCallCheck$w(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$u(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$u(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$u(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$u(Constructor, staticProps);
    return Constructor;
  }

  function _possibleConstructorReturn$v(self, call) {
    if (call && (_typeof$v(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized$v(self);
  }

  function _assertThisInitialized$v(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _get$3(target, property, receiver) {
    if (typeof Reflect !== "undefined" && Reflect.get) {
      _get$3 = Reflect.get;
    } else {
      _get$3 = function _get(target, property, receiver) {
        var base = _superPropBase$3(target, property);

        if (!base) return;
        var desc = Object.getOwnPropertyDescriptor(base, property);

        if (desc.get) {
          return desc.get.call(receiver);
        }

        return desc.value;
      };
    }

    return _get$3(target, property, receiver || target);
  }

  function _superPropBase$3(object, property) {
    while (!Object.prototype.hasOwnProperty.call(object, property)) {
      object = _getPrototypeOf$v(object);
      if (object === null) break;
    }

    return object;
  }

  function _getPrototypeOf$v(o) {
    _getPrototypeOf$v = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf$v(o);
  }

  function _inherits$v(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf$v(subClass, superClass);
  }

  function _setPrototypeOf$v(o, p) {
    _setPrototypeOf$v = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf$v(o, p);
  }

  var Tile =
  /*#__PURE__*/
  function (_mixin) {
    _inherits$v(Tile, _mixin);
    /**
     * Tile.
     * @extends CreateComponent
     * @extends InitComponentBySearch
     * @param {HTMLElement} element The element working as an Tile.
     */


    function Tile(element, options) {
      var _this;

      _classCallCheck$w(this, Tile);

      _this = _possibleConstructorReturn$v(this, _getPrototypeOf$v(Tile).call(this, element, options));

      _this._getClass = function (type) {
        var typeObj = {
          expandable: _this.options.classExpandedTile,
          clickable: _this.options.classClickableTile,
          selectable: _this.options.classSelectableTile
        };
        return typeObj[type];
      };

      _this._hookActions = function (tileClass) {
        var isExpandable = _this.tileType === 'expandable';

        if (isExpandable) {
          var aboveTheFold = _this.element.querySelector(_this.options.selectorAboveTheFold);

          var getStyle = _this.element.ownerDocument.defaultView.getComputedStyle(_this.element, null);

          var tilePaddingTop = parseInt(getStyle.getPropertyValue('padding-top'), 10);
          var tilePaddingBottom = parseInt(getStyle.getPropertyValue('padding-bottom'), 10);
          var tilePadding = tilePaddingTop + tilePaddingBottom;

          if (aboveTheFold) {
            _this.tileHeight = _this.element.getBoundingClientRect().height;
            _this.atfHeight = aboveTheFold.getBoundingClientRect().height + tilePadding;
            _this.element.style.maxHeight = "".concat(_this.atfHeight, "px");
          }

          if (_this.element.classList.contains(_this.options.classExpandedTile)) {
            _this._setTileHeight();
          }
        }

        _this.element.addEventListener('click', function (evt) {
          var input = eventMatches(evt, _this.options.selectorTileInput);

          if (!input) {
            _this.element.classList.toggle(tileClass);
          }

          if (isExpandable) {
            _this._setTileHeight();
          }
        });

        _this.element.addEventListener('keydown', function (evt) {
          var input = _this.element.querySelector(_this.options.selectorTileInput);

          if (input) {
            if (evt.which === 13 || evt.which === 32) {
              if (!isExpandable) {
                _this.element.classList.toggle(tileClass);

                input.checked = !input.checked;
              }
            }
          }
        });
      };

      _this._setTileHeight = function () {
        var isExpanded = _this.element.classList.contains(_this.options.classExpandedTile);

        _this.element.style.maxHeight = isExpanded ? "".concat(_this.tileHeight, "px") : "".concat(_this.atfHeight, "px");
      };

      _this.tileType = _this.element.dataset.tile;
      _this.tileHeight = 0; // Tracks expandable tile height

      _this.atfHeight = 0; // Tracks above the fold height

      _this._hookActions(_this._getClass(_this.tileType));

      return _this;
    }

    _createClass$u(Tile, [{
      key: "release",
      value: function release() {
        _get$3(_getPrototypeOf$v(Tile.prototype), "release", this).call(this);
      }
      /**
       * The map associating DOM element and Tile UI instance.
       * @type {WeakMap}
       */

    }], [{
      key: "options",

      /**
       * The component options.
       * If `options` is specified in the constructor,
       * properties in this object are overriden for the instance being created.
       * @property {string} selectorInit The CSS selector to find Tile instances.
       */
      get: function get() {
        var prefix = settings_1.prefix;
        return {
          selectorInit: '[data-tile]',
          selectorAboveTheFold: '[data-tile-atf]',
          selectorTileInput: '[data-tile-input]',
          classExpandedTile: "".concat(prefix, "--tile--is-expanded"),
          classClickableTile: "".concat(prefix, "--tile--is-clicked"),
          classSelectableTile: "".concat(prefix, "--tile--is-selected")
        };
      }
    }]);

    Tile.components = new WeakMap();
    return Tile;
  }(mixin(createComponent, initComponentBySearch));

  function _typeof$w(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof$w = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof$w = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof$w(obj);
  }

  function _classCallCheck$x(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$v(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$v(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$v(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$v(Constructor, staticProps);
    return Constructor;
  }

  function _possibleConstructorReturn$w(self, call) {
    if (call && (_typeof$w(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized$w(self);
  }

  function _assertThisInitialized$w(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _getPrototypeOf$w(o) {
    _getPrototypeOf$w = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf$w(o);
  }

  function _inherits$w(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf$w(subClass, superClass);
  }

  function _setPrototypeOf$w(o, p) {
    _setPrototypeOf$w = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf$w(o, p);
  }

  var CodeSnippet =
  /*#__PURE__*/
  function (_mixin) {
    _inherits$w(CodeSnippet, _mixin);
    /**
     * CodeSnippet UI.
     * @extends CreateComponent
     * @extends InitComponentBySearch
     * @extends Handles
     * @param {HTMLElement} element The element working as a CodeSnippet UI.
     */


    function CodeSnippet(element, options) {
      var _this;

      _classCallCheck$x(this, CodeSnippet);

      _this = _possibleConstructorReturn$w(this, _getPrototypeOf$w(CodeSnippet).call(this, element, options));

      _this._initCodeSnippet();

      _this.element.querySelector(_this.options.classExpandBtn).addEventListener('click', function (evt) {
        return _this._handleClick(evt);
      });

      return _this;
    }

    _createClass$v(CodeSnippet, [{
      key: "_handleClick",
      value: function _handleClick() {
        var expandBtn = this.element.querySelector(this.options.classExpandText);
        this.element.classList.toggle(this.options.classExpanded);

        if (this.element.classList.contains(this.options.classExpanded)) {
          expandBtn.textContent = expandBtn.getAttribute(this.options.attribShowLessText);
        } else {
          expandBtn.textContent = expandBtn.getAttribute(this.options.attribShowMoreText);
        }
      }
    }, {
      key: "_initCodeSnippet",
      value: function _initCodeSnippet() {
        var expandBtn = this.element.querySelector(this.options.classExpandText);

        if (!expandBtn) {
          throw new TypeError('Cannot find the expand button.');
        }

        expandBtn.textContent = expandBtn.getAttribute(this.options.attribShowMoreText);

        if (this.element.offsetHeight < this.options.minHeight) {
          this.element.classList.add(this.options.classHideExpand);
        }
      }
      /**
       * The map associating DOM element and code snippet UI instance.
       * @member CodeSnippet.components
       * @type {WeakMap}
       */

    }], [{
      key: "options",

      /**
       * The component options.
       * If `options` is specified in the constructor, {@linkcode CodeSnippet.create .create()},
       * or {@linkcode CodeSnippet.init .init()},
       * properties in this object are overriden for the instance being create and how {@linkcode CodeSnippet.init .init()} works.
       * @member CodeSnippet.options
       * @type {object}
       * @property {string} selectorInit The data attribute to find code snippet UIs.
       */
      get: function get() {
        var prefix = settings_1.prefix;
        return {
          selectorInit: '[data-code-snippet]',
          attribShowMoreText: 'data-show-more-text',
          attribShowLessText: 'data-show-less-text',
          minHeight: 288,
          classExpanded: "".concat(prefix, "--snippet--expand"),
          classExpandBtn: ".".concat(prefix, "--snippet-btn--expand"),
          classExpandText: ".".concat(prefix, "--snippet-btn--text"),
          classHideExpand: "".concat(prefix, "--snippet-btn--expand--hide")
        };
      }
    }]);

    CodeSnippet.components = new WeakMap();
    return CodeSnippet;
  }(mixin(createComponent, initComponentBySearch, handles));

  function _typeof$x(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof$x = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof$x = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof$x(obj);
  }

  function _classCallCheck$y(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$w(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$w(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$w(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$w(Constructor, staticProps);
    return Constructor;
  }

  function _possibleConstructorReturn$x(self, call) {
    if (call && (_typeof$x(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized$x(self);
  }

  function _assertThisInitialized$x(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _getPrototypeOf$x(o) {
    _getPrototypeOf$x = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf$x(o);
  }

  function _inherits$x(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf$x(subClass, superClass);
  }

  function _setPrototypeOf$x(o, p) {
    _setPrototypeOf$x = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf$x(o, p);
  }

  var TextInput =
  /*#__PURE__*/
  function (_mixin) {
    _inherits$x(TextInput, _mixin);
    /**
     * Text Input.
     * @extends CreateComponent
     * @extends InitComponentBySearch
     * @extends Handles
     * @param {HTMLElement} element - The element functioning as a text field.
     */


    function TextInput(_element, options) {
      var _this;

      _classCallCheck$y(this, TextInput);

      _this = _possibleConstructorReturn$x(this, _getPrototypeOf$x(TextInput).call(this, _element, options));

      _this._setIconVisibility = function (_ref) {
        var iconVisibilityOn = _ref.iconVisibilityOn,
            iconVisibilityOff = _ref.iconVisibilityOff,
            passwordIsVisible = _ref.passwordIsVisible,
            selectorPasswordVisibilityTooltip = _ref.selectorPasswordVisibilityTooltip;

        if (passwordIsVisible) {
          iconVisibilityOn.setAttribute('hidden', true);
          iconVisibilityOff.removeAttribute('hidden');
          selectorPasswordVisibilityTooltip.textContent = 'Hide password';
          return;
        }

        iconVisibilityOn.removeAttribute('hidden');
        iconVisibilityOff.setAttribute('hidden', true);
        selectorPasswordVisibilityTooltip.textContent = 'Show password';
      };

      _this._toggle = function (_ref2) {
        var element = _ref2.element,
            button = _ref2.button; // toggle action must come before querying the classList

        element.classList.toggle(_this.options.passwordIsVisible);
        var passwordIsVisible = element.classList.contains(_this.options.passwordIsVisible);
        var iconVisibilityOn = button.querySelector(_this.options.svgIconVisibilityOn);
        var iconVisibilityOff = button.querySelector(_this.options.svgIconVisibilityOff);
        var input = element.querySelector(_this.options.selectorPasswordField);
        var selectorPasswordVisibilityTooltip = element.querySelector(_this.options.selectorPasswordVisibilityTooltip);

        _this._setIconVisibility({
          iconVisibilityOn: iconVisibilityOn,
          iconVisibilityOff: iconVisibilityOff,
          passwordIsVisible: passwordIsVisible,
          selectorPasswordVisibilityTooltip: selectorPasswordVisibilityTooltip
        });

        input.type = passwordIsVisible ? 'text' : 'password';
      };

      _this.manage(on(_this.element, 'click', function (event) {
        var toggleVisibilityButton = eventMatches(event, _this.options.selectorPasswordVisibilityButton);

        if (toggleVisibilityButton) {
          _this._toggle({
            element: _element,
            button: toggleVisibilityButton
          });
        }
      }));

      return _this;
    }
    /**
     *
     * @param {object} obj - Object containing selectors and visibility status
     * @param {HTMLElement} obj.iconVisibilityOn - The element functioning as
     * the SVG icon for visibility on
     * @param {HTMLElement} obj.iconVisibilityOff - The element functioning as
     * the SVG icon for visibility off
     * @param {boolean} obj.passwordIsVisible - The visibility of the password in the
     * input field
     */


    _createClass$w(TextInput, null, [{
      key: "options",

      /**
       * The component options.
       *
       * If `options` is specified in the constructor,
       * {@linkcode TextInput.create .create()},
       * or {@linkcode TextInput.init .init()},
       * properties in this object are overriden for the instance being
       * created and how {@linkcode TextInput.init .init()} works.
       * @property {string} selectorInit The CSS selector to find text input UIs.
       */
      get: function get() {
        var prefix = settings_1.prefix;
        return {
          selectorInit: '[data-text-input]',
          selectorPasswordField: ".".concat(prefix, "--text-input[data-toggle-password-visibility]"),
          selectorPasswordVisibilityButton: ".".concat(prefix, "--text-input--password__visibility__toggle"),
          selectorPasswordVisibilityTooltip: ".".concat(prefix, "--text-input--password__visibility__toggle > .").concat(prefix, "--assistive-text"),
          passwordIsVisible: "".concat(prefix, "--text-input--password-visible"),
          svgIconVisibilityOn: "svg.".concat(prefix, "--icon--visibility-on"),
          svgIconVisibilityOff: "svg.".concat(prefix, "--icon--visibility-off")
        };
      }
      /**
       * The map associating DOM element and text input UI instance.
       * @type {WeakMap}
       */

    }]);

    TextInput.components = new WeakMap();
    return TextInput;
  }(mixin(createComponent, initComponentBySearch, handles));

  function _typeof$y(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof$y = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof$y = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof$y(obj);
  }

  function _toConsumableArray$6(arr) {
    return _arrayWithoutHoles$6(arr) || _iterableToArray$6(arr) || _nonIterableSpread$6();
  }

  function _nonIterableSpread$6() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray$6(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles$6(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }

      return arr2;
    }
  }

  function _classCallCheck$z(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$x(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$x(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$x(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$x(Constructor, staticProps);
    return Constructor;
  }

  function _possibleConstructorReturn$y(self, call) {
    if (call && (_typeof$y(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized$y(self);
  }

  function _assertThisInitialized$y(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _getPrototypeOf$y(o) {
    _getPrototypeOf$y = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf$y(o);
  }

  function _inherits$y(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf$y(subClass, superClass);
  }

  function _setPrototypeOf$y(o, p) {
    _setPrototypeOf$y = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf$y(o, p);
  }
  var prefix = settings_1.prefix;

  var SideNav =
  /*#__PURE__*/
  function (_mixin) {
    _inherits$y(SideNav, _mixin);
    /**
     * The map associating DOM element and copy button UI instance.
     * @member SideNav.components
     * @type {WeakMap}
     */


    function SideNav(element, options) {
      var _this;

      _classCallCheck$z(this, SideNav);

      _this = _possibleConstructorReturn$y(this, _getPrototypeOf$y(SideNav).call(this, element, options));

      _this._handleClick = function (evt) {
        var matchesToggle = eventMatches(evt, _this.options.selectorSideNavToggle);
        var matchesNavSubmenu = eventMatches(evt, _this.options.selectorSideNavSubmenu);
        var matchesSideNavLink = eventMatches(evt, _this.options.selectorSideNavLink);

        if (!matchesToggle && !matchesNavSubmenu && !matchesSideNavLink) {
          return;
        }

        if (matchesToggle) {
          _this.changeState(!_this.isNavExpanded() ? _this.constructor.state.EXPANDED : _this.constructor.state.COLLAPSED);

          return;
        }

        if (matchesNavSubmenu) {
          var isSubmenuExpanded = matchesNavSubmenu.getAttribute('aria-expanded') === 'true';
          matchesNavSubmenu.setAttribute('aria-expanded', "".concat(!isSubmenuExpanded));
          return;
        }

        if (matchesSideNavLink) {
          _toConsumableArray$6(_this.element.querySelectorAll(_this.options.selectorSideNavLinkCurrent)).forEach(function (el) {
            el.classList.remove(_this.options.classSideNavItemActive, _this.options.classSideNavLinkCurrent);
            el.removeAttribute('aria-current');
          });

          matchesSideNavLink.classList.add(_this.options.classSideNavLinkCurrent);
          var closestSideNavItem = matchesSideNavLink.closest(_this.options.selectorSideNavItem);

          if (closestSideNavItem) {
            closestSideNavItem.classList.add(_this.options.classSideNavItemActive);
          }
        }
      };

      _this.manage(on(element, 'click', _this._handleClick));

      return _this;
    }
    /**
     * Enum for toggling side nav visibility
     * @readonly
     * @member SideNav.state
     * @type {Object}
     * @property {string} EXPANDED Opening/visible
     * @property {string} COLLAPSED Closing/hidden
     */


    _createClass$x(SideNav, [{
      key: "isNavExpanded",

      /**
       * @returns {boolean} `true` if the nav is expanded.
       */
      value: function isNavExpanded() {
        return this.element.classList.contains(this.options.classSideNavExpanded);
      }
      /**
       * Changes the expanded/collapsed state.
       */

    }, {
      key: "changeState",
      value: function changeState(state) {
        this.element.classList.toggle(this.options.classSideNavExpanded, state === this.constructor.state.EXPANDED);
      }
    }]);

    SideNav.components = new WeakMap();
    SideNav.state = {
      EXPANDED: 'expanded',
      COLLAPSED: 'collapsed'
    };
    SideNav.options = {
      selectorInit: '[data-side-nav]',
      selectorSideNavToggle: ".".concat(prefix, "--side-nav__toggle"),
      selectorSideNavSubmenu: ".".concat(prefix, "--side-nav__submenu"),
      selectorSideNavItem: ".".concat(prefix, "--side-nav__item"),
      selectorSideNavLink: ".".concat(prefix, "--side-nav__link"),
      selectorSideNavLinkCurrent: "[aria-current=\"page\"],.".concat(prefix, "--side-nav__link--current,.").concat(prefix, "--side-nav__item--active"),
      classSideNavExpanded: "".concat(prefix, "--side-nav--expanded"),
      classSideNavItemActive: "".concat(prefix, "--side-nav__item--active"),
      classSideNavLinkCurrent: "".concat(prefix, "--side-nav__link--current")
    };
    return SideNav;
  }(mixin(createComponent, initComponentBySearch, handles));

  function _typeof$z(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof$z = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof$z = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof$z(obj);
  }

  function _slicedToArray$1(arr, i) {
    return _arrayWithHoles$1(arr) || _iterableToArrayLimit$1(arr, i) || _nonIterableRest$1();
  }

  function _nonIterableRest$1() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit$1(arr, i) {
    var _arr = [];
    var _n = true;
    var _d = false;
    var _e = undefined;

    try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);

        if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;
      _e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }

    return _arr;
  }

  function _arrayWithHoles$1(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function _classCallCheck$A(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$y(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$y(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$y(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$y(Constructor, staticProps);
    return Constructor;
  }

  function _possibleConstructorReturn$z(self, call) {
    if (call && (_typeof$z(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized$z(self);
  }

  function _assertThisInitialized$z(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _getPrototypeOf$z(o) {
    _getPrototypeOf$z = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf$z(o);
  }

  function _inherits$z(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf$z(subClass, superClass);
  }

  function _setPrototypeOf$z(o, p) {
    _setPrototypeOf$z = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf$z(o, p);
  }

  var forEach =
  /* #__PURE__ */
  function () {
    return Array.prototype.forEach;
  }();

  var toArray$9 = function toArray(arrayLike) {
    return Array.prototype.slice.call(arrayLike);
  };

  var HeaderSubmenu =
  /*#__PURE__*/
  function (_mixin) {
    _inherits$z(HeaderSubmenu, _mixin);

    function HeaderSubmenu(element, options) {
      var _this;

      _classCallCheck$A(this, HeaderSubmenu);

      _this = _possibleConstructorReturn$z(this, _getPrototypeOf$z(HeaderSubmenu).call(this, element, options));

      _this._getAction = function (event) {
        var isFlyoutMenu = eventMatches(event, _this.options.selectorFlyoutMenu);

        if (isFlyoutMenu) {
          return _this.constructor.actions.DELEGATE_TO_FLYOUT_MENU;
        }

        switch (event.type) {
          case 'keydown':
            return {
              32: _this.constructor.actions.TOGGLE_SUBMENU_WITH_FOCUS,
              // space bar
              13: _this.constructor.actions.TOGGLE_SUBMENU_WITH_FOCUS,
              // enter
              27: _this.constructor.actions.CLOSE_SUBMENU // esc
              // possible arrow keys

            }[event.which];

          case 'click':
            return eventMatches(event, _this.options.selectorItem) ? _this.constructor.actions.CLOSE_SUBMENU : null;

          case 'blur':
          case 'focusout':
            {
              var isOfSelf = _this.element.contains(event.relatedTarget);

              return isOfSelf ? null : _this.constructor.actions.CLOSE_SUBMENU;
            }

          case 'mouseenter':
            return _this.constructor.actions.OPEN_SUBMENU;

          case 'mouseleave':
            return _this.constructor.actions.CLOSE_SUBMENU;

          default:
            return null;
        }
      };

      _this._getNewState = function (action) {
        var trigger = _this.element.querySelector(_this.options.selectorTrigger);

        var isExpanded = trigger.getAttribute(_this.options.attribExpanded) === 'true';

        switch (action) {
          case _this.constructor.actions.CLOSE_SUBMENU:
            return false;

          case _this.constructor.actions.OPEN_SUBMENU:
            return true;

          case _this.constructor.actions.TOGGLE_SUBMENU_WITH_FOCUS:
            return !isExpanded;

          default:
            return isExpanded;
        }
      };

      _this._setState = function (_ref) {
        var shouldBeExpanded = _ref.shouldBeExpanded,
            shouldFocusOnOpen = _ref.shouldFocusOnOpen;

        var trigger = _this.element.querySelector(_this.options.selectorTrigger);

        trigger.setAttribute(_this.options.attribExpanded, shouldBeExpanded);
        forEach.call(_this.element.querySelectorAll(_this.options.selectorItem), function (item) {
          item.tabIndex = shouldBeExpanded ? 0 : -1;
        }); // focus first submenu item

        if (shouldBeExpanded && shouldFocusOnOpen) {
          _this.element.querySelector(_this.options.selectorItem).focus();
        }
      };

      _this.getCurrentNavigation = function () {
        var focused = _this.element.ownerDocument.activeElement;
        return focused.nodeType === Node.ELEMENT_NODE && focused.matches(_this.options.selectorItem) ? focused : null;
      };

      _this.navigate = function (direction) {
        var items = toArray$9(_this.element.querySelectorAll(_this.options.selectorItem));

        var start = _this.getCurrentNavigation() || _this.element.querySelector(_this.options.selectorItemSelected);

        var getNextItem = function getNextItem(old) {
          var handleUnderflow = function handleUnderflow(index, length) {
            return index + (index >= 0 ? 0 : length);
          };

          var handleOverflow = function handleOverflow(index, length) {
            return index - (index < length ? 0 : length);
          }; // `items.indexOf(old)` may be -1 (Scenario of no previous focus)


          var index = Math.max(items.indexOf(old) + direction, -1);
          return items[handleUnderflow(handleOverflow(index, items.length), items.length)];
        };

        for (var current = getNextItem(start); current && current !== start; current = getNextItem(current)) {
          if (!current.matches(_this.options.selectorItemHidden) && !current.parentNode.matches(_this.options.selectorItemHidden) && !current.matches(_this.options.selectorItemSelected)) {
            current.focus();
            break;
          }
        }
      };

      _this._handleEvent = function (event) {
        var trigger = _this.element.querySelector(_this.options.selectorTrigger);

        if (!trigger) {
          return;
        }

        var action = _this._getAction(event);

        if (action) {
          var shouldBeExpanded = _this._getNewState(action);

          _this._setState({
            shouldBeExpanded: shouldBeExpanded
          });
        }
      };

      _this._handleKeyDown = function (event) {
        var trigger = _this.element.querySelector(_this.options.selectorTrigger);

        if (!trigger) {
          return;
        }

        var action = _this._getAction(event);

        if (event.which === 32) {
          event.preventDefault();
        }

        switch (action) {
          case _this.constructor.actions.DELEGATE_TO_FLYOUT_MENU:
            // currently we do not have a scenario that handles flyout menu
            // handleFlyoutMenu
            break;
          // currently we do not have a scenario that opens a submenu on keydown
          // case this.constructor.actions.OPEN_SUBMENU:

          case _this.constructor.actions.CLOSE_SUBMENU:
            {
              var shouldBeExpanded = _this._getNewState(action);

              _this._setState({
                shouldBeExpanded: shouldBeExpanded
              });

              break;
            }

          case _this.constructor.actions.TOGGLE_SUBMENU_WITH_FOCUS:
            {
              var _shouldBeExpanded = _this._getNewState(action);

              _this._setState({
                shouldBeExpanded: _shouldBeExpanded,
                shouldFocusOnOpen: true
              });

              break;
            }

          default:
            {
              var expanded = trigger.getAttribute(_this.options.attribExpanded) === 'true';

              if (expanded) {
                var direction = {
                  38: _this.constructor.NAVIGATE.BACKWARD,
                  40: _this.constructor.NAVIGATE.FORWARD
                }[event.which];

                switch (event.which) {
                  case 35:
                    {
                      // end key
                      event.preventDefault(); // prevents key from scrolling page

                      var menuItems = _this.element.querySelectorAll(_this.options.selectorItem);

                      var lastMenuItem = menuItems[menuItems.length - 1];

                      if (lastMenuItem) {
                        lastMenuItem.focus();
                      }

                      break;
                    }

                  case 36:
                    {
                      // home key
                      event.preventDefault(); // prevents key from scrolling page

                      var _this$element$querySe = _this.element.querySelectorAll(_this.options.selectorItem),
                          _this$element$querySe2 = _slicedToArray$1(_this$element$querySe, 1),
                          firstMenuItem = _this$element$querySe2[0];

                      if (firstMenuItem) {
                        firstMenuItem.focus();
                      }

                      break;
                    }

                  case 38: // up arrow

                  case 40:
                    // down arrow
                    _this.navigate(direction);

                    event.preventDefault(); // prevents keys from scrolling page

                    break;

                  default:
                    break;
                }
              }

              break;
            }
        }
      };

      var hasFocusOut = 'onfocusout' in window;

      _this.manage(on(_this.element, hasFocusOut ? 'focusout' : 'blur', _this._handleEvent, !hasFocusOut));

      _this.manage(on(_this.element, 'mouseenter', _this._handleEvent));

      _this.manage(on(_this.element, 'mouseleave', _this._handleEvent));

      _this.manage(on(_this.element, 'click', _this._handleEvent));

      _this.manage(on(_this.element, 'keydown', _this._handleKeyDown));

      return _this;
    }
    /**
     * The map associating DOM element and HeaderSubmenu instance.
     * @member HeaderSubmenu.components
     * @type {WeakMap}
     */


    _createClass$y(HeaderSubmenu, null, [{
      key: "options",

      /**
       * The component options.
       * If `options` is specified in the constructor,
       * {@linkcode HeaderSubmenu.create .create()}, or
       * {@linkcode HeaderSubmenu.init .init()},
       * properties in this object are overriden for the instance being create and
       * how {@linkcode HeaderSubmenu.init .init()} works.
       * @member HeaderSubmenu.options
       * @type {object}
       * @property {string} selectorInit The data attribute to find side navs.
       */
      get: function get() {
        var prefix = settings_1.prefix;
        return {
          selectorInit: '[data-header-submenu]',
          selectorTrigger: ".".concat(prefix, "--header__menu-title"),
          selectorItem: ".".concat(prefix, "--header__menu .").concat(prefix, "--header__menu-item"),
          attribExpanded: 'aria-expanded'
        };
      }
      /**
       * Enum for navigating backward/forward.
       * @readonly
       * @member HeaderSubmenu.NAVIGATE
       * @type {Object}
       * @property {number} BACKWARD Navigating backward.
       * @property {number} FORWARD Navigating forward.
       */

    }]);

    HeaderSubmenu.components = new WeakMap();
    HeaderSubmenu.actions = {
      CLOSE_SUBMENU: 'CLOSE_SUBMENU',
      OPEN_SUBMENU: 'OPEN_SUBMENU',
      TOGGLE_SUBMENU_WITH_FOCUS: 'TOGGLE_SUBMENU_WITH_FOCUS',
      DELEGATE_TO_FLYOUT_MENU: 'DELEGATE_TO_FLYOUT_MENU'
    };
    HeaderSubmenu.NAVIGATE = {
      BACKWARD: -1,
      FORWARD: 1
    };
    return HeaderSubmenu;
  }(mixin(createComponent, initComponentBySearch, handles));

  function _typeof$A(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof$A = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof$A = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof$A(obj);
  }

  function _classCallCheck$B(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$z(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$z(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$z(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$z(Constructor, staticProps);
    return Constructor;
  }

  function _possibleConstructorReturn$A(self, call) {
    if (call && (_typeof$A(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized$A(self);
  }

  function _assertThisInitialized$A(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _getPrototypeOf$A(o) {
    _getPrototypeOf$A = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf$A(o);
  }

  function _inherits$A(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf$A(subClass, superClass);
  }

  function _setPrototypeOf$A(o, p) {
    _setPrototypeOf$A = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf$A(o, p);
  }

  var toArray$a = function toArray(arrayLike) {
    return Array.prototype.slice.call(arrayLike);
  };

  var HeaderNav =
  /*#__PURE__*/
  function (_mixin) {
    _inherits$A(HeaderNav, _mixin);

    function HeaderNav(element, options) {
      var _this;

      _classCallCheck$B(this, HeaderNav);

      _this = _possibleConstructorReturn$A(this, _getPrototypeOf$A(HeaderNav).call(this, element, options));

      _this.getCurrentNavigation = function () {
        var focused = _this.element.ownerDocument.activeElement.closest(_this.options.selectorSubmenu);

        return focused && focused.nodeType === Node.ELEMENT_NODE ? focused.querySelector(_this.options.selectorSubmenuLink) : null;
      };

      _this.navigate = function (direction) {
        var items = toArray$a(_this.element.querySelectorAll(_this.options.selectorSubmenuLink));

        var start = _this.getCurrentNavigation();

        var getNextItem = function getNextItem(old) {
          var handleUnderflow = function handleUnderflow(index, length) {
            return index + (index >= 0 ? 0 : length);
          };

          var handleOverflow = function handleOverflow(index, length) {
            return index - (index < length ? 0 : length);
          }; // `items.indexOf(old)` may be -1 (Scenario of no previous focus)


          var index = Math.max(items.indexOf(old) + direction, -1);
          return items[handleUnderflow(handleOverflow(index, items.length), items.length)];
        };

        getNextItem(start).focus();
      };

      _this._handleKeyDown = function (event) {
        var keyCodes = {
          37: _this.constructor.NAVIGATE.BACKWARD,
          // left arrow
          39: _this.constructor.NAVIGATE.FORWARD // right arrow

        };
        var keyCodeMatches = keyCodes[event.which];

        if (keyCodeMatches) {
          _this.navigate(keyCodeMatches);
        }
      };

      _this.manage(on(_this.element, 'keydown', _this._handleKeyDown));

      return _this;
    }
    /**
     * The map associating DOM element and Header instance.
     * @member HeaderNav.components
     * @type {WeakMap}
     */


    _createClass$z(HeaderNav, null, [{
      key: "options",

      /**
       * The component options.
       * If `options` is specified in the constructor,
       * {@linkcode HeaderNav.create .create()}, or
       * {@linkcode HeaderNav.init .init()},
       * properties in this object are overriden for the instance being create and
       * how {@linkcode HeaderNav.init .init()} works.
       * @member HeaderNav.options
       * @type {object}
       * @property {string} selectorInit The data attribute to find side navs.
       */
      get: function get() {
        var prefix = settings_1.prefix;
        return {
          selectorInit: '[data-header-nav]',
          selectorNavKind: '[data-header-nav-kind]',
          selectorSubmenu: ".".concat(prefix, "--header__submenu"),
          selectorSubmenuLink: ".".concat(prefix, "--header__menu-title"),
          selectorSubmenuItem: ".".concat(prefix, "--header__menu-title > .").concat(prefix, "--header__menu-item")
        };
      }
      /**
       * Enum for navigating backward/forward.
       * @readonly
       * @member Header.NAVIGATE
       * @type {Object}
       * @property {number} BACKWARD Navigating backward.
       * @property {number} FORWARD Navigating forward.
       */

    }]);

    HeaderNav.components = new WeakMap();
    HeaderNav.NAVIGATE = {
      BACKWARD: -1,
      FORWARD: 1
    };
    return HeaderNav;
  }(mixin(createComponent, initComponentBySearch, handles));

  function _typeof$B(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof$B = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof$B = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof$B(obj);
  }

  function _classCallCheck$C(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$A(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$A(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$A(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$A(Constructor, staticProps);
    return Constructor;
  }

  function _possibleConstructorReturn$B(self, call) {
    if (call && (_typeof$B(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized$B(self);
  }

  function _assertThisInitialized$B(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _getPrototypeOf$B(o) {
    _getPrototypeOf$B = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf$B(o);
  }

  function _inherits$B(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf$B(subClass, superClass);
  }

  function _setPrototypeOf$B(o, p) {
    _setPrototypeOf$B = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf$B(o, p);
  }

  var NavigationMenuPanel =
  /*#__PURE__*/
  function (_mixin) {
    _inherits$B(NavigationMenuPanel, _mixin);

    function NavigationMenuPanel() {
      var _getPrototypeOf2;

      var _this;

      _classCallCheck$C(this, NavigationMenuPanel);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = _possibleConstructorReturn$B(this, (_getPrototypeOf2 = _getPrototypeOf$B(NavigationMenuPanel)).call.apply(_getPrototypeOf2, [this].concat(args)));

      _this.createdByLauncher = function (event) {
        var isExpanded = !_this.element.hasAttribute('hidden');
        var newState = isExpanded ? 'collapsed' : 'expanded';
        _this.triggerButton = event.delegateTarget;

        _this.changeState(newState);
      };

      _this.shouldStateBeChanged = function (state) {
        return state === 'expanded' === _this.element.hasAttribute('hidden');
      };

      _this._changeState = function (state, callback) {
        toggleAttribute(_this.element, 'hidden', state !== 'expanded');

        if (_this.triggerButton) {
          if (state === 'expanded') {
            var focusableMenuItems = _this.element.querySelector(_this.options.selectorFocusableMenuItem);

            if (focusableMenuItems) {
              focusableMenuItems.focus();
            }
          }

          var label = state === 'expanded' ? _this.triggerButton.getAttribute(_this.options.attribLabelCollapse) : _this.triggerButton.getAttribute(_this.options.attribLabelExpand);

          _this.triggerButton.classList.toggle(_this.options.classNavigationMenuPanelHeaderActionActive, state === 'expanded');

          _this.triggerButton.setAttribute('aria-label', label);

          _this.triggerButton.setAttribute('title', label);
        }

        callback();
      };

      return _this;
    }

    _createClass$A(NavigationMenuPanel, null, [{
      key: "options",

      /**
       * The component options.
       * If `options` is specified in the constructor,
       * {@linkcode NavigationMenuPanel.create .create()}, or
       * {@linkcode NavigationMenuPanel.init .init()},
       * properties in this object are overriden for the instance being create and
       * how {@linkcode NavigationMenuPanel.init .init()} works.
       * @member NavigationMenuPanel.options
       * @type {object}
       * @property {string} selectorInit The CSS class to find popup navs.
       * @property {string} attribInitTarget The attribute name in the launcher buttons to find target popup nav.
       * @property {string[]} initEventNames The events that the component will handles
       */
      get: function get() {
        var prefix = settings_1.prefix;
        return {
          initEventNames: ['click'],
          eventBeforeExpanded: 'navigation-menu-being-expanded',
          eventAfterExpanded: 'navigation-menu-expanded',
          eventBeforeCollapsed: 'navigation-menu-being-collapsed',
          eventAfterCollapsed: 'navigation-menu-collapsed',
          selectorFocusableMenuItem: ".".concat(prefix, "--navigation__category-toggle, .").concat(prefix, "--navigation-link"),
          classNavigationMenuPanelHeaderActionActive: "".concat(prefix, "--header__action--active"),
          attribLabelExpand: 'data-navigation-menu-panel-label-expand',
          attribLabelCollapse: 'data-navigation-menu-panel-label-collapse'
        };
      }
    }]);

    NavigationMenuPanel.components = new WeakMap();
    return NavigationMenuPanel;
  }(mixin(createComponent, initComponentByLauncher, exports$1, handles, eventedState));

  function _typeof$C(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof$C = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof$C = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof$C(obj);
  }

  function _classCallCheck$D(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties$B(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass$B(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties$B(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties$B(Constructor, staticProps);
    return Constructor;
  }

  function _possibleConstructorReturn$C(self, call) {
    if (call && (_typeof$C(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized$C(self);
  }

  function _assertThisInitialized$C(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _getPrototypeOf$C(o) {
    _getPrototypeOf$C = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf$C(o);
  }

  function _inherits$C(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf$C(subClass, superClass);
  }

  function _setPrototypeOf$C(o, p) {
    _setPrototypeOf$C = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf$C(o, p);
  }

  var PaginationNav =
  /*#__PURE__*/
  function (_mixin) {
    _inherits$C(PaginationNav, _mixin);
    /**
     * Pagination Nav component
     * @extends CreateComponent
     * @extends InitComponentBySearch
     * @extends Handles
     * @param {HTMLElement} element The element working as a pagination nav.
     */


    function PaginationNav(element, options) {
      var _this;

      _classCallCheck$D(this, PaginationNav);

      _this = _possibleConstructorReturn$C(this, _getPrototypeOf$C(PaginationNav).call(this, element, options));

      _this.getActivePageNumber = function () {
        var pageNum;

        var activePageElement = _this.element.querySelector(_this.options.selectorPageActive);

        if (activePageElement) {
          pageNum = Number(activePageElement.getAttribute(_this.options.attribPage));
        }

        return pageNum;
      };

      _this.clearActivePage = function (evt) {
        var pageButtonNodeList = _this.element.querySelectorAll(_this.options.selectorPageButton);

        var pageSelectElement = _this.element.querySelector(_this.options.selectorPageSelect);

        Array.prototype.forEach.call(pageButtonNodeList, function (el) {
          el.classList.remove(_this.options.classActive, _this.options.classDisabled);
          el.removeAttribute(_this.options.attribActive);
          el.removeAttribute('aria-disabled');
          el.removeAttribute('aria-current');
        });

        if (pageSelectElement) {
          pageSelectElement.removeAttribute('aria-current');
          var pageSelectElementOptions = pageSelectElement.options;
          Array.prototype.forEach.call(pageSelectElementOptions, function (el) {
            el.removeAttribute(_this.options.attribActive);
          });

          if (!evt.target.matches(_this.options.selectorPageSelect)) {
            pageSelectElement.classList.remove(_this.options.classActive);
            pageSelectElement.value = '';
          }
        }
      };

      _this.handleClick = function (evt) {
        if (!evt.target.getAttribute('aria-disabled') === true) {
          var nextActivePageNumber = _this.getActivePageNumber();

          var pageElementNodeList = _this.element.querySelectorAll(_this.options.selectorPageElement);

          var pageSelectElement = _this.element.querySelector(_this.options.selectorPageSelect);

          _this.clearActivePage(evt);

          if (evt.target.matches(_this.options.selectorPageButton)) {
            nextActivePageNumber = Number(evt.target.getAttribute(_this.options.attribPage));
          }

          if (evt.target.matches(_this.options.selectorPagePrevious)) {
            nextActivePageNumber -= 1;
          }

          if (evt.target.matches(_this.options.selectorPageNext)) {
            nextActivePageNumber += 1;
          }

          var pageTargetElement = pageElementNodeList[nextActivePageNumber - 1];
          pageTargetElement.setAttribute(_this.options.attribActive, true);

          if (pageTargetElement.tagName === 'OPTION') {
            pageSelectElement.value = _this.getActivePageNumber();
            pageSelectElement.classList.add(_this.options.classActive);
            pageSelectElement.setAttribute('aria-current', 'page');
          } else {
            pageTargetElement.classList.add(_this.options.classActive, _this.options.classDisabled);
            pageTargetElement.setAttribute('aria-disabled', true);
            pageTargetElement.setAttribute('aria-current', 'page');
          }

          _this.setPrevNextStates();
        }
      };

      _this.handleSelectChange = function (evt) {
        _this.clearActivePage(evt);

        var pageSelectElement = _this.element.querySelector(_this.options.selectorPageSelect);

        var pageSelectElementOptions = pageSelectElement.options;
        pageSelectElementOptions[pageSelectElementOptions.selectedIndex].setAttribute(_this.options.attribActive, true);
        evt.target.setAttribute('aria-current', 'page');
        evt.target.classList.add(_this.options.classActive);

        _this.setPrevNextStates();
      };

      _this.setPrevNextStates = function () {
        var pageElementNodeList = _this.element.querySelectorAll(_this.options.selectorPageElement);

        var totalPages = pageElementNodeList.length;

        var pageDirectionElementPrevious = _this.element.querySelector(_this.options.selectorPagePrevious);

        var pageDirectionElementNext = _this.element.querySelector(_this.options.selectorPageNext);

        if (pageDirectionElementPrevious) {
          if (_this.getActivePageNumber() <= 1) {
            pageDirectionElementPrevious.setAttribute('aria-disabled', true);
            pageDirectionElementPrevious.classList.add(_this.options.classDisabled);
          } else {
            pageDirectionElementPrevious.removeAttribute('aria-disabled');
            pageDirectionElementPrevious.classList.remove(_this.options.classDisabled);
          }
        }

        if (pageDirectionElementNext) {
          if (_this.getActivePageNumber() >= totalPages) {
            pageDirectionElementNext.setAttribute('aria-disabled', true);
            pageDirectionElementNext.classList.add(_this.options.classDisabled);
          } else {
            pageDirectionElementNext.removeAttribute('aria-disabled');
            pageDirectionElementNext.classList.remove(_this.options.classDisabled);
          }
        }
      };

      _this.manage(on(_this.element, 'click', function (evt) {
        return _this.handleClick(evt);
      }));

      _this.manage(on(_this.element, 'change', function (evt) {
        if (evt.target.matches(_this.options.selectorPageSelect)) {
          _this.handleSelectChange(evt);
        }
      }));

      return _this;
    }
    /**
     * Get active page number
     */


    _createClass$B(PaginationNav, null, [{
      key: "options",

      /**
       * The component options.
       * If `options` is specified in the constructor, {@linkcode PaginationNav.create .create()},
       * or {@linkcode PaginationNav.init .init()},
       * properties in this object are overriden for the instance being create and how {@linkcode PaginationNav.init .init()} works.
       * @member PaginationNav.options
       * @type {object}
       * @property {string} selectorInit The data attribute to find pagination nav.
       * @property {string} selectorPageElement The data attribute to find page element.
       * @property {string} selectorPageButton The data attribute to find page interactive element.
       * @property {string} selectorPageDirection The data attribute to find page change element.
       * @property {string} selectorPageSelect The data attribute to find page select element.
       * @property {string} selectorPageActive The data attribute to find active page element.
       * @property {string} [classActive] The CSS class for page's selected state.
       * @property {string} [classDisabled] The CSS class for page's disabled state.
       */
      get: function get() {
        var prefix = settings_1.prefix;
        return {
          selectorInit: '[data-pagination-nav]',
          selectorPageElement: '[data-page]',
          selectorPageButton: '[data-page-button]',
          selectorPagePrevious: '[data-page-previous]',
          selectorPageNext: '[data-page-next]',
          selectorPageSelect: '[data-page-select]',
          selectorPageActive: '[data-page-active="true"]',
          attribPage: 'data-page',
          attribActive: 'data-page-active',
          classActive: "".concat(prefix, "--pagination-nav__page--active"),
          classDisabled: "".concat(prefix, "--pagination-nav__page--disabled")
        };
      }
    }]);

    PaginationNav.components = new WeakMap();
    return PaginationNav;
  }(mixin(createComponent, initComponentBySearch, handles));

  var prefix$1 = settings_1.prefix;

  function Accordion$1(_ref) {
    var children = _ref.children,
        customClassName = _ref.className,
        rest = _objectWithoutProperties(_ref, ["children", "className"]);

    var className = classNames("".concat(prefix$1, "--accordion"), customClassName);
    return React__default.createElement("ul", _extends({
      className: className
    }, rest), children);
  }

  Accordion$1.propTypes = {
    /**
     * Pass in the children that will be rendered within the Accordion
     */
    children: PropTypes__default.node,

    /**
     * Specify an optional className to be applied to the container node
     */
    className: PropTypes__default.string
  };

  function _defineProperty$5(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  function ownKeys$2(object, enumerableOnly) {
    var keys = Object.keys(object);

    if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);
      if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });
      keys.push.apply(keys, symbols);
    }

    return keys;
  }

  function _objectSpread2$1(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};

      if (i % 2) {
        ownKeys$2(source, true).forEach(function (key) {
          _defineProperty$5(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys$2(source).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }

    return target;
  }

  function _objectWithoutPropertiesLoose$1(source, excluded) {
    if (source == null) return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i;

    for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      target[key] = source[key];
    }

    return target;
  }

  function _objectWithoutProperties$1(source, excluded) {
    if (source == null) return {};

    var target = _objectWithoutPropertiesLoose$1(source, excluded);

    var key, i;

    if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

      for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];
        if (excluded.indexOf(key) >= 0) continue;
        if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
        target[key] = source[key];
      }
    }

    return target;
  }
  /**
   * Copyright IBM Corp. 2018, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */


  var defaultAttributes = {
    // Reference:
    // https://github.com/IBM/carbon-components-react/issues/1392
    // https://github.com/PolymerElements/iron-iconset-svg/pull/47
    // `focusable` is a string attribute which is why we do not use a boolean here
    focusable: 'false',
    preserveAspectRatio: 'xMidYMid meet',
    // Reference:
    // https://github.com/ckeditor/ckeditor5/issues/668#issuecomment-344844027
    style: 'will-change: transform;'
  };
  /**
   * Get supplementary HTML attributes for a given <svg> element based on existing
   * attributes.
   */

  function getAttributes() {
    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        width = _ref.width,
        height = _ref.height,
        _ref$viewBox = _ref.viewBox,
        viewBox = _ref$viewBox === void 0 ? "0 0 ".concat(width, " ").concat(height) : _ref$viewBox,
        attributes = _objectWithoutProperties$1(_ref, ["width", "height", "viewBox"]);

    var tabindex = attributes.tabindex,
        rest = _objectWithoutProperties$1(attributes, ["tabindex"]);

    var iconAttributes = _objectSpread2$1({}, defaultAttributes, {}, rest, {
      width: width,
      height: height,
      viewBox: viewBox
    }); // TODO: attributes.title assumes that the consumer will implement <title> and
    // correctly set `aria-labelledby`.


    if (iconAttributes['aria-label'] || iconAttributes['aria-labelledby'] || iconAttributes.title) {
      iconAttributes.role = 'img'; // Reference:
      // https://allyjs.io/tutorials/focusing-in-svg.html

      if (tabindex !== undefined && tabindex !== null) {
        iconAttributes.focusable = 'true';
        iconAttributes.tabindex = tabindex;
      }
    } else {
      iconAttributes['aria-hidden'] = true;
    }

    return iconAttributes;
  }

  function _defineProperty$6(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true});}else{obj[key]=value;}return obj;}function _extends$1(){_extends$1=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key];}}}return target;};return _extends$1.apply(this,arguments);}function ownKeys$3(object,enumerableOnly){var keys=Object.keys(object);if(Object.getOwnPropertySymbols){var symbols=Object.getOwnPropertySymbols(object);if(enumerableOnly)symbols=symbols.filter(function(sym){return Object.getOwnPropertyDescriptor(object,sym).enumerable;});keys.push.apply(keys,symbols);}return keys;}function _objectSpread2$2(target){for(var i=1;i<arguments.length;i++){var source=arguments[i]!=null?arguments[i]:{};if(i%2){ownKeys$3(source,true).forEach(function(key){_defineProperty$6(target,key,source[key]);});}else if(Object.getOwnPropertyDescriptors){Object.defineProperties(target,Object.getOwnPropertyDescriptors(source));}else{ownKeys$3(source).forEach(function(key){Object.defineProperty(target,key,Object.getOwnPropertyDescriptor(source,key));});}}return target;}function _objectWithoutPropertiesLoose$2(source,excluded){if(source==null)return {};var target={};var sourceKeys=Object.keys(source);var key,i;for(i=0;i<sourceKeys.length;i++){key=sourceKeys[i];if(excluded.indexOf(key)>=0)continue;target[key]=source[key];}return target;}function _objectWithoutProperties$2(source,excluded){if(source==null)return {};var target=_objectWithoutPropertiesLoose$2(source,excluded);var key,i;if(Object.getOwnPropertySymbols){var sourceSymbolKeys=Object.getOwnPropertySymbols(source);for(i=0;i<sourceSymbolKeys.length;i++){key=sourceSymbolKeys[i];if(excluded.indexOf(key)>=0)continue;if(!Object.prototype.propertyIsEnumerable.call(source,key))continue;target[key]=source[key];}}return target;}var defaultStyle={willChange:'transform'};var Icon=React__default.forwardRef(function Icon(_ref,ref){var className=_ref.className,children=_ref.children,_ref$style=_ref.style,style=_ref$style===void 0?{}:_ref$style,tabIndex=_ref.tabIndex,rest=_objectWithoutProperties$2(_ref,["className","children","style","tabIndex"]);var _getAttributes=getAttributes(_objectSpread2$2({},rest,{tabindex:tabIndex})),tabindex=_getAttributes.tabindex,props=_objectWithoutProperties$2(_getAttributes,["tabindex"]);if(className){props.className=className;}if(tabindex!==undefined&&tabindex!==null){props.tabIndex=tabindex;}if(ref){props.ref=ref;}props.style=_objectSpread2$2({},defaultStyle,{},style);return React__default.createElement('svg',props,children);});Icon.displayName='Icon';Icon.propTypes={'aria-hidden':PropTypes__default.string,'aria-label':PropTypes__default.string,'aria-labelledby':PropTypes__default.string,className:PropTypes__default.string,children:PropTypes__default.node,height:PropTypes__default.number,preserveAspectRatio:PropTypes__default.string,tabIndex:PropTypes__default.string,viewBox:PropTypes__default.string,width:PropTypes__default.number,xmlns:PropTypes__default.string};Icon.defaultProps={xmlns:'http://www.w3.org/2000/svg',preserveAspectRatio:'xMidYMid meet'};var AddFilled16=/*#__PURE__*/React__default.forwardRef(function AddFilled16(props,ref){return React__default.createElement(Icon,_extends$1({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React__default.createElement("path",{d:"M8 1C4.2 1 1 4.2 1 8s3.2 7 7 7 7-3.2 7-7-3.2-7-7-7zm4 8H9v3H7V9H4V7h3V4h2v3h3v2z"}),props.children);});var Calendar16=/*#__PURE__*/React__default.forwardRef(function Calendar16(props,ref){return React__default.createElement(Icon,_extends$1({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React__default.createElement("path",{d:"M13 2h-2V1h-1v1H6V1H5v1H3c-.6 0-1 .4-1 1v10c0 .6.4 1 1 1h10c.6 0 1-.4 1-1V3c0-.6-.4-1-1-1zm0 11H3V6h10v7zm0-8H3V3h2v1h1V3h4v1h1V3h2v2z"}),props.children);});var CheckmarkFilled16=/*#__PURE__*/React__default.forwardRef(function CheckmarkFilled16(props,ref){return React__default.createElement(Icon,_extends$1({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React__default.createElement("path",{d:"M8 1C4.1 1 1 4.1 1 8s3.1 7 7 7 7-3.1 7-7-3.1-7-7-7zM7 11L4.3 8.3l.9-.8L7 9.3l4-3.9.9.8L7 11z"}),React__default.createElement("path",{d:"M7 11L4.3 8.3l.9-.8L7 9.3l4-3.9.9.8L7 11z","data-icon-path":"inner-path",opacity:"0"}),props.children);});var CheckmarkOutline16=/*#__PURE__*/React__default.forwardRef(function CheckmarkOutline16(props,ref){return React__default.createElement(Icon,_extends$1({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React__default.createElement("path",{d:"M8 1C4.1 1 1 4.1 1 8s3.1 7 7 7 7-3.1 7-7-3.1-7-7-7zm0 13c-3.3 0-6-2.7-6-6s2.7-6 6-6 6 2.7 6 6-2.7 6-6 6z"}),React__default.createElement("path",{d:"M7 10.8L4.5 8.3l.8-.8L7 9.2l3.7-3.7.8.8z"}),props.children);});var ChevronDown16=/*#__PURE__*/React__default.forwardRef(function ChevronDown16(props,ref){return React__default.createElement(Icon,_extends$1({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React__default.createElement("path",{d:"M8 11L3 6l.7-.7L8 9.6l4.3-4.3.7.7z"}),props.children);});var ChevronRight16=/*#__PURE__*/React__default.forwardRef(function ChevronRight16(props,ref){return React__default.createElement(Icon,_extends$1({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React__default.createElement("path",{d:"M11 8l-5 5-.7-.7L9.6 8 5.3 3.7 6 3z"}),props.children);});var CloseFilled16=/*#__PURE__*/React__default.forwardRef(function CloseFilled16(props,ref){return React__default.createElement(Icon,_extends$1({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React__default.createElement("path",{d:"M8 1C4.1 1 1 4.1 1 8s3.1 7 7 7 7-3.1 7-7-3.1-7-7-7zm2.7 10.5L8 8.8l-2.7 2.7-.8-.8L7.2 8 4.5 5.3l.8-.8L8 7.2l2.7-2.7.8.8L8.8 8l2.7 2.7-.8.8z"}),props.children);});var Close16=/*#__PURE__*/React__default.forwardRef(function Close16(props,ref){return React__default.createElement(Icon,_extends$1({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React__default.createElement("path",{d:"M12 4.7l-.7-.7L8 7.3 4.7 4l-.7.7L7.3 8 4 11.3l.7.7L8 8.7l3.3 3.3.7-.7L8.7 8z"}),props.children);});var Copy16=/*#__PURE__*/React__default.forwardRef(function Copy16(props,ref){return React__default.createElement(Icon,_extends$1({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React__default.createElement("path",{d:"M14 5v9H5V5h9m0-1H5a1 1 0 0 0-1 1v9a1 1 0 0 0 1 1h9a1 1 0 0 0 1-1V5a1 1 0 0 0-1-1z"}),React__default.createElement("path",{d:"M2 9H1V2a1 1 0 0 1 1-1h7v1H2z"}),props.children);});var Filter16=/*#__PURE__*/React__default.forwardRef(function Filter16(props,ref){return React__default.createElement(Icon,_extends$1({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React__default.createElement("path",{d:"M15 4h-2.1c-.2-1.1-1.2-2-2.4-2s-2.2.9-2.4 2H1v1h7.1c.2 1.1 1.2 2 2.4 2s2.2-.9 2.4-2H15V4zm-4.5 2C9.7 6 9 5.3 9 4.5S9.7 3 10.5 3s1.5.7 1.5 1.5S11.3 6 10.5 6zM1 12h2.1c.2 1.1 1.2 2 2.4 2s2.2-.9 2.4-2H15v-1H7.9c-.2-1.1-1.2-2-2.4-2s-2.2.9-2.4 2H1v1zm4.5-2c.8 0 1.5.7 1.5 1.5S6.3 13 5.5 13 4 12.3 4 11.5 4.7 10 5.5 10z"}),props.children);});var Grid16=/*#__PURE__*/React__default.forwardRef(function Grid16(props,ref){return React__default.createElement(Icon,_extends$1({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React__default.createElement("path",{d:"M6 2H3c-.6 0-1 .4-1 1v3c0 .6.4 1 1 1h3c.6 0 1-.4 1-1V3c0-.6-.4-1-1-1zm0 4H3V3h3v3zm7-4h-3c-.6 0-1 .4-1 1v3c0 .6.4 1 1 1h3c.6 0 1-.4 1-1V3c0-.6-.4-1-1-1zm0 4h-3V3h3v3zM6 9H3c-.6 0-1 .4-1 1v3c0 .6.4 1 1 1h3c.6 0 1-.4 1-1v-3c0-.6-.4-1-1-1zm0 4H3v-3h3v3zm7-4h-3c-.6 0-1 .4-1 1v3c0 .6.4 1 1 1h3c.6 0 1-.4 1-1v-3c0-.6-.4-1-1-1zm0 4h-3v-3h3v3z"}),props.children);});var Information16=/*#__PURE__*/React__default.forwardRef(function Information16(props,ref){return React__default.createElement(Icon,_extends$1({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React__default.createElement("path",{d:"M8.5 11V6.5h-2v1h1V11H6v1h4v-1zM8 3.5c-.4 0-.8.3-.8.8s.4.7.8.7.8-.3.8-.8-.4-.7-.8-.7z"}),React__default.createElement("path",{d:"M8 15c-3.9 0-7-3.1-7-7s3.1-7 7-7 7 3.1 7 7-3.1 7-7 7zM8 2C4.7 2 2 4.7 2 8s2.7 6 6 6 6-2.7 6-6-2.7-6-6-6z"}),props.children);});var ListBulleted16=/*#__PURE__*/React__default.forwardRef(function ListBulleted16(props,ref){return React__default.createElement(Icon,_extends$1({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React__default.createElement("circle",{cx:"3.5",cy:"4.5",r:"1.5"}),React__default.createElement("circle",{cx:"3.5",cy:"11.5",r:"1.5"}),React__default.createElement("path",{d:"M8 11h7v1H8zm0-7h7v1H8z"}),props.children);});var OverflowMenuVertical16=/*#__PURE__*/React__default.forwardRef(function OverflowMenuVertical16(props,ref){return React__default.createElement(Icon,_extends$1({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React__default.createElement("circle",{cx:"8",cy:"3",r:"1"}),React__default.createElement("circle",{cx:"8",cy:"8",r:"1"}),React__default.createElement("circle",{cx:"8",cy:"13",r:"1"}),props.children);});var Search16=/*#__PURE__*/React__default.forwardRef(function Search16(props,ref){return React__default.createElement(Icon,_extends$1({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React__default.createElement("path",{d:"M15 14.3L10.7 10c1.9-2.3 1.6-5.8-.7-7.7S4.2.7 2.3 3 .7 8.8 3 10.7c2 1.7 5 1.7 7 0l4.3 4.3.7-.7zM2 6.5C2 4 4 2 6.5 2S11 4 11 6.5 9 11 6.5 11 2 9 2 6.5z"}),props.children);});var Settings16=/*#__PURE__*/React__default.forwardRef(function Settings16(props,ref){return React__default.createElement(Icon,_extends$1({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React__default.createElement("path",{d:"M13.5 8.4v-.8l1-.8c.4-.3.4-.9.2-1.3l-1.2-2c-.2-.3-.5-.5-.9-.5-.1 0-.2 0-.3.1l-1.2.4c-.2-.1-.4-.3-.7-.4l-.3-1.3c0-.5-.4-.8-.9-.8H6.8c-.5 0-.9.3-1 .8l-.2 1.3c-.3.1-.5.2-.7.3L3.7 3h-.3c-.4 0-.7.2-.9.5l-1.2 2c-.2.4-.1.9.3 1.3l.9.9v.8l-.9.7c-.4.3-.5.9-.2 1.3l1.2 2c.1.3.4.5.8.5.1 0 .2 0 .3-.1l1.2-.4c.2.1.4.3.7.4l.3 1.3c.1.5.5.8 1 .8h2.4c.5 0 .9-.3 1-.8l.3-1.3c.2-.1.4-.2.7-.4l1.2.4c.1 0 .2.1.3.1.4 0 .7-.2.9-.5l1.1-2c.2-.4.2-.9-.2-1.3l-1.1-.8zm-.9 3.6l-1.7-.6c-.4.3-.9.6-1.4.8L9.2 14H6.8l-.4-1.8c-.5-.2-.9-.5-1.4-.8l-1.6.6-1.2-2 1.4-1.2c-.1-.5-.1-1.1 0-1.6L2.2 6l1.2-2 1.7.6c.4-.4.9-.6 1.4-.8L6.8 2h2.4l.4 1.8c.5.2.9.5 1.4.8l1.6-.6 1.2 2-1.4 1.2c.1.5.1 1.1 0 1.6l1.4 1.2-1.2 2z"}),React__default.createElement("path",{d:"M8 11c-1.7 0-3-1.3-3-3s1.3-3 3-3 3 1.3 3 3c0 1.6-1.3 3-3 3zm0-5c-1.1 0-2 .8-2 1.9V8c0 1.1.8 2 1.9 2H8c1.1 0 2-.8 2-1.9V8c0-1.1-.8-2-2-2 .1 0 0 0 0 0z"}),props.children);});var ViewOff16=/*#__PURE__*/React__default.forwardRef(function ViewOff16(props,ref){return React__default.createElement(Icon,_extends$1({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React__default.createElement("path",{d:"M2.6 11.3l.7-.7C2.6 9.8 1.9 9 1.5 8c1-2.5 3.8-4.5 6.5-4.5.7 0 1.4.1 2 .4l.8-.8C9.9 2.7 9 2.5 8 2.5 4.7 2.6 1.7 4.7.5 7.8v.3c.5 1.2 1.2 2.3 2.1 3.2z"}),React__default.createElement("path",{d:"M6 7.9c.1-1 .9-1.8 1.8-1.8l.9-.9c-1.5-.5-3.2.4-3.6 2-.1.5-.1 1.1 0 1.6l.9-.9zm9.5-.1c-.6-1.5-1.6-2.8-2.9-3.7L15 1.7l-.7-.7L1 14.3l.7.7 2.6-2.6c1.1.7 2.4 1 3.7 1.1 3.3-.1 6.3-2.2 7.5-5.3v-.4zM10 8c0 1.1-.9 2-2 2-.3 0-.7-.1-1-.3L9.7 7c.2.3.3.6.3 1zm-2 4.5c-1 0-2.1-.3-3-.8l1.3-1.3c1.4.9 3.2.6 4.2-.8.7-1 .7-2.4 0-3.4l1.4-1.4c1.1.8 2 1.9 2.6 3.2-1.1 2.5-3.9 4.5-6.5 4.5z"}),props.children);});var View16=/*#__PURE__*/React__default.forwardRef(function View16(props,ref){return React__default.createElement(Icon,_extends$1({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React__default.createElement("path",{d:"M15.5 7.8C14.3 4.7 11.3 2.6 8 2.5 4.7 2.6 1.7 4.7.5 7.8v.3c1.2 3.1 4.1 5.2 7.5 5.3 3.3-.1 6.3-2.2 7.5-5.3v-.3zM8 12.5c-2.7 0-5.4-2-6.5-4.5 1-2.5 3.8-4.5 6.5-4.5s5.4 2 6.5 4.5c-1.1 2.5-3.9 4.5-6.5 4.5z"}),React__default.createElement("path",{d:"M8 5C6.3 5 5 6.3 5 8s1.3 3 3 3 3-1.3 3-3-1.3-3-3-3zm0 5c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2z"}),props.children);});var WarningFilled16=/*#__PURE__*/React__default.forwardRef(function WarningFilled16(props,ref){return React__default.createElement(Icon,_extends$1({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React__default.createElement("path",{d:"M8 1C4.2 1 1 4.2 1 8s3.2 7 7 7 7-3.1 7-7-3.1-7-7-7zm-.5 3h1v5h-1V4zm.5 8.2c-.4 0-.8-.4-.8-.8s.3-.8.8-.8c.4 0 .8.4.8.8s-.4.8-.8.8z"}),React__default.createElement("path",{d:"M7.5 4h1v5h-1V4zm.5 8.2c-.4 0-.8-.4-.8-.8s.3-.8.8-.8c.4 0 .8.4.8.8s-.4.8-.8.8z","data-icon-path":"inner-path",opacity:"0"}),props.children);});var Warning16=/*#__PURE__*/React__default.forwardRef(function Warning16(props,ref){return React__default.createElement(Icon,_extends$1({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React__default.createElement("path",{d:"M8 1C4.1 1 1 4.1 1 8s3.1 7 7 7 7-3.1 7-7-3.1-7-7-7zm0 13c-3.3 0-6-2.7-6-6s2.7-6 6-6 6 2.7 6 6-2.7 6-6 6z"}),React__default.createElement("path",{d:"M7.5 4h1v5h-1zm.5 6.2c-.4 0-.8.3-.8.8s.3.8.8.8c.4 0 .8-.3.8-.8s-.4-.8-.8-.8z"}),props.children);});var CheckmarkFilled20=/*#__PURE__*/React__default.forwardRef(function CheckmarkFilled20(props,ref){return React__default.createElement(Icon,_extends$1({width:20,height:20,viewBox:"0 0 20 20",ref:ref},props),React__default.createElement("path",{d:"M10 1c-4.9 0-9 4.1-9 9s4.1 9 9 9 9-4 9-9-4-9-9-9zM8.7 13.5l-3.2-3.2 1-1 2.2 2.2 4.8-4.8 1 1-5.8 5.8z"}),React__default.createElement("path",{d:"M8.7 13.5l-3.2-3.2 1-1 2.2 2.2 4.8-4.8 1 1-5.8 5.8z","data-icon-path":"inner-path",opacity:"0"}),props.children);});var ErrorFilled20=/*#__PURE__*/React__default.forwardRef(function ErrorFilled20(props,ref){return React__default.createElement(Icon,_extends$1({width:20,height:20,viewBox:"0 0 20 20",ref:ref},props),React__default.createElement("path",{d:"M10 1c-5 0-9 4-9 9s4 9 9 9 9-4 9-9-4-9-9-9zm3.5 13.5l-8-8 1-1 8 8-1 1z"}),React__default.createElement("path",{d:"M13.5 14.5l-8-8 1-1 8 8-1 1z","data-icon-path":"inner-path",opacity:"0"}),props.children);});var Menu20=/*#__PURE__*/React__default.forwardRef(function Menu20(props,ref){return React__default.createElement(Icon,_extends$1({width:20,height:20,viewBox:"0 0 20 20",ref:ref},props),React__default.createElement("path",{d:"M2 14.8h16V16H2zm0-3.6h16v1.2H2zm0-3.6h16v1.2H2zM2 4h16v1.2H2z"}),props.children);});var WarningFilled20=/*#__PURE__*/React__default.forwardRef(function WarningFilled20(props,ref){return React__default.createElement(Icon,_extends$1({width:20,height:20,viewBox:"0 0 20 20",ref:ref},props),React__default.createElement("path",{d:"M10 1c-5 0-9 4-9 9s4 9 9 9 9-4 9-9-4-9-9-9zm-.8 4h1.5v7H9.2V5zm.8 11c-.6 0-1-.4-1-1s.4-1 1-1 1 .4 1 1-.4 1-1 1z"}),React__default.createElement("path",{d:"M9.2 5h1.5v7H9.2V5zm.8 11c-.6 0-1-.4-1-1s.4-1 1-1 1 .4 1 1-.4 1-1 1z","data-icon-path":"inner-path",opacity:"0"}),props.children);});var ArrowUp20=/*#__PURE__*/React__default.forwardRef(function ArrowUp20(props,ref){return React__default.createElement(Icon,_extends$1({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React__default.createElement("path",{d:"M16 4L6 14l1.41 1.41L15 7.83V30h2V7.83l7.59 7.58L26 14 16 4z"}),props.children);});var ArrowsVertical20=/*#__PURE__*/React__default.forwardRef(function ArrowsVertical20(props,ref){return React__default.createElement(Icon,_extends$1({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React__default.createElement("path",{d:"M26.59 20.59L23 24.17V4h-2v20.17l-3.59-3.58L16 22l6 6 6-6-1.41-1.41zM10 4l-6 6 1.41 1.41L9 7.83V28h2V7.83l3.59 3.58L16 10l-6-6z"}),props.children);});var CaretLeft24=/*#__PURE__*/React__default.forwardRef(function CaretLeft24(props,ref){return React__default.createElement(Icon,_extends$1({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React__default.createElement("path",{d:"M19 23l-8-7 8-7v14z"}),props.children);});var CaretRight24=/*#__PURE__*/React__default.forwardRef(function CaretRight24(props,ref){return React__default.createElement(Icon,_extends$1({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React__default.createElement("path",{d:"M13 9l8 7-8 7V9z"}),props.children);});var ChevronDown20=/*#__PURE__*/React__default.forwardRef(function ChevronDown20(props,ref){return React__default.createElement(Icon,_extends$1({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React__default.createElement("path",{d:"M16 22L6 12l1.4-1.4 8.6 8.6 8.6-8.6L26 12z"}),props.children);});var ChevronRight20=/*#__PURE__*/React__default.forwardRef(function ChevronRight20(props,ref){return React__default.createElement(Icon,_extends$1({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React__default.createElement("path",{d:"M22 16L12 26l-1.4-1.4 8.6-8.6-8.6-8.6L12 6z"}),props.children);});var Close20=/*#__PURE__*/React__default.forwardRef(function Close20(props,ref){return React__default.createElement(Icon,_extends$1({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React__default.createElement("path",{d:"M24 9.4L22.6 8 16 14.6 9.4 8 8 9.4l6.6 6.6L8 22.6 9.4 24l6.6-6.6 6.6 6.6 1.4-1.4-6.6-6.6L24 9.4z"}),props.children);});var CaretDownGlyph=/*#__PURE__*/React__default.forwardRef(function CaretDownGlyph(props,ref){return React__default.createElement(Icon,_extends$1({width:8,height:4,viewBox:"0 0 8 4",ref:ref},props),React__default.createElement("path",{d:"M8 0L4 4 0 0z"}),props.children);});var CaretUpGlyph=/*#__PURE__*/React__default.forwardRef(function CaretUpGlyph(props,ref){return React__default.createElement(Icon,_extends$1({width:8,height:4,viewBox:"0 0 8 4",ref:ref},props),React__default.createElement("path",{d:"M0 4l4-4 4 4z"}),props.children);});var ChevronDownGlyph=/*#__PURE__*/React__default.forwardRef(function ChevronDownGlyph(props,ref){return React__default.createElement(Icon,_extends$1({width:10,height:6,viewBox:"0 0 10 6",ref:ref},props),React__default.createElement("path",{d:"M5 6L0 1 .7.3 5 4.6 9.3.3l.7.7z"}),props.children);});

  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */
  var Enter = {
    key: 'Enter',
    which: 13,
    keyCode: 13
  };
  var Escape = {
    key: ['Escape', // IE11 Escape
    'Esc'],
    which: 27,
    keyCode: 27
  };
  var Space = {
    key: ' ',
    which: 32,
    keyCode: 32
  };
  var ArrowLeft = {
    key: 'ArrowLeft',
    which: 37,
    keyCode: 37
  };
  var ArrowUp = {
    key: 'ArrowUp',
    which: 38,
    keyCode: 38
  };
  var ArrowRight = {
    key: 'ArrowRight',
    which: 39,
    keyCode: 39
  };
  var ArrowDown = {
    key: 'ArrowDown',
    which: 40,
    keyCode: 40
  };

  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */

  /**
   * @typedef Key
   * @property key {Array<string>|string}
   * @property which {number}
   * @property keyCode {number}
   */

  /**
   * Check to see if at least one key code matches the key code of the
   * given event.
   *
   * @example
   * import * as keys from '../keys';
   * import { matches } from '../match';
   *
   * function handleOnKeyDown(event) {
   *   if (matches(event, [keys.Enter, keys.Space]) {
   *     // ...
   *   }
   * }
   *
   * @param {Event} event
   * @param {Array<Key>} keysToMatch
   * @returns {boolean}
   */
  function matches(event, keysToMatch) {
    for (var i = 0; i < keysToMatch.length; i++) {
      if (match(event, keysToMatch[i])) {
        return true;
      }
    }

    return false;
  }
  /**
   * Check to see if the given key matches the corresponding keyboard event. Also
   * supports passing in the value directly if you can't used the given event.
   *
   * @example
   * import * as keys from '../keys';
   * import { matches } from '../match';
   *
   * function handleOnKeyDown(event) {
   *   if (match(event, keys.Enter) {
   *     // ...
   *   }
   * }
   *
   * @param {Event|number|string} eventOrCode
   * @param {Key} key
   * @returns {boolean}
   */

  function match(eventOrCode) {
    var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
        key = _ref.key,
        which = _ref.which,
        keyCode = _ref.keyCode;

    if (typeof eventOrCode === 'string') {
      return eventOrCode === key;
    }

    if (typeof eventOrCode === 'number') {
      return eventOrCode === which || eventOrCode === keyCode;
    }

    if (eventOrCode.key && Array.isArray(key)) {
      return key.indexOf(eventOrCode.key) !== -1;
    }

    return eventOrCode.key === key || eventOrCode.which === which || eventOrCode.keyCode === keyCode;
  }

  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */
  /**
   * Various utilities to help with a11y work
   */

  /**
   * A "ring buffer" function that takes an array and depending on an ArrowRight
   * or ArrowLeft key input loops from last index to first or first index to last.
   *
   * @param {string} key - the left or right arrow keys
   * @param {number} index - the current index in a given array
   * @param {number} arrayLength - the total length of the array
   *
   * @example
   * 	getNextIndex(keyCodes.RIGHT, 0, 4)
   */

  var getNextIndex = function getNextIndex(key, index, arrayLength) {
    if (match(key, ArrowRight)) {
      return (index + 1) % arrayLength;
    }

    if (match(key, ArrowLeft)) {
      return (index + arrayLength - 1) % arrayLength;
    }
  };

  var prefix$2 = settings_1.prefix;

  var defaultRenderExpando = function defaultRenderExpando(props) {
    return React__default.createElement("button", props);
  };

  function AccordionItem(_ref) {
    var _cx;

    var children = _ref.children,
        customClassName = _ref.className,
        _ref$iconDescription = _ref.iconDescription,
        iconDescription = _ref$iconDescription === void 0 ? 'Expand/Collapse' : _ref$iconDescription,
        _ref$open = _ref.open,
        open = _ref$open === void 0 ? false : _ref$open,
        onHeadingClick = _ref.onHeadingClick,
        _ref$renderExpando = _ref.renderExpando,
        Expando = _ref$renderExpando === void 0 ? defaultRenderExpando : _ref$renderExpando,
        _ref$title = _ref.title,
        title = _ref$title === void 0 ? 'title' : _ref$title,
        rest = _objectWithoutProperties(_ref, ["children", "className", "iconDescription", "open", "onHeadingClick", "renderExpando", "title"]);

    var _useState = React.useState(open),
        _useState2 = _slicedToArray(_useState, 2),
        isOpen = _useState2[0],
        setIsOpen = _useState2[1];

    var _useState3 = React.useState(open),
        _useState4 = _slicedToArray(_useState3, 2),
        prevIsOpen = _useState4[0],
        setPrevIsOpen = _useState4[1];

    var className = classNames((_cx = {}, _defineProperty(_cx, "".concat(prefix$2, "--accordion__item"), true), _defineProperty(_cx, "".concat(prefix$2, "--accordion__item--active"), isOpen), _defineProperty(_cx, customClassName, !!customClassName), _cx));

    if (open !== prevIsOpen) {
      setIsOpen(open);
      setPrevIsOpen(open);
    } // When the AccordionItem heading is clicked, toggle the open state of the
    // panel


    function onClick(event) {
      var nextValue = !isOpen;
      setIsOpen(nextValue);

      if (onHeadingClick) {
        // TODO: normalize signature, potentially:
        // onHeadingClick :: (event: Event, state: { isOpen: Boolean }) => any
        onHeadingClick({
          isOpen: nextValue,
          event: event
        });
      }
    } // If the AccordionItem is open, and the user hits the ESC key, then close it


    function onKeyDown(event) {
      if (isOpen && match(event, Escape)) {
        setIsOpen(false);
      }
    }

    return React__default.createElement("li", _extends({
      className: className
    }, rest), React__default.createElement(Expando, {
      "aria-expanded": isOpen,
      className: "".concat(prefix$2, "--accordion__heading"),
      onClick: onClick,
      onKeyDown: onKeyDown,
      title: iconDescription,
      type: "button"
    }, React__default.createElement(ChevronRight16, {
      "aria-label": iconDescription,
      className: "".concat(prefix$2, "--accordion__arrow")
    }), React__default.createElement("div", {
      className: "".concat(prefix$2, "--accordion__title")
    }, title)), React__default.createElement("div", {
      className: "".concat(prefix$2, "--accordion__content")
    }, children));
  }

  AccordionItem.propTypes = {
    /**
     * Provide the contents of your AccordionItem
     */
    children: PropTypes__default.node,

    /**
     * Specify an optional className to be applied to the container node
     */
    className: PropTypes__default.string,

    /**
     * The accordion title.
     */
    title: PropTypes__default.node,

    /**
     * The callback function to render the expando button.
     * Can be a React component class.
     */
    renderExpando: PropTypes__default.func,

    /**
     * The description of the expando icon.
     */
    iconDescription: PropTypes__default.string,

    /**
     * `true` to open the expando.
     */
    open: PropTypes__default.bool,

    /**
     * The handler of the massaged `click` event.
     */
    onClick: PropTypes__default.func,

    /**
     * The handler of the massaged `click` event on the heading.
     */
    onHeadingClick: PropTypes__default.func
  };

  var prefix$3 = settings_1.prefix;
  var randoms = [0.973051493507435, 0.15334737213558558, 0.5671034553053769];

  function getRandomInt(min, max, n) {
    return Math.floor(randoms[n % 3] * (max - min + 1)) + min;
  }

  var SkeletonText = function SkeletonText(_ref) {
    var _classNames;

    var paragraph = _ref.paragraph,
        lineCount = _ref.lineCount,
        width = _ref.width,
        heading = _ref.heading,
        className = _ref.className,
        other = _objectWithoutProperties(_ref, ["paragraph", "lineCount", "width", "heading", "className"]);

    var skeletonTextClasses = classNames((_classNames = {}, _defineProperty(_classNames, "".concat(prefix$3, "--skeleton__text"), true), _defineProperty(_classNames, "".concat(prefix$3, "--skeleton__heading"), heading), _defineProperty(_classNames, className, className), _classNames));
    var widthNum = parseInt(width, 10);
    var widthPx = width.includes('px');
    var widthPercent = width.includes('%');

    if (widthPercent && paragraph) {
      var lines = [];

      for (var i = 0; i < lineCount; i++) {
        var randomWidth = getRandomInt(0, 75, i) + 'px';
        lines.push(React__default.createElement("p", _extends({
          className: skeletonTextClasses,
          style: {
            width: "calc(".concat(width, " - ").concat(randomWidth, ")")
          },
          key: i
        }, other)));
      }

      return React__default.createElement("div", null, lines);
    }

    if (widthPx && paragraph) {
      var _lines = [];

      for (var j = 0; j < lineCount; j++) {
        var _randomWidth = getRandomInt(widthNum - 75, widthNum, j) + 'px';

        _lines.push(React__default.createElement("p", _extends({
          className: skeletonTextClasses,
          style: {
            width: _randomWidth
          },
          key: j
        }, other)));
      }

      return React__default.createElement("div", null, _lines);
    }

    return React__default.createElement("p", _extends({
      className: skeletonTextClasses,
      style: {
        width: width
      }
    }, other));
  };

  SkeletonText.propTypes = {
    /**
     * will generate multiple lines of text
     */
    paragraph: PropTypes__default.bool,

    /**
     * the number of lines in a paragraph
     */
    lineCount: PropTypes__default.number,

    /**
     * width (in px or %) of single line of text or max-width of paragraph lines
     */
    width: PropTypes__default.string,

    /**
     * generates skeleton text at a larger size
     */
    heading: PropTypes__default.bool,

    /**
     * Specify an optional className to be applied to the container node
     */
    className: PropTypes__default.string
  };
  SkeletonText.defaultProps = {
    paragraph: false,
    width: '100%',
    heading: false,
    lineCount: 3
  };

  var didWarnAboutDeprecation = {};
  function deprecate(propType, message) {
    function checker(props, propName, componentName) {
      if (props[propName] === undefined) {
        return;
      }

      if (!didWarnAboutDeprecation[componentName] || !didWarnAboutDeprecation[componentName][propName]) {
        didWarnAboutDeprecation[componentName] = _objectSpread2({}, didWarnAboutDeprecation[componentName], _defineProperty({}, propName, true));
         warning_1(false, message || "The prop `".concat(propName, "` has been deprecated for the ") + "".concat(componentName, " component. It will be removed in the next major ") + "release") ;
      }

      for (var _len = arguments.length, rest = new Array(_len > 3 ? _len - 3 : 0), _key = 3; _key < _len; _key++) {
        rest[_key - 3] = arguments[_key];
      }

      return propType.apply(void 0, [props, propName, componentName].concat(rest));
    }

    return checker;
  }

  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */
  var prefix$4 = settings_1.prefix;

  function AccordionSkeleton(props) {
    var numSkeletonItems = props.open ? props.count - 1 : props.count;
    return React__default.createElement("ul", {
      className: "".concat(prefix$4, "--accordion ").concat(prefix$4, "--skeleton")
    }, props.open && React__default.createElement("li", {
      className: "".concat(prefix$4, "--accordion__item ").concat(prefix$4, "--accordion__item--active")
    }, React__default.createElement("button", {
      type: "button",
      className: "".concat(prefix$4, "--accordion__heading")
    }, React__default.createElement(ChevronRight16, {
      className: "".concat(prefix$4, "--accordion__arrow")
    }), React__default.createElement(SkeletonText, {
      className: "".concat(prefix$4, "--accordion__title")
    })), React__default.createElement("div", {
      className: "".concat(prefix$4, "--accordion__content")
    }, React__default.createElement(SkeletonText, {
      width: "90%"
    }), React__default.createElement(SkeletonText, {
      width: "80%"
    }), React__default.createElement(SkeletonText, {
      width: "95%"
    }))), Array.from({
      length: numSkeletonItems
    }).map(function (_, i) {
      return React__default.createElement(AccordionSkeletonItem, {
        key: i
      });
    }));
  }

  AccordionSkeleton.propTypes = {
    /**
     * `false` to not display the first item opened
     */
    open: PropTypes__default.bool,

    /**
     * Set number of items to render
     */
    count: PropTypes__default.number,

    /**
     * Set unique identifier to generate unique item keys
     */
    uid: deprecate(PropTypes__default.any)
  };
  AccordionSkeleton.defaultProps = {
    open: true,
    count: 4
  };

  function AccordionSkeletonItem() {
    return React__default.createElement("li", {
      className: "".concat(prefix$4, "--accordion__item")
    }, React__default.createElement("button", {
      type: "button",
      className: "".concat(prefix$4, "--accordion__heading")
    }, React__default.createElement(ChevronRight16, {
      className: "".concat(prefix$4, "--accordion__arrow")
    }), React__default.createElement(SkeletonText, {
      className: "".concat(prefix$4, "--accordion__title")
    })));
  }

  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */

  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */

  var prefix$5 = settings_1.prefix;

  var Breadcrumb = function Breadcrumb(_ref) {
    var _cx;

    var children = _ref.children,
        customClassName = _ref.className,
        noTrailingSlash = _ref.noTrailingSlash,
        rest = _objectWithoutProperties(_ref, ["children", "className", "noTrailingSlash"]);

    var className = classNames((_cx = {}, _defineProperty(_cx, "".concat(prefix$5, "--breadcrumb"), true), _defineProperty(_cx, "".concat(prefix$5, "--breadcrumb--no-trailing-slash"), noTrailingSlash), _defineProperty(_cx, customClassName, !!customClassName), _cx));
    return React__default.createElement("nav", _extends({
      className: className
    }, rest), children);
  };

  Breadcrumb.propTypes = {
    /**
     * Pass in the BreadcrumbItem's for your Breadcrumb
     */
    children: PropTypes__default.node,

    /**
     * Specify an optional className to be applied to the container node
     */
    className: PropTypes__default.string,

    /**
     * Optional prop to omit the trailing slash for the breadcrumbs
     */
    noTrailingSlash: PropTypes__default.bool
  };

  var prefix$6 = settings_1.prefix;

  var Link = function Link(_ref) {
    var children = _ref.children,
        className = _ref.className,
        href = _ref.href,
        other = _objectWithoutProperties(_ref, ["children", "className", "href"]);

    var classNames$1 = classNames("".concat(prefix$6, "--link"), className);
    return React__default.createElement("a", _extends({
      href: other.disabled ? null : href,
      className: classNames$1
    }, other), children);
  };

  Link.propTypes = {
    /**
     * Provide the content for the Link
     */
    children: PropTypes__default.node,

    /**
     * Provide a custom className to be applied to the containing <a> node
     */
    className: PropTypes__default.string,

    /**
     * Provide the `href` attribute for the <a> node
     */
    href: PropTypes__default.string
  };

  var prefix$7 = settings_1.prefix;

  var BreadcrumbItem = function BreadcrumbItem(_ref) {
    var _cx;

    var ariaCurrent = _ref['aria-current'],
        children = _ref.children,
        customClassName = _ref.className,
        href = _ref.href,
        isCurrentPage = _ref.isCurrentPage,
        rest = _objectWithoutProperties(_ref, ["aria-current", "children", "className", "href", "isCurrentPage"]);

    var className = classNames((_cx = {}, _defineProperty(_cx, "".concat(prefix$7, "--breadcrumb-item"), true), _defineProperty(_cx, "".concat(prefix$7, "--breadcrumb-item--current"), isCurrentPage && ariaCurrent !== 'page'), _defineProperty(_cx, customClassName, !!customClassName), _cx));

    if (typeof children === 'string' && href) {
      return React__default.createElement("div", _extends({
        className: className
      }, rest), React__default.createElement(Link, {
        href: href,
        "aria-current": ariaCurrent
      }, children));
    }

    return React__default.createElement("div", _extends({
      className: className
    }, rest), React__default.cloneElement(children, {
      'aria-current': ariaCurrent,
      className: "".concat(prefix$7, "--link")
    }));
  };

  BreadcrumbItem.propTypes = {
    /**
     * Pass in content that will be inside of the BreadcrumbItem
     */
    children: PropTypes__default.node,

    /**
     * Specify an optional className to be applied to the container node
     */
    className: PropTypes__default.string,

    /**
     * Optional string representing the link location for the BreadcrumbItem
     */
    href: PropTypes__default.string,

    /**
     * Provide if this breadcrumb item represents the current page
     */
    isCurrentPage: PropTypes__default.bool
  };

  var prefix$8 = settings_1.prefix;

  var BreadcrumbSkeleton =
  /*#__PURE__*/
  function (_React$Component) {
    _inherits(BreadcrumbSkeleton, _React$Component);

    function BreadcrumbSkeleton() {
      _classCallCheck(this, BreadcrumbSkeleton);

      return _possibleConstructorReturn(this, _getPrototypeOf(BreadcrumbSkeleton).apply(this, arguments));
    }

    _createClass(BreadcrumbSkeleton, [{
      key: "render",
      value: function render() {
        var item = React__default.createElement("div", {
          className: "".concat(prefix$8, "--breadcrumb-item")
        }, React__default.createElement("a", {
          href: "/#",
          className: "".concat(prefix$8, "--link")
        }, "\xA0"));
        return React__default.createElement("div", {
          className: "".concat(prefix$8, "--breadcrumb ").concat(prefix$8, "--skeleton")
        }, item, item, item);
      }
    }]);

    return BreadcrumbSkeleton;
  }(React__default.Component);

  var prefix$9 = settings_1.prefix;

  var ButtonSkeleton = function ButtonSkeleton(_ref) {
    var _classNames;

    var small = _ref.small,
        href = _ref.href;
    var buttonClasses = classNames((_classNames = {}, _defineProperty(_classNames, "".concat(prefix$9, "--skeleton"), true), _defineProperty(_classNames, "".concat(prefix$9, "--btn"), true), _defineProperty(_classNames, "".concat(prefix$9, "--btn--sm"), small), _classNames));
    var commonProps = {
      className: buttonClasses
    };
    var button = React__default.createElement("div", commonProps);
    var anchor = React__default.createElement("a", _extends({}, commonProps, {
      href: href,
      role: "button"
    })); // eslint-disable-line

    return href ? anchor : button;
  };

  ButtonSkeleton.propTypes = {
    /**
     * Specify whether the Button should be a small variant
     */
    small: PropTypes__default.bool,

    /**
     * Optionally specify an href for your Button to become an <a> element
     */
    href: PropTypes__default.string
  };
  ButtonSkeleton.defaultProps = {
    small: false
  };

  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */
  var ButtonTypes = {
    buttonKind: PropTypes.oneOf(['primary', 'secondary', 'danger', 'ghost', 'danger--primary', 'tertiary'])
  };

  var prefix$a = settings_1.prefix;
  var Button = React__default.forwardRef(function Button(_ref, ref) {
    var _classNames;

    var children = _ref.children,
        as = _ref.as,
        className = _ref.className,
        disabled = _ref.disabled,
        small = _ref.small,
        size = _ref.size,
        kind = _ref.kind,
        href = _ref.href,
        tabIndex = _ref.tabIndex,
        type = _ref.type,
        ButtonImageElement = _ref.renderIcon,
        iconDescription = _ref.iconDescription,
        hasIconOnly = _ref.hasIconOnly,
        tooltipPosition = _ref.tooltipPosition,
        tooltipAlignment = _ref.tooltipAlignment,
        other = _objectWithoutProperties(_ref, ["children", "as", "className", "disabled", "small", "size", "kind", "href", "tabIndex", "type", "renderIcon", "iconDescription", "hasIconOnly", "tooltipPosition", "tooltipAlignment"]);

    var buttonClasses = classNames(className, (_classNames = {}, _defineProperty(_classNames, "".concat(prefix$a, "--btn"), true), _defineProperty(_classNames, "".concat(prefix$a, "--btn--field"), size === 'field'), _defineProperty(_classNames, "".concat(prefix$a, "--btn--sm"), size === 'small' || small), _defineProperty(_classNames, "".concat(prefix$a, "--btn--primary"), kind === 'primary'), _defineProperty(_classNames, "".concat(prefix$a, "--btn--danger"), kind === 'danger'), _defineProperty(_classNames, "".concat(prefix$a, "--btn--secondary"), kind === 'secondary'), _defineProperty(_classNames, "".concat(prefix$a, "--btn--ghost"), kind === 'ghost'), _defineProperty(_classNames, "".concat(prefix$a, "--btn--danger--primary"), kind === 'danger--primary'), _defineProperty(_classNames, "".concat(prefix$a, "--btn--tertiary"), kind === 'tertiary'), _defineProperty(_classNames, "".concat(prefix$a, "--btn--disabled"), disabled), _defineProperty(_classNames, "".concat(prefix$a, "--btn--icon-only"), hasIconOnly), _defineProperty(_classNames, "".concat(prefix$a, "--tooltip__trigger"), hasIconOnly), _defineProperty(_classNames, "".concat(prefix$a, "--tooltip--a11y"), hasIconOnly), _defineProperty(_classNames, "".concat(prefix$a, "--tooltip--").concat(tooltipPosition), hasIconOnly && tooltipPosition), _defineProperty(_classNames, "".concat(prefix$a, "--tooltip--align-").concat(tooltipAlignment), hasIconOnly && tooltipAlignment), _classNames));
    var commonProps = {
      tabIndex: tabIndex,
      className: buttonClasses,
      ref: ref
    };
    var buttonImage = !ButtonImageElement ? null : React__default.createElement(ButtonImageElement, {
      "aria-label": iconDescription,
      className: "".concat(prefix$a, "--btn__icon"),
      "aria-hidden": "true"
    });
    var component = 'button';
    var otherProps = {
      disabled: disabled,
      type: type
    };
    var anchorProps = {
      role: 'button',
      href: href
    };
    var assistiveText = hasIconOnly ? React__default.createElement("span", {
      className: "".concat(prefix$a, "--assistive-text")
    }, iconDescription) : null;

    if (as) {
      component = as;
      otherProps = _objectSpread2({}, otherProps, {}, anchorProps);
    } else if (href) {
      component = 'a';
      otherProps = anchorProps;
    }

    return React__default.createElement(component, _objectSpread2({}, other, {}, commonProps, {}, otherProps), assistiveText, children, buttonImage);
  });
  Button.propTypes = {
    /**
     * Specify the content of your Button
     */
    children: PropTypes__default.node,

    /**
     * Specify how the button itself should be rendered.
     * Make sure to apply all props to the root node and render children appropriately
     */
    as: PropTypes__default.oneOfType([PropTypes__default.func, PropTypes__default.string]),

    /**
     * Specify an optional className to be added to your Button
     */
    className: PropTypes__default.string,

    /**
     * Specify whether the Button should be disabled, or not
     */
    disabled: PropTypes__default.bool,

    /**
     * Specify the size of the button, from a list of available sizes.
     * For `default` buttons, this prop can remain unspecified.
     */
    size: PropTypes__default.oneOf(['default', 'field', 'small']),

    /**
     * Deprecated in v10 in favor of `size`.
     * Specify whether the Button should be a small variant
     */
    small: deprecate(PropTypes__default.bool, "\nThe prop `small` for Button has been deprecated in favor of `size`. Please use `size=\"small\"` instead."),

    /**
     * Specify the kind of Button you want to create
     */
    kind: ButtonTypes.buttonKind.isRequired,

    /**
     * Optionally specify an href for your Button to become an <a> element
     */
    href: PropTypes__default.string,

    /**
     * Optional prop to specify the tabIndex of the Button
     */
    tabIndex: PropTypes__default.number,

    /**
     * Optional prop to specify the type of the Button
     */
    type: PropTypes__default.oneOf(['button', 'reset', 'submit']),

    /**
     * Optional prop to specify the role of the Button
     */
    role: PropTypes__default.string,

    /**
     * Optional prop to allow overriding the icon rendering.
     * Can be a React component class
     */
    renderIcon: PropTypes__default.oneOfType([PropTypes__default.func, PropTypes__default.object]),

    /**
     * If specifying the `icon` prop, provide a description for that icon that can
     * be read by screen readers
     */
    iconDescription: function iconDescription(props) {
      if (props.renderIcon && !props.children && !props.iconDescription) {
        return new Error('renderIcon property specified without also providing an iconDescription property.');
      }

      return undefined;
    },

    /**
     * Specify if the button is an icon-only button
     */
    hasIconOnly: PropTypes__default.bool,

    /**
     * Specify the direction of the tooltip for icon-only buttons.
     * Can be either top, right, bottom, or left.
     */
    tooltipPosition: PropTypes__default.oneOf(['top', 'right', 'bottom', 'left']),

    /**
     * Specify the alignment of the tooltip to the icon-only button.
     * Can be one of: start, center, or end.
     */
    tooltipAlignment: PropTypes__default.oneOf(['start', 'center', 'end'])
  };
  Button.defaultProps = {
    tabIndex: 0,
    type: 'button',
    disabled: false,
    kind: 'primary'
  };

  var prefix$b = settings_1.prefix;

  var CheckboxSkeleton =
  /*#__PURE__*/
  function (_React$Component) {
    _inherits(CheckboxSkeleton, _React$Component);

    function CheckboxSkeleton() {
      _classCallCheck(this, CheckboxSkeleton);

      return _possibleConstructorReturn(this, _getPrototypeOf(CheckboxSkeleton).apply(this, arguments));
    }

    _createClass(CheckboxSkeleton, [{
      key: "render",
      value: function render() {
        var id = this.props.id;
        return React__default.createElement("div", {
          className: "".concat(prefix$b, "--form-item ").concat(prefix$b, "--checkbox-wrapper")
        }, // eslint-disable-next-line jsx-a11y/label-has-for,jsx-a11y/label-has-associated-control
        React__default.createElement("label", {
          className: "".concat(prefix$b, "--checkbox-label ").concat(prefix$b, "--skeleton"),
          htmlFor: id
        }));
      }
    }]);

    return CheckboxSkeleton;
  }(React__default.Component);

  var prefix$c = settings_1.prefix;
  var Checkbox$1 = React__default.forwardRef(function Checkbox(_ref, _ref2) {
    var className = _ref.className,
        id = _ref.id,
        labelText = _ref.labelText,
        _onChange = _ref.onChange,
        indeterminate = _ref.indeterminate,
        hideLabel = _ref.hideLabel,
        wrapperClassName = _ref.wrapperClassName,
        _ref$title = _ref.title,
        title = _ref$title === void 0 ? '' : _ref$title,
        other = _objectWithoutProperties(_ref, ["className", "id", "labelText", "onChange", "indeterminate", "hideLabel", "wrapperClassName", "title"]);

    var labelClasses = classNames("".concat(prefix$c, "--checkbox-label"), className);
    var innerLabelClasses = classNames("".concat(prefix$c, "--checkbox-label-text"), _defineProperty({}, "".concat(prefix$c, "--visually-hidden"), hideLabel));
    var wrapperClasses = classNames("".concat(prefix$c, "--form-item"), "".concat(prefix$c, "--checkbox-wrapper"), wrapperClassName);
    return React__default.createElement("div", {
      className: wrapperClasses
    }, React__default.createElement("input", _extends({}, other, {
      type: "checkbox",
      onChange: function onChange(evt) {
        _onChange(evt.target.checked, id, evt);
      },
      className: "".concat(prefix$c, "--checkbox"),
      id: id,
      ref: function ref(el) {
        if (el) {
          el.indeterminate = indeterminate;
        }

        if (typeof _ref2 === 'function') {
          _ref2(el);
        } else if (Object(_ref2) === _ref2) {
          _ref2.current = el;
        }
      }
    })), React__default.createElement("label", {
      htmlFor: id,
      className: labelClasses,
      title: title || null
    }, React__default.createElement("span", {
      className: innerLabelClasses
    }, labelText)));
  });
  Checkbox$1.propTypes = {
    /**
     * Specify whether the underlying input should be checked
     */
    checked: PropTypes__default.bool,

    /**
     * Specify whether the underlying input should be checked by default
     */
    defaultChecked: PropTypes__default.bool,

    /**
     * Specify whether the Checkbox is in an indeterminate state
     */
    indeterminate: PropTypes__default.bool,

    /**
     * Specify an optional className to be applied to the <label> node
     */
    className: PropTypes__default.string,

    /**
     * Specify whether the Checkbox should be disabled
     */
    disabled: PropTypes__default.bool,

    /**
     * Provide an `id` to uniquely identify the Checkbox input
     */
    id: PropTypes__default.string.isRequired,

    /**
     * Provide a label to provide a description of the Checkbox input that you are
     * exposing to the user
     */
    labelText: PropTypes__default.node.isRequired,

    /**
     * Specify whether the label should be hidden, or not
     */
    hideLabel: PropTypes__default.bool,

    /**
     * Receives three arguments: true/false, the checkbox's id, and the dom event.
     * `(value, id, event) => console.log({value, id, event})`
     */
    onChange: PropTypes__default.func,

    /**
     * Specify a title for the <label> node for the Checkbox
     */
    title: PropTypes__default.string,

    /**
     * The CSS class name to be placed on the wrapping element
     */
    wrapperClassName: PropTypes__default.string
  };
  Checkbox$1.defaultProps = {
    onChange: function onChange() {},
    indeterminate: false
  };

  var prefix$d = settings_1.prefix;

  var CodeSnippetSkeleton =
  /*#__PURE__*/
  function (_Component) {
    _inherits(CodeSnippetSkeleton, _Component);

    function CodeSnippetSkeleton() {
      _classCallCheck(this, CodeSnippetSkeleton);

      return _possibleConstructorReturn(this, _getPrototypeOf(CodeSnippetSkeleton).apply(this, arguments));
    }

    _createClass(CodeSnippetSkeleton, [{
      key: "render",
      value: function render() {
        var _classNames;

        var _this$props = this.props,
            className = _this$props.className,
            type = _this$props.type,
            other = _objectWithoutProperties(_this$props, ["className", "type"]);

        var codeSnippetClasses = classNames(className, (_classNames = {}, _defineProperty(_classNames, "".concat(prefix$d, "--snippet"), true), _defineProperty(_classNames, "".concat(prefix$d, "--skeleton"), true), _defineProperty(_classNames, "".concat(prefix$d, "--snippet--single"), type === 'single'), _defineProperty(_classNames, "".concat(prefix$d, "--snippet--multi"), type === 'multi'), _classNames));

        if (type === 'single') {
          return React__default.createElement("div", _extends({
            className: codeSnippetClasses
          }, other), React__default.createElement("div", {
            className: "".concat(prefix$d, "--snippet-container")
          }, React__default.createElement("span", null)));
        }

        if (type === 'multi') {
          return React__default.createElement("div", _extends({
            className: codeSnippetClasses
          }, other), React__default.createElement("div", {
            className: "".concat(prefix$d, "--snippet-container")
          }, React__default.createElement("span", null), React__default.createElement("span", null), React__default.createElement("span", null)));
        }
      }
    }]);

    return CodeSnippetSkeleton;
  }(React.Component);

  _defineProperty(CodeSnippetSkeleton, "propTypes", {
    /**
     * The type of code snippet
     * can be single or multi
     */
    type: PropTypes__default.oneOf(['single', 'multi']),

    /**
     * Specify an optional className to be applied to the container node
     */
    className: PropTypes__default.string
  });

  _defineProperty(CodeSnippetSkeleton, "defaultProps", {
    type: 'single'
  });

  var prefix$e = settings_1.prefix;

  var Copy =
  /*#__PURE__*/
  function (_Component) {
    _inherits(Copy, _Component);

    function Copy() {
      var _getPrototypeOf2;

      var _this;

      _classCallCheck(this, Copy);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(Copy)).call.apply(_getPrototypeOf2, [this].concat(args)));

      _defineProperty(_assertThisInitialized(_this), "state", {
        showFeedback: false
      });

      _defineProperty(_assertThisInitialized(_this), "handleClick", function (evt) {
        _this.setState({
          showFeedback: true
        });

        _this.timeoutId = setTimeout(function () {
          _this.setState({
            showFeedback: false
          });
        }, _this.props.feedbackTimeout);

        _this.props.onClick(evt);
      });

      return _this;
    }

    _createClass(Copy, [{
      key: "componentWillUnmount",

      /* istanbul ignore next */
      value: function componentWillUnmount() {
        if (typeof this.timeoutId !== 'undefined') {
          clearTimeout(this.timeoutId);
          delete this.timeoutId;
        }
      }
    }, {
      key: "render",
      // eslint-disable-line no-unused-vars
      value: function render() {
        var _this$props = this.props,
            className = _this$props.className,
            feedback = _this$props.feedback,
            children = _this$props.children,
            feedbackTimeout = _this$props.feedbackTimeout,
            onClick = _this$props.onClick,
            other = _objectWithoutProperties(_this$props, ["className", "feedback", "children", "feedbackTimeout", "onClick"]);

        var feedbackClassNames = classNames("".concat(prefix$e, "--btn--copy__feedback"), _defineProperty({}, "".concat(prefix$e, "--btn--copy__feedback--displayed"), this.state.showFeedback));
        return React__default.createElement("button", _extends({
          type: "button",
          className: className,
          onClick: this.handleClick
        }, other), children, React__default.createElement("div", {
          className: feedbackClassNames,
          "data-feedback": feedback
        }));
      }
    }]);

    return Copy;
  }(React.Component);

  _defineProperty(Copy, "propTypes", {
    /**
     * Pass in content to be rendred in the underlying <button>
     */
    children: PropTypes__default.node,

    /**
     * Specify an optional className to be applied to the underlying <button>
     */
    className: PropTypes__default.string,

    /**
     * Specify the string that is displayed when the button is clicked and the
     * content is copied
     */
    feedback: PropTypes__default.string,

    /**
     * Specify the time it takes for the feedback message to timeout
     */
    feedbackTimeout: PropTypes__default.number,

    /**
     * Specify an optional `onClick` handler that is called when the underlying
     * <button> is clicked
     */
    onClick: PropTypes__default.func
  });

  _defineProperty(Copy, "defaultProps", {
    feedback: 'Copied!',
    feedbackTimeout: 2000,
    onClick: function onClick() {}
  });

  var prefix$f = settings_1.prefix;

  var CopyButton$1 =
  /*#__PURE__*/
  function (_Component) {
    _inherits(CopyButton, _Component);

    function CopyButton() {
      var _getPrototypeOf2;

      var _this;

      _classCallCheck(this, CopyButton);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(CopyButton)).call.apply(_getPrototypeOf2, [this].concat(args)));

      _defineProperty(_assertThisInitialized(_this), "state", {
        showFeedback: false
      });

      _defineProperty(_assertThisInitialized(_this), "handleClick", function (evt) {
        _this.setState({
          showFeedback: true
        });

        _this.timeoutId = setTimeout(function () {
          _this.setState({
            showFeedback: false
          });
        }, _this.props.feedbackTimeout);

        _this.props.onClick(evt);
      });

      return _this;
    }

    _createClass(CopyButton, [{
      key: "componentWillUnmount",

      /* istanbul ignore next */
      value: function componentWillUnmount() {
        if (typeof this.timeoutId !== 'undefined') {
          clearTimeout(this.timeoutId);
          delete this.timeoutId;
        }
      }
    }, {
      key: "render",
      // eslint-disable-line no-unused-vars
      value: function render() {
        var _this$props = this.props,
            iconDescription = _this$props.iconDescription,
            className = _this$props.className,
            feedback = _this$props.feedback,
            feedbackTimeout = _this$props.feedbackTimeout,
            onClick = _this$props.onClick,
            other = _objectWithoutProperties(_this$props, ["iconDescription", "className", "feedback", "feedbackTimeout", "onClick"]);

        var classNames$1 = classNames("".concat(prefix$f, "--snippet-button"), className);
        var feedbackClassNames = classNames("".concat(prefix$f, "--btn--copy__feedback"), _defineProperty({}, "".concat(prefix$f, "--btn--copy__feedback--displayed"), this.state.showFeedback));
        return React__default.createElement("button", _extends({
          type: "button",
          className: classNames$1,
          onClick: this.handleClick,
          title: iconDescription
        }, other), React__default.createElement(Copy16, {
          className: "".concat(prefix$f, "--snippet__icon"),
          "aria-label": iconDescription
        }), React__default.createElement("div", {
          className: feedbackClassNames,
          "data-feedback": feedback
        }));
      }
    }]);

    return CopyButton;
  }(React.Component);

  _defineProperty(CopyButton$1, "propTypes", {
    /**
     * Specify an optional className to be applied to the underlying <button>
     */
    className: PropTypes__default.string,

    /**
     * Provide a description for the icon representing the copy action that can
     * be read by screen readers
     */
    iconDescription: PropTypes__default.string,

    /**
     * Specify the string that is displayed when the button is clicked and the
     * content is copied
     */
    feedback: PropTypes__default.string,

    /**
     * Specify the time it takes for the feedback message to timeout
     */
    feedbackTimeout: PropTypes__default.number,

    /**
     * Specify an optional `onClick` handler that is called when the underlying
     * <button> is clicked
     */
    onClick: PropTypes__default.func
  });

  _defineProperty(CopyButton$1, "defaultProps", {
    iconDescription: 'Copy to clipboard',
    feedback: 'Copied!',
    feedbackTimeout: 2000,
    onClick: function onClick() {}
  });

  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */
  var lastId = 0;
  function uid () {
    var prefix = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'id';
    lastId++;
    return "".concat(prefix).concat(lastId);
  }

  var prefix$g = settings_1.prefix;

  var CodeSnippet$1 =
  /*#__PURE__*/
  function (_Component) {
    _inherits(CodeSnippet, _Component);

    function CodeSnippet() {
      var _getPrototypeOf2;

      var _this;

      _classCallCheck(this, CodeSnippet);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(CodeSnippet)).call.apply(_getPrototypeOf2, [this].concat(args)));

      _defineProperty(_assertThisInitialized(_this), "state", {
        shouldShowMoreLessBtn: false,
        expandedCode: false
      });

      _defineProperty(_assertThisInitialized(_this), "expandCode", function () {
        _this.setState({
          expandedCode: !_this.state.expandedCode
        });
      });

      return _this;
    }

    _createClass(CodeSnippet, [{
      key: "componentDidMount",
      value: function componentDidMount() {
        if (this.codeContent) {
          if (this.codeContent.getBoundingClientRect().height > 255) {
            this.setState({
              shouldShowMoreLessBtn: true
            });
          }
        }
      }
    }, {
      key: "componentDidUpdate",
      value: function componentDidUpdate(prevProps) {
        if (this.props.children !== prevProps.children && this.codeContent) {
          if (this.codeContent.getBoundingClientRect().height > 255) {
            this.setState({
              shouldShowMoreLessBtn: true
            });
          }
        }
      }
    }, {
      key: "render",
      value: function render() {
        var _classNames,
            _this2 = this;

        var _this$props = this.props,
            className = _this$props.className,
            type = _this$props.type,
            children = _this$props.children,
            feedback = _this$props.feedback,
            onClick = _this$props.onClick,
            ariaLabel = _this$props.ariaLabel,
            copyLabel = _this$props.copyLabel,
            copyButtonDescription = _this$props.copyButtonDescription,
            light = _this$props.light,
            showMoreText = _this$props.showMoreText,
            showLessText = _this$props.showLessText,
            other = _objectWithoutProperties(_this$props, ["className", "type", "children", "feedback", "onClick", "ariaLabel", "copyLabel", "copyButtonDescription", "light", "showMoreText", "showLessText"]); // a unique id generated for aria-describedby


        this.uid = uid();
        var codeSnippetClasses = classNames(className, (_classNames = {}, _defineProperty(_classNames, "".concat(prefix$g, "--snippet"), true), _defineProperty(_classNames, "".concat(prefix$g, "--snippet--single"), type === 'single'), _defineProperty(_classNames, "".concat(prefix$g, "--snippet--multi"), type === 'multi'), _defineProperty(_classNames, "".concat(prefix$g, "--snippet--inline"), type === 'inline'), _defineProperty(_classNames, "".concat(prefix$g, "--snippet--expand"), this.state.expandedCode), _defineProperty(_classNames, "".concat(prefix$g, "--snippet--light"), light), _classNames));
        var expandCodeBtnText = this.state.expandedCode ? showLessText : showMoreText;
        var moreLessBtn = React__default.createElement("button", {
          className: "".concat(prefix$g, "--btn ").concat(prefix$g, "--btn--ghost ").concat(prefix$g, "--btn--sm ").concat(prefix$g, "--snippet-btn--expand"),
          type: "button",
          onClick: this.expandCode
        }, React__default.createElement("span", {
          className: "".concat(prefix$g, "--snippet-btn--text")
        }, expandCodeBtnText), React__default.createElement(ChevronDown16, {
          "aria-label": expandCodeBtnText,
          className: "".concat(prefix$g, "--icon-chevron--down ").concat(prefix$g, "--snippet__icon"),
          name: "chevron--down",
          role: "img"
        }));
        var code = React__default.createElement("div", {
          role: "textbox",
          tabIndex: 0,
          className: "".concat(prefix$g, "--snippet-container"),
          "aria-label": ariaLabel || copyLabel || 'code-snippet'
        }, React__default.createElement("code", null, React__default.createElement("pre", {
          ref: function ref(codeContent) {
            _this2.codeContent = codeContent;
          }
        }, children)));
        var copy = React__default.createElement(CopyButton$1, {
          onClick: onClick,
          feedback: feedback,
          iconDescription: copyButtonDescription
        });

        if (type === 'inline') {
          return React__default.createElement(Copy, _extends({}, other, {
            onClick: onClick,
            "aria-label": copyLabel || ariaLabel,
            "aria-describedby": this.uid,
            className: codeSnippetClasses,
            feedback: feedback
          }), React__default.createElement("code", {
            id: this.uid
          }, children));
        }

        if (type === 'single') {
          return React__default.createElement("div", _extends({}, other, {
            className: codeSnippetClasses
          }), code, copy);
        }

        if (!this.state.shouldShowMoreLessBtn && type === 'multi') {
          return React__default.createElement("div", _extends({}, other, {
            className: codeSnippetClasses
          }), code, copy);
        }

        if (this.state.shouldShowMoreLessBtn && type === 'multi') {
          return React__default.createElement("div", _extends({
            className: codeSnippetClasses
          }, other), code, copy, moreLessBtn);
        }
      }
    }]);

    return CodeSnippet;
  }(React.Component);

  _defineProperty(CodeSnippet$1, "propTypes", {
    /**
     * Provide the type of Code Snippet
     */
    type: PropTypes__default.oneOf(['single', 'inline', 'multi']),

    /**
     * Specify an optional className to be applied to the container node
     */
    className: PropTypes__default.string,

    /**
     * Provide the content of your CodeSnippet as a string
     */
    children: PropTypes__default.string,

    /**
     * Specify the string displayed when the snippet is copied
     */
    feedback: PropTypes__default.string,

    /**
     * Specify the description for the Copy Button
     */
    copyButtonDescription: PropTypes__default.string,

    /**
     * An optional handler to listen to the `onClick` even fired by the Copy
     * Button
     */
    onClick: PropTypes__default.func,

    /**
     * Specify a label to be read by screen readers on the containing <textbox>
     * node
     */
    copyLabel: PropTypes__default.string,

    /**
     * Specify a label to be read by screen readers on the containing <textbox>
     * node
     */
    ariaLabel: PropTypes__default.string,

    /**
     * Specify a string that is displayed when the Code Snippet text is more
     * than 15 lines
     */
    showMoreText: PropTypes__default.string,

    /**
     * Specify a string that is displayed when the Code Snippet has been
     * interacted with to show more lines
     */
    showLessText: PropTypes__default.string,

    /**
     * Specify whether you are using the light variant of the Code Snippet,
     * typically used for inline snippest to display an alternate color
     */
    light: PropTypes__default.bool
  });

  _defineProperty(CodeSnippet$1, "defaultProps", {
    type: 'single',
    showMoreText: 'Show more',
    showLessText: 'Show less'
  });

  var statusDiv = typeof document === 'undefined' ? null : document.getElementById('a11y-status-message');
  var statuses = [];

  function setStatus(status) {
    var isSameAsLast = statuses[statuses.length - 1] === status;

    if (isSameAsLast) {
      statuses = [].concat(statuses, [status]);
    } else {
      statuses = [status];
    }

    var div = getStatusDiv(); // Remove previous children

    while (div.lastChild) {
      div.removeChild(div.firstChild);
    }

    statuses.filter(Boolean).forEach(function (statusItem, index) {
      div.appendChild(getStatusChildDiv(statusItem, index));
    });
  }

  function getStatusChildDiv(status, index) {
    var display = index === statuses.length - 1 ? 'block' : 'none';
    var childDiv = document.createElement('div');
    childDiv.style.display = display;
    childDiv.textContent = status;
    return childDiv;
  }

  function getStatusDiv() {
    if (statusDiv) {
      return statusDiv;
    }

    statusDiv = document.createElement('div');
    statusDiv.setAttribute('id', 'a11y-status-message');
    statusDiv.setAttribute('role', 'status');
    statusDiv.setAttribute('aria-live', 'assertive');
    statusDiv.setAttribute('aria-relevant', 'additions text');
    Object.assign(statusDiv.style, {
      border: '0',
      clip: 'rect(0 0 0 0)',
      height: '1px',
      margin: '-1px',
      overflow: 'hidden',
      padding: '0',
      position: 'absolute',
      width: '1px'
    });
    document.body.appendChild(statusDiv);
    return statusDiv;
  }

  var idCounter = 0;
  /**
   * Accepts a parameter and returns it if it's a function
   * or a noop function if it's not. This allows us to
   * accept a callback, but not worry about it if it's not
   * passed.
   * @param {Function} cb the callback
   * @return {Function} a function
   */

  function cbToCb(cb) {
    return typeof cb === 'function' ? cb : noop;
  }

  function noop() {}

  function findParent(finder, node, rootNode) {
    if (node !== null && node !== rootNode.parentNode) {
      if (finder(node)) {
        if (node === document.body && node.scrollTop === 0) {
          // in chrome body.scrollTop always return 0
          return document.documentElement;
        }

        return node;
      } else {
        return findParent(finder, node.parentNode, rootNode);
      }
    } else {
      return null;
    }
  }
  /**
   * Get the closest element that scrolls
   * @param {HTMLElement} node - the child element to start searching for scroll parent at
   * @param {HTMLElement} rootNode - the root element of the component
   * @return {HTMLElement} the closest parentNode that scrolls
   */


  var getClosestScrollParent = findParent.bind(null, function (node) {
    return node.scrollHeight > node.clientHeight;
  });
  /**
   * Scroll node into view if necessary
   * @param {HTMLElement} node - the element that should scroll into view
   * @param {HTMLElement} rootNode - the root element of the component
   * @param {Boolean} alignToTop - align element to the top of the visible area of the scrollable ancestor
   */
  // eslint-disable-next-line complexity

  function scrollIntoView(node, rootNode) {
    var scrollParent = getClosestScrollParent(node, rootNode);

    if (scrollParent === null) {
      return;
    }

    var scrollParentStyles = getComputedStyle(scrollParent);
    var scrollParentRect = scrollParent.getBoundingClientRect();
    var scrollParentBorderTopWidth = parseInt(scrollParentStyles.borderTopWidth, 10);
    var scrollParentBorderBottomWidth = parseInt(scrollParentStyles.borderBottomWidth, 10);
    var bordersWidth = scrollParentBorderTopWidth + scrollParentBorderBottomWidth;
    var scrollParentTop = scrollParentRect.top + scrollParentBorderTopWidth;
    var nodeRect = node.getBoundingClientRect();

    if (nodeRect.top < 0 && scrollParentRect.top < 0) {
      scrollParent.scrollTop += nodeRect.top;
      return;
    }

    if (nodeRect.top < 0) {
      // the item is above the viewport and the parent is not above the viewport
      scrollParent.scrollTop += nodeRect.top - scrollParentTop;
      return;
    }

    if (nodeRect.top > 0 && scrollParentRect.top < 0) {
      if (scrollParentRect.bottom > 0 && nodeRect.bottom + bordersWidth > scrollParentRect.bottom) {
        // the item is below scrollable area
        scrollParent.scrollTop += nodeRect.bottom - scrollParentRect.bottom + bordersWidth;
      } // item and parent top are on different sides of view top border (do nothing)


      return;
    }

    var nodeOffsetTop = nodeRect.top + scrollParent.scrollTop;
    var nodeTop = nodeOffsetTop - scrollParentTop;

    if (nodeTop < scrollParent.scrollTop) {
      // the item is above the scrollable area
      scrollParent.scrollTop = nodeTop;
    } else if (nodeTop + nodeRect.height + bordersWidth > scrollParent.scrollTop + scrollParentRect.height) {
      // the item is below the scrollable area
      scrollParent.scrollTop = nodeTop + nodeRect.height - scrollParentRect.height + bordersWidth;
    } // the item is within the scrollable area (do nothing)

  }
  /**
   * @param {HTMLElement} parent the parent node
   * @param {HTMLElement} child the child node
   * @return {Boolean} whether the parent is the child or the child is in the parent
   */


  function isOrContainsNode(parent, child) {
    return parent === child || parent.contains(child);
  }
  /**
   * Simple debounce implementation. Will call the given
   * function once after the time given has passed since
   * it was last called.
   * @param {Function} fn the function to call after the time
   * @param {Number} time the time to wait
   * @return {Function} the debounced function
   */


  function debounce$1(fn, time) {
    var timeoutId = void 0;
    return wrapper;

    function wrapper() {
      for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      if (timeoutId) {
        clearTimeout(timeoutId);
      }

      timeoutId = setTimeout(function () {
        timeoutId = null;
        fn.apply(undefined, args);
      }, time);
    }
  }
  /**
   * This is intended to be used to compose event handlers.
   * They are executed in order until one of them sets
   * `event.preventDownshiftDefault = true`.
   * @param {Function} fns the event handler functions
   * @return {Function} the event handler to add to an element
   */


  function composeEventHandlers() {
    for (var _len2 = arguments.length, fns = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      fns[_key2] = arguments[_key2];
    }

    return function (event) {
      for (var _len3 = arguments.length, args = Array(_len3 > 1 ? _len3 - 1 : 0), _key3 = 1; _key3 < _len3; _key3++) {
        args[_key3 - 1] = arguments[_key3];
      }

      return fns.some(function (fn) {
        fn && fn.apply(undefined, [event].concat(args)); // TODO: remove everything after the || in the next breaking change

        return event.preventDownshiftDefault || event.defaultPrevented;
      });
    };
  }
  /**
   * This generates a unique ID for an instance of Downshift
   * @return {String} the unique ID
   */


  function generateId() {
    return String(idCounter++);
  }
  /**
   * Resets idCounter to 0. Used for SSR.
   */


  function resetIdCounter() {
    idCounter = 0;
  }
  /**
   * Returns the first argument that is not undefined
   * @param {...*} args the arguments
   * @return {*} the defined value
   */


  function firstDefined() {
    for (var _len4 = arguments.length, args = Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
      args[_key4] = arguments[_key4];
    }

    return args.find(function (a) {
      return typeof a !== 'undefined';
    });
  } // eslint-disable-next-line complexity


  function getA11yStatusMessage(_ref) {
    var isOpen = _ref.isOpen,
        highlightedItem = _ref.highlightedItem,
        selectedItem = _ref.selectedItem,
        resultCount = _ref.resultCount,
        previousResultCount = _ref.previousResultCount,
        itemToString = _ref.itemToString;

    if (!isOpen) {
      if (selectedItem) {
        return itemToString(selectedItem);
      } else {
        return '';
      }
    }

    if (!resultCount) {
      return 'No results.';
    } else if (!highlightedItem || resultCount !== previousResultCount) {
      return resultCount + ' ' + (resultCount === 1 ? 'result is' : 'results are') + ' available, use up and down arrow keys to navigate.';
    }

    return itemToString(highlightedItem);
  }
  /**
   * Takes an argument and if it's an array, returns the first item in the array
   * otherwise returns the argument
   * @param {*} arg the maybe-array
   * @param {*} defaultValue the value if arg is falsey not defined
   * @return {*} the arg or it's first item
   */


  function unwrapArray(arg, defaultValue) {
    arg = Array.isArray(arg) ?
    /* istanbul ignore next (preact) */
    arg[0] : arg;

    if (!arg && defaultValue) {
      return defaultValue;
    } else {
      return arg;
    }
  }
  /**
   * @param {Object} element (P)react element
   * @return {Boolean} whether it's a DOM element
   */


  function isDOMElement(element) {
    /* istanbul ignore if */
    if (element.nodeName) {
      // then this is preact
      return typeof element.nodeName === 'string';
    } else {
      // then we assume this is react
      return typeof element.type === 'string';
    }
  }
  /**
   * @param {Object} element (P)react element
   * @return {Object} the props
   */


  function getElementProps(element) {
    // props for react, attributes for preact
    return element.props ||
    /* istanbul ignore next (preact) */
    element.attributes;
  }
  /**
   * Throws a helpful error message for required properties. Useful
   * to be used as a default in destructuring or object params.
   * @param {String} fnName the function name
   * @param {String} propName the prop name
   */


  function requiredProp(fnName, propName) {
    throw new Error('The property "' + propName + '" is required in "' + fnName + '"');
  }

  var stateKeys = ['highlightedIndex', 'inputValue', 'isOpen', 'selectedItem', 'type'];
  /**
   * @param {Object} state The state object
   * @return {Object} State that is relevant to downshift
   */

  function pickState() {
    var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var result = {};
    stateKeys.forEach(function (k) {
      if (state.hasOwnProperty(k)) {
        result[k] = state[k];
      }
    });
    return result;
  }
  /**
   * Normalizes the 'key' property of a KeyboardEvent in IE/Edge
   * @param {Object} event a KeyboardEvent object
   * @return {String} keyboard key
   */


  function normalizeArrowKey(event) {
    var key = event.key,
        keyCode = event.keyCode;
    /* istanbul ignore next (ie) */

    if (keyCode >= 37 && keyCode <= 40 && key.indexOf('Arrow') !== 0) {
      return 'Arrow' + key;
    }

    return key;
  }
  /**
   * Simple check if the value passed is object literal
   * @param {*} obj any things
   * @return {Boolean} whether it's object literal
   */


  function isPlainObject(obj) {
    return Object.prototype.toString.call(obj) === '[object Object]';
  }

  var classCallCheck = function (instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  };

  var _extends$2 = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];

      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }

    return target;
  };

  var inherits = function (subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        enumerable: false,
        writable: true,
        configurable: true
      }
    });
    if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
  };

  var objectWithoutProperties = function (obj, keys) {
    var target = {};

    for (var i in obj) {
      if (keys.indexOf(i) >= 0) continue;
      if (!Object.prototype.hasOwnProperty.call(obj, i)) continue;
      target[i] = obj[i];
    }

    return target;
  };

  var possibleConstructorReturn = function (self, call) {
    if (!self) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return call && (typeof call === "object" || typeof call === "function") ? call : self;
  };
  /* eslint camelcase:0 */


  var Downshift = function (_Component) {
    inherits(Downshift, _Component);

    function Downshift() {
      classCallCheck(this, Downshift);

      for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      var _this = possibleConstructorReturn(this, _Component.call.apply(_Component, [this].concat(args)));

      _initialiseProps.call(_this);

      var state = _this.getState({
        highlightedIndex: _this.props.defaultHighlightedIndex,
        isOpen: _this.props.defaultIsOpen,
        inputValue: _this.props.defaultInputValue,
        selectedItem: _this.props.defaultSelectedItem
      });

      if (state.selectedItem != null) {
        state.inputValue = _this.props.itemToString(state.selectedItem);
      }

      _this.state = state;
      _this.id = _this.props.id || 'downshift-' + generateId();
      return _this;
    } // itemCount can be changed asynchronously
    // from within downshift (so it can't come from a prop)
    // this is why we store it as an instance and use
    // getItemCount rather than just use items.length
    // (to support windowing + async)

    /**
     * Gets the state based on internal state or props
     * If a state value is passed via props, then that
     * is the value given, otherwise it's retrieved from
     * stateToMerge
     *
     * This will perform a shallow merge of the given state object
     * with the state coming from props
     * (for the controlled component scenario)
     * This is used in state updater functions so they're referencing
     * the right state regardless of where it comes from.
     *
     * @param {Object} stateToMerge defaults to this.state
     * @return {Object} the state
     */


    Downshift.prototype.getState = function getState() {
      var _this2 = this;

      var stateToMerge = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.state;
      return Object.keys(stateToMerge).reduce(function (state, key) {
        state[key] = _this2.isControlledProp(key) ? _this2.props[key] : stateToMerge[key];
        return state;
      }, {});
    };
    /**
     * This determines whether a prop is a "controlled prop" meaning it is
     * state which is controlled by the outside of this component rather
     * than within this component.
     * @param {String} key the key to check
     * @return {Boolean} whether it is a controlled controlled prop
     */


    Downshift.prototype.isControlledProp = function isControlledProp(key) {
      return this.props[key] !== undefined;
    };

    Downshift.prototype.getItemCount = function getItemCount() {
      // things read better this way. They're in priority order:
      // 1. `this.itemCount`
      // 2. `this.props.itemCount`
      // 3. `this.items.length`

      /* eslint-disable no-negated-condition */
      if (this.itemCount != null) {
        return this.itemCount;
      } else if (this.props.itemCount !== undefined) {
        return this.props.itemCount;
      } else {
        return this.items.length;
      }
      /* eslint-enable no-negated-condition */

    };

    Downshift.prototype.getItemNodeFromIndex = function getItemNodeFromIndex(index) {
      return this.props.environment.document.getElementById(this.getItemId(index));
    };

    Downshift.prototype.scrollHighlightedItemIntoView = function scrollHighlightedItemIntoView() {
      /* istanbul ignore else (react-native) */
      {
        var node = this.getItemNodeFromIndex(this.getState().highlightedIndex);
        scrollIntoView(node, this._rootNode);
      }
    };

    Downshift.prototype.moveHighlightedIndex = function moveHighlightedIndex(amount, otherStateToSet) {
      if (this.getState().isOpen) {
        this.changeHighlightedIndex(amount, otherStateToSet);
      } else {
        this.setHighlightedIndex(undefined, _extends$2({
          isOpen: true
        }, otherStateToSet));
      }
    }; // eslint-disable-next-line complexity


    Downshift.prototype.changeHighlightedIndex = function changeHighlightedIndex(moveAmount, otherStateToSet) {
      var itemsLastIndex = this.getItemCount() - 1;

      if (itemsLastIndex < 0) {
        return;
      }

      var _getState = this.getState(),
          highlightedIndex = _getState.highlightedIndex;

      var baseIndex = highlightedIndex;

      if (baseIndex === null) {
        baseIndex = moveAmount > 0 ? -1 : itemsLastIndex + 1;
      }

      var newIndex = baseIndex + moveAmount;

      if (newIndex < 0) {
        newIndex = itemsLastIndex;
      } else if (newIndex > itemsLastIndex) {
        newIndex = 0;
      }

      this.setHighlightedIndex(newIndex, otherStateToSet);
    }; // any piece of our state can live in two places:
    // 1. Uncontrolled: it's internal (this.state)
    //    We will call this.setState to update that state
    // 2. Controlled: it's external (this.props)
    //    We will call this.props.onStateChange to update that state
    //
    // In addition, we'll call this.props.onChange if the
    // selectedItem is changed.


    Downshift.prototype.getStateAndHelpers = function getStateAndHelpers() {
      var _getState2 = this.getState(),
          highlightedIndex = _getState2.highlightedIndex,
          inputValue = _getState2.inputValue,
          selectedItem = _getState2.selectedItem,
          isOpen = _getState2.isOpen;

      var itemToString = this.props.itemToString;
      var id = this.id;
      var getRootProps = this.getRootProps,
          getButtonProps = this.getButtonProps,
          getToggleButtonProps = this.getToggleButtonProps,
          getLabelProps = this.getLabelProps,
          getInputProps = this.getInputProps,
          getItemProps = this.getItemProps,
          openMenu = this.openMenu,
          closeMenu = this.closeMenu,
          toggleMenu = this.toggleMenu,
          selectItem = this.selectItem,
          selectItemAtIndex = this.selectItemAtIndex,
          selectHighlightedItem = this.selectHighlightedItem,
          setHighlightedIndex = this.setHighlightedIndex,
          clearSelection = this.clearSelection,
          clearItems = this.clearItems,
          reset = this.reset,
          setItemCount = this.setItemCount,
          unsetItemCount = this.unsetItemCount,
          setState = this.internalSetState;
      return {
        // prop getters
        getRootProps: getRootProps,
        getButtonProps: getButtonProps,
        getToggleButtonProps: getToggleButtonProps,
        getLabelProps: getLabelProps,
        getInputProps: getInputProps,
        getItemProps: getItemProps,
        // actions
        reset: reset,
        openMenu: openMenu,
        closeMenu: closeMenu,
        toggleMenu: toggleMenu,
        selectItem: selectItem,
        selectItemAtIndex: selectItemAtIndex,
        selectHighlightedItem: selectHighlightedItem,
        setHighlightedIndex: setHighlightedIndex,
        clearSelection: clearSelection,
        clearItems: clearItems,
        setItemCount: setItemCount,
        unsetItemCount: unsetItemCount,
        setState: setState,
        //props
        itemToString: itemToString,
        //derived
        id: id,
        // state
        highlightedIndex: highlightedIndex,
        inputValue: inputValue,
        isOpen: isOpen,
        selectedItem: selectedItem
      };
    }; //////////////////////////// ROOT
    //\\\\\\\\\\\\\\\\\\\\\\\\\\ ROOT
    //////////////////////////// BUTTON
    // TODO: remove this in 2.0.0 and just call it `getToggleButtonProps`
    //\\\\\\\\\\\\\\\\\\\\\\\\\\\\\ BUTTON
    /////////////////////////////// LABEL
    //\\\\\\\\\\\\\\\\\\\\\\\\\\\\\ LABEL
    /////////////////////////////// INPUT
    //\\\\\\\\\\\\\\\\\\\\\\\\\\\\\ INPUT
    /////////////////////////////// ITEM


    Downshift.prototype.getItemId = function getItemId(index) {
      return this.id + '-item-' + index;
    }; //\\\\\\\\\\\\\\\\\\\\\\\\\\\\\ ITEM


    Downshift.prototype.componentDidMount = function componentDidMount() {
      var _this3 = this; // the _isMounted property is because we have `updateStatus` in a `debounce`
      // and we don't want to update the status if the component has been umounted


      this._isMounted = true;
      /* istanbul ignore if (react-native) */

      {
        // this.isMouseDown helps us track whether the mouse is currently held down.
        // This is useful when the user clicks on an item in the list, but holds the mouse
        // down long enough for the list to disappear (because the blur event fires on the input)
        // this.isMouseDown is used in the blur handler on the input to determine whether the blur event should
        // trigger hiding the menu.
        var onMouseDown = function () {
          _this3.isMouseDown = true;
        };

        var onMouseUp = function (event) {
          var document = _this3.props.environment.document;
          _this3.isMouseDown = false;
          var targetInDownshift = _this3._rootNode && isOrContainsNode(_this3._rootNode, event.target);
          var activeElementInDownshift = _this3._rootNode && isOrContainsNode(_this3._rootNode, document.activeElement);

          if (!targetInDownshift && !activeElementInDownshift && _this3.getState().isOpen) {
            _this3.reset({
              type: Downshift.stateChangeTypes.mouseUp
            }, function () {
              return _this3.props.onOuterClick(_this3.getStateAndHelpers());
            });
          }
        }; // Touching an element in iOS gives focus and hover states, but touching out of
        // the element will remove hover, and persist the focus state, resulting in the
        // blur event not being triggered.


        var onTouchStart = function (event) {
          var targetInDownshift = _this3._rootNode && isOrContainsNode(_this3._rootNode, event.target);

          if (!targetInDownshift && _this3.getState().isOpen) {
            _this3.reset({
              type: Downshift.stateChangeTypes.touchStart
            }, function () {
              return _this3.props.onOuterClick(_this3.getStateAndHelpers());
            });
          }
        };

        this.props.environment.addEventListener('mousedown', onMouseDown);
        this.props.environment.addEventListener('mouseup', onMouseUp);
        this.props.environment.addEventListener('touchstart', onTouchStart);

        this.cleanup = function () {
          _this3._isMounted = false;

          _this3.props.environment.removeEventListener('mousedown', onMouseDown);

          _this3.props.environment.removeEventListener('mouseup', onMouseUp);

          _this3.props.environment.removeEventListener('touchstart', onTouchStart);
        };
      }
    };

    Downshift.prototype.componentDidUpdate = function componentDidUpdate(prevProps, prevState) {
      if (this.isControlledProp('selectedItem') && this.props.selectedItemChanged(prevProps.selectedItem, this.props.selectedItem)) {
        this.internalSetState({
          type: Downshift.stateChangeTypes.controlledPropUpdatedSelectedItem,
          inputValue: this.props.itemToString(this.props.selectedItem)
        });
      }

      var current = this.props.highlightedIndex === undefined ? this.state : this.props;
      var prev = prevProps.highlightedIndex === undefined ? prevState : prevProps;

      if (current.highlightedIndex !== prev.highlightedIndex && !this.avoidScrolling) {
        this.scrollHighlightedItemIntoView();
      }

      this.updateStatus();
    };

    Downshift.prototype.componentWillUnmount = function componentWillUnmount() {
      this.cleanup(); // avoids memory leak
    }; // eslint-disable-next-line complexity


    Downshift.prototype.render = function render() {
      var children = unwrapArray(this.props.render || this.props.children, noop); // because the items are rerendered every time we call the children
      // we clear this out each render and

      this.clearItems(); // we reset this so we know whether the user calls getRootProps during
      // this render. If they do then we don't need to do anything,
      // if they don't then we need to clone the element they return and
      // apply the props for them.

      this.getRootProps.called = false;
      this.getRootProps.refKey = undefined;
      this.getRootProps.suppressRefError = undefined; // we do something similar for getLabelProps

      this.getLabelProps.called = false; // and something similar for getInputProps

      this.getInputProps.called = false;
      var element = unwrapArray(children(this.getStateAndHelpers()));

      if (!element) {
        return null;
      }

      if (this.getRootProps.called) {
        if (!this.getRootProps.suppressRefError) {
          validateGetRootPropsCalledCorrectly(element, this.getRootProps);
        }

        return element;
      } else if (isDOMElement(element)) {
        // they didn't apply the root props, but we can clone
        // this and apply the props ourselves
        return React__default.cloneElement(element, this.getRootProps(getElementProps(element)));
      } else {
        // they didn't apply the root props, but they need to
        // otherwise we can't query around the autocomplete
        throw new Error('downshift: If you return a non-DOM element, you must use apply the getRootProps function');
      }
    };

    return Downshift;
  }(React.Component);

  Downshift.defaultProps = {
    defaultHighlightedIndex: null,
    defaultSelectedItem: null,
    defaultInputValue: '',
    defaultIsOpen: false,
    getA11yStatusMessage: getA11yStatusMessage,
    itemToString: function itemToString(i) {
      if (i == null) {
        return '';
      }

      if ( isPlainObject(i)) {
        //eslint-disable-next-line no-console
        console.warn('downshift: An object was passed to the default implementation of `itemToString`. You should probably provide your own `itemToString` implementation. Please refer to the `itemToString` API documentation.', 'The object that was passed:', i);
      }

      return String(i);
    },
    onStateChange: function onStateChange() {},
    onInputValueChange: function onInputValueChange() {},
    onUserAction: function onUserAction() {},
    onChange: function onChange() {},
    onSelect: function onSelect() {},
    onOuterClick: function onOuterClick() {},
    selectedItemChanged: function selectedItemChanged(prevItem, item) {
      return prevItem !== item;
    },
    environment: typeof window === 'undefined'
    /* istanbul ignore next (ssr) */
    ? {} : window,
    stateReducer: function stateReducer(state, stateToSet) {
      return stateToSet;
    },
    breakingChanges: {}
  };
  Downshift.stateChangeTypes = {
    unknown: '__autocomplete_unknown__',
    mouseUp: '__autocomplete_mouseup__',
    itemMouseEnter: '__autocomplete_item_mouseenter__',
    keyDownArrowUp: '__autocomplete_keydown_arrow_up__',
    keyDownArrowDown: '__autocomplete_keydown_arrow_down__',
    keyDownEscape: '__autocomplete_keydown_escape__',
    keyDownEnter: '__autocomplete_keydown_enter__',
    clickItem: '__autocomplete_click_item__',
    blurInput: '__autocomplete_blur_input__',
    changeInput: '__autocomplete_change_input__',
    keyDownSpaceButton: '__autocomplete_keydown_space_button__',
    clickButton: '__autocomplete_click_button__',
    blurButton: '__autocomplete_blur_button__',
    controlledPropUpdatedSelectedItem: '__autocomplete_controlled_prop_updated_selected_item__',
    touchStart: '__autocomplete_touchstart__'
  };

  var _initialiseProps = function () {
    var _this4 = this;

    this.input = null;
    this.items = [];
    this.itemCount = null;
    this.previousResultCount = 0;

    this.setItemCount = function (count) {
      return _this4.itemCount = count;
    };

    this.unsetItemCount = function () {
      return _this4.itemCount = null;
    };

    this.setHighlightedIndex = function () {
      var highlightedIndex = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : _this4.props.defaultHighlightedIndex;
      var otherStateToSet = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      otherStateToSet = pickState(otherStateToSet);

      _this4.internalSetState(_extends$2({
        highlightedIndex: highlightedIndex
      }, otherStateToSet));
    };

    this.clearSelection = function (cb) {
      _this4.internalSetState({
        selectedItem: null,
        inputValue: '',
        isOpen: false
      }, cb);
    };

    this.selectItem = function (item, otherStateToSet, cb) {
      otherStateToSet = pickState(otherStateToSet);

      _this4.internalSetState(_extends$2({
        isOpen: false,
        highlightedIndex: _this4.props.defaultHighlightedIndex,
        selectedItem: item,
        inputValue: _this4.isControlledProp('selectedItem') && _this4.props.breakingChanges.resetInputOnSelection ? _this4.props.defaultInputValue : _this4.props.itemToString(item)
      }, otherStateToSet), cb);
    };

    this.selectItemAtIndex = function (itemIndex, otherStateToSet, cb) {
      var item = _this4.items[itemIndex];

      if (item == null) {
        return;
      }

      _this4.selectItem(item, otherStateToSet, cb);
    };

    this.selectHighlightedItem = function (otherStateToSet, cb) {
      return _this4.selectItemAtIndex(_this4.getState().highlightedIndex, otherStateToSet, cb);
    };

    this.internalSetState = function (stateToSet, cb) {
      var isItemSelected = void 0,
          onChangeArg = void 0;
      var onStateChangeArg = {};
      var isStateToSetFunction = typeof stateToSet === 'function'; // we want to call `onInputValueChange` before the `setState` call
      // so someone controlling the `inputValue` state gets notified of
      // the input change as soon as possible. This avoids issues with
      // preserving the cursor position.
      // See https://github.com/paypal/downshift/issues/217 for more info.

      if (!isStateToSetFunction && stateToSet.hasOwnProperty('inputValue')) {
        _this4.props.onInputValueChange(stateToSet.inputValue, _extends$2({}, _this4.getStateAndHelpers(), stateToSet));
      }

      return _this4.setState(function (state) {
        state = _this4.getState(state);
        var newStateToSet = isStateToSetFunction ? stateToSet(state) : stateToSet; // Your own function that could modify the state that will be set.

        newStateToSet = _this4.props.stateReducer(state, newStateToSet); // checks if an item is selected, regardless of if it's different from
        // what was selected before
        // used to determine if onSelect and onChange callbacks should be called

        isItemSelected = newStateToSet.hasOwnProperty('selectedItem'); // this keeps track of the object we want to call with setState

        var nextState = {}; // this is just used to tell whether the state changed

        var nextFullState = {}; // we need to call on change if the outside world is controlling any of our state
        // and we're trying to update that state. OR if the selection has changed and we're
        // trying to update the selection

        if (isItemSelected && newStateToSet.selectedItem !== state.selectedItem) {
          onChangeArg = newStateToSet.selectedItem;
        }

        newStateToSet.type = newStateToSet.type || Downshift.stateChangeTypes.unknown;
        Object.keys(newStateToSet).forEach(function (key) {
          // onStateChangeArg should only have the state that is
          // actually changing
          if (state[key] !== newStateToSet[key]) {
            onStateChangeArg[key] = newStateToSet[key];
          } // the type is useful for the onStateChangeArg
          // but we don't actually want to set it in internal state.
          // this is an undocumented feature for now... Not all internalSetState
          // calls support it and I'm not certain we want them to yet.
          // But it enables users controlling the isOpen state to know when
          // the isOpen state changes due to mouseup events which is quite handy.


          if (key === 'type') {
            return;
          }

          nextFullState[key] = newStateToSet[key]; // if it's coming from props, then we don't care to set it internally

          if (!_this4.isControlledProp(key)) {
            nextState[key] = newStateToSet[key];
          }
        }); // if stateToSet is a function, then we weren't able to call onInputValueChange
        // earlier, so we'll call it now that we know what the inputValue state will be.

        if (isStateToSetFunction && newStateToSet.hasOwnProperty('inputValue')) {
          _this4.props.onInputValueChange(newStateToSet.inputValue, _extends$2({}, _this4.getStateAndHelpers(), newStateToSet));
        }

        return nextState;
      }, function () {
        // call the provided callback if it's a callback
        cbToCb(cb)(); // only call the onStateChange and onChange callbacks if
        // we have relevant information to pass them.

        var hasMoreStateThanType = Object.keys(onStateChangeArg).length > 1;

        if (hasMoreStateThanType) {
          _this4.props.onStateChange(onStateChangeArg, _this4.getStateAndHelpers());
        }

        if (isItemSelected) {
          _this4.props.onSelect(stateToSet.selectedItem, _this4.getStateAndHelpers());
        }

        if (onChangeArg !== undefined) {
          _this4.props.onChange(onChangeArg, _this4.getStateAndHelpers());
        } // this is currently undocumented and therefore subject to change
        // We'll try to not break it, but just be warned.


        _this4.props.onUserAction(onStateChangeArg, _this4.getStateAndHelpers());
      });
    };

    this.rootRef = function (node) {
      return _this4._rootNode = node;
    };

    this.getRootProps = function () {
      var _babelHelpers$extends;

      var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      var _ref3 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
          _ref3$suppressRefErro = _ref3.suppressRefError,
          suppressRefError = _ref3$suppressRefErro === undefined ? false : _ref3$suppressRefErro;

      var _ref2$refKey = _ref2.refKey,
          refKey = _ref2$refKey === undefined ? 'ref' : _ref2$refKey,
          rest = objectWithoutProperties(_ref2, ['refKey']); // this is used in the render to know whether the user has called getRootProps.
      // It uses that to know whether to apply the props automatically

      _this4.getRootProps.called = true;
      _this4.getRootProps.refKey = refKey;
      _this4.getRootProps.suppressRefError = suppressRefError;
      return _extends$2((_babelHelpers$extends = {}, _babelHelpers$extends[refKey] = _this4.rootRef, _babelHelpers$extends), rest);
    };

    this.keyDownHandlers = {
      ArrowDown: function ArrowDown(event) {
        event.preventDefault();
        var amount = event.shiftKey ? 5 : 1;
        this.moveHighlightedIndex(amount, {
          type: Downshift.stateChangeTypes.keyDownArrowDown
        });
      },
      ArrowUp: function ArrowUp(event) {
        event.preventDefault();
        var amount = event.shiftKey ? -5 : -1;
        this.moveHighlightedIndex(amount, {
          type: Downshift.stateChangeTypes.keyDownArrowUp
        });
      },
      Enter: function Enter(event) {
        if (this.getState().isOpen) {
          event.preventDefault();
          var itemIndex = this.getState().highlightedIndex;
          var item = this.items[itemIndex];
          var itemNode = this.getItemNodeFromIndex(itemIndex);

          if (item == null || itemNode && itemNode.hasAttribute('disabled')) {
            return;
          }

          this.selectHighlightedItem({
            type: Downshift.stateChangeTypes.keyDownEnter
          });
        }
      },
      Escape: function Escape(event) {
        event.preventDefault();
        this.reset({
          type: Downshift.stateChangeTypes.keyDownEscape
        });
      }
    };
    this.buttonKeyDownHandlers = _extends$2({}, this.keyDownHandlers, {
      ' ': function _(event) {
        event.preventDefault();
        this.toggleMenu({
          type: Downshift.stateChangeTypes.keyDownSpaceButton
        });
      }
    });

    this.getToggleButtonProps = function () {
      var _ref4 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      var onClick = _ref4.onClick,
          onKeyDown = _ref4.onKeyDown,
          onBlur = _ref4.onBlur,
          rest = objectWithoutProperties(_ref4, ['onClick', 'onKeyDown', 'onBlur']);

      var _getState3 = _this4.getState(),
          isOpen = _getState3.isOpen;

      var enabledEventHandlers = {
        onClick: composeEventHandlers(onClick, _this4.button_handleClick),
        onKeyDown: composeEventHandlers(onKeyDown, _this4.button_handleKeyDown),
        onBlur: composeEventHandlers(onBlur, _this4.button_handleBlur)
      };
      var eventHandlers = rest.disabled ? {} : enabledEventHandlers;
      return _extends$2({
        type: 'button',
        role: 'button',
        'aria-label': isOpen ? 'close menu' : 'open menu',
        'aria-expanded': isOpen,
        'aria-haspopup': true,
        'data-toggle': true
      }, eventHandlers, rest);
    };

    this.getButtonProps = this.getToggleButtonProps;

    this.button_handleKeyDown = function (event) {
      var key = normalizeArrowKey(event);

      if (_this4.buttonKeyDownHandlers[key]) {
        _this4.buttonKeyDownHandlers[key].call(_this4, event);
      }
    };

    this.button_handleClick = function (event) {
      event.preventDefault(); // handle odd case for Safari and Firefox which
      // don't give the button the focus properly.

      /* istanbul ignore if (can't reasonably test this) */

      if (_this4.props.environment.document.activeElement === _this4.props.environment.document.body) {
        event.target.focus();
      } // to simplify testing components that use downshift, we'll not wrap this in a setTimeout
      // if the NODE_ENV is test. With the proper build system, this should be dead code eliminated
      // when building for production and should therefore have no impact on production code.


      {
        // Ensure that toggle of menu occurs after the potential blur event in iOS
        setTimeout(function () {
          return _this4.toggleMenu({
            type: Downshift.stateChangeTypes.clickButton
          });
        });
      }
    };

    this.button_handleBlur = function (event) {
      var blurTarget = event.target; // Save blur target for comparison with activeElement later
      // Need setTimeout, so that when the user presses Tab, the activeElement is the next focused element, not body element

      setTimeout(function () {
        if (!_this4.isMouseDown && (_this4.props.environment.document.activeElement == null || _this4.props.environment.document.activeElement.id !== _this4.inputId) && _this4.props.environment.document.activeElement !== blurTarget // Do nothing if we refocus the same element again (to solve issue in Safari on iOS)
        ) {
            _this4.reset({
              type: Downshift.stateChangeTypes.blurButton
            });
          }
      });
    };

    this.getLabelProps = function () {
      var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      _this4.getLabelProps.called = true;

      if (_this4.getInputProps.called && props.htmlFor && props.htmlFor !== _this4.inputId) {
        throw new Error('downshift: You provided the htmlFor of "' + props.htmlFor + '" for your label, but the id of your input is "' + _this4.inputId + '". You must either remove the id from your input or set the htmlFor of the label equal to the input id.');
      }

      _this4.inputId = firstDefined(_this4.inputId, props.htmlFor, _this4.id + '-input');
      return _extends$2({}, props, {
        htmlFor: _this4.inputId
      });
    };

    this.getInputProps = function () {
      var _ref6;

      var _ref5 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      var onKeyDown = _ref5.onKeyDown,
          onBlur = _ref5.onBlur,
          onChange = _ref5.onChange,
          onInput = _ref5.onInput,
          rest = objectWithoutProperties(_ref5, ['onKeyDown', 'onBlur', 'onChange', 'onInput']);
      _this4.getInputProps.called = true;

      if (_this4.getLabelProps.called && rest.id && rest.id !== _this4.inputId) {
        throw new Error('downshift: You provided the id of "' + rest.id + '" for your input, but the htmlFor of your label is "' + _this4.inputId + '". You must either remove the id from your input or set the htmlFor of the label equal to the input id.');
      }

      _this4.inputId = firstDefined(_this4.inputId, rest.id, _this4.id + '-input');
      var onChangeKey = void 0;
      /* istanbul ignore next (preact) */

      onChangeKey = 'onChange';

      var _getState4 = _this4.getState(),
          inputValue = _getState4.inputValue,
          isOpen = _getState4.isOpen,
          highlightedIndex = _getState4.highlightedIndex;

      var eventHandlers = rest.disabled ? {} : (_ref6 = {}, _ref6[onChangeKey] = composeEventHandlers(onChange, onInput, _this4.input_handleChange), _ref6.onKeyDown = composeEventHandlers(onKeyDown, _this4.input_handleKeyDown), _ref6.onBlur = composeEventHandlers(onBlur, _this4.input_handleBlur), _ref6);
      return _extends$2({
        role: 'combobox',
        'aria-autocomplete': 'list',
        'aria-expanded': isOpen,
        'aria-activedescendant': isOpen && typeof highlightedIndex === 'number' && highlightedIndex >= 0 ? _this4.getItemId(highlightedIndex) : null,
        autoComplete: 'off',
        value: inputValue
      }, eventHandlers, rest, {
        id: _this4.inputId
      });
    };

    this.input_handleKeyDown = function (event) {
      var key = normalizeArrowKey(event);

      if (key && _this4.keyDownHandlers[key]) {
        _this4.keyDownHandlers[key].call(_this4, event);
      }
    };

    this.input_handleChange = function (event) {
      _this4.internalSetState({
        type: Downshift.stateChangeTypes.changeInput,
        isOpen: true,
        inputValue: event.target.value
      });
    };

    this.input_handleBlur = function () {
      // Need setTimeout, so that when the user presses Tab, the activeElement is the next focused element, not the body element
      setTimeout(function () {
        var downshiftButtonIsActive = _this4.props.environment.document.activeElement.dataset.toggle && _this4._rootNode && _this4._rootNode.contains(_this4.props.environment.document.activeElement);

        if (!_this4.isMouseDown && !downshiftButtonIsActive) {
          _this4.reset({
            type: Downshift.stateChangeTypes.blurInput
          });
        }
      });
    };

    this.getItemProps = function () {
      var _enabledEventHandlers;

      var _ref7 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      var onMouseMove = _ref7.onMouseMove,
          onMouseDown = _ref7.onMouseDown,
          onClick = _ref7.onClick,
          index = _ref7.index,
          _ref7$item = _ref7.item,
          item = _ref7$item === undefined ? requiredProp('getItemProps', 'item') : _ref7$item,
          rest = objectWithoutProperties(_ref7, ['onMouseMove', 'onMouseDown', 'onClick', 'index', 'item']);

      if (index === undefined) {
        _this4.items.push(item);

        index = _this4.items.indexOf(item);
      } else {
        _this4.items[index] = item;
      }

      var onSelectKey = 'onClick';
      var enabledEventHandlers = (_enabledEventHandlers = {
        // onMouseMove is used over onMouseEnter here. onMouseMove
        // is only triggered on actual mouse movement while onMouseEnter
        // can fire on DOM changes, interrupting keyboard navigation
        onMouseMove: composeEventHandlers(onMouseMove, function () {
          if (index === _this4.getState().highlightedIndex) {
            return;
          }

          _this4.setHighlightedIndex(index, {
            type: Downshift.stateChangeTypes.itemMouseEnter
          }); // We never want to manually scroll when changing state based
          // on `onMouseMove` because we will be moving the element out
          // from under the user which is currently scrolling/moving the
          // cursor


          _this4.avoidScrolling = true;
          setTimeout(function () {
            return _this4.avoidScrolling = false;
          }, 250);
        }),
        onMouseDown: composeEventHandlers(onMouseDown, function (event) {
          // This prevents the activeElement from being changed
          // to the item so it can remain with the current activeElement
          // which is a more common use case.
          event.preventDefault();
        })
      }, _enabledEventHandlers[onSelectKey] = composeEventHandlers(onClick, function () {
        _this4.selectItemAtIndex(index, {
          type: Downshift.stateChangeTypes.clickItem
        });
      }), _enabledEventHandlers);
      var eventHandlers = rest.disabled ? {} : enabledEventHandlers;
      return _extends$2({
        id: _this4.getItemId(index)
      }, eventHandlers, rest);
    };

    this.clearItems = function () {
      _this4.items = [];
    };

    this.reset = function () {
      var otherStateToSet = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var cb = arguments[1];
      otherStateToSet = pickState(otherStateToSet);

      _this4.internalSetState(function (_ref8) {
        var selectedItem = _ref8.selectedItem;
        return _extends$2({
          isOpen: false,
          highlightedIndex: _this4.props.defaultHighlightedIndex,
          inputValue: _this4.props.itemToString(selectedItem)
        }, otherStateToSet);
      }, cbToCb(cb));
    };

    this.toggleMenu = function () {
      var otherStateToSet = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var cb = arguments[1];
      otherStateToSet = pickState(otherStateToSet);

      _this4.internalSetState(function (_ref9) {
        var isOpen = _ref9.isOpen;
        return _extends$2({
          isOpen: !isOpen
        }, otherStateToSet);
      }, function () {
        var _getState5 = _this4.getState(),
            isOpen = _getState5.isOpen;

        if (isOpen) {
          // highlight default index
          _this4.setHighlightedIndex(undefined, otherStateToSet);
        }

        cbToCb(cb)();
      });
    };

    this.openMenu = function (cb) {
      _this4.internalSetState({
        isOpen: true
      }, cbToCb(cb));
    };

    this.closeMenu = function (cb) {
      _this4.internalSetState({
        isOpen: false
      }, cbToCb(cb));
    };

    this.updateStatus = debounce$1(function () {
      if (!_this4._isMounted) {
        return;
      }

      var state = _this4.getState();

      var item = _this4.items[state.highlightedIndex];

      var resultCount = _this4.getItemCount();

      var status = _this4.props.getA11yStatusMessage(_extends$2({
        itemToString: _this4.props.itemToString,
        previousResultCount: _this4.previousResultCount,
        resultCount: resultCount,
        highlightedItem: item
      }, state));

      _this4.previousResultCount = resultCount;
      /* istanbul ignore else (react-native) */

      setStatus(status);
    }, 200);
  };

   Downshift.propTypes = {
    children: PropTypes__default.func,
    render: PropTypes__default.func,
    defaultHighlightedIndex: PropTypes__default.number,
    defaultSelectedItem: PropTypes__default.any,
    defaultInputValue: PropTypes__default.string,
    defaultIsOpen: PropTypes__default.bool,
    getA11yStatusMessage: PropTypes__default.func,
    itemToString: PropTypes__default.func,
    onChange: PropTypes__default.func,
    onSelect: PropTypes__default.func,
    onStateChange: PropTypes__default.func,
    onInputValueChange: PropTypes__default.func,
    onUserAction: PropTypes__default.func,
    onOuterClick: PropTypes__default.func,
    selectedItemChanged: PropTypes__default.func,
    stateReducer: PropTypes__default.func,
    itemCount: PropTypes__default.number,
    id: PropTypes__default.string,
    environment: PropTypes__default.shape({
      addEventListener: PropTypes__default.func,
      removeEventListener: PropTypes__default.func,
      document: PropTypes__default.shape({
        getElementById: PropTypes__default.func,
        activeElement: PropTypes__default.any,
        body: PropTypes__default.any
      })
    }),
    // things we keep in state for uncontrolled components
    // but can accept as props for controlled components

    /* eslint-disable react/no-unused-prop-types */
    selectedItem: PropTypes__default.any,
    isOpen: PropTypes__default.bool,
    inputValue: PropTypes__default.string,
    highlightedIndex: PropTypes__default.number,
    breakingChanges: PropTypes__default.shape({
      resetInputOnSelection: PropTypes__default.bool
    })
    /* eslint-enable */

  } ;

  function validateGetRootPropsCalledCorrectly(element, _ref) {
    var refKey = _ref.refKey;
    var refKeySpecified = refKey !== 'ref';
    var isComposite = !isDOMElement(element);

    if (isComposite && !refKeySpecified) {
      throw new Error('downshift: You returned a non-DOM element. You must specify a refKey in getRootProps');
    } else if (!isComposite && refKeySpecified) {
      throw new Error('downshift: You returned a DOM element. You should not specify a refKey in getRootProps. You specified "' + refKey + '"');
    }

    if (!getElementProps(element)[refKey]) {
      throw new Error('downshift: You must apply the ref prop "' + refKey + '" from getRootProps onto your root element.');
    }
  }
  /*
   * Fix importing in typescript after rollup compilation
   * https://github.com/rollup/rollup/issues/1156
   * https://github.com/Microsoft/TypeScript/issues/13017#issuecomment-268657860
   */


  Downshift.default = Downshift;
  Downshift.resetIdCounter = resetIdCounter;

  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */
  var ListBoxType = PropTypes__default.oneOf(['default', 'inline']);

  var prefix$h = settings_1.prefix;

  var handleOnKeyDown = function handleOnKeyDown(event) {
    if (event.keyCode === 27) {
      event.stopPropagation();
    }
  };

  var handleClick = function handleClick(event) {
    event.preventDefault();
    event.stopPropagation();
  };
  /**
   * `ListBox` is a generic container component that handles creating the
   * container class name in response to certain props.
   */


  var ListBox = function ListBox(_ref) {
    var _cx;

    var children = _ref.children,
        containerClassName = _ref.className,
        disabled = _ref.disabled,
        innerRef = _ref.innerRef,
        type = _ref.type,
        invalid = _ref.invalid,
        invalidText = _ref.invalidText,
        light = _ref.light,
        isOpen = _ref.isOpen,
        rest = _objectWithoutProperties(_ref, ["children", "className", "disabled", "innerRef", "type", "invalid", "invalidText", "light", "isOpen"]);

    var className = classNames((_cx = {}, _defineProperty(_cx, containerClassName, !!containerClassName), _defineProperty(_cx, "".concat(prefix$h, "--list-box"), true), _defineProperty(_cx, "".concat(prefix$h, "--list-box--inline"), type === 'inline'), _defineProperty(_cx, "".concat(prefix$h, "--list-box--disabled"), disabled), _defineProperty(_cx, "".concat(prefix$h, "--list-box--light"), light), _defineProperty(_cx, "".concat(prefix$h, "--list-box--expanded"), isOpen), _cx));
    return React__default.createElement(React__default.Fragment, null, React__default.createElement("div", _extends({}, rest, {
      role: "listbox",
      tabIndex: "-1",
      className: className,
      ref: innerRef,
      onKeyDown: handleOnKeyDown,
      onClick: handleClick,
      "data-invalid": invalid || undefined
    }), children), invalid ? React__default.createElement("div", {
      className: "".concat(prefix$h, "--form-requirement")
    }, invalidText) : null);
  };

  ListBox.propTypes = {
    /**
     * Provide the contents of your ListBox
     */
    children: PropTypes__default.node,

    /**
     * Specify a class name to be applied on the containing list box node
     */
    className: PropTypes__default.string,

    /**
     * `innerRef` hook used for libraries like Downshift that require a reference
     * on a container node when it is not a native element
     */
    innerRef: PropTypes__default.func.isRequired,

    /**
     * Specify whether the ListBox is currently disabled
     */
    disabled: PropTypes__default.bool.isRequired,

    /**
     * Specify the "type" of the ListBox. Currently supports either `default` or
     * `inline` as an option.
     */
    type: ListBoxType.isRequired
  };
  ListBox.defaultProps = {
    innerRef: function innerRef() {},
    disabled: false,
    type: 'default'
  };

  var _defaultTranslations;
  var prefix$i = settings_1.prefix;
  var translationIds = {
    'close.menu': 'close.menu',
    'open.menu': 'open.menu'
  };
  var defaultTranslations = (_defaultTranslations = {}, _defineProperty(_defaultTranslations, translationIds['close.menu'], 'Close menu'), _defineProperty(_defaultTranslations, translationIds['open.menu'], 'Open menu'), _defaultTranslations);
  /**
   * `ListBoxField` is responsible for creating the containing node for valid
   * elements inside of a field. It also provides a11y-related attributes like
   * `role` to make sure a user can focus the given field.
   */

  var ListBoxField = function ListBoxField(_ref) {
    var children = _ref.children,
        id = _ref.id,
        disabled = _ref.disabled,
        tabIndex = _ref.tabIndex,
        t = _ref.translateWithId,
        rest = _objectWithoutProperties(_ref, ["children", "id", "disabled", "tabIndex", "translateWithId"]);

    return React__default.createElement("div", _extends({
      role: rest['aria-expanded'] ? 'combobox' : rest.role || 'combobox',
      "aria-owns": rest['aria-expanded'] && "".concat(id, "__menu") || null,
      "aria-controls": rest['aria-expanded'] && "".concat(id, "__menu") || null,
      className: "".concat(prefix$i, "--list-box__field"),
      tabIndex: !disabled && tabIndex || -1
    }, rest, {
      "aria-label": rest['aria-expanded'] ? t('close.menu') : t('open.menu')
    }), children);
  };

  ListBoxField.propTypes = {
    /**
     * Provide the contents of your ListBoxField
     */
    children: PropTypes__default.node,

    /**
     * Specify a custom `id`
     */
    id: PropTypes__default.string.isRequired,

    /**
     * Specify if the parent <ListBox> is disabled
     */
    disabled: PropTypes__default.bool,

    /**
     * Optional prop to specify the tabIndex of the <ListBox> trigger button
     */
    tabIndex: PropTypes__default.oneOfType([PropTypes__default.number, PropTypes__default.string]),

    /**
     * i18n hook used to provide the appropriate description for the given menu
     * icon. This function takes in an id defined in `translationIds` and should
     * return a string message for that given message id.
     */
    translateWithId: PropTypes__default.func.isRequired
  };
  ListBoxField.defaultProps = {
    translateWithId: function translateWithId(id) {
      return defaultTranslations[id];
    }
  };

  var prefix$j = settings_1.prefix;
  /**
   * `ListBoxMenuItem` is a helper component for managing the container class
   * name, alongside any classes for any corresponding states, for a generic list
   * box menu item.
   */

  var ListBoxMenuItem = function ListBoxMenuItem(_ref) {
    var _cx;

    var children = _ref.children,
        isActive = _ref.isActive,
        isHighlighted = _ref.isHighlighted,
        rest = _objectWithoutProperties(_ref, ["children", "isActive", "isHighlighted"]);

    var className = classNames((_cx = {}, _defineProperty(_cx, "".concat(prefix$j, "--list-box__menu-item"), true), _defineProperty(_cx, "".concat(prefix$j, "--list-box__menu-item--active"), isActive), _defineProperty(_cx, "".concat(prefix$j, "--list-box__menu-item--highlighted"), isHighlighted), _cx));
    return React__default.createElement("div", _extends({
      className: className
    }, rest), React__default.createElement("div", {
      className: "".concat(prefix$j, "--list-box__menu-item__option")
    }, children));
  };

  ListBoxMenuItem.propTypes = {
    /**
     * Specify any children nodes that hsould be rendered inside of the ListBox
     * Menu Item
     */
    children: PropTypes__default.node,

    /**
     * Specify whether the current menu item is "active".
     */
    isActive: PropTypes__default.bool.isRequired,

    /**
     * Specify whether the current menu item is "highlighed".
     */
    isHighlighted: PropTypes__default.bool.isRequired
  };
  ListBoxMenuItem.defaultProps = {
    isActive: false,
    isHighlighted: false
  };

  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */

  /**
   * `createChainableTypeChecker` is used inside of our custom prop validators to
   * add in chaining `isRequired` on a given prop validator.
   */
  var createChainableTypeChecker = function createChainableTypeChecker(validate) {
    // `checkType` is borrowed heavily from the `prop-types` package
    var checkType = function checkType(isRequired, props, propName, componentName, location) {
      if (props[propName] == null) {
        if (isRequired) {
          if (props[propName] === null) {
            return new Error("The ".concat(location, " `").concat(propName, "` is marked as required in ") + "".concat(componentName, ", but its value is `null`."));
          }

          return new Error("The ".concat(location, " `").concat(propName, "` is marked as required in ") + "".concat(componentName, ", but its value is `undefined`."));
        }

        return null;
      } else {
        return validate(props, propName, componentName, location);
      }
    }; // By default, the validator will have `isRequired` set to false. However, we
    // also define the `isRequired` property on the validtor so that consumers can
    // chain their prop validator and assert that the property is required.


    var chainedCheckType = checkType.bind(null, false);
    chainedCheckType.isRequired = checkType.bind(null, true);
    return chainedCheckType;
  };

  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */
  var cachedDisplayNames = new WeakMap();
  /**
   * `getDisplayName` is a utility function for getting a name from a given
   * component type. It supports names from React elements, Stateless Functional
   * Components, and Class-based Components
   */

  var getDisplayName = function getDisplayName(type) {
    if (typeof type === 'string') {
      return type;
    }

    if (cachedDisplayNames.has(type)) {
      return cachedDisplayNames.get(type);
    }

    var displayName;

    if (typeof type.displayName === 'string') {
      displayName = type.displayName;
    }

    if (!displayName) {
      displayName = type.name || 'Unknown';
    }

    cachedDisplayNames.set(type, displayName);
    return displayName;
  };

  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */
  /**
   * `childrenOfType` is used for asserting that children of a given React
   * component are only of a given type. Currently, this supports React elements,
   * Stateless Functional Components, and Class-based components.
   *
   * This prop validator also supports chaining through `isRequired`
   */

  var childrenOfType = function childrenOfType(expectedChildType) {
    var expectedDisplayName = getDisplayName( // Support both React elements and components by using `type` if it exists
    expectedChildType.type || expectedChildType);

    var validate = function validate(props, propName, componentName) {
      React.Children.forEach(props[propName], function (child) {
        var childDisplayName = getDisplayName(child.type);

        if (child.type !== expectedChildType.type && child.type !== expectedChildType) {
          throw new Error("Invalid prop `children` of type `".concat(childDisplayName, "` ") + "supplied to `".concat(componentName, "`, expected each child to be a ") + "`".concat(expectedDisplayName, "` component."));
        }
      });
    };

    return createChainableTypeChecker(validate);
  };

  var prefix$k = settings_1.prefix;
  /**
   * `ListBoxMenu` is a simple container node that isolates the `list-box__menu`
   * class into a single component. It is also being used to validate given
   * `children` components.
   */

  var ListBoxMenu = function ListBoxMenu(_ref) {
    var children = _ref.children,
        id = _ref.id,
        rest = _objectWithoutProperties(_ref, ["children", "id"]);

    return React__default.createElement("div", _extends({
      id: "".concat(id, "__menu"),
      className: "".concat(prefix$k, "--list-box__menu"),
      role: "listbox"
    }, rest), children);
  };

  ListBoxMenu.propTypes = {
    /**
     * Provide the contents of your ListBoxMenu
     */
    children: childrenOfType(ListBoxMenuItem),

    /**
     * Specify a custom `id`
     */
    id: PropTypes__default.string.isRequired
  };

  var _defaultTranslations$1;
  var prefix$l = settings_1.prefix;
  var translationIds$1 = {
    'close.menu': 'close.menu',
    'open.menu': 'open.menu'
  };
  var defaultTranslations$1 = (_defaultTranslations$1 = {}, _defineProperty(_defaultTranslations$1, translationIds$1['close.menu'], 'Close menu'), _defineProperty(_defaultTranslations$1, translationIds$1['open.menu'], 'Open menu'), _defaultTranslations$1);
  /**
   * `ListBoxMenuIcon` is used to orient the icon up or down depending on the
   * state of the menu for a given `ListBox`
   */

  var ListBoxMenuIcon = function ListBoxMenuIcon(_ref) {
    var isOpen = _ref.isOpen,
        t = _ref.translateWithId;
    var className = classNames("".concat(prefix$l, "--list-box__menu-icon"), _defineProperty({}, "".concat(prefix$l, "--list-box__menu-icon--open"), isOpen));
    var description = isOpen ? t('close.menu') : t('open.menu');
    return React__default.createElement("div", {
      className: className
    }, React__default.createElement(ChevronDown16, {
      name: "chevron--down",
      "aria-label": description
    }, React__default.createElement("title", null, description)));
  };

  ListBoxMenuIcon.propTypes = {
    /**
     * Specify whether the menu is currently open, which will influence the
     * direction of the menu icon
     */
    isOpen: PropTypes__default.bool.isRequired,

    /**
     * i18n hook used to provide the appropriate description for the given menu
     * icon. This function takes in an id defined in `translationIds` and should
     * return a string message for that given message id.
     */
    translateWithId: PropTypes__default.func.isRequired
  };
  ListBoxMenuIcon.defaultProps = {
    translateWithId: function translateWithId(id) {
      return defaultTranslations$1[id];
    }
  };

  var _defaultTranslations$2;
  var prefix$m = settings_1.prefix;
  /**
   * `ListBoxSelection` is used to provide controls for clearing a selection, in
   * addition to conditionally rendering a badge if the control has more than one
   * selection.
   */

  var ListBoxSelection = function ListBoxSelection(_ref) {
    var _cx;

    var clearSelection = _ref.clearSelection,
        selectionCount = _ref.selectionCount,
        t = _ref.translateWithId;
    var className = classNames("".concat(prefix$m, "--list-box__selection"), (_cx = {}, _defineProperty(_cx, "".concat(prefix$m, "--tag--filter"), selectionCount), _defineProperty(_cx, "".concat(prefix$m, "--list-box__selection--multi"), selectionCount), _cx));

    var handleOnClick = function handleOnClick(event) {
      event.stopPropagation();
      clearSelection(event);
    };

    var handleOnKeyDown = function handleOnKeyDown(event) {
      event.stopPropagation(); // When a user hits ENTER, we'll clear the selection

      if (event.keyCode === 13) {
        clearSelection(event);
      }
    };

    var description = selectionCount ? t('clear.all') : t('clear.selection');
    return React__default.createElement("div", {
      role: "button",
      className: className,
      tabIndex: "0",
      onClick: handleOnClick,
      onKeyDown: handleOnKeyDown,
      title: description
    }, selectionCount, React__default.createElement(Close16, {
      role: "img"
    }));
  };

  var translationIds$2 = {
    'clear.all': 'clear.all',
    'clear.selection': 'clear.selection'
  };
  var defaultTranslations$2 = (_defaultTranslations$2 = {}, _defineProperty(_defaultTranslations$2, translationIds$2['clear.all'], 'Clear all selected items'), _defineProperty(_defaultTranslations$2, translationIds$2['clear.selection'], 'Clear selected item'), _defaultTranslations$2);
  ListBoxSelection.propTypes = {
    /**
     * Specify a function to be invoked when a user interacts with the clear
     * selection element.
     */
    clearSelection: PropTypes__default.func.isRequired,

    /**
     * Specify an optional `selectionCount` value that will be used to determine
     * whether the selection should display a badge or a single clear icon.
     */
    selectionCount: PropTypes__default.number,

    /**
     * i18n hook used to provide the appropriate description for the given menu
     * icon. This function takes in an id defined in `translationIds` and should
     * return a string message for that given message id.
     */
    translateWithId: PropTypes__default.func.isRequired
  };
  ListBoxSelection.defaultProps = {
    translateWithId: function translateWithId(id) {
      return defaultTranslations$2[id];
    }
  };

  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */
  ListBox.Field = ListBoxField;
  ListBox.Menu = ListBoxMenu;
  ListBox.MenuIcon = ListBoxMenuIcon;
  ListBox.MenuItem = ListBoxMenuItem;
  ListBox.Selection = ListBoxSelection;

  var prefix$n = settings_1.prefix;

  var defaultItemToString = function defaultItemToString(item) {
    if (typeof item === 'string') {
      return item;
    }

    return item && item.label;
  };

  var defaultShouldFilterItem = function defaultShouldFilterItem() {
    return true;
  };

  var getInputValue = function getInputValue(props, state) {
    if (props.initialSelectedItem) {
      return props.itemToString(props.initialSelectedItem);
    }

    return state.inputValue || '';
  };

  var findHighlightedIndex = function findHighlightedIndex(_ref, inputValue) {
    var items = _ref.items,
        itemToString = _ref.itemToString;

    if (!inputValue) {
      return -1;
    }

    var searchValue = inputValue.toLowerCase();

    for (var i = 0; i < items.length; i++) {
      var item = itemToString(items[i]).toLowerCase();

      if (item.indexOf(searchValue) !== -1) {
        return i;
      }
    }

    return -1;
  };

  var ComboBox =
  /*#__PURE__*/
  function (_React$Component) {
    _inherits(ComboBox, _React$Component);

    function ComboBox(props) {
      var _this;

      _classCallCheck(this, ComboBox);

      _this = _possibleConstructorReturn(this, _getPrototypeOf(ComboBox).call(this, props));

      _defineProperty(_assertThisInitialized(_this), "filterItems", function (items, itemToString, inputValue) {
        return items.filter(function (item) {
          return _this.props.shouldFilterItem({
            item: item,
            itemToString: itemToString,
            inputValue: inputValue
          });
        });
      });

      _defineProperty(_assertThisInitialized(_this), "handleOnChange", function (selectedItem) {
        if (_this.props.onChange) {
          _this.props.onChange({
            selectedItem: selectedItem
          });
        }
      });

      _defineProperty(_assertThisInitialized(_this), "handleOnInputKeyDown", function (event) {
        event.stopPropagation();
      });

      _defineProperty(_assertThisInitialized(_this), "handleOnStateChange", function (newState, _ref2) {
        var setHighlightedIndex = _ref2.setHighlightedIndex;

        if (Object.prototype.hasOwnProperty.call(newState, 'inputValue')) {
          var inputValue = newState.inputValue;
          var onInputChange = _this.props.onInputChange;
          setHighlightedIndex(findHighlightedIndex(_this.props, inputValue));

          _this.setState(function () {
            return {
              // Default to empty string if we have a false-y `inputValue`
              inputValue: inputValue || ''
            };
          }, function () {
            if (onInputChange) {
              onInputChange(inputValue);
            }
          });
        }
      });

      _defineProperty(_assertThisInitialized(_this), "onToggleClick", function (isOpen) {
        return function (event) {
          if (event.target === _this.textInput.current && isOpen) {
            event.preventDownshiftDefault = true;
            event.persist();
          }
        };
      });

      _this.textInput = React__default.createRef();
      _this.state = {
        inputValue: getInputValue(props, {})
      };
      return _this;
    }

    _createClass(ComboBox, [{
      key: "UNSAFE_componentWillReceiveProps",
      value: function UNSAFE_componentWillReceiveProps(nextProps) {
        this.setState(function (state) {
          return {
            inputValue: getInputValue(nextProps, state)
          };
        });
      }
    }, {
      key: "render",
      value: function render() {
        var _this2 = this;

        var _this$props = this.props,
            containerClassName = _this$props.className,
            disabled = _this$props.disabled,
            id = _this$props.id,
            items = _this$props.items,
            itemToString = _this$props.itemToString,
            itemToElement = _this$props.itemToElement,
            titleText = _this$props.titleText,
            helperText = _this$props.helperText,
            placeholder = _this$props.placeholder,
            initialSelectedItem = _this$props.initialSelectedItem,
            ariaLabel = _this$props.ariaLabel,
            translateWithId = _this$props.translateWithId,
            invalid = _this$props.invalid,
            invalidText = _this$props.invalidText,
            light = _this$props.light,
            type = _this$props.type,
            shouldFilterItem = _this$props.shouldFilterItem,
            onChange = _this$props.onChange,
            onInputChange = _this$props.onInputChange,
            downshiftProps = _this$props.downshiftProps,
            rest = _objectWithoutProperties(_this$props, ["className", "disabled", "id", "items", "itemToString", "itemToElement", "titleText", "helperText", "placeholder", "initialSelectedItem", "ariaLabel", "translateWithId", "invalid", "invalidText", "light", "type", "shouldFilterItem", "onChange", "onInputChange", "downshiftProps"]);

        var className = classNames("".concat(prefix$n, "--combo-box"), containerClassName);
        var titleClasses = classNames("".concat(prefix$n, "--label"), _defineProperty({}, "".concat(prefix$n, "--label--disabled"), disabled));
        var title = titleText ? React__default.createElement("label", {
          htmlFor: id,
          className: titleClasses
        }, titleText) : null;
        var helperClasses = classNames("".concat(prefix$n, "--form__helper-text"), _defineProperty({}, "".concat(prefix$n, "--form__helper-text--disabled"), disabled));
        var helper = helperText ? React__default.createElement("div", {
          className: helperClasses
        }, helperText) : null;
        var wrapperClasses = classNames("".concat(prefix$n, "--list-box__wrapper")); // needs to be Capitalized for react to render it correctly

        var ItemToElement = itemToElement;
        var input = React__default.createElement(Downshift, _extends({}, downshiftProps, {
          onChange: this.handleOnChange,
          onStateChange: this.handleOnStateChange,
          inputValue: this.state.inputValue || '',
          itemToString: itemToString,
          defaultSelectedItem: initialSelectedItem
        }), function (_ref3) {
          var getButtonProps = _ref3.getButtonProps,
              getInputProps = _ref3.getInputProps,
              getItemProps = _ref3.getItemProps,
              getRootProps = _ref3.getRootProps,
              isOpen = _ref3.isOpen,
              inputValue = _ref3.inputValue,
              selectedItem = _ref3.selectedItem,
              highlightedIndex = _ref3.highlightedIndex,
              clearSelection = _ref3.clearSelection;
          return React__default.createElement(ListBox, _extends({
            className: className,
            disabled: disabled,
            invalid: invalid,
            invalidText: invalidText,
            isOpen: isOpen,
            light: light
          }, getRootProps({
            refKey: 'innerRef'
          })), React__default.createElement(ListBox.Field, _extends({
            id: id,
            disabled: disabled,
            translateWithId: translateWithId
          }, getButtonProps({
            disabled: disabled,
            onClick: _this2.onToggleClick(isOpen)
          })), React__default.createElement("input", _extends({
            className: "".concat(prefix$n, "--text-input"),
            "aria-label": ariaLabel,
            "aria-disabled": disabled,
            "aria-controls": "".concat(id, "__menu"),
            "aria-autocomplete": "list",
            ref: _this2.textInput
          }, rest, getInputProps({
            disabled: disabled,
            id: id,
            placeholder: placeholder,
            onKeyDown: _this2.handleOnInputKeyDown
          }))), invalid && React__default.createElement(WarningFilled16, {
            className: "".concat(prefix$n, "--list-box__invalid-icon")
          }), inputValue && React__default.createElement(ListBox.Selection, {
            clearSelection: clearSelection,
            translateWithId: translateWithId
          }), React__default.createElement(ListBox.MenuIcon, {
            isOpen: isOpen,
            translateWithId: translateWithId
          })), isOpen && React__default.createElement(ListBox.Menu, {
            "aria-label": ariaLabel,
            id: id
          }, _this2.filterItems(items, itemToString, inputValue).map(function (item, index) {
            return React__default.createElement(ListBox.MenuItem, _extends({
              key: itemToString(item),
              isActive: selectedItem === item,
              isHighlighted: highlightedIndex === index || selectedItem && selectedItem.id === item.id || false
            }, getItemProps({
              item: item,
              index: index
            })), itemToElement ? React__default.createElement(ItemToElement, _extends({
              key: itemToString(item)
            }, item)) : itemToString(item));
          })));
        });
        return React__default.createElement("div", {
          className: wrapperClasses
        }, title, helper, input);
      }
    }]);

    return ComboBox;
  }(React__default.Component);

  _defineProperty(ComboBox, "propTypes", {
    /**
     * 'aria-label' of the ListBox component.
     */
    ariaLabel: PropTypes__default.string,

    /**
     * An optional className to add to the container node
     */
    className: PropTypes__default.string,

    /**
     * Specify if the control should be disabled, or not
     */
    disabled: PropTypes__default.bool,

    /**
     * Specify a custom `id` for the input
     */
    id: PropTypes__default.string.isRequired,

    /**
     * Allow users to pass in an arbitrary item or a string (in case their items are an array of strings)
     * from their collection that are pre-selected
     */
    initialSelectedItem: PropTypes__default.oneOfType([PropTypes__default.object, PropTypes__default.string]),

    /**
     * We try to stay as generic as possible here to allow individuals to pass
     * in a collection of whatever kind of data structure they prefer
     */
    items: PropTypes__default.array.isRequired,

    /**
     * Helper function passed to downshift that allows the library to render a
     * given item to a string label. By default, it extracts the `label` field
     * from a given item to serve as the item label in the list
     */
    itemToString: PropTypes__default.func,

    /**
     * Optional function to render items as custom components instead of strings.
     * Defaults to null and is overriden by a getter
     */
    itemToElement: PropTypes__default.func,

    /**
     * `onChange` is a utility for this controlled component to communicate to a
     * consuming component when a specific dropdown item is selected.
     * @param {{ selectedItem }}
     */
    onChange: PropTypes__default.func.isRequired,

    /**
     * Used to provide a placeholder text node before a user enters any input.
     * This is only present if the control has no items selected
     */
    placeholder: PropTypes__default.string.isRequired,

    /**
     * Specify your own filtering logic by passing in a `shouldFilterItem`
     * function that takes in the current input and an item and passes back
     * whether or not the item should be filtered.
     */
    shouldFilterItem: PropTypes__default.func,

    /**
     * Specify if the currently selected value is invalid.
     */
    invalid: PropTypes__default.bool,

    /**
     * Message which is displayed if the value is invalid.
     */
    invalidText: PropTypes__default.string,

    /**
     * Specify a custom translation function that takes in a message identifier
     * and returns the localized string for the message
     */
    translateWithId: PropTypes__default.func,

    /**
     * Currently supports either the default type, or an inline variant
     */
    type: ListBoxType,

    /**
     * Callback function to notify consumer when the text input changes.
     * This provides support to change available items based on the text.
     * @param {string} inputText
     */
    onInputChange: PropTypes__default.func,

    /**
     * should use "light theme" (white background)?
     */
    light: PropTypes__default.bool,

    /**
     * Additional props passed to Downshift
     */
    downshiftProps: PropTypes__default.shape(Downshift.propTypes)
  });

  _defineProperty(ComboBox, "defaultProps", {
    disabled: false,
    itemToString: defaultItemToString,
    itemToElement: null,
    shouldFilterItem: defaultShouldFilterItem,
    type: 'default',
    ariaLabel: 'Choose an item',
    light: false
  });

  /**
   * Adds or removes a CSS class to an element.
   * @param {Element} element An element.
   * @param {string} name A CSS class name.
   * @param {boolean} add `true` to add the given CSS class to given the element. Otherwise to remove.
   */
  function toggleClass(element, name, add) {
    if (element.classList.contains(name) === !add) {
      element.classList[add ? 'add' : 'remove'](name);
    }
  }

  var prefix$o = settings_1.prefix;

  var ComposedModal =
  /*#__PURE__*/
  function (_Component) {
    _inherits(ComposedModal, _Component);

    function ComposedModal() {
      var _getPrototypeOf2;

      var _this;

      _classCallCheck(this, ComposedModal);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(ComposedModal)).call.apply(_getPrototypeOf2, [this].concat(args)));

      _defineProperty(_assertThisInitialized(_this), "state", {});

      _defineProperty(_assertThisInitialized(_this), "outerModal", React__default.createRef());

      _defineProperty(_assertThisInitialized(_this), "innerModal", React__default.createRef());

      _defineProperty(_assertThisInitialized(_this), "button", React__default.createRef());

      _defineProperty(_assertThisInitialized(_this), "elementOrParentIsFloatingMenu", function (target) {
        var _this$props$selectors = _this.props.selectorsFloatingMenus,
            selectorsFloatingMenus = _this$props$selectors === void 0 ? [".".concat(prefix$o, "--overflow-menu-options"), ".".concat(prefix$o, "--tooltip"), '.flatpickr-calendar'] : _this$props$selectors;

        if (target && typeof target.closest === 'function') {
          return selectorsFloatingMenus.some(function (selector) {
            return target.closest(selector);
          });
        }
      });

      _defineProperty(_assertThisInitialized(_this), "handleKeyDown", function (evt) {
        // Esc key
        if (evt.which === 27) {
          _this.closeModal();
        }

        _this.props.onKeyDown(evt);
      });

      _defineProperty(_assertThisInitialized(_this), "handleClick", function (evt) {
        if (_this.innerModal.current && !_this.innerModal.current.contains(evt.target)) {
          _this.closeModal();
        }
      });

      _defineProperty(_assertThisInitialized(_this), "focusModal", function () {
        if (_this.outerModal.current) {
          _this.outerModal.current.focus();
        }
      });

      _defineProperty(_assertThisInitialized(_this), "handleBlur", function (evt) {
        // Keyboard trap
        if (_this.innerModal.current && _this.props.open && evt.relatedTarget && !_this.innerModal.current.contains(evt.relatedTarget) && !_this.elementOrParentIsFloatingMenu(evt.relatedTarget)) {
          _this.focusModal();
        }
      });

      _defineProperty(_assertThisInitialized(_this), "focusButton", function (focusContainerElement) {
        var primaryFocusElement = focusContainerElement.querySelector(_this.props.selectorPrimaryFocus);

        if (primaryFocusElement) {
          primaryFocusElement.focus();
          return;
        }

        if (_this.button.current) {
          _this.button.current.focus();
        }
      });

      _defineProperty(_assertThisInitialized(_this), "handleTransitionEnd", function (evt) {
        if (_this.outerModal.current.offsetWidth && _this.outerModal.current.offsetHeight && _this.beingOpen) {
          _this.focusButton(evt.currentTarget);

          _this.beingOpen = false;
        }
      });

      _defineProperty(_assertThisInitialized(_this), "closeModal", function () {
        var onClose = _this.props.onClose;

        if (!onClose || onClose() !== false) {
          _this.setState({
            open: false
          });
        }
      });

      return _this;
    }

    _createClass(ComposedModal, [{
      key: "componentDidUpdate",
      value: function componentDidUpdate(prevProps) {
        if (!prevProps.open && this.props.open) {
          this.beingOpen = true;
        } else if (prevProps.open && !this.props.open) {
          this.beingOpen = false;
        }

        toggleClass(document.body, "".concat(prefix$o, "--body--with-modal-open"), this.props.open);
      }
    }, {
      key: "componentDidMount",
      value: function componentDidMount() {
        toggleClass(document.body, "".concat(prefix$o, "--body--with-modal-open"), this.props.open);

        if (!this.props.open) {
          return;
        }

        this.focusButton(this.innerModal.current);
      }
    }, {
      key: "render",
      value: function render() {
        var _classNames,
            _classNames2,
            _this2 = this;

        var open = this.state.open;

        var _this$props = this.props,
            className = _this$props.className,
            containerClassName = _this$props.containerClassName,
            children = _this$props.children,
            danger = _this$props.danger,
            selectorPrimaryFocus = _this$props.selectorPrimaryFocus,
            other = _objectWithoutProperties(_this$props, ["className", "containerClassName", "children", "danger", "selectorPrimaryFocus"]);

        var modalClass = classNames((_classNames = {}, _defineProperty(_classNames, "".concat(prefix$o, "--modal"), true), _defineProperty(_classNames, 'is-visible', open), _defineProperty(_classNames, className, className), _defineProperty(_classNames, "".concat(prefix$o, "--modal--danger"), danger), _classNames));
        var containerClass = classNames((_classNames2 = {}, _defineProperty(_classNames2, "".concat(prefix$o, "--modal-container"), true), _defineProperty(_classNames2, containerClassName, containerClassName), _classNames2));
        var childrenWithProps = React__default.Children.toArray(children).map(function (child) {
          switch (child.type) {
            case ModalHeader:
              return React__default.cloneElement(child, {
                closeModal: _this2.closeModal
              });

            case ModalFooter:
              return React__default.cloneElement(child, {
                closeModal: _this2.closeModal,
                inputref: _this2.button
              });

            default:
              return child;
          }
        });
        return React__default.createElement("div", _extends({}, other, {
          role: "presentation",
          ref: this.outerModal,
          onBlur: this.handleBlur,
          onClick: this.handleClick,
          onKeyDown: this.handleKeyDown,
          onTransitionEnd: open ? this.handleTransitionEnd : undefined,
          className: modalClass,
          tabIndex: -1
        }), React__default.createElement("div", {
          ref: this.innerModal,
          className: containerClass
        }, childrenWithProps));
      }
    }], [{
      key: "getDerivedStateFromProps",
      value: function getDerivedStateFromProps(_ref, state) {
        var open = _ref.open;
        var prevOpen = state.prevOpen;
        return prevOpen === open ? null : {
          open: open,
          prevOpen: open
        };
      }
    }]);

    return ComposedModal;
  }(React.Component);

  _defineProperty(ComposedModal, "defaultProps", {
    onKeyDown: function onKeyDown() {},
    selectorPrimaryFocus: '[data-modal-primary-focus]'
  });

  _defineProperty(ComposedModal, "propTypes", {
    /**
     * Specify an optional className to be applied to the modal root node
     */
    className: PropTypes__default.string,

    /**
     * Specify an optional className to be applied to the modal node
     */
    containerClassName: PropTypes__default.string,

    /**
     * Specify an optional handler for closing modal.
     * Returning `false` here prevents closing modal.
     */
    onClose: PropTypes__default.func,

    /**
     * Specify an optional handler for the `onKeyDown` event. Called for all
     * `onKeyDown` events that do not close the modal
     */
    onKeyDown: PropTypes__default.func,

    /**
     * Specify whether the Modal is currently open
     */
    open: PropTypes__default.bool,

    /**
     * Specify a CSS selector that matches the DOM element that should be
     * focused when the Modal opens
     */
    selectorPrimaryFocus: PropTypes__default.string
  });
  var ModalHeader =
  /*#__PURE__*/
  function (_Component2) {
    _inherits(ModalHeader, _Component2);

    function ModalHeader() {
      var _getPrototypeOf3;

      var _this3;

      _classCallCheck(this, ModalHeader);

      for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        args[_key2] = arguments[_key2];
      }

      _this3 = _possibleConstructorReturn(this, (_getPrototypeOf3 = _getPrototypeOf(ModalHeader)).call.apply(_getPrototypeOf3, [this].concat(args)));

      _defineProperty(_assertThisInitialized(_this3), "handleCloseButtonClick", function () {
        _this3.props.closeModal();

        _this3.props.buttonOnClick();
      });

      return _this3;
    }

    _createClass(ModalHeader, [{
      key: "render",
      value: function render() {
        var _classNames3, _classNames4, _classNames5, _classNames6, _classNames7;

        var _this$props2 = this.props,
            className = _this$props2.className,
            labelClassName = _this$props2.labelClassName,
            titleClassName = _this$props2.titleClassName,
            closeClassName = _this$props2.closeClassName,
            closeIconClassName = _this$props2.closeIconClassName,
            label = _this$props2.label,
            title = _this$props2.title,
            children = _this$props2.children,
            iconDescription = _this$props2.iconDescription,
            closeModal = _this$props2.closeModal,
            buttonOnClick = _this$props2.buttonOnClick,
            other = _objectWithoutProperties(_this$props2, ["className", "labelClassName", "titleClassName", "closeClassName", "closeIconClassName", "label", "title", "children", "iconDescription", "closeModal", "buttonOnClick"]);

        var headerClass = classNames((_classNames3 = {}, _defineProperty(_classNames3, "".concat(prefix$o, "--modal-header"), true), _defineProperty(_classNames3, className, className), _classNames3));
        var labelClass = classNames((_classNames4 = {}, _defineProperty(_classNames4, "".concat(prefix$o, "--modal-header__label ").concat(prefix$o, "--type-delta"), true), _defineProperty(_classNames4, labelClassName, labelClassName), _classNames4));
        var titleClass = classNames((_classNames5 = {}, _defineProperty(_classNames5, "".concat(prefix$o, "--modal-header__heading ").concat(prefix$o, "--type-beta"), true), _defineProperty(_classNames5, titleClassName, titleClassName), _classNames5));
        var closeClass = classNames((_classNames6 = {}, _defineProperty(_classNames6, "".concat(prefix$o, "--modal-close"), true), _defineProperty(_classNames6, closeClassName, closeClassName), _classNames6));
        var closeIconClass = classNames((_classNames7 = {}, _defineProperty(_classNames7, "".concat(prefix$o, "--modal-close__icon"), true), _defineProperty(_classNames7, closeIconClassName, closeIconClassName), _classNames7));
        return React__default.createElement("div", _extends({
          className: headerClass
        }, other), label && React__default.createElement("p", {
          className: labelClass
        }, label), title && React__default.createElement("p", {
          className: titleClass
        }, title), children, React__default.createElement("button", {
          onClick: this.handleCloseButtonClick,
          className: closeClass,
          title: iconDescription,
          type: "button"
        }, React__default.createElement(Close20, {
          "aria-label": iconDescription,
          className: closeIconClass
        })));
      }
    }]);

    return ModalHeader;
  }(React.Component);

  _defineProperty(ModalHeader, "propTypes", {
    /**
     * Specify an optional className to be applied to the modal header
     */
    className: PropTypes__default.string,

    /**
     * Specify an optional className to be applied to the modal header label
     */
    labelClassName: PropTypes__default.string,

    /**
     * Specify an optional className to be applied to the modal heading
     */
    titleClassName: PropTypes__default.string,

    /**
     * Specify an optional className to be applied to the modal close node
     */
    closeClassName: PropTypes__default.string,

    /**
     * Specify an optional className to be applied to the modal close icon node
     */
    closeIconClassName: PropTypes__default.string,

    /**
     * Specify an optional label to be displayed
     */
    label: PropTypes__default.node,

    /**
     * Specify an optional title to be displayed
     */
    title: PropTypes__default.node,

    /**
     * Specify the content to be placed in the ModalHeader
     */
    children: PropTypes__default.node,

    /**
     * Specify a description for the close icon that can be read by screen
     * readers
     */
    iconDescription: PropTypes__default.string,

    /**
     * Provide an optional function to be called when the modal is closed
     */
    closeModal: PropTypes__default.func,

    /**
     * Provide an optional function to be called when the close button is
     * clicked
     */
    buttonOnClick: PropTypes__default.func
  });

  _defineProperty(ModalHeader, "defaultProps", {
    iconDescription: 'Close the modal',
    buttonOnClick: function buttonOnClick() {}
  });

  var ModalBody =
  /*#__PURE__*/
  function (_Component3) {
    _inherits(ModalBody, _Component3);

    function ModalBody() {
      _classCallCheck(this, ModalBody);

      return _possibleConstructorReturn(this, _getPrototypeOf(ModalBody).apply(this, arguments));
    }

    _createClass(ModalBody, [{
      key: "render",
      value: function render() {
        var _classNames8;

        var _this$props3 = this.props,
            className = _this$props3.className,
            children = _this$props3.children,
            other = _objectWithoutProperties(_this$props3, ["className", "children"]);

        var contentClass = classNames((_classNames8 = {}, _defineProperty(_classNames8, "".concat(prefix$o, "--modal-content"), true), _defineProperty(_classNames8, className, className), _classNames8));
        return React__default.createElement("div", _extends({
          className: contentClass
        }, other), children);
      }
    }]);

    return ModalBody;
  }(React.Component);

  _defineProperty(ModalBody, "propTypes", {
    /**
     * Specify an optional className to be added to the Modal Body node
     */
    className: PropTypes__default.string
  });

  var ModalFooter =
  /*#__PURE__*/
  function (_Component4) {
    _inherits(ModalFooter, _Component4);

    function ModalFooter() {
      var _getPrototypeOf4;

      var _this4;

      _classCallCheck(this, ModalFooter);

      for (var _len3 = arguments.length, args = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
        args[_key3] = arguments[_key3];
      }

      _this4 = _possibleConstructorReturn(this, (_getPrototypeOf4 = _getPrototypeOf(ModalFooter)).call.apply(_getPrototypeOf4, [this].concat(args)));

      _defineProperty(_assertThisInitialized(_this4), "handleRequestClose", function (evt) {
        _this4.props.closeModal();

        _this4.props.onRequestClose(evt);
      });

      return _this4;
    }

    _createClass(ModalFooter, [{
      key: "render",
      value: function render() {
        var _classNames9;

        var _this$props4 = this.props,
            className = _this$props4.className,
            primaryClassName = _this$props4.primaryClassName,
            secondaryClassName = _this$props4.secondaryClassName,
            secondaryButtonText = _this$props4.secondaryButtonText,
            primaryButtonText = _this$props4.primaryButtonText,
            primaryButtonDisabled = _this$props4.primaryButtonDisabled,
            closeModal = _this$props4.closeModal,
            onRequestClose = _this$props4.onRequestClose,
            onRequestSubmit = _this$props4.onRequestSubmit,
            children = _this$props4.children,
            danger = _this$props4.danger,
            other = _objectWithoutProperties(_this$props4, ["className", "primaryClassName", "secondaryClassName", "secondaryButtonText", "primaryButtonText", "primaryButtonDisabled", "closeModal", "onRequestClose", "onRequestSubmit", "children", "danger"]);

        var footerClass = classNames((_classNames9 = {}, _defineProperty(_classNames9, "".concat(prefix$o, "--modal-footer"), true), _defineProperty(_classNames9, className, className), _classNames9));
        var primaryClass = classNames(_defineProperty({}, primaryClassName, primaryClassName));
        var secondaryClass = classNames(_defineProperty({}, secondaryClassName, secondaryClassName));
        return React__default.createElement("div", _extends({
          className: footerClass
        }, other), secondaryButtonText && React__default.createElement(Button, {
          className: secondaryClass,
          onClick: this.handleRequestClose,
          kind: "secondary"
        }, secondaryButtonText), primaryButtonText && React__default.createElement(Button, {
          onClick: onRequestSubmit,
          className: primaryClass,
          disabled: primaryButtonDisabled,
          kind: danger ? 'danger' : 'primary',
          ref: this.props.inputref
        }, primaryButtonText), children);
      }
    }]);

    return ModalFooter;
  }(React.Component);

  _defineProperty(ModalFooter, "propTypes", {
    /**
     * Specify a custom className to be applied to the Modal Footer container
     */
    className: PropTypes__default.string,

    /**
     * Specify a custom className to be applied to the primary button
     */
    primaryClassName: PropTypes__default.string,

    /**
     * Specify the text for the primary button
     */
    primaryButtonText: PropTypes__default.string,

    /**
     * Specify whether the primary button should be disabled
     */
    primaryButtonDisabled: PropTypes__default.bool,

    /**
     * Specify a custom className to be applied to the secondary button
     */
    secondaryClassName: PropTypes__default.string,

    /**
     * Specify the text for the secondary button
     */
    secondaryButtonText: PropTypes__default.string,

    /**
     * Specify an optional function for when the modal is requesting to be
     * closed
     */
    onRequestClose: PropTypes__default.func,

    /**
     * Specify an optional function for when the modal is requesting to be
     * submitted
     */
    onRequestSubmit: PropTypes__default.func,

    /**
     * Specify an optional function that is called whenever the modal is closed
     */
    closeModal: PropTypes__default.func,

    /**
     * Pass in content that will be rendered in the Modal Footer
     */
    children: PropTypes__default.node
  });

  _defineProperty(ModalFooter, "defaultProps", {
    onRequestClose: function onRequestClose() {},
    onRequestSubmit: function onRequestSubmit() {}
  });

  var prefix$p = settings_1.prefix;
  var Switch = React__default.forwardRef(function Switch(_ref, ref) {
    var _cx;

    var customClassName = _ref.className,
        index = _ref.index,
        onClick = _ref.onClick,
        name = _ref.name,
        _ref$selected = _ref.selected,
        selected = _ref$selected === void 0 ? false : _ref$selected,
        text = _ref.text,
        rest = _objectWithoutProperties(_ref, ["className", "index", "onClick", "name", "selected", "text"]);

    var className = classNames((_cx = {}, _defineProperty(_cx, "".concat(prefix$p, "--content-switcher-btn"), true), _defineProperty(_cx, "".concat(prefix$p, "--content-switcher--selected"), selected), _defineProperty(_cx, customClassName, !!customClassName), _cx));

    function handleOnClick(event) {
      onClick(event, index);
    }

    return React__default.createElement("button", _extends({
      "aria-selected": selected,
      className: className,
      ref: ref,
      role: "tab",
      onClick: handleOnClick,
      tabIndex: selected ? '0' : '-1',
      type: "button"
    }, rest), React__default.createElement("span", {
      className: "".concat(prefix$p, "--content-switcher__label")
    }, text));
  });
  Switch.displayName = 'Switch';
  Switch.propTypes = {
    /**
     * Specify an optional className to be added to your Switch
     */
    className: PropTypes__default.string,

    /**
     * Provide the name of your Switch that is used for event handlers
     */
    name: deprecate(PropTypes__default.oneOfType([PropTypes__default.string, PropTypes__default.number])),

    /**
     * The index of your Switch in your ContentSwitcher that is used for event handlers.
     * Reserved for usage in ContentSwitcher
     */
    index: PropTypes__default.number,

    /**
     * A handler that is invoked when a user clicks on the control.
     */
    onClick: PropTypes__default.func,

    /**
     * A handler that is invoked on the key down event for the control.
     */
    onKeyDown: PropTypes__default.func,

    /**
     * Whether your Switch is selected. Reserved for usage in ContentSwitcher
     */
    selected: PropTypes__default.bool,

    /**
     * Provide the contents of your Switch
     */
    text: PropTypes__default.string.isRequired
  };

  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */

  /**
   * Generic utility to compose event handlers so that consumers can supply their
   * own event listeners on table components. The default heuristic here is to
   * iterate through the given functions until `preventDefault` is called on the
   * given event.
   *
   * @param {Array<Function>} fns array of functions to apply to the event
   * @returns {Function}
   */
  var composeEventHandlers$1 = function composeEventHandlers(fns) {
    return function (event) {
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      for (var i = 0; i < fns.length; i++) {
        if (event.defaultPrevented) {
          break;
        }

        if (typeof fns[i] === 'function') {
          fns[i].apply(fns, [event].concat(args));
        }
      }
    };
  };

  var prefix$q = settings_1.prefix;

  function ContentSwitcher$1(_ref) {
    var children = _ref.children,
        customClassName = _ref.className,
        onChange = _ref.onChange,
        _ref$selectedIndex = _ref.selectedIndex,
        controlledSelectedIndex = _ref$selectedIndex === void 0 ? 0 : _ref$selectedIndex,
        rest = _objectWithoutProperties(_ref, ["children", "className", "onChange", "selectedIndex"]);

    var switchRefs = [];
    var className = classNames("".concat(prefix$q, "--content-switcher"), customClassName);
    var savedOnChange = React.useRef(null);

    var _useState = React.useState(controlledSelectedIndex),
        _useState2 = _slicedToArray(_useState, 2),
        selectedIndex = _useState2[0],
        setSelectedIndex = _useState2[1];

    var _useState3 = React.useState(controlledSelectedIndex),
        _useState4 = _slicedToArray(_useState3, 2),
        prevControlledIndex = _useState4[0],
        setPrevControlledIndex = _useState4[1];

    var _useState5 = React.useState(false),
        _useState6 = _slicedToArray(_useState5, 2),
        shouldFocus = _useState6[0],
        setShouldFocus = _useState6[1];

    if (controlledSelectedIndex !== prevControlledIndex) {
      setSelectedIndex(controlledSelectedIndex);
      setPrevControlledIndex(controlledSelectedIndex);
      setShouldFocus(false);
    } // Always keep track of the latest `onChange` prop to use in our focus effect
    // handler


    React.useEffect(function () {
      savedOnChange.current = onChange;
    }, [onChange]); // If our selectedIndex has changed from an event handler, meaning that
    // `shouldFocus` is set to true, then call the saved `onChange` handler if it
    // exists

    React.useEffect(function () {
      if (shouldFocus && savedOnChange.current) {
        savedOnChange.current(selectedIndex);
      }
    }, [shouldFocus, selectedIndex]); // We have a couple of scenarios we want to keep track of when managing focus:
    // 1) Don't focus the ref at the selectedIndex if its the first render, focus
    //    should only come from a user action
    // 2) Don't focus if selectedIndex has changed because of a change in props
    // 3) Trigger focus if triggered by click or key down. Both of these handlers
    //    should set `shouldFocus` to true

    React.useEffect(function () {
      if (!shouldFocus) {
        return;
      }

      var ref = switchRefs[selectedIndex];

      if (ref && document.activeElement !== ref) {
        ref.focus && ref.focus();
      }
    }, [shouldFocus, switchRefs, selectedIndex]);

    function handleItemRef(index) {
      return function (ref) {
        switchRefs[index] = ref;
      };
    }

    function onClick(event, index) {
      if (selectedIndex !== index) {
        setSelectedIndex(index);

        if (shouldFocus !== true) {
          setShouldFocus(true);
        }
      }
    }

    function onKeyDown(event) {
      if (matches(event, [ArrowRight, ArrowLeft])) {
        setSelectedIndex(getNextIndex(event, selectedIndex, children.length));

        if (shouldFocus !== true) {
          setShouldFocus(true);
        }
      }
    }

    return React__default.createElement("div", _extends({
      className: className
    }, rest), React.Children.map(children, function (child, index) {
      return React.cloneElement(child, {
        index: index,
        onClick: composeEventHandlers$1([onClick, child.props.onClick]),
        onKeyDown: composeEventHandlers$1([onKeyDown, child.props.onKeyDown]),
        selected: index === selectedIndex,
        ref: handleItemRef(index)
      });
    }));
  }

  ContentSwitcher$1.propTypes = {
    /**
     * Pass in Switch components to be rendered in the ContentSwitcher
     */
    children: PropTypes__default.node,

    /**
     * Specify an optional className to be added to the container node
     */
    className: PropTypes__default.string,

    /**
     * Specify an `onChange` handler that is called whenever the ContentSwitcher
     * changes which item is selected
     */
    onChange: PropTypes__default.func.isRequired,

    /**
     * Specify a selected index for the initially selected content
     */
    selectedIndex: PropTypes__default.number
  };

  var DangerButton = function DangerButton(props) {
    return React__default.createElement(Button, _extends({
      kind: "danger"
    }, props));
  };

  var lodash_isequal = createCommonjsModule(function (module, exports) {
    /**
     * Lodash (Custom Build) <https://lodash.com/>
     * Build: `lodash modularize exports="npm" -o ./`
     * Copyright JS Foundation and other contributors <https://js.foundation/>
     * Released under MIT license <https://lodash.com/license>
     * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
     * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
     */

    /** Used as the size to enable large array optimizations. */
    var LARGE_ARRAY_SIZE = 200;
    /** Used to stand-in for `undefined` hash values. */

    var HASH_UNDEFINED = '__lodash_hash_undefined__';
    /** Used to compose bitmasks for value comparisons. */

    var COMPARE_PARTIAL_FLAG = 1,
        COMPARE_UNORDERED_FLAG = 2;
    /** Used as references for various `Number` constants. */

    var MAX_SAFE_INTEGER = 9007199254740991;
    /** `Object#toString` result references. */

    var argsTag = '[object Arguments]',
        arrayTag = '[object Array]',
        asyncTag = '[object AsyncFunction]',
        boolTag = '[object Boolean]',
        dateTag = '[object Date]',
        errorTag = '[object Error]',
        funcTag = '[object Function]',
        genTag = '[object GeneratorFunction]',
        mapTag = '[object Map]',
        numberTag = '[object Number]',
        nullTag = '[object Null]',
        objectTag = '[object Object]',
        promiseTag = '[object Promise]',
        proxyTag = '[object Proxy]',
        regexpTag = '[object RegExp]',
        setTag = '[object Set]',
        stringTag = '[object String]',
        symbolTag = '[object Symbol]',
        undefinedTag = '[object Undefined]',
        weakMapTag = '[object WeakMap]';
    var arrayBufferTag = '[object ArrayBuffer]',
        dataViewTag = '[object DataView]',
        float32Tag = '[object Float32Array]',
        float64Tag = '[object Float64Array]',
        int8Tag = '[object Int8Array]',
        int16Tag = '[object Int16Array]',
        int32Tag = '[object Int32Array]',
        uint8Tag = '[object Uint8Array]',
        uint8ClampedTag = '[object Uint8ClampedArray]',
        uint16Tag = '[object Uint16Array]',
        uint32Tag = '[object Uint32Array]';
    /**
     * Used to match `RegExp`
     * [syntax characters](http://ecma-international.org/ecma-262/7.0/#sec-patterns).
     */

    var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;
    /** Used to detect host constructors (Safari). */

    var reIsHostCtor = /^\[object .+?Constructor\]$/;
    /** Used to detect unsigned integer values. */

    var reIsUint = /^(?:0|[1-9]\d*)$/;
    /** Used to identify `toStringTag` values of typed arrays. */

    var typedArrayTags = {};
    typedArrayTags[float32Tag] = typedArrayTags[float64Tag] = typedArrayTags[int8Tag] = typedArrayTags[int16Tag] = typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] = typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] = typedArrayTags[uint32Tag] = true;
    typedArrayTags[argsTag] = typedArrayTags[arrayTag] = typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] = typedArrayTags[dataViewTag] = typedArrayTags[dateTag] = typedArrayTags[errorTag] = typedArrayTags[funcTag] = typedArrayTags[mapTag] = typedArrayTags[numberTag] = typedArrayTags[objectTag] = typedArrayTags[regexpTag] = typedArrayTags[setTag] = typedArrayTags[stringTag] = typedArrayTags[weakMapTag] = false;
    /** Detect free variable `global` from Node.js. */

    var freeGlobal = typeof commonjsGlobal == 'object' && commonjsGlobal && commonjsGlobal.Object === Object && commonjsGlobal;
    /** Detect free variable `self`. */

    var freeSelf = typeof self == 'object' && self && self.Object === Object && self;
    /** Used as a reference to the global object. */

    var root = freeGlobal || freeSelf || Function('return this')();
    /** Detect free variable `exports`. */

    var freeExports =  exports && !exports.nodeType && exports;
    /** Detect free variable `module`. */

    var freeModule = freeExports && 'object' == 'object' && module && !module.nodeType && module;
    /** Detect the popular CommonJS extension `module.exports`. */

    var moduleExports = freeModule && freeModule.exports === freeExports;
    /** Detect free variable `process` from Node.js. */

    var freeProcess = moduleExports && freeGlobal.process;
    /** Used to access faster Node.js helpers. */

    var nodeUtil = function () {
      try {
        return freeProcess && freeProcess.binding && freeProcess.binding('util');
      } catch (e) {}
    }();
    /* Node.js helper references. */


    var nodeIsTypedArray = nodeUtil && nodeUtil.isTypedArray;
    /**
     * A specialized version of `_.filter` for arrays without support for
     * iteratee shorthands.
     *
     * @private
     * @param {Array} [array] The array to iterate over.
     * @param {Function} predicate The function invoked per iteration.
     * @returns {Array} Returns the new filtered array.
     */

    function arrayFilter(array, predicate) {
      var index = -1,
          length = array == null ? 0 : array.length,
          resIndex = 0,
          result = [];

      while (++index < length) {
        var value = array[index];

        if (predicate(value, index, array)) {
          result[resIndex++] = value;
        }
      }

      return result;
    }
    /**
     * Appends the elements of `values` to `array`.
     *
     * @private
     * @param {Array} array The array to modify.
     * @param {Array} values The values to append.
     * @returns {Array} Returns `array`.
     */


    function arrayPush(array, values) {
      var index = -1,
          length = values.length,
          offset = array.length;

      while (++index < length) {
        array[offset + index] = values[index];
      }

      return array;
    }
    /**
     * A specialized version of `_.some` for arrays without support for iteratee
     * shorthands.
     *
     * @private
     * @param {Array} [array] The array to iterate over.
     * @param {Function} predicate The function invoked per iteration.
     * @returns {boolean} Returns `true` if any element passes the predicate check,
     *  else `false`.
     */


    function arraySome(array, predicate) {
      var index = -1,
          length = array == null ? 0 : array.length;

      while (++index < length) {
        if (predicate(array[index], index, array)) {
          return true;
        }
      }

      return false;
    }
    /**
     * The base implementation of `_.times` without support for iteratee shorthands
     * or max array length checks.
     *
     * @private
     * @param {number} n The number of times to invoke `iteratee`.
     * @param {Function} iteratee The function invoked per iteration.
     * @returns {Array} Returns the array of results.
     */


    function baseTimes(n, iteratee) {
      var index = -1,
          result = Array(n);

      while (++index < n) {
        result[index] = iteratee(index);
      }

      return result;
    }
    /**
     * The base implementation of `_.unary` without support for storing metadata.
     *
     * @private
     * @param {Function} func The function to cap arguments for.
     * @returns {Function} Returns the new capped function.
     */


    function baseUnary(func) {
      return function (value) {
        return func(value);
      };
    }
    /**
     * Checks if a `cache` value for `key` exists.
     *
     * @private
     * @param {Object} cache The cache to query.
     * @param {string} key The key of the entry to check.
     * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
     */


    function cacheHas(cache, key) {
      return cache.has(key);
    }
    /**
     * Gets the value at `key` of `object`.
     *
     * @private
     * @param {Object} [object] The object to query.
     * @param {string} key The key of the property to get.
     * @returns {*} Returns the property value.
     */


    function getValue(object, key) {
      return object == null ? undefined : object[key];
    }
    /**
     * Converts `map` to its key-value pairs.
     *
     * @private
     * @param {Object} map The map to convert.
     * @returns {Array} Returns the key-value pairs.
     */


    function mapToArray(map) {
      var index = -1,
          result = Array(map.size);
      map.forEach(function (value, key) {
        result[++index] = [key, value];
      });
      return result;
    }
    /**
     * Creates a unary function that invokes `func` with its argument transformed.
     *
     * @private
     * @param {Function} func The function to wrap.
     * @param {Function} transform The argument transform.
     * @returns {Function} Returns the new function.
     */


    function overArg(func, transform) {
      return function (arg) {
        return func(transform(arg));
      };
    }
    /**
     * Converts `set` to an array of its values.
     *
     * @private
     * @param {Object} set The set to convert.
     * @returns {Array} Returns the values.
     */


    function setToArray(set) {
      var index = -1,
          result = Array(set.size);
      set.forEach(function (value) {
        result[++index] = value;
      });
      return result;
    }
    /** Used for built-in method references. */


    var arrayProto = Array.prototype,
        funcProto = Function.prototype,
        objectProto = Object.prototype;
    /** Used to detect overreaching core-js shims. */

    var coreJsData = root['__core-js_shared__'];
    /** Used to resolve the decompiled source of functions. */

    var funcToString = funcProto.toString;
    /** Used to check objects for own properties. */

    var hasOwnProperty = objectProto.hasOwnProperty;
    /** Used to detect methods masquerading as native. */

    var maskSrcKey = function () {
      var uid = /[^.]+$/.exec(coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO || '');
      return uid ? 'Symbol(src)_1.' + uid : '';
    }();
    /**
     * Used to resolve the
     * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
     * of values.
     */


    var nativeObjectToString = objectProto.toString;
    /** Used to detect if a method is native. */

    var reIsNative = RegExp('^' + funcToString.call(hasOwnProperty).replace(reRegExpChar, '\\$&').replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$');
    /** Built-in value references. */

    var Buffer = moduleExports ? root.Buffer : undefined,
        Symbol = root.Symbol,
        Uint8Array = root.Uint8Array,
        propertyIsEnumerable = objectProto.propertyIsEnumerable,
        splice = arrayProto.splice,
        symToStringTag = Symbol ? Symbol.toStringTag : undefined;
    /* Built-in method references for those with the same name as other `lodash` methods. */

    var nativeGetSymbols = Object.getOwnPropertySymbols,
        nativeIsBuffer = Buffer ? Buffer.isBuffer : undefined,
        nativeKeys = overArg(Object.keys, Object);
    /* Built-in method references that are verified to be native. */

    var DataView = getNative(root, 'DataView'),
        Map = getNative(root, 'Map'),
        Promise = getNative(root, 'Promise'),
        Set = getNative(root, 'Set'),
        WeakMap = getNative(root, 'WeakMap'),
        nativeCreate = getNative(Object, 'create');
    /** Used to detect maps, sets, and weakmaps. */

    var dataViewCtorString = toSource(DataView),
        mapCtorString = toSource(Map),
        promiseCtorString = toSource(Promise),
        setCtorString = toSource(Set),
        weakMapCtorString = toSource(WeakMap);
    /** Used to convert symbols to primitives and strings. */

    var symbolProto = Symbol ? Symbol.prototype : undefined,
        symbolValueOf = symbolProto ? symbolProto.valueOf : undefined;
    /**
     * Creates a hash object.
     *
     * @private
     * @constructor
     * @param {Array} [entries] The key-value pairs to cache.
     */

    function Hash(entries) {
      var index = -1,
          length = entries == null ? 0 : entries.length;
      this.clear();

      while (++index < length) {
        var entry = entries[index];
        this.set(entry[0], entry[1]);
      }
    }
    /**
     * Removes all key-value entries from the hash.
     *
     * @private
     * @name clear
     * @memberOf Hash
     */


    function hashClear() {
      this.__data__ = nativeCreate ? nativeCreate(null) : {};
      this.size = 0;
    }
    /**
     * Removes `key` and its value from the hash.
     *
     * @private
     * @name delete
     * @memberOf Hash
     * @param {Object} hash The hash to modify.
     * @param {string} key The key of the value to remove.
     * @returns {boolean} Returns `true` if the entry was removed, else `false`.
     */


    function hashDelete(key) {
      var result = this.has(key) && delete this.__data__[key];
      this.size -= result ? 1 : 0;
      return result;
    }
    /**
     * Gets the hash value for `key`.
     *
     * @private
     * @name get
     * @memberOf Hash
     * @param {string} key The key of the value to get.
     * @returns {*} Returns the entry value.
     */


    function hashGet(key) {
      var data = this.__data__;

      if (nativeCreate) {
        var result = data[key];
        return result === HASH_UNDEFINED ? undefined : result;
      }

      return hasOwnProperty.call(data, key) ? data[key] : undefined;
    }
    /**
     * Checks if a hash value for `key` exists.
     *
     * @private
     * @name has
     * @memberOf Hash
     * @param {string} key The key of the entry to check.
     * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
     */


    function hashHas(key) {
      var data = this.__data__;
      return nativeCreate ? data[key] !== undefined : hasOwnProperty.call(data, key);
    }
    /**
     * Sets the hash `key` to `value`.
     *
     * @private
     * @name set
     * @memberOf Hash
     * @param {string} key The key of the value to set.
     * @param {*} value The value to set.
     * @returns {Object} Returns the hash instance.
     */


    function hashSet(key, value) {
      var data = this.__data__;
      this.size += this.has(key) ? 0 : 1;
      data[key] = nativeCreate && value === undefined ? HASH_UNDEFINED : value;
      return this;
    } // Add methods to `Hash`.


    Hash.prototype.clear = hashClear;
    Hash.prototype['delete'] = hashDelete;
    Hash.prototype.get = hashGet;
    Hash.prototype.has = hashHas;
    Hash.prototype.set = hashSet;
    /**
     * Creates an list cache object.
     *
     * @private
     * @constructor
     * @param {Array} [entries] The key-value pairs to cache.
     */

    function ListCache(entries) {
      var index = -1,
          length = entries == null ? 0 : entries.length;
      this.clear();

      while (++index < length) {
        var entry = entries[index];
        this.set(entry[0], entry[1]);
      }
    }
    /**
     * Removes all key-value entries from the list cache.
     *
     * @private
     * @name clear
     * @memberOf ListCache
     */


    function listCacheClear() {
      this.__data__ = [];
      this.size = 0;
    }
    /**
     * Removes `key` and its value from the list cache.
     *
     * @private
     * @name delete
     * @memberOf ListCache
     * @param {string} key The key of the value to remove.
     * @returns {boolean} Returns `true` if the entry was removed, else `false`.
     */


    function listCacheDelete(key) {
      var data = this.__data__,
          index = assocIndexOf(data, key);

      if (index < 0) {
        return false;
      }

      var lastIndex = data.length - 1;

      if (index == lastIndex) {
        data.pop();
      } else {
        splice.call(data, index, 1);
      }

      --this.size;
      return true;
    }
    /**
     * Gets the list cache value for `key`.
     *
     * @private
     * @name get
     * @memberOf ListCache
     * @param {string} key The key of the value to get.
     * @returns {*} Returns the entry value.
     */


    function listCacheGet(key) {
      var data = this.__data__,
          index = assocIndexOf(data, key);
      return index < 0 ? undefined : data[index][1];
    }
    /**
     * Checks if a list cache value for `key` exists.
     *
     * @private
     * @name has
     * @memberOf ListCache
     * @param {string} key The key of the entry to check.
     * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
     */


    function listCacheHas(key) {
      return assocIndexOf(this.__data__, key) > -1;
    }
    /**
     * Sets the list cache `key` to `value`.
     *
     * @private
     * @name set
     * @memberOf ListCache
     * @param {string} key The key of the value to set.
     * @param {*} value The value to set.
     * @returns {Object} Returns the list cache instance.
     */


    function listCacheSet(key, value) {
      var data = this.__data__,
          index = assocIndexOf(data, key);

      if (index < 0) {
        ++this.size;
        data.push([key, value]);
      } else {
        data[index][1] = value;
      }

      return this;
    } // Add methods to `ListCache`.


    ListCache.prototype.clear = listCacheClear;
    ListCache.prototype['delete'] = listCacheDelete;
    ListCache.prototype.get = listCacheGet;
    ListCache.prototype.has = listCacheHas;
    ListCache.prototype.set = listCacheSet;
    /**
     * Creates a map cache object to store key-value pairs.
     *
     * @private
     * @constructor
     * @param {Array} [entries] The key-value pairs to cache.
     */

    function MapCache(entries) {
      var index = -1,
          length = entries == null ? 0 : entries.length;
      this.clear();

      while (++index < length) {
        var entry = entries[index];
        this.set(entry[0], entry[1]);
      }
    }
    /**
     * Removes all key-value entries from the map.
     *
     * @private
     * @name clear
     * @memberOf MapCache
     */


    function mapCacheClear() {
      this.size = 0;
      this.__data__ = {
        'hash': new Hash(),
        'map': new (Map || ListCache)(),
        'string': new Hash()
      };
    }
    /**
     * Removes `key` and its value from the map.
     *
     * @private
     * @name delete
     * @memberOf MapCache
     * @param {string} key The key of the value to remove.
     * @returns {boolean} Returns `true` if the entry was removed, else `false`.
     */


    function mapCacheDelete(key) {
      var result = getMapData(this, key)['delete'](key);
      this.size -= result ? 1 : 0;
      return result;
    }
    /**
     * Gets the map value for `key`.
     *
     * @private
     * @name get
     * @memberOf MapCache
     * @param {string} key The key of the value to get.
     * @returns {*} Returns the entry value.
     */


    function mapCacheGet(key) {
      return getMapData(this, key).get(key);
    }
    /**
     * Checks if a map value for `key` exists.
     *
     * @private
     * @name has
     * @memberOf MapCache
     * @param {string} key The key of the entry to check.
     * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
     */


    function mapCacheHas(key) {
      return getMapData(this, key).has(key);
    }
    /**
     * Sets the map `key` to `value`.
     *
     * @private
     * @name set
     * @memberOf MapCache
     * @param {string} key The key of the value to set.
     * @param {*} value The value to set.
     * @returns {Object} Returns the map cache instance.
     */


    function mapCacheSet(key, value) {
      var data = getMapData(this, key),
          size = data.size;
      data.set(key, value);
      this.size += data.size == size ? 0 : 1;
      return this;
    } // Add methods to `MapCache`.


    MapCache.prototype.clear = mapCacheClear;
    MapCache.prototype['delete'] = mapCacheDelete;
    MapCache.prototype.get = mapCacheGet;
    MapCache.prototype.has = mapCacheHas;
    MapCache.prototype.set = mapCacheSet;
    /**
     *
     * Creates an array cache object to store unique values.
     *
     * @private
     * @constructor
     * @param {Array} [values] The values to cache.
     */

    function SetCache(values) {
      var index = -1,
          length = values == null ? 0 : values.length;
      this.__data__ = new MapCache();

      while (++index < length) {
        this.add(values[index]);
      }
    }
    /**
     * Adds `value` to the array cache.
     *
     * @private
     * @name add
     * @memberOf SetCache
     * @alias push
     * @param {*} value The value to cache.
     * @returns {Object} Returns the cache instance.
     */


    function setCacheAdd(value) {
      this.__data__.set(value, HASH_UNDEFINED);

      return this;
    }
    /**
     * Checks if `value` is in the array cache.
     *
     * @private
     * @name has
     * @memberOf SetCache
     * @param {*} value The value to search for.
     * @returns {number} Returns `true` if `value` is found, else `false`.
     */


    function setCacheHas(value) {
      return this.__data__.has(value);
    } // Add methods to `SetCache`.


    SetCache.prototype.add = SetCache.prototype.push = setCacheAdd;
    SetCache.prototype.has = setCacheHas;
    /**
     * Creates a stack cache object to store key-value pairs.
     *
     * @private
     * @constructor
     * @param {Array} [entries] The key-value pairs to cache.
     */

    function Stack(entries) {
      var data = this.__data__ = new ListCache(entries);
      this.size = data.size;
    }
    /**
     * Removes all key-value entries from the stack.
     *
     * @private
     * @name clear
     * @memberOf Stack
     */


    function stackClear() {
      this.__data__ = new ListCache();
      this.size = 0;
    }
    /**
     * Removes `key` and its value from the stack.
     *
     * @private
     * @name delete
     * @memberOf Stack
     * @param {string} key The key of the value to remove.
     * @returns {boolean} Returns `true` if the entry was removed, else `false`.
     */


    function stackDelete(key) {
      var data = this.__data__,
          result = data['delete'](key);
      this.size = data.size;
      return result;
    }
    /**
     * Gets the stack value for `key`.
     *
     * @private
     * @name get
     * @memberOf Stack
     * @param {string} key The key of the value to get.
     * @returns {*} Returns the entry value.
     */


    function stackGet(key) {
      return this.__data__.get(key);
    }
    /**
     * Checks if a stack value for `key` exists.
     *
     * @private
     * @name has
     * @memberOf Stack
     * @param {string} key The key of the entry to check.
     * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
     */


    function stackHas(key) {
      return this.__data__.has(key);
    }
    /**
     * Sets the stack `key` to `value`.
     *
     * @private
     * @name set
     * @memberOf Stack
     * @param {string} key The key of the value to set.
     * @param {*} value The value to set.
     * @returns {Object} Returns the stack cache instance.
     */


    function stackSet(key, value) {
      var data = this.__data__;

      if (data instanceof ListCache) {
        var pairs = data.__data__;

        if (!Map || pairs.length < LARGE_ARRAY_SIZE - 1) {
          pairs.push([key, value]);
          this.size = ++data.size;
          return this;
        }

        data = this.__data__ = new MapCache(pairs);
      }

      data.set(key, value);
      this.size = data.size;
      return this;
    } // Add methods to `Stack`.


    Stack.prototype.clear = stackClear;
    Stack.prototype['delete'] = stackDelete;
    Stack.prototype.get = stackGet;
    Stack.prototype.has = stackHas;
    Stack.prototype.set = stackSet;
    /**
     * Creates an array of the enumerable property names of the array-like `value`.
     *
     * @private
     * @param {*} value The value to query.
     * @param {boolean} inherited Specify returning inherited property names.
     * @returns {Array} Returns the array of property names.
     */

    function arrayLikeKeys(value, inherited) {
      var isArr = isArray(value),
          isArg = !isArr && isArguments(value),
          isBuff = !isArr && !isArg && isBuffer(value),
          isType = !isArr && !isArg && !isBuff && isTypedArray(value),
          skipIndexes = isArr || isArg || isBuff || isType,
          result = skipIndexes ? baseTimes(value.length, String) : [],
          length = result.length;

      for (var key in value) {
        if ((inherited || hasOwnProperty.call(value, key)) && !(skipIndexes && ( // Safari 9 has enumerable `arguments.length` in strict mode.
        key == 'length' || // Node.js 0.10 has enumerable non-index properties on buffers.
        isBuff && (key == 'offset' || key == 'parent') || // PhantomJS 2 has enumerable non-index properties on typed arrays.
        isType && (key == 'buffer' || key == 'byteLength' || key == 'byteOffset') || // Skip index properties.
        isIndex(key, length)))) {
          result.push(key);
        }
      }

      return result;
    }
    /**
     * Gets the index at which the `key` is found in `array` of key-value pairs.
     *
     * @private
     * @param {Array} array The array to inspect.
     * @param {*} key The key to search for.
     * @returns {number} Returns the index of the matched value, else `-1`.
     */


    function assocIndexOf(array, key) {
      var length = array.length;

      while (length--) {
        if (eq(array[length][0], key)) {
          return length;
        }
      }

      return -1;
    }
    /**
     * The base implementation of `getAllKeys` and `getAllKeysIn` which uses
     * `keysFunc` and `symbolsFunc` to get the enumerable property names and
     * symbols of `object`.
     *
     * @private
     * @param {Object} object The object to query.
     * @param {Function} keysFunc The function to get the keys of `object`.
     * @param {Function} symbolsFunc The function to get the symbols of `object`.
     * @returns {Array} Returns the array of property names and symbols.
     */


    function baseGetAllKeys(object, keysFunc, symbolsFunc) {
      var result = keysFunc(object);
      return isArray(object) ? result : arrayPush(result, symbolsFunc(object));
    }
    /**
     * The base implementation of `getTag` without fallbacks for buggy environments.
     *
     * @private
     * @param {*} value The value to query.
     * @returns {string} Returns the `toStringTag`.
     */


    function baseGetTag(value) {
      if (value == null) {
        return value === undefined ? undefinedTag : nullTag;
      }

      return symToStringTag && symToStringTag in Object(value) ? getRawTag(value) : objectToString(value);
    }
    /**
     * The base implementation of `_.isArguments`.
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is an `arguments` object,
     */


    function baseIsArguments(value) {
      return isObjectLike(value) && baseGetTag(value) == argsTag;
    }
    /**
     * The base implementation of `_.isEqual` which supports partial comparisons
     * and tracks traversed objects.
     *
     * @private
     * @param {*} value The value to compare.
     * @param {*} other The other value to compare.
     * @param {boolean} bitmask The bitmask flags.
     *  1 - Unordered comparison
     *  2 - Partial comparison
     * @param {Function} [customizer] The function to customize comparisons.
     * @param {Object} [stack] Tracks traversed `value` and `other` objects.
     * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
     */


    function baseIsEqual(value, other, bitmask, customizer, stack) {
      if (value === other) {
        return true;
      }

      if (value == null || other == null || !isObjectLike(value) && !isObjectLike(other)) {
        return value !== value && other !== other;
      }

      return baseIsEqualDeep(value, other, bitmask, customizer, baseIsEqual, stack);
    }
    /**
     * A specialized version of `baseIsEqual` for arrays and objects which performs
     * deep comparisons and tracks traversed objects enabling objects with circular
     * references to be compared.
     *
     * @private
     * @param {Object} object The object to compare.
     * @param {Object} other The other object to compare.
     * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
     * @param {Function} customizer The function to customize comparisons.
     * @param {Function} equalFunc The function to determine equivalents of values.
     * @param {Object} [stack] Tracks traversed `object` and `other` objects.
     * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
     */


    function baseIsEqualDeep(object, other, bitmask, customizer, equalFunc, stack) {
      var objIsArr = isArray(object),
          othIsArr = isArray(other),
          objTag = objIsArr ? arrayTag : getTag(object),
          othTag = othIsArr ? arrayTag : getTag(other);
      objTag = objTag == argsTag ? objectTag : objTag;
      othTag = othTag == argsTag ? objectTag : othTag;
      var objIsObj = objTag == objectTag,
          othIsObj = othTag == objectTag,
          isSameTag = objTag == othTag;

      if (isSameTag && isBuffer(object)) {
        if (!isBuffer(other)) {
          return false;
        }

        objIsArr = true;
        objIsObj = false;
      }

      if (isSameTag && !objIsObj) {
        stack || (stack = new Stack());
        return objIsArr || isTypedArray(object) ? equalArrays(object, other, bitmask, customizer, equalFunc, stack) : equalByTag(object, other, objTag, bitmask, customizer, equalFunc, stack);
      }

      if (!(bitmask & COMPARE_PARTIAL_FLAG)) {
        var objIsWrapped = objIsObj && hasOwnProperty.call(object, '__wrapped__'),
            othIsWrapped = othIsObj && hasOwnProperty.call(other, '__wrapped__');

        if (objIsWrapped || othIsWrapped) {
          var objUnwrapped = objIsWrapped ? object.value() : object,
              othUnwrapped = othIsWrapped ? other.value() : other;
          stack || (stack = new Stack());
          return equalFunc(objUnwrapped, othUnwrapped, bitmask, customizer, stack);
        }
      }

      if (!isSameTag) {
        return false;
      }

      stack || (stack = new Stack());
      return equalObjects(object, other, bitmask, customizer, equalFunc, stack);
    }
    /**
     * The base implementation of `_.isNative` without bad shim checks.
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a native function,
     *  else `false`.
     */


    function baseIsNative(value) {
      if (!isObject(value) || isMasked(value)) {
        return false;
      }

      var pattern = isFunction(value) ? reIsNative : reIsHostCtor;
      return pattern.test(toSource(value));
    }
    /**
     * The base implementation of `_.isTypedArray` without Node.js optimizations.
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
     */


    function baseIsTypedArray(value) {
      return isObjectLike(value) && isLength(value.length) && !!typedArrayTags[baseGetTag(value)];
    }
    /**
     * The base implementation of `_.keys` which doesn't treat sparse arrays as dense.
     *
     * @private
     * @param {Object} object The object to query.
     * @returns {Array} Returns the array of property names.
     */


    function baseKeys(object) {
      if (!isPrototype(object)) {
        return nativeKeys(object);
      }

      var result = [];

      for (var key in Object(object)) {
        if (hasOwnProperty.call(object, key) && key != 'constructor') {
          result.push(key);
        }
      }

      return result;
    }
    /**
     * A specialized version of `baseIsEqualDeep` for arrays with support for
     * partial deep comparisons.
     *
     * @private
     * @param {Array} array The array to compare.
     * @param {Array} other The other array to compare.
     * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
     * @param {Function} customizer The function to customize comparisons.
     * @param {Function} equalFunc The function to determine equivalents of values.
     * @param {Object} stack Tracks traversed `array` and `other` objects.
     * @returns {boolean} Returns `true` if the arrays are equivalent, else `false`.
     */


    function equalArrays(array, other, bitmask, customizer, equalFunc, stack) {
      var isPartial = bitmask & COMPARE_PARTIAL_FLAG,
          arrLength = array.length,
          othLength = other.length;

      if (arrLength != othLength && !(isPartial && othLength > arrLength)) {
        return false;
      } // Assume cyclic values are equal.


      var stacked = stack.get(array);

      if (stacked && stack.get(other)) {
        return stacked == other;
      }

      var index = -1,
          result = true,
          seen = bitmask & COMPARE_UNORDERED_FLAG ? new SetCache() : undefined;
      stack.set(array, other);
      stack.set(other, array); // Ignore non-index properties.

      while (++index < arrLength) {
        var arrValue = array[index],
            othValue = other[index];

        if (customizer) {
          var compared = isPartial ? customizer(othValue, arrValue, index, other, array, stack) : customizer(arrValue, othValue, index, array, other, stack);
        }

        if (compared !== undefined) {
          if (compared) {
            continue;
          }

          result = false;
          break;
        } // Recursively compare arrays (susceptible to call stack limits).


        if (seen) {
          if (!arraySome(other, function (othValue, othIndex) {
            if (!cacheHas(seen, othIndex) && (arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {
              return seen.push(othIndex);
            }
          })) {
            result = false;
            break;
          }
        } else if (!(arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {
          result = false;
          break;
        }
      }

      stack['delete'](array);
      stack['delete'](other);
      return result;
    }
    /**
     * A specialized version of `baseIsEqualDeep` for comparing objects of
     * the same `toStringTag`.
     *
     * **Note:** This function only supports comparing values with tags of
     * `Boolean`, `Date`, `Error`, `Number`, `RegExp`, or `String`.
     *
     * @private
     * @param {Object} object The object to compare.
     * @param {Object} other The other object to compare.
     * @param {string} tag The `toStringTag` of the objects to compare.
     * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
     * @param {Function} customizer The function to customize comparisons.
     * @param {Function} equalFunc The function to determine equivalents of values.
     * @param {Object} stack Tracks traversed `object` and `other` objects.
     * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
     */


    function equalByTag(object, other, tag, bitmask, customizer, equalFunc, stack) {
      switch (tag) {
        case dataViewTag:
          if (object.byteLength != other.byteLength || object.byteOffset != other.byteOffset) {
            return false;
          }

          object = object.buffer;
          other = other.buffer;

        case arrayBufferTag:
          if (object.byteLength != other.byteLength || !equalFunc(new Uint8Array(object), new Uint8Array(other))) {
            return false;
          }

          return true;

        case boolTag:
        case dateTag:
        case numberTag:
          // Coerce booleans to `1` or `0` and dates to milliseconds.
          // Invalid dates are coerced to `NaN`.
          return eq(+object, +other);

        case errorTag:
          return object.name == other.name && object.message == other.message;

        case regexpTag:
        case stringTag:
          // Coerce regexes to strings and treat strings, primitives and objects,
          // as equal. See http://www.ecma-international.org/ecma-262/7.0/#sec-regexp.prototype.tostring
          // for more details.
          return object == other + '';

        case mapTag:
          var convert = mapToArray;

        case setTag:
          var isPartial = bitmask & COMPARE_PARTIAL_FLAG;
          convert || (convert = setToArray);

          if (object.size != other.size && !isPartial) {
            return false;
          } // Assume cyclic values are equal.


          var stacked = stack.get(object);

          if (stacked) {
            return stacked == other;
          }

          bitmask |= COMPARE_UNORDERED_FLAG; // Recursively compare objects (susceptible to call stack limits).

          stack.set(object, other);
          var result = equalArrays(convert(object), convert(other), bitmask, customizer, equalFunc, stack);
          stack['delete'](object);
          return result;

        case symbolTag:
          if (symbolValueOf) {
            return symbolValueOf.call(object) == symbolValueOf.call(other);
          }

      }

      return false;
    }
    /**
     * A specialized version of `baseIsEqualDeep` for objects with support for
     * partial deep comparisons.
     *
     * @private
     * @param {Object} object The object to compare.
     * @param {Object} other The other object to compare.
     * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
     * @param {Function} customizer The function to customize comparisons.
     * @param {Function} equalFunc The function to determine equivalents of values.
     * @param {Object} stack Tracks traversed `object` and `other` objects.
     * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
     */


    function equalObjects(object, other, bitmask, customizer, equalFunc, stack) {
      var isPartial = bitmask & COMPARE_PARTIAL_FLAG,
          objProps = getAllKeys(object),
          objLength = objProps.length,
          othProps = getAllKeys(other),
          othLength = othProps.length;

      if (objLength != othLength && !isPartial) {
        return false;
      }

      var index = objLength;

      while (index--) {
        var key = objProps[index];

        if (!(isPartial ? key in other : hasOwnProperty.call(other, key))) {
          return false;
        }
      } // Assume cyclic values are equal.


      var stacked = stack.get(object);

      if (stacked && stack.get(other)) {
        return stacked == other;
      }

      var result = true;
      stack.set(object, other);
      stack.set(other, object);
      var skipCtor = isPartial;

      while (++index < objLength) {
        key = objProps[index];
        var objValue = object[key],
            othValue = other[key];

        if (customizer) {
          var compared = isPartial ? customizer(othValue, objValue, key, other, object, stack) : customizer(objValue, othValue, key, object, other, stack);
        } // Recursively compare objects (susceptible to call stack limits).


        if (!(compared === undefined ? objValue === othValue || equalFunc(objValue, othValue, bitmask, customizer, stack) : compared)) {
          result = false;
          break;
        }

        skipCtor || (skipCtor = key == 'constructor');
      }

      if (result && !skipCtor) {
        var objCtor = object.constructor,
            othCtor = other.constructor; // Non `Object` object instances with different constructors are not equal.

        if (objCtor != othCtor && 'constructor' in object && 'constructor' in other && !(typeof objCtor == 'function' && objCtor instanceof objCtor && typeof othCtor == 'function' && othCtor instanceof othCtor)) {
          result = false;
        }
      }

      stack['delete'](object);
      stack['delete'](other);
      return result;
    }
    /**
     * Creates an array of own enumerable property names and symbols of `object`.
     *
     * @private
     * @param {Object} object The object to query.
     * @returns {Array} Returns the array of property names and symbols.
     */


    function getAllKeys(object) {
      return baseGetAllKeys(object, keys, getSymbols);
    }
    /**
     * Gets the data for `map`.
     *
     * @private
     * @param {Object} map The map to query.
     * @param {string} key The reference key.
     * @returns {*} Returns the map data.
     */


    function getMapData(map, key) {
      var data = map.__data__;
      return isKeyable(key) ? data[typeof key == 'string' ? 'string' : 'hash'] : data.map;
    }
    /**
     * Gets the native function at `key` of `object`.
     *
     * @private
     * @param {Object} object The object to query.
     * @param {string} key The key of the method to get.
     * @returns {*} Returns the function if it's native, else `undefined`.
     */


    function getNative(object, key) {
      var value = getValue(object, key);
      return baseIsNative(value) ? value : undefined;
    }
    /**
     * A specialized version of `baseGetTag` which ignores `Symbol.toStringTag` values.
     *
     * @private
     * @param {*} value The value to query.
     * @returns {string} Returns the raw `toStringTag`.
     */


    function getRawTag(value) {
      var isOwn = hasOwnProperty.call(value, symToStringTag),
          tag = value[symToStringTag];

      try {
        value[symToStringTag] = undefined;
        var unmasked = true;
      } catch (e) {}

      var result = nativeObjectToString.call(value);

      if (unmasked) {
        if (isOwn) {
          value[symToStringTag] = tag;
        } else {
          delete value[symToStringTag];
        }
      }

      return result;
    }
    /**
     * Creates an array of the own enumerable symbols of `object`.
     *
     * @private
     * @param {Object} object The object to query.
     * @returns {Array} Returns the array of symbols.
     */


    var getSymbols = !nativeGetSymbols ? stubArray : function (object) {
      if (object == null) {
        return [];
      }

      object = Object(object);
      return arrayFilter(nativeGetSymbols(object), function (symbol) {
        return propertyIsEnumerable.call(object, symbol);
      });
    };
    /**
     * Gets the `toStringTag` of `value`.
     *
     * @private
     * @param {*} value The value to query.
     * @returns {string} Returns the `toStringTag`.
     */

    var getTag = baseGetTag; // Fallback for data views, maps, sets, and weak maps in IE 11 and promises in Node.js < 6.

    if (DataView && getTag(new DataView(new ArrayBuffer(1))) != dataViewTag || Map && getTag(new Map()) != mapTag || Promise && getTag(Promise.resolve()) != promiseTag || Set && getTag(new Set()) != setTag || WeakMap && getTag(new WeakMap()) != weakMapTag) {
      getTag = function (value) {
        var result = baseGetTag(value),
            Ctor = result == objectTag ? value.constructor : undefined,
            ctorString = Ctor ? toSource(Ctor) : '';

        if (ctorString) {
          switch (ctorString) {
            case dataViewCtorString:
              return dataViewTag;

            case mapCtorString:
              return mapTag;

            case promiseCtorString:
              return promiseTag;

            case setCtorString:
              return setTag;

            case weakMapCtorString:
              return weakMapTag;
          }
        }

        return result;
      };
    }
    /**
     * Checks if `value` is a valid array-like index.
     *
     * @private
     * @param {*} value The value to check.
     * @param {number} [length=MAX_SAFE_INTEGER] The upper bounds of a valid index.
     * @returns {boolean} Returns `true` if `value` is a valid index, else `false`.
     */


    function isIndex(value, length) {
      length = length == null ? MAX_SAFE_INTEGER : length;
      return !!length && (typeof value == 'number' || reIsUint.test(value)) && value > -1 && value % 1 == 0 && value < length;
    }
    /**
     * Checks if `value` is suitable for use as unique object key.
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is suitable, else `false`.
     */


    function isKeyable(value) {
      var type = typeof value;
      return type == 'string' || type == 'number' || type == 'symbol' || type == 'boolean' ? value !== '__proto__' : value === null;
    }
    /**
     * Checks if `func` has its source masked.
     *
     * @private
     * @param {Function} func The function to check.
     * @returns {boolean} Returns `true` if `func` is masked, else `false`.
     */


    function isMasked(func) {
      return !!maskSrcKey && maskSrcKey in func;
    }
    /**
     * Checks if `value` is likely a prototype object.
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a prototype, else `false`.
     */


    function isPrototype(value) {
      var Ctor = value && value.constructor,
          proto = typeof Ctor == 'function' && Ctor.prototype || objectProto;
      return value === proto;
    }
    /**
     * Converts `value` to a string using `Object.prototype.toString`.
     *
     * @private
     * @param {*} value The value to convert.
     * @returns {string} Returns the converted string.
     */


    function objectToString(value) {
      return nativeObjectToString.call(value);
    }
    /**
     * Converts `func` to its source code.
     *
     * @private
     * @param {Function} func The function to convert.
     * @returns {string} Returns the source code.
     */


    function toSource(func) {
      if (func != null) {
        try {
          return funcToString.call(func);
        } catch (e) {}

        try {
          return func + '';
        } catch (e) {}
      }

      return '';
    }
    /**
     * Performs a
     * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
     * comparison between two values to determine if they are equivalent.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to compare.
     * @param {*} other The other value to compare.
     * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
     * @example
     *
     * var object = { 'a': 1 };
     * var other = { 'a': 1 };
     *
     * _.eq(object, object);
     * // => true
     *
     * _.eq(object, other);
     * // => false
     *
     * _.eq('a', 'a');
     * // => true
     *
     * _.eq('a', Object('a'));
     * // => false
     *
     * _.eq(NaN, NaN);
     * // => true
     */


    function eq(value, other) {
      return value === other || value !== value && other !== other;
    }
    /**
     * Checks if `value` is likely an `arguments` object.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is an `arguments` object,
     *  else `false`.
     * @example
     *
     * _.isArguments(function() { return arguments; }());
     * // => true
     *
     * _.isArguments([1, 2, 3]);
     * // => false
     */


    var isArguments = baseIsArguments(function () {
      return arguments;
    }()) ? baseIsArguments : function (value) {
      return isObjectLike(value) && hasOwnProperty.call(value, 'callee') && !propertyIsEnumerable.call(value, 'callee');
    };
    /**
     * Checks if `value` is classified as an `Array` object.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is an array, else `false`.
     * @example
     *
     * _.isArray([1, 2, 3]);
     * // => true
     *
     * _.isArray(document.body.children);
     * // => false
     *
     * _.isArray('abc');
     * // => false
     *
     * _.isArray(_.noop);
     * // => false
     */

    var isArray = Array.isArray;
    /**
     * Checks if `value` is array-like. A value is considered array-like if it's
     * not a function and has a `value.length` that's an integer greater than or
     * equal to `0` and less than or equal to `Number.MAX_SAFE_INTEGER`.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is array-like, else `false`.
     * @example
     *
     * _.isArrayLike([1, 2, 3]);
     * // => true
     *
     * _.isArrayLike(document.body.children);
     * // => true
     *
     * _.isArrayLike('abc');
     * // => true
     *
     * _.isArrayLike(_.noop);
     * // => false
     */

    function isArrayLike(value) {
      return value != null && isLength(value.length) && !isFunction(value);
    }
    /**
     * Checks if `value` is a buffer.
     *
     * @static
     * @memberOf _
     * @since 4.3.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a buffer, else `false`.
     * @example
     *
     * _.isBuffer(new Buffer(2));
     * // => true
     *
     * _.isBuffer(new Uint8Array(2));
     * // => false
     */


    var isBuffer = nativeIsBuffer || stubFalse;
    /**
     * Performs a deep comparison between two values to determine if they are
     * equivalent.
     *
     * **Note:** This method supports comparing arrays, array buffers, booleans,
     * date objects, error objects, maps, numbers, `Object` objects, regexes,
     * sets, strings, symbols, and typed arrays. `Object` objects are compared
     * by their own, not inherited, enumerable properties. Functions and DOM
     * nodes are compared by strict equality, i.e. `===`.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Lang
     * @param {*} value The value to compare.
     * @param {*} other The other value to compare.
     * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
     * @example
     *
     * var object = { 'a': 1 };
     * var other = { 'a': 1 };
     *
     * _.isEqual(object, other);
     * // => true
     *
     * object === other;
     * // => false
     */

    function isEqual(value, other) {
      return baseIsEqual(value, other);
    }
    /**
     * Checks if `value` is classified as a `Function` object.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a function, else `false`.
     * @example
     *
     * _.isFunction(_);
     * // => true
     *
     * _.isFunction(/abc/);
     * // => false
     */


    function isFunction(value) {
      if (!isObject(value)) {
        return false;
      } // The use of `Object#toString` avoids issues with the `typeof` operator
      // in Safari 9 which returns 'object' for typed arrays and other constructors.


      var tag = baseGetTag(value);
      return tag == funcTag || tag == genTag || tag == asyncTag || tag == proxyTag;
    }
    /**
     * Checks if `value` is a valid array-like length.
     *
     * **Note:** This method is loosely based on
     * [`ToLength`](http://ecma-international.org/ecma-262/7.0/#sec-tolength).
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a valid length, else `false`.
     * @example
     *
     * _.isLength(3);
     * // => true
     *
     * _.isLength(Number.MIN_VALUE);
     * // => false
     *
     * _.isLength(Infinity);
     * // => false
     *
     * _.isLength('3');
     * // => false
     */


    function isLength(value) {
      return typeof value == 'number' && value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
    }
    /**
     * Checks if `value` is the
     * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
     * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is an object, else `false`.
     * @example
     *
     * _.isObject({});
     * // => true
     *
     * _.isObject([1, 2, 3]);
     * // => true
     *
     * _.isObject(_.noop);
     * // => true
     *
     * _.isObject(null);
     * // => false
     */


    function isObject(value) {
      var type = typeof value;
      return value != null && (type == 'object' || type == 'function');
    }
    /**
     * Checks if `value` is object-like. A value is object-like if it's not `null`
     * and has a `typeof` result of "object".
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
     * @example
     *
     * _.isObjectLike({});
     * // => true
     *
     * _.isObjectLike([1, 2, 3]);
     * // => true
     *
     * _.isObjectLike(_.noop);
     * // => false
     *
     * _.isObjectLike(null);
     * // => false
     */


    function isObjectLike(value) {
      return value != null && typeof value == 'object';
    }
    /**
     * Checks if `value` is classified as a typed array.
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
     * @example
     *
     * _.isTypedArray(new Uint8Array);
     * // => true
     *
     * _.isTypedArray([]);
     * // => false
     */


    var isTypedArray = nodeIsTypedArray ? baseUnary(nodeIsTypedArray) : baseIsTypedArray;
    /**
     * Creates an array of the own enumerable property names of `object`.
     *
     * **Note:** Non-object values are coerced to objects. See the
     * [ES spec](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)
     * for more details.
     *
     * @static
     * @since 0.1.0
     * @memberOf _
     * @category Object
     * @param {Object} object The object to query.
     * @returns {Array} Returns the array of property names.
     * @example
     *
     * function Foo() {
     *   this.a = 1;
     *   this.b = 2;
     * }
     *
     * Foo.prototype.c = 3;
     *
     * _.keys(new Foo);
     * // => ['a', 'b'] (iteration order is not guaranteed)
     *
     * _.keys('hi');
     * // => ['0', '1']
     */

    function keys(object) {
      return isArrayLike(object) ? arrayLikeKeys(object) : baseKeys(object);
    }
    /**
     * This method returns a new empty array.
     *
     * @static
     * @memberOf _
     * @since 4.13.0
     * @category Util
     * @returns {Array} Returns the new empty array.
     * @example
     *
     * var arrays = _.times(2, _.stubArray);
     *
     * console.log(arrays);
     * // => [[], []]
     *
     * console.log(arrays[0] === arrays[1]);
     * // => false
     */


    function stubArray() {
      return [];
    }
    /**
     * This method returns `false`.
     *
     * @static
     * @memberOf _
     * @since 4.13.0
     * @category Util
     * @returns {boolean} Returns `false`.
     * @example
     *
     * _.times(2, _.stubFalse);
     * // => [false, false]
     */


    function stubFalse() {
      return false;
    }

    module.exports = isEqual;
  });

  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */

  /**
   * Generic helper used to consolidate all call sites for getting a cell id into
   * one method. The strategy currently is that a "cellId" is just the combination
   * of the row id and the header key used to access this field in a row.
   *
   * @param {string} rowId
   * @param {string} header
   * @returns {string}
   */
  var getCellId = function getCellId(rowId, header) {
    return "".concat(rowId, ":").concat(header);
  };

  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */
  /**
   * Compare two primitives to determine which comes first. Initially, this method
   * will try and figure out if both entries are the same type. If so, it will
   * apply the default sort algorithm for those types. Otherwise, it defaults to a
   * string conversion.
   *
   * @param {number|string} a
   * @param {number|string} b
   * @param {string} locale
   * @returns {number}
   */

  var compare = function compare(a, b) {
    var locale = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'en';

    if (typeof a === 'number' && typeof b === 'number') {
      return a - b;
    }

    if (typeof a === 'string' && typeof b === 'string') {
      return compareStrings(a, b, locale);
    }

    return compareStrings('' + a, '' + b, locale);
  };
  /**
   * Use the built-in `localeCompare` function available on strings to compare two
   * srints.
   *
   * @param {string} a
   * @param {string} b
   * @param {string} locale
   * @returns {number}
   */

  var compareStrings = function compareStrings(a, b) {
    var locale = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'en';
    return a.localeCompare(b, locale, {
      numeric: true
    });
  };
  /**
   * Default implementation of how we sort rows internally. The idea behind this
   * implementation is to use the given list of row ids to look up the cells in
   * the row by the given key. We then use the value of these cells and pipe them
   * into our local `compareStrings` method, including the locale where
   * appropriate.
   *
   * @param {object} config
   * @param {Array[string]} config.rowIds array of all the row ids in the table
   * @param {object} config.cellsById object containing a mapping of cell id to
   * cell
   * @param {string} config.direction the sort direction used to determine the
   * order the comparison is called in
   * @param {string} config.key the header key that we use to lookup the cell
   * @param {string} [config.locale] optional locale used in the comparison
   * function
   * @returns {Array[string]} array of sorted rowIds
   */

  var sortRows = function sortRows(_ref) {
    var rowIds = _ref.rowIds,
        cellsById = _ref.cellsById,
        sortDirection = _ref.sortDirection,
        key = _ref.key,
        locale = _ref.locale,
        sortRow = _ref.sortRow;
    return rowIds.slice().sort(function (a, b) {
      var cellA = cellsById[getCellId(a, key)];
      var cellB = cellsById[getCellId(b, key)];
      return sortRow(cellA.value, cellB.value, {
        key: key,
        sortDirection: sortDirection,
        locale: locale,
        sortStates: sortStates,
        compare: compare
      });
    });
  };
  var defaultSortRow = function defaultSortRow(cellA, cellB, _ref2) {
    var sortDirection = _ref2.sortDirection,
        sortStates = _ref2.sortStates,
        locale = _ref2.locale;

    if (sortDirection === sortStates.ASC) {
      return compare(cellA, cellB, locale);
    }

    return compare(cellB, cellA, locale);
  };

  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */
  /**
   * We currently support the following sorting states for DataTable headers,
   * namely: `NONE` for no sorting being applied, and then `DESC` and `ASC` for
   * the corresponding direction of the sorting order.
   */

  var sortStates = {
    NONE: 'NONE',
    DESC: 'DESC',
    ASC: 'ASC'
  }; // Our initialSortState should be `NONE`, unless a consumer has specified a
  // different initialSortState

  var initialSortState = sortStates.NONE;
  /**
   * Utility used to get the next sort state given the following pieces of
   * information:
   *
   * @param {string} prevHeader the value of the previous header
   * @param {string} header the value of the currently selected header
   * @param {string} prevState the previous sort state of the table
   * @returns {string}
   */

  var getNextSortDirection = function getNextSortDirection(prevHeader, header, prevState) {
    // If the previous header is equivalent to the current header, we know that we
    // have to derive the next sort state from the previous sort state
    if (prevHeader === header) {
      // When transitioning, we know that the sequence of states is as follows:
      // NONE -> ASC -> DESC -> NONE
      if (prevState === 'NONE') {
        return sortStates.ASC;
      }

      if (prevState === 'ASC') {
        return sortStates.DESC;
      }

      return sortStates.NONE;
    } // Otherwise, we have selected a new header and need to start off by sorting
    // in descending order by default


    return sortStates.ASC;
  };
  var getNextSortState = function getNextSortState(props, state, _ref) {
    var key = _ref.key;
    var sortDirection = state.sortDirection,
        sortHeaderKey = state.sortHeaderKey;
    var nextSortDirection = getNextSortDirection(key, sortHeaderKey, sortDirection);
    return getSortedState(props, state, key, nextSortDirection);
  };
  /**
   * Derive the set of sorted state fields from props and state for the given
   * header key and sortDirection
   *
   * @param {object} props
   * @param {string} props.locale The current locale
   * @param {Function} props.sortRows Method to handle sorting a collection of
   * rows
   * @param {object} state
   * @param {Array<string>} state.rowIds Array of row ids
   * @param {object} state.cellsById Lookup object for cells by id
   * @param {Array<string>} state.initialRowOrder Initial row order for the
   * current set of rows
   * @param {string} key The key for the given header we are derving the
   * sorted state for
   * @param {string} sortDirection The sortState that we want to order by
   * @returns {object}
   */

  var getSortedState = function getSortedState(props, state, key, sortDirection) {
    var rowIds = state.rowIds,
        cellsById = state.cellsById,
        initialRowOrder = state.initialRowOrder;
    var locale = props.locale,
        sortRow = props.sortRow;
    var nextRowIds = sortDirection !== sortStates.NONE ? sortRows({
      rowIds: rowIds,
      cellsById: cellsById,
      sortDirection: sortDirection,
      key: key,
      locale: locale,
      sortRow: sortRow
    }) : initialRowOrder;
    return {
      sortHeaderKey: key,
      sortDirection: sortDirection,
      rowIds: nextRowIds
    };
  };

  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */
  /**
   * Normalize a collection of rows with the given headers.
   *
   * @param {Array<object>} rows
   * @param {Array<object>} headers
   * @returns {object}
   */

  var normalize = function normalize(rows, headers) {
    var prevState = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    var prevRowsByIds = prevState.rowsById;
    var rowIds = new Array(rows.length);
    var rowsById = {};
    var cellsById = {};
    rows.forEach(function (row, i) {
      rowIds[i] = row.id; // Initialize the row info and state values, namely for selection and
      // expansion

      var id = row.id,
          _row$isSelected = row.isSelected,
          isSelected = _row$isSelected === void 0 ? false : _row$isSelected,
          _row$isExpanded = row.isExpanded,
          isExpanded = _row$isExpanded === void 0 ? false : _row$isExpanded,
          _row$disabled = row.disabled,
          disabled = _row$disabled === void 0 ? false : _row$disabled;
      rowsById[id] = {
        id: id,
        isSelected: isSelected,
        isExpanded: isExpanded,
        disabled: disabled,
        cells: new Array(headers.length)
      }; // If we have a previous state, and the row existed in that previous state,
      // then we'll set the state values of the row to the previous state values.

      if (prevRowsByIds && prevRowsByIds[row.id] !== undefined) {
        rowsById[row.id].isSelected = prevRowsByIds[row.id].isSelected;
        rowsById[row.id].isExpanded = prevRowsByIds[row.id].isExpanded;
      }

      headers.forEach(function (_ref, i) {
        var key = _ref.key;
        var id = getCellId(row.id, key); // Initialize the cell info and state values, namely for editing

        cellsById[id] = {
          id: id,
          value: row[key],
          isEditable: false,
          isEditing: false,
          isValid: true,
          errors: null,
          info: {
            header: key
          }
        }; // TODO: When working on inline edits, we'll need to derive the state
        // values similarly to rows above.

        rowsById[row.id].cells[i] = id;
      });
    });
    return {
      rowIds: rowIds,
      rowsById: rowsById,
      cellsById: cellsById
    };
  };

  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */
  /**
   * Helper to derive the next state from the given props and the
   * prevState. Potential future-facing API hook for React v17.
   *
   * Currently, it's being used as a way to normalize the incoming data that we
   * are receiving for rows
   */

  var getDerivedStateFromProps = function getDerivedStateFromProps(props, prevState) {
    var _normalize = normalize(props.rows, props.headers, prevState),
        rowIds = _normalize.rowIds,
        rowsById = _normalize.rowsById,
        cellsById = _normalize.cellsById;

    var state = {
      rowIds: rowIds,
      rowsById: rowsById,
      cellsById: cellsById,
      sortDirection: prevState.sortDirection || initialSortState,
      sortHeaderKey: prevState.sortHeaderKey || null,
      // Copy over rowIds so the reference doesn't mutate the stored
      // `initialRowOrder`
      initialRowOrder: rowIds.slice(),
      filterInputValue: prevState.filterInputValue || null,
      // Optional state field to indicate whether a consumer should show a
      // batch actions menu
      shouldShowBatchActions: prevState.shouldShowBatchActions || false
    };

    if (prevState.sortDirection && prevState.sortHeaderKey) {
      var _getSortedState = getSortedState(props, state, prevState.sortHeaderKey, prevState.sortDirection),
          _rowIds = _getSortedState.rowIds;

      state.rowIds = _rowIds;
    }

    return state;
  };

  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */

  /**
   * Counterpart to `normalize` for a collection of rows. This method unravels the
   * normalization step that we use to build the given parameters in order to
   * return a natural interface to working with rows for a consumer.
   *
   * The default heuristic here is to map through all the row ids and return the
   * value of the row for the given id, in addition to adding a `cells` key that
   * contains the results of mapping over the rows cells and getting individual
   * cell info.
   *
   * @param {Array<string>} rowIds array of row ids in the table
   * @param {object} rowsById object containing lookups for rows by id
   * @param {object} cellsById object containing lookups for cells by id
   */
  var denormalize = function denormalize(rowIds, rowsById, cellsById) {
    return rowIds.map(function (id) {
      return _objectSpread2({}, rowsById[id], {
        cells: rowsById[id].cells.map(function (cellId) {
          return cellsById[cellId];
        })
      });
    });
  };

  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */
  /**
   * Default implemention of how we filter rows internally. The idea behind this
   * implementation is to use the given list of row ids and headers to get the
   * individual cell values for a row. Then, we go through each cell value and see
   * if any of them includes the given inputValue.
   *
   * @param {object} config
   * @param {Array<string>} config.rowIds array of all the row ids in the table
   * @param {Array<object>} config.headers
   * @param {object} config.cellsById object containing a map of cell id to cell
   * @param {string} config.inputValue the current input value in the Table Search
   * @returns {Array<string>} rowIds
   */

  var defaultFilterRows = function defaultFilterRows(_ref) {
    var rowIds = _ref.rowIds,
        headers = _ref.headers,
        cellsById = _ref.cellsById,
        inputValue = _ref.inputValue;
    return rowIds.filter(function (rowId) {
      return headers.some(function (_ref2) {
        var key = _ref2.key;
        var id = getCellId(rowId, key);
        if (typeof cellsById[id].value === 'boolean') return false;
        return ('' + cellsById[id].value).toLowerCase().includes(inputValue.toLowerCase());
      });
    });
  };

  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */

  /**
   * Generic utility to initialize a method that will return a unique instance id
   * for a component.
   */
  var setupGetInstanceId = function setupGetInstanceId() {
    var instanceId = 0;
    return function getInstanceId() {
      return ++instanceId;
    };
  };

  var _defaultTranslations$3;
  var getInstanceId = setupGetInstanceId();
  var translationKeys = {
    expandRow: 'carbon.table.row.expand',
    collapseRow: 'carbon.table.row.collapse',
    expandAll: 'carbon.table.all.expand',
    collapseAll: 'carbon.table.all.collapse',
    selectAll: 'carbon.table.all.select',
    unselectAll: 'carbon.table.all.unselect',
    selectRow: 'carbon.table.row.select',
    unselectRow: 'carbon.table.row.unselect'
  };
  var defaultTranslations$3 = (_defaultTranslations$3 = {}, _defineProperty(_defaultTranslations$3, translationKeys.expandAll, 'Expand all rows'), _defineProperty(_defaultTranslations$3, translationKeys.collapseAll, 'Collapse all rows'), _defineProperty(_defaultTranslations$3, translationKeys.expandRow, 'Expand current row'), _defineProperty(_defaultTranslations$3, translationKeys.collapseRow, 'Collapse current row'), _defineProperty(_defaultTranslations$3, translationKeys.selectAll, 'Select all rows'), _defineProperty(_defaultTranslations$3, translationKeys.unselectAll, 'Unselect all rows'), _defineProperty(_defaultTranslations$3, translationKeys.selectRow, 'Select row'), _defineProperty(_defaultTranslations$3, translationKeys.unselectRow, 'Unselect row'), _defaultTranslations$3);

  var translateWithId = function translateWithId(id) {
    return defaultTranslations$3[id];
  };
  /**
   * Data Tables are used to represent a collection of resources, displaying a
   * subset of their fields in columns, or headers. We prioritize direct updates
   * to the state of what we're rendering, so internally we end up normalizing the
   * given data and then denormalizing it when rendering.
   *
   * As a result, each part of the DataTable is accessible through look-up by id,
   * and updating the state of the single entity will cascade updates to the
   * consumer.
   */


  var DataTable$1 =
  /*#__PURE__*/
  function (_React$Component) {
    _inherits(DataTable, _React$Component);

    function DataTable(_props) {
      var _this;

      _classCallCheck(this, DataTable);

      _this = _possibleConstructorReturn(this, _getPrototypeOf(DataTable).call(this, _props));

      _defineProperty(_assertThisInitialized(_this), "getHeaderProps", function (_ref) {
        var header = _ref.header,
            onClick = _ref.onClick,
            _ref$isSortable = _ref.isSortable,
            isSortable = _ref$isSortable === void 0 ? _this.props.isSortable : _ref$isSortable,
            rest = _objectWithoutProperties(_ref, ["header", "onClick", "isSortable"]);

        var _this$state = _this.state,
            sortDirection = _this$state.sortDirection,
            sortHeaderKey = _this$state.sortHeaderKey;
        return _objectSpread2({}, rest, {
          key: header.key,
          sortDirection: sortDirection,
          isSortable: isSortable,
          isSortHeader: sortHeaderKey === header.key,
          // Compose the event handlers so we don't overwrite a consumer's `onClick`
          // handler
          onClick: composeEventHandlers$1([_this.handleSortBy(header.key), onClick ? _this.handleOnHeaderClick(onClick, {
            sortHeaderKey: header.key,
            sortDirection: sortDirection
          }) : null])
        });
      });

      _defineProperty(_assertThisInitialized(_this), "getExpandHeaderProps", function () {
        var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
            onClick = _ref2.onClick,
            rest = _objectWithoutProperties(_ref2, ["onClick"]);

        var t = _this.props.translateWithId;
        var _this$state2 = _this.state,
            isExpandedAll = _this$state2.isExpandedAll,
            rowIds = _this$state2.rowIds,
            rowsById = _this$state2.rowsById;
        var isExpanded = isExpandedAll || rowIds.every(function (id) {
          return rowsById[id].isExpanded;
        });
        var translationKey = !isExpanded ? translationKeys.collapseAll : translationKeys.expandAll;
        return _objectSpread2({}, rest, {
          ariaLabel: t(translationKey),
          isExpanded: isExpanded,
          // Compose the event handlers so we don't overwrite a consumer's `onClick`
          // handler
          onExpand: composeEventHandlers$1([_this.handleOnExpandAll, onClick ? _this.handleOnExpandHeaderClick(onClick, {
            isExpanded: isExpanded
          }) : null])
        });
      });

      _defineProperty(_assertThisInitialized(_this), "handleOnHeaderClick", function (onClick, sortParams) {
        return function (e) {
          return onClick(e, sortParams);
        };
      });

      _defineProperty(_assertThisInitialized(_this), "handleOnExpandHeaderClick", function (onClick, expandParams) {
        return function (e) {
          return onClick(e, expandParams);
        };
      });

      _defineProperty(_assertThisInitialized(_this), "getRowProps", function (_ref3) {
        var row = _ref3.row,
            onClick = _ref3.onClick,
            rest = _objectWithoutProperties(_ref3, ["row", "onClick"]);

        var t = _this.props.translateWithId;
        var translationKey = row.isExpanded ? translationKeys.collapseRow : translationKeys.expandRow;
        return _objectSpread2({}, rest, {
          key: row.id,
          // Compose the event handlers so we don't overwrite a consumer's `onClick`
          // handler
          onExpand: composeEventHandlers$1([_this.handleOnExpandRow(row.id), onClick]),
          isExpanded: row.isExpanded,
          ariaLabel: t(translationKey),
          isSelected: row.isSelected,
          disabled: row.disabled
        });
      });

      _defineProperty(_assertThisInitialized(_this), "getSelectionProps", function () {
        var _ref4 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
            onClick = _ref4.onClick,
            row = _ref4.row,
            rest = _objectWithoutProperties(_ref4, ["onClick", "row"]);

        var t = _this.props.translateWithId; // If we're given a row, return the selection state values for that row

        if (row) {
          var _translationKey = row.isSelected ? translationKeys.unselectRow : translationKeys.selectRow;

          return _objectSpread2({}, rest, {
            checked: row.isSelected,
            onSelect: composeEventHandlers$1([_this.handleOnSelectRow(row.id), onClick]),
            id: "".concat(_this.getTablePrefix(), "__select-row-").concat(row.id),
            name: "select-row-".concat(row.id),
            ariaLabel: t(_translationKey),
            disabled: row.disabled,
            radio: _this.props.radio || null
          });
        } // Otherwise, we're working on `TableSelectAll` which handles toggling the
        // selection state of all rows.


        var rowCount = _this.state.rowIds.length;

        var selectedRowCount = _this.getSelectedRows().length;

        var checked = rowCount > 0 && selectedRowCount === rowCount;
        var indeterminate = rowCount > 0 && selectedRowCount > 0 && selectedRowCount !== rowCount;
        var translationKey = checked ? translationKeys.unselectAll : translationKeys.selectAll;
        return _objectSpread2({}, rest, {
          ariaLabel: t(translationKey),
          checked: checked,
          id: "".concat(_this.getTablePrefix(), "__select-all"),
          indeterminate: indeterminate,
          name: 'select-all',
          onSelect: composeEventHandlers$1([_this.handleSelectAll, onClick])
        });
      });

      _defineProperty(_assertThisInitialized(_this), "getBatchActionProps", function () {
        var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        var shouldShowBatchActions = _this.state.shouldShowBatchActions;

        var totalSelected = _this.getSelectedRows().length;

        return _objectSpread2({}, props, {
          shouldShowBatchActions: shouldShowBatchActions,
          totalSelected: totalSelected,
          onCancel: _this.handleOnCancel
        });
      });

      _defineProperty(_assertThisInitialized(_this), "getTableProps", function () {
        var _this$props = _this.props,
            useZebraStyles = _this$props.useZebraStyles,
            size = _this$props.size,
            isSortable = _this$props.isSortable,
            useStaticWidth = _this$props.useStaticWidth,
            shouldShowBorder = _this$props.shouldShowBorder;
        return {
          useZebraStyles: useZebraStyles,
          size: size,
          isSortable: isSortable,
          useStaticWidth: useStaticWidth,
          shouldShowBorder: shouldShowBorder
        };
      });

      _defineProperty(_assertThisInitialized(_this), "getSelectedRows", function () {
        return _this.state.rowIds.filter(function (id) {
          var row = _this.state.rowsById[id];
          return row.isSelected;
        });
      });

      _defineProperty(_assertThisInitialized(_this), "getTablePrefix", function () {
        return "data-table-".concat(_this.instanceId);
      });

      _defineProperty(_assertThisInitialized(_this), "setAllSelectedState", function (initialState, isSelected) {
        var rowIds = initialState.rowIds;
        return {
          rowsById: rowIds.reduce(function (acc, id) {
            return _objectSpread2({}, acc, _defineProperty({}, id, _objectSpread2({}, initialState.rowsById[id], {
              isSelected: initialState.rowsById[id].disabled ? false : isSelected
            })));
          }, {})
        };
      });

      _defineProperty(_assertThisInitialized(_this), "handleOnCancel", function () {
        _this.setState(function (state) {
          return _objectSpread2({
            shouldShowBatchActions: false
          }, _this.setAllSelectedState(state, false));
        });
      });

      _defineProperty(_assertThisInitialized(_this), "handleSelectAll", function () {
        _this.setState(function (state) {
          var rowIds = state.rowIds,
              rowsById = state.rowsById;
          var selectableRows = rowIds.reduce(function (acc, rowId) {
            return acc += rowsById[rowId].disabled ? 0 : 1;
          }, 0);
          var isSelected = _this.getSelectedRows().length !== selectableRows;
          return _objectSpread2({
            shouldShowBatchActions: isSelected
          }, _this.setAllSelectedState(state, isSelected));
        });
      });

      _defineProperty(_assertThisInitialized(_this), "handleOnSelectRow", function (rowId) {
        return function () {
          _this.setState(function (state) {
            var row = state.rowsById[rowId];

            if (_this.props.radio) {
              // deselect all radio buttons
              var rowsById = Object.entries(state.rowsById).reduce(function (p, c) {
                var _c = _slicedToArray(c, 2),
                    key = _c[0],
                    val = _c[1];

                val.isSelected = false;
                p[key] = val;
                return p;
              }, {});
              return {
                shouldShowBatchActions: false,
                rowsById: _objectSpread2({}, rowsById, _defineProperty({}, rowId, _objectSpread2({}, row, {
                  isSelected: !row.isSelected
                })))
              };
            }

            var selectedRows = state.rowIds.filter(function (id) {
              return state.rowsById[id].isSelected;
            }).length; // Predict the length of the selected rows after this change occurs

            var selectedRowsCount = !row.isSelected ? selectedRows + 1 : selectedRows - 1;
            return {
              // Basic assumption here is that we want to show the batch action bar if
              // the row is being selected. If it's being unselected, then see if we
              // have a non-zero number of selected rows that batch actions could
              // still apply to
              shouldShowBatchActions: !row.isSelected || selectedRowsCount > 0,
              rowsById: _objectSpread2({}, state.rowsById, _defineProperty({}, rowId, _objectSpread2({}, row, {
                isSelected: !row.isSelected
              })))
            };
          });
        };
      });

      _defineProperty(_assertThisInitialized(_this), "handleOnExpandRow", function (rowId) {
        return function () {
          _this.setState(function (state) {
            var row = state.rowsById[rowId];
            var isExpandedAll = state.isExpandedAll;
            return {
              isExpandedAll: row.isExpanded ? false : isExpandedAll,
              rowsById: _objectSpread2({}, state.rowsById, _defineProperty({}, rowId, _objectSpread2({}, row, {
                isExpanded: !row.isExpanded
              })))
            };
          });
        };
      });

      _defineProperty(_assertThisInitialized(_this), "handleOnExpandAll", function () {
        _this.setState(function (state) {
          var rowIds = state.rowIds,
              isExpandedAll = state.isExpandedAll;
          return {
            isExpandedAll: !isExpandedAll,
            rowsById: rowIds.reduce(function (acc, id) {
              return _objectSpread2({}, acc, _defineProperty({}, id, _objectSpread2({}, state.rowsById[id], {
                isExpanded: !isExpandedAll
              })));
            }, {})
          };
        });
      });

      _defineProperty(_assertThisInitialized(_this), "handleSortBy", function (headerKey) {
        return function () {
          _this.setState(function (state) {
            return getNextSortState(_this.props, state, {
              key: headerKey
            });
          });
        };
      });

      _defineProperty(_assertThisInitialized(_this), "handleOnInputValueChange", function (event) {
        if (event.target) {
          _this.setState({
            filterInputValue: event.target.value
          });
        }
      });

      _this.state = _objectSpread2({}, getDerivedStateFromProps(_props, {}), {
        isExpandedAll: false // Start with collapsed state, treat `undefined` as neutral state

      });
      _this.instanceId = getInstanceId();
      return _this;
    }

    _createClass(DataTable, [{
      key: "UNSAFE_componentWillReceiveProps",
      value: function UNSAFE_componentWillReceiveProps(nextProps) {
        var rowIds = this.props.rows.map(function (row) {
          return row.id;
        });
        var nextRowIds = nextProps.rows.map(function (row) {
          return row.id;
        });

        if (!lodash_isequal(rowIds, nextRowIds)) {
          this.setState(function (state) {
            return getDerivedStateFromProps(nextProps, state);
          });
          return;
        }

        var headers = this.props.headers.map(function (header) {
          return header.key;
        });
        var nextHeaders = nextProps.headers.map(function (header) {
          return header.key;
        });

        if (!lodash_isequal(headers, nextHeaders)) {
          this.setState(function (state) {
            return getDerivedStateFromProps(nextProps, state);
          });
          return;
        }

        if (!lodash_isequal(this.props.rows, nextProps.rows)) {
          this.setState(function (state) {
            return getDerivedStateFromProps(nextProps, state);
          });
          return;
        }
      }
      /**
       * Get the props associated with the given header. Mostly used for adding in
       * sorting behavior.
       *
       * @param {object} config
       * @param {string} config.header the header we want the props for
       * @param {Function} config.onClick a custom click handler for the header
       * @returns {object}
       */

    }, {
      key: "render",
      value: function render() {
        var _this2 = this;

        var _this$props2 = this.props,
            children = _this$props2.children,
            filterRows = _this$props2.filterRows,
            headers = _this$props2.headers,
            render = _this$props2.render;
        var _this$state3 = this.state,
            filterInputValue = _this$state3.filterInputValue,
            rowIds = _this$state3.rowIds,
            rowsById = _this$state3.rowsById,
            cellsById = _this$state3.cellsById;
        var filteredRowIds = typeof filterInputValue === 'string' ? filterRows({
          rowIds: rowIds,
          headers: headers,
          cellsById: cellsById,
          inputValue: filterInputValue
        }) : rowIds;
        var renderProps = {
          // Data derived from state
          rows: denormalize(filteredRowIds, rowsById, cellsById),
          headers: this.props.headers,
          selectedRows: denormalize(this.getSelectedRows(), rowsById, cellsById),
          // Prop accessors/getters
          getHeaderProps: this.getHeaderProps,
          getExpandHeaderProps: this.getExpandHeaderProps,
          getRowProps: this.getRowProps,
          getSelectionProps: this.getSelectionProps,
          getBatchActionProps: this.getBatchActionProps,
          getTableProps: this.getTableProps,
          // Custom event handlers
          onInputChange: this.handleOnInputValueChange,
          // Expose internal state change actions
          sortBy: function sortBy(headerKey) {
            return _this2.handleSortBy(headerKey)();
          },
          selectAll: this.handleSelectAll,
          selectRow: function selectRow(rowId) {
            return _this2.handleOnSelectRow(rowId)();
          },
          expandRow: function expandRow(rowId) {
            return _this2.handleOnExpandRow(rowId)();
          },
          expandAll: this.handleOnExpandAll,
          radio: this.props.radio
        };

        if (render !== undefined) {
          return render(renderProps);
        }

        if (children !== undefined) {
          return children(renderProps);
        }

        return null;
      }
    }]);

    return DataTable;
  }(React__default.Component);

  _defineProperty(DataTable$1, "propTypes", {
    /**
     * The `rows` prop is where you provide us with a list of all the rows that
     * you want to render in the table. The only hard requirement is that this
     * is an array of objects, and that each object has a unique `id` field
     * available on it.
     */
    rows: PropTypes__default.arrayOf(PropTypes__default.shape({
      id: PropTypes__default.string.isRequired,
      disabled: PropTypes__default.bool,
      isSelected: PropTypes__default.bool,
      isExpanded: PropTypes__default.bool
    })).isRequired,

    /**
     * The `headers` prop represents the order in which the headers should
     * appear in the table. We expect an array of objects to be passed in, where
     * `key` is the name of the key in a row object, and `header` is the name of
     * the header.
     */
    headers: PropTypes__default.arrayOf(PropTypes__default.shape({
      key: PropTypes__default.string.isRequired,
      header: PropTypes__default.node.isRequired
    })).isRequired,

    /**
     * Optional hook to manually control sorting of the rows.
     */
    sortRow: PropTypes__default.func,

    /**
     * Optional hook to manually control filtering of the rows from the
     * TableToolbarSearch component
     */
    filterRows: PropTypes__default.func,

    /**
     * Provide a string for the current locale
     */
    locale: PropTypes__default.string,

    /**
     * Optional method that takes in a message id and returns an
     * internationalized string. See `DataTable.translationKeys` for all
     * available message ids.
     */
    translateWithId: PropTypes__default.func,

    /**
     * Specify whether the control should be a radio button or inline checkbox
     */
    radio: PropTypes__default.bool
  });

  _defineProperty(DataTable$1, "defaultProps", {
    sortRow: defaultSortRow,
    filterRows: defaultFilterRows,
    locale: 'en',
    translateWithId: translateWithId
  });

  _defineProperty(DataTable$1, "translationKeys", Object.values(translationKeys));

  var prefix$r = settings_1.prefix;
  var Table = function Table(_ref) {
    var _cx;

    var className = _ref.className,
        children = _ref.children,
        useZebraStyles = _ref.useZebraStyles,
        size = _ref.size,
        isSortable = _ref.isSortable,
        useStaticWidth = _ref.useStaticWidth,
        shouldShowBorder = _ref.shouldShowBorder,
        other = _objectWithoutProperties(_ref, ["className", "children", "useZebraStyles", "size", "isSortable", "useStaticWidth", "shouldShowBorder"]);

    var componentClass = classNames("".concat(prefix$r, "--data-table"), className, (_cx = {}, _defineProperty(_cx, "".concat(prefix$r, "--data-table--compact"), size === 'compact'), _defineProperty(_cx, "".concat(prefix$r, "--data-table--short"), size === 'short'), _defineProperty(_cx, "".concat(prefix$r, "--data-table--tall"), size === 'tall'), _defineProperty(_cx, "".concat(prefix$r, "--data-table--sort"), isSortable), _defineProperty(_cx, "".concat(prefix$r, "--data-table--zebra"), useZebraStyles), _defineProperty(_cx, "".concat(prefix$r, "--data-table--static"), useStaticWidth), _defineProperty(_cx, "".concat(prefix$r, "--data-table--no-border"), !shouldShowBorder), _cx));
    return React__default.createElement("table", _extends({}, other, {
      className: componentClass
    }), children);
  };
  Table.propTypes = {
    className: PropTypes__default.string,

    /**
     * `true` to add useZebraStyles striping.
     */
    useZebraStyles: PropTypes__default.bool,

    /**
     * `normal` Change the row height of table
     */
    size: PropTypes__default.oneOf(['compact', 'short', 'normal', 'tall']),

    /**
     * `false` If true, will use a width of 'auto' instead of 100%
     */
    useStaticWidth: PropTypes__default.bool,

    /**
     * `false` If true, will remove the table border
     */
    shouldShowBorder: PropTypes__default.bool,

    /**
     * `false` If true, will apply sorting styles
     */
    isSortable: PropTypes__default.bool
  };
  Table.defaultProps = {
    isSortable: false
  };

  var wrapComponent = function wrapComponent(_ref) {
    var name = _ref.name,
        className = _ref.className,
        type = _ref.type;

    var Component = function Component(_ref2) {
      var baseClassName = _ref2.className,
          other = _objectWithoutProperties(_ref2, ["className"]);

      var componentClass = classNames(className, baseClassName);
      return React__default.createElement(type, _objectSpread2({}, other, {
        // Prevent Weird quirk where `cx` will evaluate to an empty string, '',
        // and so we have empty `class` attributes in the resulting markup
        // eslint-disable-next-line no-extra-boolean-cast
        className: !!componentClass ? componentClass : undefined
      }));
    };

    Component.displayName = name;
    Component.propTypes = {
      className: PropTypes__default.string
    };
    return Component;
  };

  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */
  var prefix$s = settings_1.prefix;
  var TableActionList = wrapComponent({
    name: 'TableActionList',
    type: 'div',
    className: "".concat(prefix$s, "--action-list")
  });

  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */

  var TableBatchAction = function TableBatchAction(props) {
    return React__default.createElement(Button, props);
  };

  TableBatchAction.propTypes = {
    /**
     * Provide a text description for the icon in the button
     */
    iconDescription: PropTypes__default.string.isRequired,

    /**
     * Optional function to render your own icon in the underlying button
     */
    renderIcon: PropTypes__default.oneOfType([PropTypes__default.func, PropTypes__default.object])
  };
  TableBatchAction.defaultProps = {
    iconDescription: 'Add',
    renderIcon: AddFilled16
  };

  var prefix$t = settings_1.prefix;
  var translationKeys$1 = {
    'carbon.table.batch.cancel': 'Cancel',
    'carbon.table.batch.items.selected': 'items selected',
    'carbon.table.batch.item.selected': 'item selected'
  };

  var translateWithId$1 = function translateWithId(id, state) {
    if (id === 'carbon.table.batch.cancel') {
      return translationKeys$1[id];
    }

    return "".concat(state.totalSelected, " ").concat(translationKeys$1[id]);
  };

  var TableBatchActions = function TableBatchActions(_ref) {
    var _cx;

    var className = _ref.className,
        children = _ref.children,
        shouldShowBatchActions = _ref.shouldShowBatchActions,
        totalSelected = _ref.totalSelected,
        onCancel = _ref.onCancel,
        t = _ref.translateWithId,
        rest = _objectWithoutProperties(_ref, ["className", "children", "shouldShowBatchActions", "totalSelected", "onCancel", "translateWithId"]);

    var batchActionsClasses = classNames((_cx = {}, _defineProperty(_cx, "".concat(prefix$t, "--batch-actions"), true), _defineProperty(_cx, "".concat(prefix$t, "--batch-actions--active"), shouldShowBatchActions), _cx), className);
    return React__default.createElement("div", _extends({}, rest, {
      className: batchActionsClasses
    }), React__default.createElement(TableActionList, null, children, React__default.createElement(Button, {
      className: "".concat(prefix$t, "--batch-summary__cancel"),
      onClick: onCancel
    }, t('carbon.table.batch.cancel'))), React__default.createElement("div", {
      className: "".concat(prefix$t, "--batch-summary")
    }, React__default.createElement("p", {
      className: "".concat(prefix$t, "--batch-summary__para")
    }, React__default.createElement("span", null, totalSelected > 1 ? t('carbon.table.batch.items.selected', {
      totalSelected: totalSelected
    }) : t('carbon.table.batch.item.selected', {
      totalSelected: totalSelected
    })))));
  };

  TableBatchActions.translationKeys = Object.keys(translationKeys$1);
  TableBatchActions.propTypes = {
    children: PropTypes__default.node,
    className: PropTypes__default.string,

    /**
     * Boolean specifier for whether or not the batch action bar should be
     * displayed
     */
    shouldShowBatchActions: PropTypes__default.bool,

    /**
     * Numeric representation of the total number of items selected in a table.
     * This number is used to derive the selection message
     */
    totalSelected: PropTypes__default.number.isRequired,

    /**
     * Hook required to listen for when the user initiates a cancel request
     * through this comopnent
     */
    onCancel: PropTypes__default.func.isRequired,

    /**
     * Supply a method to translate internal strings with your i18n tool of
     * choice. Translation keys are avabile on the `translationKeys` field for
     * this component.
     */
    translateWithId: PropTypes__default.func
  };
  TableBatchActions.defaultProps = {
    translateWithId: translateWithId$1
  };

  var TableBody = function TableBody(_ref) {
    var children = _ref.children,
        className = _ref.className,
        rest = _objectWithoutProperties(_ref, ["children", "className"]);

    return React__default.createElement("tbody", _extends({
      className: className
    }, rest), children);
  };

  TableBody.propTypes = {
    className: PropTypes__default.string,
    children: PropTypes__default.node,

    /**
     * `polite` Adjust the notification behavior of screen readers
     */
    'aria-live': PropTypes__default.oneOf(['polite', 'assertive', 'off'])
  };
  TableBody.defaultProps = {
    'aria-live': 'polite'
  };

  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */
  var TableCell = wrapComponent({
    name: 'TableCell',
    type: 'td'
  });

  var prefix$u = settings_1.prefix;

  var TableContainer = function TableContainer(_ref) {
    var className = _ref.className,
        children = _ref.children,
        title = _ref.title,
        description = _ref.description,
        rest = _objectWithoutProperties(_ref, ["className", "children", "title", "description"]);

    var tableContainerClasses = classNames(className, "".concat(prefix$u, "--data-table-container"));
    return React__default.createElement("div", _extends({}, rest, {
      className: tableContainerClasses
    }), title && React__default.createElement("div", {
      className: "".concat(prefix$u, "--data-table-header")
    }, React__default.createElement("h4", {
      className: "".concat(prefix$u, "--data-table-header__title")
    }, title), React__default.createElement("p", {
      className: "".concat(prefix$u, "--data-table-header__description")
    }, description)), children);
  };

  TableContainer.propTypes = {
    className: PropTypes__default.string,
    children: PropTypes__default.node,

    /**
     * Provide a title for the Table
     */
    title: PropTypes__default.node,

    /**
     * Optional description text for the Table
     */
    description: PropTypes__default.node
  };

  var prefix$v = settings_1.prefix;

  var TableExpandHeader = function TableExpandHeader(_ref) {
    var ariaLabel = _ref.ariaLabel,
        headerClassName = _ref.className,
        enableExpando = _ref.enableExpando,
        isExpanded = _ref.isExpanded,
        onExpand = _ref.onExpand,
        expandIconDescription = _ref.expandIconDescription,
        rest = _objectWithoutProperties(_ref, ["ariaLabel", "className", "enableExpando", "isExpanded", "onExpand", "expandIconDescription"]);

    var className = classNames("".concat(prefix$v, "--table-expand"), headerClassName);
    var previousValue = isExpanded ? 'collapsed' : undefined;
    return React__default.createElement("th", _extends({
      scope: "col",
      className: className,
      "data-previous-value": previousValue
    }, rest), !enableExpando ? null : React__default.createElement("button", {
      className: "".concat(prefix$v, "--table-expand__button"),
      onClick: onExpand,
      title: expandIconDescription,
      "aria-label": ariaLabel
    }, React__default.createElement(ChevronRight16, {
      className: "".concat(prefix$v, "--table-expand__svg"),
      "aria-label": expandIconDescription
    })));
  };

  var prefix$w = settings_1.prefix;

  var TableExpandRow = function TableExpandRow(_ref) {
    var _cx;

    var ariaLabel = _ref.ariaLabel,
        rowClassName = _ref.className,
        children = _ref.children,
        isExpanded = _ref.isExpanded,
        onExpand = _ref.onExpand,
        expandIconDescription = _ref.expandIconDescription,
        isSelected = _ref.isSelected,
        expandHeader = _ref.expandHeader,
        rest = _objectWithoutProperties(_ref, ["ariaLabel", "className", "children", "isExpanded", "onExpand", "expandIconDescription", "isSelected", "expandHeader"]);

    var className = classNames((_cx = {}, _defineProperty(_cx, "".concat(prefix$w, "--parent-row"), true), _defineProperty(_cx, "".concat(prefix$w, "--expandable-row"), isExpanded), _defineProperty(_cx, "".concat(prefix$w, "--data-table--selected"), isSelected), _cx), rowClassName);
    var previousValue = isExpanded ? 'collapsed' : undefined;
    return React__default.createElement("tr", _extends({}, rest, {
      className: className,
      "data-parent-row": true
    }), React__default.createElement(TableCell, {
      className: "".concat(prefix$w, "--table-expand"),
      "data-previous-value": previousValue,
      headers: expandHeader
    }, React__default.createElement("button", {
      className: "".concat(prefix$w, "--table-expand__button"),
      onClick: onExpand,
      title: expandIconDescription,
      "aria-label": ariaLabel
    }, React__default.createElement(ChevronRight16, {
      className: "".concat(prefix$w, "--table-expand__svg"),
      "aria-label": expandIconDescription
    }))), children);
  };

  TableExpandRow.propTypes = {
    /**
     * Specify the string read by a voice reader when the expand trigger is
     * focused
     */
    ariaLabel: PropTypes__default.string.isRequired,
    className: PropTypes__default.string,
    children: PropTypes__default.node,

    /**
     * Specify whether this row is expanded or not. This helps coordinate data
     * attributes so that `TableExpandRow` and `TableExapndedRow` work together
     */
    isExpanded: PropTypes__default.bool.isRequired,

    /**
     * Hook for when a listener initiates a request to expand the given row
     */
    onExpand: PropTypes__default.func.isRequired,

    /**
     * The description of the chevron right icon, to be put in its SVG `<title>` element.
     */
    expandIconDescription: PropTypes__default.string,

    /**
     * The id of the matching th node in the table head. Addresses a11y concerns outlined here: https://www.ibm.com/able/guidelines/ci162/info_and_relationships.html and https://www.w3.org/TR/WCAG20-TECHS/H43
     */
    expandHeader: PropTypes__default.string
  };
  TableExpandRow.defaultProps = {
    expandHeader: 'expand'
  };

  var prefix$x = settings_1.prefix;

  var TableExpandedRow = function TableExpandedRow(_ref) {
    var customClassName = _ref.className,
        children = _ref.children,
        colSpan = _ref.colSpan,
        rest = _objectWithoutProperties(_ref, ["className", "children", "colSpan"]);

    var rowRef = React.useRef(null);
    var className = classNames("".concat(prefix$x, "--expandable-row"), customClassName);

    var toggleParentHoverClass = function toggleParentHoverClass(eventType) {
      if (rowRef && rowRef.current && rowRef.current.previousElementSibling) {
        var parentNode = rowRef.current.previousElementSibling;

        if (eventType === 'enter') {
          parentNode.classList.add("".concat(prefix$x, "--expandable-row--hover"));
        } else {
          parentNode.classList.remove("".concat(prefix$x, "--expandable-row--hover"));
        }
      }
    };

    return React__default.createElement("tr", _extends({
      ref: rowRef,
      onMouseEnter: function onMouseEnter() {
        return toggleParentHoverClass('enter');
      },
      onMouseLeave: function onMouseLeave() {
        return toggleParentHoverClass('leave');
      }
    }, rest, {
      className: className,
      "data-child-row": true
    }), React__default.createElement(TableCell, {
      colSpan: colSpan
    }, React__default.createElement("div", {
      className: "".concat(prefix$x, "--child-row-inner-container")
    }, children)));
  };

  TableExpandedRow.propTypes = {
    /**
     * Pass in the contents for your TableExpandedRow
     */
    children: PropTypes__default.node,

    /**
     * Specify an optional className to be applied to the container node
     */
    className: PropTypes__default.string,

    /**
     * The width of the expanded row's internal cell
     */
    colSpan: PropTypes__default.number.isRequired
  };

  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */
  var TableHead = wrapComponent({
    name: 'TableHead',
    type: 'thead'
  });

  var _sortDirections;
  var prefix$y = settings_1.prefix;
  var translationKeys$2 = {
    iconDescription: 'carbon.table.header.icon.description'
  };

  var translateWithId$2 = function translateWithId(key, _ref) {
    var sortDirection = _ref.sortDirection,
        isSortHeader = _ref.isSortHeader,
        sortStates = _ref.sortStates;

    if (key === translationKeys$2.iconDescription) {
      if (isSortHeader) {
        // When transitioning, we know that the sequence of states is as follows:
        // NONE -> ASC -> DESC -> NONE
        if (sortDirection === sortStates.NONE) {
          return 'Sort rows by this header in ascending order';
        }

        if (sortDirection === sortStates.ASC) {
          return 'Sort rows by this header in descending order';
        }

        return 'Unsort rows by this header';
      }

      return 'Sort rows by this header in ascending order';
    }

    return '';
  };

  var sortDirections = (_sortDirections = {}, _defineProperty(_sortDirections, sortStates.NONE, 'none'), _defineProperty(_sortDirections, sortStates.ASC, 'ascending'), _defineProperty(_sortDirections, sortStates.DESC, 'descending'), _sortDirections);

  var TableHeader = function TableHeader(_ref2) {
    var _cx;

    var headerClassName = _ref2.className,
        children = _ref2.children,
        isSortable = _ref2.isSortable,
        isSortHeader = _ref2.isSortHeader,
        onClick = _ref2.onClick,
        scope = _ref2.scope,
        sortDirection = _ref2.sortDirection,
        t = _ref2.translateWithId,
        rest = _objectWithoutProperties(_ref2, ["className", "children", "isSortable", "isSortHeader", "onClick", "scope", "sortDirection", "translateWithId"]);

    if (!isSortable) {
      return React__default.createElement("th", _extends({}, rest, {
        className: headerClassName,
        scope: scope
      }), React__default.createElement("span", {
        className: "".concat(prefix$y, "--table-header-label")
      }, children));
    }

    var className = classNames(headerClassName, (_cx = {}, _defineProperty(_cx, "".concat(prefix$y, "--table-sort"), true), _defineProperty(_cx, "".concat(prefix$y, "--table-sort--active"), isSortHeader && sortDirection !== sortStates.NONE), _defineProperty(_cx, "".concat(prefix$y, "--table-sort--ascending"), isSortHeader && sortDirection === sortStates.DESC), _cx));
    var ariaSort = !isSortHeader ? 'none' : sortDirections[sortDirection];
    return React__default.createElement("th", {
      scope: scope,
      className: headerClassName,
      "aria-sort": ariaSort
    }, React__default.createElement("button", _extends({
      className: className,
      onClick: onClick
    }, rest), React__default.createElement("span", {
      className: "".concat(prefix$y, "--table-header-label")
    }, children), React__default.createElement(ArrowUp20, {
      className: "".concat(prefix$y, "--table-sort__icon"),
      "aria-label": t('carbon.table.header.icon.description', {
        header: children,
        sortDirection: sortDirection,
        isSortHeader: isSortHeader,
        sortStates: sortStates
      })
    }), React__default.createElement(ArrowsVertical20, {
      className: "".concat(prefix$y, "--table-sort__icon-unsorted"),
      "aria-label": t('carbon.table.header.icon.description', {
        header: children,
        sortDirection: sortDirection,
        isSortHeader: isSortHeader,
        sortStates: sortStates
      })
    })));
  };

  TableHeader.propTypes = {
    /**
     * Specify an optional className to be applied to the container node
     */
    className: PropTypes__default.string,

    /**
     * Pass in children that will be embedded in the table header label
     */
    children: PropTypes__default.node,

    /**
     * Specify whether this header is one through which a user can sort the table
     */
    isSortable: PropTypes__default.bool,

    /**
     * Specify whether this header is the header by which a table is being sorted
     * by
     */
    isSortHeader: PropTypes__default.bool,

    /**
     * Hook that is invoked when the header is clicked
     */
    onClick: PropTypes__default.func,

    /**
     * Specify the scope of this table header. You can find more info about this
     * attribute at the following URL:
     * https://developer.mozilla.org/en-US/docs/Web/HTML/Element/th#attr-scope
     */
    scope: PropTypes__default.string.isRequired,

    /**
     * Specify which direction we are currently sorting by, should be one of DESC,
     * NONE, or ASC.
     */
    sortDirection: PropTypes__default.oneOf(Object.values(sortStates)),

    /**
     * Supply a method to translate internal strings with your i18n tool of
     * choice. Translation keys are avabile on the `translationKeys` field for
     * this component.
     */
    translateWithId: PropTypes__default.func
  };
  TableHeader.defaultProps = {
    isSortable: false,
    scope: 'col',
    translateWithId: translateWithId$2
  };
  TableHeader.translationKeys = Object.values(translationKeys$2);

  /**
   * lodash (Custom Build) <https://lodash.com/>
   * Build: `lodash modularize exports="npm" -o ./`
   * Copyright jQuery Foundation and other contributors <https://jquery.org/>
   * Released under MIT license <https://lodash.com/license>
   * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
   * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
   */

  /** Used as the size to enable large array optimizations. */

  var LARGE_ARRAY_SIZE = 200;
  /** Used to stand-in for `undefined` hash values. */

  var HASH_UNDEFINED = '__lodash_hash_undefined__';
  /** Used as references for various `Number` constants. */

  var INFINITY = 1 / 0,
      MAX_SAFE_INTEGER = 9007199254740991;
  /** `Object#toString` result references. */

  var argsTag = '[object Arguments]',
      funcTag = '[object Function]',
      genTag = '[object GeneratorFunction]',
      symbolTag$1 = '[object Symbol]';
  /**
   * Used to match `RegExp`
   * [syntax characters](http://ecma-international.org/ecma-262/7.0/#sec-patterns).
   */

  var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;
  /** Used to detect host constructors (Safari). */

  var reIsHostCtor = /^\[object .+?Constructor\]$/;
  /** Used to detect unsigned integer values. */

  var reIsUint = /^(?:0|[1-9]\d*)$/;
  /** Detect free variable `global` from Node.js. */

  var freeGlobal$1 = typeof commonjsGlobal == 'object' && commonjsGlobal && commonjsGlobal.Object === Object && commonjsGlobal;
  /** Detect free variable `self`. */

  var freeSelf$1 = typeof self == 'object' && self && self.Object === Object && self;
  /** Used as a reference to the global object. */

  var root$1 = freeGlobal$1 || freeSelf$1 || Function('return this')();
  /**
   * A faster alternative to `Function#apply`, this function invokes `func`
   * with the `this` binding of `thisArg` and the arguments of `args`.
   *
   * @private
   * @param {Function} func The function to invoke.
   * @param {*} thisArg The `this` binding of `func`.
   * @param {Array} args The arguments to invoke `func` with.
   * @returns {*} Returns the result of `func`.
   */

  function apply(func, thisArg, args) {
    switch (args.length) {
      case 0:
        return func.call(thisArg);

      case 1:
        return func.call(thisArg, args[0]);

      case 2:
        return func.call(thisArg, args[0], args[1]);

      case 3:
        return func.call(thisArg, args[0], args[1], args[2]);
    }

    return func.apply(thisArg, args);
  }
  /**
   * A specialized version of `_.includes` for arrays without support for
   * specifying an index to search from.
   *
   * @private
   * @param {Array} [array] The array to inspect.
   * @param {*} target The value to search for.
   * @returns {boolean} Returns `true` if `target` is found, else `false`.
   */


  function arrayIncludes(array, value) {
    var length = array ? array.length : 0;
    return !!length && baseIndexOf(array, value, 0) > -1;
  }
  /**
   * This function is like `arrayIncludes` except that it accepts a comparator.
   *
   * @private
   * @param {Array} [array] The array to inspect.
   * @param {*} target The value to search for.
   * @param {Function} comparator The comparator invoked per element.
   * @returns {boolean} Returns `true` if `target` is found, else `false`.
   */


  function arrayIncludesWith(array, value, comparator) {
    var index = -1,
        length = array ? array.length : 0;

    while (++index < length) {
      if (comparator(value, array[index])) {
        return true;
      }
    }

    return false;
  }
  /**
   * A specialized version of `_.map` for arrays without support for iteratee
   * shorthands.
   *
   * @private
   * @param {Array} [array] The array to iterate over.
   * @param {Function} iteratee The function invoked per iteration.
   * @returns {Array} Returns the new mapped array.
   */


  function arrayMap(array, iteratee) {
    var index = -1,
        length = array ? array.length : 0,
        result = Array(length);

    while (++index < length) {
      result[index] = iteratee(array[index], index, array);
    }

    return result;
  }
  /**
   * Appends the elements of `values` to `array`.
   *
   * @private
   * @param {Array} array The array to modify.
   * @param {Array} values The values to append.
   * @returns {Array} Returns `array`.
   */


  function arrayPush(array, values) {
    var index = -1,
        length = values.length,
        offset = array.length;

    while (++index < length) {
      array[offset + index] = values[index];
    }

    return array;
  }
  /**
   * The base implementation of `_.findIndex` and `_.findLastIndex` without
   * support for iteratee shorthands.
   *
   * @private
   * @param {Array} array The array to inspect.
   * @param {Function} predicate The function invoked per iteration.
   * @param {number} fromIndex The index to search from.
   * @param {boolean} [fromRight] Specify iterating from right to left.
   * @returns {number} Returns the index of the matched value, else `-1`.
   */


  function baseFindIndex(array, predicate, fromIndex, fromRight) {
    var length = array.length,
        index = fromIndex + (fromRight ? 1 : -1);

    while (fromRight ? index-- : ++index < length) {
      if (predicate(array[index], index, array)) {
        return index;
      }
    }

    return -1;
  }
  /**
   * The base implementation of `_.indexOf` without `fromIndex` bounds checks.
   *
   * @private
   * @param {Array} array The array to inspect.
   * @param {*} value The value to search for.
   * @param {number} fromIndex The index to search from.
   * @returns {number} Returns the index of the matched value, else `-1`.
   */


  function baseIndexOf(array, value, fromIndex) {
    if (value !== value) {
      return baseFindIndex(array, baseIsNaN, fromIndex);
    }

    var index = fromIndex - 1,
        length = array.length;

    while (++index < length) {
      if (array[index] === value) {
        return index;
      }
    }

    return -1;
  }
  /**
   * The base implementation of `_.isNaN` without support for number objects.
   *
   * @private
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is `NaN`, else `false`.
   */


  function baseIsNaN(value) {
    return value !== value;
  }
  /**
   * The base implementation of `_.times` without support for iteratee shorthands
   * or max array length checks.
   *
   * @private
   * @param {number} n The number of times to invoke `iteratee`.
   * @param {Function} iteratee The function invoked per iteration.
   * @returns {Array} Returns the array of results.
   */


  function baseTimes(n, iteratee) {
    var index = -1,
        result = Array(n);

    while (++index < n) {
      result[index] = iteratee(index);
    }

    return result;
  }
  /**
   * The base implementation of `_.unary` without support for storing metadata.
   *
   * @private
   * @param {Function} func The function to cap arguments for.
   * @returns {Function} Returns the new capped function.
   */


  function baseUnary(func) {
    return function (value) {
      return func(value);
    };
  }
  /**
   * Checks if a cache value for `key` exists.
   *
   * @private
   * @param {Object} cache The cache to query.
   * @param {string} key The key of the entry to check.
   * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
   */


  function cacheHas(cache, key) {
    return cache.has(key);
  }
  /**
   * Gets the value at `key` of `object`.
   *
   * @private
   * @param {Object} [object] The object to query.
   * @param {string} key The key of the property to get.
   * @returns {*} Returns the property value.
   */


  function getValue(object, key) {
    return object == null ? undefined : object[key];
  }
  /**
   * Checks if `value` is a host object in IE < 9.
   *
   * @private
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is a host object, else `false`.
   */


  function isHostObject(value) {
    // Many host objects are `Object` objects that can coerce to strings
    // despite having improperly defined `toString` methods.
    var result = false;

    if (value != null && typeof value.toString != 'function') {
      try {
        result = !!(value + '');
      } catch (e) {}
    }

    return result;
  }
  /**
   * Creates a unary function that invokes `func` with its argument transformed.
   *
   * @private
   * @param {Function} func The function to wrap.
   * @param {Function} transform The argument transform.
   * @returns {Function} Returns the new function.
   */


  function overArg(func, transform) {
    return function (arg) {
      return func(transform(arg));
    };
  }
  /** Used for built-in method references. */


  var arrayProto = Array.prototype,
      funcProto = Function.prototype,
      objectProto$1 = Object.prototype;
  /** Used to detect overreaching core-js shims. */

  var coreJsData = root$1['__core-js_shared__'];
  /** Used to detect methods masquerading as native. */

  var maskSrcKey = function () {
    var uid = /[^.]+$/.exec(coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO || '');
    return uid ? 'Symbol(src)_1.' + uid : '';
  }();
  /** Used to resolve the decompiled source of functions. */


  var funcToString = funcProto.toString;
  /** Used to check objects for own properties. */

  var hasOwnProperty = objectProto$1.hasOwnProperty;
  /**
   * Used to resolve the
   * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
   * of values.
   */

  var objectToString$1 = objectProto$1.toString;
  /** Used to detect if a method is native. */

  var reIsNative = RegExp('^' + funcToString.call(hasOwnProperty).replace(reRegExpChar, '\\$&').replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$');
  /** Built-in value references. */

  var Symbol$1 = root$1.Symbol,
      getPrototype = overArg(Object.getPrototypeOf, Object),
      propertyIsEnumerable = objectProto$1.propertyIsEnumerable,
      splice = arrayProto.splice,
      spreadableSymbol = Symbol$1 ? Symbol$1.isConcatSpreadable : undefined;
  /* Built-in method references for those with the same name as other `lodash` methods. */

  var nativeGetSymbols = Object.getOwnPropertySymbols,
      nativeMax$1 = Math.max;
  /* Built-in method references that are verified to be native. */

  var Map = getNative(root$1, 'Map'),
      nativeCreate = getNative(Object, 'create');
  /**
   * Creates a hash object.
   *
   * @private
   * @constructor
   * @param {Array} [entries] The key-value pairs to cache.
   */

  function Hash(entries) {
    var index = -1,
        length = entries ? entries.length : 0;
    this.clear();

    while (++index < length) {
      var entry = entries[index];
      this.set(entry[0], entry[1]);
    }
  }
  /**
   * Removes all key-value entries from the hash.
   *
   * @private
   * @name clear
   * @memberOf Hash
   */


  function hashClear() {
    this.__data__ = nativeCreate ? nativeCreate(null) : {};
  }
  /**
   * Removes `key` and its value from the hash.
   *
   * @private
   * @name delete
   * @memberOf Hash
   * @param {Object} hash The hash to modify.
   * @param {string} key The key of the value to remove.
   * @returns {boolean} Returns `true` if the entry was removed, else `false`.
   */


  function hashDelete(key) {
    return this.has(key) && delete this.__data__[key];
  }
  /**
   * Gets the hash value for `key`.
   *
   * @private
   * @name get
   * @memberOf Hash
   * @param {string} key The key of the value to get.
   * @returns {*} Returns the entry value.
   */


  function hashGet(key) {
    var data = this.__data__;

    if (nativeCreate) {
      var result = data[key];
      return result === HASH_UNDEFINED ? undefined : result;
    }

    return hasOwnProperty.call(data, key) ? data[key] : undefined;
  }
  /**
   * Checks if a hash value for `key` exists.
   *
   * @private
   * @name has
   * @memberOf Hash
   * @param {string} key The key of the entry to check.
   * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
   */


  function hashHas(key) {
    var data = this.__data__;
    return nativeCreate ? data[key] !== undefined : hasOwnProperty.call(data, key);
  }
  /**
   * Sets the hash `key` to `value`.
   *
   * @private
   * @name set
   * @memberOf Hash
   * @param {string} key The key of the value to set.
   * @param {*} value The value to set.
   * @returns {Object} Returns the hash instance.
   */


  function hashSet(key, value) {
    var data = this.__data__;
    data[key] = nativeCreate && value === undefined ? HASH_UNDEFINED : value;
    return this;
  } // Add methods to `Hash`.


  Hash.prototype.clear = hashClear;
  Hash.prototype['delete'] = hashDelete;
  Hash.prototype.get = hashGet;
  Hash.prototype.has = hashHas;
  Hash.prototype.set = hashSet;
  /**
   * Creates an list cache object.
   *
   * @private
   * @constructor
   * @param {Array} [entries] The key-value pairs to cache.
   */

  function ListCache(entries) {
    var index = -1,
        length = entries ? entries.length : 0;
    this.clear();

    while (++index < length) {
      var entry = entries[index];
      this.set(entry[0], entry[1]);
    }
  }
  /**
   * Removes all key-value entries from the list cache.
   *
   * @private
   * @name clear
   * @memberOf ListCache
   */


  function listCacheClear() {
    this.__data__ = [];
  }
  /**
   * Removes `key` and its value from the list cache.
   *
   * @private
   * @name delete
   * @memberOf ListCache
   * @param {string} key The key of the value to remove.
   * @returns {boolean} Returns `true` if the entry was removed, else `false`.
   */


  function listCacheDelete(key) {
    var data = this.__data__,
        index = assocIndexOf(data, key);

    if (index < 0) {
      return false;
    }

    var lastIndex = data.length - 1;

    if (index == lastIndex) {
      data.pop();
    } else {
      splice.call(data, index, 1);
    }

    return true;
  }
  /**
   * Gets the list cache value for `key`.
   *
   * @private
   * @name get
   * @memberOf ListCache
   * @param {string} key The key of the value to get.
   * @returns {*} Returns the entry value.
   */


  function listCacheGet(key) {
    var data = this.__data__,
        index = assocIndexOf(data, key);
    return index < 0 ? undefined : data[index][1];
  }
  /**
   * Checks if a list cache value for `key` exists.
   *
   * @private
   * @name has
   * @memberOf ListCache
   * @param {string} key The key of the entry to check.
   * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
   */


  function listCacheHas(key) {
    return assocIndexOf(this.__data__, key) > -1;
  }
  /**
   * Sets the list cache `key` to `value`.
   *
   * @private
   * @name set
   * @memberOf ListCache
   * @param {string} key The key of the value to set.
   * @param {*} value The value to set.
   * @returns {Object} Returns the list cache instance.
   */


  function listCacheSet(key, value) {
    var data = this.__data__,
        index = assocIndexOf(data, key);

    if (index < 0) {
      data.push([key, value]);
    } else {
      data[index][1] = value;
    }

    return this;
  } // Add methods to `ListCache`.


  ListCache.prototype.clear = listCacheClear;
  ListCache.prototype['delete'] = listCacheDelete;
  ListCache.prototype.get = listCacheGet;
  ListCache.prototype.has = listCacheHas;
  ListCache.prototype.set = listCacheSet;
  /**
   * Creates a map cache object to store key-value pairs.
   *
   * @private
   * @constructor
   * @param {Array} [entries] The key-value pairs to cache.
   */

  function MapCache(entries) {
    var index = -1,
        length = entries ? entries.length : 0;
    this.clear();

    while (++index < length) {
      var entry = entries[index];
      this.set(entry[0], entry[1]);
    }
  }
  /**
   * Removes all key-value entries from the map.
   *
   * @private
   * @name clear
   * @memberOf MapCache
   */


  function mapCacheClear() {
    this.__data__ = {
      'hash': new Hash(),
      'map': new (Map || ListCache)(),
      'string': new Hash()
    };
  }
  /**
   * Removes `key` and its value from the map.
   *
   * @private
   * @name delete
   * @memberOf MapCache
   * @param {string} key The key of the value to remove.
   * @returns {boolean} Returns `true` if the entry was removed, else `false`.
   */


  function mapCacheDelete(key) {
    return getMapData(this, key)['delete'](key);
  }
  /**
   * Gets the map value for `key`.
   *
   * @private
   * @name get
   * @memberOf MapCache
   * @param {string} key The key of the value to get.
   * @returns {*} Returns the entry value.
   */


  function mapCacheGet(key) {
    return getMapData(this, key).get(key);
  }
  /**
   * Checks if a map value for `key` exists.
   *
   * @private
   * @name has
   * @memberOf MapCache
   * @param {string} key The key of the entry to check.
   * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
   */


  function mapCacheHas(key) {
    return getMapData(this, key).has(key);
  }
  /**
   * Sets the map `key` to `value`.
   *
   * @private
   * @name set
   * @memberOf MapCache
   * @param {string} key The key of the value to set.
   * @param {*} value The value to set.
   * @returns {Object} Returns the map cache instance.
   */


  function mapCacheSet(key, value) {
    getMapData(this, key).set(key, value);
    return this;
  } // Add methods to `MapCache`.


  MapCache.prototype.clear = mapCacheClear;
  MapCache.prototype['delete'] = mapCacheDelete;
  MapCache.prototype.get = mapCacheGet;
  MapCache.prototype.has = mapCacheHas;
  MapCache.prototype.set = mapCacheSet;
  /**
   *
   * Creates an array cache object to store unique values.
   *
   * @private
   * @constructor
   * @param {Array} [values] The values to cache.
   */

  function SetCache(values) {
    var index = -1,
        length = values ? values.length : 0;
    this.__data__ = new MapCache();

    while (++index < length) {
      this.add(values[index]);
    }
  }
  /**
   * Adds `value` to the array cache.
   *
   * @private
   * @name add
   * @memberOf SetCache
   * @alias push
   * @param {*} value The value to cache.
   * @returns {Object} Returns the cache instance.
   */


  function setCacheAdd(value) {
    this.__data__.set(value, HASH_UNDEFINED);

    return this;
  }
  /**
   * Checks if `value` is in the array cache.
   *
   * @private
   * @name has
   * @memberOf SetCache
   * @param {*} value The value to search for.
   * @returns {number} Returns `true` if `value` is found, else `false`.
   */


  function setCacheHas(value) {
    return this.__data__.has(value);
  } // Add methods to `SetCache`.


  SetCache.prototype.add = SetCache.prototype.push = setCacheAdd;
  SetCache.prototype.has = setCacheHas;
  /**
   * Creates an array of the enumerable property names of the array-like `value`.
   *
   * @private
   * @param {*} value The value to query.
   * @param {boolean} inherited Specify returning inherited property names.
   * @returns {Array} Returns the array of property names.
   */

  function arrayLikeKeys(value, inherited) {
    // Safari 8.1 makes `arguments.callee` enumerable in strict mode.
    // Safari 9 makes `arguments.length` enumerable in strict mode.
    var result = isArray(value) || isArguments(value) ? baseTimes(value.length, String) : [];
    var length = result.length,
        skipIndexes = !!length;

    for (var key in value) {
      if ((inherited || hasOwnProperty.call(value, key)) && !(skipIndexes && (key == 'length' || isIndex(key, length)))) {
        result.push(key);
      }
    }

    return result;
  }
  /**
   * Gets the index at which the `key` is found in `array` of key-value pairs.
   *
   * @private
   * @param {Array} array The array to inspect.
   * @param {*} key The key to search for.
   * @returns {number} Returns the index of the matched value, else `-1`.
   */


  function assocIndexOf(array, key) {
    var length = array.length;

    while (length--) {
      if (eq(array[length][0], key)) {
        return length;
      }
    }

    return -1;
  }
  /**
   * The base implementation of methods like `_.difference` without support
   * for excluding multiple arrays or iteratee shorthands.
   *
   * @private
   * @param {Array} array The array to inspect.
   * @param {Array} values The values to exclude.
   * @param {Function} [iteratee] The iteratee invoked per element.
   * @param {Function} [comparator] The comparator invoked per element.
   * @returns {Array} Returns the new array of filtered values.
   */


  function baseDifference(array, values, iteratee, comparator) {
    var index = -1,
        includes = arrayIncludes,
        isCommon = true,
        length = array.length,
        result = [],
        valuesLength = values.length;

    if (!length) {
      return result;
    }

    if (iteratee) {
      values = arrayMap(values, baseUnary(iteratee));
    }

    if (comparator) {
      includes = arrayIncludesWith;
      isCommon = false;
    } else if (values.length >= LARGE_ARRAY_SIZE) {
      includes = cacheHas;
      isCommon = false;
      values = new SetCache(values);
    }

    outer: while (++index < length) {
      var value = array[index],
          computed = iteratee ? iteratee(value) : value;
      value = comparator || value !== 0 ? value : 0;

      if (isCommon && computed === computed) {
        var valuesIndex = valuesLength;

        while (valuesIndex--) {
          if (values[valuesIndex] === computed) {
            continue outer;
          }
        }

        result.push(value);
      } else if (!includes(values, computed, comparator)) {
        result.push(value);
      }
    }

    return result;
  }
  /**
   * The base implementation of `_.flatten` with support for restricting flattening.
   *
   * @private
   * @param {Array} array The array to flatten.
   * @param {number} depth The maximum recursion depth.
   * @param {boolean} [predicate=isFlattenable] The function invoked per iteration.
   * @param {boolean} [isStrict] Restrict to values that pass `predicate` checks.
   * @param {Array} [result=[]] The initial result value.
   * @returns {Array} Returns the new flattened array.
   */


  function baseFlatten(array, depth, predicate, isStrict, result) {
    var index = -1,
        length = array.length;
    predicate || (predicate = isFlattenable);
    result || (result = []);

    while (++index < length) {
      var value = array[index];

      if (depth > 0 && predicate(value)) {
        if (depth > 1) {
          // Recursively flatten arrays (susceptible to call stack limits).
          baseFlatten(value, depth - 1, predicate, isStrict, result);
        } else {
          arrayPush(result, value);
        }
      } else if (!isStrict) {
        result[result.length] = value;
      }
    }

    return result;
  }
  /**
   * The base implementation of `getAllKeys` and `getAllKeysIn` which uses
   * `keysFunc` and `symbolsFunc` to get the enumerable property names and
   * symbols of `object`.
   *
   * @private
   * @param {Object} object The object to query.
   * @param {Function} keysFunc The function to get the keys of `object`.
   * @param {Function} symbolsFunc The function to get the symbols of `object`.
   * @returns {Array} Returns the array of property names and symbols.
   */


  function baseGetAllKeys(object, keysFunc, symbolsFunc) {
    var result = keysFunc(object);
    return isArray(object) ? result : arrayPush(result, symbolsFunc(object));
  }
  /**
   * The base implementation of `_.isNative` without bad shim checks.
   *
   * @private
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is a native function,
   *  else `false`.
   */


  function baseIsNative(value) {
    if (!isObject$1(value) || isMasked(value)) {
      return false;
    }

    var pattern = isFunction(value) || isHostObject(value) ? reIsNative : reIsHostCtor;
    return pattern.test(toSource(value));
  }
  /**
   * The base implementation of `_.keysIn` which doesn't treat sparse arrays as dense.
   *
   * @private
   * @param {Object} object The object to query.
   * @returns {Array} Returns the array of property names.
   */


  function baseKeysIn(object) {
    if (!isObject$1(object)) {
      return nativeKeysIn(object);
    }

    var isProto = isPrototype(object),
        result = [];

    for (var key in object) {
      if (!(key == 'constructor' && (isProto || !hasOwnProperty.call(object, key)))) {
        result.push(key);
      }
    }

    return result;
  }
  /**
   * The base implementation of `_.pick` without support for individual
   * property identifiers.
   *
   * @private
   * @param {Object} object The source object.
   * @param {string[]} props The property identifiers to pick.
   * @returns {Object} Returns the new object.
   */


  function basePick(object, props) {
    object = Object(object);
    return basePickBy(object, props, function (value, key) {
      return key in object;
    });
  }
  /**
   * The base implementation of  `_.pickBy` without support for iteratee shorthands.
   *
   * @private
   * @param {Object} object The source object.
   * @param {string[]} props The property identifiers to pick from.
   * @param {Function} predicate The function invoked per property.
   * @returns {Object} Returns the new object.
   */


  function basePickBy(object, props, predicate) {
    var index = -1,
        length = props.length,
        result = {};

    while (++index < length) {
      var key = props[index],
          value = object[key];

      if (predicate(value, key)) {
        result[key] = value;
      }
    }

    return result;
  }
  /**
   * The base implementation of `_.rest` which doesn't validate or coerce arguments.
   *
   * @private
   * @param {Function} func The function to apply a rest parameter to.
   * @param {number} [start=func.length-1] The start position of the rest parameter.
   * @returns {Function} Returns the new function.
   */


  function baseRest(func, start) {
    start = nativeMax$1(start === undefined ? func.length - 1 : start, 0);
    return function () {
      var args = arguments,
          index = -1,
          length = nativeMax$1(args.length - start, 0),
          array = Array(length);

      while (++index < length) {
        array[index] = args[start + index];
      }

      index = -1;
      var otherArgs = Array(start + 1);

      while (++index < start) {
        otherArgs[index] = args[index];
      }

      otherArgs[start] = array;
      return apply(func, this, otherArgs);
    };
  }
  /**
   * Creates an array of own and inherited enumerable property names and
   * symbols of `object`.
   *
   * @private
   * @param {Object} object The object to query.
   * @returns {Array} Returns the array of property names and symbols.
   */


  function getAllKeysIn(object) {
    return baseGetAllKeys(object, keysIn, getSymbolsIn);
  }
  /**
   * Gets the data for `map`.
   *
   * @private
   * @param {Object} map The map to query.
   * @param {string} key The reference key.
   * @returns {*} Returns the map data.
   */


  function getMapData(map, key) {
    var data = map.__data__;
    return isKeyable(key) ? data[typeof key == 'string' ? 'string' : 'hash'] : data.map;
  }
  /**
   * Gets the native function at `key` of `object`.
   *
   * @private
   * @param {Object} object The object to query.
   * @param {string} key The key of the method to get.
   * @returns {*} Returns the function if it's native, else `undefined`.
   */


  function getNative(object, key) {
    var value = getValue(object, key);
    return baseIsNative(value) ? value : undefined;
  }
  /**
   * Creates an array of the own enumerable symbol properties of `object`.
   *
   * @private
   * @param {Object} object The object to query.
   * @returns {Array} Returns the array of symbols.
   */


  var getSymbols = nativeGetSymbols ? overArg(nativeGetSymbols, Object) : stubArray;
  /**
   * Creates an array of the own and inherited enumerable symbol properties
   * of `object`.
   *
   * @private
   * @param {Object} object The object to query.
   * @returns {Array} Returns the array of symbols.
   */

  var getSymbolsIn = !nativeGetSymbols ? stubArray : function (object) {
    var result = [];

    while (object) {
      arrayPush(result, getSymbols(object));
      object = getPrototype(object);
    }

    return result;
  };
  /**
   * Checks if `value` is a flattenable `arguments` object or array.
   *
   * @private
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is flattenable, else `false`.
   */

  function isFlattenable(value) {
    return isArray(value) || isArguments(value) || !!(spreadableSymbol && value && value[spreadableSymbol]);
  }
  /**
   * Checks if `value` is a valid array-like index.
   *
   * @private
   * @param {*} value The value to check.
   * @param {number} [length=MAX_SAFE_INTEGER] The upper bounds of a valid index.
   * @returns {boolean} Returns `true` if `value` is a valid index, else `false`.
   */


  function isIndex(value, length) {
    length = length == null ? MAX_SAFE_INTEGER : length;
    return !!length && (typeof value == 'number' || reIsUint.test(value)) && value > -1 && value % 1 == 0 && value < length;
  }
  /**
   * Checks if `value` is suitable for use as unique object key.
   *
   * @private
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is suitable, else `false`.
   */


  function isKeyable(value) {
    var type = typeof value;
    return type == 'string' || type == 'number' || type == 'symbol' || type == 'boolean' ? value !== '__proto__' : value === null;
  }
  /**
   * Checks if `func` has its source masked.
   *
   * @private
   * @param {Function} func The function to check.
   * @returns {boolean} Returns `true` if `func` is masked, else `false`.
   */


  function isMasked(func) {
    return !!maskSrcKey && maskSrcKey in func;
  }
  /**
   * Checks if `value` is likely a prototype object.
   *
   * @private
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is a prototype, else `false`.
   */


  function isPrototype(value) {
    var Ctor = value && value.constructor,
        proto = typeof Ctor == 'function' && Ctor.prototype || objectProto$1;
    return value === proto;
  }
  /**
   * This function is like
   * [`Object.keys`](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)
   * except that it includes inherited enumerable properties.
   *
   * @private
   * @param {Object} object The object to query.
   * @returns {Array} Returns the array of property names.
   */


  function nativeKeysIn(object) {
    var result = [];

    if (object != null) {
      for (var key in Object(object)) {
        result.push(key);
      }
    }

    return result;
  }
  /**
   * Converts `value` to a string key if it's not a string or symbol.
   *
   * @private
   * @param {*} value The value to inspect.
   * @returns {string|symbol} Returns the key.
   */


  function toKey(value) {
    if (typeof value == 'string' || isSymbol$1(value)) {
      return value;
    }

    var result = value + '';
    return result == '0' && 1 / value == -INFINITY ? '-0' : result;
  }
  /**
   * Converts `func` to its source code.
   *
   * @private
   * @param {Function} func The function to process.
   * @returns {string} Returns the source code.
   */


  function toSource(func) {
    if (func != null) {
      try {
        return funcToString.call(func);
      } catch (e) {}

      try {
        return func + '';
      } catch (e) {}
    }

    return '';
  }
  /**
   * Performs a
   * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
   * comparison between two values to determine if they are equivalent.
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Lang
   * @param {*} value The value to compare.
   * @param {*} other The other value to compare.
   * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
   * @example
   *
   * var object = { 'a': 1 };
   * var other = { 'a': 1 };
   *
   * _.eq(object, object);
   * // => true
   *
   * _.eq(object, other);
   * // => false
   *
   * _.eq('a', 'a');
   * // => true
   *
   * _.eq('a', Object('a'));
   * // => false
   *
   * _.eq(NaN, NaN);
   * // => true
   */


  function eq(value, other) {
    return value === other || value !== value && other !== other;
  }
  /**
   * Checks if `value` is likely an `arguments` object.
   *
   * @static
   * @memberOf _
   * @since 0.1.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is an `arguments` object,
   *  else `false`.
   * @example
   *
   * _.isArguments(function() { return arguments; }());
   * // => true
   *
   * _.isArguments([1, 2, 3]);
   * // => false
   */


  function isArguments(value) {
    // Safari 8.1 makes `arguments.callee` enumerable in strict mode.
    return isArrayLikeObject(value) && hasOwnProperty.call(value, 'callee') && (!propertyIsEnumerable.call(value, 'callee') || objectToString$1.call(value) == argsTag);
  }
  /**
   * Checks if `value` is classified as an `Array` object.
   *
   * @static
   * @memberOf _
   * @since 0.1.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is an array, else `false`.
   * @example
   *
   * _.isArray([1, 2, 3]);
   * // => true
   *
   * _.isArray(document.body.children);
   * // => false
   *
   * _.isArray('abc');
   * // => false
   *
   * _.isArray(_.noop);
   * // => false
   */


  var isArray = Array.isArray;
  /**
   * Checks if `value` is array-like. A value is considered array-like if it's
   * not a function and has a `value.length` that's an integer greater than or
   * equal to `0` and less than or equal to `Number.MAX_SAFE_INTEGER`.
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is array-like, else `false`.
   * @example
   *
   * _.isArrayLike([1, 2, 3]);
   * // => true
   *
   * _.isArrayLike(document.body.children);
   * // => true
   *
   * _.isArrayLike('abc');
   * // => true
   *
   * _.isArrayLike(_.noop);
   * // => false
   */

  function isArrayLike(value) {
    return value != null && isLength(value.length) && !isFunction(value);
  }
  /**
   * This method is like `_.isArrayLike` except that it also checks if `value`
   * is an object.
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is an array-like object,
   *  else `false`.
   * @example
   *
   * _.isArrayLikeObject([1, 2, 3]);
   * // => true
   *
   * _.isArrayLikeObject(document.body.children);
   * // => true
   *
   * _.isArrayLikeObject('abc');
   * // => false
   *
   * _.isArrayLikeObject(_.noop);
   * // => false
   */


  function isArrayLikeObject(value) {
    return isObjectLike$1(value) && isArrayLike(value);
  }
  /**
   * Checks if `value` is classified as a `Function` object.
   *
   * @static
   * @memberOf _
   * @since 0.1.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is a function, else `false`.
   * @example
   *
   * _.isFunction(_);
   * // => true
   *
   * _.isFunction(/abc/);
   * // => false
   */


  function isFunction(value) {
    // The use of `Object#toString` avoids issues with the `typeof` operator
    // in Safari 8-9 which returns 'object' for typed array and other constructors.
    var tag = isObject$1(value) ? objectToString$1.call(value) : '';
    return tag == funcTag || tag == genTag;
  }
  /**
   * Checks if `value` is a valid array-like length.
   *
   * **Note:** This method is loosely based on
   * [`ToLength`](http://ecma-international.org/ecma-262/7.0/#sec-tolength).
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is a valid length, else `false`.
   * @example
   *
   * _.isLength(3);
   * // => true
   *
   * _.isLength(Number.MIN_VALUE);
   * // => false
   *
   * _.isLength(Infinity);
   * // => false
   *
   * _.isLength('3');
   * // => false
   */


  function isLength(value) {
    return typeof value == 'number' && value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
  }
  /**
   * Checks if `value` is the
   * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
   * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
   *
   * @static
   * @memberOf _
   * @since 0.1.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is an object, else `false`.
   * @example
   *
   * _.isObject({});
   * // => true
   *
   * _.isObject([1, 2, 3]);
   * // => true
   *
   * _.isObject(_.noop);
   * // => true
   *
   * _.isObject(null);
   * // => false
   */


  function isObject$1(value) {
    var type = typeof value;
    return !!value && (type == 'object' || type == 'function');
  }
  /**
   * Checks if `value` is object-like. A value is object-like if it's not `null`
   * and has a `typeof` result of "object".
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
   * @example
   *
   * _.isObjectLike({});
   * // => true
   *
   * _.isObjectLike([1, 2, 3]);
   * // => true
   *
   * _.isObjectLike(_.noop);
   * // => false
   *
   * _.isObjectLike(null);
   * // => false
   */


  function isObjectLike$1(value) {
    return !!value && typeof value == 'object';
  }
  /**
   * Checks if `value` is classified as a `Symbol` primitive or object.
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
   * @example
   *
   * _.isSymbol(Symbol.iterator);
   * // => true
   *
   * _.isSymbol('abc');
   * // => false
   */


  function isSymbol$1(value) {
    return typeof value == 'symbol' || isObjectLike$1(value) && objectToString$1.call(value) == symbolTag$1;
  }
  /**
   * Creates an array of the own and inherited enumerable property names of `object`.
   *
   * **Note:** Non-object values are coerced to objects.
   *
   * @static
   * @memberOf _
   * @since 3.0.0
   * @category Object
   * @param {Object} object The object to query.
   * @returns {Array} Returns the array of property names.
   * @example
   *
   * function Foo() {
   *   this.a = 1;
   *   this.b = 2;
   * }
   *
   * Foo.prototype.c = 3;
   *
   * _.keysIn(new Foo);
   * // => ['a', 'b', 'c'] (iteration order is not guaranteed)
   */


  function keysIn(object) {
    return isArrayLike(object) ? arrayLikeKeys(object, true) : baseKeysIn(object);
  }
  /**
   * The opposite of `_.pick`; this method creates an object composed of the
   * own and inherited enumerable string keyed properties of `object` that are
   * not omitted.
   *
   * @static
   * @since 0.1.0
   * @memberOf _
   * @category Object
   * @param {Object} object The source object.
   * @param {...(string|string[])} [props] The property identifiers to omit.
   * @returns {Object} Returns the new object.
   * @example
   *
   * var object = { 'a': 1, 'b': '2', 'c': 3 };
   *
   * _.omit(object, ['a', 'c']);
   * // => { 'b': '2' }
   */


  var omit = baseRest(function (object, props) {
    if (object == null) {
      return {};
    }

    props = arrayMap(baseFlatten(props, 1), toKey);
    return basePick(object, baseDifference(getAllKeysIn(object), props));
  });
  /**
   * This method returns a new empty array.
   *
   * @static
   * @memberOf _
   * @since 4.13.0
   * @category Util
   * @returns {Array} Returns the new empty array.
   * @example
   *
   * var arrays = _.times(2, _.stubArray);
   *
   * console.log(arrays);
   * // => [[], []]
   *
   * console.log(arrays[0] === arrays[1]);
   * // => false
   */

  function stubArray() {
    return [];
  }

  var lodash_omit = omit;

  var prefix$z = settings_1.prefix;

  var TableRow = function TableRow(props) {
    // Remove unnecessary props if provided to this component, these are
    // only useful in `TableExpandRow`
    var className = classNames(props.className, _defineProperty({}, "".concat(prefix$z, "--data-table--selected"), props.isSelected));

    var cleanProps = _objectSpread2({}, lodash_omit(props, ['ariaLabel', 'onExpand', 'isExpanded', 'isSelected']), {
      className: className || undefined
    });

    return React__default.createElement("tr", cleanProps);
  };

  TableRow.propTypes = {
    /**
     * Specify an optional className to be applied to the container node
     */
    className: PropTypes__default.string
  };

  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */

  /**
   * @param {...Ref<Element>} refs List of React refs to merge.
   * @returns {Ref<Element>} Merged React ref.
   */
  var mergeRefs = function mergeRefs() {
    for (var _len = arguments.length, refs = new Array(_len), _key = 0; _key < _len; _key++) {
      refs[_key] = arguments[_key];
    }

    return function (el) {
      refs.forEach(function (ref) {
        // https://github.com/facebook/react/issues/13029#issuecomment-410002316
        if (typeof ref === 'function') {
          ref(el);
        } else if (Object(ref) === ref) {
          ref.current = el;
        }
      });
    };
  };

  var prefix$A = settings_1.prefix;

  var InlineCheckbox =
  /*#__PURE__*/
  function (_React$Component) {
    _inherits(InlineCheckbox, _React$Component);

    function InlineCheckbox() {
      var _getPrototypeOf2;

      var _this;

      _classCallCheck(this, InlineCheckbox);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(InlineCheckbox)).call.apply(_getPrototypeOf2, [this].concat(args)));

      _defineProperty(_assertThisInitialized(_this), "handleRef", function (el) {
        _this.inputNode = el;
      });

      return _this;
    }

    _createClass(InlineCheckbox, [{
      key: "componentDidMount",
      value: function componentDidMount() {
        this.inputNode.indeterminate = this.props.indeterminate;
      }
    }, {
      key: "componentDidUpdate",
      value: function componentDidUpdate(prevProps) {
        if (prevProps.indeterminate !== this.props.indeterminate) {
          this.inputNode.indeterminate = this.props.indeterminate;
        }
      }
    }, {
      key: "render",
      value: function render() {
        var _this$props = this.props,
            id = _this$props.id,
            indeterminate = _this$props.indeterminate,
            checked = _this$props.checked,
            disabled = _this$props.disabled,
            ariaLabel = _this$props.ariaLabel,
            name = _this$props.name,
            _onChange = _this$props.onChange,
            onClick = _this$props.onClick,
            onKeyDown = _this$props.onKeyDown,
            _this$props$title = _this$props.title,
            title = _this$props$title === void 0 ? undefined : _this$props$title,
            ref = _this$props.innerRef;
        var inputProps = {
          id: id,
          name: name,
          onClick: onClick,
          onChange: function onChange(evt) {
            _onChange(evt.target.checked, id, evt);
          },
          onKeyDown: onKeyDown,
          className: "".concat(prefix$A, "--checkbox"),
          type: 'checkbox',
          ref: mergeRefs(ref, this.handleRef),
          checked: false,
          disabled: disabled
        };

        if (checked) {
          inputProps.checked = true;
        }

        if (indeterminate) {
          inputProps.checked = false;
          inputProps['aria-checked'] = 'mixed';
        }

        return React__default.createElement(React__default.Fragment, null, React__default.createElement("input", inputProps),
        /* eslint-disable jsx-a11y/label-has-for,jsx-a11y/label-has-associated-control */
        React__default.createElement("label", {
          htmlFor: id,
          className: "".concat(prefix$A, "--checkbox-label"),
          "aria-label": ariaLabel,
          title: title
        }));
      }
    }]);

    return InlineCheckbox;
  }(React__default.Component);

  _defineProperty(InlineCheckbox, "propTypes", {
    /**
     * Specify the label for the control
     */
    ariaLabel: PropTypes__default.string.isRequired,

    /**
     * Specify whether the underlying control is checked, or not
     */
    checked: PropTypes__default.bool.isRequired,

    /**
     * Specify whether the underlying input control should be disabled
     */
    disabled: PropTypes__default.bool,

    /**
     * Provide an `id` for the underlying input control
     */
    id: PropTypes__default.string.isRequired,

    /**
     * Specify whether the control is in an indterminate state
     */
    indeterminate: PropTypes__default.bool,

    /**
     * Provide a `name` for the underlying input control
     */
    name: PropTypes__default.string.isRequired,

    /**
     * Provide a handler that is invoked when a user clicks on the control
     */
    onClick: PropTypes__default.func,

    /**
     * Provide a handler that is invoked on the key down event for the control
     */
    onKeyDown: PropTypes__default.func,

    /**
     * Provide an optional tooltip for the InlineCheckbox
     */
    title: PropTypes__default.string,

    /**
     * Provide an optional hook that is called each time the input is updated
     */
    onChange: PropTypes__default.func
  });

  _defineProperty(InlineCheckbox, "defaultProps", {
    ariaLabel: '',
    checked: false,
    id: 'inline-checkbox',
    name: '',
    onChange: function onChange() {}
  });

  var InlineCheckbox$1 = (function () {
    var forwardRef = function forwardRef(props, ref) {
      return React__default.createElement(InlineCheckbox, _extends({}, props, {
        innerRef: ref
      }));
    };

    forwardRef.displayName = 'InlineCheckbox';
    return React__default.forwardRef(forwardRef);
  })();

  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */
  var prefix$B = settings_1.prefix;

  var TableSelectAll = function TableSelectAll(_ref) {
    var ariaLabel = _ref.ariaLabel,
        checked = _ref.checked,
        id = _ref.id,
        indeterminate = _ref.indeterminate,
        name = _ref.name,
        onSelect = _ref.onSelect,
        disabled = _ref.disabled,
        className = _ref.className;
    return React__default.createElement("th", {
      scope: "col",
      className: classNames("".concat(prefix$B, "--table-column-checkbox"), className)
    }, React__default.createElement(InlineCheckbox$1, {
      ariaLabel: ariaLabel,
      checked: checked,
      id: id,
      indeterminate: indeterminate,
      name: name,
      onClick: onSelect,
      disabled: disabled
    }));
  };

  TableSelectAll.propTypes = {
    /**
     * Specify the aria label for the underlying input control
     */
    ariaLabel: PropTypes__default.string.isRequired,

    /**
     * Specify whether all items are selected, or not
     */
    checked: PropTypes__default.bool.isRequired,

    /**
     * Provide an `id` for the underlying input control
     */
    id: PropTypes__default.string.isRequired,

    /**
     * Specify whether the selection only has a subset of all items
     */
    indeterminate: PropTypes__default.bool,

    /**
     * Provide a `name` for the underlying input control
     */
    name: PropTypes__default.string.isRequired,

    /**
     * Provide a handler to listen to when a user initiates a selection request
     */
    onSelect: PropTypes__default.func.isRequired,

    /**
     * The CSS class names of the cell that wraps the underlying input control
     */
    className: PropTypes__default.string
  };
  TableSelectAll.defaultProps = {
    ariaLabel: 'Select all rows in the table'
  };

  var prefix$C = settings_1.prefix;

  var RadioButtonSkeleton =
  /*#__PURE__*/
  function (_React$Component) {
    _inherits(RadioButtonSkeleton, _React$Component);

    function RadioButtonSkeleton() {
      _classCallCheck(this, RadioButtonSkeleton);

      return _possibleConstructorReturn(this, _getPrototypeOf(RadioButtonSkeleton).apply(this, arguments));
    }

    _createClass(RadioButtonSkeleton, [{
      key: "render",
      value: function render() {
        var id = this.props.id;
        return React__default.createElement("div", {
          className: "".concat(prefix$C, "--radio-button-wrapper")
        }, React__default.createElement("div", {
          className: "".concat(prefix$C, "--radio-button ").concat(prefix$C, "--skeleton")
        }),
        /* eslint-disable jsx-a11y/label-has-for,jsx-a11y/label-has-associated-control */
        React__default.createElement("label", {
          className: "".concat(prefix$C, "--radio-button__label ").concat(prefix$C, "--skeleton"),
          htmlFor: id
        }));
      }
    }]);

    return RadioButtonSkeleton;
  }(React__default.Component);

  var prefix$D = settings_1.prefix;

  var RadioButton =
  /*#__PURE__*/
  function (_React$Component) {
    _inherits(RadioButton, _React$Component);

    function RadioButton() {
      var _getPrototypeOf2;

      var _this;

      _classCallCheck(this, RadioButton);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(RadioButton)).call.apply(_getPrototypeOf2, [this].concat(args)));

      _defineProperty(_assertThisInitialized(_this), "uid", _this.props.id || uid());

      _defineProperty(_assertThisInitialized(_this), "handleChange", function (evt) {
        _this.props.onChange(_this.props.value, _this.props.name, evt);
      });

      return _this;
    }

    _createClass(RadioButton, [{
      key: "render",
      value: function render() {
        var _this$props = this.props,
            className = _this$props.className,
            labelText = _this$props.labelText,
            labelPosition = _this$props.labelPosition,
            ref = _this$props.innerRef,
            hideLabel = _this$props.hideLabel,
            other = _objectWithoutProperties(_this$props, ["className", "labelText", "labelPosition", "innerRef", "hideLabel"]);

        {
           warning_1(labelPosition !== 'top' && labelPosition !== 'bottom', '`top`/`bottom` values for `labelPosition` property in the `RadioButton` component is deprecated ' + 'and being removed in the next release of `carbon-components-react`.') ;
        }

        var innerLabelClasses = classNames(_defineProperty({}, "".concat(prefix$D, "--visually-hidden"), hideLabel));
        var wrapperClasses = classNames(className, "".concat(prefix$D, "--radio-button-wrapper"), _defineProperty({}, "".concat(prefix$D, "--radio-button-wrapper--label-").concat(labelPosition), labelPosition !== 'right'));
        return React__default.createElement("div", {
          className: wrapperClasses
        }, React__default.createElement("input", _extends({}, other, {
          type: "radio",
          className: "".concat(prefix$D, "--radio-button"),
          onChange: this.handleChange,
          id: this.uid,
          ref: ref
        })), React__default.createElement("label", {
          htmlFor: this.uid,
          className: "".concat(prefix$D, "--radio-button__label"),
          "aria-label": labelText
        }, React__default.createElement("span", {
          className: "".concat(prefix$D, "--radio-button__appearance")
        }), React__default.createElement("span", {
          className: innerLabelClasses
        }, labelText)));
      }
    }]);

    return RadioButton;
  }(React__default.Component);

  _defineProperty(RadioButton, "propTypes", {
    /**
     * Specify whether the <RadioButton> is currently checked
     */
    checked: PropTypes__default.bool,

    /**
     * Provide an optional className to be applied to the containing node
     */
    className: PropTypes__default.string,

    /**
     * Specify whether the <RadioButton> should be checked by default
     */
    defaultChecked: PropTypes__default.bool,

    /**
     * Specify whether the control is disabled
     */
    disabled: PropTypes__default.bool,

    /**
     * Provide a unique id for the underlying <input> node
     */
    id: PropTypes__default.string,

    /**
     * Provide label text to be read by screen readers when interacting with the
     * control
     */
    labelText: PropTypes__default.node.isRequired,

    /**
     * Specify whether the label should be hidden, or not
     */
    hideLabel: PropTypes__default.bool,

    /**
     * Provide where label text should be placed
     * NOTE: `top`/`bottom` are deprecated
     */
    labelPosition: PropTypes__default.oneOf(['top', 'right', 'bottom', 'left']),

    /**
     * Provide a name for the underlying <input> node
     */
    name: PropTypes__default.string,

    /**
     * Provide a handler that is invoked when a user clicks on the control
     */
    onClick: PropTypes__default.func,

    /**
     * Provide an optional `onChange` hook that is called each time the value of
     * the underlying <input> changes
     */
    onChange: PropTypes__default.func,

    /**
     * Specify the value of the <RadioButton>
     */
    value: PropTypes__default.oneOfType([PropTypes__default.string, PropTypes__default.number]).isRequired
  });

  _defineProperty(RadioButton, "defaultProps", {
    labelText: '',
    labelPosition: 'right',
    onChange: function onChange() {},
    value: ''
  });

  var RadioButton$1 = (function () {
    var forwardRef = function forwardRef(props, ref) {
      return React__default.createElement(RadioButton, _extends({}, props, {
        innerRef: ref
      }));
    };

    forwardRef.displayName = 'RadioButton';
    return React__default.forwardRef(forwardRef);
  })();

  var TableSelectRow = function TableSelectRow(_ref) {
    var ariaLabel = _ref.ariaLabel,
        checked = _ref.checked,
        id = _ref.id,
        name = _ref.name,
        onSelect = _ref.onSelect,
        disabled = _ref.disabled,
        radio = _ref.radio,
        className = _ref.className;
    var selectionInputProps = {
      id: id,
      name: name,
      onClick: onSelect,
      checked: checked,
      disabled: disabled
    };
    var InlineInputComponent = radio ? RadioButton$1 : InlineCheckbox$1;
    return React__default.createElement("td", {
      className: className
    }, React__default.createElement(InlineInputComponent, _extends({}, selectionInputProps, radio && {
      labelText: ariaLabel,
      hideLabel: true
    }, !radio && {
      ariaLabel: ariaLabel
    })));
  };

  TableSelectRow.propTypes = {
    /**
     * Specify the aria label for the underlying input control
     */
    ariaLabel: PropTypes__default.string.isRequired,

    /**
     * Specify whether all items are selected, or not
     */
    checked: PropTypes__default.bool.isRequired,

    /**
     * Specify whether the control is disabled
     */
    disabled: PropTypes__default.bool,

    /**
     * Provide an `id` for the underlying input control
     */
    id: PropTypes__default.string.isRequired,

    /**
     * Provide a `name` for the underlying input control
     */
    name: PropTypes__default.string.isRequired,

    /**
     * Provide a handler to listen to when a user initiates a selection request
     */
    onSelect: PropTypes__default.func.isRequired,

    /**
     * Specify whether the control should be a radio button or inline checkbox
     */
    radio: PropTypes__default.bool,

    /**
     * The CSS class names of the cell that wraps the underlying input control
     */
    className: PropTypes__default.string
  };

  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */
  var prefix$E = settings_1.prefix;

  var TableToolbar = function TableToolbar(_ref) {
    var children = _ref.children;
    return React__default.createElement("section", {
      "aria-label": "data table toolbar",
      className: "".concat(prefix$E, "--table-toolbar")
    }, children);
  };

  var prefix$F = settings_1.prefix;

  var OverflowMenuItem =
  /*#__PURE__*/
  function (_React$Component) {
    _inherits(OverflowMenuItem, _React$Component);

    function OverflowMenuItem() {
      var _getPrototypeOf2;

      var _this;

      _classCallCheck(this, OverflowMenuItem);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(OverflowMenuItem)).call.apply(_getPrototypeOf2, [this].concat(args)));

      _defineProperty(_assertThisInitialized(_this), "overflowMenuItem", React__default.createRef());

      _defineProperty(_assertThisInitialized(_this), "setTabFocus", function (evt) {
        if (match(evt, ArrowDown)) {
          _this.props.handleOverflowMenuItemFocus(_this.props.index + 1);
        }

        if (match(evt, ArrowUp)) {
          _this.props.handleOverflowMenuItemFocus(_this.props.index - 1);
        }
      });

      _defineProperty(_assertThisInitialized(_this), "handleClick", function (evt) {
        var _this$props = _this.props,
            onClick = _this$props.onClick,
            closeMenu = _this$props.closeMenu;
        onClick(evt);

        if (closeMenu) {
          closeMenu();
        }
      });

      return _this;
    }

    _createClass(OverflowMenuItem, [{
      key: "render",
      value: function render() {
        var _classNames,
            _this2 = this;

        var _this$props2 = this.props,
            href = _this$props2.href,
            className = _this$props2.className,
            itemText = _this$props2.itemText,
            hasDivider = _this$props2.hasDivider,
            isDelete = _this$props2.isDelete,
            disabled = _this$props2.disabled,
            closeMenu = _this$props2.closeMenu,
            onClick = _this$props2.onClick,
            handleOverflowMenuItemFocus = _this$props2.handleOverflowMenuItemFocus,
            _onKeyDown = _this$props2.onKeyDown,
            primaryFocus = _this$props2.primaryFocus,
            wrapperClassName = _this$props2.wrapperClassName,
            requireTitle = _this$props2.requireTitle,
            index = _this$props2.index,
            other = _objectWithoutProperties(_this$props2, ["href", "className", "itemText", "hasDivider", "isDelete", "disabled", "closeMenu", "onClick", "handleOverflowMenuItemFocus", "onKeyDown", "primaryFocus", "wrapperClassName", "requireTitle", "index"]);

        {
           warning_1(closeMenu, '`<OverflowMenuItem>` detected missing `closeMenu` prop. ' + '`closeMenu` is required to let `<OverflowMenu>` close the menu upon actions on `<OverflowMenuItem>`. ' + 'Please make sure `<OverflowMenuItem>` is a direct child of `<OverflowMenu>.') ;
        }

        var overflowMenuBtnClasses = classNames("".concat(prefix$F, "--overflow-menu-options__btn"), className);
        var overflowMenuItemClasses = classNames("".concat(prefix$F, "--overflow-menu-options__option"), (_classNames = {}, _defineProperty(_classNames, "".concat(prefix$F, "--overflow-menu--divider"), hasDivider), _defineProperty(_classNames, "".concat(prefix$F, "--overflow-menu-options__option--danger"), isDelete), _defineProperty(_classNames, "".concat(prefix$F, "--overflow-menu-options__option--disabled"), disabled), _classNames), wrapperClassName);
        var primaryFocusProp = primaryFocus ? {
          'data-floating-menu-primary-focus': true
        } : {};
        var TagToUse = href ? 'a' : 'button';

        var OverflowMenuItemContent = function () {
          if (typeof itemText !== 'string') {
            return itemText;
          }

          return React__default.createElement("div", {
            className: "".concat(prefix$F, "--overflow-menu-options__option-content")
          }, itemText);
        }();

        return React__default.createElement("li", {
          className: overflowMenuItemClasses,
          role: "menuitem"
        }, React__default.createElement(TagToUse, _extends({}, other, primaryFocusProp, {
          href: href,
          className: overflowMenuBtnClasses,
          disabled: disabled,
          onClick: this.handleClick,
          onKeyDown: function onKeyDown(evt) {
            _this2.setTabFocus(evt);

            _onKeyDown(evt);
          },
          ref: this.overflowMenuItem,
          title: requireTitle ? itemText : null,
          tabIndex: "-1",
          index: index
        }), OverflowMenuItemContent));
      }
    }]);

    return OverflowMenuItem;
  }(React__default.Component);

  _defineProperty(OverflowMenuItem, "propTypes", {
    /**
     * The CSS class name to be placed on the button element
     */
    className: PropTypes__default.string,

    /**
     * The CSS class name to be placed on the wrapper list item element
     */
    wrapperClassName: PropTypes__default.string,

    /**
     * The text in the menu item.
     */
    itemText: PropTypes__default.node.isRequired,

    /**
     * If given, overflow item will render as a link with the given href
     */
    href: PropTypes__default.string,

    /**
     * `true` to make this menu item a divider.
     */
    hasDivider: PropTypes__default.bool,

    /**
     * `true` to make this menu item a "danger button".
     */
    isDelete: PropTypes__default.bool,

    /**
     * `true` to make this menu item disabled.
     */
    disabled: PropTypes__default.bool,

    /**
     * event handlers
     */
    onBlur: PropTypes__default.func,
    onClick: PropTypes__default.func,
    onFocus: PropTypes__default.func,
    onKeyDown: PropTypes__default.func,
    onKeyUp: PropTypes__default.func,
    onMouseDown: PropTypes__default.func,
    onMouseEnter: PropTypes__default.func,
    onMouseLeave: PropTypes__default.func,
    onMouseUp: PropTypes__default.func,

    /**
     * A callback to tell the parent menu component that the menu should be closed.
     */
    closeMenu: PropTypes__default.func,

    /**
     * `true` if this menu item should get focus when the menu gets open.
     */
    primaryFocus: PropTypes__default.bool,

    /**
     * `true` if this menu item has long text and requires a browser tooltip
     */
    requireTitle: PropTypes__default.bool
  });

  _defineProperty(OverflowMenuItem, "defaultProps", {
    hasDivider: false,
    isDelete: false,
    disabled: false,
    itemText: 'Provide itemText',
    onClick: function onClick() {},
    onKeyDown: function onKeyDown() {}
  });

  var TableToolbarAction = function TableToolbarAction(_ref) {
    var children = _ref.children,
        rest = _objectWithoutProperties(_ref, ["children"]);

    return React__default.createElement(OverflowMenuItem, _extends({
      itemText: children
    }, rest));
  };

  TableToolbarAction.propTypes = {
    children: PropTypes__default.node,
    className: PropTypes__default.string,
    onClick: PropTypes__default.func.isRequired
  };

  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */
  var prefix$G = settings_1.prefix;
  var TableToolbarContent = wrapComponent({
    name: 'TableToolbarContent',
    type: 'div',
    className: "".concat(prefix$G, "--toolbar-content")
  });

  var prefix$H = settings_1.prefix;

  var SearchSkeleton =
  /*#__PURE__*/
  function (_Component) {
    _inherits(SearchSkeleton, _Component);

    function SearchSkeleton() {
      _classCallCheck(this, SearchSkeleton);

      return _possibleConstructorReturn(this, _getPrototypeOf(SearchSkeleton).apply(this, arguments));
    }

    _createClass(SearchSkeleton, [{
      key: "render",
      value: function render() {
        var _classNames;

        var _this$props = this.props,
            small = _this$props.small,
            id = _this$props.id;
        var searchClasses = classNames((_classNames = {}, _defineProperty(_classNames, "".concat(prefix$H, "--skeleton"), true), _defineProperty(_classNames, "".concat(prefix$H, "--search--xl"), !small), _defineProperty(_classNames, "".concat(prefix$H, "--search--sm"), small), _classNames));
        return React__default.createElement("div", {
          className: searchClasses,
          role: "search"
        },
        /* eslint-disable jsx-a11y/label-has-for,jsx-a11y/label-has-associated-control */
        React__default.createElement("label", {
          htmlFor: id,
          className: "".concat(prefix$H, "--label")
        }), React__default.createElement("div", {
          className: "".concat(prefix$H, "--search-input")
        }));
      }
    }]);

    return SearchSkeleton;
  }(React.Component);

  _defineProperty(SearchSkeleton, "propTypes", {
    /**
     * Specify whether the Search should be a small variant
     */
    small: PropTypes__default.bool
  });

  _defineProperty(SearchSkeleton, "defaultProps", {
    small: false
  });

  var prefix$I = settings_1.prefix;

  var Search$1 =
  /*#__PURE__*/
  function (_Component) {
    _inherits(Search, _Component);

    function Search() {
      var _getPrototypeOf2;

      var _this;

      _classCallCheck(this, Search);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(Search)).call.apply(_getPrototypeOf2, [this].concat(args)));

      _defineProperty(_assertThisInitialized(_this), "state", {
        hasContent: _this.props.value || _this.props.defaultValue || false,
        prevValue: _this.props.value
      });

      _defineProperty(_assertThisInitialized(_this), "clearInput", function (evt) {
        if (!_this.props.value) {
          _this.input.value = '';

          _this.props.onChange(evt);
        } else {
          var clearedEvt = Object.assign({}, evt.target, {
            target: {
              value: ''
            }
          });

          _this.props.onChange(clearedEvt);
        }

        _this.setState({
          hasContent: false
        }, function () {
          return _this.input.focus();
        });
      });

      _defineProperty(_assertThisInitialized(_this), "handleChange", function (evt) {
        _this.setState({
          hasContent: evt.target.value !== ''
        });

        _this.props.onChange(evt);
      });

      return _this;
    }

    _createClass(Search, [{
      key: "render",
      value: function render() {
        var _classNames,
            _classNames2,
            _this2 = this;

        var _this$props = this.props,
            className = _this$props.className,
            type = _this$props.type,
            _this$props$id = _this$props.id,
            id = _this$props$id === void 0 ? this._inputId = this._inputId || "search__input__id_".concat(Math.random().toString(36).substr(2)) : _this$props$id,
            placeHolderText = _this$props.placeHolderText,
            labelText = _this$props.labelText,
            closeButtonLabelText = _this$props.closeButtonLabelText,
            small = _this$props.small,
            light = _this$props.light,
            other = _objectWithoutProperties(_this$props, ["className", "type", "id", "placeHolderText", "labelText", "closeButtonLabelText", "small", "light"]);

        var hasContent = this.state.hasContent;
        var searchClasses = classNames((_classNames = {}, _defineProperty(_classNames, "".concat(prefix$I, "--search"), true), _defineProperty(_classNames, "".concat(prefix$I, "--search--xl"), !small), _defineProperty(_classNames, "".concat(prefix$I, "--search--sm"), small), _defineProperty(_classNames, "".concat(prefix$I, "--search--light"), light), _defineProperty(_classNames, className, className), _classNames));
        var clearClasses = classNames((_classNames2 = {}, _defineProperty(_classNames2, "".concat(prefix$I, "--search-close"), true), _defineProperty(_classNames2, "".concat(prefix$I, "--search-close--hidden"), !hasContent), _classNames2));
        var CloseIconX = !small ? Close20 : Close16;
        return React__default.createElement("div", {
          className: searchClasses
        }, React__default.createElement(Search16, {
          className: "".concat(prefix$I, "--search-magnifier"),
          role: "img"
        }), React__default.createElement("label", {
          htmlFor: id,
          className: "".concat(prefix$I, "--label")
        }, labelText), React__default.createElement("input", _extends({}, other, {
          type: type,
          className: "".concat(prefix$I, "--search-input"),
          id: id,
          placeholder: placeHolderText,
          onChange: this.handleChange,
          ref: function ref(input) {
            _this2.input = input;
          }
        })), React__default.createElement("button", {
          className: clearClasses,
          onClick: this.clearInput,
          type: "button",
          "aria-label": closeButtonLabelText
        }, React__default.createElement(CloseIconX, {
          "aria-label": closeButtonLabelText,
          role: "img"
        })));
      }
    }], [{
      key: "getDerivedStateFromProps",
      value: function getDerivedStateFromProps(_ref, state) {
        var value = _ref.value;
        var prevValue = state.prevValue;
        return prevValue === value ? null : {
          hasContent: !!value,
          prevValue: value
        };
      }
    }]);

    return Search;
  }(React.Component);

  _defineProperty(Search$1, "propTypes", {
    /**
     * Specify an optional className to be applied to the container node
     */
    className: PropTypes__default.string,

    /**
     * Optional prop to specify the type of the `<input>`
     */
    type: PropTypes__default.string,

    /**
     * Specify whether the Search should be a small variant
     */
    small: PropTypes__default.bool,

    /**
     * Provide an optional placeholder text for the Search.
     * Note: if the label and placeholder differ,
     * VoiceOver on Mac will read both
     */
    placeHolderText: PropTypes__default.string,

    /**
     * Provide an optional label text for the Search icon
     */
    labelText: PropTypes__default.node.isRequired,

    /**
     * Specify light version or default version of this control
     */
    light: PropTypes__default.bool,

    /**
     * Specify a custom `id` for the input
     */
    id: PropTypes__default.string,

    /**
     * Specify a label to be read by screen readers on the "close" button
     */
    closeButtonLabelText: PropTypes__default.string,

    /**
     * Specify the value of the <input>
     */
    value: PropTypes__default.oneOfType([PropTypes__default.string, PropTypes__default.number]),

    /**
     * Optionally provide the default value of the <input>
     */
    defaultValue: PropTypes__default.oneOfType([PropTypes__default.string, PropTypes__default.number])
  });

  _defineProperty(Search$1, "defaultProps", {
    type: 'text',
    small: false,
    placeHolderText: '',
    closeButtonLabelText: 'Clear search input',
    onChange: function onChange() {}
  });

  var prefix$J = settings_1.prefix;
  var getInstanceId$1 = setupGetInstanceId();
  var translationKeys$3 = {
    'carbon.table.toolbar.search.label': 'Filter table',
    'carbon.table.toolbar.search.placeholder': 'Filter table'
  };

  var translateWithId$3 = function translateWithId(id) {
    return translationKeys$3[id];
  };

  var TableToolbarSearch = function TableToolbarSearch(_ref) {
    var _cx;

    var className = _ref.className,
        searchContainerClass = _ref.searchContainerClass,
        onChangeProp = _ref.onChange,
        t = _ref.translateWithId,
        placeHolderText = _ref.placeHolderText,
        labelText = _ref.labelText,
        expandedProp = _ref.expanded,
        defaultExpanded = _ref.defaultExpanded,
        onExpand = _ref.onExpand,
        persistent = _ref.persistent,
        persistant = _ref.persistant,
        _ref$id = _ref.id,
        id = _ref$id === void 0 ? "data-table-search-".concat(getInstanceId$1()) : _ref$id,
        rest = _objectWithoutProperties(_ref, ["className", "searchContainerClass", "onChange", "translateWithId", "placeHolderText", "labelText", "expanded", "defaultExpanded", "onExpand", "persistent", "persistant", "id"]);

    var _useRef = React.useRef(expandedProp !== undefined),
        controlled = _useRef.current;

    var _useState = React.useState(defaultExpanded),
        _useState2 = _slicedToArray(_useState, 2),
        expandedState = _useState2[0],
        setExpandedState = _useState2[1];

    var expanded = controlled ? expandedProp : expandedState;
    var searchRef = React.useRef(null);

    var _useState3 = React.useState(''),
        _useState4 = _slicedToArray(_useState3, 2),
        value = _useState4[0],
        setValue = _useState4[1];

    React.useEffect(function () {
      if (searchRef.current) {
        searchRef.current.querySelector('input').focus();
      }
    });
    var searchContainerClasses = classNames((_cx = {}, _defineProperty(_cx, searchContainerClass, searchContainerClass), _defineProperty(_cx, "".concat(prefix$J, "--toolbar-action"), true), _defineProperty(_cx, "".concat(prefix$J, "--toolbar-search-container-active"), expanded), _defineProperty(_cx, "".concat(prefix$J, "--toolbar-search-container-expandable"), !persistent || !persistent && !persistant), _defineProperty(_cx, "".concat(prefix$J, "--toolbar-search-container-persistent"), persistent || persistant), _cx));
    var searchClasses = classNames(_defineProperty({
      className: className
    }, "".concat(prefix$J, "--search-maginfier"), true));

    var handleExpand = function handleExpand(event) {
      var value = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : !expanded;

      if (!controlled && (!persistent || !persistent && !persistant)) {
        setExpandedState(value);
      }

      if (onExpand) {
        onExpand(event, value);
      }
    };

    var onChange = function onChange(e) {
      setValue(e.target.value);

      if (onChangeProp) {
        onChangeProp(e);
      }
    };

    return React__default.createElement("div", {
      tabIndex: "0",
      role: "searchbox",
      ref: searchRef,
      onClick: function onClick(event) {
        return handleExpand(event, true);
      },
      onFocus: function onFocus(event) {
        return handleExpand(event, true);
      },
      onBlur: function onBlur(event) {
        return !value && handleExpand(event, false);
      },
      className: searchContainerClasses
    }, React__default.createElement(Search$1, _extends({}, rest, {
      small: true,
      className: searchClasses,
      value: value,
      id: id,
      "aria-hidden": !expanded,
      labelText: labelText || t('carbon.table.toolbar.search.label'),
      placeHolderText: placeHolderText || t('carbon.table.toolbar.search.placeholder'),
      onChange: onChange
    })));
  };

  TableToolbarSearch.propTypes = {
    children: PropTypes__default.node,

    /**
     * Provide an optional class name for the search container
     */
    className: PropTypes__default.string,

    /**
     * Provide an optional id for the search container
     */
    id: PropTypes__default.string,

    /**
     * Provide an optional className for the overal container of the Search
     */
    searchContainerClasses: PropTypes__default.string,

    /**
     * Provide an optional hook that is called each time the input is updated
     */
    onChange: PropTypes__default.func,

    /**
     * Provide an optional placeholder text for the Search component
     */
    placeHolderText: PropTypes__default.string,

    /**
     * Provide an optional label text for the Search component icon
     */
    labelText: PropTypes__default.string,

    /**
     * Provide custom text for the component for each translation id
     */
    translateWithId: PropTypes__default.func.isRequired,

    /**
     * Whether the search should be allowed to expand
     */
    persistent: PropTypes__default.bool,
    persistant: deprecate(PropTypes__default.bool, "\nThe prop `persistant` for TableToolbarSearch has been deprecated in favor of `persistent`. Please use `persistent` instead.")
  };
  TableToolbarSearch.defaultProps = {
    translateWithId: translateWithId$3,
    persistent: false
  };

  /**
   * Copyright (c) 2013-present, Facebook, Inc.
   *
   * This source code is licensed under the MIT license found in the
   * LICENSE file in the root directory of this source tree.
   */

  var invariant = function (condition, format, a, b, c, d, e, f) {
    {
      if (format === undefined) {
        throw new Error('invariant requires an error message argument');
      }
    }

    if (!condition) {
      var error;

      if (format === undefined) {
        error = new Error('Minified exception occurred; use the non-minified dev environment ' + 'for the full error message and additional helpful warnings.');
      } else {
        var args = [a, b, c, d, e, f];
        var argIndex = 0;
        error = new Error(format.replace(/%s/g, function () {
          return args[argIndex++];
        }));
        error.name = 'Invariant Violation';
      }

      error.framesToPop = 1; // we don't care about invariant's own frame

      throw error;
    }
  };

  var invariant_1 = invariant;

  /**
   * Generic component used for reacting to a click event happening outside of a
   * given `children` element.
   */

  var ClickListener =
  /*#__PURE__*/
  function (_React$Component) {
    _inherits(ClickListener, _React$Component);

    function ClickListener(props) {
      var _this;

      _classCallCheck(this, ClickListener);

      _this = _possibleConstructorReturn(this, _getPrototypeOf(ClickListener).call(this, props)); // We manually bind handlers in this Component, versus using class
      // properties, so that we can properly test the `handleRef` handler with
      // enzyme.

      _this.handleRef = _this.handleRef.bind(_assertThisInitialized(_this));
      _this.handleDocumentClick = _this.handleDocumentClick.bind(_assertThisInitialized(_this));
      return _this;
    }

    _createClass(ClickListener, [{
      key: "componentDidMount",
      value: function componentDidMount() {
        document.addEventListener('click', this.handleDocumentClick);
      }
    }, {
      key: "componentWillUnmount",
      value: function componentWillUnmount() {
        document.removeEventListener('click', this.handleDocumentClick);
      }
    }, {
      key: "handleDocumentClick",
      value: function handleDocumentClick(evt) {
        if (this.element) {
          if (this.element.contains && !this.element.contains(evt.target)) {
            this.props.onClickOutside(evt);
          }
        }
      }
    }, {
      key: "handleRef",
      value: function handleRef(el) {
        var children = this.props.children;
        this.element = el;
        /**
         * One important note, `children.ref` corresponds to a `ref` prop passed in
         * directly to the child, not necessarily a `ref` defined in the component.
         * This means that here we target the following `ref` location:
         *
         * <ClickListener onClickOutside={() => {}}>
         *   <Child ref={targetedRefHere} />
         * </ClickListener>
         */

        if (children.ref && typeof children.ref === 'function') {
          children.ref(el);
        }
      }
    }, {
      key: "render",
      value: function render() {
        return React__default.cloneElement(this.props.children, {
          ref: this.handleRef
        });
      }
    }]);

    return ClickListener;
  }(React__default.Component);

  _defineProperty(ClickListener, "propTypes", {
    children: PropTypes__default.element.isRequired,
    onClickOutside: PropTypes__default.func.isRequired
  });

  var lib = typeof self === 'object' && self.self === self && self || typeof commonjsGlobal === 'object' && commonjsGlobal.global === commonjsGlobal && commonjsGlobal || commonjsGlobal;

  /**
   * The structure for the position of floating menu.
   * @typedef {Object} FloatingMenu~position
   * @property {number} left The left position.
   * @property {number} top The top position.
   * @property {number} right The right position.
   * @property {number} bottom The bottom position.
   */

  /**
   * The structure for the size of floating menu.
   * @typedef {Object} FloatingMenu~size
   * @property {number} width The width.
   * @property {number} height The height.
   */

  /**
   * The structure for the position offset of floating menu.
   * @typedef {Object} FloatingMenu~offset
   * @property {number} top The top position.
   * @property {number} left The left position.
   */

  var DIRECTION_LEFT$1 = 'left';
  var DIRECTION_TOP$1 = 'top';
  var DIRECTION_RIGHT$1 = 'right';
  var DIRECTION_BOTTOM$1 = 'bottom';
  /**
   * @param {FloatingMenu~offset} [oldMenuOffset={}] The old value.
   * @param {FloatingMenu~offset} [menuOffset={}] The new value.
   * @returns `true` if the parent component wants to change in the adjustment of the floating menu position.
   * @private
   */

  var hasChangeInOffset = function hasChangeInOffset() {
    var oldMenuOffset = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var menuOffset = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    if (_typeof(oldMenuOffset) !== _typeof(menuOffset)) {
      return true;
    } else if (Object(menuOffset) === menuOffset && typeof menuOffset !== 'function') {
      return oldMenuOffset.top !== menuOffset.top || oldMenuOffset.left !== menuOffset.left;
    }

    return oldMenuOffset !== menuOffset;
  };
  /**
   * @param {object} params The parameters.
   * @param {FloatingMenu~size} params.menuSize The size of the menu.
   * @param {FloatingMenu~position} params.refPosition The position of the triggering element.
   * @param {FloatingMenu~offset} [params.offset={ left: 0, top: 0 }] The position offset of the menu.
   * @param {string} [params.direction=bottom] The menu direction.
   * @param {number} [params.scrollX=0] The scroll position of the viewport.
   * @param {number} [params.scrollY=0] The scroll position of the viewport.
   * @returns {FloatingMenu~offset} The position of the menu, relative to the top-left corner of the viewport.
   * @private
   */


  var getFloatingPosition$1 = function getFloatingPosition(_ref) {
    var _DIRECTION_LEFT$DIREC;

    var menuSize = _ref.menuSize,
        refPosition = _ref.refPosition,
        _ref$offset = _ref.offset,
        offset = _ref$offset === void 0 ? {} : _ref$offset,
        _ref$direction = _ref.direction,
        direction = _ref$direction === void 0 ? DIRECTION_BOTTOM$1 : _ref$direction,
        _ref$scrollX = _ref.scrollX,
        scrollX = _ref$scrollX === void 0 ? 0 : _ref$scrollX,
        _ref$scrollY = _ref.scrollY,
        scrollY = _ref$scrollY === void 0 ? 0 : _ref$scrollY;
    var _refPosition$left = refPosition.left,
        refLeft = _refPosition$left === void 0 ? 0 : _refPosition$left,
        _refPosition$top = refPosition.top,
        refTop = _refPosition$top === void 0 ? 0 : _refPosition$top,
        _refPosition$right = refPosition.right,
        refRight = _refPosition$right === void 0 ? 0 : _refPosition$right,
        _refPosition$bottom = refPosition.bottom,
        refBottom = _refPosition$bottom === void 0 ? 0 : _refPosition$bottom;
    var width = menuSize.width,
        height = menuSize.height;
    var _offset$top = offset.top,
        top = _offset$top === void 0 ? 0 : _offset$top,
        _offset$left = offset.left,
        left = _offset$left === void 0 ? 0 : _offset$left;
    var refCenterHorizontal = (refLeft + refRight) / 2;
    var refCenterVertical = (refTop + refBottom) / 2;
    return (_DIRECTION_LEFT$DIREC = {}, _defineProperty(_DIRECTION_LEFT$DIREC, DIRECTION_LEFT$1, function () {
      return {
        left: refLeft - width + scrollX - left,
        top: refCenterVertical - height / 2 + scrollY + top
      };
    }), _defineProperty(_DIRECTION_LEFT$DIREC, DIRECTION_TOP$1, function () {
      return {
        left: refCenterHorizontal - width / 2 + scrollX + left,
        top: refTop - height + scrollY - top
      };
    }), _defineProperty(_DIRECTION_LEFT$DIREC, DIRECTION_RIGHT$1, function () {
      return {
        left: refRight + scrollX + left,
        top: refCenterVertical - height / 2 + scrollY + top
      };
    }), _defineProperty(_DIRECTION_LEFT$DIREC, DIRECTION_BOTTOM$1, function () {
      return {
        left: refCenterHorizontal - width / 2 + scrollX + left,
        top: refBottom + scrollY + top
      };
    }), _DIRECTION_LEFT$DIREC)[direction]();
  };
  /**
   * A menu that is detached from the triggering element.
   * Useful when the container of the triggering element cannot have `overflow:visible` style, etc.
   */


  var FloatingMenu$1 =
  /*#__PURE__*/
  function (_React$Component) {
    _inherits(FloatingMenu, _React$Component);

    function FloatingMenu() {
      var _getPrototypeOf2;

      var _this;

      _classCallCheck(this, FloatingMenu);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(FloatingMenu)).call.apply(_getPrototypeOf2, [this].concat(args)));

      _defineProperty(_assertThisInitialized(_this), "_placeInProgress", false);

      _defineProperty(_assertThisInitialized(_this), "state", {
        /**
         * The position of the menu, relative to the top-left corner of the viewport.
         * @type {FloatingMenu~offset}
         */
        floatingPosition: undefined
      });

      _defineProperty(_assertThisInitialized(_this), "_menuContainer", null);

      _defineProperty(_assertThisInitialized(_this), "_menuBody", null);

      _defineProperty(_assertThisInitialized(_this), "_updateMenuSize", function () {
        var prevProps = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        var menuBody = _this._menuBody;
         warning_1(menuBody, 'The DOM node for menu body for calculating its position is not available. Skipping...') ;

        if (!menuBody) {
          return;
        }

        var _prevProps$menuPositi = prevProps.menuPosition,
            oldRefPosition = _prevProps$menuPositi === void 0 ? {} : _prevProps$menuPositi,
            _prevProps$menuOffset = prevProps.menuOffset,
            oldMenuOffset = _prevProps$menuOffset === void 0 ? {} : _prevProps$menuOffset,
            oldMenuDirection = prevProps.menuDirection;
        var _this$props = _this.props,
            _this$props$menuPosit = _this$props.menuPosition,
            refPosition = _this$props$menuPosit === void 0 ? {} : _this$props$menuPosit,
            _this$props$menuOffse = _this$props.menuOffset,
            menuOffset = _this$props$menuOffse === void 0 ? {} : _this$props$menuOffse,
            menuDirection = _this$props.menuDirection;

        if (oldRefPosition.top !== refPosition.top || oldRefPosition.right !== refPosition.right || oldRefPosition.bottom !== refPosition.bottom || oldRefPosition.left !== refPosition.left || hasChangeInOffset(oldMenuOffset, menuOffset) || oldMenuDirection !== menuDirection) {
          var menuSize = menuBody.getBoundingClientRect();
          var _this$props2 = _this.props,
              menuEl = _this$props2.menuEl,
              flipped = _this$props2.flipped;
          var offset = typeof menuOffset !== 'function' ? menuOffset : menuOffset(menuBody, menuDirection, menuEl, flipped); // Skips if either in the following condition:
          // a) Menu body has `display:none`
          // b) `menuOffset` as a callback returns `undefined` (The callback saw that it couldn't calculate the value)

          if (menuSize.width > 0 && menuSize.height > 0 || !offset) {
            _this.setState({
              floatingPosition: getFloatingPosition$1({
                menuSize: menuSize,
                refPosition: refPosition,
                direction: menuDirection,
                offset: offset,
                scrollX: lib.pageXOffset,
                scrollY: lib.pageYOffset
              })
            });
          }
        }
      });

      _defineProperty(_assertThisInitialized(_this), "_menuRef", function (menuBody) {
        var menuRef = _this.props.menuRef;
        _this._placeInProgress = !!menuBody;
        menuRef && menuRef(_this._menuBody = menuBody);

        if (menuBody) {
          _this._updateMenuSize();
        }
      });

      _defineProperty(_assertThisInitialized(_this), "_getChildrenWithProps", function () {
        var _this$props3 = _this.props,
            styles = _this$props3.styles,
            children = _this$props3.children;
        var pos = _this.state.floatingPosition; // If no pos available, we need to hide the element (offscreen to the left)
        // This is done so we can measure the content before positioning it correctly.

        var positioningStyle = pos ? {
          left: "".concat(pos.left, "px"),
          top: "".concat(pos.top, "px"),
          right: 'auto'
        } : {
          visibility: 'hidden',
          top: '0px'
        };
        return React__default.cloneElement(children, {
          ref: _this._menuRef,
          style: _objectSpread2({}, styles, {}, positioningStyle, {
            position: 'absolute',
            margin: 0,
            opacity: 1
          })
        });
      });

      return _this;
    }

    _createClass(FloatingMenu, [{
      key: "componentDidUpdate",
      value: function componentDidUpdate(prevProps) {
        this._updateMenuSize(prevProps);

        var onPlace = this.props.onPlace;

        if (this._placeInProgress && this.state.floatingPosition && typeof onPlace === 'function') {
          onPlace(this._menuBody);
          this._placeInProgress = false;
        }
      }
      /**
       * A callback for called when menu body is mounted or unmounted.
       * @param {Element} menuBody The menu body being mounted. `null` if the menu body is being unmounted.
       */

    }, {
      key: "render",
      value: function render() {
        if (typeof document !== 'undefined') {
          var target = this.props.target;
          return ReactDOM.createPortal(this._getChildrenWithProps(), !target ? document.body : target());
        }

        return null;
      }
    }]);

    return FloatingMenu;
  }(React__default.Component);

  _defineProperty(FloatingMenu$1, "propTypes", {
    /**
     * Contents to put into the floating menu.
     */
    children: PropTypes__default.object,

    /**
     * The query selector indicating where the floating menu body should be placed.
     */
    target: PropTypes__default.func,

    /**
     * The position in the viewport of the trigger button.
     */
    menuPosition: PropTypes__default.shape({
      top: PropTypes__default.number,
      right: PropTypes__default.number,
      bottom: PropTypes__default.number,
      left: PropTypes__default.number
    }),

    /**
     * Where to put the tooltip, relative to the trigger button.
     */
    menuDirection: PropTypes__default.oneOf([DIRECTION_LEFT$1, DIRECTION_TOP$1, DIRECTION_RIGHT$1, DIRECTION_BOTTOM$1]),

    /**
     * The adjustment of the floating menu position, considering the position of dropdown arrow, etc.
     */
    menuOffset: PropTypes__default.oneOfType([PropTypes__default.shape({
      top: PropTypes__default.number,
      left: PropTypes__default.number
    }), PropTypes__default.func]),

    /**
     * The additional styles to put to the floating menu.
     */
    styles: PropTypes__default.object,

    /**
     * The callback called when the menu body has been mounted to/will be unmounted from the DOM.
     */
    menuRef: PropTypes__default.func,

    /**
     * The callback called when the menu body has been mounted and positioned.
     */
    onPlace: PropTypes__default.func
  });

  _defineProperty(FloatingMenu$1, "defaultProps", {
    menuPosition: {},
    menuOffset: {},
    menuDirection: DIRECTION_BOTTOM$1
  });

  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */

  var OptimizedResize = function optimizedResize() {
    var callbacks = [];
    var running = false; // run the actual callbacks

    function runCallbacks() {
      callbacks.forEach(function (callback) {
        callback();
      });
      running = false;
    } // fired on resize event


    function resize() {
      if (!running) {
        running = true;
        lib.requestAnimationFrame(runCallbacks);
      }
    } // adds callback to loop


    function addCallback(callback) {
      if (callback) {
        var index = callbacks.indexOf(callback);

        if (index < 0) {
          callbacks.push(callback);
        }
      }
    }

    return {
      // public method to add additional callback
      add: function add(callback) {
        if (!callbacks.length) {
          lib.addEventListener('resize', resize);
        }

        addCallback(callback);
        return {
          release: function release() {
            var index = callbacks.indexOf(callback);

            if (index >= 0) {
              callbacks.splice(index, 1);
            }
          }
        };
      }
    };
  }();

  var _triggerButtonPositio, _triggerButtonPositio2;
  var prefix$K = settings_1.prefix;

  var on$1 = function on(element) {
    for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args[_key - 1] = arguments[_key];
    }

    element.addEventListener.apply(element, args);
    return {
      release: function release() {
        element.removeEventListener.apply(element, args);
        return null;
      }
    };
  };
  /**
   * The CSS property names of the arrow keyed by the floating menu direction.
   * @type {Object<string, string>}
   */


  var triggerButtonPositionProps$1 = (_triggerButtonPositio = {}, _defineProperty(_triggerButtonPositio, DIRECTION_TOP$1, 'bottom'), _defineProperty(_triggerButtonPositio, DIRECTION_BOTTOM$1, 'top'), _triggerButtonPositio);
  /**
   * Determines how the position of arrow should affect the floating menu position.
   * @type {Object<string, number>}
   */

  var triggerButtonPositionFactors$1 = (_triggerButtonPositio2 = {}, _defineProperty(_triggerButtonPositio2, DIRECTION_TOP$1, -2), _defineProperty(_triggerButtonPositio2, DIRECTION_BOTTOM$1, -1), _triggerButtonPositio2);
  /**
   * @param {Element} menuBody The menu body with the menu arrow.
   * @param {string} direction The floating menu direction.
   * @returns {FloatingMenu~offset} The adjustment of the floating menu position, upon the position of the menu arrow.
   * @private
   */

  var getMenuOffset$2 = function getMenuOffset(menuBody, direction, trigger, flip) {
    var triggerButtonPositionProp = triggerButtonPositionProps$1[direction];
    var triggerButtonPositionFactor = triggerButtonPositionFactors$1[direction];

    {
      !(triggerButtonPositionProp && triggerButtonPositionFactor) ?  invariant_1(false, '[OverflowMenu] wrong floating menu direction: `%s`', direction)  : void 0;
    }

    var menuWidth = menuBody.offsetWidth,
        menuHeight = menuBody.offsetHeight;

    switch (triggerButtonPositionProp) {
      case 'top':
      case 'bottom':
        {
          // TODO: Ensure `trigger` is there for `<OverflowMenu open>`
          var triggerWidth = !trigger ? 0 : trigger.offsetWidth;
          return {
            left: (!flip ? 1 : -1) * (menuWidth / 2 - triggerWidth / 2),
            top: 0
          };
        }

      case 'left':
      case 'right':
        {
          // TODO: Ensure `trigger` is there for `<OverflowMenu open>`
          var triggerHeight = !trigger ? 0 : trigger.offsetHeight;
          return {
            left: 0,
            top: (!flip ? 1 : -1) * (menuHeight / 2 - triggerHeight / 2)
          };
        }

      default:
        break;
    }
  };

  var OverflowMenu$1 =
  /*#__PURE__*/
  function (_Component) {
    _inherits(OverflowMenu, _Component);

    function OverflowMenu() {
      var _getPrototypeOf2;

      var _this;

      _classCallCheck(this, OverflowMenu);

      for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        args[_key2] = arguments[_key2];
      }

      _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(OverflowMenu)).call.apply(_getPrototypeOf2, [this].concat(args)));

      _defineProperty(_assertThisInitialized(_this), "state", {});

      _defineProperty(_assertThisInitialized(_this), "_hFocusIn", null);

      _defineProperty(_assertThisInitialized(_this), "_hBlurTimeout", void 0);

      _defineProperty(_assertThisInitialized(_this), "getPrimaryFocusableElement", function () {
        if (_this.menuEl) {
          var primaryFocusPropEl = _this.menuEl.querySelector('[data-floating-menu-primary-focus]');

          if (primaryFocusPropEl) {
            return primaryFocusPropEl;
          }
        }

        var firstItem = _this.overflowMenuItem0;

        if (firstItem && firstItem.overflowMenuItem && firstItem.overflowMenuItem.current) {
          return firstItem.overflowMenuItem.current;
        }
      });

      _defineProperty(_assertThisInitialized(_this), "getMenuPosition", function () {
        if (_this.menuEl) {
          var menuPosition = _this.menuEl.getBoundingClientRect();

          _this.setState({
            menuPosition: menuPosition
          });
        }
      });

      _defineProperty(_assertThisInitialized(_this), "handleClick", function (evt) {
        if (!_this._menuBody || !_this._menuBody.contains(evt.target)) {
          _this.setState({
            open: !_this.state.open
          });

          _this.props.onClick(evt);
        }
      });

      _defineProperty(_assertThisInitialized(_this), "handleKeyDown", function (evt) {
        if (matches(evt, [ArrowDown])) {
          _this.setState({
            open: !_this.state.open
          });

          _this.props.onClick(evt);
        }
      });

      _defineProperty(_assertThisInitialized(_this), "handleKeyPress", function (evt) {
        // only respond to key events when the menu is closed, so that menu items still respond to key events
        if (!_this.state.open) {
          if (matches(evt, [Enter, Space])) {
            _this.setState({
              open: true
            });
          }
        } // Close the overflow menu on escape


        if (matches(evt, [Escape])) {
          _this.closeMenu(); // Stop the esc keypress from bubbling out and closing something it shouldn't


          evt.stopPropagation();
          evt.preventDefault();
        }
      });

      _defineProperty(_assertThisInitialized(_this), "handleClickOutside", function (evt) {
        if (!_this._menuBody || !_this._menuBody.contains(evt.target)) {
          _this.closeMenu();
        }
      });

      _defineProperty(_assertThisInitialized(_this), "closeMenu", function () {
        var wasOpen = _this.state.open;

        _this.setState({
          open: false
        }, function () {
          if (wasOpen) {
            _this.focusMenuEl();
          }

          _this.props.onClose();
        });
      });

      _defineProperty(_assertThisInitialized(_this), "bindMenuEl", function (menuEl) {
        _this.menuEl = menuEl;
      });

      _defineProperty(_assertThisInitialized(_this), "focusMenuEl", function () {
        if (_this.menuEl) {
          _this.menuEl.focus();
        }
      });

      _defineProperty(_assertThisInitialized(_this), "handleOverflowMenuItemFocus", function (index) {
        var i = function () {
          switch (index) {
            case -1:
              return React__default.Children.count(_this.props.children) - 1;

            case React__default.Children.count(_this.props.children):
              return 0;

            default:
              return index;
          }
        }();

        var _ref = _this["overflowMenuItem".concat(i)] || React__default.Children.toArray(_this.props.children)[i],
            overflowMenuItem = _ref.overflowMenuItem;

        if (overflowMenuItem && overflowMenuItem.current) {
          overflowMenuItem.current.focus();
        }
      });

      _defineProperty(_assertThisInitialized(_this), "_bindMenuBody", function (menuBody) {
        if (!menuBody) {
          _this._menuBody = menuBody;
        }

        if (!menuBody && _this._hFocusIn) {
          _this._hFocusIn = _this._hFocusIn.release();
        }
      });

      _defineProperty(_assertThisInitialized(_this), "_handlePlace", function (menuBody) {
        if (menuBody) {
          _this._menuBody = menuBody;
          (menuBody.querySelector('[data-floating-menu-primary-focus]') || menuBody).focus();
          var hasFocusin = 'onfocusin' in window;
          var focusinEventName = hasFocusin ? 'focusin' : 'focus';
          _this._hFocusIn = on$1(menuBody.ownerDocument, focusinEventName, function (event) {
            var target = event.target;

            if (!menuBody.contains(target) && _this.menuEl && !target.matches(".".concat(prefix$K, "--overflow-menu,.").concat(prefix$K, "--overflow-menu-options"))) {
              _this.closeMenu();
            }
          }, !hasFocusin);

          _this.props.onOpen();
        }
      });

      _defineProperty(_assertThisInitialized(_this), "_getTarget", function () {
        return _this.menuEl && _this.menuEl.closest('[data-floating-menu-container]') || document.body;
      });

      return _this;
    }

    _createClass(OverflowMenu, [{
      key: "shouldComponentUpdate",
      value: function shouldComponentUpdate(nextProps, nextState) {
        var _this2 = this;

        if (nextState.open && !this.state.open) {
          requestAnimationFrame(function () {
            _this2.getMenuPosition();
          });
          return false; // Let `.getMenuPosition()` cause render
        }

        return true;
      }
    }, {
      key: "componentDidMount",
      value: function componentDidMount() {
        var _this3 = this;

        requestAnimationFrame(function () {
          _this3.getMenuPosition();
        });
        this.hResize = OptimizedResize.add(function () {
          _this3.getMenuPosition();
        });
      }
    }, {
      key: "componentDidUpdate",
      value: function componentDidUpdate() {
        var onClose = this.props.onClose;

        if (!this.state.open) {
          onClose();
        }
      }
    }, {
      key: "componentWillUnmount",
      value: function componentWillUnmount() {
        if (typeof this._hBlurTimeout === 'number') {
          clearTimeout(this._hBlurTimeout);
          this._hBlurTimeout = undefined;
        }

        this.hResize.release();
      }
    }, {
      key: "render",
      value: function render() {
        var _classNames2,
            _this4 = this;

        var _this$props = this.props,
            id = _this$props.id,
            tabIndex = _this$props.tabIndex,
            ariaLabel = _this$props.ariaLabel,
            children = _this$props.children,
            iconDescription = _this$props.iconDescription,
            direction = _this$props.direction,
            flipped = _this$props.flipped,
            menuOffset = _this$props.menuOffset,
            menuOffsetFlip = _this$props.menuOffsetFlip,
            iconClass = _this$props.iconClass,
            onClick = _this$props.onClick,
            onOpen = _this$props.onOpen,
            IconElement = _this$props.renderIcon,
            ref = _this$props.innerRef,
            menuOptionsClass = _this$props.menuOptionsClass,
            other = _objectWithoutProperties(_this$props, ["id", "tabIndex", "ariaLabel", "children", "iconDescription", "direction", "flipped", "menuOffset", "menuOffsetFlip", "iconClass", "onClick", "onOpen", "renderIcon", "innerRef", "menuOptionsClass"]);

        var open = this.state.open;
        var overflowMenuClasses = classNames(this.props.className, "".concat(prefix$K, "--overflow-menu"), _defineProperty({}, "".concat(prefix$K, "--overflow-menu--open"), open));
        var overflowMenuOptionsClasses = classNames(menuOptionsClass, "".concat(prefix$K, "--overflow-menu-options"), (_classNames2 = {}, _defineProperty(_classNames2, "".concat(prefix$K, "--overflow-menu--flip"), this.props.flipped), _defineProperty(_classNames2, "".concat(prefix$K, "--overflow-menu-options--open"), open), _classNames2));
        var overflowMenuIconClasses = classNames("".concat(prefix$K, "--overflow-menu__icon"), iconClass);
        var childrenWithProps = React__default.Children.toArray(children).map(function (child, index) {
          return React__default.cloneElement(child, {
            closeMenu: _this4.closeMenu,
            handleOverflowMenuItemFocus: _this4.handleOverflowMenuItemFocus,
            ref: function ref(e) {
              _this4["overflowMenuItem".concat(index)] = e;
            },
            index: index
          });
        });
        var menuBody = React__default.createElement("ul", {
          className: overflowMenuOptionsClasses,
          tabIndex: "-1",
          role: "menu",
          "aria-label": ariaLabel
        }, childrenWithProps);
        var wrappedMenuBody = React__default.createElement(FloatingMenu$1, {
          menuPosition: this.state.menuPosition,
          menuDirection: direction,
          menuOffset: flipped ? menuOffsetFlip : menuOffset,
          menuRef: this._bindMenuBody,
          menuEl: this.menuEl,
          flipped: this.props.flipped,
          target: this._getTarget,
          onPlace: this._handlePlace
        }, React__default.cloneElement(menuBody, {
          'data-floating-menu-direction': direction
        }));
        var iconProps = {
          onClick: this.handleClick,
          onKeyDown: this.handleKeyDown,
          className: overflowMenuIconClasses,
          'aria-label': iconDescription,
          focusable: 'false' // Prevent `<svg>` in trigger icon from getting focus for IE11

        };
        return React__default.createElement(ClickListener, {
          onClickOutside: this.handleClickOutside
        }, React__default.createElement("div", _extends({}, other, {
          role: "button",
          "aria-haspopup": true,
          "aria-expanded": this.state.open,
          className: overflowMenuClasses,
          onKeyDown: this.handleKeyPress,
          onBlur: this.handleBlur,
          onClick: this.handleClick,
          "aria-label": ariaLabel,
          id: id,
          tabIndex: tabIndex,
          ref: mergeRefs(ref, this.bindMenuEl)
        }), React__default.createElement(IconElement, iconProps, iconDescription && React__default.createElement("title", null, iconDescription)), open && wrappedMenuBody));
      }
    }], [{
      key: "getDerivedStateFromProps",
      value: function getDerivedStateFromProps(_ref2, state) {
        var open = _ref2.open;
        var prevOpen = state.prevOpen;
        return prevOpen === open ? null : {
          open: open,
          prevOpen: open
        };
      }
    }]);

    return OverflowMenu;
  }(React.Component);

  _defineProperty(OverflowMenu$1, "propTypes", {
    /**
     * `true` if the menu should be open.
     */
    open: PropTypes__default.bool,

    /**
     * The menu direction.
     */
    direction: PropTypes__default.oneOf([DIRECTION_TOP$1, DIRECTION_BOTTOM$1]),

    /**
     * `true` if the menu alignment should be flipped.
     */
    flipped: PropTypes__default.bool,

    /**
     * The child nodes.
     */
    children: PropTypes__default.node,

    /**
     * The CSS class names.
     */
    className: PropTypes__default.string,

    /**
     * The `tabindex` attribute.
     */
    tabIndex: PropTypes__default.number,

    /**
     * The element ID.
     */
    id: PropTypes__default.string,

    /**
     * The ARIA label.
     */
    ariaLabel: PropTypes__default.string,

    /**
     * The event handler for the `click` event.
     */
    onClick: PropTypes__default.func,

    /**
     * The event handler for the `focus` event.
     */
    onFocus: PropTypes__default.func,

    /**
     * The event handler for the `keydown` event.
     */
    onKeyDown: PropTypes__default.func,

    /**
     * The icon description.
     */
    iconDescription: PropTypes__default.string.isRequired,

    /**
     * The adjustment in position applied to the floating menu.
     */
    menuOffset: PropTypes__default.oneOfType([PropTypes__default.shape({
      top: PropTypes__default.number,
      left: PropTypes__default.number
    }), PropTypes__default.func]),

    /**
     * The adjustment in position applied to the floating menu.
     */
    menuOffsetFlip: PropTypes__default.oneOfType([PropTypes__default.shape({
      top: PropTypes__default.number,
      left: PropTypes__default.number
    }), PropTypes__default.func]),

    /**
     * The CSS class for the icon.
     */
    iconClass: PropTypes__default.string,

    /**
     * Function called to override icon rendering.
     */
    renderIcon: PropTypes__default.oneOfType([PropTypes__default.func, PropTypes__default.object]),

    /**
     * Function called when menu is closed
     */
    onClose: PropTypes__default.func,

    /**
     * The class to apply to the menu options
     */
    menuOptionsClass: PropTypes__default.string,

    /**
     * Function called when menu is closed
     */
    onOpen: PropTypes__default.func
  });

  _defineProperty(OverflowMenu$1, "defaultProps", {
    ariaLabel: 'Menu',
    iconDescription: 'open and close list of options',
    open: false,
    direction: DIRECTION_BOTTOM$1,
    flipped: false,
    renderIcon: OverflowMenuVertical16,
    onClick: function onClick() {},
    onKeyDown: function onKeyDown() {},
    onClose: function onClose() {},
    onOpen: function onOpen() {},
    tabIndex: 0,
    menuOffset: getMenuOffset$2,
    menuOffsetFlip: getMenuOffset$2
  });

  var OverflowMenu$2 = (function () {
    var forwardRef = function forwardRef(props, ref) {
      return React__default.createElement(OverflowMenu$1, _extends({}, props, {
        innerRef: ref
      }));
    };

    forwardRef.displayName = 'OverflowMenu';
    return React__default.forwardRef(forwardRef);
  })();

  var prefix$L = settings_1.prefix;

  var TableToolbarMenu = function TableToolbarMenu(_ref) {
    var className = _ref.className,
        renderIcon = _ref.renderIcon,
        iconDescription = _ref.iconDescription,
        children = _ref.children,
        rest = _objectWithoutProperties(_ref, ["className", "renderIcon", "iconDescription", "children"]);

    var toolbarActionClasses = classNames(className, "".concat(prefix$L, "--toolbar-action ").concat(prefix$L, "--overflow-menu"));
    return React__default.createElement(OverflowMenu$2, _extends({
      renderIcon: renderIcon,
      className: toolbarActionClasses,
      title: iconDescription,
      flipped: true
    }, rest), children);
  };

  TableToolbarMenu.defaultProps = {
    renderIcon: Settings16,
    iconDescription: 'Settings'
  };
  TableToolbarMenu.propTypes = {
    children: PropTypes__default.node.isRequired,

    /**
     * Provide an optional class name for the toolbar menu
     */
    className: PropTypes__default.string,

    /**
     * Optional prop to allow overriding the default menu icon
     */
    renderIcon: PropTypes__default.oneOfType([PropTypes__default.func, PropTypes__default.object]),

    /**
     * The description of the menu icon.
     */
    iconDescription: PropTypes__default.string.isRequired
  };

  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */
  DataTable$1.Table = Table;
  DataTable$1.TableActionList = TableActionList;
  DataTable$1.TableBatchAction = TableBatchAction;
  DataTable$1.TableBatchActions = TableBatchActions;
  DataTable$1.TableBody = TableBody;
  DataTable$1.TableCell = TableCell;
  DataTable$1.TableContainer = TableContainer;
  DataTable$1.TableExpandHeader = TableExpandHeader;
  DataTable$1.TableExpandRow = TableExpandRow;
  DataTable$1.TableExpandedRow = TableExpandedRow;
  DataTable$1.TableHead = TableHead;
  DataTable$1.TableHeader = TableHeader;
  DataTable$1.TableRow = TableRow;
  DataTable$1.TableSelectAll = TableSelectAll;
  DataTable$1.TableSelectRow = TableSelectRow;
  DataTable$1.TableToolbar = TableToolbar;
  DataTable$1.TableToolbarAction = TableToolbarAction;
  DataTable$1.TableToolbarContent = TableToolbarContent;
  DataTable$1.TableToolbarSearch = TableToolbarSearch;
  DataTable$1.TableToolbarMenu = TableToolbarMenu;

  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */
  var prefix$M = settings_1.prefix;

  var DatePickerSkeleton = function DatePickerSkeleton(_ref) {
    var range = _ref.range,
        id = _ref.id;
    var dateInput = React__default.createElement("div", {
      className: "".concat(prefix$M, "--date-picker-container")
    },
    /* eslint-disable jsx-a11y/label-has-for,jsx-a11y/label-has-associated-control */
    React__default.createElement("label", {
      className: "".concat(prefix$M, "--label"),
      htmlFor: id
    }), React__default.createElement("div", {
      className: "".concat(prefix$M, "--date-picker__input ").concat(prefix$M, "--skeleton")
    }));

    if (range) {
      return React__default.createElement("div", {
        className: "".concat(prefix$M, "--form-item")
      }, React__default.createElement("div", {
        className: "".concat(prefix$M, "--date-picker ").concat(prefix$M, "--date-picker--range ").concat(prefix$M, "--skeleton")
      }, dateInput, dateInput));
    }

    return React__default.createElement("div", {
      className: "".concat(prefix$M, "--form-item")
    }, React__default.createElement("div", {
      className: "".concat(prefix$M, "--date-picker ").concat(prefix$M, "--date-picker--short ").concat(prefix$M, "--date-picker--simple ").concat(prefix$M, "--skeleton")
    }, dateInput));
  };

  DatePickerSkeleton.propTypes = {
    /**
     * Specify whether the skeleton should be of range date picker.
     */
    range: PropTypes__default.bool
  };

  var l10n = createCommonjsModule(function (module, exports) {
    (function (global, factory) {
       factory(exports) ;
    })(commonjsGlobal, function (exports) {
      /*! *****************************************************************************
      Copyright (c) Microsoft Corporation. All rights reserved.
      Licensed under the Apache License, Version 2.0 (the "License"); you may not use
      this file except in compliance with the License. You may obtain a copy of the
      License at http://www.apache.org/licenses/LICENSE-2.0
        THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
      KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
      WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
      MERCHANTABLITY OR NON-INFRINGEMENT.
        See the Apache Version 2.0 License for specific language governing permissions
      and limitations under the License.
      ***************************************************************************** */

      var __assign = function () {
        __assign = Object.assign || function __assign(t) {
          for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];

            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
          }

          return t;
        };

        return __assign.apply(this, arguments);
      };

      var fp = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Arabic = {
        weekdays: {
          shorthand: ["أحد", "اثنين", "ثلاثاء", "أربعاء", "خميس", "جمعة", "سبت"],
          longhand: ["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"]
        },
        months: {
          shorthand: ["1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"],
          longhand: ["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"]
        },
        rangeSeparator: ' - '
      };
      fp.l10ns.ar = Arabic;
      fp.l10ns;
      var fp$1 = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Austria = {
        weekdays: {
          shorthand: ["So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"],
          longhand: ["Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag"]
        },
        months: {
          shorthand: ["Jän", "Feb", "Mär", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dez"],
          longhand: ["Jänner", "Februar", "März", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"]
        },
        firstDayOfWeek: 1,
        weekAbbreviation: "KW",
        rangeSeparator: " bis ",
        scrollTitle: "Zum Ändern scrollen",
        toggleTitle: "Zum Umschalten klicken"
      };
      fp$1.l10ns.at = Austria;
      fp$1.l10ns;
      var fp$2 = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Azerbaijan = {
        weekdays: {
          shorthand: ["Baz", "BzE", "ÇAx", "Çər", "CAx", "Cüm", "Şən"],
          longhand: ["Bazar", "Bazar ertəsi", "Çərşənbə axşamı", "Çərşənbə", "Cümə axşamı", "Cümə", "Şənbə"]
        },
        months: {
          shorthand: ["Yan", "Fev", "Mar", "Apr", "May", "İyn", "İyl", "Avq", "Sen", "Okt", "Noy", "Dek"],
          longhand: ["Yanvar", "Fevral", "Mart", "Aprel", "May", "İyun", "İyul", "Avqust", "Sentyabr", "Oktyabr", "Noyabr", "Dekabr"]
        },
        firstDayOfWeek: 1,
        ordinal: function () {
          return ".";
        },
        rangeSeparator: " - ",
        weekAbbreviation: "Hf",
        scrollTitle: "Artırmaq üçün sürüşdürün",
        toggleTitle: "Aç / Bağla",
        amPM: ["GƏ", "GS"],
        time_24hr: true
      };
      fp$2.l10ns.az = Azerbaijan;
      fp$2.l10ns;
      var fp$3 = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Belarusian = {
        weekdays: {
          shorthand: ["Нд", "Пн", "Аў", "Ср", "Чц", "Пт", "Сб"],
          longhand: ["Нядзеля", "Панядзелак", "Аўторак", "Серада", "Чацвер", "Пятніца", "Субота"]
        },
        months: {
          shorthand: ["Сту", "Лют", "Сак", "Кра", "Тра", "Чэр", "Ліп", "Жні", "Вер", "Кас", "Ліс", "Сне"],
          longhand: ["Студзень", "Люты", "Сакавік", "Красавік", "Травень", "Чэрвень", "Ліпень", "Жнівень", "Верасень", "Кастрычнік", "Лістапад", "Снежань"]
        },
        firstDayOfWeek: 1,
        ordinal: function () {
          return "";
        },
        rangeSeparator: " — ",
        weekAbbreviation: "Тыд.",
        scrollTitle: "Пракруціце для павелічэння",
        toggleTitle: "Націсніце для пераключэння",
        amPM: ["ДП", "ПП"],
        yearAriaLabel: "Год",
        time_24hr: true
      };
      fp$3.l10ns.be = Belarusian;
      fp$3.l10ns;
      var fp$4 = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Bosnian = {
        firstDayOfWeek: 1,
        weekdays: {
          shorthand: ["Ned", "Pon", "Uto", "Sri", "Čet", "Pet", "Sub"],
          longhand: ["Nedjelja", "Ponedjeljak", "Utorak", "Srijeda", "Četvrtak", "Petak", "Subota"]
        },
        months: {
          shorthand: ["Jan", "Feb", "Mar", "Apr", "Maj", "Jun", "Jul", "Avg", "Sep", "Okt", "Nov", "Dec"],
          longhand: ["Januar", "Februar", "Mart", "April", "Maj", "Juni", "Juli", "August", "Septembar", "Oktobar", "Novembar", "Decembar"]
        },
        time_24hr: true
      };
      fp$4.l10ns.bs = Bosnian;
      fp$4.l10ns;
      var fp$5 = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Bulgarian = {
        weekdays: {
          shorthand: ["Нд", "Пн", "Вт", "Ср", "Чт", "Пт", "Сб"],
          longhand: ["Неделя", "Понеделник", "Вторник", "Сряда", "Четвъртък", "Петък", "Събота"]
        },
        months: {
          shorthand: ["Яну", "Фев", "Март", "Апр", "Май", "Юни", "Юли", "Авг", "Сеп", "Окт", "Ное", "Дек"],
          longhand: ["Януари", "Февруари", "Март", "Април", "Май", "Юни", "Юли", "Август", "Септември", "Октомври", "Ноември", "Декември"]
        },
        time_24hr: true,
        firstDayOfWeek: 1
      };
      fp$5.l10ns.bg = Bulgarian;
      fp$5.l10ns;
      var fp$6 = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Bangla = {
        weekdays: {
          shorthand: ["রবি", "সোম", "মঙ্গল", "বুধ", "বৃহস্পতি", "শুক্র", "শনি"],
          longhand: ["রবিবার", "সোমবার", "মঙ্গলবার", "বুধবার", "বৃহস্পতিবার", "শুক্রবার", "শনিবার"]
        },
        months: {
          shorthand: ["জানু", "ফেব্রু", "মার্চ", "এপ্রিল", "মে", "জুন", "জুলাই", "আগ", "সেপ্টে", "অক্টো", "নভে", "ডিসে"],
          longhand: ["জানুয়ারী", "ফেব্রুয়ারী", "মার্চ", "এপ্রিল", "মে", "জুন", "জুলাই", "আগস্ট", "সেপ্টেম্বর", "অক্টোবর", "নভেম্বর", "ডিসেম্বর"]
        }
      };
      fp$6.l10ns.bn = Bangla;
      fp$6.l10ns;
      var fp$7 = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Catalan = {
        weekdays: {
          shorthand: ["Dg", "Dl", "Dt", "Dc", "Dj", "Dv", "Ds"],
          longhand: ["Diumenge", "Dilluns", "Dimarts", "Dimecres", "Dijous", "Divendres", "Dissabte"]
        },
        months: {
          shorthand: ["Gen", "Febr", "Març", "Abr", "Maig", "Juny", "Jul", "Ag", "Set", "Oct", "Nov", "Des"],
          longhand: ["Gener", "Febrer", "Març", "Abril", "Maig", "Juny", "Juliol", "Agost", "Setembre", "Octubre", "Novembre", "Desembre"]
        },
        ordinal: function (nth) {
          var s = nth % 100;
          if (s > 3 && s < 21) return "è";

          switch (s % 10) {
            case 1:
              return "r";

            case 2:
              return "n";

            case 3:
              return "r";

            case 4:
              return "t";

            default:
              return "è";
          }
        },
        firstDayOfWeek: 1,
        time_24hr: true
      };
      fp$7.l10ns.cat = Catalan;
      fp$7.l10ns;
      var fp$8 = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Czech = {
        weekdays: {
          shorthand: ["Ne", "Po", "Út", "St", "Čt", "Pá", "So"],
          longhand: ["Neděle", "Pondělí", "Úterý", "Středa", "Čtvrtek", "Pátek", "Sobota"]
        },
        months: {
          shorthand: ["Led", "Ún", "Bře", "Dub", "Kvě", "Čer", "Čvc", "Srp", "Zář", "Říj", "Lis", "Pro"],
          longhand: ["Leden", "Únor", "Březen", "Duben", "Květen", "Červen", "Červenec", "Srpen", "Září", "Říjen", "Listopad", "Prosinec"]
        },
        firstDayOfWeek: 1,
        ordinal: function () {
          return ".";
        },
        rangeSeparator: " do ",
        weekAbbreviation: "Týd.",
        scrollTitle: "Rolujte pro změnu",
        toggleTitle: "Přepnout dopoledne/odpoledne",
        amPM: ["dop.", "odp."],
        yearAriaLabel: "Rok",
        time_24hr: true
      };
      fp$8.l10ns.cs = Czech;
      fp$8.l10ns;
      var fp$9 = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Welsh = {
        weekdays: {
          shorthand: ["Sul", "Llun", "Maw", "Mer", "Iau", "Gwe", "Sad"],
          longhand: ["Dydd Sul", "Dydd Llun", "Dydd Mawrth", "Dydd Mercher", "Dydd Iau", "Dydd Gwener", "Dydd Sadwrn"]
        },
        months: {
          shorthand: ["Ion", "Chwef", "Maw", "Ebr", "Mai", "Meh", "Gorff", "Awst", "Medi", "Hyd", "Tach", "Rhag"],
          longhand: ["Ionawr", "Chwefror", "Mawrth", "Ebrill", "Mai", "Mehefin", "Gorffennaf", "Awst", "Medi", "Hydref", "Tachwedd", "Rhagfyr"]
        },
        firstDayOfWeek: 1,
        ordinal: function (nth) {
          if (nth === 1) return "af";
          if (nth === 2) return "ail";
          if (nth === 3 || nth === 4) return "ydd";
          if (nth === 5 || nth === 6) return "ed";
          if (nth >= 7 && nth <= 10 || nth == 12 || nth == 15 || nth == 18 || nth == 20) return "fed";
          if (nth == 11 || nth == 13 || nth == 14 || nth == 16 || nth == 17 || nth == 19) return "eg";
          if (nth >= 21 && nth <= 39) return "ain"; // Inconclusive.

          return "";
        },
        time_24hr: true
      };
      fp$9.l10ns.cy = Welsh;
      fp$9.l10ns;
      var fp$a = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Danish = {
        weekdays: {
          shorthand: ["søn", "man", "tir", "ons", "tors", "fre", "lør"],
          longhand: ["søndag", "mandag", "tirsdag", "onsdag", "torsdag", "fredag", "lørdag"]
        },
        months: {
          shorthand: ["jan", "feb", "mar", "apr", "maj", "jun", "jul", "aug", "sep", "okt", "nov", "dec"],
          longhand: ["januar", "februar", "marts", "april", "maj", "juni", "juli", "august", "september", "oktober", "november", "december"]
        },
        ordinal: function () {
          return ".";
        },
        firstDayOfWeek: 1,
        rangeSeparator: " til ",
        weekAbbreviation: "uge",
        time_24hr: true
      };
      fp$a.l10ns.da = Danish;
      fp$a.l10ns;
      var fp$b = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var German = {
        weekdays: {
          shorthand: ["So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"],
          longhand: ["Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag"]
        },
        months: {
          shorthand: ["Jan", "Feb", "Mär", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dez"],
          longhand: ["Januar", "Februar", "März", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"]
        },
        firstDayOfWeek: 1,
        weekAbbreviation: "KW",
        rangeSeparator: " bis ",
        scrollTitle: "Zum Ändern scrollen",
        toggleTitle: "Zum Umschalten klicken",
        time_24hr: true
      };
      fp$b.l10ns.de = German;
      fp$b.l10ns;
      var english = {
        weekdays: {
          shorthand: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
          longhand: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]
        },
        months: {
          shorthand: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
          longhand: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]
        },
        daysInMonth: [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31],
        firstDayOfWeek: 0,
        ordinal: function (nth) {
          var s = nth % 100;
          if (s > 3 && s < 21) return "th";

          switch (s % 10) {
            case 1:
              return "st";

            case 2:
              return "nd";

            case 3:
              return "rd";

            default:
              return "th";
          }
        },
        rangeSeparator: " to ",
        weekAbbreviation: "Wk",
        scrollTitle: "Scroll to increment",
        toggleTitle: "Click to toggle",
        amPM: ["AM", "PM"],
        yearAriaLabel: "Year",
        time_24hr: false
      };
      var fp$c = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Esperanto = {
        firstDayOfWeek: 1,
        rangeSeparator: " ĝis ",
        weekAbbreviation: "Sem",
        scrollTitle: "Rulumu por pligrandigi la valoron",
        toggleTitle: "Klaku por ŝalti",
        weekdays: {
          shorthand: ["Dim", "Lun", "Mar", "Mer", "Ĵaŭ", "Ven", "Sab"],
          longhand: ["dimanĉo", "lundo", "mardo", "merkredo", "ĵaŭdo", "vendredo", "sabato"]
        },
        months: {
          shorthand: ["Jan", "Feb", "Mar", "Apr", "Maj", "Jun", "Jul", "Aŭg", "Sep", "Okt", "Nov", "Dec"],
          longhand: ["januaro", "februaro", "marto", "aprilo", "majo", "junio", "julio", "aŭgusto", "septembro", "oktobro", "novembro", "decembro"]
        },
        ordinal: function () {
          return "-a";
        },
        time_24hr: true
      };
      fp$c.l10ns.eo = Esperanto;
      fp$c.l10ns;
      var fp$d = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Spanish = {
        weekdays: {
          shorthand: ["Dom", "Lun", "Mar", "Mié", "Jue", "Vie", "Sáb"],
          longhand: ["Domingo", "Lunes", "Martes", "Miércoles", "Jueves", "Viernes", "Sábado"]
        },
        months: {
          shorthand: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
          longhand: ["Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"]
        },
        ordinal: function () {
          return "º";
        },
        firstDayOfWeek: 1,
        rangeSeparator: " a ",
        time_24hr: true
      };
      fp$d.l10ns.es = Spanish;
      fp$d.l10ns;
      var fp$e = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Estonian = {
        weekdays: {
          shorthand: ["P", "E", "T", "K", "N", "R", "L"],
          longhand: ["Pühapäev", "Esmaspäev", "Teisipäev", "Kolmapäev", "Neljapäev", "Reede", "Laupäev"]
        },
        months: {
          shorthand: ["Jaan", "Veebr", "Märts", "Apr", "Mai", "Juuni", "Juuli", "Aug", "Sept", "Okt", "Nov", "Dets"],
          longhand: ["Jaanuar", "Veebruar", "Märts", "Aprill", "Mai", "Juuni", "Juuli", "August", "September", "Oktoober", "November", "Detsember"]
        },
        firstDayOfWeek: 1,
        ordinal: function () {
          return ".";
        },
        weekAbbreviation: "Näd",
        rangeSeparator: " kuni ",
        scrollTitle: "Keri, et suurendada",
        toggleTitle: "Klõpsa, et vahetada",
        time_24hr: true
      };
      fp$e.l10ns.et = Estonian;
      fp$e.l10ns;
      var fp$f = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Persian = {
        weekdays: {
          shorthand: ["یک", "دو", "سه", "چهار", "پنج", "جمعه", "شنبه"],
          longhand: ["یک‌شنبه", "دوشنبه", "سه‌شنبه", "چهارشنبه", "پنچ‌شنبه", "جمعه", "شنبه"]
        },
        months: {
          shorthand: ["ژانویه", "فوریه", "مارس", "آوریل", "مه", "ژوئن", "ژوئیه", "اوت", "سپتامبر", "اکتبر", "نوامبر", "دسامبر"],
          longhand: ["ژانویه", "فوریه", "مارس", "آوریل", "مه", "ژوئن", "ژوئیه", "اوت", "سپتامبر", "اکتبر", "نوامبر", "دسامبر"]
        },
        firstDayOfWeek: 6,
        ordinal: function () {
          return "";
        }
      };
      fp$f.l10ns.fa = Persian;
      fp$f.l10ns;
      var fp$g = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Finnish = {
        firstDayOfWeek: 1,
        weekdays: {
          shorthand: ["Su", "Ma", "Ti", "Ke", "To", "Pe", "La"],
          longhand: ["Sunnuntai", "Maanantai", "Tiistai", "Keskiviikko", "Torstai", "Perjantai", "Lauantai"]
        },
        months: {
          shorthand: ["Tammi", "Helmi", "Maalis", "Huhti", "Touko", "Kesä", "Heinä", "Elo", "Syys", "Loka", "Marras", "Joulu"],
          longhand: ["Tammikuu", "Helmikuu", "Maaliskuu", "Huhtikuu", "Toukokuu", "Kesäkuu", "Heinäkuu", "Elokuu", "Syyskuu", "Lokakuu", "Marraskuu", "Joulukuu"]
        },
        ordinal: function () {
          return ".";
        },
        time_24hr: true
      };
      fp$g.l10ns.fi = Finnish;
      fp$g.l10ns;
      var fp$h = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Faroese = {
        weekdays: {
          shorthand: ["Sun", "Mán", "Týs", "Mik", "Hós", "Frí", "Ley"],
          longhand: ["Sunnudagur", "Mánadagur", "Týsdagur", "Mikudagur", "Hósdagur", "Fríggjadagur", "Leygardagur"]
        },
        months: {
          shorthand: ["Jan", "Feb", "Mar", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Des"],
          longhand: ["Januar", "Februar", "Mars", "Apríl", "Mai", "Juni", "Juli", "August", "Septembur", "Oktobur", "Novembur", "Desembur"]
        },
        ordinal: function () {
          return ".";
        },
        firstDayOfWeek: 1,
        rangeSeparator: " til ",
        weekAbbreviation: "vika",
        scrollTitle: "Rulla fyri at broyta",
        toggleTitle: "Trýst fyri at skifta",
        yearAriaLabel: "Ár",
        time_24hr: true
      };
      fp$h.l10ns.fo = Faroese;
      fp$h.l10ns;
      var fp$i = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var French = {
        firstDayOfWeek: 1,
        weekdays: {
          shorthand: ["dim", "lun", "mar", "mer", "jeu", "ven", "sam"],
          longhand: ["dimanche", "lundi", "mardi", "mercredi", "jeudi", "vendredi", "samedi"]
        },
        months: {
          shorthand: ["janv", "févr", "mars", "avr", "mai", "juin", "juil", "août", "sept", "oct", "nov", "déc"],
          longhand: ["janvier", "février", "mars", "avril", "mai", "juin", "juillet", "août", "septembre", "octobre", "novembre", "décembre"]
        },
        ordinal: function (nth) {
          if (nth > 1) return "";
          return "er";
        },
        rangeSeparator: " au ",
        weekAbbreviation: "Sem",
        scrollTitle: "Défiler pour augmenter la valeur",
        toggleTitle: "Cliquer pour basculer",
        time_24hr: true
      };
      fp$i.l10ns.fr = French;
      fp$i.l10ns;
      var fp$j = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Greek = {
        weekdays: {
          shorthand: ["Κυ", "Δε", "Τρ", "Τε", "Πέ", "Πα", "Σά"],
          longhand: ["Κυριακή", "Δευτέρα", "Τρίτη", "Τετάρτη", "Πέμπτη", "Παρασκευή", "Σάββατο"]
        },
        months: {
          shorthand: ["Ιαν", "Φεβ", "Μάρ", "Απρ", "Μάι", "Ιού", "Ιού", "Αύγ", "Σεπ", "Οκτ", "Νοέ", "Δεκ"],
          longhand: ["Ιανουάριος", "Φεβρουάριος", "Μάρτιος", "Απρίλιος", "Μάιος", "Ιούνιος", "Ιούλιος", "Αύγουστος", "Σεπτέμβριος", "Οκτώβριος", "Νοέμβριος", "Δεκέμβριος"]
        },
        firstDayOfWeek: 1,
        ordinal: function () {
          return "";
        },
        weekAbbreviation: "Εβδ",
        rangeSeparator: " έως ",
        scrollTitle: "Μετακυλήστε για προσαύξηση",
        toggleTitle: "Κάντε κλικ για αλλαγή",
        amPM: ["ΠΜ", "ΜΜ"]
      };
      fp$j.l10ns.gr = Greek;
      fp$j.l10ns;
      var fp$k = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Hebrew = {
        weekdays: {
          shorthand: ["א", "ב", "ג", "ד", "ה", "ו", "ש"],
          longhand: ["ראשון", "שני", "שלישי", "רביעי", "חמישי", "שישי", "שבת"]
        },
        months: {
          shorthand: ["ינו׳", "פבר׳", "מרץ", "אפר׳", "מאי", "יוני", "יולי", "אוג׳", "ספט׳", "אוק׳", "נוב׳", "דצמ׳"],
          longhand: ["ינואר", "פברואר", "מרץ", "אפריל", "מאי", "יוני", "יולי", "אוגוסט", "ספטמבר", "אוקטובר", "נובמבר", "דצמבר"]
        },
        rangeSeparator: " אל ",
        time_24hr: true
      };
      fp$k.l10ns.he = Hebrew;
      fp$k.l10ns;
      var fp$l = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Hindi = {
        weekdays: {
          shorthand: ["रवि", "सोम", "मंगल", "बुध", "गुरु", "शुक्र", "शनि"],
          longhand: ["रविवार", "सोमवार", "मंगलवार", "बुधवार", "गुरुवार", "शुक्रवार", "शनिवार"]
        },
        months: {
          shorthand: ["जन", "फर", "मार्च", "अप्रेल", "मई", "जून", "जूलाई", "अग", "सित", "अक्ट", "नव", "दि"],
          longhand: ["जनवरी ", "फरवरी", "मार्च", "अप्रेल", "मई", "जून", "जूलाई", "अगस्त ", "सितम्बर", "अक्टूबर", "नवम्बर", "दिसम्बर"]
        }
      };
      fp$l.l10ns.hi = Hindi;
      fp$l.l10ns;
      var fp$m = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Croatian = {
        firstDayOfWeek: 1,
        weekdays: {
          shorthand: ["Ned", "Pon", "Uto", "Sri", "Čet", "Pet", "Sub"],
          longhand: ["Nedjelja", "Ponedjeljak", "Utorak", "Srijeda", "Četvrtak", "Petak", "Subota"]
        },
        months: {
          shorthand: ["Sij", "Velj", "Ožu", "Tra", "Svi", "Lip", "Srp", "Kol", "Ruj", "Lis", "Stu", "Pro"],
          longhand: ["Siječanj", "Veljača", "Ožujak", "Travanj", "Svibanj", "Lipanj", "Srpanj", "Kolovoz", "Rujan", "Listopad", "Studeni", "Prosinac"]
        },
        time_24hr: true
      };
      fp$m.l10ns.hr = Croatian;
      fp$m.l10ns;
      var fp$n = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Hungarian = {
        firstDayOfWeek: 1,
        weekdays: {
          shorthand: ["V", "H", "K", "Sz", "Cs", "P", "Szo"],
          longhand: ["Vasárnap", "Hétfő", "Kedd", "Szerda", "Csütörtök", "Péntek", "Szombat"]
        },
        months: {
          shorthand: ["Jan", "Feb", "Már", "Ápr", "Máj", "Jún", "Júl", "Aug", "Szep", "Okt", "Nov", "Dec"],
          longhand: ["Január", "Február", "Március", "Április", "Május", "Június", "Július", "Augusztus", "Szeptember", "Október", "November", "December"]
        },
        ordinal: function () {
          return ".";
        },
        weekAbbreviation: "Hét",
        scrollTitle: "Görgessen",
        toggleTitle: "Kattintson a váltáshoz",
        rangeSeparator: " - ",
        time_24hr: true
      };
      fp$n.l10ns.hu = Hungarian;
      fp$n.l10ns;
      var fp$o = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Indonesian = {
        weekdays: {
          shorthand: ["Min", "Sen", "Sel", "Rab", "Kam", "Jum", "Sab"],
          longhand: ["Minggu", "Senin", "Selasa", "Rabu", "Kamis", "Jumat", "Sabtu"]
        },
        months: {
          shorthand: ["Jan", "Feb", "Mar", "Apr", "Mei", "Jun", "Jul", "Agu", "Sep", "Okt", "Nov", "Des"],
          longhand: ["Januari", "Februari", "Maret", "April", "Mei", "Juni", "Juli", "Agustus", "September", "Oktober", "November", "Desember"]
        },
        firstDayOfWeek: 1,
        ordinal: function () {
          return "";
        },
        time_24hr: true,
        rangeSeparator: ' - '
      };
      fp$o.l10ns.id = Indonesian;
      fp$o.l10ns;
      var fp$p = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Icelandic = {
        weekdays: {
          shorthand: ["Sun", "Mán", "Þri", "Mið", "Fim", "Fös", "Lau"],
          longhand: ["Sunnudagur", "Mánudagur", "Þriðjudagur", "Miðvikudagur", "Fimmtudagur", "Föstudagur", "Laugardagur"]
        },
        months: {
          shorthand: ["Jan", "Feb", "Mar", "Apr", "Maí", "Jún", "Júl", "Ágú", "Sep", "Okt", "Nóv", "Des"],
          longhand: ["Janúar", "Febrúar", "Mars", "Apríl", "Maí", "Júní", "Júlí", "Ágúst", "September", "Október", "Nóvember", "Desember"]
        },
        ordinal: function () {
          return ".";
        },
        firstDayOfWeek: 1,
        rangeSeparator: " til ",
        weekAbbreviation: "vika",
        yearAriaLabel: "Ár",
        time_24hr: true
      };
      fp$p.l10ns.is = Icelandic;
      fp$p.l10ns;
      var fp$q = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Italian = {
        weekdays: {
          shorthand: ["Dom", "Lun", "Mar", "Mer", "Gio", "Ven", "Sab"],
          longhand: ["Domenica", "Lunedì", "Martedì", "Mercoledì", "Giovedì", "Venerdì", "Sabato"]
        },
        months: {
          shorthand: ["Gen", "Feb", "Mar", "Apr", "Mag", "Giu", "Lug", "Ago", "Set", "Ott", "Nov", "Dic"],
          longhand: ["Gennaio", "Febbraio", "Marzo", "Aprile", "Maggio", "Giugno", "Luglio", "Agosto", "Settembre", "Ottobre", "Novembre", "Dicembre"]
        },
        firstDayOfWeek: 1,
        ordinal: function () {
          return "°";
        },
        rangeSeparator: " al ",
        weekAbbreviation: "Se",
        scrollTitle: "Scrolla per aumentare",
        toggleTitle: "Clicca per cambiare",
        time_24hr: true
      };
      fp$q.l10ns.it = Italian;
      fp$q.l10ns;
      var fp$r = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Japanese = {
        weekdays: {
          shorthand: ["日", "月", "火", "水", "木", "金", "土"],
          longhand: ["日曜日", "月曜日", "火曜日", "水曜日", "木曜日", "金曜日", "土曜日"]
        },
        months: {
          shorthand: ["1月", "2月", "3月", "4月", "5月", "6月", "7月", "8月", "9月", "10月", "11月", "12月"],
          longhand: ["1月", "2月", "3月", "4月", "5月", "6月", "7月", "8月", "9月", "10月", "11月", "12月"]
        },
        time_24hr: true,
        rangeSeparator: ' から '
      };
      fp$r.l10ns.ja = Japanese;
      fp$r.l10ns;
      var fp$s = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Korean = {
        weekdays: {
          shorthand: ["일", "월", "화", "수", "목", "금", "토"],
          longhand: ["일요일", "월요일", "화요일", "수요일", "목요일", "금요일", "토요일"]
        },
        months: {
          shorthand: ["1월", "2월", "3월", "4월", "5월", "6월", "7월", "8월", "9월", "10월", "11월", "12월"],
          longhand: ["1월", "2월", "3월", "4월", "5월", "6월", "7월", "8월", "9월", "10월", "11월", "12월"]
        },
        ordinal: function () {
          return "일";
        },
        rangeSeparator: ' ~ '
      };
      fp$s.l10ns.ko = Korean;
      fp$s.l10ns;
      var fp$t = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Khmer = {
        weekdays: {
          shorthand: ["អាទិត្យ", "ចន្ទ", "អង្គារ", "ពុធ", "ព្រហស.", "សុក្រ", "សៅរ៍"],
          longhand: ["អាទិត្យ", "ចន្ទ", "អង្គារ", "ពុធ", "ព្រហស្បតិ៍", "សុក្រ", "សៅរ៍"]
        },
        months: {
          shorthand: ["មករា", "កុម្ភះ", "មីនា", "មេសា", "ឧសភា", "មិថុនា", "កក្កដា", "សីហា", "កញ្ញា", "តុលា", "វិច្ឆិកា", "ធ្នូ"],
          longhand: ["មករា", "កុម្ភះ", "មីនា", "មេសា", "ឧសភា", "មិថុនា", "កក្កដា", "សីហា", "កញ្ញា", "តុលា", "វិច្ឆិកា", "ធ្នូ"]
        },
        ordinal: function () {
          return "";
        },
        firstDayOfWeek: 1,
        rangeSeparator: " ដល់ ",
        weekAbbreviation: "សប្តាហ៍",
        scrollTitle: "រំកិលដើម្បីបង្កើន",
        toggleTitle: "ចុចដើម្បីផ្លាស់ប្ដូរ",
        yearAriaLabel: "ឆ្នាំ",
        time_24hr: true
      };
      fp$t.l10ns.km = Khmer;
      fp$t.l10ns;
      var fp$u = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Kazakh = {
        weekdays: {
          shorthand: ["Жс", "Дс", "Сc", "Ср", "Бс", "Жм", "Сб"],
          longhand: ["Жексенбi", "Дүйсенбi", "Сейсенбi", "Сәрсенбi", "Бейсенбi", "Жұма", "Сенбi"]
        },
        months: {
          shorthand: ["Қаң", "Ақп", "Нау", "Сәу", "Мам", "Мау", "Шiл", "Там", "Қыр", "Қаз", "Қар", "Жел"],
          longhand: ["Қаңтар", "Ақпан", "Наурыз", "Сәуiр", "Мамыр", "Маусым", "Шiлде", "Тамыз", "Қыркүйек", "Қазан", "Қараша", "Желтоқсан"]
        },
        firstDayOfWeek: 1,
        ordinal: function () {
          return "";
        },
        rangeSeparator: " — ",
        weekAbbreviation: "Апта",
        scrollTitle: "Үлкейту үшін айналдырыңыз",
        toggleTitle: "Ауыстыру үшін басыңыз",
        amPM: ["ТД", "ТК"],
        yearAriaLabel: "Жыл"
      };
      fp$u.l10ns.kz = Kazakh;
      fp$u.l10ns;
      var fp$v = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Lithuanian = {
        weekdays: {
          shorthand: ["S", "Pr", "A", "T", "K", "Pn", "Š"],
          longhand: ["Sekmadienis", "Pirmadienis", "Antradienis", "Trečiadienis", "Ketvirtadienis", "Penktadienis", "Šeštadienis"]
        },
        months: {
          shorthand: ["Sau", "Vas", "Kov", "Bal", "Geg", "Bir", "Lie", "Rgp", "Rgs", "Spl", "Lap", "Grd"],
          longhand: ["Sausis", "Vasaris", "Kovas", "Balandis", "Gegužė", "Birželis", "Liepa", "Rugpjūtis", "Rugsėjis", "Spalis", "Lapkritis", "Gruodis"]
        },
        firstDayOfWeek: 1,
        ordinal: function () {
          return "-a";
        },
        weekAbbreviation: "Sav",
        scrollTitle: "Keisti laiką pelės rateliu",
        toggleTitle: "Perjungti laiko formatą",
        time_24hr: true
      };
      fp$v.l10ns.lt = Lithuanian;
      fp$v.l10ns;
      var fp$w = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Latvian = {
        firstDayOfWeek: 1,
        weekdays: {
          shorthand: ["Sv", "Pr", "Ot", "Tr", "Ce", "Pk", "Se"],
          longhand: ["Svētdiena", "Pirmdiena", "Otrdiena", "Trešdiena", "Ceturtdiena", "Piektdiena", "Sestdiena"]
        },
        months: {
          shorthand: ["Jan", "Feb", "Mar", "Apr", "Mai", "Jūn", "Jūl", "Aug", "Sep", "Okt", "Nov", "Dec"],
          longhand: ["Janvāris", "Februāris", "Marts", "Aprīlis", "Maijs", "Jūnijs", "Jūlijs", "Augusts", "Septembris", "Oktobris", "Novembris", "Decembris"]
        },
        rangeSeparator: " līdz ",
        time_24hr: true
      };
      fp$w.l10ns.lv = Latvian;
      fp$w.l10ns;
      var fp$x = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Macedonian = {
        weekdays: {
          shorthand: ["Не", "По", "Вт", "Ср", "Че", "Пе", "Са"],
          longhand: ["Недела", "Понеделник", "Вторник", "Среда", "Четврток", "Петок", "Сабота"]
        },
        months: {
          shorthand: ["Јан", "Фев", "Мар", "Апр", "Мај", "Јун", "Јул", "Авг", "Сеп", "Окт", "Ное", "Дек"],
          longhand: ["Јануари", "Февруари", "Март", "Април", "Мај", "Јуни", "Јули", "Август", "Септември", "Октомври", "Ноември", "Декември"]
        },
        firstDayOfWeek: 1,
        weekAbbreviation: "Нед.",
        rangeSeparator: " до ",
        time_24hr: true
      };
      fp$x.l10ns.mk = Macedonian;
      fp$x.l10ns;
      var fp$y = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Mongolian = {
        firstDayOfWeek: 1,
        weekdays: {
          shorthand: ["Да", "Мя", "Лх", "Пү", "Ба", "Бя", "Ня"],
          longhand: ["Даваа", "Мягмар", "Лхагва", "Пүрэв", "Баасан", "Бямба", "Ням"]
        },
        months: {
          shorthand: ["1-р сар", "2-р сар", "3-р сар", "4-р сар", "5-р сар", "6-р сар", "7-р сар", "8-р сар", "9-р сар", "10-р сар", "11-р сар", "12-р сар"],
          longhand: ["Нэгдүгээр сар", "Хоёрдугаар сар", "Гуравдугаар сар", "Дөрөвдүгээр сар", "Тавдугаар сар", "Зургаадугаар сар", "Долдугаар сар", "Наймдугаар сар", "Есдүгээр сар", "Аравдугаар сар", "Арваннэгдүгээр сар", "Арванхоёрдугаар сар"]
        },
        rangeSeparator: "-с ",
        time_24hr: true
      };
      fp$y.l10ns.mn = Mongolian;
      fp$y.l10ns;
      var fp$z = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Malaysian = {
        weekdays: {
          shorthand: ["Min", "Isn", "Sel", "Rab", "Kha", "Jum", "Sab"],
          longhand: ["Minggu", "Isnin", "Selasa", "Rabu", "Khamis", "Jumaat", "Sabtu"]
        },
        months: {
          shorthand: ["Jan", "Feb", "Mac", "Apr", "Mei", "Jun", "Jul", "Ogo", "Sep", "Okt", "Nov", "Dis"],
          longhand: ["Januari", "Februari", "Mac", "April", "Mei", "Jun", "Julai", "Ogos", "September", "Oktober", "November", "Disember"]
        },
        firstDayOfWeek: 1,
        ordinal: function () {
          return "";
        }
      };
      fp$z.l10ns;
      var fp$A = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Burmese = {
        weekdays: {
          shorthand: ["နွေ", "လာ", "ဂါ", "ဟူး", "ကြာ", "သော", "နေ"],
          longhand: ["တနင်္ဂနွေ", "တနင်္လာ", "အင်္ဂါ", "ဗုဒ္ဓဟူး", "ကြာသပတေး", "သောကြာ", "စနေ"]
        },
        months: {
          shorthand: ["ဇန်", "ဖေ", "မတ်", "ပြီ", "မေ", "ဇွန်", "လိုင်", "သြ", "စက်", "အောက်", "နို", "ဒီ"],
          longhand: ["ဇန်နဝါရီ", "ဖေဖော်ဝါရီ", "မတ်", "ဧပြီ", "မေ", "ဇွန်", "ဇူလိုင်", "သြဂုတ်", "စက်တင်ဘာ", "အောက်တိုဘာ", "နိုဝင်ဘာ", "ဒီဇင်ဘာ"]
        },
        firstDayOfWeek: 1,
        ordinal: function () {
          return "";
        },
        time_24hr: true
      };
      fp$A.l10ns.my = Burmese;
      fp$A.l10ns;
      var fp$B = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Dutch = {
        weekdays: {
          shorthand: ["zo", "ma", "di", "wo", "do", "vr", "za"],
          longhand: ["zondag", "maandag", "dinsdag", "woensdag", "donderdag", "vrijdag", "zaterdag"]
        },
        months: {
          shorthand: ["jan", "feb", "mrt", "apr", "mei", "jun", "jul", "aug", "sept", "okt", "nov", "dec"],
          longhand: ["januari", "februari", "maart", "april", "mei", "juni", "juli", "augustus", "september", "oktober", "november", "december"]
        },
        firstDayOfWeek: 1,
        weekAbbreviation: "wk",
        rangeSeparator: " tot ",
        scrollTitle: "Scroll voor volgende / vorige",
        toggleTitle: "Klik om te wisselen",
        time_24hr: true,
        ordinal: function (nth) {
          if (nth === 1 || nth === 8 || nth >= 20) return "ste";
          return "de";
        }
      };
      fp$B.l10ns.nl = Dutch;
      fp$B.l10ns;
      var fp$C = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Norwegian = {
        weekdays: {
          shorthand: ["Søn", "Man", "Tir", "Ons", "Tor", "Fre", "Lør"],
          longhand: ["Søndag", "Mandag", "Tirsdag", "Onsdag", "Torsdag", "Fredag", "Lørdag"]
        },
        months: {
          shorthand: ["Jan", "Feb", "Mar", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Des"],
          longhand: ["Januar", "Februar", "Mars", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Desember"]
        },
        firstDayOfWeek: 1,
        rangeSeparator: " til ",
        weekAbbreviation: "Uke",
        scrollTitle: "Scroll for å endre",
        toggleTitle: "Klikk for å veksle",
        time_24hr: true,
        ordinal: function () {
          return ".";
        }
      };
      fp$C.l10ns.no = Norwegian;
      fp$C.l10ns;
      var fp$D = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Punjabi = {
        weekdays: {
          shorthand: ["ਐਤ", "ਸੋਮ", "ਮੰਗਲ", "ਬੁੱਧ", "ਵੀਰ", "ਸ਼ੁੱਕਰ", "ਸ਼ਨਿੱਚਰ"],
          longhand: ["ਐਤਵਾਰ", "ਸੋਮਵਾਰ", "ਮੰਗਲਵਾਰ", "ਬੁੱਧਵਾਰ", "ਵੀਰਵਾਰ", "ਸ਼ੁੱਕਰਵਾਰ", "ਸ਼ਨਿੱਚਰਵਾਰ"]
        },
        months: {
          shorthand: ["ਜਨ", "ਫ਼ਰ", "ਮਾਰ", "ਅਪ੍ਰੈ", "ਮਈ", "ਜੂਨ", "ਜੁਲਾ", "ਅਗ", "ਸਤੰ", "ਅਕ", "ਨਵੰ", "ਦਸੰ"],
          longhand: ["ਜਨਵਰੀ", "ਫ਼ਰਵਰੀ", "ਮਾਰਚ", "ਅਪ੍ਰੈਲ", "ਮਈ", "ਜੂਨ", "ਜੁਲਾਈ", "ਅਗਸਤ", "ਸਤੰਬਰ", "ਅਕਤੂਬਰ", "ਨਵੰਬਰ", "ਦਸੰਬਰ"]
        },
        time_24hr: true
      };
      fp$D.l10ns.pa = Punjabi;
      fp$D.l10ns;
      var fp$E = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Polish = {
        weekdays: {
          shorthand: ["Nd", "Pn", "Wt", "Śr", "Cz", "Pt", "So"],
          longhand: ["Niedziela", "Poniedziałek", "Wtorek", "Środa", "Czwartek", "Piątek", "Sobota"]
        },
        months: {
          shorthand: ["Sty", "Lut", "Mar", "Kwi", "Maj", "Cze", "Lip", "Sie", "Wrz", "Paź", "Lis", "Gru"],
          longhand: ["Styczeń", "Luty", "Marzec", "Kwiecień", "Maj", "Czerwiec", "Lipiec", "Sierpień", "Wrzesień", "Październik", "Listopad", "Grudzień"]
        },
        rangeSeparator: " do ",
        weekAbbreviation: "tydz.",
        scrollTitle: "Przewiń, aby zwiększyć",
        toggleTitle: "Kliknij, aby przełączyć",
        firstDayOfWeek: 1,
        time_24hr: true,
        ordinal: function () {
          return ".";
        }
      };
      fp$E.l10ns.pl = Polish;
      fp$E.l10ns;
      var fp$F = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Portuguese = {
        weekdays: {
          shorthand: ["Dom", "Seg", "Ter", "Qua", "Qui", "Sex", "Sáb"],
          longhand: ["Domingo", "Segunda-feira", "Terça-feira", "Quarta-feira", "Quinta-feira", "Sexta-feira", "Sábado"]
        },
        months: {
          shorthand: ["Jan", "Fev", "Mar", "Abr", "Mai", "Jun", "Jul", "Ago", "Set", "Out", "Nov", "Dez"],
          longhand: ["Janeiro", "Fevereiro", "Março", "Abril", "Maio", "Junho", "Julho", "Agosto", "Setembro", "Outubro", "Novembro", "Dezembro"]
        },
        rangeSeparator: " até ",
        time_24hr: true
      };
      fp$F.l10ns.pt = Portuguese;
      fp$F.l10ns;
      var fp$G = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Romanian = {
        weekdays: {
          shorthand: ["Dum", "Lun", "Mar", "Mie", "Joi", "Vin", "Sâm"],
          longhand: ["Duminică", "Luni", "Marți", "Miercuri", "Joi", "Vineri", "Sâmbătă"]
        },
        months: {
          shorthand: ["Ian", "Feb", "Mar", "Apr", "Mai", "Iun", "Iul", "Aug", "Sep", "Oct", "Noi", "Dec"],
          longhand: ["Ianuarie", "Februarie", "Martie", "Aprilie", "Mai", "Iunie", "Iulie", "August", "Septembrie", "Octombrie", "Noiembrie", "Decembrie"]
        },
        firstDayOfWeek: 1,
        time_24hr: true,
        ordinal: function () {
          return "";
        }
      };
      fp$G.l10ns.ro = Romanian;
      fp$G.l10ns;
      var fp$H = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Russian = {
        weekdays: {
          shorthand: ["Вс", "Пн", "Вт", "Ср", "Чт", "Пт", "Сб"],
          longhand: ["Воскресенье", "Понедельник", "Вторник", "Среда", "Четверг", "Пятница", "Суббота"]
        },
        months: {
          shorthand: ["Янв", "Фев", "Март", "Апр", "Май", "Июнь", "Июль", "Авг", "Сен", "Окт", "Ноя", "Дек"],
          longhand: ["Январь", "Февраль", "Март", "Апрель", "Май", "Июнь", "Июль", "Август", "Сентябрь", "Октябрь", "Ноябрь", "Декабрь"]
        },
        firstDayOfWeek: 1,
        ordinal: function () {
          return "";
        },
        rangeSeparator: " — ",
        weekAbbreviation: "Нед.",
        scrollTitle: "Прокрутите для увеличения",
        toggleTitle: "Нажмите для переключения",
        amPM: ["ДП", "ПП"],
        yearAriaLabel: "Год",
        time_24hr: true
      };
      fp$H.l10ns.ru = Russian;
      fp$H.l10ns;
      var fp$I = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Sinhala = {
        weekdays: {
          shorthand: ["ඉ", "ස", "අ", "බ", "බ්‍ර", "සි", "සෙ"],
          longhand: ["ඉරිදා", "සඳුදා", "අඟහරුවාදා", "බදාදා", "බ්‍රහස්පතින්දා", "සිකුරාදා", "සෙනසුරාදා"]
        },
        months: {
          shorthand: ["ජන", "පෙබ", "මාර්", "අප්‍රේ", "මැයි", "ජුනි", "ජූලි", "අගෝ", "සැප්", "ඔක්", "නොවැ", "දෙසැ"],
          longhand: ["ජනවාරි", "පෙබරවාරි", "මාර්තු", "අප්‍රේල්", "මැයි", "ජුනි", "ජූලි", "අගෝස්තු", "සැප්තැම්බර්", "ඔක්තෝබර්", "නොවැම්බර්", "දෙසැම්බර්"]
        },
        time_24hr: true
      };
      fp$I.l10ns.si = Sinhala;
      fp$I.l10ns;
      var fp$J = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Slovak = {
        weekdays: {
          shorthand: ["Ned", "Pon", "Ut", "Str", "Štv", "Pia", "Sob"],
          longhand: ["Nedeľa", "Pondelok", "Utorok", "Streda", "Štvrtok", "Piatok", "Sobota"]
        },
        months: {
          shorthand: ["Jan", "Feb", "Mar", "Apr", "Máj", "Jún", "Júl", "Aug", "Sep", "Okt", "Nov", "Dec"],
          longhand: ["Január", "Február", "Marec", "Apríl", "Máj", "Jún", "Júl", "August", "September", "Október", "November", "December"]
        },
        firstDayOfWeek: 1,
        rangeSeparator: " do ",
        time_24hr: true,
        ordinal: function () {
          return ".";
        }
      };
      fp$J.l10ns.sk = Slovak;
      fp$J.l10ns;
      var fp$K = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Slovenian = {
        weekdays: {
          shorthand: ["Ned", "Pon", "Tor", "Sre", "Čet", "Pet", "Sob"],
          longhand: ["Nedelja", "Ponedeljek", "Torek", "Sreda", "Četrtek", "Petek", "Sobota"]
        },
        months: {
          shorthand: ["Jan", "Feb", "Mar", "Apr", "Maj", "Jun", "Jul", "Avg", "Sep", "Okt", "Nov", "Dec"],
          longhand: ["Januar", "Februar", "Marec", "April", "Maj", "Junij", "Julij", "Avgust", "September", "Oktober", "November", "December"]
        },
        firstDayOfWeek: 1,
        rangeSeparator: " do ",
        time_24hr: true,
        ordinal: function () {
          return ".";
        }
      };
      fp$K.l10ns.sl = Slovenian;
      fp$K.l10ns;
      var fp$L = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Albanian = {
        weekdays: {
          shorthand: ["Di", "Hë", "Ma", "Më", "En", "Pr", "Sh"],
          longhand: ["E Diel", "E Hënë", "E Martë", "E Mërkurë", "E Enjte", "E Premte", "E Shtunë"]
        },
        months: {
          shorthand: ["Jan", "Shk", "Mar", "Pri", "Maj", "Qer", "Kor", "Gus", "Sht", "Tet", "Nën", "Dhj"],
          longhand: ["Janar", "Shkurt", "Mars", "Prill", "Maj", "Qershor", "Korrik", "Gusht", "Shtator", "Tetor", "Nëntor", "Dhjetor"]
        },
        time_24hr: true
      };
      fp$L.l10ns.sq = Albanian;
      fp$L.l10ns;
      var fp$M = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Serbian = {
        weekdays: {
          shorthand: ["Ned", "Pon", "Uto", "Sre", "Čet", "Pet", "Sub"],
          longhand: ["Nedelja", "Ponedeljak", "Utorak", "Sreda", "Četvrtak", "Petak", "Subota"]
        },
        months: {
          shorthand: ["Jan", "Feb", "Mar", "Apr", "Maj", "Jun", "Jul", "Avg", "Sep", "Okt", "Nov", "Dec"],
          longhand: ["Januar", "Februar", "Mart", "April", "Maj", "Jun", "Jul", "Avgust", "Septembar", "Oktobar", "Novembar", "Decembar"]
        },
        firstDayOfWeek: 1,
        weekAbbreviation: "Ned.",
        rangeSeparator: " do ",
        time_24hr: true
      };
      fp$M.l10ns.sr = Serbian;
      fp$M.l10ns;
      var fp$N = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Swedish = {
        firstDayOfWeek: 1,
        weekAbbreviation: "v",
        weekdays: {
          shorthand: ["Sön", "Mån", "Tis", "Ons", "Tor", "Fre", "Lör"],
          longhand: ["Söndag", "Måndag", "Tisdag", "Onsdag", "Torsdag", "Fredag", "Lördag"]
        },
        months: {
          shorthand: ["Jan", "Feb", "Mar", "Apr", "Maj", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dec"],
          longhand: ["Januari", "Februari", "Mars", "April", "Maj", "Juni", "Juli", "Augusti", "September", "Oktober", "November", "December"]
        },
        time_24hr: true,
        ordinal: function () {
          return ".";
        }
      };
      fp$N.l10ns.sv = Swedish;
      fp$N.l10ns;
      var fp$O = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Thai = {
        weekdays: {
          shorthand: ["อา", "จ", "อ", "พ", "พฤ", "ศ", "ส"],
          longhand: ["อาทิตย์", "จันทร์", "อังคาร", "พุธ", "พฤหัสบดี", "ศุกร์", "เสาร์"]
        },
        months: {
          shorthand: ["ม.ค.", "ก.พ.", "มี.ค.", "เม.ย.", "พ.ค.", "มิ.ย.", "ก.ค.", "ส.ค.", "ก.ย.", "ต.ค.", "พ.ย.", "ธ.ค."],
          longhand: ["มกราคม", "กุมภาพันธ์", "มีนาคม", "เมษายน", "พฤษภาคม", "มิถุนายน", "กรกฎาคม", "สิงหาคม", "กันยายน", "ตุลาคม", "พฤศจิกายน", "ธันวาคม"]
        },
        firstDayOfWeek: 1,
        rangeSeparator: " ถึง ",
        scrollTitle: "เลื่อนเพื่อเพิ่มหรือลด",
        toggleTitle: "คลิกเพื่อเปลี่ยน",
        time_24hr: true,
        ordinal: function () {
          return "";
        }
      };
      fp$O.l10ns.th = Thai;
      fp$O.l10ns;
      var fp$P = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Turkish = {
        weekdays: {
          shorthand: ["Paz", "Pzt", "Sal", "Çar", "Per", "Cum", "Cmt"],
          longhand: ["Pazar", "Pazartesi", "Salı", "Çarşamba", "Perşembe", "Cuma", "Cumartesi"]
        },
        months: {
          shorthand: ["Oca", "Şub", "Mar", "Nis", "May", "Haz", "Tem", "Ağu", "Eyl", "Eki", "Kas", "Ara"],
          longhand: ["Ocak", "Şubat", "Mart", "Nisan", "Mayıs", "Haziran", "Temmuz", "Ağustos", "Eylül", "Ekim", "Kasım", "Aralık"]
        },
        firstDayOfWeek: 1,
        ordinal: function () {
          return ".";
        },
        rangeSeparator: " - ",
        weekAbbreviation: "Hf",
        scrollTitle: "Artırmak için kaydırın",
        toggleTitle: "Aç/Kapa",
        amPM: ["ÖÖ", "ÖS"],
        time_24hr: true
      };
      fp$P.l10ns.tr = Turkish;
      fp$P.l10ns;
      var fp$Q = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Ukrainian = {
        firstDayOfWeek: 1,
        weekdays: {
          shorthand: ["Нд", "Пн", "Вт", "Ср", "Чт", "Пт", "Сб"],
          longhand: ["Неділя", "Понеділок", "Вівторок", "Середа", "Четвер", "П'ятниця", "Субота"]
        },
        months: {
          shorthand: ["Січ", "Лют", "Бер", "Кві", "Тра", "Чер", "Лип", "Сер", "Вер", "Жов", "Лис", "Гру"],
          longhand: ["Січень", "Лютий", "Березень", "Квітень", "Травень", "Червень", "Липень", "Серпень", "Вересень", "Жовтень", "Листопад", "Грудень"]
        },
        time_24hr: true
      };
      fp$Q.l10ns.uk = Ukrainian;
      fp$Q.l10ns;
      var fp$R = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Vietnamese = {
        weekdays: {
          shorthand: ["CN", "T2", "T3", "T4", "T5", "T6", "T7"],
          longhand: ["Chủ nhật", "Thứ hai", "Thứ ba", "Thứ tư", "Thứ năm", "Thứ sáu", "Thứ bảy"]
        },
        months: {
          shorthand: ["Th1", "Th2", "Th3", "Th4", "Th5", "Th6", "Th7", "Th8", "Th9", "Th10", "Th11", "Th12"],
          longhand: ["Tháng một", "Tháng hai", "Tháng ba", "Tháng tư", "Tháng năm", "Tháng sáu", "Tháng bảy", "Tháng tám", "Tháng chín", "Tháng mười", "Tháng 11", "Tháng 12"]
        },
        firstDayOfWeek: 1,
        rangeSeparator: ' đến '
      };
      fp$R.l10ns.vn = Vietnamese;
      fp$R.l10ns;
      var fp$S = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var Mandarin = {
        weekdays: {
          shorthand: ["周日", "周一", "周二", "周三", "周四", "周五", "周六"],
          longhand: ["星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六"]
        },
        months: {
          shorthand: ["一月", "二月", "三月", "四月", "五月", "六月", "七月", "八月", "九月", "十月", "十一月", "十二月"],
          longhand: ["一月", "二月", "三月", "四月", "五月", "六月", "七月", "八月", "九月", "十月", "十一月", "十二月"]
        },
        rangeSeparator: " 至 ",
        weekAbbreviation: "周",
        scrollTitle: "滚动切换",
        toggleTitle: "点击切换 12/24 小时时制"
      };
      fp$S.l10ns.zh = Mandarin;
      fp$S.l10ns;
      var fp$T = typeof window !== "undefined" && window.flatpickr !== undefined ? window.flatpickr : {
        l10ns: {}
      };
      var MandarinTraditional = {
        weekdays: {
          shorthand: ["週日", "週一", "週二", "週三", "週四", "週五", "週六"],
          longhand: ["星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六"]
        },
        months: {
          shorthand: ["一月", "二月", "三月", "四月", "五月", "六月", "七月", "八月", "九月", "十月", "十一月", "十二月"],
          longhand: ["一月", "二月", "三月", "四月", "五月", "六月", "七月", "八月", "九月", "十月", "十一月", "十二月"]
        },
        rangeSeparator: " 至 ",
        weekAbbreviation: "週",
        scrollTitle: "滾動切換",
        toggleTitle: "點擊切換 12/24 小時時制"
      };
      fp$T.l10ns.zh_tw = MandarinTraditional;
      fp$T.l10ns;
      var l10n = {
        ar: Arabic,
        at: Austria,
        az: Azerbaijan,
        be: Belarusian,
        bg: Bulgarian,
        bn: Bangla,
        bs: Bosnian,
        cat: Catalan,
        cs: Czech,
        cy: Welsh,
        da: Danish,
        de: German,
        "default": __assign({}, english),
        en: english,
        eo: Esperanto,
        es: Spanish,
        et: Estonian,
        fa: Persian,
        fi: Finnish,
        fo: Faroese,
        fr: French,
        gr: Greek,
        he: Hebrew,
        hi: Hindi,
        hr: Croatian,
        hu: Hungarian,
        id: Indonesian,
        is: Icelandic,
        it: Italian,
        ja: Japanese,
        ko: Korean,
        km: Khmer,
        kz: Kazakh,
        lt: Lithuanian,
        lv: Latvian,
        mk: Macedonian,
        mn: Mongolian,
        ms: Malaysian,
        my: Burmese,
        nl: Dutch,
        no: Norwegian,
        pa: Punjabi,
        pl: Polish,
        pt: Portuguese,
        ro: Romanian,
        ru: Russian,
        si: Sinhala,
        sk: Slovak,
        sl: Slovenian,
        sq: Albanian,
        sr: Serbian,
        sv: Swedish,
        th: Thai,
        tr: Turkish,
        uk: Ukrainian,
        vn: Vietnamese,
        zh: Mandarin,
        zh_tw: MandarinTraditional
      };
      exports.default = l10n;
      Object.defineProperty(exports, '__esModule', {
        value: true
      });
    });
  });
  var l10n$1 = unwrapExports(l10n);

  var rangePlugin = createCommonjsModule(function (module, exports) {
    (function (global, factory) {
       module.exports = factory() ;
    })(commonjsGlobal, function () {

      function rangePlugin(config) {
        if (config === void 0) {
          config = {};
        }

        return function (fp) {
          var dateFormat = "",
              secondInput,
              _secondInputFocused,
              _prevDates;

          var createSecondInput = function () {
            if (config.input) {
              secondInput = config.input instanceof Element ? config.input : window.document.querySelector(config.input);

              if (!secondInput) {
                fp.config.errorHandler(new Error("Invalid input element specified"));
                return;
              }

              if (fp.config.wrap) {
                secondInput = secondInput.querySelector("[data-input]");
              }
            } else {
              secondInput = fp._input.cloneNode();
              secondInput.removeAttribute("id");
              secondInput._flatpickr = undefined;
            }

            if (secondInput.value) {
              var parsedDate = fp.parseDate(secondInput.value);
              if (parsedDate) fp.selectedDates.push(parsedDate);
            }

            secondInput.setAttribute("data-fp-omit", "");

            fp._bind(secondInput, ["focus", "click"], function () {
              if (fp.selectedDates[1]) {
                fp.latestSelectedDateObj = fp.selectedDates[1];

                fp._setHoursFromDate(fp.selectedDates[1]);

                fp.jumpToDate(fp.selectedDates[1]);
              }

              _secondInputFocused = true;
              fp.isOpen = false;
              fp.open(undefined, config.position === "left" ? fp._input : secondInput);
            });

            fp._bind(fp._input, ["focus", "click"], function (e) {
              e.preventDefault();
              fp.isOpen = false;
              fp.open();
            });

            if (fp.config.allowInput) fp._bind(secondInput, "keydown", function (e) {
              if (e.key === "Enter") {
                fp.setDate([fp.selectedDates[0], secondInput.value], true, dateFormat);
                secondInput.click();
              }
            });
            if (!config.input) fp._input.parentNode && fp._input.parentNode.insertBefore(secondInput, fp._input.nextSibling);
          };

          var plugin = {
            onParseConfig: function () {
              fp.config.mode = "range";
              dateFormat = fp.config.altInput ? fp.config.altFormat : fp.config.dateFormat;
            },
            onReady: function () {
              createSecondInput();
              fp.config.ignoredFocusElements.push(secondInput);

              if (fp.config.allowInput) {
                fp._input.removeAttribute("readonly");

                secondInput.removeAttribute("readonly");
              } else {
                secondInput.setAttribute("readonly", "readonly");
              }

              fp._bind(fp._input, "focus", function () {
                fp.latestSelectedDateObj = fp.selectedDates[0];

                fp._setHoursFromDate(fp.selectedDates[0]);

                _secondInputFocused = false;
                fp.jumpToDate(fp.selectedDates[0]);
              });

              if (fp.config.allowInput) fp._bind(fp._input, "keydown", function (e) {
                if (e.key === "Enter") fp.setDate([fp._input.value, fp.selectedDates[1]], true, dateFormat);
              });
              fp.setDate(fp.selectedDates, false);
              plugin.onValueUpdate(fp.selectedDates);
              fp.loadedPlugins.push("range");
            },
            onPreCalendarPosition: function () {
              if (_secondInputFocused) {
                fp._positionElement = secondInput;
                setTimeout(function () {
                  fp._positionElement = fp._input;
                }, 0);
              }
            },
            onChange: function () {
              if (!fp.selectedDates.length) {
                setTimeout(function () {
                  if (fp.selectedDates.length) return;
                  secondInput.value = "";
                  _prevDates = [];
                }, 10);
              }

              if (_secondInputFocused) {
                setTimeout(function () {
                  secondInput.focus();
                }, 0);
              }
            },
            onDestroy: function () {
              if (!config.input) secondInput.parentNode && secondInput.parentNode.removeChild(secondInput);
            },
            onValueUpdate: function (selDates) {
              var _a, _b, _c;

              if (!secondInput) return;
              _prevDates = !_prevDates || selDates.length >= _prevDates.length ? selDates.slice() : _prevDates;

              if (_prevDates.length > selDates.length) {
                var newSelectedDate = selDates[0];
                var newDates = _secondInputFocused ? [_prevDates[0], newSelectedDate] : [newSelectedDate, _prevDates[1]];
                fp.setDate(newDates, false);
                _prevDates = newDates.slice();
              }

              _a = fp.selectedDates.map(function (d) {
                return fp.formatDate(d, dateFormat);
              }), _b = _a[0], fp._input.value = _b === void 0 ? "" : _b, _c = _a[1], secondInput.value = _c === void 0 ? "" : _c;
            }
          };
          return plugin;
        };
      }

      return rangePlugin;
    });
  });

  var prefix$N = settings_1.prefix;

  var DatePickerInput =
  /*#__PURE__*/
  function (_Component) {
    _inherits(DatePickerInput, _Component);

    function DatePickerInput() {
      _classCallCheck(this, DatePickerInput);

      return _possibleConstructorReturn(this, _getPrototypeOf(DatePickerInput).apply(this, arguments));
    }

    _createClass(DatePickerInput, [{
      key: "render",
      value: function render() {
        var _classNames,
            _this = this;

        var _this$props = this.props,
            id = _this$props.id,
            labelText = _this$props.labelText,
            disabled = _this$props.disabled,
            invalid = _this$props.invalid,
            invalidText = _this$props.invalidText,
            hideLabel = _this$props.hideLabel,
            _onChange = _this$props.onChange,
            _onClick = _this$props.onClick,
            placeholder = _this$props.placeholder,
            type = _this$props.type,
            datePickerType = _this$props.datePickerType,
            pattern = _this$props.pattern,
            iconDescription = _this$props.iconDescription,
            openCalendar = _this$props.openCalendar,
            other = _objectWithoutProperties(_this$props, ["id", "labelText", "disabled", "invalid", "invalidText", "hideLabel", "onChange", "onClick", "placeholder", "type", "datePickerType", "pattern", "iconDescription", "openCalendar"]);

        var datePickerInputProps = {
          id: id,
          onChange: function onChange(evt) {
            if (!disabled) {
              _onChange(evt);
            }
          },
          onClick: function onClick(evt) {
            if (!disabled) {
              _onClick(evt);
            }
          },
          placeholder: placeholder,
          type: type,
          pattern: pattern
        };
        var labelClasses = classNames("".concat(prefix$N, "--label"), (_classNames = {}, _defineProperty(_classNames, "".concat(prefix$N, "--visually-hidden"), hideLabel), _defineProperty(_classNames, "".concat(prefix$N, "--label--disabled"), disabled), _classNames));

        var datePickerIcon = function () {
          if (datePickerType === 'simple') {
            return;
          }

          return React__default.createElement(Calendar16, {
            className: "".concat(prefix$N, "--date-picker__icon"),
            "aria-label": iconDescription,
            onClick: openCalendar,
            role: "img"
          }, iconDescription && React__default.createElement("title", null, iconDescription));
        }();

        var label = labelText ? React__default.createElement("label", {
          htmlFor: id,
          className: labelClasses
        }, labelText) : null;
        var error = invalid ? React__default.createElement("div", {
          className: "".concat(prefix$N, "--form-requirement")
        }, invalidText) : null;
        var containerClasses = classNames("".concat(prefix$N, "--date-picker-container"), _defineProperty({}, "".concat(prefix$N, "--date-picker--nolabel"), !label));
        var input = invalid ? React__default.createElement("input", _extends({}, other, datePickerInputProps, {
          disabled: disabled,
          ref: function ref(input) {
            _this.input = input;
          },
          "data-invalid": true,
          className: "".concat(prefix$N, "--date-picker__input")
        })) : React__default.createElement("input", _extends({
          ref: function ref(input) {
            _this.input = input;
          }
        }, other, datePickerInputProps, {
          disabled: disabled,
          className: "".concat(prefix$N, "--date-picker__input")
        }));
        return React__default.createElement("div", {
          className: containerClasses
        }, label, React__default.createElement("div", {
          className: "".concat(prefix$N, "--date-picker-input__wrapper")
        }, input, datePickerIcon), error);
      }
    }]);

    return DatePickerInput;
  }(React.Component);

  _defineProperty(DatePickerInput, "propTypes", {
    /**
     * Specify an id that unique identifies the <input>
     */
    id: PropTypes__default.string.isRequired,

    /**
     * The description of the calendar icon.
     */
    iconDescription: PropTypes__default.string,

    /**
     * Provide the text that will be read by a screen reader when visiting this
     * control
     */
    labelText: PropTypes__default.node.isRequired
  });

  _defineProperty(DatePickerInput, "defaultProps", {
    pattern: '\\d{1,2}\\/\\d{1,2}\\/\\d{4}',
    type: 'text',
    disabled: false,
    invalid: false,
    onClick: function onClick() {},
    onChange: function onChange() {}
  });

  var prefix$O = settings_1.prefix; // Weekdays shorthand for english locale

  l10n$1.en.weekdays.shorthand.forEach(function (day, index) {
    var currentDay = l10n$1.en.weekdays.shorthand;

    if (currentDay[index] === 'Thu' || currentDay[index] === 'Th') {
      currentDay[index] = 'Th';
    } else {
      currentDay[index] = currentDay[index].charAt(0);
    }
  });
  var forEach$1 = Array.prototype.forEach;
  /**
   * @param {number} monthNumber The month number.
   * @param {boolean} shorthand `true` to use shorthand month.
   * @param {Locale} locale The Flatpickr locale data.
   * @returns {string} The month string.
   */

  var monthToStr$1 = function monthToStr(monthNumber, shorthand, locale) {
    return locale.months[shorthand ? 'shorthand' : 'longhand'][monthNumber];
  };
  /**
   * @param {object} config Plugin configuration.
   * @param {boolean} [config.shorthand] `true` to use shorthand month.
   * @param {string} config.selectorFlatpickrMonthYearContainer The CSS selector for the container of month/year selection UI.
   * @param {string} config.selectorFlatpickrYearContainer The CSS selector for the container of year selection UI.
   * @param {string} config.selectorFlatpickrCurrentMonth The CSS selector for the text-based month selection UI.
   * @param {string} config.classFlatpickrCurrentMonth The CSS class for the text-based month selection UI.
   * @returns {Plugin} A Flatpickr plugin to use text instead of `<select>` for month picker.
   */


  var carbonFlatpickrMonthSelectPlugin$1 = function carbonFlatpickrMonthSelectPlugin(config) {
    return function (fp) {
      var setupElements = function setupElements() {
        var _fp$monthElements;

        if (!fp.monthElements) {
          return;
        }

        fp.monthElements.forEach(function (elem) {
          if (!elem.parentNode) return;
          elem.parentNode.removeChild(elem);
        });

        (_fp$monthElements = fp.monthElements).splice.apply(_fp$monthElements, [0, fp.monthElements.length].concat(_toConsumableArray(fp.monthElements.map(function () {
          // eslint-disable-next-line no-underscore-dangle
          var monthElement = fp._createElement('span', config.classFlatpickrCurrentMonth);

          monthElement.textContent = monthToStr$1(fp.currentMonth, config.shorthand === true, fp.l10n);
          fp.yearElements[0].closest(config.selectorFlatpickrMonthYearContainer).insertBefore(monthElement, fp.yearElements[0].closest(config.selectorFlatpickrYearContainer));
          return monthElement;
        }))));
      };

      var updateCurrentMonth = function updateCurrentMonth() {
        var monthStr = monthToStr$1(fp.currentMonth, config.shorthand === true, fp.l10n);
        fp.yearElements.forEach(function (elem) {
          var currentMonthContainer = elem.closest(config.selectorFlatpickrMonthYearContainer);
          Array.prototype.forEach.call(currentMonthContainer.querySelectorAll('.cur-month'), function (monthElement) {
            monthElement.textContent = monthStr;
          });
        });
      };

      var register = function register() {
        fp.loadedPlugins.push('carbonFlatpickrMonthSelectPlugin');
      };

      return {
        onMonthChange: updateCurrentMonth,
        onOpen: updateCurrentMonth,
        onReady: [setupElements, updateCurrentMonth, register]
      };
    };
  };

  var DatePicker$1 =
  /*#__PURE__*/
  function (_Component) {
    _inherits(DatePicker, _Component);

    function DatePicker() {
      var _getPrototypeOf2;

      var _this;

      _classCallCheck(this, DatePicker);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(DatePicker)).call.apply(_getPrototypeOf2, [this].concat(args)));

      _defineProperty(_assertThisInitialized(_this), "onChange", function (e) {
        if (e.target.value === '' && _this.cal && _this.cal.selectedDates.length > 0) {
          _this.cal.clear();
        }
      });

      _defineProperty(_assertThisInitialized(_this), "addKeyboardEvents", function (cal) {
        if (_this.inputField) {
          _this.inputField.addEventListener('keydown', function (e) {
            if (match(e, ArrowDown)) {
              (cal.selectedDateElem || cal.todayDateElem || cal.calendarContainer).focus();
            }
          });

          _this.inputField.addEventListener('change', _this.onChange);
        }

        if (_this.toInputField) {
          _this.toInputField.addEventListener('blur', function (evt) {
            if (!_this.cal.calendarContainer.contains(evt.relatedTarget)) {
              _this.cal.close();
            }
          });

          _this.toInputField.addEventListener('keydown', function (e) {
            if (match(e, ArrowDown)) {
              (cal.selectedDateElem || cal.todayDateElem || cal.calendarContainer).focus();
            }
          });

          _this.toInputField.addEventListener('change', _this.onChange);
        }
      });

      _defineProperty(_assertThisInitialized(_this), "openCalendar", function () {
        if (_this.cal) {
          _this.cal.open();
        }
      });

      _defineProperty(_assertThisInitialized(_this), "updateClassNames", function (calendar) {
        var calendarContainer = calendar.calendarContainer;
        var daysContainer = calendar.days;

        if (calendarContainer && daysContainer) {
          // calendarContainer and daysContainer are undefined if flatpickr detects a mobile device
          calendarContainer.classList.add("".concat(prefix$O, "--date-picker__calendar"));
          calendarContainer.querySelector('.flatpickr-month').classList.add("".concat(prefix$O, "--date-picker__month"));
          calendarContainer.querySelector('.flatpickr-weekdays').classList.add("".concat(prefix$O, "--date-picker__weekdays"));
          calendarContainer.querySelector('.flatpickr-days').classList.add("".concat(prefix$O, "--date-picker__days"));
          forEach$1.call(calendarContainer.querySelectorAll('.flatpickr-weekday'), function (item) {
            var currentItem = item;
            currentItem.innerHTML = currentItem.innerHTML.replace(/\s+/g, '');
            currentItem.classList.add("".concat(prefix$O, "--date-picker__weekday"));
          });
          forEach$1.call(daysContainer.querySelectorAll('.flatpickr-day'), function (item) {
            item.classList.add("".concat(prefix$O, "--date-picker__day"));

            if (item.classList.contains('today') && calendar.selectedDates.length > 0) {
              item.classList.add('no-border');
            } else if (item.classList.contains('today') && calendar.selectedDates.length === 0) {
              item.classList.remove('no-border');
            }
          });
        }
      });

      _defineProperty(_assertThisInitialized(_this), "assignInputFieldRef", function (node) {
        _this.inputField = !node ? null : // Child is a regular DOM node, seen in tests
        node.nodeType === Node.ELEMENT_NODE ? node.querySelector(".".concat(prefix$O, "--date-picker__input")) : // Child is a React component
        node.input && node.input.nodeType === Node.ELEMENT_NODE ? node.input : null;
      });

      _defineProperty(_assertThisInitialized(_this), "assignToInputFieldRef", function (node) {
        _this.toInputField = !node ? null : // Child is a regular DOM node, seen in tests
        node.nodeType === Node.ELEMENT_NODE ? node.querySelector(".".concat(prefix$O, "--date-picker__input")) : // Child is a React component
        node.input && node.input.nodeType === Node.ELEMENT_NODE ? node.input : null;
      });

      _defineProperty(_assertThisInitialized(_this), "isLabelTextEmpty", function (children) {
        return children.every(function (child) {
          return !child.props.labelText;
        });
      });

      return _this;
    }

    _createClass(DatePicker, [{
      key: "UNSAFE_componentWillUpdate",
      value: function UNSAFE_componentWillUpdate(nextProps) {
        if (nextProps.value !== this.props.value) {
          if (this.cal) {
            this.cal.setDate(nextProps.value);
            this.updateClassNames(this.cal);
          } else {
            if (this.inputField) {
              this.inputField.value = nextProps.value;
            }
          }
        }
      }
    }, {
      key: "componentDidMount",
      value: function componentDidMount() {
        var _this2 = this;

        var _this$props = this.props,
            datePickerType = _this$props.datePickerType,
            dateFormat = _this$props.dateFormat,
            locale = _this$props.locale,
            minDate = _this$props.minDate,
            maxDate = _this$props.maxDate,
            value = _this$props.value,
            onClose = _this$props.onClose;

        if (datePickerType === 'single' || datePickerType === 'range') {
          var onHook = function onHook(electedDates, dateStr, instance) {
            _this2.updateClassNames(instance);
          };

          var appendToNode; // inputField ref might not be set in enzyme tests

          if (this.inputField) {
            this.cal = new flatpickr(this.inputField, {
              defaultDate: value,
              appendTo: appendToNode,
              mode: datePickerType,
              allowInput: true,
              dateFormat: dateFormat,
              locale: l10n$1[locale],
              minDate: minDate,
              maxDate: maxDate,
              plugins: [datePickerType === 'range' ? new rangePlugin({
                input: this.toInputField,
                position: 'left'
              }) : function () {}, carbonFlatpickrMonthSelectPlugin$1({
                selectorFlatpickrMonthYearContainer: '.flatpickr-current-month',
                selectorFlatpickrYearContainer: '.numInputWrapper',
                selectorFlatpickrCurrentMonth: '.cur-month',
                classFlatpickrCurrentMonth: 'cur-month'
              })],
              clickOpens: true,
              nextArrow: this.rightArrowHTML(),
              prevArrow: this.leftArrowHTML(),
              onChange: function onChange() {
                var onChange = _this2.props.onChange;

                if (onChange) {
                  onChange.apply(void 0, arguments);
                }
              },
              onClose: onClose,
              onReady: onHook,
              onMonthChange: onHook,
              onYearChange: onHook,
              onOpen: onHook,
              onValueUpdate: onHook
            });
            this.addKeyboardEvents(this.cal);
          }
        }
      }
    }, {
      key: "componentWillUnmount",
      value: function componentWillUnmount() {
        if (this.cal) {
          this.cal.destroy();
        }

        if (this.inputField) {
          this.inputField.removeEventListener('change', this.onChange);
        }

        if (this.toInputField) {
          this.toInputField.removeEventListener('change', this.onChange);
        }
      }
    }, {
      key: "rightArrowHTML",
      value: function rightArrowHTML() {
        return "\n      <svg width=\"16px\" height=\"16px\" viewBox=\"0 0 16 16\">\n        <polygon points=\"11,8 6,13 5.3,12.3 9.6,8 5.3,3.7 6,3 \"/>\n        <rect width=\"16\" height=\"16\" style=\"fill:none\" />\n      </svg>";
      }
    }, {
      key: "leftArrowHTML",
      value: function leftArrowHTML() {
        return "\n      <svg width=\"16px\" height=\"16px\" viewBox=\"0 0 16 16\">\n        <polygon points=\"5,8 10,3 10.7,3.7 6.4,8 10.7,12.3 10,13 \"/>\n        <rect width=\"16\" height=\"16\" style=\"fill:none\" />\n      </svg>";
      }
    }, {
      key: "render",
      value: function render() {
        var _classNames,
            _this3 = this;

        var _this$props2 = this.props,
            appendTo = _this$props2.appendTo,
            children = _this$props2.children,
            className = _this$props2.className,
            short = _this$props2.short,
            light = _this$props2.light,
            datePickerType = _this$props2.datePickerType,
            minDate = _this$props2.minDate,
            maxDate = _this$props2.maxDate,
            dateFormat = _this$props2.dateFormat,
            onChange = _this$props2.onChange,
            locale = _this$props2.locale,
            value = _this$props2.value,
            other = _objectWithoutProperties(_this$props2, ["appendTo", "children", "className", "short", "light", "datePickerType", "minDate", "maxDate", "dateFormat", "onChange", "locale", "value"]);

        var datePickerClasses = classNames("".concat(prefix$O, "--date-picker"), className, (_classNames = {}, _defineProperty(_classNames, "".concat(prefix$O, "--date-picker--short"), short), _defineProperty(_classNames, "".concat(prefix$O, "--date-picker--light"), light), _defineProperty(_classNames, "".concat(prefix$O, "--date-picker--simple"), datePickerType === 'simple'), _defineProperty(_classNames, "".concat(prefix$O, "--date-picker--single"), datePickerType === 'single'), _defineProperty(_classNames, "".concat(prefix$O, "--date-picker--range"), datePickerType === 'range'), _defineProperty(_classNames, "".concat(prefix$O, "--date-picker--nolabel"), datePickerType === 'range' && this.isLabelTextEmpty(children)), _classNames));
        var childArray = React__default.Children.toArray(children);
        var childrenWithProps = childArray.map(function (child, index) {
          if (index === 0 && child.type === DatePickerInput) {
            return React__default.cloneElement(child, {
              datePickerType: datePickerType,
              ref: _this3.assignInputFieldRef,
              openCalendar: _this3.openCalendar
            });
          } else if (index === 1 && child.type === DatePickerInput) {
            return React__default.cloneElement(child, {
              datePickerType: datePickerType,
              ref: _this3.assignToInputFieldRef
            });
          } else if (index === 0) {
            return React__default.cloneElement(child, {
              ref: _this3.assignInputFieldRef
            });
          } else if (index === 1) {
            return React__default.cloneElement(child, {
              ref: _this3.assignToInputFieldRef
            });
          }
        });
        return React__default.createElement("div", {
          className: "".concat(prefix$O, "--form-item")
        }, React__default.createElement("div", _extends({
          className: datePickerClasses
        }, other), childrenWithProps));
      }
    }]);

    return DatePicker;
  }(React.Component);

  _defineProperty(DatePicker$1, "propTypes", {
    /**
     * The child nodes.
     */
    children: PropTypes__default.node,

    /**
     * The CSS class names.
     */
    className: PropTypes__default.string,

    /**
     * `true` to use the short version.
     */
    short: PropTypes__default.bool,

    /**
     * `true` to use the light version.
     */
    light: PropTypes__default.bool,

    /**
     * The type of the date picker:
     *
     * * `simple` - Without calendar dropdown.
     * * `single` - With calendar dropdown and single date.
     * * `range` - With calendar dropdown and a date range.
     */
    datePickerType: PropTypes__default.oneOf(['simple', 'single', 'range']),

    /**
     * The date format.
     */
    dateFormat: PropTypes__default.string,

    /**
     *  The language locale used to format the days of the week, months, and numbers.
     *
     * * `ar` - Arabic
     * * `at` - Austria
     * * `be` - Belarusian
     * * `bg` - Bulgarian
     * * `bn` - Bangla
     * * `cat` - Catalan
     * * `cs` - Czech
     * * `cy` - Welsh
     * * `da` - Danish
     * * `de` - German
     * * `en` - English
     * * `eo` - Esperanto
     * * `es` - Spanish
     * * `et` - Estonian
     * * `fa` - Persian
     * * `fi` - Finnish
     * * `fr` - French
     * * `gr` - Greek
     * * `he` - Hebrew
     * * `hi` - Hindi
     * * `hr` - Croatian
     * * `hu` - Hungarian
     * * `id` - Indonesian
     * * `it` - Italian
     * * `ja` - Japanese
     * * `ko` - Korean
     * * `lt` - Lithuanian
     * * `lv` - Latvian
     * * `mk` - Macedonian
     * * `mn` - Mongolian
     * * `ms` - Malaysian
     * * `my` - Burmese
     * * `nl` - Dutch
     * * `no` - Norwegian
     * * `pa` - Punjabi
     * * `pl` - Polish
     * * `pt` - Portuguese
     * * `ro` - Romanian
     * * `si` - Sinhala
     * * `sk` - Slovak
     * * `sl` - Slovenian
     * * `sq` - Albanian
     * * `sr` - Serbian
     * * `sv` - Swedish
     * * `th` - Thai
     * * `tr` - Turkish
     * * `uk` - Ukrainian
     * * `vn` - Vietnamese
     * * `zh` - Mandarin
     */
    locale: PropTypes__default.oneOf(['ar', 'at', 'be', 'bg', 'bn', 'cat', 'cs', 'cy', 'da', 'de', 'en', 'en', 'eo', 'es', 'et', 'fa', 'fi', 'fr', 'gr', 'he', 'hi', 'hr', 'hu', 'id', 'it', 'ja', 'ko', 'lt', 'lv', 'mk', 'mn', 'ms', 'my', 'nl', 'no', 'pa', 'pl', 'pt', 'ro', 'ru', 'si', 'sk', 'sl', 'sq', 'sr', 'sv', 'th', 'tr', 'uk', 'vn', 'zh']),

    /**
     * The value of the date value provided to flatpickr, could
     * be a date, a date number, a date string, an array of dates.
     */
    value: PropTypes__default.oneOfType([PropTypes__default.string, PropTypes__default.arrayOf(PropTypes__default.oneOfType([PropTypes__default.string, PropTypes__default.number, PropTypes__default.object])), PropTypes__default.object, PropTypes__default.number]),

    /**
     * The DOM element or selector the Flatpicker should be inserted into. `<body>` by default.
     */
    appendTo: PropTypes__default.oneOfType([PropTypes__default.string, PropTypes__default.object]),

    /**
     * The `change` event handler.
     */
    onChange: PropTypes__default.func,

    /**
     * The `close` event handler.
     */
    onClose: PropTypes__default.func,

    /**
     * The minimum date that a user can start picking from.
     */
    minDate: PropTypes__default.string,

    /**
     * The maximum date that a user can pick to.
     */
    maxDate: PropTypes__default.string
  });

  _defineProperty(DatePicker$1, "defaultProps", {
    short: false,
    light: false,
    dateFormat: 'm/d/Y',
    locale: 'en'
  });

  var prefix$P = settings_1.prefix;

  var DropdownSkeleton = function DropdownSkeleton(_ref) {
    var _classNames;

    var inline = _ref.inline;
    var wrapperClasses = classNames((_classNames = {}, _defineProperty(_classNames, "".concat(prefix$P, "--skeleton"), true), _defineProperty(_classNames, "".concat(prefix$P, "--dropdown-v2"), true), _defineProperty(_classNames, "".concat(prefix$P, "--list-box"), true), _defineProperty(_classNames, "".concat(prefix$P, "--form-item"), true), _defineProperty(_classNames, "".concat(prefix$P, "--list-box--inline"), inline), _classNames));
    return React__default.createElement("div", {
      className: wrapperClasses
    }, React__default.createElement("div", {
      role: "button",
      className: "".concat(prefix$P, "--list-box__field")
    }, React__default.createElement("span", {
      className: "".concat(prefix$P, "--list-box__label")
    })));
  };

  DropdownSkeleton.propTypes = {
    /**
     * Specify whether you want the inline version of this control
     */
    inline: PropTypes__default.bool
  };
  DropdownSkeleton.defaultProps = {
    inline: false
  };

  var prefix$Q = settings_1.prefix;

  var defaultItemToString$1 = function defaultItemToString(item) {
    if (typeof item === 'string') {
      return item;
    }

    return item ? item.label : '';
  };

  var Dropdown$1 =
  /*#__PURE__*/
  function (_React$Component) {
    _inherits(Dropdown, _React$Component);

    function Dropdown() {
      var _getPrototypeOf2;

      var _this;

      _classCallCheck(this, Dropdown);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(Dropdown)).call.apply(_getPrototypeOf2, [this].concat(args)));

      _defineProperty(_assertThisInitialized(_this), "handleOnChange", function (selectedItem) {
        if (_this.props.onChange) {
          _this.props.onChange({
            selectedItem: selectedItem
          });
        }
      });

      return _this;
    }

    _createClass(Dropdown, [{
      key: "render",
      value: function render() {
        var _cx4;

        var _this$props = this.props,
            containerClassName = _this$props.className,
            disabled = _this$props.disabled,
            items = _this$props.items,
            label = _this$props.label,
            ariaLabel = _this$props.ariaLabel,
            itemToString = _this$props.itemToString,
            itemToElement = _this$props.itemToElement,
            type = _this$props.type,
            initialSelectedItem = _this$props.initialSelectedItem,
            selectedItem = _this$props.selectedItem,
            id = _this$props.id,
            titleText = _this$props.titleText,
            helperText = _this$props.helperText,
            translateWithId = _this$props.translateWithId,
            light = _this$props.light,
            invalid = _this$props.invalid,
            invalidText = _this$props.invalidText,
            downshiftProps = _this$props.downshiftProps;
        var inline = type === 'inline';

        var className = function className(_ref) {
          var _cx;

          var isOpen = _ref.isOpen;
          return classNames("".concat(prefix$Q, "--dropdown"), containerClassName, (_cx = {}, _defineProperty(_cx, "".concat(prefix$Q, "--dropdown--invalid"), invalid), _defineProperty(_cx, "".concat(prefix$Q, "--dropdown--open"), isOpen), _defineProperty(_cx, "".concat(prefix$Q, "--dropdown--inline"), inline), _defineProperty(_cx, "".concat(prefix$Q, "--dropdown--disabled"), disabled), _defineProperty(_cx, "".concat(prefix$Q, "--dropdown--light"), light), _cx));
        };

        var titleClasses = classNames("".concat(prefix$Q, "--label"), _defineProperty({}, "".concat(prefix$Q, "--label--disabled"), disabled));
        var title = titleText ? React__default.createElement("label", {
          htmlFor: id,
          className: titleClasses
        }, titleText) : null;
        var helperClasses = classNames("".concat(prefix$Q, "--form__helper-text"), _defineProperty({}, "".concat(prefix$Q, "--form__helper-text--disabled"), disabled));
        var helper = helperText ? React__default.createElement("div", {
          className: helperClasses
        }, helperText) : null;
        var wrapperClasses = classNames("".concat(prefix$Q, "--dropdown__wrapper"), "".concat(prefix$Q, "--list-box__wrapper"), (_cx4 = {}, _defineProperty(_cx4, "".concat(prefix$Q, "--dropdown__wrapper--inline"), inline), _defineProperty(_cx4, "".concat(prefix$Q, "--list-box__wrapper--inline"), inline), _defineProperty(_cx4, "".concat(prefix$Q, "--dropdown__wrapper--inline--invalid"), inline && invalid), _defineProperty(_cx4, "".concat(prefix$Q, "--list-box__wrapper--inline--invalid"), inline && invalid), _cx4)); // needs to be Capitalized for react to render it correctly

        var ItemToElement = itemToElement;
        return React__default.createElement("div", {
          className: wrapperClasses
        }, title, !inline && helper, React__default.createElement(Downshift, _extends({}, downshiftProps, {
          onChange: this.handleOnChange,
          itemToString: itemToString,
          defaultSelectedItem: initialSelectedItem,
          selectedItem: selectedItem
        }), function (_ref2) {
          var isOpen = _ref2.isOpen,
              itemToString = _ref2.itemToString,
              selectedItem = _ref2.selectedItem,
              highlightedIndex = _ref2.highlightedIndex,
              getRootProps = _ref2.getRootProps,
              getButtonProps = _ref2.getButtonProps,
              getItemProps = _ref2.getItemProps,
              getLabelProps = _ref2.getLabelProps;
          return React__default.createElement(ListBox, _extends({
            id: id,
            type: type,
            className: className({
              isOpen: isOpen
            }),
            disabled: disabled,
            isOpen: isOpen,
            invalid: invalid,
            invalidText: invalidText,
            light: light
          }, getRootProps({
            refKey: 'innerRef'
          })), invalid && React__default.createElement(WarningFilled16, {
            className: "".concat(prefix$Q, "--list-box__invalid-icon")
          }), React__default.createElement(ListBox.Field, _extends({
            id: id,
            tabIndex: "0",
            disabled: disabled,
            "aria-disabled": disabled,
            translateWithId: translateWithId
          }, getButtonProps({
            disabled: disabled
          })), React__default.createElement("span", _extends({
            className: "".concat(prefix$Q, "--list-box__label")
          }, getLabelProps()), selectedItem ? itemToString(selectedItem) : label), React__default.createElement(ListBox.MenuIcon, {
            isOpen: isOpen,
            translateWithId: translateWithId
          })), isOpen && React__default.createElement(ListBox.Menu, {
            "aria-label": ariaLabel,
            id: id
          }, items.map(function (item, index) {
            return React__default.createElement(ListBox.MenuItem, _extends({
              key: itemToString(item),
              isActive: selectedItem === item,
              isHighlighted: highlightedIndex === index || selectedItem === item
            }, getItemProps({
              item: item,
              index: index
            })), itemToElement ? React__default.createElement(ItemToElement, _extends({
              key: itemToString(item)
            }, item)) : itemToString(item));
          })));
        }));
      }
    }]);

    return Dropdown;
  }(React__default.Component);

  _defineProperty(Dropdown$1, "propTypes", {
    /**
     * Disable the control
     */
    disabled: PropTypes__default.bool,

    /**
     * We try to stay as generic as possible here to allow individuals to pass
     * in a collection of whatever kind of data structure they prefer
     */
    items: PropTypes__default.array.isRequired,

    /**
     * Allow users to pass in an arbitrary item or a string (in case their items are an array of strings)
     * from their collection that are pre-selected
     */
    initialSelectedItem: PropTypes__default.oneOfType([PropTypes__default.object, PropTypes__default.string]),

    /**
     * Specify a custom `id`
     */
    id: PropTypes__default.string.isRequired,

    /**
     * Specify whether you want the inline version of this control
     */
    inline: PropTypes__default.bool,

    /**
     * Specify if the currently selected value is invalid.
     */
    invalid: PropTypes__default.bool,

    /**
     * Message which is displayed if the value is invalid.
     */
    invalidText: PropTypes__default.string,

    /**
     * Helper function passed to downshift that allows the library to render a
     * given item to a string label. By default, it extracts the `label` field
     * from a given item to serve as the item label in the list.
     */
    itemToString: PropTypes__default.func,

    /**
     * Function to render items as custom components instead of strings.
     * Defaults to null and is overriden by a getter
     */
    itemToElement: PropTypes__default.func,

    /**
     * `onChange` is a utility for this controlled component to communicate to a
     * consuming component what kind of internal state changes are occuring.
     */
    onChange: PropTypes__default.func,

    /**
     * Generic `label` that will be used as the textual representation of what
     * this field is for
     */
    label: PropTypes__default.node.isRequired,

    /**
     * Callback function for translating ListBoxMenuIcon SVG title
     */
    translateWithId: PropTypes__default.func,

    /**
     * 'aria-label' of the ListBox component.
     */
    ariaLabel: PropTypes__default.string,

    /**
     * The dropdown type, `default` or `inline`
     */
    type: ListBoxType,

    /**
     * In the case you want to control the dropdown selection entirely.
     */
    selectedItem: PropTypes__default.oneOfType([PropTypes__default.object, PropTypes__default.string]),

    /**
     * `true` to use the light version.
     */
    light: PropTypes__default.bool,

    /**
     * Provide the title text that will be read by a screen reader when
     * visiting this control
     */
    titleText: PropTypes__default.oneOfType([PropTypes__default.string, PropTypes__default.node]),

    /**
     * Provide helper text that is used alongside the control label for
     * additional help
     */
    helperText: PropTypes__default.oneOfType([PropTypes__default.string, PropTypes__default.node]),

    /**
     * Additional props passed to Downshift
     */
    downshiftProps: PropTypes__default.shape(Downshift.propTypes)
  });

  _defineProperty(Dropdown$1, "defaultProps", {
    disabled: false,
    type: 'default',
    itemToString: defaultItemToString$1,
    itemToElement: null,
    light: false,
    titleText: '',
    helperText: ''
  });

  var prefix$R = settings_1.prefix;

  var FileUploaderSkeleton =
  /*#__PURE__*/
  function (_React$Component) {
    _inherits(FileUploaderSkeleton, _React$Component);

    function FileUploaderSkeleton() {
      _classCallCheck(this, FileUploaderSkeleton);

      return _possibleConstructorReturn(this, _getPrototypeOf(FileUploaderSkeleton).apply(this, arguments));
    }

    _createClass(FileUploaderSkeleton, [{
      key: "render",
      value: function render() {
        return React__default.createElement("div", {
          className: "".concat(prefix$R, "--form-item")
        }, React__default.createElement(SkeletonText, {
          heading: true,
          width: "100px"
        }), React__default.createElement(SkeletonText, {
          width: "225px",
          className: "".concat(prefix$R, "--label-description")
        }), React__default.createElement(ButtonSkeleton, null));
      }
    }]);

    return FileUploaderSkeleton;
  }(React__default.Component);

  var prefix$S = settings_1.prefix;
  var FileUploaderButton =
  /*#__PURE__*/
  function (_Component) {
    _inherits(FileUploaderButton, _Component);

    function FileUploaderButton() {
      var _getPrototypeOf2;

      var _this;

      _classCallCheck(this, FileUploaderButton);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(FileUploaderButton)).call.apply(_getPrototypeOf2, [this].concat(args)));

      _defineProperty(_assertThisInitialized(_this), "state", {});

      _defineProperty(_assertThisInitialized(_this), "handleChange", function (evt) {
        var files = evt.target.files;
        var length = evt.target.files.length;

        if (files && !_this.props.disableLabelChanges) {
          if (length > 1) {
            _this.setState({
              labelText: "".concat(length, " files")
            });
          } else if (length === 1) {
            _this.setState({
              labelText: files[0].name
            });
          }
        }

        _this.props.onChange(evt);
      });

      return _this;
    }

    _createClass(FileUploaderButton, [{
      key: "render",
      value: function render() {
        var _this2 = this;

        var _this$props = this.props,
            className = _this$props.className,
            disableLabelChanges = _this$props.disableLabelChanges,
            labelText = _this$props.labelText,
            multiple = _this$props.multiple,
            role = _this$props.role,
            tabIndex = _this$props.tabIndex,
            buttonKind = _this$props.buttonKind,
            accept = _this$props.accept,
            name = _this$props.name,
            disabled = _this$props.disabled,
            other = _objectWithoutProperties(_this$props, ["className", "disableLabelChanges", "labelText", "multiple", "role", "tabIndex", "buttonKind", "accept", "name", "disabled"]);

        var classes = classNames("".concat(prefix$S, "--btn"), "".concat(prefix$S, "--btn--sm"), className, _defineProperty({}, "".concat(prefix$S, "--btn--").concat(buttonKind), buttonKind));
        this.uid = this.props.id || uid();
        return React__default.createElement(React__default.Fragment, null, React__default.createElement("label", _extends({
          tabIndex: tabIndex || 0,
          className: classes,
          onKeyDown: function onKeyDown(evt) {
            if (evt.which === 13 || evt.which === 32) {
              _this2.input.click();
            }
          },
          htmlFor: this.uid,
          role: role
        }, other), this.state.labelText), React__default.createElement("input", {
          className: "".concat(prefix$S, "--visually-hidden"),
          ref: function ref(input) {
            return _this2.input = input;
          },
          id: this.uid,
          disabled: disabled,
          type: "file",
          tabIndex: "-1",
          multiple: multiple,
          accept: accept,
          name: name,
          onChange: this.handleChange,
          onClick: function onClick(evt) {
            evt.target.value = null;
          }
        }));
      }
    }], [{
      key: "getDerivedStateFromProps",
      value: function getDerivedStateFromProps(_ref, state) {
        var labelText = _ref.labelText;
        var prevLabelText = state.prevLabelText;
        return prevLabelText === labelText ? null : {
          labelText: labelText,
          prevLabelText: labelText
        };
      }
    }]);

    return FileUploaderButton;
  }(React.Component);

  _defineProperty(FileUploaderButton, "propTypes", {
    /**
     * Provide a custom className to be applied to the container node
     */
    className: PropTypes__default.string,

    /**
     * Specify whether you want to disable any updates to the FileUploaderButton
     * label
     */
    disableLabelChanges: PropTypes__default.bool,

    /**
     * Provide a unique id for the underlying <input> node
     */
    id: PropTypes__default.string,

    /**
     * Provide the label text to be read by screen readers when interacting with
     * this control
     */
    labelText: PropTypes__default.node,

    /**
     * Specify whether you want the component to list the files that have been
     * submitted to be uploaded
     */
    listFiles: PropTypes__default.bool,

    /**
     * Specify if the component should accept multiple files to upload
     */
    multiple: PropTypes__default.bool,

    /**
     * Provide a name for the underlying <input> node
     */
    name: PropTypes__default.string,

    /**
     * Provide an optional `onChange` hook that is called each time the <input>
     * value changes
     */
    onChange: PropTypes__default.func,

    /**
     * Provide an optional `onClick` hook that is called each time the button is
     * clicked
     */
    onClick: PropTypes__default.func,

    /**
     * Provide an accessibility role for the <FileUploaderButton>
     */
    role: PropTypes__default.string,

    /**
     * Provide a custom tabIndex value for the <FileUploaderButton>
     */
    tabIndex: PropTypes__default.number,

    /**
     * Specify the type of underlying button
     */
    buttonKind: ButtonTypes.buttonKind,

    /**
     * Specify the types of files that this input should be able to receive
     */
    accept: PropTypes__default.arrayOf(PropTypes__default.string),

    /**
     * Specify whether file input is disabled
     */
    disabled: PropTypes__default.bool
  });

  _defineProperty(FileUploaderButton, "defaultProps", {
    tabIndex: 0,
    disableLabelChanges: false,
    labelText: 'Add file',
    buttonKind: 'primary',
    multiple: false,
    onChange: function onChange() {},
    onClick: function onClick() {},
    accept: [],
    disabled: false,
    role: 'button'
  });

  var Filename =
  /*#__PURE__*/
  function (_Component2) {
    _inherits(Filename, _Component2);

    function Filename() {
      _classCallCheck(this, Filename);

      return _possibleConstructorReturn(this, _getPrototypeOf(Filename).apply(this, arguments));
    }

    _createClass(Filename, [{
      key: "render",
      value: function render() {
        var _this$props2 = this.props,
            iconDescription = _this$props2.iconDescription,
            status = _this$props2.status,
            style = _this$props2.style,
            other = _objectWithoutProperties(_this$props2, ["iconDescription", "status", "style"]);

        if (status === 'uploading') {
          return React__default.createElement("div", _extends({
            className: "".concat(prefix$S, "--loading"),
            style: _objectSpread2({}, style, {
              width: '1rem',
              height: '1rem'
            })
          }, other), React__default.createElement("svg", {
            className: "".concat(prefix$S, "--loading__svg"),
            viewBox: "-42 -42 84 84"
          }, React__default.createElement("circle", {
            cx: "0",
            cy: "0",
            r: "37.5"
          })));
        } else if (status === 'edit') {
          return React__default.createElement(CloseFilled16, _extends({
            className: "".concat(prefix$S, "--file-close"),
            "aria-label": iconDescription,
            style: style
          }, other), iconDescription && React__default.createElement("title", null, iconDescription));
        } else if (status === 'complete') {
          return React__default.createElement(CheckmarkFilled16, _extends({
            className: "".concat(prefix$S, "--file-complete"),
            "aria-label": iconDescription,
            style: style
          }, other), iconDescription && React__default.createElement("title", null, iconDescription));
        } else {
          return null;
        }
      }
    }]);

    return Filename;
  }(React.Component);

  _defineProperty(Filename, "propTypes", {
    /**
     * Specify an optional object of styles to be applied inline to the root
     * node
     */
    style: PropTypes__default.object,

    /**
     * Specify the status of the File Upload
     */
    status: PropTypes__default.oneOf(['edit', 'complete', 'uploading']),

    /**
     * Provide a description for the complete/close icon that can be read by screen readers
     */
    iconDescription: PropTypes__default.string
  });

  _defineProperty(Filename, "defaultProps", {
    onKeyDown: function onKeyDown() {},
    status: 'uploading',
    style: {},
    tabIndex: 0
  });

  var FileUploader$1 =
  /*#__PURE__*/
  function (_Component3) {
    _inherits(FileUploader, _Component3);

    function FileUploader() {
      var _getPrototypeOf3;

      var _this3;

      _classCallCheck(this, FileUploader);

      for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        args[_key2] = arguments[_key2];
      }

      _this3 = _possibleConstructorReturn(this, (_getPrototypeOf3 = _getPrototypeOf(FileUploader)).call.apply(_getPrototypeOf3, [this].concat(args)));

      _defineProperty(_assertThisInitialized(_this3), "state", {
        filenames: []
      });

      _defineProperty(_assertThisInitialized(_this3), "nodes", []);

      _defineProperty(_assertThisInitialized(_this3), "handleChange", function (evt) {
        evt.stopPropagation();

        _this3.setState({
          filenames: _this3.state.filenames.concat(Array.prototype.map.call(evt.target.files, function (file) {
            return file.name;
          }))
        });

        _this3.props.onChange(evt);
      });

      _defineProperty(_assertThisInitialized(_this3), "handleClick", function (evt, index) {
        var filteredArray = _this3.state.filenames.filter(function (filename) {
          return filename !== _this3.nodes[index].innerText.trim();
        });

        _this3.setState({
          filenames: filteredArray
        });

        _this3.props.onClick(evt);
      });

      _defineProperty(_assertThisInitialized(_this3), "clearFiles", function () {
        // A clearFiles function that resets filenames and can be referenced using a ref by the parent.
        _this3.setState({
          filenames: []
        });
      });

      return _this3;
    }

    _createClass(FileUploader, [{
      key: "render",
      value: function render() {
        var _classNames2,
            _this4 = this;

        var _this$props3 = this.props,
            iconDescription = _this$props3.iconDescription,
            buttonLabel = _this$props3.buttonLabel,
            buttonKind = _this$props3.buttonKind,
            filenameStatus = _this$props3.filenameStatus,
            labelDescription = _this$props3.labelDescription,
            labelTitle = _this$props3.labelTitle,
            className = _this$props3.className,
            multiple = _this$props3.multiple,
            accept = _this$props3.accept,
            name = _this$props3.name,
            other = _objectWithoutProperties(_this$props3, ["iconDescription", "buttonLabel", "buttonKind", "filenameStatus", "labelDescription", "labelTitle", "className", "multiple", "accept", "name"]);

        var classes = classNames((_classNames2 = {}, _defineProperty(_classNames2, "".concat(prefix$S, "--form-item"), true), _defineProperty(_classNames2, className, className), _classNames2));
        return React__default.createElement("div", _extends({
          className: classes
        }, other), React__default.createElement("strong", {
          className: "".concat(prefix$S, "--file--label")
        }, labelTitle), React__default.createElement("p", {
          className: "".concat(prefix$S, "--label-description")
        }, labelDescription), React__default.createElement(FileUploaderButton, {
          labelText: buttonLabel,
          multiple: multiple,
          buttonKind: buttonKind,
          onChange: this.handleChange,
          disableLabelChanges: true,
          accept: accept,
          name: name
        }), React__default.createElement("div", {
          className: "".concat(prefix$S, "--file-container")
        }, this.state.filenames.length === 0 ? null : this.state.filenames.map(function (name, index) {
          return React__default.createElement("span", _extends({
            key: index,
            className: "".concat(prefix$S, "--file__selected-file"),
            ref: function ref(node) {
              return _this4.nodes[index] = node;
            } // eslint-disable-line

          }, other), React__default.createElement("p", {
            className: "".concat(prefix$S, "--file-filename")
          }, name), React__default.createElement("span", {
            className: "".concat(prefix$S, "--file__state-container")
          }, React__default.createElement(Filename, {
            iconDescription: iconDescription,
            status: filenameStatus,
            onKeyDown: function onKeyDown(evt) {
              if (evt.which === 13 || evt.which === 32) {
                _this4.handleClick(evt, index);
              }
            },
            onClick: function onClick(evt) {
              if (filenameStatus === 'edit') {
                _this4.handleClick(evt, index);
              }
            }
          })));
        })));
      }
    }], [{
      key: "getDerivedStateFromProps",
      value: function getDerivedStateFromProps(_ref2, state) {
        var filenameStatus = _ref2.filenameStatus;
        var prevFilenameStatus = state.prevFilenameStatus;
        return prevFilenameStatus === filenameStatus ? null : {
          filenameStatus: filenameStatus,
          prevFilenameStatus: filenameStatus
        };
      }
    }]);

    return FileUploader;
  }(React.Component);

  _defineProperty(FileUploader$1, "propTypes", {
    /**
     * Provide a description for the complete/close icon that can be read by screen readers
     */
    iconDescription: PropTypes__default.string,

    /**
     * Provide the label text to be read by screen readers when interacting with
     * the <FileUploaderButton>
     */
    buttonLabel: PropTypes__default.string,

    /**
     * Specify the type of the <FileUploaderButton>
     */
    buttonKind: ButtonTypes.buttonKind,

    /**
     * Specify the status of the File Upload
     */
    filenameStatus: PropTypes__default.oneOf(['edit', 'complete', 'uploading']).isRequired,

    /**
     * Specify the description text of this <FileUploader>
     */
    labelDescription: PropTypes__default.string,

    /**
     * Specify the title text of this <FileUploader>
     */
    labelTitle: PropTypes__default.string,

    /**
     * Specify if the component should accept multiple files to upload
     */
    multiple: PropTypes__default.bool,

    /**
     * Provide a name for the underlying <input> node
     */
    name: PropTypes__default.string,

    /**
     * Provide an optional `onClick` hook that is called each time the button is
     * clicked
     */
    onClick: PropTypes__default.func,

    /**
     * Provide a custom className to be applied to the container node
     */
    className: PropTypes__default.string,

    /**
     * Specify the types of files that this input should be able to receive
     */
    accept: PropTypes__default.arrayOf(PropTypes__default.string)
  });

  _defineProperty(FileUploader$1, "defaultProps", {
    iconDescription: 'Provide icon description',
    filenameStatus: 'uploading',
    buttonLabel: '',
    buttonKind: 'primary',
    multiple: false,
    onClick: function onClick() {},
    accept: []
  });

  var prefix$T = settings_1.prefix;

  var Form = function Form(_ref) {
    var className = _ref.className,
        children = _ref.children,
        other = _objectWithoutProperties(_ref, ["className", "children"]);

    var classNames$1 = classNames("".concat(prefix$T, "--form"), className);
    return React__default.createElement("form", _extends({
      className: classNames$1
    }, other), ' ', children, ' ');
  };

  Form.propTypes = {
    /**
     * Provide children to be rendered inside of the <form> element
     */
    children: PropTypes__default.node,

    /**
     * Provide a custom className to be applied on the containing <form> node
     */
    className: PropTypes__default.string
  };

  var prefix$U = settings_1.prefix;

  var FormGroup = function FormGroup(_ref) {
    var legendText = _ref.legendText,
        invalid = _ref.invalid,
        children = _ref.children,
        className = _ref.className,
        message = _ref.message,
        messageText = _ref.messageText,
        other = _objectWithoutProperties(_ref, ["legendText", "invalid", "children", "className", "message", "messageText"]);

    var classNamesLegend = classNames("".concat(prefix$U, "--label"), className);
    var classNamesFieldset = classNames("".concat(prefix$U, "--fieldset"), className);
    return React__default.createElement("fieldset", _extends({}, invalid && {
      'data-invalid': ''
    }, {
      className: classNamesFieldset
    }, other), React__default.createElement("legend", {
      className: classNamesLegend
    }, legendText), children, message ? React__default.createElement("div", {
      className: "".concat(prefix$U, "--form__requirements")
    }, messageText) : null);
  };

  FormGroup.propTypes = {
    /**
     * Provide the children form elements to be rendered inside of the <fieldset>
     */
    children: PropTypes__default.node,

    /**
     * Provide the text to be rendered inside of the fieldset <legend>
     */
    legendText: PropTypes__default.string.isRequired,

    /**
     * Provide a custom className to be applied to the containing <fieldset> node
     */
    className: PropTypes__default.string,

    /**
     * Specify whether the <FormGroup> is invalid
     */
    invalid: PropTypes__default.bool,

    /**
     * Specify whether the message should be displayed in the <FormGroup>
     */
    message: PropTypes__default.bool,

    /**
     * Provide the text for the message in the <FormGroup>
     */
    messageText: PropTypes__default.string
  };
  FormGroup.defaultProps = {
    invalid: false,
    message: false,
    messageText: ''
  };

  var prefix$V = settings_1.prefix;

  var FormItem = function FormItem(_ref) {
    var className = _ref.className,
        children = _ref.children,
        other = _objectWithoutProperties(_ref, ["className", "children"]);

    var classNames$1 = classNames("".concat(prefix$V, "--form-item"), className);
    return React__default.createElement("div", _extends({
      className: classNames$1
    }, other), children);
  };

  FormItem.propTypes = {
    /**
     * Provide content to be rendered in the form item
     */
    children: PropTypes__default.node,

    /**
     * Provide a custom className to be applied to the containing node
     */
    className: PropTypes__default.string
  };

  var prefix$W = settings_1.prefix;

  var FormLabel = function FormLabel(_ref) {
    var className = _ref.className,
        children = _ref.children,
        id = _ref.id,
        other = _objectWithoutProperties(_ref, ["className", "children", "id"]);

    var classNames$1 = classNames("".concat(prefix$W, "--label"), className);
    return React__default.createElement("label", _extends({
      htmlFor: id,
      className: classNames$1
    }, other), children);
  };

  FormLabel.propTypes = {
    /**
     * Specify the content of the form label
     */
    children: PropTypes__default.node,

    /**
     * Provide a custom className to be applied to the containing <label> node
     */
    className: PropTypes__default.string,

    /**
     * Provide a unique id for the given <FormLabel>
     */
    id: PropTypes__default.string
  };

  /**
   * @param {object} svgData - JSON Object for an SVG icon
   * @returns {ReactElement} Elements/Nodes for SVG
   * @example
   * // Returns SVG elements
   * const svgData = getSvgData('copy-code');
   * svgShapes(svgData);
   */

  function svgShapes(svgData) {
    var svgElements = Object.keys(svgData).filter(function (key) {
      return svgData[key];
    }).map(function (svgProp) {
      var data = svgData[svgProp];

      if (svgProp === 'circles') {
        return data.map(function (circle, index) {
          var circleProps = {
            cx: circle.cx,
            cy: circle.cy,
            r: circle.r,
            key: "circle".concat(index)
          };
          return React__default.createElement("circle", circleProps);
        });
      } else if (svgProp === 'paths') {
        return data.map(function (path, index) {
          return React__default.createElement("path", {
            d: path.d,
            key: "key".concat(index)
          });
        });
      } else if (svgProp === 'polygons') {
        return data.map(function (polygon, index) {
          return React__default.createElement("polygon", {
            points: polygon.points,
            key: "key".concat(index)
          });
        });
      }

      return '';
    });
    return svgElements;
  }
  function isPrefixed(name) {
    {
      !(typeof name === 'string') ?  invariant_1(false, '[Icon] icon name is missing. You likely forgot to specify the icon, ' + 'or are using older (pre-`7.x`) version of `carbon-icons` library. ' + 'To specify the icon, use either `icon` (data) or `name` (icon name) properties.')  : void 0;
    }

    return name && name.split('--')[0] === 'icon';
  }

  var Icon$1 = function Icon(_ref) {
    var className = _ref.className,
        iconTitle = _ref.iconTitle,
        description = _ref.description,
        fill = _ref.fill,
        fillRule = _ref.fillRule,
        height = _ref.height,
        name = _ref.name,
        icon = _ref.icon,
        role = _ref.role,
        style = _ref.style,
        width = _ref.width,
        iconRef = _ref.iconRef,
        other = _objectWithoutProperties(_ref, ["className", "iconTitle", "description", "fill", "fillRule", "height", "name", "icon", "role", "style", "width", "iconRef"]);

    var props = _objectSpread2({
      className: className,
      fill: fill,
      fillRule: fillRule,
      height: height || icon.height,
      name: isPrefixed ? name : "icon--".concat(name),
      role: role,
      style: style,
      viewBox: icon.viewBox,
      width: width || icon.width,
      ref: iconRef
    }, other);

    var svgContent = icon ? svgShapes(icon.svgData) : '';
    return React__default.createElement("svg", _extends({}, props, {
      "aria-label": description
    }), React__default.createElement("title", null, typeof iconTitle === 'undefined' ? description : iconTitle), svgContent);
  };

  Icon$1.propTypes = {
    /**
     * The CSS class name.
     */
    className: PropTypes__default.string,

    /**
     * The icon title.
     */
    iconTitle: PropTypes__default.string,

    /**
     * The icon description.
     */
    description: PropTypes__default.string.isRequired,

    /**
     * The `<svg>` `fill` attribute.
     */
    fill: PropTypes__default.string,

    /**
     * The `<svg>` `fillRule` attribute.
     */
    fillRule: PropTypes__default.string,

    /**
     * The `<svg>` `height` attribute.
     */
    height: PropTypes__default.string,

    /**
     * The icon data.
     */
    icon: PropTypes__default.shape({
      width: PropTypes__default.string,
      height: PropTypes__default.string,
      viewBox: PropTypes__default.string.isRequired,
      svgData: PropTypes__default.object.isRequired
    }),

    /**
     * The `role` attribute.
     */
    role: PropTypes__default.string,

    /**
     * The CSS styles.
     */
    style: PropTypes__default.object,

    /**
     * The `<svg>` `viewbox` attribute.
     */
    viewBox: PropTypes__default.string,

    /**
     * The `<svg>` `width` attribute.
     */
    width: PropTypes__default.string,

    /**
     * The `ref` callback for the icon.
     */
    iconRef: PropTypes__default.func
  };
  Icon$1.defaultProps = {
    fillRule: 'evenodd',
    role: 'img'
  };

  var prefix$X = settings_1.prefix;

  var IconSkeleton = function IconSkeleton(_ref) {
    var style = _ref.style;
    var props = {
      style: style
    };
    return React__default.createElement("div", _extends({
      className: "".concat(prefix$X, "--icon--skeleton")
    }, props));
  };

  IconSkeleton.propTypes = {
    /**
     * The CSS styles.
     */
    style: PropTypes__default.object
  };

  var prefix$Y = settings_1.prefix;

  var Loading$1 =
  /*#__PURE__*/
  function (_React$Component) {
    _inherits(Loading, _React$Component);

    function Loading() {
      _classCallCheck(this, Loading);

      return _possibleConstructorReturn(this, _getPrototypeOf(Loading).apply(this, arguments));
    }

    _createClass(Loading, [{
      key: "render",
      value: function render() {
        var _classNames;

        var _this$props = this.props,
            active = _this$props.active,
            className = _this$props.className,
            withOverlay = _this$props.withOverlay,
            small = _this$props.small,
            description = _this$props.description,
            other = _objectWithoutProperties(_this$props, ["active", "className", "withOverlay", "small", "description"]);

        var loadingClasses = classNames("".concat(prefix$Y, "--loading"), className, (_classNames = {}, _defineProperty(_classNames, "".concat(prefix$Y, "--loading--small"), small), _defineProperty(_classNames, "".concat(prefix$Y, "--loading--stop"), !active), _classNames));
        var overlayClasses = classNames("".concat(prefix$Y, "--loading-overlay"), _defineProperty({}, "".concat(prefix$Y, "--loading-overlay--stop"), !active));
        var loading = React__default.createElement("div", _extends({}, other, {
          "aria-label": description,
          "aria-live": active ? 'assertive' : 'off',
          className: loadingClasses
        }), React__default.createElement("svg", {
          className: "".concat(prefix$Y, "--loading__svg"),
          viewBox: "-75 -75 150 150"
        }, React__default.createElement("title", null, description), small ? React__default.createElement("circle", {
          className: "".concat(prefix$Y, "--loading__background"),
          cx: "0",
          cy: "0",
          r: "37.5"
        }) : null, React__default.createElement("circle", {
          className: "".concat(prefix$Y, "--loading__stroke"),
          cx: "0",
          cy: "0",
          r: "37.5"
        })));
        return withOverlay ? React__default.crea