var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
// Internal Imports
import { AxisChart } from "../axis-chart";
import * as Configuration from "../configuration";
import { Tools } from "../tools";
// Components
import { Grid, GroupedBar, TwoDimensionalAxes, HorizontalZeroLine, TooltipBar } from "../components/index";
var GroupedBarChart = /** @class */ (function (_super) {
    __extends(GroupedBarChart, _super);
    function GroupedBarChart(holder, chartConfigs) {
        var _this = _super.call(this, holder, chartConfigs) || this;
        // Merge the default options for this chart
        // With the user provided options
        _this.model.setOptions(Tools.merge(Tools.clone(Configuration.options.groupedBarChart), chartConfigs.options));
        // Initialize data, services, components etc.
        _this.init(holder, chartConfigs);
        return _this;
    }
    GroupedBarChart.prototype.getComponents = function () {
        // Specify what to render inside the graph-frame
        var graphFrameComponents = [
            new TwoDimensionalAxes(this.model, this.services),
            new Grid(this.model, this.services),
            new GroupedBar(this.model, this.services),
            new HorizontalZeroLine(this.model, this.services)
        ];
        var components = this.getAxisChartComponents(graphFrameComponents);
        components.push(new TooltipBar(this.model, this.services));
        return components;
    };
    return GroupedBarChart;
}(AxisChart));
export { GroupedBarChart };
//# sourceMappingURL=/home/travis/build/carbon-design-system/carbon-charts/packages/core/charts/bar-grouped.js.map