var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
// Internal Imports
import { PieChart } from "./pie";
import * as Configuration from "../configuration";
import { Tools } from "../tools";
// Components
import { Donut, Tooltip } from "../components/index";
var DonutChart = /** @class */ (function (_super) {
    __extends(DonutChart, _super);
    function DonutChart(holder, chartConfigs) {
        var _this = _super.call(this, holder, chartConfigs, true) || this;
        // Merge the default options for this chart
        // With the user provided options
        _this.model.setOptions(Tools.merge(Tools.clone(Configuration.options.donutChart), chartConfigs.options));
        // Initialize data, services, components etc.
        _this.init(holder, chartConfigs);
        return _this;
    }
    DonutChart.prototype.getComponents = function () {
        // Specify what to render inside the graph-frame
        var graphFrameComponents = [
            new Donut(this.model, this.services)
        ];
        var components = this.getChartComponents(graphFrameComponents);
        components.push(new Tooltip(this.model, this.services));
        return components;
    };
    return DonutChart;
}(PieChart));
export { DonutChart };
//# sourceMappingURL=/home/travis/build/carbon-design-system/carbon-charts/packages/core/charts/donut.js.map