import { ScaleTypes } from "./enums";
/**
 * options to configure a scale. not all options are used by all scales
 */
export interface AxisOptions {
    /**
     * type of the scale used on axis
     */
    scaleType?: ScaleTypes;
    primary?: boolean;
    secondary?: boolean;
    /**
     * optional title for the scales
     */
    title?: string;
    /**
     * tick configuration
     */
    ticks?: {
        /**
         * number of ticks to show
         */
        number?: number;
        /**
         * minimum tick value
         */
        min?: number;
        /**
         * maximum tick value
         */
        max?: number;
        /**
         * function to format the ticks
         */
        formatter?: Function;
    };
}
/**
 * customize the axes components
 */
export interface AxesOptions {
    left?: AxisOptions;
    bottom?: AxisOptions;
    right?: AxisOptions;
    top?: AxisOptions;
}
/**
 * customize time series scales
 */
export interface TimeScaleOptions {
    addSpaceOnEdges?: boolean;
}
