var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import { curveBasis, curveBasisClosed, curveBasisOpen, curveBundle, curveCardinal, curveCardinalClosed, curveCardinalOpen, curveCatmullRom, curveCatmullRomClosed, curveCatmullRomOpen, curveLinear, curveLinearClosed, curveMonotoneX, curveMonotoneY, curveNatural, curveStep, curveStepAfter, curveStepBefore } from "d3-shape";
// Internal Imports
import { Service } from "./service";
var Curves = /** @class */ (function (_super) {
    __extends(Curves, _super);
    function Curves() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.curveTypes = {
            curveLinear: curveLinear,
            curveLinearClosed: curveLinearClosed,
            curveBasis: curveBasis,
            curveBasisClosed: curveBasisClosed,
            curveBasisOpen: curveBasisOpen,
            curveBundle: curveBundle,
            curveCardinal: curveCardinal,
            curveCardinalClosed: curveCardinalClosed,
            curveCardinalOpen: curveCardinalOpen,
            curveCatmullRom: curveCatmullRom,
            curveCatmullRomClosed: curveCatmullRomClosed,
            curveCatmullRomOpen: curveCatmullRomOpen,
            curveMonotoneX: curveMonotoneX,
            curveMonotoneY: curveMonotoneY,
            curveNatural: curveNatural,
            curveStep: curveStep,
            curveStepAfter: curveStepAfter,
            curveStepBefore: curveStepBefore
        };
        return _this;
    }
    Curves.prototype.getD3Curve = function () {
        var curveName = "curveLinear";
        var curveOptions = this.model.getOptions().curve;
        // Parse curve type whether the user provided a string
        // Or an object with more options
        if (curveOptions) {
            if (typeof curveOptions === "string") { // curve: 'string'
                curveName = curveOptions;
            }
            else { // curve: { name: 'string' }
                curveName = curveOptions.name;
            }
        }
        if (this.curveTypes[curveName]) {
            // Grab correct d3 curve function
            var curve_1 = this.curveTypes[curveName];
            // Apply user-provided options to the d3 curve
            if (curveOptions) {
                Object.keys(curveOptions).forEach(function (optionName) {
                    if (curve_1[optionName]) {
                        curve_1 = curve_1[optionName](curveOptions[optionName]);
                    }
                });
            }
            return curve_1;
        }
        console.warn("The curve type '" + curveName + "' is invalid, using 'curveLinear' instead");
        return this.curveTypes["curveLinear"];
    };
    return Curves;
}(Service));
export { Curves };
//# sourceMappingURL=/home/travis/build/carbon-design-system/carbon-charts/packages/core/services/curves.js.map