var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
// Internal Imports
import { Service } from "../service";
import * as Configuration from "../../configuration";
import { Tools } from "../../tools";
// D3 Imports
import { transition } from "d3-transition";
var Transitions = /** @class */ (function (_super) {
    __extends(Transitions, _super);
    function Transitions() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.pendingTransitions = {};
        return _this;
    }
    // transitions: Transition<any, any, any, any>[];
    Transitions.prototype.init = function () {
        var _this = this;
        this.services.events
            .addEventListener("model-update", function () {
            _this.pendingTransitions = {};
        });
    };
    Transitions.prototype.getTransition = function (name, animate) {
        var _this = this;
        if (this.model.getOptions().animations === false || animate === false) {
            return this.getInstantTransition(name);
        }
        var t = transition(name)
            .duration(Tools.getProperty(Configuration.transitions, name, "duration") || Configuration.transitions.default.duration);
        this.pendingTransitions[t._id] = t;
        t.on("end", function () {
            delete _this.pendingTransitions[t._id];
        });
        return t;
    };
    Transitions.prototype.getInstantTransition = function (name) {
        var _this = this;
        var t = transition(name).duration(0);
        this.pendingTransitions[t._id] = t;
        t.on("end", function () {
            delete _this.pendingTransitions[t._id];
        });
        return t;
    };
    Transitions.prototype.getPendingTransitions = function () {
        return this.pendingTransitions;
    };
    return Transitions;
}(Service));
export { Transitions };
//# sourceMappingURL=/home/travis/build/carbon-design-system/carbon-charts/packages/core/services/essentials/transitions.js.map