/**
 * Copyright IBM Corp. 2018, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import {
  // Blue
  blue20,
  blue60,
  blue70,
  blue80,

  // Gray
  gray10,
  gray20,
  gray30,
  gray50,
  gray60,
  gray70,
  gray80,
  gray100,

  // Support
  blue50,
  green40,
  green50,
  yellow,
  red50,
  red60,
  red80,
  purple60,

  // Constants
  white,

  // Tools
  rgba,
} from '@carbon/colors';

export const interactive01 = blue60;
export const interactive02 = gray100;
export const interactive03 = blue60;
export const interactive04 = blue60;

export const uiBackground = gray10;

export const ui01 = white;
export const ui02 = gray10;
export const ui03 = gray20;
export const ui04 = gray50;
export const ui05 = gray100;

export const text01 = gray100;
export const text02 = gray70;
export const text03 = gray50;
export const text04 = white;

export const icon01 = gray100;
export const icon02 = gray70;
export const icon03 = white;

export const link01 = blue60;

export const field01 = white;
export const field02 = gray10;

export const inverse01 = white;
export const inverse02 = gray80;

export const support01 = red60;
export const support02 = green50;
export const support03 = yellow;
export const support04 = blue70;

export const inverseSupport01 = red50;
export const inverseSupport02 = green40;
export const inverseSupport03 = yellow;
export const inverseSupport04 = blue50;

export const overlay01 = rgba(gray100, 0.5);

// Interaction states
export const focus = blue60;

export const hoverPrimary = '#0353e9';
export const activePrimary = blue80;

export const hoverPrimaryText = blue70;

export const hoverSecondary = '#4c4c4c';
export const activeSecondary = gray60;

export const hoverTertiary = '#0353e9';
export const activeTertiary = blue80;

export const hoverUI = '#e5e5e5';
export const activeUI = gray30;
export const selectedUI = gray20;

export const hoverSelectedUI = '#cacaca';

export const hoverDanger = '#ba1b23';
export const activeDanger = red80;

export const hoverRow = '#e5e5e5';

export const visitedLink = purple60;

export const disabled01 = white;
export const disabled02 = gray30;
export const disabled03 = gray50;

export const highlight = blue20;

export const skeleton01 = '#e5e5e5';
export const skeleton02 = gray30;

// Deprecated ☠️
export const brand01 = interactive01;
export const brand02 = interactive02;
export const brand03 = interactive03;
export const active01 = activeUI;
export const hoverField = hoverUI;
