/**
 * Copyright IBM Corp. 2018, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import {
  // Blue
  blue30,
  blue40,
  blue50,
  blue60,
  blue70,
  blue80,

  // Gray
  gray10,
  gray30,
  gray50,
  gray60,
  gray70,
  gray80,
  gray90,
  gray100,

  // Support
  green40,
  green50,
  yellow,
  red50,
  red60,
  red80,
  purple40,

  // Constants
  white,

  // Tools
  rgba,
} from '@carbon/colors';

export const interactive01 = blue60;
export const interactive02 = gray60;
export const interactive03 = white;
export const interactive04 = blue50;

export const uiBackground = gray90;

export const ui01 = gray80;
export const ui02 = gray70;
export const ui03 = gray70;
export const ui04 = gray50;
export const ui05 = gray10;

export const text01 = gray10;
export const text02 = gray30;
export const text03 = gray50;
export const text04 = white;

export const icon01 = gray10;
export const icon02 = gray30;
export const icon03 = white;

export const link01 = blue40;

export const field01 = gray80;
export const field02 = gray70;

export const inverse01 = gray100;
export const inverse02 = gray10;

export const support01 = red50;
export const support02 = green40;
export const support03 = yellow;
export const support04 = blue50;

export const inverseSupport01 = red60;
export const inverseSupport02 = green50;
export const inverseSupport03 = yellow;
export const inverseSupport04 = blue60;

export const overlay01 = rgba(gray100, 0.7);

// Interaction states
export const focus = white;

export const hoverPrimary = '#0353e9';
export const activePrimary = blue80;

export const hoverPrimaryText = blue30;

export const hoverSecondary = '#606060';
export const activeSecondary = gray80;

export const hoverTertiary = gray10;
export const activeTertiary = gray30;

export const hoverUI = '#4c4c4c';
export const activeUI = gray60;
export const selectedUI = gray70;

export const hoverSelectedUI = '#656565';

export const hoverDanger = '#ba1b23';
export const activeDanger = red80;

export const hoverRow = '#4c4c4c';

export const visitedLink = purple40;

export const disabled01 = gray80;
export const disabled02 = gray70;
export const disabled03 = gray50;

export const highlight = blue70;

export const skeleton01 = '#353535';
export const skeleton02 = gray70;

// Deprecated ☠️
export const brand01 = interactive01;
export const brand02 = interactive02;
export const brand03 = interactive03;
export const active01 = activeUI;
export const hoverField = hoverUI;
