/**
 * Copyright IBM Corp. 2015, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

var enabled$1 = {};
try {
  if (process.env.CARBON_ENABLE_CSS_CUSTOM_PROPERTIES) {
    if (process.env.CARBON_ENABLE_CSS_CUSTOM_PROPERTIES === 'true') {
      enabled$1.enableCssCustomProperties = true;
    } else {
      enabled$1.enableCssCustomProperties = false;
    }
  } else {
    enabled$1.enableCssCustomProperties = false;
  }
  if (process.env.CARBON_ENABLE_USE_CONTROLLED_STATE_WITH_VALUE) {
    if (process.env.CARBON_ENABLE_USE_CONTROLLED_STATE_WITH_VALUE === 'true') {
      enabled$1.enableUseControlledStateWithValue = true;
    } else {
      enabled$1.enableUseControlledStateWithValue = false;
    }
  } else {
    enabled$1.enableUseControlledStateWithValue = false;
  }
  if (process.env.CARBON_ENABLE_CSS_GRID) {
    if (process.env.CARBON_ENABLE_CSS_GRID === 'true') {
      enabled$1.enableCssGrid = true;
    } else {
      enabled$1.enableCssGrid = false;
    }
  } else {
    enabled$1.enableCssGrid = false;
  }
  if (process.env.CARBON_ENABLE_V11_RELEASE) {
    if (process.env.CARBON_ENABLE_V11_RELEASE === 'true') {
      enabled$1.enableV11Release = true;
    } else {
      enabled$1.enableV11Release = false;
    }
  } else {
    enabled$1.enableV11Release = true;
  }
  if (process.env.CARBON_ENABLE_EXPERIMENTAL_TILE_CONTRAST) {
    if (process.env.CARBON_ENABLE_EXPERIMENTAL_TILE_CONTRAST === 'true') {
      enabled$1.enableExperimentalTileContrast = true;
    } else {
      enabled$1.enableExperimentalTileContrast = false;
    }
  } else {
    enabled$1.enableExperimentalTileContrast = false;
  }
  if (process.env.CARBON_ENABLE_V12_TILE_DEFAULT_ICONS) {
    if (process.env.CARBON_ENABLE_V12_TILE_DEFAULT_ICONS === 'true') {
      enabled$1.enableV12TileDefaultIcons = true;
    } else {
      enabled$1.enableV12TileDefaultIcons = false;
    }
  } else {
    enabled$1.enableV12TileDefaultIcons = false;
  }
  if (process.env.CARBON_ENABLE_V12_OVERFLOWMENU) {
    if (process.env.CARBON_ENABLE_V12_OVERFLOWMENU === 'true') {
      enabled$1.enableV12Overflowmenu = true;
    } else {
      enabled$1.enableV12Overflowmenu = false;
    }
  } else {
    enabled$1.enableV12Overflowmenu = false;
  }
} catch (error) {
  enabled$1.enableCssCustomProperties = false;
  enabled$1.enableUseControlledStateWithValue = false;
  enabled$1.enableCssGrid = false;
  enabled$1.enableV11Release = true;
  enabled$1.enableExperimentalTileContrast = false;
  enabled$1.enableV12TileDefaultIcons = false;
  enabled$1.enableV12Overflowmenu = false;
}
var featureFlagInfo = [{
  name: "enable-css-custom-properties",
  description: "Describe what the flag does",
  enabled: enabled$1.enableCssCustomProperties
}, {
  name: "enable-use-controlled-state-with-value",
  description: "Enable components to be created in either a controlled or uncontrolled mode\n",
  enabled: enabled$1.enableUseControlledStateWithValue
}, {
  name: "enable-css-grid",
  description: "Enable CSS Grid Layout in the Grid and Column React components\n",
  enabled: enabled$1.enableCssGrid
}, {
  name: "enable-v11-release",
  description: "Enable the features and functionality for the v11 Release\n",
  enabled: enabled$1.enableV11Release
}, {
  name: "enable-experimental-tile-contrast",
  description: "Enable the experimental tile improved contrast styles\n",
  enabled: enabled$1.enableExperimentalTileContrast
}, {
  name: "enable-v12-tile-default-icons",
  description: "Enable rendering of default icons in the tile components\n",
  enabled: enabled$1.enableV12TileDefaultIcons
}, {
  name: "enable-v12-overflowmenu",
  description: "Enable the use of the v12 OverflowMenu leveraging the Menu subcomponents\n",
  enabled: enabled$1.enableV12Overflowmenu
}];

function _iterableToArrayLimit(arr, i) {
  var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"];
  if (null != _i) {
    var _s,
      _e,
      _x,
      _r,
      _arr = [],
      _n = !0,
      _d = !1;
    try {
      if (_x = (_i = _i.call(arr)).next, 0 === i) {
        if (Object(_i) !== _i) return;
        _n = !1;
      } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0);
    } catch (err) {
      _d = !0, _e = err;
    } finally {
      try {
        if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return;
      } finally {
        if (_d) throw _e;
      }
    }
    return _arr;
  }
}
function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor) descriptor.writable = true;
    Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor);
  }
}
function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
  if (staticProps) _defineProperties(Constructor, staticProps);
  Object.defineProperty(Constructor, "prototype", {
    writable: false
  });
  return Constructor;
}
function _slicedToArray(arr, i) {
  return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest();
}
function _arrayWithHoles(arr) {
  if (Array.isArray(arr)) return arr;
}
function _unsupportedIterableToArray(o, minLen) {
  if (!o) return;
  if (typeof o === "string") return _arrayLikeToArray(o, minLen);
  var n = Object.prototype.toString.call(o).slice(8, -1);
  if (n === "Object" && o.constructor) n = o.constructor.name;
  if (n === "Map" || n === "Set") return Array.from(o);
  if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
}
function _arrayLikeToArray(arr, len) {
  if (len == null || len > arr.length) len = arr.length;
  for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];
  return arr2;
}
function _nonIterableRest() {
  throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}
function _createForOfIteratorHelper(o, allowArrayLike) {
  var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"];
  if (!it) {
    if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") {
      if (it) o = it;
      var i = 0;
      var F = function () {};
      return {
        s: F,
        n: function () {
          if (i >= o.length) return {
            done: true
          };
          return {
            done: false,
            value: o[i++]
          };
        },
        e: function (e) {
          throw e;
        },
        f: F
      };
    }
    throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }
  var normalCompletion = true,
    didErr = false,
    err;
  return {
    s: function () {
      it = it.call(o);
    },
    n: function () {
      var step = it.next();
      normalCompletion = step.done;
      return step;
    },
    e: function (e) {
      didErr = true;
      err = e;
    },
    f: function () {
      try {
        if (!normalCompletion && it.return != null) it.return();
      } finally {
        if (didErr) throw err;
      }
    }
  };
}
function _toPrimitive(input, hint) {
  if (typeof input !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== undefined) {
    var res = prim.call(input, hint || "default");
    if (typeof res !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
function _toPropertyKey(arg) {
  var key = _toPrimitive(arg, "string");
  return typeof key === "symbol" ? key : String(key);
}

/**
 * Copyright IBM Corp. 2015, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

var FeatureFlagScope = /*#__PURE__*/function () {
  function FeatureFlagScope(flags) {
    var _this = this;
    _classCallCheck(this, FeatureFlagScope);
    this.flags = new Map();
    if (flags) {
      Object.keys(flags).forEach(function (key) {
        _this.flags.set(key, flags[key]);
      });
    }
  }

  /**
   * Check to see if a flag exists
   * @param {string} name
   */
  _createClass(FeatureFlagScope, [{
    key: "checkForFlag",
    value: function checkForFlag(name) {
      if (!this.flags.has(name)) {
        throw new Error("Unable to find a feature flag with the name: `".concat(name, "`"));
      }
    }

    /**
     * Add a feature flag
     * @param {string} name
     * @param {boolean} enabled
     */
  }, {
    key: "add",
    value: function add(name, enabled) {
      if (this.flags.has(name)) {
        throw new Error("The feature flag: ".concat(name, " already exists"));
      }
      this.flags.set(name, enabled);
    }

    /**
     * Enable a feature flag
     * @param {string} name
     */
  }, {
    key: "enable",
    value: function enable(name) {
      this.checkForFlag(name);
      this.flags.set(name, true);
    }

    /**
     * Disable a feature flag
     * @param {string} name
     */
  }, {
    key: "disable",
    value: function disable(name) {
      this.checkForFlag(name);
      this.flags.set(name, false);
    }

    /**
     * Merge the given feature flags with the current set of feature flags.
     * Duplicate keys will be set to the value in the given feature flags.
     * @param {object} flags
     */
  }, {
    key: "merge",
    value: function merge(flags) {
      var _this2 = this;
      Object.keys(flags).forEach(function (key) {
        _this2.flags.set(key, flags[key]);
      });
    }

    /**
     * @param {FeatureFlagScope} scope
     */
  }, {
    key: "mergeWithScope",
    value: function mergeWithScope(scope) {
      var _iterator = _createForOfIteratorHelper(scope.flags),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var _step$value = _slicedToArray(_step.value, 2),
            key = _step$value[0],
            value = _step$value[1];
          if (this.flags.has(key)) {
            continue;
          }
          this.flags.set(key, value);
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
    }

    /**
     * Check if a feature flag is enabled
     * @param {string} name
     * @returns {boolean}
     */
  }, {
    key: "enabled",
    value: function enabled(name) {
      this.checkForFlag(name);
      return this.flags.get(name);
    }
  }]);
  return FeatureFlagScope;
}();

var FeatureFlags = createScope();
for (var i = 0; i < featureFlagInfo.length; i++) {
  var featureFlag = featureFlagInfo[i];
  FeatureFlags.add(featureFlag.name, featureFlag.enabled);
}
function createScope(flags) {
  return new FeatureFlagScope(flags);
}
function add() {
  return FeatureFlags.add.apply(FeatureFlags, arguments);
}
function enable() {
  return FeatureFlags.enable.apply(FeatureFlags, arguments);
}
function disable() {
  return FeatureFlags.disable.apply(FeatureFlags, arguments);
}
function enabled() {
  return FeatureFlags.enabled.apply(FeatureFlags, arguments);
}
function merge() {
  return FeatureFlags.merge.apply(FeatureFlags, arguments);
}

export { FeatureFlags, add, createScope, disable, enable, enabled, merge };
