/**
 * Copyright IBM Corp. 2015, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

var enabled$1 = {};
try {
  if (process.env.CARBON_ENABLE_CSS_CUSTOM_PROPERTIES) {
    if (process.env.CARBON_ENABLE_CSS_CUSTOM_PROPERTIES === 'true') {
      enabled$1.enableCssCustomProperties = true;
    } else {
      enabled$1.enableCssCustomProperties = false;
    }
  } else {
    enabled$1.enableCssCustomProperties = false;
  }
  if (process.env.CARBON_ENABLE_CSS_GRID) {
    if (process.env.CARBON_ENABLE_CSS_GRID === 'true') {
      enabled$1.enableCssGrid = true;
    } else {
      enabled$1.enableCssGrid = false;
    }
  } else {
    enabled$1.enableCssGrid = false;
  }
  if (process.env.CARBON_ENABLE_V11_RELEASE) {
    if (process.env.CARBON_ENABLE_V11_RELEASE === 'true') {
      enabled$1.enableV11Release = true;
    } else {
      enabled$1.enableV11Release = false;
    }
  } else {
    enabled$1.enableV11Release = true;
  }
  if (process.env.CARBON_ENABLE_EXPERIMENTAL_TILE_CONTRAST) {
    if (process.env.CARBON_ENABLE_EXPERIMENTAL_TILE_CONTRAST === 'true') {
      enabled$1.enableExperimentalTileContrast = true;
    } else {
      enabled$1.enableExperimentalTileContrast = false;
    }
  } else {
    enabled$1.enableExperimentalTileContrast = false;
  }
  if (process.env.CARBON_ENABLE_V12_TILE_DEFAULT_ICONS) {
    if (process.env.CARBON_ENABLE_V12_TILE_DEFAULT_ICONS === 'true') {
      enabled$1.enableV12TileDefaultIcons = true;
    } else {
      enabled$1.enableV12TileDefaultIcons = false;
    }
  } else {
    enabled$1.enableV12TileDefaultIcons = false;
  }
  if (process.env.CARBON_ENABLE_V12_TILE_RADIO_ICONS) {
    if (process.env.CARBON_ENABLE_V12_TILE_RADIO_ICONS === 'true') {
      enabled$1.enableV12TileRadioIcons = true;
    } else {
      enabled$1.enableV12TileRadioIcons = false;
    }
  } else {
    enabled$1.enableV12TileRadioIcons = false;
  }
  if (process.env.CARBON_ENABLE_V12_OVERFLOWMENU) {
    if (process.env.CARBON_ENABLE_V12_OVERFLOWMENU === 'true') {
      enabled$1.enableV12Overflowmenu = true;
    } else {
      enabled$1.enableV12Overflowmenu = false;
    }
  } else {
    enabled$1.enableV12Overflowmenu = false;
  }
  if (process.env.CARBON_ENABLE_TREEVIEW_CONTROLLABLE) {
    if (process.env.CARBON_ENABLE_TREEVIEW_CONTROLLABLE === 'true') {
      enabled$1.enableTreeviewControllable = true;
    } else {
      enabled$1.enableTreeviewControllable = false;
    }
  } else {
    enabled$1.enableTreeviewControllable = false;
  }
  if (process.env.CARBON_ENABLE_V12_STRUCTURED_LIST_VISIBLE_ICONS) {
    if (process.env.CARBON_ENABLE_V12_STRUCTURED_LIST_VISIBLE_ICONS === 'true') {
      enabled$1.enableV12StructuredListVisibleIcons = true;
    } else {
      enabled$1.enableV12StructuredListVisibleIcons = false;
    }
  } else {
    enabled$1.enableV12StructuredListVisibleIcons = false;
  }
  if (process.env.CARBON_ENABLE_EXPERIMENTAL_FOCUS_WRAP_WITHOUT_SENTINELS) {
    if (process.env.CARBON_ENABLE_EXPERIMENTAL_FOCUS_WRAP_WITHOUT_SENTINELS === 'true') {
      enabled$1.enableExperimentalFocusWrapWithoutSentinels = true;
    } else {
      enabled$1.enableExperimentalFocusWrapWithoutSentinels = false;
    }
  } else {
    enabled$1.enableExperimentalFocusWrapWithoutSentinels = false;
  }
  if (process.env.CARBON_ENABLE_V12_DYNAMIC_FLOATING_STYLES) {
    if (process.env.CARBON_ENABLE_V12_DYNAMIC_FLOATING_STYLES === 'true') {
      enabled$1.enableV12DynamicFloatingStyles = true;
    } else {
      enabled$1.enableV12DynamicFloatingStyles = false;
    }
  } else {
    enabled$1.enableV12DynamicFloatingStyles = false;
  }
} catch (error) {
  enabled$1.enableCssCustomProperties = false;
  enabled$1.enableCssGrid = false;
  enabled$1.enableV11Release = true;
  enabled$1.enableExperimentalTileContrast = false;
  enabled$1.enableV12TileDefaultIcons = false;
  enabled$1.enableV12TileRadioIcons = false;
  enabled$1.enableV12Overflowmenu = false;
  enabled$1.enableTreeviewControllable = false;
  enabled$1.enableV12StructuredListVisibleIcons = false;
  enabled$1.enableExperimentalFocusWrapWithoutSentinels = false;
  enabled$1.enableV12DynamicFloatingStyles = false;
}
var featureFlagInfo = [{
  name: "enable-css-custom-properties",
  description: "Describe what the flag does",
  enabled: enabled$1.enableCssCustomProperties
}, {
  name: "enable-css-grid",
  description: "Enable CSS Grid Layout in the Grid and Column React components\n",
  enabled: enabled$1.enableCssGrid
}, {
  name: "enable-v11-release",
  description: "Enable the features and functionality for the v11 Release\n",
  enabled: enabled$1.enableV11Release
}, {
  name: "enable-experimental-tile-contrast",
  description: "Enable the experimental tile improved contrast styles\n",
  enabled: enabled$1.enableExperimentalTileContrast
}, {
  name: "enable-v12-tile-default-icons",
  description: "Enable rendering of default icons in the tile components\n",
  enabled: enabled$1.enableV12TileDefaultIcons
}, {
  name: "enable-v12-tile-radio-icons",
  description: "Enable rendering of radio icons in the RadioTile component\n",
  enabled: enabled$1.enableV12TileRadioIcons
}, {
  name: "enable-v12-overflowmenu",
  description: "Enable the use of the v12 OverflowMenu leveraging the Menu subcomponents\n",
  enabled: enabled$1.enableV12Overflowmenu
}, {
  name: "enable-treeview-controllable",
  description: "Enable the new TreeView controllable API\n",
  enabled: enabled$1.enableTreeviewControllable
}, {
  name: "enable-v12-structured-list-visible-icons",
  description: "Enable rendering of radio icons in the StructuredList component\n",
  enabled: enabled$1.enableV12StructuredListVisibleIcons
}, {
  name: "enable-experimental-focus-wrap-without-sentinels",
  description: "Enable the new focus wrap behavior that doesn't use sentinel nodes\n",
  enabled: enabled$1.enableExperimentalFocusWrapWithoutSentinels
}, {
  name: "enable-v12-dynamic-floating-styles",
  description: "Enable dynamic setting of floating styles for components like Popover, Tooltip, etc.\n",
  enabled: enabled$1.enableV12DynamicFloatingStyles
}];

function _arrayLikeToArray(r, a) {
  (null == a || a > r.length) && (a = r.length);
  for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e];
  return n;
}
function _arrayWithHoles(r) {
  if (Array.isArray(r)) return r;
}
function _classCallCheck(a, n) {
  if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function");
}
function _defineProperties(e, r) {
  for (var t = 0; t < r.length; t++) {
    var o = r[t];
    o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o);
  }
}
function _createClass(e, r, t) {
  return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", {
    writable: !1
  }), e;
}
function _createForOfIteratorHelper(r, e) {
  var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"];
  if (!t) {
    if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) {
      t && (r = t);
      var n = 0,
        F = function () {};
      return {
        s: F,
        n: function () {
          return n >= r.length ? {
            done: !0
          } : {
            done: !1,
            value: r[n++]
          };
        },
        e: function (r) {
          throw r;
        },
        f: F
      };
    }
    throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }
  var o,
    a = !0,
    u = !1;
  return {
    s: function () {
      t = t.call(r);
    },
    n: function () {
      var r = t.next();
      return a = r.done, r;
    },
    e: function (r) {
      u = !0, o = r;
    },
    f: function () {
      try {
        a || null == t.return || t.return();
      } finally {
        if (u) throw o;
      }
    }
  };
}
function _iterableToArrayLimit(r, l) {
  var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"];
  if (null != t) {
    var e,
      n,
      i,
      u,
      a = [],
      f = !0,
      o = !1;
    try {
      if (i = (t = t.call(r)).next, 0 === l) {
        if (Object(t) !== t) return;
        f = !1;
      } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0);
    } catch (r) {
      o = !0, n = r;
    } finally {
      try {
        if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return;
      } finally {
        if (o) throw n;
      }
    }
    return a;
  }
}
function _nonIterableRest() {
  throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}
function _slicedToArray(r, e) {
  return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest();
}
function _toPrimitive(t, r) {
  if ("object" != typeof t || !t) return t;
  var e = t[Symbol.toPrimitive];
  if (void 0 !== e) {
    var i = e.call(t, r || "default");
    if ("object" != typeof i) return i;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return ("string" === r ? String : Number)(t);
}
function _toPropertyKey(t) {
  var i = _toPrimitive(t, "string");
  return "symbol" == typeof i ? i : i + "";
}
function _unsupportedIterableToArray(r, a) {
  if (r) {
    if ("string" == typeof r) return _arrayLikeToArray(r, a);
    var t = {}.toString.call(r).slice(8, -1);
    return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0;
  }
}

/**
 * Copyright IBM Corp. 2015, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

var FeatureFlagScope = /*#__PURE__*/function () {
  function FeatureFlagScope(flags) {
    var _this = this;
    _classCallCheck(this, FeatureFlagScope);
    this.flags = new Map();
    if (flags) {
      Object.keys(flags).forEach(function (key) {
        _this.flags.set(key, flags[key]);
      });
    }
  }

  /**
   * Check to see if a flag exists
   * @param {string} name
   */
  return _createClass(FeatureFlagScope, [{
    key: "checkForFlag",
    value: function checkForFlag(name) {
      if (!this.flags.has(name)) {
        throw new Error("Unable to find a feature flag with the name: `".concat(name, "`"));
      }
    }

    /**
     * Add a feature flag
     * @param {string} name
     * @param {boolean} enabled
     */
  }, {
    key: "add",
    value: function add(name, enabled) {
      if (this.flags.has(name)) {
        throw new Error("The feature flag: ".concat(name, " already exists"));
      }
      this.flags.set(name, enabled);
    }

    /**
     * Enable a feature flag
     * @param {string} name
     */
  }, {
    key: "enable",
    value: function enable(name) {
      this.checkForFlag(name);
      this.flags.set(name, true);
    }

    /**
     * Disable a feature flag
     * @param {string} name
     */
  }, {
    key: "disable",
    value: function disable(name) {
      this.checkForFlag(name);
      this.flags.set(name, false);
    }

    /**
     * Merge the given feature flags with the current set of feature flags.
     * Duplicate keys will be set to the value in the given feature flags.
     * @param {object} flags
     */
  }, {
    key: "merge",
    value: function merge(flags) {
      var _this2 = this;
      Object.keys(flags).forEach(function (key) {
        _this2.flags.set(key, flags[key]);
      });
    }

    /**
     * @param {FeatureFlagScope} scope
     */
  }, {
    key: "mergeWithScope",
    value: function mergeWithScope(scope) {
      var _iterator = _createForOfIteratorHelper(scope.flags),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var _step$value = _slicedToArray(_step.value, 2),
            key = _step$value[0],
            value = _step$value[1];
          if (this.flags.has(key)) {
            continue;
          }
          this.flags.set(key, value);
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
    }

    /**
     * Check if a feature flag is enabled
     * @param {string} name
     * @returns {boolean}
     */
  }, {
    key: "enabled",
    value: function enabled(name) {
      this.checkForFlag(name);
      return this.flags.get(name);
    }
  }]);
}();

var FeatureFlags = createScope();
for (var i = 0; i < featureFlagInfo.length; i++) {
  var featureFlag = featureFlagInfo[i];
  FeatureFlags.add(featureFlag.name, featureFlag.enabled);
}
function createScope(flags) {
  return new FeatureFlagScope(flags);
}
function add() {
  return FeatureFlags.add.apply(FeatureFlags, arguments);
}
function enable() {
  return FeatureFlags.enable.apply(FeatureFlags, arguments);
}
function disable() {
  return FeatureFlags.disable.apply(FeatureFlags, arguments);
}
function enabled() {
  return FeatureFlags.enabled.apply(FeatureFlags, arguments);
}
function merge() {
  return FeatureFlags.merge.apply(FeatureFlags, arguments);
}

export { FeatureFlags, add, createScope, disable, enable, enabled, merge };
