/**
 * Copyright IBM Corp. 2018, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
interface IconAttributes extends Omit<React.SVGProps<React.ReactSVGElement>, 'tabIndex'> {
    tabindex?: string | number | undefined;
    title?: string | undefined;
}
export declare const defaultAttributes: IconAttributes;
/**
 * Get supplementary HTML attributes for a given <svg> element based on existing
 * attributes.
 */
export default function getAttributes({ width, height, viewBox, ...attributes }?: IconAttributes): IconAttributes;
export {};
