(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('react'), require('@carbon/icon-helpers'), require('prop-types')) :
  typeof define === 'function' && define.amd ? define(['exports', 'react', '@carbon/icon-helpers', 'prop-types'], factory) :
  (global = global || self, factory(global.CarbonIconsReact = {}, global.React, global.CarbonIconHelpers, global.PropTypes));
}(this, function (exports, React, iconHelpers, PropTypes) { 'use strict';

  React = React && React.hasOwnProperty('default') ? React['default'] : React;
  PropTypes = PropTypes && PropTypes.hasOwnProperty('default') ? PropTypes['default'] : PropTypes;

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    };

    return _extends.apply(this, arguments);
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);

    if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);
      if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });
      keys.push.apply(keys, symbols);
    }

    return keys;
  }

  function _objectSpread2(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};

      if (i % 2) {
        ownKeys(source, true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(source).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }

    return target;
  }

  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i;

    for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      target[key] = source[key];
    }

    return target;
  }

  function _objectWithoutProperties(source, excluded) {
    if (source == null) return {};

    var target = _objectWithoutPropertiesLoose(source, excluded);

    var key, i;

    if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

      for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];
        if (excluded.indexOf(key) >= 0) continue;
        if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
        target[key] = source[key];
      }
    }

    return target;
  }

  var defaultStyle = {
    willChange: 'transform'
  };
  var Icon = React.forwardRef(function Icon(_ref, ref) {
    var className = _ref.className,
        children = _ref.children,
        _ref$style = _ref.style,
        style = _ref$style === void 0 ? {} : _ref$style,
        tabIndex = _ref.tabIndex,
        rest = _objectWithoutProperties(_ref, ["className", "children", "style", "tabIndex"]);

    var _getAttributes = iconHelpers.getAttributes(_objectSpread2({}, rest, {
      tabindex: tabIndex
    })),
        tabindex = _getAttributes.tabindex,
        props = _objectWithoutProperties(_getAttributes, ["tabindex"]);

    if (className) {
      props.className = className;
    }

    if (tabindex !== undefined && tabindex !== null) {
      props.tabIndex = tabindex;
    }

    if (ref) {
      props.ref = ref;
    }

    props.style = _objectSpread2({}, defaultStyle, {}, style);
    return React.createElement('svg', props, children);
  });
  Icon.displayName = 'Icon';
  Icon.propTypes = {
    'aria-hidden': PropTypes.string,
    'aria-label': PropTypes.string,
    'aria-labelledby': PropTypes.string,
    className: PropTypes.string,
    children: PropTypes.node,
    height: PropTypes.number,
    preserveAspectRatio: PropTypes.string,
    tabIndex: PropTypes.string,
    viewBox: PropTypes.string,
    width: PropTypes.number,
    xmlns: PropTypes.string
  };
  Icon.defaultProps = {
    xmlns: 'http://www.w3.org/2000/svg',
    preserveAspectRatio: 'xMidYMid meet'
  };

  var AddAlt16=/*#__PURE__*/React.forwardRef(function AddAlt16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8 2c3.3 0 6 2.7 6 6s-2.7 6-6 6-6-2.7-6-6 2.7-6 6-6m0-1C4.1 1 1 4.1 1 8s3.1 7 7 7 7-3.1 7-7-3.1-7-7-7z"}),React.createElement("path",{d:"M12 7H9V4H7v3H4v2h3v3h2V9h3z"}),props.children);});var AddFilled16=/*#__PURE__*/React.forwardRef(function AddFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8 1C4.2 1 1 4.2 1 8s3.2 7 7 7 7-3.2 7-7-3.2-7-7-7zm4 8H9v3H7V9H4V7h3V4h2v3h3v2z"}),props.children);});var Add16=/*#__PURE__*/React.forwardRef(function Add16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M9 7V3H7v4H3v2h4v4h2V9h4V7z"}),props.children);});var AppSwitcher16=/*#__PURE__*/React.forwardRef(function AppSwitcher16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M12 12h2v2h-2zm-5 0h2v2H7zm-5 0h2v2H2zm10-5h2v2h-2zM7 7h2v2H7zM2 7h2v2H2zm10-5h2v2h-2zM7 2h2v2H7zM2 2h2v2H2z"}),props.children);});var Apps16=/*#__PURE__*/React.forwardRef(function Apps16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M4 2v2H2V2h2zm1-1H1v4h4V1zm4 1v2H7V2h2zm1-1H6v4h4V1zm4 1v2h-2V2h2zm1-1h-4v4h4V1zM4 7v2H2V7h2zm1-1H1v4h4V6zm4 1v2H7V7h2zm1-1H6v4h4V6zm4 1v2h-2V7h2zm1-1h-4v4h4V6zM4 12v2H2v-2h2zm1-1H1v4h4v-4zm4 1v2H7v-2h2zm1-1H6v4h4v-4zm4 1v2h-2v-2h2zm1-1h-4v4h4v-4z"}),props.children);});var ArrowDown16=/*#__PURE__*/React.forwardRef(function ArrowDown16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M12.3 9.3l-3.8 3.8V1h-1v12.1L3.7 9.3 3 10l5 5 5-5z"}),props.children);});var ArrowLeft16=/*#__PURE__*/React.forwardRef(function ArrowLeft16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M6.7 12.3L2.9 8.5H15v-1H2.9l3.8-3.8L6 3 1 8l5 5z"}),props.children);});var ArrowRight16=/*#__PURE__*/React.forwardRef(function ArrowRight16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M9.3 3.7l3.8 3.8H1v1h12.1l-3.8 3.8.7.7 5-5-5-5z"}),props.children);});var ArrowUp16=/*#__PURE__*/React.forwardRef(function ArrowUp16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M3.7 6.7l3.8-3.8V15h1V2.9l3.8 3.8.7-.7-5-5-5 5z"}),props.children);});var ArrowsVertical16=/*#__PURE__*/React.forwardRef(function ArrowsVertical16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M13.8 10.3L12 12.1V2h-1v10.1l-1.8-1.8-.7.7 3 3 3-3zM4.5 2l-3 3 .7.7L4 3.9V14h1V3.9l1.8 1.8.7-.7z"}),props.children);});var Arrows16=/*#__PURE__*/React.forwardRef(function Arrows16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M13.8 10.3L12 12.1V2h-1v10.1l-1.8-1.8-.7.7 3 3 3-3zM4.5 2l-3 3 .7.7L4 3.9V14h1V3.9l1.8 1.8.7-.7z"}),props.children);});var Asleep16=/*#__PURE__*/React.forwardRef(function Asleep16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M7.2 2.3c-1 4.4 1.7 8.7 6.1 9.8h.2c-1.1 1.2-2.7 1.8-4.3 1.8H9c-3.4-.1-6-2.9-5.8-6.2 0-2.4 1.6-4.6 4-5.4M8 1c-3.9.6-6.5 4.3-5.9 8.1.6 3.3 3.4 5.8 6.8 5.9h.3c2.3 0 4.4-1.1 5.8-3 .2-.2.1-.6-.1-.7-.1-.1-.2-.1-.3-.1-3.9-.3-6.7-3.8-6.4-7.6.1-.6.2-1.2.4-1.8.1-.3 0-.6-.3-.7C8.1 1 8.1 1 8 1z"}),props.children);});var Attachment16=/*#__PURE__*/React.forwardRef(function Attachment16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M14.1 9L7 1.9C5.6.6 3.3.7 2 2.1S.7 5.6 1.9 7l1.6 1.6.8-.8-1.6-1.6c-1-.9-1-2.5-.1-3.5s2.5-1 3.5-.1l.1.1 7.1 7.1c1 .9 1 2.5.1 3.5s-2.5 1-3.5.1l-.1-.1-3.3-3.4c-.6-.5-.6-1.4 0-1.9s1.4-.5 1.9 0l1.7 1.7.8-.7-1.8-1.8c-1-.9-2.5-.9-3.5.1-.9.9-.9 2.4 0 3.3L9 14.1c1.4 1.3 3.7 1.2 5-.2s1.3-3.5.1-4.9z"}),props.children);});var Awake16=/*#__PURE__*/React.forwardRef(function Awake16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M7.5 1h1v2.5h-1zm3.304 3.454l1.768-1.768.707.707-1.768 1.768zM12.5 7.5H15v1h-2.5zm-1.662 4.01l.707-.706 1.768 1.767-.707.707zM7.5 12.5h1V15h-1zm-4.778.11l1.768-1.77.707.707-1.768 1.768zM1 7.5h2.5v1H1zm1.688-4.07l.707-.706L5.163 4.49l-.707.707zM8 6c1.1 0 2 .9 2 2s-.9 2-2 2-2-.9-2-2 .9-2 2-2m0-1C6.3 5 5 6.3 5 8s1.3 3 3 3 3-1.3 3-3-1.3-3-3-3z"}),props.children);});var BackToTop16=/*#__PURE__*/React.forwardRef(function BackToTop16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8 7l-5 5 .7.7L8 8.4l4.3 4.3.7-.7zM2 4h12v1H2z"}),props.children);});var Calendar16=/*#__PURE__*/React.forwardRef(function Calendar16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M13 2h-2V1h-1v1H6V1H5v1H3c-.6 0-1 .4-1 1v10c0 .6.4 1 1 1h10c.6 0 1-.4 1-1V3c0-.6-.4-1-1-1zm0 11H3V6h10v7zm0-8H3V3h2v1h1V3h4v1h1V3h2v2z"}),props.children);});var CaretDown16=/*#__PURE__*/React.forwardRef(function CaretDown16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M12 6l-4 4-4-4z"}),props.children);});var CaretLeft16=/*#__PURE__*/React.forwardRef(function CaretLeft16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M11 12L6 8l5-4z"}),props.children);});var CaretRight16=/*#__PURE__*/React.forwardRef(function CaretRight16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M6 4l5 4-5 4z"}),props.children);});var CaretSortDown16=/*#__PURE__*/React.forwardRef(function CaretSortDown16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M11.5 10L8 14l-3.5-4z"}),props.children);});var CaretSortUp16=/*#__PURE__*/React.forwardRef(function CaretSortUp16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M4.5 6L8 2l3.5 4z"}),props.children);});var CaretSort16=/*#__PURE__*/React.forwardRef(function CaretSort16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M4.5 6L8 2l3.5 4zm7 4L8 14l-3.5-4z"}),props.children);});var CaretUp16=/*#__PURE__*/React.forwardRef(function CaretUp16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M4 10l4-4 4 4z"}),props.children);});var Chat16=/*#__PURE__*/React.forwardRef(function Chat16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8.9 14l-.9-.5 2-3.5h3c.6 0 1-.4 1-1V3c0-.6-.4-1-1-1H3c-.6 0-1 .4-1 1v6c0 .6.4 1 1 1h4.5v1H3c-1.1 0-2-.9-2-2V3c0-1.1.9-2 2-2h10c1.1 0 2 .9 2 2v6c0 1.1-.9 2-2 2h-2.4l-1.7 3z"}),React.createElement("path",{d:"M4 4h8v1H4zm0 3h5v1H4z"}),props.children);});var CheckmarkFilled16=/*#__PURE__*/React.forwardRef(function CheckmarkFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8 1C4.1 1 1 4.1 1 8s3.1 7 7 7 7-3.1 7-7-3.1-7-7-7zM7 11L4.3 8.3l.9-.8L7 9.3l4-3.9.9.8L7 11z"}),React.createElement("path",{d:"M7 11L4.3 8.3l.9-.8L7 9.3l4-3.9.9.8L7 11z","data-icon-path":"inner-path",opacity:"0"}),props.children);});var CheckmarkOutline16=/*#__PURE__*/React.forwardRef(function CheckmarkOutline16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8 1C4.1 1 1 4.1 1 8s3.1 7 7 7 7-3.1 7-7-3.1-7-7-7zm0 13c-3.3 0-6-2.7-6-6s2.7-6 6-6 6 2.7 6 6-2.7 6-6 6z"}),React.createElement("path",{d:"M7 10.8L4.5 8.3l.8-.8L7 9.2l3.7-3.7.8.8z"}),props.children);});var Checkmark16=/*#__PURE__*/React.forwardRef(function Checkmark16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M6 10.6L2.5 7.1l-.7.7 3.5 3.5.7.7 7.1-7.1-.7-.7z"}),props.children);});var ChevronDown16=/*#__PURE__*/React.forwardRef(function ChevronDown16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8 11L3 6l.7-.7L8 9.6l4.3-4.3.7.7z"}),props.children);});var ChevronLeft16=/*#__PURE__*/React.forwardRef(function ChevronLeft16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M5 8l5-5 .7.7L6.4 8l4.3 4.3-.7.7z"}),props.children);});var ChevronMini16=/*#__PURE__*/React.forwardRef(function ChevronMini16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M15 9v6H9z"}),props.children);});var ChevronRight16=/*#__PURE__*/React.forwardRef(function ChevronRight16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M11 8l-5 5-.7-.7L9.6 8 5.3 3.7 6 3z"}),props.children);});var ChevronSortDown16=/*#__PURE__*/React.forwardRef(function ChevronSortDown16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8 14l-3.5-3.5.7-.7L8 12.6l2.8-2.8.7.7z"}),props.children);});var ChevronSortUp16=/*#__PURE__*/React.forwardRef(function ChevronSortUp16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8 2l3.5 3.5-.7.7L8 3.4 5.2 6.2l-.7-.7z"}),props.children);});var ChevronSort16=/*#__PURE__*/React.forwardRef(function ChevronSort16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8 14l-3.5-3.5.7-.7L8 12.6l2.8-2.8.7.7zM8 2l3.5 3.5-.7.7L8 3.4 5.2 6.2l-.7-.7z"}),props.children);});var ChevronUp16=/*#__PURE__*/React.forwardRef(function ChevronUp16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8 5l5 5-.7.7L8 6.4l-4.3 4.3L3 10z"}),props.children);});var CloseFilled16=/*#__PURE__*/React.forwardRef(function CloseFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8 1C4.1 1 1 4.1 1 8s3.1 7 7 7 7-3.1 7-7-3.1-7-7-7zm2.7 10.5L8 8.8l-2.7 2.7-.8-.8L7.2 8 4.5 5.3l.8-.8L8 7.2l2.7-2.7.8.8L8.8 8l2.7 2.7-.8.8z"}),props.children);});var CloseOutline16=/*#__PURE__*/React.forwardRef(function CloseOutline16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8 1C4.1 1 1 4.1 1 8s3.1 7 7 7 7-3.1 7-7-3.1-7-7-7zm0 13c-3.3 0-6-2.7-6-6s2.7-6 6-6 6 2.7 6 6-2.7 6-6 6z"}),React.createElement("path",{d:"M10.7 11.5L8 8.8l-2.7 2.7-.8-.8L7.2 8 4.5 5.3l.8-.8L8 7.2l2.7-2.7.8.8L8.8 8l2.7 2.7z"}),props.children);});var Close16=/*#__PURE__*/React.forwardRef(function Close16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M12 4.7l-.7-.7L8 7.3 4.7 4l-.7.7L7.3 8 4 11.3l.7.7L8 8.7l3.3 3.3.7-.7L8.7 8z"}),props.children);});var Code16=/*#__PURE__*/React.forwardRef(function Code16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M15.5 8L12 11.5l-.7-.7L14.1 8l-2.8-2.8.7-.7zM.5 8L4 4.5l.7.7L1.9 8l2.8 2.8-.7.7zm5.72 4.697l2.615-9.756.966.26-2.614 9.755z"}),props.children);});var CopyFile16=/*#__PURE__*/React.forwardRef(function CopyFile16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M14.72 7.35l-3-3.06A1 1 0 0 0 11 4H5a1 1 0 0 0-1 1v9a1 1 0 0 0 1 1h9a1 1 0 0 0 1-1V8a1 1 0 0 0-.28-.65zM11 5l3 3h-3zm-6 9V5h5v3a1 1 0 0 0 1 1h3v5z"}),React.createElement("path",{d:"M2 9H1V2a1 1 0 0 1 1-1h7v1H2z"}),props.children);});var Copy16=/*#__PURE__*/React.forwardRef(function Copy16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M14 5v9H5V5h9m0-1H5a1 1 0 0 0-1 1v9a1 1 0 0 0 1 1h9a1 1 0 0 0 1-1V5a1 1 0 0 0-1-1z"}),React.createElement("path",{d:"M2 9H1V2a1 1 0 0 1 1-1h7v1H2z"}),props.children);});var Delete16=/*#__PURE__*/React.forwardRef(function Delete16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M6 6h1v6H6zm3 0h1v6H9z"}),React.createElement("path",{d:"M2 3v1h1v10c0 .6.4 1 1 1h8c.6 0 1-.4 1-1V4h1V3H2zm2 11V4h8v10H4zM6 1h4v1H6z"}),props.children);});var Document16=/*#__PURE__*/React.forwardRef(function Document16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M12.9 4.7L9.4 1.2C9.3 1.1 9.1 1 9 1H4c-.6 0-1 .4-1 1v12c0 .6.4 1 1 1h8c.6 0 1-.4 1-1V5c0-.1-.1-.3-.1-.3zM9 2.2L11.8 5H9V2.2zM12 14H4V2h4v3c0 .6.4 1 1 1h3v8z"}),React.createElement("path",{d:"M5 11h6v1H5zm0-3h6v1H5z"}),props.children);});var DownToBottom16=/*#__PURE__*/React.forwardRef(function DownToBottom16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8 10l5-5-.7-.7L8 8.6 3.7 4.3 3 5zm-6 2h12v1H2z"}),props.children);});var Download16=/*#__PURE__*/React.forwardRef(function Download16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M13 7l-.7-.7-3.8 3.8V1h-1v9.1L3.7 6.3 3 7l5 5zm0 5v2H3v-2H2v2c0 .6.4 1 1 1h10c.6 0 1-.4 1-1v-2h-1z"}),props.children);});var Draggable16=/*#__PURE__*/React.forwardRef(function Draggable16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M5 3h2v2H5zm4 0h2v2H9zM5 7h2v2H5zm4 0h2v2H9zm-4 4h2v2H5zm4 0h2v2H9z"}),props.children);});var EditOff16=/*#__PURE__*/React.forwardRef(function EditOff16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M15 14.3L1.7 1l-.7.7 5 5-4 4V14h3.2l4-4 5 5 .8-.7zM4.8 13H3v-1.8l3.8-3.8 1.8 1.8L4.8 13zm9.9-9.9l-1.8-1.8c-.4-.4-1-.4-1.4 0l-4 4 .7.7L10 4.2 11.8 6 10 7.8l.7.7 4-4c.4-.4.4-1 0-1.4zm-2.2 2.2l-1.8-1.8L12.2 2 14 3.8l-1.5 1.5z"}),props.children);});var Edit16=/*#__PURE__*/React.forwardRef(function Edit16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M1 13h14v1H1zm11.7-8.5c.4-.4.4-1 0-1.4l-1.8-1.8c-.4-.4-1-.4-1.4 0L2 8.8V12h3.2l7.5-7.5zM10.2 2L12 3.8l-1.5 1.5-1.8-1.8L10.2 2zM3 11V9.2l5-5L9.8 6l-5 5H3z"}),props.children);});var Email16=/*#__PURE__*/React.forwardRef(function Email16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M14 3H2c-.6 0-1 .4-1 1v8c0 .6.4 1 1 1h12c.6 0 1-.4 1-1V4c0-.6-.4-1-1-1zm-1.1 1L8 7.4 3.1 4h9.8zM2 12V4.5l5.7 4c.2.1.4.1.6 0l5.7-4V12H2z"}),props.children);});var ErrorFilled16=/*#__PURE__*/React.forwardRef(function ErrorFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8 1C4.1 1 1 4.1 1 8s3.1 7 7 7 7-3.1 7-7-3.1-7-7-7zm2.7 10.5L4.5 5.3l.8-.8 6.2 6.2-.8.8z"}),React.createElement("path",{d:"M10.7 11.5L4.5 5.3l.8-.8 6.2 6.2-.8.8z","data-icon-path":"inner-path",opacity:"0"}),props.children);});var ErrorOutline16=/*#__PURE__*/React.forwardRef(function ErrorOutline16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8 1C4.1 1 1 4.1 1 8s3.1 7 7 7 7-3.1 7-7-3.1-7-7-7zm0 13c-3.3 0-6-2.7-6-6s2.7-6 6-6 6 2.7 6 6-2.7 6-6 6z"}),React.createElement("path",{d:"M4.464 5.313l.778-.778 6.223 6.223-.778.777z"}),props.children);});var Export16=/*#__PURE__*/React.forwardRef(function Export16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M13 12v2H3v-2H2v2c0 .6.4 1 1 1h10c.6 0 1-.4 1-1v-2h-1zM3 6l.7.7 3.8-3.8V12h1V2.9l3.8 3.8.7-.7-5-5z"}),props.children);});var Fade16=/*#__PURE__*/React.forwardRef(function Fade16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M4.1 12.6l-.6.8c.6.5 1.3.9 2.1 1.2l.3-.9c-.6-.3-1.2-.7-1.8-1.1zM2.1 9l-1 .2c.1.8.4 1.6.8 2.3l.9-.5c-.4-.6-.6-1.3-.7-2zm3.8-6.6l-.3-1c-.8.3-1.5.7-2.1 1.3l.6.8c.6-.5 1.2-.9 1.8-1.1zM2.8 5l-.9-.5c-.4.7-.6 1.5-.8 2.3l1 .2c.1-.7.4-1.4.7-2zM8 1v1c3.3 0 6 2.7 6 6s-2.7 6-6 6v1c3.9 0 7-3.1 7-7s-3.1-7-7-7z"}),props.children);});var FavoriteFilled16=/*#__PURE__*/React.forwardRef(function FavoriteFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M11.2 2c-1 0-2 .4-2.7 1.1l-.5.6-.6-.6C6 1.6 3.6 1.6 2.1 3.1S.6 7 2.1 8.5l5.9 6 5.9-6c1.5-1.5 1.5-3.9 0-5.4-.7-.7-1.7-1.1-2.7-1.1z"}),props.children);});var Favorite16=/*#__PURE__*/React.forwardRef(function Favorite16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M11.2 3c.7 0 1.4.3 2 .8 1.1 1.1 1.1 2.9 0 4L8 13.1 2.8 7.8c-1.1-1.1-1.1-2.9 0-4s2.8-1.1 3.9 0L8 5.1l1.3-1.3c.5-.5 1.2-.8 1.9-.8m0-1c-1 0-2 .4-2.7 1.1l-.5.6-.6-.6C6 1.6 3.6 1.6 2.1 3.1S.6 7 2.1 8.5l5.9 6 5.9-6c1.5-1.5 1.5-3.9 0-5.4-.7-.7-1.7-1.1-2.7-1.1z"}),props.children);});var Filter16=/*#__PURE__*/React.forwardRef(function Filter16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M15 4h-2.1c-.2-1.1-1.2-2-2.4-2s-2.2.9-2.4 2H1v1h7.1c.2 1.1 1.2 2 2.4 2s2.2-.9 2.4-2H15V4zm-4.5 2C9.7 6 9 5.3 9 4.5S9.7 3 10.5 3s1.5.7 1.5 1.5S11.3 6 10.5 6zM1 12h2.1c.2 1.1 1.2 2 2.4 2s2.2-.9 2.4-2H15v-1H7.9c-.2-1.1-1.2-2-2.4-2s-2.2.9-2.4 2H1v1zm4.5-2c.8 0 1.5.7 1.5 1.5S6.3 13 5.5 13 4 12.3 4 11.5 4.7 10 5.5 10z"}),props.children);});var FolderAdd16=/*#__PURE__*/React.forwardRef(function FolderAdd16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M13 10h-1v2h-2v1h2v2h1v-2h2v-1h-2z"}),React.createElement("path",{d:"M14 4H8L6.3 2.3c-.2-.2-.4-.3-.7-.3H2c-.6 0-1 .4-1 1v10c0 .6.4 1 1 1h6v-1H2V3h3.6l1.7 1.7.3.3H14v4h1V5c0-.6-.4-1-1-1z"}),props.children);});var Folder16=/*#__PURE__*/React.forwardRef(function Folder16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M5.6 3l1.7 1.7.3.3H14v8H2V3h3.6m0-1H2c-.6 0-1 .4-1 1v10c0 .6.4 1 1 1h12c.6 0 1-.4 1-1V5c0-.6-.4-1-1-1H8L6.3 2.3c-.2-.2-.4-.3-.7-.3z"}),props.children);});var Forum16=/*#__PURE__*/React.forwardRef(function Forum16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M2 9H1V2.5C1 1.7 1.7 1 2.5 1H9v1H2v7z"}),React.createElement("path",{d:"M14 3H4c-.6 0-1 .4-1 1v7c0 .6.4 1 1 1h4v-1H4V4h10v7h-3.6L8 14.4l.8.6 2.1-3H14c.6 0 1-.4 1-1V4c0-.6-.4-1-1-1z"}),props.children);});var Grid16=/*#__PURE__*/React.forwardRef(function Grid16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M6 2H3c-.6 0-1 .4-1 1v3c0 .6.4 1 1 1h3c.6 0 1-.4 1-1V3c0-.6-.4-1-1-1zm0 4H3V3h3v3zm7-4h-3c-.6 0-1 .4-1 1v3c0 .6.4 1 1 1h3c.6 0 1-.4 1-1V3c0-.6-.4-1-1-1zm0 4h-3V3h3v3zM6 9H3c-.6 0-1 .4-1 1v3c0 .6.4 1 1 1h3c.6 0 1-.4 1-1v-3c0-.6-.4-1-1-1zm0 4H3v-3h3v3zm7-4h-3c-.6 0-1 .4-1 1v3c0 .6.4 1 1 1h3c.6 0 1-.4 1-1v-3c0-.6-.4-1-1-1zm0 4h-3v-3h3v3z"}),props.children);});var HelpFilled16=/*#__PURE__*/React.forwardRef(function HelpFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8 1C4.1 1 1 4.1 1 8s3.1 7 7 7 7-3.1 7-7-3.1-7-7-7zm0 11.5c-.4 0-.8-.3-.8-.8s.4-.7.8-.7.8.3.8.8-.4.7-.8.7zm.6-3.9v1.2H7.4V7.5h1.1c.7 0 1.2-.6 1.1-1.3 0-.6-.5-1.1-1.1-1.1h-.7c-.7 0-1.2.5-1.2 1.2v.3H5.4v-.3C5.4 5 6.5 4 7.8 4h.7c1.3 0 2.3 1.1 2.2 2.4 0 1.2-.9 2.2-2.1 2.2z"}),props.children);});var Help16=/*#__PURE__*/React.forwardRef(function Help16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8 1C4.1 1 1 4.1 1 8s3.1 7 7 7 7-3.1 7-7-3.1-7-7-7zm0 13c-3.3 0-6-2.7-6-6s2.7-6 6-6 6 2.7 6 6-2.7 6-6 6z"}),React.createElement("circle",{cx:"8",cy:"11.8",r:".8"}),React.createElement("path",{d:"M8.5 4h-.7C6.5 4 5.5 5 5.5 6.2v.2h1v-.2c0-.6.6-1.2 1.3-1.2h.8c.7 0 1.2.6 1.2 1.2s-.6 1.3-1.3 1.3h-1v2.2h1V8.5c1.2 0 2.2-1 2.2-2.2S9.7 4 8.5 4z"}),props.children);});var InformationFilled16=/*#__PURE__*/React.forwardRef(function InformationFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8 1C4.1 1 1 4.1 1 8s3.1 7 7 7 7-3.1 7-7-3.1-7-7-7zm0 2.5c.4 0 .8.3.8.8S8.4 5 8 5s-.8-.3-.8-.8.4-.7.8-.7zm2 8.6H6V11h1.4V7.6h-.9V6.4h2.1v4.5H10v1.2z"}),props.children);});var Information16=/*#__PURE__*/React.forwardRef(function Information16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8.5 11V6.5h-2v1h1V11H6v1h4v-1zM8 3.5c-.4 0-.8.3-.8.8s.4.7.8.7.8-.3.8-.8-.4-.7-.8-.7z"}),React.createElement("path",{d:"M8 15c-3.9 0-7-3.1-7-7s3.1-7 7-7 7 3.1 7 7-3.1 7-7 7zM8 2C4.7 2 2 4.7 2 8s2.7 6 6 6 6-2.7 6-6-2.7-6-6-6z"}),props.children);});var Launch16=/*#__PURE__*/React.forwardRef(function Launch16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M13 14H3c-.6 0-1-.4-1-1V3c0-.6.4-1 1-1h5v1H3v10h10V8h1v5c0 .6-.4 1-1 1z"}),React.createElement("path",{d:"M10 1v1h3.3L9 6.3l.7.7L14 2.7V6h1V1z"}),props.children);});var Light16=/*#__PURE__*/React.forwardRef(function Light16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M7.5 1h1v2.5h-1zm3.294 3.43l1.767-1.767.708.707L11.5 5.138zM12.5 7.5H15v1h-2.5zm-1.638 4l.707-.708 1.767 1.768-.707.707zm-3.362 1h1V15h-1zm-4.77.131l1.768-1.768.707.708-1.768 1.767zM1 7.5h2.5v1H1zm1.662-4.06l.707-.707 1.768 1.768-.707.707zM8 6c1.1 0 2 .9 2 2s-.9 2-2 2-2-.9-2-2 .9-2 2-2m0-1C6.3 5 5 6.3 5 8s1.3 3 3 3 3-1.3 3-3-1.3-3-3-3z"}),props.children);});var ListBulleted16=/*#__PURE__*/React.forwardRef(function ListBulleted16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("circle",{cx:"3.5",cy:"4.5",r:"1.5"}),React.createElement("circle",{cx:"3.5",cy:"11.5",r:"1.5"}),React.createElement("path",{d:"M8 11h7v1H8zm0-7h7v1H8z"}),props.children);});var Locked16=/*#__PURE__*/React.forwardRef(function Locked16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M12 7h-1V4c0-1.7-1.3-3-3-3S5 2.3 5 4v3H4c-.6 0-1 .4-1 1v6c0 .6.4 1 1 1h8c.6 0 1-.4 1-1V8c0-.6-.4-1-1-1zM6 4c0-1.1.9-2 2-2s2 .9 2 2v3H6V4zm6 10H4V8h8v6z"}),props.children);});var Maximize16=/*#__PURE__*/React.forwardRef(function Maximize16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M10 1v1h3.3L8.5 6.8l.7.7L14 2.7V6h1V1zM7.5 9.2l-.7-.7L2 13.3V10H1v5h5v-1H2.7z"}),props.children);});var Menu16=/*#__PURE__*/React.forwardRef(function Menu16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M2 12h12v1H2zm0-3h12v1H2zm0-3h12v1H2zm0-3h12v1H2z"}),props.children);});var Minimize16=/*#__PURE__*/React.forwardRef(function Minimize16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M3 9v1h2.3L1 14.3l.7.7L6 10.7V13h1V9zm10-2V6h-2.3L15 1.7l-.7-.7L10 5.3V3H9v4z"}),props.children);});var MisuseOutline16=/*#__PURE__*/React.forwardRef(function MisuseOutline16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8 1C4.1 1 1 4.1 1 8s3.1 7 7 7 7-3.1 7-7-3.1-7-7-7zm0 13c-3.3 0-6-2.7-6-6s2.7-6 6-6 6 2.7 6 6-2.7 6-6 6z"}),React.createElement("path",{d:"M10.7 11.5L8 8.8l-2.7 2.7-.8-.8L7.2 8 4.5 5.3l.8-.8L8 7.2l2.7-2.7.8.8L8.8 8l2.7 2.7z"}),props.children);});var Misuse16=/*#__PURE__*/React.forwardRef(function Misuse16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8 1C4.1 1 1 4.1 1 8s3.1 7 7 7 7-3.1 7-7-3.1-7-7-7zm2.7 10.5L8 8.8l-2.7 2.7-.8-.8L7.2 8 4.5 5.3l.8-.8L8 7.2l2.7-2.7.8.8L8.8 8l2.7 2.7-.8.8z"}),React.createElement("path",{d:"M10.7 11.5L8 8.8l-2.7 2.7-.8-.8L7.2 8 4.5 5.3l.8-.8L8 7.2l2.7-2.7.8.8L8.8 8l2.7 2.7-.8.8z","data-icon-path":"inner-path",opacity:"0"}),props.children);});var NewTab16=/*#__PURE__*/React.forwardRef(function NewTab16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M13 13H3V3h5V2H3c-.6 0-1 .4-1 1v10c0 .6.4 1 1 1h10c.6 0 1-.4 1-1V8h-1v5z"}),React.createElement("path",{d:"M13 3V1h-1v2h-2v1h2v2h1V4h2V3z"}),props.children);});var NotificationOff16=/*#__PURE__*/React.forwardRef(function NotificationOff16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M2.5 11.5v-.8l1.3-1.4c.1 0 .2-.2.2-.3V6.5c0-2.2 1.8-4 4-4 .9 0 1.8.3 2.5.9l.7-.7c-.7-.7-1.7-1.1-2.7-1.2v-1h-1v1C5 1.8 3 3.9 3 6.5v2.3l-1.4 1.3c-.1.1-.2.2-.1.4v1h1zM13 8.8V6.5c0-.8-.2-1.6-.5-2.2L15 1.7l-.7-.7L1 14.3l.7.7 2.5-2.5h1.3C5.5 13.9 6.6 15 8 15s2.5-1.1 2.5-2.5H14c.3 0 .5-.2.5-.4v-1.6c0-.1-.1-.3-.1-.4L13 8.8zM8 14c-.8 0-1.5-.7-1.5-1.5h3c0 .8-.7 1.5-1.5 1.5zm5.5-2.5H5.2L11.7 5c.2.5.3 1 .3 1.5V9c0 .1.1.3.1.4l1.4 1.3v.8z"}),props.children);});var Notification16=/*#__PURE__*/React.forwardRef(function Notification16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M14.4 10.1L13 8.8V6.5c0-2.6-1.9-4.7-4.5-5v-1h-1v1C5 1.8 3 3.9 3 6.5v2.3l-1.4 1.3c-.1.1-.2.2-.1.4V12c0 .3.2.5.4.5h3.6C5.5 13.9 6.6 15 8 15s2.5-1.1 2.5-2.5H14c.3 0 .5-.2.5-.4v-1.6c0-.1-.1-.3-.1-.4zM8 14c-.8 0-1.5-.7-1.5-1.5h3c0 .8-.7 1.5-1.5 1.5zm5.5-2.5h-11v-.8l1.3-1.4c.1 0 .2-.2.2-.3V6.5c0-2.2 1.8-4 4-4s4 1.8 4 4V9c0 .1.1.3.1.4l1.4 1.3v.8z"}),props.children);});var OverflowMenuHorizontal16=/*#__PURE__*/React.forwardRef(function OverflowMenuHorizontal16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("circle",{cx:"3",cy:"8",r:"1"}),React.createElement("circle",{cx:"8",cy:"8",r:"1"}),React.createElement("circle",{cx:"13",cy:"8",r:"1"}),props.children);});var OverflowMenuVertical16=/*#__PURE__*/React.forwardRef(function OverflowMenuVertical16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("circle",{cx:"8",cy:"3",r:"1"}),React.createElement("circle",{cx:"8",cy:"8",r:"1"}),React.createElement("circle",{cx:"8",cy:"13",r:"1"}),props.children);});var PauseOutlineFilled16=/*#__PURE__*/React.forwardRef(function PauseOutlineFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8 1C4.1 1 1 4.1 1 8s3.1 7 7 7 7-3.1 7-7-3.1-7-7-7zM7 11H6V5h1v6zm3 0H9V5h1v6z"}),props.children);});var PauseOutline16=/*#__PURE__*/React.forwardRef(function PauseOutline16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M7 5H6v6h1V5zm3 0H9v6h1V5z"}),React.createElement("path",{d:"M8 2c3.3 0 6 2.7 6 6s-2.7 6-6 6-6-2.7-6-6 2.7-6 6-6m0-1C4.1 1 1 4.1 1 8s3.1 7 7 7 7-3.1 7-7-3.1-7-7-7z"}),props.children);});var Pause16=/*#__PURE__*/React.forwardRef(function Pause16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M6 4v8H4V4h2m0-1H4c-.6 0-1 .4-1 1v8c0 .6.4 1 1 1h2c.6 0 1-.4 1-1V4c0-.6-.4-1-1-1zm6 1v8h-2V4h2m0-1h-2c-.6 0-1 .4-1 1v8c0 .6.4 1 1 1h2c.6 0 1-.4 1-1V4c0-.6-.4-1-1-1z"}),props.children);});var PlayFilled16=/*#__PURE__*/React.forwardRef(function PlayFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8 1C4.1 1 1 4.1 1 8s3.1 7 7 7 7-3.1 7-7-3.1-7-7-7zm3.7 7.4l-5.5 3c-.2.1-.3.1-.5 0s-.2-.3-.2-.4V5c0-.2.1-.3.2-.4.2-.1.3-.1.5 0l5.5 3c.3.1.4.4.2.6 0 .1-.1.2-.2.2z"}),props.children);});var PlayOutlineFilled16=/*#__PURE__*/React.forwardRef(function PlayOutlineFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8 1C4.1 1 1 4.1 1 8s3.1 7 7 7 7-3.1 7-7-3.1-7-7-7zm3.7 7.4l-5.5 3c-.2.1-.3.1-.5 0s-.2-.3-.2-.4V5c0-.2.1-.3.2-.4.2-.1.3-.1.5 0l5.5 3c.3.1.4.4.2.6 0 .1-.1.2-.2.2z"}),React.createElement("path",{d:"M6.5 10.2l4-2.2-4-2.2z"}),props.children);});var PlayOutline16=/*#__PURE__*/React.forwardRef(function PlayOutline16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8 2c3.3 0 6 2.7 6 6s-2.7 6-6 6-6-2.7-6-6 2.7-6 6-6m0-1C4.1 1 1 4.1 1 8s3.1 7 7 7 7-3.1 7-7-3.1-7-7-7z"}),React.createElement("path",{d:"M6 11.5c-.1 0-.2 0-.3-.1-.2-.1-.2-.3-.2-.4V5c0-.2.1-.3.2-.4.2-.1.3-.1.5 0l5.5 3c.3.1.4.4.2.6 0 .1-.1.2-.2.2l-5.5 3c0 .1-.1.1-.2.1zm.5-5.7v4.3l4-2.2-4-2.1z"}),props.children);});var Play16=/*#__PURE__*/React.forwardRef(function Play16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M3.5 14c-.3 0-.5-.2-.5-.5v-11c0-.2.1-.3.2-.4.2-.1.4-.1.6 0l9.5 5.5c.2.1.3.4.2.7 0 .1-.1.1-.2.2L3.8 14h-.3zM4 3.4v9.3L12 8 4 3.4z"}),props.children);});var Power16=/*#__PURE__*/React.forwardRef(function Power16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M11.2 2.9l-.5.9c2.6 1.5 3.5 4.9 2 7.5s-4.9 3.5-7.5 2-3.5-4.9-2-7.5c.5-.8 1.2-1.5 2-2l-.4-.9C1.7 4.7.6 8.7 2.4 11.8s5.8 4.2 8.9 2.4 4.2-5.8 2.4-8.9c-.6-1-1.5-1.9-2.5-2.4z"}),React.createElement("path",{d:"M7.5 1h1v7h-1z"}),props.children);});var Redo16=/*#__PURE__*/React.forwardRef(function Redo16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M4 8c-1.2 0-2 .8-2 2s.8 2 2 2h3v1H4c-1.7 0-3-1.2-3-3 0-1.7 1.3-3 3-3h9.1l-2-2 .7-.7L15 7.5l-3.2 3.2-.7-.7 2-2H4z"}),props.children);});var Restart16=/*#__PURE__*/React.forwardRef(function Restart16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M13 9c0 2.8-2.2 5-5 5s-5-2.2-5-5 2.2-5 5-5h3.1L9.3 5.8l.7.7 3-3-3-3-.7.7L11.1 3H8C4.7 3 2 5.7 2 9s2.7 6 6 6 6-2.7 6-6h-1z"}),props.children);});var Save16=/*#__PURE__*/React.forwardRef(function Save16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M13.9 4.6l-2.5-2.5c-.1 0-.3-.1-.4-.1H3c-.6 0-1 .4-1 1v10c0 .6.4 1 1 1h10c.6 0 1-.4 1-1V5c0-.1-.1-.3-.1-.4zM6 3h4v2H6V3zm4 10H6V9h4v4zm1 0V9c0-.6-.4-1-1-1H6c-.6 0-1 .4-1 1v4H3V3h2v2c0 .6.4 1 1 1h4c.6 0 1-.4 1-1V3.2l2 2V13h-2z"}),props.children);});var Search16=/*#__PURE__*/React.forwardRef(function Search16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M15 14.3L10.7 10c1.9-2.3 1.6-5.8-.7-7.7S4.2.7 2.3 3 .7 8.8 3 10.7c2 1.7 5 1.7 7 0l4.3 4.3.7-.7zM2 6.5C2 4 4 2 6.5 2S11 4 11 6.5 9 11 6.5 11 2 9 2 6.5z"}),props.children);});var Settings16=/*#__PURE__*/React.forwardRef(function Settings16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M13.5 8.4v-.8l1-.8c.4-.3.4-.9.2-1.3l-1.2-2c-.2-.3-.5-.5-.9-.5-.1 0-.2 0-.3.1l-1.2.4c-.2-.1-.4-.3-.7-.4l-.3-1.3c0-.5-.4-.8-.9-.8H6.8c-.5 0-.9.3-1 .8l-.2 1.3c-.3.1-.5.2-.7.3L3.7 3h-.3c-.4 0-.7.2-.9.5l-1.2 2c-.2.4-.1.9.3 1.3l.9.9v.8l-.9.7c-.4.3-.5.9-.2 1.3l1.2 2c.1.3.4.5.8.5.1 0 .2 0 .3-.1l1.2-.4c.2.1.4.3.7.4l.3 1.3c.1.5.5.8 1 .8h2.4c.5 0 .9-.3 1-.8l.3-1.3c.2-.1.4-.2.7-.4l1.2.4c.1 0 .2.1.3.1.4 0 .7-.2.9-.5l1.1-2c.2-.4.2-.9-.2-1.3l-1.1-.8zm-.9 3.6l-1.7-.6c-.4.3-.9.6-1.4.8L9.2 14H6.8l-.4-1.8c-.5-.2-.9-.5-1.4-.8l-1.6.6-1.2-2 1.4-1.2c-.1-.5-.1-1.1 0-1.6L2.2 6l1.2-2 1.7.6c.4-.4.9-.6 1.4-.8L6.8 2h2.4l.4 1.8c.5.2.9.5 1.4.8l1.6-.6 1.2 2-1.4 1.2c.1.5.1 1.1 0 1.6l1.4 1.2-1.2 2z"}),React.createElement("path",{d:"M8 11c-1.7 0-3-1.3-3-3s1.3-3 3-3 3 1.3 3 3c0 1.6-1.3 3-3 3zm0-5c-1.1 0-2 .8-2 1.9V8c0 1.1.8 2 1.9 2H8c1.1 0 2-.8 2-1.9V8c0-1.1-.8-2-2-2 .1 0 0 0 0 0z"}),props.children);});var StarFilled16=/*#__PURE__*/React.forwardRef(function StarFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8 1L5.7 5.6l-5.1.7 3.7 3.6-.8 5.1L8 12.6l4.6 2.4-.9-5.1 3.7-3.6-5.1-.7L8 1z"}),props.children);});var StarHalf16=/*#__PURE__*/React.forwardRef(function StarHalf16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M5.7 5.6l-5.1.7 3.7 3.6-.8 5.1L8 12.6V1z"}),props.children);});var Star16=/*#__PURE__*/React.forwardRef(function Star16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8 3.3l1.4 2.8.2.5.5.1 3.1.4L11 9.2l-.4.4.1.5.5 3.1-2.8-1.4-.4-.3-.5.2-2.8 1.4.5-3.1.1-.5-.3-.3L2.8 7l3.1-.4.5-.1.2-.5L8 3.3M8 1L5.7 5.6l-5.1.7 3.7 3.6-.8 5.1L8 12.6l4.6 2.4-.9-5.1 3.7-3.6-5.1-.7L8 1z"}),props.children);});var StopFilled16=/*#__PURE__*/React.forwardRef(function StopFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8 1C4.1 1 1 4.1 1 8s3.1 7 7 7 7-3.1 7-7-3.1-7-7-7zm3 9c0 .6-.4 1-1 1H6c-.6 0-1-.4-1-1V6c0-.6.4-1 1-1h4c.6 0 1 .4 1 1v4z"}),props.children);});var StopOutlineFilled16=/*#__PURE__*/React.forwardRef(function StopOutlineFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8 1C4.1 1 1 4.1 1 8s3.1 7 7 7 7-3.1 7-7-3.1-7-7-7zm3 9c0 .6-.4 1-1 1H6c-.6 0-1-.4-1-1V6c0-.6.4-1 1-1h4c.6 0 1 .4 1 1v4z"}),React.createElement("path",{d:"M6 6h4v4H6z"}),props.children);});var StopOutline16=/*#__PURE__*/React.forwardRef(function StopOutline16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8 2c3.3 0 6 2.7 6 6s-2.7 6-6 6-6-2.7-6-6 2.7-6 6-6m0-1C4.1 1 1 4.1 1 8s3.1 7 7 7 7-3.1 7-7-3.1-7-7-7z"}),React.createElement("path",{d:"M10 6v4H6V6h4m0-1H6c-.6 0-1 .4-1 1v4c0 .6.4 1 1 1h4c.6 0 1-.4 1-1V6c0-.6-.4-1-1-1z"}),props.children);});var Stop16=/*#__PURE__*/React.forwardRef(function Stop16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M12 4v8H4V4h8m0-1H4c-.6 0-1 .4-1 1v8c0 .6.4 1 1 1h8c.6 0 1-.4 1-1V4c0-.6-.4-1-1-1z"}),props.children);});var SubtractAlt16=/*#__PURE__*/React.forwardRef(function SubtractAlt16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8 2c3.3 0 6 2.7 6 6s-2.7 6-6 6-6-2.7-6-6 2.7-6 6-6m0-1C4.1 1 1 4.1 1 8s3.1 7 7 7 7-3.1 7-7-3.1-7-7-7z"}),React.createElement("path",{d:"M5 7.5h6v1H5z"}),props.children);});var Subtract16=/*#__PURE__*/React.forwardRef(function Subtract16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M4 7.5h8v1H4z"}),props.children);});var Switcher16=/*#__PURE__*/React.forwardRef(function Switcher16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M12 12h2v2h-2zm-5 0h2v2H7zm-5 0h2v2H2zm10-5h2v2h-2zM7 7h2v2H7zM2 7h2v2H2zm10-5h2v2h-2zM7 2h2v2H7zM2 2h2v2H2z"}),props.children);});var TrashCan16=/*#__PURE__*/React.forwardRef(function TrashCan16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M6 6h1v6H6zm3 0h1v6H9z"}),React.createElement("path",{d:"M2 3v1h1v10c0 .6.4 1 1 1h8c.6 0 1-.4 1-1V4h1V3H2zm2 11V4h8v10H4zM6 1h4v1H6z"}),props.children);});var Undo16=/*#__PURE__*/React.forwardRef(function Undo16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M12 8c1.2 0 2 .8 2 2s-.8 2-2 2H9v1h3c1.7 0 3-1.2 3-3 0-1.7-1.3-3-3-3H2.9l2-2-.7-.7L1 7.5l3.2 3.2.7-.7-2-2H12z"}),props.children);});var Unlocked16=/*#__PURE__*/React.forwardRef(function Unlocked16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M12 7H6V4c0-1.1.9-2 2-2s2 .9 2 2h1c0-1.7-1.3-3-3-3S5 2.3 5 4v3H4c-.6 0-1 .4-1 1v6c0 .6.4 1 1 1h8c.6 0 1-.4 1-1V8c0-.6-.4-1-1-1zm0 7H4V8h8v6z"}),props.children);});var UpToTop16=/*#__PURE__*/React.forwardRef(function UpToTop16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8 6l-5 5 .7.7L8 7.4l4.3 4.3.7-.7zM2 3h12v1H2z"}),props.children);});var Upload16=/*#__PURE__*/React.forwardRef(function Upload16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M3 9l.7.7 3.8-3.8V15h1V5.9l3.8 3.8.7-.7-5-5zm0-5V2h10v2h1V2c0-.6-.4-1-1-1H3c-.6 0-1 .4-1 1v2h1z"}),props.children);});var UserAvatar16=/*#__PURE__*/React.forwardRef(function UserAvatar16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8 1C4.1 1 1 4.1 1 8s3.1 7 7 7 7-3.1 7-7-3.1-7-7-7zM5 13.2v-1.5c0-.9.6-1.6 1.5-1.7h3c.9.1 1.5.8 1.5 1.7v1.5c-1.9 1.1-4.1 1.1-6 0zm7-1.2v-.8c0-.9-1.1-2.1-2.5-2.2h-3C5.1 9.1 4 10.3 4 11.7v.8c-2.5-2.2-2.7-6-.5-8.5s6-2.7 8.5-.5 2.7 6 .5 8.5c-.1.2-.3.3-.5.5V12z"}),React.createElement("path",{d:"M8 3C6.6 3 5.5 4.1 5.5 5.5S6.6 8 8 8s2.5-1.1 2.5-2.5S9.4 3 8 3zm0 4c-.8 0-1.5-.7-1.5-1.5S7.2 4 8 4s1.5.7 1.5 1.5S8.8 7 8 7z"}),props.children);});var User16=/*#__PURE__*/React.forwardRef(function User16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8 2c1.4 0 2.5 1.1 2.5 2.5S9.4 7 8 7 5.5 5.9 5.5 4.5 6.6 2 8 2m0-1C6.1 1 4.5 2.6 4.5 4.5S6.1 8 8 8s3.5-1.6 3.5-3.5S9.9 1 8 1zm5 14h-1v-2.5c0-1.4-1.1-2.5-2.5-2.5h-3C5.1 10 4 11.1 4 12.5V15H3v-2.5C3 10.6 4.6 9 6.5 9h3c1.9 0 3.5 1.6 3.5 3.5V15z"}),props.children);});var ViewOff16=/*#__PURE__*/React.forwardRef(function ViewOff16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M2.6 11.3l.7-.7C2.6 9.8 1.9 9 1.5 8c1-2.5 3.8-4.5 6.5-4.5.7 0 1.4.1 2 .4l.8-.8C9.9 2.7 9 2.5 8 2.5 4.7 2.6 1.7 4.7.5 7.8v.3c.5 1.2 1.2 2.3 2.1 3.2z"}),React.createElement("path",{d:"M6 7.9c.1-1 .9-1.8 1.8-1.8l.9-.9c-1.5-.5-3.2.4-3.6 2-.1.5-.1 1.1 0 1.6l.9-.9zm9.5-.1c-.6-1.5-1.6-2.8-2.9-3.7L15 1.7l-.7-.7L1 14.3l.7.7 2.6-2.6c1.1.7 2.4 1 3.7 1.1 3.3-.1 6.3-2.2 7.5-5.3v-.4zM10 8c0 1.1-.9 2-2 2-.3 0-.7-.1-1-.3L9.7 7c.2.3.3.6.3 1zm-2 4.5c-1 0-2.1-.3-3-.8l1.3-1.3c1.4.9 3.2.6 4.2-.8.7-1 .7-2.4 0-3.4l1.4-1.4c1.1.8 2 1.9 2.6 3.2-1.1 2.5-3.9 4.5-6.5 4.5z"}),props.children);});var View16=/*#__PURE__*/React.forwardRef(function View16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M15.5 7.8C14.3 4.7 11.3 2.6 8 2.5 4.7 2.6 1.7 4.7.5 7.8v.3c1.2 3.1 4.1 5.2 7.5 5.3 3.3-.1 6.3-2.2 7.5-5.3v-.3zM8 12.5c-2.7 0-5.4-2-6.5-4.5 1-2.5 3.8-4.5 6.5-4.5s5.4 2 6.5 4.5c-1.1 2.5-3.9 4.5-6.5 4.5z"}),React.createElement("path",{d:"M8 5C6.3 5 5 6.3 5 8s1.3 3 3 3 3-1.3 3-3-1.3-3-3-3zm0 5c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2z"}),props.children);});var WarningAltFilled16=/*#__PURE__*/React.forwardRef(function WarningAltFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M14.9 13.3l-6.5-12c-.1-.3-.4-.4-.6-.2-.1 0-.2.1-.2.2l-6.5 12c-.1.2-.1.3 0 .5.1.1.2.2.4.2h13c.2 0 .3-.1.4-.2.1-.2.1-.4 0-.5zM7.4 5.5h1.1v4H7.4v-4zm.6 6.7c-.4 0-.8-.3-.8-.8s.3-.8.8-.8c.4 0 .8.3.8.8s-.4.8-.8.8z"}),props.children);});var WarningAlt16=/*#__PURE__*/React.forwardRef(function WarningAlt16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M14.5 14h-13c-.2 0-.3-.1-.4-.2-.1-.2-.1-.3 0-.5l6.5-12c.1-.3.4-.4.6-.2.1 0 .2.1.2.2l6.5 12c.1.2.1.3 0 .5 0 .1-.2.2-.4.2zM2.3 13h11.3L8 2.5 2.3 13z"}),React.createElement("path",{d:"M7.5 6h1v3.5h-1zm.5 4.8c-.4 0-.8.3-.8.8s.3.8.8.8c.4 0 .8-.3.8-.8s-.4-.8-.8-.8z"}),props.children);});var WarningFilled16=/*#__PURE__*/React.forwardRef(function WarningFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8 1C4.2 1 1 4.2 1 8s3.2 7 7 7 7-3.1 7-7-3.1-7-7-7zm-.5 3h1v5h-1V4zm.5 8.2c-.4 0-.8-.4-.8-.8s.3-.8.8-.8c.4 0 .8.4.8.8s-.4.8-.8.8z"}),React.createElement("path",{d:"M7.5 4h1v5h-1V4zm.5 8.2c-.4 0-.8-.4-.8-.8s.3-.8.8-.8c.4 0 .8.4.8.8s-.4.8-.8.8z","data-icon-path":"inner-path",opacity:"0"}),props.children);});var Warning16=/*#__PURE__*/React.forwardRef(function Warning16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8 1C4.1 1 1 4.1 1 8s3.1 7 7 7 7-3.1 7-7-3.1-7-7-7zm0 13c-3.3 0-6-2.7-6-6s2.7-6 6-6 6 2.7 6 6-2.7 6-6 6z"}),React.createElement("path",{d:"M7.5 4h1v5h-1zm.5 6.2c-.4 0-.8.3-.8.8s.3.8.8.8c.4 0 .8-.3.8-.8s-.4-.8-.8-.8z"}),props.children);});var ZoomIn16=/*#__PURE__*/React.forwardRef(function ZoomIn16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M9 6H7V4H6v2H4v1h2v2h1V7h2z"}),React.createElement("path",{d:"M10.7 10c.8-1 1.3-2.2 1.3-3.5C12 3.5 9.5 1 6.5 1S1 3.5 1 6.5 3.5 12 6.5 12c1.3 0 2.5-.5 3.5-1.3l3.8 3.8.7-.7-3.8-3.8zm-4.2 1C4 11 2 9 2 6.5S4 2 6.5 2 11 4 11 6.5 9 11 6.5 11z"}),props.children);});var ZoomOut16=/*#__PURE__*/React.forwardRef(function ZoomOut16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M4 6h5v1H4z"}),React.createElement("path",{d:"M10.7 10c.8-1 1.3-2.2 1.3-3.5C12 3.5 9.5 1 6.5 1S1 3.5 1 6.5 3.5 12 6.5 12c1.3 0 2.5-.5 3.5-1.3l3.8 3.8.7-.7-3.8-3.8zm-4.2 1C4 11 2 9 2 6.5S4 2 6.5 2 11 4 11 6.5 9 11 6.5 11z"}),props.children);});var AppSwitcher20=/*#__PURE__*/React.forwardRef(function AppSwitcher20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 20 20",ref:ref},props),React.createElement("path",{d:"M15.5 15.5H18V18h-2.5zm-6.75 0h2.5V18h-2.5zM2 15.5h2.5V18H2zm13.5-6.75H18v2.5h-2.5zm-6.75 0h2.5v2.5h-2.5zM2 8.75h2.5v2.5H2zM15.5 2H18v2.5h-2.5zM8.75 2h2.5v2.5h-2.5zM2 2h2.5v2.5H2z"}),props.children);});var ArrowRight20=/*#__PURE__*/React.forwardRef(function ArrowRight20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 20 20",ref:ref},props),React.createElement("path",{d:"M11.8 2.8l-1 1 5.4 5.5H1v1.4h15.2l-5.4 5.5 1 1L19 10z"}),props.children);});var CheckmarkFilled20=/*#__PURE__*/React.forwardRef(function CheckmarkFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 20 20",ref:ref},props),React.createElement("path",{d:"M10 1c-4.9 0-9 4.1-9 9s4.1 9 9 9 9-4 9-9-4-9-9-9zM8.7 13.5l-3.2-3.2 1-1 2.2 2.2 4.8-4.8 1 1-5.8 5.8z"}),React.createElement("path",{d:"M8.7 13.5l-3.2-3.2 1-1 2.2 2.2 4.8-4.8 1 1-5.8 5.8z","data-icon-path":"inner-path",opacity:"0"}),props.children);});var Checkmark20=/*#__PURE__*/React.forwardRef(function Checkmark20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 20 20",ref:ref},props),React.createElement("path",{d:"M8 13.2L3.6 8.8l-.9.9 4.4 4.4.9.9 8.5-8.5-.9-.9z"}),React.createElement("path",{d:"M15.6 5.6L8 13.2 3.6 8.8l-.9.9 4.4 4.4.9.9 8.5-8.5-.9-.9z"}),props.children);});var ErrorFilled20=/*#__PURE__*/React.forwardRef(function ErrorFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 20 20",ref:ref},props),React.createElement("path",{d:"M10 1c-5 0-9 4-9 9s4 9 9 9 9-4 9-9-4-9-9-9zm3.5 13.5l-8-8 1-1 8 8-1 1z"}),React.createElement("path",{d:"M13.5 14.5l-8-8 1-1 8 8-1 1z","data-icon-path":"inner-path",opacity:"0"}),props.children);});var Menu20=/*#__PURE__*/React.forwardRef(function Menu20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 20 20",ref:ref},props),React.createElement("path",{d:"M2 14.8h16V16H2zm0-3.6h16v1.2H2zm0-3.6h16v1.2H2zM2 4h16v1.2H2z"}),props.children);});var Misuse20=/*#__PURE__*/React.forwardRef(function Misuse20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 20 20",ref:ref},props),React.createElement("path",{d:"M10 1c-4.9 0-9 4.1-9 9s4.1 9 9 9 9-4 9-9-4-9-9-9zm3.5 13.5L10 11l-3.5 3.5-1-1L9 10 5.5 6.5l1-1L10 9l3.5-3.5 1 1L11 10l3.5 3.5-1 1z"}),React.createElement("path",{d:"M13.5 14.5L10 11l-3.5 3.5-1-1L9 10 5.5 6.5l1-1L10 9l3.5-3.5 1 1L11 10l3.5 3.5-1 1z","data-icon-path":"inner-path",opacity:"0"}),props.children);});var Redo20=/*#__PURE__*/React.forwardRef(function Redo20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 20 20",ref:ref},props),React.createElement("path",{d:"M5 9.3c-1.5 0-2.8 1.3-2.8 2.7 0 1.5 1.3 2.7 2.8 2.7h4V16H5c-2.3 0-4-1.7-4-4 0-2.2 1.8-4 4-4h11.6l-2.5-2.5.9-.9 4 4-4 4-.9-.9 2.5-2.5H5z"}),props.children);});var Save20=/*#__PURE__*/React.forwardRef(function Save20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 20 20",ref:ref},props),React.createElement("path",{d:"M17.8 5.5l-3.3-3.3c-.2-.1-.3-.2-.5-.2H3.3C2.6 2 2 2.6 2 3.3v13.3c0 .8.6 1.4 1.3 1.4h13.3c.7 0 1.4-.5 1.4-1.2V6.1c0-.4-.1-.4-.2-.6zM7.3 3.3h5.3v3.3H7.3V3.3zm5.4 13.4H7.3v-5.3h5.3l.1 5.3zm1.3 0v-5.3c0-.7-.6-1.3-1.3-1.3H7.3c-.7-.1-1.3.5-1.3 1.2v5.3H3.3V3.3H6v3.3C6 7.4 6.6 8 7.3 8h5.3c.8 0 1.4-.6 1.4-1.3v-3l2.7 2.7v10.4l-2.7-.1z"}),props.children);});var Switcher20=/*#__PURE__*/React.forwardRef(function Switcher20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 20 20",ref:ref},props),React.createElement("path",{d:"M15.5 15.5H18V18h-2.5zm-6.75 0h2.5V18h-2.5zM2 15.5h2.5V18H2zm13.5-6.75H18v2.5h-2.5zm-6.75 0h2.5v2.5h-2.5zM2 8.75h2.5v2.5H2zM15.5 2H18v2.5h-2.5zM8.75 2h2.5v2.5h-2.5zM2 2h2.5v2.5H2z"}),props.children);});var Time20=/*#__PURE__*/React.forwardRef(function Time20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 20 20",ref:ref},props),React.createElement("path",{d:"M10 19c-5 0-9-4-9-9s4-9 9-9 9 4 9 9-4 9-9 9zm0-16.7c-4.3 0-7.7 3.5-7.7 7.7s3.5 7.7 7.7 7.7 7.7-3.5 7.7-7.7-3.4-7.7-7.7-7.7z"}),React.createElement("path",{d:"M13 13.9l-3.6-3.6V4h1.2v5.7l3.3 3.3z"}),props.children);});var Undo20=/*#__PURE__*/React.forwardRef(function Undo20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 20 20",ref:ref},props),React.createElement("path",{d:"M15 9.3c1.5 0 2.8 1.3 2.8 2.7 0 1.5-1.3 2.7-2.8 2.7h-4V16h4c2.3 0 4-1.7 4-4 0-2.2-1.8-4-4-4H3.4l2.5-2.5-.9-.9-4 4 4 4 .9-.9-2.5-2.4H15z"}),props.children);});var WarningFilled20=/*#__PURE__*/React.forwardRef(function WarningFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 20 20",ref:ref},props),React.createElement("path",{d:"M10 1c-5 0-9 4-9 9s4 9 9 9 9-4 9-9-4-9-9-9zm-.8 4h1.5v7H9.2V5zm.8 11c-.6 0-1-.4-1-1s.4-1 1-1 1 .4 1 1-.4 1-1 1z"}),React.createElement("path",{d:"M9.2 5h1.5v7H9.2V5zm.8 11c-.6 0-1-.4-1-1s.4-1 1-1 1 .4 1 1-.4 1-1 1z","data-icon-path":"inner-path",opacity:"0"}),props.children);});var AppSwitcher24=/*#__PURE__*/React.forwardRef(function AppSwitcher24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 24 24",ref:ref},props),React.createElement("path",{d:"M18 18h3v3h-3zm-7.5 0h3v3h-3zM3 18h3v3H3zm15-7.5h3v3h-3zm-7.5 0h3v3h-3zm-7.5 0h3v3H3zM18 3h3v3h-3zm-7.5 0h3v3h-3zM3 3h3v3H3z"}),props.children);});var ArrowRight24=/*#__PURE__*/React.forwardRef(function ArrowRight24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 24 24",ref:ref},props),React.createElement("path",{d:"M14 4l-1.1 1.1 6 6.1H2v1.6h16.9l-6 6.1L14 20l8-8z"}),props.children);});var CheckmarkFilled24=/*#__PURE__*/React.forwardRef(function CheckmarkFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 24 24",ref:ref},props),React.createElement("path",{d:"M12 1C6 1 1 6 1 12s5 11 11 11 11-4.9 11-11S18.1 1 12 1zm-1.6 15.3l-3.9-3.9 1.3-1.2 2.7 2.7 5.8-5.8 1.3 1.3-7.2 6.9z"}),React.createElement("path",{d:"M10.4 16.3l-3.9-3.9 1.3-1.2 2.7 2.7 5.8-5.8 1.3 1.3-7.2 6.9z","data-icon-path":"inner-path",opacity:"0"}),props.children);});var Checkmark24=/*#__PURE__*/React.forwardRef(function Checkmark24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 24 24",ref:ref},props),React.createElement("path",{d:"M10 15.9l-5.3-5.3-1.1 1 5.3 5.3L10 18 20.6 7.4l-1.1-1.1z"}),props.children);});var ErrorFilled24=/*#__PURE__*/React.forwardRef(function ErrorFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 24 24",ref:ref},props),React.createElement("path",{d:"M12 1C5.9 1 1 5.9 1 12s4.9 11 11 11 11-4.9 11-11S18.1 1 12 1zm4.3 16.5L6.5 7.7l1.2-1.2 9.8 9.8-1.2 1.2z"}),React.createElement("path",{d:"M16.3 17.5L6.5 7.7l1.2-1.2 9.8 9.8-1.2 1.2z","data-icon-path":"inner-path",opacity:"0"}),props.children);});var Menu24=/*#__PURE__*/React.forwardRef(function Menu24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 24 24",ref:ref},props),React.createElement("path",{d:"M3 18h18v1.5H3zm0-4.5h18V15H3zM3 9h18v1.5H3zm0-4.5h18V6H3z"}),props.children);});var Misuse24=/*#__PURE__*/React.forwardRef(function Misuse24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 24 24",ref:ref},props),React.createElement("path",{d:"M12 1C6 1 1 6 1 12s5 11 11 11 11-4.9 11-11S18.1 1 12 1zm4.2 16.5L12 13.3l-4.2 4.2-1.3-1.3 4.2-4.2-4.2-4.2 1.3-1.3 4.2 4.2 4.2-4.2 1.3 1.3-4.2 4.2 4.2 4.2-1.3 1.3z"}),React.createElement("path",{d:"M16.2 17.5L12 13.3l-4.2 4.2-1.3-1.3 4.2-4.2-4.2-4.2 1.3-1.3 4.2 4.2 4.2-4.2 1.3 1.3-4.2 4.2 4.2 4.2-1.3 1.3z","data-icon-path":"inner-path",opacity:"0"}),props.children);});var Redo24=/*#__PURE__*/React.forwardRef(function Redo24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 24 24",ref:ref},props),React.createElement("path",{d:"M6.8 11.2c-1.8 0-3.2 1.7-3.2 3.3 0 1.5 1.5 3.2 3.2 3.2H10v1.5H6.8C4.6 19.2 2 17 2 14.5s2-4.8 4.8-4.8h12.4l-3-3 1.1-1.1 4.8 4.8-4.8 4.8-1.1-1.1 3-3H6.8z"}),props.children);});var Save24=/*#__PURE__*/React.forwardRef(function Save24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 24 24",ref:ref},props),React.createElement("path",{d:"M20.8 7L17 3.2c-.1-.1-.3-.2-.5-.2h-12C3.7 3 3 3.7 3 4.5v15c0 .8.7 1.5 1.5 1.5h15c.8 0 1.5-.7 1.5-1.5v-12c0-.2-.1-.4-.2-.5zM9 4.5h6v3H9v-3zm6 15H9v-6h6v6zm1.5 0v-6c0-.8-.7-1.5-1.5-1.5H9c-.8 0-1.5.7-1.5 1.5v6h-3v-15h3v3C7.5 8.3 8.2 9 9 9h6c.8 0 1.5-.7 1.5-1.5V4.8l3 3v11.7h-3z"}),props.children);});var Switcher24=/*#__PURE__*/React.forwardRef(function Switcher24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 24 24",ref:ref},props),React.createElement("path",{d:"M18 18h3v3h-3zm-7.5 0h3v3h-3zM3 18h3v3H3zm15-7.5h3v3h-3zm-7.5 0h3v3h-3zm-7.5 0h3v3H3zM18 3h3v3h-3zm-7.5 0h3v3h-3zM3 3h3v3H3z"}),props.children);});var Undo24=/*#__PURE__*/React.forwardRef(function Undo24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 24 24",ref:ref},props),React.createElement("path",{d:"M17.2 11.2c1.8 0 3.2 1.7 3.2 3.3 0 1.5-1.5 3.2-3.2 3.2H14v1.5h3.2c2.2 0 4.8-2.3 4.8-4.8s-2-4.8-4.8-4.8H4.8l3-3-1-.9L2 10.5l4.8 4.8 1.1-1.1-3-3h12.3z"}),props.children);});var WarningFilled24=/*#__PURE__*/React.forwardRef(function WarningFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 24 24",ref:ref},props),React.createElement("path",{d:"M12 1C5.9 1 1 5.9 1 12s4.9 11 11 11 11-4.9 11-11S18.1 1 12 1zm-.9 5h1.8v8h-1.8V6zm.9 13.2c-.7 0-1.2-.6-1.2-1.2s.6-1.2 1.2-1.2 1.2.6 1.2 1.2-.5 1.2-1.2 1.2z"}),React.createElement("path",{d:"M13.2 18c0 .7-.6 1.2-1.2 1.2s-1.2-.6-1.2-1.2.6-1.2 1.2-1.2 1.2.5 1.2 1.2zm-.3-12h-1.8v8h1.8V6z","data-icon-path":"inner-path",opacity:"0"}),props.children);});var _4KFilled32=/*#__PURE__*/React.forwardRef(function _4KFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 6H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zM14 21h-2v-4H8v-6h2v4h2v-4h2zm10.19 0H22l-2.09-4.06-.91 1.33V21h-2V11h2v4.39L22 11h2.19l-3 4.38z"}),props.children);});var _4KFilled24=/*#__PURE__*/React.forwardRef(function _4KFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 6H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zM14 21h-2v-4H8v-6h2v4h2v-4h2zm10.19 0H22l-2.09-4.06-.91 1.33V21h-2V11h2v4.39L22 11h2.19l-3 4.38z"}),props.children);});var _4KFilled20=/*#__PURE__*/React.forwardRef(function _4KFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 6H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zM14 21h-2v-4H8v-6h2v4h2v-4h2zm10.19 0H22l-2.09-4.06-.91 1.33V21h-2V11h2v4.39L22 11h2.19l-3 4.38z"}),props.children);});var _4KFilled16=/*#__PURE__*/React.forwardRef(function _4KFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 6H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zM14 21h-2v-4H8v-6h2v4h2v-4h2zm10.19 0H22l-2.09-4.06-.91 1.33V21h-2V11h2v4.39L22 11h2.19l-3 4.38z"}),props.children);});var _4K32=/*#__PURE__*/React.forwardRef(function _4K32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 11.03v4h-2v-4H8v6h4v4h2v-10h-2zm12.19 0H22l-3 4.39v-4.39h-2v10h2V18.3l.91-1.33L22 21.03h2.19l-2.99-5.62 2.99-4.38z"}),React.createElement("path",{d:"M28 26H4a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h24a2 2 0 0 1 2 2v16a2 2 0 0 1-2 2zM4 8v16h24V8z"}),props.children);});var _4K24=/*#__PURE__*/React.forwardRef(function _4K24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 11.03v4h-2v-4H8v6h4v4h2v-10h-2zm12.19 0H22l-3 4.39v-4.39h-2v10h2V18.3l.91-1.33L22 21.03h2.19l-2.99-5.62 2.99-4.38z"}),React.createElement("path",{d:"M28 26H4a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h24a2 2 0 0 1 2 2v16a2 2 0 0 1-2 2zM4 8v16h24V8z"}),props.children);});var _4K20=/*#__PURE__*/React.forwardRef(function _4K20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 11.03v4h-2v-4H8v6h4v4h2v-10h-2zm12.19 0H22l-3 4.39v-4.39h-2v10h2V18.3l.91-1.33L22 21.03h2.19l-2.99-5.62 2.99-4.38z"}),React.createElement("path",{d:"M28 26H4a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h24a2 2 0 0 1 2 2v16a2 2 0 0 1-2 2zM4 8v16h24V8z"}),props.children);});var _4K16=/*#__PURE__*/React.forwardRef(function _4K16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 11.03v4h-2v-4H8v6h4v4h2v-10h-2zm12.19 0H22l-3 4.39v-4.39h-2v10h2V18.3l.91-1.33L22 21.03h2.19l-2.99-5.62 2.99-4.38z"}),React.createElement("path",{d:"M28 26H4a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h24a2 2 0 0 1 2 2v16a2 2 0 0 1-2 2zM4 8v16h24V8z"}),props.children);});var Api_132=/*#__PURE__*/React.forwardRef(function Api_132(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8 9H4a2 2 0 0 0-2 2v12h2v-5h4v5h2V11a2 2 0 0 0-2-2zm-4 7v-5h4v5zm18-5h3v10h-3v2h8v-2h-3V11h3V9h-8v2zm-8 12h-2V9h6a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2h-4zm0-7h4v-5h-4z"}),props.children);});var Api_124=/*#__PURE__*/React.forwardRef(function Api_124(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8 9H4a2 2 0 0 0-2 2v12h2v-5h4v5h2V11a2 2 0 0 0-2-2zm-4 7v-5h4v5zm18-5h3v10h-3v2h8v-2h-3V11h3V9h-8v2zm-8 12h-2V9h6a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2h-4zm0-7h4v-5h-4z"}),props.children);});var Api_120=/*#__PURE__*/React.forwardRef(function Api_120(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8 9H4a2 2 0 0 0-2 2v12h2v-5h4v5h2V11a2 2 0 0 0-2-2zm-4 7v-5h4v5zm18-5h3v10h-3v2h8v-2h-3V11h3V9h-8v2zm-8 12h-2V9h6a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2h-4zm0-7h4v-5h-4z"}),props.children);});var Api_116=/*#__PURE__*/React.forwardRef(function Api_116(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8 9H4a2 2 0 0 0-2 2v12h2v-5h4v5h2V11a2 2 0 0 0-2-2zm-4 7v-5h4v5zm18-5h3v10h-3v2h8v-2h-3V11h3V9h-8v2zm-8 12h-2V9h6a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2h-4zm0-7h4v-5h-4z"}),props.children);});var Cad32=/*#__PURE__*/React.forwardRef(function Cad32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 9h-4a2 2 0 0 0-2 2v12h2v-5h4v5h2V11a2 2 0 0 0-2-2zm-4 7v-5h4v5zm12 7h-4V9h4a4 4 0 0 1 4 4v6a4 4 0 0 1-4 4zm-2-2h2a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2h-2zm-14 2H4a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h6v2H4v10h6z"}),props.children);});var Cad24=/*#__PURE__*/React.forwardRef(function Cad24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 9h-4a2 2 0 0 0-2 2v12h2v-5h4v5h2V11a2 2 0 0 0-2-2zm-4 7v-5h4v5zm12 7h-4V9h4a4 4 0 0 1 4 4v6a4 4 0 0 1-4 4zm-2-2h2a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2h-2zm-14 2H4a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h6v2H4v10h6z"}),props.children);});var Cad20=/*#__PURE__*/React.forwardRef(function Cad20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 9h-4a2 2 0 0 0-2 2v12h2v-5h4v5h2V11a2 2 0 0 0-2-2zm-4 7v-5h4v5zm12 7h-4V9h4a4 4 0 0 1 4 4v6a4 4 0 0 1-4 4zm-2-2h2a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2h-2zm-14 2H4a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h6v2H4v10h6z"}),props.children);});var Cad16=/*#__PURE__*/React.forwardRef(function Cad16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 9h-4a2 2 0 0 0-2 2v12h2v-5h4v5h2V11a2 2 0 0 0-2-2zm-4 7v-5h4v5zm12 7h-4V9h4a4 4 0 0 1 4 4v6a4 4 0 0 1-4 4zm-2-2h2a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2h-2zm-14 2H4a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h6v2H4v10h6z"}),props.children);});var Csv32=/*#__PURE__*/React.forwardRef(function Csv32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 9l-2 13-2-13h-2l2.516 14h2.968L30 9h-2zM18 23h-6v-2h6v-4h-4a2.002 2.002 0 0 1-2-2v-4a2.002 2.002 0 0 1 2-2h6v2h-6v4h4a2.002 2.002 0 0 1 2 2v4a2.002 2.002 0 0 1-2 2zm-8 0H4a2.002 2.002 0 0 1-2-2V11a2.002 2.002 0 0 1 2-2h6v2H4v10h6z"}),props.children);});var Csv24=/*#__PURE__*/React.forwardRef(function Csv24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 9l-2 13-2-13h-2l2.516 14h2.968L30 9h-2zM18 23h-6v-2h6v-4h-4a2.002 2.002 0 0 1-2-2v-4a2.002 2.002 0 0 1 2-2h6v2h-6v4h4a2.002 2.002 0 0 1 2 2v4a2.002 2.002 0 0 1-2 2zm-8 0H4a2.002 2.002 0 0 1-2-2V11a2.002 2.002 0 0 1 2-2h6v2H4v10h6z"}),props.children);});var Csv20=/*#__PURE__*/React.forwardRef(function Csv20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 9l-2 13-2-13h-2l2.516 14h2.968L30 9h-2zM18 23h-6v-2h6v-4h-4a2.002 2.002 0 0 1-2-2v-4a2.002 2.002 0 0 1 2-2h6v2h-6v4h4a2.002 2.002 0 0 1 2 2v4a2.002 2.002 0 0 1-2 2zm-8 0H4a2.002 2.002 0 0 1-2-2V11a2.002 2.002 0 0 1 2-2h6v2H4v10h6z"}),props.children);});var Csv16=/*#__PURE__*/React.forwardRef(function Csv16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 9l-2 13-2-13h-2l2.516 14h2.968L30 9h-2zM18 23h-6v-2h6v-4h-4a2.002 2.002 0 0 1-2-2v-4a2.002 2.002 0 0 1 2-2h6v2h-6v4h4a2.002 2.002 0 0 1 2 2v4a2.002 2.002 0 0 1-2 2zm-8 0H4a2.002 2.002 0 0 1-2-2V11a2.002 2.002 0 0 1 2-2h6v2H4v10h6z"}),props.children);});var Dvr32=/*#__PURE__*/React.forwardRef(function Dvr32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 15v-4a2 2 0 0 0-2-2h-6v14h2v-6h1.48l2.34 6H30l-2.33-6H28a2 2 0 0 0 2-2zm-6-4h4v4h-4zm-6-2l-2 13-2-13h-2l2.52 14h2.96L20 9h-2zM6 23H2V9h4a4 4 0 0 1 4 4v6a4 4 0 0 1-4 4zm-2-2h2a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2H4z"}),props.children);});var Dvr24=/*#__PURE__*/React.forwardRef(function Dvr24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 15v-4a2 2 0 0 0-2-2h-6v14h2v-6h1.48l2.34 6H30l-2.33-6H28a2 2 0 0 0 2-2zm-6-4h4v4h-4zm-6-2l-2 13-2-13h-2l2.52 14h2.96L20 9h-2zM6 23H2V9h4a4 4 0 0 1 4 4v6a4 4 0 0 1-4 4zm-2-2h2a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2H4z"}),props.children);});var Dvr20=/*#__PURE__*/React.forwardRef(function Dvr20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 15v-4a2 2 0 0 0-2-2h-6v14h2v-6h1.48l2.34 6H30l-2.33-6H28a2 2 0 0 0 2-2zm-6-4h4v4h-4zm-6-2l-2 13-2-13h-2l2.52 14h2.96L20 9h-2zM6 23H2V9h4a4 4 0 0 1 4 4v6a4 4 0 0 1-4 4zm-2-2h2a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2H4z"}),props.children);});var Dvr16=/*#__PURE__*/React.forwardRef(function Dvr16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 15v-4a2 2 0 0 0-2-2h-6v14h2v-6h1.48l2.34 6H30l-2.33-6H28a2 2 0 0 0 2-2zm-6-4h4v4h-4zm-6-2l-2 13-2-13h-2l2.52 14h2.96L20 9h-2zM6 23H2V9h4a4 4 0 0 1 4 4v6a4 4 0 0 1-4 4zm-2-2h2a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2H4z"}),props.children);});var Gif32=/*#__PURE__*/React.forwardRef(function Gif32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2 12v8a3 3 0 0 0 3 3h5v-8H6v2h2v4H5a1 1 0 0 1-1-1v-8a1 1 0 0 1 1-1h5V9H5a3 3 0 0 0-3 3zm28-1V9h-8v14h2v-6h5v-2h-5v-4h6zM12 9v2h3v10h-3v2h8v-2h-3V11h3V9h-8z"}),props.children);});var Gif24=/*#__PURE__*/React.forwardRef(function Gif24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2 12v8a3 3 0 0 0 3 3h5v-8H6v2h2v4H5a1 1 0 0 1-1-1v-8a1 1 0 0 1 1-1h5V9H5a3 3 0 0 0-3 3zm28-1V9h-8v14h2v-6h5v-2h-5v-4h6zM12 9v2h3v10h-3v2h8v-2h-3V11h3V9h-8z"}),props.children);});var Gif20=/*#__PURE__*/React.forwardRef(function Gif20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2 12v8a3 3 0 0 0 3 3h5v-8H6v2h2v4H5a1 1 0 0 1-1-1v-8a1 1 0 0 1 1-1h5V9H5a3 3 0 0 0-3 3zm28-1V9h-8v14h2v-6h5v-2h-5v-4h6zM12 9v2h3v10h-3v2h8v-2h-3V11h3V9h-8z"}),props.children);});var Gif16=/*#__PURE__*/React.forwardRef(function Gif16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2 12v8a3 3 0 0 0 3 3h5v-8H6v2h2v4H5a1 1 0 0 1-1-1v-8a1 1 0 0 1 1-1h5V9H5a3 3 0 0 0-3 3zm28-1V9h-8v14h2v-6h5v-2h-5v-4h6zM12 9v2h3v10h-3v2h8v-2h-3V11h3V9h-8z"}),props.children);});var HdFilled32=/*#__PURE__*/React.forwardRef(function HdFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22 13h-2v6h2a1 1 0 0 0 1-1v-4a1 1 0 0 0-1-1z"}),React.createElement("path",{d:"M28 6H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zM15 21h-2v-4h-3v4H8V11h2v4h3v-4h2zm10-3a3 3 0 0 1-3 3h-4V11h4a3 3 0 0 1 3 3z"}),props.children);});var HdFilled24=/*#__PURE__*/React.forwardRef(function HdFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22 13h-2v6h2a1 1 0 0 0 1-1v-4a1 1 0 0 0-1-1z"}),React.createElement("path",{d:"M28 6H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zM15 21h-2v-4h-3v4H8V11h2v4h3v-4h2zm10-3a3 3 0 0 1-3 3h-4V11h4a3 3 0 0 1 3 3z"}),props.children);});var HdFilled20=/*#__PURE__*/React.forwardRef(function HdFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22 13h-2v6h2a1 1 0 0 0 1-1v-4a1 1 0 0 0-1-1z"}),React.createElement("path",{d:"M28 6H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zM15 21h-2v-4h-3v4H8V11h2v4h3v-4h2zm10-3a3 3 0 0 1-3 3h-4V11h4a3 3 0 0 1 3 3z"}),props.children);});var HdFilled16=/*#__PURE__*/React.forwardRef(function HdFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22 13h-2v6h2a1 1 0 0 0 1-1v-4a1 1 0 0 0-1-1z"}),React.createElement("path",{d:"M28 6H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zM15 21h-2v-4h-3v4H8V11h2v4h3v-4h2zm10-3a3 3 0 0 1-3 3h-4V11h4a3 3 0 0 1 3 3z"}),props.children);});var Hd32=/*#__PURE__*/React.forwardRef(function Hd32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 6H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zM4 24V8h24v16z"}),React.createElement("path",{d:"M22 11h-4v10h4a3 3 0 0 0 3-3v-4a3 3 0 0 0-3-3zm1 7a1 1 0 0 1-1 1h-2v-6h2a1 1 0 0 1 1 1zm-10-7v4h-3v-4H8v10h2v-4h3v4h2V11h-2z"}),props.children);});var Hd24=/*#__PURE__*/React.forwardRef(function Hd24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 6H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zM4 24V8h24v16z"}),React.createElement("path",{d:"M22 11h-4v10h4a3 3 0 0 0 3-3v-4a3 3 0 0 0-3-3zm1 7a1 1 0 0 1-1 1h-2v-6h2a1 1 0 0 1 1 1zm-10-7v4h-3v-4H8v10h2v-4h3v4h2V11h-2z"}),props.children);});var Hd20=/*#__PURE__*/React.forwardRef(function Hd20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 6H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zM4 24V8h24v16z"}),React.createElement("path",{d:"M22 11h-4v10h4a3 3 0 0 0 3-3v-4a3 3 0 0 0-3-3zm1 7a1 1 0 0 1-1 1h-2v-6h2a1 1 0 0 1 1 1zm-10-7v4h-3v-4H8v10h2v-4h3v4h2V11h-2z"}),props.children);});var Hd16=/*#__PURE__*/React.forwardRef(function Hd16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 6H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zM4 24V8h24v16z"}),React.createElement("path",{d:"M22 11h-4v10h4a3 3 0 0 0 3-3v-4a3 3 0 0 0-3-3zm1 7a1 1 0 0 1-1 1h-2v-6h2a1 1 0 0 1 1 1zm-10-7v4h-3v-4H8v10h2v-4h3v4h2V11h-2z"}),props.children);});var Hdr32=/*#__PURE__*/React.forwardRef(function Hdr32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 15v-4a2 2 0 0 0-2-2h-6v14h2v-6h1.48l2.34 6H30l-2.33-6H28a2 2 0 0 0 2-2zm-6-4h4v4h-4zm-8 12h-4V9h4a4 4 0 0 1 4 4v6a4 4 0 0 1-4 4zm-2-2h2a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2h-2zM8 9v6H4V9H2v14h2v-6h4v6h2V9H8z"}),props.children);});var Hdr24=/*#__PURE__*/React.forwardRef(function Hdr24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 15v-4a2 2 0 0 0-2-2h-6v14h2v-6h1.48l2.34 6H30l-2.33-6H28a2 2 0 0 0 2-2zm-6-4h4v4h-4zm-8 12h-4V9h4a4 4 0 0 1 4 4v6a4 4 0 0 1-4 4zm-2-2h2a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2h-2zM8 9v6H4V9H2v14h2v-6h4v6h2V9H8z"}),props.children);});var Hdr20=/*#__PURE__*/React.forwardRef(function Hdr20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 15v-4a2 2 0 0 0-2-2h-6v14h2v-6h1.48l2.34 6H30l-2.33-6H28a2 2 0 0 0 2-2zm-6-4h4v4h-4zm-8 12h-4V9h4a4 4 0 0 1 4 4v6a4 4 0 0 1-4 4zm-2-2h2a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2h-2zM8 9v6H4V9H2v14h2v-6h4v6h2V9H8z"}),props.children);});var Hdr16=/*#__PURE__*/React.forwardRef(function Hdr16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 15v-4a2 2 0 0 0-2-2h-6v14h2v-6h1.48l2.34 6H30l-2.33-6H28a2 2 0 0 0 2-2zm-6-4h4v4h-4zm-8 12h-4V9h4a4 4 0 0 1 4 4v6a4 4 0 0 1-4 4zm-2-2h2a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2h-2zM8 9v6H4V9H2v14h2v-6h4v6h2V9H8z"}),props.children);});var Http32=/*#__PURE__*/React.forwardRef(function Http32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 11h-5v10h2v-3h3a2.003 2.003 0 0 0 2-2v-3a2.002 2.002 0 0 0-2-2zm-3 5v-3h3l.001 3zm-17-3h2v8h2v-8h2v-2h-6v2zm13-2h-6v2h2v8h2v-8h2v-2zM6 11v4H3v-4H1v10h2v-4h3v4h2V11H6z"}),props.children);});var Http24=/*#__PURE__*/React.forwardRef(function Http24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 11h-5v10h2v-3h3a2.003 2.003 0 0 0 2-2v-3a2.002 2.002 0 0 0-2-2zm-3 5v-3h3l.001 3zm-17-3h2v8h2v-8h2v-2h-6v2zm13-2h-6v2h2v8h2v-8h2v-2zM6 11v4H3v-4H1v10h2v-4h3v4h2V11H6z"}),props.children);});var Http20=/*#__PURE__*/React.forwardRef(function Http20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 11h-5v10h2v-3h3a2.003 2.003 0 0 0 2-2v-3a2.002 2.002 0 0 0-2-2zm-3 5v-3h3l.001 3zm-17-3h2v8h2v-8h2v-2h-6v2zm13-2h-6v2h2v8h2v-8h2v-2zM6 11v4H3v-4H1v10h2v-4h3v4h2V11H6z"}),props.children);});var Http16=/*#__PURE__*/React.forwardRef(function Http16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 11h-5v10h2v-3h3a2.003 2.003 0 0 0 2-2v-3a2.002 2.002 0 0 0-2-2zm-3 5v-3h3l.001 3zm-17-3h2v8h2v-8h2v-2h-6v2zm13-2h-6v2h2v8h2v-8h2v-2zM6 11v4H3v-4H1v10h2v-4h3v4h2V11H6z"}),props.children);});var IsoFilled32=/*#__PURE__*/React.forwardRef(function IsoFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21 13h3v6h-3z"}),React.createElement("path",{d:"M28 6H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zM8 21H6V11h2zm9-8h-5v2h3a2 2 0 0 1 2 2v2a2 2 0 0 1-2 2h-5v-2h5v-2h-3a2 2 0 0 1-2-2v-2a2 2 0 0 1 2-2h5zm9 6a2 2 0 0 1-2 2h-3a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h3a2 2 0 0 1 2 2z"}),props.children);});var IsoFilled24=/*#__PURE__*/React.forwardRef(function IsoFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21 13h3v6h-3z"}),React.createElement("path",{d:"M28 6H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zM8 21H6V11h2zm9-8h-5v2h3a2 2 0 0 1 2 2v2a2 2 0 0 1-2 2h-5v-2h5v-2h-3a2 2 0 0 1-2-2v-2a2 2 0 0 1 2-2h5zm9 6a2 2 0 0 1-2 2h-3a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h3a2 2 0 0 1 2 2z"}),props.children);});var IsoFilled20=/*#__PURE__*/React.forwardRef(function IsoFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21 13h3v6h-3z"}),React.createElement("path",{d:"M28 6H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zM8 21H6V11h2zm9-8h-5v2h3a2 2 0 0 1 2 2v2a2 2 0 0 1-2 2h-5v-2h5v-2h-3a2 2 0 0 1-2-2v-2a2 2 0 0 1 2-2h5zm9 6a2 2 0 0 1-2 2h-3a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h3a2 2 0 0 1 2 2z"}),props.children);});var IsoFilled16=/*#__PURE__*/React.forwardRef(function IsoFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21 13h3v6h-3z"}),React.createElement("path",{d:"M28 6H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zM8 21H6V11h2zm9-8h-5v2h3a2 2 0 0 1 2 2v2a2 2 0 0 1-2 2h-5v-2h5v-2h-3a2 2 0 0 1-2-2v-2a2 2 0 0 1 2-2h5zm9 6a2 2 0 0 1-2 2h-3a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h3a2 2 0 0 1 2 2z"}),props.children);});var IsoOutline32=/*#__PURE__*/React.forwardRef(function IsoOutline32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 21h-3a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h3a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2zm-3-8v6h3v-6zm-6 8h-5v-2h5v-2h-3a2 2 0 0 1-2-2v-2a2 2 0 0 1 2-2h5v2h-5v2h3a2 2 0 0 1 2 2v2a2 2 0 0 1-2 2zM6 11h2v10H6z"}),React.createElement("path",{d:"M28 6H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zM4 24V8h24v16z"}),props.children);});var IsoOutline24=/*#__PURE__*/React.forwardRef(function IsoOutline24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 21h-3a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h3a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2zm-3-8v6h3v-6zm-6 8h-5v-2h5v-2h-3a2 2 0 0 1-2-2v-2a2 2 0 0 1 2-2h5v2h-5v2h3a2 2 0 0 1 2 2v2a2 2 0 0 1-2 2zM6 11h2v10H6z"}),React.createElement("path",{d:"M28 6H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zM4 24V8h24v16z"}),props.children);});var IsoOutline20=/*#__PURE__*/React.forwardRef(function IsoOutline20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 21h-3a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h3a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2zm-3-8v6h3v-6zm-6 8h-5v-2h5v-2h-3a2 2 0 0 1-2-2v-2a2 2 0 0 1 2-2h5v2h-5v2h3a2 2 0 0 1 2 2v2a2 2 0 0 1-2 2zM6 11h2v10H6z"}),React.createElement("path",{d:"M28 6H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zM4 24V8h24v16z"}),props.children);});var IsoOutline16=/*#__PURE__*/React.forwardRef(function IsoOutline16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 21h-3a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h3a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2zm-3-8v6h3v-6zm-6 8h-5v-2h5v-2h-3a2 2 0 0 1-2-2v-2a2 2 0 0 1 2-2h5v2h-5v2h3a2 2 0 0 1 2 2v2a2 2 0 0 1-2 2zM6 11h2v10H6z"}),React.createElement("path",{d:"M28 6H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zM4 24V8h24v16z"}),props.children);});var Iso32=/*#__PURE__*/React.forwardRef(function Iso32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 23h-4a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v10a2 2 0 0 1-2 2zm-4-12v10h4V11zm-6 12h-6v-2h6v-4h-4a2 2 0 0 1-2-2v-4a2 2 0 0 1 2-2h6v2h-6v4h4a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2zM2 11h3v10H2v2h8v-2H7V11h3V9H2v2z"}),props.children);});var Iso24=/*#__PURE__*/React.forwardRef(function Iso24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 23h-4a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v10a2 2 0 0 1-2 2zm-4-12v10h4V11zm-6 12h-6v-2h6v-4h-4a2 2 0 0 1-2-2v-4a2 2 0 0 1 2-2h6v2h-6v4h4a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2zM2 11h3v10H2v2h8v-2H7V11h3V9H2v2z"}),props.children);});var Iso20=/*#__PURE__*/React.forwardRef(function Iso20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 23h-4a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v10a2 2 0 0 1-2 2zm-4-12v10h4V11zm-6 12h-6v-2h6v-4h-4a2 2 0 0 1-2-2v-4a2 2 0 0 1 2-2h6v2h-6v4h4a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2zM2 11h3v10H2v2h8v-2H7V11h3V9H2v2z"}),props.children);});var Iso16=/*#__PURE__*/React.forwardRef(function Iso16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 23h-4a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v10a2 2 0 0 1-2 2zm-4-12v10h4V11zm-6 12h-6v-2h6v-4h-4a2 2 0 0 1-2-2v-4a2 2 0 0 1 2-2h6v2h-6v4h4a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2zM2 11h3v10H2v2h8v-2H7V11h3V9H2v2z"}),props.children);});var Jpg32=/*#__PURE__*/React.forwardRef(function Jpg32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 23h-6a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h6v2h-6v10h4v-4h-2v-2h4zm-16 0h-2V9h6a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2h-4zm0-7h4v-5h-4zm-6 7H4a2 2 0 0 1-2-2v-2h2v2h4V9h2v12a2 2 0 0 1-2 2z"}),props.children);});var Jpg24=/*#__PURE__*/React.forwardRef(function Jpg24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 23h-6a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h6v2h-6v10h4v-4h-2v-2h4zm-16 0h-2V9h6a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2h-4zm0-7h4v-5h-4zm-6 7H4a2 2 0 0 1-2-2v-2h2v2h4V9h2v12a2 2 0 0 1-2 2z"}),props.children);});var Jpg20=/*#__PURE__*/React.forwardRef(function Jpg20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 23h-6a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h6v2h-6v10h4v-4h-2v-2h4zm-16 0h-2V9h6a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2h-4zm0-7h4v-5h-4zm-6 7H4a2 2 0 0 1-2-2v-2h2v2h4V9h2v12a2 2 0 0 1-2 2z"}),props.children);});var Jpg16=/*#__PURE__*/React.forwardRef(function Jpg16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 23h-6a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h6v2h-6v10h4v-4h-2v-2h4zm-16 0h-2V9h6a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2h-4zm0-7h4v-5h-4zm-6 7H4a2 2 0 0 1-2-2v-2h2v2h4V9h2v12a2 2 0 0 1-2 2z"}),props.children);});var Json32=/*#__PURE__*/React.forwardRef(function Json32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M31 11v10h-2l-2-6v6h-2V11h2l2 6v-6h2zm-9.666 10h-2.667A1.668 1.668 0 0 1 17 19.334v-6.667A1.668 1.668 0 0 1 18.666 11h2.667A1.668 1.668 0 0 1 23 12.666v6.667A1.668 1.668 0 0 1 21.334 21zM19 19h2v-6h-2zm-5.666 2H9v-2h4v-2h-2a2.002 2.002 0 0 1-2-2v-2.334A1.668 1.668 0 0 1 10.666 11H15v2h-4v2h2a2.002 2.002 0 0 1 2 2v2.333A1.668 1.668 0 0 1 13.334 21zm-8.001 0H2.667A1.668 1.668 0 0 1 1 19.334V17h2v2h2v-8h2v8.334A1.668 1.668 0 0 1 5.333 21z"}),props.children);});var Json24=/*#__PURE__*/React.forwardRef(function Json24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M31 11v10h-2l-2-6v6h-2V11h2l2 6v-6h2zm-9.666 10h-2.667A1.668 1.668 0 0 1 17 19.334v-6.667A1.668 1.668 0 0 1 18.666 11h2.667A1.668 1.668 0 0 1 23 12.666v6.667A1.668 1.668 0 0 1 21.334 21zM19 19h2v-6h-2zm-5.666 2H9v-2h4v-2h-2a2.002 2.002 0 0 1-2-2v-2.334A1.668 1.668 0 0 1 10.666 11H15v2h-4v2h2a2.002 2.002 0 0 1 2 2v2.333A1.668 1.668 0 0 1 13.334 21zm-8.001 0H2.667A1.668 1.668 0 0 1 1 19.334V17h2v2h2v-8h2v8.334A1.668 1.668 0 0 1 5.333 21z"}),props.children);});var Json20=/*#__PURE__*/React.forwardRef(function Json20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M31 11v10h-2l-2-6v6h-2V11h2l2 6v-6h2zm-9.666 10h-2.667A1.668 1.668 0 0 1 17 19.334v-6.667A1.668 1.668 0 0 1 18.666 11h2.667A1.668 1.668 0 0 1 23 12.666v6.667A1.668 1.668 0 0 1 21.334 21zM19 19h2v-6h-2zm-5.666 2H9v-2h4v-2h-2a2.002 2.002 0 0 1-2-2v-2.334A1.668 1.668 0 0 1 10.666 11H15v2h-4v2h2a2.002 2.002 0 0 1 2 2v2.333A1.668 1.668 0 0 1 13.334 21zm-8.001 0H2.667A1.668 1.668 0 0 1 1 19.334V17h2v2h2v-8h2v8.334A1.668 1.668 0 0 1 5.333 21z"}),props.children);});var Json16=/*#__PURE__*/React.forwardRef(function Json16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M31 11v10h-2l-2-6v6h-2V11h2l2 6v-6h2zm-9.666 10h-2.667A1.668 1.668 0 0 1 17 19.334v-6.667A1.668 1.668 0 0 1 18.666 11h2.667A1.668 1.668 0 0 1 23 12.666v6.667A1.668 1.668 0 0 1 21.334 21zM19 19h2v-6h-2zm-5.666 2H9v-2h4v-2h-2a2.002 2.002 0 0 1-2-2v-2.334A1.668 1.668 0 0 1 10.666 11H15v2h-4v2h2a2.002 2.002 0 0 1 2 2v2.333A1.668 1.668 0 0 1 13.334 21zm-8.001 0H2.667A1.668 1.668 0 0 1 1 19.334V17h2v2h2v-8h2v8.334A1.668 1.668 0 0 1 5.333 21z"}),props.children);});var Mov32=/*#__PURE__*/React.forwardRef(function Mov32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 9l-2 13-2-13h-2l2.52 14h2.96L30 9h-2zM18 23h-4a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v10a2 2 0 0 1-2 2zm-4-12v10h4V11zM8 9l-1.51 5L6 15.98 5.54 14 4 9H2v14h2v-8l-.16-2 .58 2L6 19.63 7.58 15l.58-2L8 15v8h2V9H8z"}),props.children);});var Mov24=/*#__PURE__*/React.forwardRef(function Mov24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 9l-2 13-2-13h-2l2.52 14h2.96L30 9h-2zM18 23h-4a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v10a2 2 0 0 1-2 2zm-4-12v10h4V11zM8 9l-1.51 5L6 15.98 5.54 14 4 9H2v14h2v-8l-.16-2 .58 2L6 19.63 7.58 15l.58-2L8 15v8h2V9H8z"}),props.children);});var Mov20=/*#__PURE__*/React.forwardRef(function Mov20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 9l-2 13-2-13h-2l2.52 14h2.96L30 9h-2zM18 23h-4a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v10a2 2 0 0 1-2 2zm-4-12v10h4V11zM8 9l-1.51 5L6 15.98 5.54 14 4 9H2v14h2v-8l-.16-2 .58 2L6 19.63 7.58 15l.58-2L8 15v8h2V9H8z"}),props.children);});var Mov16=/*#__PURE__*/React.forwardRef(function Mov16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 9l-2 13-2-13h-2l2.52 14h2.96L30 9h-2zM18 23h-4a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v10a2 2 0 0 1-2 2zm-4-12v10h4V11zM8 9l-1.51 5L6 15.98 5.54 14 4 9H2v14h2v-8l-.16-2 .58 2L6 19.63 7.58 15l.58-2L8 15v8h2V9H8z"}),props.children);});var Mp332=/*#__PURE__*/React.forwardRef(function Mp332(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 9h-6v2h6v4h-4v2h4v4h-6v2h6a2 2 0 0 0 2-2V11a2 2 0 0 0-2-2zM14 23h-2V9h6a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2h-4zm0-7h4v-5h-4zM8 9l-1.51 5L6 15.98 5.54 14 4 9H2v14h2v-8l-.16-2 .58 2L6 19.63 7.58 15l.58-2L8 15v8h2V9H8z"}),props.children);});var Mp324=/*#__PURE__*/React.forwardRef(function Mp324(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 9h-6v2h6v4h-4v2h4v4h-6v2h6a2 2 0 0 0 2-2V11a2 2 0 0 0-2-2zM14 23h-2V9h6a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2h-4zm0-7h4v-5h-4zM8 9l-1.51 5L6 15.98 5.54 14 4 9H2v14h2v-8l-.16-2 .58 2L6 19.63 7.58 15l.58-2L8 15v8h2V9H8z"}),props.children);});var Mp320=/*#__PURE__*/React.forwardRef(function Mp320(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 9h-6v2h6v4h-4v2h4v4h-6v2h6a2 2 0 0 0 2-2V11a2 2 0 0 0-2-2zM14 23h-2V9h6a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2h-4zm0-7h4v-5h-4zM8 9l-1.51 5L6 15.98 5.54 14 4 9H2v14h2v-8l-.16-2 .58 2L6 19.63 7.58 15l.58-2L8 15v8h2V9H8z"}),props.children);});var Mp316=/*#__PURE__*/React.forwardRef(function Mp316(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 9h-6v2h6v4h-4v2h4v4h-6v2h6a2 2 0 0 0 2-2V11a2 2 0 0 0-2-2zM14 23h-2V9h6a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2h-4zm0-7h4v-5h-4zM8 9l-1.51 5L6 15.98 5.54 14 4 9H2v14h2v-8l-.16-2 .58 2L6 19.63 7.58 15l.58-2L8 15v8h2V9H8z"}),props.children);});var Mp432=/*#__PURE__*/React.forwardRef(function Mp432(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.5 22.5v-4h-5v-9h1v8h4v-8h1v8h1v1h-1v4h-1z"}),React.createElement("path",{d:"M28 10v8-8m1-1h-2v8h-3V9h-2v10h5v4h2v-4h1v-2h-1V9zM14 23h-2V9h6a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2h-4zm0-7h4v-5h-4zM8 9l-1.51 5L6 15.98 5.54 14 4 9H2v14h2v-8l-.16-2 .58 2L6 19.63 7.58 15l.58-2L8 15v8h2V9H8z"}),props.children);});var Mp424=/*#__PURE__*/React.forwardRef(function Mp424(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.5 22.5v-4h-5v-9h1v8h4v-8h1v8h1v1h-1v4h-1z"}),React.createElement("path",{d:"M28 10v8-8m1-1h-2v8h-3V9h-2v10h5v4h2v-4h1v-2h-1V9zM14 23h-2V9h6a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2h-4zm0-7h4v-5h-4zM8 9l-1.51 5L6 15.98 5.54 14 4 9H2v14h2v-8l-.16-2 .58 2L6 19.63 7.58 15l.58-2L8 15v8h2V9H8z"}),props.children);});var Mp420=/*#__PURE__*/React.forwardRef(function Mp420(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.5 22.5v-4h-5v-9h1v8h4v-8h1v8h1v1h-1v4h-1z"}),React.createElement("path",{d:"M28 10v8-8m1-1h-2v8h-3V9h-2v10h5v4h2v-4h1v-2h-1V9zM14 23h-2V9h6a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2h-4zm0-7h4v-5h-4zM8 9l-1.51 5L6 15.98 5.54 14 4 9H2v14h2v-8l-.16-2 .58 2L6 19.63 7.58 15l.58-2L8 15v8h2V9H8z"}),props.children);});var Mp416=/*#__PURE__*/React.forwardRef(function Mp416(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.5 22.5v-4h-5v-9h1v8h4v-8h1v8h1v1h-1v4h-1z"}),React.createElement("path",{d:"M28 10v8-8m1-1h-2v8h-3V9h-2v10h5v4h2v-4h1v-2h-1V9zM14 23h-2V9h6a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2h-4zm0-7h4v-5h-4zM8 9l-1.51 5L6 15.98 5.54 14 4 9H2v14h2v-8l-.16-2 .58 2L6 19.63 7.58 15l.58-2L8 15v8h2V9H8z"}),props.children);});var Pdf32=/*#__PURE__*/React.forwardRef(function Pdf32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 11V9h-8v14h2v-6h5v-2h-5v-4h6zM8 9H2v14h2v-5h4a2 2 0 0 0 2-2v-5a2 2 0 0 0-2-2zm0 7H4v-5h4zm8 7h-4V9h4a4 4 0 0 1 4 4v6a4 4 0 0 1-4 4zm-2-2h2a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2h-2z"}),props.children);});var Pdf24=/*#__PURE__*/React.forwardRef(function Pdf24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 11V9h-8v14h2v-6h5v-2h-5v-4h6zM8 9H2v14h2v-5h4a2 2 0 0 0 2-2v-5a2 2 0 0 0-2-2zm0 7H4v-5h4zm8 7h-4V9h4a4 4 0 0 1 4 4v6a4 4 0 0 1-4 4zm-2-2h2a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2h-2z"}),props.children);});var Pdf20=/*#__PURE__*/React.forwardRef(function Pdf20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 11V9h-8v14h2v-6h5v-2h-5v-4h6zM8 9H2v14h2v-5h4a2 2 0 0 0 2-2v-5a2 2 0 0 0-2-2zm0 7H4v-5h4zm8 7h-4V9h4a4 4 0 0 1 4 4v6a4 4 0 0 1-4 4zm-2-2h2a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2h-2z"}),props.children);});var Pdf16=/*#__PURE__*/React.forwardRef(function Pdf16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 11V9h-8v14h2v-6h5v-2h-5v-4h6zM8 9H2v14h2v-5h4a2 2 0 0 0 2-2v-5a2 2 0 0 0-2-2zm0 7H4v-5h4zm8 7h-4V9h4a4 4 0 0 1 4 4v6a4 4 0 0 1-4 4zm-2-2h2a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2h-2z"}),props.children);});var Png32=/*#__PURE__*/React.forwardRef(function Png32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 23h-6a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h6v2h-6v10h4v-4h-2v-2h4zm-12-4L14.32 9H12v14h2V13l3.68 10H20V9h-2v10zM4 23H2V9h6a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2H4zm0-7h4v-5H4z"}),props.children);});var Png24=/*#__PURE__*/React.forwardRef(function Png24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 23h-6a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h6v2h-6v10h4v-4h-2v-2h4zm-12-4L14.32 9H12v14h2V13l3.68 10H20V9h-2v10zM4 23H2V9h6a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2H4zm0-7h4v-5H4z"}),props.children);});var Png20=/*#__PURE__*/React.forwardRef(function Png20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 23h-6a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h6v2h-6v10h4v-4h-2v-2h4zm-12-4L14.32 9H12v14h2V13l3.68 10H20V9h-2v10zM4 23H2V9h6a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2H4zm0-7h4v-5H4z"}),props.children);});var Png16=/*#__PURE__*/React.forwardRef(function Png16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 23h-6a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h6v2h-6v10h4v-4h-2v-2h4zm-12-4L14.32 9H12v14h2V13l3.68 10H20V9h-2v10zM4 23H2V9h6a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2H4zm0-7h4v-5H4z"}),props.children);});var QH32=/*#__PURE__*/React.forwardRef(function QH32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 9v6h-4V9h-2v14h2v-6h4v6h2V9h-2z"}),props.children);});var QH24=/*#__PURE__*/React.forwardRef(function QH24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 9v6h-4V9h-2v14h2v-6h4v6h2V9h-2z"}),props.children);});var QH20=/*#__PURE__*/React.forwardRef(function QH20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 9v6h-4V9h-2v14h2v-6h4v6h2V9h-2z"}),props.children);});var QH16=/*#__PURE__*/React.forwardRef(function QH16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 9v6h-4V9h-2v14h2v-6h4v6h2V9h-2z"}),props.children);});var QSAlt32=/*#__PURE__*/React.forwardRef(function QSAlt32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 9h-2V7h-2v2h-2v2h2v6h2v-6h2V9zM14 23H8v-2h6v-4h-4a2 2 0 0 1-2-2v-4a2 2 0 0 1 2-2h6v2h-6v4h4a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2z"}),props.children);});var QSAlt24=/*#__PURE__*/React.forwardRef(function QSAlt24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 9h-2V7h-2v2h-2v2h2v6h2v-6h2V9zM14 23H8v-2h6v-4h-4a2 2 0 0 1-2-2v-4a2 2 0 0 1 2-2h6v2h-6v4h4a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2z"}),props.children);});var QSAlt20=/*#__PURE__*/React.forwardRef(function QSAlt20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 9h-2V7h-2v2h-2v2h2v6h2v-6h2V9zM14 23H8v-2h6v-4h-4a2 2 0 0 1-2-2v-4a2 2 0 0 1 2-2h6v2h-6v4h4a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2z"}),props.children);});var QSAlt16=/*#__PURE__*/React.forwardRef(function QSAlt16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 9h-2V7h-2v2h-2v2h2v6h2v-6h2V9zM14 23H8v-2h6v-4h-4a2 2 0 0 1-2-2v-4a2 2 0 0 1 2-2h6v2h-6v4h4a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2z"}),props.children);});var QS32=/*#__PURE__*/React.forwardRef(function QS32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 23h-6v-2h6v-4h-4a2 2 0 0 1-2-2v-4a2 2 0 0 1 2-2h6v2h-6v4h4a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2z"}),props.children);});var QS24=/*#__PURE__*/React.forwardRef(function QS24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 23h-6v-2h6v-4h-4a2 2 0 0 1-2-2v-4a2 2 0 0 1 2-2h6v2h-6v4h4a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2z"}),props.children);});var QS20=/*#__PURE__*/React.forwardRef(function QS20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 23h-6v-2h6v-4h-4a2 2 0 0 1-2-2v-4a2 2 0 0 1 2-2h6v2h-6v4h4a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2z"}),props.children);});var QS16=/*#__PURE__*/React.forwardRef(function QS16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 23h-6v-2h6v-4h-4a2 2 0 0 1-2-2v-4a2 2 0 0 1 2-2h6v2h-6v4h4a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2z"}),props.children);});var QTAlt32=/*#__PURE__*/React.forwardRef(function QTAlt32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8 11h3v12h2V11h3V9H8v2zm16-2h-2V7h-2v2h-2v2h2v6l1 1 1-1v-6h2V9z"}),props.children);});var QTAlt24=/*#__PURE__*/React.forwardRef(function QTAlt24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8 11h3v12h2V11h3V9H8v2zm16-2h-2V7h-2v2h-2v2h2v6l1 1 1-1v-6h2V9z"}),props.children);});var QTAlt20=/*#__PURE__*/React.forwardRef(function QTAlt20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8 11h3v12h2V11h3V9H8v2zm16-2h-2V7h-2v2h-2v2h2v6l1 1 1-1v-6h2V9z"}),props.children);});var QTAlt16=/*#__PURE__*/React.forwardRef(function QTAlt16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8 11h3v12h2V11h3V9H8v2zm16-2h-2V7h-2v2h-2v2h2v6l1 1 1-1v-6h2V9z"}),props.children);});var QT32=/*#__PURE__*/React.forwardRef(function QT32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 11h3v12h2V11h3V9h-8v2z"}),props.children);});var QT24=/*#__PURE__*/React.forwardRef(function QT24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 11h3v12h2V11h3V9h-8v2z"}),props.children);});var QT20=/*#__PURE__*/React.forwardRef(function QT20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 11h3v12h2V11h3V9h-8v2z"}),props.children);});var QT16=/*#__PURE__*/React.forwardRef(function QT16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 11h3v12h2V11h3V9h-8v2z"}),props.children);});var QU132=/*#__PURE__*/React.forwardRef(function QU132(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13 23H9a2 2 0 0 1-2-2V9h2v12h4V9h2v12a2 2 0 0 1-2 2zm9-2V9h-5v2h3v10h-3v2h8v-2h-3z"}),props.children);});var QU124=/*#__PURE__*/React.forwardRef(function QU124(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13 23H9a2 2 0 0 1-2-2V9h2v12h4V9h2v12a2 2 0 0 1-2 2zm9-2V9h-5v2h3v10h-3v2h8v-2h-3z"}),props.children);});var QU120=/*#__PURE__*/React.forwardRef(function QU120(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13 23H9a2 2 0 0 1-2-2V9h2v12h4V9h2v12a2 2 0 0 1-2 2zm9-2V9h-5v2h3v10h-3v2h8v-2h-3z"}),props.children);});var QU116=/*#__PURE__*/React.forwardRef(function QU116(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13 23H9a2 2 0 0 1-2-2V9h2v12h4V9h2v12a2 2 0 0 1-2 2zm9-2V9h-5v2h3v10h-3v2h8v-2h-3z"}),props.children);});var QU232=/*#__PURE__*/React.forwardRef(function QU232(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13 23H9a2 2 0 0 1-2-2V9h2v12h4V9h2v12a2 2 0 0 1-2 2zm12 0h-8v-6a2 2 0 0 1 2-2h4v-4h-6V9h6a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2h-4v4h6z"}),props.children);});var QU224=/*#__PURE__*/React.forwardRef(function QU224(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13 23H9a2 2 0 0 1-2-2V9h2v12h4V9h2v12a2 2 0 0 1-2 2zm12 0h-8v-6a2 2 0 0 1 2-2h4v-4h-6V9h6a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2h-4v4h6z"}),props.children);});var QU220=/*#__PURE__*/React.forwardRef(function QU220(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13 23H9a2 2 0 0 1-2-2V9h2v12h4V9h2v12a2 2 0 0 1-2 2zm12 0h-8v-6a2 2 0 0 1 2-2h4v-4h-6V9h6a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2h-4v4h6z"}),props.children);});var QU216=/*#__PURE__*/React.forwardRef(function QU216(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13 23H9a2 2 0 0 1-2-2V9h2v12h4V9h2v12a2 2 0 0 1-2 2zm12 0h-8v-6a2 2 0 0 1 2-2h4v-4h-6V9h6a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2h-4v4h6z"}),props.children);});var QU332=/*#__PURE__*/React.forwardRef(function QU332(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13 23H9a2 2 0 0 1-2-2V9h2v12h4V9h2v12a2 2 0 0 1-2 2zM23 9h-6v2h6v4h-5v2h5v4h-6v2h6a2 2 0 0 0 2-2V11a2 2 0 0 0-2-2z"}),props.children);});var QU324=/*#__PURE__*/React.forwardRef(function QU324(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13 23H9a2 2 0 0 1-2-2V9h2v12h4V9h2v12a2 2 0 0 1-2 2zM23 9h-6v2h6v4h-5v2h5v4h-6v2h6a2 2 0 0 0 2-2V11a2 2 0 0 0-2-2z"}),props.children);});var QU320=/*#__PURE__*/React.forwardRef(function QU320(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13 23H9a2 2 0 0 1-2-2V9h2v12h4V9h2v12a2 2 0 0 1-2 2zM23 9h-6v2h6v4h-5v2h5v4h-6v2h6a2 2 0 0 0 2-2V11a2 2 0 0 0-2-2z"}),props.children);});var QU316=/*#__PURE__*/React.forwardRef(function QU316(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13 23H9a2 2 0 0 1-2-2V9h2v12h4V9h2v12a2 2 0 0 1-2 2zM23 9h-6v2h6v4h-5v2h5v4h-6v2h6a2 2 0 0 0 2-2V11a2 2 0 0 0-2-2z"}),props.children);});var QX32=/*#__PURE__*/React.forwardRef(function QX32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 9h-2l-2 6-2-6h-2l2.75 7L12 23h2l2-6 2 6h2l-2.75-7L20 9z"}),props.children);});var QX24=/*#__PURE__*/React.forwardRef(function QX24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 9h-2l-2 6-2-6h-2l2.75 7L12 23h2l2-6 2 6h2l-2.75-7L20 9z"}),props.children);});var QX20=/*#__PURE__*/React.forwardRef(function QX20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 9h-2l-2 6-2-6h-2l2.75 7L12 23h2l2-6 2 6h2l-2.75-7L20 9z"}),props.children);});var QX16=/*#__PURE__*/React.forwardRef(function QX16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 9h-2l-2 6-2-6h-2l2.75 7L12 23h2l2-6 2 6h2l-2.75-7L20 9z"}),props.children);});var QY32=/*#__PURE__*/React.forwardRef(function QY32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 9h-2l-2 7-2-7h-2l3 9v5h2v-5l3-9z"}),props.children);});var QY24=/*#__PURE__*/React.forwardRef(function QY24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 9h-2l-2 7-2-7h-2l3 9v5h2v-5l3-9z"}),props.children);});var QY20=/*#__PURE__*/React.forwardRef(function QY20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 9h-2l-2 7-2-7h-2l3 9v5h2v-5l3-9z"}),props.children);});var QY16=/*#__PURE__*/React.forwardRef(function QY16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 9h-2l-2 7-2-7h-2l3 9v5h2v-5l3-9z"}),props.children);});var QZ32=/*#__PURE__*/React.forwardRef(function QZ32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 9h-8v2h6l-6 10v2h8v-2h-6l6-10V9z"}),props.children);});var QZ24=/*#__PURE__*/React.forwardRef(function QZ24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 9h-8v2h6l-6 10v2h8v-2h-6l6-10V9z"}),props.children);});var QZ20=/*#__PURE__*/React.forwardRef(function QZ20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 9h-8v2h6l-6 10v2h8v-2h-6l6-10V9z"}),props.children);});var QZ16=/*#__PURE__*/React.forwardRef(function QZ16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 9h-8v2h6l-6 10v2h8v-2h-6l6-10V9z"}),props.children);});var QBarrier32=/*#__PURE__*/React.forwardRef(function QBarrier32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 5h2v4h-2zm0 6h2v4h-2zm0 6h2v4h-2zm0 6h2v4h-2z"}),props.children);});var QBarrier24=/*#__PURE__*/React.forwardRef(function QBarrier24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 5h2v4h-2zm0 6h2v4h-2zm0 6h2v4h-2zm0 6h2v4h-2z"}),props.children);});var QBarrier20=/*#__PURE__*/React.forwardRef(function QBarrier20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 5h2v4h-2zm0 6h2v4h-2zm0 6h2v4h-2zm0 6h2v4h-2z"}),props.children);});var QBarrier16=/*#__PURE__*/React.forwardRef(function QBarrier16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 5h2v4h-2zm0 6h2v4h-2zm0 6h2v4h-2zm0 6h2v4h-2z"}),props.children);});var QBlochSphere32=/*#__PURE__*/React.forwardRef(function QBlochSphere32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21.87 7.84l-1.74-1L16 14a2 2 0 1 0 2 2 2 2 0 0 0-.27-1z"}),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 2a12 12 0 0 1 11.17 7.65 25.69 25.69 0 0 0-3.69-1.5l-1 1.77a22.7 22.7 0 0 1 5.41 2.39 11.05 11.05 0 0 1 0 3.38A22.92 22.92 0 0 1 16 21a22.92 22.92 0 0 1-11.87-3.31 11.05 11.05 0 0 1 0-3.38A22.8 22.8 0 0 1 15 11V9a25 25 0 0 0-10.17 2.6A12 12 0 0 1 16 4zm0 24a12 12 0 0 1-11.17-7.65A24.88 24.88 0 0 0 16 23a24.88 24.88 0 0 0 11.17-2.65A12 12 0 0 1 16 28z"}),props.children);});var QBlochSphere24=/*#__PURE__*/React.forwardRef(function QBlochSphere24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21.87 7.84l-1.74-1L16 14a2 2 0 1 0 2 2 2 2 0 0 0-.27-1z"}),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 2a12 12 0 0 1 11.17 7.65 25.69 25.69 0 0 0-3.69-1.5l-1 1.77a22.7 22.7 0 0 1 5.41 2.39 11.05 11.05 0 0 1 0 3.38A22.92 22.92 0 0 1 16 21a22.92 22.92 0 0 1-11.87-3.31 11.05 11.05 0 0 1 0-3.38A22.8 22.8 0 0 1 15 11V9a25 25 0 0 0-10.17 2.6A12 12 0 0 1 16 4zm0 24a12 12 0 0 1-11.17-7.65A24.88 24.88 0 0 0 16 23a24.88 24.88 0 0 0 11.17-2.65A12 12 0 0 1 16 28z"}),props.children);});var QBlochSphere20=/*#__PURE__*/React.forwardRef(function QBlochSphere20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21.87 7.84l-1.74-1L16 14a2 2 0 1 0 2 2 2 2 0 0 0-.27-1z"}),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 2a12 12 0 0 1 11.17 7.65 25.69 25.69 0 0 0-3.69-1.5l-1 1.77a22.7 22.7 0 0 1 5.41 2.39 11.05 11.05 0 0 1 0 3.38A22.92 22.92 0 0 1 16 21a22.92 22.92 0 0 1-11.87-3.31 11.05 11.05 0 0 1 0-3.38A22.8 22.8 0 0 1 15 11V9a25 25 0 0 0-10.17 2.6A12 12 0 0 1 16 4zm0 24a12 12 0 0 1-11.17-7.65A24.88 24.88 0 0 0 16 23a24.88 24.88 0 0 0 11.17-2.65A12 12 0 0 1 16 28z"}),props.children);});var QBlochSphere16=/*#__PURE__*/React.forwardRef(function QBlochSphere16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21.87 7.84l-1.74-1L16 14a2 2 0 1 0 2 2 2 2 0 0 0-.27-1z"}),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 2a12 12 0 0 1 11.17 7.65 25.69 25.69 0 0 0-3.69-1.5l-1 1.77a22.7 22.7 0 0 1 5.41 2.39 11.05 11.05 0 0 1 0 3.38A22.92 22.92 0 0 1 16 21a22.92 22.92 0 0 1-11.87-3.31 11.05 11.05 0 0 1 0-3.38A22.8 22.8 0 0 1 15 11V9a25 25 0 0 0-10.17 2.6A12 12 0 0 1 16 4zm0 24a12 12 0 0 1-11.17-7.65A24.88 24.88 0 0 0 16 23a24.88 24.88 0 0 0 11.17-2.65A12 12 0 0 1 16 28z"}),props.children);});var QCU132=/*#__PURE__*/React.forwardRef(function QCU132(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 23H5a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h5v2H5v6h5zm8 0h-4a2 2 0 0 1-2-2V9h2v12h4V9h2v12a2 2 0 0 1-2 2zm9-2V9.01h-5v2h3V21h-3v2h8v-2h-3z"}),props.children);});var QCU124=/*#__PURE__*/React.forwardRef(function QCU124(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 23H5a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h5v2H5v6h5zm8 0h-4a2 2 0 0 1-2-2V9h2v12h4V9h2v12a2 2 0 0 1-2 2zm9-2V9.01h-5v2h3V21h-3v2h8v-2h-3z"}),props.children);});var QCU120=/*#__PURE__*/React.forwardRef(function QCU120(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 23H5a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h5v2H5v6h5zm8 0h-4a2 2 0 0 1-2-2V9h2v12h4V9h2v12a2 2 0 0 1-2 2zm9-2V9.01h-5v2h3V21h-3v2h8v-2h-3z"}),props.children);});var QCU116=/*#__PURE__*/React.forwardRef(function QCU116(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 23H5a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h5v2H5v6h5zm8 0h-4a2 2 0 0 1-2-2V9h2v12h4V9h2v12a2 2 0 0 1-2 2zm9-2V9.01h-5v2h3V21h-3v2h8v-2h-3z"}),props.children);});var QCU332=/*#__PURE__*/React.forwardRef(function QCU332(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 23H5a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h5v2H5v6h5zm8 0h-4a2 2 0 0 1-2-2V9h2v12h4V9h2v12a2 2 0 0 1-2 2zM28 9h-6v2h6v4h-5v2h5v4h-6v2h6a2 2 0 0 0 2-2V11a2 2 0 0 0-2-2z"}),props.children);});var QCU324=/*#__PURE__*/React.forwardRef(function QCU324(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 23H5a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h5v2H5v6h5zm8 0h-4a2 2 0 0 1-2-2V9h2v12h4V9h2v12a2 2 0 0 1-2 2zM28 9h-6v2h6v4h-5v2h5v4h-6v2h6a2 2 0 0 0 2-2V11a2 2 0 0 0-2-2z"}),props.children);});var QCU320=/*#__PURE__*/React.forwardRef(function QCU320(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 23H5a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h5v2H5v6h5zm8 0h-4a2 2 0 0 1-2-2V9h2v12h4V9h2v12a2 2 0 0 1-2 2zM28 9h-6v2h6v4h-5v2h5v4h-6v2h6a2 2 0 0 0 2-2V11a2 2 0 0 0-2-2z"}),props.children);});var QCU316=/*#__PURE__*/React.forwardRef(function QCU316(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 23H5a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h5v2H5v6h5zm8 0h-4a2 2 0 0 1-2-2V9h2v12h4V9h2v12a2 2 0 0 1-2 2zM28 9h-6v2h6v4h-5v2h5v4h-6v2h6a2 2 0 0 0 2-2V11a2 2 0 0 0-2-2z"}),props.children);});var QCY32=/*#__PURE__*/React.forwardRef(function QCY32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 23h-5a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h5v2h-5v6h5zm9-14h-2l-2 7-2-7h-2l3 9v5h2v-5l3-9z"}),props.children);});var QCY24=/*#__PURE__*/React.forwardRef(function QCY24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 23h-5a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h5v2h-5v6h5zm9-14h-2l-2 7-2-7h-2l3 9v5h2v-5l3-9z"}),props.children);});var QCY20=/*#__PURE__*/React.forwardRef(function QCY20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 23h-5a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h5v2h-5v6h5zm9-14h-2l-2 7-2-7h-2l3 9v5h2v-5l3-9z"}),props.children);});var QCY16=/*#__PURE__*/React.forwardRef(function QCY16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 23h-5a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h5v2h-5v6h5zm9-14h-2l-2 7-2-7h-2l3 9v5h2v-5l3-9z"}),props.children);});var QCZ32=/*#__PURE__*/React.forwardRef(function QCZ32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M14 23H9a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h5v2H9v6h5zM24 9h-8v2h6l-6 10v2h8v-2h-6l6-10V9z"}),props.children);});var QCZ24=/*#__PURE__*/React.forwardRef(function QCZ24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M14 23H9a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h5v2H9v6h5zM24 9h-8v2h6l-6 10v2h8v-2h-6l6-10V9z"}),props.children);});var QCZ20=/*#__PURE__*/React.forwardRef(function QCZ20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M14 23H9a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h5v2H9v6h5zM24 9h-8v2h6l-6 10v2h8v-2h-6l6-10V9z"}),props.children);});var QCZ16=/*#__PURE__*/React.forwardRef(function QCZ16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M14 23H9a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h5v2H9v6h5zM24 9h-8v2h6l-6 10v2h8v-2h-6l6-10V9z"}),props.children);});var QCcX32=/*#__PURE__*/React.forwardRef(function QCcX32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 23H5a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h5v2H5v6h5zm9 0h-5a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h5v2h-5v6h5zM29 9h-2l-2 6-2-6h-2l2.75 7L21 23h2l2-6 2 6h2l-2.75-7L29 9z"}),props.children);});var QCcX24=/*#__PURE__*/React.forwardRef(function QCcX24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 23H5a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h5v2H5v6h5zm9 0h-5a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h5v2h-5v6h5zM29 9h-2l-2 6-2-6h-2l2.75 7L21 23h2l2-6 2 6h2l-2.75-7L29 9z"}),props.children);});var QCcX20=/*#__PURE__*/React.forwardRef(function QCcX20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 23H5a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h5v2H5v6h5zm9 0h-5a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h5v2h-5v6h5zM29 9h-2l-2 6-2-6h-2l2.75 7L21 23h2l2-6 2 6h2l-2.75-7L29 9z"}),props.children);});var QCcX16=/*#__PURE__*/React.forwardRef(function QCcX16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 23H5a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h5v2H5v6h5zm9 0h-5a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h5v2h-5v6h5zM29 9h-2l-2 6-2-6h-2l2.75 7L21 23h2l2-6 2 6h2l-2.75-7L29 9z"}),props.children);});var QCircuitComposer32=/*#__PURE__*/React.forwardRef(function QCircuitComposer32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 9v6h-4V9h-2v14h2v-6h4v6h2V9h-2z"}),React.createElement("path",{d:"M30 15h-4V6a2 2 0 0 0-2-2H8a2 2 0 0 0-2 2v9H2v2h4v9a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2v-9h4zM8 26V6h16v20z"}),props.children);});var QCircuitComposer24=/*#__PURE__*/React.forwardRef(function QCircuitComposer24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 9v6h-4V9h-2v14h2v-6h4v6h2V9h-2z"}),React.createElement("path",{d:"M30 15h-4V6a2 2 0 0 0-2-2H8a2 2 0 0 0-2 2v9H2v2h4v9a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2v-9h4zM8 26V6h16v20z"}),props.children);});var QCircuitComposer20=/*#__PURE__*/React.forwardRef(function QCircuitComposer20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 9v6h-4V9h-2v14h2v-6h4v6h2V9h-2z"}),React.createElement("path",{d:"M30 15h-4V6a2 2 0 0 0-2-2H8a2 2 0 0 0-2 2v9H2v2h4v9a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2v-9h4zM8 26V6h16v20z"}),props.children);});var QCircuitComposer16=/*#__PURE__*/React.forwardRef(function QCircuitComposer16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 9v6h-4V9h-2v14h2v-6h4v6h2V9h-2z"}),React.createElement("path",{d:"M30 15h-4V6a2 2 0 0 0-2-2H8a2 2 0 0 0-2 2v9H2v2h4v9a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2v-9h4zM8 26V6h16v20z"}),props.children);});var QComposerEdit32=/*#__PURE__*/React.forwardRef(function QComposerEdit32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.82 10H30V8h-4.18a3 3 0 0 0-5.64 0H13V5H5v3H2v2h3v3h8v-3h7.18A3 3 0 0 0 22 11.82v7.32A4 4 0 0 0 19.14 22H2v2h17.14a4 4 0 0 0 7.72 0H30v-2h-3.14A4 4 0 0 0 24 19.14v-7.32A3 3 0 0 0 25.82 10zM11 11H7V7h4zm14 12a2 2 0 1 1-2-2 2 2 0 0 1 2 2z"}),props.children);});var QComposerEdit24=/*#__PURE__*/React.forwardRef(function QComposerEdit24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.82 10H30V8h-4.18a3 3 0 0 0-5.64 0H13V5H5v3H2v2h3v3h8v-3h7.18A3 3 0 0 0 22 11.82v7.32A4 4 0 0 0 19.14 22H2v2h17.14a4 4 0 0 0 7.72 0H30v-2h-3.14A4 4 0 0 0 24 19.14v-7.32A3 3 0 0 0 25.82 10zM11 11H7V7h4zm14 12a2 2 0 1 1-2-2 2 2 0 0 1 2 2z"}),props.children);});var QComposerEdit20=/*#__PURE__*/React.forwardRef(function QComposerEdit20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.82 10H30V8h-4.18a3 3 0 0 0-5.64 0H13V5H5v3H2v2h3v3h8v-3h7.18A3 3 0 0 0 22 11.82v7.32A4 4 0 0 0 19.14 22H2v2h17.14a4 4 0 0 0 7.72 0H30v-2h-3.14A4 4 0 0 0 24 19.14v-7.32A3 3 0 0 0 25.82 10zM11 11H7V7h4zm14 12a2 2 0 1 1-2-2 2 2 0 0 1 2 2z"}),props.children);});var QComposerEdit16=/*#__PURE__*/React.forwardRef(function QComposerEdit16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.82 10H30V8h-4.18a3 3 0 0 0-5.64 0H13V5H5v3H2v2h3v3h8v-3h7.18A3 3 0 0 0 22 11.82v7.32A4 4 0 0 0 19.14 22H2v2h17.14a4 4 0 0 0 7.72 0H30v-2h-3.14A4 4 0 0 0 24 19.14v-7.32A3 3 0 0 0 25.82 10zM11 11H7V7h4zm14 12a2 2 0 1 1-2-2 2 2 0 0 1 2 2z"}),props.children);});var QHintonPlot32=/*#__PURE__*/React.forwardRef(function QHintonPlot32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2 2h4v4H2zm8 0h4v4h-4zm8 0h4v4h-4zm8 0h4v4h-4zM2 10h4v4H2zm8 0h4v4h-4zm8 0h4v4h-4zm8 0h4v4h-4zM2 18h4v4H2zm8 0h4v4h-4zm8 0h4v4h-4zm8 0h4v4h-4zM2 26h4v4H2zm8 0h4v4h-4zm8 0h4v4h-4zm8 0h4v4h-4z"}),props.children);});var QHintonPlot24=/*#__PURE__*/React.forwardRef(function QHintonPlot24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2 2h4v4H2zm8 0h4v4h-4zm8 0h4v4h-4zm8 0h4v4h-4zM2 10h4v4H2zm8 0h4v4h-4zm8 0h4v4h-4zm8 0h4v4h-4zM2 18h4v4H2zm8 0h4v4h-4zm8 0h4v4h-4zm8 0h4v4h-4zM2 26h4v4H2zm8 0h4v4h-4zm8 0h4v4h-4zm8 0h4v4h-4z"}),props.children);});var QHintonPlot20=/*#__PURE__*/React.forwardRef(function QHintonPlot20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2 2h4v4H2zm8 0h4v4h-4zm8 0h4v4h-4zm8 0h4v4h-4zM2 10h4v4H2zm8 0h4v4h-4zm8 0h4v4h-4zm8 0h4v4h-4zM2 18h4v4H2zm8 0h4v4h-4zm8 0h4v4h-4zm8 0h4v4h-4zM2 26h4v4H2zm8 0h4v4h-4zm8 0h4v4h-4zm8 0h4v4h-4z"}),props.children);});var QHintonPlot16=/*#__PURE__*/React.forwardRef(function QHintonPlot16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2 2h4v4H2zm8 0h4v4h-4zm8 0h4v4h-4zm8 0h4v4h-4zM2 10h4v4H2zm8 0h4v4h-4zm8 0h4v4h-4zm8 0h4v4h-4zM2 18h4v4H2zm8 0h4v4h-4zm8 0h4v4h-4zm8 0h4v4h-4zM2 26h4v4H2zm8 0h4v4h-4zm8 0h4v4h-4zm8 0h4v4h-4z"}),props.children);});var QID32=/*#__PURE__*/React.forwardRef(function QID32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 9h2v2h-2zm8 14h-4V9h4a4 4 0 0 1 4 4v6a4 4 0 0 1-4 4zm-2-2h2a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2h-2zm-6-8h2v10h-2z"}),props.children);});var QID24=/*#__PURE__*/React.forwardRef(function QID24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 9h2v2h-2zm8 14h-4V9h4a4 4 0 0 1 4 4v6a4 4 0 0 1-4 4zm-2-2h2a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2h-2zm-6-8h2v10h-2z"}),props.children);});var QID20=/*#__PURE__*/React.forwardRef(function QID20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 9h2v2h-2zm8 14h-4V9h4a4 4 0 0 1 4 4v6a4 4 0 0 1-4 4zm-2-2h2a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2h-2zm-6-8h2v10h-2z"}),props.children);});var QID16=/*#__PURE__*/React.forwardRef(function QID16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 9h2v2h-2zm8 14h-4V9h4a4 4 0 0 1 4 4v6a4 4 0 0 1-4 4zm-2-2h2a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2h-2zm-6-8h2v10h-2z"}),props.children);});var QMatrix32=/*#__PURE__*/React.forwardRef(function QMatrix32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 13V4h-2v2h-3v2h3v5h-3v2h8v-2h-3zm-1.5 7a3.5 3.5 0 1 1-3.5 3.5 3.5 3.5 0 0 1 3.5-3.5m0-2a5.5 5.5 0 1 0 5.5 5.5 5.5 5.5 0 0 0-5.5-5.5zM8 30H2V2h6v2H4v24h4v2zm22 0h-6v-2h4V4h-4V2h6v28z"}),props.children);});var QMatrix24=/*#__PURE__*/React.forwardRef(function QMatrix24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 13V4h-2v2h-3v2h3v5h-3v2h8v-2h-3zm-1.5 7a3.5 3.5 0 1 1-3.5 3.5 3.5 3.5 0 0 1 3.5-3.5m0-2a5.5 5.5 0 1 0 5.5 5.5 5.5 5.5 0 0 0-5.5-5.5zM8 30H2V2h6v2H4v24h4v2zm22 0h-6v-2h4V4h-4V2h6v28z"}),props.children);});var QMatrix20=/*#__PURE__*/React.forwardRef(function QMatrix20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 13V4h-2v2h-3v2h3v5h-3v2h8v-2h-3zm-1.5 7a3.5 3.5 0 1 1-3.5 3.5 3.5 3.5 0 0 1 3.5-3.5m0-2a5.5 5.5 0 1 0 5.5 5.5 5.5 5.5 0 0 0-5.5-5.5zM8 30H2V2h6v2H4v24h4v2zm22 0h-6v-2h4V4h-4V2h6v28z"}),props.children);});var QMatrix16=/*#__PURE__*/React.forwardRef(function QMatrix16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 13V4h-2v2h-3v2h3v5h-3v2h8v-2h-3zm-1.5 7a3.5 3.5 0 1 1-3.5 3.5 3.5 3.5 0 0 1 3.5-3.5m0-2a5.5 5.5 0 1 0 5.5 5.5 5.5 5.5 0 0 0-5.5-5.5zM8 30H2V2h6v2H4v24h4v2zm22 0h-6v-2h4V4h-4V2h6v28z"}),props.children);});var QOperationGauge32=/*#__PURE__*/React.forwardRef(function QOperationGauge32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 4h-6v2h3.75L24 10v2h6v-2h-3.62L30 6V4zM20 17.62L22.08 14l-1.73-1-2.18 3.76A12 12 0 0 0 2 28h2a10 10 0 0 1 13.16-9.48L14 24a2 2 0 1 0 2 2 2 2 0 0 0-.27-1L19 19.35A10 10 0 0 1 24 28h2a12 12 0 0 0-6-10.38z"}),props.children);});var QOperationGauge24=/*#__PURE__*/React.forwardRef(function QOperationGauge24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 4h-6v2h3.75L24 10v2h6v-2h-3.62L30 6V4zM20 17.62L22.08 14l-1.73-1-2.18 3.76A12 12 0 0 0 2 28h2a10 10 0 0 1 13.16-9.48L14 24a2 2 0 1 0 2 2 2 2 0 0 0-.27-1L19 19.35A10 10 0 0 1 24 28h2a12 12 0 0 0-6-10.38z"}),props.children);});var QOperationGauge20=/*#__PURE__*/React.forwardRef(function QOperationGauge20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 4h-6v2h3.75L24 10v2h6v-2h-3.62L30 6V4zM20 17.62L22.08 14l-1.73-1-2.18 3.76A12 12 0 0 0 2 28h2a10 10 0 0 1 13.16-9.48L14 24a2 2 0 1 0 2 2 2 2 0 0 0-.27-1L19 19.35A10 10 0 0 1 24 28h2a12 12 0 0 0-6-10.38z"}),props.children);});var QOperationGauge16=/*#__PURE__*/React.forwardRef(function QOperationGauge16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 4h-6v2h3.75L24 10v2h6v-2h-3.62L30 6V4zM20 17.62L22.08 14l-1.73-1-2.18 3.76A12 12 0 0 0 2 28h2a10 10 0 0 1 13.16-9.48L14 24a2 2 0 1 0 2 2 2 2 0 0 0-.27-1L19 19.35A10 10 0 0 1 24 28h2a12 12 0 0 0-6-10.38z"}),props.children);});var QOperationIf32=/*#__PURE__*/React.forwardRef(function QOperationIf32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 13h2v10h-2zm0-4h2v2h-2zm11 2V9h-3a2 2 0 0 0-2 2v2h-2v2h2v8h2v-8h3v-2h-3v-2z"}),props.children);});var QOperationIf24=/*#__PURE__*/React.forwardRef(function QOperationIf24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 13h2v10h-2zm0-4h2v2h-2zm11 2V9h-3a2 2 0 0 0-2 2v2h-2v2h2v8h2v-8h3v-2h-3v-2z"}),props.children);});var QOperationIf20=/*#__PURE__*/React.forwardRef(function QOperationIf20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 13h2v10h-2zm0-4h2v2h-2zm11 2V9h-3a2 2 0 0 0-2 2v2h-2v2h2v8h2v-8h3v-2h-3v-2z"}),props.children);});var QOperationIf16=/*#__PURE__*/React.forwardRef(function QOperationIf16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 13h2v10h-2zm0-4h2v2h-2zm11 2V9h-3a2 2 0 0 0-2 2v2h-2v2h2v8h2v-8h3v-2h-3v-2z"}),props.children);});var QOperation32=/*#__PURE__*/React.forwardRef(function QOperation32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 26h-2l5-10-5-10h2l5 10-5 10zM4 6h2v20H4zm12 3h-4a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2V11a2 2 0 0 0-2-2zm0 12h-4V11h4z"}),React.createElement("path",{d:"M13 15h2v2h-2z"}),props.children);});var QOperation24=/*#__PURE__*/React.forwardRef(function QOperation24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 26h-2l5-10-5-10h2l5 10-5 10zM4 6h2v20H4zm12 3h-4a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2V11a2 2 0 0 0-2-2zm0 12h-4V11h4z"}),React.createElement("path",{d:"M13 15h2v2h-2z"}),props.children);});var QOperation20=/*#__PURE__*/React.forwardRef(function QOperation20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 26h-2l5-10-5-10h2l5 10-5 10zM4 6h2v20H4zm12 3h-4a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2V11a2 2 0 0 0-2-2zm0 12h-4V11h4z"}),React.createElement("path",{d:"M13 15h2v2h-2z"}),props.children);});var QOperation16=/*#__PURE__*/React.forwardRef(function QOperation16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 26h-2l5-10-5-10h2l5 10-5 10zM4 6h2v20H4zm12 3h-4a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2V11a2 2 0 0 0-2-2zm0 12h-4V11h4z"}),React.createElement("path",{d:"M13 15h2v2h-2z"}),props.children);});var Raw32=/*#__PURE__*/React.forwardRef(function Raw32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.2 9l-.34 8-.26 4.54-.41-3.54-.68-5.46h-2.02L24.81 18l-.41 3.54-.26-4.54-.34-8H22l1 14h2.27l.76-4.93.46-4.07.01-.03.01.03.46 4.07.76 4.93H30l1-14h-1.8zM18 9h-4a2 2 0 0 0-2 2v12h2v-5h4v5h2V11a2 2 0 0 0-2-2zm-4 7v-5h4v5zm-4-1v-4a2 2 0 0 0-2-2H2v14h2v-6h1.48l2.34 6H10l-2.37-6H8a2 2 0 0 0 2-2zm-6-4h4v4H4z"}),props.children);});var Raw24=/*#__PURE__*/React.forwardRef(function Raw24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.2 9l-.34 8-.26 4.54-.41-3.54-.68-5.46h-2.02L24.81 18l-.41 3.54-.26-4.54-.34-8H22l1 14h2.27l.76-4.93.46-4.07.01-.03.01.03.46 4.07.76 4.93H30l1-14h-1.8zM18 9h-4a2 2 0 0 0-2 2v12h2v-5h4v5h2V11a2 2 0 0 0-2-2zm-4 7v-5h4v5zm-4-1v-4a2 2 0 0 0-2-2H2v14h2v-6h1.48l2.34 6H10l-2.37-6H8a2 2 0 0 0 2-2zm-6-4h4v4H4z"}),props.children);});var Raw20=/*#__PURE__*/React.forwardRef(function Raw20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.2 9l-.34 8-.26 4.54-.41-3.54-.68-5.46h-2.02L24.81 18l-.41 3.54-.26-4.54-.34-8H22l1 14h2.27l.76-4.93.46-4.07.01-.03.01.03.46 4.07.76 4.93H30l1-14h-1.8zM18 9h-4a2 2 0 0 0-2 2v12h2v-5h4v5h2V11a2 2 0 0 0-2-2zm-4 7v-5h4v5zm-4-1v-4a2 2 0 0 0-2-2H2v14h2v-6h1.48l2.34 6H10l-2.37-6H8a2 2 0 0 0 2-2zm-6-4h4v4H4z"}),props.children);});var Raw16=/*#__PURE__*/React.forwardRef(function Raw16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.2 9l-.34 8-.26 4.54-.41-3.54-.68-5.46h-2.02L24.81 18l-.41 3.54-.26-4.54-.34-8H22l1 14h2.27l.76-4.93.46-4.07.01-.03.01.03.46 4.07.76 4.93H30l1-14h-1.8zM18 9h-4a2 2 0 0 0-2 2v12h2v-5h4v5h2V11a2 2 0 0 0-2-2zm-4 7v-5h4v5zm-4-1v-4a2 2 0 0 0-2-2H2v14h2v-6h1.48l2.34 6H10l-2.37-6H8a2 2 0 0 0 2-2zm-6-4h4v4H4z"}),props.children);});var Sql32=/*#__PURE__*/React.forwardRef(function Sql32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 21V9h-2v14h8v-2h-6zM18 9h-4a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h1v2a2 2 0 0 0 2 2h2v-2h-2v-2h1a2 2 0 0 0 2-2V11a2 2 0 0 0-2-2zm-4 12V11h4v10zm-6 2H2v-2h6v-4H4a2 2 0 0 1-2-2v-4a2 2 0 0 1 2-2h6v2H4v4h4a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2z"}),props.children);});var Sql24=/*#__PURE__*/React.forwardRef(function Sql24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 21V9h-2v14h8v-2h-6zM18 9h-4a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h1v2a2 2 0 0 0 2 2h2v-2h-2v-2h1a2 2 0 0 0 2-2V11a2 2 0 0 0-2-2zm-4 12V11h4v10zm-6 2H2v-2h6v-4H4a2 2 0 0 1-2-2v-4a2 2 0 0 1 2-2h6v2H4v4h4a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2z"}),props.children);});var Sql20=/*#__PURE__*/React.forwardRef(function Sql20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 21V9h-2v14h8v-2h-6zM18 9h-4a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h1v2a2 2 0 0 0 2 2h2v-2h-2v-2h1a2 2 0 0 0 2-2V11a2 2 0 0 0-2-2zm-4 12V11h4v10zm-6 2H2v-2h6v-4H4a2 2 0 0 1-2-2v-4a2 2 0 0 1 2-2h6v2H4v4h4a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2z"}),props.children);});var Sql16=/*#__PURE__*/React.forwardRef(function Sql16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 21V9h-2v14h8v-2h-6zM18 9h-4a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h1v2a2 2 0 0 0 2 2h2v-2h-2v-2h1a2 2 0 0 0 2-2V11a2 2 0 0 0-2-2zm-4 12V11h4v10zm-6 2H2v-2h6v-4H4a2 2 0 0 1-2-2v-4a2 2 0 0 1 2-2h6v2H4v4h4a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2z"}),props.children);});var Svg32=/*#__PURE__*/React.forwardRef(function Svg32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 23h-6a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h6v2h-6v10h4v-4h-2v-2h4zM18 9l-2 13-2-13h-2l2.52 14h2.96L20 9h-2zM8 23H2v-2h6v-4H4a2 2 0 0 1-2-2v-4a2 2 0 0 1 2-2h6v2H4v4h4a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2z"}),props.children);});var Svg24=/*#__PURE__*/React.forwardRef(function Svg24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 23h-6a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h6v2h-6v10h4v-4h-2v-2h4zM18 9l-2 13-2-13h-2l2.52 14h2.96L20 9h-2zM8 23H2v-2h6v-4H4a2 2 0 0 1-2-2v-4a2 2 0 0 1 2-2h6v2H4v4h4a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2z"}),props.children);});var Svg20=/*#__PURE__*/React.forwardRef(function Svg20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 23h-6a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h6v2h-6v10h4v-4h-2v-2h4zM18 9l-2 13-2-13h-2l2.52 14h2.96L20 9h-2zM8 23H2v-2h6v-4H4a2 2 0 0 1-2-2v-4a2 2 0 0 1 2-2h6v2H4v4h4a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2z"}),props.children);});var Svg16=/*#__PURE__*/React.forwardRef(function Svg16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 23h-6a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h6v2h-6v10h4v-4h-2v-2h4zM18 9l-2 13-2-13h-2l2.52 14h2.96L20 9h-2zM8 23H2v-2h6v-4H4a2 2 0 0 1-2-2v-4a2 2 0 0 1 2-2h6v2H4v4h4a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2z"}),props.children);});var Tif32=/*#__PURE__*/React.forwardRef(function Tif32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 11V9h-8v14h2v-6h5v-2h-5v-4h6zm-18 0h3v10h-3v2h8v-2h-3V11h3V9h-8v2zM2 11h3v12h2V11h3V9H2v2z"}),props.children);});var Tif24=/*#__PURE__*/React.forwardRef(function Tif24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 11V9h-8v14h2v-6h5v-2h-5v-4h6zm-18 0h3v10h-3v2h8v-2h-3V11h3V9h-8v2zM2 11h3v12h2V11h3V9H2v2z"}),props.children);});var Tif20=/*#__PURE__*/React.forwardRef(function Tif20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 11V9h-8v14h2v-6h5v-2h-5v-4h6zm-18 0h3v10h-3v2h8v-2h-3V11h3V9h-8v2zM2 11h3v12h2V11h3V9H2v2z"}),props.children);});var Tif16=/*#__PURE__*/React.forwardRef(function Tif16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 11V9h-8v14h2v-6h5v-2h-5v-4h6zm-18 0h3v10h-3v2h8v-2h-3V11h3V9h-8v2zM2 11h3v12h2V11h3V9H2v2z"}),props.children);});var Tsv32=/*#__PURE__*/React.forwardRef(function Tsv32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 9l-2 13-2-13h-2l2.516 14h2.968L30 9h-2zM18 23h-6v-2h6v-4h-4a2.002 2.002 0 0 1-2-2v-4a2.002 2.002 0 0 1 2-2h6v2h-6v4h4a2.002 2.002 0 0 1 2 2v4a2.002 2.002 0 0 1-2 2zM2 11h3v12h2V11h3V9H2v2z"}),props.children);});var Tsv24=/*#__PURE__*/React.forwardRef(function Tsv24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 9l-2 13-2-13h-2l2.516 14h2.968L30 9h-2zM18 23h-6v-2h6v-4h-4a2.002 2.002 0 0 1-2-2v-4a2.002 2.002 0 0 1 2-2h6v2h-6v4h4a2.002 2.002 0 0 1 2 2v4a2.002 2.002 0 0 1-2 2zM2 11h3v12h2V11h3V9H2v2z"}),props.children);});var Tsv20=/*#__PURE__*/React.forwardRef(function Tsv20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 9l-2 13-2-13h-2l2.516 14h2.968L30 9h-2zM18 23h-6v-2h6v-4h-4a2.002 2.002 0 0 1-2-2v-4a2.002 2.002 0 0 1 2-2h6v2h-6v4h4a2.002 2.002 0 0 1 2 2v4a2.002 2.002 0 0 1-2 2zM2 11h3v12h2V11h3V9H2v2z"}),props.children);});var Tsv16=/*#__PURE__*/React.forwardRef(function Tsv16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 9l-2 13-2-13h-2l2.516 14h2.968L30 9h-2zM18 23h-6v-2h6v-4h-4a2.002 2.002 0 0 1-2-2v-4a2.002 2.002 0 0 1 2-2h6v2h-6v4h4a2.002 2.002 0 0 1 2 2v4a2.002 2.002 0 0 1-2 2zM2 11h3v12h2V11h3V9H2v2z"}),props.children);});var Txt32=/*#__PURE__*/React.forwardRef(function Txt32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21 11h3v12h2V11h3V9h-8v2zm-1-2h-2l-2 6-2-6h-2l2.75 7L12 23h2l2-6 2 6h2l-2.75-7L20 9zM3 11h3v12h2V11h3V9H3v2z"}),props.children);});var Txt24=/*#__PURE__*/React.forwardRef(function Txt24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21 11h3v12h2V11h3V9h-8v2zm-1-2h-2l-2 6-2-6h-2l2.75 7L12 23h2l2-6 2 6h2l-2.75-7L20 9zM3 11h3v12h2V11h3V9H3v2z"}),props.children);});var Txt20=/*#__PURE__*/React.forwardRef(function Txt20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21 11h3v12h2V11h3V9h-8v2zm-1-2h-2l-2 6-2-6h-2l2.75 7L12 23h2l2-6 2 6h2l-2.75-7L20 9zM3 11h3v12h2V11h3V9H3v2z"}),props.children);});var Txt16=/*#__PURE__*/React.forwardRef(function Txt16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21 11h3v12h2V11h3V9h-8v2zm-1-2h-2l-2 6-2-6h-2l2.75 7L12 23h2l2-6 2 6h2l-2.75-7L20 9zM3 11h3v12h2V11h3V9H3v2z"}),props.children);});var Usb32=/*#__PURE__*/React.forwardRef(function Usb32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 15V6a2 2 0 0 0-2-2H10a2 2 0 0 0-2 2v9a2 2 0 0 0-2 2v11h2V17h16v11h2V17a2 2 0 0 0-2-2zM10 6h12v9H10z"}),React.createElement("path",{d:"M12 10h3v2h-3zm5 0h3v2h-3z"}),props.children);});var Usb24=/*#__PURE__*/React.forwardRef(function Usb24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 15V6a2 2 0 0 0-2-2H10a2 2 0 0 0-2 2v9a2 2 0 0 0-2 2v11h2V17h16v11h2V17a2 2 0 0 0-2-2zM10 6h12v9H10z"}),React.createElement("path",{d:"M12 10h3v2h-3zm5 0h3v2h-3z"}),props.children);});var Usb20=/*#__PURE__*/React.forwardRef(function Usb20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 15V6a2 2 0 0 0-2-2H10a2 2 0 0 0-2 2v9a2 2 0 0 0-2 2v11h2V17h16v11h2V17a2 2 0 0 0-2-2zM10 6h12v9H10z"}),React.createElement("path",{d:"M12 10h3v2h-3zm5 0h3v2h-3z"}),props.children);});var Usb16=/*#__PURE__*/React.forwardRef(function Usb16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 15V6a2 2 0 0 0-2-2H10a2 2 0 0 0-2 2v9a2 2 0 0 0-2 2v11h2V17h16v11h2V17a2 2 0 0 0-2-2zM10 6h12v9H10z"}),React.createElement("path",{d:"M12 10h3v2h-3zm5 0h3v2h-3z"}),props.children);});var Vpn32=/*#__PURE__*/React.forwardRef(function Vpn32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M14 23h-2V9h6a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2h-4zm0-7h4v-5h-4zm14 3L24.32 9H22v14h2V13l3.68 10H30V9h-2v10zM8 9L6 22 4 9H2l2.52 14h2.96L10 9H8z"}),props.children);});var Vpn24=/*#__PURE__*/React.forwardRef(function Vpn24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M14 23h-2V9h6a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2h-4zm0-7h4v-5h-4zm14 3L24.32 9H22v14h2V13l3.68 10H30V9h-2v10zM8 9L6 22 4 9H2l2.52 14h2.96L10 9H8z"}),props.children);});var Vpn20=/*#__PURE__*/React.forwardRef(function Vpn20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M14 23h-2V9h6a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2h-4zm0-7h4v-5h-4zm14 3L24.32 9H22v14h2V13l3.68 10H30V9h-2v10zM8 9L6 22 4 9H2l2.52 14h2.96L10 9H8z"}),props.children);});var Vpn16=/*#__PURE__*/React.forwardRef(function Vpn16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M14 23h-2V9h6a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2h-4zm0-7h4v-5h-4zm14 3L24.32 9H22v14h2V13l3.68 10H30V9h-2v10zM8 9L6 22 4 9H2l2.52 14h2.96L10 9H8z"}),props.children);});var Wmv32=/*#__PURE__*/React.forwardRef(function Wmv32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29 9l-2 13-2-13h-2l2.52 14h2.96L31 9h-2zM19 9l-1.52 5-.48 1.98-.46-1.98L15 9h-2v14h2v-8l-.16-2 .58 2L17 19.63 18.58 15l.58-2-.16 2v8h2V9h-2zM9.2 9l-.34 8-.26 4.54L8.19 18l-.68-5.46H5.49L4.81 18l-.41 3.54L4.14 17 3.8 9H2l1 14h2.27l.76-4.93.46-4.07.01-.03.01.03.46 4.07.76 4.93H10l1-14H9.2z"}),props.children);});var Wmv24=/*#__PURE__*/React.forwardRef(function Wmv24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29 9l-2 13-2-13h-2l2.52 14h2.96L31 9h-2zM19 9l-1.52 5-.48 1.98-.46-1.98L15 9h-2v14h2v-8l-.16-2 .58 2L17 19.63 18.58 15l.58-2-.16 2v8h2V9h-2zM9.2 9l-.34 8-.26 4.54L8.19 18l-.68-5.46H5.49L4.81 18l-.41 3.54L4.14 17 3.8 9H2l1 14h2.27l.76-4.93.46-4.07.01-.03.01.03.46 4.07.76 4.93H10l1-14H9.2z"}),props.children);});var Wmv20=/*#__PURE__*/React.forwardRef(function Wmv20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29 9l-2 13-2-13h-2l2.52 14h2.96L31 9h-2zM19 9l-1.52 5-.48 1.98-.46-1.98L15 9h-2v14h2v-8l-.16-2 .58 2L17 19.63 18.58 15l.58-2-.16 2v8h2V9h-2zM9.2 9l-.34 8-.26 4.54L8.19 18l-.68-5.46H5.49L4.81 18l-.41 3.54L4.14 17 3.8 9H2l1 14h2.27l.76-4.93.46-4.07.01-.03.01.03.46 4.07.76 4.93H10l1-14H9.2z"}),props.children);});var Wmv16=/*#__PURE__*/React.forwardRef(function Wmv16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29 9l-2 13-2-13h-2l2.52 14h2.96L31 9h-2zM19 9l-1.52 5-.48 1.98-.46-1.98L15 9h-2v14h2v-8l-.16-2 .58 2L17 19.63 18.58 15l.58-2-.16 2v8h2V9h-2zM9.2 9l-.34 8-.26 4.54L8.19 18l-.68-5.46H5.49L4.81 18l-.41 3.54L4.14 17 3.8 9H2l1 14h2.27l.76-4.93.46-4.07.01-.03.01.03.46 4.07.76 4.93H10l1-14H9.2z"}),props.children);});var Xls32=/*#__PURE__*/React.forwardRef(function Xls32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 23h-6v-2h6v-4h-4a2.002 2.002 0 0 1-2-2v-4a2.002 2.002 0 0 1 2-2h6v2h-6v4h4a2.002 2.002 0 0 1 2 2v4a2.002 2.002 0 0 1-2 2zm-14-2V9h-2v14h8v-2h-6zM10 9H8l-2 6-2-6H2l2.752 7L2 23h2l2-6 2 6h2l-2.755-7L10 9z"}),props.children);});var Xls24=/*#__PURE__*/React.forwardRef(function Xls24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 23h-6v-2h6v-4h-4a2.002 2.002 0 0 1-2-2v-4a2.002 2.002 0 0 1 2-2h6v2h-6v4h4a2.002 2.002 0 0 1 2 2v4a2.002 2.002 0 0 1-2 2zm-14-2V9h-2v14h8v-2h-6zM10 9H8l-2 6-2-6H2l2.752 7L2 23h2l2-6 2 6h2l-2.755-7L10 9z"}),props.children);});var Xls20=/*#__PURE__*/React.forwardRef(function Xls20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 23h-6v-2h6v-4h-4a2.002 2.002 0 0 1-2-2v-4a2.002 2.002 0 0 1 2-2h6v2h-6v4h4a2.002 2.002 0 0 1 2 2v4a2.002 2.002 0 0 1-2 2zm-14-2V9h-2v14h8v-2h-6zM10 9H8l-2 6-2-6H2l2.752 7L2 23h2l2-6 2 6h2l-2.755-7L10 9z"}),props.children);});var Xls16=/*#__PURE__*/React.forwardRef(function Xls16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 23h-6v-2h6v-4h-4a2.002 2.002 0 0 1-2-2v-4a2.002 2.002 0 0 1 2-2h6v2h-6v4h4a2.002 2.002 0 0 1 2 2v4a2.002 2.002 0 0 1-2 2zm-14-2V9h-2v14h8v-2h-6zM10 9H8l-2 6-2-6H2l2.752 7L2 23h2l2-6 2 6h2l-2.755-7L10 9z"}),props.children);});var Xml32=/*#__PURE__*/React.forwardRef(function Xml32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 21V9h-2v14h8v-2h-6zM18 9l-1.52 5-.48 1.98-.46-1.98L14 9h-2v14h2v-8l-.16-2 .58 2L16 19.63 17.58 15l.58-2-.16 2v8h2V9h-2zm-8 0H8l-2 6-2-6H2l2.75 7L2 23h2l2-6 2 6h2l-2.75-7L10 9z"}),props.children);});var Xml24=/*#__PURE__*/React.forwardRef(function Xml24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 21V9h-2v14h8v-2h-6zM18 9l-1.52 5-.48 1.98-.46-1.98L14 9h-2v14h2v-8l-.16-2 .58 2L16 19.63 17.58 15l.58-2-.16 2v8h2V9h-2zm-8 0H8l-2 6-2-6H2l2.75 7L2 23h2l2-6 2 6h2l-2.75-7L10 9z"}),props.children);});var Xml20=/*#__PURE__*/React.forwardRef(function Xml20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 21V9h-2v14h8v-2h-6zM18 9l-1.52 5-.48 1.98-.46-1.98L14 9h-2v14h2v-8l-.16-2 .58 2L16 19.63 17.58 15l.58-2-.16 2v8h2V9h-2zm-8 0H8l-2 6-2-6H2l2.75 7L2 23h2l2-6 2 6h2l-2.75-7L10 9z"}),props.children);});var Xml16=/*#__PURE__*/React.forwardRef(function Xml16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 21V9h-2v14h8v-2h-6zM18 9l-1.52 5-.48 1.98-.46-1.98L14 9h-2v14h2v-8l-.16-2 .58 2L16 19.63 17.58 15l.58-2-.16 2v8h2V9h-2zm-8 0H8l-2 6-2-6H2l2.75 7L2 23h2l2-6 2 6h2l-2.75-7L10 9z"}),props.children);});var Zip32=/*#__PURE__*/React.forwardRef(function Zip32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 9h-6v14h2v-5h4a2 2 0 0 0 2-2v-5a2 2 0 0 0-2-2zm0 7h-4v-5h4zM12 9v2h3v10h-3v2h8v-2h-3V11h3V9h-8zm-2 0H2v2h6L2 21v2h8v-2H4l6-10V9z"}),props.children);});var Zip24=/*#__PURE__*/React.forwardRef(function Zip24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 9h-6v14h2v-5h4a2 2 0 0 0 2-2v-5a2 2 0 0 0-2-2zm0 7h-4v-5h4zM12 9v2h3v10h-3v2h8v-2h-3V11h3V9h-8zm-2 0H2v2h6L2 21v2h8v-2H4l6-10V9z"}),props.children);});var Zip20=/*#__PURE__*/React.forwardRef(function Zip20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 9h-6v14h2v-5h4a2 2 0 0 0 2-2v-5a2 2 0 0 0-2-2zm0 7h-4v-5h4zM12 9v2h3v10h-3v2h8v-2h-3V11h3V9h-8zm-2 0H2v2h6L2 21v2h8v-2H4l6-10V9z"}),props.children);});var Zip16=/*#__PURE__*/React.forwardRef(function Zip16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 9h-6v14h2v-5h4a2 2 0 0 0 2-2v-5a2 2 0 0 0-2-2zm0 7h-4v-5h4zM12 9v2h3v10h-3v2h8v-2h-3V11h3V9h-8zm-2 0H2v2h6L2 21v2h8v-2H4l6-10V9z"}),props.children);});var Accessibility32=/*#__PURE__*/React.forwardRef(function Accessibility32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.55 26.11l-3.05 1.52L23.66 21H15a2 2 0 0 1-2-2v-6a2 2 0 0 1 4 0v4h7v-2h-5v-2a4 4 0 0 0-8 0v1a9 9 0 1 0 8.77 11h-2.06A7 7 0 1 1 11 16v3a4 4 0 0 0 4 4h7.34l3.16 7.37 4.95-2.48zM15.5 8A3.5 3.5 0 1 1 19 4.5 3.5 3.5 0 0 1 15.5 8zm0-5A1.5 1.5 0 1 0 17 4.5 1.5 1.5 0 0 0 15.5 3z"}),props.children);});var Accessibility24=/*#__PURE__*/React.forwardRef(function Accessibility24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.55 26.11l-3.05 1.52L23.66 21H15a2 2 0 0 1-2-2v-6a2 2 0 0 1 4 0v4h7v-2h-5v-2a4 4 0 0 0-8 0v1a9 9 0 1 0 8.77 11h-2.06A7 7 0 1 1 11 16v3a4 4 0 0 0 4 4h7.34l3.16 7.37 4.95-2.48zM15.5 8A3.5 3.5 0 1 1 19 4.5 3.5 3.5 0 0 1 15.5 8zm0-5A1.5 1.5 0 1 0 17 4.5 1.5 1.5 0 0 0 15.5 3z"}),props.children);});var Accessibility20=/*#__PURE__*/React.forwardRef(function Accessibility20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.55 26.11l-3.05 1.52L23.66 21H15a2 2 0 0 1-2-2v-6a2 2 0 0 1 4 0v4h7v-2h-5v-2a4 4 0 0 0-8 0v1a9 9 0 1 0 8.77 11h-2.06A7 7 0 1 1 11 16v3a4 4 0 0 0 4 4h7.34l3.16 7.37 4.95-2.48zM15.5 8A3.5 3.5 0 1 1 19 4.5 3.5 3.5 0 0 1 15.5 8zm0-5A1.5 1.5 0 1 0 17 4.5 1.5 1.5 0 0 0 15.5 3z"}),props.children);});var Accessibility16=/*#__PURE__*/React.forwardRef(function Accessibility16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.55 26.11l-3.05 1.52L23.66 21H15a2 2 0 0 1-2-2v-6a2 2 0 0 1 4 0v4h7v-2h-5v-2a4 4 0 0 0-8 0v1a9 9 0 1 0 8.77 11h-2.06A7 7 0 1 1 11 16v3a4 4 0 0 0 4 4h7.34l3.16 7.37 4.95-2.48zM15.5 8A3.5 3.5 0 1 1 19 4.5 3.5 3.5 0 0 1 15.5 8zm0-5A1.5 1.5 0 1 0 17 4.5 1.5 1.5 0 0 0 15.5 3z"}),props.children);});var Account32=/*#__PURE__*/React.forwardRef(function Account32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8 14h11v2H8zm0 5h13v2H8z"}),React.createElement("path",{d:"M28 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm0 2v2H4V6zM4 26V10h24v16z"}),props.children);});var Account24=/*#__PURE__*/React.forwardRef(function Account24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8 14h11v2H8zm0 5h13v2H8z"}),React.createElement("path",{d:"M28 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm0 2v2H4V6zM4 26V10h24v16z"}),props.children);});var Account20=/*#__PURE__*/React.forwardRef(function Account20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8 14h11v2H8zm0 5h13v2H8z"}),React.createElement("path",{d:"M28 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm0 2v2H4V6zM4 26V10h24v16z"}),props.children);});var Account16=/*#__PURE__*/React.forwardRef(function Account16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8 14h11v2H8zm0 5h13v2H8z"}),React.createElement("path",{d:"M28 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm0 2v2H4V6zM4 26V10h24v16z"}),props.children);});var Activity32=/*#__PURE__*/React.forwardRef(function Activity32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 29a1 1 0 0 1-.92-.62L6.33 17H2v-2h5a1 1 0 0 1 .92.62L12 25.28l8.06-21.63A1 1 0 0 1 21 3a1 1 0 0 1 .93.68L25.72 15H30v2h-5a1 1 0 0 1-.95-.68L21 7l-8.06 21.35A1 1 0 0 1 12 29z"}),props.children);});var Activity24=/*#__PURE__*/React.forwardRef(function Activity24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 29a1 1 0 0 1-.92-.62L6.33 17H2v-2h5a1 1 0 0 1 .92.62L12 25.28l8.06-21.63A1 1 0 0 1 21 3a1 1 0 0 1 .93.68L25.72 15H30v2h-5a1 1 0 0 1-.95-.68L21 7l-8.06 21.35A1 1 0 0 1 12 29z"}),props.children);});var Activity20=/*#__PURE__*/React.forwardRef(function Activity20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 29a1 1 0 0 1-.92-.62L6.33 17H2v-2h5a1 1 0 0 1 .92.62L12 25.28l8.06-21.63A1 1 0 0 1 21 3a1 1 0 0 1 .93.68L25.72 15H30v2h-5a1 1 0 0 1-.95-.68L21 7l-8.06 21.35A1 1 0 0 1 12 29z"}),props.children);});var Activity16=/*#__PURE__*/React.forwardRef(function Activity16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 29a1 1 0 0 1-.92-.62L6.33 17H2v-2h5a1 1 0 0 1 .92.62L12 25.28l8.06-21.63A1 1 0 0 1 21 3a1 1 0 0 1 .93.68L25.72 15H30v2h-5a1 1 0 0 1-.95-.68L21 7l-8.06 21.35A1 1 0 0 1 12 29z"}),props.children);});var AddAlt32=/*#__PURE__*/React.forwardRef(function AddAlt32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 4A12 12 0 1 1 4 16 12 12 0 0 1 16 4m0-2a14 14 0 1 0 14 14A14 14 0 0 0 16 2z"}),React.createElement("path",{d:"M22 15h-5v-5h-2v5h-5v2h5v5h2v-5h5v-2z"}),props.children);});var AddAlt24=/*#__PURE__*/React.forwardRef(function AddAlt24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 4A12 12 0 1 1 4 16 12 12 0 0 1 16 4m0-2a14 14 0 1 0 14 14A14 14 0 0 0 16 2z"}),React.createElement("path",{d:"M22 15h-5v-5h-2v5h-5v2h5v5h2v-5h5v-2z"}),props.children);});var AddAlt20=/*#__PURE__*/React.forwardRef(function AddAlt20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 4A12 12 0 1 1 4 16 12 12 0 0 1 16 4m0-2a14 14 0 1 0 14 14A14 14 0 0 0 16 2z"}),React.createElement("path",{d:"M22 15h-5v-5h-2v5h-5v2h5v5h2v-5h5v-2z"}),props.children);});var AddFilled32=/*#__PURE__*/React.forwardRef(function AddFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2C8.4 2 2 8.4 2 16s6.4 14 14 14 14-6.4 14-14S23.6 2 16 2zm6 15h-5v5h-2v-5h-5v-2h5v-5h2v5h5v2z"}),React.createElement("path",{d:"M22 17h-5v5h-2v-5h-5v-2h5v-5h2v5h5z","data-icon-path":"inner-path",opacity:"0"}),props.children);});var AddFilled24=/*#__PURE__*/React.forwardRef(function AddFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2C8.4 2 2 8.4 2 16s6.4 14 14 14 14-6.4 14-14S23.6 2 16 2zm6 15h-5v5h-2v-5h-5v-2h5v-5h2v5h5v2z"}),React.createElement("path",{d:"M22 17h-5v5h-2v-5h-5v-2h5v-5h2v5h5z","data-icon-path":"inner-path",opacity:"0"}),props.children);});var AddFilled20=/*#__PURE__*/React.forwardRef(function AddFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2C8.4 2 2 8.4 2 16s6.4 14 14 14 14-6.4 14-14S23.6 2 16 2zm6 15h-5v5h-2v-5h-5v-2h5v-5h2v5h5v2z"}),React.createElement("path",{d:"M22 17h-5v5h-2v-5h-5v-2h5v-5h2v5h5z","data-icon-path":"inner-path",opacity:"0"}),props.children);});var AddComment32=/*#__PURE__*/React.forwardRef(function AddComment32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17.74 30L16 29l4-7h6a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h9v2H6a4 4 0 0 1-4-4V8a4 4 0 0 1 4-4h20a4 4 0 0 1 4 4v12a4 4 0 0 1-4 4h-4.84z"}),React.createElement("path",{d:"M17 9h-2v4h-4v2h4v4h2v-4h4v-2h-4V9z"}),props.children);});var AddComment24=/*#__PURE__*/React.forwardRef(function AddComment24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17.74 30L16 29l4-7h6a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h9v2H6a4 4 0 0 1-4-4V8a4 4 0 0 1 4-4h20a4 4 0 0 1 4 4v12a4 4 0 0 1-4 4h-4.84z"}),React.createElement("path",{d:"M17 9h-2v4h-4v2h4v4h2v-4h4v-2h-4V9z"}),props.children);});var AddComment20=/*#__PURE__*/React.forwardRef(function AddComment20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17.74 30L16 29l4-7h6a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h9v2H6a4 4 0 0 1-4-4V8a4 4 0 0 1 4-4h20a4 4 0 0 1 4 4v12a4 4 0 0 1-4 4h-4.84z"}),React.createElement("path",{d:"M17 9h-2v4h-4v2h4v4h2v-4h4v-2h-4V9z"}),props.children);});var AddComment16=/*#__PURE__*/React.forwardRef(function AddComment16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17.74 30L16 29l4-7h6a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h9v2H6a4 4 0 0 1-4-4V8a4 4 0 0 1 4-4h20a4 4 0 0 1 4 4v12a4 4 0 0 1-4 4h-4.84z"}),React.createElement("path",{d:"M17 9h-2v4h-4v2h4v4h2v-4h4v-2h-4V9z"}),props.children);});var Add32=/*#__PURE__*/React.forwardRef(function Add32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17 15V7h-2v8H7v2h8v8h2v-8h8v-2h-8z"}),props.children);});var Add24=/*#__PURE__*/React.forwardRef(function Add24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17 15V7h-2v8H7v2h8v8h2v-8h8v-2h-8z"}),props.children);});var Add20=/*#__PURE__*/React.forwardRef(function Add20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17 15V7h-2v8H7v2h8v8h2v-8h8v-2h-8z"}),props.children);});var AlarmAdd32=/*#__PURE__*/React.forwardRef(function AlarmAdd32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 28a11 11 0 1 1 11-11 11 11 0 0 1-11 11zm0-20a9 9 0 1 0 9 9 9 9 0 0 0-9-9zM4 7.592l3.582-3.589 1.416 1.413-3.582 3.589zm19-2.184l1.415-1.413 3.581 3.589-1.415 1.413z"}),React.createElement("path",{d:"M21 16h-4v-4h-2v4h-4v2h4v4h2v-4h4v-2z"}),props.children);});var AlarmAdd24=/*#__PURE__*/React.forwardRef(function AlarmAdd24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 28a11 11 0 1 1 11-11 11 11 0 0 1-11 11zm0-20a9 9 0 1 0 9 9 9 9 0 0 0-9-9zM4 7.592l3.582-3.589 1.416 1.413-3.582 3.589zm19-2.184l1.415-1.413 3.581 3.589-1.415 1.413z"}),React.createElement("path",{d:"M21 16h-4v-4h-2v4h-4v2h4v4h2v-4h4v-2z"}),props.children);});var AlarmAdd20=/*#__PURE__*/React.forwardRef(function AlarmAdd20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 28a11 11 0 1 1 11-11 11 11 0 0 1-11 11zm0-20a9 9 0 1 0 9 9 9 9 0 0 0-9-9zM4 7.592l3.582-3.589 1.416 1.413-3.582 3.589zm19-2.184l1.415-1.413 3.581 3.589-1.415 1.413z"}),React.createElement("path",{d:"M21 16h-4v-4h-2v4h-4v2h4v4h2v-4h4v-2z"}),props.children);});var AlarmAdd16=/*#__PURE__*/React.forwardRef(function AlarmAdd16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 28a11 11 0 1 1 11-11 11 11 0 0 1-11 11zm0-20a9 9 0 1 0 9 9 9 9 0 0 0-9-9zM4 7.592l3.582-3.589 1.416 1.413-3.582 3.589zm19-2.184l1.415-1.413 3.581 3.589-1.415 1.413z"}),React.createElement("path",{d:"M21 16h-4v-4h-2v4h-4v2h4v4h2v-4h4v-2z"}),props.children);});var AlarmSubtract32=/*#__PURE__*/React.forwardRef(function AlarmSubtract32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 28a11 11 0 1 1 11-11 11 11 0 0 1-11 11zm0-20a9 9 0 1 0 9 9 9 9 0 0 0-9-9zM4 7.592l3.582-3.589 1.416 1.413-3.582 3.589zm19-2.184l1.415-1.413 3.581 3.589-1.415 1.413z"}),React.createElement("path",{d:"M11 16h10v2H11z"}),props.children);});var AlarmSubtract24=/*#__PURE__*/React.forwardRef(function AlarmSubtract24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 28a11 11 0 1 1 11-11 11 11 0 0 1-11 11zm0-20a9 9 0 1 0 9 9 9 9 0 0 0-9-9zM4 7.592l3.582-3.589 1.416 1.413-3.582 3.589zm19-2.184l1.415-1.413 3.581 3.589-1.415 1.413z"}),React.createElement("path",{d:"M11 16h10v2H11z"}),props.children);});var AlarmSubtract20=/*#__PURE__*/React.forwardRef(function AlarmSubtract20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 28a11 11 0 1 1 11-11 11 11 0 0 1-11 11zm0-20a9 9 0 1 0 9 9 9 9 0 0 0-9-9zM4 7.592l3.582-3.589 1.416 1.413-3.582 3.589zm19-2.184l1.415-1.413 3.581 3.589-1.415 1.413z"}),React.createElement("path",{d:"M11 16h10v2H11z"}),props.children);});var AlarmSubtract16=/*#__PURE__*/React.forwardRef(function AlarmSubtract16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 28a11 11 0 1 1 11-11 11 11 0 0 1-11 11zm0-20a9 9 0 1 0 9 9 9 9 0 0 0-9-9zM4 7.592l3.582-3.589 1.416 1.413-3.582 3.589zm19-2.184l1.415-1.413 3.581 3.589-1.415 1.413z"}),React.createElement("path",{d:"M11 16h10v2H11z"}),props.children);});var Alarm32=/*#__PURE__*/React.forwardRef(function Alarm32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 28a11 11 0 1 1 11-11 11 11 0 0 1-11 11zm0-20a9 9 0 1 0 9 9 9 9 0 0 0-9-9z"}),React.createElement("path",{d:"M18.59 21L15 17.41V11h2v5.58l3 3.01L18.59 21zM4 7.592l3.582-3.589 1.416 1.413-3.582 3.589zm19-2.184l1.415-1.413 3.581 3.589-1.415 1.413z"}),props.children);});var Alarm24=/*#__PURE__*/React.forwardRef(function Alarm24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 28a11 11 0 1 1 11-11 11 11 0 0 1-11 11zm0-20a9 9 0 1 0 9 9 9 9 0 0 0-9-9z"}),React.createElement("path",{d:"M18.59 21L15 17.41V11h2v5.58l3 3.01L18.59 21zM4 7.592l3.582-3.589 1.416 1.413-3.582 3.589zm19-2.184l1.415-1.413 3.581 3.589-1.415 1.413z"}),props.children);});var Alarm20=/*#__PURE__*/React.forwardRef(function Alarm20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 28a11 11 0 1 1 11-11 11 11 0 0 1-11 11zm0-20a9 9 0 1 0 9 9 9 9 0 0 0-9-9z"}),React.createElement("path",{d:"M18.59 21L15 17.41V11h2v5.58l3 3.01L18.59 21zM4 7.592l3.582-3.589 1.416 1.413-3.582 3.589zm19-2.184l1.415-1.413 3.581 3.589-1.415 1.413z"}),props.children);});var Alarm16=/*#__PURE__*/React.forwardRef(function Alarm16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 28a11 11 0 1 1 11-11 11 11 0 0 1-11 11zm0-20a9 9 0 1 0 9 9 9 9 0 0 0-9-9z"}),React.createElement("path",{d:"M18.59 21L15 17.41V11h2v5.58l3 3.01L18.59 21zM4 7.592l3.582-3.589 1.416 1.413-3.582 3.589zm19-2.184l1.415-1.413 3.581 3.589-1.415 1.413z"}),props.children);});var Analytics32=/*#__PURE__*/React.forwardRef(function Analytics32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4 2H2v26a2 2 0 0 0 2 2h26v-2H4z"}),React.createElement("path",{d:"M30 9h-7v2h3.59L19 18.59l-4.29-4.3a1 1 0 0 0-1.42 0L6 21.59 7.41 23 14 16.41l4.29 4.3a1 1 0 0 0 1.42 0l8.29-8.3V16h2z"}),props.children);});var Analytics24=/*#__PURE__*/React.forwardRef(function Analytics24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4 2H2v26a2 2 0 0 0 2 2h26v-2H4z"}),React.createElement("path",{d:"M30 9h-7v2h3.59L19 18.59l-4.29-4.3a1 1 0 0 0-1.42 0L6 21.59 7.41 23 14 16.41l4.29 4.3a1 1 0 0 0 1.42 0l8.29-8.3V16h2z"}),props.children);});var Analytics20=/*#__PURE__*/React.forwardRef(function Analytics20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4 2H2v26a2 2 0 0 0 2 2h26v-2H4z"}),React.createElement("path",{d:"M30 9h-7v2h3.59L19 18.59l-4.29-4.3a1 1 0 0 0-1.42 0L6 21.59 7.41 23 14 16.41l4.29 4.3a1 1 0 0 0 1.42 0l8.29-8.3V16h2z"}),props.children);});var Analytics16=/*#__PURE__*/React.forwardRef(function Analytics16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4 2H2v26a2 2 0 0 0 2 2h26v-2H4z"}),React.createElement("path",{d:"M30 9h-7v2h3.59L19 18.59l-4.29-4.3a1 1 0 0 0-1.42 0L6 21.59 7.41 23 14 16.41l4.29 4.3a1 1 0 0 0 1.42 0l8.29-8.3V16h2z"}),props.children);});var Aperture32=/*#__PURE__*/React.forwardRef(function Aperture32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm11.84 12.14L22 17.52V5.62a12 12 0 0 1 5.84 8.52zM12 18.68v-5.36L16 11l4 2.31v5.36L16 21zm8-14V11l-9.66-5.58A11.9 11.9 0 0 1 20 4.7zm-11.52 2L14 9.85 4 15.62a12 12 0 0 1 4.48-8.96zM4.16 17.85L10 14.47v11.91a12 12 0 0 1-5.84-8.53zM12 27.3V21l9.67 5.58A11.92 11.92 0 0 1 16 28a12.05 12.05 0 0 1-4-.7zm11.52-2L18 22.14l10-5.77a12 12 0 0 1-4.48 8.97z"}),props.children);});var Aperture24=/*#__PURE__*/React.forwardRef(function Aperture24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm11.84 12.14L22 17.52V5.62a12 12 0 0 1 5.84 8.52zM12 18.68v-5.36L16 11l4 2.31v5.36L16 21zm8-14V11l-9.66-5.58A11.9 11.9 0 0 1 20 4.7zm-11.52 2L14 9.85 4 15.62a12 12 0 0 1 4.48-8.96zM4.16 17.85L10 14.47v11.91a12 12 0 0 1-5.84-8.53zM12 27.3V21l9.67 5.58A11.92 11.92 0 0 1 16 28a12.05 12.05 0 0 1-4-.7zm11.52-2L18 22.14l10-5.77a12 12 0 0 1-4.48 8.97z"}),props.children);});var Aperture20=/*#__PURE__*/React.forwardRef(function Aperture20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm11.84 12.14L22 17.52V5.62a12 12 0 0 1 5.84 8.52zM12 18.68v-5.36L16 11l4 2.31v5.36L16 21zm8-14V11l-9.66-5.58A11.9 11.9 0 0 1 20 4.7zm-11.52 2L14 9.85 4 15.62a12 12 0 0 1 4.48-8.96zM4.16 17.85L10 14.47v11.91a12 12 0 0 1-5.84-8.53zM12 27.3V21l9.67 5.58A11.92 11.92 0 0 1 16 28a12.05 12.05 0 0 1-4-.7zm11.52-2L18 22.14l10-5.77a12 12 0 0 1-4.48 8.97z"}),props.children);});var Aperture16=/*#__PURE__*/React.forwardRef(function Aperture16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm11.84 12.14L22 17.52V5.62a12 12 0 0 1 5.84 8.52zM12 18.68v-5.36L16 11l4 2.31v5.36L16 21zm8-14V11l-9.66-5.58A11.9 11.9 0 0 1 20 4.7zm-11.52 2L14 9.85 4 15.62a12 12 0 0 1 4.48-8.96zM4.16 17.85L10 14.47v11.91a12 12 0 0 1-5.84-8.53zM12 27.3V21l9.67 5.58A11.92 11.92 0 0 1 16 28a12.05 12.05 0 0 1-4-.7zm11.52-2L18 22.14l10-5.77a12 12 0 0 1-4.48 8.97z"}),props.children);});var Api32=/*#__PURE__*/React.forwardRef(function Api32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 22a3.86 3.86 0 0 0-2 .57l-3.09-3.1a6 6 0 0 0 0-6.94L24 9.43a3.86 3.86 0 0 0 2 .57 4 4 0 1 0-4-4 3.86 3.86 0 0 0 .57 2l-3.1 3.09a6 6 0 0 0-6.94 0L9.43 8A3.86 3.86 0 0 0 10 6a4 4 0 1 0-4 4 3.86 3.86 0 0 0 2-.57l3.09 3.1a6 6 0 0 0 0 6.94L8 22.57A3.86 3.86 0 0 0 6 22a4 4 0 1 0 4 4 3.86 3.86 0 0 0-.57-2l3.1-3.09a6 6 0 0 0 6.94 0l3.1 3.09a3.86 3.86 0 0 0-.57 2 4 4 0 1 0 4-4zm0-18a2 2 0 1 1-2 2 2 2 0 0 1 2-2zM4 6a2 2 0 1 1 2 2 2 2 0 0 1-2-2zm2 22a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm10-8a4 4 0 1 1 4-4 4 4 0 0 1-4 4zm10 8a2 2 0 1 1 2-2 2 2 0 0 1-2 2z"}),props.children);});var Api24=/*#__PURE__*/React.forwardRef(function Api24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 22a3.86 3.86 0 0 0-2 .57l-3.09-3.1a6 6 0 0 0 0-6.94L24 9.43a3.86 3.86 0 0 0 2 .57 4 4 0 1 0-4-4 3.86 3.86 0 0 0 .57 2l-3.1 3.09a6 6 0 0 0-6.94 0L9.43 8A3.86 3.86 0 0 0 10 6a4 4 0 1 0-4 4 3.86 3.86 0 0 0 2-.57l3.09 3.1a6 6 0 0 0 0 6.94L8 22.57A3.86 3.86 0 0 0 6 22a4 4 0 1 0 4 4 3.86 3.86 0 0 0-.57-2l3.1-3.09a6 6 0 0 0 6.94 0l3.1 3.09a3.86 3.86 0 0 0-.57 2 4 4 0 1 0 4-4zm0-18a2 2 0 1 1-2 2 2 2 0 0 1 2-2zM4 6a2 2 0 1 1 2 2 2 2 0 0 1-2-2zm2 22a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm10-8a4 4 0 1 1 4-4 4 4 0 0 1-4 4zm10 8a2 2 0 1 1 2-2 2 2 0 0 1-2 2z"}),props.children);});var Api20=/*#__PURE__*/React.forwardRef(function Api20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 22a3.86 3.86 0 0 0-2 .57l-3.09-3.1a6 6 0 0 0 0-6.94L24 9.43a3.86 3.86 0 0 0 2 .57 4 4 0 1 0-4-4 3.86 3.86 0 0 0 .57 2l-3.1 3.09a6 6 0 0 0-6.94 0L9.43 8A3.86 3.86 0 0 0 10 6a4 4 0 1 0-4 4 3.86 3.86 0 0 0 2-.57l3.09 3.1a6 6 0 0 0 0 6.94L8 22.57A3.86 3.86 0 0 0 6 22a4 4 0 1 0 4 4 3.86 3.86 0 0 0-.57-2l3.1-3.09a6 6 0 0 0 6.94 0l3.1 3.09a3.86 3.86 0 0 0-.57 2 4 4 0 1 0 4-4zm0-18a2 2 0 1 1-2 2 2 2 0 0 1 2-2zM4 6a2 2 0 1 1 2 2 2 2 0 0 1-2-2zm2 22a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm10-8a4 4 0 1 1 4-4 4 4 0 0 1-4 4zm10 8a2 2 0 1 1 2-2 2 2 0 0 1-2 2z"}),props.children);});var Api16=/*#__PURE__*/React.forwardRef(function Api16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 22a3.86 3.86 0 0 0-2 .57l-3.09-3.1a6 6 0 0 0 0-6.94L24 9.43a3.86 3.86 0 0 0 2 .57 4 4 0 1 0-4-4 3.86 3.86 0 0 0 .57 2l-3.1 3.09a6 6 0 0 0-6.94 0L9.43 8A3.86 3.86 0 0 0 10 6a4 4 0 1 0-4 4 3.86 3.86 0 0 0 2-.57l3.09 3.1a6 6 0 0 0 0 6.94L8 22.57A3.86 3.86 0 0 0 6 22a4 4 0 1 0 4 4 3.86 3.86 0 0 0-.57-2l3.1-3.09a6 6 0 0 0 6.94 0l3.1 3.09a3.86 3.86 0 0 0-.57 2 4 4 0 1 0 4-4zm0-18a2 2 0 1 1-2 2 2 2 0 0 1 2-2zM4 6a2 2 0 1 1 2 2 2 2 0 0 1-2-2zm2 22a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm10-8a4 4 0 1 1 4-4 4 4 0 0 1-4 4zm10 8a2 2 0 1 1 2-2 2 2 0 0 1-2 2z"}),props.children);});var AppSwitcher32=/*#__PURE__*/React.forwardRef(function AppSwitcher32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M14 5h4v4h-4zM5 5h4v4H5zm18 0h4v4h-4zm-9 9h4v4h-4zm-9 0h4v4H5zm18 0h4v4h-4zm-9 9h4v4h-4zm-9 0h4v4H5zm18 0h4v4h-4z"}),props.children);});var Application32=/*#__PURE__*/React.forwardRef(function Application32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 18H6a2 2 0 0 1-2-2V6a2 2 0 0 1 2-2h10a2 2 0 0 1 2 2v10a2 2 0 0 1-2 2zM6 6v10h10V6zm20 6v4h-4v-4h4m0-2h-4a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2v-4a2 2 0 0 0-2-2zm0 12v4h-4v-4h4m0-2h-4a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2v-4a2 2 0 0 0-2-2zm-10 2v4h-4v-4h4m0-2h-4a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2v-4a2 2 0 0 0-2-2z"}),props.children);});var Application24=/*#__PURE__*/React.forwardRef(function Application24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 18H6a2 2 0 0 1-2-2V6a2 2 0 0 1 2-2h10a2 2 0 0 1 2 2v10a2 2 0 0 1-2 2zM6 6v10h10V6zm20 6v4h-4v-4h4m0-2h-4a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2v-4a2 2 0 0 0-2-2zm0 12v4h-4v-4h4m0-2h-4a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2v-4a2 2 0 0 0-2-2zm-10 2v4h-4v-4h4m0-2h-4a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2v-4a2 2 0 0 0-2-2z"}),props.children);});var Application20=/*#__PURE__*/React.forwardRef(function Application20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 18H6a2 2 0 0 1-2-2V6a2 2 0 0 1 2-2h10a2 2 0 0 1 2 2v10a2 2 0 0 1-2 2zM6 6v10h10V6zm20 6v4h-4v-4h4m0-2h-4a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2v-4a2 2 0 0 0-2-2zm0 12v4h-4v-4h4m0-2h-4a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2v-4a2 2 0 0 0-2-2zm-10 2v4h-4v-4h4m0-2h-4a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2v-4a2 2 0 0 0-2-2z"}),props.children);});var Application16=/*#__PURE__*/React.forwardRef(function Application16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 18H6a2 2 0 0 1-2-2V6a2 2 0 0 1 2-2h10a2 2 0 0 1 2 2v10a2 2 0 0 1-2 2zM6 6v10h10V6zm20 6v4h-4v-4h4m0-2h-4a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2v-4a2 2 0 0 0-2-2zm0 12v4h-4v-4h4m0-2h-4a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2v-4a2 2 0 0 0-2-2zm-10 2v4h-4v-4h4m0-2h-4a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2v-4a2 2 0 0 0-2-2z"}),props.children);});var Apps32=/*#__PURE__*/React.forwardRef(function Apps32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8 4v4H4V4h4zm2-2H2v8h8V2zm8 2v4h-4V4h4zm2-2h-8v8h8V2zm8 2v4h-4V4h4zm2-2h-8v8h8V2zM8 14v4H4v-4h4zm2-2H2v8h8v-8zm8 2v4h-4v-4h4zm2-2h-8v8h8v-8zm8 2v4h-4v-4h4zm2-2h-8v8h8v-8zM8 24v4H4v-4h4zm2-2H2v8h8v-8zm8 2v4h-4v-4h4zm2-2h-8v8h8v-8zm8 2v4h-4v-4h4zm2-2h-8v8h8v-8z"}),props.children);});var Apps24=/*#__PURE__*/React.forwardRef(function Apps24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8 4v4H4V4h4zm2-2H2v8h8V2zm8 2v4h-4V4h4zm2-2h-8v8h8V2zm8 2v4h-4V4h4zm2-2h-8v8h8V2zM8 14v4H4v-4h4zm2-2H2v8h8v-8zm8 2v4h-4v-4h4zm2-2h-8v8h8v-8zm8 2v4h-4v-4h4zm2-2h-8v8h8v-8zM8 24v4H4v-4h4zm2-2H2v8h8v-8zm8 2v4h-4v-4h4zm2-2h-8v8h8v-8zm8 2v4h-4v-4h4zm2-2h-8v8h8v-8z"}),props.children);});var Apps20=/*#__PURE__*/React.forwardRef(function Apps20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8 4v4H4V4h4zm2-2H2v8h8V2zm8 2v4h-4V4h4zm2-2h-8v8h8V2zm8 2v4h-4V4h4zm2-2h-8v8h8V2zM8 14v4H4v-4h4zm2-2H2v8h8v-8zm8 2v4h-4v-4h4zm2-2h-8v8h8v-8zm8 2v4h-4v-4h4zm2-2h-8v8h8v-8zM8 24v4H4v-4h4zm2-2H2v8h8v-8zm8 2v4h-4v-4h4zm2-2h-8v8h8v-8zm8 2v4h-4v-4h4zm2-2h-8v8h8v-8z"}),props.children);});var Archive32=/*#__PURE__*/React.forwardRef(function Archive32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M14 19h4v2h-4z"}),React.createElement("path",{d:"M6 2v26a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V2zm18 26H8V16h16zm0-14H8v-4h16zM8 8V4h16v4z"}),props.children);});var Archive24=/*#__PURE__*/React.forwardRef(function Archive24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M14 19h4v2h-4z"}),React.createElement("path",{d:"M6 2v26a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V2zm18 26H8V16h16zm0-14H8v-4h16zM8 8V4h16v4z"}),props.children);});var Archive20=/*#__PURE__*/React.forwardRef(function Archive20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M14 19h4v2h-4z"}),React.createElement("path",{d:"M6 2v26a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V2zm18 26H8V16h16zm0-14H8v-4h16zM8 8V4h16v4z"}),props.children);});var Archive16=/*#__PURE__*/React.forwardRef(function Archive16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M14 19h4v2h-4z"}),React.createElement("path",{d:"M6 2v26a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V2zm18 26H8V16h16zm0-14H8v-4h16zM8 8V4h16v4z"}),props.children);});var Arrival32=/*#__PURE__*/React.forwardRef(function Arrival32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2 28h28v2H2zM17.21 5.23l1.39.38 1 11.29 5.87 1.57A2 2 0 0 1 27 20.62a1.88 1.88 0 0 1-1.37 1.52 2 2 0 0 1-1 0l-18.7-5a1.89 1.89 0 0 1-1.33-2.3l1.75-6.5 1.44.38.61 5.18 6 1.62 2.81-10.29m-1-2.2a1 1 0 0 0-.68.69L13 13.07l-2.81-.75-.5-4.53A1 1 0 0 0 9 7l-3.13-.86a.94.94 0 0 0-.5 0 1 1 0 0 0-.68.68l-2 7.49a3.87 3.87 0 0 0 2.74 4.74l18.71 5A3.87 3.87 0 0 0 29 21a4 4 0 0 0-3-4.42l-4.52-1.21-.95-10.66a1 1 0 0 0-.72-.85L16.73 3a1.06 1.06 0 0 0-.5 0z"}),props.children);});var Arrival24=/*#__PURE__*/React.forwardRef(function Arrival24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2 28h28v2H2zM17.21 5.23l1.39.38 1 11.29 5.87 1.57A2 2 0 0 1 27 20.62a1.88 1.88 0 0 1-1.37 1.52 2 2 0 0 1-1 0l-18.7-5a1.89 1.89 0 0 1-1.33-2.3l1.75-6.5 1.44.38.61 5.18 6 1.62 2.81-10.29m-1-2.2a1 1 0 0 0-.68.69L13 13.07l-2.81-.75-.5-4.53A1 1 0 0 0 9 7l-3.13-.86a.94.94 0 0 0-.5 0 1 1 0 0 0-.68.68l-2 7.49a3.87 3.87 0 0 0 2.74 4.74l18.71 5A3.87 3.87 0 0 0 29 21a4 4 0 0 0-3-4.42l-4.52-1.21-.95-10.66a1 1 0 0 0-.72-.85L16.73 3a1.06 1.06 0 0 0-.5 0z"}),props.children);});var Arrival20=/*#__PURE__*/React.forwardRef(function Arrival20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2 28h28v2H2zM17.21 5.23l1.39.38 1 11.29 5.87 1.57A2 2 0 0 1 27 20.62a1.88 1.88 0 0 1-1.37 1.52 2 2 0 0 1-1 0l-18.7-5a1.89 1.89 0 0 1-1.33-2.3l1.75-6.5 1.44.38.61 5.18 6 1.62 2.81-10.29m-1-2.2a1 1 0 0 0-.68.69L13 13.07l-2.81-.75-.5-4.53A1 1 0 0 0 9 7l-3.13-.86a.94.94 0 0 0-.5 0 1 1 0 0 0-.68.68l-2 7.49a3.87 3.87 0 0 0 2.74 4.74l18.71 5A3.87 3.87 0 0 0 29 21a4 4 0 0 0-3-4.42l-4.52-1.21-.95-10.66a1 1 0 0 0-.72-.85L16.73 3a1.06 1.06 0 0 0-.5 0z"}),props.children);});var Arrival16=/*#__PURE__*/React.forwardRef(function Arrival16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2 28h28v2H2zM17.21 5.23l1.39.38 1 11.29 5.87 1.57A2 2 0 0 1 27 20.62a1.88 1.88 0 0 1-1.37 1.52 2 2 0 0 1-1 0l-18.7-5a1.89 1.89 0 0 1-1.33-2.3l1.75-6.5 1.44.38.61 5.18 6 1.62 2.81-10.29m-1-2.2a1 1 0 0 0-.68.69L13 13.07l-2.81-.75-.5-4.53A1 1 0 0 0 9 7l-3.13-.86a.94.94 0 0 0-.5 0 1 1 0 0 0-.68.68l-2 7.49a3.87 3.87 0 0 0 2.74 4.74l18.71 5A3.87 3.87 0 0 0 29 21a4 4 0 0 0-3-4.42l-4.52-1.21-.95-10.66a1 1 0 0 0-.72-.85L16.73 3a1.06 1.06 0 0 0-.5 0z"}),props.children);});var ArrowDownLeft32=/*#__PURE__*/React.forwardRef(function ArrowDownLeft32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22 26v-2H9.41L26 7.41 24.59 6 8 22.59V10H6v16h16z"}),props.children);});var ArrowDownLeft24=/*#__PURE__*/React.forwardRef(function ArrowDownLeft24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22 26v-2H9.41L26 7.41 24.59 6 8 22.59V10H6v16h16z"}),props.children);});var ArrowDownLeft20=/*#__PURE__*/React.forwardRef(function ArrowDownLeft20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22 26v-2H9.41L26 7.41 24.59 6 8 22.59V10H6v16h16z"}),props.children);});var ArrowDownLeft16=/*#__PURE__*/React.forwardRef(function ArrowDownLeft16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22 26v-2H9.41L26 7.41 24.59 6 8 22.59V10H6v16h16z"}),props.children);});var ArrowDownRight32=/*#__PURE__*/React.forwardRef(function ArrowDownRight32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 26v-2h12.59L6 7.41 7.41 6 24 22.59V10h2v16H10z"}),props.children);});var ArrowDownRight24=/*#__PURE__*/React.forwardRef(function ArrowDownRight24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 26v-2h12.59L6 7.41 7.41 6 24 22.59V10h2v16H10z"}),props.children);});var ArrowDownRight20=/*#__PURE__*/React.forwardRef(function ArrowDownRight20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 26v-2h12.59L6 7.41 7.41 6 24 22.59V10h2v16H10z"}),props.children);});var ArrowDownRight16=/*#__PURE__*/React.forwardRef(function ArrowDownRight16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 26v-2h12.59L6 7.41 7.41 6 24 22.59V10h2v16H10z"}),props.children);});var ArrowDown32=/*#__PURE__*/React.forwardRef(function ArrowDown32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24.59 16.59L17 24.17V2h-2v22.17l-7.59-7.58L6 18l10 10 10-10-1.41-1.41z"}),props.children);});var ArrowDown24=/*#__PURE__*/React.forwardRef(function ArrowDown24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24.59 16.59L17 24.17V2h-2v22.17l-7.59-7.58L6 18l10 10 10-10-1.41-1.41z"}),props.children);});var ArrowDown20=/*#__PURE__*/React.forwardRef(function ArrowDown20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24.59 16.59L17 24.17V2h-2v22.17l-7.59-7.58L6 18l10 10 10-10-1.41-1.41z"}),props.children);});var ArrowLeft32=/*#__PURE__*/React.forwardRef(function ArrowLeft32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13 26l1.41-1.41L6.83 17H29v-2H6.83l7.58-7.59L13 6 3 16l10 10z"}),props.children);});var ArrowLeft24=/*#__PURE__*/React.forwardRef(function ArrowLeft24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13 26l1.41-1.41L6.83 17H29v-2H6.83l7.58-7.59L13 6 3 16l10 10z"}),props.children);});var ArrowLeft20=/*#__PURE__*/React.forwardRef(function ArrowLeft20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13 26l1.41-1.41L6.83 17H29v-2H6.83l7.58-7.59L13 6 3 16l10 10z"}),props.children);});var ArrowRight32=/*#__PURE__*/React.forwardRef(function ArrowRight32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 6l-1.4 1.4 7.5 7.6H3v2h21.1l-7.5 7.6L18 26l10-10z"}),props.children);});var ArrowUpLeft32=/*#__PURE__*/React.forwardRef(function ArrowUpLeft32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22 6v2H9.41L26 24.59 24.59 26 8 9.41V22H6V6h16z"}),props.children);});var ArrowUpLeft24=/*#__PURE__*/React.forwardRef(function ArrowUpLeft24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22 6v2H9.41L26 24.59 24.59 26 8 9.41V22H6V6h16z"}),props.children);});var ArrowUpLeft20=/*#__PURE__*/React.forwardRef(function ArrowUpLeft20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22 6v2H9.41L26 24.59 24.59 26 8 9.41V22H6V6h16z"}),props.children);});var ArrowUpLeft16=/*#__PURE__*/React.forwardRef(function ArrowUpLeft16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22 6v2H9.41L26 24.59 24.59 26 8 9.41V22H6V6h16z"}),props.children);});var ArrowUpRight32=/*#__PURE__*/React.forwardRef(function ArrowUpRight32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 6v2h12.59L6 24.59 7.41 26 24 9.41V22h2V6H10z"}),props.children);});var ArrowUpRight24=/*#__PURE__*/React.forwardRef(function ArrowUpRight24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 6v2h12.59L6 24.59 7.41 26 24 9.41V22h2V6H10z"}),props.children);});var ArrowUpRight20=/*#__PURE__*/React.forwardRef(function ArrowUpRight20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 6v2h12.59L6 24.59 7.41 26 24 9.41V22h2V6H10z"}),props.children);});var ArrowUpRight16=/*#__PURE__*/React.forwardRef(function ArrowUpRight16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 6v2h12.59L6 24.59 7.41 26 24 9.41V22h2V6H10z"}),props.children);});var ArrowUp32=/*#__PURE__*/React.forwardRef(function ArrowUp32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 4L6 14l1.41 1.41L15 7.83V30h2V7.83l7.59 7.58L26 14 16 4z"}),props.children);});var ArrowUp24=/*#__PURE__*/React.forwardRef(function ArrowUp24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 4L6 14l1.41 1.41L15 7.83V30h2V7.83l7.59 7.58L26 14 16 4z"}),props.children);});var ArrowUp20=/*#__PURE__*/React.forwardRef(function ArrowUp20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 4L6 14l1.41 1.41L15 7.83V30h2V7.83l7.59 7.58L26 14 16 4z"}),props.children);});var ArrowsHorizontal32=/*#__PURE__*/React.forwardRef(function ArrowsHorizontal32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.41 26.59L7.83 23H28v-2H7.83l3.58-3.59L10 16l-6 6 6 6 1.41-1.41zM28 10l-6-6-1.41 1.41L24.17 9H4v2h20.17l-3.58 3.59L22 16l6-6z"}),props.children);});var ArrowsHorizontal24=/*#__PURE__*/React.forwardRef(function ArrowsHorizontal24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.41 26.59L7.83 23H28v-2H7.83l3.58-3.59L10 16l-6 6 6 6 1.41-1.41zM28 10l-6-6-1.41 1.41L24.17 9H4v2h20.17l-3.58 3.59L22 16l6-6z"}),props.children);});var ArrowsHorizontal20=/*#__PURE__*/React.forwardRef(function ArrowsHorizontal20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.41 26.59L7.83 23H28v-2H7.83l3.58-3.59L10 16l-6 6 6 6 1.41-1.41zM28 10l-6-6-1.41 1.41L24.17 9H4v2h20.17l-3.58 3.59L22 16l6-6z"}),props.children);});var ArrowsHorizontal16=/*#__PURE__*/React.forwardRef(function ArrowsHorizontal16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.41 26.59L7.83 23H28v-2H7.83l3.58-3.59L10 16l-6 6 6 6 1.41-1.41zM28 10l-6-6-1.41 1.41L24.17 9H4v2h20.17l-3.58 3.59L22 16l6-6z"}),props.children);});var ArrowsVertical32=/*#__PURE__*/React.forwardRef(function ArrowsVertical32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26.59 20.59L23 24.17V4h-2v20.17l-3.59-3.58L16 22l6 6 6-6-1.41-1.41zM10 4l-6 6 1.41 1.41L9 7.83V28h2V7.83l3.59 3.58L16 10l-6-6z"}),props.children);});var ArrowsVertical24=/*#__PURE__*/React.forwardRef(function ArrowsVertical24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26.59 20.59L23 24.17V4h-2v20.17l-3.59-3.58L16 22l6 6 6-6-1.41-1.41zM10 4l-6 6 1.41 1.41L9 7.83V28h2V7.83l3.59 3.58L16 10l-6-6z"}),props.children);});var ArrowsVertical20=/*#__PURE__*/React.forwardRef(function ArrowsVertical20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26.59 20.59L23 24.17V4h-2v20.17l-3.59-3.58L16 22l6 6 6-6-1.41-1.41zM10 4l-6 6 1.41 1.41L9 7.83V28h2V7.83l3.59 3.58L16 10l-6-6z"}),props.children);});var Arrows32=/*#__PURE__*/React.forwardRef(function Arrows32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26.6 20.6L23 24.2V4h-2v20.2l-3.6-3.6L16 22l6 6 6-6zM10 4l-6 6 1.4 1.4L9 7.8V28h2V7.8l3.6 3.6L16 10z"}),props.children);});var Arrows24=/*#__PURE__*/React.forwardRef(function Arrows24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26.6 20.6L23 24.2V4h-2v20.2l-3.6-3.6L16 22l6 6 6-6zM10 4l-6 6 1.4 1.4L9 7.8V28h2V7.8l3.6 3.6L16 10z"}),props.children);});var Arrows20=/*#__PURE__*/React.forwardRef(function Arrows20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26.6 20.6L23 24.2V4h-2v20.2l-3.6-3.6L16 22l6 6 6-6zM10 4l-6 6 1.4 1.4L9 7.8V28h2V7.8l3.6 3.6L16 10z"}),props.children);});var AsleepFilled32=/*#__PURE__*/React.forwardRef(function AsleepFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 3h-.2a13.09 13.09 0 0 0 1.82 26h.49a13.08 13.08 0 0 0 10.71-5.56 1 1 0 0 0-.82-1.56 13.08 13.08 0 0 1-11.12-17.5A1 1 0 0 0 15 3z"}),props.children);});var AsleepFilled24=/*#__PURE__*/React.forwardRef(function AsleepFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 3h-.2a13.09 13.09 0 0 0 1.82 26h.49a13.08 13.08 0 0 0 10.71-5.56 1 1 0 0 0-.82-1.56 13.08 13.08 0 0 1-11.12-17.5A1 1 0 0 0 15 3z"}),props.children);});var AsleepFilled20=/*#__PURE__*/React.forwardRef(function AsleepFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 3h-.2a13.09 13.09 0 0 0 1.82 26h.49a13.08 13.08 0 0 0 10.71-5.56 1 1 0 0 0-.82-1.56 13.08 13.08 0 0 1-11.12-17.5A1 1 0 0 0 15 3z"}),props.children);});var AsleepFilled16=/*#__PURE__*/React.forwardRef(function AsleepFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 3h-.2a13.09 13.09 0 0 0 1.82 26h.49a13.08 13.08 0 0 0 10.71-5.56 1 1 0 0 0-.82-1.56 13.08 13.08 0 0 1-11.12-17.5A1 1 0 0 0 15 3z"}),props.children);});var Asleep32=/*#__PURE__*/React.forwardRef(function Asleep32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13.49 5.41a15.08 15.08 0 0 0 11.6 18.2 11.09 11.09 0 0 1-8 3.39h-.42a11.1 11.1 0 0 1-3.2-21.59M15 3h-.2a13.09 13.09 0 0 0 1.82 26h.49a13.08 13.08 0 0 0 10.71-5.56 1 1 0 0 0-.82-1.56 13.08 13.08 0 0 1-11.12-17.5A1 1 0 0 0 15 3z"}),props.children);});var Asleep24=/*#__PURE__*/React.forwardRef(function Asleep24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13.49 5.41a15.08 15.08 0 0 0 11.6 18.2 11.09 11.09 0 0 1-8 3.39h-.42a11.1 11.1 0 0 1-3.2-21.59M15 3h-.2a13.09 13.09 0 0 0 1.82 26h.49a13.08 13.08 0 0 0 10.71-5.56 1 1 0 0 0-.82-1.56 13.08 13.08 0 0 1-11.12-17.5A1 1 0 0 0 15 3z"}),props.children);});var Asleep20=/*#__PURE__*/React.forwardRef(function Asleep20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13.49 5.41a15.08 15.08 0 0 0 11.6 18.2 11.09 11.09 0 0 1-8 3.39h-.42a11.1 11.1 0 0 1-3.2-21.59M15 3h-.2a13.09 13.09 0 0 0 1.82 26h.49a13.08 13.08 0 0 0 10.71-5.56 1 1 0 0 0-.82-1.56 13.08 13.08 0 0 1-11.12-17.5A1 1 0 0 0 15 3z"}),props.children);});var Asset32=/*#__PURE__*/React.forwardRef(function Asset32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12.075 24a4 4 0 1 1 4-4 4.004 4.004 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2z"}),React.createElement("path",{d:"M30 6a4.004 4.004 0 0 0-4-4 3.949 3.949 0 0 0-1.854.477l-16.389 8.48a9.992 9.992 0 1 0 13.309 13.236l8.49-16.4A3.95 3.95 0 0 0 30 6zm-4-2a2 2 0 1 1-2 2 2.002 2.002 0 0 1 2-2zm-3.98 1.808c-.004.065-.02.126-.02.192a4.004 4.004 0 0 0 4 4c.065 0 .124-.016.188-.019l-4.332 8.362a10.017 10.017 0 0 0-8.215-8.196zM12 28a8 8 0 1 1 8-8 8.01 8.01 0 0 1-8 8z"}),props.children);});var Asset24=/*#__PURE__*/React.forwardRef(function Asset24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12.075 24a4 4 0 1 1 4-4 4.004 4.004 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2z"}),React.createElement("path",{d:"M30 6a4.004 4.004 0 0 0-4-4 3.949 3.949 0 0 0-1.854.477l-16.389 8.48a9.992 9.992 0 1 0 13.309 13.236l8.49-16.4A3.95 3.95 0 0 0 30 6zm-4-2a2 2 0 1 1-2 2 2.002 2.002 0 0 1 2-2zm-3.98 1.808c-.004.065-.02.126-.02.192a4.004 4.004 0 0 0 4 4c.065 0 .124-.016.188-.019l-4.332 8.362a10.017 10.017 0 0 0-8.215-8.196zM12 28a8 8 0 1 1 8-8 8.01 8.01 0 0 1-8 8z"}),props.children);});var Asset20=/*#__PURE__*/React.forwardRef(function Asset20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12.075 24a4 4 0 1 1 4-4 4.004 4.004 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2z"}),React.createElement("path",{d:"M30 6a4.004 4.004 0 0 0-4-4 3.949 3.949 0 0 0-1.854.477l-16.389 8.48a9.992 9.992 0 1 0 13.309 13.236l8.49-16.4A3.95 3.95 0 0 0 30 6zm-4-2a2 2 0 1 1-2 2 2.002 2.002 0 0 1 2-2zm-3.98 1.808c-.004.065-.02.126-.02.192a4.004 4.004 0 0 0 4 4c.065 0 .124-.016.188-.019l-4.332 8.362a10.017 10.017 0 0 0-8.215-8.196zM12 28a8 8 0 1 1 8-8 8.01 8.01 0 0 1-8 8z"}),props.children);});var Asset16=/*#__PURE__*/React.forwardRef(function Asset16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12.075 24a4 4 0 1 1 4-4 4.004 4.004 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2z"}),React.createElement("path",{d:"M30 6a4.004 4.004 0 0 0-4-4 3.949 3.949 0 0 0-1.854.477l-16.389 8.48a9.992 9.992 0 1 0 13.309 13.236l8.49-16.4A3.95 3.95 0 0 0 30 6zm-4-2a2 2 0 1 1-2 2 2.002 2.002 0 0 1 2-2zm-3.98 1.808c-.004.065-.02.126-.02.192a4.004 4.004 0 0 0 4 4c.065 0 .124-.016.188-.019l-4.332 8.362a10.017 10.017 0 0 0-8.215-8.196zM12 28a8 8 0 1 1 8-8 8.01 8.01 0 0 1-8 8z"}),props.children);});var At32=/*#__PURE__*/React.forwardRef(function At32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 3A12.92 12.92 0 0 0 3 16v1a13 13 0 0 0 13 13h7v-2h-7A11 11 0 0 1 5 17v-1A10.94 10.94 0 0 1 16 5a10.64 10.64 0 0 1 11 11c0 3.59-1.4 5-3.66 5-1.58 0-2.34-1.29-2.34-3v-8h-2v1.94A3.84 3.84 0 0 0 15.5 10a5.48 5.48 0 0 0-5.5 5.44v2.12A5.48 5.48 0 0 0 15.5 23a4.28 4.28 0 0 0 4-2.46A4.35 4.35 0 0 0 23.41 23c3.07 0 5.59-2 5.59-7A12.72 12.72 0 0 0 16 3zm3 14.56a3.5 3.5 0 0 1-7 0v-2.12a3.5 3.5 0 0 1 7 0z"}),props.children);});var At24=/*#__PURE__*/React.forwardRef(function At24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 3A12.92 12.92 0 0 0 3 16v1a13 13 0 0 0 13 13h7v-2h-7A11 11 0 0 1 5 17v-1A10.94 10.94 0 0 1 16 5a10.64 10.64 0 0 1 11 11c0 3.59-1.4 5-3.66 5-1.58 0-2.34-1.29-2.34-3v-8h-2v1.94A3.84 3.84 0 0 0 15.5 10a5.48 5.48 0 0 0-5.5 5.44v2.12A5.48 5.48 0 0 0 15.5 23a4.28 4.28 0 0 0 4-2.46A4.35 4.35 0 0 0 23.41 23c3.07 0 5.59-2 5.59-7A12.72 12.72 0 0 0 16 3zm3 14.56a3.5 3.5 0 0 1-7 0v-2.12a3.5 3.5 0 0 1 7 0z"}),props.children);});var At20=/*#__PURE__*/React.forwardRef(function At20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 3A12.92 12.92 0 0 0 3 16v1a13 13 0 0 0 13 13h7v-2h-7A11 11 0 0 1 5 17v-1A10.94 10.94 0 0 1 16 5a10.64 10.64 0 0 1 11 11c0 3.59-1.4 5-3.66 5-1.58 0-2.34-1.29-2.34-3v-8h-2v1.94A3.84 3.84 0 0 0 15.5 10a5.48 5.48 0 0 0-5.5 5.44v2.12A5.48 5.48 0 0 0 15.5 23a4.28 4.28 0 0 0 4-2.46A4.35 4.35 0 0 0 23.41 23c3.07 0 5.59-2 5.59-7A12.72 12.72 0 0 0 16 3zm3 14.56a3.5 3.5 0 0 1-7 0v-2.12a3.5 3.5 0 0 1 7 0z"}),props.children);});var At16=/*#__PURE__*/React.forwardRef(function At16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 3A12.92 12.92 0 0 0 3 16v1a13 13 0 0 0 13 13h7v-2h-7A11 11 0 0 1 5 17v-1A10.94 10.94 0 0 1 16 5a10.64 10.64 0 0 1 11 11c0 3.59-1.4 5-3.66 5-1.58 0-2.34-1.29-2.34-3v-8h-2v1.94A3.84 3.84 0 0 0 15.5 10a5.48 5.48 0 0 0-5.5 5.44v2.12A5.48 5.48 0 0 0 15.5 23a4.28 4.28 0 0 0 4-2.46A4.35 4.35 0 0 0 23.41 23c3.07 0 5.59-2 5.59-7A12.72 12.72 0 0 0 16 3zm3 14.56a3.5 3.5 0 0 1-7 0v-2.12a3.5 3.5 0 0 1 7 0z"}),props.children);});var Attachment32=/*#__PURE__*/React.forwardRef(function Attachment32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.1 17.9l-13-13a6.51 6.51 0 0 0-9.2 9.2l3 3 1.41-1.41-3-3a4.5 4.5 0 1 1 6.36-6.36l13 13a4.5 4.5 0 1 1-6.36 6.36l-6.13-6.13A2.5 2.5 0 0 1 16.72 16l3.17 3.17 1.41-1.41s-3.22-3.23-3.25-3.24a4.49 4.49 0 0 0-6.34 6.35l6.19 6.23a6.51 6.51 0 0 0 9.2-9.2z"}),props.children);});var Attachment24=/*#__PURE__*/React.forwardRef(function Attachment24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.1 17.9l-13-13a6.51 6.51 0 0 0-9.2 9.2l3 3 1.41-1.41-3-3a4.5 4.5 0 1 1 6.36-6.36l13 13a4.5 4.5 0 1 1-6.36 6.36l-6.13-6.13A2.5 2.5 0 0 1 16.72 16l3.17 3.17 1.41-1.41s-3.22-3.23-3.25-3.24a4.49 4.49 0 0 0-6.34 6.35l6.19 6.23a6.51 6.51 0 0 0 9.2-9.2z"}),props.children);});var Attachment20=/*#__PURE__*/React.forwardRef(function Attachment20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.1 17.9l-13-13a6.51 6.51 0 0 0-9.2 9.2l3 3 1.41-1.41-3-3a4.5 4.5 0 1 1 6.36-6.36l13 13a4.5 4.5 0 1 1-6.36 6.36l-6.13-6.13A2.5 2.5 0 0 1 16.72 16l3.17 3.17 1.41-1.41s-3.22-3.23-3.25-3.24a4.49 4.49 0 0 0-6.34 6.35l6.19 6.23a6.51 6.51 0 0 0 9.2-9.2z"}),props.children);});var AudioConsole32=/*#__PURE__*/React.forwardRef(function AudioConsole32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 20.005h-1v-18h-2v18h-1a2.003 2.003 0 0 0-2 2v2a2.003 2.003 0 0 0 2 2h1v4h2v-4h1a2.003 2.003 0 0 0 2-2v-2a2.003 2.003 0 0 0-2-2zm0 4h-4v-2h4zm-8-10h-1v-12h-2v12h-1a2.002 2.002 0 0 0-2 2v2a2.002 2.002 0 0 0 2 2h1v10h2v-10h1a2.003 2.003 0 0 0 2-2v-2a2.002 2.002 0 0 0-2-2zm0 4h-4v-2h4zm-8-11h-1v-5h-2v5h-1a2.002 2.002 0 0 0-2 2v2a2.002 2.002 0 0 0 2 2h1v17h2v-17h1a2.002 2.002 0 0 0 2-2v-2a2.002 2.002 0 0 0-2-2zm0 4h-4v-2h4zm-8 10H5v-19H3v19H2a2.002 2.002 0 0 0-2 2v2a2.002 2.002 0 0 0 2 2h1v3h2v-3h1a2.002 2.002 0 0 0 2-2v-2a2.002 2.002 0 0 0-2-2zm0 4H2v-2l4-.001z"}),props.children);});var AudioConsole24=/*#__PURE__*/React.forwardRef(function AudioConsole24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 20.005h-1v-18h-2v18h-1a2.003 2.003 0 0 0-2 2v2a2.003 2.003 0 0 0 2 2h1v4h2v-4h1a2.003 2.003 0 0 0 2-2v-2a2.003 2.003 0 0 0-2-2zm0 4h-4v-2h4zm-8-10h-1v-12h-2v12h-1a2.002 2.002 0 0 0-2 2v2a2.002 2.002 0 0 0 2 2h1v10h2v-10h1a2.003 2.003 0 0 0 2-2v-2a2.002 2.002 0 0 0-2-2zm0 4h-4v-2h4zm-8-11h-1v-5h-2v5h-1a2.002 2.002 0 0 0-2 2v2a2.002 2.002 0 0 0 2 2h1v17h2v-17h1a2.002 2.002 0 0 0 2-2v-2a2.002 2.002 0 0 0-2-2zm0 4h-4v-2h4zm-8 10H5v-19H3v19H2a2.002 2.002 0 0 0-2 2v2a2.002 2.002 0 0 0 2 2h1v3h2v-3h1a2.002 2.002 0 0 0 2-2v-2a2.002 2.002 0 0 0-2-2zm0 4H2v-2l4-.001z"}),props.children);});var AudioConsole20=/*#__PURE__*/React.forwardRef(function AudioConsole20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 20.005h-1v-18h-2v18h-1a2.003 2.003 0 0 0-2 2v2a2.003 2.003 0 0 0 2 2h1v4h2v-4h1a2.003 2.003 0 0 0 2-2v-2a2.003 2.003 0 0 0-2-2zm0 4h-4v-2h4zm-8-10h-1v-12h-2v12h-1a2.002 2.002 0 0 0-2 2v2a2.002 2.002 0 0 0 2 2h1v10h2v-10h1a2.003 2.003 0 0 0 2-2v-2a2.002 2.002 0 0 0-2-2zm0 4h-4v-2h4zm-8-11h-1v-5h-2v5h-1a2.002 2.002 0 0 0-2 2v2a2.002 2.002 0 0 0 2 2h1v17h2v-17h1a2.002 2.002 0 0 0 2-2v-2a2.002 2.002 0 0 0-2-2zm0 4h-4v-2h4zm-8 10H5v-19H3v19H2a2.002 2.002 0 0 0-2 2v2a2.002 2.002 0 0 0 2 2h1v3h2v-3h1a2.002 2.002 0 0 0 2-2v-2a2.002 2.002 0 0 0-2-2zm0 4H2v-2l4-.001z"}),props.children);});var AudioConsole16=/*#__PURE__*/React.forwardRef(function AudioConsole16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 20.005h-1v-18h-2v18h-1a2.003 2.003 0 0 0-2 2v2a2.003 2.003 0 0 0 2 2h1v4h2v-4h1a2.003 2.003 0 0 0 2-2v-2a2.003 2.003 0 0 0-2-2zm0 4h-4v-2h4zm-8-10h-1v-12h-2v12h-1a2.002 2.002 0 0 0-2 2v2a2.002 2.002 0 0 0 2 2h1v10h2v-10h1a2.003 2.003 0 0 0 2-2v-2a2.002 2.002 0 0 0-2-2zm0 4h-4v-2h4zm-8-11h-1v-5h-2v5h-1a2.002 2.002 0 0 0-2 2v2a2.002 2.002 0 0 0 2 2h1v17h2v-17h1a2.002 2.002 0 0 0 2-2v-2a2.002 2.002 0 0 0-2-2zm0 4h-4v-2h4zm-8 10H5v-19H3v19H2a2.002 2.002 0 0 0-2 2v2a2.002 2.002 0 0 0 2 2h1v3h2v-3h1a2.002 2.002 0 0 0 2-2v-2a2.002 2.002 0 0 0-2-2zm0 4H2v-2l4-.001z"}),props.children);});var AugmentedReality32=/*#__PURE__*/React.forwardRef(function AugmentedReality32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.447 9.105l-6-3a1 1 0 0 0-.894 0l-6 3A1 1 0 0 0 14 10v7a1 1 0 0 0 .553.894l6 3a1.001 1.001 0 0 0 .894 0l6-3A1 1 0 0 0 28 17v-7a1 1 0 0 0-.553-.895zM21 8.118L24.764 10 21 11.882 17.236 10zm-5 3.5l4 2v4.764l-4-2zm6 6.764v-4.764l4-2v4.764z"}),React.createElement("circle",{cx:"13.5",cy:"24.5",r:"1.5"}),React.createElement("path",{d:"M20 30H7a2.002 2.002 0 0 1-2-2V4a2.002 2.002 0 0 1 2-2h13v2H7v24h13v-4h2v4a2.002 2.002 0 0 1-2 2z"}),props.children);});var AugmentedReality24=/*#__PURE__*/React.forwardRef(function AugmentedReality24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.447 9.105l-6-3a1 1 0 0 0-.894 0l-6 3A1 1 0 0 0 14 10v7a1 1 0 0 0 .553.894l6 3a1.001 1.001 0 0 0 .894 0l6-3A1 1 0 0 0 28 17v-7a1 1 0 0 0-.553-.895zM21 8.118L24.764 10 21 11.882 17.236 10zm-5 3.5l4 2v4.764l-4-2zm6 6.764v-4.764l4-2v4.764z"}),React.createElement("circle",{cx:"13.5",cy:"24.5",r:"1.5"}),React.createElement("path",{d:"M20 30H7a2.002 2.002 0 0 1-2-2V4a2.002 2.002 0 0 1 2-2h13v2H7v24h13v-4h2v4a2.002 2.002 0 0 1-2 2z"}),props.children);});var AugmentedReality20=/*#__PURE__*/React.forwardRef(function AugmentedReality20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.447 9.105l-6-3a1 1 0 0 0-.894 0l-6 3A1 1 0 0 0 14 10v7a1 1 0 0 0 .553.894l6 3a1.001 1.001 0 0 0 .894 0l6-3A1 1 0 0 0 28 17v-7a1 1 0 0 0-.553-.895zM21 8.118L24.764 10 21 11.882 17.236 10zm-5 3.5l4 2v4.764l-4-2zm6 6.764v-4.764l4-2v4.764z"}),React.createElement("circle",{cx:"13.5",cy:"24.5",r:"1.5"}),React.createElement("path",{d:"M20 30H7a2.002 2.002 0 0 1-2-2V4a2.002 2.002 0 0 1 2-2h13v2H7v24h13v-4h2v4a2.002 2.002 0 0 1-2 2z"}),props.children);});var AugmentedReality16=/*#__PURE__*/React.forwardRef(function AugmentedReality16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.447 9.105l-6-3a1 1 0 0 0-.894 0l-6 3A1 1 0 0 0 14 10v7a1 1 0 0 0 .553.894l6 3a1.001 1.001 0 0 0 .894 0l6-3A1 1 0 0 0 28 17v-7a1 1 0 0 0-.553-.895zM21 8.118L24.764 10 21 11.882 17.236 10zm-5 3.5l4 2v4.764l-4-2zm6 6.764v-4.764l4-2v4.764z"}),React.createElement("circle",{cx:"13.5",cy:"24.5",r:"1.5"}),React.createElement("path",{d:"M20 30H7a2.002 2.002 0 0 1-2-2V4a2.002 2.002 0 0 1 2-2h13v2H7v24h13v-4h2v4a2.002 2.002 0 0 1-2 2z"}),props.children);});var Awake32=/*#__PURE__*/React.forwardRef(function Awake32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 2h2v4.96h-2zm6.687 6.89l3.507-3.506 1.414 1.414-3.507 3.507zM25.04 15H30v2h-4.96zm-3.347 8.104l1.414-1.414 3.507 3.507L25.2 26.61zM15 25.04h2V30h-2zm-9.604.162l3.508-3.507 1.414 1.414-3.507 3.507zM2 15h4.96v2H2zm3.39-8.197l1.415-1.414 3.507 3.507-1.414 1.414zM16 12a4 4 0 1 1-4 4 4 4 0 0 1 4-4m0-2a6 6 0 1 0 6 6 6 6 0 0 0-6-6z"}),props.children);});var Awake24=/*#__PURE__*/React.forwardRef(function Awake24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 2h2v4.96h-2zm6.687 6.89l3.507-3.506 1.414 1.414-3.507 3.507zM25.04 15H30v2h-4.96zm-3.347 8.104l1.414-1.414 3.507 3.507L25.2 26.61zM15 25.04h2V30h-2zm-9.604.162l3.508-3.507 1.414 1.414-3.507 3.507zM2 15h4.96v2H2zm3.39-8.197l1.415-1.414 3.507 3.507-1.414 1.414zM16 12a4 4 0 1 1-4 4 4 4 0 0 1 4-4m0-2a6 6 0 1 0 6 6 6 6 0 0 0-6-6z"}),props.children);});var Awake20=/*#__PURE__*/React.forwardRef(function Awake20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 2h2v4.96h-2zm6.687 6.89l3.507-3.506 1.414 1.414-3.507 3.507zM25.04 15H30v2h-4.96zm-3.347 8.104l1.414-1.414 3.507 3.507L25.2 26.61zM15 25.04h2V30h-2zm-9.604.162l3.508-3.507 1.414 1.414-3.507 3.507zM2 15h4.96v2H2zm3.39-8.197l1.415-1.414 3.507 3.507-1.414 1.414zM16 12a4 4 0 1 1-4 4 4 4 0 0 1 4-4m0-2a6 6 0 1 0 6 6 6 6 0 0 0-6-6z"}),props.children);});var BackToTop32=/*#__PURE__*/React.forwardRef(function BackToTop32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 13L6 23l1.41 1.41L16 15.83l8.59 8.58L26 23 16 13zM4 7h24v2H4z"}),props.children);});var BackToTop24=/*#__PURE__*/React.forwardRef(function BackToTop24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 13L6 23l1.41 1.41L16 15.83l8.59 8.58L26 23 16 13zM4 7h24v2H4z"}),props.children);});var BackToTop20=/*#__PURE__*/React.forwardRef(function BackToTop20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 13L6 23l1.41 1.41L16 15.83l8.59 8.58L26 23 16 13zM4 7h24v2H4z"}),props.children);});var Bar32=/*#__PURE__*/React.forwardRef(function Bar32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 11H15a1 1 0 0 0-1 1v4a6.005 6.005 0 0 0 5 5.91V28h-3v2h8v-2h-3v-6.09A6.005 6.005 0 0 0 26 16v-4a1 1 0 0 0-1-1zm-1 5a4 4 0 0 1-8 0v-3h8z"}),React.createElement("path",{d:"M15 1h-5a1 1 0 0 0-1 1v7.37A6.09 6.09 0 0 0 6 15v14a1 1 0 0 0 1 1h5v-2H8V15c0-3.188 2.231-4.02 2.316-4.051L11 10.72V3h3v5h2V2a1 1 0 0 0-1-1z"}),props.children);});var Bar24=/*#__PURE__*/React.forwardRef(function Bar24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 11H15a1 1 0 0 0-1 1v4a6.005 6.005 0 0 0 5 5.91V28h-3v2h8v-2h-3v-6.09A6.005 6.005 0 0 0 26 16v-4a1 1 0 0 0-1-1zm-1 5a4 4 0 0 1-8 0v-3h8z"}),React.createElement("path",{d:"M15 1h-5a1 1 0 0 0-1 1v7.37A6.09 6.09 0 0 0 6 15v14a1 1 0 0 0 1 1h5v-2H8V15c0-3.188 2.231-4.02 2.316-4.051L11 10.72V3h3v5h2V2a1 1 0 0 0-1-1z"}),props.children);});var Bar20=/*#__PURE__*/React.forwardRef(function Bar20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 11H15a1 1 0 0 0-1 1v4a6.005 6.005 0 0 0 5 5.91V28h-3v2h8v-2h-3v-6.09A6.005 6.005 0 0 0 26 16v-4a1 1 0 0 0-1-1zm-1 5a4 4 0 0 1-8 0v-3h8z"}),React.createElement("path",{d:"M15 1h-5a1 1 0 0 0-1 1v7.37A6.09 6.09 0 0 0 6 15v14a1 1 0 0 0 1 1h5v-2H8V15c0-3.188 2.231-4.02 2.316-4.051L11 10.72V3h3v5h2V2a1 1 0 0 0-1-1z"}),props.children);});var Bar16=/*#__PURE__*/React.forwardRef(function Bar16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 11H15a1 1 0 0 0-1 1v4a6.005 6.005 0 0 0 5 5.91V28h-3v2h8v-2h-3v-6.09A6.005 6.005 0 0 0 26 16v-4a1 1 0 0 0-1-1zm-1 5a4 4 0 0 1-8 0v-3h8z"}),React.createElement("path",{d:"M15 1h-5a1 1 0 0 0-1 1v7.37A6.09 6.09 0 0 0 6 15v14a1 1 0 0 0 1 1h5v-2H8V15c0-3.188 2.231-4.02 2.316-4.051L11 10.72V3h3v5h2V2a1 1 0 0 0-1-1z"}),props.children);});var BatteryCharging32=/*#__PURE__*/React.forwardRef(function BatteryCharging32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27 11h-1v-1a2 2 0 0 0-2-2h-4v2h4v3h3v6h-3v3h-5v2h5a2 2 0 0 0 2-2v-1h1a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2zM11 22H6V10h6V8H6a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h5z"}),React.createElement("path",{d:"M14.81 23.58l-1.62-1.16L17.06 17H9.37l6.85-8.62 1.56 1.24L13.51 15h7.43l-6.13 8.58z"}),props.children);});var BatteryCharging24=/*#__PURE__*/React.forwardRef(function BatteryCharging24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27 11h-1v-1a2 2 0 0 0-2-2h-4v2h4v3h3v6h-3v3h-5v2h5a2 2 0 0 0 2-2v-1h1a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2zM11 22H6V10h6V8H6a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h5z"}),React.createElement("path",{d:"M14.81 23.58l-1.62-1.16L17.06 17H9.37l6.85-8.62 1.56 1.24L13.51 15h7.43l-6.13 8.58z"}),props.children);});var BatteryCharging20=/*#__PURE__*/React.forwardRef(function BatteryCharging20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27 11h-1v-1a2 2 0 0 0-2-2h-4v2h4v3h3v6h-3v3h-5v2h5a2 2 0 0 0 2-2v-1h1a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2zM11 22H6V10h6V8H6a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h5z"}),React.createElement("path",{d:"M14.81 23.58l-1.62-1.16L17.06 17H9.37l6.85-8.62 1.56 1.24L13.51 15h7.43l-6.13 8.58z"}),props.children);});var BatteryCharging16=/*#__PURE__*/React.forwardRef(function BatteryCharging16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27 11h-1v-1a2 2 0 0 0-2-2h-4v2h4v3h3v6h-3v3h-5v2h5a2 2 0 0 0 2-2v-1h1a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2zM11 22H6V10h6V8H6a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h5z"}),React.createElement("path",{d:"M14.81 23.58l-1.62-1.16L17.06 17H9.37l6.85-8.62 1.56 1.24L13.51 15h7.43l-6.13 8.58z"}),props.children);});var BatteryEmpty32=/*#__PURE__*/React.forwardRef(function BatteryEmpty32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 24H6a2.002 2.002 0 0 1-2-2V10a2.002 2.002 0 0 1 2-2h18a2.002 2.002 0 0 1 2 2v1h1a2.002 2.002 0 0 1 2 2v6a2.003 2.003 0 0 1-2 2h-1v1a2.003 2.003 0 0 1-2 2zM6 10v12h18v-3h3v-6h-3v-3z"}),props.children);});var BatteryEmpty24=/*#__PURE__*/React.forwardRef(function BatteryEmpty24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 24H6a2.002 2.002 0 0 1-2-2V10a2.002 2.002 0 0 1 2-2h18a2.002 2.002 0 0 1 2 2v1h1a2.002 2.002 0 0 1 2 2v6a2.003 2.003 0 0 1-2 2h-1v1a2.003 2.003 0 0 1-2 2zM6 10v12h18v-3h3v-6h-3v-3z"}),props.children);});var BatteryEmpty20=/*#__PURE__*/React.forwardRef(function BatteryEmpty20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 24H6a2.002 2.002 0 0 1-2-2V10a2.002 2.002 0 0 1 2-2h18a2.002 2.002 0 0 1 2 2v1h1a2.002 2.002 0 0 1 2 2v6a2.003 2.003 0 0 1-2 2h-1v1a2.003 2.003 0 0 1-2 2zM6 10v12h18v-3h3v-6h-3v-3z"}),props.children);});var BatteryEmpty16=/*#__PURE__*/React.forwardRef(function BatteryEmpty16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 24H6a2.002 2.002 0 0 1-2-2V10a2.002 2.002 0 0 1 2-2h18a2.002 2.002 0 0 1 2 2v1h1a2.002 2.002 0 0 1 2 2v6a2.003 2.003 0 0 1-2 2h-1v1a2.003 2.003 0 0 1-2 2zM6 10v12h18v-3h3v-6h-3v-3z"}),props.children);});var BatteryFull32=/*#__PURE__*/React.forwardRef(function BatteryFull32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 24H6a2 2 0 0 1-2-2V10a2 2 0 0 1 2-2h18a2 2 0 0 1 2 2v1h1a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2h-1v1a2 2 0 0 1-2 2zM6 10v12h18v-3h3v-6h-3v-3z"}),React.createElement("path",{d:"M22 12v8H8v-8z"}),props.children);});var BatteryFull24=/*#__PURE__*/React.forwardRef(function BatteryFull24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 24H6a2 2 0 0 1-2-2V10a2 2 0 0 1 2-2h18a2 2 0 0 1 2 2v1h1a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2h-1v1a2 2 0 0 1-2 2zM6 10v12h18v-3h3v-6h-3v-3z"}),React.createElement("path",{d:"M22 12v8H8v-8z"}),props.children);});var BatteryFull20=/*#__PURE__*/React.forwardRef(function BatteryFull20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 24H6a2 2 0 0 1-2-2V10a2 2 0 0 1 2-2h18a2 2 0 0 1 2 2v1h1a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2h-1v1a2 2 0 0 1-2 2zM6 10v12h18v-3h3v-6h-3v-3z"}),React.createElement("path",{d:"M22 12v8H8v-8z"}),props.children);});var BatteryFull16=/*#__PURE__*/React.forwardRef(function BatteryFull16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 24H6a2 2 0 0 1-2-2V10a2 2 0 0 1 2-2h18a2 2 0 0 1 2 2v1h1a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2h-1v1a2 2 0 0 1-2 2zM6 10v12h18v-3h3v-6h-3v-3z"}),React.createElement("path",{d:"M22 12v8H8v-8z"}),props.children);});var BatteryHalf32=/*#__PURE__*/React.forwardRef(function BatteryHalf32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 24H6a2 2 0 0 1-2-2V10a2 2 0 0 1 2-2h18a2 2 0 0 1 2 2v1h1a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2h-1v1a2 2 0 0 1-2 2zM6 10v12h18v-3h3v-6h-3v-3z"}),React.createElement("path",{d:"M16 12v8H8v-8z"}),props.children);});var BatteryHalf24=/*#__PURE__*/React.forwardRef(function BatteryHalf24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 24H6a2 2 0 0 1-2-2V10a2 2 0 0 1 2-2h18a2 2 0 0 1 2 2v1h1a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2h-1v1a2 2 0 0 1-2 2zM6 10v12h18v-3h3v-6h-3v-3z"}),React.createElement("path",{d:"M16 12v8H8v-8z"}),props.children);});var BatteryHalf20=/*#__PURE__*/React.forwardRef(function BatteryHalf20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 24H6a2 2 0 0 1-2-2V10a2 2 0 0 1 2-2h18a2 2 0 0 1 2 2v1h1a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2h-1v1a2 2 0 0 1-2 2zM6 10v12h18v-3h3v-6h-3v-3z"}),React.createElement("path",{d:"M16 12v8H8v-8z"}),props.children);});var BatteryHalf16=/*#__PURE__*/React.forwardRef(function BatteryHalf16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 24H6a2 2 0 0 1-2-2V10a2 2 0 0 1 2-2h18a2 2 0 0 1 2 2v1h1a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2h-1v1a2 2 0 0 1-2 2zM6 10v12h18v-3h3v-6h-3v-3z"}),React.createElement("path",{d:"M16 12v8H8v-8z"}),props.children);});var BatteryLow32=/*#__PURE__*/React.forwardRef(function BatteryLow32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 24H6a2.002 2.002 0 0 1-2-2V10a2.002 2.002 0 0 1 2-2h18a2.002 2.002 0 0 1 2 2v1h1a2.002 2.002 0 0 1 2 2v6a2.003 2.003 0 0 1-2 2h-1v1a2.003 2.003 0 0 1-2 2zM6 10v12h18v-3h3v-6h-3v-3z"}),React.createElement("path",{d:"M10 12v8H8v-8z"}),props.children);});var BatteryLow24=/*#__PURE__*/React.forwardRef(function BatteryLow24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 24H6a2.002 2.002 0 0 1-2-2V10a2.002 2.002 0 0 1 2-2h18a2.002 2.002 0 0 1 2 2v1h1a2.002 2.002 0 0 1 2 2v6a2.003 2.003 0 0 1-2 2h-1v1a2.003 2.003 0 0 1-2 2zM6 10v12h18v-3h3v-6h-3v-3z"}),React.createElement("path",{d:"M10 12v8H8v-8z"}),props.children);});var BatteryLow20=/*#__PURE__*/React.forwardRef(function BatteryLow20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 24H6a2.002 2.002 0 0 1-2-2V10a2.002 2.002 0 0 1 2-2h18a2.002 2.002 0 0 1 2 2v1h1a2.002 2.002 0 0 1 2 2v6a2.003 2.003 0 0 1-2 2h-1v1a2.003 2.003 0 0 1-2 2zM6 10v12h18v-3h3v-6h-3v-3z"}),React.createElement("path",{d:"M10 12v8H8v-8z"}),props.children);});var BatteryLow16=/*#__PURE__*/React.forwardRef(function BatteryLow16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 24H6a2.002 2.002 0 0 1-2-2V10a2.002 2.002 0 0 1 2-2h18a2.002 2.002 0 0 1 2 2v1h1a2.002 2.002 0 0 1 2 2v6a2.003 2.003 0 0 1-2 2h-1v1a2.003 2.003 0 0 1-2 2zM6 10v12h18v-3h3v-6h-3v-3z"}),React.createElement("path",{d:"M10 12v8H8v-8z"}),props.children);});var BatteryQuarter32=/*#__PURE__*/React.forwardRef(function BatteryQuarter32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 24H6a2.002 2.002 0 0 1-2-2V10a2.002 2.002 0 0 1 2-2h18a2.002 2.002 0 0 1 2 2v1h1a2.002 2.002 0 0 1 2 2v6a2.003 2.003 0 0 1-2 2h-1v1a2.003 2.003 0 0 1-2 2zM6 10v12h18v-3h3v-6h-3v-3z"}),React.createElement("path",{d:"M12 12v8H8v-8z"}),props.children);});var BatteryQuarter24=/*#__PURE__*/React.forwardRef(function BatteryQuarter24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 24H6a2.002 2.002 0 0 1-2-2V10a2.002 2.002 0 0 1 2-2h18a2.002 2.002 0 0 1 2 2v1h1a2.002 2.002 0 0 1 2 2v6a2.003 2.003 0 0 1-2 2h-1v1a2.003 2.003 0 0 1-2 2zM6 10v12h18v-3h3v-6h-3v-3z"}),React.createElement("path",{d:"M12 12v8H8v-8z"}),props.children);});var BatteryQuarter20=/*#__PURE__*/React.forwardRef(function BatteryQuarter20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 24H6a2.002 2.002 0 0 1-2-2V10a2.002 2.002 0 0 1 2-2h18a2.002 2.002 0 0 1 2 2v1h1a2.002 2.002 0 0 1 2 2v6a2.003 2.003 0 0 1-2 2h-1v1a2.003 2.003 0 0 1-2 2zM6 10v12h18v-3h3v-6h-3v-3z"}),React.createElement("path",{d:"M12 12v8H8v-8z"}),props.children);});var BatteryQuarter16=/*#__PURE__*/React.forwardRef(function BatteryQuarter16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 24H6a2.002 2.002 0 0 1-2-2V10a2.002 2.002 0 0 1 2-2h18a2.002 2.002 0 0 1 2 2v1h1a2.002 2.002 0 0 1 2 2v6a2.003 2.003 0 0 1-2 2h-1v1a2.003 2.003 0 0 1-2 2zM6 10v12h18v-3h3v-6h-3v-3z"}),React.createElement("path",{d:"M12 12v8H8v-8z"}),props.children);});var Bee32=/*#__PURE__*/React.forwardRef(function Bee32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 10a6 6 0 0 0-6 6v8a6 6 0 0 0 12 0v-8a6 6 0 0 0-6-6zm-4.25 7.87h8.5v4.25h-8.5zM16 28.25A4.27 4.27 0 0 1 11.75 24v-.13h8.5V24A4.27 4.27 0 0 1 16 28.25zm4.25-12.13h-8.5V16a4.25 4.25 0 0 1 8.5 0zm10.41 3.09L24 13v9.1a4 4 0 0 0 8 0 3.83 3.83 0 0 0-1.34-2.89zM28 24.35a2.25 2.25 0 0 1-2.25-2.25V17l3.72 3.47A2.05 2.05 0 0 1 30.2 22a2.25 2.25 0 0 1-2.2 2.35zM0 22.1a4 4 0 0 0 8 0V13l-6.66 6.21A3.88 3.88 0 0 0 0 22.1zm2.48-1.56L6.25 17v5.1a2.25 2.25 0 0 1-4.5 0 2.05 2.05 0 0 1 .73-1.56zM15 5.5A3.5 3.5 0 1 0 11.5 9 3.5 3.5 0 0 0 15 5.5zm-5.25 0a1.75 1.75 0 1 1 1.75 1.75A1.77 1.77 0 0 1 9.75 5.5zM20.5 2A3.5 3.5 0 1 0 24 5.5 3.5 3.5 0 0 0 20.5 2zm0 5.25a1.75 1.75 0 1 1 1.75-1.75 1.77 1.77 0 0 1-1.75 1.75z"}),props.children);});var Bee24=/*#__PURE__*/React.forwardRef(function Bee24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 10a6 6 0 0 0-6 6v8a6 6 0 0 0 12 0v-8a6 6 0 0 0-6-6zm-4.25 7.87h8.5v4.25h-8.5zM16 28.25A4.27 4.27 0 0 1 11.75 24v-.13h8.5V24A4.27 4.27 0 0 1 16 28.25zm4.25-12.13h-8.5V16a4.25 4.25 0 0 1 8.5 0zm10.41 3.09L24 13v9.1a4 4 0 0 0 8 0 3.83 3.83 0 0 0-1.34-2.89zM28 24.35a2.25 2.25 0 0 1-2.25-2.25V17l3.72 3.47A2.05 2.05 0 0 1 30.2 22a2.25 2.25 0 0 1-2.2 2.35zM0 22.1a4 4 0 0 0 8 0V13l-6.66 6.21A3.88 3.88 0 0 0 0 22.1zm2.48-1.56L6.25 17v5.1a2.25 2.25 0 0 1-4.5 0 2.05 2.05 0 0 1 .73-1.56zM15 5.5A3.5 3.5 0 1 0 11.5 9 3.5 3.5 0 0 0 15 5.5zm-5.25 0a1.75 1.75 0 1 1 1.75 1.75A1.77 1.77 0 0 1 9.75 5.5zM20.5 2A3.5 3.5 0 1 0 24 5.5 3.5 3.5 0 0 0 20.5 2zm0 5.25a1.75 1.75 0 1 1 1.75-1.75 1.77 1.77 0 0 1-1.75 1.75z"}),props.children);});var Bee20=/*#__PURE__*/React.forwardRef(function Bee20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 10a6 6 0 0 0-6 6v8a6 6 0 0 0 12 0v-8a6 6 0 0 0-6-6zm-4.25 7.87h8.5v4.25h-8.5zM16 28.25A4.27 4.27 0 0 1 11.75 24v-.13h8.5V24A4.27 4.27 0 0 1 16 28.25zm4.25-12.13h-8.5V16a4.25 4.25 0 0 1 8.5 0zm10.41 3.09L24 13v9.1a4 4 0 0 0 8 0 3.83 3.83 0 0 0-1.34-2.89zM28 24.35a2.25 2.25 0 0 1-2.25-2.25V17l3.72 3.47A2.05 2.05 0 0 1 30.2 22a2.25 2.25 0 0 1-2.2 2.35zM0 22.1a4 4 0 0 0 8 0V13l-6.66 6.21A3.88 3.88 0 0 0 0 22.1zm2.48-1.56L6.25 17v5.1a2.25 2.25 0 0 1-4.5 0 2.05 2.05 0 0 1 .73-1.56zM15 5.5A3.5 3.5 0 1 0 11.5 9 3.5 3.5 0 0 0 15 5.5zm-5.25 0a1.75 1.75 0 1 1 1.75 1.75A1.77 1.77 0 0 1 9.75 5.5zM20.5 2A3.5 3.5 0 1 0 24 5.5 3.5 3.5 0 0 0 20.5 2zm0 5.25a1.75 1.75 0 1 1 1.75-1.75 1.77 1.77 0 0 1-1.75 1.75z"}),props.children);});var Bee16=/*#__PURE__*/React.forwardRef(function Bee16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 10a6 6 0 0 0-6 6v8a6 6 0 0 0 12 0v-8a6 6 0 0 0-6-6zm-4.25 7.87h8.5v4.25h-8.5zM16 28.25A4.27 4.27 0 0 1 11.75 24v-.13h8.5V24A4.27 4.27 0 0 1 16 28.25zm4.25-12.13h-8.5V16a4.25 4.25 0 0 1 8.5 0zm10.41 3.09L24 13v9.1a4 4 0 0 0 8 0 3.83 3.83 0 0 0-1.34-2.89zM28 24.35a2.25 2.25 0 0 1-2.25-2.25V17l3.72 3.47A2.05 2.05 0 0 1 30.2 22a2.25 2.25 0 0 1-2.2 2.35zM0 22.1a4 4 0 0 0 8 0V13l-6.66 6.21A3.88 3.88 0 0 0 0 22.1zm2.48-1.56L6.25 17v5.1a2.25 2.25 0 0 1-4.5 0 2.05 2.05 0 0 1 .73-1.56zM15 5.5A3.5 3.5 0 1 0 11.5 9 3.5 3.5 0 0 0 15 5.5zm-5.25 0a1.75 1.75 0 1 1 1.75 1.75A1.77 1.77 0 0 1 9.75 5.5zM20.5 2A3.5 3.5 0 1 0 24 5.5 3.5 3.5 0 0 0 20.5 2zm0 5.25a1.75 1.75 0 1 1 1.75-1.75 1.77 1.77 0 0 1-1.75 1.75z"}),props.children);});var Bicycle32=/*#__PURE__*/React.forwardRef(function Bicycle32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 16a5.93 5.93 0 0 0-1.75.26l-2.36-4.71a1.07 1.07 0 0 0-.25-.31L22.72 8H25V6h-7v2h2.61l-1 3H9.38L10 8.21A1 1 0 0 0 9 7H4v2h3.76l-1.5 7H6a6 6 0 1 0 2.22.43l.64-3 7.06 8.82a2 2 0 0 0 1.56.75h2.61A6 6 0 1 0 26 16zm-16 6a4 4 0 1 1-4.17-4L5 21.79A1.55 1.55 0 0 0 5 22a1 1 0 0 0 1 1 1 1 0 0 0 1-.79l.81-3.77A4 4 0 0 1 10 22zm1.08-9H19l-2.32 6.94zm9 8h-1.7l2.39-7.19 1.68 3.35A6.05 6.05 0 0 0 20.09 21zM26 26a4 4 0 0 1-2.62-7l1.73 3.45A1 1 0 0 0 27 22a1.06 1.06 0 0 0-.11-.44l-1.73-3.46A3.86 3.86 0 0 1 26 18a4 4 0 0 1 0 8z"}),props.children);});var Bicycle24=/*#__PURE__*/React.forwardRef(function Bicycle24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 16a5.93 5.93 0 0 0-1.75.26l-2.36-4.71a1.07 1.07 0 0 0-.25-.31L22.72 8H25V6h-7v2h2.61l-1 3H9.38L10 8.21A1 1 0 0 0 9 7H4v2h3.76l-1.5 7H6a6 6 0 1 0 2.22.43l.64-3 7.06 8.82a2 2 0 0 0 1.56.75h2.61A6 6 0 1 0 26 16zm-16 6a4 4 0 1 1-4.17-4L5 21.79A1.55 1.55 0 0 0 5 22a1 1 0 0 0 1 1 1 1 0 0 0 1-.79l.81-3.77A4 4 0 0 1 10 22zm1.08-9H19l-2.32 6.94zm9 8h-1.7l2.39-7.19 1.68 3.35A6.05 6.05 0 0 0 20.09 21zM26 26a4 4 0 0 1-2.62-7l1.73 3.45A1 1 0 0 0 27 22a1.06 1.06 0 0 0-.11-.44l-1.73-3.46A3.86 3.86 0 0 1 26 18a4 4 0 0 1 0 8z"}),props.children);});var Bicycle20=/*#__PURE__*/React.forwardRef(function Bicycle20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 16a5.93 5.93 0 0 0-1.75.26l-2.36-4.71a1.07 1.07 0 0 0-.25-.31L22.72 8H25V6h-7v2h2.61l-1 3H9.38L10 8.21A1 1 0 0 0 9 7H4v2h3.76l-1.5 7H6a6 6 0 1 0 2.22.43l.64-3 7.06 8.82a2 2 0 0 0 1.56.75h2.61A6 6 0 1 0 26 16zm-16 6a4 4 0 1 1-4.17-4L5 21.79A1.55 1.55 0 0 0 5 22a1 1 0 0 0 1 1 1 1 0 0 0 1-.79l.81-3.77A4 4 0 0 1 10 22zm1.08-9H19l-2.32 6.94zm9 8h-1.7l2.39-7.19 1.68 3.35A6.05 6.05 0 0 0 20.09 21zM26 26a4 4 0 0 1-2.62-7l1.73 3.45A1 1 0 0 0 27 22a1.06 1.06 0 0 0-.11-.44l-1.73-3.46A3.86 3.86 0 0 1 26 18a4 4 0 0 1 0 8z"}),props.children);});var Bicycle16=/*#__PURE__*/React.forwardRef(function Bicycle16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 16a5.93 5.93 0 0 0-1.75.26l-2.36-4.71a1.07 1.07 0 0 0-.25-.31L22.72 8H25V6h-7v2h2.61l-1 3H9.38L10 8.21A1 1 0 0 0 9 7H4v2h3.76l-1.5 7H6a6 6 0 1 0 2.22.43l.64-3 7.06 8.82a2 2 0 0 0 1.56.75h2.61A6 6 0 1 0 26 16zm-16 6a4 4 0 1 1-4.17-4L5 21.79A1.55 1.55 0 0 0 5 22a1 1 0 0 0 1 1 1 1 0 0 0 1-.79l.81-3.77A4 4 0 0 1 10 22zm1.08-9H19l-2.32 6.94zm9 8h-1.7l2.39-7.19 1.68 3.35A6.05 6.05 0 0 0 20.09 21zM26 26a4 4 0 0 1-2.62-7l1.73 3.45A1 1 0 0 0 27 22a1.06 1.06 0 0 0-.11-.44l-1.73-3.46A3.86 3.86 0 0 1 26 18a4 4 0 0 1 0 8z"}),props.children);});var Binoculars32=/*#__PURE__*/React.forwardRef(function Binoculars32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 8V5a1 1 0 0 0-1-1h-6a1 1 0 0 0-1 1v3a2 2 0 0 0-2 2v2h-4v-2a2 2 0 0 0-2-2V5a1 1 0 0 0-1-1H5a1 1 0 0 0-1 1v3a2 2 0 0 0-2 2v12a2 2 0 0 0 1 1.72V27a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1v-3.28A2 2 0 0 0 14 22v-2h4v2a2 2 0 0 0 1 1.72V27a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1v-3.28A2 2 0 0 0 30 22V10a2 2 0 0 0-2-2zM11 26H5v-2h6zm1-4H4V10h2V6h4v4h2zm2-4v-4h4v4zm13 8h-6v-2h6zm1-4h-8V10h2V6h4v4h2z"}),props.children);});var Binoculars24=/*#__PURE__*/React.forwardRef(function Binoculars24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 8V5a1 1 0 0 0-1-1h-6a1 1 0 0 0-1 1v3a2 2 0 0 0-2 2v2h-4v-2a2 2 0 0 0-2-2V5a1 1 0 0 0-1-1H5a1 1 0 0 0-1 1v3a2 2 0 0 0-2 2v12a2 2 0 0 0 1 1.72V27a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1v-3.28A2 2 0 0 0 14 22v-2h4v2a2 2 0 0 0 1 1.72V27a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1v-3.28A2 2 0 0 0 30 22V10a2 2 0 0 0-2-2zM11 26H5v-2h6zm1-4H4V10h2V6h4v4h2zm2-4v-4h4v4zm13 8h-6v-2h6zm1-4h-8V10h2V6h4v4h2z"}),props.children);});var Binoculars20=/*#__PURE__*/React.forwardRef(function Binoculars20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 8V5a1 1 0 0 0-1-1h-6a1 1 0 0 0-1 1v3a2 2 0 0 0-2 2v2h-4v-2a2 2 0 0 0-2-2V5a1 1 0 0 0-1-1H5a1 1 0 0 0-1 1v3a2 2 0 0 0-2 2v12a2 2 0 0 0 1 1.72V27a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1v-3.28A2 2 0 0 0 14 22v-2h4v2a2 2 0 0 0 1 1.72V27a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1v-3.28A2 2 0 0 0 30 22V10a2 2 0 0 0-2-2zM11 26H5v-2h6zm1-4H4V10h2V6h4v4h2zm2-4v-4h4v4zm13 8h-6v-2h6zm1-4h-8V10h2V6h4v4h2z"}),props.children);});var Binoculars16=/*#__PURE__*/React.forwardRef(function Binoculars16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 8V5a1 1 0 0 0-1-1h-6a1 1 0 0 0-1 1v3a2 2 0 0 0-2 2v2h-4v-2a2 2 0 0 0-2-2V5a1 1 0 0 0-1-1H5a1 1 0 0 0-1 1v3a2 2 0 0 0-2 2v12a2 2 0 0 0 1 1.72V27a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1v-3.28A2 2 0 0 0 14 22v-2h4v2a2 2 0 0 0 1 1.72V27a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1v-3.28A2 2 0 0 0 30 22V10a2 2 0 0 0-2-2zM11 26H5v-2h6zm1-4H4V10h2V6h4v4h2zm2-4v-4h4v4zm13 8h-6v-2h6zm1-4h-8V10h2V6h4v4h2z"}),props.children);});var Blog32=/*#__PURE__*/React.forwardRef(function Blog32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4 24h10v2H4zm0-6h10v2H4zm22-4H6a2 2 0 0 1-2-2V6a2 2 0 0 1 2-2h20a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2zM6 6v6h20V6zm20 22h-6a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h6a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2zm-6-8v6h6v-6z"}),props.children);});var Blog24=/*#__PURE__*/React.forwardRef(function Blog24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4 24h10v2H4zm0-6h10v2H4zm22-4H6a2 2 0 0 1-2-2V6a2 2 0 0 1 2-2h20a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2zM6 6v6h20V6zm20 22h-6a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h6a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2zm-6-8v6h6v-6z"}),props.children);});var Blog20=/*#__PURE__*/React.forwardRef(function Blog20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4 24h10v2H4zm0-6h10v2H4zm22-4H6a2 2 0 0 1-2-2V6a2 2 0 0 1 2-2h20a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2zM6 6v6h20V6zm20 22h-6a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h6a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2zm-6-8v6h6v-6z"}),props.children);});var Blog16=/*#__PURE__*/React.forwardRef(function Blog16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4 24h10v2H4zm0-6h10v2H4zm22-4H6a2 2 0 0 1-2-2V6a2 2 0 0 1 2-2h20a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2zM6 6v6h20V6zm20 22h-6a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h6a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2zm-6-8v6h6v-6z"}),props.children);});var BluetoothOff32=/*#__PURE__*/React.forwardRef(function BluetoothOff32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 26.59L5.41 4 4 5.41 14.59 16 7 23.59 8.41 25 15 18.41V29a1 1 0 0 0 .58.91A1.06 1.06 0 0 0 16 30a1 1 0 0 0 .65-.24l6.3-5.4L26.59 28zm-11 .24v-8.42l4.53 4.53zm0-14.08V5.17l4.53 3.89-4.11 4.11 1.41 1.41 4.88-4.87A1 1 0 0 0 24 9a1 1 0 0 0-.35-.72l-7-6a1 1 0 0 0-1.07-.15A1 1 0 0 0 15 3v7.75z"}),props.children);});var BluetoothOff24=/*#__PURE__*/React.forwardRef(function BluetoothOff24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 26.59L5.41 4 4 5.41 14.59 16 7 23.59 8.41 25 15 18.41V29a1 1 0 0 0 .58.91A1.06 1.06 0 0 0 16 30a1 1 0 0 0 .65-.24l6.3-5.4L26.59 28zm-11 .24v-8.42l4.53 4.53zm0-14.08V5.17l4.53 3.89-4.11 4.11 1.41 1.41 4.88-4.87A1 1 0 0 0 24 9a1 1 0 0 0-.35-.72l-7-6a1 1 0 0 0-1.07-.15A1 1 0 0 0 15 3v7.75z"}),props.children);});var BluetoothOff20=/*#__PURE__*/React.forwardRef(function BluetoothOff20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 26.59L5.41 4 4 5.41 14.59 16 7 23.59 8.41 25 15 18.41V29a1 1 0 0 0 .58.91A1.06 1.06 0 0 0 16 30a1 1 0 0 0 .65-.24l6.3-5.4L26.59 28zm-11 .24v-8.42l4.53 4.53zm0-14.08V5.17l4.53 3.89-4.11 4.11 1.41 1.41 4.88-4.87A1 1 0 0 0 24 9a1 1 0 0 0-.35-.72l-7-6a1 1 0 0 0-1.07-.15A1 1 0 0 0 15 3v7.75z"}),props.children);});var BluetoothOff16=/*#__PURE__*/React.forwardRef(function BluetoothOff16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 26.59L5.41 4 4 5.41 14.59 16 7 23.59 8.41 25 15 18.41V29a1 1 0 0 0 .58.91A1.06 1.06 0 0 0 16 30a1 1 0 0 0 .65-.24l6.3-5.4L26.59 28zm-11 .24v-8.42l4.53 4.53zm0-14.08V5.17l4.53 3.89-4.11 4.11 1.41 1.41 4.88-4.87A1 1 0 0 0 24 9a1 1 0 0 0-.35-.72l-7-6a1 1 0 0 0-1.07-.15A1 1 0 0 0 15 3v7.75z"}),props.children);});var Bluetooth32=/*#__PURE__*/React.forwardRef(function Bluetooth32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 30a1.06 1.06 0 0 1-.42-.09A1 1 0 0 1 15 29V18.41L8.41 25 7 23.59 14.59 16 7 8.41 8.41 7 15 13.59V3a1 1 0 0 1 .58-.91 1 1 0 0 1 1.07.15l7 6A1 1 0 0 1 24 9a1 1 0 0 1-.29.75L17.41 16l6.3 6.29A1 1 0 0 1 24 23a1 1 0 0 1-.35.72l-7 6A1 1 0 0 1 16 30zm1-11.59v8.42l4.53-3.89zm0-13.24v8.42l4.53-4.53z"}),props.children);});var Bluetooth24=/*#__PURE__*/React.forwardRef(function Bluetooth24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 30a1.06 1.06 0 0 1-.42-.09A1 1 0 0 1 15 29V18.41L8.41 25 7 23.59 14.59 16 7 8.41 8.41 7 15 13.59V3a1 1 0 0 1 .58-.91 1 1 0 0 1 1.07.15l7 6A1 1 0 0 1 24 9a1 1 0 0 1-.29.75L17.41 16l6.3 6.29A1 1 0 0 1 24 23a1 1 0 0 1-.35.72l-7 6A1 1 0 0 1 16 30zm1-11.59v8.42l4.53-3.89zm0-13.24v8.42l4.53-4.53z"}),props.children);});var Bluetooth20=/*#__PURE__*/React.forwardRef(function Bluetooth20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 30a1.06 1.06 0 0 1-.42-.09A1 1 0 0 1 15 29V18.41L8.41 25 7 23.59 14.59 16 7 8.41 8.41 7 15 13.59V3a1 1 0 0 1 .58-.91 1 1 0 0 1 1.07.15l7 6A1 1 0 0 1 24 9a1 1 0 0 1-.29.75L17.41 16l6.3 6.29A1 1 0 0 1 24 23a1 1 0 0 1-.35.72l-7 6A1 1 0 0 1 16 30zm1-11.59v8.42l4.53-3.89zm0-13.24v8.42l4.53-4.53z"}),props.children);});var Bluetooth16=/*#__PURE__*/React.forwardRef(function Bluetooth16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 30a1.06 1.06 0 0 1-.42-.09A1 1 0 0 1 15 29V18.41L8.41 25 7 23.59 14.59 16 7 8.41 8.41 7 15 13.59V3a1 1 0 0 1 .58-.91 1 1 0 0 1 1.07.15l7 6A1 1 0 0 1 24 9a1 1 0 0 1-.29.75L17.41 16l6.3 6.29A1 1 0 0 1 24 23a1 1 0 0 1-.35.72l-7 6A1 1 0 0 1 16 30zm1-11.59v8.42l4.53-3.89zm0-13.24v8.42l4.53-4.53z"}),props.children);});var Bookmark32=/*#__PURE__*/React.forwardRef(function Bookmark32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 4v22.75l-7.1-3.59-.9-.45-.9.45L8 26.75V4h16m0-2H8a2 2 0 0 0-2 2v26l10-5 10 5V4a2 2 0 0 0-2-2z"}),props.children);});var Bookmark24=/*#__PURE__*/React.forwardRef(function Bookmark24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 4v22.75l-7.1-3.59-.9-.45-.9.45L8 26.75V4h16m0-2H8a2 2 0 0 0-2 2v26l10-5 10 5V4a2 2 0 0 0-2-2z"}),props.children);});var Bookmark20=/*#__PURE__*/React.forwardRef(function Bookmark20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 4v22.75l-7.1-3.59-.9-.45-.9.45L8 26.75V4h16m0-2H8a2 2 0 0 0-2 2v26l10-5 10 5V4a2 2 0 0 0-2-2z"}),props.children);});var Bookmark16=/*#__PURE__*/React.forwardRef(function Bookmark16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 4v22.75l-7.1-3.59-.9-.45-.9.45L8 26.75V4h16m0-2H8a2 2 0 0 0-2 2v26l10-5 10 5V4a2 2 0 0 0-2-2z"}),props.children);});var Box32=/*#__PURE__*/React.forwardRef(function Box32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 21h-8a2 2 0 0 1-2-2v-2a2 2 0 0 1 2-2h8a2 2 0 0 1 2 2v2a2 2 0 0 1-2 2zm-8-4v2h8v-2z"}),React.createElement("path",{d:"M28 4H4a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2v16a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2V12a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm-2 24H6V12h20zm2-18H4V6h24v4z"}),props.children);});var Box24=/*#__PURE__*/React.forwardRef(function Box24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 21h-8a2 2 0 0 1-2-2v-2a2 2 0 0 1 2-2h8a2 2 0 0 1 2 2v2a2 2 0 0 1-2 2zm-8-4v2h8v-2z"}),React.createElement("path",{d:"M28 4H4a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2v16a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2V12a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm-2 24H6V12h20zm2-18H4V6h24v4z"}),props.children);});var Box20=/*#__PURE__*/React.forwardRef(function Box20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 21h-8a2 2 0 0 1-2-2v-2a2 2 0 0 1 2-2h8a2 2 0 0 1 2 2v2a2 2 0 0 1-2 2zm-8-4v2h8v-2z"}),React.createElement("path",{d:"M28 4H4a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2v16a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2V12a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm-2 24H6V12h20zm2-18H4V6h24v4z"}),props.children);});var Box16=/*#__PURE__*/React.forwardRef(function Box16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 21h-8a2 2 0 0 1-2-2v-2a2 2 0 0 1 2-2h8a2 2 0 0 1 2 2v2a2 2 0 0 1-2 2zm-8-4v2h8v-2z"}),React.createElement("path",{d:"M28 4H4a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2v16a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2V12a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm-2 24H6V12h20zm2-18H4V6h24v4z"}),props.children);});var Branch32=/*#__PURE__*/React.forwardRef(function Branch32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 18a3.995 3.995 0 0 0-3.858 3H18a3.003 3.003 0 0 1-3-3v-4a4.951 4.951 0 0 0-1.026-3h8.168a4 4 0 1 0 0-2H9.858a4 4 0 1 0 0 2H10a3.003 3.003 0 0 1 3 3v4a5.006 5.006 0 0 0 5 5h4.142A3.994 3.994 0 1 0 26 18zm0-10a2 2 0 1 1-2 2 2.002 2.002 0 0 1 2-2zM6 12a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2zm20 12a2 2 0 1 1 2-2 2.003 2.003 0 0 1-2 2z"}),props.children);});var Branch24=/*#__PURE__*/React.forwardRef(function Branch24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 18a3.995 3.995 0 0 0-3.858 3H18a3.003 3.003 0 0 1-3-3v-4a4.951 4.951 0 0 0-1.026-3h8.168a4 4 0 1 0 0-2H9.858a4 4 0 1 0 0 2H10a3.003 3.003 0 0 1 3 3v4a5.006 5.006 0 0 0 5 5h4.142A3.994 3.994 0 1 0 26 18zm0-10a2 2 0 1 1-2 2 2.002 2.002 0 0 1 2-2zM6 12a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2zm20 12a2 2 0 1 1 2-2 2.003 2.003 0 0 1-2 2z"}),props.children);});var Branch20=/*#__PURE__*/React.forwardRef(function Branch20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 18a3.995 3.995 0 0 0-3.858 3H18a3.003 3.003 0 0 1-3-3v-4a4.951 4.951 0 0 0-1.026-3h8.168a4 4 0 1 0 0-2H9.858a4 4 0 1 0 0 2H10a3.003 3.003 0 0 1 3 3v4a5.006 5.006 0 0 0 5 5h4.142A3.994 3.994 0 1 0 26 18zm0-10a2 2 0 1 1-2 2 2.002 2.002 0 0 1 2-2zM6 12a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2zm20 12a2 2 0 1 1 2-2 2.003 2.003 0 0 1-2 2z"}),props.children);});var Branch16=/*#__PURE__*/React.forwardRef(function Branch16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 18a3.995 3.995 0 0 0-3.858 3H18a3.003 3.003 0 0 1-3-3v-4a4.951 4.951 0 0 0-1.026-3h8.168a4 4 0 1 0 0-2H9.858a4 4 0 1 0 0 2H10a3.003 3.003 0 0 1 3 3v4a5.006 5.006 0 0 0 5 5h4.142A3.994 3.994 0 1 0 26 18zm0-10a2 2 0 1 1-2 2 2.002 2.002 0 0 1 2-2zM6 12a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2zm20 12a2 2 0 1 1 2-2 2.003 2.003 0 0 1-2 2z"}),props.children);});var BrightnessContrast32=/*#__PURE__*/React.forwardRef(function BrightnessContrast32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 2h2v3h-2zm12 13h3v2h-3zM15 27h2v3h-2zM2 15h3v2H2zm3.45-8.117L6.864 5.47l2.122 2.12L7.57 9.004zM23 7.581l2.12-2.121 1.414 1.414-2.121 2.122zm.002 16.835l1.414-1.414 2.122 2.122-1.414 1.414zM5.47 25.13L7.59 23 9 24.42l-2.12 2.12-1.41-1.41zM16 8a8 8 0 1 0 8 8 8 8 0 0 0-8-8zm0 14a6 6 0 0 1 0-12z"}),props.children);});var BrightnessContrast24=/*#__PURE__*/React.forwardRef(function BrightnessContrast24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 2h2v3h-2zm12 13h3v2h-3zM15 27h2v3h-2zM2 15h3v2H2zm3.45-8.117L6.864 5.47l2.122 2.12L7.57 9.004zM23 7.581l2.12-2.121 1.414 1.414-2.121 2.122zm.002 16.835l1.414-1.414 2.122 2.122-1.414 1.414zM5.47 25.13L7.59 23 9 24.42l-2.12 2.12-1.41-1.41zM16 8a8 8 0 1 0 8 8 8 8 0 0 0-8-8zm0 14a6 6 0 0 1 0-12z"}),props.children);});var BrightnessContrast20=/*#__PURE__*/React.forwardRef(function BrightnessContrast20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 2h2v3h-2zm12 13h3v2h-3zM15 27h2v3h-2zM2 15h3v2H2zm3.45-8.117L6.864 5.47l2.122 2.12L7.57 9.004zM23 7.581l2.12-2.121 1.414 1.414-2.121 2.122zm.002 16.835l1.414-1.414 2.122 2.122-1.414 1.414zM5.47 25.13L7.59 23 9 24.42l-2.12 2.12-1.41-1.41zM16 8a8 8 0 1 0 8 8 8 8 0 0 0-8-8zm0 14a6 6 0 0 1 0-12z"}),props.children);});var BrightnessContrast16=/*#__PURE__*/React.forwardRef(function BrightnessContrast16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 2h2v3h-2zm12 13h3v2h-3zM15 27h2v3h-2zM2 15h3v2H2zm3.45-8.117L6.864 5.47l2.122 2.12L7.57 9.004zM23 7.581l2.12-2.121 1.414 1.414-2.121 2.122zm.002 16.835l1.414-1.414 2.122 2.122-1.414 1.414zM5.47 25.13L7.59 23 9 24.42l-2.12 2.12-1.41-1.41zM16 8a8 8 0 1 0 8 8 8 8 0 0 0-8-8zm0 14a6 6 0 0 1 0-12z"}),props.children);});var BuildingInsights_132=/*#__PURE__*/React.forwardRef(function BuildingInsights_132(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 2H16a2.002 2.002 0 0 0-2 2v10H4a2.002 2.002 0 0 0-2 2v14h28V4a2.002 2.002 0 0 0-2-2zM9 28v-7h4v7zm19 0H15v-8a1 1 0 0 0-1-1H8a1 1 0 0 0-1 1v8H4V16h12V4h12z"}),React.createElement("path",{d:"M18 8h2v2h-2zm6 0h2v2h-2zm-6 6h2v2h-2zm6 0h2v2h-2zm-6 6h2v2h-2zm6 0h2v2h-2zM9 12H7a5.006 5.006 0 0 1 5-5v2a3.003 3.003 0 0 0-3 3zm-5 0H2A10.011 10.011 0 0 1 12 2v2a8.01 8.01 0 0 0-8 8z"}),props.children);});var BuildingInsights_124=/*#__PURE__*/React.forwardRef(function BuildingInsights_124(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 2H16a2.002 2.002 0 0 0-2 2v10H4a2.002 2.002 0 0 0-2 2v14h28V4a2.002 2.002 0 0 0-2-2zM9 28v-7h4v7zm19 0H15v-8a1 1 0 0 0-1-1H8a1 1 0 0 0-1 1v8H4V16h12V4h12z"}),React.createElement("path",{d:"M18 8h2v2h-2zm6 0h2v2h-2zm-6 6h2v2h-2zm6 0h2v2h-2zm-6 6h2v2h-2zm6 0h2v2h-2zM9 12H7a5.006 5.006 0 0 1 5-5v2a3.003 3.003 0 0 0-3 3zm-5 0H2A10.011 10.011 0 0 1 12 2v2a8.01 8.01 0 0 0-8 8z"}),props.children);});var BuildingInsights_120=/*#__PURE__*/React.forwardRef(function BuildingInsights_120(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 2H16a2.002 2.002 0 0 0-2 2v10H4a2.002 2.002 0 0 0-2 2v14h28V4a2.002 2.002 0 0 0-2-2zM9 28v-7h4v7zm19 0H15v-8a1 1 0 0 0-1-1H8a1 1 0 0 0-1 1v8H4V16h12V4h12z"}),React.createElement("path",{d:"M18 8h2v2h-2zm6 0h2v2h-2zm-6 6h2v2h-2zm6 0h2v2h-2zm-6 6h2v2h-2zm6 0h2v2h-2zM9 12H7a5.006 5.006 0 0 1 5-5v2a3.003 3.003 0 0 0-3 3zm-5 0H2A10.011 10.011 0 0 1 12 2v2a8.01 8.01 0 0 0-8 8z"}),props.children);});var BuildingInsights_116=/*#__PURE__*/React.forwardRef(function BuildingInsights_116(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 2H16a2.002 2.002 0 0 0-2 2v10H4a2.002 2.002 0 0 0-2 2v14h28V4a2.002 2.002 0 0 0-2-2zM9 28v-7h4v7zm19 0H15v-8a1 1 0 0 0-1-1H8a1 1 0 0 0-1 1v8H4V16h12V4h12z"}),React.createElement("path",{d:"M18 8h2v2h-2zm6 0h2v2h-2zm-6 6h2v2h-2zm6 0h2v2h-2zm-6 6h2v2h-2zm6 0h2v2h-2zM9 12H7a5.006 5.006 0 0 1 5-5v2a3.003 3.003 0 0 0-3 3zm-5 0H2A10.011 10.011 0 0 1 12 2v2a8.01 8.01 0 0 0-8 8z"}),props.children);});var BuildingInsights_232=/*#__PURE__*/React.forwardRef(function BuildingInsights_232(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 2H16a2.002 2.002 0 0 0-2 2v10H4a2.002 2.002 0 0 0-2 2v14h28V4a2.002 2.002 0 0 0-2-2zM9 28v-7h4v7zm19 0H15v-8a1 1 0 0 0-1-1H8a1 1 0 0 0-1 1v8H4V16h12V4h12z"}),React.createElement("path",{d:"M18 8h2v2h-2zm6 0h2v2h-2zm-6 6h2v2h-2zm6 0h2v2h-2zm-6 6h2v2h-2zm6 0h2v2h-2zM5.5 12a3.5 3.5 0 0 1 0-7h.627A4.006 4.006 0 0 1 10 2h2v2h-2a2.002 2.002 0 0 0-2 2v1H5.5a1.5 1.5 0 0 0 0 3H12v2z"}),props.children);});var BuildingInsights_224=/*#__PURE__*/React.forwardRef(function BuildingInsights_224(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 2H16a2.002 2.002 0 0 0-2 2v10H4a2.002 2.002 0 0 0-2 2v14h28V4a2.002 2.002 0 0 0-2-2zM9 28v-7h4v7zm19 0H15v-8a1 1 0 0 0-1-1H8a1 1 0 0 0-1 1v8H4V16h12V4h12z"}),React.createElement("path",{d:"M18 8h2v2h-2zm6 0h2v2h-2zm-6 6h2v2h-2zm6 0h2v2h-2zm-6 6h2v2h-2zm6 0h2v2h-2zM5.5 12a3.5 3.5 0 0 1 0-7h.627A4.006 4.006 0 0 1 10 2h2v2h-2a2.002 2.002 0 0 0-2 2v1H5.5a1.5 1.5 0 0 0 0 3H12v2z"}),props.children);});var BuildingInsights_220=/*#__PURE__*/React.forwardRef(function BuildingInsights_220(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 2H16a2.002 2.002 0 0 0-2 2v10H4a2.002 2.002 0 0 0-2 2v14h28V4a2.002 2.002 0 0 0-2-2zM9 28v-7h4v7zm19 0H15v-8a1 1 0 0 0-1-1H8a1 1 0 0 0-1 1v8H4V16h12V4h12z"}),React.createElement("path",{d:"M18 8h2v2h-2zm6 0h2v2h-2zm-6 6h2v2h-2zm6 0h2v2h-2zm-6 6h2v2h-2zm6 0h2v2h-2zM5.5 12a3.5 3.5 0 0 1 0-7h.627A4.006 4.006 0 0 1 10 2h2v2h-2a2.002 2.002 0 0 0-2 2v1H5.5a1.5 1.5 0 0 0 0 3H12v2z"}),props.children);});var BuildingInsights_216=/*#__PURE__*/React.forwardRef(function BuildingInsights_216(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 2H16a2.002 2.002 0 0 0-2 2v10H4a2.002 2.002 0 0 0-2 2v14h28V4a2.002 2.002 0 0 0-2-2zM9 28v-7h4v7zm19 0H15v-8a1 1 0 0 0-1-1H8a1 1 0 0 0-1 1v8H4V16h12V4h12z"}),React.createElement("path",{d:"M18 8h2v2h-2zm6 0h2v2h-2zm-6 6h2v2h-2zm6 0h2v2h-2zm-6 6h2v2h-2zm6 0h2v2h-2zM5.5 12a3.5 3.5 0 0 1 0-7h.627A4.006 4.006 0 0 1 10 2h2v2h-2a2.002 2.002 0 0 0-2 2v1H5.5a1.5 1.5 0 0 0 0 3H12v2z"}),props.children);});var BuildingInsights_332=/*#__PURE__*/React.forwardRef(function BuildingInsights_332(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 2H16a2.002 2.002 0 0 0-2 2v10H4a2.002 2.002 0 0 0-2 2v14h28V4a2.002 2.002 0 0 0-2-2zM9 28v-7h4v7zm19 0H15v-8a1 1 0 0 0-1-1H8a1 1 0 0 0-1 1v8H4V16h12V4h12z"}),React.createElement("path",{d:"M18 8h2v2h-2zm6 0h2v2h-2zm-6 6h2v2h-2zm6 0h2v2h-2zm-6 6h2v2h-2zm6 0h2v2h-2zM2 10h5v2H2zm8-8h2v5h-2zM4 5.414L5.414 4 9 7.585 7.585 9z"}),props.children);});var BuildingInsights_324=/*#__PURE__*/React.forwardRef(function BuildingInsights_324(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 2H16a2.002 2.002 0 0 0-2 2v10H4a2.002 2.002 0 0 0-2 2v14h28V4a2.002 2.002 0 0 0-2-2zM9 28v-7h4v7zm19 0H15v-8a1 1 0 0 0-1-1H8a1 1 0 0 0-1 1v8H4V16h12V4h12z"}),React.createElement("path",{d:"M18 8h2v2h-2zm6 0h2v2h-2zm-6 6h2v2h-2zm6 0h2v2h-2zm-6 6h2v2h-2zm6 0h2v2h-2zM2 10h5v2H2zm8-8h2v5h-2zM4 5.414L5.414 4 9 7.585 7.585 9z"}),props.children);});var BuildingInsights_320=/*#__PURE__*/React.forwardRef(function BuildingInsights_320(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 2H16a2.002 2.002 0 0 0-2 2v10H4a2.002 2.002 0 0 0-2 2v14h28V4a2.002 2.002 0 0 0-2-2zM9 28v-7h4v7zm19 0H15v-8a1 1 0 0 0-1-1H8a1 1 0 0 0-1 1v8H4V16h12V4h12z"}),React.createElement("path",{d:"M18 8h2v2h-2zm6 0h2v2h-2zm-6 6h2v2h-2zm6 0h2v2h-2zm-6 6h2v2h-2zm6 0h2v2h-2zM2 10h5v2H2zm8-8h2v5h-2zM4 5.414L5.414 4 9 7.585 7.585 9z"}),props.children);});var BuildingInsights_316=/*#__PURE__*/React.forwardRef(function BuildingInsights_316(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 2H16a2.002 2.002 0 0 0-2 2v10H4a2.002 2.002 0 0 0-2 2v14h28V4a2.002 2.002 0 0 0-2-2zM9 28v-7h4v7zm19 0H15v-8a1 1 0 0 0-1-1H8a1 1 0 0 0-1 1v8H4V16h12V4h12z"}),React.createElement("path",{d:"M18 8h2v2h-2zm6 0h2v2h-2zm-6 6h2v2h-2zm6 0h2v2h-2zm-6 6h2v2h-2zm6 0h2v2h-2zM2 10h5v2H2zm8-8h2v5h-2zM4 5.414L5.414 4 9 7.585 7.585 9z"}),props.children);});var Building32=/*#__PURE__*/React.forwardRef(function Building32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 2H16a2.002 2.002 0 0 0-2 2v10H4a2.002 2.002 0 0 0-2 2v14h28V4a2.002 2.002 0 0 0-2-2zM9 28v-7h4v7zm19 0H15v-8a1 1 0 0 0-1-1H8a1 1 0 0 0-1 1v8H4V16h12V4h12z"}),React.createElement("path",{d:"M18 8h2v2h-2zm6 0h2v2h-2zm-6 6h2v2h-2zm6 0h2v2h-2zm-6 6h2v2h-2zm6 0h2v2h-2z"}),props.children);});var Building24=/*#__PURE__*/React.forwardRef(function Building24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 2H16a2.002 2.002 0 0 0-2 2v10H4a2.002 2.002 0 0 0-2 2v14h28V4a2.002 2.002 0 0 0-2-2zM9 28v-7h4v7zm19 0H15v-8a1 1 0 0 0-1-1H8a1 1 0 0 0-1 1v8H4V16h12V4h12z"}),React.createElement("path",{d:"M18 8h2v2h-2zm6 0h2v2h-2zm-6 6h2v2h-2zm6 0h2v2h-2zm-6 6h2v2h-2zm6 0h2v2h-2z"}),props.children);});var Building20=/*#__PURE__*/React.forwardRef(function Building20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 2H16a2.002 2.002 0 0 0-2 2v10H4a2.002 2.002 0 0 0-2 2v14h28V4a2.002 2.002 0 0 0-2-2zM9 28v-7h4v7zm19 0H15v-8a1 1 0 0 0-1-1H8a1 1 0 0 0-1 1v8H4V16h12V4h12z"}),React.createElement("path",{d:"M18 8h2v2h-2zm6 0h2v2h-2zm-6 6h2v2h-2zm6 0h2v2h-2zm-6 6h2v2h-2zm6 0h2v2h-2z"}),props.children);});var Building16=/*#__PURE__*/React.forwardRef(function Building16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 2H16a2.002 2.002 0 0 0-2 2v10H4a2.002 2.002 0 0 0-2 2v14h28V4a2.002 2.002 0 0 0-2-2zM9 28v-7h4v7zm19 0H15v-8a1 1 0 0 0-1-1H8a1 1 0 0 0-1 1v8H4V16h12V4h12z"}),React.createElement("path",{d:"M18 8h2v2h-2zm6 0h2v2h-2zm-6 6h2v2h-2zm6 0h2v2h-2zm-6 6h2v2h-2zm6 0h2v2h-2z"}),props.children);});var Bullhorn32=/*#__PURE__*/React.forwardRef(function Bullhorn32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 6v2.17l-20.36 3.7a2 2 0 0 0-1.64 2v4.34a2 2 0 0 0 1.64 2l2.36.35V24a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2v-1.26l6 1.09V26h2V6zm-8 18h-8v-3.07l8 1.45zM6 18.17v-4.34l20-3.63v11.6z"}),props.children);});var Bullhorn24=/*#__PURE__*/React.forwardRef(function Bullhorn24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 6v2.17l-20.36 3.7a2 2 0 0 0-1.64 2v4.34a2 2 0 0 0 1.64 2l2.36.35V24a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2v-1.26l6 1.09V26h2V6zm-8 18h-8v-3.07l8 1.45zM6 18.17v-4.34l20-3.63v11.6z"}),props.children);});var Bullhorn20=/*#__PURE__*/React.forwardRef(function Bullhorn20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 6v2.17l-20.36 3.7a2 2 0 0 0-1.64 2v4.34a2 2 0 0 0 1.64 2l2.36.35V24a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2v-1.26l6 1.09V26h2V6zm-8 18h-8v-3.07l8 1.45zM6 18.17v-4.34l20-3.63v11.6z"}),props.children);});var Bullhorn16=/*#__PURE__*/React.forwardRef(function Bullhorn16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 6v2.17l-20.36 3.7a2 2 0 0 0-1.64 2v4.34a2 2 0 0 0 1.64 2l2.36.35V24a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2v-1.26l6 1.09V26h2V6zm-8 18h-8v-3.07l8 1.45zM6 18.17v-4.34l20-3.63v11.6z"}),props.children);});var Bus32=/*#__PURE__*/React.forwardRef(function Bus32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M3 8h2v6H3zm24 0h2v6h-2zM10 19h2v2h-2zm10 0h2v2h-2z"}),React.createElement("path",{d:"M21 2H11a5 5 0 0 0-5 5v16a2 2 0 0 0 2 2v3h2v-3h12v3h2v-3a2 2 0 0 0 2-2V7a5 5 0 0 0-5-5zm3 6v7H8V8zM11 4h10a3 3 0 0 1 2.82 2H8.18A3 3 0 0 1 11 4zM8 23v-6h16v6z"}),props.children);});var Bus24=/*#__PURE__*/React.forwardRef(function Bus24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M3 8h2v6H3zm24 0h2v6h-2zM10 19h2v2h-2zm10 0h2v2h-2z"}),React.createElement("path",{d:"M21 2H11a5 5 0 0 0-5 5v16a2 2 0 0 0 2 2v3h2v-3h12v3h2v-3a2 2 0 0 0 2-2V7a5 5 0 0 0-5-5zm3 6v7H8V8zM11 4h10a3 3 0 0 1 2.82 2H8.18A3 3 0 0 1 11 4zM8 23v-6h16v6z"}),props.children);});var Bus20=/*#__PURE__*/React.forwardRef(function Bus20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M3 8h2v6H3zm24 0h2v6h-2zM10 19h2v2h-2zm10 0h2v2h-2z"}),React.createElement("path",{d:"M21 2H11a5 5 0 0 0-5 5v16a2 2 0 0 0 2 2v3h2v-3h12v3h2v-3a2 2 0 0 0 2-2V7a5 5 0 0 0-5-5zm3 6v7H8V8zM11 4h10a3 3 0 0 1 2.82 2H8.18A3 3 0 0 1 11 4zM8 23v-6h16v6z"}),props.children);});var Bus16=/*#__PURE__*/React.forwardRef(function Bus16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M3 8h2v6H3zm24 0h2v6h-2zM10 19h2v2h-2zm10 0h2v2h-2z"}),React.createElement("path",{d:"M21 2H11a5 5 0 0 0-5 5v16a2 2 0 0 0 2 2v3h2v-3h12v3h2v-3a2 2 0 0 0 2-2V7a5 5 0 0 0-5-5zm3 6v7H8V8zM11 4h10a3 3 0 0 1 2.82 2H8.18A3 3 0 0 1 11 4zM8 23v-6h16v6z"}),props.children);});var Cafe32=/*#__PURE__*/React.forwardRef(function Cafe32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2 28h28v2H2zm22.5-17H8a2.002 2.002 0 0 0-2 2v8a5.006 5.006 0 0 0 5 5h8a5.006 5.006 0 0 0 5-5v-1h.5a4.5 4.5 0 0 0 0-9zM22 21a3.003 3.003 0 0 1-3 3h-8a3.003 3.003 0 0 1-3-3v-8h14zm2.5-3H24v-5h.5a2.5 2.5 0 0 1 0 5zM19 9h-2v-.146a1.988 1.988 0 0 0-1.105-1.789L13.21 5.724A3.979 3.979 0 0 1 11 2.146V1h2v1.146a1.99 1.99 0 0 0 1.105 1.789l2.684 1.341A3.98 3.98 0 0 1 19 8.854z"}),props.children);});var Cafe24=/*#__PURE__*/React.forwardRef(function Cafe24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2 28h28v2H2zm22.5-17H8a2.002 2.002 0 0 0-2 2v8a5.006 5.006 0 0 0 5 5h8a5.006 5.006 0 0 0 5-5v-1h.5a4.5 4.5 0 0 0 0-9zM22 21a3.003 3.003 0 0 1-3 3h-8a3.003 3.003 0 0 1-3-3v-8h14zm2.5-3H24v-5h.5a2.5 2.5 0 0 1 0 5zM19 9h-2v-.146a1.988 1.988 0 0 0-1.105-1.789L13.21 5.724A3.979 3.979 0 0 1 11 2.146V1h2v1.146a1.99 1.99 0 0 0 1.105 1.789l2.684 1.341A3.98 3.98 0 0 1 19 8.854z"}),props.children);});var Cafe20=/*#__PURE__*/React.forwardRef(function Cafe20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2 28h28v2H2zm22.5-17H8a2.002 2.002 0 0 0-2 2v8a5.006 5.006 0 0 0 5 5h8a5.006 5.006 0 0 0 5-5v-1h.5a4.5 4.5 0 0 0 0-9zM22 21a3.003 3.003 0 0 1-3 3h-8a3.003 3.003 0 0 1-3-3v-8h14zm2.5-3H24v-5h.5a2.5 2.5 0 0 1 0 5zM19 9h-2v-.146a1.988 1.988 0 0 0-1.105-1.789L13.21 5.724A3.979 3.979 0 0 1 11 2.146V1h2v1.146a1.99 1.99 0 0 0 1.105 1.789l2.684 1.341A3.98 3.98 0 0 1 19 8.854z"}),props.children);});var Cafe16=/*#__PURE__*/React.forwardRef(function Cafe16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2 28h28v2H2zm22.5-17H8a2.002 2.002 0 0 0-2 2v8a5.006 5.006 0 0 0 5 5h8a5.006 5.006 0 0 0 5-5v-1h.5a4.5 4.5 0 0 0 0-9zM22 21a3.003 3.003 0 0 1-3 3h-8a3.003 3.003 0 0 1-3-3v-8h14zm2.5-3H24v-5h.5a2.5 2.5 0 0 1 0 5zM19 9h-2v-.146a1.988 1.988 0 0 0-1.105-1.789L13.21 5.724A3.979 3.979 0 0 1 11 2.146V1h2v1.146a1.99 1.99 0 0 0 1.105 1.789l2.684 1.341A3.98 3.98 0 0 1 19 8.854z"}),props.children);});var CalculatorCheck32=/*#__PURE__*/React.forwardRef(function CalculatorCheck32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 26.59L21.41 24 20 25.41l4 4 7-7L29.59 21 24 26.59zM15 23h2v2h-2zm-6 0h2v2H9zm12-5h2v2h-2zm-6 0h2v2h-2zm-6 0h2v2H9zm12-5h2v2h-2zm-6 0h2v2h-2zm-6 0h2v2H9zm0-6h14v3H9z"}),React.createElement("path",{d:"M17 30H6.005A2.007 2.007 0 0 1 4 27.995V3.996A1.998 1.998 0 0 1 5.996 2h20.008A1.998 1.998 0 0 1 28 3.996V18h-2V4H6v24h11z"}),props.children);});var CalculatorCheck24=/*#__PURE__*/React.forwardRef(function CalculatorCheck24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 26.59L21.41 24 20 25.41l4 4 7-7L29.59 21 24 26.59zM15 23h2v2h-2zm-6 0h2v2H9zm12-5h2v2h-2zm-6 0h2v2h-2zm-6 0h2v2H9zm12-5h2v2h-2zm-6 0h2v2h-2zm-6 0h2v2H9zm0-6h14v3H9z"}),React.createElement("path",{d:"M17 30H6.005A2.007 2.007 0 0 1 4 27.995V3.996A1.998 1.998 0 0 1 5.996 2h20.008A1.998 1.998 0 0 1 28 3.996V18h-2V4H6v24h11z"}),props.children);});var CalculatorCheck20=/*#__PURE__*/React.forwardRef(function CalculatorCheck20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 26.59L21.41 24 20 25.41l4 4 7-7L29.59 21 24 26.59zM15 23h2v2h-2zm-6 0h2v2H9zm12-5h2v2h-2zm-6 0h2v2h-2zm-6 0h2v2H9zm12-5h2v2h-2zm-6 0h2v2h-2zm-6 0h2v2H9zm0-6h14v3H9z"}),React.createElement("path",{d:"M17 30H6.005A2.007 2.007 0 0 1 4 27.995V3.996A1.998 1.998 0 0 1 5.996 2h20.008A1.998 1.998 0 0 1 28 3.996V18h-2V4H6v24h11z"}),props.children);});var CalculatorCheck16=/*#__PURE__*/React.forwardRef(function CalculatorCheck16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 26.59L21.41 24 20 25.41l4 4 7-7L29.59 21 24 26.59zM15 23h2v2h-2zm-6 0h2v2H9zm12-5h2v2h-2zm-6 0h2v2h-2zm-6 0h2v2H9zm12-5h2v2h-2zm-6 0h2v2h-2zm-6 0h2v2H9zm0-6h14v3H9z"}),React.createElement("path",{d:"M17 30H6.005A2.007 2.007 0 0 1 4 27.995V3.996A1.998 1.998 0 0 1 5.996 2h20.008A1.998 1.998 0 0 1 28 3.996V18h-2V4H6v24h11z"}),props.children);});var Calculator32=/*#__PURE__*/React.forwardRef(function Calculator32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 4v24H6V4h20m0-2H6a2 2 0 0 0-2 2v24a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2z"}),React.createElement("path",{d:"M9 23h2v2H9zm12 0h2v2h-2zM9 18h2v2H9zm12 0h2v2h-2zM9 13h2v2H9zm6 10h2v2h-2zm0-5h2v2h-2zm0-5h2v2h-2zm6 0h2v2h-2zM9 7h14v3H9z"}),props.children);});var Calculator24=/*#__PURE__*/React.forwardRef(function Calculator24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 4v24H6V4h20m0-2H6a2 2 0 0 0-2 2v24a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2z"}),React.createElement("path",{d:"M9 23h2v2H9zm12 0h2v2h-2zM9 18h2v2H9zm12 0h2v2h-2zM9 13h2v2H9zm6 10h2v2h-2zm0-5h2v2h-2zm0-5h2v2h-2zm6 0h2v2h-2zM9 7h14v3H9z"}),props.children);});var Calculator20=/*#__PURE__*/React.forwardRef(function Calculator20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 4v24H6V4h20m0-2H6a2 2 0 0 0-2 2v24a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2z"}),React.createElement("path",{d:"M9 23h2v2H9zm12 0h2v2h-2zM9 18h2v2H9zm12 0h2v2h-2zM9 13h2v2H9zm6 10h2v2h-2zm0-5h2v2h-2zm0-5h2v2h-2zm6 0h2v2h-2zM9 7h14v3H9z"}),props.children);});var Calculator16=/*#__PURE__*/React.forwardRef(function Calculator16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 4v24H6V4h20m0-2H6a2 2 0 0 0-2 2v24a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2z"}),React.createElement("path",{d:"M9 23h2v2H9zm12 0h2v2h-2zM9 18h2v2H9zm12 0h2v2h-2zM9 13h2v2H9zm6 10h2v2h-2zm0-5h2v2h-2zm0-5h2v2h-2zm6 0h2v2h-2zM9 7h14v3H9z"}),props.children);});var Calendar32=/*#__PURE__*/React.forwardRef(function Calendar32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 4.03h-4v-2h-2v2h-8v-2h-2v2H6a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2v-20a2 2 0 0 0-2-2zm0 22H6v-14h20zm0-16H6v-4h4v2h2v-2h8v2h2v-2h4z"}),props.children);});var Calendar24=/*#__PURE__*/React.forwardRef(function Calendar24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 4.03h-4v-2h-2v2h-8v-2h-2v2H6a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2v-20a2 2 0 0 0-2-2zm0 22H6v-14h20zm0-16H6v-4h4v2h2v-2h8v2h2v-2h4z"}),props.children);});var Calendar20=/*#__PURE__*/React.forwardRef(function Calendar20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 4.03h-4v-2h-2v2h-8v-2h-2v2H6a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2v-20a2 2 0 0 0-2-2zm0 22H6v-14h20zm0-16H6v-4h4v2h2v-2h8v2h2v-2h4z"}),props.children);});var Calibrate32=/*#__PURE__*/React.forwardRef(function Calibrate32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28.83 21.17L25 17.37l.67-.67a1 1 0 0 0 0-1.41l-6-6a1 1 0 0 0-1.41 0l-.79.79-6.76-6.79a1 1 0 0 0-1.41 0l-4 4-.12.15-4 6a1 1 0 0 0 .12 1.26l3 3a1 1 0 0 0 1.42 0L10 13.41l2.09 2.09-4.8 4.79a1 1 0 0 0 0 1.41l2 2a1 1 0 0 0 .71.3 1 1 0 0 0 .52-.15l4.33-2.6 2.44 2.45a1 1 0 0 0 1.41 0l.67-.7 3.79 3.83a4 4 0 0 0 5.66-5.66zM10 10.58l-5 5-1.71-1.71 3.49-5.24L10 5.41l6.09 6.09-2.59 2.58zm8 11l-2.84-2.84-5 3-.74-.74L19 11.41 23.59 16zm9.42 3.83a2 2 0 0 1-2.83 0l-3.8-3.79 2.83-2.83 3.8 3.79a2 2 0 0 1 0 2.83z"}),props.children);});var Calibrate24=/*#__PURE__*/React.forwardRef(function Calibrate24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28.83 21.17L25 17.37l.67-.67a1 1 0 0 0 0-1.41l-6-6a1 1 0 0 0-1.41 0l-.79.79-6.76-6.79a1 1 0 0 0-1.41 0l-4 4-.12.15-4 6a1 1 0 0 0 .12 1.26l3 3a1 1 0 0 0 1.42 0L10 13.41l2.09 2.09-4.8 4.79a1 1 0 0 0 0 1.41l2 2a1 1 0 0 0 .71.3 1 1 0 0 0 .52-.15l4.33-2.6 2.44 2.45a1 1 0 0 0 1.41 0l.67-.7 3.79 3.83a4 4 0 0 0 5.66-5.66zM10 10.58l-5 5-1.71-1.71 3.49-5.24L10 5.41l6.09 6.09-2.59 2.58zm8 11l-2.84-2.84-5 3-.74-.74L19 11.41 23.59 16zm9.42 3.83a2 2 0 0 1-2.83 0l-3.8-3.79 2.83-2.83 3.8 3.79a2 2 0 0 1 0 2.83z"}),props.children);});var Calibrate20=/*#__PURE__*/React.forwardRef(function Calibrate20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28.83 21.17L25 17.37l.67-.67a1 1 0 0 0 0-1.41l-6-6a1 1 0 0 0-1.41 0l-.79.79-6.76-6.79a1 1 0 0 0-1.41 0l-4 4-.12.15-4 6a1 1 0 0 0 .12 1.26l3 3a1 1 0 0 0 1.42 0L10 13.41l2.09 2.09-4.8 4.79a1 1 0 0 0 0 1.41l2 2a1 1 0 0 0 .71.3 1 1 0 0 0 .52-.15l4.33-2.6 2.44 2.45a1 1 0 0 0 1.41 0l.67-.7 3.79 3.83a4 4 0 0 0 5.66-5.66zM10 10.58l-5 5-1.71-1.71 3.49-5.24L10 5.41l6.09 6.09-2.59 2.58zm8 11l-2.84-2.84-5 3-.74-.74L19 11.41 23.59 16zm9.42 3.83a2 2 0 0 1-2.83 0l-3.8-3.79 2.83-2.83 3.8 3.79a2 2 0 0 1 0 2.83z"}),props.children);});var Calibrate16=/*#__PURE__*/React.forwardRef(function Calibrate16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28.83 21.17L25 17.37l.67-.67a1 1 0 0 0 0-1.41l-6-6a1 1 0 0 0-1.41 0l-.79.79-6.76-6.79a1 1 0 0 0-1.41 0l-4 4-.12.15-4 6a1 1 0 0 0 .12 1.26l3 3a1 1 0 0 0 1.42 0L10 13.41l2.09 2.09-4.8 4.79a1 1 0 0 0 0 1.41l2 2a1 1 0 0 0 .71.3 1 1 0 0 0 .52-.15l4.33-2.6 2.44 2.45a1 1 0 0 0 1.41 0l.67-.7 3.79 3.83a4 4 0 0 0 5.66-5.66zM10 10.58l-5 5-1.71-1.71 3.49-5.24L10 5.41l6.09 6.09-2.59 2.58zm8 11l-2.84-2.84-5 3-.74-.74L19 11.41 23.59 16zm9.42 3.83a2 2 0 0 1-2.83 0l-3.8-3.79 2.83-2.83 3.8 3.79a2 2 0 0 1 0 2.83z"}),props.children);});var CameraAction32=/*#__PURE__*/React.forwardRef(function CameraAction32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 23a6 6 0 1 1 6-6 6 6 0 0 1-6 6zm0-10a4 4 0 1 0 4 4 4 4 0 0 0-4-4z"}),React.createElement("path",{d:"M29 27H3a1 1 0 0 1-1-1V6a1 1 0 0 1 1-1h26a1 1 0 0 1 1 1v20a1 1 0 0 1-1 1zM4 25h24V7H4z"}),React.createElement("path",{d:"M19 9h7v2h-7z"}),React.createElement("circle",{cx:"12",cy:"17",r:"1"}),props.children);});var CameraAction24=/*#__PURE__*/React.forwardRef(function CameraAction24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 23a6 6 0 1 1 6-6 6 6 0 0 1-6 6zm0-10a4 4 0 1 0 4 4 4 4 0 0 0-4-4z"}),React.createElement("path",{d:"M29 27H3a1 1 0 0 1-1-1V6a1 1 0 0 1 1-1h26a1 1 0 0 1 1 1v20a1 1 0 0 1-1 1zM4 25h24V7H4z"}),React.createElement("path",{d:"M19 9h7v2h-7z"}),React.createElement("circle",{cx:"12",cy:"17",r:"1"}),props.children);});var CameraAction20=/*#__PURE__*/React.forwardRef(function CameraAction20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 23a6 6 0 1 1 6-6 6 6 0 0 1-6 6zm0-10a4 4 0 1 0 4 4 4 4 0 0 0-4-4z"}),React.createElement("path",{d:"M29 27H3a1 1 0 0 1-1-1V6a1 1 0 0 1 1-1h26a1 1 0 0 1 1 1v20a1 1 0 0 1-1 1zM4 25h24V7H4z"}),React.createElement("path",{d:"M19 9h7v2h-7z"}),React.createElement("circle",{cx:"12",cy:"17",r:"1"}),props.children);});var CameraAction16=/*#__PURE__*/React.forwardRef(function CameraAction16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 23a6 6 0 1 1 6-6 6 6 0 0 1-6 6zm0-10a4 4 0 1 0 4 4 4 4 0 0 0-4-4z"}),React.createElement("path",{d:"M29 27H3a1 1 0 0 1-1-1V6a1 1 0 0 1 1-1h26a1 1 0 0 1 1 1v20a1 1 0 0 1-1 1zM4 25h24V7H4z"}),React.createElement("path",{d:"M19 9h7v2h-7z"}),React.createElement("circle",{cx:"12",cy:"17",r:"1"}),props.children);});var Camera32=/*#__PURE__*/React.forwardRef(function Camera32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29 26H3a1 1 0 0 1-1-1V8a1 1 0 0 1 1-1h6.46l1.71-2.55A1 1 0 0 1 12 4h8a1 1 0 0 1 .83.45L22.54 7H29a1 1 0 0 1 1 1v17a1 1 0 0 1-1 1zM4 24h24V9h-6a1 1 0 0 1-.83-.45L19.46 6h-6.92l-1.71 2.55A1 1 0 0 1 10 9H4z"}),React.createElement("path",{d:"M16 22a6 6 0 1 1 6-6 6 6 0 0 1-6 6zm0-10a4 4 0 1 0 4 4 4 4 0 0 0-4-4z"}),props.children);});var Camera24=/*#__PURE__*/React.forwardRef(function Camera24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29 26H3a1 1 0 0 1-1-1V8a1 1 0 0 1 1-1h6.46l1.71-2.55A1 1 0 0 1 12 4h8a1 1 0 0 1 .83.45L22.54 7H29a1 1 0 0 1 1 1v17a1 1 0 0 1-1 1zM4 24h24V9h-6a1 1 0 0 1-.83-.45L19.46 6h-6.92l-1.71 2.55A1 1 0 0 1 10 9H4z"}),React.createElement("path",{d:"M16 22a6 6 0 1 1 6-6 6 6 0 0 1-6 6zm0-10a4 4 0 1 0 4 4 4 4 0 0 0-4-4z"}),props.children);});var Camera20=/*#__PURE__*/React.forwardRef(function Camera20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29 26H3a1 1 0 0 1-1-1V8a1 1 0 0 1 1-1h6.46l1.71-2.55A1 1 0 0 1 12 4h8a1 1 0 0 1 .83.45L22.54 7H29a1 1 0 0 1 1 1v17a1 1 0 0 1-1 1zM4 24h24V9h-6a1 1 0 0 1-.83-.45L19.46 6h-6.92l-1.71 2.55A1 1 0 0 1 10 9H4z"}),React.createElement("path",{d:"M16 22a6 6 0 1 1 6-6 6 6 0 0 1-6 6zm0-10a4 4 0 1 0 4 4 4 4 0 0 0-4-4z"}),props.children);});var Camera16=/*#__PURE__*/React.forwardRef(function Camera16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29 26H3a1 1 0 0 1-1-1V8a1 1 0 0 1 1-1h6.46l1.71-2.55A1 1 0 0 1 12 4h8a1 1 0 0 1 .83.45L22.54 7H29a1 1 0 0 1 1 1v17a1 1 0 0 1-1 1zM4 24h24V9h-6a1 1 0 0 1-.83-.45L19.46 6h-6.92l-1.71 2.55A1 1 0 0 1 10 9H4z"}),React.createElement("path",{d:"M16 22a6 6 0 1 1 6-6 6 6 0 0 1-6 6zm0-10a4 4 0 1 0 4 4 4 4 0 0 0-4-4z"}),props.children);});var Car32=/*#__PURE__*/React.forwardRef(function Car32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.34 15.94l-7.73-2.78-3.24-4.06A3 3 0 0 0 16.05 8h-8a3 3 0 0 0-2.47 1.32l-2.71 4A5 5 0 0 0 2 16.11V24a1 1 0 0 0 1 1h2.14a4 4 0 0 0 7.72 0h6.28a4 4 0 0 0 7.72 0H29a1 1 0 0 0 1-1v-7.12a1 1 0 0 0-.66-.94zM9 26a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm14 0a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm5-3h-1.14a4 4 0 0 0-7.72 0h-6.28a4 4 0 0 0-7.72 0H4v-6.89a3 3 0 0 1 .52-1.69l2.71-4a1 1 0 0 1 .83-.42h8a1 1 0 0 1 .77.36l3.4 4.27a1.09 1.09 0 0 0 .44.32L28 17.58z"}),props.children);});var Car24=/*#__PURE__*/React.forwardRef(function Car24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.34 15.94l-7.73-2.78-3.24-4.06A3 3 0 0 0 16.05 8h-8a3 3 0 0 0-2.47 1.32l-2.71 4A5 5 0 0 0 2 16.11V24a1 1 0 0 0 1 1h2.14a4 4 0 0 0 7.72 0h6.28a4 4 0 0 0 7.72 0H29a1 1 0 0 0 1-1v-7.12a1 1 0 0 0-.66-.94zM9 26a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm14 0a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm5-3h-1.14a4 4 0 0 0-7.72 0h-6.28a4 4 0 0 0-7.72 0H4v-6.89a3 3 0 0 1 .52-1.69l2.71-4a1 1 0 0 1 .83-.42h8a1 1 0 0 1 .77.36l3.4 4.27a1.09 1.09 0 0 0 .44.32L28 17.58z"}),props.children);});var Car20=/*#__PURE__*/React.forwardRef(function Car20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.34 15.94l-7.73-2.78-3.24-4.06A3 3 0 0 0 16.05 8h-8a3 3 0 0 0-2.47 1.32l-2.71 4A5 5 0 0 0 2 16.11V24a1 1 0 0 0 1 1h2.14a4 4 0 0 0 7.72 0h6.28a4 4 0 0 0 7.72 0H29a1 1 0 0 0 1-1v-7.12a1 1 0 0 0-.66-.94zM9 26a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm14 0a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm5-3h-1.14a4 4 0 0 0-7.72 0h-6.28a4 4 0 0 0-7.72 0H4v-6.89a3 3 0 0 1 .52-1.69l2.71-4a1 1 0 0 1 .83-.42h8a1 1 0 0 1 .77.36l3.4 4.27a1.09 1.09 0 0 0 .44.32L28 17.58z"}),props.children);});var Car16=/*#__PURE__*/React.forwardRef(function Car16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.34 15.94l-7.73-2.78-3.24-4.06A3 3 0 0 0 16.05 8h-8a3 3 0 0 0-2.47 1.32l-2.71 4A5 5 0 0 0 2 16.11V24a1 1 0 0 0 1 1h2.14a4 4 0 0 0 7.72 0h6.28a4 4 0 0 0 7.72 0H29a1 1 0 0 0 1-1v-7.12a1 1 0 0 0-.66-.94zM9 26a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm14 0a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm5-3h-1.14a4 4 0 0 0-7.72 0h-6.28a4 4 0 0 0-7.72 0H4v-6.89a3 3 0 0 1 .52-1.69l2.71-4a1 1 0 0 1 .83-.42h8a1 1 0 0 1 .77.36l3.4 4.27a1.09 1.09 0 0 0 .44.32L28 17.58z"}),props.children);});var Carbon32=/*#__PURE__*/React.forwardRef(function Carbon32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13.5 30.815a1.001 1.001 0 0 1-.493-.13l-8.5-4.815A1 1 0 0 1 4 25V15a1 1 0 0 1 .507-.87l8.5-4.815a1.001 1.001 0 0 1 .986 0l8.5 4.815A1 1 0 0 1 23 15v10a1 1 0 0 1-.507.87l-8.5 4.815a1.001 1.001 0 0 1-.493.13zM6 24.417l7.5 4.248 7.5-4.248v-8.834l-7.5-4.248L6 15.582z"}),React.createElement("path",{d:"M28 17h-2V7.583l-7.5-4.248-8.007 4.535-.986-1.74 8.5-4.815a1.001 1.001 0 0 1 .986 0l8.5 4.815A1 1 0 0 1 28 7z"}),props.children);});var Carbon24=/*#__PURE__*/React.forwardRef(function Carbon24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13.5 30.815a1.001 1.001 0 0 1-.493-.13l-8.5-4.815A1 1 0 0 1 4 25V15a1 1 0 0 1 .507-.87l8.5-4.815a1.001 1.001 0 0 1 .986 0l8.5 4.815A1 1 0 0 1 23 15v10a1 1 0 0 1-.507.87l-8.5 4.815a1.001 1.001 0 0 1-.493.13zM6 24.417l7.5 4.248 7.5-4.248v-8.834l-7.5-4.248L6 15.582z"}),React.createElement("path",{d:"M28 17h-2V7.583l-7.5-4.248-8.007 4.535-.986-1.74 8.5-4.815a1.001 1.001 0 0 1 .986 0l8.5 4.815A1 1 0 0 1 28 7z"}),props.children);});var Carbon20=/*#__PURE__*/React.forwardRef(function Carbon20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13.5 30.815a1.001 1.001 0 0 1-.493-.13l-8.5-4.815A1 1 0 0 1 4 25V15a1 1 0 0 1 .507-.87l8.5-4.815a1.001 1.001 0 0 1 .986 0l8.5 4.815A1 1 0 0 1 23 15v10a1 1 0 0 1-.507.87l-8.5 4.815a1.001 1.001 0 0 1-.493.13zM6 24.417l7.5 4.248 7.5-4.248v-8.834l-7.5-4.248L6 15.582z"}),React.createElement("path",{d:"M28 17h-2V7.583l-7.5-4.248-8.007 4.535-.986-1.74 8.5-4.815a1.001 1.001 0 0 1 .986 0l8.5 4.815A1 1 0 0 1 28 7z"}),props.children);});var Carbon16=/*#__PURE__*/React.forwardRef(function Carbon16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13.5 30.815a1.001 1.001 0 0 1-.493-.13l-8.5-4.815A1 1 0 0 1 4 25V15a1 1 0 0 1 .507-.87l8.5-4.815a1.001 1.001 0 0 1 .986 0l8.5 4.815A1 1 0 0 1 23 15v10a1 1 0 0 1-.507.87l-8.5 4.815a1.001 1.001 0 0 1-.493.13zM6 24.417l7.5 4.248 7.5-4.248v-8.834l-7.5-4.248L6 15.582z"}),React.createElement("path",{d:"M28 17h-2V7.583l-7.5-4.248-8.007 4.535-.986-1.74 8.5-4.815a1.001 1.001 0 0 1 .986 0l8.5 4.815A1 1 0 0 1 28 7z"}),props.children);});var CaretDown32=/*#__PURE__*/React.forwardRef(function CaretDown32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 12l-7 8-7-8h14z"}),props.children);});var CaretDown24=/*#__PURE__*/React.forwardRef(function CaretDown24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 12l-7 8-7-8h14z"}),props.children);});var CaretDown20=/*#__PURE__*/React.forwardRef(function CaretDown20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 12l-7 8-7-8h14z"}),props.children);});var CaretLeft32=/*#__PURE__*/React.forwardRef(function CaretLeft32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19 23l-8-7 8-7v14z"}),props.children);});var CaretLeft24=/*#__PURE__*/React.forwardRef(function CaretLeft24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19 23l-8-7 8-7v14z"}),props.children);});var CaretLeft20=/*#__PURE__*/React.forwardRef(function CaretLeft20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19 23l-8-7 8-7v14z"}),props.children);});var CaretRight32=/*#__PURE__*/React.forwardRef(function CaretRight32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13 9l8 7-8 7V9z"}),props.children);});var CaretRight24=/*#__PURE__*/React.forwardRef(function CaretRight24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13 9l8 7-8 7V9z"}),props.children);});var CaretRight20=/*#__PURE__*/React.forwardRef(function CaretRight20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13 9l8 7-8 7V9z"}),props.children);});var CaretSortDown32=/*#__PURE__*/React.forwardRef(function CaretSortDown32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 20l-7 8-7-8z"}),props.children);});var CaretSortDown24=/*#__PURE__*/React.forwardRef(function CaretSortDown24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 20l-7 8-7-8z"}),props.children);});var CaretSortDown20=/*#__PURE__*/React.forwardRef(function CaretSortDown20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 20l-7 8-7-8z"}),props.children);});var CaretSortUp32=/*#__PURE__*/React.forwardRef(function CaretSortUp32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M9 12l7-8 7 8z"}),props.children);});var CaretSortUp24=/*#__PURE__*/React.forwardRef(function CaretSortUp24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M9 12l7-8 7 8z"}),props.children);});var CaretSortUp20=/*#__PURE__*/React.forwardRef(function CaretSortUp20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M9 12l7-8 7 8z"}),props.children);});var CaretSort32=/*#__PURE__*/React.forwardRef(function CaretSort32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M9 12l7-8 7 8H9zm14 8l-7 8-7-8h14z"}),props.children);});var CaretSort24=/*#__PURE__*/React.forwardRef(function CaretSort24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M9 12l7-8 7 8H9zm14 8l-7 8-7-8h14z"}),props.children);});var CaretSort20=/*#__PURE__*/React.forwardRef(function CaretSort20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M9 12l7-8 7 8H9zm14 8l-7 8-7-8h14z"}),props.children);});var CaretUp32=/*#__PURE__*/React.forwardRef(function CaretUp32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M9 20l7-8 7 8H9z"}),props.children);});var CaretUp24=/*#__PURE__*/React.forwardRef(function CaretUp24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M9 20l7-8 7 8H9z"}),props.children);});var CaretUp20=/*#__PURE__*/React.forwardRef(function CaretUp20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M9 20l7-8 7 8H9z"}),props.children);});var CarouselHorizontal32=/*#__PURE__*/React.forwardRef(function CarouselHorizontal32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22 26H10a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v16a2 2 0 0 1-2 2zM10 8v16h12V8zM4 24H0v-2h4V10H0V8h4a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2zm28 0h-4a2 2 0 0 1-2-2V10a2 2 0 0 1 2-2h4v2h-4v12h4z"}),props.children);});var CarouselHorizontal24=/*#__PURE__*/React.forwardRef(function CarouselHorizontal24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22 26H10a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v16a2 2 0 0 1-2 2zM10 8v16h12V8zM4 24H0v-2h4V10H0V8h4a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2zm28 0h-4a2 2 0 0 1-2-2V10a2 2 0 0 1 2-2h4v2h-4v12h4z"}),props.children);});var CarouselHorizontal20=/*#__PURE__*/React.forwardRef(function CarouselHorizontal20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22 26H10a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v16a2 2 0 0 1-2 2zM10 8v16h12V8zM4 24H0v-2h4V10H0V8h4a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2zm28 0h-4a2 2 0 0 1-2-2V10a2 2 0 0 1 2-2h4v2h-4v12h4z"}),props.children);});var CarouselHorizontal16=/*#__PURE__*/React.forwardRef(function CarouselHorizontal16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22 26H10a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v16a2 2 0 0 1-2 2zM10 8v16h12V8zM4 24H0v-2h4V10H0V8h4a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2zm28 0h-4a2 2 0 0 1-2-2V10a2 2 0 0 1 2-2h4v2h-4v12h4z"}),props.children);});var CarouselVertical32=/*#__PURE__*/React.forwardRef(function CarouselVertical32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 10v12a2 2 0 0 1-2 2H8a2 2 0 0 1-2-2V10a2 2 0 0 1 2-2h16a2 2 0 0 1 2 2zM8 22h16V10H8zm16 6v4h-2v-4H10v4H8v-4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2zm0-28v4a2 2 0 0 1-2 2H10a2 2 0 0 1-2-2V0h2v4h12V0z"}),props.children);});var CarouselVertical24=/*#__PURE__*/React.forwardRef(function CarouselVertical24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 10v12a2 2 0 0 1-2 2H8a2 2 0 0 1-2-2V10a2 2 0 0 1 2-2h16a2 2 0 0 1 2 2zM8 22h16V10H8zm16 6v4h-2v-4H10v4H8v-4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2zm0-28v4a2 2 0 0 1-2 2H10a2 2 0 0 1-2-2V0h2v4h12V0z"}),props.children);});var CarouselVertical20=/*#__PURE__*/React.forwardRef(function CarouselVertical20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 10v12a2 2 0 0 1-2 2H8a2 2 0 0 1-2-2V10a2 2 0 0 1 2-2h16a2 2 0 0 1 2 2zM8 22h16V10H8zm16 6v4h-2v-4H10v4H8v-4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2zm0-28v4a2 2 0 0 1-2 2H10a2 2 0 0 1-2-2V0h2v4h12V0z"}),props.children);});var CarouselVertical16=/*#__PURE__*/React.forwardRef(function CarouselVertical16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 10v12a2 2 0 0 1-2 2H8a2 2 0 0 1-2-2V10a2 2 0 0 1 2-2h16a2 2 0 0 1 2 2zM8 22h16V10H8zm16 6v4h-2v-4H10v4H8v-4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2zm0-28v4a2 2 0 0 1-2 2H10a2 2 0 0 1-2-2V0h2v4h12V0z"}),props.children);});var Catalog32=/*#__PURE__*/React.forwardRef(function Catalog32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 2H8a2 2 0 0 0-2 2v4H4v2h2v5H4v2h2v5H4v2h2v4a2 2 0 0 0 2 2h18a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2zm0 26H8v-4h2v-2H8v-5h2v-2H8v-5h2V8H8V4h18z"}),React.createElement("path",{d:"M14 8h8v2h-8zm0 7h8v2h-8zm0 7h8v2h-8z"}),props.children);});var Catalog24=/*#__PURE__*/React.forwardRef(function Catalog24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 2H8a2 2 0 0 0-2 2v4H4v2h2v5H4v2h2v5H4v2h2v4a2 2 0 0 0 2 2h18a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2zm0 26H8v-4h2v-2H8v-5h2v-2H8v-5h2V8H8V4h18z"}),React.createElement("path",{d:"M14 8h8v2h-8zm0 7h8v2h-8zm0 7h8v2h-8z"}),props.children);});var Catalog20=/*#__PURE__*/React.forwardRef(function Catalog20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 2H8a2 2 0 0 0-2 2v4H4v2h2v5H4v2h2v5H4v2h2v4a2 2 0 0 0 2 2h18a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2zm0 26H8v-4h2v-2H8v-5h2v-2H8v-5h2V8H8V4h18z"}),React.createElement("path",{d:"M14 8h8v2h-8zm0 7h8v2h-8zm0 7h8v2h-8z"}),props.children);});var Catalog16=/*#__PURE__*/React.forwardRef(function Catalog16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 2H8a2 2 0 0 0-2 2v4H4v2h2v5H4v2h2v5H4v2h2v4a2 2 0 0 0 2 2h18a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2zm0 26H8v-4h2v-2H8v-5h2v-2H8v-5h2V8H8V4h18z"}),React.createElement("path",{d:"M14 8h8v2h-8zm0 7h8v2h-8zm0 7h8v2h-8z"}),props.children);});var Categories32=/*#__PURE__*/React.forwardRef(function Categories32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6.76 6l.45.89L7.76 8H12v5H4V6h2.76m.62-2H3a1 1 0 0 0-1 1v9a1 1 0 0 0 1 1h10a1 1 0 0 0 1-1V7a1 1 0 0 0-1-1H9l-.72-1.45a1 1 0 0 0-.9-.55zm15.38 2l.45.89.55 1.11H28v5h-8V6h2.76m.62-2H19a1 1 0 0 0-1 1v9a1 1 0 0 0 1 1h10a1 1 0 0 0 1-1V7a1 1 0 0 0-1-1h-4l-.72-1.45a1 1 0 0 0-.9-.55zM6.76 19l.45.89.55 1.11H12v5H4v-7h2.76m.62-2H3a1 1 0 0 0-1 1v9a1 1 0 0 0 1 1h10a1 1 0 0 0 1-1v-7a1 1 0 0 0-1-1H9l-.72-1.45a1 1 0 0 0-.9-.55zm15.38 2l.45.89.55 1.11H28v5h-8v-7h2.76m.62-2H19a1 1 0 0 0-1 1v9a1 1 0 0 0 1 1h10a1 1 0 0 0 1-1v-7a1 1 0 0 0-1-1h-4l-.72-1.45a1 1 0 0 0-.9-.55z"}),props.children);});var Categories24=/*#__PURE__*/React.forwardRef(function Categories24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6.76 6l.45.89L7.76 8H12v5H4V6h2.76m.62-2H3a1 1 0 0 0-1 1v9a1 1 0 0 0 1 1h10a1 1 0 0 0 1-1V7a1 1 0 0 0-1-1H9l-.72-1.45a1 1 0 0 0-.9-.55zm15.38 2l.45.89.55 1.11H28v5h-8V6h2.76m.62-2H19a1 1 0 0 0-1 1v9a1 1 0 0 0 1 1h10a1 1 0 0 0 1-1V7a1 1 0 0 0-1-1h-4l-.72-1.45a1 1 0 0 0-.9-.55zM6.76 19l.45.89.55 1.11H12v5H4v-7h2.76m.62-2H3a1 1 0 0 0-1 1v9a1 1 0 0 0 1 1h10a1 1 0 0 0 1-1v-7a1 1 0 0 0-1-1H9l-.72-1.45a1 1 0 0 0-.9-.55zm15.38 2l.45.89.55 1.11H28v5h-8v-7h2.76m.62-2H19a1 1 0 0 0-1 1v9a1 1 0 0 0 1 1h10a1 1 0 0 0 1-1v-7a1 1 0 0 0-1-1h-4l-.72-1.45a1 1 0 0 0-.9-.55z"}),props.children);});var Categories20=/*#__PURE__*/React.forwardRef(function Categories20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6.76 6l.45.89L7.76 8H12v5H4V6h2.76m.62-2H3a1 1 0 0 0-1 1v9a1 1 0 0 0 1 1h10a1 1 0 0 0 1-1V7a1 1 0 0 0-1-1H9l-.72-1.45a1 1 0 0 0-.9-.55zm15.38 2l.45.89.55 1.11H28v5h-8V6h2.76m.62-2H19a1 1 0 0 0-1 1v9a1 1 0 0 0 1 1h10a1 1 0 0 0 1-1V7a1 1 0 0 0-1-1h-4l-.72-1.45a1 1 0 0 0-.9-.55zM6.76 19l.45.89.55 1.11H12v5H4v-7h2.76m.62-2H3a1 1 0 0 0-1 1v9a1 1 0 0 0 1 1h10a1 1 0 0 0 1-1v-7a1 1 0 0 0-1-1H9l-.72-1.45a1 1 0 0 0-.9-.55zm15.38 2l.45.89.55 1.11H28v5h-8v-7h2.76m.62-2H19a1 1 0 0 0-1 1v9a1 1 0 0 0 1 1h10a1 1 0 0 0 1-1v-7a1 1 0 0 0-1-1h-4l-.72-1.45a1 1 0 0 0-.9-.55z"}),props.children);});var Categories16=/*#__PURE__*/React.forwardRef(function Categories16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6.76 6l.45.89L7.76 8H12v5H4V6h2.76m.62-2H3a1 1 0 0 0-1 1v9a1 1 0 0 0 1 1h10a1 1 0 0 0 1-1V7a1 1 0 0 0-1-1H9l-.72-1.45a1 1 0 0 0-.9-.55zm15.38 2l.45.89.55 1.11H28v5h-8V6h2.76m.62-2H19a1 1 0 0 0-1 1v9a1 1 0 0 0 1 1h10a1 1 0 0 0 1-1V7a1 1 0 0 0-1-1h-4l-.72-1.45a1 1 0 0 0-.9-.55zM6.76 19l.45.89.55 1.11H12v5H4v-7h2.76m.62-2H3a1 1 0 0 0-1 1v9a1 1 0 0 0 1 1h10a1 1 0 0 0 1-1v-7a1 1 0 0 0-1-1H9l-.72-1.45a1 1 0 0 0-.9-.55zm15.38 2l.45.89.55 1.11H28v5h-8v-7h2.76m.62-2H19a1 1 0 0 0-1 1v9a1 1 0 0 0 1 1h10a1 1 0 0 0 1-1v-7a1 1 0 0 0-1-1h-4l-.72-1.45a1 1 0 0 0-.9-.55z"}),props.children);});var CategoryAdd32=/*#__PURE__*/React.forwardRef(function CategoryAdd32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 6l-1.41 1.41L17.17 11l-3.58 3.59L15 16l5-5-5-5z"}),React.createElement("path",{d:"M28 24H17v-4h6a2.003 2.003 0 0 0 2-2V4a2.002 2.002 0 0 0-2-2H9a2.002 2.002 0 0 0-2 2v14a2.002 2.002 0 0 0 2 2h6v4H4a2 2 0 0 0-2 2v4h2v-4h11v4h2v-4h11v4h2v-4a2 2 0 0 0-2-2zM9 4h14l.002 14H9z"}),props.children);});var CategoryAdd24=/*#__PURE__*/React.forwardRef(function CategoryAdd24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 6l-1.41 1.41L17.17 11l-3.58 3.59L15 16l5-5-5-5z"}),React.createElement("path",{d:"M28 24H17v-4h6a2.003 2.003 0 0 0 2-2V4a2.002 2.002 0 0 0-2-2H9a2.002 2.002 0 0 0-2 2v14a2.002 2.002 0 0 0 2 2h6v4H4a2 2 0 0 0-2 2v4h2v-4h11v4h2v-4h11v4h2v-4a2 2 0 0 0-2-2zM9 4h14l.002 14H9z"}),props.children);});var CategoryAdd20=/*#__PURE__*/React.forwardRef(function CategoryAdd20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 6l-1.41 1.41L17.17 11l-3.58 3.59L15 16l5-5-5-5z"}),React.createElement("path",{d:"M28 24H17v-4h6a2.003 2.003 0 0 0 2-2V4a2.002 2.002 0 0 0-2-2H9a2.002 2.002 0 0 0-2 2v14a2.002 2.002 0 0 0 2 2h6v4H4a2 2 0 0 0-2 2v4h2v-4h11v4h2v-4h11v4h2v-4a2 2 0 0 0-2-2zM9 4h14l.002 14H9z"}),props.children);});var CategoryAdd16=/*#__PURE__*/React.forwardRef(function CategoryAdd16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 6l-1.41 1.41L17.17 11l-3.58 3.59L15 16l5-5-5-5z"}),React.createElement("path",{d:"M28 24H17v-4h6a2.003 2.003 0 0 0 2-2V4a2.002 2.002 0 0 0-2-2H9a2.002 2.002 0 0 0-2 2v14a2.002 2.002 0 0 0 2 2h6v4H4a2 2 0 0 0-2 2v4h2v-4h11v4h2v-4h11v4h2v-4a2 2 0 0 0-2-2zM9 4h14l.002 14H9z"}),props.children);});var CategoryAnd32=/*#__PURE__*/React.forwardRef(function CategoryAnd32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4 30v-4h11v4h2v-4h11v4h2v-4a2 2 0 0 0-2-2H17v-5h-2v5H4a2 2 0 0 0-2 2v4zm16.695-16.014A10.08 10.08 0 0 0 21.946 10H23V8h-3v1a9.263 9.263 0 0 1-.664 3.27L16.65 8.883a5.126 5.126 0 0 0 2.144-2.37 3.252 3.252 0 0 0-.189-2.702 3.38 3.38 0 0 0-2.239-1.706 3.469 3.469 0 0 0-4.222 2.119c-.505 1.552.44 3.116 1.261 4.108a4.726 4.726 0 0 0-2.346 4.828A4.453 4.453 0 0 0 15.427 17h.006a5.784 5.784 0 0 0 3.971-1.423L20.532 17h2.552zM14.047 4.84A1.322 1.322 0 0 1 15.414 4a2.41 2.41 0 0 1 .521.058 1.402 1.402 0 0 1 .912.702 1.25 1.25 0 0 1 .079 1.042 3.687 3.687 0 0 1-1.682 1.593c-.66-.713-1.435-1.822-1.197-2.554zM15.432 15h-.004a2.443 2.443 0 0 1-2.392-2.15 2.826 2.826 0 0 1 1.81-3.026l3.312 4.179a3.885 3.885 0 0 1-2.726.997z"}),props.children);});var CategoryAnd24=/*#__PURE__*/React.forwardRef(function CategoryAnd24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4 30v-4h11v4h2v-4h11v4h2v-4a2 2 0 0 0-2-2H17v-5h-2v5H4a2 2 0 0 0-2 2v4zm16.695-16.014A10.08 10.08 0 0 0 21.946 10H23V8h-3v1a9.263 9.263 0 0 1-.664 3.27L16.65 8.883a5.126 5.126 0 0 0 2.144-2.37 3.252 3.252 0 0 0-.189-2.702 3.38 3.38 0 0 0-2.239-1.706 3.469 3.469 0 0 0-4.222 2.119c-.505 1.552.44 3.116 1.261 4.108a4.726 4.726 0 0 0-2.346 4.828A4.453 4.453 0 0 0 15.427 17h.006a5.784 5.784 0 0 0 3.971-1.423L20.532 17h2.552zM14.047 4.84A1.322 1.322 0 0 1 15.414 4a2.41 2.41 0 0 1 .521.058 1.402 1.402 0 0 1 .912.702 1.25 1.25 0 0 1 .079 1.042 3.687 3.687 0 0 1-1.682 1.593c-.66-.713-1.435-1.822-1.197-2.554zM15.432 15h-.004a2.443 2.443 0 0 1-2.392-2.15 2.826 2.826 0 0 1 1.81-3.026l3.312 4.179a3.885 3.885 0 0 1-2.726.997z"}),props.children);});var CategoryAnd20=/*#__PURE__*/React.forwardRef(function CategoryAnd20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4 30v-4h11v4h2v-4h11v4h2v-4a2 2 0 0 0-2-2H17v-5h-2v5H4a2 2 0 0 0-2 2v4zm16.695-16.014A10.08 10.08 0 0 0 21.946 10H23V8h-3v1a9.263 9.263 0 0 1-.664 3.27L16.65 8.883a5.126 5.126 0 0 0 2.144-2.37 3.252 3.252 0 0 0-.189-2.702 3.38 3.38 0 0 0-2.239-1.706 3.469 3.469 0 0 0-4.222 2.119c-.505 1.552.44 3.116 1.261 4.108a4.726 4.726 0 0 0-2.346 4.828A4.453 4.453 0 0 0 15.427 17h.006a5.784 5.784 0 0 0 3.971-1.423L20.532 17h2.552zM14.047 4.84A1.322 1.322 0 0 1 15.414 4a2.41 2.41 0 0 1 .521.058 1.402 1.402 0 0 1 .912.702 1.25 1.25 0 0 1 .079 1.042 3.687 3.687 0 0 1-1.682 1.593c-.66-.713-1.435-1.822-1.197-2.554zM15.432 15h-.004a2.443 2.443 0 0 1-2.392-2.15 2.826 2.826 0 0 1 1.81-3.026l3.312 4.179a3.885 3.885 0 0 1-2.726.997z"}),props.children);});var CategoryAnd16=/*#__PURE__*/React.forwardRef(function CategoryAnd16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4 30v-4h11v4h2v-4h11v4h2v-4a2 2 0 0 0-2-2H17v-5h-2v5H4a2 2 0 0 0-2 2v4zm16.695-16.014A10.08 10.08 0 0 0 21.946 10H23V8h-3v1a9.263 9.263 0 0 1-.664 3.27L16.65 8.883a5.126 5.126 0 0 0 2.144-2.37 3.252 3.252 0 0 0-.189-2.702 3.38 3.38 0 0 0-2.239-1.706 3.469 3.469 0 0 0-4.222 2.119c-.505 1.552.44 3.116 1.261 4.108a4.726 4.726 0 0 0-2.346 4.828A4.453 4.453 0 0 0 15.427 17h.006a5.784 5.784 0 0 0 3.971-1.423L20.532 17h2.552zM14.047 4.84A1.322 1.322 0 0 1 15.414 4a2.41 2.41 0 0 1 .521.058 1.402 1.402 0 0 1 .912.702 1.25 1.25 0 0 1 .079 1.042 3.687 3.687 0 0 1-1.682 1.593c-.66-.713-1.435-1.822-1.197-2.554zM15.432 15h-.004a2.443 2.443 0 0 1-2.392-2.15 2.826 2.826 0 0 1 1.81-3.026l3.312 4.179a3.885 3.885 0 0 1-2.726.997z"}),props.children);});var CategoryNewEach32=/*#__PURE__*/React.forwardRef(function CategoryNewEach32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29 10h-5v2h5v6h-7v2h3v2.142a4 4 0 1 0 2 0V20h2a2.003 2.003 0 0 0 2-2v-6a2.002 2.002 0 0 0-2-2zm-1 16a2 2 0 1 1-2-2 2.003 2.003 0 0 1 2 2zM19 6h-5v2h5v6h-7v2h3v6.142a4 4 0 1 0 2 0V16h2a2.002 2.002 0 0 0 2-2V8a2.002 2.002 0 0 0-2-2zm-1 20a2 2 0 1 1-2-2 2.003 2.003 0 0 1 2 2zM9 2H3a2.002 2.002 0 0 0-2 2v6a2.002 2.002 0 0 0 2 2h2v10.142a4 4 0 1 0 2 0V12h2a2.002 2.002 0 0 0 2-2V4a2.002 2.002 0 0 0-2-2zM8 26a2 2 0 1 1-2-2 2.002 2.002 0 0 1 2 2zM3 10V4h6l.002 6z"}),props.children);});var CategoryNewEach24=/*#__PURE__*/React.forwardRef(function CategoryNewEach24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29 10h-5v2h5v6h-7v2h3v2.142a4 4 0 1 0 2 0V20h2a2.003 2.003 0 0 0 2-2v-6a2.002 2.002 0 0 0-2-2zm-1 16a2 2 0 1 1-2-2 2.003 2.003 0 0 1 2 2zM19 6h-5v2h5v6h-7v2h3v6.142a4 4 0 1 0 2 0V16h2a2.002 2.002 0 0 0 2-2V8a2.002 2.002 0 0 0-2-2zm-1 20a2 2 0 1 1-2-2 2.003 2.003 0 0 1 2 2zM9 2H3a2.002 2.002 0 0 0-2 2v6a2.002 2.002 0 0 0 2 2h2v10.142a4 4 0 1 0 2 0V12h2a2.002 2.002 0 0 0 2-2V4a2.002 2.002 0 0 0-2-2zM8 26a2 2 0 1 1-2-2 2.002 2.002 0 0 1 2 2zM3 10V4h6l.002 6z"}),props.children);});var CategoryNewEach20=/*#__PURE__*/React.forwardRef(function CategoryNewEach20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29 10h-5v2h5v6h-7v2h3v2.142a4 4 0 1 0 2 0V20h2a2.003 2.003 0 0 0 2-2v-6a2.002 2.002 0 0 0-2-2zm-1 16a2 2 0 1 1-2-2 2.003 2.003 0 0 1 2 2zM19 6h-5v2h5v6h-7v2h3v6.142a4 4 0 1 0 2 0V16h2a2.002 2.002 0 0 0 2-2V8a2.002 2.002 0 0 0-2-2zm-1 20a2 2 0 1 1-2-2 2.003 2.003 0 0 1 2 2zM9 2H3a2.002 2.002 0 0 0-2 2v6a2.002 2.002 0 0 0 2 2h2v10.142a4 4 0 1 0 2 0V12h2a2.002 2.002 0 0 0 2-2V4a2.002 2.002 0 0 0-2-2zM8 26a2 2 0 1 1-2-2 2.002 2.002 0 0 1 2 2zM3 10V4h6l.002 6z"}),props.children);});var CategoryNewEach16=/*#__PURE__*/React.forwardRef(function CategoryNewEach16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29 10h-5v2h5v6h-7v2h3v2.142a4 4 0 1 0 2 0V20h2a2.003 2.003 0 0 0 2-2v-6a2.002 2.002 0 0 0-2-2zm-1 16a2 2 0 1 1-2-2 2.003 2.003 0 0 1 2 2zM19 6h-5v2h5v6h-7v2h3v6.142a4 4 0 1 0 2 0V16h2a2.002 2.002 0 0 0 2-2V8a2.002 2.002 0 0 0-2-2zm-1 20a2 2 0 1 1-2-2 2.003 2.003 0 0 1 2 2zM9 2H3a2.002 2.002 0 0 0-2 2v6a2.002 2.002 0 0 0 2 2h2v10.142a4 4 0 1 0 2 0V12h2a2.002 2.002 0 0 0 2-2V4a2.002 2.002 0 0 0-2-2zM8 26a2 2 0 1 1-2-2 2.002 2.002 0 0 1 2 2zM3 10V4h6l.002 6z"}),props.children);});var CategoryNew32=/*#__PURE__*/React.forwardRef(function CategoryNew32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21 10h-4V6h-2v4h-4v2h4v4h2v-4h4v-2z"}),React.createElement("path",{d:"M28 24H17v-4h6a2.003 2.003 0 0 0 2-2V4a2.002 2.002 0 0 0-2-2H9a2.002 2.002 0 0 0-2 2v14a2.002 2.002 0 0 0 2 2h6v4H4a2 2 0 0 0-2 2v4h2v-4h11v4h2v-4h11v4h2v-4a2 2 0 0 0-2-2zM9 4h14l.002 14H9z"}),props.children);});var CategoryNew24=/*#__PURE__*/React.forwardRef(function CategoryNew24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21 10h-4V6h-2v4h-4v2h4v4h2v-4h4v-2z"}),React.createElement("path",{d:"M28 24H17v-4h6a2.003 2.003 0 0 0 2-2V4a2.002 2.002 0 0 0-2-2H9a2.002 2.002 0 0 0-2 2v14a2.002 2.002 0 0 0 2 2h6v4H4a2 2 0 0 0-2 2v4h2v-4h11v4h2v-4h11v4h2v-4a2 2 0 0 0-2-2zM9 4h14l.002 14H9z"}),props.children);});var CategoryNew20=/*#__PURE__*/React.forwardRef(function CategoryNew20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21 10h-4V6h-2v4h-4v2h4v4h2v-4h4v-2z"}),React.createElement("path",{d:"M28 24H17v-4h6a2.003 2.003 0 0 0 2-2V4a2.002 2.002 0 0 0-2-2H9a2.002 2.002 0 0 0-2 2v14a2.002 2.002 0 0 0 2 2h6v4H4a2 2 0 0 0-2 2v4h2v-4h11v4h2v-4h11v4h2v-4a2 2 0 0 0-2-2zM9 4h14l.002 14H9z"}),props.children);});var CategoryNew16=/*#__PURE__*/React.forwardRef(function CategoryNew16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21 10h-4V6h-2v4h-4v2h4v4h2v-4h4v-2z"}),React.createElement("path",{d:"M28 24H17v-4h6a2.003 2.003 0 0 0 2-2V4a2.002 2.002 0 0 0-2-2H9a2.002 2.002 0 0 0-2 2v14a2.002 2.002 0 0 0 2 2h6v4H4a2 2 0 0 0-2 2v4h2v-4h11v4h2v-4h11v4h2v-4a2 2 0 0 0-2-2zM9 4h14l.002 14H9z"}),props.children);});var Category32=/*#__PURE__*/React.forwardRef(function Category32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27 22.141V18a2 2 0 0 0-2-2h-8v-4h2a2.002 2.002 0 0 0 2-2V4a2.002 2.002 0 0 0-2-2h-6a2.002 2.002 0 0 0-2 2v6a2.002 2.002 0 0 0 2 2h2v4H7a2 2 0 0 0-2 2v4.142a4 4 0 1 0 2 0V18h8v4.142a4 4 0 1 0 2 0V18h8v4.141a4 4 0 1 0 2 0zM13 4h6l.001 6H13zM8 26a2 2 0 1 1-2-2 2.002 2.002 0 0 1 2 2zm10 0a2 2 0 1 1-2-2 2.003 2.003 0 0 1 2 2zm8 2a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2z"}),props.children);});var Category24=/*#__PURE__*/React.forwardRef(function Category24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27 22.141V18a2 2 0 0 0-2-2h-8v-4h2a2.002 2.002 0 0 0 2-2V4a2.002 2.002 0 0 0-2-2h-6a2.002 2.002 0 0 0-2 2v6a2.002 2.002 0 0 0 2 2h2v4H7a2 2 0 0 0-2 2v4.142a4 4 0 1 0 2 0V18h8v4.142a4 4 0 1 0 2 0V18h8v4.141a4 4 0 1 0 2 0zM13 4h6l.001 6H13zM8 26a2 2 0 1 1-2-2 2.002 2.002 0 0 1 2 2zm10 0a2 2 0 1 1-2-2 2.003 2.003 0 0 1 2 2zm8 2a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2z"}),props.children);});var Category20=/*#__PURE__*/React.forwardRef(function Category20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27 22.141V18a2 2 0 0 0-2-2h-8v-4h2a2.002 2.002 0 0 0 2-2V4a2.002 2.002 0 0 0-2-2h-6a2.002 2.002 0 0 0-2 2v6a2.002 2.002 0 0 0 2 2h2v4H7a2 2 0 0 0-2 2v4.142a4 4 0 1 0 2 0V18h8v4.142a4 4 0 1 0 2 0V18h8v4.141a4 4 0 1 0 2 0zM13 4h6l.001 6H13zM8 26a2 2 0 1 1-2-2 2.002 2.002 0 0 1 2 2zm10 0a2 2 0 1 1-2-2 2.003 2.003 0 0 1 2 2zm8 2a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2z"}),props.children);});var Category16=/*#__PURE__*/React.forwardRef(function Category16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27 22.141V18a2 2 0 0 0-2-2h-8v-4h2a2.002 2.002 0 0 0 2-2V4a2.002 2.002 0 0 0-2-2h-6a2.002 2.002 0 0 0-2 2v6a2.002 2.002 0 0 0 2 2h2v4H7a2 2 0 0 0-2 2v4.142a4 4 0 1 0 2 0V18h8v4.142a4 4 0 1 0 2 0V18h8v4.141a4 4 0 1 0 2 0zM13 4h6l.001 6H13zM8 26a2 2 0 1 1-2-2 2.002 2.002 0 0 1 2 2zm10 0a2 2 0 1 1-2-2 2.003 2.003 0 0 1 2 2zm8 2a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2z"}),props.children);});var ChartBar32=/*#__PURE__*/React.forwardRef(function ChartBar32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27 28V6h-8v22h-4V14H7v14H4V2H2v26a2 2 0 0 0 2 2h26v-2zm-14 0H9V16h4zm12 0h-4V8h4z"}),props.children);});var ChartBar24=/*#__PURE__*/React.forwardRef(function ChartBar24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27 28V6h-8v22h-4V14H7v14H4V2H2v26a2 2 0 0 0 2 2h26v-2zm-14 0H9V16h4zm12 0h-4V8h4z"}),props.children);});var ChartBar20=/*#__PURE__*/React.forwardRef(function ChartBar20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27 28V6h-8v22h-4V14H7v14H4V2H2v26a2 2 0 0 0 2 2h26v-2zm-14 0H9V16h4zm12 0h-4V8h4z"}),props.children);});var ChartBar16=/*#__PURE__*/React.forwardRef(function ChartBar16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27 28V6h-8v22h-4V14H7v14H4V2H2v26a2 2 0 0 0 2 2h26v-2zm-14 0H9V16h4zm12 0h-4V8h4z"}),props.children);});var ChartBubble32=/*#__PURE__*/React.forwardRef(function ChartBubble32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 30H4a2 2 0 0 1-2-2V2h2v26h26z"}),React.createElement("path",{d:"M10 16a2 2 0 1 1-2 2 2 2 0 0 1 2-2m0-2a4 4 0 1 0 4 4 4 4 0 0 0-4-4zm11-8a4 4 0 1 1-4 4 4 4 0 0 1 4-4m0-2a6 6 0 1 0 6 6 6 6 0 0 0-6-6zm3.5 17a1.5 1.5 0 1 1-1.5 1.5 1.5 1.5 0 0 1 1.5-1.5m0-2a3.5 3.5 0 1 0 3.5 3.5 3.5 3.5 0 0 0-3.5-3.5z"}),props.children);});var ChartBubble24=/*#__PURE__*/React.forwardRef(function ChartBubble24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 30H4a2 2 0 0 1-2-2V2h2v26h26z"}),React.createElement("path",{d:"M10 16a2 2 0 1 1-2 2 2 2 0 0 1 2-2m0-2a4 4 0 1 0 4 4 4 4 0 0 0-4-4zm11-8a4 4 0 1 1-4 4 4 4 0 0 1 4-4m0-2a6 6 0 1 0 6 6 6 6 0 0 0-6-6zm3.5 17a1.5 1.5 0 1 1-1.5 1.5 1.5 1.5 0 0 1 1.5-1.5m0-2a3.5 3.5 0 1 0 3.5 3.5 3.5 3.5 0 0 0-3.5-3.5z"}),props.children);});var ChartBubble20=/*#__PURE__*/React.forwardRef(function ChartBubble20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 30H4a2 2 0 0 1-2-2V2h2v26h26z"}),React.createElement("path",{d:"M10 16a2 2 0 1 1-2 2 2 2 0 0 1 2-2m0-2a4 4 0 1 0 4 4 4 4 0 0 0-4-4zm11-8a4 4 0 1 1-4 4 4 4 0 0 1 4-4m0-2a6 6 0 1 0 6 6 6 6 0 0 0-6-6zm3.5 17a1.5 1.5 0 1 1-1.5 1.5 1.5 1.5 0 0 1 1.5-1.5m0-2a3.5 3.5 0 1 0 3.5 3.5 3.5 3.5 0 0 0-3.5-3.5z"}),props.children);});var ChartBubble16=/*#__PURE__*/React.forwardRef(function ChartBubble16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 30H4a2 2 0 0 1-2-2V2h2v26h26z"}),React.createElement("path",{d:"M10 16a2 2 0 1 1-2 2 2 2 0 0 1 2-2m0-2a4 4 0 1 0 4 4 4 4 0 0 0-4-4zm11-8a4 4 0 1 1-4 4 4 4 0 0 1 4-4m0-2a6 6 0 1 0 6 6 6 6 0 0 0-6-6zm3.5 17a1.5 1.5 0 1 1-1.5 1.5 1.5 1.5 0 0 1 1.5-1.5m0-2a3.5 3.5 0 1 0 3.5 3.5 3.5 3.5 0 0 0-3.5-3.5z"}),props.children);});var ChartLineData32=/*#__PURE__*/React.forwardRef(function ChartLineData32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10.06 17.88A4.25 4.25 0 0 0 11 18a4 4 0 0 0 2.23-.68l3.22 2.87a3.88 3.88 0 0 0-.2 3.17A4 4 0 1 0 22.62 19l2.54-5.09a3.78 3.78 0 0 0 2.91-.53 4 4 0 1 0-4.69-.38l-2.54 5.09A3.86 3.86 0 0 0 20 18a4 4 0 0 0-2.23.68l-3.22-2.87a3.88 3.88 0 0 0 .2-3.17 4 4 0 1 0-6.45 4.29L4 25V2H2v26a2 2 0 0 0 2 2h26v-2H4.67zM26 8a2 2 0 1 1-2 2 2 2 0 0 1 2-2zm-4 14a2 2 0 1 1-2-2 2 2 0 0 1 2 2zM11 12a2 2 0 1 1-2 2 2 2 0 0 1 2-2z"}),props.children);});var ChartLineData24=/*#__PURE__*/React.forwardRef(function ChartLineData24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10.06 17.88A4.25 4.25 0 0 0 11 18a4 4 0 0 0 2.23-.68l3.22 2.87a3.88 3.88 0 0 0-.2 3.17A4 4 0 1 0 22.62 19l2.54-5.09a3.78 3.78 0 0 0 2.91-.53 4 4 0 1 0-4.69-.38l-2.54 5.09A3.86 3.86 0 0 0 20 18a4 4 0 0 0-2.23.68l-3.22-2.87a3.88 3.88 0 0 0 .2-3.17 4 4 0 1 0-6.45 4.29L4 25V2H2v26a2 2 0 0 0 2 2h26v-2H4.67zM26 8a2 2 0 1 1-2 2 2 2 0 0 1 2-2zm-4 14a2 2 0 1 1-2-2 2 2 0 0 1 2 2zM11 12a2 2 0 1 1-2 2 2 2 0 0 1 2-2z"}),props.children);});var ChartLineData20=/*#__PURE__*/React.forwardRef(function ChartLineData20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10.06 17.88A4.25 4.25 0 0 0 11 18a4 4 0 0 0 2.23-.68l3.22 2.87a3.88 3.88 0 0 0-.2 3.17A4 4 0 1 0 22.62 19l2.54-5.09a3.78 3.78 0 0 0 2.91-.53 4 4 0 1 0-4.69-.38l-2.54 5.09A3.86 3.86 0 0 0 20 18a4 4 0 0 0-2.23.68l-3.22-2.87a3.88 3.88 0 0 0 .2-3.17 4 4 0 1 0-6.45 4.29L4 25V2H2v26a2 2 0 0 0 2 2h26v-2H4.67zM26 8a2 2 0 1 1-2 2 2 2 0 0 1 2-2zm-4 14a2 2 0 1 1-2-2 2 2 0 0 1 2 2zM11 12a2 2 0 1 1-2 2 2 2 0 0 1 2-2z"}),props.children);});var ChartLineData16=/*#__PURE__*/React.forwardRef(function ChartLineData16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10.06 17.88A4.25 4.25 0 0 0 11 18a4 4 0 0 0 2.23-.68l3.22 2.87a3.88 3.88 0 0 0-.2 3.17A4 4 0 1 0 22.62 19l2.54-5.09a3.78 3.78 0 0 0 2.91-.53 4 4 0 1 0-4.69-.38l-2.54 5.09A3.86 3.86 0 0 0 20 18a4 4 0 0 0-2.23.68l-3.22-2.87a3.88 3.88 0 0 0 .2-3.17 4 4 0 1 0-6.45 4.29L4 25V2H2v26a2 2 0 0 0 2 2h26v-2H4.67zM26 8a2 2 0 1 1-2 2 2 2 0 0 1 2-2zm-4 14a2 2 0 1 1-2-2 2 2 0 0 1 2 2zM11 12a2 2 0 1 1-2 2 2 2 0 0 1 2-2z"}),props.children);});var ChartLine32=/*#__PURE__*/React.forwardRef(function ChartLine32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4.67 28l6.39-12 7.3 6.49a2 2 0 0 0 1.7.47 2 2 0 0 0 1.42-1.07L27 10.9l-1.82-.9-5.49 11-7.3-6.49a2 2 0 0 0-1.68-.51 2 2 0 0 0-1.42 1L4 25V2H2v26a2 2 0 0 0 2 2h26v-2z"}),props.children);});var ChartLine24=/*#__PURE__*/React.forwardRef(function ChartLine24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4.67 28l6.39-12 7.3 6.49a2 2 0 0 0 1.7.47 2 2 0 0 0 1.42-1.07L27 10.9l-1.82-.9-5.49 11-7.3-6.49a2 2 0 0 0-1.68-.51 2 2 0 0 0-1.42 1L4 25V2H2v26a2 2 0 0 0 2 2h26v-2z"}),props.children);});var ChartLine20=/*#__PURE__*/React.forwardRef(function ChartLine20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4.67 28l6.39-12 7.3 6.49a2 2 0 0 0 1.7.47 2 2 0 0 0 1.42-1.07L27 10.9l-1.82-.9-5.49 11-7.3-6.49a2 2 0 0 0-1.68-.51 2 2 0 0 0-1.42 1L4 25V2H2v26a2 2 0 0 0 2 2h26v-2z"}),props.children);});var ChartLine16=/*#__PURE__*/React.forwardRef(function ChartLine16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4.67 28l6.39-12 7.3 6.49a2 2 0 0 0 1.7.47 2 2 0 0 0 1.42-1.07L27 10.9l-1.82-.9-5.49 11-7.3-6.49a2 2 0 0 0-1.68-.51 2 2 0 0 0-1.42 1L4 25V2H2v26a2 2 0 0 0 2 2h26v-2z"}),props.children);});var ChartNetwork32=/*#__PURE__*/React.forwardRef(function ChartNetwork32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 14a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2h-6a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h2v4.1a5 5 0 0 0-3.9 3.9H14v-2a2 2 0 0 0-2-2h-2v-4.1a5 5 0 1 0-2 0V18H6a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2v-2h4.1a5 5 0 1 0 5.9-5.9V14zM6 9a3 3 0 1 1 3 3 3 3 0 0 1-3-3zm6 17H6v-6h6zm14-3a3 3 0 1 1-3-3 3 3 0 0 1 3 3zM20 6h6v6h-6z"}),props.children);});var ChartNetwork24=/*#__PURE__*/React.forwardRef(function ChartNetwork24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 14a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2h-6a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h2v4.1a5 5 0 0 0-3.9 3.9H14v-2a2 2 0 0 0-2-2h-2v-4.1a5 5 0 1 0-2 0V18H6a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2v-2h4.1a5 5 0 1 0 5.9-5.9V14zM6 9a3 3 0 1 1 3 3 3 3 0 0 1-3-3zm6 17H6v-6h6zm14-3a3 3 0 1 1-3-3 3 3 0 0 1 3 3zM20 6h6v6h-6z"}),props.children);});var ChartNetwork20=/*#__PURE__*/React.forwardRef(function ChartNetwork20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 14a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2h-6a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h2v4.1a5 5 0 0 0-3.9 3.9H14v-2a2 2 0 0 0-2-2h-2v-4.1a5 5 0 1 0-2 0V18H6a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2v-2h4.1a5 5 0 1 0 5.9-5.9V14zM6 9a3 3 0 1 1 3 3 3 3 0 0 1-3-3zm6 17H6v-6h6zm14-3a3 3 0 1 1-3-3 3 3 0 0 1 3 3zM20 6h6v6h-6z"}),props.children);});var ChartNetwork16=/*#__PURE__*/React.forwardRef(function ChartNetwork16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 14a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2h-6a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h2v4.1a5 5 0 0 0-3.9 3.9H14v-2a2 2 0 0 0-2-2h-2v-4.1a5 5 0 1 0-2 0V18H6a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2v-2h4.1a5 5 0 1 0 5.9-5.9V14zM6 9a3 3 0 1 1 3 3 3 3 0 0 1-3-3zm6 17H6v-6h6zm14-3a3 3 0 1 1-3-3 3 3 0 0 1 3 3zM20 6h6v6h-6z"}),props.children);});var ChartPie32=/*#__PURE__*/React.forwardRef(function ChartPie32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 4a12 12 0 1 0 12 12A12 12 0 0 0 16 4zm10 11h-9V6.05A10 10 0 0 1 26 15zM15.42 26A10 10 0 0 1 15 6.05v9a2 2 0 0 0 2 2h9A10 10 0 0 1 15.42 26z"}),props.children);});var ChartPie24=/*#__PURE__*/React.forwardRef(function ChartPie24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 4a12 12 0 1 0 12 12A12 12 0 0 0 16 4zm10 11h-9V6.05A10 10 0 0 1 26 15zM15.42 26A10 10 0 0 1 15 6.05v9a2 2 0 0 0 2 2h9A10 10 0 0 1 15.42 26z"}),props.children);});var ChartPie20=/*#__PURE__*/React.forwardRef(function ChartPie20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 4a12 12 0 1 0 12 12A12 12 0 0 0 16 4zm10 11h-9V6.05A10 10 0 0 1 26 15zM15.42 26A10 10 0 0 1 15 6.05v9a2 2 0 0 0 2 2h9A10 10 0 0 1 15.42 26z"}),props.children);});var ChartPie16=/*#__PURE__*/React.forwardRef(function ChartPie16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 4a12 12 0 1 0 12 12A12 12 0 0 0 16 4zm10 11h-9V6.05A10 10 0 0 1 26 15zM15.42 26A10 10 0 0 1 15 6.05v9a2 2 0 0 0 2 2h9A10 10 0 0 1 15.42 26z"}),props.children);});var ChartScatter32=/*#__PURE__*/React.forwardRef(function ChartScatter32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 30H4a2 2 0 0 1-2-2V2h2v26h26z"}),React.createElement("circle",{cx:"10",cy:"22",r:"2"}),React.createElement("circle",{cx:"14",cy:"15",r:"2"}),React.createElement("circle",{cx:"22",cy:"15",r:"2"}),React.createElement("circle",{cx:"26",cy:"6",r:"2"}),React.createElement("circle",{cx:"14",cy:"8",r:"2"}),props.children);});var ChartScatter24=/*#__PURE__*/React.forwardRef(function ChartScatter24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 30H4a2 2 0 0 1-2-2V2h2v26h26z"}),React.createElement("circle",{cx:"10",cy:"22",r:"2"}),React.createElement("circle",{cx:"14",cy:"15",r:"2"}),React.createElement("circle",{cx:"22",cy:"15",r:"2"}),React.createElement("circle",{cx:"26",cy:"6",r:"2"}),React.createElement("circle",{cx:"14",cy:"8",r:"2"}),props.children);});var ChartScatter20=/*#__PURE__*/React.forwardRef(function ChartScatter20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 30H4a2 2 0 0 1-2-2V2h2v26h26z"}),React.createElement("circle",{cx:"10",cy:"22",r:"2"}),React.createElement("circle",{cx:"14",cy:"15",r:"2"}),React.createElement("circle",{cx:"22",cy:"15",r:"2"}),React.createElement("circle",{cx:"26",cy:"6",r:"2"}),React.createElement("circle",{cx:"14",cy:"8",r:"2"}),props.children);});var ChartScatter16=/*#__PURE__*/React.forwardRef(function ChartScatter16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 30H4a2 2 0 0 1-2-2V2h2v26h26z"}),React.createElement("circle",{cx:"10",cy:"22",r:"2"}),React.createElement("circle",{cx:"14",cy:"15",r:"2"}),React.createElement("circle",{cx:"22",cy:"15",r:"2"}),React.createElement("circle",{cx:"26",cy:"6",r:"2"}),React.createElement("circle",{cx:"14",cy:"8",r:"2"}),props.children);});var ChartVennDiagram32=/*#__PURE__*/React.forwardRef(function ChartVennDiagram32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 6a9.92 9.92 0 0 0-4 .84A9.92 9.92 0 0 0 12 6a10 10 0 0 0 0 20 9.92 9.92 0 0 0 4-.84 9.92 9.92 0 0 0 4 .84 10 10 0 0 0 0-20zm-8 18a8 8 0 0 1 0-16 7.91 7.91 0 0 1 1.76.2 10 10 0 0 0 0 15.6A7.91 7.91 0 0 1 12 24zm8-8a8 8 0 0 1-4 6.92 8 8 0 0 1 0-13.84A8 8 0 0 1 20 16zm0 8a7.91 7.91 0 0 1-1.76-.2 10 10 0 0 0 0-15.6A7.91 7.91 0 0 1 20 8a8 8 0 0 1 0 16z"}),props.children);});var ChartVennDiagram24=/*#__PURE__*/React.forwardRef(function ChartVennDiagram24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 6a9.92 9.92 0 0 0-4 .84A9.92 9.92 0 0 0 12 6a10 10 0 0 0 0 20 9.92 9.92 0 0 0 4-.84 9.92 9.92 0 0 0 4 .84 10 10 0 0 0 0-20zm-8 18a8 8 0 0 1 0-16 7.91 7.91 0 0 1 1.76.2 10 10 0 0 0 0 15.6A7.91 7.91 0 0 1 12 24zm8-8a8 8 0 0 1-4 6.92 8 8 0 0 1 0-13.84A8 8 0 0 1 20 16zm0 8a7.91 7.91 0 0 1-1.76-.2 10 10 0 0 0 0-15.6A7.91 7.91 0 0 1 20 8a8 8 0 0 1 0 16z"}),props.children);});var ChartVennDiagram20=/*#__PURE__*/React.forwardRef(function ChartVennDiagram20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 6a9.92 9.92 0 0 0-4 .84A9.92 9.92 0 0 0 12 6a10 10 0 0 0 0 20 9.92 9.92 0 0 0 4-.84 9.92 9.92 0 0 0 4 .84 10 10 0 0 0 0-20zm-8 18a8 8 0 0 1 0-16 7.91 7.91 0 0 1 1.76.2 10 10 0 0 0 0 15.6A7.91 7.91 0 0 1 12 24zm8-8a8 8 0 0 1-4 6.92 8 8 0 0 1 0-13.84A8 8 0 0 1 20 16zm0 8a7.91 7.91 0 0 1-1.76-.2 10 10 0 0 0 0-15.6A7.91 7.91 0 0 1 20 8a8 8 0 0 1 0 16z"}),props.children);});var ChartVennDiagram16=/*#__PURE__*/React.forwardRef(function ChartVennDiagram16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 6a9.92 9.92 0 0 0-4 .84A9.92 9.92 0 0 0 12 6a10 10 0 0 0 0 20 9.92 9.92 0 0 0 4-.84 9.92 9.92 0 0 0 4 .84 10 10 0 0 0 0-20zm-8 18a8 8 0 0 1 0-16 7.91 7.91 0 0 1 1.76.2 10 10 0 0 0 0 15.6A7.91 7.91 0 0 1 12 24zm8-8a8 8 0 0 1-4 6.92 8 8 0 0 1 0-13.84A8 8 0 0 1 20 16zm0 8a7.91 7.91 0 0 1-1.76-.2 10 10 0 0 0 0-15.6A7.91 7.91 0 0 1 20 8a8 8 0 0 1 0 16z"}),props.children);});var Chat32=/*#__PURE__*/React.forwardRef(function Chat32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17.74 30L16 29l4-7h6a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h9v2H6a4 4 0 0 1-4-4V8a4 4 0 0 1 4-4h20a4 4 0 0 1 4 4v12a4 4 0 0 1-4 4h-4.84z"}),React.createElement("path",{d:"M8 10h16v2H8zm0 6h10v2H8z"}),props.children);});var Chat24=/*#__PURE__*/React.forwardRef(function Chat24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17.74 30L16 29l4-7h6a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h9v2H6a4 4 0 0 1-4-4V8a4 4 0 0 1 4-4h20a4 4 0 0 1 4 4v12a4 4 0 0 1-4 4h-4.84z"}),React.createElement("path",{d:"M8 10h16v2H8zm0 6h10v2H8z"}),props.children);});var Chat20=/*#__PURE__*/React.forwardRef(function Chat20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17.74 30L16 29l4-7h6a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h9v2H6a4 4 0 0 1-4-4V8a4 4 0 0 1 4-4h20a4 4 0 0 1 4 4v12a4 4 0 0 1-4 4h-4.84z"}),React.createElement("path",{d:"M8 10h16v2H8zm0 6h10v2H8z"}),props.children);});var CheckboxCheckedFilled32=/*#__PURE__*/React.forwardRef(function CheckboxCheckedFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 4H6a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zM14 21.5l-5-5 1.59-1.5L14 18.35 21.41 11 23 12.58z"}),props.children);});var CheckboxCheckedFilled24=/*#__PURE__*/React.forwardRef(function CheckboxCheckedFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 4H6a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zM14 21.5l-5-5 1.59-1.5L14 18.35 21.41 11 23 12.58z"}),props.children);});var CheckboxCheckedFilled20=/*#__PURE__*/React.forwardRef(function CheckboxCheckedFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 4H6a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zM14 21.5l-5-5 1.59-1.5L14 18.35 21.41 11 23 12.58z"}),props.children);});var CheckboxCheckedFilled16=/*#__PURE__*/React.forwardRef(function CheckboxCheckedFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 4H6a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zM14 21.5l-5-5 1.59-1.5L14 18.35 21.41 11 23 12.58z"}),props.children);});var CheckboxChecked32=/*#__PURE__*/React.forwardRef(function CheckboxChecked32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 4H6a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zM6 26V6h20v20z"}),React.createElement("path",{d:"M14 21.5l-5-4.96L10.59 15 14 18.35 21.41 11 23 12.58l-9 8.92z"}),props.children);});var CheckboxChecked24=/*#__PURE__*/React.forwardRef(function CheckboxChecked24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 4H6a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zM6 26V6h20v20z"}),React.createElement("path",{d:"M14 21.5l-5-4.96L10.59 15 14 18.35 21.41 11 23 12.58l-9 8.92z"}),props.children);});var CheckboxChecked20=/*#__PURE__*/React.forwardRef(function CheckboxChecked20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 4H6a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zM6 26V6h20v20z"}),React.createElement("path",{d:"M14 21.5l-5-4.96L10.59 15 14 18.35 21.41 11 23 12.58l-9 8.92z"}),props.children);});var CheckboxChecked16=/*#__PURE__*/React.forwardRef(function CheckboxChecked16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 4H6a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zM6 26V6h20v20z"}),React.createElement("path",{d:"M14 21.5l-5-4.96L10.59 15 14 18.35 21.41 11 23 12.58l-9 8.92z"}),props.children);});var CheckboxUndeterminateFilled32=/*#__PURE__*/React.forwardRef(function CheckboxUndeterminateFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 4H6a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm-4 14H10v-4h12z"}),props.children);});var CheckboxUndeterminateFilled24=/*#__PURE__*/React.forwardRef(function CheckboxUndeterminateFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 4H6a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm-4 14H10v-4h12z"}),props.children);});var CheckboxUndeterminateFilled20=/*#__PURE__*/React.forwardRef(function CheckboxUndeterminateFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 4H6a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm-4 14H10v-4h12z"}),props.children);});var CheckboxUndeterminateFilled16=/*#__PURE__*/React.forwardRef(function CheckboxUndeterminateFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 4H6a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm-4 14H10v-4h12z"}),props.children);});var CheckboxUndeterminate32=/*#__PURE__*/React.forwardRef(function CheckboxUndeterminate32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 14h12v4H10z"}),React.createElement("path",{d:"M26 4H6a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zM6 26V6h20v20z"}),props.children);});var CheckboxUndeterminate24=/*#__PURE__*/React.forwardRef(function CheckboxUndeterminate24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 14h12v4H10z"}),React.createElement("path",{d:"M26 4H6a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zM6 26V6h20v20z"}),props.children);});var CheckboxUndeterminate20=/*#__PURE__*/React.forwardRef(function CheckboxUndeterminate20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 14h12v4H10z"}),React.createElement("path",{d:"M26 4H6a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zM6 26V6h20v20z"}),props.children);});var CheckboxUndeterminate16=/*#__PURE__*/React.forwardRef(function CheckboxUndeterminate16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 14h12v4H10z"}),React.createElement("path",{d:"M26 4H6a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zM6 26V6h20v20z"}),props.children);});var Checkbox32=/*#__PURE__*/React.forwardRef(function Checkbox32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 4H6a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zM6 26V6h20v20z"}),props.children);});var Checkbox24=/*#__PURE__*/React.forwardRef(function Checkbox24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 4H6a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zM6 26V6h20v20z"}),props.children);});var Checkbox20=/*#__PURE__*/React.forwardRef(function Checkbox20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 4H6a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zM6 26V6h20v20z"}),props.children);});var Checkbox16=/*#__PURE__*/React.forwardRef(function Checkbox16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 4H6a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zM6 26V6h20v20z"}),props.children);});var CheckmarkFilled32=/*#__PURE__*/React.forwardRef(function CheckmarkFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2C8.3 2 2 8.3 2 16s6.3 14 14 14 14-6.3 14-14S23.7 2 16 2zm-2 19.5l-5-5 1.6-1.5 3.4 3.4 7.4-7.4 1.6 1.6-9 8.9z"}),React.createElement("path",{d:"M14 21.5l-5-5 1.6-1.5 3.4 3.4 7.4-7.4 1.6 1.6-9 8.9z","data-icon-path":"inner-path",opacity:"0"}),props.children);});var CheckmarkOutline32=/*#__PURE__*/React.forwardRef(function CheckmarkOutline32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 26a12 12 0 1 1 12-12 12 12 0 0 1-12 12z"}),React.createElement("path",{d:"M14 21.5l-5-4.96 1.59-1.57L14 18.35 21.41 11 23 12.58l-9 8.92z"}),props.children);});var CheckmarkOutline24=/*#__PURE__*/React.forwardRef(function CheckmarkOutline24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 26a12 12 0 1 1 12-12 12 12 0 0 1-12 12z"}),React.createElement("path",{d:"M14 21.5l-5-4.96 1.59-1.57L14 18.35 21.41 11 23 12.58l-9 8.92z"}),props.children);});var CheckmarkOutline20=/*#__PURE__*/React.forwardRef(function CheckmarkOutline20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 26a12 12 0 1 1 12-12 12 12 0 0 1-12 12z"}),React.createElement("path",{d:"M14 21.5l-5-4.96 1.59-1.57L14 18.35 21.41 11 23 12.58l-9 8.92z"}),props.children);});var Checkmark32=/*#__PURE__*/React.forwardRef(function Checkmark32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13 21.2l-7.1-7.1-1.4 1.4 7.1 7.1L13 24 27.1 9.9l-1.4-1.5z"}),props.children);});var Chemistry32=/*#__PURE__*/React.forwardRef(function Chemistry32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.231 23.618L20 13.675V4h2V2H10v2h2v9.675l-7.231 9.943A4.018 4.018 0 0 0 8.019 30H23.98a4.018 4.018 0 0 0 3.25-6.382zM14 14.325V4h4v10.325L20.673 18h-9.346zM23.981 28H8.02a2.02 2.02 0 0 1-1.633-3.206L9.873 20h12.254l3.487 4.794A2.02 2.02 0 0 1 23.981 28z"}),props.children);});var Chemistry24=/*#__PURE__*/React.forwardRef(function Chemistry24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.231 23.618L20 13.675V4h2V2H10v2h2v9.675l-7.231 9.943A4.018 4.018 0 0 0 8.019 30H23.98a4.018 4.018 0 0 0 3.25-6.382zM14 14.325V4h4v10.325L20.673 18h-9.346zM23.981 28H8.02a2.02 2.02 0 0 1-1.633-3.206L9.873 20h12.254l3.487 4.794A2.02 2.02 0 0 1 23.981 28z"}),props.children);});var Chemistry20=/*#__PURE__*/React.forwardRef(function Chemistry20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.231 23.618L20 13.675V4h2V2H10v2h2v9.675l-7.231 9.943A4.018 4.018 0 0 0 8.019 30H23.98a4.018 4.018 0 0 0 3.25-6.382zM14 14.325V4h4v10.325L20.673 18h-9.346zM23.981 28H8.02a2.02 2.02 0 0 1-1.633-3.206L9.873 20h12.254l3.487 4.794A2.02 2.02 0 0 1 23.981 28z"}),props.children);});var Chemistry16=/*#__PURE__*/React.forwardRef(function Chemistry16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.231 23.618L20 13.675V4h2V2H10v2h2v9.675l-7.231 9.943A4.018 4.018 0 0 0 8.019 30H23.98a4.018 4.018 0 0 0 3.25-6.382zM14 14.325V4h4v10.325L20.673 18h-9.346zM23.981 28H8.02a2.02 2.02 0 0 1-1.633-3.206L9.873 20h12.254l3.487 4.794A2.02 2.02 0 0 1 23.981 28z"}),props.children);});var ChevronDown32=/*#__PURE__*/React.forwardRef(function ChevronDown32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 22L6 12l1.4-1.4 8.6 8.6 8.6-8.6L26 12z"}),props.children);});var ChevronDown24=/*#__PURE__*/React.forwardRef(function ChevronDown24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 22L6 12l1.4-1.4 8.6 8.6 8.6-8.6L26 12z"}),props.children);});var ChevronDown20=/*#__PURE__*/React.forwardRef(function ChevronDown20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 22L6 12l1.4-1.4 8.6 8.6 8.6-8.6L26 12z"}),props.children);});var ChevronLeft32=/*#__PURE__*/React.forwardRef(function ChevronLeft32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 16L20 6l1.4 1.4-8.6 8.6 8.6 8.6L20 26z"}),props.children);});var ChevronLeft24=/*#__PURE__*/React.forwardRef(function ChevronLeft24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 16L20 6l1.4 1.4-8.6 8.6 8.6 8.6L20 26z"}),props.children);});var ChevronLeft20=/*#__PURE__*/React.forwardRef(function ChevronLeft20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 16L20 6l1.4 1.4-8.6 8.6 8.6 8.6L20 26z"}),props.children);});var ChevronMini32=/*#__PURE__*/React.forwardRef(function ChevronMini32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M31 19v12H19z"}),props.children);});var ChevronMini24=/*#__PURE__*/React.forwardRef(function ChevronMini24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M31 19v12H19z"}),props.children);});var ChevronMini20=/*#__PURE__*/React.forwardRef(function ChevronMini20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M31 19v12H19z"}),props.children);});var ChevronRight32=/*#__PURE__*/React.forwardRef(function ChevronRight32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22 16L12 26l-1.4-1.4 8.6-8.6-8.6-8.6L12 6z"}),props.children);});var ChevronRight24=/*#__PURE__*/React.forwardRef(function ChevronRight24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22 16L12 26l-1.4-1.4 8.6-8.6-8.6-8.6L12 6z"}),props.children);});var ChevronRight20=/*#__PURE__*/React.forwardRef(function ChevronRight20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22 16L12 26l-1.4-1.4 8.6-8.6-8.6-8.6L12 6z"}),props.children);});var ChevronSortDown32=/*#__PURE__*/React.forwardRef(function ChevronSortDown32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 28l-7-7 1.4-1.4 5.6 5.6 5.6-5.6L23 21z"}),props.children);});var ChevronSortDown24=/*#__PURE__*/React.forwardRef(function ChevronSortDown24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 28l-7-7 1.4-1.4 5.6 5.6 5.6-5.6L23 21z"}),props.children);});var ChevronSortDown20=/*#__PURE__*/React.forwardRef(function ChevronSortDown20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 28l-7-7 1.4-1.4 5.6 5.6 5.6-5.6L23 21z"}),props.children);});var ChevronSortUp32=/*#__PURE__*/React.forwardRef(function ChevronSortUp32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 4l7 7-1.4 1.4L16 6.8l-5.6 5.6L9 11z"}),props.children);});var ChevronSortUp24=/*#__PURE__*/React.forwardRef(function ChevronSortUp24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 4l7 7-1.4 1.4L16 6.8l-5.6 5.6L9 11z"}),props.children);});var ChevronSortUp20=/*#__PURE__*/React.forwardRef(function ChevronSortUp20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 4l7 7-1.4 1.4L16 6.8l-5.6 5.6L9 11z"}),props.children);});var ChevronSort32=/*#__PURE__*/React.forwardRef(function ChevronSort32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 28l-7-7 1.41-1.41L16 25.17l5.59-5.58L23 21l-7 7zm0-24l7 7-1.41 1.41L16 6.83l-5.59 5.58L9 11l7-7z"}),props.children);});var ChevronSort24=/*#__PURE__*/React.forwardRef(function ChevronSort24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 28l-7-7 1.41-1.41L16 25.17l5.59-5.58L23 21l-7 7zm0-24l7 7-1.41 1.41L16 6.83l-5.59 5.58L9 11l7-7z"}),props.children);});var ChevronSort20=/*#__PURE__*/React.forwardRef(function ChevronSort20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 28l-7-7 1.41-1.41L16 25.17l5.59-5.58L23 21l-7 7zm0-24l7 7-1.41 1.41L16 6.83l-5.59 5.58L9 11l7-7z"}),props.children);});var ChevronUp32=/*#__PURE__*/React.forwardRef(function ChevronUp32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 10l10 10-1.4 1.4-8.6-8.6-8.6 8.6L6 20z"}),props.children);});var ChevronUp24=/*#__PURE__*/React.forwardRef(function ChevronUp24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 10l10 10-1.4 1.4-8.6-8.6-8.6 8.6L6 20z"}),props.children);});var ChevronUp20=/*#__PURE__*/React.forwardRef(function ChevronUp20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 10l10 10-1.4 1.4-8.6-8.6-8.6 8.6L6 20z"}),props.children);});var Chip32=/*#__PURE__*/React.forwardRef(function Chip32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11 11v10h10V11zm8 8h-6v-6h6z"}),React.createElement("path",{d:"M30 13v-2h-4V8a2 2 0 0 0-2-2h-3V2h-2v4h-6V2h-2v4H8a2 2 0 0 0-2 2v3H2v2h4v6H2v2h4v3a2 2 0 0 0 2 2h3v4h2v-4h6v4h2v-4h3a2 2 0 0 0 2-2v-3h4v-2h-4v-6zm-6 11H8V8h16z"}),props.children);});var Chip24=/*#__PURE__*/React.forwardRef(function Chip24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11 11v10h10V11zm8 8h-6v-6h6z"}),React.createElement("path",{d:"M30 13v-2h-4V8a2 2 0 0 0-2-2h-3V2h-2v4h-6V2h-2v4H8a2 2 0 0 0-2 2v3H2v2h4v6H2v2h4v3a2 2 0 0 0 2 2h3v4h2v-4h6v4h2v-4h3a2 2 0 0 0 2-2v-3h4v-2h-4v-6zm-6 11H8V8h16z"}),props.children);});var Chip20=/*#__PURE__*/React.forwardRef(function Chip20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11 11v10h10V11zm8 8h-6v-6h6z"}),React.createElement("path",{d:"M30 13v-2h-4V8a2 2 0 0 0-2-2h-3V2h-2v4h-6V2h-2v4H8a2 2 0 0 0-2 2v3H2v2h4v6H2v2h4v3a2 2 0 0 0 2 2h3v4h2v-4h6v4h2v-4h3a2 2 0 0 0 2-2v-3h4v-2h-4v-6zm-6 11H8V8h16z"}),props.children);});var Chip16=/*#__PURE__*/React.forwardRef(function Chip16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11 11v10h10V11zm8 8h-6v-6h6z"}),React.createElement("path",{d:"M30 13v-2h-4V8a2 2 0 0 0-2-2h-3V2h-2v4h-6V2h-2v4H8a2 2 0 0 0-2 2v3H2v2h4v6H2v2h4v3a2 2 0 0 0 2 2h3v4h2v-4h6v4h2v-4h3a2 2 0 0 0 2-2v-3h4v-2h-4v-6zm-6 11H8V8h16z"}),props.children);});var CircleDash32=/*#__PURE__*/React.forwardRef(function CircleDash32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7.7 4.7a14.7 14.7 0 0 0-3 3.1L6.3 9a13.26 13.26 0 0 1 2.6-2.7zm-3.1 7.6l-1.9-.6A12.51 12.51 0 0 0 2 16h2a11.48 11.48 0 0 1 .6-3.7zm-1.9 8.1a14.4 14.4 0 0 0 2 3.9l1.6-1.2a12.89 12.89 0 0 1-1.7-3.3zm5.1 6.9a14.4 14.4 0 0 0 3.9 2l.6-1.9A12.89 12.89 0 0 1 9 25.7zm3.9-24.6l.6 1.9A11.48 11.48 0 0 1 16 4V2a12.51 12.51 0 0 0-4.3.7zm12.5 24.6a15.18 15.18 0 0 0 3.1-3.1L25.7 23a11.53 11.53 0 0 1-2.7 2.7zm3.2-7.6l1.9.6A15.47 15.47 0 0 0 30 16h-2a11.48 11.48 0 0 1-.6 3.7zm1.8-8.1a14.4 14.4 0 0 0-2-3.9l-1.6 1.2a12.89 12.89 0 0 1 1.7 3.3zm-5.1-7a14.4 14.4 0 0 0-3.9-2l-.6 1.9a12.89 12.89 0 0 1 3.3 1.7zm-3.8 24.7l-.6-1.9a11.48 11.48 0 0 1-3.7.6v2a21.42 21.42 0 0 0 4.3-.7z"}),props.children);});var CircleDash24=/*#__PURE__*/React.forwardRef(function CircleDash24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7.7 4.7a14.7 14.7 0 0 0-3 3.1L6.3 9a13.26 13.26 0 0 1 2.6-2.7zm-3.1 7.6l-1.9-.6A12.51 12.51 0 0 0 2 16h2a11.48 11.48 0 0 1 .6-3.7zm-1.9 8.1a14.4 14.4 0 0 0 2 3.9l1.6-1.2a12.89 12.89 0 0 1-1.7-3.3zm5.1 6.9a14.4 14.4 0 0 0 3.9 2l.6-1.9A12.89 12.89 0 0 1 9 25.7zm3.9-24.6l.6 1.9A11.48 11.48 0 0 1 16 4V2a12.51 12.51 0 0 0-4.3.7zm12.5 24.6a15.18 15.18 0 0 0 3.1-3.1L25.7 23a11.53 11.53 0 0 1-2.7 2.7zm3.2-7.6l1.9.6A15.47 15.47 0 0 0 30 16h-2a11.48 11.48 0 0 1-.6 3.7zm1.8-8.1a14.4 14.4 0 0 0-2-3.9l-1.6 1.2a12.89 12.89 0 0 1 1.7 3.3zm-5.1-7a14.4 14.4 0 0 0-3.9-2l-.6 1.9a12.89 12.89 0 0 1 3.3 1.7zm-3.8 24.7l-.6-1.9a11.48 11.48 0 0 1-3.7.6v2a21.42 21.42 0 0 0 4.3-.7z"}),props.children);});var CircleDash20=/*#__PURE__*/React.forwardRef(function CircleDash20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7.7 4.7a14.7 14.7 0 0 0-3 3.1L6.3 9a13.26 13.26 0 0 1 2.6-2.7zm-3.1 7.6l-1.9-.6A12.51 12.51 0 0 0 2 16h2a11.48 11.48 0 0 1 .6-3.7zm-1.9 8.1a14.4 14.4 0 0 0 2 3.9l1.6-1.2a12.89 12.89 0 0 1-1.7-3.3zm5.1 6.9a14.4 14.4 0 0 0 3.9 2l.6-1.9A12.89 12.89 0 0 1 9 25.7zm3.9-24.6l.6 1.9A11.48 11.48 0 0 1 16 4V2a12.51 12.51 0 0 0-4.3.7zm12.5 24.6a15.18 15.18 0 0 0 3.1-3.1L25.7 23a11.53 11.53 0 0 1-2.7 2.7zm3.2-7.6l1.9.6A15.47 15.47 0 0 0 30 16h-2a11.48 11.48 0 0 1-.6 3.7zm1.8-8.1a14.4 14.4 0 0 0-2-3.9l-1.6 1.2a12.89 12.89 0 0 1 1.7 3.3zm-5.1-7a14.4 14.4 0 0 0-3.9-2l-.6 1.9a12.89 12.89 0 0 1 3.3 1.7zm-3.8 24.7l-.6-1.9a11.48 11.48 0 0 1-3.7.6v2a21.42 21.42 0 0 0 4.3-.7z"}),props.children);});var CircleDash16=/*#__PURE__*/React.forwardRef(function CircleDash16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7.7 4.7a14.7 14.7 0 0 0-3 3.1L6.3 9a13.26 13.26 0 0 1 2.6-2.7zm-3.1 7.6l-1.9-.6A12.51 12.51 0 0 0 2 16h2a11.48 11.48 0 0 1 .6-3.7zm-1.9 8.1a14.4 14.4 0 0 0 2 3.9l1.6-1.2a12.89 12.89 0 0 1-1.7-3.3zm5.1 6.9a14.4 14.4 0 0 0 3.9 2l.6-1.9A12.89 12.89 0 0 1 9 25.7zm3.9-24.6l.6 1.9A11.48 11.48 0 0 1 16 4V2a12.51 12.51 0 0 0-4.3.7zm12.5 24.6a15.18 15.18 0 0 0 3.1-3.1L25.7 23a11.53 11.53 0 0 1-2.7 2.7zm3.2-7.6l1.9.6A15.47 15.47 0 0 0 30 16h-2a11.48 11.48 0 0 1-.6 3.7zm1.8-8.1a14.4 14.4 0 0 0-2-3.9l-1.6 1.2a12.89 12.89 0 0 1 1.7 3.3zm-5.1-7a14.4 14.4 0 0 0-3.9-2l-.6 1.9a12.89 12.89 0 0 1 3.3 1.7zm-3.8 24.7l-.6-1.9a11.48 11.48 0 0 1-3.7.6v2a21.42 21.42 0 0 0 4.3-.7z"}),props.children);});var ClassifierLanguage32=/*#__PURE__*/React.forwardRef(function ClassifierLanguage32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 10V2h-8v8h3v4h-2v2h7v-2h-3v-4zm-6-6h4v4h-4zm-4 19.41L18.59 22 16 24.59 13.41 22 12 23.41 14.59 26 12 28.59 13.41 30 16 27.41 18.59 30 20 28.59 17.41 26 20 23.41zM20 14h-8v2h3v5h2v-5h3v-2zM7 9.86a4 4 0 1 0-2 0V14H2v2h7v-2H7zM4 6a2 2 0 1 1 2 2 2 2 0 0 1-2-2z"}),props.children);});var ClassifierLanguage24=/*#__PURE__*/React.forwardRef(function ClassifierLanguage24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 10V2h-8v8h3v4h-2v2h7v-2h-3v-4zm-6-6h4v4h-4zm-4 19.41L18.59 22 16 24.59 13.41 22 12 23.41 14.59 26 12 28.59 13.41 30 16 27.41 18.59 30 20 28.59 17.41 26 20 23.41zM20 14h-8v2h3v5h2v-5h3v-2zM7 9.86a4 4 0 1 0-2 0V14H2v2h7v-2H7zM4 6a2 2 0 1 1 2 2 2 2 0 0 1-2-2z"}),props.children);});var ClassifierLanguage20=/*#__PURE__*/React.forwardRef(function ClassifierLanguage20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 10V2h-8v8h3v4h-2v2h7v-2h-3v-4zm-6-6h4v4h-4zm-4 19.41L18.59 22 16 24.59 13.41 22 12 23.41 14.59 26 12 28.59 13.41 30 16 27.41 18.59 30 20 28.59 17.41 26 20 23.41zM20 14h-8v2h3v5h2v-5h3v-2zM7 9.86a4 4 0 1 0-2 0V14H2v2h7v-2H7zM4 6a2 2 0 1 1 2 2 2 2 0 0 1-2-2z"}),props.children);});var ClassifierLanguage16=/*#__PURE__*/React.forwardRef(function ClassifierLanguage16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 10V2h-8v8h3v4h-2v2h7v-2h-3v-4zm-6-6h4v4h-4zm-4 19.41L18.59 22 16 24.59 13.41 22 12 23.41 14.59 26 12 28.59 13.41 30 16 27.41 18.59 30 20 28.59 17.41 26 20 23.41zM20 14h-8v2h3v5h2v-5h3v-2zM7 9.86a4 4 0 1 0-2 0V14H2v2h7v-2H7zM4 6a2 2 0 1 1 2 2 2 2 0 0 1-2-2z"}),props.children);});var CloseFilled32=/*#__PURE__*/React.forwardRef(function CloseFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2C8.2 2 2 8.2 2 16s6.2 14 14 14 14-6.2 14-14S23.8 2 16 2zm5.4 21L16 17.6 10.6 23 9 21.4l5.4-5.4L9 10.6 10.6 9l5.4 5.4L21.4 9l1.6 1.6-5.4 5.4 5.4 5.4-1.6 1.6z"}),React.createElement("path",{d:"M14.4 16L9 10.6 10.6 9l5.4 5.4L21.4 9l1.6 1.6-5.4 5.4 5.4 5.4-1.6 1.6-5.4-5.4-5.4 5.4L9 21.4l5.4-5.4","data-icon-path":"inner-path",opacity:"0"}),props.children);});var CloseFilled24=/*#__PURE__*/React.forwardRef(function CloseFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2C8.2 2 2 8.2 2 16s6.2 14 14 14 14-6.2 14-14S23.8 2 16 2zm5.4 21L16 17.6 10.6 23 9 21.4l5.4-5.4L9 10.6 10.6 9l5.4 5.4L21.4 9l1.6 1.6-5.4 5.4 5.4 5.4-1.6 1.6z"}),React.createElement("path",{d:"M14.4 16L9 10.6 10.6 9l5.4 5.4L21.4 9l1.6 1.6-5.4 5.4 5.4 5.4-1.6 1.6-5.4-5.4-5.4 5.4L9 21.4l5.4-5.4","data-icon-path":"inner-path",opacity:"0"}),props.children);});var CloseFilled20=/*#__PURE__*/React.forwardRef(function CloseFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2C8.2 2 2 8.2 2 16s6.2 14 14 14 14-6.2 14-14S23.8 2 16 2zm5.4 21L16 17.6 10.6 23 9 21.4l5.4-5.4L9 10.6 10.6 9l5.4 5.4L21.4 9l1.6 1.6-5.4 5.4 5.4 5.4-1.6 1.6z"}),React.createElement("path",{d:"M14.4 16L9 10.6 10.6 9l5.4 5.4L21.4 9l1.6 1.6-5.4 5.4 5.4 5.4-1.6 1.6-5.4-5.4-5.4 5.4L9 21.4l5.4-5.4","data-icon-path":"inner-path",opacity:"0"}),props.children);});var CloseOutline32=/*#__PURE__*/React.forwardRef(function CloseOutline32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2C8.2 2 2 8.2 2 16s6.2 14 14 14 14-6.2 14-14S23.8 2 16 2zm0 26C9.4 28 4 22.6 4 16S9.4 4 16 4s12 5.4 12 12-5.4 12-12 12z"}),React.createElement("path",{d:"M21.4 23L16 17.6 10.6 23 9 21.4l5.4-5.4L9 10.6 10.6 9l5.4 5.4L21.4 9l1.6 1.6-5.4 5.4 5.4 5.4z"}),props.children);});var CloseOutline24=/*#__PURE__*/React.forwardRef(function CloseOutline24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2C8.2 2 2 8.2 2 16s6.2 14 14 14 14-6.2 14-14S23.8 2 16 2zm0 26C9.4 28 4 22.6 4 16S9.4 4 16 4s12 5.4 12 12-5.4 12-12 12z"}),React.createElement("path",{d:"M21.4 23L16 17.6 10.6 23 9 21.4l5.4-5.4L9 10.6 10.6 9l5.4 5.4L21.4 9l1.6 1.6-5.4 5.4 5.4 5.4z"}),props.children);});var CloseOutline20=/*#__PURE__*/React.forwardRef(function CloseOutline20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2C8.2 2 2 8.2 2 16s6.2 14 14 14 14-6.2 14-14S23.8 2 16 2zm0 26C9.4 28 4 22.6 4 16S9.4 4 16 4s12 5.4 12 12-5.4 12-12 12z"}),React.createElement("path",{d:"M21.4 23L16 17.6 10.6 23 9 21.4l5.4-5.4L9 10.6 10.6 9l5.4 5.4L21.4 9l1.6 1.6-5.4 5.4 5.4 5.4z"}),props.children);});var Close32=/*#__PURE__*/React.forwardRef(function Close32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 9.4L22.6 8 16 14.6 9.4 8 8 9.4l6.6 6.6L8 22.6 9.4 24l6.6-6.6 6.6 6.6 1.4-1.4-6.6-6.6L24 9.4z"}),props.children);});var Close24=/*#__PURE__*/React.forwardRef(function Close24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 9.4L22.6 8 16 14.6 9.4 8 8 9.4l6.6 6.6L8 22.6 9.4 24l6.6-6.6 6.6 6.6 1.4-1.4-6.6-6.6L24 9.4z"}),props.children);});var Close20=/*#__PURE__*/React.forwardRef(function Close20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 9.4L22.6 8 16 14.6 9.4 8 8 9.4l6.6 6.6L8 22.6 9.4 24l6.6-6.6 6.6 6.6 1.4-1.4-6.6-6.6L24 9.4z"}),props.children);});var ClosedCaptionAlt32=/*#__PURE__*/React.forwardRef(function ClosedCaptionAlt32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19 17h6v2h-6zm-8 0h6v2h-6zm-5 0h3v2H6zm16-4h4v2h-4zm-9 0h7v2h-7zm-7 0h5v2H6z"}),React.createElement("path",{d:"M17.736 30L16 29l4-7h6a1.997 1.997 0 0 0 2-2V8a1.997 1.997 0 0 0-2-2H6a1.997 1.997 0 0 0-2 2v12a1.997 1.997 0 0 0 2 2h9v2H6a4 4 0 0 1-4-4V8a3.999 3.999 0 0 1 4-4h20a3.999 3.999 0 0 1 4 4v12a4 4 0 0 1-4 4h-4.835z"}),props.children);});var ClosedCaptionAlt24=/*#__PURE__*/React.forwardRef(function ClosedCaptionAlt24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19 17h6v2h-6zm-8 0h6v2h-6zm-5 0h3v2H6zm16-4h4v2h-4zm-9 0h7v2h-7zm-7 0h5v2H6z"}),React.createElement("path",{d:"M17.736 30L16 29l4-7h6a1.997 1.997 0 0 0 2-2V8a1.997 1.997 0 0 0-2-2H6a1.997 1.997 0 0 0-2 2v12a1.997 1.997 0 0 0 2 2h9v2H6a4 4 0 0 1-4-4V8a3.999 3.999 0 0 1 4-4h20a3.999 3.999 0 0 1 4 4v12a4 4 0 0 1-4 4h-4.835z"}),props.children);});var ClosedCaptionAlt20=/*#__PURE__*/React.forwardRef(function ClosedCaptionAlt20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19 17h6v2h-6zm-8 0h6v2h-6zm-5 0h3v2H6zm16-4h4v2h-4zm-9 0h7v2h-7zm-7 0h5v2H6z"}),React.createElement("path",{d:"M17.736 30L16 29l4-7h6a1.997 1.997 0 0 0 2-2V8a1.997 1.997 0 0 0-2-2H6a1.997 1.997 0 0 0-2 2v12a1.997 1.997 0 0 0 2 2h9v2H6a4 4 0 0 1-4-4V8a3.999 3.999 0 0 1 4-4h20a3.999 3.999 0 0 1 4 4v12a4 4 0 0 1-4 4h-4.835z"}),props.children);});var ClosedCaptionAlt16=/*#__PURE__*/React.forwardRef(function ClosedCaptionAlt16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19 17h6v2h-6zm-8 0h6v2h-6zm-5 0h3v2H6zm16-4h4v2h-4zm-9 0h7v2h-7zm-7 0h5v2H6z"}),React.createElement("path",{d:"M17.736 30L16 29l4-7h6a1.997 1.997 0 0 0 2-2V8a1.997 1.997 0 0 0-2-2H6a1.997 1.997 0 0 0-2 2v12a1.997 1.997 0 0 0 2 2h9v2H6a4 4 0 0 1-4-4V8a3.999 3.999 0 0 1 4-4h20a3.999 3.999 0 0 1 4 4v12a4 4 0 0 1-4 4h-4.835z"}),props.children);});var ClosedCaptionFilled32=/*#__PURE__*/React.forwardRef(function ClosedCaptionFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 6H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zm-13 7h-5v6h5v2h-5a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h5zm10 0h-5v6h5v2h-5a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h5z"}),props.children);});var ClosedCaptionFilled24=/*#__PURE__*/React.forwardRef(function ClosedCaptionFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 6H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zm-13 7h-5v6h5v2h-5a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h5zm10 0h-5v6h5v2h-5a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h5z"}),props.children);});var ClosedCaptionFilled20=/*#__PURE__*/React.forwardRef(function ClosedCaptionFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 6H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zm-13 7h-5v6h5v2h-5a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h5zm10 0h-5v6h5v2h-5a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h5z"}),props.children);});var ClosedCaptionFilled16=/*#__PURE__*/React.forwardRef(function ClosedCaptionFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 6H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zm-13 7h-5v6h5v2h-5a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h5zm10 0h-5v6h5v2h-5a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h5z"}),props.children);});var ClosedCaption32=/*#__PURE__*/React.forwardRef(function ClosedCaption32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 21h-5a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h5v2h-5v6h5zm10 0h-5a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h5v2h-5v6h5z"}),React.createElement("path",{d:"M28 26H4a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h24a2 2 0 0 1 2 2v16a2 2 0 0 1-2 2zM4 8v16h24V8z"}),props.children);});var ClosedCaption24=/*#__PURE__*/React.forwardRef(function ClosedCaption24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 21h-5a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h5v2h-5v6h5zm10 0h-5a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h5v2h-5v6h5z"}),React.createElement("path",{d:"M28 26H4a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h24a2 2 0 0 1 2 2v16a2 2 0 0 1-2 2zM4 8v16h24V8z"}),props.children);});var ClosedCaption20=/*#__PURE__*/React.forwardRef(function ClosedCaption20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 21h-5a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h5v2h-5v6h5zm10 0h-5a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h5v2h-5v6h5z"}),React.createElement("path",{d:"M28 26H4a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h24a2 2 0 0 1 2 2v16a2 2 0 0 1-2 2zM4 8v16h24V8z"}),props.children);});var ClosedCaption16=/*#__PURE__*/React.forwardRef(function ClosedCaption16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 21h-5a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h5v2h-5v6h5zm10 0h-5a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h5v2h-5v6h5z"}),React.createElement("path",{d:"M28 26H4a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h24a2 2 0 0 1 2 2v16a2 2 0 0 1-2 2zM4 8v16h24V8z"}),props.children);});var CloudDownload32=/*#__PURE__*/React.forwardRef(function CloudDownload32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.5 22H23v-2h.5a4.5 4.5 0 0 0 .36-9H23l-.1-.82a7 7 0 0 0-13.88 0L9 11h-.86a4.5 4.5 0 0 0 .36 9H9v2h-.5A6.5 6.5 0 0 1 7.2 9.14a9 9 0 0 1 17.6 0A6.5 6.5 0 0 1 23.5 22z"}),React.createElement("path",{d:"M17 26.17V14h-2v12.17l-2.59-2.58L11 25l5 5 5-5-1.41-1.41L17 26.17z"}),props.children);});var CloudDownload24=/*#__PURE__*/React.forwardRef(function CloudDownload24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.5 22H23v-2h.5a4.5 4.5 0 0 0 .36-9H23l-.1-.82a7 7 0 0 0-13.88 0L9 11h-.86a4.5 4.5 0 0 0 .36 9H9v2h-.5A6.5 6.5 0 0 1 7.2 9.14a9 9 0 0 1 17.6 0A6.5 6.5 0 0 1 23.5 22z"}),React.createElement("path",{d:"M17 26.17V14h-2v12.17l-2.59-2.58L11 25l5 5 5-5-1.41-1.41L17 26.17z"}),props.children);});var CloudDownload20=/*#__PURE__*/React.forwardRef(function CloudDownload20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.5 22H23v-2h.5a4.5 4.5 0 0 0 .36-9H23l-.1-.82a7 7 0 0 0-13.88 0L9 11h-.86a4.5 4.5 0 0 0 .36 9H9v2h-.5A6.5 6.5 0 0 1 7.2 9.14a9 9 0 0 1 17.6 0A6.5 6.5 0 0 1 23.5 22z"}),React.createElement("path",{d:"M17 26.17V14h-2v12.17l-2.59-2.58L11 25l5 5 5-5-1.41-1.41L17 26.17z"}),props.children);});var CloudDownload16=/*#__PURE__*/React.forwardRef(function CloudDownload16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.5 22H23v-2h.5a4.5 4.5 0 0 0 .36-9H23l-.1-.82a7 7 0 0 0-13.88 0L9 11h-.86a4.5 4.5 0 0 0 .36 9H9v2h-.5A6.5 6.5 0 0 1 7.2 9.14a9 9 0 0 1 17.6 0A6.5 6.5 0 0 1 23.5 22z"}),React.createElement("path",{d:"M17 26.17V14h-2v12.17l-2.59-2.58L11 25l5 5 5-5-1.41-1.41L17 26.17z"}),props.children);});var CloudLightning32=/*#__PURE__*/React.forwardRef(function CloudLightning32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.5 22H23v-2h.5a4.5 4.5 0 0 0 .36-9H23l-.1-.82a7 7 0 0 0-13.88 0L9 11h-.86a4.5 4.5 0 0 0 .36 9H9v2h-.5A6.5 6.5 0 0 1 7.2 9.14a9 9 0 0 1 17.6 0A6.5 6.5 0 0 1 23.5 22z"}),React.createElement("path",{d:"M15.87 30.5l-1.74-1 3.15-5.5h-6l4.85-8.5 1.74 1-3.15 5.5h6l-4.85 8.5z"}),props.children);});var CloudLightning24=/*#__PURE__*/React.forwardRef(function CloudLightning24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.5 22H23v-2h.5a4.5 4.5 0 0 0 .36-9H23l-.1-.82a7 7 0 0 0-13.88 0L9 11h-.86a4.5 4.5 0 0 0 .36 9H9v2h-.5A6.5 6.5 0 0 1 7.2 9.14a9 9 0 0 1 17.6 0A6.5 6.5 0 0 1 23.5 22z"}),React.createElement("path",{d:"M15.87 30.5l-1.74-1 3.15-5.5h-6l4.85-8.5 1.74 1-3.15 5.5h6l-4.85 8.5z"}),props.children);});var CloudLightning20=/*#__PURE__*/React.forwardRef(function CloudLightning20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.5 22H23v-2h.5a4.5 4.5 0 0 0 .36-9H23l-.1-.82a7 7 0 0 0-13.88 0L9 11h-.86a4.5 4.5 0 0 0 .36 9H9v2h-.5A6.5 6.5 0 0 1 7.2 9.14a9 9 0 0 1 17.6 0A6.5 6.5 0 0 1 23.5 22z"}),React.createElement("path",{d:"M15.87 30.5l-1.74-1 3.15-5.5h-6l4.85-8.5 1.74 1-3.15 5.5h6l-4.85 8.5z"}),props.children);});var CloudLightning16=/*#__PURE__*/React.forwardRef(function CloudLightning16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.5 22H23v-2h.5a4.5 4.5 0 0 0 .36-9H23l-.1-.82a7 7 0 0 0-13.88 0L9 11h-.86a4.5 4.5 0 0 0 .36 9H9v2h-.5A6.5 6.5 0 0 1 7.2 9.14a9 9 0 0 1 17.6 0A6.5 6.5 0 0 1 23.5 22z"}),React.createElement("path",{d:"M15.87 30.5l-1.74-1 3.15-5.5h-6l4.85-8.5 1.74 1-3.15 5.5h6l-4.85 8.5z"}),props.children);});var CloudRain32=/*#__PURE__*/React.forwardRef(function CloudRain32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.5 22h-15A6.5 6.5 0 0 1 7.2 9.14a9 9 0 0 1 17.6 0A6.5 6.5 0 0 1 23.5 22zM16 4a7 7 0 0 0-6.94 6.14L9 11h-.86a4.5 4.5 0 0 0 .36 9h15a4.5 4.5 0 0 0 .36-9H23l-.1-.82A7 7 0 0 0 16 4zm-2 26a.93.93 0 0 1-.45-.11 1 1 0 0 1-.44-1.34l2-4a1 1 0 1 1 1.78.9l-2 4A1 1 0 0 1 14 30zm6 0a.93.93 0 0 1-.45-.11 1 1 0 0 1-.44-1.34l2-4a1 1 0 1 1 1.78.9l-2 4A1 1 0 0 1 20 30zM8 30a.93.93 0 0 1-.45-.11 1 1 0 0 1-.44-1.34l2-4a1 1 0 1 1 1.78.9l-2 4A1 1 0 0 1 8 30z"}),props.children);});var CloudRain24=/*#__PURE__*/React.forwardRef(function CloudRain24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.5 22h-15A6.5 6.5 0 0 1 7.2 9.14a9 9 0 0 1 17.6 0A6.5 6.5 0 0 1 23.5 22zM16 4a7 7 0 0 0-6.94 6.14L9 11h-.86a4.5 4.5 0 0 0 .36 9h15a4.5 4.5 0 0 0 .36-9H23l-.1-.82A7 7 0 0 0 16 4zm-2 26a.93.93 0 0 1-.45-.11 1 1 0 0 1-.44-1.34l2-4a1 1 0 1 1 1.78.9l-2 4A1 1 0 0 1 14 30zm6 0a.93.93 0 0 1-.45-.11 1 1 0 0 1-.44-1.34l2-4a1 1 0 1 1 1.78.9l-2 4A1 1 0 0 1 20 30zM8 30a.93.93 0 0 1-.45-.11 1 1 0 0 1-.44-1.34l2-4a1 1 0 1 1 1.78.9l-2 4A1 1 0 0 1 8 30z"}),props.children);});var CloudRain20=/*#__PURE__*/React.forwardRef(function CloudRain20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.5 22h-15A6.5 6.5 0 0 1 7.2 9.14a9 9 0 0 1 17.6 0A6.5 6.5 0 0 1 23.5 22zM16 4a7 7 0 0 0-6.94 6.14L9 11h-.86a4.5 4.5 0 0 0 .36 9h15a4.5 4.5 0 0 0 .36-9H23l-.1-.82A7 7 0 0 0 16 4zm-2 26a.93.93 0 0 1-.45-.11 1 1 0 0 1-.44-1.34l2-4a1 1 0 1 1 1.78.9l-2 4A1 1 0 0 1 14 30zm6 0a.93.93 0 0 1-.45-.11 1 1 0 0 1-.44-1.34l2-4a1 1 0 1 1 1.78.9l-2 4A1 1 0 0 1 20 30zM8 30a.93.93 0 0 1-.45-.11 1 1 0 0 1-.44-1.34l2-4a1 1 0 1 1 1.78.9l-2 4A1 1 0 0 1 8 30z"}),props.children);});var CloudRain16=/*#__PURE__*/React.forwardRef(function CloudRain16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.5 22h-15A6.5 6.5 0 0 1 7.2 9.14a9 9 0 0 1 17.6 0A6.5 6.5 0 0 1 23.5 22zM16 4a7 7 0 0 0-6.94 6.14L9 11h-.86a4.5 4.5 0 0 0 .36 9h15a4.5 4.5 0 0 0 .36-9H23l-.1-.82A7 7 0 0 0 16 4zm-2 26a.93.93 0 0 1-.45-.11 1 1 0 0 1-.44-1.34l2-4a1 1 0 1 1 1.78.9l-2 4A1 1 0 0 1 14 30zm6 0a.93.93 0 0 1-.45-.11 1 1 0 0 1-.44-1.34l2-4a1 1 0 1 1 1.78.9l-2 4A1 1 0 0 1 20 30zM8 30a.93.93 0 0 1-.45-.11 1 1 0 0 1-.44-1.34l2-4a1 1 0 1 1 1.78.9l-2 4A1 1 0 0 1 8 30z"}),props.children);});var CloudSnow32=/*#__PURE__*/React.forwardRef(function CloudSnow32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.5 22h-15A6.5 6.5 0 0 1 7.2 9.14a9 9 0 0 1 17.6 0A6.5 6.5 0 0 1 23.5 22zM16 4a7 7 0 0 0-6.94 6.14L9 11h-.86a4.5 4.5 0 0 0 .36 9h15a4.5 4.5 0 0 0 .36-9H23l-.1-.82A7 7 0 0 0 16 4zm-4 21.05L10.95 24 9.5 25.45 8.05 24 7 25.05l1.45 1.45L7 27.95 8.05 29l1.45-1.45L10.95 29 12 27.95l-1.45-1.45L12 25.05zm14 0L24.95 24l-1.45 1.45L22.05 24 21 25.05l1.45 1.45L21 27.95 22.05 29l1.45-1.45L24.95 29 26 27.95l-1.45-1.45L26 25.05zm-7 2L17.95 26l-1.45 1.45L15.05 26 14 27.05l1.45 1.45L14 29.95 15.05 31l1.45-1.45L17.95 31 19 29.95l-1.45-1.45L19 27.05z"}),props.children);});var CloudSnow24=/*#__PURE__*/React.forwardRef(function CloudSnow24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.5 22h-15A6.5 6.5 0 0 1 7.2 9.14a9 9 0 0 1 17.6 0A6.5 6.5 0 0 1 23.5 22zM16 4a7 7 0 0 0-6.94 6.14L9 11h-.86a4.5 4.5 0 0 0 .36 9h15a4.5 4.5 0 0 0 .36-9H23l-.1-.82A7 7 0 0 0 16 4zm-4 21.05L10.95 24 9.5 25.45 8.05 24 7 25.05l1.45 1.45L7 27.95 8.05 29l1.45-1.45L10.95 29 12 27.95l-1.45-1.45L12 25.05zm14 0L24.95 24l-1.45 1.45L22.05 24 21 25.05l1.45 1.45L21 27.95 22.05 29l1.45-1.45L24.95 29 26 27.95l-1.45-1.45L26 25.05zm-7 2L17.95 26l-1.45 1.45L15.05 26 14 27.05l1.45 1.45L14 29.95 15.05 31l1.45-1.45L17.95 31 19 29.95l-1.45-1.45L19 27.05z"}),props.children);});var CloudSnow20=/*#__PURE__*/React.forwardRef(function CloudSnow20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.5 22h-15A6.5 6.5 0 0 1 7.2 9.14a9 9 0 0 1 17.6 0A6.5 6.5 0 0 1 23.5 22zM16 4a7 7 0 0 0-6.94 6.14L9 11h-.86a4.5 4.5 0 0 0 .36 9h15a4.5 4.5 0 0 0 .36-9H23l-.1-.82A7 7 0 0 0 16 4zm-4 21.05L10.95 24 9.5 25.45 8.05 24 7 25.05l1.45 1.45L7 27.95 8.05 29l1.45-1.45L10.95 29 12 27.95l-1.45-1.45L12 25.05zm14 0L24.95 24l-1.45 1.45L22.05 24 21 25.05l1.45 1.45L21 27.95 22.05 29l1.45-1.45L24.95 29 26 27.95l-1.45-1.45L26 25.05zm-7 2L17.95 26l-1.45 1.45L15.05 26 14 27.05l1.45 1.45L14 29.95 15.05 31l1.45-1.45L17.95 31 19 29.95l-1.45-1.45L19 27.05z"}),props.children);});var CloudSnow16=/*#__PURE__*/React.forwardRef(function CloudSnow16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.5 22h-15A6.5 6.5 0 0 1 7.2 9.14a9 9 0 0 1 17.6 0A6.5 6.5 0 0 1 23.5 22zM16 4a7 7 0 0 0-6.94 6.14L9 11h-.86a4.5 4.5 0 0 0 .36 9h15a4.5 4.5 0 0 0 .36-9H23l-.1-.82A7 7 0 0 0 16 4zm-4 21.05L10.95 24 9.5 25.45 8.05 24 7 25.05l1.45 1.45L7 27.95 8.05 29l1.45-1.45L10.95 29 12 27.95l-1.45-1.45L12 25.05zm14 0L24.95 24l-1.45 1.45L22.05 24 21 25.05l1.45 1.45L21 27.95 22.05 29l1.45-1.45L24.95 29 26 27.95l-1.45-1.45L26 25.05zm-7 2L17.95 26l-1.45 1.45L15.05 26 14 27.05l1.45 1.45L14 29.95 15.05 31l1.45-1.45L17.95 31 19 29.95l-1.45-1.45L19 27.05z"}),props.children);});var CloudUpload32=/*#__PURE__*/React.forwardRef(function CloudUpload32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11 18l1.41 1.41L15 16.83V29h2V16.83l2.59 2.58L21 18l-5-5-5 5z"}),React.createElement("path",{d:"M23.5 22H23v-2h.5a4.5 4.5 0 0 0 .36-9H23l-.1-.82a7 7 0 0 0-13.88 0L9 11h-.86a4.5 4.5 0 0 0 .36 9H9v2h-.5A6.5 6.5 0 0 1 7.2 9.14a9 9 0 0 1 17.6 0A6.5 6.5 0 0 1 23.5 22z"}),props.children);});var CloudUpload24=/*#__PURE__*/React.forwardRef(function CloudUpload24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11 18l1.41 1.41L15 16.83V29h2V16.83l2.59 2.58L21 18l-5-5-5 5z"}),React.createElement("path",{d:"M23.5 22H23v-2h.5a4.5 4.5 0 0 0 .36-9H23l-.1-.82a7 7 0 0 0-13.88 0L9 11h-.86a4.5 4.5 0 0 0 .36 9H9v2h-.5A6.5 6.5 0 0 1 7.2 9.14a9 9 0 0 1 17.6 0A6.5 6.5 0 0 1 23.5 22z"}),props.children);});var CloudUpload20=/*#__PURE__*/React.forwardRef(function CloudUpload20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11 18l1.41 1.41L15 16.83V29h2V16.83l2.59 2.58L21 18l-5-5-5 5z"}),React.createElement("path",{d:"M23.5 22H23v-2h.5a4.5 4.5 0 0 0 .36-9H23l-.1-.82a7 7 0 0 0-13.88 0L9 11h-.86a4.5 4.5 0 0 0 .36 9H9v2h-.5A6.5 6.5 0 0 1 7.2 9.14a9 9 0 0 1 17.6 0A6.5 6.5 0 0 1 23.5 22z"}),props.children);});var CloudUpload16=/*#__PURE__*/React.forwardRef(function CloudUpload16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11 18l1.41 1.41L15 16.83V29h2V16.83l2.59 2.58L21 18l-5-5-5 5z"}),React.createElement("path",{d:"M23.5 22H23v-2h.5a4.5 4.5 0 0 0 .36-9H23l-.1-.82a7 7 0 0 0-13.88 0L9 11h-.86a4.5 4.5 0 0 0 .36 9H9v2h-.5A6.5 6.5 0 0 1 7.2 9.14a9 9 0 0 1 17.6 0A6.5 6.5 0 0 1 23.5 22z"}),props.children);});var CloudFoundry_132=/*#__PURE__*/React.forwardRef(function CloudFoundry_132(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 7a7.66 7.66 0 0 1 1.51.15 8 8 0 0 1 6.35 6.34l.26 1.35 1.35.24a5.5 5.5 0 0 1-1 10.92H7.5a5.5 5.5 0 0 1-1-10.92l1.34-.24.26-1.35A8 8 0 0 1 16 7m0-2a10 10 0 0 0-9.83 8.12A7.5 7.5 0 0 0 7.49 28h17a7.5 7.5 0 0 0 1.32-14.88 10 10 0 0 0-7.94-7.94A10.27 10.27 0 0 0 16 5z"}),React.createElement("path",{d:"M14 24h-3a2 2 0 0 1-2-2v-3a2 2 0 0 1 2-2h3v2h-3v3h3zm7-9v-2h-2a2 2 0 0 0-2 2v2h-1v2h1v5h2v-5h2v-2h-2v-2z"}),props.children);});var CloudFoundry_124=/*#__PURE__*/React.forwardRef(function CloudFoundry_124(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 7a7.66 7.66 0 0 1 1.51.15 8 8 0 0 1 6.35 6.34l.26 1.35 1.35.24a5.5 5.5 0 0 1-1 10.92H7.5a5.5 5.5 0 0 1-1-10.92l1.34-.24.26-1.35A8 8 0 0 1 16 7m0-2a10 10 0 0 0-9.83 8.12A7.5 7.5 0 0 0 7.49 28h17a7.5 7.5 0 0 0 1.32-14.88 10 10 0 0 0-7.94-7.94A10.27 10.27 0 0 0 16 5z"}),React.createElement("path",{d:"M14 24h-3a2 2 0 0 1-2-2v-3a2 2 0 0 1 2-2h3v2h-3v3h3zm7-9v-2h-2a2 2 0 0 0-2 2v2h-1v2h1v5h2v-5h2v-2h-2v-2z"}),props.children);});var CloudFoundry_120=/*#__PURE__*/React.forwardRef(function CloudFoundry_120(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 7a7.66 7.66 0 0 1 1.51.15 8 8 0 0 1 6.35 6.34l.26 1.35 1.35.24a5.5 5.5 0 0 1-1 10.92H7.5a5.5 5.5 0 0 1-1-10.92l1.34-.24.26-1.35A8 8 0 0 1 16 7m0-2a10 10 0 0 0-9.83 8.12A7.5 7.5 0 0 0 7.49 28h17a7.5 7.5 0 0 0 1.32-14.88 10 10 0 0 0-7.94-7.94A10.27 10.27 0 0 0 16 5z"}),React.createElement("path",{d:"M14 24h-3a2 2 0 0 1-2-2v-3a2 2 0 0 1 2-2h3v2h-3v3h3zm7-9v-2h-2a2 2 0 0 0-2 2v2h-1v2h1v5h2v-5h2v-2h-2v-2z"}),props.children);});var CloudFoundry_116=/*#__PURE__*/React.forwardRef(function CloudFoundry_116(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 7a7.66 7.66 0 0 1 1.51.15 8 8 0 0 1 6.35 6.34l.26 1.35 1.35.24a5.5 5.5 0 0 1-1 10.92H7.5a5.5 5.5 0 0 1-1-10.92l1.34-.24.26-1.35A8 8 0 0 1 16 7m0-2a10 10 0 0 0-9.83 8.12A7.5 7.5 0 0 0 7.49 28h17a7.5 7.5 0 0 0 1.32-14.88 10 10 0 0 0-7.94-7.94A10.27 10.27 0 0 0 16 5z"}),React.createElement("path",{d:"M14 24h-3a2 2 0 0 1-2-2v-3a2 2 0 0 1 2-2h3v2h-3v3h3zm7-9v-2h-2a2 2 0 0 0-2 2v2h-1v2h1v5h2v-5h2v-2h-2v-2z"}),props.children);});var CloudFoundry_232=/*#__PURE__*/React.forwardRef(function CloudFoundry_232(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 11V9h-8v14h2v-6h5v-2h-5v-4h6zM15 23H9a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h6v2H9v10h6z"}),props.children);});var CloudFoundry_224=/*#__PURE__*/React.forwardRef(function CloudFoundry_224(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 11V9h-8v14h2v-6h5v-2h-5v-4h6zM15 23H9a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h6v2H9v10h6z"}),props.children);});var CloudFoundry_220=/*#__PURE__*/React.forwardRef(function CloudFoundry_220(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 11V9h-8v14h2v-6h5v-2h-5v-4h6zM15 23H9a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h6v2H9v10h6z"}),props.children);});var CloudFoundry_216=/*#__PURE__*/React.forwardRef(function CloudFoundry_216(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 11V9h-8v14h2v-6h5v-2h-5v-4h6zM15 23H9a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h6v2H9v10h6z"}),props.children);});var Cloud32=/*#__PURE__*/React.forwardRef(function Cloud32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 7a7.66 7.66 0 0 1 1.51.15 8 8 0 0 1 6.35 6.34l.26 1.35 1.35.24a5.5 5.5 0 0 1-1 10.92H7.5a5.5 5.5 0 0 1-1-10.92l1.34-.24.26-1.35A8 8 0 0 1 16 7m0-2a10 10 0 0 0-9.83 8.12A7.5 7.5 0 0 0 7.49 28h17a7.5 7.5 0 0 0 1.32-14.88 10 10 0 0 0-7.94-7.94A10.27 10.27 0 0 0 16 5z"}),props.children);});var Cloud24=/*#__PURE__*/React.forwardRef(function Cloud24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 7a7.66 7.66 0 0 1 1.51.15 8 8 0 0 1 6.35 6.34l.26 1.35 1.35.24a5.5 5.5 0 0 1-1 10.92H7.5a5.5 5.5 0 0 1-1-10.92l1.34-.24.26-1.35A8 8 0 0 1 16 7m0-2a10 10 0 0 0-9.83 8.12A7.5 7.5 0 0 0 7.49 28h17a7.5 7.5 0 0 0 1.32-14.88 10 10 0 0 0-7.94-7.94A10.27 10.27 0 0 0 16 5z"}),props.children);});var Cloud20=/*#__PURE__*/React.forwardRef(function Cloud20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 7a7.66 7.66 0 0 1 1.51.15 8 8 0 0 1 6.35 6.34l.26 1.35 1.35.24a5.5 5.5 0 0 1-1 10.92H7.5a5.5 5.5 0 0 1-1-10.92l1.34-.24.26-1.35A8 8 0 0 1 16 7m0-2a10 10 0 0 0-9.83 8.12A7.5 7.5 0 0 0 7.49 28h17a7.5 7.5 0 0 0 1.32-14.88 10 10 0 0 0-7.94-7.94A10.27 10.27 0 0 0 16 5z"}),props.children);});var Cloud16=/*#__PURE__*/React.forwardRef(function Cloud16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 7a7.66 7.66 0 0 1 1.51.15 8 8 0 0 1 6.35 6.34l.26 1.35 1.35.24a5.5 5.5 0 0 1-1 10.92H7.5a5.5 5.5 0 0 1-1-10.92l1.34-.24.26-1.35A8 8 0 0 1 16 7m0-2a10 10 0 0 0-9.83 8.12A7.5 7.5 0 0 0 7.49 28h17a7.5 7.5 0 0 0 1.32-14.88 10 10 0 0 0-7.94-7.94A10.27 10.27 0 0 0 16 5z"}),props.children);});var Code32=/*#__PURE__*/React.forwardRef(function Code32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M31 16l-7 7-1.41-1.41L28.17 16l-5.58-5.59L24 9l7 7zM1 16l7-7 1.41 1.41L3.83 16l5.58 5.59L8 23l-7-7zm11.42 9.484L17.64 6l1.932.517L14.352 26z"}),props.children);});var Code24=/*#__PURE__*/React.forwardRef(function Code24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M31 16l-7 7-1.41-1.41L28.17 16l-5.58-5.59L24 9l7 7zM1 16l7-7 1.41 1.41L3.83 16l5.58 5.59L8 23l-7-7zm11.42 9.484L17.64 6l1.932.517L14.352 26z"}),props.children);});var Code20=/*#__PURE__*/React.forwardRef(function Code20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M31 16l-7 7-1.41-1.41L28.17 16l-5.58-5.59L24 9l7 7zM1 16l7-7 1.41 1.41L3.83 16l5.58 5.59L8 23l-7-7zm11.42 9.484L17.64 6l1.932.517L14.352 26z"}),props.children);});var Cognitive32=/*#__PURE__*/React.forwardRef(function Cognitive32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 13A11 11 0 0 0 19 2h-8a9 9 0 0 0-9 9v3a5 5 0 0 0 5 5h1.1a5 5 0 0 0 4.9 4h1.38l4 7 1.73-1-4-6.89A2 2 0 0 0 14.38 21H13a3 3 0 0 1 0-6h1v-2h-1a5 5 0 0 0-4.9 4H7a3 3 0 0 1-3-3v-2h2a3 3 0 0 0 3-3V8H7v1a1 1 0 0 1-1 1H4.08A7 7 0 0 1 11 4h6v2a1 1 0 0 1-1 1h-2v2h2a3 3 0 0 0 3-3V4a9 9 0 0 1 8.05 5H26a3 3 0 0 0-3 3v1h2v-1a1 1 0 0 1 1-1h1.77a8.76 8.76 0 0 1 .23 2v1a5 5 0 0 1-5 5h-3v2h3a7 7 0 0 0 3-.68V21a3 3 0 0 1-3 3h-1v2h1a5 5 0 0 0 5-5v-2.11A7 7 0 0 0 30 14z"}),props.children);});var Cognitive24=/*#__PURE__*/React.forwardRef(function Cognitive24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 13A11 11 0 0 0 19 2h-8a9 9 0 0 0-9 9v3a5 5 0 0 0 5 5h1.1a5 5 0 0 0 4.9 4h1.38l4 7 1.73-1-4-6.89A2 2 0 0 0 14.38 21H13a3 3 0 0 1 0-6h1v-2h-1a5 5 0 0 0-4.9 4H7a3 3 0 0 1-3-3v-2h2a3 3 0 0 0 3-3V8H7v1a1 1 0 0 1-1 1H4.08A7 7 0 0 1 11 4h6v2a1 1 0 0 1-1 1h-2v2h2a3 3 0 0 0 3-3V4a9 9 0 0 1 8.05 5H26a3 3 0 0 0-3 3v1h2v-1a1 1 0 0 1 1-1h1.77a8.76 8.76 0 0 1 .23 2v1a5 5 0 0 1-5 5h-3v2h3a7 7 0 0 0 3-.68V21a3 3 0 0 1-3 3h-1v2h1a5 5 0 0 0 5-5v-2.11A7 7 0 0 0 30 14z"}),props.children);});var Cognitive20=/*#__PURE__*/React.forwardRef(function Cognitive20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 13A11 11 0 0 0 19 2h-8a9 9 0 0 0-9 9v3a5 5 0 0 0 5 5h1.1a5 5 0 0 0 4.9 4h1.38l4 7 1.73-1-4-6.89A2 2 0 0 0 14.38 21H13a3 3 0 0 1 0-6h1v-2h-1a5 5 0 0 0-4.9 4H7a3 3 0 0 1-3-3v-2h2a3 3 0 0 0 3-3V8H7v1a1 1 0 0 1-1 1H4.08A7 7 0 0 1 11 4h6v2a1 1 0 0 1-1 1h-2v2h2a3 3 0 0 0 3-3V4a9 9 0 0 1 8.05 5H26a3 3 0 0 0-3 3v1h2v-1a1 1 0 0 1 1-1h1.77a8.76 8.76 0 0 1 .23 2v1a5 5 0 0 1-5 5h-3v2h3a7 7 0 0 0 3-.68V21a3 3 0 0 1-3 3h-1v2h1a5 5 0 0 0 5-5v-2.11A7 7 0 0 0 30 14z"}),props.children);});var Cognitive16=/*#__PURE__*/React.forwardRef(function Cognitive16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 13A11 11 0 0 0 19 2h-8a9 9 0 0 0-9 9v3a5 5 0 0 0 5 5h1.1a5 5 0 0 0 4.9 4h1.38l4 7 1.73-1-4-6.89A2 2 0 0 0 14.38 21H13a3 3 0 0 1 0-6h1v-2h-1a5 5 0 0 0-4.9 4H7a3 3 0 0 1-3-3v-2h2a3 3 0 0 0 3-3V8H7v1a1 1 0 0 1-1 1H4.08A7 7 0 0 1 11 4h6v2a1 1 0 0 1-1 1h-2v2h2a3 3 0 0 0 3-3V4a9 9 0 0 1 8.05 5H26a3 3 0 0 0-3 3v1h2v-1a1 1 0 0 1 1-1h1.77a8.76 8.76 0 0 1 .23 2v1a5 5 0 0 1-5 5h-3v2h3a7 7 0 0 0 3-.68V21a3 3 0 0 1-3 3h-1v2h1a5 5 0 0 0 5-5v-2.11A7 7 0 0 0 30 14z"}),props.children);});var Collaborate32=/*#__PURE__*/React.forwardRef(function Collaborate32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6 21v-1H4v1a7 7 0 0 0 7 7h3v-2h-3a5 5 0 0 1-5-5zm18-10v1h2v-1a7 7 0 0 0-7-7h-3v2h3a5 5 0 0 1 5 5zm-13 0H5a3 3 0 0 0-3 3v2h2v-2a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1v2h2v-2a3 3 0 0 0-3-3zm-3-1a4 4 0 1 0-4-4 4 4 0 0 0 4 4zm0-6a2 2 0 1 1-2 2 2 2 0 0 1 2-2zm19 21h-6a3 3 0 0 0-3 3v2h2v-2a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1v2h2v-2a3 3 0 0 0-3-3zm-7-5a4 4 0 1 0 4-4 4 4 0 0 0-4 4zm6 0a2 2 0 1 1-2-2 2 2 0 0 1 2 2z"}),props.children);});var Collaborate24=/*#__PURE__*/React.forwardRef(function Collaborate24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6 21v-1H4v1a7 7 0 0 0 7 7h3v-2h-3a5 5 0 0 1-5-5zm18-10v1h2v-1a7 7 0 0 0-7-7h-3v2h3a5 5 0 0 1 5 5zm-13 0H5a3 3 0 0 0-3 3v2h2v-2a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1v2h2v-2a3 3 0 0 0-3-3zm-3-1a4 4 0 1 0-4-4 4 4 0 0 0 4 4zm0-6a2 2 0 1 1-2 2 2 2 0 0 1 2-2zm19 21h-6a3 3 0 0 0-3 3v2h2v-2a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1v2h2v-2a3 3 0 0 0-3-3zm-7-5a4 4 0 1 0 4-4 4 4 0 0 0-4 4zm6 0a2 2 0 1 1-2-2 2 2 0 0 1 2 2z"}),props.children);});var Collaborate20=/*#__PURE__*/React.forwardRef(function Collaborate20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6 21v-1H4v1a7 7 0 0 0 7 7h3v-2h-3a5 5 0 0 1-5-5zm18-10v1h2v-1a7 7 0 0 0-7-7h-3v2h3a5 5 0 0 1 5 5zm-13 0H5a3 3 0 0 0-3 3v2h2v-2a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1v2h2v-2a3 3 0 0 0-3-3zm-3-1a4 4 0 1 0-4-4 4 4 0 0 0 4 4zm0-6a2 2 0 1 1-2 2 2 2 0 0 1 2-2zm19 21h-6a3 3 0 0 0-3 3v2h2v-2a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1v2h2v-2a3 3 0 0 0-3-3zm-7-5a4 4 0 1 0 4-4 4 4 0 0 0-4 4zm6 0a2 2 0 1 1-2-2 2 2 0 0 1 2 2z"}),props.children);});var Collaborate16=/*#__PURE__*/React.forwardRef(function Collaborate16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6 21v-1H4v1a7 7 0 0 0 7 7h3v-2h-3a5 5 0 0 1-5-5zm18-10v1h2v-1a7 7 0 0 0-7-7h-3v2h3a5 5 0 0 1 5 5zm-13 0H5a3 3 0 0 0-3 3v2h2v-2a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1v2h2v-2a3 3 0 0 0-3-3zm-3-1a4 4 0 1 0-4-4 4 4 0 0 0 4 4zm0-6a2 2 0 1 1-2 2 2 2 0 0 1 2-2zm19 21h-6a3 3 0 0 0-3 3v2h2v-2a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1v2h2v-2a3 3 0 0 0-3-3zm-7-5a4 4 0 1 0 4-4 4 4 0 0 0-4 4zm6 0a2 2 0 1 1-2-2 2 2 0 0 1 2 2z"}),props.children);});var ColorPalette32=/*#__PURE__*/React.forwardRef(function ColorPalette32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"10",cy:"12",r:"2"}),React.createElement("circle",{cx:"16",cy:"9",r:"2"}),React.createElement("circle",{cx:"22",cy:"12",r:"2"}),React.createElement("circle",{cx:"23",cy:"18",r:"2"}),React.createElement("circle",{cx:"19",cy:"23",r:"2"}),React.createElement("path",{d:"M16.54 2A14 14 0 0 0 2 16a4.82 4.82 0 0 0 6.09 4.65l1.12-.31a3 3 0 0 1 3.79 2.9V27a3 3 0 0 0 3 3 14 14 0 0 0 14-14.54A14.05 14.05 0 0 0 16.54 2zm8.11 22.31A11.93 11.93 0 0 1 16 28a1 1 0 0 1-1-1v-3.76a5 5 0 0 0-5-5 5.07 5.07 0 0 0-1.33.18l-1.12.31A2.82 2.82 0 0 1 4 16 12 12 0 0 1 16.47 4 12.18 12.18 0 0 1 28 15.53a11.89 11.89 0 0 1-3.35 8.79z"}),props.children);});var ColorPalette24=/*#__PURE__*/React.forwardRef(function ColorPalette24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"10",cy:"12",r:"2"}),React.createElement("circle",{cx:"16",cy:"9",r:"2"}),React.createElement("circle",{cx:"22",cy:"12",r:"2"}),React.createElement("circle",{cx:"23",cy:"18",r:"2"}),React.createElement("circle",{cx:"19",cy:"23",r:"2"}),React.createElement("path",{d:"M16.54 2A14 14 0 0 0 2 16a4.82 4.82 0 0 0 6.09 4.65l1.12-.31a3 3 0 0 1 3.79 2.9V27a3 3 0 0 0 3 3 14 14 0 0 0 14-14.54A14.05 14.05 0 0 0 16.54 2zm8.11 22.31A11.93 11.93 0 0 1 16 28a1 1 0 0 1-1-1v-3.76a5 5 0 0 0-5-5 5.07 5.07 0 0 0-1.33.18l-1.12.31A2.82 2.82 0 0 1 4 16 12 12 0 0 1 16.47 4 12.18 12.18 0 0 1 28 15.53a11.89 11.89 0 0 1-3.35 8.79z"}),props.children);});var ColorPalette20=/*#__PURE__*/React.forwardRef(function ColorPalette20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"10",cy:"12",r:"2"}),React.createElement("circle",{cx:"16",cy:"9",r:"2"}),React.createElement("circle",{cx:"22",cy:"12",r:"2"}),React.createElement("circle",{cx:"23",cy:"18",r:"2"}),React.createElement("circle",{cx:"19",cy:"23",r:"2"}),React.createElement("path",{d:"M16.54 2A14 14 0 0 0 2 16a4.82 4.82 0 0 0 6.09 4.65l1.12-.31a3 3 0 0 1 3.79 2.9V27a3 3 0 0 0 3 3 14 14 0 0 0 14-14.54A14.05 14.05 0 0 0 16.54 2zm8.11 22.31A11.93 11.93 0 0 1 16 28a1 1 0 0 1-1-1v-3.76a5 5 0 0 0-5-5 5.07 5.07 0 0 0-1.33.18l-1.12.31A2.82 2.82 0 0 1 4 16 12 12 0 0 1 16.47 4 12.18 12.18 0 0 1 28 15.53a11.89 11.89 0 0 1-3.35 8.79z"}),props.children);});var ColorPalette16=/*#__PURE__*/React.forwardRef(function ColorPalette16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"10",cy:"12",r:"2"}),React.createElement("circle",{cx:"16",cy:"9",r:"2"}),React.createElement("circle",{cx:"22",cy:"12",r:"2"}),React.createElement("circle",{cx:"23",cy:"18",r:"2"}),React.createElement("circle",{cx:"19",cy:"23",r:"2"}),React.createElement("path",{d:"M16.54 2A14 14 0 0 0 2 16a4.82 4.82 0 0 0 6.09 4.65l1.12-.31a3 3 0 0 1 3.79 2.9V27a3 3 0 0 0 3 3 14 14 0 0 0 14-14.54A14.05 14.05 0 0 0 16.54 2zm8.11 22.31A11.93 11.93 0 0 1 16 28a1 1 0 0 1-1-1v-3.76a5 5 0 0 0-5-5 5.07 5.07 0 0 0-1.33.18l-1.12.31A2.82 2.82 0 0 1 4 16 12 12 0 0 1 16.47 4 12.18 12.18 0 0 1 28 15.53a11.89 11.89 0 0 1-3.35 8.79z"}),props.children);});var Column32=/*#__PURE__*/React.forwardRef(function Column32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 4h2v24h-2zm-6 2v20h-4V6h4m0-2h-4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zM6 4h2v24H6z"}),props.children);});var Column24=/*#__PURE__*/React.forwardRef(function Column24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 4h2v24h-2zm-6 2v20h-4V6h4m0-2h-4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zM6 4h2v24H6z"}),props.children);});var Column20=/*#__PURE__*/React.forwardRef(function Column20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 4h2v24h-2zm-6 2v20h-4V6h4m0-2h-4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zM6 4h2v24H6z"}),props.children);});var Column16=/*#__PURE__*/React.forwardRef(function Column16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 4h2v24h-2zm-6 2v20h-4V6h4m0-2h-4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zM6 4h2v24H6z"}),props.children);});var Compare32=/*#__PURE__*/React.forwardRef(function Compare32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 6H18V4a2 2 0 0 0-2-2H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h10v2a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zM4 15h6.17l-2.58 2.59L9 19l5-5-5-5-1.41 1.41L10.17 13H4V4h12v20H4zm12 13v-2a2 2 0 0 0 2-2V8h10v9h-6.17l2.58-2.59L23 13l-5 5 5 5 1.41-1.41L21.83 19H28v9z"}),props.children);});var Compare24=/*#__PURE__*/React.forwardRef(function Compare24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 6H18V4a2 2 0 0 0-2-2H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h10v2a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zM4 15h6.17l-2.58 2.59L9 19l5-5-5-5-1.41 1.41L10.17 13H4V4h12v20H4zm12 13v-2a2 2 0 0 0 2-2V8h10v9h-6.17l2.58-2.59L23 13l-5 5 5 5 1.41-1.41L21.83 19H28v9z"}),props.children);});var Compare20=/*#__PURE__*/React.forwardRef(function Compare20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 6H18V4a2 2 0 0 0-2-2H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h10v2a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zM4 15h6.17l-2.58 2.59L9 19l5-5-5-5-1.41 1.41L10.17 13H4V4h12v20H4zm12 13v-2a2 2 0 0 0 2-2V8h10v9h-6.17l2.58-2.59L23 13l-5 5 5 5 1.41-1.41L21.83 19H28v9z"}),props.children);});var Compare16=/*#__PURE__*/React.forwardRef(function Compare16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 6H18V4a2 2 0 0 0-2-2H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h10v2a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zM4 15h6.17l-2.58 2.59L9 19l5-5-5-5-1.41 1.41L10.17 13H4V4h12v20H4zm12 13v-2a2 2 0 0 0 2-2V8h10v9h-6.17l2.58-2.59L23 13l-5 5 5 5 1.41-1.41L21.83 19H28v9z"}),props.children);});var Compass32=/*#__PURE__*/React.forwardRef(function Compass32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 4A12 12 0 1 1 4 16 12 12 0 0 1 16 4m0-2a14 14 0 1 0 14 14A14 14 0 0 0 16 2z"}),React.createElement("path",{d:"M23 10.41L21.59 9l-4.3 4.3a3 3 0 0 0-4 4L9 21.59 10.41 23l4.3-4.3a3 3 0 0 0 4-4zM17 16a1 1 0 1 1-1-1 1 1 0 0 1 1 1z"}),React.createElement("circle",{cx:"16",cy:"7.5",r:"1.5"}),props.children);});var Compass24=/*#__PURE__*/React.forwardRef(function Compass24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 4A12 12 0 1 1 4 16 12 12 0 0 1 16 4m0-2a14 14 0 1 0 14 14A14 14 0 0 0 16 2z"}),React.createElement("path",{d:"M23 10.41L21.59 9l-4.3 4.3a3 3 0 0 0-4 4L9 21.59 10.41 23l4.3-4.3a3 3 0 0 0 4-4zM17 16a1 1 0 1 1-1-1 1 1 0 0 1 1 1z"}),React.createElement("circle",{cx:"16",cy:"7.5",r:"1.5"}),props.children);});var Compass20=/*#__PURE__*/React.forwardRef(function Compass20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 4A12 12 0 1 1 4 16 12 12 0 0 1 16 4m0-2a14 14 0 1 0 14 14A14 14 0 0 0 16 2z"}),React.createElement("path",{d:"M23 10.41L21.59 9l-4.3 4.3a3 3 0 0 0-4 4L9 21.59 10.41 23l4.3-4.3a3 3 0 0 0 4-4zM17 16a1 1 0 1 1-1-1 1 1 0 0 1 1 1z"}),React.createElement("circle",{cx:"16",cy:"7.5",r:"1.5"}),props.children);});var Compass16=/*#__PURE__*/React.forwardRef(function Compass16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 4A12 12 0 1 1 4 16 12 12 0 0 1 16 4m0-2a14 14 0 1 0 14 14A14 14 0 0 0 16 2z"}),React.createElement("path",{d:"M23 10.41L21.59 9l-4.3 4.3a3 3 0 0 0-4 4L9 21.59 10.41 23l4.3-4.3a3 3 0 0 0 4-4zM17 16a1 1 0 1 1-1-1 1 1 0 0 1 1 1z"}),React.createElement("circle",{cx:"16",cy:"7.5",r:"1.5"}),props.children);});var ComposerEdit32=/*#__PURE__*/React.forwardRef(function ComposerEdit32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.82 10H30V8h-4.18a3 3 0 0 0-5.64 0H13V5H5v3H2v2h3v3h8v-3h7.18A3 3 0 0 0 22 11.82v7.32A4 4 0 0 0 19.14 22H2v2h17.14a4 4 0 0 0 7.72 0H30v-2h-3.14A4 4 0 0 0 24 19.14v-7.32A3 3 0 0 0 25.82 10zM11 11H7V7h4zm14 12a2 2 0 1 1-2-2 2 2 0 0 1 2 2z"}),props.children);});var ComposerEdit24=/*#__PURE__*/React.forwardRef(function ComposerEdit24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.82 10H30V8h-4.18a3 3 0 0 0-5.64 0H13V5H5v3H2v2h3v3h8v-3h7.18A3 3 0 0 0 22 11.82v7.32A4 4 0 0 0 19.14 22H2v2h17.14a4 4 0 0 0 7.72 0H30v-2h-3.14A4 4 0 0 0 24 19.14v-7.32A3 3 0 0 0 25.82 10zM11 11H7V7h4zm14 12a2 2 0 1 1-2-2 2 2 0 0 1 2 2z"}),props.children);});var ComposerEdit20=/*#__PURE__*/React.forwardRef(function ComposerEdit20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.82 10H30V8h-4.18a3 3 0 0 0-5.64 0H13V5H5v3H2v2h3v3h8v-3h7.18A3 3 0 0 0 22 11.82v7.32A4 4 0 0 0 19.14 22H2v2h17.14a4 4 0 0 0 7.72 0H30v-2h-3.14A4 4 0 0 0 24 19.14v-7.32A3 3 0 0 0 25.82 10zM11 11H7V7h4zm14 12a2 2 0 1 1-2-2 2 2 0 0 1 2 2z"}),props.children);});var ComposerEdit16=/*#__PURE__*/React.forwardRef(function ComposerEdit16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.82 10H30V8h-4.18a3 3 0 0 0-5.64 0H13V5H5v3H2v2h3v3h8v-3h7.18A3 3 0 0 0 22 11.82v7.32A4 4 0 0 0 19.14 22H2v2h17.14a4 4 0 0 0 7.72 0H30v-2h-3.14A4 4 0 0 0 24 19.14v-7.32A3 3 0 0 0 25.82 10zM11 11H7V7h4zm14 12a2 2 0 1 1-2-2 2 2 0 0 1 2 2z"}),props.children);});var Concept32=/*#__PURE__*/React.forwardRef(function Concept32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20.885 19.471a5.96 5.96 0 0 0 0-6.942L23 10.414l1.293 1.293a1 1 0 0 0 1.414 0l4-4a1 1 0 0 0 0-1.414l-4-4a1 1 0 0 0-1.414 0l-4 4a1 1 0 0 0 0 1.414L21.586 9l-2.115 2.115a5.96 5.96 0 0 0-6.942 0L10 8.585V2H2v8h6.586l2.529 2.529a5.96 5.96 0 0 0 0 6.942L9 21.586l-1.293-1.293a1 1 0 0 0-1.414 0l-4 4a1 1 0 0 0 0 1.414l4 4a1 1 0 0 0 1.414 0l4-4a1 1 0 0 0 0-1.414L10.414 23l2.115-2.115a5.96 5.96 0 0 0 6.942 0L22 23.415V30h8v-8h-6.586zM25 4.414L27.586 7 25 9.586 22.414 7zM7 27.586L4.414 25 7 22.414 9.586 25zM8 8H4V4h4zm4 8a4 4 0 1 1 4 4 4.005 4.005 0 0 1-4-4zm12 8h4v4h-4z"}),props.children);});var Concept24=/*#__PURE__*/React.forwardRef(function Concept24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20.885 19.471a5.96 5.96 0 0 0 0-6.942L23 10.414l1.293 1.293a1 1 0 0 0 1.414 0l4-4a1 1 0 0 0 0-1.414l-4-4a1 1 0 0 0-1.414 0l-4 4a1 1 0 0 0 0 1.414L21.586 9l-2.115 2.115a5.96 5.96 0 0 0-6.942 0L10 8.585V2H2v8h6.586l2.529 2.529a5.96 5.96 0 0 0 0 6.942L9 21.586l-1.293-1.293a1 1 0 0 0-1.414 0l-4 4a1 1 0 0 0 0 1.414l4 4a1 1 0 0 0 1.414 0l4-4a1 1 0 0 0 0-1.414L10.414 23l2.115-2.115a5.96 5.96 0 0 0 6.942 0L22 23.415V30h8v-8h-6.586zM25 4.414L27.586 7 25 9.586 22.414 7zM7 27.586L4.414 25 7 22.414 9.586 25zM8 8H4V4h4zm4 8a4 4 0 1 1 4 4 4.005 4.005 0 0 1-4-4zm12 8h4v4h-4z"}),props.children);});var Concept20=/*#__PURE__*/React.forwardRef(function Concept20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20.885 19.471a5.96 5.96 0 0 0 0-6.942L23 10.414l1.293 1.293a1 1 0 0 0 1.414 0l4-4a1 1 0 0 0 0-1.414l-4-4a1 1 0 0 0-1.414 0l-4 4a1 1 0 0 0 0 1.414L21.586 9l-2.115 2.115a5.96 5.96 0 0 0-6.942 0L10 8.585V2H2v8h6.586l2.529 2.529a5.96 5.96 0 0 0 0 6.942L9 21.586l-1.293-1.293a1 1 0 0 0-1.414 0l-4 4a1 1 0 0 0 0 1.414l4 4a1 1 0 0 0 1.414 0l4-4a1 1 0 0 0 0-1.414L10.414 23l2.115-2.115a5.96 5.96 0 0 0 6.942 0L22 23.415V30h8v-8h-6.586zM25 4.414L27.586 7 25 9.586 22.414 7zM7 27.586L4.414 25 7 22.414 9.586 25zM8 8H4V4h4zm4 8a4 4 0 1 1 4 4 4.005 4.005 0 0 1-4-4zm12 8h4v4h-4z"}),props.children);});var Concept16=/*#__PURE__*/React.forwardRef(function Concept16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20.885 19.471a5.96 5.96 0 0 0 0-6.942L23 10.414l1.293 1.293a1 1 0 0 0 1.414 0l4-4a1 1 0 0 0 0-1.414l-4-4a1 1 0 0 0-1.414 0l-4 4a1 1 0 0 0 0 1.414L21.586 9l-2.115 2.115a5.96 5.96 0 0 0-6.942 0L10 8.585V2H2v8h6.586l2.529 2.529a5.96 5.96 0 0 0 0 6.942L9 21.586l-1.293-1.293a1 1 0 0 0-1.414 0l-4 4a1 1 0 0 0 0 1.414l4 4a1 1 0 0 0 1.414 0l4-4a1 1 0 0 0 0-1.414L10.414 23l2.115-2.115a5.96 5.96 0 0 0 6.942 0L22 23.415V30h8v-8h-6.586zM25 4.414L27.586 7 25 9.586 22.414 7zM7 27.586L4.414 25 7 22.414 9.586 25zM8 8H4V4h4zm4 8a4 4 0 1 1 4 4 4.005 4.005 0 0 1-4-4zm12 8h4v4h-4z"}),props.children);});var Connect32=/*#__PURE__*/React.forwardRef(function Connect32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 16.01a7 7 0 0 0-4.18 1.39l-4.22-4.22A6.86 6.86 0 0 0 16 9.01a7 7 0 1 0-2.81 5.59l4.21 4.22a7 7 0 1 0 5.6-2.81zm-19-7a5 5 0 1 1 5 5 5 5 0 0 1-5-5z"}),props.children);});var Connect24=/*#__PURE__*/React.forwardRef(function Connect24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 16.01a7 7 0 0 0-4.18 1.39l-4.22-4.22A6.86 6.86 0 0 0 16 9.01a7 7 0 1 0-2.81 5.59l4.21 4.22a7 7 0 1 0 5.6-2.81zm-19-7a5 5 0 1 1 5 5 5 5 0 0 1-5-5z"}),props.children);});var Connect20=/*#__PURE__*/React.forwardRef(function Connect20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 16.01a7 7 0 0 0-4.18 1.39l-4.22-4.22A6.86 6.86 0 0 0 16 9.01a7 7 0 1 0-2.81 5.59l4.21 4.22a7 7 0 1 0 5.6-2.81zm-19-7a5 5 0 1 1 5 5 5 5 0 0 1-5-5z"}),props.children);});var Connect16=/*#__PURE__*/React.forwardRef(function Connect16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 16.01a7 7 0 0 0-4.18 1.39l-4.22-4.22A6.86 6.86 0 0 0 16 9.01a7 7 0 1 0-2.81 5.59l4.21 4.22a7 7 0 1 0 5.6-2.81zm-19-7a5 5 0 1 1 5 5 5 5 0 0 1-5-5z"}),props.children);});var ConnectionSignal32=/*#__PURE__*/React.forwardRef(function ConnectionSignal32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 12h2v18h-2zm-3.67 6.22a7 7 0 0 1 0-10.44l1.34 1.49a5 5 0 0 0 0 7.46zm9.34 0l-1.34-1.49a5 5 0 0 0 0-7.46l1.34-1.49a7 7 0 0 1 0 10.44z"}),React.createElement("path",{d:"M8.4 21.8a11 11 0 0 1 0-17.6l1.2 1.6a9 9 0 0 0 0 14.4zm15.2 0l-1.2-1.6a9 9 0 0 0 0-14.4l1.2-1.6a11 11 0 0 1 0 17.6z"}),props.children);});var ConnectionSignal24=/*#__PURE__*/React.forwardRef(function ConnectionSignal24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 12h2v18h-2zm-3.67 6.22a7 7 0 0 1 0-10.44l1.34 1.49a5 5 0 0 0 0 7.46zm9.34 0l-1.34-1.49a5 5 0 0 0 0-7.46l1.34-1.49a7 7 0 0 1 0 10.44z"}),React.createElement("path",{d:"M8.4 21.8a11 11 0 0 1 0-17.6l1.2 1.6a9 9 0 0 0 0 14.4zm15.2 0l-1.2-1.6a9 9 0 0 0 0-14.4l1.2-1.6a11 11 0 0 1 0 17.6z"}),props.children);});var ConnectionSignal20=/*#__PURE__*/React.forwardRef(function ConnectionSignal20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 12h2v18h-2zm-3.67 6.22a7 7 0 0 1 0-10.44l1.34 1.49a5 5 0 0 0 0 7.46zm9.34 0l-1.34-1.49a5 5 0 0 0 0-7.46l1.34-1.49a7 7 0 0 1 0 10.44z"}),React.createElement("path",{d:"M8.4 21.8a11 11 0 0 1 0-17.6l1.2 1.6a9 9 0 0 0 0 14.4zm15.2 0l-1.2-1.6a9 9 0 0 0 0-14.4l1.2-1.6a11 11 0 0 1 0 17.6z"}),props.children);});var ConnectionSignal16=/*#__PURE__*/React.forwardRef(function ConnectionSignal16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 12h2v18h-2zm-3.67 6.22a7 7 0 0 1 0-10.44l1.34 1.49a5 5 0 0 0 0 7.46zm9.34 0l-1.34-1.49a5 5 0 0 0 0-7.46l1.34-1.49a7 7 0 0 1 0 10.44z"}),React.createElement("path",{d:"M8.4 21.8a11 11 0 0 1 0-17.6l1.2 1.6a9 9 0 0 0 0 14.4zm15.2 0l-1.2-1.6a9 9 0 0 0 0-14.4l1.2-1.6a11 11 0 0 1 0 17.6z"}),props.children);});var Contrast32=/*#__PURE__*/React.forwardRef(function Contrast32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.37 11.84a13.6 13.6 0 0 0-1.06-2.51A14.17 14.17 0 0 0 25.9 6.1a14 14 0 1 0 0 19.8 14.17 14.17 0 0 0 2.41-3.23 13.6 13.6 0 0 0 1.06-2.51 14 14 0 0 0 0-8.32zM4 16A12 12 0 0 1 16 4v24A12 12 0 0 1 4 16z"}),props.children);});var Contrast24=/*#__PURE__*/React.forwardRef(function Contrast24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.37 11.84a13.6 13.6 0 0 0-1.06-2.51A14.17 14.17 0 0 0 25.9 6.1a14 14 0 1 0 0 19.8 14.17 14.17 0 0 0 2.41-3.23 13.6 13.6 0 0 0 1.06-2.51 14 14 0 0 0 0-8.32zM4 16A12 12 0 0 1 16 4v24A12 12 0 0 1 4 16z"}),props.children);});var Contrast20=/*#__PURE__*/React.forwardRef(function Contrast20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.37 11.84a13.6 13.6 0 0 0-1.06-2.51A14.17 14.17 0 0 0 25.9 6.1a14 14 0 1 0 0 19.8 14.17 14.17 0 0 0 2.41-3.23 13.6 13.6 0 0 0 1.06-2.51 14 14 0 0 0 0-8.32zM4 16A12 12 0 0 1 16 4v24A12 12 0 0 1 4 16z"}),props.children);});var Contrast16=/*#__PURE__*/React.forwardRef(function Contrast16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.37 11.84a13.6 13.6 0 0 0-1.06-2.51A14.17 14.17 0 0 0 25.9 6.1a14 14 0 1 0 0 19.8 14.17 14.17 0 0 0 2.41-3.23 13.6 13.6 0 0 0 1.06-2.51 14 14 0 0 0 0-8.32zM4 16A12 12 0 0 1 16 4v24A12 12 0 0 1 4 16z"}),props.children);});var CopyFile32=/*#__PURE__*/React.forwardRef(function CopyFile32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.435 14.699l-6.058-6.121A1.949 1.949 0 0 0 19.998 8H12a2.002 2.002 0 0 0-2 2v19a2.002 2.002 0 0 0 2 2h14a2.002 2.002 0 0 0 2-2V16.077a1.976 1.976 0 0 0-.565-1.378zM20 10.03L25.924 16H20zM12 29V10h6v6a2.002 2.002 0 0 0 2 2h6l.001 11z"}),React.createElement("path",{d:"M6 18H4V4a2.002 2.002 0 0 1 2-2h14v2H6z"}),props.children);});var CopyFile24=/*#__PURE__*/React.forwardRef(function CopyFile24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.435 14.699l-6.058-6.121A1.949 1.949 0 0 0 19.998 8H12a2.002 2.002 0 0 0-2 2v19a2.002 2.002 0 0 0 2 2h14a2.002 2.002 0 0 0 2-2V16.077a1.976 1.976 0 0 0-.565-1.378zM20 10.03L25.924 16H20zM12 29V10h6v6a2.002 2.002 0 0 0 2 2h6l.001 11z"}),React.createElement("path",{d:"M6 18H4V4a2.002 2.002 0 0 1 2-2h14v2H6z"}),props.children);});var CopyFile20=/*#__PURE__*/React.forwardRef(function CopyFile20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.435 14.699l-6.058-6.121A1.949 1.949 0 0 0 19.998 8H12a2.002 2.002 0 0 0-2 2v19a2.002 2.002 0 0 0 2 2h14a2.002 2.002 0 0 0 2-2V16.077a1.976 1.976 0 0 0-.565-1.378zM20 10.03L25.924 16H20zM12 29V10h6v6a2.002 2.002 0 0 0 2 2h6l.001 11z"}),React.createElement("path",{d:"M6 18H4V4a2.002 2.002 0 0 1 2-2h14v2H6z"}),props.children);});var Copy32=/*#__PURE__*/React.forwardRef(function Copy32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 10v18H10V10h18m0-2H10a2 2 0 0 0-2 2v18a2 2 0 0 0 2 2h18a2 2 0 0 0 2-2V10a2 2 0 0 0-2-2z"}),React.createElement("path",{d:"M4 18H2V4a2 2 0 0 1 2-2h14v2H4z"}),props.children);});var Copy24=/*#__PURE__*/React.forwardRef(function Copy24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 10v18H10V10h18m0-2H10a2 2 0 0 0-2 2v18a2 2 0 0 0 2 2h18a2 2 0 0 0 2-2V10a2 2 0 0 0-2-2z"}),React.createElement("path",{d:"M4 18H2V4a2 2 0 0 1 2-2h14v2H4z"}),props.children);});var Copy20=/*#__PURE__*/React.forwardRef(function Copy20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 10v18H10V10h18m0-2H10a2 2 0 0 0-2 2v18a2 2 0 0 0 2 2h18a2 2 0 0 0 2-2V10a2 2 0 0 0-2-2z"}),React.createElement("path",{d:"M4 18H2V4a2 2 0 0 1 2-2h14v2H4z"}),props.children);});var Corner32=/*#__PURE__*/React.forwardRef(function Corner32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 9H14V6H6v8h3v14h2V14h3v-3h14zm-16 3H8V8h4z"}),props.children);});var Corner24=/*#__PURE__*/React.forwardRef(function Corner24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 9H14V6H6v8h3v14h2V14h3v-3h14zm-16 3H8V8h4z"}),props.children);});var Corner20=/*#__PURE__*/React.forwardRef(function Corner20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 9H14V6H6v8h3v14h2V14h3v-3h14zm-16 3H8V8h4z"}),props.children);});var Corner16=/*#__PURE__*/React.forwardRef(function Corner16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 9H14V6H6v8h3v14h2V14h3v-3h14zm-16 3H8V8h4z"}),props.children);});var Crop32=/*#__PURE__*/React.forwardRef(function Crop32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 20h-2V9H12V7h11a2 2 0 0 1 2 2z"}),React.createElement("path",{d:"M9 23V2H7v5H2v2h5v14a2 2 0 0 0 2 2h14v5h2v-5h5v-2z"}),props.children);});var Crop24=/*#__PURE__*/React.forwardRef(function Crop24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 20h-2V9H12V7h11a2 2 0 0 1 2 2z"}),React.createElement("path",{d:"M9 23V2H7v5H2v2h5v14a2 2 0 0 0 2 2h14v5h2v-5h5v-2z"}),props.children);});var Crop20=/*#__PURE__*/React.forwardRef(function Crop20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 20h-2V9H12V7h11a2 2 0 0 1 2 2z"}),React.createElement("path",{d:"M9 23V2H7v5H2v2h5v14a2 2 0 0 0 2 2h14v5h2v-5h5v-2z"}),props.children);});var Crop16=/*#__PURE__*/React.forwardRef(function Crop16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 20h-2V9H12V7h11a2 2 0 0 1 2 2z"}),React.createElement("path",{d:"M9 23V2H7v5H2v2h5v14a2 2 0 0 0 2 2h14v5h2v-5h5v-2z"}),props.children);});var Cursor_132=/*#__PURE__*/React.forwardRef(function Cursor_132(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 28a1 1 0 0 1-.71-.29l-6.13-6.14-3.33 5a1 1 0 0 1-1 .44 1 1 0 0 1-.81-.7l-6-20A1 1 0 0 1 6.29 5l20 6a1 1 0 0 1 .7.81 1 1 0 0 1-.44 1l-5 3.33 6.14 6.13a1 1 0 0 1 0 1.42l-4 4A1 1 0 0 1 23 28zm0-2.41L25.59 23l-7.16-7.15 5.25-3.5L7.49 7.49l4.86 16.19 3.5-5.25z"}),props.children);});var Cursor_124=/*#__PURE__*/React.forwardRef(function Cursor_124(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 28a1 1 0 0 1-.71-.29l-6.13-6.14-3.33 5a1 1 0 0 1-1 .44 1 1 0 0 1-.81-.7l-6-20A1 1 0 0 1 6.29 5l20 6a1 1 0 0 1 .7.81 1 1 0 0 1-.44 1l-5 3.33 6.14 6.13a1 1 0 0 1 0 1.42l-4 4A1 1 0 0 1 23 28zm0-2.41L25.59 23l-7.16-7.15 5.25-3.5L7.49 7.49l4.86 16.19 3.5-5.25z"}),props.children);});var Cursor_120=/*#__PURE__*/React.forwardRef(function Cursor_120(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 28a1 1 0 0 1-.71-.29l-6.13-6.14-3.33 5a1 1 0 0 1-1 .44 1 1 0 0 1-.81-.7l-6-20A1 1 0 0 1 6.29 5l20 6a1 1 0 0 1 .7.81 1 1 0 0 1-.44 1l-5 3.33 6.14 6.13a1 1 0 0 1 0 1.42l-4 4A1 1 0 0 1 23 28zm0-2.41L25.59 23l-7.16-7.15 5.25-3.5L7.49 7.49l4.86 16.19 3.5-5.25z"}),props.children);});var Cursor_116=/*#__PURE__*/React.forwardRef(function Cursor_116(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 28a1 1 0 0 1-.71-.29l-6.13-6.14-3.33 5a1 1 0 0 1-1 .44 1 1 0 0 1-.81-.7l-6-20A1 1 0 0 1 6.29 5l20 6a1 1 0 0 1 .7.81 1 1 0 0 1-.44 1l-5 3.33 6.14 6.13a1 1 0 0 1 0 1.42l-4 4A1 1 0 0 1 23 28zm0-2.41L25.59 23l-7.16-7.15 5.25-3.5L7.49 7.49l4.86 16.19 3.5-5.25z"}),props.children);});var Cursor_232=/*#__PURE__*/React.forwardRef(function Cursor_232(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.34 12.06l-22-8a1 1 0 0 0-1.28 1.28l8 22A1 1 0 0 0 13 28a1 1 0 0 0 .93-.63l3.84-9.6 9.6-3.84a1 1 0 0 0 0-1.87zm-10.71 4l-.4.16-.16.4L13 24.2 6.67 6.67 24.2 13z"}),props.children);});var Cursor_224=/*#__PURE__*/React.forwardRef(function Cursor_224(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.34 12.06l-22-8a1 1 0 0 0-1.28 1.28l8 22A1 1 0 0 0 13 28a1 1 0 0 0 .93-.63l3.84-9.6 9.6-3.84a1 1 0 0 0 0-1.87zm-10.71 4l-.4.16-.16.4L13 24.2 6.67 6.67 24.2 13z"}),props.children);});var Cursor_220=/*#__PURE__*/React.forwardRef(function Cursor_220(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.34 12.06l-22-8a1 1 0 0 0-1.28 1.28l8 22A1 1 0 0 0 13 28a1 1 0 0 0 .93-.63l3.84-9.6 9.6-3.84a1 1 0 0 0 0-1.87zm-10.71 4l-.4.16-.16.4L13 24.2 6.67 6.67 24.2 13z"}),props.children);});var Cursor_216=/*#__PURE__*/React.forwardRef(function Cursor_216(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.34 12.06l-22-8a1 1 0 0 0-1.28 1.28l8 22A1 1 0 0 0 13 28a1 1 0 0 0 .93-.63l3.84-9.6 9.6-3.84a1 1 0 0 0 0-1.87zm-10.71 4l-.4.16-.16.4L13 24.2 6.67 6.67 24.2 13z"}),props.children);});var Cut32=/*#__PURE__*/React.forwardRef(function Cut32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26.5 19.63L20.24 16l6.26-3.63a5 5 0 0 0-1.21-9.2A5.19 5.19 0 0 0 24 3a5 5 0 0 0-4.33 7.53 5 5 0 0 0 2.39 2.1l-3.82 2.21L4 6.6 3 8.34 16.24 16 3 23.68l1 1.74 14.24-8.26 3.82 2.21a5 5 0 0 0-2.39 2.1A5 5 0 0 0 24 29a5.19 5.19 0 0 0 1.29-.17 5 5 0 0 0 1.21-9.2zm-5.1-10.1a3 3 0 0 1 1.1-4.12 3 3 0 0 1 4.1 1.11 3 3 0 0 1-1.1 4.11 3 3 0 0 1-4.1-1.1zm5.2 16a3 3 0 0 1-4.1 1.11 3 3 0 0 1-1.1-4.12 3 3 0 0 1 4.1-1.1 3 3 0 0 1 1.1 4.06z"}),props.children);});var Cut24=/*#__PURE__*/React.forwardRef(function Cut24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26.5 19.63L20.24 16l6.26-3.63a5 5 0 0 0-1.21-9.2A5.19 5.19 0 0 0 24 3a5 5 0 0 0-4.33 7.53 5 5 0 0 0 2.39 2.1l-3.82 2.21L4 6.6 3 8.34 16.24 16 3 23.68l1 1.74 14.24-8.26 3.82 2.21a5 5 0 0 0-2.39 2.1A5 5 0 0 0 24 29a5.19 5.19 0 0 0 1.29-.17 5 5 0 0 0 1.21-9.2zm-5.1-10.1a3 3 0 0 1 1.1-4.12 3 3 0 0 1 4.1 1.11 3 3 0 0 1-1.1 4.11 3 3 0 0 1-4.1-1.1zm5.2 16a3 3 0 0 1-4.1 1.11 3 3 0 0 1-1.1-4.12 3 3 0 0 1 4.1-1.1 3 3 0 0 1 1.1 4.06z"}),props.children);});var Cut20=/*#__PURE__*/React.forwardRef(function Cut20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26.5 19.63L20.24 16l6.26-3.63a5 5 0 0 0-1.21-9.2A5.19 5.19 0 0 0 24 3a5 5 0 0 0-4.33 7.53 5 5 0 0 0 2.39 2.1l-3.82 2.21L4 6.6 3 8.34 16.24 16 3 23.68l1 1.74 14.24-8.26 3.82 2.21a5 5 0 0 0-2.39 2.1A5 5 0 0 0 24 29a5.19 5.19 0 0 0 1.29-.17 5 5 0 0 0 1.21-9.2zm-5.1-10.1a3 3 0 0 1 1.1-4.12 3 3 0 0 1 4.1 1.11 3 3 0 0 1-1.1 4.11 3 3 0 0 1-4.1-1.1zm5.2 16a3 3 0 0 1-4.1 1.11 3 3 0 0 1-1.1-4.12 3 3 0 0 1 4.1-1.1 3 3 0 0 1 1.1 4.06z"}),props.children);});var Cut16=/*#__PURE__*/React.forwardRef(function Cut16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26.5 19.63L20.24 16l6.26-3.63a5 5 0 0 0-1.21-9.2A5.19 5.19 0 0 0 24 3a5 5 0 0 0-4.33 7.53 5 5 0 0 0 2.39 2.1l-3.82 2.21L4 6.6 3 8.34 16.24 16 3 23.68l1 1.74 14.24-8.26 3.82 2.21a5 5 0 0 0-2.39 2.1A5 5 0 0 0 24 29a5.19 5.19 0 0 0 1.29-.17 5 5 0 0 0 1.21-9.2zm-5.1-10.1a3 3 0 0 1 1.1-4.12 3 3 0 0 1 4.1 1.11 3 3 0 0 1-1.1 4.11 3 3 0 0 1-4.1-1.1zm5.2 16a3 3 0 0 1-4.1 1.11 3 3 0 0 1-1.1-4.12 3 3 0 0 1 4.1-1.1 3 3 0 0 1 1.1 4.06z"}),props.children);});var Dashboard32=/*#__PURE__*/React.forwardRef(function Dashboard32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 21h2v5h-2zm-4-5h2v10h-2zm-9 10a5.006 5.006 0 0 1-5-5h2a3 3 0 1 0 3-3v-2a5 5 0 0 1 0 10z"}),React.createElement("path",{d:"M28 2H4a2.002 2.002 0 0 0-2 2v24a2.002 2.002 0 0 0 2 2h24a2.003 2.003 0 0 0 2-2V4a2.002 2.002 0 0 0-2-2zm0 9H14V4h14zM12 4v7H4V4zM4 28V13h24l.002 15z"}),props.children);});var Dashboard24=/*#__PURE__*/React.forwardRef(function Dashboard24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 21h2v5h-2zm-4-5h2v10h-2zm-9 10a5.006 5.006 0 0 1-5-5h2a3 3 0 1 0 3-3v-2a5 5 0 0 1 0 10z"}),React.createElement("path",{d:"M28 2H4a2.002 2.002 0 0 0-2 2v24a2.002 2.002 0 0 0 2 2h24a2.003 2.003 0 0 0 2-2V4a2.002 2.002 0 0 0-2-2zm0 9H14V4h14zM12 4v7H4V4zM4 28V13h24l.002 15z"}),props.children);});var Dashboard20=/*#__PURE__*/React.forwardRef(function Dashboard20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 21h2v5h-2zm-4-5h2v10h-2zm-9 10a5.006 5.006 0 0 1-5-5h2a3 3 0 1 0 3-3v-2a5 5 0 0 1 0 10z"}),React.createElement("path",{d:"M28 2H4a2.002 2.002 0 0 0-2 2v24a2.002 2.002 0 0 0 2 2h24a2.003 2.003 0 0 0 2-2V4a2.002 2.002 0 0 0-2-2zm0 9H14V4h14zM12 4v7H4V4zM4 28V13h24l.002 15z"}),props.children);});var Dashboard16=/*#__PURE__*/React.forwardRef(function Dashboard16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 21h2v5h-2zm-4-5h2v10h-2zm-9 10a5.006 5.006 0 0 1-5-5h2a3 3 0 1 0 3-3v-2a5 5 0 0 1 0 10z"}),React.createElement("path",{d:"M28 2H4a2.002 2.002 0 0 0-2 2v24a2.002 2.002 0 0 0 2 2h24a2.003 2.003 0 0 0 2-2V4a2.002 2.002 0 0 0-2-2zm0 9H14V4h14zM12 4v7H4V4zM4 28V13h24l.002 15z"}),props.children);});var Data_132=/*#__PURE__*/React.forwardRef(function Data_132(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 6h13v2H15zm0 18h13v2H15zM4 15h13v2H4zm3-4a4 4 0 1 1 4-4 4 4 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2 2 0 0 0-2-2zm0 24a4 4 0 1 1 4-4 4 4 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2 2 0 0 0-2-2zm18-3a4 4 0 1 1 4-4 4 4 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2 2 0 0 0-2-2z"}),props.children);});var Data_124=/*#__PURE__*/React.forwardRef(function Data_124(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 6h13v2H15zm0 18h13v2H15zM4 15h13v2H4zm3-4a4 4 0 1 1 4-4 4 4 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2 2 0 0 0-2-2zm0 24a4 4 0 1 1 4-4 4 4 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2 2 0 0 0-2-2zm18-3a4 4 0 1 1 4-4 4 4 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2 2 0 0 0-2-2z"}),props.children);});var Data_120=/*#__PURE__*/React.forwardRef(function Data_120(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 6h13v2H15zm0 18h13v2H15zM4 15h13v2H4zm3-4a4 4 0 1 1 4-4 4 4 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2 2 0 0 0-2-2zm0 24a4 4 0 1 1 4-4 4 4 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2 2 0 0 0-2-2zm18-3a4 4 0 1 1 4-4 4 4 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2 2 0 0 0-2-2z"}),props.children);});var Data_116=/*#__PURE__*/React.forwardRef(function Data_116(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 6h13v2H15zm0 18h13v2H15zM4 15h13v2H4zm3-4a4 4 0 1 1 4-4 4 4 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2 2 0 0 0-2-2zm0 24a4 4 0 1 1 4-4 4 4 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2 2 0 0 0-2-2zm18-3a4 4 0 1 1 4-4 4 4 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2 2 0 0 0-2-2z"}),props.children);});var Data_232=/*#__PURE__*/React.forwardRef(function Data_232(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4 6h11v2H4zm14 0h10v2H18zm3 6h7v2h-7zm-10 0h7v2h-7zm-7 0h4v2H4zm0 6h24v2H4zm0 6h17v2H4zm20 0h4v2h-4z"}),props.children);});var Data_224=/*#__PURE__*/React.forwardRef(function Data_224(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4 6h11v2H4zm14 0h10v2H18zm3 6h7v2h-7zm-10 0h7v2h-7zm-7 0h4v2H4zm0 6h24v2H4zm0 6h17v2H4zm20 0h4v2h-4z"}),props.children);});var Data_220=/*#__PURE__*/React.forwardRef(function Data_220(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4 6h11v2H4zm14 0h10v2H18zm3 6h7v2h-7zm-10 0h7v2h-7zm-7 0h4v2H4zm0 6h24v2H4zm0 6h17v2H4zm20 0h4v2h-4z"}),props.children);});var Data_216=/*#__PURE__*/React.forwardRef(function Data_216(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4 6h11v2H4zm14 0h10v2H18zm3 6h7v2h-7zm-10 0h7v2h-7zm-7 0h4v2H4zm0 6h24v2H4zm0 6h17v2H4zm20 0h4v2h-4z"}),props.children);});var DataBase32=/*#__PURE__*/React.forwardRef(function DataBase32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 3H8a2 2 0 0 0-2 2v22a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V5a2 2 0 0 0-2-2zm0 2v6H8V5zM8 19v-6h16v6zm0 8v-6h16v6z"}),React.createElement("circle",{cx:"11",cy:"8",r:"1"}),React.createElement("circle",{cx:"11",cy:"16",r:"1"}),React.createElement("circle",{cx:"11",cy:"24",r:"1"}),props.children);});var DataBase24=/*#__PURE__*/React.forwardRef(function DataBase24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 3H8a2 2 0 0 0-2 2v22a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V5a2 2 0 0 0-2-2zm0 2v6H8V5zM8 19v-6h16v6zm0 8v-6h16v6z"}),React.createElement("circle",{cx:"11",cy:"8",r:"1"}),React.createElement("circle",{cx:"11",cy:"16",r:"1"}),React.createElement("circle",{cx:"11",cy:"24",r:"1"}),props.children);});var DataBase20=/*#__PURE__*/React.forwardRef(function DataBase20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 3H8a2 2 0 0 0-2 2v22a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V5a2 2 0 0 0-2-2zm0 2v6H8V5zM8 19v-6h16v6zm0 8v-6h16v6z"}),React.createElement("circle",{cx:"11",cy:"8",r:"1"}),React.createElement("circle",{cx:"11",cy:"16",r:"1"}),React.createElement("circle",{cx:"11",cy:"24",r:"1"}),props.children);});var DataBase16=/*#__PURE__*/React.forwardRef(function DataBase16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 3H8a2 2 0 0 0-2 2v22a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V5a2 2 0 0 0-2-2zm0 2v6H8V5zM8 19v-6h16v6zm0 8v-6h16v6z"}),React.createElement("circle",{cx:"11",cy:"8",r:"1"}),React.createElement("circle",{cx:"11",cy:"16",r:"1"}),React.createElement("circle",{cx:"11",cy:"24",r:"1"}),props.children);});var DataCheck32=/*#__PURE__*/React.forwardRef(function DataCheck32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 27.18l-2.59-2.59L19 26l4 4 7-7-1.41-1.41L23 27.18z"}),React.createElement("circle",{cx:"11",cy:"8",r:"1"}),React.createElement("circle",{cx:"11",cy:"16",r:"1"}),React.createElement("circle",{cx:"11",cy:"24",r:"1"}),React.createElement("path",{d:"M24 3H8a2 2 0 0 0-2 2v22a2 2 0 0 0 2 2h8v-2H8v-6h18V5a2 2 0 0 0-2-2zm0 16H8v-6h16zm0-8H8V5h16z"}),props.children);});var DataCheck24=/*#__PURE__*/React.forwardRef(function DataCheck24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 27.18l-2.59-2.59L19 26l4 4 7-7-1.41-1.41L23 27.18z"}),React.createElement("circle",{cx:"11",cy:"8",r:"1"}),React.createElement("circle",{cx:"11",cy:"16",r:"1"}),React.createElement("circle",{cx:"11",cy:"24",r:"1"}),React.createElement("path",{d:"M24 3H8a2 2 0 0 0-2 2v22a2 2 0 0 0 2 2h8v-2H8v-6h18V5a2 2 0 0 0-2-2zm0 16H8v-6h16zm0-8H8V5h16z"}),props.children);});var DataCheck20=/*#__PURE__*/React.forwardRef(function DataCheck20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 27.18l-2.59-2.59L19 26l4 4 7-7-1.41-1.41L23 27.18z"}),React.createElement("circle",{cx:"11",cy:"8",r:"1"}),React.createElement("circle",{cx:"11",cy:"16",r:"1"}),React.createElement("circle",{cx:"11",cy:"24",r:"1"}),React.createElement("path",{d:"M24 3H8a2 2 0 0 0-2 2v22a2 2 0 0 0 2 2h8v-2H8v-6h18V5a2 2 0 0 0-2-2zm0 16H8v-6h16zm0-8H8V5h16z"}),props.children);});var DataCheck16=/*#__PURE__*/React.forwardRef(function DataCheck16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 27.18l-2.59-2.59L19 26l4 4 7-7-1.41-1.41L23 27.18z"}),React.createElement("circle",{cx:"11",cy:"8",r:"1"}),React.createElement("circle",{cx:"11",cy:"16",r:"1"}),React.createElement("circle",{cx:"11",cy:"24",r:"1"}),React.createElement("path",{d:"M24 3H8a2 2 0 0 0-2 2v22a2 2 0 0 0 2 2h8v-2H8v-6h18V5a2 2 0 0 0-2-2zm0 16H8v-6h16zm0-8H8V5h16z"}),props.children);});var DataConnected32=/*#__PURE__*/React.forwardRef(function DataConnected32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 30h-6v-2h4V4h-4V2h6v28z"}),React.createElement("path",{d:"M24.91 19.59a4.51 4.51 0 0 0-2.66-3.24 4.55 4.55 0 0 0-3.5 0 4.94 4.94 0 0 0-.64.35l-2.81-2.81a4.53 4.53 0 1 0-1.41 1.41l2.81 2.81a4.48 4.48 0 0 0-.61 3.3 4.51 4.51 0 0 0 2.66 3.24 4.55 4.55 0 0 0 3.5 0 4.51 4.51 0 0 0 2.66-3.24 4.65 4.65 0 0 0 0-1.82zM11.5 14a2.5 2.5 0 1 1 2.5-2.5 2.5 2.5 0 0 1-2.5 2.5z"}),React.createElement("path",{d:"M8 30H2V2h6v2H4v24h4v2z"}),props.children);});var DataConnected24=/*#__PURE__*/React.forwardRef(function DataConnected24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 30h-6v-2h4V4h-4V2h6v28z"}),React.createElement("path",{d:"M24.91 19.59a4.51 4.51 0 0 0-2.66-3.24 4.55 4.55 0 0 0-3.5 0 4.94 4.94 0 0 0-.64.35l-2.81-2.81a4.53 4.53 0 1 0-1.41 1.41l2.81 2.81a4.48 4.48 0 0 0-.61 3.3 4.51 4.51 0 0 0 2.66 3.24 4.55 4.55 0 0 0 3.5 0 4.51 4.51 0 0 0 2.66-3.24 4.65 4.65 0 0 0 0-1.82zM11.5 14a2.5 2.5 0 1 1 2.5-2.5 2.5 2.5 0 0 1-2.5 2.5z"}),React.createElement("path",{d:"M8 30H2V2h6v2H4v24h4v2z"}),props.children);});var DataConnected20=/*#__PURE__*/React.forwardRef(function DataConnected20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 30h-6v-2h4V4h-4V2h6v28z"}),React.createElement("path",{d:"M24.91 19.59a4.51 4.51 0 0 0-2.66-3.24 4.55 4.55 0 0 0-3.5 0 4.94 4.94 0 0 0-.64.35l-2.81-2.81a4.53 4.53 0 1 0-1.41 1.41l2.81 2.81a4.48 4.48 0 0 0-.61 3.3 4.51 4.51 0 0 0 2.66 3.24 4.55 4.55 0 0 0 3.5 0 4.51 4.51 0 0 0 2.66-3.24 4.65 4.65 0 0 0 0-1.82zM11.5 14a2.5 2.5 0 1 1 2.5-2.5 2.5 2.5 0 0 1-2.5 2.5z"}),React.createElement("path",{d:"M8 30H2V2h6v2H4v24h4v2z"}),props.children);});var DataConnected16=/*#__PURE__*/React.forwardRef(function DataConnected16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 30h-6v-2h4V4h-4V2h6v28z"}),React.createElement("path",{d:"M24.91 19.59a4.51 4.51 0 0 0-2.66-3.24 4.55 4.55 0 0 0-3.5 0 4.94 4.94 0 0 0-.64.35l-2.81-2.81a4.53 4.53 0 1 0-1.41 1.41l2.81 2.81a4.48 4.48 0 0 0-.61 3.3 4.51 4.51 0 0 0 2.66 3.24 4.55 4.55 0 0 0 3.5 0 4.51 4.51 0 0 0 2.66-3.24 4.65 4.65 0 0 0 0-1.82zM11.5 14a2.5 2.5 0 1 1 2.5-2.5 2.5 2.5 0 0 1-2.5 2.5z"}),React.createElement("path",{d:"M8 30H2V2h6v2H4v24h4v2z"}),props.children);});var DataError32=/*#__PURE__*/React.forwardRef(function DataError32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"11",cy:"8",r:"1"}),React.createElement("circle",{cx:"11",cy:"16",r:"1"}),React.createElement("circle",{cx:"11",cy:"24",r:"1"}),React.createElement("path",{d:"M24 3H8a2 2 0 0 0-2 2v22a2 2 0 0 0 2 2h8v-2H8v-6h18V5a2 2 0 0 0-2-2zm0 16H8v-6h16zm0-8H8V5h16z"}),React.createElement("path",{d:"M29.24 29.58l-2.83-2.83 2.83-2.83-1.41-1.41L25 25.33l-2.83-2.82-1.41 1.41 2.83 2.83-2.83 2.83 1.41 1.41L25 28.16l2.83 2.83 1.41-1.41z"}),props.children);});var DataError24=/*#__PURE__*/React.forwardRef(function DataError24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"11",cy:"8",r:"1"}),React.createElement("circle",{cx:"11",cy:"16",r:"1"}),React.createElement("circle",{cx:"11",cy:"24",r:"1"}),React.createElement("path",{d:"M24 3H8a2 2 0 0 0-2 2v22a2 2 0 0 0 2 2h8v-2H8v-6h18V5a2 2 0 0 0-2-2zm0 16H8v-6h16zm0-8H8V5h16z"}),React.createElement("path",{d:"M29.24 29.58l-2.83-2.83 2.83-2.83-1.41-1.41L25 25.33l-2.83-2.82-1.41 1.41 2.83 2.83-2.83 2.83 1.41 1.41L25 28.16l2.83 2.83 1.41-1.41z"}),props.children);});var DataError20=/*#__PURE__*/React.forwardRef(function DataError20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"11",cy:"8",r:"1"}),React.createElement("circle",{cx:"11",cy:"16",r:"1"}),React.createElement("circle",{cx:"11",cy:"24",r:"1"}),React.createElement("path",{d:"M24 3H8a2 2 0 0 0-2 2v22a2 2 0 0 0 2 2h8v-2H8v-6h18V5a2 2 0 0 0-2-2zm0 16H8v-6h16zm0-8H8V5h16z"}),React.createElement("path",{d:"M29.24 29.58l-2.83-2.83 2.83-2.83-1.41-1.41L25 25.33l-2.83-2.82-1.41 1.41 2.83 2.83-2.83 2.83 1.41 1.41L25 28.16l2.83 2.83 1.41-1.41z"}),props.children);});var DataError16=/*#__PURE__*/React.forwardRef(function DataError16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"11",cy:"8",r:"1"}),React.createElement("circle",{cx:"11",cy:"16",r:"1"}),React.createElement("circle",{cx:"11",cy:"24",r:"1"}),React.createElement("path",{d:"M24 3H8a2 2 0 0 0-2 2v22a2 2 0 0 0 2 2h8v-2H8v-6h18V5a2 2 0 0 0-2-2zm0 16H8v-6h16zm0-8H8V5h16z"}),React.createElement("path",{d:"M29.24 29.58l-2.83-2.83 2.83-2.83-1.41-1.41L25 25.33l-2.83-2.82-1.41 1.41 2.83 2.83-2.83 2.83 1.41 1.41L25 28.16l2.83 2.83 1.41-1.41z"}),props.children);});var DataReference32=/*#__PURE__*/React.forwardRef(function DataReference32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 13V4h-2v2h-3v2h3v5h-3v2h8v-2h-3zM8.5 6A3.5 3.5 0 1 1 5 9.5 3.504 3.504 0 0 1 8.5 6m0-2A5.5 5.5 0 1 0 14 9.5 5.5 5.5 0 0 0 8.5 4zm15 16a3.5 3.5 0 1 1-3.5 3.5 3.504 3.504 0 0 1 3.5-3.5m0-2a5.5 5.5 0 1 0 5.5 5.5 5.5 5.5 0 0 0-5.5-5.5zM6 19v2h3.586L4 26.586 5.414 28 11 22.414V26h2v-7H6z"}),props.children);});var DataReference24=/*#__PURE__*/React.forwardRef(function DataReference24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 13V4h-2v2h-3v2h3v5h-3v2h8v-2h-3zM8.5 6A3.5 3.5 0 1 1 5 9.5 3.504 3.504 0 0 1 8.5 6m0-2A5.5 5.5 0 1 0 14 9.5 5.5 5.5 0 0 0 8.5 4zm15 16a3.5 3.5 0 1 1-3.5 3.5 3.504 3.504 0 0 1 3.5-3.5m0-2a5.5 5.5 0 1 0 5.5 5.5 5.5 5.5 0 0 0-5.5-5.5zM6 19v2h3.586L4 26.586 5.414 28 11 22.414V26h2v-7H6z"}),props.children);});var DataReference20=/*#__PURE__*/React.forwardRef(function DataReference20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 13V4h-2v2h-3v2h3v5h-3v2h8v-2h-3zM8.5 6A3.5 3.5 0 1 1 5 9.5 3.504 3.504 0 0 1 8.5 6m0-2A5.5 5.5 0 1 0 14 9.5 5.5 5.5 0 0 0 8.5 4zm15 16a3.5 3.5 0 1 1-3.5 3.5 3.504 3.504 0 0 1 3.5-3.5m0-2a5.5 5.5 0 1 0 5.5 5.5 5.5 5.5 0 0 0-5.5-5.5zM6 19v2h3.586L4 26.586 5.414 28 11 22.414V26h2v-7H6z"}),props.children);});var DataReference16=/*#__PURE__*/React.forwardRef(function DataReference16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 13V4h-2v2h-3v2h3v5h-3v2h8v-2h-3zM8.5 6A3.5 3.5 0 1 1 5 9.5 3.504 3.504 0 0 1 8.5 6m0-2A5.5 5.5 0 1 0 14 9.5 5.5 5.5 0 0 0 8.5 4zm15 16a3.5 3.5 0 1 1-3.5 3.5 3.504 3.504 0 0 1 3.5-3.5m0-2a5.5 5.5 0 1 0 5.5 5.5 5.5 5.5 0 0 0-5.5-5.5zM6 19v2h3.586L4 26.586 5.414 28 11 22.414V26h2v-7H6z"}),props.children);});var DataSet32=/*#__PURE__*/React.forwardRef(function DataSet32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 13V4h-2v2h-3v2h3v5h-3v2h8v-2h-3zM8.5 6A3.5 3.5 0 1 1 5 9.5 3.5 3.5 0 0 1 8.5 6m0-2A5.5 5.5 0 1 0 14 9.5 5.5 5.5 0 0 0 8.5 4zm0 16A3.5 3.5 0 1 1 5 23.5 3.5 3.5 0 0 1 8.5 20m0-2a5.5 5.5 0 1 0 5.5 5.5A5.5 5.5 0 0 0 8.5 18zm15 2a3.5 3.5 0 1 1-3.5 3.5 3.5 3.5 0 0 1 3.5-3.5m0-2a5.5 5.5 0 1 0 5.5 5.5 5.5 5.5 0 0 0-5.5-5.5z"}),props.children);});var DataSet24=/*#__PURE__*/React.forwardRef(function DataSet24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 13V4h-2v2h-3v2h3v5h-3v2h8v-2h-3zM8.5 6A3.5 3.5 0 1 1 5 9.5 3.5 3.5 0 0 1 8.5 6m0-2A5.5 5.5 0 1 0 14 9.5 5.5 5.5 0 0 0 8.5 4zm0 16A3.5 3.5 0 1 1 5 23.5 3.5 3.5 0 0 1 8.5 20m0-2a5.5 5.5 0 1 0 5.5 5.5A5.5 5.5 0 0 0 8.5 18zm15 2a3.5 3.5 0 1 1-3.5 3.5 3.5 3.5 0 0 1 3.5-3.5m0-2a5.5 5.5 0 1 0 5.5 5.5 5.5 5.5 0 0 0-5.5-5.5z"}),props.children);});var DataSet20=/*#__PURE__*/React.forwardRef(function DataSet20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 13V4h-2v2h-3v2h3v5h-3v2h8v-2h-3zM8.5 6A3.5 3.5 0 1 1 5 9.5 3.5 3.5 0 0 1 8.5 6m0-2A5.5 5.5 0 1 0 14 9.5 5.5 5.5 0 0 0 8.5 4zm0 16A3.5 3.5 0 1 1 5 23.5 3.5 3.5 0 0 1 8.5 20m0-2a5.5 5.5 0 1 0 5.5 5.5A5.5 5.5 0 0 0 8.5 18zm15 2a3.5 3.5 0 1 1-3.5 3.5 3.5 3.5 0 0 1 3.5-3.5m0-2a5.5 5.5 0 1 0 5.5 5.5 5.5 5.5 0 0 0-5.5-5.5z"}),props.children);});var DataSet16=/*#__PURE__*/React.forwardRef(function DataSet16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 13V4h-2v2h-3v2h3v5h-3v2h8v-2h-3zM8.5 6A3.5 3.5 0 1 1 5 9.5 3.5 3.5 0 0 1 8.5 6m0-2A5.5 5.5 0 1 0 14 9.5 5.5 5.5 0 0 0 8.5 4zm0 16A3.5 3.5 0 1 1 5 23.5 3.5 3.5 0 0 1 8.5 20m0-2a5.5 5.5 0 1 0 5.5 5.5A5.5 5.5 0 0 0 8.5 18zm15 2a3.5 3.5 0 1 1-3.5 3.5 3.5 3.5 0 0 1 3.5-3.5m0-2a5.5 5.5 0 1 0 5.5 5.5 5.5 5.5 0 0 0-5.5-5.5z"}),props.children);});var DataStructured32=/*#__PURE__*/React.forwardRef(function DataStructured32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"9",cy:"7",r:"1"}),React.createElement("path",{d:"M27 22.14V18a2 2 0 0 0-2-2h-8v-4h9a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h9v4H7a2 2 0 0 0-2 2v4.14a4 4 0 1 0 2 0V18h8v4h-3v8h8v-8h-3v-4h8v4.14a4 4 0 1 0 2 0zM8 26a2 2 0 1 1-2-2 2 2 0 0 1 2 2zm10-2v4h-4v-4zM6 10V4h20v6zm20 18a2 2 0 1 1 2-2 2 2 0 0 1-2 2z"}),props.children);});var DataStructured24=/*#__PURE__*/React.forwardRef(function DataStructured24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"9",cy:"7",r:"1"}),React.createElement("path",{d:"M27 22.14V18a2 2 0 0 0-2-2h-8v-4h9a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h9v4H7a2 2 0 0 0-2 2v4.14a4 4 0 1 0 2 0V18h8v4h-3v8h8v-8h-3v-4h8v4.14a4 4 0 1 0 2 0zM8 26a2 2 0 1 1-2-2 2 2 0 0 1 2 2zm10-2v4h-4v-4zM6 10V4h20v6zm20 18a2 2 0 1 1 2-2 2 2 0 0 1-2 2z"}),props.children);});var DataStructured20=/*#__PURE__*/React.forwardRef(function DataStructured20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"9",cy:"7",r:"1"}),React.createElement("path",{d:"M27 22.14V18a2 2 0 0 0-2-2h-8v-4h9a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h9v4H7a2 2 0 0 0-2 2v4.14a4 4 0 1 0 2 0V18h8v4h-3v8h8v-8h-3v-4h8v4.14a4 4 0 1 0 2 0zM8 26a2 2 0 1 1-2-2 2 2 0 0 1 2 2zm10-2v4h-4v-4zM6 10V4h20v6zm20 18a2 2 0 1 1 2-2 2 2 0 0 1-2 2z"}),props.children);});var DataStructured16=/*#__PURE__*/React.forwardRef(function DataStructured16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"9",cy:"7",r:"1"}),React.createElement("path",{d:"M27 22.14V18a2 2 0 0 0-2-2h-8v-4h9a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h9v4H7a2 2 0 0 0-2 2v4.14a4 4 0 1 0 2 0V18h8v4h-3v8h8v-8h-3v-4h8v4.14a4 4 0 1 0 2 0zM8 26a2 2 0 1 1-2-2 2 2 0 0 1 2 2zm10-2v4h-4v-4zM6 10V4h20v6zm20 18a2 2 0 1 1 2-2 2 2 0 0 1-2 2z"}),props.children);});var DataUnstructured32=/*#__PURE__*/React.forwardRef(function DataUnstructured32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6 24a2 2 0 1 1-2 2 2 2 0 0 1 2-2m0-2a4 4 0 1 0 4 4 4 4 0 0 0-4-4zM16 4a2 2 0 1 1-2 2 2 2 0 0 1 2-2m0-2a4 4 0 1 0 4 4 4 4 0 0 0-4-4zm10 2a2 2 0 1 1-2 2 2 2 0 0 1 2-2m0-2a4 4 0 1 0 4 4 4 4 0 0 0-4-4zm-8 22v4h-4v-4h4m2-2h-8v8h8z"}),React.createElement("path",{d:"M27 22.14V17a2 2 0 0 0-2-2H7v-5h3V2H2v8h3v5a2 2 0 0 0 2 2h18v5.14a4 4 0 1 0 2 0zM4 4h4v4H4zm22 24a2 2 0 1 1 2-2 2 2 0 0 1-2 2z"}),props.children);});var DataUnstructured24=/*#__PURE__*/React.forwardRef(function DataUnstructured24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6 24a2 2 0 1 1-2 2 2 2 0 0 1 2-2m0-2a4 4 0 1 0 4 4 4 4 0 0 0-4-4zM16 4a2 2 0 1 1-2 2 2 2 0 0 1 2-2m0-2a4 4 0 1 0 4 4 4 4 0 0 0-4-4zm10 2a2 2 0 1 1-2 2 2 2 0 0 1 2-2m0-2a4 4 0 1 0 4 4 4 4 0 0 0-4-4zm-8 22v4h-4v-4h4m2-2h-8v8h8z"}),React.createElement("path",{d:"M27 22.14V17a2 2 0 0 0-2-2H7v-5h3V2H2v8h3v5a2 2 0 0 0 2 2h18v5.14a4 4 0 1 0 2 0zM4 4h4v4H4zm22 24a2 2 0 1 1 2-2 2 2 0 0 1-2 2z"}),props.children);});var DataUnstructured20=/*#__PURE__*/React.forwardRef(function DataUnstructured20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6 24a2 2 0 1 1-2 2 2 2 0 0 1 2-2m0-2a4 4 0 1 0 4 4 4 4 0 0 0-4-4zM16 4a2 2 0 1 1-2 2 2 2 0 0 1 2-2m0-2a4 4 0 1 0 4 4 4 4 0 0 0-4-4zm10 2a2 2 0 1 1-2 2 2 2 0 0 1 2-2m0-2a4 4 0 1 0 4 4 4 4 0 0 0-4-4zm-8 22v4h-4v-4h4m2-2h-8v8h8z"}),React.createElement("path",{d:"M27 22.14V17a2 2 0 0 0-2-2H7v-5h3V2H2v8h3v5a2 2 0 0 0 2 2h18v5.14a4 4 0 1 0 2 0zM4 4h4v4H4zm22 24a2 2 0 1 1 2-2 2 2 0 0 1-2 2z"}),props.children);});var DataUnstructured16=/*#__PURE__*/React.forwardRef(function DataUnstructured16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6 24a2 2 0 1 1-2 2 2 2 0 0 1 2-2m0-2a4 4 0 1 0 4 4 4 4 0 0 0-4-4zM16 4a2 2 0 1 1-2 2 2 2 0 0 1 2-2m0-2a4 4 0 1 0 4 4 4 4 0 0 0-4-4zm10 2a2 2 0 1 1-2 2 2 2 0 0 1 2-2m0-2a4 4 0 1 0 4 4 4 4 0 0 0-4-4zm-8 22v4h-4v-4h4m2-2h-8v8h8z"}),React.createElement("path",{d:"M27 22.14V17a2 2 0 0 0-2-2H7v-5h3V2H2v8h3v5a2 2 0 0 0 2 2h18v5.14a4 4 0 1 0 2 0zM4 4h4v4H4zm22 24a2 2 0 1 1 2-2 2 2 0 0 1-2 2z"}),props.children);});var DataShare32=/*#__PURE__*/React.forwardRef(function DataShare32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M5 25v-9.172l-3.586 3.586L0 18l6-6 6 6-1.414 1.414L7 15.828V25h12v2H7a2.002 2.002 0 0 1-2-2zm19-3h4a2.002 2.002 0 0 1 2 2v4a2.002 2.002 0 0 1-2 2h-4a2.002 2.002 0 0 1-2-2v-4a2.002 2.002 0 0 1 2-2zm4 6v-4h-4.002L24 28zM27 6v9.172l3.586-3.586L32 13l-6 6-6-6 1.414-1.414L25 15.172V6H13V4h12a2.002 2.002 0 0 1 2 2zM2 6h6v2H2zm0-4h8v2H2z"}),props.children);});var DataShare24=/*#__PURE__*/React.forwardRef(function DataShare24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M5 25v-9.172l-3.586 3.586L0 18l6-6 6 6-1.414 1.414L7 15.828V25h12v2H7a2.002 2.002 0 0 1-2-2zm19-3h4a2.002 2.002 0 0 1 2 2v4a2.002 2.002 0 0 1-2 2h-4a2.002 2.002 0 0 1-2-2v-4a2.002 2.002 0 0 1 2-2zm4 6v-4h-4.002L24 28zM27 6v9.172l3.586-3.586L32 13l-6 6-6-6 1.414-1.414L25 15.172V6H13V4h12a2.002 2.002 0 0 1 2 2zM2 6h6v2H2zm0-4h8v2H2z"}),props.children);});var DataShare20=/*#__PURE__*/React.forwardRef(function DataShare20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M5 25v-9.172l-3.586 3.586L0 18l6-6 6 6-1.414 1.414L7 15.828V25h12v2H7a2.002 2.002 0 0 1-2-2zm19-3h4a2.002 2.002 0 0 1 2 2v4a2.002 2.002 0 0 1-2 2h-4a2.002 2.002 0 0 1-2-2v-4a2.002 2.002 0 0 1 2-2zm4 6v-4h-4.002L24 28zM27 6v9.172l3.586-3.586L32 13l-6 6-6-6 1.414-1.414L25 15.172V6H13V4h12a2.002 2.002 0 0 1 2 2zM2 6h6v2H2zm0-4h8v2H2z"}),props.children);});var DataShare16=/*#__PURE__*/React.forwardRef(function DataShare16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M5 25v-9.172l-3.586 3.586L0 18l6-6 6 6-1.414 1.414L7 15.828V25h12v2H7a2.002 2.002 0 0 1-2-2zm19-3h4a2.002 2.002 0 0 1 2 2v4a2.002 2.002 0 0 1-2 2h-4a2.002 2.002 0 0 1-2-2v-4a2.002 2.002 0 0 1 2-2zm4 6v-4h-4.002L24 28zM27 6v9.172l3.586-3.586L32 13l-6 6-6-6 1.414-1.414L25 15.172V6H13V4h12a2.002 2.002 0 0 1 2 2zM2 6h6v2H2zm0-4h8v2H2z"}),props.children);});var DataVis_132=/*#__PURE__*/React.forwardRef(function DataVis_132(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 22a3.955 3.955 0 0 0-2.02.567l-3.813-3.814a4.965 4.965 0 0 0 0-5.506l2.547-2.547A3.028 3.028 0 1 0 21.3 9.286l-2.547 2.547a4.965 4.965 0 0 0-5.506 0L9.433 8.019A3.955 3.955 0 0 0 10 6a4 4 0 1 0-4 4 3.955 3.955 0 0 0 2.02-.567l3.813 3.814a4.965 4.965 0 0 0 0 5.506l-3.814 3.814A3.956 3.956 0 0 0 6 22a4 4 0 1 0 4 4 3.955 3.955 0 0 0-.567-2.02l3.814-3.813a4.969 4.969 0 0 0 1.753.732v3.285a3 3 0 1 0 2 0v-3.285a4.969 4.969 0 0 0 1.753-.732l3.814 3.814A3.955 3.955 0 0 0 22 26a4 4 0 1 0 4-4zm-10-9a3 3 0 1 1-3 3 3.003 3.003 0 0 1 3-3zM4 6a2 2 0 1 1 2 2 2.002 2.002 0 0 1-2-2zm2 22a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2zm20 0a2 2 0 1 1 2-2 2.003 2.003 0 0 1-2 2z"}),props.children);});var DataVis_124=/*#__PURE__*/React.forwardRef(function DataVis_124(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 22a3.955 3.955 0 0 0-2.02.567l-3.813-3.814a4.965 4.965 0 0 0 0-5.506l2.547-2.547A3.028 3.028 0 1 0 21.3 9.286l-2.547 2.547a4.965 4.965 0 0 0-5.506 0L9.433 8.019A3.955 3.955 0 0 0 10 6a4 4 0 1 0-4 4 3.955 3.955 0 0 0 2.02-.567l3.813 3.814a4.965 4.965 0 0 0 0 5.506l-3.814 3.814A3.956 3.956 0 0 0 6 22a4 4 0 1 0 4 4 3.955 3.955 0 0 0-.567-2.02l3.814-3.813a4.969 4.969 0 0 0 1.753.732v3.285a3 3 0 1 0 2 0v-3.285a4.969 4.969 0 0 0 1.753-.732l3.814 3.814A3.955 3.955 0 0 0 22 26a4 4 0 1 0 4-4zm-10-9a3 3 0 1 1-3 3 3.003 3.003 0 0 1 3-3zM4 6a2 2 0 1 1 2 2 2.002 2.002 0 0 1-2-2zm2 22a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2zm20 0a2 2 0 1 1 2-2 2.003 2.003 0 0 1-2 2z"}),props.children);});var DataVis_120=/*#__PURE__*/React.forwardRef(function DataVis_120(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 22a3.955 3.955 0 0 0-2.02.567l-3.813-3.814a4.965 4.965 0 0 0 0-5.506l2.547-2.547A3.028 3.028 0 1 0 21.3 9.286l-2.547 2.547a4.965 4.965 0 0 0-5.506 0L9.433 8.019A3.955 3.955 0 0 0 10 6a4 4 0 1 0-4 4 3.955 3.955 0 0 0 2.02-.567l3.813 3.814a4.965 4.965 0 0 0 0 5.506l-3.814 3.814A3.956 3.956 0 0 0 6 22a4 4 0 1 0 4 4 3.955 3.955 0 0 0-.567-2.02l3.814-3.813a4.969 4.969 0 0 0 1.753.732v3.285a3 3 0 1 0 2 0v-3.285a4.969 4.969 0 0 0 1.753-.732l3.814 3.814A3.955 3.955 0 0 0 22 26a4 4 0 1 0 4-4zm-10-9a3 3 0 1 1-3 3 3.003 3.003 0 0 1 3-3zM4 6a2 2 0 1 1 2 2 2.002 2.002 0 0 1-2-2zm2 22a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2zm20 0a2 2 0 1 1 2-2 2.003 2.003 0 0 1-2 2z"}),props.children);});var DataVis_116=/*#__PURE__*/React.forwardRef(function DataVis_116(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 22a3.955 3.955 0 0 0-2.02.567l-3.813-3.814a4.965 4.965 0 0 0 0-5.506l2.547-2.547A3.028 3.028 0 1 0 21.3 9.286l-2.547 2.547a4.965 4.965 0 0 0-5.506 0L9.433 8.019A3.955 3.955 0 0 0 10 6a4 4 0 1 0-4 4 3.955 3.955 0 0 0 2.02-.567l3.813 3.814a4.965 4.965 0 0 0 0 5.506l-3.814 3.814A3.956 3.956 0 0 0 6 22a4 4 0 1 0 4 4 3.955 3.955 0 0 0-.567-2.02l3.814-3.813a4.969 4.969 0 0 0 1.753.732v3.285a3 3 0 1 0 2 0v-3.285a4.969 4.969 0 0 0 1.753-.732l3.814 3.814A3.955 3.955 0 0 0 22 26a4 4 0 1 0 4-4zm-10-9a3 3 0 1 1-3 3 3.003 3.003 0 0 1 3-3zM4 6a2 2 0 1 1 2 2 2.002 2.002 0 0 1-2-2zm2 22a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2zm20 0a2 2 0 1 1 2-2 2.003 2.003 0 0 1-2 2z"}),props.children);});var DataVis_232=/*#__PURE__*/React.forwardRef(function DataVis_232(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 2H17a2.002 2.002 0 0 0-2 2v6H4a2.002 2.002 0 0 0-2 2v16a2.002 2.002 0 0 0 2 2h11a2.002 2.002 0 0 0 2-2v-6h11a2.003 2.003 0 0 0 2-2V4a2.002 2.002 0 0 0-2-2zm0 2v4H17V4zM15 22H4v-4h11zm2-12h11l.001 4H17zm-2 2v4H4v-4zM4 28v-4h11.001v4zm13-8v-4h11.002v4z"}),props.children);});var DataVis_224=/*#__PURE__*/React.forwardRef(function DataVis_224(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 2H17a2.002 2.002 0 0 0-2 2v6H4a2.002 2.002 0 0 0-2 2v16a2.002 2.002 0 0 0 2 2h11a2.002 2.002 0 0 0 2-2v-6h11a2.003 2.003 0 0 0 2-2V4a2.002 2.002 0 0 0-2-2zm0 2v4H17V4zM15 22H4v-4h11zm2-12h11l.001 4H17zm-2 2v4H4v-4zM4 28v-4h11.001v4zm13-8v-4h11.002v4z"}),props.children);});var DataVis_220=/*#__PURE__*/React.forwardRef(function DataVis_220(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 2H17a2.002 2.002 0 0 0-2 2v6H4a2.002 2.002 0 0 0-2 2v16a2.002 2.002 0 0 0 2 2h11a2.002 2.002 0 0 0 2-2v-6h11a2.003 2.003 0 0 0 2-2V4a2.002 2.002 0 0 0-2-2zm0 2v4H17V4zM15 22H4v-4h11zm2-12h11l.001 4H17zm-2 2v4H4v-4zM4 28v-4h11.001v4zm13-8v-4h11.002v4z"}),props.children);});var DataVis_216=/*#__PURE__*/React.forwardRef(function DataVis_216(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 2H17a2.002 2.002 0 0 0-2 2v6H4a2.002 2.002 0 0 0-2 2v16a2.002 2.002 0 0 0 2 2h11a2.002 2.002 0 0 0 2-2v-6h11a2.003 2.003 0 0 0 2-2V4a2.002 2.002 0 0 0-2-2zm0 2v4H17V4zM15 22H4v-4h11zm2-12h11l.001 4H17zm-2 2v4H4v-4zM4 28v-4h11.001v4zm13-8v-4h11.002v4z"}),props.children);});var DataVis_332=/*#__PURE__*/React.forwardRef(function DataVis_332(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 3a2.991 2.991 0 0 0-2.816 2h-3.326a3.98 3.98 0 0 0-7.716 0H9.858A3.992 3.992 0 1 0 5 9.858v4.284a3.98 3.98 0 0 0 0 7.716v3.326a3 3 0 1 0 2 0v-3.326a3.978 3.978 0 0 0 1.673-.903l3.364 1.682A2.963 2.963 0 0 0 12 23a3.012 3.012 0 1 0 .922-2.157l-3.148-1.574A3.95 3.95 0 0 0 10 18a3.996 3.996 0 0 0-3-3.858V9.858A3.995 3.995 0 0 0 9.858 7h4.284a3.937 3.937 0 0 0 4.782 2.882l1.811 3.17a3.045 3.045 0 1 0 1.733-.998L20.689 8.94A3.984 3.984 0 0 0 21.858 7h3.326A2.995 2.995 0 1 0 28 3zM8 18a2 2 0 1 1-2-2 2.002 2.002 0 0 1 2 2zM6 8a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2zm10-2a2 2 0 1 1 2 2 2.002 2.002 0 0 1-2-2z"}),props.children);});var DataVis_324=/*#__PURE__*/React.forwardRef(function DataVis_324(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 3a2.991 2.991 0 0 0-2.816 2h-3.326a3.98 3.98 0 0 0-7.716 0H9.858A3.992 3.992 0 1 0 5 9.858v4.284a3.98 3.98 0 0 0 0 7.716v3.326a3 3 0 1 0 2 0v-3.326a3.978 3.978 0 0 0 1.673-.903l3.364 1.682A2.963 2.963 0 0 0 12 23a3.012 3.012 0 1 0 .922-2.157l-3.148-1.574A3.95 3.95 0 0 0 10 18a3.996 3.996 0 0 0-3-3.858V9.858A3.995 3.995 0 0 0 9.858 7h4.284a3.937 3.937 0 0 0 4.782 2.882l1.811 3.17a3.045 3.045 0 1 0 1.733-.998L20.689 8.94A3.984 3.984 0 0 0 21.858 7h3.326A2.995 2.995 0 1 0 28 3zM8 18a2 2 0 1 1-2-2 2.002 2.002 0 0 1 2 2zM6 8a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2zm10-2a2 2 0 1 1 2 2 2.002 2.002 0 0 1-2-2z"}),props.children);});var DataVis_320=/*#__PURE__*/React.forwardRef(function DataVis_320(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 3a2.991 2.991 0 0 0-2.816 2h-3.326a3.98 3.98 0 0 0-7.716 0H9.858A3.992 3.992 0 1 0 5 9.858v4.284a3.98 3.98 0 0 0 0 7.716v3.326a3 3 0 1 0 2 0v-3.326a3.978 3.978 0 0 0 1.673-.903l3.364 1.682A2.963 2.963 0 0 0 12 23a3.012 3.012 0 1 0 .922-2.157l-3.148-1.574A3.95 3.95 0 0 0 10 18a3.996 3.996 0 0 0-3-3.858V9.858A3.995 3.995 0 0 0 9.858 7h4.284a3.937 3.937 0 0 0 4.782 2.882l1.811 3.17a3.045 3.045 0 1 0 1.733-.998L20.689 8.94A3.984 3.984 0 0 0 21.858 7h3.326A2.995 2.995 0 1 0 28 3zM8 18a2 2 0 1 1-2-2 2.002 2.002 0 0 1 2 2zM6 8a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2zm10-2a2 2 0 1 1 2 2 2.002 2.002 0 0 1-2-2z"}),props.children);});var DataVis_316=/*#__PURE__*/React.forwardRef(function DataVis_316(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 3a2.991 2.991 0 0 0-2.816 2h-3.326a3.98 3.98 0 0 0-7.716 0H9.858A3.992 3.992 0 1 0 5 9.858v4.284a3.98 3.98 0 0 0 0 7.716v3.326a3 3 0 1 0 2 0v-3.326a3.978 3.978 0 0 0 1.673-.903l3.364 1.682A2.963 2.963 0 0 0 12 23a3.012 3.012 0 1 0 .922-2.157l-3.148-1.574A3.95 3.95 0 0 0 10 18a3.996 3.996 0 0 0-3-3.858V9.858A3.995 3.995 0 0 0 9.858 7h4.284a3.937 3.937 0 0 0 4.782 2.882l1.811 3.17a3.045 3.045 0 1 0 1.733-.998L20.689 8.94A3.984 3.984 0 0 0 21.858 7h3.326A2.995 2.995 0 1 0 28 3zM8 18a2 2 0 1 1-2-2 2.002 2.002 0 0 1 2 2zM6 8a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2zm10-2a2 2 0 1 1 2 2 2.002 2.002 0 0 1-2-2z"}),props.children);});var DataVis_432=/*#__PURE__*/React.forwardRef(function DataVis_432(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27 3H5a2.002 2.002 0 0 0-2 2v22a2.002 2.002 0 0 0 2 2h22a2.003 2.003 0 0 0 2-2V5a2.002 2.002 0 0 0-2-2zm0 6H17V5h10zM15 27h-4v-4h4zm0-6h-4v-4h4zm-6 0H5v-4h4zm2-6v-4h10v4zm0-6V5h4v4zm12 2h4v4h-4zM9 5v10H5V5zM5 23h4v4H5zm12 4V17h10.001l.001 10z"}),props.children);});var DataVis_424=/*#__PURE__*/React.forwardRef(function DataVis_424(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27 3H5a2.002 2.002 0 0 0-2 2v22a2.002 2.002 0 0 0 2 2h22a2.003 2.003 0 0 0 2-2V5a2.002 2.002 0 0 0-2-2zm0 6H17V5h10zM15 27h-4v-4h4zm0-6h-4v-4h4zm-6 0H5v-4h4zm2-6v-4h10v4zm0-6V5h4v4zm12 2h4v4h-4zM9 5v10H5V5zM5 23h4v4H5zm12 4V17h10.001l.001 10z"}),props.children);});var DataVis_420=/*#__PURE__*/React.forwardRef(function DataVis_420(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27 3H5a2.002 2.002 0 0 0-2 2v22a2.002 2.002 0 0 0 2 2h22a2.003 2.003 0 0 0 2-2V5a2.002 2.002 0 0 0-2-2zm0 6H17V5h10zM15 27h-4v-4h4zm0-6h-4v-4h4zm-6 0H5v-4h4zm2-6v-4h10v4zm0-6V5h4v4zm12 2h4v4h-4zM9 5v10H5V5zM5 23h4v4H5zm12 4V17h10.001l.001 10z"}),props.children);});var DataVis_416=/*#__PURE__*/React.forwardRef(function DataVis_416(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27 3H5a2.002 2.002 0 0 0-2 2v22a2.002 2.002 0 0 0 2 2h22a2.003 2.003 0 0 0 2-2V5a2.002 2.002 0 0 0-2-2zm0 6H17V5h10zM15 27h-4v-4h4zm0-6h-4v-4h4zm-6 0H5v-4h4zm2-6v-4h10v4zm0-6V5h4v4zm12 2h4v4h-4zM9 5v10H5V5zM5 23h4v4H5zm12 4V17h10.001l.001 10z"}),props.children);});var Debug32=/*#__PURE__*/React.forwardRef(function Debug32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.83 20l.34-2-5.17-.85v-4.38l5.06-1.36-.51-1.93-4.83 1.29A9 9 0 0 0 20 5V2h-2v2.23a8.81 8.81 0 0 0-4 0V2h-2v3a9 9 0 0 0-4.71 5.82L2.46 9.48 2 11.41l5 1.36v4.38L1.84 18l.32 2L7 19.18a8.9 8.9 0 0 0 .82 3.57l-4.53 4.54 1.42 1.42 4.19-4.2a9 9 0 0 0 14.2 0l4.19 4.2 1.42-1.42-4.54-4.54a8.9 8.9 0 0 0 .83-3.57zM15 25.92A7 7 0 0 1 9 19v-6h6zM9.29 11a7 7 0 0 1 13.42 0zM23 19a7 7 0 0 1-6 6.92V13h6z"}),props.children);});var Debug24=/*#__PURE__*/React.forwardRef(function Debug24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.83 20l.34-2-5.17-.85v-4.38l5.06-1.36-.51-1.93-4.83 1.29A9 9 0 0 0 20 5V2h-2v2.23a8.81 8.81 0 0 0-4 0V2h-2v3a9 9 0 0 0-4.71 5.82L2.46 9.48 2 11.41l5 1.36v4.38L1.84 18l.32 2L7 19.18a8.9 8.9 0 0 0 .82 3.57l-4.53 4.54 1.42 1.42 4.19-4.2a9 9 0 0 0 14.2 0l4.19 4.2 1.42-1.42-4.54-4.54a8.9 8.9 0 0 0 .83-3.57zM15 25.92A7 7 0 0 1 9 19v-6h6zM9.29 11a7 7 0 0 1 13.42 0zM23 19a7 7 0 0 1-6 6.92V13h6z"}),props.children);});var Debug20=/*#__PURE__*/React.forwardRef(function Debug20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.83 20l.34-2-5.17-.85v-4.38l5.06-1.36-.51-1.93-4.83 1.29A9 9 0 0 0 20 5V2h-2v2.23a8.81 8.81 0 0 0-4 0V2h-2v3a9 9 0 0 0-4.71 5.82L2.46 9.48 2 11.41l5 1.36v4.38L1.84 18l.32 2L7 19.18a8.9 8.9 0 0 0 .82 3.57l-4.53 4.54 1.42 1.42 4.19-4.2a9 9 0 0 0 14.2 0l4.19 4.2 1.42-1.42-4.54-4.54a8.9 8.9 0 0 0 .83-3.57zM15 25.92A7 7 0 0 1 9 19v-6h6zM9.29 11a7 7 0 0 1 13.42 0zM23 19a7 7 0 0 1-6 6.92V13h6z"}),props.children);});var Debug16=/*#__PURE__*/React.forwardRef(function Debug16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.83 20l.34-2-5.17-.85v-4.38l5.06-1.36-.51-1.93-4.83 1.29A9 9 0 0 0 20 5V2h-2v2.23a8.81 8.81 0 0 0-4 0V2h-2v3a9 9 0 0 0-4.71 5.82L2.46 9.48 2 11.41l5 1.36v4.38L1.84 18l.32 2L7 19.18a8.9 8.9 0 0 0 .82 3.57l-4.53 4.54 1.42 1.42 4.19-4.2a9 9 0 0 0 14.2 0l4.19 4.2 1.42-1.42-4.54-4.54a8.9 8.9 0 0 0 .83-3.57zM15 25.92A7 7 0 0 1 9 19v-6h6zM9.29 11a7 7 0 0 1 13.42 0zM23 19a7 7 0 0 1-6 6.92V13h6z"}),props.children);});var Delete32=/*#__PURE__*/React.forwardRef(function Delete32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 12h2v12h-2zm6 0h2v12h-2z"}),React.createElement("path",{d:"M4 6v2h2v20a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V8h2V6zm4 22V8h16v20zm4-26h8v2h-8z"}),props.children);});var Delete24=/*#__PURE__*/React.forwardRef(function Delete24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 12h2v12h-2zm6 0h2v12h-2z"}),React.createElement("path",{d:"M4 6v2h2v20a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V8h2V6zm4 22V8h16v20zm4-26h8v2h-8z"}),props.children);});var Delete20=/*#__PURE__*/React.forwardRef(function Delete20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 12h2v12h-2zm6 0h2v12h-2z"}),React.createElement("path",{d:"M4 6v2h2v20a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V8h2V6zm4 22V8h16v20zm4-26h8v2h-8z"}),props.children);});var DeliveryTruck32=/*#__PURE__*/React.forwardRef(function DeliveryTruck32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.92 16.61l-3-7A1 1 0 0 0 26 9h-3V7a1 1 0 0 0-1-1H3a1 1 0 0 0-1 1v17a1 1 0 0 0 1 1h2.14a4 4 0 0 0 7.72 0h6.28a4 4 0 0 0 7.72 0H29a1 1 0 0 0 1-1v-7a1 1 0 0 0-.08-.39zM23 11h2.34l2.14 5H23zM9 26a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm10.14-3h-6.28a4 4 0 0 0-7.72 0H4V8h17v12.56A4 4 0 0 0 19.14 23zM23 26a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm5-3h-1.14A4 4 0 0 0 23 20v-2h5z"}),props.children);});var DeliveryTruck24=/*#__PURE__*/React.forwardRef(function DeliveryTruck24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.92 16.61l-3-7A1 1 0 0 0 26 9h-3V7a1 1 0 0 0-1-1H3a1 1 0 0 0-1 1v17a1 1 0 0 0 1 1h2.14a4 4 0 0 0 7.72 0h6.28a4 4 0 0 0 7.72 0H29a1 1 0 0 0 1-1v-7a1 1 0 0 0-.08-.39zM23 11h2.34l2.14 5H23zM9 26a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm10.14-3h-6.28a4 4 0 0 0-7.72 0H4V8h17v12.56A4 4 0 0 0 19.14 23zM23 26a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm5-3h-1.14A4 4 0 0 0 23 20v-2h5z"}),props.children);});var DeliveryTruck20=/*#__PURE__*/React.forwardRef(function DeliveryTruck20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.92 16.61l-3-7A1 1 0 0 0 26 9h-3V7a1 1 0 0 0-1-1H3a1 1 0 0 0-1 1v17a1 1 0 0 0 1 1h2.14a4 4 0 0 0 7.72 0h6.28a4 4 0 0 0 7.72 0H29a1 1 0 0 0 1-1v-7a1 1 0 0 0-.08-.39zM23 11h2.34l2.14 5H23zM9 26a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm10.14-3h-6.28a4 4 0 0 0-7.72 0H4V8h17v12.56A4 4 0 0 0 19.14 23zM23 26a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm5-3h-1.14A4 4 0 0 0 23 20v-2h5z"}),props.children);});var DeliveryTruck16=/*#__PURE__*/React.forwardRef(function DeliveryTruck16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.92 16.61l-3-7A1 1 0 0 0 26 9h-3V7a1 1 0 0 0-1-1H3a1 1 0 0 0-1 1v17a1 1 0 0 0 1 1h2.14a4 4 0 0 0 7.72 0h6.28a4 4 0 0 0 7.72 0H29a1 1 0 0 0 1-1v-7a1 1 0 0 0-.08-.39zM23 11h2.34l2.14 5H23zM9 26a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm10.14-3h-6.28a4 4 0 0 0-7.72 0H4V8h17v12.56A4 4 0 0 0 19.14 23zM23 26a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm5-3h-1.14A4 4 0 0 0 23 20v-2h5z"}),props.children);});var Departure32=/*#__PURE__*/React.forwardRef(function Departure32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2 28h28v2H2zM13.48 5.15l5.69 8.14.8 1.15 1.35-.36 4.52-1.21a2.13 2.13 0 0 1 1.12 0A1.84 1.84 0 0 1 28.23 14 1.87 1.87 0 0 1 27 16.45l-18.71 5a1.78 1.78 0 0 1-1 0A1.87 1.87 0 0 1 6 20.12l-.25-.93L5 16.38l-.74-2.74 1.44-.39 2.3 3.1.81 1.08 1.31-.35 2.8-.75 1.94-.52-.52-1.93-2.26-8.36 1.4-.37M14.16 3a1.06 1.06 0 0 0-.5 0l-3.09.83A1 1 0 0 0 9.89 5l2.5 9.36-2.81.75-2.73-3.61a1 1 0 0 0-.52-.36 1.06 1.06 0 0 0-.5 0L2.72 12A1 1 0 0 0 2 13.16l1 3.74.75 2.8.25.94a3.87 3.87 0 0 0 2.74 2.74 3.91 3.91 0 0 0 2 0l18.7-5a3.84 3.84 0 0 0 0-7.44 4.27 4.27 0 0 0-2.16 0l-4.51 1.21-6.07-8.74a1 1 0 0 0-.54-.41z"}),props.children);});var Departure24=/*#__PURE__*/React.forwardRef(function Departure24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2 28h28v2H2zM13.48 5.15l5.69 8.14.8 1.15 1.35-.36 4.52-1.21a2.13 2.13 0 0 1 1.12 0A1.84 1.84 0 0 1 28.23 14 1.87 1.87 0 0 1 27 16.45l-18.71 5a1.78 1.78 0 0 1-1 0A1.87 1.87 0 0 1 6 20.12l-.25-.93L5 16.38l-.74-2.74 1.44-.39 2.3 3.1.81 1.08 1.31-.35 2.8-.75 1.94-.52-.52-1.93-2.26-8.36 1.4-.37M14.16 3a1.06 1.06 0 0 0-.5 0l-3.09.83A1 1 0 0 0 9.89 5l2.5 9.36-2.81.75-2.73-3.61a1 1 0 0 0-.52-.36 1.06 1.06 0 0 0-.5 0L2.72 12A1 1 0 0 0 2 13.16l1 3.74.75 2.8.25.94a3.87 3.87 0 0 0 2.74 2.74 3.91 3.91 0 0 0 2 0l18.7-5a3.84 3.84 0 0 0 0-7.44 4.27 4.27 0 0 0-2.16 0l-4.51 1.21-6.07-8.74a1 1 0 0 0-.54-.41z"}),props.children);});var Departure20=/*#__PURE__*/React.forwardRef(function Departure20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2 28h28v2H2zM13.48 5.15l5.69 8.14.8 1.15 1.35-.36 4.52-1.21a2.13 2.13 0 0 1 1.12 0A1.84 1.84 0 0 1 28.23 14 1.87 1.87 0 0 1 27 16.45l-18.71 5a1.78 1.78 0 0 1-1 0A1.87 1.87 0 0 1 6 20.12l-.25-.93L5 16.38l-.74-2.74 1.44-.39 2.3 3.1.81 1.08 1.31-.35 2.8-.75 1.94-.52-.52-1.93-2.26-8.36 1.4-.37M14.16 3a1.06 1.06 0 0 0-.5 0l-3.09.83A1 1 0 0 0 9.89 5l2.5 9.36-2.81.75-2.73-3.61a1 1 0 0 0-.52-.36 1.06 1.06 0 0 0-.5 0L2.72 12A1 1 0 0 0 2 13.16l1 3.74.75 2.8.25.94a3.87 3.87 0 0 0 2.74 2.74 3.91 3.91 0 0 0 2 0l18.7-5a3.84 3.84 0 0 0 0-7.44 4.27 4.27 0 0 0-2.16 0l-4.51 1.21-6.07-8.74a1 1 0 0 0-.54-.41z"}),props.children);});var Departure16=/*#__PURE__*/React.forwardRef(function Departure16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2 28h28v2H2zM13.48 5.15l5.69 8.14.8 1.15 1.35-.36 4.52-1.21a2.13 2.13 0 0 1 1.12 0A1.84 1.84 0 0 1 28.23 14 1.87 1.87 0 0 1 27 16.45l-18.71 5a1.78 1.78 0 0 1-1 0A1.87 1.87 0 0 1 6 20.12l-.25-.93L5 16.38l-.74-2.74 1.44-.39 2.3 3.1.81 1.08 1.31-.35 2.8-.75 1.94-.52-.52-1.93-2.26-8.36 1.4-.37M14.16 3a1.06 1.06 0 0 0-.5 0l-3.09.83A1 1 0 0 0 9.89 5l2.5 9.36-2.81.75-2.73-3.61a1 1 0 0 0-.52-.36 1.06 1.06 0 0 0-.5 0L2.72 12A1 1 0 0 0 2 13.16l1 3.74.75 2.8.25.94a3.87 3.87 0 0 0 2.74 2.74 3.91 3.91 0 0 0 2 0l18.7-5a3.84 3.84 0 0 0 0-7.44 4.27 4.27 0 0 0-2.16 0l-4.51 1.21-6.07-8.74a1 1 0 0 0-.54-.41z"}),props.children);});var DeployRules32=/*#__PURE__*/React.forwardRef(function DeployRules32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 4l-6 6 1.41 1.41L17 7.83V20h2V7.83l3.59 3.58L24 10l-6-6zM8 18h7v2H8zm0 4h16v2H8zm0 4h16v2H8z"}),props.children);});var DeployRules24=/*#__PURE__*/React.forwardRef(function DeployRules24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 4l-6 6 1.41 1.41L17 7.83V20h2V7.83l3.59 3.58L24 10l-6-6zM8 18h7v2H8zm0 4h16v2H8zm0 4h16v2H8z"}),props.children);});var DeployRules20=/*#__PURE__*/React.forwardRef(function DeployRules20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 4l-6 6 1.41 1.41L17 7.83V20h2V7.83l3.59 3.58L24 10l-6-6zM8 18h7v2H8zm0 4h16v2H8zm0 4h16v2H8z"}),props.children);});var DeployRules16=/*#__PURE__*/React.forwardRef(function DeployRules16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 4l-6 6 1.41 1.41L17 7.83V20h2V7.83l3.59 3.58L24 10l-6-6zM8 18h7v2H8zm0 4h16v2H8zm0 4h16v2H8z"}),props.children);});var Development32=/*#__PURE__*/React.forwardRef(function Development32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8 4v4H4V4h4M2 2v8h8V2zm16 5v4h-4V7h4m-6-2v8h8V5zM8 16v4H4v-4h4m-6-2v8h8v-8z"}),React.createElement("path",{d:"M22 10v6h-6v6h-6v8h20V10zm-4 8h4v4h-4zm-2 10h-4v-4h4zm6 0h-4v-4h4zm6 0h-4v-4h4zm0-6h-4v-4h4zm-4-6v-4h4v4z"}),props.children);});var Development24=/*#__PURE__*/React.forwardRef(function Development24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8 4v4H4V4h4M2 2v8h8V2zm16 5v4h-4V7h4m-6-2v8h8V5zM8 16v4H4v-4h4m-6-2v8h8v-8z"}),React.createElement("path",{d:"M22 10v6h-6v6h-6v8h20V10zm-4 8h4v4h-4zm-2 10h-4v-4h4zm6 0h-4v-4h4zm6 0h-4v-4h4zm0-6h-4v-4h4zm-4-6v-4h4v4z"}),props.children);});var Development20=/*#__PURE__*/React.forwardRef(function Development20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8 4v4H4V4h4M2 2v8h8V2zm16 5v4h-4V7h4m-6-2v8h8V5zM8 16v4H4v-4h4m-6-2v8h8v-8z"}),React.createElement("path",{d:"M22 10v6h-6v6h-6v8h20V10zm-4 8h4v4h-4zm-2 10h-4v-4h4zm6 0h-4v-4h4zm6 0h-4v-4h4zm0-6h-4v-4h4zm-4-6v-4h4v4z"}),props.children);});var Development16=/*#__PURE__*/React.forwardRef(function Development16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8 4v4H4V4h4M2 2v8h8V2zm16 5v4h-4V7h4m-6-2v8h8V5zM8 16v4H4v-4h4m-6-2v8h8v-8z"}),React.createElement("path",{d:"M22 10v6h-6v6h-6v8h20V10zm-4 8h4v4h-4zm-2 10h-4v-4h4zm6 0h-4v-4h4zm6 0h-4v-4h4zm0-6h-4v-4h4zm-4-6v-4h4v4z"}),props.children);});var Devices32=/*#__PURE__*/React.forwardRef(function Devices32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 30H4a2 2 0 0 1-2-2V16a2 2 0 0 1 2-2h6a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2zM4 16v12h6V16z"}),React.createElement("path",{d:"M28 4H6a2 2 0 0 0-2 2v6h2V6h22v14H14v2h2v4h-2v2h9v-2h-5v-4h10a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2z"}),props.children);});var Devices24=/*#__PURE__*/React.forwardRef(function Devices24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 30H4a2 2 0 0 1-2-2V16a2 2 0 0 1 2-2h6a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2zM4 16v12h6V16z"}),React.createElement("path",{d:"M28 4H6a2 2 0 0 0-2 2v6h2V6h22v14H14v2h2v4h-2v2h9v-2h-5v-4h10a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2z"}),props.children);});var Devices20=/*#__PURE__*/React.forwardRef(function Devices20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 30H4a2 2 0 0 1-2-2V16a2 2 0 0 1 2-2h6a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2zM4 16v12h6V16z"}),React.createElement("path",{d:"M28 4H6a2 2 0 0 0-2 2v6h2V6h22v14H14v2h2v4h-2v2h9v-2h-5v-4h10a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2z"}),props.children);});var Devices16=/*#__PURE__*/React.forwardRef(function Devices16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 30H4a2 2 0 0 1-2-2V16a2 2 0 0 1 2-2h6a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2zM4 16v12h6V16z"}),React.createElement("path",{d:"M28 4H6a2 2 0 0 0-2 2v6h2V6h22v14H14v2h2v4h-2v2h9v-2h-5v-4h10a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2z"}),props.children);});var Diagram32=/*#__PURE__*/React.forwardRef(function Diagram32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13 30a11 11 0 0 1 0-22 1 1 0 0 1 1 1v9h9a1 1 0 0 1 1 1 11 11 0 0 1-11 11zm-1-19.94A9 9 0 1 0 21.94 20H14a2 2 0 0 1-2-2z"}),React.createElement("path",{d:"M28 14h-9a2 2 0 0 1-2-2V3a1 1 0 0 1 1-1 11 11 0 0 1 11 11 1 1 0 0 1-1 1zm-9-2h7.94A9 9 0 0 0 19 4.06z"}),props.children);});var Diagram24=/*#__PURE__*/React.forwardRef(function Diagram24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13 30a11 11 0 0 1 0-22 1 1 0 0 1 1 1v9h9a1 1 0 0 1 1 1 11 11 0 0 1-11 11zm-1-19.94A9 9 0 1 0 21.94 20H14a2 2 0 0 1-2-2z"}),React.createElement("path",{d:"M28 14h-9a2 2 0 0 1-2-2V3a1 1 0 0 1 1-1 11 11 0 0 1 11 11 1 1 0 0 1-1 1zm-9-2h7.94A9 9 0 0 0 19 4.06z"}),props.children);});var Diagram20=/*#__PURE__*/React.forwardRef(function Diagram20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13 30a11 11 0 0 1 0-22 1 1 0 0 1 1 1v9h9a1 1 0 0 1 1 1 11 11 0 0 1-11 11zm-1-19.94A9 9 0 1 0 21.94 20H14a2 2 0 0 1-2-2z"}),React.createElement("path",{d:"M28 14h-9a2 2 0 0 1-2-2V3a1 1 0 0 1 1-1 11 11 0 0 1 11 11 1 1 0 0 1-1 1zm-9-2h7.94A9 9 0 0 0 19 4.06z"}),props.children);});var Diagram16=/*#__PURE__*/React.forwardRef(function Diagram16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13 30a11 11 0 0 1 0-22 1 1 0 0 1 1 1v9h9a1 1 0 0 1 1 1 11 11 0 0 1-11 11zm-1-19.94A9 9 0 1 0 21.94 20H14a2 2 0 0 1-2-2z"}),React.createElement("path",{d:"M28 14h-9a2 2 0 0 1-2-2V3a1 1 0 0 1 1-1 11 11 0 0 1 11 11 1 1 0 0 1-1 1zm-9-2h7.94A9 9 0 0 0 19 4.06z"}),props.children);});var DocumentAdd32=/*#__PURE__*/React.forwardRef(function DocumentAdd32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.7 9.3l-7-7A.91.91 0 0 0 18 2H8a2 2 0 0 0-2 2v24a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V10a.91.91 0 0 0-.3-.7zM18 4.4l5.6 5.6H18zM24 28H8V4h8v6a2 2 0 0 0 2 2h6z"}),React.createElement("path",{d:"M21 19h-4v-4h-2v4h-4v2h4v4h2v-4h4v-2z"}),props.children);});var DocumentAdd24=/*#__PURE__*/React.forwardRef(function DocumentAdd24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.7 9.3l-7-7A.91.91 0 0 0 18 2H8a2 2 0 0 0-2 2v24a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V10a.91.91 0 0 0-.3-.7zM18 4.4l5.6 5.6H18zM24 28H8V4h8v6a2 2 0 0 0 2 2h6z"}),React.createElement("path",{d:"M21 19h-4v-4h-2v4h-4v2h4v4h2v-4h4v-2z"}),props.children);});var DocumentAdd20=/*#__PURE__*/React.forwardRef(function DocumentAdd20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.7 9.3l-7-7A.91.91 0 0 0 18 2H8a2 2 0 0 0-2 2v24a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V10a.91.91 0 0 0-.3-.7zM18 4.4l5.6 5.6H18zM24 28H8V4h8v6a2 2 0 0 0 2 2h6z"}),React.createElement("path",{d:"M21 19h-4v-4h-2v4h-4v2h4v4h2v-4h4v-2z"}),props.children);});var DocumentAdd16=/*#__PURE__*/React.forwardRef(function DocumentAdd16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.7 9.3l-7-7A.91.91 0 0 0 18 2H8a2 2 0 0 0-2 2v24a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V10a.91.91 0 0 0-.3-.7zM18 4.4l5.6 5.6H18zM24 28H8V4h8v6a2 2 0 0 0 2 2h6z"}),React.createElement("path",{d:"M21 19h-4v-4h-2v4h-4v2h4v4h2v-4h4v-2z"}),props.children);});var DocumentExport32=/*#__PURE__*/React.forwardRef(function DocumentExport32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13 21h13.17l-2.58 2.59L25 25l5-5-5-5-1.41 1.41L26.17 19H13v2z"}),React.createElement("path",{d:"M22 14v-4a1 1 0 0 0-.29-.71l-7-7A1 1 0 0 0 14 2H4a2 2 0 0 0-2 2v24a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2v-2h-2v2H4V4h8v6a2 2 0 0 0 2 2h6v2zm-8-4V4.41L19.59 10z"}),props.children);});var DocumentExport24=/*#__PURE__*/React.forwardRef(function DocumentExport24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13 21h13.17l-2.58 2.59L25 25l5-5-5-5-1.41 1.41L26.17 19H13v2z"}),React.createElement("path",{d:"M22 14v-4a1 1 0 0 0-.29-.71l-7-7A1 1 0 0 0 14 2H4a2 2 0 0 0-2 2v24a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2v-2h-2v2H4V4h8v6a2 2 0 0 0 2 2h6v2zm-8-4V4.41L19.59 10z"}),props.children);});var DocumentExport20=/*#__PURE__*/React.forwardRef(function DocumentExport20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13 21h13.17l-2.58 2.59L25 25l5-5-5-5-1.41 1.41L26.17 19H13v2z"}),React.createElement("path",{d:"M22 14v-4a1 1 0 0 0-.29-.71l-7-7A1 1 0 0 0 14 2H4a2 2 0 0 0-2 2v24a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2v-2h-2v2H4V4h8v6a2 2 0 0 0 2 2h6v2zm-8-4V4.41L19.59 10z"}),props.children);});var DocumentExport16=/*#__PURE__*/React.forwardRef(function DocumentExport16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13 21h13.17l-2.58 2.59L25 25l5-5-5-5-1.41 1.41L26.17 19H13v2z"}),React.createElement("path",{d:"M22 14v-4a1 1 0 0 0-.29-.71l-7-7A1 1 0 0 0 14 2H4a2 2 0 0 0-2 2v24a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2v-2h-2v2H4V4h8v6a2 2 0 0 0 2 2h6v2zm-8-4V4.41L19.59 10z"}),props.children);});var DocumentImport32=/*#__PURE__*/React.forwardRef(function DocumentImport32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 19H14.83l2.58-2.59L16 15l-5 5 5 5 1.41-1.41L14.83 21H28v-2z"}),React.createElement("path",{d:"M24 14v-4a1 1 0 0 0-.29-.71l-7-7A1 1 0 0 0 16 2H6a2 2 0 0 0-2 2v24a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2v-2h-2v2H6V4h8v6a2 2 0 0 0 2 2h6v2zm-8-4V4.41L21.59 10z"}),props.children);});var DocumentImport24=/*#__PURE__*/React.forwardRef(function DocumentImport24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 19H14.83l2.58-2.59L16 15l-5 5 5 5 1.41-1.41L14.83 21H28v-2z"}),React.createElement("path",{d:"M24 14v-4a1 1 0 0 0-.29-.71l-7-7A1 1 0 0 0 16 2H6a2 2 0 0 0-2 2v24a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2v-2h-2v2H6V4h8v6a2 2 0 0 0 2 2h6v2zm-8-4V4.41L21.59 10z"}),props.children);});var DocumentImport20=/*#__PURE__*/React.forwardRef(function DocumentImport20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 19H14.83l2.58-2.59L16 15l-5 5 5 5 1.41-1.41L14.83 21H28v-2z"}),React.createElement("path",{d:"M24 14v-4a1 1 0 0 0-.29-.71l-7-7A1 1 0 0 0 16 2H6a2 2 0 0 0-2 2v24a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2v-2h-2v2H6V4h8v6a2 2 0 0 0 2 2h6v2zm-8-4V4.41L21.59 10z"}),props.children);});var DocumentImport16=/*#__PURE__*/React.forwardRef(function DocumentImport16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 19H14.83l2.58-2.59L16 15l-5 5 5 5 1.41-1.41L14.83 21H28v-2z"}),React.createElement("path",{d:"M24 14v-4a1 1 0 0 0-.29-.71l-7-7A1 1 0 0 0 16 2H6a2 2 0 0 0-2 2v24a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2v-2h-2v2H6V4h8v6a2 2 0 0 0 2 2h6v2zm-8-4V4.41L21.59 10z"}),props.children);});var DocumentSubtract32=/*#__PURE__*/React.forwardRef(function DocumentSubtract32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.7 9.3l-7-7A.91.91 0 0 0 18 2H8a2 2 0 0 0-2 2v24a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V10a.91.91 0 0 0-.3-.7zM18 4.4l5.6 5.6H18zM24 28H8V4h8v6a2 2 0 0 0 2 2h6z"}),React.createElement("path",{d:"M11 19h10v2H11z"}),props.children);});var DocumentSubtract24=/*#__PURE__*/React.forwardRef(function DocumentSubtract24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.7 9.3l-7-7A.91.91 0 0 0 18 2H8a2 2 0 0 0-2 2v24a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V10a.91.91 0 0 0-.3-.7zM18 4.4l5.6 5.6H18zM24 28H8V4h8v6a2 2 0 0 0 2 2h6z"}),React.createElement("path",{d:"M11 19h10v2H11z"}),props.children);});var DocumentSubtract20=/*#__PURE__*/React.forwardRef(function DocumentSubtract20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.7 9.3l-7-7A.91.91 0 0 0 18 2H8a2 2 0 0 0-2 2v24a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V10a.91.91 0 0 0-.3-.7zM18 4.4l5.6 5.6H18zM24 28H8V4h8v6a2 2 0 0 0 2 2h6z"}),React.createElement("path",{d:"M11 19h10v2H11z"}),props.children);});var DocumentSubtract16=/*#__PURE__*/React.forwardRef(function DocumentSubtract16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.7 9.3l-7-7A.91.91 0 0 0 18 2H8a2 2 0 0 0-2 2v24a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V10a.91.91 0 0 0-.3-.7zM18 4.4l5.6 5.6H18zM24 28H8V4h8v6a2 2 0 0 0 2 2h6z"}),React.createElement("path",{d:"M11 19h10v2H11z"}),props.children);});var DocumentTasks32=/*#__PURE__*/React.forwardRef(function DocumentTasks32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.7 9.3l-7-7A.91.91 0 0 0 18 2H8a2 2 0 0 0-2 2v24a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V10a.91.91 0 0 0-.3-.7zM18 4.4l5.6 5.6H18zM24 28H8V4h8v6a2 2 0 0 0 2 2h6z"}),React.createElement("path",{d:"M14 22.18l-2.59-2.59L10 21l4 4 8-8-1.41-1.41L14 22.18z"}),props.children);});var DocumentTasks24=/*#__PURE__*/React.forwardRef(function DocumentTasks24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.7 9.3l-7-7A.91.91 0 0 0 18 2H8a2 2 0 0 0-2 2v24a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V10a.91.91 0 0 0-.3-.7zM18 4.4l5.6 5.6H18zM24 28H8V4h8v6a2 2 0 0 0 2 2h6z"}),React.createElement("path",{d:"M14 22.18l-2.59-2.59L10 21l4 4 8-8-1.41-1.41L14 22.18z"}),props.children);});var DocumentTasks20=/*#__PURE__*/React.forwardRef(function DocumentTasks20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.7 9.3l-7-7A.91.91 0 0 0 18 2H8a2 2 0 0 0-2 2v24a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V10a.91.91 0 0 0-.3-.7zM18 4.4l5.6 5.6H18zM24 28H8V4h8v6a2 2 0 0 0 2 2h6z"}),React.createElement("path",{d:"M14 22.18l-2.59-2.59L10 21l4 4 8-8-1.41-1.41L14 22.18z"}),props.children);});var DocumentTasks16=/*#__PURE__*/React.forwardRef(function DocumentTasks16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.7 9.3l-7-7A.91.91 0 0 0 18 2H8a2 2 0 0 0-2 2v24a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V10a.91.91 0 0 0-.3-.7zM18 4.4l5.6 5.6H18zM24 28H8V4h8v6a2 2 0 0 0 2 2h6z"}),React.createElement("path",{d:"M14 22.18l-2.59-2.59L10 21l4 4 8-8-1.41-1.41L14 22.18z"}),props.children);});var Document32=/*#__PURE__*/React.forwardRef(function Document32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.7 9.3l-7-7A.91.91 0 0 0 18 2H8a2 2 0 0 0-2 2v24a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V10a.91.91 0 0 0-.3-.7zM18 4.4l5.6 5.6H18zM24 28H8V4h8v6a2 2 0 0 0 2 2h6z"}),React.createElement("path",{d:"M11 22h10v2H11zm0-6h10v2H11z"}),props.children);});var Document24=/*#__PURE__*/React.forwardRef(function Document24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.7 9.3l-7-7A.91.91 0 0 0 18 2H8a2 2 0 0 0-2 2v24a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V10a.91.91 0 0 0-.3-.7zM18 4.4l5.6 5.6H18zM24 28H8V4h8v6a2 2 0 0 0 2 2h6z"}),React.createElement("path",{d:"M11 22h10v2H11zm0-6h10v2H11z"}),props.children);});var Document20=/*#__PURE__*/React.forwardRef(function Document20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.7 9.3l-7-7A.91.91 0 0 0 18 2H8a2 2 0 0 0-2 2v24a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V10a.91.91 0 0 0-.3-.7zM18 4.4l5.6 5.6H18zM24 28H8V4h8v6a2 2 0 0 0 2 2h6z"}),React.createElement("path",{d:"M11 22h10v2H11zm0-6h10v2H11z"}),props.children);});var DownToBottom32=/*#__PURE__*/React.forwardRef(function DownToBottom32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 19L6 9l1.41-1.41L16 16.17l8.59-8.58L26 9 16 19zM4 23h24v2H4z"}),props.children);});var DownToBottom24=/*#__PURE__*/React.forwardRef(function DownToBottom24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 19L6 9l1.41-1.41L16 16.17l8.59-8.58L26 9 16 19zM4 23h24v2H4z"}),props.children);});var DownToBottom20=/*#__PURE__*/React.forwardRef(function DownToBottom20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 19L6 9l1.41-1.41L16 16.17l8.59-8.58L26 9 16 19zM4 23h24v2H4z"}),props.children);});var Download32=/*#__PURE__*/React.forwardRef(function Download32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 15l-1.41-1.41L17 21.17V2h-2v19.17l-7.59-7.58L6 15l10 10 10-10z"}),React.createElement("path",{d:"M26 24v4H6v-4H4v4a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2v-4z"}),props.children);});var Download24=/*#__PURE__*/React.forwardRef(function Download24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 15l-1.41-1.41L17 21.17V2h-2v19.17l-7.59-7.58L6 15l10 10 10-10z"}),React.createElement("path",{d:"M26 24v4H6v-4H4v4a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2v-4z"}),props.children);});var Download20=/*#__PURE__*/React.forwardRef(function Download20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 15l-1.41-1.41L17 21.17V2h-2v19.17l-7.59-7.58L6 15l10 10 10-10z"}),React.createElement("path",{d:"M26 24v4H6v-4H4v4a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2v-4z"}),props.children);});var DragHorizontal32=/*#__PURE__*/React.forwardRef(function DragHorizontal32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 4v11H5.83l2.58-2.59L7 11l-5 5 5 5 1.41-1.41L5.83 17H12v11h2V4h-2zm13 7l-1.41 1.41L26.17 15H20V4h-2v24h2V17h6.17l-2.58 2.59L25 21l5-5-5-5z"}),props.children);});var DragHorizontal24=/*#__PURE__*/React.forwardRef(function DragHorizontal24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 4v11H5.83l2.58-2.59L7 11l-5 5 5 5 1.41-1.41L5.83 17H12v11h2V4h-2zm13 7l-1.41 1.41L26.17 15H20V4h-2v24h2V17h6.17l-2.58 2.59L25 21l5-5-5-5z"}),props.children);});var DragHorizontal20=/*#__PURE__*/React.forwardRef(function DragHorizontal20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 4v11H5.83l2.58-2.59L7 11l-5 5 5 5 1.41-1.41L5.83 17H12v11h2V4h-2zm13 7l-1.41 1.41L26.17 15H20V4h-2v24h2V17h6.17l-2.58 2.59L25 21l5-5-5-5z"}),props.children);});var DragHorizontal16=/*#__PURE__*/React.forwardRef(function DragHorizontal16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 4v11H5.83l2.58-2.59L7 11l-5 5 5 5 1.41-1.41L5.83 17H12v11h2V4h-2zm13 7l-1.41 1.41L26.17 15H20V4h-2v24h2V17h6.17l-2.58 2.59L25 21l5-5-5-5z"}),props.children);});var DragVertical32=/*#__PURE__*/React.forwardRef(function DragVertical32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4 20h11v6.17l-2.59-2.58L11 25l5 5 5-5-1.41-1.41L17 26.17V20h11v-2H4v2zm7-13l1.41 1.41L15 5.83V12H4v2h24v-2H17V5.83l2.59 2.58L21 7l-5-5-5 5z"}),props.children);});var DragVertical24=/*#__PURE__*/React.forwardRef(function DragVertical24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4 20h11v6.17l-2.59-2.58L11 25l5 5 5-5-1.41-1.41L17 26.17V20h11v-2H4v2zm7-13l1.41 1.41L15 5.83V12H4v2h24v-2H17V5.83l2.59 2.58L21 7l-5-5-5 5z"}),props.children);});var DragVertical20=/*#__PURE__*/React.forwardRef(function DragVertical20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4 20h11v6.17l-2.59-2.58L11 25l5 5 5-5-1.41-1.41L17 26.17V20h11v-2H4v2zm7-13l1.41 1.41L15 5.83V12H4v2h24v-2H17V5.83l2.59 2.58L21 7l-5-5-5 5z"}),props.children);});var DragVertical16=/*#__PURE__*/React.forwardRef(function DragVertical16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4 20h11v6.17l-2.59-2.58L11 25l5 5 5-5-1.41-1.41L17 26.17V20h11v-2H4v2zm7-13l1.41 1.41L15 5.83V12H4v2h24v-2H17V5.83l2.59 2.58L21 7l-5-5-5 5z"}),props.children);});var Draggable32=/*#__PURE__*/React.forwardRef(function Draggable32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 5h4v4h-4zm8 0h4v4h-4zm-8 9h4v4h-4zm8 0h4v4h-4zm-8 9h4v4h-4zm8 0h4v4h-4z"}),props.children);});var Draggable24=/*#__PURE__*/React.forwardRef(function Draggable24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 5h4v4h-4zm8 0h4v4h-4zm-8 9h4v4h-4zm8 0h4v4h-4zm-8 9h4v4h-4zm8 0h4v4h-4z"}),props.children);});var Draggable20=/*#__PURE__*/React.forwardRef(function Draggable20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 5h4v4h-4zm8 0h4v4h-4zm-8 9h4v4h-4zm8 0h4v4h-4zm-8 9h4v4h-4zm8 0h4v4h-4z"}),props.children);});var Draw32=/*#__PURE__*/React.forwardRef(function Draw32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19.14 28a3.42 3.42 0 0 1-2.42-5.85L21.86 17a1.42 1.42 0 1 0-2-2L13 21.85a3.5 3.5 0 0 1-4.85 0 3.43 3.43 0 0 1 0-4.84l8.58-8.58a1.42 1.42 0 1 0-2-2L6.41 14.7 5 13.3 13.29 5a3.43 3.43 0 0 1 4.84 4.85l-8.57 8.57a1.42 1.42 0 0 0 0 2 1.45 1.45 0 0 0 2 0l6.86-6.86a3.43 3.43 0 1 1 4.85 4.84l-5.15 5.15a1.42 1.42 0 0 0 2 2l4.44-4.43L26 22.56 21.56 27a3.38 3.38 0 0 1-2.42 1z"}),props.children);});var Draw24=/*#__PURE__*/React.forwardRef(function Draw24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19.14 28a3.42 3.42 0 0 1-2.42-5.85L21.86 17a1.42 1.42 0 1 0-2-2L13 21.85a3.5 3.5 0 0 1-4.85 0 3.43 3.43 0 0 1 0-4.84l8.58-8.58a1.42 1.42 0 1 0-2-2L6.41 14.7 5 13.3 13.29 5a3.43 3.43 0 0 1 4.84 4.85l-8.57 8.57a1.42 1.42 0 0 0 0 2 1.45 1.45 0 0 0 2 0l6.86-6.86a3.43 3.43 0 1 1 4.85 4.84l-5.15 5.15a1.42 1.42 0 0 0 2 2l4.44-4.43L26 22.56 21.56 27a3.38 3.38 0 0 1-2.42 1z"}),props.children);});var Draw20=/*#__PURE__*/React.forwardRef(function Draw20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19.14 28a3.42 3.42 0 0 1-2.42-5.85L21.86 17a1.42 1.42 0 1 0-2-2L13 21.85a3.5 3.5 0 0 1-4.85 0 3.43 3.43 0 0 1 0-4.84l8.58-8.58a1.42 1.42 0 1 0-2-2L6.41 14.7 5 13.3 13.29 5a3.43 3.43 0 0 1 4.84 4.85l-8.57 8.57a1.42 1.42 0 0 0 0 2 1.45 1.45 0 0 0 2 0l6.86-6.86a3.43 3.43 0 1 1 4.85 4.84l-5.15 5.15a1.42 1.42 0 0 0 2 2l4.44-4.43L26 22.56 21.56 27a3.38 3.38 0 0 1-2.42 1z"}),props.children);});var Draw16=/*#__PURE__*/React.forwardRef(function Draw16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19.14 28a3.42 3.42 0 0 1-2.42-5.85L21.86 17a1.42 1.42 0 1 0-2-2L13 21.85a3.5 3.5 0 0 1-4.85 0 3.43 3.43 0 0 1 0-4.84l8.58-8.58a1.42 1.42 0 1 0-2-2L6.41 14.7 5 13.3 13.29 5a3.43 3.43 0 0 1 4.84 4.85l-8.57 8.57a1.42 1.42 0 0 0 0 2 1.45 1.45 0 0 0 2 0l6.86-6.86a3.43 3.43 0 1 1 4.85 4.84l-5.15 5.15a1.42 1.42 0 0 0 2 2l4.44-4.43L26 22.56 21.56 27a3.38 3.38 0 0 1-2.42 1z"}),props.children);});var EditOff32=/*#__PURE__*/React.forwardRef(function EditOff32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 28.59L3.41 2 2 3.41 12.09 13.5 4 21.59V28h6.41l8.09-8.09L28.59 30zM9.59 26H6v-3.59l7.5-7.5 3.59 3.59zM29.41 6.17l-3.58-3.58a2 2 0 0 0-2.83 0l-8.08 8.08 1.41 1.41L20 8.41 23.59 12l-3.67 3.67 1.41 1.41L29.41 9a2 2 0 0 0 0-2.83zM25 10.59L21.41 7l3-3L28 7.59z"}),props.children);});var EditOff24=/*#__PURE__*/React.forwardRef(function EditOff24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 28.59L3.41 2 2 3.41 12.09 13.5 4 21.59V28h6.41l8.09-8.09L28.59 30zM9.59 26H6v-3.59l7.5-7.5 3.59 3.59zM29.41 6.17l-3.58-3.58a2 2 0 0 0-2.83 0l-8.08 8.08 1.41 1.41L20 8.41 23.59 12l-3.67 3.67 1.41 1.41L29.41 9a2 2 0 0 0 0-2.83zM25 10.59L21.41 7l3-3L28 7.59z"}),props.children);});var EditOff20=/*#__PURE__*/React.forwardRef(function EditOff20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 28.59L3.41 2 2 3.41 12.09 13.5 4 21.59V28h6.41l8.09-8.09L28.59 30zM9.59 26H6v-3.59l7.5-7.5 3.59 3.59zM29.41 6.17l-3.58-3.58a2 2 0 0 0-2.83 0l-8.08 8.08 1.41 1.41L20 8.41 23.59 12l-3.67 3.67 1.41 1.41L29.41 9a2 2 0 0 0 0-2.83zM25 10.59L21.41 7l3-3L28 7.59z"}),props.children);});var Edit32=/*#__PURE__*/React.forwardRef(function Edit32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2 27h28v2H2zM25.41 9a2 2 0 0 0 0-2.83l-3.58-3.58a2 2 0 0 0-2.83 0l-15 15V24h6.41zm-5-5L24 7.59l-3 3L17.41 7zM6 22v-3.59l10-10L19.59 12l-10 10z"}),props.children);});var Edit24=/*#__PURE__*/React.forwardRef(function Edit24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2 27h28v2H2zM25.41 9a2 2 0 0 0 0-2.83l-3.58-3.58a2 2 0 0 0-2.83 0l-15 15V24h6.41zm-5-5L24 7.59l-3 3L17.41 7zM6 22v-3.59l10-10L19.59 12l-10 10z"}),props.children);});var Edit20=/*#__PURE__*/React.forwardRef(function Edit20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2 27h28v2H2zM25.41 9a2 2 0 0 0 0-2.83l-3.58-3.58a2 2 0 0 0-2.83 0l-15 15V24h6.41zm-5-5L24 7.59l-3 3L17.41 7zM6 22v-3.59l10-10L19.59 12l-10 10z"}),props.children);});var EdtLoop32=/*#__PURE__*/React.forwardRef(function EdtLoop32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.625 22.587a6.129 6.129 0 0 1-4.5-1.9l-3.1-3.2-3.1 3.2a6.458 6.458 0 0 1-9.1 0 7.028 7.028 0 0 1-1.8-4.7 6.655 6.655 0 0 1 1.9-4.7 6.338 6.338 0 0 1 9 0l3.1 3.2 3.1-3.2a6.338 6.338 0 0 1 9 0 6.828 6.828 0 0 1 0 9.4 6.542 6.542 0 0 1-4.5 1.9zm-6.2-6.6l3.1 3.3a4.406 4.406 0 0 0 6.2 0 4.908 4.908 0 0 0 0-6.6 4.406 4.406 0 0 0-6.2 0zm-9-4.6a4.158 4.158 0 0 0-3.1 1.3 4.838 4.838 0 0 0 0 6.6 4.406 4.406 0 0 0 6.2 0l3.1-3.3-3.1-3.3a4.77 4.77 0 0 0-3.1-1.3z"}),props.children);});var EdtLoop24=/*#__PURE__*/React.forwardRef(function EdtLoop24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.625 22.587a6.129 6.129 0 0 1-4.5-1.9l-3.1-3.2-3.1 3.2a6.458 6.458 0 0 1-9.1 0 7.028 7.028 0 0 1-1.8-4.7 6.655 6.655 0 0 1 1.9-4.7 6.338 6.338 0 0 1 9 0l3.1 3.2 3.1-3.2a6.338 6.338 0 0 1 9 0 6.828 6.828 0 0 1 0 9.4 6.542 6.542 0 0 1-4.5 1.9zm-6.2-6.6l3.1 3.3a4.406 4.406 0 0 0 6.2 0 4.908 4.908 0 0 0 0-6.6 4.406 4.406 0 0 0-6.2 0zm-9-4.6a4.158 4.158 0 0 0-3.1 1.3 4.838 4.838 0 0 0 0 6.6 4.406 4.406 0 0 0 6.2 0l3.1-3.3-3.1-3.3a4.77 4.77 0 0 0-3.1-1.3z"}),props.children);});var EdtLoop20=/*#__PURE__*/React.forwardRef(function EdtLoop20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.625 22.587a6.129 6.129 0 0 1-4.5-1.9l-3.1-3.2-3.1 3.2a6.458 6.458 0 0 1-9.1 0 7.028 7.028 0 0 1-1.8-4.7 6.655 6.655 0 0 1 1.9-4.7 6.338 6.338 0 0 1 9 0l3.1 3.2 3.1-3.2a6.338 6.338 0 0 1 9 0 6.828 6.828 0 0 1 0 9.4 6.542 6.542 0 0 1-4.5 1.9zm-6.2-6.6l3.1 3.3a4.406 4.406 0 0 0 6.2 0 4.908 4.908 0 0 0 0-6.6 4.406 4.406 0 0 0-6.2 0zm-9-4.6a4.158 4.158 0 0 0-3.1 1.3 4.838 4.838 0 0 0 0 6.6 4.406 4.406 0 0 0 6.2 0l3.1-3.3-3.1-3.3a4.77 4.77 0 0 0-3.1-1.3z"}),props.children);});var EdtLoop16=/*#__PURE__*/React.forwardRef(function EdtLoop16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.625 22.587a6.129 6.129 0 0 1-4.5-1.9l-3.1-3.2-3.1 3.2a6.458 6.458 0 0 1-9.1 0 7.028 7.028 0 0 1-1.8-4.7 6.655 6.655 0 0 1 1.9-4.7 6.338 6.338 0 0 1 9 0l3.1 3.2 3.1-3.2a6.338 6.338 0 0 1 9 0 6.828 6.828 0 0 1 0 9.4 6.542 6.542 0 0 1-4.5 1.9zm-6.2-6.6l3.1 3.3a4.406 4.406 0 0 0 6.2 0 4.908 4.908 0 0 0 0-6.6 4.406 4.406 0 0 0-6.2 0zm-9-4.6a4.158 4.158 0 0 0-3.1 1.3 4.838 4.838 0 0 0 0 6.6 4.406 4.406 0 0 0 6.2 0l3.1-3.3-3.1-3.3a4.77 4.77 0 0 0-3.1-1.3z"}),props.children);});var Education32=/*#__PURE__*/React.forwardRef(function Education32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 30h-2v-3a5.006 5.006 0 0 0-5-5h-6a5.006 5.006 0 0 0-5 5v3H6v-3a7.008 7.008 0 0 1 7-7h6a7.008 7.008 0 0 1 7 7zM5 6a1 1 0 0 0-1 1v9h2V7a1 1 0 0 0-1-1z"}),React.createElement("path",{d:"M4 2v2h5v7a7 7 0 0 0 14 0V4h5V2zm7 2h10v3H11zm5 12a5 5 0 0 1-5-5V9h10v2a5 5 0 0 1-5 5z"}),props.children);});var Education24=/*#__PURE__*/React.forwardRef(function Education24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 30h-2v-3a5.006 5.006 0 0 0-5-5h-6a5.006 5.006 0 0 0-5 5v3H6v-3a7.008 7.008 0 0 1 7-7h6a7.008 7.008 0 0 1 7 7zM5 6a1 1 0 0 0-1 1v9h2V7a1 1 0 0 0-1-1z"}),React.createElement("path",{d:"M4 2v2h5v7a7 7 0 0 0 14 0V4h5V2zm7 2h10v3H11zm5 12a5 5 0 0 1-5-5V9h10v2a5 5 0 0 1-5 5z"}),props.children);});var Education20=/*#__PURE__*/React.forwardRef(function Education20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 30h-2v-3a5.006 5.006 0 0 0-5-5h-6a5.006 5.006 0 0 0-5 5v3H6v-3a7.008 7.008 0 0 1 7-7h6a7.008 7.008 0 0 1 7 7zM5 6a1 1 0 0 0-1 1v9h2V7a1 1 0 0 0-1-1z"}),React.createElement("path",{d:"M4 2v2h5v7a7 7 0 0 0 14 0V4h5V2zm7 2h10v3H11zm5 12a5 5 0 0 1-5-5V9h10v2a5 5 0 0 1-5 5z"}),props.children);});var Education16=/*#__PURE__*/React.forwardRef(function Education16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 30h-2v-3a5.006 5.006 0 0 0-5-5h-6a5.006 5.006 0 0 0-5 5v3H6v-3a7.008 7.008 0 0 1 7-7h6a7.008 7.008 0 0 1 7 7zM5 6a1 1 0 0 0-1 1v9h2V7a1 1 0 0 0-1-1z"}),React.createElement("path",{d:"M4 2v2h5v7a7 7 0 0 0 14 0V4h5V2zm7 2h10v3H11zm5 12a5 5 0 0 1-5-5V9h10v2a5 5 0 0 1-5 5z"}),props.children);});var Email32=/*#__PURE__*/React.forwardRef(function Email32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 6H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zm-2.2 2L16 14.78 6.2 8zM4 24V8.91l11.43 7.91a1 1 0 0 0 1.14 0L28 8.91V24z"}),props.children);});var Email24=/*#__PURE__*/React.forwardRef(function Email24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 6H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zm-2.2 2L16 14.78 6.2 8zM4 24V8.91l11.43 7.91a1 1 0 0 0 1.14 0L28 8.91V24z"}),props.children);});var Email20=/*#__PURE__*/React.forwardRef(function Email20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 6H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zm-2.2 2L16 14.78 6.2 8zM4 24V8.91l11.43 7.91a1 1 0 0 0 1.14 0L28 8.91V24z"}),props.children);});var Enterprise32=/*#__PURE__*/React.forwardRef(function Enterprise32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 28V14a2 2 0 0 0-2-2h-4V4a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2v24H2v2h28v-2zM6 4h14v24H6zm16 24V14h4v14z"}),React.createElement("path",{d:"M10 8h2v4h-2zm0 6h2v4h-2zm4-6h2v4h-2zm0 6h2v4h-2zm-4 6h2v4h-2zm4 0h2v4h-2z"}),props.children);});var Enterprise24=/*#__PURE__*/React.forwardRef(function Enterprise24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 28V14a2 2 0 0 0-2-2h-4V4a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2v24H2v2h28v-2zM6 4h14v24H6zm16 24V14h4v14z"}),React.createElement("path",{d:"M10 8h2v4h-2zm0 6h2v4h-2zm4-6h2v4h-2zm0 6h2v4h-2zm-4 6h2v4h-2zm4 0h2v4h-2z"}),props.children);});var Enterprise20=/*#__PURE__*/React.forwardRef(function Enterprise20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 28V14a2 2 0 0 0-2-2h-4V4a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2v24H2v2h28v-2zM6 4h14v24H6zm16 24V14h4v14z"}),React.createElement("path",{d:"M10 8h2v4h-2zm0 6h2v4h-2zm4-6h2v4h-2zm0 6h2v4h-2zm-4 6h2v4h-2zm4 0h2v4h-2z"}),props.children);});var Enterprise16=/*#__PURE__*/React.forwardRef(function Enterprise16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 28V14a2 2 0 0 0-2-2h-4V4a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2v24H2v2h28v-2zM6 4h14v24H6zm16 24V14h4v14z"}),React.createElement("path",{d:"M10 8h2v4h-2zm0 6h2v4h-2zm4-6h2v4h-2zm0 6h2v4h-2zm-4 6h2v4h-2zm4 0h2v4h-2z"}),props.children);});var Erase32=/*#__PURE__*/React.forwardRef(function Erase32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7 27h23v2H7zm20.38-16.49l-7.93-7.92a2 2 0 0 0-2.83 0l-14 14a2 2 0 0 0 0 2.83L7.13 24h9.59l10.66-10.66a2 2 0 0 0 0-2.83zM15.89 22H8l-4-4 6.31-6.31 7.93 7.92zm3.76-3.76l-7.92-7.93L18 4l8 7.93z"}),props.children);});var Erase24=/*#__PURE__*/React.forwardRef(function Erase24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7 27h23v2H7zm20.38-16.49l-7.93-7.92a2 2 0 0 0-2.83 0l-14 14a2 2 0 0 0 0 2.83L7.13 24h9.59l10.66-10.66a2 2 0 0 0 0-2.83zM15.89 22H8l-4-4 6.31-6.31 7.93 7.92zm3.76-3.76l-7.92-7.93L18 4l8 7.93z"}),props.children);});var Erase20=/*#__PURE__*/React.forwardRef(function Erase20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7 27h23v2H7zm20.38-16.49l-7.93-7.92a2 2 0 0 0-2.83 0l-14 14a2 2 0 0 0 0 2.83L7.13 24h9.59l10.66-10.66a2 2 0 0 0 0-2.83zM15.89 22H8l-4-4 6.31-6.31 7.93 7.92zm3.76-3.76l-7.92-7.93L18 4l8 7.93z"}),props.children);});var Erase16=/*#__PURE__*/React.forwardRef(function Erase16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7 27h23v2H7zm20.38-16.49l-7.93-7.92a2 2 0 0 0-2.83 0l-14 14a2 2 0 0 0 0 2.83L7.13 24h9.59l10.66-10.66a2 2 0 0 0 0-2.83zM15.89 22H8l-4-4 6.31-6.31 7.93 7.92zm3.76-3.76l-7.92-7.93L18 4l8 7.93z"}),props.children);});var ErrorFilled32=/*#__PURE__*/React.forwardRef(function ErrorFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2C8.2 2 2 8.2 2 16s6.2 14 14 14 14-6.2 14-14S23.8 2 16 2zm5.4 21L9 10.6 10.6 9 23 21.4 21.4 23z"}),React.createElement("path",{d:"M21.4 23L9 10.6 10.6 9 23 21.4 21.4 23z","data-icon-path":"inner-path",opacity:"0"}),props.children);});var ErrorOutline32=/*#__PURE__*/React.forwardRef(function ErrorOutline32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2C8.2 2 2 8.2 2 16s6.2 14 14 14 14-6.2 14-14S23.8 2 16 2zm0 26C9.4 28 4 22.6 4 16S9.4 4 16 4s12 5.4 12 12-5.4 12-12 12z"}),React.createElement("path",{d:"M8.929 10.667l1.555-1.555L22.93 21.557l-1.555 1.555z"}),props.children);});var ErrorOutline24=/*#__PURE__*/React.forwardRef(function ErrorOutline24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2C8.2 2 2 8.2 2 16s6.2 14 14 14 14-6.2 14-14S23.8 2 16 2zm0 26C9.4 28 4 22.6 4 16S9.4 4 16 4s12 5.4 12 12-5.4 12-12 12z"}),React.createElement("path",{d:"M8.929 10.667l1.555-1.555L22.93 21.557l-1.555 1.555z"}),props.children);});var ErrorOutline20=/*#__PURE__*/React.forwardRef(function ErrorOutline20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2C8.2 2 2 8.2 2 16s6.2 14 14 14 14-6.2 14-14S23.8 2 16 2zm0 26C9.4 28 4 22.6 4 16S9.4 4 16 4s12 5.4 12 12-5.4 12-12 12z"}),React.createElement("path",{d:"M8.929 10.667l1.555-1.555L22.93 21.557l-1.555 1.555z"}),props.children);});var Error32=/*#__PURE__*/React.forwardRef(function Error32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2 16A14 14 0 1 0 16 2 14 14 0 0 0 2 16zm23.15 7.75L8.25 6.85a12 12 0 0 1 16.9 16.9zM8.24 25.16a12 12 0 0 1-1.4-16.89l16.89 16.89a12 12 0 0 1-15.49 0z"}),props.children);});var Error24=/*#__PURE__*/React.forwardRef(function Error24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2 16A14 14 0 1 0 16 2 14 14 0 0 0 2 16zm23.15 7.75L8.25 6.85a12 12 0 0 1 16.9 16.9zM8.24 25.16a12 12 0 0 1-1.4-16.89l16.89 16.89a12 12 0 0 1-15.49 0z"}),props.children);});var Error20=/*#__PURE__*/React.forwardRef(function Error20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2 16A14 14 0 1 0 16 2 14 14 0 0 0 2 16zm23.15 7.75L8.25 6.85a12 12 0 0 1 16.9 16.9zM8.24 25.16a12 12 0 0 1-1.4-16.89l16.89 16.89a12 12 0 0 1-15.49 0z"}),props.children);});var Error16=/*#__PURE__*/React.forwardRef(function Error16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2 16A14 14 0 1 0 16 2 14 14 0 0 0 2 16zm23.15 7.75L8.25 6.85a12 12 0 0 1 16.9 16.9zM8.24 25.16a12 12 0 0 1-1.4-16.89l16.89 16.89a12 12 0 0 1-15.49 0z"}),props.children);});var EventSchedule32=/*#__PURE__*/React.forwardRef(function EventSchedule32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21 30a8 8 0 1 1 8-8 8 8 0 0 1-8 8zm0-14a6 6 0 1 0 6 6 6 6 0 0 0-6-6z"}),React.createElement("path",{d:"M22.59 25L20 22.41V18h2v3.59l2 2L22.59 25z"}),React.createElement("path",{d:"M28 6a2 2 0 0 0-2-2h-4V2h-2v2h-8V2h-2v2H6a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h4v-2H6V6h4v2h2V6h8v2h2V6h4v6h2z"}),props.children);});var EventSchedule24=/*#__PURE__*/React.forwardRef(function EventSchedule24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21 30a8 8 0 1 1 8-8 8 8 0 0 1-8 8zm0-14a6 6 0 1 0 6 6 6 6 0 0 0-6-6z"}),React.createElement("path",{d:"M22.59 25L20 22.41V18h2v3.59l2 2L22.59 25z"}),React.createElement("path",{d:"M28 6a2 2 0 0 0-2-2h-4V2h-2v2h-8V2h-2v2H6a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h4v-2H6V6h4v2h2V6h8v2h2V6h4v6h2z"}),props.children);});var EventSchedule20=/*#__PURE__*/React.forwardRef(function EventSchedule20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21 30a8 8 0 1 1 8-8 8 8 0 0 1-8 8zm0-14a6 6 0 1 0 6 6 6 6 0 0 0-6-6z"}),React.createElement("path",{d:"M22.59 25L20 22.41V18h2v3.59l2 2L22.59 25z"}),React.createElement("path",{d:"M28 6a2 2 0 0 0-2-2h-4V2h-2v2h-8V2h-2v2H6a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h4v-2H6V6h4v2h2V6h8v2h2V6h4v6h2z"}),props.children);});var EventSchedule16=/*#__PURE__*/React.forwardRef(function EventSchedule16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21 30a8 8 0 1 1 8-8 8 8 0 0 1-8 8zm0-14a6 6 0 1 0 6 6 6 6 0 0 0-6-6z"}),React.createElement("path",{d:"M22.59 25L20 22.41V18h2v3.59l2 2L22.59 25z"}),React.createElement("path",{d:"M28 6a2 2 0 0 0-2-2h-4V2h-2v2h-8V2h-2v2H6a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h4v-2H6V6h4v2h2V6h8v2h2V6h4v6h2z"}),props.children);});var Event32=/*#__PURE__*/React.forwardRef(function Event32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 6a2 2 0 0 0-2-2h-4V2h-2v2h-8V2h-2v2H6a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h4v-2H6V6h4v2h2V6h8v2h2V6h4v6h2z"}),React.createElement("path",{d:"M21 15l2.55 4.94 5.45.79-4 3.84.99 5.43-4.88-2.56L16 30l1-5.43-4-3.84 5.6-.79L21 15z"}),props.children);});var Event24=/*#__PURE__*/React.forwardRef(function Event24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 6a2 2 0 0 0-2-2h-4V2h-2v2h-8V2h-2v2H6a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h4v-2H6V6h4v2h2V6h8v2h2V6h4v6h2z"}),React.createElement("path",{d:"M21 15l2.55 4.94 5.45.79-4 3.84.99 5.43-4.88-2.56L16 30l1-5.43-4-3.84 5.6-.79L21 15z"}),props.children);});var Event20=/*#__PURE__*/React.forwardRef(function Event20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 6a2 2 0 0 0-2-2h-4V2h-2v2h-8V2h-2v2H6a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h4v-2H6V6h4v2h2V6h8v2h2V6h4v6h2z"}),React.createElement("path",{d:"M21 15l2.55 4.94 5.45.79-4 3.84.99 5.43-4.88-2.56L16 30l1-5.43-4-3.84 5.6-.79L21 15z"}),props.children);});var Event16=/*#__PURE__*/React.forwardRef(function Event16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 6a2 2 0 0 0-2-2h-4V2h-2v2h-8V2h-2v2H6a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h4v-2H6V6h4v2h2V6h8v2h2V6h4v6h2z"}),React.createElement("path",{d:"M21 15l2.55 4.94 5.45.79-4 3.84.99 5.43-4.88-2.56L16 30l1-5.43-4-3.84 5.6-.79L21 15z"}),props.children);});var EventsAlt32=/*#__PURE__*/React.forwardRef(function EventsAlt32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 31h2v-2a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1v2h2v-2a3.003 3.003 0 0 0-3-3h-6a3.003 3.003 0 0 0-3 3zm6-6a4 4 0 1 1 4-4 4.004 4.004 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.003 2.003 0 0 0-2-2zM2 31h2v-2a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1v2h2v-2a3.003 3.003 0 0 0-3-3H5a3.003 3.003 0 0 0-3 3zm6-6a4 4 0 1 1 4-4 4.004 4.004 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2zm10-3h2v-2a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1v2h2v-2a3.003 3.003 0 0 0-3-3h-6a3.003 3.003 0 0 0-3 3zm6-6a4 4 0 1 1 4-4 4.004 4.004 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2zM2 16h2v-2a1.001 1.001 0 0 1 1-1h6a1.001 1.001 0 0 1 1 1v2h2v-2a3.003 3.003 0 0 0-3-3H5a3.003 3.003 0 0 0-3 3zm6-6a4 4 0 1 1 4-4 4.005 4.005 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2z"}),props.children);});var EventsAlt24=/*#__PURE__*/React.forwardRef(function EventsAlt24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 31h2v-2a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1v2h2v-2a3.003 3.003 0 0 0-3-3h-6a3.003 3.003 0 0 0-3 3zm6-6a4 4 0 1 1 4-4 4.004 4.004 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.003 2.003 0 0 0-2-2zM2 31h2v-2a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1v2h2v-2a3.003 3.003 0 0 0-3-3H5a3.003 3.003 0 0 0-3 3zm6-6a4 4 0 1 1 4-4 4.004 4.004 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2zm10-3h2v-2a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1v2h2v-2a3.003 3.003 0 0 0-3-3h-6a3.003 3.003 0 0 0-3 3zm6-6a4 4 0 1 1 4-4 4.004 4.004 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2zM2 16h2v-2a1.001 1.001 0 0 1 1-1h6a1.001 1.001 0 0 1 1 1v2h2v-2a3.003 3.003 0 0 0-3-3H5a3.003 3.003 0 0 0-3 3zm6-6a4 4 0 1 1 4-4 4.005 4.005 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2z"}),props.children);});var EventsAlt20=/*#__PURE__*/React.forwardRef(function EventsAlt20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 31h2v-2a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1v2h2v-2a3.003 3.003 0 0 0-3-3h-6a3.003 3.003 0 0 0-3 3zm6-6a4 4 0 1 1 4-4 4.004 4.004 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.003 2.003 0 0 0-2-2zM2 31h2v-2a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1v2h2v-2a3.003 3.003 0 0 0-3-3H5a3.003 3.003 0 0 0-3 3zm6-6a4 4 0 1 1 4-4 4.004 4.004 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2zm10-3h2v-2a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1v2h2v-2a3.003 3.003 0 0 0-3-3h-6a3.003 3.003 0 0 0-3 3zm6-6a4 4 0 1 1 4-4 4.004 4.004 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2zM2 16h2v-2a1.001 1.001 0 0 1 1-1h6a1.001 1.001 0 0 1 1 1v2h2v-2a3.003 3.003 0 0 0-3-3H5a3.003 3.003 0 0 0-3 3zm6-6a4 4 0 1 1 4-4 4.005 4.005 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2z"}),props.children);});var EventsAlt16=/*#__PURE__*/React.forwardRef(function EventsAlt16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 31h2v-2a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1v2h2v-2a3.003 3.003 0 0 0-3-3h-6a3.003 3.003 0 0 0-3 3zm6-6a4 4 0 1 1 4-4 4.004 4.004 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.003 2.003 0 0 0-2-2zM2 31h2v-2a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1v2h2v-2a3.003 3.003 0 0 0-3-3H5a3.003 3.003 0 0 0-3 3zm6-6a4 4 0 1 1 4-4 4.004 4.004 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2zm10-3h2v-2a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1v2h2v-2a3.003 3.003 0 0 0-3-3h-6a3.003 3.003 0 0 0-3 3zm6-6a4 4 0 1 1 4-4 4.004 4.004 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2zM2 16h2v-2a1.001 1.001 0 0 1 1-1h6a1.001 1.001 0 0 1 1 1v2h2v-2a3.003 3.003 0 0 0-3-3H5a3.003 3.003 0 0 0-3 3zm6-6a4 4 0 1 1 4-4 4.005 4.005 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2z"}),props.children);});var Events32=/*#__PURE__*/React.forwardRef(function Events32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 14h-2v2h2a3.003 3.003 0 0 1 3 3v4h2v-4a5.006 5.006 0 0 0-5-5zM24 4a3 3 0 1 1-3 3 3 3 0 0 1 3-3m0-2a5 5 0 1 0 5 5 5 5 0 0 0-5-5zm-1 28h-2v-2a3.003 3.003 0 0 0-3-3h-4a3.003 3.003 0 0 0-3 3v2H9v-2a5.006 5.006 0 0 1 5-5h4a5.006 5.006 0 0 1 5 5zm-7-17a3 3 0 1 1-3 3 3 3 0 0 1 3-3m0-2a5 5 0 1 0 5 5 5 5 0 0 0-5-5zm-8 3H6a5.006 5.006 0 0 0-5 5v4h2v-4a3.003 3.003 0 0 1 3-3h2zM8 4a3 3 0 1 1-3 3 3 3 0 0 1 3-3m0-2a5 5 0 1 0 5 5 5 5 0 0 0-5-5z"}),props.children);});var Events24=/*#__PURE__*/React.forwardRef(function Events24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 14h-2v2h2a3.003 3.003 0 0 1 3 3v4h2v-4a5.006 5.006 0 0 0-5-5zM24 4a3 3 0 1 1-3 3 3 3 0 0 1 3-3m0-2a5 5 0 1 0 5 5 5 5 0 0 0-5-5zm-1 28h-2v-2a3.003 3.003 0 0 0-3-3h-4a3.003 3.003 0 0 0-3 3v2H9v-2a5.006 5.006 0 0 1 5-5h4a5.006 5.006 0 0 1 5 5zm-7-17a3 3 0 1 1-3 3 3 3 0 0 1 3-3m0-2a5 5 0 1 0 5 5 5 5 0 0 0-5-5zm-8 3H6a5.006 5.006 0 0 0-5 5v4h2v-4a3.003 3.003 0 0 1 3-3h2zM8 4a3 3 0 1 1-3 3 3 3 0 0 1 3-3m0-2a5 5 0 1 0 5 5 5 5 0 0 0-5-5z"}),props.children);});var Events20=/*#__PURE__*/React.forwardRef(function Events20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 14h-2v2h2a3.003 3.003 0 0 1 3 3v4h2v-4a5.006 5.006 0 0 0-5-5zM24 4a3 3 0 1 1-3 3 3 3 0 0 1 3-3m0-2a5 5 0 1 0 5 5 5 5 0 0 0-5-5zm-1 28h-2v-2a3.003 3.003 0 0 0-3-3h-4a3.003 3.003 0 0 0-3 3v2H9v-2a5.006 5.006 0 0 1 5-5h4a5.006 5.006 0 0 1 5 5zm-7-17a3 3 0 1 1-3 3 3 3 0 0 1 3-3m0-2a5 5 0 1 0 5 5 5 5 0 0 0-5-5zm-8 3H6a5.006 5.006 0 0 0-5 5v4h2v-4a3.003 3.003 0 0 1 3-3h2zM8 4a3 3 0 1 1-3 3 3 3 0 0 1 3-3m0-2a5 5 0 1 0 5 5 5 5 0 0 0-5-5z"}),props.children);});var Events16=/*#__PURE__*/React.forwardRef(function Events16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 14h-2v2h2a3.003 3.003 0 0 1 3 3v4h2v-4a5.006 5.006 0 0 0-5-5zM24 4a3 3 0 1 1-3 3 3 3 0 0 1 3-3m0-2a5 5 0 1 0 5 5 5 5 0 0 0-5-5zm-1 28h-2v-2a3.003 3.003 0 0 0-3-3h-4a3.003 3.003 0 0 0-3 3v2H9v-2a5.006 5.006 0 0 1 5-5h4a5.006 5.006 0 0 1 5 5zm-7-17a3 3 0 1 1-3 3 3 3 0 0 1 3-3m0-2a5 5 0 1 0 5 5 5 5 0 0 0-5-5zm-8 3H6a5.006 5.006 0 0 0-5 5v4h2v-4a3.003 3.003 0 0 1 3-3h2zM8 4a3 3 0 1 1-3 3 3 3 0 0 1 3-3m0-2a5 5 0 1 0 5 5 5 5 0 0 0-5-5z"}),props.children);});var ExamMode32=/*#__PURE__*/React.forwardRef(function ExamMode32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 23v3H7v-9.17l3.59 3.58L12 19l-6-6-6 6 1.41 1.41L5 16.83V26a2 2 0 0 0 2 2h18a2 2 0 0 0 2-2v-3zm2-16v9.17l3.59-3.58L32 14l-6 6-6-6 1.41-1.41L25 16.17V7H13V5h12a2 2 0 0 1 2 2zM8 10H4a2 2 0 0 1-2-2V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2zM4 4v4h4V4z"}),props.children);});var ExamMode24=/*#__PURE__*/React.forwardRef(function ExamMode24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 23v3H7v-9.17l3.59 3.58L12 19l-6-6-6 6 1.41 1.41L5 16.83V26a2 2 0 0 0 2 2h18a2 2 0 0 0 2-2v-3zm2-16v9.17l3.59-3.58L32 14l-6 6-6-6 1.41-1.41L25 16.17V7H13V5h12a2 2 0 0 1 2 2zM8 10H4a2 2 0 0 1-2-2V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2zM4 4v4h4V4z"}),props.children);});var ExamMode20=/*#__PURE__*/React.forwardRef(function ExamMode20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 23v3H7v-9.17l3.59 3.58L12 19l-6-6-6 6 1.41 1.41L5 16.83V26a2 2 0 0 0 2 2h18a2 2 0 0 0 2-2v-3zm2-16v9.17l3.59-3.58L32 14l-6 6-6-6 1.41-1.41L25 16.17V7H13V5h12a2 2 0 0 1 2 2zM8 10H4a2 2 0 0 1-2-2V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2zM4 4v4h4V4z"}),props.children);});var ExamMode16=/*#__PURE__*/React.forwardRef(function ExamMode16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 23v3H7v-9.17l3.59 3.58L12 19l-6-6-6 6 1.41 1.41L5 16.83V26a2 2 0 0 0 2 2h18a2 2 0 0 0 2-2v-3zm2-16v9.17l3.59-3.58L32 14l-6 6-6-6 1.41-1.41L25 16.17V7H13V5h12a2 2 0 0 1 2 2zM8 10H4a2 2 0 0 1-2-2V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2zM4 4v4h4V4z"}),props.children);});var Export32=/*#__PURE__*/React.forwardRef(function Export32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 24v4H6v-4H4v4a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2v-4z"}),React.createElement("path",{d:"M6 12l1.41 1.4L15 5.83V25h2V5.83l7.59 7.57L26 12 16 2 6 12z"}),props.children);});var Export24=/*#__PURE__*/React.forwardRef(function Export24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 24v4H6v-4H4v4a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2v-4z"}),React.createElement("path",{d:"M6 12l1.41 1.4L15 5.83V25h2V5.83l7.59 7.57L26 12 16 2 6 12z"}),props.children);});var Export20=/*#__PURE__*/React.forwardRef(function Export20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 24v4H6v-4H4v4a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2v-4z"}),React.createElement("path",{d:"M6 12l1.41 1.4L15 5.83V25h2V5.83l7.59 7.57L26 12 16 2 6 12z"}),props.children);});var Eyedropper32=/*#__PURE__*/React.forwardRef(function Eyedropper32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2 27h3v3H2zM29.71 7.29l-5-5a1 1 0 0 0-1.41 0L20 5.59l-1.29-1.3-1.42 1.42L18.59 7 8.29 17.29A1 1 0 0 0 8 18v1.59l-2.71 2.7a1 1 0 0 0 0 1.41l3 3a1 1 0 0 0 1.41 0l2.71-2.7H14a1 1 0 0 0 .71-.29L25 13.41l1.29 1.3 1.42-1.42-1.3-1.29 3.3-3.29a1 1 0 0 0 0-1.41zM13.59 22h-2L9 24.59 7.41 23 10 20.41v-2l10-10L23.59 12zM25 10.59L21.41 7 24 4.41 27.59 8z"}),props.children);});var Eyedropper24=/*#__PURE__*/React.forwardRef(function Eyedropper24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2 27h3v3H2zM29.71 7.29l-5-5a1 1 0 0 0-1.41 0L20 5.59l-1.29-1.3-1.42 1.42L18.59 7 8.29 17.29A1 1 0 0 0 8 18v1.59l-2.71 2.7a1 1 0 0 0 0 1.41l3 3a1 1 0 0 0 1.41 0l2.71-2.7H14a1 1 0 0 0 .71-.29L25 13.41l1.29 1.3 1.42-1.42-1.3-1.29 3.3-3.29a1 1 0 0 0 0-1.41zM13.59 22h-2L9 24.59 7.41 23 10 20.41v-2l10-10L23.59 12zM25 10.59L21.41 7 24 4.41 27.59 8z"}),props.children);});var Eyedropper20=/*#__PURE__*/React.forwardRef(function Eyedropper20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2 27h3v3H2zM29.71 7.29l-5-5a1 1 0 0 0-1.41 0L20 5.59l-1.29-1.3-1.42 1.42L18.59 7 8.29 17.29A1 1 0 0 0 8 18v1.59l-2.71 2.7a1 1 0 0 0 0 1.41l3 3a1 1 0 0 0 1.41 0l2.71-2.7H14a1 1 0 0 0 .71-.29L25 13.41l1.29 1.3 1.42-1.42-1.3-1.29 3.3-3.29a1 1 0 0 0 0-1.41zM13.59 22h-2L9 24.59 7.41 23 10 20.41v-2l10-10L23.59 12zM25 10.59L21.41 7 24 4.41 27.59 8z"}),props.children);});var Eyedropper16=/*#__PURE__*/React.forwardRef(function Eyedropper16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2 27h3v3H2zM29.71 7.29l-5-5a1 1 0 0 0-1.41 0L20 5.59l-1.29-1.3-1.42 1.42L18.59 7 8.29 17.29A1 1 0 0 0 8 18v1.59l-2.71 2.7a1 1 0 0 0 0 1.41l3 3a1 1 0 0 0 1.41 0l2.71-2.7H14a1 1 0 0 0 .71-.29L25 13.41l1.29 1.3 1.42-1.42-1.3-1.29 3.3-3.29a1 1 0 0 0 0-1.41zM13.59 22h-2L9 24.59 7.41 23 10 20.41v-2l10-10L23.59 12zM25 10.59L21.41 7 24 4.41 27.59 8z"}),props.children);});var FaceActivatedAdd32=/*#__PURE__*/React.forwardRef(function FaceActivatedAdd32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 4h-4V0h-2v4h-4v2h4v4h2V6h4V4zm-18.5 7a2.5 2.5 0 1 0 2.5 2.5 2.48 2.48 0 0 0-2.5-2.5zm9 0a2.5 2.5 0 1 0 2.5 2.5 2.48 2.48 0 0 0-2.5-2.5zM9 20a8.13 8.13 0 0 0 14 0z"}),React.createElement("path",{d:"M27.82 14A12 12 0 1 1 16 4V2a14 14 0 1 0 14 14 14.71 14.71 0 0 0-.16-2z"}),props.children);});var FaceActivatedAdd24=/*#__PURE__*/React.forwardRef(function FaceActivatedAdd24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 4h-4V0h-2v4h-4v2h4v4h2V6h4V4zm-18.5 7a2.5 2.5 0 1 0 2.5 2.5 2.48 2.48 0 0 0-2.5-2.5zm9 0a2.5 2.5 0 1 0 2.5 2.5 2.48 2.48 0 0 0-2.5-2.5zM9 20a8.13 8.13 0 0 0 14 0z"}),React.createElement("path",{d:"M27.82 14A12 12 0 1 1 16 4V2a14 14 0 1 0 14 14 14.71 14.71 0 0 0-.16-2z"}),props.children);});var FaceActivatedAdd20=/*#__PURE__*/React.forwardRef(function FaceActivatedAdd20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 4h-4V0h-2v4h-4v2h4v4h2V6h4V4zm-18.5 7a2.5 2.5 0 1 0 2.5 2.5 2.48 2.48 0 0 0-2.5-2.5zm9 0a2.5 2.5 0 1 0 2.5 2.5 2.48 2.48 0 0 0-2.5-2.5zM9 20a8.13 8.13 0 0 0 14 0z"}),React.createElement("path",{d:"M27.82 14A12 12 0 1 1 16 4V2a14 14 0 1 0 14 14 14.71 14.71 0 0 0-.16-2z"}),props.children);});var FaceActivatedAdd16=/*#__PURE__*/React.forwardRef(function FaceActivatedAdd16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 4h-4V0h-2v4h-4v2h4v4h2V6h4V4zm-18.5 7a2.5 2.5 0 1 0 2.5 2.5 2.48 2.48 0 0 0-2.5-2.5zm9 0a2.5 2.5 0 1 0 2.5 2.5 2.48 2.48 0 0 0-2.5-2.5zM9 20a8.13 8.13 0 0 0 14 0z"}),React.createElement("path",{d:"M27.82 14A12 12 0 1 1 16 4V2a14 14 0 1 0 14 14 14.71 14.71 0 0 0-.16-2z"}),props.children);});var FaceActivatedFilled32=/*#__PURE__*/React.forwardRef(function FaceActivatedFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm-4.5 9A2.5 2.5 0 1 1 9 13.5a2.48 2.48 0 0 1 2.5-2.5zM16 24a8.11 8.11 0 0 1-7-4h14a8.11 8.11 0 0 1-7 4zm4.5-8a2.5 2.5 0 1 1 2.5-2.5 2.48 2.48 0 0 1-2.5 2.5z"}),props.children);});var FaceActivatedFilled24=/*#__PURE__*/React.forwardRef(function FaceActivatedFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm-4.5 9A2.5 2.5 0 1 1 9 13.5a2.48 2.48 0 0 1 2.5-2.5zM16 24a8.11 8.11 0 0 1-7-4h14a8.11 8.11 0 0 1-7 4zm4.5-8a2.5 2.5 0 1 1 2.5-2.5 2.48 2.48 0 0 1-2.5 2.5z"}),props.children);});var FaceActivatedFilled20=/*#__PURE__*/React.forwardRef(function FaceActivatedFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm-4.5 9A2.5 2.5 0 1 1 9 13.5a2.48 2.48 0 0 1 2.5-2.5zM16 24a8.11 8.11 0 0 1-7-4h14a8.11 8.11 0 0 1-7 4zm4.5-8a2.5 2.5 0 1 1 2.5-2.5 2.48 2.48 0 0 1-2.5 2.5z"}),props.children);});var FaceActivatedFilled16=/*#__PURE__*/React.forwardRef(function FaceActivatedFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm-4.5 9A2.5 2.5 0 1 1 9 13.5a2.48 2.48 0 0 1 2.5-2.5zM16 24a8.11 8.11 0 0 1-7-4h14a8.11 8.11 0 0 1-7 4zm4.5-8a2.5 2.5 0 1 1 2.5-2.5 2.48 2.48 0 0 1-2.5 2.5z"}),props.children);});var FaceActivated32=/*#__PURE__*/React.forwardRef(function FaceActivated32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 26a12 12 0 1 1 12-12 12 12 0 0 1-12 12z"}),React.createElement("path",{d:"M11.5 11a2.5 2.5 0 1 0 2.5 2.5 2.48 2.48 0 0 0-2.5-2.5zm9 0a2.5 2.5 0 1 0 2.5 2.5 2.48 2.48 0 0 0-2.5-2.5zM9 20a8.13 8.13 0 0 0 14 0z"}),props.children);});var FaceActivated24=/*#__PURE__*/React.forwardRef(function FaceActivated24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 26a12 12 0 1 1 12-12 12 12 0 0 1-12 12z"}),React.createElement("path",{d:"M11.5 11a2.5 2.5 0 1 0 2.5 2.5 2.48 2.48 0 0 0-2.5-2.5zm9 0a2.5 2.5 0 1 0 2.5 2.5 2.48 2.48 0 0 0-2.5-2.5zM9 20a8.13 8.13 0 0 0 14 0z"}),props.children);});var FaceActivated20=/*#__PURE__*/React.forwardRef(function FaceActivated20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 26a12 12 0 1 1 12-12 12 12 0 0 1-12 12z"}),React.createElement("path",{d:"M11.5 11a2.5 2.5 0 1 0 2.5 2.5 2.48 2.48 0 0 0-2.5-2.5zm9 0a2.5 2.5 0 1 0 2.5 2.5 2.48 2.48 0 0 0-2.5-2.5zM9 20a8.13 8.13 0 0 0 14 0z"}),props.children);});var FaceActivated16=/*#__PURE__*/React.forwardRef(function FaceActivated16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 26a12 12 0 1 1 12-12 12 12 0 0 1-12 12z"}),React.createElement("path",{d:"M11.5 11a2.5 2.5 0 1 0 2.5 2.5 2.48 2.48 0 0 0-2.5-2.5zm9 0a2.5 2.5 0 1 0 2.5 2.5 2.48 2.48 0 0 0-2.5-2.5zM9 20a8.13 8.13 0 0 0 14 0z"}),props.children);});var FaceAdd32=/*#__PURE__*/React.forwardRef(function FaceAdd32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 22a6 6 0 0 1-5.14-2.92l-1.71 1a8 8 0 0 0 13.7 0l-1.71-1A6 6 0 0 1 16 22zM30 4h-4V0h-2v4h-4v2h4v4h2V6h4V4zm-18.5 7a2.5 2.5 0 1 0 2.5 2.5 2.48 2.48 0 0 0-2.5-2.5zm9 0a2.5 2.5 0 1 0 2.5 2.5 2.48 2.48 0 0 0-2.5-2.5z"}),React.createElement("path",{d:"M27.61 13a12.33 12.33 0 0 1 .39 3A12 12 0 1 1 16 4V2a14 14 0 1 0 13.67 11z"}),props.children);});var FaceAdd24=/*#__PURE__*/React.forwardRef(function FaceAdd24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 22a6 6 0 0 1-5.14-2.92l-1.71 1a8 8 0 0 0 13.7 0l-1.71-1A6 6 0 0 1 16 22zM30 4h-4V0h-2v4h-4v2h4v4h2V6h4V4zm-18.5 7a2.5 2.5 0 1 0 2.5 2.5 2.48 2.48 0 0 0-2.5-2.5zm9 0a2.5 2.5 0 1 0 2.5 2.5 2.48 2.48 0 0 0-2.5-2.5z"}),React.createElement("path",{d:"M27.61 13a12.33 12.33 0 0 1 .39 3A12 12 0 1 1 16 4V2a14 14 0 1 0 13.67 11z"}),props.children);});var FaceAdd20=/*#__PURE__*/React.forwardRef(function FaceAdd20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 22a6 6 0 0 1-5.14-2.92l-1.71 1a8 8 0 0 0 13.7 0l-1.71-1A6 6 0 0 1 16 22zM30 4h-4V0h-2v4h-4v2h4v4h2V6h4V4zm-18.5 7a2.5 2.5 0 1 0 2.5 2.5 2.48 2.48 0 0 0-2.5-2.5zm9 0a2.5 2.5 0 1 0 2.5 2.5 2.48 2.48 0 0 0-2.5-2.5z"}),React.createElement("path",{d:"M27.61 13a12.33 12.33 0 0 1 .39 3A12 12 0 1 1 16 4V2a14 14 0 1 0 13.67 11z"}),props.children);});var FaceAdd16=/*#__PURE__*/React.forwardRef(function FaceAdd16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 22a6 6 0 0 1-5.14-2.92l-1.71 1a8 8 0 0 0 13.7 0l-1.71-1A6 6 0 0 1 16 22zM30 4h-4V0h-2v4h-4v2h4v4h2V6h4V4zm-18.5 7a2.5 2.5 0 1 0 2.5 2.5 2.48 2.48 0 0 0-2.5-2.5zm9 0a2.5 2.5 0 1 0 2.5 2.5 2.48 2.48 0 0 0-2.5-2.5z"}),React.createElement("path",{d:"M27.61 13a12.33 12.33 0 0 1 .39 3A12 12 0 1 1 16 4V2a14 14 0 1 0 13.67 11z"}),props.children);});var FaceCool32=/*#__PURE__*/React.forwardRef(function FaceCool32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 24a8 8 0 0 0 6.85-3.89l-1.71-1a6 6 0 0 1-10.28 0l-1.71 1A8 8 0 0 0 16 24z"}),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 2a12 12 0 0 1 10.89 7H25a1 1 0 0 0-1-1H8a1 1 0 0 0-1 1H5.11A12 12 0 0 1 16 4zm0 24A12 12 0 0 1 4 16a11.86 11.86 0 0 1 .4-3H7v2a2 2 0 0 0 2 2h3.31a2 2 0 0 0 2-1.67l.52-3.33h2.34l.55 3.33a2 2 0 0 0 2 1.67H23a2 2 0 0 0 2-2v-2h2.6a11.86 11.86 0 0 1 .4 3 12 12 0 0 1-12 12z"}),props.children);});var FaceCool24=/*#__PURE__*/React.forwardRef(function FaceCool24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 24a8 8 0 0 0 6.85-3.89l-1.71-1a6 6 0 0 1-10.28 0l-1.71 1A8 8 0 0 0 16 24z"}),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 2a12 12 0 0 1 10.89 7H25a1 1 0 0 0-1-1H8a1 1 0 0 0-1 1H5.11A12 12 0 0 1 16 4zm0 24A12 12 0 0 1 4 16a11.86 11.86 0 0 1 .4-3H7v2a2 2 0 0 0 2 2h3.31a2 2 0 0 0 2-1.67l.52-3.33h2.34l.55 3.33a2 2 0 0 0 2 1.67H23a2 2 0 0 0 2-2v-2h2.6a11.86 11.86 0 0 1 .4 3 12 12 0 0 1-12 12z"}),props.children);});var FaceCool20=/*#__PURE__*/React.forwardRef(function FaceCool20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 24a8 8 0 0 0 6.85-3.89l-1.71-1a6 6 0 0 1-10.28 0l-1.71 1A8 8 0 0 0 16 24z"}),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 2a12 12 0 0 1 10.89 7H25a1 1 0 0 0-1-1H8a1 1 0 0 0-1 1H5.11A12 12 0 0 1 16 4zm0 24A12 12 0 0 1 4 16a11.86 11.86 0 0 1 .4-3H7v2a2 2 0 0 0 2 2h3.31a2 2 0 0 0 2-1.67l.52-3.33h2.34l.55 3.33a2 2 0 0 0 2 1.67H23a2 2 0 0 0 2-2v-2h2.6a11.86 11.86 0 0 1 .4 3 12 12 0 0 1-12 12z"}),props.children);});var FaceCool16=/*#__PURE__*/React.forwardRef(function FaceCool16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 24a8 8 0 0 0 6.85-3.89l-1.71-1a6 6 0 0 1-10.28 0l-1.71 1A8 8 0 0 0 16 24z"}),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 2a12 12 0 0 1 10.89 7H25a1 1 0 0 0-1-1H8a1 1 0 0 0-1 1H5.11A12 12 0 0 1 16 4zm0 24A12 12 0 0 1 4 16a11.86 11.86 0 0 1 .4-3H7v2a2 2 0 0 0 2 2h3.31a2 2 0 0 0 2-1.67l.52-3.33h2.34l.55 3.33a2 2 0 0 0 2 1.67H23a2 2 0 0 0 2-2v-2h2.6a11.86 11.86 0 0 1 .4 3 12 12 0 0 1-12 12z"}),props.children);});var FaceDissatisfiedFilled32=/*#__PURE__*/React.forwardRef(function FaceDissatisfiedFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm-4.5 9A2.5 2.5 0 1 1 9 13.5a2.48 2.48 0 0 1 2.54-2.5zm9.64 12.92a6 6 0 0 0-10.28 0l-1.71-1a8 8 0 0 1 13.7 0zM20.5 16a2.5 2.5 0 0 1 0-5 2.5 2.5 0 0 1 0 5z"}),props.children);});var FaceDissatisfiedFilled24=/*#__PURE__*/React.forwardRef(function FaceDissatisfiedFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm-4.5 9A2.5 2.5 0 1 1 9 13.5a2.48 2.48 0 0 1 2.54-2.5zm9.64 12.92a6 6 0 0 0-10.28 0l-1.71-1a8 8 0 0 1 13.7 0zM20.5 16a2.5 2.5 0 0 1 0-5 2.5 2.5 0 0 1 0 5z"}),props.children);});var FaceDissatisfiedFilled20=/*#__PURE__*/React.forwardRef(function FaceDissatisfiedFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm-4.5 9A2.5 2.5 0 1 1 9 13.5a2.48 2.48 0 0 1 2.54-2.5zm9.64 12.92a6 6 0 0 0-10.28 0l-1.71-1a8 8 0 0 1 13.7 0zM20.5 16a2.5 2.5 0 0 1 0-5 2.5 2.5 0 0 1 0 5z"}),props.children);});var FaceDissatisfiedFilled16=/*#__PURE__*/React.forwardRef(function FaceDissatisfiedFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm-4.5 9A2.5 2.5 0 1 1 9 13.5a2.48 2.48 0 0 1 2.54-2.5zm9.64 12.92a6 6 0 0 0-10.28 0l-1.71-1a8 8 0 0 1 13.7 0zM20.5 16a2.5 2.5 0 0 1 0-5 2.5 2.5 0 0 1 0 5z"}),props.children);});var FaceDissatisfied32=/*#__PURE__*/React.forwardRef(function FaceDissatisfied32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 26a12 12 0 1 1 12-12 12 12 0 0 1-12 12z"}),React.createElement("path",{d:"M11.5 11a2.5 2.5 0 1 0 2.5 2.5 2.5 2.5 0 0 0-2.5-2.5zm9 0a2.5 2.5 0 1 0 2.5 2.5 2.5 2.5 0 0 0-2.5-2.5zM16 19a8 8 0 0 0-6.85 3.89l1.71 1a6 6 0 0 1 10.28 0l1.71-1A8 8 0 0 0 16 19z"}),props.children);});var FaceDissatisfied24=/*#__PURE__*/React.forwardRef(function FaceDissatisfied24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 26a12 12 0 1 1 12-12 12 12 0 0 1-12 12z"}),React.createElement("path",{d:"M11.5 11a2.5 2.5 0 1 0 2.5 2.5 2.5 2.5 0 0 0-2.5-2.5zm9 0a2.5 2.5 0 1 0 2.5 2.5 2.5 2.5 0 0 0-2.5-2.5zM16 19a8 8 0 0 0-6.85 3.89l1.71 1a6 6 0 0 1 10.28 0l1.71-1A8 8 0 0 0 16 19z"}),props.children);});var FaceDissatisfied20=/*#__PURE__*/React.forwardRef(function FaceDissatisfied20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 26a12 12 0 1 1 12-12 12 12 0 0 1-12 12z"}),React.createElement("path",{d:"M11.5 11a2.5 2.5 0 1 0 2.5 2.5 2.5 2.5 0 0 0-2.5-2.5zm9 0a2.5 2.5 0 1 0 2.5 2.5 2.5 2.5 0 0 0-2.5-2.5zM16 19a8 8 0 0 0-6.85 3.89l1.71 1a6 6 0 0 1 10.28 0l1.71-1A8 8 0 0 0 16 19z"}),props.children);});var FaceDissatisfied16=/*#__PURE__*/React.forwardRef(function FaceDissatisfied16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 26a12 12 0 1 1 12-12 12 12 0 0 1-12 12z"}),React.createElement("path",{d:"M11.5 11a2.5 2.5 0 1 0 2.5 2.5 2.5 2.5 0 0 0-2.5-2.5zm9 0a2.5 2.5 0 1 0 2.5 2.5 2.5 2.5 0 0 0-2.5-2.5zM16 19a8 8 0 0 0-6.85 3.89l1.71 1a6 6 0 0 1 10.28 0l1.71-1A8 8 0 0 0 16 19z"}),props.children);});var FaceDizzyFilled32=/*#__PURE__*/React.forwardRef(function FaceDizzyFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zM9 16.41L7.59 15l2-2-2-2L9 9.59l2 2 2-2L14.41 11l-2 2 2 2L13 16.41l-2-2zM16 25a3 3 0 1 1 3-3 3 3 0 0 1-3 3zm8.41-10L23 16.41l-2-2-2 2L17.59 15l2-2-2-2L19 9.59l2 2 2-2L24.41 11l-2 2z"}),props.children);});var FaceDizzyFilled24=/*#__PURE__*/React.forwardRef(function FaceDizzyFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zM9 16.41L7.59 15l2-2-2-2L9 9.59l2 2 2-2L14.41 11l-2 2 2 2L13 16.41l-2-2zM16 25a3 3 0 1 1 3-3 3 3 0 0 1-3 3zm8.41-10L23 16.41l-2-2-2 2L17.59 15l2-2-2-2L19 9.59l2 2 2-2L24.41 11l-2 2z"}),props.children);});var FaceDizzyFilled20=/*#__PURE__*/React.forwardRef(function FaceDizzyFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zM9 16.41L7.59 15l2-2-2-2L9 9.59l2 2 2-2L14.41 11l-2 2 2 2L13 16.41l-2-2zM16 25a3 3 0 1 1 3-3 3 3 0 0 1-3 3zm8.41-10L23 16.41l-2-2-2 2L17.59 15l2-2-2-2L19 9.59l2 2 2-2L24.41 11l-2 2z"}),props.children);});var FaceDizzyFilled16=/*#__PURE__*/React.forwardRef(function FaceDizzyFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zM9 16.41L7.59 15l2-2-2-2L9 9.59l2 2 2-2L14.41 11l-2 2 2 2L13 16.41l-2-2zM16 25a3 3 0 1 1 3-3 3 3 0 0 1-3 3zm8.41-10L23 16.41l-2-2-2 2L17.59 15l2-2-2-2L19 9.59l2 2 2-2L24.41 11l-2 2z"}),props.children);});var FaceDizzy32=/*#__PURE__*/React.forwardRef(function FaceDizzy32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 26a12 12 0 1 1 12-12 12 12 0 0 1-12 12z"}),React.createElement("path",{d:"M24.41 11L23 9.59l-2 2-2-2L17.59 11l2 2-2 2L19 16.41l2-2 2 2L24.41 15l-2-2 2-2zm-10 0L13 9.59l-2 2-2-2L7.59 11l2 2-2 2L9 16.41l2-2 2 2L14.41 15l-2-2 2-2zM16 19a3 3 0 1 0 3 3 3 3 0 0 0-3-3z"}),props.children);});var FaceDizzy24=/*#__PURE__*/React.forwardRef(function FaceDizzy24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 26a12 12 0 1 1 12-12 12 12 0 0 1-12 12z"}),React.createElement("path",{d:"M24.41 11L23 9.59l-2 2-2-2L17.59 11l2 2-2 2L19 16.41l2-2 2 2L24.41 15l-2-2 2-2zm-10 0L13 9.59l-2 2-2-2L7.59 11l2 2-2 2L9 16.41l2-2 2 2L14.41 15l-2-2 2-2zM16 19a3 3 0 1 0 3 3 3 3 0 0 0-3-3z"}),props.children);});var FaceDizzy20=/*#__PURE__*/React.forwardRef(function FaceDizzy20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 26a12 12 0 1 1 12-12 12 12 0 0 1-12 12z"}),React.createElement("path",{d:"M24.41 11L23 9.59l-2 2-2-2L17.59 11l2 2-2 2L19 16.41l2-2 2 2L24.41 15l-2-2 2-2zm-10 0L13 9.59l-2 2-2-2L7.59 11l2 2-2 2L9 16.41l2-2 2 2L14.41 15l-2-2 2-2zM16 19a3 3 0 1 0 3 3 3 3 0 0 0-3-3z"}),props.children);});var FaceDizzy16=/*#__PURE__*/React.forwardRef(function FaceDizzy16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 26a12 12 0 1 1 12-12 12 12 0 0 1-12 12z"}),React.createElement("path",{d:"M24.41 11L23 9.59l-2 2-2-2L17.59 11l2 2-2 2L19 16.41l2-2 2 2L24.41 15l-2-2 2-2zm-10 0L13 9.59l-2 2-2-2L7.59 11l2 2-2 2L9 16.41l2-2 2 2L14.41 15l-2-2 2-2zM16 19a3 3 0 1 0 3 3 3 3 0 0 0-3-3z"}),props.children);});var FaceNeutralFilled32=/*#__PURE__*/React.forwardRef(function FaceNeutralFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zM9 13.5a2.5 2.5 0 1 1 2.5 2.5A2.5 2.5 0 0 1 9 13.5zM22 22H10v-2h12zm-1.5-6a2.5 2.5 0 1 1 2.5-2.5 2.5 2.5 0 0 1-2.5 2.5z"}),props.children);});var FaceNeutralFilled24=/*#__PURE__*/React.forwardRef(function FaceNeutralFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zM9 13.5a2.5 2.5 0 1 1 2.5 2.5A2.5 2.5 0 0 1 9 13.5zM22 22H10v-2h12zm-1.5-6a2.5 2.5 0 1 1 2.5-2.5 2.5 2.5 0 0 1-2.5 2.5z"}),props.children);});var FaceNeutralFilled20=/*#__PURE__*/React.forwardRef(function FaceNeutralFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zM9 13.5a2.5 2.5 0 1 1 2.5 2.5A2.5 2.5 0 0 1 9 13.5zM22 22H10v-2h12zm-1.5-6a2.5 2.5 0 1 1 2.5-2.5 2.5 2.5 0 0 1-2.5 2.5z"}),props.children);});var FaceNeutralFilled16=/*#__PURE__*/React.forwardRef(function FaceNeutralFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zM9 13.5a2.5 2.5 0 1 1 2.5 2.5A2.5 2.5 0 0 1 9 13.5zM22 22H10v-2h12zm-1.5-6a2.5 2.5 0 1 1 2.5-2.5 2.5 2.5 0 0 1-2.5 2.5z"}),props.children);});var FaceNeutral32=/*#__PURE__*/React.forwardRef(function FaceNeutral32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 26a12 12 0 1 1 12-12 12 12 0 0 1-12 12z"}),React.createElement("path",{d:"M11.5 11a2.5 2.5 0 1 0 2.5 2.5 2.5 2.5 0 0 0-2.5-2.5zm9 0a2.5 2.5 0 1 0 2.5 2.5 2.5 2.5 0 0 0-2.5-2.5zM10 20h12v2H10z"}),props.children);});var FaceNeutral24=/*#__PURE__*/React.forwardRef(function FaceNeutral24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 26a12 12 0 1 1 12-12 12 12 0 0 1-12 12z"}),React.createElement("path",{d:"M11.5 11a2.5 2.5 0 1 0 2.5 2.5 2.5 2.5 0 0 0-2.5-2.5zm9 0a2.5 2.5 0 1 0 2.5 2.5 2.5 2.5 0 0 0-2.5-2.5zM10 20h12v2H10z"}),props.children);});var FaceNeutral20=/*#__PURE__*/React.forwardRef(function FaceNeutral20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 26a12 12 0 1 1 12-12 12 12 0 0 1-12 12z"}),React.createElement("path",{d:"M11.5 11a2.5 2.5 0 1 0 2.5 2.5 2.5 2.5 0 0 0-2.5-2.5zm9 0a2.5 2.5 0 1 0 2.5 2.5 2.5 2.5 0 0 0-2.5-2.5zM10 20h12v2H10z"}),props.children);});var FaceNeutral16=/*#__PURE__*/React.forwardRef(function FaceNeutral16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 26a12 12 0 1 1 12-12 12 12 0 0 1-12 12z"}),React.createElement("path",{d:"M11.5 11a2.5 2.5 0 1 0 2.5 2.5 2.5 2.5 0 0 0-2.5-2.5zm9 0a2.5 2.5 0 1 0 2.5 2.5 2.5 2.5 0 0 0-2.5-2.5zM10 20h12v2H10z"}),props.children);});var FacePendingFilled32=/*#__PURE__*/React.forwardRef(function FacePendingFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm-4.5 14a2.5 2.5 0 1 1 2.5-2.5 2.48 2.48 0 0 1-2.5 2.5zm9 0a2.5 2.5 0 1 1 2.5-2.5 2.48 2.48 0 0 1-2.5 2.5z"}),props.children);});var FacePendingFilled24=/*#__PURE__*/React.forwardRef(function FacePendingFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm-4.5 14a2.5 2.5 0 1 1 2.5-2.5 2.48 2.48 0 0 1-2.5 2.5zm9 0a2.5 2.5 0 1 1 2.5-2.5 2.48 2.48 0 0 1-2.5 2.5z"}),props.children);});var FacePendingFilled20=/*#__PURE__*/React.forwardRef(function FacePendingFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm-4.5 14a2.5 2.5 0 1 1 2.5-2.5 2.48 2.48 0 0 1-2.5 2.5zm9 0a2.5 2.5 0 1 1 2.5-2.5 2.48 2.48 0 0 1-2.5 2.5z"}),props.children);});var FacePendingFilled16=/*#__PURE__*/React.forwardRef(function FacePendingFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm-4.5 14a2.5 2.5 0 1 1 2.5-2.5 2.48 2.48 0 0 1-2.5 2.5zm9 0a2.5 2.5 0 1 1 2.5-2.5 2.48 2.48 0 0 1-2.5 2.5z"}),props.children);});var FacePending32=/*#__PURE__*/React.forwardRef(function FacePending32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 26a12 12 0 1 1 12-12 12 12 0 0 1-12 12z"}),React.createElement("path",{d:"M11.5 11a2.5 2.5 0 1 0 2.5 2.5 2.48 2.48 0 0 0-2.5-2.5zm9 0a2.5 2.5 0 1 0 2.5 2.5 2.48 2.48 0 0 0-2.5-2.5z"}),props.children);});var FacePending24=/*#__PURE__*/React.forwardRef(function FacePending24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 26a12 12 0 1 1 12-12 12 12 0 0 1-12 12z"}),React.createElement("path",{d:"M11.5 11a2.5 2.5 0 1 0 2.5 2.5 2.48 2.48 0 0 0-2.5-2.5zm9 0a2.5 2.5 0 1 0 2.5 2.5 2.48 2.48 0 0 0-2.5-2.5z"}),props.children);});var FacePending20=/*#__PURE__*/React.forwardRef(function FacePending20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 26a12 12 0 1 1 12-12 12 12 0 0 1-12 12z"}),React.createElement("path",{d:"M11.5 11a2.5 2.5 0 1 0 2.5 2.5 2.48 2.48 0 0 0-2.5-2.5zm9 0a2.5 2.5 0 1 0 2.5 2.5 2.48 2.48 0 0 0-2.5-2.5z"}),props.children);});var FacePending16=/*#__PURE__*/React.forwardRef(function FacePending16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 26a12 12 0 1 1 12-12 12 12 0 0 1-12 12z"}),React.createElement("path",{d:"M11.5 11a2.5 2.5 0 1 0 2.5 2.5 2.48 2.48 0 0 0-2.5-2.5zm9 0a2.5 2.5 0 1 0 2.5 2.5 2.48 2.48 0 0 0-2.5-2.5z"}),props.children);});var FaceSatisfiedFilled32=/*#__PURE__*/React.forwardRef(function FaceSatisfiedFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm-4.5 9A2.5 2.5 0 1 1 9 13.5a2.48 2.48 0 0 1 2.5-2.5zM16 24a8 8 0 0 1-6.85-3.89l1.71-1a6 6 0 0 0 10.28 0l1.71 1A8 8 0 0 1 16 24zm4.5-8a2.5 2.5 0 1 1 2.5-2.5 2.48 2.48 0 0 1-2.5 2.5z"}),props.children);});var FaceSatisfiedFilled24=/*#__PURE__*/React.forwardRef(function FaceSatisfiedFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm-4.5 9A2.5 2.5 0 1 1 9 13.5a2.48 2.48 0 0 1 2.5-2.5zM16 24a8 8 0 0 1-6.85-3.89l1.71-1a6 6 0 0 0 10.28 0l1.71 1A8 8 0 0 1 16 24zm4.5-8a2.5 2.5 0 1 1 2.5-2.5 2.48 2.48 0 0 1-2.5 2.5z"}),props.children);});var FaceSatisfiedFilled20=/*#__PURE__*/React.forwardRef(function FaceSatisfiedFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm-4.5 9A2.5 2.5 0 1 1 9 13.5a2.48 2.48 0 0 1 2.5-2.5zM16 24a8 8 0 0 1-6.85-3.89l1.71-1a6 6 0 0 0 10.28 0l1.71 1A8 8 0 0 1 16 24zm4.5-8a2.5 2.5 0 1 1 2.5-2.5 2.48 2.48 0 0 1-2.5 2.5z"}),props.children);});var FaceSatisfiedFilled16=/*#__PURE__*/React.forwardRef(function FaceSatisfiedFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm-4.5 9A2.5 2.5 0 1 1 9 13.5a2.48 2.48 0 0 1 2.5-2.5zM16 24a8 8 0 0 1-6.85-3.89l1.71-1a6 6 0 0 0 10.28 0l1.71 1A8 8 0 0 1 16 24zm4.5-8a2.5 2.5 0 1 1 2.5-2.5 2.48 2.48 0 0 1-2.5 2.5z"}),props.children);});var FaceSatisfied32=/*#__PURE__*/React.forwardRef(function FaceSatisfied32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 26a12 12 0 1 1 12-12 12 12 0 0 1-12 12z"}),React.createElement("path",{d:"M11.5 11a2.5 2.5 0 1 0 2.5 2.5 2.48 2.48 0 0 0-2.5-2.5zm9 0a2.5 2.5 0 1 0 2.5 2.5 2.48 2.48 0 0 0-2.5-2.5zM16 24a8 8 0 0 0 6.85-3.89l-1.71-1a6 6 0 0 1-10.28 0l-1.71 1A8 8 0 0 0 16 24z"}),props.children);});var FaceSatisfied24=/*#__PURE__*/React.forwardRef(function FaceSatisfied24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 26a12 12 0 1 1 12-12 12 12 0 0 1-12 12z"}),React.createElement("path",{d:"M11.5 11a2.5 2.5 0 1 0 2.5 2.5 2.48 2.48 0 0 0-2.5-2.5zm9 0a2.5 2.5 0 1 0 2.5 2.5 2.48 2.48 0 0 0-2.5-2.5zM16 24a8 8 0 0 0 6.85-3.89l-1.71-1a6 6 0 0 1-10.28 0l-1.71 1A8 8 0 0 0 16 24z"}),props.children);});var FaceSatisfied20=/*#__PURE__*/React.forwardRef(function FaceSatisfied20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 26a12 12 0 1 1 12-12 12 12 0 0 1-12 12z"}),React.createElement("path",{d:"M11.5 11a2.5 2.5 0 1 0 2.5 2.5 2.48 2.48 0 0 0-2.5-2.5zm9 0a2.5 2.5 0 1 0 2.5 2.5 2.48 2.48 0 0 0-2.5-2.5zM16 24a8 8 0 0 0 6.85-3.89l-1.71-1a6 6 0 0 1-10.28 0l-1.71 1A8 8 0 0 0 16 24z"}),props.children);});var FaceSatisfied16=/*#__PURE__*/React.forwardRef(function FaceSatisfied16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 26a12 12 0 1 1 12-12 12 12 0 0 1-12 12z"}),React.createElement("path",{d:"M11.5 11a2.5 2.5 0 1 0 2.5 2.5 2.48 2.48 0 0 0-2.5-2.5zm9 0a2.5 2.5 0 1 0 2.5 2.5 2.48 2.48 0 0 0-2.5-2.5zM16 24a8 8 0 0 0 6.85-3.89l-1.71-1a6 6 0 0 1-10.28 0l-1.71 1A8 8 0 0 0 16 24z"}),props.children);});var FaceWinkFilled32=/*#__PURE__*/React.forwardRef(function FaceWinkFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zM8 13h6v2H8zm8 11a8 8 0 0 1-6.85-3.89l1.71-1a6 6 0 0 0 10.28 0l1.71 1A8 8 0 0 1 16 24zm4.5-8a2.5 2.5 0 0 1 0-5 2.5 2.5 0 0 1 0 5z"}),props.children);});var FaceWinkFilled24=/*#__PURE__*/React.forwardRef(function FaceWinkFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zM8 13h6v2H8zm8 11a8 8 0 0 1-6.85-3.89l1.71-1a6 6 0 0 0 10.28 0l1.71 1A8 8 0 0 1 16 24zm4.5-8a2.5 2.5 0 0 1 0-5 2.5 2.5 0 0 1 0 5z"}),props.children);});var FaceWinkFilled20=/*#__PURE__*/React.forwardRef(function FaceWinkFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zM8 13h6v2H8zm8 11a8 8 0 0 1-6.85-3.89l1.71-1a6 6 0 0 0 10.28 0l1.71 1A8 8 0 0 1 16 24zm4.5-8a2.5 2.5 0 0 1 0-5 2.5 2.5 0 0 1 0 5z"}),props.children);});var FaceWinkFilled16=/*#__PURE__*/React.forwardRef(function FaceWinkFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zM8 13h6v2H8zm8 11a8 8 0 0 1-6.85-3.89l1.71-1a6 6 0 0 0 10.28 0l1.71 1A8 8 0 0 1 16 24zm4.5-8a2.5 2.5 0 0 1 0-5 2.5 2.5 0 0 1 0 5z"}),props.children);});var FaceWink32=/*#__PURE__*/React.forwardRef(function FaceWink32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 26a12 12 0 1 1 12-12 12 12 0 0 1-12 12z"}),React.createElement("path",{d:"M20.5 11a2.5 2.5 0 1 0 2.5 2.5 2.5 2.5 0 0 0-2.5-2.5zM8 13h6v2H8zm8 11a8 8 0 0 0 6.85-3.89l-1.71-1a6 6 0 0 1-10.28 0l-1.71 1A8 8 0 0 0 16 24z"}),props.children);});var FaceWink24=/*#__PURE__*/React.forwardRef(function FaceWink24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 26a12 12 0 1 1 12-12 12 12 0 0 1-12 12z"}),React.createElement("path",{d:"M20.5 11a2.5 2.5 0 1 0 2.5 2.5 2.5 2.5 0 0 0-2.5-2.5zM8 13h6v2H8zm8 11a8 8 0 0 0 6.85-3.89l-1.71-1a6 6 0 0 1-10.28 0l-1.71 1A8 8 0 0 0 16 24z"}),props.children);});var FaceWink20=/*#__PURE__*/React.forwardRef(function FaceWink20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 26a12 12 0 1 1 12-12 12 12 0 0 1-12 12z"}),React.createElement("path",{d:"M20.5 11a2.5 2.5 0 1 0 2.5 2.5 2.5 2.5 0 0 0-2.5-2.5zM8 13h6v2H8zm8 11a8 8 0 0 0 6.85-3.89l-1.71-1a6 6 0 0 1-10.28 0l-1.71 1A8 8 0 0 0 16 24z"}),props.children);});var FaceWink16=/*#__PURE__*/React.forwardRef(function FaceWink16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 26a12 12 0 1 1 12-12 12 12 0 0 1-12 12z"}),React.createElement("path",{d:"M20.5 11a2.5 2.5 0 1 0 2.5 2.5 2.5 2.5 0 0 0-2.5-2.5zM8 13h6v2H8zm8 11a8 8 0 0 0 6.85-3.89l-1.71-1a6 6 0 0 1-10.28 0l-1.71 1A8 8 0 0 0 16 24z"}),props.children);});var Fade32=/*#__PURE__*/React.forwardRef(function Fade32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8.24 25.14L7 26.67a13.79 13.79 0 0 0 4.18 2.44l.69-1.87a12 12 0 0 1-3.63-2.1zM4.19 18l-2 .41A14.09 14.09 0 0 0 3.86 23l1.73-1a12.44 12.44 0 0 1-1.4-4zm7.63-13.24l-.69-1.87A13.79 13.79 0 0 0 7 5.33l1.24 1.53a12 12 0 0 1 3.58-2.1zM5.59 10L3.86 9a14.37 14.37 0 0 0-1.64 4.59l2 .34A12.05 12.05 0 0 1 5.59 10zM16 2v2a12 12 0 0 1 0 24v2a14 14 0 0 0 0-28z"}),props.children);});var Fade24=/*#__PURE__*/React.forwardRef(function Fade24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8.24 25.14L7 26.67a13.79 13.79 0 0 0 4.18 2.44l.69-1.87a12 12 0 0 1-3.63-2.1zM4.19 18l-2 .41A14.09 14.09 0 0 0 3.86 23l1.73-1a12.44 12.44 0 0 1-1.4-4zm7.63-13.24l-.69-1.87A13.79 13.79 0 0 0 7 5.33l1.24 1.53a12 12 0 0 1 3.58-2.1zM5.59 10L3.86 9a14.37 14.37 0 0 0-1.64 4.59l2 .34A12.05 12.05 0 0 1 5.59 10zM16 2v2a12 12 0 0 1 0 24v2a14 14 0 0 0 0-28z"}),props.children);});var Fade20=/*#__PURE__*/React.forwardRef(function Fade20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8.24 25.14L7 26.67a13.79 13.79 0 0 0 4.18 2.44l.69-1.87a12 12 0 0 1-3.63-2.1zM4.19 18l-2 .41A14.09 14.09 0 0 0 3.86 23l1.73-1a12.44 12.44 0 0 1-1.4-4zm7.63-13.24l-.69-1.87A13.79 13.79 0 0 0 7 5.33l1.24 1.53a12 12 0 0 1 3.58-2.1zM5.59 10L3.86 9a14.37 14.37 0 0 0-1.64 4.59l2 .34A12.05 12.05 0 0 1 5.59 10zM16 2v2a12 12 0 0 1 0 24v2a14 14 0 0 0 0-28z"}),props.children);});var FavoriteFilled32=/*#__PURE__*/React.forwardRef(function FavoriteFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22.45 4a7.47 7.47 0 0 0-5.34 2.24L16 7.36l-1.11-1.12a7.49 7.49 0 0 0-10.68 0 7.72 7.72 0 0 0 0 10.82L16 29l11.79-11.94a7.72 7.72 0 0 0 0-10.82A7.49 7.49 0 0 0 22.45 4z"}),props.children);});var FavoriteFilled24=/*#__PURE__*/React.forwardRef(function FavoriteFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22.45 4a7.47 7.47 0 0 0-5.34 2.24L16 7.36l-1.11-1.12a7.49 7.49 0 0 0-10.68 0 7.72 7.72 0 0 0 0 10.82L16 29l11.79-11.94a7.72 7.72 0 0 0 0-10.82A7.49 7.49 0 0 0 22.45 4z"}),props.children);});var FavoriteFilled20=/*#__PURE__*/React.forwardRef(function FavoriteFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22.45 4a7.47 7.47 0 0 0-5.34 2.24L16 7.36l-1.11-1.12a7.49 7.49 0 0 0-10.68 0 7.72 7.72 0 0 0 0 10.82L16 29l11.79-11.94a7.72 7.72 0 0 0 0-10.82A7.49 7.49 0 0 0 22.45 4z"}),props.children);});var Favorite32=/*#__PURE__*/React.forwardRef(function Favorite32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22.45 6a5.47 5.47 0 0 1 3.91 1.64 5.7 5.7 0 0 1 0 8L16 26.13 5.64 15.64a5.7 5.7 0 0 1 0-8 5.48 5.48 0 0 1 7.82 0l2.54 2.6 2.53-2.58A5.44 5.44 0 0 1 22.45 6m0-2a7.47 7.47 0 0 0-5.34 2.24L16 7.36l-1.11-1.12a7.49 7.49 0 0 0-10.68 0 7.72 7.72 0 0 0 0 10.82L16 29l11.79-11.94a7.72 7.72 0 0 0 0-10.82A7.49 7.49 0 0 0 22.45 4z"}),props.children);});var Favorite24=/*#__PURE__*/React.forwardRef(function Favorite24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22.45 6a5.47 5.47 0 0 1 3.91 1.64 5.7 5.7 0 0 1 0 8L16 26.13 5.64 15.64a5.7 5.7 0 0 1 0-8 5.48 5.48 0 0 1 7.82 0l2.54 2.6 2.53-2.58A5.44 5.44 0 0 1 22.45 6m0-2a7.47 7.47 0 0 0-5.34 2.24L16 7.36l-1.11-1.12a7.49 7.49 0 0 0-10.68 0 7.72 7.72 0 0 0 0 10.82L16 29l11.79-11.94a7.72 7.72 0 0 0 0-10.82A7.49 7.49 0 0 0 22.45 4z"}),props.children);});var Favorite20=/*#__PURE__*/React.forwardRef(function Favorite20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22.45 6a5.47 5.47 0 0 1 3.91 1.64 5.7 5.7 0 0 1 0 8L16 26.13 5.64 15.64a5.7 5.7 0 0 1 0-8 5.48 5.48 0 0 1 7.82 0l2.54 2.6 2.53-2.58A5.44 5.44 0 0 1 22.45 6m0-2a7.47 7.47 0 0 0-5.34 2.24L16 7.36l-1.11-1.12a7.49 7.49 0 0 0-10.68 0 7.72 7.72 0 0 0 0 10.82L16 29l11.79-11.94a7.72 7.72 0 0 0 0-10.82A7.49 7.49 0 0 0 22.45 4z"}),props.children);});var FilterEdit32=/*#__PURE__*/React.forwardRef(function FilterEdit32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 6H4v3.17l7.41 7.42.59.58V26h4v-2h2v2a2 2 0 0 1-2 2h-4a2 2 0 0 1-2-2v-8l-7.41-7.41A2 2 0 0 1 2 9.17V6a2 2 0 0 1 2-2h22z"}),React.createElement("path",{d:"M29.71 11.29l-3-3a1 1 0 0 0-1.42 0L16 17.59V22h4.41l9.3-9.29a1 1 0 0 0 0-1.42zM19.59 20H18v-1.59l5-5L24.59 15zM26 13.59L24.41 12 26 10.41 27.59 12z"}),props.children);});var FilterEdit24=/*#__PURE__*/React.forwardRef(function FilterEdit24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 6H4v3.17l7.41 7.42.59.58V26h4v-2h2v2a2 2 0 0 1-2 2h-4a2 2 0 0 1-2-2v-8l-7.41-7.41A2 2 0 0 1 2 9.17V6a2 2 0 0 1 2-2h22z"}),React.createElement("path",{d:"M29.71 11.29l-3-3a1 1 0 0 0-1.42 0L16 17.59V22h4.41l9.3-9.29a1 1 0 0 0 0-1.42zM19.59 20H18v-1.59l5-5L24.59 15zM26 13.59L24.41 12 26 10.41 27.59 12z"}),props.children);});var FilterEdit20=/*#__PURE__*/React.forwardRef(function FilterEdit20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 6H4v3.17l7.41 7.42.59.58V26h4v-2h2v2a2 2 0 0 1-2 2h-4a2 2 0 0 1-2-2v-8l-7.41-7.41A2 2 0 0 1 2 9.17V6a2 2 0 0 1 2-2h22z"}),React.createElement("path",{d:"M29.71 11.29l-3-3a1 1 0 0 0-1.42 0L16 17.59V22h4.41l9.3-9.29a1 1 0 0 0 0-1.42zM19.59 20H18v-1.59l5-5L24.59 15zM26 13.59L24.41 12 26 10.41 27.59 12z"}),props.children);});var FilterEdit16=/*#__PURE__*/React.forwardRef(function FilterEdit16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 6H4v3.17l7.41 7.42.59.58V26h4v-2h2v2a2 2 0 0 1-2 2h-4a2 2 0 0 1-2-2v-8l-7.41-7.41A2 2 0 0 1 2 9.17V6a2 2 0 0 1 2-2h22z"}),React.createElement("path",{d:"M29.71 11.29l-3-3a1 1 0 0 0-1.42 0L16 17.59V22h4.41l9.3-9.29a1 1 0 0 0 0-1.42zM19.59 20H18v-1.59l5-5L24.59 15zM26 13.59L24.41 12 26 10.41 27.59 12z"}),props.children);});var Filter32=/*#__PURE__*/React.forwardRef(function Filter32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 28h-4a2 2 0 0 1-2-2v-7.59L4.59 11A2 2 0 0 1 4 9.59V6a2 2 0 0 1 2-2h20a2 2 0 0 1 2 2v3.59a2 2 0 0 1-.59 1.41L20 18.41V26a2 2 0 0 1-2 2zM6 6v3.59l8 8V26h4v-8.41l8-8V6z"}),props.children);});var Filter24=/*#__PURE__*/React.forwardRef(function Filter24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 28h-4a2 2 0 0 1-2-2v-7.59L4.59 11A2 2 0 0 1 4 9.59V6a2 2 0 0 1 2-2h20a2 2 0 0 1 2 2v3.59a2 2 0 0 1-.59 1.41L20 18.41V26a2 2 0 0 1-2 2zM6 6v3.59l8 8V26h4v-8.41l8-8V6z"}),props.children);});var Filter20=/*#__PURE__*/React.forwardRef(function Filter20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 28h-4a2 2 0 0 1-2-2v-7.59L4.59 11A2 2 0 0 1 4 9.59V6a2 2 0 0 1 2-2h20a2 2 0 0 1 2 2v3.59a2 2 0 0 1-.59 1.41L20 18.41V26a2 2 0 0 1-2 2zM6 6v3.59l8 8V26h4v-8.41l8-8V6z"}),props.children);});var Finance32=/*#__PURE__*/React.forwardRef(function Finance32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2 28h28v2H2zm25-17a1 1 0 0 0 1-1V7a1 1 0 0 0-.66-.94l-11-4a1 1 0 0 0-.68 0l-11 4A1 1 0 0 0 4 7v3a1 1 0 0 0 1 1h1v13H4v2h24v-2h-2V11zM6 7.7l10-3.64L26 7.7V9H6zM18 24h-4V11h4zM8 11h4v13H8zm16 13h-4V11h4z"}),props.children);});var Finance24=/*#__PURE__*/React.forwardRef(function Finance24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2 28h28v2H2zm25-17a1 1 0 0 0 1-1V7a1 1 0 0 0-.66-.94l-11-4a1 1 0 0 0-.68 0l-11 4A1 1 0 0 0 4 7v3a1 1 0 0 0 1 1h1v13H4v2h24v-2h-2V11zM6 7.7l10-3.64L26 7.7V9H6zM18 24h-4V11h4zM8 11h4v13H8zm16 13h-4V11h4z"}),props.children);});var Finance20=/*#__PURE__*/React.forwardRef(function Finance20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2 28h28v2H2zm25-17a1 1 0 0 0 1-1V7a1 1 0 0 0-.66-.94l-11-4a1 1 0 0 0-.68 0l-11 4A1 1 0 0 0 4 7v3a1 1 0 0 0 1 1h1v13H4v2h24v-2h-2V11zM6 7.7l10-3.64L26 7.7V9H6zM18 24h-4V11h4zM8 11h4v13H8zm16 13h-4V11h4z"}),props.children);});var Finance16=/*#__PURE__*/React.forwardRef(function Finance16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2 28h28v2H2zm25-17a1 1 0 0 0 1-1V7a1 1 0 0 0-.66-.94l-11-4a1 1 0 0 0-.68 0l-11 4A1 1 0 0 0 4 7v3a1 1 0 0 0 1 1h1v13H4v2h24v-2h-2V11zM6 7.7l10-3.64L26 7.7V9H6zM18 24h-4V11h4zM8 11h4v13H8zm16 13h-4V11h4z"}),props.children);});var FingerprintRecognition32=/*#__PURE__*/React.forwardRef(function FingerprintRecognition32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7 5.21a.77.77 0 0 1-.46-1.38A15.46 15.46 0 0 1 16 1c2.66 0 6.48.45 9.5 2.62a.77.77 0 0 1 .18 1.07.78.78 0 0 1-1.08.17A15 15 0 0 0 16 2.53a14 14 0 0 0-8.5 2.52.74.74 0 0 1-.5.16z"}),React.createElement("path",{d:"M28.23 12.26a.78.78 0 0 1-.63-.33C25.87 9.49 22.78 6.24 16 6.24a14 14 0 0 0-11.63 5.7.77.77 0 0 1-1.07.17.76.76 0 0 1-.15-1.11A15.54 15.54 0 0 1 16 4.71c5.61 0 9.81 2.08 12.84 6.34a.77.77 0 0 1-.19 1.07.79.79 0 0 1-.42.14z"}),React.createElement("path",{d:"M12.28 31a.78.78 0 0 1-.72-.49.75.75 0 0 1 .44-1c4.37-1.68 7-5.12 7-9.21a2.8 2.8 0 0 0-3-3c-1.86 0-2.76 1-3 3.35a4.27 4.27 0 0 1-4.52 3.83 4.27 4.27 0 0 1-4.32-4.59A11.71 11.71 0 0 1 16 8.39a12 12 0 0 1 12 11.93 18.66 18.66 0 0 1-1.39 6.5.78.78 0 0 1-1 .41.76.76 0 0 1-.41-1 17.25 17.25 0 0 0 1.27-5.91A10.45 10.45 0 0 0 16 9.92a10.18 10.18 0 0 0-10.38 10 2.77 2.77 0 0 0 2.79 3.06 2.74 2.74 0 0 0 3-2.48c.36-3.11 1.89-4.69 4.56-4.69a4.31 4.31 0 0 1 4.52 4.56c0 4.74-3 8.72-8 10.63a.92.92 0 0 1-.21 0z"}),React.createElement("path",{d:"M19.77 30.28a.81.81 0 0 1-.52-.2.76.76 0 0 1 0-1.08 12.63 12.63 0 0 0 3.54-8.68c0-1.56-.48-6.65-6.7-6.65a6.83 6.83 0 0 0-4.94 1.87A6.17 6.17 0 0 0 9.32 20a.77.77 0 0 1-.77.76.76.76 0 0 1-.77-.76A7.73 7.73 0 0 1 10 14.46a8.34 8.34 0 0 1 6-2.32c6.08 0 8.24 4.4 8.24 8.18a14.09 14.09 0 0 1-3.9 9.68.75.75 0 0 1-.57.28z"}),React.createElement("path",{d:"M8.66 27.74a14.14 14.14 0 0 1-1.56-.09.76.76 0 1 1 .17-1.52c2.49.28 4.45-.16 5.84-1.32a6.37 6.37 0 0 0 2.12-4.53.75.75 0 0 1 .82-.71.78.78 0 0 1 .72.81A7.89 7.89 0 0 1 14.09 26a8.2 8.2 0 0 1-5.43 1.74z"}),props.children);});var FingerprintRecognition24=/*#__PURE__*/React.forwardRef(function FingerprintRecognition24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7 5.21a.77.77 0 0 1-.46-1.38A15.46 15.46 0 0 1 16 1c2.66 0 6.48.45 9.5 2.62a.77.77 0 0 1 .18 1.07.78.78 0 0 1-1.08.17A15 15 0 0 0 16 2.53a14 14 0 0 0-8.5 2.52.74.74 0 0 1-.5.16z"}),React.createElement("path",{d:"M28.23 12.26a.78.78 0 0 1-.63-.33C25.87 9.49 22.78 6.24 16 6.24a14 14 0 0 0-11.63 5.7.77.77 0 0 1-1.07.17.76.76 0 0 1-.15-1.11A15.54 15.54 0 0 1 16 4.71c5.61 0 9.81 2.08 12.84 6.34a.77.77 0 0 1-.19 1.07.79.79 0 0 1-.42.14z"}),React.createElement("path",{d:"M12.28 31a.78.78 0 0 1-.72-.49.75.75 0 0 1 .44-1c4.37-1.68 7-5.12 7-9.21a2.8 2.8 0 0 0-3-3c-1.86 0-2.76 1-3 3.35a4.27 4.27 0 0 1-4.52 3.83 4.27 4.27 0 0 1-4.32-4.59A11.71 11.71 0 0 1 16 8.39a12 12 0 0 1 12 11.93 18.66 18.66 0 0 1-1.39 6.5.78.78 0 0 1-1 .41.76.76 0 0 1-.41-1 17.25 17.25 0 0 0 1.27-5.91A10.45 10.45 0 0 0 16 9.92a10.18 10.18 0 0 0-10.38 10 2.77 2.77 0 0 0 2.79 3.06 2.74 2.74 0 0 0 3-2.48c.36-3.11 1.89-4.69 4.56-4.69a4.31 4.31 0 0 1 4.52 4.56c0 4.74-3 8.72-8 10.63a.92.92 0 0 1-.21 0z"}),React.createElement("path",{d:"M19.77 30.28a.81.81 0 0 1-.52-.2.76.76 0 0 1 0-1.08 12.63 12.63 0 0 0 3.54-8.68c0-1.56-.48-6.65-6.7-6.65a6.83 6.83 0 0 0-4.94 1.87A6.17 6.17 0 0 0 9.32 20a.77.77 0 0 1-.77.76.76.76 0 0 1-.77-.76A7.73 7.73 0 0 1 10 14.46a8.34 8.34 0 0 1 6-2.32c6.08 0 8.24 4.4 8.24 8.18a14.09 14.09 0 0 1-3.9 9.68.75.75 0 0 1-.57.28z"}),React.createElement("path",{d:"M8.66 27.74a14.14 14.14 0 0 1-1.56-.09.76.76 0 1 1 .17-1.52c2.49.28 4.45-.16 5.84-1.32a6.37 6.37 0 0 0 2.12-4.53.75.75 0 0 1 .82-.71.78.78 0 0 1 .72.81A7.89 7.89 0 0 1 14.09 26a8.2 8.2 0 0 1-5.43 1.74z"}),props.children);});var FingerprintRecognition20=/*#__PURE__*/React.forwardRef(function FingerprintRecognition20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7 5.21a.77.77 0 0 1-.46-1.38A15.46 15.46 0 0 1 16 1c2.66 0 6.48.45 9.5 2.62a.77.77 0 0 1 .18 1.07.78.78 0 0 1-1.08.17A15 15 0 0 0 16 2.53a14 14 0 0 0-8.5 2.52.74.74 0 0 1-.5.16z"}),React.createElement("path",{d:"M28.23 12.26a.78.78 0 0 1-.63-.33C25.87 9.49 22.78 6.24 16 6.24a14 14 0 0 0-11.63 5.7.77.77 0 0 1-1.07.17.76.76 0 0 1-.15-1.11A15.54 15.54 0 0 1 16 4.71c5.61 0 9.81 2.08 12.84 6.34a.77.77 0 0 1-.19 1.07.79.79 0 0 1-.42.14z"}),React.createElement("path",{d:"M12.28 31a.78.78 0 0 1-.72-.49.75.75 0 0 1 .44-1c4.37-1.68 7-5.12 7-9.21a2.8 2.8 0 0 0-3-3c-1.86 0-2.76 1-3 3.35a4.27 4.27 0 0 1-4.52 3.83 4.27 4.27 0 0 1-4.32-4.59A11.71 11.71 0 0 1 16 8.39a12 12 0 0 1 12 11.93 18.66 18.66 0 0 1-1.39 6.5.78.78 0 0 1-1 .41.76.76 0 0 1-.41-1 17.25 17.25 0 0 0 1.27-5.91A10.45 10.45 0 0 0 16 9.92a10.18 10.18 0 0 0-10.38 10 2.77 2.77 0 0 0 2.79 3.06 2.74 2.74 0 0 0 3-2.48c.36-3.11 1.89-4.69 4.56-4.69a4.31 4.31 0 0 1 4.52 4.56c0 4.74-3 8.72-8 10.63a.92.92 0 0 1-.21 0z"}),React.createElement("path",{d:"M19.77 30.28a.81.81 0 0 1-.52-.2.76.76 0 0 1 0-1.08 12.63 12.63 0 0 0 3.54-8.68c0-1.56-.48-6.65-6.7-6.65a6.83 6.83 0 0 0-4.94 1.87A6.17 6.17 0 0 0 9.32 20a.77.77 0 0 1-.77.76.76.76 0 0 1-.77-.76A7.73 7.73 0 0 1 10 14.46a8.34 8.34 0 0 1 6-2.32c6.08 0 8.24 4.4 8.24 8.18a14.09 14.09 0 0 1-3.9 9.68.75.75 0 0 1-.57.28z"}),React.createElement("path",{d:"M8.66 27.74a14.14 14.14 0 0 1-1.56-.09.76.76 0 1 1 .17-1.52c2.49.28 4.45-.16 5.84-1.32a6.37 6.37 0 0 0 2.12-4.53.75.75 0 0 1 .82-.71.78.78 0 0 1 .72.81A7.89 7.89 0 0 1 14.09 26a8.2 8.2 0 0 1-5.43 1.74z"}),props.children);});var FingerprintRecognition16=/*#__PURE__*/React.forwardRef(function FingerprintRecognition16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7 5.21a.77.77 0 0 1-.46-1.38A15.46 15.46 0 0 1 16 1c2.66 0 6.48.45 9.5 2.62a.77.77 0 0 1 .18 1.07.78.78 0 0 1-1.08.17A15 15 0 0 0 16 2.53a14 14 0 0 0-8.5 2.52.74.74 0 0 1-.5.16z"}),React.createElement("path",{d:"M28.23 12.26a.78.78 0 0 1-.63-.33C25.87 9.49 22.78 6.24 16 6.24a14 14 0 0 0-11.63 5.7.77.77 0 0 1-1.07.17.76.76 0 0 1-.15-1.11A15.54 15.54 0 0 1 16 4.71c5.61 0 9.81 2.08 12.84 6.34a.77.77 0 0 1-.19 1.07.79.79 0 0 1-.42.14z"}),React.createElement("path",{d:"M12.28 31a.78.78 0 0 1-.72-.49.75.75 0 0 1 .44-1c4.37-1.68 7-5.12 7-9.21a2.8 2.8 0 0 0-3-3c-1.86 0-2.76 1-3 3.35a4.27 4.27 0 0 1-4.52 3.83 4.27 4.27 0 0 1-4.32-4.59A11.71 11.71 0 0 1 16 8.39a12 12 0 0 1 12 11.93 18.66 18.66 0 0 1-1.39 6.5.78.78 0 0 1-1 .41.76.76 0 0 1-.41-1 17.25 17.25 0 0 0 1.27-5.91A10.45 10.45 0 0 0 16 9.92a10.18 10.18 0 0 0-10.38 10 2.77 2.77 0 0 0 2.79 3.06 2.74 2.74 0 0 0 3-2.48c.36-3.11 1.89-4.69 4.56-4.69a4.31 4.31 0 0 1 4.52 4.56c0 4.74-3 8.72-8 10.63a.92.92 0 0 1-.21 0z"}),React.createElement("path",{d:"M19.77 30.28a.81.81 0 0 1-.52-.2.76.76 0 0 1 0-1.08 12.63 12.63 0 0 0 3.54-8.68c0-1.56-.48-6.65-6.7-6.65a6.83 6.83 0 0 0-4.94 1.87A6.17 6.17 0 0 0 9.32 20a.77.77 0 0 1-.77.76.76.76 0 0 1-.77-.76A7.73 7.73 0 0 1 10 14.46a8.34 8.34 0 0 1 6-2.32c6.08 0 8.24 4.4 8.24 8.18a14.09 14.09 0 0 1-3.9 9.68.75.75 0 0 1-.57.28z"}),React.createElement("path",{d:"M8.66 27.74a14.14 14.14 0 0 1-1.56-.09.76.76 0 1 1 .17-1.52c2.49.28 4.45-.16 5.84-1.32a6.37 6.37 0 0 0 2.12-4.53.75.75 0 0 1 .82-.71.78.78 0 0 1 .72.81A7.89 7.89 0 0 1 14.09 26a8.2 8.2 0 0 1-5.43 1.74z"}),props.children);});var Flag32=/*#__PURE__*/React.forwardRef(function Flag32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6 30H4V2h24l-5.8 9 5.8 9H6zm0-12h18.33l-4.53-7 4.53-7H6z"}),props.children);});var Flag24=/*#__PURE__*/React.forwardRef(function Flag24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6 30H4V2h24l-5.8 9 5.8 9H6zm0-12h18.33l-4.53-7 4.53-7H6z"}),props.children);});var Flag20=/*#__PURE__*/React.forwardRef(function Flag20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6 30H4V2h24l-5.8 9 5.8 9H6zm0-12h18.33l-4.53-7 4.53-7H6z"}),props.children);});var Flag16=/*#__PURE__*/React.forwardRef(function Flag16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6 30H4V2h24l-5.8 9 5.8 9H6zm0-12h18.33l-4.53-7 4.53-7H6z"}),props.children);});var FlashFilled32=/*#__PURE__*/React.forwardRef(function FlashFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.61 29.92a1 1 0 0 1-.6-1.07L12.83 17H8a1 1 0 0 1-1-1.23l3-13A1 1 0 0 1 11 2h10a1 1 0 0 1 .78.37 1 1 0 0 1 .2.85L20.25 11H25a1 1 0 0 1 .9.56 1 1 0 0 1-.11 1l-13 17A1 1 0 0 1 12 30a1.09 1.09 0 0 1-.39-.08z"}),props.children);});var FlashFilled24=/*#__PURE__*/React.forwardRef(function FlashFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.61 29.92a1 1 0 0 1-.6-1.07L12.83 17H8a1 1 0 0 1-1-1.23l3-13A1 1 0 0 1 11 2h10a1 1 0 0 1 .78.37 1 1 0 0 1 .2.85L20.25 11H25a1 1 0 0 1 .9.56 1 1 0 0 1-.11 1l-13 17A1 1 0 0 1 12 30a1.09 1.09 0 0 1-.39-.08z"}),props.children);});var FlashFilled20=/*#__PURE__*/React.forwardRef(function FlashFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.61 29.92a1 1 0 0 1-.6-1.07L12.83 17H8a1 1 0 0 1-1-1.23l3-13A1 1 0 0 1 11 2h10a1 1 0 0 1 .78.37 1 1 0 0 1 .2.85L20.25 11H25a1 1 0 0 1 .9.56 1 1 0 0 1-.11 1l-13 17A1 1 0 0 1 12 30a1.09 1.09 0 0 1-.39-.08z"}),props.children);});var FlashFilled16=/*#__PURE__*/React.forwardRef(function FlashFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.61 29.92a1 1 0 0 1-.6-1.07L12.83 17H8a1 1 0 0 1-1-1.23l3-13A1 1 0 0 1 11 2h10a1 1 0 0 1 .78.37 1 1 0 0 1 .2.85L20.25 11H25a1 1 0 0 1 .9.56 1 1 0 0 1-.11 1l-13 17A1 1 0 0 1 12 30a1.09 1.09 0 0 1-.39-.08z"}),props.children);});var FlashOffFilled32=/*#__PURE__*/React.forwardRef(function FlashOffFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 28.59L3.41 2 2 3.41l6.4 6.41L7 15.77A1 1 0 0 0 8 17h4.83L11 28.85a1 1 0 0 0 .6 1.07 1.09 1.09 0 0 0 .4.08 1 1 0 0 0 .79-.39l6.68-8.73L28.59 30zm-7.47-11.72l3.26-4.26a1 1 0 0 0 .11-1A1 1 0 0 0 25 11h-4.75L22 3.22a1 1 0 0 0-.2-.85A1 1 0 0 0 21 2H11a1 1 0 0 0-1 .77l-.3 1.3z"}),props.children);});var FlashOffFilled24=/*#__PURE__*/React.forwardRef(function FlashOffFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 28.59L3.41 2 2 3.41l6.4 6.41L7 15.77A1 1 0 0 0 8 17h4.83L11 28.85a1 1 0 0 0 .6 1.07 1.09 1.09 0 0 0 .4.08 1 1 0 0 0 .79-.39l6.68-8.73L28.59 30zm-7.47-11.72l3.26-4.26a1 1 0 0 0 .11-1A1 1 0 0 0 25 11h-4.75L22 3.22a1 1 0 0 0-.2-.85A1 1 0 0 0 21 2H11a1 1 0 0 0-1 .77l-.3 1.3z"}),props.children);});var FlashOffFilled20=/*#__PURE__*/React.forwardRef(function FlashOffFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 28.59L3.41 2 2 3.41l6.4 6.41L7 15.77A1 1 0 0 0 8 17h4.83L11 28.85a1 1 0 0 0 .6 1.07 1.09 1.09 0 0 0 .4.08 1 1 0 0 0 .79-.39l6.68-8.73L28.59 30zm-7.47-11.72l3.26-4.26a1 1 0 0 0 .11-1A1 1 0 0 0 25 11h-4.75L22 3.22a1 1 0 0 0-.2-.85A1 1 0 0 0 21 2H11a1 1 0 0 0-1 .77l-.3 1.3z"}),props.children);});var FlashOffFilled16=/*#__PURE__*/React.forwardRef(function FlashOffFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 28.59L3.41 2 2 3.41l6.4 6.41L7 15.77A1 1 0 0 0 8 17h4.83L11 28.85a1 1 0 0 0 .6 1.07 1.09 1.09 0 0 0 .4.08 1 1 0 0 0 .79-.39l6.68-8.73L28.59 30zm-7.47-11.72l3.26-4.26a1 1 0 0 0 .11-1A1 1 0 0 0 25 11h-4.75L22 3.22a1 1 0 0 0-.2-.85A1 1 0 0 0 21 2H11a1 1 0 0 0-1 .77l-.3 1.3z"}),props.children);});var FlashOff32=/*#__PURE__*/React.forwardRef(function FlashOff32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.13 6.89L11.8 4h8l-2 9H23l-2.49 3.25 1.43 1.43 3.87-5.07a1 1 0 0 0 .11-1A1 1 0 0 0 25 11h-4.75L22 3.22a1 1 0 0 0-.2-.85A1 1 0 0 0 21 2H11a1 1 0 0 0-1 .77l-.54 2.45zM30 28.59l-9.31-9.31-1.42-1.43-8.67-8.66-1.67-1.67L3.41 2 2 3.41l6.4 6.41L7 15.77A1 1 0 0 0 8 17h4.83L11 28.85a1 1 0 0 0 .6 1.07 1.09 1.09 0 0 0 .4.08 1 1 0 0 0 .79-.39l6.68-8.73L28.59 30zM9.26 15l.81-3.52L13.59 15zm4.32 10.28L15 16.37l3 3.08z"}),props.children);});var FlashOff24=/*#__PURE__*/React.forwardRef(function FlashOff24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.13 6.89L11.8 4h8l-2 9H23l-2.49 3.25 1.43 1.43 3.87-5.07a1 1 0 0 0 .11-1A1 1 0 0 0 25 11h-4.75L22 3.22a1 1 0 0 0-.2-.85A1 1 0 0 0 21 2H11a1 1 0 0 0-1 .77l-.54 2.45zM30 28.59l-9.31-9.31-1.42-1.43-8.67-8.66-1.67-1.67L3.41 2 2 3.41l6.4 6.41L7 15.77A1 1 0 0 0 8 17h4.83L11 28.85a1 1 0 0 0 .6 1.07 1.09 1.09 0 0 0 .4.08 1 1 0 0 0 .79-.39l6.68-8.73L28.59 30zM9.26 15l.81-3.52L13.59 15zm4.32 10.28L15 16.37l3 3.08z"}),props.children);});var FlashOff20=/*#__PURE__*/React.forwardRef(function FlashOff20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.13 6.89L11.8 4h8l-2 9H23l-2.49 3.25 1.43 1.43 3.87-5.07a1 1 0 0 0 .11-1A1 1 0 0 0 25 11h-4.75L22 3.22a1 1 0 0 0-.2-.85A1 1 0 0 0 21 2H11a1 1 0 0 0-1 .77l-.54 2.45zM30 28.59l-9.31-9.31-1.42-1.43-8.67-8.66-1.67-1.67L3.41 2 2 3.41l6.4 6.41L7 15.77A1 1 0 0 0 8 17h4.83L11 28.85a1 1 0 0 0 .6 1.07 1.09 1.09 0 0 0 .4.08 1 1 0 0 0 .79-.39l6.68-8.73L28.59 30zM9.26 15l.81-3.52L13.59 15zm4.32 10.28L15 16.37l3 3.08z"}),props.children);});var FlashOff16=/*#__PURE__*/React.forwardRef(function FlashOff16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.13 6.89L11.8 4h8l-2 9H23l-2.49 3.25 1.43 1.43 3.87-5.07a1 1 0 0 0 .11-1A1 1 0 0 0 25 11h-4.75L22 3.22a1 1 0 0 0-.2-.85A1 1 0 0 0 21 2H11a1 1 0 0 0-1 .77l-.54 2.45zM30 28.59l-9.31-9.31-1.42-1.43-8.67-8.66-1.67-1.67L3.41 2 2 3.41l6.4 6.41L7 15.77A1 1 0 0 0 8 17h4.83L11 28.85a1 1 0 0 0 .6 1.07 1.09 1.09 0 0 0 .4.08 1 1 0 0 0 .79-.39l6.68-8.73L28.59 30zM9.26 15l.81-3.52L13.59 15zm4.32 10.28L15 16.37l3 3.08z"}),props.children);});var Flash32=/*#__PURE__*/React.forwardRef(function Flash32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.61 29.92a1 1 0 0 1-.6-1.07L12.83 17H8a1 1 0 0 1-1-1.23l3-13A1 1 0 0 1 11 2h10a1 1 0 0 1 .78.37 1 1 0 0 1 .2.85L20.25 11H25a1 1 0 0 1 .9.56 1 1 0 0 1-.11 1l-13 17A1 1 0 0 1 12 30a1.09 1.09 0 0 1-.39-.08zM17.75 13l2-9H11.8L9.26 15h5.91l-1.59 10.28L23 13z"}),props.children);});var Flash24=/*#__PURE__*/React.forwardRef(function Flash24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.61 29.92a1 1 0 0 1-.6-1.07L12.83 17H8a1 1 0 0 1-1-1.23l3-13A1 1 0 0 1 11 2h10a1 1 0 0 1 .78.37 1 1 0 0 1 .2.85L20.25 11H25a1 1 0 0 1 .9.56 1 1 0 0 1-.11 1l-13 17A1 1 0 0 1 12 30a1.09 1.09 0 0 1-.39-.08zM17.75 13l2-9H11.8L9.26 15h5.91l-1.59 10.28L23 13z"}),props.children);});var Flash20=/*#__PURE__*/React.forwardRef(function Flash20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.61 29.92a1 1 0 0 1-.6-1.07L12.83 17H8a1 1 0 0 1-1-1.23l3-13A1 1 0 0 1 11 2h10a1 1 0 0 1 .78.37 1 1 0 0 1 .2.85L20.25 11H25a1 1 0 0 1 .9.56 1 1 0 0 1-.11 1l-13 17A1 1 0 0 1 12 30a1.09 1.09 0 0 1-.39-.08zM17.75 13l2-9H11.8L9.26 15h5.91l-1.59 10.28L23 13z"}),props.children);});var Flash16=/*#__PURE__*/React.forwardRef(function Flash16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.61 29.92a1 1 0 0 1-.6-1.07L12.83 17H8a1 1 0 0 1-1-1.23l3-13A1 1 0 0 1 11 2h10a1 1 0 0 1 .78.37 1 1 0 0 1 .2.85L20.25 11H25a1 1 0 0 1 .9.56 1 1 0 0 1-.11 1l-13 17A1 1 0 0 1 12 30a1.09 1.09 0 0 1-.39-.08zM17.75 13l2-9H11.8L9.26 15h5.91l-1.59 10.28L23 13z"}),props.children);});var FlowData32=/*#__PURE__*/React.forwardRef(function FlowData32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 23h-8.14a4.17 4.17 0 0 0-.43-1L22 11.43a3.86 3.86 0 0 0 2 .57 4 4 0 1 0-3.86-5h-8.28a4 4 0 1 0 0 2h8.28a4.17 4.17 0 0 0 .43 1L10 20.57A3.86 3.86 0 0 0 8 20a4 4 0 1 0 3.86 5H20v3h8v-8h-8zM8 10a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm16-4a2 2 0 1 1-2 2 2 2 0 0 1 2-2zM8 26a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm14-4h4v4h-4z"}),props.children);});var FlowData24=/*#__PURE__*/React.forwardRef(function FlowData24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 23h-8.14a4.17 4.17 0 0 0-.43-1L22 11.43a3.86 3.86 0 0 0 2 .57 4 4 0 1 0-3.86-5h-8.28a4 4 0 1 0 0 2h8.28a4.17 4.17 0 0 0 .43 1L10 20.57A3.86 3.86 0 0 0 8 20a4 4 0 1 0 3.86 5H20v3h8v-8h-8zM8 10a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm16-4a2 2 0 1 1-2 2 2 2 0 0 1 2-2zM8 26a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm14-4h4v4h-4z"}),props.children);});var FlowData20=/*#__PURE__*/React.forwardRef(function FlowData20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 23h-8.14a4.17 4.17 0 0 0-.43-1L22 11.43a3.86 3.86 0 0 0 2 .57 4 4 0 1 0-3.86-5h-8.28a4 4 0 1 0 0 2h8.28a4.17 4.17 0 0 0 .43 1L10 20.57A3.86 3.86 0 0 0 8 20a4 4 0 1 0 3.86 5H20v3h8v-8h-8zM8 10a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm16-4a2 2 0 1 1-2 2 2 2 0 0 1 2-2zM8 26a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm14-4h4v4h-4z"}),props.children);});var FlowData16=/*#__PURE__*/React.forwardRef(function FlowData16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 23h-8.14a4.17 4.17 0 0 0-.43-1L22 11.43a3.86 3.86 0 0 0 2 .57 4 4 0 1 0-3.86-5h-8.28a4 4 0 1 0 0 2h8.28a4.17 4.17 0 0 0 .43 1L10 20.57A3.86 3.86 0 0 0 8 20a4 4 0 1 0 3.86 5H20v3h8v-8h-8zM8 10a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm16-4a2 2 0 1 1-2 2 2 2 0 0 1 2-2zM8 26a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm14-4h4v4h-4z"}),props.children);});var FlowStream32=/*#__PURE__*/React.forwardRef(function FlowStream32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 24h-8.14a4.17 4.17 0 0 0-.43-1L22 12.43a3.86 3.86 0 0 0 2 .57 4 4 0 1 0-3.86-5H14v2h6.14a4.17 4.17 0 0 0 .43 1L10 21.57A3.86 3.86 0 0 0 8 21a4 4 0 1 0 3.86 5H20v3h8v-8h-8zm4-17a2 2 0 1 1-2 2 2 2 0 0 1 2-2zM8 27a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm14-4h4v4h-4zM7.05 15.75a9 9 0 0 1 0-13.5l1.32 1.5a7 7 0 0 0 0 10.5z"}),React.createElement("path",{d:"M9.69 12.75a5 5 0 0 1 0-7.5L11 6.75a3 3 0 0 0 0 4.5z"}),props.children);});var FlowStream24=/*#__PURE__*/React.forwardRef(function FlowStream24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 24h-8.14a4.17 4.17 0 0 0-.43-1L22 12.43a3.86 3.86 0 0 0 2 .57 4 4 0 1 0-3.86-5H14v2h6.14a4.17 4.17 0 0 0 .43 1L10 21.57A3.86 3.86 0 0 0 8 21a4 4 0 1 0 3.86 5H20v3h8v-8h-8zm4-17a2 2 0 1 1-2 2 2 2 0 0 1 2-2zM8 27a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm14-4h4v4h-4zM7.05 15.75a9 9 0 0 1 0-13.5l1.32 1.5a7 7 0 0 0 0 10.5z"}),React.createElement("path",{d:"M9.69 12.75a5 5 0 0 1 0-7.5L11 6.75a3 3 0 0 0 0 4.5z"}),props.children);});var FlowStream20=/*#__PURE__*/React.forwardRef(function FlowStream20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 24h-8.14a4.17 4.17 0 0 0-.43-1L22 12.43a3.86 3.86 0 0 0 2 .57 4 4 0 1 0-3.86-5H14v2h6.14a4.17 4.17 0 0 0 .43 1L10 21.57A3.86 3.86 0 0 0 8 21a4 4 0 1 0 3.86 5H20v3h8v-8h-8zm4-17a2 2 0 1 1-2 2 2 2 0 0 1 2-2zM8 27a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm14-4h4v4h-4zM7.05 15.75a9 9 0 0 1 0-13.5l1.32 1.5a7 7 0 0 0 0 10.5z"}),React.createElement("path",{d:"M9.69 12.75a5 5 0 0 1 0-7.5L11 6.75a3 3 0 0 0 0 4.5z"}),props.children);});var FlowStream16=/*#__PURE__*/React.forwardRef(function FlowStream16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 24h-8.14a4.17 4.17 0 0 0-.43-1L22 12.43a3.86 3.86 0 0 0 2 .57 4 4 0 1 0-3.86-5H14v2h6.14a4.17 4.17 0 0 0 .43 1L10 21.57A3.86 3.86 0 0 0 8 21a4 4 0 1 0 3.86 5H20v3h8v-8h-8zm4-17a2 2 0 1 1-2 2 2 2 0 0 1 2-2zM8 27a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm14-4h4v4h-4zM7.05 15.75a9 9 0 0 1 0-13.5l1.32 1.5a7 7 0 0 0 0 10.5z"}),React.createElement("path",{d:"M9.69 12.75a5 5 0 0 1 0-7.5L11 6.75a3 3 0 0 0 0 4.5z"}),props.children);});var Flow32=/*#__PURE__*/React.forwardRef(function Flow32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27 22.14V17a2 2 0 0 0-2-2h-8V9.86a4 4 0 1 0-2 0V15H7a2 2 0 0 0-2 2v5.14a4 4 0 1 0 2 0V17h18v5.14a4 4 0 1 0 2 0zM8 26a2 2 0 1 1-2-2 2 2 0 0 1 2 2zm6-20a2 2 0 1 1 2 2 2 2 0 0 1-2-2zm12 22a2 2 0 1 1 2-2 2 2 0 0 1-2 2z"}),props.children);});var Flow24=/*#__PURE__*/React.forwardRef(function Flow24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27 22.14V17a2 2 0 0 0-2-2h-8V9.86a4 4 0 1 0-2 0V15H7a2 2 0 0 0-2 2v5.14a4 4 0 1 0 2 0V17h18v5.14a4 4 0 1 0 2 0zM8 26a2 2 0 1 1-2-2 2 2 0 0 1 2 2zm6-20a2 2 0 1 1 2 2 2 2 0 0 1-2-2zm12 22a2 2 0 1 1 2-2 2 2 0 0 1-2 2z"}),props.children);});var Flow20=/*#__PURE__*/React.forwardRef(function Flow20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27 22.14V17a2 2 0 0 0-2-2h-8V9.86a4 4 0 1 0-2 0V15H7a2 2 0 0 0-2 2v5.14a4 4 0 1 0 2 0V17h18v5.14a4 4 0 1 0 2 0zM8 26a2 2 0 1 1-2-2 2 2 0 0 1 2 2zm6-20a2 2 0 1 1 2 2 2 2 0 0 1-2-2zm12 22a2 2 0 1 1 2-2 2 2 0 0 1-2 2z"}),props.children);});var Flow16=/*#__PURE__*/React.forwardRef(function Flow16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27 22.14V17a2 2 0 0 0-2-2h-8V9.86a4 4 0 1 0-2 0V15H7a2 2 0 0 0-2 2v5.14a4 4 0 1 0 2 0V17h18v5.14a4 4 0 1 0 2 0zM8 26a2 2 0 1 1-2-2 2 2 0 0 1 2 2zm6-20a2 2 0 1 1 2 2 2 2 0 0 1-2-2zm12 22a2 2 0 1 1 2-2 2 2 0 0 1-2 2z"}),props.children);});var Fog32=/*#__PURE__*/React.forwardRef(function Fog32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.829 13.116A10.02 10.02 0 0 0 16 5v2a8.023 8.023 0 0 1 7.865 6.493l.259 1.346 1.349.245A5.502 5.502 0 0 1 24.508 26H16v2h8.508a7.502 7.502 0 0 0 1.32-14.884zM8 24h6v2H8zm-4 0h2v2H4zm2-4h8v2H6zm-4 0h2v2H2zm6-4h6v2H8zm-4 0h2v2H4zm6-4h4v2h-4zm-4 0h2v2H6zm6-4h2v2h-2z"}),props.children);});var Fog24=/*#__PURE__*/React.forwardRef(function Fog24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.829 13.116A10.02 10.02 0 0 0 16 5v2a8.023 8.023 0 0 1 7.865 6.493l.259 1.346 1.349.245A5.502 5.502 0 0 1 24.508 26H16v2h8.508a7.502 7.502 0 0 0 1.32-14.884zM8 24h6v2H8zm-4 0h2v2H4zm2-4h8v2H6zm-4 0h2v2H2zm6-4h6v2H8zm-4 0h2v2H4zm6-4h4v2h-4zm-4 0h2v2H6zm6-4h2v2h-2z"}),props.children);});var Fog20=/*#__PURE__*/React.forwardRef(function Fog20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.829 13.116A10.02 10.02 0 0 0 16 5v2a8.023 8.023 0 0 1 7.865 6.493l.259 1.346 1.349.245A5.502 5.502 0 0 1 24.508 26H16v2h8.508a7.502 7.502 0 0 0 1.32-14.884zM8 24h6v2H8zm-4 0h2v2H4zm2-4h8v2H6zm-4 0h2v2H2zm6-4h6v2H8zm-4 0h2v2H4zm6-4h4v2h-4zm-4 0h2v2H6zm6-4h2v2h-2z"}),props.children);});var Fog16=/*#__PURE__*/React.forwardRef(function Fog16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.829 13.116A10.02 10.02 0 0 0 16 5v2a8.023 8.023 0 0 1 7.865 6.493l.259 1.346 1.349.245A5.502 5.502 0 0 1 24.508 26H16v2h8.508a7.502 7.502 0 0 0 1.32-14.884zM8 24h6v2H8zm-4 0h2v2H4zm2-4h8v2H6zm-4 0h2v2H2zm6-4h6v2H8zm-4 0h2v2H4zm6-4h4v2h-4zm-4 0h2v2H6zm6-4h2v2h-2z"}),props.children);});var FolderAdd32=/*#__PURE__*/React.forwardRef(function FolderAdd32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 20h-2v4h-4v2h4v4h2v-4h4v-2h-4v-4z"}),React.createElement("path",{d:"M28 8H16l-3.41-3.41A2 2 0 0 0 11.17 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h12v-2H4V6h7.17l3.42 3.41.58.59H28v7h2v-7a2 2 0 0 0-2-2z"}),props.children);});var FolderAdd24=/*#__PURE__*/React.forwardRef(function FolderAdd24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 20h-2v4h-4v2h4v4h2v-4h4v-2h-4v-4z"}),React.createElement("path",{d:"M28 8H16l-3.41-3.41A2 2 0 0 0 11.17 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h12v-2H4V6h7.17l3.42 3.41.58.59H28v7h2v-7a2 2 0 0 0-2-2z"}),props.children);});var FolderAdd20=/*#__PURE__*/React.forwardRef(function FolderAdd20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 20h-2v4h-4v2h4v4h2v-4h4v-2h-4v-4z"}),React.createElement("path",{d:"M28 8H16l-3.41-3.41A2 2 0 0 0 11.17 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h12v-2H4V6h7.17l3.42 3.41.58.59H28v7h2v-7a2 2 0 0 0-2-2z"}),props.children);});var FolderDetails32=/*#__PURE__*/React.forwardRef(function FolderDetails32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 20h14v2H16zm0 4h14v2H16zm0 4h7v2h-7z"}),React.createElement("path",{d:"M14 26H4V6h7.17l3.42 3.41.58.59H28v8h2v-8a2 2 0 0 0-2-2H16l-3.41-3.41A2 2 0 0 0 11.17 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h10z"}),props.children);});var FolderDetails24=/*#__PURE__*/React.forwardRef(function FolderDetails24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 20h14v2H16zm0 4h14v2H16zm0 4h7v2h-7z"}),React.createElement("path",{d:"M14 26H4V6h7.17l3.42 3.41.58.59H28v8h2v-8a2 2 0 0 0-2-2H16l-3.41-3.41A2 2 0 0 0 11.17 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h10z"}),props.children);});var FolderDetails20=/*#__PURE__*/React.forwardRef(function FolderDetails20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 20h14v2H16zm0 4h14v2H16zm0 4h7v2h-7z"}),React.createElement("path",{d:"M14 26H4V6h7.17l3.42 3.41.58.59H28v8h2v-8a2 2 0 0 0-2-2H16l-3.41-3.41A2 2 0 0 0 11.17 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h10z"}),props.children);});var FolderDetails16=/*#__PURE__*/React.forwardRef(function FolderDetails16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 20h14v2H16zm0 4h14v2H16zm0 4h7v2h-7z"}),React.createElement("path",{d:"M14 26H4V6h7.17l3.42 3.41.58.59H28v8h2v-8a2 2 0 0 0-2-2H16l-3.41-3.41A2 2 0 0 0 11.17 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h10z"}),props.children);});var FolderShared32=/*#__PURE__*/React.forwardRef(function FolderShared32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 8H16l-3.41-3.41A2 2 0 0 0 11.17 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V10a2 2 0 0 0-2-2zm-6 18h-8v-1a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1zm6 0h-4v-1a3 3 0 0 0-3-3h-6a3 3 0 0 0-3 3v1H4V6h7.17l3.42 3.41.58.59H28z"}),React.createElement("path",{d:"M14 17a4 4 0 1 0 4-4 4 4 0 0 0-4 4zm4-2a2 2 0 1 1-2 2 2 2 0 0 1 2-2z"}),props.children);});var FolderShared24=/*#__PURE__*/React.forwardRef(function FolderShared24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 8H16l-3.41-3.41A2 2 0 0 0 11.17 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V10a2 2 0 0 0-2-2zm-6 18h-8v-1a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1zm6 0h-4v-1a3 3 0 0 0-3-3h-6a3 3 0 0 0-3 3v1H4V6h7.17l3.42 3.41.58.59H28z"}),React.createElement("path",{d:"M14 17a4 4 0 1 0 4-4 4 4 0 0 0-4 4zm4-2a2 2 0 1 1-2 2 2 2 0 0 1 2-2z"}),props.children);});var FolderShared20=/*#__PURE__*/React.forwardRef(function FolderShared20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 8H16l-3.41-3.41A2 2 0 0 0 11.17 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V10a2 2 0 0 0-2-2zm-6 18h-8v-1a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1zm6 0h-4v-1a3 3 0 0 0-3-3h-6a3 3 0 0 0-3 3v1H4V6h7.17l3.42 3.41.58.59H28z"}),React.createElement("path",{d:"M14 17a4 4 0 1 0 4-4 4 4 0 0 0-4 4zm4-2a2 2 0 1 1-2 2 2 2 0 0 1 2-2z"}),props.children);});var FolderShared16=/*#__PURE__*/React.forwardRef(function FolderShared16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 8H16l-3.41-3.41A2 2 0 0 0 11.17 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V10a2 2 0 0 0-2-2zm-6 18h-8v-1a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1zm6 0h-4v-1a3 3 0 0 0-3-3h-6a3 3 0 0 0-3 3v1H4V6h7.17l3.42 3.41.58.59H28z"}),React.createElement("path",{d:"M14 17a4 4 0 1 0 4-4 4 4 0 0 0-4 4zm4-2a2 2 0 1 1-2 2 2 2 0 0 1 2-2z"}),props.children);});var Folder32=/*#__PURE__*/React.forwardRef(function Folder32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.17 6l3.42 3.41.58.59H28v16H4V6h7.17m0-2H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V10a2 2 0 0 0-2-2H16l-3.41-3.41A2 2 0 0 0 11.17 4z"}),props.children);});var Folder24=/*#__PURE__*/React.forwardRef(function Folder24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.17 6l3.42 3.41.58.59H28v16H4V6h7.17m0-2H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V10a2 2 0 0 0-2-2H16l-3.41-3.41A2 2 0 0 0 11.17 4z"}),props.children);});var Folder20=/*#__PURE__*/React.forwardRef(function Folder20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.17 6l3.42 3.41.58.59H28v16H4V6h7.17m0-2H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V10a2 2 0 0 0-2-2H16l-3.41-3.41A2 2 0 0 0 11.17 4z"}),props.children);});var Fork32=/*#__PURE__*/React.forwardRef(function Fork32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 18a3.996 3.996 0 0 0-3.858 3H17V11h5.142a4 4 0 1 0 0-2H17a2.002 2.002 0 0 0-2 2v4H9.858a4 4 0 1 0 0 2H15v4a2.002 2.002 0 0 0 2 2h5.142A3.993 3.993 0 1 0 26 18zm0-10a2 2 0 1 1-2 2 2.002 2.002 0 0 1 2-2zM6 18a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2zm20 6a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2z"}),props.children);});var Fork24=/*#__PURE__*/React.forwardRef(function Fork24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 18a3.996 3.996 0 0 0-3.858 3H17V11h5.142a4 4 0 1 0 0-2H17a2.002 2.002 0 0 0-2 2v4H9.858a4 4 0 1 0 0 2H15v4a2.002 2.002 0 0 0 2 2h5.142A3.993 3.993 0 1 0 26 18zm0-10a2 2 0 1 1-2 2 2.002 2.002 0 0 1 2-2zM6 18a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2zm20 6a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2z"}),props.children);});var Fork20=/*#__PURE__*/React.forwardRef(function Fork20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 18a3.996 3.996 0 0 0-3.858 3H17V11h5.142a4 4 0 1 0 0-2H17a2.002 2.002 0 0 0-2 2v4H9.858a4 4 0 1 0 0 2H15v4a2.002 2.002 0 0 0 2 2h5.142A3.993 3.993 0 1 0 26 18zm0-10a2 2 0 1 1-2 2 2.002 2.002 0 0 1 2-2zM6 18a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2zm20 6a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2z"}),props.children);});var Fork16=/*#__PURE__*/React.forwardRef(function Fork16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 18a3.996 3.996 0 0 0-3.858 3H17V11h5.142a4 4 0 1 0 0-2H17a2.002 2.002 0 0 0-2 2v4H9.858a4 4 0 1 0 0 2H15v4a2.002 2.002 0 0 0 2 2h5.142A3.993 3.993 0 1 0 26 18zm0-10a2 2 0 1 1-2 2 2.002 2.002 0 0 1 2-2zM6 18a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2zm20 6a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2z"}),props.children);});var Forum32=/*#__PURE__*/React.forwardRef(function Forum32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27 7H10a3.003 3.003 0 0 0-3 3v11a3.003 3.003 0 0 0 3 3h6v-2h-6a1 1 0 0 1-1-1V10a1.001 1.001 0 0 1 1-1h17a1 1 0 0 1 1 1v11a1 1 0 0 1-1 1h-5.2L17 28.854 18.639 30l4.202-6H27a3.003 3.003 0 0 0 3-3V10a3.003 3.003 0 0 0-3-3z"}),React.createElement("path",{d:"M3 17H1V4a3.003 3.003 0 0 1 3-3h13v2H4a1.001 1.001 0 0 0-1 1z"}),props.children);});var Forum24=/*#__PURE__*/React.forwardRef(function Forum24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27 7H10a3.003 3.003 0 0 0-3 3v11a3.003 3.003 0 0 0 3 3h6v-2h-6a1 1 0 0 1-1-1V10a1.001 1.001 0 0 1 1-1h17a1 1 0 0 1 1 1v11a1 1 0 0 1-1 1h-5.2L17 28.854 18.639 30l4.202-6H27a3.003 3.003 0 0 0 3-3V10a3.003 3.003 0 0 0-3-3z"}),React.createElement("path",{d:"M3 17H1V4a3.003 3.003 0 0 1 3-3h13v2H4a1.001 1.001 0 0 0-1 1z"}),props.children);});var Forum20=/*#__PURE__*/React.forwardRef(function Forum20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27 7H10a3.003 3.003 0 0 0-3 3v11a3.003 3.003 0 0 0 3 3h6v-2h-6a1 1 0 0 1-1-1V10a1.001 1.001 0 0 1 1-1h17a1 1 0 0 1 1 1v11a1 1 0 0 1-1 1h-5.2L17 28.854 18.639 30l4.202-6H27a3.003 3.003 0 0 0 3-3V10a3.003 3.003 0 0 0-3-3z"}),React.createElement("path",{d:"M3 17H1V4a3.003 3.003 0 0 1 3-3h13v2H4a1.001 1.001 0 0 0-1 1z"}),props.children);});var Forward_1032=/*#__PURE__*/React.forwardRef(function Forward_1032(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 18A10 10 0 1 1 16 8h4v5l6-6-6-6v5h-4a12 12 0 1 0 12 12z"}),React.createElement("path",{d:"M19.63 22.13a2.84 2.84 0 0 1-1.28-.27 2.44 2.44 0 0 1-.89-.77 3.57 3.57 0 0 1-.52-1.25 7.69 7.69 0 0 1-.17-1.68 7.83 7.83 0 0 1 .17-1.68 3.65 3.65 0 0 1 .52-1.25 2.44 2.44 0 0 1 .89-.77 2.84 2.84 0 0 1 1.28-.27 2.44 2.44 0 0 1 2.16 1 5.23 5.23 0 0 1 .7 2.93 5.23 5.23 0 0 1-.7 2.93 2.44 2.44 0 0 1-2.16 1.08zm0-1.22a1.07 1.07 0 0 0 1-.55 3.38 3.38 0 0 0 .37-1.51v-1.38a3.31 3.31 0 0 0-.29-1.5 1.23 1.23 0 0 0-2.06 0 3.31 3.31 0 0 0-.29 1.5v1.38a3.38 3.38 0 0 0 .29 1.51 1.06 1.06 0 0 0 .98.55zm-9 1.09v-1.18h2v-5.19l-1.86 1-.55-1.06 2.32-1.3H14v6.5h1.78V22z"}),props.children);});var Forward_1024=/*#__PURE__*/React.forwardRef(function Forward_1024(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 18A10 10 0 1 1 16 8h4v5l6-6-6-6v5h-4a12 12 0 1 0 12 12z"}),React.createElement("path",{d:"M19.63 22.13a2.84 2.84 0 0 1-1.28-.27 2.44 2.44 0 0 1-.89-.77 3.57 3.57 0 0 1-.52-1.25 7.69 7.69 0 0 1-.17-1.68 7.83 7.83 0 0 1 .17-1.68 3.65 3.65 0 0 1 .52-1.25 2.44 2.44 0 0 1 .89-.77 2.84 2.84 0 0 1 1.28-.27 2.44 2.44 0 0 1 2.16 1 5.23 5.23 0 0 1 .7 2.93 5.23 5.23 0 0 1-.7 2.93 2.44 2.44 0 0 1-2.16 1.08zm0-1.22a1.07 1.07 0 0 0 1-.55 3.38 3.38 0 0 0 .37-1.51v-1.38a3.31 3.31 0 0 0-.29-1.5 1.23 1.23 0 0 0-2.06 0 3.31 3.31 0 0 0-.29 1.5v1.38a3.38 3.38 0 0 0 .29 1.51 1.06 1.06 0 0 0 .98.55zm-9 1.09v-1.18h2v-5.19l-1.86 1-.55-1.06 2.32-1.3H14v6.5h1.78V22z"}),props.children);});var Forward_1020=/*#__PURE__*/React.forwardRef(function Forward_1020(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 18A10 10 0 1 1 16 8h4v5l6-6-6-6v5h-4a12 12 0 1 0 12 12z"}),React.createElement("path",{d:"M19.63 22.13a2.84 2.84 0 0 1-1.28-.27 2.44 2.44 0 0 1-.89-.77 3.57 3.57 0 0 1-.52-1.25 7.69 7.69 0 0 1-.17-1.68 7.83 7.83 0 0 1 .17-1.68 3.65 3.65 0 0 1 .52-1.25 2.44 2.44 0 0 1 .89-.77 2.84 2.84 0 0 1 1.28-.27 2.44 2.44 0 0 1 2.16 1 5.23 5.23 0 0 1 .7 2.93 5.23 5.23 0 0 1-.7 2.93 2.44 2.44 0 0 1-2.16 1.08zm0-1.22a1.07 1.07 0 0 0 1-.55 3.38 3.38 0 0 0 .37-1.51v-1.38a3.31 3.31 0 0 0-.29-1.5 1.23 1.23 0 0 0-2.06 0 3.31 3.31 0 0 0-.29 1.5v1.38a3.38 3.38 0 0 0 .29 1.51 1.06 1.06 0 0 0 .98.55zm-9 1.09v-1.18h2v-5.19l-1.86 1-.55-1.06 2.32-1.3H14v6.5h1.78V22z"}),props.children);});var Forward_1016=/*#__PURE__*/React.forwardRef(function Forward_1016(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 18A10 10 0 1 1 16 8h4v5l6-6-6-6v5h-4a12 12 0 1 0 12 12z"}),React.createElement("path",{d:"M19.63 22.13a2.84 2.84 0 0 1-1.28-.27 2.44 2.44 0 0 1-.89-.77 3.57 3.57 0 0 1-.52-1.25 7.69 7.69 0 0 1-.17-1.68 7.83 7.83 0 0 1 .17-1.68 3.65 3.65 0 0 1 .52-1.25 2.44 2.44 0 0 1 .89-.77 2.84 2.84 0 0 1 1.28-.27 2.44 2.44 0 0 1 2.16 1 5.23 5.23 0 0 1 .7 2.93 5.23 5.23 0 0 1-.7 2.93 2.44 2.44 0 0 1-2.16 1.08zm0-1.22a1.07 1.07 0 0 0 1-.55 3.38 3.38 0 0 0 .37-1.51v-1.38a3.31 3.31 0 0 0-.29-1.5 1.23 1.23 0 0 0-2.06 0 3.31 3.31 0 0 0-.29 1.5v1.38a3.38 3.38 0 0 0 .29 1.51 1.06 1.06 0 0 0 .98.55zm-9 1.09v-1.18h2v-5.19l-1.86 1-.55-1.06 2.32-1.3H14v6.5h1.78V22z"}),props.children);});var Forward_3032=/*#__PURE__*/React.forwardRef(function Forward_3032(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 18A10 10 0 1 1 16 8h4v5l6-6-6-6v5h-4a12 12 0 1 0 12 12z"}),React.createElement("path",{d:"M19.64 22.13a2.81 2.81 0 0 1-1.28-.27 2.36 2.36 0 0 1-.89-.77 3.39 3.39 0 0 1-.47-1.25 7.12 7.12 0 0 1-.17-1.68 7.24 7.24 0 0 1 .17-1.68 3.46 3.46 0 0 1 .52-1.25 2.36 2.36 0 0 1 .89-.77 2.81 2.81 0 0 1 1.28-.27 2.44 2.44 0 0 1 2.16 1 5.31 5.31 0 0 1 .7 2.93 5.31 5.31 0 0 1-.7 2.93 2.44 2.44 0 0 1-2.21 1.08zm0-1.22a1 1 0 0 0 1-.55 3.24 3.24 0 0 0 .3-1.51v-1.38a3.17 3.17 0 0 0-.3-1.5 1.22 1.22 0 0 0-2.05 0 3.18 3.18 0 0 0-.29 1.5v1.38a3.25 3.25 0 0 0 .29 1.51 1 1 0 0 0 1.05.55zm-7.02-3.49a1.46 1.46 0 0 0 1-.27.84.84 0 0 0 .31-.68v-.08a.94.94 0 0 0-.3-.74 1.2 1.2 0 0 0-.83-.27 1.65 1.65 0 0 0-.89.24 2.1 2.1 0 0 0-.68.68l-.93-.83a5.37 5.37 0 0 1 .44-.51 2.7 2.7 0 0 1 .54-.4 2.55 2.55 0 0 1 .7-.27 3.25 3.25 0 0 1 .87-.1 3.94 3.94 0 0 1 1.06.14 2.33 2.33 0 0 1 .82.4 1.91 1.91 0 0 1 .54.63 1.87 1.87 0 0 1 .18.83 2 2 0 0 1-.11.67 1.82 1.82 0 0 1-.32.52 1.79 1.79 0 0 1-.47.36 2.27 2.27 0 0 1-.57.2V18a2.34 2.34 0 0 1 .63.21 1.7 1.7 0 0 1 .51.38 1.89 1.89 0 0 1 .34.55 2.07 2.07 0 0 1 .12.73 2 2 0 0 1-.2.92 2 2 0 0 1-.58.72 2.66 2.66 0 0 1-.89.45 3.76 3.76 0 0 1-1.15.16 4.1 4.1 0 0 1-1-.11 3.1 3.1 0 0 1-.76-.31 2.76 2.76 0 0 1-.56-.45 4.22 4.22 0 0 1-.44-.55l1.07-.81a3.07 3.07 0 0 0 .28.42 1.94 1.94 0 0 0 .36.34 1.57 1.57 0 0 0 .45.22 2 2 0 0 0 .57.07 1.45 1.45 0 0 0 1-.3 1.12 1.12 0 0 0 .34-.85v-.08a1 1 0 0 0-.37-.8 1.78 1.78 0 0 0-1.06-.28h-.76v-1.21z"}),props.children);});var Forward_3024=/*#__PURE__*/React.forwardRef(function Forward_3024(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 18A10 10 0 1 1 16 8h4v5l6-6-6-6v5h-4a12 12 0 1 0 12 12z"}),React.createElement("path",{d:"M19.64 22.13a2.81 2.81 0 0 1-1.28-.27 2.36 2.36 0 0 1-.89-.77 3.39 3.39 0 0 1-.47-1.25 7.12 7.12 0 0 1-.17-1.68 7.24 7.24 0 0 1 .17-1.68 3.46 3.46 0 0 1 .52-1.25 2.36 2.36 0 0 1 .89-.77 2.81 2.81 0 0 1 1.28-.27 2.44 2.44 0 0 1 2.16 1 5.31 5.31 0 0 1 .7 2.93 5.31 5.31 0 0 1-.7 2.93 2.44 2.44 0 0 1-2.21 1.08zm0-1.22a1 1 0 0 0 1-.55 3.24 3.24 0 0 0 .3-1.51v-1.38a3.17 3.17 0 0 0-.3-1.5 1.22 1.22 0 0 0-2.05 0 3.18 3.18 0 0 0-.29 1.5v1.38a3.25 3.25 0 0 0 .29 1.51 1 1 0 0 0 1.05.55zm-7.02-3.49a1.46 1.46 0 0 0 1-.27.84.84 0 0 0 .31-.68v-.08a.94.94 0 0 0-.3-.74 1.2 1.2 0 0 0-.83-.27 1.65 1.65 0 0 0-.89.24 2.1 2.1 0 0 0-.68.68l-.93-.83a5.37 5.37 0 0 1 .44-.51 2.7 2.7 0 0 1 .54-.4 2.55 2.55 0 0 1 .7-.27 3.25 3.25 0 0 1 .87-.1 3.94 3.94 0 0 1 1.06.14 2.33 2.33 0 0 1 .82.4 1.91 1.91 0 0 1 .54.63 1.87 1.87 0 0 1 .18.83 2 2 0 0 1-.11.67 1.82 1.82 0 0 1-.32.52 1.79 1.79 0 0 1-.47.36 2.27 2.27 0 0 1-.57.2V18a2.34 2.34 0 0 1 .63.21 1.7 1.7 0 0 1 .51.38 1.89 1.89 0 0 1 .34.55 2.07 2.07 0 0 1 .12.73 2 2 0 0 1-.2.92 2 2 0 0 1-.58.72 2.66 2.66 0 0 1-.89.45 3.76 3.76 0 0 1-1.15.16 4.1 4.1 0 0 1-1-.11 3.1 3.1 0 0 1-.76-.31 2.76 2.76 0 0 1-.56-.45 4.22 4.22 0 0 1-.44-.55l1.07-.81a3.07 3.07 0 0 0 .28.42 1.94 1.94 0 0 0 .36.34 1.57 1.57 0 0 0 .45.22 2 2 0 0 0 .57.07 1.45 1.45 0 0 0 1-.3 1.12 1.12 0 0 0 .34-.85v-.08a1 1 0 0 0-.37-.8 1.78 1.78 0 0 0-1.06-.28h-.76v-1.21z"}),props.children);});var Forward_3020=/*#__PURE__*/React.forwardRef(function Forward_3020(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 18A10 10 0 1 1 16 8h4v5l6-6-6-6v5h-4a12 12 0 1 0 12 12z"}),React.createElement("path",{d:"M19.64 22.13a2.81 2.81 0 0 1-1.28-.27 2.36 2.36 0 0 1-.89-.77 3.39 3.39 0 0 1-.47-1.25 7.12 7.12 0 0 1-.17-1.68 7.24 7.24 0 0 1 .17-1.68 3.46 3.46 0 0 1 .52-1.25 2.36 2.36 0 0 1 .89-.77 2.81 2.81 0 0 1 1.28-.27 2.44 2.44 0 0 1 2.16 1 5.31 5.31 0 0 1 .7 2.93 5.31 5.31 0 0 1-.7 2.93 2.44 2.44 0 0 1-2.21 1.08zm0-1.22a1 1 0 0 0 1-.55 3.24 3.24 0 0 0 .3-1.51v-1.38a3.17 3.17 0 0 0-.3-1.5 1.22 1.22 0 0 0-2.05 0 3.18 3.18 0 0 0-.29 1.5v1.38a3.25 3.25 0 0 0 .29 1.51 1 1 0 0 0 1.05.55zm-7.02-3.49a1.46 1.46 0 0 0 1-.27.84.84 0 0 0 .31-.68v-.08a.94.94 0 0 0-.3-.74 1.2 1.2 0 0 0-.83-.27 1.65 1.65 0 0 0-.89.24 2.1 2.1 0 0 0-.68.68l-.93-.83a5.37 5.37 0 0 1 .44-.51 2.7 2.7 0 0 1 .54-.4 2.55 2.55 0 0 1 .7-.27 3.25 3.25 0 0 1 .87-.1 3.94 3.94 0 0 1 1.06.14 2.33 2.33 0 0 1 .82.4 1.91 1.91 0 0 1 .54.63 1.87 1.87 0 0 1 .18.83 2 2 0 0 1-.11.67 1.82 1.82 0 0 1-.32.52 1.79 1.79 0 0 1-.47.36 2.27 2.27 0 0 1-.57.2V18a2.34 2.34 0 0 1 .63.21 1.7 1.7 0 0 1 .51.38 1.89 1.89 0 0 1 .34.55 2.07 2.07 0 0 1 .12.73 2 2 0 0 1-.2.92 2 2 0 0 1-.58.72 2.66 2.66 0 0 1-.89.45 3.76 3.76 0 0 1-1.15.16 4.1 4.1 0 0 1-1-.11 3.1 3.1 0 0 1-.76-.31 2.76 2.76 0 0 1-.56-.45 4.22 4.22 0 0 1-.44-.55l1.07-.81a3.07 3.07 0 0 0 .28.42 1.94 1.94 0 0 0 .36.34 1.57 1.57 0 0 0 .45.22 2 2 0 0 0 .57.07 1.45 1.45 0 0 0 1-.3 1.12 1.12 0 0 0 .34-.85v-.08a1 1 0 0 0-.37-.8 1.78 1.78 0 0 0-1.06-.28h-.76v-1.21z"}),props.children);});var Forward_3016=/*#__PURE__*/React.forwardRef(function Forward_3016(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 18A10 10 0 1 1 16 8h4v5l6-6-6-6v5h-4a12 12 0 1 0 12 12z"}),React.createElement("path",{d:"M19.64 22.13a2.81 2.81 0 0 1-1.28-.27 2.36 2.36 0 0 1-.89-.77 3.39 3.39 0 0 1-.47-1.25 7.12 7.12 0 0 1-.17-1.68 7.24 7.24 0 0 1 .17-1.68 3.46 3.46 0 0 1 .52-1.25 2.36 2.36 0 0 1 .89-.77 2.81 2.81 0 0 1 1.28-.27 2.44 2.44 0 0 1 2.16 1 5.31 5.31 0 0 1 .7 2.93 5.31 5.31 0 0 1-.7 2.93 2.44 2.44 0 0 1-2.21 1.08zm0-1.22a1 1 0 0 0 1-.55 3.24 3.24 0 0 0 .3-1.51v-1.38a3.17 3.17 0 0 0-.3-1.5 1.22 1.22 0 0 0-2.05 0 3.18 3.18 0 0 0-.29 1.5v1.38a3.25 3.25 0 0 0 .29 1.51 1 1 0 0 0 1.05.55zm-7.02-3.49a1.46 1.46 0 0 0 1-.27.84.84 0 0 0 .31-.68v-.08a.94.94 0 0 0-.3-.74 1.2 1.2 0 0 0-.83-.27 1.65 1.65 0 0 0-.89.24 2.1 2.1 0 0 0-.68.68l-.93-.83a5.37 5.37 0 0 1 .44-.51 2.7 2.7 0 0 1 .54-.4 2.55 2.55 0 0 1 .7-.27 3.25 3.25 0 0 1 .87-.1 3.94 3.94 0 0 1 1.06.14 2.33 2.33 0 0 1 .82.4 1.91 1.91 0 0 1 .54.63 1.87 1.87 0 0 1 .18.83 2 2 0 0 1-.11.67 1.82 1.82 0 0 1-.32.52 1.79 1.79 0 0 1-.47.36 2.27 2.27 0 0 1-.57.2V18a2.34 2.34 0 0 1 .63.21 1.7 1.7 0 0 1 .51.38 1.89 1.89 0 0 1 .34.55 2.07 2.07 0 0 1 .12.73 2 2 0 0 1-.2.92 2 2 0 0 1-.58.72 2.66 2.66 0 0 1-.89.45 3.76 3.76 0 0 1-1.15.16 4.1 4.1 0 0 1-1-.11 3.1 3.1 0 0 1-.76-.31 2.76 2.76 0 0 1-.56-.45 4.22 4.22 0 0 1-.44-.55l1.07-.81a3.07 3.07 0 0 0 .28.42 1.94 1.94 0 0 0 .36.34 1.57 1.57 0 0 0 .45.22 2 2 0 0 0 .57.07 1.45 1.45 0 0 0 1-.3 1.12 1.12 0 0 0 .34-.85v-.08a1 1 0 0 0-.37-.8 1.78 1.78 0 0 0-1.06-.28h-.76v-1.21z"}),props.children);});var Forward_532=/*#__PURE__*/React.forwardRef(function Forward_532(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 18A10 10 0 1 1 16 8h4v5l6-6-6-6v5h-4a12 12 0 1 0 12 12z"}),React.createElement("path",{d:"M18.58 15.58h-3.45L15 18.15a4.83 4.83 0 0 1 .26-.45 1.59 1.59 0 0 1 .33-.35 1.53 1.53 0 0 1 .44-.23 2 2 0 0 1 .6-.08 2.54 2.54 0 0 1 .92.16 2.06 2.06 0 0 1 .74.48 2.28 2.28 0 0 1 .5.77 2.73 2.73 0 0 1 .18 1 2.87 2.87 0 0 1-.19 1.07 2.36 2.36 0 0 1-.55.84 2.44 2.44 0 0 1-.89.55 3.23 3.23 0 0 1-1.21.2 3.79 3.79 0 0 1-.94-.11 3 3 0 0 1-.74-.32 2.45 2.45 0 0 1-.55-.45 4.13 4.13 0 0 1-.41-.55l1.06-.81.27.41a1.82 1.82 0 0 0 .34.34 1.59 1.59 0 0 0 .43.22 1.52 1.52 0 0 0 .55.08 1.29 1.29 0 0 0 1-.36 1.41 1.41 0 0 0 .33-1v-.06a1.18 1.18 0 0 0-1.28-1.27 1.44 1.44 0 0 0-.77.18 1.94 1.94 0 0 0-.48.39l-1.19-.17.29-4.31h4.52z"}),props.children);});var Forward_524=/*#__PURE__*/React.forwardRef(function Forward_524(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 18A10 10 0 1 1 16 8h4v5l6-6-6-6v5h-4a12 12 0 1 0 12 12z"}),React.createElement("path",{d:"M18.58 15.58h-3.45L15 18.15a4.83 4.83 0 0 1 .26-.45 1.59 1.59 0 0 1 .33-.35 1.53 1.53 0 0 1 .44-.23 2 2 0 0 1 .6-.08 2.54 2.54 0 0 1 .92.16 2.06 2.06 0 0 1 .74.48 2.28 2.28 0 0 1 .5.77 2.73 2.73 0 0 1 .18 1 2.87 2.87 0 0 1-.19 1.07 2.36 2.36 0 0 1-.55.84 2.44 2.44 0 0 1-.89.55 3.23 3.23 0 0 1-1.21.2 3.79 3.79 0 0 1-.94-.11 3 3 0 0 1-.74-.32 2.45 2.45 0 0 1-.55-.45 4.13 4.13 0 0 1-.41-.55l1.06-.81.27.41a1.82 1.82 0 0 0 .34.34 1.59 1.59 0 0 0 .43.22 1.52 1.52 0 0 0 .55.08 1.29 1.29 0 0 0 1-.36 1.41 1.41 0 0 0 .33-1v-.06a1.18 1.18 0 0 0-1.28-1.27 1.44 1.44 0 0 0-.77.18 1.94 1.94 0 0 0-.48.39l-1.19-.17.29-4.31h4.52z"}),props.children);});var Forward_520=/*#__PURE__*/React.forwardRef(function Forward_520(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 18A10 10 0 1 1 16 8h4v5l6-6-6-6v5h-4a12 12 0 1 0 12 12z"}),React.createElement("path",{d:"M18.58 15.58h-3.45L15 18.15a4.83 4.83 0 0 1 .26-.45 1.59 1.59 0 0 1 .33-.35 1.53 1.53 0 0 1 .44-.23 2 2 0 0 1 .6-.08 2.54 2.54 0 0 1 .92.16 2.06 2.06 0 0 1 .74.48 2.28 2.28 0 0 1 .5.77 2.73 2.73 0 0 1 .18 1 2.87 2.87 0 0 1-.19 1.07 2.36 2.36 0 0 1-.55.84 2.44 2.44 0 0 1-.89.55 3.23 3.23 0 0 1-1.21.2 3.79 3.79 0 0 1-.94-.11 3 3 0 0 1-.74-.32 2.45 2.45 0 0 1-.55-.45 4.13 4.13 0 0 1-.41-.55l1.06-.81.27.41a1.82 1.82 0 0 0 .34.34 1.59 1.59 0 0 0 .43.22 1.52 1.52 0 0 0 .55.08 1.29 1.29 0 0 0 1-.36 1.41 1.41 0 0 0 .33-1v-.06a1.18 1.18 0 0 0-1.28-1.27 1.44 1.44 0 0 0-.77.18 1.94 1.94 0 0 0-.48.39l-1.19-.17.29-4.31h4.52z"}),props.children);});var Forward_516=/*#__PURE__*/React.forwardRef(function Forward_516(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 18A10 10 0 1 1 16 8h4v5l6-6-6-6v5h-4a12 12 0 1 0 12 12z"}),React.createElement("path",{d:"M18.58 15.58h-3.45L15 18.15a4.83 4.83 0 0 1 .26-.45 1.59 1.59 0 0 1 .33-.35 1.53 1.53 0 0 1 .44-.23 2 2 0 0 1 .6-.08 2.54 2.54 0 0 1 .92.16 2.06 2.06 0 0 1 .74.48 2.28 2.28 0 0 1 .5.77 2.73 2.73 0 0 1 .18 1 2.87 2.87 0 0 1-.19 1.07 2.36 2.36 0 0 1-.55.84 2.44 2.44 0 0 1-.89.55 3.23 3.23 0 0 1-1.21.2 3.79 3.79 0 0 1-.94-.11 3 3 0 0 1-.74-.32 2.45 2.45 0 0 1-.55-.45 4.13 4.13 0 0 1-.41-.55l1.06-.81.27.41a1.82 1.82 0 0 0 .34.34 1.59 1.59 0 0 0 .43.22 1.52 1.52 0 0 0 .55.08 1.29 1.29 0 0 0 1-.36 1.41 1.41 0 0 0 .33-1v-.06a1.18 1.18 0 0 0-1.28-1.27 1.44 1.44 0 0 0-.77.18 1.94 1.94 0 0 0-.48.39l-1.19-.17.29-4.31h4.52z"}),props.children);});var Function32=/*#__PURE__*/React.forwardRef(function Function32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8.5 30a2.5 2.5 0 0 1 0-5c.63-.07 2.35-1.53 2.49-7.22l-1.78-.45a2.92 2.92 0 0 1 0-5.66l1.79-.46C11.55 4 19.32 2 23.5 2a2.5 2.5 0 0 1 0 5c-.08 0-2.23.15-2.48 4.22l1.77.45a2.92 2.92 0 0 1 0 5.66l-1.79.46C20.49 29.86 8.62 30 8.5 30zm15-26c-.43 0-10.5.11-10.5 8v.78l-3.3.83a.92.92 0 0 0 0 1.78l3.3.83V17c0 9.72-4 10-4.5 10a.5.5 0 0 0 0 1c.43 0 10.5-.17 10.5-11v-.78l3.3-.83a.92.92 0 0 0 0-1.78l-3.3-.83V12c0-6.92 4.46-7 4.5-7a.5.5 0 0 0 0-1z"}),React.createElement("path",{d:"M4.15 23.46a14 14 0 0 1 6.46-20.38l.77 1.84A12 12 0 0 0 5.85 22.4zm17.24 5.46l-.77-1.84a12 12 0 0 0 5.49-17.54l1.69-1.08a14 14 0 0 1-6.41 20.46z"}),props.children);});var Function24=/*#__PURE__*/React.forwardRef(function Function24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8.5 30a2.5 2.5 0 0 1 0-5c.63-.07 2.35-1.53 2.49-7.22l-1.78-.45a2.92 2.92 0 0 1 0-5.66l1.79-.46C11.55 4 19.32 2 23.5 2a2.5 2.5 0 0 1 0 5c-.08 0-2.23.15-2.48 4.22l1.77.45a2.92 2.92 0 0 1 0 5.66l-1.79.46C20.49 29.86 8.62 30 8.5 30zm15-26c-.43 0-10.5.11-10.5 8v.78l-3.3.83a.92.92 0 0 0 0 1.78l3.3.83V17c0 9.72-4 10-4.5 10a.5.5 0 0 0 0 1c.43 0 10.5-.17 10.5-11v-.78l3.3-.83a.92.92 0 0 0 0-1.78l-3.3-.83V12c0-6.92 4.46-7 4.5-7a.5.5 0 0 0 0-1z"}),React.createElement("path",{d:"M4.15 23.46a14 14 0 0 1 6.46-20.38l.77 1.84A12 12 0 0 0 5.85 22.4zm17.24 5.46l-.77-1.84a12 12 0 0 0 5.49-17.54l1.69-1.08a14 14 0 0 1-6.41 20.46z"}),props.children);});var Function20=/*#__PURE__*/React.forwardRef(function Function20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8.5 30a2.5 2.5 0 0 1 0-5c.63-.07 2.35-1.53 2.49-7.22l-1.78-.45a2.92 2.92 0 0 1 0-5.66l1.79-.46C11.55 4 19.32 2 23.5 2a2.5 2.5 0 0 1 0 5c-.08 0-2.23.15-2.48 4.22l1.77.45a2.92 2.92 0 0 1 0 5.66l-1.79.46C20.49 29.86 8.62 30 8.5 30zm15-26c-.43 0-10.5.11-10.5 8v.78l-3.3.83a.92.92 0 0 0 0 1.78l3.3.83V17c0 9.72-4 10-4.5 10a.5.5 0 0 0 0 1c.43 0 10.5-.17 10.5-11v-.78l3.3-.83a.92.92 0 0 0 0-1.78l-3.3-.83V12c0-6.92 4.46-7 4.5-7a.5.5 0 0 0 0-1z"}),React.createElement("path",{d:"M4.15 23.46a14 14 0 0 1 6.46-20.38l.77 1.84A12 12 0 0 0 5.85 22.4zm17.24 5.46l-.77-1.84a12 12 0 0 0 5.49-17.54l1.69-1.08a14 14 0 0 1-6.41 20.46z"}),props.children);});var Function16=/*#__PURE__*/React.forwardRef(function Function16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8.5 30a2.5 2.5 0 0 1 0-5c.63-.07 2.35-1.53 2.49-7.22l-1.78-.45a2.92 2.92 0 0 1 0-5.66l1.79-.46C11.55 4 19.32 2 23.5 2a2.5 2.5 0 0 1 0 5c-.08 0-2.23.15-2.48 4.22l1.77.45a2.92 2.92 0 0 1 0 5.66l-1.79.46C20.49 29.86 8.62 30 8.5 30zm15-26c-.43 0-10.5.11-10.5 8v.78l-3.3.83a.92.92 0 0 0 0 1.78l3.3.83V17c0 9.72-4 10-4.5 10a.5.5 0 0 0 0 1c.43 0 10.5-.17 10.5-11v-.78l3.3-.83a.92.92 0 0 0 0-1.78l-3.3-.83V12c0-6.92 4.46-7 4.5-7a.5.5 0 0 0 0-1z"}),React.createElement("path",{d:"M4.15 23.46a14 14 0 0 1 6.46-20.38l.77 1.84A12 12 0 0 0 5.85 22.4zm17.24 5.46l-.77-1.84a12 12 0 0 0 5.49-17.54l1.69-1.08a14 14 0 0 1-6.41 20.46z"}),props.children);});var GameConsole32=/*#__PURE__*/React.forwardRef(function GameConsole32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7.51 26a5.48 5.48 0 0 1-1.44-.19A5.6 5.6 0 0 1 2.19 19l2.33-8.84a5.54 5.54 0 0 1 2.59-3.43 5.43 5.43 0 0 1 4.15-.54A5.52 5.52 0 0 1 14.7 9h2.6a5.49 5.49 0 0 1 3.44-2.81 5.43 5.43 0 0 1 4.15.54 5.57 5.57 0 0 1 2.59 3.41L29.81 19a5.6 5.6 0 0 1-3.89 6.83 5.43 5.43 0 0 1-4.15-.54 5.54 5.54 0 0 1-2.59-3.41L19 21h-6l-.23.86a5.54 5.54 0 0 1-2.59 3.41 5.46 5.46 0 0 1-2.67.73zM9.83 8a3.49 3.49 0 0 0-1.72.46 3.6 3.6 0 0 0-1.66 2.19l-2.33 8.84a3.6 3.6 0 0 0 2.48 4.39 3.43 3.43 0 0 0 2.62-.34 3.54 3.54 0 0 0 1.66-2.19L11.5 19h9l.61 2.35a3.58 3.58 0 0 0 1.66 2.19 3.46 3.46 0 0 0 2.63.34 3.58 3.58 0 0 0 2.47-4.39l-2.33-8.84a3.55 3.55 0 0 0-1.65-2.19 3.46 3.46 0 0 0-2.63-.34 3.55 3.55 0 0 0-2.37 2.22l-.24.66h-5.3l-.24-.66a3.56 3.56 0 0 0-2.38-2.22 3.48 3.48 0 0 0-.9-.12z"}),React.createElement("path",{d:"M10 16a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm0-2z"}),React.createElement("circle",{cx:"22",cy:"12",r:"1"}),React.createElement("circle",{cx:"22",cy:"16",r:"1"}),React.createElement("circle",{cx:"20",cy:"14",r:"1"}),React.createElement("circle",{cx:"24",cy:"14",r:"1"}),props.children);});var GameConsole24=/*#__PURE__*/React.forwardRef(function GameConsole24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7.51 26a5.48 5.48 0 0 1-1.44-.19A5.6 5.6 0 0 1 2.19 19l2.33-8.84a5.54 5.54 0 0 1 2.59-3.43 5.43 5.43 0 0 1 4.15-.54A5.52 5.52 0 0 1 14.7 9h2.6a5.49 5.49 0 0 1 3.44-2.81 5.43 5.43 0 0 1 4.15.54 5.57 5.57 0 0 1 2.59 3.41L29.81 19a5.6 5.6 0 0 1-3.89 6.83 5.43 5.43 0 0 1-4.15-.54 5.54 5.54 0 0 1-2.59-3.41L19 21h-6l-.23.86a5.54 5.54 0 0 1-2.59 3.41 5.46 5.46 0 0 1-2.67.73zM9.83 8a3.49 3.49 0 0 0-1.72.46 3.6 3.6 0 0 0-1.66 2.19l-2.33 8.84a3.6 3.6 0 0 0 2.48 4.39 3.43 3.43 0 0 0 2.62-.34 3.54 3.54 0 0 0 1.66-2.19L11.5 19h9l.61 2.35a3.58 3.58 0 0 0 1.66 2.19 3.46 3.46 0 0 0 2.63.34 3.58 3.58 0 0 0 2.47-4.39l-2.33-8.84a3.55 3.55 0 0 0-1.65-2.19 3.46 3.46 0 0 0-2.63-.34 3.55 3.55 0 0 0-2.37 2.22l-.24.66h-5.3l-.24-.66a3.56 3.56 0 0 0-2.38-2.22 3.48 3.48 0 0 0-.9-.12z"}),React.createElement("path",{d:"M10 16a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm0-2z"}),React.createElement("circle",{cx:"22",cy:"12",r:"1"}),React.createElement("circle",{cx:"22",cy:"16",r:"1"}),React.createElement("circle",{cx:"20",cy:"14",r:"1"}),React.createElement("circle",{cx:"24",cy:"14",r:"1"}),props.children);});var GameConsole20=/*#__PURE__*/React.forwardRef(function GameConsole20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7.51 26a5.48 5.48 0 0 1-1.44-.19A5.6 5.6 0 0 1 2.19 19l2.33-8.84a5.54 5.54 0 0 1 2.59-3.43 5.43 5.43 0 0 1 4.15-.54A5.52 5.52 0 0 1 14.7 9h2.6a5.49 5.49 0 0 1 3.44-2.81 5.43 5.43 0 0 1 4.15.54 5.57 5.57 0 0 1 2.59 3.41L29.81 19a5.6 5.6 0 0 1-3.89 6.83 5.43 5.43 0 0 1-4.15-.54 5.54 5.54 0 0 1-2.59-3.41L19 21h-6l-.23.86a5.54 5.54 0 0 1-2.59 3.41 5.46 5.46 0 0 1-2.67.73zM9.83 8a3.49 3.49 0 0 0-1.72.46 3.6 3.6 0 0 0-1.66 2.19l-2.33 8.84a3.6 3.6 0 0 0 2.48 4.39 3.43 3.43 0 0 0 2.62-.34 3.54 3.54 0 0 0 1.66-2.19L11.5 19h9l.61 2.35a3.58 3.58 0 0 0 1.66 2.19 3.46 3.46 0 0 0 2.63.34 3.58 3.58 0 0 0 2.47-4.39l-2.33-8.84a3.55 3.55 0 0 0-1.65-2.19 3.46 3.46 0 0 0-2.63-.34 3.55 3.55 0 0 0-2.37 2.22l-.24.66h-5.3l-.24-.66a3.56 3.56 0 0 0-2.38-2.22 3.48 3.48 0 0 0-.9-.12z"}),React.createElement("path",{d:"M10 16a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm0-2z"}),React.createElement("circle",{cx:"22",cy:"12",r:"1"}),React.createElement("circle",{cx:"22",cy:"16",r:"1"}),React.createElement("circle",{cx:"20",cy:"14",r:"1"}),React.createElement("circle",{cx:"24",cy:"14",r:"1"}),props.children);});var GameConsole16=/*#__PURE__*/React.forwardRef(function GameConsole16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7.51 26a5.48 5.48 0 0 1-1.44-.19A5.6 5.6 0 0 1 2.19 19l2.33-8.84a5.54 5.54 0 0 1 2.59-3.43 5.43 5.43 0 0 1 4.15-.54A5.52 5.52 0 0 1 14.7 9h2.6a5.49 5.49 0 0 1 3.44-2.81 5.43 5.43 0 0 1 4.15.54 5.57 5.57 0 0 1 2.59 3.41L29.81 19a5.6 5.6 0 0 1-3.89 6.83 5.43 5.43 0 0 1-4.15-.54 5.54 5.54 0 0 1-2.59-3.41L19 21h-6l-.23.86a5.54 5.54 0 0 1-2.59 3.41 5.46 5.46 0 0 1-2.67.73zM9.83 8a3.49 3.49 0 0 0-1.72.46 3.6 3.6 0 0 0-1.66 2.19l-2.33 8.84a3.6 3.6 0 0 0 2.48 4.39 3.43 3.43 0 0 0 2.62-.34 3.54 3.54 0 0 0 1.66-2.19L11.5 19h9l.61 2.35a3.58 3.58 0 0 0 1.66 2.19 3.46 3.46 0 0 0 2.63.34 3.58 3.58 0 0 0 2.47-4.39l-2.33-8.84a3.55 3.55 0 0 0-1.65-2.19 3.46 3.46 0 0 0-2.63-.34 3.55 3.55 0 0 0-2.37 2.22l-.24.66h-5.3l-.24-.66a3.56 3.56 0 0 0-2.38-2.22 3.48 3.48 0 0 0-.9-.12z"}),React.createElement("path",{d:"M10 16a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm0-2z"}),React.createElement("circle",{cx:"22",cy:"12",r:"1"}),React.createElement("circle",{cx:"22",cy:"16",r:"1"}),React.createElement("circle",{cx:"20",cy:"14",r:"1"}),React.createElement("circle",{cx:"24",cy:"14",r:"1"}),props.children);});var GameWireless32=/*#__PURE__*/React.forwardRef(function GameWireless32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7.51 30a5.48 5.48 0 0 1-1.44-.19A5.6 5.6 0 0 1 2.19 23l2.33-8.84a5.54 5.54 0 0 1 2.59-3.41 5.43 5.43 0 0 1 4.15-.54A5.52 5.52 0 0 1 14.7 13h2.6a5.49 5.49 0 0 1 3.44-2.81 5.43 5.43 0 0 1 4.15.54 5.55 5.55 0 0 1 2.59 3.41L29.81 23a5.6 5.6 0 0 1-3.89 6.83 5.43 5.43 0 0 1-4.15-.54 5.54 5.54 0 0 1-2.59-3.41L19 25h-6l-.23.86a5.54 5.54 0 0 1-2.59 3.41 5.46 5.46 0 0 1-2.67.73zm2.32-18a3.49 3.49 0 0 0-1.72.46 3.58 3.58 0 0 0-1.66 2.19l-2.33 8.84a3.6 3.6 0 0 0 2.48 4.39 3.43 3.43 0 0 0 2.62-.34 3.57 3.57 0 0 0 1.66-2.19L11.5 23h9l.61 2.35a3.6 3.6 0 0 0 1.66 2.19 3.46 3.46 0 0 0 2.63.34 3.58 3.58 0 0 0 2.47-4.39l-2.33-8.84a3.53 3.53 0 0 0-1.65-2.19 3.46 3.46 0 0 0-2.63-.34 3.55 3.55 0 0 0-2.37 2.22l-.24.66h-5.3l-.24-.66a3.56 3.56 0 0 0-2.38-2.22 3.48 3.48 0 0 0-.9-.12z"}),React.createElement("path",{d:"M10 20a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm0-2z"}),React.createElement("circle",{cx:"22",cy:"16",r:"1"}),React.createElement("circle",{cx:"22",cy:"20",r:"1"}),React.createElement("circle",{cx:"20",cy:"18",r:"1"}),React.createElement("circle",{cx:"24",cy:"18",r:"1"}),React.createElement("path",{d:"M13.75 9l-1.5-1.33a5 5 0 0 1 7.5 0L18.25 9a3 3 0 0 0-4.5 0z"}),React.createElement("path",{d:"M21.25 6.37a7 7 0 0 0-10.5 0l-1.5-1.32a9 9 0 0 1 13.5 0z"}),props.children);});var GameWireless24=/*#__PURE__*/React.forwardRef(function GameWireless24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7.51 30a5.48 5.48 0 0 1-1.44-.19A5.6 5.6 0 0 1 2.19 23l2.33-8.84a5.54 5.54 0 0 1 2.59-3.41 5.43 5.43 0 0 1 4.15-.54A5.52 5.52 0 0 1 14.7 13h2.6a5.49 5.49 0 0 1 3.44-2.81 5.43 5.43 0 0 1 4.15.54 5.55 5.55 0 0 1 2.59 3.41L29.81 23a5.6 5.6 0 0 1-3.89 6.83 5.43 5.43 0 0 1-4.15-.54 5.54 5.54 0 0 1-2.59-3.41L19 25h-6l-.23.86a5.54 5.54 0 0 1-2.59 3.41 5.46 5.46 0 0 1-2.67.73zm2.32-18a3.49 3.49 0 0 0-1.72.46 3.58 3.58 0 0 0-1.66 2.19l-2.33 8.84a3.6 3.6 0 0 0 2.48 4.39 3.43 3.43 0 0 0 2.62-.34 3.57 3.57 0 0 0 1.66-2.19L11.5 23h9l.61 2.35a3.6 3.6 0 0 0 1.66 2.19 3.46 3.46 0 0 0 2.63.34 3.58 3.58 0 0 0 2.47-4.39l-2.33-8.84a3.53 3.53 0 0 0-1.65-2.19 3.46 3.46 0 0 0-2.63-.34 3.55 3.55 0 0 0-2.37 2.22l-.24.66h-5.3l-.24-.66a3.56 3.56 0 0 0-2.38-2.22 3.48 3.48 0 0 0-.9-.12z"}),React.createElement("path",{d:"M10 20a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm0-2z"}),React.createElement("circle",{cx:"22",cy:"16",r:"1"}),React.createElement("circle",{cx:"22",cy:"20",r:"1"}),React.createElement("circle",{cx:"20",cy:"18",r:"1"}),React.createElement("circle",{cx:"24",cy:"18",r:"1"}),React.createElement("path",{d:"M13.75 9l-1.5-1.33a5 5 0 0 1 7.5 0L18.25 9a3 3 0 0 0-4.5 0z"}),React.createElement("path",{d:"M21.25 6.37a7 7 0 0 0-10.5 0l-1.5-1.32a9 9 0 0 1 13.5 0z"}),props.children);});var GameWireless20=/*#__PURE__*/React.forwardRef(function GameWireless20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7.51 30a5.48 5.48 0 0 1-1.44-.19A5.6 5.6 0 0 1 2.19 23l2.33-8.84a5.54 5.54 0 0 1 2.59-3.41 5.43 5.43 0 0 1 4.15-.54A5.52 5.52 0 0 1 14.7 13h2.6a5.49 5.49 0 0 1 3.44-2.81 5.43 5.43 0 0 1 4.15.54 5.55 5.55 0 0 1 2.59 3.41L29.81 23a5.6 5.6 0 0 1-3.89 6.83 5.43 5.43 0 0 1-4.15-.54 5.54 5.54 0 0 1-2.59-3.41L19 25h-6l-.23.86a5.54 5.54 0 0 1-2.59 3.41 5.46 5.46 0 0 1-2.67.73zm2.32-18a3.49 3.49 0 0 0-1.72.46 3.58 3.58 0 0 0-1.66 2.19l-2.33 8.84a3.6 3.6 0 0 0 2.48 4.39 3.43 3.43 0 0 0 2.62-.34 3.57 3.57 0 0 0 1.66-2.19L11.5 23h9l.61 2.35a3.6 3.6 0 0 0 1.66 2.19 3.46 3.46 0 0 0 2.63.34 3.58 3.58 0 0 0 2.47-4.39l-2.33-8.84a3.53 3.53 0 0 0-1.65-2.19 3.46 3.46 0 0 0-2.63-.34 3.55 3.55 0 0 0-2.37 2.22l-.24.66h-5.3l-.24-.66a3.56 3.56 0 0 0-2.38-2.22 3.48 3.48 0 0 0-.9-.12z"}),React.createElement("path",{d:"M10 20a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm0-2z"}),React.createElement("circle",{cx:"22",cy:"16",r:"1"}),React.createElement("circle",{cx:"22",cy:"20",r:"1"}),React.createElement("circle",{cx:"20",cy:"18",r:"1"}),React.createElement("circle",{cx:"24",cy:"18",r:"1"}),React.createElement("path",{d:"M13.75 9l-1.5-1.33a5 5 0 0 1 7.5 0L18.25 9a3 3 0 0 0-4.5 0z"}),React.createElement("path",{d:"M21.25 6.37a7 7 0 0 0-10.5 0l-1.5-1.32a9 9 0 0 1 13.5 0z"}),props.children);});var GameWireless16=/*#__PURE__*/React.forwardRef(function GameWireless16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7.51 30a5.48 5.48 0 0 1-1.44-.19A5.6 5.6 0 0 1 2.19 23l2.33-8.84a5.54 5.54 0 0 1 2.59-3.41 5.43 5.43 0 0 1 4.15-.54A5.52 5.52 0 0 1 14.7 13h2.6a5.49 5.49 0 0 1 3.44-2.81 5.43 5.43 0 0 1 4.15.54 5.55 5.55 0 0 1 2.59 3.41L29.81 23a5.6 5.6 0 0 1-3.89 6.83 5.43 5.43 0 0 1-4.15-.54 5.54 5.54 0 0 1-2.59-3.41L19 25h-6l-.23.86a5.54 5.54 0 0 1-2.59 3.41 5.46 5.46 0 0 1-2.67.73zm2.32-18a3.49 3.49 0 0 0-1.72.46 3.58 3.58 0 0 0-1.66 2.19l-2.33 8.84a3.6 3.6 0 0 0 2.48 4.39 3.43 3.43 0 0 0 2.62-.34 3.57 3.57 0 0 0 1.66-2.19L11.5 23h9l.61 2.35a3.6 3.6 0 0 0 1.66 2.19 3.46 3.46 0 0 0 2.63.34 3.58 3.58 0 0 0 2.47-4.39l-2.33-8.84a3.53 3.53 0 0 0-1.65-2.19 3.46 3.46 0 0 0-2.63-.34 3.55 3.55 0 0 0-2.37 2.22l-.24.66h-5.3l-.24-.66a3.56 3.56 0 0 0-2.38-2.22 3.48 3.48 0 0 0-.9-.12z"}),React.createElement("path",{d:"M10 20a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm0-2z"}),React.createElement("circle",{cx:"22",cy:"16",r:"1"}),React.createElement("circle",{cx:"22",cy:"20",r:"1"}),React.createElement("circle",{cx:"20",cy:"18",r:"1"}),React.createElement("circle",{cx:"24",cy:"18",r:"1"}),React.createElement("path",{d:"M13.75 9l-1.5-1.33a5 5 0 0 1 7.5 0L18.25 9a3 3 0 0 0-4.5 0z"}),React.createElement("path",{d:"M21.25 6.37a7 7 0 0 0-10.5 0l-1.5-1.32a9 9 0 0 1 13.5 0z"}),props.children);});var Globe32=/*#__PURE__*/React.forwardRef(function Globe32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M14 4a7 7 0 1 1-7 7 7 7 0 0 1 7-7m0-2a9 9 0 1 0 9 9 9 9 0 0 0-9-9z"}),React.createElement("path",{d:"M28 11a13.92 13.92 0 0 0-4.11-9.89l-1.41 1.41a12 12 0 0 1-16.92 17l-1.45 1.37A13.92 13.92 0 0 0 14 25v3h-4v2h10v-2h-4v-3.16A14 14 0 0 0 28 11z"}),props.children);});var Globe24=/*#__PURE__*/React.forwardRef(function Globe24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M14 4a7 7 0 1 1-7 7 7 7 0 0 1 7-7m0-2a9 9 0 1 0 9 9 9 9 0 0 0-9-9z"}),React.createElement("path",{d:"M28 11a13.92 13.92 0 0 0-4.11-9.89l-1.41 1.41a12 12 0 0 1-16.92 17l-1.45 1.37A13.92 13.92 0 0 0 14 25v3h-4v2h10v-2h-4v-3.16A14 14 0 0 0 28 11z"}),props.children);});var Globe20=/*#__PURE__*/React.forwardRef(function Globe20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M14 4a7 7 0 1 1-7 7 7 7 0 0 1 7-7m0-2a9 9 0 1 0 9 9 9 9 0 0 0-9-9z"}),React.createElement("path",{d:"M28 11a13.92 13.92 0 0 0-4.11-9.89l-1.41 1.41a12 12 0 0 1-16.92 17l-1.45 1.37A13.92 13.92 0 0 0 14 25v3h-4v2h10v-2h-4v-3.16A14 14 0 0 0 28 11z"}),props.children);});var Globe16=/*#__PURE__*/React.forwardRef(function Globe16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M14 4a7 7 0 1 1-7 7 7 7 0 0 1 7-7m0-2a9 9 0 1 0 9 9 9 9 0 0 0-9-9z"}),React.createElement("path",{d:"M28 11a13.92 13.92 0 0 0-4.11-9.89l-1.41 1.41a12 12 0 0 1-16.92 17l-1.45 1.37A13.92 13.92 0 0 0 14 25v3h-4v2h10v-2h-4v-3.16A14 14 0 0 0 28 11z"}),props.children);});var Grid32=/*#__PURE__*/React.forwardRef(function Grid32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 4H6a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm0 8H6V6h6zm14-8h-6a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm0 8h-6V6h6zm-14 6H6a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2zm0 8H6v-6h6zm14-8h-6a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2zm0 8h-6v-6h6z"}),props.children);});var Grid24=/*#__PURE__*/React.forwardRef(function Grid24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 4H6a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm0 8H6V6h6zm14-8h-6a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm0 8h-6V6h6zm-14 6H6a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2zm0 8H6v-6h6zm14-8h-6a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2zm0 8h-6v-6h6z"}),props.children);});var Grid20=/*#__PURE__*/React.forwardRef(function Grid20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 4H6a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm0 8H6V6h6zm14-8h-6a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm0 8h-6V6h6zm-14 6H6a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2zm0 8H6v-6h6zm14-8h-6a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2zm0 8h-6v-6h6z"}),props.children);});var Group32=/*#__PURE__*/React.forwardRef(function Group32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M31 30h-2v-3a3 3 0 0 0-3-3h-4a3 3 0 0 0-3 3v3h-2v-3a5 5 0 0 1 5-5h4a5 5 0 0 1 5 5zm-7-18a3 3 0 1 1-3 3 3 3 0 0 1 3-3m0-2a5 5 0 1 0 5 5 5 5 0 0 0-5-5zm-9 12h-2v-3a3 3 0 0 0-3-3H6a3 3 0 0 0-3 3v3H1v-3a5 5 0 0 1 5-5h4a5 5 0 0 1 5 5zM8 4a3 3 0 1 1-3 3 3 3 0 0 1 3-3m0-2a5 5 0 1 0 5 5 5 5 0 0 0-5-5z"}),props.children);});var Group24=/*#__PURE__*/React.forwardRef(function Group24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M31 30h-2v-3a3 3 0 0 0-3-3h-4a3 3 0 0 0-3 3v3h-2v-3a5 5 0 0 1 5-5h4a5 5 0 0 1 5 5zm-7-18a3 3 0 1 1-3 3 3 3 0 0 1 3-3m0-2a5 5 0 1 0 5 5 5 5 0 0 0-5-5zm-9 12h-2v-3a3 3 0 0 0-3-3H6a3 3 0 0 0-3 3v3H1v-3a5 5 0 0 1 5-5h4a5 5 0 0 1 5 5zM8 4a3 3 0 1 1-3 3 3 3 0 0 1 3-3m0-2a5 5 0 1 0 5 5 5 5 0 0 0-5-5z"}),props.children);});var Group20=/*#__PURE__*/React.forwardRef(function Group20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M31 30h-2v-3a3 3 0 0 0-3-3h-4a3 3 0 0 0-3 3v3h-2v-3a5 5 0 0 1 5-5h4a5 5 0 0 1 5 5zm-7-18a3 3 0 1 1-3 3 3 3 0 0 1 3-3m0-2a5 5 0 1 0 5 5 5 5 0 0 0-5-5zm-9 12h-2v-3a3 3 0 0 0-3-3H6a3 3 0 0 0-3 3v3H1v-3a5 5 0 0 1 5-5h4a5 5 0 0 1 5 5zM8 4a3 3 0 1 1-3 3 3 3 0 0 1 3-3m0-2a5 5 0 1 0 5 5 5 5 0 0 0-5-5z"}),props.children);});var Group16=/*#__PURE__*/React.forwardRef(function Group16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M31 30h-2v-3a3 3 0 0 0-3-3h-4a3 3 0 0 0-3 3v3h-2v-3a5 5 0 0 1 5-5h4a5 5 0 0 1 5 5zm-7-18a3 3 0 1 1-3 3 3 3 0 0 1 3-3m0-2a5 5 0 1 0 5 5 5 5 0 0 0-5-5zm-9 12h-2v-3a3 3 0 0 0-3-3H6a3 3 0 0 0-3 3v3H1v-3a5 5 0 0 1 5-5h4a5 5 0 0 1 5 5zM8 4a3 3 0 1 1-3 3 3 3 0 0 1 3-3m0-2a5 5 0 1 0 5 5 5 5 0 0 0-5-5z"}),props.children);});var Headphones32=/*#__PURE__*/React.forwardRef(function Headphones32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 16v-1a9 9 0 0 0-18 0v1a5 5 0 0 0 0 10h2V15a7 7 0 0 1 14 0v11h2a5 5 0 0 0 0-10zM4 21a3 3 0 0 1 3-3v6a3 3 0 0 1-3-3zm21 3v-6a3 3 0 0 1 0 6z"}),props.children);});var Headphones24=/*#__PURE__*/React.forwardRef(function Headphones24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 16v-1a9 9 0 0 0-18 0v1a5 5 0 0 0 0 10h2V15a7 7 0 0 1 14 0v11h2a5 5 0 0 0 0-10zM4 21a3 3 0 0 1 3-3v6a3 3 0 0 1-3-3zm21 3v-6a3 3 0 0 1 0 6z"}),props.children);});var Headphones20=/*#__PURE__*/React.forwardRef(function Headphones20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 16v-1a9 9 0 0 0-18 0v1a5 5 0 0 0 0 10h2V15a7 7 0 0 1 14 0v11h2a5 5 0 0 0 0-10zM4 21a3 3 0 0 1 3-3v6a3 3 0 0 1-3-3zm21 3v-6a3 3 0 0 1 0 6z"}),props.children);});var Headphones16=/*#__PURE__*/React.forwardRef(function Headphones16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 16v-1a9 9 0 0 0-18 0v1a5 5 0 0 0 0 10h2V15a7 7 0 0 1 14 0v11h2a5 5 0 0 0 0-10zM4 21a3 3 0 0 1 3-3v6a3 3 0 0 1-3-3zm21 3v-6a3 3 0 0 1 0 6z"}),props.children);});var Headset32=/*#__PURE__*/React.forwardRef(function Headset32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 10h-.06a9 9 0 0 0-17.88 0H7a5 5 0 0 0 0 10h2v-9a7 7 0 0 1 14 0v10a4 4 0 0 1-3.17 3.91 4 4 0 1 0 .05 2A6 6 0 0 0 25 21v-1a5 5 0 0 0 0-10zM4 15a3 3 0 0 1 3-3v6a3 3 0 0 1-3-3zm12 13a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm9-10v-6a3 3 0 0 1 0 6z"}),props.children);});var Headset24=/*#__PURE__*/React.forwardRef(function Headset24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 10h-.06a9 9 0 0 0-17.88 0H7a5 5 0 0 0 0 10h2v-9a7 7 0 0 1 14 0v10a4 4 0 0 1-3.17 3.91 4 4 0 1 0 .05 2A6 6 0 0 0 25 21v-1a5 5 0 0 0 0-10zM4 15a3 3 0 0 1 3-3v6a3 3 0 0 1-3-3zm12 13a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm9-10v-6a3 3 0 0 1 0 6z"}),props.children);});var Headset20=/*#__PURE__*/React.forwardRef(function Headset20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 10h-.06a9 9 0 0 0-17.88 0H7a5 5 0 0 0 0 10h2v-9a7 7 0 0 1 14 0v10a4 4 0 0 1-3.17 3.91 4 4 0 1 0 .05 2A6 6 0 0 0 25 21v-1a5 5 0 0 0 0-10zM4 15a3 3 0 0 1 3-3v6a3 3 0 0 1-3-3zm12 13a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm9-10v-6a3 3 0 0 1 0 6z"}),props.children);});var Headset16=/*#__PURE__*/React.forwardRef(function Headset16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 10h-.06a9 9 0 0 0-17.88 0H7a5 5 0 0 0 0 10h2v-9a7 7 0 0 1 14 0v10a4 4 0 0 1-3.17 3.91 4 4 0 1 0 .05 2A6 6 0 0 0 25 21v-1a5 5 0 0 0 0-10zM4 15a3 3 0 0 1 3-3v6a3 3 0 0 1-3-3zm12 13a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm9-10v-6a3 3 0 0 1 0 6z"}),props.children);});var HealthCross32=/*#__PURE__*/React.forwardRef(function HealthCross32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19 28h-6a2.002 2.002 0 0 1-2-2v-5H6a2.002 2.002 0 0 1-2-2v-6a2.002 2.002 0 0 1 2-2h5V6a2.002 2.002 0 0 1 2-2h6a2.002 2.002 0 0 1 2 2v5h5a2.002 2.002 0 0 1 2 2v6a2.003 2.003 0 0 1-2 2h-5v5a2.003 2.003 0 0 1-2 2zM6 13v6h7v7h6v-7h7v-6h-7V6h-6v7z"}),props.children);});var HealthCross24=/*#__PURE__*/React.forwardRef(function HealthCross24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19 28h-6a2.002 2.002 0 0 1-2-2v-5H6a2.002 2.002 0 0 1-2-2v-6a2.002 2.002 0 0 1 2-2h5V6a2.002 2.002 0 0 1 2-2h6a2.002 2.002 0 0 1 2 2v5h5a2.002 2.002 0 0 1 2 2v6a2.003 2.003 0 0 1-2 2h-5v5a2.003 2.003 0 0 1-2 2zM6 13v6h7v7h6v-7h7v-6h-7V6h-6v7z"}),props.children);});var HealthCross20=/*#__PURE__*/React.forwardRef(function HealthCross20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19 28h-6a2.002 2.002 0 0 1-2-2v-5H6a2.002 2.002 0 0 1-2-2v-6a2.002 2.002 0 0 1 2-2h5V6a2.002 2.002 0 0 1 2-2h6a2.002 2.002 0 0 1 2 2v5h5a2.002 2.002 0 0 1 2 2v6a2.003 2.003 0 0 1-2 2h-5v5a2.003 2.003 0 0 1-2 2zM6 13v6h7v7h6v-7h7v-6h-7V6h-6v7z"}),props.children);});var HealthCross16=/*#__PURE__*/React.forwardRef(function HealthCross16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19 28h-6a2.002 2.002 0 0 1-2-2v-5H6a2.002 2.002 0 0 1-2-2v-6a2.002 2.002 0 0 1 2-2h5V6a2.002 2.002 0 0 1 2-2h6a2.002 2.002 0 0 1 2 2v5h5a2.002 2.002 0 0 1 2 2v6a2.003 2.003 0 0 1-2 2h-5v5a2.003 2.003 0 0 1-2 2zM6 13v6h7v7h6v-7h7v-6h-7V6h-6v7z"}),props.children);});var Hearing32=/*#__PURE__*/React.forwardRef(function Hearing32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 30v-2a10.011 10.011 0 0 0 10-10h2a12.013 12.013 0 0 1-12 12z"}),React.createElement("path",{d:"M18 26v-2a6.007 6.007 0 0 0 6-6h2a8.01 8.01 0 0 1-8 8z"}),React.createElement("path",{d:"M18 22v-2a2.002 2.002 0 0 0 2-2h2a4.004 4.004 0 0 1-4 4zM10 2a9.01 9.01 0 0 0-9 9h2a7 7 0 0 1 14 0 7.09 7.09 0 0 1-3.501 6.135l-.499.288v3.073a2.935 2.935 0 0 1-.9 2.151 4.182 4.182 0 0 1-4.633 1.03A4.092 4.092 0 0 1 5 20H3a6.116 6.116 0 0 0 3.67 5.512 5.782 5.782 0 0 0 2.314.486 6.585 6.585 0 0 0 4.478-1.888A4.94 4.94 0 0 0 15 20.496v-1.942A9.108 9.108 0 0 0 19 11a9.01 9.01 0 0 0-9-9z"}),React.createElement("path",{d:"M9.28 8.082A3.006 3.006 0 0 1 13 11h2a4.979 4.979 0 0 0-1.884-3.911 5.041 5.041 0 0 0-4.281-.957 4.95 4.95 0 0 0-3.703 3.703 5.032 5.032 0 0 0 2.304 5.458A3.078 3.078 0 0 1 9 17.924V20h2v-2.077a5.06 5.06 0 0 0-2.537-4.346 3.002 3.002 0 0 1 .817-5.495z"}),props.children);});var Hearing24=/*#__PURE__*/React.forwardRef(function Hearing24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 30v-2a10.011 10.011 0 0 0 10-10h2a12.013 12.013 0 0 1-12 12z"}),React.createElement("path",{d:"M18 26v-2a6.007 6.007 0 0 0 6-6h2a8.01 8.01 0 0 1-8 8z"}),React.createElement("path",{d:"M18 22v-2a2.002 2.002 0 0 0 2-2h2a4.004 4.004 0 0 1-4 4zM10 2a9.01 9.01 0 0 0-9 9h2a7 7 0 0 1 14 0 7.09 7.09 0 0 1-3.501 6.135l-.499.288v3.073a2.935 2.935 0 0 1-.9 2.151 4.182 4.182 0 0 1-4.633 1.03A4.092 4.092 0 0 1 5 20H3a6.116 6.116 0 0 0 3.67 5.512 5.782 5.782 0 0 0 2.314.486 6.585 6.585 0 0 0 4.478-1.888A4.94 4.94 0 0 0 15 20.496v-1.942A9.108 9.108 0 0 0 19 11a9.01 9.01 0 0 0-9-9z"}),React.createElement("path",{d:"M9.28 8.082A3.006 3.006 0 0 1 13 11h2a4.979 4.979 0 0 0-1.884-3.911 5.041 5.041 0 0 0-4.281-.957 4.95 4.95 0 0 0-3.703 3.703 5.032 5.032 0 0 0 2.304 5.458A3.078 3.078 0 0 1 9 17.924V20h2v-2.077a5.06 5.06 0 0 0-2.537-4.346 3.002 3.002 0 0 1 .817-5.495z"}),props.children);});var Hearing20=/*#__PURE__*/React.forwardRef(function Hearing20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 30v-2a10.011 10.011 0 0 0 10-10h2a12.013 12.013 0 0 1-12 12z"}),React.createElement("path",{d:"M18 26v-2a6.007 6.007 0 0 0 6-6h2a8.01 8.01 0 0 1-8 8z"}),React.createElement("path",{d:"M18 22v-2a2.002 2.002 0 0 0 2-2h2a4.004 4.004 0 0 1-4 4zM10 2a9.01 9.01 0 0 0-9 9h2a7 7 0 0 1 14 0 7.09 7.09 0 0 1-3.501 6.135l-.499.288v3.073a2.935 2.935 0 0 1-.9 2.151 4.182 4.182 0 0 1-4.633 1.03A4.092 4.092 0 0 1 5 20H3a6.116 6.116 0 0 0 3.67 5.512 5.782 5.782 0 0 0 2.314.486 6.585 6.585 0 0 0 4.478-1.888A4.94 4.94 0 0 0 15 20.496v-1.942A9.108 9.108 0 0 0 19 11a9.01 9.01 0 0 0-9-9z"}),React.createElement("path",{d:"M9.28 8.082A3.006 3.006 0 0 1 13 11h2a4.979 4.979 0 0 0-1.884-3.911 5.041 5.041 0 0 0-4.281-.957 4.95 4.95 0 0 0-3.703 3.703 5.032 5.032 0 0 0 2.304 5.458A3.078 3.078 0 0 1 9 17.924V20h2v-2.077a5.06 5.06 0 0 0-2.537-4.346 3.002 3.002 0 0 1 .817-5.495z"}),props.children);});var Hearing16=/*#__PURE__*/React.forwardRef(function Hearing16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 30v-2a10.011 10.011 0 0 0 10-10h2a12.013 12.013 0 0 1-12 12z"}),React.createElement("path",{d:"M18 26v-2a6.007 6.007 0 0 0 6-6h2a8.01 8.01 0 0 1-8 8z"}),React.createElement("path",{d:"M18 22v-2a2.002 2.002 0 0 0 2-2h2a4.004 4.004 0 0 1-4 4zM10 2a9.01 9.01 0 0 0-9 9h2a7 7 0 0 1 14 0 7.09 7.09 0 0 1-3.501 6.135l-.499.288v3.073a2.935 2.935 0 0 1-.9 2.151 4.182 4.182 0 0 1-4.633 1.03A4.092 4.092 0 0 1 5 20H3a6.116 6.116 0 0 0 3.67 5.512 5.782 5.782 0 0 0 2.314.486 6.585 6.585 0 0 0 4.478-1.888A4.94 4.94 0 0 0 15 20.496v-1.942A9.108 9.108 0 0 0 19 11a9.01 9.01 0 0 0-9-9z"}),React.createElement("path",{d:"M9.28 8.082A3.006 3.006 0 0 1 13 11h2a4.979 4.979 0 0 0-1.884-3.911 5.041 5.041 0 0 0-4.281-.957 4.95 4.95 0 0 0-3.703 3.703 5.032 5.032 0 0 0 2.304 5.458A3.078 3.078 0 0 1 9 17.924V20h2v-2.077a5.06 5.06 0 0 0-2.537-4.346 3.002 3.002 0 0 1 .817-5.495z"}),props.children);});var HelpFilled32=/*#__PURE__*/React.forwardRef(function HelpFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 23a1.5 1.5 0 1 1 1.5-1.5A1.5 1.5 0 0 1 16 25zm1.14-7.75v2.5h-2.25V15H17a2.38 2.38 0 0 0 0-4.75h-1.5a2.38 2.38 0 0 0-2.38 2.37v.64h-2.23v-.64A4.63 4.63 0 0 1 15.52 8H17a4.63 4.63 0 0 1 .12 9.25z"}),props.children);});var HelpFilled24=/*#__PURE__*/React.forwardRef(function HelpFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 23a1.5 1.5 0 1 1 1.5-1.5A1.5 1.5 0 0 1 16 25zm1.14-7.75v2.5h-2.25V15H17a2.38 2.38 0 0 0 0-4.75h-1.5a2.38 2.38 0 0 0-2.38 2.37v.64h-2.23v-.64A4.63 4.63 0 0 1 15.52 8H17a4.63 4.63 0 0 1 .12 9.25z"}),props.children);});var HelpFilled20=/*#__PURE__*/React.forwardRef(function HelpFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 23a1.5 1.5 0 1 1 1.5-1.5A1.5 1.5 0 0 1 16 25zm1.14-7.75v2.5h-2.25V15H17a2.38 2.38 0 0 0 0-4.75h-1.5a2.38 2.38 0 0 0-2.38 2.37v.64h-2.23v-.64A4.63 4.63 0 0 1 15.52 8H17a4.63 4.63 0 0 1 .12 9.25z"}),props.children);});var HelpDesk32=/*#__PURE__*/React.forwardRef(function HelpDesk32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27 10h-6a3.003 3.003 0 0 0-3 3v6a2.002 2.002 0 0 0 2 2v7a2.002 2.002 0 0 0 2 2h4a2.002 2.002 0 0 0 2-2v-7a2.002 2.002 0 0 0 2-2v-6a3.003 3.003 0 0 0-3-3zm1 9h-2v9h-4v-9h-2v-6a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1zM20 5a4 4 0 1 1 4 4 4.004 4.004 0 0 1-4-4zm2 0a2 2 0 1 0 2-2 2.002 2.002 0 0 0-2 2zm-8 11v-3a3.003 3.003 0 0 0-3-3H5a3.003 3.003 0 0 0-3 3v3H0v2h16v-2zM4 13a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1v3H4zm0-8a4 4 0 1 1 4 4 4.004 4.004 0 0 1-4-4zm2 0a2 2 0 1 0 2-2 2.002 2.002 0 0 0-2 2z"}),props.children);});var HelpDesk24=/*#__PURE__*/React.forwardRef(function HelpDesk24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27 10h-6a3.003 3.003 0 0 0-3 3v6a2.002 2.002 0 0 0 2 2v7a2.002 2.002 0 0 0 2 2h4a2.002 2.002 0 0 0 2-2v-7a2.002 2.002 0 0 0 2-2v-6a3.003 3.003 0 0 0-3-3zm1 9h-2v9h-4v-9h-2v-6a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1zM20 5a4 4 0 1 1 4 4 4.004 4.004 0 0 1-4-4zm2 0a2 2 0 1 0 2-2 2.002 2.002 0 0 0-2 2zm-8 11v-3a3.003 3.003 0 0 0-3-3H5a3.003 3.003 0 0 0-3 3v3H0v2h16v-2zM4 13a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1v3H4zm0-8a4 4 0 1 1 4 4 4.004 4.004 0 0 1-4-4zm2 0a2 2 0 1 0 2-2 2.002 2.002 0 0 0-2 2z"}),props.children);});var HelpDesk20=/*#__PURE__*/React.forwardRef(function HelpDesk20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27 10h-6a3.003 3.003 0 0 0-3 3v6a2.002 2.002 0 0 0 2 2v7a2.002 2.002 0 0 0 2 2h4a2.002 2.002 0 0 0 2-2v-7a2.002 2.002 0 0 0 2-2v-6a3.003 3.003 0 0 0-3-3zm1 9h-2v9h-4v-9h-2v-6a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1zM20 5a4 4 0 1 1 4 4 4.004 4.004 0 0 1-4-4zm2 0a2 2 0 1 0 2-2 2.002 2.002 0 0 0-2 2zm-8 11v-3a3.003 3.003 0 0 0-3-3H5a3.003 3.003 0 0 0-3 3v3H0v2h16v-2zM4 13a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1v3H4zm0-8a4 4 0 1 1 4 4 4.004 4.004 0 0 1-4-4zm2 0a2 2 0 1 0 2-2 2.002 2.002 0 0 0-2 2z"}),props.children);});var HelpDesk16=/*#__PURE__*/React.forwardRef(function HelpDesk16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27 10h-6a3.003 3.003 0 0 0-3 3v6a2.002 2.002 0 0 0 2 2v7a2.002 2.002 0 0 0 2 2h4a2.002 2.002 0 0 0 2-2v-7a2.002 2.002 0 0 0 2-2v-6a3.003 3.003 0 0 0-3-3zm1 9h-2v9h-4v-9h-2v-6a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1zM20 5a4 4 0 1 1 4 4 4.004 4.004 0 0 1-4-4zm2 0a2 2 0 1 0 2-2 2.002 2.002 0 0 0-2 2zm-8 11v-3a3.003 3.003 0 0 0-3-3H5a3.003 3.003 0 0 0-3 3v3H0v2h16v-2zM4 13a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1v3H4zm0-8a4 4 0 1 1 4 4 4.004 4.004 0 0 1-4-4zm2 0a2 2 0 1 0 2-2 2.002 2.002 0 0 0-2 2z"}),props.children);});var Help32=/*#__PURE__*/React.forwardRef(function Help32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 26a12 12 0 1 1 12-12 12 12 0 0 1-12 12z"}),React.createElement("circle",{cx:"16",cy:"23.5",r:"1.5"}),React.createElement("path",{d:"M17 8h-1.5a4.49 4.49 0 0 0-4.5 4.5v.5h2v-.5a2.5 2.5 0 0 1 2.5-2.5H17a2.5 2.5 0 0 1 0 5h-2v4.5h2V17a4.5 4.5 0 0 0 0-9z"}),props.children);});var Help24=/*#__PURE__*/React.forwardRef(function Help24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 26a12 12 0 1 1 12-12 12 12 0 0 1-12 12z"}),React.createElement("circle",{cx:"16",cy:"23.5",r:"1.5"}),React.createElement("path",{d:"M17 8h-1.5a4.49 4.49 0 0 0-4.5 4.5v.5h2v-.5a2.5 2.5 0 0 1 2.5-2.5H17a2.5 2.5 0 0 1 0 5h-2v4.5h2V17a4.5 4.5 0 0 0 0-9z"}),props.children);});var Help20=/*#__PURE__*/React.forwardRef(function Help20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 26a12 12 0 1 1 12-12 12 12 0 0 1-12 12z"}),React.createElement("circle",{cx:"16",cy:"23.5",r:"1.5"}),React.createElement("path",{d:"M17 8h-1.5a4.49 4.49 0 0 0-4.5 4.5v.5h2v-.5a2.5 2.5 0 0 1 2.5-2.5H17a2.5 2.5 0 0 1 0 5h-2v4.5h2V17a4.5 4.5 0 0 0 0-9z"}),props.children);});var Home32=/*#__PURE__*/React.forwardRef(function Home32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16.61 2.21a1 1 0 0 0-1.24 0L1 13.42 2.24 15 4 13.62V26a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2V13.63L29.76 15 31 13.43zM18 26h-4v-8h4zm2 0v-8a2 2 0 0 0-2-2h-4a2 2 0 0 0-2 2v8H6V12.06l10-7.79 10 7.8V26z"}),props.children);});var Home24=/*#__PURE__*/React.forwardRef(function Home24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16.61 2.21a1 1 0 0 0-1.24 0L1 13.42 2.24 15 4 13.62V26a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2V13.63L29.76 15 31 13.43zM18 26h-4v-8h4zm2 0v-8a2 2 0 0 0-2-2h-4a2 2 0 0 0-2 2v8H6V12.06l10-7.79 10 7.8V26z"}),props.children);});var Home20=/*#__PURE__*/React.forwardRef(function Home20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16.61 2.21a1 1 0 0 0-1.24 0L1 13.42 2.24 15 4 13.62V26a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2V13.63L29.76 15 31 13.43zM18 26h-4v-8h4zm2 0v-8a2 2 0 0 0-2-2h-4a2 2 0 0 0-2 2v8H6V12.06l10-7.79 10 7.8V26z"}),props.children);});var Home16=/*#__PURE__*/React.forwardRef(function Home16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16.61 2.21a1 1 0 0 0-1.24 0L1 13.42 2.24 15 4 13.62V26a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2V13.63L29.76 15 31 13.43zM18 26h-4v-8h4zm2 0v-8a2 2 0 0 0-2-2h-4a2 2 0 0 0-2 2v8H6V12.06l10-7.79 10 7.8V26z"}),props.children);});var Hotel32=/*#__PURE__*/React.forwardRef(function Hotel32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M9.5 15A1.5 1.5 0 1 1 8 16.5 1.5 1.5 0 0 1 9.5 15m0-2a3.5 3.5 0 1 0 3.5 3.5A3.5 3.5 0 0 0 9.5 13z"}),React.createElement("path",{d:"M25 14h-8a2 2 0 0 0-2 2v6H4V10.6l12-6.46 12.53 6.74.94-1.76-13-7a1 1 0 0 0-.94 0l-13 7A1 1 0 0 0 2 10v20h2v-6h24v6h2V19a5 5 0 0 0-5-5zm-8 8v-6h8a3 3 0 0 1 3 3v3z"}),props.children);});var Hotel24=/*#__PURE__*/React.forwardRef(function Hotel24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M9.5 15A1.5 1.5 0 1 1 8 16.5 1.5 1.5 0 0 1 9.5 15m0-2a3.5 3.5 0 1 0 3.5 3.5A3.5 3.5 0 0 0 9.5 13z"}),React.createElement("path",{d:"M25 14h-8a2 2 0 0 0-2 2v6H4V10.6l12-6.46 12.53 6.74.94-1.76-13-7a1 1 0 0 0-.94 0l-13 7A1 1 0 0 0 2 10v20h2v-6h24v6h2V19a5 5 0 0 0-5-5zm-8 8v-6h8a3 3 0 0 1 3 3v3z"}),props.children);});var Hotel20=/*#__PURE__*/React.forwardRef(function Hotel20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M9.5 15A1.5 1.5 0 1 1 8 16.5 1.5 1.5 0 0 1 9.5 15m0-2a3.5 3.5 0 1 0 3.5 3.5A3.5 3.5 0 0 0 9.5 13z"}),React.createElement("path",{d:"M25 14h-8a2 2 0 0 0-2 2v6H4V10.6l12-6.46 12.53 6.74.94-1.76-13-7a1 1 0 0 0-.94 0l-13 7A1 1 0 0 0 2 10v20h2v-6h24v6h2V19a5 5 0 0 0-5-5zm-8 8v-6h8a3 3 0 0 1 3 3v3z"}),props.children);});var Hotel16=/*#__PURE__*/React.forwardRef(function Hotel16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M9.5 15A1.5 1.5 0 1 1 8 16.5 1.5 1.5 0 0 1 9.5 15m0-2a3.5 3.5 0 1 0 3.5 3.5A3.5 3.5 0 0 0 9.5 13z"}),React.createElement("path",{d:"M25 14h-8a2 2 0 0 0-2 2v6H4V10.6l12-6.46 12.53 6.74.94-1.76-13-7a1 1 0 0 0-.94 0l-13 7A1 1 0 0 0 2 10v20h2v-6h24v6h2V19a5 5 0 0 0-5-5zm-8 8v-6h8a3 3 0 0 1 3 3v3z"}),props.children);});var Hourglass32=/*#__PURE__*/React.forwardRef(function Hourglass32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 19h2v2h-2zm0 4h2v2h-2z"}),React.createElement("path",{d:"M23 11.67V4h3V2H6v2h3v7.67a2 2 0 0 0 .4 1.2L11.75 16 9.4 19.13a2 2 0 0 0-.4 1.2V28H6v2h20v-2h-3v-7.67a2 2 0 0 0-.4-1.2L20.25 16l2.35-3.13a2 2 0 0 0 .4-1.2zM21 4v7H11V4zm0 16.33V28H11v-7.67L14.25 16 12 13h8l-2.25 3z"}),props.children);});var Hourglass24=/*#__PURE__*/React.forwardRef(function Hourglass24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 19h2v2h-2zm0 4h2v2h-2z"}),React.createElement("path",{d:"M23 11.67V4h3V2H6v2h3v7.67a2 2 0 0 0 .4 1.2L11.75 16 9.4 19.13a2 2 0 0 0-.4 1.2V28H6v2h20v-2h-3v-7.67a2 2 0 0 0-.4-1.2L20.25 16l2.35-3.13a2 2 0 0 0 .4-1.2zM21 4v7H11V4zm0 16.33V28H11v-7.67L14.25 16 12 13h8l-2.25 3z"}),props.children);});var Hourglass20=/*#__PURE__*/React.forwardRef(function Hourglass20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 19h2v2h-2zm0 4h2v2h-2z"}),React.createElement("path",{d:"M23 11.67V4h3V2H6v2h3v7.67a2 2 0 0 0 .4 1.2L11.75 16 9.4 19.13a2 2 0 0 0-.4 1.2V28H6v2h20v-2h-3v-7.67a2 2 0 0 0-.4-1.2L20.25 16l2.35-3.13a2 2 0 0 0 .4-1.2zM21 4v7H11V4zm0 16.33V28H11v-7.67L14.25 16 12 13h8l-2.25 3z"}),props.children);});var Hourglass16=/*#__PURE__*/React.forwardRef(function Hourglass16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 19h2v2h-2zm0 4h2v2h-2z"}),React.createElement("path",{d:"M23 11.67V4h3V2H6v2h3v7.67a2 2 0 0 0 .4 1.2L11.75 16 9.4 19.13a2 2 0 0 0-.4 1.2V28H6v2h20v-2h-3v-7.67a2 2 0 0 0-.4-1.2L20.25 16l2.35-3.13a2 2 0 0 0 .4-1.2zM21 4v7H11V4zm0 16.33V28H11v-7.67L14.25 16 12 13h8l-2.25 3z"}),props.children);});var Humidity32=/*#__PURE__*/React.forwardRef(function Humidity32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.5 30h-15a6.494 6.494 0 0 1-1.3-12.858 8.994 8.994 0 0 1 17.6 0A6.495 6.495 0 0 1 23.5 30zM16 12.005a6.999 6.999 0 0 0-6.941 6.143l-.099.812-.816.064A4.495 4.495 0 0 0 8.5 28h15a4.495 4.495 0 0 0 .356-8.976l-.815-.064-.099-.812A7.001 7.001 0 0 0 16 12.005zm10.044-.017h-.088A3.968 3.968 0 0 1 22 8.091a3.876 3.876 0 0 1 .806-2.373l2.381-3.336a1.035 1.035 0 0 1 1.626 0l2.384 3.337A3.867 3.867 0 0 1 30 8.074a3.972 3.972 0 0 1-3.956 3.914zM26 4.688l-1.57 2.198A1.923 1.923 0 0 0 24 8.074a1.946 1.946 0 0 0 1.985 1.909h.03A1.974 1.974 0 0 0 28 8.056a1.837 1.837 0 0 0-.385-1.109 2.422 2.422 0 0 1-.06-.082z"}),props.children);});var Humidity24=/*#__PURE__*/React.forwardRef(function Humidity24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.5 30h-15a6.494 6.494 0 0 1-1.3-12.858 8.994 8.994 0 0 1 17.6 0A6.495 6.495 0 0 1 23.5 30zM16 12.005a6.999 6.999 0 0 0-6.941 6.143l-.099.812-.816.064A4.495 4.495 0 0 0 8.5 28h15a4.495 4.495 0 0 0 .356-8.976l-.815-.064-.099-.812A7.001 7.001 0 0 0 16 12.005zm10.044-.017h-.088A3.968 3.968 0 0 1 22 8.091a3.876 3.876 0 0 1 .806-2.373l2.381-3.336a1.035 1.035 0 0 1 1.626 0l2.384 3.337A3.867 3.867 0 0 1 30 8.074a3.972 3.972 0 0 1-3.956 3.914zM26 4.688l-1.57 2.198A1.923 1.923 0 0 0 24 8.074a1.946 1.946 0 0 0 1.985 1.909h.03A1.974 1.974 0 0 0 28 8.056a1.837 1.837 0 0 0-.385-1.109 2.422 2.422 0 0 1-.06-.082z"}),props.children);});var Humidity20=/*#__PURE__*/React.forwardRef(function Humidity20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.5 30h-15a6.494 6.494 0 0 1-1.3-12.858 8.994 8.994 0 0 1 17.6 0A6.495 6.495 0 0 1 23.5 30zM16 12.005a6.999 6.999 0 0 0-6.941 6.143l-.099.812-.816.064A4.495 4.495 0 0 0 8.5 28h15a4.495 4.495 0 0 0 .356-8.976l-.815-.064-.099-.812A7.001 7.001 0 0 0 16 12.005zm10.044-.017h-.088A3.968 3.968 0 0 1 22 8.091a3.876 3.876 0 0 1 .806-2.373l2.381-3.336a1.035 1.035 0 0 1 1.626 0l2.384 3.337A3.867 3.867 0 0 1 30 8.074a3.972 3.972 0 0 1-3.956 3.914zM26 4.688l-1.57 2.198A1.923 1.923 0 0 0 24 8.074a1.946 1.946 0 0 0 1.985 1.909h.03A1.974 1.974 0 0 0 28 8.056a1.837 1.837 0 0 0-.385-1.109 2.422 2.422 0 0 1-.06-.082z"}),props.children);});var Humidity16=/*#__PURE__*/React.forwardRef(function Humidity16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.5 30h-15a6.494 6.494 0 0 1-1.3-12.858 8.994 8.994 0 0 1 17.6 0A6.495 6.495 0 0 1 23.5 30zM16 12.005a6.999 6.999 0 0 0-6.941 6.143l-.099.812-.816.064A4.495 4.495 0 0 0 8.5 28h15a4.495 4.495 0 0 0 .356-8.976l-.815-.064-.099-.812A7.001 7.001 0 0 0 16 12.005zm10.044-.017h-.088A3.968 3.968 0 0 1 22 8.091a3.876 3.876 0 0 1 .806-2.373l2.381-3.336a1.035 1.035 0 0 1 1.626 0l2.384 3.337A3.867 3.867 0 0 1 30 8.074a3.972 3.972 0 0 1-3.956 3.914zM26 4.688l-1.57 2.198A1.923 1.923 0 0 0 24 8.074a1.946 1.946 0 0 0 1.985 1.909h.03A1.974 1.974 0 0 0 28 8.056a1.837 1.837 0 0 0-.385-1.109 2.422 2.422 0 0 1-.06-.082z"}),props.children);});var Hurricane32=/*#__PURE__*/React.forwardRef(function Hurricane32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"16",cy:"16",r:"2"}),React.createElement("path",{d:"M16 7a8.966 8.966 0 0 0-2.655.4 15.613 15.613 0 0 1 3.466-1.823A25.969 25.969 0 0 1 25.001 4L25 2c-.18 0-18 .16-18 14a9 9 0 0 0 11.655 8.6 15.61 15.61 0 0 1-3.466 1.823A25.975 25.975 0 0 1 7 28v2c.18 0 18-.16 18-14a9.01 9.01 0 0 0-9-9zm0 16a7 7 0 1 1 7-7 7.008 7.008 0 0 1-7 7z"}),props.children);});var Hurricane24=/*#__PURE__*/React.forwardRef(function Hurricane24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"16",cy:"16",r:"2"}),React.createElement("path",{d:"M16 7a8.966 8.966 0 0 0-2.655.4 15.613 15.613 0 0 1 3.466-1.823A25.969 25.969 0 0 1 25.001 4L25 2c-.18 0-18 .16-18 14a9 9 0 0 0 11.655 8.6 15.61 15.61 0 0 1-3.466 1.823A25.975 25.975 0 0 1 7 28v2c.18 0 18-.16 18-14a9.01 9.01 0 0 0-9-9zm0 16a7 7 0 1 1 7-7 7.008 7.008 0 0 1-7 7z"}),props.children);});var Hurricane20=/*#__PURE__*/React.forwardRef(function Hurricane20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"16",cy:"16",r:"2"}),React.createElement("path",{d:"M16 7a8.966 8.966 0 0 0-2.655.4 15.613 15.613 0 0 1 3.466-1.823A25.969 25.969 0 0 1 25.001 4L25 2c-.18 0-18 .16-18 14a9 9 0 0 0 11.655 8.6 15.61 15.61 0 0 1-3.466 1.823A25.975 25.975 0 0 1 7 28v2c.18 0 18-.16 18-14a9.01 9.01 0 0 0-9-9zm0 16a7 7 0 1 1 7-7 7.008 7.008 0 0 1-7 7z"}),props.children);});var Hurricane16=/*#__PURE__*/React.forwardRef(function Hurricane16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"16",cy:"16",r:"2"}),React.createElement("path",{d:"M16 7a8.966 8.966 0 0 0-2.655.4 15.613 15.613 0 0 1 3.466-1.823A25.969 25.969 0 0 1 25.001 4L25 2c-.18 0-18 .16-18 14a9 9 0 0 0 11.655 8.6 15.61 15.61 0 0 1-3.466 1.823A25.975 25.975 0 0 1 7 28v2c.18 0 18-.16 18-14a9.01 9.01 0 0 0-9-9zm0 16a7 7 0 1 1 7-7 7.008 7.008 0 0 1-7 7z"}),props.children);});var IbmCloud32=/*#__PURE__*/React.forwardRef(function IbmCloud32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24.58 13.65a9.733 9.733 0 0 0-18.294 3.889A6.75 6.75 0 0 0 7 31h16a8.746 8.746 0 0 0 1.58-17.35zM23 29.5H7a5.237 5.237 0 0 1-.7-10.43 9.726 9.726 0 0 0 1.104 3.785.75.75 0 1 0 1.322-.71 8.25 8.25 0 0 1 14.026-8.632 8.754 8.754 0 0 0-6.315 2.95.75.75 0 1 0 1.124.992A7.25 7.25 0 1 1 23 29.5zm8.898-19.245a.758.758 0 0 0-1.036-.278l-3.02 1.744a.759.759 0 1 0 .758 1.314l3.02-1.744a.759.759 0 0 0 .278-1.036zM22.676 7.87a.758.758 0 0 0 1.037-.278l1.744-3.02a.759.759 0 0 0-1.314-.758l-1.744 3.02a.759.759 0 0 0 .277 1.036zM16 6.081a.759.759 0 0 0 .759-.759V1.835a.759.759 0 1 0-1.518 0v3.487a.759.759 0 0 0 .759.76zM8.287 7.592a.759.759 0 0 0 1.314-.759l-1.744-3.02a.759.759 0 1 0-1.314.76zm-4.128 4.129l-3.02-1.744a.759.759 0 1 0-.76 1.314L3.4 13.035a.759.759 0 1 0 .759-1.314z"}),props.children);});var IbmCloud24=/*#__PURE__*/React.forwardRef(function IbmCloud24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24.58 13.65a9.733 9.733 0 0 0-18.294 3.889A6.75 6.75 0 0 0 7 31h16a8.746 8.746 0 0 0 1.58-17.35zM23 29.5H7a5.237 5.237 0 0 1-.7-10.43 9.726 9.726 0 0 0 1.104 3.785.75.75 0 1 0 1.322-.71 8.25 8.25 0 0 1 14.026-8.632 8.754 8.754 0 0 0-6.315 2.95.75.75 0 1 0 1.124.992A7.25 7.25 0 1 1 23 29.5zm8.898-19.245a.758.758 0 0 0-1.036-.278l-3.02 1.744a.759.759 0 1 0 .758 1.314l3.02-1.744a.759.759 0 0 0 .278-1.036zM22.676 7.87a.758.758 0 0 0 1.037-.278l1.744-3.02a.759.759 0 0 0-1.314-.758l-1.744 3.02a.759.759 0 0 0 .277 1.036zM16 6.081a.759.759 0 0 0 .759-.759V1.835a.759.759 0 1 0-1.518 0v3.487a.759.759 0 0 0 .759.76zM8.287 7.592a.759.759 0 0 0 1.314-.759l-1.744-3.02a.759.759 0 1 0-1.314.76zm-4.128 4.129l-3.02-1.744a.759.759 0 1 0-.76 1.314L3.4 13.035a.759.759 0 1 0 .759-1.314z"}),props.children);});var IbmCloud20=/*#__PURE__*/React.forwardRef(function IbmCloud20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24.58 13.65a9.733 9.733 0 0 0-18.294 3.889A6.75 6.75 0 0 0 7 31h16a8.746 8.746 0 0 0 1.58-17.35zM23 29.5H7a5.237 5.237 0 0 1-.7-10.43 9.726 9.726 0 0 0 1.104 3.785.75.75 0 1 0 1.322-.71 8.25 8.25 0 0 1 14.026-8.632 8.754 8.754 0 0 0-6.315 2.95.75.75 0 1 0 1.124.992A7.25 7.25 0 1 1 23 29.5zm8.898-19.245a.758.758 0 0 0-1.036-.278l-3.02 1.744a.759.759 0 1 0 .758 1.314l3.02-1.744a.759.759 0 0 0 .278-1.036zM22.676 7.87a.758.758 0 0 0 1.037-.278l1.744-3.02a.759.759 0 0 0-1.314-.758l-1.744 3.02a.759.759 0 0 0 .277 1.036zM16 6.081a.759.759 0 0 0 .759-.759V1.835a.759.759 0 1 0-1.518 0v3.487a.759.759 0 0 0 .759.76zM8.287 7.592a.759.759 0 0 0 1.314-.759l-1.744-3.02a.759.759 0 1 0-1.314.76zm-4.128 4.129l-3.02-1.744a.759.759 0 1 0-.76 1.314L3.4 13.035a.759.759 0 1 0 .759-1.314z"}),props.children);});var IbmCloud16=/*#__PURE__*/React.forwardRef(function IbmCloud16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24.58 13.65a9.733 9.733 0 0 0-18.294 3.889A6.75 6.75 0 0 0 7 31h16a8.746 8.746 0 0 0 1.58-17.35zM23 29.5H7a5.237 5.237 0 0 1-.7-10.43 9.726 9.726 0 0 0 1.104 3.785.75.75 0 1 0 1.322-.71 8.25 8.25 0 0 1 14.026-8.632 8.754 8.754 0 0 0-6.315 2.95.75.75 0 1 0 1.124.992A7.25 7.25 0 1 1 23 29.5zm8.898-19.245a.758.758 0 0 0-1.036-.278l-3.02 1.744a.759.759 0 1 0 .758 1.314l3.02-1.744a.759.759 0 0 0 .278-1.036zM22.676 7.87a.758.758 0 0 0 1.037-.278l1.744-3.02a.759.759 0 0 0-1.314-.758l-1.744 3.02a.759.759 0 0 0 .277 1.036zM16 6.081a.759.759 0 0 0 .759-.759V1.835a.759.759 0 1 0-1.518 0v3.487a.759.759 0 0 0 .759.76zM8.287 7.592a.759.759 0 0 0 1.314-.759l-1.744-3.02a.759.759 0 1 0-1.314.76zm-4.128 4.129l-3.02-1.744a.759.759 0 1 0-.76 1.314L3.4 13.035a.759.759 0 1 0 .759-1.314z"}),props.children);});var IbmSecurity32=/*#__PURE__*/React.forwardRef(function IbmSecurity32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 0L4 5.978v14.066a12 12 0 0 0 24 0V5.978zm6.83 27.314L16 23.912v2.228l5.036 2.509A10.002 10.002 0 0 1 6 20.044V7.21l10-4.982L26 7.21v3.75L16 5.978v2.228l10 4.982v3.75l-10-4.982v2.228l10 4.982v.878a9.905 9.905 0 0 1-.37 2.687L16 17.934v2.228l8.895 4.431a10.025 10.025 0 0 1-2.065 2.721z"}),props.children);});var IbmSecurity24=/*#__PURE__*/React.forwardRef(function IbmSecurity24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 0L4 5.978v14.066a12 12 0 0 0 24 0V5.978zm6.83 27.314L16 23.912v2.228l5.036 2.509A10.002 10.002 0 0 1 6 20.044V7.21l10-4.982L26 7.21v3.75L16 5.978v2.228l10 4.982v3.75l-10-4.982v2.228l10 4.982v.878a9.905 9.905 0 0 1-.37 2.687L16 17.934v2.228l8.895 4.431a10.025 10.025 0 0 1-2.065 2.721z"}),props.children);});var IbmSecurity20=/*#__PURE__*/React.forwardRef(function IbmSecurity20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 0L4 5.978v14.066a12 12 0 0 0 24 0V5.978zm6.83 27.314L16 23.912v2.228l5.036 2.509A10.002 10.002 0 0 1 6 20.044V7.21l10-4.982L26 7.21v3.75L16 5.978v2.228l10 4.982v3.75l-10-4.982v2.228l10 4.982v.878a9.905 9.905 0 0 1-.37 2.687L16 17.934v2.228l8.895 4.431a10.025 10.025 0 0 1-2.065 2.721z"}),props.children);});var IbmSecurity16=/*#__PURE__*/React.forwardRef(function IbmSecurity16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 0L4 5.978v14.066a12 12 0 0 0 24 0V5.978zm6.83 27.314L16 23.912v2.228l5.036 2.509A10.002 10.002 0 0 1 6 20.044V7.21l10-4.982L26 7.21v3.75L16 5.978v2.228l10 4.982v3.75l-10-4.982v2.228l10 4.982v.878a9.905 9.905 0 0 1-.37 2.687L16 17.934v2.228l8.895 4.431a10.025 10.025 0 0 1-2.065 2.721z"}),props.children);});var Idea32=/*#__PURE__*/React.forwardRef(function Idea32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11 24h10v2H11zm2 4h6v2h-6zm3-26A10 10 0 0 0 6 12a9.19 9.19 0 0 0 3.46 7.62c1 .93 1.54 1.46 1.54 2.38h2c0-1.84-1.11-2.87-2.19-3.86A7.2 7.2 0 0 1 8 12a8 8 0 0 1 16 0 7.2 7.2 0 0 1-2.82 6.14c-1.07 1-2.18 2-2.18 3.86h2c0-.92.53-1.45 1.54-2.39A9.18 9.18 0 0 0 26 12 10 10 0 0 0 16 2z"}),props.children);});var Idea24=/*#__PURE__*/React.forwardRef(function Idea24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11 24h10v2H11zm2 4h6v2h-6zm3-26A10 10 0 0 0 6 12a9.19 9.19 0 0 0 3.46 7.62c1 .93 1.54 1.46 1.54 2.38h2c0-1.84-1.11-2.87-2.19-3.86A7.2 7.2 0 0 1 8 12a8 8 0 0 1 16 0 7.2 7.2 0 0 1-2.82 6.14c-1.07 1-2.18 2-2.18 3.86h2c0-.92.53-1.45 1.54-2.39A9.18 9.18 0 0 0 26 12 10 10 0 0 0 16 2z"}),props.children);});var Idea20=/*#__PURE__*/React.forwardRef(function Idea20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11 24h10v2H11zm2 4h6v2h-6zm3-26A10 10 0 0 0 6 12a9.19 9.19 0 0 0 3.46 7.62c1 .93 1.54 1.46 1.54 2.38h2c0-1.84-1.11-2.87-2.19-3.86A7.2 7.2 0 0 1 8 12a8 8 0 0 1 16 0 7.2 7.2 0 0 1-2.82 6.14c-1.07 1-2.18 2-2.18 3.86h2c0-.92.53-1.45 1.54-2.39A9.18 9.18 0 0 0 26 12 10 10 0 0 0 16 2z"}),props.children);});var Idea16=/*#__PURE__*/React.forwardRef(function Idea16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11 24h10v2H11zm2 4h6v2h-6zm3-26A10 10 0 0 0 6 12a9.19 9.19 0 0 0 3.46 7.62c1 .93 1.54 1.46 1.54 2.38h2c0-1.84-1.11-2.87-2.19-3.86A7.2 7.2 0 0 1 8 12a8 8 0 0 1 16 0 7.2 7.2 0 0 1-2.82 6.14c-1.07 1-2.18 2-2.18 3.86h2c0-.92.53-1.45 1.54-2.39A9.18 9.18 0 0 0 26 12 10 10 0 0 0 16 2z"}),props.children);});var Identification32=/*#__PURE__*/React.forwardRef(function Identification32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 6v20H4V6h24m0-2H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2z"}),React.createElement("path",{d:"M6 10h7v2H6zm0 4h4v2H6zm17 4h-6a3 3 0 0 0-3 3v2h2v-2a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1v2h2v-2a3 3 0 0 0-3-3zm-3-1a4 4 0 1 0-4-4 4 4 0 0 0 4 4zm0-6a2 2 0 1 1-2 2 2 2 0 0 1 2-2z"}),props.children);});var Identification24=/*#__PURE__*/React.forwardRef(function Identification24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 6v20H4V6h24m0-2H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2z"}),React.createElement("path",{d:"M6 10h7v2H6zm0 4h4v2H6zm17 4h-6a3 3 0 0 0-3 3v2h2v-2a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1v2h2v-2a3 3 0 0 0-3-3zm-3-1a4 4 0 1 0-4-4 4 4 0 0 0 4 4zm0-6a2 2 0 1 1-2 2 2 2 0 0 1 2-2z"}),props.children);});var Identification20=/*#__PURE__*/React.forwardRef(function Identification20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 6v20H4V6h24m0-2H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2z"}),React.createElement("path",{d:"M6 10h7v2H6zm0 4h4v2H6zm17 4h-6a3 3 0 0 0-3 3v2h2v-2a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1v2h2v-2a3 3 0 0 0-3-3zm-3-1a4 4 0 1 0-4-4 4 4 0 0 0 4 4zm0-6a2 2 0 1 1-2 2 2 2 0 0 1 2-2z"}),props.children);});var Identification16=/*#__PURE__*/React.forwardRef(function Identification16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 6v20H4V6h24m0-2H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2z"}),React.createElement("path",{d:"M6 10h7v2H6zm0 4h4v2H6zm17 4h-6a3 3 0 0 0-3 3v2h2v-2a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1v2h2v-2a3 3 0 0 0-3-3zm-3-1a4 4 0 1 0-4-4 4 4 0 0 0 4 4zm0-6a2 2 0 1 1-2 2 2 2 0 0 1 2-2z"}),props.children);});var ImageMedical32=/*#__PURE__*/React.forwardRef(function ImageMedical32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 6v20H6V6h20m0-2H6a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2z"}),React.createElement("path",{d:"M22 16v-2h-5v-2h3v-2h-3V8h-2v2h-3v2h3v2h-5v2h5v2h-5v2h5v2h-3v2h8v-2h-3v-2h5v-2h-5v-2h5z"}),props.children);});var ImageMedical24=/*#__PURE__*/React.forwardRef(function ImageMedical24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 6v20H6V6h20m0-2H6a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2z"}),React.createElement("path",{d:"M22 16v-2h-5v-2h3v-2h-3V8h-2v2h-3v2h3v2h-5v2h5v2h-5v2h5v2h-3v2h8v-2h-3v-2h5v-2h-5v-2h5z"}),props.children);});var ImageMedical20=/*#__PURE__*/React.forwardRef(function ImageMedical20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 6v20H6V6h20m0-2H6a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2z"}),React.createElement("path",{d:"M22 16v-2h-5v-2h3v-2h-3V8h-2v2h-3v2h3v2h-5v2h5v2h-5v2h5v2h-3v2h8v-2h-3v-2h5v-2h-5v-2h5z"}),props.children);});var ImageMedical16=/*#__PURE__*/React.forwardRef(function ImageMedical16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 6v20H6V6h20m0-2H6a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2z"}),React.createElement("path",{d:"M22 16v-2h-5v-2h3v-2h-3V8h-2v2h-3v2h3v2h-5v2h5v2h-5v2h5v2h-3v2h8v-2h-3v-2h5v-2h-5v-2h5z"}),props.children);});var Image32=/*#__PURE__*/React.forwardRef(function Image32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19 14a3 3 0 1 0-3-3 3 3 0 0 0 3 3zm0-4a1 1 0 1 1-1 1 1 1 0 0 1 1-1z"}),React.createElement("path",{d:"M26 4H6a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm0 22H6v-6l5-5 5.59 5.59a2 2 0 0 0 2.82 0L21 19l5 5zm0-4.83l-3.59-3.59a2 2 0 0 0-2.82 0L18 19.17l-5.59-5.59a2 2 0 0 0-2.82 0L6 17.17V6h20z"}),props.children);});var Image24=/*#__PURE__*/React.forwardRef(function Image24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19 14a3 3 0 1 0-3-3 3 3 0 0 0 3 3zm0-4a1 1 0 1 1-1 1 1 1 0 0 1 1-1z"}),React.createElement("path",{d:"M26 4H6a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm0 22H6v-6l5-5 5.59 5.59a2 2 0 0 0 2.82 0L21 19l5 5zm0-4.83l-3.59-3.59a2 2 0 0 0-2.82 0L18 19.17l-5.59-5.59a2 2 0 0 0-2.82 0L6 17.17V6h20z"}),props.children);});var Image20=/*#__PURE__*/React.forwardRef(function Image20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19 14a3 3 0 1 0-3-3 3 3 0 0 0 3 3zm0-4a1 1 0 1 1-1 1 1 1 0 0 1 1-1z"}),React.createElement("path",{d:"M26 4H6a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm0 22H6v-6l5-5 5.59 5.59a2 2 0 0 0 2.82 0L21 19l5 5zm0-4.83l-3.59-3.59a2 2 0 0 0-2.82 0L18 19.17l-5.59-5.59a2 2 0 0 0-2.82 0L6 17.17V6h20z"}),props.children);});var Image16=/*#__PURE__*/React.forwardRef(function Image16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19 14a3 3 0 1 0-3-3 3 3 0 0 0 3 3zm0-4a1 1 0 1 1-1 1 1 1 0 0 1 1-1z"}),React.createElement("path",{d:"M26 4H6a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm0 22H6v-6l5-5 5.59 5.59a2 2 0 0 0 2.82 0L21 19l5 5zm0-4.83l-3.59-3.59a2 2 0 0 0-2.82 0L18 19.17l-5.59-5.59a2 2 0 0 0-2.82 0L6 17.17V6h20z"}),props.children);});var Industry32=/*#__PURE__*/React.forwardRef(function Industry32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.53 6.15a1 1 0 0 0-1 0L20 10.38V7a1 1 0 0 0-1.45-.89L10 10.38V3a1 1 0 0 0-1-1H3a1 1 0 0 0-1 1v25h28V7a1 1 0 0 0-.47-.85zM22 26h-4v-7h4zm6 0h-4v-8a1 1 0 0 0-1-1h-6a1 1 0 0 0-1 1v8H4V4h4v9.62l10-5v5l10-5z"}),props.children);});var Industry24=/*#__PURE__*/React.forwardRef(function Industry24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.53 6.15a1 1 0 0 0-1 0L20 10.38V7a1 1 0 0 0-1.45-.89L10 10.38V3a1 1 0 0 0-1-1H3a1 1 0 0 0-1 1v25h28V7a1 1 0 0 0-.47-.85zM22 26h-4v-7h4zm6 0h-4v-8a1 1 0 0 0-1-1h-6a1 1 0 0 0-1 1v8H4V4h4v9.62l10-5v5l10-5z"}),props.children);});var Industry20=/*#__PURE__*/React.forwardRef(function Industry20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.53 6.15a1 1 0 0 0-1 0L20 10.38V7a1 1 0 0 0-1.45-.89L10 10.38V3a1 1 0 0 0-1-1H3a1 1 0 0 0-1 1v25h28V7a1 1 0 0 0-.47-.85zM22 26h-4v-7h4zm6 0h-4v-8a1 1 0 0 0-1-1h-6a1 1 0 0 0-1 1v8H4V4h4v9.62l10-5v5l10-5z"}),props.children);});var Industry16=/*#__PURE__*/React.forwardRef(function Industry16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.53 6.15a1 1 0 0 0-1 0L20 10.38V7a1 1 0 0 0-1.45-.89L10 10.38V3a1 1 0 0 0-1-1H3a1 1 0 0 0-1 1v25h28V7a1 1 0 0 0-.47-.85zM22 26h-4v-7h4zm6 0h-4v-8a1 1 0 0 0-1-1h-6a1 1 0 0 0-1 1v8H4V4h4v9.62l10-5v5l10-5z"}),props.children);});var InformationFilled32=/*#__PURE__*/React.forwardRef(function InformationFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 5a1.5 1.5 0 1 1-1.5 1.5A1.5 1.5 0 0 1 16 7zm4 17.12h-8v-2.24h2.88v-6.76H13v-2.24h4.13v9H20z"}),props.children);});var InformationFilled24=/*#__PURE__*/React.forwardRef(function InformationFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 5a1.5 1.5 0 1 1-1.5 1.5A1.5 1.5 0 0 1 16 7zm4 17.12h-8v-2.24h2.88v-6.76H13v-2.24h4.13v9H20z"}),props.children);});var InformationFilled20=/*#__PURE__*/React.forwardRef(function InformationFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 5a1.5 1.5 0 1 1-1.5 1.5A1.5 1.5 0 0 1 16 7zm4 17.12h-8v-2.24h2.88v-6.76H13v-2.24h4.13v9H20z"}),props.children);});var Information32=/*#__PURE__*/React.forwardRef(function Information32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17 22v-9h-4v2h2v7h-3v2h8v-2h-3zM16 7a1.5 1.5 0 1 0 1.5 1.5A1.5 1.5 0 0 0 16 7z"}),React.createElement("path",{d:"M16 30a14 14 0 1 1 14-14 14 14 0 0 1-14 14zm0-26a12 12 0 1 0 12 12A12 12 0 0 0 16 4z"}),props.children);});var Information24=/*#__PURE__*/React.forwardRef(function Information24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17 22v-9h-4v2h2v7h-3v2h8v-2h-3zM16 7a1.5 1.5 0 1 0 1.5 1.5A1.5 1.5 0 0 0 16 7z"}),React.createElement("path",{d:"M16 30a14 14 0 1 1 14-14 14 14 0 0 1-14 14zm0-26a12 12 0 1 0 12 12A12 12 0 0 0 16 4z"}),props.children);});var Information20=/*#__PURE__*/React.forwardRef(function Information20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17 22v-9h-4v2h2v7h-3v2h8v-2h-3zM16 7a1.5 1.5 0 1 0 1.5 1.5A1.5 1.5 0 0 0 16 7z"}),React.createElement("path",{d:"M16 30a14 14 0 1 1 14-14 14 14 0 0 1-14 14zm0-26a12 12 0 1 0 12 12A12 12 0 0 0 16 4z"}),props.children);});var Insert32=/*#__PURE__*/React.forwardRef(function Insert32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2 9h9V2H2zm2-5h5v3H4zM2 19h9v-7H2zm2-5h5v3H4zM2 29h9v-7H2zm2-5h5v3H4zM27 9h-9l3.41-3.59L20 4l-6 6 6 6 1.41-1.41L18 11h9a1 1 0 0 1 1 1v12a1 1 0 0 1-1 1H15v2h12a3 3 0 0 0 3-3V12a3 3 0 0 0-3-3z"}),props.children);});var Insert24=/*#__PURE__*/React.forwardRef(function Insert24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2 9h9V2H2zm2-5h5v3H4zM2 19h9v-7H2zm2-5h5v3H4zM2 29h9v-7H2zm2-5h5v3H4zM27 9h-9l3.41-3.59L20 4l-6 6 6 6 1.41-1.41L18 11h9a1 1 0 0 1 1 1v12a1 1 0 0 1-1 1H15v2h12a3 3 0 0 0 3-3V12a3 3 0 0 0-3-3z"}),props.children);});var Insert20=/*#__PURE__*/React.forwardRef(function Insert20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2 9h9V2H2zm2-5h5v3H4zM2 19h9v-7H2zm2-5h5v3H4zM2 29h9v-7H2zm2-5h5v3H4zM27 9h-9l3.41-3.59L20 4l-6 6 6 6 1.41-1.41L18 11h9a1 1 0 0 1 1 1v12a1 1 0 0 1-1 1H15v2h12a3 3 0 0 0 3-3V12a3 3 0 0 0-3-3z"}),props.children);});var Insert16=/*#__PURE__*/React.forwardRef(function Insert16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2 9h9V2H2zm2-5h5v3H4zM2 19h9v-7H2zm2-5h5v3H4zM2 29h9v-7H2zm2-5h5v3H4zM27 9h-9l3.41-3.59L20 4l-6 6 6 6 1.41-1.41L18 11h9a1 1 0 0 1 1 1v12a1 1 0 0 1-1 1H15v2h12a3 3 0 0 0 3-3V12a3 3 0 0 0-3-3z"}),props.children);});var Integration32=/*#__PURE__*/React.forwardRef(function Integration32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.88 15.52l-6-11A1 1 0 0 0 23 4H9a1 1 0 0 0-.88.52l-6 11a1 1 0 0 0 0 1l6 11A1 1 0 0 0 9 28h14a1 1 0 0 0 .88-.52l6-11a1 1 0 0 0 0-.96zM22.93 7l4.39 8h-9.5zM16 14.14L10.82 6h10.36zM9.07 7l5.11 8h-9.5zM4.68 17h9.5l-5.11 8zm11.32.86L21.18 26H10.82zM22.93 25l-5.11-8h9.5z"}),props.children);});var Integration24=/*#__PURE__*/React.forwardRef(function Integration24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.88 15.52l-6-11A1 1 0 0 0 23 4H9a1 1 0 0 0-.88.52l-6 11a1 1 0 0 0 0 1l6 11A1 1 0 0 0 9 28h14a1 1 0 0 0 .88-.52l6-11a1 1 0 0 0 0-.96zM22.93 7l4.39 8h-9.5zM16 14.14L10.82 6h10.36zM9.07 7l5.11 8h-9.5zM4.68 17h9.5l-5.11 8zm11.32.86L21.18 26H10.82zM22.93 25l-5.11-8h9.5z"}),props.children);});var Integration20=/*#__PURE__*/React.forwardRef(function Integration20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.88 15.52l-6-11A1 1 0 0 0 23 4H9a1 1 0 0 0-.88.52l-6 11a1 1 0 0 0 0 1l6 11A1 1 0 0 0 9 28h14a1 1 0 0 0 .88-.52l6-11a1 1 0 0 0 0-.96zM22.93 7l4.39 8h-9.5zM16 14.14L10.82 6h10.36zM9.07 7l5.11 8h-9.5zM4.68 17h9.5l-5.11 8zm11.32.86L21.18 26H10.82zM22.93 25l-5.11-8h9.5z"}),props.children);});var Integration16=/*#__PURE__*/React.forwardRef(function Integration16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.88 15.52l-6-11A1 1 0 0 0 23 4H9a1 1 0 0 0-.88.52l-6 11a1 1 0 0 0 0 1l6 11A1 1 0 0 0 9 28h14a1 1 0 0 0 .88-.52l6-11a1 1 0 0 0 0-.96zM22.93 7l4.39 8h-9.5zM16 14.14L10.82 6h10.36zM9.07 7l5.11 8h-9.5zM4.68 17h9.5l-5.11 8zm11.32.86L21.18 26H10.82zM22.93 25l-5.11-8h9.5z"}),props.children);});var InventoryManagement32=/*#__PURE__*/React.forwardRef(function InventoryManagement32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19 24h4v4h-4zm7 0h4v4h-4zm-7-7h4v4h-4zm7 0h4v4h-4z"}),React.createElement("path",{d:"M17 24H4V10h24v5h2v-5a2.002 2.002 0 0 0-2-2h-6V4a2.002 2.002 0 0 0-2-2h-8a2.002 2.002 0 0 0-2 2v4H4a2.002 2.002 0 0 0-2 2v14a2.002 2.002 0 0 0 2 2h13zM12 4h8v4h-8z"}),props.children);});var InventoryManagement24=/*#__PURE__*/React.forwardRef(function InventoryManagement24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19 24h4v4h-4zm7 0h4v4h-4zm-7-7h4v4h-4zm7 0h4v4h-4z"}),React.createElement("path",{d:"M17 24H4V10h24v5h2v-5a2.002 2.002 0 0 0-2-2h-6V4a2.002 2.002 0 0 0-2-2h-8a2.002 2.002 0 0 0-2 2v4H4a2.002 2.002 0 0 0-2 2v14a2.002 2.002 0 0 0 2 2h13zM12 4h8v4h-8z"}),props.children);});var InventoryManagement20=/*#__PURE__*/React.forwardRef(function InventoryManagement20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19 24h4v4h-4zm7 0h4v4h-4zm-7-7h4v4h-4zm7 0h4v4h-4z"}),React.createElement("path",{d:"M17 24H4V10h24v5h2v-5a2.002 2.002 0 0 0-2-2h-6V4a2.002 2.002 0 0 0-2-2h-8a2.002 2.002 0 0 0-2 2v4H4a2.002 2.002 0 0 0-2 2v14a2.002 2.002 0 0 0 2 2h13zM12 4h8v4h-8z"}),props.children);});var InventoryManagement16=/*#__PURE__*/React.forwardRef(function InventoryManagement16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19 24h4v4h-4zm7 0h4v4h-4zm-7-7h4v4h-4zm7 0h4v4h-4z"}),React.createElement("path",{d:"M17 24H4V10h24v5h2v-5a2.002 2.002 0 0 0-2-2h-6V4a2.002 2.002 0 0 0-2-2h-8a2.002 2.002 0 0 0-2 2v4H4a2.002 2.002 0 0 0-2 2v14a2.002 2.002 0 0 0 2 2h13zM12 4h8v4h-8z"}),props.children);});var IotConnect32=/*#__PURE__*/React.forwardRef(function IotConnect32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 19h-4v-4h-2v9H8V8h9V6h-4V2h-2v4H8a2.002 2.002 0 0 0-2 2v3H2v2h4v6H2v2h4v3a2.002 2.002 0 0 0 2 2h3v4h2v-4h6v4h2v-4h3a2.003 2.003 0 0 0 2-2v-3h4z"}),React.createElement("path",{d:"M26 2a4.004 4.004 0 0 0-4 4 3.956 3.956 0 0 0 .567 2.02L19.586 11H11v10h10v-8.586l2.98-2.98A3.955 3.955 0 0 0 26 10a4 4 0 0 0 0-8zm-7 17h-6v-6h6zm7-11a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2z"}),props.children);});var IotConnect24=/*#__PURE__*/React.forwardRef(function IotConnect24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 19h-4v-4h-2v9H8V8h9V6h-4V2h-2v4H8a2.002 2.002 0 0 0-2 2v3H2v2h4v6H2v2h4v3a2.002 2.002 0 0 0 2 2h3v4h2v-4h6v4h2v-4h3a2.003 2.003 0 0 0 2-2v-3h4z"}),React.createElement("path",{d:"M26 2a4.004 4.004 0 0 0-4 4 3.956 3.956 0 0 0 .567 2.02L19.586 11H11v10h10v-8.586l2.98-2.98A3.955 3.955 0 0 0 26 10a4 4 0 0 0 0-8zm-7 17h-6v-6h6zm7-11a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2z"}),props.children);});var IotConnect20=/*#__PURE__*/React.forwardRef(function IotConnect20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 19h-4v-4h-2v9H8V8h9V6h-4V2h-2v4H8a2.002 2.002 0 0 0-2 2v3H2v2h4v6H2v2h4v3a2.002 2.002 0 0 0 2 2h3v4h2v-4h6v4h2v-4h3a2.003 2.003 0 0 0 2-2v-3h4z"}),React.createElement("path",{d:"M26 2a4.004 4.004 0 0 0-4 4 3.956 3.956 0 0 0 .567 2.02L19.586 11H11v10h10v-8.586l2.98-2.98A3.955 3.955 0 0 0 26 10a4 4 0 0 0 0-8zm-7 17h-6v-6h6zm7-11a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2z"}),props.children);});var IotConnect16=/*#__PURE__*/React.forwardRef(function IotConnect16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 19h-4v-4h-2v9H8V8h9V6h-4V2h-2v4H8a2.002 2.002 0 0 0-2 2v3H2v2h4v6H2v2h4v3a2.002 2.002 0 0 0 2 2h3v4h2v-4h6v4h2v-4h3a2.003 2.003 0 0 0 2-2v-3h4z"}),React.createElement("path",{d:"M26 2a4.004 4.004 0 0 0-4 4 3.956 3.956 0 0 0 .567 2.02L19.586 11H11v10h10v-8.586l2.98-2.98A3.955 3.955 0 0 0 26 10a4 4 0 0 0 0-8zm-7 17h-6v-6h6zm7-11a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2z"}),props.children);});var IotPlatform32=/*#__PURE__*/React.forwardRef(function IotPlatform32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 19h-4v-4h-2v9H8V8h9V6h-4V2h-2v4H8a2.002 2.002 0 0 0-2 2v3H2v2h4v6H2v2h4v3a2.002 2.002 0 0 0 2 2h3v4h2v-4h6v4h2v-4h3a2.003 2.003 0 0 0 2-2v-3h4z"}),React.createElement("path",{d:"M21 21H11V11h10zm-8-2h6v-6h-6zm18-6h-2A10.012 10.012 0 0 0 19 3V1a12.013 12.013 0 0 1 12 12z"}),React.createElement("path",{d:"M26 13h-2a5.006 5.006 0 0 0-5-5V6a7.008 7.008 0 0 1 7 7z"}),props.children);});var IotPlatform24=/*#__PURE__*/React.forwardRef(function IotPlatform24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 19h-4v-4h-2v9H8V8h9V6h-4V2h-2v4H8a2.002 2.002 0 0 0-2 2v3H2v2h4v6H2v2h4v3a2.002 2.002 0 0 0 2 2h3v4h2v-4h6v4h2v-4h3a2.003 2.003 0 0 0 2-2v-3h4z"}),React.createElement("path",{d:"M21 21H11V11h10zm-8-2h6v-6h-6zm18-6h-2A10.012 10.012 0 0 0 19 3V1a12.013 12.013 0 0 1 12 12z"}),React.createElement("path",{d:"M26 13h-2a5.006 5.006 0 0 0-5-5V6a7.008 7.008 0 0 1 7 7z"}),props.children);});var IotPlatform20=/*#__PURE__*/React.forwardRef(function IotPlatform20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 19h-4v-4h-2v9H8V8h9V6h-4V2h-2v4H8a2.002 2.002 0 0 0-2 2v3H2v2h4v6H2v2h4v3a2.002 2.002 0 0 0 2 2h3v4h2v-4h6v4h2v-4h3a2.003 2.003 0 0 0 2-2v-3h4z"}),React.createElement("path",{d:"M21 21H11V11h10zm-8-2h6v-6h-6zm18-6h-2A10.012 10.012 0 0 0 19 3V1a12.013 12.013 0 0 1 12 12z"}),React.createElement("path",{d:"M26 13h-2a5.006 5.006 0 0 0-5-5V6a7.008 7.008 0 0 1 7 7z"}),props.children);});var IotPlatform16=/*#__PURE__*/React.forwardRef(function IotPlatform16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 19h-4v-4h-2v9H8V8h9V6h-4V2h-2v4H8a2.002 2.002 0 0 0-2 2v3H2v2h4v6H2v2h4v3a2.002 2.002 0 0 0 2 2h3v4h2v-4h6v4h2v-4h3a2.003 2.003 0 0 0 2-2v-3h4z"}),React.createElement("path",{d:"M21 21H11V11h10zm-8-2h6v-6h-6zm18-6h-2A10.012 10.012 0 0 0 19 3V1a12.013 12.013 0 0 1 12 12z"}),React.createElement("path",{d:"M26 13h-2a5.006 5.006 0 0 0-5-5V6a7.008 7.008 0 0 1 7 7z"}),props.children);});var Keyboard32=/*#__PURE__*/React.forwardRef(function Keyboard32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 26H4a2 2 0 0 1-2-2V10a2 2 0 0 1 2-2h24a2 2 0 0 1 2 2v14a2 2 0 0 1-2 2zM4 10v14h24V10z"}),React.createElement("path",{d:"M10 20h11v2H10zm-4-8h2v2H6zm4 0h2v2h-2zm4 0h2v2h-2zm4 0h2v2h-2zM6 20h2v2H6zm0-4h2v2H6zm4 0h2v2h-2zm4 0h2v2h-2zm8-4h4v2h-4zm0 4h4v2h-4zm-4 0h2v2h-2zm5 4h3v2h-3z"}),props.children);});var Keyboard24=/*#__PURE__*/React.forwardRef(function Keyboard24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 26H4a2 2 0 0 1-2-2V10a2 2 0 0 1 2-2h24a2 2 0 0 1 2 2v14a2 2 0 0 1-2 2zM4 10v14h24V10z"}),React.createElement("path",{d:"M10 20h11v2H10zm-4-8h2v2H6zm4 0h2v2h-2zm4 0h2v2h-2zm4 0h2v2h-2zM6 20h2v2H6zm0-4h2v2H6zm4 0h2v2h-2zm4 0h2v2h-2zm8-4h4v2h-4zm0 4h4v2h-4zm-4 0h2v2h-2zm5 4h3v2h-3z"}),props.children);});var Keyboard20=/*#__PURE__*/React.forwardRef(function Keyboard20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 26H4a2 2 0 0 1-2-2V10a2 2 0 0 1 2-2h24a2 2 0 0 1 2 2v14a2 2 0 0 1-2 2zM4 10v14h24V10z"}),React.createElement("path",{d:"M10 20h11v2H10zm-4-8h2v2H6zm4 0h2v2h-2zm4 0h2v2h-2zm4 0h2v2h-2zM6 20h2v2H6zm0-4h2v2H6zm4 0h2v2h-2zm4 0h2v2h-2zm8-4h4v2h-4zm0 4h4v2h-4zm-4 0h2v2h-2zm5 4h3v2h-3z"}),props.children);});var Keyboard16=/*#__PURE__*/React.forwardRef(function Keyboard16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 26H4a2 2 0 0 1-2-2V10a2 2 0 0 1 2-2h24a2 2 0 0 1 2 2v14a2 2 0 0 1-2 2zM4 10v14h24V10z"}),React.createElement("path",{d:"M10 20h11v2H10zm-4-8h2v2H6zm4 0h2v2h-2zm4 0h2v2h-2zm4 0h2v2h-2zM6 20h2v2H6zm0-4h2v2H6zm4 0h2v2h-2zm4 0h2v2h-2zm8-4h4v2h-4zm0 4h4v2h-4zm-4 0h2v2h-2zm5 4h3v2h-3z"}),props.children);});var Language32=/*#__PURE__*/React.forwardRef(function Language32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 19h6v2h-6zm0-4h12v2H18zm0-4h12v2H18zm-4 10v-2H9v-2H7v2H2v2h8.215a8.591 8.591 0 0 1-2.216 3.977A9.273 9.273 0 0 1 6.552 23H4.333a10.855 10.855 0 0 0 2.145 3.297A14.658 14.658 0 0 1 3 28.127L3.702 30a16.42 16.42 0 0 0 4.29-2.336A16.488 16.488 0 0 0 12.299 30L13 28.127A14.664 14.664 0 0 1 9.523 26.3a10.313 10.313 0 0 0 2.729-5.3zm-2.833-8h2.166L8.75 2H6.583L2 13h2.166L5 11h5.333zM5.833 9l1.833-4.4L9.5 9z"}),props.children);});var Language24=/*#__PURE__*/React.forwardRef(function Language24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 19h6v2h-6zm0-4h12v2H18zm0-4h12v2H18zm-4 10v-2H9v-2H7v2H2v2h8.215a8.591 8.591 0 0 1-2.216 3.977A9.273 9.273 0 0 1 6.552 23H4.333a10.855 10.855 0 0 0 2.145 3.297A14.658 14.658 0 0 1 3 28.127L3.702 30a16.42 16.42 0 0 0 4.29-2.336A16.488 16.488 0 0 0 12.299 30L13 28.127A14.664 14.664 0 0 1 9.523 26.3a10.313 10.313 0 0 0 2.729-5.3zm-2.833-8h2.166L8.75 2H6.583L2 13h2.166L5 11h5.333zM5.833 9l1.833-4.4L9.5 9z"}),props.children);});var Language20=/*#__PURE__*/React.forwardRef(function Language20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 19h6v2h-6zm0-4h12v2H18zm0-4h12v2H18zm-4 10v-2H9v-2H7v2H2v2h8.215a8.591 8.591 0 0 1-2.216 3.977A9.273 9.273 0 0 1 6.552 23H4.333a10.855 10.855 0 0 0 2.145 3.297A14.658 14.658 0 0 1 3 28.127L3.702 30a16.42 16.42 0 0 0 4.29-2.336A16.488 16.488 0 0 0 12.299 30L13 28.127A14.664 14.664 0 0 1 9.523 26.3a10.313 10.313 0 0 0 2.729-5.3zm-2.833-8h2.166L8.75 2H6.583L2 13h2.166L5 11h5.333zM5.833 9l1.833-4.4L9.5 9z"}),props.children);});var Language16=/*#__PURE__*/React.forwardRef(function Language16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 19h6v2h-6zm0-4h12v2H18zm0-4h12v2H18zm-4 10v-2H9v-2H7v2H2v2h8.215a8.591 8.591 0 0 1-2.216 3.977A9.273 9.273 0 0 1 6.552 23H4.333a10.855 10.855 0 0 0 2.145 3.297A14.658 14.658 0 0 1 3 28.127L3.702 30a16.42 16.42 0 0 0 4.29-2.336A16.488 16.488 0 0 0 12.299 30L13 28.127A14.664 14.664 0 0 1 9.523 26.3a10.313 10.313 0 0 0 2.729-5.3zm-2.833-8h2.166L8.75 2H6.583L2 13h2.166L5 11h5.333zM5.833 9l1.833-4.4L9.5 9z"}),props.children);});var Laptop32=/*#__PURE__*/React.forwardRef(function Laptop32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 24.005H6a2.002 2.002 0 0 1-2-2v-14a2.002 2.002 0 0 1 2-2h20a2.002 2.002 0 0 1 2 2v14a2.003 2.003 0 0 1-2 2zm-20-16v14h20v-14zm-4 18h28v2H2z"}),props.children);});var Laptop24=/*#__PURE__*/React.forwardRef(function Laptop24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 24.005H6a2.002 2.002 0 0 1-2-2v-14a2.002 2.002 0 0 1 2-2h20a2.002 2.002 0 0 1 2 2v14a2.003 2.003 0 0 1-2 2zm-20-16v14h20v-14zm-4 18h28v2H2z"}),props.children);});var Laptop20=/*#__PURE__*/React.forwardRef(function Laptop20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 24.005H6a2.002 2.002 0 0 1-2-2v-14a2.002 2.002 0 0 1 2-2h20a2.002 2.002 0 0 1 2 2v14a2.003 2.003 0 0 1-2 2zm-20-16v14h20v-14zm-4 18h28v2H2z"}),props.children);});var Laptop16=/*#__PURE__*/React.forwardRef(function Laptop16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 24.005H6a2.002 2.002 0 0 1-2-2v-14a2.002 2.002 0 0 1 2-2h20a2.002 2.002 0 0 1 2 2v14a2.003 2.003 0 0 1-2 2zm-20-16v14h20v-14zm-4 18h28v2H2z"}),props.children);});var Launch32=/*#__PURE__*/React.forwardRef(function Launch32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 28H6a2 2 0 0 1-2-2V6a2 2 0 0 1 2-2h9v2H6v20h20v-9h2v9a2 2 0 0 1-2 2z"}),React.createElement("path",{d:"M21 2v2h5.59L18 12.59 19.41 14 28 5.41V11h2V2h-9z"}),props.children);});var Launch24=/*#__PURE__*/React.forwardRef(function Launch24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 28H6a2 2 0 0 1-2-2V6a2 2 0 0 1 2-2h9v2H6v20h20v-9h2v9a2 2 0 0 1-2 2z"}),React.createElement("path",{d:"M21 2v2h5.59L18 12.59 19.41 14 28 5.41V11h2V2h-9z"}),props.children);});var Launch20=/*#__PURE__*/React.forwardRef(function Launch20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 28H6a2 2 0 0 1-2-2V6a2 2 0 0 1 2-2h9v2H6v20h20v-9h2v9a2 2 0 0 1-2 2z"}),React.createElement("path",{d:"M21 2v2h5.59L18 12.59 19.41 14 28 5.41V11h2V2h-9z"}),props.children);});var LetterAa32=/*#__PURE__*/React.forwardRef(function LetterAa32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 13h-5v2h5v2h-4a2 2 0 0 0-2 2v2a2 2 0 0 0 2 2h6v-8a2 2 0 0 0-2-2zm0 8h-4v-2h4zM13 9H9a2 2 0 0 0-2 2v12h2v-5h4v5h2V11a2 2 0 0 0-2-2zm-4 7v-5h4v5z"}),props.children);});var LetterAa24=/*#__PURE__*/React.forwardRef(function LetterAa24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 13h-5v2h5v2h-4a2 2 0 0 0-2 2v2a2 2 0 0 0 2 2h6v-8a2 2 0 0 0-2-2zm0 8h-4v-2h4zM13 9H9a2 2 0 0 0-2 2v12h2v-5h4v5h2V11a2 2 0 0 0-2-2zm-4 7v-5h4v5z"}),props.children);});var LetterAa20=/*#__PURE__*/React.forwardRef(function LetterAa20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 13h-5v2h5v2h-4a2 2 0 0 0-2 2v2a2 2 0 0 0 2 2h6v-8a2 2 0 0 0-2-2zm0 8h-4v-2h4zM13 9H9a2 2 0 0 0-2 2v12h2v-5h4v5h2V11a2 2 0 0 0-2-2zm-4 7v-5h4v5z"}),props.children);});var LetterAa16=/*#__PURE__*/React.forwardRef(function LetterAa16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 13h-5v2h5v2h-4a2 2 0 0 0-2 2v2a2 2 0 0 0 2 2h6v-8a2 2 0 0 0-2-2zm0 8h-4v-2h4zM13 9H9a2 2 0 0 0-2 2v12h2v-5h4v5h2V11a2 2 0 0 0-2-2zm-4 7v-5h4v5z"}),props.children);});var LetterBb32=/*#__PURE__*/React.forwardRef(function LetterBb32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 13h-4V9h-2v14h6a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2zm-4 8v-6h4v6zm-4-9a3 3 0 0 0-3-3H7v14h5a3 3 0 0 0 3-3v-2a3 3 0 0 0-.78-2 3 3 0 0 0 .78-2zm-6-1h3a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1H9zm4 9a1 1 0 0 1-1 1H9v-4h3a1 1 0 0 1 1 1z"}),props.children);});var LetterBb24=/*#__PURE__*/React.forwardRef(function LetterBb24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 13h-4V9h-2v14h6a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2zm-4 8v-6h4v6zm-4-9a3 3 0 0 0-3-3H7v14h5a3 3 0 0 0 3-3v-2a3 3 0 0 0-.78-2 3 3 0 0 0 .78-2zm-6-1h3a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1H9zm4 9a1 1 0 0 1-1 1H9v-4h3a1 1 0 0 1 1 1z"}),props.children);});var LetterBb20=/*#__PURE__*/React.forwardRef(function LetterBb20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 13h-4V9h-2v14h6a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2zm-4 8v-6h4v6zm-4-9a3 3 0 0 0-3-3H7v14h5a3 3 0 0 0 3-3v-2a3 3 0 0 0-.78-2 3 3 0 0 0 .78-2zm-6-1h3a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1H9zm4 9a1 1 0 0 1-1 1H9v-4h3a1 1 0 0 1 1 1z"}),props.children);});var LetterBb16=/*#__PURE__*/React.forwardRef(function LetterBb16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 13h-4V9h-2v14h6a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2zm-4 8v-6h4v6zm-4-9a3 3 0 0 0-3-3H7v14h5a3 3 0 0 0 3-3v-2a3 3 0 0 0-.78-2 3 3 0 0 0 .78-2zm-6-1h3a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1H9zm4 9a1 1 0 0 1-1 1H9v-4h3a1 1 0 0 1 1 1z"}),props.children);});var LetterCc32=/*#__PURE__*/React.forwardRef(function LetterCc32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 23h-5a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h5v2h-5v6h5zm-9 0H9a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h6v2H9v10h6z"}),props.children);});var LetterCc24=/*#__PURE__*/React.forwardRef(function LetterCc24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 23h-5a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h5v2h-5v6h5zm-9 0H9a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h6v2H9v10h6z"}),props.children);});var LetterCc20=/*#__PURE__*/React.forwardRef(function LetterCc20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 23h-5a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h5v2h-5v6h5zm-9 0H9a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h6v2H9v10h6z"}),props.children);});var LetterCc16=/*#__PURE__*/React.forwardRef(function LetterCc16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 23h-5a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h5v2h-5v6h5zm-9 0H9a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h6v2H9v10h6z"}),props.children);});var LetterDd32=/*#__PURE__*/React.forwardRef(function LetterDd32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 9v4h-4a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h6V9zm-4 6h4v6h-4zm-8 8H7V9h4a4 4 0 0 1 4 4v6a4 4 0 0 1-4 4zm-2-2h2a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2H9z"}),props.children);});var LetterDd24=/*#__PURE__*/React.forwardRef(function LetterDd24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 9v4h-4a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h6V9zm-4 6h4v6h-4zm-8 8H7V9h4a4 4 0 0 1 4 4v6a4 4 0 0 1-4 4zm-2-2h2a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2H9z"}),props.children);});var LetterDd20=/*#__PURE__*/React.forwardRef(function LetterDd20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 9v4h-4a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h6V9zm-4 6h4v6h-4zm-8 8H7V9h4a4 4 0 0 1 4 4v6a4 4 0 0 1-4 4zm-2-2h2a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2H9z"}),props.children);});var LetterDd16=/*#__PURE__*/React.forwardRef(function LetterDd16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 9v4h-4a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h6V9zm-4 6h4v6h-4zm-8 8H7V9h4a4 4 0 0 1 4 4v6a4 4 0 0 1-4 4zm-2-2h2a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2H9z"}),props.children);});var LetterEe32=/*#__PURE__*/React.forwardRef(function LetterEe32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 11V9.02H7V23h8v-2H9v-4h5v-2H9v-4h6zm10 8v-4a2 2 0 0 0-2-2h-4a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h5v-2h-5v-2zm-6-4h4v2h-4z"}),props.children);});var LetterEe24=/*#__PURE__*/React.forwardRef(function LetterEe24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 11V9.02H7V23h8v-2H9v-4h5v-2H9v-4h6zm10 8v-4a2 2 0 0 0-2-2h-4a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h5v-2h-5v-2zm-6-4h4v2h-4z"}),props.children);});var LetterEe20=/*#__PURE__*/React.forwardRef(function LetterEe20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 11V9.02H7V23h8v-2H9v-4h5v-2H9v-4h6zm10 8v-4a2 2 0 0 0-2-2h-4a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h5v-2h-5v-2zm-6-4h4v2h-4z"}),props.children);});var LetterEe16=/*#__PURE__*/React.forwardRef(function LetterEe16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 11V9.02H7V23h8v-2H9v-4h5v-2H9v-4h6zm10 8v-4a2 2 0 0 0-2-2h-4a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h5v-2h-5v-2zm-6-4h4v2h-4z"}),props.children);});var LetterFf32=/*#__PURE__*/React.forwardRef(function LetterFf32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 11V9H8v14h2v-6h5v-2h-5v-4h6zm8 0V9h-3a2 2 0 0 0-2 2v2h-2v2h2v8h2v-8h3v-2h-3v-2z"}),props.children);});var LetterFf24=/*#__PURE__*/React.forwardRef(function LetterFf24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 11V9H8v14h2v-6h5v-2h-5v-4h6zm8 0V9h-3a2 2 0 0 0-2 2v2h-2v2h2v8h2v-8h3v-2h-3v-2z"}),props.children);});var LetterFf20=/*#__PURE__*/React.forwardRef(function LetterFf20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 11V9H8v14h2v-6h5v-2h-5v-4h6zm8 0V9h-3a2 2 0 0 0-2 2v2h-2v2h2v8h2v-8h3v-2h-3v-2z"}),props.children);});var LetterFf16=/*#__PURE__*/React.forwardRef(function LetterFf16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 11V9H8v14h2v-6h5v-2h-5v-4h6zm8 0V9h-3a2 2 0 0 0-2 2v2h-2v2h2v8h2v-8h3v-2h-3v-2z"}),props.children);});var LetterGg32=/*#__PURE__*/React.forwardRef(function LetterGg32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19 13a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h4v2h-5v2h5a2 2 0 0 0 2-2V13zm4 8h-4v-6h4zm-8 2H9a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h6v2H9v10h4v-4h-2v-2h4z"}),props.children);});var LetterGg24=/*#__PURE__*/React.forwardRef(function LetterGg24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19 13a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h4v2h-5v2h5a2 2 0 0 0 2-2V13zm4 8h-4v-6h4zm-8 2H9a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h6v2H9v10h4v-4h-2v-2h4z"}),props.children);});var LetterGg20=/*#__PURE__*/React.forwardRef(function LetterGg20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19 13a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h4v2h-5v2h5a2 2 0 0 0 2-2V13zm4 8h-4v-6h4zm-8 2H9a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h6v2H9v10h4v-4h-2v-2h4z"}),props.children);});var LetterGg16=/*#__PURE__*/React.forwardRef(function LetterGg16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19 13a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h4v2h-5v2h5a2 2 0 0 0 2-2V13zm4 8h-4v-6h4zm-8 2H9a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h6v2H9v10h4v-4h-2v-2h4z"}),props.children);});var LetterHh32=/*#__PURE__*/React.forwardRef(function LetterHh32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13 9v6H9V9H7v14h2v-6h4v6h2V9h-2zm10 4h-4V9h-2v14h2v-8h4v8h2v-8a2 2 0 0 0-2-2z"}),props.children);});var LetterHh24=/*#__PURE__*/React.forwardRef(function LetterHh24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13 9v6H9V9H7v14h2v-6h4v6h2V9h-2zm10 4h-4V9h-2v14h2v-8h4v8h2v-8a2 2 0 0 0-2-2z"}),props.children);});var LetterHh20=/*#__PURE__*/React.forwardRef(function LetterHh20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13 9v6H9V9H7v14h2v-6h4v6h2V9h-2zm10 4h-4V9h-2v14h2v-8h4v8h2v-8a2 2 0 0 0-2-2z"}),props.children);});var LetterHh16=/*#__PURE__*/React.forwardRef(function LetterHh16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13 9v6H9V9H7v14h2v-6h4v6h2V9h-2zm10 4h-4V9h-2v14h2v-8h4v8h2v-8a2 2 0 0 0-2-2z"}),props.children);});var LetterIi32=/*#__PURE__*/React.forwardRef(function LetterIi32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 11h3v10h-3v2h8v-2h-3V11h3V9h-8v2zm10 2h2v10h-2zm0-4h2v2h-2z"}),props.children);});var LetterIi24=/*#__PURE__*/React.forwardRef(function LetterIi24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 11h3v10h-3v2h8v-2h-3V11h3V9h-8v2zm10 2h2v10h-2zm0-4h2v2h-2z"}),props.children);});var LetterIi20=/*#__PURE__*/React.forwardRef(function LetterIi20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 11h3v10h-3v2h8v-2h-3V11h3V9h-8v2zm10 2h2v10h-2zm0-4h2v2h-2z"}),props.children);});var LetterIi16=/*#__PURE__*/React.forwardRef(function LetterIi16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 11h3v10h-3v2h8v-2h-3V11h3V9h-8v2zm10 2h2v10h-2zm0-4h2v2h-2z"}),props.children);});var LetterJj32=/*#__PURE__*/React.forwardRef(function LetterJj32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 9h2v2h-2zm0 16h-3v2h3a2 2 0 0 0 2-2V13h-2zm-6-2h-4a2 2 0 0 1-2-2v-2h2v2h4V9h2v12a2 2 0 0 1-2 2z"}),props.children);});var LetterJj24=/*#__PURE__*/React.forwardRef(function LetterJj24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 9h2v2h-2zm0 16h-3v2h3a2 2 0 0 0 2-2V13h-2zm-6-2h-4a2 2 0 0 1-2-2v-2h2v2h4V9h2v12a2 2 0 0 1-2 2z"}),props.children);});var LetterJj20=/*#__PURE__*/React.forwardRef(function LetterJj20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 9h2v2h-2zm0 16h-3v2h3a2 2 0 0 0 2-2V13h-2zm-6-2h-4a2 2 0 0 1-2-2v-2h2v2h4V9h2v12a2 2 0 0 1-2 2z"}),props.children);});var LetterJj16=/*#__PURE__*/React.forwardRef(function LetterJj16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 9h2v2h-2zm0 16h-3v2h3a2 2 0 0 0 2-2V13h-2zm-6-2h-4a2 2 0 0 1-2-2v-2h2v2h4V9h2v12a2 2 0 0 1-2 2z"}),props.children);});var LetterKk32=/*#__PURE__*/React.forwardRef(function LetterKk32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 9h-2.11L9 15.55V9H7v14h2v-4.29l.93-1.49L12.89 23H15l-3.89-7.57L15 9zm7.78 14H25l-3.78-6L25 13h-2.24L19 17.17V9h-2v14h2v-3.75l.96-1.04L22.78 23z"}),props.children);});var LetterKk24=/*#__PURE__*/React.forwardRef(function LetterKk24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 9h-2.11L9 15.55V9H7v14h2v-4.29l.93-1.49L12.89 23H15l-3.89-7.57L15 9zm7.78 14H25l-3.78-6L25 13h-2.24L19 17.17V9h-2v14h2v-3.75l.96-1.04L22.78 23z"}),props.children);});var LetterKk20=/*#__PURE__*/React.forwardRef(function LetterKk20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 9h-2.11L9 15.55V9H7v14h2v-4.29l.93-1.49L12.89 23H15l-3.89-7.57L15 9zm7.78 14H25l-3.78-6L25 13h-2.24L19 17.17V9h-2v14h2v-3.75l.96-1.04L22.78 23z"}),props.children);});var LetterKk16=/*#__PURE__*/React.forwardRef(function LetterKk16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 9h-2.11L9 15.55V9H7v14h2v-4.29l.93-1.49L12.89 23H15l-3.89-7.57L15 9zm7.78 14H25l-3.78-6L25 13h-2.24L19 17.17V9h-2v14h2v-3.75l.96-1.04L22.78 23z"}),props.children);});var LetterLl32=/*#__PURE__*/React.forwardRef(function LetterLl32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11 21V9H9v14h8v-2h-6zm12 2h-2a2 2 0 0 1-2-2V9h2v12h2z"}),props.children);});var LetterLl24=/*#__PURE__*/React.forwardRef(function LetterLl24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11 21V9H9v14h8v-2h-6zm12 2h-2a2 2 0 0 1-2-2V9h2v12h2z"}),props.children);});var LetterLl20=/*#__PURE__*/React.forwardRef(function LetterLl20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11 21V9H9v14h8v-2h-6zm12 2h-2a2 2 0 0 1-2-2V9h2v12h2z"}),props.children);});var LetterLl16=/*#__PURE__*/React.forwardRef(function LetterLl16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11 21V9H9v14h8v-2h-6zm12 2h-2a2 2 0 0 1-2-2V9h2v12h2z"}),props.children);});var LetterMm32=/*#__PURE__*/React.forwardRef(function LetterMm32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 13h-8v10h2v-8h2v8h2v-8h2v8h2v-8a2 2 0 0 0-2-2zM12 9l-1.52 5-.48 1.98L9.54 14 8 9H6v14h2v-8l-.16-2 .58 2L10 19.63 11.58 15l.58-2-.16 2v8h2V9h-2z"}),props.children);});var LetterMm24=/*#__PURE__*/React.forwardRef(function LetterMm24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 13h-8v10h2v-8h2v8h2v-8h2v8h2v-8a2 2 0 0 0-2-2zM12 9l-1.52 5-.48 1.98L9.54 14 8 9H6v14h2v-8l-.16-2 .58 2L10 19.63 11.58 15l.58-2-.16 2v8h2V9h-2z"}),props.children);});var LetterMm20=/*#__PURE__*/React.forwardRef(function LetterMm20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 13h-8v10h2v-8h2v8h2v-8h2v8h2v-8a2 2 0 0 0-2-2zM12 9l-1.52 5-.48 1.98L9.54 14 8 9H6v14h2v-8l-.16-2 .58 2L10 19.63 11.58 15l.58-2-.16 2v8h2V9h-2z"}),props.children);});var LetterMm16=/*#__PURE__*/React.forwardRef(function LetterMm16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 13h-8v10h2v-8h2v8h2v-8h2v8h2v-8a2 2 0 0 0-2-2zM12 9l-1.52 5-.48 1.98L9.54 14 8 9H6v14h2v-8l-.16-2 .58 2L10 19.63 11.58 15l.58-2-.16 2v8h2V9h-2z"}),props.children);});var LetterNn32=/*#__PURE__*/React.forwardRef(function LetterNn32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 23h-2v-8h-4v8h-2V13h6a2 2 0 0 1 2 2zm-12-4L9.32 9H7v14h2V13l3.68 10H15V9h-2v10z"}),props.children);});var LetterNn24=/*#__PURE__*/React.forwardRef(function LetterNn24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 23h-2v-8h-4v8h-2V13h6a2 2 0 0 1 2 2zm-12-4L9.32 9H7v14h2V13l3.68 10H15V9h-2v10z"}),props.children);});var LetterNn20=/*#__PURE__*/React.forwardRef(function LetterNn20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 23h-2v-8h-4v8h-2V13h6a2 2 0 0 1 2 2zm-12-4L9.32 9H7v14h2V13l3.68 10H15V9h-2v10z"}),props.children);});var LetterNn16=/*#__PURE__*/React.forwardRef(function LetterNn16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 23h-2v-8h-4v8h-2V13h6a2 2 0 0 1 2 2zm-12-4L9.32 9H7v14h2V13l3.68 10H15V9h-2v10z"}),props.children);});var LetterOo32=/*#__PURE__*/React.forwardRef(function LetterOo32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 23h-4a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2zm-4-8v6h4v-6zm-6 8H9a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v10a2 2 0 0 1-2 2zM9 11v10h4V11z"}),props.children);});var LetterOo24=/*#__PURE__*/React.forwardRef(function LetterOo24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 23h-4a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2zm-4-8v6h4v-6zm-6 8H9a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v10a2 2 0 0 1-2 2zM9 11v10h4V11z"}),props.children);});var LetterOo20=/*#__PURE__*/React.forwardRef(function LetterOo20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 23h-4a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2zm-4-8v6h4v-6zm-6 8H9a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v10a2 2 0 0 1-2 2zM9 11v10h4V11z"}),props.children);});var LetterOo16=/*#__PURE__*/React.forwardRef(function LetterOo16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 23h-4a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2zm-4-8v6h4v-6zm-6 8H9a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v10a2 2 0 0 1-2 2zM9 11v10h4V11z"}),props.children);});var LetterPp32=/*#__PURE__*/React.forwardRef(function LetterPp32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 13h-6v14h2v-4h4a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2zm-4 8v-6h4v6zM9 23H7V9h6a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2H9zm0-7h4v-5H9z"}),props.children);});var LetterPp24=/*#__PURE__*/React.forwardRef(function LetterPp24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 13h-6v14h2v-4h4a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2zm-4 8v-6h4v6zM9 23H7V9h6a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2H9zm0-7h4v-5H9z"}),props.children);});var LetterPp20=/*#__PURE__*/React.forwardRef(function LetterPp20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 13h-6v14h2v-4h4a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2zm-4 8v-6h4v6zM9 23H7V9h6a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2H9zm0-7h4v-5H9z"}),props.children);});var LetterPp16=/*#__PURE__*/React.forwardRef(function LetterPp16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 13h-6v14h2v-4h4a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2zm-4 8v-6h4v6zM9 23H7V9h6a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2H9zm0-7h4v-5H9z"}),props.children);});var LetterQq32=/*#__PURE__*/React.forwardRef(function LetterQq32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19 13a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h4v4h2V13zm4 8h-4v-6h4zM13 9H9a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h1v2a2 2 0 0 0 2 2h2v-2h-2v-2h1a2 2 0 0 0 2-2V11a2 2 0 0 0-2-2zM9 21V11h4v10z"}),props.children);});var LetterQq24=/*#__PURE__*/React.forwardRef(function LetterQq24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19 13a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h4v4h2V13zm4 8h-4v-6h4zM13 9H9a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h1v2a2 2 0 0 0 2 2h2v-2h-2v-2h1a2 2 0 0 0 2-2V11a2 2 0 0 0-2-2zM9 21V11h4v10z"}),props.children);});var LetterQq20=/*#__PURE__*/React.forwardRef(function LetterQq20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19 13a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h4v4h2V13zm4 8h-4v-6h4zM13 9H9a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h1v2a2 2 0 0 0 2 2h2v-2h-2v-2h1a2 2 0 0 0 2-2V11a2 2 0 0 0-2-2zM9 21V11h4v10z"}),props.children);});var LetterQq16=/*#__PURE__*/React.forwardRef(function LetterQq16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19 13a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h4v4h2V13zm4 8h-4v-6h4zM13 9H9a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h1v2a2 2 0 0 0 2 2h2v-2h-2v-2h1a2 2 0 0 0 2-2V11a2 2 0 0 0-2-2zM9 21V11h4v10z"}),props.children);});var LetterRr32=/*#__PURE__*/React.forwardRef(function LetterRr32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 15v-4a2 2 0 0 0-2-2H8v14h2v-6h1.48l2.34 6H16l-2.33-6H14a2 2 0 0 0 2-2zm-6-4h4v4h-4zm14 2h-6v10h2v-8h4v-2z"}),props.children);});var LetterRr24=/*#__PURE__*/React.forwardRef(function LetterRr24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 15v-4a2 2 0 0 0-2-2H8v14h2v-6h1.48l2.34 6H16l-2.33-6H14a2 2 0 0 0 2-2zm-6-4h4v4h-4zm14 2h-6v10h2v-8h4v-2z"}),props.children);});var LetterRr20=/*#__PURE__*/React.forwardRef(function LetterRr20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 15v-4a2 2 0 0 0-2-2H8v14h2v-6h1.48l2.34 6H16l-2.33-6H14a2 2 0 0 0 2-2zm-6-4h4v4h-4zm14 2h-6v10h2v-8h4v-2z"}),props.children);});var LetterRr16=/*#__PURE__*/React.forwardRef(function LetterRr16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 15v-4a2 2 0 0 0-2-2H8v14h2v-6h1.48l2.34 6H16l-2.33-6H14a2 2 0 0 0 2-2zm-6-4h4v4h-4zm14 2h-6v10h2v-8h4v-2z"}),props.children);});var LetterSs32=/*#__PURE__*/React.forwardRef(function LetterSs32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22 23h-5v-2h5v-2h-3a2 2 0 0 1-2-2v-2a2 2 0 0 1 2-2h5v2h-5v2h3a2 2 0 0 1 2 2v2a2 2 0 0 1-2 2zm-9 0H7v-2h6v-4H9a2 2 0 0 1-2-2v-4a2 2 0 0 1 2-2h6v2H9v4h4a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2z"}),props.children);});var LetterSs24=/*#__PURE__*/React.forwardRef(function LetterSs24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22 23h-5v-2h5v-2h-3a2 2 0 0 1-2-2v-2a2 2 0 0 1 2-2h5v2h-5v2h3a2 2 0 0 1 2 2v2a2 2 0 0 1-2 2zm-9 0H7v-2h6v-4H9a2 2 0 0 1-2-2v-4a2 2 0 0 1 2-2h6v2H9v4h4a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2z"}),props.children);});var LetterSs20=/*#__PURE__*/React.forwardRef(function LetterSs20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22 23h-5v-2h5v-2h-3a2 2 0 0 1-2-2v-2a2 2 0 0 1 2-2h5v2h-5v2h3a2 2 0 0 1 2 2v2a2 2 0 0 1-2 2zm-9 0H7v-2h6v-4H9a2 2 0 0 1-2-2v-4a2 2 0 0 1 2-2h6v2H9v4h4a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2z"}),props.children);});var LetterSs16=/*#__PURE__*/React.forwardRef(function LetterSs16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22 23h-5v-2h5v-2h-3a2 2 0 0 1-2-2v-2a2 2 0 0 1 2-2h5v2h-5v2h3a2 2 0 0 1 2 2v2a2 2 0 0 1-2 2zm-9 0H7v-2h6v-4H9a2 2 0 0 1-2-2v-4a2 2 0 0 1 2-2h6v2H9v4h4a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2z"}),props.children);});var LetterTt32=/*#__PURE__*/React.forwardRef(function LetterTt32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8 11h3v12h2V11h3V9H8v2zm15 4v-2h-3v-2h-2v2h-2v2h2v6a2 2 0 0 0 2 2h3v-2h-3v-6z"}),props.children);});var LetterTt24=/*#__PURE__*/React.forwardRef(function LetterTt24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8 11h3v12h2V11h3V9H8v2zm15 4v-2h-3v-2h-2v2h-2v2h2v6a2 2 0 0 0 2 2h3v-2h-3v-6z"}),props.children);});var LetterTt20=/*#__PURE__*/React.forwardRef(function LetterTt20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8 11h3v12h2V11h3V9H8v2zm15 4v-2h-3v-2h-2v2h-2v2h2v6a2 2 0 0 0 2 2h3v-2h-3v-6z"}),props.children);});var LetterTt16=/*#__PURE__*/React.forwardRef(function LetterTt16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8 11h3v12h2V11h3V9H8v2zm15 4v-2h-3v-2h-2v2h-2v2h2v6a2 2 0 0 0 2 2h3v-2h-3v-6z"}),props.children);});var LetterUu32=/*#__PURE__*/React.forwardRef(function LetterUu32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 23h-4a2 2 0 0 1-2-2v-8h2v8h4v-8h2v8a2 2 0 0 1-2 2zm-10 0H9a2 2 0 0 1-2-2V9h2v12h4V9h2v12a2 2 0 0 1-2 2z"}),props.children);});var LetterUu24=/*#__PURE__*/React.forwardRef(function LetterUu24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 23h-4a2 2 0 0 1-2-2v-8h2v8h4v-8h2v8a2 2 0 0 1-2 2zm-10 0H9a2 2 0 0 1-2-2V9h2v12h4V9h2v12a2 2 0 0 1-2 2z"}),props.children);});var LetterUu20=/*#__PURE__*/React.forwardRef(function LetterUu20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 23h-4a2 2 0 0 1-2-2v-8h2v8h4v-8h2v8a2 2 0 0 1-2 2zm-10 0H9a2 2 0 0 1-2-2V9h2v12h4V9h2v12a2 2 0 0 1-2 2z"}),props.children);});var LetterUu16=/*#__PURE__*/React.forwardRef(function LetterUu16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 23h-4a2 2 0 0 1-2-2v-8h2v8h4v-8h2v8a2 2 0 0 1-2 2zm-10 0H9a2 2 0 0 1-2-2V9h2v12h4V9h2v12a2 2 0 0 1-2 2z"}),props.children);});var LetterVv32=/*#__PURE__*/React.forwardRef(function LetterVv32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 13h-1.75L21 22.03 18.79 13H17l2.5 10h3L25 13zM13 9l-2 13L9 9H7l2.52 14h2.96L15 9h-2z"}),props.children);});var LetterVv24=/*#__PURE__*/React.forwardRef(function LetterVv24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 13h-1.75L21 22.03 18.79 13H17l2.5 10h3L25 13zM13 9l-2 13L9 9H7l2.52 14h2.96L15 9h-2z"}),props.children);});var LetterVv20=/*#__PURE__*/React.forwardRef(function LetterVv20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 13h-1.75L21 22.03 18.79 13H17l2.5 10h3L25 13zM13 9l-2 13L9 9H7l2.52 14h2.96L15 9h-2z"}),props.children);});var LetterVv16=/*#__PURE__*/React.forwardRef(function LetterVv16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 13h-1.75L21 22.03 18.79 13H17l2.5 10h3L25 13zM13 9l-2 13L9 9H7l2.52 14h2.96L15 9h-2z"}),props.children);});var LetterWw32=/*#__PURE__*/React.forwardRef(function LetterWw32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24.3 13l-.91 8.61L22 13h-2l-1.39 8.61L17.7 13H16l1.36 10h2.28L21 14.63 22.36 23h2.28L26 13h-1.7zM12.21 9l-.34 8-.26 4.54L11.2 18l-.68-5.46H8.5L7.82 18l-.41 3.54L7.16 17l-.35-8h-1.8l1 14h2.27l.76-4.93L9.5 14l.01-.03.01.03.46 4.07.76 4.93h2.27l1-14h-1.8z"}),props.children);});var LetterWw24=/*#__PURE__*/React.forwardRef(function LetterWw24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24.3 13l-.91 8.61L22 13h-2l-1.39 8.61L17.7 13H16l1.36 10h2.28L21 14.63 22.36 23h2.28L26 13h-1.7zM12.21 9l-.34 8-.26 4.54L11.2 18l-.68-5.46H8.5L7.82 18l-.41 3.54L7.16 17l-.35-8h-1.8l1 14h2.27l.76-4.93L9.5 14l.01-.03.01.03.46 4.07.76 4.93h2.27l1-14h-1.8z"}),props.children);});var LetterWw20=/*#__PURE__*/React.forwardRef(function LetterWw20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24.3 13l-.91 8.61L22 13h-2l-1.39 8.61L17.7 13H16l1.36 10h2.28L21 14.63 22.36 23h2.28L26 13h-1.7zM12.21 9l-.34 8-.26 4.54L11.2 18l-.68-5.46H8.5L7.82 18l-.41 3.54L7.16 17l-.35-8h-1.8l1 14h2.27l.76-4.93L9.5 14l.01-.03.01.03.46 4.07.76 4.93h2.27l1-14h-1.8z"}),props.children);});var LetterWw16=/*#__PURE__*/React.forwardRef(function LetterWw16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24.3 13l-.91 8.61L22 13h-2l-1.39 8.61L17.7 13H16l1.36 10h2.28L21 14.63 22.36 23h2.28L26 13h-1.7zM12.21 9l-.34 8-.26 4.54L11.2 18l-.68-5.46H8.5L7.82 18l-.41 3.54L7.16 17l-.35-8h-1.8l1 14h2.27l.76-4.93L9.5 14l.01-.03.01.03.46 4.07.76 4.93h2.27l1-14h-1.8z"}),props.children);});var LetterXx32=/*#__PURE__*/React.forwardRef(function LetterXx32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 9h-2l-2 6-2-6H7l2.75 7L7 23h2l2-6 2 6h2l-2.76-7L15 9zm10 4h-2l-2 3.9-2-3.9h-2l2.91 5L17 23h2l2-3.8 2 3.8h2l-2.9-5 2.9-5z"}),props.children);});var LetterXx24=/*#__PURE__*/React.forwardRef(function LetterXx24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 9h-2l-2 6-2-6H7l2.75 7L7 23h2l2-6 2 6h2l-2.76-7L15 9zm10 4h-2l-2 3.9-2-3.9h-2l2.91 5L17 23h2l2-3.8 2 3.8h2l-2.9-5 2.9-5z"}),props.children);});var LetterXx20=/*#__PURE__*/React.forwardRef(function LetterXx20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 9h-2l-2 6-2-6H7l2.75 7L7 23h2l2-6 2 6h2l-2.76-7L15 9zm10 4h-2l-2 3.9-2-3.9h-2l2.91 5L17 23h2l2-3.8 2 3.8h2l-2.9-5 2.9-5z"}),props.children);});var LetterXx16=/*#__PURE__*/React.forwardRef(function LetterXx16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 9h-2l-2 6-2-6H7l2.75 7L7 23h2l2-6 2 6h2l-2.76-7L15 9zm10 4h-2l-2 3.9-2-3.9h-2l2.91 5L17 23h2l2-3.8 2 3.8h2l-2.9-5 2.9-5z"}),props.children);});var LetterYy32=/*#__PURE__*/React.forwardRef(function LetterYy32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 9h-2l-2 7-2-7H7l3 9v5h2v-5l3-9zm8 4l-2 7.52L19.08 13H17l3.15 9.87-.62 2.13H17v2h2.26a2 2 0 0 0 1.91-1.42L25 13z"}),props.children);});var LetterYy24=/*#__PURE__*/React.forwardRef(function LetterYy24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 9h-2l-2 7-2-7H7l3 9v5h2v-5l3-9zm8 4l-2 7.52L19.08 13H17l3.15 9.87-.62 2.13H17v2h2.26a2 2 0 0 0 1.91-1.42L25 13z"}),props.children);});var LetterYy20=/*#__PURE__*/React.forwardRef(function LetterYy20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 9h-2l-2 7-2-7H7l3 9v5h2v-5l3-9zm8 4l-2 7.52L19.08 13H17l3.15 9.87-.62 2.13H17v2h2.26a2 2 0 0 0 1.91-1.42L25 13z"}),props.children);});var LetterYy16=/*#__PURE__*/React.forwardRef(function LetterYy16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 9h-2l-2 7-2-7H7l3 9v5h2v-5l3-9zm8 4l-2 7.52L19.08 13H17l3.15 9.87-.62 2.13H17v2h2.26a2 2 0 0 0 1.91-1.42L25 13z"}),props.children);});var LetterZz32=/*#__PURE__*/React.forwardRef(function LetterZz32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 15v-2h-8v2h5.5L17 21v2h8v-2h-5.49L25 15zM15 9H7v2h6L7 21v2h8v-2H9l6-10V9z"}),props.children);});var LetterZz24=/*#__PURE__*/React.forwardRef(function LetterZz24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 15v-2h-8v2h5.5L17 21v2h8v-2h-5.49L25 15zM15 9H7v2h6L7 21v2h8v-2H9l6-10V9z"}),props.children);});var LetterZz20=/*#__PURE__*/React.forwardRef(function LetterZz20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 15v-2h-8v2h5.5L17 21v2h8v-2h-5.49L25 15zM15 9H7v2h6L7 21v2h8v-2H9l6-10V9z"}),props.children);});var LetterZz16=/*#__PURE__*/React.forwardRef(function LetterZz16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 15v-2h-8v2h5.5L17 21v2h8v-2h-5.49L25 15zM15 9H7v2h6L7 21v2h8v-2H9l6-10V9z"}),props.children);});var LightFilled32=/*#__PURE__*/React.forwardRef(function LightFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 2h2v4.96h-2zm6.687 6.89l3.507-3.506 1.414 1.414-3.507 3.507zM25.04 15H30v2h-4.96zm-3.347 8.104l1.414-1.414 3.507 3.507L25.2 26.61zM15 25.04h2V30h-2zm-9.604.162l3.508-3.507 1.414 1.414-3.507 3.507zM2 15h4.96v2H2zm3.39-8.197l1.415-1.414 3.507 3.507-1.414 1.414zM16 10a6 6 0 1 0 6 6 6 6 0 0 0-6-6z"}),props.children);});var LightFilled24=/*#__PURE__*/React.forwardRef(function LightFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 2h2v4.96h-2zm6.687 6.89l3.507-3.506 1.414 1.414-3.507 3.507zM25.04 15H30v2h-4.96zm-3.347 8.104l1.414-1.414 3.507 3.507L25.2 26.61zM15 25.04h2V30h-2zm-9.604.162l3.508-3.507 1.414 1.414-3.507 3.507zM2 15h4.96v2H2zm3.39-8.197l1.415-1.414 3.507 3.507-1.414 1.414zM16 10a6 6 0 1 0 6 6 6 6 0 0 0-6-6z"}),props.children);});var LightFilled20=/*#__PURE__*/React.forwardRef(function LightFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 2h2v4.96h-2zm6.687 6.89l3.507-3.506 1.414 1.414-3.507 3.507zM25.04 15H30v2h-4.96zm-3.347 8.104l1.414-1.414 3.507 3.507L25.2 26.61zM15 25.04h2V30h-2zm-9.604.162l3.508-3.507 1.414 1.414-3.507 3.507zM2 15h4.96v2H2zm3.39-8.197l1.415-1.414 3.507 3.507-1.414 1.414zM16 10a6 6 0 1 0 6 6 6 6 0 0 0-6-6z"}),props.children);});var LightFilled16=/*#__PURE__*/React.forwardRef(function LightFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 2h2v4.96h-2zm6.687 6.89l3.507-3.506 1.414 1.414-3.507 3.507zM25.04 15H30v2h-4.96zm-3.347 8.104l1.414-1.414 3.507 3.507L25.2 26.61zM15 25.04h2V30h-2zm-9.604.162l3.508-3.507 1.414 1.414-3.507 3.507zM2 15h4.96v2H2zm3.39-8.197l1.415-1.414 3.507 3.507-1.414 1.414zM16 10a6 6 0 1 0 6 6 6 6 0 0 0-6-6z"}),props.children);});var Light32=/*#__PURE__*/React.forwardRef(function Light32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 2h2v4.96h-2zm6.687 6.89l3.507-3.506 1.414 1.414-3.507 3.507zM25.04 15H30v2h-4.96zm-3.347 8.104l1.414-1.414 3.507 3.507L25.2 26.61zM15 25.04h2V30h-2zm-9.604.162l3.508-3.507 1.414 1.414-3.507 3.507zM2 15h4.96v2H2zm3.39-8.197l1.415-1.414 3.507 3.507-1.414 1.414zM16 12a4 4 0 1 1-4 4 4 4 0 0 1 4-4m0-2a6 6 0 1 0 6 6 6 6 0 0 0-6-6z"}),props.children);});var Light24=/*#__PURE__*/React.forwardRef(function Light24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 2h2v4.96h-2zm6.687 6.89l3.507-3.506 1.414 1.414-3.507 3.507zM25.04 15H30v2h-4.96zm-3.347 8.104l1.414-1.414 3.507 3.507L25.2 26.61zM15 25.04h2V30h-2zm-9.604.162l3.508-3.507 1.414 1.414-3.507 3.507zM2 15h4.96v2H2zm3.39-8.197l1.415-1.414 3.507 3.507-1.414 1.414zM16 12a4 4 0 1 1-4 4 4 4 0 0 1 4-4m0-2a6 6 0 1 0 6 6 6 6 0 0 0-6-6z"}),props.children);});var Light20=/*#__PURE__*/React.forwardRef(function Light20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 2h2v4.96h-2zm6.687 6.89l3.507-3.506 1.414 1.414-3.507 3.507zM25.04 15H30v2h-4.96zm-3.347 8.104l1.414-1.414 3.507 3.507L25.2 26.61zM15 25.04h2V30h-2zm-9.604.162l3.508-3.507 1.414 1.414-3.507 3.507zM2 15h4.96v2H2zm3.39-8.197l1.415-1.414 3.507 3.507-1.414 1.414zM16 12a4 4 0 1 1-4 4 4 4 0 0 1 4-4m0-2a6 6 0 1 0 6 6 6 6 0 0 0-6-6z"}),props.children);});var Link32=/*#__PURE__*/React.forwardRef(function Link32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.25 6.76a6 6 0 0 0-8.5 0l1.42 1.42a4 4 0 1 1 5.67 5.67l-8 8a4 4 0 1 1-5.67-5.66l1.41-1.42-1.41-1.42-1.42 1.42a6 6 0 0 0 0 8.5A6 6 0 0 0 17 25a6 6 0 0 0 4.27-1.76l8-8a6 6 0 0 0-.02-8.48z"}),React.createElement("path",{d:"M4.19 24.82a4 4 0 0 1 0-5.67l8-8a4 4 0 0 1 5.67 0A3.94 3.94 0 0 1 19 14a4 4 0 0 1-1.17 2.85L15.71 19l1.42 1.42 2.12-2.12a6 6 0 0 0-8.51-8.51l-8 8a6 6 0 0 0 0 8.51A6 6 0 0 0 7 28a6.07 6.07 0 0 0 4.28-1.76l-1.42-1.42a4 4 0 0 1-5.67 0z"}),props.children);});var Link24=/*#__PURE__*/React.forwardRef(function Link24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.25 6.76a6 6 0 0 0-8.5 0l1.42 1.42a4 4 0 1 1 5.67 5.67l-8 8a4 4 0 1 1-5.67-5.66l1.41-1.42-1.41-1.42-1.42 1.42a6 6 0 0 0 0 8.5A6 6 0 0 0 17 25a6 6 0 0 0 4.27-1.76l8-8a6 6 0 0 0-.02-8.48z"}),React.createElement("path",{d:"M4.19 24.82a4 4 0 0 1 0-5.67l8-8a4 4 0 0 1 5.67 0A3.94 3.94 0 0 1 19 14a4 4 0 0 1-1.17 2.85L15.71 19l1.42 1.42 2.12-2.12a6 6 0 0 0-8.51-8.51l-8 8a6 6 0 0 0 0 8.51A6 6 0 0 0 7 28a6.07 6.07 0 0 0 4.28-1.76l-1.42-1.42a4 4 0 0 1-5.67 0z"}),props.children);});var Link20=/*#__PURE__*/React.forwardRef(function Link20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.25 6.76a6 6 0 0 0-8.5 0l1.42 1.42a4 4 0 1 1 5.67 5.67l-8 8a4 4 0 1 1-5.67-5.66l1.41-1.42-1.41-1.42-1.42 1.42a6 6 0 0 0 0 8.5A6 6 0 0 0 17 25a6 6 0 0 0 4.27-1.76l8-8a6 6 0 0 0-.02-8.48z"}),React.createElement("path",{d:"M4.19 24.82a4 4 0 0 1 0-5.67l8-8a4 4 0 0 1 5.67 0A3.94 3.94 0 0 1 19 14a4 4 0 0 1-1.17 2.85L15.71 19l1.42 1.42 2.12-2.12a6 6 0 0 0-8.51-8.51l-8 8a6 6 0 0 0 0 8.51A6 6 0 0 0 7 28a6.07 6.07 0 0 0 4.28-1.76l-1.42-1.42a4 4 0 0 1-5.67 0z"}),props.children);});var Link16=/*#__PURE__*/React.forwardRef(function Link16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.25 6.76a6 6 0 0 0-8.5 0l1.42 1.42a4 4 0 1 1 5.67 5.67l-8 8a4 4 0 1 1-5.67-5.66l1.41-1.42-1.41-1.42-1.42 1.42a6 6 0 0 0 0 8.5A6 6 0 0 0 17 25a6 6 0 0 0 4.27-1.76l8-8a6 6 0 0 0-.02-8.48z"}),React.createElement("path",{d:"M4.19 24.82a4 4 0 0 1 0-5.67l8-8a4 4 0 0 1 5.67 0A3.94 3.94 0 0 1 19 14a4 4 0 0 1-1.17 2.85L15.71 19l1.42 1.42 2.12-2.12a6 6 0 0 0-8.51-8.51l-8 8a6 6 0 0 0 0 8.51A6 6 0 0 0 7 28a6.07 6.07 0 0 0 4.28-1.76l-1.42-1.42a4 4 0 0 1-5.67 0z"}),props.children);});var ListBulleted32=/*#__PURE__*/React.forwardRef(function ListBulleted32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"7",cy:"9",r:"3"}),React.createElement("circle",{cx:"7",cy:"23",r:"3"}),React.createElement("path",{d:"M16 22h14v2H16zm0-14h14v2H16z"}),props.children);});var ListBulleted24=/*#__PURE__*/React.forwardRef(function ListBulleted24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"7",cy:"9",r:"3"}),React.createElement("circle",{cx:"7",cy:"23",r:"3"}),React.createElement("path",{d:"M16 22h14v2H16zm0-14h14v2H16z"}),props.children);});var ListBulleted20=/*#__PURE__*/React.forwardRef(function ListBulleted20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"7",cy:"9",r:"3"}),React.createElement("circle",{cx:"7",cy:"23",r:"3"}),React.createElement("path",{d:"M16 22h14v2H16zm0-14h14v2H16z"}),props.children);});var ListChecked32=/*#__PURE__*/React.forwardRef(function ListChecked32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 8h14v2H16zM6 10.59L3.41 8 2 9.41l4 4 8-8L12.59 4 6 10.59zM16 22h14v2H16zM6 24.59L3.41 22 2 23.41l4 4 8-8L12.59 18 6 24.59z"}),props.children);});var ListChecked24=/*#__PURE__*/React.forwardRef(function ListChecked24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 8h14v2H16zM6 10.59L3.41 8 2 9.41l4 4 8-8L12.59 4 6 10.59zM16 22h14v2H16zM6 24.59L3.41 22 2 23.41l4 4 8-8L12.59 18 6 24.59z"}),props.children);});var ListChecked20=/*#__PURE__*/React.forwardRef(function ListChecked20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 8h14v2H16zM6 10.59L3.41 8 2 9.41l4 4 8-8L12.59 4 6 10.59zM16 22h14v2H16zM6 24.59L3.41 22 2 23.41l4 4 8-8L12.59 18 6 24.59z"}),props.children);});var ListChecked16=/*#__PURE__*/React.forwardRef(function ListChecked16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 8h14v2H16zM6 10.59L3.41 8 2 9.41l4 4 8-8L12.59 4 6 10.59zM16 22h14v2H16zM6 24.59L3.41 22 2 23.41l4 4 8-8L12.59 18 6 24.59z"}),props.children);});var ListDropdown32=/*#__PURE__*/React.forwardRef(function ListDropdown32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 6V2H2v10h9v18h19V6zM4 10V4h20v2H11v4zm24 18H13V8h15z"}),React.createElement("path",{d:"M15 11h2v2h-2zm4 0h7v2h-7zm-4 6h2v2h-2zm4 0h7v2h-7zm-4 6h2v2h-2zm4 0h7v2h-7z"}),props.children);});var ListDropdown24=/*#__PURE__*/React.forwardRef(function ListDropdown24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 6V2H2v10h9v18h19V6zM4 10V4h20v2H11v4zm24 18H13V8h15z"}),React.createElement("path",{d:"M15 11h2v2h-2zm4 0h7v2h-7zm-4 6h2v2h-2zm4 0h7v2h-7zm-4 6h2v2h-2zm4 0h7v2h-7z"}),props.children);});var ListDropdown20=/*#__PURE__*/React.forwardRef(function ListDropdown20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 6V2H2v10h9v18h19V6zM4 10V4h20v2H11v4zm24 18H13V8h15z"}),React.createElement("path",{d:"M15 11h2v2h-2zm4 0h7v2h-7zm-4 6h2v2h-2zm4 0h7v2h-7zm-4 6h2v2h-2zm4 0h7v2h-7z"}),props.children);});var ListDropdown16=/*#__PURE__*/React.forwardRef(function ListDropdown16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 6V2H2v10h9v18h19V6zM4 10V4h20v2H11v4zm24 18H13V8h15z"}),React.createElement("path",{d:"M15 11h2v2h-2zm4 0h7v2h-7zm-4 6h2v2h-2zm4 0h7v2h-7zm-4 6h2v2h-2zm4 0h7v2h-7z"}),props.children);});var ListNumbered32=/*#__PURE__*/React.forwardRef(function ListNumbered32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 22h14v2H16zm0-14h14v2H16zm-8 4V4H6v1H4v2h2v5H4v2h6v-2H8zm2 16H4v-4a2 2 0 0 1 2-2h2v-2H4v-2h4a2 2 0 0 1 2 2v2a2 2 0 0 1-2 2H6v2h4z"}),props.children);});var ListNumbered24=/*#__PURE__*/React.forwardRef(function ListNumbered24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 22h14v2H16zm0-14h14v2H16zm-8 4V4H6v1H4v2h2v5H4v2h6v-2H8zm2 16H4v-4a2 2 0 0 1 2-2h2v-2H4v-2h4a2 2 0 0 1 2 2v2a2 2 0 0 1-2 2H6v2h4z"}),props.children);});var ListNumbered20=/*#__PURE__*/React.forwardRef(function ListNumbered20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 22h14v2H16zm0-14h14v2H16zm-8 4V4H6v1H4v2h2v5H4v2h6v-2H8zm2 16H4v-4a2 2 0 0 1 2-2h2v-2H4v-2h4a2 2 0 0 1 2 2v2a2 2 0 0 1-2 2H6v2h4z"}),props.children);});var ListNumbered16=/*#__PURE__*/React.forwardRef(function ListNumbered16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 22h14v2H16zm0-14h14v2H16zm-8 4V4H6v1H4v2h2v5H4v2h6v-2H8zm2 16H4v-4a2 2 0 0 1 2-2h2v-2H4v-2h4a2 2 0 0 1 2 2v2a2 2 0 0 1-2 2H6v2h4z"}),props.children);});var List32=/*#__PURE__*/React.forwardRef(function List32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 6h18v2H10zm0 18h18v2H10zm0-9h18v2H10zm-6 0h2v2H4zm0-9h2v2H4zm0 18h2v2H4z"}),props.children);});var List24=/*#__PURE__*/React.forwardRef(function List24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 6h18v2H10zm0 18h18v2H10zm0-9h18v2H10zm-6 0h2v2H4zm0-9h2v2H4zm0 18h2v2H4z"}),props.children);});var List20=/*#__PURE__*/React.forwardRef(function List20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 6h18v2H10zm0 18h18v2H10zm0-9h18v2H10zm-6 0h2v2H4zm0-9h2v2H4zm0 18h2v2H4z"}),props.children);});var List16=/*#__PURE__*/React.forwardRef(function List16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 6h18v2H10zm0 18h18v2H10zm0-9h18v2H10zm-6 0h2v2H4zm0-9h2v2H4zm0 18h2v2H4z"}),props.children);});var Location32=/*#__PURE__*/React.forwardRef(function Location32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 10a3 3 0 1 1-3 3 3 3 0 0 1 3-3m0-2a5 5 0 1 0 5 5 5 5 0 0 0-5-5z"}),React.createElement("path",{d:"M16 4a8.88 8.88 0 0 1 9 8.71 8.47 8.47 0 0 1-1.79 5.21L16 28.46 8.85 18A8.47 8.47 0 0 1 7 12.71 8.88 8.88 0 0 1 16 4m0-2A10.86 10.86 0 0 0 5 12.71a10.53 10.53 0 0 0 2.2 6.43L16 32l8.8-12.86a10.53 10.53 0 0 0 2.2-6.43A10.86 10.86 0 0 0 16 2z"}),props.children);});var Location24=/*#__PURE__*/React.forwardRef(function Location24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 10a3 3 0 1 1-3 3 3 3 0 0 1 3-3m0-2a5 5 0 1 0 5 5 5 5 0 0 0-5-5z"}),React.createElement("path",{d:"M16 4a8.88 8.88 0 0 1 9 8.71 8.47 8.47 0 0 1-1.79 5.21L16 28.46 8.85 18A8.47 8.47 0 0 1 7 12.71 8.88 8.88 0 0 1 16 4m0-2A10.86 10.86 0 0 0 5 12.71a10.53 10.53 0 0 0 2.2 6.43L16 32l8.8-12.86a10.53 10.53 0 0 0 2.2-6.43A10.86 10.86 0 0 0 16 2z"}),props.children);});var Location20=/*#__PURE__*/React.forwardRef(function Location20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 10a3 3 0 1 1-3 3 3 3 0 0 1 3-3m0-2a5 5 0 1 0 5 5 5 5 0 0 0-5-5z"}),React.createElement("path",{d:"M16 4a8.88 8.88 0 0 1 9 8.71 8.47 8.47 0 0 1-1.79 5.21L16 28.46 8.85 18A8.47 8.47 0 0 1 7 12.71 8.88 8.88 0 0 1 16 4m0-2A10.86 10.86 0 0 0 5 12.71a10.53 10.53 0 0 0 2.2 6.43L16 32l8.8-12.86a10.53 10.53 0 0 0 2.2-6.43A10.86 10.86 0 0 0 16 2z"}),props.children);});var Location16=/*#__PURE__*/React.forwardRef(function Location16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 10a3 3 0 1 1-3 3 3 3 0 0 1 3-3m0-2a5 5 0 1 0 5 5 5 5 0 0 0-5-5z"}),React.createElement("path",{d:"M16 4a8.88 8.88 0 0 1 9 8.71 8.47 8.47 0 0 1-1.79 5.21L16 28.46 8.85 18A8.47 8.47 0 0 1 7 12.71 8.88 8.88 0 0 1 16 4m0-2A10.86 10.86 0 0 0 5 12.71a10.53 10.53 0 0 0 2.2 6.43L16 32l8.8-12.86a10.53 10.53 0 0 0 2.2-6.43A10.86 10.86 0 0 0 16 2z"}),props.children);});var Locked32=/*#__PURE__*/React.forwardRef(function Locked32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 14h-2V8a6 6 0 0 0-12 0v6H8a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V16a2 2 0 0 0-2-2zM12 8a4 4 0 0 1 8 0v6h-8zm12 20H8V16h16z"}),props.children);});var Locked24=/*#__PURE__*/React.forwardRef(function Locked24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 14h-2V8a6 6 0 0 0-12 0v6H8a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V16a2 2 0 0 0-2-2zM12 8a4 4 0 0 1 8 0v6h-8zm12 20H8V16h16z"}),props.children);});var Locked20=/*#__PURE__*/React.forwardRef(function Locked20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 14h-2V8a6 6 0 0 0-12 0v6H8a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V16a2 2 0 0 0-2-2zM12 8a4 4 0 0 1 8 0v6h-8zm12 20H8V16h16z"}),props.children);});var Login32=/*#__PURE__*/React.forwardRef(function Login32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 30H14a2 2 0 0 1-2-2v-3h2v3h12V4H14v3h-2V4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v24a2 2 0 0 1-2 2z"}),React.createElement("path",{d:"M14.59 20.59L18.17 17H4v-2h14.17l-3.58-3.59L16 10l6 6-6 6-1.41-1.41z"}),props.children);});var Login24=/*#__PURE__*/React.forwardRef(function Login24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 30H14a2 2 0 0 1-2-2v-3h2v3h12V4H14v3h-2V4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v24a2 2 0 0 1-2 2z"}),React.createElement("path",{d:"M14.59 20.59L18.17 17H4v-2h14.17l-3.58-3.59L16 10l6 6-6 6-1.41-1.41z"}),props.children);});var Login20=/*#__PURE__*/React.forwardRef(function Login20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 30H14a2 2 0 0 1-2-2v-3h2v3h12V4H14v3h-2V4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v24a2 2 0 0 1-2 2z"}),React.createElement("path",{d:"M14.59 20.59L18.17 17H4v-2h14.17l-3.58-3.59L16 10l6 6-6 6-1.41-1.41z"}),props.children);});var Login16=/*#__PURE__*/React.forwardRef(function Login16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 30H14a2 2 0 0 1-2-2v-3h2v3h12V4H14v3h-2V4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v24a2 2 0 0 1-2 2z"}),React.createElement("path",{d:"M14.59 20.59L18.17 17H4v-2h14.17l-3.58-3.59L16 10l6 6-6 6-1.41-1.41z"}),props.children);});var LogoDelicious32=/*#__PURE__*/React.forwardRef(function LogoDelicious32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4 16h12v12H4zM16 4h12v12H16z"}),props.children);});var LogoDelicious24=/*#__PURE__*/React.forwardRef(function LogoDelicious24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4 16h12v12H4zM16 4h12v12H16z"}),props.children);});var LogoDelicious20=/*#__PURE__*/React.forwardRef(function LogoDelicious20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4 16h12v12H4zM16 4h12v12H16z"}),props.children);});var LogoDelicious16=/*#__PURE__*/React.forwardRef(function LogoDelicious16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4 16h12v12H4zM16 4h12v12H16z"}),props.children);});var LogoDigg32=/*#__PURE__*/React.forwardRef(function LogoDigg32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6.48 7.6v3.92H2V21h7.28V7.6zm0 11.2H4.8v-5h1.68zm3.92-7.28h2.8v9.52h-2.8zm0-3.92h2.8v2.8h-2.8zm3.92 3.92V21h4.48v1.12h-4.48v2.28h7.28V11.52zm4.48 7.28h-1.68v-5h1.68zm3.92-7.28V21h4.48v1.12h-4.48v2.28H30V11.52zm4.48 7.28h-1.68v-5h1.68z"}),props.children);});var LogoDigg24=/*#__PURE__*/React.forwardRef(function LogoDigg24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6.48 7.6v3.92H2V21h7.28V7.6zm0 11.2H4.8v-5h1.68zm3.92-7.28h2.8v9.52h-2.8zm0-3.92h2.8v2.8h-2.8zm3.92 3.92V21h4.48v1.12h-4.48v2.28h7.28V11.52zm4.48 7.28h-1.68v-5h1.68zm3.92-7.28V21h4.48v1.12h-4.48v2.28H30V11.52zm4.48 7.28h-1.68v-5h1.68z"}),props.children);});var LogoDigg20=/*#__PURE__*/React.forwardRef(function LogoDigg20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6.48 7.6v3.92H2V21h7.28V7.6zm0 11.2H4.8v-5h1.68zm3.92-7.28h2.8v9.52h-2.8zm0-3.92h2.8v2.8h-2.8zm3.92 3.92V21h4.48v1.12h-4.48v2.28h7.28V11.52zm4.48 7.28h-1.68v-5h1.68zm3.92-7.28V21h4.48v1.12h-4.48v2.28H30V11.52zm4.48 7.28h-1.68v-5h1.68z"}),props.children);});var LogoDigg16=/*#__PURE__*/React.forwardRef(function LogoDigg16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6.48 7.6v3.92H2V21h7.28V7.6zm0 11.2H4.8v-5h1.68zm3.92-7.28h2.8v9.52h-2.8zm0-3.92h2.8v2.8h-2.8zm3.92 3.92V21h4.48v1.12h-4.48v2.28h7.28V11.52zm4.48 7.28h-1.68v-5h1.68zm3.92-7.28V21h4.48v1.12h-4.48v2.28H30V11.52zm4.48 7.28h-1.68v-5h1.68z"}),props.children);});var LogoFacebook32=/*#__PURE__*/React.forwardRef(function LogoFacebook32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26.67 4H5.33A1.34 1.34 0 0 0 4 5.33v21.34A1.34 1.34 0 0 0 5.33 28h11.49v-9.28H13.7v-3.63h3.12v-2.67c0-3.1 1.89-4.79 4.67-4.79.93 0 1.86 0 2.79.14V11h-1.91c-1.51 0-1.8.72-1.8 1.77v2.31h3.6l-.47 3.63h-3.13V28h6.1A1.34 1.34 0 0 0 28 26.67V5.33A1.34 1.34 0 0 0 26.67 4z"}),props.children);});var LogoFacebook24=/*#__PURE__*/React.forwardRef(function LogoFacebook24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26.67 4H5.33A1.34 1.34 0 0 0 4 5.33v21.34A1.34 1.34 0 0 0 5.33 28h11.49v-9.28H13.7v-3.63h3.12v-2.67c0-3.1 1.89-4.79 4.67-4.79.93 0 1.86 0 2.79.14V11h-1.91c-1.51 0-1.8.72-1.8 1.77v2.31h3.6l-.47 3.63h-3.13V28h6.1A1.34 1.34 0 0 0 28 26.67V5.33A1.34 1.34 0 0 0 26.67 4z"}),props.children);});var LogoFacebook20=/*#__PURE__*/React.forwardRef(function LogoFacebook20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26.67 4H5.33A1.34 1.34 0 0 0 4 5.33v21.34A1.34 1.34 0 0 0 5.33 28h11.49v-9.28H13.7v-3.63h3.12v-2.67c0-3.1 1.89-4.79 4.67-4.79.93 0 1.86 0 2.79.14V11h-1.91c-1.51 0-1.8.72-1.8 1.77v2.31h3.6l-.47 3.63h-3.13V28h6.1A1.34 1.34 0 0 0 28 26.67V5.33A1.34 1.34 0 0 0 26.67 4z"}),props.children);});var LogoFacebook16=/*#__PURE__*/React.forwardRef(function LogoFacebook16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26.67 4H5.33A1.34 1.34 0 0 0 4 5.33v21.34A1.34 1.34 0 0 0 5.33 28h11.49v-9.28H13.7v-3.63h3.12v-2.67c0-3.1 1.89-4.79 4.67-4.79.93 0 1.86 0 2.79.14V11h-1.91c-1.51 0-1.8.72-1.8 1.77v2.31h3.6l-.47 3.63h-3.13V28h6.1A1.34 1.34 0 0 0 28 26.67V5.33A1.34 1.34 0 0 0 26.67 4z"}),props.children);});var LogoFlickr32=/*#__PURE__*/React.forwardRef(function LogoFlickr32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"8",cy:"16",r:"6"}),React.createElement("circle",{cx:"24",cy:"16",r:"6"}),props.children);});var LogoFlickr24=/*#__PURE__*/React.forwardRef(function LogoFlickr24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"8",cy:"16",r:"6"}),React.createElement("circle",{cx:"24",cy:"16",r:"6"}),props.children);});var LogoFlickr20=/*#__PURE__*/React.forwardRef(function LogoFlickr20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"8",cy:"16",r:"6"}),React.createElement("circle",{cx:"24",cy:"16",r:"6"}),props.children);});var LogoFlickr16=/*#__PURE__*/React.forwardRef(function LogoFlickr16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"8",cy:"16",r:"6"}),React.createElement("circle",{cx:"24",cy:"16",r:"6"}),props.children);});var LogoGithub32=/*#__PURE__*/React.forwardRef(function LogoGithub32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{fillRule:"evenodd",d:"M16 2a14 14 0 0 0-4.43 27.28c.7.13 1-.3 1-.67v-2.38c-3.89.84-4.71-1.88-4.71-1.88a3.71 3.71 0 0 0-1.62-2.05c-1.27-.86.1-.85.1-.85a2.94 2.94 0 0 1 2.14 1.45 3 3 0 0 0 4.08 1.16 2.93 2.93 0 0 1 .88-1.87c-3.1-.36-6.37-1.56-6.37-6.92a5.4 5.4 0 0 1 1.44-3.76 5 5 0 0 1 .14-3.7s1.17-.38 3.85 1.43a13.3 13.3 0 0 1 7 0c2.67-1.81 3.84-1.43 3.84-1.43a5 5 0 0 1 .14 3.7 5.4 5.4 0 0 1 1.44 3.76c0 5.38-3.27 6.56-6.39 6.91a3.33 3.33 0 0 1 .95 2.59v3.84c0 .46.25.81 1 .67A14 14 0 0 0 16 2z"}),props.children);});var LogoGithub24=/*#__PURE__*/React.forwardRef(function LogoGithub24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{fillRule:"evenodd",d:"M16 2a14 14 0 0 0-4.43 27.28c.7.13 1-.3 1-.67v-2.38c-3.89.84-4.71-1.88-4.71-1.88a3.71 3.71 0 0 0-1.62-2.05c-1.27-.86.1-.85.1-.85a2.94 2.94 0 0 1 2.14 1.45 3 3 0 0 0 4.08 1.16 2.93 2.93 0 0 1 .88-1.87c-3.1-.36-6.37-1.56-6.37-6.92a5.4 5.4 0 0 1 1.44-3.76 5 5 0 0 1 .14-3.7s1.17-.38 3.85 1.43a13.3 13.3 0 0 1 7 0c2.67-1.81 3.84-1.43 3.84-1.43a5 5 0 0 1 .14 3.7 5.4 5.4 0 0 1 1.44 3.76c0 5.38-3.27 6.56-6.39 6.91a3.33 3.33 0 0 1 .95 2.59v3.84c0 .46.25.81 1 .67A14 14 0 0 0 16 2z"}),props.children);});var LogoGithub20=/*#__PURE__*/React.forwardRef(function LogoGithub20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{fillRule:"evenodd",d:"M16 2a14 14 0 0 0-4.43 27.28c.7.13 1-.3 1-.67v-2.38c-3.89.84-4.71-1.88-4.71-1.88a3.71 3.71 0 0 0-1.62-2.05c-1.27-.86.1-.85.1-.85a2.94 2.94 0 0 1 2.14 1.45 3 3 0 0 0 4.08 1.16 2.93 2.93 0 0 1 .88-1.87c-3.1-.36-6.37-1.56-6.37-6.92a5.4 5.4 0 0 1 1.44-3.76 5 5 0 0 1 .14-3.7s1.17-.38 3.85 1.43a13.3 13.3 0 0 1 7 0c2.67-1.81 3.84-1.43 3.84-1.43a5 5 0 0 1 .14 3.7 5.4 5.4 0 0 1 1.44 3.76c0 5.38-3.27 6.56-6.39 6.91a3.33 3.33 0 0 1 .95 2.59v3.84c0 .46.25.81 1 .67A14 14 0 0 0 16 2z"}),props.children);});var LogoGithub16=/*#__PURE__*/React.forwardRef(function LogoGithub16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{fillRule:"evenodd",d:"M16 2a14 14 0 0 0-4.43 27.28c.7.13 1-.3 1-.67v-2.38c-3.89.84-4.71-1.88-4.71-1.88a3.71 3.71 0 0 0-1.62-2.05c-1.27-.86.1-.85.1-.85a2.94 2.94 0 0 1 2.14 1.45 3 3 0 0 0 4.08 1.16 2.93 2.93 0 0 1 .88-1.87c-3.1-.36-6.37-1.56-6.37-6.92a5.4 5.4 0 0 1 1.44-3.76 5 5 0 0 1 .14-3.7s1.17-.38 3.85 1.43a13.3 13.3 0 0 1 7 0c2.67-1.81 3.84-1.43 3.84-1.43a5 5 0 0 1 .14 3.7 5.4 5.4 0 0 1 1.44 3.76c0 5.38-3.27 6.56-6.39 6.91a3.33 3.33 0 0 1 .95 2.59v3.84c0 .46.25.81 1 .67A14 14 0 0 0 16 2z"}),props.children);});var LogoGoogle32=/*#__PURE__*/React.forwardRef(function LogoGoogle32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.39 13.82H16.21v4.63h6.44c-.6 2.95-3.11 4.64-6.44 4.64a7.09 7.09 0 0 1 0-14.18 7 7 0 0 1 4.42 1.58L24.12 7a12 12 0 1 0-7.91 21c6 0 11.45-4.36 11.45-12a9.56 9.56 0 0 0-.27-2.18z"}),props.children);});var LogoGoogle24=/*#__PURE__*/React.forwardRef(function LogoGoogle24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.39 13.82H16.21v4.63h6.44c-.6 2.95-3.11 4.64-6.44 4.64a7.09 7.09 0 0 1 0-14.18 7 7 0 0 1 4.42 1.58L24.12 7a12 12 0 1 0-7.91 21c6 0 11.45-4.36 11.45-12a9.56 9.56 0 0 0-.27-2.18z"}),props.children);});var LogoGoogle20=/*#__PURE__*/React.forwardRef(function LogoGoogle20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.39 13.82H16.21v4.63h6.44c-.6 2.95-3.11 4.64-6.44 4.64a7.09 7.09 0 0 1 0-14.18 7 7 0 0 1 4.42 1.58L24.12 7a12 12 0 1 0-7.91 21c6 0 11.45-4.36 11.45-12a9.56 9.56 0 0 0-.27-2.18z"}),props.children);});var LogoGoogle16=/*#__PURE__*/React.forwardRef(function LogoGoogle16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.39 13.82H16.21v4.63h6.44c-.6 2.95-3.11 4.64-6.44 4.64a7.09 7.09 0 0 1 0-14.18 7 7 0 0 1 4.42 1.58L24.12 7a12 12 0 1 0-7.91 21c6 0 11.45-4.36 11.45-12a9.56 9.56 0 0 0-.27-2.18z"}),props.children);});var LogoLinkedin32=/*#__PURE__*/React.forwardRef(function LogoLinkedin32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26.21 4H5.79A1.78 1.78 0 0 0 4 5.73V26.2a1.77 1.77 0 0 0 1.79 1.73h20.42A1.77 1.77 0 0 0 28 26.2V5.73A1.78 1.78 0 0 0 26.21 4zm-15.1 20.41H7.59V13h3.52zm-1.72-13a2.07 2.07 0 0 1-2.07-2.02 2 2 0 0 1 2.07-2.07 2.07 2.07 0 0 1 0 4.13zm15.09 12.93H21v-5.58c0-1.33 0-3.06-1.86-3.06S17 17.16 17 18.63v5.65h-3.56V13h3.32v1.5h.07a3.72 3.72 0 0 1 3.39-1.86c3.59 0 4.26 2.4 4.26 5.45z"}),props.children);});var LogoLinkedin24=/*#__PURE__*/React.forwardRef(function LogoLinkedin24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26.21 4H5.79A1.78 1.78 0 0 0 4 5.73V26.2a1.77 1.77 0 0 0 1.79 1.73h20.42A1.77 1.77 0 0 0 28 26.2V5.73A1.78 1.78 0 0 0 26.21 4zm-15.1 20.41H7.59V13h3.52zm-1.72-13a2.07 2.07 0 0 1-2.07-2.02 2 2 0 0 1 2.07-2.07 2.07 2.07 0 0 1 0 4.13zm15.09 12.93H21v-5.58c0-1.33 0-3.06-1.86-3.06S17 17.16 17 18.63v5.65h-3.56V13h3.32v1.5h.07a3.72 3.72 0 0 1 3.39-1.86c3.59 0 4.26 2.4 4.26 5.45z"}),props.children);});var LogoLinkedin20=/*#__PURE__*/React.forwardRef(function LogoLinkedin20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26.21 4H5.79A1.78 1.78 0 0 0 4 5.73V26.2a1.77 1.77 0 0 0 1.79 1.73h20.42A1.77 1.77 0 0 0 28 26.2V5.73A1.78 1.78 0 0 0 26.21 4zm-15.1 20.41H7.59V13h3.52zm-1.72-13a2.07 2.07 0 0 1-2.07-2.02 2 2 0 0 1 2.07-2.07 2.07 2.07 0 0 1 0 4.13zm15.09 12.93H21v-5.58c0-1.33 0-3.06-1.86-3.06S17 17.16 17 18.63v5.65h-3.56V13h3.32v1.5h.07a3.72 3.72 0 0 1 3.39-1.86c3.59 0 4.26 2.4 4.26 5.45z"}),props.children);});var LogoLinkedin16=/*#__PURE__*/React.forwardRef(function LogoLinkedin16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26.21 4H5.79A1.78 1.78 0 0 0 4 5.73V26.2a1.77 1.77 0 0 0 1.79 1.73h20.42A1.77 1.77 0 0 0 28 26.2V5.73A1.78 1.78 0 0 0 26.21 4zm-15.1 20.41H7.59V13h3.52zm-1.72-13a2.07 2.07 0 0 1-2.07-2.02 2 2 0 0 1 2.07-2.07 2.07 2.07 0 0 1 0 4.13zm15.09 12.93H21v-5.58c0-1.33 0-3.06-1.86-3.06S17 17.16 17 18.63v5.65h-3.56V13h3.32v1.5h.07a3.72 3.72 0 0 1 3.39-1.86c3.59 0 4.26 2.4 4.26 5.45z"}),props.children);});var LogoLivestream32=/*#__PURE__*/React.forwardRef(function LogoLivestream32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22.49 23.71h-7.54a3.12 3.12 0 0 1-2.41-1A14.91 14.91 0 0 1 10 18.88c-1.3-2.6-2.54-5.22-3.82-7.82-.39-.8-.82-1.56-1.28-2.32A7.84 7.84 0 0 0 2 5.6h3.57a45.63 45.63 0 0 1 7 .61 8.09 8.09 0 0 1 6.34 5.09 48.51 48.51 0 0 1 2.17 7.36 26 26 0 0 0 1.41 5.05zm5.61 2.67a2.93 2.93 0 0 1-2.74-2.64 42.08 42.08 0 0 1-.14-4.9 48 48 0 0 0-.61-7.58 3.75 3.75 0 0 0-.83-2h2.65c.54 0 .73.37.89.78a12.1 12.1 0 0 1 .68 3.24c.29 2.72.31 5.45.33 8.18a10.94 10.94 0 0 0 0 1.15c.09.78.4 1.1 1.17 1.08.5 0 .5-.06.5-.06v2.69a8.62 8.62 0 0 1-1.9.06z"}),props.children);});var LogoLivestream24=/*#__PURE__*/React.forwardRef(function LogoLivestream24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22.49 23.71h-7.54a3.12 3.12 0 0 1-2.41-1A14.91 14.91 0 0 1 10 18.88c-1.3-2.6-2.54-5.22-3.82-7.82-.39-.8-.82-1.56-1.28-2.32A7.84 7.84 0 0 0 2 5.6h3.57a45.63 45.63 0 0 1 7 .61 8.09 8.09 0 0 1 6.34 5.09 48.51 48.51 0 0 1 2.17 7.36 26 26 0 0 0 1.41 5.05zm5.61 2.67a2.93 2.93 0 0 1-2.74-2.64 42.08 42.08 0 0 1-.14-4.9 48 48 0 0 0-.61-7.58 3.75 3.75 0 0 0-.83-2h2.65c.54 0 .73.37.89.78a12.1 12.1 0 0 1 .68 3.24c.29 2.72.31 5.45.33 8.18a10.94 10.94 0 0 0 0 1.15c.09.78.4 1.1 1.17 1.08.5 0 .5-.06.5-.06v2.69a8.62 8.62 0 0 1-1.9.06z"}),props.children);});var LogoLivestream20=/*#__PURE__*/React.forwardRef(function LogoLivestream20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22.49 23.71h-7.54a3.12 3.12 0 0 1-2.41-1A14.91 14.91 0 0 1 10 18.88c-1.3-2.6-2.54-5.22-3.82-7.82-.39-.8-.82-1.56-1.28-2.32A7.84 7.84 0 0 0 2 5.6h3.57a45.63 45.63 0 0 1 7 .61 8.09 8.09 0 0 1 6.34 5.09 48.51 48.51 0 0 1 2.17 7.36 26 26 0 0 0 1.41 5.05zm5.61 2.67a2.93 2.93 0 0 1-2.74-2.64 42.08 42.08 0 0 1-.14-4.9 48 48 0 0 0-.61-7.58 3.75 3.75 0 0 0-.83-2h2.65c.54 0 .73.37.89.78a12.1 12.1 0 0 1 .68 3.24c.29 2.72.31 5.45.33 8.18a10.94 10.94 0 0 0 0 1.15c.09.78.4 1.1 1.17 1.08.5 0 .5-.06.5-.06v2.69a8.62 8.62 0 0 1-1.9.06z"}),props.children);});var LogoLivestream16=/*#__PURE__*/React.forwardRef(function LogoLivestream16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22.49 23.71h-7.54a3.12 3.12 0 0 1-2.41-1A14.91 14.91 0 0 1 10 18.88c-1.3-2.6-2.54-5.22-3.82-7.82-.39-.8-.82-1.56-1.28-2.32A7.84 7.84 0 0 0 2 5.6h3.57a45.63 45.63 0 0 1 7 .61 8.09 8.09 0 0 1 6.34 5.09 48.51 48.51 0 0 1 2.17 7.36 26 26 0 0 0 1.41 5.05zm5.61 2.67a2.93 2.93 0 0 1-2.74-2.64 42.08 42.08 0 0 1-.14-4.9 48 48 0 0 0-.61-7.58 3.75 3.75 0 0 0-.83-2h2.65c.54 0 .73.37.89.78a12.1 12.1 0 0 1 .68 3.24c.29 2.72.31 5.45.33 8.18a10.94 10.94 0 0 0 0 1.15c.09.78.4 1.1 1.17 1.08.5 0 .5-.06.5-.06v2.69a8.62 8.62 0 0 1-1.9.06z"}),props.children);});var LogoPinterest32=/*#__PURE__*/React.forwardRef(function LogoPinterest32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 0 0-5.1 27 13.24 13.24 0 0 1 0-4l1.65-7a5.05 5.05 0 0 1-.38-2c0-1.94 1.13-3.4 2.53-3.4a1.76 1.76 0 0 1 1.77 2c0 1.2-.76 3-1.16 4.66a2 2 0 0 0 2.08 2.53c2.48 0 4.4-2.63 4.4-6.41a5.53 5.53 0 0 0-5.85-5.7 6.06 6.06 0 0 0-6.32 6.08 5.42 5.42 0 0 0 1 3.19.44.44 0 0 1 .1.4c-.11.44-.35 1.4-.39 1.59s-.21.31-.47.19c-1.75-.82-2.84-3.37-2.84-5.43 0-4.41 3.21-8.47 9.25-8.47 4.85 0 8.63 3.46 8.63 8.09 0 4.82-3 8.7-7.27 8.7a3.76 3.76 0 0 1-3.21-1.6l-.87 3.33a15.55 15.55 0 0 1-1.74 3.67A14.17 14.17 0 0 0 16 30a14 14 0 0 0 0-28"}),props.children);});var LogoPinterest24=/*#__PURE__*/React.forwardRef(function LogoPinterest24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 0 0-5.1 27 13.24 13.24 0 0 1 0-4l1.65-7a5.05 5.05 0 0 1-.38-2c0-1.94 1.13-3.4 2.53-3.4a1.76 1.76 0 0 1 1.77 2c0 1.2-.76 3-1.16 4.66a2 2 0 0 0 2.08 2.53c2.48 0 4.4-2.63 4.4-6.41a5.53 5.53 0 0 0-5.85-5.7 6.06 6.06 0 0 0-6.32 6.08 5.42 5.42 0 0 0 1 3.19.44.44 0 0 1 .1.4c-.11.44-.35 1.4-.39 1.59s-.21.31-.47.19c-1.75-.82-2.84-3.37-2.84-5.43 0-4.41 3.21-8.47 9.25-8.47 4.85 0 8.63 3.46 8.63 8.09 0 4.82-3 8.7-7.27 8.7a3.76 3.76 0 0 1-3.21-1.6l-.87 3.33a15.55 15.55 0 0 1-1.74 3.67A14.17 14.17 0 0 0 16 30a14 14 0 0 0 0-28"}),props.children);});var LogoPinterest20=/*#__PURE__*/React.forwardRef(function LogoPinterest20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 0 0-5.1 27 13.24 13.24 0 0 1 0-4l1.65-7a5.05 5.05 0 0 1-.38-2c0-1.94 1.13-3.4 2.53-3.4a1.76 1.76 0 0 1 1.77 2c0 1.2-.76 3-1.16 4.66a2 2 0 0 0 2.08 2.53c2.48 0 4.4-2.63 4.4-6.41a5.53 5.53 0 0 0-5.85-5.7 6.06 6.06 0 0 0-6.32 6.08 5.42 5.42 0 0 0 1 3.19.44.44 0 0 1 .1.4c-.11.44-.35 1.4-.39 1.59s-.21.31-.47.19c-1.75-.82-2.84-3.37-2.84-5.43 0-4.41 3.21-8.47 9.25-8.47 4.85 0 8.63 3.46 8.63 8.09 0 4.82-3 8.7-7.27 8.7a3.76 3.76 0 0 1-3.21-1.6l-.87 3.33a15.55 15.55 0 0 1-1.74 3.67A14.17 14.17 0 0 0 16 30a14 14 0 0 0 0-28"}),props.children);});var LogoPinterest16=/*#__PURE__*/React.forwardRef(function LogoPinterest16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 0 0-5.1 27 13.24 13.24 0 0 1 0-4l1.65-7a5.05 5.05 0 0 1-.38-2c0-1.94 1.13-3.4 2.53-3.4a1.76 1.76 0 0 1 1.77 2c0 1.2-.76 3-1.16 4.66a2 2 0 0 0 2.08 2.53c2.48 0 4.4-2.63 4.4-6.41a5.53 5.53 0 0 0-5.85-5.7 6.06 6.06 0 0 0-6.32 6.08 5.42 5.42 0 0 0 1 3.19.44.44 0 0 1 .1.4c-.11.44-.35 1.4-.39 1.59s-.21.31-.47.19c-1.75-.82-2.84-3.37-2.84-5.43 0-4.41 3.21-8.47 9.25-8.47 4.85 0 8.63 3.46 8.63 8.09 0 4.82-3 8.7-7.27 8.7a3.76 3.76 0 0 1-3.21-1.6l-.87 3.33a15.55 15.55 0 0 1-1.74 3.67A14.17 14.17 0 0 0 16 30a14 14 0 0 0 0-28"}),props.children);});var LogoQuora32=/*#__PURE__*/React.forwardRef(function LogoQuora32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29 23.86h-2a1.72 1.72 0 0 1-1.73 1.72c-1.15 0-1.82-.86-2.58-2a11 11 0 0 0 4.79-9.1c.09-7.19-5.85-11.89-12.17-11.89S3 7.37 3 14.37s6 11.79 12.17 11.79a10.71 10.71 0 0 0 3.07-.48c1.15 2.11 2.59 3.74 5.46 3.74a5 5 0 0 0 5.3-5.56zm-8.14-3.45a6.31 6.31 0 0 0-5.56-3.16 6 6 0 0 0-3.74 1.15l.64 1.6a2.56 2.56 0 0 1 .86-.1c1.82 0 3 1.53 4.12 3.64a7.58 7.58 0 0 1-1.91.19C10.86 23.76 9 20.6 9 14.47s1.91-9.3 6.23-9.3 6.32 3.16 6.32 9.3a20.68 20.68 0 0 1-.72 5.94z"}),props.children);});var LogoQuora24=/*#__PURE__*/React.forwardRef(function LogoQuora24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29 23.86h-2a1.72 1.72 0 0 1-1.73 1.72c-1.15 0-1.82-.86-2.58-2a11 11 0 0 0 4.79-9.1c.09-7.19-5.85-11.89-12.17-11.89S3 7.37 3 14.37s6 11.79 12.17 11.79a10.71 10.71 0 0 0 3.07-.48c1.15 2.11 2.59 3.74 5.46 3.74a5 5 0 0 0 5.3-5.56zm-8.14-3.45a6.31 6.31 0 0 0-5.56-3.16 6 6 0 0 0-3.74 1.15l.64 1.6a2.56 2.56 0 0 1 .86-.1c1.82 0 3 1.53 4.12 3.64a7.58 7.58 0 0 1-1.91.19C10.86 23.76 9 20.6 9 14.47s1.91-9.3 6.23-9.3 6.32 3.16 6.32 9.3a20.68 20.68 0 0 1-.72 5.94z"}),props.children);});var LogoQuora20=/*#__PURE__*/React.forwardRef(function LogoQuora20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29 23.86h-2a1.72 1.72 0 0 1-1.73 1.72c-1.15 0-1.82-.86-2.58-2a11 11 0 0 0 4.79-9.1c.09-7.19-5.85-11.89-12.17-11.89S3 7.37 3 14.37s6 11.79 12.17 11.79a10.71 10.71 0 0 0 3.07-.48c1.15 2.11 2.59 3.74 5.46 3.74a5 5 0 0 0 5.3-5.56zm-8.14-3.45a6.31 6.31 0 0 0-5.56-3.16 6 6 0 0 0-3.74 1.15l.64 1.6a2.56 2.56 0 0 1 .86-.1c1.82 0 3 1.53 4.12 3.64a7.58 7.58 0 0 1-1.91.19C10.86 23.76 9 20.6 9 14.47s1.91-9.3 6.23-9.3 6.32 3.16 6.32 9.3a20.68 20.68 0 0 1-.72 5.94z"}),props.children);});var LogoQuora16=/*#__PURE__*/React.forwardRef(function LogoQuora16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29 23.86h-2a1.72 1.72 0 0 1-1.73 1.72c-1.15 0-1.82-.86-2.58-2a11 11 0 0 0 4.79-9.1c.09-7.19-5.85-11.89-12.17-11.89S3 7.37 3 14.37s6 11.79 12.17 11.79a10.71 10.71 0 0 0 3.07-.48c1.15 2.11 2.59 3.74 5.46 3.74a5 5 0 0 0 5.3-5.56zm-8.14-3.45a6.31 6.31 0 0 0-5.56-3.16 6 6 0 0 0-3.74 1.15l.64 1.6a2.56 2.56 0 0 1 .86-.1c1.82 0 3 1.53 4.12 3.64a7.58 7.58 0 0 1-1.91.19C10.86 23.76 9 20.6 9 14.47s1.91-9.3 6.23-9.3 6.32 3.16 6.32 9.3a20.68 20.68 0 0 1-.72 5.94z"}),props.children);});var LogoSkype32=/*#__PURE__*/React.forwardRef(function LogoSkype32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.91 17.88a11.63 11.63 0 0 0 .15-1.88A12.06 12.06 0 0 0 16 3.94a11.63 11.63 0 0 0-1.88.15 7.29 7.29 0 0 0-10 10A11.63 11.63 0 0 0 3.94 16 12.06 12.06 0 0 0 16 28.06a11.63 11.63 0 0 0 1.88-.15 7.29 7.29 0 0 0 10-10zm-6.18 3.6a5 5 0 0 1-2.24 1.73 9 9 0 0 1-3.48.62A8.41 8.41 0 0 1 12 23a5.2 5.2 0 0 1-1.82-1.63 3.59 3.59 0 0 1-.7-2 1.36 1.36 0 0 1 .43-1A1.56 1.56 0 0 1 11 18a1.38 1.38 0 0 1 .91.32 2.5 2.5 0 0 1 .63.94 5.83 5.83 0 0 0 .66 1.18 2.61 2.61 0 0 0 1 .78 3.87 3.87 0 0 0 1.69.31 4 4 0 0 0 2.34-.62 1.8 1.8 0 0 0 .89-1.53 1.54 1.54 0 0 0-.47-1.17 3.09 3.09 0 0 0-1.25-.7c-.52-.17-1.21-.34-2.08-.53a16 16 0 0 1-2.91-.98 4.78 4.78 0 0 1-1.89-1.4 3.5 3.5 0 0 1-.7-2.21 3.65 3.65 0 0 1 .74-2.24 4.7 4.7 0 0 1 2.14-1.5 9.51 9.51 0 0 1 3.3-.48 8.63 8.63 0 0 1 2.59.35 5.81 5.81 0 0 1 1.83.92 3.91 3.91 0 0 1 1.06 1.21 2.62 2.62 0 0 1 .34 1.25 1.4 1.4 0 0 1-.43 1 1.43 1.43 0 0 1-1.07.46 1.25 1.25 0 0 1-.89-.28 3.36 3.36 0 0 1-.65-.87 3.79 3.79 0 0 0-1.05-1.31 3.13 3.13 0 0 0-1.95-.46 3.64 3.64 0 0 0-2 .5 1.44 1.44 0 0 0-.76 1.2 1.15 1.15 0 0 0 .25.75 2.21 2.21 0 0 0 .72.55 4.74 4.74 0 0 0 .92.36c.32.09.84.22 1.57.39.92.2 1.74.42 2.49.66a7.61 7.61 0 0 1 1.9.88 3.59 3.59 0 0 1 1.23 1.31 4 4 0 0 1 .4 1.96 4.24 4.24 0 0 1-.77 2.48z"}),props.children);});var LogoSkype24=/*#__PURE__*/React.forwardRef(function LogoSkype24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.91 17.88a11.63 11.63 0 0 0 .15-1.88A12.06 12.06 0 0 0 16 3.94a11.63 11.63 0 0 0-1.88.15 7.29 7.29 0 0 0-10 10A11.63 11.63 0 0 0 3.94 16 12.06 12.06 0 0 0 16 28.06a11.63 11.63 0 0 0 1.88-.15 7.29 7.29 0 0 0 10-10zm-6.18 3.6a5 5 0 0 1-2.24 1.73 9 9 0 0 1-3.48.62A8.41 8.41 0 0 1 12 23a5.2 5.2 0 0 1-1.82-1.63 3.59 3.59 0 0 1-.7-2 1.36 1.36 0 0 1 .43-1A1.56 1.56 0 0 1 11 18a1.38 1.38 0 0 1 .91.32 2.5 2.5 0 0 1 .63.94 5.83 5.83 0 0 0 .66 1.18 2.61 2.61 0 0 0 1 .78 3.87 3.87 0 0 0 1.69.31 4 4 0 0 0 2.34-.62 1.8 1.8 0 0 0 .89-1.53 1.54 1.54 0 0 0-.47-1.17 3.09 3.09 0 0 0-1.25-.7c-.52-.17-1.21-.34-2.08-.53a16 16 0 0 1-2.91-.98 4.78 4.78 0 0 1-1.89-1.4 3.5 3.5 0 0 1-.7-2.21 3.65 3.65 0 0 1 .74-2.24 4.7 4.7 0 0 1 2.14-1.5 9.51 9.51 0 0 1 3.3-.48 8.63 8.63 0 0 1 2.59.35 5.81 5.81 0 0 1 1.83.92 3.91 3.91 0 0 1 1.06 1.21 2.62 2.62 0 0 1 .34 1.25 1.4 1.4 0 0 1-.43 1 1.43 1.43 0 0 1-1.07.46 1.25 1.25 0 0 1-.89-.28 3.36 3.36 0 0 1-.65-.87 3.79 3.79 0 0 0-1.05-1.31 3.13 3.13 0 0 0-1.95-.46 3.64 3.64 0 0 0-2 .5 1.44 1.44 0 0 0-.76 1.2 1.15 1.15 0 0 0 .25.75 2.21 2.21 0 0 0 .72.55 4.74 4.74 0 0 0 .92.36c.32.09.84.22 1.57.39.92.2 1.74.42 2.49.66a7.61 7.61 0 0 1 1.9.88 3.59 3.59 0 0 1 1.23 1.31 4 4 0 0 1 .4 1.96 4.24 4.24 0 0 1-.77 2.48z"}),props.children);});var LogoSkype20=/*#__PURE__*/React.forwardRef(function LogoSkype20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.91 17.88a11.63 11.63 0 0 0 .15-1.88A12.06 12.06 0 0 0 16 3.94a11.63 11.63 0 0 0-1.88.15 7.29 7.29 0 0 0-10 10A11.63 11.63 0 0 0 3.94 16 12.06 12.06 0 0 0 16 28.06a11.63 11.63 0 0 0 1.88-.15 7.29 7.29 0 0 0 10-10zm-6.18 3.6a5 5 0 0 1-2.24 1.73 9 9 0 0 1-3.48.62A8.41 8.41 0 0 1 12 23a5.2 5.2 0 0 1-1.82-1.63 3.59 3.59 0 0 1-.7-2 1.36 1.36 0 0 1 .43-1A1.56 1.56 0 0 1 11 18a1.38 1.38 0 0 1 .91.32 2.5 2.5 0 0 1 .63.94 5.83 5.83 0 0 0 .66 1.18 2.61 2.61 0 0 0 1 .78 3.87 3.87 0 0 0 1.69.31 4 4 0 0 0 2.34-.62 1.8 1.8 0 0 0 .89-1.53 1.54 1.54 0 0 0-.47-1.17 3.09 3.09 0 0 0-1.25-.7c-.52-.17-1.21-.34-2.08-.53a16 16 0 0 1-2.91-.98 4.78 4.78 0 0 1-1.89-1.4 3.5 3.5 0 0 1-.7-2.21 3.65 3.65 0 0 1 .74-2.24 4.7 4.7 0 0 1 2.14-1.5 9.51 9.51 0 0 1 3.3-.48 8.63 8.63 0 0 1 2.59.35 5.81 5.81 0 0 1 1.83.92 3.91 3.91 0 0 1 1.06 1.21 2.62 2.62 0 0 1 .34 1.25 1.4 1.4 0 0 1-.43 1 1.43 1.43 0 0 1-1.07.46 1.25 1.25 0 0 1-.89-.28 3.36 3.36 0 0 1-.65-.87 3.79 3.79 0 0 0-1.05-1.31 3.13 3.13 0 0 0-1.95-.46 3.64 3.64 0 0 0-2 .5 1.44 1.44 0 0 0-.76 1.2 1.15 1.15 0 0 0 .25.75 2.21 2.21 0 0 0 .72.55 4.74 4.74 0 0 0 .92.36c.32.09.84.22 1.57.39.92.2 1.74.42 2.49.66a7.61 7.61 0 0 1 1.9.88 3.59 3.59 0 0 1 1.23 1.31 4 4 0 0 1 .4 1.96 4.24 4.24 0 0 1-.77 2.48z"}),props.children);});var LogoSkype16=/*#__PURE__*/React.forwardRef(function LogoSkype16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.91 17.88a11.63 11.63 0 0 0 .15-1.88A12.06 12.06 0 0 0 16 3.94a11.63 11.63 0 0 0-1.88.15 7.29 7.29 0 0 0-10 10A11.63 11.63 0 0 0 3.94 16 12.06 12.06 0 0 0 16 28.06a11.63 11.63 0 0 0 1.88-.15 7.29 7.29 0 0 0 10-10zm-6.18 3.6a5 5 0 0 1-2.24 1.73 9 9 0 0 1-3.48.62A8.41 8.41 0 0 1 12 23a5.2 5.2 0 0 1-1.82-1.63 3.59 3.59 0 0 1-.7-2 1.36 1.36 0 0 1 .43-1A1.56 1.56 0 0 1 11 18a1.38 1.38 0 0 1 .91.32 2.5 2.5 0 0 1 .63.94 5.83 5.83 0 0 0 .66 1.18 2.61 2.61 0 0 0 1 .78 3.87 3.87 0 0 0 1.69.31 4 4 0 0 0 2.34-.62 1.8 1.8 0 0 0 .89-1.53 1.54 1.54 0 0 0-.47-1.17 3.09 3.09 0 0 0-1.25-.7c-.52-.17-1.21-.34-2.08-.53a16 16 0 0 1-2.91-.98 4.78 4.78 0 0 1-1.89-1.4 3.5 3.5 0 0 1-.7-2.21 3.65 3.65 0 0 1 .74-2.24 4.7 4.7 0 0 1 2.14-1.5 9.51 9.51 0 0 1 3.3-.48 8.63 8.63 0 0 1 2.59.35 5.81 5.81 0 0 1 1.83.92 3.91 3.91 0 0 1 1.06 1.21 2.62 2.62 0 0 1 .34 1.25 1.4 1.4 0 0 1-.43 1 1.43 1.43 0 0 1-1.07.46 1.25 1.25 0 0 1-.89-.28 3.36 3.36 0 0 1-.65-.87 3.79 3.79 0 0 0-1.05-1.31 3.13 3.13 0 0 0-1.95-.46 3.64 3.64 0 0 0-2 .5 1.44 1.44 0 0 0-.76 1.2 1.15 1.15 0 0 0 .25.75 2.21 2.21 0 0 0 .72.55 4.74 4.74 0 0 0 .92.36c.32.09.84.22 1.57.39.92.2 1.74.42 2.49.66a7.61 7.61 0 0 1 1.9.88 3.59 3.59 0 0 1 1.23 1.31 4 4 0 0 1 .4 1.96 4.24 4.24 0 0 1-.77 2.48z"}),props.children);});var LogoSlack32=/*#__PURE__*/React.forwardRef(function LogoSlack32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M9.042 19.166a2.521 2.521 0 1 1-2.52-2.521h2.52zm1.271 0a2.521 2.521 0 0 1 5.042 0v6.313a2.521 2.521 0 1 1-5.042 0zm2.521-10.124a2.521 2.521 0 1 1 2.521-2.52v2.52zm0 1.271a2.521 2.521 0 0 1 0 5.042H6.52a2.521 2.521 0 1 1 0-5.042zm10.124 2.521a2.521 2.521 0 1 1 2.52 2.521h-2.52zm-1.271 0a2.521 2.521 0 0 1-5.042 0V6.52a2.521 2.521 0 1 1 5.042 0zm-2.521 10.124a2.521 2.521 0 1 1-2.521 2.52v-2.52zm0-1.271a2.521 2.521 0 0 1 0-5.042h6.313a2.521 2.521 0 1 1 0 5.042z"}),props.children);});var LogoSlack24=/*#__PURE__*/React.forwardRef(function LogoSlack24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M9.042 19.166a2.521 2.521 0 1 1-2.52-2.521h2.52zm1.271 0a2.521 2.521 0 0 1 5.042 0v6.313a2.521 2.521 0 1 1-5.042 0zm2.521-10.124a2.521 2.521 0 1 1 2.521-2.52v2.52zm0 1.271a2.521 2.521 0 0 1 0 5.042H6.52a2.521 2.521 0 1 1 0-5.042zm10.124 2.521a2.521 2.521 0 1 1 2.52 2.521h-2.52zm-1.271 0a2.521 2.521 0 0 1-5.042 0V6.52a2.521 2.521 0 1 1 5.042 0zm-2.521 10.124a2.521 2.521 0 1 1-2.521 2.52v-2.52zm0-1.271a2.521 2.521 0 0 1 0-5.042h6.313a2.521 2.521 0 1 1 0 5.042z"}),props.children);});var LogoSlack20=/*#__PURE__*/React.forwardRef(function LogoSlack20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M9.042 19.166a2.521 2.521 0 1 1-2.52-2.521h2.52zm1.271 0a2.521 2.521 0 0 1 5.042 0v6.313a2.521 2.521 0 1 1-5.042 0zm2.521-10.124a2.521 2.521 0 1 1 2.521-2.52v2.52zm0 1.271a2.521 2.521 0 0 1 0 5.042H6.52a2.521 2.521 0 1 1 0-5.042zm10.124 2.521a2.521 2.521 0 1 1 2.52 2.521h-2.52zm-1.271 0a2.521 2.521 0 0 1-5.042 0V6.52a2.521 2.521 0 1 1 5.042 0zm-2.521 10.124a2.521 2.521 0 1 1-2.521 2.52v-2.52zm0-1.271a2.521 2.521 0 0 1 0-5.042h6.313a2.521 2.521 0 1 1 0 5.042z"}),props.children);});var LogoSlack16=/*#__PURE__*/React.forwardRef(function LogoSlack16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M9.042 19.166a2.521 2.521 0 1 1-2.52-2.521h2.52zm1.271 0a2.521 2.521 0 0 1 5.042 0v6.313a2.521 2.521 0 1 1-5.042 0zm2.521-10.124a2.521 2.521 0 1 1 2.521-2.52v2.52zm0 1.271a2.521 2.521 0 0 1 0 5.042H6.52a2.521 2.521 0 1 1 0-5.042zm10.124 2.521a2.521 2.521 0 1 1 2.52 2.521h-2.52zm-1.271 0a2.521 2.521 0 0 1-5.042 0V6.52a2.521 2.521 0 1 1 5.042 0zm-2.521 10.124a2.521 2.521 0 1 1-2.521 2.52v-2.52zm0-1.271a2.521 2.521 0 0 1 0-5.042h6.313a2.521 2.521 0 1 1 0 5.042z"}),props.children);});var LogoSnapchat32=/*#__PURE__*/React.forwardRef(function LogoSnapchat32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 8.56a8.44 8.44 0 0 0-.13-1.5 6.13 6.13 0 0 0-.57-1.74 6.13 6.13 0 0 0-1.2-1.56 5.88 5.88 0 0 0-2.54-1.45A10.66 10.66 0 0 0 22.87 2H9.13c-.51 0-1 0-1.54.07a7.73 7.73 0 0 0-1.65.37A5.89 5.89 0 0 0 3.76 3.9 5.78 5.78 0 0 0 2.3 6.45 10 10 0 0 0 2 9.12v13.77a16.2 16.2 0 0 0 .13 1.86 6.46 6.46 0 0 0 .57 1.89 6 6 0 0 0 1.68 2 5.45 5.45 0 0 0 1.69.92 9 9 0 0 0 2.77.4h14.57a9.59 9.59 0 0 0 1.68-.18 5.74 5.74 0 0 0 2.81-1.36 5.85 5.85 0 0 0 1.86-3.1 11.25 11.25 0 0 0 .24-2.43V8.56zm-3.75 13c-.18.42-1.08.77-2.61 1-.15 0-.21.26-.29.64a4.05 4.05 0 0 1-.12.47.28.28 0 0 1-.3.23 2.15 2.15 0 0 1-.44-.06 5.3 5.3 0 0 0-2-.05 3.94 3.94 0 0 0-1.57.81 4.56 4.56 0 0 1-2.76 1.08h-.26a4.56 4.56 0 0 1-2.76-1.08 4 4 0 0 0-1.58-.81 5.92 5.92 0 0 0-.82-.07 6 6 0 0 0-1.15.13 2.07 2.07 0 0 1-.44.06.3.3 0 0 1-.33-.23 4.15 4.15 0 0 1-.11-.48c-.09-.38-.15-.61-.29-.63-1.53-.24-2.44-.59-2.62-1a.31.31 0 0 1 0-.13.24.24 0 0 1 .2-.26 5.35 5.35 0 0 0 3.22-1.91 7.37 7.37 0 0 0 1.1-1.71 1.08 1.08 0 0 0 .11-.92c-.2-.47-.85-.67-1.29-.81l-.29-.1c-.38-.15-1-.47-.93-.91a.85.85 0 0 1 .84-.55.66.66 0 0 1 .25 0 2.58 2.58 0 0 0 1 .28.89.89 0 0 0 .6-.19v-.61a10.24 10.24 0 0 1 .19-4.15 5.38 5.38 0 0 1 5-3.22h.41a5.38 5.38 0 0 1 5 3.22 10.61 10.61 0 0 1 .25 4.14v.61a.82.82 0 0 0 .54.18 2.55 2.55 0 0 0 1-.27.84.84 0 0 1 .32-.06.9.9 0 0 1 .37.07.68.68 0 0 1 .51.56c0 .21-.16.53-.94.84l-.29.1c-.43.14-1.09.34-1.28.81a1.11 1.11 0 0 0 .1.92c.05.13 1.37 3.13 4.31 3.62a.26.26 0 0 1 .21.26.65.65 0 0 1-.09.14z"}),props.children);});var LogoSnapchat24=/*#__PURE__*/React.forwardRef(function LogoSnapchat24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 8.56a8.44 8.44 0 0 0-.13-1.5 6.13 6.13 0 0 0-.57-1.74 6.13 6.13 0 0 0-1.2-1.56 5.88 5.88 0 0 0-2.54-1.45A10.66 10.66 0 0 0 22.87 2H9.13c-.51 0-1 0-1.54.07a7.73 7.73 0 0 0-1.65.37A5.89 5.89 0 0 0 3.76 3.9 5.78 5.78 0 0 0 2.3 6.45 10 10 0 0 0 2 9.12v13.77a16.2 16.2 0 0 0 .13 1.86 6.46 6.46 0 0 0 .57 1.89 6 6 0 0 0 1.68 2 5.45 5.45 0 0 0 1.69.92 9 9 0 0 0 2.77.4h14.57a9.59 9.59 0 0 0 1.68-.18 5.74 5.74 0 0 0 2.81-1.36 5.85 5.85 0 0 0 1.86-3.1 11.25 11.25 0 0 0 .24-2.43V8.56zm-3.75 13c-.18.42-1.08.77-2.61 1-.15 0-.21.26-.29.64a4.05 4.05 0 0 1-.12.47.28.28 0 0 1-.3.23 2.15 2.15 0 0 1-.44-.06 5.3 5.3 0 0 0-2-.05 3.94 3.94 0 0 0-1.57.81 4.56 4.56 0 0 1-2.76 1.08h-.26a4.56 4.56 0 0 1-2.76-1.08 4 4 0 0 0-1.58-.81 5.92 5.92 0 0 0-.82-.07 6 6 0 0 0-1.15.13 2.07 2.07 0 0 1-.44.06.3.3 0 0 1-.33-.23 4.15 4.15 0 0 1-.11-.48c-.09-.38-.15-.61-.29-.63-1.53-.24-2.44-.59-2.62-1a.31.31 0 0 1 0-.13.24.24 0 0 1 .2-.26 5.35 5.35 0 0 0 3.22-1.91 7.37 7.37 0 0 0 1.1-1.71 1.08 1.08 0 0 0 .11-.92c-.2-.47-.85-.67-1.29-.81l-.29-.1c-.38-.15-1-.47-.93-.91a.85.85 0 0 1 .84-.55.66.66 0 0 1 .25 0 2.58 2.58 0 0 0 1 .28.89.89 0 0 0 .6-.19v-.61a10.24 10.24 0 0 1 .19-4.15 5.38 5.38 0 0 1 5-3.22h.41a5.38 5.38 0 0 1 5 3.22 10.61 10.61 0 0 1 .25 4.14v.61a.82.82 0 0 0 .54.18 2.55 2.55 0 0 0 1-.27.84.84 0 0 1 .32-.06.9.9 0 0 1 .37.07.68.68 0 0 1 .51.56c0 .21-.16.53-.94.84l-.29.1c-.43.14-1.09.34-1.28.81a1.11 1.11 0 0 0 .1.92c.05.13 1.37 3.13 4.31 3.62a.26.26 0 0 1 .21.26.65.65 0 0 1-.09.14z"}),props.children);});var LogoSnapchat20=/*#__PURE__*/React.forwardRef(function LogoSnapchat20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 8.56a8.44 8.44 0 0 0-.13-1.5 6.13 6.13 0 0 0-.57-1.74 6.13 6.13 0 0 0-1.2-1.56 5.88 5.88 0 0 0-2.54-1.45A10.66 10.66 0 0 0 22.87 2H9.13c-.51 0-1 0-1.54.07a7.73 7.73 0 0 0-1.65.37A5.89 5.89 0 0 0 3.76 3.9 5.78 5.78 0 0 0 2.3 6.45 10 10 0 0 0 2 9.12v13.77a16.2 16.2 0 0 0 .13 1.86 6.46 6.46 0 0 0 .57 1.89 6 6 0 0 0 1.68 2 5.45 5.45 0 0 0 1.69.92 9 9 0 0 0 2.77.4h14.57a9.59 9.59 0 0 0 1.68-.18 5.74 5.74 0 0 0 2.81-1.36 5.85 5.85 0 0 0 1.86-3.1 11.25 11.25 0 0 0 .24-2.43V8.56zm-3.75 13c-.18.42-1.08.77-2.61 1-.15 0-.21.26-.29.64a4.05 4.05 0 0 1-.12.47.28.28 0 0 1-.3.23 2.15 2.15 0 0 1-.44-.06 5.3 5.3 0 0 0-2-.05 3.94 3.94 0 0 0-1.57.81 4.56 4.56 0 0 1-2.76 1.08h-.26a4.56 4.56 0 0 1-2.76-1.08 4 4 0 0 0-1.58-.81 5.92 5.92 0 0 0-.82-.07 6 6 0 0 0-1.15.13 2.07 2.07 0 0 1-.44.06.3.3 0 0 1-.33-.23 4.15 4.15 0 0 1-.11-.48c-.09-.38-.15-.61-.29-.63-1.53-.24-2.44-.59-2.62-1a.31.31 0 0 1 0-.13.24.24 0 0 1 .2-.26 5.35 5.35 0 0 0 3.22-1.91 7.37 7.37 0 0 0 1.1-1.71 1.08 1.08 0 0 0 .11-.92c-.2-.47-.85-.67-1.29-.81l-.29-.1c-.38-.15-1-.47-.93-.91a.85.85 0 0 1 .84-.55.66.66 0 0 1 .25 0 2.58 2.58 0 0 0 1 .28.89.89 0 0 0 .6-.19v-.61a10.24 10.24 0 0 1 .19-4.15 5.38 5.38 0 0 1 5-3.22h.41a5.38 5.38 0 0 1 5 3.22 10.61 10.61 0 0 1 .25 4.14v.61a.82.82 0 0 0 .54.18 2.55 2.55 0 0 0 1-.27.84.84 0 0 1 .32-.06.9.9 0 0 1 .37.07.68.68 0 0 1 .51.56c0 .21-.16.53-.94.84l-.29.1c-.43.14-1.09.34-1.28.81a1.11 1.11 0 0 0 .1.92c.05.13 1.37 3.13 4.31 3.62a.26.26 0 0 1 .21.26.65.65 0 0 1-.09.14z"}),props.children);});var LogoSnapchat16=/*#__PURE__*/React.forwardRef(function LogoSnapchat16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 8.56a8.44 8.44 0 0 0-.13-1.5 6.13 6.13 0 0 0-.57-1.74 6.13 6.13 0 0 0-1.2-1.56 5.88 5.88 0 0 0-2.54-1.45A10.66 10.66 0 0 0 22.87 2H9.13c-.51 0-1 0-1.54.07a7.73 7.73 0 0 0-1.65.37A5.89 5.89 0 0 0 3.76 3.9 5.78 5.78 0 0 0 2.3 6.45 10 10 0 0 0 2 9.12v13.77a16.2 16.2 0 0 0 .13 1.86 6.46 6.46 0 0 0 .57 1.89 6 6 0 0 0 1.68 2 5.45 5.45 0 0 0 1.69.92 9 9 0 0 0 2.77.4h14.57a9.59 9.59 0 0 0 1.68-.18 5.74 5.74 0 0 0 2.81-1.36 5.85 5.85 0 0 0 1.86-3.1 11.25 11.25 0 0 0 .24-2.43V8.56zm-3.75 13c-.18.42-1.08.77-2.61 1-.15 0-.21.26-.29.64a4.05 4.05 0 0 1-.12.47.28.28 0 0 1-.3.23 2.15 2.15 0 0 1-.44-.06 5.3 5.3 0 0 0-2-.05 3.94 3.94 0 0 0-1.57.81 4.56 4.56 0 0 1-2.76 1.08h-.26a4.56 4.56 0 0 1-2.76-1.08 4 4 0 0 0-1.58-.81 5.92 5.92 0 0 0-.82-.07 6 6 0 0 0-1.15.13 2.07 2.07 0 0 1-.44.06.3.3 0 0 1-.33-.23 4.15 4.15 0 0 1-.11-.48c-.09-.38-.15-.61-.29-.63-1.53-.24-2.44-.59-2.62-1a.31.31 0 0 1 0-.13.24.24 0 0 1 .2-.26 5.35 5.35 0 0 0 3.22-1.91 7.37 7.37 0 0 0 1.1-1.71 1.08 1.08 0 0 0 .11-.92c-.2-.47-.85-.67-1.29-.81l-.29-.1c-.38-.15-1-.47-.93-.91a.85.85 0 0 1 .84-.55.66.66 0 0 1 .25 0 2.58 2.58 0 0 0 1 .28.89.89 0 0 0 .6-.19v-.61a10.24 10.24 0 0 1 .19-4.15 5.38 5.38 0 0 1 5-3.22h.41a5.38 5.38 0 0 1 5 3.22 10.61 10.61 0 0 1 .25 4.14v.61a.82.82 0 0 0 .54.18 2.55 2.55 0 0 0 1-.27.84.84 0 0 1 .32-.06.9.9 0 0 1 .37.07.68.68 0 0 1 .51.56c0 .21-.16.53-.94.84l-.29.1c-.43.14-1.09.34-1.28.81a1.11 1.11 0 0 0 .1.92c.05.13 1.37 3.13 4.31 3.62a.26.26 0 0 1 .21.26.65.65 0 0 1-.09.14z"}),props.children);});var LogoStumbleupon32=/*#__PURE__*/React.forwardRef(function LogoStumbleupon32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm-.09 10.45a.84.84 0 0 0-.84.84v5.14a3.55 3.55 0 0 1-7.1 0v-2.34h2.71v2.24a.84.84 0 0 0 1.68 0v-5a3.55 3.55 0 0 1 7.09 0v1l-1.58.51-1.12-.51v-1a.85.85 0 0 0-.84-.88zm7.93 6a3.55 3.55 0 0 1-7.09 0v-2.31l1.12.51 1.58-.51v2.29a.84.84 0 0 0 1.68 0v-2.24h2.71z"}),props.children);});var LogoStumbleupon24=/*#__PURE__*/React.forwardRef(function LogoStumbleupon24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm-.09 10.45a.84.84 0 0 0-.84.84v5.14a3.55 3.55 0 0 1-7.1 0v-2.34h2.71v2.24a.84.84 0 0 0 1.68 0v-5a3.55 3.55 0 0 1 7.09 0v1l-1.58.51-1.12-.51v-1a.85.85 0 0 0-.84-.88zm7.93 6a3.55 3.55 0 0 1-7.09 0v-2.31l1.12.51 1.58-.51v2.29a.84.84 0 0 0 1.68 0v-2.24h2.71z"}),props.children);});var LogoStumbleupon20=/*#__PURE__*/React.forwardRef(function LogoStumbleupon20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm-.09 10.45a.84.84 0 0 0-.84.84v5.14a3.55 3.55 0 0 1-7.1 0v-2.34h2.71v2.24a.84.84 0 0 0 1.68 0v-5a3.55 3.55 0 0 1 7.09 0v1l-1.58.51-1.12-.51v-1a.85.85 0 0 0-.84-.88zm7.93 6a3.55 3.55 0 0 1-7.09 0v-2.31l1.12.51 1.58-.51v2.29a.84.84 0 0 0 1.68 0v-2.24h2.71z"}),props.children);});var LogoStumbleupon16=/*#__PURE__*/React.forwardRef(function LogoStumbleupon16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm-.09 10.45a.84.84 0 0 0-.84.84v5.14a3.55 3.55 0 0 1-7.1 0v-2.34h2.71v2.24a.84.84 0 0 0 1.68 0v-5a3.55 3.55 0 0 1 7.09 0v1l-1.58.51-1.12-.51v-1a.85.85 0 0 0-.84-.88zm7.93 6a3.55 3.55 0 0 1-7.09 0v-2.31l1.12.51 1.58-.51v2.29a.84.84 0 0 0 1.68 0v-2.24h2.71z"}),props.children);});var LogoTumblr32=/*#__PURE__*/React.forwardRef(function LogoTumblr32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22.6 28h-4c-3.59 0-6.3-1.86-6.3-6.3v-7.12H9v-3.86A7.17 7.17 0 0 0 14.3 4h3.76v6.12h4.36v4.46h-4.36v6.2c0 1.86.94 2.49 2.42 2.49h2.12z"}),props.children);});var LogoTumblr24=/*#__PURE__*/React.forwardRef(function LogoTumblr24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22.6 28h-4c-3.59 0-6.3-1.86-6.3-6.3v-7.12H9v-3.86A7.17 7.17 0 0 0 14.3 4h3.76v6.12h4.36v4.46h-4.36v6.2c0 1.86.94 2.49 2.42 2.49h2.12z"}),props.children);});var LogoTumblr20=/*#__PURE__*/React.forwardRef(function LogoTumblr20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22.6 28h-4c-3.59 0-6.3-1.86-6.3-6.3v-7.12H9v-3.86A7.17 7.17 0 0 0 14.3 4h3.76v6.12h4.36v4.46h-4.36v6.2c0 1.86.94 2.49 2.42 2.49h2.12z"}),props.children);});var LogoTumblr16=/*#__PURE__*/React.forwardRef(function LogoTumblr16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22.6 28h-4c-3.59 0-6.3-1.86-6.3-6.3v-7.12H9v-3.86A7.17 7.17 0 0 0 14.3 4h3.76v6.12h4.36v4.46h-4.36v6.2c0 1.86.94 2.49 2.42 2.49h2.12z"}),props.children);});var LogoTwitter32=/*#__PURE__*/React.forwardRef(function LogoTwitter32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.92 24.94A12.76 12.76 0 0 0 24.76 12.1v-.59A9.4 9.4 0 0 0 27 9.18a9.31 9.31 0 0 1-2.59.71 4.56 4.56 0 0 0 2-2.5 8.89 8.89 0 0 1-2.86 1.1 4.52 4.52 0 0 0-7.7 4.11 12.79 12.79 0 0 1-9.3-4.71 4.51 4.51 0 0 0 1.4 6 4.47 4.47 0 0 1-2-.56v.05a4.53 4.53 0 0 0 3.55 4.45 4.53 4.53 0 0 1-2 .08A4.51 4.51 0 0 0 11.68 21a9.05 9.05 0 0 1-5.61 2A9.77 9.77 0 0 1 5 22.91a12.77 12.77 0 0 0 6.92 2"}),props.children);});var LogoTwitter24=/*#__PURE__*/React.forwardRef(function LogoTwitter24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.92 24.94A12.76 12.76 0 0 0 24.76 12.1v-.59A9.4 9.4 0 0 0 27 9.18a9.31 9.31 0 0 1-2.59.71 4.56 4.56 0 0 0 2-2.5 8.89 8.89 0 0 1-2.86 1.1 4.52 4.52 0 0 0-7.7 4.11 12.79 12.79 0 0 1-9.3-4.71 4.51 4.51 0 0 0 1.4 6 4.47 4.47 0 0 1-2-.56v.05a4.53 4.53 0 0 0 3.55 4.45 4.53 4.53 0 0 1-2 .08A4.51 4.51 0 0 0 11.68 21a9.05 9.05 0 0 1-5.61 2A9.77 9.77 0 0 1 5 22.91a12.77 12.77 0 0 0 6.92 2"}),props.children);});var LogoTwitter20=/*#__PURE__*/React.forwardRef(function LogoTwitter20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.92 24.94A12.76 12.76 0 0 0 24.76 12.1v-.59A9.4 9.4 0 0 0 27 9.18a9.31 9.31 0 0 1-2.59.71 4.56 4.56 0 0 0 2-2.5 8.89 8.89 0 0 1-2.86 1.1 4.52 4.52 0 0 0-7.7 4.11 12.79 12.79 0 0 1-9.3-4.71 4.51 4.51 0 0 0 1.4 6 4.47 4.47 0 0 1-2-.56v.05a4.53 4.53 0 0 0 3.55 4.45 4.53 4.53 0 0 1-2 .08A4.51 4.51 0 0 0 11.68 21a9.05 9.05 0 0 1-5.61 2A9.77 9.77 0 0 1 5 22.91a12.77 12.77 0 0 0 6.92 2"}),props.children);});var LogoTwitter16=/*#__PURE__*/React.forwardRef(function LogoTwitter16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.92 24.94A12.76 12.76 0 0 0 24.76 12.1v-.59A9.4 9.4 0 0 0 27 9.18a9.31 9.31 0 0 1-2.59.71 4.56 4.56 0 0 0 2-2.5 8.89 8.89 0 0 1-2.86 1.1 4.52 4.52 0 0 0-7.7 4.11 12.79 12.79 0 0 1-9.3-4.71 4.51 4.51 0 0 0 1.4 6 4.47 4.47 0 0 1-2-.56v.05a4.53 4.53 0 0 0 3.55 4.45 4.53 4.53 0 0 1-2 .08A4.51 4.51 0 0 0 11.68 21a9.05 9.05 0 0 1-5.61 2A9.77 9.77 0 0 1 5 22.91a12.77 12.77 0 0 0 6.92 2"}),props.children);});var LogoXing32=/*#__PURE__*/React.forwardRef(function LogoXing32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.42 8.29a1.25 1.25 0 0 0-1.13-.76h-4a.65.65 0 0 0-.55.25.63.63 0 0 0 0 .62l2.73 4.73-4.3 7.59a.6.6 0 0 0 0 .62.58.58 0 0 0 .52.28h4a1.22 1.22 0 0 0 1.1-.78l4.36-7.71-2.73-4.84zm16.41-5.41a.65.65 0 0 0 0-.62.61.61 0 0 0-.53-.26h-4.08a1.19 1.19 0 0 0-1.08.77s-8.7 15.43-9 15.93l5.74 10.53A1.26 1.26 0 0 0 20 30h4a.59.59 0 0 0 .54-.26.62.62 0 0 0 0-.62l-5.69-10.4z"}),props.children);});var LogoXing24=/*#__PURE__*/React.forwardRef(function LogoXing24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.42 8.29a1.25 1.25 0 0 0-1.13-.76h-4a.65.65 0 0 0-.55.25.63.63 0 0 0 0 .62l2.73 4.73-4.3 7.59a.6.6 0 0 0 0 .62.58.58 0 0 0 .52.28h4a1.22 1.22 0 0 0 1.1-.78l4.36-7.71-2.73-4.84zm16.41-5.41a.65.65 0 0 0 0-.62.61.61 0 0 0-.53-.26h-4.08a1.19 1.19 0 0 0-1.08.77s-8.7 15.43-9 15.93l5.74 10.53A1.26 1.26 0 0 0 20 30h4a.59.59 0 0 0 .54-.26.62.62 0 0 0 0-.62l-5.69-10.4z"}),props.children);});var LogoXing20=/*#__PURE__*/React.forwardRef(function LogoXing20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.42 8.29a1.25 1.25 0 0 0-1.13-.76h-4a.65.65 0 0 0-.55.25.63.63 0 0 0 0 .62l2.73 4.73-4.3 7.59a.6.6 0 0 0 0 .62.58.58 0 0 0 .52.28h4a1.22 1.22 0 0 0 1.1-.78l4.36-7.71-2.73-4.84zm16.41-5.41a.65.65 0 0 0 0-.62.61.61 0 0 0-.53-.26h-4.08a1.19 1.19 0 0 0-1.08.77s-8.7 15.43-9 15.93l5.74 10.53A1.26 1.26 0 0 0 20 30h4a.59.59 0 0 0 .54-.26.62.62 0 0 0 0-.62l-5.69-10.4z"}),props.children);});var LogoXing16=/*#__PURE__*/React.forwardRef(function LogoXing16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.42 8.29a1.25 1.25 0 0 0-1.13-.76h-4a.65.65 0 0 0-.55.25.63.63 0 0 0 0 .62l2.73 4.73-4.3 7.59a.6.6 0 0 0 0 .62.58.58 0 0 0 .52.28h4a1.22 1.22 0 0 0 1.1-.78l4.36-7.71-2.73-4.84zm16.41-5.41a.65.65 0 0 0 0-.62.61.61 0 0 0-.53-.26h-4.08a1.19 1.19 0 0 0-1.08.77s-8.7 15.43-9 15.93l5.74 10.53A1.26 1.26 0 0 0 20 30h4a.59.59 0 0 0 .54-.26.62.62 0 0 0 0-.62l-5.69-10.4z"}),props.children);});var LogoYoutube32=/*#__PURE__*/React.forwardRef(function LogoYoutube32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.41 9.26a3.5 3.5 0 0 0-2.47-2.47C24.76 6.2 16 6.2 16 6.2s-8.76 0-10.94.59a3.5 3.5 0 0 0-2.47 2.47A36.13 36.13 0 0 0 2 16a36.13 36.13 0 0 0 .59 6.74 3.5 3.5 0 0 0 2.47 2.47c2.18.59 10.94.59 10.94.59s8.76 0 10.94-.59a3.5 3.5 0 0 0 2.47-2.47A36.13 36.13 0 0 0 30 16a36.13 36.13 0 0 0-.59-6.74zM13.2 20.2v-8.4l7.27 4.2z"}),props.children);});var LogoYoutube24=/*#__PURE__*/React.forwardRef(function LogoYoutube24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.41 9.26a3.5 3.5 0 0 0-2.47-2.47C24.76 6.2 16 6.2 16 6.2s-8.76 0-10.94.59a3.5 3.5 0 0 0-2.47 2.47A36.13 36.13 0 0 0 2 16a36.13 36.13 0 0 0 .59 6.74 3.5 3.5 0 0 0 2.47 2.47c2.18.59 10.94.59 10.94.59s8.76 0 10.94-.59a3.5 3.5 0 0 0 2.47-2.47A36.13 36.13 0 0 0 30 16a36.13 36.13 0 0 0-.59-6.74zM13.2 20.2v-8.4l7.27 4.2z"}),props.children);});var LogoYoutube20=/*#__PURE__*/React.forwardRef(function LogoYoutube20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.41 9.26a3.5 3.5 0 0 0-2.47-2.47C24.76 6.2 16 6.2 16 6.2s-8.76 0-10.94.59a3.5 3.5 0 0 0-2.47 2.47A36.13 36.13 0 0 0 2 16a36.13 36.13 0 0 0 .59 6.74 3.5 3.5 0 0 0 2.47 2.47c2.18.59 10.94.59 10.94.59s8.76 0 10.94-.59a3.5 3.5 0 0 0 2.47-2.47A36.13 36.13 0 0 0 30 16a36.13 36.13 0 0 0-.59-6.74zM13.2 20.2v-8.4l7.27 4.2z"}),props.children);});var LogoYoutube16=/*#__PURE__*/React.forwardRef(function LogoYoutube16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.41 9.26a3.5 3.5 0 0 0-2.47-2.47C24.76 6.2 16 6.2 16 6.2s-8.76 0-10.94.59a3.5 3.5 0 0 0-2.47 2.47A36.13 36.13 0 0 0 2 16a36.13 36.13 0 0 0 .59 6.74 3.5 3.5 0 0 0 2.47 2.47c2.18.59 10.94.59 10.94.59s8.76 0 10.94-.59a3.5 3.5 0 0 0 2.47-2.47A36.13 36.13 0 0 0 30 16a36.13 36.13 0 0 0-.59-6.74zM13.2 20.2v-8.4l7.27 4.2z"}),props.children);});var Logout32=/*#__PURE__*/React.forwardRef(function Logout32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6 30h12a2.002 2.002 0 0 0 2-2v-3h-2v3H6V4h12v3h2V4a2.002 2.002 0 0 0-2-2H6a2.002 2.002 0 0 0-2 2v24a2.002 2.002 0 0 0 2 2z"}),React.createElement("path",{d:"M20.586 20.586L24.172 17H10v-2h14.172l-3.586-3.586L22 10l6 6-6 6-1.414-1.414z"}),props.children);});var Logout24=/*#__PURE__*/React.forwardRef(function Logout24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6 30h12a2.002 2.002 0 0 0 2-2v-3h-2v3H6V4h12v3h2V4a2.002 2.002 0 0 0-2-2H6a2.002 2.002 0 0 0-2 2v24a2.002 2.002 0 0 0 2 2z"}),React.createElement("path",{d:"M20.586 20.586L24.172 17H10v-2h14.172l-3.586-3.586L22 10l6 6-6 6-1.414-1.414z"}),props.children);});var Logout20=/*#__PURE__*/React.forwardRef(function Logout20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6 30h12a2.002 2.002 0 0 0 2-2v-3h-2v3H6V4h12v3h2V4a2.002 2.002 0 0 0-2-2H6a2.002 2.002 0 0 0-2 2v24a2.002 2.002 0 0 0 2 2z"}),React.createElement("path",{d:"M20.586 20.586L24.172 17H10v-2h14.172l-3.586-3.586L22 10l6 6-6 6-1.414-1.414z"}),props.children);});var Logout16=/*#__PURE__*/React.forwardRef(function Logout16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6 30h12a2.002 2.002 0 0 0 2-2v-3h-2v3H6V4h12v3h2V4a2.002 2.002 0 0 0-2-2H6a2.002 2.002 0 0 0-2 2v24a2.002 2.002 0 0 0 2 2z"}),React.createElement("path",{d:"M20.586 20.586L24.172 17H10v-2h14.172l-3.586-3.586L22 10l6 6-6 6-1.414-1.414z"}),props.children);});var Loop32=/*#__PURE__*/React.forwardRef(function Loop32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.59 19.41L26 22h-5v2h5l-2.41 2.59L25 28l5-5-5-5-1.41 1.41zM13 6a9 9 0 0 0-7.48 14l1.66-1.11A7 7 0 1 1 13 22H2v2h11a9 9 0 0 0 0-18z"}),props.children);});var Loop24=/*#__PURE__*/React.forwardRef(function Loop24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.59 19.41L26 22h-5v2h5l-2.41 2.59L25 28l5-5-5-5-1.41 1.41zM13 6a9 9 0 0 0-7.48 14l1.66-1.11A7 7 0 1 1 13 22H2v2h11a9 9 0 0 0 0-18z"}),props.children);});var Loop20=/*#__PURE__*/React.forwardRef(function Loop20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.59 19.41L26 22h-5v2h5l-2.41 2.59L25 28l5-5-5-5-1.41 1.41zM13 6a9 9 0 0 0-7.48 14l1.66-1.11A7 7 0 1 1 13 22H2v2h11a9 9 0 0 0 0-18z"}),props.children);});var Loop16=/*#__PURE__*/React.forwardRef(function Loop16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.59 19.41L26 22h-5v2h5l-2.41 2.59L25 28l5-5-5-5-1.41 1.41zM13 6a9 9 0 0 0-7.48 14l1.66-1.11A7 7 0 1 1 13 22H2v2h11a9 9 0 0 0 0-18z"}),props.children);});var MacCommand32=/*#__PURE__*/React.forwardRef(function MacCommand32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 13a4 4 0 0 0 4-4V8a4 4 0 0 0-4-4h-1a4 4 0 0 0-4 4v3h-6V8a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v1a4 4 0 0 0 4 4h3v6H8a4 4 0 0 0-4 4v1a4 4 0 0 0 4 4h1a4 4 0 0 0 4-4v-3h6v3a4 4 0 0 0 4 4h1a4 4 0 0 0 4-4v-1a4 4 0 0 0-4-4h-3v-6zm-3-5a2 2 0 0 1 2-2h1a2 2 0 0 1 2 2v1a2 2 0 0 1-2 2h-3zM8 11a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h1a2 2 0 0 1 2 2v3H8zm3 13a2 2 0 0 1-2 2H8a2 2 0 0 1-2-2v-1a2 2 0 0 1 2-2h3zm8-5h-6v-6h6zm2 2h3a2 2 0 0 1 2 2v1a2 2 0 0 1-2 2h-1a2 2 0 0 1-2-2z"}),props.children);});var MacCommand24=/*#__PURE__*/React.forwardRef(function MacCommand24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 13a4 4 0 0 0 4-4V8a4 4 0 0 0-4-4h-1a4 4 0 0 0-4 4v3h-6V8a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v1a4 4 0 0 0 4 4h3v6H8a4 4 0 0 0-4 4v1a4 4 0 0 0 4 4h1a4 4 0 0 0 4-4v-3h6v3a4 4 0 0 0 4 4h1a4 4 0 0 0 4-4v-1a4 4 0 0 0-4-4h-3v-6zm-3-5a2 2 0 0 1 2-2h1a2 2 0 0 1 2 2v1a2 2 0 0 1-2 2h-3zM8 11a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h1a2 2 0 0 1 2 2v3H8zm3 13a2 2 0 0 1-2 2H8a2 2 0 0 1-2-2v-1a2 2 0 0 1 2-2h3zm8-5h-6v-6h6zm2 2h3a2 2 0 0 1 2 2v1a2 2 0 0 1-2 2h-1a2 2 0 0 1-2-2z"}),props.children);});var MacCommand20=/*#__PURE__*/React.forwardRef(function MacCommand20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 13a4 4 0 0 0 4-4V8a4 4 0 0 0-4-4h-1a4 4 0 0 0-4 4v3h-6V8a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v1a4 4 0 0 0 4 4h3v6H8a4 4 0 0 0-4 4v1a4 4 0 0 0 4 4h1a4 4 0 0 0 4-4v-3h6v3a4 4 0 0 0 4 4h1a4 4 0 0 0 4-4v-1a4 4 0 0 0-4-4h-3v-6zm-3-5a2 2 0 0 1 2-2h1a2 2 0 0 1 2 2v1a2 2 0 0 1-2 2h-3zM8 11a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h1a2 2 0 0 1 2 2v3H8zm3 13a2 2 0 0 1-2 2H8a2 2 0 0 1-2-2v-1a2 2 0 0 1 2-2h3zm8-5h-6v-6h6zm2 2h3a2 2 0 0 1 2 2v1a2 2 0 0 1-2 2h-1a2 2 0 0 1-2-2z"}),props.children);});var MacCommand16=/*#__PURE__*/React.forwardRef(function MacCommand16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 13a4 4 0 0 0 4-4V8a4 4 0 0 0-4-4h-1a4 4 0 0 0-4 4v3h-6V8a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v1a4 4 0 0 0 4 4h3v6H8a4 4 0 0 0-4 4v1a4 4 0 0 0 4 4h1a4 4 0 0 0 4-4v-3h6v3a4 4 0 0 0 4 4h1a4 4 0 0 0 4-4v-1a4 4 0 0 0-4-4h-3v-6zm-3-5a2 2 0 0 1 2-2h1a2 2 0 0 1 2 2v1a2 2 0 0 1-2 2h-3zM8 11a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h1a2 2 0 0 1 2 2v3H8zm3 13a2 2 0 0 1-2 2H8a2 2 0 0 1-2-2v-1a2 2 0 0 1 2-2h3zm8-5h-6v-6h6zm2 2h3a2 2 0 0 1 2 2v1a2 2 0 0 1-2 2h-1a2 2 0 0 1-2-2z"}),props.children);});var MacOption32=/*#__PURE__*/React.forwardRef(function MacOption32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 5h10v2H18zm-7.4 0H4v2h5.4l9 20H28v-2h-8.4z"}),props.children);});var MacOption24=/*#__PURE__*/React.forwardRef(function MacOption24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 5h10v2H18zm-7.4 0H4v2h5.4l9 20H28v-2h-8.4z"}),props.children);});var MacOption20=/*#__PURE__*/React.forwardRef(function MacOption20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 5h10v2H18zm-7.4 0H4v2h5.4l9 20H28v-2h-8.4z"}),props.children);});var MacOption16=/*#__PURE__*/React.forwardRef(function MacOption16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 5h10v2H18zm-7.4 0H4v2h5.4l9 20H28v-2h-8.4z"}),props.children);});var MacShift32=/*#__PURE__*/React.forwardRef(function MacShift32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21 28H11a2 2 0 0 1-2-2V16H4a1 1 0 0 1-.92-.62 1 1 0 0 1 .21-1.09l12-12a1 1 0 0 1 1.42 0l12 12a1 1 0 0 1 .21 1.09A1 1 0 0 1 28 16h-5v10a2 2 0 0 1-2 2zM6.41 14H10a1 1 0 0 1 1 1v11h10V15a1 1 0 0 1 1-1h3.59L16 4.41z"}),props.children);});var MacShift24=/*#__PURE__*/React.forwardRef(function MacShift24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21 28H11a2 2 0 0 1-2-2V16H4a1 1 0 0 1-.92-.62 1 1 0 0 1 .21-1.09l12-12a1 1 0 0 1 1.42 0l12 12a1 1 0 0 1 .21 1.09A1 1 0 0 1 28 16h-5v10a2 2 0 0 1-2 2zM6.41 14H10a1 1 0 0 1 1 1v11h10V15a1 1 0 0 1 1-1h3.59L16 4.41z"}),props.children);});var MacShift20=/*#__PURE__*/React.forwardRef(function MacShift20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21 28H11a2 2 0 0 1-2-2V16H4a1 1 0 0 1-.92-.62 1 1 0 0 1 .21-1.09l12-12a1 1 0 0 1 1.42 0l12 12a1 1 0 0 1 .21 1.09A1 1 0 0 1 28 16h-5v10a2 2 0 0 1-2 2zM6.41 14H10a1 1 0 0 1 1 1v11h10V15a1 1 0 0 1 1-1h3.59L16 4.41z"}),props.children);});var MacShift16=/*#__PURE__*/React.forwardRef(function MacShift16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21 28H11a2 2 0 0 1-2-2V16H4a1 1 0 0 1-.92-.62 1 1 0 0 1 .21-1.09l12-12a1 1 0 0 1 1.42 0l12 12a1 1 0 0 1 .21 1.09A1 1 0 0 1 28 16h-5v10a2 2 0 0 1-2 2zM6.41 14H10a1 1 0 0 1 1 1v11h10V15a1 1 0 0 1 1-1h3.59L16 4.41z"}),props.children);});var MailAll32=/*#__PURE__*/React.forwardRef(function MailAll32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16.59 20.41L20.17 24l-3.59 3.59L18 29l5-5-5-5-1.41 1.41zm7 0L27.17 24l-3.59 3.59L25 29l5-5-5-5-1.41 1.41z"}),React.createElement("path",{d:"M14 23H4V7.91l11.43 7.91a1 1 0 0 0 1.14 0L28 7.91V17h2V7a2 2 0 0 0-2-2H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h10zM25.8 7L16 13.78 6.2 7z"}),props.children);});var MailAll24=/*#__PURE__*/React.forwardRef(function MailAll24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16.59 20.41L20.17 24l-3.59 3.59L18 29l5-5-5-5-1.41 1.41zm7 0L27.17 24l-3.59 3.59L25 29l5-5-5-5-1.41 1.41z"}),React.createElement("path",{d:"M14 23H4V7.91l11.43 7.91a1 1 0 0 0 1.14 0L28 7.91V17h2V7a2 2 0 0 0-2-2H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h10zM25.8 7L16 13.78 6.2 7z"}),props.children);});var MailAll20=/*#__PURE__*/React.forwardRef(function MailAll20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16.59 20.41L20.17 24l-3.59 3.59L18 29l5-5-5-5-1.41 1.41zm7 0L27.17 24l-3.59 3.59L25 29l5-5-5-5-1.41 1.41z"}),React.createElement("path",{d:"M14 23H4V7.91l11.43 7.91a1 1 0 0 0 1.14 0L28 7.91V17h2V7a2 2 0 0 0-2-2H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h10zM25.8 7L16 13.78 6.2 7z"}),props.children);});var MailAll16=/*#__PURE__*/React.forwardRef(function MailAll16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16.59 20.41L20.17 24l-3.59 3.59L18 29l5-5-5-5-1.41 1.41zm7 0L27.17 24l-3.59 3.59L25 29l5-5-5-5-1.41 1.41z"}),React.createElement("path",{d:"M14 23H4V7.91l11.43 7.91a1 1 0 0 0 1.14 0L28 7.91V17h2V7a2 2 0 0 0-2-2H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h10zM25.8 7L16 13.78 6.2 7z"}),props.children);});var Map32=/*#__PURE__*/React.forwardRef(function Map32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 24l-6.09-8.6A8.14 8.14 0 0 1 16 2a8.08 8.08 0 0 1 8 8.13 8.2 8.2 0 0 1-1.8 5.13zm0-20a6.07 6.07 0 0 0-6 6.13 6.19 6.19 0 0 0 1.49 4L16 20.52 20.63 14A6.24 6.24 0 0 0 22 10.13 6.07 6.07 0 0 0 16 4z"}),React.createElement("circle",{cx:"16",cy:"9",r:"2"}),React.createElement("path",{d:"M28 12h-2v2h2v14H4V14h2v-2H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V14a2 2 0 0 0-2-2z"}),props.children);});var Map24=/*#__PURE__*/React.forwardRef(function Map24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 24l-6.09-8.6A8.14 8.14 0 0 1 16 2a8.08 8.08 0 0 1 8 8.13 8.2 8.2 0 0 1-1.8 5.13zm0-20a6.07 6.07 0 0 0-6 6.13 6.19 6.19 0 0 0 1.49 4L16 20.52 20.63 14A6.24 6.24 0 0 0 22 10.13 6.07 6.07 0 0 0 16 4z"}),React.createElement("circle",{cx:"16",cy:"9",r:"2"}),React.createElement("path",{d:"M28 12h-2v2h2v14H4V14h2v-2H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V14a2 2 0 0 0-2-2z"}),props.children);});var Map20=/*#__PURE__*/React.forwardRef(function Map20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 24l-6.09-8.6A8.14 8.14 0 0 1 16 2a8.08 8.08 0 0 1 8 8.13 8.2 8.2 0 0 1-1.8 5.13zm0-20a6.07 6.07 0 0 0-6 6.13 6.19 6.19 0 0 0 1.49 4L16 20.52 20.63 14A6.24 6.24 0 0 0 22 10.13 6.07 6.07 0 0 0 16 4z"}),React.createElement("circle",{cx:"16",cy:"9",r:"2"}),React.createElement("path",{d:"M28 12h-2v2h2v14H4V14h2v-2H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V14a2 2 0 0 0-2-2z"}),props.children);});var Map16=/*#__PURE__*/React.forwardRef(function Map16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 24l-6.09-8.6A8.14 8.14 0 0 1 16 2a8.08 8.08 0 0 1 8 8.13 8.2 8.2 0 0 1-1.8 5.13zm0-20a6.07 6.07 0 0 0-6 6.13 6.19 6.19 0 0 0 1.49 4L16 20.52 20.63 14A6.24 6.24 0 0 0 22 10.13 6.07 6.07 0 0 0 16 4z"}),React.createElement("circle",{cx:"16",cy:"9",r:"2"}),React.createElement("path",{d:"M28 12h-2v2h2v14H4V14h2v-2H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V14a2 2 0 0 0-2-2z"}),props.children);});var Maximize32=/*#__PURE__*/React.forwardRef(function Maximize32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21 2v2h5.59L17 13.58 18.41 15 28 5.41V11h2V2h-9zm-6 16.42L13.59 17 4 26.59V21H2v9h9v-2H5.41L15 18.42z"}),props.children);});var Maximize24=/*#__PURE__*/React.forwardRef(function Maximize24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21 2v2h5.59L17 13.58 18.41 15 28 5.41V11h2V2h-9zm-6 16.42L13.59 17 4 26.59V21H2v9h9v-2H5.41L15 18.42z"}),props.children);});var Maximize20=/*#__PURE__*/React.forwardRef(function Maximize20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21 2v2h5.59L17 13.58 18.41 15 28 5.41V11h2V2h-9zm-6 16.42L13.59 17 4 26.59V21H2v9h9v-2H5.41L15 18.42z"}),props.children);});var MedicationAlert32=/*#__PURE__*/React.forwardRef(function MedicationAlert32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22 19h2v5h-2z"}),React.createElement("path",{d:"M23 31a8 8 0 1 1 8-8 8 8 0 0 1-8 8zm0-14a6 6 0 1 0 6 6 6 6 0 0 0-6-6z"}),React.createElement("circle",{cx:"23",cy:"26",r:"1"}),React.createElement("path",{d:"M20 2H4a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2v18a2 2 0 0 0 2 2h8v-2H6v-2h5V12H6v-2h12v3h2v-3a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2zM9 14v10H6V14zM4 8V4h16v4z"}),props.children);});var MedicationAlert24=/*#__PURE__*/React.forwardRef(function MedicationAlert24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22 19h2v5h-2z"}),React.createElement("path",{d:"M23 31a8 8 0 1 1 8-8 8 8 0 0 1-8 8zm0-14a6 6 0 1 0 6 6 6 6 0 0 0-6-6z"}),React.createElement("circle",{cx:"23",cy:"26",r:"1"}),React.createElement("path",{d:"M20 2H4a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2v18a2 2 0 0 0 2 2h8v-2H6v-2h5V12H6v-2h12v3h2v-3a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2zM9 14v10H6V14zM4 8V4h16v4z"}),props.children);});var MedicationAlert20=/*#__PURE__*/React.forwardRef(function MedicationAlert20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22 19h2v5h-2z"}),React.createElement("path",{d:"M23 31a8 8 0 1 1 8-8 8 8 0 0 1-8 8zm0-14a6 6 0 1 0 6 6 6 6 0 0 0-6-6z"}),React.createElement("circle",{cx:"23",cy:"26",r:"1"}),React.createElement("path",{d:"M20 2H4a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2v18a2 2 0 0 0 2 2h8v-2H6v-2h5V12H6v-2h12v3h2v-3a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2zM9 14v10H6V14zM4 8V4h16v4z"}),props.children);});var MedicationAlert16=/*#__PURE__*/React.forwardRef(function MedicationAlert16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22 19h2v5h-2z"}),React.createElement("path",{d:"M23 31a8 8 0 1 1 8-8 8 8 0 0 1-8 8zm0-14a6 6 0 1 0 6 6 6 6 0 0 0-6-6z"}),React.createElement("circle",{cx:"23",cy:"26",r:"1"}),React.createElement("path",{d:"M20 2H4a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2v18a2 2 0 0 0 2 2h8v-2H6v-2h5V12H6v-2h12v3h2v-3a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2zM9 14v10H6V14zM4 8V4h16v4z"}),props.children);});var MedicationReminder32=/*#__PURE__*/React.forwardRef(function MedicationReminder32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 2H4a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2v18a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V10a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2zM6 14h3v10H6zm12 14H6v-2h5V12H6v-2h12zM4 8V4h16v4z"}),React.createElement("circle",{cx:"26",cy:"16",r:"4"}),props.children);});var MedicationReminder24=/*#__PURE__*/React.forwardRef(function MedicationReminder24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 2H4a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2v18a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V10a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2zM6 14h3v10H6zm12 14H6v-2h5V12H6v-2h12zM4 8V4h16v4z"}),React.createElement("circle",{cx:"26",cy:"16",r:"4"}),props.children);});var MedicationReminder20=/*#__PURE__*/React.forwardRef(function MedicationReminder20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 2H4a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2v18a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V10a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2zM6 14h3v10H6zm12 14H6v-2h5V12H6v-2h12zM4 8V4h16v4z"}),React.createElement("circle",{cx:"26",cy:"16",r:"4"}),props.children);});var MedicationReminder16=/*#__PURE__*/React.forwardRef(function MedicationReminder16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 2H4a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2v18a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V10a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2zM6 14h3v10H6zm12 14H6v-2h5V12H6v-2h12zM4 8V4h16v4z"}),React.createElement("circle",{cx:"26",cy:"16",r:"4"}),props.children);});var Medication32=/*#__PURE__*/React.forwardRef(function Medication32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 2H8a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2v18a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V10a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2zM10 14h3v10h-3zm12 14H10v-2h5V12h-5v-2h12zM8 8V4h16v4z"}),props.children);});var Medication24=/*#__PURE__*/React.forwardRef(function Medication24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 2H8a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2v18a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V10a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2zM10 14h3v10h-3zm12 14H10v-2h5V12h-5v-2h12zM8 8V4h16v4z"}),props.children);});var Medication20=/*#__PURE__*/React.forwardRef(function Medication20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 2H8a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2v18a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V10a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2zM10 14h3v10h-3zm12 14H10v-2h5V12h-5v-2h12zM8 8V4h16v4z"}),props.children);});var Medication16=/*#__PURE__*/React.forwardRef(function Medication16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 2H8a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2v18a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V10a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2zM10 14h3v10h-3zm12 14H10v-2h5V12h-5v-2h12zM8 8V4h16v4z"}),props.children);});var Menu32=/*#__PURE__*/React.forwardRef(function Menu32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4 24h24v2H4zm0-12h24v2H4zm0 6h24v2H4zM4 6h24v2H4z"}),props.children);});var MicrophoneFilled32=/*#__PURE__*/React.forwardRef(function MicrophoneFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 14v3a7 7 0 0 1-14 0v-3H7v3a9 9 0 0 0 8 8.94V28h-4v2h10v-2h-4v-2.06A9 9 0 0 0 25 17v-3z"}),React.createElement("path",{d:"M16 22a5 5 0 0 0 5-5V7a5 5 0 0 0-10 0v10a5 5 0 0 0 5 5z"}),props.children);});var MicrophoneFilled24=/*#__PURE__*/React.forwardRef(function MicrophoneFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 14v3a7 7 0 0 1-14 0v-3H7v3a9 9 0 0 0 8 8.94V28h-4v2h10v-2h-4v-2.06A9 9 0 0 0 25 17v-3z"}),React.createElement("path",{d:"M16 22a5 5 0 0 0 5-5V7a5 5 0 0 0-10 0v10a5 5 0 0 0 5 5z"}),props.children);});var MicrophoneFilled20=/*#__PURE__*/React.forwardRef(function MicrophoneFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 14v3a7 7 0 0 1-14 0v-3H7v3a9 9 0 0 0 8 8.94V28h-4v2h10v-2h-4v-2.06A9 9 0 0 0 25 17v-3z"}),React.createElement("path",{d:"M16 22a5 5 0 0 0 5-5V7a5 5 0 0 0-10 0v10a5 5 0 0 0 5 5z"}),props.children);});var MicrophoneFilled16=/*#__PURE__*/React.forwardRef(function MicrophoneFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 14v3a7 7 0 0 1-14 0v-3H7v3a9 9 0 0 0 8 8.94V28h-4v2h10v-2h-4v-2.06A9 9 0 0 0 25 17v-3z"}),React.createElement("path",{d:"M16 22a5 5 0 0 0 5-5V7a5 5 0 0 0-10 0v10a5 5 0 0 0 5 5z"}),props.children);});var MicrophoneOffFilled32=/*#__PURE__*/React.forwardRef(function MicrophoneOffFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 17a7 7 0 0 1-11.73 5.14l1.42-1.41A5 5 0 0 0 21 17v-4.58l9-9L28.59 2 2 28.59 3.41 30l6.44-6.44A8.91 8.91 0 0 0 15 25.94V28h-4v2h10v-2h-4v-2.06A9 9 0 0 0 25 17v-3h-2zm-14 .32V14H7v3a9 9 0 0 0 .25 2.09zM20.76 5.58A5 5 0 0 0 11 7v8.34z"}),props.children);});var MicrophoneOffFilled24=/*#__PURE__*/React.forwardRef(function MicrophoneOffFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 17a7 7 0 0 1-11.73 5.14l1.42-1.41A5 5 0 0 0 21 17v-4.58l9-9L28.59 2 2 28.59 3.41 30l6.44-6.44A8.91 8.91 0 0 0 15 25.94V28h-4v2h10v-2h-4v-2.06A9 9 0 0 0 25 17v-3h-2zm-14 .32V14H7v3a9 9 0 0 0 .25 2.09zM20.76 5.58A5 5 0 0 0 11 7v8.34z"}),props.children);});var MicrophoneOffFilled20=/*#__PURE__*/React.forwardRef(function MicrophoneOffFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 17a7 7 0 0 1-11.73 5.14l1.42-1.41A5 5 0 0 0 21 17v-4.58l9-9L28.59 2 2 28.59 3.41 30l6.44-6.44A8.91 8.91 0 0 0 15 25.94V28h-4v2h10v-2h-4v-2.06A9 9 0 0 0 25 17v-3h-2zm-14 .32V14H7v3a9 9 0 0 0 .25 2.09zM20.76 5.58A5 5 0 0 0 11 7v8.34z"}),props.children);});var MicrophoneOffFilled16=/*#__PURE__*/React.forwardRef(function MicrophoneOffFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 17a7 7 0 0 1-11.73 5.14l1.42-1.41A5 5 0 0 0 21 17v-4.58l9-9L28.59 2 2 28.59 3.41 30l6.44-6.44A8.91 8.91 0 0 0 15 25.94V28h-4v2h10v-2h-4v-2.06A9 9 0 0 0 25 17v-3h-2zm-14 .32V14H7v3a9 9 0 0 0 .25 2.09zM20.76 5.58A5 5 0 0 0 11 7v8.34z"}),props.children);});var MicrophoneOff32=/*#__PURE__*/React.forwardRef(function MicrophoneOff32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M9.18 18.57A7.41 7.41 0 0 1 9 17v-3H7v3a8.84 8.84 0 0 0 .58 3.18zM13 15V7a3 3 0 0 1 6 0v1.75l2-2A5 5 0 0 0 11 7v8zm10 2a7 7 0 0 1-11.73 5.14l1.42-1.41A5 5 0 0 0 21 17v-4.58l9-9L28.59 2 2 28.59 3.41 30l6.44-6.44A8.91 8.91 0 0 0 15 25.94V28h-4v2h10v-2h-4v-2.06A9 9 0 0 0 25 17v-3h-2zm-4 0a3 3 0 0 1-4.9 2.31l4.9-4.89z"}),props.children);});var MicrophoneOff24=/*#__PURE__*/React.forwardRef(function MicrophoneOff24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M9.18 18.57A7.41 7.41 0 0 1 9 17v-3H7v3a8.84 8.84 0 0 0 .58 3.18zM13 15V7a3 3 0 0 1 6 0v1.75l2-2A5 5 0 0 0 11 7v8zm10 2a7 7 0 0 1-11.73 5.14l1.42-1.41A5 5 0 0 0 21 17v-4.58l9-9L28.59 2 2 28.59 3.41 30l6.44-6.44A8.91 8.91 0 0 0 15 25.94V28h-4v2h10v-2h-4v-2.06A9 9 0 0 0 25 17v-3h-2zm-4 0a3 3 0 0 1-4.9 2.31l4.9-4.89z"}),props.children);});var MicrophoneOff20=/*#__PURE__*/React.forwardRef(function MicrophoneOff20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M9.18 18.57A7.41 7.41 0 0 1 9 17v-3H7v3a8.84 8.84 0 0 0 .58 3.18zM13 15V7a3 3 0 0 1 6 0v1.75l2-2A5 5 0 0 0 11 7v8zm10 2a7 7 0 0 1-11.73 5.14l1.42-1.41A5 5 0 0 0 21 17v-4.58l9-9L28.59 2 2 28.59 3.41 30l6.44-6.44A8.91 8.91 0 0 0 15 25.94V28h-4v2h10v-2h-4v-2.06A9 9 0 0 0 25 17v-3h-2zm-4 0a3 3 0 0 1-4.9 2.31l4.9-4.89z"}),props.children);});var MicrophoneOff16=/*#__PURE__*/React.forwardRef(function MicrophoneOff16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M9.18 18.57A7.41 7.41 0 0 1 9 17v-3H7v3a8.84 8.84 0 0 0 .58 3.18zM13 15V7a3 3 0 0 1 6 0v1.75l2-2A5 5 0 0 0 11 7v8zm10 2a7 7 0 0 1-11.73 5.14l1.42-1.41A5 5 0 0 0 21 17v-4.58l9-9L28.59 2 2 28.59 3.41 30l6.44-6.44A8.91 8.91 0 0 0 15 25.94V28h-4v2h10v-2h-4v-2.06A9 9 0 0 0 25 17v-3h-2zm-4 0a3 3 0 0 1-4.9 2.31l4.9-4.89z"}),props.children);});var Microphone32=/*#__PURE__*/React.forwardRef(function Microphone32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 14v3a7 7 0 0 1-14 0v-3H7v3a9 9 0 0 0 8 8.94V28h-4v2h10v-2h-4v-2.06A9 9 0 0 0 25 17v-3z"}),React.createElement("path",{d:"M16 22a5 5 0 0 0 5-5V7a5 5 0 0 0-10 0v10a5 5 0 0 0 5 5zM13 7a3 3 0 0 1 6 0v10a3 3 0 0 1-6 0z"}),props.children);});var Microphone24=/*#__PURE__*/React.forwardRef(function Microphone24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 14v3a7 7 0 0 1-14 0v-3H7v3a9 9 0 0 0 8 8.94V28h-4v2h10v-2h-4v-2.06A9 9 0 0 0 25 17v-3z"}),React.createElement("path",{d:"M16 22a5 5 0 0 0 5-5V7a5 5 0 0 0-10 0v10a5 5 0 0 0 5 5zM13 7a3 3 0 0 1 6 0v10a3 3 0 0 1-6 0z"}),props.children);});var Microphone20=/*#__PURE__*/React.forwardRef(function Microphone20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 14v3a7 7 0 0 1-14 0v-3H7v3a9 9 0 0 0 8 8.94V28h-4v2h10v-2h-4v-2.06A9 9 0 0 0 25 17v-3z"}),React.createElement("path",{d:"M16 22a5 5 0 0 0 5-5V7a5 5 0 0 0-10 0v10a5 5 0 0 0 5 5zM13 7a3 3 0 0 1 6 0v10a3 3 0 0 1-6 0z"}),props.children);});var Microphone16=/*#__PURE__*/React.forwardRef(function Microphone16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23 14v3a7 7 0 0 1-14 0v-3H7v3a9 9 0 0 0 8 8.94V28h-4v2h10v-2h-4v-2.06A9 9 0 0 0 25 17v-3z"}),React.createElement("path",{d:"M16 22a5 5 0 0 0 5-5V7a5 5 0 0 0-10 0v10a5 5 0 0 0 5 5zM13 7a3 3 0 0 1 6 0v10a3 3 0 0 1-6 0z"}),props.children);});var MigrateAlt32=/*#__PURE__*/React.forwardRef(function MigrateAlt32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm0 22H12v-6h-2v6H4v-9h16.172l-3.586 3.586L18 22l6-6-6-6-1.414 1.414L20.172 15H4V6h6v6h2V6h16z"}),props.children);});var MigrateAlt24=/*#__PURE__*/React.forwardRef(function MigrateAlt24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm0 22H12v-6h-2v6H4v-9h16.172l-3.586 3.586L18 22l6-6-6-6-1.414 1.414L20.172 15H4V6h6v6h2V6h16z"}),props.children);});var MigrateAlt20=/*#__PURE__*/React.forwardRef(function MigrateAlt20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm0 22H12v-6h-2v6H4v-9h16.172l-3.586 3.586L18 22l6-6-6-6-1.414 1.414L20.172 15H4V6h6v6h2V6h16z"}),props.children);});var MigrateAlt16=/*#__PURE__*/React.forwardRef(function MigrateAlt16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm0 22H12v-6h-2v6H4v-9h16.172l-3.586 3.586L18 22l6-6-6-6-1.414 1.414L20.172 15H4V6h6v6h2V6h16z"}),props.children);});var Migrate32=/*#__PURE__*/React.forwardRef(function Migrate32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 2H6a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h9v6.17l-2.59-2.58L11 15l5 5 5-5-1.41-1.41L17 16.17V10h9a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2zM6 4h4v4H6zm20 4H12V4h14zm0 14H6a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2v-4a2 2 0 0 0-2-2zM6 24h14v4H6zm20 4h-4v-4h4z"}),props.children);});var Migrate24=/*#__PURE__*/React.forwardRef(function Migrate24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 2H6a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h9v6.17l-2.59-2.58L11 15l5 5 5-5-1.41-1.41L17 16.17V10h9a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2zM6 4h4v4H6zm20 4H12V4h14zm0 14H6a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2v-4a2 2 0 0 0-2-2zM6 24h14v4H6zm20 4h-4v-4h4z"}),props.children);});var Migrate20=/*#__PURE__*/React.forwardRef(function Migrate20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 2H6a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h9v6.17l-2.59-2.58L11 15l5 5 5-5-1.41-1.41L17 16.17V10h9a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2zM6 4h4v4H6zm20 4H12V4h14zm0 14H6a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2v-4a2 2 0 0 0-2-2zM6 24h14v4H6zm20 4h-4v-4h4z"}),props.children);});var Migrate16=/*#__PURE__*/React.forwardRef(function Migrate16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 2H6a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h9v6.17l-2.59-2.58L11 15l5 5 5-5-1.41-1.41L17 16.17V10h9a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2zM6 4h4v4H6zm20 4H12V4h14zm0 14H6a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2v-4a2 2 0 0 0-2-2zM6 24h14v4H6zm20 4h-4v-4h4z"}),props.children);});var Minimize32=/*#__PURE__*/React.forwardRef(function Minimize32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6 17v2h5.59L2 28.58 3.41 30 13 20.41V26h2v-9H6zM30 3.42L28.59 2 19 11.59V6h-2v9h9v-2h-5.59L30 3.42z"}),props.children);});var Minimize24=/*#__PURE__*/React.forwardRef(function Minimize24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6 17v2h5.59L2 28.58 3.41 30 13 20.41V26h2v-9H6zM30 3.42L28.59 2 19 11.59V6h-2v9h9v-2h-5.59L30 3.42z"}),props.children);});var Minimize20=/*#__PURE__*/React.forwardRef(function Minimize20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6 17v2h5.59L2 28.58 3.41 30 13 20.41V26h2v-9H6zM30 3.42L28.59 2 19 11.59V6h-2v9h9v-2h-5.59L30 3.42z"}),props.children);});var MisuseAlt32=/*#__PURE__*/React.forwardRef(function MisuseAlt32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21.41 23L16 17.591 10.59 23 9 21.41 14.409 16 9 10.591 10.591 9 16 14.409 21.409 9 23 10.591 17.591 16 23 21.41 21.41 23z"}),React.createElement("path",{d:"M16 4A12 12 0 1 1 4 16 12.014 12.014 0 0 1 16 4m0-2a14 14 0 1 0 14 14A14 14 0 0 0 16 2z"}),props.children);});var MisuseAlt24=/*#__PURE__*/React.forwardRef(function MisuseAlt24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21.41 23L16 17.591 10.59 23 9 21.41 14.409 16 9 10.591 10.591 9 16 14.409 21.409 9 23 10.591 17.591 16 23 21.41 21.41 23z"}),React.createElement("path",{d:"M16 4A12 12 0 1 1 4 16 12.014 12.014 0 0 1 16 4m0-2a14 14 0 1 0 14 14A14 14 0 0 0 16 2z"}),props.children);});var MisuseAlt20=/*#__PURE__*/React.forwardRef(function MisuseAlt20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21.41 23L16 17.591 10.59 23 9 21.41 14.409 16 9 10.591 10.591 9 16 14.409 21.409 9 23 10.591 17.591 16 23 21.41 21.41 23z"}),React.createElement("path",{d:"M16 4A12 12 0 1 1 4 16 12.014 12.014 0 0 1 16 4m0-2a14 14 0 1 0 14 14A14 14 0 0 0 16 2z"}),props.children);});var MisuseAlt16=/*#__PURE__*/React.forwardRef(function MisuseAlt16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21.41 23L16 17.591 10.59 23 9 21.41 14.409 16 9 10.591 10.591 9 16 14.409 21.409 9 23 10.591 17.591 16 23 21.41 21.41 23z"}),React.createElement("path",{d:"M16 4A12 12 0 1 1 4 16 12.014 12.014 0 0 1 16 4m0-2a14 14 0 1 0 14 14A14 14 0 0 0 16 2z"}),props.children);});var MisuseOutline32=/*#__PURE__*/React.forwardRef(function MisuseOutline32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2C8.2 2 2 8.2 2 16s6.2 14 14 14 14-6.2 14-14S23.8 2 16 2zm0 26C9.4 28 4 22.6 4 16S9.4 4 16 4s12 5.4 12 12-5.4 12-12 12z"}),React.createElement("path",{d:"M21.4 23L16 17.6 10.6 23 9 21.4l5.4-5.4L9 10.6 10.6 9l5.4 5.4L21.4 9l1.6 1.6-5.4 5.4 5.4 5.4z"}),props.children);});var MisuseOutline24=/*#__PURE__*/React.forwardRef(function MisuseOutline24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2C8.2 2 2 8.2 2 16s6.2 14 14 14 14-6.2 14-14S23.8 2 16 2zm0 26C9.4 28 4 22.6 4 16S9.4 4 16 4s12 5.4 12 12-5.4 12-12 12z"}),React.createElement("path",{d:"M21.4 23L16 17.6 10.6 23 9 21.4l5.4-5.4L9 10.6 10.6 9l5.4 5.4L21.4 9l1.6 1.6-5.4 5.4 5.4 5.4z"}),props.children);});var MisuseOutline20=/*#__PURE__*/React.forwardRef(function MisuseOutline20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2C8.2 2 2 8.2 2 16s6.2 14 14 14 14-6.2 14-14S23.8 2 16 2zm0 26C9.4 28 4 22.6 4 16S9.4 4 16 4s12 5.4 12 12-5.4 12-12 12z"}),React.createElement("path",{d:"M21.4 23L16 17.6 10.6 23 9 21.4l5.4-5.4L9 10.6 10.6 9l5.4 5.4L21.4 9l1.6 1.6-5.4 5.4 5.4 5.4z"}),props.children);});var Misuse32=/*#__PURE__*/React.forwardRef(function Misuse32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2C8.3 2 2 8.3 2 16s6.3 14 14 14 14-6.3 14-14S23.7 2 16 2zm5.4 21L16 17.6 10.6 23 9 21.4l5.4-5.4L9 10.6 10.6 9l5.4 5.4L21.4 9l1.6 1.6-5.4 5.4 5.4 5.4-1.6 1.6z"}),React.createElement("path",{d:"M21.4 23L16 17.6 10.6 23 9 21.4l5.4-5.4L9 10.6 10.6 9l5.4 5.4L21.4 9l1.6 1.6-5.4 5.4 5.4 5.4-1.6 1.6z","data-icon-path":"inner-path",opacity:"0"}),props.children);});var MobileAdd32=/*#__PURE__*/React.forwardRef(function MobileAdd32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 24h-4v-4h-2v4h-4v2h4v4h2v-4h4v-2z"}),React.createElement("path",{d:"M10 28V10h12v7h2V6a2.002 2.002 0 0 0-2-2H10a2.002 2.002 0 0 0-2 2v22a2.002 2.002 0 0 0 2 2h6v-2zm0-22h12v2H10z"}),props.children);});var MobileAdd24=/*#__PURE__*/React.forwardRef(function MobileAdd24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 24h-4v-4h-2v4h-4v2h4v4h2v-4h4v-2z"}),React.createElement("path",{d:"M10 28V10h12v7h2V6a2.002 2.002 0 0 0-2-2H10a2.002 2.002 0 0 0-2 2v22a2.002 2.002 0 0 0 2 2h6v-2zm0-22h12v2H10z"}),props.children);});var MobileAdd20=/*#__PURE__*/React.forwardRef(function MobileAdd20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 24h-4v-4h-2v4h-4v2h4v4h2v-4h4v-2z"}),React.createElement("path",{d:"M10 28V10h12v7h2V6a2.002 2.002 0 0 0-2-2H10a2.002 2.002 0 0 0-2 2v22a2.002 2.002 0 0 0 2 2h6v-2zm0-22h12v2H10z"}),props.children);});var MobileAdd16=/*#__PURE__*/React.forwardRef(function MobileAdd16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 24h-4v-4h-2v4h-4v2h4v4h2v-4h4v-2z"}),React.createElement("path",{d:"M10 28V10h12v7h2V6a2.002 2.002 0 0 0-2-2H10a2.002 2.002 0 0 0-2 2v22a2.002 2.002 0 0 0 2 2h6v-2zm0-22h12v2H10z"}),props.children);});var MobileCheck32=/*#__PURE__*/React.forwardRef(function MobileCheck32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 27.18l-2.59-2.59L16 26l4 4 8-8-1.41-1.41L20 27.18z"}),React.createElement("path",{d:"M10 28V10h12v9h2V6a2.002 2.002 0 0 0-2-2H10a2.002 2.002 0 0 0-2 2v22a2.002 2.002 0 0 0 2 2h4v-2zm0-22h12v2H10z"}),props.children);});var MobileCheck24=/*#__PURE__*/React.forwardRef(function MobileCheck24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 27.18l-2.59-2.59L16 26l4 4 8-8-1.41-1.41L20 27.18z"}),React.createElement("path",{d:"M10 28V10h12v9h2V6a2.002 2.002 0 0 0-2-2H10a2.002 2.002 0 0 0-2 2v22a2.002 2.002 0 0 0 2 2h4v-2zm0-22h12v2H10z"}),props.children);});var MobileCheck20=/*#__PURE__*/React.forwardRef(function MobileCheck20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 27.18l-2.59-2.59L16 26l4 4 8-8-1.41-1.41L20 27.18z"}),React.createElement("path",{d:"M10 28V10h12v9h2V6a2.002 2.002 0 0 0-2-2H10a2.002 2.002 0 0 0-2 2v22a2.002 2.002 0 0 0 2 2h4v-2zm0-22h12v2H10z"}),props.children);});var MobileCheck16=/*#__PURE__*/React.forwardRef(function MobileCheck16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 27.18l-2.59-2.59L16 26l4 4 8-8-1.41-1.41L20 27.18z"}),React.createElement("path",{d:"M10 28V10h12v9h2V6a2.002 2.002 0 0 0-2-2H10a2.002 2.002 0 0 0-2 2v22a2.002 2.002 0 0 0 2 2h4v-2zm0-22h12v2H10z"}),props.children);});var MobileDownload32=/*#__PURE__*/React.forwardRef(function MobileDownload32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 25l-1.414-1.414L24 26.172V18h-2v8.172l-2.586-2.586L18 25l5 5 5-5z"}),React.createElement("path",{d:"M10 28V10h12v5h2V6a2.002 2.002 0 0 0-2-2H10a2.002 2.002 0 0 0-2 2v22a2.002 2.002 0 0 0 2 2h6v-2zm0-22h12v2H10z"}),props.children);});var MobileDownload24=/*#__PURE__*/React.forwardRef(function MobileDownload24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 25l-1.414-1.414L24 26.172V18h-2v8.172l-2.586-2.586L18 25l5 5 5-5z"}),React.createElement("path",{d:"M10 28V10h12v5h2V6a2.002 2.002 0 0 0-2-2H10a2.002 2.002 0 0 0-2 2v22a2.002 2.002 0 0 0 2 2h6v-2zm0-22h12v2H10z"}),props.children);});var MobileDownload20=/*#__PURE__*/React.forwardRef(function MobileDownload20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 25l-1.414-1.414L24 26.172V18h-2v8.172l-2.586-2.586L18 25l5 5 5-5z"}),React.createElement("path",{d:"M10 28V10h12v5h2V6a2.002 2.002 0 0 0-2-2H10a2.002 2.002 0 0 0-2 2v22a2.002 2.002 0 0 0 2 2h6v-2zm0-22h12v2H10z"}),props.children);});var MobileDownload16=/*#__PURE__*/React.forwardRef(function MobileDownload16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 25l-1.414-1.414L24 26.172V18h-2v8.172l-2.586-2.586L18 25l5 5 5-5z"}),React.createElement("path",{d:"M10 28V10h12v5h2V6a2.002 2.002 0 0 0-2-2H10a2.002 2.002 0 0 0-2 2v22a2.002 2.002 0 0 0 2 2h6v-2zm0-22h12v2H10z"}),props.children);});var MobileLandscape32=/*#__PURE__*/React.forwardRef(function MobileLandscape32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M3 10v12a2.002 2.002 0 0 0 2 2h22a2.002 2.002 0 0 0 2-2V10a2.003 2.003 0 0 0-2-2H5a2.002 2.002 0 0 0-2 2zm2 0h2v12H5zm22 12H9V10h18z"}),props.children);});var MobileLandscape24=/*#__PURE__*/React.forwardRef(function MobileLandscape24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M3 10v12a2.002 2.002 0 0 0 2 2h22a2.002 2.002 0 0 0 2-2V10a2.003 2.003 0 0 0-2-2H5a2.002 2.002 0 0 0-2 2zm2 0h2v12H5zm22 12H9V10h18z"}),props.children);});var MobileLandscape20=/*#__PURE__*/React.forwardRef(function MobileLandscape20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M3 10v12a2.002 2.002 0 0 0 2 2h22a2.002 2.002 0 0 0 2-2V10a2.003 2.003 0 0 0-2-2H5a2.002 2.002 0 0 0-2 2zm2 0h2v12H5zm22 12H9V10h18z"}),props.children);});var MobileLandscape16=/*#__PURE__*/React.forwardRef(function MobileLandscape16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M3 10v12a2.002 2.002 0 0 0 2 2h22a2.002 2.002 0 0 0 2-2V10a2.003 2.003 0 0 0-2-2H5a2.002 2.002 0 0 0-2 2zm2 0h2v12H5zm22 12H9V10h18z"}),props.children);});var Mobile32=/*#__PURE__*/React.forwardRef(function Mobile32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22 4H10a2.002 2.002 0 0 0-2 2v22a2.002 2.002 0 0 0 2 2h12a2.003 2.003 0 0 0 2-2V6a2.002 2.002 0 0 0-2-2zm0 2v2H10V6zM10 28V10h12v18z"}),props.children);});var Mobile24=/*#__PURE__*/React.forwardRef(function Mobile24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22 4H10a2.002 2.002 0 0 0-2 2v22a2.002 2.002 0 0 0 2 2h12a2.003 2.003 0 0 0 2-2V6a2.002 2.002 0 0 0-2-2zm0 2v2H10V6zM10 28V10h12v18z"}),props.children);});var Mobile20=/*#__PURE__*/React.forwardRef(function Mobile20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22 4H10a2.002 2.002 0 0 0-2 2v22a2.002 2.002 0 0 0 2 2h12a2.003 2.003 0 0 0 2-2V6a2.002 2.002 0 0 0-2-2zm0 2v2H10V6zM10 28V10h12v18z"}),props.children);});var Mobile16=/*#__PURE__*/React.forwardRef(function Mobile16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22 4H10a2.002 2.002 0 0 0-2 2v22a2.002 2.002 0 0 0 2 2h12a2.003 2.003 0 0 0 2-2V6a2.002 2.002 0 0 0-2-2zm0 2v2H10V6zM10 28V10h12v18z"}),props.children);});var ModelReference32=/*#__PURE__*/React.forwardRef(function ModelReference32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4 21v2h3.586L2 28.586 3.414 30 9 24.414V28h2v-7H4z"}),React.createElement("path",{d:"M23.5 4h-15l-6 8-.784 1.045L6.877 19l1.324-1.526L5.19 14h5.112L16 29.527l14.284-16.482zm3.5 8h-5.446l-3.75-6H22.5zm-7.804 0h-6.392L16 6.887zM5 12l4.5-6h4.696l-3.75 6zm10.999 11.721L12.432 14h7.136zm1.944.51L21.698 14h5.112z"}),props.children);});var ModelReference24=/*#__PURE__*/React.forwardRef(function ModelReference24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4 21v2h3.586L2 28.586 3.414 30 9 24.414V28h2v-7H4z"}),React.createElement("path",{d:"M23.5 4h-15l-6 8-.784 1.045L6.877 19l1.324-1.526L5.19 14h5.112L16 29.527l14.284-16.482zm3.5 8h-5.446l-3.75-6H22.5zm-7.804 0h-6.392L16 6.887zM5 12l4.5-6h4.696l-3.75 6zm10.999 11.721L12.432 14h7.136zm1.944.51L21.698 14h5.112z"}),props.children);});var ModelReference20=/*#__PURE__*/React.forwardRef(function ModelReference20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4 21v2h3.586L2 28.586 3.414 30 9 24.414V28h2v-7H4z"}),React.createElement("path",{d:"M23.5 4h-15l-6 8-.784 1.045L6.877 19l1.324-1.526L5.19 14h5.112L16 29.527l14.284-16.482zm3.5 8h-5.446l-3.75-6H22.5zm-7.804 0h-6.392L16 6.887zM5 12l4.5-6h4.696l-3.75 6zm10.999 11.721L12.432 14h7.136zm1.944.51L21.698 14h5.112z"}),props.children);});var ModelReference16=/*#__PURE__*/React.forwardRef(function ModelReference16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4 21v2h3.586L2 28.586 3.414 30 9 24.414V28h2v-7H4z"}),React.createElement("path",{d:"M23.5 4h-15l-6 8-.784 1.045L6.877 19l1.324-1.526L5.19 14h5.112L16 29.527l14.284-16.482zm3.5 8h-5.446l-3.75-6H22.5zm-7.804 0h-6.392L16 6.887zM5 12l4.5-6h4.696l-3.75 6zm10.999 11.721L12.432 14h7.136zm1.944.51L21.698 14h5.112z"}),props.children);});var Model32=/*#__PURE__*/React.forwardRef(function Model32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.5 4h-15l-6.784 9.045L16 29.527l14.284-16.482zm3.5 8h-5.446l-3.75-6H22.5zm-16.698 2l3.754 10.23L5.19 14zm2.13 0h7.136l-3.569 9.721zm.373-2L16 6.887 19.196 12zm8.893 2h5.112l-8.867 10.231zM9.5 6h4.696l-3.75 6H5z"}),props.children);});var Model24=/*#__PURE__*/React.forwardRef(function Model24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.5 4h-15l-6.784 9.045L16 29.527l14.284-16.482zm3.5 8h-5.446l-3.75-6H22.5zm-16.698 2l3.754 10.23L5.19 14zm2.13 0h7.136l-3.569 9.721zm.373-2L16 6.887 19.196 12zm8.893 2h5.112l-8.867 10.231zM9.5 6h4.696l-3.75 6H5z"}),props.children);});var Model20=/*#__PURE__*/React.forwardRef(function Model20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.5 4h-15l-6.784 9.045L16 29.527l14.284-16.482zm3.5 8h-5.446l-3.75-6H22.5zm-16.698 2l3.754 10.23L5.19 14zm2.13 0h7.136l-3.569 9.721zm.373-2L16 6.887 19.196 12zm8.893 2h5.112l-8.867 10.231zM9.5 6h4.696l-3.75 6H5z"}),props.children);});var Model16=/*#__PURE__*/React.forwardRef(function Model16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.5 4h-15l-6.784 9.045L16 29.527l14.284-16.482zm3.5 8h-5.446l-3.75-6H22.5zm-16.698 2l3.754 10.23L5.19 14zm2.13 0h7.136l-3.569 9.721zm.373-2L16 6.887 19.196 12zm8.893 2h5.112l-8.867 10.231zM9.5 6h4.696l-3.75 6H5z"}),props.children);});var Move32=/*#__PURE__*/React.forwardRef(function Move32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 11l-1.41 1.41L26.17 15H17V5.83l2.59 2.58L21 7l-5-5-5 5 1.41 1.41L15 5.83V15H5.83l2.58-2.59L7 11l-5 5 5 5 1.41-1.41L5.83 17H15v9.17l-2.59-2.58L11 25l5 5 5-5-1.41-1.41L17 26.17V17h9.17l-2.58 2.59L25 21l5-5-5-5z"}),props.children);});var Move24=/*#__PURE__*/React.forwardRef(function Move24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 11l-1.41 1.41L26.17 15H17V5.83l2.59 2.58L21 7l-5-5-5 5 1.41 1.41L15 5.83V15H5.83l2.58-2.59L7 11l-5 5 5 5 1.41-1.41L5.83 17H15v9.17l-2.59-2.58L11 25l5 5 5-5-1.41-1.41L17 26.17V17h9.17l-2.58 2.59L25 21l5-5-5-5z"}),props.children);});var Move20=/*#__PURE__*/React.forwardRef(function Move20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 11l-1.41 1.41L26.17 15H17V5.83l2.59 2.58L21 7l-5-5-5 5 1.41 1.41L15 5.83V15H5.83l2.58-2.59L7 11l-5 5 5 5 1.41-1.41L5.83 17H15v9.17l-2.59-2.58L11 25l5 5 5-5-1.41-1.41L17 26.17V17h9.17l-2.58 2.59L25 21l5-5-5-5z"}),props.children);});var Move16=/*#__PURE__*/React.forwardRef(function Move16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 11l-1.41 1.41L26.17 15H17V5.83l2.59 2.58L21 7l-5-5-5 5 1.41 1.41L15 5.83V15H5.83l2.58-2.59L7 11l-5 5 5 5 1.41-1.41L5.83 17H15v9.17l-2.59-2.58L11 25l5 5 5-5-1.41-1.41L17 26.17V17h9.17l-2.58 2.59L25 21l5-5-5-5z"}),props.children);});var Movement32=/*#__PURE__*/React.forwardRef(function Movement32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 20l-1.41 1.41L26.17 25H10a4 4 0 0 1 0-8h12a6 6 0 0 0 0-12H5.83l3.58-3.59L8 0 2 6l6 6 1.41-1.41L5.83 7H22a4 4 0 0 1 0 8H10a6 6 0 0 0 0 12h16.17l-3.58 3.59L24 32l6-6z"}),props.children);});var Movement24=/*#__PURE__*/React.forwardRef(function Movement24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 20l-1.41 1.41L26.17 25H10a4 4 0 0 1 0-8h12a6 6 0 0 0 0-12H5.83l3.58-3.59L8 0 2 6l6 6 1.41-1.41L5.83 7H22a4 4 0 0 1 0 8H10a6 6 0 0 0 0 12h16.17l-3.58 3.59L24 32l6-6z"}),props.children);});var Movement20=/*#__PURE__*/React.forwardRef(function Movement20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 20l-1.41 1.41L26.17 25H10a4 4 0 0 1 0-8h12a6 6 0 0 0 0-12H5.83l3.58-3.59L8 0 2 6l6 6 1.41-1.41L5.83 7H22a4 4 0 0 1 0 8H10a6 6 0 0 0 0 12h16.17l-3.58 3.59L24 32l6-6z"}),props.children);});var Movement16=/*#__PURE__*/React.forwardRef(function Movement16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24 20l-1.41 1.41L26.17 25H10a4 4 0 0 1 0-8h12a6 6 0 0 0 0-12H5.83l3.58-3.59L8 0 2 6l6 6 1.41-1.41L5.83 7H22a4 4 0 0 1 0 8H10a6 6 0 0 0 0 12h16.17l-3.58 3.59L24 32l6-6z"}),props.children);});var Music32=/*#__PURE__*/React.forwardRef(function Music32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 4H10a2.002 2.002 0 0 0-2 2v14.556A3.955 3.955 0 0 0 6 20a4 4 0 1 0 4 4V12h15v8.556A3.954 3.954 0 0 0 23 20a4 4 0 1 0 4 4V6a2.002 2.002 0 0 0-2-2zM6 26a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2zm17 0a2 2 0 1 1 2-2 2.003 2.003 0 0 1-2 2zM10 6h15v4H10z"}),props.children);});var Music24=/*#__PURE__*/React.forwardRef(function Music24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 4H10a2.002 2.002 0 0 0-2 2v14.556A3.955 3.955 0 0 0 6 20a4 4 0 1 0 4 4V12h15v8.556A3.954 3.954 0 0 0 23 20a4 4 0 1 0 4 4V6a2.002 2.002 0 0 0-2-2zM6 26a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2zm17 0a2 2 0 1 1 2-2 2.003 2.003 0 0 1-2 2zM10 6h15v4H10z"}),props.children);});var Music20=/*#__PURE__*/React.forwardRef(function Music20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 4H10a2.002 2.002 0 0 0-2 2v14.556A3.955 3.955 0 0 0 6 20a4 4 0 1 0 4 4V12h15v8.556A3.954 3.954 0 0 0 23 20a4 4 0 1 0 4 4V6a2.002 2.002 0 0 0-2-2zM6 26a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2zm17 0a2 2 0 1 1 2-2 2.003 2.003 0 0 1-2 2zM10 6h15v4H10z"}),props.children);});var Music16=/*#__PURE__*/React.forwardRef(function Music16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25 4H10a2.002 2.002 0 0 0-2 2v14.556A3.955 3.955 0 0 0 6 20a4 4 0 1 0 4 4V12h15v8.556A3.954 3.954 0 0 0 23 20a4 4 0 1 0 4 4V6a2.002 2.002 0 0 0-2-2zM6 26a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2zm17 0a2 2 0 1 1 2-2 2.003 2.003 0 0 1-2 2zM10 6h15v4H10z"}),props.children);});var Network_132=/*#__PURE__*/React.forwardRef(function Network_132(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 20a4 4 0 1 1 4-4 4.005 4.005 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2zM5 20a4 4 0 1 1 4-4 4.005 4.005 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2zm5 17a4 4 0 1 1 4-4 4.005 4.005 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2zm12 6a4 4 0 1 1 4-4 4.005 4.005 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2zm5-5a4 4 0 1 1 4-4 4.005 4.005 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2zm-5-5a4 4 0 1 1 4-4 4.005 4.005 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2zM10 9a4 4 0 1 1 4-4 4.005 4.005 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2z"}),props.children);});var Network_124=/*#__PURE__*/React.forwardRef(function Network_124(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 20a4 4 0 1 1 4-4 4.005 4.005 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2zM5 20a4 4 0 1 1 4-4 4.005 4.005 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2zm5 17a4 4 0 1 1 4-4 4.005 4.005 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2zm12 6a4 4 0 1 1 4-4 4.005 4.005 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2zm5-5a4 4 0 1 1 4-4 4.005 4.005 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2zm-5-5a4 4 0 1 1 4-4 4.005 4.005 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2zM10 9a4 4 0 1 1 4-4 4.005 4.005 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2z"}),props.children);});var Network_120=/*#__PURE__*/React.forwardRef(function Network_120(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 20a4 4 0 1 1 4-4 4.005 4.005 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2zM5 20a4 4 0 1 1 4-4 4.005 4.005 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2zm5 17a4 4 0 1 1 4-4 4.005 4.005 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2zm12 6a4 4 0 1 1 4-4 4.005 4.005 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2zm5-5a4 4 0 1 1 4-4 4.005 4.005 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2zm-5-5a4 4 0 1 1 4-4 4.005 4.005 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2zM10 9a4 4 0 1 1 4-4 4.005 4.005 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2z"}),props.children);});var Network_116=/*#__PURE__*/React.forwardRef(function Network_116(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 20a4 4 0 1 1 4-4 4.005 4.005 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2zM5 20a4 4 0 1 1 4-4 4.005 4.005 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2zm5 17a4 4 0 1 1 4-4 4.005 4.005 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2zm12 6a4 4 0 1 1 4-4 4.005 4.005 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2zm5-5a4 4 0 1 1 4-4 4.005 4.005 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2zm-5-5a4 4 0 1 1 4-4 4.005 4.005 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2zM10 9a4 4 0 1 1 4-4 4.005 4.005 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2z"}),props.children);});var Network_232=/*#__PURE__*/React.forwardRef(function Network_232(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17 17h5.142a4 4 0 1 0 0-2H17V7h5.142a4 4 0 1 0 0-2H17a2.002 2.002 0 0 0-2 2v8H9.858a4 4 0 1 0 0 2H15v8a2.002 2.002 0 0 0 2 2h5.142a4 4 0 1 0 0-2H17zm9-3a2 2 0 1 1-2 2 2.002 2.002 0 0 1 2-2zm0-10a2 2 0 1 1-2 2 2.002 2.002 0 0 1 2-2zM6 18a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2zm20 6a2 2 0 1 1-2 2 2.002 2.002 0 0 1 2-2z"}),props.children);});var Network_224=/*#__PURE__*/React.forwardRef(function Network_224(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17 17h5.142a4 4 0 1 0 0-2H17V7h5.142a4 4 0 1 0 0-2H17a2.002 2.002 0 0 0-2 2v8H9.858a4 4 0 1 0 0 2H15v8a2.002 2.002 0 0 0 2 2h5.142a4 4 0 1 0 0-2H17zm9-3a2 2 0 1 1-2 2 2.002 2.002 0 0 1 2-2zm0-10a2 2 0 1 1-2 2 2.002 2.002 0 0 1 2-2zM6 18a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2zm20 6a2 2 0 1 1-2 2 2.002 2.002 0 0 1 2-2z"}),props.children);});var Network_220=/*#__PURE__*/React.forwardRef(function Network_220(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17 17h5.142a4 4 0 1 0 0-2H17V7h5.142a4 4 0 1 0 0-2H17a2.002 2.002 0 0 0-2 2v8H9.858a4 4 0 1 0 0 2H15v8a2.002 2.002 0 0 0 2 2h5.142a4 4 0 1 0 0-2H17zm9-3a2 2 0 1 1-2 2 2.002 2.002 0 0 1 2-2zm0-10a2 2 0 1 1-2 2 2.002 2.002 0 0 1 2-2zM6 18a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2zm20 6a2 2 0 1 1-2 2 2.002 2.002 0 0 1 2-2z"}),props.children);});var Network_216=/*#__PURE__*/React.forwardRef(function Network_216(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17 17h5.142a4 4 0 1 0 0-2H17V7h5.142a4 4 0 1 0 0-2H17a2.002 2.002 0 0 0-2 2v8H9.858a4 4 0 1 0 0 2H15v8a2.002 2.002 0 0 0 2 2h5.142a4 4 0 1 0 0-2H17zm9-3a2 2 0 1 1-2 2 2.002 2.002 0 0 1 2-2zm0-10a2 2 0 1 1-2 2 2.002 2.002 0 0 1 2-2zM6 18a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2zm20 6a2 2 0 1 1-2 2 2.002 2.002 0 0 1 2-2z"}),props.children);});var Network_332=/*#__PURE__*/React.forwardRef(function Network_332(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 30h-8v-8h8zm-6-2h4v-4h-4zm-4-1H8a6 6 0 0 1 0-12h2v2H8a4 4 0 0 0 0 8h12z"}),React.createElement("path",{d:"M20 20h-8v-8h8zm-6-2h4v-4h-4z"}),React.createElement("path",{d:"M24 17h-2v-2h2a4 4 0 0 0 0-8H12V5h12a6 6 0 0 1 0 12zm-14-7H2V2h8zM4 8h4V4H4z"}),props.children);});var Network_324=/*#__PURE__*/React.forwardRef(function Network_324(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 30h-8v-8h8zm-6-2h4v-4h-4zm-4-1H8a6 6 0 0 1 0-12h2v2H8a4 4 0 0 0 0 8h12z"}),React.createElement("path",{d:"M20 20h-8v-8h8zm-6-2h4v-4h-4z"}),React.createElement("path",{d:"M24 17h-2v-2h2a4 4 0 0 0 0-8H12V5h12a6 6 0 0 1 0 12zm-14-7H2V2h8zM4 8h4V4H4z"}),props.children);});var Network_320=/*#__PURE__*/React.forwardRef(function Network_320(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 30h-8v-8h8zm-6-2h4v-4h-4zm-4-1H8a6 6 0 0 1 0-12h2v2H8a4 4 0 0 0 0 8h12z"}),React.createElement("path",{d:"M20 20h-8v-8h8zm-6-2h4v-4h-4z"}),React.createElement("path",{d:"M24 17h-2v-2h2a4 4 0 0 0 0-8H12V5h12a6 6 0 0 1 0 12zm-14-7H2V2h8zM4 8h4V4H4z"}),props.children);});var Network_316=/*#__PURE__*/React.forwardRef(function Network_316(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 30h-8v-8h8zm-6-2h4v-4h-4zm-4-1H8a6 6 0 0 1 0-12h2v2H8a4 4 0 0 0 0 8h12z"}),React.createElement("path",{d:"M20 20h-8v-8h8zm-6-2h4v-4h-4z"}),React.createElement("path",{d:"M24 17h-2v-2h2a4 4 0 0 0 0-8H12V5h12a6 6 0 0 1 0 12zm-14-7H2V2h8zM4 8h4V4H4z"}),props.children);});var Network_432=/*#__PURE__*/React.forwardRef(function Network_432(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"21",cy:"26",r:"2"}),React.createElement("circle",{cx:"21",cy:"6",r:"2"}),React.createElement("circle",{cx:"4",cy:"16",r:"2"}),React.createElement("path",{d:"M28 12a3.996 3.996 0 0 0-3.858 3h-4.284a3.966 3.966 0 0 0-5.491-2.643l-3.177-3.97A3.963 3.963 0 0 0 12 6a4 4 0 1 0-4 4 3.96 3.96 0 0 0 1.634-.357l3.176 3.97a3.924 3.924 0 0 0 0 4.774l-3.176 3.97A3.96 3.96 0 0 0 8 22a4 4 0 1 0 4 4 3.962 3.962 0 0 0-.81-2.387l3.176-3.97A3.966 3.966 0 0 0 19.858 17h4.284A3.993 3.993 0 1 0 28 12zM6 6a2 2 0 1 1 2 2 2.002 2.002 0 0 1-2-2zm2 22a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2zm8-10a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2zm12 0a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2z"}),props.children);});var Network_424=/*#__PURE__*/React.forwardRef(function Network_424(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"21",cy:"26",r:"2"}),React.createElement("circle",{cx:"21",cy:"6",r:"2"}),React.createElement("circle",{cx:"4",cy:"16",r:"2"}),React.createElement("path",{d:"M28 12a3.996 3.996 0 0 0-3.858 3h-4.284a3.966 3.966 0 0 0-5.491-2.643l-3.177-3.97A3.963 3.963 0 0 0 12 6a4 4 0 1 0-4 4 3.96 3.96 0 0 0 1.634-.357l3.176 3.97a3.924 3.924 0 0 0 0 4.774l-3.176 3.97A3.96 3.96 0 0 0 8 22a4 4 0 1 0 4 4 3.962 3.962 0 0 0-.81-2.387l3.176-3.97A3.966 3.966 0 0 0 19.858 17h4.284A3.993 3.993 0 1 0 28 12zM6 6a2 2 0 1 1 2 2 2.002 2.002 0 0 1-2-2zm2 22a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2zm8-10a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2zm12 0a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2z"}),props.children);});var Network_420=/*#__PURE__*/React.forwardRef(function Network_420(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"21",cy:"26",r:"2"}),React.createElement("circle",{cx:"21",cy:"6",r:"2"}),React.createElement("circle",{cx:"4",cy:"16",r:"2"}),React.createElement("path",{d:"M28 12a3.996 3.996 0 0 0-3.858 3h-4.284a3.966 3.966 0 0 0-5.491-2.643l-3.177-3.97A3.963 3.963 0 0 0 12 6a4 4 0 1 0-4 4 3.96 3.96 0 0 0 1.634-.357l3.176 3.97a3.924 3.924 0 0 0 0 4.774l-3.176 3.97A3.96 3.96 0 0 0 8 22a4 4 0 1 0 4 4 3.962 3.962 0 0 0-.81-2.387l3.176-3.97A3.966 3.966 0 0 0 19.858 17h4.284A3.993 3.993 0 1 0 28 12zM6 6a2 2 0 1 1 2 2 2.002 2.002 0 0 1-2-2zm2 22a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2zm8-10a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2zm12 0a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2z"}),props.children);});var Network_416=/*#__PURE__*/React.forwardRef(function Network_416(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"21",cy:"26",r:"2"}),React.createElement("circle",{cx:"21",cy:"6",r:"2"}),React.createElement("circle",{cx:"4",cy:"16",r:"2"}),React.createElement("path",{d:"M28 12a3.996 3.996 0 0 0-3.858 3h-4.284a3.966 3.966 0 0 0-5.491-2.643l-3.177-3.97A3.963 3.963 0 0 0 12 6a4 4 0 1 0-4 4 3.96 3.96 0 0 0 1.634-.357l3.176 3.97a3.924 3.924 0 0 0 0 4.774l-3.176 3.97A3.96 3.96 0 0 0 8 22a4 4 0 1 0 4 4 3.962 3.962 0 0 0-.81-2.387l3.176-3.97A3.966 3.966 0 0 0 19.858 17h4.284A3.993 3.993 0 1 0 28 12zM6 6a2 2 0 1 1 2 2 2.002 2.002 0 0 1-2-2zm2 22a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2zm8-10a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2zm12 0a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2z"}),props.children);});var NewTab32=/*#__PURE__*/React.forwardRef(function NewTab32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 26H6V6h9V4H6a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2v-9h-2zm0-20V2h-2v4h-4v2h4v4h2V8h4V6h-4z"}),props.children);});var NewTab24=/*#__PURE__*/React.forwardRef(function NewTab24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 26H6V6h9V4H6a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2v-9h-2zm0-20V2h-2v4h-4v2h4v4h2V8h4V6h-4z"}),props.children);});var NewTab20=/*#__PURE__*/React.forwardRef(function NewTab20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 26H6V6h9V4H6a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2v-9h-2zm0-20V2h-2v4h-4v2h4v4h2V8h4V6h-4z"}),props.children);});var NoImage32=/*#__PURE__*/React.forwardRef(function NoImage32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 3.414L28.586 2 2 28.586 3.414 30l2-2H26a2.003 2.003 0 0 0 2-2V5.414zM26 26H7.414l7.793-7.793 2.379 2.379a2 2 0 0 0 2.828 0L22 19l4 3.997zm0-5.832l-2.586-2.586a2 2 0 0 0-2.828 0L19 19.168l-2.377-2.377L26 7.414zM6 22v-3l5-4.997 1.373 1.374 1.416-1.416-1.375-1.375a2 2 0 0 0-2.828 0L6 16.172V6h16V4H6a2.002 2.002 0 0 0-2 2v16z"}),props.children);});var NoImage24=/*#__PURE__*/React.forwardRef(function NoImage24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 3.414L28.586 2 2 28.586 3.414 30l2-2H26a2.003 2.003 0 0 0 2-2V5.414zM26 26H7.414l7.793-7.793 2.379 2.379a2 2 0 0 0 2.828 0L22 19l4 3.997zm0-5.832l-2.586-2.586a2 2 0 0 0-2.828 0L19 19.168l-2.377-2.377L26 7.414zM6 22v-3l5-4.997 1.373 1.374 1.416-1.416-1.375-1.375a2 2 0 0 0-2.828 0L6 16.172V6h16V4H6a2.002 2.002 0 0 0-2 2v16z"}),props.children);});var NoImage20=/*#__PURE__*/React.forwardRef(function NoImage20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 3.414L28.586 2 2 28.586 3.414 30l2-2H26a2.003 2.003 0 0 0 2-2V5.414zM26 26H7.414l7.793-7.793 2.379 2.379a2 2 0 0 0 2.828 0L22 19l4 3.997zm0-5.832l-2.586-2.586a2 2 0 0 0-2.828 0L19 19.168l-2.377-2.377L26 7.414zM6 22v-3l5-4.997 1.373 1.374 1.416-1.416-1.375-1.375a2 2 0 0 0-2.828 0L6 16.172V6h16V4H6a2.002 2.002 0 0 0-2 2v16z"}),props.children);});var NoImage16=/*#__PURE__*/React.forwardRef(function NoImage16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 3.414L28.586 2 2 28.586 3.414 30l2-2H26a2.003 2.003 0 0 0 2-2V5.414zM26 26H7.414l7.793-7.793 2.379 2.379a2 2 0 0 0 2.828 0L22 19l4 3.997zm0-5.832l-2.586-2.586a2 2 0 0 0-2.828 0L19 19.168l-2.377-2.377L26 7.414zM6 22v-3l5-4.997 1.373 1.374 1.416-1.416-1.375-1.375a2 2 0 0 0-2.828 0L6 16.172V6h16V4H6a2.002 2.002 0 0 0-2 2v16z"}),props.children);});var NoTicket32=/*#__PURE__*/React.forwardRef(function NoTicket32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 6h-.586L30 3.414 28.586 2 2 28.586 3.414 30l4-4H28a2.003 2.003 0 0 0 2-2v-5a1 1 0 0 0-1-1 2 2 0 0 1 0-4 1 1 0 0 0 1-1V8a2.002 2.002 0 0 0-2-2zm0 6.127a4 4 0 0 0 0 7.746V24h-7v-3h-2v3H9.414L19 14.414V19h2v-6.586L25.414 8H28zm-24 0V8h15V6H4a2.002 2.002 0 0 0-2 2v5a1 1 0 0 0 1 1 2 2 0 0 1 0 4 1 1 0 0 0-1 1v5h2v-4.127a4 4 0 0 0 0-7.747z"}),props.children);});var NoTicket24=/*#__PURE__*/React.forwardRef(function NoTicket24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 6h-.586L30 3.414 28.586 2 2 28.586 3.414 30l4-4H28a2.003 2.003 0 0 0 2-2v-5a1 1 0 0 0-1-1 2 2 0 0 1 0-4 1 1 0 0 0 1-1V8a2.002 2.002 0 0 0-2-2zm0 6.127a4 4 0 0 0 0 7.746V24h-7v-3h-2v3H9.414L19 14.414V19h2v-6.586L25.414 8H28zm-24 0V8h15V6H4a2.002 2.002 0 0 0-2 2v5a1 1 0 0 0 1 1 2 2 0 0 1 0 4 1 1 0 0 0-1 1v5h2v-4.127a4 4 0 0 0 0-7.747z"}),props.children);});var NoTicket20=/*#__PURE__*/React.forwardRef(function NoTicket20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 6h-.586L30 3.414 28.586 2 2 28.586 3.414 30l4-4H28a2.003 2.003 0 0 0 2-2v-5a1 1 0 0 0-1-1 2 2 0 0 1 0-4 1 1 0 0 0 1-1V8a2.002 2.002 0 0 0-2-2zm0 6.127a4 4 0 0 0 0 7.746V24h-7v-3h-2v3H9.414L19 14.414V19h2v-6.586L25.414 8H28zm-24 0V8h15V6H4a2.002 2.002 0 0 0-2 2v5a1 1 0 0 0 1 1 2 2 0 0 1 0 4 1 1 0 0 0-1 1v5h2v-4.127a4 4 0 0 0 0-7.747z"}),props.children);});var NoTicket16=/*#__PURE__*/React.forwardRef(function NoTicket16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 6h-.586L30 3.414 28.586 2 2 28.586 3.414 30l4-4H28a2.003 2.003 0 0 0 2-2v-5a1 1 0 0 0-1-1 2 2 0 0 1 0-4 1 1 0 0 0 1-1V8a2.002 2.002 0 0 0-2-2zm0 6.127a4 4 0 0 0 0 7.746V24h-7v-3h-2v3H9.414L19 14.414V19h2v-6.586L25.414 8H28zm-24 0V8h15V6H4a2.002 2.002 0 0 0-2 2v5a1 1 0 0 0 1 1 2 2 0 0 1 0 4 1 1 0 0 0-1 1v5h2v-4.127a4 4 0 0 0 0-7.747z"}),props.children);});var NotSentFilled32=/*#__PURE__*/React.forwardRef(function NotSentFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 28.59L3.41 2 2 3.41l8 8-7.34 2.65a1 1 0 0 0 0 1.87l8.59 3.43L14.59 16 16 17.41l-3.37 3.37 3.44 8.59A1 1 0 0 0 17 30a1 1 0 0 0 .92-.66L20.6 22l8 8zm-7.51-11.76l3.45-9.49a1 1 0 0 0-1.28-1.28l-9.49 3.45z"}),props.children);});var NotSentFilled24=/*#__PURE__*/React.forwardRef(function NotSentFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 28.59L3.41 2 2 3.41l8 8-7.34 2.65a1 1 0 0 0 0 1.87l8.59 3.43L14.59 16 16 17.41l-3.37 3.37 3.44 8.59A1 1 0 0 0 17 30a1 1 0 0 0 .92-.66L20.6 22l8 8zm-7.51-11.76l3.45-9.49a1 1 0 0 0-1.28-1.28l-9.49 3.45z"}),props.children);});var NotSentFilled20=/*#__PURE__*/React.forwardRef(function NotSentFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 28.59L3.41 2 2 3.41l8 8-7.34 2.65a1 1 0 0 0 0 1.87l8.59 3.43L14.59 16 16 17.41l-3.37 3.37 3.44 8.59A1 1 0 0 0 17 30a1 1 0 0 0 .92-.66L20.6 22l8 8zm-7.51-11.76l3.45-9.49a1 1 0 0 0-1.28-1.28l-9.49 3.45z"}),props.children);});var NotSentFilled16=/*#__PURE__*/React.forwardRef(function NotSentFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 28.59L3.41 2 2 3.41l8 8-7.34 2.65a1 1 0 0 0 0 1.87l8.59 3.43L14.59 16 16 17.41l-3.37 3.37 3.44 8.59A1 1 0 0 0 17 30a1 1 0 0 0 .92-.66L20.6 22l8 8zm-7.51-11.76l3.45-9.49a1 1 0 0 0-1.28-1.28l-9.49 3.45z"}),props.children);});var NotSent32=/*#__PURE__*/React.forwardRef(function NotSent32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 28.59L3.41 2 2 3.41l8 8-7.34 2.65a1 1 0 0 0 0 1.87l9.6 3.84 3.84 9.6a1 1 0 0 0 .9.63 1 1 0 0 0 .92-.66L20.6 22l8 8zM5.8 15l5.74-2 3.05 3-1.83 1.83zM17 26.2l-2.79-7L16 17.41l3 3.05zm-1.31-14.75l7.64-2.78-2.78 7.64 1.56 1.56 3.83-10.53a1 1 0 0 0-1.28-1.28L14.13 9.89z"}),props.children);});var NotSent24=/*#__PURE__*/React.forwardRef(function NotSent24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 28.59L3.41 2 2 3.41l8 8-7.34 2.65a1 1 0 0 0 0 1.87l9.6 3.84 3.84 9.6a1 1 0 0 0 .9.63 1 1 0 0 0 .92-.66L20.6 22l8 8zM5.8 15l5.74-2 3.05 3-1.83 1.83zM17 26.2l-2.79-7L16 17.41l3 3.05zm-1.31-14.75l7.64-2.78-2.78 7.64 1.56 1.56 3.83-10.53a1 1 0 0 0-1.28-1.28L14.13 9.89z"}),props.children);});var NotSent20=/*#__PURE__*/React.forwardRef(function NotSent20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 28.59L3.41 2 2 3.41l8 8-7.34 2.65a1 1 0 0 0 0 1.87l9.6 3.84 3.84 9.6a1 1 0 0 0 .9.63 1 1 0 0 0 .92-.66L20.6 22l8 8zM5.8 15l5.74-2 3.05 3-1.83 1.83zM17 26.2l-2.79-7L16 17.41l3 3.05zm-1.31-14.75l7.64-2.78-2.78 7.64 1.56 1.56 3.83-10.53a1 1 0 0 0-1.28-1.28L14.13 9.89z"}),props.children);});var NotSent16=/*#__PURE__*/React.forwardRef(function NotSent16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30 28.59L3.41 2 2 3.41l8 8-7.34 2.65a1 1 0 0 0 0 1.87l9.6 3.84 3.84 9.6a1 1 0 0 0 .9.63 1 1 0 0 0 .92-.66L20.6 22l8 8zM5.8 15l5.74-2 3.05 3-1.83 1.83zM17 26.2l-2.79-7L16 17.41l3 3.05zm-1.31-14.75l7.64-2.78-2.78 7.64 1.56 1.56 3.83-10.53a1 1 0 0 0-1.28-1.28L14.13 9.89z"}),props.children);});var NotebookReference32=/*#__PURE__*/React.forwardRef(function NotebookReference32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4 20v2h3.586L2 27.586 3.414 29 9 23.414V27h2v-7H4zm15-10h7v2h-7zm0 5h7v2h-7zm0 5h7v2h-7z"}),React.createElement("path",{d:"M28 5H4a2.002 2.002 0 0 0-2 2v10h2V7h11v20h13a2.002 2.002 0 0 0 2-2V7a2.002 2.002 0 0 0-2-2zM17 25V7h11l.002 18z"}),props.children);});var NotebookReference24=/*#__PURE__*/React.forwardRef(function NotebookReference24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4 20v2h3.586L2 27.586 3.414 29 9 23.414V27h2v-7H4zm15-10h7v2h-7zm0 5h7v2h-7zm0 5h7v2h-7z"}),React.createElement("path",{d:"M28 5H4a2.002 2.002 0 0 0-2 2v10h2V7h11v20h13a2.002 2.002 0 0 0 2-2V7a2.002 2.002 0 0 0-2-2zM17 25V7h11l.002 18z"}),props.children);});var NotebookReference20=/*#__PURE__*/React.forwardRef(function NotebookReference20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4 20v2h3.586L2 27.586 3.414 29 9 23.414V27h2v-7H4zm15-10h7v2h-7zm0 5h7v2h-7zm0 5h7v2h-7z"}),React.createElement("path",{d:"M28 5H4a2.002 2.002 0 0 0-2 2v10h2V7h11v20h13a2.002 2.002 0 0 0 2-2V7a2.002 2.002 0 0 0-2-2zM17 25V7h11l.002 18z"}),props.children);});var NotebookReference16=/*#__PURE__*/React.forwardRef(function NotebookReference16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4 20v2h3.586L2 27.586 3.414 29 9 23.414V27h2v-7H4zm15-10h7v2h-7zm0 5h7v2h-7zm0 5h7v2h-7z"}),React.createElement("path",{d:"M28 5H4a2.002 2.002 0 0 0-2 2v10h2V7h11v20h13a2.002 2.002 0 0 0 2-2V7a2.002 2.002 0 0 0-2-2zM17 25V7h11l.002 18z"}),props.children);});var Notebook32=/*#__PURE__*/React.forwardRef(function Notebook32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19 10h7v2h-7zm0 5h7v2h-7zm0 5h7v2h-7z"}),React.createElement("path",{d:"M28 5H4a2.002 2.002 0 0 0-2 2v18a2.002 2.002 0 0 0 2 2h24a2.003 2.003 0 0 0 2-2V7a2.002 2.002 0 0 0-2-2zM4 7h11v18H4zm13 18V7h11l.002 18z"}),props.children);});var Notebook24=/*#__PURE__*/React.forwardRef(function Notebook24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19 10h7v2h-7zm0 5h7v2h-7zm0 5h7v2h-7z"}),React.createElement("path",{d:"M28 5H4a2.002 2.002 0 0 0-2 2v18a2.002 2.002 0 0 0 2 2h24a2.003 2.003 0 0 0 2-2V7a2.002 2.002 0 0 0-2-2zM4 7h11v18H4zm13 18V7h11l.002 18z"}),props.children);});var Notebook20=/*#__PURE__*/React.forwardRef(function Notebook20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19 10h7v2h-7zm0 5h7v2h-7zm0 5h7v2h-7z"}),React.createElement("path",{d:"M28 5H4a2.002 2.002 0 0 0-2 2v18a2.002 2.002 0 0 0 2 2h24a2.003 2.003 0 0 0 2-2V7a2.002 2.002 0 0 0-2-2zM4 7h11v18H4zm13 18V7h11l.002 18z"}),props.children);});var Notebook16=/*#__PURE__*/React.forwardRef(function Notebook16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19 10h7v2h-7zm0 5h7v2h-7zm0 5h7v2h-7z"}),React.createElement("path",{d:"M28 5H4a2.002 2.002 0 0 0-2 2v18a2.002 2.002 0 0 0 2 2h24a2.003 2.003 0 0 0 2-2V7a2.002 2.002 0 0 0-2-2zM4 7h11v18H4zm13 18V7h11l.002 18z"}),props.children);});var NotificationFilled32=/*#__PURE__*/React.forwardRef(function NotificationFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28.7 20.3L26 17.6V13a10.07 10.07 0 0 0-9-10V1h-2v2a10.15 10.15 0 0 0-9 10v4.6l-2.7 2.7a.91.91 0 0 0-.3.7v3a.94.94 0 0 0 1 1h7a5 5 0 0 0 10 0h7a.94.94 0 0 0 1-1v-3a.91.91 0 0 0-.3-.7zM16 28a3 3 0 0 1-3-3h6a3 3 0 0 1-3 3z"}),props.children);});var NotificationFilled24=/*#__PURE__*/React.forwardRef(function NotificationFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28.7 20.3L26 17.6V13a10.07 10.07 0 0 0-9-10V1h-2v2a10.15 10.15 0 0 0-9 10v4.6l-2.7 2.7a.91.91 0 0 0-.3.7v3a.94.94 0 0 0 1 1h7a5 5 0 0 0 10 0h7a.94.94 0 0 0 1-1v-3a.91.91 0 0 0-.3-.7zM16 28a3 3 0 0 1-3-3h6a3 3 0 0 1-3 3z"}),props.children);});var NotificationFilled20=/*#__PURE__*/React.forwardRef(function NotificationFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28.7 20.3L26 17.6V13a10.07 10.07 0 0 0-9-10V1h-2v2a10.15 10.15 0 0 0-9 10v4.6l-2.7 2.7a.91.91 0 0 0-.3.7v3a.94.94 0 0 0 1 1h7a5 5 0 0 0 10 0h7a.94.94 0 0 0 1-1v-3a.91.91 0 0 0-.3-.7zM16 28a3 3 0 0 1-3-3h6a3 3 0 0 1-3 3z"}),props.children);});var NotificationFilled16=/*#__PURE__*/React.forwardRef(function NotificationFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28.7 20.3L26 17.6V13a10.07 10.07 0 0 0-9-10V1h-2v2a10.15 10.15 0 0 0-9 10v4.6l-2.7 2.7a.91.91 0 0 0-.3.7v3a.94.94 0 0 0 1 1h7a5 5 0 0 0 10 0h7a.94.94 0 0 0 1-1v-3a.91.91 0 0 0-.3-.7zM16 28a3 3 0 0 1-3-3h6a3 3 0 0 1-3 3z"}),props.children);});var NotificationNew32=/*#__PURE__*/React.forwardRef(function NotificationNew32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 17.6V15h-2v3a.91.91 0 0 0 .3.7l2.7 2.7V23H5v-1.6l2.7-2.7A.91.91 0 0 0 8 18v-5a8 8 0 0 1 8-8 7.89 7.89 0 0 1 4 1.09V3.8a9.71 9.71 0 0 0-3-.8V1h-2v2a10.15 10.15 0 0 0-9 10v4.6l-2.7 2.7a.91.91 0 0 0-.3.7v3a.94.94 0 0 0 1 1h7a5 5 0 0 0 10 0h7a.94.94 0 0 0 1-1v-3a.91.91 0 0 0-.3-.7zM16 28a3 3 0 0 1-3-3h6a3 3 0 0 1-3 3z"}),React.createElement("circle",{cx:"26",cy:"8",r:"4"}),props.children);});var NotificationNew24=/*#__PURE__*/React.forwardRef(function NotificationNew24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 17.6V15h-2v3a.91.91 0 0 0 .3.7l2.7 2.7V23H5v-1.6l2.7-2.7A.91.91 0 0 0 8 18v-5a8 8 0 0 1 8-8 7.89 7.89 0 0 1 4 1.09V3.8a9.71 9.71 0 0 0-3-.8V1h-2v2a10.15 10.15 0 0 0-9 10v4.6l-2.7 2.7a.91.91 0 0 0-.3.7v3a.94.94 0 0 0 1 1h7a5 5 0 0 0 10 0h7a.94.94 0 0 0 1-1v-3a.91.91 0 0 0-.3-.7zM16 28a3 3 0 0 1-3-3h6a3 3 0 0 1-3 3z"}),React.createElement("circle",{cx:"26",cy:"8",r:"4"}),props.children);});var NotificationNew20=/*#__PURE__*/React.forwardRef(function NotificationNew20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 17.6V15h-2v3a.91.91 0 0 0 .3.7l2.7 2.7V23H5v-1.6l2.7-2.7A.91.91 0 0 0 8 18v-5a8 8 0 0 1 8-8 7.89 7.89 0 0 1 4 1.09V3.8a9.71 9.71 0 0 0-3-.8V1h-2v2a10.15 10.15 0 0 0-9 10v4.6l-2.7 2.7a.91.91 0 0 0-.3.7v3a.94.94 0 0 0 1 1h7a5 5 0 0 0 10 0h7a.94.94 0 0 0 1-1v-3a.91.91 0 0 0-.3-.7zM16 28a3 3 0 0 1-3-3h6a3 3 0 0 1-3 3z"}),React.createElement("circle",{cx:"26",cy:"8",r:"4"}),props.children);});var NotificationNew16=/*#__PURE__*/React.forwardRef(function NotificationNew16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 17.6V15h-2v3a.91.91 0 0 0 .3.7l2.7 2.7V23H5v-1.6l2.7-2.7A.91.91 0 0 0 8 18v-5a8 8 0 0 1 8-8 7.89 7.89 0 0 1 4 1.09V3.8a9.71 9.71 0 0 0-3-.8V1h-2v2a10.15 10.15 0 0 0-9 10v4.6l-2.7 2.7a.91.91 0 0 0-.3.7v3a.94.94 0 0 0 1 1h7a5 5 0 0 0 10 0h7a.94.94 0 0 0 1-1v-3a.91.91 0 0 0-.3-.7zM16 28a3 3 0 0 1-3-3h6a3 3 0 0 1-3 3z"}),React.createElement("circle",{cx:"26",cy:"8",r:"4"}),props.children);});var NotificationOffFilled32=/*#__PURE__*/React.forwardRef(function NotificationOffFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 17.6V13a10 10 0 0 0-1.09-4.5L30 3.41 28.59 2 2 28.59 3.41 30l5-5H11a5 5 0 0 0 10 0h7a.94.94 0 0 0 1-1v-3a.91.91 0 0 0-.3-.7zM16 28a3 3 0 0 1-3-3h6a3 3 0 0 1-3 3zm5.63-23.28A9.78 9.78 0 0 0 17 3V1h-2v2a10.15 10.15 0 0 0-9 10v4.6l-2.7 2.7a.91.91 0 0 0-.3.7v2.34z"}),props.children);});var NotificationOffFilled24=/*#__PURE__*/React.forwardRef(function NotificationOffFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 17.6V13a10 10 0 0 0-1.09-4.5L30 3.41 28.59 2 2 28.59 3.41 30l5-5H11a5 5 0 0 0 10 0h7a.94.94 0 0 0 1-1v-3a.91.91 0 0 0-.3-.7zM16 28a3 3 0 0 1-3-3h6a3 3 0 0 1-3 3zm5.63-23.28A9.78 9.78 0 0 0 17 3V1h-2v2a10.15 10.15 0 0 0-9 10v4.6l-2.7 2.7a.91.91 0 0 0-.3.7v2.34z"}),props.children);});var NotificationOffFilled20=/*#__PURE__*/React.forwardRef(function NotificationOffFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 17.6V13a10 10 0 0 0-1.09-4.5L30 3.41 28.59 2 2 28.59 3.41 30l5-5H11a5 5 0 0 0 10 0h7a.94.94 0 0 0 1-1v-3a.91.91 0 0 0-.3-.7zM16 28a3 3 0 0 1-3-3h6a3 3 0 0 1-3 3zm5.63-23.28A9.78 9.78 0 0 0 17 3V1h-2v2a10.15 10.15 0 0 0-9 10v4.6l-2.7 2.7a.91.91 0 0 0-.3.7v2.34z"}),props.children);});var NotificationOffFilled16=/*#__PURE__*/React.forwardRef(function NotificationOffFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 17.6V13a10 10 0 0 0-1.09-4.5L30 3.41 28.59 2 2 28.59 3.41 30l5-5H11a5 5 0 0 0 10 0h7a.94.94 0 0 0 1-1v-3a.91.91 0 0 0-.3-.7zM16 28a3 3 0 0 1-3-3h6a3 3 0 0 1-3 3zm5.63-23.28A9.78 9.78 0 0 0 17 3V1h-2v2a10.15 10.15 0 0 0-9 10v4.6l-2.7 2.7a.91.91 0 0 0-.3.7v2.34z"}),props.children);});var NotificationOff32=/*#__PURE__*/React.forwardRef(function NotificationOff32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M5 23v-1.6l2.7-2.7A.91.91 0 0 0 8 18v-5a8 8 0 0 1 13-6.24l1.44-1.43A9.79 9.79 0 0 0 17 3V1h-2v2a10.15 10.15 0 0 0-9 10v4.6l-2.7 2.7a.91.91 0 0 0-.3.7v2zm21-5.4V13a10 10 0 0 0-1.09-4.5L30 3.41 28.59 2 2 28.59 3.41 30l5-5H11a5 5 0 0 0 10 0h7a.94.94 0 0 0 1-1v-3a.91.91 0 0 0-.3-.7zM16 28a3 3 0 0 1-3-3h6a3 3 0 0 1-3 3zm11-5H10.42l13-13a8.06 8.06 0 0 1 .58 3v5a.91.91 0 0 0 .3.7l2.7 2.7z"}),props.children);});var NotificationOff24=/*#__PURE__*/React.forwardRef(function NotificationOff24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M5 23v-1.6l2.7-2.7A.91.91 0 0 0 8 18v-5a8 8 0 0 1 13-6.24l1.44-1.43A9.79 9.79 0 0 0 17 3V1h-2v2a10.15 10.15 0 0 0-9 10v4.6l-2.7 2.7a.91.91 0 0 0-.3.7v2zm21-5.4V13a10 10 0 0 0-1.09-4.5L30 3.41 28.59 2 2 28.59 3.41 30l5-5H11a5 5 0 0 0 10 0h7a.94.94 0 0 0 1-1v-3a.91.91 0 0 0-.3-.7zM16 28a3 3 0 0 1-3-3h6a3 3 0 0 1-3 3zm11-5H10.42l13-13a8.06 8.06 0 0 1 .58 3v5a.91.91 0 0 0 .3.7l2.7 2.7z"}),props.children);});var NotificationOff20=/*#__PURE__*/React.forwardRef(function NotificationOff20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M5 23v-1.6l2.7-2.7A.91.91 0 0 0 8 18v-5a8 8 0 0 1 13-6.24l1.44-1.43A9.79 9.79 0 0 0 17 3V1h-2v2a10.15 10.15 0 0 0-9 10v4.6l-2.7 2.7a.91.91 0 0 0-.3.7v2zm21-5.4V13a10 10 0 0 0-1.09-4.5L30 3.41 28.59 2 2 28.59 3.41 30l5-5H11a5 5 0 0 0 10 0h7a.94.94 0 0 0 1-1v-3a.91.91 0 0 0-.3-.7zM16 28a3 3 0 0 1-3-3h6a3 3 0 0 1-3 3zm11-5H10.42l13-13a8.06 8.06 0 0 1 .58 3v5a.91.91 0 0 0 .3.7l2.7 2.7z"}),props.children);});var Notification32=/*#__PURE__*/React.forwardRef(function Notification32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28.7 20.3L26 17.6V13a10.07 10.07 0 0 0-9-10V1h-2v2a10.15 10.15 0 0 0-9 10v4.6l-2.7 2.7a.91.91 0 0 0-.3.7v3a.94.94 0 0 0 1 1h7a5 5 0 0 0 10 0h7a.94.94 0 0 0 1-1v-3a.91.91 0 0 0-.3-.7zM16 28a3 3 0 0 1-3-3h6a3 3 0 0 1-3 3zm11-5H5v-1.6l2.7-2.7A.91.91 0 0 0 8 18v-5a8 8 0 0 1 16 0v5a.91.91 0 0 0 .3.7l2.7 2.7z"}),props.children);});var Notification24=/*#__PURE__*/React.forwardRef(function Notification24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28.7 20.3L26 17.6V13a10.07 10.07 0 0 0-9-10V1h-2v2a10.15 10.15 0 0 0-9 10v4.6l-2.7 2.7a.91.91 0 0 0-.3.7v3a.94.94 0 0 0 1 1h7a5 5 0 0 0 10 0h7a.94.94 0 0 0 1-1v-3a.91.91 0 0 0-.3-.7zM16 28a3 3 0 0 1-3-3h6a3 3 0 0 1-3 3zm11-5H5v-1.6l2.7-2.7A.91.91 0 0 0 8 18v-5a8 8 0 0 1 16 0v5a.91.91 0 0 0 .3.7l2.7 2.7z"}),props.children);});var Notification20=/*#__PURE__*/React.forwardRef(function Notification20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28.7 20.3L26 17.6V13a10.07 10.07 0 0 0-9-10V1h-2v2a10.15 10.15 0 0 0-9 10v4.6l-2.7 2.7a.91.91 0 0 0-.3.7v3a.94.94 0 0 0 1 1h7a5 5 0 0 0 10 0h7a.94.94 0 0 0 1-1v-3a.91.91 0 0 0-.3-.7zM16 28a3 3 0 0 1-3-3h6a3 3 0 0 1-3 3zm11-5H5v-1.6l2.7-2.7A.91.91 0 0 0 8 18v-5a8 8 0 0 1 16 0v5a.91.91 0 0 0 .3.7l2.7 2.7z"}),props.children);});var Number_032=/*#__PURE__*/React.forwardRef(function Number_032(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 23h-4a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v10a2 2 0 0 1-2 2zm-4-12v10h4V11z"}),React.createElement("path",{d:"M15 15h2v2h-2z"}),props.children);});var Number_024=/*#__PURE__*/React.forwardRef(function Number_024(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 23h-4a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v10a2 2 0 0 1-2 2zm-4-12v10h4V11z"}),React.createElement("path",{d:"M15 15h2v2h-2z"}),props.children);});var Number_020=/*#__PURE__*/React.forwardRef(function Number_020(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 23h-4a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v10a2 2 0 0 1-2 2zm-4-12v10h4V11z"}),React.createElement("path",{d:"M15 15h2v2h-2z"}),props.children);});var Number_016=/*#__PURE__*/React.forwardRef(function Number_016(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 23h-4a2 2 0 0 1-2-2V11a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v10a2 2 0 0 1-2 2zm-4-12v10h4V11z"}),React.createElement("path",{d:"M15 15h2v2h-2z"}),props.children);});var Number_132=/*#__PURE__*/React.forwardRef(function Number_132(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12.5 22.5v-1h3v-11h-3v-1h4v12h3v1h-7z"}),React.createElement("path",{d:"M16 10v12-12m1-1h-5v2h3v10h-3v2h8v-2h-3V9z"}),props.children);});var Number_124=/*#__PURE__*/React.forwardRef(function Number_124(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12.5 22.5v-1h3v-11h-3v-1h4v12h3v1h-7z"}),React.createElement("path",{d:"M16 10v12-12m1-1h-5v2h3v10h-3v2h8v-2h-3V9z"}),props.children);});var Number_120=/*#__PURE__*/React.forwardRef(function Number_120(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12.5 22.5v-1h3v-11h-3v-1h4v12h3v1h-7z"}),React.createElement("path",{d:"M16 10v12-12m1-1h-5v2h3v10h-3v2h8v-2h-3V9z"}),props.children);});var Number_116=/*#__PURE__*/React.forwardRef(function Number_116(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12.5 22.5v-1h3v-11h-3v-1h4v12h3v1h-7z"}),React.createElement("path",{d:"M16 10v12-12m1-1h-5v2h3v10h-3v2h8v-2h-3V9z"}),props.children);});var Number_232=/*#__PURE__*/React.forwardRef(function Number_232(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 23h-8v-6a2 2 0 0 1 2-2h4v-4h-6V9h6a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2h-4v4h6z"}),props.children);});var Number_224=/*#__PURE__*/React.forwardRef(function Number_224(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 23h-8v-6a2 2 0 0 1 2-2h4v-4h-6V9h6a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2h-4v4h6z"}),props.children);});var Number_220=/*#__PURE__*/React.forwardRef(function Number_220(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 23h-8v-6a2 2 0 0 1 2-2h4v-4h-6V9h6a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2h-4v4h6z"}),props.children);});var Number_216=/*#__PURE__*/React.forwardRef(function Number_216(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 23h-8v-6a2 2 0 0 1 2-2h4v-4h-6V9h6a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2h-4v4h6z"}),props.children);});var Number_332=/*#__PURE__*/React.forwardRef(function Number_332(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 9h-6v2h6v4h-4v2h4v4h-6v2h6a2 2 0 0 0 2-2V11a2 2 0 0 0-2-2z"}),props.children);});var Number_324=/*#__PURE__*/React.forwardRef(function Number_324(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 9h-6v2h6v4h-4v2h4v4h-6v2h6a2 2 0 0 0 2-2V11a2 2 0 0 0-2-2z"}),props.children);});var Number_320=/*#__PURE__*/React.forwardRef(function Number_320(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 9h-6v2h6v4h-4v2h4v4h-6v2h6a2 2 0 0 0 2-2V11a2 2 0 0 0-2-2z"}),props.children);});var Number_316=/*#__PURE__*/React.forwardRef(function Number_316(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 9h-6v2h6v4h-4v2h4v4h-6v2h6a2 2 0 0 0 2-2V11a2 2 0 0 0-2-2z"}),props.children);});var Number_432=/*#__PURE__*/React.forwardRef(function Number_432(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17.5 22.5v-4h-5v-9h1v8h4v-8h1v8h1v1h-1v4h-1z"}),React.createElement("path",{d:"M18 10v8-8m1-1h-2v8h-3V9h-2v10h5v4h2v-4h1v-2h-1V9z"}),props.children);});var Number_424=/*#__PURE__*/React.forwardRef(function Number_424(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17.5 22.5v-4h-5v-9h1v8h4v-8h1v8h1v1h-1v4h-1z"}),React.createElement("path",{d:"M18 10v8-8m1-1h-2v8h-3V9h-2v10h5v4h2v-4h1v-2h-1V9z"}),props.children);});var Number_420=/*#__PURE__*/React.forwardRef(function Number_420(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17.5 22.5v-4h-5v-9h1v8h4v-8h1v8h1v1h-1v4h-1z"}),React.createElement("path",{d:"M18 10v8-8m1-1h-2v8h-3V9h-2v10h5v4h2v-4h1v-2h-1V9z"}),props.children);});var Number_416=/*#__PURE__*/React.forwardRef(function Number_416(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17.5 22.5v-4h-5v-9h1v8h4v-8h1v8h1v1h-1v4h-1z"}),React.createElement("path",{d:"M18 10v8-8m1-1h-2v8h-3V9h-2v10h5v4h2v-4h1v-2h-1V9z"}),props.children);});var Number_532=/*#__PURE__*/React.forwardRef(function Number_532(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 23h-6v-2h6v-4h-6V9h8v2h-6v4h4a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2z"}),props.children);});var Number_524=/*#__PURE__*/React.forwardRef(function Number_524(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 23h-6v-2h6v-4h-6V9h8v2h-6v4h4a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2z"}),props.children);});var Number_520=/*#__PURE__*/React.forwardRef(function Number_520(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 23h-6v-2h6v-4h-6V9h8v2h-6v4h4a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2z"}),props.children);});var Number_516=/*#__PURE__*/React.forwardRef(function Number_516(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 23h-6v-2h6v-4h-6V9h8v2h-6v4h4a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2z"}),props.children);});var Number_632=/*#__PURE__*/React.forwardRef(function Number_632(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 14h-4v-3h5V9h-5a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2v-5a2 2 0 0 0-2-2zm-4 7v-5h4v5z"}),props.children);});var Number_624=/*#__PURE__*/React.forwardRef(function Number_624(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 14h-4v-3h5V9h-5a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2v-5a2 2 0 0 0-2-2zm-4 7v-5h4v5z"}),props.children);});var Number_620=/*#__PURE__*/React.forwardRef(function Number_620(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 14h-4v-3h5V9h-5a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2v-5a2 2 0 0 0-2-2zm-4 7v-5h4v5z"}),props.children);});var Number_616=/*#__PURE__*/React.forwardRef(function Number_616(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 14h-4v-3h5V9h-5a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2v-5a2 2 0 0 0-2-2zm-4 7v-5h4v5z"}),props.children);});var Number_732=/*#__PURE__*/React.forwardRef(function Number_732(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 9h-8v4h2v-2h3.85L13 23h2.16L20 11V9z"}),props.children);});var Number_724=/*#__PURE__*/React.forwardRef(function Number_724(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 9h-8v4h2v-2h3.85L13 23h2.16L20 11V9z"}),props.children);});var Number_720=/*#__PURE__*/React.forwardRef(function Number_720(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 9h-8v4h2v-2h3.85L13 23h2.16L20 11V9z"}),props.children);});var Number_716=/*#__PURE__*/React.forwardRef(function Number_716(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20 9h-8v4h2v-2h3.85L13 23h2.16L20 11V9z"}),props.children);});var Number_832=/*#__PURE__*/React.forwardRef(function Number_832(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 9h-4a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2V11a2 2 0 0 0-2-2zm0 2v4h-4v-4zm-4 10v-4h4v4z"}),props.children);});var Number_824=/*#__PURE__*/React.forwardRef(function Number_824(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 9h-4a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2V11a2 2 0 0 0-2-2zm0 2v4h-4v-4zm-4 10v-4h4v4z"}),props.children);});var Number_820=/*#__PURE__*/React.forwardRef(function Number_820(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 9h-4a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2V11a2 2 0 0 0-2-2zm0 2v4h-4v-4zm-4 10v-4h4v4z"}),props.children);});var Number_816=/*#__PURE__*/React.forwardRef(function Number_816(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 9h-4a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2V11a2 2 0 0 0-2-2zm0 2v4h-4v-4zm-4 10v-4h4v4z"}),props.children);});var Number_932=/*#__PURE__*/React.forwardRef(function Number_932(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 9h-4a2 2 0 0 0-2 2v5a2 2 0 0 0 2 2h4v3h-5v2h5a2 2 0 0 0 2-2V11a2 2 0 0 0-2-2zm0 7h-4v-5h4z"}),props.children);});var Number_924=/*#__PURE__*/React.forwardRef(function Number_924(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 9h-4a2 2 0 0 0-2 2v5a2 2 0 0 0 2 2h4v3h-5v2h5a2 2 0 0 0 2-2V11a2 2 0 0 0-2-2zm0 7h-4v-5h4z"}),props.children);});var Number_920=/*#__PURE__*/React.forwardRef(function Number_920(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 9h-4a2 2 0 0 0-2 2v5a2 2 0 0 0 2 2h4v3h-5v2h5a2 2 0 0 0 2-2V11a2 2 0 0 0-2-2zm0 7h-4v-5h4z"}),props.children);});var Number_916=/*#__PURE__*/React.forwardRef(function Number_916(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 9h-4a2 2 0 0 0-2 2v5a2 2 0 0 0 2 2h4v3h-5v2h5a2 2 0 0 0 2-2V11a2 2 0 0 0-2-2zm0 7h-4v-5h4z"}),props.children);});var NumberSmall_032=/*#__PURE__*/React.forwardRef(function NumberSmall_032(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17 21h-2a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h2a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2zm-2-8v6h2v-6z"}),props.children);});var NumberSmall_024=/*#__PURE__*/React.forwardRef(function NumberSmall_024(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17 21h-2a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h2a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2zm-2-8v6h2v-6z"}),props.children);});var NumberSmall_020=/*#__PURE__*/React.forwardRef(function NumberSmall_020(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17 21h-2a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h2a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2zm-2-8v6h2v-6z"}),props.children);});var NumberSmall_016=/*#__PURE__*/React.forwardRef(function NumberSmall_016(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17 21h-2a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h2a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2zm-2-8v6h2v-6z"}),props.children);});var NumberSmall_132=/*#__PURE__*/React.forwardRef(function NumberSmall_132(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17 19v-8h-2v1h-2v2h2v5h-2v2h6v-2h-2z"}),props.children);});var NumberSmall_124=/*#__PURE__*/React.forwardRef(function NumberSmall_124(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17 19v-8h-2v1h-2v2h2v5h-2v2h6v-2h-2z"}),props.children);});var NumberSmall_120=/*#__PURE__*/React.forwardRef(function NumberSmall_120(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17 19v-8h-2v1h-2v2h2v5h-2v2h6v-2h-2z"}),props.children);});var NumberSmall_116=/*#__PURE__*/React.forwardRef(function NumberSmall_116(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17 19v-8h-2v1h-2v2h2v5h-2v2h6v-2h-2z"}),props.children);});var NumberSmall_232=/*#__PURE__*/React.forwardRef(function NumberSmall_232(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19 21h-6v-4a2 2 0 0 1 2-2h2v-2h-4v-2h4a2 2 0 0 1 2 2v2a2 2 0 0 1-2 2h-2v2h4z"}),props.children);});var NumberSmall_224=/*#__PURE__*/React.forwardRef(function NumberSmall_224(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19 21h-6v-4a2 2 0 0 1 2-2h2v-2h-4v-2h4a2 2 0 0 1 2 2v2a2 2 0 0 1-2 2h-2v2h4z"}),props.children);});var NumberSmall_220=/*#__PURE__*/React.forwardRef(function NumberSmall_220(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19 21h-6v-4a2 2 0 0 1 2-2h2v-2h-4v-2h4a2 2 0 0 1 2 2v2a2 2 0 0 1-2 2h-2v2h4z"}),props.children);});var NumberSmall_216=/*#__PURE__*/React.forwardRef(function NumberSmall_216(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19 21h-6v-4a2 2 0 0 1 2-2h2v-2h-4v-2h4a2 2 0 0 1 2 2v2a2 2 0 0 1-2 2h-2v2h4z"}),props.children);});var NumberSmall_332=/*#__PURE__*/React.forwardRef(function NumberSmall_332(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17 11h-4v2h4v2h-3v2h3v2h-4v2h4a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2z"}),props.children);});var NumberSmall_324=/*#__PURE__*/React.forwardRef(function NumberSmall_324(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17 11h-4v2h4v2h-3v2h3v2h-4v2h4a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2z"}),props.children);});var NumberSmall_320=/*#__PURE__*/React.forwardRef(function NumberSmall_320(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17 11h-4v2h4v2h-3v2h3v2h-4v2h4a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2z"}),props.children);});var NumberSmall_316=/*#__PURE__*/React.forwardRef(function NumberSmall_316(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17 11h-4v2h4v2h-3v2h3v2h-4v2h4a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2z"}),props.children);});var NumberSmall_432=/*#__PURE__*/React.forwardRef(function NumberSmall_432(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17 11v4h-2v-4h-2v6h4v4h2V11h-2z"}),props.children);});var NumberSmall_424=/*#__PURE__*/React.forwardRef(function NumberSmall_424(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17 11v4h-2v-4h-2v6h4v4h2V11h-2z"}),props.children);});var NumberSmall_420=/*#__PURE__*/React.forwardRef(function NumberSmall_420(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17 11v4h-2v-4h-2v6h4v4h2V11h-2z"}),props.children);});var NumberSmall_416=/*#__PURE__*/React.forwardRef(function NumberSmall_416(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17 11v4h-2v-4h-2v6h4v4h2V11h-2z"}),props.children);});var NumberSmall_532=/*#__PURE__*/React.forwardRef(function NumberSmall_532(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17 21h-4v-2h4v-2h-4v-6h6v2h-4v2h2a2 2 0 0 1 2 2v2a2 2 0 0 1-2 2z"}),props.children);});var NumberSmall_524=/*#__PURE__*/React.forwardRef(function NumberSmall_524(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17 21h-4v-2h4v-2h-4v-6h6v2h-4v2h2a2 2 0 0 1 2 2v2a2 2 0 0 1-2 2z"}),props.children);});var NumberSmall_520=/*#__PURE__*/React.forwardRef(function NumberSmall_520(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17 21h-4v-2h4v-2h-4v-6h6v2h-4v2h2a2 2 0 0 1 2 2v2a2 2 0 0 1-2 2z"}),props.children);});var NumberSmall_516=/*#__PURE__*/React.forwardRef(function NumberSmall_516(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17 21h-4v-2h4v-2h-4v-6h6v2h-4v2h2a2 2 0 0 1 2 2v2a2 2 0 0 1-2 2z"}),props.children);});var NumberSmall_632=/*#__PURE__*/React.forwardRef(function NumberSmall_632(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17 21h-2a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h3v2h-3v2h2a2 2 0 0 1 2 2v2a2 2 0 0 1-2 2zm-2-4v2h2v-2z"}),props.children);});var NumberSmall_624=/*#__PURE__*/React.forwardRef(function NumberSmall_624(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17 21h-2a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h3v2h-3v2h2a2 2 0 0 1 2 2v2a2 2 0 0 1-2 2zm-2-4v2h2v-2z"}),props.children);});var NumberSmall_620=/*#__PURE__*/React.forwardRef(function NumberSmall_620(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17 21h-2a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h3v2h-3v2h2a2 2 0 0 1 2 2v2a2 2 0 0 1-2 2zm-2-4v2h2v-2z"}),props.children);});var NumberSmall_616=/*#__PURE__*/React.forwardRef(function NumberSmall_616(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17 21h-2a2 2 0 0 1-2-2v-6a2 2 0 0 1 2-2h3v2h-3v2h2a2 2 0 0 1 2 2v2a2 2 0 0 1-2 2zm-2-4v2h2v-2z"}),props.children);});var NumberSmall_732=/*#__PURE__*/React.forwardRef(function NumberSmall_732(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16.44 21h-2L17 13h-2v1h-2v-3h6v2l-2.56 8z"}),props.children);});var NumberSmall_724=/*#__PURE__*/React.forwardRef(function NumberSmall_724(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16.44 21h-2L17 13h-2v1h-2v-3h6v2l-2.56 8z"}),props.children);});var NumberSmall_720=/*#__PURE__*/React.forwardRef(function NumberSmall_720(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16.44 21h-2L17 13h-2v1h-2v-3h6v2l-2.56 8z"}),props.children);});var NumberSmall_716=/*#__PURE__*/React.forwardRef(function NumberSmall_716(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16.44 21h-2L17 13h-2v1h-2v-3h6v2l-2.56 8z"}),props.children);});var NumberSmall_832=/*#__PURE__*/React.forwardRef(function NumberSmall_832(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17 11h-2a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h2a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2zm0 2v2h-2v-2zm-2 6v-2h2v2z"}),props.children);});var NumberSmall_824=/*#__PURE__*/React.forwardRef(function NumberSmall_824(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17 11h-2a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h2a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2zm0 2v2h-2v-2zm-2 6v-2h2v2z"}),props.children);});var NumberSmall_820=/*#__PURE__*/React.forwardRef(function NumberSmall_820(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17 11h-2a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h2a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2zm0 2v2h-2v-2zm-2 6v-2h2v2z"}),props.children);});var NumberSmall_816=/*#__PURE__*/React.forwardRef(function NumberSmall_816(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17 11h-2a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h2a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2zm0 2v2h-2v-2zm-2 6v-2h2v2z"}),props.children);});var NumberSmall_932=/*#__PURE__*/React.forwardRef(function NumberSmall_932(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17 21h-3v-2h3v-2h-2a2 2 0 0 1-2-2v-2a2 2 0 0 1 2-2h2a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2zm-2-8v2h2v-2z"}),props.children);});var NumberSmall_924=/*#__PURE__*/React.forwardRef(function NumberSmall_924(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17 21h-3v-2h3v-2h-2a2 2 0 0 1-2-2v-2a2 2 0 0 1 2-2h2a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2zm-2-8v2h2v-2z"}),props.children);});var NumberSmall_920=/*#__PURE__*/React.forwardRef(function NumberSmall_920(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17 21h-3v-2h3v-2h-2a2 2 0 0 1-2-2v-2a2 2 0 0 1 2-2h2a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2zm-2-8v2h2v-2z"}),props.children);});var NumberSmall_916=/*#__PURE__*/React.forwardRef(function NumberSmall_916(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17 21h-3v-2h3v-2h-2a2 2 0 0 1-2-2v-2a2 2 0 0 1 2-2h2a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2zm-2-8v2h2v-2z"}),props.children);});var Opacity32=/*#__PURE__*/React.forwardRef(function Opacity32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6 6h4v4H6zm4 4h4v4h-4zm4-4h4v4h-4zm8 0h4v4h-4zM6 14h4v4H6zm8 0h4v4h-4zm8 0h4v4h-4zM6 22h4v4H6zm8 0h4v4h-4zm8 0h4v4h-4zm-4-12h4v4h-4zm-8 8h4v4h-4zm8 0h4v4h-4z"}),props.children);});var Opacity24=/*#__PURE__*/React.forwardRef(function Opacity24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6 6h4v4H6zm4 4h4v4h-4zm4-4h4v4h-4zm8 0h4v4h-4zM6 14h4v4H6zm8 0h4v4h-4zm8 0h4v4h-4zM6 22h4v4H6zm8 0h4v4h-4zm8 0h4v4h-4zm-4-12h4v4h-4zm-8 8h4v4h-4zm8 0h4v4h-4z"}),props.children);});var Opacity20=/*#__PURE__*/React.forwardRef(function Opacity20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6 6h4v4H6zm4 4h4v4h-4zm4-4h4v4h-4zm8 0h4v4h-4zM6 14h4v4H6zm8 0h4v4h-4zm8 0h4v4h-4zM6 22h4v4H6zm8 0h4v4h-4zm8 0h4v4h-4zm-4-12h4v4h-4zm-8 8h4v4h-4zm8 0h4v4h-4z"}),props.children);});var Opacity16=/*#__PURE__*/React.forwardRef(function Opacity16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6 6h4v4H6zm4 4h4v4h-4zm4-4h4v4h-4zm8 0h4v4h-4zM6 14h4v4H6zm8 0h4v4h-4zm8 0h4v4h-4zM6 22h4v4H6zm8 0h4v4h-4zm8 0h4v4h-4zm-4-12h4v4h-4zm-8 8h4v4h-4zm8 0h4v4h-4z"}),props.children);});var OpenPanelBottom32=/*#__PURE__*/React.forwardRef(function OpenPanelBottom32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm0 2v12H4V6zM4 26v-6h24v6z"}),props.children);});var OpenPanelBottom24=/*#__PURE__*/React.forwardRef(function OpenPanelBottom24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm0 2v12H4V6zM4 26v-6h24v6z"}),props.children);});var OpenPanelBottom20=/*#__PURE__*/React.forwardRef(function OpenPanelBottom20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm0 2v12H4V6zM4 26v-6h24v6z"}),props.children);});var OpenPanelBottom16=/*#__PURE__*/React.forwardRef(function OpenPanelBottom16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm0 2v12H4V6zM4 26v-6h24v6z"}),props.children);});var OpenPanelFilledBottom32=/*#__PURE__*/React.forwardRef(function OpenPanelFilledBottom32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm0 2v12H4V6z"}),props.children);});var OpenPanelFilledBottom24=/*#__PURE__*/React.forwardRef(function OpenPanelFilledBottom24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm0 2v12H4V6z"}),props.children);});var OpenPanelFilledBottom20=/*#__PURE__*/React.forwardRef(function OpenPanelFilledBottom20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm0 2v12H4V6z"}),props.children);});var OpenPanelFilledBottom16=/*#__PURE__*/React.forwardRef(function OpenPanelFilledBottom16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm0 2v12H4V6z"}),props.children);});var OpenPanelFilledLeft32=/*#__PURE__*/React.forwardRef(function OpenPanelFilledLeft32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm0 22H12V6h16z"}),props.children);});var OpenPanelFilledLeft24=/*#__PURE__*/React.forwardRef(function OpenPanelFilledLeft24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm0 22H12V6h16z"}),props.children);});var OpenPanelFilledLeft20=/*#__PURE__*/React.forwardRef(function OpenPanelFilledLeft20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm0 22H12V6h16z"}),props.children);});var OpenPanelFilledLeft16=/*#__PURE__*/React.forwardRef(function OpenPanelFilledLeft16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm0 22H12V6h16z"}),props.children);});var OpenPanelFilledRight32=/*#__PURE__*/React.forwardRef(function OpenPanelFilledRight32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zM4 6h16v20H4z"}),props.children);});var OpenPanelFilledRight24=/*#__PURE__*/React.forwardRef(function OpenPanelFilledRight24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zM4 6h16v20H4z"}),props.children);});var OpenPanelFilledRight20=/*#__PURE__*/React.forwardRef(function OpenPanelFilledRight20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zM4 6h16v20H4z"}),props.children);});var OpenPanelFilledRight16=/*#__PURE__*/React.forwardRef(function OpenPanelFilledRight16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zM4 6h16v20H4z"}),props.children);});var OpenPanelFilledTop32=/*#__PURE__*/React.forwardRef(function OpenPanelFilledTop32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zM4 26V14h24v12z"}),props.children);});var OpenPanelFilledTop24=/*#__PURE__*/React.forwardRef(function OpenPanelFilledTop24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zM4 26V14h24v12z"}),props.children);});var OpenPanelFilledTop20=/*#__PURE__*/React.forwardRef(function OpenPanelFilledTop20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zM4 26V14h24v12z"}),props.children);});var OpenPanelFilledTop16=/*#__PURE__*/React.forwardRef(function OpenPanelFilledTop16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zM4 26V14h24v12z"}),props.children);});var OpenPanelLeft32=/*#__PURE__*/React.forwardRef(function OpenPanelLeft32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zM4 6h6v20H4zm24 20H12V6h16z"}),props.children);});var OpenPanelLeft24=/*#__PURE__*/React.forwardRef(function OpenPanelLeft24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zM4 6h6v20H4zm24 20H12V6h16z"}),props.children);});var OpenPanelLeft20=/*#__PURE__*/React.forwardRef(function OpenPanelLeft20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zM4 6h6v20H4zm24 20H12V6h16z"}),props.children);});var OpenPanelLeft16=/*#__PURE__*/React.forwardRef(function OpenPanelLeft16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zM4 6h6v20H4zm24 20H12V6h16z"}),props.children);});var OpenPanelRight32=/*#__PURE__*/React.forwardRef(function OpenPanelRight32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zM4 6h16v20H4zm24 20h-6V6h6z"}),props.children);});var OpenPanelRight24=/*#__PURE__*/React.forwardRef(function OpenPanelRight24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zM4 6h16v20H4zm24 20h-6V6h6z"}),props.children);});var OpenPanelRight20=/*#__PURE__*/React.forwardRef(function OpenPanelRight20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zM4 6h16v20H4zm24 20h-6V6h6z"}),props.children);});var OpenPanelRight16=/*#__PURE__*/React.forwardRef(function OpenPanelRight16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zM4 6h16v20H4zm24 20h-6V6h6z"}),props.children);});var OpenPanelTop32=/*#__PURE__*/React.forwardRef(function OpenPanelTop32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm0 2v6H4V6zM4 26V14h24v12z"}),props.children);});var OpenPanelTop24=/*#__PURE__*/React.forwardRef(function OpenPanelTop24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm0 2v6H4V6zM4 26V14h24v12z"}),props.children);});var OpenPanelTop20=/*#__PURE__*/React.forwardRef(function OpenPanelTop20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm0 2v6H4V6zM4 26V14h24v12z"}),props.children);});var OpenPanelTop16=/*#__PURE__*/React.forwardRef(function OpenPanelTop16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 4H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm0 2v6H4V6zM4 26V14h24v12z"}),props.children);});var OverflowMenuHorizontal32=/*#__PURE__*/React.forwardRef(function OverflowMenuHorizontal32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"6",cy:"16",r:"2"}),React.createElement("circle",{cx:"16",cy:"16",r:"2"}),React.createElement("circle",{cx:"26",cy:"16",r:"2"}),props.children);});var OverflowMenuHorizontal24=/*#__PURE__*/React.forwardRef(function OverflowMenuHorizontal24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"6",cy:"16",r:"2"}),React.createElement("circle",{cx:"16",cy:"16",r:"2"}),React.createElement("circle",{cx:"26",cy:"16",r:"2"}),props.children);});var OverflowMenuHorizontal20=/*#__PURE__*/React.forwardRef(function OverflowMenuHorizontal20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"6",cy:"16",r:"2"}),React.createElement("circle",{cx:"16",cy:"16",r:"2"}),React.createElement("circle",{cx:"26",cy:"16",r:"2"}),props.children);});var OverflowMenuVertical32=/*#__PURE__*/React.forwardRef(function OverflowMenuVertical32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"16",cy:"6",r:"2"}),React.createElement("circle",{cx:"16",cy:"16",r:"2"}),React.createElement("circle",{cx:"16",cy:"26",r:"2"}),props.children);});var OverflowMenuVertical24=/*#__PURE__*/React.forwardRef(function OverflowMenuVertical24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"16",cy:"6",r:"2"}),React.createElement("circle",{cx:"16",cy:"16",r:"2"}),React.createElement("circle",{cx:"16",cy:"26",r:"2"}),props.children);});var OverflowMenuVertical20=/*#__PURE__*/React.forwardRef(function OverflowMenuVertical20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"16",cy:"6",r:"2"}),React.createElement("circle",{cx:"16",cy:"16",r:"2"}),React.createElement("circle",{cx:"16",cy:"26",r:"2"}),props.children);});var Package32=/*#__PURE__*/React.forwardRef(function Package32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 30H6a2 2 0 0 1-2-2V16a2 2 0 0 1 2-2h3v2H6v12h20V16h-3v-2h3a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2z"}),React.createElement("path",{d:"M13 20h6v2h-6zm7.59-11.41L17 12.17V2h-2v10.17l-3.59-3.58L10 10l6 6 6-6-1.41-1.41z"}),props.children);});var Package24=/*#__PURE__*/React.forwardRef(function Package24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 30H6a2 2 0 0 1-2-2V16a2 2 0 0 1 2-2h3v2H6v12h20V16h-3v-2h3a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2z"}),React.createElement("path",{d:"M13 20h6v2h-6zm7.59-11.41L17 12.17V2h-2v10.17l-3.59-3.58L10 10l6 6 6-6-1.41-1.41z"}),props.children);});var Package20=/*#__PURE__*/React.forwardRef(function Package20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 30H6a2 2 0 0 1-2-2V16a2 2 0 0 1 2-2h3v2H6v12h20V16h-3v-2h3a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2z"}),React.createElement("path",{d:"M13 20h6v2h-6zm7.59-11.41L17 12.17V2h-2v10.17l-3.59-3.58L10 10l6 6 6-6-1.41-1.41z"}),props.children);});var Package16=/*#__PURE__*/React.forwardRef(function Package16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 30H6a2 2 0 0 1-2-2V16a2 2 0 0 1 2-2h3v2H6v12h20V16h-3v-2h3a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2z"}),React.createElement("path",{d:"M13 20h6v2h-6zm7.59-11.41L17 12.17V2h-2v10.17l-3.59-3.58L10 10l6 6 6-6-1.41-1.41z"}),props.children);});var PageFirst32=/*#__PURE__*/React.forwardRef(function PageFirst32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M14 16L24 6l1.4 1.4-8.6 8.6 8.6 8.6L24 26zM8 4h2v24H8z"}),props.children);});var PageFirst24=/*#__PURE__*/React.forwardRef(function PageFirst24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M14 16L24 6l1.4 1.4-8.6 8.6 8.6 8.6L24 26zM8 4h2v24H8z"}),props.children);});var PageFirst20=/*#__PURE__*/React.forwardRef(function PageFirst20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M14 16L24 6l1.4 1.4-8.6 8.6 8.6 8.6L24 26zM8 4h2v24H8z"}),props.children);});var PageFirst16=/*#__PURE__*/React.forwardRef(function PageFirst16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M14 16L24 6l1.4 1.4-8.6 8.6 8.6 8.6L24 26zM8 4h2v24H8z"}),props.children);});var PageLast32=/*#__PURE__*/React.forwardRef(function PageLast32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 16L8 26l-1.4-1.4 8.6-8.6-8.6-8.6L8 6zm4-12h2v24h-2z"}),props.children);});var PageLast24=/*#__PURE__*/React.forwardRef(function PageLast24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 16L8 26l-1.4-1.4 8.6-8.6-8.6-8.6L8 6zm4-12h2v24h-2z"}),props.children);});var PageLast20=/*#__PURE__*/React.forwardRef(function PageLast20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 16L8 26l-1.4-1.4 8.6-8.6-8.6-8.6L8 6zm4-12h2v24h-2z"}),props.children);});var PageLast16=/*#__PURE__*/React.forwardRef(function PageLast16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 16L8 26l-1.4-1.4 8.6-8.6-8.6-8.6L8 6zm4-12h2v24h-2z"}),props.children);});var PaintBrush32=/*#__PURE__*/React.forwardRef(function PaintBrush32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28.83 23.17L23 17.33V13a1 1 0 0 0-.29-.71l-10-10a1 1 0 0 0-1.42 0l-9 9a1 1 0 0 0 0 1.42l10 10A1 1 0 0 0 13 23h4.34l5.83 5.84a4 4 0 0 0 5.66-5.66zM6 10.41l2.29 2.3 1.42-1.42L7.41 9 9 7.41l4.29 4.3 1.42-1.42L10.41 6 12 4.41 18.59 11 11 18.59 4.41 12zm21.41 17a2 2 0 0 1-2.82 0l-6.13-6.12a1.8 1.8 0 0 0-.71-.29h-4.34l-1-1L20 12.41l1 1v4.34a1 1 0 0 0 .29.7l6.12 6.14a2 2 0 0 1 0 2.82z"}),props.children);});var PaintBrush24=/*#__PURE__*/React.forwardRef(function PaintBrush24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28.83 23.17L23 17.33V13a1 1 0 0 0-.29-.71l-10-10a1 1 0 0 0-1.42 0l-9 9a1 1 0 0 0 0 1.42l10 10A1 1 0 0 0 13 23h4.34l5.83 5.84a4 4 0 0 0 5.66-5.66zM6 10.41l2.29 2.3 1.42-1.42L7.41 9 9 7.41l4.29 4.3 1.42-1.42L10.41 6 12 4.41 18.59 11 11 18.59 4.41 12zm21.41 17a2 2 0 0 1-2.82 0l-6.13-6.12a1.8 1.8 0 0 0-.71-.29h-4.34l-1-1L20 12.41l1 1v4.34a1 1 0 0 0 .29.7l6.12 6.14a2 2 0 0 1 0 2.82z"}),props.children);});var PaintBrush20=/*#__PURE__*/React.forwardRef(function PaintBrush20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28.83 23.17L23 17.33V13a1 1 0 0 0-.29-.71l-10-10a1 1 0 0 0-1.42 0l-9 9a1 1 0 0 0 0 1.42l10 10A1 1 0 0 0 13 23h4.34l5.83 5.84a4 4 0 0 0 5.66-5.66zM6 10.41l2.29 2.3 1.42-1.42L7.41 9 9 7.41l4.29 4.3 1.42-1.42L10.41 6 12 4.41 18.59 11 11 18.59 4.41 12zm21.41 17a2 2 0 0 1-2.82 0l-6.13-6.12a1.8 1.8 0 0 0-.71-.29h-4.34l-1-1L20 12.41l1 1v4.34a1 1 0 0 0 .29.7l6.12 6.14a2 2 0 0 1 0 2.82z"}),props.children);});var PaintBrush16=/*#__PURE__*/React.forwardRef(function PaintBrush16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28.83 23.17L23 17.33V13a1 1 0 0 0-.29-.71l-10-10a1 1 0 0 0-1.42 0l-9 9a1 1 0 0 0 0 1.42l10 10A1 1 0 0 0 13 23h4.34l5.83 5.84a4 4 0 0 0 5.66-5.66zM6 10.41l2.29 2.3 1.42-1.42L7.41 9 9 7.41l4.29 4.3 1.42-1.42L10.41 6 12 4.41 18.59 11 11 18.59 4.41 12zm21.41 17a2 2 0 0 1-2.82 0l-6.13-6.12a1.8 1.8 0 0 0-.71-.29h-4.34l-1-1L20 12.41l1 1v4.34a1 1 0 0 0 .29.7l6.12 6.14a2 2 0 0 1 0 2.82z"}),props.children);});var PanelExpansion32=/*#__PURE__*/React.forwardRef(function PanelExpansion32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 6H6a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zm-6 8V8h6v6zm20-8h-6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zm-6 18V8h6v16z"}),props.children);});var PanelExpansion24=/*#__PURE__*/React.forwardRef(function PanelExpansion24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 6H6a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zm-6 8V8h6v6zm20-8h-6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zm-6 18V8h6v16z"}),props.children);});var PanelExpansion20=/*#__PURE__*/React.forwardRef(function PanelExpansion20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 6H6a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zm-6 8V8h6v6zm20-8h-6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zm-6 18V8h6v16z"}),props.children);});var PanelExpansion16=/*#__PURE__*/React.forwardRef(function PanelExpansion16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 6H6a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zm-6 8V8h6v6zm20-8h-6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zm-6 18V8h6v16z"}),props.children);});var ParentChild32=/*#__PURE__*/React.forwardRef(function ParentChild32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 12a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2H4a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h11v4H9a2 2 0 0 0-2 2v4H4a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2v-4a2 2 0 0 0-2-2H9v-4h14v4h-3a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2v-4a2 2 0 0 0-2-2h-3v-4a2 2 0 0 0-2-2h-6v-4zM12 28H4v-4h8zm16 0h-8v-4h8zM4 4h24v6H4z"}),props.children);});var ParentChild24=/*#__PURE__*/React.forwardRef(function ParentChild24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 12a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2H4a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h11v4H9a2 2 0 0 0-2 2v4H4a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2v-4a2 2 0 0 0-2-2H9v-4h14v4h-3a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2v-4a2 2 0 0 0-2-2h-3v-4a2 2 0 0 0-2-2h-6v-4zM12 28H4v-4h8zm16 0h-8v-4h8zM4 4h24v6H4z"}),props.children);});var ParentChild20=/*#__PURE__*/React.forwardRef(function ParentChild20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 12a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2H4a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h11v4H9a2 2 0 0 0-2 2v4H4a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2v-4a2 2 0 0 0-2-2H9v-4h14v4h-3a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2v-4a2 2 0 0 0-2-2h-3v-4a2 2 0 0 0-2-2h-6v-4zM12 28H4v-4h8zm16 0h-8v-4h8zM4 4h24v6H4z"}),props.children);});var ParentChild16=/*#__PURE__*/React.forwardRef(function ParentChild16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 12a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2H4a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h11v4H9a2 2 0 0 0-2 2v4H4a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2v-4a2 2 0 0 0-2-2H9v-4h14v4h-3a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2v-4a2 2 0 0 0-2-2h-3v-4a2 2 0 0 0-2-2h-6v-4zM12 28H4v-4h8zm16 0h-8v-4h8zM4 4h24v6H4z"}),props.children);});var PartlyCloudy32=/*#__PURE__*/React.forwardRef(function PartlyCloudy32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21.743 18.692a6.05 6.05 0 0 0 1.057-1.086 5.998 5.998 0 1 0-10.733-4.445 7.557 7.557 0 0 0-5.716 5.088A5.993 5.993 0 0 0 8 30.005h11a5.985 5.985 0 0 0 2.743-11.313zM18 10.005a4.004 4.004 0 0 1 4 4 3.961 3.961 0 0 1-.8 2.4 4.012 4.012 0 0 1-.94.891 7.542 7.542 0 0 0-6.134-4.24A3.998 3.998 0 0 1 18 10.005zm1 18H8a3.993 3.993 0 0 1-.673-7.93l.663-.112.146-.656a5.496 5.496 0 0 1 10.729 0l.146.656.662.112a3.993 3.993 0 0 1-.673 7.93zm7-15h4v2h-4zM22.95 7.64l2.828-2.827 1.415 1.414-2.829 2.828zM17 2.005h2v4h-2zM8.808 6.227l1.414-1.414 2.829 2.828-1.415 1.414z"}),props.children);});var PartlyCloudy24=/*#__PURE__*/React.forwardRef(function PartlyCloudy24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21.743 18.692a6.05 6.05 0 0 0 1.057-1.086 5.998 5.998 0 1 0-10.733-4.445 7.557 7.557 0 0 0-5.716 5.088A5.993 5.993 0 0 0 8 30.005h11a5.985 5.985 0 0 0 2.743-11.313zM18 10.005a4.004 4.004 0 0 1 4 4 3.961 3.961 0 0 1-.8 2.4 4.012 4.012 0 0 1-.94.891 7.542 7.542 0 0 0-6.134-4.24A3.998 3.998 0 0 1 18 10.005zm1 18H8a3.993 3.993 0 0 1-.673-7.93l.663-.112.146-.656a5.496 5.496 0 0 1 10.729 0l.146.656.662.112a3.993 3.993 0 0 1-.673 7.93zm7-15h4v2h-4zM22.95 7.64l2.828-2.827 1.415 1.414-2.829 2.828zM17 2.005h2v4h-2zM8.808 6.227l1.414-1.414 2.829 2.828-1.415 1.414z"}),props.children);});var PartlyCloudy20=/*#__PURE__*/React.forwardRef(function PartlyCloudy20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21.743 18.692a6.05 6.05 0 0 0 1.057-1.086 5.998 5.998 0 1 0-10.733-4.445 7.557 7.557 0 0 0-5.716 5.088A5.993 5.993 0 0 0 8 30.005h11a5.985 5.985 0 0 0 2.743-11.313zM18 10.005a4.004 4.004 0 0 1 4 4 3.961 3.961 0 0 1-.8 2.4 4.012 4.012 0 0 1-.94.891 7.542 7.542 0 0 0-6.134-4.24A3.998 3.998 0 0 1 18 10.005zm1 18H8a3.993 3.993 0 0 1-.673-7.93l.663-.112.146-.656a5.496 5.496 0 0 1 10.729 0l.146.656.662.112a3.993 3.993 0 0 1-.673 7.93zm7-15h4v2h-4zM22.95 7.64l2.828-2.827 1.415 1.414-2.829 2.828zM17 2.005h2v4h-2zM8.808 6.227l1.414-1.414 2.829 2.828-1.415 1.414z"}),props.children);});var PartlyCloudy16=/*#__PURE__*/React.forwardRef(function PartlyCloudy16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21.743 18.692a6.05 6.05 0 0 0 1.057-1.086 5.998 5.998 0 1 0-10.733-4.445 7.557 7.557 0 0 0-5.716 5.088A5.993 5.993 0 0 0 8 30.005h11a5.985 5.985 0 0 0 2.743-11.313zM18 10.005a4.004 4.004 0 0 1 4 4 3.961 3.961 0 0 1-.8 2.4 4.012 4.012 0 0 1-.94.891 7.542 7.542 0 0 0-6.134-4.24A3.998 3.998 0 0 1 18 10.005zm1 18H8a3.993 3.993 0 0 1-.673-7.93l.663-.112.146-.656a5.496 5.496 0 0 1 10.729 0l.146.656.662.112a3.993 3.993 0 0 1-.673 7.93zm7-15h4v2h-4zM22.95 7.64l2.828-2.827 1.415 1.414-2.829 2.828zM17 2.005h2v4h-2zM8.808 6.227l1.414-1.414 2.829 2.828-1.415 1.414z"}),props.children);});var Partnership32=/*#__PURE__*/React.forwardRef(function Partnership32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8 9a4 4 0 1 1 4-4 4 4 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2 2 0 0 0-2-2zm16 6a4 4 0 1 1 4-4 4 4 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2 2 0 0 0-2-2zm2 27h-4a2 2 0 0 1-2-2v-7h2v7h4v-9h2v-6a1 1 0 0 0-1-1h-6.42L16 20l-4.58-8H5a1 1 0 0 0-1 1v6h2v9h4v-7h2v7a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2v-7a2 2 0 0 1-2-2v-6a3 3 0 0 1 3-3h7.58L16 16l3.42-6H27a3 3 0 0 1 3 3v6a2 2 0 0 1-2 2v7a2 2 0 0 1-2 2z"}),props.children);});var Partnership24=/*#__PURE__*/React.forwardRef(function Partnership24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8 9a4 4 0 1 1 4-4 4 4 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2 2 0 0 0-2-2zm16 6a4 4 0 1 1 4-4 4 4 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2 2 0 0 0-2-2zm2 27h-4a2 2 0 0 1-2-2v-7h2v7h4v-9h2v-6a1 1 0 0 0-1-1h-6.42L16 20l-4.58-8H5a1 1 0 0 0-1 1v6h2v9h4v-7h2v7a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2v-7a2 2 0 0 1-2-2v-6a3 3 0 0 1 3-3h7.58L16 16l3.42-6H27a3 3 0 0 1 3 3v6a2 2 0 0 1-2 2v7a2 2 0 0 1-2 2z"}),props.children);});var Partnership20=/*#__PURE__*/React.forwardRef(function Partnership20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8 9a4 4 0 1 1 4-4 4 4 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2 2 0 0 0-2-2zm16 6a4 4 0 1 1 4-4 4 4 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2 2 0 0 0-2-2zm2 27h-4a2 2 0 0 1-2-2v-7h2v7h4v-9h2v-6a1 1 0 0 0-1-1h-6.42L16 20l-4.58-8H5a1 1 0 0 0-1 1v6h2v9h4v-7h2v7a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2v-7a2 2 0 0 1-2-2v-6a3 3 0 0 1 3-3h7.58L16 16l3.42-6H27a3 3 0 0 1 3 3v6a2 2 0 0 1-2 2v7a2 2 0 0 1-2 2z"}),props.children);});var Partnership16=/*#__PURE__*/React.forwardRef(function Partnership16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8 9a4 4 0 1 1 4-4 4 4 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2 2 0 0 0-2-2zm16 6a4 4 0 1 1 4-4 4 4 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2 2 0 0 0-2-2zm2 27h-4a2 2 0 0 1-2-2v-7h2v7h4v-9h2v-6a1 1 0 0 0-1-1h-6.42L16 20l-4.58-8H5a1 1 0 0 0-1 1v6h2v9h4v-7h2v7a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2v-7a2 2 0 0 1-2-2v-6a3 3 0 0 1 3-3h7.58L16 16l3.42-6H27a3 3 0 0 1 3 3v6a2 2 0 0 1-2 2v7a2 2 0 0 1-2 2z"}),props.children);});var Password32=/*#__PURE__*/React.forwardRef(function Password32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21 2a9 9 0 0 0-9 9 8.87 8.87 0 0 0 .39 2.61L2 24v6h6l10.39-10.39A9 9 0 0 0 30 11.74a8.77 8.77 0 0 0-1.65-6A9 9 0 0 0 21 2zm0 16a7 7 0 0 1-2-.3l-1.15-.35-.85.85-3.18 3.18L12.41 20 11 21.41l1.38 1.38-1.59 1.59L9.41 23 8 24.41l1.38 1.38L7.17 28H4v-3.17L13.8 15l.85-.85-.29-.95a7.14 7.14 0 0 1 3.4-8.44 7 7 0 0 1 10.24 6 6.69 6.69 0 0 1-1.09 4A7 7 0 0 1 21 18z"}),React.createElement("circle",{cx:"22",cy:"10",r:"2"}),props.children);});var Password24=/*#__PURE__*/React.forwardRef(function Password24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21 2a9 9 0 0 0-9 9 8.87 8.87 0 0 0 .39 2.61L2 24v6h6l10.39-10.39A9 9 0 0 0 30 11.74a8.77 8.77 0 0 0-1.65-6A9 9 0 0 0 21 2zm0 16a7 7 0 0 1-2-.3l-1.15-.35-.85.85-3.18 3.18L12.41 20 11 21.41l1.38 1.38-1.59 1.59L9.41 23 8 24.41l1.38 1.38L7.17 28H4v-3.17L13.8 15l.85-.85-.29-.95a7.14 7.14 0 0 1 3.4-8.44 7 7 0 0 1 10.24 6 6.69 6.69 0 0 1-1.09 4A7 7 0 0 1 21 18z"}),React.createElement("circle",{cx:"22",cy:"10",r:"2"}),props.children);});var Password20=/*#__PURE__*/React.forwardRef(function Password20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21 2a9 9 0 0 0-9 9 8.87 8.87 0 0 0 .39 2.61L2 24v6h6l10.39-10.39A9 9 0 0 0 30 11.74a8.77 8.77 0 0 0-1.65-6A9 9 0 0 0 21 2zm0 16a7 7 0 0 1-2-.3l-1.15-.35-.85.85-3.18 3.18L12.41 20 11 21.41l1.38 1.38-1.59 1.59L9.41 23 8 24.41l1.38 1.38L7.17 28H4v-3.17L13.8 15l.85-.85-.29-.95a7.14 7.14 0 0 1 3.4-8.44 7 7 0 0 1 10.24 6 6.69 6.69 0 0 1-1.09 4A7 7 0 0 1 21 18z"}),React.createElement("circle",{cx:"22",cy:"10",r:"2"}),props.children);});var Password16=/*#__PURE__*/React.forwardRef(function Password16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21 2a9 9 0 0 0-9 9 8.87 8.87 0 0 0 .39 2.61L2 24v6h6l10.39-10.39A9 9 0 0 0 30 11.74a8.77 8.77 0 0 0-1.65-6A9 9 0 0 0 21 2zm0 16a7 7 0 0 1-2-.3l-1.15-.35-.85.85-3.18 3.18L12.41 20 11 21.41l1.38 1.38-1.59 1.59L9.41 23 8 24.41l1.38 1.38L7.17 28H4v-3.17L13.8 15l.85-.85-.29-.95a7.14 7.14 0 0 1 3.4-8.44 7 7 0 0 1 10.24 6 6.69 6.69 0 0 1-1.09 4A7 7 0 0 1 21 18z"}),React.createElement("circle",{cx:"22",cy:"10",r:"2"}),props.children);});var Paste32=/*#__PURE__*/React.forwardRef(function Paste32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 20h-8.17l2.58-2.59L19 16l-5 5 5 5 1.41-1.41L17.83 22H26v8h2v-8a2 2 0 0 0-2-2z"}),React.createElement("path",{d:"M23.71 9.29l-7-7A1 1 0 0 0 16 2H6a2 2 0 0 0-2 2v24a2 2 0 0 0 2 2h8v-2H6V4h8v6a2 2 0 0 0 2 2h6v2h2v-4a1 1 0 0 0-.29-.71zM16 4.41L21.59 10H16z"}),props.children);});var Paste24=/*#__PURE__*/React.forwardRef(function Paste24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 20h-8.17l2.58-2.59L19 16l-5 5 5 5 1.41-1.41L17.83 22H26v8h2v-8a2 2 0 0 0-2-2z"}),React.createElement("path",{d:"M23.71 9.29l-7-7A1 1 0 0 0 16 2H6a2 2 0 0 0-2 2v24a2 2 0 0 0 2 2h8v-2H6V4h8v6a2 2 0 0 0 2 2h6v2h2v-4a1 1 0 0 0-.29-.71zM16 4.41L21.59 10H16z"}),props.children);});var Paste20=/*#__PURE__*/React.forwardRef(function Paste20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 20h-8.17l2.58-2.59L19 16l-5 5 5 5 1.41-1.41L17.83 22H26v8h2v-8a2 2 0 0 0-2-2z"}),React.createElement("path",{d:"M23.71 9.29l-7-7A1 1 0 0 0 16 2H6a2 2 0 0 0-2 2v24a2 2 0 0 0 2 2h8v-2H6V4h8v6a2 2 0 0 0 2 2h6v2h2v-4a1 1 0 0 0-.29-.71zM16 4.41L21.59 10H16z"}),props.children);});var Paste16=/*#__PURE__*/React.forwardRef(function Paste16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 20h-8.17l2.58-2.59L19 16l-5 5 5 5 1.41-1.41L17.83 22H26v8h2v-8a2 2 0 0 0-2-2z"}),React.createElement("path",{d:"M23.71 9.29l-7-7A1 1 0 0 0 16 2H6a2 2 0 0 0-2 2v24a2 2 0 0 0 2 2h8v-2H6V4h8v6a2 2 0 0 0 2 2h6v2h2v-4a1 1 0 0 0-.29-.71zM16 4.41L21.59 10H16z"}),props.children);});var PauseFilled32=/*#__PURE__*/React.forwardRef(function PauseFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 6h-2a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h2a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zm10 0h-2a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h2a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2z"}),props.children);});var PauseFilled24=/*#__PURE__*/React.forwardRef(function PauseFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 6h-2a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h2a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zm10 0h-2a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h2a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2z"}),props.children);});var PauseFilled20=/*#__PURE__*/React.forwardRef(function PauseFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 6h-2a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h2a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zm10 0h-2a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h2a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2z"}),props.children);});var PauseFilled16=/*#__PURE__*/React.forwardRef(function PauseFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 6h-2a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h2a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zm10 0h-2a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h2a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2z"}),props.children);});var PauseOutlineFilled32=/*#__PURE__*/React.forwardRef(function PauseOutlineFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm-2 20h-2V10h2zm6 0h-2V10h2z"}),props.children);});var PauseOutlineFilled24=/*#__PURE__*/React.forwardRef(function PauseOutlineFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm-2 20h-2V10h2zm6 0h-2V10h2z"}),props.children);});var PauseOutlineFilled20=/*#__PURE__*/React.forwardRef(function PauseOutlineFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm-2 20h-2V10h2zm6 0h-2V10h2z"}),props.children);});var PauseOutline32=/*#__PURE__*/React.forwardRef(function PauseOutline32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M14 10h-2v12h2V10zm6 0h-2v12h2V10z"}),React.createElement("path",{d:"M16 4A12 12 0 1 1 4 16 12 12 0 0 1 16 4m0-2a14 14 0 1 0 14 14A14 14 0 0 0 16 2z"}),props.children);});var PauseOutline24=/*#__PURE__*/React.forwardRef(function PauseOutline24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M14 10h-2v12h2V10zm6 0h-2v12h2V10z"}),React.createElement("path",{d:"M16 4A12 12 0 1 1 4 16 12 12 0 0 1 16 4m0-2a14 14 0 1 0 14 14A14 14 0 0 0 16 2z"}),props.children);});var PauseOutline20=/*#__PURE__*/React.forwardRef(function PauseOutline20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M14 10h-2v12h2V10zm6 0h-2v12h2V10z"}),React.createElement("path",{d:"M16 4A12 12 0 1 1 4 16 12 12 0 0 1 16 4m0-2a14 14 0 1 0 14 14A14 14 0 0 0 16 2z"}),props.children);});var Pause32=/*#__PURE__*/React.forwardRef(function Pause32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 8v16H8V8h4m0-2H8a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zm12 2v16h-4V8h4m0-2h-4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2z"}),props.children);});var Pause24=/*#__PURE__*/React.forwardRef(function Pause24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 8v16H8V8h4m0-2H8a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zm12 2v16h-4V8h4m0-2h-4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2z"}),props.children);});var Pause20=/*#__PURE__*/React.forwardRef(function Pause20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 8v16H8V8h4m0-2H8a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zm12 2v16h-4V8h4m0-2h-4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2z"}),props.children);});var PersonFavorite32=/*#__PURE__*/React.forwardRef(function PersonFavorite32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 31H6a2.006 2.006 0 0 1-2-2v-7a2.006 2.006 0 0 1-2-2v-6a2.946 2.946 0 0 1 3-3h6a2.946 2.946 0 0 1 3 3v6a2.006 2.006 0 0 1-2 2v7a2.006 2.006 0 0 1-2 2zM5 13a.945.945 0 0 0-1 1v6h2v9h4v-9h2v-6a.945.945 0 0 0-1-1zm3-3a4 4 0 1 1 4-4 4.005 4.005 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2zm20.766.256A4.212 4.212 0 0 0 23 4.032a4.212 4.212 0 0 0-5.766.224 4.319 4.319 0 0 0 0 6.044l5.764 5.84.002-.002.002.001 5.764-5.839a4.319 4.319 0 0 0 0-6.044zm-1.424 4.639l-4.34 4.397L23 13.29l-.002.002-4.34-4.397a2.308 2.308 0 0 1 0-3.234 2.264 2.264 0 0 1 3.156 0l1.181 1.207.005-.005.005.005 1.18-1.207a2.264 2.264 0 0 1 3.157 0 2.308 2.308 0 0 1 0 3.234z"}),props.children);});var PersonFavorite24=/*#__PURE__*/React.forwardRef(function PersonFavorite24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 31H6a2.006 2.006 0 0 1-2-2v-7a2.006 2.006 0 0 1-2-2v-6a2.946 2.946 0 0 1 3-3h6a2.946 2.946 0 0 1 3 3v6a2.006 2.006 0 0 1-2 2v7a2.006 2.006 0 0 1-2 2zM5 13a.945.945 0 0 0-1 1v6h2v9h4v-9h2v-6a.945.945 0 0 0-1-1zm3-3a4 4 0 1 1 4-4 4.005 4.005 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2zm20.766.256A4.212 4.212 0 0 0 23 4.032a4.212 4.212 0 0 0-5.766.224 4.319 4.319 0 0 0 0 6.044l5.764 5.84.002-.002.002.001 5.764-5.839a4.319 4.319 0 0 0 0-6.044zm-1.424 4.639l-4.34 4.397L23 13.29l-.002.002-4.34-4.397a2.308 2.308 0 0 1 0-3.234 2.264 2.264 0 0 1 3.156 0l1.181 1.207.005-.005.005.005 1.18-1.207a2.264 2.264 0 0 1 3.157 0 2.308 2.308 0 0 1 0 3.234z"}),props.children);});var PersonFavorite20=/*#__PURE__*/React.forwardRef(function PersonFavorite20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 31H6a2.006 2.006 0 0 1-2-2v-7a2.006 2.006 0 0 1-2-2v-6a2.946 2.946 0 0 1 3-3h6a2.946 2.946 0 0 1 3 3v6a2.006 2.006 0 0 1-2 2v7a2.006 2.006 0 0 1-2 2zM5 13a.945.945 0 0 0-1 1v6h2v9h4v-9h2v-6a.945.945 0 0 0-1-1zm3-3a4 4 0 1 1 4-4 4.005 4.005 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2zm20.766.256A4.212 4.212 0 0 0 23 4.032a4.212 4.212 0 0 0-5.766.224 4.319 4.319 0 0 0 0 6.044l5.764 5.84.002-.002.002.001 5.764-5.839a4.319 4.319 0 0 0 0-6.044zm-1.424 4.639l-4.34 4.397L23 13.29l-.002.002-4.34-4.397a2.308 2.308 0 0 1 0-3.234 2.264 2.264 0 0 1 3.156 0l1.181 1.207.005-.005.005.005 1.18-1.207a2.264 2.264 0 0 1 3.157 0 2.308 2.308 0 0 1 0 3.234z"}),props.children);});var PersonFavorite16=/*#__PURE__*/React.forwardRef(function PersonFavorite16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 31H6a2.006 2.006 0 0 1-2-2v-7a2.006 2.006 0 0 1-2-2v-6a2.946 2.946 0 0 1 3-3h6a2.946 2.946 0 0 1 3 3v6a2.006 2.006 0 0 1-2 2v7a2.006 2.006 0 0 1-2 2zM5 13a.945.945 0 0 0-1 1v6h2v9h4v-9h2v-6a.945.945 0 0 0-1-1zm3-3a4 4 0 1 1 4-4 4.005 4.005 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2zm20.766.256A4.212 4.212 0 0 0 23 4.032a4.212 4.212 0 0 0-5.766.224 4.319 4.319 0 0 0 0 6.044l5.764 5.84.002-.002.002.001 5.764-5.839a4.319 4.319 0 0 0 0-6.044zm-1.424 4.639l-4.34 4.397L23 13.29l-.002.002-4.34-4.397a2.308 2.308 0 0 1 0-3.234 2.264 2.264 0 0 1 3.156 0l1.181 1.207.005-.005.005.005 1.18-1.207a2.264 2.264 0 0 1 3.157 0 2.308 2.308 0 0 1 0 3.234z"}),props.children);});var Person32=/*#__PURE__*/React.forwardRef(function Person32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 30h-4a2 2 0 0 1-2-2v-7a2 2 0 0 1-2-2v-6a3 3 0 0 1 3-3h6a3 3 0 0 1 3 3v6a2 2 0 0 1-2 2v7a2 2 0 0 1-2 2zm-5-18a.94.94 0 0 0-1 1v6h2v9h4v-9h2v-6a.94.94 0 0 0-1-1zm3-3a4 4 0 1 1 4-4 4 4 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2 2 0 0 0-2-2z"}),props.children);});var Person24=/*#__PURE__*/React.forwardRef(function Person24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 30h-4a2 2 0 0 1-2-2v-7a2 2 0 0 1-2-2v-6a3 3 0 0 1 3-3h6a3 3 0 0 1 3 3v6a2 2 0 0 1-2 2v7a2 2 0 0 1-2 2zm-5-18a.94.94 0 0 0-1 1v6h2v9h4v-9h2v-6a.94.94 0 0 0-1-1zm3-3a4 4 0 1 1 4-4 4 4 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2 2 0 0 0-2-2z"}),props.children);});var Person20=/*#__PURE__*/React.forwardRef(function Person20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 30h-4a2 2 0 0 1-2-2v-7a2 2 0 0 1-2-2v-6a3 3 0 0 1 3-3h6a3 3 0 0 1 3 3v6a2 2 0 0 1-2 2v7a2 2 0 0 1-2 2zm-5-18a.94.94 0 0 0-1 1v6h2v9h4v-9h2v-6a.94.94 0 0 0-1-1zm3-3a4 4 0 1 1 4-4 4 4 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2 2 0 0 0-2-2z"}),props.children);});var Person16=/*#__PURE__*/React.forwardRef(function Person16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18 30h-4a2 2 0 0 1-2-2v-7a2 2 0 0 1-2-2v-6a3 3 0 0 1 3-3h6a3 3 0 0 1 3 3v6a2 2 0 0 1-2 2v7a2 2 0 0 1-2 2zm-5-18a.94.94 0 0 0-1 1v6h2v9h4v-9h2v-6a.94.94 0 0 0-1-1zm3-3a4 4 0 1 1 4-4 4 4 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2 2 0 0 0-2-2z"}),props.children);});var PhoneFilled32=/*#__PURE__*/React.forwardRef(function PhoneFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20.33 21.48l2.24-2.24a2.19 2.19 0 0 1 2.34-.48l2.73 1.09a2.18 2.18 0 0 1 1.36 2v5A2.17 2.17 0 0 1 26.72 29C7.59 27.81 3.73 11.61 3 5.41A2.17 2.17 0 0 1 5.17 3H10a2.16 2.16 0 0 1 2 1.36l1.09 2.73a2.16 2.16 0 0 1-.47 2.34l-2.24 2.24s1.29 8.73 9.95 9.81z"}),props.children);});var PhoneFilled24=/*#__PURE__*/React.forwardRef(function PhoneFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20.33 21.48l2.24-2.24a2.19 2.19 0 0 1 2.34-.48l2.73 1.09a2.18 2.18 0 0 1 1.36 2v5A2.17 2.17 0 0 1 26.72 29C7.59 27.81 3.73 11.61 3 5.41A2.17 2.17 0 0 1 5.17 3H10a2.16 2.16 0 0 1 2 1.36l1.09 2.73a2.16 2.16 0 0 1-.47 2.34l-2.24 2.24s1.29 8.73 9.95 9.81z"}),props.children);});var PhoneFilled20=/*#__PURE__*/React.forwardRef(function PhoneFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20.33 21.48l2.24-2.24a2.19 2.19 0 0 1 2.34-.48l2.73 1.09a2.18 2.18 0 0 1 1.36 2v5A2.17 2.17 0 0 1 26.72 29C7.59 27.81 3.73 11.61 3 5.41A2.17 2.17 0 0 1 5.17 3H10a2.16 2.16 0 0 1 2 1.36l1.09 2.73a2.16 2.16 0 0 1-.47 2.34l-2.24 2.24s1.29 8.73 9.95 9.81z"}),props.children);});var PhoneFilled16=/*#__PURE__*/React.forwardRef(function PhoneFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20.33 21.48l2.24-2.24a2.19 2.19 0 0 1 2.34-.48l2.73 1.09a2.18 2.18 0 0 1 1.36 2v5A2.17 2.17 0 0 1 26.72 29C7.59 27.81 3.73 11.61 3 5.41A2.17 2.17 0 0 1 5.17 3H10a2.16 2.16 0 0 1 2 1.36l1.09 2.73a2.16 2.16 0 0 1-.47 2.34l-2.24 2.24s1.29 8.73 9.95 9.81z"}),props.children);});var PhoneOffFilled32=/*#__PURE__*/React.forwardRef(function PhoneOffFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26.74 19.56l-2.52-1a2 2 0 0 0-2.15.44L20 21.06a9.93 9.93 0 0 1-5.35-2.29L30 3.41 28.59 2 2 28.59 3.41 30l7.93-7.92c3.24 3.12 7.89 5.5 14.55 5.92A2 2 0 0 0 28 26v-4.59a2 2 0 0 0-1.26-1.85zM8.15 18.19l3.52-3.52a11.68 11.68 0 0 1-.82-2.67l2.07-2.07a2 2 0 0 0 .44-2.15l-1-2.52A2 2 0 0 0 10.5 4H6a2 2 0 0 0-2 2.22 29 29 0 0 0 4.15 11.97z"}),props.children);});var PhoneOffFilled24=/*#__PURE__*/React.forwardRef(function PhoneOffFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26.74 19.56l-2.52-1a2 2 0 0 0-2.15.44L20 21.06a9.93 9.93 0 0 1-5.35-2.29L30 3.41 28.59 2 2 28.59 3.41 30l7.93-7.92c3.24 3.12 7.89 5.5 14.55 5.92A2 2 0 0 0 28 26v-4.59a2 2 0 0 0-1.26-1.85zM8.15 18.19l3.52-3.52a11.68 11.68 0 0 1-.82-2.67l2.07-2.07a2 2 0 0 0 .44-2.15l-1-2.52A2 2 0 0 0 10.5 4H6a2 2 0 0 0-2 2.22 29 29 0 0 0 4.15 11.97z"}),props.children);});var PhoneOffFilled20=/*#__PURE__*/React.forwardRef(function PhoneOffFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26.74 19.56l-2.52-1a2 2 0 0 0-2.15.44L20 21.06a9.93 9.93 0 0 1-5.35-2.29L30 3.41 28.59 2 2 28.59 3.41 30l7.93-7.92c3.24 3.12 7.89 5.5 14.55 5.92A2 2 0 0 0 28 26v-4.59a2 2 0 0 0-1.26-1.85zM8.15 18.19l3.52-3.52a11.68 11.68 0 0 1-.82-2.67l2.07-2.07a2 2 0 0 0 .44-2.15l-1-2.52A2 2 0 0 0 10.5 4H6a2 2 0 0 0-2 2.22 29 29 0 0 0 4.15 11.97z"}),props.children);});var PhoneOffFilled16=/*#__PURE__*/React.forwardRef(function PhoneOffFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26.74 19.56l-2.52-1a2 2 0 0 0-2.15.44L20 21.06a9.93 9.93 0 0 1-5.35-2.29L30 3.41 28.59 2 2 28.59 3.41 30l7.93-7.92c3.24 3.12 7.89 5.5 14.55 5.92A2 2 0 0 0 28 26v-4.59a2 2 0 0 0-1.26-1.85zM8.15 18.19l3.52-3.52a11.68 11.68 0 0 1-.82-2.67l2.07-2.07a2 2 0 0 0 .44-2.15l-1-2.52A2 2 0 0 0 10.5 4H6a2 2 0 0 0-2 2.22 29 29 0 0 0 4.15 11.97z"}),props.children);});var PhoneOff32=/*#__PURE__*/React.forwardRef(function PhoneOff32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M9.19 18.56A25.66 25.66 0 0 1 5 6.08V6a1 1 0 0 1 1-1h5.28l1.5 3.77-2.84 2.87.06.48a13 13 0 0 0 1.46 4.17l1.46-1.46a9.34 9.34 0 0 1-.84-2.52l2.13-2.15A2 2 0 0 0 14.65 8l-1.52-3.74A2 2 0 0 0 11.27 3H5.76A3 3 0 0 0 3 6.23 28 28 0 0 0 7.79 20zm18.58.3L24 17.35a2 2 0 0 0-2.17.41l-2.17 2.15A9.17 9.17 0 0 1 15.45 18L30 3.41 28.59 2 2 28.59 3.41 30l7-7c3.38 3.18 8.28 5.62 15.39 6h.2a3 3 0 0 0 3-3v-5.28a2 2 0 0 0-1.23-1.86zM27 26v.06a1 1 0 0 1-1.06.94c-6.51-.37-11-2.54-14.11-5.42L14 19.44A10.77 10.77 0 0 0 19.88 22l.48.06 2.87-2.85L27 20.72z"}),props.children);});var PhoneOff24=/*#__PURE__*/React.forwardRef(function PhoneOff24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M9.19 18.56A25.66 25.66 0 0 1 5 6.08V6a1 1 0 0 1 1-1h5.28l1.5 3.77-2.84 2.87.06.48a13 13 0 0 0 1.46 4.17l1.46-1.46a9.34 9.34 0 0 1-.84-2.52l2.13-2.15A2 2 0 0 0 14.65 8l-1.52-3.74A2 2 0 0 0 11.27 3H5.76A3 3 0 0 0 3 6.23 28 28 0 0 0 7.79 20zm18.58.3L24 17.35a2 2 0 0 0-2.17.41l-2.17 2.15A9.17 9.17 0 0 1 15.45 18L30 3.41 28.59 2 2 28.59 3.41 30l7-7c3.38 3.18 8.28 5.62 15.39 6h.2a3 3 0 0 0 3-3v-5.28a2 2 0 0 0-1.23-1.86zM27 26v.06a1 1 0 0 1-1.06.94c-6.51-.37-11-2.54-14.11-5.42L14 19.44A10.77 10.77 0 0 0 19.88 22l.48.06 2.87-2.85L27 20.72z"}),props.children);});var PhoneOff20=/*#__PURE__*/React.forwardRef(function PhoneOff20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M9.19 18.56A25.66 25.66 0 0 1 5 6.08V6a1 1 0 0 1 1-1h5.28l1.5 3.77-2.84 2.87.06.48a13 13 0 0 0 1.46 4.17l1.46-1.46a9.34 9.34 0 0 1-.84-2.52l2.13-2.15A2 2 0 0 0 14.65 8l-1.52-3.74A2 2 0 0 0 11.27 3H5.76A3 3 0 0 0 3 6.23 28 28 0 0 0 7.79 20zm18.58.3L24 17.35a2 2 0 0 0-2.17.41l-2.17 2.15A9.17 9.17 0 0 1 15.45 18L30 3.41 28.59 2 2 28.59 3.41 30l7-7c3.38 3.18 8.28 5.62 15.39 6h.2a3 3 0 0 0 3-3v-5.28a2 2 0 0 0-1.23-1.86zM27 26v.06a1 1 0 0 1-1.06.94c-6.51-.37-11-2.54-14.11-5.42L14 19.44A10.77 10.77 0 0 0 19.88 22l.48.06 2.87-2.85L27 20.72z"}),props.children);});var PhoneOff16=/*#__PURE__*/React.forwardRef(function PhoneOff16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M9.19 18.56A25.66 25.66 0 0 1 5 6.08V6a1 1 0 0 1 1-1h5.28l1.5 3.77-2.84 2.87.06.48a13 13 0 0 0 1.46 4.17l1.46-1.46a9.34 9.34 0 0 1-.84-2.52l2.13-2.15A2 2 0 0 0 14.65 8l-1.52-3.74A2 2 0 0 0 11.27 3H5.76A3 3 0 0 0 3 6.23 28 28 0 0 0 7.79 20zm18.58.3L24 17.35a2 2 0 0 0-2.17.41l-2.17 2.15A9.17 9.17 0 0 1 15.45 18L30 3.41 28.59 2 2 28.59 3.41 30l7-7c3.38 3.18 8.28 5.62 15.39 6h.2a3 3 0 0 0 3-3v-5.28a2 2 0 0 0-1.23-1.86zM27 26v.06a1 1 0 0 1-1.06.94c-6.51-.37-11-2.54-14.11-5.42L14 19.44A10.77 10.77 0 0 0 19.88 22l.48.06 2.87-2.85L27 20.72z"}),props.children);});var Phone32=/*#__PURE__*/React.forwardRef(function Phone32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 29h-.17C6.18 27.87 3.39 11.29 3 6.23A3 3 0 0 1 5.76 3h5.51a2 2 0 0 1 1.86 1.26L14.65 8a2 2 0 0 1-.44 2.16l-2.13 2.15a9.37 9.37 0 0 0 7.58 7.6l2.17-2.15a2 2 0 0 1 2.17-.41l3.77 1.51A2 2 0 0 1 29 20.72V26a3 3 0 0 1-3 3zM6 5a1 1 0 0 0-1 1v.08C5.46 12 8.41 26 25.94 27a1 1 0 0 0 1.06-.94v-5.34l-3.77-1.51-2.87 2.85-.48-.06c-8.7-1.09-9.88-9.79-9.88-9.88l-.06-.48 2.84-2.87L11.28 5z"}),props.children);});var Phone24=/*#__PURE__*/React.forwardRef(function Phone24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 29h-.17C6.18 27.87 3.39 11.29 3 6.23A3 3 0 0 1 5.76 3h5.51a2 2 0 0 1 1.86 1.26L14.65 8a2 2 0 0 1-.44 2.16l-2.13 2.15a9.37 9.37 0 0 0 7.58 7.6l2.17-2.15a2 2 0 0 1 2.17-.41l3.77 1.51A2 2 0 0 1 29 20.72V26a3 3 0 0 1-3 3zM6 5a1 1 0 0 0-1 1v.08C5.46 12 8.41 26 25.94 27a1 1 0 0 0 1.06-.94v-5.34l-3.77-1.51-2.87 2.85-.48-.06c-8.7-1.09-9.88-9.79-9.88-9.88l-.06-.48 2.84-2.87L11.28 5z"}),props.children);});var Phone20=/*#__PURE__*/React.forwardRef(function Phone20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 29h-.17C6.18 27.87 3.39 11.29 3 6.23A3 3 0 0 1 5.76 3h5.51a2 2 0 0 1 1.86 1.26L14.65 8a2 2 0 0 1-.44 2.16l-2.13 2.15a9.37 9.37 0 0 0 7.58 7.6l2.17-2.15a2 2 0 0 1 2.17-.41l3.77 1.51A2 2 0 0 1 29 20.72V26a3 3 0 0 1-3 3zM6 5a1 1 0 0 0-1 1v.08C5.46 12 8.41 26 25.94 27a1 1 0 0 0 1.06-.94v-5.34l-3.77-1.51-2.87 2.85-.48-.06c-8.7-1.09-9.88-9.79-9.88-9.88l-.06-.48 2.84-2.87L11.28 5z"}),props.children);});var Phone16=/*#__PURE__*/React.forwardRef(function Phone16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26 29h-.17C6.18 27.87 3.39 11.29 3 6.23A3 3 0 0 1 5.76 3h5.51a2 2 0 0 1 1.86 1.26L14.65 8a2 2 0 0 1-.44 2.16l-2.13 2.15a9.37 9.37 0 0 0 7.58 7.6l2.17-2.15a2 2 0 0 1 2.17-.41l3.77 1.51A2 2 0 0 1 29 20.72V26a3 3 0 0 1-3 3zM6 5a1 1 0 0 0-1 1v.08C5.46 12 8.41 26 25.94 27a1 1 0 0 0 1.06-.94v-5.34l-3.77-1.51-2.87 2.85-.48-.06c-8.7-1.09-9.88-9.79-9.88-9.88l-.06-.48 2.84-2.87L11.28 5z"}),props.children);});var PillsAdd32=/*#__PURE__*/React.forwardRef(function PillsAdd32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22 14a7.94 7.94 0 0 0-4 1.083V9A7 7 0 0 0 4 9v14a6.986 6.986 0 0 0 12.276 4.577A7.997 7.997 0 1 0 22 14zM11 4a5.006 5.006 0 0 1 5 5v6H6V9a5.006 5.006 0 0 1 5-5zm0 24a5.006 5.006 0 0 1-5-5v-6h9.765a7.956 7.956 0 0 0-.724 8.932A5.015 5.015 0 0 1 11 28zm11 0a6 6 0 1 1 6-6 6.007 6.007 0 0 1-6 6z"}),React.createElement("path",{d:"M25 21h-2v-2h-2v2h-2v2h2v2h2v-2h2v-2z"}),props.children);});var PillsAdd24=/*#__PURE__*/React.forwardRef(function PillsAdd24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22 14a7.94 7.94 0 0 0-4 1.083V9A7 7 0 0 0 4 9v14a6.986 6.986 0 0 0 12.276 4.577A7.997 7.997 0 1 0 22 14zM11 4a5.006 5.006 0 0 1 5 5v6H6V9a5.006 5.006 0 0 1 5-5zm0 24a5.006 5.006 0 0 1-5-5v-6h9.765a7.956 7.956 0 0 0-.724 8.932A5.015 5.015 0 0 1 11 28zm11 0a6 6 0 1 1 6-6 6.007 6.007 0 0 1-6 6z"}),React.createElement("path",{d:"M25 21h-2v-2h-2v2h-2v2h2v2h2v-2h2v-2z"}),props.children);});var PillsAdd20=/*#__PURE__*/React.forwardRef(function PillsAdd20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22 14a7.94 7.94 0 0 0-4 1.083V9A7 7 0 0 0 4 9v14a6.986 6.986 0 0 0 12.276 4.577A7.997 7.997 0 1 0 22 14zM11 4a5.006 5.006 0 0 1 5 5v6H6V9a5.006 5.006 0 0 1 5-5zm0 24a5.006 5.006 0 0 1-5-5v-6h9.765a7.956 7.956 0 0 0-.724 8.932A5.015 5.015 0 0 1 11 28zm11 0a6 6 0 1 1 6-6 6.007 6.007 0 0 1-6 6z"}),React.createElement("path",{d:"M25 21h-2v-2h-2v2h-2v2h2v2h2v-2h2v-2z"}),props.children);});var PillsAdd16=/*#__PURE__*/React.forwardRef(function PillsAdd16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22 14a7.94 7.94 0 0 0-4 1.083V9A7 7 0 0 0 4 9v14a6.986 6.986 0 0 0 12.276 4.577A7.997 7.997 0 1 0 22 14zM11 4a5.006 5.006 0 0 1 5 5v6H6V9a5.006 5.006 0 0 1 5-5zm0 24a5.006 5.006 0 0 1-5-5v-6h9.765a7.956 7.956 0 0 0-.724 8.932A5.015 5.015 0 0 1 11 28zm11 0a6 6 0 1 1 6-6 6.007 6.007 0 0 1-6 6z"}),React.createElement("path",{d:"M25 21h-2v-2h-2v2h-2v2h2v2h2v-2h2v-2z"}),props.children);});var PillsSubtract32=/*#__PURE__*/React.forwardRef(function PillsSubtract32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22 14a7.94 7.94 0 0 0-4 1.083V9A7 7 0 0 0 4 9v14a6.986 6.986 0 0 0 12.276 4.577A7.997 7.997 0 1 0 22 14zM11 4a5.006 5.006 0 0 1 5 5v6H6V9a5.006 5.006 0 0 1 5-5zm0 24a5.006 5.006 0 0 1-5-5v-6h9.765a7.956 7.956 0 0 0-.724 8.932A5.015 5.015 0 0 1 11 28zm11 0a6 6 0 1 1 6-6 6.007 6.007 0 0 1-6 6z"}),React.createElement("path",{d:"M19 21h6v2h-6z"}),props.children);});var PillsSubtract24=/*#__PURE__*/React.forwardRef(function PillsSubtract24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22 14a7.94 7.94 0 0 0-4 1.083V9A7 7 0 0 0 4 9v14a6.986 6.986 0 0 0 12.276 4.577A7.997 7.997 0 1 0 22 14zM11 4a5.006 5.006 0 0 1 5 5v6H6V9a5.006 5.006 0 0 1 5-5zm0 24a5.006 5.006 0 0 1-5-5v-6h9.765a7.956 7.956 0 0 0-.724 8.932A5.015 5.015 0 0 1 11 28zm11 0a6 6 0 1 1 6-6 6.007 6.007 0 0 1-6 6z"}),React.createElement("path",{d:"M19 21h6v2h-6z"}),props.children);});var PillsSubtract20=/*#__PURE__*/React.forwardRef(function PillsSubtract20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22 14a7.94 7.94 0 0 0-4 1.083V9A7 7 0 0 0 4 9v14a6.986 6.986 0 0 0 12.276 4.577A7.997 7.997 0 1 0 22 14zM11 4a5.006 5.006 0 0 1 5 5v6H6V9a5.006 5.006 0 0 1 5-5zm0 24a5.006 5.006 0 0 1-5-5v-6h9.765a7.956 7.956 0 0 0-.724 8.932A5.015 5.015 0 0 1 11 28zm11 0a6 6 0 1 1 6-6 6.007 6.007 0 0 1-6 6z"}),React.createElement("path",{d:"M19 21h6v2h-6z"}),props.children);});var PillsSubtract16=/*#__PURE__*/React.forwardRef(function PillsSubtract16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22 14a7.94 7.94 0 0 0-4 1.083V9A7 7 0 0 0 4 9v14a6.986 6.986 0 0 0 12.276 4.577A7.997 7.997 0 1 0 22 14zM11 4a5.006 5.006 0 0 1 5 5v6H6V9a5.006 5.006 0 0 1 5-5zm0 24a5.006 5.006 0 0 1-5-5v-6h9.765a7.956 7.956 0 0 0-.724 8.932A5.015 5.015 0 0 1 11 28zm11 0a6 6 0 1 1 6-6 6.007 6.007 0 0 1-6 6z"}),React.createElement("path",{d:"M19 21h6v2h-6z"}),props.children);});var Pills32=/*#__PURE__*/React.forwardRef(function Pills32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22 14a7.94 7.94 0 0 0-4 1.083V9A7 7 0 0 0 4 9v14a6.999 6.999 0 0 0 12.286 4.588A7.997 7.997 0 1 0 22 14zm0 2a6.005 6.005 0 0 1 5.91 5H16.09A6.005 6.005 0 0 1 22 16zM6 9a5 5 0 0 1 10 0v6H6zm5 19a5.006 5.006 0 0 1-5-5v-6h9.765a7.957 7.957 0 0 0-.724 8.931A4.989 4.989 0 0 1 11 28zm11 0a6.005 6.005 0 0 1-5.91-5h11.82A6.005 6.005 0 0 1 22 28z"}),props.children);});var Pills24=/*#__PURE__*/React.forwardRef(function Pills24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22 14a7.94 7.94 0 0 0-4 1.083V9A7 7 0 0 0 4 9v14a6.999 6.999 0 0 0 12.286 4.588A7.997 7.997 0 1 0 22 14zm0 2a6.005 6.005 0 0 1 5.91 5H16.09A6.005 6.005 0 0 1 22 16zM6 9a5 5 0 0 1 10 0v6H6zm5 19a5.006 5.006 0 0 1-5-5v-6h9.765a7.957 7.957 0 0 0-.724 8.931A4.989 4.989 0 0 1 11 28zm11 0a6.005 6.005 0 0 1-5.91-5h11.82A6.005 6.005 0 0 1 22 28z"}),props.children);});var Pills20=/*#__PURE__*/React.forwardRef(function Pills20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22 14a7.94 7.94 0 0 0-4 1.083V9A7 7 0 0 0 4 9v14a6.999 6.999 0 0 0 12.286 4.588A7.997 7.997 0 1 0 22 14zm0 2a6.005 6.005 0 0 1 5.91 5H16.09A6.005 6.005 0 0 1 22 16zM6 9a5 5 0 0 1 10 0v6H6zm5 19a5.006 5.006 0 0 1-5-5v-6h9.765a7.957 7.957 0 0 0-.724 8.931A4.989 4.989 0 0 1 11 28zm11 0a6.005 6.005 0 0 1-5.91-5h11.82A6.005 6.005 0 0 1 22 28z"}),props.children);});var Pills16=/*#__PURE__*/React.forwardRef(function Pills16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22 14a7.94 7.94 0 0 0-4 1.083V9A7 7 0 0 0 4 9v14a6.999 6.999 0 0 0 12.286 4.588A7.997 7.997 0 1 0 22 14zm0 2a6.005 6.005 0 0 1 5.91 5H16.09A6.005 6.005 0 0 1 22 16zM6 9a5 5 0 0 1 10 0v6H6zm5 19a5.006 5.006 0 0 1-5-5v-6h9.765a7.957 7.957 0 0 0-.724 8.931A4.989 4.989 0 0 1 11 28zm11 0a6.005 6.005 0 0 1-5.91-5h11.82A6.005 6.005 0 0 1 22 28z"}),props.children);});var Pin32=/*#__PURE__*/React.forwardRef(function Pin32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28.59 13.31L30 11.9 20 2l-1.31 1.42 1.18 1.18-11.49 9.72-1.72-1.71L5.25 14l5.66 5.68L2 28.58 3.41 30l8.91-8.91L18 26.75l1.39-1.42-1.71-1.71 9.72-11.49zM16.26 22.2L9.8 15.74 21.29 6 26 10.71z"}),props.children);});var Pin24=/*#__PURE__*/React.forwardRef(function Pin24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28.59 13.31L30 11.9 20 2l-1.31 1.42 1.18 1.18-11.49 9.72-1.72-1.71L5.25 14l5.66 5.68L2 28.58 3.41 30l8.91-8.91L18 26.75l1.39-1.42-1.71-1.71 9.72-11.49zM16.26 22.2L9.8 15.74 21.29 6 26 10.71z"}),props.children);});var Pin20=/*#__PURE__*/React.forwardRef(function Pin20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28.59 13.31L30 11.9 20 2l-1.31 1.42 1.18 1.18-11.49 9.72-1.72-1.71L5.25 14l5.66 5.68L2 28.58 3.41 30l8.91-8.91L18 26.75l1.39-1.42-1.71-1.71 9.72-11.49zM16.26 22.2L9.8 15.74 21.29 6 26 10.71z"}),props.children);});var Pin16=/*#__PURE__*/React.forwardRef(function Pin16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28.59 13.31L30 11.9 20 2l-1.31 1.42 1.18 1.18-11.49 9.72-1.72-1.71L5.25 14l5.66 5.68L2 28.58 3.41 30l8.91-8.91L18 26.75l1.39-1.42-1.71-1.71 9.72-11.49zM16.26 22.2L9.8 15.74 21.29 6 26 10.71z"}),props.children);});var Plane32=/*#__PURE__*/React.forwardRef(function Plane32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.37 14.75L20 10V6a4 4 0 0 0-8 0v4l-9.37 4.75a1 1 0 0 0-.63.93v5a1 1 0 0 0 1 1 1 1 0 0 0 .29-.05L12 18v5l-3.45 1.72a1 1 0 0 0-.55.9V29a1 1 0 0 0 1 1 .9.9 0 0 0 .28 0L16 28l6.72 2a.9.9 0 0 0 .28 0 1 1 0 0 0 1-1v-3.38a1 1 0 0 0-.55-.9L20 23v-5l8.71 3.61a1 1 0 0 0 .29.05 1 1 0 0 0 1-1v-5a1 1 0 0 0-.63-.91zM28 19.15L18 15v9.24l4 2v1.43l-6-1.75-6 1.75v-1.43l4-2V15L4 19.15V16.3l10-5.07V6a2 2 0 0 1 4 0v5.23l10 5.07z"}),props.children);});var Plane24=/*#__PURE__*/React.forwardRef(function Plane24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.37 14.75L20 10V6a4 4 0 0 0-8 0v4l-9.37 4.75a1 1 0 0 0-.63.93v5a1 1 0 0 0 1 1 1 1 0 0 0 .29-.05L12 18v5l-3.45 1.72a1 1 0 0 0-.55.9V29a1 1 0 0 0 1 1 .9.9 0 0 0 .28 0L16 28l6.72 2a.9.9 0 0 0 .28 0 1 1 0 0 0 1-1v-3.38a1 1 0 0 0-.55-.9L20 23v-5l8.71 3.61a1 1 0 0 0 .29.05 1 1 0 0 0 1-1v-5a1 1 0 0 0-.63-.91zM28 19.15L18 15v9.24l4 2v1.43l-6-1.75-6 1.75v-1.43l4-2V15L4 19.15V16.3l10-5.07V6a2 2 0 0 1 4 0v5.23l10 5.07z"}),props.children);});var Plane20=/*#__PURE__*/React.forwardRef(function Plane20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.37 14.75L20 10V6a4 4 0 0 0-8 0v4l-9.37 4.75a1 1 0 0 0-.63.93v5a1 1 0 0 0 1 1 1 1 0 0 0 .29-.05L12 18v5l-3.45 1.72a1 1 0 0 0-.55.9V29a1 1 0 0 0 1 1 .9.9 0 0 0 .28 0L16 28l6.72 2a.9.9 0 0 0 .28 0 1 1 0 0 0 1-1v-3.38a1 1 0 0 0-.55-.9L20 23v-5l8.71 3.61a1 1 0 0 0 .29.05 1 1 0 0 0 1-1v-5a1 1 0 0 0-.63-.91zM28 19.15L18 15v9.24l4 2v1.43l-6-1.75-6 1.75v-1.43l4-2V15L4 19.15V16.3l10-5.07V6a2 2 0 0 1 4 0v5.23l10 5.07z"}),props.children);});var Plane16=/*#__PURE__*/React.forwardRef(function Plane16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.37 14.75L20 10V6a4 4 0 0 0-8 0v4l-9.37 4.75a1 1 0 0 0-.63.93v5a1 1 0 0 0 1 1 1 1 0 0 0 .29-.05L12 18v5l-3.45 1.72a1 1 0 0 0-.55.9V29a1 1 0 0 0 1 1 .9.9 0 0 0 .28 0L16 28l6.72 2a.9.9 0 0 0 .28 0 1 1 0 0 0 1-1v-3.38a1 1 0 0 0-.55-.9L20 23v-5l8.71 3.61a1 1 0 0 0 .29.05 1 1 0 0 0 1-1v-5a1 1 0 0 0-.63-.91zM28 19.15L18 15v9.24l4 2v1.43l-6-1.75-6 1.75v-1.43l4-2V15L4 19.15V16.3l10-5.07V6a2 2 0 0 1 4 0v5.23l10 5.07z"}),props.children);});var PlayFilledAlt32=/*#__PURE__*/React.forwardRef(function PlayFilledAlt32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7 28a1 1 0 0 1-1-1V5a1 1 0 0 1 1.501-.865l19 11a1 1 0 0 1 0 1.73l-19 11A.998.998 0 0 1 7 28z"}),props.children);});var PlayFilledAlt24=/*#__PURE__*/React.forwardRef(function PlayFilledAlt24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7 28a1 1 0 0 1-1-1V5a1 1 0 0 1 1.501-.865l19 11a1 1 0 0 1 0 1.73l-19 11A.998.998 0 0 1 7 28z"}),props.children);});var PlayFilledAlt20=/*#__PURE__*/React.forwardRef(function PlayFilledAlt20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7 28a1 1 0 0 1-1-1V5a1 1 0 0 1 1.501-.865l19 11a1 1 0 0 1 0 1.73l-19 11A.998.998 0 0 1 7 28z"}),props.children);});var PlayFilledAlt16=/*#__PURE__*/React.forwardRef(function PlayFilledAlt16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7 28a1 1 0 0 1-1-1V5a1 1 0 0 1 1.501-.865l19 11a1 1 0 0 1 0 1.73l-19 11A.998.998 0 0 1 7 28z"}),props.children);});var PlayFilled32=/*#__PURE__*/React.forwardRef(function PlayFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm7.48 14.88l-11 6a1 1 0 0 1-1 0A1 1 0 0 1 11 22V10a1 1 0 0 1 .49-.86 1 1 0 0 1 1 0l11 6a1 1 0 0 1 0 1.76z"}),props.children);});var PlayFilled24=/*#__PURE__*/React.forwardRef(function PlayFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm7.48 14.88l-11 6a1 1 0 0 1-1 0A1 1 0 0 1 11 22V10a1 1 0 0 1 .49-.86 1 1 0 0 1 1 0l11 6a1 1 0 0 1 0 1.76z"}),props.children);});var PlayFilled20=/*#__PURE__*/React.forwardRef(function PlayFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm7.48 14.88l-11 6a1 1 0 0 1-1 0A1 1 0 0 1 11 22V10a1 1 0 0 1 .49-.86 1 1 0 0 1 1 0l11 6a1 1 0 0 1 0 1.76z"}),props.children);});var PlayOutlineFilled32=/*#__PURE__*/React.forwardRef(function PlayOutlineFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm7.48 14.88l-11 6a1 1 0 0 1-1 0A1 1 0 0 1 11 22V10a1 1 0 0 1 .49-.86 1 1 0 0 1 1 0l11 6a1 1 0 0 1 0 1.76z"}),React.createElement("path",{d:"M13 20.32L20.91 16 13 11.69v8.63z"}),props.children);});var PlayOutlineFilled24=/*#__PURE__*/React.forwardRef(function PlayOutlineFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm7.48 14.88l-11 6a1 1 0 0 1-1 0A1 1 0 0 1 11 22V10a1 1 0 0 1 .49-.86 1 1 0 0 1 1 0l11 6a1 1 0 0 1 0 1.76z"}),React.createElement("path",{d:"M13 20.32L20.91 16 13 11.69v8.63z"}),props.children);});var PlayOutlineFilled20=/*#__PURE__*/React.forwardRef(function PlayOutlineFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm7.48 14.88l-11 6a1 1 0 0 1-1 0A1 1 0 0 1 11 22V10a1 1 0 0 1 .49-.86 1 1 0 0 1 1 0l11 6a1 1 0 0 1 0 1.76z"}),React.createElement("path",{d:"M13 20.32L20.91 16 13 11.69v8.63z"}),props.children);});var PlayOutline32=/*#__PURE__*/React.forwardRef(function PlayOutline32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 4A12 12 0 1 1 4 16 12 12 0 0 1 16 4m0-2a14 14 0 1 0 14 14A14 14 0 0 0 16 2z"}),React.createElement("path",{d:"M12 23a1 1 0 0 1-.51-.14A1 1 0 0 1 11 22V10a1 1 0 0 1 .49-.86 1 1 0 0 1 1 0l11 6a1 1 0 0 1 0 1.76l-11 6a1 1 0 0 1-.49.1zm1-11.32v8.64L20.91 16z"}),props.children);});var PlayOutline24=/*#__PURE__*/React.forwardRef(function PlayOutline24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 4A12 12 0 1 1 4 16 12 12 0 0 1 16 4m0-2a14 14 0 1 0 14 14A14 14 0 0 0 16 2z"}),React.createElement("path",{d:"M12 23a1 1 0 0 1-.51-.14A1 1 0 0 1 11 22V10a1 1 0 0 1 .49-.86 1 1 0 0 1 1 0l11 6a1 1 0 0 1 0 1.76l-11 6a1 1 0 0 1-.49.1zm1-11.32v8.64L20.91 16z"}),props.children);});var PlayOutline20=/*#__PURE__*/React.forwardRef(function PlayOutline20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 4A12 12 0 1 1 4 16 12 12 0 0 1 16 4m0-2a14 14 0 1 0 14 14A14 14 0 0 0 16 2z"}),React.createElement("path",{d:"M12 23a1 1 0 0 1-.51-.14A1 1 0 0 1 11 22V10a1 1 0 0 1 .49-.86 1 1 0 0 1 1 0l11 6a1 1 0 0 1 0 1.76l-11 6a1 1 0 0 1-.49.1zm1-11.32v8.64L20.91 16z"}),props.children);});var Play32=/*#__PURE__*/React.forwardRef(function Play32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7 28a1 1 0 0 1-1-1V5a1 1 0 0 1 .5-.87 1 1 0 0 1 1 0l19 11a1 1 0 0 1 0 1.74l-19 11A1 1 0 0 1 7 28zM8 6.73v18.54L24 16z"}),props.children);});var Play24=/*#__PURE__*/React.forwardRef(function Play24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7 28a1 1 0 0 1-1-1V5a1 1 0 0 1 .5-.87 1 1 0 0 1 1 0l19 11a1 1 0 0 1 0 1.74l-19 11A1 1 0 0 1 7 28zM8 6.73v18.54L24 16z"}),props.children);});var Play20=/*#__PURE__*/React.forwardRef(function Play20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7 28a1 1 0 0 1-1-1V5a1 1 0 0 1 .5-.87 1 1 0 0 1 1 0l19 11a1 1 0 0 1 0 1.74l-19 11A1 1 0 0 1 7 28zM8 6.73v18.54L24 16z"}),props.children);});var Playlist32=/*#__PURE__*/React.forwardRef(function Playlist32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4 6h18v2H4zm0 6h18v2H4zm0 6h12v2H4zm17 0l7 5-7 5V18z"}),props.children);});var Playlist24=/*#__PURE__*/React.forwardRef(function Playlist24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4 6h18v2H4zm0 6h18v2H4zm0 6h12v2H4zm17 0l7 5-7 5V18z"}),props.children);});var Playlist20=/*#__PURE__*/React.forwardRef(function Playlist20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4 6h18v2H4zm0 6h18v2H4zm0 6h12v2H4zm17 0l7 5-7 5V18z"}),props.children);});var Playlist16=/*#__PURE__*/React.forwardRef(function Playlist16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4 6h18v2H4zm0 6h18v2H4zm0 6h12v2H4zm17 0l7 5-7 5V18z"}),props.children);});var Popup32=/*#__PURE__*/React.forwardRef(function Popup32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 4H10a2.006 2.006 0 0 0-2 2v14a2.006 2.006 0 0 0 2 2h18a2.006 2.006 0 0 0 2-2V6a2.006 2.006 0 0 0-2-2zm0 16H10V6h18z"}),React.createElement("path",{d:"M18 26H4V16h2v-2H4a2.006 2.006 0 0 0-2 2v10a2.006 2.006 0 0 0 2 2h14a2.006 2.006 0 0 0 2-2v-2h-2z"}),props.children);});var Popup24=/*#__PURE__*/React.forwardRef(function Popup24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 4H10a2.006 2.006 0 0 0-2 2v14a2.006 2.006 0 0 0 2 2h18a2.006 2.006 0 0 0 2-2V6a2.006 2.006 0 0 0-2-2zm0 16H10V6h18z"}),React.createElement("path",{d:"M18 26H4V16h2v-2H4a2.006 2.006 0 0 0-2 2v10a2.006 2.006 0 0 0 2 2h14a2.006 2.006 0 0 0 2-2v-2h-2z"}),props.children);});var Popup20=/*#__PURE__*/React.forwardRef(function Popup20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 4H10a2.006 2.006 0 0 0-2 2v14a2.006 2.006 0 0 0 2 2h18a2.006 2.006 0 0 0 2-2V6a2.006 2.006 0 0 0-2-2zm0 16H10V6h18z"}),React.createElement("path",{d:"M18 26H4V16h2v-2H4a2.006 2.006 0 0 0-2 2v10a2.006 2.006 0 0 0 2 2h14a2.006 2.006 0 0 0 2-2v-2h-2z"}),props.children);});var Popup16=/*#__PURE__*/React.forwardRef(function Popup16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 4H10a2.006 2.006 0 0 0-2 2v14a2.006 2.006 0 0 0 2 2h18a2.006 2.006 0 0 0 2-2V6a2.006 2.006 0 0 0-2-2zm0 16H10V6h18z"}),React.createElement("path",{d:"M18 26H4V16h2v-2H4a2.006 2.006 0 0 0-2 2v10a2.006 2.006 0 0 0 2 2h14a2.006 2.006 0 0 0 2-2v-2h-2z"}),props.children);});var Portfolio32=/*#__PURE__*/React.forwardRef(function Portfolio32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 10h-6V6a2 2 0 0 0-2-2h-8a2 2 0 0 0-2 2v4H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V12a2 2 0 0 0-2-2zM12 6h8v4h-8zM4 26V12h24v14z"}),props.children);});var Portfolio24=/*#__PURE__*/React.forwardRef(function Portfolio24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 10h-6V6a2 2 0 0 0-2-2h-8a2 2 0 0 0-2 2v4H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V12a2 2 0 0 0-2-2zM12 6h8v4h-8zM4 26V12h24v14z"}),props.children);});var Portfolio20=/*#__PURE__*/React.forwardRef(function Portfolio20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 10h-6V6a2 2 0 0 0-2-2h-8a2 2 0 0 0-2 2v4H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V12a2 2 0 0 0-2-2zM12 6h8v4h-8zM4 26V12h24v14z"}),props.children);});var Portfolio16=/*#__PURE__*/React.forwardRef(function Portfolio16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 10h-6V6a2 2 0 0 0-2-2h-8a2 2 0 0 0-2 2v4H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V12a2 2 0 0 0-2-2zM12 6h8v4h-8zM4 26V12h24v14z"}),props.children);});var Power32=/*#__PURE__*/React.forwardRef(function Power32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22.5 5.74l-1 1.73a11 11 0 1 1-11 0l-1-1.73a13 13 0 1 0 13 0z"}),React.createElement("path",{d:"M15 2h2v14h-2z"}),props.children);});var Power24=/*#__PURE__*/React.forwardRef(function Power24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22.5 5.74l-1 1.73a11 11 0 1 1-11 0l-1-1.73a13 13 0 1 0 13 0z"}),React.createElement("path",{d:"M15 2h2v14h-2z"}),props.children);});var Power20=/*#__PURE__*/React.forwardRef(function Power20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22.5 5.74l-1 1.73a11 11 0 1 1-11 0l-1-1.73a13 13 0 1 0 13 0z"}),React.createElement("path",{d:"M15 2h2v14h-2z"}),props.children);});var PresentationFile32=/*#__PURE__*/React.forwardRef(function PresentationFile32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 10h2v8h-2zm5 4h2v4h-2zm-10-2h2v6h-2z"}),React.createElement("path",{d:"M25 4h-8V2h-2v2H7a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h8v6h-4v2h10v-2h-4v-6h8a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm0 16H7V6h18z"}),props.children);});var PresentationFile24=/*#__PURE__*/React.forwardRef(function PresentationFile24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 10h2v8h-2zm5 4h2v4h-2zm-10-2h2v6h-2z"}),React.createElement("path",{d:"M25 4h-8V2h-2v2H7a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h8v6h-4v2h10v-2h-4v-6h8a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm0 16H7V6h18z"}),props.children);});var PresentationFile20=/*#__PURE__*/React.forwardRef(function PresentationFile20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 10h2v8h-2zm5 4h2v4h-2zm-10-2h2v6h-2z"}),React.createElement("path",{d:"M25 4h-8V2h-2v2H7a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h8v6h-4v2h10v-2h-4v-6h8a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm0 16H7V6h18z"}),props.children);});var PresentationFile16=/*#__PURE__*/React.forwardRef(function PresentationFile16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15 10h2v8h-2zm5 4h2v4h-2zm-10-2h2v6h-2z"}),React.createElement("path",{d:"M25 4h-8V2h-2v2H7a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h8v6h-4v2h10v-2h-4v-6h8a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zm0 16H7V6h18z"}),props.children);});var Printer32=/*#__PURE__*/React.forwardRef(function Printer32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 9h-3V3H7v6H4a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h3v6h18v-6h3a2 2 0 0 0 2-2V11a2 2 0 0 0-2-2zM9 5h14v4H9zm14 22H9V17h14zm5-6h-3v-6H7v6H4V11h24z"}),props.children);});var Printer24=/*#__PURE__*/React.forwardRef(function Printer24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 9h-3V3H7v6H4a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h3v6h18v-6h3a2 2 0 0 0 2-2V11a2 2 0 0 0-2-2zM9 5h14v4H9zm14 22H9V17h14zm5-6h-3v-6H7v6H4V11h24z"}),props.children);});var Printer20=/*#__PURE__*/React.forwardRef(function Printer20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 9h-3V3H7v6H4a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h3v6h18v-6h3a2 2 0 0 0 2-2V11a2 2 0 0 0-2-2zM9 5h14v4H9zm14 22H9V17h14zm5-6h-3v-6H7v6H4V11h24z"}),props.children);});var Printer16=/*#__PURE__*/React.forwardRef(function Printer16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 9h-3V3H7v6H4a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h3v6h18v-6h3a2 2 0 0 0 2-2V11a2 2 0 0 0-2-2zM9 5h14v4H9zm14 22H9V17h14zm5-6h-3v-6H7v6H4V11h24z"}),props.children);});var Purchase32=/*#__PURE__*/React.forwardRef(function Purchase32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 6H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zm0 2v3H4V8zM4 24V13h24v11z"}),React.createElement("path",{d:"M6 20h10v2H6z"}),props.children);});var Purchase24=/*#__PURE__*/React.forwardRef(function Purchase24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 6H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zm0 2v3H4V8zM4 24V13h24v11z"}),React.createElement("path",{d:"M6 20h10v2H6z"}),props.children);});var Purchase20=/*#__PURE__*/React.forwardRef(function Purchase20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 6H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zm0 2v3H4V8zM4 24V13h24v11z"}),React.createElement("path",{d:"M6 20h10v2H6z"}),props.children);});var Purchase16=/*#__PURE__*/React.forwardRef(function Purchase16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 6H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zm0 2v3H4V8zM4 24V13h24v11z"}),React.createElement("path",{d:"M6 20h10v2H6z"}),props.children);});var QueryQueue32=/*#__PURE__*/React.forwardRef(function QueryQueue32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 6h18v2H10zm0 6h18v2H10zm5 6h13v2H15zm-5 6h18v2H10zM4 14l7 5-7 5V14z"}),props.children);});var QueryQueue24=/*#__PURE__*/React.forwardRef(function QueryQueue24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 6h18v2H10zm0 6h18v2H10zm5 6h13v2H15zm-5 6h18v2H10zM4 14l7 5-7 5V14z"}),props.children);});var QueryQueue20=/*#__PURE__*/React.forwardRef(function QueryQueue20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 6h18v2H10zm0 6h18v2H10zm5 6h13v2H15zm-5 6h18v2H10zM4 14l7 5-7 5V14z"}),props.children);});var QueryQueue16=/*#__PURE__*/React.forwardRef(function QueryQueue16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10 6h18v2H10zm0 6h18v2H10zm5 6h13v2H15zm-5 6h18v2H10zM4 14l7 5-7 5V14z"}),props.children);});var Quotes32=/*#__PURE__*/React.forwardRef(function Quotes32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 15H6.11A9 9 0 0 1 10 8.86l1.79-1.2L10.69 6 8.9 7.2A11 11 0 0 0 4 16.35V23a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2zm14 0h-5.89A9 9 0 0 1 24 8.86l1.79-1.2L24.7 6l-1.8 1.2a11 11 0 0 0-4.9 9.15V23a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2z"}),props.children);});var Quotes24=/*#__PURE__*/React.forwardRef(function Quotes24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 15H6.11A9 9 0 0 1 10 8.86l1.79-1.2L10.69 6 8.9 7.2A11 11 0 0 0 4 16.35V23a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2zm14 0h-5.89A9 9 0 0 1 24 8.86l1.79-1.2L24.7 6l-1.8 1.2a11 11 0 0 0-4.9 9.15V23a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2z"}),props.children);});var Quotes20=/*#__PURE__*/React.forwardRef(function Quotes20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 15H6.11A9 9 0 0 1 10 8.86l1.79-1.2L10.69 6 8.9 7.2A11 11 0 0 0 4 16.35V23a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2zm14 0h-5.89A9 9 0 0 1 24 8.86l1.79-1.2L24.7 6l-1.8 1.2a11 11 0 0 0-4.9 9.15V23a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2z"}),props.children);});var Quotes16=/*#__PURE__*/React.forwardRef(function Quotes16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12 15H6.11A9 9 0 0 1 10 8.86l1.79-1.2L10.69 6 8.9 7.2A11 11 0 0 0 4 16.35V23a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2zm14 0h-5.89A9 9 0 0 1 24 8.86l1.79-1.2L24.7 6l-1.8 1.2a11 11 0 0 0-4.9 9.15V23a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2z"}),props.children);});var RadioButtonChecked32=/*#__PURE__*/React.forwardRef(function RadioButtonChecked32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 26a12 12 0 1 1 12-12 12 12 0 0 1-12 12z"}),React.createElement("path",{d:"M16 10a6 6 0 1 0 6 6 6 6 0 0 0-6-6z"}),props.children);});var RadioButtonChecked24=/*#__PURE__*/React.forwardRef(function RadioButtonChecked24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 26a12 12 0 1 1 12-12 12 12 0 0 1-12 12z"}),React.createElement("path",{d:"M16 10a6 6 0 1 0 6 6 6 6 0 0 0-6-6z"}),props.children);});var RadioButtonChecked20=/*#__PURE__*/React.forwardRef(function RadioButtonChecked20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 26a12 12 0 1 1 12-12 12 12 0 0 1-12 12z"}),React.createElement("path",{d:"M16 10a6 6 0 1 0 6 6 6 6 0 0 0-6-6z"}),props.children);});var RadioButtonChecked16=/*#__PURE__*/React.forwardRef(function RadioButtonChecked16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 26a12 12 0 1 1 12-12 12 12 0 0 1-12 12z"}),React.createElement("path",{d:"M16 10a6 6 0 1 0 6 6 6 6 0 0 0-6-6z"}),props.children);});var RadioButton32=/*#__PURE__*/React.forwardRef(function RadioButton32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 26a12 12 0 1 1 12-12 12 12 0 0 1-12 12z"}),props.children);});var RadioButton24=/*#__PURE__*/React.forwardRef(function RadioButton24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 26a12 12 0 1 1 12-12 12 12 0 0 1-12 12z"}),props.children);});var RadioButton20=/*#__PURE__*/React.forwardRef(function RadioButton20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 26a12 12 0 1 1 12-12 12 12 0 0 1-12 12z"}),props.children);});var RadioButton16=/*#__PURE__*/React.forwardRef(function RadioButton16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm0 26a12 12 0 1 1 12-12 12 12 0 0 1-12 12z"}),props.children);});var Radio32=/*#__PURE__*/React.forwardRef(function Radio32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 10h-4V2h-2v8h-9V8h-2v2H8V8H6v2H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V12a2 2 0 0 0-2-2zM4 28V12h24v16z"}),React.createElement("path",{d:"M10 26a4 4 0 1 1 4-4 4 4 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2 2 0 0 0-2-2zm-3-6h6v2H7zm10 2h9v2h-9zm0 4h9v2h-9zm0 4h9v2h-9z"}),props.children);});var Radio24=/*#__PURE__*/React.forwardRef(function Radio24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 10h-4V2h-2v8h-9V8h-2v2H8V8H6v2H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V12a2 2 0 0 0-2-2zM4 28V12h24v16z"}),React.createElement("path",{d:"M10 26a4 4 0 1 1 4-4 4 4 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2 2 0 0 0-2-2zm-3-6h6v2H7zm10 2h9v2h-9zm0 4h9v2h-9zm0 4h9v2h-9z"}),props.children);});var Radio20=/*#__PURE__*/React.forwardRef(function Radio20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 10h-4V2h-2v8h-9V8h-2v2H8V8H6v2H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V12a2 2 0 0 0-2-2zM4 28V12h24v16z"}),React.createElement("path",{d:"M10 26a4 4 0 1 1 4-4 4 4 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2 2 0 0 0-2-2zm-3-6h6v2H7zm10 2h9v2h-9zm0 4h9v2h-9zm0 4h9v2h-9z"}),props.children);});var Radio16=/*#__PURE__*/React.forwardRef(function Radio16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28 10h-4V2h-2v8h-9V8h-2v2H8V8H6v2H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V12a2 2 0 0 0-2-2zM4 28V12h24v16z"}),React.createElement("path",{d:"M10 26a4 4 0 1 1 4-4 4 4 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2 2 0 0 0-2-2zm-3-6h6v2H7zm10 2h9v2h-9zm0 4h9v2h-9zm0 4h9v2h-9z"}),props.children);});var Receipt32=/*#__PURE__*/React.forwardRef(function Receipt32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21 16h2v2h-2zM9 16h8v2H9zm12-4h2v2h-2zM9 12h8v2H9zm0-4h14v2H9z"}),React.createElement("path",{d:"M25 2H7a2.002 2.002 0 0 0-2 2v25a1 1 0 0 0 1 1h1a.999.999 0 0 0 .8-.4l2.2-2.933 2.2 2.933a1.035 1.035 0 0 0 1.6 0l2.2-2.933 2.2 2.933a1.035 1.035 0 0 0 1.6 0l2.2-2.933 2.2 2.933a1 1 0 0 0 .8.4h1a1 1 0 0 0 1-1V4a2.002 2.002 0 0 0-2-2zm0 25.333L22.8 24.4a1.035 1.035 0 0 0-1.6 0L19 27.333 16.8 24.4a1.035 1.035 0 0 0-1.6 0L13 27.333 10.8 24.4a1.035 1.035 0 0 0-1.6 0L7 27.333V4h18z"}),props.children);});var Receipt24=/*#__PURE__*/React.forwardRef(function Receipt24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21 16h2v2h-2zM9 16h8v2H9zm12-4h2v2h-2zM9 12h8v2H9zm0-4h14v2H9z"}),React.createElement("path",{d:"M25 2H7a2.002 2.002 0 0 0-2 2v25a1 1 0 0 0 1 1h1a.999.999 0 0 0 .8-.4l2.2-2.933 2.2 2.933a1.035 1.035 0 0 0 1.6 0l2.2-2.933 2.2 2.933a1.035 1.035 0 0 0 1.6 0l2.2-2.933 2.2 2.933a1 1 0 0 0 .8.4h1a1 1 0 0 0 1-1V4a2.002 2.002 0 0 0-2-2zm0 25.333L22.8 24.4a1.035 1.035 0 0 0-1.6 0L19 27.333 16.8 24.4a1.035 1.035 0 0 0-1.6 0L13 27.333 10.8 24.4a1.035 1.035 0 0 0-1.6 0L7 27.333V4h18z"}),props.children);});var Receipt20=/*#__PURE__*/React.forwardRef(function Receipt20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21 16h2v2h-2zM9 16h8v2H9zm12-4h2v2h-2zM9 12h8v2H9zm0-4h14v2H9z"}),React.createElement("path",{d:"M25 2H7a2.002 2.002 0 0 0-2 2v25a1 1 0 0 0 1 1h1a.999.999 0 0 0 .8-.4l2.2-2.933 2.2 2.933a1.035 1.035 0 0 0 1.6 0l2.2-2.933 2.2 2.933a1.035 1.035 0 0 0 1.6 0l2.2-2.933 2.2 2.933a1 1 0 0 0 .8.4h1a1 1 0 0 0 1-1V4a2.002 2.002 0 0 0-2-2zm0 25.333L22.8 24.4a1.035 1.035 0 0 0-1.6 0L19 27.333 16.8 24.4a1.035 1.035 0 0 0-1.6 0L13 27.333 10.8 24.4a1.035 1.035 0 0 0-1.6 0L7 27.333V4h18z"}),props.children);});var Receipt16=/*#__PURE__*/React.forwardRef(function Receipt16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21 16h2v2h-2zM9 16h8v2H9zm12-4h2v2h-2zM9 12h8v2H9zm0-4h14v2H9z"}),React.createElement("path",{d:"M25 2H7a2.002 2.002 0 0 0-2 2v25a1 1 0 0 0 1 1h1a.999.999 0 0 0 .8-.4l2.2-2.933 2.2 2.933a1.035 1.035 0 0 0 1.6 0l2.2-2.933 2.2 2.933a1.035 1.035 0 0 0 1.6 0l2.2-2.933 2.2 2.933a1 1 0 0 0 .8.4h1a1 1 0 0 0 1-1V4a2.002 2.002 0 0 0-2-2zm0 25.333L22.8 24.4a1.035 1.035 0 0 0-1.6 0L19 27.333 16.8 24.4a1.035 1.035 0 0 0-1.6 0L13 27.333 10.8 24.4a1.035 1.035 0 0 0-1.6 0L7 27.333V4h18z"}),props.children);});var RecentlyViewed32=/*#__PURE__*/React.forwardRef(function RecentlyViewed32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20.59 22L15 16.41V7h2v8.58l5 5.01L20.59 22z"}),React.createElement("path",{d:"M16 2A13.94 13.94 0 0 0 6 6.23V2H4v8h8V8H7.08A12 12 0 1 1 4 16H2A14 14 0 1 0 16 2z"}),props.children);});var RecentlyViewed24=/*#__PURE__*/React.forwardRef(function RecentlyVi