import { _ as _objectSpread2, a as _defineProperty } from '../chunk-75bb93d0.js';
import { getAttributes } from '@carbon/icon-helpers';

var virtual_Aperture32 = {
  name: 'Aperture32',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = getAttributes(_objectSpread2({
      width: '32',
      height: '32',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = _defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zm11.84 12.14L22 17.52V5.62a12 12 0 0 1 5.84 8.52zM12 18.68v-5.36L16 11l4 2.31v5.36L16 21zm8-14V11l-9.66-5.58A11.9 11.9 0 0 1 20 4.7zm-11.52 2L14 9.85 4 15.62a12 12 0 0 1 4.48-8.96zM4.16 17.85L10 14.47v11.91a12 12 0 0 1-5.84-8.53zM12 27.3V21l9.67 5.58A11.92 11.92 0 0 1 16 28a12.05 12.05 0 0 1-4-.7zm11.52-2L18 22.14l10-5.77a12 12 0 0 1-4.48 8.97z"
      }
    }), children]);
  }
};

export default virtual_Aperture32;
